use crate::ReportCase;

type Inner = Box<crate::ReportCase>;

#[derive(Debug)]
pub(crate) struct BoxedReport(Option<Inner>);

impl BoxedReport {
    pub(super) fn new() -> Self {
	Self(Some(Box::new(ReportCase::new())))
    }

    pub(super) fn take(&mut self) -> Inner {
	self.0.take().expect("inner ReportCase is None")
    }
}

impl Default for BoxedReport {
    fn default() -> Self {
	Self(Some(Box::default()))
    }
}

impl std::ops::Deref for BoxedReport {
    type Target = Inner;

    fn deref(&self) -> &Self::Target {
	self.0.as_ref().expect("inner ReportCase is NOne")
    }
}

impl std::ops::DerefMut for BoxedReport {
    fn deref_mut(&mut self) -> &mut Self::Target {
	self.0.as_mut().expect("inner ReportCase is NOne")
    }
}
