use super::case::Case;

use crate::engine::plan::plan_rc::PlanRc;

#[derive(Debug)]
pub enum Expect {
    Pass,
    Fail,
    Panic,
    FailOrPanic,
    Ignore,
}

#[derive(Debug)]
pub struct Opts {
    pub name:		String,
    pub description:	Option<String>,
    pub comment:	Option<String>,
    pub expect:		Expect,
    pub do_degrade:	bool,
    pub do_skip:	bool,
    pub is_todo:	bool,
}

impl Opts {
    pub fn new(name: &str) -> Self
    {
	Self {
	    name:		name.to_string(),
	    description:	None,
	    comment:		None,
	    expect:		Expect::Pass,
	    do_degrade:		false,
	    do_skip:		false,
	    is_todo:		false,
	}
    }

    pub fn replace_description(&mut self, desc: &str) {
	self.description = Some(desc.to_string());
    }

    pub fn set_description(mut self, desc: &str) -> Self {
	self.replace_description(desc);
	self
    }

    pub fn replace_comment(&mut self, comment: &str) {
	self.comment = Some(comment.to_string());
    }

    pub fn set_comment(mut self, comment: &str) -> Self {
	self.replace_comment(comment);
	self
    }

    pub fn replace_expect(&mut self, expect: Expect, do_degrade: bool) {
	self.expect = expect;
	self.do_degrade = do_degrade;
    }

    pub fn set_expect(mut self, expect: Expect, do_degrade: bool) -> Self {
	self.replace_expect(expect, do_degrade);
	self
    }

    pub fn replace_skip(&mut self, skip: bool) {
	self.do_skip = skip;
    }

    pub fn set_skip(mut self, skip: bool) -> Self {
	self.replace_skip(skip);
	self
    }

    pub fn replace_todo(&mut self, todo: bool) {
	self.is_todo = todo;
    }

    pub fn set_todo(mut self, todo: bool) -> Self {
	self.replace_todo(todo);
	self
    }

    pub fn create(self, plan: PlanRc)
    {
	Case::create(plan, self)
    }
}
