Library for writing plans for integration and e2e tests.  Results can be given
out in nested [TAP](https://testanything.org/tap-version-13-specification.html),
[junit](https://github.com/junit-team/junit5/blob/main/platform-tests/src/test/resources/jenkins-junit.xsd)
and some junit dialect which allows nested `testsuite` elements.

Usage:

```rust
use ensc_testsuite::PlanRunner;

#[test]
fn test() {
    let p = PlanRunner::new();
	p.run("init", |p| {
		p.ok("create database", || database.create());

		let admin: Admin =
		p.ok("create admin", || database.create_admin()).into();

		p.fail("create 2nd admin",  || database.create_admin());
		p.eq("exactly one admin", 1, "database.count_admin());

		p.new_plan("some other test")
			.set_skip(easter_is_at_xmas(), "strange event")
			.run(|p| {
				p.ok("....", || true);
			});
	});

	// not really necessary
	p.destruct();
}
```

When running `cargo test`, two environment variables must be set:

  - `TESTSUITE_OUTPUT`: the basename of the output file; depending on
    the chosen format a suffix like `.tap` or `.junit` will be appended

  - `TESTSUITE_FORMAT`: a comma separated list of output formats.
    Supported values are:

    - `tap`: nested [TAP](https://testanything.org/tap-version-13-specification.html)
    - `junit` or `junit-flat`: [junit](https://github.com/junit-team/junit5/blob/main/platform-tests/src/test/resources/jenkins-junit.xsd) format
    - `junit-nested`: junit with nested `testsuite` elements
    - `json`: some unspecified json representation
