#![allow(non_snake_case)]
#![allow(non_camel_case_types)]

//! Rust bindings for [`ENet`] library, the reliable UDP networking library.
//!
//! # Installation
//! Add the following to your `Cargo.toml` file:
//!
//! ```toml
//! [dependencies]
//! enet-rs = "1.3.17"
//! ```
//!
//! # Full Examples
//! Full examples, detailing and explaining usage of the basic functionality of the library, can be found in the [`examples`] directory.
//!
//! [`ENet`]: http://enet.bespin.org/
//! [`examples`]: https://github.com/ZTzTopia/enet-rs

pub mod callbacks;
pub mod enet;
pub mod types;
pub mod list;
pub mod protocol;
pub mod time;
pub mod header;
pub mod utility;