/* automatically generated by rust-bindgen 0.55.1 */

#[repr(C)]
#[derive(Copy, Clone, Debug, Default, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct __BindgenBitfieldUnit<Storage, Align> {
    storage: Storage,
    align: [Align; 0],
}
impl<Storage, Align> __BindgenBitfieldUnit<Storage, Align> {
    #[inline]
    pub const fn new(storage: Storage) -> Self {
        Self { storage, align: [] }
    }
}
impl<Storage, Align> __BindgenBitfieldUnit<Storage, Align>
where
    Storage: AsRef<[u8]> + AsMut<[u8]>,
{
    #[inline]
    pub fn get_bit(&self, index: usize) -> bool {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = self.storage.as_ref()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        byte & mask == mask
    }
    #[inline]
    pub fn set_bit(&mut self, index: usize, val: bool) {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = &mut self.storage.as_mut()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        if val {
            *byte |= mask;
        } else {
            *byte &= !mask;
        }
    }
    #[inline]
    pub fn get(&self, bit_offset: usize, bit_width: u8) -> u64 {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        let mut val = 0;
        for i in 0..(bit_width as usize) {
            if self.get_bit(i + bit_offset) {
                let index = if cfg!(target_endian = "big") {
                    bit_width as usize - 1 - i
                } else {
                    i
                };
                val |= 1 << index;
            }
        }
        val
    }
    #[inline]
    pub fn set(&mut self, bit_offset: usize, bit_width: u8, val: u64) {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        for i in 0..(bit_width as usize) {
            let mask = 1 << i;
            let val_bit_is_set = val & mask == mask;
            let index = if cfg!(target_endian = "big") {
                bit_width as usize - 1 - i
            } else {
                i
            };
            self.set_bit(index + bit_offset, val_bit_is_set);
        }
    }
}
#[repr(C)]
#[derive(Default)]
pub struct __IncompleteArrayField<T>(::std::marker::PhantomData<T>, [T; 0]);
impl<T> __IncompleteArrayField<T> {
    #[inline]
    pub const fn new() -> Self {
        __IncompleteArrayField(::std::marker::PhantomData, [])
    }
    #[inline]
    pub fn as_ptr(&self) -> *const T {
        self as *const _ as *const T
    }
    #[inline]
    pub fn as_mut_ptr(&mut self) -> *mut T {
        self as *mut _ as *mut T
    }
    #[inline]
    pub unsafe fn as_slice(&self, len: usize) -> &[T] {
        ::std::slice::from_raw_parts(self.as_ptr(), len)
    }
    #[inline]
    pub unsafe fn as_mut_slice(&mut self, len: usize) -> &mut [T] {
        ::std::slice::from_raw_parts_mut(self.as_mut_ptr(), len)
    }
}
impl<T> ::std::fmt::Debug for __IncompleteArrayField<T> {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.write_str("__IncompleteArrayField")
    }
}
pub const __ENDPOINT_SECURITY_INDIRECT__: u32 = 1;
pub const __WORDSIZE: u32 = 64;
pub const __DARWIN_ONLY_64_BIT_INO_T: u32 = 0;
pub const __DARWIN_ONLY_UNIX_CONFORMANCE: u32 = 1;
pub const __DARWIN_ONLY_VERS_1050: u32 = 0;
pub const __DARWIN_UNIX03: u32 = 1;
pub const __DARWIN_64_BIT_INO_T: u32 = 1;
pub const __DARWIN_VERS_1050: u32 = 1;
pub const __DARWIN_NON_CANCELABLE: u32 = 0;
pub const __DARWIN_SUF_64_BIT_INO_T: &'static [u8; 9usize] = b"$INODE64\0";
pub const __DARWIN_SUF_1050: &'static [u8; 6usize] = b"$1050\0";
pub const __DARWIN_SUF_EXTSN: &'static [u8; 14usize] = b"$DARWIN_EXTSN\0";
pub const __DARWIN_C_ANSI: u32 = 4096;
pub const __DARWIN_C_FULL: u32 = 900000;
pub const __DARWIN_C_LEVEL: u32 = 900000;
pub const __STDC_WANT_LIB_EXT1__: u32 = 1;
pub const __DARWIN_NO_LONG_LONG: u32 = 0;
pub const _DARWIN_FEATURE_64_BIT_INODE: u32 = 1;
pub const _DARWIN_FEATURE_ONLY_UNIX_CONFORMANCE: u32 = 1;
pub const _DARWIN_FEATURE_UNIX_CONFORMANCE: u32 = 3;
pub const __PTHREAD_SIZE__: u32 = 8176;
pub const __PTHREAD_ATTR_SIZE__: u32 = 56;
pub const __PTHREAD_MUTEXATTR_SIZE__: u32 = 8;
pub const __PTHREAD_MUTEX_SIZE__: u32 = 56;
pub const __PTHREAD_CONDATTR_SIZE__: u32 = 8;
pub const __PTHREAD_COND_SIZE__: u32 = 40;
pub const __PTHREAD_ONCE_SIZE__: u32 = 8;
pub const __PTHREAD_RWLOCK_SIZE__: u32 = 192;
pub const __PTHREAD_RWLOCKATTR_SIZE__: u32 = 16;
pub const INT8_MAX: u32 = 127;
pub const INT16_MAX: u32 = 32767;
pub const INT32_MAX: u32 = 2147483647;
pub const INT64_MAX: u64 = 9223372036854775807;
pub const INT8_MIN: i32 = -128;
pub const INT16_MIN: i32 = -32768;
pub const INT32_MIN: i32 = -2147483648;
pub const INT64_MIN: i64 = -9223372036854775808;
pub const UINT8_MAX: u32 = 255;
pub const UINT16_MAX: u32 = 65535;
pub const UINT32_MAX: u32 = 4294967295;
pub const UINT64_MAX: i32 = -1;
pub const INT_LEAST8_MIN: i32 = -128;
pub const INT_LEAST16_MIN: i32 = -32768;
pub const INT_LEAST32_MIN: i32 = -2147483648;
pub const INT_LEAST64_MIN: i64 = -9223372036854775808;
pub const INT_LEAST8_MAX: u32 = 127;
pub const INT_LEAST16_MAX: u32 = 32767;
pub const INT_LEAST32_MAX: u32 = 2147483647;
pub const INT_LEAST64_MAX: u64 = 9223372036854775807;
pub const UINT_LEAST8_MAX: u32 = 255;
pub const UINT_LEAST16_MAX: u32 = 65535;
pub const UINT_LEAST32_MAX: u32 = 4294967295;
pub const UINT_LEAST64_MAX: i32 = -1;
pub const INT_FAST8_MIN: i32 = -128;
pub const INT_FAST16_MIN: i32 = -32768;
pub const INT_FAST32_MIN: i32 = -2147483648;
pub const INT_FAST64_MIN: i64 = -9223372036854775808;
pub const INT_FAST8_MAX: u32 = 127;
pub const INT_FAST16_MAX: u32 = 32767;
pub const INT_FAST32_MAX: u32 = 2147483647;
pub const INT_FAST64_MAX: u64 = 9223372036854775807;
pub const UINT_FAST8_MAX: u32 = 255;
pub const UINT_FAST16_MAX: u32 = 65535;
pub const UINT_FAST32_MAX: u32 = 4294967295;
pub const UINT_FAST64_MAX: i32 = -1;
pub const INTPTR_MAX: u64 = 9223372036854775807;
pub const INTPTR_MIN: i64 = -9223372036854775808;
pub const UINTPTR_MAX: i32 = -1;
pub const SIZE_MAX: i32 = -1;
pub const RSIZE_MAX: i32 = -1;
pub const WINT_MIN: i32 = -2147483648;
pub const WINT_MAX: u32 = 2147483647;
pub const SIG_ATOMIC_MIN: i32 = -2147483648;
pub const SIG_ATOMIC_MAX: u32 = 2147483647;
pub const CS_VALID: u32 = 1;
pub const CS_ADHOC: u32 = 2;
pub const CS_GET_TASK_ALLOW: u32 = 4;
pub const CS_INSTALLER: u32 = 8;
pub const CS_FORCED_LV: u32 = 16;
pub const CS_INVALID_ALLOWED: u32 = 32;
pub const CS_HARD: u32 = 256;
pub const CS_KILL: u32 = 512;
pub const CS_CHECK_EXPIRATION: u32 = 1024;
pub const CS_RESTRICT: u32 = 2048;
pub const CS_ENFORCEMENT: u32 = 4096;
pub const CS_REQUIRE_LV: u32 = 8192;
pub const CS_ENTITLEMENTS_VALIDATED: u32 = 16384;
pub const CS_NVRAM_UNRESTRICTED: u32 = 32768;
pub const CS_RUNTIME: u32 = 65536;
pub const CS_LINKER_SIGNED: u32 = 131072;
pub const CS_ALLOWED_MACHO: u32 = 212738;
pub const CS_EXEC_SET_HARD: u32 = 1048576;
pub const CS_EXEC_SET_KILL: u32 = 2097152;
pub const CS_EXEC_SET_ENFORCEMENT: u32 = 4194304;
pub const CS_EXEC_INHERIT_SIP: u32 = 8388608;
pub const CS_KILLED: u32 = 16777216;
pub const CS_DYLD_PLATFORM: u32 = 33554432;
pub const CS_PLATFORM_BINARY: u32 = 67108864;
pub const CS_PLATFORM_PATH: u32 = 134217728;
pub const CS_DEBUGGED: u32 = 268435456;
pub const CS_SIGNED: u32 = 536870912;
pub const CS_DEV_CODE: u32 = 1073741824;
pub const CS_DATAVAULT_CONTROLLER: u32 = 2147483648;
pub const CS_ENTITLEMENT_FLAGS: u32 = 2147516428;
pub const CS_EXECSEG_MAIN_BINARY: u32 = 1;
pub const CS_EXECSEG_ALLOW_UNSIGNED: u32 = 16;
pub const CS_EXECSEG_DEBUGGER: u32 = 32;
pub const CS_EXECSEG_JIT: u32 = 64;
pub const CS_EXECSEG_SKIP_LV: u32 = 128;
pub const CS_EXECSEG_CAN_LOAD_CDHASH: u32 = 256;
pub const CS_EXECSEG_CAN_EXEC_CDHASH: u32 = 512;
pub const KERNEL_HAVE_CS_CODEDIRECTORY: u32 = 1;
pub const KERNEL_CS_CODEDIRECTORY_HAVE_PLATFORM: u32 = 1;
pub const KERNEL_HAVE_CS_GENERICBLOB: u32 = 1;
pub const _QUAD_HIGHWORD: u32 = 1;
pub const _QUAD_LOWWORD: u32 = 0;
pub const __DARWIN_LITTLE_ENDIAN: u32 = 1234;
pub const __DARWIN_BIG_ENDIAN: u32 = 4321;
pub const __DARWIN_PDP_ENDIAN: u32 = 3412;
pub const __DARWIN_BYTE_ORDER: u32 = 1234;
pub const LITTLE_ENDIAN: u32 = 1234;
pub const BIG_ENDIAN: u32 = 4321;
pub const PDP_ENDIAN: u32 = 3412;
pub const BYTE_ORDER: u32 = 1234;
pub const __API_TO_BE_DEPRECATED: u32 = 100000;
pub const __MAC_10_0: u32 = 1000;
pub const __MAC_10_1: u32 = 1010;
pub const __MAC_10_2: u32 = 1020;
pub const __MAC_10_3: u32 = 1030;
pub const __MAC_10_4: u32 = 1040;
pub const __MAC_10_5: u32 = 1050;
pub const __MAC_10_6: u32 = 1060;
pub const __MAC_10_7: u32 = 1070;
pub const __MAC_10_8: u32 = 1080;
pub const __MAC_10_9: u32 = 1090;
pub const __MAC_10_10: u32 = 101000;
pub const __MAC_10_10_2: u32 = 101002;
pub const __MAC_10_10_3: u32 = 101003;
pub const __MAC_10_11: u32 = 101100;
pub const __MAC_10_11_2: u32 = 101102;
pub const __MAC_10_11_3: u32 = 101103;
pub const __MAC_10_11_4: u32 = 101104;
pub const __MAC_10_12: u32 = 101200;
pub const __MAC_10_12_1: u32 = 101201;
pub const __MAC_10_12_2: u32 = 101202;
pub const __MAC_10_12_4: u32 = 101204;
pub const __MAC_10_13: u32 = 101300;
pub const __MAC_10_13_1: u32 = 101301;
pub const __MAC_10_13_2: u32 = 101302;
pub const __MAC_10_13_4: u32 = 101304;
pub const __MAC_10_14: u32 = 101400;
pub const __MAC_10_14_1: u32 = 101401;
pub const __MAC_10_14_4: u32 = 101404;
pub const __MAC_10_14_6: u32 = 101406;
pub const __MAC_10_15: u32 = 101500;
pub const __MAC_10_15_1: u32 = 101501;
pub const __MAC_10_15_4: u32 = 101504;
pub const __MAC_10_16: u32 = 101600;
pub const __MAC_11_0: u32 = 110000;
pub const __IPHONE_2_0: u32 = 20000;
pub const __IPHONE_2_1: u32 = 20100;
pub const __IPHONE_2_2: u32 = 20200;
pub const __IPHONE_3_0: u32 = 30000;
pub const __IPHONE_3_1: u32 = 30100;
pub const __IPHONE_3_2: u32 = 30200;
pub const __IPHONE_4_0: u32 = 40000;
pub const __IPHONE_4_1: u32 = 40100;
pub const __IPHONE_4_2: u32 = 40200;
pub const __IPHONE_4_3: u32 = 40300;
pub const __IPHONE_5_0: u32 = 50000;
pub const __IPHONE_5_1: u32 = 50100;
pub const __IPHONE_6_0: u32 = 60000;
pub const __IPHONE_6_1: u32 = 60100;
pub const __IPHONE_7_0: u32 = 70000;
pub const __IPHONE_7_1: u32 = 70100;
pub const __IPHONE_8_0: u32 = 80000;
pub const __IPHONE_8_1: u32 = 80100;
pub const __IPHONE_8_2: u32 = 80200;
pub const __IPHONE_8_3: u32 = 80300;
pub const __IPHONE_8_4: u32 = 80400;
pub const __IPHONE_9_0: u32 = 90000;
pub const __IPHONE_9_1: u32 = 90100;
pub const __IPHONE_9_2: u32 = 90200;
pub const __IPHONE_9_3: u32 = 90300;
pub const __IPHONE_10_0: u32 = 100000;
pub const __IPHONE_10_1: u32 = 100100;
pub const __IPHONE_10_2: u32 = 100200;
pub const __IPHONE_10_3: u32 = 100300;
pub const __IPHONE_11_0: u32 = 110000;
pub const __IPHONE_11_1: u32 = 110100;
pub const __IPHONE_11_2: u32 = 110200;
pub const __IPHONE_11_3: u32 = 110300;
pub const __IPHONE_11_4: u32 = 110400;
pub const __IPHONE_12_0: u32 = 120000;
pub const __IPHONE_12_1: u32 = 120100;
pub const __IPHONE_12_2: u32 = 120200;
pub const __IPHONE_12_3: u32 = 120300;
pub const __IPHONE_12_4: u32 = 120400;
pub const __IPHONE_13_0: u32 = 130000;
pub const __IPHONE_13_1: u32 = 130100;
pub const __IPHONE_13_2: u32 = 130200;
pub const __IPHONE_13_3: u32 = 130300;
pub const __IPHONE_13_4: u32 = 130400;
pub const __IPHONE_13_5: u32 = 130500;
pub const __IPHONE_13_6: u32 = 130600;
pub const __IPHONE_14_0: u32 = 140000;
pub const __TVOS_9_0: u32 = 90000;
pub const __TVOS_9_1: u32 = 90100;
pub const __TVOS_9_2: u32 = 90200;
pub const __TVOS_10_0: u32 = 100000;
pub const __TVOS_10_0_1: u32 = 100001;
pub const __TVOS_10_1: u32 = 100100;
pub const __TVOS_10_2: u32 = 100200;
pub const __TVOS_11_0: u32 = 110000;
pub const __TVOS_11_1: u32 = 110100;
pub const __TVOS_11_2: u32 = 110200;
pub const __TVOS_11_3: u32 = 110300;
pub const __TVOS_11_4: u32 = 110400;
pub const __TVOS_12_0: u32 = 120000;
pub const __TVOS_12_1: u32 = 120100;
pub const __TVOS_12_2: u32 = 120200;
pub const __TVOS_12_3: u32 = 120300;
pub const __TVOS_12_4: u32 = 120400;
pub const __TVOS_13_0: u32 = 130000;
pub const __TVOS_13_2: u32 = 130200;
pub const __TVOS_13_3: u32 = 130300;
pub const __TVOS_13_4: u32 = 130400;
pub const __TVOS_14_0: u32 = 140000;
pub const __WATCHOS_1_0: u32 = 10000;
pub const __WATCHOS_2_0: u32 = 20000;
pub const __WATCHOS_2_1: u32 = 20100;
pub const __WATCHOS_2_2: u32 = 20200;
pub const __WATCHOS_3_0: u32 = 30000;
pub const __WATCHOS_3_1: u32 = 30100;
pub const __WATCHOS_3_1_1: u32 = 30101;
pub const __WATCHOS_3_2: u32 = 30200;
pub const __WATCHOS_4_0: u32 = 40000;
pub const __WATCHOS_4_1: u32 = 40100;
pub const __WATCHOS_4_2: u32 = 40200;
pub const __WATCHOS_4_3: u32 = 40300;
pub const __WATCHOS_5_0: u32 = 50000;
pub const __WATCHOS_5_1: u32 = 50100;
pub const __WATCHOS_5_2: u32 = 50200;
pub const __WATCHOS_5_3: u32 = 50300;
pub const __WATCHOS_6_0: u32 = 60000;
pub const __WATCHOS_6_1: u32 = 60100;
pub const __WATCHOS_6_2: u32 = 60200;
pub const __WATCHOS_7_0: u32 = 70000;
pub const MAC_OS_X_VERSION_10_0: u32 = 1000;
pub const MAC_OS_X_VERSION_10_1: u32 = 1010;
pub const MAC_OS_X_VERSION_10_2: u32 = 1020;
pub const MAC_OS_X_VERSION_10_3: u32 = 1030;
pub const MAC_OS_X_VERSION_10_4: u32 = 1040;
pub const MAC_OS_X_VERSION_10_5: u32 = 1050;
pub const MAC_OS_X_VERSION_10_6: u32 = 1060;
pub const MAC_OS_X_VERSION_10_7: u32 = 1070;
pub const MAC_OS_X_VERSION_10_8: u32 = 1080;
pub const MAC_OS_X_VERSION_10_9: u32 = 1090;
pub const MAC_OS_X_VERSION_10_10: u32 = 101000;
pub const MAC_OS_X_VERSION_10_10_2: u32 = 101002;
pub const MAC_OS_X_VERSION_10_10_3: u32 = 101003;
pub const MAC_OS_X_VERSION_10_11: u32 = 101100;
pub const MAC_OS_X_VERSION_10_11_2: u32 = 101102;
pub const MAC_OS_X_VERSION_10_11_3: u32 = 101103;
pub const MAC_OS_X_VERSION_10_11_4: u32 = 101104;
pub const MAC_OS_X_VERSION_10_12: u32 = 101200;
pub const MAC_OS_X_VERSION_10_12_1: u32 = 101201;
pub const MAC_OS_X_VERSION_10_12_2: u32 = 101202;
pub const MAC_OS_X_VERSION_10_12_4: u32 = 101204;
pub const MAC_OS_X_VERSION_10_13: u32 = 101300;
pub const MAC_OS_X_VERSION_10_13_1: u32 = 101301;
pub const MAC_OS_X_VERSION_10_13_2: u32 = 101302;
pub const MAC_OS_X_VERSION_10_13_4: u32 = 101304;
pub const MAC_OS_X_VERSION_10_14: u32 = 101400;
pub const MAC_OS_X_VERSION_10_14_1: u32 = 101401;
pub const MAC_OS_X_VERSION_10_14_4: u32 = 101404;
pub const MAC_OS_X_VERSION_10_14_6: u32 = 101406;
pub const MAC_OS_X_VERSION_10_15: u32 = 101500;
pub const MAC_OS_X_VERSION_10_15_1: u32 = 101501;
pub const MAC_OS_X_VERSION_10_16: u32 = 101600;
pub const MAC_OS_VERSION_11_0: u32 = 110000;
pub const __DRIVERKIT_19_0: u32 = 190000;
pub const __DRIVERKIT_20_0: u32 = 200000;
pub const __MAC_OS_X_VERSION_MAX_ALLOWED: u32 = 101600;
pub const __ENABLE_LEGACY_MAC_AVAILABILITY: u32 = 1;
pub const __DARWIN_FD_SETSIZE: u32 = 1024;
pub const __DARWIN_NBBY: u32 = 8;
pub const NBBY: u32 = 8;
pub const FD_SETSIZE: u32 = 1024;
pub const TRUE: u32 = 1;
pub const FALSE: u32 = 0;
pub const MACH_PORT_NULL: u32 = 0;
pub const MACH_PORT_TYPE_DNREQUEST: u32 = 2147483648;
pub const MACH_PORT_TYPE_SPREQUEST: u32 = 1073741824;
pub const MACH_PORT_TYPE_SPREQUEST_DELAYED: u32 = 536870912;
pub const MACH_PORT_SRIGHTS_NONE: u32 = 0;
pub const MACH_PORT_SRIGHTS_PRESENT: u32 = 1;
pub const MACH_PORT_QLIMIT_ZERO: u32 = 0;
pub const MACH_PORT_QLIMIT_BASIC: u32 = 5;
pub const MACH_PORT_QLIMIT_SMALL: u32 = 16;
pub const MACH_PORT_QLIMIT_LARGE: u32 = 1024;
pub const MACH_PORT_QLIMIT_KERNEL: u32 = 65534;
pub const MACH_PORT_QLIMIT_MIN: u32 = 0;
pub const MACH_PORT_QLIMIT_DEFAULT: u32 = 5;
pub const MACH_PORT_QLIMIT_MAX: u32 = 1024;
pub const MACH_PORT_STATUS_FLAG_TEMPOWNER: u32 = 1;
pub const MACH_PORT_STATUS_FLAG_GUARDED: u32 = 2;
pub const MACH_PORT_STATUS_FLAG_STRICT_GUARD: u32 = 4;
pub const MACH_PORT_STATUS_FLAG_IMP_DONATION: u32 = 8;
pub const MACH_PORT_STATUS_FLAG_REVIVE: u32 = 16;
pub const MACH_PORT_STATUS_FLAG_TASKPTR: u32 = 32;
pub const MACH_PORT_STATUS_FLAG_GUARD_IMMOVABLE_RECEIVE: u32 = 64;
pub const MACH_PORT_STATUS_FLAG_NO_GRANT: u32 = 128;
pub const MACH_PORT_LIMITS_INFO: u32 = 1;
pub const MACH_PORT_RECEIVE_STATUS: u32 = 2;
pub const MACH_PORT_DNREQUESTS_SIZE: u32 = 3;
pub const MACH_PORT_TEMPOWNER: u32 = 4;
pub const MACH_PORT_IMPORTANCE_RECEIVER: u32 = 5;
pub const MACH_PORT_DENAP_RECEIVER: u32 = 6;
pub const MACH_PORT_INFO_EXT: u32 = 7;
pub const MACH_PORT_DNREQUESTS_SIZE_COUNT: u32 = 1;
pub const MPO_CONTEXT_AS_GUARD: u32 = 1;
pub const MPO_QLIMIT: u32 = 2;
pub const MPO_TEMPOWNER: u32 = 4;
pub const MPO_IMPORTANCE_RECEIVER: u32 = 8;
pub const MPO_INSERT_SEND_RIGHT: u32 = 16;
pub const MPO_STRICT: u32 = 32;
pub const MPO_DENAP_RECEIVER: u32 = 64;
pub const MPO_IMMOVABLE_RECEIVE: u32 = 128;
pub const MPO_FILTER_MSG: u32 = 256;
pub const MPO_TG_BLOCK_TRACKING: u32 = 512;
pub const GUARD_TYPE_MACH_PORT: u32 = 1;
pub const MAX_FATAL_kGUARD_EXC_CODE: u32 = 64;
pub const MPG_FLAGS_STRICT_REPLY_INVALID_REPLY_DISP: u64 = 72057594037927936;
pub const MPG_FLAGS_STRICT_REPLY_INVALID_REPLY_PORT: u64 = 144115188075855872;
pub const MPG_FLAGS_STRICT_REPLY_INVALID_VOUCHER: u64 = 288230376151711744;
pub const MPG_FLAGS_STRICT_REPLY_NO_BANK_ATTR: u64 = 576460752303423488;
pub const MPG_FLAGS_STRICT_REPLY_MISMATCHED_PERSONA: u64 = 1152921504606846976;
pub const MPG_FLAGS_STRICT_REPLY_MASK: i64 = -72057594037927936;
pub const MPG_STRICT: u32 = 1;
pub const MPG_IMMOVABLE_RECEIVE: u32 = 2;
pub const KERN_SUCCESS: u32 = 0;
pub const KERN_INVALID_ADDRESS: u32 = 1;
pub const KERN_PROTECTION_FAILURE: u32 = 2;
pub const KERN_NO_SPACE: u32 = 3;
pub const KERN_INVALID_ARGUMENT: u32 = 4;
pub const KERN_FAILURE: u32 = 5;
pub const KERN_RESOURCE_SHORTAGE: u32 = 6;
pub const KERN_NOT_RECEIVER: u32 = 7;
pub const KERN_NO_ACCESS: u32 = 8;
pub const KERN_MEMORY_FAILURE: u32 = 9;
pub const KERN_MEMORY_ERROR: u32 = 10;
pub const KERN_ALREADY_IN_SET: u32 = 11;
pub const KERN_NOT_IN_SET: u32 = 12;
pub const KERN_NAME_EXISTS: u32 = 13;
pub const KERN_ABORTED: u32 = 14;
pub const KERN_INVALID_NAME: u32 = 15;
pub const KERN_INVALID_TASK: u32 = 16;
pub const KERN_INVALID_RIGHT: u32 = 17;
pub const KERN_INVALID_VALUE: u32 = 18;
pub const KERN_UREFS_OVERFLOW: u32 = 19;
pub const KERN_INVALID_CAPABILITY: u32 = 20;
pub const KERN_RIGHT_EXISTS: u32 = 21;
pub const KERN_INVALID_HOST: u32 = 22;
pub const KERN_MEMORY_PRESENT: u32 = 23;
pub const KERN_MEMORY_DATA_MOVED: u32 = 24;
pub const KERN_MEMORY_RESTART_COPY: u32 = 25;
pub const KERN_INVALID_PROCESSOR_SET: u32 = 26;
pub const KERN_POLICY_LIMIT: u32 = 27;
pub const KERN_INVALID_POLICY: u32 = 28;
pub const KERN_INVALID_OBJECT: u32 = 29;
pub const KERN_ALREADY_WAITING: u32 = 30;
pub const KERN_DEFAULT_SET: u32 = 31;
pub const KERN_EXCEPTION_PROTECTED: u32 = 32;
pub const KERN_INVALID_LEDGER: u32 = 33;
pub const KERN_INVALID_MEMORY_CONTROL: u32 = 34;
pub const KERN_INVALID_SECURITY: u32 = 35;
pub const KERN_NOT_DEPRESSED: u32 = 36;
pub const KERN_TERMINATED: u32 = 37;
pub const KERN_LOCK_SET_DESTROYED: u32 = 38;
pub const KERN_LOCK_UNSTABLE: u32 = 39;
pub const KERN_LOCK_OWNED: u32 = 40;
pub const KERN_LOCK_OWNED_SELF: u32 = 41;
pub const KERN_SEMAPHORE_DESTROYED: u32 = 42;
pub const KERN_RPC_SERVER_TERMINATED: u32 = 43;
pub const KERN_RPC_TERMINATE_ORPHAN: u32 = 44;
pub const KERN_RPC_CONTINUE_ORPHAN: u32 = 45;
pub const KERN_NOT_SUPPORTED: u32 = 46;
pub const KERN_NODE_DOWN: u32 = 47;
pub const KERN_NOT_WAITING: u32 = 48;
pub const KERN_OPERATION_TIMED_OUT: u32 = 49;
pub const KERN_CODESIGN_ERROR: u32 = 50;
pub const KERN_POLICY_STATIC: u32 = 51;
pub const KERN_INSUFFICIENT_BUFFER_SIZE: u32 = 52;
pub const KERN_DENIED: u32 = 53;
pub const KERN_RETURN_MAX: u32 = 256;
pub const MACH_MSGH_BITS_ZERO: u32 = 0;
pub const MACH_MSGH_BITS_REMOTE_MASK: u32 = 31;
pub const MACH_MSGH_BITS_LOCAL_MASK: u32 = 7936;
pub const MACH_MSGH_BITS_VOUCHER_MASK: u32 = 2031616;
pub const MACH_MSGH_BITS_PORTS_MASK: u32 = 2039583;
pub const MACH_MSGH_BITS_COMPLEX: u32 = 2147483648;
pub const MACH_MSGH_BITS_USER: u32 = 2149523231;
pub const MACH_MSGH_BITS_RAISEIMP: u32 = 536870912;
pub const MACH_MSGH_BITS_DENAP: u32 = 536870912;
pub const MACH_MSGH_BITS_IMPHOLDASRT: u32 = 268435456;
pub const MACH_MSGH_BITS_DENAPHOLDASRT: u32 = 268435456;
pub const MACH_MSGH_BITS_CIRCULAR: u32 = 268435456;
pub const MACH_MSGH_BITS_USED: u32 = 2954829599;
pub const MACH_MSG_TYPE_MOVE_RECEIVE: u32 = 16;
pub const MACH_MSG_TYPE_MOVE_SEND: u32 = 17;
pub const MACH_MSG_TYPE_MOVE_SEND_ONCE: u32 = 18;
pub const MACH_MSG_TYPE_COPY_SEND: u32 = 19;
pub const MACH_MSG_TYPE_MAKE_SEND: u32 = 20;
pub const MACH_MSG_TYPE_MAKE_SEND_ONCE: u32 = 21;
pub const MACH_MSG_TYPE_COPY_RECEIVE: u32 = 22;
pub const MACH_MSG_TYPE_DISPOSE_RECEIVE: u32 = 24;
pub const MACH_MSG_TYPE_DISPOSE_SEND: u32 = 25;
pub const MACH_MSG_TYPE_DISPOSE_SEND_ONCE: u32 = 26;
pub const MACH_MSG_PHYSICAL_COPY: u32 = 0;
pub const MACH_MSG_VIRTUAL_COPY: u32 = 1;
pub const MACH_MSG_ALLOCATE: u32 = 2;
pub const MACH_MSG_OVERWRITE: u32 = 3;
pub const MACH_MSG_GUARD_FLAGS_NONE: u32 = 0;
pub const MACH_MSG_GUARD_FLAGS_IMMOVABLE_RECEIVE: u32 = 1;
pub const MACH_MSG_GUARD_FLAGS_UNGUARDED_ON_SEND: u32 = 2;
pub const MACH_MSG_GUARD_FLAGS_MASK: u32 = 3;
pub const MACH_MSG_PORT_DESCRIPTOR: u32 = 0;
pub const MACH_MSG_OOL_DESCRIPTOR: u32 = 1;
pub const MACH_MSG_OOL_PORTS_DESCRIPTOR: u32 = 2;
pub const MACH_MSG_OOL_VOLATILE_DESCRIPTOR: u32 = 3;
pub const MACH_MSG_GUARDED_PORT_DESCRIPTOR: u32 = 4;
pub const MACH_MSG_TRAILER_FORMAT_0: u32 = 0;
pub const MACH_MSGH_KIND_NORMAL: u32 = 0;
pub const MACH_MSGH_KIND_NOTIFICATION: u32 = 1;
pub const MACH_MSG_TYPE_PORT_NONE: u32 = 0;
pub const MACH_MSG_TYPE_PORT_NAME: u32 = 15;
pub const MACH_MSG_TYPE_PORT_RECEIVE: u32 = 16;
pub const MACH_MSG_TYPE_PORT_SEND: u32 = 17;
pub const MACH_MSG_TYPE_PORT_SEND_ONCE: u32 = 18;
pub const MACH_MSG_TYPE_LAST: u32 = 22;
pub const MACH_MSG_OPTION_NONE: u32 = 0;
pub const MACH_SEND_MSG: u32 = 1;
pub const MACH_RCV_MSG: u32 = 2;
pub const MACH_RCV_LARGE: u32 = 4;
pub const MACH_RCV_LARGE_IDENTITY: u32 = 8;
pub const MACH_SEND_TIMEOUT: u32 = 16;
pub const MACH_SEND_OVERRIDE: u32 = 32;
pub const MACH_SEND_INTERRUPT: u32 = 64;
pub const MACH_SEND_NOTIFY: u32 = 128;
pub const MACH_SEND_ALWAYS: u32 = 65536;
pub const MACH_SEND_TRAILER: u32 = 131072;
pub const MACH_SEND_NOIMPORTANCE: u32 = 262144;
pub const MACH_SEND_NODENAP: u32 = 262144;
pub const MACH_SEND_IMPORTANCE: u32 = 524288;
pub const MACH_SEND_SYNC_OVERRIDE: u32 = 1048576;
pub const MACH_SEND_PROPAGATE_QOS: u32 = 2097152;
pub const MACH_SEND_SYNC_USE_THRPRI: u32 = 2097152;
pub const MACH_SEND_KERNEL: u32 = 4194304;
pub const MACH_SEND_SYNC_BOOTSTRAP_CHECKIN: u32 = 8388608;
pub const MACH_RCV_TIMEOUT: u32 = 256;
pub const MACH_RCV_NOTIFY: u32 = 0;
pub const MACH_RCV_INTERRUPT: u32 = 1024;
pub const MACH_RCV_VOUCHER: u32 = 2048;
pub const MACH_RCV_OVERWRITE: u32 = 0;
pub const MACH_RCV_GUARDED_DESC: u32 = 4096;
pub const MACH_RCV_SYNC_WAIT: u32 = 16384;
pub const MACH_RCV_SYNC_PEEK: u32 = 32768;
pub const MACH_MSG_STRICT_REPLY: u32 = 512;
pub const MACH_RCV_TRAILER_NULL: u32 = 0;
pub const MACH_RCV_TRAILER_SEQNO: u32 = 1;
pub const MACH_RCV_TRAILER_SENDER: u32 = 2;
pub const MACH_RCV_TRAILER_AUDIT: u32 = 3;
pub const MACH_RCV_TRAILER_CTX: u32 = 4;
pub const MACH_RCV_TRAILER_AV: u32 = 7;
pub const MACH_RCV_TRAILER_LABELS: u32 = 8;
pub const MACH_RCV_TRAILER_MASK: u32 = 251658240;
pub const MACH_MSG_SUCCESS: u32 = 0;
pub const MACH_MSG_MASK: u32 = 15872;
pub const MACH_MSG_IPC_SPACE: u32 = 8192;
pub const MACH_MSG_VM_SPACE: u32 = 4096;
pub const MACH_MSG_IPC_KERNEL: u32 = 2048;
pub const MACH_MSG_VM_KERNEL: u32 = 1024;
pub const MACH_SEND_IN_PROGRESS: u32 = 268435457;
pub const MACH_SEND_INVALID_DATA: u32 = 268435458;
pub const MACH_SEND_INVALID_DEST: u32 = 268435459;
pub const MACH_SEND_TIMED_OUT: u32 = 268435460;
pub const MACH_SEND_INVALID_VOUCHER: u32 = 268435461;
pub const MACH_SEND_INTERRUPTED: u32 = 268435463;
pub const MACH_SEND_MSG_TOO_SMALL: u32 = 268435464;
pub const MACH_SEND_INVALID_REPLY: u32 = 268435465;
pub const MACH_SEND_INVALID_RIGHT: u32 = 268435466;
pub const MACH_SEND_INVALID_NOTIFY: u32 = 268435467;
pub const MACH_SEND_INVALID_MEMORY: u32 = 268435468;
pub const MACH_SEND_NO_BUFFER: u32 = 268435469;
pub const MACH_SEND_TOO_LARGE: u32 = 268435470;
pub const MACH_SEND_INVALID_TYPE: u32 = 268435471;
pub const MACH_SEND_INVALID_HEADER: u32 = 268435472;
pub const MACH_SEND_INVALID_TRAILER: u32 = 268435473;
pub const MACH_SEND_INVALID_CONTEXT: u32 = 268435474;
pub const MACH_SEND_INVALID_RT_OOL_SIZE: u32 = 268435477;
pub const MACH_SEND_NO_GRANT_DEST: u32 = 268435478;
pub const MACH_SEND_MSG_FILTERED: u32 = 268435479;
pub const MACH_RCV_IN_PROGRESS: u32 = 268451841;
pub const MACH_RCV_INVALID_NAME: u32 = 268451842;
pub const MACH_RCV_TIMED_OUT: u32 = 268451843;
pub const MACH_RCV_TOO_LARGE: u32 = 268451844;
pub const MACH_RCV_INTERRUPTED: u32 = 268451845;
pub const MACH_RCV_PORT_CHANGED: u32 = 268451846;
pub const MACH_RCV_INVALID_NOTIFY: u32 = 268451847;
pub const MACH_RCV_INVALID_DATA: u32 = 268451848;
pub const MACH_RCV_PORT_DIED: u32 = 268451849;
pub const MACH_RCV_IN_SET: u32 = 268451850;
pub const MACH_RCV_HEADER_ERROR: u32 = 268451851;
pub const MACH_RCV_BODY_ERROR: u32 = 268451852;
pub const MACH_RCV_INVALID_TYPE: u32 = 268451853;
pub const MACH_RCV_SCATTER_SMALL: u32 = 268451854;
pub const MACH_RCV_INVALID_TRAILER: u32 = 268451855;
pub const MACH_RCV_IN_PROGRESS_TIMED: u32 = 268451857;
pub const MACH_RCV_INVALID_REPLY: u32 = 268451858;
pub const true_: u32 = 1;
pub const false_: u32 = 0;
pub const __bool_true_false_are_defined: u32 = 1;
pub const BSD: u32 = 199506;
pub const BSD4_3: u32 = 1;
pub const BSD4_4: u32 = 1;
pub const NeXTBSD: u32 = 1995064;
pub const NeXTBSD4_0: u32 = 0;
pub const ARG_MAX: u32 = 1048576;
pub const CHILD_MAX: u32 = 266;
pub const GID_MAX: u32 = 2147483647;
pub const LINK_MAX: u32 = 32767;
pub const MAX_CANON: u32 = 1024;
pub const MAX_INPUT: u32 = 1024;
pub const NAME_MAX: u32 = 255;
pub const NGROUPS_MAX: u32 = 16;
pub const UID_MAX: u32 = 2147483647;
pub const OPEN_MAX: u32 = 10240;
pub const PATH_MAX: u32 = 1024;
pub const PIPE_BUF: u32 = 512;
pub const BC_BASE_MAX: u32 = 99;
pub const BC_DIM_MAX: u32 = 2048;
pub const BC_SCALE_MAX: u32 = 99;
pub const BC_STRING_MAX: u32 = 1000;
pub const CHARCLASS_NAME_MAX: u32 = 14;
pub const COLL_WEIGHTS_MAX: u32 = 2;
pub const EQUIV_CLASS_MAX: u32 = 2;
pub const EXPR_NEST_MAX: u32 = 32;
pub const LINE_MAX: u32 = 2048;
pub const RE_DUP_MAX: u32 = 255;
pub const NZERO: u32 = 20;
pub const MAXCOMLEN: u32 = 16;
pub const MAXINTERP: u32 = 64;
pub const MAXLOGNAME: u32 = 255;
pub const MAXUPRC: u32 = 266;
pub const NCARGS: u32 = 1048576;
pub const NGROUPS: u32 = 16;
pub const NOFILE: u32 = 256;
pub const NOGROUP: u32 = 65535;
pub const MAXHOSTNAMELEN: u32 = 256;
pub const MAXDOMNAMELEN: u32 = 256;
pub const NBPG: u32 = 4096;
pub const PGOFSET: u32 = 4095;
pub const PGSHIFT: u32 = 12;
pub const DEV_BSIZE: u32 = 512;
pub const DEV_BSHIFT: u32 = 9;
pub const BLKDEV_IOSIZE: u32 = 2048;
pub const MAXPHYS: u32 = 131072;
pub const CLSIZE: u32 = 1;
pub const CLSIZELOG2: u32 = 0;
pub const MSIZESHIFT: u32 = 8;
pub const MSIZE: u32 = 256;
pub const MCLSHIFT: u32 = 11;
pub const MCLBYTES: u32 = 2048;
pub const MBIGCLSHIFT: u32 = 12;
pub const MBIGCLBYTES: u32 = 4096;
pub const M16KCLSHIFT: u32 = 14;
pub const M16KCLBYTES: u32 = 16384;
pub const MCLOFSET: u32 = 2047;
pub const NMBCLUSTERS: u32 = 512;
pub const __DARWIN_CLK_TCK: u32 = 100;
pub const CHAR_BIT: u32 = 8;
pub const MB_LEN_MAX: u32 = 6;
pub const CLK_TCK: u32 = 100;
pub const SCHAR_MAX: u32 = 127;
pub const SCHAR_MIN: i32 = -128;
pub const UCHAR_MAX: u32 = 255;
pub const CHAR_MAX: u32 = 127;
pub const CHAR_MIN: i32 = -128;
pub const USHRT_MAX: u32 = 65535;
pub const SHRT_MAX: u32 = 32767;
pub const SHRT_MIN: i32 = -32768;
pub const UINT_MAX: u32 = 4294967295;
pub const INT_MAX: u32 = 2147483647;
pub const INT_MIN: i32 = -2147483648;
pub const ULONG_MAX: i32 = -1;
pub const LONG_MAX: u64 = 9223372036854775807;
pub const LONG_MIN: i64 = -9223372036854775808;
pub const ULLONG_MAX: i32 = -1;
pub const LLONG_MAX: u64 = 9223372036854775807;
pub const LLONG_MIN: i64 = -9223372036854775808;
pub const LONG_BIT: u32 = 64;
pub const SSIZE_MAX: u64 = 9223372036854775807;
pub const WORD_BIT: u32 = 32;
pub const SIZE_T_MAX: i32 = -1;
pub const UQUAD_MAX: i32 = -1;
pub const QUAD_MAX: u64 = 9223372036854775807;
pub const QUAD_MIN: i64 = -9223372036854775808;
pub const _POSIX_ARG_MAX: u32 = 4096;
pub const _POSIX_CHILD_MAX: u32 = 25;
pub const _POSIX_LINK_MAX: u32 = 8;
pub const _POSIX_MAX_CANON: u32 = 255;
pub const _POSIX_MAX_INPUT: u32 = 255;
pub const _POSIX_NAME_MAX: u32 = 14;
pub const _POSIX_NGROUPS_MAX: u32 = 8;
pub const _POSIX_OPEN_MAX: u32 = 20;
pub const _POSIX_PATH_MAX: u32 = 256;
pub const _POSIX_PIPE_BUF: u32 = 512;
pub const _POSIX_SSIZE_MAX: u32 = 32767;
pub const _POSIX_STREAM_MAX: u32 = 8;
pub const _POSIX_TZNAME_MAX: u32 = 6;
pub const _POSIX2_BC_BASE_MAX: u32 = 99;
pub const _POSIX2_BC_DIM_MAX: u32 = 2048;
pub const _POSIX2_BC_SCALE_MAX: u32 = 99;
pub const _POSIX2_BC_STRING_MAX: u32 = 1000;
pub const _POSIX2_EQUIV_CLASS_MAX: u32 = 2;
pub const _POSIX2_EXPR_NEST_MAX: u32 = 32;
pub const _POSIX2_LINE_MAX: u32 = 2048;
pub const _POSIX2_RE_DUP_MAX: u32 = 255;
pub const _POSIX_AIO_LISTIO_MAX: u32 = 2;
pub const _POSIX_AIO_MAX: u32 = 1;
pub const _POSIX_DELAYTIMER_MAX: u32 = 32;
pub const _POSIX_MQ_OPEN_MAX: u32 = 8;
pub const _POSIX_MQ_PRIO_MAX: u32 = 32;
pub const _POSIX_RTSIG_MAX: u32 = 8;
pub const _POSIX_SEM_NSEMS_MAX: u32 = 256;
pub const _POSIX_SEM_VALUE_MAX: u32 = 32767;
pub const _POSIX_SIGQUEUE_MAX: u32 = 32;
pub const _POSIX_TIMER_MAX: u32 = 32;
pub const _POSIX_CLOCKRES_MIN: u32 = 20000000;
pub const _POSIX_THREAD_DESTRUCTOR_ITERATIONS: u32 = 4;
pub const _POSIX_THREAD_KEYS_MAX: u32 = 128;
pub const _POSIX_THREAD_THREADS_MAX: u32 = 64;
pub const PTHREAD_DESTRUCTOR_ITERATIONS: u32 = 4;
pub const PTHREAD_KEYS_MAX: u32 = 512;
pub const PTHREAD_STACK_MIN: u32 = 8192;
pub const _POSIX_HOST_NAME_MAX: u32 = 255;
pub const _POSIX_LOGIN_NAME_MAX: u32 = 9;
pub const _POSIX_SS_REPL_MAX: u32 = 4;
pub const _POSIX_SYMLINK_MAX: u32 = 255;
pub const _POSIX_SYMLOOP_MAX: u32 = 8;
pub const _POSIX_TRACE_EVENT_NAME_MAX: u32 = 30;
pub const _POSIX_TRACE_NAME_MAX: u32 = 8;
pub const _POSIX_TRACE_SYS_MAX: u32 = 8;
pub const _POSIX_TRACE_USER_EVENT_MAX: u32 = 32;
pub const _POSIX_TTY_NAME_MAX: u32 = 9;
pub const _POSIX2_CHARCLASS_NAME_MAX: u32 = 14;
pub const _POSIX2_COLL_WEIGHTS_MAX: u32 = 2;
pub const _POSIX_RE_DUP_MAX: u32 = 255;
pub const OFF_MIN: i64 = -9223372036854775808;
pub const OFF_MAX: u64 = 9223372036854775807;
pub const PASS_MAX: u32 = 128;
pub const NL_ARGMAX: u32 = 9;
pub const NL_LANGMAX: u32 = 14;
pub const NL_MSGMAX: u32 = 32767;
pub const NL_NMAX: u32 = 1;
pub const NL_SETMAX: u32 = 255;
pub const NL_TEXTMAX: u32 = 2048;
pub const _XOPEN_IOV_MAX: u32 = 16;
pub const IOV_MAX: u32 = 1024;
pub const _XOPEN_NAME_MAX: u32 = 255;
pub const _XOPEN_PATH_MAX: u32 = 1024;
pub const __DARWIN_NSIG: u32 = 32;
pub const NSIG: u32 = 32;
pub const _I386_SIGNAL_H_: u32 = 1;
pub const SIGHUP: u32 = 1;
pub const SIGINT: u32 = 2;
pub const SIGQUIT: u32 = 3;
pub const SIGILL: u32 = 4;
pub const SIGTRAP: u32 = 5;
pub const SIGABRT: u32 = 6;
pub const SIGIOT: u32 = 6;
pub const SIGEMT: u32 = 7;
pub const SIGFPE: u32 = 8;
pub const SIGKILL: u32 = 9;
pub const SIGBUS: u32 = 10;
pub const SIGSEGV: u32 = 11;
pub const SIGSYS: u32 = 12;
pub const SIGPIPE: u32 = 13;
pub const SIGALRM: u32 = 14;
pub const SIGTERM: u32 = 15;
pub const SIGURG: u32 = 16;
pub const SIGSTOP: u32 = 17;
pub const SIGTSTP: u32 = 18;
pub const SIGCONT: u32 = 19;
pub const SIGCHLD: u32 = 20;
pub const SIGTTIN: u32 = 21;
pub const SIGTTOU: u32 = 22;
pub const SIGIO: u32 = 23;
pub const SIGXCPU: u32 = 24;
pub const SIGXFSZ: u32 = 25;
pub const SIGVTALRM: u32 = 26;
pub const SIGPROF: u32 = 27;
pub const SIGWINCH: u32 = 28;
pub const SIGINFO: u32 = 29;
pub const SIGUSR1: u32 = 30;
pub const SIGUSR2: u32 = 31;
pub const FP_PREC_24B: u32 = 0;
pub const FP_PREC_53B: u32 = 2;
pub const FP_PREC_64B: u32 = 3;
pub const FP_RND_NEAR: u32 = 0;
pub const FP_RND_DOWN: u32 = 1;
pub const FP_RND_UP: u32 = 2;
pub const FP_CHOP: u32 = 3;
pub const FP_STATE_BYTES: u32 = 512;
pub const SIGEV_NONE: u32 = 0;
pub const SIGEV_SIGNAL: u32 = 1;
pub const SIGEV_THREAD: u32 = 3;
pub const ILL_NOOP: u32 = 0;
pub const ILL_ILLOPC: u32 = 1;
pub const ILL_ILLTRP: u32 = 2;
pub const ILL_PRVOPC: u32 = 3;
pub const ILL_ILLOPN: u32 = 4;
pub const ILL_ILLADR: u32 = 5;
pub const ILL_PRVREG: u32 = 6;
pub const ILL_COPROC: u32 = 7;
pub const ILL_BADSTK: u32 = 8;
pub const FPE_NOOP: u32 = 0;
pub const FPE_FLTDIV: u32 = 1;
pub const FPE_FLTOVF: u32 = 2;
pub const FPE_FLTUND: u32 = 3;
pub const FPE_FLTRES: u32 = 4;
pub const FPE_FLTINV: u32 = 5;
pub const FPE_FLTSUB: u32 = 6;
pub const FPE_INTDIV: u32 = 7;
pub const FPE_INTOVF: u32 = 8;
pub const SEGV_NOOP: u32 = 0;
pub const SEGV_MAPERR: u32 = 1;
pub const SEGV_ACCERR: u32 = 2;
pub const BUS_NOOP: u32 = 0;
pub const BUS_ADRALN: u32 = 1;
pub const BUS_ADRERR: u32 = 2;
pub const BUS_OBJERR: u32 = 3;
pub const TRAP_BRKPT: u32 = 1;
pub const TRAP_TRACE: u32 = 2;
pub const CLD_NOOP: u32 = 0;
pub const CLD_EXITED: u32 = 1;
pub const CLD_KILLED: u32 = 2;
pub const CLD_DUMPED: u32 = 3;
pub const CLD_TRAPPED: u32 = 4;
pub const CLD_STOPPED: u32 = 5;
pub const CLD_CONTINUED: u32 = 6;
pub const POLL_IN: u32 = 1;
pub const POLL_OUT: u32 = 2;
pub const POLL_MSG: u32 = 3;
pub const POLL_ERR: u32 = 4;
pub const POLL_PRI: u32 = 5;
pub const POLL_HUP: u32 = 6;
pub const SA_ONSTACK: u32 = 1;
pub const SA_RESTART: u32 = 2;
pub const SA_RESETHAND: u32 = 4;
pub const SA_NOCLDSTOP: u32 = 8;
pub const SA_NODEFER: u32 = 16;
pub const SA_NOCLDWAIT: u32 = 32;
pub const SA_SIGINFO: u32 = 64;
pub const SA_USERTRAMP: u32 = 256;
pub const SA_64REGSET: u32 = 512;
pub const SA_USERSPACE_MASK: u32 = 127;
pub const SIG_BLOCK: u32 = 1;
pub const SIG_UNBLOCK: u32 = 2;
pub const SIG_SETMASK: u32 = 3;
pub const SI_USER: u32 = 65537;
pub const SI_QUEUE: u32 = 65538;
pub const SI_TIMER: u32 = 65539;
pub const SI_ASYNCIO: u32 = 65540;
pub const SI_MESGQ: u32 = 65541;
pub const SS_ONSTACK: u32 = 1;
pub const SS_DISABLE: u32 = 4;
pub const MINSIGSTKSZ: u32 = 32768;
pub const SIGSTKSZ: u32 = 131072;
pub const SV_ONSTACK: u32 = 1;
pub const SV_INTERRUPT: u32 = 2;
pub const SV_RESETHAND: u32 = 4;
pub const SV_NODEFER: u32 = 16;
pub const SV_NOCLDSTOP: u32 = 8;
pub const SV_SIGINFO: u32 = 64;
pub const PSWP: u32 = 0;
pub const PVM: u32 = 4;
pub const PINOD: u32 = 8;
pub const PRIBIO: u32 = 16;
pub const PVFS: u32 = 20;
pub const PZERO: u32 = 22;
pub const PSOCK: u32 = 24;
pub const PWAIT: u32 = 32;
pub const PLOCK: u32 = 36;
pub const PPAUSE: u32 = 40;
pub const PUSER: u32 = 50;
pub const MAXPRI: u32 = 127;
pub const PRIMASK: u32 = 255;
pub const PCATCH: u32 = 256;
pub const PTTYBLOCK: u32 = 512;
pub const PDROP: u32 = 1024;
pub const PSPIN: u32 = 2048;
pub const CMASK: u32 = 18;
pub const CLBYTES: u32 = 4096;
pub const CLOFSET: u32 = 4095;
pub const CLOFF: u32 = 4095;
pub const CLSHIFT: u32 = 12;
pub const CBLOCK: u32 = 64;
pub const CBQSIZE: u32 = 8;
pub const CROUND: u32 = 63;
pub const MAXBSIZE: u32 = 1048576;
pub const MAXPHYSIO: u32 = 131072;
pub const MAXFRAG: u32 = 8;
pub const MAXPHYSIO_WIRED: u32 = 16777216;
pub const MAXPATHLEN: u32 = 1024;
pub const MAXSYMLINKS: u32 = 32;
pub const FSHIFT: u32 = 11;
pub const FSCALE: u32 = 2048;
pub const AUDIT_RECORD_MAGIC: u32 = 2190085915;
pub const MAX_AUDIT_RECORDS: u32 = 20;
pub const MAXAUDITDATA: u32 = 32767;
pub const MAX_AUDIT_RECORD_SIZE: u32 = 32767;
pub const MIN_AUDIT_FILE_SIZE: u32 = 524288;
pub const AUDIT_HARD_LIMIT_FREE_BLOCKS: u32 = 4;
pub const AUDIT_TRIGGER_MIN: u32 = 1;
pub const AUDIT_TRIGGER_LOW_SPACE: u32 = 1;
pub const AUDIT_TRIGGER_ROTATE_KERNEL: u32 = 2;
pub const AUDIT_TRIGGER_READ_FILE: u32 = 3;
pub const AUDIT_TRIGGER_CLOSE_AND_DIE: u32 = 4;
pub const AUDIT_TRIGGER_NO_SPACE: u32 = 5;
pub const AUDIT_TRIGGER_ROTATE_USER: u32 = 6;
pub const AUDIT_TRIGGER_INITIALIZE: u32 = 7;
pub const AUDIT_TRIGGER_EXPIRE_TRAILS: u32 = 8;
pub const AUDIT_TRIGGER_MAX: u32 = 8;
pub const AUDITDEV_FILENAME: &'static [u8; 6usize] = b"audit\0";
pub const AUDIT_TRIGGER_FILE: &'static [u8; 11usize] = b"/dev/audit\0";
pub const AU_DEFAUDITSID: u32 = 0;
pub const AU_ASSIGN_ASID: i32 = -1;
pub const AUC_UNSET: u32 = 0;
pub const AUC_AUDITING: u32 = 1;
pub const AUC_NOAUDIT: u32 = 2;
pub const AUC_DISABLED: i32 = -1;
pub const A_OLDGETPOLICY: u32 = 2;
pub const A_OLDSETPOLICY: u32 = 3;
pub const A_GETKMASK: u32 = 4;
pub const A_SETKMASK: u32 = 5;
pub const A_OLDGETQCTRL: u32 = 6;
pub const A_OLDSETQCTRL: u32 = 7;
pub const A_GETCWD: u32 = 8;
pub const A_GETCAR: u32 = 9;
pub const A_GETSTAT: u32 = 12;
pub const A_SETSTAT: u32 = 13;
pub const A_SETUMASK: u32 = 14;
pub const A_SETSMASK: u32 = 15;
pub const A_OLDGETCOND: u32 = 20;
pub const A_OLDSETCOND: u32 = 21;
pub const A_GETCLASS: u32 = 22;
pub const A_SETCLASS: u32 = 23;
pub const A_GETPINFO: u32 = 24;
pub const A_SETPMASK: u32 = 25;
pub const A_SETFSIZE: u32 = 26;
pub const A_GETFSIZE: u32 = 27;
pub const A_GETPINFO_ADDR: u32 = 28;
pub const A_GETKAUDIT: u32 = 29;
pub const A_SETKAUDIT: u32 = 30;
pub const A_SENDTRIGGER: u32 = 31;
pub const A_GETSINFO_ADDR: u32 = 32;
pub const A_GETPOLICY: u32 = 33;
pub const A_SETPOLICY: u32 = 34;
pub const A_GETQCTRL: u32 = 35;
pub const A_SETQCTRL: u32 = 36;
pub const A_GETCOND: u32 = 37;
pub const A_SETCOND: u32 = 38;
pub const A_GETSFLAGS: u32 = 39;
pub const A_SETSFLAGS: u32 = 40;
pub const A_GETCTLMODE: u32 = 41;
pub const A_SETCTLMODE: u32 = 42;
pub const A_GETEXPAFTER: u32 = 43;
pub const A_SETEXPAFTER: u32 = 44;
pub const AUDIT_CNT: u32 = 1;
pub const AUDIT_AHLT: u32 = 2;
pub const AUDIT_ARGV: u32 = 4;
pub const AUDIT_ARGE: u32 = 8;
pub const AUDIT_SEQ: u32 = 16;
pub const AUDIT_WINDATA: u32 = 32;
pub const AUDIT_USER: u32 = 64;
pub const AUDIT_GROUP: u32 = 128;
pub const AUDIT_TRAIL: u32 = 256;
pub const AUDIT_PATH: u32 = 512;
pub const AUDIT_SCNT: u32 = 1024;
pub const AUDIT_PUBLIC: u32 = 2048;
pub const AUDIT_ZONENAME: u32 = 4096;
pub const AUDIT_PERZONE: u32 = 8192;
pub const AQ_HIWATER: u32 = 100;
pub const AQ_MAXHIGH: u32 = 10000;
pub const AQ_LOWATER: u32 = 10;
pub const AQ_BUFSZ: u32 = 32767;
pub const AQ_MAXBUFSZ: u32 = 1048576;
pub const AU_FS_MINFREE: u32 = 20;
pub const AU_IPv4: u32 = 4;
pub const AU_IPv6: u32 = 16;
pub const AU_CLASS_MASK_RESERVED: u32 = 268435456;
pub const CRF_NOMEMBERD: u32 = 1;
pub const CRF_MAC_ENFORCE: u32 = 2;
pub const XUCRED_VERSION: u32 = 0;
pub const ITIMER_REAL: u32 = 0;
pub const ITIMER_VIRTUAL: u32 = 1;
pub const ITIMER_PROF: u32 = 2;
pub const DST_NONE: u32 = 0;
pub const DST_USA: u32 = 1;
pub const DST_AUST: u32 = 2;
pub const DST_WET: u32 = 3;
pub const DST_MET: u32 = 4;
pub const DST_EET: u32 = 5;
pub const DST_CAN: u32 = 6;
pub const __DARWIN_WCHAR_MIN: i32 = -2147483648;
pub const _FORTIFY_SOURCE: u32 = 2;
pub const CLOCKS_PER_SEC: u32 = 1000000;
pub const TIME_UTC: u32 = 1;
pub const FSOPT_NOFOLLOW: u32 = 1;
pub const FSOPT_NOINMEMUPDATE: u32 = 2;
pub const FSOPT_REPORT_FULLSIZE: u32 = 4;
pub const FSOPT_PACK_INVAL_ATTRS: u32 = 8;
pub const FSOPT_ATTR_CMN_EXTENDED: u32 = 32;
pub const FSOPT_RETURN_REALDEV: u32 = 512;
pub const SEARCHFS_MAX_SEARCHPARMS: u32 = 4096;
pub const ATTR_BIT_MAP_COUNT: u32 = 5;
pub const VOL_CAPABILITIES_FORMAT: u32 = 0;
pub const VOL_CAPABILITIES_INTERFACES: u32 = 1;
pub const VOL_CAPABILITIES_RESERVED1: u32 = 2;
pub const VOL_CAPABILITIES_RESERVED2: u32 = 3;
pub const ATTR_MAX_BUFFER: u32 = 8192;
pub const VOL_CAP_FMT_PERSISTENTOBJECTIDS: u32 = 1;
pub const VOL_CAP_FMT_SYMBOLICLINKS: u32 = 2;
pub const VOL_CAP_FMT_HARDLINKS: u32 = 4;
pub const VOL_CAP_FMT_JOURNAL: u32 = 8;
pub const VOL_CAP_FMT_JOURNAL_ACTIVE: u32 = 16;
pub const VOL_CAP_FMT_NO_ROOT_TIMES: u32 = 32;
pub const VOL_CAP_FMT_SPARSE_FILES: u32 = 64;
pub const VOL_CAP_FMT_ZERO_RUNS: u32 = 128;
pub const VOL_CAP_FMT_CASE_SENSITIVE: u32 = 256;
pub const VOL_CAP_FMT_CASE_PRESERVING: u32 = 512;
pub const VOL_CAP_FMT_FAST_STATFS: u32 = 1024;
pub const VOL_CAP_FMT_2TB_FILESIZE: u32 = 2048;
pub const VOL_CAP_FMT_OPENDENYMODES: u32 = 4096;
pub const VOL_CAP_FMT_HIDDEN_FILES: u32 = 8192;
pub const VOL_CAP_FMT_PATH_FROM_ID: u32 = 16384;
pub const VOL_CAP_FMT_NO_VOLUME_SIZES: u32 = 32768;
pub const VOL_CAP_FMT_DECMPFS_COMPRESSION: u32 = 65536;
pub const VOL_CAP_FMT_64BIT_OBJECT_IDS: u32 = 131072;
pub const VOL_CAP_FMT_DIR_HARDLINKS: u32 = 262144;
pub const VOL_CAP_FMT_DOCUMENT_ID: u32 = 524288;
pub const VOL_CAP_FMT_WRITE_GENERATION_COUNT: u32 = 1048576;
pub const VOL_CAP_FMT_NO_IMMUTABLE_FILES: u32 = 2097152;
pub const VOL_CAP_FMT_NO_PERMISSIONS: u32 = 4194304;
pub const VOL_CAP_FMT_SHARED_SPACE: u32 = 8388608;
pub const VOL_CAP_FMT_VOL_GROUPS: u32 = 16777216;
pub const VOL_CAP_FMT_SEALED: u32 = 33554432;
pub const VOL_CAP_INT_SEARCHFS: u32 = 1;
pub const VOL_CAP_INT_ATTRLIST: u32 = 2;
pub const VOL_CAP_INT_NFSEXPORT: u32 = 4;
pub const VOL_CAP_INT_READDIRATTR: u32 = 8;
pub const VOL_CAP_INT_EXCHANGEDATA: u32 = 16;
pub const VOL_CAP_INT_COPYFILE: u32 = 32;
pub const VOL_CAP_INT_ALLOCATE: u32 = 64;
pub const VOL_CAP_INT_VOL_RENAME: u32 = 128;
pub const VOL_CAP_INT_ADVLOCK: u32 = 256;
pub const VOL_CAP_INT_FLOCK: u32 = 512;
pub const VOL_CAP_INT_EXTENDED_SECURITY: u32 = 1024;
pub const VOL_CAP_INT_USERACCESS: u32 = 2048;
pub const VOL_CAP_INT_MANLOCK: u32 = 4096;
pub const VOL_CAP_INT_NAMEDSTREAMS: u32 = 8192;
pub const VOL_CAP_INT_EXTENDED_ATTR: u32 = 16384;
pub const VOL_CAP_INT_CLONE: u32 = 65536;
pub const VOL_CAP_INT_SNAPSHOT: u32 = 131072;
pub const VOL_CAP_INT_RENAME_SWAP: u32 = 262144;
pub const VOL_CAP_INT_RENAME_EXCL: u32 = 524288;
pub const VOL_CAP_INT_RENAME_OPENFAIL: u32 = 1048576;
pub const ATTR_CMN_NAME: u32 = 1;
pub const ATTR_CMN_DEVID: u32 = 2;
pub const ATTR_CMN_FSID: u32 = 4;
pub const ATTR_CMN_OBJTYPE: u32 = 8;
pub const ATTR_CMN_OBJTAG: u32 = 16;
pub const ATTR_CMN_OBJID: u32 = 32;
pub const ATTR_CMN_OBJPERMANENTID: u32 = 64;
pub const ATTR_CMN_PAROBJID: u32 = 128;
pub const ATTR_CMN_SCRIPT: u32 = 256;
pub const ATTR_CMN_CRTIME: u32 = 512;
pub const ATTR_CMN_MODTIME: u32 = 1024;
pub const ATTR_CMN_CHGTIME: u32 = 2048;
pub const ATTR_CMN_ACCTIME: u32 = 4096;
pub const ATTR_CMN_BKUPTIME: u32 = 8192;
pub const ATTR_CMN_FNDRINFO: u32 = 16384;
pub const ATTR_CMN_OWNERID: u32 = 32768;
pub const ATTR_CMN_GRPID: u32 = 65536;
pub const ATTR_CMN_ACCESSMASK: u32 = 131072;
pub const ATTR_CMN_FLAGS: u32 = 262144;
pub const ATTR_CMN_GEN_COUNT: u32 = 524288;
pub const ATTR_CMN_DOCUMENT_ID: u32 = 1048576;
pub const ATTR_CMN_USERACCESS: u32 = 2097152;
pub const ATTR_CMN_EXTENDED_SECURITY: u32 = 4194304;
pub const ATTR_CMN_UUID: u32 = 8388608;
pub const ATTR_CMN_GRPUUID: u32 = 16777216;
pub const ATTR_CMN_FILEID: u32 = 33554432;
pub const ATTR_CMN_PARENTID: u32 = 67108864;
pub const ATTR_CMN_FULLPATH: u32 = 134217728;
pub const ATTR_CMN_ADDEDTIME: u32 = 268435456;
pub const ATTR_CMN_ERROR: u32 = 536870912;
pub const ATTR_CMN_DATA_PROTECT_FLAGS: u32 = 1073741824;
pub const ATTR_CMN_RETURNED_ATTRS: u32 = 2147483648;
pub const ATTR_CMN_VALIDMASK: u32 = 4294967295;
pub const ATTR_CMN_SETMASK: u32 = 1372061440;
pub const ATTR_CMN_VOLSETMASK: u32 = 26368;
pub const ATTR_VOL_FSTYPE: u32 = 1;
pub const ATTR_VOL_SIGNATURE: u32 = 2;
pub const ATTR_VOL_SIZE: u32 = 4;
pub const ATTR_VOL_SPACEFREE: u32 = 8;
pub const ATTR_VOL_SPACEAVAIL: u32 = 16;
pub const ATTR_VOL_MINALLOCATION: u32 = 32;
pub const ATTR_VOL_ALLOCATIONCLUMP: u32 = 64;
pub const ATTR_VOL_IOBLOCKSIZE: u32 = 128;
pub const ATTR_VOL_OBJCOUNT: u32 = 256;
pub const ATTR_VOL_FILECOUNT: u32 = 512;
pub const ATTR_VOL_DIRCOUNT: u32 = 1024;
pub const ATTR_VOL_MAXOBJCOUNT: u32 = 2048;
pub const ATTR_VOL_MOUNTPOINT: u32 = 4096;
pub const ATTR_VOL_NAME: u32 = 8192;
pub const ATTR_VOL_MOUNTFLAGS: u32 = 16384;
pub const ATTR_VOL_MOUNTEDDEVICE: u32 = 32768;
pub const ATTR_VOL_ENCODINGSUSED: u32 = 65536;
pub const ATTR_VOL_CAPABILITIES: u32 = 131072;
pub const ATTR_VOL_UUID: u32 = 262144;
pub const ATTR_VOL_QUOTA_SIZE: u32 = 268435456;
pub const ATTR_VOL_RESERVED_SIZE: u32 = 536870912;
pub const ATTR_VOL_ATTRIBUTES: u32 = 1073741824;
pub const ATTR_VOL_INFO: u32 = 2147483648;
pub const ATTR_VOL_VALIDMASK: u32 = 4027056127;
pub const ATTR_VOL_SETMASK: u32 = 2147491840;
pub const ATTR_DIR_LINKCOUNT: u32 = 1;
pub const ATTR_DIR_ENTRYCOUNT: u32 = 2;
pub const ATTR_DIR_MOUNTSTATUS: u32 = 4;
pub const ATTR_DIR_ALLOCSIZE: u32 = 8;
pub const ATTR_DIR_IOBLOCKSIZE: u32 = 16;
pub const ATTR_DIR_DATALENGTH: u32 = 32;
pub const DIR_MNTSTATUS_MNTPOINT: u32 = 1;
pub const DIR_MNTSTATUS_TRIGGER: u32 = 2;
pub const ATTR_DIR_VALIDMASK: u32 = 63;
pub const ATTR_DIR_SETMASK: u32 = 0;
pub const ATTR_FILE_LINKCOUNT: u32 = 1;
pub const ATTR_FILE_TOTALSIZE: u32 = 2;
pub const ATTR_FILE_ALLOCSIZE: u32 = 4;
pub const ATTR_FILE_IOBLOCKSIZE: u32 = 8;
pub const ATTR_FILE_DEVTYPE: u32 = 32;
pub const ATTR_FILE_FORKCOUNT: u32 = 128;
pub const ATTR_FILE_FORKLIST: u32 = 256;
pub const ATTR_FILE_DATALENGTH: u32 = 512;
pub const ATTR_FILE_DATAALLOCSIZE: u32 = 1024;
pub const ATTR_FILE_RSRCLENGTH: u32 = 4096;
pub const ATTR_FILE_RSRCALLOCSIZE: u32 = 8192;
pub const ATTR_FILE_VALIDMASK: u32 = 14335;
pub const ATTR_FILE_SETMASK: u32 = 32;
pub const ATTR_CMNEXT_RELPATH: u32 = 4;
pub const ATTR_CMNEXT_PRIVATESIZE: u32 = 8;
pub const ATTR_CMNEXT_LINKID: u32 = 16;
pub const ATTR_CMNEXT_NOFIRMLINKPATH: u32 = 32;
pub const ATTR_CMNEXT_REALDEVID: u32 = 64;
pub const ATTR_CMNEXT_REALFSID: u32 = 128;
pub const ATTR_CMNEXT_CLONEID: u32 = 256;
pub const ATTR_CMNEXT_EXT_FLAGS: u32 = 512;
pub const ATTR_CMNEXT_RECURSIVE_GENCOUNT: u32 = 1024;
pub const ATTR_CMNEXT_VALIDMASK: u32 = 2044;
pub const ATTR_CMNEXT_SETMASK: u32 = 0;
pub const ATTR_FORK_TOTALSIZE: u32 = 1;
pub const ATTR_FORK_ALLOCSIZE: u32 = 2;
pub const ATTR_FORK_RESERVED: u32 = 4294967295;
pub const ATTR_FORK_VALIDMASK: u32 = 3;
pub const ATTR_FORK_SETMASK: u32 = 0;
pub const ATTR_CMN_NAMEDATTRCOUNT: u32 = 524288;
pub const ATTR_CMN_NAMEDATTRLIST: u32 = 1048576;
pub const ATTR_FILE_CLUMPSIZE: u32 = 16;
pub const ATTR_FILE_FILETYPE: u32 = 64;
pub const ATTR_FILE_DATAEXTENTS: u32 = 2048;
pub const ATTR_FILE_RSRCEXTENTS: u32 = 16384;
pub const ATTR_BULK_REQUIRED: u32 = 2147483649;
pub const SRCHFS_START: u32 = 1;
pub const SRCHFS_MATCHPARTIALNAMES: u32 = 2;
pub const SRCHFS_MATCHDIRS: u32 = 4;
pub const SRCHFS_MATCHFILES: u32 = 8;
pub const SRCHFS_SKIPLINKS: u32 = 16;
pub const SRCHFS_SKIPINVISIBLE: u32 = 32;
pub const SRCHFS_SKIPPACKAGES: u32 = 64;
pub const SRCHFS_SKIPINAPPROPRIATE: u32 = 128;
pub const SRCHFS_NEGATEPARAMS: u32 = 2147483648;
pub const SRCHFS_VALIDOPTIONSMASK: u32 = 2147483903;
pub const FST_EOF: i32 = -1;
pub const MFSNAMELEN: u32 = 15;
pub const MFSTYPENAMELEN: u32 = 16;
pub const MNAMELEN: u32 = 1024;
pub const MNT_EXT_ROOT_DATA_VOL: u32 = 1;
pub const MNT_RDONLY: u32 = 1;
pub const MNT_SYNCHRONOUS: u32 = 2;
pub const MNT_NOEXEC: u32 = 4;
pub const MNT_NOSUID: u32 = 8;
pub const MNT_NODEV: u32 = 16;
pub const MNT_UNION: u32 = 32;
pub const MNT_ASYNC: u32 = 64;
pub const MNT_CPROTECT: u32 = 128;
pub const MNT_EXPORTED: u32 = 256;
pub const MNT_REMOVABLE: u32 = 512;
pub const MNT_QUARANTINE: u32 = 1024;
pub const MNT_LOCAL: u32 = 4096;
pub const MNT_QUOTA: u32 = 8192;
pub const MNT_ROOTFS: u32 = 16384;
pub const MNT_DOVOLFS: u32 = 32768;
pub const MNT_DONTBROWSE: u32 = 1048576;
pub const MNT_IGNORE_OWNERSHIP: u32 = 2097152;
pub const MNT_AUTOMOUNTED: u32 = 4194304;
pub const MNT_JOURNALED: u32 = 8388608;
pub const MNT_NOUSERXATTR: u32 = 16777216;
pub const MNT_DEFWRITE: u32 = 33554432;
pub const MNT_MULTILABEL: u32 = 67108864;
pub const MNT_NOATIME: u32 = 268435456;
pub const MNT_SNAPSHOT: u32 = 1073741824;
pub const MNT_STRICTATIME: u32 = 2147483648;
pub const MNT_UNKNOWNPERMISSIONS: u32 = 2097152;
pub const MNT_VISFLAGMASK: u32 = 3622893567;
pub const MNT_UPDATE: u32 = 65536;
pub const MNT_NOBLOCK: u32 = 131072;
pub const MNT_RELOAD: u32 = 262144;
pub const MNT_FORCE: u32 = 524288;
pub const MNT_CMDFLAGS: u32 = 983040;
pub const VFS_GENERIC: u32 = 0;
pub const VFS_NUMMNTOPS: u32 = 1;
pub const VFS_MAXTYPENUM: u32 = 1;
pub const VFS_CONF: u32 = 2;
pub const MNT_WAIT: u32 = 1;
pub const MNT_NOWAIT: u32 = 2;
pub const MNT_DWAIT: u32 = 4;
pub const VFS_CTL_VERS1: u32 = 1;
pub const VFS_CTL_OSTATFS: u32 = 65537;
pub const VFS_CTL_UMOUNT: u32 = 65538;
pub const VFS_CTL_QUERY: u32 = 65539;
pub const VFS_CTL_NEWADDR: u32 = 65540;
pub const VFS_CTL_TIMEO: u32 = 65541;
pub const VFS_CTL_NOLOCKS: u32 = 65542;
pub const VFS_CTL_SADDR: u32 = 65543;
pub const VFS_CTL_DISC: u32 = 65544;
pub const VFS_CTL_SERVERINFO: u32 = 65545;
pub const VFS_CTL_NSTATUS: u32 = 65546;
pub const VFS_CTL_STATFS64: u32 = 65547;
pub const VFS_CTL_STATFS: u32 = 65547;
pub const VQ_NOTRESP: u32 = 1;
pub const VQ_NEEDAUTH: u32 = 2;
pub const VQ_LOWDISK: u32 = 4;
pub const VQ_MOUNT: u32 = 8;
pub const VQ_UNMOUNT: u32 = 16;
pub const VQ_DEAD: u32 = 32;
pub const VQ_ASSIST: u32 = 64;
pub const VQ_NOTRESPLOCK: u32 = 128;
pub const VQ_UPDATE: u32 = 256;
pub const VQ_VERYLOWDISK: u32 = 512;
pub const VQ_SYNCEVENT: u32 = 1024;
pub const VQ_SERVEREVENT: u32 = 2048;
pub const VQ_QUOTA: u32 = 4096;
pub const VQ_NEARLOWDISK: u32 = 8192;
pub const VQ_DESIRED_DISK: u32 = 16384;
pub const VQ_FREE_SPACE_CHANGE: u32 = 32768;
pub const VQ_FLAG10000: u32 = 65536;
pub const NFSV4_MAX_FH_SIZE: u32 = 128;
pub const NFSV3_MAX_FH_SIZE: u32 = 64;
pub const NFSV2_MAX_FH_SIZE: u32 = 32;
pub const S_IFMT: u32 = 61440;
pub const S_IFIFO: u32 = 4096;
pub const S_IFCHR: u32 = 8192;
pub const S_IFDIR: u32 = 16384;
pub const S_IFBLK: u32 = 24576;
pub const S_IFREG: u32 = 32768;
pub const S_IFLNK: u32 = 40960;
pub const S_IFSOCK: u32 = 49152;
pub const S_IFWHT: u32 = 57344;
pub const S_IRWXU: u32 = 448;
pub const S_IRUSR: u32 = 256;
pub const S_IWUSR: u32 = 128;
pub const S_IXUSR: u32 = 64;
pub const S_IRWXG: u32 = 56;
pub const S_IRGRP: u32 = 32;
pub const S_IWGRP: u32 = 16;
pub const S_IXGRP: u32 = 8;
pub const S_IRWXO: u32 = 7;
pub const S_IROTH: u32 = 4;
pub const S_IWOTH: u32 = 2;
pub const S_IXOTH: u32 = 1;
pub const S_ISUID: u32 = 2048;
pub const S_ISGID: u32 = 1024;
pub const S_ISVTX: u32 = 512;
pub const S_ISTXT: u32 = 512;
pub const S_IREAD: u32 = 256;
pub const S_IWRITE: u32 = 128;
pub const S_IEXEC: u32 = 64;
pub const ACCESSPERMS: u32 = 511;
pub const ALLPERMS: u32 = 4095;
pub const DEFFILEMODE: u32 = 438;
pub const S_BLKSIZE: u32 = 512;
pub const UF_SETTABLE: u32 = 65535;
pub const UF_NODUMP: u32 = 1;
pub const UF_IMMUTABLE: u32 = 2;
pub const UF_APPEND: u32 = 4;
pub const UF_OPAQUE: u32 = 8;
pub const UF_COMPRESSED: u32 = 32;
pub const UF_TRACKED: u32 = 64;
pub const UF_DATAVAULT: u32 = 128;
pub const UF_HIDDEN: u32 = 32768;
pub const SF_SUPPORTED: u32 = 10420224;
pub const SF_SETTABLE: u32 = 1073676288;
pub const SF_SYNTHETIC: u32 = 3221225472;
pub const SF_ARCHIVED: u32 = 65536;
pub const SF_IMMUTABLE: u32 = 131072;
pub const SF_APPEND: u32 = 262144;
pub const SF_RESTRICTED: u32 = 524288;
pub const SF_NOUNLINK: u32 = 1048576;
pub const SF_FIRMLINK: u32 = 8388608;
pub const SF_DATALESS: u32 = 1073741824;
pub const EF_MAY_SHARE_BLOCKS: u32 = 1;
pub const EF_NO_XATTRS: u32 = 2;
pub const EF_IS_SYNC_ROOT: u32 = 4;
pub const EF_IS_PURGEABLE: u32 = 8;
pub const EF_IS_SPARSE: u32 = 16;
pub const UTIME_NOW: i32 = -1;
pub const UTIME_OMIT: i32 = -2;
pub const XATTR_NOFOLLOW: u32 = 1;
pub const XATTR_CREATE: u32 = 2;
pub const XATTR_REPLACE: u32 = 4;
pub const XATTR_NOSECURITY: u32 = 8;
pub const XATTR_NODEFAULT: u32 = 16;
pub const XATTR_SHOWCOMPRESSION: u32 = 32;
pub const XATTR_MAXNAMELEN: u32 = 127;
pub const XATTR_FINDERINFO_NAME: &'static [u8; 21usize] = b"com.apple.FinderInfo\0";
pub const XATTR_RESOURCEFORK_NAME: &'static [u8; 23usize] = b"com.apple.ResourceFork\0";
pub const API_TO_BE_DEPRECATED: u32 = 100000;
pub const KAUTH_GUID_SIZE: u32 = 16;
pub const KAUTH_NTSID_MAX_AUTHORITIES: u32 = 16;
pub const KAUTH_NTSID_HDRSIZE: u32 = 8;
pub const KAUTH_EXTLOOKUP_SUCCESS: u32 = 0;
pub const KAUTH_EXTLOOKUP_BADRQ: u32 = 1;
pub const KAUTH_EXTLOOKUP_FAILURE: u32 = 2;
pub const KAUTH_EXTLOOKUP_FATAL: u32 = 3;
pub const KAUTH_EXTLOOKUP_INPROG: u32 = 100;
pub const KAUTH_EXTLOOKUP_VALID_UID: u32 = 1;
pub const KAUTH_EXTLOOKUP_VALID_UGUID: u32 = 2;
pub const KAUTH_EXTLOOKUP_VALID_USID: u32 = 4;
pub const KAUTH_EXTLOOKUP_VALID_GID: u32 = 8;
pub const KAUTH_EXTLOOKUP_VALID_GGUID: u32 = 16;
pub const KAUTH_EXTLOOKUP_VALID_GSID: u32 = 32;
pub const KAUTH_EXTLOOKUP_WANT_UID: u32 = 64;
pub const KAUTH_EXTLOOKUP_WANT_UGUID: u32 = 128;
pub const KAUTH_EXTLOOKUP_WANT_USID: u32 = 256;
pub const KAUTH_EXTLOOKUP_WANT_GID: u32 = 512;
pub const KAUTH_EXTLOOKUP_WANT_GGUID: u32 = 1024;
pub const KAUTH_EXTLOOKUP_WANT_GSID: u32 = 2048;
pub const KAUTH_EXTLOOKUP_WANT_MEMBERSHIP: u32 = 4096;
pub const KAUTH_EXTLOOKUP_VALID_MEMBERSHIP: u32 = 8192;
pub const KAUTH_EXTLOOKUP_ISMEMBER: u32 = 16384;
pub const KAUTH_EXTLOOKUP_VALID_PWNAM: u32 = 32768;
pub const KAUTH_EXTLOOKUP_WANT_PWNAM: u32 = 65536;
pub const KAUTH_EXTLOOKUP_VALID_GRNAM: u32 = 131072;
pub const KAUTH_EXTLOOKUP_WANT_GRNAM: u32 = 262144;
pub const KAUTH_EXTLOOKUP_VALID_SUPGRPS: u32 = 524288;
pub const KAUTH_EXTLOOKUP_WANT_SUPGRPS: u32 = 1048576;
pub const KAUTH_EXTLOOKUP_REGISTER: u32 = 0;
pub const KAUTH_EXTLOOKUP_RESULT: u32 = 1;
pub const KAUTH_EXTLOOKUP_WORKER: u32 = 2;
pub const KAUTH_EXTLOOKUP_DEREGISTER: u32 = 4;
pub const KAUTH_GET_CACHE_SIZES: u32 = 8;
pub const KAUTH_SET_CACHE_SIZES: u32 = 16;
pub const KAUTH_CLEAR_CACHES: u32 = 32;
pub const IDENTITYSVC_ENTITLEMENT: &'static [u8; 30usize] = b"com.apple.private.identitysvc\0";
pub const KAUTH_ACE_KINDMASK: u32 = 15;
pub const KAUTH_ACE_PERMIT: u32 = 1;
pub const KAUTH_ACE_DENY: u32 = 2;
pub const KAUTH_ACE_AUDIT: u32 = 3;
pub const KAUTH_ACE_ALARM: u32 = 4;
pub const KAUTH_ACE_INHERITED: u32 = 16;
pub const KAUTH_ACE_FILE_INHERIT: u32 = 32;
pub const KAUTH_ACE_DIRECTORY_INHERIT: u32 = 64;
pub const KAUTH_ACE_LIMIT_INHERIT: u32 = 128;
pub const KAUTH_ACE_ONLY_INHERIT: u32 = 256;
pub const KAUTH_ACE_SUCCESS: u32 = 512;
pub const KAUTH_ACE_FAILURE: u32 = 1024;
pub const KAUTH_ACE_INHERIT_CONTROL_FLAGS: u32 = 480;
pub const KAUTH_ACE_GENERIC_ALL: u32 = 2097152;
pub const KAUTH_ACE_GENERIC_EXECUTE: u32 = 4194304;
pub const KAUTH_ACE_GENERIC_WRITE: u32 = 8388608;
pub const KAUTH_ACE_GENERIC_READ: u32 = 16777216;
pub const KAUTH_ACL_MAX_ENTRIES: u32 = 128;
pub const KAUTH_ACL_FLAGS_PRIVATE: u32 = 65535;
pub const KAUTH_ACL_DEFER_INHERIT: u32 = 65536;
pub const KAUTH_ACL_NO_INHERIT: u32 = 131072;
pub const KAUTH_FILESEC_MAGIC: u32 = 19710317;
pub const KAUTH_FILESEC_FLAGS_PRIVATE: u32 = 65535;
pub const KAUTH_FILESEC_DEFER_INHERIT: u32 = 65536;
pub const KAUTH_FILESEC_NO_INHERIT: u32 = 131072;
pub const KAUTH_FILESEC_XATTR: &'static [u8; 26usize] = b"com.apple.system.Security\0";
pub const KAUTH_ENDIAN_HOST: u32 = 1;
pub const KAUTH_ENDIAN_DISK: u32 = 2;
pub const KAUTH_VNODE_READ_DATA: u32 = 2;
pub const KAUTH_VNODE_LIST_DIRECTORY: u32 = 2;
pub const KAUTH_VNODE_WRITE_DATA: u32 = 4;
pub const KAUTH_VNODE_ADD_FILE: u32 = 4;
pub const KAUTH_VNODE_EXECUTE: u32 = 8;
pub const KAUTH_VNODE_SEARCH: u32 = 8;
pub const KAUTH_VNODE_DELETE: u32 = 16;
pub const KAUTH_VNODE_APPEND_DATA: u32 = 32;
pub const KAUTH_VNODE_ADD_SUBDIRECTORY: u32 = 32;
pub const KAUTH_VNODE_DELETE_CHILD: u32 = 64;
pub const KAUTH_VNODE_READ_ATTRIBUTES: u32 = 128;
pub const KAUTH_VNODE_WRITE_ATTRIBUTES: u32 = 256;
pub const KAUTH_VNODE_READ_EXTATTRIBUTES: u32 = 512;
pub const KAUTH_VNODE_WRITE_EXTATTRIBUTES: u32 = 1024;
pub const KAUTH_VNODE_READ_SECURITY: u32 = 2048;
pub const KAUTH_VNODE_WRITE_SECURITY: u32 = 4096;
pub const KAUTH_VNODE_TAKE_OWNERSHIP: u32 = 8192;
pub const KAUTH_VNODE_CHANGE_OWNER: u32 = 8192;
pub const KAUTH_VNODE_SYNCHRONIZE: u32 = 1048576;
pub const KAUTH_VNODE_LINKTARGET: u32 = 33554432;
pub const KAUTH_VNODE_CHECKIMMUTABLE: u32 = 67108864;
pub const KAUTH_VNODE_ACCESS: u32 = 2147483648;
pub const KAUTH_VNODE_NOIMMUTABLE: u32 = 1073741824;
pub const KAUTH_VNODE_SEARCHBYANYONE: u32 = 536870912;
pub const KAUTH_VNODE_GENERIC_READ_BITS: u32 = 2690;
pub const KAUTH_VNODE_GENERIC_WRITE_BITS: u32 = 5492;
pub const KAUTH_VNODE_GENERIC_EXECUTE_BITS: u32 = 8;
pub const KAUTH_VNODE_GENERIC_ALL_BITS: u32 = 8190;
pub const KAUTH_VNODE_WRITE_RIGHTS: u32 = 100676980;
pub const __DARWIN_ACL_READ_DATA: u32 = 2;
pub const __DARWIN_ACL_LIST_DIRECTORY: u32 = 2;
pub const __DARWIN_ACL_WRITE_DATA: u32 = 4;
pub const __DARWIN_ACL_ADD_FILE: u32 = 4;
pub const __DARWIN_ACL_EXECUTE: u32 = 8;
pub const __DARWIN_ACL_SEARCH: u32 = 8;
pub const __DARWIN_ACL_DELETE: u32 = 16;
pub const __DARWIN_ACL_APPEND_DATA: u32 = 32;
pub const __DARWIN_ACL_ADD_SUBDIRECTORY: u32 = 32;
pub const __DARWIN_ACL_DELETE_CHILD: u32 = 64;
pub const __DARWIN_ACL_READ_ATTRIBUTES: u32 = 128;
pub const __DARWIN_ACL_WRITE_ATTRIBUTES: u32 = 256;
pub const __DARWIN_ACL_READ_EXTATTRIBUTES: u32 = 512;
pub const __DARWIN_ACL_WRITE_EXTATTRIBUTES: u32 = 1024;
pub const __DARWIN_ACL_READ_SECURITY: u32 = 2048;
pub const __DARWIN_ACL_WRITE_SECURITY: u32 = 4096;
pub const __DARWIN_ACL_CHANGE_OWNER: u32 = 8192;
pub const __DARWIN_ACL_SYNCHRONIZE: u32 = 1048576;
pub const __DARWIN_ACL_EXTENDED_ALLOW: u32 = 1;
pub const __DARWIN_ACL_EXTENDED_DENY: u32 = 2;
pub const __DARWIN_ACL_ENTRY_INHERITED: u32 = 16;
pub const __DARWIN_ACL_ENTRY_FILE_INHERIT: u32 = 32;
pub const __DARWIN_ACL_ENTRY_DIRECTORY_INHERIT: u32 = 64;
pub const __DARWIN_ACL_ENTRY_LIMIT_INHERIT: u32 = 128;
pub const __DARWIN_ACL_ENTRY_ONLY_INHERIT: u32 = 256;
pub const __DARWIN_ACL_FLAG_NO_INHERIT: u32 = 131072;
pub const ACL_MAX_ENTRIES: u32 = 128;
pub type int_least8_t = i8;
pub type int_least16_t = i16;
pub type int_least32_t = i32;
pub type int_least64_t = i64;
pub type uint_least8_t = u8;
pub type uint_least16_t = u16;
pub type uint_least32_t = u32;
pub type uint_least64_t = u64;
pub type int_fast8_t = i8;
pub type int_fast16_t = i16;
pub type int_fast32_t = i32;
pub type int_fast64_t = i64;
pub type uint_fast8_t = u8;
pub type uint_fast16_t = u16;
pub type uint_fast32_t = u32;
pub type uint_fast64_t = u64;
pub type __int8_t = ::std::os::raw::c_schar;
pub type __uint8_t = ::std::os::raw::c_uchar;
pub type __int16_t = ::std::os::raw::c_short;
pub type __uint16_t = ::std::os::raw::c_ushort;
pub type __int32_t = ::std::os::raw::c_int;
pub type __uint32_t = ::std::os::raw::c_uint;
pub type __int64_t = ::std::os::raw::c_longlong;
pub type __uint64_t = ::std::os::raw::c_ulonglong;
pub type __darwin_intptr_t = ::std::os::raw::c_long;
pub type __darwin_natural_t = ::std::os::raw::c_uint;
pub type __darwin_ct_rune_t = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Copy, Clone)]
pub union __mbstate_t {
    pub __mbstate8: [::std::os::raw::c_char; 128usize],
    pub _mbstateL: ::std::os::raw::c_longlong,
    _bindgen_union_align: [u64; 16usize],
}
#[test]
fn bindgen_test_layout___mbstate_t() {
    assert_eq!(
        ::std::mem::size_of::<__mbstate_t>(),
        128usize,
        concat!("Size of: ", stringify!(__mbstate_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__mbstate_t>(),
        8usize,
        concat!("Alignment of ", stringify!(__mbstate_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__mbstate_t>())).__mbstate8 as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__mbstate_t),
            "::",
            stringify!(__mbstate8)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__mbstate_t>()))._mbstateL as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__mbstate_t),
            "::",
            stringify!(_mbstateL)
        )
    );
}
pub type __darwin_mbstate_t = __mbstate_t;
pub type __darwin_ptrdiff_t = ::std::os::raw::c_long;
pub type __darwin_size_t = ::std::os::raw::c_ulong;
pub type __darwin_va_list = __builtin_va_list;
pub type __darwin_wchar_t = ::std::os::raw::c_int;
pub type __darwin_rune_t = __darwin_wchar_t;
pub type __darwin_wint_t = ::std::os::raw::c_int;
pub type __darwin_clock_t = ::std::os::raw::c_ulong;
pub type __darwin_socklen_t = __uint32_t;
pub type __darwin_ssize_t = ::std::os::raw::c_long;
pub type __darwin_time_t = ::std::os::raw::c_long;
pub type __darwin_blkcnt_t = __int64_t;
pub type __darwin_blksize_t = __int32_t;
pub type __darwin_dev_t = __int32_t;
pub type __darwin_fsblkcnt_t = ::std::os::raw::c_uint;
pub type __darwin_fsfilcnt_t = ::std::os::raw::c_uint;
pub type __darwin_gid_t = __uint32_t;
pub type __darwin_id_t = __uint32_t;
pub type __darwin_ino64_t = __uint64_t;
pub type __darwin_ino_t = __darwin_ino64_t;
pub type __darwin_mach_port_name_t = __darwin_natural_t;
pub type __darwin_mach_port_t = __darwin_mach_port_name_t;
pub type __darwin_mode_t = __uint16_t;
pub type __darwin_off_t = __int64_t;
pub type __darwin_pid_t = __int32_t;
pub type __darwin_sigset_t = __uint32_t;
pub type __darwin_suseconds_t = __int32_t;
pub type __darwin_uid_t = __uint32_t;
pub type __darwin_useconds_t = __uint32_t;
pub type __darwin_uuid_t = [::std::os::raw::c_uchar; 16usize];
pub type __darwin_uuid_string_t = [::std::os::raw::c_char; 37usize];
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_pthread_handler_rec {
    pub __routine: ::std::option::Option<unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_void)>,
    pub __arg: *mut ::std::os::raw::c_void,
    pub __next: *mut __darwin_pthread_handler_rec,
}
#[test]
fn bindgen_test_layout___darwin_pthread_handler_rec() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_pthread_handler_rec>(),
        24usize,
        concat!("Size of: ", stringify!(__darwin_pthread_handler_rec))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_pthread_handler_rec>(),
        8usize,
        concat!("Alignment of ", stringify!(__darwin_pthread_handler_rec))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_pthread_handler_rec>())).__routine as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_pthread_handler_rec),
            "::",
            stringify!(__routine)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_pthread_handler_rec>())).__arg as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_pthread_handler_rec),
            "::",
            stringify!(__arg)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_pthread_handler_rec>())).__next as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_pthread_handler_rec),
            "::",
            stringify!(__next)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _opaque_pthread_attr_t {
    pub __sig: ::std::os::raw::c_long,
    pub __opaque: [::std::os::raw::c_char; 56usize],
}
#[test]
fn bindgen_test_layout__opaque_pthread_attr_t() {
    assert_eq!(
        ::std::mem::size_of::<_opaque_pthread_attr_t>(),
        64usize,
        concat!("Size of: ", stringify!(_opaque_pthread_attr_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_opaque_pthread_attr_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_opaque_pthread_attr_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_opaque_pthread_attr_t>())).__sig as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_attr_t),
            "::",
            stringify!(__sig)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_opaque_pthread_attr_t>())).__opaque as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_attr_t),
            "::",
            stringify!(__opaque)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _opaque_pthread_cond_t {
    pub __sig: ::std::os::raw::c_long,
    pub __opaque: [::std::os::raw::c_char; 40usize],
}
#[test]
fn bindgen_test_layout__opaque_pthread_cond_t() {
    assert_eq!(
        ::std::mem::size_of::<_opaque_pthread_cond_t>(),
        48usize,
        concat!("Size of: ", stringify!(_opaque_pthread_cond_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_opaque_pthread_cond_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_opaque_pthread_cond_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_opaque_pthread_cond_t>())).__sig as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_cond_t),
            "::",
            stringify!(__sig)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_opaque_pthread_cond_t>())).__opaque as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_cond_t),
            "::",
            stringify!(__opaque)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _opaque_pthread_condattr_t {
    pub __sig: ::std::os::raw::c_long,
    pub __opaque: [::std::os::raw::c_char; 8usize],
}
#[test]
fn bindgen_test_layout__opaque_pthread_condattr_t() {
    assert_eq!(
        ::std::mem::size_of::<_opaque_pthread_condattr_t>(),
        16usize,
        concat!("Size of: ", stringify!(_opaque_pthread_condattr_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_opaque_pthread_condattr_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_opaque_pthread_condattr_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_opaque_pthread_condattr_t>())).__sig as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_condattr_t),
            "::",
            stringify!(__sig)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_opaque_pthread_condattr_t>())).__opaque as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_condattr_t),
            "::",
            stringify!(__opaque)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _opaque_pthread_mutex_t {
    pub __sig: ::std::os::raw::c_long,
    pub __opaque: [::std::os::raw::c_char; 56usize],
}
#[test]
fn bindgen_test_layout__opaque_pthread_mutex_t() {
    assert_eq!(
        ::std::mem::size_of::<_opaque_pthread_mutex_t>(),
        64usize,
        concat!("Size of: ", stringify!(_opaque_pthread_mutex_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_opaque_pthread_mutex_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_opaque_pthread_mutex_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_opaque_pthread_mutex_t>())).__sig as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_mutex_t),
            "::",
            stringify!(__sig)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_opaque_pthread_mutex_t>())).__opaque as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_mutex_t),
            "::",
            stringify!(__opaque)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _opaque_pthread_mutexattr_t {
    pub __sig: ::std::os::raw::c_long,
    pub __opaque: [::std::os::raw::c_char; 8usize],
}
#[test]
fn bindgen_test_layout__opaque_pthread_mutexattr_t() {
    assert_eq!(
        ::std::mem::size_of::<_opaque_pthread_mutexattr_t>(),
        16usize,
        concat!("Size of: ", stringify!(_opaque_pthread_mutexattr_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_opaque_pthread_mutexattr_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_opaque_pthread_mutexattr_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_opaque_pthread_mutexattr_t>())).__sig as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_mutexattr_t),
            "::",
            stringify!(__sig)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_opaque_pthread_mutexattr_t>())).__opaque as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_mutexattr_t),
            "::",
            stringify!(__opaque)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _opaque_pthread_once_t {
    pub __sig: ::std::os::raw::c_long,
    pub __opaque: [::std::os::raw::c_char; 8usize],
}
#[test]
fn bindgen_test_layout__opaque_pthread_once_t() {
    assert_eq!(
        ::std::mem::size_of::<_opaque_pthread_once_t>(),
        16usize,
        concat!("Size of: ", stringify!(_opaque_pthread_once_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_opaque_pthread_once_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_opaque_pthread_once_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_opaque_pthread_once_t>())).__sig as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_once_t),
            "::",
            stringify!(__sig)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_opaque_pthread_once_t>())).__opaque as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_once_t),
            "::",
            stringify!(__opaque)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _opaque_pthread_rwlock_t {
    pub __sig: ::std::os::raw::c_long,
    pub __opaque: [::std::os::raw::c_char; 192usize],
}
#[test]
fn bindgen_test_layout__opaque_pthread_rwlock_t() {
    assert_eq!(
        ::std::mem::size_of::<_opaque_pthread_rwlock_t>(),
        200usize,
        concat!("Size of: ", stringify!(_opaque_pthread_rwlock_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_opaque_pthread_rwlock_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_opaque_pthread_rwlock_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_opaque_pthread_rwlock_t>())).__sig as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_rwlock_t),
            "::",
            stringify!(__sig)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_opaque_pthread_rwlock_t>())).__opaque as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_rwlock_t),
            "::",
            stringify!(__opaque)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _opaque_pthread_rwlockattr_t {
    pub __sig: ::std::os::raw::c_long,
    pub __opaque: [::std::os::raw::c_char; 16usize],
}
#[test]
fn bindgen_test_layout__opaque_pthread_rwlockattr_t() {
    assert_eq!(
        ::std::mem::size_of::<_opaque_pthread_rwlockattr_t>(),
        24usize,
        concat!("Size of: ", stringify!(_opaque_pthread_rwlockattr_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_opaque_pthread_rwlockattr_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_opaque_pthread_rwlockattr_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_opaque_pthread_rwlockattr_t>())).__sig as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_rwlockattr_t),
            "::",
            stringify!(__sig)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_opaque_pthread_rwlockattr_t>())).__opaque as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_rwlockattr_t),
            "::",
            stringify!(__opaque)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _opaque_pthread_t {
    pub __sig: ::std::os::raw::c_long,
    pub __cleanup_stack: *mut __darwin_pthread_handler_rec,
    pub __opaque: [::std::os::raw::c_char; 8176usize],
}
#[test]
fn bindgen_test_layout__opaque_pthread_t() {
    assert_eq!(
        ::std::mem::size_of::<_opaque_pthread_t>(),
        8192usize,
        concat!("Size of: ", stringify!(_opaque_pthread_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_opaque_pthread_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_opaque_pthread_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_opaque_pthread_t>())).__sig as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_t),
            "::",
            stringify!(__sig)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_opaque_pthread_t>())).__cleanup_stack as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_t),
            "::",
            stringify!(__cleanup_stack)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_opaque_pthread_t>())).__opaque as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_t),
            "::",
            stringify!(__opaque)
        )
    );
}
pub type __darwin_pthread_attr_t = _opaque_pthread_attr_t;
pub type __darwin_pthread_cond_t = _opaque_pthread_cond_t;
pub type __darwin_pthread_condattr_t = _opaque_pthread_condattr_t;
pub type __darwin_pthread_key_t = ::std::os::raw::c_ulong;
pub type __darwin_pthread_mutex_t = _opaque_pthread_mutex_t;
pub type __darwin_pthread_mutexattr_t = _opaque_pthread_mutexattr_t;
pub type __darwin_pthread_once_t = _opaque_pthread_once_t;
pub type __darwin_pthread_rwlock_t = _opaque_pthread_rwlock_t;
pub type __darwin_pthread_rwlockattr_t = _opaque_pthread_rwlockattr_t;
pub type __darwin_pthread_t = *mut _opaque_pthread_t;
pub type u_int8_t = ::std::os::raw::c_uchar;
pub type u_int16_t = ::std::os::raw::c_ushort;
pub type u_int32_t = ::std::os::raw::c_uint;
pub type u_int64_t = ::std::os::raw::c_ulonglong;
pub type register_t = i64;
pub type user_addr_t = u_int64_t;
pub type user_size_t = u_int64_t;
pub type user_ssize_t = i64;
pub type user_long_t = i64;
pub type user_ulong_t = u_int64_t;
pub type user_time_t = i64;
pub type user_off_t = i64;
pub type syscall_arg_t = u_int64_t;
pub type intmax_t = ::std::os::raw::c_long;
pub type uintmax_t = ::std::os::raw::c_ulong;
pub const CSMAGIC_REQUIREMENT: ::std::os::raw::c_uint = 4208856064;
pub const CSMAGIC_REQUIREMENTS: ::std::os::raw::c_uint = 4208856065;
pub const CSMAGIC_CODEDIRECTORY: ::std::os::raw::c_uint = 4208856066;
pub const CSMAGIC_EMBEDDED_SIGNATURE: ::std::os::raw::c_uint = 4208856256;
pub const CSMAGIC_EMBEDDED_SIGNATURE_OLD: ::std::os::raw::c_uint = 4208855810;
pub const CSMAGIC_EMBEDDED_ENTITLEMENTS: ::std::os::raw::c_uint = 4208882033;
pub const CSMAGIC_DETACHED_SIGNATURE: ::std::os::raw::c_uint = 4208856257;
pub const CSMAGIC_BLOBWRAPPER: ::std::os::raw::c_uint = 4208855809;
pub const CS_SUPPORTSSCATTER: ::std::os::raw::c_uint = 131328;
pub const CS_SUPPORTSTEAMID: ::std::os::raw::c_uint = 131584;
pub const CS_SUPPORTSCODELIMIT64: ::std::os::raw::c_uint = 131840;
pub const CS_SUPPORTSEXECSEG: ::std::os::raw::c_uint = 132096;
pub const CS_SUPPORTSRUNTIME: ::std::os::raw::c_uint = 132352;
pub const CS_SUPPORTSLINKAGE: ::std::os::raw::c_uint = 132608;
pub const CSSLOT_CODEDIRECTORY: ::std::os::raw::c_uint = 0;
pub const CSSLOT_INFOSLOT: ::std::os::raw::c_uint = 1;
pub const CSSLOT_REQUIREMENTS: ::std::os::raw::c_uint = 2;
pub const CSSLOT_RESOURCEDIR: ::std::os::raw::c_uint = 3;
pub const CSSLOT_APPLICATION: ::std::os::raw::c_uint = 4;
pub const CSSLOT_ENTITLEMENTS: ::std::os::raw::c_uint = 5;
pub const CSSLOT_ALTERNATE_CODEDIRECTORIES: ::std::os::raw::c_uint = 4096;
pub const CSSLOT_ALTERNATE_CODEDIRECTORY_MAX: ::std::os::raw::c_uint = 5;
pub const CSSLOT_ALTERNATE_CODEDIRECTORY_LIMIT: ::std::os::raw::c_uint = 4101;
pub const CSSLOT_SIGNATURESLOT: ::std::os::raw::c_uint = 65536;
pub const CSSLOT_IDENTIFICATIONSLOT: ::std::os::raw::c_uint = 65537;
pub const CSSLOT_TICKETSLOT: ::std::os::raw::c_uint = 65538;
pub const CSTYPE_INDEX_REQUIREMENTS: ::std::os::raw::c_uint = 2;
pub const CSTYPE_INDEX_ENTITLEMENTS: ::std::os::raw::c_uint = 5;
pub const CS_HASHTYPE_SHA1: ::std::os::raw::c_uint = 1;
pub const CS_HASHTYPE_SHA256: ::std::os::raw::c_uint = 2;
pub const CS_HASHTYPE_SHA256_TRUNCATED: ::std::os::raw::c_uint = 3;
pub const CS_HASHTYPE_SHA384: ::std::os::raw::c_uint = 4;
pub const CS_SHA1_LEN: ::std::os::raw::c_uint = 20;
pub const CS_SHA256_LEN: ::std::os::raw::c_uint = 32;
pub const CS_SHA256_TRUNCATED_LEN: ::std::os::raw::c_uint = 20;
pub const CS_CDHASH_LEN: ::std::os::raw::c_uint = 20;
pub const CS_HASH_MAX_SIZE: ::std::os::raw::c_uint = 48;
pub const CS_SIGNER_TYPE_UNKNOWN: ::std::os::raw::c_uint = 0;
pub const CS_SIGNER_TYPE_LEGACYVPN: ::std::os::raw::c_uint = 5;
pub const CS_SIGNER_TYPE_MAC_APP_STORE: ::std::os::raw::c_uint = 6;
pub const CS_SUPPL_SIGNER_TYPE_UNKNOWN: ::std::os::raw::c_uint = 0;
pub const CS_SUPPL_SIGNER_TYPE_TRUSTCACHE: ::std::os::raw::c_uint = 7;
pub const CS_SUPPL_SIGNER_TYPE_LOCAL: ::std::os::raw::c_uint = 8;
pub type _bindgen_ty_1 = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug)]
pub struct __CodeDirectory {
    pub magic: u32,
    pub length: u32,
    pub version: u32,
    pub flags: u32,
    pub hashOffset: u32,
    pub identOffset: u32,
    pub nSpecialSlots: u32,
    pub nCodeSlots: u32,
    pub codeLimit: u32,
    pub hashSize: u8,
    pub hashType: u8,
    pub platform: u8,
    pub pageSize: u8,
    pub spare2: u32,
    pub end_earliest: __IncompleteArrayField<::std::os::raw::c_char>,
    pub scatterOffset: u32,
    pub end_withScatter: __IncompleteArrayField<::std::os::raw::c_char>,
    pub teamOffset: u32,
    pub end_withTeam: __IncompleteArrayField<::std::os::raw::c_char>,
    pub spare3: u32,
    pub codeLimit64: u64,
    pub end_withCodeLimit64: __IncompleteArrayField<::std::os::raw::c_char>,
    pub execSegBase: u64,
    pub execSegLimit: u64,
    pub execSegFlags: u64,
    pub end_withExecSeg: __IncompleteArrayField<::std::os::raw::c_char>,
    pub runtime: u32,
    pub preEncryptOffset: u32,
    pub end_withPreEncryptOffset: __IncompleteArrayField<::std::os::raw::c_char>,
    pub linkageHashType: u8,
    pub linkageTruncated: u8,
    pub spare4: u16,
    pub linkageOffset: u32,
    pub linkageSize: u32,
    pub end_withLinkage: __IncompleteArrayField<::std::os::raw::c_char>,
}
#[test]
fn bindgen_test_layout___CodeDirectory() {
    assert_eq!(
        ::std::mem::size_of::<__CodeDirectory>(),
        112usize,
        concat!("Size of: ", stringify!(__CodeDirectory))
    );
    assert_eq!(
        ::std::mem::align_of::<__CodeDirectory>(),
        8usize,
        concat!("Alignment of ", stringify!(__CodeDirectory))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__CodeDirectory>())).magic as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__CodeDirectory),
            "::",
            stringify!(magic)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__CodeDirectory>())).length as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__CodeDirectory),
            "::",
            stringify!(length)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__CodeDirectory>())).version as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__CodeDirectory),
            "::",
            stringify!(version)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__CodeDirectory>())).flags as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__CodeDirectory),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__CodeDirectory>())).hashOffset as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__CodeDirectory),
            "::",
            stringify!(hashOffset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__CodeDirectory>())).identOffset as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(__CodeDirectory),
            "::",
            stringify!(identOffset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__CodeDirectory>())).nSpecialSlots as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__CodeDirectory),
            "::",
            stringify!(nSpecialSlots)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__CodeDirectory>())).nCodeSlots as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(__CodeDirectory),
            "::",
            stringify!(nCodeSlots)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__CodeDirectory>())).codeLimit as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__CodeDirectory),
            "::",
            stringify!(codeLimit)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__CodeDirectory>())).hashSize as *const _ as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(__CodeDirectory),
            "::",
            stringify!(hashSize)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__CodeDirectory>())).hashType as *const _ as usize },
        37usize,
        concat!(
            "Offset of field: ",
            stringify!(__CodeDirectory),
            "::",
            stringify!(hashType)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__CodeDirectory>())).platform as *const _ as usize },
        38usize,
        concat!(
            "Offset of field: ",
            stringify!(__CodeDirectory),
            "::",
            stringify!(platform)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__CodeDirectory>())).pageSize as *const _ as usize },
        39usize,
        concat!(
            "Offset of field: ",
            stringify!(__CodeDirectory),
            "::",
            stringify!(pageSize)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__CodeDirectory>())).spare2 as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__CodeDirectory),
            "::",
            stringify!(spare2)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__CodeDirectory>())).end_earliest as *const _ as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(__CodeDirectory),
            "::",
            stringify!(end_earliest)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__CodeDirectory>())).scatterOffset as *const _ as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(__CodeDirectory),
            "::",
            stringify!(scatterOffset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__CodeDirectory>())).end_withScatter as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(__CodeDirectory),
            "::",
            stringify!(end_withScatter)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__CodeDirectory>())).teamOffset as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(__CodeDirectory),
            "::",
            stringify!(teamOffset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__CodeDirectory>())).end_withTeam as *const _ as usize },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(__CodeDirectory),
            "::",
            stringify!(end_withTeam)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__CodeDirectory>())).spare3 as *const _ as usize },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(__CodeDirectory),
            "::",
            stringify!(spare3)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__CodeDirectory>())).codeLimit64 as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(__CodeDirectory),
            "::",
            stringify!(codeLimit64)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__CodeDirectory>())).end_withCodeLimit64 as *const _ as usize
        },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(__CodeDirectory),
            "::",
            stringify!(end_withCodeLimit64)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__CodeDirectory>())).execSegBase as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(__CodeDirectory),
            "::",
            stringify!(execSegBase)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__CodeDirectory>())).execSegLimit as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(__CodeDirectory),
            "::",
            stringify!(execSegLimit)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__CodeDirectory>())).execSegFlags as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(__CodeDirectory),
            "::",
            stringify!(execSegFlags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__CodeDirectory>())).end_withExecSeg as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(__CodeDirectory),
            "::",
            stringify!(end_withExecSeg)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__CodeDirectory>())).runtime as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(__CodeDirectory),
            "::",
            stringify!(runtime)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__CodeDirectory>())).preEncryptOffset as *const _ as usize
        },
        92usize,
        concat!(
            "Offset of field: ",
            stringify!(__CodeDirectory),
            "::",
            stringify!(preEncryptOffset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__CodeDirectory>())).end_withPreEncryptOffset as *const _
                as usize
        },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(__CodeDirectory),
            "::",
            stringify!(end_withPreEncryptOffset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__CodeDirectory>())).linkageHashType as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(__CodeDirectory),
            "::",
            stringify!(linkageHashType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__CodeDirectory>())).linkageTruncated as *const _ as usize
        },
        97usize,
        concat!(
            "Offset of field: ",
            stringify!(__CodeDirectory),
            "::",
            stringify!(linkageTruncated)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__CodeDirectory>())).spare4 as *const _ as usize },
        98usize,
        concat!(
            "Offset of field: ",
            stringify!(__CodeDirectory),
            "::",
            stringify!(spare4)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__CodeDirectory>())).linkageOffset as *const _ as usize },
        100usize,
        concat!(
            "Offset of field: ",
            stringify!(__CodeDirectory),
            "::",
            stringify!(linkageOffset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__CodeDirectory>())).linkageSize as *const _ as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(__CodeDirectory),
            "::",
            stringify!(linkageSize)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__CodeDirectory>())).end_withLinkage as *const _ as usize },
        108usize,
        concat!(
            "Offset of field: ",
            stringify!(__CodeDirectory),
            "::",
            stringify!(end_withLinkage)
        )
    );
}
pub type CS_CodeDirectory = __CodeDirectory;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __BlobIndex {
    pub type_: u32,
    pub offset: u32,
}
#[test]
fn bindgen_test_layout___BlobIndex() {
    assert_eq!(
        ::std::mem::size_of::<__BlobIndex>(),
        8usize,
        concat!("Size of: ", stringify!(__BlobIndex))
    );
    assert_eq!(
        ::std::mem::align_of::<__BlobIndex>(),
        4usize,
        concat!("Alignment of ", stringify!(__BlobIndex))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__BlobIndex>())).type_ as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__BlobIndex),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__BlobIndex>())).offset as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__BlobIndex),
            "::",
            stringify!(offset)
        )
    );
}
pub type CS_BlobIndex = __BlobIndex;
#[repr(C)]
#[derive(Debug)]
pub struct __SC_SuperBlob {
    pub magic: u32,
    pub length: u32,
    pub count: u32,
    pub index: __IncompleteArrayField<CS_BlobIndex>,
}
#[test]
fn bindgen_test_layout___SC_SuperBlob() {
    assert_eq!(
        ::std::mem::size_of::<__SC_SuperBlob>(),
        12usize,
        concat!("Size of: ", stringify!(__SC_SuperBlob))
    );
    assert_eq!(
        ::std::mem::align_of::<__SC_SuperBlob>(),
        4usize,
        concat!("Alignment of ", stringify!(__SC_SuperBlob))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__SC_SuperBlob>())).magic as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__SC_SuperBlob),
            "::",
            stringify!(magic)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__SC_SuperBlob>())).length as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__SC_SuperBlob),
            "::",
            stringify!(length)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__SC_SuperBlob>())).count as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__SC_SuperBlob),
            "::",
            stringify!(count)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__SC_SuperBlob>())).index as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__SC_SuperBlob),
            "::",
            stringify!(index)
        )
    );
}
pub type CS_SuperBlob = __SC_SuperBlob;
#[repr(C)]
#[derive(Debug)]
pub struct __SC_GenericBlob {
    pub magic: u32,
    pub length: u32,
    pub data: __IncompleteArrayField<::std::os::raw::c_char>,
}
#[test]
fn bindgen_test_layout___SC_GenericBlob() {
    assert_eq!(
        ::std::mem::size_of::<__SC_GenericBlob>(),
        8usize,
        concat!("Size of: ", stringify!(__SC_GenericBlob))
    );
    assert_eq!(
        ::std::mem::align_of::<__SC_GenericBlob>(),
        4usize,
        concat!("Alignment of ", stringify!(__SC_GenericBlob))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__SC_GenericBlob>())).magic as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__SC_GenericBlob),
            "::",
            stringify!(magic)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__SC_GenericBlob>())).length as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__SC_GenericBlob),
            "::",
            stringify!(length)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__SC_GenericBlob>())).data as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__SC_GenericBlob),
            "::",
            stringify!(data)
        )
    );
}
pub type CS_GenericBlob = __SC_GenericBlob;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __SC_Scatter {
    pub count: u32,
    pub base: u32,
    pub targetOffset: u64,
    pub spare: u64,
}
#[test]
fn bindgen_test_layout___SC_Scatter() {
    assert_eq!(
        ::std::mem::size_of::<__SC_Scatter>(),
        24usize,
        concat!("Size of: ", stringify!(__SC_Scatter))
    );
    assert_eq!(
        ::std::mem::align_of::<__SC_Scatter>(),
        8usize,
        concat!("Alignment of ", stringify!(__SC_Scatter))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__SC_Scatter>())).count as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__SC_Scatter),
            "::",
            stringify!(count)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__SC_Scatter>())).base as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__SC_Scatter),
            "::",
            stringify!(base)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__SC_Scatter>())).targetOffset as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__SC_Scatter),
            "::",
            stringify!(targetOffset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__SC_Scatter>())).spare as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__SC_Scatter),
            "::",
            stringify!(spare)
        )
    );
}
pub type SC_Scatter = __SC_Scatter;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct es_event_id_t {
    pub reserved: [u8; 32usize],
}
#[test]
fn bindgen_test_layout_es_event_id_t() {
    assert_eq!(
        ::std::mem::size_of::<es_event_id_t>(),
        32usize,
        concat!("Size of: ", stringify!(es_event_id_t))
    );
    assert_eq!(
        ::std::mem::align_of::<es_event_id_t>(),
        1usize,
        concat!("Alignment of ", stringify!(es_event_id_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_id_t>())).reserved as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_id_t),
            "::",
            stringify!(reserved)
        )
    );
}
pub type u_char = ::std::os::raw::c_uchar;
pub type u_short = ::std::os::raw::c_ushort;
pub type u_int = ::std::os::raw::c_uint;
pub type u_long = ::std::os::raw::c_ulong;
pub type ushort = ::std::os::raw::c_ushort;
pub type uint = ::std::os::raw::c_uint;
pub type u_quad_t = u_int64_t;
pub type quad_t = i64;
pub type qaddr_t = *mut quad_t;
pub type caddr_t = *mut ::std::os::raw::c_char;
pub type daddr_t = i32;
pub type dev_t = __darwin_dev_t;
pub type fixpt_t = u_int32_t;
pub type blkcnt_t = __darwin_blkcnt_t;
pub type blksize_t = __darwin_blksize_t;
pub type gid_t = __darwin_gid_t;
pub type in_addr_t = __uint32_t;
pub type in_port_t = __uint16_t;
pub type ino_t = __darwin_ino_t;
pub type ino64_t = __darwin_ino64_t;
pub type key_t = __int32_t;
pub type mode_t = __darwin_mode_t;
pub type nlink_t = __uint16_t;
pub type id_t = __darwin_id_t;
pub type pid_t = __darwin_pid_t;
pub type off_t = __darwin_off_t;
pub type segsz_t = i32;
pub type swblk_t = i32;
pub type uid_t = __darwin_uid_t;
pub type clock_t = __darwin_clock_t;
pub type size_t = __darwin_size_t;
pub type ssize_t = __darwin_ssize_t;
pub type time_t = __darwin_time_t;
pub type useconds_t = __darwin_useconds_t;
pub type suseconds_t = __darwin_suseconds_t;
pub type rsize_t = __darwin_size_t;
pub type errno_t = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct fd_set {
    pub fds_bits: [__int32_t; 32usize],
}
#[test]
fn bindgen_test_layout_fd_set() {
    assert_eq!(
        ::std::mem::size_of::<fd_set>(),
        128usize,
        concat!("Size of: ", stringify!(fd_set))
    );
    assert_eq!(
        ::std::mem::align_of::<fd_set>(),
        4usize,
        concat!("Alignment of ", stringify!(fd_set))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<fd_set>())).fds_bits as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(fd_set),
            "::",
            stringify!(fds_bits)
        )
    );
}
extern "C" {
    pub fn __darwin_check_fd_set_overflow(
        arg1: ::std::os::raw::c_int,
        arg2: *const ::std::os::raw::c_void,
        arg3: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
pub type fd_mask = __int32_t;
pub type pthread_attr_t = __darwin_pthread_attr_t;
pub type pthread_cond_t = __darwin_pthread_cond_t;
pub type pthread_condattr_t = __darwin_pthread_condattr_t;
pub type pthread_mutex_t = __darwin_pthread_mutex_t;
pub type pthread_mutexattr_t = __darwin_pthread_mutexattr_t;
pub type pthread_once_t = __darwin_pthread_once_t;
pub type pthread_rwlock_t = __darwin_pthread_rwlock_t;
pub type pthread_rwlockattr_t = __darwin_pthread_rwlockattr_t;
pub type pthread_t = __darwin_pthread_t;
pub type pthread_key_t = __darwin_pthread_key_t;
pub type fsblkcnt_t = __darwin_fsblkcnt_t;
pub type fsfilcnt_t = __darwin_fsfilcnt_t;
pub type os_function_t =
    ::std::option::Option<unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_void)>;
pub type os_block_t = *mut ::std::os::raw::c_void;
pub const es_action_type_t_ES_ACTION_TYPE_AUTH: es_action_type_t = 0;
pub const es_action_type_t_ES_ACTION_TYPE_NOTIFY: es_action_type_t = 1;
pub type es_action_type_t = ::std::os::raw::c_uint;
pub const es_set_or_clear_t_ES_SET: es_set_or_clear_t = 0;
pub const es_set_or_clear_t_ES_CLEAR: es_set_or_clear_t = 1;
pub type es_set_or_clear_t = ::std::os::raw::c_uint;
pub const es_event_type_t_ES_EVENT_TYPE_AUTH_EXEC: es_event_type_t = 0;
pub const es_event_type_t_ES_EVENT_TYPE_AUTH_OPEN: es_event_type_t = 1;
pub const es_event_type_t_ES_EVENT_TYPE_AUTH_KEXTLOAD: es_event_type_t = 2;
pub const es_event_type_t_ES_EVENT_TYPE_AUTH_MMAP: es_event_type_t = 3;
pub const es_event_type_t_ES_EVENT_TYPE_AUTH_MPROTECT: es_event_type_t = 4;
pub const es_event_type_t_ES_EVENT_TYPE_AUTH_MOUNT: es_event_type_t = 5;
pub const es_event_type_t_ES_EVENT_TYPE_AUTH_RENAME: es_event_type_t = 6;
pub const es_event_type_t_ES_EVENT_TYPE_AUTH_SIGNAL: es_event_type_t = 7;
pub const es_event_type_t_ES_EVENT_TYPE_AUTH_UNLINK: es_event_type_t = 8;
pub const es_event_type_t_ES_EVENT_TYPE_NOTIFY_EXEC: es_event_type_t = 9;
pub const es_event_type_t_ES_EVENT_TYPE_NOTIFY_OPEN: es_event_type_t = 10;
pub const es_event_type_t_ES_EVENT_TYPE_NOTIFY_FORK: es_event_type_t = 11;
pub const es_event_type_t_ES_EVENT_TYPE_NOTIFY_CLOSE: es_event_type_t = 12;
pub const es_event_type_t_ES_EVENT_TYPE_NOTIFY_CREATE: es_event_type_t = 13;
pub const es_event_type_t_ES_EVENT_TYPE_NOTIFY_EXCHANGEDATA: es_event_type_t = 14;
pub const es_event_type_t_ES_EVENT_TYPE_NOTIFY_EXIT: es_event_type_t = 15;
pub const es_event_type_t_ES_EVENT_TYPE_NOTIFY_GET_TASK: es_event_type_t = 16;
pub const es_event_type_t_ES_EVENT_TYPE_NOTIFY_KEXTLOAD: es_event_type_t = 17;
pub const es_event_type_t_ES_EVENT_TYPE_NOTIFY_KEXTUNLOAD: es_event_type_t = 18;
pub const es_event_type_t_ES_EVENT_TYPE_NOTIFY_LINK: es_event_type_t = 19;
pub const es_event_type_t_ES_EVENT_TYPE_NOTIFY_MMAP: es_event_type_t = 20;
pub const es_event_type_t_ES_EVENT_TYPE_NOTIFY_MPROTECT: es_event_type_t = 21;
pub const es_event_type_t_ES_EVENT_TYPE_NOTIFY_MOUNT: es_event_type_t = 22;
pub const es_event_type_t_ES_EVENT_TYPE_NOTIFY_UNMOUNT: es_event_type_t = 23;
pub const es_event_type_t_ES_EVENT_TYPE_NOTIFY_IOKIT_OPEN: es_event_type_t = 24;
pub const es_event_type_t_ES_EVENT_TYPE_NOTIFY_RENAME: es_event_type_t = 25;
pub const es_event_type_t_ES_EVENT_TYPE_NOTIFY_SETATTRLIST: es_event_type_t = 26;
pub const es_event_type_t_ES_EVENT_TYPE_NOTIFY_SETEXTATTR: es_event_type_t = 27;
pub const es_event_type_t_ES_EVENT_TYPE_NOTIFY_SETFLAGS: es_event_type_t = 28;
pub const es_event_type_t_ES_EVENT_TYPE_NOTIFY_SETMODE: es_event_type_t = 29;
pub const es_event_type_t_ES_EVENT_TYPE_NOTIFY_SETOWNER: es_event_type_t = 30;
pub const es_event_type_t_ES_EVENT_TYPE_NOTIFY_SIGNAL: es_event_type_t = 31;
pub const es_event_type_t_ES_EVENT_TYPE_NOTIFY_UNLINK: es_event_type_t = 32;
pub const es_event_type_t_ES_EVENT_TYPE_NOTIFY_WRITE: es_event_type_t = 33;
pub const es_event_type_t_ES_EVENT_TYPE_AUTH_FILE_PROVIDER_MATERIALIZE: es_event_type_t = 34;
pub const es_event_type_t_ES_EVENT_TYPE_NOTIFY_FILE_PROVIDER_MATERIALIZE: es_event_type_t = 35;
pub const es_event_type_t_ES_EVENT_TYPE_AUTH_FILE_PROVIDER_UPDATE: es_event_type_t = 36;
pub const es_event_type_t_ES_EVENT_TYPE_NOTIFY_FILE_PROVIDER_UPDATE: es_event_type_t = 37;
pub const es_event_type_t_ES_EVENT_TYPE_AUTH_READLINK: es_event_type_t = 38;
pub const es_event_type_t_ES_EVENT_TYPE_NOTIFY_READLINK: es_event_type_t = 39;
pub const es_event_type_t_ES_EVENT_TYPE_AUTH_TRUNCATE: es_event_type_t = 40;
pub const es_event_type_t_ES_EVENT_TYPE_NOTIFY_TRUNCATE: es_event_type_t = 41;
pub const es_event_type_t_ES_EVENT_TYPE_AUTH_LINK: es_event_type_t = 42;
pub const es_event_type_t_ES_EVENT_TYPE_NOTIFY_LOOKUP: es_event_type_t = 43;
pub const es_event_type_t_ES_EVENT_TYPE_AUTH_CREATE: es_event_type_t = 44;
pub const es_event_type_t_ES_EVENT_TYPE_AUTH_SETATTRLIST: es_event_type_t = 45;
pub const es_event_type_t_ES_EVENT_TYPE_AUTH_SETEXTATTR: es_event_type_t = 46;
pub const es_event_type_t_ES_EVENT_TYPE_AUTH_SETFLAGS: es_event_type_t = 47;
pub const es_event_type_t_ES_EVENT_TYPE_AUTH_SETMODE: es_event_type_t = 48;
pub const es_event_type_t_ES_EVENT_TYPE_AUTH_SETOWNER: es_event_type_t = 49;
pub const es_event_type_t_ES_EVENT_TYPE_AUTH_CHDIR: es_event_type_t = 50;
pub const es_event_type_t_ES_EVENT_TYPE_NOTIFY_CHDIR: es_event_type_t = 51;
pub const es_event_type_t_ES_EVENT_TYPE_AUTH_GETATTRLIST: es_event_type_t = 52;
pub const es_event_type_t_ES_EVENT_TYPE_NOTIFY_GETATTRLIST: es_event_type_t = 53;
pub const es_event_type_t_ES_EVENT_TYPE_NOTIFY_STAT: es_event_type_t = 54;
pub const es_event_type_t_ES_EVENT_TYPE_NOTIFY_ACCESS: es_event_type_t = 55;
pub const es_event_type_t_ES_EVENT_TYPE_AUTH_CHROOT: es_event_type_t = 56;
pub const es_event_type_t_ES_EVENT_TYPE_NOTIFY_CHROOT: es_event_type_t = 57;
pub const es_event_type_t_ES_EVENT_TYPE_AUTH_UTIMES: es_event_type_t = 58;
pub const es_event_type_t_ES_EVENT_TYPE_NOTIFY_UTIMES: es_event_type_t = 59;
pub const es_event_type_t_ES_EVENT_TYPE_AUTH_CLONE: es_event_type_t = 60;
pub const es_event_type_t_ES_EVENT_TYPE_NOTIFY_CLONE: es_event_type_t = 61;
pub const es_event_type_t_ES_EVENT_TYPE_NOTIFY_FCNTL: es_event_type_t = 62;
pub const es_event_type_t_ES_EVENT_TYPE_AUTH_GETEXTATTR: es_event_type_t = 63;
pub const es_event_type_t_ES_EVENT_TYPE_NOTIFY_GETEXTATTR: es_event_type_t = 64;
pub const es_event_type_t_ES_EVENT_TYPE_AUTH_LISTEXTATTR: es_event_type_t = 65;
pub const es_event_type_t_ES_EVENT_TYPE_NOTIFY_LISTEXTATTR: es_event_type_t = 66;
pub const es_event_type_t_ES_EVENT_TYPE_AUTH_READDIR: es_event_type_t = 67;
pub const es_event_type_t_ES_EVENT_TYPE_NOTIFY_READDIR: es_event_type_t = 68;
pub const es_event_type_t_ES_EVENT_TYPE_AUTH_DELETEEXTATTR: es_event_type_t = 69;
pub const es_event_type_t_ES_EVENT_TYPE_NOTIFY_DELETEEXTATTR: es_event_type_t = 70;
pub const es_event_type_t_ES_EVENT_TYPE_AUTH_FSGETPATH: es_event_type_t = 71;
pub const es_event_type_t_ES_EVENT_TYPE_NOTIFY_FSGETPATH: es_event_type_t = 72;
pub const es_event_type_t_ES_EVENT_TYPE_NOTIFY_DUP: es_event_type_t = 73;
pub const es_event_type_t_ES_EVENT_TYPE_AUTH_SETTIME: es_event_type_t = 74;
pub const es_event_type_t_ES_EVENT_TYPE_NOTIFY_SETTIME: es_event_type_t = 75;
pub const es_event_type_t_ES_EVENT_TYPE_NOTIFY_UIPC_BIND: es_event_type_t = 76;
pub const es_event_type_t_ES_EVENT_TYPE_AUTH_UIPC_BIND: es_event_type_t = 77;
pub const es_event_type_t_ES_EVENT_TYPE_NOTIFY_UIPC_CONNECT: es_event_type_t = 78;
pub const es_event_type_t_ES_EVENT_TYPE_AUTH_UIPC_CONNECT: es_event_type_t = 79;
pub const es_event_type_t_ES_EVENT_TYPE_AUTH_EXCHANGEDATA: es_event_type_t = 80;
pub const es_event_type_t_ES_EVENT_TYPE_AUTH_SETACL: es_event_type_t = 81;
pub const es_event_type_t_ES_EVENT_TYPE_NOTIFY_SETACL: es_event_type_t = 82;
pub const es_event_type_t_ES_EVENT_TYPE_NOTIFY_PTY_GRANT: es_event_type_t = 83;
pub const es_event_type_t_ES_EVENT_TYPE_NOTIFY_PTY_CLOSE: es_event_type_t = 84;
pub const es_event_type_t_ES_EVENT_TYPE_AUTH_PROC_CHECK: es_event_type_t = 85;
pub const es_event_type_t_ES_EVENT_TYPE_NOTIFY_PROC_CHECK: es_event_type_t = 86;
pub const es_event_type_t_ES_EVENT_TYPE_AUTH_GET_TASK: es_event_type_t = 87;
pub const es_event_type_t_ES_EVENT_TYPE_AUTH_SEARCHFS: es_event_type_t = 88;
pub const es_event_type_t_ES_EVENT_TYPE_NOTIFY_SEARCHFS: es_event_type_t = 89;
pub const es_event_type_t_ES_EVENT_TYPE_AUTH_FCNTL: es_event_type_t = 90;
pub const es_event_type_t_ES_EVENT_TYPE_AUTH_IOKIT_OPEN: es_event_type_t = 91;
pub const es_event_type_t_ES_EVENT_TYPE_AUTH_PROC_SUSPEND_RESUME: es_event_type_t = 92;
pub const es_event_type_t_ES_EVENT_TYPE_NOTIFY_PROC_SUSPEND_RESUME: es_event_type_t = 93;
pub const es_event_type_t_ES_EVENT_TYPE_NOTIFY_CS_INVALIDATED: es_event_type_t = 94;
pub const es_event_type_t_ES_EVENT_TYPE_NOTIFY_GET_TASK_NAME: es_event_type_t = 95;
pub const es_event_type_t_ES_EVENT_TYPE_NOTIFY_TRACE: es_event_type_t = 96;
pub const es_event_type_t_ES_EVENT_TYPE_NOTIFY_REMOTE_THREAD_CREATE: es_event_type_t = 97;
pub const es_event_type_t_ES_EVENT_TYPE_AUTH_REMOUNT: es_event_type_t = 98;
pub const es_event_type_t_ES_EVENT_TYPE_NOTIFY_REMOUNT: es_event_type_t = 99;
pub const es_event_type_t_ES_EVENT_TYPE_LAST: es_event_type_t = 100;
pub type es_event_type_t = ::std::os::raw::c_uint;
pub const es_auth_result_t_ES_AUTH_RESULT_ALLOW: es_auth_result_t = 0;
pub const es_auth_result_t_ES_AUTH_RESULT_DENY: es_auth_result_t = 1;
pub type es_auth_result_t = ::std::os::raw::c_uint;
pub const es_result_type_t_ES_RESULT_TYPE_AUTH: es_result_type_t = 0;
pub const es_result_type_t_ES_RESULT_TYPE_FLAGS: es_result_type_t = 1;
pub type es_result_type_t = ::std::os::raw::c_uint;
pub const es_return_t_ES_RETURN_SUCCESS: es_return_t = 0;
pub const es_return_t_ES_RETURN_ERROR: es_return_t = 1;
pub type es_return_t = ::std::os::raw::c_uint;
pub const es_respond_result_t_ES_RESPOND_RESULT_SUCCESS: es_respond_result_t = 0;
pub const es_respond_result_t_ES_RESPOND_RESULT_ERR_INVALID_ARGUMENT: es_respond_result_t = 1;
pub const es_respond_result_t_ES_RESPOND_RESULT_ERR_INTERNAL: es_respond_result_t = 2;
pub const es_respond_result_t_ES_RESPOND_RESULT_NOT_FOUND: es_respond_result_t = 3;
pub const es_respond_result_t_ES_RESPOND_RESULT_ERR_DUPLICATE_RESPONSE: es_respond_result_t = 4;
pub const es_respond_result_t_ES_RESPOND_RESULT_ERR_EVENT_TYPE: es_respond_result_t = 5;
pub type es_respond_result_t = ::std::os::raw::c_uint;
pub const es_new_client_result_t_ES_NEW_CLIENT_RESULT_SUCCESS: es_new_client_result_t = 0;
pub const es_new_client_result_t_ES_NEW_CLIENT_RESULT_ERR_INVALID_ARGUMENT: es_new_client_result_t =
    1;
pub const es_new_client_result_t_ES_NEW_CLIENT_RESULT_ERR_INTERNAL: es_new_client_result_t = 2;
pub const es_new_client_result_t_ES_NEW_CLIENT_RESULT_ERR_NOT_ENTITLED: es_new_client_result_t = 3;
pub const es_new_client_result_t_ES_NEW_CLIENT_RESULT_ERR_NOT_PERMITTED: es_new_client_result_t = 4;
pub const es_new_client_result_t_ES_NEW_CLIENT_RESULT_ERR_NOT_PRIVILEGED: es_new_client_result_t =
    5;
pub const es_new_client_result_t_ES_NEW_CLIENT_RESULT_ERR_TOO_MANY_CLIENTS: es_new_client_result_t =
    6;
pub type es_new_client_result_t = ::std::os::raw::c_uint;
pub const es_clear_cache_result_t_ES_CLEAR_CACHE_RESULT_SUCCESS: es_clear_cache_result_t = 0;
pub const es_clear_cache_result_t_ES_CLEAR_CACHE_RESULT_ERR_INTERNAL: es_clear_cache_result_t = 1;
pub const es_clear_cache_result_t_ES_CLEAR_CACHE_RESULT_ERR_THROTTLE: es_clear_cache_result_t = 2;
pub type es_clear_cache_result_t = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct es_token_t {
    pub size: size_t,
    pub data: *const u8,
}
#[test]
fn bindgen_test_layout_es_token_t() {
    assert_eq!(
        ::std::mem::size_of::<es_token_t>(),
        16usize,
        concat!("Size of: ", stringify!(es_token_t))
    );
    assert_eq!(
        ::std::mem::align_of::<es_token_t>(),
        8usize,
        concat!("Alignment of ", stringify!(es_token_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_token_t>())).size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_token_t),
            "::",
            stringify!(size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_token_t>())).data as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(es_token_t),
            "::",
            stringify!(data)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct es_string_token_t {
    pub length: size_t,
    pub data: *const ::std::os::raw::c_char,
}
#[test]
fn bindgen_test_layout_es_string_token_t() {
    assert_eq!(
        ::std::mem::size_of::<es_string_token_t>(),
        16usize,
        concat!("Size of: ", stringify!(es_string_token_t))
    );
    assert_eq!(
        ::std::mem::align_of::<es_string_token_t>(),
        8usize,
        concat!("Alignment of ", stringify!(es_string_token_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_string_token_t>())).length as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_string_token_t),
            "::",
            stringify!(length)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_string_token_t>())).data as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(es_string_token_t),
            "::",
            stringify!(data)
        )
    );
}
pub type boolean_t = ::std::os::raw::c_uint;
pub type natural_t = __darwin_natural_t;
pub type integer_t = ::std::os::raw::c_int;
pub type vm_offset_t = usize;
pub type vm_size_t = usize;
pub type mach_vm_address_t = u64;
pub type mach_vm_offset_t = u64;
pub type mach_vm_size_t = u64;
pub type vm_map_offset_t = u64;
pub type vm_map_address_t = u64;
pub type vm_map_size_t = u64;
pub type mach_port_context_t = mach_vm_address_t;
pub type mach_port_name_t = natural_t;
pub type mach_port_name_array_t = *mut mach_port_name_t;
pub type mach_port_t = __darwin_mach_port_t;
pub type mach_port_array_t = *mut mach_port_t;
pub type mach_port_right_t = natural_t;
pub type mach_port_type_t = natural_t;
pub type mach_port_type_array_t = *mut mach_port_type_t;
pub type mach_port_urefs_t = natural_t;
pub type mach_port_delta_t = integer_t;
pub type mach_port_seqno_t = natural_t;
pub type mach_port_mscount_t = natural_t;
pub type mach_port_msgcount_t = natural_t;
pub type mach_port_rights_t = natural_t;
pub type mach_port_srights_t = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct mach_port_status {
    pub mps_pset: mach_port_rights_t,
    pub mps_seqno: mach_port_seqno_t,
    pub mps_mscount: mach_port_mscount_t,
    pub mps_qlimit: mach_port_msgcount_t,
    pub mps_msgcount: mach_port_msgcount_t,
    pub mps_sorights: mach_port_rights_t,
    pub mps_srights: boolean_t,
    pub mps_pdrequest: boolean_t,
    pub mps_nsrequest: boolean_t,
    pub mps_flags: natural_t,
}
#[test]
fn bindgen_test_layout_mach_port_status() {
    assert_eq!(
        ::std::mem::size_of::<mach_port_status>(),
        40usize,
        concat!("Size of: ", stringify!(mach_port_status))
    );
    assert_eq!(
        ::std::mem::align_of::<mach_port_status>(),
        4usize,
        concat!("Alignment of ", stringify!(mach_port_status))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<mach_port_status>())).mps_pset as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_port_status),
            "::",
            stringify!(mps_pset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<mach_port_status>())).mps_seqno as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_port_status),
            "::",
            stringify!(mps_seqno)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<mach_port_status>())).mps_mscount as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_port_status),
            "::",
            stringify!(mps_mscount)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<mach_port_status>())).mps_qlimit as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_port_status),
            "::",
            stringify!(mps_qlimit)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<mach_port_status>())).mps_msgcount as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_port_status),
            "::",
            stringify!(mps_msgcount)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<mach_port_status>())).mps_sorights as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_port_status),
            "::",
            stringify!(mps_sorights)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<mach_port_status>())).mps_srights as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_port_status),
            "::",
            stringify!(mps_srights)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<mach_port_status>())).mps_pdrequest as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_port_status),
            "::",
            stringify!(mps_pdrequest)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<mach_port_status>())).mps_nsrequest as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_port_status),
            "::",
            stringify!(mps_nsrequest)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<mach_port_status>())).mps_flags as *const _ as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_port_status),
            "::",
            stringify!(mps_flags)
        )
    );
}
pub type mach_port_status_t = mach_port_status;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct mach_port_limits {
    pub mpl_qlimit: mach_port_msgcount_t,
}
#[test]
fn bindgen_test_layout_mach_port_limits() {
    assert_eq!(
        ::std::mem::size_of::<mach_port_limits>(),
        4usize,
        concat!("Size of: ", stringify!(mach_port_limits))
    );
    assert_eq!(
        ::std::mem::align_of::<mach_port_limits>(),
        4usize,
        concat!("Alignment of ", stringify!(mach_port_limits))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<mach_port_limits>())).mpl_qlimit as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_port_limits),
            "::",
            stringify!(mpl_qlimit)
        )
    );
}
pub type mach_port_limits_t = mach_port_limits;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct mach_port_info_ext {
    pub mpie_status: mach_port_status_t,
    pub mpie_boost_cnt: mach_port_msgcount_t,
    pub reserved: [u32; 6usize],
}
#[test]
fn bindgen_test_layout_mach_port_info_ext() {
    assert_eq!(
        ::std::mem::size_of::<mach_port_info_ext>(),
        68usize,
        concat!("Size of: ", stringify!(mach_port_info_ext))
    );
    assert_eq!(
        ::std::mem::align_of::<mach_port_info_ext>(),
        4usize,
        concat!("Alignment of ", stringify!(mach_port_info_ext))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<mach_port_info_ext>())).mpie_status as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_port_info_ext),
            "::",
            stringify!(mpie_status)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<mach_port_info_ext>())).mpie_boost_cnt as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_port_info_ext),
            "::",
            stringify!(mpie_boost_cnt)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<mach_port_info_ext>())).reserved as *const _ as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_port_info_ext),
            "::",
            stringify!(reserved)
        )
    );
}
pub type mach_port_info_ext_t = mach_port_info_ext;
pub type mach_port_info_t = *mut integer_t;
pub type mach_port_flavor_t = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct mach_port_qos {
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize], u32>,
    pub len: natural_t,
}
#[test]
fn bindgen_test_layout_mach_port_qos() {
    assert_eq!(
        ::std::mem::size_of::<mach_port_qos>(),
        8usize,
        concat!("Size of: ", stringify!(mach_port_qos))
    );
    assert_eq!(
        ::std::mem::align_of::<mach_port_qos>(),
        4usize,
        concat!("Alignment of ", stringify!(mach_port_qos))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<mach_port_qos>())).len as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_port_qos),
            "::",
            stringify!(len)
        )
    );
}
impl mach_port_qos {
    #[inline]
    pub fn name(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_name(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn prealloc(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_prealloc(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn pad1(&self) -> boolean_t {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 30u8) as u32) }
    }
    #[inline]
    pub fn set_pad1(&mut self, val: boolean_t) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 30u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        name: ::std::os::raw::c_uint,
        prealloc: ::std::os::raw::c_uint,
        pad1: boolean_t,
    ) -> __BindgenBitfieldUnit<[u8; 4usize], u32> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize], u32> =
            Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let name: u32 = unsafe { ::std::mem::transmute(name) };
            name as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let prealloc: u32 = unsafe { ::std::mem::transmute(prealloc) };
            prealloc as u64
        });
        __bindgen_bitfield_unit.set(2usize, 30u8, {
            let pad1: u32 = unsafe { ::std::mem::transmute(pad1) };
            pad1 as u64
        });
        __bindgen_bitfield_unit
    }
}
pub type mach_port_qos_t = mach_port_qos;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct mach_port_options {
    pub flags: u32,
    pub mpl: mach_port_limits_t,
    pub __bindgen_anon_1: mach_port_options__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union mach_port_options__bindgen_ty_1 {
    pub reserved: [u64; 2usize],
    pub work_interval_port: mach_port_name_t,
    _bindgen_union_align: [u64; 2usize],
}
#[test]
fn bindgen_test_layout_mach_port_options__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<mach_port_options__bindgen_ty_1>(),
        16usize,
        concat!("Size of: ", stringify!(mach_port_options__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<mach_port_options__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(mach_port_options__bindgen_ty_1))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<mach_port_options__bindgen_ty_1>())).reserved as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_port_options__bindgen_ty_1),
            "::",
            stringify!(reserved)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<mach_port_options__bindgen_ty_1>())).work_interval_port
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_port_options__bindgen_ty_1),
            "::",
            stringify!(work_interval_port)
        )
    );
}
#[test]
fn bindgen_test_layout_mach_port_options() {
    assert_eq!(
        ::std::mem::size_of::<mach_port_options>(),
        24usize,
        concat!("Size of: ", stringify!(mach_port_options))
    );
    assert_eq!(
        ::std::mem::align_of::<mach_port_options>(),
        8usize,
        concat!("Alignment of ", stringify!(mach_port_options))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<mach_port_options>())).flags as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_port_options),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<mach_port_options>())).mpl as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_port_options),
            "::",
            stringify!(mpl)
        )
    );
}
pub type mach_port_options_t = mach_port_options;
pub type mach_port_options_ptr_t = *mut mach_port_options_t;
pub const mach_port_guard_exception_codes_kGUARD_EXC_DESTROY: mach_port_guard_exception_codes = 1;
pub const mach_port_guard_exception_codes_kGUARD_EXC_MOD_REFS: mach_port_guard_exception_codes = 2;
pub const mach_port_guard_exception_codes_kGUARD_EXC_SET_CONTEXT: mach_port_guard_exception_codes =
    4;
pub const mach_port_guard_exception_codes_kGUARD_EXC_UNGUARDED: mach_port_guard_exception_codes = 8;
pub const mach_port_guard_exception_codes_kGUARD_EXC_INCORRECT_GUARD:
    mach_port_guard_exception_codes = 16;
pub const mach_port_guard_exception_codes_kGUARD_EXC_IMMOVABLE: mach_port_guard_exception_codes =
    32;
pub const mach_port_guard_exception_codes_kGUARD_EXC_STRICT_REPLY: mach_port_guard_exception_codes =
    64;
pub const mach_port_guard_exception_codes_kGUARD_EXC_MSG_FILTERED: mach_port_guard_exception_codes =
    128;
pub const mach_port_guard_exception_codes_kGUARD_EXC_INVALID_RIGHT:
    mach_port_guard_exception_codes = 256;
pub const mach_port_guard_exception_codes_kGUARD_EXC_INVALID_NAME: mach_port_guard_exception_codes =
    512;
pub const mach_port_guard_exception_codes_kGUARD_EXC_INVALID_VALUE:
    mach_port_guard_exception_codes = 1024;
pub const mach_port_guard_exception_codes_kGUARD_EXC_INVALID_ARGUMENT:
    mach_port_guard_exception_codes = 2048;
pub const mach_port_guard_exception_codes_kGUARD_EXC_RIGHT_EXISTS: mach_port_guard_exception_codes =
    4096;
pub const mach_port_guard_exception_codes_kGUARD_EXC_KERN_NO_SPACE:
    mach_port_guard_exception_codes = 8192;
pub const mach_port_guard_exception_codes_kGUARD_EXC_KERN_FAILURE: mach_port_guard_exception_codes =
    16384;
pub const mach_port_guard_exception_codes_kGUARD_EXC_KERN_RESOURCE:
    mach_port_guard_exception_codes = 32768;
pub const mach_port_guard_exception_codes_kGUARD_EXC_SEND_INVALID_REPLY:
    mach_port_guard_exception_codes = 65536;
pub const mach_port_guard_exception_codes_kGUARD_EXC_SEND_INVALID_VOUCHER:
    mach_port_guard_exception_codes = 131072;
pub const mach_port_guard_exception_codes_kGUARD_EXC_SEND_INVALID_RIGHT:
    mach_port_guard_exception_codes = 262144;
pub const mach_port_guard_exception_codes_kGUARD_EXC_RCV_INVALID_NAME:
    mach_port_guard_exception_codes = 524288;
pub const mach_port_guard_exception_codes_kGUARD_EXC_RCV_GUARDED_DESC:
    mach_port_guard_exception_codes = 1048576;
pub type mach_port_guard_exception_codes = ::std::os::raw::c_uint;
pub type kern_return_t = ::std::os::raw::c_int;
pub type mach_msg_timeout_t = natural_t;
pub type mach_msg_bits_t = ::std::os::raw::c_uint;
pub type mach_msg_size_t = natural_t;
pub type mach_msg_id_t = integer_t;
pub type mach_msg_priority_t = ::std::os::raw::c_uint;
pub type mach_msg_type_name_t = ::std::os::raw::c_uint;
pub type mach_msg_copy_options_t = ::std::os::raw::c_uint;
pub type mach_msg_guard_flags_t = ::std::os::raw::c_uint;
pub type mach_msg_descriptor_type_t = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct mach_msg_type_descriptor_t {
    pub pad1: natural_t,
    pub pad2: mach_msg_size_t,
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize], u32>,
}
#[test]
fn bindgen_test_layout_mach_msg_type_descriptor_t() {
    assert_eq!(
        ::std::mem::size_of::<mach_msg_type_descriptor_t>(),
        12usize,
        concat!("Size of: ", stringify!(mach_msg_type_descriptor_t))
    );
    assert_eq!(
        ::std::mem::align_of::<mach_msg_type_descriptor_t>(),
        4usize,
        concat!("Alignment of ", stringify!(mach_msg_type_descriptor_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<mach_msg_type_descriptor_t>())).pad1 as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_type_descriptor_t),
            "::",
            stringify!(pad1)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<mach_msg_type_descriptor_t>())).pad2 as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_type_descriptor_t),
            "::",
            stringify!(pad2)
        )
    );
}
impl mach_msg_type_descriptor_t {
    #[inline]
    pub fn pad3(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 24u8) as u32) }
    }
    #[inline]
    pub fn set_pad3(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 24u8, val as u64)
        }
    }
    #[inline]
    pub fn type_(&self) -> mach_msg_descriptor_type_t {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(24usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_type(&mut self, val: mach_msg_descriptor_type_t) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(24usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        pad3: ::std::os::raw::c_uint,
        type_: mach_msg_descriptor_type_t,
    ) -> __BindgenBitfieldUnit<[u8; 4usize], u32> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize], u32> =
            Default::default();
        __bindgen_bitfield_unit.set(0usize, 24u8, {
            let pad3: u32 = unsafe { ::std::mem::transmute(pad3) };
            pad3 as u64
        });
        __bindgen_bitfield_unit.set(24usize, 8u8, {
            let type_: u32 = unsafe { ::std::mem::transmute(type_) };
            type_ as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct mach_msg_port_descriptor_t {
    pub name: mach_port_t,
    pub pad1: mach_msg_size_t,
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize], u16>,
}
#[test]
fn bindgen_test_layout_mach_msg_port_descriptor_t() {
    assert_eq!(
        ::std::mem::size_of::<mach_msg_port_descriptor_t>(),
        12usize,
        concat!("Size of: ", stringify!(mach_msg_port_descriptor_t))
    );
    assert_eq!(
        ::std::mem::align_of::<mach_msg_port_descriptor_t>(),
        4usize,
        concat!("Alignment of ", stringify!(mach_msg_port_descriptor_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<mach_msg_port_descriptor_t>())).name as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_port_descriptor_t),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<mach_msg_port_descriptor_t>())).pad1 as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_port_descriptor_t),
            "::",
            stringify!(pad1)
        )
    );
}
impl mach_msg_port_descriptor_t {
    #[inline]
    pub fn pad2(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 16u8) as u32) }
    }
    #[inline]
    pub fn set_pad2(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 16u8, val as u64)
        }
    }
    #[inline]
    pub fn disposition(&self) -> mach_msg_type_name_t {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(16usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_disposition(&mut self, val: mach_msg_type_name_t) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(16usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn type_(&self) -> mach_msg_descriptor_type_t {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(24usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_type(&mut self, val: mach_msg_descriptor_type_t) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(24usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        pad2: ::std::os::raw::c_uint,
        disposition: mach_msg_type_name_t,
        type_: mach_msg_descriptor_type_t,
    ) -> __BindgenBitfieldUnit<[u8; 4usize], u16> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize], u16> =
            Default::default();
        __bindgen_bitfield_unit.set(0usize, 16u8, {
            let pad2: u32 = unsafe { ::std::mem::transmute(pad2) };
            pad2 as u64
        });
        __bindgen_bitfield_unit.set(16usize, 8u8, {
            let disposition: u32 = unsafe { ::std::mem::transmute(disposition) };
            disposition as u64
        });
        __bindgen_bitfield_unit.set(24usize, 8u8, {
            let type_: u32 = unsafe { ::std::mem::transmute(type_) };
            type_ as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct mach_msg_ool_descriptor32_t {
    pub address: u32,
    pub size: mach_msg_size_t,
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize], u8>,
}
#[test]
fn bindgen_test_layout_mach_msg_ool_descriptor32_t() {
    assert_eq!(
        ::std::mem::size_of::<mach_msg_ool_descriptor32_t>(),
        12usize,
        concat!("Size of: ", stringify!(mach_msg_ool_descriptor32_t))
    );
    assert_eq!(
        ::std::mem::align_of::<mach_msg_ool_descriptor32_t>(),
        4usize,
        concat!("Alignment of ", stringify!(mach_msg_ool_descriptor32_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<mach_msg_ool_descriptor32_t>())).address as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_ool_descriptor32_t),
            "::",
            stringify!(address)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<mach_msg_ool_descriptor32_t>())).size as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_ool_descriptor32_t),
            "::",
            stringify!(size)
        )
    );
}
impl mach_msg_ool_descriptor32_t {
    #[inline]
    pub fn deallocate(&self) -> boolean_t {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_deallocate(&mut self, val: boolean_t) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn copy(&self) -> mach_msg_copy_options_t {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_copy(&mut self, val: mach_msg_copy_options_t) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn pad1(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(16usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_pad1(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(16usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn type_(&self) -> mach_msg_descriptor_type_t {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(24usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_type(&mut self, val: mach_msg_descriptor_type_t) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(24usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        deallocate: boolean_t,
        copy: mach_msg_copy_options_t,
        pad1: ::std::os::raw::c_uint,
        type_: mach_msg_descriptor_type_t,
    ) -> __BindgenBitfieldUnit<[u8; 4usize], u8> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize], u8> =
            Default::default();
        __bindgen_bitfield_unit.set(0usize, 8u8, {
            let deallocate: u32 = unsafe { ::std::mem::transmute(deallocate) };
            deallocate as u64
        });
        __bindgen_bitfield_unit.set(8usize, 8u8, {
            let copy: u32 = unsafe { ::std::mem::transmute(copy) };
            copy as u64
        });
        __bindgen_bitfield_unit.set(16usize, 8u8, {
            let pad1: u32 = unsafe { ::std::mem::transmute(pad1) };
            pad1 as u64
        });
        __bindgen_bitfield_unit.set(24usize, 8u8, {
            let type_: u32 = unsafe { ::std::mem::transmute(type_) };
            type_ as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C, packed(4))]
#[derive(Debug, Copy, Clone)]
pub struct mach_msg_ool_descriptor64_t {
    pub address: u64,
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize], u8>,
    pub size: mach_msg_size_t,
}
#[test]
fn bindgen_test_layout_mach_msg_ool_descriptor64_t() {
    assert_eq!(
        ::std::mem::size_of::<mach_msg_ool_descriptor64_t>(),
        16usize,
        concat!("Size of: ", stringify!(mach_msg_ool_descriptor64_t))
    );
    assert_eq!(
        ::std::mem::align_of::<mach_msg_ool_descriptor64_t>(),
        4usize,
        concat!("Alignment of ", stringify!(mach_msg_ool_descriptor64_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<mach_msg_ool_descriptor64_t>())).address as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_ool_descriptor64_t),
            "::",
            stringify!(address)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<mach_msg_ool_descriptor64_t>())).size as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_ool_descriptor64_t),
            "::",
            stringify!(size)
        )
    );
}
impl mach_msg_ool_descriptor64_t {
    #[inline]
    pub fn deallocate(&self) -> boolean_t {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_deallocate(&mut self, val: boolean_t) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn copy(&self) -> mach_msg_copy_options_t {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_copy(&mut self, val: mach_msg_copy_options_t) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn pad1(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(16usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_pad1(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(16usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn type_(&self) -> mach_msg_descriptor_type_t {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(24usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_type(&mut self, val: mach_msg_descriptor_type_t) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(24usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        deallocate: boolean_t,
        copy: mach_msg_copy_options_t,
        pad1: ::std::os::raw::c_uint,
        type_: mach_msg_descriptor_type_t,
    ) -> __BindgenBitfieldUnit<[u8; 4usize], u8> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize], u8> =
            Default::default();
        __bindgen_bitfield_unit.set(0usize, 8u8, {
            let deallocate: u32 = unsafe { ::std::mem::transmute(deallocate) };
            deallocate as u64
        });
        __bindgen_bitfield_unit.set(8usize, 8u8, {
            let copy: u32 = unsafe { ::std::mem::transmute(copy) };
            copy as u64
        });
        __bindgen_bitfield_unit.set(16usize, 8u8, {
            let pad1: u32 = unsafe { ::std::mem::transmute(pad1) };
            pad1 as u64
        });
        __bindgen_bitfield_unit.set(24usize, 8u8, {
            let type_: u32 = unsafe { ::std::mem::transmute(type_) };
            type_ as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C, packed(4))]
#[derive(Debug, Copy, Clone)]
pub struct mach_msg_ool_descriptor_t {
    pub address: *mut ::std::os::raw::c_void,
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize], u8>,
    pub size: mach_msg_size_t,
}
#[test]
fn bindgen_test_layout_mach_msg_ool_descriptor_t() {
    assert_eq!(
        ::std::mem::size_of::<mach_msg_ool_descriptor_t>(),
        16usize,
        concat!("Size of: ", stringify!(mach_msg_ool_descriptor_t))
    );
    assert_eq!(
        ::std::mem::align_of::<mach_msg_ool_descriptor_t>(),
        4usize,
        concat!("Alignment of ", stringify!(mach_msg_ool_descriptor_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<mach_msg_ool_descriptor_t>())).address as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_ool_descriptor_t),
            "::",
            stringify!(address)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<mach_msg_ool_descriptor_t>())).size as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_ool_descriptor_t),
            "::",
            stringify!(size)
        )
    );
}
impl mach_msg_ool_descriptor_t {
    #[inline]
    pub fn deallocate(&self) -> boolean_t {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_deallocate(&mut self, val: boolean_t) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn copy(&self) -> mach_msg_copy_options_t {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_copy(&mut self, val: mach_msg_copy_options_t) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn pad1(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(16usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_pad1(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(16usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn type_(&self) -> mach_msg_descriptor_type_t {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(24usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_type(&mut self, val: mach_msg_descriptor_type_t) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(24usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        deallocate: boolean_t,
        copy: mach_msg_copy_options_t,
        pad1: ::std::os::raw::c_uint,
        type_: mach_msg_descriptor_type_t,
    ) -> __BindgenBitfieldUnit<[u8; 4usize], u8> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize], u8> =
            Default::default();
        __bindgen_bitfield_unit.set(0usize, 8u8, {
            let deallocate: u32 = unsafe { ::std::mem::transmute(deallocate) };
            deallocate as u64
        });
        __bindgen_bitfield_unit.set(8usize, 8u8, {
            let copy: u32 = unsafe { ::std::mem::transmute(copy) };
            copy as u64
        });
        __bindgen_bitfield_unit.set(16usize, 8u8, {
            let pad1: u32 = unsafe { ::std::mem::transmute(pad1) };
            pad1 as u64
        });
        __bindgen_bitfield_unit.set(24usize, 8u8, {
            let type_: u32 = unsafe { ::std::mem::transmute(type_) };
            type_ as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct mach_msg_ool_ports_descriptor32_t {
    pub address: u32,
    pub count: mach_msg_size_t,
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize], u8>,
}
#[test]
fn bindgen_test_layout_mach_msg_ool_ports_descriptor32_t() {
    assert_eq!(
        ::std::mem::size_of::<mach_msg_ool_ports_descriptor32_t>(),
        12usize,
        concat!("Size of: ", stringify!(mach_msg_ool_ports_descriptor32_t))
    );
    assert_eq!(
        ::std::mem::align_of::<mach_msg_ool_ports_descriptor32_t>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(mach_msg_ool_ports_descriptor32_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<mach_msg_ool_ports_descriptor32_t>())).address as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_ool_ports_descriptor32_t),
            "::",
            stringify!(address)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<mach_msg_ool_ports_descriptor32_t>())).count as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_ool_ports_descriptor32_t),
            "::",
            stringify!(count)
        )
    );
}
impl mach_msg_ool_ports_descriptor32_t {
    #[inline]
    pub fn deallocate(&self) -> boolean_t {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_deallocate(&mut self, val: boolean_t) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn copy(&self) -> mach_msg_copy_options_t {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_copy(&mut self, val: mach_msg_copy_options_t) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn disposition(&self) -> mach_msg_type_name_t {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(16usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_disposition(&mut self, val: mach_msg_type_name_t) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(16usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn type_(&self) -> mach_msg_descriptor_type_t {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(24usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_type(&mut self, val: mach_msg_descriptor_type_t) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(24usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        deallocate: boolean_t,
        copy: mach_msg_copy_options_t,
        disposition: mach_msg_type_name_t,
        type_: mach_msg_descriptor_type_t,
    ) -> __BindgenBitfieldUnit<[u8; 4usize], u8> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize], u8> =
            Default::default();
        __bindgen_bitfield_unit.set(0usize, 8u8, {
            let deallocate: u32 = unsafe { ::std::mem::transmute(deallocate) };
            deallocate as u64
        });
        __bindgen_bitfield_unit.set(8usize, 8u8, {
            let copy: u32 = unsafe { ::std::mem::transmute(copy) };
            copy as u64
        });
        __bindgen_bitfield_unit.set(16usize, 8u8, {
            let disposition: u32 = unsafe { ::std::mem::transmute(disposition) };
            disposition as u64
        });
        __bindgen_bitfield_unit.set(24usize, 8u8, {
            let type_: u32 = unsafe { ::std::mem::transmute(type_) };
            type_ as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C, packed(4))]
#[derive(Debug, Copy, Clone)]
pub struct mach_msg_ool_ports_descriptor64_t {
    pub address: u64,
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize], u8>,
    pub count: mach_msg_size_t,
}
#[test]
fn bindgen_test_layout_mach_msg_ool_ports_descriptor64_t() {
    assert_eq!(
        ::std::mem::size_of::<mach_msg_ool_ports_descriptor64_t>(),
        16usize,
        concat!("Size of: ", stringify!(mach_msg_ool_ports_descriptor64_t))
    );
    assert_eq!(
        ::std::mem::align_of::<mach_msg_ool_ports_descriptor64_t>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(mach_msg_ool_ports_descriptor64_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<mach_msg_ool_ports_descriptor64_t>())).address as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_ool_ports_descriptor64_t),
            "::",
            stringify!(address)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<mach_msg_ool_ports_descriptor64_t>())).count as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_ool_ports_descriptor64_t),
            "::",
            stringify!(count)
        )
    );
}
impl mach_msg_ool_ports_descriptor64_t {
    #[inline]
    pub fn deallocate(&self) -> boolean_t {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_deallocate(&mut self, val: boolean_t) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn copy(&self) -> mach_msg_copy_options_t {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_copy(&mut self, val: mach_msg_copy_options_t) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn disposition(&self) -> mach_msg_type_name_t {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(16usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_disposition(&mut self, val: mach_msg_type_name_t) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(16usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn type_(&self) -> mach_msg_descriptor_type_t {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(24usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_type(&mut self, val: mach_msg_descriptor_type_t) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(24usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        deallocate: boolean_t,
        copy: mach_msg_copy_options_t,
        disposition: mach_msg_type_name_t,
        type_: mach_msg_descriptor_type_t,
    ) -> __BindgenBitfieldUnit<[u8; 4usize], u8> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize], u8> =
            Default::default();
        __bindgen_bitfield_unit.set(0usize, 8u8, {
            let deallocate: u32 = unsafe { ::std::mem::transmute(deallocate) };
            deallocate as u64
        });
        __bindgen_bitfield_unit.set(8usize, 8u8, {
            let copy: u32 = unsafe { ::std::mem::transmute(copy) };
            copy as u64
        });
        __bindgen_bitfield_unit.set(16usize, 8u8, {
            let disposition: u32 = unsafe { ::std::mem::transmute(disposition) };
            disposition as u64
        });
        __bindgen_bitfield_unit.set(24usize, 8u8, {
            let type_: u32 = unsafe { ::std::mem::transmute(type_) };
            type_ as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C, packed(4))]
#[derive(Debug, Copy, Clone)]
pub struct mach_msg_ool_ports_descriptor_t {
    pub address: *mut ::std::os::raw::c_void,
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize], u8>,
    pub count: mach_msg_size_t,
}
#[test]
fn bindgen_test_layout_mach_msg_ool_ports_descriptor_t() {
    assert_eq!(
        ::std::mem::size_of::<mach_msg_ool_ports_descriptor_t>(),
        16usize,
        concat!("Size of: ", stringify!(mach_msg_ool_ports_descriptor_t))
    );
    assert_eq!(
        ::std::mem::align_of::<mach_msg_ool_ports_descriptor_t>(),
        4usize,
        concat!("Alignment of ", stringify!(mach_msg_ool_ports_descriptor_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<mach_msg_ool_ports_descriptor_t>())).address as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_ool_ports_descriptor_t),
            "::",
            stringify!(address)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<mach_msg_ool_ports_descriptor_t>())).count as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_ool_ports_descriptor_t),
            "::",
            stringify!(count)
        )
    );
}
impl mach_msg_ool_ports_descriptor_t {
    #[inline]
    pub fn deallocate(&self) -> boolean_t {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_deallocate(&mut self, val: boolean_t) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn copy(&self) -> mach_msg_copy_options_t {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_copy(&mut self, val: mach_msg_copy_options_t) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn disposition(&self) -> mach_msg_type_name_t {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(16usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_disposition(&mut self, val: mach_msg_type_name_t) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(16usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn type_(&self) -> mach_msg_descriptor_type_t {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(24usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_type(&mut self, val: mach_msg_descriptor_type_t) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(24usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        deallocate: boolean_t,
        copy: mach_msg_copy_options_t,
        disposition: mach_msg_type_name_t,
        type_: mach_msg_descriptor_type_t,
    ) -> __BindgenBitfieldUnit<[u8; 4usize], u8> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize], u8> =
            Default::default();
        __bindgen_bitfield_unit.set(0usize, 8u8, {
            let deallocate: u32 = unsafe { ::std::mem::transmute(deallocate) };
            deallocate as u64
        });
        __bindgen_bitfield_unit.set(8usize, 8u8, {
            let copy: u32 = unsafe { ::std::mem::transmute(copy) };
            copy as u64
        });
        __bindgen_bitfield_unit.set(16usize, 8u8, {
            let disposition: u32 = unsafe { ::std::mem::transmute(disposition) };
            disposition as u64
        });
        __bindgen_bitfield_unit.set(24usize, 8u8, {
            let type_: u32 = unsafe { ::std::mem::transmute(type_) };
            type_ as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct mach_msg_guarded_port_descriptor32_t {
    pub context: u32,
    pub name: mach_port_name_t,
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize], u16>,
}
#[test]
fn bindgen_test_layout_mach_msg_guarded_port_descriptor32_t() {
    assert_eq!(
        ::std::mem::size_of::<mach_msg_guarded_port_descriptor32_t>(),
        12usize,
        concat!(
            "Size of: ",
            stringify!(mach_msg_guarded_port_descriptor32_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<mach_msg_guarded_port_descriptor32_t>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(mach_msg_guarded_port_descriptor32_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<mach_msg_guarded_port_descriptor32_t>())).context as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_guarded_port_descriptor32_t),
            "::",
            stringify!(context)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<mach_msg_guarded_port_descriptor32_t>())).name as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_guarded_port_descriptor32_t),
            "::",
            stringify!(name)
        )
    );
}
impl mach_msg_guarded_port_descriptor32_t {
    #[inline]
    pub fn flags(&self) -> mach_msg_guard_flags_t {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 16u8) as u32) }
    }
    #[inline]
    pub fn set_flags(&mut self, val: mach_msg_guard_flags_t) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 16u8, val as u64)
        }
    }
    #[inline]
    pub fn disposition(&self) -> mach_msg_type_name_t {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(16usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_disposition(&mut self, val: mach_msg_type_name_t) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(16usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn type_(&self) -> mach_msg_descriptor_type_t {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(24usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_type(&mut self, val: mach_msg_descriptor_type_t) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(24usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        flags: mach_msg_guard_flags_t,
        disposition: mach_msg_type_name_t,
        type_: mach_msg_descriptor_type_t,
    ) -> __BindgenBitfieldUnit<[u8; 4usize], u16> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize], u16> =
            Default::default();
        __bindgen_bitfield_unit.set(0usize, 16u8, {
            let flags: u32 = unsafe { ::std::mem::transmute(flags) };
            flags as u64
        });
        __bindgen_bitfield_unit.set(16usize, 8u8, {
            let disposition: u32 = unsafe { ::std::mem::transmute(disposition) };
            disposition as u64
        });
        __bindgen_bitfield_unit.set(24usize, 8u8, {
            let type_: u32 = unsafe { ::std::mem::transmute(type_) };
            type_ as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C, packed(4))]
#[derive(Debug, Copy, Clone)]
pub struct mach_msg_guarded_port_descriptor64_t {
    pub context: u64,
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize], u16>,
    pub name: mach_port_name_t,
}
#[test]
fn bindgen_test_layout_mach_msg_guarded_port_descriptor64_t() {
    assert_eq!(
        ::std::mem::size_of::<mach_msg_guarded_port_descriptor64_t>(),
        16usize,
        concat!(
            "Size of: ",
            stringify!(mach_msg_guarded_port_descriptor64_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<mach_msg_guarded_port_descriptor64_t>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(mach_msg_guarded_port_descriptor64_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<mach_msg_guarded_port_descriptor64_t>())).context as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_guarded_port_descriptor64_t),
            "::",
            stringify!(context)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<mach_msg_guarded_port_descriptor64_t>())).name as *const _
                as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_guarded_port_descriptor64_t),
            "::",
            stringify!(name)
        )
    );
}
impl mach_msg_guarded_port_descriptor64_t {
    #[inline]
    pub fn flags(&self) -> mach_msg_guard_flags_t {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 16u8) as u32) }
    }
    #[inline]
    pub fn set_flags(&mut self, val: mach_msg_guard_flags_t) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 16u8, val as u64)
        }
    }
    #[inline]
    pub fn disposition(&self) -> mach_msg_type_name_t {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(16usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_disposition(&mut self, val: mach_msg_type_name_t) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(16usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn type_(&self) -> mach_msg_descriptor_type_t {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(24usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_type(&mut self, val: mach_msg_descriptor_type_t) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(24usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        flags: mach_msg_guard_flags_t,
        disposition: mach_msg_type_name_t,
        type_: mach_msg_descriptor_type_t,
    ) -> __BindgenBitfieldUnit<[u8; 4usize], u16> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize], u16> =
            Default::default();
        __bindgen_bitfield_unit.set(0usize, 16u8, {
            let flags: u32 = unsafe { ::std::mem::transmute(flags) };
            flags as u64
        });
        __bindgen_bitfield_unit.set(16usize, 8u8, {
            let disposition: u32 = unsafe { ::std::mem::transmute(disposition) };
            disposition as u64
        });
        __bindgen_bitfield_unit.set(24usize, 8u8, {
            let type_: u32 = unsafe { ::std::mem::transmute(type_) };
            type_ as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C, packed(4))]
#[derive(Debug, Copy, Clone)]
pub struct mach_msg_guarded_port_descriptor_t {
    pub context: mach_port_context_t,
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize], u16>,
    pub name: mach_port_name_t,
}
#[test]
fn bindgen_test_layout_mach_msg_guarded_port_descriptor_t() {
    assert_eq!(
        ::std::mem::size_of::<mach_msg_guarded_port_descriptor_t>(),
        16usize,
        concat!("Size of: ", stringify!(mach_msg_guarded_port_descriptor_t))
    );
    assert_eq!(
        ::std::mem::align_of::<mach_msg_guarded_port_descriptor_t>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(mach_msg_guarded_port_descriptor_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<mach_msg_guarded_port_descriptor_t>())).context as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_guarded_port_descriptor_t),
            "::",
            stringify!(context)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<mach_msg_guarded_port_descriptor_t>())).name as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_guarded_port_descriptor_t),
            "::",
            stringify!(name)
        )
    );
}
impl mach_msg_guarded_port_descriptor_t {
    #[inline]
    pub fn flags(&self) -> mach_msg_guard_flags_t {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 16u8) as u32) }
    }
    #[inline]
    pub fn set_flags(&mut self, val: mach_msg_guard_flags_t) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 16u8, val as u64)
        }
    }
    #[inline]
    pub fn disposition(&self) -> mach_msg_type_name_t {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(16usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_disposition(&mut self, val: mach_msg_type_name_t) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(16usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn type_(&self) -> mach_msg_descriptor_type_t {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(24usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_type(&mut self, val: mach_msg_descriptor_type_t) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(24usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        flags: mach_msg_guard_flags_t,
        disposition: mach_msg_type_name_t,
        type_: mach_msg_descriptor_type_t,
    ) -> __BindgenBitfieldUnit<[u8; 4usize], u16> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize], u16> =
            Default::default();
        __bindgen_bitfield_unit.set(0usize, 16u8, {
            let flags: u32 = unsafe { ::std::mem::transmute(flags) };
            flags as u64
        });
        __bindgen_bitfield_unit.set(16usize, 8u8, {
            let disposition: u32 = unsafe { ::std::mem::transmute(disposition) };
            disposition as u64
        });
        __bindgen_bitfield_unit.set(24usize, 8u8, {
            let type_: u32 = unsafe { ::std::mem::transmute(type_) };
            type_ as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union mach_msg_descriptor_t {
    pub port: mach_msg_port_descriptor_t,
    pub out_of_line: mach_msg_ool_descriptor_t,
    pub ool_ports: mach_msg_ool_ports_descriptor_t,
    pub type_: mach_msg_type_descriptor_t,
    pub guarded_port: mach_msg_guarded_port_descriptor_t,
    _bindgen_union_align: [u32; 4usize],
}
#[test]
fn bindgen_test_layout_mach_msg_descriptor_t() {
    assert_eq!(
        ::std::mem::size_of::<mach_msg_descriptor_t>(),
        16usize,
        concat!("Size of: ", stringify!(mach_msg_descriptor_t))
    );
    assert_eq!(
        ::std::mem::align_of::<mach_msg_descriptor_t>(),
        4usize,
        concat!("Alignment of ", stringify!(mach_msg_descriptor_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<mach_msg_descriptor_t>())).port as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_descriptor_t),
            "::",
            stringify!(port)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<mach_msg_descriptor_t>())).out_of_line as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_descriptor_t),
            "::",
            stringify!(out_of_line)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<mach_msg_descriptor_t>())).ool_ports as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_descriptor_t),
            "::",
            stringify!(ool_ports)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<mach_msg_descriptor_t>())).type_ as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_descriptor_t),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<mach_msg_descriptor_t>())).guarded_port as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_descriptor_t),
            "::",
            stringify!(guarded_port)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct mach_msg_body_t {
    pub msgh_descriptor_count: mach_msg_size_t,
}
#[test]
fn bindgen_test_layout_mach_msg_body_t() {
    assert_eq!(
        ::std::mem::size_of::<mach_msg_body_t>(),
        4usize,
        concat!("Size of: ", stringify!(mach_msg_body_t))
    );
    assert_eq!(
        ::std::mem::align_of::<mach_msg_body_t>(),
        4usize,
        concat!("Alignment of ", stringify!(mach_msg_body_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<mach_msg_body_t>())).msgh_descriptor_count as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_body_t),
            "::",
            stringify!(msgh_descriptor_count)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct mach_msg_header_t {
    pub msgh_bits: mach_msg_bits_t,
    pub msgh_size: mach_msg_size_t,
    pub msgh_remote_port: mach_port_t,
    pub msgh_local_port: mach_port_t,
    pub msgh_voucher_port: mach_port_name_t,
    pub msgh_id: mach_msg_id_t,
}
#[test]
fn bindgen_test_layout_mach_msg_header_t() {
    assert_eq!(
        ::std::mem::size_of::<mach_msg_header_t>(),
        24usize,
        concat!("Size of: ", stringify!(mach_msg_header_t))
    );
    assert_eq!(
        ::std::mem::align_of::<mach_msg_header_t>(),
        4usize,
        concat!("Alignment of ", stringify!(mach_msg_header_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<mach_msg_header_t>())).msgh_bits as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_header_t),
            "::",
            stringify!(msgh_bits)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<mach_msg_header_t>())).msgh_size as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_header_t),
            "::",
            stringify!(msgh_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<mach_msg_header_t>())).msgh_remote_port as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_header_t),
            "::",
            stringify!(msgh_remote_port)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<mach_msg_header_t>())).msgh_local_port as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_header_t),
            "::",
            stringify!(msgh_local_port)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<mach_msg_header_t>())).msgh_voucher_port as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_header_t),
            "::",
            stringify!(msgh_voucher_port)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<mach_msg_header_t>())).msgh_id as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_header_t),
            "::",
            stringify!(msgh_id)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct mach_msg_base_t {
    pub header: mach_msg_header_t,
    pub body: mach_msg_body_t,
}
#[test]
fn bindgen_test_layout_mach_msg_base_t() {
    assert_eq!(
        ::std::mem::size_of::<mach_msg_base_t>(),
        28usize,
        concat!("Size of: ", stringify!(mach_msg_base_t))
    );
    assert_eq!(
        ::std::mem::align_of::<mach_msg_base_t>(),
        4usize,
        concat!("Alignment of ", stringify!(mach_msg_base_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<mach_msg_base_t>())).header as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_base_t),
            "::",
            stringify!(header)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<mach_msg_base_t>())).body as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_base_t),
            "::",
            stringify!(body)
        )
    );
}
pub type mach_msg_trailer_type_t = ::std::os::raw::c_uint;
pub type mach_msg_trailer_size_t = ::std::os::raw::c_uint;
pub type mach_msg_trailer_info_t = *mut ::std::os::raw::c_char;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct mach_msg_trailer_t {
    pub msgh_trailer_type: mach_msg_trailer_type_t,
    pub msgh_trailer_size: mach_msg_trailer_size_t,
}
#[test]
fn bindgen_test_layout_mach_msg_trailer_t() {
    assert_eq!(
        ::std::mem::size_of::<mach_msg_trailer_t>(),
        8usize,
        concat!("Size of: ", stringify!(mach_msg_trailer_t))
    );
    assert_eq!(
        ::std::mem::align_of::<mach_msg_trailer_t>(),
        4usize,
        concat!("Alignment of ", stringify!(mach_msg_trailer_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<mach_msg_trailer_t>())).msgh_trailer_type as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_trailer_t),
            "::",
            stringify!(msgh_trailer_type)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<mach_msg_trailer_t>())).msgh_trailer_size as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_trailer_t),
            "::",
            stringify!(msgh_trailer_size)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct mach_msg_seqno_trailer_t {
    pub msgh_trailer_type: mach_msg_trailer_type_t,
    pub msgh_trailer_size: mach_msg_trailer_size_t,
    pub msgh_seqno: mach_port_seqno_t,
}
#[test]
fn bindgen_test_layout_mach_msg_seqno_trailer_t() {
    assert_eq!(
        ::std::mem::size_of::<mach_msg_seqno_trailer_t>(),
        12usize,
        concat!("Size of: ", stringify!(mach_msg_seqno_trailer_t))
    );
    assert_eq!(
        ::std::mem::align_of::<mach_msg_seqno_trailer_t>(),
        4usize,
        concat!("Alignment of ", stringify!(mach_msg_seqno_trailer_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<mach_msg_seqno_trailer_t>())).msgh_trailer_type as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_seqno_trailer_t),
            "::",
            stringify!(msgh_trailer_type)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<mach_msg_seqno_trailer_t>())).msgh_trailer_size as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_seqno_trailer_t),
            "::",
            stringify!(msgh_trailer_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<mach_msg_seqno_trailer_t>())).msgh_seqno as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_seqno_trailer_t),
            "::",
            stringify!(msgh_seqno)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct security_token_t {
    pub val: [::std::os::raw::c_uint; 2usize],
}
#[test]
fn bindgen_test_layout_security_token_t() {
    assert_eq!(
        ::std::mem::size_of::<security_token_t>(),
        8usize,
        concat!("Size of: ", stringify!(security_token_t))
    );
    assert_eq!(
        ::std::mem::align_of::<security_token_t>(),
        4usize,
        concat!("Alignment of ", stringify!(security_token_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<security_token_t>())).val as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(security_token_t),
            "::",
            stringify!(val)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct mach_msg_security_trailer_t {
    pub msgh_trailer_type: mach_msg_trailer_type_t,
    pub msgh_trailer_size: mach_msg_trailer_size_t,
    pub msgh_seqno: mach_port_seqno_t,
    pub msgh_sender: security_token_t,
}
#[test]
fn bindgen_test_layout_mach_msg_security_trailer_t() {
    assert_eq!(
        ::std::mem::size_of::<mach_msg_security_trailer_t>(),
        20usize,
        concat!("Size of: ", stringify!(mach_msg_security_trailer_t))
    );
    assert_eq!(
        ::std::mem::align_of::<mach_msg_security_trailer_t>(),
        4usize,
        concat!("Alignment of ", stringify!(mach_msg_security_trailer_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<mach_msg_security_trailer_t>())).msgh_trailer_type as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_security_trailer_t),
            "::",
            stringify!(msgh_trailer_type)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<mach_msg_security_trailer_t>())).msgh_trailer_size as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_security_trailer_t),
            "::",
            stringify!(msgh_trailer_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<mach_msg_security_trailer_t>())).msgh_seqno as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_security_trailer_t),
            "::",
            stringify!(msgh_seqno)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<mach_msg_security_trailer_t>())).msgh_sender as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_security_trailer_t),
            "::",
            stringify!(msgh_sender)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct audit_token_t {
    pub val: [::std::os::raw::c_uint; 8usize],
}
#[test]
fn bindgen_test_layout_audit_token_t() {
    assert_eq!(
        ::std::mem::size_of::<audit_token_t>(),
        32usize,
        concat!("Size of: ", stringify!(audit_token_t))
    );
    assert_eq!(
        ::std::mem::align_of::<audit_token_t>(),
        4usize,
        concat!("Alignment of ", stringify!(audit_token_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<audit_token_t>())).val as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(audit_token_t),
            "::",
            stringify!(val)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct mach_msg_audit_trailer_t {
    pub msgh_trailer_type: mach_msg_trailer_type_t,
    pub msgh_trailer_size: mach_msg_trailer_size_t,
    pub msgh_seqno: mach_port_seqno_t,
    pub msgh_sender: security_token_t,
    pub msgh_audit: audit_token_t,
}
#[test]
fn bindgen_test_layout_mach_msg_audit_trailer_t() {
    assert_eq!(
        ::std::mem::size_of::<mach_msg_audit_trailer_t>(),
        52usize,
        concat!("Size of: ", stringify!(mach_msg_audit_trailer_t))
    );
    assert_eq!(
        ::std::mem::align_of::<mach_msg_audit_trailer_t>(),
        4usize,
        concat!("Alignment of ", stringify!(mach_msg_audit_trailer_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<mach_msg_audit_trailer_t>())).msgh_trailer_type as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_audit_trailer_t),
            "::",
            stringify!(msgh_trailer_type)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<mach_msg_audit_trailer_t>())).msgh_trailer_size as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_audit_trailer_t),
            "::",
            stringify!(msgh_trailer_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<mach_msg_audit_trailer_t>())).msgh_seqno as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_audit_trailer_t),
            "::",
            stringify!(msgh_seqno)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<mach_msg_audit_trailer_t>())).msgh_sender as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_audit_trailer_t),
            "::",
            stringify!(msgh_sender)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<mach_msg_audit_trailer_t>())).msgh_audit as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_audit_trailer_t),
            "::",
            stringify!(msgh_audit)
        )
    );
}
#[repr(C, packed(4))]
#[derive(Debug, Copy, Clone)]
pub struct mach_msg_context_trailer_t {
    pub msgh_trailer_type: mach_msg_trailer_type_t,
    pub msgh_trailer_size: mach_msg_trailer_size_t,
    pub msgh_seqno: mach_port_seqno_t,
    pub msgh_sender: security_token_t,
    pub msgh_audit: audit_token_t,
    pub msgh_context: mach_port_context_t,
}
#[test]
fn bindgen_test_layout_mach_msg_context_trailer_t() {
    assert_eq!(
        ::std::mem::size_of::<mach_msg_context_trailer_t>(),
        60usize,
        concat!("Size of: ", stringify!(mach_msg_context_trailer_t))
    );
    assert_eq!(
        ::std::mem::align_of::<mach_msg_context_trailer_t>(),
        4usize,
        concat!("Alignment of ", stringify!(mach_msg_context_trailer_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<mach_msg_context_trailer_t>())).msgh_trailer_type as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_context_trailer_t),
            "::",
            stringify!(msgh_trailer_type)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<mach_msg_context_trailer_t>())).msgh_trailer_size as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_context_trailer_t),
            "::",
            stringify!(msgh_trailer_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<mach_msg_context_trailer_t>())).msgh_seqno as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_context_trailer_t),
            "::",
            stringify!(msgh_seqno)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<mach_msg_context_trailer_t>())).msgh_sender as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_context_trailer_t),
            "::",
            stringify!(msgh_sender)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<mach_msg_context_trailer_t>())).msgh_audit as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_context_trailer_t),
            "::",
            stringify!(msgh_audit)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<mach_msg_context_trailer_t>())).msgh_context as *const _ as usize
        },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_context_trailer_t),
            "::",
            stringify!(msgh_context)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct msg_labels_t {
    pub sender: mach_port_name_t,
}
#[test]
fn bindgen_test_layout_msg_labels_t() {
    assert_eq!(
        ::std::mem::size_of::<msg_labels_t>(),
        4usize,
        concat!("Size of: ", stringify!(msg_labels_t))
    );
    assert_eq!(
        ::std::mem::align_of::<msg_labels_t>(),
        4usize,
        concat!("Alignment of ", stringify!(msg_labels_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<msg_labels_t>())).sender as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(msg_labels_t),
            "::",
            stringify!(sender)
        )
    );
}
pub type mach_msg_filter_id = ::std::os::raw::c_int;
#[repr(C, packed(4))]
#[derive(Debug, Copy, Clone)]
pub struct mach_msg_mac_trailer_t {
    pub msgh_trailer_type: mach_msg_trailer_type_t,
    pub msgh_trailer_size: mach_msg_trailer_size_t,
    pub msgh_seqno: mach_port_seqno_t,
    pub msgh_sender: security_token_t,
    pub msgh_audit: audit_token_t,
    pub msgh_context: mach_port_context_t,
    pub msgh_ad: mach_msg_filter_id,
    pub msgh_labels: msg_labels_t,
}
#[test]
fn bindgen_test_layout_mach_msg_mac_trailer_t() {
    assert_eq!(
        ::std::mem::size_of::<mach_msg_mac_trailer_t>(),
        68usize,
        concat!("Size of: ", stringify!(mach_msg_mac_trailer_t))
    );
    assert_eq!(
        ::std::mem::align_of::<mach_msg_mac_trailer_t>(),
        4usize,
        concat!("Alignment of ", stringify!(mach_msg_mac_trailer_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<mach_msg_mac_trailer_t>())).msgh_trailer_type as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_mac_trailer_t),
            "::",
            stringify!(msgh_trailer_type)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<mach_msg_mac_trailer_t>())).msgh_trailer_size as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_mac_trailer_t),
            "::",
            stringify!(msgh_trailer_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<mach_msg_mac_trailer_t>())).msgh_seqno as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_mac_trailer_t),
            "::",
            stringify!(msgh_seqno)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<mach_msg_mac_trailer_t>())).msgh_sender as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_mac_trailer_t),
            "::",
            stringify!(msgh_sender)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<mach_msg_mac_trailer_t>())).msgh_audit as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_mac_trailer_t),
            "::",
            stringify!(msgh_audit)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<mach_msg_mac_trailer_t>())).msgh_context as *const _ as usize
        },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_mac_trailer_t),
            "::",
            stringify!(msgh_context)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<mach_msg_mac_trailer_t>())).msgh_ad as *const _ as usize },
        60usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_mac_trailer_t),
            "::",
            stringify!(msgh_ad)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<mach_msg_mac_trailer_t>())).msgh_labels as *const _ as usize
        },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_mac_trailer_t),
            "::",
            stringify!(msgh_labels)
        )
    );
}
pub type mach_msg_max_trailer_t = mach_msg_mac_trailer_t;
pub type mach_msg_format_0_trailer_t = mach_msg_security_trailer_t;
extern "C" {
    pub static KERNEL_SECURITY_TOKEN: security_token_t;
}
extern "C" {
    pub static KERNEL_AUDIT_TOKEN: audit_token_t;
}
pub type mach_msg_options_t = integer_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct mach_msg_empty_send_t {
    pub header: mach_msg_header_t,
}
#[test]
fn bindgen_test_layout_mach_msg_empty_send_t() {
    assert_eq!(
        ::std::mem::size_of::<mach_msg_empty_send_t>(),
        24usize,
        concat!("Size of: ", stringify!(mach_msg_empty_send_t))
    );
    assert_eq!(
        ::std::mem::align_of::<mach_msg_empty_send_t>(),
        4usize,
        concat!("Alignment of ", stringify!(mach_msg_empty_send_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<mach_msg_empty_send_t>())).header as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_empty_send_t),
            "::",
            stringify!(header)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct mach_msg_empty_rcv_t {
    pub header: mach_msg_header_t,
    pub trailer: mach_msg_trailer_t,
}
#[test]
fn bindgen_test_layout_mach_msg_empty_rcv_t() {
    assert_eq!(
        ::std::mem::size_of::<mach_msg_empty_rcv_t>(),
        32usize,
        concat!("Size of: ", stringify!(mach_msg_empty_rcv_t))
    );
    assert_eq!(
        ::std::mem::align_of::<mach_msg_empty_rcv_t>(),
        4usize,
        concat!("Alignment of ", stringify!(mach_msg_empty_rcv_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<mach_msg_empty_rcv_t>())).header as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_empty_rcv_t),
            "::",
            stringify!(header)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<mach_msg_empty_rcv_t>())).trailer as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_empty_rcv_t),
            "::",
            stringify!(trailer)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union mach_msg_empty_t {
    pub send: mach_msg_empty_send_t,
    pub rcv: mach_msg_empty_rcv_t,
    _bindgen_union_align: [u32; 8usize],
}
#[test]
fn bindgen_test_layout_mach_msg_empty_t() {
    assert_eq!(
        ::std::mem::size_of::<mach_msg_empty_t>(),
        32usize,
        concat!("Size of: ", stringify!(mach_msg_empty_t))
    );
    assert_eq!(
        ::std::mem::align_of::<mach_msg_empty_t>(),
        4usize,
        concat!("Alignment of ", stringify!(mach_msg_empty_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<mach_msg_empty_t>())).send as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_empty_t),
            "::",
            stringify!(send)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<mach_msg_empty_t>())).rcv as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_empty_t),
            "::",
            stringify!(rcv)
        )
    );
}
pub type mach_msg_type_size_t = natural_t;
pub type mach_msg_type_number_t = natural_t;
pub type mach_msg_option_t = integer_t;
pub type mach_msg_return_t = kern_return_t;
extern "C" {
    pub fn mach_msg_overwrite(
        msg: *mut mach_msg_header_t,
        option: mach_msg_option_t,
        send_size: mach_msg_size_t,
        rcv_size: mach_msg_size_t,
        rcv_name: mach_port_name_t,
        timeout: mach_msg_timeout_t,
        notify: mach_port_name_t,
        rcv_msg: *mut mach_msg_header_t,
        rcv_limit: mach_msg_size_t,
    ) -> mach_msg_return_t;
}
extern "C" {
    pub fn mach_msg(
        msg: *mut mach_msg_header_t,
        option: mach_msg_option_t,
        send_size: mach_msg_size_t,
        rcv_size: mach_msg_size_t,
        rcv_name: mach_port_name_t,
        timeout: mach_msg_timeout_t,
        notify: mach_port_name_t,
    ) -> mach_msg_return_t;
}
extern "C" {
    pub fn mach_voucher_deallocate(voucher: mach_port_name_t) -> kern_return_t;
}
pub type sig_atomic_t = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_i386_thread_state {
    pub __eax: ::std::os::raw::c_uint,
    pub __ebx: ::std::os::raw::c_uint,
    pub __ecx: ::std::os::raw::c_uint,
    pub __edx: ::std::os::raw::c_uint,
    pub __edi: ::std::os::raw::c_uint,
    pub __esi: ::std::os::raw::c_uint,
    pub __ebp: ::std::os::raw::c_uint,
    pub __esp: ::std::os::raw::c_uint,
    pub __ss: ::std::os::raw::c_uint,
    pub __eflags: ::std::os::raw::c_uint,
    pub __eip: ::std::os::raw::c_uint,
    pub __cs: ::std::os::raw::c_uint,
    pub __ds: ::std::os::raw::c_uint,
    pub __es: ::std::os::raw::c_uint,
    pub __fs: ::std::os::raw::c_uint,
    pub __gs: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout___darwin_i386_thread_state() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_i386_thread_state>(),
        64usize,
        concat!("Size of: ", stringify!(__darwin_i386_thread_state))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_i386_thread_state>(),
        4usize,
        concat!("Alignment of ", stringify!(__darwin_i386_thread_state))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_thread_state>())).__eax as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__eax)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_thread_state>())).__ebx as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__ebx)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_thread_state>())).__ecx as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__ecx)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_thread_state>())).__edx as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__edx)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_thread_state>())).__edi as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__edi)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_thread_state>())).__esi as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__esi)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_thread_state>())).__ebp as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__ebp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_thread_state>())).__esp as *const _ as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__esp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_i386_thread_state>())).__ss as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__ss)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_thread_state>())).__eflags as *const _ as usize
        },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__eflags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_thread_state>())).__eip as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__eip)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_i386_thread_state>())).__cs as *const _ as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__cs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_i386_thread_state>())).__ds as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__ds)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_i386_thread_state>())).__es as *const _ as usize },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__es)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_i386_thread_state>())).__fs as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__fs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_i386_thread_state>())).__gs as *const _ as usize },
        60usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__gs)
        )
    );
}
#[repr(C)]
#[repr(align(2))]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_fp_control {
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 2usize], u8>,
}
#[test]
fn bindgen_test_layout___darwin_fp_control() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_fp_control>(),
        2usize,
        concat!("Size of: ", stringify!(__darwin_fp_control))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_fp_control>(),
        2usize,
        concat!("Alignment of ", stringify!(__darwin_fp_control))
    );
}
impl __darwin_fp_control {
    #[inline]
    pub fn __invalid(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___invalid(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __denorm(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___denorm(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __zdiv(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___zdiv(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __ovrfl(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___ovrfl(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __undfl(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___undfl(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __precis(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___precis(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __pc(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 2u8) as u16) }
    }
    #[inline]
    pub fn set___pc(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn __rc(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(10usize, 2u8) as u16) }
    }
    #[inline]
    pub fn set___rc(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(10usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        __invalid: ::std::os::raw::c_ushort,
        __denorm: ::std::os::raw::c_ushort,
        __zdiv: ::std::os::raw::c_ushort,
        __ovrfl: ::std::os::raw::c_ushort,
        __undfl: ::std::os::raw::c_ushort,
        __precis: ::std::os::raw::c_ushort,
        __pc: ::std::os::raw::c_ushort,
        __rc: ::std::os::raw::c_ushort,
    ) -> __BindgenBitfieldUnit<[u8; 2usize], u8> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 2usize], u8> =
            Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let __invalid: u16 = unsafe { ::std::mem::transmute(__invalid) };
            __invalid as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let __denorm: u16 = unsafe { ::std::mem::transmute(__denorm) };
            __denorm as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let __zdiv: u16 = unsafe { ::std::mem::transmute(__zdiv) };
            __zdiv as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let __ovrfl: u16 = unsafe { ::std::mem::transmute(__ovrfl) };
            __ovrfl as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let __undfl: u16 = unsafe { ::std::mem::transmute(__undfl) };
            __undfl as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let __precis: u16 = unsafe { ::std::mem::transmute(__precis) };
            __precis as u64
        });
        __bindgen_bitfield_unit.set(8usize, 2u8, {
            let __pc: u16 = unsafe { ::std::mem::transmute(__pc) };
            __pc as u64
        });
        __bindgen_bitfield_unit.set(10usize, 2u8, {
            let __rc: u16 = unsafe { ::std::mem::transmute(__rc) };
            __rc as u64
        });
        __bindgen_bitfield_unit
    }
}
pub type __darwin_fp_control_t = __darwin_fp_control;
#[repr(C)]
#[repr(align(2))]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_fp_status {
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 2usize], u8>,
}
#[test]
fn bindgen_test_layout___darwin_fp_status() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_fp_status>(),
        2usize,
        concat!("Size of: ", stringify!(__darwin_fp_status))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_fp_status>(),
        2usize,
        concat!("Alignment of ", stringify!(__darwin_fp_status))
    );
}
impl __darwin_fp_status {
    #[inline]
    pub fn __invalid(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___invalid(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __denorm(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___denorm(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __zdiv(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___zdiv(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __ovrfl(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___ovrfl(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __undfl(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___undfl(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __precis(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___precis(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __stkflt(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(6usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___stkflt(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(6usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __errsumm(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(7usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___errsumm(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(7usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __c0(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___c0(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __c1(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(9usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___c1(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(9usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __c2(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(10usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___c2(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(10usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __tos(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(11usize, 3u8) as u16) }
    }
    #[inline]
    pub fn set___tos(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(11usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub fn __c3(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(14usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___c3(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(14usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __busy(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(15usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___busy(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(15usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        __invalid: ::std::os::raw::c_ushort,
        __denorm: ::std::os::raw::c_ushort,
        __zdiv: ::std::os::raw::c_ushort,
        __ovrfl: ::std::os::raw::c_ushort,
        __undfl: ::std::os::raw::c_ushort,
        __precis: ::std::os::raw::c_ushort,
        __stkflt: ::std::os::raw::c_ushort,
        __errsumm: ::std::os::raw::c_ushort,
        __c0: ::std::os::raw::c_ushort,
        __c1: ::std::os::raw::c_ushort,
        __c2: ::std::os::raw::c_ushort,
        __tos: ::std::os::raw::c_ushort,
        __c3: ::std::os::raw::c_ushort,
        __busy: ::std::os::raw::c_ushort,
    ) -> __BindgenBitfieldUnit<[u8; 2usize], u8> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 2usize], u8> =
            Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let __invalid: u16 = unsafe { ::std::mem::transmute(__invalid) };
            __invalid as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let __denorm: u16 = unsafe { ::std::mem::transmute(__denorm) };
            __denorm as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let __zdiv: u16 = unsafe { ::std::mem::transmute(__zdiv) };
            __zdiv as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let __ovrfl: u16 = unsafe { ::std::mem::transmute(__ovrfl) };
            __ovrfl as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let __undfl: u16 = unsafe { ::std::mem::transmute(__undfl) };
            __undfl as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let __precis: u16 = unsafe { ::std::mem::transmute(__precis) };
            __precis as u64
        });
        __bindgen_bitfield_unit.set(6usize, 1u8, {
            let __stkflt: u16 = unsafe { ::std::mem::transmute(__stkflt) };
            __stkflt as u64
        });
        __bindgen_bitfield_unit.set(7usize, 1u8, {
            let __errsumm: u16 = unsafe { ::std::mem::transmute(__errsumm) };
            __errsumm as u64
        });
        __bindgen_bitfield_unit.set(8usize, 1u8, {
            let __c0: u16 = unsafe { ::std::mem::transmute(__c0) };
            __c0 as u64
        });
        __bindgen_bitfield_unit.set(9usize, 1u8, {
            let __c1: u16 = unsafe { ::std::mem::transmute(__c1) };
            __c1 as u64
        });
        __bindgen_bitfield_unit.set(10usize, 1u8, {
            let __c2: u16 = unsafe { ::std::mem::transmute(__c2) };
            __c2 as u64
        });
        __bindgen_bitfield_unit.set(11usize, 3u8, {
            let __tos: u16 = unsafe { ::std::mem::transmute(__tos) };
            __tos as u64
        });
        __bindgen_bitfield_unit.set(14usize, 1u8, {
            let __c3: u16 = unsafe { ::std::mem::transmute(__c3) };
            __c3 as u64
        });
        __bindgen_bitfield_unit.set(15usize, 1u8, {
            let __busy: u16 = unsafe { ::std::mem::transmute(__busy) };
            __busy as u64
        });
        __bindgen_bitfield_unit
    }
}
pub type __darwin_fp_status_t = __darwin_fp_status;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_mmst_reg {
    pub __mmst_reg: [::std::os::raw::c_char; 10usize],
    pub __mmst_rsrv: [::std::os::raw::c_char; 6usize],
}
#[test]
fn bindgen_test_layout___darwin_mmst_reg() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_mmst_reg>(),
        16usize,
        concat!("Size of: ", stringify!(__darwin_mmst_reg))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_mmst_reg>(),
        1usize,
        concat!("Alignment of ", stringify!(__darwin_mmst_reg))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_mmst_reg>())).__mmst_reg as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mmst_reg),
            "::",
            stringify!(__mmst_reg)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_mmst_reg>())).__mmst_rsrv as *const _ as usize },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mmst_reg),
            "::",
            stringify!(__mmst_rsrv)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_xmm_reg {
    pub __xmm_reg: [::std::os::raw::c_char; 16usize],
}
#[test]
fn bindgen_test_layout___darwin_xmm_reg() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_xmm_reg>(),
        16usize,
        concat!("Size of: ", stringify!(__darwin_xmm_reg))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_xmm_reg>(),
        1usize,
        concat!("Alignment of ", stringify!(__darwin_xmm_reg))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_xmm_reg>())).__xmm_reg as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_xmm_reg),
            "::",
            stringify!(__xmm_reg)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_ymm_reg {
    pub __ymm_reg: [::std::os::raw::c_char; 32usize],
}
#[test]
fn bindgen_test_layout___darwin_ymm_reg() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_ymm_reg>(),
        32usize,
        concat!("Size of: ", stringify!(__darwin_ymm_reg))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_ymm_reg>(),
        1usize,
        concat!("Alignment of ", stringify!(__darwin_ymm_reg))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_ymm_reg>())).__ymm_reg as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_ymm_reg),
            "::",
            stringify!(__ymm_reg)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct __darwin_zmm_reg {
    pub __zmm_reg: [::std::os::raw::c_char; 64usize],
}
#[test]
fn bindgen_test_layout___darwin_zmm_reg() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_zmm_reg>(),
        64usize,
        concat!("Size of: ", stringify!(__darwin_zmm_reg))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_zmm_reg>(),
        1usize,
        concat!("Alignment of ", stringify!(__darwin_zmm_reg))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_zmm_reg>())).__zmm_reg as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_zmm_reg),
            "::",
            stringify!(__zmm_reg)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_opmask_reg {
    pub __opmask_reg: [::std::os::raw::c_char; 8usize],
}
#[test]
fn bindgen_test_layout___darwin_opmask_reg() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_opmask_reg>(),
        8usize,
        concat!("Size of: ", stringify!(__darwin_opmask_reg))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_opmask_reg>(),
        1usize,
        concat!("Alignment of ", stringify!(__darwin_opmask_reg))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_opmask_reg>())).__opmask_reg as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_opmask_reg),
            "::",
            stringify!(__opmask_reg)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct __darwin_i386_float_state {
    pub __fpu_reserved: [::std::os::raw::c_int; 2usize],
    pub __fpu_fcw: __darwin_fp_control,
    pub __fpu_fsw: __darwin_fp_status,
    pub __fpu_ftw: __uint8_t,
    pub __fpu_rsrv1: __uint8_t,
    pub __fpu_fop: __uint16_t,
    pub __fpu_ip: __uint32_t,
    pub __fpu_cs: __uint16_t,
    pub __fpu_rsrv2: __uint16_t,
    pub __fpu_dp: __uint32_t,
    pub __fpu_ds: __uint16_t,
    pub __fpu_rsrv3: __uint16_t,
    pub __fpu_mxcsr: __uint32_t,
    pub __fpu_mxcsrmask: __uint32_t,
    pub __fpu_stmm0: __darwin_mmst_reg,
    pub __fpu_stmm1: __darwin_mmst_reg,
    pub __fpu_stmm2: __darwin_mmst_reg,
    pub __fpu_stmm3: __darwin_mmst_reg,
    pub __fpu_stmm4: __darwin_mmst_reg,
    pub __fpu_stmm5: __darwin_mmst_reg,
    pub __fpu_stmm6: __darwin_mmst_reg,
    pub __fpu_stmm7: __darwin_mmst_reg,
    pub __fpu_xmm0: __darwin_xmm_reg,
    pub __fpu_xmm1: __darwin_xmm_reg,
    pub __fpu_xmm2: __darwin_xmm_reg,
    pub __fpu_xmm3: __darwin_xmm_reg,
    pub __fpu_xmm4: __darwin_xmm_reg,
    pub __fpu_xmm5: __darwin_xmm_reg,
    pub __fpu_xmm6: __darwin_xmm_reg,
    pub __fpu_xmm7: __darwin_xmm_reg,
    pub __fpu_rsrv4: [::std::os::raw::c_char; 224usize],
    pub __fpu_reserved1: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout___darwin_i386_float_state() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_i386_float_state>(),
        524usize,
        concat!("Size of: ", stringify!(__darwin_i386_float_state))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_i386_float_state>(),
        4usize,
        concat!("Alignment of ", stringify!(__darwin_i386_float_state))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_reserved as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_reserved)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_fcw as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_fcw)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_fsw as *const _ as usize
        },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_fsw)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_ftw as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_ftw)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_rsrv1 as *const _ as usize
        },
        13usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_rsrv1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_fop as *const _ as usize
        },
        14usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_fop)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_ip as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_ip)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_cs as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_cs)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_rsrv2 as *const _ as usize
        },
        22usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_rsrv2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_dp as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_dp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_ds as *const _ as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_ds)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_rsrv3 as *const _ as usize
        },
        30usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_rsrv3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_mxcsr as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_mxcsr)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_mxcsrmask as *const _
                as usize
        },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_mxcsrmask)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_stmm0 as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_stmm0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_stmm1 as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_stmm1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_stmm2 as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_stmm2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_stmm3 as *const _ as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_stmm3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_stmm4 as *const _ as usize
        },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_stmm4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_stmm5 as *const _ as usize
        },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_stmm5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_stmm6 as *const _ as usize
        },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_stmm6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_stmm7 as *const _ as usize
        },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_stmm7)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_xmm0 as *const _ as usize
        },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_xmm0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_xmm1 as *const _ as usize
        },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_xmm1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_xmm2 as *const _ as usize
        },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_xmm2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_xmm3 as *const _ as usize
        },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_xmm3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_xmm4 as *const _ as usize
        },
        232usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_xmm4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_xmm5 as *const _ as usize
        },
        248usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_xmm5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_xmm6 as *const _ as usize
        },
        264usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_xmm6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_xmm7 as *const _ as usize
        },
        280usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_xmm7)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_rsrv4 as *const _ as usize
        },
        296usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_rsrv4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_reserved1 as *const _
                as usize
        },
        520usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_reserved1)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct __darwin_i386_avx_state {
    pub __fpu_reserved: [::std::os::raw::c_int; 2usize],
    pub __fpu_fcw: __darwin_fp_control,
    pub __fpu_fsw: __darwin_fp_status,
    pub __fpu_ftw: __uint8_t,
    pub __fpu_rsrv1: __uint8_t,
    pub __fpu_fop: __uint16_t,
    pub __fpu_ip: __uint32_t,
    pub __fpu_cs: __uint16_t,
    pub __fpu_rsrv2: __uint16_t,
    pub __fpu_dp: __uint32_t,
    pub __fpu_ds: __uint16_t,
    pub __fpu_rsrv3: __uint16_t,
    pub __fpu_mxcsr: __uint32_t,
    pub __fpu_mxcsrmask: __uint32_t,
    pub __fpu_stmm0: __darwin_mmst_reg,
    pub __fpu_stmm1: __darwin_mmst_reg,
    pub __fpu_stmm2: __darwin_mmst_reg,
    pub __fpu_stmm3: __darwin_mmst_reg,
    pub __fpu_stmm4: __darwin_mmst_reg,
    pub __fpu_stmm5: __darwin_mmst_reg,
    pub __fpu_stmm6: __darwin_mmst_reg,
    pub __fpu_stmm7: __darwin_mmst_reg,
    pub __fpu_xmm0: __darwin_xmm_reg,
    pub __fpu_xmm1: __darwin_xmm_reg,
    pub __fpu_xmm2: __darwin_xmm_reg,
    pub __fpu_xmm3: __darwin_xmm_reg,
    pub __fpu_xmm4: __darwin_xmm_reg,
    pub __fpu_xmm5: __darwin_xmm_reg,
    pub __fpu_xmm6: __darwin_xmm_reg,
    pub __fpu_xmm7: __darwin_xmm_reg,
    pub __fpu_rsrv4: [::std::os::raw::c_char; 224usize],
    pub __fpu_reserved1: ::std::os::raw::c_int,
    pub __avx_reserved1: [::std::os::raw::c_char; 64usize],
    pub __fpu_ymmh0: __darwin_xmm_reg,
    pub __fpu_ymmh1: __darwin_xmm_reg,
    pub __fpu_ymmh2: __darwin_xmm_reg,
    pub __fpu_ymmh3: __darwin_xmm_reg,
    pub __fpu_ymmh4: __darwin_xmm_reg,
    pub __fpu_ymmh5: __darwin_xmm_reg,
    pub __fpu_ymmh6: __darwin_xmm_reg,
    pub __fpu_ymmh7: __darwin_xmm_reg,
}
#[test]
fn bindgen_test_layout___darwin_i386_avx_state() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_i386_avx_state>(),
        716usize,
        concat!("Size of: ", stringify!(__darwin_i386_avx_state))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_i386_avx_state>(),
        4usize,
        concat!("Alignment of ", stringify!(__darwin_i386_avx_state))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_reserved as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_reserved)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_fcw as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_fcw)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_fsw as *const _ as usize
        },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_fsw)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_ftw as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_ftw)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_rsrv1 as *const _ as usize
        },
        13usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_rsrv1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_fop as *const _ as usize
        },
        14usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_fop)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_ip as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_ip)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_cs as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_cs)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_rsrv2 as *const _ as usize
        },
        22usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_rsrv2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_dp as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_dp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_ds as *const _ as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_ds)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_rsrv3 as *const _ as usize
        },
        30usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_rsrv3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_mxcsr as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_mxcsr)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_mxcsrmask as *const _ as usize
        },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_mxcsrmask)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_stmm0 as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_stmm0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_stmm1 as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_stmm1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_stmm2 as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_stmm2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_stmm3 as *const _ as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_stmm3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_stmm4 as *const _ as usize
        },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_stmm4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_stmm5 as *const _ as usize
        },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_stmm5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_stmm6 as *const _ as usize
        },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_stmm6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_stmm7 as *const _ as usize
        },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_stmm7)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_xmm0 as *const _ as usize
        },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_xmm0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_xmm1 as *const _ as usize
        },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_xmm1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_xmm2 as *const _ as usize
        },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_xmm2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_xmm3 as *const _ as usize
        },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_xmm3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_xmm4 as *const _ as usize
        },
        232usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_xmm4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_xmm5 as *const _ as usize
        },
        248usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_xmm5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_xmm6 as *const _ as usize
        },
        264usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_xmm6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_xmm7 as *const _ as usize
        },
        280usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_xmm7)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_rsrv4 as *const _ as usize
        },
        296usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_rsrv4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_reserved1 as *const _ as usize
        },
        520usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_reserved1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__avx_reserved1 as *const _ as usize
        },
        524usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__avx_reserved1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_ymmh0 as *const _ as usize
        },
        588usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_ymmh0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_ymmh1 as *const _ as usize
        },
        604usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_ymmh1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_ymmh2 as *const _ as usize
        },
        620usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_ymmh2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_ymmh3 as *const _ as usize
        },
        636usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_ymmh3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_ymmh4 as *const _ as usize
        },
        652usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_ymmh4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_ymmh5 as *const _ as usize
        },
        668usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_ymmh5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_ymmh6 as *const _ as usize
        },
        684usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_ymmh6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_ymmh7 as *const _ as usize
        },
        700usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_ymmh7)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct __darwin_i386_avx512_state {
    pub __fpu_reserved: [::std::os::raw::c_int; 2usize],
    pub __fpu_fcw: __darwin_fp_control,
    pub __fpu_fsw: __darwin_fp_status,
    pub __fpu_ftw: __uint8_t,
    pub __fpu_rsrv1: __uint8_t,
    pub __fpu_fop: __uint16_t,
    pub __fpu_ip: __uint32_t,
    pub __fpu_cs: __uint16_t,
    pub __fpu_rsrv2: __uint16_t,
    pub __fpu_dp: __uint32_t,
    pub __fpu_ds: __uint16_t,
    pub __fpu_rsrv3: __uint16_t,
    pub __fpu_mxcsr: __uint32_t,
    pub __fpu_mxcsrmask: __uint32_t,
    pub __fpu_stmm0: __darwin_mmst_reg,
    pub __fpu_stmm1: __darwin_mmst_reg,
    pub __fpu_stmm2: __darwin_mmst_reg,
    pub __fpu_stmm3: __darwin_mmst_reg,
    pub __fpu_stmm4: __darwin_mmst_reg,
    pub __fpu_stmm5: __darwin_mmst_reg,
    pub __fpu_stmm6: __darwin_mmst_reg,
    pub __fpu_stmm7: __darwin_mmst_reg,
    pub __fpu_xmm0: __darwin_xmm_reg,
    pub __fpu_xmm1: __darwin_xmm_reg,
    pub __fpu_xmm2: __darwin_xmm_reg,
    pub __fpu_xmm3: __darwin_xmm_reg,
    pub __fpu_xmm4: __darwin_xmm_reg,
    pub __fpu_xmm5: __darwin_xmm_reg,
    pub __fpu_xmm6: __darwin_xmm_reg,
    pub __fpu_xmm7: __darwin_xmm_reg,
    pub __fpu_rsrv4: [::std::os::raw::c_char; 224usize],
    pub __fpu_reserved1: ::std::os::raw::c_int,
    pub __avx_reserved1: [::std::os::raw::c_char; 64usize],
    pub __fpu_ymmh0: __darwin_xmm_reg,
    pub __fpu_ymmh1: __darwin_xmm_reg,
    pub __fpu_ymmh2: __darwin_xmm_reg,
    pub __fpu_ymmh3: __darwin_xmm_reg,
    pub __fpu_ymmh4: __darwin_xmm_reg,
    pub __fpu_ymmh5: __darwin_xmm_reg,
    pub __fpu_ymmh6: __darwin_xmm_reg,
    pub __fpu_ymmh7: __darwin_xmm_reg,
    pub __fpu_k0: __darwin_opmask_reg,
    pub __fpu_k1: __darwin_opmask_reg,
    pub __fpu_k2: __darwin_opmask_reg,
    pub __fpu_k3: __darwin_opmask_reg,
    pub __fpu_k4: __darwin_opmask_reg,
    pub __fpu_k5: __darwin_opmask_reg,
    pub __fpu_k6: __darwin_opmask_reg,
    pub __fpu_k7: __darwin_opmask_reg,
    pub __fpu_zmmh0: __darwin_ymm_reg,
    pub __fpu_zmmh1: __darwin_ymm_reg,
    pub __fpu_zmmh2: __darwin_ymm_reg,
    pub __fpu_zmmh3: __darwin_ymm_reg,
    pub __fpu_zmmh4: __darwin_ymm_reg,
    pub __fpu_zmmh5: __darwin_ymm_reg,
    pub __fpu_zmmh6: __darwin_ymm_reg,
    pub __fpu_zmmh7: __darwin_ymm_reg,
}
#[test]
fn bindgen_test_layout___darwin_i386_avx512_state() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_i386_avx512_state>(),
        1036usize,
        concat!("Size of: ", stringify!(__darwin_i386_avx512_state))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_i386_avx512_state>(),
        4usize,
        concat!("Alignment of ", stringify!(__darwin_i386_avx512_state))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_reserved as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_reserved)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_fcw as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_fcw)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_fsw as *const _ as usize
        },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_fsw)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_ftw as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_ftw)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_rsrv1 as *const _ as usize
        },
        13usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_rsrv1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_fop as *const _ as usize
        },
        14usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_fop)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_ip as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_ip)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_cs as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_cs)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_rsrv2 as *const _ as usize
        },
        22usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_rsrv2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_dp as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_dp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_ds as *const _ as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_ds)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_rsrv3 as *const _ as usize
        },
        30usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_rsrv3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_mxcsr as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_mxcsr)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_mxcsrmask as *const _
                as usize
        },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_mxcsrmask)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_stmm0 as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_stmm0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_stmm1 as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_stmm1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_stmm2 as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_stmm2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_stmm3 as *const _ as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_stmm3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_stmm4 as *const _ as usize
        },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_stmm4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_stmm5 as *const _ as usize
        },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_stmm5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_stmm6 as *const _ as usize
        },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_stmm6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_stmm7 as *const _ as usize
        },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_stmm7)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_xmm0 as *const _ as usize
        },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_xmm0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_xmm1 as *const _ as usize
        },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_xmm1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_xmm2 as *const _ as usize
        },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_xmm2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_xmm3 as *const _ as usize
        },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_xmm3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_xmm4 as *const _ as usize
        },
        232usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_xmm4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_xmm5 as *const _ as usize
        },
        248usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_xmm5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_xmm6 as *const _ as usize
        },
        264usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_xmm6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_xmm7 as *const _ as usize
        },
        280usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_xmm7)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_rsrv4 as *const _ as usize
        },
        296usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_rsrv4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_reserved1 as *const _
                as usize
        },
        520usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_reserved1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__avx_reserved1 as *const _
                as usize
        },
        524usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__avx_reserved1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_ymmh0 as *const _ as usize
        },
        588usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_ymmh0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_ymmh1 as *const _ as usize
        },
        604usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_ymmh1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_ymmh2 as *const _ as usize
        },
        620usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_ymmh2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_ymmh3 as *const _ as usize
        },
        636usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_ymmh3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_ymmh4 as *const _ as usize
        },
        652usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_ymmh4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_ymmh5 as *const _ as usize
        },
        668usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_ymmh5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_ymmh6 as *const _ as usize
        },
        684usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_ymmh6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_ymmh7 as *const _ as usize
        },
        700usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_ymmh7)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_k0 as *const _ as usize
        },
        716usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_k0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_k1 as *const _ as usize
        },
        724usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_k1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_k2 as *const _ as usize
        },
        732usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_k2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_k3 as *const _ as usize
        },
        740usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_k3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_k4 as *const _ as usize
        },
        748usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_k4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_k5 as *const _ as usize
        },
        756usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_k5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_k6 as *const _ as usize
        },
        764usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_k6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_k7 as *const _ as usize
        },
        772usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_k7)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_zmmh0 as *const _ as usize
        },
        780usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_zmmh0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_zmmh1 as *const _ as usize
        },
        812usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_zmmh1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_zmmh2 as *const _ as usize
        },
        844usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_zmmh2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_zmmh3 as *const _ as usize
        },
        876usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_zmmh3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_zmmh4 as *const _ as usize
        },
        908usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_zmmh4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_zmmh5 as *const _ as usize
        },
        940usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_zmmh5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_zmmh6 as *const _ as usize
        },
        972usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_zmmh6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_zmmh7 as *const _ as usize
        },
        1004usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_zmmh7)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_i386_exception_state {
    pub __trapno: __uint16_t,
    pub __cpu: __uint16_t,
    pub __err: __uint32_t,
    pub __faultvaddr: __uint32_t,
}
#[test]
fn bindgen_test_layout___darwin_i386_exception_state() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_i386_exception_state>(),
        12usize,
        concat!("Size of: ", stringify!(__darwin_i386_exception_state))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_i386_exception_state>(),
        4usize,
        concat!("Alignment of ", stringify!(__darwin_i386_exception_state))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_exception_state>())).__trapno as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_exception_state),
            "::",
            stringify!(__trapno)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_exception_state>())).__cpu as *const _ as usize
        },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_exception_state),
            "::",
            stringify!(__cpu)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_exception_state>())).__err as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_exception_state),
            "::",
            stringify!(__err)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_exception_state>())).__faultvaddr as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_exception_state),
            "::",
            stringify!(__faultvaddr)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_x86_debug_state32 {
    pub __dr0: ::std::os::raw::c_uint,
    pub __dr1: ::std::os::raw::c_uint,
    pub __dr2: ::std::os::raw::c_uint,
    pub __dr3: ::std::os::raw::c_uint,
    pub __dr4: ::std::os::raw::c_uint,
    pub __dr5: ::std::os::raw::c_uint,
    pub __dr6: ::std::os::raw::c_uint,
    pub __dr7: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout___darwin_x86_debug_state32() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_x86_debug_state32>(),
        32usize,
        concat!("Size of: ", stringify!(__darwin_x86_debug_state32))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_x86_debug_state32>(),
        4usize,
        concat!("Alignment of ", stringify!(__darwin_x86_debug_state32))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_debug_state32>())).__dr0 as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state32),
            "::",
            stringify!(__dr0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_debug_state32>())).__dr1 as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state32),
            "::",
            stringify!(__dr1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_debug_state32>())).__dr2 as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state32),
            "::",
            stringify!(__dr2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_debug_state32>())).__dr3 as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state32),
            "::",
            stringify!(__dr3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_debug_state32>())).__dr4 as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state32),
            "::",
            stringify!(__dr4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_debug_state32>())).__dr5 as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state32),
            "::",
            stringify!(__dr5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_debug_state32>())).__dr6 as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state32),
            "::",
            stringify!(__dr6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_debug_state32>())).__dr7 as *const _ as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state32),
            "::",
            stringify!(__dr7)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __x86_pagein_state {
    pub __pagein_error: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout___x86_pagein_state() {
    assert_eq!(
        ::std::mem::size_of::<__x86_pagein_state>(),
        4usize,
        concat!("Size of: ", stringify!(__x86_pagein_state))
    );
    assert_eq!(
        ::std::mem::align_of::<__x86_pagein_state>(),
        4usize,
        concat!("Alignment of ", stringify!(__x86_pagein_state))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__x86_pagein_state>())).__pagein_error as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__x86_pagein_state),
            "::",
            stringify!(__pagein_error)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_x86_thread_state64 {
    pub __rax: __uint64_t,
    pub __rbx: __uint64_t,
    pub __rcx: __uint64_t,
    pub __rdx: __uint64_t,
    pub __rdi: __uint64_t,
    pub __rsi: __uint64_t,
    pub __rbp: __uint64_t,
    pub __rsp: __uint64_t,
    pub __r8: __uint64_t,
    pub __r9: __uint64_t,
    pub __r10: __uint64_t,
    pub __r11: __uint64_t,
    pub __r12: __uint64_t,
    pub __r13: __uint64_t,
    pub __r14: __uint64_t,
    pub __r15: __uint64_t,
    pub __rip: __uint64_t,
    pub __rflags: __uint64_t,
    pub __cs: __uint64_t,
    pub __fs: __uint64_t,
    pub __gs: __uint64_t,
}
#[test]
fn bindgen_test_layout___darwin_x86_thread_state64() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_x86_thread_state64>(),
        168usize,
        concat!("Size of: ", stringify!(__darwin_x86_thread_state64))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_x86_thread_state64>(),
        8usize,
        concat!("Alignment of ", stringify!(__darwin_x86_thread_state64))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__rax as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__rax)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__rbx as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__rbx)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__rcx as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__rcx)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__rdx as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__rdx)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__rdi as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__rdi)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__rsi as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__rsi)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__rbp as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__rbp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__rsp as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__rsp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__r8 as *const _ as usize
        },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__r8)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__r9 as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__r9)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__r10 as *const _ as usize
        },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__r10)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__r11 as *const _ as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__r11)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__r12 as *const _ as usize
        },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__r12)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__r13 as *const _ as usize
        },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__r13)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__r14 as *const _ as usize
        },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__r14)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__r15 as *const _ as usize
        },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__r15)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__rip as *const _ as usize
        },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__rip)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__rflags as *const _ as usize
        },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__rflags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__cs as *const _ as usize
        },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__cs)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__fs as *const _ as usize
        },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__fs)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__gs as *const _ as usize
        },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__gs)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_x86_thread_full_state64 {
    pub __ss64: __darwin_x86_thread_state64,
    pub __ds: __uint64_t,
    pub __es: __uint64_t,
    pub __ss: __uint64_t,
    pub __gsbase: __uint64_t,
}
#[test]
fn bindgen_test_layout___darwin_x86_thread_full_state64() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_x86_thread_full_state64>(),
        200usize,
        concat!("Size of: ", stringify!(__darwin_x86_thread_full_state64))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_x86_thread_full_state64>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__darwin_x86_thread_full_state64)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_full_state64>())).__ss64 as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_full_state64),
            "::",
            stringify!(__ss64)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_full_state64>())).__ds as *const _ as usize
        },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_full_state64),
            "::",
            stringify!(__ds)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_full_state64>())).__es as *const _ as usize
        },
        176usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_full_state64),
            "::",
            stringify!(__es)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_full_state64>())).__ss as *const _ as usize
        },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_full_state64),
            "::",
            stringify!(__ss)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_full_state64>())).__gsbase as *const _
                as usize
        },
        192usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_full_state64),
            "::",
            stringify!(__gsbase)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct __darwin_x86_float_state64 {
    pub __fpu_reserved: [::std::os::raw::c_int; 2usize],
    pub __fpu_fcw: __darwin_fp_control,
    pub __fpu_fsw: __darwin_fp_status,
    pub __fpu_ftw: __uint8_t,
    pub __fpu_rsrv1: __uint8_t,
    pub __fpu_fop: __uint16_t,
    pub __fpu_ip: __uint32_t,
    pub __fpu_cs: __uint16_t,
    pub __fpu_rsrv2: __uint16_t,
    pub __fpu_dp: __uint32_t,
    pub __fpu_ds: __uint16_t,
    pub __fpu_rsrv3: __uint16_t,
    pub __fpu_mxcsr: __uint32_t,
    pub __fpu_mxcsrmask: __uint32_t,
    pub __fpu_stmm0: __darwin_mmst_reg,
    pub __fpu_stmm1: __darwin_mmst_reg,
    pub __fpu_stmm2: __darwin_mmst_reg,
    pub __fpu_stmm3: __darwin_mmst_reg,
    pub __fpu_stmm4: __darwin_mmst_reg,
    pub __fpu_stmm5: __darwin_mmst_reg,
    pub __fpu_stmm6: __darwin_mmst_reg,
    pub __fpu_stmm7: __darwin_mmst_reg,
    pub __fpu_xmm0: __darwin_xmm_reg,
    pub __fpu_xmm1: __darwin_xmm_reg,
    pub __fpu_xmm2: __darwin_xmm_reg,
    pub __fpu_xmm3: __darwin_xmm_reg,
    pub __fpu_xmm4: __darwin_xmm_reg,
    pub __fpu_xmm5: __darwin_xmm_reg,
    pub __fpu_xmm6: __darwin_xmm_reg,
    pub __fpu_xmm7: __darwin_xmm_reg,
    pub __fpu_xmm8: __darwin_xmm_reg,
    pub __fpu_xmm9: __darwin_xmm_reg,
    pub __fpu_xmm10: __darwin_xmm_reg,
    pub __fpu_xmm11: __darwin_xmm_reg,
    pub __fpu_xmm12: __darwin_xmm_reg,
    pub __fpu_xmm13: __darwin_xmm_reg,
    pub __fpu_xmm14: __darwin_xmm_reg,
    pub __fpu_xmm15: __darwin_xmm_reg,
    pub __fpu_rsrv4: [::std::os::raw::c_char; 96usize],
    pub __fpu_reserved1: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout___darwin_x86_float_state64() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_x86_float_state64>(),
        524usize,
        concat!("Size of: ", stringify!(__darwin_x86_float_state64))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_x86_float_state64>(),
        4usize,
        concat!("Alignment of ", stringify!(__darwin_x86_float_state64))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_reserved as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_reserved)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_fcw as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_fcw)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_fsw as *const _ as usize
        },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_fsw)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_ftw as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_ftw)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_rsrv1 as *const _ as usize
        },
        13usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_rsrv1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_fop as *const _ as usize
        },
        14usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_fop)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_ip as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_ip)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_cs as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_cs)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_rsrv2 as *const _ as usize
        },
        22usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_rsrv2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_dp as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_dp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_ds as *const _ as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_ds)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_rsrv3 as *const _ as usize
        },
        30usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_rsrv3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_mxcsr as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_mxcsr)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_mxcsrmask as *const _
                as usize
        },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_mxcsrmask)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_stmm0 as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_stmm0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_stmm1 as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_stmm1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_stmm2 as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_stmm2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_stmm3 as *const _ as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_stmm3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_stmm4 as *const _ as usize
        },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_stmm4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_stmm5 as *const _ as usize
        },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_stmm5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_stmm6 as *const _ as usize
        },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_stmm6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_stmm7 as *const _ as usize
        },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_stmm7)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_xmm0 as *const _ as usize
        },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_xmm1 as *const _ as usize
        },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_xmm2 as *const _ as usize
        },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_xmm3 as *const _ as usize
        },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_xmm4 as *const _ as usize
        },
        232usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_xmm5 as *const _ as usize
        },
        248usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_xmm6 as *const _ as usize
        },
        264usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_xmm7 as *const _ as usize
        },
        280usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm7)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_xmm8 as *const _ as usize
        },
        296usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm8)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_xmm9 as *const _ as usize
        },
        312usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm9)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_xmm10 as *const _ as usize
        },
        328usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm10)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_xmm11 as *const _ as usize
        },
        344usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm11)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_xmm12 as *const _ as usize
        },
        360usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm12)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_xmm13 as *const _ as usize
        },
        376usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm13)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_xmm14 as *const _ as usize
        },
        392usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm14)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_xmm15 as *const _ as usize
        },
        408usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm15)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_rsrv4 as *const _ as usize
        },
        424usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_rsrv4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_reserved1 as *const _
                as usize
        },
        520usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_reserved1)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct __darwin_x86_avx_state64 {
    pub __fpu_reserved: [::std::os::raw::c_int; 2usize],
    pub __fpu_fcw: __darwin_fp_control,
    pub __fpu_fsw: __darwin_fp_status,
    pub __fpu_ftw: __uint8_t,
    pub __fpu_rsrv1: __uint8_t,
    pub __fpu_fop: __uint16_t,
    pub __fpu_ip: __uint32_t,
    pub __fpu_cs: __uint16_t,
    pub __fpu_rsrv2: __uint16_t,
    pub __fpu_dp: __uint32_t,
    pub __fpu_ds: __uint16_t,
    pub __fpu_rsrv3: __uint16_t,
    pub __fpu_mxcsr: __uint32_t,
    pub __fpu_mxcsrmask: __uint32_t,
    pub __fpu_stmm0: __darwin_mmst_reg,
    pub __fpu_stmm1: __darwin_mmst_reg,
    pub __fpu_stmm2: __darwin_mmst_reg,
    pub __fpu_stmm3: __darwin_mmst_reg,
    pub __fpu_stmm4: __darwin_mmst_reg,
    pub __fpu_stmm5: __darwin_mmst_reg,
    pub __fpu_stmm6: __darwin_mmst_reg,
    pub __fpu_stmm7: __darwin_mmst_reg,
    pub __fpu_xmm0: __darwin_xmm_reg,
    pub __fpu_xmm1: __darwin_xmm_reg,
    pub __fpu_xmm2: __darwin_xmm_reg,
    pub __fpu_xmm3: __darwin_xmm_reg,
    pub __fpu_xmm4: __darwin_xmm_reg,
    pub __fpu_xmm5: __darwin_xmm_reg,
    pub __fpu_xmm6: __darwin_xmm_reg,
    pub __fpu_xmm7: __darwin_xmm_reg,
    pub __fpu_xmm8: __darwin_xmm_reg,
    pub __fpu_xmm9: __darwin_xmm_reg,
    pub __fpu_xmm10: __darwin_xmm_reg,
    pub __fpu_xmm11: __darwin_xmm_reg,
    pub __fpu_xmm12: __darwin_xmm_reg,
    pub __fpu_xmm13: __darwin_xmm_reg,
    pub __fpu_xmm14: __darwin_xmm_reg,
    pub __fpu_xmm15: __darwin_xmm_reg,
    pub __fpu_rsrv4: [::std::os::raw::c_char; 96usize],
    pub __fpu_reserved1: ::std::os::raw::c_int,
    pub __avx_reserved1: [::std::os::raw::c_char; 64usize],
    pub __fpu_ymmh0: __darwin_xmm_reg,
    pub __fpu_ymmh1: __darwin_xmm_reg,
    pub __fpu_ymmh2: __darwin_xmm_reg,
    pub __fpu_ymmh3: __darwin_xmm_reg,
    pub __fpu_ymmh4: __darwin_xmm_reg,
    pub __fpu_ymmh5: __darwin_xmm_reg,
    pub __fpu_ymmh6: __darwin_xmm_reg,
    pub __fpu_ymmh7: __darwin_xmm_reg,
    pub __fpu_ymmh8: __darwin_xmm_reg,
    pub __fpu_ymmh9: __darwin_xmm_reg,
    pub __fpu_ymmh10: __darwin_xmm_reg,
    pub __fpu_ymmh11: __darwin_xmm_reg,
    pub __fpu_ymmh12: __darwin_xmm_reg,
    pub __fpu_ymmh13: __darwin_xmm_reg,
    pub __fpu_ymmh14: __darwin_xmm_reg,
    pub __fpu_ymmh15: __darwin_xmm_reg,
}
#[test]
fn bindgen_test_layout___darwin_x86_avx_state64() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_x86_avx_state64>(),
        844usize,
        concat!("Size of: ", stringify!(__darwin_x86_avx_state64))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_x86_avx_state64>(),
        4usize,
        concat!("Alignment of ", stringify!(__darwin_x86_avx_state64))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_reserved as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_reserved)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_fcw as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_fcw)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_fsw as *const _ as usize
        },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_fsw)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_ftw as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ftw)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_rsrv1 as *const _ as usize
        },
        13usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_rsrv1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_fop as *const _ as usize
        },
        14usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_fop)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_ip as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ip)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_cs as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_cs)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_rsrv2 as *const _ as usize
        },
        22usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_rsrv2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_dp as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_dp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_ds as *const _ as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ds)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_rsrv3 as *const _ as usize
        },
        30usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_rsrv3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_mxcsr as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_mxcsr)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_mxcsrmask as *const _
                as usize
        },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_mxcsrmask)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_stmm0 as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_stmm0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_stmm1 as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_stmm1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_stmm2 as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_stmm2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_stmm3 as *const _ as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_stmm3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_stmm4 as *const _ as usize
        },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_stmm4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_stmm5 as *const _ as usize
        },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_stmm5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_stmm6 as *const _ as usize
        },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_stmm6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_stmm7 as *const _ as usize
        },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_stmm7)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_xmm0 as *const _ as usize
        },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_xmm1 as *const _ as usize
        },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_xmm2 as *const _ as usize
        },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_xmm3 as *const _ as usize
        },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_xmm4 as *const _ as usize
        },
        232usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_xmm5 as *const _ as usize
        },
        248usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_xmm6 as *const _ as usize
        },
        264usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_xmm7 as *const _ as usize
        },
        280usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm7)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_xmm8 as *const _ as usize
        },
        296usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm8)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_xmm9 as *const _ as usize
        },
        312usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm9)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_xmm10 as *const _ as usize
        },
        328usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm10)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_xmm11 as *const _ as usize
        },
        344usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm11)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_xmm12 as *const _ as usize
        },
        360usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm12)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_xmm13 as *const _ as usize
        },
        376usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm13)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_xmm14 as *const _ as usize
        },
        392usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm14)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_xmm15 as *const _ as usize
        },
        408usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm15)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_rsrv4 as *const _ as usize
        },
        424usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_rsrv4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_reserved1 as *const _
                as usize
        },
        520usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_reserved1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__avx_reserved1 as *const _
                as usize
        },
        524usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__avx_reserved1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_ymmh0 as *const _ as usize
        },
        588usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_ymmh1 as *const _ as usize
        },
        604usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_ymmh2 as *const _ as usize
        },
        620usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_ymmh3 as *const _ as usize
        },
        636usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_ymmh4 as *const _ as usize
        },
        652usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_ymmh5 as *const _ as usize
        },
        668usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_ymmh6 as *const _ as usize
        },
        684usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_ymmh7 as *const _ as usize
        },
        700usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh7)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_ymmh8 as *const _ as usize
        },
        716usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh8)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_ymmh9 as *const _ as usize
        },
        732usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh9)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_ymmh10 as *const _ as usize
        },
        748usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh10)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_ymmh11 as *const _ as usize
        },
        764usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh11)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_ymmh12 as *const _ as usize
        },
        780usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh12)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_ymmh13 as *const _ as usize
        },
        796usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh13)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_ymmh14 as *const _ as usize
        },
        812usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh14)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_ymmh15 as *const _ as usize
        },
        828usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh15)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct __darwin_x86_avx512_state64 {
    pub __fpu_reserved: [::std::os::raw::c_int; 2usize],
    pub __fpu_fcw: __darwin_fp_control,
    pub __fpu_fsw: __darwin_fp_status,
    pub __fpu_ftw: __uint8_t,
    pub __fpu_rsrv1: __uint8_t,
    pub __fpu_fop: __uint16_t,
    pub __fpu_ip: __uint32_t,
    pub __fpu_cs: __uint16_t,
    pub __fpu_rsrv2: __uint16_t,
    pub __fpu_dp: __uint32_t,
    pub __fpu_ds: __uint16_t,
    pub __fpu_rsrv3: __uint16_t,
    pub __fpu_mxcsr: __uint32_t,
    pub __fpu_mxcsrmask: __uint32_t,
    pub __fpu_stmm0: __darwin_mmst_reg,
    pub __fpu_stmm1: __darwin_mmst_reg,
    pub __fpu_stmm2: __darwin_mmst_reg,
    pub __fpu_stmm3: __darwin_mmst_reg,
    pub __fpu_stmm4: __darwin_mmst_reg,
    pub __fpu_stmm5: __darwin_mmst_reg,
    pub __fpu_stmm6: __darwin_mmst_reg,
    pub __fpu_stmm7: __darwin_mmst_reg,
    pub __fpu_xmm0: __darwin_xmm_reg,
    pub __fpu_xmm1: __darwin_xmm_reg,
    pub __fpu_xmm2: __darwin_xmm_reg,
    pub __fpu_xmm3: __darwin_xmm_reg,
    pub __fpu_xmm4: __darwin_xmm_reg,
    pub __fpu_xmm5: __darwin_xmm_reg,
    pub __fpu_xmm6: __darwin_xmm_reg,
    pub __fpu_xmm7: __darwin_xmm_reg,
    pub __fpu_xmm8: __darwin_xmm_reg,
    pub __fpu_xmm9: __darwin_xmm_reg,
    pub __fpu_xmm10: __darwin_xmm_reg,
    pub __fpu_xmm11: __darwin_xmm_reg,
    pub __fpu_xmm12: __darwin_xmm_reg,
    pub __fpu_xmm13: __darwin_xmm_reg,
    pub __fpu_xmm14: __darwin_xmm_reg,
    pub __fpu_xmm15: __darwin_xmm_reg,
    pub __fpu_rsrv4: [::std::os::raw::c_char; 96usize],
    pub __fpu_reserved1: ::std::os::raw::c_int,
    pub __avx_reserved1: [::std::os::raw::c_char; 64usize],
    pub __fpu_ymmh0: __darwin_xmm_reg,
    pub __fpu_ymmh1: __darwin_xmm_reg,
    pub __fpu_ymmh2: __darwin_xmm_reg,
    pub __fpu_ymmh3: __darwin_xmm_reg,
    pub __fpu_ymmh4: __darwin_xmm_reg,
    pub __fpu_ymmh5: __darwin_xmm_reg,
    pub __fpu_ymmh6: __darwin_xmm_reg,
    pub __fpu_ymmh7: __darwin_xmm_reg,
    pub __fpu_ymmh8: __darwin_xmm_reg,
    pub __fpu_ymmh9: __darwin_xmm_reg,
    pub __fpu_ymmh10: __darwin_xmm_reg,
    pub __fpu_ymmh11: __darwin_xmm_reg,
    pub __fpu_ymmh12: __darwin_xmm_reg,
    pub __fpu_ymmh13: __darwin_xmm_reg,
    pub __fpu_ymmh14: __darwin_xmm_reg,
    pub __fpu_ymmh15: __darwin_xmm_reg,
    pub __fpu_k0: __darwin_opmask_reg,
    pub __fpu_k1: __darwin_opmask_reg,
    pub __fpu_k2: __darwin_opmask_reg,
    pub __fpu_k3: __darwin_opmask_reg,
    pub __fpu_k4: __darwin_opmask_reg,
    pub __fpu_k5: __darwin_opmask_reg,
    pub __fpu_k6: __darwin_opmask_reg,
    pub __fpu_k7: __darwin_opmask_reg,
    pub __fpu_zmmh0: __darwin_ymm_reg,
    pub __fpu_zmmh1: __darwin_ymm_reg,
    pub __fpu_zmmh2: __darwin_ymm_reg,
    pub __fpu_zmmh3: __darwin_ymm_reg,
    pub __fpu_zmmh4: __darwin_ymm_reg,
    pub __fpu_zmmh5: __darwin_ymm_reg,
    pub __fpu_zmmh6: __darwin_ymm_reg,
    pub __fpu_zmmh7: __darwin_ymm_reg,
    pub __fpu_zmmh8: __darwin_ymm_reg,
    pub __fpu_zmmh9: __darwin_ymm_reg,
    pub __fpu_zmmh10: __darwin_ymm_reg,
    pub __fpu_zmmh11: __darwin_ymm_reg,
    pub __fpu_zmmh12: __darwin_ymm_reg,
    pub __fpu_zmmh13: __darwin_ymm_reg,
    pub __fpu_zmmh14: __darwin_ymm_reg,
    pub __fpu_zmmh15: __darwin_ymm_reg,
    pub __fpu_zmm16: __darwin_zmm_reg,
    pub __fpu_zmm17: __darwin_zmm_reg,
    pub __fpu_zmm18: __darwin_zmm_reg,
    pub __fpu_zmm19: __darwin_zmm_reg,
    pub __fpu_zmm20: __darwin_zmm_reg,
    pub __fpu_zmm21: __darwin_zmm_reg,
    pub __fpu_zmm22: __darwin_zmm_reg,
    pub __fpu_zmm23: __darwin_zmm_reg,
    pub __fpu_zmm24: __darwin_zmm_reg,
    pub __fpu_zmm25: __darwin_zmm_reg,
    pub __fpu_zmm26: __darwin_zmm_reg,
    pub __fpu_zmm27: __darwin_zmm_reg,
    pub __fpu_zmm28: __darwin_zmm_reg,
    pub __fpu_zmm29: __darwin_zmm_reg,
    pub __fpu_zmm30: __darwin_zmm_reg,
    pub __fpu_zmm31: __darwin_zmm_reg,
}
#[test]
fn bindgen_test_layout___darwin_x86_avx512_state64() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_x86_avx512_state64>(),
        2444usize,
        concat!("Size of: ", stringify!(__darwin_x86_avx512_state64))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_x86_avx512_state64>(),
        4usize,
        concat!("Alignment of ", stringify!(__darwin_x86_avx512_state64))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_reserved as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_reserved)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_fcw as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_fcw)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_fsw as *const _ as usize
        },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_fsw)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_ftw as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ftw)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_rsrv1 as *const _ as usize
        },
        13usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_rsrv1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_fop as *const _ as usize
        },
        14usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_fop)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_ip as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ip)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_cs as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_cs)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_rsrv2 as *const _ as usize
        },
        22usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_rsrv2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_dp as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_dp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_ds as *const _ as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ds)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_rsrv3 as *const _ as usize
        },
        30usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_rsrv3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_mxcsr as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_mxcsr)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_mxcsrmask as *const _
                as usize
        },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_mxcsrmask)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_stmm0 as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_stmm0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_stmm1 as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_stmm1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_stmm2 as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_stmm2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_stmm3 as *const _ as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_stmm3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_stmm4 as *const _ as usize
        },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_stmm4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_stmm5 as *const _ as usize
        },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_stmm5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_stmm6 as *const _ as usize
        },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_stmm6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_stmm7 as *const _ as usize
        },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_stmm7)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_xmm0 as *const _ as usize
        },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_xmm1 as *const _ as usize
        },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_xmm2 as *const _ as usize
        },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_xmm3 as *const _ as usize
        },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_xmm4 as *const _ as usize
        },
        232usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_xmm5 as *const _ as usize
        },
        248usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_xmm6 as *const _ as usize
        },
        264usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_xmm7 as *const _ as usize
        },
        280usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm7)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_xmm8 as *const _ as usize
        },
        296usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm8)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_xmm9 as *const _ as usize
        },
        312usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm9)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_xmm10 as *const _ as usize
        },
        328usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm10)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_xmm11 as *const _ as usize
        },
        344usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm11)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_xmm12 as *const _ as usize
        },
        360usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm12)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_xmm13 as *const _ as usize
        },
        376usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm13)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_xmm14 as *const _ as usize
        },
        392usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm14)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_xmm15 as *const _ as usize
        },
        408usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm15)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_rsrv4 as *const _ as usize
        },
        424usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_rsrv4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_reserved1 as *const _
                as usize
        },
        520usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_reserved1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__avx_reserved1 as *const _
                as usize
        },
        524usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__avx_reserved1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_ymmh0 as *const _ as usize
        },
        588usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_ymmh1 as *const _ as usize
        },
        604usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_ymmh2 as *const _ as usize
        },
        620usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_ymmh3 as *const _ as usize
        },
        636usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_ymmh4 as *const _ as usize
        },
        652usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_ymmh5 as *const _ as usize
        },
        668usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_ymmh6 as *const _ as usize
        },
        684usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_ymmh7 as *const _ as usize
        },
        700usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh7)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_ymmh8 as *const _ as usize
        },
        716usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh8)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_ymmh9 as *const _ as usize
        },
        732usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh9)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_ymmh10 as *const _
                as usize
        },
        748usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh10)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_ymmh11 as *const _
                as usize
        },
        764usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh11)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_ymmh12 as *const _
                as usize
        },
        780usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh12)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_ymmh13 as *const _
                as usize
        },
        796usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh13)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_ymmh14 as *const _
                as usize
        },
        812usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh14)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_ymmh15 as *const _
                as usize
        },
        828usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh15)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_k0 as *const _ as usize
        },
        844usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_k0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_k1 as *const _ as usize
        },
        852usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_k1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_k2 as *const _ as usize
        },
        860usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_k2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_k3 as *const _ as usize
        },
        868usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_k3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_k4 as *const _ as usize
        },
        876usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_k4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_k5 as *const _ as usize
        },
        884usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_k5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_k6 as *const _ as usize
        },
        892usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_k6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_k7 as *const _ as usize
        },
        900usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_k7)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmmh0 as *const _ as usize
        },
        908usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmmh1 as *const _ as usize
        },
        940usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmmh2 as *const _ as usize
        },
        972usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmmh3 as *const _ as usize
        },
        1004usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmmh4 as *const _ as usize
        },
        1036usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmmh5 as *const _ as usize
        },
        1068usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmmh6 as *const _ as usize
        },
        1100usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmmh7 as *const _ as usize
        },
        1132usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh7)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmmh8 as *const _ as usize
        },
        1164usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh8)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmmh9 as *const _ as usize
        },
        1196usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh9)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmmh10 as *const _
                as usize
        },
        1228usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh10)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmmh11 as *const _
                as usize
        },
        1260usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh11)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmmh12 as *const _
                as usize
        },
        1292usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh12)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmmh13 as *const _
                as usize
        },
        1324usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh13)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmmh14 as *const _
                as usize
        },
        1356usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh14)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmmh15 as *const _
                as usize
        },
        1388usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh15)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmm16 as *const _ as usize
        },
        1420usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm16)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmm17 as *const _ as usize
        },
        1484usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm17)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmm18 as *const _ as usize
        },
        1548usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm18)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmm19 as *const _ as usize
        },
        1612usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm19)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmm20 as *const _ as usize
        },
        1676usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm20)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmm21 as *const _ as usize
        },
        1740usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm21)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmm22 as *const _ as usize
        },
        1804usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm22)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmm23 as *const _ as usize
        },
        1868usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm23)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmm24 as *const _ as usize
        },
        1932usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm24)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmm25 as *const _ as usize
        },
        1996usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm25)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmm26 as *const _ as usize
        },
        2060usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm26)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmm27 as *const _ as usize
        },
        2124usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm27)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmm28 as *const _ as usize
        },
        2188usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm28)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmm29 as *const _ as usize
        },
        2252usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm29)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmm30 as *const _ as usize
        },
        2316usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm30)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmm31 as *const _ as usize
        },
        2380usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm31)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_x86_exception_state64 {
    pub __trapno: __uint16_t,
    pub __cpu: __uint16_t,
    pub __err: __uint32_t,
    pub __faultvaddr: __uint64_t,
}
#[test]
fn bindgen_test_layout___darwin_x86_exception_state64() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_x86_exception_state64>(),
        16usize,
        concat!("Size of: ", stringify!(__darwin_x86_exception_state64))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_x86_exception_state64>(),
        8usize,
        concat!("Alignment of ", stringify!(__darwin_x86_exception_state64))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_exception_state64>())).__trapno as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_exception_state64),
            "::",
            stringify!(__trapno)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_exception_state64>())).__cpu as *const _ as usize
        },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_exception_state64),
            "::",
            stringify!(__cpu)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_exception_state64>())).__err as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_exception_state64),
            "::",
            stringify!(__err)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_exception_state64>())).__faultvaddr as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_exception_state64),
            "::",
            stringify!(__faultvaddr)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_x86_debug_state64 {
    pub __dr0: __uint64_t,
    pub __dr1: __uint64_t,
    pub __dr2: __uint64_t,
    pub __dr3: __uint64_t,
    pub __dr4: __uint64_t,
    pub __dr5: __uint64_t,
    pub __dr6: __uint64_t,
    pub __dr7: __uint64_t,
}
#[test]
fn bindgen_test_layout___darwin_x86_debug_state64() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_x86_debug_state64>(),
        64usize,
        concat!("Size of: ", stringify!(__darwin_x86_debug_state64))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_x86_debug_state64>(),
        8usize,
        concat!("Alignment of ", stringify!(__darwin_x86_debug_state64))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_debug_state64>())).__dr0 as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state64),
            "::",
            stringify!(__dr0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_debug_state64>())).__dr1 as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state64),
            "::",
            stringify!(__dr1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_debug_state64>())).__dr2 as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state64),
            "::",
            stringify!(__dr2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_debug_state64>())).__dr3 as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state64),
            "::",
            stringify!(__dr3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_debug_state64>())).__dr4 as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state64),
            "::",
            stringify!(__dr4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_debug_state64>())).__dr5 as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state64),
            "::",
            stringify!(__dr5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_debug_state64>())).__dr6 as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state64),
            "::",
            stringify!(__dr6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_debug_state64>())).__dr7 as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state64),
            "::",
            stringify!(__dr7)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_x86_cpmu_state64 {
    pub __ctrs: [__uint64_t; 16usize],
}
#[test]
fn bindgen_test_layout___darwin_x86_cpmu_state64() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_x86_cpmu_state64>(),
        128usize,
        concat!("Size of: ", stringify!(__darwin_x86_cpmu_state64))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_x86_cpmu_state64>(),
        8usize,
        concat!("Alignment of ", stringify!(__darwin_x86_cpmu_state64))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_cpmu_state64>())).__ctrs as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_cpmu_state64),
            "::",
            stringify!(__ctrs)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct __darwin_mcontext32 {
    pub __es: __darwin_i386_exception_state,
    pub __ss: __darwin_i386_thread_state,
    pub __fs: __darwin_i386_float_state,
}
#[test]
fn bindgen_test_layout___darwin_mcontext32() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_mcontext32>(),
        600usize,
        concat!("Size of: ", stringify!(__darwin_mcontext32))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_mcontext32>(),
        4usize,
        concat!("Alignment of ", stringify!(__darwin_mcontext32))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_mcontext32>())).__es as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext32),
            "::",
            stringify!(__es)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_mcontext32>())).__ss as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext32),
            "::",
            stringify!(__ss)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_mcontext32>())).__fs as *const _ as usize },
        76usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext32),
            "::",
            stringify!(__fs)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct __darwin_mcontext_avx32 {
    pub __es: __darwin_i386_exception_state,
    pub __ss: __darwin_i386_thread_state,
    pub __fs: __darwin_i386_avx_state,
}
#[test]
fn bindgen_test_layout___darwin_mcontext_avx32() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_mcontext_avx32>(),
        792usize,
        concat!("Size of: ", stringify!(__darwin_mcontext_avx32))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_mcontext_avx32>(),
        4usize,
        concat!("Alignment of ", stringify!(__darwin_mcontext_avx32))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_mcontext_avx32>())).__es as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx32),
            "::",
            stringify!(__es)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_mcontext_avx32>())).__ss as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx32),
            "::",
            stringify!(__ss)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_mcontext_avx32>())).__fs as *const _ as usize },
        76usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx32),
            "::",
            stringify!(__fs)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct __darwin_mcontext_avx512_32 {
    pub __es: __darwin_i386_exception_state,
    pub __ss: __darwin_i386_thread_state,
    pub __fs: __darwin_i386_avx512_state,
}
#[test]
fn bindgen_test_layout___darwin_mcontext_avx512_32() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_mcontext_avx512_32>(),
        1112usize,
        concat!("Size of: ", stringify!(__darwin_mcontext_avx512_32))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_mcontext_avx512_32>(),
        4usize,
        concat!("Alignment of ", stringify!(__darwin_mcontext_avx512_32))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_mcontext_avx512_32>())).__es as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx512_32),
            "::",
            stringify!(__es)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_mcontext_avx512_32>())).__ss as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx512_32),
            "::",
            stringify!(__ss)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_mcontext_avx512_32>())).__fs as *const _ as usize
        },
        76usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx512_32),
            "::",
            stringify!(__fs)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct __darwin_mcontext64 {
    pub __es: __darwin_x86_exception_state64,
    pub __ss: __darwin_x86_thread_state64,
    pub __fs: __darwin_x86_float_state64,
}
#[test]
fn bindgen_test_layout___darwin_mcontext64() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_mcontext64>(),
        712usize,
        concat!("Size of: ", stringify!(__darwin_mcontext64))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_mcontext64>(),
        8usize,
        concat!("Alignment of ", stringify!(__darwin_mcontext64))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_mcontext64>())).__es as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext64),
            "::",
            stringify!(__es)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_mcontext64>())).__ss as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext64),
            "::",
            stringify!(__ss)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_mcontext64>())).__fs as *const _ as usize },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext64),
            "::",
            stringify!(__fs)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct __darwin_mcontext64_full {
    pub __es: __darwin_x86_exception_state64,
    pub __ss: __darwin_x86_thread_full_state64,
    pub __fs: __darwin_x86_float_state64,
}
#[test]
fn bindgen_test_layout___darwin_mcontext64_full() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_mcontext64_full>(),
        744usize,
        concat!("Size of: ", stringify!(__darwin_mcontext64_full))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_mcontext64_full>(),
        8usize,
        concat!("Alignment of ", stringify!(__darwin_mcontext64_full))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_mcontext64_full>())).__es as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext64_full),
            "::",
            stringify!(__es)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_mcontext64_full>())).__ss as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext64_full),
            "::",
            stringify!(__ss)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_mcontext64_full>())).__fs as *const _ as usize },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext64_full),
            "::",
            stringify!(__fs)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct __darwin_mcontext_avx64 {
    pub __es: __darwin_x86_exception_state64,
    pub __ss: __darwin_x86_thread_state64,
    pub __fs: __darwin_x86_avx_state64,
}
#[test]
fn bindgen_test_layout___darwin_mcontext_avx64() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_mcontext_avx64>(),
        1032usize,
        concat!("Size of: ", stringify!(__darwin_mcontext_avx64))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_mcontext_avx64>(),
        8usize,
        concat!("Alignment of ", stringify!(__darwin_mcontext_avx64))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_mcontext_avx64>())).__es as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx64),
            "::",
            stringify!(__es)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_mcontext_avx64>())).__ss as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx64),
            "::",
            stringify!(__ss)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_mcontext_avx64>())).__fs as *const _ as usize },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx64),
            "::",
            stringify!(__fs)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct __darwin_mcontext_avx64_full {
    pub __es: __darwin_x86_exception_state64,
    pub __ss: __darwin_x86_thread_full_state64,
    pub __fs: __darwin_x86_avx_state64,
}
#[test]
fn bindgen_test_layout___darwin_mcontext_avx64_full() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_mcontext_avx64_full>(),
        1064usize,
        concat!("Size of: ", stringify!(__darwin_mcontext_avx64_full))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_mcontext_avx64_full>(),
        8usize,
        concat!("Alignment of ", stringify!(__darwin_mcontext_avx64_full))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_mcontext_avx64_full>())).__es as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx64_full),
            "::",
            stringify!(__es)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_mcontext_avx64_full>())).__ss as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx64_full),
            "::",
            stringify!(__ss)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_mcontext_avx64_full>())).__fs as *const _ as usize
        },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx64_full),
            "::",
            stringify!(__fs)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct __darwin_mcontext_avx512_64 {
    pub __es: __darwin_x86_exception_state64,
    pub __ss: __darwin_x86_thread_state64,
    pub __fs: __darwin_x86_avx512_state64,
}
#[test]
fn bindgen_test_layout___darwin_mcontext_avx512_64() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_mcontext_avx512_64>(),
        2632usize,
        concat!("Size of: ", stringify!(__darwin_mcontext_avx512_64))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_mcontext_avx512_64>(),
        8usize,
        concat!("Alignment of ", stringify!(__darwin_mcontext_avx512_64))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_mcontext_avx512_64>())).__es as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx512_64),
            "::",
            stringify!(__es)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_mcontext_avx512_64>())).__ss as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx512_64),
            "::",
            stringify!(__ss)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_mcontext_avx512_64>())).__fs as *const _ as usize
        },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx512_64),
            "::",
            stringify!(__fs)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct __darwin_mcontext_avx512_64_full {
    pub __es: __darwin_x86_exception_state64,
    pub __ss: __darwin_x86_thread_full_state64,
    pub __fs: __darwin_x86_avx512_state64,
}
#[test]
fn bindgen_test_layout___darwin_mcontext_avx512_64_full() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_mcontext_avx512_64_full>(),
        2664usize,
        concat!("Size of: ", stringify!(__darwin_mcontext_avx512_64_full))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_mcontext_avx512_64_full>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__darwin_mcontext_avx512_64_full)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_mcontext_avx512_64_full>())).__es as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx512_64_full),
            "::",
            stringify!(__es)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_mcontext_avx512_64_full>())).__ss as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx512_64_full),
            "::",
            stringify!(__ss)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_mcontext_avx512_64_full>())).__fs as *const _ as usize
        },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx512_64_full),
            "::",
            stringify!(__fs)
        )
    );
}
pub type mcontext_t = *mut __darwin_mcontext64;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_sigaltstack {
    pub ss_sp: *mut ::std::os::raw::c_void,
    pub ss_size: __darwin_size_t,
    pub ss_flags: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout___darwin_sigaltstack() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_sigaltstack>(),
        24usize,
        concat!("Size of: ", stringify!(__darwin_sigaltstack))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_sigaltstack>(),
        8usize,
        concat!("Alignment of ", stringify!(__darwin_sigaltstack))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_sigaltstack>())).ss_sp as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_sigaltstack),
            "::",
            stringify!(ss_sp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_sigaltstack>())).ss_size as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_sigaltstack),
            "::",
            stringify!(ss_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_sigaltstack>())).ss_flags as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_sigaltstack),
            "::",
            stringify!(ss_flags)
        )
    );
}
pub type stack_t = __darwin_sigaltstack;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_ucontext {
    pub uc_onstack: ::std::os::raw::c_int,
    pub uc_sigmask: __darwin_sigset_t,
    pub uc_stack: __darwin_sigaltstack,
    pub uc_link: *mut __darwin_ucontext,
    pub uc_mcsize: __darwin_size_t,
    pub uc_mcontext: *mut __darwin_mcontext64,
}
#[test]
fn bindgen_test_layout___darwin_ucontext() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_ucontext>(),
        56usize,
        concat!("Size of: ", stringify!(__darwin_ucontext))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_ucontext>(),
        8usize,
        concat!("Alignment of ", stringify!(__darwin_ucontext))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_ucontext>())).uc_onstack as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_ucontext),
            "::",
            stringify!(uc_onstack)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_ucontext>())).uc_sigmask as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_ucontext),
            "::",
            stringify!(uc_sigmask)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_ucontext>())).uc_stack as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_ucontext),
            "::",
            stringify!(uc_stack)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_ucontext>())).uc_link as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_ucontext),
            "::",
            stringify!(uc_link)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_ucontext>())).uc_mcsize as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_ucontext),
            "::",
            stringify!(uc_mcsize)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_ucontext>())).uc_mcontext as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_ucontext),
            "::",
            stringify!(uc_mcontext)
        )
    );
}
pub type ucontext_t = __darwin_ucontext;
pub type sigset_t = __darwin_sigset_t;
#[repr(C)]
#[derive(Copy, Clone)]
pub union sigval {
    pub sival_int: ::std::os::raw::c_int,
    pub sival_ptr: *mut ::std::os::raw::c_void,
    _bindgen_union_align: u64,
}
#[test]
fn bindgen_test_layout_sigval() {
    assert_eq!(
        ::std::mem::size_of::<sigval>(),
        8usize,
        concat!("Size of: ", stringify!(sigval))
    );
    assert_eq!(
        ::std::mem::align_of::<sigval>(),
        8usize,
        concat!("Alignment of ", stringify!(sigval))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigval>())).sival_int as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sigval),
            "::",
            stringify!(sival_int)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigval>())).sival_ptr as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sigval),
            "::",
            stringify!(sival_ptr)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct sigevent {
    pub sigev_notify: ::std::os::raw::c_int,
    pub sigev_signo: ::std::os::raw::c_int,
    pub sigev_value: sigval,
    pub sigev_notify_function: ::std::option::Option<unsafe extern "C" fn(arg1: sigval)>,
    pub sigev_notify_attributes: *mut pthread_attr_t,
}
#[test]
fn bindgen_test_layout_sigevent() {
    assert_eq!(
        ::std::mem::size_of::<sigevent>(),
        32usize,
        concat!("Size of: ", stringify!(sigevent))
    );
    assert_eq!(
        ::std::mem::align_of::<sigevent>(),
        8usize,
        concat!("Alignment of ", stringify!(sigevent))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigevent>())).sigev_notify as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sigevent),
            "::",
            stringify!(sigev_notify)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigevent>())).sigev_signo as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(sigevent),
            "::",
            stringify!(sigev_signo)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigevent>())).sigev_value as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(sigevent),
            "::",
            stringify!(sigev_value)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigevent>())).sigev_notify_function as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(sigevent),
            "::",
            stringify!(sigev_notify_function)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<sigevent>())).sigev_notify_attributes as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(sigevent),
            "::",
            stringify!(sigev_notify_attributes)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct __siginfo {
    pub si_signo: ::std::os::raw::c_int,
    pub si_errno: ::std::os::raw::c_int,
    pub si_code: ::std::os::raw::c_int,
    pub si_pid: pid_t,
    pub si_uid: uid_t,
    pub si_status: ::std::os::raw::c_int,
    pub si_addr: *mut ::std::os::raw::c_void,
    pub si_value: sigval,
    pub si_band: ::std::os::raw::c_long,
    pub __pad: [::std::os::raw::c_ulong; 7usize],
}
#[test]
fn bindgen_test_layout___siginfo() {
    assert_eq!(
        ::std::mem::size_of::<__siginfo>(),
        104usize,
        concat!("Size of: ", stringify!(__siginfo))
    );
    assert_eq!(
        ::std::mem::align_of::<__siginfo>(),
        8usize,
        concat!("Alignment of ", stringify!(__siginfo))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__siginfo>())).si_signo as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__siginfo),
            "::",
            stringify!(si_signo)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__siginfo>())).si_errno as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__siginfo),
            "::",
            stringify!(si_errno)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__siginfo>())).si_code as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__siginfo),
            "::",
            stringify!(si_code)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__siginfo>())).si_pid as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__siginfo),
            "::",
            stringify!(si_pid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__siginfo>())).si_uid as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__siginfo),
            "::",
            stringify!(si_uid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__siginfo>())).si_status as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(__siginfo),
            "::",
            stringify!(si_status)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__siginfo>())).si_addr as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__siginfo),
            "::",
            stringify!(si_addr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__siginfo>())).si_value as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__siginfo),
            "::",
            stringify!(si_value)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__siginfo>())).si_band as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__siginfo),
            "::",
            stringify!(si_band)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__siginfo>())).__pad as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(__siginfo),
            "::",
            stringify!(__pad)
        )
    );
}
pub type siginfo_t = __siginfo;
#[repr(C)]
#[derive(Copy, Clone)]
pub union __sigaction_u {
    pub __sa_handler: ::std::option::Option<unsafe extern "C" fn(arg1: ::std::os::raw::c_int)>,
    pub __sa_sigaction: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: ::std::os::raw::c_int,
            arg2: *mut __siginfo,
            arg3: *mut ::std::os::raw::c_void,
        ),
    >,
    _bindgen_union_align: u64,
}
#[test]
fn bindgen_test_layout___sigaction_u() {
    assert_eq!(
        ::std::mem::size_of::<__sigaction_u>(),
        8usize,
        concat!("Size of: ", stringify!(__sigaction_u))
    );
    assert_eq!(
        ::std::mem::align_of::<__sigaction_u>(),
        8usize,
        concat!("Alignment of ", stringify!(__sigaction_u))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sigaction_u>())).__sa_handler as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__sigaction_u),
            "::",
            stringify!(__sa_handler)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sigaction_u>())).__sa_sigaction as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__sigaction_u),
            "::",
            stringify!(__sa_sigaction)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct __sigaction {
    pub __sigaction_u: __sigaction_u,
    pub sa_tramp: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut ::std::os::raw::c_void,
            arg2: ::std::os::raw::c_int,
            arg3: ::std::os::raw::c_int,
            arg4: *mut siginfo_t,
            arg5: *mut ::std::os::raw::c_void,
        ),
    >,
    pub sa_mask: sigset_t,
    pub sa_flags: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout___sigaction() {
    assert_eq!(
        ::std::mem::size_of::<__sigaction>(),
        24usize,
        concat!("Size of: ", stringify!(__sigaction))
    );
    assert_eq!(
        ::std::mem::align_of::<__sigaction>(),
        8usize,
        concat!("Alignment of ", stringify!(__sigaction))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sigaction>())).__sigaction_u as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__sigaction),
            "::",
            stringify!(__sigaction_u)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sigaction>())).sa_tramp as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__sigaction),
            "::",
            stringify!(sa_tramp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sigaction>())).sa_mask as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__sigaction),
            "::",
            stringify!(sa_mask)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sigaction>())).sa_flags as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(__sigaction),
            "::",
            stringify!(sa_flags)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct sigaction {
    pub __sigaction_u: __sigaction_u,
    pub sa_mask: sigset_t,
    pub sa_flags: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_sigaction() {
    assert_eq!(
        ::std::mem::size_of::<sigaction>(),
        16usize,
        concat!("Size of: ", stringify!(sigaction))
    );
    assert_eq!(
        ::std::mem::align_of::<sigaction>(),
        8usize,
        concat!("Alignment of ", stringify!(sigaction))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigaction>())).__sigaction_u as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sigaction),
            "::",
            stringify!(__sigaction_u)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigaction>())).sa_mask as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(sigaction),
            "::",
            stringify!(sa_mask)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigaction>())).sa_flags as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(sigaction),
            "::",
            stringify!(sa_flags)
        )
    );
}
pub type sig_t = ::std::option::Option<unsafe extern "C" fn(arg1: ::std::os::raw::c_int)>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct sigvec {
    pub sv_handler: ::std::option::Option<unsafe extern "C" fn(arg1: ::std::os::raw::c_int)>,
    pub sv_mask: ::std::os::raw::c_int,
    pub sv_flags: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_sigvec() {
    assert_eq!(
        ::std::mem::size_of::<sigvec>(),
        16usize,
        concat!("Size of: ", stringify!(sigvec))
    );
    assert_eq!(
        ::std::mem::align_of::<sigvec>(),
        8usize,
        concat!("Alignment of ", stringify!(sigvec))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigvec>())).sv_handler as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sigvec),
            "::",
            stringify!(sv_handler)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigvec>())).sv_mask as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(sigvec),
            "::",
            stringify!(sv_mask)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigvec>())).sv_flags as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(sigvec),
            "::",
            stringify!(sv_flags)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct sigstack {
    pub ss_sp: *mut ::std::os::raw::c_char,
    pub ss_onstack: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_sigstack() {
    assert_eq!(
        ::std::mem::size_of::<sigstack>(),
        16usize,
        concat!("Size of: ", stringify!(sigstack))
    );
    assert_eq!(
        ::std::mem::align_of::<sigstack>(),
        8usize,
        concat!("Alignment of ", stringify!(sigstack))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigstack>())).ss_sp as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sigstack),
            "::",
            stringify!(ss_sp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigstack>())).ss_onstack as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(sigstack),
            "::",
            stringify!(ss_onstack)
        )
    );
}
extern "C" {
    pub fn signal(
        arg1: ::std::os::raw::c_int,
        arg2: ::std::option::Option<unsafe extern "C" fn(arg1: ::std::os::raw::c_int)>,
    ) -> ::std::option::Option<
        unsafe extern "C" fn(
            arg1: ::std::os::raw::c_int,
            arg2: ::std::option::Option<unsafe extern "C" fn(arg1: ::std::os::raw::c_int)>,
        ),
    >;
}
pub type au_id_t = uid_t;
pub type au_asid_t = pid_t;
pub type au_event_t = u_int16_t;
pub type au_emod_t = u_int16_t;
pub type au_class_t = u_int32_t;
pub type au_asflgs_t = u_int64_t;
pub type au_ctlmode_t = ::std::os::raw::c_uchar;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct au_tid {
    pub port: dev_t,
    pub machine: u_int32_t,
}
#[test]
fn bindgen_test_layout_au_tid() {
    assert_eq!(
        ::std::mem::size_of::<au_tid>(),
        8usize,
        concat!("Size of: ", stringify!(au_tid))
    );
    assert_eq!(
        ::std::mem::align_of::<au_tid>(),
        4usize,
        concat!("Alignment of ", stringify!(au_tid))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<au_tid>())).port as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(au_tid),
            "::",
            stringify!(port)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<au_tid>())).machine as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(au_tid),
            "::",
            stringify!(machine)
        )
    );
}
pub type au_tid_t = au_tid;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct au_tid_addr {
    pub at_port: dev_t,
    pub at_type: u_int32_t,
    pub at_addr: [u_int32_t; 4usize],
}
#[test]
fn bindgen_test_layout_au_tid_addr() {
    assert_eq!(
        ::std::mem::size_of::<au_tid_addr>(),
        24usize,
        concat!("Size of: ", stringify!(au_tid_addr))
    );
    assert_eq!(
        ::std::mem::align_of::<au_tid_addr>(),
        4usize,
        concat!("Alignment of ", stringify!(au_tid_addr))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<au_tid_addr>())).at_port as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(au_tid_addr),
            "::",
            stringify!(at_port)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<au_tid_addr>())).at_type as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(au_tid_addr),
            "::",
            stringify!(at_type)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<au_tid_addr>())).at_addr as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(au_tid_addr),
            "::",
            stringify!(at_addr)
        )
    );
}
pub type au_tid_addr_t = au_tid_addr;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct au_mask {
    pub am_success: ::std::os::raw::c_uint,
    pub am_failure: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout_au_mask() {
    assert_eq!(
        ::std::mem::size_of::<au_mask>(),
        8usize,
        concat!("Size of: ", stringify!(au_mask))
    );
    assert_eq!(
        ::std::mem::align_of::<au_mask>(),
        4usize,
        concat!("Alignment of ", stringify!(au_mask))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<au_mask>())).am_success as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(au_mask),
            "::",
            stringify!(am_success)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<au_mask>())).am_failure as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(au_mask),
            "::",
            stringify!(am_failure)
        )
    );
}
pub type au_mask_t = au_mask;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct auditinfo {
    pub ai_auid: au_id_t,
    pub ai_mask: au_mask_t,
    pub ai_termid: au_tid_t,
    pub ai_asid: au_asid_t,
}
#[test]
fn bindgen_test_layout_auditinfo() {
    assert_eq!(
        ::std::mem::size_of::<auditinfo>(),
        24usize,
        concat!("Size of: ", stringify!(auditinfo))
    );
    assert_eq!(
        ::std::mem::align_of::<auditinfo>(),
        4usize,
        concat!("Alignment of ", stringify!(auditinfo))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<auditinfo>())).ai_auid as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(auditinfo),
            "::",
            stringify!(ai_auid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<auditinfo>())).ai_mask as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(auditinfo),
            "::",
            stringify!(ai_mask)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<auditinfo>())).ai_termid as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(auditinfo),
            "::",
            stringify!(ai_termid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<auditinfo>())).ai_asid as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(auditinfo),
            "::",
            stringify!(ai_asid)
        )
    );
}
pub type auditinfo_t = auditinfo;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct auditinfo_addr {
    pub ai_auid: au_id_t,
    pub ai_mask: au_mask_t,
    pub ai_termid: au_tid_addr_t,
    pub ai_asid: au_asid_t,
    pub ai_flags: au_asflgs_t,
}
#[test]
fn bindgen_test_layout_auditinfo_addr() {
    assert_eq!(
        ::std::mem::size_of::<auditinfo_addr>(),
        48usize,
        concat!("Size of: ", stringify!(auditinfo_addr))
    );
    assert_eq!(
        ::std::mem::align_of::<auditinfo_addr>(),
        8usize,
        concat!("Alignment of ", stringify!(auditinfo_addr))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<auditinfo_addr>())).ai_auid as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(auditinfo_addr),
            "::",
            stringify!(ai_auid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<auditinfo_addr>())).ai_mask as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(auditinfo_addr),
            "::",
            stringify!(ai_mask)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<auditinfo_addr>())).ai_termid as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(auditinfo_addr),
            "::",
            stringify!(ai_termid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<auditinfo_addr>())).ai_asid as *const _ as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(auditinfo_addr),
            "::",
            stringify!(ai_asid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<auditinfo_addr>())).ai_flags as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(auditinfo_addr),
            "::",
            stringify!(ai_flags)
        )
    );
}
pub type auditinfo_addr_t = auditinfo_addr;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct auditpinfo {
    pub ap_pid: pid_t,
    pub ap_auid: au_id_t,
    pub ap_mask: au_mask_t,
    pub ap_termid: au_tid_t,
    pub ap_asid: au_asid_t,
}
#[test]
fn bindgen_test_layout_auditpinfo() {
    assert_eq!(
        ::std::mem::size_of::<auditpinfo>(),
        28usize,
        concat!("Size of: ", stringify!(auditpinfo))
    );
    assert_eq!(
        ::std::mem::align_of::<auditpinfo>(),
        4usize,
        concat!("Alignment of ", stringify!(auditpinfo))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<auditpinfo>())).ap_pid as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(auditpinfo),
            "::",
            stringify!(ap_pid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<auditpinfo>())).ap_auid as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(auditpinfo),
            "::",
            stringify!(ap_auid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<auditpinfo>())).ap_mask as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(auditpinfo),
            "::",
            stringify!(ap_mask)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<auditpinfo>())).ap_termid as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(auditpinfo),
            "::",
            stringify!(ap_termid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<auditpinfo>())).ap_asid as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(auditpinfo),
            "::",
            stringify!(ap_asid)
        )
    );
}
pub type auditpinfo_t = auditpinfo;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct auditpinfo_addr {
    pub ap_pid: pid_t,
    pub ap_auid: au_id_t,
    pub ap_mask: au_mask_t,
    pub ap_termid: au_tid_addr_t,
    pub ap_asid: au_asid_t,
    pub ap_flags: au_asflgs_t,
}
#[test]
fn bindgen_test_layout_auditpinfo_addr() {
    assert_eq!(
        ::std::mem::size_of::<auditpinfo_addr>(),
        56usize,
        concat!("Size of: ", stringify!(auditpinfo_addr))
    );
    assert_eq!(
        ::std::mem::align_of::<auditpinfo_addr>(),
        8usize,
        concat!("Alignment of ", stringify!(auditpinfo_addr))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<auditpinfo_addr>())).ap_pid as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(auditpinfo_addr),
            "::",
            stringify!(ap_pid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<auditpinfo_addr>())).ap_auid as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(auditpinfo_addr),
            "::",
            stringify!(ap_auid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<auditpinfo_addr>())).ap_mask as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(auditpinfo_addr),
            "::",
            stringify!(ap_mask)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<auditpinfo_addr>())).ap_termid as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(auditpinfo_addr),
            "::",
            stringify!(ap_termid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<auditpinfo_addr>())).ap_asid as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(auditpinfo_addr),
            "::",
            stringify!(ap_asid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<auditpinfo_addr>())).ap_flags as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(auditpinfo_addr),
            "::",
            stringify!(ap_flags)
        )
    );
}
pub type auditpinfo_addr_t = auditpinfo_addr;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct au_session {
    pub as_aia_p: *mut auditinfo_addr_t,
    pub as_mask: au_mask_t,
}
#[test]
fn bindgen_test_layout_au_session() {
    assert_eq!(
        ::std::mem::size_of::<au_session>(),
        16usize,
        concat!("Size of: ", stringify!(au_session))
    );
    assert_eq!(
        ::std::mem::align_of::<au_session>(),
        8usize,
        concat!("Alignment of ", stringify!(au_session))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<au_session>())).as_aia_p as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(au_session),
            "::",
            stringify!(as_aia_p)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<au_session>())).as_mask as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(au_session),
            "::",
            stringify!(as_mask)
        )
    );
}
pub type au_session_t = au_session;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct au_expire_after {
    pub age: time_t,
    pub size: size_t,
    pub op_type: ::std::os::raw::c_uchar,
}
#[test]
fn bindgen_test_layout_au_expire_after() {
    assert_eq!(
        ::std::mem::size_of::<au_expire_after>(),
        24usize,
        concat!("Size of: ", stringify!(au_expire_after))
    );
    assert_eq!(
        ::std::mem::align_of::<au_expire_after>(),
        8usize,
        concat!("Alignment of ", stringify!(au_expire_after))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<au_expire_after>())).age as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(au_expire_after),
            "::",
            stringify!(age)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<au_expire_after>())).size as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(au_expire_after),
            "::",
            stringify!(size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<au_expire_after>())).op_type as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(au_expire_after),
            "::",
            stringify!(op_type)
        )
    );
}
pub type au_expire_after_t = au_expire_after;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct au_token {
    _unused: [u8; 0],
}
pub type token_t = au_token;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct au_qctrl {
    pub aq_hiwater: ::std::os::raw::c_int,
    pub aq_lowater: ::std::os::raw::c_int,
    pub aq_bufsz: ::std::os::raw::c_int,
    pub aq_delay: ::std::os::raw::c_int,
    pub aq_minfree: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_au_qctrl() {
    assert_eq!(
        ::std::mem::size_of::<au_qctrl>(),
        20usize,
        concat!("Size of: ", stringify!(au_qctrl))
    );
    assert_eq!(
        ::std::mem::align_of::<au_qctrl>(),
        4usize,
        concat!("Alignment of ", stringify!(au_qctrl))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<au_qctrl>())).aq_hiwater as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(au_qctrl),
            "::",
            stringify!(aq_hiwater)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<au_qctrl>())).aq_lowater as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(au_qctrl),
            "::",
            stringify!(aq_lowater)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<au_qctrl>())).aq_bufsz as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(au_qctrl),
            "::",
            stringify!(aq_bufsz)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<au_qctrl>())).aq_delay as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(au_qctrl),
            "::",
            stringify!(aq_delay)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<au_qctrl>())).aq_minfree as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(au_qctrl),
            "::",
            stringify!(aq_minfree)
        )
    );
}
pub type au_qctrl_t = au_qctrl;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct audit_stat {
    pub as_version: ::std::os::raw::c_uint,
    pub as_numevent: ::std::os::raw::c_uint,
    pub as_generated: ::std::os::raw::c_int,
    pub as_nonattrib: ::std::os::raw::c_int,
    pub as_kernel: ::std::os::raw::c_int,
    pub as_audit: ::std::os::raw::c_int,
    pub as_auditctl: ::std::os::raw::c_int,
    pub as_enqueue: ::std::os::raw::c_int,
    pub as_written: ::std::os::raw::c_int,
    pub as_wblocked: ::std::os::raw::c_int,
    pub as_rblocked: ::std::os::raw::c_int,
    pub as_dropped: ::std::os::raw::c_int,
    pub as_totalsize: ::std::os::raw::c_int,
    pub as_memused: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout_audit_stat() {
    assert_eq!(
        ::std::mem::size_of::<audit_stat>(),
        56usize,
        concat!("Size of: ", stringify!(audit_stat))
    );
    assert_eq!(
        ::std::mem::align_of::<audit_stat>(),
        4usize,
        concat!("Alignment of ", stringify!(audit_stat))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<audit_stat>())).as_version as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(audit_stat),
            "::",
            stringify!(as_version)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<audit_stat>())).as_numevent as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(audit_stat),
            "::",
            stringify!(as_numevent)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<audit_stat>())).as_generated as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(audit_stat),
            "::",
            stringify!(as_generated)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<audit_stat>())).as_nonattrib as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(audit_stat),
            "::",
            stringify!(as_nonattrib)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<audit_stat>())).as_kernel as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(audit_stat),
            "::",
            stringify!(as_kernel)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<audit_stat>())).as_audit as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(audit_stat),
            "::",
            stringify!(as_audit)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<audit_stat>())).as_auditctl as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(audit_stat),
            "::",
            stringify!(as_auditctl)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<audit_stat>())).as_enqueue as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(audit_stat),
            "::",
            stringify!(as_enqueue)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<audit_stat>())).as_written as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(audit_stat),
            "::",
            stringify!(as_written)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<audit_stat>())).as_wblocked as *const _ as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(audit_stat),
            "::",
            stringify!(as_wblocked)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<audit_stat>())).as_rblocked as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(audit_stat),
            "::",
            stringify!(as_rblocked)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<audit_stat>())).as_dropped as *const _ as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(audit_stat),
            "::",
            stringify!(as_dropped)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<audit_stat>())).as_totalsize as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(audit_stat),
            "::",
            stringify!(as_totalsize)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<audit_stat>())).as_memused as *const _ as usize },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(audit_stat),
            "::",
            stringify!(as_memused)
        )
    );
}
pub type au_stat_t = audit_stat;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct audit_fstat {
    pub af_filesz: u_int64_t,
    pub af_currsz: u_int64_t,
}
#[test]
fn bindgen_test_layout_audit_fstat() {
    assert_eq!(
        ::std::mem::size_of::<audit_fstat>(),
        16usize,
        concat!("Size of: ", stringify!(audit_fstat))
    );
    assert_eq!(
        ::std::mem::align_of::<audit_fstat>(),
        8usize,
        concat!("Alignment of ", stringify!(audit_fstat))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<audit_fstat>())).af_filesz as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(audit_fstat),
            "::",
            stringify!(af_filesz)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<audit_fstat>())).af_currsz as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(audit_fstat),
            "::",
            stringify!(af_currsz)
        )
    );
}
pub type au_fstat_t = audit_fstat;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct au_evclass_map {
    pub ec_number: au_event_t,
    pub ec_class: au_class_t,
}
#[test]
fn bindgen_test_layout_au_evclass_map() {
    assert_eq!(
        ::std::mem::size_of::<au_evclass_map>(),
        8usize,
        concat!("Size of: ", stringify!(au_evclass_map))
    );
    assert_eq!(
        ::std::mem::align_of::<au_evclass_map>(),
        4usize,
        concat!("Alignment of ", stringify!(au_evclass_map))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<au_evclass_map>())).ec_number as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(au_evclass_map),
            "::",
            stringify!(ec_number)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<au_evclass_map>())).ec_class as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(au_evclass_map),
            "::",
            stringify!(ec_class)
        )
    );
}
pub type au_evclass_map_t = au_evclass_map;
extern "C" {
    pub fn audit(
        arg1: *const ::std::os::raw::c_void,
        arg2: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn auditon(
        arg1: ::std::os::raw::c_int,
        arg2: *mut ::std::os::raw::c_void,
        arg3: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn auditctl(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getauid(arg1: *mut au_id_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setauid(arg1: *const au_id_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getaudit_addr(
        arg1: *mut auditinfo_addr,
        arg2: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setaudit_addr(
        arg1: *const auditinfo_addr,
        arg2: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getaudit(arg1: *mut auditinfo) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setaudit(arg1: *const auditinfo) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn audit_session_self() -> mach_port_name_t;
}
extern "C" {
    pub fn audit_session_join(port: mach_port_name_t) -> au_asid_t;
}
extern "C" {
    pub fn audit_session_port(
        asid: au_asid_t,
        portname: *mut mach_port_name_t,
    ) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct label {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ucred {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct posix_cred {
    _unused: [u8; 0],
}
pub type kauth_cred_t = *mut ucred;
pub type posix_cred_t = *mut posix_cred;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xucred {
    pub cr_version: u_int,
    pub cr_uid: uid_t,
    pub cr_ngroups: ::std::os::raw::c_short,
    pub cr_groups: [gid_t; 16usize],
}
#[test]
fn bindgen_test_layout_xucred() {
    assert_eq!(
        ::std::mem::size_of::<xucred>(),
        76usize,
        concat!("Size of: ", stringify!(xucred))
    );
    assert_eq!(
        ::std::mem::align_of::<xucred>(),
        4usize,
        concat!("Alignment of ", stringify!(xucred))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xucred>())).cr_version as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xucred),
            "::",
            stringify!(cr_version)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xucred>())).cr_uid as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(xucred),
            "::",
            stringify!(cr_uid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xucred>())).cr_ngroups as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(xucred),
            "::",
            stringify!(cr_ngroups)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xucred>())).cr_groups as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(xucred),
            "::",
            stringify!(cr_groups)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct timespec {
    pub tv_sec: __darwin_time_t,
    pub tv_nsec: ::std::os::raw::c_long,
}
#[test]
fn bindgen_test_layout_timespec() {
    assert_eq!(
        ::std::mem::size_of::<timespec>(),
        16usize,
        concat!("Size of: ", stringify!(timespec))
    );
    assert_eq!(
        ::std::mem::align_of::<timespec>(),
        8usize,
        concat!("Alignment of ", stringify!(timespec))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<timespec>())).tv_sec as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(timespec),
            "::",
            stringify!(tv_sec)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<timespec>())).tv_nsec as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(timespec),
            "::",
            stringify!(tv_nsec)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct timeval {
    pub tv_sec: __darwin_time_t,
    pub tv_usec: __darwin_suseconds_t,
}
#[test]
fn bindgen_test_layout_timeval() {
    assert_eq!(
        ::std::mem::size_of::<timeval>(),
        16usize,
        concat!("Size of: ", stringify!(timeval))
    );
    assert_eq!(
        ::std::mem::align_of::<timeval>(),
        8usize,
        concat!("Alignment of ", stringify!(timeval))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<timeval>())).tv_sec as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(timeval),
            "::",
            stringify!(tv_sec)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<timeval>())).tv_usec as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(timeval),
            "::",
            stringify!(tv_usec)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct timeval64 {
    pub tv_sec: __int64_t,
    pub tv_usec: __int64_t,
}
#[test]
fn bindgen_test_layout_timeval64() {
    assert_eq!(
        ::std::mem::size_of::<timeval64>(),
        16usize,
        concat!("Size of: ", stringify!(timeval64))
    );
    assert_eq!(
        ::std::mem::align_of::<timeval64>(),
        8usize,
        concat!("Alignment of ", stringify!(timeval64))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<timeval64>())).tv_sec as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(timeval64),
            "::",
            stringify!(tv_sec)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<timeval64>())).tv_usec as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(timeval64),
            "::",
            stringify!(tv_usec)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct itimerval {
    pub it_interval: timeval,
    pub it_value: timeval,
}
#[test]
fn bindgen_test_layout_itimerval() {
    assert_eq!(
        ::std::mem::size_of::<itimerval>(),
        32usize,
        concat!("Size of: ", stringify!(itimerval))
    );
    assert_eq!(
        ::std::mem::align_of::<itimerval>(),
        8usize,
        concat!("Alignment of ", stringify!(itimerval))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<itimerval>())).it_interval as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(itimerval),
            "::",
            stringify!(it_interval)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<itimerval>())).it_value as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(itimerval),
            "::",
            stringify!(it_value)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct timezone {
    pub tz_minuteswest: ::std::os::raw::c_int,
    pub tz_dsttime: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_timezone() {
    assert_eq!(
        ::std::mem::size_of::<timezone>(),
        8usize,
        concat!("Size of: ", stringify!(timezone))
    );
    assert_eq!(
        ::std::mem::align_of::<timezone>(),
        4usize,
        concat!("Alignment of ", stringify!(timezone))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<timezone>())).tz_minuteswest as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(timezone),
            "::",
            stringify!(tz_minuteswest)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<timezone>())).tz_dsttime as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(timezone),
            "::",
            stringify!(tz_dsttime)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct clockinfo {
    pub hz: ::std::os::raw::c_int,
    pub tick: ::std::os::raw::c_int,
    pub tickadj: ::std::os::raw::c_int,
    pub stathz: ::std::os::raw::c_int,
    pub profhz: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_clockinfo() {
    assert_eq!(
        ::std::mem::size_of::<clockinfo>(),
        20usize,
        concat!("Size of: ", stringify!(clockinfo))
    );
    assert_eq!(
        ::std::mem::align_of::<clockinfo>(),
        4usize,
        concat!("Alignment of ", stringify!(clockinfo))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<clockinfo>())).hz as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(clockinfo),
            "::",
            stringify!(hz)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<clockinfo>())).tick as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(clockinfo),
            "::",
            stringify!(tick)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<clockinfo>())).tickadj as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(clockinfo),
            "::",
            stringify!(tickadj)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<clockinfo>())).stathz as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(clockinfo),
            "::",
            stringify!(stathz)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<clockinfo>())).profhz as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(clockinfo),
            "::",
            stringify!(profhz)
        )
    );
}
pub type __darwin_nl_item = ::std::os::raw::c_int;
pub type __darwin_wctrans_t = ::std::os::raw::c_int;
pub type __darwin_wctype_t = __uint32_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct tm {
    pub tm_sec: ::std::os::raw::c_int,
    pub tm_min: ::std::os::raw::c_int,
    pub tm_hour: ::std::os::raw::c_int,
    pub tm_mday: ::std::os::raw::c_int,
    pub tm_mon: ::std::os::raw::c_int,
    pub tm_year: ::std::os::raw::c_int,
    pub tm_wday: ::std::os::raw::c_int,
    pub tm_yday: ::std::os::raw::c_int,
    pub tm_isdst: ::std::os::raw::c_int,
    pub tm_gmtoff: ::std::os::raw::c_long,
    pub tm_zone: *mut ::std::os::raw::c_char,
}
#[test]
fn bindgen_test_layout_tm() {
    assert_eq!(
        ::std::mem::size_of::<tm>(),
        56usize,
        concat!("Size of: ", stringify!(tm))
    );
    assert_eq!(
        ::std::mem::align_of::<tm>(),
        8usize,
        concat!("Alignment of ", stringify!(tm))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<tm>())).tm_sec as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(tm),
            "::",
            stringify!(tm_sec)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<tm>())).tm_min as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(tm),
            "::",
            stringify!(tm_min)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<tm>())).tm_hour as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(tm),
            "::",
            stringify!(tm_hour)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<tm>())).tm_mday as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(tm),
            "::",
            stringify!(tm_mday)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<tm>())).tm_mon as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(tm),
            "::",
            stringify!(tm_mon)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<tm>())).tm_year as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(tm),
            "::",
            stringify!(tm_year)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<tm>())).tm_wday as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(tm),
            "::",
            stringify!(tm_wday)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<tm>())).tm_yday as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(tm),
            "::",
            stringify!(tm_yday)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<tm>())).tm_isdst as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(tm),
            "::",
            stringify!(tm_isdst)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<tm>())).tm_gmtoff as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(tm),
            "::",
            stringify!(tm_gmtoff)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<tm>())).tm_zone as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(tm),
            "::",
            stringify!(tm_zone)
        )
    );
}
extern "C" {
    pub static mut tzname: [*mut ::std::os::raw::c_char; 0usize];
}
extern "C" {
    pub static mut getdate_err: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut timezone: ::std::os::raw::c_long;
}
extern "C" {
    pub static mut daylight: ::std::os::raw::c_int;
}
extern "C" {
    pub fn asctime(arg1: *const tm) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn clock() -> clock_t;
}
extern "C" {
    pub fn ctime(arg1: *const time_t) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn difftime(arg1: time_t, arg2: time_t) -> f64;
}
extern "C" {
    pub fn getdate(arg1: *const ::std::os::raw::c_char) -> *mut tm;
}
extern "C" {
    pub fn gmtime(arg1: *const time_t) -> *mut tm;
}
extern "C" {
    pub fn localtime(arg1: *const time_t) -> *mut tm;
}
extern "C" {
    pub fn mktime(arg1: *mut tm) -> time_t;
}
extern "C" {
    pub fn strftime(
        arg1: *mut ::std::os::raw::c_char,
        arg2: size_t,
        arg3: *const ::std::os::raw::c_char,
        arg4: *const tm,
    ) -> size_t;
}
extern "C" {
    pub fn strptime(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        arg3: *mut tm,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn time(arg1: *mut time_t) -> time_t;
}
extern "C" {
    pub fn tzset();
}
extern "C" {
    pub fn asctime_r(
        arg1: *const tm,
        arg2: *mut ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn ctime_r(
        arg1: *const time_t,
        arg2: *mut ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn gmtime_r(arg1: *const time_t, arg2: *mut tm) -> *mut tm;
}
extern "C" {
    pub fn localtime_r(arg1: *const time_t, arg2: *mut tm) -> *mut tm;
}
extern "C" {
    pub fn posix2time(arg1: time_t) -> time_t;
}
extern "C" {
    pub fn tzsetwall();
}
extern "C" {
    pub fn time2posix(arg1: time_t) -> time_t;
}
extern "C" {
    pub fn timelocal(arg1: *mut tm) -> time_t;
}
extern "C" {
    pub fn timegm(arg1: *mut tm) -> time_t;
}
extern "C" {
    pub fn nanosleep(__rqtp: *const timespec, __rmtp: *mut timespec) -> ::std::os::raw::c_int;
}
pub const clockid_t__CLOCK_REALTIME: clockid_t = 0;
pub const clockid_t__CLOCK_MONOTONIC: clockid_t = 6;
pub const clockid_t__CLOCK_MONOTONIC_RAW: clockid_t = 4;
pub const clockid_t__CLOCK_MONOTONIC_RAW_APPROX: clockid_t = 5;
pub const clockid_t__CLOCK_UPTIME_RAW: clockid_t = 8;
pub const clockid_t__CLOCK_UPTIME_RAW_APPROX: clockid_t = 9;
pub const clockid_t__CLOCK_PROCESS_CPUTIME_ID: clockid_t = 12;
pub const clockid_t__CLOCK_THREAD_CPUTIME_ID: clockid_t = 16;
pub type clockid_t = ::std::os::raw::c_uint;
extern "C" {
    pub fn clock_getres(__clock_id: clockid_t, __res: *mut timespec) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn clock_gettime(__clock_id: clockid_t, __tp: *mut timespec) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn clock_gettime_nsec_np(__clock_id: clockid_t) -> __uint64_t;
}
extern "C" {
    pub fn clock_settime(__clock_id: clockid_t, __tp: *const timespec) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn timespec_get(ts: *mut timespec, base: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn adjtime(arg1: *const timeval, arg2: *mut timeval) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn futimes(arg1: ::std::os::raw::c_int, arg2: *const timeval) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn lutimes(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const timeval,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn settimeofday(arg1: *const timeval, arg2: *const timezone) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getitimer(arg1: ::std::os::raw::c_int, arg2: *mut itimerval) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn gettimeofday(
        arg1: *mut timeval,
        arg2: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}_select$1050"]
    pub fn select(
        arg1: ::std::os::raw::c_int,
        arg2: *mut fd_set,
        arg3: *mut fd_set,
        arg4: *mut fd_set,
        arg5: *mut timeval,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setitimer(
        arg1: ::std::os::raw::c_int,
        arg2: *const itimerval,
        arg3: *mut itimerval,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn utimes(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const timeval,
    ) -> ::std::os::raw::c_int;
}
pub type text_encoding_t = u_int32_t;
pub type fsobj_type_t = u_int32_t;
pub type fsobj_tag_t = u_int32_t;
pub type fsfile_type_t = u_int32_t;
pub type fsvolid_t = u_int32_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct fsobj_id {
    pub fid_objno: u_int32_t,
    pub fid_generation: u_int32_t,
}
#[test]
fn bindgen_test_layout_fsobj_id() {
    assert_eq!(
        ::std::mem::size_of::<fsobj_id>(),
        8usize,
        concat!("Size of: ", stringify!(fsobj_id))
    );
    assert_eq!(
        ::std::mem::align_of::<fsobj_id>(),
        4usize,
        concat!("Alignment of ", stringify!(fsobj_id))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<fsobj_id>())).fid_objno as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(fsobj_id),
            "::",
            stringify!(fid_objno)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<fsobj_id>())).fid_generation as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(fsobj_id),
            "::",
            stringify!(fid_generation)
        )
    );
}
pub type fsobj_id_t = fsobj_id;
pub type attrgroup_t = u_int32_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct attrlist {
    pub bitmapcount: u_short,
    pub reserved: u_int16_t,
    pub commonattr: attrgroup_t,
    pub volattr: attrgroup_t,
    pub dirattr: attrgroup_t,
    pub fileattr: attrgroup_t,
    pub forkattr: attrgroup_t,
}
#[test]
fn bindgen_test_layout_attrlist() {
    assert_eq!(
        ::std::mem::size_of::<attrlist>(),
        24usize,
        concat!("Size of: ", stringify!(attrlist))
    );
    assert_eq!(
        ::std::mem::align_of::<attrlist>(),
        4usize,
        concat!("Alignment of ", stringify!(attrlist))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<attrlist>())).bitmapcount as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(attrlist),
            "::",
            stringify!(bitmapcount)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<attrlist>())).reserved as *const _ as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(attrlist),
            "::",
            stringify!(reserved)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<attrlist>())).commonattr as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(attrlist),
            "::",
            stringify!(commonattr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<attrlist>())).volattr as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(attrlist),
            "::",
            stringify!(volattr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<attrlist>())).dirattr as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(attrlist),
            "::",
            stringify!(dirattr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<attrlist>())).fileattr as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(attrlist),
            "::",
            stringify!(fileattr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<attrlist>())).forkattr as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(attrlist),
            "::",
            stringify!(forkattr)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct attribute_set {
    pub commonattr: attrgroup_t,
    pub volattr: attrgroup_t,
    pub dirattr: attrgroup_t,
    pub fileattr: attrgroup_t,
    pub forkattr: attrgroup_t,
}
#[test]
fn bindgen_test_layout_attribute_set() {
    assert_eq!(
        ::std::mem::size_of::<attribute_set>(),
        20usize,
        concat!("Size of: ", stringify!(attribute_set))
    );
    assert_eq!(
        ::std::mem::align_of::<attribute_set>(),
        4usize,
        concat!("Alignment of ", stringify!(attribute_set))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<attribute_set>())).commonattr as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(attribute_set),
            "::",
            stringify!(commonattr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<attribute_set>())).volattr as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(attribute_set),
            "::",
            stringify!(volattr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<attribute_set>())).dirattr as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(attribute_set),
            "::",
            stringify!(dirattr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<attribute_set>())).fileattr as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(attribute_set),
            "::",
            stringify!(fileattr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<attribute_set>())).forkattr as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(attribute_set),
            "::",
            stringify!(forkattr)
        )
    );
}
pub type attribute_set_t = attribute_set;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct attrreference {
    pub attr_dataoffset: i32,
    pub attr_length: u_int32_t,
}
#[test]
fn bindgen_test_layout_attrreference() {
    assert_eq!(
        ::std::mem::size_of::<attrreference>(),
        8usize,
        concat!("Size of: ", stringify!(attrreference))
    );
    assert_eq!(
        ::std::mem::align_of::<attrreference>(),
        4usize,
        concat!("Alignment of ", stringify!(attrreference))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<attrreference>())).attr_dataoffset as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(attrreference),
            "::",
            stringify!(attr_dataoffset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<attrreference>())).attr_length as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(attrreference),
            "::",
            stringify!(attr_length)
        )
    );
}
pub type attrreference_t = attrreference;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct diskextent {
    pub startblock: u_int32_t,
    pub blockcount: u_int32_t,
}
#[test]
fn bindgen_test_layout_diskextent() {
    assert_eq!(
        ::std::mem::size_of::<diskextent>(),
        8usize,
        concat!("Size of: ", stringify!(diskextent))
    );
    assert_eq!(
        ::std::mem::align_of::<diskextent>(),
        4usize,
        concat!("Alignment of ", stringify!(diskextent))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<diskextent>())).startblock as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(diskextent),
            "::",
            stringify!(startblock)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<diskextent>())).blockcount as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(diskextent),
            "::",
            stringify!(blockcount)
        )
    );
}
pub type extentrecord = [diskextent; 8usize];
pub type vol_capabilities_set_t = [u_int32_t; 4usize];
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct vol_capabilities_attr {
    pub capabilities: vol_capabilities_set_t,
    pub valid: vol_capabilities_set_t,
}
#[test]
fn bindgen_test_layout_vol_capabilities_attr() {
    assert_eq!(
        ::std::mem::size_of::<vol_capabilities_attr>(),
        32usize,
        concat!("Size of: ", stringify!(vol_capabilities_attr))
    );
    assert_eq!(
        ::std::mem::align_of::<vol_capabilities_attr>(),
        4usize,
        concat!("Alignment of ", stringify!(vol_capabilities_attr))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<vol_capabilities_attr>())).capabilities as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(vol_capabilities_attr),
            "::",
            stringify!(capabilities)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<vol_capabilities_attr>())).valid as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(vol_capabilities_attr),
            "::",
            stringify!(valid)
        )
    );
}
pub type vol_capabilities_attr_t = vol_capabilities_attr;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct vol_attributes_attr {
    pub validattr: attribute_set_t,
    pub nativeattr: attribute_set_t,
}
#[test]
fn bindgen_test_layout_vol_attributes_attr() {
    assert_eq!(
        ::std::mem::size_of::<vol_attributes_attr>(),
        40usize,
        concat!("Size of: ", stringify!(vol_attributes_attr))
    );
    assert_eq!(
        ::std::mem::align_of::<vol_attributes_attr>(),
        4usize,
        concat!("Alignment of ", stringify!(vol_attributes_attr))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<vol_attributes_attr>())).validattr as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(vol_attributes_attr),
            "::",
            stringify!(validattr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<vol_attributes_attr>())).nativeattr as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(vol_attributes_attr),
            "::",
            stringify!(nativeattr)
        )
    );
}
pub type vol_attributes_attr_t = vol_attributes_attr;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct fssearchblock {
    pub returnattrs: *mut attrlist,
    pub returnbuffer: *mut ::std::os::raw::c_void,
    pub returnbuffersize: size_t,
    pub maxmatches: u_long,
    pub timelimit: timeval,
    pub searchparams1: *mut ::std::os::raw::c_void,
    pub sizeofsearchparams1: size_t,
    pub searchparams2: *mut ::std::os::raw::c_void,
    pub sizeofsearchparams2: size_t,
    pub searchattrs: attrlist,
}
#[test]
fn bindgen_test_layout_fssearchblock() {
    assert_eq!(
        ::std::mem::size_of::<fssearchblock>(),
        104usize,
        concat!("Size of: ", stringify!(fssearchblock))
    );
    assert_eq!(
        ::std::mem::align_of::<fssearchblock>(),
        8usize,
        concat!("Alignment of ", stringify!(fssearchblock))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<fssearchblock>())).returnattrs as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(fssearchblock),
            "::",
            stringify!(returnattrs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<fssearchblock>())).returnbuffer as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(fssearchblock),
            "::",
            stringify!(returnbuffer)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<fssearchblock>())).returnbuffersize as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(fssearchblock),
            "::",
            stringify!(returnbuffersize)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<fssearchblock>())).maxmatches as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(fssearchblock),
            "::",
            stringify!(maxmatches)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<fssearchblock>())).timelimit as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(fssearchblock),
            "::",
            stringify!(timelimit)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<fssearchblock>())).searchparams1 as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(fssearchblock),
            "::",
            stringify!(searchparams1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fssearchblock>())).sizeofsearchparams1 as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(fssearchblock),
            "::",
            stringify!(sizeofsearchparams1)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<fssearchblock>())).searchparams2 as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(fssearchblock),
            "::",
            stringify!(searchparams2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fssearchblock>())).sizeofsearchparams2 as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(fssearchblock),
            "::",
            stringify!(sizeofsearchparams2)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<fssearchblock>())).searchattrs as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(fssearchblock),
            "::",
            stringify!(searchattrs)
        )
    );
}
#[repr(C, packed)]
#[derive(Copy, Clone)]
pub struct searchstate {
    pub ss_union_flags: u32,
    pub ss_union_layer: u32,
    pub ss_fsstate: [u_char; 548usize],
}
#[test]
fn bindgen_test_layout_searchstate() {
    assert_eq!(
        ::std::mem::size_of::<searchstate>(),
        556usize,
        concat!("Size of: ", stringify!(searchstate))
    );
    assert_eq!(
        ::std::mem::align_of::<searchstate>(),
        1usize,
        concat!("Alignment of ", stringify!(searchstate))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<searchstate>())).ss_union_flags as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(searchstate),
            "::",
            stringify!(ss_union_flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<searchstate>())).ss_union_layer as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(searchstate),
            "::",
            stringify!(ss_union_layer)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<searchstate>())).ss_fsstate as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(searchstate),
            "::",
            stringify!(ss_fsstate)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct fsid {
    pub val: [i32; 2usize],
}
#[test]
fn bindgen_test_layout_fsid() {
    assert_eq!(
        ::std::mem::size_of::<fsid>(),
        8usize,
        concat!("Size of: ", stringify!(fsid))
    );
    assert_eq!(
        ::std::mem::align_of::<fsid>(),
        4usize,
        concat!("Alignment of ", stringify!(fsid))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<fsid>())).val as *const _ as usize },
        0usize,
        concat!("Offset of field: ", stringify!(fsid), "::", stringify!(val))
    );
}
pub type fsid_t = fsid;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct statfs64 {
    pub f_bsize: u32,
    pub f_iosize: i32,
    pub f_blocks: u64,
    pub f_bfree: u64,
    pub f_bavail: u64,
    pub f_files: u64,
    pub f_ffree: u64,
    pub f_fsid: fsid_t,
    pub f_owner: uid_t,
    pub f_type: u32,
    pub f_flags: u32,
    pub f_fssubtype: u32,
    pub f_fstypename: [::std::os::raw::c_char; 16usize],
    pub f_mntonname: [::std::os::raw::c_char; 1024usize],
    pub f_mntfromname: [::std::os::raw::c_char; 1024usize],
    pub f_flags_ext: u32,
    pub f_reserved: [u32; 7usize],
}
#[test]
fn bindgen_test_layout_statfs64() {
    assert_eq!(
        ::std::mem::size_of::<statfs64>(),
        2168usize,
        concat!("Size of: ", stringify!(statfs64))
    );
    assert_eq!(
        ::std::mem::align_of::<statfs64>(),
        8usize,
        concat!("Alignment of ", stringify!(statfs64))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<statfs64>())).f_bsize as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(statfs64),
            "::",
            stringify!(f_bsize)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<statfs64>())).f_iosize as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(statfs64),
            "::",
            stringify!(f_iosize)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<statfs64>())).f_blocks as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(statfs64),
            "::",
            stringify!(f_blocks)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<statfs64>())).f_bfree as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(statfs64),
            "::",
            stringify!(f_bfree)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<statfs64>())).f_bavail as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(statfs64),
            "::",
            stringify!(f_bavail)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<statfs64>())).f_files as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(statfs64),
            "::",
            stringify!(f_files)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<statfs64>())).f_ffree as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(statfs64),
            "::",
            stringify!(f_ffree)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<statfs64>())).f_fsid as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(statfs64),
            "::",
            stringify!(f_fsid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<statfs64>())).f_owner as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(statfs64),
            "::",
            stringify!(f_owner)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<statfs64>())).f_type as *const _ as usize },
        60usize,
        concat!(
            "Offset of field: ",
            stringify!(statfs64),
            "::",
            stringify!(f_type)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<statfs64>())).f_flags as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(statfs64),
            "::",
            stringify!(f_flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<statfs64>())).f_fssubtype as *const _ as usize },
        68usize,
        concat!(
            "Offset of field: ",
            stringify!(statfs64),
            "::",
            stringify!(f_fssubtype)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<statfs64>())).f_fstypename as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(statfs64),
            "::",
            stringify!(f_fstypename)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<statfs64>())).f_mntonname as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(statfs64),
            "::",
            stringify!(f_mntonname)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<statfs64>())).f_mntfromname as *const _ as usize },
        1112usize,
        concat!(
            "Offset of field: ",
            stringify!(statfs64),
            "::",
            stringify!(f_mntfromname)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<statfs64>())).f_flags_ext as *const _ as usize },
        2136usize,
        concat!(
            "Offset of field: ",
            stringify!(statfs64),
            "::",
            stringify!(f_flags_ext)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<statfs64>())).f_reserved as *const _ as usize },
        2140usize,
        concat!(
            "Offset of field: ",
            stringify!(statfs64),
            "::",
            stringify!(f_reserved)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct statfs {
    pub f_bsize: u32,
    pub f_iosize: i32,
    pub f_blocks: u64,
    pub f_bfree: u64,
    pub f_bavail: u64,
    pub f_files: u64,
    pub f_ffree: u64,
    pub f_fsid: fsid_t,
    pub f_owner: uid_t,
    pub f_type: u32,
    pub f_flags: u32,
    pub f_fssubtype: u32,
    pub f_fstypename: [::std::os::raw::c_char; 16usize],
    pub f_mntonname: [::std::os::raw::c_char; 1024usize],
    pub f_mntfromname: [::std::os::raw::c_char; 1024usize],
    pub f_flags_ext: u32,
    pub f_reserved: [u32; 7usize],
}
#[test]
fn bindgen_test_layout_statfs() {
    assert_eq!(
        ::std::mem::size_of::<statfs>(),
        2168usize,
        concat!("Size of: ", stringify!(statfs))
    );
    assert_eq!(
        ::std::mem::align_of::<statfs>(),
        8usize,
        concat!("Alignment of ", stringify!(statfs))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<statfs>())).f_bsize as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(statfs),
            "::",
            stringify!(f_bsize)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<statfs>())).f_iosize as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(statfs),
            "::",
            stringify!(f_iosize)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<statfs>())).f_blocks as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(statfs),
            "::",
            stringify!(f_blocks)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<statfs>())).f_bfree as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(statfs),
            "::",
            stringify!(f_bfree)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<statfs>())).f_bavail as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(statfs),
            "::",
            stringify!(f_bavail)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<statfs>())).f_files as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(statfs),
            "::",
            stringify!(f_files)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<statfs>())).f_ffree as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(statfs),
            "::",
            stringify!(f_ffree)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<statfs>())).f_fsid as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(statfs),
            "::",
            stringify!(f_fsid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<statfs>())).f_owner as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(statfs),
            "::",
            stringify!(f_owner)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<statfs>())).f_type as *const _ as usize },
        60usize,
        concat!(
            "Offset of field: ",
            stringify!(statfs),
            "::",
            stringify!(f_type)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<statfs>())).f_flags as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(statfs),
            "::",
            stringify!(f_flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<statfs>())).f_fssubtype as *const _ as usize },
        68usize,
        concat!(
            "Offset of field: ",
            stringify!(statfs),
            "::",
            stringify!(f_fssubtype)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<statfs>())).f_fstypename as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(statfs),
            "::",
            stringify!(f_fstypename)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<statfs>())).f_mntonname as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(statfs),
            "::",
            stringify!(f_mntonname)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<statfs>())).f_mntfromname as *const _ as usize },
        1112usize,
        concat!(
            "Offset of field: ",
            stringify!(statfs),
            "::",
            stringify!(f_mntfromname)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<statfs>())).f_flags_ext as *const _ as usize },
        2136usize,
        concat!(
            "Offset of field: ",
            stringify!(statfs),
            "::",
            stringify!(f_flags_ext)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<statfs>())).f_reserved as *const _ as usize },
        2140usize,
        concat!(
            "Offset of field: ",
            stringify!(statfs),
            "::",
            stringify!(f_reserved)
        )
    );
}
#[repr(C, packed(4))]
#[derive(Copy, Clone)]
pub struct vfsstatfs {
    pub f_bsize: u32,
    pub f_iosize: size_t,
    pub f_blocks: u64,
    pub f_bfree: u64,
    pub f_bavail: u64,
    pub f_bused: u64,
    pub f_files: u64,
    pub f_ffree: u64,
    pub f_fsid: fsid_t,
    pub f_owner: uid_t,
    pub f_flags: u64,
    pub f_fstypename: [::std::os::raw::c_char; 16usize],
    pub f_mntonname: [::std::os::raw::c_char; 1024usize],
    pub f_mntfromname: [::std::os::raw::c_char; 1024usize],
    pub f_fssubtype: u32,
    pub f_reserved: [*mut ::std::os::raw::c_void; 2usize],
}
#[test]
fn bindgen_test_layout_vfsstatfs() {
    assert_eq!(
        ::std::mem::size_of::<vfsstatfs>(),
        2164usize,
        concat!("Size of: ", stringify!(vfsstatfs))
    );
    assert_eq!(
        ::std::mem::align_of::<vfsstatfs>(),
        4usize,
        concat!("Alignment of ", stringify!(vfsstatfs))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<vfsstatfs>())).f_bsize as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(vfsstatfs),
            "::",
            stringify!(f_bsize)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<vfsstatfs>())).f_iosize as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(vfsstatfs),
            "::",
            stringify!(f_iosize)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<vfsstatfs>())).f_blocks as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(vfsstatfs),
            "::",
            stringify!(f_blocks)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<vfsstatfs>())).f_bfree as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(vfsstatfs),
            "::",
            stringify!(f_bfree)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<vfsstatfs>())).f_bavail as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(vfsstatfs),
            "::",
            stringify!(f_bavail)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<vfsstatfs>())).f_bused as *const _ as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(vfsstatfs),
            "::",
            stringify!(f_bused)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<vfsstatfs>())).f_files as *const _ as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(vfsstatfs),
            "::",
            stringify!(f_files)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<vfsstatfs>())).f_ffree as *const _ as usize },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(vfsstatfs),
            "::",
            stringify!(f_ffree)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<vfsstatfs>())).f_fsid as *const _ as usize },
        60usize,
        concat!(
            "Offset of field: ",
            stringify!(vfsstatfs),
            "::",
            stringify!(f_fsid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<vfsstatfs>())).f_owner as *const _ as usize },
        68usize,
        concat!(
            "Offset of field: ",
            stringify!(vfsstatfs),
            "::",
            stringify!(f_owner)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<vfsstatfs>())).f_flags as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(vfsstatfs),
            "::",
            stringify!(f_flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<vfsstatfs>())).f_fstypename as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(vfsstatfs),
            "::",
            stringify!(f_fstypename)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<vfsstatfs>())).f_mntonname as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(vfsstatfs),
            "::",
            stringify!(f_mntonname)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<vfsstatfs>())).f_mntfromname as *const _ as usize },
        1120usize,
        concat!(
            "Offset of field: ",
            stringify!(vfsstatfs),
            "::",
            stringify!(f_mntfromname)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<vfsstatfs>())).f_fssubtype as *const _ as usize },
        2144usize,
        concat!(
            "Offset of field: ",
            stringify!(vfsstatfs),
            "::",
            stringify!(f_fssubtype)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<vfsstatfs>())).f_reserved as *const _ as usize },
        2148usize,
        concat!(
            "Offset of field: ",
            stringify!(vfsstatfs),
            "::",
            stringify!(f_reserved)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct mount {
    _unused: [u8; 0],
}
pub type mount_t = *mut mount;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct vnode {
    _unused: [u8; 0],
}
pub type vnode_t = *mut vnode;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct vfsconf {
    pub vfc_reserved1: u32,
    pub vfc_name: [::std::os::raw::c_char; 15usize],
    pub vfc_typenum: ::std::os::raw::c_int,
    pub vfc_refcount: ::std::os::raw::c_int,
    pub vfc_flags: ::std::os::raw::c_int,
    pub vfc_reserved2: u32,
    pub vfc_reserved3: u32,
}
#[test]
fn bindgen_test_layout_vfsconf() {
    assert_eq!(
        ::std::mem::size_of::<vfsconf>(),
        40usize,
        concat!("Size of: ", stringify!(vfsconf))
    );
    assert_eq!(
        ::std::mem::align_of::<vfsconf>(),
        4usize,
        concat!("Alignment of ", stringify!(vfsconf))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<vfsconf>())).vfc_reserved1 as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(vfsconf),
            "::",
            stringify!(vfc_reserved1)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<vfsconf>())).vfc_name as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(vfsconf),
            "::",
            stringify!(vfc_name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<vfsconf>())).vfc_typenum as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(vfsconf),
            "::",
            stringify!(vfc_typenum)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<vfsconf>())).vfc_refcount as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(vfsconf),
            "::",
            stringify!(vfc_refcount)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<vfsconf>())).vfc_flags as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(vfsconf),
            "::",
            stringify!(vfc_flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<vfsconf>())).vfc_reserved2 as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(vfsconf),
            "::",
            stringify!(vfc_reserved2)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<vfsconf>())).vfc_reserved3 as *const _ as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(vfsconf),
            "::",
            stringify!(vfc_reserved3)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct vfsidctl {
    pub vc_vers: ::std::os::raw::c_int,
    pub vc_fsid: fsid_t,
    pub vc_ptr: *mut ::std::os::raw::c_void,
    pub vc_len: size_t,
    pub vc_spare: [u_int32_t; 12usize],
}
#[test]
fn bindgen_test_layout_vfsidctl() {
    assert_eq!(
        ::std::mem::size_of::<vfsidctl>(),
        80usize,
        concat!("Size of: ", stringify!(vfsidctl))
    );
    assert_eq!(
        ::std::mem::align_of::<vfsidctl>(),
        8usize,
        concat!("Alignment of ", stringify!(vfsidctl))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<vfsidctl>())).vc_vers as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(vfsidctl),
            "::",
            stringify!(vc_vers)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<vfsidctl>())).vc_fsid as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(vfsidctl),
            "::",
            stringify!(vc_fsid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<vfsidctl>())).vc_ptr as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(vfsidctl),
            "::",
            stringify!(vc_ptr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<vfsidctl>())).vc_len as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(vfsidctl),
            "::",
            stringify!(vc_len)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<vfsidctl>())).vc_spare as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(vfsidctl),
            "::",
            stringify!(vc_spare)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct vfsquery {
    pub vq_flags: u_int32_t,
    pub vq_spare: [u_int32_t; 31usize],
}
#[test]
fn bindgen_test_layout_vfsquery() {
    assert_eq!(
        ::std::mem::size_of::<vfsquery>(),
        128usize,
        concat!("Size of: ", stringify!(vfsquery))
    );
    assert_eq!(
        ::std::mem::align_of::<vfsquery>(),
        4usize,
        concat!("Alignment of ", stringify!(vfsquery))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<vfsquery>())).vq_flags as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(vfsquery),
            "::",
            stringify!(vq_flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<vfsquery>())).vq_spare as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(vfsquery),
            "::",
            stringify!(vq_spare)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct vfs_server {
    pub vs_minutes: i32,
    pub vs_server_name: [u_int8_t; 768usize],
}
#[test]
fn bindgen_test_layout_vfs_server() {
    assert_eq!(
        ::std::mem::size_of::<vfs_server>(),
        772usize,
        concat!("Size of: ", stringify!(vfs_server))
    );
    assert_eq!(
        ::std::mem::align_of::<vfs_server>(),
        4usize,
        concat!("Alignment of ", stringify!(vfs_server))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<vfs_server>())).vs_minutes as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(vfs_server),
            "::",
            stringify!(vs_minutes)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<vfs_server>())).vs_server_name as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(vfs_server),
            "::",
            stringify!(vs_server_name)
        )
    );
}
#[repr(C)]
pub struct netfs_status {
    pub ns_status: u_int32_t,
    pub ns_mountopts: [::std::os::raw::c_char; 512usize],
    pub ns_waittime: u32,
    pub ns_threadcount: u32,
    pub ns_threadids: __IncompleteArrayField<u64>,
}
#[test]
fn bindgen_test_layout_netfs_status() {
    assert_eq!(
        ::std::mem::size_of::<netfs_status>(),
        528usize,
        concat!("Size of: ", stringify!(netfs_status))
    );
    assert_eq!(
        ::std::mem::align_of::<netfs_status>(),
        8usize,
        concat!("Alignment of ", stringify!(netfs_status))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<netfs_status>())).ns_status as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(netfs_status),
            "::",
            stringify!(ns_status)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<netfs_status>())).ns_mountopts as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(netfs_status),
            "::",
            stringify!(ns_mountopts)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<netfs_status>())).ns_waittime as *const _ as usize },
        516usize,
        concat!(
            "Offset of field: ",
            stringify!(netfs_status),
            "::",
            stringify!(ns_waittime)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<netfs_status>())).ns_threadcount as *const _ as usize },
        520usize,
        concat!(
            "Offset of field: ",
            stringify!(netfs_status),
            "::",
            stringify!(ns_threadcount)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<netfs_status>())).ns_threadids as *const _ as usize },
        528usize,
        concat!(
            "Offset of field: ",
            stringify!(netfs_status),
            "::",
            stringify!(ns_threadids)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct fhandle {
    pub fh_len: ::std::os::raw::c_uint,
    pub fh_data: [::std::os::raw::c_uchar; 128usize],
}
#[test]
fn bindgen_test_layout_fhandle() {
    assert_eq!(
        ::std::mem::size_of::<fhandle>(),
        132usize,
        concat!("Size of: ", stringify!(fhandle))
    );
    assert_eq!(
        ::std::mem::align_of::<fhandle>(),
        4usize,
        concat!("Alignment of ", stringify!(fhandle))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<fhandle>())).fh_len as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(fhandle),
            "::",
            stringify!(fh_len)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<fhandle>())).fh_data as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(fhandle),
            "::",
            stringify!(fh_data)
        )
    );
}
pub type fhandle_t = fhandle;
extern "C" {
    pub fn fhopen(arg1: *const fhandle, arg2: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}_fstatfs$INODE64"]
    pub fn fstatfs(arg1: ::std::os::raw::c_int, arg2: *mut statfs) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fstatfs64(arg1: ::std::os::raw::c_int, arg2: *mut statfs64) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getfh(
        arg1: *const ::std::os::raw::c_char,
        arg2: *mut fhandle_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}_getfsstat$INODE64"]
    pub fn getfsstat(
        arg1: *mut statfs,
        arg2: ::std::os::raw::c_int,
        arg3: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getfsstat64(
        arg1: *mut statfs64,
        arg2: ::std::os::raw::c_int,
        arg3: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}_getmntinfo$INODE64"]
    pub fn getmntinfo(arg1: *mut *mut statfs, arg2: ::std::os::raw::c_int)
        -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}_getmntinfo_r_np$INODE64"]
    pub fn getmntinfo_r_np(
        arg1: *mut *mut statfs,
        arg2: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getmntinfo64(
        arg1: *mut *mut statfs64,
        arg2: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mount(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        arg3: ::std::os::raw::c_int,
        arg4: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fmount(
        arg1: *const ::std::os::raw::c_char,
        arg2: ::std::os::raw::c_int,
        arg3: ::std::os::raw::c_int,
        arg4: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}_statfs$INODE64"]
    pub fn statfs(arg1: *const ::std::os::raw::c_char, arg2: *mut statfs) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn statfs64(
        arg1: *const ::std::os::raw::c_char,
        arg2: *mut statfs64,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn unmount(
        arg1: *const ::std::os::raw::c_char,
        arg2: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getvfsbyname(
        arg1: *const ::std::os::raw::c_char,
        arg2: *mut vfsconf,
    ) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ostat {
    pub st_dev: __uint16_t,
    pub st_ino: ino_t,
    pub st_mode: mode_t,
    pub st_nlink: nlink_t,
    pub st_uid: __uint16_t,
    pub st_gid: __uint16_t,
    pub st_rdev: __uint16_t,
    pub st_size: __int32_t,
    pub st_atimespec: timespec,
    pub st_mtimespec: timespec,
    pub st_ctimespec: timespec,
    pub st_blksize: __int32_t,
    pub st_blocks: __int32_t,
    pub st_flags: __uint32_t,
    pub st_gen: __uint32_t,
}
#[test]
fn bindgen_test_layout_ostat() {
    assert_eq!(
        ::std::mem::size_of::<ostat>(),
        96usize,
        concat!("Size of: ", stringify!(ostat))
    );
    assert_eq!(
        ::std::mem::align_of::<ostat>(),
        8usize,
        concat!("Alignment of ", stringify!(ostat))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ostat>())).st_dev as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ostat),
            "::",
            stringify!(st_dev)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ostat>())).st_ino as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(ostat),
            "::",
            stringify!(st_ino)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ostat>())).st_mode as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(ostat),
            "::",
            stringify!(st_mode)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ostat>())).st_nlink as *const _ as usize },
        18usize,
        concat!(
            "Offset of field: ",
            stringify!(ostat),
            "::",
            stringify!(st_nlink)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ostat>())).st_uid as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(ostat),
            "::",
            stringify!(st_uid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ostat>())).st_gid as *const _ as usize },
        22usize,
        concat!(
            "Offset of field: ",
            stringify!(ostat),
            "::",
            stringify!(st_gid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ostat>())).st_rdev as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(ostat),
            "::",
            stringify!(st_rdev)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ostat>())).st_size as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(ostat),
            "::",
            stringify!(st_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ostat>())).st_atimespec as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(ostat),
            "::",
            stringify!(st_atimespec)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ostat>())).st_mtimespec as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(ostat),
            "::",
            stringify!(st_mtimespec)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ostat>())).st_ctimespec as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(ostat),
            "::",
            stringify!(st_ctimespec)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ostat>())).st_blksize as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(ostat),
            "::",
            stringify!(st_blksize)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ostat>())).st_blocks as *const _ as usize },
        84usize,
        concat!(
            "Offset of field: ",
            stringify!(ostat),
            "::",
            stringify!(st_blocks)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ostat>())).st_flags as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(ostat),
            "::",
            stringify!(st_flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ostat>())).st_gen as *const _ as usize },
        92usize,
        concat!(
            "Offset of field: ",
            stringify!(ostat),
            "::",
            stringify!(st_gen)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct stat {
    pub st_dev: dev_t,
    pub st_mode: mode_t,
    pub st_nlink: nlink_t,
    pub st_ino: __darwin_ino64_t,
    pub st_uid: uid_t,
    pub st_gid: gid_t,
    pub st_rdev: dev_t,
    pub st_atimespec: timespec,
    pub st_mtimespec: timespec,
    pub st_ctimespec: timespec,
    pub st_birthtimespec: timespec,
    pub st_size: off_t,
    pub st_blocks: blkcnt_t,
    pub st_blksize: blksize_t,
    pub st_flags: __uint32_t,
    pub st_gen: __uint32_t,
    pub st_lspare: __int32_t,
    pub st_qspare: [__int64_t; 2usize],
}
#[test]
fn bindgen_test_layout_stat() {
    assert_eq!(
        ::std::mem::size_of::<stat>(),
        144usize,
        concat!("Size of: ", stringify!(stat))
    );
    assert_eq!(
        ::std::mem::align_of::<stat>(),
        8usize,
        concat!("Alignment of ", stringify!(stat))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat>())).st_dev as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(stat),
            "::",
            stringify!(st_dev)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat>())).st_mode as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(stat),
            "::",
            stringify!(st_mode)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat>())).st_nlink as *const _ as usize },
        6usize,
        concat!(
            "Offset of field: ",
            stringify!(stat),
            "::",
            stringify!(st_nlink)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat>())).st_ino as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(stat),
            "::",
            stringify!(st_ino)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat>())).st_uid as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(stat),
            "::",
            stringify!(st_uid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat>())).st_gid as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(stat),
            "::",
            stringify!(st_gid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat>())).st_rdev as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(stat),
            "::",
            stringify!(st_rdev)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat>())).st_atimespec as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(stat),
            "::",
            stringify!(st_atimespec)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat>())).st_mtimespec as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(stat),
            "::",
            stringify!(st_mtimespec)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat>())).st_ctimespec as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(stat),
            "::",
            stringify!(st_ctimespec)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat>())).st_birthtimespec as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(stat),
            "::",
            stringify!(st_birthtimespec)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat>())).st_size as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(stat),
            "::",
            stringify!(st_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat>())).st_blocks as *const _ as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(stat),
            "::",
            stringify!(st_blocks)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat>())).st_blksize as *const _ as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(stat),
            "::",
            stringify!(st_blksize)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat>())).st_flags as *const _ as usize },
        116usize,
        concat!(
            "Offset of field: ",
            stringify!(stat),
            "::",
            stringify!(st_flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat>())).st_gen as *const _ as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(stat),
            "::",
            stringify!(st_gen)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat>())).st_lspare as *const _ as usize },
        124usize,
        concat!(
            "Offset of field: ",
            stringify!(stat),
            "::",
            stringify!(st_lspare)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat>())).st_qspare as *const _ as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(stat),
            "::",
            stringify!(st_qspare)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct stat64 {
    pub st_dev: dev_t,
    pub st_mode: mode_t,
    pub st_nlink: nlink_t,
    pub st_ino: __darwin_ino64_t,
    pub st_uid: uid_t,
    pub st_gid: gid_t,
    pub st_rdev: dev_t,
    pub st_atimespec: timespec,
    pub st_mtimespec: timespec,
    pub st_ctimespec: timespec,
    pub st_birthtimespec: timespec,
    pub st_size: off_t,
    pub st_blocks: blkcnt_t,
    pub st_blksize: blksize_t,
    pub st_flags: __uint32_t,
    pub st_gen: __uint32_t,
    pub st_lspare: __int32_t,
    pub st_qspare: [__int64_t; 2usize],
}
#[test]
fn bindgen_test_layout_stat64() {
    assert_eq!(
        ::std::mem::size_of::<stat64>(),
        144usize,
        concat!("Size of: ", stringify!(stat64))
    );
    assert_eq!(
        ::std::mem::align_of::<stat64>(),
        8usize,
        concat!("Alignment of ", stringify!(stat64))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat64>())).st_dev as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(stat64),
            "::",
            stringify!(st_dev)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat64>())).st_mode as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(stat64),
            "::",
            stringify!(st_mode)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat64>())).st_nlink as *const _ as usize },
        6usize,
        concat!(
            "Offset of field: ",
            stringify!(stat64),
            "::",
            stringify!(st_nlink)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat64>())).st_ino as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(stat64),
            "::",
            stringify!(st_ino)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat64>())).st_uid as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(stat64),
            "::",
            stringify!(st_uid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat64>())).st_gid as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(stat64),
            "::",
            stringify!(st_gid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat64>())).st_rdev as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(stat64),
            "::",
            stringify!(st_rdev)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat64>())).st_atimespec as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(stat64),
            "::",
            stringify!(st_atimespec)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat64>())).st_mtimespec as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(stat64),
            "::",
            stringify!(st_mtimespec)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat64>())).st_ctimespec as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(stat64),
            "::",
            stringify!(st_ctimespec)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat64>())).st_birthtimespec as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(stat64),
            "::",
            stringify!(st_birthtimespec)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat64>())).st_size as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(stat64),
            "::",
            stringify!(st_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat64>())).st_blocks as *const _ as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(stat64),
            "::",
            stringify!(st_blocks)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat64>())).st_blksize as *const _ as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(stat64),
            "::",
            stringify!(st_blksize)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat64>())).st_flags as *const _ as usize },
        116usize,
        concat!(
            "Offset of field: ",
            stringify!(stat64),
            "::",
            stringify!(st_flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat64>())).st_gen as *const _ as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(stat64),
            "::",
            stringify!(st_gen)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat64>())).st_lspare as *const _ as usize },
        124usize,
        concat!(
            "Offset of field: ",
            stringify!(stat64),
            "::",
            stringify!(st_lspare)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat64>())).st_qspare as *const _ as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(stat64),
            "::",
            stringify!(st_qspare)
        )
    );
}
extern "C" {
    pub fn chmod(arg1: *const ::std::os::raw::c_char, arg2: mode_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fchmod(arg1: ::std::os::raw::c_int, arg2: mode_t) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}_fstat$INODE64"]
    pub fn fstat(arg1: ::std::os::raw::c_int, arg2: *mut stat) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}_lstat$INODE64"]
    pub fn lstat(arg1: *const ::std::os::raw::c_char, arg2: *mut stat) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mkdir(arg1: *const ::std::os::raw::c_char, arg2: mode_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mkfifo(arg1: *const ::std::os::raw::c_char, arg2: mode_t) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}_stat$INODE64"]
    pub fn stat(arg1: *const ::std::os::raw::c_char, arg2: *mut stat) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mknod(
        arg1: *const ::std::os::raw::c_char,
        arg2: mode_t,
        arg3: dev_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn umask(arg1: mode_t) -> mode_t;
}
extern "C" {
    pub fn fchmodat(
        arg1: ::std::os::raw::c_int,
        arg2: *const ::std::os::raw::c_char,
        arg3: mode_t,
        arg4: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}_fstatat$INODE64"]
    pub fn fstatat(
        arg1: ::std::os::raw::c_int,
        arg2: *const ::std::os::raw::c_char,
        arg3: *mut stat,
        arg4: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mkdirat(
        arg1: ::std::os::raw::c_int,
        arg2: *const ::std::os::raw::c_char,
        arg3: mode_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn futimens(__fd: ::std::os::raw::c_int, __times: *const timespec)
        -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn utimensat(
        __fd: ::std::os::raw::c_int,
        __path: *const ::std::os::raw::c_char,
        __times: *const timespec,
        __flag: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _filesec {
    _unused: [u8; 0],
}
pub type filesec_t = *mut _filesec;
extern "C" {
    pub fn chflags(arg1: *const ::std::os::raw::c_char, arg2: __uint32_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn chmodx_np(arg1: *const ::std::os::raw::c_char, arg2: filesec_t)
        -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fchflags(arg1: ::std::os::raw::c_int, arg2: __uint32_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fchmodx_np(arg1: ::std::os::raw::c_int, arg2: filesec_t) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}_fstatx_np$INODE64"]
    pub fn fstatx_np(
        arg1: ::std::os::raw::c_int,
        arg2: *mut stat,
        arg3: filesec_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn lchflags(arg1: *const ::std::os::raw::c_char, arg2: __uint32_t)
        -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn lchmod(arg1: *const ::std::os::raw::c_char, arg2: mode_t) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}_lstatx_np$INODE64"]
    pub fn lstatx_np(
        arg1: *const ::std::os::raw::c_char,
        arg2: *mut stat,
        arg3: filesec_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mkdirx_np(arg1: *const ::std::os::raw::c_char, arg2: filesec_t)
        -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mkfifox_np(
        arg1: *const ::std::os::raw::c_char,
        arg2: filesec_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}_statx_np$INODE64"]
    pub fn statx_np(
        arg1: *const ::std::os::raw::c_char,
        arg2: *mut stat,
        arg3: filesec_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn umaskx_np(arg1: filesec_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fstatx64_np(
        arg1: ::std::os::raw::c_int,
        arg2: *mut stat64,
        arg3: filesec_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn lstatx64_np(
        arg1: *const ::std::os::raw::c_char,
        arg2: *mut stat64,
        arg3: filesec_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn statx64_np(
        arg1: *const ::std::os::raw::c_char,
        arg2: *mut stat64,
        arg3: filesec_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fstat64(arg1: ::std::os::raw::c_int, arg2: *mut stat64) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn lstat64(arg1: *const ::std::os::raw::c_char, arg2: *mut stat64)
        -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn stat64(arg1: *const ::std::os::raw::c_char, arg2: *mut stat64) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getxattr(
        path: *const ::std::os::raw::c_char,
        name: *const ::std::os::raw::c_char,
        value: *mut ::std::os::raw::c_void,
        size: size_t,
        position: u_int32_t,
        options: ::std::os::raw::c_int,
    ) -> ssize_t;
}
extern "C" {
    pub fn fgetxattr(
        fd: ::std::os::raw::c_int,
        name: *const ::std::os::raw::c_char,
        value: *mut ::std::os::raw::c_void,
        size: size_t,
        position: u_int32_t,
        options: ::std::os::raw::c_int,
    ) -> ssize_t;
}
extern "C" {
    pub fn setxattr(
        path: *const ::std::os::raw::c_char,
        name: *const ::std::os::raw::c_char,
        value: *const ::std::os::raw::c_void,
        size: size_t,
        position: u_int32_t,
        options: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fsetxattr(
        fd: ::std::os::raw::c_int,
        name: *const ::std::os::raw::c_char,
        value: *const ::std::os::raw::c_void,
        size: size_t,
        position: u_int32_t,
        options: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn removexattr(
        path: *const ::std::os::raw::c_char,
        name: *const ::std::os::raw::c_char,
        options: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fremovexattr(
        fd: ::std::os::raw::c_int,
        name: *const ::std::os::raw::c_char,
        options: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn listxattr(
        path: *const ::std::os::raw::c_char,
        namebuff: *mut ::std::os::raw::c_char,
        size: size_t,
        options: ::std::os::raw::c_int,
    ) -> ssize_t;
}
extern "C" {
    pub fn flistxattr(
        fd: ::std::os::raw::c_int,
        namebuff: *mut ::std::os::raw::c_char,
        size: size_t,
        options: ::std::os::raw::c_int,
    ) -> ssize_t;
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union guid_t {
    pub g_guid: [::std::os::raw::c_uchar; 16usize],
    pub g_guid_asint: [::std::os::raw::c_uint; 4usize],
    _bindgen_union_align: [u32; 4usize],
}
#[test]
fn bindgen_test_layout_guid_t() {
    assert_eq!(
        ::std::mem::size_of::<guid_t>(),
        16usize,
        concat!("Size of: ", stringify!(guid_t))
    );
    assert_eq!(
        ::std::mem::align_of::<guid_t>(),
        4usize,
        concat!("Alignment of ", stringify!(guid_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<guid_t>())).g_guid as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(guid_t),
            "::",
            stringify!(g_guid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<guid_t>())).g_guid_asint as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(guid_t),
            "::",
            stringify!(g_guid_asint)
        )
    );
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct ntsid_t {
    pub sid_kind: u_int8_t,
    pub sid_authcount: u_int8_t,
    pub sid_authority: [u_int8_t; 6usize],
    pub sid_authorities: [u_int32_t; 16usize],
}
#[test]
fn bindgen_test_layout_ntsid_t() {
    assert_eq!(
        ::std::mem::size_of::<ntsid_t>(),
        72usize,
        concat!("Size of: ", stringify!(ntsid_t))
    );
    assert_eq!(
        ::std::mem::align_of::<ntsid_t>(),
        1usize,
        concat!("Alignment of ", stringify!(ntsid_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ntsid_t>())).sid_kind as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ntsid_t),
            "::",
            stringify!(sid_kind)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ntsid_t>())).sid_authcount as *const _ as usize },
        1usize,
        concat!(
            "Offset of field: ",
            stringify!(ntsid_t),
            "::",
            stringify!(sid_authcount)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ntsid_t>())).sid_authority as *const _ as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(ntsid_t),
            "::",
            stringify!(sid_authority)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ntsid_t>())).sid_authorities as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(ntsid_t),
            "::",
            stringify!(sid_authorities)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct kauth_identity_extlookup {
    pub el_seqno: u_int32_t,
    pub el_result: u_int32_t,
    pub el_flags: u_int32_t,
    pub el_info_pid: __darwin_pid_t,
    pub el_extend: u_int64_t,
    pub el_info_reserved_1: u_int32_t,
    pub el_uid: uid_t,
    pub el_uguid: guid_t,
    pub el_uguid_valid: u_int32_t,
    pub el_usid: ntsid_t,
    pub el_usid_valid: u_int32_t,
    pub el_gid: gid_t,
    pub el_gguid: guid_t,
    pub el_gguid_valid: u_int32_t,
    pub el_gsid: ntsid_t,
    pub el_gsid_valid: u_int32_t,
    pub el_member_valid: u_int32_t,
    pub el_sup_grp_cnt: u_int32_t,
    pub el_sup_groups: [gid_t; 16usize],
}
#[test]
fn bindgen_test_layout_kauth_identity_extlookup() {
    assert_eq!(
        ::std::mem::size_of::<kauth_identity_extlookup>(),
        304usize,
        concat!("Size of: ", stringify!(kauth_identity_extlookup))
    );
    assert_eq!(
        ::std::mem::align_of::<kauth_identity_extlookup>(),
        8usize,
        concat!("Alignment of ", stringify!(kauth_identity_extlookup))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kauth_identity_extlookup>())).el_seqno as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kauth_identity_extlookup),
            "::",
            stringify!(el_seqno)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kauth_identity_extlookup>())).el_result as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(kauth_identity_extlookup),
            "::",
            stringify!(el_result)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kauth_identity_extlookup>())).el_flags as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kauth_identity_extlookup),
            "::",
            stringify!(el_flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kauth_identity_extlookup>())).el_info_pid as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(kauth_identity_extlookup),
            "::",
            stringify!(el_info_pid)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kauth_identity_extlookup>())).el_extend as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(kauth_identity_extlookup),
            "::",
            stringify!(el_extend)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kauth_identity_extlookup>())).el_info_reserved_1 as *const _
                as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(kauth_identity_extlookup),
            "::",
            stringify!(el_info_reserved_1)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kauth_identity_extlookup>())).el_uid as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(kauth_identity_extlookup),
            "::",
            stringify!(el_uid)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kauth_identity_extlookup>())).el_uguid as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(kauth_identity_extlookup),
            "::",
            stringify!(el_uguid)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kauth_identity_extlookup>())).el_uguid_valid as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(kauth_identity_extlookup),
            "::",
            stringify!(el_uguid_valid)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kauth_identity_extlookup>())).el_usid as *const _ as usize
        },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(kauth_identity_extlookup),
            "::",
            stringify!(el_usid)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kauth_identity_extlookup>())).el_usid_valid as *const _ as usize
        },
        124usize,
        concat!(
            "Offset of field: ",
            stringify!(kauth_identity_extlookup),
            "::",
            stringify!(el_usid_valid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kauth_identity_extlookup>())).el_gid as *const _ as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(kauth_identity_extlookup),
            "::",
            stringify!(el_gid)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kauth_identity_extlookup>())).el_gguid as *const _ as usize
        },
        132usize,
        concat!(
            "Offset of field: ",
            stringify!(kauth_identity_extlookup),
            "::",
            stringify!(el_gguid)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kauth_identity_extlookup>())).el_gguid_valid as *const _ as usize
        },
        148usize,
        concat!(
            "Offset of field: ",
            stringify!(kauth_identity_extlookup),
            "::",
            stringify!(el_gguid_valid)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kauth_identity_extlookup>())).el_gsid as *const _ as usize
        },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(kauth_identity_extlookup),
            "::",
            stringify!(el_gsid)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kauth_identity_extlookup>())).el_gsid_valid as *const _ as usize
        },
        224usize,
        concat!(
            "Offset of field: ",
            stringify!(kauth_identity_extlookup),
            "::",
            stringify!(el_gsid_valid)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kauth_identity_extlookup>())).el_member_valid as *const _
                as usize
        },
        228usize,
        concat!(
            "Offset of field: ",
            stringify!(kauth_identity_extlookup),
            "::",
            stringify!(el_member_valid)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kauth_identity_extlookup>())).el_sup_grp_cnt as *const _ as usize
        },
        232usize,
        concat!(
            "Offset of field: ",
            stringify!(kauth_identity_extlookup),
            "::",
            stringify!(el_sup_grp_cnt)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kauth_identity_extlookup>())).el_sup_groups as *const _ as usize
        },
        236usize,
        concat!(
            "Offset of field: ",
            stringify!(kauth_identity_extlookup),
            "::",
            stringify!(el_sup_groups)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct kauth_cache_sizes {
    pub kcs_group_size: u_int32_t,
    pub kcs_id_size: u_int32_t,
}
#[test]
fn bindgen_test_layout_kauth_cache_sizes() {
    assert_eq!(
        ::std::mem::size_of::<kauth_cache_sizes>(),
        8usize,
        concat!("Size of: ", stringify!(kauth_cache_sizes))
    );
    assert_eq!(
        ::std::mem::align_of::<kauth_cache_sizes>(),
        4usize,
        concat!("Alignment of ", stringify!(kauth_cache_sizes))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kauth_cache_sizes>())).kcs_group_size as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kauth_cache_sizes),
            "::",
            stringify!(kcs_group_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kauth_cache_sizes>())).kcs_id_size as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(kauth_cache_sizes),
            "::",
            stringify!(kcs_id_size)
        )
    );
}
pub type kauth_ace_rights_t = u_int32_t;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct kauth_ace {
    pub ace_applicable: guid_t,
    pub ace_flags: u_int32_t,
    pub ace_rights: kauth_ace_rights_t,
}
#[test]
fn bindgen_test_layout_kauth_ace() {
    assert_eq!(
        ::std::mem::size_of::<kauth_ace>(),
        24usize,
        concat!("Size of: ", stringify!(kauth_ace))
    );
    assert_eq!(
        ::std::mem::align_of::<kauth_ace>(),
        4usize,
        concat!("Alignment of ", stringify!(kauth_ace))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kauth_ace>())).ace_applicable as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kauth_ace),
            "::",
            stringify!(ace_applicable)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kauth_ace>())).ace_flags as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(kauth_ace),
            "::",
            stringify!(ace_flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kauth_ace>())).ace_rights as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(kauth_ace),
            "::",
            stringify!(ace_rights)
        )
    );
}
pub type kauth_ace_t = *mut kauth_ace;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct kauth_acl {
    pub acl_entrycount: u_int32_t,
    pub acl_flags: u_int32_t,
    pub acl_ace: [kauth_ace; 1usize],
}
#[test]
fn bindgen_test_layout_kauth_acl() {
    assert_eq!(
        ::std::mem::size_of::<kauth_acl>(),
        32usize,
        concat!("Size of: ", stringify!(kauth_acl))
    );
    assert_eq!(
        ::std::mem::align_of::<kauth_acl>(),
        4usize,
        concat!("Alignment of ", stringify!(kauth_acl))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kauth_acl>())).acl_entrycount as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kauth_acl),
            "::",
            stringify!(acl_entrycount)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kauth_acl>())).acl_flags as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(kauth_acl),
            "::",
            stringify!(acl_flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kauth_acl>())).acl_ace as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kauth_acl),
            "::",
            stringify!(acl_ace)
        )
    );
}
pub type kauth_acl_t = *mut kauth_acl;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct kauth_filesec {
    pub fsec_magic: u_int32_t,
    pub fsec_owner: guid_t,
    pub fsec_group: guid_t,
    pub fsec_acl: kauth_acl,
}
#[test]
fn bindgen_test_layout_kauth_filesec() {
    assert_eq!(
        ::std::mem::size_of::<kauth_filesec>(),
        68usize,
        concat!("Size of: ", stringify!(kauth_filesec))
    );
    assert_eq!(
        ::std::mem::align_of::<kauth_filesec>(),
        4usize,
        concat!("Alignment of ", stringify!(kauth_filesec))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kauth_filesec>())).fsec_magic as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kauth_filesec),
            "::",
            stringify!(fsec_magic)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kauth_filesec>())).fsec_owner as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(kauth_filesec),
            "::",
            stringify!(fsec_owner)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kauth_filesec>())).fsec_group as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(kauth_filesec),
            "::",
            stringify!(fsec_group)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kauth_filesec>())).fsec_acl as *const _ as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(kauth_filesec),
            "::",
            stringify!(fsec_acl)
        )
    );
}
pub type kauth_filesec_t = *mut kauth_filesec;
pub const acl_perm_t_ACL_READ_DATA: acl_perm_t = 2;
pub const acl_perm_t_ACL_LIST_DIRECTORY: acl_perm_t = 2;
pub const acl_perm_t_ACL_WRITE_DATA: acl_perm_t = 4;
pub const acl_perm_t_ACL_ADD_FILE: acl_perm_t = 4;
pub const acl_perm_t_ACL_EXECUTE: acl_perm_t = 8;
pub const acl_perm_t_ACL_SEARCH: acl_perm_t = 8;
pub const acl_perm_t_ACL_DELETE: acl_perm_t = 16;
pub const acl_perm_t_ACL_APPEND_DATA: acl_perm_t = 32;
pub const acl_perm_t_ACL_ADD_SUBDIRECTORY: acl_perm_t = 32;
pub const acl_perm_t_ACL_DELETE_CHILD: acl_perm_t = 64;
pub const acl_perm_t_ACL_READ_ATTRIBUTES: acl_perm_t = 128;
pub const acl_perm_t_ACL_WRITE_ATTRIBUTES: acl_perm_t = 256;
pub const acl_perm_t_ACL_READ_EXTATTRIBUTES: acl_perm_t = 512;
pub const acl_perm_t_ACL_WRITE_EXTATTRIBUTES: acl_perm_t = 1024;
pub const acl_perm_t_ACL_READ_SECURITY: acl_perm_t = 2048;
pub const acl_perm_t_ACL_WRITE_SECURITY: acl_perm_t = 4096;
pub const acl_perm_t_ACL_CHANGE_OWNER: acl_perm_t = 8192;
pub const acl_perm_t_ACL_SYNCHRONIZE: acl_perm_t = 1048576;
pub type acl_perm_t = ::std::os::raw::c_uint;
pub const acl_tag_t_ACL_UNDEFINED_TAG: acl_tag_t = 0;
pub const acl_tag_t_ACL_EXTENDED_ALLOW: acl_tag_t = 1;
pub const acl_tag_t_ACL_EXTENDED_DENY: acl_tag_t = 2;
pub type acl_tag_t = ::std::os::raw::c_uint;
pub const acl_type_t_ACL_TYPE_EXTENDED: acl_type_t = 256;
pub const acl_type_t_ACL_TYPE_ACCESS: acl_type_t = 0;
pub const acl_type_t_ACL_TYPE_DEFAULT: acl_type_t = 1;
pub const acl_type_t_ACL_TYPE_AFS: acl_type_t = 2;
pub const acl_type_t_ACL_TYPE_CODA: acl_type_t = 3;
pub const acl_type_t_ACL_TYPE_NTFS: acl_type_t = 4;
pub const acl_type_t_ACL_TYPE_NWFS: acl_type_t = 5;
pub type acl_type_t = ::std::os::raw::c_uint;
pub const acl_entry_id_t_ACL_FIRST_ENTRY: acl_entry_id_t = 0;
pub const acl_entry_id_t_ACL_NEXT_ENTRY: acl_entry_id_t = -1;
pub const acl_entry_id_t_ACL_LAST_ENTRY: acl_entry_id_t = -2;
pub type acl_entry_id_t = ::std::os::raw::c_int;
pub const acl_flag_t_ACL_FLAG_DEFER_INHERIT: acl_flag_t = 1;
pub const acl_flag_t_ACL_FLAG_NO_INHERIT: acl_flag_t = 131072;
pub const acl_flag_t_ACL_ENTRY_INHERITED: acl_flag_t = 16;
pub const acl_flag_t_ACL_ENTRY_FILE_INHERIT: acl_flag_t = 32;
pub const acl_flag_t_ACL_ENTRY_DIRECTORY_INHERIT: acl_flag_t = 64;
pub const acl_flag_t_ACL_ENTRY_LIMIT_INHERIT: acl_flag_t = 128;
pub const acl_flag_t_ACL_ENTRY_ONLY_INHERIT: acl_flag_t = 256;
pub type acl_flag_t = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _acl {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _acl_entry {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _acl_permset {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _acl_flagset {
    _unused: [u8; 0],
}
pub type acl_t = *mut _acl;
pub type acl_entry_t = *mut _acl_entry;
pub type acl_permset_t = *mut _acl_permset;
pub type acl_flagset_t = *mut _acl_flagset;
pub type acl_permset_mask_t = u_int64_t;
extern "C" {
    pub fn acl_dup(acl: acl_t) -> acl_t;
}
extern "C" {
    pub fn acl_free(obj_p: *mut ::std::os::raw::c_void) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn acl_init(count: ::std::os::raw::c_int) -> acl_t;
}
extern "C" {
    pub fn acl_copy_entry(dest_d: acl_entry_t, src_d: acl_entry_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn acl_create_entry(acl_p: *mut acl_t, entry_p: *mut acl_entry_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn acl_create_entry_np(
        acl_p: *mut acl_t,
        entry_p: *mut acl_entry_t,
        entry_index: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn acl_delete_entry(acl: acl_t, entry_d: acl_entry_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn acl_get_entry(
        acl: acl_t,
        entry_id: ::std::os::raw::c_int,
        entry_p: *mut acl_entry_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn acl_valid(acl: acl_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn acl_valid_fd_np(
        fd: ::std::os::raw::c_int,
        type_: acl_type_t,
        acl: acl_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn acl_valid_file_np(
        path: *const ::std::os::raw::c_char,
        type_: acl_type_t,
        acl: acl_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn acl_valid_link_np(
        path: *const ::std::os::raw::c_char,
        type_: acl_type_t,
        acl: acl_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn acl_add_perm(permset_d: acl_permset_t, perm: acl_perm_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn acl_calc_mask(acl_p: *mut acl_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn acl_clear_perms(permset_d: acl_permset_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn acl_delete_perm(permset_d: acl_permset_t, perm: acl_perm_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn acl_get_perm_np(permset_d: acl_permset_t, perm: acl_perm_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn acl_get_permset(
        entry_d: acl_entry_t,
        permset_p: *mut acl_permset_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn acl_set_permset(entry_d: acl_entry_t, permset_d: acl_permset_t)
        -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn acl_maximal_permset_mask_np(mask_p: *mut acl_permset_mask_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn acl_get_permset_mask_np(
        entry_d: acl_entry_t,
        mask_p: *mut acl_permset_mask_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn acl_set_permset_mask_np(
        entry_d: acl_entry_t,
        mask: acl_permset_mask_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn acl_add_flag_np(flagset_d: acl_flagset_t, flag: acl_flag_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn acl_clear_flags_np(flagset_d: acl_flagset_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn acl_delete_flag_np(flagset_d: acl_flagset_t, flag: acl_flag_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn acl_get_flag_np(flagset_d: acl_flagset_t, flag: acl_flag_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn acl_get_flagset_np(
        obj_p: *mut ::std::os::raw::c_void,
        flagset_p: *mut acl_flagset_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn acl_set_flagset_np(
        obj_p: *mut ::std::os::raw::c_void,
        flagset_d: acl_flagset_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn acl_get_qualifier(entry_d: acl_entry_t) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn acl_get_tag_type(
        entry_d: acl_entry_t,
        tag_type_p: *mut acl_tag_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn acl_set_qualifier(
        entry_d: acl_entry_t,
        tag_qualifier_p: *const ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn acl_set_tag_type(entry_d: acl_entry_t, tag_type: acl_tag_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn acl_delete_def_file(path_p: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn acl_get_fd(fd: ::std::os::raw::c_int) -> acl_t;
}
extern "C" {
    pub fn acl_get_fd_np(fd: ::std::os::raw::c_int, type_: acl_type_t) -> acl_t;
}
extern "C" {
    pub fn acl_get_file(path_p: *const ::std::os::raw::c_char, type_: acl_type_t) -> acl_t;
}
extern "C" {
    pub fn acl_get_link_np(path_p: *const ::std::os::raw::c_char, type_: acl_type_t) -> acl_t;
}
extern "C" {
    pub fn acl_set_fd(fd: ::std::os::raw::c_int, acl: acl_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn acl_set_fd_np(
        fd: ::std::os::raw::c_int,
        acl: acl_t,
        acl_type: acl_type_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn acl_set_file(
        path_p: *const ::std::os::raw::c_char,
        type_: acl_type_t,
        acl: acl_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn acl_set_link_np(
        path_p: *const ::std::os::raw::c_char,
        type_: acl_type_t,
        acl: acl_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn acl_copy_ext(buf_p: *mut ::std::os::raw::c_void, acl: acl_t, size: ssize_t) -> ssize_t;
}
extern "C" {
    pub fn acl_copy_ext_native(
        buf_p: *mut ::std::os::raw::c_void,
        acl: acl_t,
        size: ssize_t,
    ) -> ssize_t;
}
extern "C" {
    pub fn acl_copy_int(buf_p: *const ::std::os::raw::c_void) -> acl_t;
}
extern "C" {
    pub fn acl_copy_int_native(buf_p: *const ::std::os::raw::c_void) -> acl_t;
}
extern "C" {
    pub fn acl_from_text(buf_p: *const ::std::os::raw::c_char) -> acl_t;
}
extern "C" {
    pub fn acl_size(acl: acl_t) -> ssize_t;
}
extern "C" {
    pub fn acl_to_text(acl: acl_t, len_p: *mut ssize_t) -> *mut ::std::os::raw::c_char;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct es_file_t {
    pub path: es_string_token_t,
    pub path_truncated: bool,
    pub stat: stat,
}
#[test]
fn bindgen_test_layout_es_file_t() {
    assert_eq!(
        ::std::mem::size_of::<es_file_t>(),
        168usize,
        concat!("Size of: ", stringify!(es_file_t))
    );
    assert_eq!(
        ::std::mem::align_of::<es_file_t>(),
        8usize,
        concat!("Alignment of ", stringify!(es_file_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_file_t>())).path as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_file_t),
            "::",
            stringify!(path)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_file_t>())).path_truncated as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(es_file_t),
            "::",
            stringify!(path_truncated)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_file_t>())).stat as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(es_file_t),
            "::",
            stringify!(stat)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct es_process_t {
    pub audit_token: audit_token_t,
    pub ppid: pid_t,
    pub original_ppid: pid_t,
    pub group_id: pid_t,
    pub session_id: pid_t,
    pub codesigning_flags: u32,
    pub is_platform_binary: bool,
    pub is_es_client: bool,
    pub cdhash: [u8; 20usize],
    pub signing_id: es_string_token_t,
    pub team_id: es_string_token_t,
    pub executable: *mut es_file_t,
    pub tty: *mut es_file_t,
    pub start_time: timeval,
}
#[test]
fn bindgen_test_layout_es_process_t() {
    assert_eq!(
        ::std::mem::size_of::<es_process_t>(),
        144usize,
        concat!("Size of: ", stringify!(es_process_t))
    );
    assert_eq!(
        ::std::mem::align_of::<es_process_t>(),
        8usize,
        concat!("Alignment of ", stringify!(es_process_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_process_t>())).audit_token as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_process_t),
            "::",
            stringify!(audit_token)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_process_t>())).ppid as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(es_process_t),
            "::",
            stringify!(ppid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_process_t>())).original_ppid as *const _ as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(es_process_t),
            "::",
            stringify!(original_ppid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_process_t>())).group_id as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(es_process_t),
            "::",
            stringify!(group_id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_process_t>())).session_id as *const _ as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(es_process_t),
            "::",
            stringify!(session_id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_process_t>())).codesigning_flags as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(es_process_t),
            "::",
            stringify!(codesigning_flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_process_t>())).is_platform_binary as *const _ as usize },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(es_process_t),
            "::",
            stringify!(is_platform_binary)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_process_t>())).is_es_client as *const _ as usize },
        53usize,
        concat!(
            "Offset of field: ",
            stringify!(es_process_t),
            "::",
            stringify!(is_es_client)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_process_t>())).cdhash as *const _ as usize },
        54usize,
        concat!(
            "Offset of field: ",
            stringify!(es_process_t),
            "::",
            stringify!(cdhash)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_process_t>())).signing_id as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(es_process_t),
            "::",
            stringify!(signing_id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_process_t>())).team_id as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(es_process_t),
            "::",
            stringify!(team_id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_process_t>())).executable as *const _ as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(es_process_t),
            "::",
            stringify!(executable)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_process_t>())).tty as *const _ as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(es_process_t),
            "::",
            stringify!(tty)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_process_t>())).start_time as *const _ as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(es_process_t),
            "::",
            stringify!(start_time)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct es_thread_state_t {
    pub flavor: ::std::os::raw::c_int,
    pub state: es_token_t,
}
#[test]
fn bindgen_test_layout_es_thread_state_t() {
    assert_eq!(
        ::std::mem::size_of::<es_thread_state_t>(),
        24usize,
        concat!("Size of: ", stringify!(es_thread_state_t))
    );
    assert_eq!(
        ::std::mem::align_of::<es_thread_state_t>(),
        8usize,
        concat!("Alignment of ", stringify!(es_thread_state_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_thread_state_t>())).flavor as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_thread_state_t),
            "::",
            stringify!(flavor)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_thread_state_t>())).state as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(es_thread_state_t),
            "::",
            stringify!(state)
        )
    );
}
pub type es_statfs_t = statfs;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct es_fd_t {
    pub fd: i32,
    pub fdtype: u32,
    pub __bindgen_anon_1: es_fd_t__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union es_fd_t__bindgen_ty_1 {
    pub pipe: es_fd_t__bindgen_ty_1__bindgen_ty_1,
    _bindgen_union_align: u64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct es_fd_t__bindgen_ty_1__bindgen_ty_1 {
    pub pipe_id: u64,
}
#[test]
fn bindgen_test_layout_es_fd_t__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<es_fd_t__bindgen_ty_1__bindgen_ty_1>(),
        8usize,
        concat!("Size of: ", stringify!(es_fd_t__bindgen_ty_1__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<es_fd_t__bindgen_ty_1__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(es_fd_t__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<es_fd_t__bindgen_ty_1__bindgen_ty_1>())).pipe_id as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_fd_t__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(pipe_id)
        )
    );
}
#[test]
fn bindgen_test_layout_es_fd_t__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<es_fd_t__bindgen_ty_1>(),
        8usize,
        concat!("Size of: ", stringify!(es_fd_t__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<es_fd_t__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(es_fd_t__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_fd_t__bindgen_ty_1>())).pipe as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_fd_t__bindgen_ty_1),
            "::",
            stringify!(pipe)
        )
    );
}
#[test]
fn bindgen_test_layout_es_fd_t() {
    assert_eq!(
        ::std::mem::size_of::<es_fd_t>(),
        16usize,
        concat!("Size of: ", stringify!(es_fd_t))
    );
    assert_eq!(
        ::std::mem::align_of::<es_fd_t>(),
        8usize,
        concat!("Alignment of ", stringify!(es_fd_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_fd_t>())).fd as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_fd_t),
            "::",
            stringify!(fd)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_fd_t>())).fdtype as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(es_fd_t),
            "::",
            stringify!(fdtype)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct es_event_exec_t {
    pub target: *mut es_process_t,
    pub args: es_token_t,
    pub __bindgen_anon_1: es_event_exec_t__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union es_event_exec_t__bindgen_ty_1 {
    pub reserved: [u8; 64usize],
    pub __bindgen_anon_1: es_event_exec_t__bindgen_ty_1__bindgen_ty_1,
    _bindgen_union_align: [u64; 8usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct es_event_exec_t__bindgen_ty_1__bindgen_ty_1 {
    pub script: *mut es_file_t,
    pub cwd: *mut es_file_t,
    pub last_fd: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_es_event_exec_t__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<es_event_exec_t__bindgen_ty_1__bindgen_ty_1>(),
        24usize,
        concat!(
            "Size of: ",
            stringify!(es_event_exec_t__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<es_event_exec_t__bindgen_ty_1__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(es_event_exec_t__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<es_event_exec_t__bindgen_ty_1__bindgen_ty_1>())).script
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_exec_t__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(script)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<es_event_exec_t__bindgen_ty_1__bindgen_ty_1>())).cwd as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_exec_t__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(cwd)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<es_event_exec_t__bindgen_ty_1__bindgen_ty_1>())).last_fd
                as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_exec_t__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(last_fd)
        )
    );
}
#[test]
fn bindgen_test_layout_es_event_exec_t__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<es_event_exec_t__bindgen_ty_1>(),
        64usize,
        concat!("Size of: ", stringify!(es_event_exec_t__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<es_event_exec_t__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(es_event_exec_t__bindgen_ty_1))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<es_event_exec_t__bindgen_ty_1>())).reserved as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_exec_t__bindgen_ty_1),
            "::",
            stringify!(reserved)
        )
    );
}
#[test]
fn bindgen_test_layout_es_event_exec_t() {
    assert_eq!(
        ::std::mem::size_of::<es_event_exec_t>(),
        88usize,
        concat!("Size of: ", stringify!(es_event_exec_t))
    );
    assert_eq!(
        ::std::mem::align_of::<es_event_exec_t>(),
        8usize,
        concat!("Alignment of ", stringify!(es_event_exec_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_exec_t>())).target as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_exec_t),
            "::",
            stringify!(target)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_exec_t>())).args as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_exec_t),
            "::",
            stringify!(args)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct es_event_open_t {
    pub fflag: i32,
    pub file: *mut es_file_t,
    pub reserved: [u8; 64usize],
}
#[test]
fn bindgen_test_layout_es_event_open_t() {
    assert_eq!(
        ::std::mem::size_of::<es_event_open_t>(),
        80usize,
        concat!("Size of: ", stringify!(es_event_open_t))
    );
    assert_eq!(
        ::std::mem::align_of::<es_event_open_t>(),
        8usize,
        concat!("Alignment of ", stringify!(es_event_open_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_open_t>())).fflag as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_open_t),
            "::",
            stringify!(fflag)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_open_t>())).file as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_open_t),
            "::",
            stringify!(file)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_open_t>())).reserved as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_open_t),
            "::",
            stringify!(reserved)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct es_event_kextload_t {
    pub identifier: es_string_token_t,
    pub reserved: [u8; 64usize],
}
#[test]
fn bindgen_test_layout_es_event_kextload_t() {
    assert_eq!(
        ::std::mem::size_of::<es_event_kextload_t>(),
        80usize,
        concat!("Size of: ", stringify!(es_event_kextload_t))
    );
    assert_eq!(
        ::std::mem::align_of::<es_event_kextload_t>(),
        8usize,
        concat!("Alignment of ", stringify!(es_event_kextload_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_kextload_t>())).identifier as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_kextload_t),
            "::",
            stringify!(identifier)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_kextload_t>())).reserved as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_kextload_t),
            "::",
            stringify!(reserved)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct es_event_kextunload_t {
    pub identifier: es_string_token_t,
    pub reserved: [u8; 64usize],
}
#[test]
fn bindgen_test_layout_es_event_kextunload_t() {
    assert_eq!(
        ::std::mem::size_of::<es_event_kextunload_t>(),
        80usize,
        concat!("Size of: ", stringify!(es_event_kextunload_t))
    );
    assert_eq!(
        ::std::mem::align_of::<es_event_kextunload_t>(),
        8usize,
        concat!("Alignment of ", stringify!(es_event_kextunload_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<es_event_kextunload_t>())).identifier as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_kextunload_t),
            "::",
            stringify!(identifier)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_kextunload_t>())).reserved as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_kextunload_t),
            "::",
            stringify!(reserved)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct es_event_unlink_t {
    pub target: *mut es_file_t,
    pub parent_dir: *mut es_file_t,
    pub reserved: [u8; 64usize],
}
#[test]
fn bindgen_test_layout_es_event_unlink_t() {
    assert_eq!(
        ::std::mem::size_of::<es_event_unlink_t>(),
        80usize,
        concat!("Size of: ", stringify!(es_event_unlink_t))
    );
    assert_eq!(
        ::std::mem::align_of::<es_event_unlink_t>(),
        8usize,
        concat!("Alignment of ", stringify!(es_event_unlink_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_unlink_t>())).target as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_unlink_t),
            "::",
            stringify!(target)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_unlink_t>())).parent_dir as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_unlink_t),
            "::",
            stringify!(parent_dir)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_unlink_t>())).reserved as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_unlink_t),
            "::",
            stringify!(reserved)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct es_event_mmap_t {
    pub protection: i32,
    pub max_protection: i32,
    pub flags: i32,
    pub file_pos: u64,
    pub source: *mut es_file_t,
    pub reserved: [u8; 64usize],
}
#[test]
fn bindgen_test_layout_es_event_mmap_t() {
    assert_eq!(
        ::std::mem::size_of::<es_event_mmap_t>(),
        96usize,
        concat!("Size of: ", stringify!(es_event_mmap_t))
    );
    assert_eq!(
        ::std::mem::align_of::<es_event_mmap_t>(),
        8usize,
        concat!("Alignment of ", stringify!(es_event_mmap_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_mmap_t>())).protection as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_mmap_t),
            "::",
            stringify!(protection)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_mmap_t>())).max_protection as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_mmap_t),
            "::",
            stringify!(max_protection)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_mmap_t>())).flags as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_mmap_t),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_mmap_t>())).file_pos as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_mmap_t),
            "::",
            stringify!(file_pos)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_mmap_t>())).source as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_mmap_t),
            "::",
            stringify!(source)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_mmap_t>())).reserved as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_mmap_t),
            "::",
            stringify!(reserved)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct es_event_link_t {
    pub source: *mut es_file_t,
    pub target_dir: *mut es_file_t,
    pub target_filename: es_string_token_t,
    pub reserved: [u8; 64usize],
}
#[test]
fn bindgen_test_layout_es_event_link_t() {
    assert_eq!(
        ::std::mem::size_of::<es_event_link_t>(),
        96usize,
        concat!("Size of: ", stringify!(es_event_link_t))
    );
    assert_eq!(
        ::std::mem::align_of::<es_event_link_t>(),
        8usize,
        concat!("Alignment of ", stringify!(es_event_link_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_link_t>())).source as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_link_t),
            "::",
            stringify!(source)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_link_t>())).target_dir as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_link_t),
            "::",
            stringify!(target_dir)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_link_t>())).target_filename as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_link_t),
            "::",
            stringify!(target_filename)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_link_t>())).reserved as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_link_t),
            "::",
            stringify!(reserved)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct es_event_mount_t {
    pub statfs: *mut es_statfs_t,
    pub reserved: [u8; 64usize],
}
#[test]
fn bindgen_test_layout_es_event_mount_t() {
    assert_eq!(
        ::std::mem::size_of::<es_event_mount_t>(),
        72usize,
        concat!("Size of: ", stringify!(es_event_mount_t))
    );
    assert_eq!(
        ::std::mem::align_of::<es_event_mount_t>(),
        8usize,
        concat!("Alignment of ", stringify!(es_event_mount_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_mount_t>())).statfs as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_mount_t),
            "::",
            stringify!(statfs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_mount_t>())).reserved as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_mount_t),
            "::",
            stringify!(reserved)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct es_event_unmount_t {
    pub statfs: *mut es_statfs_t,
    pub reserved: [u8; 64usize],
}
#[test]
fn bindgen_test_layout_es_event_unmount_t() {
    assert_eq!(
        ::std::mem::size_of::<es_event_unmount_t>(),
        72usize,
        concat!("Size of: ", stringify!(es_event_unmount_t))
    );
    assert_eq!(
        ::std::mem::align_of::<es_event_unmount_t>(),
        8usize,
        concat!("Alignment of ", stringify!(es_event_unmount_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_unmount_t>())).statfs as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_unmount_t),
            "::",
            stringify!(statfs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_unmount_t>())).reserved as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_unmount_t),
            "::",
            stringify!(reserved)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct es_event_remount_t {
    pub statfs: *mut es_statfs_t,
    pub reserved: [u8; 64usize],
}
#[test]
fn bindgen_test_layout_es_event_remount_t() {
    assert_eq!(
        ::std::mem::size_of::<es_event_remount_t>(),
        72usize,
        concat!("Size of: ", stringify!(es_event_remount_t))
    );
    assert_eq!(
        ::std::mem::align_of::<es_event_remount_t>(),
        8usize,
        concat!("Alignment of ", stringify!(es_event_remount_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_remount_t>())).statfs as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_remount_t),
            "::",
            stringify!(statfs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_remount_t>())).reserved as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_remount_t),
            "::",
            stringify!(reserved)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct es_event_fork_t {
    pub child: *mut es_process_t,
    pub reserved: [u8; 64usize],
}
#[test]
fn bindgen_test_layout_es_event_fork_t() {
    assert_eq!(
        ::std::mem::size_of::<es_event_fork_t>(),
        72usize,
        concat!("Size of: ", stringify!(es_event_fork_t))
    );
    assert_eq!(
        ::std::mem::align_of::<es_event_fork_t>(),
        8usize,
        concat!("Alignment of ", stringify!(es_event_fork_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_fork_t>())).child as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_fork_t),
            "::",
            stringify!(child)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_fork_t>())).reserved as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_fork_t),
            "::",
            stringify!(reserved)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct es_event_mprotect_t {
    pub protection: i32,
    pub address: user_addr_t,
    pub size: user_size_t,
    pub reserved: [u8; 64usize],
}
#[test]
fn bindgen_test_layout_es_event_mprotect_t() {
    assert_eq!(
        ::std::mem::size_of::<es_event_mprotect_t>(),
        88usize,
        concat!("Size of: ", stringify!(es_event_mprotect_t))
    );
    assert_eq!(
        ::std::mem::align_of::<es_event_mprotect_t>(),
        8usize,
        concat!("Alignment of ", stringify!(es_event_mprotect_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_mprotect_t>())).protection as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_mprotect_t),
            "::",
            stringify!(protection)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_mprotect_t>())).address as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_mprotect_t),
            "::",
            stringify!(address)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_mprotect_t>())).size as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_mprotect_t),
            "::",
            stringify!(size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_mprotect_t>())).reserved as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_mprotect_t),
            "::",
            stringify!(reserved)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct es_event_signal_t {
    pub sig: ::std::os::raw::c_int,
    pub target: *mut es_process_t,
    pub reserved: [u8; 64usize],
}
#[test]
fn bindgen_test_layout_es_event_signal_t() {
    assert_eq!(
        ::std::mem::size_of::<es_event_signal_t>(),
        80usize,
        concat!("Size of: ", stringify!(es_event_signal_t))
    );
    assert_eq!(
        ::std::mem::align_of::<es_event_signal_t>(),
        8usize,
        concat!("Alignment of ", stringify!(es_event_signal_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_signal_t>())).sig as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_signal_t),
            "::",
            stringify!(sig)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_signal_t>())).target as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_signal_t),
            "::",
            stringify!(target)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_signal_t>())).reserved as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_signal_t),
            "::",
            stringify!(reserved)
        )
    );
}
pub const es_destination_type_t_ES_DESTINATION_TYPE_EXISTING_FILE: es_destination_type_t = 0;
pub const es_destination_type_t_ES_DESTINATION_TYPE_NEW_PATH: es_destination_type_t = 1;
pub type es_destination_type_t = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct es_event_rename_t {
    pub source: *mut es_file_t,
    pub destination_type: es_destination_type_t,
    pub destination: es_event_rename_t__bindgen_ty_1,
    pub reserved: [u8; 64usize],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union es_event_rename_t__bindgen_ty_1 {
    pub existing_file: *mut es_file_t,
    pub new_path: es_event_rename_t__bindgen_ty_1__bindgen_ty_1,
    _bindgen_union_align: [u64; 3usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct es_event_rename_t__bindgen_ty_1__bindgen_ty_1 {
    pub dir: *mut es_file_t,
    pub filename: es_string_token_t,
}
#[test]
fn bindgen_test_layout_es_event_rename_t__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<es_event_rename_t__bindgen_ty_1__bindgen_ty_1>(),
        24usize,
        concat!(
            "Size of: ",
            stringify!(es_event_rename_t__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<es_event_rename_t__bindgen_ty_1__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(es_event_rename_t__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<es_event_rename_t__bindgen_ty_1__bindgen_ty_1>())).dir
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_rename_t__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(dir)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<es_event_rename_t__bindgen_ty_1__bindgen_ty_1>())).filename
                as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_rename_t__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(filename)
        )
    );
}
#[test]
fn bindgen_test_layout_es_event_rename_t__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<es_event_rename_t__bindgen_ty_1>(),
        24usize,
        concat!("Size of: ", stringify!(es_event_rename_t__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<es_event_rename_t__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(es_event_rename_t__bindgen_ty_1))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<es_event_rename_t__bindgen_ty_1>())).existing_file as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_rename_t__bindgen_ty_1),
            "::",
            stringify!(existing_file)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<es_event_rename_t__bindgen_ty_1>())).new_path as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_rename_t__bindgen_ty_1),
            "::",
            stringify!(new_path)
        )
    );
}
#[test]
fn bindgen_test_layout_es_event_rename_t() {
    assert_eq!(
        ::std::mem::size_of::<es_event_rename_t>(),
        104usize,
        concat!("Size of: ", stringify!(es_event_rename_t))
    );
    assert_eq!(
        ::std::mem::align_of::<es_event_rename_t>(),
        8usize,
        concat!("Alignment of ", stringify!(es_event_rename_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_rename_t>())).source as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_rename_t),
            "::",
            stringify!(source)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<es_event_rename_t>())).destination_type as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_rename_t),
            "::",
            stringify!(destination_type)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_rename_t>())).destination as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_rename_t),
            "::",
            stringify!(destination)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_rename_t>())).reserved as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_rename_t),
            "::",
            stringify!(reserved)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct es_event_setextattr_t {
    pub target: *mut es_file_t,
    pub extattr: es_string_token_t,
    pub reserved: [u8; 64usize],
}
#[test]
fn bindgen_test_layout_es_event_setextattr_t() {
    assert_eq!(
        ::std::mem::size_of::<es_event_setextattr_t>(),
        88usize,
        concat!("Size of: ", stringify!(es_event_setextattr_t))
    );
    assert_eq!(
        ::std::mem::align_of::<es_event_setextattr_t>(),
        8usize,
        concat!("Alignment of ", stringify!(es_event_setextattr_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_setextattr_t>())).target as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_setextattr_t),
            "::",
            stringify!(target)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_setextattr_t>())).extattr as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_setextattr_t),
            "::",
            stringify!(extattr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_setextattr_t>())).reserved as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_setextattr_t),
            "::",
            stringify!(reserved)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct es_event_getextattr_t {
    pub target: *mut es_file_t,
    pub extattr: es_string_token_t,
    pub reserved: [u8; 64usize],
}
#[test]
fn bindgen_test_layout_es_event_getextattr_t() {
    assert_eq!(
        ::std::mem::size_of::<es_event_getextattr_t>(),
        88usize,
        concat!("Size of: ", stringify!(es_event_getextattr_t))
    );
    assert_eq!(
        ::std::mem::align_of::<es_event_getextattr_t>(),
        8usize,
        concat!("Alignment of ", stringify!(es_event_getextattr_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_getextattr_t>())).target as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_getextattr_t),
            "::",
            stringify!(target)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_getextattr_t>())).extattr as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_getextattr_t),
            "::",
            stringify!(extattr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_getextattr_t>())).reserved as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_getextattr_t),
            "::",
            stringify!(reserved)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct es_event_deleteextattr_t {
    pub target: *mut es_file_t,
    pub extattr: es_string_token_t,
    pub reserved: [u8; 64usize],
}
#[test]
fn bindgen_test_layout_es_event_deleteextattr_t() {
    assert_eq!(
        ::std::mem::size_of::<es_event_deleteextattr_t>(),
        88usize,
        concat!("Size of: ", stringify!(es_event_deleteextattr_t))
    );
    assert_eq!(
        ::std::mem::align_of::<es_event_deleteextattr_t>(),
        8usize,
        concat!("Alignment of ", stringify!(es_event_deleteextattr_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_deleteextattr_t>())).target as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_deleteextattr_t),
            "::",
            stringify!(target)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<es_event_deleteextattr_t>())).extattr as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_deleteextattr_t),
            "::",
            stringify!(extattr)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<es_event_deleteextattr_t>())).reserved as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_deleteextattr_t),
            "::",
            stringify!(reserved)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct es_event_setmode_t {
    pub mode: mode_t,
    pub target: *mut es_file_t,
    pub reserved: [u8; 64usize],
}
#[test]
fn bindgen_test_layout_es_event_setmode_t() {
    assert_eq!(
        ::std::mem::size_of::<es_event_setmode_t>(),
        80usize,
        concat!("Size of: ", stringify!(es_event_setmode_t))
    );
    assert_eq!(
        ::std::mem::align_of::<es_event_setmode_t>(),
        8usize,
        concat!("Alignment of ", stringify!(es_event_setmode_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_setmode_t>())).mode as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_setmode_t),
            "::",
            stringify!(mode)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_setmode_t>())).target as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_setmode_t),
            "::",
            stringify!(target)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_setmode_t>())).reserved as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_setmode_t),
            "::",
            stringify!(reserved)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct es_event_setflags_t {
    pub flags: u32,
    pub target: *mut es_file_t,
    pub reserved: [u8; 64usize],
}
#[test]
fn bindgen_test_layout_es_event_setflags_t() {
    assert_eq!(
        ::std::mem::size_of::<es_event_setflags_t>(),
        80usize,
        concat!("Size of: ", stringify!(es_event_setflags_t))
    );
    assert_eq!(
        ::std::mem::align_of::<es_event_setflags_t>(),
        8usize,
        concat!("Alignment of ", stringify!(es_event_setflags_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_setflags_t>())).flags as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_setflags_t),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_setflags_t>())).target as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_setflags_t),
            "::",
            stringify!(target)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_setflags_t>())).reserved as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_setflags_t),
            "::",
            stringify!(reserved)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct es_event_setowner_t {
    pub uid: uid_t,
    pub gid: gid_t,
    pub target: *mut es_file_t,
    pub reserved: [u8; 64usize],
}
#[test]
fn bindgen_test_layout_es_event_setowner_t() {
    assert_eq!(
        ::std::mem::size_of::<es_event_setowner_t>(),
        80usize,
        concat!("Size of: ", stringify!(es_event_setowner_t))
    );
    assert_eq!(
        ::std::mem::align_of::<es_event_setowner_t>(),
        8usize,
        concat!("Alignment of ", stringify!(es_event_setowner_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_setowner_t>())).uid as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_setowner_t),
            "::",
            stringify!(uid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_setowner_t>())).gid as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_setowner_t),
            "::",
            stringify!(gid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_setowner_t>())).target as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_setowner_t),
            "::",
            stringify!(target)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_setowner_t>())).reserved as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_setowner_t),
            "::",
            stringify!(reserved)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct es_event_close_t {
    pub modified: bool,
    pub target: *mut es_file_t,
    pub reserved: [u8; 64usize],
}
#[test]
fn bindgen_test_layout_es_event_close_t() {
    assert_eq!(
        ::std::mem::size_of::<es_event_close_t>(),
        80usize,
        concat!("Size of: ", stringify!(es_event_close_t))
    );
    assert_eq!(
        ::std::mem::align_of::<es_event_close_t>(),
        8usize,
        concat!("Alignment of ", stringify!(es_event_close_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_close_t>())).modified as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_close_t),
            "::",
            stringify!(modified)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_close_t>())).target as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_close_t),
            "::",
            stringify!(target)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_close_t>())).reserved as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_close_t),
            "::",
            stringify!(reserved)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct es_event_create_t {
    pub destination_type: es_destination_type_t,
    pub destination: es_event_create_t__bindgen_ty_1,
    pub reserved2: [u8; 16usize],
    pub __bindgen_anon_1: es_event_create_t__bindgen_ty_2,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union es_event_create_t__bindgen_ty_1 {
    pub existing_file: *mut es_file_t,
    pub new_path: es_event_create_t__bindgen_ty_1__bindgen_ty_1,
    _bindgen_union_align: [u64; 4usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct es_event_create_t__bindgen_ty_1__bindgen_ty_1 {
    pub dir: *mut es_file_t,
    pub filename: es_string_token_t,
    pub mode: mode_t,
}
#[test]
fn bindgen_test_layout_es_event_create_t__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<es_event_create_t__bindgen_ty_1__bindgen_ty_1>(),
        32usize,
        concat!(
            "Size of: ",
            stringify!(es_event_create_t__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<es_event_create_t__bindgen_ty_1__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(es_event_create_t__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<es_event_create_t__bindgen_ty_1__bindgen_ty_1>())).dir
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_create_t__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(dir)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<es_event_create_t__bindgen_ty_1__bindgen_ty_1>())).filename
                as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_create_t__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(filename)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<es_event_create_t__bindgen_ty_1__bindgen_ty_1>())).mode
                as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_create_t__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(mode)
        )
    );
}
#[test]
fn bindgen_test_layout_es_event_create_t__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<es_event_create_t__bindgen_ty_1>(),
        32usize,
        concat!("Size of: ", stringify!(es_event_create_t__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<es_event_create_t__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(es_event_create_t__bindgen_ty_1))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<es_event_create_t__bindgen_ty_1>())).existing_file as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_create_t__bindgen_ty_1),
            "::",
            stringify!(existing_file)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<es_event_create_t__bindgen_ty_1>())).new_path as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_create_t__bindgen_ty_1),
            "::",
            stringify!(new_path)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union es_event_create_t__bindgen_ty_2 {
    pub reserved: [u8; 48usize],
    pub __bindgen_anon_1: es_event_create_t__bindgen_ty_2__bindgen_ty_1,
    _bindgen_union_align: [u64; 6usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct es_event_create_t__bindgen_ty_2__bindgen_ty_1 {
    pub acl: acl_t,
}
#[test]
fn bindgen_test_layout_es_event_create_t__bindgen_ty_2__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<es_event_create_t__bindgen_ty_2__bindgen_ty_1>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(es_event_create_t__bindgen_ty_2__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<es_event_create_t__bindgen_ty_2__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(es_event_create_t__bindgen_ty_2__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<es_event_create_t__bindgen_ty_2__bindgen_ty_1>())).acl
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_create_t__bindgen_ty_2__bindgen_ty_1),
            "::",
            stringify!(acl)
        )
    );
}
#[test]
fn bindgen_test_layout_es_event_create_t__bindgen_ty_2() {
    assert_eq!(
        ::std::mem::size_of::<es_event_create_t__bindgen_ty_2>(),
        48usize,
        concat!("Size of: ", stringify!(es_event_create_t__bindgen_ty_2))
    );
    assert_eq!(
        ::std::mem::align_of::<es_event_create_t__bindgen_ty_2>(),
        8usize,
        concat!("Alignment of ", stringify!(es_event_create_t__bindgen_ty_2))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<es_event_create_t__bindgen_ty_2>())).reserved as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_create_t__bindgen_ty_2),
            "::",
            stringify!(reserved)
        )
    );
}
#[test]
fn bindgen_test_layout_es_event_create_t() {
    assert_eq!(
        ::std::mem::size_of::<es_event_create_t>(),
        104usize,
        concat!("Size of: ", stringify!(es_event_create_t))
    );
    assert_eq!(
        ::std::mem::align_of::<es_event_create_t>(),
        8usize,
        concat!("Alignment of ", stringify!(es_event_create_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<es_event_create_t>())).destination_type as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_create_t),
            "::",
            stringify!(destination_type)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_create_t>())).destination as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_create_t),
            "::",
            stringify!(destination)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_create_t>())).reserved2 as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_create_t),
            "::",
            stringify!(reserved2)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct es_event_exit_t {
    pub stat: ::std::os::raw::c_int,
    pub reserved: [u8; 64usize],
}
#[test]
fn bindgen_test_layout_es_event_exit_t() {
    assert_eq!(
        ::std::mem::size_of::<es_event_exit_t>(),
        68usize,
        concat!("Size of: ", stringify!(es_event_exit_t))
    );
    assert_eq!(
        ::std::mem::align_of::<es_event_exit_t>(),
        4usize,
        concat!("Alignment of ", stringify!(es_event_exit_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_exit_t>())).stat as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_exit_t),
            "::",
            stringify!(stat)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_exit_t>())).reserved as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_exit_t),
            "::",
            stringify!(reserved)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct es_event_exchangedata_t {
    pub file1: *mut es_file_t,
    pub file2: *mut es_file_t,
    pub reserved: [u8; 64usize],
}
#[test]
fn bindgen_test_layout_es_event_exchangedata_t() {
    assert_eq!(
        ::std::mem::size_of::<es_event_exchangedata_t>(),
        80usize,
        concat!("Size of: ", stringify!(es_event_exchangedata_t))
    );
    assert_eq!(
        ::std::mem::align_of::<es_event_exchangedata_t>(),
        8usize,
        concat!("Alignment of ", stringify!(es_event_exchangedata_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_exchangedata_t>())).file1 as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_exchangedata_t),
            "::",
            stringify!(file1)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_exchangedata_t>())).file2 as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_exchangedata_t),
            "::",
            stringify!(file2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<es_event_exchangedata_t>())).reserved as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_exchangedata_t),
            "::",
            stringify!(reserved)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct es_event_write_t {
    pub target: *mut es_file_t,
    pub reserved: [u8; 64usize],
}
#[test]
fn bindgen_test_layout_es_event_write_t() {
    assert_eq!(
        ::std::mem::size_of::<es_event_write_t>(),
        72usize,
        concat!("Size of: ", stringify!(es_event_write_t))
    );
    assert_eq!(
        ::std::mem::align_of::<es_event_write_t>(),
        8usize,
        concat!("Alignment of ", stringify!(es_event_write_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_write_t>())).target as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_write_t),
            "::",
            stringify!(target)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_write_t>())).reserved as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_write_t),
            "::",
            stringify!(reserved)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct es_event_truncate_t {
    pub target: *mut es_file_t,
    pub reserved: [u8; 64usize],
}
#[test]
fn bindgen_test_layout_es_event_truncate_t() {
    assert_eq!(
        ::std::mem::size_of::<es_event_truncate_t>(),
        72usize,
        concat!("Size of: ", stringify!(es_event_truncate_t))
    );
    assert_eq!(
        ::std::mem::align_of::<es_event_truncate_t>(),
        8usize,
        concat!("Alignment of ", stringify!(es_event_truncate_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_truncate_t>())).target as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_truncate_t),
            "::",
            stringify!(target)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_truncate_t>())).reserved as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_truncate_t),
            "::",
            stringify!(reserved)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct es_event_chdir_t {
    pub target: *mut es_file_t,
    pub reserved: [u8; 64usize],
}
#[test]
fn bindgen_test_layout_es_event_chdir_t() {
    assert_eq!(
        ::std::mem::size_of::<es_event_chdir_t>(),
        72usize,
        concat!("Size of: ", stringify!(es_event_chdir_t))
    );
    assert_eq!(
        ::std::mem::align_of::<es_event_chdir_t>(),
        8usize,
        concat!("Alignment of ", stringify!(es_event_chdir_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_chdir_t>())).target as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_chdir_t),
            "::",
            stringify!(target)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_chdir_t>())).reserved as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_chdir_t),
            "::",
            stringify!(reserved)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct es_event_stat_t {
    pub target: *mut es_file_t,
    pub reserved: [u8; 64usize],
}
#[test]
fn bindgen_test_layout_es_event_stat_t() {
    assert_eq!(
        ::std::mem::size_of::<es_event_stat_t>(),
        72usize,
        concat!("Size of: ", stringify!(es_event_stat_t))
    );
    assert_eq!(
        ::std::mem::align_of::<es_event_stat_t>(),
        8usize,
        concat!("Alignment of ", stringify!(es_event_stat_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_stat_t>())).target as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_stat_t),
            "::",
            stringify!(target)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_stat_t>())).reserved as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_stat_t),
            "::",
            stringify!(reserved)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct es_event_chroot_t {
    pub target: *mut es_file_t,
    pub reserved: [u8; 64usize],
}
#[test]
fn bindgen_test_layout_es_event_chroot_t() {
    assert_eq!(
        ::std::mem::size_of::<es_event_chroot_t>(),
        72usize,
        concat!("Size of: ", stringify!(es_event_chroot_t))
    );
    assert_eq!(
        ::std::mem::align_of::<es_event_chroot_t>(),
        8usize,
        concat!("Alignment of ", stringify!(es_event_chroot_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_chroot_t>())).target as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_chroot_t),
            "::",
            stringify!(target)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_chroot_t>())).reserved as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_chroot_t),
            "::",
            stringify!(reserved)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct es_event_listextattr_t {
    pub target: *mut es_file_t,
    pub reserved: [u8; 64usize],
}
#[test]
fn bindgen_test_layout_es_event_listextattr_t() {
    assert_eq!(
        ::std::mem::size_of::<es_event_listextattr_t>(),
        72usize,
        concat!("Size of: ", stringify!(es_event_listextattr_t))
    );
    assert_eq!(
        ::std::mem::align_of::<es_event_listextattr_t>(),
        8usize,
        concat!("Alignment of ", stringify!(es_event_listextattr_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_listextattr_t>())).target as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_listextattr_t),
            "::",
            stringify!(target)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_listextattr_t>())).reserved as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_listextattr_t),
            "::",
            stringify!(reserved)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct es_event_iokit_open_t {
    pub user_client_type: u32,
    pub user_client_class: es_string_token_t,
    pub reserved: [u8; 64usize],
}
#[test]
fn bindgen_test_layout_es_event_iokit_open_t() {
    assert_eq!(
        ::std::mem::size_of::<es_event_iokit_open_t>(),
        88usize,
        concat!("Size of: ", stringify!(es_event_iokit_open_t))
    );
    assert_eq!(
        ::std::mem::align_of::<es_event_iokit_open_t>(),
        8usize,
        concat!("Alignment of ", stringify!(es_event_iokit_open_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<es_event_iokit_open_t>())).user_client_type as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_iokit_open_t),
            "::",
            stringify!(user_client_type)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<es_event_iokit_open_t>())).user_client_class as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_iokit_open_t),
            "::",
            stringify!(user_client_class)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_iokit_open_t>())).reserved as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_iokit_open_t),
            "::",
            stringify!(reserved)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct es_event_get_task_t {
    pub target: *mut es_process_t,
    pub reserved: [u8; 64usize],
}
#[test]
fn bindgen_test_layout_es_event_get_task_t() {
    assert_eq!(
        ::std::mem::size_of::<es_event_get_task_t>(),
        72usize,
        concat!("Size of: ", stringify!(es_event_get_task_t))
    );
    assert_eq!(
        ::std::mem::align_of::<es_event_get_task_t>(),
        8usize,
        concat!("Alignment of ", stringify!(es_event_get_task_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_get_task_t>())).target as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_get_task_t),
            "::",
            stringify!(target)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_get_task_t>())).reserved as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_get_task_t),
            "::",
            stringify!(reserved)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct es_event_get_task_name_t {
    pub target: *mut es_process_t,
    pub reserved: [u8; 64usize],
}
#[test]
fn bindgen_test_layout_es_event_get_task_name_t() {
    assert_eq!(
        ::std::mem::size_of::<es_event_get_task_name_t>(),
        72usize,
        concat!("Size of: ", stringify!(es_event_get_task_name_t))
    );
    assert_eq!(
        ::std::mem::align_of::<es_event_get_task_name_t>(),
        8usize,
        concat!("Alignment of ", stringify!(es_event_get_task_name_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_get_task_name_t>())).target as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_get_task_name_t),
            "::",
            stringify!(target)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<es_event_get_task_name_t>())).reserved as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_get_task_name_t),
            "::",
            stringify!(reserved)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct es_event_getattrlist_t {
    pub attrlist: attrlist,
    pub target: *mut es_file_t,
    pub reserved: [u8; 64usize],
}
#[test]
fn bindgen_test_layout_es_event_getattrlist_t() {
    assert_eq!(
        ::std::mem::size_of::<es_event_getattrlist_t>(),
        96usize,
        concat!("Size of: ", stringify!(es_event_getattrlist_t))
    );
    assert_eq!(
        ::std::mem::align_of::<es_event_getattrlist_t>(),
        8usize,
        concat!("Alignment of ", stringify!(es_event_getattrlist_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_getattrlist_t>())).attrlist as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_getattrlist_t),
            "::",
            stringify!(attrlist)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_getattrlist_t>())).target as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_getattrlist_t),
            "::",
            stringify!(target)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_getattrlist_t>())).reserved as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_getattrlist_t),
            "::",
            stringify!(reserved)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct es_event_setattrlist_t {
    pub attrlist: attrlist,
    pub target: *mut es_file_t,
    pub reserved: [u8; 64usize],
}
#[test]
fn bindgen_test_layout_es_event_setattrlist_t() {
    assert_eq!(
        ::std::mem::size_of::<es_event_setattrlist_t>(),
        96usize,
        concat!("Size of: ", stringify!(es_event_setattrlist_t))
    );
    assert_eq!(
        ::std::mem::align_of::<es_event_setattrlist_t>(),
        8usize,
        concat!("Alignment of ", stringify!(es_event_setattrlist_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_setattrlist_t>())).attrlist as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_setattrlist_t),
            "::",
            stringify!(attrlist)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_setattrlist_t>())).target as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_setattrlist_t),
            "::",
            stringify!(target)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_setattrlist_t>())).reserved as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_setattrlist_t),
            "::",
            stringify!(reserved)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct es_event_file_provider_update_t {
    pub source: *mut es_file_t,
    pub target_path: es_string_token_t,
    pub reserved: [u8; 64usize],
}
#[test]
fn bindgen_test_layout_es_event_file_provider_update_t() {
    assert_eq!(
        ::std::mem::size_of::<es_event_file_provider_update_t>(),
        88usize,
        concat!("Size of: ", stringify!(es_event_file_provider_update_t))
    );
    assert_eq!(
        ::std::mem::align_of::<es_event_file_provider_update_t>(),
        8usize,
        concat!("Alignment of ", stringify!(es_event_file_provider_update_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<es_event_file_provider_update_t>())).source as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_file_provider_update_t),
            "::",
            stringify!(source)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<es_event_file_provider_update_t>())).target_path as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_file_provider_update_t),
            "::",
            stringify!(target_path)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<es_event_file_provider_update_t>())).reserved as *const _
                as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_file_provider_update_t),
            "::",
            stringify!(reserved)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct es_event_file_provider_materialize_t {
    pub instigator: *mut es_process_t,
    pub source: *mut es_file_t,
    pub target: *mut es_file_t,
    pub reserved: [u8; 64usize],
}
#[test]
fn bindgen_test_layout_es_event_file_provider_materialize_t() {
    assert_eq!(
        ::std::mem::size_of::<es_event_file_provider_materialize_t>(),
        88usize,
        concat!(
            "Size of: ",
            stringify!(es_event_file_provider_materialize_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<es_event_file_provider_materialize_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(es_event_file_provider_materialize_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<es_event_file_provider_materialize_t>())).instigator as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_file_provider_materialize_t),
            "::",
            stringify!(instigator)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<es_event_file_provider_materialize_t>())).source as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_file_provider_materialize_t),
            "::",
            stringify!(source)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<es_event_file_provider_materialize_t>())).target as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_file_provider_materialize_t),
            "::",
            stringify!(target)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<es_event_file_provider_materialize_t>())).reserved as *const _
                as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_file_provider_materialize_t),
            "::",
            stringify!(reserved)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct es_event_readlink_t {
    pub source: *mut es_file_t,
    pub reserved: [u8; 64usize],
}
#[test]
fn bindgen_test_layout_es_event_readlink_t() {
    assert_eq!(
        ::std::mem::size_of::<es_event_readlink_t>(),
        72usize,
        concat!("Size of: ", stringify!(es_event_readlink_t))
    );
    assert_eq!(
        ::std::mem::align_of::<es_event_readlink_t>(),
        8usize,
        concat!("Alignment of ", stringify!(es_event_readlink_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_readlink_t>())).source as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_readlink_t),
            "::",
            stringify!(source)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_readlink_t>())).reserved as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_readlink_t),
            "::",
            stringify!(reserved)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct es_event_lookup_t {
    pub source_dir: *mut es_file_t,
    pub relative_target: es_string_token_t,
    pub reserved: [u8; 64usize],
}
#[test]
fn bindgen_test_layout_es_event_lookup_t() {
    assert_eq!(
        ::std::mem::size_of::<es_event_lookup_t>(),
        88usize,
        concat!("Size of: ", stringify!(es_event_lookup_t))
    );
    assert_eq!(
        ::std::mem::align_of::<es_event_lookup_t>(),
        8usize,
        concat!("Alignment of ", stringify!(es_event_lookup_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_lookup_t>())).source_dir as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_lookup_t),
            "::",
            stringify!(source_dir)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<es_event_lookup_t>())).relative_target as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_lookup_t),
            "::",
            stringify!(relative_target)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_lookup_t>())).reserved as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_lookup_t),
            "::",
            stringify!(reserved)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct es_event_access_t {
    pub mode: i32,
    pub target: *mut es_file_t,
    pub reserved: [u8; 64usize],
}
#[test]
fn bindgen_test_layout_es_event_access_t() {
    assert_eq!(
        ::std::mem::size_of::<es_event_access_t>(),
        80usize,
        concat!("Size of: ", stringify!(es_event_access_t))
    );
    assert_eq!(
        ::std::mem::align_of::<es_event_access_t>(),
        8usize,
        concat!("Alignment of ", stringify!(es_event_access_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_access_t>())).mode as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_access_t),
            "::",
            stringify!(mode)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_access_t>())).target as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_access_t),
            "::",
            stringify!(target)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_access_t>())).reserved as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_access_t),
            "::",
            stringify!(reserved)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct es_event_utimes_t {
    pub target: *mut es_file_t,
    pub atime: timespec,
    pub mtime: timespec,
    pub reserved: [u8; 64usize],
}
#[test]
fn bindgen_test_layout_es_event_utimes_t() {
    assert_eq!(
        ::std::mem::size_of::<es_event_utimes_t>(),
        104usize,
        concat!("Size of: ", stringify!(es_event_utimes_t))
    );
    assert_eq!(
        ::std::mem::align_of::<es_event_utimes_t>(),
        8usize,
        concat!("Alignment of ", stringify!(es_event_utimes_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_utimes_t>())).target as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_utimes_t),
            "::",
            stringify!(target)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_utimes_t>())).atime as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_utimes_t),
            "::",
            stringify!(atime)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_utimes_t>())).mtime as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_utimes_t),
            "::",
            stringify!(mtime)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_utimes_t>())).reserved as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_utimes_t),
            "::",
            stringify!(reserved)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct es_event_clone_t {
    pub source: *mut es_file_t,
    pub target_dir: *mut es_file_t,
    pub target_name: es_string_token_t,
    pub reserved: [u8; 64usize],
}
#[test]
fn bindgen_test_layout_es_event_clone_t() {
    assert_eq!(
        ::std::mem::size_of::<es_event_clone_t>(),
        96usize,
        concat!("Size of: ", stringify!(es_event_clone_t))
    );
    assert_eq!(
        ::std::mem::align_of::<es_event_clone_t>(),
        8usize,
        concat!("Alignment of ", stringify!(es_event_clone_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_clone_t>())).source as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_clone_t),
            "::",
            stringify!(source)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_clone_t>())).target_dir as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_clone_t),
            "::",
            stringify!(target_dir)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_clone_t>())).target_name as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_clone_t),
            "::",
            stringify!(target_name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_clone_t>())).reserved as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_clone_t),
            "::",
            stringify!(reserved)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct es_event_fcntl_t {
    pub target: *mut es_file_t,
    pub cmd: i32,
    pub reserved: [u8; 64usize],
}
#[test]
fn bindgen_test_layout_es_event_fcntl_t() {
    assert_eq!(
        ::std::mem::size_of::<es_event_fcntl_t>(),
        80usize,
        concat!("Size of: ", stringify!(es_event_fcntl_t))
    );
    assert_eq!(
        ::std::mem::align_of::<es_event_fcntl_t>(),
        8usize,
        concat!("Alignment of ", stringify!(es_event_fcntl_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_fcntl_t>())).target as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_fcntl_t),
            "::",
            stringify!(target)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_fcntl_t>())).cmd as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_fcntl_t),
            "::",
            stringify!(cmd)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_fcntl_t>())).reserved as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_fcntl_t),
            "::",
            stringify!(reserved)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct es_event_readdir_t {
    pub target: *mut es_file_t,
    pub reserved: [u8; 64usize],
}
#[test]
fn bindgen_test_layout_es_event_readdir_t() {
    assert_eq!(
        ::std::mem::size_of::<es_event_readdir_t>(),
        72usize,
        concat!("Size of: ", stringify!(es_event_readdir_t))
    );
    assert_eq!(
        ::std::mem::align_of::<es_event_readdir_t>(),
        8usize,
        concat!("Alignment of ", stringify!(es_event_readdir_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_readdir_t>())).target as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_readdir_t),
            "::",
            stringify!(target)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_readdir_t>())).reserved as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_readdir_t),
            "::",
            stringify!(reserved)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct es_event_fsgetpath_t {
    pub target: *mut es_file_t,
    pub reserved: [u8; 64usize],
}
#[test]
fn bindgen_test_layout_es_event_fsgetpath_t() {
    assert_eq!(
        ::std::mem::size_of::<es_event_fsgetpath_t>(),
        72usize,
        concat!("Size of: ", stringify!(es_event_fsgetpath_t))
    );
    assert_eq!(
        ::std::mem::align_of::<es_event_fsgetpath_t>(),
        8usize,
        concat!("Alignment of ", stringify!(es_event_fsgetpath_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_fsgetpath_t>())).target as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_fsgetpath_t),
            "::",
            stringify!(target)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_fsgetpath_t>())).reserved as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_fsgetpath_t),
            "::",
            stringify!(reserved)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct es_event_settime_t {
    pub reserved: [u8; 64usize],
}
#[test]
fn bindgen_test_layout_es_event_settime_t() {
    assert_eq!(
        ::std::mem::size_of::<es_event_settime_t>(),
        64usize,
        concat!("Size of: ", stringify!(es_event_settime_t))
    );
    assert_eq!(
        ::std::mem::align_of::<es_event_settime_t>(),
        1usize,
        concat!("Alignment of ", stringify!(es_event_settime_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_settime_t>())).reserved as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_settime_t),
            "::",
            stringify!(reserved)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct es_event_dup_t {
    pub target: *mut es_file_t,
    pub reserved: [u8; 64usize],
}
#[test]
fn bindgen_test_layout_es_event_dup_t() {
    assert_eq!(
        ::std::mem::size_of::<es_event_dup_t>(),
        72usize,
        concat!("Size of: ", stringify!(es_event_dup_t))
    );
    assert_eq!(
        ::std::mem::align_of::<es_event_dup_t>(),
        8usize,
        concat!("Alignment of ", stringify!(es_event_dup_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_dup_t>())).target as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_dup_t),
            "::",
            stringify!(target)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_dup_t>())).reserved as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_dup_t),
            "::",
            stringify!(reserved)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct es_event_uipc_bind_t {
    pub dir: *mut es_file_t,
    pub filename: es_string_token_t,
    pub mode: mode_t,
    pub reserved: [u8; 64usize],
}
#[test]
fn bindgen_test_layout_es_event_uipc_bind_t() {
    assert_eq!(
        ::std::mem::size_of::<es_event_uipc_bind_t>(),
        96usize,
        concat!("Size of: ", stringify!(es_event_uipc_bind_t))
    );
    assert_eq!(
        ::std::mem::align_of::<es_event_uipc_bind_t>(),
        8usize,
        concat!("Alignment of ", stringify!(es_event_uipc_bind_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_uipc_bind_t>())).dir as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_uipc_bind_t),
            "::",
            stringify!(dir)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_uipc_bind_t>())).filename as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_uipc_bind_t),
            "::",
            stringify!(filename)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_uipc_bind_t>())).mode as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_uipc_bind_t),
            "::",
            stringify!(mode)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_uipc_bind_t>())).reserved as *const _ as usize },
        26usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_uipc_bind_t),
            "::",
            stringify!(reserved)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct es_event_uipc_connect_t {
    pub file: *mut es_file_t,
    pub domain: ::std::os::raw::c_int,
    pub type_: ::std::os::raw::c_int,
    pub protocol: ::std::os::raw::c_int,
    pub reserved: [u8; 64usize],
}
#[test]
fn bindgen_test_layout_es_event_uipc_connect_t() {
    assert_eq!(
        ::std::mem::size_of::<es_event_uipc_connect_t>(),
        88usize,
        concat!("Size of: ", stringify!(es_event_uipc_connect_t))
    );
    assert_eq!(
        ::std::mem::align_of::<es_event_uipc_connect_t>(),
        8usize,
        concat!("Alignment of ", stringify!(es_event_uipc_connect_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_uipc_connect_t>())).file as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_uipc_connect_t),
            "::",
            stringify!(file)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_uipc_connect_t>())).domain as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_uipc_connect_t),
            "::",
            stringify!(domain)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_uipc_connect_t>())).type_ as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_uipc_connect_t),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<es_event_uipc_connect_t>())).protocol as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_uipc_connect_t),
            "::",
            stringify!(protocol)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<es_event_uipc_connect_t>())).reserved as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_uipc_connect_t),
            "::",
            stringify!(reserved)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct es_event_setacl_t {
    pub target: *mut es_file_t,
    pub set_or_clear: es_set_or_clear_t,
    pub acl: es_event_setacl_t__bindgen_ty_1,
    pub reserved: [u8; 64usize],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union es_event_setacl_t__bindgen_ty_1 {
    pub set: acl_t,
    _bindgen_union_align: u64,
}
#[test]
fn bindgen_test_layout_es_event_setacl_t__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<es_event_setacl_t__bindgen_ty_1>(),
        8usize,
        concat!("Size of: ", stringify!(es_event_setacl_t__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<es_event_setacl_t__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(es_event_setacl_t__bindgen_ty_1))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<es_event_setacl_t__bindgen_ty_1>())).set as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_setacl_t__bindgen_ty_1),
            "::",
            stringify!(set)
        )
    );
}
#[test]
fn bindgen_test_layout_es_event_setacl_t() {
    assert_eq!(
        ::std::mem::size_of::<es_event_setacl_t>(),
        88usize,
        concat!("Size of: ", stringify!(es_event_setacl_t))
    );
    assert_eq!(
        ::std::mem::align_of::<es_event_setacl_t>(),
        8usize,
        concat!("Alignment of ", stringify!(es_event_setacl_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_setacl_t>())).target as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_setacl_t),
            "::",
            stringify!(target)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_setacl_t>())).set_or_clear as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_setacl_t),
            "::",
            stringify!(set_or_clear)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_setacl_t>())).acl as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_setacl_t),
            "::",
            stringify!(acl)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_setacl_t>())).reserved as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_setacl_t),
            "::",
            stringify!(reserved)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct es_event_pty_grant_t {
    pub dev: dev_t,
    pub reserved: [u8; 64usize],
}
#[test]
fn bindgen_test_layout_es_event_pty_grant_t() {
    assert_eq!(
        ::std::mem::size_of::<es_event_pty_grant_t>(),
        68usize,
        concat!("Size of: ", stringify!(es_event_pty_grant_t))
    );
    assert_eq!(
        ::std::mem::align_of::<es_event_pty_grant_t>(),
        4usize,
        concat!("Alignment of ", stringify!(es_event_pty_grant_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_pty_grant_t>())).dev as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_pty_grant_t),
            "::",
            stringify!(dev)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_pty_grant_t>())).reserved as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_pty_grant_t),
            "::",
            stringify!(reserved)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct es_event_pty_close_t {
    pub dev: dev_t,
    pub reserved: [u8; 64usize],
}
#[test]
fn bindgen_test_layout_es_event_pty_close_t() {
    assert_eq!(
        ::std::mem::size_of::<es_event_pty_close_t>(),
        68usize,
        concat!("Size of: ", stringify!(es_event_pty_close_t))
    );
    assert_eq!(
        ::std::mem::align_of::<es_event_pty_close_t>(),
        4usize,
        concat!("Alignment of ", stringify!(es_event_pty_close_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_pty_close_t>())).dev as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_pty_close_t),
            "::",
            stringify!(dev)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_pty_close_t>())).reserved as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_pty_close_t),
            "::",
            stringify!(reserved)
        )
    );
}
pub const es_proc_check_type_t_ES_PROC_CHECK_TYPE_LISTPIDS: es_proc_check_type_t = 1;
pub const es_proc_check_type_t_ES_PROC_CHECK_TYPE_PIDINFO: es_proc_check_type_t = 2;
pub const es_proc_check_type_t_ES_PROC_CHECK_TYPE_PIDFDINFO: es_proc_check_type_t = 3;
pub const es_proc_check_type_t_ES_PROC_CHECK_TYPE_KERNMSGBUF: es_proc_check_type_t = 4;
pub const es_proc_check_type_t_ES_PROC_CHECK_TYPE_SETCONTROL: es_proc_check_type_t = 5;
pub const es_proc_check_type_t_ES_PROC_CHECK_TYPE_PIDFILEPORTINFO: es_proc_check_type_t = 6;
pub const es_proc_check_type_t_ES_PROC_CHECK_TYPE_TERMINATE: es_proc_check_type_t = 7;
pub const es_proc_check_type_t_ES_PROC_CHECK_TYPE_DIRTYCONTROL: es_proc_check_type_t = 8;
pub const es_proc_check_type_t_ES_PROC_CHECK_TYPE_PIDRUSAGE: es_proc_check_type_t = 9;
pub const es_proc_check_type_t_ES_PROC_CHECK_TYPE_UDATA_INFO: es_proc_check_type_t = 14;
pub type es_proc_check_type_t = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct es_event_proc_check_t {
    pub target: *mut es_process_t,
    pub type_: es_proc_check_type_t,
    pub flavor: ::std::os::raw::c_int,
    pub reserved: [u8; 64usize],
}
#[test]
fn bindgen_test_layout_es_event_proc_check_t() {
    assert_eq!(
        ::std::mem::size_of::<es_event_proc_check_t>(),
        80usize,
        concat!("Size of: ", stringify!(es_event_proc_check_t))
    );
    assert_eq!(
        ::std::mem::align_of::<es_event_proc_check_t>(),
        8usize,
        concat!("Alignment of ", stringify!(es_event_proc_check_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_proc_check_t>())).target as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_proc_check_t),
            "::",
            stringify!(target)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_proc_check_t>())).type_ as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_proc_check_t),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_proc_check_t>())).flavor as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_proc_check_t),
            "::",
            stringify!(flavor)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_proc_check_t>())).reserved as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_proc_check_t),
            "::",
            stringify!(reserved)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct es_event_searchfs_t {
    pub attrlist: attrlist,
    pub target: *mut es_file_t,
    pub reserved: [u8; 64usize],
}
#[test]
fn bindgen_test_layout_es_event_searchfs_t() {
    assert_eq!(
        ::std::mem::size_of::<es_event_searchfs_t>(),
        96usize,
        concat!("Size of: ", stringify!(es_event_searchfs_t))
    );
    assert_eq!(
        ::std::mem::align_of::<es_event_searchfs_t>(),
        8usize,
        concat!("Alignment of ", stringify!(es_event_searchfs_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_searchfs_t>())).attrlist as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_searchfs_t),
            "::",
            stringify!(attrlist)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_searchfs_t>())).target as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_searchfs_t),
            "::",
            stringify!(target)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_searchfs_t>())).reserved as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_searchfs_t),
            "::",
            stringify!(reserved)
        )
    );
}
pub const es_proc_suspend_resume_type_t_ES_PROC_SUSPEND_RESUME_TYPE_SUSPEND:
    es_proc_suspend_resume_type_t = 0;
pub const es_proc_suspend_resume_type_t_ES_PROC_SUSPEND_RESUME_TYPE_RESUME:
    es_proc_suspend_resume_type_t = 1;
pub const es_proc_suspend_resume_type_t_ES_PROC_SUSPEND_RESUME_TYPE_SHUTDOWN_SOCKETS:
    es_proc_suspend_resume_type_t = 3;
pub type es_proc_suspend_resume_type_t = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct es_event_proc_suspend_resume_t {
    pub target: *mut es_process_t,
    pub type_: es_proc_suspend_resume_type_t,
    pub reserved: [u8; 64usize],
}
#[test]
fn bindgen_test_layout_es_event_proc_suspend_resume_t() {
    assert_eq!(
        ::std::mem::size_of::<es_event_proc_suspend_resume_t>(),
        80usize,
        concat!("Size of: ", stringify!(es_event_proc_suspend_resume_t))
    );
    assert_eq!(
        ::std::mem::align_of::<es_event_proc_suspend_resume_t>(),
        8usize,
        concat!("Alignment of ", stringify!(es_event_proc_suspend_resume_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<es_event_proc_suspend_resume_t>())).target as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_proc_suspend_resume_t),
            "::",
            stringify!(target)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<es_event_proc_suspend_resume_t>())).type_ as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_proc_suspend_resume_t),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<es_event_proc_suspend_resume_t>())).reserved as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_proc_suspend_resume_t),
            "::",
            stringify!(reserved)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct es_event_cs_invalidated_t {
    pub reserved: [u8; 64usize],
}
#[test]
fn bindgen_test_layout_es_event_cs_invalidated_t() {
    assert_eq!(
        ::std::mem::size_of::<es_event_cs_invalidated_t>(),
        64usize,
        concat!("Size of: ", stringify!(es_event_cs_invalidated_t))
    );
    assert_eq!(
        ::std::mem::align_of::<es_event_cs_invalidated_t>(),
        1usize,
        concat!("Alignment of ", stringify!(es_event_cs_invalidated_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<es_event_cs_invalidated_t>())).reserved as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_cs_invalidated_t),
            "::",
            stringify!(reserved)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct es_event_trace_t {
    pub target: *mut es_process_t,
    pub reserved: [u8; 64usize],
}
#[test]
fn bindgen_test_layout_es_event_trace_t() {
    assert_eq!(
        ::std::mem::size_of::<es_event_trace_t>(),
        72usize,
        concat!("Size of: ", stringify!(es_event_trace_t))
    );
    assert_eq!(
        ::std::mem::align_of::<es_event_trace_t>(),
        8usize,
        concat!("Alignment of ", stringify!(es_event_trace_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_trace_t>())).target as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_trace_t),
            "::",
            stringify!(target)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_event_trace_t>())).reserved as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_trace_t),
            "::",
            stringify!(reserved)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct es_event_remote_thread_create_t {
    pub target: *mut es_process_t,
    pub thread_state: *mut es_thread_state_t,
    pub reserved: [u8; 64usize],
}
#[test]
fn bindgen_test_layout_es_event_remote_thread_create_t() {
    assert_eq!(
        ::std::mem::size_of::<es_event_remote_thread_create_t>(),
        80usize,
        concat!("Size of: ", stringify!(es_event_remote_thread_create_t))
    );
    assert_eq!(
        ::std::mem::align_of::<es_event_remote_thread_create_t>(),
        8usize,
        concat!("Alignment of ", stringify!(es_event_remote_thread_create_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<es_event_remote_thread_create_t>())).target as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_remote_thread_create_t),
            "::",
            stringify!(target)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<es_event_remote_thread_create_t>())).thread_state as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_remote_thread_create_t),
            "::",
            stringify!(thread_state)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<es_event_remote_thread_create_t>())).reserved as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(es_event_remote_thread_create_t),
            "::",
            stringify!(reserved)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union es_events_t {
    pub access: es_event_access_t,
    pub chdir: es_event_chdir_t,
    pub chroot: es_event_chroot_t,
    pub clone: es_event_clone_t,
    pub close: es_event_close_t,
    pub create: es_event_create_t,
    pub cs_invalidated: es_event_cs_invalidated_t,
    pub deleteextattr: es_event_deleteextattr_t,
    pub dup: es_event_dup_t,
    pub exchangedata: es_event_exchangedata_t,
    pub exec: es_event_exec_t,
    pub exit: es_event_exit_t,
    pub file_provider_materialize: es_event_file_provider_materialize_t,
    pub file_provider_update: es_event_file_provider_update_t,
    pub fcntl: es_event_fcntl_t,
    pub fork: es_event_fork_t,
    pub fsgetpath: es_event_fsgetpath_t,
    pub get_task: es_event_get_task_t,
    pub get_task_name: es_event_get_task_name_t,
    pub getattrlist: es_event_getattrlist_t,
    pub getextattr: es_event_getextattr_t,
    pub iokit_open: es_event_iokit_open_t,
    pub kextload: es_event_kextload_t,
    pub kextunload: es_event_kextunload_t,
    pub link: es_event_link_t,
    pub listextattr: es_event_listextattr_t,
    pub lookup: es_event_lookup_t,
    pub mmap: es_event_mmap_t,
    pub mount: es_event_mount_t,
    pub mprotect: es_event_mprotect_t,
    pub open: es_event_open_t,
    pub proc_check: es_event_proc_check_t,
    pub proc_suspend_resume: es_event_proc_suspend_resume_t,
    pub pty_close: es_event_pty_close_t,
    pub pty_grant: es_event_pty_grant_t,
    pub readdir: es_event_readdir_t,
    pub readlink: es_event_readlink_t,
    pub remote_thread_create: es_event_remote_thread_create_t,
    pub remount: es_event_remount_t,
    pub rename: es_event_rename_t,
    pub searchfs: es_event_searchfs_t,
    pub setacl: es_event_setacl_t,
    pub setattrlist: es_event_setattrlist_t,
    pub setextattr: es_event_setextattr_t,
    pub setflags: es_event_setflags_t,
    pub setmode: es_event_setmode_t,
    pub setowner: es_event_setowner_t,
    pub settime: es_event_settime_t,
    pub signal: es_event_signal_t,
    pub stat: es_event_stat_t,
    pub trace: es_event_trace_t,
    pub truncate: es_event_truncate_t,
    pub uipc_bind: es_event_uipc_bind_t,
    pub uipc_connect: es_event_uipc_connect_t,
    pub unlink: es_event_unlink_t,
    pub unmount: es_event_unmount_t,
    pub utimes: es_event_utimes_t,
    pub write: es_event_write_t,
    _bindgen_union_align: [u64; 13usize],
}
#[test]
fn bindgen_test_layout_es_events_t() {
    assert_eq!(
        ::std::mem::size_of::<es_events_t>(),
        104usize,
        concat!("Size of: ", stringify!(es_events_t))
    );
    assert_eq!(
        ::std::mem::align_of::<es_events_t>(),
        8usize,
        concat!("Alignment of ", stringify!(es_events_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_events_t>())).access as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_events_t),
            "::",
            stringify!(access)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_events_t>())).chdir as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_events_t),
            "::",
            stringify!(chdir)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_events_t>())).chroot as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_events_t),
            "::",
            stringify!(chroot)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_events_t>())).clone as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_events_t),
            "::",
            stringify!(clone)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_events_t>())).close as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_events_t),
            "::",
            stringify!(close)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_events_t>())).create as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_events_t),
            "::",
            stringify!(create)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_events_t>())).cs_invalidated as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_events_t),
            "::",
            stringify!(cs_invalidated)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_events_t>())).deleteextattr as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_events_t),
            "::",
            stringify!(deleteextattr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_events_t>())).dup as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_events_t),
            "::",
            stringify!(dup)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_events_t>())).exchangedata as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_events_t),
            "::",
            stringify!(exchangedata)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_events_t>())).exec as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_events_t),
            "::",
            stringify!(exec)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_events_t>())).exit as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_events_t),
            "::",
            stringify!(exit)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<es_events_t>())).file_provider_materialize as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_events_t),
            "::",
            stringify!(file_provider_materialize)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<es_events_t>())).file_provider_update as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_events_t),
            "::",
            stringify!(file_provider_update)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_events_t>())).fcntl as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_events_t),
            "::",
            stringify!(fcntl)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_events_t>())).fork as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_events_t),
            "::",
            stringify!(fork)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_events_t>())).fsgetpath as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_events_t),
            "::",
            stringify!(fsgetpath)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_events_t>())).get_task as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_events_t),
            "::",
            stringify!(get_task)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_events_t>())).get_task_name as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_events_t),
            "::",
            stringify!(get_task_name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_events_t>())).getattrlist as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_events_t),
            "::",
            stringify!(getattrlist)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_events_t>())).getextattr as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_events_t),
            "::",
            stringify!(getextattr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_events_t>())).iokit_open as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_events_t),
            "::",
            stringify!(iokit_open)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_events_t>())).kextload as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_events_t),
            "::",
            stringify!(kextload)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_events_t>())).kextunload as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_events_t),
            "::",
            stringify!(kextunload)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_events_t>())).link as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_events_t),
            "::",
            stringify!(link)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_events_t>())).listextattr as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_events_t),
            "::",
            stringify!(listextattr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_events_t>())).lookup as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_events_t),
            "::",
            stringify!(lookup)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_events_t>())).mmap as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_events_t),
            "::",
            stringify!(mmap)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_events_t>())).mount as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_events_t),
            "::",
            stringify!(mount)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_events_t>())).mprotect as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_events_t),
            "::",
            stringify!(mprotect)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_events_t>())).open as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_events_t),
            "::",
            stringify!(open)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_events_t>())).proc_check as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_events_t),
            "::",
            stringify!(proc_check)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_events_t>())).proc_suspend_resume as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_events_t),
            "::",
            stringify!(proc_suspend_resume)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_events_t>())).pty_close as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_events_t),
            "::",
            stringify!(pty_close)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_events_t>())).pty_grant as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_events_t),
            "::",
            stringify!(pty_grant)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_events_t>())).readdir as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_events_t),
            "::",
            stringify!(readdir)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_events_t>())).readlink as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_events_t),
            "::",
            stringify!(readlink)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<es_events_t>())).remote_thread_create as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_events_t),
            "::",
            stringify!(remote_thread_create)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_events_t>())).remount as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_events_t),
            "::",
            stringify!(remount)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_events_t>())).rename as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_events_t),
            "::",
            stringify!(rename)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_events_t>())).searchfs as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_events_t),
            "::",
            stringify!(searchfs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_events_t>())).setacl as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_events_t),
            "::",
            stringify!(setacl)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_events_t>())).setattrlist as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_events_t),
            "::",
            stringify!(setattrlist)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_events_t>())).setextattr as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_events_t),
            "::",
            stringify!(setextattr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_events_t>())).setflags as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_events_t),
            "::",
            stringify!(setflags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_events_t>())).setmode as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_events_t),
            "::",
            stringify!(setmode)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_events_t>())).setowner as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_events_t),
            "::",
            stringify!(setowner)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_events_t>())).settime as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_events_t),
            "::",
            stringify!(settime)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_events_t>())).signal as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_events_t),
            "::",
            stringify!(signal)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_events_t>())).stat as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_events_t),
            "::",
            stringify!(stat)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_events_t>())).trace as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_events_t),
            "::",
            stringify!(trace)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_events_t>())).truncate as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_events_t),
            "::",
            stringify!(truncate)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_events_t>())).uipc_bind as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_events_t),
            "::",
            stringify!(uipc_bind)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_events_t>())).uipc_connect as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_events_t),
            "::",
            stringify!(uipc_connect)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_events_t>())).unlink as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_events_t),
            "::",
            stringify!(unlink)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_events_t>())).unmount as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_events_t),
            "::",
            stringify!(unmount)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_events_t>())).utimes as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_events_t),
            "::",
            stringify!(utimes)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_events_t>())).write as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_events_t),
            "::",
            stringify!(write)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct es_result_t {
    pub result_type: es_result_type_t,
    pub result: es_result_t__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union es_result_t__bindgen_ty_1 {
    pub auth: es_auth_result_t,
    pub flags: u32,
    pub reserved: [u8; 32usize],
    _bindgen_union_align: [u32; 8usize],
}
#[test]
fn bindgen_test_layout_es_result_t__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<es_result_t__bindgen_ty_1>(),
        32usize,
        concat!("Size of: ", stringify!(es_result_t__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<es_result_t__bindgen_ty_1>(),
        4usize,
        concat!("Alignment of ", stringify!(es_result_t__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_result_t__bindgen_ty_1>())).auth as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_result_t__bindgen_ty_1),
            "::",
            stringify!(auth)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_result_t__bindgen_ty_1>())).flags as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_result_t__bindgen_ty_1),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<es_result_t__bindgen_ty_1>())).reserved as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_result_t__bindgen_ty_1),
            "::",
            stringify!(reserved)
        )
    );
}
#[test]
fn bindgen_test_layout_es_result_t() {
    assert_eq!(
        ::std::mem::size_of::<es_result_t>(),
        36usize,
        concat!("Size of: ", stringify!(es_result_t))
    );
    assert_eq!(
        ::std::mem::align_of::<es_result_t>(),
        4usize,
        concat!("Alignment of ", stringify!(es_result_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_result_t>())).result_type as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_result_t),
            "::",
            stringify!(result_type)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_result_t>())).result as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(es_result_t),
            "::",
            stringify!(result)
        )
    );
}
#[repr(C)]
pub struct es_message_t {
    pub version: u32,
    pub time: timespec,
    pub mach_time: u64,
    pub deadline: u64,
    pub process: *mut es_process_t,
    pub seq_num: u64,
    pub action_type: es_action_type_t,
    pub action: es_message_t__bindgen_ty_1,
    pub event_type: es_event_type_t,
    pub event: es_events_t,
    pub opaque: __IncompleteArrayField<u64>,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union es_message_t__bindgen_ty_1 {
    pub auth: es_event_id_t,
    pub notify: es_result_t,
    _bindgen_union_align: [u32; 9usize],
}
#[test]
fn bindgen_test_layout_es_message_t__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<es_message_t__bindgen_ty_1>(),
        36usize,
        concat!("Size of: ", stringify!(es_message_t__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<es_message_t__bindgen_ty_1>(),
        4usize,
        concat!("Alignment of ", stringify!(es_message_t__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_message_t__bindgen_ty_1>())).auth as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_message_t__bindgen_ty_1),
            "::",
            stringify!(auth)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<es_message_t__bindgen_ty_1>())).notify as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_message_t__bindgen_ty_1),
            "::",
            stringify!(notify)
        )
    );
}
#[test]
fn bindgen_test_layout_es_message_t() {
    assert_eq!(
        ::std::mem::size_of::<es_message_t>(),
        208usize,
        concat!("Size of: ", stringify!(es_message_t))
    );
    assert_eq!(
        ::std::mem::align_of::<es_message_t>(),
        8usize,
        concat!("Alignment of ", stringify!(es_message_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_message_t>())).version as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(es_message_t),
            "::",
            stringify!(version)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_message_t>())).time as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(es_message_t),
            "::",
            stringify!(time)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_message_t>())).mach_time as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(es_message_t),
            "::",
            stringify!(mach_time)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_message_t>())).deadline as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(es_message_t),
            "::",
            stringify!(deadline)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_message_t>())).process as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(es_message_t),
            "::",
            stringify!(process)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_message_t>())).seq_num as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(es_message_t),
            "::",
            stringify!(seq_num)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_message_t>())).action_type as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(es_message_t),
            "::",
            stringify!(action_type)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_message_t>())).action as *const _ as usize },
        60usize,
        concat!(
            "Offset of field: ",
            stringify!(es_message_t),
            "::",
            stringify!(action)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_message_t>())).event_type as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(es_message_t),
            "::",
            stringify!(event_type)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_message_t>())).event as *const _ as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(es_message_t),
            "::",
            stringify!(event)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<es_message_t>())).opaque as *const _ as usize },
        208usize,
        concat!(
            "Offset of field: ",
            stringify!(es_message_t),
            "::",
            stringify!(opaque)
        )
    );
}
extern "C" {
    pub fn es_message_size(msg: *const es_message_t) -> size_t;
}
extern "C" {
    pub fn es_copy_message(msg: *const es_message_t) -> *mut es_message_t;
}
extern "C" {
    pub fn es_free_message(msg: *mut es_message_t);
}
extern "C" {
    pub fn es_exec_arg_count(event: *const es_event_exec_t) -> u32;
}
extern "C" {
    pub fn es_exec_env_count(event: *const es_event_exec_t) -> u32;
}
extern "C" {
    pub fn es_exec_fd_count(event: *const es_event_exec_t) -> u32;
}
extern "C" {
    pub fn es_exec_arg(event: *const es_event_exec_t, index: u32) -> es_string_token_t;
}
extern "C" {
    pub fn es_exec_env(event: *const es_event_exec_t, index: u32) -> es_string_token_t;
}
extern "C" {
    pub fn es_exec_fd(event: *const es_event_exec_t, index: u32) -> *const es_fd_t;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct es_client_s {
    pub _unused: [u8; 0],
}
pub type es_client_t = es_client_s;
extern "C" {
    pub fn es_subscribe(
        client: *mut es_client_t,
        events: *const es_event_type_t,
        event_count: u32,
    ) -> es_return_t;
}
extern "C" {
    pub fn es_unsubscribe(
        client: *mut es_client_t,
        events: *const es_event_type_t,
        event_count: u32,
    ) -> es_return_t;
}
extern "C" {
    pub fn es_unsubscribe_all(client: *mut es_client_t) -> es_return_t;
}
extern "C" {
    pub fn es_subscriptions(
        client: *mut es_client_t,
        count: *mut size_t,
        subscriptions: *mut *mut es_event_type_t,
    ) -> es_return_t;
}
extern "C" {
    pub fn es_respond_auth_result(
        client: *mut es_client_t,
        message: *const es_message_t,
        result: es_auth_result_t,
        cache: bool,
    ) -> es_respond_result_t;
}
extern "C" {
    pub fn es_respond_flags_result(
        client: *mut es_client_t,
        message: *const es_message_t,
        authorized_flags: u32,
        cache: bool,
    ) -> es_respond_result_t;
}
extern "C" {
    pub fn es_mute_process(
        client: *mut es_client_t,
        audit_token: *const audit_token_t,
    ) -> es_return_t;
}
extern "C" {
    pub fn es_unmute_process(
        client: *mut es_client_t,
        audit_token: *const audit_token_t,
    ) -> es_return_t;
}
extern "C" {
    pub fn es_muted_processes(
        client: *mut es_client_t,
        count: *mut size_t,
        audit_tokens: *mut *mut audit_token_t,
    ) -> es_return_t;
}
extern "C" {
    pub fn es_mute_path_prefix(
        client: *mut es_client_t,
        path_prefix: *const ::std::os::raw::c_char,
    ) -> es_return_t;
}
extern "C" {
    pub fn es_mute_path_literal(
        client: *mut es_client_t,
        path_literal: *const ::std::os::raw::c_char,
    ) -> es_return_t;
}
extern "C" {
    pub fn es_unmute_all_paths(client: *mut es_client_t) -> es_return_t;
}
extern "C" {
    pub fn es_clear_cache(client: *mut es_client_t) -> es_clear_cache_result_t;
}
// EDITED FROM *mut to *const
pub type es_handler_block_t = *const ::std::os::raw::c_void;
// FINISH EDIT
extern "C" {
    pub fn es_new_client(
        client: *mut *mut es_client_t,
        handler: es_handler_block_t,
    ) -> es_new_client_result_t;
}
extern "C" {
    pub fn es_delete_client(client: *mut es_client_t) -> es_return_t;
}
pub type __builtin_va_list = [__va_list_tag; 1usize];
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __va_list_tag {
    pub gp_offset: ::std::os::raw::c_uint,
    pub fp_offset: ::std::os::raw::c_uint,
    pub overflow_arg_area: *mut ::std::os::raw::c_void,
    pub reg_save_area: *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout___va_list_tag() {
    assert_eq!(
        ::std::mem::size_of::<__va_list_tag>(),
        24usize,
        concat!("Size of: ", stringify!(__va_list_tag))
    );
    assert_eq!(
        ::std::mem::align_of::<__va_list_tag>(),
        8usize,
        concat!("Alignment of ", stringify!(__va_list_tag))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__va_list_tag>())).gp_offset as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__va_list_tag),
            "::",
            stringify!(gp_offset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__va_list_tag>())).fp_offset as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__va_list_tag),
            "::",
            stringify!(fp_offset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__va_list_tag>())).overflow_arg_area as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__va_list_tag),
            "::",
            stringify!(overflow_arg_area)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__va_list_tag>())).reg_save_area as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__va_list_tag),
            "::",
            stringify!(reg_save_area)
        )
    );
}
