use crate::percent::PercentValidator;
use crate::Validator;

#[test]
fn is_valid() {
    let test_cases: &[(&str, bool)] = &[
        ("", true),
        ("azAZ09", true),
        ("%20", true),
        ("a%20a", true),
        ("%0x", false),
        ("%x0", false),
        ("a%0", false),
        ("a%", false),
    ];
    for (data, expected) in test_cases {
        let result: bool = PercentValidator::default().is_valid(data.as_bytes());
        assert_eq!(result, *expected);
    }
}
