use std::marker::PhantomData;

use crate::Validator;

/// Responsible for validating percent encoded data.
#[derive(Copy, Clone, Ord, PartialOrd, Eq, PartialEq, Hash, Debug)]
pub struct PercentValidator {
    _phantom: PhantomData<()>,
}

impl Default for PercentValidator {
    fn default() -> Self {
        Self {
            _phantom: PhantomData::default(),
        }
    }
}

impl Validator for PercentValidator {
    fn is_valid(&self, encoded_data: &[u8]) -> bool {
        match encoded_data.iter().position(|c| *c == b'%') {
            Some(p) => {
                if encoded_data.len() < 3 || p > encoded_data.len() - 3 {
                    false
                } else if !encoded_data[p + 1].is_ascii_hexdigit()
                    || !encoded_data[p + 2].is_ascii_hexdigit()
                {
                    false
                } else {
                    self.is_valid(&encoded_data[p + 3..])
                }
            }
            None => true,
        }
    }
}
