use crate::percent::PercentEncoder;
use crate::{Error, StringEncoder};

#[test]
fn needs_encoding() {
    let encoder: PercentEncoder = PercentEncoder::new(b"");
    b"09azAZ"
        .iter()
        .for_each(|c| assert_eq!(encoder.needs_encoding(*c), false));
    b"\x00\x1F\x7F\xFF"
        .iter()
        .for_each(|c| assert_eq!(encoder.needs_encoding(*c), true));
    b" /:@[`{~"
        .iter()
        .for_each(|c| assert_eq!(encoder.needs_encoding(*c), true));

    let encoder: PercentEncoder = PercentEncoder::new(b"/@{1");
    b"/@{"
        .iter()
        .for_each(|c| assert_eq!(encoder.needs_encoding(*c), false));
    b" :[`~"
        .iter()
        .for_each(|c| assert_eq!(encoder.needs_encoding(*c), true));
}

#[test]
fn encode() {
    let encoder: PercentEncoder = PercentEncoder::new(b"{}[]()");
    let test_cases: &[(&str, &str)] = &[
        ("", ""),
        ("azAZ09", "azAZ09"),
        ("!az:AZ/09~", "%21az%3AAZ%2F09%7E"),
        ("{az}[AZ](09)", "{az}[AZ](09)"),
    ];
    for (data, expected) in test_cases {
        let result: Result<String, Error> = encoder.encode_as_string(data.as_bytes());
        assert_eq!(result, Ok(expected.to_string()));
    }
}
