use crate::percent::PercentDecoder;
use crate::{Decoder, Error};

#[test]
fn decode() -> Result<(), Error> {
    let test_cases: &[(&str, &str)] = &[
        ("", ""),
        ("azAZ09", "azAZ09"),
        ("%30", "0"),
        ("az%30AZ%3009", "az0AZ009"),
        ("%2x", "%2x"),
        ("%x2", "%x2"),
        ("a%", "a%"),
        ("a%0", "a%0"),
    ];
    for (data, expected) in test_cases {
        let result: Vec<u8> = PercentDecoder::default().decode_as_vec(data.as_bytes())?;
        assert_eq!(result.as_slice(), expected.as_bytes());
    }
    Ok(())
}
