use crate::hex::HexValidator;
use crate::Validator;

#[test]
fn is_valid() {
    let test_cases: &[(&str, bool)] = &[
        ("", true),
        ("0", false),
        ("00", true),
        ("000", false),
        ("0000", true),
        ("00000", false),
        ("000000", true),
        ("0123456789", true),
        ("abcdef", true),
        ("ABCDEF", true),
        ("//", false),
        ("::", false),
        ("@@", false),
        ("GG", false),
        ("``", false),
        ("gg", false),
    ];
    for (encoded_data, expected) in test_cases {
        let result: bool = HexValidator::default().is_valid(encoded_data.as_bytes());
        assert_eq!(result, *expected);
    }
}
