use std::marker::PhantomData;

use crate::hex::HexDecoder;
use crate::Validator;

/// Responsible for validating hex data.
#[derive(Copy, Clone, Ord, PartialOrd, Eq, PartialEq, Hash, Debug)]
pub struct HexValidator {
    _phantom: PhantomData<()>,
}

impl Default for HexValidator {
    fn default() -> Self {
        Self {
            _phantom: PhantomData::default(),
        }
    }
}

impl Validator for HexValidator {
    fn is_valid(&self, data: &[u8]) -> bool {
        data.len() % 2 == 0
            && data
                .iter()
                .all(|c| HexDecoder::DECODING_TABLE[*c as usize] != HexDecoder::INV)
    }
}
