use crate::hex::HexEncoder;
use crate::{Error, StringEncoder};

#[test]
fn encode() {
    let test_cases: &[(&str, &str)] = &[
        ("", ""),
        ("H", "48"),
        ("He", "4865"),
        ("Hel", "48656C"),
        ("Hell", "48656C6C"),
        ("Hello", "48656C6C6F"),
        ("Hello,", "48656C6C6F2C"),
        ("Hello, ", "48656C6C6F2C20"),
        ("Hello, w", "48656C6C6F2C2077"),
        ("Hello, wo", "48656C6C6F2C20776F"),
        ("Hello, wor", "48656C6C6F2C20776F72"),
        ("Hello, worl", "48656C6C6F2C20776F726C"),
        ("Hello, world", "48656C6C6F2C20776F726C64"),
        ("Hello, world!", "48656C6C6F2C20776F726C6421"),
    ];
    for (data, expected) in test_cases {
        let result: Result<String, Error> =
            HexEncoder::LOWERCASE_ENCODER.encode_as_string(data.as_bytes());
        assert_eq!(result, Ok(expected.to_ascii_lowercase().to_string()));

        let result: Result<String, Error> =
            HexEncoder::UPPERCASE_ENCODER.encode_as_string(data.as_bytes());
        assert_eq!(result, Ok(expected.to_ascii_uppercase().to_string()));
    }
}
