use crate::hex::HexDecoder;
use crate::{Decoder, Error};

#[test]
fn decode() {
    let test_cases: &[(&str, &str)] = &[
        ("", ""),
        ("48", "H"),
        ("4865", "He"),
        ("48656C", "Hel"),
        ("48656C6C", "Hell"),
        ("48656C6C6F", "Hello"),
        ("48656C6C6F2C", "Hello,"),
        ("48656C6C6F2C20", "Hello, "),
        ("48656C6C6F2C2077", "Hello, w"),
        ("48656C6C6F2C20776F", "Hello, wo"),
        ("48656C6C6F2C20776F72", "Hello, wor"),
        ("48656C6C6F2C20776F726C", "Hello, worl"),
        ("48656C6C6F2C20776F726C64", "Hello, world"),
        ("48656C6C6F2C20776F726C6421", "Hello, world!"),
    ];
    for (data, expected) in test_cases {
        let result: Result<Vec<u8>, Error> =
            HexDecoder::default().decode_as_vec(data.to_ascii_uppercase().as_bytes());
        assert_eq!(result.unwrap().as_slice(), expected.as_bytes());

        let result: Result<Vec<u8>, Error> =
            HexDecoder::default().decode_as_vec(data.to_ascii_lowercase().as_bytes());
        assert_eq!(result.unwrap().as_slice(), expected.as_bytes());
    }
}
