use std::fmt::{Display, Formatter};

/// Represents an error processing encoded data.
#[derive(Copy, Clone, Ord, PartialOrd, Eq, PartialEq, Hash, Debug)]
pub enum Error {
    /// An integer operation overflowed.
    IntegerOverflow,

    /// The target has insufficient space.
    InsufficientTargetSpace,

    /// The encoded data is invalid.
    InvalidEncodedData,
}

impl std::error::Error for Error {}

impl Display for Error {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        let message: &'static str = match self {
            Self::IntegerOverflow => "an integer operation overflowed",
            Self::InsufficientTargetSpace => "the target has insufficient space",
            Self::InvalidEncodedData => "the encoded data is invalid",
        };
        f.write_str(message)
    }
}
