use std::path::PathBuf;

use emote_mapper::EmoteMapper;

fn main() {
    let em = EmoteMapper::from_path(&PathBuf::from("examples/twitch_emotes.csv"))
        .unwrap()
        .emote_width(2);

    let messages = vec![
        "modproHi, how are you doing?",
        "<3, great",
        "tggleBoss Kappa xD",
    ];

    for message in messages.into_iter().map(|m| em.replace_all(m)) {
        println!("{}", message)
    }
}
