#![cfg_attr(rustfmt, rustfmt::skip)]

use crate::{Emoji, SkinTone, UnicodeVersion};

/// A category for an emoji.
///
/// Based on Unicode CLDR data.
#[derive(Debug, Clone, Copy, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub enum Group {
   SmileysAndEmotion,
   PeopleAndBody,
   AnimalsAndNature,
   FoodAndDrink,
   TravelAndPlaces,
   Activities,
   Objects,
   Symbols,
   Flags,
}

pub const EMOJIS: &[Emoji] = &[
    Emoji { emoji: "😀", name: "grinning face", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["grinning"]), variations: &[] },
    Emoji { emoji: "😃", name: "grinning face with big eyes", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["smiley"]), variations: &[] },
    Emoji { emoji: "😄", name: "grinning face with smiling eyes", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["smile"]), variations: &[] },
    Emoji { emoji: "😁", name: "beaming face with smiling eyes", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["grin"]), variations: &[] },
    Emoji { emoji: "😆", name: "grinning squinting face", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["laughing", "satisfied"]), variations: &[] },
    Emoji { emoji: "😅", name: "grinning face with sweat", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["sweat_smile"]), variations: &[] },
    Emoji { emoji: "🤣", name: "rolling on the floor laughing", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["rofl"]), variations: &[] },
    Emoji { emoji: "😂", name: "face with tears of joy", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["joy"]), variations: &[] },
    Emoji { emoji: "🙂", name: "slightly smiling face", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["slightly_smiling_face"]), variations: &[] },
    Emoji { emoji: "🙃", name: "upside-down face", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["upside_down_face"]), variations: &[] },
    Emoji { emoji: "🫠", name: "melting face", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: None, variations: &[] },
    Emoji { emoji: "😉", name: "winking face", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["wink"]), variations: &[] },
    Emoji { emoji: "😊", name: "smiling face with smiling eyes", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["blush"]), variations: &[] },
    Emoji { emoji: "😇", name: "smiling face with halo", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["innocent"]), variations: &[] },
    Emoji { emoji: "🥰", name: "smiling face with hearts", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["smiling_face_with_three_hearts"]), variations: &[] },
    Emoji { emoji: "😍", name: "smiling face with heart-eyes", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["heart_eyes"]), variations: &[] },
    Emoji { emoji: "🤩", name: "star-struck", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["star_struck"]), variations: &[] },
    Emoji { emoji: "😘", name: "face blowing a kiss", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["kissing_heart"]), variations: &[] },
    Emoji { emoji: "😗", name: "kissing face", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["kissing"]), variations: &[] },
    Emoji { emoji: "☺️", name: "smiling face", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["relaxed"]), variations: &["☺"] },
    Emoji { emoji: "😚", name: "kissing face with closed eyes", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["kissing_closed_eyes"]), variations: &[] },
    Emoji { emoji: "😙", name: "kissing face with smiling eyes", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["kissing_smiling_eyes"]), variations: &[] },
    Emoji { emoji: "🥲", name: "smiling face with tear", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["smiling_face_with_tear"]), variations: &[] },
    Emoji { emoji: "😋", name: "face savoring food", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["yum"]), variations: &[] },
    Emoji { emoji: "😛", name: "face with tongue", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["stuck_out_tongue"]), variations: &[] },
    Emoji { emoji: "😜", name: "winking face with tongue", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["stuck_out_tongue_winking_eye"]), variations: &[] },
    Emoji { emoji: "🤪", name: "zany face", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["zany_face"]), variations: &[] },
    Emoji { emoji: "😝", name: "squinting face with tongue", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["stuck_out_tongue_closed_eyes"]), variations: &[] },
    Emoji { emoji: "🤑", name: "money-mouth face", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["money_mouth_face"]), variations: &[] },
    Emoji { emoji: "🤗", name: "smiling face with open hands", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["hugs"]), variations: &[] },
    Emoji { emoji: "🤭", name: "face with hand over mouth", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["hand_over_mouth"]), variations: &[] },
    Emoji { emoji: "🫢", name: "face with open eyes and hand over mouth", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: None, variations: &[] },
    Emoji { emoji: "🫣", name: "face with peeking eye", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: None, variations: &[] },
    Emoji { emoji: "🤫", name: "shushing face", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["shushing_face"]), variations: &[] },
    Emoji { emoji: "🤔", name: "thinking face", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["thinking"]), variations: &[] },
    Emoji { emoji: "🫡", name: "saluting face", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: None, variations: &[] },
    Emoji { emoji: "🤐", name: "zipper-mouth face", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["zipper_mouth_face"]), variations: &[] },
    Emoji { emoji: "🤨", name: "face with raised eyebrow", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["raised_eyebrow"]), variations: &[] },
    Emoji { emoji: "😐", name: "neutral face", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["neutral_face"]), variations: &[] },
    Emoji { emoji: "😑", name: "expressionless face", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["expressionless"]), variations: &[] },
    Emoji { emoji: "😶", name: "face without mouth", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["no_mouth"]), variations: &[] },
    Emoji { emoji: "🫥", name: "dotted line face", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: None, variations: &[] },
    Emoji { emoji: "😶‍🌫️", name: "face in clouds", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: None, variations: &["😶\u{200d}🌫"] },
    Emoji { emoji: "😏", name: "smirking face", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["smirk"]), variations: &[] },
    Emoji { emoji: "😒", name: "unamused face", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["unamused"]), variations: &[] },
    Emoji { emoji: "🙄", name: "face with rolling eyes", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["roll_eyes"]), variations: &[] },
    Emoji { emoji: "😬", name: "grimacing face", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["grimacing"]), variations: &[] },
    Emoji { emoji: "😮‍💨", name: "face exhaling", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: None, variations: &[] },
    Emoji { emoji: "🤥", name: "lying face", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["lying_face"]), variations: &[] },
    Emoji { emoji: "😌", name: "relieved face", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["relieved"]), variations: &[] },
    Emoji { emoji: "😔", name: "pensive face", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["pensive"]), variations: &[] },
    Emoji { emoji: "😪", name: "sleepy face", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["sleepy"]), variations: &[] },
    Emoji { emoji: "🤤", name: "drooling face", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["drooling_face"]), variations: &[] },
    Emoji { emoji: "😴", name: "sleeping face", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["sleeping"]), variations: &[] },
    Emoji { emoji: "😷", name: "face with medical mask", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["mask"]), variations: &[] },
    Emoji { emoji: "🤒", name: "face with thermometer", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["face_with_thermometer"]), variations: &[] },
    Emoji { emoji: "🤕", name: "face with head-bandage", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["face_with_head_bandage"]), variations: &[] },
    Emoji { emoji: "🤢", name: "nauseated face", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["nauseated_face"]), variations: &[] },
    Emoji { emoji: "🤮", name: "face vomiting", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["vomiting_face"]), variations: &[] },
    Emoji { emoji: "🤧", name: "sneezing face", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["sneezing_face"]), variations: &[] },
    Emoji { emoji: "🥵", name: "hot face", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["hot_face"]), variations: &[] },
    Emoji { emoji: "🥶", name: "cold face", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["cold_face"]), variations: &[] },
    Emoji { emoji: "🥴", name: "woozy face", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["woozy_face"]), variations: &[] },
    Emoji { emoji: "😵", name: "face with crossed-out eyes", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["dizzy_face"]), variations: &[] },
    Emoji { emoji: "😵‍💫", name: "face with spiral eyes", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: None, variations: &[] },
    Emoji { emoji: "🤯", name: "exploding head", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["exploding_head"]), variations: &[] },
    Emoji { emoji: "🤠", name: "cowboy hat face", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["cowboy_hat_face"]), variations: &[] },
    Emoji { emoji: "🥳", name: "partying face", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["partying_face"]), variations: &[] },
    Emoji { emoji: "🥸", name: "disguised face", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["disguised_face"]), variations: &[] },
    Emoji { emoji: "😎", name: "smiling face with sunglasses", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["sunglasses"]), variations: &[] },
    Emoji { emoji: "🤓", name: "nerd face", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["nerd_face"]), variations: &[] },
    Emoji { emoji: "🧐", name: "face with monocle", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["monocle_face"]), variations: &[] },
    Emoji { emoji: "😕", name: "confused face", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["confused"]), variations: &[] },
    Emoji { emoji: "🫤", name: "face with diagonal mouth", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: None, variations: &[] },
    Emoji { emoji: "😟", name: "worried face", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["worried"]), variations: &[] },
    Emoji { emoji: "🙁", name: "slightly frowning face", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["slightly_frowning_face"]), variations: &[] },
    Emoji { emoji: "☹️", name: "frowning face", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["frowning_face"]), variations: &["☹"] },
    Emoji { emoji: "😮", name: "face with open mouth", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["open_mouth"]), variations: &[] },
    Emoji { emoji: "😯", name: "hushed face", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["hushed"]), variations: &[] },
    Emoji { emoji: "😲", name: "astonished face", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["astonished"]), variations: &[] },
    Emoji { emoji: "😳", name: "flushed face", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["flushed"]), variations: &[] },
    Emoji { emoji: "🥺", name: "pleading face", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["pleading_face"]), variations: &[] },
    Emoji { emoji: "🥹", name: "face holding back tears", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: None, variations: &[] },
    Emoji { emoji: "😦", name: "frowning face with open mouth", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["frowning"]), variations: &[] },
    Emoji { emoji: "😧", name: "anguished face", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["anguished"]), variations: &[] },
    Emoji { emoji: "😨", name: "fearful face", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["fearful"]), variations: &[] },
    Emoji { emoji: "😰", name: "anxious face with sweat", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["cold_sweat"]), variations: &[] },
    Emoji { emoji: "😥", name: "sad but relieved face", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["disappointed_relieved"]), variations: &[] },
    Emoji { emoji: "😢", name: "crying face", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["cry"]), variations: &[] },
    Emoji { emoji: "😭", name: "loudly crying face", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["sob"]), variations: &[] },
    Emoji { emoji: "😱", name: "face screaming in fear", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["scream"]), variations: &[] },
    Emoji { emoji: "😖", name: "confounded face", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["confounded"]), variations: &[] },
    Emoji { emoji: "😣", name: "persevering face", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["persevere"]), variations: &[] },
    Emoji { emoji: "😞", name: "disappointed face", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["disappointed"]), variations: &[] },
    Emoji { emoji: "😓", name: "downcast face with sweat", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["sweat"]), variations: &[] },
    Emoji { emoji: "😩", name: "weary face", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["weary"]), variations: &[] },
    Emoji { emoji: "😫", name: "tired face", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["tired_face"]), variations: &[] },
    Emoji { emoji: "🥱", name: "yawning face", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["yawning_face"]), variations: &[] },
    Emoji { emoji: "😤", name: "face with steam from nose", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["triumph"]), variations: &[] },
    Emoji { emoji: "😡", name: "pouting face", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["rage", "pout"]), variations: &[] },
    Emoji { emoji: "😠", name: "angry face", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["angry"]), variations: &[] },
    Emoji { emoji: "🤬", name: "face with symbols on mouth", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["cursing_face"]), variations: &[] },
    Emoji { emoji: "😈", name: "smiling face with horns", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["smiling_imp"]), variations: &[] },
    Emoji { emoji: "👿", name: "angry face with horns", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["imp"]), variations: &[] },
    Emoji { emoji: "💀", name: "skull", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["skull"]), variations: &[] },
    Emoji { emoji: "☠️", name: "skull and crossbones", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["skull_and_crossbones"]), variations: &["☠"] },
    Emoji { emoji: "💩", name: "pile of poo", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["hankey", "poop", "shit"]), variations: &[] },
    Emoji { emoji: "🤡", name: "clown face", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["clown_face"]), variations: &[] },
    Emoji { emoji: "👹", name: "ogre", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["japanese_ogre"]), variations: &[] },
    Emoji { emoji: "👺", name: "goblin", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["japanese_goblin"]), variations: &[] },
    Emoji { emoji: "👻", name: "ghost", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["ghost"]), variations: &[] },
    Emoji { emoji: "👽", name: "alien", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["alien"]), variations: &[] },
    Emoji { emoji: "👾", name: "alien monster", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["space_invader"]), variations: &[] },
    Emoji { emoji: "🤖", name: "robot", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["robot"]), variations: &[] },
    Emoji { emoji: "😺", name: "grinning cat", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["smiley_cat"]), variations: &[] },
    Emoji { emoji: "😸", name: "grinning cat with smiling eyes", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["smile_cat"]), variations: &[] },
    Emoji { emoji: "😹", name: "cat with tears of joy", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["joy_cat"]), variations: &[] },
    Emoji { emoji: "😻", name: "smiling cat with heart-eyes", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["heart_eyes_cat"]), variations: &[] },
    Emoji { emoji: "😼", name: "cat with wry smile", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["smirk_cat"]), variations: &[] },
    Emoji { emoji: "😽", name: "kissing cat", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["kissing_cat"]), variations: &[] },
    Emoji { emoji: "🙀", name: "weary cat", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["scream_cat"]), variations: &[] },
    Emoji { emoji: "😿", name: "crying cat", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["crying_cat_face"]), variations: &[] },
    Emoji { emoji: "😾", name: "pouting cat", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["pouting_cat"]), variations: &[] },
    Emoji { emoji: "🙈", name: "see-no-evil monkey", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["see_no_evil"]), variations: &[] },
    Emoji { emoji: "🙉", name: "hear-no-evil monkey", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["hear_no_evil"]), variations: &[] },
    Emoji { emoji: "🙊", name: "speak-no-evil monkey", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["speak_no_evil"]), variations: &[] },
    Emoji { emoji: "💋", name: "kiss mark", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["kiss"]), variations: &[] },
    Emoji { emoji: "💌", name: "love letter", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["love_letter"]), variations: &[] },
    Emoji { emoji: "💘", name: "heart with arrow", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["cupid"]), variations: &[] },
    Emoji { emoji: "💝", name: "heart with ribbon", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["gift_heart"]), variations: &[] },
    Emoji { emoji: "💖", name: "sparkling heart", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["sparkling_heart"]), variations: &[] },
    Emoji { emoji: "💗", name: "growing heart", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["heartpulse"]), variations: &[] },
    Emoji { emoji: "💓", name: "beating heart", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["heartbeat"]), variations: &[] },
    Emoji { emoji: "💞", name: "revolving hearts", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["revolving_hearts"]), variations: &[] },
    Emoji { emoji: "💕", name: "two hearts", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["two_hearts"]), variations: &[] },
    Emoji { emoji: "💟", name: "heart decoration", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["heart_decoration"]), variations: &[] },
    Emoji { emoji: "❣️", name: "heart exclamation", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["heavy_heart_exclamation"]), variations: &["❣"] },
    Emoji { emoji: "💔", name: "broken heart", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["broken_heart"]), variations: &[] },
    Emoji { emoji: "❤️‍🔥", name: "heart on fire", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: None, variations: &["❤\u{200d}🔥"] },
    Emoji { emoji: "❤️‍🩹", name: "mending heart", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: None, variations: &["❤\u{200d}🩹"] },
    Emoji { emoji: "❤️", name: "red heart", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["heart"]), variations: &["❤"] },
    Emoji { emoji: "🧡", name: "orange heart", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["orange_heart"]), variations: &[] },
    Emoji { emoji: "💛", name: "yellow heart", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["yellow_heart"]), variations: &[] },
    Emoji { emoji: "💚", name: "green heart", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["green_heart"]), variations: &[] },
    Emoji { emoji: "💙", name: "blue heart", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["blue_heart"]), variations: &[] },
    Emoji { emoji: "💜", name: "purple heart", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["purple_heart"]), variations: &[] },
    Emoji { emoji: "🤎", name: "brown heart", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["brown_heart"]), variations: &[] },
    Emoji { emoji: "🖤", name: "black heart", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["black_heart"]), variations: &[] },
    Emoji { emoji: "🤍", name: "white heart", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["white_heart"]), variations: &[] },
    Emoji { emoji: "💯", name: "hundred points", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["100"]), variations: &[] },
    Emoji { emoji: "💢", name: "anger symbol", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["anger"]), variations: &[] },
    Emoji { emoji: "💥", name: "collision", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["boom", "collision"]), variations: &[] },
    Emoji { emoji: "💫", name: "dizzy", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["dizzy"]), variations: &[] },
    Emoji { emoji: "💦", name: "sweat droplets", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["sweat_drops"]), variations: &[] },
    Emoji { emoji: "💨", name: "dashing away", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["dash"]), variations: &[] },
    Emoji { emoji: "🕳️", name: "hole", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["hole"]), variations: &["🕳"] },
    Emoji { emoji: "💣", name: "bomb", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["bomb"]), variations: &[] },
    Emoji { emoji: "💬", name: "speech balloon", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["speech_balloon"]), variations: &[] },
    Emoji { emoji: "👁️‍🗨️", name: "eye in speech bubble", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["eye_speech_bubble"]), variations: &["👁\u{200d}🗨\u{fe0f}", "👁\u{fe0f}\u{200d}🗨", "👁\u{200d}🗨"] },
    Emoji { emoji: "🗨️", name: "left speech bubble", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["left_speech_bubble"]), variations: &["🗨"] },
    Emoji { emoji: "🗯️", name: "right anger bubble", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["right_anger_bubble"]), variations: &["🗯"] },
    Emoji { emoji: "💭", name: "thought balloon", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["thought_balloon"]), variations: &[] },
    Emoji { emoji: "💤", name: "zzz", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["zzz"]), variations: &[] },
    Emoji { emoji: "👋", name: "waving hand", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: Some((163, SkinTone::Default)), aliases: Some(&["wave"]), variations: &[] },
    Emoji { emoji: "👋🏻", name: "waving hand: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((163, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "👋🏼", name: "waving hand: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((163, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "👋🏽", name: "waving hand: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((163, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "👋🏾", name: "waving hand: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((163, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "👋🏿", name: "waving hand: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((163, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "🤚", name: "raised back of hand", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((169, SkinTone::Default)), aliases: Some(&["raised_back_of_hand"]), variations: &[] },
    Emoji { emoji: "🤚🏻", name: "raised back of hand: light skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((169, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "🤚🏼", name: "raised back of hand: medium-light skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((169, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "🤚🏽", name: "raised back of hand: medium skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((169, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "🤚🏾", name: "raised back of hand: medium-dark skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((169, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "🤚🏿", name: "raised back of hand: dark skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((169, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "🖐️", name: "hand with fingers splayed", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::PeopleAndBody, skin_tone: Some((175, SkinTone::Default)), aliases: Some(&["raised_hand_with_fingers_splayed"]), variations: &["🖐"] },
    Emoji { emoji: "🖐🏻", name: "hand with fingers splayed: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((175, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "🖐🏼", name: "hand with fingers splayed: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((175, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "🖐🏽", name: "hand with fingers splayed: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((175, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "🖐🏾", name: "hand with fingers splayed: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((175, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "🖐🏿", name: "hand with fingers splayed: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((175, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "✋", name: "raised hand", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: Some((181, SkinTone::Default)), aliases: Some(&["hand", "raised_hand"]), variations: &[] },
    Emoji { emoji: "✋🏻", name: "raised hand: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((181, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "✋🏼", name: "raised hand: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((181, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "✋🏽", name: "raised hand: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((181, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "✋🏾", name: "raised hand: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((181, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "✋🏿", name: "raised hand: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((181, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "🖖", name: "vulcan salute", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((187, SkinTone::Default)), aliases: Some(&["vulcan_salute"]), variations: &[] },
    Emoji { emoji: "🖖🏻", name: "vulcan salute: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((187, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "🖖🏼", name: "vulcan salute: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((187, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "🖖🏽", name: "vulcan salute: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((187, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "🖖🏾", name: "vulcan salute: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((187, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "🖖🏿", name: "vulcan salute: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((187, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "🫱", name: "rightwards hand", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((193, SkinTone::Default)), aliases: None, variations: &[] },
    Emoji { emoji: "🫱🏻", name: "rightwards hand: light skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((193, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "🫱🏼", name: "rightwards hand: medium-light skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((193, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "🫱🏽", name: "rightwards hand: medium skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((193, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "🫱🏾", name: "rightwards hand: medium-dark skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((193, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "🫱🏿", name: "rightwards hand: dark skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((193, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "🫲", name: "leftwards hand", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((199, SkinTone::Default)), aliases: None, variations: &[] },
    Emoji { emoji: "🫲🏻", name: "leftwards hand: light skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((199, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "🫲🏼", name: "leftwards hand: medium-light skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((199, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "🫲🏽", name: "leftwards hand: medium skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((199, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "🫲🏾", name: "leftwards hand: medium-dark skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((199, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "🫲🏿", name: "leftwards hand: dark skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((199, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "🫳", name: "palm down hand", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((205, SkinTone::Default)), aliases: None, variations: &[] },
    Emoji { emoji: "🫳🏻", name: "palm down hand: light skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((205, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "🫳🏼", name: "palm down hand: medium-light skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((205, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "🫳🏽", name: "palm down hand: medium skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((205, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "🫳🏾", name: "palm down hand: medium-dark skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((205, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "🫳🏿", name: "palm down hand: dark skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((205, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "🫴", name: "palm up hand", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((211, SkinTone::Default)), aliases: None, variations: &[] },
    Emoji { emoji: "🫴🏻", name: "palm up hand: light skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((211, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "🫴🏼", name: "palm up hand: medium-light skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((211, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "🫴🏽", name: "palm up hand: medium skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((211, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "🫴🏾", name: "palm up hand: medium-dark skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((211, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "🫴🏿", name: "palm up hand: dark skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((211, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "👌", name: "OK hand", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: Some((217, SkinTone::Default)), aliases: Some(&["ok_hand"]), variations: &[] },
    Emoji { emoji: "👌🏻", name: "OK hand: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((217, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "👌🏼", name: "OK hand: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((217, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "👌🏽", name: "OK hand: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((217, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "👌🏾", name: "OK hand: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((217, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "👌🏿", name: "OK hand: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((217, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "🤌", name: "pinched fingers", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((223, SkinTone::Default)), aliases: Some(&["pinched_fingers"]), variations: &[] },
    Emoji { emoji: "🤌🏻", name: "pinched fingers: light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((223, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "🤌🏼", name: "pinched fingers: medium-light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((223, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "🤌🏽", name: "pinched fingers: medium skin tone", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((223, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "🤌🏾", name: "pinched fingers: medium-dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((223, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "🤌🏿", name: "pinched fingers: dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((223, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "🤏", name: "pinching hand", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((229, SkinTone::Default)), aliases: Some(&["pinching_hand"]), variations: &[] },
    Emoji { emoji: "🤏🏻", name: "pinching hand: light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((229, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "🤏🏼", name: "pinching hand: medium-light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((229, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "🤏🏽", name: "pinching hand: medium skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((229, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "🤏🏾", name: "pinching hand: medium-dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((229, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "🤏🏿", name: "pinching hand: dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((229, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "✌️", name: "victory hand", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: Some((235, SkinTone::Default)), aliases: Some(&["v"]), variations: &["✌"] },
    Emoji { emoji: "✌🏻", name: "victory hand: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((235, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "✌🏼", name: "victory hand: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((235, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "✌🏽", name: "victory hand: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((235, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "✌🏾", name: "victory hand: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((235, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "✌🏿", name: "victory hand: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((235, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "🤞", name: "crossed fingers", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((241, SkinTone::Default)), aliases: Some(&["crossed_fingers"]), variations: &[] },
    Emoji { emoji: "🤞🏻", name: "crossed fingers: light skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((241, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "🤞🏼", name: "crossed fingers: medium-light skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((241, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "🤞🏽", name: "crossed fingers: medium skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((241, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "🤞🏾", name: "crossed fingers: medium-dark skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((241, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "🤞🏿", name: "crossed fingers: dark skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((241, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "🫰", name: "hand with index finger and thumb crossed", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((247, SkinTone::Default)), aliases: None, variations: &[] },
    Emoji { emoji: "🫰🏻", name: "hand with index finger and thumb crossed: light skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((247, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "🫰🏼", name: "hand with index finger and thumb crossed: medium-light skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((247, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "🫰🏽", name: "hand with index finger and thumb crossed: medium skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((247, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "🫰🏾", name: "hand with index finger and thumb crossed: medium-dark skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((247, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "🫰🏿", name: "hand with index finger and thumb crossed: dark skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((247, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "🤟", name: "love-you gesture", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((253, SkinTone::Default)), aliases: Some(&["love_you_gesture"]), variations: &[] },
    Emoji { emoji: "🤟🏻", name: "love-you gesture: light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((253, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "🤟🏼", name: "love-you gesture: medium-light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((253, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "🤟🏽", name: "love-you gesture: medium skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((253, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "🤟🏾", name: "love-you gesture: medium-dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((253, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "🤟🏿", name: "love-you gesture: dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((253, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "🤘", name: "sign of the horns", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((259, SkinTone::Default)), aliases: Some(&["metal"]), variations: &[] },
    Emoji { emoji: "🤘🏻", name: "sign of the horns: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((259, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "🤘🏼", name: "sign of the horns: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((259, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "🤘🏽", name: "sign of the horns: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((259, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "🤘🏾", name: "sign of the horns: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((259, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "🤘🏿", name: "sign of the horns: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((259, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "🤙", name: "call me hand", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((265, SkinTone::Default)), aliases: Some(&["call_me_hand"]), variations: &[] },
    Emoji { emoji: "🤙🏻", name: "call me hand: light skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((265, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "🤙🏼", name: "call me hand: medium-light skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((265, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "🤙🏽", name: "call me hand: medium skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((265, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "🤙🏾", name: "call me hand: medium-dark skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((265, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "🤙🏿", name: "call me hand: dark skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((265, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "👈", name: "backhand index pointing left", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: Some((271, SkinTone::Default)), aliases: Some(&["point_left"]), variations: &[] },
    Emoji { emoji: "👈🏻", name: "backhand index pointing left: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((271, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "👈🏼", name: "backhand index pointing left: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((271, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "👈🏽", name: "backhand index pointing left: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((271, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "👈🏾", name: "backhand index pointing left: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((271, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "👈🏿", name: "backhand index pointing left: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((271, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "👉", name: "backhand index pointing right", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: Some((277, SkinTone::Default)), aliases: Some(&["point_right"]), variations: &[] },
    Emoji { emoji: "👉🏻", name: "backhand index pointing right: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((277, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "👉🏼", name: "backhand index pointing right: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((277, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "👉🏽", name: "backhand index pointing right: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((277, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "👉🏾", name: "backhand index pointing right: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((277, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "👉🏿", name: "backhand index pointing right: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((277, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "👆", name: "backhand index pointing up", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: Some((283, SkinTone::Default)), aliases: Some(&["point_up_2"]), variations: &[] },
    Emoji { emoji: "👆🏻", name: "backhand index pointing up: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((283, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "👆🏼", name: "backhand index pointing up: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((283, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "👆🏽", name: "backhand index pointing up: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((283, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "👆🏾", name: "backhand index pointing up: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((283, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "👆🏿", name: "backhand index pointing up: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((283, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "🖕", name: "middle finger", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((289, SkinTone::Default)), aliases: Some(&["middle_finger", "fu"]), variations: &[] },
    Emoji { emoji: "🖕🏻", name: "middle finger: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((289, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "🖕🏼", name: "middle finger: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((289, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "🖕🏽", name: "middle finger: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((289, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "🖕🏾", name: "middle finger: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((289, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "🖕🏿", name: "middle finger: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((289, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "👇", name: "backhand index pointing down", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: Some((295, SkinTone::Default)), aliases: Some(&["point_down"]), variations: &[] },
    Emoji { emoji: "👇🏻", name: "backhand index pointing down: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((295, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "👇🏼", name: "backhand index pointing down: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((295, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "👇🏽", name: "backhand index pointing down: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((295, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "👇🏾", name: "backhand index pointing down: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((295, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "👇🏿", name: "backhand index pointing down: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((295, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "☝️", name: "index pointing up", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: Some((301, SkinTone::Default)), aliases: Some(&["point_up"]), variations: &["☝"] },
    Emoji { emoji: "☝🏻", name: "index pointing up: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((301, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "☝🏼", name: "index pointing up: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((301, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "☝🏽", name: "index pointing up: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((301, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "☝🏾", name: "index pointing up: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((301, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "☝🏿", name: "index pointing up: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((301, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "🫵", name: "index pointing at the viewer", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((307, SkinTone::Default)), aliases: None, variations: &[] },
    Emoji { emoji: "🫵🏻", name: "index pointing at the viewer: light skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((307, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "🫵🏼", name: "index pointing at the viewer: medium-light skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((307, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "🫵🏽", name: "index pointing at the viewer: medium skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((307, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "🫵🏾", name: "index pointing at the viewer: medium-dark skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((307, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "🫵🏿", name: "index pointing at the viewer: dark skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((307, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "👍", name: "thumbs up", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: Some((313, SkinTone::Default)), aliases: Some(&["+1", "thumbsup"]), variations: &[] },
    Emoji { emoji: "👍🏻", name: "thumbs up: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((313, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "👍🏼", name: "thumbs up: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((313, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "👍🏽", name: "thumbs up: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((313, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "👍🏾", name: "thumbs up: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((313, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "👍🏿", name: "thumbs up: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((313, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "👎", name: "thumbs down", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: Some((319, SkinTone::Default)), aliases: Some(&["-1", "thumbsdown"]), variations: &[] },
    Emoji { emoji: "👎🏻", name: "thumbs down: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((319, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "👎🏼", name: "thumbs down: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((319, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "👎🏽", name: "thumbs down: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((319, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "👎🏾", name: "thumbs down: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((319, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "👎🏿", name: "thumbs down: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((319, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "✊", name: "raised fist", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: Some((325, SkinTone::Default)), aliases: Some(&["fist_raised", "fist"]), variations: &[] },
    Emoji { emoji: "✊🏻", name: "raised fist: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((325, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "✊🏼", name: "raised fist: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((325, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "✊🏽", name: "raised fist: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((325, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "✊🏾", name: "raised fist: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((325, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "✊🏿", name: "raised fist: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((325, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "👊", name: "oncoming fist", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: Some((331, SkinTone::Default)), aliases: Some(&["fist_oncoming", "facepunch", "punch"]), variations: &[] },
    Emoji { emoji: "👊🏻", name: "oncoming fist: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((331, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "👊🏼", name: "oncoming fist: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((331, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "👊🏽", name: "oncoming fist: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((331, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "👊🏾", name: "oncoming fist: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((331, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "👊🏿", name: "oncoming fist: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((331, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "🤛", name: "left-facing fist", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((337, SkinTone::Default)), aliases: Some(&["fist_left"]), variations: &[] },
    Emoji { emoji: "🤛🏻", name: "left-facing fist: light skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((337, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "🤛🏼", name: "left-facing fist: medium-light skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((337, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "🤛🏽", name: "left-facing fist: medium skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((337, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "🤛🏾", name: "left-facing fist: medium-dark skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((337, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "🤛🏿", name: "left-facing fist: dark skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((337, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "🤜", name: "right-facing fist", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((343, SkinTone::Default)), aliases: Some(&["fist_right"]), variations: &[] },
    Emoji { emoji: "🤜🏻", name: "right-facing fist: light skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((343, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "🤜🏼", name: "right-facing fist: medium-light skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((343, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "🤜🏽", name: "right-facing fist: medium skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((343, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "🤜🏾", name: "right-facing fist: medium-dark skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((343, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "🤜🏿", name: "right-facing fist: dark skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((343, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "👏", name: "clapping hands", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: Some((349, SkinTone::Default)), aliases: Some(&["clap"]), variations: &[] },
    Emoji { emoji: "👏🏻", name: "clapping hands: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((349, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "👏🏼", name: "clapping hands: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((349, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "👏🏽", name: "clapping hands: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((349, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "👏🏾", name: "clapping hands: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((349, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "👏🏿", name: "clapping hands: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((349, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "🙌", name: "raising hands", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: Some((355, SkinTone::Default)), aliases: Some(&["raised_hands"]), variations: &[] },
    Emoji { emoji: "🙌🏻", name: "raising hands: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((355, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "🙌🏼", name: "raising hands: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((355, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "🙌🏽", name: "raising hands: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((355, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "🙌🏾", name: "raising hands: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((355, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "🙌🏿", name: "raising hands: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((355, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "🫶", name: "heart hands", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((361, SkinTone::Default)), aliases: None, variations: &[] },
    Emoji { emoji: "🫶🏻", name: "heart hands: light skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((361, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "🫶🏼", name: "heart hands: medium-light skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((361, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "🫶🏽", name: "heart hands: medium skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((361, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "🫶🏾", name: "heart hands: medium-dark skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((361, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "🫶🏿", name: "heart hands: dark skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((361, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "👐", name: "open hands", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: Some((367, SkinTone::Default)), aliases: Some(&["open_hands"]), variations: &[] },
    Emoji { emoji: "👐🏻", name: "open hands: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((367, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "👐🏼", name: "open hands: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((367, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "👐🏽", name: "open hands: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((367, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "👐🏾", name: "open hands: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((367, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "👐🏿", name: "open hands: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((367, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "🤲", name: "palms up together", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((373, SkinTone::Default)), aliases: Some(&["palms_up_together"]), variations: &[] },
    Emoji { emoji: "🤲🏻", name: "palms up together: light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((373, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "🤲🏼", name: "palms up together: medium-light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((373, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "🤲🏽", name: "palms up together: medium skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((373, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "🤲🏾", name: "palms up together: medium-dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((373, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "🤲🏿", name: "palms up together: dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((373, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "🤝", name: "handshake", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((379, SkinTone::Default)), aliases: Some(&["handshake"]), variations: &["🫱🏻\u{200d}🫲🏼", "🫱🏻\u{200d}🫲🏽", "🫱🏻\u{200d}🫲🏾", "🫱🏻\u{200d}🫲🏿", "🫱🏼\u{200d}🫲🏻", "🫱🏼\u{200d}🫲🏽", "🫱🏼\u{200d}🫲🏾", "🫱🏼\u{200d}🫲🏿", "🫱🏽\u{200d}🫲🏻", "🫱🏽\u{200d}🫲🏼", "🫱🏽\u{200d}🫲🏾", "🫱🏽\u{200d}🫲🏿", "🫱🏾\u{200d}🫲🏻", "🫱🏾\u{200d}🫲🏼", "🫱🏾\u{200d}🫲🏽", "🫱🏾\u{200d}🫲🏿", "🫱🏿\u{200d}🫲🏻", "🫱🏿\u{200d}🫲🏼", "🫱🏿\u{200d}🫲🏽", "🫱🏿\u{200d}🫲🏾"] },
    Emoji { emoji: "🤝🏻", name: "handshake: light skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((379, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "🤝🏼", name: "handshake: medium-light skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((379, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "🤝🏽", name: "handshake: medium skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((379, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "🤝🏾", name: "handshake: medium-dark skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((379, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "🤝🏿", name: "handshake: dark skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((379, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "🙏", name: "folded hands", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: Some((385, SkinTone::Default)), aliases: Some(&["pray"]), variations: &[] },
    Emoji { emoji: "🙏🏻", name: "folded hands: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((385, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "🙏🏼", name: "folded hands: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((385, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "🙏🏽", name: "folded hands: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((385, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "🙏🏾", name: "folded hands: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((385, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "🙏🏿", name: "folded hands: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((385, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "✍️", name: "writing hand", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::PeopleAndBody, skin_tone: Some((391, SkinTone::Default)), aliases: Some(&["writing_hand"]), variations: &["✍"] },
    Emoji { emoji: "✍🏻", name: "writing hand: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((391, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "✍🏼", name: "writing hand: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((391, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "✍🏽", name: "writing hand: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((391, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "✍🏾", name: "writing hand: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((391, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "✍🏿", name: "writing hand: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((391, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "💅", name: "nail polish", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: Some((397, SkinTone::Default)), aliases: Some(&["nail_care"]), variations: &[] },
    Emoji { emoji: "💅🏻", name: "nail polish: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((397, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "💅🏼", name: "nail polish: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((397, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "💅🏽", name: "nail polish: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((397, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "💅🏾", name: "nail polish: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((397, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "💅🏿", name: "nail polish: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((397, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "🤳", name: "selfie", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((403, SkinTone::Default)), aliases: Some(&["selfie"]), variations: &[] },
    Emoji { emoji: "🤳🏻", name: "selfie: light skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((403, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "🤳🏼", name: "selfie: medium-light skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((403, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "🤳🏽", name: "selfie: medium skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((403, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "🤳🏾", name: "selfie: medium-dark skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((403, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "🤳🏿", name: "selfie: dark skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((403, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "💪", name: "flexed biceps", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: Some((409, SkinTone::Default)), aliases: Some(&["muscle"]), variations: &[] },
    Emoji { emoji: "💪🏻", name: "flexed biceps: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((409, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "💪🏼", name: "flexed biceps: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((409, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "💪🏽", name: "flexed biceps: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((409, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "💪🏾", name: "flexed biceps: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((409, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "💪🏿", name: "flexed biceps: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((409, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "🦾", name: "mechanical arm", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["mechanical_arm"]), variations: &[] },
    Emoji { emoji: "🦿", name: "mechanical leg", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["mechanical_leg"]), variations: &[] },
    Emoji { emoji: "🦵", name: "leg", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((417, SkinTone::Default)), aliases: Some(&["leg"]), variations: &[] },
    Emoji { emoji: "🦵🏻", name: "leg: light skin tone", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((417, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "🦵🏼", name: "leg: medium-light skin tone", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((417, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "🦵🏽", name: "leg: medium skin tone", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((417, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "🦵🏾", name: "leg: medium-dark skin tone", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((417, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "🦵🏿", name: "leg: dark skin tone", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((417, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "🦶", name: "foot", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((423, SkinTone::Default)), aliases: Some(&["foot"]), variations: &[] },
    Emoji { emoji: "🦶🏻", name: "foot: light skin tone", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((423, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "🦶🏼", name: "foot: medium-light skin tone", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((423, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "🦶🏽", name: "foot: medium skin tone", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((423, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "🦶🏾", name: "foot: medium-dark skin tone", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((423, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "🦶🏿", name: "foot: dark skin tone", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((423, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "👂", name: "ear", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: Some((429, SkinTone::Default)), aliases: Some(&["ear"]), variations: &[] },
    Emoji { emoji: "👂🏻", name: "ear: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((429, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "👂🏼", name: "ear: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((429, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "👂🏽", name: "ear: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((429, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "👂🏾", name: "ear: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((429, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "👂🏿", name: "ear: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((429, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "🦻", name: "ear with hearing aid", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((435, SkinTone::Default)), aliases: Some(&["ear_with_hearing_aid"]), variations: &[] },
    Emoji { emoji: "🦻🏻", name: "ear with hearing aid: light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((435, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "🦻🏼", name: "ear with hearing aid: medium-light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((435, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "🦻🏽", name: "ear with hearing aid: medium skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((435, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "🦻🏾", name: "ear with hearing aid: medium-dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((435, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "🦻🏿", name: "ear with hearing aid: dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((435, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "👃", name: "nose", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: Some((441, SkinTone::Default)), aliases: Some(&["nose"]), variations: &[] },
    Emoji { emoji: "👃🏻", name: "nose: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((441, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "👃🏼", name: "nose: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((441, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "👃🏽", name: "nose: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((441, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "👃🏾", name: "nose: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((441, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "👃🏿", name: "nose: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((441, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "🧠", name: "brain", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["brain"]), variations: &[] },
    Emoji { emoji: "🫀", name: "anatomical heart", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["anatomical_heart"]), variations: &[] },
    Emoji { emoji: "🫁", name: "lungs", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["lungs"]), variations: &[] },
    Emoji { emoji: "🦷", name: "tooth", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["tooth"]), variations: &[] },
    Emoji { emoji: "🦴", name: "bone", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["bone"]), variations: &[] },
    Emoji { emoji: "👀", name: "eyes", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["eyes"]), variations: &[] },
    Emoji { emoji: "👁️", name: "eye", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["eye"]), variations: &["👁"] },
    Emoji { emoji: "👅", name: "tongue", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["tongue"]), variations: &[] },
    Emoji { emoji: "👄", name: "mouth", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["lips"]), variations: &[] },
    Emoji { emoji: "🫦", name: "biting lip", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: None, aliases: None, variations: &[] },
    Emoji { emoji: "👶", name: "baby", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: Some((457, SkinTone::Default)), aliases: Some(&["baby"]), variations: &[] },
    Emoji { emoji: "👶🏻", name: "baby: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((457, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "👶🏼", name: "baby: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((457, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "👶🏽", name: "baby: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((457, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "👶🏾", name: "baby: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((457, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "👶🏿", name: "baby: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((457, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "🧒", name: "child", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((463, SkinTone::Default)), aliases: Some(&["child"]), variations: &[] },
    Emoji { emoji: "🧒🏻", name: "child: light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((463, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "🧒🏼", name: "child: medium-light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((463, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "🧒🏽", name: "child: medium skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((463, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "🧒🏾", name: "child: medium-dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((463, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "🧒🏿", name: "child: dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((463, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "👦", name: "boy", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: Some((469, SkinTone::Default)), aliases: Some(&["boy"]), variations: &[] },
    Emoji { emoji: "👦🏻", name: "boy: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((469, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "👦🏼", name: "boy: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((469, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "👦🏽", name: "boy: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((469, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "👦🏾", name: "boy: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((469, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "👦🏿", name: "boy: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((469, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "👧", name: "girl", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: Some((475, SkinTone::Default)), aliases: Some(&["girl"]), variations: &[] },
    Emoji { emoji: "👧🏻", name: "girl: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((475, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "👧🏼", name: "girl: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((475, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "👧🏽", name: "girl: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((475, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "👧🏾", name: "girl: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((475, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "👧🏿", name: "girl: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((475, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "🧑", name: "person", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((481, SkinTone::Default)), aliases: Some(&["adult"]), variations: &[] },
    Emoji { emoji: "🧑🏻", name: "person: light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((481, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "🧑🏼", name: "person: medium-light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((481, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "🧑🏽", name: "person: medium skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((481, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "🧑🏾", name: "person: medium-dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((481, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "🧑🏿", name: "person: dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((481, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "👱", name: "person: blond hair", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: Some((487, SkinTone::Default)), aliases: Some(&["blond_haired_person"]), variations: &[] },
    Emoji { emoji: "👱🏻", name: "person: light skin tone, blond hair", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((487, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "👱🏼", name: "person: medium-light skin tone, blond hair", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((487, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "👱🏽", name: "person: medium skin tone, blond hair", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((487, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "👱🏾", name: "person: medium-dark skin tone, blond hair", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((487, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "👱🏿", name: "person: dark skin tone, blond hair", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((487, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "👨", name: "man", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: Some((493, SkinTone::Default)), aliases: Some(&["man"]), variations: &[] },
    Emoji { emoji: "👨🏻", name: "man: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((493, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "👨🏼", name: "man: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((493, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "👨🏽", name: "man: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((493, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "👨🏾", name: "man: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((493, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "👨🏿", name: "man: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((493, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "🧔", name: "person: beard", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((499, SkinTone::Default)), aliases: Some(&["bearded_person"]), variations: &[] },
    Emoji { emoji: "🧔🏻", name: "person: light skin tone, beard", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((499, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "🧔🏼", name: "person: medium-light skin tone, beard", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((499, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "🧔🏽", name: "person: medium skin tone, beard", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((499, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "🧔🏾", name: "person: medium-dark skin tone, beard", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((499, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "🧔🏿", name: "person: dark skin tone, beard", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((499, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "🧔‍♂️", name: "man: beard", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((505, SkinTone::Default)), aliases: None, variations: &["🧔\u{200d}♂"] },
    Emoji { emoji: "🧔🏻‍♂️", name: "man: light skin tone, beard", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((505, SkinTone::Light)), aliases: None, variations: &["🧔🏻\u{200d}♂"] },
    Emoji { emoji: "🧔🏼‍♂️", name: "man: medium-light skin tone, beard", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((505, SkinTone::MediumLight)), aliases: None, variations: &["🧔🏼\u{200d}♂"] },
    Emoji { emoji: "🧔🏽‍♂️", name: "man: medium skin tone, beard", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((505, SkinTone::Medium)), aliases: None, variations: &["🧔🏽\u{200d}♂"] },
    Emoji { emoji: "🧔🏾‍♂️", name: "man: medium-dark skin tone, beard", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((505, SkinTone::MediumDark)), aliases: None, variations: &["🧔🏾\u{200d}♂"] },
    Emoji { emoji: "🧔🏿‍♂️", name: "man: dark skin tone, beard", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((505, SkinTone::Dark)), aliases: None, variations: &["🧔🏿\u{200d}♂"] },
    Emoji { emoji: "🧔‍♀️", name: "woman: beard", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((511, SkinTone::Default)), aliases: None, variations: &["🧔\u{200d}♀"] },
    Emoji { emoji: "🧔🏻‍♀️", name: "woman: light skin tone, beard", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((511, SkinTone::Light)), aliases: None, variations: &["🧔🏻\u{200d}♀"] },
    Emoji { emoji: "🧔🏼‍♀️", name: "woman: medium-light skin tone, beard", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((511, SkinTone::MediumLight)), aliases: None, variations: &["🧔🏼\u{200d}♀"] },
    Emoji { emoji: "🧔🏽‍♀️", name: "woman: medium skin tone, beard", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((511, SkinTone::Medium)), aliases: None, variations: &["🧔🏽\u{200d}♀"] },
    Emoji { emoji: "🧔🏾‍♀️", name: "woman: medium-dark skin tone, beard", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((511, SkinTone::MediumDark)), aliases: None, variations: &["🧔🏾\u{200d}♀"] },
    Emoji { emoji: "🧔🏿‍♀️", name: "woman: dark skin tone, beard", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((511, SkinTone::Dark)), aliases: None, variations: &["🧔🏿\u{200d}♀"] },
    Emoji { emoji: "👨‍🦰", name: "man: red hair", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((517, SkinTone::Default)), aliases: Some(&["red_haired_man"]), variations: &[] },
    Emoji { emoji: "👨🏻‍🦰", name: "man: light skin tone, red hair", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((517, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "👨🏼‍🦰", name: "man: medium-light skin tone, red hair", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((517, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "👨🏽‍🦰", name: "man: medium skin tone, red hair", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((517, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "👨🏾‍🦰", name: "man: medium-dark skin tone, red hair", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((517, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "👨🏿‍🦰", name: "man: dark skin tone, red hair", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((517, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "👨‍🦱", name: "man: curly hair", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((523, SkinTone::Default)), aliases: Some(&["curly_haired_man"]), variations: &[] },
    Emoji { emoji: "👨🏻‍🦱", name: "man: light skin tone, curly hair", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((523, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "👨🏼‍🦱", name: "man: medium-light skin tone, curly hair", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((523, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "👨🏽‍🦱", name: "man: medium skin tone, curly hair", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((523, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "👨🏾‍🦱", name: "man: medium-dark skin tone, curly hair", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((523, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "👨🏿‍🦱", name: "man: dark skin tone, curly hair", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((523, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "👨‍🦳", name: "man: white hair", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((529, SkinTone::Default)), aliases: Some(&["white_haired_man"]), variations: &[] },
    Emoji { emoji: "👨🏻‍🦳", name: "man: light skin tone, white hair", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((529, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "👨🏼‍🦳", name: "man: medium-light skin tone, white hair", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((529, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "👨🏽‍🦳", name: "man: medium skin tone, white hair", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((529, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "👨🏾‍🦳", name: "man: medium-dark skin tone, white hair", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((529, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "👨🏿‍🦳", name: "man: dark skin tone, white hair", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((529, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "👨‍🦲", name: "man: bald", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((535, SkinTone::Default)), aliases: Some(&["bald_man"]), variations: &[] },
    Emoji { emoji: "👨🏻‍🦲", name: "man: light skin tone, bald", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((535, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "👨🏼‍🦲", name: "man: medium-light skin tone, bald", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((535, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "👨🏽‍🦲", name: "man: medium skin tone, bald", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((535, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "👨🏾‍🦲", name: "man: medium-dark skin tone, bald", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((535, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "👨🏿‍🦲", name: "man: dark skin tone, bald", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((535, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "👩", name: "woman", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: Some((541, SkinTone::Default)), aliases: Some(&["woman"]), variations: &[] },
    Emoji { emoji: "👩🏻", name: "woman: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((541, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "👩🏼", name: "woman: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((541, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "👩🏽", name: "woman: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((541, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "👩🏾", name: "woman: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((541, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "👩🏿", name: "woman: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((541, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "👩‍🦰", name: "woman: red hair", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((547, SkinTone::Default)), aliases: Some(&["red_haired_woman"]), variations: &[] },
    Emoji { emoji: "👩🏻‍🦰", name: "woman: light skin tone, red hair", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((547, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "👩🏼‍🦰", name: "woman: medium-light skin tone, red hair", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((547, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "👩🏽‍🦰", name: "woman: medium skin tone, red hair", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((547, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "👩🏾‍🦰", name: "woman: medium-dark skin tone, red hair", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((547, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "👩🏿‍🦰", name: "woman: dark skin tone, red hair", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((547, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "🧑‍🦰", name: "person: red hair", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((553, SkinTone::Default)), aliases: Some(&["person_red_hair"]), variations: &[] },
    Emoji { emoji: "🧑🏻‍🦰", name: "person: light skin tone, red hair", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((553, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "🧑🏼‍🦰", name: "person: medium-light skin tone, red hair", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((553, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "🧑🏽‍🦰", name: "person: medium skin tone, red hair", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((553, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "🧑🏾‍🦰", name: "person: medium-dark skin tone, red hair", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((553, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "🧑🏿‍🦰", name: "person: dark skin tone, red hair", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((553, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "👩‍🦱", name: "woman: curly hair", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((559, SkinTone::Default)), aliases: Some(&["curly_haired_woman"]), variations: &[] },
    Emoji { emoji: "👩🏻‍🦱", name: "woman: light skin tone, curly hair", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((559, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "👩🏼‍🦱", name: "woman: medium-light skin tone, curly hair", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((559, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "👩🏽‍🦱", name: "woman: medium skin tone, curly hair", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((559, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "👩🏾‍🦱", name: "woman: medium-dark skin tone, curly hair", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((559, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "👩🏿‍🦱", name: "woman: dark skin tone, curly hair", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((559, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "🧑‍🦱", name: "person: curly hair", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((565, SkinTone::Default)), aliases: Some(&["person_curly_hair"]), variations: &[] },
    Emoji { emoji: "🧑🏻‍🦱", name: "person: light skin tone, curly hair", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((565, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "🧑🏼‍🦱", name: "person: medium-light skin tone, curly hair", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((565, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "🧑🏽‍🦱", name: "person: medium skin tone, curly hair", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((565, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "🧑🏾‍🦱", name: "person: medium-dark skin tone, curly hair", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((565, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "🧑🏿‍🦱", name: "person: dark skin tone, curly hair", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((565, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "👩‍🦳", name: "woman: white hair", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((571, SkinTone::Default)), aliases: Some(&["white_haired_woman"]), variations: &[] },
    Emoji { emoji: "👩🏻‍🦳", name: "woman: light skin tone, white hair", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((571, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "👩🏼‍🦳", name: "woman: medium-light skin tone, white hair", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((571, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "👩🏽‍🦳", name: "woman: medium skin tone, white hair", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((571, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "👩🏾‍🦳", name: "woman: medium-dark skin tone, white hair", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((571, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "👩🏿‍🦳", name: "woman: dark skin tone, white hair", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((571, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "🧑‍🦳", name: "person: white hair", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((577, SkinTone::Default)), aliases: Some(&["person_white_hair"]), variations: &[] },
    Emoji { emoji: "🧑🏻‍🦳", name: "person: light skin tone, white hair", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((577, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "🧑🏼‍🦳", name: "person: medium-light skin tone, white hair", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((577, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "🧑🏽‍🦳", name: "person: medium skin tone, white hair", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((577, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "🧑🏾‍🦳", name: "person: medium-dark skin tone, white hair", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((577, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "🧑🏿‍🦳", name: "person: dark skin tone, white hair", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((577, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "👩‍🦲", name: "woman: bald", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((583, SkinTone::Default)), aliases: Some(&["bald_woman"]), variations: &[] },
    Emoji { emoji: "👩🏻‍🦲", name: "woman: light skin tone, bald", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((583, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "👩🏼‍🦲", name: "woman: medium-light skin tone, bald", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((583, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "👩🏽‍🦲", name: "woman: medium skin tone, bald", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((583, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "👩🏾‍🦲", name: "woman: medium-dark skin tone, bald", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((583, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "👩🏿‍🦲", name: "woman: dark skin tone, bald", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((583, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "🧑‍🦲", name: "person: bald", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((589, SkinTone::Default)), aliases: Some(&["person_bald"]), variations: &[] },
    Emoji { emoji: "🧑🏻‍🦲", name: "person: light skin tone, bald", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((589, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "🧑🏼‍🦲", name: "person: medium-light skin tone, bald", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((589, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "🧑🏽‍🦲", name: "person: medium skin tone, bald", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((589, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "🧑🏾‍🦲", name: "person: medium-dark skin tone, bald", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((589, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "🧑🏿‍🦲", name: "person: dark skin tone, bald", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((589, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "👱‍♀️", name: "woman: blond hair", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((595, SkinTone::Default)), aliases: Some(&["blond_haired_woman", "blonde_woman"]), variations: &["👱\u{200d}♀"] },
    Emoji { emoji: "👱🏻‍♀️", name: "woman: light skin tone, blond hair", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((595, SkinTone::Light)), aliases: None, variations: &["👱🏻\u{200d}♀"] },
    Emoji { emoji: "👱🏼‍♀️", name: "woman: medium-light skin tone, blond hair", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((595, SkinTone::MediumLight)), aliases: None, variations: &["👱🏼\u{200d}♀"] },
    Emoji { emoji: "👱🏽‍♀️", name: "woman: medium skin tone, blond hair", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((595, SkinTone::Medium)), aliases: None, variations: &["👱🏽\u{200d}♀"] },
    Emoji { emoji: "👱🏾‍♀️", name: "woman: medium-dark skin tone, blond hair", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((595, SkinTone::MediumDark)), aliases: None, variations: &["👱🏾\u{200d}♀"] },
    Emoji { emoji: "👱🏿‍♀️", name: "woman: dark skin tone, blond hair", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((595, SkinTone::Dark)), aliases: None, variations: &["👱🏿\u{200d}♀"] },
    Emoji { emoji: "👱‍♂️", name: "man: blond hair", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((601, SkinTone::Default)), aliases: Some(&["blond_haired_man"]), variations: &["👱\u{200d}♂"] },
    Emoji { emoji: "👱🏻‍♂️", name: "man: light skin tone, blond hair", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((601, SkinTone::Light)), aliases: None, variations: &["👱🏻\u{200d}♂"] },
    Emoji { emoji: "👱🏼‍♂️", name: "man: medium-light skin tone, blond hair", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((601, SkinTone::MediumLight)), aliases: None, variations: &["👱🏼\u{200d}♂"] },
    Emoji { emoji: "👱🏽‍♂️", name: "man: medium skin tone, blond hair", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((601, SkinTone::Medium)), aliases: None, variations: &["👱🏽\u{200d}♂"] },
    Emoji { emoji: "👱🏾‍♂️", name: "man: medium-dark skin tone, blond hair", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((601, SkinTone::MediumDark)), aliases: None, variations: &["👱🏾\u{200d}♂"] },
    Emoji { emoji: "👱🏿‍♂️", name: "man: dark skin tone, blond hair", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((601, SkinTone::Dark)), aliases: None, variations: &["👱🏿\u{200d}♂"] },
    Emoji { emoji: "🧓", name: "older person", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((607, SkinTone::Default)), aliases: Some(&["older_adult"]), variations: &[] },
    Emoji { emoji: "🧓🏻", name: "older person: light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((607, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "🧓🏼", name: "older person: medium-light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((607, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "🧓🏽", name: "older person: medium skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((607, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "🧓🏾", name: "older person: medium-dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((607, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "🧓🏿", name: "older person: dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((607, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "👴", name: "old man", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: Some((613, SkinTone::Default)), aliases: Some(&["older_man"]), variations: &[] },
    Emoji { emoji: "👴🏻", name: "old man: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((613, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "👴🏼", name: "old man: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((613, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "👴🏽", name: "old man: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((613, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "👴🏾", name: "old man: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((613, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "👴🏿", name: "old man: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((613, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "👵", name: "old woman", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: Some((619, SkinTone::Default)), aliases: Some(&["older_woman"]), variations: &[] },
    Emoji { emoji: "👵🏻", name: "old woman: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((619, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "👵🏼", name: "old woman: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((619, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "👵🏽", name: "old woman: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((619, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "👵🏾", name: "old woman: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((619, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "👵🏿", name: "old woman: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((619, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "🙍", name: "person frowning", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: Some((625, SkinTone::Default)), aliases: Some(&["frowning_person"]), variations: &[] },
    Emoji { emoji: "🙍🏻", name: "person frowning: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((625, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "🙍🏼", name: "person frowning: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((625, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "🙍🏽", name: "person frowning: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((625, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "🙍🏾", name: "person frowning: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((625, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "🙍🏿", name: "person frowning: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((625, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "🙍‍♂️", name: "man frowning", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((631, SkinTone::Default)), aliases: Some(&["frowning_man"]), variations: &["🙍\u{200d}♂"] },
    Emoji { emoji: "🙍🏻‍♂️", name: "man frowning: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((631, SkinTone::Light)), aliases: None, variations: &["🙍🏻\u{200d}♂"] },
    Emoji { emoji: "🙍🏼‍♂️", name: "man frowning: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((631, SkinTone::MediumLight)), aliases: None, variations: &["🙍🏼\u{200d}♂"] },
    Emoji { emoji: "🙍🏽‍♂️", name: "man frowning: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((631, SkinTone::Medium)), aliases: None, variations: &["🙍🏽\u{200d}♂"] },
    Emoji { emoji: "🙍🏾‍♂️", name: "man frowning: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((631, SkinTone::MediumDark)), aliases: None, variations: &["🙍🏾\u{200d}♂"] },
    Emoji { emoji: "🙍🏿‍♂️", name: "man frowning: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((631, SkinTone::Dark)), aliases: None, variations: &["🙍🏿\u{200d}♂"] },
    Emoji { emoji: "🙍‍♀️", name: "woman frowning", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((637, SkinTone::Default)), aliases: Some(&["frowning_woman"]), variations: &["🙍\u{200d}♀"] },
    Emoji { emoji: "🙍🏻‍♀️", name: "woman frowning: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((637, SkinTone::Light)), aliases: None, variations: &["🙍🏻\u{200d}♀"] },
    Emoji { emoji: "🙍🏼‍♀️", name: "woman frowning: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((637, SkinTone::MediumLight)), aliases: None, variations: &["🙍🏼\u{200d}♀"] },
    Emoji { emoji: "🙍🏽‍♀️", name: "woman frowning: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((637, SkinTone::Medium)), aliases: None, variations: &["🙍🏽\u{200d}♀"] },
    Emoji { emoji: "🙍🏾‍♀️", name: "woman frowning: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((637, SkinTone::MediumDark)), aliases: None, variations: &["🙍🏾\u{200d}♀"] },
    Emoji { emoji: "🙍🏿‍♀️", name: "woman frowning: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((637, SkinTone::Dark)), aliases: None, variations: &["🙍🏿\u{200d}♀"] },
    Emoji { emoji: "🙎", name: "person pouting", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: Some((643, SkinTone::Default)), aliases: Some(&["pouting_face"]), variations: &[] },
    Emoji { emoji: "🙎🏻", name: "person pouting: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((643, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "🙎🏼", name: "person pouting: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((643, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "🙎🏽", name: "person pouting: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((643, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "🙎🏾", name: "person pouting: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((643, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "🙎🏿", name: "person pouting: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((643, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "🙎‍♂️", name: "man pouting", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((649, SkinTone::Default)), aliases: Some(&["pouting_man"]), variations: &["🙎\u{200d}♂"] },
    Emoji { emoji: "🙎🏻‍♂️", name: "man pouting: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((649, SkinTone::Light)), aliases: None, variations: &["🙎🏻\u{200d}♂"] },
    Emoji { emoji: "🙎🏼‍♂️", name: "man pouting: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((649, SkinTone::MediumLight)), aliases: None, variations: &["🙎🏼\u{200d}♂"] },
    Emoji { emoji: "🙎🏽‍♂️", name: "man pouting: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((649, SkinTone::Medium)), aliases: None, variations: &["🙎🏽\u{200d}♂"] },
    Emoji { emoji: "🙎🏾‍♂️", name: "man pouting: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((649, SkinTone::MediumDark)), aliases: None, variations: &["🙎🏾\u{200d}♂"] },
    Emoji { emoji: "🙎🏿‍♂️", name: "man pouting: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((649, SkinTone::Dark)), aliases: None, variations: &["🙎🏿\u{200d}♂"] },
    Emoji { emoji: "🙎‍♀️", name: "woman pouting", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((655, SkinTone::Default)), aliases: Some(&["pouting_woman"]), variations: &["🙎\u{200d}♀"] },
    Emoji { emoji: "🙎🏻‍♀️", name: "woman pouting: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((655, SkinTone::Light)), aliases: None, variations: &["🙎🏻\u{200d}♀"] },
    Emoji { emoji: "🙎🏼‍♀️", name: "woman pouting: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((655, SkinTone::MediumLight)), aliases: None, variations: &["🙎🏼\u{200d}♀"] },
    Emoji { emoji: "🙎🏽‍♀️", name: "woman pouting: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((655, SkinTone::Medium)), aliases: None, variations: &["🙎🏽\u{200d}♀"] },
    Emoji { emoji: "🙎🏾‍♀️", name: "woman pouting: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((655, SkinTone::MediumDark)), aliases: None, variations: &["🙎🏾\u{200d}♀"] },
    Emoji { emoji: "🙎🏿‍♀️", name: "woman pouting: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((655, SkinTone::Dark)), aliases: None, variations: &["🙎🏿\u{200d}♀"] },
    Emoji { emoji: "🙅", name: "person gesturing NO", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: Some((661, SkinTone::Default)), aliases: Some(&["no_good"]), variations: &[] },
    Emoji { emoji: "🙅🏻", name: "person gesturing NO: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((661, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "🙅🏼", name: "person gesturing NO: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((661, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "🙅🏽", name: "person gesturing NO: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((661, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "🙅🏾", name: "person gesturing NO: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((661, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "🙅🏿", name: "person gesturing NO: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((661, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "🙅‍♂️", name: "man gesturing NO", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((667, SkinTone::Default)), aliases: Some(&["no_good_man", "ng_man"]), variations: &["🙅\u{200d}♂"] },
    Emoji { emoji: "🙅🏻‍♂️", name: "man gesturing NO: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((667, SkinTone::Light)), aliases: None, variations: &["🙅🏻\u{200d}♂"] },
    Emoji { emoji: "🙅🏼‍♂️", name: "man gesturing NO: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((667, SkinTone::MediumLight)), aliases: None, variations: &["🙅🏼\u{200d}♂"] },
    Emoji { emoji: "🙅🏽‍♂️", name: "man gesturing NO: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((667, SkinTone::Medium)), aliases: None, variations: &["🙅🏽\u{200d}♂"] },
    Emoji { emoji: "🙅🏾‍♂️", name: "man gesturing NO: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((667, SkinTone::MediumDark)), aliases: None, variations: &["🙅🏾\u{200d}♂"] },
    Emoji { emoji: "🙅🏿‍♂️", name: "man gesturing NO: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((667, SkinTone::Dark)), aliases: None, variations: &["🙅🏿\u{200d}♂"] },
    Emoji { emoji: "🙅‍♀️", name: "woman gesturing NO", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((673, SkinTone::Default)), aliases: Some(&["no_good_woman", "ng_woman"]), variations: &["🙅\u{200d}♀"] },
    Emoji { emoji: "🙅🏻‍♀️", name: "woman gesturing NO: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((673, SkinTone::Light)), aliases: None, variations: &["🙅🏻\u{200d}♀"] },
    Emoji { emoji: "🙅🏼‍♀️", name: "woman gesturing NO: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((673, SkinTone::MediumLight)), aliases: None, variations: &["🙅🏼\u{200d}♀"] },
    Emoji { emoji: "🙅🏽‍♀️", name: "woman gesturing NO: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((673, SkinTone::Medium)), aliases: None, variations: &["🙅🏽\u{200d}♀"] },
    Emoji { emoji: "🙅🏾‍♀️", name: "woman gesturing NO: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((673, SkinTone::MediumDark)), aliases: None, variations: &["🙅🏾\u{200d}♀"] },
    Emoji { emoji: "🙅🏿‍♀️", name: "woman gesturing NO: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((673, SkinTone::Dark)), aliases: None, variations: &["🙅🏿\u{200d}♀"] },
    Emoji { emoji: "🙆", name: "person gesturing OK", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: Some((679, SkinTone::Default)), aliases: Some(&["ok_person"]), variations: &[] },
    Emoji { emoji: "🙆🏻", name: "person gesturing OK: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((679, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "🙆🏼", name: "person gesturing OK: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((679, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "🙆🏽", name: "person gesturing OK: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((679, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "🙆🏾", name: "person gesturing OK: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((679, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "🙆🏿", name: "person gesturing OK: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((679, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "🙆‍♂️", name: "man gesturing OK", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((685, SkinTone::Default)), aliases: Some(&["ok_man"]), variations: &["🙆\u{200d}♂"] },
    Emoji { emoji: "🙆🏻‍♂️", name: "man gesturing OK: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((685, SkinTone::Light)), aliases: None, variations: &["🙆🏻\u{200d}♂"] },
    Emoji { emoji: "🙆🏼‍♂️", name: "man gesturing OK: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((685, SkinTone::MediumLight)), aliases: None, variations: &["🙆🏼\u{200d}♂"] },
    Emoji { emoji: "🙆🏽‍♂️", name: "man gesturing OK: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((685, SkinTone::Medium)), aliases: None, variations: &["🙆🏽\u{200d}♂"] },
    Emoji { emoji: "🙆🏾‍♂️", name: "man gesturing OK: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((685, SkinTone::MediumDark)), aliases: None, variations: &["🙆🏾\u{200d}♂"] },
    Emoji { emoji: "🙆🏿‍♂️", name: "man gesturing OK: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((685, SkinTone::Dark)), aliases: None, variations: &["🙆🏿\u{200d}♂"] },
    Emoji { emoji: "🙆‍♀️", name: "woman gesturing OK", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((691, SkinTone::Default)), aliases: Some(&["ok_woman"]), variations: &["🙆\u{200d}♀"] },
    Emoji { emoji: "🙆🏻‍♀️", name: "woman gesturing OK: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((691, SkinTone::Light)), aliases: None, variations: &["🙆🏻\u{200d}♀"] },
    Emoji { emoji: "🙆🏼‍♀️", name: "woman gesturing OK: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((691, SkinTone::MediumLight)), aliases: None, variations: &["🙆🏼\u{200d}♀"] },
    Emoji { emoji: "🙆🏽‍♀️", name: "woman gesturing OK: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((691, SkinTone::Medium)), aliases: None, variations: &["🙆🏽\u{200d}♀"] },
    Emoji { emoji: "🙆🏾‍♀️", name: "woman gesturing OK: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((691, SkinTone::MediumDark)), aliases: None, variations: &["🙆🏾\u{200d}♀"] },
    Emoji { emoji: "🙆🏿‍♀️", name: "woman gesturing OK: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((691, SkinTone::Dark)), aliases: None, variations: &["🙆🏿\u{200d}♀"] },
    Emoji { emoji: "💁", name: "person tipping hand", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: Some((697, SkinTone::Default)), aliases: Some(&["tipping_hand_person", "information_desk_person"]), variations: &[] },
    Emoji { emoji: "💁🏻", name: "person tipping hand: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((697, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "💁🏼", name: "person tipping hand: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((697, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "💁🏽", name: "person tipping hand: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((697, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "💁🏾", name: "person tipping hand: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((697, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "💁🏿", name: "person tipping hand: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((697, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "💁‍♂️", name: "man tipping hand", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((703, SkinTone::Default)), aliases: Some(&["tipping_hand_man", "sassy_man"]), variations: &["💁\u{200d}♂"] },
    Emoji { emoji: "💁🏻‍♂️", name: "man tipping hand: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((703, SkinTone::Light)), aliases: None, variations: &["💁🏻\u{200d}♂"] },
    Emoji { emoji: "💁🏼‍♂️", name: "man tipping hand: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((703, SkinTone::MediumLight)), aliases: None, variations: &["💁🏼\u{200d}♂"] },
    Emoji { emoji: "💁🏽‍♂️", name: "man tipping hand: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((703, SkinTone::Medium)), aliases: None, variations: &["💁🏽\u{200d}♂"] },
    Emoji { emoji: "💁🏾‍♂️", name: "man tipping hand: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((703, SkinTone::MediumDark)), aliases: None, variations: &["💁🏾\u{200d}♂"] },
    Emoji { emoji: "💁🏿‍♂️", name: "man tipping hand: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((703, SkinTone::Dark)), aliases: None, variations: &["💁🏿\u{200d}♂"] },
    Emoji { emoji: "💁‍♀️", name: "woman tipping hand", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((709, SkinTone::Default)), aliases: Some(&["tipping_hand_woman", "sassy_woman"]), variations: &["💁\u{200d}♀"] },
    Emoji { emoji: "💁🏻‍♀️", name: "woman tipping hand: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((709, SkinTone::Light)), aliases: None, variations: &["💁🏻\u{200d}♀"] },
    Emoji { emoji: "💁🏼‍♀️", name: "woman tipping hand: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((709, SkinTone::MediumLight)), aliases: None, variations: &["💁🏼\u{200d}♀"] },
    Emoji { emoji: "💁🏽‍♀️", name: "woman tipping hand: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((709, SkinTone::Medium)), aliases: None, variations: &["💁🏽\u{200d}♀"] },
    Emoji { emoji: "💁🏾‍♀️", name: "woman tipping hand: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((709, SkinTone::MediumDark)), aliases: None, variations: &["💁🏾\u{200d}♀"] },
    Emoji { emoji: "💁🏿‍♀️", name: "woman tipping hand: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((709, SkinTone::Dark)), aliases: None, variations: &["💁🏿\u{200d}♀"] },
    Emoji { emoji: "🙋", name: "person raising hand", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: Some((715, SkinTone::Default)), aliases: Some(&["raising_hand"]), variations: &[] },
    Emoji { emoji: "🙋🏻", name: "person raising hand: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((715, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "🙋🏼", name: "person raising hand: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((715, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "🙋🏽", name: "person raising hand: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((715, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "🙋🏾", name: "person raising hand: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((715, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "🙋🏿", name: "person raising hand: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((715, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "🙋‍♂️", name: "man raising hand", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((721, SkinTone::Default)), aliases: Some(&["raising_hand_man"]), variations: &["🙋\u{200d}♂"] },
    Emoji { emoji: "🙋🏻‍♂️", name: "man raising hand: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((721, SkinTone::Light)), aliases: None, variations: &["🙋🏻\u{200d}♂"] },
    Emoji { emoji: "🙋🏼‍♂️", name: "man raising hand: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((721, SkinTone::MediumLight)), aliases: None, variations: &["🙋🏼\u{200d}♂"] },
    Emoji { emoji: "🙋🏽‍♂️", name: "man raising hand: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((721, SkinTone::Medium)), aliases: None, variations: &["🙋🏽\u{200d}♂"] },
    Emoji { emoji: "🙋🏾‍♂️", name: "man raising hand: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((721, SkinTone::MediumDark)), aliases: None, variations: &["🙋🏾\u{200d}♂"] },
    Emoji { emoji: "🙋🏿‍♂️", name: "man raising hand: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((721, SkinTone::Dark)), aliases: None, variations: &["🙋🏿\u{200d}♂"] },
    Emoji { emoji: "🙋‍♀️", name: "woman raising hand", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((727, SkinTone::Default)), aliases: Some(&["raising_hand_woman"]), variations: &["🙋\u{200d}♀"] },
    Emoji { emoji: "🙋🏻‍♀️", name: "woman raising hand: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((727, SkinTone::Light)), aliases: None, variations: &["🙋🏻\u{200d}♀"] },
    Emoji { emoji: "🙋🏼‍♀️", name: "woman raising hand: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((727, SkinTone::MediumLight)), aliases: None, variations: &["🙋🏼\u{200d}♀"] },
    Emoji { emoji: "🙋🏽‍♀️", name: "woman raising hand: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((727, SkinTone::Medium)), aliases: None, variations: &["🙋🏽\u{200d}♀"] },
    Emoji { emoji: "🙋🏾‍♀️", name: "woman raising hand: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((727, SkinTone::MediumDark)), aliases: None, variations: &["🙋🏾\u{200d}♀"] },
    Emoji { emoji: "🙋🏿‍♀️", name: "woman raising hand: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((727, SkinTone::Dark)), aliases: None, variations: &["🙋🏿\u{200d}♀"] },
    Emoji { emoji: "🧏", name: "deaf person", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((733, SkinTone::Default)), aliases: Some(&["deaf_person"]), variations: &[] },
    Emoji { emoji: "🧏🏻", name: "deaf person: light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((733, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "🧏🏼", name: "deaf person: medium-light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((733, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "🧏🏽", name: "deaf person: medium skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((733, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "🧏🏾", name: "deaf person: medium-dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((733, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "🧏🏿", name: "deaf person: dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((733, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "🧏‍♂️", name: "deaf man", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((739, SkinTone::Default)), aliases: Some(&["deaf_man"]), variations: &["🧏\u{200d}♂"] },
    Emoji { emoji: "🧏🏻‍♂️", name: "deaf man: light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((739, SkinTone::Light)), aliases: None, variations: &["🧏🏻\u{200d}♂"] },
    Emoji { emoji: "🧏🏼‍♂️", name: "deaf man: medium-light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((739, SkinTone::MediumLight)), aliases: None, variations: &["🧏🏼\u{200d}♂"] },
    Emoji { emoji: "🧏🏽‍♂️", name: "deaf man: medium skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((739, SkinTone::Medium)), aliases: None, variations: &["🧏🏽\u{200d}♂"] },
    Emoji { emoji: "🧏🏾‍♂️", name: "deaf man: medium-dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((739, SkinTone::MediumDark)), aliases: None, variations: &["🧏🏾\u{200d}♂"] },
    Emoji { emoji: "🧏🏿‍♂️", name: "deaf man: dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((739, SkinTone::Dark)), aliases: None, variations: &["🧏🏿\u{200d}♂"] },
    Emoji { emoji: "🧏‍♀️", name: "deaf woman", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((745, SkinTone::Default)), aliases: Some(&["deaf_woman"]), variations: &["🧏\u{200d}♀"] },
    Emoji { emoji: "🧏🏻‍♀️", name: "deaf woman: light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((745, SkinTone::Light)), aliases: None, variations: &["🧏🏻\u{200d}♀"] },
    Emoji { emoji: "🧏🏼‍♀️", name: "deaf woman: medium-light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((745, SkinTone::MediumLight)), aliases: None, variations: &["🧏🏼\u{200d}♀"] },
    Emoji { emoji: "🧏🏽‍♀️", name: "deaf woman: medium skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((745, SkinTone::Medium)), aliases: None, variations: &["🧏🏽\u{200d}♀"] },
    Emoji { emoji: "🧏🏾‍♀️", name: "deaf woman: medium-dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((745, SkinTone::MediumDark)), aliases: None, variations: &["🧏🏾\u{200d}♀"] },
    Emoji { emoji: "🧏🏿‍♀️", name: "deaf woman: dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((745, SkinTone::Dark)), aliases: None, variations: &["🧏🏿\u{200d}♀"] },
    Emoji { emoji: "🙇", name: "person bowing", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: Some((751, SkinTone::Default)), aliases: Some(&["bow"]), variations: &[] },
    Emoji { emoji: "🙇🏻", name: "person bowing: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((751, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "🙇🏼", name: "person bowing: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((751, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "🙇🏽", name: "person bowing: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((751, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "🙇🏾", name: "person bowing: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((751, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "🙇🏿", name: "person bowing: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((751, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "🙇‍♂️", name: "man bowing", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((757, SkinTone::Default)), aliases: Some(&["bowing_man"]), variations: &["🙇\u{200d}♂"] },
    Emoji { emoji: "🙇🏻‍♂️", name: "man bowing: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((757, SkinTone::Light)), aliases: None, variations: &["🙇🏻\u{200d}♂"] },
    Emoji { emoji: "🙇🏼‍♂️", name: "man bowing: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((757, SkinTone::MediumLight)), aliases: None, variations: &["🙇🏼\u{200d}♂"] },
    Emoji { emoji: "🙇🏽‍♂️", name: "man bowing: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((757, SkinTone::Medium)), aliases: None, variations: &["🙇🏽\u{200d}♂"] },
    Emoji { emoji: "🙇🏾‍♂️", name: "man bowing: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((757, SkinTone::MediumDark)), aliases: None, variations: &["🙇🏾\u{200d}♂"] },
    Emoji { emoji: "🙇🏿‍♂️", name: "man bowing: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((757, SkinTone::Dark)), aliases: None, variations: &["🙇🏿\u{200d}♂"] },
    Emoji { emoji: "🙇‍♀️", name: "woman bowing", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((763, SkinTone::Default)), aliases: Some(&["bowing_woman"]), variations: &["🙇\u{200d}♀"] },
    Emoji { emoji: "🙇🏻‍♀️", name: "woman bowing: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((763, SkinTone::Light)), aliases: None, variations: &["🙇🏻\u{200d}♀"] },
    Emoji { emoji: "🙇🏼‍♀️", name: "woman bowing: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((763, SkinTone::MediumLight)), aliases: None, variations: &["🙇🏼\u{200d}♀"] },
    Emoji { emoji: "🙇🏽‍♀️", name: "woman bowing: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((763, SkinTone::Medium)), aliases: None, variations: &["🙇🏽\u{200d}♀"] },
    Emoji { emoji: "🙇🏾‍♀️", name: "woman bowing: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((763, SkinTone::MediumDark)), aliases: None, variations: &["🙇🏾\u{200d}♀"] },
    Emoji { emoji: "🙇🏿‍♀️", name: "woman bowing: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((763, SkinTone::Dark)), aliases: None, variations: &["🙇🏿\u{200d}♀"] },
    Emoji { emoji: "🤦", name: "person facepalming", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((769, SkinTone::Default)), aliases: Some(&["facepalm"]), variations: &[] },
    Emoji { emoji: "🤦🏻", name: "person facepalming: light skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((769, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "🤦🏼", name: "person facepalming: medium-light skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((769, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "🤦🏽", name: "person facepalming: medium skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((769, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "🤦🏾", name: "person facepalming: medium-dark skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((769, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "🤦🏿", name: "person facepalming: dark skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((769, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "🤦‍♂️", name: "man facepalming", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((775, SkinTone::Default)), aliases: Some(&["man_facepalming"]), variations: &["🤦\u{200d}♂"] },
    Emoji { emoji: "🤦🏻‍♂️", name: "man facepalming: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((775, SkinTone::Light)), aliases: None, variations: &["🤦🏻\u{200d}♂"] },
    Emoji { emoji: "🤦🏼‍♂️", name: "man facepalming: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((775, SkinTone::MediumLight)), aliases: None, variations: &["🤦🏼\u{200d}♂"] },
    Emoji { emoji: "🤦🏽‍♂️", name: "man facepalming: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((775, SkinTone::Medium)), aliases: None, variations: &["🤦🏽\u{200d}♂"] },
    Emoji { emoji: "🤦🏾‍♂️", name: "man facepalming: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((775, SkinTone::MediumDark)), aliases: None, variations: &["🤦🏾\u{200d}♂"] },
    Emoji { emoji: "🤦🏿‍♂️", name: "man facepalming: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((775, SkinTone::Dark)), aliases: None, variations: &["🤦🏿\u{200d}♂"] },
    Emoji { emoji: "🤦‍♀️", name: "woman facepalming", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((781, SkinTone::Default)), aliases: Some(&["woman_facepalming"]), variations: &["🤦\u{200d}♀"] },
    Emoji { emoji: "🤦🏻‍♀️", name: "woman facepalming: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((781, SkinTone::Light)), aliases: None, variations: &["🤦🏻\u{200d}♀"] },
    Emoji { emoji: "🤦🏼‍♀️", name: "woman facepalming: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((781, SkinTone::MediumLight)), aliases: None, variations: &["🤦🏼\u{200d}♀"] },
    Emoji { emoji: "🤦🏽‍♀️", name: "woman facepalming: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((781, SkinTone::Medium)), aliases: None, variations: &["🤦🏽\u{200d}♀"] },
    Emoji { emoji: "🤦🏾‍♀️", name: "woman facepalming: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((781, SkinTone::MediumDark)), aliases: None, variations: &["🤦🏾\u{200d}♀"] },
    Emoji { emoji: "🤦🏿‍♀️", name: "woman facepalming: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((781, SkinTone::Dark)), aliases: None, variations: &["🤦🏿\u{200d}♀"] },
    Emoji { emoji: "🤷", name: "person shrugging", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((787, SkinTone::Default)), aliases: Some(&["shrug"]), variations: &[] },
    Emoji { emoji: "🤷🏻", name: "person shrugging: light skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((787, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "🤷🏼", name: "person shrugging: medium-light skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((787, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "🤷🏽", name: "person shrugging: medium skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((787, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "🤷🏾", name: "person shrugging: medium-dark skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((787, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "🤷🏿", name: "person shrugging: dark skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((787, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "🤷‍♂️", name: "man shrugging", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((793, SkinTone::Default)), aliases: Some(&["man_shrugging"]), variations: &["🤷\u{200d}♂"] },
    Emoji { emoji: "🤷🏻‍♂️", name: "man shrugging: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((793, SkinTone::Light)), aliases: None, variations: &["🤷🏻\u{200d}♂"] },
    Emoji { emoji: "🤷🏼‍♂️", name: "man shrugging: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((793, SkinTone::MediumLight)), aliases: None, variations: &["🤷🏼\u{200d}♂"] },
    Emoji { emoji: "🤷🏽‍♂️", name: "man shrugging: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((793, SkinTone::Medium)), aliases: None, variations: &["🤷🏽\u{200d}♂"] },
    Emoji { emoji: "🤷🏾‍♂️", name: "man shrugging: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((793, SkinTone::MediumDark)), aliases: None, variations: &["🤷🏾\u{200d}♂"] },
    Emoji { emoji: "🤷🏿‍♂️", name: "man shrugging: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((793, SkinTone::Dark)), aliases: None, variations: &["🤷🏿\u{200d}♂"] },
    Emoji { emoji: "🤷‍♀️", name: "woman shrugging", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((799, SkinTone::Default)), aliases: Some(&["woman_shrugging"]), variations: &["🤷\u{200d}♀"] },
    Emoji { emoji: "🤷🏻‍♀️", name: "woman shrugging: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((799, SkinTone::Light)), aliases: None, variations: &["🤷🏻\u{200d}♀"] },
    Emoji { emoji: "🤷🏼‍♀️", name: "woman shrugging: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((799, SkinTone::MediumLight)), aliases: None, variations: &["🤷🏼\u{200d}♀"] },
    Emoji { emoji: "🤷🏽‍♀️", name: "woman shrugging: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((799, SkinTone::Medium)), aliases: None, variations: &["🤷🏽\u{200d}♀"] },
    Emoji { emoji: "🤷🏾‍♀️", name: "woman shrugging: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((799, SkinTone::MediumDark)), aliases: None, variations: &["🤷🏾\u{200d}♀"] },
    Emoji { emoji: "🤷🏿‍♀️", name: "woman shrugging: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((799, SkinTone::Dark)), aliases: None, variations: &["🤷🏿\u{200d}♀"] },
    Emoji { emoji: "🧑‍⚕️", name: "health worker", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((805, SkinTone::Default)), aliases: Some(&["health_worker"]), variations: &["🧑\u{200d}⚕"] },
    Emoji { emoji: "🧑🏻‍⚕️", name: "health worker: light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((805, SkinTone::Light)), aliases: None, variations: &["🧑🏻\u{200d}⚕"] },
    Emoji { emoji: "🧑🏼‍⚕️", name: "health worker: medium-light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((805, SkinTone::MediumLight)), aliases: None, variations: &["🧑🏼\u{200d}⚕"] },
    Emoji { emoji: "🧑🏽‍⚕️", name: "health worker: medium skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((805, SkinTone::Medium)), aliases: None, variations: &["🧑🏽\u{200d}⚕"] },
    Emoji { emoji: "🧑🏾‍⚕️", name: "health worker: medium-dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((805, SkinTone::MediumDark)), aliases: None, variations: &["🧑🏾\u{200d}⚕"] },
    Emoji { emoji: "🧑🏿‍⚕️", name: "health worker: dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((805, SkinTone::Dark)), aliases: None, variations: &["🧑🏿\u{200d}⚕"] },
    Emoji { emoji: "👨‍⚕️", name: "man health worker", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((811, SkinTone::Default)), aliases: Some(&["man_health_worker"]), variations: &["👨\u{200d}⚕"] },
    Emoji { emoji: "👨🏻‍⚕️", name: "man health worker: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((811, SkinTone::Light)), aliases: None, variations: &["👨🏻\u{200d}⚕"] },
    Emoji { emoji: "👨🏼‍⚕️", name: "man health worker: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((811, SkinTone::MediumLight)), aliases: None, variations: &["👨🏼\u{200d}⚕"] },
    Emoji { emoji: "👨🏽‍⚕️", name: "man health worker: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((811, SkinTone::Medium)), aliases: None, variations: &["👨🏽\u{200d}⚕"] },
    Emoji { emoji: "👨🏾‍⚕️", name: "man health worker: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((811, SkinTone::MediumDark)), aliases: None, variations: &["👨🏾\u{200d}⚕"] },
    Emoji { emoji: "👨🏿‍⚕️", name: "man health worker: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((811, SkinTone::Dark)), aliases: None, variations: &["👨🏿\u{200d}⚕"] },
    Emoji { emoji: "👩‍⚕️", name: "woman health worker", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((817, SkinTone::Default)), aliases: Some(&["woman_health_worker"]), variations: &["👩\u{200d}⚕"] },
    Emoji { emoji: "👩🏻‍⚕️", name: "woman health worker: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((817, SkinTone::Light)), aliases: None, variations: &["👩🏻\u{200d}⚕"] },
    Emoji { emoji: "👩🏼‍⚕️", name: "woman health worker: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((817, SkinTone::MediumLight)), aliases: None, variations: &["👩🏼\u{200d}⚕"] },
    Emoji { emoji: "👩🏽‍⚕️", name: "woman health worker: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((817, SkinTone::Medium)), aliases: None, variations: &["👩🏽\u{200d}⚕"] },
    Emoji { emoji: "👩🏾‍⚕️", name: "woman health worker: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((817, SkinTone::MediumDark)), aliases: None, variations: &["👩🏾\u{200d}⚕"] },
    Emoji { emoji: "👩🏿‍⚕️", name: "woman health worker: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((817, SkinTone::Dark)), aliases: None, variations: &["👩🏿\u{200d}⚕"] },
    Emoji { emoji: "🧑‍🎓", name: "student", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((823, SkinTone::Default)), aliases: Some(&["student"]), variations: &[] },
    Emoji { emoji: "🧑🏻‍🎓", name: "student: light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((823, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "🧑🏼‍🎓", name: "student: medium-light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((823, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "🧑🏽‍🎓", name: "student: medium skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((823, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "🧑🏾‍🎓", name: "student: medium-dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((823, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "🧑🏿‍🎓", name: "student: dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((823, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "👨‍🎓", name: "man student", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((829, SkinTone::Default)), aliases: Some(&["man_student"]), variations: &[] },
    Emoji { emoji: "👨🏻‍🎓", name: "man student: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((829, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "👨🏼‍🎓", name: "man student: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((829, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "👨🏽‍🎓", name: "man student: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((829, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "👨🏾‍🎓", name: "man student: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((829, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "👨🏿‍🎓", name: "man student: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((829, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "👩‍🎓", name: "woman student", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((835, SkinTone::Default)), aliases: Some(&["woman_student"]), variations: &[] },
    Emoji { emoji: "👩🏻‍🎓", name: "woman student: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((835, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "👩🏼‍🎓", name: "woman student: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((835, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "👩🏽‍🎓", name: "woman student: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((835, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "👩🏾‍🎓", name: "woman student: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((835, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "👩🏿‍🎓", name: "woman student: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((835, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "🧑‍🏫", name: "teacher", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((841, SkinTone::Default)), aliases: Some(&["teacher"]), variations: &[] },
    Emoji { emoji: "🧑🏻‍🏫", name: "teacher: light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((841, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "🧑🏼‍🏫", name: "teacher: medium-light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((841, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "🧑🏽‍🏫", name: "teacher: medium skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((841, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "🧑🏾‍🏫", name: "teacher: medium-dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((841, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "🧑🏿‍🏫", name: "teacher: dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((841, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "👨‍🏫", name: "man teacher", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((847, SkinTone::Default)), aliases: Some(&["man_teacher"]), variations: &[] },
    Emoji { emoji: "👨🏻‍🏫", name: "man teacher: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((847, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "👨🏼‍🏫", name: "man teacher: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((847, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "👨🏽‍🏫", name: "man teacher: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((847, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "👨🏾‍🏫", name: "man teacher: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((847, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "👨🏿‍🏫", name: "man teacher: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((847, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "👩‍🏫", name: "woman teacher", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((853, SkinTone::Default)), aliases: Some(&["woman_teacher"]), variations: &[] },
    Emoji { emoji: "👩🏻‍🏫", name: "woman teacher: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((853, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "👩🏼‍🏫", name: "woman teacher: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((853, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "👩🏽‍🏫", name: "woman teacher: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((853, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "👩🏾‍🏫", name: "woman teacher: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((853, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "👩🏿‍🏫", name: "woman teacher: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((853, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "🧑‍⚖️", name: "judge", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((859, SkinTone::Default)), aliases: Some(&["judge"]), variations: &["🧑\u{200d}⚖"] },
    Emoji { emoji: "🧑🏻‍⚖️", name: "judge: light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((859, SkinTone::Light)), aliases: None, variations: &["🧑🏻\u{200d}⚖"] },
    Emoji { emoji: "🧑🏼‍⚖️", name: "judge: medium-light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((859, SkinTone::MediumLight)), aliases: None, variations: &["🧑🏼\u{200d}⚖"] },
    Emoji { emoji: "🧑🏽‍⚖️", name: "judge: medium skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((859, SkinTone::Medium)), aliases: None, variations: &["🧑🏽\u{200d}⚖"] },
    Emoji { emoji: "🧑🏾‍⚖️", name: "judge: medium-dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((859, SkinTone::MediumDark)), aliases: None, variations: &["🧑🏾\u{200d}⚖"] },
    Emoji { emoji: "🧑🏿‍⚖️", name: "judge: dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((859, SkinTone::Dark)), aliases: None, variations: &["🧑🏿\u{200d}⚖"] },
    Emoji { emoji: "👨‍⚖️", name: "man judge", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((865, SkinTone::Default)), aliases: Some(&["man_judge"]), variations: &["👨\u{200d}⚖"] },
    Emoji { emoji: "👨🏻‍⚖️", name: "man judge: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((865, SkinTone::Light)), aliases: None, variations: &["👨🏻\u{200d}⚖"] },
    Emoji { emoji: "👨🏼‍⚖️", name: "man judge: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((865, SkinTone::MediumLight)), aliases: None, variations: &["👨🏼\u{200d}⚖"] },
    Emoji { emoji: "👨🏽‍⚖️", name: "man judge: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((865, SkinTone::Medium)), aliases: None, variations: &["👨🏽\u{200d}⚖"] },
    Emoji { emoji: "👨🏾‍⚖️", name: "man judge: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((865, SkinTone::MediumDark)), aliases: None, variations: &["👨🏾\u{200d}⚖"] },
    Emoji { emoji: "👨🏿‍⚖️", name: "man judge: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((865, SkinTone::Dark)), aliases: None, variations: &["👨🏿\u{200d}⚖"] },
    Emoji { emoji: "👩‍⚖️", name: "woman judge", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((871, SkinTone::Default)), aliases: Some(&["woman_judge"]), variations: &["👩\u{200d}⚖"] },
    Emoji { emoji: "👩🏻‍⚖️", name: "woman judge: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((871, SkinTone::Light)), aliases: None, variations: &["👩🏻\u{200d}⚖"] },
    Emoji { emoji: "👩🏼‍⚖️", name: "woman judge: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((871, SkinTone::MediumLight)), aliases: None, variations: &["👩🏼\u{200d}⚖"] },
    Emoji { emoji: "👩🏽‍⚖️", name: "woman judge: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((871, SkinTone::Medium)), aliases: None, variations: &["👩🏽\u{200d}⚖"] },
    Emoji { emoji: "👩🏾‍⚖️", name: "woman judge: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((871, SkinTone::MediumDark)), aliases: None, variations: &["👩🏾\u{200d}⚖"] },
    Emoji { emoji: "👩🏿‍⚖️", name: "woman judge: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((871, SkinTone::Dark)), aliases: None, variations: &["👩🏿\u{200d}⚖"] },
    Emoji { emoji: "🧑‍🌾", name: "farmer", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((877, SkinTone::Default)), aliases: Some(&["farmer"]), variations: &[] },
    Emoji { emoji: "🧑🏻‍🌾", name: "farmer: light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((877, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "🧑🏼‍🌾", name: "farmer: medium-light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((877, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "🧑🏽‍🌾", name: "farmer: medium skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((877, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "🧑🏾‍🌾", name: "farmer: medium-dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((877, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "🧑🏿‍🌾", name: "farmer: dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((877, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "👨‍🌾", name: "man farmer", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((883, SkinTone::Default)), aliases: Some(&["man_farmer"]), variations: &[] },
    Emoji { emoji: "👨🏻‍🌾", name: "man farmer: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((883, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "👨🏼‍🌾", name: "man farmer: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((883, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "👨🏽‍🌾", name: "man farmer: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((883, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "👨🏾‍🌾", name: "man farmer: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((883, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "👨🏿‍🌾", name: "man farmer: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((883, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "👩‍🌾", name: "woman farmer", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((889, SkinTone::Default)), aliases: Some(&["woman_farmer"]), variations: &[] },
    Emoji { emoji: "👩🏻‍🌾", name: "woman farmer: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((889, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "👩🏼‍🌾", name: "woman farmer: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((889, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "👩🏽‍🌾", name: "woman farmer: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((889, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "👩🏾‍🌾", name: "woman farmer: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((889, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "👩🏿‍🌾", name: "woman farmer: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((889, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "🧑‍🍳", name: "cook", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((895, SkinTone::Default)), aliases: Some(&["cook"]), variations: &[] },
    Emoji { emoji: "🧑🏻‍🍳", name: "cook: light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((895, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "🧑🏼‍🍳", name: "cook: medium-light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((895, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "🧑🏽‍🍳", name: "cook: medium skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((895, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "🧑🏾‍🍳", name: "cook: medium-dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((895, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "🧑🏿‍🍳", name: "cook: dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((895, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "👨‍🍳", name: "man cook", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((901, SkinTone::Default)), aliases: Some(&["man_cook"]), variations: &[] },
    Emoji { emoji: "👨🏻‍🍳", name: "man cook: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((901, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "👨🏼‍🍳", name: "man cook: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((901, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "👨🏽‍🍳", name: "man cook: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((901, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "👨🏾‍🍳", name: "man cook: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((901, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "👨🏿‍🍳", name: "man cook: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((901, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "👩‍🍳", name: "woman cook", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((907, SkinTone::Default)), aliases: Some(&["woman_cook"]), variations: &[] },
    Emoji { emoji: "👩🏻‍🍳", name: "woman cook: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((907, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "👩🏼‍🍳", name: "woman cook: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((907, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "👩🏽‍🍳", name: "woman cook: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((907, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "👩🏾‍🍳", name: "woman cook: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((907, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "👩🏿‍🍳", name: "woman cook: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((907, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "🧑‍🔧", name: "mechanic", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((913, SkinTone::Default)), aliases: Some(&["mechanic"]), variations: &[] },
    Emoji { emoji: "🧑🏻‍🔧", name: "mechanic: light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((913, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "🧑🏼‍🔧", name: "mechanic: medium-light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((913, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "🧑🏽‍🔧", name: "mechanic: medium skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((913, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "🧑🏾‍🔧", name: "mechanic: medium-dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((913, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "🧑🏿‍🔧", name: "mechanic: dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((913, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "👨‍🔧", name: "man mechanic", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((919, SkinTone::Default)), aliases: Some(&["man_mechanic"]), variations: &[] },
    Emoji { emoji: "👨🏻‍🔧", name: "man mechanic: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((919, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "👨🏼‍🔧", name: "man mechanic: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((919, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "👨🏽‍🔧", name: "man mechanic: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((919, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "👨🏾‍🔧", name: "man mechanic: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((919, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "👨🏿‍🔧", name: "man mechanic: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((919, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "👩‍🔧", name: "woman mechanic", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((925, SkinTone::Default)), aliases: Some(&["woman_mechanic"]), variations: &[] },
    Emoji { emoji: "👩🏻‍🔧", name: "woman mechanic: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((925, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "👩🏼‍🔧", name: "woman mechanic: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((925, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "👩🏽‍🔧", name: "woman mechanic: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((925, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "👩🏾‍🔧", name: "woman mechanic: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((925, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "👩🏿‍🔧", name: "woman mechanic: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((925, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "🧑‍🏭", name: "factory worker", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((931, SkinTone::Default)), aliases: Some(&["factory_worker"]), variations: &[] },
    Emoji { emoji: "🧑🏻‍🏭", name: "factory worker: light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((931, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "🧑🏼‍🏭", name: "factory worker: medium-light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((931, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "🧑🏽‍🏭", name: "factory worker: medium skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((931, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "🧑🏾‍🏭", name: "factory worker: medium-dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((931, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "🧑🏿‍🏭", name: "factory worker: dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((931, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "👨‍🏭", name: "man factory worker", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((937, SkinTone::Default)), aliases: Some(&["man_factory_worker"]), variations: &[] },
    Emoji { emoji: "👨🏻‍🏭", name: "man factory worker: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((937, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "👨🏼‍🏭", name: "man factory worker: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((937, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "👨🏽‍🏭", name: "man factory worker: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((937, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "👨🏾‍🏭", name: "man factory worker: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((937, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "👨🏿‍🏭", name: "man factory worker: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((937, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "👩‍🏭", name: "woman factory worker", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((943, SkinTone::Default)), aliases: Some(&["woman_factory_worker"]), variations: &[] },
    Emoji { emoji: "👩🏻‍🏭", name: "woman factory worker: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((943, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "👩🏼‍🏭", name: "woman factory worker: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((943, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "👩🏽‍🏭", name: "woman factory worker: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((943, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "👩🏾‍🏭", name: "woman factory worker: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((943, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "👩🏿‍🏭", name: "woman factory worker: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((943, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "🧑‍💼", name: "office worker", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((949, SkinTone::Default)), aliases: Some(&["office_worker"]), variations: &[] },
    Emoji { emoji: "🧑🏻‍💼", name: "office worker: light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((949, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "🧑🏼‍💼", name: "office worker: medium-light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((949, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "🧑🏽‍💼", name: "office worker: medium skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((949, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "🧑🏾‍💼", name: "office worker: medium-dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((949, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "🧑🏿‍💼", name: "office worker: dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((949, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "👨‍💼", name: "man office worker", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((955, SkinTone::Default)), aliases: Some(&["man_office_worker"]), variations: &[] },
    Emoji { emoji: "👨🏻‍💼", name: "man office worker: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((955, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "👨🏼‍💼", name: "man office worker: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((955, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "👨🏽‍💼", name: "man office worker: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((955, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "👨🏾‍💼", name: "man office worker: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((955, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "👨🏿‍💼", name: "man office worker: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((955, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "👩‍💼", name: "woman office worker", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((961, SkinTone::Default)), aliases: Some(&["woman_office_worker"]), variations: &[] },
    Emoji { emoji: "👩🏻‍💼", name: "woman office worker: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((961, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "👩🏼‍💼", name: "woman office worker: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((961, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "👩🏽‍💼", name: "woman office worker: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((961, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "👩🏾‍💼", name: "woman office worker: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((961, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "👩🏿‍💼", name: "woman office worker: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((961, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "🧑‍🔬", name: "scientist", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((967, SkinTone::Default)), aliases: Some(&["scientist"]), variations: &[] },
    Emoji { emoji: "🧑🏻‍🔬", name: "scientist: light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((967, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "🧑🏼‍🔬", name: "scientist: medium-light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((967, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "🧑🏽‍🔬", name: "scientist: medium skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((967, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "🧑🏾‍🔬", name: "scientist: medium-dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((967, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "🧑🏿‍🔬", name: "scientist: dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((967, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "👨‍🔬", name: "man scientist", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((973, SkinTone::Default)), aliases: Some(&["man_scientist"]), variations: &[] },
    Emoji { emoji: "👨🏻‍🔬", name: "man scientist: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((973, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "👨🏼‍🔬", name: "man scientist: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((973, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "👨🏽‍🔬", name: "man scientist: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((973, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "👨🏾‍🔬", name: "man scientist: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((973, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "👨🏿‍🔬", name: "man scientist: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((973, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "👩‍🔬", name: "woman scientist", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((979, SkinTone::Default)), aliases: Some(&["woman_scientist"]), variations: &[] },
    Emoji { emoji: "👩🏻‍🔬", name: "woman scientist: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((979, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "👩🏼‍🔬", name: "woman scientist: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((979, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "👩🏽‍🔬", name: "woman scientist: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((979, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "👩🏾‍🔬", name: "woman scientist: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((979, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "👩🏿‍🔬", name: "woman scientist: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((979, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "🧑‍💻", name: "technologist", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((985, SkinTone::Default)), aliases: Some(&["technologist"]), variations: &[] },
    Emoji { emoji: "🧑🏻‍💻", name: "technologist: light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((985, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "🧑🏼‍💻", name: "technologist: medium-light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((985, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "🧑🏽‍💻", name: "technologist: medium skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((985, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "🧑🏾‍💻", name: "technologist: medium-dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((985, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "🧑🏿‍💻", name: "technologist: dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((985, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "👨‍💻", name: "man technologist", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((991, SkinTone::Default)), aliases: Some(&["man_technologist"]), variations: &[] },
    Emoji { emoji: "👨🏻‍💻", name: "man technologist: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((991, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "👨🏼‍💻", name: "man technologist: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((991, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "👨🏽‍💻", name: "man technologist: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((991, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "👨🏾‍💻", name: "man technologist: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((991, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "👨🏿‍💻", name: "man technologist: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((991, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "👩‍💻", name: "woman technologist", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((997, SkinTone::Default)), aliases: Some(&["woman_technologist"]), variations: &[] },
    Emoji { emoji: "👩🏻‍💻", name: "woman technologist: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((997, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "👩🏼‍💻", name: "woman technologist: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((997, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "👩🏽‍💻", name: "woman technologist: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((997, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "👩🏾‍💻", name: "woman technologist: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((997, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "👩🏿‍💻", name: "woman technologist: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((997, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "🧑‍🎤", name: "singer", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1003, SkinTone::Default)), aliases: Some(&["singer"]), variations: &[] },
    Emoji { emoji: "🧑🏻‍🎤", name: "singer: light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1003, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "🧑🏼‍🎤", name: "singer: medium-light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1003, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "🧑🏽‍🎤", name: "singer: medium skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1003, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "🧑🏾‍🎤", name: "singer: medium-dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1003, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "🧑🏿‍🎤", name: "singer: dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1003, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "👨‍🎤", name: "man singer", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1009, SkinTone::Default)), aliases: Some(&["man_singer"]), variations: &[] },
    Emoji { emoji: "👨🏻‍🎤", name: "man singer: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1009, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "👨🏼‍🎤", name: "man singer: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1009, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "👨🏽‍🎤", name: "man singer: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1009, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "👨🏾‍🎤", name: "man singer: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1009, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "👨🏿‍🎤", name: "man singer: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1009, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "👩‍🎤", name: "woman singer", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1015, SkinTone::Default)), aliases: Some(&["woman_singer"]), variations: &[] },
    Emoji { emoji: "👩🏻‍🎤", name: "woman singer: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1015, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "👩🏼‍🎤", name: "woman singer: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1015, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "👩🏽‍🎤", name: "woman singer: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1015, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "👩🏾‍🎤", name: "woman singer: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1015, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "👩🏿‍🎤", name: "woman singer: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1015, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "🧑‍🎨", name: "artist", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1021, SkinTone::Default)), aliases: Some(&["artist"]), variations: &[] },
    Emoji { emoji: "🧑🏻‍🎨", name: "artist: light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1021, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "🧑🏼‍🎨", name: "artist: medium-light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1021, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "🧑🏽‍🎨", name: "artist: medium skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1021, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "🧑🏾‍🎨", name: "artist: medium-dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1021, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "🧑🏿‍🎨", name: "artist: dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1021, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "👨‍🎨", name: "man artist", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1027, SkinTone::Default)), aliases: Some(&["man_artist"]), variations: &[] },
    Emoji { emoji: "👨🏻‍🎨", name: "man artist: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1027, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "👨🏼‍🎨", name: "man artist: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1027, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "👨🏽‍🎨", name: "man artist: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1027, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "👨🏾‍🎨", name: "man artist: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1027, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "👨🏿‍🎨", name: "man artist: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1027, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "👩‍🎨", name: "woman artist", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1033, SkinTone::Default)), aliases: Some(&["woman_artist"]), variations: &[] },
    Emoji { emoji: "👩🏻‍🎨", name: "woman artist: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1033, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "👩🏼‍🎨", name: "woman artist: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1033, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "👩🏽‍🎨", name: "woman artist: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1033, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "👩🏾‍🎨", name: "woman artist: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1033, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "👩🏿‍🎨", name: "woman artist: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1033, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "🧑‍✈️", name: "pilot", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1039, SkinTone::Default)), aliases: Some(&["pilot"]), variations: &["🧑\u{200d}✈"] },
    Emoji { emoji: "🧑🏻‍✈️", name: "pilot: light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1039, SkinTone::Light)), aliases: None, variations: &["🧑🏻\u{200d}✈"] },
    Emoji { emoji: "🧑🏼‍✈️", name: "pilot: medium-light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1039, SkinTone::MediumLight)), aliases: None, variations: &["🧑🏼\u{200d}✈"] },
    Emoji { emoji: "🧑🏽‍✈️", name: "pilot: medium skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1039, SkinTone::Medium)), aliases: None, variations: &["🧑🏽\u{200d}✈"] },
    Emoji { emoji: "🧑🏾‍✈️", name: "pilot: medium-dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1039, SkinTone::MediumDark)), aliases: None, variations: &["🧑🏾\u{200d}✈"] },
    Emoji { emoji: "🧑🏿‍✈️", name: "pilot: dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1039, SkinTone::Dark)), aliases: None, variations: &["🧑🏿\u{200d}✈"] },
    Emoji { emoji: "👨‍✈️", name: "man pilot", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1045, SkinTone::Default)), aliases: Some(&["man_pilot"]), variations: &["👨\u{200d}✈"] },
    Emoji { emoji: "👨🏻‍✈️", name: "man pilot: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1045, SkinTone::Light)), aliases: None, variations: &["👨🏻\u{200d}✈"] },
    Emoji { emoji: "👨🏼‍✈️", name: "man pilot: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1045, SkinTone::MediumLight)), aliases: None, variations: &["👨🏼\u{200d}✈"] },
    Emoji { emoji: "👨🏽‍✈️", name: "man pilot: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1045, SkinTone::Medium)), aliases: None, variations: &["👨🏽\u{200d}✈"] },
    Emoji { emoji: "👨🏾‍✈️", name: "man pilot: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1045, SkinTone::MediumDark)), aliases: None, variations: &["👨🏾\u{200d}✈"] },
    Emoji { emoji: "👨🏿‍✈️", name: "man pilot: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1045, SkinTone::Dark)), aliases: None, variations: &["👨🏿\u{200d}✈"] },
    Emoji { emoji: "👩‍✈️", name: "woman pilot", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1051, SkinTone::Default)), aliases: Some(&["woman_pilot"]), variations: &["👩\u{200d}✈"] },
    Emoji { emoji: "👩🏻‍✈️", name: "woman pilot: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1051, SkinTone::Light)), aliases: None, variations: &["👩🏻\u{200d}✈"] },
    Emoji { emoji: "👩🏼‍✈️", name: "woman pilot: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1051, SkinTone::MediumLight)), aliases: None, variations: &["👩🏼\u{200d}✈"] },
    Emoji { emoji: "👩🏽‍✈️", name: "woman pilot: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1051, SkinTone::Medium)), aliases: None, variations: &["👩🏽\u{200d}✈"] },
    Emoji { emoji: "👩🏾‍✈️", name: "woman pilot: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1051, SkinTone::MediumDark)), aliases: None, variations: &["👩🏾\u{200d}✈"] },
    Emoji { emoji: "👩🏿‍✈️", name: "woman pilot: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1051, SkinTone::Dark)), aliases: None, variations: &["👩🏿\u{200d}✈"] },
    Emoji { emoji: "🧑‍🚀", name: "astronaut", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1057, SkinTone::Default)), aliases: Some(&["astronaut"]), variations: &[] },
    Emoji { emoji: "🧑🏻‍🚀", name: "astronaut: light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1057, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "🧑🏼‍🚀", name: "astronaut: medium-light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1057, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "🧑🏽‍🚀", name: "astronaut: medium skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1057, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "🧑🏾‍🚀", name: "astronaut: medium-dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1057, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "🧑🏿‍🚀", name: "astronaut: dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1057, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "👨‍🚀", name: "man astronaut", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1063, SkinTone::Default)), aliases: Some(&["man_astronaut"]), variations: &[] },
    Emoji { emoji: "👨🏻‍🚀", name: "man astronaut: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1063, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "👨🏼‍🚀", name: "man astronaut: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1063, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "👨🏽‍🚀", name: "man astronaut: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1063, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "👨🏾‍🚀", name: "man astronaut: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1063, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "👨🏿‍🚀", name: "man astronaut: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1063, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "👩‍🚀", name: "woman astronaut", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1069, SkinTone::Default)), aliases: Some(&["woman_astronaut"]), variations: &[] },
    Emoji { emoji: "👩🏻‍🚀", name: "woman astronaut: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1069, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "👩🏼‍🚀", name: "woman astronaut: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1069, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "👩🏽‍🚀", name: "woman astronaut: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1069, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "👩🏾‍🚀", name: "woman astronaut: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1069, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "👩🏿‍🚀", name: "woman astronaut: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1069, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "🧑‍🚒", name: "firefighter", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1075, SkinTone::Default)), aliases: Some(&["firefighter"]), variations: &[] },
    Emoji { emoji: "🧑🏻‍🚒", name: "firefighter: light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1075, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "🧑🏼‍🚒", name: "firefighter: medium-light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1075, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "🧑🏽‍🚒", name: "firefighter: medium skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1075, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "🧑🏾‍🚒", name: "firefighter: medium-dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1075, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "🧑🏿‍🚒", name: "firefighter: dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1075, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "👨‍🚒", name: "man firefighter", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1081, SkinTone::Default)), aliases: Some(&["man_firefighter"]), variations: &[] },
    Emoji { emoji: "👨🏻‍🚒", name: "man firefighter: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1081, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "👨🏼‍🚒", name: "man firefighter: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1081, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "👨🏽‍🚒", name: "man firefighter: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1081, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "👨🏾‍🚒", name: "man firefighter: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1081, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "👨🏿‍🚒", name: "man firefighter: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1081, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "👩‍🚒", name: "woman firefighter", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1087, SkinTone::Default)), aliases: Some(&["woman_firefighter"]), variations: &[] },
    Emoji { emoji: "👩🏻‍🚒", name: "woman firefighter: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1087, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "👩🏼‍🚒", name: "woman firefighter: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1087, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "👩🏽‍🚒", name: "woman firefighter: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1087, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "👩🏾‍🚒", name: "woman firefighter: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1087, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "👩🏿‍🚒", name: "woman firefighter: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1087, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "👮", name: "police officer", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: Some((1093, SkinTone::Default)), aliases: Some(&["police_officer", "cop"]), variations: &[] },
    Emoji { emoji: "👮🏻", name: "police officer: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1093, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "👮🏼", name: "police officer: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1093, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "👮🏽", name: "police officer: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1093, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "👮🏾", name: "police officer: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1093, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "👮🏿", name: "police officer: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1093, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "👮‍♂️", name: "man police officer", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1099, SkinTone::Default)), aliases: Some(&["policeman"]), variations: &["👮\u{200d}♂"] },
    Emoji { emoji: "👮🏻‍♂️", name: "man police officer: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1099, SkinTone::Light)), aliases: None, variations: &["👮🏻\u{200d}♂"] },
    Emoji { emoji: "👮🏼‍♂️", name: "man police officer: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1099, SkinTone::MediumLight)), aliases: None, variations: &["👮🏼\u{200d}♂"] },
    Emoji { emoji: "👮🏽‍♂️", name: "man police officer: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1099, SkinTone::Medium)), aliases: None, variations: &["👮🏽\u{200d}♂"] },
    Emoji { emoji: "👮🏾‍♂️", name: "man police officer: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1099, SkinTone::MediumDark)), aliases: None, variations: &["👮🏾\u{200d}♂"] },
    Emoji { emoji: "👮🏿‍♂️", name: "man police officer: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1099, SkinTone::Dark)), aliases: None, variations: &["👮🏿\u{200d}♂"] },
    Emoji { emoji: "👮‍♀️", name: "woman police officer", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1105, SkinTone::Default)), aliases: Some(&["policewoman"]), variations: &["👮\u{200d}♀"] },
    Emoji { emoji: "👮🏻‍♀️", name: "woman police officer: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1105, SkinTone::Light)), aliases: None, variations: &["👮🏻\u{200d}♀"] },
    Emoji { emoji: "👮🏼‍♀️", name: "woman police officer: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1105, SkinTone::MediumLight)), aliases: None, variations: &["👮🏼\u{200d}♀"] },
    Emoji { emoji: "👮🏽‍♀️", name: "woman police officer: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1105, SkinTone::Medium)), aliases: None, variations: &["👮🏽\u{200d}♀"] },
    Emoji { emoji: "👮🏾‍♀️", name: "woman police officer: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1105, SkinTone::MediumDark)), aliases: None, variations: &["👮🏾\u{200d}♀"] },
    Emoji { emoji: "👮🏿‍♀️", name: "woman police officer: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1105, SkinTone::Dark)), aliases: None, variations: &["👮🏿\u{200d}♀"] },
    Emoji { emoji: "🕵️", name: "detective", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::PeopleAndBody, skin_tone: Some((1111, SkinTone::Default)), aliases: Some(&["detective"]), variations: &["🕵"] },
    Emoji { emoji: "🕵🏻", name: "detective: light skin tone", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1111, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "🕵🏼", name: "detective: medium-light skin tone", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1111, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "🕵🏽", name: "detective: medium skin tone", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1111, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "🕵🏾", name: "detective: medium-dark skin tone", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1111, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "🕵🏿", name: "detective: dark skin tone", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1111, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "🕵️‍♂️", name: "man detective", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1117, SkinTone::Default)), aliases: Some(&["male_detective"]), variations: &["🕵\u{200d}♂\u{fe0f}", "🕵\u{fe0f}\u{200d}♂", "🕵\u{200d}♂"] },
    Emoji { emoji: "🕵🏻‍♂️", name: "man detective: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1117, SkinTone::Light)), aliases: None, variations: &["🕵🏻\u{200d}♂"] },
    Emoji { emoji: "🕵🏼‍♂️", name: "man detective: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1117, SkinTone::MediumLight)), aliases: None, variations: &["🕵🏼\u{200d}♂"] },
    Emoji { emoji: "🕵🏽‍♂️", name: "man detective: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1117, SkinTone::Medium)), aliases: None, variations: &["🕵🏽\u{200d}♂"] },
    Emoji { emoji: "🕵🏾‍♂️", name: "man detective: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1117, SkinTone::MediumDark)), aliases: None, variations: &["🕵🏾\u{200d}♂"] },
    Emoji { emoji: "🕵🏿‍♂️", name: "man detective: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1117, SkinTone::Dark)), aliases: None, variations: &["🕵🏿\u{200d}♂"] },
    Emoji { emoji: "🕵️‍♀️", name: "woman detective", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1123, SkinTone::Default)), aliases: Some(&["female_detective"]), variations: &["🕵\u{200d}♀\u{fe0f}", "🕵\u{fe0f}\u{200d}♀", "🕵\u{200d}♀"] },
    Emoji { emoji: "🕵🏻‍♀️", name: "woman detective: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1123, SkinTone::Light)), aliases: None, variations: &["🕵🏻\u{200d}♀"] },
    Emoji { emoji: "🕵🏼‍♀️", name: "woman detective: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1123, SkinTone::MediumLight)), aliases: None, variations: &["🕵🏼\u{200d}♀"] },
    Emoji { emoji: "🕵🏽‍♀️", name: "woman detective: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1123, SkinTone::Medium)), aliases: None, variations: &["🕵🏽\u{200d}♀"] },
    Emoji { emoji: "🕵🏾‍♀️", name: "woman detective: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1123, SkinTone::MediumDark)), aliases: None, variations: &["🕵🏾\u{200d}♀"] },
    Emoji { emoji: "🕵🏿‍♀️", name: "woman detective: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1123, SkinTone::Dark)), aliases: None, variations: &["🕵🏿\u{200d}♀"] },
    Emoji { emoji: "💂", name: "guard", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: Some((1129, SkinTone::Default)), aliases: Some(&["guard"]), variations: &[] },
    Emoji { emoji: "💂🏻", name: "guard: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1129, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "💂🏼", name: "guard: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1129, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "💂🏽", name: "guard: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1129, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "💂🏾", name: "guard: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1129, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "💂🏿", name: "guard: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1129, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "💂‍♂️", name: "man guard", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1135, SkinTone::Default)), aliases: Some(&["guardsman"]), variations: &["💂\u{200d}♂"] },
    Emoji { emoji: "💂🏻‍♂️", name: "man guard: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1135, SkinTone::Light)), aliases: None, variations: &["💂🏻\u{200d}♂"] },
    Emoji { emoji: "💂🏼‍♂️", name: "man guard: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1135, SkinTone::MediumLight)), aliases: None, variations: &["💂🏼\u{200d}♂"] },
    Emoji { emoji: "💂🏽‍♂️", name: "man guard: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1135, SkinTone::Medium)), aliases: None, variations: &["💂🏽\u{200d}♂"] },
    Emoji { emoji: "💂🏾‍♂️", name: "man guard: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1135, SkinTone::MediumDark)), aliases: None, variations: &["💂🏾\u{200d}♂"] },
    Emoji { emoji: "💂🏿‍♂️", name: "man guard: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1135, SkinTone::Dark)), aliases: None, variations: &["💂🏿\u{200d}♂"] },
    Emoji { emoji: "💂‍♀️", name: "woman guard", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1141, SkinTone::Default)), aliases: Some(&["guardswoman"]), variations: &["💂\u{200d}♀"] },
    Emoji { emoji: "💂🏻‍♀️", name: "woman guard: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1141, SkinTone::Light)), aliases: None, variations: &["💂🏻\u{200d}♀"] },
    Emoji { emoji: "💂🏼‍♀️", name: "woman guard: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1141, SkinTone::MediumLight)), aliases: None, variations: &["💂🏼\u{200d}♀"] },
    Emoji { emoji: "💂🏽‍♀️", name: "woman guard: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1141, SkinTone::Medium)), aliases: None, variations: &["💂🏽\u{200d}♀"] },
    Emoji { emoji: "💂🏾‍♀️", name: "woman guard: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1141, SkinTone::MediumDark)), aliases: None, variations: &["💂🏾\u{200d}♀"] },
    Emoji { emoji: "💂🏿‍♀️", name: "woman guard: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1141, SkinTone::Dark)), aliases: None, variations: &["💂🏿\u{200d}♀"] },
    Emoji { emoji: "🥷", name: "ninja", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1147, SkinTone::Default)), aliases: Some(&["ninja"]), variations: &[] },
    Emoji { emoji: "🥷🏻", name: "ninja: light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1147, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "🥷🏼", name: "ninja: medium-light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1147, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "🥷🏽", name: "ninja: medium skin tone", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1147, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "🥷🏾", name: "ninja: medium-dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1147, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "🥷🏿", name: "ninja: dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1147, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "👷", name: "construction worker", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: Some((1153, SkinTone::Default)), aliases: Some(&["construction_worker"]), variations: &[] },
    Emoji { emoji: "👷🏻", name: "construction worker: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1153, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "👷🏼", name: "construction worker: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1153, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "👷🏽", name: "construction worker: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1153, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "👷🏾", name: "construction worker: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1153, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "👷🏿", name: "construction worker: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1153, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "👷‍♂️", name: "man construction worker", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1159, SkinTone::Default)), aliases: Some(&["construction_worker_man"]), variations: &["👷\u{200d}♂"] },
    Emoji { emoji: "👷🏻‍♂️", name: "man construction worker: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1159, SkinTone::Light)), aliases: None, variations: &["👷🏻\u{200d}♂"] },
    Emoji { emoji: "👷🏼‍♂️", name: "man construction worker: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1159, SkinTone::MediumLight)), aliases: None, variations: &["👷🏼\u{200d}♂"] },
    Emoji { emoji: "👷🏽‍♂️", name: "man construction worker: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1159, SkinTone::Medium)), aliases: None, variations: &["👷🏽\u{200d}♂"] },
    Emoji { emoji: "👷🏾‍♂️", name: "man construction worker: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1159, SkinTone::MediumDark)), aliases: None, variations: &["👷🏾\u{200d}♂"] },
    Emoji { emoji: "👷🏿‍♂️", name: "man construction worker: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1159, SkinTone::Dark)), aliases: None, variations: &["👷🏿\u{200d}♂"] },
    Emoji { emoji: "👷‍♀️", name: "woman construction worker", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1165, SkinTone::Default)), aliases: Some(&["construction_worker_woman"]), variations: &["👷\u{200d}♀"] },
    Emoji { emoji: "👷🏻‍♀️", name: "woman construction worker: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1165, SkinTone::Light)), aliases: None, variations: &["👷🏻\u{200d}♀"] },
    Emoji { emoji: "👷🏼‍♀️", name: "woman construction worker: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1165, SkinTone::MediumLight)), aliases: None, variations: &["👷🏼\u{200d}♀"] },
    Emoji { emoji: "👷🏽‍♀️", name: "woman construction worker: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1165, SkinTone::Medium)), aliases: None, variations: &["👷🏽\u{200d}♀"] },
    Emoji { emoji: "👷🏾‍♀️", name: "woman construction worker: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1165, SkinTone::MediumDark)), aliases: None, variations: &["👷🏾\u{200d}♀"] },
    Emoji { emoji: "👷🏿‍♀️", name: "woman construction worker: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1165, SkinTone::Dark)), aliases: None, variations: &["👷🏿\u{200d}♀"] },
    Emoji { emoji: "🫅", name: "person with crown", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1171, SkinTone::Default)), aliases: None, variations: &[] },
    Emoji { emoji: "🫅🏻", name: "person with crown: light skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1171, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "🫅🏼", name: "person with crown: medium-light skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1171, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "🫅🏽", name: "person with crown: medium skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1171, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "🫅🏾", name: "person with crown: medium-dark skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1171, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "🫅🏿", name: "person with crown: dark skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1171, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "🤴", name: "prince", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1177, SkinTone::Default)), aliases: Some(&["prince"]), variations: &[] },
    Emoji { emoji: "🤴🏻", name: "prince: light skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1177, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "🤴🏼", name: "prince: medium-light skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1177, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "🤴🏽", name: "prince: medium skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1177, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "🤴🏾", name: "prince: medium-dark skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1177, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "🤴🏿", name: "prince: dark skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1177, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "👸", name: "princess", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: Some((1183, SkinTone::Default)), aliases: Some(&["princess"]), variations: &[] },
    Emoji { emoji: "👸🏻", name: "princess: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1183, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "👸🏼", name: "princess: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1183, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "👸🏽", name: "princess: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1183, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "👸🏾", name: "princess: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1183, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "👸🏿", name: "princess: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1183, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "👳", name: "person wearing turban", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: Some((1189, SkinTone::Default)), aliases: Some(&["person_with_turban"]), variations: &[] },
    Emoji { emoji: "👳🏻", name: "person wearing turban: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1189, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "👳🏼", name: "person wearing turban: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1189, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "👳🏽", name: "person wearing turban: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1189, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "👳🏾", name: "person wearing turban: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1189, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "👳🏿", name: "person wearing turban: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1189, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "👳‍♂️", name: "man wearing turban", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1195, SkinTone::Default)), aliases: Some(&["man_with_turban"]), variations: &["👳\u{200d}♂"] },
    Emoji { emoji: "👳🏻‍♂️", name: "man wearing turban: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1195, SkinTone::Light)), aliases: None, variations: &["👳🏻\u{200d}♂"] },
    Emoji { emoji: "👳🏼‍♂️", name: "man wearing turban: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1195, SkinTone::MediumLight)), aliases: None, variations: &["👳🏼\u{200d}♂"] },
    Emoji { emoji: "👳🏽‍♂️", name: "man wearing turban: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1195, SkinTone::Medium)), aliases: None, variations: &["👳🏽\u{200d}♂"] },
    Emoji { emoji: "👳🏾‍♂️", name: "man wearing turban: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1195, SkinTone::MediumDark)), aliases: None, variations: &["👳🏾\u{200d}♂"] },
    Emoji { emoji: "👳🏿‍♂️", name: "man wearing turban: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1195, SkinTone::Dark)), aliases: None, variations: &["👳🏿\u{200d}♂"] },
    Emoji { emoji: "👳‍♀️", name: "woman wearing turban", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1201, SkinTone::Default)), aliases: Some(&["woman_with_turban"]), variations: &["👳\u{200d}♀"] },
    Emoji { emoji: "👳🏻‍♀️", name: "woman wearing turban: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1201, SkinTone::Light)), aliases: None, variations: &["👳🏻\u{200d}♀"] },
    Emoji { emoji: "👳🏼‍♀️", name: "woman wearing turban: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1201, SkinTone::MediumLight)), aliases: None, variations: &["👳🏼\u{200d}♀"] },
    Emoji { emoji: "👳🏽‍♀️", name: "woman wearing turban: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1201, SkinTone::Medium)), aliases: None, variations: &["👳🏽\u{200d}♀"] },
    Emoji { emoji: "👳🏾‍♀️", name: "woman wearing turban: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1201, SkinTone::MediumDark)), aliases: None, variations: &["👳🏾\u{200d}♀"] },
    Emoji { emoji: "👳🏿‍♀️", name: "woman wearing turban: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1201, SkinTone::Dark)), aliases: None, variations: &["👳🏿\u{200d}♀"] },
    Emoji { emoji: "👲", name: "person with skullcap", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: Some((1207, SkinTone::Default)), aliases: Some(&["man_with_gua_pi_mao"]), variations: &[] },
    Emoji { emoji: "👲🏻", name: "person with skullcap: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1207, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "👲🏼", name: "person with skullcap: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1207, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "👲🏽", name: "person with skullcap: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1207, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "👲🏾", name: "person with skullcap: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1207, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "👲🏿", name: "person with skullcap: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1207, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "🧕", name: "woman with headscarf", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1213, SkinTone::Default)), aliases: Some(&["woman_with_headscarf"]), variations: &[] },
    Emoji { emoji: "🧕🏻", name: "woman with headscarf: light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1213, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "🧕🏼", name: "woman with headscarf: medium-light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1213, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "🧕🏽", name: "woman with headscarf: medium skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1213, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "🧕🏾", name: "woman with headscarf: medium-dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1213, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "🧕🏿", name: "woman with headscarf: dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1213, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "🤵", name: "person in tuxedo", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1219, SkinTone::Default)), aliases: Some(&["person_in_tuxedo"]), variations: &[] },
    Emoji { emoji: "🤵🏻", name: "person in tuxedo: light skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1219, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "🤵🏼", name: "person in tuxedo: medium-light skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1219, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "🤵🏽", name: "person in tuxedo: medium skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1219, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "🤵🏾", name: "person in tuxedo: medium-dark skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1219, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "🤵🏿", name: "person in tuxedo: dark skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1219, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "🤵‍♂️", name: "man in tuxedo", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1225, SkinTone::Default)), aliases: Some(&["man_in_tuxedo"]), variations: &["🤵\u{200d}♂"] },
    Emoji { emoji: "🤵🏻‍♂️", name: "man in tuxedo: light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1225, SkinTone::Light)), aliases: None, variations: &["🤵🏻\u{200d}♂"] },
    Emoji { emoji: "🤵🏼‍♂️", name: "man in tuxedo: medium-light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1225, SkinTone::MediumLight)), aliases: None, variations: &["🤵🏼\u{200d}♂"] },
    Emoji { emoji: "🤵🏽‍♂️", name: "man in tuxedo: medium skin tone", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1225, SkinTone::Medium)), aliases: None, variations: &["🤵🏽\u{200d}♂"] },
    Emoji { emoji: "🤵🏾‍♂️", name: "man in tuxedo: medium-dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1225, SkinTone::MediumDark)), aliases: None, variations: &["🤵🏾\u{200d}♂"] },
    Emoji { emoji: "🤵🏿‍♂️", name: "man in tuxedo: dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1225, SkinTone::Dark)), aliases: None, variations: &["🤵🏿\u{200d}♂"] },
    Emoji { emoji: "🤵‍♀️", name: "woman in tuxedo", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1231, SkinTone::Default)), aliases: Some(&["woman_in_tuxedo"]), variations: &["🤵\u{200d}♀"] },
    Emoji { emoji: "🤵🏻‍♀️", name: "woman in tuxedo: light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1231, SkinTone::Light)), aliases: None, variations: &["🤵🏻\u{200d}♀"] },
    Emoji { emoji: "🤵🏼‍♀️", name: "woman in tuxedo: medium-light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1231, SkinTone::MediumLight)), aliases: None, variations: &["🤵🏼\u{200d}♀"] },
    Emoji { emoji: "🤵🏽‍♀️", name: "woman in tuxedo: medium skin tone", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1231, SkinTone::Medium)), aliases: None, variations: &["🤵🏽\u{200d}♀"] },
    Emoji { emoji: "🤵🏾‍♀️", name: "woman in tuxedo: medium-dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1231, SkinTone::MediumDark)), aliases: None, variations: &["🤵🏾\u{200d}♀"] },
    Emoji { emoji: "🤵🏿‍♀️", name: "woman in tuxedo: dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1231, SkinTone::Dark)), aliases: None, variations: &["🤵🏿\u{200d}♀"] },
    Emoji { emoji: "👰", name: "person with veil", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: Some((1237, SkinTone::Default)), aliases: Some(&["person_with_veil"]), variations: &[] },
    Emoji { emoji: "👰🏻", name: "person with veil: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1237, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "👰🏼", name: "person with veil: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1237, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "👰🏽", name: "person with veil: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1237, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "👰🏾", name: "person with veil: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1237, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "👰🏿", name: "person with veil: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1237, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "👰‍♂️", name: "man with veil", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1243, SkinTone::Default)), aliases: Some(&["man_with_veil"]), variations: &["👰\u{200d}♂"] },
    Emoji { emoji: "👰🏻‍♂️", name: "man with veil: light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1243, SkinTone::Light)), aliases: None, variations: &["👰🏻\u{200d}♂"] },
    Emoji { emoji: "👰🏼‍♂️", name: "man with veil: medium-light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1243, SkinTone::MediumLight)), aliases: None, variations: &["👰🏼\u{200d}♂"] },
    Emoji { emoji: "👰🏽‍♂️", name: "man with veil: medium skin tone", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1243, SkinTone::Medium)), aliases: None, variations: &["👰🏽\u{200d}♂"] },
    Emoji { emoji: "👰🏾‍♂️", name: "man with veil: medium-dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1243, SkinTone::MediumDark)), aliases: None, variations: &["👰🏾\u{200d}♂"] },
    Emoji { emoji: "👰🏿‍♂️", name: "man with veil: dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1243, SkinTone::Dark)), aliases: None, variations: &["👰🏿\u{200d}♂"] },
    Emoji { emoji: "👰‍♀️", name: "woman with veil", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1249, SkinTone::Default)), aliases: Some(&["woman_with_veil", "bride_with_veil"]), variations: &["👰\u{200d}♀"] },
    Emoji { emoji: "👰🏻‍♀️", name: "woman with veil: light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1249, SkinTone::Light)), aliases: None, variations: &["👰🏻\u{200d}♀"] },
    Emoji { emoji: "👰🏼‍♀️", name: "woman with veil: medium-light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1249, SkinTone::MediumLight)), aliases: None, variations: &["👰🏼\u{200d}♀"] },
    Emoji { emoji: "👰🏽‍♀️", name: "woman with veil: medium skin tone", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1249, SkinTone::Medium)), aliases: None, variations: &["👰🏽\u{200d}♀"] },
    Emoji { emoji: "👰🏾‍♀️", name: "woman with veil: medium-dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1249, SkinTone::MediumDark)), aliases: None, variations: &["👰🏾\u{200d}♀"] },
    Emoji { emoji: "👰🏿‍♀️", name: "woman with veil: dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1249, SkinTone::Dark)), aliases: None, variations: &["👰🏿\u{200d}♀"] },
    Emoji { emoji: "🤰", name: "pregnant woman", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1255, SkinTone::Default)), aliases: Some(&["pregnant_woman"]), variations: &[] },
    Emoji { emoji: "🤰🏻", name: "pregnant woman: light skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1255, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "🤰🏼", name: "pregnant woman: medium-light skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1255, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "🤰🏽", name: "pregnant woman: medium skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1255, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "🤰🏾", name: "pregnant woman: medium-dark skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1255, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "🤰🏿", name: "pregnant woman: dark skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1255, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "🫃", name: "pregnant man", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1261, SkinTone::Default)), aliases: None, variations: &[] },
    Emoji { emoji: "🫃🏻", name: "pregnant man: light skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1261, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "🫃🏼", name: "pregnant man: medium-light skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1261, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "🫃🏽", name: "pregnant man: medium skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1261, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "🫃🏾", name: "pregnant man: medium-dark skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1261, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "🫃🏿", name: "pregnant man: dark skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1261, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "🫄", name: "pregnant person", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1267, SkinTone::Default)), aliases: None, variations: &[] },
    Emoji { emoji: "🫄🏻", name: "pregnant person: light skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1267, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "🫄🏼", name: "pregnant person: medium-light skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1267, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "🫄🏽", name: "pregnant person: medium skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1267, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "🫄🏾", name: "pregnant person: medium-dark skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1267, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "🫄🏿", name: "pregnant person: dark skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1267, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "🤱", name: "breast-feeding", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1273, SkinTone::Default)), aliases: Some(&["breast_feeding"]), variations: &[] },
    Emoji { emoji: "🤱🏻", name: "breast-feeding: light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1273, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "🤱🏼", name: "breast-feeding: medium-light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1273, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "🤱🏽", name: "breast-feeding: medium skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1273, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "🤱🏾", name: "breast-feeding: medium-dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1273, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "🤱🏿", name: "breast-feeding: dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1273, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "👩‍🍼", name: "woman feeding baby", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1279, SkinTone::Default)), aliases: Some(&["woman_feeding_baby"]), variations: &[] },
    Emoji { emoji: "👩🏻‍🍼", name: "woman feeding baby: light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1279, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "👩🏼‍🍼", name: "woman feeding baby: medium-light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1279, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "👩🏽‍🍼", name: "woman feeding baby: medium skin tone", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1279, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "👩🏾‍🍼", name: "woman feeding baby: medium-dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1279, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "👩🏿‍🍼", name: "woman feeding baby: dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1279, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "👨‍🍼", name: "man feeding baby", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1285, SkinTone::Default)), aliases: Some(&["man_feeding_baby"]), variations: &[] },
    Emoji { emoji: "👨🏻‍🍼", name: "man feeding baby: light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1285, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "👨🏼‍🍼", name: "man feeding baby: medium-light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1285, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "👨🏽‍🍼", name: "man feeding baby: medium skin tone", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1285, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "👨🏾‍🍼", name: "man feeding baby: medium-dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1285, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "👨🏿‍🍼", name: "man feeding baby: dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1285, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "🧑‍🍼", name: "person feeding baby", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1291, SkinTone::Default)), aliases: Some(&["person_feeding_baby"]), variations: &[] },
    Emoji { emoji: "🧑🏻‍🍼", name: "person feeding baby: light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1291, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "🧑🏼‍🍼", name: "person feeding baby: medium-light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1291, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "🧑🏽‍🍼", name: "person feeding baby: medium skin tone", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1291, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "🧑🏾‍🍼", name: "person feeding baby: medium-dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1291, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "🧑🏿‍🍼", name: "person feeding baby: dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1291, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "👼", name: "baby angel", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: Some((1297, SkinTone::Default)), aliases: Some(&["angel"]), variations: &[] },
    Emoji { emoji: "👼🏻", name: "baby angel: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1297, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "👼🏼", name: "baby angel: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1297, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "👼🏽", name: "baby angel: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1297, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "👼🏾", name: "baby angel: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1297, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "👼🏿", name: "baby angel: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1297, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "🎅", name: "Santa Claus", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: Some((1303, SkinTone::Default)), aliases: Some(&["santa"]), variations: &[] },
    Emoji { emoji: "🎅🏻", name: "Santa Claus: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1303, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "🎅🏼", name: "Santa Claus: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1303, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "🎅🏽", name: "Santa Claus: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1303, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "🎅🏾", name: "Santa Claus: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1303, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "🎅🏿", name: "Santa Claus: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1303, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "🤶", name: "Mrs. Claus", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1309, SkinTone::Default)), aliases: Some(&["mrs_claus"]), variations: &[] },
    Emoji { emoji: "🤶🏻", name: "Mrs. Claus: light skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1309, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "🤶🏼", name: "Mrs. Claus: medium-light skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1309, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "🤶🏽", name: "Mrs. Claus: medium skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1309, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "🤶🏾", name: "Mrs. Claus: medium-dark skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1309, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "🤶🏿", name: "Mrs. Claus: dark skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1309, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "🧑‍🎄", name: "mx claus", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1315, SkinTone::Default)), aliases: Some(&["mx_claus"]), variations: &[] },
    Emoji { emoji: "🧑🏻‍🎄", name: "mx claus: light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1315, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "🧑🏼‍🎄", name: "mx claus: medium-light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1315, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "🧑🏽‍🎄", name: "mx claus: medium skin tone", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1315, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "🧑🏾‍🎄", name: "mx claus: medium-dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1315, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "🧑🏿‍🎄", name: "mx claus: dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1315, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "🦸", name: "superhero", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1321, SkinTone::Default)), aliases: Some(&["superhero"]), variations: &[] },
    Emoji { emoji: "🦸🏻", name: "superhero: light skin tone", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1321, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "🦸🏼", name: "superhero: medium-light skin tone", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1321, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "🦸🏽", name: "superhero: medium skin tone", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1321, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "🦸🏾", name: "superhero: medium-dark skin tone", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1321, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "🦸🏿", name: "superhero: dark skin tone", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1321, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "🦸‍♂️", name: "man superhero", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1327, SkinTone::Default)), aliases: Some(&["superhero_man"]), variations: &["🦸\u{200d}♂"] },
    Emoji { emoji: "🦸🏻‍♂️", name: "man superhero: light skin tone", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1327, SkinTone::Light)), aliases: None, variations: &["🦸🏻\u{200d}♂"] },
    Emoji { emoji: "🦸🏼‍♂️", name: "man superhero: medium-light skin tone", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1327, SkinTone::MediumLight)), aliases: None, variations: &["🦸🏼\u{200d}♂"] },
    Emoji { emoji: "🦸🏽‍♂️", name: "man superhero: medium skin tone", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1327, SkinTone::Medium)), aliases: None, variations: &["🦸🏽\u{200d}♂"] },
    Emoji { emoji: "🦸🏾‍♂️", name: "man superhero: medium-dark skin tone", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1327, SkinTone::MediumDark)), aliases: None, variations: &["🦸🏾\u{200d}♂"] },
    Emoji { emoji: "🦸🏿‍♂️", name: "man superhero: dark skin tone", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1327, SkinTone::Dark)), aliases: None, variations: &["🦸🏿\u{200d}♂"] },
    Emoji { emoji: "🦸‍♀️", name: "woman superhero", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1333, SkinTone::Default)), aliases: Some(&["superhero_woman"]), variations: &["🦸\u{200d}♀"] },
    Emoji { emoji: "🦸🏻‍♀️", name: "woman superhero: light skin tone", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1333, SkinTone::Light)), aliases: None, variations: &["🦸🏻\u{200d}♀"] },
    Emoji { emoji: "🦸🏼‍♀️", name: "woman superhero: medium-light skin tone", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1333, SkinTone::MediumLight)), aliases: None, variations: &["🦸🏼\u{200d}♀"] },
    Emoji { emoji: "🦸🏽‍♀️", name: "woman superhero: medium skin tone", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1333, SkinTone::Medium)), aliases: None, variations: &["🦸🏽\u{200d}♀"] },
    Emoji { emoji: "🦸🏾‍♀️", name: "woman superhero: medium-dark skin tone", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1333, SkinTone::MediumDark)), aliases: None, variations: &["🦸🏾\u{200d}♀"] },
    Emoji { emoji: "🦸🏿‍♀️", name: "woman superhero: dark skin tone", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1333, SkinTone::Dark)), aliases: None, variations: &["🦸🏿\u{200d}♀"] },
    Emoji { emoji: "🦹", name: "supervillain", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1339, SkinTone::Default)), aliases: Some(&["supervillain"]), variations: &[] },
    Emoji { emoji: "🦹🏻", name: "supervillain: light skin tone", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1339, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "🦹🏼", name: "supervillain: medium-light skin tone", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1339, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "🦹🏽", name: "supervillain: medium skin tone", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1339, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "🦹🏾", name: "supervillain: medium-dark skin tone", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1339, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "🦹🏿", name: "supervillain: dark skin tone", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1339, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "🦹‍♂️", name: "man supervillain", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1345, SkinTone::Default)), aliases: Some(&["supervillain_man"]), variations: &["🦹\u{200d}♂"] },
    Emoji { emoji: "🦹🏻‍♂️", name: "man supervillain: light skin tone", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1345, SkinTone::Light)), aliases: None, variations: &["🦹🏻\u{200d}♂"] },
    Emoji { emoji: "🦹🏼‍♂️", name: "man supervillain: medium-light skin tone", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1345, SkinTone::MediumLight)), aliases: None, variations: &["🦹🏼\u{200d}♂"] },
    Emoji { emoji: "🦹🏽‍♂️", name: "man supervillain: medium skin tone", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1345, SkinTone::Medium)), aliases: None, variations: &["🦹🏽\u{200d}♂"] },
    Emoji { emoji: "🦹🏾‍♂️", name: "man supervillain: medium-dark skin tone", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1345, SkinTone::MediumDark)), aliases: None, variations: &["🦹🏾\u{200d}♂"] },
    Emoji { emoji: "🦹🏿‍♂️", name: "man supervillain: dark skin tone", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1345, SkinTone::Dark)), aliases: None, variations: &["🦹🏿\u{200d}♂"] },
    Emoji { emoji: "🦹‍♀️", name: "woman supervillain", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1351, SkinTone::Default)), aliases: Some(&["supervillain_woman"]), variations: &["🦹\u{200d}♀"] },
    Emoji { emoji: "🦹🏻‍♀️", name: "woman supervillain: light skin tone", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1351, SkinTone::Light)), aliases: None, variations: &["🦹🏻\u{200d}♀"] },
    Emoji { emoji: "🦹🏼‍♀️", name: "woman supervillain: medium-light skin tone", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1351, SkinTone::MediumLight)), aliases: None, variations: &["🦹🏼\u{200d}♀"] },
    Emoji { emoji: "🦹🏽‍♀️", name: "woman supervillain: medium skin tone", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1351, SkinTone::Medium)), aliases: None, variations: &["🦹🏽\u{200d}♀"] },
    Emoji { emoji: "🦹🏾‍♀️", name: "woman supervillain: medium-dark skin tone", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1351, SkinTone::MediumDark)), aliases: None, variations: &["🦹🏾\u{200d}♀"] },
    Emoji { emoji: "🦹🏿‍♀️", name: "woman supervillain: dark skin tone", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1351, SkinTone::Dark)), aliases: None, variations: &["🦹🏿\u{200d}♀"] },
    Emoji { emoji: "🧙", name: "mage", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1357, SkinTone::Default)), aliases: Some(&["mage"]), variations: &[] },
    Emoji { emoji: "🧙🏻", name: "mage: light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1357, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "🧙🏼", name: "mage: medium-light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1357, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "🧙🏽", name: "mage: medium skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1357, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "🧙🏾", name: "mage: medium-dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1357, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "🧙🏿", name: "mage: dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1357, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "🧙‍♂️", name: "man mage", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1363, SkinTone::Default)), aliases: Some(&["mage_man"]), variations: &["🧙\u{200d}♂"] },
    Emoji { emoji: "🧙🏻‍♂️", name: "man mage: light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1363, SkinTone::Light)), aliases: None, variations: &["🧙🏻\u{200d}♂"] },
    Emoji { emoji: "🧙🏼‍♂️", name: "man mage: medium-light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1363, SkinTone::MediumLight)), aliases: None, variations: &["🧙🏼\u{200d}♂"] },
    Emoji { emoji: "🧙🏽‍♂️", name: "man mage: medium skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1363, SkinTone::Medium)), aliases: None, variations: &["🧙🏽\u{200d}♂"] },
    Emoji { emoji: "🧙🏾‍♂️", name: "man mage: medium-dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1363, SkinTone::MediumDark)), aliases: None, variations: &["🧙🏾\u{200d}♂"] },
    Emoji { emoji: "🧙🏿‍♂️", name: "man mage: dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1363, SkinTone::Dark)), aliases: None, variations: &["🧙🏿\u{200d}♂"] },
    Emoji { emoji: "🧙‍♀️", name: "woman mage", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1369, SkinTone::Default)), aliases: Some(&["mage_woman"]), variations: &["🧙\u{200d}♀"] },
    Emoji { emoji: "🧙🏻‍♀️", name: "woman mage: light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1369, SkinTone::Light)), aliases: None, variations: &["🧙🏻\u{200d}♀"] },
    Emoji { emoji: "🧙🏼‍♀️", name: "woman mage: medium-light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1369, SkinTone::MediumLight)), aliases: None, variations: &["🧙🏼\u{200d}♀"] },
    Emoji { emoji: "🧙🏽‍♀️", name: "woman mage: medium skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1369, SkinTone::Medium)), aliases: None, variations: &["🧙🏽\u{200d}♀"] },
    Emoji { emoji: "🧙🏾‍♀️", name: "woman mage: medium-dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1369, SkinTone::MediumDark)), aliases: None, variations: &["🧙🏾\u{200d}♀"] },
    Emoji { emoji: "🧙🏿‍♀️", name: "woman mage: dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1369, SkinTone::Dark)), aliases: None, variations: &["🧙🏿\u{200d}♀"] },
    Emoji { emoji: "🧚", name: "fairy", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1375, SkinTone::Default)), aliases: Some(&["fairy"]), variations: &[] },
    Emoji { emoji: "🧚🏻", name: "fairy: light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1375, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "🧚🏼", name: "fairy: medium-light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1375, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "🧚🏽", name: "fairy: medium skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1375, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "🧚🏾", name: "fairy: medium-dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1375, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "🧚🏿", name: "fairy: dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1375, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "🧚‍♂️", name: "man fairy", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1381, SkinTone::Default)), aliases: Some(&["fairy_man"]), variations: &["🧚\u{200d}♂"] },
    Emoji { emoji: "🧚🏻‍♂️", name: "man fairy: light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1381, SkinTone::Light)), aliases: None, variations: &["🧚🏻\u{200d}♂"] },
    Emoji { emoji: "🧚🏼‍♂️", name: "man fairy: medium-light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1381, SkinTone::MediumLight)), aliases: None, variations: &["🧚🏼\u{200d}♂"] },
    Emoji { emoji: "🧚🏽‍♂️", name: "man fairy: medium skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1381, SkinTone::Medium)), aliases: None, variations: &["🧚🏽\u{200d}♂"] },
    Emoji { emoji: "🧚🏾‍♂️", name: "man fairy: medium-dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1381, SkinTone::MediumDark)), aliases: None, variations: &["🧚🏾\u{200d}♂"] },
    Emoji { emoji: "🧚🏿‍♂️", name: "man fairy: dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1381, SkinTone::Dark)), aliases: None, variations: &["🧚🏿\u{200d}♂"] },
    Emoji { emoji: "🧚‍♀️", name: "woman fairy", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1387, SkinTone::Default)), aliases: Some(&["fairy_woman"]), variations: &["🧚\u{200d}♀"] },
    Emoji { emoji: "🧚🏻‍♀️", name: "woman fairy: light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1387, SkinTone::Light)), aliases: None, variations: &["🧚🏻\u{200d}♀"] },
    Emoji { emoji: "🧚🏼‍♀️", name: "woman fairy: medium-light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1387, SkinTone::MediumLight)), aliases: None, variations: &["🧚🏼\u{200d}♀"] },
    Emoji { emoji: "🧚🏽‍♀️", name: "woman fairy: medium skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1387, SkinTone::Medium)), aliases: None, variations: &["🧚🏽\u{200d}♀"] },
    Emoji { emoji: "🧚🏾‍♀️", name: "woman fairy: medium-dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1387, SkinTone::MediumDark)), aliases: None, variations: &["🧚🏾\u{200d}♀"] },
    Emoji { emoji: "🧚🏿‍♀️", name: "woman fairy: dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1387, SkinTone::Dark)), aliases: None, variations: &["🧚🏿\u{200d}♀"] },
    Emoji { emoji: "🧛", name: "vampire", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1393, SkinTone::Default)), aliases: Some(&["vampire"]), variations: &[] },
    Emoji { emoji: "🧛🏻", name: "vampire: light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1393, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "🧛🏼", name: "vampire: medium-light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1393, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "🧛🏽", name: "vampire: medium skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1393, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "🧛🏾", name: "vampire: medium-dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1393, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "🧛🏿", name: "vampire: dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1393, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "🧛‍♂️", name: "man vampire", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1399, SkinTone::Default)), aliases: Some(&["vampire_man"]), variations: &["🧛\u{200d}♂"] },
    Emoji { emoji: "🧛🏻‍♂️", name: "man vampire: light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1399, SkinTone::Light)), aliases: None, variations: &["🧛🏻\u{200d}♂"] },
    Emoji { emoji: "🧛🏼‍♂️", name: "man vampire: medium-light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1399, SkinTone::MediumLight)), aliases: None, variations: &["🧛🏼\u{200d}♂"] },
    Emoji { emoji: "🧛🏽‍♂️", name: "man vampire: medium skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1399, SkinTone::Medium)), aliases: None, variations: &["🧛🏽\u{200d}♂"] },
    Emoji { emoji: "🧛🏾‍♂️", name: "man vampire: medium-dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1399, SkinTone::MediumDark)), aliases: None, variations: &["🧛🏾\u{200d}♂"] },
    Emoji { emoji: "🧛🏿‍♂️", name: "man vampire: dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1399, SkinTone::Dark)), aliases: None, variations: &["🧛🏿\u{200d}♂"] },
    Emoji { emoji: "🧛‍♀️", name: "woman vampire", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1405, SkinTone::Default)), aliases: Some(&["vampire_woman"]), variations: &["🧛\u{200d}♀"] },
    Emoji { emoji: "🧛🏻‍♀️", name: "woman vampire: light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1405, SkinTone::Light)), aliases: None, variations: &["🧛🏻\u{200d}♀"] },
    Emoji { emoji: "🧛🏼‍♀️", name: "woman vampire: medium-light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1405, SkinTone::MediumLight)), aliases: None, variations: &["🧛🏼\u{200d}♀"] },
    Emoji { emoji: "🧛🏽‍♀️", name: "woman vampire: medium skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1405, SkinTone::Medium)), aliases: None, variations: &["🧛🏽\u{200d}♀"] },
    Emoji { emoji: "🧛🏾‍♀️", name: "woman vampire: medium-dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1405, SkinTone::MediumDark)), aliases: None, variations: &["🧛🏾\u{200d}♀"] },
    Emoji { emoji: "🧛🏿‍♀️", name: "woman vampire: dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1405, SkinTone::Dark)), aliases: None, variations: &["🧛🏿\u{200d}♀"] },
    Emoji { emoji: "🧜", name: "merperson", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1411, SkinTone::Default)), aliases: Some(&["merperson"]), variations: &[] },
    Emoji { emoji: "🧜🏻", name: "merperson: light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1411, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "🧜🏼", name: "merperson: medium-light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1411, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "🧜🏽", name: "merperson: medium skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1411, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "🧜🏾", name: "merperson: medium-dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1411, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "🧜🏿", name: "merperson: dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1411, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "🧜‍♂️", name: "merman", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1417, SkinTone::Default)), aliases: Some(&["merman"]), variations: &["🧜\u{200d}♂"] },
    Emoji { emoji: "🧜🏻‍♂️", name: "merman: light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1417, SkinTone::Light)), aliases: None, variations: &["🧜🏻\u{200d}♂"] },
    Emoji { emoji: "🧜🏼‍♂️", name: "merman: medium-light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1417, SkinTone::MediumLight)), aliases: None, variations: &["🧜🏼\u{200d}♂"] },
    Emoji { emoji: "🧜🏽‍♂️", name: "merman: medium skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1417, SkinTone::Medium)), aliases: None, variations: &["🧜🏽\u{200d}♂"] },
    Emoji { emoji: "🧜🏾‍♂️", name: "merman: medium-dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1417, SkinTone::MediumDark)), aliases: None, variations: &["🧜🏾\u{200d}♂"] },
    Emoji { emoji: "🧜🏿‍♂️", name: "merman: dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1417, SkinTone::Dark)), aliases: None, variations: &["🧜🏿\u{200d}♂"] },
    Emoji { emoji: "🧜‍♀️", name: "mermaid", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1423, SkinTone::Default)), aliases: Some(&["mermaid"]), variations: &["🧜\u{200d}♀"] },
    Emoji { emoji: "🧜🏻‍♀️", name: "mermaid: light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1423, SkinTone::Light)), aliases: None, variations: &["🧜🏻\u{200d}♀"] },
    Emoji { emoji: "🧜🏼‍♀️", name: "mermaid: medium-light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1423, SkinTone::MediumLight)), aliases: None, variations: &["🧜🏼\u{200d}♀"] },
    Emoji { emoji: "🧜🏽‍♀️", name: "mermaid: medium skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1423, SkinTone::Medium)), aliases: None, variations: &["🧜🏽\u{200d}♀"] },
    Emoji { emoji: "🧜🏾‍♀️", name: "mermaid: medium-dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1423, SkinTone::MediumDark)), aliases: None, variations: &["🧜🏾\u{200d}♀"] },
    Emoji { emoji: "🧜🏿‍♀️", name: "mermaid: dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1423, SkinTone::Dark)), aliases: None, variations: &["🧜🏿\u{200d}♀"] },
    Emoji { emoji: "🧝", name: "elf", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1429, SkinTone::Default)), aliases: Some(&["elf"]), variations: &[] },
    Emoji { emoji: "🧝🏻", name: "elf: light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1429, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "🧝🏼", name: "elf: medium-light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1429, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "🧝🏽", name: "elf: medium skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1429, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "🧝🏾", name: "elf: medium-dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1429, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "🧝🏿", name: "elf: dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1429, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "🧝‍♂️", name: "man elf", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1435, SkinTone::Default)), aliases: Some(&["elf_man"]), variations: &["🧝\u{200d}♂"] },
    Emoji { emoji: "🧝🏻‍♂️", name: "man elf: light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1435, SkinTone::Light)), aliases: None, variations: &["🧝🏻\u{200d}♂"] },
    Emoji { emoji: "🧝🏼‍♂️", name: "man elf: medium-light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1435, SkinTone::MediumLight)), aliases: None, variations: &["🧝🏼\u{200d}♂"] },
    Emoji { emoji: "🧝🏽‍♂️", name: "man elf: medium skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1435, SkinTone::Medium)), aliases: None, variations: &["🧝🏽\u{200d}♂"] },
    Emoji { emoji: "🧝🏾‍♂️", name: "man elf: medium-dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1435, SkinTone::MediumDark)), aliases: None, variations: &["🧝🏾\u{200d}♂"] },
    Emoji { emoji: "🧝🏿‍♂️", name: "man elf: dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1435, SkinTone::Dark)), aliases: None, variations: &["🧝🏿\u{200d}♂"] },
    Emoji { emoji: "🧝‍♀️", name: "woman elf", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1441, SkinTone::Default)), aliases: Some(&["elf_woman"]), variations: &["🧝\u{200d}♀"] },
    Emoji { emoji: "🧝🏻‍♀️", name: "woman elf: light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1441, SkinTone::Light)), aliases: None, variations: &["🧝🏻\u{200d}♀"] },
    Emoji { emoji: "🧝🏼‍♀️", name: "woman elf: medium-light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1441, SkinTone::MediumLight)), aliases: None, variations: &["🧝🏼\u{200d}♀"] },
    Emoji { emoji: "🧝🏽‍♀️", name: "woman elf: medium skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1441, SkinTone::Medium)), aliases: None, variations: &["🧝🏽\u{200d}♀"] },
    Emoji { emoji: "🧝🏾‍♀️", name: "woman elf: medium-dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1441, SkinTone::MediumDark)), aliases: None, variations: &["🧝🏾\u{200d}♀"] },
    Emoji { emoji: "🧝🏿‍♀️", name: "woman elf: dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1441, SkinTone::Dark)), aliases: None, variations: &["🧝🏿\u{200d}♀"] },
    Emoji { emoji: "🧞", name: "genie", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["genie"]), variations: &[] },
    Emoji { emoji: "🧞‍♂️", name: "man genie", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["genie_man"]), variations: &["🧞\u{200d}♂"] },
    Emoji { emoji: "🧞‍♀️", name: "woman genie", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["genie_woman"]), variations: &["🧞\u{200d}♀"] },
    Emoji { emoji: "🧟", name: "zombie", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["zombie"]), variations: &[] },
    Emoji { emoji: "🧟‍♂️", name: "man zombie", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["zombie_man"]), variations: &["🧟\u{200d}♂"] },
    Emoji { emoji: "🧟‍♀️", name: "woman zombie", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["zombie_woman"]), variations: &["🧟\u{200d}♀"] },
    Emoji { emoji: "🧌", name: "troll", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: None, aliases: None, variations: &[] },
    Emoji { emoji: "💆", name: "person getting massage", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: Some((1454, SkinTone::Default)), aliases: Some(&["massage"]), variations: &[] },
    Emoji { emoji: "💆🏻", name: "person getting massage: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1454, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "💆🏼", name: "person getting massage: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1454, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "💆🏽", name: "person getting massage: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1454, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "💆🏾", name: "person getting massage: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1454, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "💆🏿", name: "person getting massage: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1454, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "💆‍♂️", name: "man getting massage", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1460, SkinTone::Default)), aliases: Some(&["massage_man"]), variations: &["💆\u{200d}♂"] },
    Emoji { emoji: "💆🏻‍♂️", name: "man getting massage: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1460, SkinTone::Light)), aliases: None, variations: &["💆🏻\u{200d}♂"] },
    Emoji { emoji: "💆🏼‍♂️", name: "man getting massage: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1460, SkinTone::MediumLight)), aliases: None, variations: &["💆🏼\u{200d}♂"] },
    Emoji { emoji: "💆🏽‍♂️", name: "man getting massage: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1460, SkinTone::Medium)), aliases: None, variations: &["💆🏽\u{200d}♂"] },
    Emoji { emoji: "💆🏾‍♂️", name: "man getting massage: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1460, SkinTone::MediumDark)), aliases: None, variations: &["💆🏾\u{200d}♂"] },
    Emoji { emoji: "💆🏿‍♂️", name: "man getting massage: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1460, SkinTone::Dark)), aliases: None, variations: &["💆🏿\u{200d}♂"] },
    Emoji { emoji: "💆‍♀️", name: "woman getting massage", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1466, SkinTone::Default)), aliases: Some(&["massage_woman"]), variations: &["💆\u{200d}♀"] },
    Emoji { emoji: "💆🏻‍♀️", name: "woman getting massage: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1466, SkinTone::Light)), aliases: None, variations: &["💆🏻\u{200d}♀"] },
    Emoji { emoji: "💆🏼‍♀️", name: "woman getting massage: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1466, SkinTone::MediumLight)), aliases: None, variations: &["💆🏼\u{200d}♀"] },
    Emoji { emoji: "💆🏽‍♀️", name: "woman getting massage: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1466, SkinTone::Medium)), aliases: None, variations: &["💆🏽\u{200d}♀"] },
    Emoji { emoji: "💆🏾‍♀️", name: "woman getting massage: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1466, SkinTone::MediumDark)), aliases: None, variations: &["💆🏾\u{200d}♀"] },
    Emoji { emoji: "💆🏿‍♀️", name: "woman getting massage: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1466, SkinTone::Dark)), aliases: None, variations: &["💆🏿\u{200d}♀"] },
    Emoji { emoji: "💇", name: "person getting haircut", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: Some((1472, SkinTone::Default)), aliases: Some(&["haircut"]), variations: &[] },
    Emoji { emoji: "💇🏻", name: "person getting haircut: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1472, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "💇🏼", name: "person getting haircut: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1472, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "💇🏽", name: "person getting haircut: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1472, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "💇🏾", name: "person getting haircut: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1472, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "💇🏿", name: "person getting haircut: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1472, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "💇‍♂️", name: "man getting haircut", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1478, SkinTone::Default)), aliases: Some(&["haircut_man"]), variations: &["💇\u{200d}♂"] },
    Emoji { emoji: "💇🏻‍♂️", name: "man getting haircut: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1478, SkinTone::Light)), aliases: None, variations: &["💇🏻\u{200d}♂"] },
    Emoji { emoji: "💇🏼‍♂️", name: "man getting haircut: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1478, SkinTone::MediumLight)), aliases: None, variations: &["💇🏼\u{200d}♂"] },
    Emoji { emoji: "💇🏽‍♂️", name: "man getting haircut: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1478, SkinTone::Medium)), aliases: None, variations: &["💇🏽\u{200d}♂"] },
    Emoji { emoji: "💇🏾‍♂️", name: "man getting haircut: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1478, SkinTone::MediumDark)), aliases: None, variations: &["💇🏾\u{200d}♂"] },
    Emoji { emoji: "💇🏿‍♂️", name: "man getting haircut: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1478, SkinTone::Dark)), aliases: None, variations: &["💇🏿\u{200d}♂"] },
    Emoji { emoji: "💇‍♀️", name: "woman getting haircut", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1484, SkinTone::Default)), aliases: Some(&["haircut_woman"]), variations: &["💇\u{200d}♀"] },
    Emoji { emoji: "💇🏻‍♀️", name: "woman getting haircut: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1484, SkinTone::Light)), aliases: None, variations: &["💇🏻\u{200d}♀"] },
    Emoji { emoji: "💇🏼‍♀️", name: "woman getting haircut: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1484, SkinTone::MediumLight)), aliases: None, variations: &["💇🏼\u{200d}♀"] },
    Emoji { emoji: "💇🏽‍♀️", name: "woman getting haircut: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1484, SkinTone::Medium)), aliases: None, variations: &["💇🏽\u{200d}♀"] },
    Emoji { emoji: "💇🏾‍♀️", name: "woman getting haircut: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1484, SkinTone::MediumDark)), aliases: None, variations: &["💇🏾\u{200d}♀"] },
    Emoji { emoji: "💇🏿‍♀️", name: "woman getting haircut: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1484, SkinTone::Dark)), aliases: None, variations: &["💇🏿\u{200d}♀"] },
    Emoji { emoji: "🚶", name: "person walking", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: Some((1490, SkinTone::Default)), aliases: Some(&["walking"]), variations: &[] },
    Emoji { emoji: "🚶🏻", name: "person walking: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1490, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "🚶🏼", name: "person walking: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1490, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "🚶🏽", name: "person walking: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1490, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "🚶🏾", name: "person walking: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1490, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "🚶🏿", name: "person walking: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1490, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "🚶‍♂️", name: "man walking", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1496, SkinTone::Default)), aliases: Some(&["walking_man"]), variations: &["🚶\u{200d}♂"] },
    Emoji { emoji: "🚶🏻‍♂️", name: "man walking: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1496, SkinTone::Light)), aliases: None, variations: &["🚶🏻\u{200d}♂"] },
    Emoji { emoji: "🚶🏼‍♂️", name: "man walking: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1496, SkinTone::MediumLight)), aliases: None, variations: &["🚶🏼\u{200d}♂"] },
    Emoji { emoji: "🚶🏽‍♂️", name: "man walking: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1496, SkinTone::Medium)), aliases: None, variations: &["🚶🏽\u{200d}♂"] },
    Emoji { emoji: "🚶🏾‍♂️", name: "man walking: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1496, SkinTone::MediumDark)), aliases: None, variations: &["🚶🏾\u{200d}♂"] },
    Emoji { emoji: "🚶🏿‍♂️", name: "man walking: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1496, SkinTone::Dark)), aliases: None, variations: &["🚶🏿\u{200d}♂"] },
    Emoji { emoji: "🚶‍♀️", name: "woman walking", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1502, SkinTone::Default)), aliases: Some(&["walking_woman"]), variations: &["🚶\u{200d}♀"] },
    Emoji { emoji: "🚶🏻‍♀️", name: "woman walking: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1502, SkinTone::Light)), aliases: None, variations: &["🚶🏻\u{200d}♀"] },
    Emoji { emoji: "🚶🏼‍♀️", name: "woman walking: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1502, SkinTone::MediumLight)), aliases: None, variations: &["🚶🏼\u{200d}♀"] },
    Emoji { emoji: "🚶🏽‍♀️", name: "woman walking: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1502, SkinTone::Medium)), aliases: None, variations: &["🚶🏽\u{200d}♀"] },
    Emoji { emoji: "🚶🏾‍♀️", name: "woman walking: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1502, SkinTone::MediumDark)), aliases: None, variations: &["🚶🏾\u{200d}♀"] },
    Emoji { emoji: "🚶🏿‍♀️", name: "woman walking: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1502, SkinTone::Dark)), aliases: None, variations: &["🚶🏿\u{200d}♀"] },
    Emoji { emoji: "🧍", name: "person standing", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1508, SkinTone::Default)), aliases: Some(&["standing_person"]), variations: &[] },
    Emoji { emoji: "🧍🏻", name: "person standing: light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1508, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "🧍🏼", name: "person standing: medium-light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1508, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "🧍🏽", name: "person standing: medium skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1508, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "🧍🏾", name: "person standing: medium-dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1508, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "🧍🏿", name: "person standing: dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1508, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "🧍‍♂️", name: "man standing", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1514, SkinTone::Default)), aliases: Some(&["standing_man"]), variations: &["🧍\u{200d}♂"] },
    Emoji { emoji: "🧍🏻‍♂️", name: "man standing: light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1514, SkinTone::Light)), aliases: None, variations: &["🧍🏻\u{200d}♂"] },
    Emoji { emoji: "🧍🏼‍♂️", name: "man standing: medium-light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1514, SkinTone::MediumLight)), aliases: None, variations: &["🧍🏼\u{200d}♂"] },
    Emoji { emoji: "🧍🏽‍♂️", name: "man standing: medium skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1514, SkinTone::Medium)), aliases: None, variations: &["🧍🏽\u{200d}♂"] },
    Emoji { emoji: "🧍🏾‍♂️", name: "man standing: medium-dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1514, SkinTone::MediumDark)), aliases: None, variations: &["🧍🏾\u{200d}♂"] },
    Emoji { emoji: "🧍🏿‍♂️", name: "man standing: dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1514, SkinTone::Dark)), aliases: None, variations: &["🧍🏿\u{200d}♂"] },
    Emoji { emoji: "🧍‍♀️", name: "woman standing", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1520, SkinTone::Default)), aliases: Some(&["standing_woman"]), variations: &["🧍\u{200d}♀"] },
    Emoji { emoji: "🧍🏻‍♀️", name: "woman standing: light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1520, SkinTone::Light)), aliases: None, variations: &["🧍🏻\u{200d}♀"] },
    Emoji { emoji: "🧍🏼‍♀️", name: "woman standing: medium-light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1520, SkinTone::MediumLight)), aliases: None, variations: &["🧍🏼\u{200d}♀"] },
    Emoji { emoji: "🧍🏽‍♀️", name: "woman standing: medium skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1520, SkinTone::Medium)), aliases: None, variations: &["🧍🏽\u{200d}♀"] },
    Emoji { emoji: "🧍🏾‍♀️", name: "woman standing: medium-dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1520, SkinTone::MediumDark)), aliases: None, variations: &["🧍🏾\u{200d}♀"] },
    Emoji { emoji: "🧍🏿‍♀️", name: "woman standing: dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1520, SkinTone::Dark)), aliases: None, variations: &["🧍🏿\u{200d}♀"] },
    Emoji { emoji: "🧎", name: "person kneeling", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1526, SkinTone::Default)), aliases: Some(&["kneeling_person"]), variations: &[] },
    Emoji { emoji: "🧎🏻", name: "person kneeling: light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1526, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "🧎🏼", name: "person kneeling: medium-light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1526, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "🧎🏽", name: "person kneeling: medium skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1526, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "🧎🏾", name: "person kneeling: medium-dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1526, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "🧎🏿", name: "person kneeling: dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1526, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "🧎‍♂️", name: "man kneeling", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1532, SkinTone::Default)), aliases: Some(&["kneeling_man"]), variations: &["🧎\u{200d}♂"] },
    Emoji { emoji: "🧎🏻‍♂️", name: "man kneeling: light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1532, SkinTone::Light)), aliases: None, variations: &["🧎🏻\u{200d}♂"] },
    Emoji { emoji: "🧎🏼‍♂️", name: "man kneeling: medium-light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1532, SkinTone::MediumLight)), aliases: None, variations: &["🧎🏼\u{200d}♂"] },
    Emoji { emoji: "🧎🏽‍♂️", name: "man kneeling: medium skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1532, SkinTone::Medium)), aliases: None, variations: &["🧎🏽\u{200d}♂"] },
    Emoji { emoji: "🧎🏾‍♂️", name: "man kneeling: medium-dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1532, SkinTone::MediumDark)), aliases: None, variations: &["🧎🏾\u{200d}♂"] },
    Emoji { emoji: "🧎🏿‍♂️", name: "man kneeling: dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1532, SkinTone::Dark)), aliases: None, variations: &["🧎🏿\u{200d}♂"] },
    Emoji { emoji: "🧎‍♀️", name: "woman kneeling", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1538, SkinTone::Default)), aliases: Some(&["kneeling_woman"]), variations: &["🧎\u{200d}♀"] },
    Emoji { emoji: "🧎🏻‍♀️", name: "woman kneeling: light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1538, SkinTone::Light)), aliases: None, variations: &["🧎🏻\u{200d}♀"] },
    Emoji { emoji: "🧎🏼‍♀️", name: "woman kneeling: medium-light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1538, SkinTone::MediumLight)), aliases: None, variations: &["🧎🏼\u{200d}♀"] },
    Emoji { emoji: "🧎🏽‍♀️", name: "woman kneeling: medium skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1538, SkinTone::Medium)), aliases: None, variations: &["🧎🏽\u{200d}♀"] },
    Emoji { emoji: "🧎🏾‍♀️", name: "woman kneeling: medium-dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1538, SkinTone::MediumDark)), aliases: None, variations: &["🧎🏾\u{200d}♀"] },
    Emoji { emoji: "🧎🏿‍♀️", name: "woman kneeling: dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1538, SkinTone::Dark)), aliases: None, variations: &["🧎🏿\u{200d}♀"] },
    Emoji { emoji: "🧑‍🦯", name: "person with white cane", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1544, SkinTone::Default)), aliases: Some(&["person_with_probing_cane"]), variations: &[] },
    Emoji { emoji: "🧑🏻‍🦯", name: "person with white cane: light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1544, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "🧑🏼‍🦯", name: "person with white cane: medium-light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1544, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "🧑🏽‍🦯", name: "person with white cane: medium skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1544, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "🧑🏾‍🦯", name: "person with white cane: medium-dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1544, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "🧑🏿‍🦯", name: "person with white cane: dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1544, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "👨‍🦯", name: "man with white cane", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1550, SkinTone::Default)), aliases: Some(&["man_with_probing_cane"]), variations: &[] },
    Emoji { emoji: "👨🏻‍🦯", name: "man with white cane: light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1550, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "👨🏼‍🦯", name: "man with white cane: medium-light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1550, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "👨🏽‍🦯", name: "man with white cane: medium skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1550, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "👨🏾‍🦯", name: "man with white cane: medium-dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1550, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "👨🏿‍🦯", name: "man with white cane: dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1550, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "👩‍🦯", name: "woman with white cane", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1556, SkinTone::Default)), aliases: Some(&["woman_with_probing_cane"]), variations: &[] },
    Emoji { emoji: "👩🏻‍🦯", name: "woman with white cane: light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1556, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "👩🏼‍🦯", name: "woman with white cane: medium-light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1556, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "👩🏽‍🦯", name: "woman with white cane: medium skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1556, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "👩🏾‍🦯", name: "woman with white cane: medium-dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1556, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "👩🏿‍🦯", name: "woman with white cane: dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1556, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "🧑‍🦼", name: "person in motorized wheelchair", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1562, SkinTone::Default)), aliases: Some(&["person_in_motorized_wheelchair"]), variations: &[] },
    Emoji { emoji: "🧑🏻‍🦼", name: "person in motorized wheelchair: light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1562, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "🧑🏼‍🦼", name: "person in motorized wheelchair: medium-light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1562, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "🧑🏽‍🦼", name: "person in motorized wheelchair: medium skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1562, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "🧑🏾‍🦼", name: "person in motorized wheelchair: medium-dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1562, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "🧑🏿‍🦼", name: "person in motorized wheelchair: dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1562, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "👨‍🦼", name: "man in motorized wheelchair", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1568, SkinTone::Default)), aliases: Some(&["man_in_motorized_wheelchair"]), variations: &[] },
    Emoji { emoji: "👨🏻‍🦼", name: "man in motorized wheelchair: light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1568, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "👨🏼‍🦼", name: "man in motorized wheelchair: medium-light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1568, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "👨🏽‍🦼", name: "man in motorized wheelchair: medium skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1568, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "👨🏾‍🦼", name: "man in motorized wheelchair: medium-dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1568, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "👨🏿‍🦼", name: "man in motorized wheelchair: dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1568, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "👩‍🦼", name: "woman in motorized wheelchair", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1574, SkinTone::Default)), aliases: Some(&["woman_in_motorized_wheelchair"]), variations: &[] },
    Emoji { emoji: "👩🏻‍🦼", name: "woman in motorized wheelchair: light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1574, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "👩🏼‍🦼", name: "woman in motorized wheelchair: medium-light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1574, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "👩🏽‍🦼", name: "woman in motorized wheelchair: medium skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1574, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "👩🏾‍🦼", name: "woman in motorized wheelchair: medium-dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1574, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "👩🏿‍🦼", name: "woman in motorized wheelchair: dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1574, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "🧑‍🦽", name: "person in manual wheelchair", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1580, SkinTone::Default)), aliases: Some(&["person_in_manual_wheelchair"]), variations: &[] },
    Emoji { emoji: "🧑🏻‍🦽", name: "person in manual wheelchair: light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1580, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "🧑🏼‍🦽", name: "person in manual wheelchair: medium-light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1580, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "🧑🏽‍🦽", name: "person in manual wheelchair: medium skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1580, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "🧑🏾‍🦽", name: "person in manual wheelchair: medium-dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1580, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "🧑🏿‍🦽", name: "person in manual wheelchair: dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1580, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "👨‍🦽", name: "man in manual wheelchair", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1586, SkinTone::Default)), aliases: Some(&["man_in_manual_wheelchair"]), variations: &[] },
    Emoji { emoji: "👨🏻‍🦽", name: "man in manual wheelchair: light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1586, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "👨🏼‍🦽", name: "man in manual wheelchair: medium-light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1586, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "👨🏽‍🦽", name: "man in manual wheelchair: medium skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1586, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "👨🏾‍🦽", name: "man in manual wheelchair: medium-dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1586, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "👨🏿‍🦽", name: "man in manual wheelchair: dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1586, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "👩‍🦽", name: "woman in manual wheelchair", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1592, SkinTone::Default)), aliases: Some(&["woman_in_manual_wheelchair"]), variations: &[] },
    Emoji { emoji: "👩🏻‍🦽", name: "woman in manual wheelchair: light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1592, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "👩🏼‍🦽", name: "woman in manual wheelchair: medium-light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1592, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "👩🏽‍🦽", name: "woman in manual wheelchair: medium skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1592, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "👩🏾‍🦽", name: "woman in manual wheelchair: medium-dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1592, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "👩🏿‍🦽", name: "woman in manual wheelchair: dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1592, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "🏃", name: "person running", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: Some((1598, SkinTone::Default)), aliases: Some(&["runner", "running"]), variations: &[] },
    Emoji { emoji: "🏃🏻", name: "person running: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1598, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "🏃🏼", name: "person running: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1598, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "🏃🏽", name: "person running: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1598, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "🏃🏾", name: "person running: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1598, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "🏃🏿", name: "person running: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1598, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "🏃‍♂️", name: "man running", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1604, SkinTone::Default)), aliases: Some(&["running_man"]), variations: &["🏃\u{200d}♂"] },
    Emoji { emoji: "🏃🏻‍♂️", name: "man running: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1604, SkinTone::Light)), aliases: None, variations: &["🏃🏻\u{200d}♂"] },
    Emoji { emoji: "🏃🏼‍♂️", name: "man running: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1604, SkinTone::MediumLight)), aliases: None, variations: &["🏃🏼\u{200d}♂"] },
    Emoji { emoji: "🏃🏽‍♂️", name: "man running: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1604, SkinTone::Medium)), aliases: None, variations: &["🏃🏽\u{200d}♂"] },
    Emoji { emoji: "🏃🏾‍♂️", name: "man running: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1604, SkinTone::MediumDark)), aliases: None, variations: &["🏃🏾\u{200d}♂"] },
    Emoji { emoji: "🏃🏿‍♂️", name: "man running: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1604, SkinTone::Dark)), aliases: None, variations: &["🏃🏿\u{200d}♂"] },
    Emoji { emoji: "🏃‍♀️", name: "woman running", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1610, SkinTone::Default)), aliases: Some(&["running_woman"]), variations: &["🏃\u{200d}♀"] },
    Emoji { emoji: "🏃🏻‍♀️", name: "woman running: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1610, SkinTone::Light)), aliases: None, variations: &["🏃🏻\u{200d}♀"] },
    Emoji { emoji: "🏃🏼‍♀️", name: "woman running: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1610, SkinTone::MediumLight)), aliases: None, variations: &["🏃🏼\u{200d}♀"] },
    Emoji { emoji: "🏃🏽‍♀️", name: "woman running: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1610, SkinTone::Medium)), aliases: None, variations: &["🏃🏽\u{200d}♀"] },
    Emoji { emoji: "🏃🏾‍♀️", name: "woman running: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1610, SkinTone::MediumDark)), aliases: None, variations: &["🏃🏾\u{200d}♀"] },
    Emoji { emoji: "🏃🏿‍♀️", name: "woman running: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1610, SkinTone::Dark)), aliases: None, variations: &["🏃🏿\u{200d}♀"] },
    Emoji { emoji: "💃", name: "woman dancing", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: Some((1616, SkinTone::Default)), aliases: Some(&["woman_dancing", "dancer"]), variations: &[] },
    Emoji { emoji: "💃🏻", name: "woman dancing: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1616, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "💃🏼", name: "woman dancing: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1616, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "💃🏽", name: "woman dancing: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1616, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "💃🏾", name: "woman dancing: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1616, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "💃🏿", name: "woman dancing: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1616, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "🕺", name: "man dancing", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1622, SkinTone::Default)), aliases: Some(&["man_dancing"]), variations: &[] },
    Emoji { emoji: "🕺🏻", name: "man dancing: light skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1622, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "🕺🏼", name: "man dancing: medium-light skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1622, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "🕺🏽", name: "man dancing: medium skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1622, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "🕺🏾", name: "man dancing: medium-dark skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1622, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "🕺🏿", name: "man dancing: dark skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1622, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "🕴️", name: "person in suit levitating", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::PeopleAndBody, skin_tone: Some((1628, SkinTone::Default)), aliases: Some(&["business_suit_levitating"]), variations: &["🕴"] },
    Emoji { emoji: "🕴🏻", name: "person in suit levitating: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1628, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "🕴🏼", name: "person in suit levitating: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1628, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "🕴🏽", name: "person in suit levitating: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1628, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "🕴🏾", name: "person in suit levitating: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1628, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "🕴🏿", name: "person in suit levitating: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1628, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "👯", name: "people with bunny ears", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["dancers"]), variations: &[] },
    Emoji { emoji: "👯‍♂️", name: "men with bunny ears", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["dancing_men"]), variations: &["👯\u{200d}♂"] },
    Emoji { emoji: "👯‍♀️", name: "women with bunny ears", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["dancing_women"]), variations: &["👯\u{200d}♀"] },
    Emoji { emoji: "🧖", name: "person in steamy room", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1637, SkinTone::Default)), aliases: Some(&["sauna_person"]), variations: &[] },
    Emoji { emoji: "🧖🏻", name: "person in steamy room: light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1637, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "🧖🏼", name: "person in steamy room: medium-light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1637, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "🧖🏽", name: "person in steamy room: medium skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1637, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "🧖🏾", name: "person in steamy room: medium-dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1637, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "🧖🏿", name: "person in steamy room: dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1637, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "🧖‍♂️", name: "man in steamy room", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1643, SkinTone::Default)), aliases: Some(&["sauna_man"]), variations: &["🧖\u{200d}♂"] },
    Emoji { emoji: "🧖🏻‍♂️", name: "man in steamy room: light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1643, SkinTone::Light)), aliases: None, variations: &["🧖🏻\u{200d}♂"] },
    Emoji { emoji: "🧖🏼‍♂️", name: "man in steamy room: medium-light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1643, SkinTone::MediumLight)), aliases: None, variations: &["🧖🏼\u{200d}♂"] },
    Emoji { emoji: "🧖🏽‍♂️", name: "man in steamy room: medium skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1643, SkinTone::Medium)), aliases: None, variations: &["🧖🏽\u{200d}♂"] },
    Emoji { emoji: "🧖🏾‍♂️", name: "man in steamy room: medium-dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1643, SkinTone::MediumDark)), aliases: None, variations: &["🧖🏾\u{200d}♂"] },
    Emoji { emoji: "🧖🏿‍♂️", name: "man in steamy room: dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1643, SkinTone::Dark)), aliases: None, variations: &["🧖🏿\u{200d}♂"] },
    Emoji { emoji: "🧖‍♀️", name: "woman in steamy room", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1649, SkinTone::Default)), aliases: Some(&["sauna_woman"]), variations: &["🧖\u{200d}♀"] },
    Emoji { emoji: "🧖🏻‍♀️", name: "woman in steamy room: light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1649, SkinTone::Light)), aliases: None, variations: &["🧖🏻\u{200d}♀"] },
    Emoji { emoji: "🧖🏼‍♀️", name: "woman in steamy room: medium-light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1649, SkinTone::MediumLight)), aliases: None, variations: &["🧖🏼\u{200d}♀"] },
    Emoji { emoji: "🧖🏽‍♀️", name: "woman in steamy room: medium skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1649, SkinTone::Medium)), aliases: None, variations: &["🧖🏽\u{200d}♀"] },
    Emoji { emoji: "🧖🏾‍♀️", name: "woman in steamy room: medium-dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1649, SkinTone::MediumDark)), aliases: None, variations: &["🧖🏾\u{200d}♀"] },
    Emoji { emoji: "🧖🏿‍♀️", name: "woman in steamy room: dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1649, SkinTone::Dark)), aliases: None, variations: &["🧖🏿\u{200d}♀"] },
    Emoji { emoji: "🧗", name: "person climbing", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1655, SkinTone::Default)), aliases: Some(&["climbing"]), variations: &[] },
    Emoji { emoji: "🧗🏻", name: "person climbing: light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1655, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "🧗🏼", name: "person climbing: medium-light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1655, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "🧗🏽", name: "person climbing: medium skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1655, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "🧗🏾", name: "person climbing: medium-dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1655, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "🧗🏿", name: "person climbing: dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1655, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "🧗‍♂️", name: "man climbing", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1661, SkinTone::Default)), aliases: Some(&["climbing_man"]), variations: &["🧗\u{200d}♂"] },
    Emoji { emoji: "🧗🏻‍♂️", name: "man climbing: light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1661, SkinTone::Light)), aliases: None, variations: &["🧗🏻\u{200d}♂"] },
    Emoji { emoji: "🧗🏼‍♂️", name: "man climbing: medium-light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1661, SkinTone::MediumLight)), aliases: None, variations: &["🧗🏼\u{200d}♂"] },
    Emoji { emoji: "🧗🏽‍♂️", name: "man climbing: medium skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1661, SkinTone::Medium)), aliases: None, variations: &["🧗🏽\u{200d}♂"] },
    Emoji { emoji: "🧗🏾‍♂️", name: "man climbing: medium-dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1661, SkinTone::MediumDark)), aliases: None, variations: &["🧗🏾\u{200d}♂"] },
    Emoji { emoji: "🧗🏿‍♂️", name: "man climbing: dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1661, SkinTone::Dark)), aliases: None, variations: &["🧗🏿\u{200d}♂"] },
    Emoji { emoji: "🧗‍♀️", name: "woman climbing", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1667, SkinTone::Default)), aliases: Some(&["climbing_woman"]), variations: &["🧗\u{200d}♀"] },
    Emoji { emoji: "🧗🏻‍♀️", name: "woman climbing: light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1667, SkinTone::Light)), aliases: None, variations: &["🧗🏻\u{200d}♀"] },
    Emoji { emoji: "🧗🏼‍♀️", name: "woman climbing: medium-light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1667, SkinTone::MediumLight)), aliases: None, variations: &["🧗🏼\u{200d}♀"] },
    Emoji { emoji: "🧗🏽‍♀️", name: "woman climbing: medium skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1667, SkinTone::Medium)), aliases: None, variations: &["🧗🏽\u{200d}♀"] },
    Emoji { emoji: "🧗🏾‍♀️", name: "woman climbing: medium-dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1667, SkinTone::MediumDark)), aliases: None, variations: &["🧗🏾\u{200d}♀"] },
    Emoji { emoji: "🧗🏿‍♀️", name: "woman climbing: dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1667, SkinTone::Dark)), aliases: None, variations: &["🧗🏿\u{200d}♀"] },
    Emoji { emoji: "🤺", name: "person fencing", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["person_fencing"]), variations: &[] },
    Emoji { emoji: "🏇", name: "horse racing", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1674, SkinTone::Default)), aliases: Some(&["horse_racing"]), variations: &[] },
    Emoji { emoji: "🏇🏻", name: "horse racing: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1674, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "🏇🏼", name: "horse racing: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1674, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "🏇🏽", name: "horse racing: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1674, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "🏇🏾", name: "horse racing: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1674, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "🏇🏿", name: "horse racing: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1674, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "⛷️", name: "skier", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["skier"]), variations: &["⛷"] },
    Emoji { emoji: "🏂", name: "snowboarder", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: Some((1681, SkinTone::Default)), aliases: Some(&["snowboarder"]), variations: &[] },
    Emoji { emoji: "🏂🏻", name: "snowboarder: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1681, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "🏂🏼", name: "snowboarder: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1681, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "🏂🏽", name: "snowboarder: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1681, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "🏂🏾", name: "snowboarder: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1681, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "🏂🏿", name: "snowboarder: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1681, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "🏌️", name: "person golfing", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::PeopleAndBody, skin_tone: Some((1687, SkinTone::Default)), aliases: Some(&["golfing"]), variations: &["🏌"] },
    Emoji { emoji: "🏌🏻", name: "person golfing: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1687, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "🏌🏼", name: "person golfing: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1687, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "🏌🏽", name: "person golfing: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1687, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "🏌🏾", name: "person golfing: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1687, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "🏌🏿", name: "person golfing: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1687, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "🏌️‍♂️", name: "man golfing", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1693, SkinTone::Default)), aliases: Some(&["golfing_man"]), variations: &["🏌\u{200d}♂\u{fe0f}", "🏌\u{fe0f}\u{200d}♂", "🏌\u{200d}♂"] },
    Emoji { emoji: "🏌🏻‍♂️", name: "man golfing: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1693, SkinTone::Light)), aliases: None, variations: &["🏌🏻\u{200d}♂"] },
    Emoji { emoji: "🏌🏼‍♂️", name: "man golfing: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1693, SkinTone::MediumLight)), aliases: None, variations: &["🏌🏼\u{200d}♂"] },
    Emoji { emoji: "🏌🏽‍♂️", name: "man golfing: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1693, SkinTone::Medium)), aliases: None, variations: &["🏌🏽\u{200d}♂"] },
    Emoji { emoji: "🏌🏾‍♂️", name: "man golfing: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1693, SkinTone::MediumDark)), aliases: None, variations: &["🏌🏾\u{200d}♂"] },
    Emoji { emoji: "🏌🏿‍♂️", name: "man golfing: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1693, SkinTone::Dark)), aliases: None, variations: &["🏌🏿\u{200d}♂"] },
    Emoji { emoji: "🏌️‍♀️", name: "woman golfing", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1699, SkinTone::Default)), aliases: Some(&["golfing_woman"]), variations: &["🏌\u{200d}♀\u{fe0f}", "🏌\u{fe0f}\u{200d}♀", "🏌\u{200d}♀"] },
    Emoji { emoji: "🏌🏻‍♀️", name: "woman golfing: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1699, SkinTone::Light)), aliases: None, variations: &["🏌🏻\u{200d}♀"] },
    Emoji { emoji: "🏌🏼‍♀️", name: "woman golfing: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1699, SkinTone::MediumLight)), aliases: None, variations: &["🏌🏼\u{200d}♀"] },
    Emoji { emoji: "🏌🏽‍♀️", name: "woman golfing: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1699, SkinTone::Medium)), aliases: None, variations: &["🏌🏽\u{200d}♀"] },
    Emoji { emoji: "🏌🏾‍♀️", name: "woman golfing: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1699, SkinTone::MediumDark)), aliases: None, variations: &["🏌🏾\u{200d}♀"] },
    Emoji { emoji: "🏌🏿‍♀️", name: "woman golfing: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1699, SkinTone::Dark)), aliases: None, variations: &["🏌🏿\u{200d}♀"] },
    Emoji { emoji: "🏄", name: "person surfing", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: Some((1705, SkinTone::Default)), aliases: Some(&["surfer"]), variations: &[] },
    Emoji { emoji: "🏄🏻", name: "person surfing: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1705, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "🏄🏼", name: "person surfing: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1705, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "🏄🏽", name: "person surfing: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1705, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "🏄🏾", name: "person surfing: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1705, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "🏄🏿", name: "person surfing: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1705, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "🏄‍♂️", name: "man surfing", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1711, SkinTone::Default)), aliases: Some(&["surfing_man"]), variations: &["🏄\u{200d}♂"] },
    Emoji { emoji: "🏄🏻‍♂️", name: "man surfing: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1711, SkinTone::Light)), aliases: None, variations: &["🏄🏻\u{200d}♂"] },
    Emoji { emoji: "🏄🏼‍♂️", name: "man surfing: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1711, SkinTone::MediumLight)), aliases: None, variations: &["🏄🏼\u{200d}♂"] },
    Emoji { emoji: "🏄🏽‍♂️", name: "man surfing: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1711, SkinTone::Medium)), aliases: None, variations: &["🏄🏽\u{200d}♂"] },
    Emoji { emoji: "🏄🏾‍♂️", name: "man surfing: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1711, SkinTone::MediumDark)), aliases: None, variations: &["🏄🏾\u{200d}♂"] },
    Emoji { emoji: "🏄🏿‍♂️", name: "man surfing: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1711, SkinTone::Dark)), aliases: None, variations: &["🏄🏿\u{200d}♂"] },
    Emoji { emoji: "🏄‍♀️", name: "woman surfing", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1717, SkinTone::Default)), aliases: Some(&["surfing_woman"]), variations: &["🏄\u{200d}♀"] },
    Emoji { emoji: "🏄🏻‍♀️", name: "woman surfing: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1717, SkinTone::Light)), aliases: None, variations: &["🏄🏻\u{200d}♀"] },
    Emoji { emoji: "🏄🏼‍♀️", name: "woman surfing: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1717, SkinTone::MediumLight)), aliases: None, variations: &["🏄🏼\u{200d}♀"] },
    Emoji { emoji: "🏄🏽‍♀️", name: "woman surfing: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1717, SkinTone::Medium)), aliases: None, variations: &["🏄🏽\u{200d}♀"] },
    Emoji { emoji: "🏄🏾‍♀️", name: "woman surfing: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1717, SkinTone::MediumDark)), aliases: None, variations: &["🏄🏾\u{200d}♀"] },
    Emoji { emoji: "🏄🏿‍♀️", name: "woman surfing: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1717, SkinTone::Dark)), aliases: None, variations: &["🏄🏿\u{200d}♀"] },
    Emoji { emoji: "🚣", name: "person rowing boat", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1723, SkinTone::Default)), aliases: Some(&["rowboat"]), variations: &[] },
    Emoji { emoji: "🚣🏻", name: "person rowing boat: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1723, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "🚣🏼", name: "person rowing boat: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1723, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "🚣🏽", name: "person rowing boat: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1723, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "🚣🏾", name: "person rowing boat: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1723, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "🚣🏿", name: "person rowing boat: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1723, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "🚣‍♂️", name: "man rowing boat", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1729, SkinTone::Default)), aliases: Some(&["rowing_man"]), variations: &["🚣\u{200d}♂"] },
    Emoji { emoji: "🚣🏻‍♂️", name: "man rowing boat: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1729, SkinTone::Light)), aliases: None, variations: &["🚣🏻\u{200d}♂"] },
    Emoji { emoji: "🚣🏼‍♂️", name: "man rowing boat: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1729, SkinTone::MediumLight)), aliases: None, variations: &["🚣🏼\u{200d}♂"] },
    Emoji { emoji: "🚣🏽‍♂️", name: "man rowing boat: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1729, SkinTone::Medium)), aliases: None, variations: &["🚣🏽\u{200d}♂"] },
    Emoji { emoji: "🚣🏾‍♂️", name: "man rowing boat: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1729, SkinTone::MediumDark)), aliases: None, variations: &["🚣🏾\u{200d}♂"] },
    Emoji { emoji: "🚣🏿‍♂️", name: "man rowing boat: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1729, SkinTone::Dark)), aliases: None, variations: &["🚣🏿\u{200d}♂"] },
    Emoji { emoji: "🚣‍♀️", name: "woman rowing boat", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1735, SkinTone::Default)), aliases: Some(&["rowing_woman"]), variations: &["🚣\u{200d}♀"] },
    Emoji { emoji: "🚣🏻‍♀️", name: "woman rowing boat: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1735, SkinTone::Light)), aliases: None, variations: &["🚣🏻\u{200d}♀"] },
    Emoji { emoji: "🚣🏼‍♀️", name: "woman rowing boat: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1735, SkinTone::MediumLight)), aliases: None, variations: &["🚣🏼\u{200d}♀"] },
    Emoji { emoji: "🚣🏽‍♀️", name: "woman rowing boat: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1735, SkinTone::Medium)), aliases: None, variations: &["🚣🏽\u{200d}♀"] },
    Emoji { emoji: "🚣🏾‍♀️", name: "woman rowing boat: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1735, SkinTone::MediumDark)), aliases: None, variations: &["🚣🏾\u{200d}♀"] },
    Emoji { emoji: "🚣🏿‍♀️", name: "woman rowing boat: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1735, SkinTone::Dark)), aliases: None, variations: &["🚣🏿\u{200d}♀"] },
    Emoji { emoji: "🏊", name: "person swimming", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: Some((1741, SkinTone::Default)), aliases: Some(&["swimmer"]), variations: &[] },
    Emoji { emoji: "🏊🏻", name: "person swimming: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1741, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "🏊🏼", name: "person swimming: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1741, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "🏊🏽", name: "person swimming: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1741, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "🏊🏾", name: "person swimming: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1741, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "🏊🏿", name: "person swimming: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1741, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "🏊‍♂️", name: "man swimming", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1747, SkinTone::Default)), aliases: Some(&["swimming_man"]), variations: &["🏊\u{200d}♂"] },
    Emoji { emoji: "🏊🏻‍♂️", name: "man swimming: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1747, SkinTone::Light)), aliases: None, variations: &["🏊🏻\u{200d}♂"] },
    Emoji { emoji: "🏊🏼‍♂️", name: "man swimming: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1747, SkinTone::MediumLight)), aliases: None, variations: &["🏊🏼\u{200d}♂"] },
    Emoji { emoji: "🏊🏽‍♂️", name: "man swimming: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1747, SkinTone::Medium)), aliases: None, variations: &["🏊🏽\u{200d}♂"] },
    Emoji { emoji: "🏊🏾‍♂️", name: "man swimming: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1747, SkinTone::MediumDark)), aliases: None, variations: &["🏊🏾\u{200d}♂"] },
    Emoji { emoji: "🏊🏿‍♂️", name: "man swimming: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1747, SkinTone::Dark)), aliases: None, variations: &["🏊🏿\u{200d}♂"] },
    Emoji { emoji: "🏊‍♀️", name: "woman swimming", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1753, SkinTone::Default)), aliases: Some(&["swimming_woman"]), variations: &["🏊\u{200d}♀"] },
    Emoji { emoji: "🏊🏻‍♀️", name: "woman swimming: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1753, SkinTone::Light)), aliases: None, variations: &["🏊🏻\u{200d}♀"] },
    Emoji { emoji: "🏊🏼‍♀️", name: "woman swimming: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1753, SkinTone::MediumLight)), aliases: None, variations: &["🏊🏼\u{200d}♀"] },
    Emoji { emoji: "🏊🏽‍♀️", name: "woman swimming: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1753, SkinTone::Medium)), aliases: None, variations: &["🏊🏽\u{200d}♀"] },
    Emoji { emoji: "🏊🏾‍♀️", name: "woman swimming: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1753, SkinTone::MediumDark)), aliases: None, variations: &["🏊🏾\u{200d}♀"] },
    Emoji { emoji: "🏊🏿‍♀️", name: "woman swimming: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1753, SkinTone::Dark)), aliases: None, variations: &["🏊🏿\u{200d}♀"] },
    Emoji { emoji: "⛹️", name: "person bouncing ball", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::PeopleAndBody, skin_tone: Some((1759, SkinTone::Default)), aliases: Some(&["bouncing_ball_person"]), variations: &["⛹"] },
    Emoji { emoji: "⛹🏻", name: "person bouncing ball: light skin tone", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1759, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "⛹🏼", name: "person bouncing ball: medium-light skin tone", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1759, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "⛹🏽", name: "person bouncing ball: medium skin tone", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1759, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "⛹🏾", name: "person bouncing ball: medium-dark skin tone", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1759, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "⛹🏿", name: "person bouncing ball: dark skin tone", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1759, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "⛹️‍♂️", name: "man bouncing ball", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1765, SkinTone::Default)), aliases: Some(&["bouncing_ball_man", "basketball_man"]), variations: &["⛹\u{200d}♂\u{fe0f}", "⛹\u{fe0f}\u{200d}♂", "⛹\u{200d}♂"] },
    Emoji { emoji: "⛹🏻‍♂️", name: "man bouncing ball: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1765, SkinTone::Light)), aliases: None, variations: &["⛹🏻\u{200d}♂"] },
    Emoji { emoji: "⛹🏼‍♂️", name: "man bouncing ball: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1765, SkinTone::MediumLight)), aliases: None, variations: &["⛹🏼\u{200d}♂"] },
    Emoji { emoji: "⛹🏽‍♂️", name: "man bouncing ball: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1765, SkinTone::Medium)), aliases: None, variations: &["⛹🏽\u{200d}♂"] },
    Emoji { emoji: "⛹🏾‍♂️", name: "man bouncing ball: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1765, SkinTone::MediumDark)), aliases: None, variations: &["⛹🏾\u{200d}♂"] },
    Emoji { emoji: "⛹🏿‍♂️", name: "man bouncing ball: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1765, SkinTone::Dark)), aliases: None, variations: &["⛹🏿\u{200d}♂"] },
    Emoji { emoji: "⛹️‍♀️", name: "woman bouncing ball", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1771, SkinTone::Default)), aliases: Some(&["bouncing_ball_woman", "basketball_woman"]), variations: &["⛹\u{200d}♀\u{fe0f}", "⛹\u{fe0f}\u{200d}♀", "⛹\u{200d}♀"] },
    Emoji { emoji: "⛹🏻‍♀️", name: "woman bouncing ball: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1771, SkinTone::Light)), aliases: None, variations: &["⛹🏻\u{200d}♀"] },
    Emoji { emoji: "⛹🏼‍♀️", name: "woman bouncing ball: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1771, SkinTone::MediumLight)), aliases: None, variations: &["⛹🏼\u{200d}♀"] },
    Emoji { emoji: "⛹🏽‍♀️", name: "woman bouncing ball: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1771, SkinTone::Medium)), aliases: None, variations: &["⛹🏽\u{200d}♀"] },
    Emoji { emoji: "⛹🏾‍♀️", name: "woman bouncing ball: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1771, SkinTone::MediumDark)), aliases: None, variations: &["⛹🏾\u{200d}♀"] },
    Emoji { emoji: "⛹🏿‍♀️", name: "woman bouncing ball: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1771, SkinTone::Dark)), aliases: None, variations: &["⛹🏿\u{200d}♀"] },
    Emoji { emoji: "🏋️", name: "person lifting weights", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::PeopleAndBody, skin_tone: Some((1777, SkinTone::Default)), aliases: Some(&["weight_lifting"]), variations: &["🏋"] },
    Emoji { emoji: "🏋🏻", name: "person lifting weights: light skin tone", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1777, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "🏋🏼", name: "person lifting weights: medium-light skin tone", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1777, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "🏋🏽", name: "person lifting weights: medium skin tone", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1777, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "🏋🏾", name: "person lifting weights: medium-dark skin tone", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1777, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "🏋🏿", name: "person lifting weights: dark skin tone", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1777, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "🏋️‍♂️", name: "man lifting weights", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1783, SkinTone::Default)), aliases: Some(&["weight_lifting_man"]), variations: &["🏋\u{200d}♂\u{fe0f}", "🏋\u{fe0f}\u{200d}♂", "🏋\u{200d}♂"] },
    Emoji { emoji: "🏋🏻‍♂️", name: "man lifting weights: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1783, SkinTone::Light)), aliases: None, variations: &["🏋🏻\u{200d}♂"] },
    Emoji { emoji: "🏋🏼‍♂️", name: "man lifting weights: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1783, SkinTone::MediumLight)), aliases: None, variations: &["🏋🏼\u{200d}♂"] },
    Emoji { emoji: "🏋🏽‍♂️", name: "man lifting weights: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1783, SkinTone::Medium)), aliases: None, variations: &["🏋🏽\u{200d}♂"] },
    Emoji { emoji: "🏋🏾‍♂️", name: "man lifting weights: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1783, SkinTone::MediumDark)), aliases: None, variations: &["🏋🏾\u{200d}♂"] },
    Emoji { emoji: "🏋🏿‍♂️", name: "man lifting weights: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1783, SkinTone::Dark)), aliases: None, variations: &["🏋🏿\u{200d}♂"] },
    Emoji { emoji: "🏋️‍♀️", name: "woman lifting weights", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1789, SkinTone::Default)), aliases: Some(&["weight_lifting_woman"]), variations: &["🏋\u{200d}♀\u{fe0f}", "🏋\u{fe0f}\u{200d}♀", "🏋\u{200d}♀"] },
    Emoji { emoji: "🏋🏻‍♀️", name: "woman lifting weights: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1789, SkinTone::Light)), aliases: None, variations: &["🏋🏻\u{200d}♀"] },
    Emoji { emoji: "🏋🏼‍♀️", name: "woman lifting weights: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1789, SkinTone::MediumLight)), aliases: None, variations: &["🏋🏼\u{200d}♀"] },
    Emoji { emoji: "🏋🏽‍♀️", name: "woman lifting weights: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1789, SkinTone::Medium)), aliases: None, variations: &["🏋🏽\u{200d}♀"] },
    Emoji { emoji: "🏋🏾‍♀️", name: "woman lifting weights: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1789, SkinTone::MediumDark)), aliases: None, variations: &["🏋🏾\u{200d}♀"] },
    Emoji { emoji: "🏋🏿‍♀️", name: "woman lifting weights: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1789, SkinTone::Dark)), aliases: None, variations: &["🏋🏿\u{200d}♀"] },
    Emoji { emoji: "🚴", name: "person biking", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1795, SkinTone::Default)), aliases: Some(&["bicyclist"]), variations: &[] },
    Emoji { emoji: "🚴🏻", name: "person biking: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1795, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "🚴🏼", name: "person biking: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1795, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "🚴🏽", name: "person biking: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1795, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "🚴🏾", name: "person biking: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1795, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "🚴🏿", name: "person biking: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1795, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "🚴‍♂️", name: "man biking", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1801, SkinTone::Default)), aliases: Some(&["biking_man"]), variations: &["🚴\u{200d}♂"] },
    Emoji { emoji: "🚴🏻‍♂️", name: "man biking: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1801, SkinTone::Light)), aliases: None, variations: &["🚴🏻\u{200d}♂"] },
    Emoji { emoji: "🚴🏼‍♂️", name: "man biking: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1801, SkinTone::MediumLight)), aliases: None, variations: &["🚴🏼\u{200d}♂"] },
    Emoji { emoji: "🚴🏽‍♂️", name: "man biking: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1801, SkinTone::Medium)), aliases: None, variations: &["🚴🏽\u{200d}♂"] },
    Emoji { emoji: "🚴🏾‍♂️", name: "man biking: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1801, SkinTone::MediumDark)), aliases: None, variations: &["🚴🏾\u{200d}♂"] },
    Emoji { emoji: "🚴🏿‍♂️", name: "man biking: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1801, SkinTone::Dark)), aliases: None, variations: &["🚴🏿\u{200d}♂"] },
    Emoji { emoji: "🚴‍♀️", name: "woman biking", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1807, SkinTone::Default)), aliases: Some(&["biking_woman"]), variations: &["🚴\u{200d}♀"] },
    Emoji { emoji: "🚴🏻‍♀️", name: "woman biking: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1807, SkinTone::Light)), aliases: None, variations: &["🚴🏻\u{200d}♀"] },
    Emoji { emoji: "🚴🏼‍♀️", name: "woman biking: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1807, SkinTone::MediumLight)), aliases: None, variations: &["🚴🏼\u{200d}♀"] },
    Emoji { emoji: "🚴🏽‍♀️", name: "woman biking: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1807, SkinTone::Medium)), aliases: None, variations: &["🚴🏽\u{200d}♀"] },
    Emoji { emoji: "🚴🏾‍♀️", name: "woman biking: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1807, SkinTone::MediumDark)), aliases: None, variations: &["🚴🏾\u{200d}♀"] },
    Emoji { emoji: "🚴🏿‍♀️", name: "woman biking: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1807, SkinTone::Dark)), aliases: None, variations: &["🚴🏿\u{200d}♀"] },
    Emoji { emoji: "🚵", name: "person mountain biking", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1813, SkinTone::Default)), aliases: Some(&["mountain_bicyclist"]), variations: &[] },
    Emoji { emoji: "🚵🏻", name: "person mountain biking: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1813, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "🚵🏼", name: "person mountain biking: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1813, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "🚵🏽", name: "person mountain biking: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1813, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "🚵🏾", name: "person mountain biking: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1813, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "🚵🏿", name: "person mountain biking: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1813, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "🚵‍♂️", name: "man mountain biking", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1819, SkinTone::Default)), aliases: Some(&["mountain_biking_man"]), variations: &["🚵\u{200d}♂"] },
    Emoji { emoji: "🚵🏻‍♂️", name: "man mountain biking: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1819, SkinTone::Light)), aliases: None, variations: &["🚵🏻\u{200d}♂"] },
    Emoji { emoji: "🚵🏼‍♂️", name: "man mountain biking: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1819, SkinTone::MediumLight)), aliases: None, variations: &["🚵🏼\u{200d}♂"] },
    Emoji { emoji: "🚵🏽‍♂️", name: "man mountain biking: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1819, SkinTone::Medium)), aliases: None, variations: &["🚵🏽\u{200d}♂"] },
    Emoji { emoji: "🚵🏾‍♂️", name: "man mountain biking: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1819, SkinTone::MediumDark)), aliases: None, variations: &["🚵🏾\u{200d}♂"] },
    Emoji { emoji: "🚵🏿‍♂️", name: "man mountain biking: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1819, SkinTone::Dark)), aliases: None, variations: &["🚵🏿\u{200d}♂"] },
    Emoji { emoji: "🚵‍♀️", name: "woman mountain biking", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1825, SkinTone::Default)), aliases: Some(&["mountain_biking_woman"]), variations: &["🚵\u{200d}♀"] },
    Emoji { emoji: "🚵🏻‍♀️", name: "woman mountain biking: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1825, SkinTone::Light)), aliases: None, variations: &["🚵🏻\u{200d}♀"] },
    Emoji { emoji: "🚵🏼‍♀️", name: "woman mountain biking: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1825, SkinTone::MediumLight)), aliases: None, variations: &["🚵🏼\u{200d}♀"] },
    Emoji { emoji: "🚵🏽‍♀️", name: "woman mountain biking: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1825, SkinTone::Medium)), aliases: None, variations: &["🚵🏽\u{200d}♀"] },
    Emoji { emoji: "🚵🏾‍♀️", name: "woman mountain biking: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1825, SkinTone::MediumDark)), aliases: None, variations: &["🚵🏾\u{200d}♀"] },
    Emoji { emoji: "🚵🏿‍♀️", name: "woman mountain biking: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1825, SkinTone::Dark)), aliases: None, variations: &["🚵🏿\u{200d}♀"] },
    Emoji { emoji: "🤸", name: "person cartwheeling", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1831, SkinTone::Default)), aliases: Some(&["cartwheeling"]), variations: &[] },
    Emoji { emoji: "🤸🏻", name: "person cartwheeling: light skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1831, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "🤸🏼", name: "person cartwheeling: medium-light skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1831, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "🤸🏽", name: "person cartwheeling: medium skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1831, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "🤸🏾", name: "person cartwheeling: medium-dark skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1831, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "🤸🏿", name: "person cartwheeling: dark skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1831, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "🤸‍♂️", name: "man cartwheeling", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1837, SkinTone::Default)), aliases: Some(&["man_cartwheeling"]), variations: &["🤸\u{200d}♂"] },
    Emoji { emoji: "🤸🏻‍♂️", name: "man cartwheeling: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1837, SkinTone::Light)), aliases: None, variations: &["🤸🏻\u{200d}♂"] },
    Emoji { emoji: "🤸🏼‍♂️", name: "man cartwheeling: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1837, SkinTone::MediumLight)), aliases: None, variations: &["🤸🏼\u{200d}♂"] },
    Emoji { emoji: "🤸🏽‍♂️", name: "man cartwheeling: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1837, SkinTone::Medium)), aliases: None, variations: &["🤸🏽\u{200d}♂"] },
    Emoji { emoji: "🤸🏾‍♂️", name: "man cartwheeling: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1837, SkinTone::MediumDark)), aliases: None, variations: &["🤸🏾\u{200d}♂"] },
    Emoji { emoji: "🤸🏿‍♂️", name: "man cartwheeling: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1837, SkinTone::Dark)), aliases: None, variations: &["🤸🏿\u{200d}♂"] },
    Emoji { emoji: "🤸‍♀️", name: "woman cartwheeling", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1843, SkinTone::Default)), aliases: Some(&["woman_cartwheeling"]), variations: &["🤸\u{200d}♀"] },
    Emoji { emoji: "🤸🏻‍♀️", name: "woman cartwheeling: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1843, SkinTone::Light)), aliases: None, variations: &["🤸🏻\u{200d}♀"] },
    Emoji { emoji: "🤸🏼‍♀️", name: "woman cartwheeling: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1843, SkinTone::MediumLight)), aliases: None, variations: &["🤸🏼\u{200d}♀"] },
    Emoji { emoji: "🤸🏽‍♀️", name: "woman cartwheeling: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1843, SkinTone::Medium)), aliases: None, variations: &["🤸🏽\u{200d}♀"] },
    Emoji { emoji: "🤸🏾‍♀️", name: "woman cartwheeling: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1843, SkinTone::MediumDark)), aliases: None, variations: &["🤸🏾\u{200d}♀"] },
    Emoji { emoji: "🤸🏿‍♀️", name: "woman cartwheeling: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1843, SkinTone::Dark)), aliases: None, variations: &["🤸🏿\u{200d}♀"] },
    Emoji { emoji: "🤼", name: "people wrestling", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["wrestling"]), variations: &[] },
    Emoji { emoji: "🤼‍♂️", name: "men wrestling", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["men_wrestling"]), variations: &["🤼\u{200d}♂"] },
    Emoji { emoji: "🤼‍♀️", name: "women wrestling", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["women_wrestling"]), variations: &["🤼\u{200d}♀"] },
    Emoji { emoji: "🤽", name: "person playing water polo", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1852, SkinTone::Default)), aliases: Some(&["water_polo"]), variations: &[] },
    Emoji { emoji: "🤽🏻", name: "person playing water polo: light skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1852, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "🤽🏼", name: "person playing water polo: medium-light skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1852, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "🤽🏽", name: "person playing water polo: medium skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1852, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "🤽🏾", name: "person playing water polo: medium-dark skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1852, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "🤽🏿", name: "person playing water polo: dark skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1852, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "🤽‍♂️", name: "man playing water polo", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1858, SkinTone::Default)), aliases: Some(&["man_playing_water_polo"]), variations: &["🤽\u{200d}♂"] },
    Emoji { emoji: "🤽🏻‍♂️", name: "man playing water polo: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1858, SkinTone::Light)), aliases: None, variations: &["🤽🏻\u{200d}♂"] },
    Emoji { emoji: "🤽🏼‍♂️", name: "man playing water polo: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1858, SkinTone::MediumLight)), aliases: None, variations: &["🤽🏼\u{200d}♂"] },
    Emoji { emoji: "🤽🏽‍♂️", name: "man playing water polo: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1858, SkinTone::Medium)), aliases: None, variations: &["🤽🏽\u{200d}♂"] },
    Emoji { emoji: "🤽🏾‍♂️", name: "man playing water polo: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1858, SkinTone::MediumDark)), aliases: None, variations: &["🤽🏾\u{200d}♂"] },
    Emoji { emoji: "🤽🏿‍♂️", name: "man playing water polo: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1858, SkinTone::Dark)), aliases: None, variations: &["🤽🏿\u{200d}♂"] },
    Emoji { emoji: "🤽‍♀️", name: "woman playing water polo", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1864, SkinTone::Default)), aliases: Some(&["woman_playing_water_polo"]), variations: &["🤽\u{200d}♀"] },
    Emoji { emoji: "🤽🏻‍♀️", name: "woman playing water polo: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1864, SkinTone::Light)), aliases: None, variations: &["🤽🏻\u{200d}♀"] },
    Emoji { emoji: "🤽🏼‍♀️", name: "woman playing water polo: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1864, SkinTone::MediumLight)), aliases: None, variations: &["🤽🏼\u{200d}♀"] },
    Emoji { emoji: "🤽🏽‍♀️", name: "woman playing water polo: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1864, SkinTone::Medium)), aliases: None, variations: &["🤽🏽\u{200d}♀"] },
    Emoji { emoji: "🤽🏾‍♀️", name: "woman playing water polo: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1864, SkinTone::MediumDark)), aliases: None, variations: &["🤽🏾\u{200d}♀"] },
    Emoji { emoji: "🤽🏿‍♀️", name: "woman playing water polo: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1864, SkinTone::Dark)), aliases: None, variations: &["🤽🏿\u{200d}♀"] },
    Emoji { emoji: "🤾", name: "person playing handball", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1870, SkinTone::Default)), aliases: Some(&["handball_person"]), variations: &[] },
    Emoji { emoji: "🤾🏻", name: "person playing handball: light skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1870, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "🤾🏼", name: "person playing handball: medium-light skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1870, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "🤾🏽", name: "person playing handball: medium skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1870, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "🤾🏾", name: "person playing handball: medium-dark skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1870, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "🤾🏿", name: "person playing handball: dark skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1870, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "🤾‍♂️", name: "man playing handball", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1876, SkinTone::Default)), aliases: Some(&["man_playing_handball"]), variations: &["🤾\u{200d}♂"] },
    Emoji { emoji: "🤾🏻‍♂️", name: "man playing handball: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1876, SkinTone::Light)), aliases: None, variations: &["🤾🏻\u{200d}♂"] },
    Emoji { emoji: "🤾🏼‍♂️", name: "man playing handball: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1876, SkinTone::MediumLight)), aliases: None, variations: &["🤾🏼\u{200d}♂"] },
    Emoji { emoji: "🤾🏽‍♂️", name: "man playing handball: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1876, SkinTone::Medium)), aliases: None, variations: &["🤾🏽\u{200d}♂"] },
    Emoji { emoji: "🤾🏾‍♂️", name: "man playing handball: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1876, SkinTone::MediumDark)), aliases: None, variations: &["🤾🏾\u{200d}♂"] },
    Emoji { emoji: "🤾🏿‍♂️", name: "man playing handball: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1876, SkinTone::Dark)), aliases: None, variations: &["🤾🏿\u{200d}♂"] },
    Emoji { emoji: "🤾‍♀️", name: "woman playing handball", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1882, SkinTone::Default)), aliases: Some(&["woman_playing_handball"]), variations: &["🤾\u{200d}♀"] },
    Emoji { emoji: "🤾🏻‍♀️", name: "woman playing handball: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1882, SkinTone::Light)), aliases: None, variations: &["🤾🏻\u{200d}♀"] },
    Emoji { emoji: "🤾🏼‍♀️", name: "woman playing handball: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1882, SkinTone::MediumLight)), aliases: None, variations: &["🤾🏼\u{200d}♀"] },
    Emoji { emoji: "🤾🏽‍♀️", name: "woman playing handball: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1882, SkinTone::Medium)), aliases: None, variations: &["🤾🏽\u{200d}♀"] },
    Emoji { emoji: "🤾🏾‍♀️", name: "woman playing handball: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1882, SkinTone::MediumDark)), aliases: None, variations: &["🤾🏾\u{200d}♀"] },
    Emoji { emoji: "🤾🏿‍♀️", name: "woman playing handball: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1882, SkinTone::Dark)), aliases: None, variations: &["🤾🏿\u{200d}♀"] },
    Emoji { emoji: "🤹", name: "person juggling", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1888, SkinTone::Default)), aliases: Some(&["juggling_person"]), variations: &[] },
    Emoji { emoji: "🤹🏻", name: "person juggling: light skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1888, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "🤹🏼", name: "person juggling: medium-light skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1888, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "🤹🏽", name: "person juggling: medium skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1888, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "🤹🏾", name: "person juggling: medium-dark skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1888, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "🤹🏿", name: "person juggling: dark skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1888, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "🤹‍♂️", name: "man juggling", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1894, SkinTone::Default)), aliases: Some(&["man_juggling"]), variations: &["🤹\u{200d}♂"] },
    Emoji { emoji: "🤹🏻‍♂️", name: "man juggling: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1894, SkinTone::Light)), aliases: None, variations: &["🤹🏻\u{200d}♂"] },
    Emoji { emoji: "🤹🏼‍♂️", name: "man juggling: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1894, SkinTone::MediumLight)), aliases: None, variations: &["🤹🏼\u{200d}♂"] },
    Emoji { emoji: "🤹🏽‍♂️", name: "man juggling: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1894, SkinTone::Medium)), aliases: None, variations: &["🤹🏽\u{200d}♂"] },
    Emoji { emoji: "🤹🏾‍♂️", name: "man juggling: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1894, SkinTone::MediumDark)), aliases: None, variations: &["🤹🏾\u{200d}♂"] },
    Emoji { emoji: "🤹🏿‍♂️", name: "man juggling: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1894, SkinTone::Dark)), aliases: None, variations: &["🤹🏿\u{200d}♂"] },
    Emoji { emoji: "🤹‍♀️", name: "woman juggling", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1900, SkinTone::Default)), aliases: Some(&["woman_juggling"]), variations: &["🤹\u{200d}♀"] },
    Emoji { emoji: "🤹🏻‍♀️", name: "woman juggling: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1900, SkinTone::Light)), aliases: None, variations: &["🤹🏻\u{200d}♀"] },
    Emoji { emoji: "🤹🏼‍♀️", name: "woman juggling: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1900, SkinTone::MediumLight)), aliases: None, variations: &["🤹🏼\u{200d}♀"] },
    Emoji { emoji: "🤹🏽‍♀️", name: "woman juggling: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1900, SkinTone::Medium)), aliases: None, variations: &["🤹🏽\u{200d}♀"] },
    Emoji { emoji: "🤹🏾‍♀️", name: "woman juggling: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1900, SkinTone::MediumDark)), aliases: None, variations: &["🤹🏾\u{200d}♀"] },
    Emoji { emoji: "🤹🏿‍♀️", name: "woman juggling: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1900, SkinTone::Dark)), aliases: None, variations: &["🤹🏿\u{200d}♀"] },
    Emoji { emoji: "🧘", name: "person in lotus position", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1906, SkinTone::Default)), aliases: Some(&["lotus_position"]), variations: &[] },
    Emoji { emoji: "🧘🏻", name: "person in lotus position: light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1906, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "🧘🏼", name: "person in lotus position: medium-light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1906, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "🧘🏽", name: "person in lotus position: medium skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1906, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "🧘🏾", name: "person in lotus position: medium-dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1906, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "🧘🏿", name: "person in lotus position: dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1906, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "🧘‍♂️", name: "man in lotus position", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1912, SkinTone::Default)), aliases: Some(&["lotus_position_man"]), variations: &["🧘\u{200d}♂"] },
    Emoji { emoji: "🧘🏻‍♂️", name: "man in lotus position: light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1912, SkinTone::Light)), aliases: None, variations: &["🧘🏻\u{200d}♂"] },
    Emoji { emoji: "🧘🏼‍♂️", name: "man in lotus position: medium-light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1912, SkinTone::MediumLight)), aliases: None, variations: &["🧘🏼\u{200d}♂"] },
    Emoji { emoji: "🧘🏽‍♂️", name: "man in lotus position: medium skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1912, SkinTone::Medium)), aliases: None, variations: &["🧘🏽\u{200d}♂"] },
    Emoji { emoji: "🧘🏾‍♂️", name: "man in lotus position: medium-dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1912, SkinTone::MediumDark)), aliases: None, variations: &["🧘🏾\u{200d}♂"] },
    Emoji { emoji: "🧘🏿‍♂️", name: "man in lotus position: dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1912, SkinTone::Dark)), aliases: None, variations: &["🧘🏿\u{200d}♂"] },
    Emoji { emoji: "🧘‍♀️", name: "woman in lotus position", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1918, SkinTone::Default)), aliases: Some(&["lotus_position_woman"]), variations: &["🧘\u{200d}♀"] },
    Emoji { emoji: "🧘🏻‍♀️", name: "woman in lotus position: light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1918, SkinTone::Light)), aliases: None, variations: &["🧘🏻\u{200d}♀"] },
    Emoji { emoji: "🧘🏼‍♀️", name: "woman in lotus position: medium-light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1918, SkinTone::MediumLight)), aliases: None, variations: &["🧘🏼\u{200d}♀"] },
    Emoji { emoji: "🧘🏽‍♀️", name: "woman in lotus position: medium skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1918, SkinTone::Medium)), aliases: None, variations: &["🧘🏽\u{200d}♀"] },
    Emoji { emoji: "🧘🏾‍♀️", name: "woman in lotus position: medium-dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1918, SkinTone::MediumDark)), aliases: None, variations: &["🧘🏾\u{200d}♀"] },
    Emoji { emoji: "🧘🏿‍♀️", name: "woman in lotus position: dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1918, SkinTone::Dark)), aliases: None, variations: &["🧘🏿\u{200d}♀"] },
    Emoji { emoji: "🛀", name: "person taking bath", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: Some((1924, SkinTone::Default)), aliases: Some(&["bath"]), variations: &[] },
    Emoji { emoji: "🛀🏻", name: "person taking bath: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1924, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "🛀🏼", name: "person taking bath: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1924, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "🛀🏽", name: "person taking bath: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1924, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "🛀🏾", name: "person taking bath: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1924, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "🛀🏿", name: "person taking bath: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1924, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "🛌", name: "person in bed", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1930, SkinTone::Default)), aliases: Some(&["sleeping_bed"]), variations: &[] },
    Emoji { emoji: "🛌🏻", name: "person in bed: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1930, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "🛌🏼", name: "person in bed: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1930, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "🛌🏽", name: "person in bed: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1930, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "🛌🏾", name: "person in bed: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1930, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "🛌🏿", name: "person in bed: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1930, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "🧑‍🤝‍🧑", name: "people holding hands", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["people_holding_hands"]), variations: &["🧑🏻\u{200d}🤝\u{200d}🧑🏻", "🧑🏻\u{200d}🤝\u{200d}🧑🏼", "🧑🏻\u{200d}🤝\u{200d}🧑🏽", "🧑🏻\u{200d}🤝\u{200d}🧑🏾", "🧑🏻\u{200d}🤝\u{200d}🧑🏿", "🧑🏼\u{200d}🤝\u{200d}🧑🏻", "🧑🏼\u{200d}🤝\u{200d}🧑🏼", "🧑🏼\u{200d}🤝\u{200d}🧑🏽", "🧑🏼\u{200d}🤝\u{200d}🧑🏾", "🧑🏼\u{200d}🤝\u{200d}🧑🏿", "🧑🏽\u{200d}🤝\u{200d}🧑🏻", "🧑🏽\u{200d}🤝\u{200d}🧑🏼", "🧑🏽\u{200d}🤝\u{200d}🧑🏽", "🧑🏽\u{200d}🤝\u{200d}🧑🏾", "🧑🏽\u{200d}🤝\u{200d}🧑🏿", "🧑🏾\u{200d}🤝\u{200d}🧑🏻", "🧑🏾\u{200d}🤝\u{200d}🧑🏼", "🧑🏾\u{200d}🤝\u{200d}🧑🏽", "🧑🏾\u{200d}🤝\u{200d}🧑🏾", "🧑🏾\u{200d}🤝\u{200d}🧑🏿", "🧑🏿\u{200d}🤝\u{200d}🧑🏻", "🧑🏿\u{200d}🤝\u{200d}🧑🏼", "🧑🏿\u{200d}🤝\u{200d}🧑🏽", "🧑🏿\u{200d}🤝\u{200d}🧑🏾", "🧑🏿\u{200d}🤝\u{200d}🧑🏿"] },
    Emoji { emoji: "👭", name: "women holding hands", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1937, SkinTone::Default)), aliases: Some(&["two_women_holding_hands"]), variations: &["👩🏻\u{200d}🤝\u{200d}👩🏼", "👩🏻\u{200d}🤝\u{200d}👩🏽", "👩🏻\u{200d}🤝\u{200d}👩🏾", "👩🏻\u{200d}🤝\u{200d}👩🏿", "👩🏼\u{200d}🤝\u{200d}👩🏻", "👩🏼\u{200d}🤝\u{200d}👩🏽", "👩🏼\u{200d}🤝\u{200d}👩🏾", "👩🏼\u{200d}🤝\u{200d}👩🏿", "👩🏽\u{200d}🤝\u{200d}👩🏻", "👩🏽\u{200d}🤝\u{200d}👩🏼", "👩🏽\u{200d}🤝\u{200d}👩🏾", "👩🏽\u{200d}🤝\u{200d}👩🏿", "👩🏾\u{200d}🤝\u{200d}👩🏻", "👩🏾\u{200d}🤝\u{200d}👩🏼", "👩🏾\u{200d}🤝\u{200d}👩🏽", "👩🏾\u{200d}🤝\u{200d}👩🏿", "👩🏿\u{200d}🤝\u{200d}👩🏻", "👩🏿\u{200d}🤝\u{200d}👩🏼", "👩🏿\u{200d}🤝\u{200d}👩🏽", "👩🏿\u{200d}🤝\u{200d}👩🏾"] },
    Emoji { emoji: "👭🏻", name: "women holding hands: light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1937, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "👭🏼", name: "women holding hands: medium-light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1937, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "👭🏽", name: "women holding hands: medium skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1937, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "👭🏾", name: "women holding hands: medium-dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1937, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "👭🏿", name: "women holding hands: dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1937, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "👫", name: "woman and man holding hands", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: Some((1943, SkinTone::Default)), aliases: Some(&["couple"]), variations: &["👩🏻\u{200d}🤝\u{200d}👨🏼", "👩🏻\u{200d}🤝\u{200d}👨🏽", "👩🏻\u{200d}🤝\u{200d}👨🏾", "👩🏻\u{200d}🤝\u{200d}👨🏿", "👩🏼\u{200d}🤝\u{200d}👨🏻", "👩🏼\u{200d}🤝\u{200d}👨🏽", "👩🏼\u{200d}🤝\u{200d}👨🏾", "👩🏼\u{200d}🤝\u{200d}👨🏿", "👩🏽\u{200d}🤝\u{200d}👨🏻", "👩🏽\u{200d}🤝\u{200d}👨🏼", "👩🏽\u{200d}🤝\u{200d}👨🏾", "👩🏽\u{200d}🤝\u{200d}👨🏿", "👩🏾\u{200d}🤝\u{200d}👨🏻", "👩🏾\u{200d}🤝\u{200d}👨🏼", "👩🏾\u{200d}🤝\u{200d}👨🏽", "👩🏾\u{200d}🤝\u{200d}👨🏿", "👩🏿\u{200d}🤝\u{200d}👨🏻", "👩🏿\u{200d}🤝\u{200d}👨🏼", "👩🏿\u{200d}🤝\u{200d}👨🏽", "👩🏿\u{200d}🤝\u{200d}👨🏾"] },
    Emoji { emoji: "👫🏻", name: "woman and man holding hands: light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1943, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "👫🏼", name: "woman and man holding hands: medium-light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1943, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "👫🏽", name: "woman and man holding hands: medium skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1943, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "👫🏾", name: "woman and man holding hands: medium-dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1943, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "👫🏿", name: "woman and man holding hands: dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1943, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "👬", name: "men holding hands", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1949, SkinTone::Default)), aliases: Some(&["two_men_holding_hands"]), variations: &["👨🏻\u{200d}🤝\u{200d}👨🏼", "👨🏻\u{200d}🤝\u{200d}👨🏽", "👨🏻\u{200d}🤝\u{200d}👨🏾", "👨🏻\u{200d}🤝\u{200d}👨🏿", "👨🏼\u{200d}🤝\u{200d}👨🏻", "👨🏼\u{200d}🤝\u{200d}👨🏽", "👨🏼\u{200d}🤝\u{200d}👨🏾", "👨🏼\u{200d}🤝\u{200d}👨🏿", "👨🏽\u{200d}🤝\u{200d}👨🏻", "👨🏽\u{200d}🤝\u{200d}👨🏼", "👨🏽\u{200d}🤝\u{200d}👨🏾", "👨🏽\u{200d}🤝\u{200d}👨🏿", "👨🏾\u{200d}🤝\u{200d}👨🏻", "👨🏾\u{200d}🤝\u{200d}👨🏼", "👨🏾\u{200d}🤝\u{200d}👨🏽", "👨🏾\u{200d}🤝\u{200d}👨🏿", "👨🏿\u{200d}🤝\u{200d}👨🏻", "👨🏿\u{200d}🤝\u{200d}👨🏼", "👨🏿\u{200d}🤝\u{200d}👨🏽", "👨🏿\u{200d}🤝\u{200d}👨🏾"] },
    Emoji { emoji: "👬🏻", name: "men holding hands: light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1949, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "👬🏼", name: "men holding hands: medium-light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1949, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "👬🏽", name: "men holding hands: medium skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1949, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "👬🏾", name: "men holding hands: medium-dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1949, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "👬🏿", name: "men holding hands: dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1949, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { emoji: "💏", name: "kiss", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: Some((1955, SkinTone::Default)), aliases: Some(&["couplekiss"]), variations: &["🧑🏻\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}🧑🏼", "🧑🏻\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}🧑🏽", "🧑🏻\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}🧑🏾", "🧑🏻\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}🧑🏿", "🧑🏼\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}🧑🏻", "🧑🏼\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}🧑🏽", "🧑🏼\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}🧑🏾", "🧑🏼\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}🧑🏿", "🧑🏽\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}🧑🏻", "🧑🏽\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}🧑🏼", "🧑🏽\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}🧑🏾", "🧑🏽\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}🧑🏿", "🧑🏾\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}🧑🏻", "🧑🏾\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}🧑🏼", "🧑🏾\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}🧑🏽", "🧑🏾\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}🧑🏿", "🧑🏿\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}🧑🏻", "🧑🏿\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}🧑🏼", "🧑🏿\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}🧑🏽", "🧑🏿\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}🧑🏾"] },
    Emoji { emoji: "💏🏻", name: "kiss: light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1955, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "💏🏼", name: "kiss: medium-light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1955, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "💏🏽", name: "kiss: medium skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1955, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "💏🏾", name: "kiss: medium-dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1955, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "💏🏿", name: "kiss: dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1955, SkinTone::Dark)), aliases: None, variations: &["🧑🏻\u{200d}❤\u{200d}💋\u{200d}🧑🏼", "🧑🏻\u{200d}❤\u{200d}💋\u{200d}🧑🏽", "🧑🏻\u{200d}❤\u{200d}💋\u{200d}🧑🏾", "🧑🏻\u{200d}❤\u{200d}💋\u{200d}🧑🏿", "🧑🏼\u{200d}❤\u{200d}💋\u{200d}🧑🏻", "🧑🏼\u{200d}❤\u{200d}💋\u{200d}🧑🏽", "🧑🏼\u{200d}❤\u{200d}💋\u{200d}🧑🏾", "🧑🏼\u{200d}❤\u{200d}💋\u{200d}🧑🏿", "🧑🏽\u{200d}❤\u{200d}💋\u{200d}🧑🏻", "🧑🏽\u{200d}❤\u{200d}💋\u{200d}🧑🏼", "🧑🏽\u{200d}❤\u{200d}💋\u{200d}🧑🏾", "🧑🏽\u{200d}❤\u{200d}💋\u{200d}🧑🏿", "🧑🏾\u{200d}❤\u{200d}💋\u{200d}🧑🏻", "🧑🏾\u{200d}❤\u{200d}💋\u{200d}🧑🏼", "🧑🏾\u{200d}❤\u{200d}💋\u{200d}🧑🏽", "🧑🏾\u{200d}❤\u{200d}💋\u{200d}🧑🏿", "🧑🏿\u{200d}❤\u{200d}💋\u{200d}🧑🏻", "🧑🏿\u{200d}❤\u{200d}💋\u{200d}🧑🏼", "🧑🏿\u{200d}❤\u{200d}💋\u{200d}🧑🏽", "🧑🏿\u{200d}❤\u{200d}💋\u{200d}🧑🏾"] },
    Emoji { emoji: "👩‍❤️‍💋‍👨", name: "kiss: woman, man", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["couplekiss_man_woman"]), variations: &["👩\u{200d}❤\u{200d}💋\u{200d}👨", "👩🏻\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏻", "👩🏻\u{200d}❤\u{200d}💋\u{200d}👨🏻", "👩🏻\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏼", "👩🏻\u{200d}❤\u{200d}💋\u{200d}👨🏼", "👩🏻\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏽", "👩🏻\u{200d}❤\u{200d}💋\u{200d}👨🏽", "👩🏻\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏾", "👩🏻\u{200d}❤\u{200d}💋\u{200d}👨🏾", "👩🏻\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏿", "👩🏻\u{200d}❤\u{200d}💋\u{200d}👨🏿", "👩🏼\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏻", "👩🏼\u{200d}❤\u{200d}💋\u{200d}👨🏻", "👩🏼\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏼", "👩🏼\u{200d}❤\u{200d}💋\u{200d}👨🏼", "👩🏼\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏽", "👩🏼\u{200d}❤\u{200d}💋\u{200d}👨🏽", "👩🏼\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏾", "👩🏼\u{200d}❤\u{200d}💋\u{200d}👨🏾", "👩🏼\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏿", "👩🏼\u{200d}❤\u{200d}💋\u{200d}👨🏿", "👩🏽\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏻", "👩🏽\u{200d}❤\u{200d}💋\u{200d}👨🏻", "👩🏽\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏼", "👩🏽\u{200d}❤\u{200d}💋\u{200d}👨🏼", "👩🏽\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏽", "👩🏽\u{200d}❤\u{200d}💋\u{200d}👨🏽", "👩🏽\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏾", "👩🏽\u{200d}❤\u{200d}💋\u{200d}👨🏾", "👩🏽\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏿", "👩🏽\u{200d}❤\u{200d}💋\u{200d}👨🏿", "👩🏾\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏻", "👩🏾\u{200d}❤\u{200d}💋\u{200d}👨🏻", "👩🏾\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏼", "👩🏾\u{200d}❤\u{200d}💋\u{200d}👨🏼", "👩🏾\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏽", "👩🏾\u{200d}❤\u{200d}💋\u{200d}👨🏽", "👩🏾\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏾", "👩🏾\u{200d}❤\u{200d}💋\u{200d}👨🏾", "👩🏾\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏿", "👩🏾\u{200d}❤\u{200d}💋\u{200d}👨🏿", "👩🏿\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏻", "👩🏿\u{200d}❤\u{200d}💋\u{200d}👨🏻", "👩🏿\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏼", "👩🏿\u{200d}❤\u{200d}💋\u{200d}👨🏼", "👩🏿\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏽", "👩🏿\u{200d}❤\u{200d}💋\u{200d}👨🏽", "👩🏿\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏾", "👩🏿\u{200d}❤\u{200d}💋\u{200d}👨🏾", "👩🏿\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏿", "👩🏿\u{200d}❤\u{200d}💋\u{200d}👨🏿"] },
    Emoji { emoji: "👨‍❤️‍💋‍👨", name: "kiss: man, man", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["couplekiss_man_man"]), variations: &["👨\u{200d}❤\u{200d}💋\u{200d}👨", "👨🏻\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏻", "👨🏻\u{200d}❤\u{200d}💋\u{200d}👨🏻", "👨🏻\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏼", "👨🏻\u{200d}❤\u{200d}💋\u{200d}👨🏼", "👨🏻\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏽", "👨🏻\u{200d}❤\u{200d}💋\u{200d}👨🏽", "👨🏻\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏾", "👨🏻\u{200d}❤\u{200d}💋\u{200d}👨🏾", "👨🏻\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏿", "👨🏻\u{200d}❤\u{200d}💋\u{200d}👨🏿", "👨🏼\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏻", "👨🏼\u{200d}❤\u{200d}💋\u{200d}👨🏻", "👨🏼\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏼", "👨🏼\u{200d}❤\u{200d}💋\u{200d}👨🏼", "👨🏼\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏽", "👨🏼\u{200d}❤\u{200d}💋\u{200d}👨🏽", "👨🏼\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏾", "👨🏼\u{200d}❤\u{200d}💋\u{200d}👨🏾", "👨🏼\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏿", "👨🏼\u{200d}❤\u{200d}💋\u{200d}👨🏿", "👨🏽\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏻", "👨🏽\u{200d}❤\u{200d}💋\u{200d}👨🏻", "👨🏽\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏼", "👨🏽\u{200d}❤\u{200d}💋\u{200d}👨🏼", "👨🏽\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏽", "👨🏽\u{200d}❤\u{200d}💋\u{200d}👨🏽", "👨🏽\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏾", "👨🏽\u{200d}❤\u{200d}💋\u{200d}👨🏾", "👨🏽\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏿", "👨🏽\u{200d}❤\u{200d}💋\u{200d}👨🏿", "👨🏾\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏻", "👨🏾\u{200d}❤\u{200d}💋\u{200d}👨🏻", "👨🏾\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏼", "👨🏾\u{200d}❤\u{200d}💋\u{200d}👨🏼", "👨🏾\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏽", "👨🏾\u{200d}❤\u{200d}💋\u{200d}👨🏽", "👨🏾\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏾", "👨🏾\u{200d}❤\u{200d}💋\u{200d}👨🏾", "👨🏾\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏿", "👨🏾\u{200d}❤\u{200d}💋\u{200d}👨🏿", "👨🏿\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏻", "👨🏿\u{200d}❤\u{200d}💋\u{200d}👨🏻", "👨🏿\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏼", "👨🏿\u{200d}❤\u{200d}💋\u{200d}👨🏼", "👨🏿\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏽", "👨🏿\u{200d}❤\u{200d}💋\u{200d}👨🏽", "👨🏿\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏾", "👨🏿\u{200d}❤\u{200d}💋\u{200d}👨🏾", "👨🏿\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏿", "👨🏿\u{200d}❤\u{200d}💋\u{200d}👨🏿"] },
    Emoji { emoji: "👩‍❤️‍💋‍👩", name: "kiss: woman, woman", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["couplekiss_woman_woman"]), variations: &["👩\u{200d}❤\u{200d}💋\u{200d}👩", "👩🏻\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👩🏻", "👩🏻\u{200d}❤\u{200d}💋\u{200d}👩🏻", "👩🏻\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👩🏼", "👩🏻\u{200d}❤\u{200d}💋\u{200d}👩🏼", "👩🏻\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👩🏽", "👩🏻\u{200d}❤\u{200d}💋\u{200d}👩🏽", "👩🏻\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👩🏾", "👩🏻\u{200d}❤\u{200d}💋\u{200d}👩🏾", "👩🏻\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👩🏿", "👩🏻\u{200d}❤\u{200d}💋\u{200d}👩🏿", "👩🏼\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👩🏻", "👩🏼\u{200d}❤\u{200d}💋\u{200d}👩🏻", "👩🏼\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👩🏼", "👩🏼\u{200d}❤\u{200d}💋\u{200d}👩🏼", "👩🏼\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👩🏽", "👩🏼\u{200d}❤\u{200d}💋\u{200d}👩🏽", "👩🏼\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👩🏾", "👩🏼\u{200d}❤\u{200d}💋\u{200d}👩🏾", "👩🏼\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👩🏿", "👩🏼\u{200d}❤\u{200d}💋\u{200d}👩🏿", "👩🏽\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👩🏻", "👩🏽\u{200d}❤\u{200d}💋\u{200d}👩🏻", "👩🏽\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👩🏼", "👩🏽\u{200d}❤\u{200d}💋\u{200d}👩🏼", "👩🏽\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👩🏽", "👩🏽\u{200d}❤\u{200d}💋\u{200d}👩🏽", "👩🏽\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👩🏾", "👩🏽\u{200d}❤\u{200d}💋\u{200d}👩🏾", "👩🏽\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👩🏿", "👩🏽\u{200d}❤\u{200d}💋\u{200d}👩🏿", "👩🏾\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👩🏻", "👩🏾\u{200d}❤\u{200d}💋\u{200d}👩🏻", "👩🏾\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👩🏼", "👩🏾\u{200d}❤\u{200d}💋\u{200d}👩🏼", "👩🏾\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👩🏽", "👩🏾\u{200d}❤\u{200d}💋\u{200d}👩🏽", "👩🏾\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👩🏾", "👩🏾\u{200d}❤\u{200d}💋\u{200d}👩🏾", "👩🏾\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👩🏿", "👩🏾\u{200d}❤\u{200d}💋\u{200d}👩🏿", "👩🏿\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👩🏻", "👩🏿\u{200d}❤\u{200d}💋\u{200d}👩🏻", "👩🏿\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👩🏼", "👩🏿\u{200d}❤\u{200d}💋\u{200d}👩🏼", "👩🏿\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👩🏽", "👩🏿\u{200d}❤\u{200d}💋\u{200d}👩🏽", "👩🏿\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👩🏾", "👩🏿\u{200d}❤\u{200d}💋\u{200d}👩🏾", "👩🏿\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👩🏿", "👩🏿\u{200d}❤\u{200d}💋\u{200d}👩🏿"] },
    Emoji { emoji: "💑", name: "couple with heart", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: Some((1964, SkinTone::Default)), aliases: Some(&["couple_with_heart"]), variations: &["🧑🏻\u{200d}❤\u{fe0f}\u{200d}🧑🏼", "🧑🏻\u{200d}❤\u{fe0f}\u{200d}🧑🏽", "🧑🏻\u{200d}❤\u{fe0f}\u{200d}🧑🏾", "🧑🏻\u{200d}❤\u{fe0f}\u{200d}🧑🏿", "🧑🏼\u{200d}❤\u{fe0f}\u{200d}🧑🏻", "🧑🏼\u{200d}❤\u{fe0f}\u{200d}🧑🏽", "🧑🏼\u{200d}❤\u{fe0f}\u{200d}🧑🏾", "🧑🏼\u{200d}❤\u{fe0f}\u{200d}🧑🏿", "🧑🏽\u{200d}❤\u{fe0f}\u{200d}🧑🏻", "🧑🏽\u{200d}❤\u{fe0f}\u{200d}🧑🏼", "🧑🏽\u{200d}❤\u{fe0f}\u{200d}🧑🏾", "🧑🏽\u{200d}❤\u{fe0f}\u{200d}🧑🏿", "🧑🏾\u{200d}❤\u{fe0f}\u{200d}🧑🏻", "🧑🏾\u{200d}❤\u{fe0f}\u{200d}🧑🏼", "🧑🏾\u{200d}❤\u{fe0f}\u{200d}🧑🏽", "🧑🏾\u{200d}❤\u{fe0f}\u{200d}🧑🏿", "🧑🏿\u{200d}❤\u{fe0f}\u{200d}🧑🏻", "🧑🏿\u{200d}❤\u{fe0f}\u{200d}🧑🏼", "🧑🏿\u{200d}❤\u{fe0f}\u{200d}🧑🏽", "🧑🏿\u{200d}❤\u{fe0f}\u{200d}🧑🏾"] },
    Emoji { emoji: "💑🏻", name: "couple with heart: light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1964, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { emoji: "💑🏼", name: "couple with heart: medium-light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1964, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { emoji: "💑🏽", name: "couple with heart: medium skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1964, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { emoji: "💑🏾", name: "couple with heart: medium-dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1964, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { emoji: "💑🏿", name: "couple with heart: dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1964, SkinTone::Dark)), aliases: None, variations: &["🧑🏻\u{200d}❤\u{200d}🧑🏼", "🧑🏻\u{200d}❤\u{200d}🧑🏽", "🧑🏻\u{200d}❤\u{200d}🧑🏾", "🧑🏻\u{200d}❤\u{200d}🧑🏿", "🧑🏼\u{200d}❤\u{200d}🧑🏻", "🧑🏼\u{200d}❤\u{200d}🧑🏽", "🧑🏼\u{200d}❤\u{200d}🧑🏾", "🧑🏼\u{200d}❤\u{200d}🧑🏿", "🧑🏽\u{200d}❤\u{200d}🧑🏻", "🧑🏽\u{200d}❤\u{200d}🧑🏼", "🧑🏽\u{200d}❤\u{200d}🧑🏾", "🧑🏽\u{200d}❤\u{200d}🧑🏿", "🧑🏾\u{200d}❤\u{200d}🧑🏻", "🧑🏾\u{200d}❤\u{200d}🧑🏼", "🧑🏾\u{200d}❤\u{200d}🧑🏽", "🧑🏾\u{200d}❤\u{200d}🧑🏿", "🧑🏿\u{200d}❤\u{200d}🧑🏻", "🧑🏿\u{200d}❤\u{200d}🧑🏼", "🧑🏿\u{200d}❤\u{200d}🧑🏽", "🧑🏿\u{200d}❤\u{200d}🧑🏾"] },
    Emoji { emoji: "👩‍❤️‍👨", name: "couple with heart: woman, man", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["couple_with_heart_woman_man"]), variations: &["👩\u{200d}❤\u{200d}👨", "👩🏻\u{200d}❤\u{fe0f}\u{200d}👨🏻", "👩🏻\u{200d}❤\u{200d}👨🏻", "👩🏻\u{200d}❤\u{fe0f}\u{200d}👨🏼", "👩🏻\u{200d}❤\u{200d}👨🏼", "👩🏻\u{200d}❤\u{fe0f}\u{200d}👨🏽", "👩🏻\u{200d}❤\u{200d}👨🏽", "👩🏻\u{200d}❤\u{fe0f}\u{200d}👨🏾", "👩🏻\u{200d}❤\u{200d}👨🏾", "👩🏻\u{200d}❤\u{fe0f}\u{200d}👨🏿", "👩🏻\u{200d}❤\u{200d}👨🏿", "👩🏼\u{200d}❤\u{fe0f}\u{200d}👨🏻", "👩🏼\u{200d}❤\u{200d}👨🏻", "👩🏼\u{200d}❤\u{fe0f}\u{200d}👨🏼", "👩🏼\u{200d}❤\u{200d}👨🏼", "👩🏼\u{200d}❤\u{fe0f}\u{200d}👨🏽", "👩🏼\u{200d}❤\u{200d}👨🏽", "👩🏼\u{200d}❤\u{fe0f}\u{200d}👨🏾", "👩🏼\u{200d}❤\u{200d}👨🏾", "👩🏼\u{200d}❤\u{fe0f}\u{200d}👨🏿", "👩🏼\u{200d}❤\u{200d}👨🏿", "👩🏽\u{200d}❤\u{fe0f}\u{200d}👨🏻", "👩🏽\u{200d}❤\u{200d}👨🏻", "👩🏽\u{200d}❤\u{fe0f}\u{200d}👨🏼", "👩🏽\u{200d}❤\u{200d}👨🏼", "👩🏽\u{200d}❤\u{fe0f}\u{200d}👨🏽", "👩🏽\u{200d}❤\u{200d}👨🏽", "👩🏽\u{200d}❤\u{fe0f}\u{200d}👨🏾", "👩🏽\u{200d}❤\u{200d}👨🏾", "👩🏽\u{200d}❤\u{fe0f}\u{200d}👨🏿", "👩🏽\u{200d}❤\u{200d}👨🏿", "👩🏾\u{200d}❤\u{fe0f}\u{200d}👨🏻", "👩🏾\u{200d}❤\u{200d}👨🏻", "👩🏾\u{200d}❤\u{fe0f}\u{200d}👨🏼", "👩🏾\u{200d}❤\u{200d}👨🏼", "👩🏾\u{200d}❤\u{fe0f}\u{200d}👨🏽", "👩🏾\u{200d}❤\u{200d}👨🏽", "👩🏾\u{200d}❤\u{fe0f}\u{200d}👨🏾", "👩🏾\u{200d}❤\u{200d}👨🏾", "👩🏾\u{200d}❤\u{fe0f}\u{200d}👨🏿", "👩🏾\u{200d}❤\u{200d}👨🏿", "👩🏿\u{200d}❤\u{fe0f}\u{200d}👨🏻", "👩🏿\u{200d}❤\u{200d}👨🏻", "👩🏿\u{200d}❤\u{fe0f}\u{200d}👨🏼", "👩🏿\u{200d}❤\u{200d}👨🏼", "👩🏿\u{200d}❤\u{fe0f}\u{200d}👨🏽", "👩🏿\u{200d}❤\u{200d}👨🏽", "👩🏿\u{200d}❤\u{fe0f}\u{200d}👨🏾", "👩🏿\u{200d}❤\u{200d}👨🏾", "👩🏿\u{200d}❤\u{fe0f}\u{200d}👨🏿", "👩🏿\u{200d}❤\u{200d}👨🏿"] },
    Emoji { emoji: "👨‍❤️‍👨", name: "couple with heart: man, man", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["couple_with_heart_man_man"]), variations: &["👨\u{200d}❤\u{200d}👨", "👨🏻\u{200d}❤\u{fe0f}\u{200d}👨🏻", "👨🏻\u{200d}❤\u{200d}👨🏻", "👨🏻\u{200d}❤\u{fe0f}\u{200d}👨🏼", "👨🏻\u{200d}❤\u{200d}👨🏼", "👨🏻\u{200d}❤\u{fe0f}\u{200d}👨🏽", "👨🏻\u{200d}❤\u{200d}👨🏽", "👨🏻\u{200d}❤\u{fe0f}\u{200d}👨🏾", "👨🏻\u{200d}❤\u{200d}👨🏾", "👨🏻\u{200d}❤\u{fe0f}\u{200d}👨🏿", "👨🏻\u{200d}❤\u{200d}👨🏿", "👨🏼\u{200d}❤\u{fe0f}\u{200d}👨🏻", "👨🏼\u{200d}❤\u{200d}👨🏻", "👨🏼\u{200d}❤\u{fe0f}\u{200d}👨🏼", "👨🏼\u{200d}❤\u{200d}👨🏼", "👨🏼\u{200d}❤\u{fe0f}\u{200d}👨🏽", "👨🏼\u{200d}❤\u{200d}👨🏽", "👨🏼\u{200d}❤\u{fe0f}\u{200d}👨🏾", "👨🏼\u{200d}❤\u{200d}👨🏾", "👨🏼\u{200d}❤\u{fe0f}\u{200d}👨🏿", "👨🏼\u{200d}❤\u{200d}👨🏿", "👨🏽\u{200d}❤\u{fe0f}\u{200d}👨🏻", "👨🏽\u{200d}❤\u{200d}👨🏻", "👨🏽\u{200d}❤\u{fe0f}\u{200d}👨🏼", "👨🏽\u{200d}❤\u{200d}👨🏼", "👨🏽\u{200d}❤\u{fe0f}\u{200d}👨🏽", "👨🏽\u{200d}❤\u{200d}👨🏽", "👨🏽\u{200d}❤\u{fe0f}\u{200d}👨🏾", "👨🏽\u{200d}❤\u{200d}👨🏾", "👨🏽\u{200d}❤\u{fe0f}\u{200d}👨🏿", "👨🏽\u{200d}❤\u{200d}👨🏿", "👨🏾\u{200d}❤\u{fe0f}\u{200d}👨🏻", "👨🏾\u{200d}❤\u{200d}👨🏻", "👨🏾\u{200d}❤\u{fe0f}\u{200d}👨🏼", "👨🏾\u{200d}❤\u{200d}👨🏼", "👨🏾\u{200d}❤\u{fe0f}\u{200d}👨🏽", "👨🏾\u{200d}❤\u{200d}👨🏽", "👨🏾\u{200d}❤\u{fe0f}\u{200d}👨🏾", "👨🏾\u{200d}❤\u{200d}👨🏾", "👨🏾\u{200d}❤\u{fe0f}\u{200d}👨🏿", "👨🏾\u{200d}❤\u{200d}👨🏿", "👨🏿\u{200d}❤\u{fe0f}\u{200d}👨🏻", "👨🏿\u{200d}❤\u{200d}👨🏻", "👨🏿\u{200d}❤\u{fe0f}\u{200d}👨🏼", "👨🏿\u{200d}❤\u{200d}👨🏼", "👨🏿\u{200d}❤\u{fe0f}\u{200d}👨🏽", "👨🏿\u{200d}❤\u{200d}👨🏽", "👨🏿\u{200d}❤\u{fe0f}\u{200d}👨🏾", "👨🏿\u{200d}❤\u{200d}👨🏾", "👨🏿\u{200d}❤\u{fe0f}\u{200d}👨🏿", "👨🏿\u{200d}❤\u{200d}👨🏿"] },
    Emoji { emoji: "👩‍❤️‍👩", name: "couple with heart: woman, woman", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["couple_with_heart_woman_woman"]), variations: &["👩\u{200d}❤\u{200d}👩", "👩🏻\u{200d}❤\u{fe0f}\u{200d}👩🏻", "👩🏻\u{200d}❤\u{200d}👩🏻", "👩🏻\u{200d}❤\u{fe0f}\u{200d}👩🏼", "👩🏻\u{200d}❤\u{200d}👩🏼", "👩🏻\u{200d}❤\u{fe0f}\u{200d}👩🏽", "👩🏻\u{200d}❤\u{200d}👩🏽", "👩🏻\u{200d}❤\u{fe0f}\u{200d}👩🏾", "👩🏻\u{200d}❤\u{200d}👩🏾", "👩🏻\u{200d}❤\u{fe0f}\u{200d}👩🏿", "👩🏻\u{200d}❤\u{200d}👩🏿", "👩🏼\u{200d}❤\u{fe0f}\u{200d}👩🏻", "👩🏼\u{200d}❤\u{200d}👩🏻", "👩🏼\u{200d}❤\u{fe0f}\u{200d}👩🏼", "👩🏼\u{200d}❤\u{200d}👩🏼", "👩🏼\u{200d}❤\u{fe0f}\u{200d}👩🏽", "👩🏼\u{200d}❤\u{200d}👩🏽", "👩🏼\u{200d}❤\u{fe0f}\u{200d}👩🏾", "👩🏼\u{200d}❤\u{200d}👩🏾", "👩🏼\u{200d}❤\u{fe0f}\u{200d}👩🏿", "👩🏼\u{200d}❤\u{200d}👩🏿", "👩🏽\u{200d}❤\u{fe0f}\u{200d}👩🏻", "👩🏽\u{200d}❤\u{200d}👩🏻", "👩🏽\u{200d}❤\u{fe0f}\u{200d}👩🏼", "👩🏽\u{200d}❤\u{200d}👩🏼", "👩🏽\u{200d}❤\u{fe0f}\u{200d}👩🏽", "👩🏽\u{200d}❤\u{200d}👩🏽", "👩🏽\u{200d}❤\u{fe0f}\u{200d}👩🏾", "👩🏽\u{200d}❤\u{200d}👩🏾", "👩🏽\u{200d}❤\u{fe0f}\u{200d}👩🏿", "👩🏽\u{200d}❤\u{200d}👩🏿", "👩🏾\u{200d}❤\u{fe0f}\u{200d}👩🏻", "👩🏾\u{200d}❤\u{200d}👩🏻", "👩🏾\u{200d}❤\u{fe0f}\u{200d}👩🏼", "👩🏾\u{200d}❤\u{200d}👩🏼", "👩🏾\u{200d}❤\u{fe0f}\u{200d}👩🏽", "👩🏾\u{200d}❤\u{200d}👩🏽", "👩🏾\u{200d}❤\u{fe0f}\u{200d}👩🏾", "👩🏾\u{200d}❤\u{200d}👩🏾", "👩🏾\u{200d}❤\u{fe0f}\u{200d}👩🏿", "👩🏾\u{200d}❤\u{200d}👩🏿", "👩🏿\u{200d}❤\u{fe0f}\u{200d}👩🏻", "👩🏿\u{200d}❤\u{200d}👩🏻", "👩🏿\u{200d}❤\u{fe0f}\u{200d}👩🏼", "👩🏿\u{200d}❤\u{200d}👩🏼", "👩🏿\u{200d}❤\u{fe0f}\u{200d}👩🏽", "👩🏿\u{200d}❤\u{200d}👩🏽", "👩🏿\u{200d}❤\u{fe0f}\u{200d}👩🏾", "👩🏿\u{200d}❤\u{200d}👩🏾", "👩🏿\u{200d}❤\u{fe0f}\u{200d}👩🏿", "👩🏿\u{200d}❤\u{200d}👩🏿"] },
    Emoji { emoji: "👪", name: "family", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["family"]), variations: &[] },
    Emoji { emoji: "👨‍👩‍👦", name: "family: man, woman, boy", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["family_man_woman_boy"]), variations: &[] },
    Emoji { emoji: "👨‍👩‍👧", name: "family: man, woman, girl", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["family_man_woman_girl"]), variations: &[] },
    Emoji { emoji: "👨‍👩‍👧‍👦", name: "family: man, woman, girl, boy", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["family_man_woman_girl_boy"]), variations: &[] },
    Emoji { emoji: "👨‍👩‍👦‍👦", name: "family: man, woman, boy, boy", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["family_man_woman_boy_boy"]), variations: &[] },
    Emoji { emoji: "👨‍👩‍👧‍👧", name: "family: man, woman, girl, girl", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["family_man_woman_girl_girl"]), variations: &[] },
    Emoji { emoji: "👨‍👨‍👦", name: "family: man, man, boy", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["family_man_man_boy"]), variations: &[] },
    Emoji { emoji: "👨‍👨‍👧", name: "family: man, man, girl", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["family_man_man_girl"]), variations: &[] },
    Emoji { emoji: "👨‍👨‍👧‍👦", name: "family: man, man, girl, boy", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["family_man_man_girl_boy"]), variations: &[] },
    Emoji { emoji: "👨‍👨‍👦‍👦", name: "family: man, man, boy, boy", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["family_man_man_boy_boy"]), variations: &[] },
    Emoji { emoji: "👨‍👨‍👧‍👧", name: "family: man, man, girl, girl", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["family_man_man_girl_girl"]), variations: &[] },
    Emoji { emoji: "👩‍👩‍👦", name: "family: woman, woman, boy", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["family_woman_woman_boy"]), variations: &[] },
    Emoji { emoji: "👩‍👩‍👧", name: "family: woman, woman, girl", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["family_woman_woman_girl"]), variations: &[] },
    Emoji { emoji: "👩‍👩‍👧‍👦", name: "family: woman, woman, girl, boy", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["family_woman_woman_girl_boy"]), variations: &[] },
    Emoji { emoji: "👩‍👩‍👦‍👦", name: "family: woman, woman, boy, boy", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["family_woman_woman_boy_boy"]), variations: &[] },
    Emoji { emoji: "👩‍👩‍👧‍👧", name: "family: woman, woman, girl, girl", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["family_woman_woman_girl_girl"]), variations: &[] },
    Emoji { emoji: "👨‍👦", name: "family: man, boy", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["family_man_boy"]), variations: &[] },
    Emoji { emoji: "👨‍👦‍👦", name: "family: man, boy, boy", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["family_man_boy_boy"]), variations: &[] },
    Emoji { emoji: "👨‍👧", name: "family: man, girl", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["family_man_girl"]), variations: &[] },
    Emoji { emoji: "👨‍👧‍👦", name: "family: man, girl, boy", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["family_man_girl_boy"]), variations: &[] },
    Emoji { emoji: "👨‍👧‍👧", name: "family: man, girl, girl", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["family_man_girl_girl"]), variations: &[] },
    Emoji { emoji: "👩‍👦", name: "family: woman, boy", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["family_woman_boy"]), variations: &[] },
    Emoji { emoji: "👩‍👦‍👦", name: "family: woman, boy, boy", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["family_woman_boy_boy"]), variations: &[] },
    Emoji { emoji: "👩‍👧", name: "family: woman, girl", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["family_woman_girl"]), variations: &[] },
    Emoji { emoji: "👩‍👧‍👦", name: "family: woman, girl, boy", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["family_woman_girl_boy"]), variations: &[] },
    Emoji { emoji: "👩‍👧‍👧", name: "family: woman, girl, girl", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["family_woman_girl_girl"]), variations: &[] },
    Emoji { emoji: "🗣️", name: "speaking head", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["speaking_head"]), variations: &["🗣"] },
    Emoji { emoji: "👤", name: "bust in silhouette", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["bust_in_silhouette"]), variations: &[] },
    Emoji { emoji: "👥", name: "busts in silhouette", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["busts_in_silhouette"]), variations: &[] },
    Emoji { emoji: "🫂", name: "people hugging", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["people_hugging"]), variations: &[] },
    Emoji { emoji: "👣", name: "footprints", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["footprints"]), variations: &[] },
    Emoji { emoji: "🐵", name: "monkey face", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["monkey_face"]), variations: &[] },
    Emoji { emoji: "🐒", name: "monkey", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["monkey"]), variations: &[] },
    Emoji { emoji: "🦍", name: "gorilla", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["gorilla"]), variations: &[] },
    Emoji { emoji: "🦧", name: "orangutan", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["orangutan"]), variations: &[] },
    Emoji { emoji: "🐶", name: "dog face", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["dog"]), variations: &[] },
    Emoji { emoji: "🐕", name: "dog", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["dog2"]), variations: &[] },
    Emoji { emoji: "🦮", name: "guide dog", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["guide_dog"]), variations: &[] },
    Emoji { emoji: "🐕‍🦺", name: "service dog", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["service_dog"]), variations: &[] },
    Emoji { emoji: "🐩", name: "poodle", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["poodle"]), variations: &[] },
    Emoji { emoji: "🐺", name: "wolf", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["wolf"]), variations: &[] },
    Emoji { emoji: "🦊", name: "fox", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["fox_face"]), variations: &[] },
    Emoji { emoji: "🦝", name: "raccoon", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["raccoon"]), variations: &[] },
    Emoji { emoji: "🐱", name: "cat face", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["cat"]), variations: &[] },
    Emoji { emoji: "🐈", name: "cat", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["cat2"]), variations: &[] },
    Emoji { emoji: "🐈‍⬛", name: "black cat", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["black_cat"]), variations: &[] },
    Emoji { emoji: "🦁", name: "lion", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["lion"]), variations: &[] },
    Emoji { emoji: "🐯", name: "tiger face", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["tiger"]), variations: &[] },
    Emoji { emoji: "🐅", name: "tiger", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["tiger2"]), variations: &[] },
    Emoji { emoji: "🐆", name: "leopard", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["leopard"]), variations: &[] },
    Emoji { emoji: "🐴", name: "horse face", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["horse"]), variations: &[] },
    Emoji { emoji: "🐎", name: "horse", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["racehorse"]), variations: &[] },
    Emoji { emoji: "🦄", name: "unicorn", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["unicorn"]), variations: &[] },
    Emoji { emoji: "🦓", name: "zebra", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["zebra"]), variations: &[] },
    Emoji { emoji: "🦌", name: "deer", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["deer"]), variations: &[] },
    Emoji { emoji: "🦬", name: "bison", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["bison"]), variations: &[] },
    Emoji { emoji: "🐮", name: "cow face", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["cow"]), variations: &[] },
    Emoji { emoji: "🐂", name: "ox", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["ox"]), variations: &[] },
    Emoji { emoji: "🐃", name: "water buffalo", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["water_buffalo"]), variations: &[] },
    Emoji { emoji: "🐄", name: "cow", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["cow2"]), variations: &[] },
    Emoji { emoji: "🐷", name: "pig face", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["pig"]), variations: &[] },
    Emoji { emoji: "🐖", name: "pig", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["pig2"]), variations: &[] },
    Emoji { emoji: "🐗", name: "boar", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["boar"]), variations: &[] },
    Emoji { emoji: "🐽", name: "pig nose", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["pig_nose"]), variations: &[] },
    Emoji { emoji: "🐏", name: "ram", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["ram"]), variations: &[] },
    Emoji { emoji: "🐑", name: "ewe", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["sheep"]), variations: &[] },
    Emoji { emoji: "🐐", name: "goat", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["goat"]), variations: &[] },
    Emoji { emoji: "🐪", name: "camel", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["dromedary_camel"]), variations: &[] },
    Emoji { emoji: "🐫", name: "two-hump camel", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["camel"]), variations: &[] },
    Emoji { emoji: "🦙", name: "llama", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["llama"]), variations: &[] },
    Emoji { emoji: "🦒", name: "giraffe", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["giraffe"]), variations: &[] },
    Emoji { emoji: "🐘", name: "elephant", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["elephant"]), variations: &[] },
    Emoji { emoji: "🦣", name: "mammoth", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["mammoth"]), variations: &[] },
    Emoji { emoji: "🦏", name: "rhinoceros", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["rhinoceros"]), variations: &[] },
    Emoji { emoji: "🦛", name: "hippopotamus", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["hippopotamus"]), variations: &[] },
    Emoji { emoji: "🐭", name: "mouse face", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["mouse"]), variations: &[] },
    Emoji { emoji: "🐁", name: "mouse", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["mouse2"]), variations: &[] },
    Emoji { emoji: "🐀", name: "rat", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["rat"]), variations: &[] },
    Emoji { emoji: "🐹", name: "hamster", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["hamster"]), variations: &[] },
    Emoji { emoji: "🐰", name: "rabbit face", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["rabbit"]), variations: &[] },
    Emoji { emoji: "🐇", name: "rabbit", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["rabbit2"]), variations: &[] },
    Emoji { emoji: "🐿️", name: "chipmunk", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["chipmunk"]), variations: &["🐿"] },
    Emoji { emoji: "🦫", name: "beaver", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["beaver"]), variations: &[] },
    Emoji { emoji: "🦔", name: "hedgehog", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["hedgehog"]), variations: &[] },
    Emoji { emoji: "🦇", name: "bat", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["bat"]), variations: &[] },
    Emoji { emoji: "🐻", name: "bear", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["bear"]), variations: &[] },
    Emoji { emoji: "🐻‍❄️", name: "polar bear", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["polar_bear"]), variations: &["🐻\u{200d}❄"] },
    Emoji { emoji: "🐨", name: "koala", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["koala"]), variations: &[] },
    Emoji { emoji: "🐼", name: "panda", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["panda_face"]), variations: &[] },
    Emoji { emoji: "🦥", name: "sloth", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["sloth"]), variations: &[] },
    Emoji { emoji: "🦦", name: "otter", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["otter"]), variations: &[] },
    Emoji { emoji: "🦨", name: "skunk", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["skunk"]), variations: &[] },
    Emoji { emoji: "🦘", name: "kangaroo", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["kangaroo"]), variations: &[] },
    Emoji { emoji: "🦡", name: "badger", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["badger"]), variations: &[] },
    Emoji { emoji: "🐾", name: "paw prints", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["feet", "paw_prints"]), variations: &[] },
    Emoji { emoji: "🦃", name: "turkey", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["turkey"]), variations: &[] },
    Emoji { emoji: "🐔", name: "chicken", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["chicken"]), variations: &[] },
    Emoji { emoji: "🐓", name: "rooster", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["rooster"]), variations: &[] },
    Emoji { emoji: "🐣", name: "hatching chick", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["hatching_chick"]), variations: &[] },
    Emoji { emoji: "🐤", name: "baby chick", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["baby_chick"]), variations: &[] },
    Emoji { emoji: "🐥", name: "front-facing baby chick", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["hatched_chick"]), variations: &[] },
    Emoji { emoji: "🐦", name: "bird", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["bird"]), variations: &[] },
    Emoji { emoji: "🐧", name: "penguin", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["penguin"]), variations: &[] },
    Emoji { emoji: "🕊️", name: "dove", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["dove"]), variations: &["🕊"] },
    Emoji { emoji: "🦅", name: "eagle", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["eagle"]), variations: &[] },
    Emoji { emoji: "🦆", name: "duck", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["duck"]), variations: &[] },
    Emoji { emoji: "🦢", name: "swan", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["swan"]), variations: &[] },
    Emoji { emoji: "🦉", name: "owl", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["owl"]), variations: &[] },
    Emoji { emoji: "🦤", name: "dodo", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["dodo"]), variations: &[] },
    Emoji { emoji: "🪶", name: "feather", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["feather"]), variations: &[] },
    Emoji { emoji: "🦩", name: "flamingo", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["flamingo"]), variations: &[] },
    Emoji { emoji: "🦚", name: "peacock", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["peacock"]), variations: &[] },
    Emoji { emoji: "🦜", name: "parrot", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["parrot"]), variations: &[] },
    Emoji { emoji: "🐸", name: "frog", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["frog"]), variations: &[] },
    Emoji { emoji: "🐊", name: "crocodile", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["crocodile"]), variations: &[] },
    Emoji { emoji: "🐢", name: "turtle", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["turtle"]), variations: &[] },
    Emoji { emoji: "🦎", name: "lizard", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["lizard"]), variations: &[] },
    Emoji { emoji: "🐍", name: "snake", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["snake"]), variations: &[] },
    Emoji { emoji: "🐲", name: "dragon face", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["dragon_face"]), variations: &[] },
    Emoji { emoji: "🐉", name: "dragon", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["dragon"]), variations: &[] },
    Emoji { emoji: "🦕", name: "sauropod", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["sauropod"]), variations: &[] },
    Emoji { emoji: "🦖", name: "T-Rex", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["t-rex"]), variations: &[] },
    Emoji { emoji: "🐳", name: "spouting whale", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["whale"]), variations: &[] },
    Emoji { emoji: "🐋", name: "whale", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["whale2"]), variations: &[] },
    Emoji { emoji: "🐬", name: "dolphin", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["dolphin", "flipper"]), variations: &[] },
    Emoji { emoji: "🦭", name: "seal", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["seal"]), variations: &[] },
    Emoji { emoji: "🐟", name: "fish", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["fish"]), variations: &[] },
    Emoji { emoji: "🐠", name: "tropical fish", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["tropical_fish"]), variations: &[] },
    Emoji { emoji: "🐡", name: "blowfish", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["blowfish"]), variations: &[] },
    Emoji { emoji: "🦈", name: "shark", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["shark"]), variations: &[] },
    Emoji { emoji: "🐙", name: "octopus", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["octopus"]), variations: &[] },
    Emoji { emoji: "🐚", name: "spiral shell", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["shell"]), variations: &[] },
    Emoji { emoji: "🪸", name: "coral", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: None, variations: &[] },
    Emoji { emoji: "🐌", name: "snail", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["snail"]), variations: &[] },
    Emoji { emoji: "🦋", name: "butterfly", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["butterfly"]), variations: &[] },
    Emoji { emoji: "🐛", name: "bug", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["bug"]), variations: &[] },
    Emoji { emoji: "🐜", name: "ant", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["ant"]), variations: &[] },
    Emoji { emoji: "🐝", name: "honeybee", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["bee", "honeybee"]), variations: &[] },
    Emoji { emoji: "🪲", name: "beetle", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["beetle"]), variations: &[] },
    Emoji { emoji: "🐞", name: "lady beetle", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["lady_beetle"]), variations: &[] },
    Emoji { emoji: "🦗", name: "cricket", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["cricket"]), variations: &[] },
    Emoji { emoji: "🪳", name: "cockroach", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["cockroach"]), variations: &[] },
    Emoji { emoji: "🕷️", name: "spider", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["spider"]), variations: &["🕷"] },
    Emoji { emoji: "🕸️", name: "spider web", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["spider_web"]), variations: &["🕸"] },
    Emoji { emoji: "🦂", name: "scorpion", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["scorpion"]), variations: &[] },
    Emoji { emoji: "🦟", name: "mosquito", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["mosquito"]), variations: &[] },
    Emoji { emoji: "🪰", name: "fly", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["fly"]), variations: &[] },
    Emoji { emoji: "🪱", name: "worm", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["worm"]), variations: &[] },
    Emoji { emoji: "🦠", name: "microbe", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["microbe"]), variations: &[] },
    Emoji { emoji: "💐", name: "bouquet", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["bouquet"]), variations: &[] },
    Emoji { emoji: "🌸", name: "cherry blossom", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["cherry_blossom"]), variations: &[] },
    Emoji { emoji: "💮", name: "white flower", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["white_flower"]), variations: &[] },
    Emoji { emoji: "🪷", name: "lotus", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: None, variations: &[] },
    Emoji { emoji: "🏵️", name: "rosette", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["rosette"]), variations: &["🏵"] },
    Emoji { emoji: "🌹", name: "rose", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["rose"]), variations: &[] },
    Emoji { emoji: "🥀", name: "wilted flower", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["wilted_flower"]), variations: &[] },
    Emoji { emoji: "🌺", name: "hibiscus", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["hibiscus"]), variations: &[] },
    Emoji { emoji: "🌻", name: "sunflower", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["sunflower"]), variations: &[] },
    Emoji { emoji: "🌼", name: "blossom", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["blossom"]), variations: &[] },
    Emoji { emoji: "🌷", name: "tulip", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["tulip"]), variations: &[] },
    Emoji { emoji: "🌱", name: "seedling", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["seedling"]), variations: &[] },
    Emoji { emoji: "🪴", name: "potted plant", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["potted_plant"]), variations: &[] },
    Emoji { emoji: "🌲", name: "evergreen tree", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["evergreen_tree"]), variations: &[] },
    Emoji { emoji: "🌳", name: "deciduous tree", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["deciduous_tree"]), variations: &[] },
    Emoji { emoji: "🌴", name: "palm tree", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["palm_tree"]), variations: &[] },
    Emoji { emoji: "🌵", name: "cactus", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["cactus"]), variations: &[] },
    Emoji { emoji: "🌾", name: "sheaf of rice", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["ear_of_rice"]), variations: &[] },
    Emoji { emoji: "🌿", name: "herb", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["herb"]), variations: &[] },
    Emoji { emoji: "☘️", name: "shamrock", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["shamrock"]), variations: &["☘"] },
    Emoji { emoji: "🍀", name: "four leaf clover", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["four_leaf_clover"]), variations: &[] },
    Emoji { emoji: "🍁", name: "maple leaf", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["maple_leaf"]), variations: &[] },
    Emoji { emoji: "🍂", name: "fallen leaf", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["fallen_leaf"]), variations: &[] },
    Emoji { emoji: "🍃", name: "leaf fluttering in wind", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["leaves"]), variations: &[] },
    Emoji { emoji: "🪹", name: "empty nest", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: None, variations: &[] },
    Emoji { emoji: "🪺", name: "nest with eggs", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, aliases: None, variations: &[] },
    Emoji { emoji: "🍇", name: "grapes", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["grapes"]), variations: &[] },
    Emoji { emoji: "🍈", name: "melon", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["melon"]), variations: &[] },
    Emoji { emoji: "🍉", name: "watermelon", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["watermelon"]), variations: &[] },
    Emoji { emoji: "🍊", name: "tangerine", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["tangerine", "orange", "mandarin"]), variations: &[] },
    Emoji { emoji: "🍋", name: "lemon", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["lemon"]), variations: &[] },
    Emoji { emoji: "🍌", name: "banana", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["banana"]), variations: &[] },
    Emoji { emoji: "🍍", name: "pineapple", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["pineapple"]), variations: &[] },
    Emoji { emoji: "🥭", name: "mango", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["mango"]), variations: &[] },
    Emoji { emoji: "🍎", name: "red apple", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["apple"]), variations: &[] },
    Emoji { emoji: "🍏", name: "green apple", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["green_apple"]), variations: &[] },
    Emoji { emoji: "🍐", name: "pear", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["pear"]), variations: &[] },
    Emoji { emoji: "🍑", name: "peach", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["peach"]), variations: &[] },
    Emoji { emoji: "🍒", name: "cherries", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["cherries"]), variations: &[] },
    Emoji { emoji: "🍓", name: "strawberry", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["strawberry"]), variations: &[] },
    Emoji { emoji: "🫐", name: "blueberries", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["blueberries"]), variations: &[] },
    Emoji { emoji: "🥝", name: "kiwi fruit", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["kiwi_fruit"]), variations: &[] },
    Emoji { emoji: "🍅", name: "tomato", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["tomato"]), variations: &[] },
    Emoji { emoji: "🫒", name: "olive", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["olive"]), variations: &[] },
    Emoji { emoji: "🥥", name: "coconut", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["coconut"]), variations: &[] },
    Emoji { emoji: "🥑", name: "avocado", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["avocado"]), variations: &[] },
    Emoji { emoji: "🍆", name: "eggplant", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["eggplant"]), variations: &[] },
    Emoji { emoji: "🥔", name: "potato", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["potato"]), variations: &[] },
    Emoji { emoji: "🥕", name: "carrot", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["carrot"]), variations: &[] },
    Emoji { emoji: "🌽", name: "ear of corn", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["corn"]), variations: &[] },
    Emoji { emoji: "🌶️", name: "hot pepper", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["hot_pepper"]), variations: &["🌶"] },
    Emoji { emoji: "🫑", name: "bell pepper", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["bell_pepper"]), variations: &[] },
    Emoji { emoji: "🥒", name: "cucumber", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["cucumber"]), variations: &[] },
    Emoji { emoji: "🥬", name: "leafy green", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["leafy_green"]), variations: &[] },
    Emoji { emoji: "🥦", name: "broccoli", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["broccoli"]), variations: &[] },
    Emoji { emoji: "🧄", name: "garlic", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["garlic"]), variations: &[] },
    Emoji { emoji: "🧅", name: "onion", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["onion"]), variations: &[] },
    Emoji { emoji: "🍄", name: "mushroom", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["mushroom"]), variations: &[] },
    Emoji { emoji: "🥜", name: "peanuts", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["peanuts"]), variations: &[] },
    Emoji { emoji: "🫘", name: "beans", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, aliases: None, variations: &[] },
    Emoji { emoji: "🌰", name: "chestnut", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["chestnut"]), variations: &[] },
    Emoji { emoji: "🍞", name: "bread", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["bread"]), variations: &[] },
    Emoji { emoji: "🥐", name: "croissant", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["croissant"]), variations: &[] },
    Emoji { emoji: "🥖", name: "baguette bread", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["baguette_bread"]), variations: &[] },
    Emoji { emoji: "🫓", name: "flatbread", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["flatbread"]), variations: &[] },
    Emoji { emoji: "🥨", name: "pretzel", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["pretzel"]), variations: &[] },
    Emoji { emoji: "🥯", name: "bagel", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["bagel"]), variations: &[] },
    Emoji { emoji: "🥞", name: "pancakes", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["pancakes"]), variations: &[] },
    Emoji { emoji: "🧇", name: "waffle", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["waffle"]), variations: &[] },
    Emoji { emoji: "🧀", name: "cheese wedge", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["cheese"]), variations: &[] },
    Emoji { emoji: "🍖", name: "meat on bone", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["meat_on_bone"]), variations: &[] },
    Emoji { emoji: "🍗", name: "poultry leg", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["poultry_leg"]), variations: &[] },
    Emoji { emoji: "🥩", name: "cut of meat", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["cut_of_meat"]), variations: &[] },
    Emoji { emoji: "🥓", name: "bacon", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["bacon"]), variations: &[] },
    Emoji { emoji: "🍔", name: "hamburger", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["hamburger"]), variations: &[] },
    Emoji { emoji: "🍟", name: "french fries", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["fries"]), variations: &[] },
    Emoji { emoji: "🍕", name: "pizza", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["pizza"]), variations: &[] },
    Emoji { emoji: "🌭", name: "hot dog", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["hotdog"]), variations: &[] },
    Emoji { emoji: "🥪", name: "sandwich", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["sandwich"]), variations: &[] },
    Emoji { emoji: "🌮", name: "taco", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["taco"]), variations: &[] },
    Emoji { emoji: "🌯", name: "burrito", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["burrito"]), variations: &[] },
    Emoji { emoji: "🫔", name: "tamale", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["tamale"]), variations: &[] },
    Emoji { emoji: "🥙", name: "stuffed flatbread", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["stuffed_flatbread"]), variations: &[] },
    Emoji { emoji: "🧆", name: "falafel", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["falafel"]), variations: &[] },
    Emoji { emoji: "🥚", name: "egg", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["egg"]), variations: &[] },
    Emoji { emoji: "🍳", name: "cooking", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["fried_egg"]), variations: &[] },
    Emoji { emoji: "🥘", name: "shallow pan of food", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["shallow_pan_of_food"]), variations: &[] },
    Emoji { emoji: "🍲", name: "pot of food", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["stew"]), variations: &[] },
    Emoji { emoji: "🫕", name: "fondue", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["fondue"]), variations: &[] },
    Emoji { emoji: "🥣", name: "bowl with spoon", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["bowl_with_spoon"]), variations: &[] },
    Emoji { emoji: "🥗", name: "green salad", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["green_salad"]), variations: &[] },
    Emoji { emoji: "🍿", name: "popcorn", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["popcorn"]), variations: &[] },
    Emoji { emoji: "🧈", name: "butter", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["butter"]), variations: &[] },
    Emoji { emoji: "🧂", name: "salt", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["salt"]), variations: &[] },
    Emoji { emoji: "🥫", name: "canned food", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["canned_food"]), variations: &[] },
    Emoji { emoji: "🍱", name: "bento box", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["bento"]), variations: &[] },
    Emoji { emoji: "🍘", name: "rice cracker", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["rice_cracker"]), variations: &[] },
    Emoji { emoji: "🍙", name: "rice ball", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["rice_ball"]), variations: &[] },
    Emoji { emoji: "🍚", name: "cooked rice", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["rice"]), variations: &[] },
    Emoji { emoji: "🍛", name: "curry rice", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["curry"]), variations: &[] },
    Emoji { emoji: "🍜", name: "steaming bowl", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["ramen"]), variations: &[] },
    Emoji { emoji: "🍝", name: "spaghetti", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["spaghetti"]), variations: &[] },
    Emoji { emoji: "🍠", name: "roasted sweet potato", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["sweet_potato"]), variations: &[] },
    Emoji { emoji: "🍢", name: "oden", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["oden"]), variations: &[] },
    Emoji { emoji: "🍣", name: "sushi", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["sushi"]), variations: &[] },
    Emoji { emoji: "🍤", name: "fried shrimp", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["fried_shrimp"]), variations: &[] },
    Emoji { emoji: "🍥", name: "fish cake with swirl", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["fish_cake"]), variations: &[] },
    Emoji { emoji: "🥮", name: "moon cake", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["moon_cake"]), variations: &[] },
    Emoji { emoji: "🍡", name: "dango", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["dango"]), variations: &[] },
    Emoji { emoji: "🥟", name: "dumpling", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["dumpling"]), variations: &[] },
    Emoji { emoji: "🥠", name: "fortune cookie", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["fortune_cookie"]), variations: &[] },
    Emoji { emoji: "🥡", name: "takeout box", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["takeout_box"]), variations: &[] },
    Emoji { emoji: "🦀", name: "crab", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["crab"]), variations: &[] },
    Emoji { emoji: "🦞", name: "lobster", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["lobster"]), variations: &[] },
    Emoji { emoji: "🦐", name: "shrimp", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["shrimp"]), variations: &[] },
    Emoji { emoji: "🦑", name: "squid", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["squid"]), variations: &[] },
    Emoji { emoji: "🦪", name: "oyster", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["oyster"]), variations: &[] },
    Emoji { emoji: "🍦", name: "soft ice cream", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["icecream"]), variations: &[] },
    Emoji { emoji: "🍧", name: "shaved ice", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["shaved_ice"]), variations: &[] },
    Emoji { emoji: "🍨", name: "ice cream", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["ice_cream"]), variations: &[] },
    Emoji { emoji: "🍩", name: "doughnut", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["doughnut"]), variations: &[] },
    Emoji { emoji: "🍪", name: "cookie", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["cookie"]), variations: &[] },
    Emoji { emoji: "🎂", name: "birthday cake", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["birthday"]), variations: &[] },
    Emoji { emoji: "🍰", name: "shortcake", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["cake"]), variations: &[] },
    Emoji { emoji: "🧁", name: "cupcake", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["cupcake"]), variations: &[] },
    Emoji { emoji: "🥧", name: "pie", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["pie"]), variations: &[] },
    Emoji { emoji: "🍫", name: "chocolate bar", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["chocolate_bar"]), variations: &[] },
    Emoji { emoji: "🍬", name: "candy", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["candy"]), variations: &[] },
    Emoji { emoji: "🍭", name: "lollipop", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["lollipop"]), variations: &[] },
    Emoji { emoji: "🍮", name: "custard", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["custard"]), variations: &[] },
    Emoji { emoji: "🍯", name: "honey pot", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["honey_pot"]), variations: &[] },
    Emoji { emoji: "🍼", name: "baby bottle", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["baby_bottle"]), variations: &[] },
    Emoji { emoji: "🥛", name: "glass of milk", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["milk_glass"]), variations: &[] },
    Emoji { emoji: "☕", name: "hot beverage", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["coffee"]), variations: &[] },
    Emoji { emoji: "🫖", name: "teapot", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["teapot"]), variations: &[] },
    Emoji { emoji: "🍵", name: "teacup without handle", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["tea"]), variations: &[] },
    Emoji { emoji: "🍶", name: "sake", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["sake"]), variations: &[] },
    Emoji { emoji: "🍾", name: "bottle with popping cork", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["champagne"]), variations: &[] },
    Emoji { emoji: "🍷", name: "wine glass", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["wine_glass"]), variations: &[] },
    Emoji { emoji: "🍸", name: "cocktail glass", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["cocktail"]), variations: &[] },
    Emoji { emoji: "🍹", name: "tropical drink", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["tropical_drink"]), variations: &[] },
    Emoji { emoji: "🍺", name: "beer mug", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["beer"]), variations: &[] },
    Emoji { emoji: "🍻", name: "clinking beer mugs", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["beers"]), variations: &[] },
    Emoji { emoji: "🥂", name: "clinking glasses", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["clinking_glasses"]), variations: &[] },
    Emoji { emoji: "🥃", name: "tumbler glass", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["tumbler_glass"]), variations: &[] },
    Emoji { emoji: "🫗", name: "pouring liquid", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, aliases: None, variations: &[] },
    Emoji { emoji: "🥤", name: "cup with straw", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["cup_with_straw"]), variations: &[] },
    Emoji { emoji: "🧋", name: "bubble tea", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["bubble_tea"]), variations: &[] },
    Emoji { emoji: "🧃", name: "beverage box", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["beverage_box"]), variations: &[] },
    Emoji { emoji: "🧉", name: "mate", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["mate"]), variations: &[] },
    Emoji { emoji: "🧊", name: "ice", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["ice_cube"]), variations: &[] },
    Emoji { emoji: "🥢", name: "chopsticks", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["chopsticks"]), variations: &[] },
    Emoji { emoji: "🍽️", name: "fork and knife with plate", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["plate_with_cutlery"]), variations: &["🍽"] },
    Emoji { emoji: "🍴", name: "fork and knife", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["fork_and_knife"]), variations: &[] },
    Emoji { emoji: "🥄", name: "spoon", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["spoon"]), variations: &[] },
    Emoji { emoji: "🔪", name: "kitchen knife", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["hocho", "knife"]), variations: &[] },
    Emoji { emoji: "🫙", name: "jar", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, aliases: None, variations: &[] },
    Emoji { emoji: "🏺", name: "amphora", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["amphora"]), variations: &[] },
    Emoji { emoji: "🌍", name: "globe showing Europe-Africa", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["earth_africa"]), variations: &[] },
    Emoji { emoji: "🌎", name: "globe showing Americas", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["earth_americas"]), variations: &[] },
    Emoji { emoji: "🌏", name: "globe showing Asia-Australia", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["earth_asia"]), variations: &[] },
    Emoji { emoji: "🌐", name: "globe with meridians", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["globe_with_meridians"]), variations: &[] },
    Emoji { emoji: "🗺️", name: "world map", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["world_map"]), variations: &["🗺"] },
    Emoji { emoji: "🗾", name: "map of Japan", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["japan"]), variations: &[] },
    Emoji { emoji: "🧭", name: "compass", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["compass"]), variations: &[] },
    Emoji { emoji: "🏔️", name: "snow-capped mountain", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["mountain_snow"]), variations: &["🏔"] },
    Emoji { emoji: "⛰️", name: "mountain", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["mountain"]), variations: &["⛰"] },
    Emoji { emoji: "🌋", name: "volcano", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["volcano"]), variations: &[] },
    Emoji { emoji: "🗻", name: "mount fuji", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["mount_fuji"]), variations: &[] },
    Emoji { emoji: "🏕️", name: "camping", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["camping"]), variations: &["🏕"] },
    Emoji { emoji: "🏖️", name: "beach with umbrella", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["beach_umbrella"]), variations: &["🏖"] },
    Emoji { emoji: "🏜️", name: "desert", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["desert"]), variations: &["🏜"] },
    Emoji { emoji: "🏝️", name: "desert island", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["desert_island"]), variations: &["🏝"] },
    Emoji { emoji: "🏞️", name: "national park", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["national_park"]), variations: &["🏞"] },
    Emoji { emoji: "🏟️", name: "stadium", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["stadium"]), variations: &["🏟"] },
    Emoji { emoji: "🏛️", name: "classical building", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["classical_building"]), variations: &["🏛"] },
    Emoji { emoji: "🏗️", name: "building construction", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["building_construction"]), variations: &["🏗"] },
    Emoji { emoji: "🧱", name: "brick", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["bricks"]), variations: &[] },
    Emoji { emoji: "🪨", name: "rock", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["rock"]), variations: &[] },
    Emoji { emoji: "🪵", name: "wood", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["wood"]), variations: &[] },
    Emoji { emoji: "🛖", name: "hut", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["hut"]), variations: &[] },
    Emoji { emoji: "🏘️", name: "houses", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["houses"]), variations: &["🏘"] },
    Emoji { emoji: "🏚️", name: "derelict house", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["derelict_house"]), variations: &["🏚"] },
    Emoji { emoji: "🏠", name: "house", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["house"]), variations: &[] },
    Emoji { emoji: "🏡", name: "house with garden", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["house_with_garden"]), variations: &[] },
    Emoji { emoji: "🏢", name: "office building", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["office"]), variations: &[] },
    Emoji { emoji: "🏣", name: "Japanese post office", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["post_office"]), variations: &[] },
    Emoji { emoji: "🏤", name: "post office", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["european_post_office"]), variations: &[] },
    Emoji { emoji: "🏥", name: "hospital", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["hospital"]), variations: &[] },
    Emoji { emoji: "🏦", name: "bank", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["bank"]), variations: &[] },
    Emoji { emoji: "🏨", name: "hotel", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["hotel"]), variations: &[] },
    Emoji { emoji: "🏩", name: "love hotel", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["love_hotel"]), variations: &[] },
    Emoji { emoji: "🏪", name: "convenience store", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["convenience_store"]), variations: &[] },
    Emoji { emoji: "🏫", name: "school", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["school"]), variations: &[] },
    Emoji { emoji: "🏬", name: "department store", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["department_store"]), variations: &[] },
    Emoji { emoji: "🏭", name: "factory", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["factory"]), variations: &[] },
    Emoji { emoji: "🏯", name: "Japanese castle", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["japanese_castle"]), variations: &[] },
    Emoji { emoji: "🏰", name: "castle", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["european_castle"]), variations: &[] },
    Emoji { emoji: "💒", name: "wedding", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["wedding"]), variations: &[] },
    Emoji { emoji: "🗼", name: "Tokyo tower", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["tokyo_tower"]), variations: &[] },
    Emoji { emoji: "🗽", name: "Statue of Liberty", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["statue_of_liberty"]), variations: &[] },
    Emoji { emoji: "⛪", name: "church", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["church"]), variations: &[] },
    Emoji { emoji: "🕌", name: "mosque", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["mosque"]), variations: &[] },
    Emoji { emoji: "🛕", name: "hindu temple", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["hindu_temple"]), variations: &[] },
    Emoji { emoji: "🕍", name: "synagogue", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["synagogue"]), variations: &[] },
    Emoji { emoji: "⛩️", name: "shinto shrine", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["shinto_shrine"]), variations: &["⛩"] },
    Emoji { emoji: "🕋", name: "kaaba", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["kaaba"]), variations: &[] },
    Emoji { emoji: "⛲", name: "fountain", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["fountain"]), variations: &[] },
    Emoji { emoji: "⛺", name: "tent", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["tent"]), variations: &[] },
    Emoji { emoji: "🌁", name: "foggy", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["foggy"]), variations: &[] },
    Emoji { emoji: "🌃", name: "night with stars", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["night_with_stars"]), variations: &[] },
    Emoji { emoji: "🏙️", name: "cityscape", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["cityscape"]), variations: &["🏙"] },
    Emoji { emoji: "🌄", name: "sunrise over mountains", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["sunrise_over_mountains"]), variations: &[] },
    Emoji { emoji: "🌅", name: "sunrise", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["sunrise"]), variations: &[] },
    Emoji { emoji: "🌆", name: "cityscape at dusk", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["city_sunset"]), variations: &[] },
    Emoji { emoji: "🌇", name: "sunset", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["city_sunrise"]), variations: &[] },
    Emoji { emoji: "🌉", name: "bridge at night", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["bridge_at_night"]), variations: &[] },
    Emoji { emoji: "♨️", name: "hot springs", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["hotsprings"]), variations: &["♨"] },
    Emoji { emoji: "🎠", name: "carousel horse", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["carousel_horse"]), variations: &[] },
    Emoji { emoji: "🛝", name: "playground slide", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: None, variations: &[] },
    Emoji { emoji: "🎡", name: "ferris wheel", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["ferris_wheel"]), variations: &[] },
    Emoji { emoji: "🎢", name: "roller coaster", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["roller_coaster"]), variations: &[] },
    Emoji { emoji: "💈", name: "barber pole", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["barber"]), variations: &[] },
    Emoji { emoji: "🎪", name: "circus tent", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["circus_tent"]), variations: &[] },
    Emoji { emoji: "🚂", name: "locomotive", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["steam_locomotive"]), variations: &[] },
    Emoji { emoji: "🚃", name: "railway car", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["railway_car"]), variations: &[] },
    Emoji { emoji: "🚄", name: "high-speed train", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["bullettrain_side"]), variations: &[] },
    Emoji { emoji: "🚅", name: "bullet train", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["bullettrain_front"]), variations: &[] },
    Emoji { emoji: "🚆", name: "train", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["train2"]), variations: &[] },
    Emoji { emoji: "🚇", name: "metro", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["metro"]), variations: &[] },
    Emoji { emoji: "🚈", name: "light rail", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["light_rail"]), variations: &[] },
    Emoji { emoji: "🚉", name: "station", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["station"]), variations: &[] },
    Emoji { emoji: "🚊", name: "tram", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["tram"]), variations: &[] },
    Emoji { emoji: "🚝", name: "monorail", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["monorail"]), variations: &[] },
    Emoji { emoji: "🚞", name: "mountain railway", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["mountain_railway"]), variations: &[] },
    Emoji { emoji: "🚋", name: "tram car", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["train"]), variations: &[] },
    Emoji { emoji: "🚌", name: "bus", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["bus"]), variations: &[] },
    Emoji { emoji: "🚍", name: "oncoming bus", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["oncoming_bus"]), variations: &[] },
    Emoji { emoji: "🚎", name: "trolleybus", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["trolleybus"]), variations: &[] },
    Emoji { emoji: "🚐", name: "minibus", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["minibus"]), variations: &[] },
    Emoji { emoji: "🚑", name: "ambulance", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["ambulance"]), variations: &[] },
    Emoji { emoji: "🚒", name: "fire engine", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["fire_engine"]), variations: &[] },
    Emoji { emoji: "🚓", name: "police car", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["police_car"]), variations: &[] },
    Emoji { emoji: "🚔", name: "oncoming police car", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["oncoming_police_car"]), variations: &[] },
    Emoji { emoji: "🚕", name: "taxi", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["taxi"]), variations: &[] },
    Emoji { emoji: "🚖", name: "oncoming taxi", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["oncoming_taxi"]), variations: &[] },
    Emoji { emoji: "🚗", name: "automobile", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["car", "red_car"]), variations: &[] },
    Emoji { emoji: "🚘", name: "oncoming automobile", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["oncoming_automobile"]), variations: &[] },
    Emoji { emoji: "🚙", name: "sport utility vehicle", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["blue_car"]), variations: &[] },
    Emoji { emoji: "🛻", name: "pickup truck", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["pickup_truck"]), variations: &[] },
    Emoji { emoji: "🚚", name: "delivery truck", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["truck"]), variations: &[] },
    Emoji { emoji: "🚛", name: "articulated lorry", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["articulated_lorry"]), variations: &[] },
    Emoji { emoji: "🚜", name: "tractor", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["tractor"]), variations: &[] },
    Emoji { emoji: "🏎️", name: "racing car", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["racing_car"]), variations: &["🏎"] },
    Emoji { emoji: "🏍️", name: "motorcycle", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["motorcycle"]), variations: &["🏍"] },
    Emoji { emoji: "🛵", name: "motor scooter", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["motor_scooter"]), variations: &[] },
    Emoji { emoji: "🦽", name: "manual wheelchair", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["manual_wheelchair"]), variations: &[] },
    Emoji { emoji: "🦼", name: "motorized wheelchair", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["motorized_wheelchair"]), variations: &[] },
    Emoji { emoji: "🛺", name: "auto rickshaw", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["auto_rickshaw"]), variations: &[] },
    Emoji { emoji: "🚲", name: "bicycle", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["bike"]), variations: &[] },
    Emoji { emoji: "🛴", name: "kick scooter", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["kick_scooter"]), variations: &[] },
    Emoji { emoji: "🛹", name: "skateboard", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["skateboard"]), variations: &[] },
    Emoji { emoji: "🛼", name: "roller skate", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["roller_skate"]), variations: &[] },
    Emoji { emoji: "🚏", name: "bus stop", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["busstop"]), variations: &[] },
    Emoji { emoji: "🛣️", name: "motorway", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["motorway"]), variations: &["🛣"] },
    Emoji { emoji: "🛤️", name: "railway track", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["railway_track"]), variations: &["🛤"] },
    Emoji { emoji: "🛢️", name: "oil drum", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["oil_drum"]), variations: &["🛢"] },
    Emoji { emoji: "⛽", name: "fuel pump", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["fuelpump"]), variations: &[] },
    Emoji { emoji: "🛞", name: "wheel", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: None, variations: &[] },
    Emoji { emoji: "🚨", name: "police car light", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["rotating_light"]), variations: &[] },
    Emoji { emoji: "🚥", name: "horizontal traffic light", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["traffic_light"]), variations: &[] },
    Emoji { emoji: "🚦", name: "vertical traffic light", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["vertical_traffic_light"]), variations: &[] },
    Emoji { emoji: "🛑", name: "stop sign", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["stop_sign"]), variations: &[] },
    Emoji { emoji: "🚧", name: "construction", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["construction"]), variations: &[] },
    Emoji { emoji: "⚓", name: "anchor", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["anchor"]), variations: &[] },
    Emoji { emoji: "🛟", name: "ring buoy", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: None, variations: &[] },
    Emoji { emoji: "⛵", name: "sailboat", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["boat", "sailboat"]), variations: &[] },
    Emoji { emoji: "🛶", name: "canoe", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["canoe"]), variations: &[] },
    Emoji { emoji: "🚤", name: "speedboat", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["speedboat"]), variations: &[] },
    Emoji { emoji: "🛳️", name: "passenger ship", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["passenger_ship"]), variations: &["🛳"] },
    Emoji { emoji: "⛴️", name: "ferry", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["ferry"]), variations: &["⛴"] },
    Emoji { emoji: "🛥️", name: "motor boat", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["motor_boat"]), variations: &["🛥"] },
    Emoji { emoji: "🚢", name: "ship", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["ship"]), variations: &[] },
    Emoji { emoji: "✈️", name: "airplane", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["airplane"]), variations: &["✈"] },
    Emoji { emoji: "🛩️", name: "small airplane", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["small_airplane"]), variations: &["🛩"] },
    Emoji { emoji: "🛫", name: "airplane departure", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["flight_departure"]), variations: &[] },
    Emoji { emoji: "🛬", name: "airplane arrival", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["flight_arrival"]), variations: &[] },
    Emoji { emoji: "🪂", name: "parachute", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["parachute"]), variations: &[] },
    Emoji { emoji: "💺", name: "seat", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["seat"]), variations: &[] },
    Emoji { emoji: "🚁", name: "helicopter", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["helicopter"]), variations: &[] },
    Emoji { emoji: "🚟", name: "suspension railway", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["suspension_railway"]), variations: &[] },
    Emoji { emoji: "🚠", name: "mountain cableway", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["mountain_cableway"]), variations: &[] },
    Emoji { emoji: "🚡", name: "aerial tramway", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["aerial_tramway"]), variations: &[] },
    Emoji { emoji: "🛰️", name: "satellite", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["artificial_satellite"]), variations: &["🛰"] },
    Emoji { emoji: "🚀", name: "rocket", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["rocket"]), variations: &[] },
    Emoji { emoji: "🛸", name: "flying saucer", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["flying_saucer"]), variations: &[] },
    Emoji { emoji: "🛎️", name: "bellhop bell", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["bellhop_bell"]), variations: &["🛎"] },
    Emoji { emoji: "🧳", name: "luggage", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["luggage"]), variations: &[] },
    Emoji { emoji: "⌛", name: "hourglass done", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["hourglass"]), variations: &[] },
    Emoji { emoji: "⏳", name: "hourglass not done", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["hourglass_flowing_sand"]), variations: &[] },
    Emoji { emoji: "⌚", name: "watch", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["watch"]), variations: &[] },
    Emoji { emoji: "⏰", name: "alarm clock", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["alarm_clock"]), variations: &[] },
    Emoji { emoji: "⏱️", name: "stopwatch", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["stopwatch"]), variations: &["⏱"] },
    Emoji { emoji: "⏲️", name: "timer clock", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["timer_clock"]), variations: &["⏲"] },
    Emoji { emoji: "🕰️", name: "mantelpiece clock", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["mantelpiece_clock"]), variations: &["🕰"] },
    Emoji { emoji: "🕛", name: "twelve o’clock", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["clock12"]), variations: &[] },
    Emoji { emoji: "🕧", name: "twelve-thirty", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["clock1230"]), variations: &[] },
    Emoji { emoji: "🕐", name: "one o’clock", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["clock1"]), variations: &[] },
    Emoji { emoji: "🕜", name: "one-thirty", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["clock130"]), variations: &[] },
    Emoji { emoji: "🕑", name: "two o’clock", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["clock2"]), variations: &[] },
    Emoji { emoji: "🕝", name: "two-thirty", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["clock230"]), variations: &[] },
    Emoji { emoji: "🕒", name: "three o’clock", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["clock3"]), variations: &[] },
    Emoji { emoji: "🕞", name: "three-thirty", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["clock330"]), variations: &[] },
    Emoji { emoji: "🕓", name: "four o’clock", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["clock4"]), variations: &[] },
    Emoji { emoji: "🕟", name: "four-thirty", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["clock430"]), variations: &[] },
    Emoji { emoji: "🕔", name: "five o’clock", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["clock5"]), variations: &[] },
    Emoji { emoji: "🕠", name: "five-thirty", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["clock530"]), variations: &[] },
    Emoji { emoji: "🕕", name: "six o’clock", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["clock6"]), variations: &[] },
    Emoji { emoji: "🕡", name: "six-thirty", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["clock630"]), variations: &[] },
    Emoji { emoji: "🕖", name: "seven o’clock", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["clock7"]), variations: &[] },
    Emoji { emoji: "🕢", name: "seven-thirty", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["clock730"]), variations: &[] },
    Emoji { emoji: "🕗", name: "eight o’clock", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["clock8"]), variations: &[] },
    Emoji { emoji: "🕣", name: "eight-thirty", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["clock830"]), variations: &[] },
    Emoji { emoji: "🕘", name: "nine o’clock", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["clock9"]), variations: &[] },
    Emoji { emoji: "🕤", name: "nine-thirty", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["clock930"]), variations: &[] },
    Emoji { emoji: "🕙", name: "ten o’clock", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["clock10"]), variations: &[] },
    Emoji { emoji: "🕥", name: "ten-thirty", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["clock1030"]), variations: &[] },
    Emoji { emoji: "🕚", name: "eleven o’clock", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["clock11"]), variations: &[] },
    Emoji { emoji: "🕦", name: "eleven-thirty", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["clock1130"]), variations: &[] },
    Emoji { emoji: "🌑", name: "new moon", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["new_moon"]), variations: &[] },
    Emoji { emoji: "🌒", name: "waxing crescent moon", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["waxing_crescent_moon"]), variations: &[] },
    Emoji { emoji: "🌓", name: "first quarter moon", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["first_quarter_moon"]), variations: &[] },
    Emoji { emoji: "🌔", name: "waxing gibbous moon", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["moon", "waxing_gibbous_moon"]), variations: &[] },
    Emoji { emoji: "🌕", name: "full moon", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["full_moon"]), variations: &[] },
    Emoji { emoji: "🌖", name: "waning gibbous moon", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["waning_gibbous_moon"]), variations: &[] },
    Emoji { emoji: "🌗", name: "last quarter moon", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["last_quarter_moon"]), variations: &[] },
    Emoji { emoji: "🌘", name: "waning crescent moon", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["waning_crescent_moon"]), variations: &[] },
    Emoji { emoji: "🌙", name: "crescent moon", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["crescent_moon"]), variations: &[] },
    Emoji { emoji: "🌚", name: "new moon face", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["new_moon_with_face"]), variations: &[] },
    Emoji { emoji: "🌛", name: "first quarter moon face", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["first_quarter_moon_with_face"]), variations: &[] },
    Emoji { emoji: "🌜", name: "last quarter moon face", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["last_quarter_moon_with_face"]), variations: &[] },
    Emoji { emoji: "🌡️", name: "thermometer", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["thermometer"]), variations: &["🌡"] },
    Emoji { emoji: "☀️", name: "sun", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["sunny"]), variations: &["☀"] },
    Emoji { emoji: "🌝", name: "full moon face", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["full_moon_with_face"]), variations: &[] },
    Emoji { emoji: "🌞", name: "sun with face", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["sun_with_face"]), variations: &[] },
    Emoji { emoji: "🪐", name: "ringed planet", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["ringed_planet"]), variations: &[] },
    Emoji { emoji: "⭐", name: "star", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["star"]), variations: &[] },
    Emoji { emoji: "🌟", name: "glowing star", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["star2"]), variations: &[] },
    Emoji { emoji: "🌠", name: "shooting star", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["stars"]), variations: &[] },
    Emoji { emoji: "🌌", name: "milky way", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["milky_way"]), variations: &[] },
    Emoji { emoji: "☁️", name: "cloud", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["cloud"]), variations: &["☁"] },
    Emoji { emoji: "⛅", name: "sun behind cloud", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["partly_sunny"]), variations: &[] },
    Emoji { emoji: "⛈️", name: "cloud with lightning and rain", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["cloud_with_lightning_and_rain"]), variations: &["⛈"] },
    Emoji { emoji: "🌤️", name: "sun behind small cloud", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["sun_behind_small_cloud"]), variations: &["🌤"] },
    Emoji { emoji: "🌥️", name: "sun behind large cloud", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["sun_behind_large_cloud"]), variations: &["🌥"] },
    Emoji { emoji: "🌦️", name: "sun behind rain cloud", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["sun_behind_rain_cloud"]), variations: &["🌦"] },
    Emoji { emoji: "🌧️", name: "cloud with rain", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["cloud_with_rain"]), variations: &["🌧"] },
    Emoji { emoji: "🌨️", name: "cloud with snow", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["cloud_with_snow"]), variations: &["🌨"] },
    Emoji { emoji: "🌩️", name: "cloud with lightning", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["cloud_with_lightning"]), variations: &["🌩"] },
    Emoji { emoji: "🌪️", name: "tornado", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["tornado"]), variations: &["🌪"] },
    Emoji { emoji: "🌫️", name: "fog", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["fog"]), variations: &["🌫"] },
    Emoji { emoji: "🌬️", name: "wind face", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["wind_face"]), variations: &["🌬"] },
    Emoji { emoji: "🌀", name: "cyclone", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["cyclone"]), variations: &[] },
    Emoji { emoji: "🌈", name: "rainbow", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["rainbow"]), variations: &[] },
    Emoji { emoji: "🌂", name: "closed umbrella", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["closed_umbrella"]), variations: &[] },
    Emoji { emoji: "☂️", name: "umbrella", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["open_umbrella"]), variations: &["☂"] },
    Emoji { emoji: "☔", name: "umbrella with rain drops", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["umbrella"]), variations: &[] },
    Emoji { emoji: "⛱️", name: "umbrella on ground", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["parasol_on_ground"]), variations: &["⛱"] },
    Emoji { emoji: "⚡", name: "high voltage", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["zap"]), variations: &[] },
    Emoji { emoji: "❄️", name: "snowflake", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["snowflake"]), variations: &["❄"] },
    Emoji { emoji: "☃️", name: "snowman", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["snowman_with_snow"]), variations: &["☃"] },
    Emoji { emoji: "⛄", name: "snowman without snow", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["snowman"]), variations: &[] },
    Emoji { emoji: "☄️", name: "comet", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["comet"]), variations: &["☄"] },
    Emoji { emoji: "🔥", name: "fire", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["fire"]), variations: &[] },
    Emoji { emoji: "💧", name: "droplet", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["droplet"]), variations: &[] },
    Emoji { emoji: "🌊", name: "water wave", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["ocean"]), variations: &[] },
    Emoji { emoji: "🎃", name: "jack-o-lantern", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Activities, skin_tone: None, aliases: Some(&["jack_o_lantern"]), variations: &[] },
    Emoji { emoji: "🎄", name: "Christmas tree", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Activities, skin_tone: None, aliases: Some(&["christmas_tree"]), variations: &[] },
    Emoji { emoji: "🎆", name: "fireworks", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Activities, skin_tone: None, aliases: Some(&["fireworks"]), variations: &[] },
    Emoji { emoji: "🎇", name: "sparkler", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Activities, skin_tone: None, aliases: Some(&["sparkler"]), variations: &[] },
    Emoji { emoji: "🧨", name: "firecracker", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::Activities, skin_tone: None, aliases: Some(&["firecracker"]), variations: &[] },
    Emoji { emoji: "✨", name: "sparkles", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Activities, skin_tone: None, aliases: Some(&["sparkles"]), variations: &[] },
    Emoji { emoji: "🎈", name: "balloon", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Activities, skin_tone: None, aliases: Some(&["balloon"]), variations: &[] },
    Emoji { emoji: "🎉", name: "party popper", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Activities, skin_tone: None, aliases: Some(&["tada"]), variations: &[] },
    Emoji { emoji: "🎊", name: "confetti ball", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Activities, skin_tone: None, aliases: Some(&["confetti_ball"]), variations: &[] },
    Emoji { emoji: "🎋", name: "tanabata tree", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Activities, skin_tone: None, aliases: Some(&["tanabata_tree"]), variations: &[] },
    Emoji { emoji: "🎍", name: "pine decoration", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Activities, skin_tone: None, aliases: Some(&["bamboo"]), variations: &[] },
    Emoji { emoji: "🎎", name: "Japanese dolls", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Activities, skin_tone: None, aliases: Some(&["dolls"]), variations: &[] },
    Emoji { emoji: "🎏", name: "carp streamer", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Activities, skin_tone: None, aliases: Some(&["flags"]), variations: &[] },
    Emoji { emoji: "🎐", name: "wind chime", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Activities, skin_tone: None, aliases: Some(&["wind_chime"]), variations: &[] },
    Emoji { emoji: "🎑", name: "moon viewing ceremony", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Activities, skin_tone: None, aliases: Some(&["rice_scene"]), variations: &[] },
    Emoji { emoji: "🧧", name: "red envelope", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::Activities, skin_tone: None, aliases: Some(&["red_envelope"]), variations: &[] },
    Emoji { emoji: "🎀", name: "ribbon", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Activities, skin_tone: None, aliases: Some(&["ribbon"]), variations: &[] },
    Emoji { emoji: "🎁", name: "wrapped gift", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Activities, skin_tone: None, aliases: Some(&["gift"]), variations: &[] },
    Emoji { emoji: "🎗️", name: "reminder ribbon", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::Activities, skin_tone: None, aliases: Some(&["reminder_ribbon"]), variations: &["🎗"] },
    Emoji { emoji: "🎟️", name: "admission tickets", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::Activities, skin_tone: None, aliases: Some(&["tickets"]), variations: &["🎟"] },
    Emoji { emoji: "🎫", name: "ticket", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Activities, skin_tone: None, aliases: Some(&["ticket"]), variations: &[] },
    Emoji { emoji: "🎖️", name: "military medal", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::Activities, skin_tone: None, aliases: Some(&["medal_military"]), variations: &["🎖"] },
    Emoji { emoji: "🏆", name: "trophy", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Activities, skin_tone: None, aliases: Some(&["trophy"]), variations: &[] },
    Emoji { emoji: "🏅", name: "sports medal", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::Activities, skin_tone: None, aliases: Some(&["medal_sports"]), variations: &[] },
    Emoji { emoji: "🥇", name: "1st place medal", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::Activities, skin_tone: None, aliases: Some(&["1st_place_medal"]), variations: &[] },
    Emoji { emoji: "🥈", name: "2nd place medal", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::Activities, skin_tone: None, aliases: Some(&["2nd_place_medal"]), variations: &[] },
    Emoji { emoji: "🥉", name: "3rd place medal", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::Activities, skin_tone: None, aliases: Some(&["3rd_place_medal"]), variations: &[] },
    Emoji { emoji: "⚽", name: "soccer ball", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Activities, skin_tone: None, aliases: Some(&["soccer"]), variations: &[] },
    Emoji { emoji: "⚾", name: "baseball", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Activities, skin_tone: None, aliases: Some(&["baseball"]), variations: &[] },
    Emoji { emoji: "🥎", name: "softball", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::Activities, skin_tone: None, aliases: Some(&["softball"]), variations: &[] },
    Emoji { emoji: "🏀", name: "basketball", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Activities, skin_tone: None, aliases: Some(&["basketball"]), variations: &[] },
    Emoji { emoji: "🏐", name: "volleyball", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::Activities, skin_tone: None, aliases: Some(&["volleyball"]), variations: &[] },
    Emoji { emoji: "🏈", name: "american football", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Activities, skin_tone: None, aliases: Some(&["football"]), variations: &[] },
    Emoji { emoji: "🏉", name: "rugby football", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::Activities, skin_tone: None, aliases: Some(&["rugby_football"]), variations: &[] },
    Emoji { emoji: "🎾", name: "tennis", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Activities, skin_tone: None, aliases: Some(&["tennis"]), variations: &[] },
    Emoji { emoji: "🥏", name: "flying disc", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::Activities, skin_tone: None, aliases: Some(&["flying_disc"]), variations: &[] },
    Emoji { emoji: "🎳", name: "bowling", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Activities, skin_tone: None, aliases: Some(&["bowling"]), variations: &[] },
    Emoji { emoji: "🏏", name: "cricket game", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::Activities, skin_tone: None, aliases: Some(&["cricket_game"]), variations: &[] },
    Emoji { emoji: "🏑", name: "field hockey", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::Activities, skin_tone: None, aliases: Some(&["field_hockey"]), variations: &[] },
    Emoji { emoji: "🏒", name: "ice hockey", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::Activities, skin_tone: None, aliases: Some(&["ice_hockey"]), variations: &[] },
    Emoji { emoji: "🥍", name: "lacrosse", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::Activities, skin_tone: None, aliases: Some(&["lacrosse"]), variations: &[] },
    Emoji { emoji: "🏓", name: "ping pong", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::Activities, skin_tone: None, aliases: Some(&["ping_pong"]), variations: &[] },
    Emoji { emoji: "🏸", name: "badminton", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::Activities, skin_tone: None, aliases: Some(&["badminton"]), variations: &[] },
    Emoji { emoji: "🥊", name: "boxing glove", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::Activities, skin_tone: None, aliases: Some(&["boxing_glove"]), variations: &[] },
    Emoji { emoji: "🥋", name: "martial arts uniform", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::Activities, skin_tone: None, aliases: Some(&["martial_arts_uniform"]), variations: &[] },
    Emoji { emoji: "🥅", name: "goal net", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::Activities, skin_tone: None, aliases: Some(&["goal_net"]), variations: &[] },
    Emoji { emoji: "⛳", name: "flag in hole", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Activities, skin_tone: None, aliases: Some(&["golf"]), variations: &[] },
    Emoji { emoji: "⛸️", name: "ice skate", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::Activities, skin_tone: None, aliases: Some(&["ice_skate"]), variations: &["⛸"] },
    Emoji { emoji: "🎣", name: "fishing pole", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Activities, skin_tone: None, aliases: Some(&["fishing_pole_and_fish"]), variations: &[] },
    Emoji { emoji: "🤿", name: "diving mask", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::Activities, skin_tone: None, aliases: Some(&["diving_mask"]), variations: &[] },
    Emoji { emoji: "🎽", name: "running shirt", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Activities, skin_tone: None, aliases: Some(&["running_shirt_with_sash"]), variations: &[] },
    Emoji { emoji: "🎿", name: "skis", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Activities, skin_tone: None, aliases: Some(&["ski"]), variations: &[] },
    Emoji { emoji: "🛷", name: "sled", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::Activities, skin_tone: None, aliases: Some(&["sled"]), variations: &[] },
    Emoji { emoji: "🥌", name: "curling stone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::Activities, skin_tone: None, aliases: Some(&["curling_stone"]), variations: &[] },
    Emoji { emoji: "🎯", name: "bullseye", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Activities, skin_tone: None, aliases: Some(&["dart"]), variations: &[] },
    Emoji { emoji: "🪀", name: "yo-yo", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::Activities, skin_tone: None, aliases: Some(&["yo_yo"]), variations: &[] },
    Emoji { emoji: "🪁", name: "kite", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::Activities, skin_tone: None, aliases: Some(&["kite"]), variations: &[] },
    Emoji { emoji: "🎱", name: "pool 8 ball", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Activities, skin_tone: None, aliases: Some(&["8ball"]), variations: &[] },
    Emoji { emoji: "🔮", name: "crystal ball", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Activities, skin_tone: None, aliases: Some(&["crystal_ball"]), variations: &[] },
    Emoji { emoji: "🪄", name: "magic wand", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::Activities, skin_tone: None, aliases: Some(&["magic_wand"]), variations: &[] },
    Emoji { emoji: "🧿", name: "nazar amulet", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::Activities, skin_tone: None, aliases: Some(&["nazar_amulet"]), variations: &[] },
    Emoji { emoji: "🪬", name: "hamsa", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::Activities, skin_tone: None, aliases: None, variations: &[] },
    Emoji { emoji: "🎮", name: "video game", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Activities, skin_tone: None, aliases: Some(&["video_game"]), variations: &[] },
    Emoji { emoji: "🕹️", name: "joystick", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::Activities, skin_tone: None, aliases: Some(&["joystick"]), variations: &["🕹"] },
    Emoji { emoji: "🎰", name: "slot machine", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Activities, skin_tone: None, aliases: Some(&["slot_machine"]), variations: &[] },
    Emoji { emoji: "🎲", name: "game die", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Activities, skin_tone: None, aliases: Some(&["game_die"]), variations: &[] },
    Emoji { emoji: "🧩", name: "puzzle piece", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::Activities, skin_tone: None, aliases: Some(&["jigsaw"]), variations: &[] },
    Emoji { emoji: "🧸", name: "teddy bear", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::Activities, skin_tone: None, aliases: Some(&["teddy_bear"]), variations: &[] },
    Emoji { emoji: "🪅", name: "piñata", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::Activities, skin_tone: None, aliases: Some(&["pi_ata"]), variations: &[] },
    Emoji { emoji: "🪩", name: "mirror ball", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::Activities, skin_tone: None, aliases: None, variations: &[] },
    Emoji { emoji: "🪆", name: "nesting dolls", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::Activities, skin_tone: None, aliases: Some(&["nesting_dolls"]), variations: &[] },
    Emoji { emoji: "♠️", name: "spade suit", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Activities, skin_tone: None, aliases: Some(&["spades"]), variations: &["♠"] },
    Emoji { emoji: "♥️", name: "heart suit", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Activities, skin_tone: None, aliases: Some(&["hearts"]), variations: &["♥"] },
    Emoji { emoji: "♦️", name: "diamond suit", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Activities, skin_tone: None, aliases: Some(&["diamonds"]), variations: &["♦"] },
    Emoji { emoji: "♣️", name: "club suit", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Activities, skin_tone: None, aliases: Some(&["clubs"]), variations: &["♣"] },
    Emoji { emoji: "♟️", name: "chess pawn", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::Activities, skin_tone: None, aliases: Some(&["chess_pawn"]), variations: &["♟"] },
    Emoji { emoji: "🃏", name: "joker", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Activities, skin_tone: None, aliases: Some(&["black_joker"]), variations: &[] },
    Emoji { emoji: "🀄", name: "mahjong red dragon", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Activities, skin_tone: None, aliases: Some(&["mahjong"]), variations: &[] },
    Emoji { emoji: "🎴", name: "flower playing cards", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Activities, skin_tone: None, aliases: Some(&["flower_playing_cards"]), variations: &[] },
    Emoji { emoji: "🎭", name: "performing arts", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Activities, skin_tone: None, aliases: Some(&["performing_arts"]), variations: &[] },
    Emoji { emoji: "🖼️", name: "framed picture", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::Activities, skin_tone: None, aliases: Some(&["framed_picture"]), variations: &["🖼"] },
    Emoji { emoji: "🎨", name: "artist palette", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Activities, skin_tone: None, aliases: Some(&["art"]), variations: &[] },
    Emoji { emoji: "🧵", name: "thread", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::Activities, skin_tone: None, aliases: Some(&["thread"]), variations: &[] },
    Emoji { emoji: "🪡", name: "sewing needle", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::Activities, skin_tone: None, aliases: Some(&["sewing_needle"]), variations: &[] },
    Emoji { emoji: "🧶", name: "yarn", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::Activities, skin_tone: None, aliases: Some(&["yarn"]), variations: &[] },
    Emoji { emoji: "🪢", name: "knot", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::Activities, skin_tone: None, aliases: Some(&["knot"]), variations: &[] },
    Emoji { emoji: "👓", name: "glasses", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["eyeglasses"]), variations: &[] },
    Emoji { emoji: "🕶️", name: "sunglasses", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::Objects, skin_tone: None, aliases: Some(&["dark_sunglasses"]), variations: &["🕶"] },
    Emoji { emoji: "🥽", name: "goggles", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::Objects, skin_tone: None, aliases: Some(&["goggles"]), variations: &[] },
    Emoji { emoji: "🥼", name: "lab coat", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::Objects, skin_tone: None, aliases: Some(&["lab_coat"]), variations: &[] },
    Emoji { emoji: "🦺", name: "safety vest", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::Objects, skin_tone: None, aliases: Some(&["safety_vest"]), variations: &[] },
    Emoji { emoji: "👔", name: "necktie", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["necktie"]), variations: &[] },
    Emoji { emoji: "👕", name: "t-shirt", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["shirt", "tshirt"]), variations: &[] },
    Emoji { emoji: "👖", name: "jeans", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["jeans"]), variations: &[] },
    Emoji { emoji: "🧣", name: "scarf", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::Objects, skin_tone: None, aliases: Some(&["scarf"]), variations: &[] },
    Emoji { emoji: "🧤", name: "gloves", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::Objects, skin_tone: None, aliases: Some(&["gloves"]), variations: &[] },
    Emoji { emoji: "🧥", name: "coat", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::Objects, skin_tone: None, aliases: Some(&["coat"]), variations: &[] },
    Emoji { emoji: "🧦", name: "socks", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::Objects, skin_tone: None, aliases: Some(&["socks"]), variations: &[] },
    Emoji { emoji: "👗", name: "dress", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["dress"]), variations: &[] },
    Emoji { emoji: "👘", name: "kimono", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["kimono"]), variations: &[] },
    Emoji { emoji: "🥻", name: "sari", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::Objects, skin_tone: None, aliases: Some(&["sari"]), variations: &[] },
    Emoji { emoji: "🩱", name: "one-piece swimsuit", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::Objects, skin_tone: None, aliases: Some(&["one_piece_swimsuit"]), variations: &[] },
    Emoji { emoji: "🩲", name: "briefs", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::Objects, skin_tone: None, aliases: Some(&["swim_brief"]), variations: &[] },
    Emoji { emoji: "🩳", name: "shorts", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::Objects, skin_tone: None, aliases: Some(&["shorts"]), variations: &[] },
    Emoji { emoji: "👙", name: "bikini", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["bikini"]), variations: &[] },
    Emoji { emoji: "👚", name: "woman’s clothes", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["womans_clothes"]), variations: &[] },
    Emoji { emoji: "👛", name: "purse", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["purse"]), variations: &[] },
    Emoji { emoji: "👜", name: "handbag", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["handbag"]), variations: &[] },
    Emoji { emoji: "👝", name: "clutch bag", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["pouch"]), variations: &[] },
    Emoji { emoji: "🛍️", name: "shopping bags", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::Objects, skin_tone: None, aliases: Some(&["shopping"]), variations: &["🛍"] },
    Emoji { emoji: "🎒", name: "backpack", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["school_satchel"]), variations: &[] },
    Emoji { emoji: "🩴", name: "thong sandal", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::Objects, skin_tone: None, aliases: Some(&["thong_sandal"]), variations: &[] },
    Emoji { emoji: "👞", name: "man’s shoe", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["mans_shoe", "shoe"]), variations: &[] },
    Emoji { emoji: "👟", name: "running shoe", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["athletic_shoe"]), variations: &[] },
    Emoji { emoji: "🥾", name: "hiking boot", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::Objects, skin_tone: None, aliases: Some(&["hiking_boot"]), variations: &[] },
    Emoji { emoji: "🥿", name: "flat shoe", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::Objects, skin_tone: None, aliases: Some(&["flat_shoe"]), variations: &[] },
    Emoji { emoji: "👠", name: "high-heeled shoe", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["high_heel"]), variations: &[] },
    Emoji { emoji: "👡", name: "woman’s sandal", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["sandal"]), variations: &[] },
    Emoji { emoji: "🩰", name: "ballet shoes", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::Objects, skin_tone: None, aliases: Some(&["ballet_shoes"]), variations: &[] },
    Emoji { emoji: "👢", name: "woman’s boot", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["boot"]), variations: &[] },
    Emoji { emoji: "👑", name: "crown", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["crown"]), variations: &[] },
    Emoji { emoji: "👒", name: "woman’s hat", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["womans_hat"]), variations: &[] },
    Emoji { emoji: "🎩", name: "top hat", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["tophat"]), variations: &[] },
    Emoji { emoji: "🎓", name: "graduation cap", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["mortar_board"]), variations: &[] },
    Emoji { emoji: "🧢", name: "billed cap", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::Objects, skin_tone: None, aliases: Some(&["billed_cap"]), variations: &[] },
    Emoji { emoji: "🪖", name: "military helmet", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::Objects, skin_tone: None, aliases: Some(&["military_helmet"]), variations: &[] },
    Emoji { emoji: "⛑️", name: "rescue worker’s helmet", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::Objects, skin_tone: None, aliases: Some(&["rescue_worker_helmet"]), variations: &["⛑"] },
    Emoji { emoji: "📿", name: "prayer beads", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::Objects, skin_tone: None, aliases: Some(&["prayer_beads"]), variations: &[] },
    Emoji { emoji: "💄", name: "lipstick", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["lipstick"]), variations: &[] },
    Emoji { emoji: "💍", name: "ring", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["ring"]), variations: &[] },
    Emoji { emoji: "💎", name: "gem stone", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["gem"]), variations: &[] },
    Emoji { emoji: "🔇", name: "muted speaker", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::Objects, skin_tone: None, aliases: Some(&["mute"]), variations: &[] },
    Emoji { emoji: "🔈", name: "speaker low volume", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::Objects, skin_tone: None, aliases: Some(&["speaker"]), variations: &[] },
    Emoji { emoji: "🔉", name: "speaker medium volume", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::Objects, skin_tone: None, aliases: Some(&["sound"]), variations: &[] },
    Emoji { emoji: "🔊", name: "speaker high volume", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["loud_sound"]), variations: &[] },
    Emoji { emoji: "📢", name: "loudspeaker", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["loudspeaker"]), variations: &[] },
    Emoji { emoji: "📣", name: "megaphone", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["mega"]), variations: &[] },
    Emoji { emoji: "📯", name: "postal horn", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::Objects, skin_tone: None, aliases: Some(&["postal_horn"]), variations: &[] },
    Emoji { emoji: "🔔", name: "bell", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["bell"]), variations: &[] },
    Emoji { emoji: "🔕", name: "bell with slash", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::Objects, skin_tone: None, aliases: Some(&["no_bell"]), variations: &[] },
    Emoji { emoji: "🎼", name: "musical score", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["musical_score"]), variations: &[] },
    Emoji { emoji: "🎵", name: "musical note", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["musical_note"]), variations: &[] },
    Emoji { emoji: "🎶", name: "musical notes", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["notes"]), variations: &[] },
    Emoji { emoji: "🎙️", name: "studio microphone", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::Objects, skin_tone: None, aliases: Some(&["studio_microphone"]), variations: &["🎙"] },
    Emoji { emoji: "🎚️", name: "level slider", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::Objects, skin_tone: None, aliases: Some(&["level_slider"]), variations: &["🎚"] },
    Emoji { emoji: "🎛️", name: "control knobs", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::Objects, skin_tone: None, aliases: Some(&["control_knobs"]), variations: &["🎛"] },
    Emoji { emoji: "🎤", name: "microphone", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["microphone"]), variations: &[] },
    Emoji { emoji: "🎧", name: "headphone", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["headphones"]), variations: &[] },
    Emoji { emoji: "📻", name: "radio", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["radio"]), variations: &[] },
    Emoji { emoji: "🎷", name: "saxophone", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["saxophone"]), variations: &[] },
    Emoji { emoji: "🪗", name: "accordion", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::Objects, skin_tone: None, aliases: Some(&["accordion"]), variations: &[] },
    Emoji { emoji: "🎸", name: "guitar", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["guitar"]), variations: &[] },
    Emoji { emoji: "🎹", name: "musical keyboard", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["musical_keyboard"]), variations: &[] },
    Emoji { emoji: "🎺", name: "trumpet", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["trumpet"]), variations: &[] },
    Emoji { emoji: "🎻", name: "violin", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["violin"]), variations: &[] },
    Emoji { emoji: "🪕", name: "banjo", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::Objects, skin_tone: None, aliases: Some(&["banjo"]), variations: &[] },
    Emoji { emoji: "🥁", name: "drum", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::Objects, skin_tone: None, aliases: Some(&["drum"]), variations: &[] },
    Emoji { emoji: "🪘", name: "long drum", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::Objects, skin_tone: None, aliases: Some(&["long_drum"]), variations: &[] },
    Emoji { emoji: "📱", name: "mobile phone", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["iphone"]), variations: &[] },
    Emoji { emoji: "📲", name: "mobile phone with arrow", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["calling"]), variations: &[] },
    Emoji { emoji: "☎️", name: "telephone", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["phone", "telephone"]), variations: &["☎"] },
    Emoji { emoji: "📞", name: "telephone receiver", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["telephone_receiver"]), variations: &[] },
    Emoji { emoji: "📟", name: "pager", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["pager"]), variations: &[] },
    Emoji { emoji: "📠", name: "fax machine", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["fax"]), variations: &[] },
    Emoji { emoji: "🔋", name: "battery", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["battery"]), variations: &[] },
    Emoji { emoji: "🪫", name: "low battery", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::Objects, skin_tone: None, aliases: None, variations: &[] },
    Emoji { emoji: "🔌", name: "electric plug", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["electric_plug"]), variations: &[] },
    Emoji { emoji: "💻", name: "laptop", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["computer"]), variations: &[] },
    Emoji { emoji: "🖥️", name: "desktop computer", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::Objects, skin_tone: None, aliases: Some(&["desktop_computer"]), variations: &["🖥"] },
    Emoji { emoji: "🖨️", name: "printer", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::Objects, skin_tone: None, aliases: Some(&["printer"]), variations: &["🖨"] },
    Emoji { emoji: "⌨️", name: "keyboard", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::Objects, skin_tone: None, aliases: Some(&["keyboard"]), variations: &["⌨"] },
    Emoji { emoji: "🖱️", name: "computer mouse", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::Objects, skin_tone: None, aliases: Some(&["computer_mouse"]), variations: &["🖱"] },
    Emoji { emoji: "🖲️", name: "trackball", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::Objects, skin_tone: None, aliases: Some(&["trackball"]), variations: &["🖲"] },
    Emoji { emoji: "💽", name: "computer disk", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["minidisc"]), variations: &[] },
    Emoji { emoji: "💾", name: "floppy disk", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["floppy_disk"]), variations: &[] },
    Emoji { emoji: "💿", name: "optical disk", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["cd"]), variations: &[] },
    Emoji { emoji: "📀", name: "dvd", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["dvd"]), variations: &[] },
    Emoji { emoji: "🧮", name: "abacus", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::Objects, skin_tone: None, aliases: Some(&["abacus"]), variations: &[] },
    Emoji { emoji: "🎥", name: "movie camera", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["movie_camera"]), variations: &[] },
    Emoji { emoji: "🎞️", name: "film frames", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::Objects, skin_tone: None, aliases: Some(&["film_strip"]), variations: &["🎞"] },
    Emoji { emoji: "📽️", name: "film projector", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::Objects, skin_tone: None, aliases: Some(&["film_projector"]), variations: &["📽"] },
    Emoji { emoji: "🎬", name: "clapper board", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["clapper"]), variations: &[] },
    Emoji { emoji: "📺", name: "television", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["tv"]), variations: &[] },
    Emoji { emoji: "📷", name: "camera", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["camera"]), variations: &[] },
    Emoji { emoji: "📸", name: "camera with flash", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::Objects, skin_tone: None, aliases: Some(&["camera_flash"]), variations: &[] },
    Emoji { emoji: "📹", name: "video camera", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["video_camera"]), variations: &[] },
    Emoji { emoji: "📼", name: "videocassette", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["vhs"]), variations: &[] },
    Emoji { emoji: "🔍", name: "magnifying glass tilted left", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["mag"]), variations: &[] },
    Emoji { emoji: "🔎", name: "magnifying glass tilted right", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["mag_right"]), variations: &[] },
    Emoji { emoji: "🕯️", name: "candle", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::Objects, skin_tone: None, aliases: Some(&["candle"]), variations: &["🕯"] },
    Emoji { emoji: "💡", name: "light bulb", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["bulb"]), variations: &[] },
    Emoji { emoji: "🔦", name: "flashlight", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["flashlight"]), variations: &[] },
    Emoji { emoji: "🏮", name: "red paper lantern", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["izakaya_lantern", "lantern"]), variations: &[] },
    Emoji { emoji: "🪔", name: "diya lamp", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::Objects, skin_tone: None, aliases: Some(&["diya_lamp"]), variations: &[] },
    Emoji { emoji: "📔", name: "notebook with decorative cover", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["notebook_with_decorative_cover"]), variations: &[] },
    Emoji { emoji: "📕", name: "closed book", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["closed_book"]), variations: &[] },
    Emoji { emoji: "📖", name: "open book", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["book", "open_book"]), variations: &[] },
    Emoji { emoji: "📗", name: "green book", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["green_book"]), variations: &[] },
    Emoji { emoji: "📘", name: "blue book", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["blue_book"]), variations: &[] },
    Emoji { emoji: "📙", name: "orange book", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["orange_book"]), variations: &[] },
    Emoji { emoji: "📚", name: "books", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["books"]), variations: &[] },
    Emoji { emoji: "📓", name: "notebook", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["notebook"]), variations: &[] },
    Emoji { emoji: "📒", name: "ledger", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["ledger"]), variations: &[] },
    Emoji { emoji: "📃", name: "page with curl", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["page_with_curl"]), variations: &[] },
    Emoji { emoji: "📜", name: "scroll", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["scroll"]), variations: &[] },
    Emoji { emoji: "📄", name: "page facing up", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["page_facing_up"]), variations: &[] },
    Emoji { emoji: "📰", name: "newspaper", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["newspaper"]), variations: &[] },
    Emoji { emoji: "🗞️", name: "rolled-up newspaper", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::Objects, skin_tone: None, aliases: Some(&["newspaper_roll"]), variations: &["🗞"] },
    Emoji { emoji: "📑", name: "bookmark tabs", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["bookmark_tabs"]), variations: &[] },
    Emoji { emoji: "🔖", name: "bookmark", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["bookmark"]), variations: &[] },
    Emoji { emoji: "🏷️", name: "label", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::Objects, skin_tone: None, aliases: Some(&["label"]), variations: &["🏷"] },
    Emoji { emoji: "💰", name: "money bag", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["moneybag"]), variations: &[] },
    Emoji { emoji: "🪙", name: "coin", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::Objects, skin_tone: None, aliases: Some(&["coin"]), variations: &[] },
    Emoji { emoji: "💴", name: "yen banknote", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["yen"]), variations: &[] },
    Emoji { emoji: "💵", name: "dollar banknote", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["dollar"]), variations: &[] },
    Emoji { emoji: "💶", name: "euro banknote", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::Objects, skin_tone: None, aliases: Some(&["euro"]), variations: &[] },
    Emoji { emoji: "💷", name: "pound banknote", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::Objects, skin_tone: None, aliases: Some(&["pound"]), variations: &[] },
    Emoji { emoji: "💸", name: "money with wings", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["money_with_wings"]), variations: &[] },
    Emoji { emoji: "💳", name: "credit card", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["credit_card"]), variations: &[] },
    Emoji { emoji: "🧾", name: "receipt", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::Objects, skin_tone: None, aliases: Some(&["receipt"]), variations: &[] },
    Emoji { emoji: "💹", name: "chart increasing with yen", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["chart"]), variations: &[] },
    Emoji { emoji: "✉️", name: "envelope", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["email", "envelope"]), variations: &["✉"] },
    Emoji { emoji: "📧", name: "e-mail", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["e-mail"]), variations: &[] },
    Emoji { emoji: "📨", name: "incoming envelope", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["incoming_envelope"]), variations: &[] },
    Emoji { emoji: "📩", name: "envelope with arrow", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["envelope_with_arrow"]), variations: &[] },
    Emoji { emoji: "📤", name: "outbox tray", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["outbox_tray"]), variations: &[] },
    Emoji { emoji: "📥", name: "inbox tray", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["inbox_tray"]), variations: &[] },
    Emoji { emoji: "📦", name: "package", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["package"]), variations: &[] },
    Emoji { emoji: "📫", name: "closed mailbox with raised flag", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["mailbox"]), variations: &[] },
    Emoji { emoji: "📪", name: "closed mailbox with lowered flag", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["mailbox_closed"]), variations: &[] },
    Emoji { emoji: "📬", name: "open mailbox with raised flag", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::Objects, skin_tone: None, aliases: Some(&["mailbox_with_mail"]), variations: &[] },
    Emoji { emoji: "📭", name: "open mailbox with lowered flag", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::Objects, skin_tone: None, aliases: Some(&["mailbox_with_no_mail"]), variations: &[] },
    Emoji { emoji: "📮", name: "postbox", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["postbox"]), variations: &[] },
    Emoji { emoji: "🗳️", name: "ballot box with ballot", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::Objects, skin_tone: None, aliases: Some(&["ballot_box"]), variations: &["🗳"] },
    Emoji { emoji: "✏️", name: "pencil", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["pencil2"]), variations: &["✏"] },
    Emoji { emoji: "✒️", name: "black nib", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["black_nib"]), variations: &["✒"] },
    Emoji { emoji: "🖋️", name: "fountain pen", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::Objects, skin_tone: None, aliases: Some(&["fountain_pen"]), variations: &["🖋"] },
    Emoji { emoji: "🖊️", name: "pen", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::Objects, skin_tone: None, aliases: Some(&["pen"]), variations: &["🖊"] },
    Emoji { emoji: "🖌️", name: "paintbrush", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::Objects, skin_tone: None, aliases: Some(&["paintbrush"]), variations: &["🖌"] },
    Emoji { emoji: "🖍️", name: "crayon", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::Objects, skin_tone: None, aliases: Some(&["crayon"]), variations: &["🖍"] },
    Emoji { emoji: "📝", name: "memo", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["memo", "pencil"]), variations: &[] },
    Emoji { emoji: "💼", name: "briefcase", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["briefcase"]), variations: &[] },
    Emoji { emoji: "📁", name: "file folder", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["file_folder"]), variations: &[] },
    Emoji { emoji: "📂", name: "open file folder", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["open_file_folder"]), variations: &[] },
    Emoji { emoji: "🗂️", name: "card index dividers", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::Objects, skin_tone: None, aliases: Some(&["card_index_dividers"]), variations: &["🗂"] },
    Emoji { emoji: "📅", name: "calendar", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["date"]), variations: &[] },
    Emoji { emoji: "📆", name: "tear-off calendar", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["calendar"]), variations: &[] },
    Emoji { emoji: "🗒️", name: "spiral notepad", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::Objects, skin_tone: None, aliases: Some(&["spiral_notepad"]), variations: &["🗒"] },
    Emoji { emoji: "🗓️", name: "spiral calendar", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::Objects, skin_tone: None, aliases: Some(&["spiral_calendar"]), variations: &["🗓"] },
    Emoji { emoji: "📇", name: "card index", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["card_index"]), variations: &[] },
    Emoji { emoji: "📈", name: "chart increasing", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["chart_with_upwards_trend"]), variations: &[] },
    Emoji { emoji: "📉", name: "chart decreasing", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["chart_with_downwards_trend"]), variations: &[] },
    Emoji { emoji: "📊", name: "bar chart", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["bar_chart"]), variations: &[] },
    Emoji { emoji: "📋", name: "clipboard", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["clipboard"]), variations: &[] },
    Emoji { emoji: "📌", name: "pushpin", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["pushpin"]), variations: &[] },
    Emoji { emoji: "📍", name: "round pushpin", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["round_pushpin"]), variations: &[] },
    Emoji { emoji: "📎", name: "paperclip", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["paperclip"]), variations: &[] },
    Emoji { emoji: "🖇️", name: "linked paperclips", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::Objects, skin_tone: None, aliases: Some(&["paperclips"]), variations: &["🖇"] },
    Emoji { emoji: "📏", name: "straight ruler", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["straight_ruler"]), variations: &[] },
    Emoji { emoji: "📐", name: "triangular ruler", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["triangular_ruler"]), variations: &[] },
    Emoji { emoji: "✂️", name: "scissors", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["scissors"]), variations: &["✂"] },
    Emoji { emoji: "🗃️", name: "card file box", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::Objects, skin_tone: None, aliases: Some(&["card_file_box"]), variations: &["🗃"] },
    Emoji { emoji: "🗄️", name: "file cabinet", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::Objects, skin_tone: None, aliases: Some(&["file_cabinet"]), variations: &["🗄"] },
    Emoji { emoji: "🗑️", name: "wastebasket", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::Objects, skin_tone: None, aliases: Some(&["wastebasket"]), variations: &["🗑"] },
    Emoji { emoji: "🔒", name: "locked", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["lock"]), variations: &[] },
    Emoji { emoji: "🔓", name: "unlocked", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["unlock"]), variations: &[] },
    Emoji { emoji: "🔏", name: "locked with pen", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["lock_with_ink_pen"]), variations: &[] },
    Emoji { emoji: "🔐", name: "locked with key", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["closed_lock_with_key"]), variations: &[] },
    Emoji { emoji: "🔑", name: "key", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["key"]), variations: &[] },
    Emoji { emoji: "🗝️", name: "old key", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::Objects, skin_tone: None, aliases: Some(&["old_key"]), variations: &["🗝"] },
    Emoji { emoji: "🔨", name: "hammer", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["hammer"]), variations: &[] },
    Emoji { emoji: "🪓", name: "axe", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::Objects, skin_tone: None, aliases: Some(&["axe"]), variations: &[] },
    Emoji { emoji: "⛏️", name: "pick", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::Objects, skin_tone: None, aliases: Some(&["pick"]), variations: &["⛏"] },
    Emoji { emoji: "⚒️", name: "hammer and pick", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::Objects, skin_tone: None, aliases: Some(&["hammer_and_pick"]), variations: &["⚒"] },
    Emoji { emoji: "🛠️", name: "hammer and wrench", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::Objects, skin_tone: None, aliases: Some(&["hammer_and_wrench"]), variations: &["🛠"] },
    Emoji { emoji: "🗡️", name: "dagger", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::Objects, skin_tone: None, aliases: Some(&["dagger"]), variations: &["🗡"] },
    Emoji { emoji: "⚔️", name: "crossed swords", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::Objects, skin_tone: None, aliases: Some(&["crossed_swords"]), variations: &["⚔"] },
    Emoji { emoji: "🔫", name: "water pistol", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["gun"]), variations: &[] },
    Emoji { emoji: "🪃", name: "boomerang", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::Objects, skin_tone: None, aliases: Some(&["boomerang"]), variations: &[] },
    Emoji { emoji: "🏹", name: "bow and arrow", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::Objects, skin_tone: None, aliases: Some(&["bow_and_arrow"]), variations: &[] },
    Emoji { emoji: "🛡️", name: "shield", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::Objects, skin_tone: None, aliases: Some(&["shield"]), variations: &["🛡"] },
    Emoji { emoji: "🪚", name: "carpentry saw", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::Objects, skin_tone: None, aliases: Some(&["carpentry_saw"]), variations: &[] },
    Emoji { emoji: "🔧", name: "wrench", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["wrench"]), variations: &[] },
    Emoji { emoji: "🪛", name: "screwdriver", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::Objects, skin_tone: None, aliases: Some(&["screwdriver"]), variations: &[] },
    Emoji { emoji: "🔩", name: "nut and bolt", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["nut_and_bolt"]), variations: &[] },
    Emoji { emoji: "⚙️", name: "gear", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::Objects, skin_tone: None, aliases: Some(&["gear"]), variations: &["⚙"] },
    Emoji { emoji: "🗜️", name: "clamp", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::Objects, skin_tone: None, aliases: Some(&["clamp"]), variations: &["🗜"] },
    Emoji { emoji: "⚖️", name: "balance scale", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::Objects, skin_tone: None, aliases: Some(&["balance_scale"]), variations: &["⚖"] },
    Emoji { emoji: "🦯", name: "white cane", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::Objects, skin_tone: None, aliases: Some(&["probing_cane"]), variations: &[] },
    Emoji { emoji: "🔗", name: "link", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["link"]), variations: &[] },
    Emoji { emoji: "⛓️", name: "chains", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::Objects, skin_tone: None, aliases: Some(&["chains"]), variations: &["⛓"] },
    Emoji { emoji: "🪝", name: "hook", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::Objects, skin_tone: None, aliases: Some(&["hook"]), variations: &[] },
    Emoji { emoji: "🧰", name: "toolbox", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::Objects, skin_tone: None, aliases: Some(&["toolbox"]), variations: &[] },
    Emoji { emoji: "🧲", name: "magnet", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::Objects, skin_tone: None, aliases: Some(&["magnet"]), variations: &[] },
    Emoji { emoji: "🪜", name: "ladder", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::Objects, skin_tone: None, aliases: Some(&["ladder"]), variations: &[] },
    Emoji { emoji: "⚗️", name: "alembic", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::Objects, skin_tone: None, aliases: Some(&["alembic"]), variations: &["⚗"] },
    Emoji { emoji: "🧪", name: "test tube", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::Objects, skin_tone: None, aliases: Some(&["test_tube"]), variations: &[] },
    Emoji { emoji: "🧫", name: "petri dish", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::Objects, skin_tone: None, aliases: Some(&["petri_dish"]), variations: &[] },
    Emoji { emoji: "🧬", name: "dna", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::Objects, skin_tone: None, aliases: Some(&["dna"]), variations: &[] },
    Emoji { emoji: "🔬", name: "microscope", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::Objects, skin_tone: None, aliases: Some(&["microscope"]), variations: &[] },
    Emoji { emoji: "🔭", name: "telescope", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::Objects, skin_tone: None, aliases: Some(&["telescope"]), variations: &[] },
    Emoji { emoji: "📡", name: "satellite antenna", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["satellite"]), variations: &[] },
    Emoji { emoji: "💉", name: "syringe", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["syringe"]), variations: &[] },
    Emoji { emoji: "🩸", name: "drop of blood", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::Objects, skin_tone: None, aliases: Some(&["drop_of_blood"]), variations: &[] },
    Emoji { emoji: "💊", name: "pill", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["pill"]), variations: &[] },
    Emoji { emoji: "🩹", name: "adhesive bandage", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::Objects, skin_tone: None, aliases: Some(&["adhesive_bandage"]), variations: &[] },
    Emoji { emoji: "🩼", name: "crutch", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::Objects, skin_tone: None, aliases: None, variations: &[] },
    Emoji { emoji: "🩺", name: "stethoscope", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::Objects, skin_tone: None, aliases: Some(&["stethoscope"]), variations: &[] },
    Emoji { emoji: "🩻", name: "x-ray", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::Objects, skin_tone: None, aliases: None, variations: &[] },
    Emoji { emoji: "🚪", name: "door", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["door"]), variations: &[] },
    Emoji { emoji: "🛗", name: "elevator", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::Objects, skin_tone: None, aliases: Some(&["elevator"]), variations: &[] },
    Emoji { emoji: "🪞", name: "mirror", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::Objects, skin_tone: None, aliases: Some(&["mirror"]), variations: &[] },
    Emoji { emoji: "🪟", name: "window", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::Objects, skin_tone: None, aliases: Some(&["window"]), variations: &[] },
    Emoji { emoji: "🛏️", name: "bed", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::Objects, skin_tone: None, aliases: Some(&["bed"]), variations: &["🛏"] },
    Emoji { emoji: "🛋️", name: "couch and lamp", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::Objects, skin_tone: None, aliases: Some(&["couch_and_lamp"]), variations: &["🛋"] },
    Emoji { emoji: "🪑", name: "chair", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::Objects, skin_tone: None, aliases: Some(&["chair"]), variations: &[] },
    Emoji { emoji: "🚽", name: "toilet", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["toilet"]), variations: &[] },
    Emoji { emoji: "🪠", name: "plunger", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::Objects, skin_tone: None, aliases: Some(&["plunger"]), variations: &[] },
    Emoji { emoji: "🚿", name: "shower", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::Objects, skin_tone: None, aliases: Some(&["shower"]), variations: &[] },
    Emoji { emoji: "🛁", name: "bathtub", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::Objects, skin_tone: None, aliases: Some(&["bathtub"]), variations: &[] },
    Emoji { emoji: "🪤", name: "mouse trap", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::Objects, skin_tone: None, aliases: Some(&["mouse_trap"]), variations: &[] },
    Emoji { emoji: "🪒", name: "razor", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::Objects, skin_tone: None, aliases: Some(&["razor"]), variations: &[] },
    Emoji { emoji: "🧴", name: "lotion bottle", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::Objects, skin_tone: None, aliases: Some(&["lotion_bottle"]), variations: &[] },
    Emoji { emoji: "🧷", name: "safety pin", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::Objects, skin_tone: None, aliases: Some(&["safety_pin"]), variations: &[] },
    Emoji { emoji: "🧹", name: "broom", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::Objects, skin_tone: None, aliases: Some(&["broom"]), variations: &[] },
    Emoji { emoji: "🧺", name: "basket", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::Objects, skin_tone: None, aliases: Some(&["basket"]), variations: &[] },
    Emoji { emoji: "🧻", name: "roll of paper", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::Objects, skin_tone: None, aliases: Some(&["roll_of_paper"]), variations: &[] },
    Emoji { emoji: "🪣", name: "bucket", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::Objects, skin_tone: None, aliases: Some(&["bucket"]), variations: &[] },
    Emoji { emoji: "🧼", name: "soap", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::Objects, skin_tone: None, aliases: Some(&["soap"]), variations: &[] },
    Emoji { emoji: "🫧", name: "bubbles", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::Objects, skin_tone: None, aliases: None, variations: &[] },
    Emoji { emoji: "🪥", name: "toothbrush", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::Objects, skin_tone: None, aliases: Some(&["toothbrush"]), variations: &[] },
    Emoji { emoji: "🧽", name: "sponge", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::Objects, skin_tone: None, aliases: Some(&["sponge"]), variations: &[] },
    Emoji { emoji: "🧯", name: "fire extinguisher", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::Objects, skin_tone: None, aliases: Some(&["fire_extinguisher"]), variations: &[] },
    Emoji { emoji: "🛒", name: "shopping cart", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::Objects, skin_tone: None, aliases: Some(&["shopping_cart"]), variations: &[] },
    Emoji { emoji: "🚬", name: "cigarette", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["smoking"]), variations: &[] },
    Emoji { emoji: "⚰️", name: "coffin", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::Objects, skin_tone: None, aliases: Some(&["coffin"]), variations: &["⚰"] },
    Emoji { emoji: "🪦", name: "headstone", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::Objects, skin_tone: None, aliases: Some(&["headstone"]), variations: &[] },
    Emoji { emoji: "⚱️", name: "funeral urn", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::Objects, skin_tone: None, aliases: Some(&["funeral_urn"]), variations: &["⚱"] },
    Emoji { emoji: "🗿", name: "moai", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, aliases: Some(&["moyai"]), variations: &[] },
    Emoji { emoji: "🪧", name: "placard", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::Objects, skin_tone: None, aliases: Some(&["placard"]), variations: &[] },
    Emoji { emoji: "🪪", name: "identification card", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::Objects, skin_tone: None, aliases: None, variations: &[] },
    Emoji { emoji: "🏧", name: "ATM sign", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["atm"]), variations: &[] },
    Emoji { emoji: "🚮", name: "litter in bin sign", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["put_litter_in_its_place"]), variations: &[] },
    Emoji { emoji: "🚰", name: "potable water", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["potable_water"]), variations: &[] },
    Emoji { emoji: "♿", name: "wheelchair symbol", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["wheelchair"]), variations: &[] },
    Emoji { emoji: "🚹", name: "men’s room", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["mens"]), variations: &[] },
    Emoji { emoji: "🚺", name: "women’s room", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["womens"]), variations: &[] },
    Emoji { emoji: "🚻", name: "restroom", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["restroom"]), variations: &[] },
    Emoji { emoji: "🚼", name: "baby symbol", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["baby_symbol"]), variations: &[] },
    Emoji { emoji: "🚾", name: "water closet", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["wc"]), variations: &[] },
    Emoji { emoji: "🛂", name: "passport control", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["passport_control"]), variations: &[] },
    Emoji { emoji: "🛃", name: "customs", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["customs"]), variations: &[] },
    Emoji { emoji: "🛄", name: "baggage claim", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["baggage_claim"]), variations: &[] },
    Emoji { emoji: "🛅", name: "left luggage", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["left_luggage"]), variations: &[] },
    Emoji { emoji: "⚠️", name: "warning", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["warning"]), variations: &["⚠"] },
    Emoji { emoji: "🚸", name: "children crossing", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["children_crossing"]), variations: &[] },
    Emoji { emoji: "⛔", name: "no entry", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["no_entry"]), variations: &[] },
    Emoji { emoji: "🚫", name: "prohibited", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["no_entry_sign"]), variations: &[] },
    Emoji { emoji: "🚳", name: "no bicycles", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["no_bicycles"]), variations: &[] },
    Emoji { emoji: "🚭", name: "no smoking", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["no_smoking"]), variations: &[] },
    Emoji { emoji: "🚯", name: "no littering", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["do_not_litter"]), variations: &[] },
    Emoji { emoji: "🚱", name: "non-potable water", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["non-potable_water"]), variations: &[] },
    Emoji { emoji: "🚷", name: "no pedestrians", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["no_pedestrians"]), variations: &[] },
    Emoji { emoji: "📵", name: "no mobile phones", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["no_mobile_phones"]), variations: &[] },
    Emoji { emoji: "🔞", name: "no one under eighteen", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["underage"]), variations: &[] },
    Emoji { emoji: "☢️", name: "radioactive", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["radioactive"]), variations: &["☢"] },
    Emoji { emoji: "☣️", name: "biohazard", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["biohazard"]), variations: &["☣"] },
    Emoji { emoji: "⬆️", name: "up arrow", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["arrow_up"]), variations: &["⬆"] },
    Emoji { emoji: "↗️", name: "up-right arrow", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["arrow_upper_right"]), variations: &["↗"] },
    Emoji { emoji: "➡️", name: "right arrow", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["arrow_right"]), variations: &["➡"] },
    Emoji { emoji: "↘️", name: "down-right arrow", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["arrow_lower_right"]), variations: &["↘"] },
    Emoji { emoji: "⬇️", name: "down arrow", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["arrow_down"]), variations: &["⬇"] },
    Emoji { emoji: "↙️", name: "down-left arrow", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["arrow_lower_left"]), variations: &["↙"] },
    Emoji { emoji: "⬅️", name: "left arrow", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["arrow_left"]), variations: &["⬅"] },
    Emoji { emoji: "↖️", name: "up-left arrow", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["arrow_upper_left"]), variations: &["↖"] },
    Emoji { emoji: "↕️", name: "up-down arrow", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["arrow_up_down"]), variations: &["↕"] },
    Emoji { emoji: "↔️", name: "left-right arrow", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["left_right_arrow"]), variations: &["↔"] },
    Emoji { emoji: "↩️", name: "right arrow curving left", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["leftwards_arrow_with_hook"]), variations: &["↩"] },
    Emoji { emoji: "↪️", name: "left arrow curving right", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["arrow_right_hook"]), variations: &["↪"] },
    Emoji { emoji: "⤴️", name: "right arrow curving up", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["arrow_heading_up"]), variations: &["⤴"] },
    Emoji { emoji: "⤵️", name: "right arrow curving down", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["arrow_heading_down"]), variations: &["⤵"] },
    Emoji { emoji: "🔃", name: "clockwise vertical arrows", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["arrows_clockwise"]), variations: &[] },
    Emoji { emoji: "🔄", name: "counterclockwise arrows button", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["arrows_counterclockwise"]), variations: &[] },
    Emoji { emoji: "🔙", name: "BACK arrow", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["back"]), variations: &[] },
    Emoji { emoji: "🔚", name: "END arrow", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["end"]), variations: &[] },
    Emoji { emoji: "🔛", name: "ON! arrow", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["on"]), variations: &[] },
    Emoji { emoji: "🔜", name: "SOON arrow", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["soon"]), variations: &[] },
    Emoji { emoji: "🔝", name: "TOP arrow", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["top"]), variations: &[] },
    Emoji { emoji: "🛐", name: "place of worship", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["place_of_worship"]), variations: &[] },
    Emoji { emoji: "⚛️", name: "atom symbol", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["atom_symbol"]), variations: &["⚛"] },
    Emoji { emoji: "🕉️", name: "om", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["om"]), variations: &["🕉"] },
    Emoji { emoji: "✡️", name: "star of David", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["star_of_david"]), variations: &["✡"] },
    Emoji { emoji: "☸️", name: "wheel of dharma", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["wheel_of_dharma"]), variations: &["☸"] },
    Emoji { emoji: "☯️", name: "yin yang", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["yin_yang"]), variations: &["☯"] },
    Emoji { emoji: "✝️", name: "latin cross", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["latin_cross"]), variations: &["✝"] },
    Emoji { emoji: "☦️", name: "orthodox cross", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["orthodox_cross"]), variations: &["☦"] },
    Emoji { emoji: "☪️", name: "star and crescent", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["star_and_crescent"]), variations: &["☪"] },
    Emoji { emoji: "☮️", name: "peace symbol", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["peace_symbol"]), variations: &["☮"] },
    Emoji { emoji: "🕎", name: "menorah", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["menorah"]), variations: &[] },
    Emoji { emoji: "🔯", name: "dotted six-pointed star", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["six_pointed_star"]), variations: &[] },
    Emoji { emoji: "♈", name: "Aries", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["aries"]), variations: &[] },
    Emoji { emoji: "♉", name: "Taurus", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["taurus"]), variations: &[] },
    Emoji { emoji: "♊", name: "Gemini", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["gemini"]), variations: &[] },
    Emoji { emoji: "♋", name: "Cancer", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["cancer"]), variations: &[] },
    Emoji { emoji: "♌", name: "Leo", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["leo"]), variations: &[] },
    Emoji { emoji: "♍", name: "Virgo", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["virgo"]), variations: &[] },
    Emoji { emoji: "♎", name: "Libra", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["libra"]), variations: &[] },
    Emoji { emoji: "♏", name: "Scorpio", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["scorpius"]), variations: &[] },
    Emoji { emoji: "♐", name: "Sagittarius", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["sagittarius"]), variations: &[] },
    Emoji { emoji: "♑", name: "Capricorn", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["capricorn"]), variations: &[] },
    Emoji { emoji: "♒", name: "Aquarius", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["aquarius"]), variations: &[] },
    Emoji { emoji: "♓", name: "Pisces", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["pisces"]), variations: &[] },
    Emoji { emoji: "⛎", name: "Ophiuchus", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["ophiuchus"]), variations: &[] },
    Emoji { emoji: "🔀", name: "shuffle tracks button", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["twisted_rightwards_arrows"]), variations: &[] },
    Emoji { emoji: "🔁", name: "repeat button", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["repeat"]), variations: &[] },
    Emoji { emoji: "🔂", name: "repeat single button", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["repeat_one"]), variations: &[] },
    Emoji { emoji: "▶️", name: "play button", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["arrow_forward"]), variations: &["▶"] },
    Emoji { emoji: "⏩", name: "fast-forward button", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["fast_forward"]), variations: &[] },
    Emoji { emoji: "⏭️", name: "next track button", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["next_track_button"]), variations: &["⏭"] },
    Emoji { emoji: "⏯️", name: "play or pause button", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["play_or_pause_button"]), variations: &["⏯"] },
    Emoji { emoji: "◀️", name: "reverse button", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["arrow_backward"]), variations: &["◀"] },
    Emoji { emoji: "⏪", name: "fast reverse button", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["rewind"]), variations: &[] },
    Emoji { emoji: "⏮️", name: "last track button", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["previous_track_button"]), variations: &["⏮"] },
    Emoji { emoji: "🔼", name: "upwards button", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["arrow_up_small"]), variations: &[] },
    Emoji { emoji: "⏫", name: "fast up button", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["arrow_double_up"]), variations: &[] },
    Emoji { emoji: "🔽", name: "downwards button", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["arrow_down_small"]), variations: &[] },
    Emoji { emoji: "⏬", name: "fast down button", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["arrow_double_down"]), variations: &[] },
    Emoji { emoji: "⏸️", name: "pause button", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["pause_button"]), variations: &["⏸"] },
    Emoji { emoji: "⏹️", name: "stop button", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["stop_button"]), variations: &["⏹"] },
    Emoji { emoji: "⏺️", name: "record button", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["record_button"]), variations: &["⏺"] },
    Emoji { emoji: "⏏️", name: "eject button", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["eject_button"]), variations: &["⏏"] },
    Emoji { emoji: "🎦", name: "cinema", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["cinema"]), variations: &[] },
    Emoji { emoji: "🔅", name: "dim button", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["low_brightness"]), variations: &[] },
    Emoji { emoji: "🔆", name: "bright button", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["high_brightness"]), variations: &[] },
    Emoji { emoji: "📶", name: "antenna bars", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["signal_strength"]), variations: &[] },
    Emoji { emoji: "📳", name: "vibration mode", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["vibration_mode"]), variations: &[] },
    Emoji { emoji: "📴", name: "mobile phone off", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["mobile_phone_off"]), variations: &[] },
    Emoji { emoji: "♀️", name: "female sign", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["female_sign"]), variations: &["♀"] },
    Emoji { emoji: "♂️", name: "male sign", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["male_sign"]), variations: &["♂"] },
    Emoji { emoji: "⚧️", name: "transgender symbol", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["transgender_symbol"]), variations: &["⚧"] },
    Emoji { emoji: "✖️", name: "multiply", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["heavy_multiplication_x"]), variations: &["✖"] },
    Emoji { emoji: "➕", name: "plus", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["heavy_plus_sign"]), variations: &[] },
    Emoji { emoji: "➖", name: "minus", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["heavy_minus_sign"]), variations: &[] },
    Emoji { emoji: "➗", name: "divide", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["heavy_division_sign"]), variations: &[] },
    Emoji { emoji: "🟰", name: "heavy equals sign", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::Symbols, skin_tone: None, aliases: None, variations: &[] },
    Emoji { emoji: "♾️", name: "infinity", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["infinity"]), variations: &["♾"] },
    Emoji { emoji: "‼️", name: "double exclamation mark", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["bangbang"]), variations: &["‼"] },
    Emoji { emoji: "⁉️", name: "exclamation question mark", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["interrobang"]), variations: &["⁉"] },
    Emoji { emoji: "❓", name: "red question mark", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["question"]), variations: &[] },
    Emoji { emoji: "❔", name: "white question mark", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["grey_question"]), variations: &[] },
    Emoji { emoji: "❕", name: "white exclamation mark", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["grey_exclamation"]), variations: &[] },
    Emoji { emoji: "❗", name: "red exclamation mark", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["exclamation", "heavy_exclamation_mark"]), variations: &[] },
    Emoji { emoji: "〰️", name: "wavy dash", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["wavy_dash"]), variations: &["〰"] },
    Emoji { emoji: "💱", name: "currency exchange", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["currency_exchange"]), variations: &[] },
    Emoji { emoji: "💲", name: "heavy dollar sign", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["heavy_dollar_sign"]), variations: &[] },
    Emoji { emoji: "⚕️", name: "medical symbol", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["medical_symbol"]), variations: &["⚕"] },
    Emoji { emoji: "♻️", name: "recycling symbol", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["recycle"]), variations: &["♻"] },
    Emoji { emoji: "⚜️", name: "fleur-de-lis", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["fleur_de_lis"]), variations: &["⚜"] },
    Emoji { emoji: "🔱", name: "trident emblem", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["trident"]), variations: &[] },
    Emoji { emoji: "📛", name: "name badge", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["name_badge"]), variations: &[] },
    Emoji { emoji: "🔰", name: "Japanese symbol for beginner", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["beginner"]), variations: &[] },
    Emoji { emoji: "⭕", name: "hollow red circle", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["o"]), variations: &[] },
    Emoji { emoji: "✅", name: "check mark button", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["white_check_mark"]), variations: &[] },
    Emoji { emoji: "☑️", name: "check box with check", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["ballot_box_with_check"]), variations: &["☑"] },
    Emoji { emoji: "✔️", name: "check mark", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["heavy_check_mark"]), variations: &["✔"] },
    Emoji { emoji: "❌", name: "cross mark", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["x"]), variations: &[] },
    Emoji { emoji: "❎", name: "cross mark button", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["negative_squared_cross_mark"]), variations: &[] },
    Emoji { emoji: "➰", name: "curly loop", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["curly_loop"]), variations: &[] },
    Emoji { emoji: "➿", name: "double curly loop", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["loop"]), variations: &[] },
    Emoji { emoji: "〽️", name: "part alternation mark", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["part_alternation_mark"]), variations: &["〽"] },
    Emoji { emoji: "✳️", name: "eight-spoked asterisk", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["eight_spoked_asterisk"]), variations: &["✳"] },
    Emoji { emoji: "✴️", name: "eight-pointed star", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["eight_pointed_black_star"]), variations: &["✴"] },
    Emoji { emoji: "❇️", name: "sparkle", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["sparkle"]), variations: &["❇"] },
    Emoji { emoji: "©️", name: "copyright", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["copyright"]), variations: &["©"] },
    Emoji { emoji: "®️", name: "registered", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["registered"]), variations: &["®"] },
    Emoji { emoji: "™️", name: "trade mark", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["tm"]), variations: &["™"] },
    Emoji { emoji: "#️⃣", name: "keycap: #", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["hash"]), variations: &["#\u{20e3}"] },
    Emoji { emoji: "*️⃣", name: "keycap: *", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["asterisk"]), variations: &["*\u{20e3}"] },
    Emoji { emoji: "0️⃣", name: "keycap: 0", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["zero"]), variations: &["0\u{20e3}"] },
    Emoji { emoji: "1️⃣", name: "keycap: 1", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["one"]), variations: &["1\u{20e3}"] },
    Emoji { emoji: "2️⃣", name: "keycap: 2", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["two"]), variations: &["2\u{20e3}"] },
    Emoji { emoji: "3️⃣", name: "keycap: 3", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["three"]), variations: &["3\u{20e3}"] },
    Emoji { emoji: "4️⃣", name: "keycap: 4", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["four"]), variations: &["4\u{20e3}"] },
    Emoji { emoji: "5️⃣", name: "keycap: 5", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["five"]), variations: &["5\u{20e3}"] },
    Emoji { emoji: "6️⃣", name: "keycap: 6", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["six"]), variations: &["6\u{20e3}"] },
    Emoji { emoji: "7️⃣", name: "keycap: 7", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["seven"]), variations: &["7\u{20e3}"] },
    Emoji { emoji: "8️⃣", name: "keycap: 8", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["eight"]), variations: &["8\u{20e3}"] },
    Emoji { emoji: "9️⃣", name: "keycap: 9", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["nine"]), variations: &["9\u{20e3}"] },
    Emoji { emoji: "🔟", name: "keycap: 10", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["keycap_ten"]), variations: &[] },
    Emoji { emoji: "🔠", name: "input latin uppercase", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["capital_abcd"]), variations: &[] },
    Emoji { emoji: "🔡", name: "input latin lowercase", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["abcd"]), variations: &[] },
    Emoji { emoji: "🔢", name: "input numbers", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["1234"]), variations: &[] },
    Emoji { emoji: "🔣", name: "input symbols", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["symbols"]), variations: &[] },
    Emoji { emoji: "🔤", name: "input latin letters", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["abc"]), variations: &[] },
    Emoji { emoji: "🅰️", name: "A button (blood type)", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["a"]), variations: &["🅰"] },
    Emoji { emoji: "🆎", name: "AB button (blood type)", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["ab"]), variations: &[] },
    Emoji { emoji: "🅱️", name: "B button (blood type)", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["b"]), variations: &["🅱"] },
    Emoji { emoji: "🆑", name: "CL button", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["cl"]), variations: &[] },
    Emoji { emoji: "🆒", name: "COOL button", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["cool"]), variations: &[] },
    Emoji { emoji: "🆓", name: "FREE button", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["free"]), variations: &[] },
    Emoji { emoji: "ℹ️", name: "information", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["information_source"]), variations: &["ℹ"] },
    Emoji { emoji: "🆔", name: "ID button", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["id"]), variations: &[] },
    Emoji { emoji: "Ⓜ️", name: "circled M", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["m"]), variations: &["Ⓜ"] },
    Emoji { emoji: "🆕", name: "NEW button", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["new"]), variations: &[] },
    Emoji { emoji: "🆖", name: "NG button", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["ng"]), variations: &[] },
    Emoji { emoji: "🅾️", name: "O button (blood type)", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["o2"]), variations: &["🅾"] },
    Emoji { emoji: "🆗", name: "OK button", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["ok"]), variations: &[] },
    Emoji { emoji: "🅿️", name: "P button", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["parking"]), variations: &["🅿"] },
    Emoji { emoji: "🆘", name: "SOS button", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["sos"]), variations: &[] },
    Emoji { emoji: "🆙", name: "UP! button", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["up"]), variations: &[] },
    Emoji { emoji: "🆚", name: "VS button", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["vs"]), variations: &[] },
    Emoji { emoji: "🈁", name: "Japanese “here” button", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["koko"]), variations: &[] },
    Emoji { emoji: "🈂️", name: "Japanese “service charge” button", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["sa"]), variations: &["🈂"] },
    Emoji { emoji: "🈷️", name: "Japanese “monthly amount” button", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["u6708"]), variations: &["🈷"] },
    Emoji { emoji: "🈶", name: "Japanese “not free of charge” button", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["u6709"]), variations: &[] },
    Emoji { emoji: "🈯", name: "Japanese “reserved” button", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["u6307"]), variations: &[] },
    Emoji { emoji: "🉐", name: "Japanese “bargain” button", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["ideograph_advantage"]), variations: &[] },
    Emoji { emoji: "🈹", name: "Japanese “discount” button", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["u5272"]), variations: &[] },
    Emoji { emoji: "🈚", name: "Japanese “free of charge” button", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["u7121"]), variations: &[] },
    Emoji { emoji: "🈲", name: "Japanese “prohibited” button", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["u7981"]), variations: &[] },
    Emoji { emoji: "🉑", name: "Japanese “acceptable” button", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["accept"]), variations: &[] },
    Emoji { emoji: "🈸", name: "Japanese “application” button", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["u7533"]), variations: &[] },
    Emoji { emoji: "🈴", name: "Japanese “passing grade” button", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["u5408"]), variations: &[] },
    Emoji { emoji: "🈳", name: "Japanese “vacancy” button", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["u7a7a"]), variations: &[] },
    Emoji { emoji: "㊗️", name: "Japanese “congratulations” button", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["congratulations"]), variations: &["㊗"] },
    Emoji { emoji: "㊙️", name: "Japanese “secret” button", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["secret"]), variations: &["㊙"] },
    Emoji { emoji: "🈺", name: "Japanese “open for business” button", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["u55b6"]), variations: &[] },
    Emoji { emoji: "🈵", name: "Japanese “no vacancy” button", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["u6e80"]), variations: &[] },
    Emoji { emoji: "🔴", name: "red circle", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["red_circle"]), variations: &[] },
    Emoji { emoji: "🟠", name: "orange circle", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["orange_circle"]), variations: &[] },
    Emoji { emoji: "🟡", name: "yellow circle", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["yellow_circle"]), variations: &[] },
    Emoji { emoji: "🟢", name: "green circle", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["green_circle"]), variations: &[] },
    Emoji { emoji: "🔵", name: "blue circle", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["large_blue_circle"]), variations: &[] },
    Emoji { emoji: "🟣", name: "purple circle", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["purple_circle"]), variations: &[] },
    Emoji { emoji: "🟤", name: "brown circle", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["brown_circle"]), variations: &[] },
    Emoji { emoji: "⚫", name: "black circle", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["black_circle"]), variations: &[] },
    Emoji { emoji: "⚪", name: "white circle", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["white_circle"]), variations: &[] },
    Emoji { emoji: "🟥", name: "red square", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["red_square"]), variations: &[] },
    Emoji { emoji: "🟧", name: "orange square", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["orange_square"]), variations: &[] },
    Emoji { emoji: "🟨", name: "yellow square", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["yellow_square"]), variations: &[] },
    Emoji { emoji: "🟩", name: "green square", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["green_square"]), variations: &[] },
    Emoji { emoji: "🟦", name: "blue square", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["blue_square"]), variations: &[] },
    Emoji { emoji: "🟪", name: "purple square", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["purple_square"]), variations: &[] },
    Emoji { emoji: "🟫", name: "brown square", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["brown_square"]), variations: &[] },
    Emoji { emoji: "⬛", name: "black large square", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["black_large_square"]), variations: &[] },
    Emoji { emoji: "⬜", name: "white large square", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["white_large_square"]), variations: &[] },
    Emoji { emoji: "◼️", name: "black medium square", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["black_medium_square"]), variations: &["◼"] },
    Emoji { emoji: "◻️", name: "white medium square", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["white_medium_square"]), variations: &["◻"] },
    Emoji { emoji: "◾", name: "black medium-small square", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["black_medium_small_square"]), variations: &[] },
    Emoji { emoji: "◽", name: "white medium-small square", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["white_medium_small_square"]), variations: &[] },
    Emoji { emoji: "▪️", name: "black small square", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["black_small_square"]), variations: &["▪"] },
    Emoji { emoji: "▫️", name: "white small square", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["white_small_square"]), variations: &["▫"] },
    Emoji { emoji: "🔶", name: "large orange diamond", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["large_orange_diamond"]), variations: &[] },
    Emoji { emoji: "🔷", name: "large blue diamond", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["large_blue_diamond"]), variations: &[] },
    Emoji { emoji: "🔸", name: "small orange diamond", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["small_orange_diamond"]), variations: &[] },
    Emoji { emoji: "🔹", name: "small blue diamond", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["small_blue_diamond"]), variations: &[] },
    Emoji { emoji: "🔺", name: "red triangle pointed up", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["small_red_triangle"]), variations: &[] },
    Emoji { emoji: "🔻", name: "red triangle pointed down", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["small_red_triangle_down"]), variations: &[] },
    Emoji { emoji: "💠", name: "diamond with a dot", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["diamond_shape_with_a_dot_inside"]), variations: &[] },
    Emoji { emoji: "🔘", name: "radio button", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["radio_button"]), variations: &[] },
    Emoji { emoji: "🔳", name: "white square button", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["white_square_button"]), variations: &[] },
    Emoji { emoji: "🔲", name: "black square button", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, aliases: Some(&["black_square_button"]), variations: &[] },
    Emoji { emoji: "🏁", name: "chequered flag", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Flags, skin_tone: None, aliases: Some(&["checkered_flag"]), variations: &[] },
    Emoji { emoji: "🚩", name: "triangular flag", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Flags, skin_tone: None, aliases: Some(&["triangular_flag_on_post"]), variations: &[] },
    Emoji { emoji: "🎌", name: "crossed flags", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Flags, skin_tone: None, aliases: Some(&["crossed_flags"]), variations: &[] },
    Emoji { emoji: "🏴", name: "black flag", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["black_flag"]), variations: &[] },
    Emoji { emoji: "🏳️", name: "white flag", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::Flags, skin_tone: None, aliases: Some(&["white_flag"]), variations: &["🏳"] },
    Emoji { emoji: "🏳️‍🌈", name: "rainbow flag", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["rainbow_flag"]), variations: &["🏳\u{200d}🌈"] },
    Emoji { emoji: "🏳️‍⚧️", name: "transgender flag", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["transgender_flag"]), variations: &["🏳\u{200d}⚧\u{fe0f}", "🏳\u{fe0f}\u{200d}⚧", "🏳\u{200d}⚧"] },
    Emoji { emoji: "🏴‍☠️", name: "pirate flag", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["pirate_flag"]), variations: &["🏴\u{200d}☠"] },
    Emoji { emoji: "🇦🇨", name: "flag: Ascension Island", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["ascension_island"]), variations: &[] },
    Emoji { emoji: "🇦🇩", name: "flag: Andorra", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["andorra"]), variations: &[] },
    Emoji { emoji: "🇦🇪", name: "flag: United Arab Emirates", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["united_arab_emirates"]), variations: &[] },
    Emoji { emoji: "🇦🇫", name: "flag: Afghanistan", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["afghanistan"]), variations: &[] },
    Emoji { emoji: "🇦🇬", name: "flag: Antigua & Barbuda", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["antigua_barbuda"]), variations: &[] },
    Emoji { emoji: "🇦🇮", name: "flag: Anguilla", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["anguilla"]), variations: &[] },
    Emoji { emoji: "🇦🇱", name: "flag: Albania", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["albania"]), variations: &[] },
    Emoji { emoji: "🇦🇲", name: "flag: Armenia", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["armenia"]), variations: &[] },
    Emoji { emoji: "🇦🇴", name: "flag: Angola", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["angola"]), variations: &[] },
    Emoji { emoji: "🇦🇶", name: "flag: Antarctica", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["antarctica"]), variations: &[] },
    Emoji { emoji: "🇦🇷", name: "flag: Argentina", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["argentina"]), variations: &[] },
    Emoji { emoji: "🇦🇸", name: "flag: American Samoa", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["american_samoa"]), variations: &[] },
    Emoji { emoji: "🇦🇹", name: "flag: Austria", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["austria"]), variations: &[] },
    Emoji { emoji: "🇦🇺", name: "flag: Australia", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["australia"]), variations: &[] },
    Emoji { emoji: "🇦🇼", name: "flag: Aruba", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["aruba"]), variations: &[] },
    Emoji { emoji: "🇦🇽", name: "flag: Åland Islands", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["aland_islands"]), variations: &[] },
    Emoji { emoji: "🇦🇿", name: "flag: Azerbaijan", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["azerbaijan"]), variations: &[] },
    Emoji { emoji: "🇧🇦", name: "flag: Bosnia & Herzegovina", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["bosnia_herzegovina"]), variations: &[] },
    Emoji { emoji: "🇧🇧", name: "flag: Barbados", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["barbados"]), variations: &[] },
    Emoji { emoji: "🇧🇩", name: "flag: Bangladesh", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["bangladesh"]), variations: &[] },
    Emoji { emoji: "🇧🇪", name: "flag: Belgium", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["belgium"]), variations: &[] },
    Emoji { emoji: "🇧🇫", name: "flag: Burkina Faso", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["burkina_faso"]), variations: &[] },
    Emoji { emoji: "🇧🇬", name: "flag: Bulgaria", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["bulgaria"]), variations: &[] },
    Emoji { emoji: "🇧🇭", name: "flag: Bahrain", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["bahrain"]), variations: &[] },
    Emoji { emoji: "🇧🇮", name: "flag: Burundi", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["burundi"]), variations: &[] },
    Emoji { emoji: "🇧🇯", name: "flag: Benin", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["benin"]), variations: &[] },
    Emoji { emoji: "🇧🇱", name: "flag: St. Barthélemy", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["st_barthelemy"]), variations: &[] },
    Emoji { emoji: "🇧🇲", name: "flag: Bermuda", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["bermuda"]), variations: &[] },
    Emoji { emoji: "🇧🇳", name: "flag: Brunei", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["brunei"]), variations: &[] },
    Emoji { emoji: "🇧🇴", name: "flag: Bolivia", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["bolivia"]), variations: &[] },
    Emoji { emoji: "🇧🇶", name: "flag: Caribbean Netherlands", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["caribbean_netherlands"]), variations: &[] },
    Emoji { emoji: "🇧🇷", name: "flag: Brazil", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["brazil"]), variations: &[] },
    Emoji { emoji: "🇧🇸", name: "flag: Bahamas", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["bahamas"]), variations: &[] },
    Emoji { emoji: "🇧🇹", name: "flag: Bhutan", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["bhutan"]), variations: &[] },
    Emoji { emoji: "🇧🇻", name: "flag: Bouvet Island", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["bouvet_island"]), variations: &[] },
    Emoji { emoji: "🇧🇼", name: "flag: Botswana", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["botswana"]), variations: &[] },
    Emoji { emoji: "🇧🇾", name: "flag: Belarus", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["belarus"]), variations: &[] },
    Emoji { emoji: "🇧🇿", name: "flag: Belize", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["belize"]), variations: &[] },
    Emoji { emoji: "🇨🇦", name: "flag: Canada", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["canada"]), variations: &[] },
    Emoji { emoji: "🇨🇨", name: "flag: Cocos (Keeling) Islands", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["cocos_islands"]), variations: &[] },
    Emoji { emoji: "🇨🇩", name: "flag: Congo - Kinshasa", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["congo_kinshasa"]), variations: &[] },
    Emoji { emoji: "🇨🇫", name: "flag: Central African Republic", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["central_african_republic"]), variations: &[] },
    Emoji { emoji: "🇨🇬", name: "flag: Congo - Brazzaville", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["congo_brazzaville"]), variations: &[] },
    Emoji { emoji: "🇨🇭", name: "flag: Switzerland", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["switzerland"]), variations: &[] },
    Emoji { emoji: "🇨🇮", name: "flag: Côte d’Ivoire", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["cote_divoire"]), variations: &[] },
    Emoji { emoji: "🇨🇰", name: "flag: Cook Islands", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["cook_islands"]), variations: &[] },
    Emoji { emoji: "🇨🇱", name: "flag: Chile", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["chile"]), variations: &[] },
    Emoji { emoji: "🇨🇲", name: "flag: Cameroon", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["cameroon"]), variations: &[] },
    Emoji { emoji: "🇨🇳", name: "flag: China", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Flags, skin_tone: None, aliases: Some(&["cn"]), variations: &[] },
    Emoji { emoji: "🇨🇴", name: "flag: Colombia", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["colombia"]), variations: &[] },
    Emoji { emoji: "🇨🇵", name: "flag: Clipperton Island", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["clipperton_island"]), variations: &[] },
    Emoji { emoji: "🇨🇷", name: "flag: Costa Rica", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["costa_rica"]), variations: &[] },
    Emoji { emoji: "🇨🇺", name: "flag: Cuba", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["cuba"]), variations: &[] },
    Emoji { emoji: "🇨🇻", name: "flag: Cape Verde", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["cape_verde"]), variations: &[] },
    Emoji { emoji: "🇨🇼", name: "flag: Curaçao", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["curacao"]), variations: &[] },
    Emoji { emoji: "🇨🇽", name: "flag: Christmas Island", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["christmas_island"]), variations: &[] },
    Emoji { emoji: "🇨🇾", name: "flag: Cyprus", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["cyprus"]), variations: &[] },
    Emoji { emoji: "🇨🇿", name: "flag: Czechia", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["czech_republic"]), variations: &[] },
    Emoji { emoji: "🇩🇪", name: "flag: Germany", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Flags, skin_tone: None, aliases: Some(&["de"]), variations: &[] },
    Emoji { emoji: "🇩🇬", name: "flag: Diego Garcia", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["diego_garcia"]), variations: &[] },
    Emoji { emoji: "🇩🇯", name: "flag: Djibouti", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["djibouti"]), variations: &[] },
    Emoji { emoji: "🇩🇰", name: "flag: Denmark", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["denmark"]), variations: &[] },
    Emoji { emoji: "🇩🇲", name: "flag: Dominica", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["dominica"]), variations: &[] },
    Emoji { emoji: "🇩🇴", name: "flag: Dominican Republic", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["dominican_republic"]), variations: &[] },
    Emoji { emoji: "🇩🇿", name: "flag: Algeria", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["algeria"]), variations: &[] },
    Emoji { emoji: "🇪🇦", name: "flag: Ceuta & Melilla", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["ceuta_melilla"]), variations: &[] },
    Emoji { emoji: "🇪🇨", name: "flag: Ecuador", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["ecuador"]), variations: &[] },
    Emoji { emoji: "🇪🇪", name: "flag: Estonia", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["estonia"]), variations: &[] },
    Emoji { emoji: "🇪🇬", name: "flag: Egypt", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["egypt"]), variations: &[] },
    Emoji { emoji: "🇪🇭", name: "flag: Western Sahara", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["western_sahara"]), variations: &[] },
    Emoji { emoji: "🇪🇷", name: "flag: Eritrea", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["eritrea"]), variations: &[] },
    Emoji { emoji: "🇪🇸", name: "flag: Spain", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Flags, skin_tone: None, aliases: Some(&["es"]), variations: &[] },
    Emoji { emoji: "🇪🇹", name: "flag: Ethiopia", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["ethiopia"]), variations: &[] },
    Emoji { emoji: "🇪🇺", name: "flag: European Union", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["eu", "european_union"]), variations: &[] },
    Emoji { emoji: "🇫🇮", name: "flag: Finland", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["finland"]), variations: &[] },
    Emoji { emoji: "🇫🇯", name: "flag: Fiji", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["fiji"]), variations: &[] },
    Emoji { emoji: "🇫🇰", name: "flag: Falkland Islands", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["falkland_islands"]), variations: &[] },
    Emoji { emoji: "🇫🇲", name: "flag: Micronesia", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["micronesia"]), variations: &[] },
    Emoji { emoji: "🇫🇴", name: "flag: Faroe Islands", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["faroe_islands"]), variations: &[] },
    Emoji { emoji: "🇫🇷", name: "flag: France", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Flags, skin_tone: None, aliases: Some(&["fr"]), variations: &[] },
    Emoji { emoji: "🇬🇦", name: "flag: Gabon", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["gabon"]), variations: &[] },
    Emoji { emoji: "🇬🇧", name: "flag: United Kingdom", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Flags, skin_tone: None, aliases: Some(&["gb", "uk"]), variations: &[] },
    Emoji { emoji: "🇬🇩", name: "flag: Grenada", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["grenada"]), variations: &[] },
    Emoji { emoji: "🇬🇪", name: "flag: Georgia", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["georgia"]), variations: &[] },
    Emoji { emoji: "🇬🇫", name: "flag: French Guiana", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["french_guiana"]), variations: &[] },
    Emoji { emoji: "🇬🇬", name: "flag: Guernsey", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["guernsey"]), variations: &[] },
    Emoji { emoji: "🇬🇭", name: "flag: Ghana", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["ghana"]), variations: &[] },
    Emoji { emoji: "🇬🇮", name: "flag: Gibraltar", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["gibraltar"]), variations: &[] },
    Emoji { emoji: "🇬🇱", name: "flag: Greenland", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["greenland"]), variations: &[] },
    Emoji { emoji: "🇬🇲", name: "flag: Gambia", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["gambia"]), variations: &[] },
    Emoji { emoji: "🇬🇳", name: "flag: Guinea", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["guinea"]), variations: &[] },
    Emoji { emoji: "🇬🇵", name: "flag: Guadeloupe", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["guadeloupe"]), variations: &[] },
    Emoji { emoji: "🇬🇶", name: "flag: Equatorial Guinea", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["equatorial_guinea"]), variations: &[] },
    Emoji { emoji: "🇬🇷", name: "flag: Greece", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["greece"]), variations: &[] },
    Emoji { emoji: "🇬🇸", name: "flag: South Georgia & South Sandwich Islands", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["south_georgia_south_sandwich_islands"]), variations: &[] },
    Emoji { emoji: "🇬🇹", name: "flag: Guatemala", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["guatemala"]), variations: &[] },
    Emoji { emoji: "🇬🇺", name: "flag: Guam", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["guam"]), variations: &[] },
    Emoji { emoji: "🇬🇼", name: "flag: Guinea-Bissau", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["guinea_bissau"]), variations: &[] },
    Emoji { emoji: "🇬🇾", name: "flag: Guyana", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["guyana"]), variations: &[] },
    Emoji { emoji: "🇭🇰", name: "flag: Hong Kong SAR China", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["hong_kong"]), variations: &[] },
    Emoji { emoji: "🇭🇲", name: "flag: Heard & McDonald Islands", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["heard_mcdonald_islands"]), variations: &[] },
    Emoji { emoji: "🇭🇳", name: "flag: Honduras", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["honduras"]), variations: &[] },
    Emoji { emoji: "🇭🇷", name: "flag: Croatia", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["croatia"]), variations: &[] },
    Emoji { emoji: "🇭🇹", name: "flag: Haiti", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["haiti"]), variations: &[] },
    Emoji { emoji: "🇭🇺", name: "flag: Hungary", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["hungary"]), variations: &[] },
    Emoji { emoji: "🇮🇨", name: "flag: Canary Islands", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["canary_islands"]), variations: &[] },
    Emoji { emoji: "🇮🇩", name: "flag: Indonesia", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["indonesia"]), variations: &[] },
    Emoji { emoji: "🇮🇪", name: "flag: Ireland", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["ireland"]), variations: &[] },
    Emoji { emoji: "🇮🇱", name: "flag: Israel", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["israel"]), variations: &[] },
    Emoji { emoji: "🇮🇲", name: "flag: Isle of Man", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["isle_of_man"]), variations: &[] },
    Emoji { emoji: "🇮🇳", name: "flag: India", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["india"]), variations: &[] },
    Emoji { emoji: "🇮🇴", name: "flag: British Indian Ocean Territory", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["british_indian_ocean_territory"]), variations: &[] },
    Emoji { emoji: "🇮🇶", name: "flag: Iraq", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["iraq"]), variations: &[] },
    Emoji { emoji: "🇮🇷", name: "flag: Iran", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["iran"]), variations: &[] },
    Emoji { emoji: "🇮🇸", name: "flag: Iceland", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["iceland"]), variations: &[] },
    Emoji { emoji: "🇮🇹", name: "flag: Italy", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Flags, skin_tone: None, aliases: Some(&["it"]), variations: &[] },
    Emoji { emoji: "🇯🇪", name: "flag: Jersey", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["jersey"]), variations: &[] },
    Emoji { emoji: "🇯🇲", name: "flag: Jamaica", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["jamaica"]), variations: &[] },
    Emoji { emoji: "🇯🇴", name: "flag: Jordan", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["jordan"]), variations: &[] },
    Emoji { emoji: "🇯🇵", name: "flag: Japan", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Flags, skin_tone: None, aliases: Some(&["jp"]), variations: &[] },
    Emoji { emoji: "🇰🇪", name: "flag: Kenya", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["kenya"]), variations: &[] },
    Emoji { emoji: "🇰🇬", name: "flag: Kyrgyzstan", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["kyrgyzstan"]), variations: &[] },
    Emoji { emoji: "🇰🇭", name: "flag: Cambodia", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["cambodia"]), variations: &[] },
    Emoji { emoji: "🇰🇮", name: "flag: Kiribati", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["kiribati"]), variations: &[] },
    Emoji { emoji: "🇰🇲", name: "flag: Comoros", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["comoros"]), variations: &[] },
    Emoji { emoji: "🇰🇳", name: "flag: St. Kitts & Nevis", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["st_kitts_nevis"]), variations: &[] },
    Emoji { emoji: "🇰🇵", name: "flag: North Korea", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["north_korea"]), variations: &[] },
    Emoji { emoji: "🇰🇷", name: "flag: South Korea", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Flags, skin_tone: None, aliases: Some(&["kr"]), variations: &[] },
    Emoji { emoji: "🇰🇼", name: "flag: Kuwait", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["kuwait"]), variations: &[] },
    Emoji { emoji: "🇰🇾", name: "flag: Cayman Islands", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["cayman_islands"]), variations: &[] },
    Emoji { emoji: "🇰🇿", name: "flag: Kazakhstan", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["kazakhstan"]), variations: &[] },
    Emoji { emoji: "🇱🇦", name: "flag: Laos", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["laos"]), variations: &[] },
    Emoji { emoji: "🇱🇧", name: "flag: Lebanon", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["lebanon"]), variations: &[] },
    Emoji { emoji: "🇱🇨", name: "flag: St. Lucia", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["st_lucia"]), variations: &[] },
    Emoji { emoji: "🇱🇮", name: "flag: Liechtenstein", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["liechtenstein"]), variations: &[] },
    Emoji { emoji: "🇱🇰", name: "flag: Sri Lanka", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["sri_lanka"]), variations: &[] },
    Emoji { emoji: "🇱🇷", name: "flag: Liberia", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["liberia"]), variations: &[] },
    Emoji { emoji: "🇱🇸", name: "flag: Lesotho", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["lesotho"]), variations: &[] },
    Emoji { emoji: "🇱🇹", name: "flag: Lithuania", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["lithuania"]), variations: &[] },
    Emoji { emoji: "🇱🇺", name: "flag: Luxembourg", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["luxembourg"]), variations: &[] },
    Emoji { emoji: "🇱🇻", name: "flag: Latvia", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["latvia"]), variations: &[] },
    Emoji { emoji: "🇱🇾", name: "flag: Libya", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["libya"]), variations: &[] },
    Emoji { emoji: "🇲🇦", name: "flag: Morocco", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["morocco"]), variations: &[] },
    Emoji { emoji: "🇲🇨", name: "flag: Monaco", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["monaco"]), variations: &[] },
    Emoji { emoji: "🇲🇩", name: "flag: Moldova", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["moldova"]), variations: &[] },
    Emoji { emoji: "🇲🇪", name: "flag: Montenegro", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["montenegro"]), variations: &[] },
    Emoji { emoji: "🇲🇫", name: "flag: St. Martin", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["st_martin"]), variations: &[] },
    Emoji { emoji: "🇲🇬", name: "flag: Madagascar", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["madagascar"]), variations: &[] },
    Emoji { emoji: "🇲🇭", name: "flag: Marshall Islands", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["marshall_islands"]), variations: &[] },
    Emoji { emoji: "🇲🇰", name: "flag: North Macedonia", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["macedonia"]), variations: &[] },
    Emoji { emoji: "🇲🇱", name: "flag: Mali", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["mali"]), variations: &[] },
    Emoji { emoji: "🇲🇲", name: "flag: Myanmar (Burma)", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["myanmar"]), variations: &[] },
    Emoji { emoji: "🇲🇳", name: "flag: Mongolia", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["mongolia"]), variations: &[] },
    Emoji { emoji: "🇲🇴", name: "flag: Macao SAR China", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["macau"]), variations: &[] },
    Emoji { emoji: "🇲🇵", name: "flag: Northern Mariana Islands", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["northern_mariana_islands"]), variations: &[] },
    Emoji { emoji: "🇲🇶", name: "flag: Martinique", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["martinique"]), variations: &[] },
    Emoji { emoji: "🇲🇷", name: "flag: Mauritania", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["mauritania"]), variations: &[] },
    Emoji { emoji: "🇲🇸", name: "flag: Montserrat", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["montserrat"]), variations: &[] },
    Emoji { emoji: "🇲🇹", name: "flag: Malta", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["malta"]), variations: &[] },
    Emoji { emoji: "🇲🇺", name: "flag: Mauritius", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["mauritius"]), variations: &[] },
    Emoji { emoji: "🇲🇻", name: "flag: Maldives", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["maldives"]), variations: &[] },
    Emoji { emoji: "🇲🇼", name: "flag: Malawi", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["malawi"]), variations: &[] },
    Emoji { emoji: "🇲🇽", name: "flag: Mexico", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["mexico"]), variations: &[] },
    Emoji { emoji: "🇲🇾", name: "flag: Malaysia", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["malaysia"]), variations: &[] },
    Emoji { emoji: "🇲🇿", name: "flag: Mozambique", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["mozambique"]), variations: &[] },
    Emoji { emoji: "🇳🇦", name: "flag: Namibia", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["namibia"]), variations: &[] },
    Emoji { emoji: "🇳🇨", name: "flag: New Caledonia", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["new_caledonia"]), variations: &[] },
    Emoji { emoji: "🇳🇪", name: "flag: Niger", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["niger"]), variations: &[] },
    Emoji { emoji: "🇳🇫", name: "flag: Norfolk Island", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["norfolk_island"]), variations: &[] },
    Emoji { emoji: "🇳🇬", name: "flag: Nigeria", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["nigeria"]), variations: &[] },
    Emoji { emoji: "🇳🇮", name: "flag: Nicaragua", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["nicaragua"]), variations: &[] },
    Emoji { emoji: "🇳🇱", name: "flag: Netherlands", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["netherlands"]), variations: &[] },
    Emoji { emoji: "🇳🇴", name: "flag: Norway", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["norway"]), variations: &[] },
    Emoji { emoji: "🇳🇵", name: "flag: Nepal", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["nepal"]), variations: &[] },
    Emoji { emoji: "🇳🇷", name: "flag: Nauru", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["nauru"]), variations: &[] },
    Emoji { emoji: "🇳🇺", name: "flag: Niue", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["niue"]), variations: &[] },
    Emoji { emoji: "🇳🇿", name: "flag: New Zealand", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["new_zealand"]), variations: &[] },
    Emoji { emoji: "🇴🇲", name: "flag: Oman", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["oman"]), variations: &[] },
    Emoji { emoji: "🇵🇦", name: "flag: Panama", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["panama"]), variations: &[] },
    Emoji { emoji: "🇵🇪", name: "flag: Peru", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["peru"]), variations: &[] },
    Emoji { emoji: "🇵🇫", name: "flag: French Polynesia", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["french_polynesia"]), variations: &[] },
    Emoji { emoji: "🇵🇬", name: "flag: Papua New Guinea", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["papua_new_guinea"]), variations: &[] },
    Emoji { emoji: "🇵🇭", name: "flag: Philippines", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["philippines"]), variations: &[] },
    Emoji { emoji: "🇵🇰", name: "flag: Pakistan", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["pakistan"]), variations: &[] },
    Emoji { emoji: "🇵🇱", name: "flag: Poland", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["poland"]), variations: &[] },
    Emoji { emoji: "🇵🇲", name: "flag: St. Pierre & Miquelon", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["st_pierre_miquelon"]), variations: &[] },
    Emoji { emoji: "🇵🇳", name: "flag: Pitcairn Islands", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["pitcairn_islands"]), variations: &[] },
    Emoji { emoji: "🇵🇷", name: "flag: Puerto Rico", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["puerto_rico"]), variations: &[] },
    Emoji { emoji: "🇵🇸", name: "flag: Palestinian Territories", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["palestinian_territories"]), variations: &[] },
    Emoji { emoji: "🇵🇹", name: "flag: Portugal", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["portugal"]), variations: &[] },
    Emoji { emoji: "🇵🇼", name: "flag: Palau", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["palau"]), variations: &[] },
    Emoji { emoji: "🇵🇾", name: "flag: Paraguay", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["paraguay"]), variations: &[] },
    Emoji { emoji: "🇶🇦", name: "flag: Qatar", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["qatar"]), variations: &[] },
    Emoji { emoji: "🇷🇪", name: "flag: Réunion", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["reunion"]), variations: &[] },
    Emoji { emoji: "🇷🇴", name: "flag: Romania", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["romania"]), variations: &[] },
    Emoji { emoji: "🇷🇸", name: "flag: Serbia", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["serbia"]), variations: &[] },
    Emoji { emoji: "🇷🇺", name: "flag: Russia", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Flags, skin_tone: None, aliases: Some(&["ru"]), variations: &[] },
    Emoji { emoji: "🇷🇼", name: "flag: Rwanda", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["rwanda"]), variations: &[] },
    Emoji { emoji: "🇸🇦", name: "flag: Saudi Arabia", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["saudi_arabia"]), variations: &[] },
    Emoji { emoji: "🇸🇧", name: "flag: Solomon Islands", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["solomon_islands"]), variations: &[] },
    Emoji { emoji: "🇸🇨", name: "flag: Seychelles", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["seychelles"]), variations: &[] },
    Emoji { emoji: "🇸🇩", name: "flag: Sudan", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["sudan"]), variations: &[] },
    Emoji { emoji: "🇸🇪", name: "flag: Sweden", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["sweden"]), variations: &[] },
    Emoji { emoji: "🇸🇬", name: "flag: Singapore", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["singapore"]), variations: &[] },
    Emoji { emoji: "🇸🇭", name: "flag: St. Helena", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["st_helena"]), variations: &[] },
    Emoji { emoji: "🇸🇮", name: "flag: Slovenia", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["slovenia"]), variations: &[] },
    Emoji { emoji: "🇸🇯", name: "flag: Svalbard & Jan Mayen", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["svalbard_jan_mayen"]), variations: &[] },
    Emoji { emoji: "🇸🇰", name: "flag: Slovakia", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["slovakia"]), variations: &[] },
    Emoji { emoji: "🇸🇱", name: "flag: Sierra Leone", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["sierra_leone"]), variations: &[] },
    Emoji { emoji: "🇸🇲", name: "flag: San Marino", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["san_marino"]), variations: &[] },
    Emoji { emoji: "🇸🇳", name: "flag: Senegal", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["senegal"]), variations: &[] },
    Emoji { emoji: "🇸🇴", name: "flag: Somalia", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["somalia"]), variations: &[] },
    Emoji { emoji: "🇸🇷", name: "flag: Suriname", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["suriname"]), variations: &[] },
    Emoji { emoji: "🇸🇸", name: "flag: South Sudan", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["south_sudan"]), variations: &[] },
    Emoji { emoji: "🇸🇹", name: "flag: São Tomé & Príncipe", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["sao_tome_principe"]), variations: &[] },
    Emoji { emoji: "🇸🇻", name: "flag: El Salvador", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["el_salvador"]), variations: &[] },
    Emoji { emoji: "🇸🇽", name: "flag: Sint Maarten", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["sint_maarten"]), variations: &[] },
    Emoji { emoji: "🇸🇾", name: "flag: Syria", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["syria"]), variations: &[] },
    Emoji { emoji: "🇸🇿", name: "flag: Eswatini", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["swaziland"]), variations: &[] },
    Emoji { emoji: "🇹🇦", name: "flag: Tristan da Cunha", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["tristan_da_cunha"]), variations: &[] },
    Emoji { emoji: "🇹🇨", name: "flag: Turks & Caicos Islands", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["turks_caicos_islands"]), variations: &[] },
    Emoji { emoji: "🇹🇩", name: "flag: Chad", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["chad"]), variations: &[] },
    Emoji { emoji: "🇹🇫", name: "flag: French Southern Territories", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["french_southern_territories"]), variations: &[] },
    Emoji { emoji: "🇹🇬", name: "flag: Togo", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["togo"]), variations: &[] },
    Emoji { emoji: "🇹🇭", name: "flag: Thailand", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["thailand"]), variations: &[] },
    Emoji { emoji: "🇹🇯", name: "flag: Tajikistan", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["tajikistan"]), variations: &[] },
    Emoji { emoji: "🇹🇰", name: "flag: Tokelau", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["tokelau"]), variations: &[] },
    Emoji { emoji: "🇹🇱", name: "flag: Timor-Leste", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["timor_leste"]), variations: &[] },
    Emoji { emoji: "🇹🇲", name: "flag: Turkmenistan", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["turkmenistan"]), variations: &[] },
    Emoji { emoji: "🇹🇳", name: "flag: Tunisia", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["tunisia"]), variations: &[] },
    Emoji { emoji: "🇹🇴", name: "flag: Tonga", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["tonga"]), variations: &[] },
    Emoji { emoji: "🇹🇷", name: "flag: Turkey", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["tr"]), variations: &[] },
    Emoji { emoji: "🇹🇹", name: "flag: Trinidad & Tobago", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["trinidad_tobago"]), variations: &[] },
    Emoji { emoji: "🇹🇻", name: "flag: Tuvalu", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["tuvalu"]), variations: &[] },
    Emoji { emoji: "🇹🇼", name: "flag: Taiwan", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["taiwan"]), variations: &[] },
    Emoji { emoji: "🇹🇿", name: "flag: Tanzania", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["tanzania"]), variations: &[] },
    Emoji { emoji: "🇺🇦", name: "flag: Ukraine", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["ukraine"]), variations: &[] },
    Emoji { emoji: "🇺🇬", name: "flag: Uganda", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["uganda"]), variations: &[] },
    Emoji { emoji: "🇺🇲", name: "flag: U.S. Outlying Islands", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["us_outlying_islands"]), variations: &[] },
    Emoji { emoji: "🇺🇳", name: "flag: United Nations", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["united_nations"]), variations: &[] },
    Emoji { emoji: "🇺🇸", name: "flag: United States", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Flags, skin_tone: None, aliases: Some(&["us"]), variations: &[] },
    Emoji { emoji: "🇺🇾", name: "flag: Uruguay", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["uruguay"]), variations: &[] },
    Emoji { emoji: "🇺🇿", name: "flag: Uzbekistan", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["uzbekistan"]), variations: &[] },
    Emoji { emoji: "🇻🇦", name: "flag: Vatican City", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["vatican_city"]), variations: &[] },
    Emoji { emoji: "🇻🇨", name: "flag: St. Vincent & Grenadines", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["st_vincent_grenadines"]), variations: &[] },
    Emoji { emoji: "🇻🇪", name: "flag: Venezuela", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["venezuela"]), variations: &[] },
    Emoji { emoji: "🇻🇬", name: "flag: British Virgin Islands", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["british_virgin_islands"]), variations: &[] },
    Emoji { emoji: "🇻🇮", name: "flag: U.S. Virgin Islands", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["us_virgin_islands"]), variations: &[] },
    Emoji { emoji: "🇻🇳", name: "flag: Vietnam", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["vietnam"]), variations: &[] },
    Emoji { emoji: "🇻🇺", name: "flag: Vanuatu", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["vanuatu"]), variations: &[] },
    Emoji { emoji: "🇼🇫", name: "flag: Wallis & Futuna", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["wallis_futuna"]), variations: &[] },
    Emoji { emoji: "🇼🇸", name: "flag: Samoa", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["samoa"]), variations: &[] },
    Emoji { emoji: "🇽🇰", name: "flag: Kosovo", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["kosovo"]), variations: &[] },
    Emoji { emoji: "🇾🇪", name: "flag: Yemen", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["yemen"]), variations: &[] },
    Emoji { emoji: "🇾🇹", name: "flag: Mayotte", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["mayotte"]), variations: &[] },
    Emoji { emoji: "🇿🇦", name: "flag: South Africa", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["south_africa"]), variations: &[] },
    Emoji { emoji: "🇿🇲", name: "flag: Zambia", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["zambia"]), variations: &[] },
    Emoji { emoji: "🇿🇼", name: "flag: Zimbabwe", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["zimbabwe"]), variations: &[] },
    Emoji { emoji: "🏴󠁧󠁢󠁥󠁮󠁧󠁿", name: "flag: England", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["england"]), variations: &[] },
    Emoji { emoji: "🏴󠁧󠁢󠁳󠁣󠁴󠁿", name: "flag: Scotland", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["scotland"]), variations: &[] },
    Emoji { emoji: "🏴󠁧󠁢󠁷󠁬󠁳󠁿", name: "flag: Wales", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::Flags, skin_tone: None, aliases: Some(&["wales"]), variations: &[] },
];
