#![cfg_attr(rustfmt, rustfmt::skip)]

use crate::{Emoji, SkinTone};

/// A category for an emoji.
///
/// Based on Unicode CLDR data.
#[derive(Debug, Clone, Copy, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub enum Group {
   SmileysAndEmotion,
   PeopleAndBody,
   AnimalsAndNature,
   FoodAndDrink,
   TravelAndPlaces,
   Activities,
   Objects,
   Symbols,
   Flags,
}

pub const EMOJIS: &[Emoji] = &[
    Emoji { id: 0, emoji: "😀", name: "grinning face", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["grinning"]), variations: &[] },
    Emoji { id: 1, emoji: "😃", name: "grinning face with big eyes", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["smiley"]), variations: &[] },
    Emoji { id: 2, emoji: "😄", name: "grinning face with smiling eyes", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["smile"]), variations: &[] },
    Emoji { id: 3, emoji: "😁", name: "beaming face with smiling eyes", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["grin"]), variations: &[] },
    Emoji { id: 4, emoji: "😆", name: "grinning squinting face", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["laughing", "satisfied"]), variations: &[] },
    Emoji { id: 5, emoji: "😅", name: "grinning face with sweat", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["sweat_smile"]), variations: &[] },
    Emoji { id: 6, emoji: "🤣", name: "rolling on the floor laughing", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["rofl"]), variations: &[] },
    Emoji { id: 7, emoji: "😂", name: "face with tears of joy", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["joy"]), variations: &[] },
    Emoji { id: 8, emoji: "🙂", name: "slightly smiling face", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["slightly_smiling_face"]), variations: &[] },
    Emoji { id: 9, emoji: "🙃", name: "upside-down face", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["upside_down_face"]), variations: &[] },
    Emoji { id: 10, emoji: "😉", name: "winking face", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["wink"]), variations: &[] },
    Emoji { id: 11, emoji: "😊", name: "smiling face with smiling eyes", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["blush"]), variations: &[] },
    Emoji { id: 12, emoji: "😇", name: "smiling face with halo", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["innocent"]), variations: &[] },
    Emoji { id: 13, emoji: "🥰", name: "smiling face with hearts", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["smiling_face_with_three_hearts"]), variations: &[] },
    Emoji { id: 14, emoji: "😍", name: "smiling face with heart-eyes", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["heart_eyes"]), variations: &[] },
    Emoji { id: 15, emoji: "🤩", name: "star-struck", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["star_struck"]), variations: &[] },
    Emoji { id: 16, emoji: "😘", name: "face blowing a kiss", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["kissing_heart"]), variations: &[] },
    Emoji { id: 17, emoji: "😗", name: "kissing face", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["kissing"]), variations: &[] },
    Emoji { id: 18, emoji: "☺️", name: "smiling face", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["relaxed"]), variations: &["☺"] },
    Emoji { id: 19, emoji: "😚", name: "kissing face with closed eyes", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["kissing_closed_eyes"]), variations: &[] },
    Emoji { id: 20, emoji: "😙", name: "kissing face with smiling eyes", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["kissing_smiling_eyes"]), variations: &[] },
    Emoji { id: 21, emoji: "🥲", name: "smiling face with tear", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["smiling_face_with_tear"]), variations: &[] },
    Emoji { id: 22, emoji: "😋", name: "face savoring food", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["yum"]), variations: &[] },
    Emoji { id: 23, emoji: "😛", name: "face with tongue", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["stuck_out_tongue"]), variations: &[] },
    Emoji { id: 24, emoji: "😜", name: "winking face with tongue", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["stuck_out_tongue_winking_eye"]), variations: &[] },
    Emoji { id: 25, emoji: "🤪", name: "zany face", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["zany_face"]), variations: &[] },
    Emoji { id: 26, emoji: "😝", name: "squinting face with tongue", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["stuck_out_tongue_closed_eyes"]), variations: &[] },
    Emoji { id: 27, emoji: "🤑", name: "money-mouth face", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["money_mouth_face"]), variations: &[] },
    Emoji { id: 28, emoji: "🤗", name: "hugging face", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["hugs"]), variations: &[] },
    Emoji { id: 29, emoji: "🤭", name: "face with hand over mouth", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["hand_over_mouth"]), variations: &[] },
    Emoji { id: 30, emoji: "🤫", name: "shushing face", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["shushing_face"]), variations: &[] },
    Emoji { id: 31, emoji: "🤔", name: "thinking face", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["thinking"]), variations: &[] },
    Emoji { id: 32, emoji: "🤐", name: "zipper-mouth face", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["zipper_mouth_face"]), variations: &[] },
    Emoji { id: 33, emoji: "🤨", name: "face with raised eyebrow", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["raised_eyebrow"]), variations: &[] },
    Emoji { id: 34, emoji: "😐", name: "neutral face", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["neutral_face"]), variations: &[] },
    Emoji { id: 35, emoji: "😑", name: "expressionless face", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["expressionless"]), variations: &[] },
    Emoji { id: 36, emoji: "😶", name: "face without mouth", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["no_mouth"]), variations: &[] },
    Emoji { id: 37, emoji: "😶‍🌫️", name: "face in clouds", group: Group::SmileysAndEmotion, skin_tone: None, aliases: None, variations: &["😶\u{200d}🌫"] },
    Emoji { id: 38, emoji: "😏", name: "smirking face", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["smirk"]), variations: &[] },
    Emoji { id: 39, emoji: "😒", name: "unamused face", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["unamused"]), variations: &[] },
    Emoji { id: 40, emoji: "🙄", name: "face with rolling eyes", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["roll_eyes"]), variations: &[] },
    Emoji { id: 41, emoji: "😬", name: "grimacing face", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["grimacing"]), variations: &[] },
    Emoji { id: 42, emoji: "😮‍💨", name: "face exhaling", group: Group::SmileysAndEmotion, skin_tone: None, aliases: None, variations: &[] },
    Emoji { id: 43, emoji: "🤥", name: "lying face", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["lying_face"]), variations: &[] },
    Emoji { id: 44, emoji: "😌", name: "relieved face", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["relieved"]), variations: &[] },
    Emoji { id: 45, emoji: "😔", name: "pensive face", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["pensive"]), variations: &[] },
    Emoji { id: 46, emoji: "😪", name: "sleepy face", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["sleepy"]), variations: &[] },
    Emoji { id: 47, emoji: "🤤", name: "drooling face", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["drooling_face"]), variations: &[] },
    Emoji { id: 48, emoji: "😴", name: "sleeping face", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["sleeping"]), variations: &[] },
    Emoji { id: 49, emoji: "😷", name: "face with medical mask", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["mask"]), variations: &[] },
    Emoji { id: 50, emoji: "🤒", name: "face with thermometer", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["face_with_thermometer"]), variations: &[] },
    Emoji { id: 51, emoji: "🤕", name: "face with head-bandage", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["face_with_head_bandage"]), variations: &[] },
    Emoji { id: 52, emoji: "🤢", name: "nauseated face", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["nauseated_face"]), variations: &[] },
    Emoji { id: 53, emoji: "🤮", name: "face vomiting", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["vomiting_face"]), variations: &[] },
    Emoji { id: 54, emoji: "🤧", name: "sneezing face", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["sneezing_face"]), variations: &[] },
    Emoji { id: 55, emoji: "🥵", name: "hot face", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["hot_face"]), variations: &[] },
    Emoji { id: 56, emoji: "🥶", name: "cold face", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["cold_face"]), variations: &[] },
    Emoji { id: 57, emoji: "🥴", name: "woozy face", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["woozy_face"]), variations: &[] },
    Emoji { id: 58, emoji: "😵", name: "knocked-out face", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["dizzy_face"]), variations: &[] },
    Emoji { id: 59, emoji: "😵‍💫", name: "face with spiral eyes", group: Group::SmileysAndEmotion, skin_tone: None, aliases: None, variations: &[] },
    Emoji { id: 60, emoji: "🤯", name: "exploding head", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["exploding_head"]), variations: &[] },
    Emoji { id: 61, emoji: "🤠", name: "cowboy hat face", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["cowboy_hat_face"]), variations: &[] },
    Emoji { id: 62, emoji: "🥳", name: "partying face", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["partying_face"]), variations: &[] },
    Emoji { id: 63, emoji: "🥸", name: "disguised face", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["disguised_face"]), variations: &[] },
    Emoji { id: 64, emoji: "😎", name: "smiling face with sunglasses", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["sunglasses"]), variations: &[] },
    Emoji { id: 65, emoji: "🤓", name: "nerd face", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["nerd_face"]), variations: &[] },
    Emoji { id: 66, emoji: "🧐", name: "face with monocle", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["monocle_face"]), variations: &[] },
    Emoji { id: 67, emoji: "😕", name: "confused face", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["confused"]), variations: &[] },
    Emoji { id: 68, emoji: "😟", name: "worried face", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["worried"]), variations: &[] },
    Emoji { id: 69, emoji: "🙁", name: "slightly frowning face", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["slightly_frowning_face"]), variations: &[] },
    Emoji { id: 70, emoji: "☹️", name: "frowning face", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["frowning_face"]), variations: &["☹"] },
    Emoji { id: 71, emoji: "😮", name: "face with open mouth", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["open_mouth"]), variations: &[] },
    Emoji { id: 72, emoji: "😯", name: "hushed face", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["hushed"]), variations: &[] },
    Emoji { id: 73, emoji: "😲", name: "astonished face", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["astonished"]), variations: &[] },
    Emoji { id: 74, emoji: "😳", name: "flushed face", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["flushed"]), variations: &[] },
    Emoji { id: 75, emoji: "🥺", name: "pleading face", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["pleading_face"]), variations: &[] },
    Emoji { id: 76, emoji: "😦", name: "frowning face with open mouth", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["frowning"]), variations: &[] },
    Emoji { id: 77, emoji: "😧", name: "anguished face", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["anguished"]), variations: &[] },
    Emoji { id: 78, emoji: "😨", name: "fearful face", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["fearful"]), variations: &[] },
    Emoji { id: 79, emoji: "😰", name: "anxious face with sweat", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["cold_sweat"]), variations: &[] },
    Emoji { id: 80, emoji: "😥", name: "sad but relieved face", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["disappointed_relieved"]), variations: &[] },
    Emoji { id: 81, emoji: "😢", name: "crying face", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["cry"]), variations: &[] },
    Emoji { id: 82, emoji: "😭", name: "loudly crying face", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["sob"]), variations: &[] },
    Emoji { id: 83, emoji: "😱", name: "face screaming in fear", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["scream"]), variations: &[] },
    Emoji { id: 84, emoji: "😖", name: "confounded face", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["confounded"]), variations: &[] },
    Emoji { id: 85, emoji: "😣", name: "persevering face", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["persevere"]), variations: &[] },
    Emoji { id: 86, emoji: "😞", name: "disappointed face", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["disappointed"]), variations: &[] },
    Emoji { id: 87, emoji: "😓", name: "downcast face with sweat", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["sweat"]), variations: &[] },
    Emoji { id: 88, emoji: "😩", name: "weary face", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["weary"]), variations: &[] },
    Emoji { id: 89, emoji: "😫", name: "tired face", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["tired_face"]), variations: &[] },
    Emoji { id: 90, emoji: "🥱", name: "yawning face", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["yawning_face"]), variations: &[] },
    Emoji { id: 91, emoji: "😤", name: "face with steam from nose", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["triumph"]), variations: &[] },
    Emoji { id: 92, emoji: "😡", name: "pouting face", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["rage", "pout"]), variations: &[] },
    Emoji { id: 93, emoji: "😠", name: "angry face", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["angry"]), variations: &[] },
    Emoji { id: 94, emoji: "🤬", name: "face with symbols on mouth", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["cursing_face"]), variations: &[] },
    Emoji { id: 95, emoji: "😈", name: "smiling face with horns", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["smiling_imp"]), variations: &[] },
    Emoji { id: 96, emoji: "👿", name: "angry face with horns", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["imp"]), variations: &[] },
    Emoji { id: 97, emoji: "💀", name: "skull", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["skull"]), variations: &[] },
    Emoji { id: 98, emoji: "☠️", name: "skull and crossbones", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["skull_and_crossbones"]), variations: &["☠"] },
    Emoji { id: 99, emoji: "💩", name: "pile of poo", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["hankey", "poop", "shit"]), variations: &[] },
    Emoji { id: 100, emoji: "🤡", name: "clown face", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["clown_face"]), variations: &[] },
    Emoji { id: 101, emoji: "👹", name: "ogre", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["japanese_ogre"]), variations: &[] },
    Emoji { id: 102, emoji: "👺", name: "goblin", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["japanese_goblin"]), variations: &[] },
    Emoji { id: 103, emoji: "👻", name: "ghost", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["ghost"]), variations: &[] },
    Emoji { id: 104, emoji: "👽", name: "alien", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["alien"]), variations: &[] },
    Emoji { id: 105, emoji: "👾", name: "alien monster", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["space_invader"]), variations: &[] },
    Emoji { id: 106, emoji: "🤖", name: "robot", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["robot"]), variations: &[] },
    Emoji { id: 107, emoji: "😺", name: "grinning cat", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["smiley_cat"]), variations: &[] },
    Emoji { id: 108, emoji: "😸", name: "grinning cat with smiling eyes", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["smile_cat"]), variations: &[] },
    Emoji { id: 109, emoji: "😹", name: "cat with tears of joy", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["joy_cat"]), variations: &[] },
    Emoji { id: 110, emoji: "😻", name: "smiling cat with heart-eyes", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["heart_eyes_cat"]), variations: &[] },
    Emoji { id: 111, emoji: "😼", name: "cat with wry smile", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["smirk_cat"]), variations: &[] },
    Emoji { id: 112, emoji: "😽", name: "kissing cat", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["kissing_cat"]), variations: &[] },
    Emoji { id: 113, emoji: "🙀", name: "weary cat", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["scream_cat"]), variations: &[] },
    Emoji { id: 114, emoji: "😿", name: "crying cat", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["crying_cat_face"]), variations: &[] },
    Emoji { id: 115, emoji: "😾", name: "pouting cat", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["pouting_cat"]), variations: &[] },
    Emoji { id: 116, emoji: "🙈", name: "see-no-evil monkey", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["see_no_evil"]), variations: &[] },
    Emoji { id: 117, emoji: "🙉", name: "hear-no-evil monkey", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["hear_no_evil"]), variations: &[] },
    Emoji { id: 118, emoji: "🙊", name: "speak-no-evil monkey", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["speak_no_evil"]), variations: &[] },
    Emoji { id: 119, emoji: "💋", name: "kiss mark", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["kiss"]), variations: &[] },
    Emoji { id: 120, emoji: "💌", name: "love letter", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["love_letter"]), variations: &[] },
    Emoji { id: 121, emoji: "💘", name: "heart with arrow", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["cupid"]), variations: &[] },
    Emoji { id: 122, emoji: "💝", name: "heart with ribbon", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["gift_heart"]), variations: &[] },
    Emoji { id: 123, emoji: "💖", name: "sparkling heart", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["sparkling_heart"]), variations: &[] },
    Emoji { id: 124, emoji: "💗", name: "growing heart", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["heartpulse"]), variations: &[] },
    Emoji { id: 125, emoji: "💓", name: "beating heart", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["heartbeat"]), variations: &[] },
    Emoji { id: 126, emoji: "💞", name: "revolving hearts", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["revolving_hearts"]), variations: &[] },
    Emoji { id: 127, emoji: "💕", name: "two hearts", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["two_hearts"]), variations: &[] },
    Emoji { id: 128, emoji: "💟", name: "heart decoration", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["heart_decoration"]), variations: &[] },
    Emoji { id: 129, emoji: "❣️", name: "heart exclamation", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["heavy_heart_exclamation"]), variations: &["❣"] },
    Emoji { id: 130, emoji: "💔", name: "broken heart", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["broken_heart"]), variations: &[] },
    Emoji { id: 131, emoji: "❤️‍🔥", name: "heart on fire", group: Group::SmileysAndEmotion, skin_tone: None, aliases: None, variations: &["❤\u{200d}🔥"] },
    Emoji { id: 132, emoji: "❤️‍🩹", name: "mending heart", group: Group::SmileysAndEmotion, skin_tone: None, aliases: None, variations: &["❤\u{200d}🩹"] },
    Emoji { id: 133, emoji: "❤️", name: "red heart", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["heart"]), variations: &["❤"] },
    Emoji { id: 134, emoji: "🧡", name: "orange heart", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["orange_heart"]), variations: &[] },
    Emoji { id: 135, emoji: "💛", name: "yellow heart", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["yellow_heart"]), variations: &[] },
    Emoji { id: 136, emoji: "💚", name: "green heart", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["green_heart"]), variations: &[] },
    Emoji { id: 137, emoji: "💙", name: "blue heart", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["blue_heart"]), variations: &[] },
    Emoji { id: 138, emoji: "💜", name: "purple heart", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["purple_heart"]), variations: &[] },
    Emoji { id: 139, emoji: "🤎", name: "brown heart", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["brown_heart"]), variations: &[] },
    Emoji { id: 140, emoji: "🖤", name: "black heart", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["black_heart"]), variations: &[] },
    Emoji { id: 141, emoji: "🤍", name: "white heart", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["white_heart"]), variations: &[] },
    Emoji { id: 142, emoji: "💯", name: "hundred points", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["100"]), variations: &[] },
    Emoji { id: 143, emoji: "💢", name: "anger symbol", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["anger"]), variations: &[] },
    Emoji { id: 144, emoji: "💥", name: "collision", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["boom", "collision"]), variations: &[] },
    Emoji { id: 145, emoji: "💫", name: "dizzy", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["dizzy"]), variations: &[] },
    Emoji { id: 146, emoji: "💦", name: "sweat droplets", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["sweat_drops"]), variations: &[] },
    Emoji { id: 147, emoji: "💨", name: "dashing away", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["dash"]), variations: &[] },
    Emoji { id: 148, emoji: "🕳️", name: "hole", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["hole"]), variations: &["🕳"] },
    Emoji { id: 149, emoji: "💣", name: "bomb", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["bomb"]), variations: &[] },
    Emoji { id: 150, emoji: "💬", name: "speech balloon", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["speech_balloon"]), variations: &[] },
    Emoji { id: 151, emoji: "👁️‍🗨️", name: "eye in speech bubble", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["eye_speech_bubble"]), variations: &["👁\u{200d}🗨\u{fe0f}", "👁\u{fe0f}\u{200d}🗨", "👁\u{200d}🗨"] },
    Emoji { id: 152, emoji: "🗨️", name: "left speech bubble", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["left_speech_bubble"]), variations: &["🗨"] },
    Emoji { id: 153, emoji: "🗯️", name: "right anger bubble", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["right_anger_bubble"]), variations: &["🗯"] },
    Emoji { id: 154, emoji: "💭", name: "thought balloon", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["thought_balloon"]), variations: &[] },
    Emoji { id: 155, emoji: "💤", name: "zzz", group: Group::SmileysAndEmotion, skin_tone: None, aliases: Some(&["zzz"]), variations: &[] },
    Emoji { id: 156, emoji: "👋", name: "waving hand", group: Group::PeopleAndBody, skin_tone: Some((156, SkinTone::Default)), aliases: Some(&["wave"]), variations: &[] },
    Emoji { id: 157, emoji: "👋🏻", name: "waving hand: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((156, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 158, emoji: "👋🏼", name: "waving hand: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((156, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 159, emoji: "👋🏽", name: "waving hand: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((156, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 160, emoji: "👋🏾", name: "waving hand: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((156, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 161, emoji: "👋🏿", name: "waving hand: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((156, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 162, emoji: "🤚", name: "raised back of hand", group: Group::PeopleAndBody, skin_tone: Some((162, SkinTone::Default)), aliases: Some(&["raised_back_of_hand"]), variations: &[] },
    Emoji { id: 163, emoji: "🤚🏻", name: "raised back of hand: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((162, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 164, emoji: "🤚🏼", name: "raised back of hand: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((162, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 165, emoji: "🤚🏽", name: "raised back of hand: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((162, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 166, emoji: "🤚🏾", name: "raised back of hand: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((162, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 167, emoji: "🤚🏿", name: "raised back of hand: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((162, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 168, emoji: "🖐️", name: "hand with fingers splayed", group: Group::PeopleAndBody, skin_tone: Some((168, SkinTone::Default)), aliases: Some(&["raised_hand_with_fingers_splayed"]), variations: &["🖐"] },
    Emoji { id: 169, emoji: "🖐🏻", name: "hand with fingers splayed: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((168, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 170, emoji: "🖐🏼", name: "hand with fingers splayed: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((168, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 171, emoji: "🖐🏽", name: "hand with fingers splayed: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((168, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 172, emoji: "🖐🏾", name: "hand with fingers splayed: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((168, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 173, emoji: "🖐🏿", name: "hand with fingers splayed: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((168, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 174, emoji: "✋", name: "raised hand", group: Group::PeopleAndBody, skin_tone: Some((174, SkinTone::Default)), aliases: Some(&["hand", "raised_hand"]), variations: &[] },
    Emoji { id: 175, emoji: "✋🏻", name: "raised hand: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((174, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 176, emoji: "✋🏼", name: "raised hand: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((174, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 177, emoji: "✋🏽", name: "raised hand: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((174, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 178, emoji: "✋🏾", name: "raised hand: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((174, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 179, emoji: "✋🏿", name: "raised hand: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((174, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 180, emoji: "🖖", name: "vulcan salute", group: Group::PeopleAndBody, skin_tone: Some((180, SkinTone::Default)), aliases: Some(&["vulcan_salute"]), variations: &[] },
    Emoji { id: 181, emoji: "🖖🏻", name: "vulcan salute: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((180, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 182, emoji: "🖖🏼", name: "vulcan salute: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((180, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 183, emoji: "🖖🏽", name: "vulcan salute: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((180, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 184, emoji: "🖖🏾", name: "vulcan salute: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((180, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 185, emoji: "🖖🏿", name: "vulcan salute: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((180, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 186, emoji: "👌", name: "OK hand", group: Group::PeopleAndBody, skin_tone: Some((186, SkinTone::Default)), aliases: Some(&["ok_hand"]), variations: &[] },
    Emoji { id: 187, emoji: "👌🏻", name: "OK hand: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((186, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 188, emoji: "👌🏼", name: "OK hand: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((186, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 189, emoji: "👌🏽", name: "OK hand: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((186, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 190, emoji: "👌🏾", name: "OK hand: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((186, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 191, emoji: "👌🏿", name: "OK hand: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((186, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 192, emoji: "🤌", name: "pinched fingers", group: Group::PeopleAndBody, skin_tone: Some((192, SkinTone::Default)), aliases: Some(&["pinched_fingers"]), variations: &[] },
    Emoji { id: 193, emoji: "🤌🏻", name: "pinched fingers: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((192, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 194, emoji: "🤌🏼", name: "pinched fingers: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((192, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 195, emoji: "🤌🏽", name: "pinched fingers: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((192, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 196, emoji: "🤌🏾", name: "pinched fingers: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((192, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 197, emoji: "🤌🏿", name: "pinched fingers: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((192, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 198, emoji: "🤏", name: "pinching hand", group: Group::PeopleAndBody, skin_tone: Some((198, SkinTone::Default)), aliases: Some(&["pinching_hand"]), variations: &[] },
    Emoji { id: 199, emoji: "🤏🏻", name: "pinching hand: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((198, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 200, emoji: "🤏🏼", name: "pinching hand: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((198, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 201, emoji: "🤏🏽", name: "pinching hand: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((198, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 202, emoji: "🤏🏾", name: "pinching hand: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((198, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 203, emoji: "🤏🏿", name: "pinching hand: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((198, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 204, emoji: "✌️", name: "victory hand", group: Group::PeopleAndBody, skin_tone: Some((204, SkinTone::Default)), aliases: Some(&["v"]), variations: &["✌"] },
    Emoji { id: 205, emoji: "✌🏻", name: "victory hand: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((204, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 206, emoji: "✌🏼", name: "victory hand: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((204, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 207, emoji: "✌🏽", name: "victory hand: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((204, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 208, emoji: "✌🏾", name: "victory hand: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((204, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 209, emoji: "✌🏿", name: "victory hand: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((204, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 210, emoji: "🤞", name: "crossed fingers", group: Group::PeopleAndBody, skin_tone: Some((210, SkinTone::Default)), aliases: Some(&["crossed_fingers"]), variations: &[] },
    Emoji { id: 211, emoji: "🤞🏻", name: "crossed fingers: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((210, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 212, emoji: "🤞🏼", name: "crossed fingers: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((210, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 213, emoji: "🤞🏽", name: "crossed fingers: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((210, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 214, emoji: "🤞🏾", name: "crossed fingers: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((210, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 215, emoji: "🤞🏿", name: "crossed fingers: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((210, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 216, emoji: "🤟", name: "love-you gesture", group: Group::PeopleAndBody, skin_tone: Some((216, SkinTone::Default)), aliases: Some(&["love_you_gesture"]), variations: &[] },
    Emoji { id: 217, emoji: "🤟🏻", name: "love-you gesture: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((216, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 218, emoji: "🤟🏼", name: "love-you gesture: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((216, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 219, emoji: "🤟🏽", name: "love-you gesture: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((216, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 220, emoji: "🤟🏾", name: "love-you gesture: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((216, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 221, emoji: "🤟🏿", name: "love-you gesture: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((216, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 222, emoji: "🤘", name: "sign of the horns", group: Group::PeopleAndBody, skin_tone: Some((222, SkinTone::Default)), aliases: Some(&["metal"]), variations: &[] },
    Emoji { id: 223, emoji: "🤘🏻", name: "sign of the horns: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((222, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 224, emoji: "🤘🏼", name: "sign of the horns: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((222, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 225, emoji: "🤘🏽", name: "sign of the horns: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((222, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 226, emoji: "🤘🏾", name: "sign of the horns: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((222, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 227, emoji: "🤘🏿", name: "sign of the horns: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((222, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 228, emoji: "🤙", name: "call me hand", group: Group::PeopleAndBody, skin_tone: Some((228, SkinTone::Default)), aliases: Some(&["call_me_hand"]), variations: &[] },
    Emoji { id: 229, emoji: "🤙🏻", name: "call me hand: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((228, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 230, emoji: "🤙🏼", name: "call me hand: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((228, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 231, emoji: "🤙🏽", name: "call me hand: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((228, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 232, emoji: "🤙🏾", name: "call me hand: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((228, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 233, emoji: "🤙🏿", name: "call me hand: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((228, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 234, emoji: "👈", name: "backhand index pointing left", group: Group::PeopleAndBody, skin_tone: Some((234, SkinTone::Default)), aliases: Some(&["point_left"]), variations: &[] },
    Emoji { id: 235, emoji: "👈🏻", name: "backhand index pointing left: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((234, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 236, emoji: "👈🏼", name: "backhand index pointing left: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((234, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 237, emoji: "👈🏽", name: "backhand index pointing left: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((234, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 238, emoji: "👈🏾", name: "backhand index pointing left: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((234, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 239, emoji: "👈🏿", name: "backhand index pointing left: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((234, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 240, emoji: "👉", name: "backhand index pointing right", group: Group::PeopleAndBody, skin_tone: Some((240, SkinTone::Default)), aliases: Some(&["point_right"]), variations: &[] },
    Emoji { id: 241, emoji: "👉🏻", name: "backhand index pointing right: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((240, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 242, emoji: "👉🏼", name: "backhand index pointing right: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((240, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 243, emoji: "👉🏽", name: "backhand index pointing right: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((240, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 244, emoji: "👉🏾", name: "backhand index pointing right: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((240, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 245, emoji: "👉🏿", name: "backhand index pointing right: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((240, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 246, emoji: "👆", name: "backhand index pointing up", group: Group::PeopleAndBody, skin_tone: Some((246, SkinTone::Default)), aliases: Some(&["point_up_2"]), variations: &[] },
    Emoji { id: 247, emoji: "👆🏻", name: "backhand index pointing up: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((246, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 248, emoji: "👆🏼", name: "backhand index pointing up: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((246, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 249, emoji: "👆🏽", name: "backhand index pointing up: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((246, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 250, emoji: "👆🏾", name: "backhand index pointing up: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((246, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 251, emoji: "👆🏿", name: "backhand index pointing up: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((246, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 252, emoji: "🖕", name: "middle finger", group: Group::PeopleAndBody, skin_tone: Some((252, SkinTone::Default)), aliases: Some(&["middle_finger", "fu"]), variations: &[] },
    Emoji { id: 253, emoji: "🖕🏻", name: "middle finger: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((252, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 254, emoji: "🖕🏼", name: "middle finger: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((252, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 255, emoji: "🖕🏽", name: "middle finger: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((252, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 256, emoji: "🖕🏾", name: "middle finger: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((252, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 257, emoji: "🖕🏿", name: "middle finger: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((252, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 258, emoji: "👇", name: "backhand index pointing down", group: Group::PeopleAndBody, skin_tone: Some((258, SkinTone::Default)), aliases: Some(&["point_down"]), variations: &[] },
    Emoji { id: 259, emoji: "👇🏻", name: "backhand index pointing down: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((258, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 260, emoji: "👇🏼", name: "backhand index pointing down: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((258, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 261, emoji: "👇🏽", name: "backhand index pointing down: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((258, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 262, emoji: "👇🏾", name: "backhand index pointing down: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((258, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 263, emoji: "👇🏿", name: "backhand index pointing down: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((258, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 264, emoji: "☝️", name: "index pointing up", group: Group::PeopleAndBody, skin_tone: Some((264, SkinTone::Default)), aliases: Some(&["point_up"]), variations: &["☝"] },
    Emoji { id: 265, emoji: "☝🏻", name: "index pointing up: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((264, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 266, emoji: "☝🏼", name: "index pointing up: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((264, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 267, emoji: "☝🏽", name: "index pointing up: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((264, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 268, emoji: "☝🏾", name: "index pointing up: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((264, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 269, emoji: "☝🏿", name: "index pointing up: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((264, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 270, emoji: "👍", name: "thumbs up", group: Group::PeopleAndBody, skin_tone: Some((270, SkinTone::Default)), aliases: Some(&["+1", "thumbsup"]), variations: &[] },
    Emoji { id: 271, emoji: "👍🏻", name: "thumbs up: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((270, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 272, emoji: "👍🏼", name: "thumbs up: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((270, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 273, emoji: "👍🏽", name: "thumbs up: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((270, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 274, emoji: "👍🏾", name: "thumbs up: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((270, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 275, emoji: "👍🏿", name: "thumbs up: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((270, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 276, emoji: "👎", name: "thumbs down", group: Group::PeopleAndBody, skin_tone: Some((276, SkinTone::Default)), aliases: Some(&["-1", "thumbsdown"]), variations: &[] },
    Emoji { id: 277, emoji: "👎🏻", name: "thumbs down: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((276, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 278, emoji: "👎🏼", name: "thumbs down: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((276, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 279, emoji: "👎🏽", name: "thumbs down: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((276, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 280, emoji: "👎🏾", name: "thumbs down: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((276, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 281, emoji: "👎🏿", name: "thumbs down: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((276, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 282, emoji: "✊", name: "raised fist", group: Group::PeopleAndBody, skin_tone: Some((282, SkinTone::Default)), aliases: Some(&["fist_raised", "fist"]), variations: &[] },
    Emoji { id: 283, emoji: "✊🏻", name: "raised fist: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((282, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 284, emoji: "✊🏼", name: "raised fist: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((282, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 285, emoji: "✊🏽", name: "raised fist: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((282, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 286, emoji: "✊🏾", name: "raised fist: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((282, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 287, emoji: "✊🏿", name: "raised fist: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((282, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 288, emoji: "👊", name: "oncoming fist", group: Group::PeopleAndBody, skin_tone: Some((288, SkinTone::Default)), aliases: Some(&["fist_oncoming", "facepunch", "punch"]), variations: &[] },
    Emoji { id: 289, emoji: "👊🏻", name: "oncoming fist: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((288, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 290, emoji: "👊🏼", name: "oncoming fist: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((288, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 291, emoji: "👊🏽", name: "oncoming fist: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((288, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 292, emoji: "👊🏾", name: "oncoming fist: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((288, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 293, emoji: "👊🏿", name: "oncoming fist: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((288, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 294, emoji: "🤛", name: "left-facing fist", group: Group::PeopleAndBody, skin_tone: Some((294, SkinTone::Default)), aliases: Some(&["fist_left"]), variations: &[] },
    Emoji { id: 295, emoji: "🤛🏻", name: "left-facing fist: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((294, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 296, emoji: "🤛🏼", name: "left-facing fist: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((294, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 297, emoji: "🤛🏽", name: "left-facing fist: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((294, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 298, emoji: "🤛🏾", name: "left-facing fist: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((294, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 299, emoji: "🤛🏿", name: "left-facing fist: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((294, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 300, emoji: "🤜", name: "right-facing fist", group: Group::PeopleAndBody, skin_tone: Some((300, SkinTone::Default)), aliases: Some(&["fist_right"]), variations: &[] },
    Emoji { id: 301, emoji: "🤜🏻", name: "right-facing fist: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((300, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 302, emoji: "🤜🏼", name: "right-facing fist: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((300, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 303, emoji: "🤜🏽", name: "right-facing fist: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((300, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 304, emoji: "🤜🏾", name: "right-facing fist: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((300, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 305, emoji: "🤜🏿", name: "right-facing fist: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((300, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 306, emoji: "👏", name: "clapping hands", group: Group::PeopleAndBody, skin_tone: Some((306, SkinTone::Default)), aliases: Some(&["clap"]), variations: &[] },
    Emoji { id: 307, emoji: "👏🏻", name: "clapping hands: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((306, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 308, emoji: "👏🏼", name: "clapping hands: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((306, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 309, emoji: "👏🏽", name: "clapping hands: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((306, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 310, emoji: "👏🏾", name: "clapping hands: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((306, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 311, emoji: "👏🏿", name: "clapping hands: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((306, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 312, emoji: "🙌", name: "raising hands", group: Group::PeopleAndBody, skin_tone: Some((312, SkinTone::Default)), aliases: Some(&["raised_hands"]), variations: &[] },
    Emoji { id: 313, emoji: "🙌🏻", name: "raising hands: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((312, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 314, emoji: "🙌🏼", name: "raising hands: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((312, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 315, emoji: "🙌🏽", name: "raising hands: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((312, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 316, emoji: "🙌🏾", name: "raising hands: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((312, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 317, emoji: "🙌🏿", name: "raising hands: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((312, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 318, emoji: "👐", name: "open hands", group: Group::PeopleAndBody, skin_tone: Some((318, SkinTone::Default)), aliases: Some(&["open_hands"]), variations: &[] },
    Emoji { id: 319, emoji: "👐🏻", name: "open hands: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((318, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 320, emoji: "👐🏼", name: "open hands: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((318, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 321, emoji: "👐🏽", name: "open hands: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((318, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 322, emoji: "👐🏾", name: "open hands: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((318, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 323, emoji: "👐🏿", name: "open hands: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((318, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 324, emoji: "🤲", name: "palms up together", group: Group::PeopleAndBody, skin_tone: Some((324, SkinTone::Default)), aliases: Some(&["palms_up_together"]), variations: &[] },
    Emoji { id: 325, emoji: "🤲🏻", name: "palms up together: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((324, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 326, emoji: "🤲🏼", name: "palms up together: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((324, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 327, emoji: "🤲🏽", name: "palms up together: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((324, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 328, emoji: "🤲🏾", name: "palms up together: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((324, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 329, emoji: "🤲🏿", name: "palms up together: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((324, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 330, emoji: "🤝", name: "handshake", group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["handshake"]), variations: &[] },
    Emoji { id: 331, emoji: "🙏", name: "folded hands", group: Group::PeopleAndBody, skin_tone: Some((331, SkinTone::Default)), aliases: Some(&["pray"]), variations: &[] },
    Emoji { id: 332, emoji: "🙏🏻", name: "folded hands: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((331, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 333, emoji: "🙏🏼", name: "folded hands: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((331, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 334, emoji: "🙏🏽", name: "folded hands: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((331, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 335, emoji: "🙏🏾", name: "folded hands: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((331, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 336, emoji: "🙏🏿", name: "folded hands: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((331, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 337, emoji: "✍️", name: "writing hand", group: Group::PeopleAndBody, skin_tone: Some((337, SkinTone::Default)), aliases: Some(&["writing_hand"]), variations: &["✍"] },
    Emoji { id: 338, emoji: "✍🏻", name: "writing hand: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((337, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 339, emoji: "✍🏼", name: "writing hand: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((337, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 340, emoji: "✍🏽", name: "writing hand: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((337, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 341, emoji: "✍🏾", name: "writing hand: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((337, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 342, emoji: "✍🏿", name: "writing hand: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((337, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 343, emoji: "💅", name: "nail polish", group: Group::PeopleAndBody, skin_tone: Some((343, SkinTone::Default)), aliases: Some(&["nail_care"]), variations: &[] },
    Emoji { id: 344, emoji: "💅🏻", name: "nail polish: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((343, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 345, emoji: "💅🏼", name: "nail polish: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((343, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 346, emoji: "💅🏽", name: "nail polish: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((343, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 347, emoji: "💅🏾", name: "nail polish: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((343, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 348, emoji: "💅🏿", name: "nail polish: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((343, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 349, emoji: "🤳", name: "selfie", group: Group::PeopleAndBody, skin_tone: Some((349, SkinTone::Default)), aliases: Some(&["selfie"]), variations: &[] },
    Emoji { id: 350, emoji: "🤳🏻", name: "selfie: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((349, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 351, emoji: "🤳🏼", name: "selfie: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((349, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 352, emoji: "🤳🏽", name: "selfie: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((349, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 353, emoji: "🤳🏾", name: "selfie: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((349, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 354, emoji: "🤳🏿", name: "selfie: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((349, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 355, emoji: "💪", name: "flexed biceps", group: Group::PeopleAndBody, skin_tone: Some((355, SkinTone::Default)), aliases: Some(&["muscle"]), variations: &[] },
    Emoji { id: 356, emoji: "💪🏻", name: "flexed biceps: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((355, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 357, emoji: "💪🏼", name: "flexed biceps: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((355, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 358, emoji: "💪🏽", name: "flexed biceps: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((355, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 359, emoji: "💪🏾", name: "flexed biceps: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((355, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 360, emoji: "💪🏿", name: "flexed biceps: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((355, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 361, emoji: "🦾", name: "mechanical arm", group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["mechanical_arm"]), variations: &[] },
    Emoji { id: 362, emoji: "🦿", name: "mechanical leg", group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["mechanical_leg"]), variations: &[] },
    Emoji { id: 363, emoji: "🦵", name: "leg", group: Group::PeopleAndBody, skin_tone: Some((363, SkinTone::Default)), aliases: Some(&["leg"]), variations: &[] },
    Emoji { id: 364, emoji: "🦵🏻", name: "leg: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((363, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 365, emoji: "🦵🏼", name: "leg: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((363, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 366, emoji: "🦵🏽", name: "leg: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((363, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 367, emoji: "🦵🏾", name: "leg: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((363, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 368, emoji: "🦵🏿", name: "leg: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((363, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 369, emoji: "🦶", name: "foot", group: Group::PeopleAndBody, skin_tone: Some((369, SkinTone::Default)), aliases: Some(&["foot"]), variations: &[] },
    Emoji { id: 370, emoji: "🦶🏻", name: "foot: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((369, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 371, emoji: "🦶🏼", name: "foot: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((369, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 372, emoji: "🦶🏽", name: "foot: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((369, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 373, emoji: "🦶🏾", name: "foot: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((369, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 374, emoji: "🦶🏿", name: "foot: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((369, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 375, emoji: "👂", name: "ear", group: Group::PeopleAndBody, skin_tone: Some((375, SkinTone::Default)), aliases: Some(&["ear"]), variations: &[] },
    Emoji { id: 376, emoji: "👂🏻", name: "ear: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((375, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 377, emoji: "👂🏼", name: "ear: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((375, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 378, emoji: "👂🏽", name: "ear: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((375, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 379, emoji: "👂🏾", name: "ear: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((375, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 380, emoji: "👂🏿", name: "ear: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((375, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 381, emoji: "🦻", name: "ear with hearing aid", group: Group::PeopleAndBody, skin_tone: Some((381, SkinTone::Default)), aliases: Some(&["ear_with_hearing_aid"]), variations: &[] },
    Emoji { id: 382, emoji: "🦻🏻", name: "ear with hearing aid: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((381, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 383, emoji: "🦻🏼", name: "ear with hearing aid: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((381, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 384, emoji: "🦻🏽", name: "ear with hearing aid: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((381, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 385, emoji: "🦻🏾", name: "ear with hearing aid: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((381, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 386, emoji: "🦻🏿", name: "ear with hearing aid: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((381, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 387, emoji: "👃", name: "nose", group: Group::PeopleAndBody, skin_tone: Some((387, SkinTone::Default)), aliases: Some(&["nose"]), variations: &[] },
    Emoji { id: 388, emoji: "👃🏻", name: "nose: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((387, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 389, emoji: "👃🏼", name: "nose: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((387, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 390, emoji: "👃🏽", name: "nose: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((387, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 391, emoji: "👃🏾", name: "nose: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((387, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 392, emoji: "👃🏿", name: "nose: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((387, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 393, emoji: "🧠", name: "brain", group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["brain"]), variations: &[] },
    Emoji { id: 394, emoji: "🫀", name: "anatomical heart", group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["anatomical_heart"]), variations: &[] },
    Emoji { id: 395, emoji: "🫁", name: "lungs", group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["lungs"]), variations: &[] },
    Emoji { id: 396, emoji: "🦷", name: "tooth", group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["tooth"]), variations: &[] },
    Emoji { id: 397, emoji: "🦴", name: "bone", group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["bone"]), variations: &[] },
    Emoji { id: 398, emoji: "👀", name: "eyes", group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["eyes"]), variations: &[] },
    Emoji { id: 399, emoji: "👁️", name: "eye", group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["eye"]), variations: &["👁"] },
    Emoji { id: 400, emoji: "👅", name: "tongue", group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["tongue"]), variations: &[] },
    Emoji { id: 401, emoji: "👄", name: "mouth", group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["lips"]), variations: &[] },
    Emoji { id: 402, emoji: "👶", name: "baby", group: Group::PeopleAndBody, skin_tone: Some((402, SkinTone::Default)), aliases: Some(&["baby"]), variations: &[] },
    Emoji { id: 403, emoji: "👶🏻", name: "baby: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((402, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 404, emoji: "👶🏼", name: "baby: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((402, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 405, emoji: "👶🏽", name: "baby: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((402, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 406, emoji: "👶🏾", name: "baby: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((402, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 407, emoji: "👶🏿", name: "baby: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((402, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 408, emoji: "🧒", name: "child", group: Group::PeopleAndBody, skin_tone: Some((408, SkinTone::Default)), aliases: Some(&["child"]), variations: &[] },
    Emoji { id: 409, emoji: "🧒🏻", name: "child: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((408, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 410, emoji: "🧒🏼", name: "child: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((408, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 411, emoji: "🧒🏽", name: "child: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((408, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 412, emoji: "🧒🏾", name: "child: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((408, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 413, emoji: "🧒🏿", name: "child: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((408, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 414, emoji: "👦", name: "boy", group: Group::PeopleAndBody, skin_tone: Some((414, SkinTone::Default)), aliases: Some(&["boy"]), variations: &[] },
    Emoji { id: 415, emoji: "👦🏻", name: "boy: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((414, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 416, emoji: "👦🏼", name: "boy: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((414, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 417, emoji: "👦🏽", name: "boy: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((414, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 418, emoji: "👦🏾", name: "boy: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((414, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 419, emoji: "👦🏿", name: "boy: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((414, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 420, emoji: "👧", name: "girl", group: Group::PeopleAndBody, skin_tone: Some((420, SkinTone::Default)), aliases: Some(&["girl"]), variations: &[] },
    Emoji { id: 421, emoji: "👧🏻", name: "girl: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((420, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 422, emoji: "👧🏼", name: "girl: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((420, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 423, emoji: "👧🏽", name: "girl: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((420, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 424, emoji: "👧🏾", name: "girl: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((420, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 425, emoji: "👧🏿", name: "girl: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((420, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 426, emoji: "🧑", name: "person", group: Group::PeopleAndBody, skin_tone: Some((426, SkinTone::Default)), aliases: Some(&["adult"]), variations: &[] },
    Emoji { id: 427, emoji: "🧑🏻", name: "person: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((426, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 428, emoji: "🧑🏼", name: "person: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((426, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 429, emoji: "🧑🏽", name: "person: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((426, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 430, emoji: "🧑🏾", name: "person: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((426, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 431, emoji: "🧑🏿", name: "person: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((426, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 432, emoji: "👱", name: "person: blond hair", group: Group::PeopleAndBody, skin_tone: Some((432, SkinTone::Default)), aliases: Some(&["blond_haired_person"]), variations: &[] },
    Emoji { id: 433, emoji: "👱🏻", name: "person: light skin tone, blond hair", group: Group::PeopleAndBody, skin_tone: Some((432, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 434, emoji: "👱🏼", name: "person: medium-light skin tone, blond hair", group: Group::PeopleAndBody, skin_tone: Some((432, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 435, emoji: "👱🏽", name: "person: medium skin tone, blond hair", group: Group::PeopleAndBody, skin_tone: Some((432, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 436, emoji: "👱🏾", name: "person: medium-dark skin tone, blond hair", group: Group::PeopleAndBody, skin_tone: Some((432, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 437, emoji: "👱🏿", name: "person: dark skin tone, blond hair", group: Group::PeopleAndBody, skin_tone: Some((432, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 438, emoji: "👨", name: "man", group: Group::PeopleAndBody, skin_tone: Some((438, SkinTone::Default)), aliases: Some(&["man"]), variations: &[] },
    Emoji { id: 439, emoji: "👨🏻", name: "man: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((438, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 440, emoji: "👨🏼", name: "man: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((438, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 441, emoji: "👨🏽", name: "man: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((438, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 442, emoji: "👨🏾", name: "man: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((438, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 443, emoji: "👨🏿", name: "man: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((438, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 444, emoji: "🧔", name: "person: beard", group: Group::PeopleAndBody, skin_tone: Some((444, SkinTone::Default)), aliases: Some(&["bearded_person"]), variations: &[] },
    Emoji { id: 445, emoji: "🧔🏻", name: "person: light skin tone, beard", group: Group::PeopleAndBody, skin_tone: Some((444, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 446, emoji: "🧔🏼", name: "person: medium-light skin tone, beard", group: Group::PeopleAndBody, skin_tone: Some((444, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 447, emoji: "🧔🏽", name: "person: medium skin tone, beard", group: Group::PeopleAndBody, skin_tone: Some((444, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 448, emoji: "🧔🏾", name: "person: medium-dark skin tone, beard", group: Group::PeopleAndBody, skin_tone: Some((444, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 449, emoji: "🧔🏿", name: "person: dark skin tone, beard", group: Group::PeopleAndBody, skin_tone: Some((444, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 450, emoji: "🧔‍♂️", name: "man: beard", group: Group::PeopleAndBody, skin_tone: Some((450, SkinTone::Default)), aliases: None, variations: &["🧔\u{200d}♂"] },
    Emoji { id: 451, emoji: "🧔🏻‍♂️", name: "man: light skin tone, beard", group: Group::PeopleAndBody, skin_tone: Some((450, SkinTone::Light)), aliases: None, variations: &["🧔🏻\u{200d}♂"] },
    Emoji { id: 452, emoji: "🧔🏼‍♂️", name: "man: medium-light skin tone, beard", group: Group::PeopleAndBody, skin_tone: Some((450, SkinTone::MediumLight)), aliases: None, variations: &["🧔🏼\u{200d}♂"] },
    Emoji { id: 453, emoji: "🧔🏽‍♂️", name: "man: medium skin tone, beard", group: Group::PeopleAndBody, skin_tone: Some((450, SkinTone::Medium)), aliases: None, variations: &["🧔🏽\u{200d}♂"] },
    Emoji { id: 454, emoji: "🧔🏾‍♂️", name: "man: medium-dark skin tone, beard", group: Group::PeopleAndBody, skin_tone: Some((450, SkinTone::MediumDark)), aliases: None, variations: &["🧔🏾\u{200d}♂"] },
    Emoji { id: 455, emoji: "🧔🏿‍♂️", name: "man: dark skin tone, beard", group: Group::PeopleAndBody, skin_tone: Some((450, SkinTone::Dark)), aliases: None, variations: &["🧔🏿\u{200d}♂"] },
    Emoji { id: 456, emoji: "🧔‍♀️", name: "woman: beard", group: Group::PeopleAndBody, skin_tone: Some((456, SkinTone::Default)), aliases: None, variations: &["🧔\u{200d}♀"] },
    Emoji { id: 457, emoji: "🧔🏻‍♀️", name: "woman: light skin tone, beard", group: Group::PeopleAndBody, skin_tone: Some((456, SkinTone::Light)), aliases: None, variations: &["🧔🏻\u{200d}♀"] },
    Emoji { id: 458, emoji: "🧔🏼‍♀️", name: "woman: medium-light skin tone, beard", group: Group::PeopleAndBody, skin_tone: Some((456, SkinTone::MediumLight)), aliases: None, variations: &["🧔🏼\u{200d}♀"] },
    Emoji { id: 459, emoji: "🧔🏽‍♀️", name: "woman: medium skin tone, beard", group: Group::PeopleAndBody, skin_tone: Some((456, SkinTone::Medium)), aliases: None, variations: &["🧔🏽\u{200d}♀"] },
    Emoji { id: 460, emoji: "🧔🏾‍♀️", name: "woman: medium-dark skin tone, beard", group: Group::PeopleAndBody, skin_tone: Some((456, SkinTone::MediumDark)), aliases: None, variations: &["🧔🏾\u{200d}♀"] },
    Emoji { id: 461, emoji: "🧔🏿‍♀️", name: "woman: dark skin tone, beard", group: Group::PeopleAndBody, skin_tone: Some((456, SkinTone::Dark)), aliases: None, variations: &["🧔🏿\u{200d}♀"] },
    Emoji { id: 462, emoji: "👨‍🦰", name: "man: red hair", group: Group::PeopleAndBody, skin_tone: Some((462, SkinTone::Default)), aliases: Some(&["red_haired_man"]), variations: &[] },
    Emoji { id: 463, emoji: "👨🏻‍🦰", name: "man: light skin tone, red hair", group: Group::PeopleAndBody, skin_tone: Some((462, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 464, emoji: "👨🏼‍🦰", name: "man: medium-light skin tone, red hair", group: Group::PeopleAndBody, skin_tone: Some((462, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 465, emoji: "👨🏽‍🦰", name: "man: medium skin tone, red hair", group: Group::PeopleAndBody, skin_tone: Some((462, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 466, emoji: "👨🏾‍🦰", name: "man: medium-dark skin tone, red hair", group: Group::PeopleAndBody, skin_tone: Some((462, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 467, emoji: "👨🏿‍🦰", name: "man: dark skin tone, red hair", group: Group::PeopleAndBody, skin_tone: Some((462, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 468, emoji: "👨‍🦱", name: "man: curly hair", group: Group::PeopleAndBody, skin_tone: Some((468, SkinTone::Default)), aliases: Some(&["curly_haired_man"]), variations: &[] },
    Emoji { id: 469, emoji: "👨🏻‍🦱", name: "man: light skin tone, curly hair", group: Group::PeopleAndBody, skin_tone: Some((468, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 470, emoji: "👨🏼‍🦱", name: "man: medium-light skin tone, curly hair", group: Group::PeopleAndBody, skin_tone: Some((468, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 471, emoji: "👨🏽‍🦱", name: "man: medium skin tone, curly hair", group: Group::PeopleAndBody, skin_tone: Some((468, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 472, emoji: "👨🏾‍🦱", name: "man: medium-dark skin tone, curly hair", group: Group::PeopleAndBody, skin_tone: Some((468, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 473, emoji: "👨🏿‍🦱", name: "man: dark skin tone, curly hair", group: Group::PeopleAndBody, skin_tone: Some((468, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 474, emoji: "👨‍🦳", name: "man: white hair", group: Group::PeopleAndBody, skin_tone: Some((474, SkinTone::Default)), aliases: Some(&["white_haired_man"]), variations: &[] },
    Emoji { id: 475, emoji: "👨🏻‍🦳", name: "man: light skin tone, white hair", group: Group::PeopleAndBody, skin_tone: Some((474, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 476, emoji: "👨🏼‍🦳", name: "man: medium-light skin tone, white hair", group: Group::PeopleAndBody, skin_tone: Some((474, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 477, emoji: "👨🏽‍🦳", name: "man: medium skin tone, white hair", group: Group::PeopleAndBody, skin_tone: Some((474, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 478, emoji: "👨🏾‍🦳", name: "man: medium-dark skin tone, white hair", group: Group::PeopleAndBody, skin_tone: Some((474, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 479, emoji: "👨🏿‍🦳", name: "man: dark skin tone, white hair", group: Group::PeopleAndBody, skin_tone: Some((474, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 480, emoji: "👨‍🦲", name: "man: bald", group: Group::PeopleAndBody, skin_tone: Some((480, SkinTone::Default)), aliases: Some(&["bald_man"]), variations: &[] },
    Emoji { id: 481, emoji: "👨🏻‍🦲", name: "man: light skin tone, bald", group: Group::PeopleAndBody, skin_tone: Some((480, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 482, emoji: "👨🏼‍🦲", name: "man: medium-light skin tone, bald", group: Group::PeopleAndBody, skin_tone: Some((480, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 483, emoji: "👨🏽‍🦲", name: "man: medium skin tone, bald", group: Group::PeopleAndBody, skin_tone: Some((480, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 484, emoji: "👨🏾‍🦲", name: "man: medium-dark skin tone, bald", group: Group::PeopleAndBody, skin_tone: Some((480, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 485, emoji: "👨🏿‍🦲", name: "man: dark skin tone, bald", group: Group::PeopleAndBody, skin_tone: Some((480, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 486, emoji: "👩", name: "woman", group: Group::PeopleAndBody, skin_tone: Some((486, SkinTone::Default)), aliases: Some(&["woman"]), variations: &[] },
    Emoji { id: 487, emoji: "👩🏻", name: "woman: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((486, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 488, emoji: "👩🏼", name: "woman: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((486, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 489, emoji: "👩🏽", name: "woman: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((486, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 490, emoji: "👩🏾", name: "woman: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((486, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 491, emoji: "👩🏿", name: "woman: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((486, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 492, emoji: "👩‍🦰", name: "woman: red hair", group: Group::PeopleAndBody, skin_tone: Some((492, SkinTone::Default)), aliases: Some(&["red_haired_woman"]), variations: &[] },
    Emoji { id: 493, emoji: "👩🏻‍🦰", name: "woman: light skin tone, red hair", group: Group::PeopleAndBody, skin_tone: Some((492, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 494, emoji: "👩🏼‍🦰", name: "woman: medium-light skin tone, red hair", group: Group::PeopleAndBody, skin_tone: Some((492, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 495, emoji: "👩🏽‍🦰", name: "woman: medium skin tone, red hair", group: Group::PeopleAndBody, skin_tone: Some((492, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 496, emoji: "👩🏾‍🦰", name: "woman: medium-dark skin tone, red hair", group: Group::PeopleAndBody, skin_tone: Some((492, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 497, emoji: "👩🏿‍🦰", name: "woman: dark skin tone, red hair", group: Group::PeopleAndBody, skin_tone: Some((492, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 498, emoji: "🧑‍🦰", name: "person: red hair", group: Group::PeopleAndBody, skin_tone: Some((498, SkinTone::Default)), aliases: Some(&["person_red_hair"]), variations: &[] },
    Emoji { id: 499, emoji: "🧑🏻‍🦰", name: "person: light skin tone, red hair", group: Group::PeopleAndBody, skin_tone: Some((498, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 500, emoji: "🧑🏼‍🦰", name: "person: medium-light skin tone, red hair", group: Group::PeopleAndBody, skin_tone: Some((498, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 501, emoji: "🧑🏽‍🦰", name: "person: medium skin tone, red hair", group: Group::PeopleAndBody, skin_tone: Some((498, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 502, emoji: "🧑🏾‍🦰", name: "person: medium-dark skin tone, red hair", group: Group::PeopleAndBody, skin_tone: Some((498, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 503, emoji: "🧑🏿‍🦰", name: "person: dark skin tone, red hair", group: Group::PeopleAndBody, skin_tone: Some((498, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 504, emoji: "👩‍🦱", name: "woman: curly hair", group: Group::PeopleAndBody, skin_tone: Some((504, SkinTone::Default)), aliases: Some(&["curly_haired_woman"]), variations: &[] },
    Emoji { id: 505, emoji: "👩🏻‍🦱", name: "woman: light skin tone, curly hair", group: Group::PeopleAndBody, skin_tone: Some((504, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 506, emoji: "👩🏼‍🦱", name: "woman: medium-light skin tone, curly hair", group: Group::PeopleAndBody, skin_tone: Some((504, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 507, emoji: "👩🏽‍🦱", name: "woman: medium skin tone, curly hair", group: Group::PeopleAndBody, skin_tone: Some((504, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 508, emoji: "👩🏾‍🦱", name: "woman: medium-dark skin tone, curly hair", group: Group::PeopleAndBody, skin_tone: Some((504, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 509, emoji: "👩🏿‍🦱", name: "woman: dark skin tone, curly hair", group: Group::PeopleAndBody, skin_tone: Some((504, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 510, emoji: "🧑‍🦱", name: "person: curly hair", group: Group::PeopleAndBody, skin_tone: Some((510, SkinTone::Default)), aliases: Some(&["person_curly_hair"]), variations: &[] },
    Emoji { id: 511, emoji: "🧑🏻‍🦱", name: "person: light skin tone, curly hair", group: Group::PeopleAndBody, skin_tone: Some((510, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 512, emoji: "🧑🏼‍🦱", name: "person: medium-light skin tone, curly hair", group: Group::PeopleAndBody, skin_tone: Some((510, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 513, emoji: "🧑🏽‍🦱", name: "person: medium skin tone, curly hair", group: Group::PeopleAndBody, skin_tone: Some((510, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 514, emoji: "🧑🏾‍🦱", name: "person: medium-dark skin tone, curly hair", group: Group::PeopleAndBody, skin_tone: Some((510, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 515, emoji: "🧑🏿‍🦱", name: "person: dark skin tone, curly hair", group: Group::PeopleAndBody, skin_tone: Some((510, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 516, emoji: "👩‍🦳", name: "woman: white hair", group: Group::PeopleAndBody, skin_tone: Some((516, SkinTone::Default)), aliases: Some(&["white_haired_woman"]), variations: &[] },
    Emoji { id: 517, emoji: "👩🏻‍🦳", name: "woman: light skin tone, white hair", group: Group::PeopleAndBody, skin_tone: Some((516, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 518, emoji: "👩🏼‍🦳", name: "woman: medium-light skin tone, white hair", group: Group::PeopleAndBody, skin_tone: Some((516, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 519, emoji: "👩🏽‍🦳", name: "woman: medium skin tone, white hair", group: Group::PeopleAndBody, skin_tone: Some((516, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 520, emoji: "👩🏾‍🦳", name: "woman: medium-dark skin tone, white hair", group: Group::PeopleAndBody, skin_tone: Some((516, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 521, emoji: "👩🏿‍🦳", name: "woman: dark skin tone, white hair", group: Group::PeopleAndBody, skin_tone: Some((516, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 522, emoji: "🧑‍🦳", name: "person: white hair", group: Group::PeopleAndBody, skin_tone: Some((522, SkinTone::Default)), aliases: Some(&["person_white_hair"]), variations: &[] },
    Emoji { id: 523, emoji: "🧑🏻‍🦳", name: "person: light skin tone, white hair", group: Group::PeopleAndBody, skin_tone: Some((522, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 524, emoji: "🧑🏼‍🦳", name: "person: medium-light skin tone, white hair", group: Group::PeopleAndBody, skin_tone: Some((522, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 525, emoji: "🧑🏽‍🦳", name: "person: medium skin tone, white hair", group: Group::PeopleAndBody, skin_tone: Some((522, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 526, emoji: "🧑🏾‍🦳", name: "person: medium-dark skin tone, white hair", group: Group::PeopleAndBody, skin_tone: Some((522, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 527, emoji: "🧑🏿‍🦳", name: "person: dark skin tone, white hair", group: Group::PeopleAndBody, skin_tone: Some((522, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 528, emoji: "👩‍🦲", name: "woman: bald", group: Group::PeopleAndBody, skin_tone: Some((528, SkinTone::Default)), aliases: Some(&["bald_woman"]), variations: &[] },
    Emoji { id: 529, emoji: "👩🏻‍🦲", name: "woman: light skin tone, bald", group: Group::PeopleAndBody, skin_tone: Some((528, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 530, emoji: "👩🏼‍🦲", name: "woman: medium-light skin tone, bald", group: Group::PeopleAndBody, skin_tone: Some((528, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 531, emoji: "👩🏽‍🦲", name: "woman: medium skin tone, bald", group: Group::PeopleAndBody, skin_tone: Some((528, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 532, emoji: "👩🏾‍🦲", name: "woman: medium-dark skin tone, bald", group: Group::PeopleAndBody, skin_tone: Some((528, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 533, emoji: "👩🏿‍🦲", name: "woman: dark skin tone, bald", group: Group::PeopleAndBody, skin_tone: Some((528, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 534, emoji: "🧑‍🦲", name: "person: bald", group: Group::PeopleAndBody, skin_tone: Some((534, SkinTone::Default)), aliases: Some(&["person_bald"]), variations: &[] },
    Emoji { id: 535, emoji: "🧑🏻‍🦲", name: "person: light skin tone, bald", group: Group::PeopleAndBody, skin_tone: Some((534, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 536, emoji: "🧑🏼‍🦲", name: "person: medium-light skin tone, bald", group: Group::PeopleAndBody, skin_tone: Some((534, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 537, emoji: "🧑🏽‍🦲", name: "person: medium skin tone, bald", group: Group::PeopleAndBody, skin_tone: Some((534, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 538, emoji: "🧑🏾‍🦲", name: "person: medium-dark skin tone, bald", group: Group::PeopleAndBody, skin_tone: Some((534, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 539, emoji: "🧑🏿‍🦲", name: "person: dark skin tone, bald", group: Group::PeopleAndBody, skin_tone: Some((534, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 540, emoji: "👱‍♀️", name: "woman: blond hair", group: Group::PeopleAndBody, skin_tone: Some((540, SkinTone::Default)), aliases: Some(&["blond_haired_woman", "blonde_woman"]), variations: &["👱\u{200d}♀"] },
    Emoji { id: 541, emoji: "👱🏻‍♀️", name: "woman: light skin tone, blond hair", group: Group::PeopleAndBody, skin_tone: Some((540, SkinTone::Light)), aliases: None, variations: &["👱🏻\u{200d}♀"] },
    Emoji { id: 542, emoji: "👱🏼‍♀️", name: "woman: medium-light skin tone, blond hair", group: Group::PeopleAndBody, skin_tone: Some((540, SkinTone::MediumLight)), aliases: None, variations: &["👱🏼\u{200d}♀"] },
    Emoji { id: 543, emoji: "👱🏽‍♀️", name: "woman: medium skin tone, blond hair", group: Group::PeopleAndBody, skin_tone: Some((540, SkinTone::Medium)), aliases: None, variations: &["👱🏽\u{200d}♀"] },
    Emoji { id: 544, emoji: "👱🏾‍♀️", name: "woman: medium-dark skin tone, blond hair", group: Group::PeopleAndBody, skin_tone: Some((540, SkinTone::MediumDark)), aliases: None, variations: &["👱🏾\u{200d}♀"] },
    Emoji { id: 545, emoji: "👱🏿‍♀️", name: "woman: dark skin tone, blond hair", group: Group::PeopleAndBody, skin_tone: Some((540, SkinTone::Dark)), aliases: None, variations: &["👱🏿\u{200d}♀"] },
    Emoji { id: 546, emoji: "👱‍♂️", name: "man: blond hair", group: Group::PeopleAndBody, skin_tone: Some((546, SkinTone::Default)), aliases: Some(&["blond_haired_man"]), variations: &["👱\u{200d}♂"] },
    Emoji { id: 547, emoji: "👱🏻‍♂️", name: "man: light skin tone, blond hair", group: Group::PeopleAndBody, skin_tone: Some((546, SkinTone::Light)), aliases: None, variations: &["👱🏻\u{200d}♂"] },
    Emoji { id: 548, emoji: "👱🏼‍♂️", name: "man: medium-light skin tone, blond hair", group: Group::PeopleAndBody, skin_tone: Some((546, SkinTone::MediumLight)), aliases: None, variations: &["👱🏼\u{200d}♂"] },
    Emoji { id: 549, emoji: "👱🏽‍♂️", name: "man: medium skin tone, blond hair", group: Group::PeopleAndBody, skin_tone: Some((546, SkinTone::Medium)), aliases: None, variations: &["👱🏽\u{200d}♂"] },
    Emoji { id: 550, emoji: "👱🏾‍♂️", name: "man: medium-dark skin tone, blond hair", group: Group::PeopleAndBody, skin_tone: Some((546, SkinTone::MediumDark)), aliases: None, variations: &["👱🏾\u{200d}♂"] },
    Emoji { id: 551, emoji: "👱🏿‍♂️", name: "man: dark skin tone, blond hair", group: Group::PeopleAndBody, skin_tone: Some((546, SkinTone::Dark)), aliases: None, variations: &["👱🏿\u{200d}♂"] },
    Emoji { id: 552, emoji: "🧓", name: "older person", group: Group::PeopleAndBody, skin_tone: Some((552, SkinTone::Default)), aliases: Some(&["older_adult"]), variations: &[] },
    Emoji { id: 553, emoji: "🧓🏻", name: "older person: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((552, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 554, emoji: "🧓🏼", name: "older person: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((552, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 555, emoji: "🧓🏽", name: "older person: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((552, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 556, emoji: "🧓🏾", name: "older person: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((552, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 557, emoji: "🧓🏿", name: "older person: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((552, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 558, emoji: "👴", name: "old man", group: Group::PeopleAndBody, skin_tone: Some((558, SkinTone::Default)), aliases: Some(&["older_man"]), variations: &[] },
    Emoji { id: 559, emoji: "👴🏻", name: "old man: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((558, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 560, emoji: "👴🏼", name: "old man: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((558, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 561, emoji: "👴🏽", name: "old man: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((558, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 562, emoji: "👴🏾", name: "old man: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((558, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 563, emoji: "👴🏿", name: "old man: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((558, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 564, emoji: "👵", name: "old woman", group: Group::PeopleAndBody, skin_tone: Some((564, SkinTone::Default)), aliases: Some(&["older_woman"]), variations: &[] },
    Emoji { id: 565, emoji: "👵🏻", name: "old woman: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((564, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 566, emoji: "👵🏼", name: "old woman: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((564, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 567, emoji: "👵🏽", name: "old woman: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((564, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 568, emoji: "👵🏾", name: "old woman: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((564, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 569, emoji: "👵🏿", name: "old woman: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((564, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 570, emoji: "🙍", name: "person frowning", group: Group::PeopleAndBody, skin_tone: Some((570, SkinTone::Default)), aliases: Some(&["frowning_person"]), variations: &[] },
    Emoji { id: 571, emoji: "🙍🏻", name: "person frowning: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((570, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 572, emoji: "🙍🏼", name: "person frowning: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((570, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 573, emoji: "🙍🏽", name: "person frowning: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((570, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 574, emoji: "🙍🏾", name: "person frowning: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((570, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 575, emoji: "🙍🏿", name: "person frowning: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((570, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 576, emoji: "🙍‍♂️", name: "man frowning", group: Group::PeopleAndBody, skin_tone: Some((576, SkinTone::Default)), aliases: Some(&["frowning_man"]), variations: &["🙍\u{200d}♂"] },
    Emoji { id: 577, emoji: "🙍🏻‍♂️", name: "man frowning: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((576, SkinTone::Light)), aliases: None, variations: &["🙍🏻\u{200d}♂"] },
    Emoji { id: 578, emoji: "🙍🏼‍♂️", name: "man frowning: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((576, SkinTone::MediumLight)), aliases: None, variations: &["🙍🏼\u{200d}♂"] },
    Emoji { id: 579, emoji: "🙍🏽‍♂️", name: "man frowning: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((576, SkinTone::Medium)), aliases: None, variations: &["🙍🏽\u{200d}♂"] },
    Emoji { id: 580, emoji: "🙍🏾‍♂️", name: "man frowning: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((576, SkinTone::MediumDark)), aliases: None, variations: &["🙍🏾\u{200d}♂"] },
    Emoji { id: 581, emoji: "🙍🏿‍♂️", name: "man frowning: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((576, SkinTone::Dark)), aliases: None, variations: &["🙍🏿\u{200d}♂"] },
    Emoji { id: 582, emoji: "🙍‍♀️", name: "woman frowning", group: Group::PeopleAndBody, skin_tone: Some((582, SkinTone::Default)), aliases: Some(&["frowning_woman"]), variations: &["🙍\u{200d}♀"] },
    Emoji { id: 583, emoji: "🙍🏻‍♀️", name: "woman frowning: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((582, SkinTone::Light)), aliases: None, variations: &["🙍🏻\u{200d}♀"] },
    Emoji { id: 584, emoji: "🙍🏼‍♀️", name: "woman frowning: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((582, SkinTone::MediumLight)), aliases: None, variations: &["🙍🏼\u{200d}♀"] },
    Emoji { id: 585, emoji: "🙍🏽‍♀️", name: "woman frowning: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((582, SkinTone::Medium)), aliases: None, variations: &["🙍🏽\u{200d}♀"] },
    Emoji { id: 586, emoji: "🙍🏾‍♀️", name: "woman frowning: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((582, SkinTone::MediumDark)), aliases: None, variations: &["🙍🏾\u{200d}♀"] },
    Emoji { id: 587, emoji: "🙍🏿‍♀️", name: "woman frowning: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((582, SkinTone::Dark)), aliases: None, variations: &["🙍🏿\u{200d}♀"] },
    Emoji { id: 588, emoji: "🙎", name: "person pouting", group: Group::PeopleAndBody, skin_tone: Some((588, SkinTone::Default)), aliases: Some(&["pouting_face"]), variations: &[] },
    Emoji { id: 589, emoji: "🙎🏻", name: "person pouting: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((588, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 590, emoji: "🙎🏼", name: "person pouting: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((588, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 591, emoji: "🙎🏽", name: "person pouting: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((588, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 592, emoji: "🙎🏾", name: "person pouting: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((588, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 593, emoji: "🙎🏿", name: "person pouting: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((588, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 594, emoji: "🙎‍♂️", name: "man pouting", group: Group::PeopleAndBody, skin_tone: Some((594, SkinTone::Default)), aliases: Some(&["pouting_man"]), variations: &["🙎\u{200d}♂"] },
    Emoji { id: 595, emoji: "🙎🏻‍♂️", name: "man pouting: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((594, SkinTone::Light)), aliases: None, variations: &["🙎🏻\u{200d}♂"] },
    Emoji { id: 596, emoji: "🙎🏼‍♂️", name: "man pouting: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((594, SkinTone::MediumLight)), aliases: None, variations: &["🙎🏼\u{200d}♂"] },
    Emoji { id: 597, emoji: "🙎🏽‍♂️", name: "man pouting: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((594, SkinTone::Medium)), aliases: None, variations: &["🙎🏽\u{200d}♂"] },
    Emoji { id: 598, emoji: "🙎🏾‍♂️", name: "man pouting: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((594, SkinTone::MediumDark)), aliases: None, variations: &["🙎🏾\u{200d}♂"] },
    Emoji { id: 599, emoji: "🙎🏿‍♂️", name: "man pouting: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((594, SkinTone::Dark)), aliases: None, variations: &["🙎🏿\u{200d}♂"] },
    Emoji { id: 600, emoji: "🙎‍♀️", name: "woman pouting", group: Group::PeopleAndBody, skin_tone: Some((600, SkinTone::Default)), aliases: Some(&["pouting_woman"]), variations: &["🙎\u{200d}♀"] },
    Emoji { id: 601, emoji: "🙎🏻‍♀️", name: "woman pouting: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((600, SkinTone::Light)), aliases: None, variations: &["🙎🏻\u{200d}♀"] },
    Emoji { id: 602, emoji: "🙎🏼‍♀️", name: "woman pouting: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((600, SkinTone::MediumLight)), aliases: None, variations: &["🙎🏼\u{200d}♀"] },
    Emoji { id: 603, emoji: "🙎🏽‍♀️", name: "woman pouting: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((600, SkinTone::Medium)), aliases: None, variations: &["🙎🏽\u{200d}♀"] },
    Emoji { id: 604, emoji: "🙎🏾‍♀️", name: "woman pouting: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((600, SkinTone::MediumDark)), aliases: None, variations: &["🙎🏾\u{200d}♀"] },
    Emoji { id: 605, emoji: "🙎🏿‍♀️", name: "woman pouting: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((600, SkinTone::Dark)), aliases: None, variations: &["🙎🏿\u{200d}♀"] },
    Emoji { id: 606, emoji: "🙅", name: "person gesturing NO", group: Group::PeopleAndBody, skin_tone: Some((606, SkinTone::Default)), aliases: Some(&["no_good"]), variations: &[] },
    Emoji { id: 607, emoji: "🙅🏻", name: "person gesturing NO: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((606, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 608, emoji: "🙅🏼", name: "person gesturing NO: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((606, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 609, emoji: "🙅🏽", name: "person gesturing NO: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((606, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 610, emoji: "🙅🏾", name: "person gesturing NO: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((606, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 611, emoji: "🙅🏿", name: "person gesturing NO: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((606, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 612, emoji: "🙅‍♂️", name: "man gesturing NO", group: Group::PeopleAndBody, skin_tone: Some((612, SkinTone::Default)), aliases: Some(&["no_good_man", "ng_man"]), variations: &["🙅\u{200d}♂"] },
    Emoji { id: 613, emoji: "🙅🏻‍♂️", name: "man gesturing NO: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((612, SkinTone::Light)), aliases: None, variations: &["🙅🏻\u{200d}♂"] },
    Emoji { id: 614, emoji: "🙅🏼‍♂️", name: "man gesturing NO: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((612, SkinTone::MediumLight)), aliases: None, variations: &["🙅🏼\u{200d}♂"] },
    Emoji { id: 615, emoji: "🙅🏽‍♂️", name: "man gesturing NO: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((612, SkinTone::Medium)), aliases: None, variations: &["🙅🏽\u{200d}♂"] },
    Emoji { id: 616, emoji: "🙅🏾‍♂️", name: "man gesturing NO: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((612, SkinTone::MediumDark)), aliases: None, variations: &["🙅🏾\u{200d}♂"] },
    Emoji { id: 617, emoji: "🙅🏿‍♂️", name: "man gesturing NO: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((612, SkinTone::Dark)), aliases: None, variations: &["🙅🏿\u{200d}♂"] },
    Emoji { id: 618, emoji: "🙅‍♀️", name: "woman gesturing NO", group: Group::PeopleAndBody, skin_tone: Some((618, SkinTone::Default)), aliases: Some(&["no_good_woman", "ng_woman"]), variations: &["🙅\u{200d}♀"] },
    Emoji { id: 619, emoji: "🙅🏻‍♀️", name: "woman gesturing NO: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((618, SkinTone::Light)), aliases: None, variations: &["🙅🏻\u{200d}♀"] },
    Emoji { id: 620, emoji: "🙅🏼‍♀️", name: "woman gesturing NO: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((618, SkinTone::MediumLight)), aliases: None, variations: &["🙅🏼\u{200d}♀"] },
    Emoji { id: 621, emoji: "🙅🏽‍♀️", name: "woman gesturing NO: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((618, SkinTone::Medium)), aliases: None, variations: &["🙅🏽\u{200d}♀"] },
    Emoji { id: 622, emoji: "🙅🏾‍♀️", name: "woman gesturing NO: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((618, SkinTone::MediumDark)), aliases: None, variations: &["🙅🏾\u{200d}♀"] },
    Emoji { id: 623, emoji: "🙅🏿‍♀️", name: "woman gesturing NO: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((618, SkinTone::Dark)), aliases: None, variations: &["🙅🏿\u{200d}♀"] },
    Emoji { id: 624, emoji: "🙆", name: "person gesturing OK", group: Group::PeopleAndBody, skin_tone: Some((624, SkinTone::Default)), aliases: Some(&["ok_person"]), variations: &[] },
    Emoji { id: 625, emoji: "🙆🏻", name: "person gesturing OK: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((624, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 626, emoji: "🙆🏼", name: "person gesturing OK: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((624, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 627, emoji: "🙆🏽", name: "person gesturing OK: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((624, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 628, emoji: "🙆🏾", name: "person gesturing OK: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((624, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 629, emoji: "🙆🏿", name: "person gesturing OK: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((624, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 630, emoji: "🙆‍♂️", name: "man gesturing OK", group: Group::PeopleAndBody, skin_tone: Some((630, SkinTone::Default)), aliases: Some(&["ok_man"]), variations: &["🙆\u{200d}♂"] },
    Emoji { id: 631, emoji: "🙆🏻‍♂️", name: "man gesturing OK: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((630, SkinTone::Light)), aliases: None, variations: &["🙆🏻\u{200d}♂"] },
    Emoji { id: 632, emoji: "🙆🏼‍♂️", name: "man gesturing OK: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((630, SkinTone::MediumLight)), aliases: None, variations: &["🙆🏼\u{200d}♂"] },
    Emoji { id: 633, emoji: "🙆🏽‍♂️", name: "man gesturing OK: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((630, SkinTone::Medium)), aliases: None, variations: &["🙆🏽\u{200d}♂"] },
    Emoji { id: 634, emoji: "🙆🏾‍♂️", name: "man gesturing OK: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((630, SkinTone::MediumDark)), aliases: None, variations: &["🙆🏾\u{200d}♂"] },
    Emoji { id: 635, emoji: "🙆🏿‍♂️", name: "man gesturing OK: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((630, SkinTone::Dark)), aliases: None, variations: &["🙆🏿\u{200d}♂"] },
    Emoji { id: 636, emoji: "🙆‍♀️", name: "woman gesturing OK", group: Group::PeopleAndBody, skin_tone: Some((636, SkinTone::Default)), aliases: Some(&["ok_woman"]), variations: &["🙆\u{200d}♀"] },
    Emoji { id: 637, emoji: "🙆🏻‍♀️", name: "woman gesturing OK: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((636, SkinTone::Light)), aliases: None, variations: &["🙆🏻\u{200d}♀"] },
    Emoji { id: 638, emoji: "🙆🏼‍♀️", name: "woman gesturing OK: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((636, SkinTone::MediumLight)), aliases: None, variations: &["🙆🏼\u{200d}♀"] },
    Emoji { id: 639, emoji: "🙆🏽‍♀️", name: "woman gesturing OK: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((636, SkinTone::Medium)), aliases: None, variations: &["🙆🏽\u{200d}♀"] },
    Emoji { id: 640, emoji: "🙆🏾‍♀️", name: "woman gesturing OK: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((636, SkinTone::MediumDark)), aliases: None, variations: &["🙆🏾\u{200d}♀"] },
    Emoji { id: 641, emoji: "🙆🏿‍♀️", name: "woman gesturing OK: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((636, SkinTone::Dark)), aliases: None, variations: &["🙆🏿\u{200d}♀"] },
    Emoji { id: 642, emoji: "💁", name: "person tipping hand", group: Group::PeopleAndBody, skin_tone: Some((642, SkinTone::Default)), aliases: Some(&["tipping_hand_person", "information_desk_person"]), variations: &[] },
    Emoji { id: 643, emoji: "💁🏻", name: "person tipping hand: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((642, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 644, emoji: "💁🏼", name: "person tipping hand: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((642, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 645, emoji: "💁🏽", name: "person tipping hand: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((642, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 646, emoji: "💁🏾", name: "person tipping hand: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((642, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 647, emoji: "💁🏿", name: "person tipping hand: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((642, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 648, emoji: "💁‍♂️", name: "man tipping hand", group: Group::PeopleAndBody, skin_tone: Some((648, SkinTone::Default)), aliases: Some(&["tipping_hand_man", "sassy_man"]), variations: &["💁\u{200d}♂"] },
    Emoji { id: 649, emoji: "💁🏻‍♂️", name: "man tipping hand: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((648, SkinTone::Light)), aliases: None, variations: &["💁🏻\u{200d}♂"] },
    Emoji { id: 650, emoji: "💁🏼‍♂️", name: "man tipping hand: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((648, SkinTone::MediumLight)), aliases: None, variations: &["💁🏼\u{200d}♂"] },
    Emoji { id: 651, emoji: "💁🏽‍♂️", name: "man tipping hand: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((648, SkinTone::Medium)), aliases: None, variations: &["💁🏽\u{200d}♂"] },
    Emoji { id: 652, emoji: "💁🏾‍♂️", name: "man tipping hand: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((648, SkinTone::MediumDark)), aliases: None, variations: &["💁🏾\u{200d}♂"] },
    Emoji { id: 653, emoji: "💁🏿‍♂️", name: "man tipping hand: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((648, SkinTone::Dark)), aliases: None, variations: &["💁🏿\u{200d}♂"] },
    Emoji { id: 654, emoji: "💁‍♀️", name: "woman tipping hand", group: Group::PeopleAndBody, skin_tone: Some((654, SkinTone::Default)), aliases: Some(&["tipping_hand_woman", "sassy_woman"]), variations: &["💁\u{200d}♀"] },
    Emoji { id: 655, emoji: "💁🏻‍♀️", name: "woman tipping hand: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((654, SkinTone::Light)), aliases: None, variations: &["💁🏻\u{200d}♀"] },
    Emoji { id: 656, emoji: "💁🏼‍♀️", name: "woman tipping hand: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((654, SkinTone::MediumLight)), aliases: None, variations: &["💁🏼\u{200d}♀"] },
    Emoji { id: 657, emoji: "💁🏽‍♀️", name: "woman tipping hand: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((654, SkinTone::Medium)), aliases: None, variations: &["💁🏽\u{200d}♀"] },
    Emoji { id: 658, emoji: "💁🏾‍♀️", name: "woman tipping hand: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((654, SkinTone::MediumDark)), aliases: None, variations: &["💁🏾\u{200d}♀"] },
    Emoji { id: 659, emoji: "💁🏿‍♀️", name: "woman tipping hand: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((654, SkinTone::Dark)), aliases: None, variations: &["💁🏿\u{200d}♀"] },
    Emoji { id: 660, emoji: "🙋", name: "person raising hand", group: Group::PeopleAndBody, skin_tone: Some((660, SkinTone::Default)), aliases: Some(&["raising_hand"]), variations: &[] },
    Emoji { id: 661, emoji: "🙋🏻", name: "person raising hand: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((660, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 662, emoji: "🙋🏼", name: "person raising hand: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((660, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 663, emoji: "🙋🏽", name: "person raising hand: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((660, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 664, emoji: "🙋🏾", name: "person raising hand: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((660, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 665, emoji: "🙋🏿", name: "person raising hand: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((660, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 666, emoji: "🙋‍♂️", name: "man raising hand", group: Group::PeopleAndBody, skin_tone: Some((666, SkinTone::Default)), aliases: Some(&["raising_hand_man"]), variations: &["🙋\u{200d}♂"] },
    Emoji { id: 667, emoji: "🙋🏻‍♂️", name: "man raising hand: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((666, SkinTone::Light)), aliases: None, variations: &["🙋🏻\u{200d}♂"] },
    Emoji { id: 668, emoji: "🙋🏼‍♂️", name: "man raising hand: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((666, SkinTone::MediumLight)), aliases: None, variations: &["🙋🏼\u{200d}♂"] },
    Emoji { id: 669, emoji: "🙋🏽‍♂️", name: "man raising hand: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((666, SkinTone::Medium)), aliases: None, variations: &["🙋🏽\u{200d}♂"] },
    Emoji { id: 670, emoji: "🙋🏾‍♂️", name: "man raising hand: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((666, SkinTone::MediumDark)), aliases: None, variations: &["🙋🏾\u{200d}♂"] },
    Emoji { id: 671, emoji: "🙋🏿‍♂️", name: "man raising hand: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((666, SkinTone::Dark)), aliases: None, variations: &["🙋🏿\u{200d}♂"] },
    Emoji { id: 672, emoji: "🙋‍♀️", name: "woman raising hand", group: Group::PeopleAndBody, skin_tone: Some((672, SkinTone::Default)), aliases: Some(&["raising_hand_woman"]), variations: &["🙋\u{200d}♀"] },
    Emoji { id: 673, emoji: "🙋🏻‍♀️", name: "woman raising hand: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((672, SkinTone::Light)), aliases: None, variations: &["🙋🏻\u{200d}♀"] },
    Emoji { id: 674, emoji: "🙋🏼‍♀️", name: "woman raising hand: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((672, SkinTone::MediumLight)), aliases: None, variations: &["🙋🏼\u{200d}♀"] },
    Emoji { id: 675, emoji: "🙋🏽‍♀️", name: "woman raising hand: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((672, SkinTone::Medium)), aliases: None, variations: &["🙋🏽\u{200d}♀"] },
    Emoji { id: 676, emoji: "🙋🏾‍♀️", name: "woman raising hand: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((672, SkinTone::MediumDark)), aliases: None, variations: &["🙋🏾\u{200d}♀"] },
    Emoji { id: 677, emoji: "🙋🏿‍♀️", name: "woman raising hand: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((672, SkinTone::Dark)), aliases: None, variations: &["🙋🏿\u{200d}♀"] },
    Emoji { id: 678, emoji: "🧏", name: "deaf person", group: Group::PeopleAndBody, skin_tone: Some((678, SkinTone::Default)), aliases: Some(&["deaf_person"]), variations: &[] },
    Emoji { id: 679, emoji: "🧏🏻", name: "deaf person: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((678, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 680, emoji: "🧏🏼", name: "deaf person: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((678, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 681, emoji: "🧏🏽", name: "deaf person: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((678, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 682, emoji: "🧏🏾", name: "deaf person: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((678, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 683, emoji: "🧏🏿", name: "deaf person: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((678, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 684, emoji: "🧏‍♂️", name: "deaf man", group: Group::PeopleAndBody, skin_tone: Some((684, SkinTone::Default)), aliases: Some(&["deaf_man"]), variations: &["🧏\u{200d}♂"] },
    Emoji { id: 685, emoji: "🧏🏻‍♂️", name: "deaf man: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((684, SkinTone::Light)), aliases: None, variations: &["🧏🏻\u{200d}♂"] },
    Emoji { id: 686, emoji: "🧏🏼‍♂️", name: "deaf man: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((684, SkinTone::MediumLight)), aliases: None, variations: &["🧏🏼\u{200d}♂"] },
    Emoji { id: 687, emoji: "🧏🏽‍♂️", name: "deaf man: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((684, SkinTone::Medium)), aliases: None, variations: &["🧏🏽\u{200d}♂"] },
    Emoji { id: 688, emoji: "🧏🏾‍♂️", name: "deaf man: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((684, SkinTone::MediumDark)), aliases: None, variations: &["🧏🏾\u{200d}♂"] },
    Emoji { id: 689, emoji: "🧏🏿‍♂️", name: "deaf man: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((684, SkinTone::Dark)), aliases: None, variations: &["🧏🏿\u{200d}♂"] },
    Emoji { id: 690, emoji: "🧏‍♀️", name: "deaf woman", group: Group::PeopleAndBody, skin_tone: Some((690, SkinTone::Default)), aliases: Some(&["deaf_woman"]), variations: &["🧏\u{200d}♀"] },
    Emoji { id: 691, emoji: "🧏🏻‍♀️", name: "deaf woman: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((690, SkinTone::Light)), aliases: None, variations: &["🧏🏻\u{200d}♀"] },
    Emoji { id: 692, emoji: "🧏🏼‍♀️", name: "deaf woman: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((690, SkinTone::MediumLight)), aliases: None, variations: &["🧏🏼\u{200d}♀"] },
    Emoji { id: 693, emoji: "🧏🏽‍♀️", name: "deaf woman: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((690, SkinTone::Medium)), aliases: None, variations: &["🧏🏽\u{200d}♀"] },
    Emoji { id: 694, emoji: "🧏🏾‍♀️", name: "deaf woman: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((690, SkinTone::MediumDark)), aliases: None, variations: &["🧏🏾\u{200d}♀"] },
    Emoji { id: 695, emoji: "🧏🏿‍♀️", name: "deaf woman: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((690, SkinTone::Dark)), aliases: None, variations: &["🧏🏿\u{200d}♀"] },
    Emoji { id: 696, emoji: "🙇", name: "person bowing", group: Group::PeopleAndBody, skin_tone: Some((696, SkinTone::Default)), aliases: Some(&["bow"]), variations: &[] },
    Emoji { id: 697, emoji: "🙇🏻", name: "person bowing: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((696, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 698, emoji: "🙇🏼", name: "person bowing: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((696, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 699, emoji: "🙇🏽", name: "person bowing: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((696, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 700, emoji: "🙇🏾", name: "person bowing: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((696, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 701, emoji: "🙇🏿", name: "person bowing: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((696, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 702, emoji: "🙇‍♂️", name: "man bowing", group: Group::PeopleAndBody, skin_tone: Some((702, SkinTone::Default)), aliases: Some(&["bowing_man"]), variations: &["🙇\u{200d}♂"] },
    Emoji { id: 703, emoji: "🙇🏻‍♂️", name: "man bowing: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((702, SkinTone::Light)), aliases: None, variations: &["🙇🏻\u{200d}♂"] },
    Emoji { id: 704, emoji: "🙇🏼‍♂️", name: "man bowing: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((702, SkinTone::MediumLight)), aliases: None, variations: &["🙇🏼\u{200d}♂"] },
    Emoji { id: 705, emoji: "🙇🏽‍♂️", name: "man bowing: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((702, SkinTone::Medium)), aliases: None, variations: &["🙇🏽\u{200d}♂"] },
    Emoji { id: 706, emoji: "🙇🏾‍♂️", name: "man bowing: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((702, SkinTone::MediumDark)), aliases: None, variations: &["🙇🏾\u{200d}♂"] },
    Emoji { id: 707, emoji: "🙇🏿‍♂️", name: "man bowing: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((702, SkinTone::Dark)), aliases: None, variations: &["🙇🏿\u{200d}♂"] },
    Emoji { id: 708, emoji: "🙇‍♀️", name: "woman bowing", group: Group::PeopleAndBody, skin_tone: Some((708, SkinTone::Default)), aliases: Some(&["bowing_woman"]), variations: &["🙇\u{200d}♀"] },
    Emoji { id: 709, emoji: "🙇🏻‍♀️", name: "woman bowing: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((708, SkinTone::Light)), aliases: None, variations: &["🙇🏻\u{200d}♀"] },
    Emoji { id: 710, emoji: "🙇🏼‍♀️", name: "woman bowing: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((708, SkinTone::MediumLight)), aliases: None, variations: &["🙇🏼\u{200d}♀"] },
    Emoji { id: 711, emoji: "🙇🏽‍♀️", name: "woman bowing: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((708, SkinTone::Medium)), aliases: None, variations: &["🙇🏽\u{200d}♀"] },
    Emoji { id: 712, emoji: "🙇🏾‍♀️", name: "woman bowing: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((708, SkinTone::MediumDark)), aliases: None, variations: &["🙇🏾\u{200d}♀"] },
    Emoji { id: 713, emoji: "🙇🏿‍♀️", name: "woman bowing: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((708, SkinTone::Dark)), aliases: None, variations: &["🙇🏿\u{200d}♀"] },
    Emoji { id: 714, emoji: "🤦", name: "person facepalming", group: Group::PeopleAndBody, skin_tone: Some((714, SkinTone::Default)), aliases: Some(&["facepalm"]), variations: &[] },
    Emoji { id: 715, emoji: "🤦🏻", name: "person facepalming: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((714, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 716, emoji: "🤦🏼", name: "person facepalming: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((714, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 717, emoji: "🤦🏽", name: "person facepalming: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((714, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 718, emoji: "🤦🏾", name: "person facepalming: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((714, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 719, emoji: "🤦🏿", name: "person facepalming: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((714, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 720, emoji: "🤦‍♂️", name: "man facepalming", group: Group::PeopleAndBody, skin_tone: Some((720, SkinTone::Default)), aliases: Some(&["man_facepalming"]), variations: &["🤦\u{200d}♂"] },
    Emoji { id: 721, emoji: "🤦🏻‍♂️", name: "man facepalming: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((720, SkinTone::Light)), aliases: None, variations: &["🤦🏻\u{200d}♂"] },
    Emoji { id: 722, emoji: "🤦🏼‍♂️", name: "man facepalming: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((720, SkinTone::MediumLight)), aliases: None, variations: &["🤦🏼\u{200d}♂"] },
    Emoji { id: 723, emoji: "🤦🏽‍♂️", name: "man facepalming: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((720, SkinTone::Medium)), aliases: None, variations: &["🤦🏽\u{200d}♂"] },
    Emoji { id: 724, emoji: "🤦🏾‍♂️", name: "man facepalming: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((720, SkinTone::MediumDark)), aliases: None, variations: &["🤦🏾\u{200d}♂"] },
    Emoji { id: 725, emoji: "🤦🏿‍♂️", name: "man facepalming: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((720, SkinTone::Dark)), aliases: None, variations: &["🤦🏿\u{200d}♂"] },
    Emoji { id: 726, emoji: "🤦‍♀️", name: "woman facepalming", group: Group::PeopleAndBody, skin_tone: Some((726, SkinTone::Default)), aliases: Some(&["woman_facepalming"]), variations: &["🤦\u{200d}♀"] },
    Emoji { id: 727, emoji: "🤦🏻‍♀️", name: "woman facepalming: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((726, SkinTone::Light)), aliases: None, variations: &["🤦🏻\u{200d}♀"] },
    Emoji { id: 728, emoji: "🤦🏼‍♀️", name: "woman facepalming: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((726, SkinTone::MediumLight)), aliases: None, variations: &["🤦🏼\u{200d}♀"] },
    Emoji { id: 729, emoji: "🤦🏽‍♀️", name: "woman facepalming: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((726, SkinTone::Medium)), aliases: None, variations: &["🤦🏽\u{200d}♀"] },
    Emoji { id: 730, emoji: "🤦🏾‍♀️", name: "woman facepalming: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((726, SkinTone::MediumDark)), aliases: None, variations: &["🤦🏾\u{200d}♀"] },
    Emoji { id: 731, emoji: "🤦🏿‍♀️", name: "woman facepalming: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((726, SkinTone::Dark)), aliases: None, variations: &["🤦🏿\u{200d}♀"] },
    Emoji { id: 732, emoji: "🤷", name: "person shrugging", group: Group::PeopleAndBody, skin_tone: Some((732, SkinTone::Default)), aliases: Some(&["shrug"]), variations: &[] },
    Emoji { id: 733, emoji: "🤷🏻", name: "person shrugging: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((732, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 734, emoji: "🤷🏼", name: "person shrugging: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((732, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 735, emoji: "🤷🏽", name: "person shrugging: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((732, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 736, emoji: "🤷🏾", name: "person shrugging: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((732, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 737, emoji: "🤷🏿", name: "person shrugging: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((732, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 738, emoji: "🤷‍♂️", name: "man shrugging", group: Group::PeopleAndBody, skin_tone: Some((738, SkinTone::Default)), aliases: Some(&["man_shrugging"]), variations: &["🤷\u{200d}♂"] },
    Emoji { id: 739, emoji: "🤷🏻‍♂️", name: "man shrugging: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((738, SkinTone::Light)), aliases: None, variations: &["🤷🏻\u{200d}♂"] },
    Emoji { id: 740, emoji: "🤷🏼‍♂️", name: "man shrugging: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((738, SkinTone::MediumLight)), aliases: None, variations: &["🤷🏼\u{200d}♂"] },
    Emoji { id: 741, emoji: "🤷🏽‍♂️", name: "man shrugging: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((738, SkinTone::Medium)), aliases: None, variations: &["🤷🏽\u{200d}♂"] },
    Emoji { id: 742, emoji: "🤷🏾‍♂️", name: "man shrugging: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((738, SkinTone::MediumDark)), aliases: None, variations: &["🤷🏾\u{200d}♂"] },
    Emoji { id: 743, emoji: "🤷🏿‍♂️", name: "man shrugging: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((738, SkinTone::Dark)), aliases: None, variations: &["🤷🏿\u{200d}♂"] },
    Emoji { id: 744, emoji: "🤷‍♀️", name: "woman shrugging", group: Group::PeopleAndBody, skin_tone: Some((744, SkinTone::Default)), aliases: Some(&["woman_shrugging"]), variations: &["🤷\u{200d}♀"] },
    Emoji { id: 745, emoji: "🤷🏻‍♀️", name: "woman shrugging: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((744, SkinTone::Light)), aliases: None, variations: &["🤷🏻\u{200d}♀"] },
    Emoji { id: 746, emoji: "🤷🏼‍♀️", name: "woman shrugging: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((744, SkinTone::MediumLight)), aliases: None, variations: &["🤷🏼\u{200d}♀"] },
    Emoji { id: 747, emoji: "🤷🏽‍♀️", name: "woman shrugging: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((744, SkinTone::Medium)), aliases: None, variations: &["🤷🏽\u{200d}♀"] },
    Emoji { id: 748, emoji: "🤷🏾‍♀️", name: "woman shrugging: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((744, SkinTone::MediumDark)), aliases: None, variations: &["🤷🏾\u{200d}♀"] },
    Emoji { id: 749, emoji: "🤷🏿‍♀️", name: "woman shrugging: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((744, SkinTone::Dark)), aliases: None, variations: &["🤷🏿\u{200d}♀"] },
    Emoji { id: 750, emoji: "🧑‍⚕️", name: "health worker", group: Group::PeopleAndBody, skin_tone: Some((750, SkinTone::Default)), aliases: Some(&["health_worker"]), variations: &["🧑\u{200d}⚕"] },
    Emoji { id: 751, emoji: "🧑🏻‍⚕️", name: "health worker: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((750, SkinTone::Light)), aliases: None, variations: &["🧑🏻\u{200d}⚕"] },
    Emoji { id: 752, emoji: "🧑🏼‍⚕️", name: "health worker: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((750, SkinTone::MediumLight)), aliases: None, variations: &["🧑🏼\u{200d}⚕"] },
    Emoji { id: 753, emoji: "🧑🏽‍⚕️", name: "health worker: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((750, SkinTone::Medium)), aliases: None, variations: &["🧑🏽\u{200d}⚕"] },
    Emoji { id: 754, emoji: "🧑🏾‍⚕️", name: "health worker: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((750, SkinTone::MediumDark)), aliases: None, variations: &["🧑🏾\u{200d}⚕"] },
    Emoji { id: 755, emoji: "🧑🏿‍⚕️", name: "health worker: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((750, SkinTone::Dark)), aliases: None, variations: &["🧑🏿\u{200d}⚕"] },
    Emoji { id: 756, emoji: "👨‍⚕️", name: "man health worker", group: Group::PeopleAndBody, skin_tone: Some((756, SkinTone::Default)), aliases: Some(&["man_health_worker"]), variations: &["👨\u{200d}⚕"] },
    Emoji { id: 757, emoji: "👨🏻‍⚕️", name: "man health worker: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((756, SkinTone::Light)), aliases: None, variations: &["👨🏻\u{200d}⚕"] },
    Emoji { id: 758, emoji: "👨🏼‍⚕️", name: "man health worker: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((756, SkinTone::MediumLight)), aliases: None, variations: &["👨🏼\u{200d}⚕"] },
    Emoji { id: 759, emoji: "👨🏽‍⚕️", name: "man health worker: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((756, SkinTone::Medium)), aliases: None, variations: &["👨🏽\u{200d}⚕"] },
    Emoji { id: 760, emoji: "👨🏾‍⚕️", name: "man health worker: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((756, SkinTone::MediumDark)), aliases: None, variations: &["👨🏾\u{200d}⚕"] },
    Emoji { id: 761, emoji: "👨🏿‍⚕️", name: "man health worker: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((756, SkinTone::Dark)), aliases: None, variations: &["👨🏿\u{200d}⚕"] },
    Emoji { id: 762, emoji: "👩‍⚕️", name: "woman health worker", group: Group::PeopleAndBody, skin_tone: Some((762, SkinTone::Default)), aliases: Some(&["woman_health_worker"]), variations: &["👩\u{200d}⚕"] },
    Emoji { id: 763, emoji: "👩🏻‍⚕️", name: "woman health worker: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((762, SkinTone::Light)), aliases: None, variations: &["👩🏻\u{200d}⚕"] },
    Emoji { id: 764, emoji: "👩🏼‍⚕️", name: "woman health worker: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((762, SkinTone::MediumLight)), aliases: None, variations: &["👩🏼\u{200d}⚕"] },
    Emoji { id: 765, emoji: "👩🏽‍⚕️", name: "woman health worker: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((762, SkinTone::Medium)), aliases: None, variations: &["👩🏽\u{200d}⚕"] },
    Emoji { id: 766, emoji: "👩🏾‍⚕️", name: "woman health worker: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((762, SkinTone::MediumDark)), aliases: None, variations: &["👩🏾\u{200d}⚕"] },
    Emoji { id: 767, emoji: "👩🏿‍⚕️", name: "woman health worker: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((762, SkinTone::Dark)), aliases: None, variations: &["👩🏿\u{200d}⚕"] },
    Emoji { id: 768, emoji: "🧑‍🎓", name: "student", group: Group::PeopleAndBody, skin_tone: Some((768, SkinTone::Default)), aliases: Some(&["student"]), variations: &[] },
    Emoji { id: 769, emoji: "🧑🏻‍🎓", name: "student: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((768, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 770, emoji: "🧑🏼‍🎓", name: "student: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((768, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 771, emoji: "🧑🏽‍🎓", name: "student: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((768, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 772, emoji: "🧑🏾‍🎓", name: "student: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((768, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 773, emoji: "🧑🏿‍🎓", name: "student: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((768, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 774, emoji: "👨‍🎓", name: "man student", group: Group::PeopleAndBody, skin_tone: Some((774, SkinTone::Default)), aliases: Some(&["man_student"]), variations: &[] },
    Emoji { id: 775, emoji: "👨🏻‍🎓", name: "man student: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((774, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 776, emoji: "👨🏼‍🎓", name: "man student: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((774, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 777, emoji: "👨🏽‍🎓", name: "man student: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((774, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 778, emoji: "👨🏾‍🎓", name: "man student: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((774, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 779, emoji: "👨🏿‍🎓", name: "man student: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((774, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 780, emoji: "👩‍🎓", name: "woman student", group: Group::PeopleAndBody, skin_tone: Some((780, SkinTone::Default)), aliases: Some(&["woman_student"]), variations: &[] },
    Emoji { id: 781, emoji: "👩🏻‍🎓", name: "woman student: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((780, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 782, emoji: "👩🏼‍🎓", name: "woman student: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((780, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 783, emoji: "👩🏽‍🎓", name: "woman student: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((780, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 784, emoji: "👩🏾‍🎓", name: "woman student: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((780, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 785, emoji: "👩🏿‍🎓", name: "woman student: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((780, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 786, emoji: "🧑‍🏫", name: "teacher", group: Group::PeopleAndBody, skin_tone: Some((786, SkinTone::Default)), aliases: Some(&["teacher"]), variations: &[] },
    Emoji { id: 787, emoji: "🧑🏻‍🏫", name: "teacher: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((786, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 788, emoji: "🧑🏼‍🏫", name: "teacher: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((786, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 789, emoji: "🧑🏽‍🏫", name: "teacher: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((786, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 790, emoji: "🧑🏾‍🏫", name: "teacher: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((786, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 791, emoji: "🧑🏿‍🏫", name: "teacher: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((786, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 792, emoji: "👨‍🏫", name: "man teacher", group: Group::PeopleAndBody, skin_tone: Some((792, SkinTone::Default)), aliases: Some(&["man_teacher"]), variations: &[] },
    Emoji { id: 793, emoji: "👨🏻‍🏫", name: "man teacher: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((792, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 794, emoji: "👨🏼‍🏫", name: "man teacher: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((792, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 795, emoji: "👨🏽‍🏫", name: "man teacher: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((792, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 796, emoji: "👨🏾‍🏫", name: "man teacher: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((792, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 797, emoji: "👨🏿‍🏫", name: "man teacher: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((792, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 798, emoji: "👩‍🏫", name: "woman teacher", group: Group::PeopleAndBody, skin_tone: Some((798, SkinTone::Default)), aliases: Some(&["woman_teacher"]), variations: &[] },
    Emoji { id: 799, emoji: "👩🏻‍🏫", name: "woman teacher: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((798, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 800, emoji: "👩🏼‍🏫", name: "woman teacher: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((798, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 801, emoji: "👩🏽‍🏫", name: "woman teacher: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((798, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 802, emoji: "👩🏾‍🏫", name: "woman teacher: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((798, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 803, emoji: "👩🏿‍🏫", name: "woman teacher: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((798, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 804, emoji: "🧑‍⚖️", name: "judge", group: Group::PeopleAndBody, skin_tone: Some((804, SkinTone::Default)), aliases: Some(&["judge"]), variations: &["🧑\u{200d}⚖"] },
    Emoji { id: 805, emoji: "🧑🏻‍⚖️", name: "judge: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((804, SkinTone::Light)), aliases: None, variations: &["🧑🏻\u{200d}⚖"] },
    Emoji { id: 806, emoji: "🧑🏼‍⚖️", name: "judge: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((804, SkinTone::MediumLight)), aliases: None, variations: &["🧑🏼\u{200d}⚖"] },
    Emoji { id: 807, emoji: "🧑🏽‍⚖️", name: "judge: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((804, SkinTone::Medium)), aliases: None, variations: &["🧑🏽\u{200d}⚖"] },
    Emoji { id: 808, emoji: "🧑🏾‍⚖️", name: "judge: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((804, SkinTone::MediumDark)), aliases: None, variations: &["🧑🏾\u{200d}⚖"] },
    Emoji { id: 809, emoji: "🧑🏿‍⚖️", name: "judge: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((804, SkinTone::Dark)), aliases: None, variations: &["🧑🏿\u{200d}⚖"] },
    Emoji { id: 810, emoji: "👨‍⚖️", name: "man judge", group: Group::PeopleAndBody, skin_tone: Some((810, SkinTone::Default)), aliases: Some(&["man_judge"]), variations: &["👨\u{200d}⚖"] },
    Emoji { id: 811, emoji: "👨🏻‍⚖️", name: "man judge: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((810, SkinTone::Light)), aliases: None, variations: &["👨🏻\u{200d}⚖"] },
    Emoji { id: 812, emoji: "👨🏼‍⚖️", name: "man judge: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((810, SkinTone::MediumLight)), aliases: None, variations: &["👨🏼\u{200d}⚖"] },
    Emoji { id: 813, emoji: "👨🏽‍⚖️", name: "man judge: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((810, SkinTone::Medium)), aliases: None, variations: &["👨🏽\u{200d}⚖"] },
    Emoji { id: 814, emoji: "👨🏾‍⚖️", name: "man judge: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((810, SkinTone::MediumDark)), aliases: None, variations: &["👨🏾\u{200d}⚖"] },
    Emoji { id: 815, emoji: "👨🏿‍⚖️", name: "man judge: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((810, SkinTone::Dark)), aliases: None, variations: &["👨🏿\u{200d}⚖"] },
    Emoji { id: 816, emoji: "👩‍⚖️", name: "woman judge", group: Group::PeopleAndBody, skin_tone: Some((816, SkinTone::Default)), aliases: Some(&["woman_judge"]), variations: &["👩\u{200d}⚖"] },
    Emoji { id: 817, emoji: "👩🏻‍⚖️", name: "woman judge: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((816, SkinTone::Light)), aliases: None, variations: &["👩🏻\u{200d}⚖"] },
    Emoji { id: 818, emoji: "👩🏼‍⚖️", name: "woman judge: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((816, SkinTone::MediumLight)), aliases: None, variations: &["👩🏼\u{200d}⚖"] },
    Emoji { id: 819, emoji: "👩🏽‍⚖️", name: "woman judge: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((816, SkinTone::Medium)), aliases: None, variations: &["👩🏽\u{200d}⚖"] },
    Emoji { id: 820, emoji: "👩🏾‍⚖️", name: "woman judge: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((816, SkinTone::MediumDark)), aliases: None, variations: &["👩🏾\u{200d}⚖"] },
    Emoji { id: 821, emoji: "👩🏿‍⚖️", name: "woman judge: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((816, SkinTone::Dark)), aliases: None, variations: &["👩🏿\u{200d}⚖"] },
    Emoji { id: 822, emoji: "🧑‍🌾", name: "farmer", group: Group::PeopleAndBody, skin_tone: Some((822, SkinTone::Default)), aliases: Some(&["farmer"]), variations: &[] },
    Emoji { id: 823, emoji: "🧑🏻‍🌾", name: "farmer: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((822, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 824, emoji: "🧑🏼‍🌾", name: "farmer: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((822, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 825, emoji: "🧑🏽‍🌾", name: "farmer: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((822, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 826, emoji: "🧑🏾‍🌾", name: "farmer: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((822, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 827, emoji: "🧑🏿‍🌾", name: "farmer: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((822, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 828, emoji: "👨‍🌾", name: "man farmer", group: Group::PeopleAndBody, skin_tone: Some((828, SkinTone::Default)), aliases: Some(&["man_farmer"]), variations: &[] },
    Emoji { id: 829, emoji: "👨🏻‍🌾", name: "man farmer: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((828, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 830, emoji: "👨🏼‍🌾", name: "man farmer: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((828, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 831, emoji: "👨🏽‍🌾", name: "man farmer: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((828, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 832, emoji: "👨🏾‍🌾", name: "man farmer: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((828, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 833, emoji: "👨🏿‍🌾", name: "man farmer: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((828, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 834, emoji: "👩‍🌾", name: "woman farmer", group: Group::PeopleAndBody, skin_tone: Some((834, SkinTone::Default)), aliases: Some(&["woman_farmer"]), variations: &[] },
    Emoji { id: 835, emoji: "👩🏻‍🌾", name: "woman farmer: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((834, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 836, emoji: "👩🏼‍🌾", name: "woman farmer: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((834, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 837, emoji: "👩🏽‍🌾", name: "woman farmer: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((834, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 838, emoji: "👩🏾‍🌾", name: "woman farmer: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((834, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 839, emoji: "👩🏿‍🌾", name: "woman farmer: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((834, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 840, emoji: "🧑‍🍳", name: "cook", group: Group::PeopleAndBody, skin_tone: Some((840, SkinTone::Default)), aliases: Some(&["cook"]), variations: &[] },
    Emoji { id: 841, emoji: "🧑🏻‍🍳", name: "cook: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((840, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 842, emoji: "🧑🏼‍🍳", name: "cook: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((840, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 843, emoji: "🧑🏽‍🍳", name: "cook: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((840, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 844, emoji: "🧑🏾‍🍳", name: "cook: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((840, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 845, emoji: "🧑🏿‍🍳", name: "cook: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((840, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 846, emoji: "👨‍🍳", name: "man cook", group: Group::PeopleAndBody, skin_tone: Some((846, SkinTone::Default)), aliases: Some(&["man_cook"]), variations: &[] },
    Emoji { id: 847, emoji: "👨🏻‍🍳", name: "man cook: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((846, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 848, emoji: "👨🏼‍🍳", name: "man cook: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((846, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 849, emoji: "👨🏽‍🍳", name: "man cook: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((846, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 850, emoji: "👨🏾‍🍳", name: "man cook: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((846, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 851, emoji: "👨🏿‍🍳", name: "man cook: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((846, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 852, emoji: "👩‍🍳", name: "woman cook", group: Group::PeopleAndBody, skin_tone: Some((852, SkinTone::Default)), aliases: Some(&["woman_cook"]), variations: &[] },
    Emoji { id: 853, emoji: "👩🏻‍🍳", name: "woman cook: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((852, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 854, emoji: "👩🏼‍🍳", name: "woman cook: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((852, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 855, emoji: "👩🏽‍🍳", name: "woman cook: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((852, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 856, emoji: "👩🏾‍🍳", name: "woman cook: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((852, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 857, emoji: "👩🏿‍🍳", name: "woman cook: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((852, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 858, emoji: "🧑‍🔧", name: "mechanic", group: Group::PeopleAndBody, skin_tone: Some((858, SkinTone::Default)), aliases: Some(&["mechanic"]), variations: &[] },
    Emoji { id: 859, emoji: "🧑🏻‍🔧", name: "mechanic: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((858, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 860, emoji: "🧑🏼‍🔧", name: "mechanic: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((858, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 861, emoji: "🧑🏽‍🔧", name: "mechanic: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((858, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 862, emoji: "🧑🏾‍🔧", name: "mechanic: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((858, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 863, emoji: "🧑🏿‍🔧", name: "mechanic: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((858, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 864, emoji: "👨‍🔧", name: "man mechanic", group: Group::PeopleAndBody, skin_tone: Some((864, SkinTone::Default)), aliases: Some(&["man_mechanic"]), variations: &[] },
    Emoji { id: 865, emoji: "👨🏻‍🔧", name: "man mechanic: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((864, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 866, emoji: "👨🏼‍🔧", name: "man mechanic: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((864, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 867, emoji: "👨🏽‍🔧", name: "man mechanic: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((864, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 868, emoji: "👨🏾‍🔧", name: "man mechanic: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((864, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 869, emoji: "👨🏿‍🔧", name: "man mechanic: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((864, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 870, emoji: "👩‍🔧", name: "woman mechanic", group: Group::PeopleAndBody, skin_tone: Some((870, SkinTone::Default)), aliases: Some(&["woman_mechanic"]), variations: &[] },
    Emoji { id: 871, emoji: "👩🏻‍🔧", name: "woman mechanic: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((870, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 872, emoji: "👩🏼‍🔧", name: "woman mechanic: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((870, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 873, emoji: "👩🏽‍🔧", name: "woman mechanic: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((870, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 874, emoji: "👩🏾‍🔧", name: "woman mechanic: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((870, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 875, emoji: "👩🏿‍🔧", name: "woman mechanic: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((870, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 876, emoji: "🧑‍🏭", name: "factory worker", group: Group::PeopleAndBody, skin_tone: Some((876, SkinTone::Default)), aliases: Some(&["factory_worker"]), variations: &[] },
    Emoji { id: 877, emoji: "🧑🏻‍🏭", name: "factory worker: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((876, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 878, emoji: "🧑🏼‍🏭", name: "factory worker: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((876, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 879, emoji: "🧑🏽‍🏭", name: "factory worker: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((876, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 880, emoji: "🧑🏾‍🏭", name: "factory worker: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((876, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 881, emoji: "🧑🏿‍🏭", name: "factory worker: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((876, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 882, emoji: "👨‍🏭", name: "man factory worker", group: Group::PeopleAndBody, skin_tone: Some((882, SkinTone::Default)), aliases: Some(&["man_factory_worker"]), variations: &[] },
    Emoji { id: 883, emoji: "👨🏻‍🏭", name: "man factory worker: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((882, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 884, emoji: "👨🏼‍🏭", name: "man factory worker: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((882, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 885, emoji: "👨🏽‍🏭", name: "man factory worker: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((882, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 886, emoji: "👨🏾‍🏭", name: "man factory worker: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((882, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 887, emoji: "👨🏿‍🏭", name: "man factory worker: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((882, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 888, emoji: "👩‍🏭", name: "woman factory worker", group: Group::PeopleAndBody, skin_tone: Some((888, SkinTone::Default)), aliases: Some(&["woman_factory_worker"]), variations: &[] },
    Emoji { id: 889, emoji: "👩🏻‍🏭", name: "woman factory worker: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((888, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 890, emoji: "👩🏼‍🏭", name: "woman factory worker: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((888, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 891, emoji: "👩🏽‍🏭", name: "woman factory worker: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((888, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 892, emoji: "👩🏾‍🏭", name: "woman factory worker: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((888, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 893, emoji: "👩🏿‍🏭", name: "woman factory worker: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((888, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 894, emoji: "🧑‍💼", name: "office worker", group: Group::PeopleAndBody, skin_tone: Some((894, SkinTone::Default)), aliases: Some(&["office_worker"]), variations: &[] },
    Emoji { id: 895, emoji: "🧑🏻‍💼", name: "office worker: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((894, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 896, emoji: "🧑🏼‍💼", name: "office worker: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((894, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 897, emoji: "🧑🏽‍💼", name: "office worker: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((894, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 898, emoji: "🧑🏾‍💼", name: "office worker: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((894, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 899, emoji: "🧑🏿‍💼", name: "office worker: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((894, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 900, emoji: "👨‍💼", name: "man office worker", group: Group::PeopleAndBody, skin_tone: Some((900, SkinTone::Default)), aliases: Some(&["man_office_worker"]), variations: &[] },
    Emoji { id: 901, emoji: "👨🏻‍💼", name: "man office worker: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((900, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 902, emoji: "👨🏼‍💼", name: "man office worker: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((900, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 903, emoji: "👨🏽‍💼", name: "man office worker: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((900, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 904, emoji: "👨🏾‍💼", name: "man office worker: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((900, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 905, emoji: "👨🏿‍💼", name: "man office worker: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((900, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 906, emoji: "👩‍💼", name: "woman office worker", group: Group::PeopleAndBody, skin_tone: Some((906, SkinTone::Default)), aliases: Some(&["woman_office_worker"]), variations: &[] },
    Emoji { id: 907, emoji: "👩🏻‍💼", name: "woman office worker: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((906, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 908, emoji: "👩🏼‍💼", name: "woman office worker: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((906, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 909, emoji: "👩🏽‍💼", name: "woman office worker: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((906, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 910, emoji: "👩🏾‍💼", name: "woman office worker: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((906, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 911, emoji: "👩🏿‍💼", name: "woman office worker: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((906, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 912, emoji: "🧑‍🔬", name: "scientist", group: Group::PeopleAndBody, skin_tone: Some((912, SkinTone::Default)), aliases: Some(&["scientist"]), variations: &[] },
    Emoji { id: 913, emoji: "🧑🏻‍🔬", name: "scientist: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((912, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 914, emoji: "🧑🏼‍🔬", name: "scientist: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((912, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 915, emoji: "🧑🏽‍🔬", name: "scientist: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((912, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 916, emoji: "🧑🏾‍🔬", name: "scientist: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((912, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 917, emoji: "🧑🏿‍🔬", name: "scientist: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((912, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 918, emoji: "👨‍🔬", name: "man scientist", group: Group::PeopleAndBody, skin_tone: Some((918, SkinTone::Default)), aliases: Some(&["man_scientist"]), variations: &[] },
    Emoji { id: 919, emoji: "👨🏻‍🔬", name: "man scientist: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((918, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 920, emoji: "👨🏼‍🔬", name: "man scientist: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((918, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 921, emoji: "👨🏽‍🔬", name: "man scientist: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((918, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 922, emoji: "👨🏾‍🔬", name: "man scientist: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((918, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 923, emoji: "👨🏿‍🔬", name: "man scientist: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((918, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 924, emoji: "👩‍🔬", name: "woman scientist", group: Group::PeopleAndBody, skin_tone: Some((924, SkinTone::Default)), aliases: Some(&["woman_scientist"]), variations: &[] },
    Emoji { id: 925, emoji: "👩🏻‍🔬", name: "woman scientist: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((924, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 926, emoji: "👩🏼‍🔬", name: "woman scientist: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((924, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 927, emoji: "👩🏽‍🔬", name: "woman scientist: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((924, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 928, emoji: "👩🏾‍🔬", name: "woman scientist: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((924, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 929, emoji: "👩🏿‍🔬", name: "woman scientist: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((924, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 930, emoji: "🧑‍💻", name: "technologist", group: Group::PeopleAndBody, skin_tone: Some((930, SkinTone::Default)), aliases: Some(&["technologist"]), variations: &[] },
    Emoji { id: 931, emoji: "🧑🏻‍💻", name: "technologist: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((930, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 932, emoji: "🧑🏼‍💻", name: "technologist: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((930, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 933, emoji: "🧑🏽‍💻", name: "technologist: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((930, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 934, emoji: "🧑🏾‍💻", name: "technologist: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((930, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 935, emoji: "🧑🏿‍💻", name: "technologist: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((930, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 936, emoji: "👨‍💻", name: "man technologist", group: Group::PeopleAndBody, skin_tone: Some((936, SkinTone::Default)), aliases: Some(&["man_technologist"]), variations: &[] },
    Emoji { id: 937, emoji: "👨🏻‍💻", name: "man technologist: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((936, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 938, emoji: "👨🏼‍💻", name: "man technologist: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((936, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 939, emoji: "👨🏽‍💻", name: "man technologist: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((936, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 940, emoji: "👨🏾‍💻", name: "man technologist: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((936, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 941, emoji: "👨🏿‍💻", name: "man technologist: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((936, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 942, emoji: "👩‍💻", name: "woman technologist", group: Group::PeopleAndBody, skin_tone: Some((942, SkinTone::Default)), aliases: Some(&["woman_technologist"]), variations: &[] },
    Emoji { id: 943, emoji: "👩🏻‍💻", name: "woman technologist: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((942, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 944, emoji: "👩🏼‍💻", name: "woman technologist: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((942, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 945, emoji: "👩🏽‍💻", name: "woman technologist: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((942, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 946, emoji: "👩🏾‍💻", name: "woman technologist: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((942, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 947, emoji: "👩🏿‍💻", name: "woman technologist: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((942, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 948, emoji: "🧑‍🎤", name: "singer", group: Group::PeopleAndBody, skin_tone: Some((948, SkinTone::Default)), aliases: Some(&["singer"]), variations: &[] },
    Emoji { id: 949, emoji: "🧑🏻‍🎤", name: "singer: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((948, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 950, emoji: "🧑🏼‍🎤", name: "singer: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((948, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 951, emoji: "🧑🏽‍🎤", name: "singer: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((948, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 952, emoji: "🧑🏾‍🎤", name: "singer: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((948, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 953, emoji: "🧑🏿‍🎤", name: "singer: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((948, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 954, emoji: "👨‍🎤", name: "man singer", group: Group::PeopleAndBody, skin_tone: Some((954, SkinTone::Default)), aliases: Some(&["man_singer"]), variations: &[] },
    Emoji { id: 955, emoji: "👨🏻‍🎤", name: "man singer: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((954, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 956, emoji: "👨🏼‍🎤", name: "man singer: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((954, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 957, emoji: "👨🏽‍🎤", name: "man singer: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((954, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 958, emoji: "👨🏾‍🎤", name: "man singer: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((954, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 959, emoji: "👨🏿‍🎤", name: "man singer: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((954, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 960, emoji: "👩‍🎤", name: "woman singer", group: Group::PeopleAndBody, skin_tone: Some((960, SkinTone::Default)), aliases: Some(&["woman_singer"]), variations: &[] },
    Emoji { id: 961, emoji: "👩🏻‍🎤", name: "woman singer: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((960, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 962, emoji: "👩🏼‍🎤", name: "woman singer: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((960, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 963, emoji: "👩🏽‍🎤", name: "woman singer: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((960, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 964, emoji: "👩🏾‍🎤", name: "woman singer: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((960, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 965, emoji: "👩🏿‍🎤", name: "woman singer: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((960, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 966, emoji: "🧑‍🎨", name: "artist", group: Group::PeopleAndBody, skin_tone: Some((966, SkinTone::Default)), aliases: Some(&["artist"]), variations: &[] },
    Emoji { id: 967, emoji: "🧑🏻‍🎨", name: "artist: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((966, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 968, emoji: "🧑🏼‍🎨", name: "artist: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((966, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 969, emoji: "🧑🏽‍🎨", name: "artist: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((966, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 970, emoji: "🧑🏾‍🎨", name: "artist: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((966, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 971, emoji: "🧑🏿‍🎨", name: "artist: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((966, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 972, emoji: "👨‍🎨", name: "man artist", group: Group::PeopleAndBody, skin_tone: Some((972, SkinTone::Default)), aliases: Some(&["man_artist"]), variations: &[] },
    Emoji { id: 973, emoji: "👨🏻‍🎨", name: "man artist: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((972, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 974, emoji: "👨🏼‍🎨", name: "man artist: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((972, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 975, emoji: "👨🏽‍🎨", name: "man artist: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((972, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 976, emoji: "👨🏾‍🎨", name: "man artist: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((972, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 977, emoji: "👨🏿‍🎨", name: "man artist: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((972, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 978, emoji: "👩‍🎨", name: "woman artist", group: Group::PeopleAndBody, skin_tone: Some((978, SkinTone::Default)), aliases: Some(&["woman_artist"]), variations: &[] },
    Emoji { id: 979, emoji: "👩🏻‍🎨", name: "woman artist: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((978, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 980, emoji: "👩🏼‍🎨", name: "woman artist: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((978, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 981, emoji: "👩🏽‍🎨", name: "woman artist: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((978, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 982, emoji: "👩🏾‍🎨", name: "woman artist: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((978, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 983, emoji: "👩🏿‍🎨", name: "woman artist: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((978, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 984, emoji: "🧑‍✈️", name: "pilot", group: Group::PeopleAndBody, skin_tone: Some((984, SkinTone::Default)), aliases: Some(&["pilot"]), variations: &["🧑\u{200d}✈"] },
    Emoji { id: 985, emoji: "🧑🏻‍✈️", name: "pilot: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((984, SkinTone::Light)), aliases: None, variations: &["🧑🏻\u{200d}✈"] },
    Emoji { id: 986, emoji: "🧑🏼‍✈️", name: "pilot: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((984, SkinTone::MediumLight)), aliases: None, variations: &["🧑🏼\u{200d}✈"] },
    Emoji { id: 987, emoji: "🧑🏽‍✈️", name: "pilot: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((984, SkinTone::Medium)), aliases: None, variations: &["🧑🏽\u{200d}✈"] },
    Emoji { id: 988, emoji: "🧑🏾‍✈️", name: "pilot: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((984, SkinTone::MediumDark)), aliases: None, variations: &["🧑🏾\u{200d}✈"] },
    Emoji { id: 989, emoji: "🧑🏿‍✈️", name: "pilot: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((984, SkinTone::Dark)), aliases: None, variations: &["🧑🏿\u{200d}✈"] },
    Emoji { id: 990, emoji: "👨‍✈️", name: "man pilot", group: Group::PeopleAndBody, skin_tone: Some((990, SkinTone::Default)), aliases: Some(&["man_pilot"]), variations: &["👨\u{200d}✈"] },
    Emoji { id: 991, emoji: "👨🏻‍✈️", name: "man pilot: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((990, SkinTone::Light)), aliases: None, variations: &["👨🏻\u{200d}✈"] },
    Emoji { id: 992, emoji: "👨🏼‍✈️", name: "man pilot: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((990, SkinTone::MediumLight)), aliases: None, variations: &["👨🏼\u{200d}✈"] },
    Emoji { id: 993, emoji: "👨🏽‍✈️", name: "man pilot: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((990, SkinTone::Medium)), aliases: None, variations: &["👨🏽\u{200d}✈"] },
    Emoji { id: 994, emoji: "👨🏾‍✈️", name: "man pilot: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((990, SkinTone::MediumDark)), aliases: None, variations: &["👨🏾\u{200d}✈"] },
    Emoji { id: 995, emoji: "👨🏿‍✈️", name: "man pilot: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((990, SkinTone::Dark)), aliases: None, variations: &["👨🏿\u{200d}✈"] },
    Emoji { id: 996, emoji: "👩‍✈️", name: "woman pilot", group: Group::PeopleAndBody, skin_tone: Some((996, SkinTone::Default)), aliases: Some(&["woman_pilot"]), variations: &["👩\u{200d}✈"] },
    Emoji { id: 997, emoji: "👩🏻‍✈️", name: "woman pilot: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((996, SkinTone::Light)), aliases: None, variations: &["👩🏻\u{200d}✈"] },
    Emoji { id: 998, emoji: "👩🏼‍✈️", name: "woman pilot: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((996, SkinTone::MediumLight)), aliases: None, variations: &["👩🏼\u{200d}✈"] },
    Emoji { id: 999, emoji: "👩🏽‍✈️", name: "woman pilot: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((996, SkinTone::Medium)), aliases: None, variations: &["👩🏽\u{200d}✈"] },
    Emoji { id: 1000, emoji: "👩🏾‍✈️", name: "woman pilot: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((996, SkinTone::MediumDark)), aliases: None, variations: &["👩🏾\u{200d}✈"] },
    Emoji { id: 1001, emoji: "👩🏿‍✈️", name: "woman pilot: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((996, SkinTone::Dark)), aliases: None, variations: &["👩🏿\u{200d}✈"] },
    Emoji { id: 1002, emoji: "🧑‍🚀", name: "astronaut", group: Group::PeopleAndBody, skin_tone: Some((1002, SkinTone::Default)), aliases: Some(&["astronaut"]), variations: &[] },
    Emoji { id: 1003, emoji: "🧑🏻‍🚀", name: "astronaut: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1002, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 1004, emoji: "🧑🏼‍🚀", name: "astronaut: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1002, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 1005, emoji: "🧑🏽‍🚀", name: "astronaut: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1002, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 1006, emoji: "🧑🏾‍🚀", name: "astronaut: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1002, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 1007, emoji: "🧑🏿‍🚀", name: "astronaut: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1002, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 1008, emoji: "👨‍🚀", name: "man astronaut", group: Group::PeopleAndBody, skin_tone: Some((1008, SkinTone::Default)), aliases: Some(&["man_astronaut"]), variations: &[] },
    Emoji { id: 1009, emoji: "👨🏻‍🚀", name: "man astronaut: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1008, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 1010, emoji: "👨🏼‍🚀", name: "man astronaut: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1008, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 1011, emoji: "👨🏽‍🚀", name: "man astronaut: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1008, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 1012, emoji: "👨🏾‍🚀", name: "man astronaut: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1008, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 1013, emoji: "👨🏿‍🚀", name: "man astronaut: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1008, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 1014, emoji: "👩‍🚀", name: "woman astronaut", group: Group::PeopleAndBody, skin_tone: Some((1014, SkinTone::Default)), aliases: Some(&["woman_astronaut"]), variations: &[] },
    Emoji { id: 1015, emoji: "👩🏻‍🚀", name: "woman astronaut: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1014, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 1016, emoji: "👩🏼‍🚀", name: "woman astronaut: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1014, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 1017, emoji: "👩🏽‍🚀", name: "woman astronaut: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1014, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 1018, emoji: "👩🏾‍🚀", name: "woman astronaut: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1014, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 1019, emoji: "👩🏿‍🚀", name: "woman astronaut: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1014, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 1020, emoji: "🧑‍🚒", name: "firefighter", group: Group::PeopleAndBody, skin_tone: Some((1020, SkinTone::Default)), aliases: Some(&["firefighter"]), variations: &[] },
    Emoji { id: 1021, emoji: "🧑🏻‍🚒", name: "firefighter: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1020, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 1022, emoji: "🧑🏼‍🚒", name: "firefighter: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1020, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 1023, emoji: "🧑🏽‍🚒", name: "firefighter: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1020, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 1024, emoji: "🧑🏾‍🚒", name: "firefighter: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1020, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 1025, emoji: "🧑🏿‍🚒", name: "firefighter: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1020, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 1026, emoji: "👨‍🚒", name: "man firefighter", group: Group::PeopleAndBody, skin_tone: Some((1026, SkinTone::Default)), aliases: Some(&["man_firefighter"]), variations: &[] },
    Emoji { id: 1027, emoji: "👨🏻‍🚒", name: "man firefighter: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1026, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 1028, emoji: "👨🏼‍🚒", name: "man firefighter: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1026, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 1029, emoji: "👨🏽‍🚒", name: "man firefighter: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1026, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 1030, emoji: "👨🏾‍🚒", name: "man firefighter: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1026, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 1031, emoji: "👨🏿‍🚒", name: "man firefighter: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1026, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 1032, emoji: "👩‍🚒", name: "woman firefighter", group: Group::PeopleAndBody, skin_tone: Some((1032, SkinTone::Default)), aliases: Some(&["woman_firefighter"]), variations: &[] },
    Emoji { id: 1033, emoji: "👩🏻‍🚒", name: "woman firefighter: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1032, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 1034, emoji: "👩🏼‍🚒", name: "woman firefighter: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1032, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 1035, emoji: "👩🏽‍🚒", name: "woman firefighter: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1032, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 1036, emoji: "👩🏾‍🚒", name: "woman firefighter: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1032, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 1037, emoji: "👩🏿‍🚒", name: "woman firefighter: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1032, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 1038, emoji: "👮", name: "police officer", group: Group::PeopleAndBody, skin_tone: Some((1038, SkinTone::Default)), aliases: Some(&["police_officer", "cop"]), variations: &[] },
    Emoji { id: 1039, emoji: "👮🏻", name: "police officer: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1038, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 1040, emoji: "👮🏼", name: "police officer: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1038, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 1041, emoji: "👮🏽", name: "police officer: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1038, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 1042, emoji: "👮🏾", name: "police officer: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1038, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 1043, emoji: "👮🏿", name: "police officer: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1038, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 1044, emoji: "👮‍♂️", name: "man police officer", group: Group::PeopleAndBody, skin_tone: Some((1044, SkinTone::Default)), aliases: Some(&["policeman"]), variations: &["👮\u{200d}♂"] },
    Emoji { id: 1045, emoji: "👮🏻‍♂️", name: "man police officer: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1044, SkinTone::Light)), aliases: None, variations: &["👮🏻\u{200d}♂"] },
    Emoji { id: 1046, emoji: "👮🏼‍♂️", name: "man police officer: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1044, SkinTone::MediumLight)), aliases: None, variations: &["👮🏼\u{200d}♂"] },
    Emoji { id: 1047, emoji: "👮🏽‍♂️", name: "man police officer: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1044, SkinTone::Medium)), aliases: None, variations: &["👮🏽\u{200d}♂"] },
    Emoji { id: 1048, emoji: "👮🏾‍♂️", name: "man police officer: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1044, SkinTone::MediumDark)), aliases: None, variations: &["👮🏾\u{200d}♂"] },
    Emoji { id: 1049, emoji: "👮🏿‍♂️", name: "man police officer: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1044, SkinTone::Dark)), aliases: None, variations: &["👮🏿\u{200d}♂"] },
    Emoji { id: 1050, emoji: "👮‍♀️", name: "woman police officer", group: Group::PeopleAndBody, skin_tone: Some((1050, SkinTone::Default)), aliases: Some(&["policewoman"]), variations: &["👮\u{200d}♀"] },
    Emoji { id: 1051, emoji: "👮🏻‍♀️", name: "woman police officer: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1050, SkinTone::Light)), aliases: None, variations: &["👮🏻\u{200d}♀"] },
    Emoji { id: 1052, emoji: "👮🏼‍♀️", name: "woman police officer: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1050, SkinTone::MediumLight)), aliases: None, variations: &["👮🏼\u{200d}♀"] },
    Emoji { id: 1053, emoji: "👮🏽‍♀️", name: "woman police officer: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1050, SkinTone::Medium)), aliases: None, variations: &["👮🏽\u{200d}♀"] },
    Emoji { id: 1054, emoji: "👮🏾‍♀️", name: "woman police officer: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1050, SkinTone::MediumDark)), aliases: None, variations: &["👮🏾\u{200d}♀"] },
    Emoji { id: 1055, emoji: "👮🏿‍♀️", name: "woman police officer: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1050, SkinTone::Dark)), aliases: None, variations: &["👮🏿\u{200d}♀"] },
    Emoji { id: 1056, emoji: "🕵️", name: "detective", group: Group::PeopleAndBody, skin_tone: Some((1056, SkinTone::Default)), aliases: Some(&["detective"]), variations: &["🕵"] },
    Emoji { id: 1057, emoji: "🕵🏻", name: "detective: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1056, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 1058, emoji: "🕵🏼", name: "detective: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1056, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 1059, emoji: "🕵🏽", name: "detective: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1056, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 1060, emoji: "🕵🏾", name: "detective: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1056, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 1061, emoji: "🕵🏿", name: "detective: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1056, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 1062, emoji: "🕵️‍♂️", name: "man detective", group: Group::PeopleAndBody, skin_tone: Some((1062, SkinTone::Default)), aliases: Some(&["male_detective"]), variations: &["🕵\u{200d}♂\u{fe0f}", "🕵\u{fe0f}\u{200d}♂", "🕵\u{200d}♂"] },
    Emoji { id: 1063, emoji: "🕵🏻‍♂️", name: "man detective: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1062, SkinTone::Light)), aliases: None, variations: &["🕵🏻\u{200d}♂"] },
    Emoji { id: 1064, emoji: "🕵🏼‍♂️", name: "man detective: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1062, SkinTone::MediumLight)), aliases: None, variations: &["🕵🏼\u{200d}♂"] },
    Emoji { id: 1065, emoji: "🕵🏽‍♂️", name: "man detective: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1062, SkinTone::Medium)), aliases: None, variations: &["🕵🏽\u{200d}♂"] },
    Emoji { id: 1066, emoji: "🕵🏾‍♂️", name: "man detective: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1062, SkinTone::MediumDark)), aliases: None, variations: &["🕵🏾\u{200d}♂"] },
    Emoji { id: 1067, emoji: "🕵🏿‍♂️", name: "man detective: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1062, SkinTone::Dark)), aliases: None, variations: &["🕵🏿\u{200d}♂"] },
    Emoji { id: 1068, emoji: "🕵️‍♀️", name: "woman detective", group: Group::PeopleAndBody, skin_tone: Some((1068, SkinTone::Default)), aliases: Some(&["female_detective"]), variations: &["🕵\u{200d}♀\u{fe0f}", "🕵\u{fe0f}\u{200d}♀", "🕵\u{200d}♀"] },
    Emoji { id: 1069, emoji: "🕵🏻‍♀️", name: "woman detective: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1068, SkinTone::Light)), aliases: None, variations: &["🕵🏻\u{200d}♀"] },
    Emoji { id: 1070, emoji: "🕵🏼‍♀️", name: "woman detective: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1068, SkinTone::MediumLight)), aliases: None, variations: &["🕵🏼\u{200d}♀"] },
    Emoji { id: 1071, emoji: "🕵🏽‍♀️", name: "woman detective: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1068, SkinTone::Medium)), aliases: None, variations: &["🕵🏽\u{200d}♀"] },
    Emoji { id: 1072, emoji: "🕵🏾‍♀️", name: "woman detective: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1068, SkinTone::MediumDark)), aliases: None, variations: &["🕵🏾\u{200d}♀"] },
    Emoji { id: 1073, emoji: "🕵🏿‍♀️", name: "woman detective: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1068, SkinTone::Dark)), aliases: None, variations: &["🕵🏿\u{200d}♀"] },
    Emoji { id: 1074, emoji: "💂", name: "guard", group: Group::PeopleAndBody, skin_tone: Some((1074, SkinTone::Default)), aliases: Some(&["guard"]), variations: &[] },
    Emoji { id: 1075, emoji: "💂🏻", name: "guard: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1074, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 1076, emoji: "💂🏼", name: "guard: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1074, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 1077, emoji: "💂🏽", name: "guard: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1074, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 1078, emoji: "💂🏾", name: "guard: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1074, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 1079, emoji: "💂🏿", name: "guard: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1074, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 1080, emoji: "💂‍♂️", name: "man guard", group: Group::PeopleAndBody, skin_tone: Some((1080, SkinTone::Default)), aliases: Some(&["guardsman"]), variations: &["💂\u{200d}♂"] },
    Emoji { id: 1081, emoji: "💂🏻‍♂️", name: "man guard: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1080, SkinTone::Light)), aliases: None, variations: &["💂🏻\u{200d}♂"] },
    Emoji { id: 1082, emoji: "💂🏼‍♂️", name: "man guard: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1080, SkinTone::MediumLight)), aliases: None, variations: &["💂🏼\u{200d}♂"] },
    Emoji { id: 1083, emoji: "💂🏽‍♂️", name: "man guard: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1080, SkinTone::Medium)), aliases: None, variations: &["💂🏽\u{200d}♂"] },
    Emoji { id: 1084, emoji: "💂🏾‍♂️", name: "man guard: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1080, SkinTone::MediumDark)), aliases: None, variations: &["💂🏾\u{200d}♂"] },
    Emoji { id: 1085, emoji: "💂🏿‍♂️", name: "man guard: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1080, SkinTone::Dark)), aliases: None, variations: &["💂🏿\u{200d}♂"] },
    Emoji { id: 1086, emoji: "💂‍♀️", name: "woman guard", group: Group::PeopleAndBody, skin_tone: Some((1086, SkinTone::Default)), aliases: Some(&["guardswoman"]), variations: &["💂\u{200d}♀"] },
    Emoji { id: 1087, emoji: "💂🏻‍♀️", name: "woman guard: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1086, SkinTone::Light)), aliases: None, variations: &["💂🏻\u{200d}♀"] },
    Emoji { id: 1088, emoji: "💂🏼‍♀️", name: "woman guard: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1086, SkinTone::MediumLight)), aliases: None, variations: &["💂🏼\u{200d}♀"] },
    Emoji { id: 1089, emoji: "💂🏽‍♀️", name: "woman guard: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1086, SkinTone::Medium)), aliases: None, variations: &["💂🏽\u{200d}♀"] },
    Emoji { id: 1090, emoji: "💂🏾‍♀️", name: "woman guard: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1086, SkinTone::MediumDark)), aliases: None, variations: &["💂🏾\u{200d}♀"] },
    Emoji { id: 1091, emoji: "💂🏿‍♀️", name: "woman guard: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1086, SkinTone::Dark)), aliases: None, variations: &["💂🏿\u{200d}♀"] },
    Emoji { id: 1092, emoji: "🥷", name: "ninja", group: Group::PeopleAndBody, skin_tone: Some((1092, SkinTone::Default)), aliases: Some(&["ninja"]), variations: &[] },
    Emoji { id: 1093, emoji: "🥷🏻", name: "ninja: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1092, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 1094, emoji: "🥷🏼", name: "ninja: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1092, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 1095, emoji: "🥷🏽", name: "ninja: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1092, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 1096, emoji: "🥷🏾", name: "ninja: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1092, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 1097, emoji: "🥷🏿", name: "ninja: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1092, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 1098, emoji: "👷", name: "construction worker", group: Group::PeopleAndBody, skin_tone: Some((1098, SkinTone::Default)), aliases: Some(&["construction_worker"]), variations: &[] },
    Emoji { id: 1099, emoji: "👷🏻", name: "construction worker: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1098, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 1100, emoji: "👷🏼", name: "construction worker: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1098, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 1101, emoji: "👷🏽", name: "construction worker: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1098, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 1102, emoji: "👷🏾", name: "construction worker: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1098, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 1103, emoji: "👷🏿", name: "construction worker: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1098, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 1104, emoji: "👷‍♂️", name: "man construction worker", group: Group::PeopleAndBody, skin_tone: Some((1104, SkinTone::Default)), aliases: Some(&["construction_worker_man"]), variations: &["👷\u{200d}♂"] },
    Emoji { id: 1105, emoji: "👷🏻‍♂️", name: "man construction worker: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1104, SkinTone::Light)), aliases: None, variations: &["👷🏻\u{200d}♂"] },
    Emoji { id: 1106, emoji: "👷🏼‍♂️", name: "man construction worker: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1104, SkinTone::MediumLight)), aliases: None, variations: &["👷🏼\u{200d}♂"] },
    Emoji { id: 1107, emoji: "👷🏽‍♂️", name: "man construction worker: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1104, SkinTone::Medium)), aliases: None, variations: &["👷🏽\u{200d}♂"] },
    Emoji { id: 1108, emoji: "👷🏾‍♂️", name: "man construction worker: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1104, SkinTone::MediumDark)), aliases: None, variations: &["👷🏾\u{200d}♂"] },
    Emoji { id: 1109, emoji: "👷🏿‍♂️", name: "man construction worker: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1104, SkinTone::Dark)), aliases: None, variations: &["👷🏿\u{200d}♂"] },
    Emoji { id: 1110, emoji: "👷‍♀️", name: "woman construction worker", group: Group::PeopleAndBody, skin_tone: Some((1110, SkinTone::Default)), aliases: Some(&["construction_worker_woman"]), variations: &["👷\u{200d}♀"] },
    Emoji { id: 1111, emoji: "👷🏻‍♀️", name: "woman construction worker: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1110, SkinTone::Light)), aliases: None, variations: &["👷🏻\u{200d}♀"] },
    Emoji { id: 1112, emoji: "👷🏼‍♀️", name: "woman construction worker: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1110, SkinTone::MediumLight)), aliases: None, variations: &["👷🏼\u{200d}♀"] },
    Emoji { id: 1113, emoji: "👷🏽‍♀️", name: "woman construction worker: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1110, SkinTone::Medium)), aliases: None, variations: &["👷🏽\u{200d}♀"] },
    Emoji { id: 1114, emoji: "👷🏾‍♀️", name: "woman construction worker: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1110, SkinTone::MediumDark)), aliases: None, variations: &["👷🏾\u{200d}♀"] },
    Emoji { id: 1115, emoji: "👷🏿‍♀️", name: "woman construction worker: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1110, SkinTone::Dark)), aliases: None, variations: &["👷🏿\u{200d}♀"] },
    Emoji { id: 1116, emoji: "🤴", name: "prince", group: Group::PeopleAndBody, skin_tone: Some((1116, SkinTone::Default)), aliases: Some(&["prince"]), variations: &[] },
    Emoji { id: 1117, emoji: "🤴🏻", name: "prince: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1116, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 1118, emoji: "🤴🏼", name: "prince: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1116, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 1119, emoji: "🤴🏽", name: "prince: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1116, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 1120, emoji: "🤴🏾", name: "prince: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1116, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 1121, emoji: "🤴🏿", name: "prince: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1116, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 1122, emoji: "👸", name: "princess", group: Group::PeopleAndBody, skin_tone: Some((1122, SkinTone::Default)), aliases: Some(&["princess"]), variations: &[] },
    Emoji { id: 1123, emoji: "👸🏻", name: "princess: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1122, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 1124, emoji: "👸🏼", name: "princess: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1122, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 1125, emoji: "👸🏽", name: "princess: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1122, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 1126, emoji: "👸🏾", name: "princess: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1122, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 1127, emoji: "👸🏿", name: "princess: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1122, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 1128, emoji: "👳", name: "person wearing turban", group: Group::PeopleAndBody, skin_tone: Some((1128, SkinTone::Default)), aliases: Some(&["person_with_turban"]), variations: &[] },
    Emoji { id: 1129, emoji: "👳🏻", name: "person wearing turban: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1128, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 1130, emoji: "👳🏼", name: "person wearing turban: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1128, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 1131, emoji: "👳🏽", name: "person wearing turban: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1128, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 1132, emoji: "👳🏾", name: "person wearing turban: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1128, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 1133, emoji: "👳🏿", name: "person wearing turban: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1128, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 1134, emoji: "👳‍♂️", name: "man wearing turban", group: Group::PeopleAndBody, skin_tone: Some((1134, SkinTone::Default)), aliases: Some(&["man_with_turban"]), variations: &["👳\u{200d}♂"] },
    Emoji { id: 1135, emoji: "👳🏻‍♂️", name: "man wearing turban: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1134, SkinTone::Light)), aliases: None, variations: &["👳🏻\u{200d}♂"] },
    Emoji { id: 1136, emoji: "👳🏼‍♂️", name: "man wearing turban: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1134, SkinTone::MediumLight)), aliases: None, variations: &["👳🏼\u{200d}♂"] },
    Emoji { id: 1137, emoji: "👳🏽‍♂️", name: "man wearing turban: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1134, SkinTone::Medium)), aliases: None, variations: &["👳🏽\u{200d}♂"] },
    Emoji { id: 1138, emoji: "👳🏾‍♂️", name: "man wearing turban: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1134, SkinTone::MediumDark)), aliases: None, variations: &["👳🏾\u{200d}♂"] },
    Emoji { id: 1139, emoji: "👳🏿‍♂️", name: "man wearing turban: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1134, SkinTone::Dark)), aliases: None, variations: &["👳🏿\u{200d}♂"] },
    Emoji { id: 1140, emoji: "👳‍♀️", name: "woman wearing turban", group: Group::PeopleAndBody, skin_tone: Some((1140, SkinTone::Default)), aliases: Some(&["woman_with_turban"]), variations: &["👳\u{200d}♀"] },
    Emoji { id: 1141, emoji: "👳🏻‍♀️", name: "woman wearing turban: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1140, SkinTone::Light)), aliases: None, variations: &["👳🏻\u{200d}♀"] },
    Emoji { id: 1142, emoji: "👳🏼‍♀️", name: "woman wearing turban: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1140, SkinTone::MediumLight)), aliases: None, variations: &["👳🏼\u{200d}♀"] },
    Emoji { id: 1143, emoji: "👳🏽‍♀️", name: "woman wearing turban: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1140, SkinTone::Medium)), aliases: None, variations: &["👳🏽\u{200d}♀"] },
    Emoji { id: 1144, emoji: "👳🏾‍♀️", name: "woman wearing turban: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1140, SkinTone::MediumDark)), aliases: None, variations: &["👳🏾\u{200d}♀"] },
    Emoji { id: 1145, emoji: "👳🏿‍♀️", name: "woman wearing turban: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1140, SkinTone::Dark)), aliases: None, variations: &["👳🏿\u{200d}♀"] },
    Emoji { id: 1146, emoji: "👲", name: "person with skullcap", group: Group::PeopleAndBody, skin_tone: Some((1146, SkinTone::Default)), aliases: Some(&["man_with_gua_pi_mao"]), variations: &[] },
    Emoji { id: 1147, emoji: "👲🏻", name: "person with skullcap: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1146, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 1148, emoji: "👲🏼", name: "person with skullcap: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1146, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 1149, emoji: "👲🏽", name: "person with skullcap: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1146, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 1150, emoji: "👲🏾", name: "person with skullcap: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1146, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 1151, emoji: "👲🏿", name: "person with skullcap: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1146, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 1152, emoji: "🧕", name: "woman with headscarf", group: Group::PeopleAndBody, skin_tone: Some((1152, SkinTone::Default)), aliases: Some(&["woman_with_headscarf"]), variations: &[] },
    Emoji { id: 1153, emoji: "🧕🏻", name: "woman with headscarf: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1152, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 1154, emoji: "🧕🏼", name: "woman with headscarf: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1152, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 1155, emoji: "🧕🏽", name: "woman with headscarf: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1152, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 1156, emoji: "🧕🏾", name: "woman with headscarf: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1152, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 1157, emoji: "🧕🏿", name: "woman with headscarf: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1152, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 1158, emoji: "🤵", name: "person in tuxedo", group: Group::PeopleAndBody, skin_tone: Some((1158, SkinTone::Default)), aliases: Some(&["person_in_tuxedo"]), variations: &[] },
    Emoji { id: 1159, emoji: "🤵🏻", name: "person in tuxedo: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1158, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 1160, emoji: "🤵🏼", name: "person in tuxedo: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1158, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 1161, emoji: "🤵🏽", name: "person in tuxedo: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1158, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 1162, emoji: "🤵🏾", name: "person in tuxedo: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1158, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 1163, emoji: "🤵🏿", name: "person in tuxedo: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1158, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 1164, emoji: "🤵‍♂️", name: "man in tuxedo", group: Group::PeopleAndBody, skin_tone: Some((1164, SkinTone::Default)), aliases: Some(&["man_in_tuxedo"]), variations: &["🤵\u{200d}♂"] },
    Emoji { id: 1165, emoji: "🤵🏻‍♂️", name: "man in tuxedo: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1164, SkinTone::Light)), aliases: None, variations: &["🤵🏻\u{200d}♂"] },
    Emoji { id: 1166, emoji: "🤵🏼‍♂️", name: "man in tuxedo: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1164, SkinTone::MediumLight)), aliases: None, variations: &["🤵🏼\u{200d}♂"] },
    Emoji { id: 1167, emoji: "🤵🏽‍♂️", name: "man in tuxedo: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1164, SkinTone::Medium)), aliases: None, variations: &["🤵🏽\u{200d}♂"] },
    Emoji { id: 1168, emoji: "🤵🏾‍♂️", name: "man in tuxedo: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1164, SkinTone::MediumDark)), aliases: None, variations: &["🤵🏾\u{200d}♂"] },
    Emoji { id: 1169, emoji: "🤵🏿‍♂️", name: "man in tuxedo: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1164, SkinTone::Dark)), aliases: None, variations: &["🤵🏿\u{200d}♂"] },
    Emoji { id: 1170, emoji: "🤵‍♀️", name: "woman in tuxedo", group: Group::PeopleAndBody, skin_tone: Some((1170, SkinTone::Default)), aliases: Some(&["woman_in_tuxedo"]), variations: &["🤵\u{200d}♀"] },
    Emoji { id: 1171, emoji: "🤵🏻‍♀️", name: "woman in tuxedo: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1170, SkinTone::Light)), aliases: None, variations: &["🤵🏻\u{200d}♀"] },
    Emoji { id: 1172, emoji: "🤵🏼‍♀️", name: "woman in tuxedo: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1170, SkinTone::MediumLight)), aliases: None, variations: &["🤵🏼\u{200d}♀"] },
    Emoji { id: 1173, emoji: "🤵🏽‍♀️", name: "woman in tuxedo: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1170, SkinTone::Medium)), aliases: None, variations: &["🤵🏽\u{200d}♀"] },
    Emoji { id: 1174, emoji: "🤵🏾‍♀️", name: "woman in tuxedo: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1170, SkinTone::MediumDark)), aliases: None, variations: &["🤵🏾\u{200d}♀"] },
    Emoji { id: 1175, emoji: "🤵🏿‍♀️", name: "woman in tuxedo: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1170, SkinTone::Dark)), aliases: None, variations: &["🤵🏿\u{200d}♀"] },
    Emoji { id: 1176, emoji: "👰", name: "person with veil", group: Group::PeopleAndBody, skin_tone: Some((1176, SkinTone::Default)), aliases: Some(&["person_with_veil"]), variations: &[] },
    Emoji { id: 1177, emoji: "👰🏻", name: "person with veil: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1176, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 1178, emoji: "👰🏼", name: "person with veil: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1176, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 1179, emoji: "👰🏽", name: "person with veil: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1176, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 1180, emoji: "👰🏾", name: "person with veil: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1176, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 1181, emoji: "👰🏿", name: "person with veil: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1176, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 1182, emoji: "👰‍♂️", name: "man with veil", group: Group::PeopleAndBody, skin_tone: Some((1182, SkinTone::Default)), aliases: Some(&["man_with_veil"]), variations: &["👰\u{200d}♂"] },
    Emoji { id: 1183, emoji: "👰🏻‍♂️", name: "man with veil: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1182, SkinTone::Light)), aliases: None, variations: &["👰🏻\u{200d}♂"] },
    Emoji { id: 1184, emoji: "👰🏼‍♂️", name: "man with veil: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1182, SkinTone::MediumLight)), aliases: None, variations: &["👰🏼\u{200d}♂"] },
    Emoji { id: 1185, emoji: "👰🏽‍♂️", name: "man with veil: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1182, SkinTone::Medium)), aliases: None, variations: &["👰🏽\u{200d}♂"] },
    Emoji { id: 1186, emoji: "👰🏾‍♂️", name: "man with veil: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1182, SkinTone::MediumDark)), aliases: None, variations: &["👰🏾\u{200d}♂"] },
    Emoji { id: 1187, emoji: "👰🏿‍♂️", name: "man with veil: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1182, SkinTone::Dark)), aliases: None, variations: &["👰🏿\u{200d}♂"] },
    Emoji { id: 1188, emoji: "👰‍♀️", name: "woman with veil", group: Group::PeopleAndBody, skin_tone: Some((1188, SkinTone::Default)), aliases: Some(&["woman_with_veil", "bride_with_veil"]), variations: &["👰\u{200d}♀"] },
    Emoji { id: 1189, emoji: "👰🏻‍♀️", name: "woman with veil: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1188, SkinTone::Light)), aliases: None, variations: &["👰🏻\u{200d}♀"] },
    Emoji { id: 1190, emoji: "👰🏼‍♀️", name: "woman with veil: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1188, SkinTone::MediumLight)), aliases: None, variations: &["👰🏼\u{200d}♀"] },
    Emoji { id: 1191, emoji: "👰🏽‍♀️", name: "woman with veil: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1188, SkinTone::Medium)), aliases: None, variations: &["👰🏽\u{200d}♀"] },
    Emoji { id: 1192, emoji: "👰🏾‍♀️", name: "woman with veil: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1188, SkinTone::MediumDark)), aliases: None, variations: &["👰🏾\u{200d}♀"] },
    Emoji { id: 1193, emoji: "👰🏿‍♀️", name: "woman with veil: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1188, SkinTone::Dark)), aliases: None, variations: &["👰🏿\u{200d}♀"] },
    Emoji { id: 1194, emoji: "🤰", name: "pregnant woman", group: Group::PeopleAndBody, skin_tone: Some((1194, SkinTone::Default)), aliases: Some(&["pregnant_woman"]), variations: &[] },
    Emoji { id: 1195, emoji: "🤰🏻", name: "pregnant woman: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1194, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 1196, emoji: "🤰🏼", name: "pregnant woman: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1194, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 1197, emoji: "🤰🏽", name: "pregnant woman: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1194, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 1198, emoji: "🤰🏾", name: "pregnant woman: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1194, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 1199, emoji: "🤰🏿", name: "pregnant woman: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1194, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 1200, emoji: "🤱", name: "breast-feeding", group: Group::PeopleAndBody, skin_tone: Some((1200, SkinTone::Default)), aliases: Some(&["breast_feeding"]), variations: &[] },
    Emoji { id: 1201, emoji: "🤱🏻", name: "breast-feeding: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1200, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 1202, emoji: "🤱🏼", name: "breast-feeding: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1200, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 1203, emoji: "🤱🏽", name: "breast-feeding: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1200, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 1204, emoji: "🤱🏾", name: "breast-feeding: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1200, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 1205, emoji: "🤱🏿", name: "breast-feeding: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1200, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 1206, emoji: "👩‍🍼", name: "woman feeding baby", group: Group::PeopleAndBody, skin_tone: Some((1206, SkinTone::Default)), aliases: Some(&["woman_feeding_baby"]), variations: &[] },
    Emoji { id: 1207, emoji: "👩🏻‍🍼", name: "woman feeding baby: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1206, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 1208, emoji: "👩🏼‍🍼", name: "woman feeding baby: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1206, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 1209, emoji: "👩🏽‍🍼", name: "woman feeding baby: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1206, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 1210, emoji: "👩🏾‍🍼", name: "woman feeding baby: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1206, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 1211, emoji: "👩🏿‍🍼", name: "woman feeding baby: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1206, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 1212, emoji: "👨‍🍼", name: "man feeding baby", group: Group::PeopleAndBody, skin_tone: Some((1212, SkinTone::Default)), aliases: Some(&["man_feeding_baby"]), variations: &[] },
    Emoji { id: 1213, emoji: "👨🏻‍🍼", name: "man feeding baby: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1212, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 1214, emoji: "👨🏼‍🍼", name: "man feeding baby: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1212, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 1215, emoji: "👨🏽‍🍼", name: "man feeding baby: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1212, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 1216, emoji: "👨🏾‍🍼", name: "man feeding baby: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1212, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 1217, emoji: "👨🏿‍🍼", name: "man feeding baby: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1212, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 1218, emoji: "🧑‍🍼", name: "person feeding baby", group: Group::PeopleAndBody, skin_tone: Some((1218, SkinTone::Default)), aliases: Some(&["person_feeding_baby"]), variations: &[] },
    Emoji { id: 1219, emoji: "🧑🏻‍🍼", name: "person feeding baby: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1218, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 1220, emoji: "🧑🏼‍🍼", name: "person feeding baby: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1218, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 1221, emoji: "🧑🏽‍🍼", name: "person feeding baby: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1218, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 1222, emoji: "🧑🏾‍🍼", name: "person feeding baby: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1218, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 1223, emoji: "🧑🏿‍🍼", name: "person feeding baby: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1218, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 1224, emoji: "👼", name: "baby angel", group: Group::PeopleAndBody, skin_tone: Some((1224, SkinTone::Default)), aliases: Some(&["angel"]), variations: &[] },
    Emoji { id: 1225, emoji: "👼🏻", name: "baby angel: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1224, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 1226, emoji: "👼🏼", name: "baby angel: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1224, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 1227, emoji: "👼🏽", name: "baby angel: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1224, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 1228, emoji: "👼🏾", name: "baby angel: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1224, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 1229, emoji: "👼🏿", name: "baby angel: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1224, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 1230, emoji: "🎅", name: "Santa Claus", group: Group::PeopleAndBody, skin_tone: Some((1230, SkinTone::Default)), aliases: Some(&["santa"]), variations: &[] },
    Emoji { id: 1231, emoji: "🎅🏻", name: "Santa Claus: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1230, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 1232, emoji: "🎅🏼", name: "Santa Claus: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1230, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 1233, emoji: "🎅🏽", name: "Santa Claus: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1230, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 1234, emoji: "🎅🏾", name: "Santa Claus: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1230, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 1235, emoji: "🎅🏿", name: "Santa Claus: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1230, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 1236, emoji: "🤶", name: "Mrs. Claus", group: Group::PeopleAndBody, skin_tone: Some((1236, SkinTone::Default)), aliases: Some(&["mrs_claus"]), variations: &[] },
    Emoji { id: 1237, emoji: "🤶🏻", name: "Mrs. Claus: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1236, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 1238, emoji: "🤶🏼", name: "Mrs. Claus: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1236, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 1239, emoji: "🤶🏽", name: "Mrs. Claus: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1236, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 1240, emoji: "🤶🏾", name: "Mrs. Claus: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1236, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 1241, emoji: "🤶🏿", name: "Mrs. Claus: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1236, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 1242, emoji: "🧑‍🎄", name: "mx claus", group: Group::PeopleAndBody, skin_tone: Some((1242, SkinTone::Default)), aliases: Some(&["mx_claus"]), variations: &[] },
    Emoji { id: 1243, emoji: "🧑🏻‍🎄", name: "mx claus: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1242, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 1244, emoji: "🧑🏼‍🎄", name: "mx claus: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1242, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 1245, emoji: "🧑🏽‍🎄", name: "mx claus: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1242, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 1246, emoji: "🧑🏾‍🎄", name: "mx claus: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1242, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 1247, emoji: "🧑🏿‍🎄", name: "mx claus: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1242, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 1248, emoji: "🦸", name: "superhero", group: Group::PeopleAndBody, skin_tone: Some((1248, SkinTone::Default)), aliases: Some(&["superhero"]), variations: &[] },
    Emoji { id: 1249, emoji: "🦸🏻", name: "superhero: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1248, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 1250, emoji: "🦸🏼", name: "superhero: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1248, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 1251, emoji: "🦸🏽", name: "superhero: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1248, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 1252, emoji: "🦸🏾", name: "superhero: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1248, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 1253, emoji: "🦸🏿", name: "superhero: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1248, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 1254, emoji: "🦸‍♂️", name: "man superhero", group: Group::PeopleAndBody, skin_tone: Some((1254, SkinTone::Default)), aliases: Some(&["superhero_man"]), variations: &["🦸\u{200d}♂"] },
    Emoji { id: 1255, emoji: "🦸🏻‍♂️", name: "man superhero: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1254, SkinTone::Light)), aliases: None, variations: &["🦸🏻\u{200d}♂"] },
    Emoji { id: 1256, emoji: "🦸🏼‍♂️", name: "man superhero: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1254, SkinTone::MediumLight)), aliases: None, variations: &["🦸🏼\u{200d}♂"] },
    Emoji { id: 1257, emoji: "🦸🏽‍♂️", name: "man superhero: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1254, SkinTone::Medium)), aliases: None, variations: &["🦸🏽\u{200d}♂"] },
    Emoji { id: 1258, emoji: "🦸🏾‍♂️", name: "man superhero: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1254, SkinTone::MediumDark)), aliases: None, variations: &["🦸🏾\u{200d}♂"] },
    Emoji { id: 1259, emoji: "🦸🏿‍♂️", name: "man superhero: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1254, SkinTone::Dark)), aliases: None, variations: &["🦸🏿\u{200d}♂"] },
    Emoji { id: 1260, emoji: "🦸‍♀️", name: "woman superhero", group: Group::PeopleAndBody, skin_tone: Some((1260, SkinTone::Default)), aliases: Some(&["superhero_woman"]), variations: &["🦸\u{200d}♀"] },
    Emoji { id: 1261, emoji: "🦸🏻‍♀️", name: "woman superhero: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1260, SkinTone::Light)), aliases: None, variations: &["🦸🏻\u{200d}♀"] },
    Emoji { id: 1262, emoji: "🦸🏼‍♀️", name: "woman superhero: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1260, SkinTone::MediumLight)), aliases: None, variations: &["🦸🏼\u{200d}♀"] },
    Emoji { id: 1263, emoji: "🦸🏽‍♀️", name: "woman superhero: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1260, SkinTone::Medium)), aliases: None, variations: &["🦸🏽\u{200d}♀"] },
    Emoji { id: 1264, emoji: "🦸🏾‍♀️", name: "woman superhero: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1260, SkinTone::MediumDark)), aliases: None, variations: &["🦸🏾\u{200d}♀"] },
    Emoji { id: 1265, emoji: "🦸🏿‍♀️", name: "woman superhero: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1260, SkinTone::Dark)), aliases: None, variations: &["🦸🏿\u{200d}♀"] },
    Emoji { id: 1266, emoji: "🦹", name: "supervillain", group: Group::PeopleAndBody, skin_tone: Some((1266, SkinTone::Default)), aliases: Some(&["supervillain"]), variations: &[] },
    Emoji { id: 1267, emoji: "🦹🏻", name: "supervillain: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1266, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 1268, emoji: "🦹🏼", name: "supervillain: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1266, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 1269, emoji: "🦹🏽", name: "supervillain: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1266, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 1270, emoji: "🦹🏾", name: "supervillain: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1266, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 1271, emoji: "🦹🏿", name: "supervillain: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1266, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 1272, emoji: "🦹‍♂️", name: "man supervillain", group: Group::PeopleAndBody, skin_tone: Some((1272, SkinTone::Default)), aliases: Some(&["supervillain_man"]), variations: &["🦹\u{200d}♂"] },
    Emoji { id: 1273, emoji: "🦹🏻‍♂️", name: "man supervillain: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1272, SkinTone::Light)), aliases: None, variations: &["🦹🏻\u{200d}♂"] },
    Emoji { id: 1274, emoji: "🦹🏼‍♂️", name: "man supervillain: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1272, SkinTone::MediumLight)), aliases: None, variations: &["🦹🏼\u{200d}♂"] },
    Emoji { id: 1275, emoji: "🦹🏽‍♂️", name: "man supervillain: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1272, SkinTone::Medium)), aliases: None, variations: &["🦹🏽\u{200d}♂"] },
    Emoji { id: 1276, emoji: "🦹🏾‍♂️", name: "man supervillain: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1272, SkinTone::MediumDark)), aliases: None, variations: &["🦹🏾\u{200d}♂"] },
    Emoji { id: 1277, emoji: "🦹🏿‍♂️", name: "man supervillain: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1272, SkinTone::Dark)), aliases: None, variations: &["🦹🏿\u{200d}♂"] },
    Emoji { id: 1278, emoji: "🦹‍♀️", name: "woman supervillain", group: Group::PeopleAndBody, skin_tone: Some((1278, SkinTone::Default)), aliases: Some(&["supervillain_woman"]), variations: &["🦹\u{200d}♀"] },
    Emoji { id: 1279, emoji: "🦹🏻‍♀️", name: "woman supervillain: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1278, SkinTone::Light)), aliases: None, variations: &["🦹🏻\u{200d}♀"] },
    Emoji { id: 1280, emoji: "🦹🏼‍♀️", name: "woman supervillain: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1278, SkinTone::MediumLight)), aliases: None, variations: &["🦹🏼\u{200d}♀"] },
    Emoji { id: 1281, emoji: "🦹🏽‍♀️", name: "woman supervillain: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1278, SkinTone::Medium)), aliases: None, variations: &["🦹🏽\u{200d}♀"] },
    Emoji { id: 1282, emoji: "🦹🏾‍♀️", name: "woman supervillain: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1278, SkinTone::MediumDark)), aliases: None, variations: &["🦹🏾\u{200d}♀"] },
    Emoji { id: 1283, emoji: "🦹🏿‍♀️", name: "woman supervillain: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1278, SkinTone::Dark)), aliases: None, variations: &["🦹🏿\u{200d}♀"] },
    Emoji { id: 1284, emoji: "🧙", name: "mage", group: Group::PeopleAndBody, skin_tone: Some((1284, SkinTone::Default)), aliases: Some(&["mage"]), variations: &[] },
    Emoji { id: 1285, emoji: "🧙🏻", name: "mage: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1284, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 1286, emoji: "🧙🏼", name: "mage: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1284, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 1287, emoji: "🧙🏽", name: "mage: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1284, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 1288, emoji: "🧙🏾", name: "mage: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1284, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 1289, emoji: "🧙🏿", name: "mage: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1284, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 1290, emoji: "🧙‍♂️", name: "man mage", group: Group::PeopleAndBody, skin_tone: Some((1290, SkinTone::Default)), aliases: Some(&["mage_man"]), variations: &["🧙\u{200d}♂"] },
    Emoji { id: 1291, emoji: "🧙🏻‍♂️", name: "man mage: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1290, SkinTone::Light)), aliases: None, variations: &["🧙🏻\u{200d}♂"] },
    Emoji { id: 1292, emoji: "🧙🏼‍♂️", name: "man mage: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1290, SkinTone::MediumLight)), aliases: None, variations: &["🧙🏼\u{200d}♂"] },
    Emoji { id: 1293, emoji: "🧙🏽‍♂️", name: "man mage: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1290, SkinTone::Medium)), aliases: None, variations: &["🧙🏽\u{200d}♂"] },
    Emoji { id: 1294, emoji: "🧙🏾‍♂️", name: "man mage: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1290, SkinTone::MediumDark)), aliases: None, variations: &["🧙🏾\u{200d}♂"] },
    Emoji { id: 1295, emoji: "🧙🏿‍♂️", name: "man mage: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1290, SkinTone::Dark)), aliases: None, variations: &["🧙🏿\u{200d}♂"] },
    Emoji { id: 1296, emoji: "🧙‍♀️", name: "woman mage", group: Group::PeopleAndBody, skin_tone: Some((1296, SkinTone::Default)), aliases: Some(&["mage_woman"]), variations: &["🧙\u{200d}♀"] },
    Emoji { id: 1297, emoji: "🧙🏻‍♀️", name: "woman mage: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1296, SkinTone::Light)), aliases: None, variations: &["🧙🏻\u{200d}♀"] },
    Emoji { id: 1298, emoji: "🧙🏼‍♀️", name: "woman mage: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1296, SkinTone::MediumLight)), aliases: None, variations: &["🧙🏼\u{200d}♀"] },
    Emoji { id: 1299, emoji: "🧙🏽‍♀️", name: "woman mage: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1296, SkinTone::Medium)), aliases: None, variations: &["🧙🏽\u{200d}♀"] },
    Emoji { id: 1300, emoji: "🧙🏾‍♀️", name: "woman mage: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1296, SkinTone::MediumDark)), aliases: None, variations: &["🧙🏾\u{200d}♀"] },
    Emoji { id: 1301, emoji: "🧙🏿‍♀️", name: "woman mage: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1296, SkinTone::Dark)), aliases: None, variations: &["🧙🏿\u{200d}♀"] },
    Emoji { id: 1302, emoji: "🧚", name: "fairy", group: Group::PeopleAndBody, skin_tone: Some((1302, SkinTone::Default)), aliases: Some(&["fairy"]), variations: &[] },
    Emoji { id: 1303, emoji: "🧚🏻", name: "fairy: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1302, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 1304, emoji: "🧚🏼", name: "fairy: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1302, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 1305, emoji: "🧚🏽", name: "fairy: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1302, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 1306, emoji: "🧚🏾", name: "fairy: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1302, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 1307, emoji: "🧚🏿", name: "fairy: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1302, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 1308, emoji: "🧚‍♂️", name: "man fairy", group: Group::PeopleAndBody, skin_tone: Some((1308, SkinTone::Default)), aliases: Some(&["fairy_man"]), variations: &["🧚\u{200d}♂"] },
    Emoji { id: 1309, emoji: "🧚🏻‍♂️", name: "man fairy: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1308, SkinTone::Light)), aliases: None, variations: &["🧚🏻\u{200d}♂"] },
    Emoji { id: 1310, emoji: "🧚🏼‍♂️", name: "man fairy: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1308, SkinTone::MediumLight)), aliases: None, variations: &["🧚🏼\u{200d}♂"] },
    Emoji { id: 1311, emoji: "🧚🏽‍♂️", name: "man fairy: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1308, SkinTone::Medium)), aliases: None, variations: &["🧚🏽\u{200d}♂"] },
    Emoji { id: 1312, emoji: "🧚🏾‍♂️", name: "man fairy: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1308, SkinTone::MediumDark)), aliases: None, variations: &["🧚🏾\u{200d}♂"] },
    Emoji { id: 1313, emoji: "🧚🏿‍♂️", name: "man fairy: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1308, SkinTone::Dark)), aliases: None, variations: &["🧚🏿\u{200d}♂"] },
    Emoji { id: 1314, emoji: "🧚‍♀️", name: "woman fairy", group: Group::PeopleAndBody, skin_tone: Some((1314, SkinTone::Default)), aliases: Some(&["fairy_woman"]), variations: &["🧚\u{200d}♀"] },
    Emoji { id: 1315, emoji: "🧚🏻‍♀️", name: "woman fairy: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1314, SkinTone::Light)), aliases: None, variations: &["🧚🏻\u{200d}♀"] },
    Emoji { id: 1316, emoji: "🧚🏼‍♀️", name: "woman fairy: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1314, SkinTone::MediumLight)), aliases: None, variations: &["🧚🏼\u{200d}♀"] },
    Emoji { id: 1317, emoji: "🧚🏽‍♀️", name: "woman fairy: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1314, SkinTone::Medium)), aliases: None, variations: &["🧚🏽\u{200d}♀"] },
    Emoji { id: 1318, emoji: "🧚🏾‍♀️", name: "woman fairy: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1314, SkinTone::MediumDark)), aliases: None, variations: &["🧚🏾\u{200d}♀"] },
    Emoji { id: 1319, emoji: "🧚🏿‍♀️", name: "woman fairy: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1314, SkinTone::Dark)), aliases: None, variations: &["🧚🏿\u{200d}♀"] },
    Emoji { id: 1320, emoji: "🧛", name: "vampire", group: Group::PeopleAndBody, skin_tone: Some((1320, SkinTone::Default)), aliases: Some(&["vampire"]), variations: &[] },
    Emoji { id: 1321, emoji: "🧛🏻", name: "vampire: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1320, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 1322, emoji: "🧛🏼", name: "vampire: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1320, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 1323, emoji: "🧛🏽", name: "vampire: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1320, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 1324, emoji: "🧛🏾", name: "vampire: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1320, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 1325, emoji: "🧛🏿", name: "vampire: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1320, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 1326, emoji: "🧛‍♂️", name: "man vampire", group: Group::PeopleAndBody, skin_tone: Some((1326, SkinTone::Default)), aliases: Some(&["vampire_man"]), variations: &["🧛\u{200d}♂"] },
    Emoji { id: 1327, emoji: "🧛🏻‍♂️", name: "man vampire: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1326, SkinTone::Light)), aliases: None, variations: &["🧛🏻\u{200d}♂"] },
    Emoji { id: 1328, emoji: "🧛🏼‍♂️", name: "man vampire: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1326, SkinTone::MediumLight)), aliases: None, variations: &["🧛🏼\u{200d}♂"] },
    Emoji { id: 1329, emoji: "🧛🏽‍♂️", name: "man vampire: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1326, SkinTone::Medium)), aliases: None, variations: &["🧛🏽\u{200d}♂"] },
    Emoji { id: 1330, emoji: "🧛🏾‍♂️", name: "man vampire: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1326, SkinTone::MediumDark)), aliases: None, variations: &["🧛🏾\u{200d}♂"] },
    Emoji { id: 1331, emoji: "🧛🏿‍♂️", name: "man vampire: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1326, SkinTone::Dark)), aliases: None, variations: &["🧛🏿\u{200d}♂"] },
    Emoji { id: 1332, emoji: "🧛‍♀️", name: "woman vampire", group: Group::PeopleAndBody, skin_tone: Some((1332, SkinTone::Default)), aliases: Some(&["vampire_woman"]), variations: &["🧛\u{200d}♀"] },
    Emoji { id: 1333, emoji: "🧛🏻‍♀️", name: "woman vampire: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1332, SkinTone::Light)), aliases: None, variations: &["🧛🏻\u{200d}♀"] },
    Emoji { id: 1334, emoji: "🧛🏼‍♀️", name: "woman vampire: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1332, SkinTone::MediumLight)), aliases: None, variations: &["🧛🏼\u{200d}♀"] },
    Emoji { id: 1335, emoji: "🧛🏽‍♀️", name: "woman vampire: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1332, SkinTone::Medium)), aliases: None, variations: &["🧛🏽\u{200d}♀"] },
    Emoji { id: 1336, emoji: "🧛🏾‍♀️", name: "woman vampire: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1332, SkinTone::MediumDark)), aliases: None, variations: &["🧛🏾\u{200d}♀"] },
    Emoji { id: 1337, emoji: "🧛🏿‍♀️", name: "woman vampire: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1332, SkinTone::Dark)), aliases: None, variations: &["🧛🏿\u{200d}♀"] },
    Emoji { id: 1338, emoji: "🧜", name: "merperson", group: Group::PeopleAndBody, skin_tone: Some((1338, SkinTone::Default)), aliases: Some(&["merperson"]), variations: &[] },
    Emoji { id: 1339, emoji: "🧜🏻", name: "merperson: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1338, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 1340, emoji: "🧜🏼", name: "merperson: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1338, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 1341, emoji: "🧜🏽", name: "merperson: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1338, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 1342, emoji: "🧜🏾", name: "merperson: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1338, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 1343, emoji: "🧜🏿", name: "merperson: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1338, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 1344, emoji: "🧜‍♂️", name: "merman", group: Group::PeopleAndBody, skin_tone: Some((1344, SkinTone::Default)), aliases: Some(&["merman"]), variations: &["🧜\u{200d}♂"] },
    Emoji { id: 1345, emoji: "🧜🏻‍♂️", name: "merman: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1344, SkinTone::Light)), aliases: None, variations: &["🧜🏻\u{200d}♂"] },
    Emoji { id: 1346, emoji: "🧜🏼‍♂️", name: "merman: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1344, SkinTone::MediumLight)), aliases: None, variations: &["🧜🏼\u{200d}♂"] },
    Emoji { id: 1347, emoji: "🧜🏽‍♂️", name: "merman: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1344, SkinTone::Medium)), aliases: None, variations: &["🧜🏽\u{200d}♂"] },
    Emoji { id: 1348, emoji: "🧜🏾‍♂️", name: "merman: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1344, SkinTone::MediumDark)), aliases: None, variations: &["🧜🏾\u{200d}♂"] },
    Emoji { id: 1349, emoji: "🧜🏿‍♂️", name: "merman: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1344, SkinTone::Dark)), aliases: None, variations: &["🧜🏿\u{200d}♂"] },
    Emoji { id: 1350, emoji: "🧜‍♀️", name: "mermaid", group: Group::PeopleAndBody, skin_tone: Some((1350, SkinTone::Default)), aliases: Some(&["mermaid"]), variations: &["🧜\u{200d}♀"] },
    Emoji { id: 1351, emoji: "🧜🏻‍♀️", name: "mermaid: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1350, SkinTone::Light)), aliases: None, variations: &["🧜🏻\u{200d}♀"] },
    Emoji { id: 1352, emoji: "🧜🏼‍♀️", name: "mermaid: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1350, SkinTone::MediumLight)), aliases: None, variations: &["🧜🏼\u{200d}♀"] },
    Emoji { id: 1353, emoji: "🧜🏽‍♀️", name: "mermaid: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1350, SkinTone::Medium)), aliases: None, variations: &["🧜🏽\u{200d}♀"] },
    Emoji { id: 1354, emoji: "🧜🏾‍♀️", name: "mermaid: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1350, SkinTone::MediumDark)), aliases: None, variations: &["🧜🏾\u{200d}♀"] },
    Emoji { id: 1355, emoji: "🧜🏿‍♀️", name: "mermaid: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1350, SkinTone::Dark)), aliases: None, variations: &["🧜🏿\u{200d}♀"] },
    Emoji { id: 1356, emoji: "🧝", name: "elf", group: Group::PeopleAndBody, skin_tone: Some((1356, SkinTone::Default)), aliases: Some(&["elf"]), variations: &[] },
    Emoji { id: 1357, emoji: "🧝🏻", name: "elf: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1356, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 1358, emoji: "🧝🏼", name: "elf: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1356, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 1359, emoji: "🧝🏽", name: "elf: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1356, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 1360, emoji: "🧝🏾", name: "elf: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1356, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 1361, emoji: "🧝🏿", name: "elf: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1356, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 1362, emoji: "🧝‍♂️", name: "man elf", group: Group::PeopleAndBody, skin_tone: Some((1362, SkinTone::Default)), aliases: Some(&["elf_man"]), variations: &["🧝\u{200d}♂"] },
    Emoji { id: 1363, emoji: "🧝🏻‍♂️", name: "man elf: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1362, SkinTone::Light)), aliases: None, variations: &["🧝🏻\u{200d}♂"] },
    Emoji { id: 1364, emoji: "🧝🏼‍♂️", name: "man elf: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1362, SkinTone::MediumLight)), aliases: None, variations: &["🧝🏼\u{200d}♂"] },
    Emoji { id: 1365, emoji: "🧝🏽‍♂️", name: "man elf: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1362, SkinTone::Medium)), aliases: None, variations: &["🧝🏽\u{200d}♂"] },
    Emoji { id: 1366, emoji: "🧝🏾‍♂️", name: "man elf: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1362, SkinTone::MediumDark)), aliases: None, variations: &["🧝🏾\u{200d}♂"] },
    Emoji { id: 1367, emoji: "🧝🏿‍♂️", name: "man elf: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1362, SkinTone::Dark)), aliases: None, variations: &["🧝🏿\u{200d}♂"] },
    Emoji { id: 1368, emoji: "🧝‍♀️", name: "woman elf", group: Group::PeopleAndBody, skin_tone: Some((1368, SkinTone::Default)), aliases: Some(&["elf_woman"]), variations: &["🧝\u{200d}♀"] },
    Emoji { id: 1369, emoji: "🧝🏻‍♀️", name: "woman elf: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1368, SkinTone::Light)), aliases: None, variations: &["🧝🏻\u{200d}♀"] },
    Emoji { id: 1370, emoji: "🧝🏼‍♀️", name: "woman elf: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1368, SkinTone::MediumLight)), aliases: None, variations: &["🧝🏼\u{200d}♀"] },
    Emoji { id: 1371, emoji: "🧝🏽‍♀️", name: "woman elf: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1368, SkinTone::Medium)), aliases: None, variations: &["🧝🏽\u{200d}♀"] },
    Emoji { id: 1372, emoji: "🧝🏾‍♀️", name: "woman elf: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1368, SkinTone::MediumDark)), aliases: None, variations: &["🧝🏾\u{200d}♀"] },
    Emoji { id: 1373, emoji: "🧝🏿‍♀️", name: "woman elf: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1368, SkinTone::Dark)), aliases: None, variations: &["🧝🏿\u{200d}♀"] },
    Emoji { id: 1374, emoji: "🧞", name: "genie", group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["genie"]), variations: &[] },
    Emoji { id: 1375, emoji: "🧞‍♂️", name: "man genie", group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["genie_man"]), variations: &["🧞\u{200d}♂"] },
    Emoji { id: 1376, emoji: "🧞‍♀️", name: "woman genie", group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["genie_woman"]), variations: &["🧞\u{200d}♀"] },
    Emoji { id: 1377, emoji: "🧟", name: "zombie", group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["zombie"]), variations: &[] },
    Emoji { id: 1378, emoji: "🧟‍♂️", name: "man zombie", group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["zombie_man"]), variations: &["🧟\u{200d}♂"] },
    Emoji { id: 1379, emoji: "🧟‍♀️", name: "woman zombie", group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["zombie_woman"]), variations: &["🧟\u{200d}♀"] },
    Emoji { id: 1380, emoji: "💆", name: "person getting massage", group: Group::PeopleAndBody, skin_tone: Some((1380, SkinTone::Default)), aliases: Some(&["massage"]), variations: &[] },
    Emoji { id: 1381, emoji: "💆🏻", name: "person getting massage: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1380, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 1382, emoji: "💆🏼", name: "person getting massage: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1380, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 1383, emoji: "💆🏽", name: "person getting massage: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1380, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 1384, emoji: "💆🏾", name: "person getting massage: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1380, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 1385, emoji: "💆🏿", name: "person getting massage: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1380, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 1386, emoji: "💆‍♂️", name: "man getting massage", group: Group::PeopleAndBody, skin_tone: Some((1386, SkinTone::Default)), aliases: Some(&["massage_man"]), variations: &["💆\u{200d}♂"] },
    Emoji { id: 1387, emoji: "💆🏻‍♂️", name: "man getting massage: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1386, SkinTone::Light)), aliases: None, variations: &["💆🏻\u{200d}♂"] },
    Emoji { id: 1388, emoji: "💆🏼‍♂️", name: "man getting massage: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1386, SkinTone::MediumLight)), aliases: None, variations: &["💆🏼\u{200d}♂"] },
    Emoji { id: 1389, emoji: "💆🏽‍♂️", name: "man getting massage: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1386, SkinTone::Medium)), aliases: None, variations: &["💆🏽\u{200d}♂"] },
    Emoji { id: 1390, emoji: "💆🏾‍♂️", name: "man getting massage: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1386, SkinTone::MediumDark)), aliases: None, variations: &["💆🏾\u{200d}♂"] },
    Emoji { id: 1391, emoji: "💆🏿‍♂️", name: "man getting massage: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1386, SkinTone::Dark)), aliases: None, variations: &["💆🏿\u{200d}♂"] },
    Emoji { id: 1392, emoji: "💆‍♀️", name: "woman getting massage", group: Group::PeopleAndBody, skin_tone: Some((1392, SkinTone::Default)), aliases: Some(&["massage_woman"]), variations: &["💆\u{200d}♀"] },
    Emoji { id: 1393, emoji: "💆🏻‍♀️", name: "woman getting massage: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1392, SkinTone::Light)), aliases: None, variations: &["💆🏻\u{200d}♀"] },
    Emoji { id: 1394, emoji: "💆🏼‍♀️", name: "woman getting massage: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1392, SkinTone::MediumLight)), aliases: None, variations: &["💆🏼\u{200d}♀"] },
    Emoji { id: 1395, emoji: "💆🏽‍♀️", name: "woman getting massage: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1392, SkinTone::Medium)), aliases: None, variations: &["💆🏽\u{200d}♀"] },
    Emoji { id: 1396, emoji: "💆🏾‍♀️", name: "woman getting massage: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1392, SkinTone::MediumDark)), aliases: None, variations: &["💆🏾\u{200d}♀"] },
    Emoji { id: 1397, emoji: "💆🏿‍♀️", name: "woman getting massage: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1392, SkinTone::Dark)), aliases: None, variations: &["💆🏿\u{200d}♀"] },
    Emoji { id: 1398, emoji: "💇", name: "person getting haircut", group: Group::PeopleAndBody, skin_tone: Some((1398, SkinTone::Default)), aliases: Some(&["haircut"]), variations: &[] },
    Emoji { id: 1399, emoji: "💇🏻", name: "person getting haircut: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1398, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 1400, emoji: "💇🏼", name: "person getting haircut: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1398, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 1401, emoji: "💇🏽", name: "person getting haircut: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1398, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 1402, emoji: "💇🏾", name: "person getting haircut: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1398, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 1403, emoji: "💇🏿", name: "person getting haircut: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1398, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 1404, emoji: "💇‍♂️", name: "man getting haircut", group: Group::PeopleAndBody, skin_tone: Some((1404, SkinTone::Default)), aliases: Some(&["haircut_man"]), variations: &["💇\u{200d}♂"] },
    Emoji { id: 1405, emoji: "💇🏻‍♂️", name: "man getting haircut: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1404, SkinTone::Light)), aliases: None, variations: &["💇🏻\u{200d}♂"] },
    Emoji { id: 1406, emoji: "💇🏼‍♂️", name: "man getting haircut: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1404, SkinTone::MediumLight)), aliases: None, variations: &["💇🏼\u{200d}♂"] },
    Emoji { id: 1407, emoji: "💇🏽‍♂️", name: "man getting haircut: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1404, SkinTone::Medium)), aliases: None, variations: &["💇🏽\u{200d}♂"] },
    Emoji { id: 1408, emoji: "💇🏾‍♂️", name: "man getting haircut: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1404, SkinTone::MediumDark)), aliases: None, variations: &["💇🏾\u{200d}♂"] },
    Emoji { id: 1409, emoji: "💇🏿‍♂️", name: "man getting haircut: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1404, SkinTone::Dark)), aliases: None, variations: &["💇🏿\u{200d}♂"] },
    Emoji { id: 1410, emoji: "💇‍♀️", name: "woman getting haircut", group: Group::PeopleAndBody, skin_tone: Some((1410, SkinTone::Default)), aliases: Some(&["haircut_woman"]), variations: &["💇\u{200d}♀"] },
    Emoji { id: 1411, emoji: "💇🏻‍♀️", name: "woman getting haircut: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1410, SkinTone::Light)), aliases: None, variations: &["💇🏻\u{200d}♀"] },
    Emoji { id: 1412, emoji: "💇🏼‍♀️", name: "woman getting haircut: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1410, SkinTone::MediumLight)), aliases: None, variations: &["💇🏼\u{200d}♀"] },
    Emoji { id: 1413, emoji: "💇🏽‍♀️", name: "woman getting haircut: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1410, SkinTone::Medium)), aliases: None, variations: &["💇🏽\u{200d}♀"] },
    Emoji { id: 1414, emoji: "💇🏾‍♀️", name: "woman getting haircut: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1410, SkinTone::MediumDark)), aliases: None, variations: &["💇🏾\u{200d}♀"] },
    Emoji { id: 1415, emoji: "💇🏿‍♀️", name: "woman getting haircut: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1410, SkinTone::Dark)), aliases: None, variations: &["💇🏿\u{200d}♀"] },
    Emoji { id: 1416, emoji: "🚶", name: "person walking", group: Group::PeopleAndBody, skin_tone: Some((1416, SkinTone::Default)), aliases: Some(&["walking"]), variations: &[] },
    Emoji { id: 1417, emoji: "🚶🏻", name: "person walking: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1416, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 1418, emoji: "🚶🏼", name: "person walking: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1416, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 1419, emoji: "🚶🏽", name: "person walking: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1416, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 1420, emoji: "🚶🏾", name: "person walking: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1416, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 1421, emoji: "🚶🏿", name: "person walking: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1416, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 1422, emoji: "🚶‍♂️", name: "man walking", group: Group::PeopleAndBody, skin_tone: Some((1422, SkinTone::Default)), aliases: Some(&["walking_man"]), variations: &["🚶\u{200d}♂"] },
    Emoji { id: 1423, emoji: "🚶🏻‍♂️", name: "man walking: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1422, SkinTone::Light)), aliases: None, variations: &["🚶🏻\u{200d}♂"] },
    Emoji { id: 1424, emoji: "🚶🏼‍♂️", name: "man walking: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1422, SkinTone::MediumLight)), aliases: None, variations: &["🚶🏼\u{200d}♂"] },
    Emoji { id: 1425, emoji: "🚶🏽‍♂️", name: "man walking: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1422, SkinTone::Medium)), aliases: None, variations: &["🚶🏽\u{200d}♂"] },
    Emoji { id: 1426, emoji: "🚶🏾‍♂️", name: "man walking: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1422, SkinTone::MediumDark)), aliases: None, variations: &["🚶🏾\u{200d}♂"] },
    Emoji { id: 1427, emoji: "🚶🏿‍♂️", name: "man walking: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1422, SkinTone::Dark)), aliases: None, variations: &["🚶🏿\u{200d}♂"] },
    Emoji { id: 1428, emoji: "🚶‍♀️", name: "woman walking", group: Group::PeopleAndBody, skin_tone: Some((1428, SkinTone::Default)), aliases: Some(&["walking_woman"]), variations: &["🚶\u{200d}♀"] },
    Emoji { id: 1429, emoji: "🚶🏻‍♀️", name: "woman walking: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1428, SkinTone::Light)), aliases: None, variations: &["🚶🏻\u{200d}♀"] },
    Emoji { id: 1430, emoji: "🚶🏼‍♀️", name: "woman walking: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1428, SkinTone::MediumLight)), aliases: None, variations: &["🚶🏼\u{200d}♀"] },
    Emoji { id: 1431, emoji: "🚶🏽‍♀️", name: "woman walking: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1428, SkinTone::Medium)), aliases: None, variations: &["🚶🏽\u{200d}♀"] },
    Emoji { id: 1432, emoji: "🚶🏾‍♀️", name: "woman walking: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1428, SkinTone::MediumDark)), aliases: None, variations: &["🚶🏾\u{200d}♀"] },
    Emoji { id: 1433, emoji: "🚶🏿‍♀️", name: "woman walking: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1428, SkinTone::Dark)), aliases: None, variations: &["🚶🏿\u{200d}♀"] },
    Emoji { id: 1434, emoji: "🧍", name: "person standing", group: Group::PeopleAndBody, skin_tone: Some((1434, SkinTone::Default)), aliases: Some(&["standing_person"]), variations: &[] },
    Emoji { id: 1435, emoji: "🧍🏻", name: "person standing: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1434, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 1436, emoji: "🧍🏼", name: "person standing: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1434, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 1437, emoji: "🧍🏽", name: "person standing: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1434, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 1438, emoji: "🧍🏾", name: "person standing: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1434, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 1439, emoji: "🧍🏿", name: "person standing: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1434, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 1440, emoji: "🧍‍♂️", name: "man standing", group: Group::PeopleAndBody, skin_tone: Some((1440, SkinTone::Default)), aliases: Some(&["standing_man"]), variations: &["🧍\u{200d}♂"] },
    Emoji { id: 1441, emoji: "🧍🏻‍♂️", name: "man standing: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1440, SkinTone::Light)), aliases: None, variations: &["🧍🏻\u{200d}♂"] },
    Emoji { id: 1442, emoji: "🧍🏼‍♂️", name: "man standing: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1440, SkinTone::MediumLight)), aliases: None, variations: &["🧍🏼\u{200d}♂"] },
    Emoji { id: 1443, emoji: "🧍🏽‍♂️", name: "man standing: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1440, SkinTone::Medium)), aliases: None, variations: &["🧍🏽\u{200d}♂"] },
    Emoji { id: 1444, emoji: "🧍🏾‍♂️", name: "man standing: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1440, SkinTone::MediumDark)), aliases: None, variations: &["🧍🏾\u{200d}♂"] },
    Emoji { id: 1445, emoji: "🧍🏿‍♂️", name: "man standing: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1440, SkinTone::Dark)), aliases: None, variations: &["🧍🏿\u{200d}♂"] },
    Emoji { id: 1446, emoji: "🧍‍♀️", name: "woman standing", group: Group::PeopleAndBody, skin_tone: Some((1446, SkinTone::Default)), aliases: Some(&["standing_woman"]), variations: &["🧍\u{200d}♀"] },
    Emoji { id: 1447, emoji: "🧍🏻‍♀️", name: "woman standing: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1446, SkinTone::Light)), aliases: None, variations: &["🧍🏻\u{200d}♀"] },
    Emoji { id: 1448, emoji: "🧍🏼‍♀️", name: "woman standing: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1446, SkinTone::MediumLight)), aliases: None, variations: &["🧍🏼\u{200d}♀"] },
    Emoji { id: 1449, emoji: "🧍🏽‍♀️", name: "woman standing: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1446, SkinTone::Medium)), aliases: None, variations: &["🧍🏽\u{200d}♀"] },
    Emoji { id: 1450, emoji: "🧍🏾‍♀️", name: "woman standing: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1446, SkinTone::MediumDark)), aliases: None, variations: &["🧍🏾\u{200d}♀"] },
    Emoji { id: 1451, emoji: "🧍🏿‍♀️", name: "woman standing: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1446, SkinTone::Dark)), aliases: None, variations: &["🧍🏿\u{200d}♀"] },
    Emoji { id: 1452, emoji: "🧎", name: "person kneeling", group: Group::PeopleAndBody, skin_tone: Some((1452, SkinTone::Default)), aliases: Some(&["kneeling_person"]), variations: &[] },
    Emoji { id: 1453, emoji: "🧎🏻", name: "person kneeling: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1452, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 1454, emoji: "🧎🏼", name: "person kneeling: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1452, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 1455, emoji: "🧎🏽", name: "person kneeling: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1452, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 1456, emoji: "🧎🏾", name: "person kneeling: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1452, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 1457, emoji: "🧎🏿", name: "person kneeling: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1452, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 1458, emoji: "🧎‍♂️", name: "man kneeling", group: Group::PeopleAndBody, skin_tone: Some((1458, SkinTone::Default)), aliases: Some(&["kneeling_man"]), variations: &["🧎\u{200d}♂"] },
    Emoji { id: 1459, emoji: "🧎🏻‍♂️", name: "man kneeling: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1458, SkinTone::Light)), aliases: None, variations: &["🧎🏻\u{200d}♂"] },
    Emoji { id: 1460, emoji: "🧎🏼‍♂️", name: "man kneeling: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1458, SkinTone::MediumLight)), aliases: None, variations: &["🧎🏼\u{200d}♂"] },
    Emoji { id: 1461, emoji: "🧎🏽‍♂️", name: "man kneeling: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1458, SkinTone::Medium)), aliases: None, variations: &["🧎🏽\u{200d}♂"] },
    Emoji { id: 1462, emoji: "🧎🏾‍♂️", name: "man kneeling: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1458, SkinTone::MediumDark)), aliases: None, variations: &["🧎🏾\u{200d}♂"] },
    Emoji { id: 1463, emoji: "🧎🏿‍♂️", name: "man kneeling: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1458, SkinTone::Dark)), aliases: None, variations: &["🧎🏿\u{200d}♂"] },
    Emoji { id: 1464, emoji: "🧎‍♀️", name: "woman kneeling", group: Group::PeopleAndBody, skin_tone: Some((1464, SkinTone::Default)), aliases: Some(&["kneeling_woman"]), variations: &["🧎\u{200d}♀"] },
    Emoji { id: 1465, emoji: "🧎🏻‍♀️", name: "woman kneeling: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1464, SkinTone::Light)), aliases: None, variations: &["🧎🏻\u{200d}♀"] },
    Emoji { id: 1466, emoji: "🧎🏼‍♀️", name: "woman kneeling: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1464, SkinTone::MediumLight)), aliases: None, variations: &["🧎🏼\u{200d}♀"] },
    Emoji { id: 1467, emoji: "🧎🏽‍♀️", name: "woman kneeling: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1464, SkinTone::Medium)), aliases: None, variations: &["🧎🏽\u{200d}♀"] },
    Emoji { id: 1468, emoji: "🧎🏾‍♀️", name: "woman kneeling: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1464, SkinTone::MediumDark)), aliases: None, variations: &["🧎🏾\u{200d}♀"] },
    Emoji { id: 1469, emoji: "🧎🏿‍♀️", name: "woman kneeling: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1464, SkinTone::Dark)), aliases: None, variations: &["🧎🏿\u{200d}♀"] },
    Emoji { id: 1470, emoji: "🧑‍🦯", name: "person with white cane", group: Group::PeopleAndBody, skin_tone: Some((1470, SkinTone::Default)), aliases: Some(&["person_with_probing_cane"]), variations: &[] },
    Emoji { id: 1471, emoji: "🧑🏻‍🦯", name: "person with white cane: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1470, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 1472, emoji: "🧑🏼‍🦯", name: "person with white cane: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1470, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 1473, emoji: "🧑🏽‍🦯", name: "person with white cane: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1470, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 1474, emoji: "🧑🏾‍🦯", name: "person with white cane: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1470, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 1475, emoji: "🧑🏿‍🦯", name: "person with white cane: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1470, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 1476, emoji: "👨‍🦯", name: "man with white cane", group: Group::PeopleAndBody, skin_tone: Some((1476, SkinTone::Default)), aliases: Some(&["man_with_probing_cane"]), variations: &[] },
    Emoji { id: 1477, emoji: "👨🏻‍🦯", name: "man with white cane: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1476, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 1478, emoji: "👨🏼‍🦯", name: "man with white cane: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1476, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 1479, emoji: "👨🏽‍🦯", name: "man with white cane: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1476, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 1480, emoji: "👨🏾‍🦯", name: "man with white cane: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1476, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 1481, emoji: "👨🏿‍🦯", name: "man with white cane: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1476, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 1482, emoji: "👩‍🦯", name: "woman with white cane", group: Group::PeopleAndBody, skin_tone: Some((1482, SkinTone::Default)), aliases: Some(&["woman_with_probing_cane"]), variations: &[] },
    Emoji { id: 1483, emoji: "👩🏻‍🦯", name: "woman with white cane: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1482, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 1484, emoji: "👩🏼‍🦯", name: "woman with white cane: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1482, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 1485, emoji: "👩🏽‍🦯", name: "woman with white cane: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1482, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 1486, emoji: "👩🏾‍🦯", name: "woman with white cane: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1482, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 1487, emoji: "👩🏿‍🦯", name: "woman with white cane: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1482, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 1488, emoji: "🧑‍🦼", name: "person in motorized wheelchair", group: Group::PeopleAndBody, skin_tone: Some((1488, SkinTone::Default)), aliases: Some(&["person_in_motorized_wheelchair"]), variations: &[] },
    Emoji { id: 1489, emoji: "🧑🏻‍🦼", name: "person in motorized wheelchair: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1488, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 1490, emoji: "🧑🏼‍🦼", name: "person in motorized wheelchair: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1488, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 1491, emoji: "🧑🏽‍🦼", name: "person in motorized wheelchair: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1488, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 1492, emoji: "🧑🏾‍🦼", name: "person in motorized wheelchair: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1488, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 1493, emoji: "🧑🏿‍🦼", name: "person in motorized wheelchair: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1488, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 1494, emoji: "👨‍🦼", name: "man in motorized wheelchair", group: Group::PeopleAndBody, skin_tone: Some((1494, SkinTone::Default)), aliases: Some(&["man_in_motorized_wheelchair"]), variations: &[] },
    Emoji { id: 1495, emoji: "👨🏻‍🦼", name: "man in motorized wheelchair: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1494, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 1496, emoji: "👨🏼‍🦼", name: "man in motorized wheelchair: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1494, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 1497, emoji: "👨🏽‍🦼", name: "man in motorized wheelchair: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1494, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 1498, emoji: "👨🏾‍🦼", name: "man in motorized wheelchair: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1494, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 1499, emoji: "👨🏿‍🦼", name: "man in motorized wheelchair: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1494, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 1500, emoji: "👩‍🦼", name: "woman in motorized wheelchair", group: Group::PeopleAndBody, skin_tone: Some((1500, SkinTone::Default)), aliases: Some(&["woman_in_motorized_wheelchair"]), variations: &[] },
    Emoji { id: 1501, emoji: "👩🏻‍🦼", name: "woman in motorized wheelchair: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1500, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 1502, emoji: "👩🏼‍🦼", name: "woman in motorized wheelchair: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1500, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 1503, emoji: "👩🏽‍🦼", name: "woman in motorized wheelchair: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1500, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 1504, emoji: "👩🏾‍🦼", name: "woman in motorized wheelchair: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1500, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 1505, emoji: "👩🏿‍🦼", name: "woman in motorized wheelchair: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1500, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 1506, emoji: "🧑‍🦽", name: "person in manual wheelchair", group: Group::PeopleAndBody, skin_tone: Some((1506, SkinTone::Default)), aliases: Some(&["person_in_manual_wheelchair"]), variations: &[] },
    Emoji { id: 1507, emoji: "🧑🏻‍🦽", name: "person in manual wheelchair: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1506, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 1508, emoji: "🧑🏼‍🦽", name: "person in manual wheelchair: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1506, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 1509, emoji: "🧑🏽‍🦽", name: "person in manual wheelchair: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1506, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 1510, emoji: "🧑🏾‍🦽", name: "person in manual wheelchair: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1506, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 1511, emoji: "🧑🏿‍🦽", name: "person in manual wheelchair: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1506, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 1512, emoji: "👨‍🦽", name: "man in manual wheelchair", group: Group::PeopleAndBody, skin_tone: Some((1512, SkinTone::Default)), aliases: Some(&["man_in_manual_wheelchair"]), variations: &[] },
    Emoji { id: 1513, emoji: "👨🏻‍🦽", name: "man in manual wheelchair: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1512, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 1514, emoji: "👨🏼‍🦽", name: "man in manual wheelchair: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1512, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 1515, emoji: "👨🏽‍🦽", name: "man in manual wheelchair: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1512, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 1516, emoji: "👨🏾‍🦽", name: "man in manual wheelchair: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1512, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 1517, emoji: "👨🏿‍🦽", name: "man in manual wheelchair: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1512, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 1518, emoji: "👩‍🦽", name: "woman in manual wheelchair", group: Group::PeopleAndBody, skin_tone: Some((1518, SkinTone::Default)), aliases: Some(&["woman_in_manual_wheelchair"]), variations: &[] },
    Emoji { id: 1519, emoji: "👩🏻‍🦽", name: "woman in manual wheelchair: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1518, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 1520, emoji: "👩🏼‍🦽", name: "woman in manual wheelchair: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1518, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 1521, emoji: "👩🏽‍🦽", name: "woman in manual wheelchair: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1518, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 1522, emoji: "👩🏾‍🦽", name: "woman in manual wheelchair: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1518, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 1523, emoji: "👩🏿‍🦽", name: "woman in manual wheelchair: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1518, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 1524, emoji: "🏃", name: "person running", group: Group::PeopleAndBody, skin_tone: Some((1524, SkinTone::Default)), aliases: Some(&["runner", "running"]), variations: &[] },
    Emoji { id: 1525, emoji: "🏃🏻", name: "person running: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1524, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 1526, emoji: "🏃🏼", name: "person running: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1524, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 1527, emoji: "🏃🏽", name: "person running: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1524, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 1528, emoji: "🏃🏾", name: "person running: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1524, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 1529, emoji: "🏃🏿", name: "person running: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1524, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 1530, emoji: "🏃‍♂️", name: "man running", group: Group::PeopleAndBody, skin_tone: Some((1530, SkinTone::Default)), aliases: Some(&["running_man"]), variations: &["🏃\u{200d}♂"] },
    Emoji { id: 1531, emoji: "🏃🏻‍♂️", name: "man running: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1530, SkinTone::Light)), aliases: None, variations: &["🏃🏻\u{200d}♂"] },
    Emoji { id: 1532, emoji: "🏃🏼‍♂️", name: "man running: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1530, SkinTone::MediumLight)), aliases: None, variations: &["🏃🏼\u{200d}♂"] },
    Emoji { id: 1533, emoji: "🏃🏽‍♂️", name: "man running: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1530, SkinTone::Medium)), aliases: None, variations: &["🏃🏽\u{200d}♂"] },
    Emoji { id: 1534, emoji: "🏃🏾‍♂️", name: "man running: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1530, SkinTone::MediumDark)), aliases: None, variations: &["🏃🏾\u{200d}♂"] },
    Emoji { id: 1535, emoji: "🏃🏿‍♂️", name: "man running: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1530, SkinTone::Dark)), aliases: None, variations: &["🏃🏿\u{200d}♂"] },
    Emoji { id: 1536, emoji: "🏃‍♀️", name: "woman running", group: Group::PeopleAndBody, skin_tone: Some((1536, SkinTone::Default)), aliases: Some(&["running_woman"]), variations: &["🏃\u{200d}♀"] },
    Emoji { id: 1537, emoji: "🏃🏻‍♀️", name: "woman running: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1536, SkinTone::Light)), aliases: None, variations: &["🏃🏻\u{200d}♀"] },
    Emoji { id: 1538, emoji: "🏃🏼‍♀️", name: "woman running: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1536, SkinTone::MediumLight)), aliases: None, variations: &["🏃🏼\u{200d}♀"] },
    Emoji { id: 1539, emoji: "🏃🏽‍♀️", name: "woman running: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1536, SkinTone::Medium)), aliases: None, variations: &["🏃🏽\u{200d}♀"] },
    Emoji { id: 1540, emoji: "🏃🏾‍♀️", name: "woman running: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1536, SkinTone::MediumDark)), aliases: None, variations: &["🏃🏾\u{200d}♀"] },
    Emoji { id: 1541, emoji: "🏃🏿‍♀️", name: "woman running: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1536, SkinTone::Dark)), aliases: None, variations: &["🏃🏿\u{200d}♀"] },
    Emoji { id: 1542, emoji: "💃", name: "woman dancing", group: Group::PeopleAndBody, skin_tone: Some((1542, SkinTone::Default)), aliases: Some(&["woman_dancing", "dancer"]), variations: &[] },
    Emoji { id: 1543, emoji: "💃🏻", name: "woman dancing: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1542, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 1544, emoji: "💃🏼", name: "woman dancing: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1542, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 1545, emoji: "💃🏽", name: "woman dancing: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1542, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 1546, emoji: "💃🏾", name: "woman dancing: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1542, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 1547, emoji: "💃🏿", name: "woman dancing: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1542, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 1548, emoji: "🕺", name: "man dancing", group: Group::PeopleAndBody, skin_tone: Some((1548, SkinTone::Default)), aliases: Some(&["man_dancing"]), variations: &[] },
    Emoji { id: 1549, emoji: "🕺🏻", name: "man dancing: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1548, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 1550, emoji: "🕺🏼", name: "man dancing: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1548, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 1551, emoji: "🕺🏽", name: "man dancing: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1548, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 1552, emoji: "🕺🏾", name: "man dancing: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1548, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 1553, emoji: "🕺🏿", name: "man dancing: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1548, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 1554, emoji: "🕴️", name: "person in suit levitating", group: Group::PeopleAndBody, skin_tone: Some((1554, SkinTone::Default)), aliases: Some(&["business_suit_levitating"]), variations: &["🕴"] },
    Emoji { id: 1555, emoji: "🕴🏻", name: "person in suit levitating: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1554, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 1556, emoji: "🕴🏼", name: "person in suit levitating: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1554, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 1557, emoji: "🕴🏽", name: "person in suit levitating: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1554, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 1558, emoji: "🕴🏾", name: "person in suit levitating: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1554, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 1559, emoji: "🕴🏿", name: "person in suit levitating: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1554, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 1560, emoji: "👯", name: "people with bunny ears", group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["dancers"]), variations: &[] },
    Emoji { id: 1561, emoji: "👯‍♂️", name: "men with bunny ears", group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["dancing_men"]), variations: &["👯\u{200d}♂"] },
    Emoji { id: 1562, emoji: "👯‍♀️", name: "women with bunny ears", group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["dancing_women"]), variations: &["👯\u{200d}♀"] },
    Emoji { id: 1563, emoji: "🧖", name: "person in steamy room", group: Group::PeopleAndBody, skin_tone: Some((1563, SkinTone::Default)), aliases: Some(&["sauna_person"]), variations: &[] },
    Emoji { id: 1564, emoji: "🧖🏻", name: "person in steamy room: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1563, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 1565, emoji: "🧖🏼", name: "person in steamy room: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1563, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 1566, emoji: "🧖🏽", name: "person in steamy room: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1563, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 1567, emoji: "🧖🏾", name: "person in steamy room: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1563, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 1568, emoji: "🧖🏿", name: "person in steamy room: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1563, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 1569, emoji: "🧖‍♂️", name: "man in steamy room", group: Group::PeopleAndBody, skin_tone: Some((1569, SkinTone::Default)), aliases: Some(&["sauna_man"]), variations: &["🧖\u{200d}♂"] },
    Emoji { id: 1570, emoji: "🧖🏻‍♂️", name: "man in steamy room: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1569, SkinTone::Light)), aliases: None, variations: &["🧖🏻\u{200d}♂"] },
    Emoji { id: 1571, emoji: "🧖🏼‍♂️", name: "man in steamy room: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1569, SkinTone::MediumLight)), aliases: None, variations: &["🧖🏼\u{200d}♂"] },
    Emoji { id: 1572, emoji: "🧖🏽‍♂️", name: "man in steamy room: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1569, SkinTone::Medium)), aliases: None, variations: &["🧖🏽\u{200d}♂"] },
    Emoji { id: 1573, emoji: "🧖🏾‍♂️", name: "man in steamy room: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1569, SkinTone::MediumDark)), aliases: None, variations: &["🧖🏾\u{200d}♂"] },
    Emoji { id: 1574, emoji: "🧖🏿‍♂️", name: "man in steamy room: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1569, SkinTone::Dark)), aliases: None, variations: &["🧖🏿\u{200d}♂"] },
    Emoji { id: 1575, emoji: "🧖‍♀️", name: "woman in steamy room", group: Group::PeopleAndBody, skin_tone: Some((1575, SkinTone::Default)), aliases: Some(&["sauna_woman"]), variations: &["🧖\u{200d}♀"] },
    Emoji { id: 1576, emoji: "🧖🏻‍♀️", name: "woman in steamy room: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1575, SkinTone::Light)), aliases: None, variations: &["🧖🏻\u{200d}♀"] },
    Emoji { id: 1577, emoji: "🧖🏼‍♀️", name: "woman in steamy room: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1575, SkinTone::MediumLight)), aliases: None, variations: &["🧖🏼\u{200d}♀"] },
    Emoji { id: 1578, emoji: "🧖🏽‍♀️", name: "woman in steamy room: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1575, SkinTone::Medium)), aliases: None, variations: &["🧖🏽\u{200d}♀"] },
    Emoji { id: 1579, emoji: "🧖🏾‍♀️", name: "woman in steamy room: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1575, SkinTone::MediumDark)), aliases: None, variations: &["🧖🏾\u{200d}♀"] },
    Emoji { id: 1580, emoji: "🧖🏿‍♀️", name: "woman in steamy room: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1575, SkinTone::Dark)), aliases: None, variations: &["🧖🏿\u{200d}♀"] },
    Emoji { id: 1581, emoji: "🧗", name: "person climbing", group: Group::PeopleAndBody, skin_tone: Some((1581, SkinTone::Default)), aliases: Some(&["climbing"]), variations: &[] },
    Emoji { id: 1582, emoji: "🧗🏻", name: "person climbing: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1581, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 1583, emoji: "🧗🏼", name: "person climbing: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1581, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 1584, emoji: "🧗🏽", name: "person climbing: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1581, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 1585, emoji: "🧗🏾", name: "person climbing: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1581, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 1586, emoji: "🧗🏿", name: "person climbing: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1581, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 1587, emoji: "🧗‍♂️", name: "man climbing", group: Group::PeopleAndBody, skin_tone: Some((1587, SkinTone::Default)), aliases: Some(&["climbing_man"]), variations: &["🧗\u{200d}♂"] },
    Emoji { id: 1588, emoji: "🧗🏻‍♂️", name: "man climbing: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1587, SkinTone::Light)), aliases: None, variations: &["🧗🏻\u{200d}♂"] },
    Emoji { id: 1589, emoji: "🧗🏼‍♂️", name: "man climbing: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1587, SkinTone::MediumLight)), aliases: None, variations: &["🧗🏼\u{200d}♂"] },
    Emoji { id: 1590, emoji: "🧗🏽‍♂️", name: "man climbing: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1587, SkinTone::Medium)), aliases: None, variations: &["🧗🏽\u{200d}♂"] },
    Emoji { id: 1591, emoji: "🧗🏾‍♂️", name: "man climbing: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1587, SkinTone::MediumDark)), aliases: None, variations: &["🧗🏾\u{200d}♂"] },
    Emoji { id: 1592, emoji: "🧗🏿‍♂️", name: "man climbing: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1587, SkinTone::Dark)), aliases: None, variations: &["🧗🏿\u{200d}♂"] },
    Emoji { id: 1593, emoji: "🧗‍♀️", name: "woman climbing", group: Group::PeopleAndBody, skin_tone: Some((1593, SkinTone::Default)), aliases: Some(&["climbing_woman"]), variations: &["🧗\u{200d}♀"] },
    Emoji { id: 1594, emoji: "🧗🏻‍♀️", name: "woman climbing: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1593, SkinTone::Light)), aliases: None, variations: &["🧗🏻\u{200d}♀"] },
    Emoji { id: 1595, emoji: "🧗🏼‍♀️", name: "woman climbing: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1593, SkinTone::MediumLight)), aliases: None, variations: &["🧗🏼\u{200d}♀"] },
    Emoji { id: 1596, emoji: "🧗🏽‍♀️", name: "woman climbing: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1593, SkinTone::Medium)), aliases: None, variations: &["🧗🏽\u{200d}♀"] },
    Emoji { id: 1597, emoji: "🧗🏾‍♀️", name: "woman climbing: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1593, SkinTone::MediumDark)), aliases: None, variations: &["🧗🏾\u{200d}♀"] },
    Emoji { id: 1598, emoji: "🧗🏿‍♀️", name: "woman climbing: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1593, SkinTone::Dark)), aliases: None, variations: &["🧗🏿\u{200d}♀"] },
    Emoji { id: 1599, emoji: "🤺", name: "person fencing", group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["person_fencing"]), variations: &[] },
    Emoji { id: 1600, emoji: "🏇", name: "horse racing", group: Group::PeopleAndBody, skin_tone: Some((1600, SkinTone::Default)), aliases: Some(&["horse_racing"]), variations: &[] },
    Emoji { id: 1601, emoji: "🏇🏻", name: "horse racing: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1600, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 1602, emoji: "🏇🏼", name: "horse racing: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1600, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 1603, emoji: "🏇🏽", name: "horse racing: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1600, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 1604, emoji: "🏇🏾", name: "horse racing: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1600, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 1605, emoji: "🏇🏿", name: "horse racing: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1600, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 1606, emoji: "⛷️", name: "skier", group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["skier"]), variations: &["⛷"] },
    Emoji { id: 1607, emoji: "🏂", name: "snowboarder", group: Group::PeopleAndBody, skin_tone: Some((1607, SkinTone::Default)), aliases: Some(&["snowboarder"]), variations: &[] },
    Emoji { id: 1608, emoji: "🏂🏻", name: "snowboarder: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1607, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 1609, emoji: "🏂🏼", name: "snowboarder: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1607, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 1610, emoji: "🏂🏽", name: "snowboarder: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1607, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 1611, emoji: "🏂🏾", name: "snowboarder: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1607, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 1612, emoji: "🏂🏿", name: "snowboarder: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1607, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 1613, emoji: "🏌️", name: "person golfing", group: Group::PeopleAndBody, skin_tone: Some((1613, SkinTone::Default)), aliases: Some(&["golfing"]), variations: &["🏌"] },
    Emoji { id: 1614, emoji: "🏌🏻", name: "person golfing: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1613, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 1615, emoji: "🏌🏼", name: "person golfing: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1613, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 1616, emoji: "🏌🏽", name: "person golfing: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1613, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 1617, emoji: "🏌🏾", name: "person golfing: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1613, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 1618, emoji: "🏌🏿", name: "person golfing: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1613, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 1619, emoji: "🏌️‍♂️", name: "man golfing", group: Group::PeopleAndBody, skin_tone: Some((1619, SkinTone::Default)), aliases: Some(&["golfing_man"]), variations: &["🏌\u{200d}♂\u{fe0f}", "🏌\u{fe0f}\u{200d}♂", "🏌\u{200d}♂"] },
    Emoji { id: 1620, emoji: "🏌🏻‍♂️", name: "man golfing: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1619, SkinTone::Light)), aliases: None, variations: &["🏌🏻\u{200d}♂"] },
    Emoji { id: 1621, emoji: "🏌🏼‍♂️", name: "man golfing: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1619, SkinTone::MediumLight)), aliases: None, variations: &["🏌🏼\u{200d}♂"] },
    Emoji { id: 1622, emoji: "🏌🏽‍♂️", name: "man golfing: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1619, SkinTone::Medium)), aliases: None, variations: &["🏌🏽\u{200d}♂"] },
    Emoji { id: 1623, emoji: "🏌🏾‍♂️", name: "man golfing: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1619, SkinTone::MediumDark)), aliases: None, variations: &["🏌🏾\u{200d}♂"] },
    Emoji { id: 1624, emoji: "🏌🏿‍♂️", name: "man golfing: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1619, SkinTone::Dark)), aliases: None, variations: &["🏌🏿\u{200d}♂"] },
    Emoji { id: 1625, emoji: "🏌️‍♀️", name: "woman golfing", group: Group::PeopleAndBody, skin_tone: Some((1625, SkinTone::Default)), aliases: Some(&["golfing_woman"]), variations: &["🏌\u{200d}♀\u{fe0f}", "🏌\u{fe0f}\u{200d}♀", "🏌\u{200d}♀"] },
    Emoji { id: 1626, emoji: "🏌🏻‍♀️", name: "woman golfing: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1625, SkinTone::Light)), aliases: None, variations: &["🏌🏻\u{200d}♀"] },
    Emoji { id: 1627, emoji: "🏌🏼‍♀️", name: "woman golfing: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1625, SkinTone::MediumLight)), aliases: None, variations: &["🏌🏼\u{200d}♀"] },
    Emoji { id: 1628, emoji: "🏌🏽‍♀️", name: "woman golfing: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1625, SkinTone::Medium)), aliases: None, variations: &["🏌🏽\u{200d}♀"] },
    Emoji { id: 1629, emoji: "🏌🏾‍♀️", name: "woman golfing: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1625, SkinTone::MediumDark)), aliases: None, variations: &["🏌🏾\u{200d}♀"] },
    Emoji { id: 1630, emoji: "🏌🏿‍♀️", name: "woman golfing: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1625, SkinTone::Dark)), aliases: None, variations: &["🏌🏿\u{200d}♀"] },
    Emoji { id: 1631, emoji: "🏄", name: "person surfing", group: Group::PeopleAndBody, skin_tone: Some((1631, SkinTone::Default)), aliases: Some(&["surfer"]), variations: &[] },
    Emoji { id: 1632, emoji: "🏄🏻", name: "person surfing: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1631, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 1633, emoji: "🏄🏼", name: "person surfing: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1631, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 1634, emoji: "🏄🏽", name: "person surfing: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1631, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 1635, emoji: "🏄🏾", name: "person surfing: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1631, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 1636, emoji: "🏄🏿", name: "person surfing: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1631, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 1637, emoji: "🏄‍♂️", name: "man surfing", group: Group::PeopleAndBody, skin_tone: Some((1637, SkinTone::Default)), aliases: Some(&["surfing_man"]), variations: &["🏄\u{200d}♂"] },
    Emoji { id: 1638, emoji: "🏄🏻‍♂️", name: "man surfing: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1637, SkinTone::Light)), aliases: None, variations: &["🏄🏻\u{200d}♂"] },
    Emoji { id: 1639, emoji: "🏄🏼‍♂️", name: "man surfing: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1637, SkinTone::MediumLight)), aliases: None, variations: &["🏄🏼\u{200d}♂"] },
    Emoji { id: 1640, emoji: "🏄🏽‍♂️", name: "man surfing: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1637, SkinTone::Medium)), aliases: None, variations: &["🏄🏽\u{200d}♂"] },
    Emoji { id: 1641, emoji: "🏄🏾‍♂️", name: "man surfing: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1637, SkinTone::MediumDark)), aliases: None, variations: &["🏄🏾\u{200d}♂"] },
    Emoji { id: 1642, emoji: "🏄🏿‍♂️", name: "man surfing: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1637, SkinTone::Dark)), aliases: None, variations: &["🏄🏿\u{200d}♂"] },
    Emoji { id: 1643, emoji: "🏄‍♀️", name: "woman surfing", group: Group::PeopleAndBody, skin_tone: Some((1643, SkinTone::Default)), aliases: Some(&["surfing_woman"]), variations: &["🏄\u{200d}♀"] },
    Emoji { id: 1644, emoji: "🏄🏻‍♀️", name: "woman surfing: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1643, SkinTone::Light)), aliases: None, variations: &["🏄🏻\u{200d}♀"] },
    Emoji { id: 1645, emoji: "🏄🏼‍♀️", name: "woman surfing: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1643, SkinTone::MediumLight)), aliases: None, variations: &["🏄🏼\u{200d}♀"] },
    Emoji { id: 1646, emoji: "🏄🏽‍♀️", name: "woman surfing: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1643, SkinTone::Medium)), aliases: None, variations: &["🏄🏽\u{200d}♀"] },
    Emoji { id: 1647, emoji: "🏄🏾‍♀️", name: "woman surfing: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1643, SkinTone::MediumDark)), aliases: None, variations: &["🏄🏾\u{200d}♀"] },
    Emoji { id: 1648, emoji: "🏄🏿‍♀️", name: "woman surfing: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1643, SkinTone::Dark)), aliases: None, variations: &["🏄🏿\u{200d}♀"] },
    Emoji { id: 1649, emoji: "🚣", name: "person rowing boat", group: Group::PeopleAndBody, skin_tone: Some((1649, SkinTone::Default)), aliases: Some(&["rowboat"]), variations: &[] },
    Emoji { id: 1650, emoji: "🚣🏻", name: "person rowing boat: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1649, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 1651, emoji: "🚣🏼", name: "person rowing boat: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1649, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 1652, emoji: "🚣🏽", name: "person rowing boat: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1649, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 1653, emoji: "🚣🏾", name: "person rowing boat: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1649, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 1654, emoji: "🚣🏿", name: "person rowing boat: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1649, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 1655, emoji: "🚣‍♂️", name: "man rowing boat", group: Group::PeopleAndBody, skin_tone: Some((1655, SkinTone::Default)), aliases: Some(&["rowing_man"]), variations: &["🚣\u{200d}♂"] },
    Emoji { id: 1656, emoji: "🚣🏻‍♂️", name: "man rowing boat: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1655, SkinTone::Light)), aliases: None, variations: &["🚣🏻\u{200d}♂"] },
    Emoji { id: 1657, emoji: "🚣🏼‍♂️", name: "man rowing boat: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1655, SkinTone::MediumLight)), aliases: None, variations: &["🚣🏼\u{200d}♂"] },
    Emoji { id: 1658, emoji: "🚣🏽‍♂️", name: "man rowing boat: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1655, SkinTone::Medium)), aliases: None, variations: &["🚣🏽\u{200d}♂"] },
    Emoji { id: 1659, emoji: "🚣🏾‍♂️", name: "man rowing boat: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1655, SkinTone::MediumDark)), aliases: None, variations: &["🚣🏾\u{200d}♂"] },
    Emoji { id: 1660, emoji: "🚣🏿‍♂️", name: "man rowing boat: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1655, SkinTone::Dark)), aliases: None, variations: &["🚣🏿\u{200d}♂"] },
    Emoji { id: 1661, emoji: "🚣‍♀️", name: "woman rowing boat", group: Group::PeopleAndBody, skin_tone: Some((1661, SkinTone::Default)), aliases: Some(&["rowing_woman"]), variations: &["🚣\u{200d}♀"] },
    Emoji { id: 1662, emoji: "🚣🏻‍♀️", name: "woman rowing boat: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1661, SkinTone::Light)), aliases: None, variations: &["🚣🏻\u{200d}♀"] },
    Emoji { id: 1663, emoji: "🚣🏼‍♀️", name: "woman rowing boat: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1661, SkinTone::MediumLight)), aliases: None, variations: &["🚣🏼\u{200d}♀"] },
    Emoji { id: 1664, emoji: "🚣🏽‍♀️", name: "woman rowing boat: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1661, SkinTone::Medium)), aliases: None, variations: &["🚣🏽\u{200d}♀"] },
    Emoji { id: 1665, emoji: "🚣🏾‍♀️", name: "woman rowing boat: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1661, SkinTone::MediumDark)), aliases: None, variations: &["🚣🏾\u{200d}♀"] },
    Emoji { id: 1666, emoji: "🚣🏿‍♀️", name: "woman rowing boat: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1661, SkinTone::Dark)), aliases: None, variations: &["🚣🏿\u{200d}♀"] },
    Emoji { id: 1667, emoji: "🏊", name: "person swimming", group: Group::PeopleAndBody, skin_tone: Some((1667, SkinTone::Default)), aliases: Some(&["swimmer"]), variations: &[] },
    Emoji { id: 1668, emoji: "🏊🏻", name: "person swimming: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1667, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 1669, emoji: "🏊🏼", name: "person swimming: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1667, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 1670, emoji: "🏊🏽", name: "person swimming: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1667, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 1671, emoji: "🏊🏾", name: "person swimming: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1667, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 1672, emoji: "🏊🏿", name: "person swimming: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1667, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 1673, emoji: "🏊‍♂️", name: "man swimming", group: Group::PeopleAndBody, skin_tone: Some((1673, SkinTone::Default)), aliases: Some(&["swimming_man"]), variations: &["🏊\u{200d}♂"] },
    Emoji { id: 1674, emoji: "🏊🏻‍♂️", name: "man swimming: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1673, SkinTone::Light)), aliases: None, variations: &["🏊🏻\u{200d}♂"] },
    Emoji { id: 1675, emoji: "🏊🏼‍♂️", name: "man swimming: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1673, SkinTone::MediumLight)), aliases: None, variations: &["🏊🏼\u{200d}♂"] },
    Emoji { id: 1676, emoji: "🏊🏽‍♂️", name: "man swimming: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1673, SkinTone::Medium)), aliases: None, variations: &["🏊🏽\u{200d}♂"] },
    Emoji { id: 1677, emoji: "🏊🏾‍♂️", name: "man swimming: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1673, SkinTone::MediumDark)), aliases: None, variations: &["🏊🏾\u{200d}♂"] },
    Emoji { id: 1678, emoji: "🏊🏿‍♂️", name: "man swimming: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1673, SkinTone::Dark)), aliases: None, variations: &["🏊🏿\u{200d}♂"] },
    Emoji { id: 1679, emoji: "🏊‍♀️", name: "woman swimming", group: Group::PeopleAndBody, skin_tone: Some((1679, SkinTone::Default)), aliases: Some(&["swimming_woman"]), variations: &["🏊\u{200d}♀"] },
    Emoji { id: 1680, emoji: "🏊🏻‍♀️", name: "woman swimming: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1679, SkinTone::Light)), aliases: None, variations: &["🏊🏻\u{200d}♀"] },
    Emoji { id: 1681, emoji: "🏊🏼‍♀️", name: "woman swimming: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1679, SkinTone::MediumLight)), aliases: None, variations: &["🏊🏼\u{200d}♀"] },
    Emoji { id: 1682, emoji: "🏊🏽‍♀️", name: "woman swimming: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1679, SkinTone::Medium)), aliases: None, variations: &["🏊🏽\u{200d}♀"] },
    Emoji { id: 1683, emoji: "🏊🏾‍♀️", name: "woman swimming: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1679, SkinTone::MediumDark)), aliases: None, variations: &["🏊🏾\u{200d}♀"] },
    Emoji { id: 1684, emoji: "🏊🏿‍♀️", name: "woman swimming: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1679, SkinTone::Dark)), aliases: None, variations: &["🏊🏿\u{200d}♀"] },
    Emoji { id: 1685, emoji: "⛹️", name: "person bouncing ball", group: Group::PeopleAndBody, skin_tone: Some((1685, SkinTone::Default)), aliases: Some(&["bouncing_ball_person"]), variations: &["⛹"] },
    Emoji { id: 1686, emoji: "⛹🏻", name: "person bouncing ball: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1685, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 1687, emoji: "⛹🏼", name: "person bouncing ball: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1685, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 1688, emoji: "⛹🏽", name: "person bouncing ball: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1685, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 1689, emoji: "⛹🏾", name: "person bouncing ball: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1685, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 1690, emoji: "⛹🏿", name: "person bouncing ball: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1685, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 1691, emoji: "⛹️‍♂️", name: "man bouncing ball", group: Group::PeopleAndBody, skin_tone: Some((1691, SkinTone::Default)), aliases: Some(&["bouncing_ball_man", "basketball_man"]), variations: &["⛹\u{200d}♂\u{fe0f}", "⛹\u{fe0f}\u{200d}♂", "⛹\u{200d}♂"] },
    Emoji { id: 1692, emoji: "⛹🏻‍♂️", name: "man bouncing ball: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1691, SkinTone::Light)), aliases: None, variations: &["⛹🏻\u{200d}♂"] },
    Emoji { id: 1693, emoji: "⛹🏼‍♂️", name: "man bouncing ball: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1691, SkinTone::MediumLight)), aliases: None, variations: &["⛹🏼\u{200d}♂"] },
    Emoji { id: 1694, emoji: "⛹🏽‍♂️", name: "man bouncing ball: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1691, SkinTone::Medium)), aliases: None, variations: &["⛹🏽\u{200d}♂"] },
    Emoji { id: 1695, emoji: "⛹🏾‍♂️", name: "man bouncing ball: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1691, SkinTone::MediumDark)), aliases: None, variations: &["⛹🏾\u{200d}♂"] },
    Emoji { id: 1696, emoji: "⛹🏿‍♂️", name: "man bouncing ball: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1691, SkinTone::Dark)), aliases: None, variations: &["⛹🏿\u{200d}♂"] },
    Emoji { id: 1697, emoji: "⛹️‍♀️", name: "woman bouncing ball", group: Group::PeopleAndBody, skin_tone: Some((1697, SkinTone::Default)), aliases: Some(&["bouncing_ball_woman", "basketball_woman"]), variations: &["⛹\u{200d}♀\u{fe0f}", "⛹\u{fe0f}\u{200d}♀", "⛹\u{200d}♀"] },
    Emoji { id: 1698, emoji: "⛹🏻‍♀️", name: "woman bouncing ball: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1697, SkinTone::Light)), aliases: None, variations: &["⛹🏻\u{200d}♀"] },
    Emoji { id: 1699, emoji: "⛹🏼‍♀️", name: "woman bouncing ball: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1697, SkinTone::MediumLight)), aliases: None, variations: &["⛹🏼\u{200d}♀"] },
    Emoji { id: 1700, emoji: "⛹🏽‍♀️", name: "woman bouncing ball: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1697, SkinTone::Medium)), aliases: None, variations: &["⛹🏽\u{200d}♀"] },
    Emoji { id: 1701, emoji: "⛹🏾‍♀️", name: "woman bouncing ball: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1697, SkinTone::MediumDark)), aliases: None, variations: &["⛹🏾\u{200d}♀"] },
    Emoji { id: 1702, emoji: "⛹🏿‍♀️", name: "woman bouncing ball: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1697, SkinTone::Dark)), aliases: None, variations: &["⛹🏿\u{200d}♀"] },
    Emoji { id: 1703, emoji: "🏋️", name: "person lifting weights", group: Group::PeopleAndBody, skin_tone: Some((1703, SkinTone::Default)), aliases: Some(&["weight_lifting"]), variations: &["🏋"] },
    Emoji { id: 1704, emoji: "🏋🏻", name: "person lifting weights: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1703, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 1705, emoji: "🏋🏼", name: "person lifting weights: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1703, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 1706, emoji: "🏋🏽", name: "person lifting weights: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1703, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 1707, emoji: "🏋🏾", name: "person lifting weights: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1703, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 1708, emoji: "🏋🏿", name: "person lifting weights: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1703, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 1709, emoji: "🏋️‍♂️", name: "man lifting weights", group: Group::PeopleAndBody, skin_tone: Some((1709, SkinTone::Default)), aliases: Some(&["weight_lifting_man"]), variations: &["🏋\u{200d}♂\u{fe0f}", "🏋\u{fe0f}\u{200d}♂", "🏋\u{200d}♂"] },
    Emoji { id: 1710, emoji: "🏋🏻‍♂️", name: "man lifting weights: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1709, SkinTone::Light)), aliases: None, variations: &["🏋🏻\u{200d}♂"] },
    Emoji { id: 1711, emoji: "🏋🏼‍♂️", name: "man lifting weights: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1709, SkinTone::MediumLight)), aliases: None, variations: &["🏋🏼\u{200d}♂"] },
    Emoji { id: 1712, emoji: "🏋🏽‍♂️", name: "man lifting weights: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1709, SkinTone::Medium)), aliases: None, variations: &["🏋🏽\u{200d}♂"] },
    Emoji { id: 1713, emoji: "🏋🏾‍♂️", name: "man lifting weights: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1709, SkinTone::MediumDark)), aliases: None, variations: &["🏋🏾\u{200d}♂"] },
    Emoji { id: 1714, emoji: "🏋🏿‍♂️", name: "man lifting weights: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1709, SkinTone::Dark)), aliases: None, variations: &["🏋🏿\u{200d}♂"] },
    Emoji { id: 1715, emoji: "🏋️‍♀️", name: "woman lifting weights", group: Group::PeopleAndBody, skin_tone: Some((1715, SkinTone::Default)), aliases: Some(&["weight_lifting_woman"]), variations: &["🏋\u{200d}♀\u{fe0f}", "🏋\u{fe0f}\u{200d}♀", "🏋\u{200d}♀"] },
    Emoji { id: 1716, emoji: "🏋🏻‍♀️", name: "woman lifting weights: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1715, SkinTone::Light)), aliases: None, variations: &["🏋🏻\u{200d}♀"] },
    Emoji { id: 1717, emoji: "🏋🏼‍♀️", name: "woman lifting weights: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1715, SkinTone::MediumLight)), aliases: None, variations: &["🏋🏼\u{200d}♀"] },
    Emoji { id: 1718, emoji: "🏋🏽‍♀️", name: "woman lifting weights: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1715, SkinTone::Medium)), aliases: None, variations: &["🏋🏽\u{200d}♀"] },
    Emoji { id: 1719, emoji: "🏋🏾‍♀️", name: "woman lifting weights: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1715, SkinTone::MediumDark)), aliases: None, variations: &["🏋🏾\u{200d}♀"] },
    Emoji { id: 1720, emoji: "🏋🏿‍♀️", name: "woman lifting weights: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1715, SkinTone::Dark)), aliases: None, variations: &["🏋🏿\u{200d}♀"] },
    Emoji { id: 1721, emoji: "🚴", name: "person biking", group: Group::PeopleAndBody, skin_tone: Some((1721, SkinTone::Default)), aliases: Some(&["bicyclist"]), variations: &[] },
    Emoji { id: 1722, emoji: "🚴🏻", name: "person biking: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1721, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 1723, emoji: "🚴🏼", name: "person biking: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1721, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 1724, emoji: "🚴🏽", name: "person biking: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1721, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 1725, emoji: "🚴🏾", name: "person biking: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1721, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 1726, emoji: "🚴🏿", name: "person biking: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1721, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 1727, emoji: "🚴‍♂️", name: "man biking", group: Group::PeopleAndBody, skin_tone: Some((1727, SkinTone::Default)), aliases: Some(&["biking_man"]), variations: &["🚴\u{200d}♂"] },
    Emoji { id: 1728, emoji: "🚴🏻‍♂️", name: "man biking: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1727, SkinTone::Light)), aliases: None, variations: &["🚴🏻\u{200d}♂"] },
    Emoji { id: 1729, emoji: "🚴🏼‍♂️", name: "man biking: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1727, SkinTone::MediumLight)), aliases: None, variations: &["🚴🏼\u{200d}♂"] },
    Emoji { id: 1730, emoji: "🚴🏽‍♂️", name: "man biking: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1727, SkinTone::Medium)), aliases: None, variations: &["🚴🏽\u{200d}♂"] },
    Emoji { id: 1731, emoji: "🚴🏾‍♂️", name: "man biking: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1727, SkinTone::MediumDark)), aliases: None, variations: &["🚴🏾\u{200d}♂"] },
    Emoji { id: 1732, emoji: "🚴🏿‍♂️", name: "man biking: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1727, SkinTone::Dark)), aliases: None, variations: &["🚴🏿\u{200d}♂"] },
    Emoji { id: 1733, emoji: "🚴‍♀️", name: "woman biking", group: Group::PeopleAndBody, skin_tone: Some((1733, SkinTone::Default)), aliases: Some(&["biking_woman"]), variations: &["🚴\u{200d}♀"] },
    Emoji { id: 1734, emoji: "🚴🏻‍♀️", name: "woman biking: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1733, SkinTone::Light)), aliases: None, variations: &["🚴🏻\u{200d}♀"] },
    Emoji { id: 1735, emoji: "🚴🏼‍♀️", name: "woman biking: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1733, SkinTone::MediumLight)), aliases: None, variations: &["🚴🏼\u{200d}♀"] },
    Emoji { id: 1736, emoji: "🚴🏽‍♀️", name: "woman biking: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1733, SkinTone::Medium)), aliases: None, variations: &["🚴🏽\u{200d}♀"] },
    Emoji { id: 1737, emoji: "🚴🏾‍♀️", name: "woman biking: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1733, SkinTone::MediumDark)), aliases: None, variations: &["🚴🏾\u{200d}♀"] },
    Emoji { id: 1738, emoji: "🚴🏿‍♀️", name: "woman biking: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1733, SkinTone::Dark)), aliases: None, variations: &["🚴🏿\u{200d}♀"] },
    Emoji { id: 1739, emoji: "🚵", name: "person mountain biking", group: Group::PeopleAndBody, skin_tone: Some((1739, SkinTone::Default)), aliases: Some(&["mountain_bicyclist"]), variations: &[] },
    Emoji { id: 1740, emoji: "🚵🏻", name: "person mountain biking: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1739, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 1741, emoji: "🚵🏼", name: "person mountain biking: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1739, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 1742, emoji: "🚵🏽", name: "person mountain biking: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1739, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 1743, emoji: "🚵🏾", name: "person mountain biking: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1739, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 1744, emoji: "🚵🏿", name: "person mountain biking: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1739, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 1745, emoji: "🚵‍♂️", name: "man mountain biking", group: Group::PeopleAndBody, skin_tone: Some((1745, SkinTone::Default)), aliases: Some(&["mountain_biking_man"]), variations: &["🚵\u{200d}♂"] },
    Emoji { id: 1746, emoji: "🚵🏻‍♂️", name: "man mountain biking: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1745, SkinTone::Light)), aliases: None, variations: &["🚵🏻\u{200d}♂"] },
    Emoji { id: 1747, emoji: "🚵🏼‍♂️", name: "man mountain biking: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1745, SkinTone::MediumLight)), aliases: None, variations: &["🚵🏼\u{200d}♂"] },
    Emoji { id: 1748, emoji: "🚵🏽‍♂️", name: "man mountain biking: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1745, SkinTone::Medium)), aliases: None, variations: &["🚵🏽\u{200d}♂"] },
    Emoji { id: 1749, emoji: "🚵🏾‍♂️", name: "man mountain biking: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1745, SkinTone::MediumDark)), aliases: None, variations: &["🚵🏾\u{200d}♂"] },
    Emoji { id: 1750, emoji: "🚵🏿‍♂️", name: "man mountain biking: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1745, SkinTone::Dark)), aliases: None, variations: &["🚵🏿\u{200d}♂"] },
    Emoji { id: 1751, emoji: "🚵‍♀️", name: "woman mountain biking", group: Group::PeopleAndBody, skin_tone: Some((1751, SkinTone::Default)), aliases: Some(&["mountain_biking_woman"]), variations: &["🚵\u{200d}♀"] },
    Emoji { id: 1752, emoji: "🚵🏻‍♀️", name: "woman mountain biking: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1751, SkinTone::Light)), aliases: None, variations: &["🚵🏻\u{200d}♀"] },
    Emoji { id: 1753, emoji: "🚵🏼‍♀️", name: "woman mountain biking: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1751, SkinTone::MediumLight)), aliases: None, variations: &["🚵🏼\u{200d}♀"] },
    Emoji { id: 1754, emoji: "🚵🏽‍♀️", name: "woman mountain biking: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1751, SkinTone::Medium)), aliases: None, variations: &["🚵🏽\u{200d}♀"] },
    Emoji { id: 1755, emoji: "🚵🏾‍♀️", name: "woman mountain biking: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1751, SkinTone::MediumDark)), aliases: None, variations: &["🚵🏾\u{200d}♀"] },
    Emoji { id: 1756, emoji: "🚵🏿‍♀️", name: "woman mountain biking: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1751, SkinTone::Dark)), aliases: None, variations: &["🚵🏿\u{200d}♀"] },
    Emoji { id: 1757, emoji: "🤸", name: "person cartwheeling", group: Group::PeopleAndBody, skin_tone: Some((1757, SkinTone::Default)), aliases: Some(&["cartwheeling"]), variations: &[] },
    Emoji { id: 1758, emoji: "🤸🏻", name: "person cartwheeling: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1757, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 1759, emoji: "🤸🏼", name: "person cartwheeling: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1757, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 1760, emoji: "🤸🏽", name: "person cartwheeling: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1757, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 1761, emoji: "🤸🏾", name: "person cartwheeling: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1757, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 1762, emoji: "🤸🏿", name: "person cartwheeling: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1757, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 1763, emoji: "🤸‍♂️", name: "man cartwheeling", group: Group::PeopleAndBody, skin_tone: Some((1763, SkinTone::Default)), aliases: Some(&["man_cartwheeling"]), variations: &["🤸\u{200d}♂"] },
    Emoji { id: 1764, emoji: "🤸🏻‍♂️", name: "man cartwheeling: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1763, SkinTone::Light)), aliases: None, variations: &["🤸🏻\u{200d}♂"] },
    Emoji { id: 1765, emoji: "🤸🏼‍♂️", name: "man cartwheeling: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1763, SkinTone::MediumLight)), aliases: None, variations: &["🤸🏼\u{200d}♂"] },
    Emoji { id: 1766, emoji: "🤸🏽‍♂️", name: "man cartwheeling: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1763, SkinTone::Medium)), aliases: None, variations: &["🤸🏽\u{200d}♂"] },
    Emoji { id: 1767, emoji: "🤸🏾‍♂️", name: "man cartwheeling: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1763, SkinTone::MediumDark)), aliases: None, variations: &["🤸🏾\u{200d}♂"] },
    Emoji { id: 1768, emoji: "🤸🏿‍♂️", name: "man cartwheeling: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1763, SkinTone::Dark)), aliases: None, variations: &["🤸🏿\u{200d}♂"] },
    Emoji { id: 1769, emoji: "🤸‍♀️", name: "woman cartwheeling", group: Group::PeopleAndBody, skin_tone: Some((1769, SkinTone::Default)), aliases: Some(&["woman_cartwheeling"]), variations: &["🤸\u{200d}♀"] },
    Emoji { id: 1770, emoji: "🤸🏻‍♀️", name: "woman cartwheeling: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1769, SkinTone::Light)), aliases: None, variations: &["🤸🏻\u{200d}♀"] },
    Emoji { id: 1771, emoji: "🤸🏼‍♀️", name: "woman cartwheeling: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1769, SkinTone::MediumLight)), aliases: None, variations: &["🤸🏼\u{200d}♀"] },
    Emoji { id: 1772, emoji: "🤸🏽‍♀️", name: "woman cartwheeling: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1769, SkinTone::Medium)), aliases: None, variations: &["🤸🏽\u{200d}♀"] },
    Emoji { id: 1773, emoji: "🤸🏾‍♀️", name: "woman cartwheeling: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1769, SkinTone::MediumDark)), aliases: None, variations: &["🤸🏾\u{200d}♀"] },
    Emoji { id: 1774, emoji: "🤸🏿‍♀️", name: "woman cartwheeling: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1769, SkinTone::Dark)), aliases: None, variations: &["🤸🏿\u{200d}♀"] },
    Emoji { id: 1775, emoji: "🤼", name: "people wrestling", group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["wrestling"]), variations: &[] },
    Emoji { id: 1776, emoji: "🤼‍♂️", name: "men wrestling", group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["men_wrestling"]), variations: &["🤼\u{200d}♂"] },
    Emoji { id: 1777, emoji: "🤼‍♀️", name: "women wrestling", group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["women_wrestling"]), variations: &["🤼\u{200d}♀"] },
    Emoji { id: 1778, emoji: "🤽", name: "person playing water polo", group: Group::PeopleAndBody, skin_tone: Some((1778, SkinTone::Default)), aliases: Some(&["water_polo"]), variations: &[] },
    Emoji { id: 1779, emoji: "🤽🏻", name: "person playing water polo: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1778, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 1780, emoji: "🤽🏼", name: "person playing water polo: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1778, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 1781, emoji: "🤽🏽", name: "person playing water polo: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1778, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 1782, emoji: "🤽🏾", name: "person playing water polo: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1778, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 1783, emoji: "🤽🏿", name: "person playing water polo: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1778, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 1784, emoji: "🤽‍♂️", name: "man playing water polo", group: Group::PeopleAndBody, skin_tone: Some((1784, SkinTone::Default)), aliases: Some(&["man_playing_water_polo"]), variations: &["🤽\u{200d}♂"] },
    Emoji { id: 1785, emoji: "🤽🏻‍♂️", name: "man playing water polo: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1784, SkinTone::Light)), aliases: None, variations: &["🤽🏻\u{200d}♂"] },
    Emoji { id: 1786, emoji: "🤽🏼‍♂️", name: "man playing water polo: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1784, SkinTone::MediumLight)), aliases: None, variations: &["🤽🏼\u{200d}♂"] },
    Emoji { id: 1787, emoji: "🤽🏽‍♂️", name: "man playing water polo: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1784, SkinTone::Medium)), aliases: None, variations: &["🤽🏽\u{200d}♂"] },
    Emoji { id: 1788, emoji: "🤽🏾‍♂️", name: "man playing water polo: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1784, SkinTone::MediumDark)), aliases: None, variations: &["🤽🏾\u{200d}♂"] },
    Emoji { id: 1789, emoji: "🤽🏿‍♂️", name: "man playing water polo: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1784, SkinTone::Dark)), aliases: None, variations: &["🤽🏿\u{200d}♂"] },
    Emoji { id: 1790, emoji: "🤽‍♀️", name: "woman playing water polo", group: Group::PeopleAndBody, skin_tone: Some((1790, SkinTone::Default)), aliases: Some(&["woman_playing_water_polo"]), variations: &["🤽\u{200d}♀"] },
    Emoji { id: 1791, emoji: "🤽🏻‍♀️", name: "woman playing water polo: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1790, SkinTone::Light)), aliases: None, variations: &["🤽🏻\u{200d}♀"] },
    Emoji { id: 1792, emoji: "🤽🏼‍♀️", name: "woman playing water polo: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1790, SkinTone::MediumLight)), aliases: None, variations: &["🤽🏼\u{200d}♀"] },
    Emoji { id: 1793, emoji: "🤽🏽‍♀️", name: "woman playing water polo: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1790, SkinTone::Medium)), aliases: None, variations: &["🤽🏽\u{200d}♀"] },
    Emoji { id: 1794, emoji: "🤽🏾‍♀️", name: "woman playing water polo: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1790, SkinTone::MediumDark)), aliases: None, variations: &["🤽🏾\u{200d}♀"] },
    Emoji { id: 1795, emoji: "🤽🏿‍♀️", name: "woman playing water polo: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1790, SkinTone::Dark)), aliases: None, variations: &["🤽🏿\u{200d}♀"] },
    Emoji { id: 1796, emoji: "🤾", name: "person playing handball", group: Group::PeopleAndBody, skin_tone: Some((1796, SkinTone::Default)), aliases: Some(&["handball_person"]), variations: &[] },
    Emoji { id: 1797, emoji: "🤾🏻", name: "person playing handball: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1796, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 1798, emoji: "🤾🏼", name: "person playing handball: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1796, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 1799, emoji: "🤾🏽", name: "person playing handball: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1796, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 1800, emoji: "🤾🏾", name: "person playing handball: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1796, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 1801, emoji: "🤾🏿", name: "person playing handball: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1796, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 1802, emoji: "🤾‍♂️", name: "man playing handball", group: Group::PeopleAndBody, skin_tone: Some((1802, SkinTone::Default)), aliases: Some(&["man_playing_handball"]), variations: &["🤾\u{200d}♂"] },
    Emoji { id: 1803, emoji: "🤾🏻‍♂️", name: "man playing handball: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1802, SkinTone::Light)), aliases: None, variations: &["🤾🏻\u{200d}♂"] },
    Emoji { id: 1804, emoji: "🤾🏼‍♂️", name: "man playing handball: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1802, SkinTone::MediumLight)), aliases: None, variations: &["🤾🏼\u{200d}♂"] },
    Emoji { id: 1805, emoji: "🤾🏽‍♂️", name: "man playing handball: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1802, SkinTone::Medium)), aliases: None, variations: &["🤾🏽\u{200d}♂"] },
    Emoji { id: 1806, emoji: "🤾🏾‍♂️", name: "man playing handball: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1802, SkinTone::MediumDark)), aliases: None, variations: &["🤾🏾\u{200d}♂"] },
    Emoji { id: 1807, emoji: "🤾🏿‍♂️", name: "man playing handball: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1802, SkinTone::Dark)), aliases: None, variations: &["🤾🏿\u{200d}♂"] },
    Emoji { id: 1808, emoji: "🤾‍♀️", name: "woman playing handball", group: Group::PeopleAndBody, skin_tone: Some((1808, SkinTone::Default)), aliases: Some(&["woman_playing_handball"]), variations: &["🤾\u{200d}♀"] },
    Emoji { id: 1809, emoji: "🤾🏻‍♀️", name: "woman playing handball: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1808, SkinTone::Light)), aliases: None, variations: &["🤾🏻\u{200d}♀"] },
    Emoji { id: 1810, emoji: "🤾🏼‍♀️", name: "woman playing handball: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1808, SkinTone::MediumLight)), aliases: None, variations: &["🤾🏼\u{200d}♀"] },
    Emoji { id: 1811, emoji: "🤾🏽‍♀️", name: "woman playing handball: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1808, SkinTone::Medium)), aliases: None, variations: &["🤾🏽\u{200d}♀"] },
    Emoji { id: 1812, emoji: "🤾🏾‍♀️", name: "woman playing handball: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1808, SkinTone::MediumDark)), aliases: None, variations: &["🤾🏾\u{200d}♀"] },
    Emoji { id: 1813, emoji: "🤾🏿‍♀️", name: "woman playing handball: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1808, SkinTone::Dark)), aliases: None, variations: &["🤾🏿\u{200d}♀"] },
    Emoji { id: 1814, emoji: "🤹", name: "person juggling", group: Group::PeopleAndBody, skin_tone: Some((1814, SkinTone::Default)), aliases: Some(&["juggling_person"]), variations: &[] },
    Emoji { id: 1815, emoji: "🤹🏻", name: "person juggling: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1814, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 1816, emoji: "🤹🏼", name: "person juggling: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1814, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 1817, emoji: "🤹🏽", name: "person juggling: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1814, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 1818, emoji: "🤹🏾", name: "person juggling: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1814, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 1819, emoji: "🤹🏿", name: "person juggling: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1814, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 1820, emoji: "🤹‍♂️", name: "man juggling", group: Group::PeopleAndBody, skin_tone: Some((1820, SkinTone::Default)), aliases: Some(&["man_juggling"]), variations: &["🤹\u{200d}♂"] },
    Emoji { id: 1821, emoji: "🤹🏻‍♂️", name: "man juggling: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1820, SkinTone::Light)), aliases: None, variations: &["🤹🏻\u{200d}♂"] },
    Emoji { id: 1822, emoji: "🤹🏼‍♂️", name: "man juggling: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1820, SkinTone::MediumLight)), aliases: None, variations: &["🤹🏼\u{200d}♂"] },
    Emoji { id: 1823, emoji: "🤹🏽‍♂️", name: "man juggling: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1820, SkinTone::Medium)), aliases: None, variations: &["🤹🏽\u{200d}♂"] },
    Emoji { id: 1824, emoji: "🤹🏾‍♂️", name: "man juggling: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1820, SkinTone::MediumDark)), aliases: None, variations: &["🤹🏾\u{200d}♂"] },
    Emoji { id: 1825, emoji: "🤹🏿‍♂️", name: "man juggling: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1820, SkinTone::Dark)), aliases: None, variations: &["🤹🏿\u{200d}♂"] },
    Emoji { id: 1826, emoji: "🤹‍♀️", name: "woman juggling", group: Group::PeopleAndBody, skin_tone: Some((1826, SkinTone::Default)), aliases: Some(&["woman_juggling"]), variations: &["🤹\u{200d}♀"] },
    Emoji { id: 1827, emoji: "🤹🏻‍♀️", name: "woman juggling: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1826, SkinTone::Light)), aliases: None, variations: &["🤹🏻\u{200d}♀"] },
    Emoji { id: 1828, emoji: "🤹🏼‍♀️", name: "woman juggling: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1826, SkinTone::MediumLight)), aliases: None, variations: &["🤹🏼\u{200d}♀"] },
    Emoji { id: 1829, emoji: "🤹🏽‍♀️", name: "woman juggling: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1826, SkinTone::Medium)), aliases: None, variations: &["🤹🏽\u{200d}♀"] },
    Emoji { id: 1830, emoji: "🤹🏾‍♀️", name: "woman juggling: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1826, SkinTone::MediumDark)), aliases: None, variations: &["🤹🏾\u{200d}♀"] },
    Emoji { id: 1831, emoji: "🤹🏿‍♀️", name: "woman juggling: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1826, SkinTone::Dark)), aliases: None, variations: &["🤹🏿\u{200d}♀"] },
    Emoji { id: 1832, emoji: "🧘", name: "person in lotus position", group: Group::PeopleAndBody, skin_tone: Some((1832, SkinTone::Default)), aliases: Some(&["lotus_position"]), variations: &[] },
    Emoji { id: 1833, emoji: "🧘🏻", name: "person in lotus position: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1832, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 1834, emoji: "🧘🏼", name: "person in lotus position: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1832, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 1835, emoji: "🧘🏽", name: "person in lotus position: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1832, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 1836, emoji: "🧘🏾", name: "person in lotus position: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1832, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 1837, emoji: "🧘🏿", name: "person in lotus position: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1832, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 1838, emoji: "🧘‍♂️", name: "man in lotus position", group: Group::PeopleAndBody, skin_tone: Some((1838, SkinTone::Default)), aliases: Some(&["lotus_position_man"]), variations: &["🧘\u{200d}♂"] },
    Emoji { id: 1839, emoji: "🧘🏻‍♂️", name: "man in lotus position: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1838, SkinTone::Light)), aliases: None, variations: &["🧘🏻\u{200d}♂"] },
    Emoji { id: 1840, emoji: "🧘🏼‍♂️", name: "man in lotus position: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1838, SkinTone::MediumLight)), aliases: None, variations: &["🧘🏼\u{200d}♂"] },
    Emoji { id: 1841, emoji: "🧘🏽‍♂️", name: "man in lotus position: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1838, SkinTone::Medium)), aliases: None, variations: &["🧘🏽\u{200d}♂"] },
    Emoji { id: 1842, emoji: "🧘🏾‍♂️", name: "man in lotus position: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1838, SkinTone::MediumDark)), aliases: None, variations: &["🧘🏾\u{200d}♂"] },
    Emoji { id: 1843, emoji: "🧘🏿‍♂️", name: "man in lotus position: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1838, SkinTone::Dark)), aliases: None, variations: &["🧘🏿\u{200d}♂"] },
    Emoji { id: 1844, emoji: "🧘‍♀️", name: "woman in lotus position", group: Group::PeopleAndBody, skin_tone: Some((1844, SkinTone::Default)), aliases: Some(&["lotus_position_woman"]), variations: &["🧘\u{200d}♀"] },
    Emoji { id: 1845, emoji: "🧘🏻‍♀️", name: "woman in lotus position: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1844, SkinTone::Light)), aliases: None, variations: &["🧘🏻\u{200d}♀"] },
    Emoji { id: 1846, emoji: "🧘🏼‍♀️", name: "woman in lotus position: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1844, SkinTone::MediumLight)), aliases: None, variations: &["🧘🏼\u{200d}♀"] },
    Emoji { id: 1847, emoji: "🧘🏽‍♀️", name: "woman in lotus position: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1844, SkinTone::Medium)), aliases: None, variations: &["🧘🏽\u{200d}♀"] },
    Emoji { id: 1848, emoji: "🧘🏾‍♀️", name: "woman in lotus position: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1844, SkinTone::MediumDark)), aliases: None, variations: &["🧘🏾\u{200d}♀"] },
    Emoji { id: 1849, emoji: "🧘🏿‍♀️", name: "woman in lotus position: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1844, SkinTone::Dark)), aliases: None, variations: &["🧘🏿\u{200d}♀"] },
    Emoji { id: 1850, emoji: "🛀", name: "person taking bath", group: Group::PeopleAndBody, skin_tone: Some((1850, SkinTone::Default)), aliases: Some(&["bath"]), variations: &[] },
    Emoji { id: 1851, emoji: "🛀🏻", name: "person taking bath: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1850, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 1852, emoji: "🛀🏼", name: "person taking bath: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1850, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 1853, emoji: "🛀🏽", name: "person taking bath: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1850, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 1854, emoji: "🛀🏾", name: "person taking bath: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1850, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 1855, emoji: "🛀🏿", name: "person taking bath: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1850, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 1856, emoji: "🛌", name: "person in bed", group: Group::PeopleAndBody, skin_tone: Some((1856, SkinTone::Default)), aliases: Some(&["sleeping_bed"]), variations: &[] },
    Emoji { id: 1857, emoji: "🛌🏻", name: "person in bed: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1856, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 1858, emoji: "🛌🏼", name: "person in bed: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1856, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 1859, emoji: "🛌🏽", name: "person in bed: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1856, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 1860, emoji: "🛌🏾", name: "person in bed: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1856, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 1861, emoji: "🛌🏿", name: "person in bed: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1856, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 1862, emoji: "🧑‍🤝‍🧑", name: "people holding hands", group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["people_holding_hands"]), variations: &["🧑🏻\u{200d}🤝\u{200d}🧑🏻", "🧑🏻\u{200d}🤝\u{200d}🧑🏼", "🧑🏻\u{200d}🤝\u{200d}🧑🏽", "🧑🏻\u{200d}🤝\u{200d}🧑🏾", "🧑🏻\u{200d}🤝\u{200d}🧑🏿", "🧑🏼\u{200d}🤝\u{200d}🧑🏻", "🧑🏼\u{200d}🤝\u{200d}🧑🏼", "🧑🏼\u{200d}🤝\u{200d}🧑🏽", "🧑🏼\u{200d}🤝\u{200d}🧑🏾", "🧑🏼\u{200d}🤝\u{200d}🧑🏿", "🧑🏽\u{200d}🤝\u{200d}🧑🏻", "🧑🏽\u{200d}🤝\u{200d}🧑🏼", "🧑🏽\u{200d}🤝\u{200d}🧑🏽", "🧑🏽\u{200d}🤝\u{200d}🧑🏾", "🧑🏽\u{200d}🤝\u{200d}🧑🏿", "🧑🏾\u{200d}🤝\u{200d}🧑🏻", "🧑🏾\u{200d}🤝\u{200d}🧑🏼", "🧑🏾\u{200d}🤝\u{200d}🧑🏽", "🧑🏾\u{200d}🤝\u{200d}🧑🏾", "🧑🏾\u{200d}🤝\u{200d}🧑🏿", "🧑🏿\u{200d}🤝\u{200d}🧑🏻", "🧑🏿\u{200d}🤝\u{200d}🧑🏼", "🧑🏿\u{200d}🤝\u{200d}🧑🏽", "🧑🏿\u{200d}🤝\u{200d}🧑🏾", "🧑🏿\u{200d}🤝\u{200d}🧑🏿"] },
    Emoji { id: 1863, emoji: "👭", name: "women holding hands", group: Group::PeopleAndBody, skin_tone: Some((1863, SkinTone::Default)), aliases: Some(&["two_women_holding_hands"]), variations: &["👩🏻\u{200d}🤝\u{200d}👩🏼", "👩🏻\u{200d}🤝\u{200d}👩🏽", "👩🏻\u{200d}🤝\u{200d}👩🏾", "👩🏻\u{200d}🤝\u{200d}👩🏿", "👩🏼\u{200d}🤝\u{200d}👩🏻", "👩🏼\u{200d}🤝\u{200d}👩🏽", "👩🏼\u{200d}🤝\u{200d}👩🏾", "👩🏼\u{200d}🤝\u{200d}👩🏿", "👩🏽\u{200d}🤝\u{200d}👩🏻", "👩🏽\u{200d}🤝\u{200d}👩🏼", "👩🏽\u{200d}🤝\u{200d}👩🏾", "👩🏽\u{200d}🤝\u{200d}👩🏿", "👩🏾\u{200d}🤝\u{200d}👩🏻", "👩🏾\u{200d}🤝\u{200d}👩🏼", "👩🏾\u{200d}🤝\u{200d}👩🏽", "👩🏾\u{200d}🤝\u{200d}👩🏿", "👩🏿\u{200d}🤝\u{200d}👩🏻", "👩🏿\u{200d}🤝\u{200d}👩🏼", "👩🏿\u{200d}🤝\u{200d}👩🏽", "👩🏿\u{200d}🤝\u{200d}👩🏾"] },
    Emoji { id: 1864, emoji: "👭🏻", name: "women holding hands: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1863, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 1865, emoji: "👭🏼", name: "women holding hands: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1863, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 1866, emoji: "👭🏽", name: "women holding hands: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1863, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 1867, emoji: "👭🏾", name: "women holding hands: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1863, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 1868, emoji: "👭🏿", name: "women holding hands: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1863, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 1869, emoji: "👫", name: "woman and man holding hands", group: Group::PeopleAndBody, skin_tone: Some((1869, SkinTone::Default)), aliases: Some(&["couple"]), variations: &["👩🏻\u{200d}🤝\u{200d}👨🏼", "👩🏻\u{200d}🤝\u{200d}👨🏽", "👩🏻\u{200d}🤝\u{200d}👨🏾", "👩🏻\u{200d}🤝\u{200d}👨🏿", "👩🏼\u{200d}🤝\u{200d}👨🏻", "👩🏼\u{200d}🤝\u{200d}👨🏽", "👩🏼\u{200d}🤝\u{200d}👨🏾", "👩🏼\u{200d}🤝\u{200d}👨🏿", "👩🏽\u{200d}🤝\u{200d}👨🏻", "👩🏽\u{200d}🤝\u{200d}👨🏼", "👩🏽\u{200d}🤝\u{200d}👨🏾", "👩🏽\u{200d}🤝\u{200d}👨🏿", "👩🏾\u{200d}🤝\u{200d}👨🏻", "👩🏾\u{200d}🤝\u{200d}👨🏼", "👩🏾\u{200d}🤝\u{200d}👨🏽", "👩🏾\u{200d}🤝\u{200d}👨🏿", "👩🏿\u{200d}🤝\u{200d}👨🏻", "👩🏿\u{200d}🤝\u{200d}👨🏼", "👩🏿\u{200d}🤝\u{200d}👨🏽", "👩🏿\u{200d}🤝\u{200d}👨🏾"] },
    Emoji { id: 1870, emoji: "👫🏻", name: "woman and man holding hands: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1869, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 1871, emoji: "👫🏼", name: "woman and man holding hands: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1869, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 1872, emoji: "👫🏽", name: "woman and man holding hands: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1869, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 1873, emoji: "👫🏾", name: "woman and man holding hands: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1869, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 1874, emoji: "👫🏿", name: "woman and man holding hands: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1869, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 1875, emoji: "👬", name: "men holding hands", group: Group::PeopleAndBody, skin_tone: Some((1875, SkinTone::Default)), aliases: Some(&["two_men_holding_hands"]), variations: &["👨🏻\u{200d}🤝\u{200d}👨🏼", "👨🏻\u{200d}🤝\u{200d}👨🏽", "👨🏻\u{200d}🤝\u{200d}👨🏾", "👨🏻\u{200d}🤝\u{200d}👨🏿", "👨🏼\u{200d}🤝\u{200d}👨🏻", "👨🏼\u{200d}🤝\u{200d}👨🏽", "👨🏼\u{200d}🤝\u{200d}👨🏾", "👨🏼\u{200d}🤝\u{200d}👨🏿", "👨🏽\u{200d}🤝\u{200d}👨🏻", "👨🏽\u{200d}🤝\u{200d}👨🏼", "👨🏽\u{200d}🤝\u{200d}👨🏾", "👨🏽\u{200d}🤝\u{200d}👨🏿", "👨🏾\u{200d}🤝\u{200d}👨🏻", "👨🏾\u{200d}🤝\u{200d}👨🏼", "👨🏾\u{200d}🤝\u{200d}👨🏽", "👨🏾\u{200d}🤝\u{200d}👨🏿", "👨🏿\u{200d}🤝\u{200d}👨🏻", "👨🏿\u{200d}🤝\u{200d}👨🏼", "👨🏿\u{200d}🤝\u{200d}👨🏽", "👨🏿\u{200d}🤝\u{200d}👨🏾"] },
    Emoji { id: 1876, emoji: "👬🏻", name: "men holding hands: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1875, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 1877, emoji: "👬🏼", name: "men holding hands: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1875, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 1878, emoji: "👬🏽", name: "men holding hands: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1875, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 1879, emoji: "👬🏾", name: "men holding hands: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1875, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 1880, emoji: "👬🏿", name: "men holding hands: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1875, SkinTone::Dark)), aliases: None, variations: &[] },
    Emoji { id: 1881, emoji: "💏", name: "kiss", group: Group::PeopleAndBody, skin_tone: Some((1881, SkinTone::Default)), aliases: Some(&["couplekiss"]), variations: &["🧑🏻\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}🧑🏼", "🧑🏻\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}🧑🏽", "🧑🏻\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}🧑🏾", "🧑🏻\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}🧑🏿", "🧑🏼\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}🧑🏻", "🧑🏼\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}🧑🏽", "🧑🏼\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}🧑🏾", "🧑🏼\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}🧑🏿", "🧑🏽\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}🧑🏻", "🧑🏽\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}🧑🏼", "🧑🏽\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}🧑🏾", "🧑🏽\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}🧑🏿", "🧑🏾\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}🧑🏻", "🧑🏾\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}🧑🏼", "🧑🏾\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}🧑🏽", "🧑🏾\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}🧑🏿", "🧑🏿\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}🧑🏻", "🧑🏿\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}🧑🏼", "🧑🏿\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}🧑🏽", "🧑🏿\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}🧑🏾"] },
    Emoji { id: 1882, emoji: "💏🏻", name: "kiss: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1881, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 1883, emoji: "💏🏼", name: "kiss: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1881, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 1884, emoji: "💏🏽", name: "kiss: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1881, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 1885, emoji: "💏🏾", name: "kiss: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1881, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 1886, emoji: "💏🏿", name: "kiss: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1881, SkinTone::Dark)), aliases: None, variations: &["🧑🏻\u{200d}❤\u{200d}💋\u{200d}🧑🏼", "🧑🏻\u{200d}❤\u{200d}💋\u{200d}🧑🏽", "🧑🏻\u{200d}❤\u{200d}💋\u{200d}🧑🏾", "🧑🏻\u{200d}❤\u{200d}💋\u{200d}🧑🏿", "🧑🏼\u{200d}❤\u{200d}💋\u{200d}🧑🏻", "🧑🏼\u{200d}❤\u{200d}💋\u{200d}🧑🏽", "🧑🏼\u{200d}❤\u{200d}💋\u{200d}🧑🏾", "🧑🏼\u{200d}❤\u{200d}💋\u{200d}🧑🏿", "🧑🏽\u{200d}❤\u{200d}💋\u{200d}🧑🏻", "🧑🏽\u{200d}❤\u{200d}💋\u{200d}🧑🏼", "🧑🏽\u{200d}❤\u{200d}💋\u{200d}🧑🏾", "🧑🏽\u{200d}❤\u{200d}💋\u{200d}🧑🏿", "🧑🏾\u{200d}❤\u{200d}💋\u{200d}🧑🏻", "🧑🏾\u{200d}❤\u{200d}💋\u{200d}🧑🏼", "🧑🏾\u{200d}❤\u{200d}💋\u{200d}🧑🏽", "🧑🏾\u{200d}❤\u{200d}💋\u{200d}🧑🏿", "🧑🏿\u{200d}❤\u{200d}💋\u{200d}🧑🏻", "🧑🏿\u{200d}❤\u{200d}💋\u{200d}🧑🏼", "🧑🏿\u{200d}❤\u{200d}💋\u{200d}🧑🏽", "🧑🏿\u{200d}❤\u{200d}💋\u{200d}🧑🏾"] },
    Emoji { id: 1887, emoji: "👩‍❤️‍💋‍👨", name: "kiss: woman, man", group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["couplekiss_man_woman"]), variations: &["👩\u{200d}❤\u{200d}💋\u{200d}👨", "👩🏻\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏻", "👩🏻\u{200d}❤\u{200d}💋\u{200d}👨🏻", "👩🏻\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏼", "👩🏻\u{200d}❤\u{200d}💋\u{200d}👨🏼", "👩🏻\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏽", "👩🏻\u{200d}❤\u{200d}💋\u{200d}👨🏽", "👩🏻\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏾", "👩🏻\u{200d}❤\u{200d}💋\u{200d}👨🏾", "👩🏻\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏿", "👩🏻\u{200d}❤\u{200d}💋\u{200d}👨🏿", "👩🏼\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏻", "👩🏼\u{200d}❤\u{200d}💋\u{200d}👨🏻", "👩🏼\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏼", "👩🏼\u{200d}❤\u{200d}💋\u{200d}👨🏼", "👩🏼\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏽", "👩🏼\u{200d}❤\u{200d}💋\u{200d}👨🏽", "👩🏼\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏾", "👩🏼\u{200d}❤\u{200d}💋\u{200d}👨🏾", "👩🏼\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏿", "👩🏼\u{200d}❤\u{200d}💋\u{200d}👨🏿", "👩🏽\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏻", "👩🏽\u{200d}❤\u{200d}💋\u{200d}👨🏻", "👩🏽\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏼", "👩🏽\u{200d}❤\u{200d}💋\u{200d}👨🏼", "👩🏽\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏽", "👩🏽\u{200d}❤\u{200d}💋\u{200d}👨🏽", "👩🏽\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏾", "👩🏽\u{200d}❤\u{200d}💋\u{200d}👨🏾", "👩🏽\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏿", "👩🏽\u{200d}❤\u{200d}💋\u{200d}👨🏿", "👩🏾\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏻", "👩🏾\u{200d}❤\u{200d}💋\u{200d}👨🏻", "👩🏾\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏼", "👩🏾\u{200d}❤\u{200d}💋\u{200d}👨🏼", "👩🏾\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏽", "👩🏾\u{200d}❤\u{200d}💋\u{200d}👨🏽", "👩🏾\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏾", "👩🏾\u{200d}❤\u{200d}💋\u{200d}👨🏾", "👩🏾\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏿", "👩🏾\u{200d}❤\u{200d}💋\u{200d}👨🏿", "👩🏿\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏻", "👩🏿\u{200d}❤\u{200d}💋\u{200d}👨🏻", "👩🏿\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏼", "👩🏿\u{200d}❤\u{200d}💋\u{200d}👨🏼", "👩🏿\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏽", "👩🏿\u{200d}❤\u{200d}💋\u{200d}👨🏽", "👩🏿\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏾", "👩🏿\u{200d}❤\u{200d}💋\u{200d}👨🏾", "👩🏿\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏿", "👩🏿\u{200d}❤\u{200d}💋\u{200d}👨🏿"] },
    Emoji { id: 1888, emoji: "👨‍❤️‍💋‍👨", name: "kiss: man, man", group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["couplekiss_man_man"]), variations: &["👨\u{200d}❤\u{200d}💋\u{200d}👨", "👨🏻\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏻", "👨🏻\u{200d}❤\u{200d}💋\u{200d}👨🏻", "👨🏻\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏼", "👨🏻\u{200d}❤\u{200d}💋\u{200d}👨🏼", "👨🏻\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏽", "👨🏻\u{200d}❤\u{200d}💋\u{200d}👨🏽", "👨🏻\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏾", "👨🏻\u{200d}❤\u{200d}💋\u{200d}👨🏾", "👨🏻\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏿", "👨🏻\u{200d}❤\u{200d}💋\u{200d}👨🏿", "👨🏼\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏻", "👨🏼\u{200d}❤\u{200d}💋\u{200d}👨🏻", "👨🏼\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏼", "👨🏼\u{200d}❤\u{200d}💋\u{200d}👨🏼", "👨🏼\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏽", "👨🏼\u{200d}❤\u{200d}💋\u{200d}👨🏽", "👨🏼\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏾", "👨🏼\u{200d}❤\u{200d}💋\u{200d}👨🏾", "👨🏼\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏿", "👨🏼\u{200d}❤\u{200d}💋\u{200d}👨🏿", "👨🏽\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏻", "👨🏽\u{200d}❤\u{200d}💋\u{200d}👨🏻", "👨🏽\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏼", "👨🏽\u{200d}❤\u{200d}💋\u{200d}👨🏼", "👨🏽\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏽", "👨🏽\u{200d}❤\u{200d}💋\u{200d}👨🏽", "👨🏽\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏾", "👨🏽\u{200d}❤\u{200d}💋\u{200d}👨🏾", "👨🏽\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏿", "👨🏽\u{200d}❤\u{200d}💋\u{200d}👨🏿", "👨🏾\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏻", "👨🏾\u{200d}❤\u{200d}💋\u{200d}👨🏻", "👨🏾\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏼", "👨🏾\u{200d}❤\u{200d}💋\u{200d}👨🏼", "👨🏾\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏽", "👨🏾\u{200d}❤\u{200d}💋\u{200d}👨🏽", "👨🏾\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏾", "👨🏾\u{200d}❤\u{200d}💋\u{200d}👨🏾", "👨🏾\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏿", "👨🏾\u{200d}❤\u{200d}💋\u{200d}👨🏿", "👨🏿\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏻", "👨🏿\u{200d}❤\u{200d}💋\u{200d}👨🏻", "👨🏿\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏼", "👨🏿\u{200d}❤\u{200d}💋\u{200d}👨🏼", "👨🏿\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏽", "👨🏿\u{200d}❤\u{200d}💋\u{200d}👨🏽", "👨🏿\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏾", "👨🏿\u{200d}❤\u{200d}💋\u{200d}👨🏾", "👨🏿\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏿", "👨🏿\u{200d}❤\u{200d}💋\u{200d}👨🏿"] },
    Emoji { id: 1889, emoji: "👩‍❤️‍💋‍👩", name: "kiss: woman, woman", group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["couplekiss_woman_woman"]), variations: &["👩\u{200d}❤\u{200d}💋\u{200d}👩", "👩🏻\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👩🏻", "👩🏻\u{200d}❤\u{200d}💋\u{200d}👩🏻", "👩🏻\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👩🏼", "👩🏻\u{200d}❤\u{200d}💋\u{200d}👩🏼", "👩🏻\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👩🏽", "👩🏻\u{200d}❤\u{200d}💋\u{200d}👩🏽", "👩🏻\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👩🏾", "👩🏻\u{200d}❤\u{200d}💋\u{200d}👩🏾", "👩🏻\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👩🏿", "👩🏻\u{200d}❤\u{200d}💋\u{200d}👩🏿", "👩🏼\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👩🏻", "👩🏼\u{200d}❤\u{200d}💋\u{200d}👩🏻", "👩🏼\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👩🏼", "👩🏼\u{200d}❤\u{200d}💋\u{200d}👩🏼", "👩🏼\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👩🏽", "👩🏼\u{200d}❤\u{200d}💋\u{200d}👩🏽", "👩🏼\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👩🏾", "👩🏼\u{200d}❤\u{200d}💋\u{200d}👩🏾", "👩🏼\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👩🏿", "👩🏼\u{200d}❤\u{200d}💋\u{200d}👩🏿", "👩🏽\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👩🏻", "👩🏽\u{200d}❤\u{200d}💋\u{200d}👩🏻", "👩🏽\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👩🏼", "👩🏽\u{200d}❤\u{200d}💋\u{200d}👩🏼", "👩🏽\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👩🏽", "👩🏽\u{200d}❤\u{200d}💋\u{200d}👩🏽", "👩🏽\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👩🏾", "👩🏽\u{200d}❤\u{200d}💋\u{200d}👩🏾", "👩🏽\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👩🏿", "👩🏽\u{200d}❤\u{200d}💋\u{200d}👩🏿", "👩🏾\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👩🏻", "👩🏾\u{200d}❤\u{200d}💋\u{200d}👩🏻", "👩🏾\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👩🏼", "👩🏾\u{200d}❤\u{200d}💋\u{200d}👩🏼", "👩🏾\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👩🏽", "👩🏾\u{200d}❤\u{200d}💋\u{200d}👩🏽", "👩🏾\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👩🏾", "👩🏾\u{200d}❤\u{200d}💋\u{200d}👩🏾", "👩🏾\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👩🏿", "👩🏾\u{200d}❤\u{200d}💋\u{200d}👩🏿", "👩🏿\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👩🏻", "👩🏿\u{200d}❤\u{200d}💋\u{200d}👩🏻", "👩🏿\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👩🏼", "👩🏿\u{200d}❤\u{200d}💋\u{200d}👩🏼", "👩🏿\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👩🏽", "👩🏿\u{200d}❤\u{200d}💋\u{200d}👩🏽", "👩🏿\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👩🏾", "👩🏿\u{200d}❤\u{200d}💋\u{200d}👩🏾", "👩🏿\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👩🏿", "👩🏿\u{200d}❤\u{200d}💋\u{200d}👩🏿"] },
    Emoji { id: 1890, emoji: "💑", name: "couple with heart", group: Group::PeopleAndBody, skin_tone: Some((1890, SkinTone::Default)), aliases: Some(&["couple_with_heart"]), variations: &["🧑🏻\u{200d}❤\u{fe0f}\u{200d}🧑🏼", "🧑🏻\u{200d}❤\u{fe0f}\u{200d}🧑🏽", "🧑🏻\u{200d}❤\u{fe0f}\u{200d}🧑🏾", "🧑🏻\u{200d}❤\u{fe0f}\u{200d}🧑🏿", "🧑🏼\u{200d}❤\u{fe0f}\u{200d}🧑🏻", "🧑🏼\u{200d}❤\u{fe0f}\u{200d}🧑🏽", "🧑🏼\u{200d}❤\u{fe0f}\u{200d}🧑🏾", "🧑🏼\u{200d}❤\u{fe0f}\u{200d}🧑🏿", "🧑🏽\u{200d}❤\u{fe0f}\u{200d}🧑🏻", "🧑🏽\u{200d}❤\u{fe0f}\u{200d}🧑🏼", "🧑🏽\u{200d}❤\u{fe0f}\u{200d}🧑🏾", "🧑🏽\u{200d}❤\u{fe0f}\u{200d}🧑🏿", "🧑🏾\u{200d}❤\u{fe0f}\u{200d}🧑🏻", "🧑🏾\u{200d}❤\u{fe0f}\u{200d}🧑🏼", "🧑🏾\u{200d}❤\u{fe0f}\u{200d}🧑🏽", "🧑🏾\u{200d}❤\u{fe0f}\u{200d}🧑🏿", "🧑🏿\u{200d}❤\u{fe0f}\u{200d}🧑🏻", "🧑🏿\u{200d}❤\u{fe0f}\u{200d}🧑🏼", "🧑🏿\u{200d}❤\u{fe0f}\u{200d}🧑🏽", "🧑🏿\u{200d}❤\u{fe0f}\u{200d}🧑🏾"] },
    Emoji { id: 1891, emoji: "💑🏻", name: "couple with heart: light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1890, SkinTone::Light)), aliases: None, variations: &[] },
    Emoji { id: 1892, emoji: "💑🏼", name: "couple with heart: medium-light skin tone", group: Group::PeopleAndBody, skin_tone: Some((1890, SkinTone::MediumLight)), aliases: None, variations: &[] },
    Emoji { id: 1893, emoji: "💑🏽", name: "couple with heart: medium skin tone", group: Group::PeopleAndBody, skin_tone: Some((1890, SkinTone::Medium)), aliases: None, variations: &[] },
    Emoji { id: 1894, emoji: "💑🏾", name: "couple with heart: medium-dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1890, SkinTone::MediumDark)), aliases: None, variations: &[] },
    Emoji { id: 1895, emoji: "💑🏿", name: "couple with heart: dark skin tone", group: Group::PeopleAndBody, skin_tone: Some((1890, SkinTone::Dark)), aliases: None, variations: &["🧑🏻\u{200d}❤\u{200d}🧑🏼", "🧑🏻\u{200d}❤\u{200d}🧑🏽", "🧑🏻\u{200d}❤\u{200d}🧑🏾", "🧑🏻\u{200d}❤\u{200d}🧑🏿", "🧑🏼\u{200d}❤\u{200d}🧑🏻", "🧑🏼\u{200d}❤\u{200d}🧑🏽", "🧑🏼\u{200d}❤\u{200d}🧑🏾", "🧑🏼\u{200d}❤\u{200d}🧑🏿", "🧑🏽\u{200d}❤\u{200d}🧑🏻", "🧑🏽\u{200d}❤\u{200d}🧑🏼", "🧑🏽\u{200d}❤\u{200d}🧑🏾", "🧑🏽\u{200d}❤\u{200d}🧑🏿", "🧑🏾\u{200d}❤\u{200d}🧑🏻", "🧑🏾\u{200d}❤\u{200d}🧑🏼", "🧑🏾\u{200d}❤\u{200d}🧑🏽", "🧑🏾\u{200d}❤\u{200d}🧑🏿", "🧑🏿\u{200d}❤\u{200d}🧑🏻", "🧑🏿\u{200d}❤\u{200d}🧑🏼", "🧑🏿\u{200d}❤\u{200d}🧑🏽", "🧑🏿\u{200d}❤\u{200d}🧑🏾"] },
    Emoji { id: 1896, emoji: "👩‍❤️‍👨", name: "couple with heart: woman, man", group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["couple_with_heart_woman_man"]), variations: &["👩\u{200d}❤\u{200d}👨", "👩🏻\u{200d}❤\u{fe0f}\u{200d}👨🏻", "👩🏻\u{200d}❤\u{200d}👨🏻", "👩🏻\u{200d}❤\u{fe0f}\u{200d}👨🏼", "👩🏻\u{200d}❤\u{200d}👨🏼", "👩🏻\u{200d}❤\u{fe0f}\u{200d}👨🏽", "👩🏻\u{200d}❤\u{200d}👨🏽", "👩🏻\u{200d}❤\u{fe0f}\u{200d}👨🏾", "👩🏻\u{200d}❤\u{200d}👨🏾", "👩🏻\u{200d}❤\u{fe0f}\u{200d}👨🏿", "👩🏻\u{200d}❤\u{200d}👨🏿", "👩🏼\u{200d}❤\u{fe0f}\u{200d}👨🏻", "👩🏼\u{200d}❤\u{200d}👨🏻", "👩🏼\u{200d}❤\u{fe0f}\u{200d}👨🏼", "👩🏼\u{200d}❤\u{200d}👨🏼", "👩🏼\u{200d}❤\u{fe0f}\u{200d}👨🏽", "👩🏼\u{200d}❤\u{200d}👨🏽", "👩🏼\u{200d}❤\u{fe0f}\u{200d}👨🏾", "👩🏼\u{200d}❤\u{200d}👨🏾", "👩🏼\u{200d}❤\u{fe0f}\u{200d}👨🏿", "👩🏼\u{200d}❤\u{200d}👨🏿", "👩🏽\u{200d}❤\u{fe0f}\u{200d}👨🏻", "👩🏽\u{200d}❤\u{200d}👨🏻", "👩🏽\u{200d}❤\u{fe0f}\u{200d}👨🏼", "👩🏽\u{200d}❤\u{200d}👨🏼", "👩🏽\u{200d}❤\u{fe0f}\u{200d}👨🏽", "👩🏽\u{200d}❤\u{200d}👨🏽", "👩🏽\u{200d}❤\u{fe0f}\u{200d}👨🏾", "👩🏽\u{200d}❤\u{200d}👨🏾", "👩🏽\u{200d}❤\u{fe0f}\u{200d}👨🏿", "👩🏽\u{200d}❤\u{200d}👨🏿", "👩🏾\u{200d}❤\u{fe0f}\u{200d}👨🏻", "👩🏾\u{200d}❤\u{200d}👨🏻", "👩🏾\u{200d}❤\u{fe0f}\u{200d}👨🏼", "👩🏾\u{200d}❤\u{200d}👨🏼", "👩🏾\u{200d}❤\u{fe0f}\u{200d}👨🏽", "👩🏾\u{200d}❤\u{200d}👨🏽", "👩🏾\u{200d}❤\u{fe0f}\u{200d}👨🏾", "👩🏾\u{200d}❤\u{200d}👨🏾", "👩🏾\u{200d}❤\u{fe0f}\u{200d}👨🏿", "👩🏾\u{200d}❤\u{200d}👨🏿", "👩🏿\u{200d}❤\u{fe0f}\u{200d}👨🏻", "👩🏿\u{200d}❤\u{200d}👨🏻", "👩🏿\u{200d}❤\u{fe0f}\u{200d}👨🏼", "👩🏿\u{200d}❤\u{200d}👨🏼", "👩🏿\u{200d}❤\u{fe0f}\u{200d}👨🏽", "👩🏿\u{200d}❤\u{200d}👨🏽", "👩🏿\u{200d}❤\u{fe0f}\u{200d}👨🏾", "👩🏿\u{200d}❤\u{200d}👨🏾", "👩🏿\u{200d}❤\u{fe0f}\u{200d}👨🏿", "👩🏿\u{200d}❤\u{200d}👨🏿"] },
    Emoji { id: 1897, emoji: "👨‍❤️‍👨", name: "couple with heart: man, man", group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["couple_with_heart_man_man"]), variations: &["👨\u{200d}❤\u{200d}👨", "👨🏻\u{200d}❤\u{fe0f}\u{200d}👨🏻", "👨🏻\u{200d}❤\u{200d}👨🏻", "👨🏻\u{200d}❤\u{fe0f}\u{200d}👨🏼", "👨🏻\u{200d}❤\u{200d}👨🏼", "👨🏻\u{200d}❤\u{fe0f}\u{200d}👨🏽", "👨🏻\u{200d}❤\u{200d}👨🏽", "👨🏻\u{200d}❤\u{fe0f}\u{200d}👨🏾", "👨🏻\u{200d}❤\u{200d}👨🏾", "👨🏻\u{200d}❤\u{fe0f}\u{200d}👨🏿", "👨🏻\u{200d}❤\u{200d}👨🏿", "👨🏼\u{200d}❤\u{fe0f}\u{200d}👨🏻", "👨🏼\u{200d}❤\u{200d}👨🏻", "👨🏼\u{200d}❤\u{fe0f}\u{200d}👨🏼", "👨🏼\u{200d}❤\u{200d}👨🏼", "👨🏼\u{200d}❤\u{fe0f}\u{200d}👨🏽", "👨🏼\u{200d}❤\u{200d}👨🏽", "👨🏼\u{200d}❤\u{fe0f}\u{200d}👨🏾", "👨🏼\u{200d}❤\u{200d}👨🏾", "👨🏼\u{200d}❤\u{fe0f}\u{200d}👨🏿", "👨🏼\u{200d}❤\u{200d}👨🏿", "👨🏽\u{200d}❤\u{fe0f}\u{200d}👨🏻", "👨🏽\u{200d}❤\u{200d}👨🏻", "👨🏽\u{200d}❤\u{fe0f}\u{200d}👨🏼", "👨🏽\u{200d}❤\u{200d}👨🏼", "👨🏽\u{200d}❤\u{fe0f}\u{200d}👨🏽", "👨🏽\u{200d}❤\u{200d}👨🏽", "👨🏽\u{200d}❤\u{fe0f}\u{200d}👨🏾", "👨🏽\u{200d}❤\u{200d}👨🏾", "👨🏽\u{200d}❤\u{fe0f}\u{200d}👨🏿", "👨🏽\u{200d}❤\u{200d}👨🏿", "👨🏾\u{200d}❤\u{fe0f}\u{200d}👨🏻", "👨🏾\u{200d}❤\u{200d}👨🏻", "👨🏾\u{200d}❤\u{fe0f}\u{200d}👨🏼", "👨🏾\u{200d}❤\u{200d}👨🏼", "👨🏾\u{200d}❤\u{fe0f}\u{200d}👨🏽", "👨🏾\u{200d}❤\u{200d}👨🏽", "👨🏾\u{200d}❤\u{fe0f}\u{200d}👨🏾", "👨🏾\u{200d}❤\u{200d}👨🏾", "👨🏾\u{200d}❤\u{fe0f}\u{200d}👨🏿", "👨🏾\u{200d}❤\u{200d}👨🏿", "👨🏿\u{200d}❤\u{fe0f}\u{200d}👨🏻", "👨🏿\u{200d}❤\u{200d}👨🏻", "👨🏿\u{200d}❤\u{fe0f}\u{200d}👨🏼", "👨🏿\u{200d}❤\u{200d}👨🏼", "👨🏿\u{200d}❤\u{fe0f}\u{200d}👨🏽", "👨🏿\u{200d}❤\u{200d}👨🏽", "👨🏿\u{200d}❤\u{fe0f}\u{200d}👨🏾", "👨🏿\u{200d}❤\u{200d}👨🏾", "👨🏿\u{200d}❤\u{fe0f}\u{200d}👨🏿", "👨🏿\u{200d}❤\u{200d}👨🏿"] },
    Emoji { id: 1898, emoji: "👩‍❤️‍👩", name: "couple with heart: woman, woman", group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["couple_with_heart_woman_woman"]), variations: &["👩\u{200d}❤\u{200d}👩", "👩🏻\u{200d}❤\u{fe0f}\u{200d}👩🏻", "👩🏻\u{200d}❤\u{200d}👩🏻", "👩🏻\u{200d}❤\u{fe0f}\u{200d}👩🏼", "👩🏻\u{200d}❤\u{200d}👩🏼", "👩🏻\u{200d}❤\u{fe0f}\u{200d}👩🏽", "👩🏻\u{200d}❤\u{200d}👩🏽", "👩🏻\u{200d}❤\u{fe0f}\u{200d}👩🏾", "👩🏻\u{200d}❤\u{200d}👩🏾", "👩🏻\u{200d}❤\u{fe0f}\u{200d}👩🏿", "👩🏻\u{200d}❤\u{200d}👩🏿", "👩🏼\u{200d}❤\u{fe0f}\u{200d}👩🏻", "👩🏼\u{200d}❤\u{200d}👩🏻", "👩🏼\u{200d}❤\u{fe0f}\u{200d}👩🏼", "👩🏼\u{200d}❤\u{200d}👩🏼", "👩🏼\u{200d}❤\u{fe0f}\u{200d}👩🏽", "👩🏼\u{200d}❤\u{200d}👩🏽", "👩🏼\u{200d}❤\u{fe0f}\u{200d}👩🏾", "👩🏼\u{200d}❤\u{200d}👩🏾", "👩🏼\u{200d}❤\u{fe0f}\u{200d}👩🏿", "👩🏼\u{200d}❤\u{200d}👩🏿", "👩🏽\u{200d}❤\u{fe0f}\u{200d}👩🏻", "👩🏽\u{200d}❤\u{200d}👩🏻", "👩🏽\u{200d}❤\u{fe0f}\u{200d}👩🏼", "👩🏽\u{200d}❤\u{200d}👩🏼", "👩🏽\u{200d}❤\u{fe0f}\u{200d}👩🏽", "👩🏽\u{200d}❤\u{200d}👩🏽", "👩🏽\u{200d}❤\u{fe0f}\u{200d}👩🏾", "👩🏽\u{200d}❤\u{200d}👩🏾", "👩🏽\u{200d}❤\u{fe0f}\u{200d}👩🏿", "👩🏽\u{200d}❤\u{200d}👩🏿", "👩🏾\u{200d}❤\u{fe0f}\u{200d}👩🏻", "👩🏾\u{200d}❤\u{200d}👩🏻", "👩🏾\u{200d}❤\u{fe0f}\u{200d}👩🏼", "👩🏾\u{200d}❤\u{200d}👩🏼", "👩🏾\u{200d}❤\u{fe0f}\u{200d}👩🏽", "👩🏾\u{200d}❤\u{200d}👩🏽", "👩🏾\u{200d}❤\u{fe0f}\u{200d}👩🏾", "👩🏾\u{200d}❤\u{200d}👩🏾", "👩🏾\u{200d}❤\u{fe0f}\u{200d}👩🏿", "👩🏾\u{200d}❤\u{200d}👩🏿", "👩🏿\u{200d}❤\u{fe0f}\u{200d}👩🏻", "👩🏿\u{200d}❤\u{200d}👩🏻", "👩🏿\u{200d}❤\u{fe0f}\u{200d}👩🏼", "👩🏿\u{200d}❤\u{200d}👩🏼", "👩🏿\u{200d}❤\u{fe0f}\u{200d}👩🏽", "👩🏿\u{200d}❤\u{200d}👩🏽", "👩🏿\u{200d}❤\u{fe0f}\u{200d}👩🏾", "👩🏿\u{200d}❤\u{200d}👩🏾", "👩🏿\u{200d}❤\u{fe0f}\u{200d}👩🏿", "👩🏿\u{200d}❤\u{200d}👩🏿"] },
    Emoji { id: 1899, emoji: "👪", name: "family", group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["family"]), variations: &[] },
    Emoji { id: 1900, emoji: "👨‍👩‍👦", name: "family: man, woman, boy", group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["family_man_woman_boy"]), variations: &[] },
    Emoji { id: 1901, emoji: "👨‍👩‍👧", name: "family: man, woman, girl", group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["family_man_woman_girl"]), variations: &[] },
    Emoji { id: 1902, emoji: "👨‍👩‍👧‍👦", name: "family: man, woman, girl, boy", group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["family_man_woman_girl_boy"]), variations: &[] },
    Emoji { id: 1903, emoji: "👨‍👩‍👦‍👦", name: "family: man, woman, boy, boy", group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["family_man_woman_boy_boy"]), variations: &[] },
    Emoji { id: 1904, emoji: "👨‍👩‍👧‍👧", name: "family: man, woman, girl, girl", group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["family_man_woman_girl_girl"]), variations: &[] },
    Emoji { id: 1905, emoji: "👨‍👨‍👦", name: "family: man, man, boy", group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["family_man_man_boy"]), variations: &[] },
    Emoji { id: 1906, emoji: "👨‍👨‍👧", name: "family: man, man, girl", group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["family_man_man_girl"]), variations: &[] },
    Emoji { id: 1907, emoji: "👨‍👨‍👧‍👦", name: "family: man, man, girl, boy", group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["family_man_man_girl_boy"]), variations: &[] },
    Emoji { id: 1908, emoji: "👨‍👨‍👦‍👦", name: "family: man, man, boy, boy", group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["family_man_man_boy_boy"]), variations: &[] },
    Emoji { id: 1909, emoji: "👨‍👨‍👧‍👧", name: "family: man, man, girl, girl", group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["family_man_man_girl_girl"]), variations: &[] },
    Emoji { id: 1910, emoji: "👩‍👩‍👦", name: "family: woman, woman, boy", group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["family_woman_woman_boy"]), variations: &[] },
    Emoji { id: 1911, emoji: "👩‍👩‍👧", name: "family: woman, woman, girl", group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["family_woman_woman_girl"]), variations: &[] },
    Emoji { id: 1912, emoji: "👩‍👩‍👧‍👦", name: "family: woman, woman, girl, boy", group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["family_woman_woman_girl_boy"]), variations: &[] },
    Emoji { id: 1913, emoji: "👩‍👩‍👦‍👦", name: "family: woman, woman, boy, boy", group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["family_woman_woman_boy_boy"]), variations: &[] },
    Emoji { id: 1914, emoji: "👩‍👩‍👧‍👧", name: "family: woman, woman, girl, girl", group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["family_woman_woman_girl_girl"]), variations: &[] },
    Emoji { id: 1915, emoji: "👨‍👦", name: "family: man, boy", group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["family_man_boy"]), variations: &[] },
    Emoji { id: 1916, emoji: "👨‍👦‍👦", name: "family: man, boy, boy", group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["family_man_boy_boy"]), variations: &[] },
    Emoji { id: 1917, emoji: "👨‍👧", name: "family: man, girl", group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["family_man_girl"]), variations: &[] },
    Emoji { id: 1918, emoji: "👨‍👧‍👦", name: "family: man, girl, boy", group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["family_man_girl_boy"]), variations: &[] },
    Emoji { id: 1919, emoji: "👨‍👧‍👧", name: "family: man, girl, girl", group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["family_man_girl_girl"]), variations: &[] },
    Emoji { id: 1920, emoji: "👩‍👦", name: "family: woman, boy", group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["family_woman_boy"]), variations: &[] },
    Emoji { id: 1921, emoji: "👩‍👦‍👦", name: "family: woman, boy, boy", group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["family_woman_boy_boy"]), variations: &[] },
    Emoji { id: 1922, emoji: "👩‍👧", name: "family: woman, girl", group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["family_woman_girl"]), variations: &[] },
    Emoji { id: 1923, emoji: "👩‍👧‍👦", name: "family: woman, girl, boy", group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["family_woman_girl_boy"]), variations: &[] },
    Emoji { id: 1924, emoji: "👩‍👧‍👧", name: "family: woman, girl, girl", group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["family_woman_girl_girl"]), variations: &[] },
    Emoji { id: 1925, emoji: "🗣️", name: "speaking head", group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["speaking_head"]), variations: &["🗣"] },
    Emoji { id: 1926, emoji: "👤", name: "bust in silhouette", group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["bust_in_silhouette"]), variations: &[] },
    Emoji { id: 1927, emoji: "👥", name: "busts in silhouette", group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["busts_in_silhouette"]), variations: &[] },
    Emoji { id: 1928, emoji: "🫂", name: "people hugging", group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["people_hugging"]), variations: &[] },
    Emoji { id: 1929, emoji: "👣", name: "footprints", group: Group::PeopleAndBody, skin_tone: None, aliases: Some(&["footprints"]), variations: &[] },
    Emoji { id: 1930, emoji: "🐵", name: "monkey face", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["monkey_face"]), variations: &[] },
    Emoji { id: 1931, emoji: "🐒", name: "monkey", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["monkey"]), variations: &[] },
    Emoji { id: 1932, emoji: "🦍", name: "gorilla", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["gorilla"]), variations: &[] },
    Emoji { id: 1933, emoji: "🦧", name: "orangutan", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["orangutan"]), variations: &[] },
    Emoji { id: 1934, emoji: "🐶", name: "dog face", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["dog"]), variations: &[] },
    Emoji { id: 1935, emoji: "🐕", name: "dog", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["dog2"]), variations: &[] },
    Emoji { id: 1936, emoji: "🦮", name: "guide dog", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["guide_dog"]), variations: &[] },
    Emoji { id: 1937, emoji: "🐕‍🦺", name: "service dog", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["service_dog"]), variations: &[] },
    Emoji { id: 1938, emoji: "🐩", name: "poodle", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["poodle"]), variations: &[] },
    Emoji { id: 1939, emoji: "🐺", name: "wolf", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["wolf"]), variations: &[] },
    Emoji { id: 1940, emoji: "🦊", name: "fox", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["fox_face"]), variations: &[] },
    Emoji { id: 1941, emoji: "🦝", name: "raccoon", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["raccoon"]), variations: &[] },
    Emoji { id: 1942, emoji: "🐱", name: "cat face", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["cat"]), variations: &[] },
    Emoji { id: 1943, emoji: "🐈", name: "cat", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["cat2"]), variations: &[] },
    Emoji { id: 1944, emoji: "🐈‍⬛", name: "black cat", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["black_cat"]), variations: &[] },
    Emoji { id: 1945, emoji: "🦁", name: "lion", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["lion"]), variations: &[] },
    Emoji { id: 1946, emoji: "🐯", name: "tiger face", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["tiger"]), variations: &[] },
    Emoji { id: 1947, emoji: "🐅", name: "tiger", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["tiger2"]), variations: &[] },
    Emoji { id: 1948, emoji: "🐆", name: "leopard", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["leopard"]), variations: &[] },
    Emoji { id: 1949, emoji: "🐴", name: "horse face", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["horse"]), variations: &[] },
    Emoji { id: 1950, emoji: "🐎", name: "horse", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["racehorse"]), variations: &[] },
    Emoji { id: 1951, emoji: "🦄", name: "unicorn", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["unicorn"]), variations: &[] },
    Emoji { id: 1952, emoji: "🦓", name: "zebra", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["zebra"]), variations: &[] },
    Emoji { id: 1953, emoji: "🦌", name: "deer", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["deer"]), variations: &[] },
    Emoji { id: 1954, emoji: "🦬", name: "bison", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["bison"]), variations: &[] },
    Emoji { id: 1955, emoji: "🐮", name: "cow face", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["cow"]), variations: &[] },
    Emoji { id: 1956, emoji: "🐂", name: "ox", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["ox"]), variations: &[] },
    Emoji { id: 1957, emoji: "🐃", name: "water buffalo", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["water_buffalo"]), variations: &[] },
    Emoji { id: 1958, emoji: "🐄", name: "cow", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["cow2"]), variations: &[] },
    Emoji { id: 1959, emoji: "🐷", name: "pig face", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["pig"]), variations: &[] },
    Emoji { id: 1960, emoji: "🐖", name: "pig", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["pig2"]), variations: &[] },
    Emoji { id: 1961, emoji: "🐗", name: "boar", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["boar"]), variations: &[] },
    Emoji { id: 1962, emoji: "🐽", name: "pig nose", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["pig_nose"]), variations: &[] },
    Emoji { id: 1963, emoji: "🐏", name: "ram", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["ram"]), variations: &[] },
    Emoji { id: 1964, emoji: "🐑", name: "ewe", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["sheep"]), variations: &[] },
    Emoji { id: 1965, emoji: "🐐", name: "goat", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["goat"]), variations: &[] },
    Emoji { id: 1966, emoji: "🐪", name: "camel", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["dromedary_camel"]), variations: &[] },
    Emoji { id: 1967, emoji: "🐫", name: "two-hump camel", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["camel"]), variations: &[] },
    Emoji { id: 1968, emoji: "🦙", name: "llama", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["llama"]), variations: &[] },
    Emoji { id: 1969, emoji: "🦒", name: "giraffe", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["giraffe"]), variations: &[] },
    Emoji { id: 1970, emoji: "🐘", name: "elephant", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["elephant"]), variations: &[] },
    Emoji { id: 1971, emoji: "🦣", name: "mammoth", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["mammoth"]), variations: &[] },
    Emoji { id: 1972, emoji: "🦏", name: "rhinoceros", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["rhinoceros"]), variations: &[] },
    Emoji { id: 1973, emoji: "🦛", name: "hippopotamus", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["hippopotamus"]), variations: &[] },
    Emoji { id: 1974, emoji: "🐭", name: "mouse face", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["mouse"]), variations: &[] },
    Emoji { id: 1975, emoji: "🐁", name: "mouse", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["mouse2"]), variations: &[] },
    Emoji { id: 1976, emoji: "🐀", name: "rat", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["rat"]), variations: &[] },
    Emoji { id: 1977, emoji: "🐹", name: "hamster", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["hamster"]), variations: &[] },
    Emoji { id: 1978, emoji: "🐰", name: "rabbit face", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["rabbit"]), variations: &[] },
    Emoji { id: 1979, emoji: "🐇", name: "rabbit", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["rabbit2"]), variations: &[] },
    Emoji { id: 1980, emoji: "🐿️", name: "chipmunk", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["chipmunk"]), variations: &["🐿"] },
    Emoji { id: 1981, emoji: "🦫", name: "beaver", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["beaver"]), variations: &[] },
    Emoji { id: 1982, emoji: "🦔", name: "hedgehog", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["hedgehog"]), variations: &[] },
    Emoji { id: 1983, emoji: "🦇", name: "bat", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["bat"]), variations: &[] },
    Emoji { id: 1984, emoji: "🐻", name: "bear", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["bear"]), variations: &[] },
    Emoji { id: 1985, emoji: "🐻‍❄️", name: "polar bear", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["polar_bear"]), variations: &["🐻\u{200d}❄"] },
    Emoji { id: 1986, emoji: "🐨", name: "koala", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["koala"]), variations: &[] },
    Emoji { id: 1987, emoji: "🐼", name: "panda", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["panda_face"]), variations: &[] },
    Emoji { id: 1988, emoji: "🦥", name: "sloth", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["sloth"]), variations: &[] },
    Emoji { id: 1989, emoji: "🦦", name: "otter", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["otter"]), variations: &[] },
    Emoji { id: 1990, emoji: "🦨", name: "skunk", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["skunk"]), variations: &[] },
    Emoji { id: 1991, emoji: "🦘", name: "kangaroo", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["kangaroo"]), variations: &[] },
    Emoji { id: 1992, emoji: "🦡", name: "badger", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["badger"]), variations: &[] },
    Emoji { id: 1993, emoji: "🐾", name: "paw prints", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["feet", "paw_prints"]), variations: &[] },
    Emoji { id: 1994, emoji: "🦃", name: "turkey", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["turkey"]), variations: &[] },
    Emoji { id: 1995, emoji: "🐔", name: "chicken", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["chicken"]), variations: &[] },
    Emoji { id: 1996, emoji: "🐓", name: "rooster", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["rooster"]), variations: &[] },
    Emoji { id: 1997, emoji: "🐣", name: "hatching chick", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["hatching_chick"]), variations: &[] },
    Emoji { id: 1998, emoji: "🐤", name: "baby chick", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["baby_chick"]), variations: &[] },
    Emoji { id: 1999, emoji: "🐥", name: "front-facing baby chick", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["hatched_chick"]), variations: &[] },
    Emoji { id: 2000, emoji: "🐦", name: "bird", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["bird"]), variations: &[] },
    Emoji { id: 2001, emoji: "🐧", name: "penguin", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["penguin"]), variations: &[] },
    Emoji { id: 2002, emoji: "🕊️", name: "dove", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["dove"]), variations: &["🕊"] },
    Emoji { id: 2003, emoji: "🦅", name: "eagle", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["eagle"]), variations: &[] },
    Emoji { id: 2004, emoji: "🦆", name: "duck", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["duck"]), variations: &[] },
    Emoji { id: 2005, emoji: "🦢", name: "swan", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["swan"]), variations: &[] },
    Emoji { id: 2006, emoji: "🦉", name: "owl", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["owl"]), variations: &[] },
    Emoji { id: 2007, emoji: "🦤", name: "dodo", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["dodo"]), variations: &[] },
    Emoji { id: 2008, emoji: "🪶", name: "feather", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["feather"]), variations: &[] },
    Emoji { id: 2009, emoji: "🦩", name: "flamingo", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["flamingo"]), variations: &[] },
    Emoji { id: 2010, emoji: "🦚", name: "peacock", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["peacock"]), variations: &[] },
    Emoji { id: 2011, emoji: "🦜", name: "parrot", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["parrot"]), variations: &[] },
    Emoji { id: 2012, emoji: "🐸", name: "frog", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["frog"]), variations: &[] },
    Emoji { id: 2013, emoji: "🐊", name: "crocodile", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["crocodile"]), variations: &[] },
    Emoji { id: 2014, emoji: "🐢", name: "turtle", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["turtle"]), variations: &[] },
    Emoji { id: 2015, emoji: "🦎", name: "lizard", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["lizard"]), variations: &[] },
    Emoji { id: 2016, emoji: "🐍", name: "snake", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["snake"]), variations: &[] },
    Emoji { id: 2017, emoji: "🐲", name: "dragon face", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["dragon_face"]), variations: &[] },
    Emoji { id: 2018, emoji: "🐉", name: "dragon", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["dragon"]), variations: &[] },
    Emoji { id: 2019, emoji: "🦕", name: "sauropod", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["sauropod"]), variations: &[] },
    Emoji { id: 2020, emoji: "🦖", name: "T-Rex", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["t-rex"]), variations: &[] },
    Emoji { id: 2021, emoji: "🐳", name: "spouting whale", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["whale"]), variations: &[] },
    Emoji { id: 2022, emoji: "🐋", name: "whale", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["whale2"]), variations: &[] },
    Emoji { id: 2023, emoji: "🐬", name: "dolphin", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["dolphin", "flipper"]), variations: &[] },
    Emoji { id: 2024, emoji: "🦭", name: "seal", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["seal"]), variations: &[] },
    Emoji { id: 2025, emoji: "🐟", name: "fish", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["fish"]), variations: &[] },
    Emoji { id: 2026, emoji: "🐠", name: "tropical fish", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["tropical_fish"]), variations: &[] },
    Emoji { id: 2027, emoji: "🐡", name: "blowfish", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["blowfish"]), variations: &[] },
    Emoji { id: 2028, emoji: "🦈", name: "shark", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["shark"]), variations: &[] },
    Emoji { id: 2029, emoji: "🐙", name: "octopus", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["octopus"]), variations: &[] },
    Emoji { id: 2030, emoji: "🐚", name: "spiral shell", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["shell"]), variations: &[] },
    Emoji { id: 2031, emoji: "🐌", name: "snail", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["snail"]), variations: &[] },
    Emoji { id: 2032, emoji: "🦋", name: "butterfly", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["butterfly"]), variations: &[] },
    Emoji { id: 2033, emoji: "🐛", name: "bug", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["bug"]), variations: &[] },
    Emoji { id: 2034, emoji: "🐜", name: "ant", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["ant"]), variations: &[] },
    Emoji { id: 2035, emoji: "🐝", name: "honeybee", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["bee", "honeybee"]), variations: &[] },
    Emoji { id: 2036, emoji: "🪲", name: "beetle", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["beetle"]), variations: &[] },
    Emoji { id: 2037, emoji: "🐞", name: "lady beetle", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["lady_beetle"]), variations: &[] },
    Emoji { id: 2038, emoji: "🦗", name: "cricket", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["cricket"]), variations: &[] },
    Emoji { id: 2039, emoji: "🪳", name: "cockroach", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["cockroach"]), variations: &[] },
    Emoji { id: 2040, emoji: "🕷️", name: "spider", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["spider"]), variations: &["🕷"] },
    Emoji { id: 2041, emoji: "🕸️", name: "spider web", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["spider_web"]), variations: &["🕸"] },
    Emoji { id: 2042, emoji: "🦂", name: "scorpion", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["scorpion"]), variations: &[] },
    Emoji { id: 2043, emoji: "🦟", name: "mosquito", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["mosquito"]), variations: &[] },
    Emoji { id: 2044, emoji: "🪰", name: "fly", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["fly"]), variations: &[] },
    Emoji { id: 2045, emoji: "🪱", name: "worm", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["worm"]), variations: &[] },
    Emoji { id: 2046, emoji: "🦠", name: "microbe", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["microbe"]), variations: &[] },
    Emoji { id: 2047, emoji: "💐", name: "bouquet", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["bouquet"]), variations: &[] },
    Emoji { id: 2048, emoji: "🌸", name: "cherry blossom", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["cherry_blossom"]), variations: &[] },
    Emoji { id: 2049, emoji: "💮", name: "white flower", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["white_flower"]), variations: &[] },
    Emoji { id: 2050, emoji: "🏵️", name: "rosette", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["rosette"]), variations: &["🏵"] },
    Emoji { id: 2051, emoji: "🌹", name: "rose", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["rose"]), variations: &[] },
    Emoji { id: 2052, emoji: "🥀", name: "wilted flower", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["wilted_flower"]), variations: &[] },
    Emoji { id: 2053, emoji: "🌺", name: "hibiscus", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["hibiscus"]), variations: &[] },
    Emoji { id: 2054, emoji: "🌻", name: "sunflower", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["sunflower"]), variations: &[] },
    Emoji { id: 2055, emoji: "🌼", name: "blossom", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["blossom"]), variations: &[] },
    Emoji { id: 2056, emoji: "🌷", name: "tulip", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["tulip"]), variations: &[] },
    Emoji { id: 2057, emoji: "🌱", name: "seedling", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["seedling"]), variations: &[] },
    Emoji { id: 2058, emoji: "🪴", name: "potted plant", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["potted_plant"]), variations: &[] },
    Emoji { id: 2059, emoji: "🌲", name: "evergreen tree", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["evergreen_tree"]), variations: &[] },
    Emoji { id: 2060, emoji: "🌳", name: "deciduous tree", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["deciduous_tree"]), variations: &[] },
    Emoji { id: 2061, emoji: "🌴", name: "palm tree", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["palm_tree"]), variations: &[] },
    Emoji { id: 2062, emoji: "🌵", name: "cactus", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["cactus"]), variations: &[] },
    Emoji { id: 2063, emoji: "🌾", name: "sheaf of rice", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["ear_of_rice"]), variations: &[] },
    Emoji { id: 2064, emoji: "🌿", name: "herb", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["herb"]), variations: &[] },
    Emoji { id: 2065, emoji: "☘️", name: "shamrock", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["shamrock"]), variations: &["☘"] },
    Emoji { id: 2066, emoji: "🍀", name: "four leaf clover", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["four_leaf_clover"]), variations: &[] },
    Emoji { id: 2067, emoji: "🍁", name: "maple leaf", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["maple_leaf"]), variations: &[] },
    Emoji { id: 2068, emoji: "🍂", name: "fallen leaf", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["fallen_leaf"]), variations: &[] },
    Emoji { id: 2069, emoji: "🍃", name: "leaf fluttering in wind", group: Group::AnimalsAndNature, skin_tone: None, aliases: Some(&["leaves"]), variations: &[] },
    Emoji { id: 2070, emoji: "🍇", name: "grapes", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["grapes"]), variations: &[] },
    Emoji { id: 2071, emoji: "🍈", name: "melon", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["melon"]), variations: &[] },
    Emoji { id: 2072, emoji: "🍉", name: "watermelon", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["watermelon"]), variations: &[] },
    Emoji { id: 2073, emoji: "🍊", name: "tangerine", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["tangerine", "orange", "mandarin"]), variations: &[] },
    Emoji { id: 2074, emoji: "🍋", name: "lemon", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["lemon"]), variations: &[] },
    Emoji { id: 2075, emoji: "🍌", name: "banana", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["banana"]), variations: &[] },
    Emoji { id: 2076, emoji: "🍍", name: "pineapple", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["pineapple"]), variations: &[] },
    Emoji { id: 2077, emoji: "🥭", name: "mango", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["mango"]), variations: &[] },
    Emoji { id: 2078, emoji: "🍎", name: "red apple", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["apple"]), variations: &[] },
    Emoji { id: 2079, emoji: "🍏", name: "green apple", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["green_apple"]), variations: &[] },
    Emoji { id: 2080, emoji: "🍐", name: "pear", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["pear"]), variations: &[] },
    Emoji { id: 2081, emoji: "🍑", name: "peach", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["peach"]), variations: &[] },
    Emoji { id: 2082, emoji: "🍒", name: "cherries", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["cherries"]), variations: &[] },
    Emoji { id: 2083, emoji: "🍓", name: "strawberry", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["strawberry"]), variations: &[] },
    Emoji { id: 2084, emoji: "🫐", name: "blueberries", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["blueberries"]), variations: &[] },
    Emoji { id: 2085, emoji: "🥝", name: "kiwi fruit", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["kiwi_fruit"]), variations: &[] },
    Emoji { id: 2086, emoji: "🍅", name: "tomato", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["tomato"]), variations: &[] },
    Emoji { id: 2087, emoji: "🫒", name: "olive", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["olive"]), variations: &[] },
    Emoji { id: 2088, emoji: "🥥", name: "coconut", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["coconut"]), variations: &[] },
    Emoji { id: 2089, emoji: "🥑", name: "avocado", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["avocado"]), variations: &[] },
    Emoji { id: 2090, emoji: "🍆", name: "eggplant", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["eggplant"]), variations: &[] },
    Emoji { id: 2091, emoji: "🥔", name: "potato", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["potato"]), variations: &[] },
    Emoji { id: 2092, emoji: "🥕", name: "carrot", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["carrot"]), variations: &[] },
    Emoji { id: 2093, emoji: "🌽", name: "ear of corn", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["corn"]), variations: &[] },
    Emoji { id: 2094, emoji: "🌶️", name: "hot pepper", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["hot_pepper"]), variations: &["🌶"] },
    Emoji { id: 2095, emoji: "🫑", name: "bell pepper", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["bell_pepper"]), variations: &[] },
    Emoji { id: 2096, emoji: "🥒", name: "cucumber", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["cucumber"]), variations: &[] },
    Emoji { id: 2097, emoji: "🥬", name: "leafy green", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["leafy_green"]), variations: &[] },
    Emoji { id: 2098, emoji: "🥦", name: "broccoli", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["broccoli"]), variations: &[] },
    Emoji { id: 2099, emoji: "🧄", name: "garlic", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["garlic"]), variations: &[] },
    Emoji { id: 2100, emoji: "🧅", name: "onion", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["onion"]), variations: &[] },
    Emoji { id: 2101, emoji: "🍄", name: "mushroom", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["mushroom"]), variations: &[] },
    Emoji { id: 2102, emoji: "🥜", name: "peanuts", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["peanuts"]), variations: &[] },
    Emoji { id: 2103, emoji: "🌰", name: "chestnut", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["chestnut"]), variations: &[] },
    Emoji { id: 2104, emoji: "🍞", name: "bread", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["bread"]), variations: &[] },
    Emoji { id: 2105, emoji: "🥐", name: "croissant", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["croissant"]), variations: &[] },
    Emoji { id: 2106, emoji: "🥖", name: "baguette bread", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["baguette_bread"]), variations: &[] },
    Emoji { id: 2107, emoji: "🫓", name: "flatbread", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["flatbread"]), variations: &[] },
    Emoji { id: 2108, emoji: "🥨", name: "pretzel", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["pretzel"]), variations: &[] },
    Emoji { id: 2109, emoji: "🥯", name: "bagel", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["bagel"]), variations: &[] },
    Emoji { id: 2110, emoji: "🥞", name: "pancakes", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["pancakes"]), variations: &[] },
    Emoji { id: 2111, emoji: "🧇", name: "waffle", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["waffle"]), variations: &[] },
    Emoji { id: 2112, emoji: "🧀", name: "cheese wedge", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["cheese"]), variations: &[] },
    Emoji { id: 2113, emoji: "🍖", name: "meat on bone", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["meat_on_bone"]), variations: &[] },
    Emoji { id: 2114, emoji: "🍗", name: "poultry leg", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["poultry_leg"]), variations: &[] },
    Emoji { id: 2115, emoji: "🥩", name: "cut of meat", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["cut_of_meat"]), variations: &[] },
    Emoji { id: 2116, emoji: "🥓", name: "bacon", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["bacon"]), variations: &[] },
    Emoji { id: 2117, emoji: "🍔", name: "hamburger", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["hamburger"]), variations: &[] },
    Emoji { id: 2118, emoji: "🍟", name: "french fries", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["fries"]), variations: &[] },
    Emoji { id: 2119, emoji: "🍕", name: "pizza", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["pizza"]), variations: &[] },
    Emoji { id: 2120, emoji: "🌭", name: "hot dog", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["hotdog"]), variations: &[] },
    Emoji { id: 2121, emoji: "🥪", name: "sandwich", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["sandwich"]), variations: &[] },
    Emoji { id: 2122, emoji: "🌮", name: "taco", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["taco"]), variations: &[] },
    Emoji { id: 2123, emoji: "🌯", name: "burrito", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["burrito"]), variations: &[] },
    Emoji { id: 2124, emoji: "🫔", name: "tamale", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["tamale"]), variations: &[] },
    Emoji { id: 2125, emoji: "🥙", name: "stuffed flatbread", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["stuffed_flatbread"]), variations: &[] },
    Emoji { id: 2126, emoji: "🧆", name: "falafel", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["falafel"]), variations: &[] },
    Emoji { id: 2127, emoji: "🥚", name: "egg", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["egg"]), variations: &[] },
    Emoji { id: 2128, emoji: "🍳", name: "cooking", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["fried_egg"]), variations: &[] },
    Emoji { id: 2129, emoji: "🥘", name: "shallow pan of food", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["shallow_pan_of_food"]), variations: &[] },
    Emoji { id: 2130, emoji: "🍲", name: "pot of food", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["stew"]), variations: &[] },
    Emoji { id: 2131, emoji: "🫕", name: "fondue", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["fondue"]), variations: &[] },
    Emoji { id: 2132, emoji: "🥣", name: "bowl with spoon", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["bowl_with_spoon"]), variations: &[] },
    Emoji { id: 2133, emoji: "🥗", name: "green salad", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["green_salad"]), variations: &[] },
    Emoji { id: 2134, emoji: "🍿", name: "popcorn", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["popcorn"]), variations: &[] },
    Emoji { id: 2135, emoji: "🧈", name: "butter", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["butter"]), variations: &[] },
    Emoji { id: 2136, emoji: "🧂", name: "salt", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["salt"]), variations: &[] },
    Emoji { id: 2137, emoji: "🥫", name: "canned food", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["canned_food"]), variations: &[] },
    Emoji { id: 2138, emoji: "🍱", name: "bento box", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["bento"]), variations: &[] },
    Emoji { id: 2139, emoji: "🍘", name: "rice cracker", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["rice_cracker"]), variations: &[] },
    Emoji { id: 2140, emoji: "🍙", name: "rice ball", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["rice_ball"]), variations: &[] },
    Emoji { id: 2141, emoji: "🍚", name: "cooked rice", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["rice"]), variations: &[] },
    Emoji { id: 2142, emoji: "🍛", name: "curry rice", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["curry"]), variations: &[] },
    Emoji { id: 2143, emoji: "🍜", name: "steaming bowl", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["ramen"]), variations: &[] },
    Emoji { id: 2144, emoji: "🍝", name: "spaghetti", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["spaghetti"]), variations: &[] },
    Emoji { id: 2145, emoji: "🍠", name: "roasted sweet potato", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["sweet_potato"]), variations: &[] },
    Emoji { id: 2146, emoji: "🍢", name: "oden", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["oden"]), variations: &[] },
    Emoji { id: 2147, emoji: "🍣", name: "sushi", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["sushi"]), variations: &[] },
    Emoji { id: 2148, emoji: "🍤", name: "fried shrimp", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["fried_shrimp"]), variations: &[] },
    Emoji { id: 2149, emoji: "🍥", name: "fish cake with swirl", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["fish_cake"]), variations: &[] },
    Emoji { id: 2150, emoji: "🥮", name: "moon cake", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["moon_cake"]), variations: &[] },
    Emoji { id: 2151, emoji: "🍡", name: "dango", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["dango"]), variations: &[] },
    Emoji { id: 2152, emoji: "🥟", name: "dumpling", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["dumpling"]), variations: &[] },
    Emoji { id: 2153, emoji: "🥠", name: "fortune cookie", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["fortune_cookie"]), variations: &[] },
    Emoji { id: 2154, emoji: "🥡", name: "takeout box", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["takeout_box"]), variations: &[] },
    Emoji { id: 2155, emoji: "🦀", name: "crab", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["crab"]), variations: &[] },
    Emoji { id: 2156, emoji: "🦞", name: "lobster", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["lobster"]), variations: &[] },
    Emoji { id: 2157, emoji: "🦐", name: "shrimp", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["shrimp"]), variations: &[] },
    Emoji { id: 2158, emoji: "🦑", name: "squid", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["squid"]), variations: &[] },
    Emoji { id: 2159, emoji: "🦪", name: "oyster", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["oyster"]), variations: &[] },
    Emoji { id: 2160, emoji: "🍦", name: "soft ice cream", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["icecream"]), variations: &[] },
    Emoji { id: 2161, emoji: "🍧", name: "shaved ice", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["shaved_ice"]), variations: &[] },
    Emoji { id: 2162, emoji: "🍨", name: "ice cream", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["ice_cream"]), variations: &[] },
    Emoji { id: 2163, emoji: "🍩", name: "doughnut", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["doughnut"]), variations: &[] },
    Emoji { id: 2164, emoji: "🍪", name: "cookie", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["cookie"]), variations: &[] },
    Emoji { id: 2165, emoji: "🎂", name: "birthday cake", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["birthday"]), variations: &[] },
    Emoji { id: 2166, emoji: "🍰", name: "shortcake", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["cake"]), variations: &[] },
    Emoji { id: 2167, emoji: "🧁", name: "cupcake", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["cupcake"]), variations: &[] },
    Emoji { id: 2168, emoji: "🥧", name: "pie", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["pie"]), variations: &[] },
    Emoji { id: 2169, emoji: "🍫", name: "chocolate bar", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["chocolate_bar"]), variations: &[] },
    Emoji { id: 2170, emoji: "🍬", name: "candy", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["candy"]), variations: &[] },
    Emoji { id: 2171, emoji: "🍭", name: "lollipop", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["lollipop"]), variations: &[] },
    Emoji { id: 2172, emoji: "🍮", name: "custard", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["custard"]), variations: &[] },
    Emoji { id: 2173, emoji: "🍯", name: "honey pot", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["honey_pot"]), variations: &[] },
    Emoji { id: 2174, emoji: "🍼", name: "baby bottle", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["baby_bottle"]), variations: &[] },
    Emoji { id: 2175, emoji: "🥛", name: "glass of milk", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["milk_glass"]), variations: &[] },
    Emoji { id: 2176, emoji: "☕", name: "hot beverage", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["coffee"]), variations: &[] },
    Emoji { id: 2177, emoji: "🫖", name: "teapot", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["teapot"]), variations: &[] },
    Emoji { id: 2178, emoji: "🍵", name: "teacup without handle", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["tea"]), variations: &[] },
    Emoji { id: 2179, emoji: "🍶", name: "sake", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["sake"]), variations: &[] },
    Emoji { id: 2180, emoji: "🍾", name: "bottle with popping cork", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["champagne"]), variations: &[] },
    Emoji { id: 2181, emoji: "🍷", name: "wine glass", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["wine_glass"]), variations: &[] },
    Emoji { id: 2182, emoji: "🍸", name: "cocktail glass", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["cocktail"]), variations: &[] },
    Emoji { id: 2183, emoji: "🍹", name: "tropical drink", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["tropical_drink"]), variations: &[] },
    Emoji { id: 2184, emoji: "🍺", name: "beer mug", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["beer"]), variations: &[] },
    Emoji { id: 2185, emoji: "🍻", name: "clinking beer mugs", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["beers"]), variations: &[] },
    Emoji { id: 2186, emoji: "🥂", name: "clinking glasses", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["clinking_glasses"]), variations: &[] },
    Emoji { id: 2187, emoji: "🥃", name: "tumbler glass", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["tumbler_glass"]), variations: &[] },
    Emoji { id: 2188, emoji: "🥤", name: "cup with straw", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["cup_with_straw"]), variations: &[] },
    Emoji { id: 2189, emoji: "🧋", name: "bubble tea", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["bubble_tea"]), variations: &[] },
    Emoji { id: 2190, emoji: "🧃", name: "beverage box", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["beverage_box"]), variations: &[] },
    Emoji { id: 2191, emoji: "🧉", name: "mate", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["mate"]), variations: &[] },
    Emoji { id: 2192, emoji: "🧊", name: "ice", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["ice_cube"]), variations: &[] },
    Emoji { id: 2193, emoji: "🥢", name: "chopsticks", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["chopsticks"]), variations: &[] },
    Emoji { id: 2194, emoji: "🍽️", name: "fork and knife with plate", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["plate_with_cutlery"]), variations: &["🍽"] },
    Emoji { id: 2195, emoji: "🍴", name: "fork and knife", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["fork_and_knife"]), variations: &[] },
    Emoji { id: 2196, emoji: "🥄", name: "spoon", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["spoon"]), variations: &[] },
    Emoji { id: 2197, emoji: "🔪", name: "kitchen knife", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["hocho", "knife"]), variations: &[] },
    Emoji { id: 2198, emoji: "🏺", name: "amphora", group: Group::FoodAndDrink, skin_tone: None, aliases: Some(&["amphora"]), variations: &[] },
    Emoji { id: 2199, emoji: "🌍", name: "globe showing Europe-Africa", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["earth_africa"]), variations: &[] },
    Emoji { id: 2200, emoji: "🌎", name: "globe showing Americas", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["earth_americas"]), variations: &[] },
    Emoji { id: 2201, emoji: "🌏", name: "globe showing Asia-Australia", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["earth_asia"]), variations: &[] },
    Emoji { id: 2202, emoji: "🌐", name: "globe with meridians", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["globe_with_meridians"]), variations: &[] },
    Emoji { id: 2203, emoji: "🗺️", name: "world map", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["world_map"]), variations: &["🗺"] },
    Emoji { id: 2204, emoji: "🗾", name: "map of Japan", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["japan"]), variations: &[] },
    Emoji { id: 2205, emoji: "🧭", name: "compass", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["compass"]), variations: &[] },
    Emoji { id: 2206, emoji: "🏔️", name: "snow-capped mountain", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["mountain_snow"]), variations: &["🏔"] },
    Emoji { id: 2207, emoji: "⛰️", name: "mountain", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["mountain"]), variations: &["⛰"] },
    Emoji { id: 2208, emoji: "🌋", name: "volcano", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["volcano"]), variations: &[] },
    Emoji { id: 2209, emoji: "🗻", name: "mount fuji", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["mount_fuji"]), variations: &[] },
    Emoji { id: 2210, emoji: "🏕️", name: "camping", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["camping"]), variations: &["🏕"] },
    Emoji { id: 2211, emoji: "🏖️", name: "beach with umbrella", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["beach_umbrella"]), variations: &["🏖"] },
    Emoji { id: 2212, emoji: "🏜️", name: "desert", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["desert"]), variations: &["🏜"] },
    Emoji { id: 2213, emoji: "🏝️", name: "desert island", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["desert_island"]), variations: &["🏝"] },
    Emoji { id: 2214, emoji: "🏞️", name: "national park", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["national_park"]), variations: &["🏞"] },
    Emoji { id: 2215, emoji: "🏟️", name: "stadium", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["stadium"]), variations: &["🏟"] },
    Emoji { id: 2216, emoji: "🏛️", name: "classical building", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["classical_building"]), variations: &["🏛"] },
    Emoji { id: 2217, emoji: "🏗️", name: "building construction", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["building_construction"]), variations: &["🏗"] },
    Emoji { id: 2218, emoji: "🧱", name: "brick", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["bricks"]), variations: &[] },
    Emoji { id: 2219, emoji: "🪨", name: "rock", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["rock"]), variations: &[] },
    Emoji { id: 2220, emoji: "🪵", name: "wood", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["wood"]), variations: &[] },
    Emoji { id: 2221, emoji: "🛖", name: "hut", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["hut"]), variations: &[] },
    Emoji { id: 2222, emoji: "🏘️", name: "houses", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["houses"]), variations: &["🏘"] },
    Emoji { id: 2223, emoji: "🏚️", name: "derelict house", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["derelict_house"]), variations: &["🏚"] },
    Emoji { id: 2224, emoji: "🏠", name: "house", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["house"]), variations: &[] },
    Emoji { id: 2225, emoji: "🏡", name: "house with garden", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["house_with_garden"]), variations: &[] },
    Emoji { id: 2226, emoji: "🏢", name: "office building", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["office"]), variations: &[] },
    Emoji { id: 2227, emoji: "🏣", name: "Japanese post office", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["post_office"]), variations: &[] },
    Emoji { id: 2228, emoji: "🏤", name: "post office", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["european_post_office"]), variations: &[] },
    Emoji { id: 2229, emoji: "🏥", name: "hospital", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["hospital"]), variations: &[] },
    Emoji { id: 2230, emoji: "🏦", name: "bank", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["bank"]), variations: &[] },
    Emoji { id: 2231, emoji: "🏨", name: "hotel", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["hotel"]), variations: &[] },
    Emoji { id: 2232, emoji: "🏩", name: "love hotel", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["love_hotel"]), variations: &[] },
    Emoji { id: 2233, emoji: "🏪", name: "convenience store", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["convenience_store"]), variations: &[] },
    Emoji { id: 2234, emoji: "🏫", name: "school", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["school"]), variations: &[] },
    Emoji { id: 2235, emoji: "🏬", name: "department store", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["department_store"]), variations: &[] },
    Emoji { id: 2236, emoji: "🏭", name: "factory", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["factory"]), variations: &[] },
    Emoji { id: 2237, emoji: "🏯", name: "Japanese castle", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["japanese_castle"]), variations: &[] },
    Emoji { id: 2238, emoji: "🏰", name: "castle", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["european_castle"]), variations: &[] },
    Emoji { id: 2239, emoji: "💒", name: "wedding", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["wedding"]), variations: &[] },
    Emoji { id: 2240, emoji: "🗼", name: "Tokyo tower", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["tokyo_tower"]), variations: &[] },
    Emoji { id: 2241, emoji: "🗽", name: "Statue of Liberty", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["statue_of_liberty"]), variations: &[] },
    Emoji { id: 2242, emoji: "⛪", name: "church", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["church"]), variations: &[] },
    Emoji { id: 2243, emoji: "🕌", name: "mosque", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["mosque"]), variations: &[] },
    Emoji { id: 2244, emoji: "🛕", name: "hindu temple", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["hindu_temple"]), variations: &[] },
    Emoji { id: 2245, emoji: "🕍", name: "synagogue", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["synagogue"]), variations: &[] },
    Emoji { id: 2246, emoji: "⛩️", name: "shinto shrine", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["shinto_shrine"]), variations: &["⛩"] },
    Emoji { id: 2247, emoji: "🕋", name: "kaaba", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["kaaba"]), variations: &[] },
    Emoji { id: 2248, emoji: "⛲", name: "fountain", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["fountain"]), variations: &[] },
    Emoji { id: 2249, emoji: "⛺", name: "tent", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["tent"]), variations: &[] },
    Emoji { id: 2250, emoji: "🌁", name: "foggy", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["foggy"]), variations: &[] },
    Emoji { id: 2251, emoji: "🌃", name: "night with stars", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["night_with_stars"]), variations: &[] },
    Emoji { id: 2252, emoji: "🏙️", name: "cityscape", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["cityscape"]), variations: &["🏙"] },
    Emoji { id: 2253, emoji: "🌄", name: "sunrise over mountains", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["sunrise_over_mountains"]), variations: &[] },
    Emoji { id: 2254, emoji: "🌅", name: "sunrise", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["sunrise"]), variations: &[] },
    Emoji { id: 2255, emoji: "🌆", name: "cityscape at dusk", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["city_sunset"]), variations: &[] },
    Emoji { id: 2256, emoji: "🌇", name: "sunset", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["city_sunrise"]), variations: &[] },
    Emoji { id: 2257, emoji: "🌉", name: "bridge at night", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["bridge_at_night"]), variations: &[] },
    Emoji { id: 2258, emoji: "♨️", name: "hot springs", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["hotsprings"]), variations: &["♨"] },
    Emoji { id: 2259, emoji: "🎠", name: "carousel horse", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["carousel_horse"]), variations: &[] },
    Emoji { id: 2260, emoji: "🎡", name: "ferris wheel", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["ferris_wheel"]), variations: &[] },
    Emoji { id: 2261, emoji: "🎢", name: "roller coaster", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["roller_coaster"]), variations: &[] },
    Emoji { id: 2262, emoji: "💈", name: "barber pole", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["barber"]), variations: &[] },
    Emoji { id: 2263, emoji: "🎪", name: "circus tent", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["circus_tent"]), variations: &[] },
    Emoji { id: 2264, emoji: "🚂", name: "locomotive", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["steam_locomotive"]), variations: &[] },
    Emoji { id: 2265, emoji: "🚃", name: "railway car", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["railway_car"]), variations: &[] },
    Emoji { id: 2266, emoji: "🚄", name: "high-speed train", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["bullettrain_side"]), variations: &[] },
    Emoji { id: 2267, emoji: "🚅", name: "bullet train", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["bullettrain_front"]), variations: &[] },
    Emoji { id: 2268, emoji: "🚆", name: "train", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["train2"]), variations: &[] },
    Emoji { id: 2269, emoji: "🚇", name: "metro", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["metro"]), variations: &[] },
    Emoji { id: 2270, emoji: "🚈", name: "light rail", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["light_rail"]), variations: &[] },
    Emoji { id: 2271, emoji: "🚉", name: "station", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["station"]), variations: &[] },
    Emoji { id: 2272, emoji: "🚊", name: "tram", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["tram"]), variations: &[] },
    Emoji { id: 2273, emoji: "🚝", name: "monorail", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["monorail"]), variations: &[] },
    Emoji { id: 2274, emoji: "🚞", name: "mountain railway", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["mountain_railway"]), variations: &[] },
    Emoji { id: 2275, emoji: "🚋", name: "tram car", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["train"]), variations: &[] },
    Emoji { id: 2276, emoji: "🚌", name: "bus", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["bus"]), variations: &[] },
    Emoji { id: 2277, emoji: "🚍", name: "oncoming bus", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["oncoming_bus"]), variations: &[] },
    Emoji { id: 2278, emoji: "🚎", name: "trolleybus", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["trolleybus"]), variations: &[] },
    Emoji { id: 2279, emoji: "🚐", name: "minibus", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["minibus"]), variations: &[] },
    Emoji { id: 2280, emoji: "🚑", name: "ambulance", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["ambulance"]), variations: &[] },
    Emoji { id: 2281, emoji: "🚒", name: "fire engine", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["fire_engine"]), variations: &[] },
    Emoji { id: 2282, emoji: "🚓", name: "police car", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["police_car"]), variations: &[] },
    Emoji { id: 2283, emoji: "🚔", name: "oncoming police car", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["oncoming_police_car"]), variations: &[] },
    Emoji { id: 2284, emoji: "🚕", name: "taxi", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["taxi"]), variations: &[] },
    Emoji { id: 2285, emoji: "🚖", name: "oncoming taxi", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["oncoming_taxi"]), variations: &[] },
    Emoji { id: 2286, emoji: "🚗", name: "automobile", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["car", "red_car"]), variations: &[] },
    Emoji { id: 2287, emoji: "🚘", name: "oncoming automobile", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["oncoming_automobile"]), variations: &[] },
    Emoji { id: 2288, emoji: "🚙", name: "sport utility vehicle", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["blue_car"]), variations: &[] },
    Emoji { id: 2289, emoji: "🛻", name: "pickup truck", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["pickup_truck"]), variations: &[] },
    Emoji { id: 2290, emoji: "🚚", name: "delivery truck", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["truck"]), variations: &[] },
    Emoji { id: 2291, emoji: "🚛", name: "articulated lorry", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["articulated_lorry"]), variations: &[] },
    Emoji { id: 2292, emoji: "🚜", name: "tractor", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["tractor"]), variations: &[] },
    Emoji { id: 2293, emoji: "🏎️", name: "racing car", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["racing_car"]), variations: &["🏎"] },
    Emoji { id: 2294, emoji: "🏍️", name: "motorcycle", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["motorcycle"]), variations: &["🏍"] },
    Emoji { id: 2295, emoji: "🛵", name: "motor scooter", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["motor_scooter"]), variations: &[] },
    Emoji { id: 2296, emoji: "🦽", name: "manual wheelchair", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["manual_wheelchair"]), variations: &[] },
    Emoji { id: 2297, emoji: "🦼", name: "motorized wheelchair", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["motorized_wheelchair"]), variations: &[] },
    Emoji { id: 2298, emoji: "🛺", name: "auto rickshaw", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["auto_rickshaw"]), variations: &[] },
    Emoji { id: 2299, emoji: "🚲", name: "bicycle", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["bike"]), variations: &[] },
    Emoji { id: 2300, emoji: "🛴", name: "kick scooter", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["kick_scooter"]), variations: &[] },
    Emoji { id: 2301, emoji: "🛹", name: "skateboard", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["skateboard"]), variations: &[] },
    Emoji { id: 2302, emoji: "🛼", name: "roller skate", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["roller_skate"]), variations: &[] },
    Emoji { id: 2303, emoji: "🚏", name: "bus stop", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["busstop"]), variations: &[] },
    Emoji { id: 2304, emoji: "🛣️", name: "motorway", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["motorway"]), variations: &["🛣"] },
    Emoji { id: 2305, emoji: "🛤️", name: "railway track", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["railway_track"]), variations: &["🛤"] },
    Emoji { id: 2306, emoji: "🛢️", name: "oil drum", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["oil_drum"]), variations: &["🛢"] },
    Emoji { id: 2307, emoji: "⛽", name: "fuel pump", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["fuelpump"]), variations: &[] },
    Emoji { id: 2308, emoji: "🚨", name: "police car light", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["rotating_light"]), variations: &[] },
    Emoji { id: 2309, emoji: "🚥", name: "horizontal traffic light", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["traffic_light"]), variations: &[] },
    Emoji { id: 2310, emoji: "🚦", name: "vertical traffic light", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["vertical_traffic_light"]), variations: &[] },
    Emoji { id: 2311, emoji: "🛑", name: "stop sign", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["stop_sign"]), variations: &[] },
    Emoji { id: 2312, emoji: "🚧", name: "construction", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["construction"]), variations: &[] },
    Emoji { id: 2313, emoji: "⚓", name: "anchor", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["anchor"]), variations: &[] },
    Emoji { id: 2314, emoji: "⛵", name: "sailboat", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["boat", "sailboat"]), variations: &[] },
    Emoji { id: 2315, emoji: "🛶", name: "canoe", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["canoe"]), variations: &[] },
    Emoji { id: 2316, emoji: "🚤", name: "speedboat", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["speedboat"]), variations: &[] },
    Emoji { id: 2317, emoji: "🛳️", name: "passenger ship", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["passenger_ship"]), variations: &["🛳"] },
    Emoji { id: 2318, emoji: "⛴️", name: "ferry", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["ferry"]), variations: &["⛴"] },
    Emoji { id: 2319, emoji: "🛥️", name: "motor boat", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["motor_boat"]), variations: &["🛥"] },
    Emoji { id: 2320, emoji: "🚢", name: "ship", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["ship"]), variations: &[] },
    Emoji { id: 2321, emoji: "✈️", name: "airplane", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["airplane"]), variations: &["✈"] },
    Emoji { id: 2322, emoji: "🛩️", name: "small airplane", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["small_airplane"]), variations: &["🛩"] },
    Emoji { id: 2323, emoji: "🛫", name: "airplane departure", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["flight_departure"]), variations: &[] },
    Emoji { id: 2324, emoji: "🛬", name: "airplane arrival", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["flight_arrival"]), variations: &[] },
    Emoji { id: 2325, emoji: "🪂", name: "parachute", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["parachute"]), variations: &[] },
    Emoji { id: 2326, emoji: "💺", name: "seat", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["seat"]), variations: &[] },
    Emoji { id: 2327, emoji: "🚁", name: "helicopter", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["helicopter"]), variations: &[] },
    Emoji { id: 2328, emoji: "🚟", name: "suspension railway", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["suspension_railway"]), variations: &[] },
    Emoji { id: 2329, emoji: "🚠", name: "mountain cableway", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["mountain_cableway"]), variations: &[] },
    Emoji { id: 2330, emoji: "🚡", name: "aerial tramway", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["aerial_tramway"]), variations: &[] },
    Emoji { id: 2331, emoji: "🛰️", name: "satellite", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["artificial_satellite"]), variations: &["🛰"] },
    Emoji { id: 2332, emoji: "🚀", name: "rocket", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["rocket"]), variations: &[] },
    Emoji { id: 2333, emoji: "🛸", name: "flying saucer", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["flying_saucer"]), variations: &[] },
    Emoji { id: 2334, emoji: "🛎️", name: "bellhop bell", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["bellhop_bell"]), variations: &["🛎"] },
    Emoji { id: 2335, emoji: "🧳", name: "luggage", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["luggage"]), variations: &[] },
    Emoji { id: 2336, emoji: "⌛", name: "hourglass done", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["hourglass"]), variations: &[] },
    Emoji { id: 2337, emoji: "⏳", name: "hourglass not done", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["hourglass_flowing_sand"]), variations: &[] },
    Emoji { id: 2338, emoji: "⌚", name: "watch", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["watch"]), variations: &[] },
    Emoji { id: 2339, emoji: "⏰", name: "alarm clock", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["alarm_clock"]), variations: &[] },
    Emoji { id: 2340, emoji: "⏱️", name: "stopwatch", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["stopwatch"]), variations: &["⏱"] },
    Emoji { id: 2341, emoji: "⏲️", name: "timer clock", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["timer_clock"]), variations: &["⏲"] },
    Emoji { id: 2342, emoji: "🕰️", name: "mantelpiece clock", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["mantelpiece_clock"]), variations: &["🕰"] },
    Emoji { id: 2343, emoji: "🕛", name: "twelve o’clock", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["clock12"]), variations: &[] },
    Emoji { id: 2344, emoji: "🕧", name: "twelve-thirty", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["clock1230"]), variations: &[] },
    Emoji { id: 2345, emoji: "🕐", name: "one o’clock", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["clock1"]), variations: &[] },
    Emoji { id: 2346, emoji: "🕜", name: "one-thirty", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["clock130"]), variations: &[] },
    Emoji { id: 2347, emoji: "🕑", name: "two o’clock", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["clock2"]), variations: &[] },
    Emoji { id: 2348, emoji: "🕝", name: "two-thirty", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["clock230"]), variations: &[] },
    Emoji { id: 2349, emoji: "🕒", name: "three o’clock", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["clock3"]), variations: &[] },
    Emoji { id: 2350, emoji: "🕞", name: "three-thirty", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["clock330"]), variations: &[] },
    Emoji { id: 2351, emoji: "🕓", name: "four o’clock", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["clock4"]), variations: &[] },
    Emoji { id: 2352, emoji: "🕟", name: "four-thirty", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["clock430"]), variations: &[] },
    Emoji { id: 2353, emoji: "🕔", name: "five o’clock", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["clock5"]), variations: &[] },
    Emoji { id: 2354, emoji: "🕠", name: "five-thirty", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["clock530"]), variations: &[] },
    Emoji { id: 2355, emoji: "🕕", name: "six o’clock", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["clock6"]), variations: &[] },
    Emoji { id: 2356, emoji: "🕡", name: "six-thirty", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["clock630"]), variations: &[] },
    Emoji { id: 2357, emoji: "🕖", name: "seven o’clock", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["clock7"]), variations: &[] },
    Emoji { id: 2358, emoji: "🕢", name: "seven-thirty", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["clock730"]), variations: &[] },
    Emoji { id: 2359, emoji: "🕗", name: "eight o’clock", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["clock8"]), variations: &[] },
    Emoji { id: 2360, emoji: "🕣", name: "eight-thirty", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["clock830"]), variations: &[] },
    Emoji { id: 2361, emoji: "🕘", name: "nine o’clock", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["clock9"]), variations: &[] },
    Emoji { id: 2362, emoji: "🕤", name: "nine-thirty", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["clock930"]), variations: &[] },
    Emoji { id: 2363, emoji: "🕙", name: "ten o’clock", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["clock10"]), variations: &[] },
    Emoji { id: 2364, emoji: "🕥", name: "ten-thirty", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["clock1030"]), variations: &[] },
    Emoji { id: 2365, emoji: "🕚", name: "eleven o’clock", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["clock11"]), variations: &[] },
    Emoji { id: 2366, emoji: "🕦", name: "eleven-thirty", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["clock1130"]), variations: &[] },
    Emoji { id: 2367, emoji: "🌑", name: "new moon", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["new_moon"]), variations: &[] },
    Emoji { id: 2368, emoji: "🌒", name: "waxing crescent moon", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["waxing_crescent_moon"]), variations: &[] },
    Emoji { id: 2369, emoji: "🌓", name: "first quarter moon", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["first_quarter_moon"]), variations: &[] },
    Emoji { id: 2370, emoji: "🌔", name: "waxing gibbous moon", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["moon", "waxing_gibbous_moon"]), variations: &[] },
    Emoji { id: 2371, emoji: "🌕", name: "full moon", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["full_moon"]), variations: &[] },
    Emoji { id: 2372, emoji: "🌖", name: "waning gibbous moon", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["waning_gibbous_moon"]), variations: &[] },
    Emoji { id: 2373, emoji: "🌗", name: "last quarter moon", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["last_quarter_moon"]), variations: &[] },
    Emoji { id: 2374, emoji: "🌘", name: "waning crescent moon", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["waning_crescent_moon"]), variations: &[] },
    Emoji { id: 2375, emoji: "🌙", name: "crescent moon", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["crescent_moon"]), variations: &[] },
    Emoji { id: 2376, emoji: "🌚", name: "new moon face", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["new_moon_with_face"]), variations: &[] },
    Emoji { id: 2377, emoji: "🌛", name: "first quarter moon face", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["first_quarter_moon_with_face"]), variations: &[] },
    Emoji { id: 2378, emoji: "🌜", name: "last quarter moon face", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["last_quarter_moon_with_face"]), variations: &[] },
    Emoji { id: 2379, emoji: "🌡️", name: "thermometer", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["thermometer"]), variations: &["🌡"] },
    Emoji { id: 2380, emoji: "☀️", name: "sun", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["sunny"]), variations: &["☀"] },
    Emoji { id: 2381, emoji: "🌝", name: "full moon face", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["full_moon_with_face"]), variations: &[] },
    Emoji { id: 2382, emoji: "🌞", name: "sun with face", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["sun_with_face"]), variations: &[] },
    Emoji { id: 2383, emoji: "🪐", name: "ringed planet", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["ringed_planet"]), variations: &[] },
    Emoji { id: 2384, emoji: "⭐", name: "star", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["star"]), variations: &[] },
    Emoji { id: 2385, emoji: "🌟", name: "glowing star", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["star2"]), variations: &[] },
    Emoji { id: 2386, emoji: "🌠", name: "shooting star", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["stars"]), variations: &[] },
    Emoji { id: 2387, emoji: "🌌", name: "milky way", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["milky_way"]), variations: &[] },
    Emoji { id: 2388, emoji: "☁️", name: "cloud", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["cloud"]), variations: &["☁"] },
    Emoji { id: 2389, emoji: "⛅", name: "sun behind cloud", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["partly_sunny"]), variations: &[] },
    Emoji { id: 2390, emoji: "⛈️", name: "cloud with lightning and rain", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["cloud_with_lightning_and_rain"]), variations: &["⛈"] },
    Emoji { id: 2391, emoji: "🌤️", name: "sun behind small cloud", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["sun_behind_small_cloud"]), variations: &["🌤"] },
    Emoji { id: 2392, emoji: "🌥️", name: "sun behind large cloud", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["sun_behind_large_cloud"]), variations: &["🌥"] },
    Emoji { id: 2393, emoji: "🌦️", name: "sun behind rain cloud", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["sun_behind_rain_cloud"]), variations: &["🌦"] },
    Emoji { id: 2394, emoji: "🌧️", name: "cloud with rain", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["cloud_with_rain"]), variations: &["🌧"] },
    Emoji { id: 2395, emoji: "🌨️", name: "cloud with snow", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["cloud_with_snow"]), variations: &["🌨"] },
    Emoji { id: 2396, emoji: "🌩️", name: "cloud with lightning", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["cloud_with_lightning"]), variations: &["🌩"] },
    Emoji { id: 2397, emoji: "🌪️", name: "tornado", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["tornado"]), variations: &["🌪"] },
    Emoji { id: 2398, emoji: "🌫️", name: "fog", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["fog"]), variations: &["🌫"] },
    Emoji { id: 2399, emoji: "🌬️", name: "wind face", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["wind_face"]), variations: &["🌬"] },
    Emoji { id: 2400, emoji: "🌀", name: "cyclone", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["cyclone"]), variations: &[] },
    Emoji { id: 2401, emoji: "🌈", name: "rainbow", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["rainbow"]), variations: &[] },
    Emoji { id: 2402, emoji: "🌂", name: "closed umbrella", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["closed_umbrella"]), variations: &[] },
    Emoji { id: 2403, emoji: "☂️", name: "umbrella", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["open_umbrella"]), variations: &["☂"] },
    Emoji { id: 2404, emoji: "☔", name: "umbrella with rain drops", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["umbrella"]), variations: &[] },
    Emoji { id: 2405, emoji: "⛱️", name: "umbrella on ground", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["parasol_on_ground"]), variations: &["⛱"] },
    Emoji { id: 2406, emoji: "⚡", name: "high voltage", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["zap"]), variations: &[] },
    Emoji { id: 2407, emoji: "❄️", name: "snowflake", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["snowflake"]), variations: &["❄"] },
    Emoji { id: 2408, emoji: "☃️", name: "snowman", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["snowman_with_snow"]), variations: &["☃"] },
    Emoji { id: 2409, emoji: "⛄", name: "snowman without snow", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["snowman"]), variations: &[] },
    Emoji { id: 2410, emoji: "☄️", name: "comet", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["comet"]), variations: &["☄"] },
    Emoji { id: 2411, emoji: "🔥", name: "fire", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["fire"]), variations: &[] },
    Emoji { id: 2412, emoji: "💧", name: "droplet", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["droplet"]), variations: &[] },
    Emoji { id: 2413, emoji: "🌊", name: "water wave", group: Group::TravelAndPlaces, skin_tone: None, aliases: Some(&["ocean"]), variations: &[] },
    Emoji { id: 2414, emoji: "🎃", name: "jack-o-lantern", group: Group::Activities, skin_tone: None, aliases: Some(&["jack_o_lantern"]), variations: &[] },
    Emoji { id: 2415, emoji: "🎄", name: "Christmas tree", group: Group::Activities, skin_tone: None, aliases: Some(&["christmas_tree"]), variations: &[] },
    Emoji { id: 2416, emoji: "🎆", name: "fireworks", group: Group::Activities, skin_tone: None, aliases: Some(&["fireworks"]), variations: &[] },
    Emoji { id: 2417, emoji: "🎇", name: "sparkler", group: Group::Activities, skin_tone: None, aliases: Some(&["sparkler"]), variations: &[] },
    Emoji { id: 2418, emoji: "🧨", name: "firecracker", group: Group::Activities, skin_tone: None, aliases: Some(&["firecracker"]), variations: &[] },
    Emoji { id: 2419, emoji: "✨", name: "sparkles", group: Group::Activities, skin_tone: None, aliases: Some(&["sparkles"]), variations: &[] },
    Emoji { id: 2420, emoji: "🎈", name: "balloon", group: Group::Activities, skin_tone: None, aliases: Some(&["balloon"]), variations: &[] },
    Emoji { id: 2421, emoji: "🎉", name: "party popper", group: Group::Activities, skin_tone: None, aliases: Some(&["tada"]), variations: &[] },
    Emoji { id: 2422, emoji: "🎊", name: "confetti ball", group: Group::Activities, skin_tone: None, aliases: Some(&["confetti_ball"]), variations: &[] },
    Emoji { id: 2423, emoji: "🎋", name: "tanabata tree", group: Group::Activities, skin_tone: None, aliases: Some(&["tanabata_tree"]), variations: &[] },
    Emoji { id: 2424, emoji: "🎍", name: "pine decoration", group: Group::Activities, skin_tone: None, aliases: Some(&["bamboo"]), variations: &[] },
    Emoji { id: 2425, emoji: "🎎", name: "Japanese dolls", group: Group::Activities, skin_tone: None, aliases: Some(&["dolls"]), variations: &[] },
    Emoji { id: 2426, emoji: "🎏", name: "carp streamer", group: Group::Activities, skin_tone: None, aliases: Some(&["flags"]), variations: &[] },
    Emoji { id: 2427, emoji: "🎐", name: "wind chime", group: Group::Activities, skin_tone: None, aliases: Some(&["wind_chime"]), variations: &[] },
    Emoji { id: 2428, emoji: "🎑", name: "moon viewing ceremony", group: Group::Activities, skin_tone: None, aliases: Some(&["rice_scene"]), variations: &[] },
    Emoji { id: 2429, emoji: "🧧", name: "red envelope", group: Group::Activities, skin_tone: None, aliases: Some(&["red_envelope"]), variations: &[] },
    Emoji { id: 2430, emoji: "🎀", name: "ribbon", group: Group::Activities, skin_tone: None, aliases: Some(&["ribbon"]), variations: &[] },
    Emoji { id: 2431, emoji: "🎁", name: "wrapped gift", group: Group::Activities, skin_tone: None, aliases: Some(&["gift"]), variations: &[] },
    Emoji { id: 2432, emoji: "🎗️", name: "reminder ribbon", group: Group::Activities, skin_tone: None, aliases: Some(&["reminder_ribbon"]), variations: &["🎗"] },
    Emoji { id: 2433, emoji: "🎟️", name: "admission tickets", group: Group::Activities, skin_tone: None, aliases: Some(&["tickets"]), variations: &["🎟"] },
    Emoji { id: 2434, emoji: "🎫", name: "ticket", group: Group::Activities, skin_tone: None, aliases: Some(&["ticket"]), variations: &[] },
    Emoji { id: 2435, emoji: "🎖️", name: "military medal", group: Group::Activities, skin_tone: None, aliases: Some(&["medal_military"]), variations: &["🎖"] },
    Emoji { id: 2436, emoji: "🏆", name: "trophy", group: Group::Activities, skin_tone: None, aliases: Some(&["trophy"]), variations: &[] },
    Emoji { id: 2437, emoji: "🏅", name: "sports medal", group: Group::Activities, skin_tone: None, aliases: Some(&["medal_sports"]), variations: &[] },
    Emoji { id: 2438, emoji: "🥇", name: "1st place medal", group: Group::Activities, skin_tone: None, aliases: Some(&["1st_place_medal"]), variations: &[] },
    Emoji { id: 2439, emoji: "🥈", name: "2nd place medal", group: Group::Activities, skin_tone: None, aliases: Some(&["2nd_place_medal"]), variations: &[] },
    Emoji { id: 2440, emoji: "🥉", name: "3rd place medal", group: Group::Activities, skin_tone: None, aliases: Some(&["3rd_place_medal"]), variations: &[] },
    Emoji { id: 2441, emoji: "⚽", name: "soccer ball", group: Group::Activities, skin_tone: None, aliases: Some(&["soccer"]), variations: &[] },
    Emoji { id: 2442, emoji: "⚾", name: "baseball", group: Group::Activities, skin_tone: None, aliases: Some(&["baseball"]), variations: &[] },
    Emoji { id: 2443, emoji: "🥎", name: "softball", group: Group::Activities, skin_tone: None, aliases: Some(&["softball"]), variations: &[] },
    Emoji { id: 2444, emoji: "🏀", name: "basketball", group: Group::Activities, skin_tone: None, aliases: Some(&["basketball"]), variations: &[] },
    Emoji { id: 2445, emoji: "🏐", name: "volleyball", group: Group::Activities, skin_tone: None, aliases: Some(&["volleyball"]), variations: &[] },
    Emoji { id: 2446, emoji: "🏈", name: "american football", group: Group::Activities, skin_tone: None, aliases: Some(&["football"]), variations: &[] },
    Emoji { id: 2447, emoji: "🏉", name: "rugby football", group: Group::Activities, skin_tone: None, aliases: Some(&["rugby_football"]), variations: &[] },
    Emoji { id: 2448, emoji: "🎾", name: "tennis", group: Group::Activities, skin_tone: None, aliases: Some(&["tennis"]), variations: &[] },
    Emoji { id: 2449, emoji: "🥏", name: "flying disc", group: Group::Activities, skin_tone: None, aliases: Some(&["flying_disc"]), variations: &[] },
    Emoji { id: 2450, emoji: "🎳", name: "bowling", group: Group::Activities, skin_tone: None, aliases: Some(&["bowling"]), variations: &[] },
    Emoji { id: 2451, emoji: "🏏", name: "cricket game", group: Group::Activities, skin_tone: None, aliases: Some(&["cricket_game"]), variations: &[] },
    Emoji { id: 2452, emoji: "🏑", name: "field hockey", group: Group::Activities, skin_tone: None, aliases: Some(&["field_hockey"]), variations: &[] },
    Emoji { id: 2453, emoji: "🏒", name: "ice hockey", group: Group::Activities, skin_tone: None, aliases: Some(&["ice_hockey"]), variations: &[] },
    Emoji { id: 2454, emoji: "🥍", name: "lacrosse", group: Group::Activities, skin_tone: None, aliases: Some(&["lacrosse"]), variations: &[] },
    Emoji { id: 2455, emoji: "🏓", name: "ping pong", group: Group::Activities, skin_tone: None, aliases: Some(&["ping_pong"]), variations: &[] },
    Emoji { id: 2456, emoji: "🏸", name: "badminton", group: Group::Activities, skin_tone: None, aliases: Some(&["badminton"]), variations: &[] },
    Emoji { id: 2457, emoji: "🥊", name: "boxing glove", group: Group::Activities, skin_tone: None, aliases: Some(&["boxing_glove"]), variations: &[] },
    Emoji { id: 2458, emoji: "🥋", name: "martial arts uniform", group: Group::Activities, skin_tone: None, aliases: Some(&["martial_arts_uniform"]), variations: &[] },
    Emoji { id: 2459, emoji: "🥅", name: "goal net", group: Group::Activities, skin_tone: None, aliases: Some(&["goal_net"]), variations: &[] },
    Emoji { id: 2460, emoji: "⛳", name: "flag in hole", group: Group::Activities, skin_tone: None, aliases: Some(&["golf"]), variations: &[] },
    Emoji { id: 2461, emoji: "⛸️", name: "ice skate", group: Group::Activities, skin_tone: None, aliases: Some(&["ice_skate"]), variations: &["⛸"] },
    Emoji { id: 2462, emoji: "🎣", name: "fishing pole", group: Group::Activities, skin_tone: None, aliases: Some(&["fishing_pole_and_fish"]), variations: &[] },
    Emoji { id: 2463, emoji: "🤿", name: "diving mask", group: Group::Activities, skin_tone: None, aliases: Some(&["diving_mask"]), variations: &[] },
    Emoji { id: 2464, emoji: "🎽", name: "running shirt", group: Group::Activities, skin_tone: None, aliases: Some(&["running_shirt_with_sash"]), variations: &[] },
    Emoji { id: 2465, emoji: "🎿", name: "skis", group: Group::Activities, skin_tone: None, aliases: Some(&["ski"]), variations: &[] },
    Emoji { id: 2466, emoji: "🛷", name: "sled", group: Group::Activities, skin_tone: None, aliases: Some(&["sled"]), variations: &[] },
    Emoji { id: 2467, emoji: "🥌", name: "curling stone", group: Group::Activities, skin_tone: None, aliases: Some(&["curling_stone"]), variations: &[] },
    Emoji { id: 2468, emoji: "🎯", name: "bullseye", group: Group::Activities, skin_tone: None, aliases: Some(&["dart"]), variations: &[] },
    Emoji { id: 2469, emoji: "🪀", name: "yo-yo", group: Group::Activities, skin_tone: None, aliases: Some(&["yo_yo"]), variations: &[] },
    Emoji { id: 2470, emoji: "🪁", name: "kite", group: Group::Activities, skin_tone: None, aliases: Some(&["kite"]), variations: &[] },
    Emoji { id: 2471, emoji: "🎱", name: "pool 8 ball", group: Group::Activities, skin_tone: None, aliases: Some(&["8ball"]), variations: &[] },
    Emoji { id: 2472, emoji: "🔮", name: "crystal ball", group: Group::Activities, skin_tone: None, aliases: Some(&["crystal_ball"]), variations: &[] },
    Emoji { id: 2473, emoji: "🪄", name: "magic wand", group: Group::Activities, skin_tone: None, aliases: Some(&["magic_wand"]), variations: &[] },
    Emoji { id: 2474, emoji: "🧿", name: "nazar amulet", group: Group::Activities, skin_tone: None, aliases: Some(&["nazar_amulet"]), variations: &[] },
    Emoji { id: 2475, emoji: "🎮", name: "video game", group: Group::Activities, skin_tone: None, aliases: Some(&["video_game"]), variations: &[] },
    Emoji { id: 2476, emoji: "🕹️", name: "joystick", group: Group::Activities, skin_tone: None, aliases: Some(&["joystick"]), variations: &["🕹"] },
    Emoji { id: 2477, emoji: "🎰", name: "slot machine", group: Group::Activities, skin_tone: None, aliases: Some(&["slot_machine"]), variations: &[] },
    Emoji { id: 2478, emoji: "🎲", name: "game die", group: Group::Activities, skin_tone: None, aliases: Some(&["game_die"]), variations: &[] },
    Emoji { id: 2479, emoji: "🧩", name: "puzzle piece", group: Group::Activities, skin_tone: None, aliases: Some(&["jigsaw"]), variations: &[] },
    Emoji { id: 2480, emoji: "🧸", name: "teddy bear", group: Group::Activities, skin_tone: None, aliases: Some(&["teddy_bear"]), variations: &[] },
    Emoji { id: 2481, emoji: "🪅", name: "piñata", group: Group::Activities, skin_tone: None, aliases: Some(&["pi_ata"]), variations: &[] },
    Emoji { id: 2482, emoji: "🪆", name: "nesting dolls", group: Group::Activities, skin_tone: None, aliases: Some(&["nesting_dolls"]), variations: &[] },
    Emoji { id: 2483, emoji: "♠️", name: "spade suit", group: Group::Activities, skin_tone: None, aliases: Some(&["spades"]), variations: &["♠"] },
    Emoji { id: 2484, emoji: "♥️", name: "heart suit", group: Group::Activities, skin_tone: None, aliases: Some(&["hearts"]), variations: &["♥"] },
    Emoji { id: 2485, emoji: "♦️", name: "diamond suit", group: Group::Activities, skin_tone: None, aliases: Some(&["diamonds"]), variations: &["♦"] },
    Emoji { id: 2486, emoji: "♣️", name: "club suit", group: Group::Activities, skin_tone: None, aliases: Some(&["clubs"]), variations: &["♣"] },
    Emoji { id: 2487, emoji: "♟️", name: "chess pawn", group: Group::Activities, skin_tone: None, aliases: Some(&["chess_pawn"]), variations: &["♟"] },
    Emoji { id: 2488, emoji: "🃏", name: "joker", group: Group::Activities, skin_tone: None, aliases: Some(&["black_joker"]), variations: &[] },
    Emoji { id: 2489, emoji: "🀄", name: "mahjong red dragon", group: Group::Activities, skin_tone: None, aliases: Some(&["mahjong"]), variations: &[] },
    Emoji { id: 2490, emoji: "🎴", name: "flower playing cards", group: Group::Activities, skin_tone: None, aliases: Some(&["flower_playing_cards"]), variations: &[] },
    Emoji { id: 2491, emoji: "🎭", name: "performing arts", group: Group::Activities, skin_tone: None, aliases: Some(&["performing_arts"]), variations: &[] },
    Emoji { id: 2492, emoji: "🖼️", name: "framed picture", group: Group::Activities, skin_tone: None, aliases: Some(&["framed_picture"]), variations: &["🖼"] },
    Emoji { id: 2493, emoji: "🎨", name: "artist palette", group: Group::Activities, skin_tone: None, aliases: Some(&["art"]), variations: &[] },
    Emoji { id: 2494, emoji: "🧵", name: "thread", group: Group::Activities, skin_tone: None, aliases: Some(&["thread"]), variations: &[] },
    Emoji { id: 2495, emoji: "🪡", name: "sewing needle", group: Group::Activities, skin_tone: None, aliases: Some(&["sewing_needle"]), variations: &[] },
    Emoji { id: 2496, emoji: "🧶", name: "yarn", group: Group::Activities, skin_tone: None, aliases: Some(&["yarn"]), variations: &[] },
    Emoji { id: 2497, emoji: "🪢", name: "knot", group: Group::Activities, skin_tone: None, aliases: Some(&["knot"]), variations: &[] },
    Emoji { id: 2498, emoji: "👓", name: "glasses", group: Group::Objects, skin_tone: None, aliases: Some(&["eyeglasses"]), variations: &[] },
    Emoji { id: 2499, emoji: "🕶️", name: "sunglasses", group: Group::Objects, skin_tone: None, aliases: Some(&["dark_sunglasses"]), variations: &["🕶"] },
    Emoji { id: 2500, emoji: "🥽", name: "goggles", group: Group::Objects, skin_tone: None, aliases: Some(&["goggles"]), variations: &[] },
    Emoji { id: 2501, emoji: "🥼", name: "lab coat", group: Group::Objects, skin_tone: None, aliases: Some(&["lab_coat"]), variations: &[] },
    Emoji { id: 2502, emoji: "🦺", name: "safety vest", group: Group::Objects, skin_tone: None, aliases: Some(&["safety_vest"]), variations: &[] },
    Emoji { id: 2503, emoji: "👔", name: "necktie", group: Group::Objects, skin_tone: None, aliases: Some(&["necktie"]), variations: &[] },
    Emoji { id: 2504, emoji: "👕", name: "t-shirt", group: Group::Objects, skin_tone: None, aliases: Some(&["shirt", "tshirt"]), variations: &[] },
    Emoji { id: 2505, emoji: "👖", name: "jeans", group: Group::Objects, skin_tone: None, aliases: Some(&["jeans"]), variations: &[] },
    Emoji { id: 2506, emoji: "🧣", name: "scarf", group: Group::Objects, skin_tone: None, aliases: Some(&["scarf"]), variations: &[] },
    Emoji { id: 2507, emoji: "🧤", name: "gloves", group: Group::Objects, skin_tone: None, aliases: Some(&["gloves"]), variations: &[] },
    Emoji { id: 2508, emoji: "🧥", name: "coat", group: Group::Objects, skin_tone: None, aliases: Some(&["coat"]), variations: &[] },
    Emoji { id: 2509, emoji: "🧦", name: "socks", group: Group::Objects, skin_tone: None, aliases: Some(&["socks"]), variations: &[] },
    Emoji { id: 2510, emoji: "👗", name: "dress", group: Group::Objects, skin_tone: None, aliases: Some(&["dress"]), variations: &[] },
    Emoji { id: 2511, emoji: "👘", name: "kimono", group: Group::Objects, skin_tone: None, aliases: Some(&["kimono"]), variations: &[] },
    Emoji { id: 2512, emoji: "🥻", name: "sari", group: Group::Objects, skin_tone: None, aliases: Some(&["sari"]), variations: &[] },
    Emoji { id: 2513, emoji: "🩱", name: "one-piece swimsuit", group: Group::Objects, skin_tone: None, aliases: Some(&["one_piece_swimsuit"]), variations: &[] },
    Emoji { id: 2514, emoji: "🩲", name: "briefs", group: Group::Objects, skin_tone: None, aliases: Some(&["swim_brief"]), variations: &[] },
    Emoji { id: 2515, emoji: "🩳", name: "shorts", group: Group::Objects, skin_tone: None, aliases: Some(&["shorts"]), variations: &[] },
    Emoji { id: 2516, emoji: "👙", name: "bikini", group: Group::Objects, skin_tone: None, aliases: Some(&["bikini"]), variations: &[] },
    Emoji { id: 2517, emoji: "👚", name: "woman’s clothes", group: Group::Objects, skin_tone: None, aliases: Some(&["womans_clothes"]), variations: &[] },
    Emoji { id: 2518, emoji: "👛", name: "purse", group: Group::Objects, skin_tone: None, aliases: Some(&["purse"]), variations: &[] },
    Emoji { id: 2519, emoji: "👜", name: "handbag", group: Group::Objects, skin_tone: None, aliases: Some(&["handbag"]), variations: &[] },
    Emoji { id: 2520, emoji: "👝", name: "clutch bag", group: Group::Objects, skin_tone: None, aliases: Some(&["pouch"]), variations: &[] },
    Emoji { id: 2521, emoji: "🛍️", name: "shopping bags", group: Group::Objects, skin_tone: None, aliases: Some(&["shopping"]), variations: &["🛍"] },
    Emoji { id: 2522, emoji: "🎒", name: "backpack", group: Group::Objects, skin_tone: None, aliases: Some(&["school_satchel"]), variations: &[] },
    Emoji { id: 2523, emoji: "🩴", name: "thong sandal", group: Group::Objects, skin_tone: None, aliases: Some(&["thong_sandal"]), variations: &[] },
    Emoji { id: 2524, emoji: "👞", name: "man’s shoe", group: Group::Objects, skin_tone: None, aliases: Some(&["mans_shoe", "shoe"]), variations: &[] },
    Emoji { id: 2525, emoji: "👟", name: "running shoe", group: Group::Objects, skin_tone: None, aliases: Some(&["athletic_shoe"]), variations: &[] },
    Emoji { id: 2526, emoji: "🥾", name: "hiking boot", group: Group::Objects, skin_tone: None, aliases: Some(&["hiking_boot"]), variations: &[] },
    Emoji { id: 2527, emoji: "🥿", name: "flat shoe", group: Group::Objects, skin_tone: None, aliases: Some(&["flat_shoe"]), variations: &[] },
    Emoji { id: 2528, emoji: "👠", name: "high-heeled shoe", group: Group::Objects, skin_tone: None, aliases: Some(&["high_heel"]), variations: &[] },
    Emoji { id: 2529, emoji: "👡", name: "woman’s sandal", group: Group::Objects, skin_tone: None, aliases: Some(&["sandal"]), variations: &[] },
    Emoji { id: 2530, emoji: "🩰", name: "ballet shoes", group: Group::Objects, skin_tone: None, aliases: Some(&["ballet_shoes"]), variations: &[] },
    Emoji { id: 2531, emoji: "👢", name: "woman’s boot", group: Group::Objects, skin_tone: None, aliases: Some(&["boot"]), variations: &[] },
    Emoji { id: 2532, emoji: "👑", name: "crown", group: Group::Objects, skin_tone: None, aliases: Some(&["crown"]), variations: &[] },
    Emoji { id: 2533, emoji: "👒", name: "woman’s hat", group: Group::Objects, skin_tone: None, aliases: Some(&["womans_hat"]), variations: &[] },
    Emoji { id: 2534, emoji: "🎩", name: "top hat", group: Group::Objects, skin_tone: None, aliases: Some(&["tophat"]), variations: &[] },
    Emoji { id: 2535, emoji: "🎓", name: "graduation cap", group: Group::Objects, skin_tone: None, aliases: Some(&["mortar_board"]), variations: &[] },
    Emoji { id: 2536, emoji: "🧢", name: "billed cap", group: Group::Objects, skin_tone: None, aliases: Some(&["billed_cap"]), variations: &[] },
    Emoji { id: 2537, emoji: "🪖", name: "military helmet", group: Group::Objects, skin_tone: None, aliases: Some(&["military_helmet"]), variations: &[] },
    Emoji { id: 2538, emoji: "⛑️", name: "rescue worker’s helmet", group: Group::Objects, skin_tone: None, aliases: Some(&["rescue_worker_helmet"]), variations: &["⛑"] },
    Emoji { id: 2539, emoji: "📿", name: "prayer beads", group: Group::Objects, skin_tone: None, aliases: Some(&["prayer_beads"]), variations: &[] },
    Emoji { id: 2540, emoji: "💄", name: "lipstick", group: Group::Objects, skin_tone: None, aliases: Some(&["lipstick"]), variations: &[] },
    Emoji { id: 2541, emoji: "💍", name: "ring", group: Group::Objects, skin_tone: None, aliases: Some(&["ring"]), variations: &[] },
    Emoji { id: 2542, emoji: "💎", name: "gem stone", group: Group::Objects, skin_tone: None, aliases: Some(&["gem"]), variations: &[] },
    Emoji { id: 2543, emoji: "🔇", name: "muted speaker", group: Group::Objects, skin_tone: None, aliases: Some(&["mute"]), variations: &[] },
    Emoji { id: 2544, emoji: "🔈", name: "speaker low volume", group: Group::Objects, skin_tone: None, aliases: Some(&["speaker"]), variations: &[] },
    Emoji { id: 2545, emoji: "🔉", name: "speaker medium volume", group: Group::Objects, skin_tone: None, aliases: Some(&["sound"]), variations: &[] },
    Emoji { id: 2546, emoji: "🔊", name: "speaker high volume", group: Group::Objects, skin_tone: None, aliases: Some(&["loud_sound"]), variations: &[] },
    Emoji { id: 2547, emoji: "📢", name: "loudspeaker", group: Group::Objects, skin_tone: None, aliases: Some(&["loudspeaker"]), variations: &[] },
    Emoji { id: 2548, emoji: "📣", name: "megaphone", group: Group::Objects, skin_tone: None, aliases: Some(&["mega"]), variations: &[] },
    Emoji { id: 2549, emoji: "📯", name: "postal horn", group: Group::Objects, skin_tone: None, aliases: Some(&["postal_horn"]), variations: &[] },
    Emoji { id: 2550, emoji: "🔔", name: "bell", group: Group::Objects, skin_tone: None, aliases: Some(&["bell"]), variations: &[] },
    Emoji { id: 2551, emoji: "🔕", name: "bell with slash", group: Group::Objects, skin_tone: None, aliases: Some(&["no_bell"]), variations: &[] },
    Emoji { id: 2552, emoji: "🎼", name: "musical score", group: Group::Objects, skin_tone: None, aliases: Some(&["musical_score"]), variations: &[] },
    Emoji { id: 2553, emoji: "🎵", name: "musical note", group: Group::Objects, skin_tone: None, aliases: Some(&["musical_note"]), variations: &[] },
    Emoji { id: 2554, emoji: "🎶", name: "musical notes", group: Group::Objects, skin_tone: None, aliases: Some(&["notes"]), variations: &[] },
    Emoji { id: 2555, emoji: "🎙️", name: "studio microphone", group: Group::Objects, skin_tone: None, aliases: Some(&["studio_microphone"]), variations: &["🎙"] },
    Emoji { id: 2556, emoji: "🎚️", name: "level slider", group: Group::Objects, skin_tone: None, aliases: Some(&["level_slider"]), variations: &["🎚"] },
    Emoji { id: 2557, emoji: "🎛️", name: "control knobs", group: Group::Objects, skin_tone: None, aliases: Some(&["control_knobs"]), variations: &["🎛"] },
    Emoji { id: 2558, emoji: "🎤", name: "microphone", group: Group::Objects, skin_tone: None, aliases: Some(&["microphone"]), variations: &[] },
    Emoji { id: 2559, emoji: "🎧", name: "headphone", group: Group::Objects, skin_tone: None, aliases: Some(&["headphones"]), variations: &[] },
    Emoji { id: 2560, emoji: "📻", name: "radio", group: Group::Objects, skin_tone: None, aliases: Some(&["radio"]), variations: &[] },
    Emoji { id: 2561, emoji: "🎷", name: "saxophone", group: Group::Objects, skin_tone: None, aliases: Some(&["saxophone"]), variations: &[] },
    Emoji { id: 2562, emoji: "🪗", name: "accordion", group: Group::Objects, skin_tone: None, aliases: Some(&["accordion"]), variations: &[] },
    Emoji { id: 2563, emoji: "🎸", name: "guitar", group: Group::Objects, skin_tone: None, aliases: Some(&["guitar"]), variations: &[] },
    Emoji { id: 2564, emoji: "🎹", name: "musical keyboard", group: Group::Objects, skin_tone: None, aliases: Some(&["musical_keyboard"]), variations: &[] },
    Emoji { id: 2565, emoji: "🎺", name: "trumpet", group: Group::Objects, skin_tone: None, aliases: Some(&["trumpet"]), variations: &[] },
    Emoji { id: 2566, emoji: "🎻", name: "violin", group: Group::Objects, skin_tone: None, aliases: Some(&["violin"]), variations: &[] },
    Emoji { id: 2567, emoji: "🪕", name: "banjo", group: Group::Objects, skin_tone: None, aliases: Some(&["banjo"]), variations: &[] },
    Emoji { id: 2568, emoji: "🥁", name: "drum", group: Group::Objects, skin_tone: None, aliases: Some(&["drum"]), variations: &[] },
    Emoji { id: 2569, emoji: "🪘", name: "long drum", group: Group::Objects, skin_tone: None, aliases: Some(&["long_drum"]), variations: &[] },
    Emoji { id: 2570, emoji: "📱", name: "mobile phone", group: Group::Objects, skin_tone: None, aliases: Some(&["iphone"]), variations: &[] },
    Emoji { id: 2571, emoji: "📲", name: "mobile phone with arrow", group: Group::Objects, skin_tone: None, aliases: Some(&["calling"]), variations: &[] },
    Emoji { id: 2572, emoji: "☎️", name: "telephone", group: Group::Objects, skin_tone: None, aliases: Some(&["phone", "telephone"]), variations: &["☎"] },
    Emoji { id: 2573, emoji: "📞", name: "telephone receiver", group: Group::Objects, skin_tone: None, aliases: Some(&["telephone_receiver"]), variations: &[] },
    Emoji { id: 2574, emoji: "📟", name: "pager", group: Group::Objects, skin_tone: None, aliases: Some(&["pager"]), variations: &[] },
    Emoji { id: 2575, emoji: "📠", name: "fax machine", group: Group::Objects, skin_tone: None, aliases: Some(&["fax"]), variations: &[] },
    Emoji { id: 2576, emoji: "🔋", name: "battery", group: Group::Objects, skin_tone: None, aliases: Some(&["battery"]), variations: &[] },
    Emoji { id: 2577, emoji: "🔌", name: "electric plug", group: Group::Objects, skin_tone: None, aliases: Some(&["electric_plug"]), variations: &[] },
    Emoji { id: 2578, emoji: "💻", name: "laptop", group: Group::Objects, skin_tone: None, aliases: Some(&["computer"]), variations: &[] },
    Emoji { id: 2579, emoji: "🖥️", name: "desktop computer", group: Group::Objects, skin_tone: None, aliases: Some(&["desktop_computer"]), variations: &["🖥"] },
    Emoji { id: 2580, emoji: "🖨️", name: "printer", group: Group::Objects, skin_tone: None, aliases: Some(&["printer"]), variations: &["🖨"] },
    Emoji { id: 2581, emoji: "⌨️", name: "keyboard", group: Group::Objects, skin_tone: None, aliases: Some(&["keyboard"]), variations: &["⌨"] },
    Emoji { id: 2582, emoji: "🖱️", name: "computer mouse", group: Group::Objects, skin_tone: None, aliases: Some(&["computer_mouse"]), variations: &["🖱"] },
    Emoji { id: 2583, emoji: "🖲️", name: "trackball", group: Group::Objects, skin_tone: None, aliases: Some(&["trackball"]), variations: &["🖲"] },
    Emoji { id: 2584, emoji: "💽", name: "computer disk", group: Group::Objects, skin_tone: None, aliases: Some(&["minidisc"]), variations: &[] },
    Emoji { id: 2585, emoji: "💾", name: "floppy disk", group: Group::Objects, skin_tone: None, aliases: Some(&["floppy_disk"]), variations: &[] },
    Emoji { id: 2586, emoji: "💿", name: "optical disk", group: Group::Objects, skin_tone: None, aliases: Some(&["cd"]), variations: &[] },
    Emoji { id: 2587, emoji: "📀", name: "dvd", group: Group::Objects, skin_tone: None, aliases: Some(&["dvd"]), variations: &[] },
    Emoji { id: 2588, emoji: "🧮", name: "abacus", group: Group::Objects, skin_tone: None, aliases: Some(&["abacus"]), variations: &[] },
    Emoji { id: 2589, emoji: "🎥", name: "movie camera", group: Group::Objects, skin_tone: None, aliases: Some(&["movie_camera"]), variations: &[] },
    Emoji { id: 2590, emoji: "🎞️", name: "film frames", group: Group::Objects, skin_tone: None, aliases: Some(&["film_strip"]), variations: &["🎞"] },
    Emoji { id: 2591, emoji: "📽️", name: "film projector", group: Group::Objects, skin_tone: None, aliases: Some(&["film_projector"]), variations: &["📽"] },
    Emoji { id: 2592, emoji: "🎬", name: "clapper board", group: Group::Objects, skin_tone: None, aliases: Some(&["clapper"]), variations: &[] },
    Emoji { id: 2593, emoji: "📺", name: "television", group: Group::Objects, skin_tone: None, aliases: Some(&["tv"]), variations: &[] },
    Emoji { id: 2594, emoji: "📷", name: "camera", group: Group::Objects, skin_tone: None, aliases: Some(&["camera"]), variations: &[] },
    Emoji { id: 2595, emoji: "📸", name: "camera with flash", group: Group::Objects, skin_tone: None, aliases: Some(&["camera_flash"]), variations: &[] },
    Emoji { id: 2596, emoji: "📹", name: "video camera", group: Group::Objects, skin_tone: None, aliases: Some(&["video_camera"]), variations: &[] },
    Emoji { id: 2597, emoji: "📼", name: "videocassette", group: Group::Objects, skin_tone: None, aliases: Some(&["vhs"]), variations: &[] },
    Emoji { id: 2598, emoji: "🔍", name: "magnifying glass tilted left", group: Group::Objects, skin_tone: None, aliases: Some(&["mag"]), variations: &[] },
    Emoji { id: 2599, emoji: "🔎", name: "magnifying glass tilted right", group: Group::Objects, skin_tone: None, aliases: Some(&["mag_right"]), variations: &[] },
    Emoji { id: 2600, emoji: "🕯️", name: "candle", group: Group::Objects, skin_tone: None, aliases: Some(&["candle"]), variations: &["🕯"] },
    Emoji { id: 2601, emoji: "💡", name: "light bulb", group: Group::Objects, skin_tone: None, aliases: Some(&["bulb"]), variations: &[] },
    Emoji { id: 2602, emoji: "🔦", name: "flashlight", group: Group::Objects, skin_tone: None, aliases: Some(&["flashlight"]), variations: &[] },
    Emoji { id: 2603, emoji: "🏮", name: "red paper lantern", group: Group::Objects, skin_tone: None, aliases: Some(&["izakaya_lantern", "lantern"]), variations: &[] },
    Emoji { id: 2604, emoji: "🪔", name: "diya lamp", group: Group::Objects, skin_tone: None, aliases: Some(&["diya_lamp"]), variations: &[] },
    Emoji { id: 2605, emoji: "📔", name: "notebook with decorative cover", group: Group::Objects, skin_tone: None, aliases: Some(&["notebook_with_decorative_cover"]), variations: &[] },
    Emoji { id: 2606, emoji: "📕", name: "closed book", group: Group::Objects, skin_tone: None, aliases: Some(&["closed_book"]), variations: &[] },
    Emoji { id: 2607, emoji: "📖", name: "open book", group: Group::Objects, skin_tone: None, aliases: Some(&["book", "open_book"]), variations: &[] },
    Emoji { id: 2608, emoji: "📗", name: "green book", group: Group::Objects, skin_tone: None, aliases: Some(&["green_book"]), variations: &[] },
    Emoji { id: 2609, emoji: "📘", name: "blue book", group: Group::Objects, skin_tone: None, aliases: Some(&["blue_book"]), variations: &[] },
    Emoji { id: 2610, emoji: "📙", name: "orange book", group: Group::Objects, skin_tone: None, aliases: Some(&["orange_book"]), variations: &[] },
    Emoji { id: 2611, emoji: "📚", name: "books", group: Group::Objects, skin_tone: None, aliases: Some(&["books"]), variations: &[] },
    Emoji { id: 2612, emoji: "📓", name: "notebook", group: Group::Objects, skin_tone: None, aliases: Some(&["notebook"]), variations: &[] },
    Emoji { id: 2613, emoji: "📒", name: "ledger", group: Group::Objects, skin_tone: None, aliases: Some(&["ledger"]), variations: &[] },
    Emoji { id: 2614, emoji: "📃", name: "page with curl", group: Group::Objects, skin_tone: None, aliases: Some(&["page_with_curl"]), variations: &[] },
    Emoji { id: 2615, emoji: "📜", name: "scroll", group: Group::Objects, skin_tone: None, aliases: Some(&["scroll"]), variations: &[] },
    Emoji { id: 2616, emoji: "📄", name: "page facing up", group: Group::Objects, skin_tone: None, aliases: Some(&["page_facing_up"]), variations: &[] },
    Emoji { id: 2617, emoji: "📰", name: "newspaper", group: Group::Objects, skin_tone: None, aliases: Some(&["newspaper"]), variations: &[] },
    Emoji { id: 2618, emoji: "🗞️", name: "rolled-up newspaper", group: Group::Objects, skin_tone: None, aliases: Some(&["newspaper_roll"]), variations: &["🗞"] },
    Emoji { id: 2619, emoji: "📑", name: "bookmark tabs", group: Group::Objects, skin_tone: None, aliases: Some(&["bookmark_tabs"]), variations: &[] },
    Emoji { id: 2620, emoji: "🔖", name: "bookmark", group: Group::Objects, skin_tone: None, aliases: Some(&["bookmark"]), variations: &[] },
    Emoji { id: 2621, emoji: "🏷️", name: "label", group: Group::Objects, skin_tone: None, aliases: Some(&["label"]), variations: &["🏷"] },
    Emoji { id: 2622, emoji: "💰", name: "money bag", group: Group::Objects, skin_tone: None, aliases: Some(&["moneybag"]), variations: &[] },
    Emoji { id: 2623, emoji: "🪙", name: "coin", group: Group::Objects, skin_tone: None, aliases: Some(&["coin"]), variations: &[] },
    Emoji { id: 2624, emoji: "💴", name: "yen banknote", group: Group::Objects, skin_tone: None, aliases: Some(&["yen"]), variations: &[] },
    Emoji { id: 2625, emoji: "💵", name: "dollar banknote", group: Group::Objects, skin_tone: None, aliases: Some(&["dollar"]), variations: &[] },
    Emoji { id: 2626, emoji: "💶", name: "euro banknote", group: Group::Objects, skin_tone: None, aliases: Some(&["euro"]), variations: &[] },
    Emoji { id: 2627, emoji: "💷", name: "pound banknote", group: Group::Objects, skin_tone: None, aliases: Some(&["pound"]), variations: &[] },
    Emoji { id: 2628, emoji: "💸", name: "money with wings", group: Group::Objects, skin_tone: None, aliases: Some(&["money_with_wings"]), variations: &[] },
    Emoji { id: 2629, emoji: "💳", name: "credit card", group: Group::Objects, skin_tone: None, aliases: Some(&["credit_card"]), variations: &[] },
    Emoji { id: 2630, emoji: "🧾", name: "receipt", group: Group::Objects, skin_tone: None, aliases: Some(&["receipt"]), variations: &[] },
    Emoji { id: 2631, emoji: "💹", name: "chart increasing with yen", group: Group::Objects, skin_tone: None, aliases: Some(&["chart"]), variations: &[] },
    Emoji { id: 2632, emoji: "✉️", name: "envelope", group: Group::Objects, skin_tone: None, aliases: Some(&["email", "envelope"]), variations: &["✉"] },
    Emoji { id: 2633, emoji: "📧", name: "e-mail", group: Group::Objects, skin_tone: None, aliases: Some(&["e-mail"]), variations: &[] },
    Emoji { id: 2634, emoji: "📨", name: "incoming envelope", group: Group::Objects, skin_tone: None, aliases: Some(&["incoming_envelope"]), variations: &[] },
    Emoji { id: 2635, emoji: "📩", name: "envelope with arrow", group: Group::Objects, skin_tone: None, aliases: Some(&["envelope_with_arrow"]), variations: &[] },
    Emoji { id: 2636, emoji: "📤", name: "outbox tray", group: Group::Objects, skin_tone: None, aliases: Some(&["outbox_tray"]), variations: &[] },
    Emoji { id: 2637, emoji: "📥", name: "inbox tray", group: Group::Objects, skin_tone: None, aliases: Some(&["inbox_tray"]), variations: &[] },
    Emoji { id: 2638, emoji: "📦", name: "package", group: Group::Objects, skin_tone: None, aliases: Some(&["package"]), variations: &[] },
    Emoji { id: 2639, emoji: "📫", name: "closed mailbox with raised flag", group: Group::Objects, skin_tone: None, aliases: Some(&["mailbox"]), variations: &[] },
    Emoji { id: 2640, emoji: "📪", name: "closed mailbox with lowered flag", group: Group::Objects, skin_tone: None, aliases: Some(&["mailbox_closed"]), variations: &[] },
    Emoji { id: 2641, emoji: "📬", name: "open mailbox with raised flag", group: Group::Objects, skin_tone: None, aliases: Some(&["mailbox_with_mail"]), variations: &[] },
    Emoji { id: 2642, emoji: "📭", name: "open mailbox with lowered flag", group: Group::Objects, skin_tone: None, aliases: Some(&["mailbox_with_no_mail"]), variations: &[] },
    Emoji { id: 2643, emoji: "📮", name: "postbox", group: Group::Objects, skin_tone: None, aliases: Some(&["postbox"]), variations: &[] },
    Emoji { id: 2644, emoji: "🗳️", name: "ballot box with ballot", group: Group::Objects, skin_tone: None, aliases: Some(&["ballot_box"]), variations: &["🗳"] },
    Emoji { id: 2645, emoji: "✏️", name: "pencil", group: Group::Objects, skin_tone: None, aliases: Some(&["pencil2"]), variations: &["✏"] },
    Emoji { id: 2646, emoji: "✒️", name: "black nib", group: Group::Objects, skin_tone: None, aliases: Some(&["black_nib"]), variations: &["✒"] },
    Emoji { id: 2647, emoji: "🖋️", name: "fountain pen", group: Group::Objects, skin_tone: None, aliases: Some(&["fountain_pen"]), variations: &["🖋"] },
    Emoji { id: 2648, emoji: "🖊️", name: "pen", group: Group::Objects, skin_tone: None, aliases: Some(&["pen"]), variations: &["🖊"] },
    Emoji { id: 2649, emoji: "🖌️", name: "paintbrush", group: Group::Objects, skin_tone: None, aliases: Some(&["paintbrush"]), variations: &["🖌"] },
    Emoji { id: 2650, emoji: "🖍️", name: "crayon", group: Group::Objects, skin_tone: None, aliases: Some(&["crayon"]), variations: &["🖍"] },
    Emoji { id: 2651, emoji: "📝", name: "memo", group: Group::Objects, skin_tone: None, aliases: Some(&["memo", "pencil"]), variations: &[] },
    Emoji { id: 2652, emoji: "💼", name: "briefcase", group: Group::Objects, skin_tone: None, aliases: Some(&["briefcase"]), variations: &[] },
    Emoji { id: 2653, emoji: "📁", name: "file folder", group: Group::Objects, skin_tone: None, aliases: Some(&["file_folder"]), variations: &[] },
    Emoji { id: 2654, emoji: "📂", name: "open file folder", group: Group::Objects, skin_tone: None, aliases: Some(&["open_file_folder"]), variations: &[] },
    Emoji { id: 2655, emoji: "🗂️", name: "card index dividers", group: Group::Objects, skin_tone: None, aliases: Some(&["card_index_dividers"]), variations: &["🗂"] },
    Emoji { id: 2656, emoji: "📅", name: "calendar", group: Group::Objects, skin_tone: None, aliases: Some(&["date"]), variations: &[] },
    Emoji { id: 2657, emoji: "📆", name: "tear-off calendar", group: Group::Objects, skin_tone: None, aliases: Some(&["calendar"]), variations: &[] },
    Emoji { id: 2658, emoji: "🗒️", name: "spiral notepad", group: Group::Objects, skin_tone: None, aliases: Some(&["spiral_notepad"]), variations: &["🗒"] },
    Emoji { id: 2659, emoji: "🗓️", name: "spiral calendar", group: Group::Objects, skin_tone: None, aliases: Some(&["spiral_calendar"]), variations: &["🗓"] },
    Emoji { id: 2660, emoji: "📇", name: "card index", group: Group::Objects, skin_tone: None, aliases: Some(&["card_index"]), variations: &[] },
    Emoji { id: 2661, emoji: "📈", name: "chart increasing", group: Group::Objects, skin_tone: None, aliases: Some(&["chart_with_upwards_trend"]), variations: &[] },
    Emoji { id: 2662, emoji: "📉", name: "chart decreasing", group: Group::Objects, skin_tone: None, aliases: Some(&["chart_with_downwards_trend"]), variations: &[] },
    Emoji { id: 2663, emoji: "📊", name: "bar chart", group: Group::Objects, skin_tone: None, aliases: Some(&["bar_chart"]), variations: &[] },
    Emoji { id: 2664, emoji: "📋", name: "clipboard", group: Group::Objects, skin_tone: None, aliases: Some(&["clipboard"]), variations: &[] },
    Emoji { id: 2665, emoji: "📌", name: "pushpin", group: Group::Objects, skin_tone: None, aliases: Some(&["pushpin"]), variations: &[] },
    Emoji { id: 2666, emoji: "📍", name: "round pushpin", group: Group::Objects, skin_tone: None, aliases: Some(&["round_pushpin"]), variations: &[] },
    Emoji { id: 2667, emoji: "📎", name: "paperclip", group: Group::Objects, skin_tone: None, aliases: Some(&["paperclip"]), variations: &[] },
    Emoji { id: 2668, emoji: "🖇️", name: "linked paperclips", group: Group::Objects, skin_tone: None, aliases: Some(&["paperclips"]), variations: &["🖇"] },
    Emoji { id: 2669, emoji: "📏", name: "straight ruler", group: Group::Objects, skin_tone: None, aliases: Some(&["straight_ruler"]), variations: &[] },
    Emoji { id: 2670, emoji: "📐", name: "triangular ruler", group: Group::Objects, skin_tone: None, aliases: Some(&["triangular_ruler"]), variations: &[] },
    Emoji { id: 2671, emoji: "✂️", name: "scissors", group: Group::Objects, skin_tone: None, aliases: Some(&["scissors"]), variations: &["✂"] },
    Emoji { id: 2672, emoji: "🗃️", name: "card file box", group: Group::Objects, skin_tone: None, aliases: Some(&["card_file_box"]), variations: &["🗃"] },
    Emoji { id: 2673, emoji: "🗄️", name: "file cabinet", group: Group::Objects, skin_tone: None, aliases: Some(&["file_cabinet"]), variations: &["🗄"] },
    Emoji { id: 2674, emoji: "🗑️", name: "wastebasket", group: Group::Objects, skin_tone: None, aliases: Some(&["wastebasket"]), variations: &["🗑"] },
    Emoji { id: 2675, emoji: "🔒", name: "locked", group: Group::Objects, skin_tone: None, aliases: Some(&["lock"]), variations: &[] },
    Emoji { id: 2676, emoji: "🔓", name: "unlocked", group: Group::Objects, skin_tone: None, aliases: Some(&["unlock"]), variations: &[] },
    Emoji { id: 2677, emoji: "🔏", name: "locked with pen", group: Group::Objects, skin_tone: None, aliases: Some(&["lock_with_ink_pen"]), variations: &[] },
    Emoji { id: 2678, emoji: "🔐", name: "locked with key", group: Group::Objects, skin_tone: None, aliases: Some(&["closed_lock_with_key"]), variations: &[] },
    Emoji { id: 2679, emoji: "🔑", name: "key", group: Group::Objects, skin_tone: None, aliases: Some(&["key"]), variations: &[] },
    Emoji { id: 2680, emoji: "🗝️", name: "old key", group: Group::Objects, skin_tone: None, aliases: Some(&["old_key"]), variations: &["🗝"] },
    Emoji { id: 2681, emoji: "🔨", name: "hammer", group: Group::Objects, skin_tone: None, aliases: Some(&["hammer"]), variations: &[] },
    Emoji { id: 2682, emoji: "🪓", name: "axe", group: Group::Objects, skin_tone: None, aliases: Some(&["axe"]), variations: &[] },
    Emoji { id: 2683, emoji: "⛏️", name: "pick", group: Group::Objects, skin_tone: None, aliases: Some(&["pick"]), variations: &["⛏"] },
    Emoji { id: 2684, emoji: "⚒️", name: "hammer and pick", group: Group::Objects, skin_tone: None, aliases: Some(&["hammer_and_pick"]), variations: &["⚒"] },
    Emoji { id: 2685, emoji: "🛠️", name: "hammer and wrench", group: Group::Objects, skin_tone: None, aliases: Some(&["hammer_and_wrench"]), variations: &["🛠"] },
    Emoji { id: 2686, emoji: "🗡️", name: "dagger", group: Group::Objects, skin_tone: None, aliases: Some(&["dagger"]), variations: &["🗡"] },
    Emoji { id: 2687, emoji: "⚔️", name: "crossed swords", group: Group::Objects, skin_tone: None, aliases: Some(&["crossed_swords"]), variations: &["⚔"] },
    Emoji { id: 2688, emoji: "🔫", name: "water pistol", group: Group::Objects, skin_tone: None, aliases: Some(&["gun"]), variations: &[] },
    Emoji { id: 2689, emoji: "🪃", name: "boomerang", group: Group::Objects, skin_tone: None, aliases: Some(&["boomerang"]), variations: &[] },
    Emoji { id: 2690, emoji: "🏹", name: "bow and arrow", group: Group::Objects, skin_tone: None, aliases: Some(&["bow_and_arrow"]), variations: &[] },
    Emoji { id: 2691, emoji: "🛡️", name: "shield", group: Group::Objects, skin_tone: None, aliases: Some(&["shield"]), variations: &["🛡"] },
    Emoji { id: 2692, emoji: "🪚", name: "carpentry saw", group: Group::Objects, skin_tone: None, aliases: Some(&["carpentry_saw"]), variations: &[] },
    Emoji { id: 2693, emoji: "🔧", name: "wrench", group: Group::Objects, skin_tone: None, aliases: Some(&["wrench"]), variations: &[] },
    Emoji { id: 2694, emoji: "🪛", name: "screwdriver", group: Group::Objects, skin_tone: None, aliases: Some(&["screwdriver"]), variations: &[] },
    Emoji { id: 2695, emoji: "🔩", name: "nut and bolt", group: Group::Objects, skin_tone: None, aliases: Some(&["nut_and_bolt"]), variations: &[] },
    Emoji { id: 2696, emoji: "⚙️", name: "gear", group: Group::Objects, skin_tone: None, aliases: Some(&["gear"]), variations: &["⚙"] },
    Emoji { id: 2697, emoji: "🗜️", name: "clamp", group: Group::Objects, skin_tone: None, aliases: Some(&["clamp"]), variations: &["🗜"] },
    Emoji { id: 2698, emoji: "⚖️", name: "balance scale", group: Group::Objects, skin_tone: None, aliases: Some(&["balance_scale"]), variations: &["⚖"] },
    Emoji { id: 2699, emoji: "🦯", name: "white cane", group: Group::Objects, skin_tone: None, aliases: Some(&["probing_cane"]), variations: &[] },
    Emoji { id: 2700, emoji: "🔗", name: "link", group: Group::Objects, skin_tone: None, aliases: Some(&["link"]), variations: &[] },
    Emoji { id: 2701, emoji: "⛓️", name: "chains", group: Group::Objects, skin_tone: None, aliases: Some(&["chains"]), variations: &["⛓"] },
    Emoji { id: 2702, emoji: "🪝", name: "hook", group: Group::Objects, skin_tone: None, aliases: Some(&["hook"]), variations: &[] },
    Emoji { id: 2703, emoji: "🧰", name: "toolbox", group: Group::Objects, skin_tone: None, aliases: Some(&["toolbox"]), variations: &[] },
    Emoji { id: 2704, emoji: "🧲", name: "magnet", group: Group::Objects, skin_tone: None, aliases: Some(&["magnet"]), variations: &[] },
    Emoji { id: 2705, emoji: "🪜", name: "ladder", group: Group::Objects, skin_tone: None, aliases: Some(&["ladder"]), variations: &[] },
    Emoji { id: 2706, emoji: "⚗️", name: "alembic", group: Group::Objects, skin_tone: None, aliases: Some(&["alembic"]), variations: &["⚗"] },
    Emoji { id: 2707, emoji: "🧪", name: "test tube", group: Group::Objects, skin_tone: None, aliases: Some(&["test_tube"]), variations: &[] },
    Emoji { id: 2708, emoji: "🧫", name: "petri dish", group: Group::Objects, skin_tone: None, aliases: Some(&["petri_dish"]), variations: &[] },
    Emoji { id: 2709, emoji: "🧬", name: "dna", group: Group::Objects, skin_tone: None, aliases: Some(&["dna"]), variations: &[] },
    Emoji { id: 2710, emoji: "🔬", name: "microscope", group: Group::Objects, skin_tone: None, aliases: Some(&["microscope"]), variations: &[] },
    Emoji { id: 2711, emoji: "🔭", name: "telescope", group: Group::Objects, skin_tone: None, aliases: Some(&["telescope"]), variations: &[] },
    Emoji { id: 2712, emoji: "📡", name: "satellite antenna", group: Group::Objects, skin_tone: None, aliases: Some(&["satellite"]), variations: &[] },
    Emoji { id: 2713, emoji: "💉", name: "syringe", group: Group::Objects, skin_tone: None, aliases: Some(&["syringe"]), variations: &[] },
    Emoji { id: 2714, emoji: "🩸", name: "drop of blood", group: Group::Objects, skin_tone: None, aliases: Some(&["drop_of_blood"]), variations: &[] },
    Emoji { id: 2715, emoji: "💊", name: "pill", group: Group::Objects, skin_tone: None, aliases: Some(&["pill"]), variations: &[] },
    Emoji { id: 2716, emoji: "🩹", name: "adhesive bandage", group: Group::Objects, skin_tone: None, aliases: Some(&["adhesive_bandage"]), variations: &[] },
    Emoji { id: 2717, emoji: "🩺", name: "stethoscope", group: Group::Objects, skin_tone: None, aliases: Some(&["stethoscope"]), variations: &[] },
    Emoji { id: 2718, emoji: "🚪", name: "door", group: Group::Objects, skin_tone: None, aliases: Some(&["door"]), variations: &[] },
    Emoji { id: 2719, emoji: "🛗", name: "elevator", group: Group::Objects, skin_tone: None, aliases: Some(&["elevator"]), variations: &[] },
    Emoji { id: 2720, emoji: "🪞", name: "mirror", group: Group::Objects, skin_tone: None, aliases: Some(&["mirror"]), variations: &[] },
    Emoji { id: 2721, emoji: "🪟", name: "window", group: Group::Objects, skin_tone: None, aliases: Some(&["window"]), variations: &[] },
    Emoji { id: 2722, emoji: "🛏️", name: "bed", group: Group::Objects, skin_tone: None, aliases: Some(&["bed"]), variations: &["🛏"] },
    Emoji { id: 2723, emoji: "🛋️", name: "couch and lamp", group: Group::Objects, skin_tone: None, aliases: Some(&["couch_and_lamp"]), variations: &["🛋"] },
    Emoji { id: 2724, emoji: "🪑", name: "chair", group: Group::Objects, skin_tone: None, aliases: Some(&["chair"]), variations: &[] },
    Emoji { id: 2725, emoji: "🚽", name: "toilet", group: Group::Objects, skin_tone: None, aliases: Some(&["toilet"]), variations: &[] },
    Emoji { id: 2726, emoji: "🪠", name: "plunger", group: Group::Objects, skin_tone: None, aliases: Some(&["plunger"]), variations: &[] },
    Emoji { id: 2727, emoji: "🚿", name: "shower", group: Group::Objects, skin_tone: None, aliases: Some(&["shower"]), variations: &[] },
    Emoji { id: 2728, emoji: "🛁", name: "bathtub", group: Group::Objects, skin_tone: None, aliases: Some(&["bathtub"]), variations: &[] },
    Emoji { id: 2729, emoji: "🪤", name: "mouse trap", group: Group::Objects, skin_tone: None, aliases: Some(&["mouse_trap"]), variations: &[] },
    Emoji { id: 2730, emoji: "🪒", name: "razor", group: Group::Objects, skin_tone: None, aliases: Some(&["razor"]), variations: &[] },
    Emoji { id: 2731, emoji: "🧴", name: "lotion bottle", group: Group::Objects, skin_tone: None, aliases: Some(&["lotion_bottle"]), variations: &[] },
    Emoji { id: 2732, emoji: "🧷", name: "safety pin", group: Group::Objects, skin_tone: None, aliases: Some(&["safety_pin"]), variations: &[] },
    Emoji { id: 2733, emoji: "🧹", name: "broom", group: Group::Objects, skin_tone: None, aliases: Some(&["broom"]), variations: &[] },
    Emoji { id: 2734, emoji: "🧺", name: "basket", group: Group::Objects, skin_tone: None, aliases: Some(&["basket"]), variations: &[] },
    Emoji { id: 2735, emoji: "🧻", name: "roll of paper", group: Group::Objects, skin_tone: None, aliases: Some(&["roll_of_paper"]), variations: &[] },
    Emoji { id: 2736, emoji: "🪣", name: "bucket", group: Group::Objects, skin_tone: None, aliases: Some(&["bucket"]), variations: &[] },
    Emoji { id: 2737, emoji: "🧼", name: "soap", group: Group::Objects, skin_tone: None, aliases: Some(&["soap"]), variations: &[] },
    Emoji { id: 2738, emoji: "🪥", name: "toothbrush", group: Group::Objects, skin_tone: None, aliases: Some(&["toothbrush"]), variations: &[] },
    Emoji { id: 2739, emoji: "🧽", name: "sponge", group: Group::Objects, skin_tone: None, aliases: Some(&["sponge"]), variations: &[] },
    Emoji { id: 2740, emoji: "🧯", name: "fire extinguisher", group: Group::Objects, skin_tone: None, aliases: Some(&["fire_extinguisher"]), variations: &[] },
    Emoji { id: 2741, emoji: "🛒", name: "shopping cart", group: Group::Objects, skin_tone: None, aliases: Some(&["shopping_cart"]), variations: &[] },
    Emoji { id: 2742, emoji: "🚬", name: "cigarette", group: Group::Objects, skin_tone: None, aliases: Some(&["smoking"]), variations: &[] },
    Emoji { id: 2743, emoji: "⚰️", name: "coffin", group: Group::Objects, skin_tone: None, aliases: Some(&["coffin"]), variations: &["⚰"] },
    Emoji { id: 2744, emoji: "🪦", name: "headstone", group: Group::Objects, skin_tone: None, aliases: Some(&["headstone"]), variations: &[] },
    Emoji { id: 2745, emoji: "⚱️", name: "funeral urn", group: Group::Objects, skin_tone: None, aliases: Some(&["funeral_urn"]), variations: &["⚱"] },
    Emoji { id: 2746, emoji: "🗿", name: "moai", group: Group::Objects, skin_tone: None, aliases: Some(&["moyai"]), variations: &[] },
    Emoji { id: 2747, emoji: "🪧", name: "placard", group: Group::Objects, skin_tone: None, aliases: Some(&["placard"]), variations: &[] },
    Emoji { id: 2748, emoji: "🏧", name: "ATM sign", group: Group::Symbols, skin_tone: None, aliases: Some(&["atm"]), variations: &[] },
    Emoji { id: 2749, emoji: "🚮", name: "litter in bin sign", group: Group::Symbols, skin_tone: None, aliases: Some(&["put_litter_in_its_place"]), variations: &[] },
    Emoji { id: 2750, emoji: "🚰", name: "potable water", group: Group::Symbols, skin_tone: None, aliases: Some(&["potable_water"]), variations: &[] },
    Emoji { id: 2751, emoji: "♿", name: "wheelchair symbol", group: Group::Symbols, skin_tone: None, aliases: Some(&["wheelchair"]), variations: &[] },
    Emoji { id: 2752, emoji: "🚹", name: "men’s room", group: Group::Symbols, skin_tone: None, aliases: Some(&["mens"]), variations: &[] },
    Emoji { id: 2753, emoji: "🚺", name: "women’s room", group: Group::Symbols, skin_tone: None, aliases: Some(&["womens"]), variations: &[] },
    Emoji { id: 2754, emoji: "🚻", name: "restroom", group: Group::Symbols, skin_tone: None, aliases: Some(&["restroom"]), variations: &[] },
    Emoji { id: 2755, emoji: "🚼", name: "baby symbol", group: Group::Symbols, skin_tone: None, aliases: Some(&["baby_symbol"]), variations: &[] },
    Emoji { id: 2756, emoji: "🚾", name: "water closet", group: Group::Symbols, skin_tone: None, aliases: Some(&["wc"]), variations: &[] },
    Emoji { id: 2757, emoji: "🛂", name: "passport control", group: Group::Symbols, skin_tone: None, aliases: Some(&["passport_control"]), variations: &[] },
    Emoji { id: 2758, emoji: "🛃", name: "customs", group: Group::Symbols, skin_tone: None, aliases: Some(&["customs"]), variations: &[] },
    Emoji { id: 2759, emoji: "🛄", name: "baggage claim", group: Group::Symbols, skin_tone: None, aliases: Some(&["baggage_claim"]), variations: &[] },
    Emoji { id: 2760, emoji: "🛅", name: "left luggage", group: Group::Symbols, skin_tone: None, aliases: Some(&["left_luggage"]), variations: &[] },
    Emoji { id: 2761, emoji: "⚠️", name: "warning", group: Group::Symbols, skin_tone: None, aliases: Some(&["warning"]), variations: &["⚠"] },
    Emoji { id: 2762, emoji: "🚸", name: "children crossing", group: Group::Symbols, skin_tone: None, aliases: Some(&["children_crossing"]), variations: &[] },
    Emoji { id: 2763, emoji: "⛔", name: "no entry", group: Group::Symbols, skin_tone: None, aliases: Some(&["no_entry"]), variations: &[] },
    Emoji { id: 2764, emoji: "🚫", name: "prohibited", group: Group::Symbols, skin_tone: None, aliases: Some(&["no_entry_sign"]), variations: &[] },
    Emoji { id: 2765, emoji: "🚳", name: "no bicycles", group: Group::Symbols, skin_tone: None, aliases: Some(&["no_bicycles"]), variations: &[] },
    Emoji { id: 2766, emoji: "🚭", name: "no smoking", group: Group::Symbols, skin_tone: None, aliases: Some(&["no_smoking"]), variations: &[] },
    Emoji { id: 2767, emoji: "🚯", name: "no littering", group: Group::Symbols, skin_tone: None, aliases: Some(&["do_not_litter"]), variations: &[] },
    Emoji { id: 2768, emoji: "🚱", name: "non-potable water", group: Group::Symbols, skin_tone: None, aliases: Some(&["non-potable_water"]), variations: &[] },
    Emoji { id: 2769, emoji: "🚷", name: "no pedestrians", group: Group::Symbols, skin_tone: None, aliases: Some(&["no_pedestrians"]), variations: &[] },
    Emoji { id: 2770, emoji: "📵", name: "no mobile phones", group: Group::Symbols, skin_tone: None, aliases: Some(&["no_mobile_phones"]), variations: &[] },
    Emoji { id: 2771, emoji: "🔞", name: "no one under eighteen", group: Group::Symbols, skin_tone: None, aliases: Some(&["underage"]), variations: &[] },
    Emoji { id: 2772, emoji: "☢️", name: "radioactive", group: Group::Symbols, skin_tone: None, aliases: Some(&["radioactive"]), variations: &["☢"] },
    Emoji { id: 2773, emoji: "☣️", name: "biohazard", group: Group::Symbols, skin_tone: None, aliases: Some(&["biohazard"]), variations: &["☣"] },
    Emoji { id: 2774, emoji: "⬆️", name: "up arrow", group: Group::Symbols, skin_tone: None, aliases: Some(&["arrow_up"]), variations: &["⬆"] },
    Emoji { id: 2775, emoji: "↗️", name: "up-right arrow", group: Group::Symbols, skin_tone: None, aliases: Some(&["arrow_upper_right"]), variations: &["↗"] },
    Emoji { id: 2776, emoji: "➡️", name: "right arrow", group: Group::Symbols, skin_tone: None, aliases: Some(&["arrow_right"]), variations: &["➡"] },
    Emoji { id: 2777, emoji: "↘️", name: "down-right arrow", group: Group::Symbols, skin_tone: None, aliases: Some(&["arrow_lower_right"]), variations: &["↘"] },
    Emoji { id: 2778, emoji: "⬇️", name: "down arrow", group: Group::Symbols, skin_tone: None, aliases: Some(&["arrow_down"]), variations: &["⬇"] },
    Emoji { id: 2779, emoji: "↙️", name: "down-left arrow", group: Group::Symbols, skin_tone: None, aliases: Some(&["arrow_lower_left"]), variations: &["↙"] },
    Emoji { id: 2780, emoji: "⬅️", name: "left arrow", group: Group::Symbols, skin_tone: None, aliases: Some(&["arrow_left"]), variations: &["⬅"] },
    Emoji { id: 2781, emoji: "↖️", name: "up-left arrow", group: Group::Symbols, skin_tone: None, aliases: Some(&["arrow_upper_left"]), variations: &["↖"] },
    Emoji { id: 2782, emoji: "↕️", name: "up-down arrow", group: Group::Symbols, skin_tone: None, aliases: Some(&["arrow_up_down"]), variations: &["↕"] },
    Emoji { id: 2783, emoji: "↔️", name: "left-right arrow", group: Group::Symbols, skin_tone: None, aliases: Some(&["left_right_arrow"]), variations: &["↔"] },
    Emoji { id: 2784, emoji: "↩️", name: "right arrow curving left", group: Group::Symbols, skin_tone: None, aliases: Some(&["leftwards_arrow_with_hook"]), variations: &["↩"] },
    Emoji { id: 2785, emoji: "↪️", name: "left arrow curving right", group: Group::Symbols, skin_tone: None, aliases: Some(&["arrow_right_hook"]), variations: &["↪"] },
    Emoji { id: 2786, emoji: "⤴️", name: "right arrow curving up", group: Group::Symbols, skin_tone: None, aliases: Some(&["arrow_heading_up"]), variations: &["⤴"] },
    Emoji { id: 2787, emoji: "⤵️", name: "right arrow curving down", group: Group::Symbols, skin_tone: None, aliases: Some(&["arrow_heading_down"]), variations: &["⤵"] },
    Emoji { id: 2788, emoji: "🔃", name: "clockwise vertical arrows", group: Group::Symbols, skin_tone: None, aliases: Some(&["arrows_clockwise"]), variations: &[] },
    Emoji { id: 2789, emoji: "🔄", name: "counterclockwise arrows button", group: Group::Symbols, skin_tone: None, aliases: Some(&["arrows_counterclockwise"]), variations: &[] },
    Emoji { id: 2790, emoji: "🔙", name: "BACK arrow", group: Group::Symbols, skin_tone: None, aliases: Some(&["back"]), variations: &[] },
    Emoji { id: 2791, emoji: "🔚", name: "END arrow", group: Group::Symbols, skin_tone: None, aliases: Some(&["end"]), variations: &[] },
    Emoji { id: 2792, emoji: "🔛", name: "ON! arrow", group: Group::Symbols, skin_tone: None, aliases: Some(&["on"]), variations: &[] },
    Emoji { id: 2793, emoji: "🔜", name: "SOON arrow", group: Group::Symbols, skin_tone: None, aliases: Some(&["soon"]), variations: &[] },
    Emoji { id: 2794, emoji: "🔝", name: "TOP arrow", group: Group::Symbols, skin_tone: None, aliases: Some(&["top"]), variations: &[] },
    Emoji { id: 2795, emoji: "🛐", name: "place of worship", group: Group::Symbols, skin_tone: None, aliases: Some(&["place_of_worship"]), variations: &[] },
    Emoji { id: 2796, emoji: "⚛️", name: "atom symbol", group: Group::Symbols, skin_tone: None, aliases: Some(&["atom_symbol"]), variations: &["⚛"] },
    Emoji { id: 2797, emoji: "🕉️", name: "om", group: Group::Symbols, skin_tone: None, aliases: Some(&["om"]), variations: &["🕉"] },
    Emoji { id: 2798, emoji: "✡️", name: "star of David", group: Group::Symbols, skin_tone: None, aliases: Some(&["star_of_david"]), variations: &["✡"] },
    Emoji { id: 2799, emoji: "☸️", name: "wheel of dharma", group: Group::Symbols, skin_tone: None, aliases: Some(&["wheel_of_dharma"]), variations: &["☸"] },
    Emoji { id: 2800, emoji: "☯️", name: "yin yang", group: Group::Symbols, skin_tone: None, aliases: Some(&["yin_yang"]), variations: &["☯"] },
    Emoji { id: 2801, emoji: "✝️", name: "latin cross", group: Group::Symbols, skin_tone: None, aliases: Some(&["latin_cross"]), variations: &["✝"] },
    Emoji { id: 2802, emoji: "☦️", name: "orthodox cross", group: Group::Symbols, skin_tone: None, aliases: Some(&["orthodox_cross"]), variations: &["☦"] },
    Emoji { id: 2803, emoji: "☪️", name: "star and crescent", group: Group::Symbols, skin_tone: None, aliases: Some(&["star_and_crescent"]), variations: &["☪"] },
    Emoji { id: 2804, emoji: "☮️", name: "peace symbol", group: Group::Symbols, skin_tone: None, aliases: Some(&["peace_symbol"]), variations: &["☮"] },
    Emoji { id: 2805, emoji: "🕎", name: "menorah", group: Group::Symbols, skin_tone: None, aliases: Some(&["menorah"]), variations: &[] },
    Emoji { id: 2806, emoji: "🔯", name: "dotted six-pointed star", group: Group::Symbols, skin_tone: None, aliases: Some(&["six_pointed_star"]), variations: &[] },
    Emoji { id: 2807, emoji: "♈", name: "Aries", group: Group::Symbols, skin_tone: None, aliases: Some(&["aries"]), variations: &[] },
    Emoji { id: 2808, emoji: "♉", name: "Taurus", group: Group::Symbols, skin_tone: None, aliases: Some(&["taurus"]), variations: &[] },
    Emoji { id: 2809, emoji: "♊", name: "Gemini", group: Group::Symbols, skin_tone: None, aliases: Some(&["gemini"]), variations: &[] },
    Emoji { id: 2810, emoji: "♋", name: "Cancer", group: Group::Symbols, skin_tone: None, aliases: Some(&["cancer"]), variations: &[] },
    Emoji { id: 2811, emoji: "♌", name: "Leo", group: Group::Symbols, skin_tone: None, aliases: Some(&["leo"]), variations: &[] },
    Emoji { id: 2812, emoji: "♍", name: "Virgo", group: Group::Symbols, skin_tone: None, aliases: Some(&["virgo"]), variations: &[] },
    Emoji { id: 2813, emoji: "♎", name: "Libra", group: Group::Symbols, skin_tone: None, aliases: Some(&["libra"]), variations: &[] },
    Emoji { id: 2814, emoji: "♏", name: "Scorpio", group: Group::Symbols, skin_tone: None, aliases: Some(&["scorpius"]), variations: &[] },
    Emoji { id: 2815, emoji: "♐", name: "Sagittarius", group: Group::Symbols, skin_tone: None, aliases: Some(&["sagittarius"]), variations: &[] },
    Emoji { id: 2816, emoji: "♑", name: "Capricorn", group: Group::Symbols, skin_tone: None, aliases: Some(&["capricorn"]), variations: &[] },
    Emoji { id: 2817, emoji: "♒", name: "Aquarius", group: Group::Symbols, skin_tone: None, aliases: Some(&["aquarius"]), variations: &[] },
    Emoji { id: 2818, emoji: "♓", name: "Pisces", group: Group::Symbols, skin_tone: None, aliases: Some(&["pisces"]), variations: &[] },
    Emoji { id: 2819, emoji: "⛎", name: "Ophiuchus", group: Group::Symbols, skin_tone: None, aliases: Some(&["ophiuchus"]), variations: &[] },
    Emoji { id: 2820, emoji: "🔀", name: "shuffle tracks button", group: Group::Symbols, skin_tone: None, aliases: Some(&["twisted_rightwards_arrows"]), variations: &[] },
    Emoji { id: 2821, emoji: "🔁", name: "repeat button", group: Group::Symbols, skin_tone: None, aliases: Some(&["repeat"]), variations: &[] },
    Emoji { id: 2822, emoji: "🔂", name: "repeat single button", group: Group::Symbols, skin_tone: None, aliases: Some(&["repeat_one"]), variations: &[] },
    Emoji { id: 2823, emoji: "▶️", name: "play button", group: Group::Symbols, skin_tone: None, aliases: Some(&["arrow_forward"]), variations: &["▶"] },
    Emoji { id: 2824, emoji: "⏩", name: "fast-forward button", group: Group::Symbols, skin_tone: None, aliases: Some(&["fast_forward"]), variations: &[] },
    Emoji { id: 2825, emoji: "⏭️", name: "next track button", group: Group::Symbols, skin_tone: None, aliases: Some(&["next_track_button"]), variations: &["⏭"] },
    Emoji { id: 2826, emoji: "⏯️", name: "play or pause button", group: Group::Symbols, skin_tone: None, aliases: Some(&["play_or_pause_button"]), variations: &["⏯"] },
    Emoji { id: 2827, emoji: "◀️", name: "reverse button", group: Group::Symbols, skin_tone: None, aliases: Some(&["arrow_backward"]), variations: &["◀"] },
    Emoji { id: 2828, emoji: "⏪", name: "fast reverse button", group: Group::Symbols, skin_tone: None, aliases: Some(&["rewind"]), variations: &[] },
    Emoji { id: 2829, emoji: "⏮️", name: "last track button", group: Group::Symbols, skin_tone: None, aliases: Some(&["previous_track_button"]), variations: &["⏮"] },
    Emoji { id: 2830, emoji: "🔼", name: "upwards button", group: Group::Symbols, skin_tone: None, aliases: Some(&["arrow_up_small"]), variations: &[] },
    Emoji { id: 2831, emoji: "⏫", name: "fast up button", group: Group::Symbols, skin_tone: None, aliases: Some(&["arrow_double_up"]), variations: &[] },
    Emoji { id: 2832, emoji: "🔽", name: "downwards button", group: Group::Symbols, skin_tone: None, aliases: Some(&["arrow_down_small"]), variations: &[] },
    Emoji { id: 2833, emoji: "⏬", name: "fast down button", group: Group::Symbols, skin_tone: None, aliases: Some(&["arrow_double_down"]), variations: &[] },
    Emoji { id: 2834, emoji: "⏸️", name: "pause button", group: Group::Symbols, skin_tone: None, aliases: Some(&["pause_button"]), variations: &["⏸"] },
    Emoji { id: 2835, emoji: "⏹️", name: "stop button", group: Group::Symbols, skin_tone: None, aliases: Some(&["stop_button"]), variations: &["⏹"] },
    Emoji { id: 2836, emoji: "⏺️", name: "record button", group: Group::Symbols, skin_tone: None, aliases: Some(&["record_button"]), variations: &["⏺"] },
    Emoji { id: 2837, emoji: "⏏️", name: "eject button", group: Group::Symbols, skin_tone: None, aliases: Some(&["eject_button"]), variations: &["⏏"] },
    Emoji { id: 2838, emoji: "🎦", name: "cinema", group: Group::Symbols, skin_tone: None, aliases: Some(&["cinema"]), variations: &[] },
    Emoji { id: 2839, emoji: "🔅", name: "dim button", group: Group::Symbols, skin_tone: None, aliases: Some(&["low_brightness"]), variations: &[] },
    Emoji { id: 2840, emoji: "🔆", name: "bright button", group: Group::Symbols, skin_tone: None, aliases: Some(&["high_brightness"]), variations: &[] },
    Emoji { id: 2841, emoji: "📶", name: "antenna bars", group: Group::Symbols, skin_tone: None, aliases: Some(&["signal_strength"]), variations: &[] },
    Emoji { id: 2842, emoji: "📳", name: "vibration mode", group: Group::Symbols, skin_tone: None, aliases: Some(&["vibration_mode"]), variations: &[] },
    Emoji { id: 2843, emoji: "📴", name: "mobile phone off", group: Group::Symbols, skin_tone: None, aliases: Some(&["mobile_phone_off"]), variations: &[] },
    Emoji { id: 2844, emoji: "♀️", name: "female sign", group: Group::Symbols, skin_tone: None, aliases: Some(&["female_sign"]), variations: &["♀"] },
    Emoji { id: 2845, emoji: "♂️", name: "male sign", group: Group::Symbols, skin_tone: None, aliases: Some(&["male_sign"]), variations: &["♂"] },
    Emoji { id: 2846, emoji: "⚧️", name: "transgender symbol", group: Group::Symbols, skin_tone: None, aliases: Some(&["transgender_symbol"]), variations: &["⚧"] },
    Emoji { id: 2847, emoji: "✖️", name: "multiply", group: Group::Symbols, skin_tone: None, aliases: Some(&["heavy_multiplication_x"]), variations: &["✖"] },
    Emoji { id: 2848, emoji: "➕", name: "plus", group: Group::Symbols, skin_tone: None, aliases: Some(&["heavy_plus_sign"]), variations: &[] },
    Emoji { id: 2849, emoji: "➖", name: "minus", group: Group::Symbols, skin_tone: None, aliases: Some(&["heavy_minus_sign"]), variations: &[] },
    Emoji { id: 2850, emoji: "➗", name: "divide", group: Group::Symbols, skin_tone: None, aliases: Some(&["heavy_division_sign"]), variations: &[] },
    Emoji { id: 2851, emoji: "♾️", name: "infinity", group: Group::Symbols, skin_tone: None, aliases: Some(&["infinity"]), variations: &["♾"] },
    Emoji { id: 2852, emoji: "‼️", name: "double exclamation mark", group: Group::Symbols, skin_tone: None, aliases: Some(&["bangbang"]), variations: &["‼"] },
    Emoji { id: 2853, emoji: "⁉️", name: "exclamation question mark", group: Group::Symbols, skin_tone: None, aliases: Some(&["interrobang"]), variations: &["⁉"] },
    Emoji { id: 2854, emoji: "❓", name: "red question mark", group: Group::Symbols, skin_tone: None, aliases: Some(&["question"]), variations: &[] },
    Emoji { id: 2855, emoji: "❔", name: "white question mark", group: Group::Symbols, skin_tone: None, aliases: Some(&["grey_question"]), variations: &[] },
    Emoji { id: 2856, emoji: "❕", name: "white exclamation mark", group: Group::Symbols, skin_tone: None, aliases: Some(&["grey_exclamation"]), variations: &[] },
    Emoji { id: 2857, emoji: "❗", name: "red exclamation mark", group: Group::Symbols, skin_tone: None, aliases: Some(&["exclamation", "heavy_exclamation_mark"]), variations: &[] },
    Emoji { id: 2858, emoji: "〰️", name: "wavy dash", group: Group::Symbols, skin_tone: None, aliases: Some(&["wavy_dash"]), variations: &["〰"] },
    Emoji { id: 2859, emoji: "💱", name: "currency exchange", group: Group::Symbols, skin_tone: None, aliases: Some(&["currency_exchange"]), variations: &[] },
    Emoji { id: 2860, emoji: "💲", name: "heavy dollar sign", group: Group::Symbols, skin_tone: None, aliases: Some(&["heavy_dollar_sign"]), variations: &[] },
    Emoji { id: 2861, emoji: "⚕️", name: "medical symbol", group: Group::Symbols, skin_tone: None, aliases: Some(&["medical_symbol"]), variations: &["⚕"] },
    Emoji { id: 2862, emoji: "♻️", name: "recycling symbol", group: Group::Symbols, skin_tone: None, aliases: Some(&["recycle"]), variations: &["♻"] },
    Emoji { id: 2863, emoji: "⚜️", name: "fleur-de-lis", group: Group::Symbols, skin_tone: None, aliases: Some(&["fleur_de_lis"]), variations: &["⚜"] },
    Emoji { id: 2864, emoji: "🔱", name: "trident emblem", group: Group::Symbols, skin_tone: None, aliases: Some(&["trident"]), variations: &[] },
    Emoji { id: 2865, emoji: "📛", name: "name badge", group: Group::Symbols, skin_tone: None, aliases: Some(&["name_badge"]), variations: &[] },
    Emoji { id: 2866, emoji: "🔰", name: "Japanese symbol for beginner", group: Group::Symbols, skin_tone: None, aliases: Some(&["beginner"]), variations: &[] },
    Emoji { id: 2867, emoji: "⭕", name: "hollow red circle", group: Group::Symbols, skin_tone: None, aliases: Some(&["o"]), variations: &[] },
    Emoji { id: 2868, emoji: "✅", name: "check mark button", group: Group::Symbols, skin_tone: None, aliases: Some(&["white_check_mark"]), variations: &[] },
    Emoji { id: 2869, emoji: "☑️", name: "check box with check", group: Group::Symbols, skin_tone: None, aliases: Some(&["ballot_box_with_check"]), variations: &["☑"] },
    Emoji { id: 2870, emoji: "✔️", name: "check mark", group: Group::Symbols, skin_tone: None, aliases: Some(&["heavy_check_mark"]), variations: &["✔"] },
    Emoji { id: 2871, emoji: "❌", name: "cross mark", group: Group::Symbols, skin_tone: None, aliases: Some(&["x"]), variations: &[] },
    Emoji { id: 2872, emoji: "❎", name: "cross mark button", group: Group::Symbols, skin_tone: None, aliases: Some(&["negative_squared_cross_mark"]), variations: &[] },
    Emoji { id: 2873, emoji: "➰", name: "curly loop", group: Group::Symbols, skin_tone: None, aliases: Some(&["curly_loop"]), variations: &[] },
    Emoji { id: 2874, emoji: "➿", name: "double curly loop", group: Group::Symbols, skin_tone: None, aliases: Some(&["loop"]), variations: &[] },
    Emoji { id: 2875, emoji: "〽️", name: "part alternation mark", group: Group::Symbols, skin_tone: None, aliases: Some(&["part_alternation_mark"]), variations: &["〽"] },
    Emoji { id: 2876, emoji: "✳️", name: "eight-spoked asterisk", group: Group::Symbols, skin_tone: None, aliases: Some(&["eight_spoked_asterisk"]), variations: &["✳"] },
    Emoji { id: 2877, emoji: "✴️", name: "eight-pointed star", group: Group::Symbols, skin_tone: None, aliases: Some(&["eight_pointed_black_star"]), variations: &["✴"] },
    Emoji { id: 2878, emoji: "❇️", name: "sparkle", group: Group::Symbols, skin_tone: None, aliases: Some(&["sparkle"]), variations: &["❇"] },
    Emoji { id: 2879, emoji: "©️", name: "copyright", group: Group::Symbols, skin_tone: None, aliases: Some(&["copyright"]), variations: &["©"] },
    Emoji { id: 2880, emoji: "®️", name: "registered", group: Group::Symbols, skin_tone: None, aliases: Some(&["registered"]), variations: &["®"] },
    Emoji { id: 2881, emoji: "™️", name: "trade mark", group: Group::Symbols, skin_tone: None, aliases: Some(&["tm"]), variations: &["™"] },
    Emoji { id: 2882, emoji: "#️⃣", name: "keycap: #", group: Group::Symbols, skin_tone: None, aliases: Some(&["hash"]), variations: &["#\u{20e3}"] },
    Emoji { id: 2883, emoji: "*️⃣", name: "keycap: *", group: Group::Symbols, skin_tone: None, aliases: Some(&["asterisk"]), variations: &["*\u{20e3}"] },
    Emoji { id: 2884, emoji: "0️⃣", name: "keycap: 0", group: Group::Symbols, skin_tone: None, aliases: Some(&["zero"]), variations: &["0\u{20e3}"] },
    Emoji { id: 2885, emoji: "1️⃣", name: "keycap: 1", group: Group::Symbols, skin_tone: None, aliases: Some(&["one"]), variations: &["1\u{20e3}"] },
    Emoji { id: 2886, emoji: "2️⃣", name: "keycap: 2", group: Group::Symbols, skin_tone: None, aliases: Some(&["two"]), variations: &["2\u{20e3}"] },
    Emoji { id: 2887, emoji: "3️⃣", name: "keycap: 3", group: Group::Symbols, skin_tone: None, aliases: Some(&["three"]), variations: &["3\u{20e3}"] },
    Emoji { id: 2888, emoji: "4️⃣", name: "keycap: 4", group: Group::Symbols, skin_tone: None, aliases: Some(&["four"]), variations: &["4\u{20e3}"] },
    Emoji { id: 2889, emoji: "5️⃣", name: "keycap: 5", group: Group::Symbols, skin_tone: None, aliases: Some(&["five"]), variations: &["5\u{20e3}"] },
    Emoji { id: 2890, emoji: "6️⃣", name: "keycap: 6", group: Group::Symbols, skin_tone: None, aliases: Some(&["six"]), variations: &["6\u{20e3}"] },
    Emoji { id: 2891, emoji: "7️⃣", name: "keycap: 7", group: Group::Symbols, skin_tone: None, aliases: Some(&["seven"]), variations: &["7\u{20e3}"] },
    Emoji { id: 2892, emoji: "8️⃣", name: "keycap: 8", group: Group::Symbols, skin_tone: None, aliases: Some(&["eight"]), variations: &["8\u{20e3}"] },
    Emoji { id: 2893, emoji: "9️⃣", name: "keycap: 9", group: Group::Symbols, skin_tone: None, aliases: Some(&["nine"]), variations: &["9\u{20e3}"] },
    Emoji { id: 2894, emoji: "🔟", name: "keycap: 10", group: Group::Symbols, skin_tone: None, aliases: Some(&["keycap_ten"]), variations: &[] },
    Emoji { id: 2895, emoji: "🔠", name: "input latin uppercase", group: Group::Symbols, skin_tone: None, aliases: Some(&["capital_abcd"]), variations: &[] },
    Emoji { id: 2896, emoji: "🔡", name: "input latin lowercase", group: Group::Symbols, skin_tone: None, aliases: Some(&["abcd"]), variations: &[] },
    Emoji { id: 2897, emoji: "🔢", name: "input numbers", group: Group::Symbols, skin_tone: None, aliases: Some(&["1234"]), variations: &[] },
    Emoji { id: 2898, emoji: "🔣", name: "input symbols", group: Group::Symbols, skin_tone: None, aliases: Some(&["symbols"]), variations: &[] },
    Emoji { id: 2899, emoji: "🔤", name: "input latin letters", group: Group::Symbols, skin_tone: None, aliases: Some(&["abc"]), variations: &[] },
    Emoji { id: 2900, emoji: "🅰️", name: "A button (blood type)", group: Group::Symbols, skin_tone: None, aliases: Some(&["a"]), variations: &["🅰"] },
    Emoji { id: 2901, emoji: "🆎", name: "AB button (blood type)", group: Group::Symbols, skin_tone: None, aliases: Some(&["ab"]), variations: &[] },
    Emoji { id: 2902, emoji: "🅱️", name: "B button (blood type)", group: Group::Symbols, skin_tone: None, aliases: Some(&["b"]), variations: &["🅱"] },
    Emoji { id: 2903, emoji: "🆑", name: "CL button", group: Group::Symbols, skin_tone: None, aliases: Some(&["cl"]), variations: &[] },
    Emoji { id: 2904, emoji: "🆒", name: "COOL button", group: Group::Symbols, skin_tone: None, aliases: Some(&["cool"]), variations: &[] },
    Emoji { id: 2905, emoji: "🆓", name: "FREE button", group: Group::Symbols, skin_tone: None, aliases: Some(&["free"]), variations: &[] },
    Emoji { id: 2906, emoji: "ℹ️", name: "information", group: Group::Symbols, skin_tone: None, aliases: Some(&["information_source"]), variations: &["ℹ"] },
    Emoji { id: 2907, emoji: "🆔", name: "ID button", group: Group::Symbols, skin_tone: None, aliases: Some(&["id"]), variations: &[] },
    Emoji { id: 2908, emoji: "Ⓜ️", name: "circled M", group: Group::Symbols, skin_tone: None, aliases: Some(&["m"]), variations: &["Ⓜ"] },
    Emoji { id: 2909, emoji: "🆕", name: "NEW button", group: Group::Symbols, skin_tone: None, aliases: Some(&["new"]), variations: &[] },
    Emoji { id: 2910, emoji: "🆖", name: "NG button", group: Group::Symbols, skin_tone: None, aliases: Some(&["ng"]), variations: &[] },
    Emoji { id: 2911, emoji: "🅾️", name: "O button (blood type)", group: Group::Symbols, skin_tone: None, aliases: Some(&["o2"]), variations: &["🅾"] },
    Emoji { id: 2912, emoji: "🆗", name: "OK button", group: Group::Symbols, skin_tone: None, aliases: Some(&["ok"]), variations: &[] },
    Emoji { id: 2913, emoji: "🅿️", name: "P button", group: Group::Symbols, skin_tone: None, aliases: Some(&["parking"]), variations: &["🅿"] },
    Emoji { id: 2914, emoji: "🆘", name: "SOS button", group: Group::Symbols, skin_tone: None, aliases: Some(&["sos"]), variations: &[] },
    Emoji { id: 2915, emoji: "🆙", name: "UP! button", group: Group::Symbols, skin_tone: None, aliases: Some(&["up"]), variations: &[] },
    Emoji { id: 2916, emoji: "🆚", name: "VS button", group: Group::Symbols, skin_tone: None, aliases: Some(&["vs"]), variations: &[] },
    Emoji { id: 2917, emoji: "🈁", name: "Japanese “here” button", group: Group::Symbols, skin_tone: None, aliases: Some(&["koko"]), variations: &[] },
    Emoji { id: 2918, emoji: "🈂️", name: "Japanese “service charge” button", group: Group::Symbols, skin_tone: None, aliases: Some(&["sa"]), variations: &["🈂"] },
    Emoji { id: 2919, emoji: "🈷️", name: "Japanese “monthly amount” button", group: Group::Symbols, skin_tone: None, aliases: Some(&["u6708"]), variations: &["🈷"] },
    Emoji { id: 2920, emoji: "🈶", name: "Japanese “not free of charge” button", group: Group::Symbols, skin_tone: None, aliases: Some(&["u6709"]), variations: &[] },
    Emoji { id: 2921, emoji: "🈯", name: "Japanese “reserved” button", group: Group::Symbols, skin_tone: None, aliases: Some(&["u6307"]), variations: &[] },
    Emoji { id: 2922, emoji: "🉐", name: "Japanese “bargain” button", group: Group::Symbols, skin_tone: None, aliases: Some(&["ideograph_advantage"]), variations: &[] },
    Emoji { id: 2923, emoji: "🈹", name: "Japanese “discount” button", group: Group::Symbols, skin_tone: None, aliases: Some(&["u5272"]), variations: &[] },
    Emoji { id: 2924, emoji: "🈚", name: "Japanese “free of charge” button", group: Group::Symbols, skin_tone: None, aliases: Some(&["u7121"]), variations: &[] },
    Emoji { id: 2925, emoji: "🈲", name: "Japanese “prohibited” button", group: Group::Symbols, skin_tone: None, aliases: Some(&["u7981"]), variations: &[] },
    Emoji { id: 2926, emoji: "🉑", name: "Japanese “acceptable” button", group: Group::Symbols, skin_tone: None, aliases: Some(&["accept"]), variations: &[] },
    Emoji { id: 2927, emoji: "🈸", name: "Japanese “application” button", group: Group::Symbols, skin_tone: None, aliases: Some(&["u7533"]), variations: &[] },
    Emoji { id: 2928, emoji: "🈴", name: "Japanese “passing grade” button", group: Group::Symbols, skin_tone: None, aliases: Some(&["u5408"]), variations: &[] },
    Emoji { id: 2929, emoji: "🈳", name: "Japanese “vacancy” button", group: Group::Symbols, skin_tone: None, aliases: Some(&["u7a7a"]), variations: &[] },
    Emoji { id: 2930, emoji: "㊗️", name: "Japanese “congratulations” button", group: Group::Symbols, skin_tone: None, aliases: Some(&["congratulations"]), variations: &["㊗"] },
    Emoji { id: 2931, emoji: "㊙️", name: "Japanese “secret” button", group: Group::Symbols, skin_tone: None, aliases: Some(&["secret"]), variations: &["㊙"] },
    Emoji { id: 2932, emoji: "🈺", name: "Japanese “open for business” button", group: Group::Symbols, skin_tone: None, aliases: Some(&["u55b6"]), variations: &[] },
    Emoji { id: 2933, emoji: "🈵", name: "Japanese “no vacancy” button", group: Group::Symbols, skin_tone: None, aliases: Some(&["u6e80"]), variations: &[] },
    Emoji { id: 2934, emoji: "🔴", name: "red circle", group: Group::Symbols, skin_tone: None, aliases: Some(&["red_circle"]), variations: &[] },
    Emoji { id: 2935, emoji: "🟠", name: "orange circle", group: Group::Symbols, skin_tone: None, aliases: Some(&["orange_circle"]), variations: &[] },
    Emoji { id: 2936, emoji: "🟡", name: "yellow circle", group: Group::Symbols, skin_tone: None, aliases: Some(&["yellow_circle"]), variations: &[] },
    Emoji { id: 2937, emoji: "🟢", name: "green circle", group: Group::Symbols, skin_tone: None, aliases: Some(&["green_circle"]), variations: &[] },
    Emoji { id: 2938, emoji: "🔵", name: "blue circle", group: Group::Symbols, skin_tone: None, aliases: Some(&["large_blue_circle"]), variations: &[] },
    Emoji { id: 2939, emoji: "🟣", name: "purple circle", group: Group::Symbols, skin_tone: None, aliases: Some(&["purple_circle"]), variations: &[] },
    Emoji { id: 2940, emoji: "🟤", name: "brown circle", group: Group::Symbols, skin_tone: None, aliases: Some(&["brown_circle"]), variations: &[] },
    Emoji { id: 2941, emoji: "⚫", name: "black circle", group: Group::Symbols, skin_tone: None, aliases: Some(&["black_circle"]), variations: &[] },
    Emoji { id: 2942, emoji: "⚪", name: "white circle", group: Group::Symbols, skin_tone: None, aliases: Some(&["white_circle"]), variations: &[] },
    Emoji { id: 2943, emoji: "🟥", name: "red square", group: Group::Symbols, skin_tone: None, aliases: Some(&["red_square"]), variations: &[] },
    Emoji { id: 2944, emoji: "🟧", name: "orange square", group: Group::Symbols, skin_tone: None, aliases: Some(&["orange_square"]), variations: &[] },
    Emoji { id: 2945, emoji: "🟨", name: "yellow square", group: Group::Symbols, skin_tone: None, aliases: Some(&["yellow_square"]), variations: &[] },
    Emoji { id: 2946, emoji: "🟩", name: "green square", group: Group::Symbols, skin_tone: None, aliases: Some(&["green_square"]), variations: &[] },
    Emoji { id: 2947, emoji: "🟦", name: "blue square", group: Group::Symbols, skin_tone: None, aliases: Some(&["blue_square"]), variations: &[] },
    Emoji { id: 2948, emoji: "🟪", name: "purple square", group: Group::Symbols, skin_tone: None, aliases: Some(&["purple_square"]), variations: &[] },
    Emoji { id: 2949, emoji: "🟫", name: "brown square", group: Group::Symbols, skin_tone: None, aliases: Some(&["brown_square"]), variations: &[] },
    Emoji { id: 2950, emoji: "⬛", name: "black large square", group: Group::Symbols, skin_tone: None, aliases: Some(&["black_large_square"]), variations: &[] },
    Emoji { id: 2951, emoji: "⬜", name: "white large square", group: Group::Symbols, skin_tone: None, aliases: Some(&["white_large_square"]), variations: &[] },
    Emoji { id: 2952, emoji: "◼️", name: "black medium square", group: Group::Symbols, skin_tone: None, aliases: Some(&["black_medium_square"]), variations: &["◼"] },
    Emoji { id: 2953, emoji: "◻️", name: "white medium square", group: Group::Symbols, skin_tone: None, aliases: Some(&["white_medium_square"]), variations: &["◻"] },
    Emoji { id: 2954, emoji: "◾", name: "black medium-small square", group: Group::Symbols, skin_tone: None, aliases: Some(&["black_medium_small_square"]), variations: &[] },
    Emoji { id: 2955, emoji: "◽", name: "white medium-small square", group: Group::Symbols, skin_tone: None, aliases: Some(&["white_medium_small_square"]), variations: &[] },
    Emoji { id: 2956, emoji: "▪️", name: "black small square", group: Group::Symbols, skin_tone: None, aliases: Some(&["black_small_square"]), variations: &["▪"] },
    Emoji { id: 2957, emoji: "▫️", name: "white small square", group: Group::Symbols, skin_tone: None, aliases: Some(&["white_small_square"]), variations: &["▫"] },
    Emoji { id: 2958, emoji: "🔶", name: "large orange diamond", group: Group::Symbols, skin_tone: None, aliases: Some(&["large_orange_diamond"]), variations: &[] },
    Emoji { id: 2959, emoji: "🔷", name: "large blue diamond", group: Group::Symbols, skin_tone: None, aliases: Some(&["large_blue_diamond"]), variations: &[] },
    Emoji { id: 2960, emoji: "🔸", name: "small orange diamond", group: Group::Symbols, skin_tone: None, aliases: Some(&["small_orange_diamond"]), variations: &[] },
    Emoji { id: 2961, emoji: "🔹", name: "small blue diamond", group: Group::Symbols, skin_tone: None, aliases: Some(&["small_blue_diamond"]), variations: &[] },
    Emoji { id: 2962, emoji: "🔺", name: "red triangle pointed up", group: Group::Symbols, skin_tone: None, aliases: Some(&["small_red_triangle"]), variations: &[] },
    Emoji { id: 2963, emoji: "🔻", name: "red triangle pointed down", group: Group::Symbols, skin_tone: None, aliases: Some(&["small_red_triangle_down"]), variations: &[] },
    Emoji { id: 2964, emoji: "💠", name: "diamond with a dot", group: Group::Symbols, skin_tone: None, aliases: Some(&["diamond_shape_with_a_dot_inside"]), variations: &[] },
    Emoji { id: 2965, emoji: "🔘", name: "radio button", group: Group::Symbols, skin_tone: None, aliases: Some(&["radio_button"]), variations: &[] },
    Emoji { id: 2966, emoji: "🔳", name: "white square button", group: Group::Symbols, skin_tone: None, aliases: Some(&["white_square_button"]), variations: &[] },
    Emoji { id: 2967, emoji: "🔲", name: "black square button", group: Group::Symbols, skin_tone: None, aliases: Some(&["black_square_button"]), variations: &[] },
    Emoji { id: 2968, emoji: "🏁", name: "chequered flag", group: Group::Flags, skin_tone: None, aliases: Some(&["checkered_flag"]), variations: &[] },
    Emoji { id: 2969, emoji: "🚩", name: "triangular flag", group: Group::Flags, skin_tone: None, aliases: Some(&["triangular_flag_on_post"]), variations: &[] },
    Emoji { id: 2970, emoji: "🎌", name: "crossed flags", group: Group::Flags, skin_tone: None, aliases: Some(&["crossed_flags"]), variations: &[] },
    Emoji { id: 2971, emoji: "🏴", name: "black flag", group: Group::Flags, skin_tone: None, aliases: Some(&["black_flag"]), variations: &[] },
    Emoji { id: 2972, emoji: "🏳️", name: "white flag", group: Group::Flags, skin_tone: None, aliases: Some(&["white_flag"]), variations: &["🏳"] },
    Emoji { id: 2973, emoji: "🏳️‍🌈", name: "rainbow flag", group: Group::Flags, skin_tone: None, aliases: Some(&["rainbow_flag"]), variations: &["🏳\u{200d}🌈"] },
    Emoji { id: 2974, emoji: "🏳️‍⚧️", name: "transgender flag", group: Group::Flags, skin_tone: None, aliases: Some(&["transgender_flag"]), variations: &["🏳\u{200d}⚧\u{fe0f}", "🏳\u{fe0f}\u{200d}⚧", "🏳\u{200d}⚧"] },
    Emoji { id: 2975, emoji: "🏴‍☠️", name: "pirate flag", group: Group::Flags, skin_tone: None, aliases: Some(&["pirate_flag"]), variations: &["🏴\u{200d}☠"] },
    Emoji { id: 2976, emoji: "🇦🇨", name: "flag: Ascension Island", group: Group::Flags, skin_tone: None, aliases: Some(&["ascension_island"]), variations: &[] },
    Emoji { id: 2977, emoji: "🇦🇩", name: "flag: Andorra", group: Group::Flags, skin_tone: None, aliases: Some(&["andorra"]), variations: &[] },
    Emoji { id: 2978, emoji: "🇦🇪", name: "flag: United Arab Emirates", group: Group::Flags, skin_tone: None, aliases: Some(&["united_arab_emirates"]), variations: &[] },
    Emoji { id: 2979, emoji: "🇦🇫", name: "flag: Afghanistan", group: Group::Flags, skin_tone: None, aliases: Some(&["afghanistan"]), variations: &[] },
    Emoji { id: 2980, emoji: "🇦🇬", name: "flag: Antigua & Barbuda", group: Group::Flags, skin_tone: None, aliases: Some(&["antigua_barbuda"]), variations: &[] },
    Emoji { id: 2981, emoji: "🇦🇮", name: "flag: Anguilla", group: Group::Flags, skin_tone: None, aliases: Some(&["anguilla"]), variations: &[] },
    Emoji { id: 2982, emoji: "🇦🇱", name: "flag: Albania", group: Group::Flags, skin_tone: None, aliases: Some(&["albania"]), variations: &[] },
    Emoji { id: 2983, emoji: "🇦🇲", name: "flag: Armenia", group: Group::Flags, skin_tone: None, aliases: Some(&["armenia"]), variations: &[] },
    Emoji { id: 2984, emoji: "🇦🇴", name: "flag: Angola", group: Group::Flags, skin_tone: None, aliases: Some(&["angola"]), variations: &[] },
    Emoji { id: 2985, emoji: "🇦🇶", name: "flag: Antarctica", group: Group::Flags, skin_tone: None, aliases: Some(&["antarctica"]), variations: &[] },
    Emoji { id: 2986, emoji: "🇦🇷", name: "flag: Argentina", group: Group::Flags, skin_tone: None, aliases: Some(&["argentina"]), variations: &[] },
    Emoji { id: 2987, emoji: "🇦🇸", name: "flag: American Samoa", group: Group::Flags, skin_tone: None, aliases: Some(&["american_samoa"]), variations: &[] },
    Emoji { id: 2988, emoji: "🇦🇹", name: "flag: Austria", group: Group::Flags, skin_tone: None, aliases: Some(&["austria"]), variations: &[] },
    Emoji { id: 2989, emoji: "🇦🇺", name: "flag: Australia", group: Group::Flags, skin_tone: None, aliases: Some(&["australia"]), variations: &[] },
    Emoji { id: 2990, emoji: "🇦🇼", name: "flag: Aruba", group: Group::Flags, skin_tone: None, aliases: Some(&["aruba"]), variations: &[] },
    Emoji { id: 2991, emoji: "🇦🇽", name: "flag: Åland Islands", group: Group::Flags, skin_tone: None, aliases: Some(&["aland_islands"]), variations: &[] },
    Emoji { id: 2992, emoji: "🇦🇿", name: "flag: Azerbaijan", group: Group::Flags, skin_tone: None, aliases: Some(&["azerbaijan"]), variations: &[] },
    Emoji { id: 2993, emoji: "🇧🇦", name: "flag: Bosnia & Herzegovina", group: Group::Flags, skin_tone: None, aliases: Some(&["bosnia_herzegovina"]), variations: &[] },
    Emoji { id: 2994, emoji: "🇧🇧", name: "flag: Barbados", group: Group::Flags, skin_tone: None, aliases: Some(&["barbados"]), variations: &[] },
    Emoji { id: 2995, emoji: "🇧🇩", name: "flag: Bangladesh", group: Group::Flags, skin_tone: None, aliases: Some(&["bangladesh"]), variations: &[] },
    Emoji { id: 2996, emoji: "🇧🇪", name: "flag: Belgium", group: Group::Flags, skin_tone: None, aliases: Some(&["belgium"]), variations: &[] },
    Emoji { id: 2997, emoji: "🇧🇫", name: "flag: Burkina Faso", group: Group::Flags, skin_tone: None, aliases: Some(&["burkina_faso"]), variations: &[] },
    Emoji { id: 2998, emoji: "🇧🇬", name: "flag: Bulgaria", group: Group::Flags, skin_tone: None, aliases: Some(&["bulgaria"]), variations: &[] },
    Emoji { id: 2999, emoji: "🇧🇭", name: "flag: Bahrain", group: Group::Flags, skin_tone: None, aliases: Some(&["bahrain"]), variations: &[] },
    Emoji { id: 3000, emoji: "🇧🇮", name: "flag: Burundi", group: Group::Flags, skin_tone: None, aliases: Some(&["burundi"]), variations: &[] },
    Emoji { id: 3001, emoji: "🇧🇯", name: "flag: Benin", group: Group::Flags, skin_tone: None, aliases: Some(&["benin"]), variations: &[] },
    Emoji { id: 3002, emoji: "🇧🇱", name: "flag: St. Barthélemy", group: Group::Flags, skin_tone: None, aliases: Some(&["st_barthelemy"]), variations: &[] },
    Emoji { id: 3003, emoji: "🇧🇲", name: "flag: Bermuda", group: Group::Flags, skin_tone: None, aliases: Some(&["bermuda"]), variations: &[] },
    Emoji { id: 3004, emoji: "🇧🇳", name: "flag: Brunei", group: Group::Flags, skin_tone: None, aliases: Some(&["brunei"]), variations: &[] },
    Emoji { id: 3005, emoji: "🇧🇴", name: "flag: Bolivia", group: Group::Flags, skin_tone: None, aliases: Some(&["bolivia"]), variations: &[] },
    Emoji { id: 3006, emoji: "🇧🇶", name: "flag: Caribbean Netherlands", group: Group::Flags, skin_tone: None, aliases: Some(&["caribbean_netherlands"]), variations: &[] },
    Emoji { id: 3007, emoji: "🇧🇷", name: "flag: Brazil", group: Group::Flags, skin_tone: None, aliases: Some(&["brazil"]), variations: &[] },
    Emoji { id: 3008, emoji: "🇧🇸", name: "flag: Bahamas", group: Group::Flags, skin_tone: None, aliases: Some(&["bahamas"]), variations: &[] },
    Emoji { id: 3009, emoji: "🇧🇹", name: "flag: Bhutan", group: Group::Flags, skin_tone: None, aliases: Some(&["bhutan"]), variations: &[] },
    Emoji { id: 3010, emoji: "🇧🇻", name: "flag: Bouvet Island", group: Group::Flags, skin_tone: None, aliases: Some(&["bouvet_island"]), variations: &[] },
    Emoji { id: 3011, emoji: "🇧🇼", name: "flag: Botswana", group: Group::Flags, skin_tone: None, aliases: Some(&["botswana"]), variations: &[] },
    Emoji { id: 3012, emoji: "🇧🇾", name: "flag: Belarus", group: Group::Flags, skin_tone: None, aliases: Some(&["belarus"]), variations: &[] },
    Emoji { id: 3013, emoji: "🇧🇿", name: "flag: Belize", group: Group::Flags, skin_tone: None, aliases: Some(&["belize"]), variations: &[] },
    Emoji { id: 3014, emoji: "🇨🇦", name: "flag: Canada", group: Group::Flags, skin_tone: None, aliases: Some(&["canada"]), variations: &[] },
    Emoji { id: 3015, emoji: "🇨🇨", name: "flag: Cocos (Keeling) Islands", group: Group::Flags, skin_tone: None, aliases: Some(&["cocos_islands"]), variations: &[] },
    Emoji { id: 3016, emoji: "🇨🇩", name: "flag: Congo - Kinshasa", group: Group::Flags, skin_tone: None, aliases: Some(&["congo_kinshasa"]), variations: &[] },
    Emoji { id: 3017, emoji: "🇨🇫", name: "flag: Central African Republic", group: Group::Flags, skin_tone: None, aliases: Some(&["central_african_republic"]), variations: &[] },
    Emoji { id: 3018, emoji: "🇨🇬", name: "flag: Congo - Brazzaville", group: Group::Flags, skin_tone: None, aliases: Some(&["congo_brazzaville"]), variations: &[] },
    Emoji { id: 3019, emoji: "🇨🇭", name: "flag: Switzerland", group: Group::Flags, skin_tone: None, aliases: Some(&["switzerland"]), variations: &[] },
    Emoji { id: 3020, emoji: "🇨🇮", name: "flag: Côte d’Ivoire", group: Group::Flags, skin_tone: None, aliases: Some(&["cote_divoire"]), variations: &[] },
    Emoji { id: 3021, emoji: "🇨🇰", name: "flag: Cook Islands", group: Group::Flags, skin_tone: None, aliases: Some(&["cook_islands"]), variations: &[] },
    Emoji { id: 3022, emoji: "🇨🇱", name: "flag: Chile", group: Group::Flags, skin_tone: None, aliases: Some(&["chile"]), variations: &[] },
    Emoji { id: 3023, emoji: "🇨🇲", name: "flag: Cameroon", group: Group::Flags, skin_tone: None, aliases: Some(&["cameroon"]), variations: &[] },
    Emoji { id: 3024, emoji: "🇨🇳", name: "flag: China", group: Group::Flags, skin_tone: None, aliases: Some(&["cn"]), variations: &[] },
    Emoji { id: 3025, emoji: "🇨🇴", name: "flag: Colombia", group: Group::Flags, skin_tone: None, aliases: Some(&["colombia"]), variations: &[] },
    Emoji { id: 3026, emoji: "🇨🇵", name: "flag: Clipperton Island", group: Group::Flags, skin_tone: None, aliases: Some(&["clipperton_island"]), variations: &[] },
    Emoji { id: 3027, emoji: "🇨🇷", name: "flag: Costa Rica", group: Group::Flags, skin_tone: None, aliases: Some(&["costa_rica"]), variations: &[] },
    Emoji { id: 3028, emoji: "🇨🇺", name: "flag: Cuba", group: Group::Flags, skin_tone: None, aliases: Some(&["cuba"]), variations: &[] },
    Emoji { id: 3029, emoji: "🇨🇻", name: "flag: Cape Verde", group: Group::Flags, skin_tone: None, aliases: Some(&["cape_verde"]), variations: &[] },
    Emoji { id: 3030, emoji: "🇨🇼", name: "flag: Curaçao", group: Group::Flags, skin_tone: None, aliases: Some(&["curacao"]), variations: &[] },
    Emoji { id: 3031, emoji: "🇨🇽", name: "flag: Christmas Island", group: Group::Flags, skin_tone: None, aliases: Some(&["christmas_island"]), variations: &[] },
    Emoji { id: 3032, emoji: "🇨🇾", name: "flag: Cyprus", group: Group::Flags, skin_tone: None, aliases: Some(&["cyprus"]), variations: &[] },
    Emoji { id: 3033, emoji: "🇨🇿", name: "flag: Czechia", group: Group::Flags, skin_tone: None, aliases: Some(&["czech_republic"]), variations: &[] },
    Emoji { id: 3034, emoji: "🇩🇪", name: "flag: Germany", group: Group::Flags, skin_tone: None, aliases: Some(&["de"]), variations: &[] },
    Emoji { id: 3035, emoji: "🇩🇬", name: "flag: Diego Garcia", group: Group::Flags, skin_tone: None, aliases: Some(&["diego_garcia"]), variations: &[] },
    Emoji { id: 3036, emoji: "🇩🇯", name: "flag: Djibouti", group: Group::Flags, skin_tone: None, aliases: Some(&["djibouti"]), variations: &[] },
    Emoji { id: 3037, emoji: "🇩🇰", name: "flag: Denmark", group: Group::Flags, skin_tone: None, aliases: Some(&["denmark"]), variations: &[] },
    Emoji { id: 3038, emoji: "🇩🇲", name: "flag: Dominica", group: Group::Flags, skin_tone: None, aliases: Some(&["dominica"]), variations: &[] },
    Emoji { id: 3039, emoji: "🇩🇴", name: "flag: Dominican Republic", group: Group::Flags, skin_tone: None, aliases: Some(&["dominican_republic"]), variations: &[] },
    Emoji { id: 3040, emoji: "🇩🇿", name: "flag: Algeria", group: Group::Flags, skin_tone: None, aliases: Some(&["algeria"]), variations: &[] },
    Emoji { id: 3041, emoji: "🇪🇦", name: "flag: Ceuta & Melilla", group: Group::Flags, skin_tone: None, aliases: Some(&["ceuta_melilla"]), variations: &[] },
    Emoji { id: 3042, emoji: "🇪🇨", name: "flag: Ecuador", group: Group::Flags, skin_tone: None, aliases: Some(&["ecuador"]), variations: &[] },
    Emoji { id: 3043, emoji: "🇪🇪", name: "flag: Estonia", group: Group::Flags, skin_tone: None, aliases: Some(&["estonia"]), variations: &[] },
    Emoji { id: 3044, emoji: "🇪🇬", name: "flag: Egypt", group: Group::Flags, skin_tone: None, aliases: Some(&["egypt"]), variations: &[] },
    Emoji { id: 3045, emoji: "🇪🇭", name: "flag: Western Sahara", group: Group::Flags, skin_tone: None, aliases: Some(&["western_sahara"]), variations: &[] },
    Emoji { id: 3046, emoji: "🇪🇷", name: "flag: Eritrea", group: Group::Flags, skin_tone: None, aliases: Some(&["eritrea"]), variations: &[] },
    Emoji { id: 3047, emoji: "🇪🇸", name: "flag: Spain", group: Group::Flags, skin_tone: None, aliases: Some(&["es"]), variations: &[] },
    Emoji { id: 3048, emoji: "🇪🇹", name: "flag: Ethiopia", group: Group::Flags, skin_tone: None, aliases: Some(&["ethiopia"]), variations: &[] },
    Emoji { id: 3049, emoji: "🇪🇺", name: "flag: European Union", group: Group::Flags, skin_tone: None, aliases: Some(&["eu", "european_union"]), variations: &[] },
    Emoji { id: 3050, emoji: "🇫🇮", name: "flag: Finland", group: Group::Flags, skin_tone: None, aliases: Some(&["finland"]), variations: &[] },
    Emoji { id: 3051, emoji: "🇫🇯", name: "flag: Fiji", group: Group::Flags, skin_tone: None, aliases: Some(&["fiji"]), variations: &[] },
    Emoji { id: 3052, emoji: "🇫🇰", name: "flag: Falkland Islands", group: Group::Flags, skin_tone: None, aliases: Some(&["falkland_islands"]), variations: &[] },
    Emoji { id: 3053, emoji: "🇫🇲", name: "flag: Micronesia", group: Group::Flags, skin_tone: None, aliases: Some(&["micronesia"]), variations: &[] },
    Emoji { id: 3054, emoji: "🇫🇴", name: "flag: Faroe Islands", group: Group::Flags, skin_tone: None, aliases: Some(&["faroe_islands"]), variations: &[] },
    Emoji { id: 3055, emoji: "🇫🇷", name: "flag: France", group: Group::Flags, skin_tone: None, aliases: Some(&["fr"]), variations: &[] },
    Emoji { id: 3056, emoji: "🇬🇦", name: "flag: Gabon", group: Group::Flags, skin_tone: None, aliases: Some(&["gabon"]), variations: &[] },
    Emoji { id: 3057, emoji: "🇬🇧", name: "flag: United Kingdom", group: Group::Flags, skin_tone: None, aliases: Some(&["gb", "uk"]), variations: &[] },
    Emoji { id: 3058, emoji: "🇬🇩", name: "flag: Grenada", group: Group::Flags, skin_tone: None, aliases: Some(&["grenada"]), variations: &[] },
    Emoji { id: 3059, emoji: "🇬🇪", name: "flag: Georgia", group: Group::Flags, skin_tone: None, aliases: Some(&["georgia"]), variations: &[] },
    Emoji { id: 3060, emoji: "🇬🇫", name: "flag: French Guiana", group: Group::Flags, skin_tone: None, aliases: Some(&["french_guiana"]), variations: &[] },
    Emoji { id: 3061, emoji: "🇬🇬", name: "flag: Guernsey", group: Group::Flags, skin_tone: None, aliases: Some(&["guernsey"]), variations: &[] },
    Emoji { id: 3062, emoji: "🇬🇭", name: "flag: Ghana", group: Group::Flags, skin_tone: None, aliases: Some(&["ghana"]), variations: &[] },
    Emoji { id: 3063, emoji: "🇬🇮", name: "flag: Gibraltar", group: Group::Flags, skin_tone: None, aliases: Some(&["gibraltar"]), variations: &[] },
    Emoji { id: 3064, emoji: "🇬🇱", name: "flag: Greenland", group: Group::Flags, skin_tone: None, aliases: Some(&["greenland"]), variations: &[] },
    Emoji { id: 3065, emoji: "🇬🇲", name: "flag: Gambia", group: Group::Flags, skin_tone: None, aliases: Some(&["gambia"]), variations: &[] },
    Emoji { id: 3066, emoji: "🇬🇳", name: "flag: Guinea", group: Group::Flags, skin_tone: None, aliases: Some(&["guinea"]), variations: &[] },
    Emoji { id: 3067, emoji: "🇬🇵", name: "flag: Guadeloupe", group: Group::Flags, skin_tone: None, aliases: Some(&["guadeloupe"]), variations: &[] },
    Emoji { id: 3068, emoji: "🇬🇶", name: "flag: Equatorial Guinea", group: Group::Flags, skin_tone: None, aliases: Some(&["equatorial_guinea"]), variations: &[] },
    Emoji { id: 3069, emoji: "🇬🇷", name: "flag: Greece", group: Group::Flags, skin_tone: None, aliases: Some(&["greece"]), variations: &[] },
    Emoji { id: 3070, emoji: "🇬🇸", name: "flag: South Georgia & South Sandwich Islands", group: Group::Flags, skin_tone: None, aliases: Some(&["south_georgia_south_sandwich_islands"]), variations: &[] },
    Emoji { id: 3071, emoji: "🇬🇹", name: "flag: Guatemala", group: Group::Flags, skin_tone: None, aliases: Some(&["guatemala"]), variations: &[] },
    Emoji { id: 3072, emoji: "🇬🇺", name: "flag: Guam", group: Group::Flags, skin_tone: None, aliases: Some(&["guam"]), variations: &[] },
    Emoji { id: 3073, emoji: "🇬🇼", name: "flag: Guinea-Bissau", group: Group::Flags, skin_tone: None, aliases: Some(&["guinea_bissau"]), variations: &[] },
    Emoji { id: 3074, emoji: "🇬🇾", name: "flag: Guyana", group: Group::Flags, skin_tone: None, aliases: Some(&["guyana"]), variations: &[] },
    Emoji { id: 3075, emoji: "🇭🇰", name: "flag: Hong Kong SAR China", group: Group::Flags, skin_tone: None, aliases: Some(&["hong_kong"]), variations: &[] },
    Emoji { id: 3076, emoji: "🇭🇲", name: "flag: Heard & McDonald Islands", group: Group::Flags, skin_tone: None, aliases: Some(&["heard_mcdonald_islands"]), variations: &[] },
    Emoji { id: 3077, emoji: "🇭🇳", name: "flag: Honduras", group: Group::Flags, skin_tone: None, aliases: Some(&["honduras"]), variations: &[] },
    Emoji { id: 3078, emoji: "🇭🇷", name: "flag: Croatia", group: Group::Flags, skin_tone: None, aliases: Some(&["croatia"]), variations: &[] },
    Emoji { id: 3079, emoji: "🇭🇹", name: "flag: Haiti", group: Group::Flags, skin_tone: None, aliases: Some(&["haiti"]), variations: &[] },
    Emoji { id: 3080, emoji: "🇭🇺", name: "flag: Hungary", group: Group::Flags, skin_tone: None, aliases: Some(&["hungary"]), variations: &[] },
    Emoji { id: 3081, emoji: "🇮🇨", name: "flag: Canary Islands", group: Group::Flags, skin_tone: None, aliases: Some(&["canary_islands"]), variations: &[] },
    Emoji { id: 3082, emoji: "🇮🇩", name: "flag: Indonesia", group: Group::Flags, skin_tone: None, aliases: Some(&["indonesia"]), variations: &[] },
    Emoji { id: 3083, emoji: "🇮🇪", name: "flag: Ireland", group: Group::Flags, skin_tone: None, aliases: Some(&["ireland"]), variations: &[] },
    Emoji { id: 3084, emoji: "🇮🇱", name: "flag: Israel", group: Group::Flags, skin_tone: None, aliases: Some(&["israel"]), variations: &[] },
    Emoji { id: 3085, emoji: "🇮🇲", name: "flag: Isle of Man", group: Group::Flags, skin_tone: None, aliases: Some(&["isle_of_man"]), variations: &[] },
    Emoji { id: 3086, emoji: "🇮🇳", name: "flag: India", group: Group::Flags, skin_tone: None, aliases: Some(&["india"]), variations: &[] },
    Emoji { id: 3087, emoji: "🇮🇴", name: "flag: British Indian Ocean Territory", group: Group::Flags, skin_tone: None, aliases: Some(&["british_indian_ocean_territory"]), variations: &[] },
    Emoji { id: 3088, emoji: "🇮🇶", name: "flag: Iraq", group: Group::Flags, skin_tone: None, aliases: Some(&["iraq"]), variations: &[] },
    Emoji { id: 3089, emoji: "🇮🇷", name: "flag: Iran", group: Group::Flags, skin_tone: None, aliases: Some(&["iran"]), variations: &[] },
    Emoji { id: 3090, emoji: "🇮🇸", name: "flag: Iceland", group: Group::Flags, skin_tone: None, aliases: Some(&["iceland"]), variations: &[] },
    Emoji { id: 3091, emoji: "🇮🇹", name: "flag: Italy", group: Group::Flags, skin_tone: None, aliases: Some(&["it"]), variations: &[] },
    Emoji { id: 3092, emoji: "🇯🇪", name: "flag: Jersey", group: Group::Flags, skin_tone: None, aliases: Some(&["jersey"]), variations: &[] },
    Emoji { id: 3093, emoji: "🇯🇲", name: "flag: Jamaica", group: Group::Flags, skin_tone: None, aliases: Some(&["jamaica"]), variations: &[] },
    Emoji { id: 3094, emoji: "🇯🇴", name: "flag: Jordan", group: Group::Flags, skin_tone: None, aliases: Some(&["jordan"]), variations: &[] },
    Emoji { id: 3095, emoji: "🇯🇵", name: "flag: Japan", group: Group::Flags, skin_tone: None, aliases: Some(&["jp"]), variations: &[] },
    Emoji { id: 3096, emoji: "🇰🇪", name: "flag: Kenya", group: Group::Flags, skin_tone: None, aliases: Some(&["kenya"]), variations: &[] },
    Emoji { id: 3097, emoji: "🇰🇬", name: "flag: Kyrgyzstan", group: Group::Flags, skin_tone: None, aliases: Some(&["kyrgyzstan"]), variations: &[] },
    Emoji { id: 3098, emoji: "🇰🇭", name: "flag: Cambodia", group: Group::Flags, skin_tone: None, aliases: Some(&["cambodia"]), variations: &[] },
    Emoji { id: 3099, emoji: "🇰🇮", name: "flag: Kiribati", group: Group::Flags, skin_tone: None, aliases: Some(&["kiribati"]), variations: &[] },
    Emoji { id: 3100, emoji: "🇰🇲", name: "flag: Comoros", group: Group::Flags, skin_tone: None, aliases: Some(&["comoros"]), variations: &[] },
    Emoji { id: 3101, emoji: "🇰🇳", name: "flag: St. Kitts & Nevis", group: Group::Flags, skin_tone: None, aliases: Some(&["st_kitts_nevis"]), variations: &[] },
    Emoji { id: 3102, emoji: "🇰🇵", name: "flag: North Korea", group: Group::Flags, skin_tone: None, aliases: Some(&["north_korea"]), variations: &[] },
    Emoji { id: 3103, emoji: "🇰🇷", name: "flag: South Korea", group: Group::Flags, skin_tone: None, aliases: Some(&["kr"]), variations: &[] },
    Emoji { id: 3104, emoji: "🇰🇼", name: "flag: Kuwait", group: Group::Flags, skin_tone: None, aliases: Some(&["kuwait"]), variations: &[] },
    Emoji { id: 3105, emoji: "🇰🇾", name: "flag: Cayman Islands", group: Group::Flags, skin_tone: None, aliases: Some(&["cayman_islands"]), variations: &[] },
    Emoji { id: 3106, emoji: "🇰🇿", name: "flag: Kazakhstan", group: Group::Flags, skin_tone: None, aliases: Some(&["kazakhstan"]), variations: &[] },
    Emoji { id: 3107, emoji: "🇱🇦", name: "flag: Laos", group: Group::Flags, skin_tone: None, aliases: Some(&["laos"]), variations: &[] },
    Emoji { id: 3108, emoji: "🇱🇧", name: "flag: Lebanon", group: Group::Flags, skin_tone: None, aliases: Some(&["lebanon"]), variations: &[] },
    Emoji { id: 3109, emoji: "🇱🇨", name: "flag: St. Lucia", group: Group::Flags, skin_tone: None, aliases: Some(&["st_lucia"]), variations: &[] },
    Emoji { id: 3110, emoji: "🇱🇮", name: "flag: Liechtenstein", group: Group::Flags, skin_tone: None, aliases: Some(&["liechtenstein"]), variations: &[] },
    Emoji { id: 3111, emoji: "🇱🇰", name: "flag: Sri Lanka", group: Group::Flags, skin_tone: None, aliases: Some(&["sri_lanka"]), variations: &[] },
    Emoji { id: 3112, emoji: "🇱🇷", name: "flag: Liberia", group: Group::Flags, skin_tone: None, aliases: Some(&["liberia"]), variations: &[] },
    Emoji { id: 3113, emoji: "🇱🇸", name: "flag: Lesotho", group: Group::Flags, skin_tone: None, aliases: Some(&["lesotho"]), variations: &[] },
    Emoji { id: 3114, emoji: "🇱🇹", name: "flag: Lithuania", group: Group::Flags, skin_tone: None, aliases: Some(&["lithuania"]), variations: &[] },
    Emoji { id: 3115, emoji: "🇱🇺", name: "flag: Luxembourg", group: Group::Flags, skin_tone: None, aliases: Some(&["luxembourg"]), variations: &[] },
    Emoji { id: 3116, emoji: "🇱🇻", name: "flag: Latvia", group: Group::Flags, skin_tone: None, aliases: Some(&["latvia"]), variations: &[] },
    Emoji { id: 3117, emoji: "🇱🇾", name: "flag: Libya", group: Group::Flags, skin_tone: None, aliases: Some(&["libya"]), variations: &[] },
    Emoji { id: 3118, emoji: "🇲🇦", name: "flag: Morocco", group: Group::Flags, skin_tone: None, aliases: Some(&["morocco"]), variations: &[] },
    Emoji { id: 3119, emoji: "🇲🇨", name: "flag: Monaco", group: Group::Flags, skin_tone: None, aliases: Some(&["monaco"]), variations: &[] },
    Emoji { id: 3120, emoji: "🇲🇩", name: "flag: Moldova", group: Group::Flags, skin_tone: None, aliases: Some(&["moldova"]), variations: &[] },
    Emoji { id: 3121, emoji: "🇲🇪", name: "flag: Montenegro", group: Group::Flags, skin_tone: None, aliases: Some(&["montenegro"]), variations: &[] },
    Emoji { id: 3122, emoji: "🇲🇫", name: "flag: St. Martin", group: Group::Flags, skin_tone: None, aliases: Some(&["st_martin"]), variations: &[] },
    Emoji { id: 3123, emoji: "🇲🇬", name: "flag: Madagascar", group: Group::Flags, skin_tone: None, aliases: Some(&["madagascar"]), variations: &[] },
    Emoji { id: 3124, emoji: "🇲🇭", name: "flag: Marshall Islands", group: Group::Flags, skin_tone: None, aliases: Some(&["marshall_islands"]), variations: &[] },
    Emoji { id: 3125, emoji: "🇲🇰", name: "flag: North Macedonia", group: Group::Flags, skin_tone: None, aliases: Some(&["macedonia"]), variations: &[] },
    Emoji { id: 3126, emoji: "🇲🇱", name: "flag: Mali", group: Group::Flags, skin_tone: None, aliases: Some(&["mali"]), variations: &[] },
    Emoji { id: 3127, emoji: "🇲🇲", name: "flag: Myanmar (Burma)", group: Group::Flags, skin_tone: None, aliases: Some(&["myanmar"]), variations: &[] },
    Emoji { id: 3128, emoji: "🇲🇳", name: "flag: Mongolia", group: Group::Flags, skin_tone: None, aliases: Some(&["mongolia"]), variations: &[] },
    Emoji { id: 3129, emoji: "🇲🇴", name: "flag: Macao SAR China", group: Group::Flags, skin_tone: None, aliases: Some(&["macau"]), variations: &[] },
    Emoji { id: 3130, emoji: "🇲🇵", name: "flag: Northern Mariana Islands", group: Group::Flags, skin_tone: None, aliases: Some(&["northern_mariana_islands"]), variations: &[] },
    Emoji { id: 3131, emoji: "🇲🇶", name: "flag: Martinique", group: Group::Flags, skin_tone: None, aliases: Some(&["martinique"]), variations: &[] },
    Emoji { id: 3132, emoji: "🇲🇷", name: "flag: Mauritania", group: Group::Flags, skin_tone: None, aliases: Some(&["mauritania"]), variations: &[] },
    Emoji { id: 3133, emoji: "🇲🇸", name: "flag: Montserrat", group: Group::Flags, skin_tone: None, aliases: Some(&["montserrat"]), variations: &[] },
    Emoji { id: 3134, emoji: "🇲🇹", name: "flag: Malta", group: Group::Flags, skin_tone: None, aliases: Some(&["malta"]), variations: &[] },
    Emoji { id: 3135, emoji: "🇲🇺", name: "flag: Mauritius", group: Group::Flags, skin_tone: None, aliases: Some(&["mauritius"]), variations: &[] },
    Emoji { id: 3136, emoji: "🇲🇻", name: "flag: Maldives", group: Group::Flags, skin_tone: None, aliases: Some(&["maldives"]), variations: &[] },
    Emoji { id: 3137, emoji: "🇲🇼", name: "flag: Malawi", group: Group::Flags, skin_tone: None, aliases: Some(&["malawi"]), variations: &[] },
    Emoji { id: 3138, emoji: "🇲🇽", name: "flag: Mexico", group: Group::Flags, skin_tone: None, aliases: Some(&["mexico"]), variations: &[] },
    Emoji { id: 3139, emoji: "🇲🇾", name: "flag: Malaysia", group: Group::Flags, skin_tone: None, aliases: Some(&["malaysia"]), variations: &[] },
    Emoji { id: 3140, emoji: "🇲🇿", name: "flag: Mozambique", group: Group::Flags, skin_tone: None, aliases: Some(&["mozambique"]), variations: &[] },
    Emoji { id: 3141, emoji: "🇳🇦", name: "flag: Namibia", group: Group::Flags, skin_tone: None, aliases: Some(&["namibia"]), variations: &[] },
    Emoji { id: 3142, emoji: "🇳🇨", name: "flag: New Caledonia", group: Group::Flags, skin_tone: None, aliases: Some(&["new_caledonia"]), variations: &[] },
    Emoji { id: 3143, emoji: "🇳🇪", name: "flag: Niger", group: Group::Flags, skin_tone: None, aliases: Some(&["niger"]), variations: &[] },
    Emoji { id: 3144, emoji: "🇳🇫", name: "flag: Norfolk Island", group: Group::Flags, skin_tone: None, aliases: Some(&["norfolk_island"]), variations: &[] },
    Emoji { id: 3145, emoji: "🇳🇬", name: "flag: Nigeria", group: Group::Flags, skin_tone: None, aliases: Some(&["nigeria"]), variations: &[] },
    Emoji { id: 3146, emoji: "🇳🇮", name: "flag: Nicaragua", group: Group::Flags, skin_tone: None, aliases: Some(&["nicaragua"]), variations: &[] },
    Emoji { id: 3147, emoji: "🇳🇱", name: "flag: Netherlands", group: Group::Flags, skin_tone: None, aliases: Some(&["netherlands"]), variations: &[] },
    Emoji { id: 3148, emoji: "🇳🇴", name: "flag: Norway", group: Group::Flags, skin_tone: None, aliases: Some(&["norway"]), variations: &[] },
    Emoji { id: 3149, emoji: "🇳🇵", name: "flag: Nepal", group: Group::Flags, skin_tone: None, aliases: Some(&["nepal"]), variations: &[] },
    Emoji { id: 3150, emoji: "🇳🇷", name: "flag: Nauru", group: Group::Flags, skin_tone: None, aliases: Some(&["nauru"]), variations: &[] },
    Emoji { id: 3151, emoji: "🇳🇺", name: "flag: Niue", group: Group::Flags, skin_tone: None, aliases: Some(&["niue"]), variations: &[] },
    Emoji { id: 3152, emoji: "🇳🇿", name: "flag: New Zealand", group: Group::Flags, skin_tone: None, aliases: Some(&["new_zealand"]), variations: &[] },
    Emoji { id: 3153, emoji: "🇴🇲", name: "flag: Oman", group: Group::Flags, skin_tone: None, aliases: Some(&["oman"]), variations: &[] },
    Emoji { id: 3154, emoji: "🇵🇦", name: "flag: Panama", group: Group::Flags, skin_tone: None, aliases: Some(&["panama"]), variations: &[] },
    Emoji { id: 3155, emoji: "🇵🇪", name: "flag: Peru", group: Group::Flags, skin_tone: None, aliases: Some(&["peru"]), variations: &[] },
    Emoji { id: 3156, emoji: "🇵🇫", name: "flag: French Polynesia", group: Group::Flags, skin_tone: None, aliases: Some(&["french_polynesia"]), variations: &[] },
    Emoji { id: 3157, emoji: "🇵🇬", name: "flag: Papua New Guinea", group: Group::Flags, skin_tone: None, aliases: Some(&["papua_new_guinea"]), variations: &[] },
    Emoji { id: 3158, emoji: "🇵🇭", name: "flag: Philippines", group: Group::Flags, skin_tone: None, aliases: Some(&["philippines"]), variations: &[] },
    Emoji { id: 3159, emoji: "🇵🇰", name: "flag: Pakistan", group: Group::Flags, skin_tone: None, aliases: Some(&["pakistan"]), variations: &[] },
    Emoji { id: 3160, emoji: "🇵🇱", name: "flag: Poland", group: Group::Flags, skin_tone: None, aliases: Some(&["poland"]), variations: &[] },
    Emoji { id: 3161, emoji: "🇵🇲", name: "flag: St. Pierre & Miquelon", group: Group::Flags, skin_tone: None, aliases: Some(&["st_pierre_miquelon"]), variations: &[] },
    Emoji { id: 3162, emoji: "🇵🇳", name: "flag: Pitcairn Islands", group: Group::Flags, skin_tone: None, aliases: Some(&["pitcairn_islands"]), variations: &[] },
    Emoji { id: 3163, emoji: "🇵🇷", name: "flag: Puerto Rico", group: Group::Flags, skin_tone: None, aliases: Some(&["puerto_rico"]), variations: &[] },
    Emoji { id: 3164, emoji: "🇵🇸", name: "flag: Palestinian Territories", group: Group::Flags, skin_tone: None, aliases: Some(&["palestinian_territories"]), variations: &[] },
    Emoji { id: 3165, emoji: "🇵🇹", name: "flag: Portugal", group: Group::Flags, skin_tone: None, aliases: Some(&["portugal"]), variations: &[] },
    Emoji { id: 3166, emoji: "🇵🇼", name: "flag: Palau", group: Group::Flags, skin_tone: None, aliases: Some(&["palau"]), variations: &[] },
    Emoji { id: 3167, emoji: "🇵🇾", name: "flag: Paraguay", group: Group::Flags, skin_tone: None, aliases: Some(&["paraguay"]), variations: &[] },
    Emoji { id: 3168, emoji: "🇶🇦", name: "flag: Qatar", group: Group::Flags, skin_tone: None, aliases: Some(&["qatar"]), variations: &[] },
    Emoji { id: 3169, emoji: "🇷🇪", name: "flag: Réunion", group: Group::Flags, skin_tone: None, aliases: Some(&["reunion"]), variations: &[] },
    Emoji { id: 3170, emoji: "🇷🇴", name: "flag: Romania", group: Group::Flags, skin_tone: None, aliases: Some(&["romania"]), variations: &[] },
    Emoji { id: 3171, emoji: "🇷🇸", name: "flag: Serbia", group: Group::Flags, skin_tone: None, aliases: Some(&["serbia"]), variations: &[] },
    Emoji { id: 3172, emoji: "🇷🇺", name: "flag: Russia", group: Group::Flags, skin_tone: None, aliases: Some(&["ru"]), variations: &[] },
    Emoji { id: 3173, emoji: "🇷🇼", name: "flag: Rwanda", group: Group::Flags, skin_tone: None, aliases: Some(&["rwanda"]), variations: &[] },
    Emoji { id: 3174, emoji: "🇸🇦", name: "flag: Saudi Arabia", group: Group::Flags, skin_tone: None, aliases: Some(&["saudi_arabia"]), variations: &[] },
    Emoji { id: 3175, emoji: "🇸🇧", name: "flag: Solomon Islands", group: Group::Flags, skin_tone: None, aliases: Some(&["solomon_islands"]), variations: &[] },
    Emoji { id: 3176, emoji: "🇸🇨", name: "flag: Seychelles", group: Group::Flags, skin_tone: None, aliases: Some(&["seychelles"]), variations: &[] },
    Emoji { id: 3177, emoji: "🇸🇩", name: "flag: Sudan", group: Group::Flags, skin_tone: None, aliases: Some(&["sudan"]), variations: &[] },
    Emoji { id: 3178, emoji: "🇸🇪", name: "flag: Sweden", group: Group::Flags, skin_tone: None, aliases: Some(&["sweden"]), variations: &[] },
    Emoji { id: 3179, emoji: "🇸🇬", name: "flag: Singapore", group: Group::Flags, skin_tone: None, aliases: Some(&["singapore"]), variations: &[] },
    Emoji { id: 3180, emoji: "🇸🇭", name: "flag: St. Helena", group: Group::Flags, skin_tone: None, aliases: Some(&["st_helena"]), variations: &[] },
    Emoji { id: 3181, emoji: "🇸🇮", name: "flag: Slovenia", group: Group::Flags, skin_tone: None, aliases: Some(&["slovenia"]), variations: &[] },
    Emoji { id: 3182, emoji: "🇸🇯", name: "flag: Svalbard & Jan Mayen", group: Group::Flags, skin_tone: None, aliases: Some(&["svalbard_jan_mayen"]), variations: &[] },
    Emoji { id: 3183, emoji: "🇸🇰", name: "flag: Slovakia", group: Group::Flags, skin_tone: None, aliases: Some(&["slovakia"]), variations: &[] },
    Emoji { id: 3184, emoji: "🇸🇱", name: "flag: Sierra Leone", group: Group::Flags, skin_tone: None, aliases: Some(&["sierra_leone"]), variations: &[] },
    Emoji { id: 3185, emoji: "🇸🇲", name: "flag: San Marino", group: Group::Flags, skin_tone: None, aliases: Some(&["san_marino"]), variations: &[] },
    Emoji { id: 3186, emoji: "🇸🇳", name: "flag: Senegal", group: Group::Flags, skin_tone: None, aliases: Some(&["senegal"]), variations: &[] },
    Emoji { id: 3187, emoji: "🇸🇴", name: "flag: Somalia", group: Group::Flags, skin_tone: None, aliases: Some(&["somalia"]), variations: &[] },
    Emoji { id: 3188, emoji: "🇸🇷", name: "flag: Suriname", group: Group::Flags, skin_tone: None, aliases: Some(&["suriname"]), variations: &[] },
    Emoji { id: 3189, emoji: "🇸🇸", name: "flag: South Sudan", group: Group::Flags, skin_tone: None, aliases: Some(&["south_sudan"]), variations: &[] },
    Emoji { id: 3190, emoji: "🇸🇹", name: "flag: São Tomé & Príncipe", group: Group::Flags, skin_tone: None, aliases: Some(&["sao_tome_principe"]), variations: &[] },
    Emoji { id: 3191, emoji: "🇸🇻", name: "flag: El Salvador", group: Group::Flags, skin_tone: None, aliases: Some(&["el_salvador"]), variations: &[] },
    Emoji { id: 3192, emoji: "🇸🇽", name: "flag: Sint Maarten", group: Group::Flags, skin_tone: None, aliases: Some(&["sint_maarten"]), variations: &[] },
    Emoji { id: 3193, emoji: "🇸🇾", name: "flag: Syria", group: Group::Flags, skin_tone: None, aliases: Some(&["syria"]), variations: &[] },
    Emoji { id: 3194, emoji: "🇸🇿", name: "flag: Eswatini", group: Group::Flags, skin_tone: None, aliases: Some(&["swaziland"]), variations: &[] },
    Emoji { id: 3195, emoji: "🇹🇦", name: "flag: Tristan da Cunha", group: Group::Flags, skin_tone: None, aliases: Some(&["tristan_da_cunha"]), variations: &[] },
    Emoji { id: 3196, emoji: "🇹🇨", name: "flag: Turks & Caicos Islands", group: Group::Flags, skin_tone: None, aliases: Some(&["turks_caicos_islands"]), variations: &[] },
    Emoji { id: 3197, emoji: "🇹🇩", name: "flag: Chad", group: Group::Flags, skin_tone: None, aliases: Some(&["chad"]), variations: &[] },
    Emoji { id: 3198, emoji: "🇹🇫", name: "flag: French Southern Territories", group: Group::Flags, skin_tone: None, aliases: Some(&["french_southern_territories"]), variations: &[] },
    Emoji { id: 3199, emoji: "🇹🇬", name: "flag: Togo", group: Group::Flags, skin_tone: None, aliases: Some(&["togo"]), variations: &[] },
    Emoji { id: 3200, emoji: "🇹🇭", name: "flag: Thailand", group: Group::Flags, skin_tone: None, aliases: Some(&["thailand"]), variations: &[] },
    Emoji { id: 3201, emoji: "🇹🇯", name: "flag: Tajikistan", group: Group::Flags, skin_tone: None, aliases: Some(&["tajikistan"]), variations: &[] },
    Emoji { id: 3202, emoji: "🇹🇰", name: "flag: Tokelau", group: Group::Flags, skin_tone: None, aliases: Some(&["tokelau"]), variations: &[] },
    Emoji { id: 3203, emoji: "🇹🇱", name: "flag: Timor-Leste", group: Group::Flags, skin_tone: None, aliases: Some(&["timor_leste"]), variations: &[] },
    Emoji { id: 3204, emoji: "🇹🇲", name: "flag: Turkmenistan", group: Group::Flags, skin_tone: None, aliases: Some(&["turkmenistan"]), variations: &[] },
    Emoji { id: 3205, emoji: "🇹🇳", name: "flag: Tunisia", group: Group::Flags, skin_tone: None, aliases: Some(&["tunisia"]), variations: &[] },
    Emoji { id: 3206, emoji: "🇹🇴", name: "flag: Tonga", group: Group::Flags, skin_tone: None, aliases: Some(&["tonga"]), variations: &[] },
    Emoji { id: 3207, emoji: "🇹🇷", name: "flag: Turkey", group: Group::Flags, skin_tone: None, aliases: Some(&["tr"]), variations: &[] },
    Emoji { id: 3208, emoji: "🇹🇹", name: "flag: Trinidad & Tobago", group: Group::Flags, skin_tone: None, aliases: Some(&["trinidad_tobago"]), variations: &[] },
    Emoji { id: 3209, emoji: "🇹🇻", name: "flag: Tuvalu", group: Group::Flags, skin_tone: None, aliases: Some(&["tuvalu"]), variations: &[] },
    Emoji { id: 3210, emoji: "🇹🇼", name: "flag: Taiwan", group: Group::Flags, skin_tone: None, aliases: Some(&["taiwan"]), variations: &[] },
    Emoji { id: 3211, emoji: "🇹🇿", name: "flag: Tanzania", group: Group::Flags, skin_tone: None, aliases: Some(&["tanzania"]), variations: &[] },
    Emoji { id: 3212, emoji: "🇺🇦", name: "flag: Ukraine", group: Group::Flags, skin_tone: None, aliases: Some(&["ukraine"]), variations: &[] },
    Emoji { id: 3213, emoji: "🇺🇬", name: "flag: Uganda", group: Group::Flags, skin_tone: None, aliases: Some(&["uganda"]), variations: &[] },
    Emoji { id: 3214, emoji: "🇺🇲", name: "flag: U.S. Outlying Islands", group: Group::Flags, skin_tone: None, aliases: Some(&["us_outlying_islands"]), variations: &[] },
    Emoji { id: 3215, emoji: "🇺🇳", name: "flag: United Nations", group: Group::Flags, skin_tone: None, aliases: Some(&["united_nations"]), variations: &[] },
    Emoji { id: 3216, emoji: "🇺🇸", name: "flag: United States", group: Group::Flags, skin_tone: None, aliases: Some(&["us"]), variations: &[] },
    Emoji { id: 3217, emoji: "🇺🇾", name: "flag: Uruguay", group: Group::Flags, skin_tone: None, aliases: Some(&["uruguay"]), variations: &[] },
    Emoji { id: 3218, emoji: "🇺🇿", name: "flag: Uzbekistan", group: Group::Flags, skin_tone: None, aliases: Some(&["uzbekistan"]), variations: &[] },
    Emoji { id: 3219, emoji: "🇻🇦", name: "flag: Vatican City", group: Group::Flags, skin_tone: None, aliases: Some(&["vatican_city"]), variations: &[] },
    Emoji { id: 3220, emoji: "🇻🇨", name: "flag: St. Vincent & Grenadines", group: Group::Flags, skin_tone: None, aliases: Some(&["st_vincent_grenadines"]), variations: &[] },
    Emoji { id: 3221, emoji: "🇻🇪", name: "flag: Venezuela", group: Group::Flags, skin_tone: None, aliases: Some(&["venezuela"]), variations: &[] },
    Emoji { id: 3222, emoji: "🇻🇬", name: "flag: British Virgin Islands", group: Group::Flags, skin_tone: None, aliases: Some(&["british_virgin_islands"]), variations: &[] },
    Emoji { id: 3223, emoji: "🇻🇮", name: "flag: U.S. Virgin Islands", group: Group::Flags, skin_tone: None, aliases: Some(&["us_virgin_islands"]), variations: &[] },
    Emoji { id: 3224, emoji: "🇻🇳", name: "flag: Vietnam", group: Group::Flags, skin_tone: None, aliases: Some(&["vietnam"]), variations: &[] },
    Emoji { id: 3225, emoji: "🇻🇺", name: "flag: Vanuatu", group: Group::Flags, skin_tone: None, aliases: Some(&["vanuatu"]), variations: &[] },
    Emoji { id: 3226, emoji: "🇼🇫", name: "flag: Wallis & Futuna", group: Group::Flags, skin_tone: None, aliases: Some(&["wallis_futuna"]), variations: &[] },
    Emoji { id: 3227, emoji: "🇼🇸", name: "flag: Samoa", group: Group::Flags, skin_tone: None, aliases: Some(&["samoa"]), variations: &[] },
    Emoji { id: 3228, emoji: "🇽🇰", name: "flag: Kosovo", group: Group::Flags, skin_tone: None, aliases: Some(&["kosovo"]), variations: &[] },
    Emoji { id: 3229, emoji: "🇾🇪", name: "flag: Yemen", group: Group::Flags, skin_tone: None, aliases: Some(&["yemen"]), variations: &[] },
    Emoji { id: 3230, emoji: "🇾🇹", name: "flag: Mayotte", group: Group::Flags, skin_tone: None, aliases: Some(&["mayotte"]), variations: &[] },
    Emoji { id: 3231, emoji: "🇿🇦", name: "flag: South Africa", group: Group::Flags, skin_tone: None, aliases: Some(&["south_africa"]), variations: &[] },
    Emoji { id: 3232, emoji: "🇿🇲", name: "flag: Zambia", group: Group::Flags, skin_tone: None, aliases: Some(&["zambia"]), variations: &[] },
    Emoji { id: 3233, emoji: "🇿🇼", name: "flag: Zimbabwe", group: Group::Flags, skin_tone: None, aliases: Some(&["zimbabwe"]), variations: &[] },
    Emoji { id: 3234, emoji: "🏴󠁧󠁢󠁥󠁮󠁧󠁿", name: "flag: England", group: Group::Flags, skin_tone: None, aliases: Some(&["england"]), variations: &[] },
    Emoji { id: 3235, emoji: "🏴󠁧󠁢󠁳󠁣󠁴󠁿", name: "flag: Scotland", group: Group::Flags, skin_tone: None, aliases: Some(&["scotland"]), variations: &[] },
    Emoji { id: 3236, emoji: "🏴󠁧󠁢󠁷󠁬󠁳󠁿", name: "flag: Wales", group: Group::Flags, skin_tone: None, aliases: Some(&["wales"]), variations: &[] },
];
