#[doc = "⚓"]
pub const ANCHOR: crate::Emoji = crate::Emoji {
    glyph: "⚓",
    codepoint: "2693",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "anchor",
    group: "Travel & Places",
    subgroup: "transport-water",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("anker"),
            keywords: &["anker", "skip"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("መልህቅ"),
            keywords: &["መልህቅ", "መሣሪያ", "መርከብ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("مرساة"),
            keywords: &["إشارة", "مرساة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("লংগৰ"),
            keywords: &["জ\u{9be}হ\u{9be}জ", "লংগৰ", "স\u{981}জ\u{9c1}লি"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("lövbər"),
            keywords: &["alət", "gəmi", "lövbər"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("якар"),
            keywords: &["карабель", "якар", "інструмент"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("котва"),
            keywords: &["инструмент", "кораб", "котва"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("নোঙর"),
            keywords: &["জ\u{9be}হ\u{9be}জ", "নোঙর", "সরঞ\u{9cd}জ\u{9be}ম"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("eor"),
            keywords: &["bag", "eor", "lestr"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("sidro"),
            keywords: &["alat", "brod", "sidro"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("àncora"),
            keywords: &["eina", "vaixell", "àncora"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎦᏅᎯᏍᏙᏗ"),
            keywords: &["ᎡᏆ ᏥᏳ", "ᎦᏅᎯᏍᏙᏗ", "ᎬᏔᏂᏓᏍᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("kotva"),
            keywords: &["kotva", "loď", "zařízení"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("angor"),
            keywords: &["angor", "llong", "offer"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("anker"),
            keywords: &["anker", "båd", "skib", "værktøj"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Anker"),
            keywords: &["Anker", "Hafen", "Meer"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("άγκυρα"),
            keywords: &["άγκυρα", "εργαλείο", "πλοίο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("anchor"),
            keywords: &["anchor", "ship", "tool"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("ancla"),
            keywords: &["ancla", "barco", "gancho"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["ancla", "barco", "bote"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("ankur"),
            keywords: &["ankur", "laev", "tööriist"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("aingura"),
            keywords: &["aingura", "ontzi", "tresna"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("لنگر"),
            keywords: &["ابزار", "لنگر", "کشتی"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("ankkuri"),
            keywords: &["alus", "ankkuri", "laiva", "merenkulku", "meri"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("angkla"),
            keywords: &["anchor", "angkla", "bangka", "barko", "kagamitan"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("akker"),
            keywords: &["akker", "bátur", "skip"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("ancre"),
            keywords: &["ancre", "bateau", "outil"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("ancaire"),
            keywords: &["ancaire", "comhartha"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("acair"),
            keywords: &["acainn", "acair", "long"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("áncora"),
            keywords: &["barco", "áncora"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("એ\u{a82}કર"),
            keywords: &["એ\u{a82}કર", "ચિહ\u{acd}ન"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("babban karfi"),
            keywords: &["babban karfi", "jirgin ruwa", "kayan aiki"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("עוגן"),
            keywords: &["אוניה", "אונייה", "ספינה", "עוגן"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ए\u{902}कर, चिह\u{94d}न"),
            keywords: &["ए\u{902}कर", "ए\u{902}कर, चिह\u{94d}न", "चिह\u{94d}न"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("sidro"),
            keywords: &["alat", "brod", "sidro"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("vasmacska"),
            keywords: &["hajózás", "horgony", "kikötés", "vasmacska"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("խարիսխ"),
            keywords: &["գործիք", "խարիսխ", "նավ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("jangkar"),
            keywords: &["alat", "jangkar", "kapal"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("mkpọrọ"),
            keywords: &["mkpọrọ", "ngwaọrụ", "ụgbọmmiri"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("akkeri"),
            keywords: &["akkeri", "skip", "tól"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("ancora"),
            keywords: &["ancora", "simbolo"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("錨"),
            keywords: &["いかり", "碇", "船", "錨"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("jangkar"),
            keywords: &["jangkar", "kapal", "pralatan"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ღუზა"),
            keywords: &["გემი", "ინსტრუმენტი", "ღუზა", "ხელსაწყო"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("зәкір"),
            keywords: &["зәкір", "кеме", "құрал"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("anker"),
            keywords: &["anker", "båd", "skib", "værktøj"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("យ\u{17bb}ថ\u{17d2}កា"),
            keywords: &[
                "កប\u{17c9}ាល\u{17cb}",
                "យ\u{17bb}ថ\u{17d2}កា",
                "ឧបករណ\u{17cd}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಲಂಗರು"),
            keywords: &["ಲಂಗರು", "ಸಂಕೇತ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("닻"),
            keywords: &["닻", "앵커", "항해"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("ना\u{902}गर"),
            keywords: &["जहाज", "ना\u{902}गर", "साधन"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("анкер"),
            keywords: &["анкер", "кеме", "курал"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Anker"),
            keywords: &["Anker", "Handwierksgeschir", "Schëff"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ສະໝ\u{ecd}"),
            keywords: &["ສະໝ\u{ecd}", "ເຄ\u{eb7}\u{ec8}ອງມ\u{eb7}", "ເຮ\u{eb7}ອ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("inkaras"),
            keywords: &["inkaras", "laivas", "įrankis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("enkurs"),
            keywords: &["enkurs", "kuģis"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("punga"),
            keywords: &["punga", "utauta", "waipuke"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("сидро"),
            keywords: &["алатка", "брод", "сидро"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("നങ\u{d4d}ക\u{d42}രം"),
            keywords: &["ചിഹ\u{d4d}നം", "നങ\u{d4d}ക\u{d42}രം", "സിംബൽ"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("зангуу"),
            keywords: &["зангуу", "усан онгоц"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("ना\u{902}गर"),
            keywords: &["जहाज", "ना\u{902}गर", "साधन"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("sauh"),
            keywords: &["alat", "kapal", "sauh"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("ankra"),
            keywords: &["ankra", "bastiment", "għodda"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ကျောက\u{103a}ဆ\u{1030}း"),
            keywords: &[
                "ကျောက\u{103a}ဆ\u{1030}း",
                "တ\u{1030}းလ\u{103a}",
                "သင\u{103a}\u{1039}ဘော",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("anker"),
            keywords: &["anker", "båt", "skip", "verktøy"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("एङ\u{94d}कर"),
            keywords: &["एङ\u{94d}कर", "जहाड", "साधन"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("anker"),
            keywords: &["anker", "hulpmiddel", "schip"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("anker"),
            keywords: &["anker", "båt", "skip", "verktøy"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଆଙ\u{b4d}କର\u{b4d}"),
            keywords: &[
                "ଆଙ\u{b4d}କର\u{b4d}",
                "ଏଙ\u{b4d}କର\u{b4d}",
                "ଚ\u{b3f}ହ\u{b4d}ନ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਲ\u{a70}ਗਰ"),
            keywords: &["ਔਜ\u{a3c}ਾਰ", "ਜਹਾਜ\u{a3c}", "ਲ\u{a70}ਗਰ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("لنگر"),
            keywords: &["اوزار", "بحری-جہاز", "لنگر"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Hẹ\u{301}ví Áyọn Wé De Hól Ship Fọ Wọ\u{301}n Ples"),
            keywords: &[
                "Hẹ\u{301}ví Áyọn Wé De Hól Ship Fọ Wọ\u{301}n Ples",
                "Ship",
                "Tul",
                "Ánkọ",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("kotwica"),
            keywords: &["kotwica", "okręt", "przyrząd", "statek"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("لنګر"),
            keywords: &["اله", "بېړۍ", "د لنګر", "لنګر"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("âncora"),
            keywords: &["sinal", "âncora"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["instrumento", "navio", "âncora"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("linderuyachiq"),
            keywords: &["apachiy", "linderuyachiq", "llamkana"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("ancoră"),
            keywords: &["ancorare", "ancoră", "instrument", "navă", "vas"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-084"),
            keywords: &["E10-084"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("якорь"),
            keywords: &["корабль", "якорь"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("inshyigikizi"),
            keywords: &["igikoresho", "inshyigikizi", "ubwato"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("لنگر"),
            keywords: &["اوزار", "بحري جهاز", "لنگر"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("නැංග\u{dd4}රම"),
            keywords: &["නැංග\u{dd4}රම", "නැව", "මෙවලම"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("kotva"),
            keywords: &["kotva", "loď", "nástroj"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("sidro"),
            keywords: &["ladja", "orodje", "sidro"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("baroosinka"),
            keywords: &["baroosinka", "markab", "qalab"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("spirancë"),
            keywords: &["anije", "spirancë", "vegël"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("сидро"),
            keywords: &["aлaт", "брoд", "сидро"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("sidro"),
            keywords: &["alat", "brod", "sidro"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("ankare"),
            keywords: &["ankare", "hopp"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("nanga"),
            keywords: &["meli", "nanga", "zana"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("நங\u{bcd}கூரம\u{bcd}"),
            keywords: &["ஆங\u{bcd}கர\u{bcd}", "கருவி", "நங\u{bcd}கூரம\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("లంగరు గుర\u{c4d}తు"),
            keywords: &["గుర\u{c4d}తు", "లంగరు"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("лангар"),
            keywords: &["асбоб", "киштӣ", "лангар"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("สมอเร\u{e37}อ"),
            keywords: &[
                "สมอ",
                "สมอเร\u{e37}อ",
                "เคร\u{e37}\u{e48}องม\u{e37}อ",
                "เร\u{e37}อ",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("labyr"),
            keywords: &["gural", "gämi", "labyr"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("taula"),
            keywords: &["taula"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("çıpa"),
            keywords: &["gemi", "işaret", "çıpa"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("لەڭگەر"),
            keywords: &["قورال", "كېمە", "لەڭگەر"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("якір"),
            keywords: &["знаряддя", "корабель", "якір"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("اینکر"),
            keywords: &["آلہ", "اینکر", "بحری جہاز"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("langar"),
            keywords: &["asbob", "kema", "langar"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("mỏ neo"),
            keywords: &["dụng cụ", "mỏ neo", "tàu"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("serukaayu gaal"),
            keywords: &["bato", "jumtukaay", "serukaayu gaal"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("i-ankile"),
            keywords: &["i-ankile", "inqanawa", "isixhobo"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ìdákòró"),
            keywords: &["irinṣẹ\u{301}", "Ìdákòró", "ọkọ\u{300} ojú omi ńlá"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("錨"),
            keywords: &["工具", "船", "錨"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("锚"),
            keywords: &["工具", "船", "锚"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("锚"),
            keywords: &["停泊", "船", "锚"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("錨"),
            keywords: &["船錨", "錨"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ihange"),
            keywords: &["ihange", "ithuluzi", "umkhumbi"],
        },
    ],
};
#[doc = "⛵"]
pub const SAILBOAT: crate::Emoji = crate::Emoji {
    glyph: "⛵",
    codepoint: "26F5",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "sailboat",
    group: "Travel & Places",
    subgroup: "transport-water",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("seilboot"),
            keywords: &["boot", "jag", "see", "seil", "seilboot", "voertuig"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ጀልባ"),
            keywords: &["ባሕር", "ተሽከርካሪ", "ታንኳ", "እንግዳ ማረፊያ", "ጀልባ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("مركب شراعي"),
            keywords: &["قارب", "مركب شراعي", "منتجع", "منتجع بحري", "يخت"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("প\u{9be}ল তৰ\u{9be} ন\u{9be}ও"),
            keywords: &[
                "ন\u{9be}ও",
                "প\u{9be}ল তৰ\u{9be} ন\u{9be}ও",
                "স\u{9be}গৰ",
                "ৰিজৰ\u{9cd}ট",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("yelkənli qayıq"),
            keywords: &[
                "dəniz",
                "kurort",
                "nəqliyyat",
                "qayıq",
                "yaxta",
                "yelkənli qayıq",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("паруснік"),
            keywords: &["ветразь", "курорт", "лодка", "мора", "паруснік", "яхта"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("яхта"),
            keywords: &["кораб", "курорт", "море", "превозно средство", "яхта"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("প\u{9be}ল তোল\u{9be} নৌক\u{9be}"),
            keywords: &[
                "ইয\u{9bc}ট",
                "নৌক\u{9be}",
                "প\u{9be}ল তোল\u{9be} নৌক\u{9be}",
                "য\u{9be}নব\u{9be}হন",
                "রিসোর\u{9cd}ট",
                "স\u{9be}গর",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("gouelier"),
            keywords: &["bag", "gouelier", "lestr"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("jedrilica"),
            keywords: &["jahta", "jedrilica", "more", "odmaralište", "čamac"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("veler"),
            keywords: &["iot", "mar", "vaixell", "vehicle", "veler"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏥᏳ ᎠᏂᎩᏍᎩ"),
            keywords: &["ᎠᎺᏉᎯ", "ᎤᏙᏢᏒᎢ ᎡᏓᏍᏗ", "ᏗᏓᏥᎯᏍᏗᏍᎩ", "ᏥᏳ", "ᏥᏳ ᎠᏂᎩᏍᎩ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("plachetnice"),
            keywords: &[
                "dovolená",
                "jachta",
                "loď",
                "moře",
                "plachetnice",
                "plavidlo",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("cwch hwylio"),
            keywords: &["cwch", "cwch hwylio", "cyrchfan", "môr"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("sejlbåd"),
            keywords: &["båd", "sejlbåd"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Segelboot"),
            keywords: &["Boot", "Segelboot"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ιστιοφόρο"),
            keywords: &["βάρκα", "θάλασσα", "θέρετρο", "ιστιοφόρο", "όχημα"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("sailboat"),
            keywords: &["boat", "resort", "sailboat", "sea", "yacht"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: Some("sailing boat"),
            keywords: &["boat", "resort", "sailboat", "sailing", "sea", "yacht"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("velero"),
            keywords: &[
                "barco",
                "barco de vela",
                "centro turístico",
                "resort",
                "velero",
                "yate",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("velero"),
            keywords: &["bote", "mar", "velero"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["bote", "deporte acuático", "mar", "transporte", "velero"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["bote", "hotel", "mar", "resort", "velero"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("purjepaat"),
            keywords: &["jaht", "meri", "paat", "puhkus", "purjepaat", "sõiduk"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("belaontzia"),
            keywords: &["belaontzia", "ibilgailu", "itsaso", "itsasontzi", "resort"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("قایق بادبانی"),
            keywords: &[
                "تفریح",
                "تفریحی",
                "دریا",
                "قایق",
                "قایق بادبانی",
                "کشتی شخصی",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("purjevene"),
            keywords: &["ajoneuvo", "alus", "jahti", "meri", "purjevene", "vene"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("bangkang may layag"),
            keywords: &[
                "bangka",
                "bangkang may layag",
                "layag",
                "sailboat",
                "sasakyang pandagat",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("seglbátur"),
            keywords: &["bátur", "segl", "seglbátur", "stuttleikabátur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("voilier"),
            keywords: &["bateau", "mer", "voilier", "yacht"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["bateau", "mer", "voile", "voilier", "yacht"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("bád seoil"),
            keywords: &[
                "bád",
                "bád seoil",
                "bás seoil",
                "ionad mara",
                "ionad saoire",
                "luamh",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("bàta-seòlaidh"),
            keywords: &[
                "bàta",
                "bàta-seòlaidh",
                "geat",
                "muir",
                "sgoth",
                "turasachd",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("veleiro"),
            keywords: &["barco", "mar", "veleiro"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("સઢવાળી હોડી"),
            keywords: &[
                "યાચ",
                "રિસૉર\u{acd}ટ",
                "સઢવાળી હોડી",
                "સમ\u{ac1}દ\u{acd}રી રિસૉર\u{acd}ટ",
                "હોડી",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("jirgin ruwa mai filafilai"),
            keywords: &[
                "jirgin ruwa mai filafilai",
                "jirgin ruwa mai filafilai ɗaya",
                "jirgin ruwa na sauri",
                "shaƙatawa",
                "teku",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("סירת מפרש"),
            keywords: &["יאכטה", "ים", "מפרש", "מפרשית", "סירה", "סירת מפרש"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("स\u{947}लबोट, नाव"),
            keywords: &[
                "नाव",
                "बोट",
                "याच",
                "रीसोर\u{94d}ट",
                "सी रीसोर\u{94d}ट",
                "स\u{947}लबोट",
                "स\u{947}लबोट, नाव",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("jedrilica"),
            keywords: &["jahta", "jedrilica", "more", "odmor", "čamac"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("vitorlás hajó"),
            keywords: &["hajó", "jacht", "tenger", "vitorlás", "vízi jármű"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("առագաստանավ"),
            keywords: &[
                "առագաստանավ",
                "զբոսանավ",
                "ծով",
                "հանգստավայր",
                "նավակ",
                "փոխադրամիջոց",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("perahu layar"),
            keywords: &[
                "kapal",
                "kendaraan",
                "laut",
                "perahu",
                "perahu layar",
                "pesiar",
                "resor",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("egwuregwu ụgbọmmiri"),
            keywords: &[
                "ebe ezumiike",
                "egwuregwu ụgbọmmiri",
                "oshimiri",
                "ụgbọmmiri",
                "ụgbọmmiri oke ọsọ",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("seglskúta"),
            keywords: &["bátur", "seglskúta", "skúta", "smábátahöfn"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("barca a vela"),
            keywords: &[
                "barca",
                "barca a vela",
                "località balneare",
                "vela",
                "yacht",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ヨット"),
            keywords: &["ヨット", "乗り物", "帆船", "船"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("prau layar"),
            keywords: &["kapal layar", "prau", "prau layar", "resor", "segara"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("იალქნიანი ნავი"),
            keywords: &[
                "გემი",
                "ზღვა",
                "იალქნიანი ნავი",
                "იახტა",
                "კურორტი",
                "ნავი",
                "ტრანსპორტი",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("желкенді қайық"),
            keywords: &["желкенді қайық", "резорт", "теңіз", "яхта", "қайық"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("sejlbåd"),
            keywords: &["båd", "sejlbåd"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ទ\u{17bc}កក\u{17d2}តោង"),
            keywords: &[
                "ក\u{17d2}តោង",
                "ទ\u{17bc}ក",
                "ទ\u{17bc}កក\u{17d2}តោង",
                "រមណ\u{17b8}យដ\u{17d2}ឋាន",
                "សម\u{17bb}ទ\u{17d2}រ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಹಾಯ\u{cbf}ದೋಣ\u{cbf}"),
            keywords: &["ದೋಣ\u{cbf}", "ಹಾಯ\u{cbf}ದೋಣ\u{cbf}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("돛단배"),
            keywords: &["돛단배", "범선", "요트"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("सफरजहाज"),
            keywords: &[
                "दर\u{94d}या",
                "पन\u{947}ळ",
                "बोट",
                "र\u{947}झॉर\u{94d}ट",
                "सफरजहाज",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("парус"),
            keywords: &["деңиз", "кайык", "парус", "унаа", "яхта"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Segelboot"),
            keywords: &["Boot", "Mier", "Resort", "Segelboot", "Yacht"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເຮ\u{eb7}ອໃບ"),
            keywords: &["ທະເລ", "ເຮ\u{eb7}ອໃບ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("burlaivis"),
            keywords: &["burlaivis", "jachta", "jūra", "kurortas", "valtis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("buru laiva"),
            keywords: &[
                "buru laiva",
                "jahta",
                "jūra",
                "laiva",
                "transports",
                "ūdens",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("waka pere"),
            keywords: &["moana", "pere rua", "poti", "waka pere", "wāhi hararei"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("едреник"),
            keywords: &["брод", "едреник", "море", "транспорт", "јахта"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("പ\u{d3e}യ\u{d4d}\u{200c}ക\u{d4d}കപ\u{d4d}പൽ"),
            keywords: &[
                "കടൽ",
                "ചങ\u{d4d}ങ\u{d3e}ടം",
                "പ\u{d3e}യ\u{d4d}\u{200c}ക\u{d4d}കപ\u{d4d}പൽ",
                "റിസോർട\u{d4d}ട\u{d4d}",
                "സെയിൽ ബോട\u{d4d}ട\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("завь"),
            keywords: &["дарвуул", "завь"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("शिडाची होडी"),
            keywords: &[
                "बोट",
                "रीसॉर\u{94d}ट",
                "शिडाची होडी",
                "सम\u{941}द\u{94d}र",
                "हलकी शिडाची होडी",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("perahu layar"),
            keywords: &[
                "bot",
                "kapal layar",
                "kenderaan",
                "laut",
                "perahu layar",
                "resort",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("dgħajsa bil-qlugħ"),
            keywords: &["baħar", "dgħajsa", "dgħajsa bil-qlugħ", "jott", "resort"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ရ\u{103d}က\u{103a}လ\u{103e}ေ"),
            keywords: &[
                "ပင\u{103a}လယ\u{103a}",
                "ရ\u{103d}က\u{103a}တ\u{102d}\u{102f}က\u{103a}",
                "ရ\u{103d}က\u{103a}လ\u{103e}ေ",
                "လ\u{103e}ေ",
                "အပန\u{103a}းဖြေ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("seilbåt"),
            keywords: &["båt", "seilbåt"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("स\u{947}लबोट"),
            keywords: &[
                "ड\u{941}ङ\u{94d}गा",
                "याच\u{94d}ट",
                "र\u{947}सोर\u{94d}ट",
                "सम\u{941}द\u{94d}र",
                "स\u{947}लबोट",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("zeilboot"),
            keywords: &["boot", "jacht", "jachthaven", "zee", "zeilboot"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("seglbåt"),
            keywords: &["båt", "seglbåt"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ସେଲ\u{b4d}\u{200c}ବୋଟ\u{b4d}\u{200c}"),
            keywords: &[
                "ଡଙ\u{b4d}ଗ\u{b3e}",
                "ନୌକ\u{b3e}",
                "ପ\u{b3e}ଲ ଟଣ\u{b3e} ଡଙ\u{b4d}ଗ\u{b3e}",
                "ର\u{b3f}ସର\u{b4d}ଟ\u{b4d}",
                "ସମ\u{b41}ଦ\u{b4d}ର ର\u{b3f}ସର\u{b4d}ଟ\u{b4d}",
                "ସେଲ\u{b4d}\u{200c}ବୋଟ\u{b4d}\u{200c}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਬ\u{a47}ੜੀ"),
            keywords: &[
                "ਕਿਸ\u{a3c}ਤੀ",
                "ਬ\u{a47}ੜਾ",
                "ਬ\u{a47}ੜੀ",
                "ਰਿਜਾਰਟ",
                "ਸਮ\u{a41}\u{a70}ਦਰ ਰਿਜਾਰਟ",
                "ਹ\u{a48}\u{a71}ਟੀ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("بادبانی کشتی"),
            keywords: &[
                "آمد ورفت رکھنا",
                "بادبان کشتی",
                "بادبانی کشتی",
                "سمندر",
                "کشتی",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Sélbot"),
            keywords: &["Bot", "Bíg-Díp-Wọtá", "Sélbot", "Sélbot Wé Im Nem Na Yọch"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("żaglówka"),
            keywords: &["jacht", "kurort", "morze", "pojazd", "łódka", "żaglówka"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("سیلبوټ"),
            keywords: &[
                "بادباني کښتۍ",
                "بحر",
                "د سيل ځای",
                "سيلبوټ",
                "سیلبوټ",
                "کښتۍ",
            ],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("barco a vela"),
            keywords: &["barco", "barco a vela", "iate", "resort", "resort marítimo"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("veleiro"),
            keywords: &["barco", "estância", "iate", "mar", "veleiro", "veículo"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("velero"),
            keywords: &["samaypaq kiti", "tiyana", "velero", "wamp’u", "yate"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("barcă cu pânze"),
            keywords: &["barcă", "barcă cu pânze", "iaht", "navigație", "pânze"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-115"),
            keywords: &["E10-115"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("парусник"),
            keywords: &["лодка", "отдых", "парусник", "яхта"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ubwato bwo gutembera"),
            keywords: &[
                "inyanja",
                "inzu yo kuruhukiramo",
                "ubwato",
                "ubwato bwo gutembera",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("بادباني ٻيڙي"),
            keywords: &["بادباني ٻيڙي", "بتيلو", "سمنڊ", "سير گاه", "ٻيڙي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("න\u{dcf}ව\u{dd2}ක බෝට\u{dca}ට\u{dd4}ව"),
            keywords: &[
                "න\u{dcf}ව\u{dd2}ක බෝට\u{dca}ට\u{dd4}ව",
                "නැව",
                "ම\u{dd4}හ\u{dd4}ද",
                "ය\u{dcf}ත\u{dca}\u{200d}ර\u{dcf}ව",
                "ලැග\u{dd4}ම\u{dca} හල",
                "ව\u{dcf}හනය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("plachetnica"),
            keywords: &[
                "dopravný prostriedok",
                "jachta",
                "loď",
                "more",
                "plachetnica",
                "stredisko",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("jadrnica"),
            keywords: &["jadrnica", "jahta", "letovišče", "morje", "vozilo", "čoln"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("doon shiraac"),
            keywords: &[
                "badda",
                "dalxiis",
                "doon",
                "doon shiraac",
                "tartan doonyaad",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("varkë me vela"),
            keywords: &["det", "jaht", "turistike", "varkë", "varkë me vela"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("једрењак"),
            keywords: &["jaхтa", "oдмoр", "вoзилo", "мoрe", "чaмaц", "једрењак"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("jedrenjak"),
            keywords: &["jahta", "jedrenjak", "more", "odmor", "vozilo", "čamac"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("segelbåt"),
            keywords: &["båt", "segelbåt", "segling"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mashua"),
            keywords: &[
                "bahari",
                "boti",
                "gari",
                "mahali pa kutembelea watalii",
                "mashua",
                "mashura",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("உல\u{bbe}ப\u{bcd} படகு"),
            keywords: &[
                "உல\u{bbe}ப\u{bcd} படகு",
                "கடல\u{bcd} பயணம\u{bcd}",
                "சுற\u{bcd}றுல\u{bbe}",
                "ரிச\u{bbe}ர\u{bcd}ட\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("పడవ"),
            keywords: &[
                "పడవ",
                "ప\u{c46}ద\u{c4d}ద పడవ",
                "ర\u{c3f}స\u{c3e}ర\u{c4d}ట\u{c4d}",
                "వ\u{c3e}హనం",
                "సముద\u{c4d}రం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("заврақи бодбондор"),
            keywords: &["баҳр", "заврақи бодбондор", "киштӣ", "курорт", "қаиқ"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เร\u{e37}อใบ"),
            keywords: &["ทะเล", "เร\u{e37}อ", "เร\u{e37}อใบ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ýelkenli gämi"),
            keywords: &[
                "deňiz",
                "dynç alynýan ýer",
                "gaýyk",
                "ýahta",
                "ýelkenli gämi",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("vakalā"),
            keywords: &["vakalā"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("yelkenli tekne"),
            keywords: &[
                "deniz tatil yeri",
                "tatil yeri",
                "tekne",
                "yat",
                "yelkenli tekne",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("قېيىق"),
            keywords: &["دېڭىز", "ساياھەت", "قېيىق", "كېمە"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("вітрильник"),
            keywords: &[
                "відпочинок",
                "вітрильник",
                "море",
                "транспорт",
                "човен",
                "яхта",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("بادبانی کشتی"),
            keywords: &["بادبانی کشتی", "سمندر", "کشتی"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("yelkanli kema"),
            keywords: &["dengiz", "kema", "transport", "yaxta", "yelkanli kema"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("thuyền buồm"),
            keywords: &[
                "biển",
                "du thuyền",
                "khu nghỉ dưỡng",
                "thuyền",
                "thuyền buồm",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("gaalu ngelaw"),
            keywords: &["gaal", "gaalu ngelaw", "géej", "serukaay", "yacht"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("iphenyana"),
            keywords: &["i-resort", "i-yacht", "iphenayana", "iphenyana", "ulwandle"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ọkọ kekere"),
            keywords: &[
                "ibi ìgbafẹ\u{301}",
                "okun",
                "Ọkọ kekere",
                "ọkọ\u{300} ojú omi",
                "ọkọ\u{300} ojú omi ibi ìgbafẹ\u{301}",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("帆船"),
            keywords: &["帆船", "度假村", "海", "艇", "遊艇"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("帆船"),
            keywords: &["帆船", "度假村", "海", "游艇", "艇"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("帆船"),
            keywords: &["帆船", "船"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("帆船"),
            keywords: &["帆船"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("isikebhe sasolwandle"),
            keywords: &[
                "indawo yokuvakasha",
                "isikebhe",
                "isikebhe sasolwandle",
                "isithuthi",
                "ulwandle",
            ],
        },
    ],
};
#[doc = "🛶"]
pub const CANOE: crate::Emoji = crate::Emoji {
    glyph: "🛶",
    codepoint: "1F6F6",
    status: crate::Status::FullyQualified,
    introduction_version: 3f32,
    name: "canoe",
    group: "Travel & Places",
    subgroup: "transport-water",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("kano"),
            keywords: &["boot", "kano"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ታንኳ"),
            keywords: &["ታንኳ", "ጀልባ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("زورق"),
            keywords: &["زورق", "قارب"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("সৰ\u{9c1} ন\u{9be}ও"),
            keywords: &["ন\u{9be}ও", "সৰ\u{9c1} ন\u{9be}ও"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("qayıq"),
            keywords: &["qayıq", "sürmə"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("каноэ"),
            keywords: &["каноэ", "лодка"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("кану"),
            keywords: &["кану", "лодка"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ডোঙ\u{9cd}গ\u{9be}"),
            keywords: &["ডোঙ\u{9cd}গ\u{9be}", "নৌক\u{9be}"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("kanoe"),
            keywords: &["bag", "kanoe"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("kanu"),
            keywords: &["kanu", "čamac"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("canoa"),
            keywords: &["canoa", "kayak"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᎹ ᏥᏳ"),
            keywords: &["ᎠᎹ ᏥᏳ", "ᏥᏳ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("kánoe"),
            keywords: &["kánoe", "loď", "člun"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("canŵ"),
            keywords: &["canŵ", "cwch"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("kano"),
            keywords: &["båd", "kano", "transportmiddel"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Kanu"),
            keywords: &["Boot", "Kanu", "Wassersport"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κανό"),
            keywords: &["βάρκα", "κανό"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("canoe"),
            keywords: &["boat", "canoe"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("canoa"),
            keywords: &["barca", "barco", "canoa", "piragua"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["bote", "canoa", "remo"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["bote", "canoa", "deporte acuático", "remo", "transporte"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kanuu"),
            keywords: &["kanuu", "paat"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("kanoa"),
            keywords: &["kanoa", "ontzi"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("بلم"),
            keywords: &["بلم", "زورق", "قایق", "قایقرانی", "پارو", "کانو"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kanootti"),
            keywords: &["kanootti", "vene"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("canoe"),
            keywords: &["bangka", "canoe"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("kano"),
            keywords: &[
                "bátur",
                "eikja",
                "holabátur",
                "indiánabátur",
                "kajakk",
                "kano",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("canoë"),
            keywords: &["bateau", "canoë"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("canú"),
            keywords: &["bád", "caidhc", "canú"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("canù"),
            keywords: &["bàta", "canù"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("canoa"),
            keywords: &["barca", "canoa", "piragua", "piragüismo", "remar"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ક\u{ac5}નોઈ"),
            keywords: &["ક\u{ac5}નોઈ", "હોડી"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("ƙaramin jirgin ruwa"),
            keywords: &["jirgin ruwa mai sauri", "ƙaramin jirgin ruwa"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("קאנו"),
            keywords: &["סירה", "קאנו"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("डो\u{902}गी"),
            keywords: &["डो\u{902}गी", "नाव"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("kanu"),
            keywords: &["kanu", "čamac"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("kenu"),
            keywords: &["csónak", "kenu"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("կանոէ"),
            keywords: &["կանոէ", "մակույկ", "նավակ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("kano"),
            keywords: &["getek", "kano", "perahu", "sampan"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ụgbọ epepe"),
            keywords: &["ụgbọ epepe", "ụgbọmmiri"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("kanó"),
            keywords: &["bátur", "farartæki", "kanó"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("canoa"),
            keywords: &["canoa", "imbarcazione"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("カヌー"),
            keywords: &["カヌー", "カヤック", "ボート", "乗り物", "船"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("kano"),
            keywords: &["kano", "prau"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("კანოე"),
            keywords: &["კანოე", "ნავი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("каное"),
            keywords: &["каное", "қайық"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("kano"),
            keywords: &["båd", "kano", "transportmiddel"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ទ\u{17bc}កចែវ"),
            keywords: &["ទ\u{17bc}ក", "ទ\u{17bc}កចែវ"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ದೋಣ\u{cbf}"),
            keywords: &["ದೋಣ\u{cbf}", "ಬೋಟ\u{ccd}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("카누"),
            keywords: &["배", "카누"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("व\u{94d}हड\u{947}\u{902}"),
            keywords: &["बोट", "व\u{94d}हड\u{947}\u{902}"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("каноэ"),
            keywords: &["кайык", "каноэ"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Kanu"),
            keywords: &["Boot", "Kanu"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ແຄໂນ"),
            keywords: &["ເຮ\u{eb7}ອ", "ແຄໂນ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("kanoja"),
            keywords: &["irkluoti", "kanoja"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("kanoe"),
            keywords: &["kanoe", "laiva"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("waka"),
            keywords: &["poti", "waka"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("кајак"),
            keywords: &["кану", "кајак"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("വള\u{d4d}ളം ത\u{d41}ഴയൽ"),
            keywords: &["ത\u{d41}ഴയൽ", "വള\u{d4d}ളം"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("сэлүүрт завь"),
            keywords: &["завь", "сэлүүр", "сэлүүрт завь"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("क\u{945}नोई"),
            keywords: &["क\u{945}नोई", "बोट"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("kanu"),
            keywords: &["kanu", "perahu"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("canoe"),
            keywords: &["canoe", "dgħajsa"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ကန\u{1030}း"),
            keywords: &["ကန\u{1030}း", "လ\u{103e}ေ"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("kano"),
            keywords: &["båt", "kano"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("क\u{94d}यानो"),
            keywords: &["क\u{94d}यानो", "ड\u{941}ङ\u{94d}गा"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("kano"),
            keywords: &["boot", "kano"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("kano"),
            keywords: &["båt", "kano"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ସର\u{b41}ଆ ହ\u{b3e}ଲକ\u{b3e} ଡଙ\u{b4d}ଗ\u{b3e}"),
            keywords: &[
                "ନୌକ\u{b3e}",
                "ସର\u{b41}ଆ ହ\u{b3e}ଲକ\u{b3e} ଡଙ\u{b4d}ଗ\u{b3e}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਕ\u{a48}ਨ\u{a4b}ਏ"),
            keywords: &["ਕਿਸ\u{a3c}ਤੀ", "ਕ\u{a48}ਨ\u{a4b}ਏ", "ਪਖ\u{a70}ਡੀ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("نیکی کشتی"),
            keywords: &["نیکی کشتی", "کشتی"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Kenú"),
            keywords: &["Bot", "Kenú"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("kajak"),
            keywords: &["kajak", "łódź"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("وړه بېړۍ"),
            keywords: &["وړه بېړۍ", "کښتۍ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("canoa"),
            keywords: &["barco", "canoa"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("canoa"),
            keywords: &["canoa", "wamp’u"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("canoe"),
            keywords: &["barcă", "canoe"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1007"),
            keywords: &["E10-1007"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("каноэ"),
            keywords: &["байдарка", "индейцы", "каноэ", "каяк", "лодка"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ubwato buto"),
            keywords: &["ubwato bugari", "ubwato buto"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڊونگي"),
            keywords: &["ٻيڙي", "ڊونگي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ඔර\u{dd4}ව"),
            keywords: &["ඔර\u{dd4}ව", "බෝට\u{dca}ට\u{dd4}ව"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("kanoe"),
            keywords: &["kanoe", "loď"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("kanu"),
            keywords: &["kanu", "čoln"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("huuri"),
            keywords: &["doon", "huuri"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("kaike"),
            keywords: &["kaike", "kanoe", "lundër", "varkë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("кану"),
            keywords: &["кану", "чамац"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["кану"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("kanu"),
            keywords: &["kanu", "čamac"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["kanu"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("kanot"),
            keywords: &["båt", "kanot"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mtumbwi"),
            keywords: &["mashua", "mtumbwi"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("படகு"),
            keywords: &["படகு"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("చ\u{c3f}న\u{c4d}న పడవ"),
            keywords: &["క\u{c3e}ను", "చ\u{c3f}న\u{c4d}న పడవ", "పడవ"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("заврақ"),
            keywords: &["заврақ", "қаиқ"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("แคน\u{e39}"),
            keywords: &["พาย", "เร\u{e37}อ", "แคน\u{e39}"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("kanoe"),
            keywords: &["gaýyk", "kanoe"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("pōpao"),
            keywords: &["pōpao"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("kano"),
            keywords: &["bot", "kano"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("قولۋاق"),
            keywords: &["قولۋاق", "قېيىق"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("каное"),
            keywords: &["каное", "човен"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("چھوٹی کشتی"),
            keywords: &["چھوٹی", "ڈونگی", "کشتی"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("kanoe"),
            keywords: &["kanoe", "qayiq"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("xuồng"),
            keywords: &["thuyền", "xuồng"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("kaal gu ndaw"),
            keywords: &["gaal", "kaal gu ndaw", "kanowe"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("iphenyane"),
            keywords: &["iphenyana", "iphenyane"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("obele"),
            keywords: &["obele", "Òbèlé", "ọkọ\u{300} ojú omi"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("獨木舟"),
            keywords: &["獨木舟", "艇"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("独木舟"),
            keywords: &["独木舟", "艇"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("独木舟"),
            keywords: &["独木舟"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("獨木舟"),
            keywords: &["獨木舟", "船"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("isikebhe"),
            keywords: &["isikebhe"],
        },
    ],
};
#[doc = "🚤"]
pub const SPEEDBOAT: crate::Emoji = crate::Emoji {
    glyph: "🚤",
    codepoint: "1F6A4",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "speedboat",
    group: "Travel & Places",
    subgroup: "transport-water",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("snelboot"),
            keywords: &["boot", "snelboot", "voertuig"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ፈጣን ጀልባ"),
            keywords: &["ተሽከርካሪ", "ጀልባ", "ፈጣን ጀልባ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("قارب سريع"),
            keywords: &["قارب", "قارب سريع", "مركبة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("স\u{9cd}পীডব’ট"),
            keywords: &["ন\u{9be}ও", "স\u{9cd}পীডব’ট"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("sürətli qayıq"),
            keywords: &["nəqliyyat", "qayıq", "sürətli qayıq"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("быстраходны катар"),
            keywords: &["быстраходны катар", "вада", "лодка", "хуткасць"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("моторна лодка"),
            keywords: &["кораб", "моторна лодка", "превозно средство"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("স\u{9cd}পীডবোট"),
            keywords: &["নৌক\u{9be}", "য\u{9be}নব\u{9be}হন", "স\u{9cd}পীডবোট"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("bag herrek"),
            keywords: &["bag", "bag herrek", "lestr"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("gliser"),
            keywords: &["gliser", "vozilo", "čamac"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("llanxa ràpida"),
            keywords: &["llanxa", "ràpida"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎦᏳᏄᎳ ᏥᏳ"),
            keywords: &["ᎦᏳᏄᎳ ᏥᏳ", "ᏥᏳ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("motorový člun"),
            keywords: &["loď", "motorový člun", "plavidlo", "člun"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("cwch gwib"),
            keywords: &["cerbyd", "cwch", "cwch gwib"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("speedbåd"),
            keywords: &["båd", "speedbåd"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Schnellboot"),
            keywords: &["Boot", "Schnellboot"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ταχύπλοο"),
            keywords: &["ταχύπλοο", "όχημα"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("speedboat"),
            keywords: &["boat", "speedboat"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("lancha motora"),
            keywords: &["barco", "lancha motora", "vehículo"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("lancha"),
            keywords: &["bote", "lancha", "vehículo"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["bote", "deporte acuático", "lancha", "transporte"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kiirkaater"),
            keywords: &["kiirkaater", "paat", "sõiduk"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("abiadura handiko txalupa"),
            keywords: &["abiadura handiko txalupa", "ibilgailu", "itsasontzi"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("قایق تندرو"),
            keywords: &["قایق", "قایق تندرو", "قایق سرعتی"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("pikavene"),
            keywords: &["ajoneuvo", "meri", "moottorivene", "pikavene", "vene"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("speedboat"),
            keywords: &[
                "bangka",
                "de-motor",
                "sasakyan",
                "sasakyang pandagat",
                "speedboat",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("rasarabátur"),
            keywords: &["bátur", "rasarabátur", "snarbátur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("hors-bord"),
            keywords: &["bateau", "hors-bord"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("luasbhád"),
            keywords: &["bád", "feithicil", "luasbhád"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("luath-bhàta"),
            keywords: &["bàta", "luath-bhàta"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("lancha motora"),
            keywords: &["barco", "lancha", "lancha motora"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("સ\u{acd}પીડબોટ"),
            keywords: &["વાહન", "સ\u{acd}પીડબોટ", "હોડી"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("jirgin ruwa mai sauri"),
            keywords: &["jirgin ruwa mai sauri", "jirgin ruwa na sauri"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("סירת מירוץ"),
            keywords: &["ים", "מירוץ", "סירה", "סירת מירוץ"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("स\u{94d}पीडबोट, नाव"),
            keywords: &["नाव", "वाहन", "स\u{94d}पीडबोट", "स\u{94d}पीडबोट, नाव"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("gliser"),
            keywords: &["gliser", "vozilo", "čamac"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("motoros siklócsónak"),
            keywords: &["csónak", "motoros siklócsónak", "vízi jármű"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("արագընթաց մոտորանավակ"),
            keywords: &["արագընթաց մոտորանավակ", "նավակ", "փոխադրամիջոց"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("perahu cepat"),
            keywords: &["kendaraan", "perahu", "perahu cepat"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ụgbọmmiri oke ọsọ"),
            keywords: &["ụgbọmmiri", "ụgbọmmiri oke ọsọ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("hraðbátur"),
            keywords: &["bátur", "hraðbátur", "spíttbátur"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("motoscafo"),
            keywords: &["barca", "motoscafo", "veicolo"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("スピードボート"),
            keywords: &["スピードボート", "ボート", "乗り物", "船"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("kapal rikat"),
            keywords: &["kapal rikat", "prau"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("გლისერი"),
            keywords: &["გემი", "გლისერი", "ნავი", "ტრანსპორტი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("жылдам жүретін қайық"),
            keywords: &["жылдам жүретін қайық", "көлік", "қайық"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("speedbåd"),
            keywords: &["båd", "speedbåd"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("កាណ\u{17bc}ត"),
            keywords: &["កាណ\u{17bc}ត", "ទ\u{17bc}ក"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ವೇಗದ ದೋಣ\u{cbf}"),
            keywords: &["ದೋಣ\u{cbf}", "ವೇಗದ ದೋಣ\u{cbf}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("쾌속정"),
            keywords: &["보트", "선박", "쾌속정"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("व\u{947}गबोट"),
            keywords: &["बोट", "व\u{947}गबोट"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("тез жүргөн катер"),
            keywords: &["кайык", "тез жүргөн катер", "унаа"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Schnellboot"),
            keywords: &["Boot", "Schnellboot"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເຮ\u{eb7}ອໄວ"),
            keywords: &["ພາຫະນະ", "ເຮ\u{eb7}ອໄວ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("motorinis kateris"),
            keywords: &["motorinis kateris", "valtis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("ātrlaiva"),
            keywords: &["laiva", "transports", "ātrlaiva", "ūdens"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("wakatere"),
            keywords: &["poti", "wakatere"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("глисер"),
            keywords: &["брод", "глисер", "транспорт"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("സ\u{d4d}പീഡ\u{d4d} ബോട\u{d4d}ട\u{d4d}"),
            keywords: &[
                "ബോട\u{d4d}ട\u{d4d}",
                "വ\u{d3e}ഹനം",
                "സ\u{d4d}പീഡ\u{d4d} ബോട\u{d4d}ട\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("хурдан завь"),
            keywords: &["завь", "хурдан"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("स\u{94d}पीडबोट"),
            keywords: &["बोट", "स\u{94d}पीडबोट"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("bot laju"),
            keywords: &["bot", "bot laju", "kenderaan"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("speedboat"),
            keywords: &["dgħajsa", "speedboat"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အမြန\u{103a}စက\u{103a}လ\u{103e}ေ"),
            keywords: &["စက\u{103a}လ\u{103e}ေ", "အမြန\u{103a}စက\u{103a}လ\u{103e}ေ"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("speedbåt"),
            keywords: &["båt", "fartøy", "speedbåt"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("स\u{94d}पिडबोट"),
            keywords: &["गाडी", "ड\u{941}ङ\u{94d}गा", "स\u{94d}पिडबोट"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("speedboot"),
            keywords: &["boot", "speedboot"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("speedbåt"),
            keywords: &["båt", "fartøy", "speedbåt"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ସ\u{b4d}ପ\u{b3f}ଡ\u{b4d}\u{200c}ବୋଟ\u{b4d}\u{200c}"),
            keywords: &[
                "ନୌକ\u{b3e}",
                "ସ\u{b4d}ପ\u{b3f}ଡ\u{b4d}\u{200c}ବୋଟ\u{b4d}\u{200c}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਤ\u{a47}ਜ\u{a3c} ਕਿਸ\u{a3c}ਤੀ"),
            keywords: &[
                "ਕਿਸ\u{a3c}ਤੀ",
                "ਗਤੀ ਕਿਸ\u{a3c}ਤੀ",
                "ਤ\u{a47}ਜ\u{a3c} ਕਿਸ\u{a3c}ਤੀ",
                "ਵਾਹਨ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("تیز رفتار کشتی"),
            keywords: &["تیز رفتار کشتی", "کشتی"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Spídbot"),
            keywords: &["Bot", "Spídbot"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("ścigacz wodny"),
            keywords: &["łódka", "łódź", "ścigacz wodny"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("چټک کښتۍ"),
            keywords: &["چټک کښتۍ", "کښتۍ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("lancha"),
            keywords: &["barco", "lancha", "veículo"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("utqhay lancha"),
            keywords: &["utqhay lancha", "wamp’u"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("barcă de viteză"),
            keywords: &["barcă", "barcă de viteză", "motor", "viteză", "șalupă"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-952"),
            keywords: &["E10-952"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("катер"),
            keywords: &["вода", "двигатель", "катер", "мотор"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("icyombo"),
            keywords: &["icyombo", "ubwato"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("تيز رفتار ٻيڙي"),
            keywords: &["تيز رفتار ٻيڙي", "ٻيڙي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("වේග බෝට\u{dca}ට\u{dd4}ව"),
            keywords: &[
                "බෝට\u{dca}ට\u{dd4}\u{dd4}ව",
                "ව\u{dcf}හනය",
                "වේග බෝට\u{dca}ට\u{dd4}ව",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("rýchly čln"),
            keywords: &["loď", "motor", "motorový čln", "rýchly čln", "čln"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("gliser"),
            keywords: &["gliser", "vozilo", "čoln"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("doon dheeraysa"),
            keywords: &["doon", "doon dheeraysa"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("motobarkë e shpejtë"),
            keywords: &["barkë", "mjet lundrimi", "motobarkë e shpejtë", "varkë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("глисер"),
            keywords: &["глисер", "чaмaц"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["глисер"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("gliser"),
            keywords: &["gliser", "čamac"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["gliser"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("racerbåt"),
            keywords: &["båt", "fordon", "racerbåt"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mashua ya kasi"),
            keywords: &["boti", "gari", "mashua ya kasi"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("அதிவேக படகு"),
            keywords: &["அதிவேக படகு", "கடல\u{bcd} பயணம\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("స\u{c4d}ప\u{c40}డ\u{c4d} పడవ"),
            keywords: &["పడవ", "స\u{c4d}ప\u{c40}డ\u{c4d}"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("катери тезгард"),
            keywords: &["катери тезгард", "қаиқ"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เร\u{e37}อด\u{e48}วน"),
            keywords: &["ยานพาหนะ", "เร\u{e37}อ", "เร\u{e37}อด\u{e48}วน"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("tiz kater"),
            keywords: &["gaýyk", "tiz kater"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("vaka oma"),
            keywords: &["vaka oma"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("sürat teknesi"),
            keywords: &["sürat teknesi", "taşıt", "tekne"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("تېز قېيىق"),
            keywords: &["تېز قېيىق", "قېيىق"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("швидкохідний катер"),
            keywords: &["транспорт", "човен", "швидкохідний катер"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("انجن والی کشتی"),
            keywords: &["انجن والی کشتی", "سواری", "کشتی"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("tezyurar qayiq"),
            keywords: &["qayiq", "tezyurar qayiq", "transport"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("xuồng cao tốc"),
            keywords: &["thuyền", "xuồng cao tốc"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("gaalu motër"),
            keywords: &["gaal", "gaalu motër"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("iphenyana lesantya"),
            keywords: &["iphenyana", "iphenyana lesantya"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ọkọ omi alare"),
            keywords: &["Ọkọ omi alare", "ọkọ\u{300} ojú omi"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("快艇"),
            keywords: &["快艇", "艇"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("快艇"),
            keywords: &["快艇", "艇"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("快艇"),
            keywords: &["快艇", "船"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("快艇"),
            keywords: &["快艇"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("快艇"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("isikebhe esinesivinini esikhulu"),
            keywords: &["isikebhe", "isikebhe esinesivinini esikhulu", "isithuthi"],
        },
    ],
};
#[doc = "🛳\u{fe0f}"]
pub const PASSENGER_SHIP: crate::Emoji = crate::Emoji {
    glyph: "🛳\u{fe0f}",
    codepoint: "1F6F3 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.7f32,
    name: "passenger ship",
    group: "Travel & Places",
    subgroup: "transport-water",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🛳",
        codepoint: "1F6F3",
        status: crate::Status::Unqualified,
        introduction_version: 0.7f32,
        name: "passenger ship",
        group: "Travel & Places",
        subgroup: "transport-water",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("passasierskip"),
            keywords: &[
                "passasier",
                "passasierskip",
                "see",
                "skip",
                "vaar",
                "voertuig",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የመንገደኞች መርከብ"),
            keywords: &["መርከብ", "መንገደኛ", "ተሽከርካሪ", "የመንገደኞች መርከብ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("سفينة ركاب"),
            keywords: &["راكب", "سفينة", "سفينة ركاب", "مركبة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("য\u{9be}ত\u{9cd}ৰীব\u{9be}হী জ\u{9be}হ\u{9be}জ"),
            keywords: &[
                "জ\u{9be}হ\u{9be}জ",
                "য\u{9be}ত\u{9cd}ৰী",
                "য\u{9be}ত\u{9cd}ৰীব\u{9be}হী জ\u{9be}হ\u{9be}জ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("sərnişin gəmisi"),
            keywords: &["gəmi", "nəqliyyat", "sərnişin", "sərnişin gəmisi"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("пасажырскі лайнер"),
            keywords: &[
                "карабель",
                "круіз",
                "падарожжа",
                "пасажырскі лайнер",
                "судна",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("пътнически кораб"),
            keywords: &["кораб", "превозно средство", "пътнически"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("য\u{9be}ত\u{9cd}রীব\u{9be}হী জ\u{9be}হ\u{9be}জ"),
            keywords: &[
                "জ\u{9be}হ\u{9be}জ",
                "য\u{9be}ত\u{9cd}রী",
                "য\u{9be}ত\u{9cd}রীব\u{9be}হী জ\u{9be}হ\u{9be}জ",
                "য\u{9be}নব\u{9be}হন",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("mordreizher"),
            keywords: &["lestr", "mordreizher"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("putnički brod"),
            keywords: &["brod", "putnik", "putnički brod"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("vaixell de passatgers"),
            keywords: &["passatgers", "vaixell", "vaixell de passatgers"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏴᏫ ᎠᏣᏍᎩ ᎡᏆ ᏥᏳ"),
            keywords: &["ᎡᏆ ᏥᏳ", "ᏴᏫ ᎠᏣᏍᎩ", "ᏴᏫ ᎠᏣᏍᎩ ᎡᏆ ᏥᏳ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("zaoceánská loď"),
            keywords: &[
                "doprava",
                "loď",
                "osobní",
                "plavidlo",
                "trajekt",
                "zaoceánská loď",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("llong deithwyr"),
            keywords: &["llong", "llong deithwyr", "teithiwr"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("passagerskib"),
            keywords: &["fartøj", "passager", "passagerskib", "skib"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Passagierschiff"),
            keywords: &["Passagierschiff", "Schiff", "Seereise"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("επιβατηγό πλοίο"),
            keywords: &["επιβάτης", "επιβατηγό πλοίο", "πλοίο", "όχημα"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("passenger ship"),
            keywords: &["passenger", "ship"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: None,
            keywords: &["cruise", "liner", "passenger", "ship"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("barco de pasajeros"),
            keywords: &["barco", "barco de pasajeros", "pasajeros", "vehículo"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["barco", "barco de pasajeros", "pasajeros", "transporte"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("reisilaev"),
            keywords: &["laev", "reisija", "reisilaev", "sõiduk"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("gurutzaontzia"),
            keywords: &["bidaiari", "gurutzaontzia", "ibilgailu", "itsasontzi"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("کشتی مسافربری"),
            keywords: &["مسافر", "مسافربری", "مسافرتی", "کشتی"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("matkustajalaiva"),
            keywords: &[
                "ajoneuvo",
                "alus",
                "laiva",
                "matkustajalaiva",
                "meri",
                "vene",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("pampasaherong barko"),
            keywords: &[
                "barko",
                "pampasahero",
                "pampasaherong barko",
                "sasakyan",
                "sasakyang pandagat",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("ferðamannaskip"),
            keywords: &["ferðafólk", "ferðamannaskip", "skip"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("paquebot"),
            keywords: &["bateau", "paquebot"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("long paisinéirí"),
            keywords: &[
                "feithicil",
                "long",
                "long paisinéirí",
                "long phaisinéirí",
                "paisinéir",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("long thaistealach"),
            keywords: &["long", "long thaistealach", "taistealach"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("barco de pasaxeiros"),
            keywords: &["barco", "barco de pasaxeiros", "cruceiro"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("યાત\u{acd}રી વહાણ"),
            keywords: &["યાત\u{acd}રી", "વહાણ", "વાહન"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("jirgin ruwa na fasinja"),
            keywords: &["fasinja", "jirgin ruwa", "jirgin ruwa na fasinja"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("ספינת נוסעים"),
            keywords: &["נוסעים", "ספינה", "ספינת נוסעים", "קרוז", "שיט"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("यात\u{94d}री जहाज"),
            keywords: &["जहाज", "यात\u{94d}री", "वाहन"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("putnički brod"),
            keywords: &["brod", "putnik", "putnički brod", "vozilo"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("utasszállító hajó"),
            keywords: &["csónak", "utasszállítás", "utasszállító hajó", "vízi jármű"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ուղևորատար նավ"),
            keywords: &["նավ", "ուղևոր", "ուղևորատար նավ", "փոխադրամիջոց"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("kapal penumpang"),
            keywords: &["kapal", "kendaraan", "penumpang"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ụgbọmmiri ndị njem"),
            keywords: &["ndị njem", "oke ọsọ", "ụgbọmmiri ndị njem"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("farþegaskip"),
            keywords: &["farartæki", "farþegaskip", "farþegi", "skip"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("nave da crociera"),
            keywords: &["crociera", "nave", "nave da crociera", "vacanza"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("客船"),
            keywords: &["乗り物", "客船", "旅客船", "船"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("kapal panumpang"),
            keywords: &["kapal", "panumpang"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("სამგზავრო გემი"),
            keywords: &["გემი", "სამგზავრო", "ტრანსპორტი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("жолаушылар тасымалдайтын кеме"),
            keywords: &["жолаушы", "жолаушылар тасымалдайтын кеме", "кеме", "көлік"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("passagerskib"),
            keywords: &["fartøj", "passager", "passagerskib", "skib"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("កាប\u{17c9}ាល\u{17cb}ដ\u{17b9}កអ\u{17d2}នកដ\u{17c6}ណើរ"),
            keywords: &[
                "កាប\u{17c9}ាល\u{17cb}",
                "កាប\u{17c9}ាល\u{17cb}ដ\u{17b9}កអ\u{17d2}នកដ\u{17c6}ណើរ",
                "នាវា",
                "អ\u{17d2}នកដ\u{17c6}ណើរ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಪ\u{ccd}ರಯಾಣ\u{cbf}ಕರ ಹಡಗು"),
            keywords: &[
                "ಪ\u{ccd}ಯಾಸ\u{cc6}ಂಜರ\u{ccd}",
                "ಪ\u{ccd}ರಯಾಣ\u{cbf}ಕರ ಹಡಗು",
                "ಹಡಗು",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("여객선"),
            keywords: &["배", "선박", "여객선"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("प\u{94d}रवासी जहाज"),
            keywords: &["जहाज", "प\u{94d}रवास", "प\u{94d}रवासी जहाज"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("жүргүнчүлөрдү ташыган кеме"),
            keywords: &["жүргүнчү", "жүргүнчүлөрдү ташыган кеме", "кеме", "унаа"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Passagéierschëff"),
            keywords: &["Passagéier", "Passagéierschëff", "Schëff"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເຮ\u{eb7}ອໂດຍສານ"),
            keywords: &[
                "ຜ\u{eb9}\u{ec9}ໂດຍສານ",
                "ພາຫະນະ",
                "ເຮ\u{eb7}ອ",
                "ເຮ\u{eb7}ອໂດຍສານ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("keleivinis laivas"),
            keywords: &["keleivinis laivas", "keleivis", "laivas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("pasažieru kuģis"),
            keywords: &[
                "kuģis",
                "pasažieri",
                "pasažieru kuģis",
                "transports",
                "ūdens",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kaipuke pāhihi"),
            keywords: &["kaipuke", "pāhihi"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("патнички брод"),
            keywords: &["брод", "патници", "патнички брод", "транспорт"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("യ\u{d3e}ത\u{d4d}രക\u{d4d}ക\u{d3e}ർക\u{d4d}ക\u{d41}ള\u{d4d}ള കപ\u{d4d}പൽ"),
            keywords: &[
                "യ\u{d3e}ത\u{d4d}രക\u{d4d}ക\u{d3e}ർക\u{d4d}ക\u{d41}ള\u{d4d}ള കപ\u{d4d}പൽ",
                "വ\u{d3e}ഹനം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("зорчих хөлөг онгоц"),
            keywords: &["зорчигч", "зорчих хөлөг онгоц", "хөлөг онгоц"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("प\u{94d}रवासी जहाज"),
            keywords: &["जहाज", "प\u{94d}रवासी"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("kapal penumpang"),
            keywords: &["kapal", "penumpang"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("vapur tal-passiġġieri"),
            keywords: &["passiġġieri", "vapur", "vapur tal-passiġġieri"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ခရ\u{102e}းသည\u{103a}တင\u{103a} သင\u{103a}\u{1039}ဘော"),
            keywords: &[
                "ခရ\u{102e}းသည\u{103a}",
                "ခရ\u{102e}းသည\u{103a}တင\u{103a} သင\u{103a}\u{1039}ဘော",
                "သင\u{103a}\u{1039}ဘော",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("passasjerskip"),
            keywords: &[
                "båt",
                "fremkomstmiddel",
                "passasjer",
                "passasjerskip",
                "skip",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("यात\u{94d}री जहाज"),
            keywords: &["गाडी", "जहाज", "यात\u{94d}री"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("passagiersschip"),
            keywords: &["passagier", "passagiersschip", "schip"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("passasjerskip"),
            keywords: &[
                "båt",
                "framkomstmiddel",
                "passasjer",
                "passasjerskip",
                "skip",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଯ\u{b3e}ତ\u{b4d}ରୀବ\u{b3e}ହ\u{b3f} ଜ\u{b3e}ହ\u{b3e}ଜ"),
            keywords: &[
                "ଜ\u{b3e}ହ\u{b3e}ଜ",
                "ଯ\u{b3e}ତ\u{b4d}ରୀ",
                "ଯ\u{b3e}ତ\u{b4d}ରୀବ\u{b3e}ହ\u{b3f} ଜ\u{b3e}ହ\u{b3e}ଜ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਸਮ\u{a41}\u{a70}ਦਰੀ ਯਾਤਰੀ ਜਹਾਜ\u{a3c}"),
            keywords: &[
                "ਯਾਤਰੀ",
                "ਵਾਹਨ",
                "ਸਮ\u{a41}\u{a70}ਦਰੀ ਜਹਾਜ\u{a3c}",
                "ਸਮ\u{a41}\u{a70}ਦਰੀ ਯਾਤਰੀ ਜਹਾਜ\u{a3c}",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("مسافر بحری جہاز"),
            keywords: &["بحری-جہاز", "مسافر", "مسافر بحری جہاز"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Pásínjá Ship"),
            keywords: &["Pásínja", "Pásínjá Ship", "Ship"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("statek pasażerski"),
            keywords: &["okręt", "pasażerski", "pojazd", "statek"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("مسافر آبګوټ"),
            keywords: &["آبګوټ", "مسافر"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("cruzeiro"),
            keywords: &["cruzeiro", "navio", "passageiros", "veículo"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("navio de passageiros"),
            keywords: &["navio", "navio de passageiros", "passageiros", "veículo"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("pasajero barcomanta"),
            keywords: &["barco", "pasajero", "pasajero barcomanta"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("vas de pasageri"),
            keywords: &["croazieră", "navă", "pasageri", "vas de pasageri"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1004"),
            keywords: &["E10-1004"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("пассажирский лайнер"),
            keywords: &[
                "круиз",
                "лайнер",
                "пассажирский лайнер",
                "пассажиры",
                "перевозки",
                "судно",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ubwato bw’umugenzi"),
            keywords: &["ubwato", "ubwato bw’umugenzi", "umugenzi"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("مسافر بحري جهاز"),
            keywords: &["بحري جهاز", "مسافر", "مسافر بحري جهاز"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("මග\u{dd3} නැව"),
            keywords: &["නැව", "මග\u{dd2}ය\u{dcf}", "මග\u{dd3} නැව", "ව\u{dcf}හනය"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("zaoceánska loď"),
            keywords: &["dopravný prostriedok", "loď", "pasažier", "zaoceánska loď"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("potniška ladja"),
            keywords: &["ladja", "potnik", "potniška ladja", "vozilo"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("rakaab markab"),
            keywords: &["markab", "rakaab"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("anije udhëtarësh"),
            keywords: &["anije", "anije udhëtarësh", "mjet lundrimi", "udhëtar"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("путнички брод"),
            keywords: &["брoд", "путнички брод"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["путнички брод"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("putnički brod"),
            keywords: &["brod", "putnički brod"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["putnički brod"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("passagerarfartyg"),
            keywords: &["fartyg", "fordon", "passagerare", "passagerarfartyg"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("meli ya abiria"),
            keywords: &["abiria", "meli", "meli ya abiria"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பயணிக\u{bcd} கப\u{bcd}பல\u{bcd}"),
            keywords: &[
                "கடல\u{bcd} பயணம\u{bcd}",
                "கப\u{bcd}பல\u{bcd}",
                "பயணிக\u{bcd} கப\u{bcd}பல\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ప\u{c4d}రయ\u{c3e}ణ\u{c3f}కుల ఓడ"),
            keywords: &[
                "ఓడ",
                "ప\u{c4d}రయ\u{c3e}ణం",
                "ప\u{c4d}రయ\u{c3e}ణ\u{c3f}కుల ఓడ",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("киштии мусофиркаш"),
            keywords: &["киштии мусофиркаш", "киштӣ", "мусофир"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เร\u{e37}อโดยสาร"),
            keywords: &["เร\u{e37}อ", "เร\u{e37}อโดยสาร"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ýolagçy gämisi"),
            keywords: &["gämi", "ýolagçy", "ýolagçy gämisi"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("vaka meili"),
            keywords: &["vaka meili"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("yolcu gemisi"),
            keywords: &["gemi", "taşıt", "yolcu", "yolcu gemisi"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("يولۇچىلار كېمىسى"),
            keywords: &["كېمە", "يولۇچى", "يولۇچىلار كېمىسى"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("пасажирський корабель"),
            keywords: &["корабель", "пасажир", "пасажирський корабель", "транспорт"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("مسافر بحری جہاز"),
            keywords: &["سواری", "مسافر", "مسافر بحری جہاز", "کشتی"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("yo‘lovchi kemasi"),
            keywords: &["kema", "transport", "yo‘lovchi", "yo‘lovchi kemasi"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("tàu chở khách"),
            keywords: &["hành khách", "tàu chở khách", "tàu thủy"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("ki mu yab bato"),
            keywords: &["bato", "ki mu yab", "ki mu yab bato"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("inqanawa yepasenja"),
            keywords: &["inqanawa", "inqanawa yepasenja", "ipasenja"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("ọkọ\u{300} ojú omi ńlá èrò"),
            keywords: &[
                "èrò",
                "ọkọ\u{300} ojú omi ńlá",
                "ọkọ\u{300} ojú omi ńlá èrò",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("客船"),
            keywords: &["乘客", "客船", "船"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("客船"),
            keywords: &["乘客", "客船", "船"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("客轮"),
            keywords: &["客船", "客轮"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("客船"),
            keywords: &["客船", "船"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("客輪"),
            keywords: &["客輪", "船"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("umkhumbi othwala abagbeli"),
            keywords: &[
                "isithuthi",
                "umgibeli",
                "umkhumbi",
                "umkhumbi othwala abagbeli",
            ],
        },
    ],
};
#[doc = "⛴\u{fe0f}"]
pub const FERRY: crate::Emoji = crate::Emoji {
    glyph: "⛴\u{fe0f}",
    codepoint: "26F4 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.7f32,
    name: "ferry",
    group: "Travel & Places",
    subgroup: "transport-water",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "⛴",
        codepoint: "26F4",
        status: crate::Status::Unqualified,
        introduction_version: 0.7f32,
        name: "ferry",
        group: "Travel & Places",
        subgroup: "transport-water",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("veerboot"),
            keywords: &["boot", "pont", "veerboot"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ከባድ የመንገደኞች መርከብ"),
            keywords: &["ከባድ የመንገደኞች መርከብ", "ጀልባ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("عب\u{651}ارة"),
            keywords: &["عب\u{651}ارة", "مركب"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ফেৰী"),
            keywords: &["ন\u{9be}ও", "ফেৰী", "য\u{9be}ত\u{9cd}ৰী"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("bərə gəmisi"),
            keywords: &["bərə gəmisi", "qayıq"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("паром"),
            keywords: &["карабель", "паром"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("ферибот"),
            keywords: &["кораб", "ферибот"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("খেয\u{9bc}\u{9be}"),
            keywords: &["খেয\u{9bc}\u{9be}", "নৌক\u{9be}"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("lestr-treizh"),
            keywords: &["bag", "lestr-treizh"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("trajekt"),
            keywords: &["brod", "trajekt", "čamac"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("ferri"),
            keywords: &["ferri", "vaixell", "vaixell de passatgers"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏗᎦᏐᎯᏍᏗᏍᎩ"),
            keywords: &["ᏗᎦᏐᎯᏍᏗᏍᎩ", "ᏥᏳ", "ᏴᏫ ᎠᏣᏍᎩ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("trajekt"),
            keywords: &[
                "doprava", "loď", "osobní", "plavidlo", "přívoz", "trajekt", "člun",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("fferi"),
            keywords: &["cwch", "fferi", "teithiwr"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("færge"),
            keywords: &["båd", "færge"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Fähre"),
            keywords: &["Fähre", "Schiff"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("φεριμπότ"),
            keywords: &["βάρκα", "φεριμπότ"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("ferry"),
            keywords: &["boat", "ferry", "passenger"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("ferri"),
            keywords: &["barco", "ferri", "ferry"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("transbordador"),
            keywords: &["bote", "ferry", "transbordador", "trasbordador", "vehículo"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &[
                "bote",
                "ferry",
                "transbordador",
                "transporte",
                "trasbordador",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("praam"),
            keywords: &["laev", "praam", "sõiduk"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("ferrya"),
            keywords: &["ferrya", "itsasontzi"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("فرابر"),
            keywords: &["سرنشین", "فرابر", "قایق", "مسافر"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("lautta"),
            keywords: &["ajoneuvo", "alus", "laiva", "lautta", "meri"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("ferry"),
            keywords: &[
                "bangka",
                "barko",
                "ferry",
                "pampasahero",
                "pandagat",
                "sasakyan",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("ferja"),
            keywords: &["bátur", "ferja", "ferðafólk"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("ferry"),
            keywords: &["bateau", "ferry"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("traversier"),
            keywords: &["bateau", "passager", "traversier"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("bád farantóireachta"),
            keywords: &["bád", "bád farantóireachta", "bád fartha"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("bàta-aiseig"),
            keywords: &["bàta", "bàta-aiseig", "taistealach"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("ferri"),
            keywords: &["barco", "ferri", "transbordador"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ફ\u{ac7}રી"),
            keywords: &["નાવડી", "ફ\u{ac7}રી", "બોટ", "હોડી"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("jirgin fito"),
            keywords: &["fasinja", "jirgin fito", "jirgin ruwa na sauri"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("מעבורת"),
            keywords: &["אונייה", "מעבורת", "נוסעים", "ספינה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("नौका"),
            keywords: &["नाव", "नौका"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("trajekt"),
            keywords: &["brod", "putnici", "trajekt"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("komp"),
            keywords: &["hajó", "komp", "utasszállítás"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("լաստանավ"),
            keywords: &["լաստանավ", "նավակ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("kapal feri"),
            keywords: &["kapal feri", "perahu"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ụgbọ mmiri njem"),
            keywords: &["ndị njem", "ụgbọ mmiri njem", "ụgbọmmiri"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("ferja"),
            keywords: &["bátur", "ferja"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("traghetto"),
            keywords: &["barca", "traghetto", "traversata"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("フェリー"),
            keywords: &["フェリー", "乗り物", "船"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("kapal feri"),
            keywords: &["feri", "kapal", "panumpang"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ბორანი"),
            keywords: &["ბორანი", "გემი", "ნავი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("паром"),
            keywords: &["паром", "қайық"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("færge"),
            keywords: &["båd", "færge"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("សាឡាង"),
            keywords: &[
                "ទ\u{17bc}ក",
                "សាឡាង",
                "ស\u{17d2}រឡាង",
                "អ\u{17d2}នកដ\u{17c6}ណើរ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಫ\u{cc6}ರ\u{ccd}ರೀ"),
            keywords: &[
                "ದೋಣ\u{cbf}",
                "ಪ\u{ccd}ಯಾಸ\u{cc6}ಂಜರ\u{ccd}",
                "ಫ\u{cc6}ರ\u{ccd}ರೀ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("페리"),
            keywords: &["보트", "연락선", "페리"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("फ\u{947}री"),
            keywords: &["प\u{94d}रवास", "फ\u{947}री", "बोट"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("паром"),
            keywords: &["кайык", "паром"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Fähr"),
            keywords: &["Boot", "Fähr", "Passagéier"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເຮ\u{eb7}ອເຟ\u{eb5}ຣ\u{eb5}"),
            keywords: &["ເຮ\u{eb7}ອ", "ເຮ\u{eb7}ອເຟ\u{eb5}ຣ\u{eb5}"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("keltas"),
            keywords: &["keleivis", "keltas", "valtis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("prāmis"),
            keywords: &["kuģis", "pasažieri", "prāmis", "transports", "ūdens"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("waka kawekawe"),
            keywords: &["poti", "pāhihi", "waka kawekawe"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("траект"),
            keywords: &["брод", "траект", "транспорт"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("കടത\u{d4d}ത\u{d4d} വള\u{d4d}ളം"),
            keywords: &["കടത\u{d4d}ത\u{d4d} വള\u{d4d}ളം", "ബോട\u{d4d}ട\u{d4d}"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("гатлага хөлөг онгоц"),
            keywords: &["гатлага", "гатлага хөлөг онгоц", "хөлөг онгоц"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("फ\u{947}री"),
            keywords: &["प\u{94d}रवासी", "फ\u{947}री", "बोट"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("feri"),
            keywords: &["bot", "feri"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("lanċa"),
            keywords: &["dgħajsa", "lanċa", "passiġġieri"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("က\u{1030}းတ\u{102d}\u{102f}\u{1037}"),
            keywords: &[
                "က\u{1030}းတ\u{102d}\u{102f}\u{1037}",
                "ခရ\u{102e}းသည\u{103a}",
                "သင\u{103a}\u{1039}ဘော",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("ferge"),
            keywords: &["båt", "ferge", "passasjer"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("फ\u{947}री"),
            keywords: &["ड\u{941}ङ\u{94d}गा", "फ\u{947}री"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("veerboot"),
            keywords: &["boot", "passagier", "veerboot"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("ferje"),
            keywords: &["båt", "ferje", "passasjer"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଡଙ\u{b4d}ଗ\u{b3e}"),
            keywords: &["ଡଙ\u{b4d}ଗ\u{b3e}", "ନୌକ\u{b3e}", "ଯ\u{b3e}ତ\u{b4d}ରୀ"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਫ\u{a48}ਰੀ"),
            keywords: &["ਕਿਸ\u{a3c}ਤੀ", "ਫ\u{a48}ਰੀ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("کشتی نال دریا پار کرنا"),
            keywords: &["مسافر", "کشتی", "کشتی نال دریا پار کرنا"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Fẹ\u{301}ri"),
            keywords: &["Bot", "Fẹ\u{301}ri", "Pásínja"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("prom"),
            keywords: &["prom", "łódź"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("بېړۍ"),
            keywords: &["بېړۍ", "مسافر", "کښتۍ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("balsa"),
            keywords: &["balsa", "barco", "ferry boat", "ferry-boat"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("ferry"),
            keywords: &["barco", "ferry"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("apay"),
            keywords: &["apay", "pasajero", "wamp’u"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("feribot"),
            keywords: &["feribot", "navă", "pasageri", "transport"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-114"),
            keywords: &["E10-114"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("паром"),
            keywords: &["паром", "перевозки", "транспорт"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("Ubwato butwara abantu"),
            keywords: &["Ubwato butwara abantu", "ubwato", "umugenzi"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ٻيڙين جو اڏو"),
            keywords: &["مسافر", "ٻيڙي", "ٻيڙين جو اڏو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("පහ\u{dd4}ර"),
            keywords: &["පහ\u{dd4}ර", "බෝට\u{dca}ට\u{dd4}ව"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("trajekt"),
            keywords: &["loď", "trajekt"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("trajekt"),
            keywords: &["ladja", "trajekt"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("rakaab qaadis"),
            keywords: &["doon", "rakaab", "rakaab qaadis"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("traget"),
            keywords: &["traget", "udhëtar", "varkë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("трајект"),
            keywords: &["трајект", "чaмaц"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("trajekt"),
            keywords: &["trajekt", "čamac"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("färja"),
            keywords: &["båt", "färja", "passagerare"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kivuko"),
            keywords: &["boti", "kivuko"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("feri"),
            keywords: &["boti", "feri", "kivuko"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ஃபெர\u{bcd}ரி"),
            keywords: &[
                "ஃபெர\u{bcd}ரி",
                "கடல\u{bcd} பயணம\u{bcd}",
                "கப\u{bcd}பல\u{bcd}",
                "படகு",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("బల\u{c4d}ల కట\u{c4d}టు"),
            keywords: &["కట\u{c4d}టు", "బల\u{c4d}ల"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("киштии гузора"),
            keywords: &["киштии гузора", "мусофир", "қаиқ"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เร\u{e37}อเฟอร\u{e4c}ร\u{e35}"),
            keywords: &["เร\u{e37}อ", "เร\u{e37}อเฟอร\u{e4c}ร\u{e35}"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("parom"),
            keywords: &["gaýyk", "parom", "ýolagçy"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("vaka uta pāsese"),
            keywords: &["vaka uta pāsese"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("feribot"),
            keywords: &["feribot", "tekne"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ساياھەت كېمىسى"),
            keywords: &["ساياھەت كېمىسى", "قېيىق", "يولۇچى"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("пором"),
            keywords: &["пором", "човен"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("فیری"),
            keywords: &["سواری", "فیری", "کشتی"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("parom"),
            keywords: &["parom", "qayiq"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("phà"),
            keywords: &["hành khách", "phà", "thuyền"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("bak"),
            keywords: &["bak", "gaal", "ki mu yab"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("isikhitshana"),
            keywords: &["ipasenja", "iphenyana", "isikhitshana"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("ferí"),
            keywords: &["ferí", "èrò", "ọkọ\u{300} ojú omi"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("渡船"),
            keywords: &["乘客", "渡船", "艇"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("渡船"),
            keywords: &["乘客", "渡船", "艇"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("渡轮"),
            keywords: &["渡船", "渡轮", "轮船"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("渡輪"),
            keywords: &["渡輪", "船"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("isikebhe sokuwelisa"),
            keywords: &["isikebhe", "isikebhe sokuwelisa"],
        },
    ],
};
#[doc = "🛥\u{fe0f}"]
pub const MOTOR_BOAT: crate::Emoji = crate::Emoji {
    glyph: "🛥\u{fe0f}",
    codepoint: "1F6E5 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.7f32,
    name: "motor boat",
    group: "Travel & Places",
    subgroup: "transport-water",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🛥",
        codepoint: "1F6E5",
        status: crate::Status::Unqualified,
        introduction_version: 0.7f32,
        name: "motor boat",
        group: "Travel & Places",
        subgroup: "transport-water",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("motorboot"),
            keywords: &["boot", "motorboot", "voertuig"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ባለሞተር ጀልባ"),
            keywords: &["ሞተር ጀልባ", "ባለሞተር ጀልባ", "ተሽከርካሪ", "ጀልባ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("زورق بخاري"),
            keywords: &["بخاري", "زورق", "مركب", "مركبة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("মটৰ ব’ট"),
            keywords: &["ন\u{9be}ও", "মটৰ ব’ট", "মটৰব’ট"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("motorlu qayıq"),
            keywords: &["motorlu qayıq", "nəqliyyat", "qayıq"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("маторная лодка"),
            keywords: &["вада", "лодка", "матор", "маторная лодка"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("моторна яхта"),
            keywords: &["кораб", "моторна яхта", "превозно средство"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("মোটরবোট"),
            keywords: &["নৌক\u{9be}", "মোটরবোট", "য\u{9be}নব\u{9be}হন"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("bag-a-dan"),
            keywords: &["bag", "bag-a-dan"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("motorni čamac"),
            keywords: &["motor", "motorni čamac", "vozilo", "čamac"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("llanxa de motor"),
            keywords: &["llanxa", "llanxa de motor", "motor", "vaixell"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎦᏣᏄᎵ ᏥᏳ"),
            keywords: &["ᎦᏣᏄᎵ ᏥᏳ", "ᏥᏳ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("motorová jachta"),
            keywords: &["loď", "motorová jachta", "motorová loď", "plavidlo", "člun"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("cwch modur"),
            keywords: &["cerbyd", "cwch", "cwch modur"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("motorbåd"),
            keywords: &["båd", "fartøj", "motorbåd"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Motorboot"),
            keywords: &["Boot", "Motorboot", "Schiff"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("μηχανοκίνητο σκάφος"),
            keywords: &["βάρκα", "μηχανοκίνητο σκάφος", "όχημα"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("motor boat"),
            keywords: &["boat", "motor boat", "motorboat"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("motorboat"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("barco a motor"),
            keywords: &["barco", "barco a motor", "motor", "vehículo"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["barco a motor", "bote", "motor", "vehículo"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("mootorpaat"),
            keywords: &["mootorpaat", "paat", "sõiduk"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("motordun txalupa"),
            keywords: &["ibilgailu", "itsasontzi", "motordun txalupa", "motorra"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("قایق موتوری"),
            keywords: &["قایق", "قایق موتوری", "قایق\u{200c}موتوری", "لتکا"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("moottorivene"),
            keywords: &["ajoneuvo", "meri", "moottorivene", "pikavene", "vene"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("bangkang de-motor"),
            keywords: &[
                "bangka",
                "bangkang de-motor",
                "de-motor",
                "motorboat",
                "sasakyang pandagat",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("maskinbátur"),
            keywords: &["bátur", "maskinbátur", "motorbátur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("bateau à moteur"),
            keywords: &["bateau", "bateau à moteur"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["bateau", "bateau à moteur", "moteur"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("mótarbhád"),
            keywords: &["bád", "feithicil", "mótarbhád"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("bàta-motair"),
            keywords: &["bàta", "bàta-motair", "motar"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("barco a motor"),
            keywords: &["barco", "barco a motor", "motor"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("મોટર બોટ"),
            keywords: &["બોટ", "મોટર બોટ", "વાહન"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("jirgin ruwa mai inji"),
            keywords: &["jirgin ruwa mai inji", "jirgin ruwa na sauri"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("סירת מנוע"),
            keywords: &["יאכטה", "מנוע", "סירה", "סירת מנוע"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("मोटर बोट"),
            keywords: &["नाव", "मोटर बोट", "मोटरबोट", "वाहन"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("motorni čamac"),
            keywords: &["motor", "motorni čamac", "vozilo", "čamac"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("motorcsónak"),
            keywords: &["csónak", "motorcsónak", "utasszállítás"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("մոտորանավակ"),
            keywords: &["մոտորանավակ", "նավակ", "փոխադրամիջոց"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("perahu bermotor"),
            keywords: &["bermotor", "kapal", "kendaraan", "perahu"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ụgbọmmiri ụgbọala"),
            keywords: &["ụgbọmmiri", "ụgbọmmiri ụgbọala", "ụgbọmmiriụgbọala"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("mótorbátur"),
            keywords: &["bátur", "farartæki", "mótorbátur"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("barca a motore"),
            keywords: &["barca", "barca a motore", "motore"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("モーターボート"),
            keywords: &["ボート", "モーターボート", "乗り物", "船"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("kapal motor"),
            keywords: &["kapal", "kapal motor"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მოტორიანი გემი"),
            keywords: &["გემი", "მოტორიანი გემი", "ნავი", "ტრანსპორტი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("моторлы қайық"),
            keywords: &["көлік", "моторлы қайық", "қайық"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("motorbåd"),
            keywords: &["båd", "fartøj", "motorbåd"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("កាណ\u{17bc}តធន\u{17cb}ធ\u{17c6}"),
            keywords: &["កាណ\u{17bc}ត", "កាណ\u{17bc}តធន\u{17cb}ធ\u{17c6}"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಮೋಟರ\u{ccd} ದೋಣ\u{cbf}"),
            keywords: &["ದೋಣ\u{cbf}", "ಮೋಟರ\u{ccd} ದೋಣ\u{cbf}", "ಮೋಟಾರು ದೋಣ\u{cbf}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("모터보트"),
            keywords: &["모터보트", "보트"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("मोटोर बोट"),
            keywords: &["बोट", "मोटोर बोट", "मोटोरबोट"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("катер"),
            keywords: &["кайык", "катер", "унаа"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Motorboot"),
            keywords: &["Boot", "Motorboot"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເຮ\u{eb7}ອຈ\u{eb1}ກ"),
            keywords: &["ພາຫະນະ", "ເຮ\u{eb7}ອ", "ເຮ\u{eb7}ອຈ\u{eb1}ກ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("motorinė valtis"),
            keywords: &["motorinė valtis", "valtis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("motorlaiva"),
            keywords: &["laiva", "motorlaiva", "transports", "ūdens"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("waka pūkaha"),
            keywords: &["poti", "waka pūkaha"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("моторен чамец"),
            keywords: &["брод", "мотор", "моторен чамец", "транспорт"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("മോട\u{d4d}ടോർ ബോട\u{d4d}ട\u{d4d}"),
            keywords: &[
                "ബോട\u{d4d}ട\u{d4d}",
                "മോട\u{d4d}ടോർ ബോട\u{d4d}ട\u{d4d}",
                "വ\u{d3e}ഹനം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("моторт онгоц"),
            keywords: &["мотор", "моторт онгоц", "онгоц"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("मोटर बोट"),
            keywords: &["बोट", "मोटर बोट", "मोटरबोट"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("motobot"),
            keywords: &["bot", "motobot"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("dgħajsa bil-mutur"),
            keywords: &["dgħajsa", "dgħajsa bil-mutur"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("စက\u{103a}တပ\u{103a} လ\u{103e}ေ"),
            keywords: &[
                "စက\u{103a}တပ\u{103a} လ\u{103e}ေ",
                "စက\u{103a}တပ\u{103a}လ\u{103e}ေ",
                "စက\u{103a}လ\u{103e}ေ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("motorbåt"),
            keywords: &["båt", "fremkomstmiddel", "motorbåt"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("मोटर ड\u{941}ङ\u{94d}गा"),
            keywords: &[
                "गाडी",
                "ड\u{941}ङ\u{94d}गा",
                "मोटर ड\u{941}ङ\u{94d}गा",
                "मोटरबोट",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("motorboot"),
            keywords: &["boot", "motorboot"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("motorbåt"),
            keywords: &["båt", "framkomstmiddel", "motorbåt"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ମୋଟର ବୋଟ\u{b4d}\u{200c}"),
            keywords: &[
                "ନୌକ\u{b3e} । ମୋଟରବୋଟ\u{b4d}\u{200c}",
                "ମୋଟର ବୋଟ\u{b4d}\u{200c}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਮ\u{a4b}ਟਰਬ\u{a4b}ਟ"),
            keywords: &[
                "ਕਿਸ\u{a3c}ਤੀ",
                "ਮ\u{a4b}ਟਰ ਵਾਲੀ ਕਿਸ\u{a3c}ਤੀ",
                "ਮ\u{a4b}ਟਰਬ\u{a4b}ਟ",
                "ਵਾਹਨ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("موٹر آلی کشتی"),
            keywords: &["موٹر آلی کشتی", "کشتی"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Moto Bot"),
            keywords: &["Bot", "Moto Bot", "Motobot"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("motorówka"),
            keywords: &["motorówka", "pojazd", "łódź motorowa"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("موټر کشتۍ"),
            keywords: &["موټر کشتۍ", "موټر کښتۍ", "موټرکښتۍ", "کښتۍ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("barco"),
            keywords: &["barco", "motor", "veículo"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("barco a motor"),
            keywords: &["barco", "barco a motor", "motor", "veículo"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("lancha motorwan"),
            keywords: &["lancha motorwan", "wamp’u"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("barcă cu motor"),
            keywords: &["barcă", "barcă cu motor", "motonavă", "motor", "șalupă"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-999"),
            keywords: &["E10-999"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("моторная лодка"),
            keywords: &[
                "вода",
                "двигатель",
                "лодка",
                "мотор",
                "моторка",
                "моторная лодка",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ubato bwa moteri"),
            keywords: &["ubato bwa moteri", "ubwato", "ubwato bwa moteri"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("موٽر واري ٻيڙي"),
            keywords: &["موٽر واري ٻيڙي", "ٻيڙي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("මෝටර\u{dca} බෝට\u{dca}ට\u{dd4}ව"),
            keywords: &[
                "බෝට\u{dca}ට\u{dd4}ව",
                "මෝටර\u{dca} බෝට\u{dca}ට\u{dd4}ව",
                "ව\u{dcf}හනය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("motorový čln"),
            keywords: &[
                "dopravný prostriedok",
                "loď",
                "motorová loď",
                "motorový čln",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("motorni čoln"),
            keywords: &["ladja", "motorni čoln", "vozilo"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("doon matoor"),
            keywords: &["doon matoor"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("motobarkë"),
            keywords: &["barkë", "mjet lundrimi", "motobarkë", "varkë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("јахта"),
            keywords: &["вoзилo", "мoтoр", "чaмaц", "јахта"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("jahta"),
            keywords: &["jahta", "motor", "vozilo", "čamac"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("motorbåt"),
            keywords: &["båt", "fordon", "motorbåt"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("motaboti"),
            keywords: &["boti", "gari", "motaboti"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("மோட\u{bcd}ட\u{bbe}ர\u{bcd} படகு"),
            keywords: &[
                "கடல\u{bcd} பயணம\u{bcd}",
                "படகு",
                "மோட\u{bcd}ட\u{bbe}ர\u{bcd} படகு",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("మ\u{c4b}ట\u{c3e}రు పడవ"),
            keywords: &["పడవ", "మ\u{c4b}ట\u{c3e}రు"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("қаиқи муҳаррикдор"),
            keywords: &["қаиқ", "қаиқи муҳаррикдор"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เร\u{e37}อยนต\u{e4c}"),
            keywords: &["ยานพาหนะ", "เร\u{e37}อ", "เร\u{e37}อยนต\u{e4c}"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("motorly gaýyk"),
            keywords: &["gaýyk", "motorly gaýyk"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("vaka mīsini"),
            keywords: &["vaka mīsini"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("motorlu tekne"),
            keywords: &["motor", "motorlu tekne", "taşıt", "tekne"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("موتورلۇق قېيىق"),
            keywords: &["قېيىق", "موتور", "موتورلۇق قېيىق"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("моторний човен"),
            keywords: &["моторний", "транспорт", "човен"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("موٹر بوٹ"),
            keywords: &["سواری", "موٹر بوٹ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("motorli qayiq"),
            keywords: &["motorli qayiq", "qayiq", "transport"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("thuyền máy"),
            keywords: &["thuyền", "thuyền máy"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("gaalu-motër"),
            keywords: &["gaal", "gaalu-motër"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("i-motor boat"),
            keywords: &["i-motor boat", "i-motorboat", "iphenyana"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("ọkọ\u{300} ojú omi tó ń lo ẹ\u{300}rọ"),
            keywords: &[
                "ọkọ\u{300} ojú omi",
                "ọkọ\u{300} ojú omi tó ń lo ẹ\u{300}rọ",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("機動船"),
            keywords: &["機動船", "艇"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("机动船"),
            keywords: &["机动船", "艇"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("摩托艇"),
            keywords: &["摩托艇", "船"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("汽艇"),
            keywords: &["汽艇", "船"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["快艇", "汽艇", "船"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("isikebhe esinenjini"),
            keywords: &["isikebhe", "isikebhe esinenjini", "isithuthi"],
        },
    ],
};
#[doc = "🚢"]
pub const SHIP: crate::Emoji = crate::Emoji {
    glyph: "🚢",
    codepoint: "1F6A2",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "ship",
    group: "Travel & Places",
    subgroup: "transport-water",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("skip"),
            keywords: &["boot", "skip", "voertuig"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("መርከብ"),
            keywords: &["መርከብ", "ተሽከርካሪ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("سفينة"),
            keywords: &["سفينة", "مركبة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("জ\u{9be}হ\u{9be}জ"),
            keywords: &["জ\u{9be}হ\u{9be}জ", "ন\u{9be}ও", "য\u{9be}ত\u{9cd}ৰী"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("gəmi"),
            keywords: &["gəmi", "nəqliyyat"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("карабель"),
            keywords: &["карабель", "параход", "перавозкі", "транспарт"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("кораб"),
            keywords: &["кораб", "превозно средство"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("জ\u{9be}হ\u{9be}জ"),
            keywords: &["জ\u{9be}হ\u{9be}জ", "য\u{9be}নব\u{9be}হন"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("lestr"),
            keywords: &["bag", "lestr"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("brod"),
            keywords: &["brod", "vozilo"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("vaixell"),
            keywords: &["mar", "passatgers", "riu", "vaixell", "vehicle"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎡᏆ ᏥᏳ"),
            keywords: &["ᎡᏆ ᏥᏳ", "ᏥᏳ", "ᏴᏫ ᎠᏣᏍᎩ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("loď"),
            keywords: &["doprava", "loď", "osobní", "plavidlo"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("llong"),
            keywords: &["cwch", "llong", "teithiwr"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("skib"),
            keywords: &["fartøj", "skib"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Schiff"),
            keywords: &["Dampfer", "Kreuzfahrtschiff", "Schiff"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("πλοίο"),
            keywords: &["πλοίο", "όχημα"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("ship"),
            keywords: &["boat", "passenger", "ship"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("barco"),
            keywords: &["barco", "vehículo"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["barco", "crucero", "vehículo"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["barco", "crucero", "transporte"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("laev"),
            keywords: &["laev", "sõiduk"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("itsasontzia"),
            keywords: &["ibilgailu", "itsasontzia"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("کشتی"),
            keywords: &["سرنشین", "قایق", "مسافر", "وسیه\u{654} نقلیه", "کشتی"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("laiva"),
            keywords: &["ajoneuvo", "alus", "laiva", "meri"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("barko"),
            keywords: &["barko", "pampasahero", "sasakyan", "sasakyang pandagat"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("skip"),
            keywords: &["ferðafólk", "skip"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("navire"),
            keywords: &["bateau", "navire"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["bateau", "navire", "passager"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("long"),
            keywords: &["feithicil", "long"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("long"),
            keywords: &["bàta", "long", "taistealach"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("barco"),
            keywords: &["barco"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("વહાણ"),
            keywords: &["જહાજ", "વહાણ", "વાહન"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("jirgin ruwa"),
            keywords: &["fasinja", "jirgin ruwa", "jirgin ruwa na sauri"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("ספינה"),
            keywords: &["אוניה", "כלי שיט", "ספינה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("जहाज\u{93c}, वाहन"),
            keywords: &["जहाज\u{93c}", "जहाज\u{93c}, वाहन", "वाहन"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("brod"),
            keywords: &["brod", "putnici", "vozilo"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("hajó"),
            keywords: &["hajó", "vízi jármű"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("նավ"),
            keywords: &["նավ", "փոխադրամիջոց"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("kapal"),
            keywords: &["kapal", "kendaraan"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ụgbọmmiri"),
            keywords: &["ndị njem", "ụgbọmmiri"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("skip"),
            keywords: &["bátur", "skip"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("nave"),
            keywords: &["imbarcazione", "nave", "veicolo"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("船"),
            keywords: &["乗り物", "船"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("kapal gedhe"),
            keywords: &["kapal", "kapal gedhe", "panumpang"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("გემი"),
            keywords: &["გემი", "ტრანსპორტი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("кеме"),
            keywords: &["кеме", "көлік"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("skib"),
            keywords: &["fartøj", "skib"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("កប\u{17c9}ាល\u{17cb}"),
            keywords: &[
                "កប\u{17c9}ាល\u{17cb}",
                "កាប\u{17c9}ាល\u{17cb}",
                "នាវា",
                "អ\u{17d2}នកដ\u{17c6}ណើរ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಹಡಗು"),
            keywords: &["ಪ\u{ccd}ಯಾಸ\u{cc6}ಂಜರ\u{ccd}", "ವಾಹನ", "ಹಡಗು"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("선박"),
            keywords: &["바다", "배", "선박"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("जहाज"),
            keywords: &["जहाज", "प\u{94d}रवासी", "बोट"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("кеме"),
            keywords: &["кеме", "унаа"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Schëff"),
            keywords: &["Boot", "Passagéier", "Schëff"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເຮ\u{eb7}ອກຳປ\u{eb1}\u{ec8}ນ"),
            keywords: &[
                "ກຳປ\u{eb1}\u{ec8}ນ",
                "ພາຫະນະ",
                "ເຮ\u{eb7}ອ",
                "ເຮ\u{eb7}ອກຳປ\u{eb1}\u{ec8}ນ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("laivas"),
            keywords: &["keleivis", "laivas", "valtis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("kuģis"),
            keywords: &["kuģis", "transports", "ūdens"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kaipuke"),
            keywords: &["kaipuke", "poti", "pāhihi"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("брод"),
            keywords: &["брод", "транспорт"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("കപ\u{d4d}പൽ"),
            keywords: &["കപ\u{d4d}പൽ", "വ\u{d3e}ഹനം"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("хөлөг онгоц"),
            keywords: &["тээвэр", "хөлөг онгоц"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("जहाज"),
            keywords: &["जहाज", "प\u{94d}रवासी", "बोट"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("kapal"),
            keywords: &["kapal", "kenderaan"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("vapur"),
            keywords: &["dgħajsa", "passiġġieri", "vapur"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("သင\u{103a}\u{1039}ဘော"),
            keywords: &[
                "ခရ\u{102e}းသည\u{103a}",
                "လ\u{103e}ေ",
                "သင\u{103a}\u{1039}ဘော",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("skip"),
            keywords: &["båt", "fartøy", "fremkomstmiddel", "skip"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("पानी जहाज"),
            keywords: &["गाडी", "पानी जहाज"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("schip"),
            keywords: &["boot", "passagier", "schip"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("skip"),
            keywords: &["båt", "fartøy", "framkomstmiddel", "skip"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଜ\u{b3e}ହ\u{b3e}ଜ"),
            keywords: &["ଜ\u{b3e}ହ\u{b3e}ଜ", "ବ\u{b3e}ହନ", "ସ\u{b3f}ପ\u{b4d}"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਜਹਾਜ\u{a3c}"),
            keywords: &["ਜਹਾਜ\u{a3c}", "ਵਾਹਨ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("بحری-جہاز"),
            keywords: &["بحری-جہاز", "مسافر", "کشتی"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Ship"),
            keywords: &["Bot", "Pásínja", "Ship"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("statek"),
            keywords: &["okręt", "statek"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("بيړۍ"),
            keywords: &["بيړۍ", "مسافر", "کښتۍ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("navio"),
            keywords: &["navio", "veículo aquático"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["barco", "navio", "passageiro"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("nave"),
            keywords: &["nave", "pasajero", "wamp’u"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("vapor"),
            keywords: &["maritim", "navigație", "navă", "pasageri", "vapor", "vas"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-950"),
            keywords: &["E10-950"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("корабль"),
            keywords: &["корабль", "пароход", "перевозки", "судно"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ubwato"),
            keywords: &["ubwato", "umugenzi"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("بحري جهاز"),
            keywords: &["بحري جهاز", "مسافر", "ٻيڙي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("නැව"),
            keywords: &["නැව", "ව\u{dcf}හනය"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("loď"),
            keywords: &["dopravný prostriedok", "loď"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("ladja"),
            keywords: &["ladja", "vozilo"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("markab"),
            keywords: &["doon", "markab", "rakaab"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("anije"),
            keywords: &["anije", "udhëtar", "varkë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("брод"),
            keywords: &["брод", "вoзилo"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("brod"),
            keywords: &["brod", "vozilo"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("fartyg"),
            keywords: &["båt", "fartyg", "fordon"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("meli"),
            keywords: &["abiria", "mashua", "meli"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("கப\u{bcd}பல\u{bcd}"),
            keywords: &["கடல\u{bcd} பயணம\u{bcd}", "கப\u{bcd}பல\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ఓడ"),
            keywords: &["ఓడ", "న\u{c4c}క"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("киштӣ"),
            keywords: &["киштӣ", "мусофир", "қаиқ"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เร\u{e37}อ"),
            keywords: &["ยานพาหนะ", "เร\u{e37}อ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("gämi"),
            keywords: &["gaýyk", "gämi", "ýolagçy"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("vakalahi"),
            keywords: &["vakalahi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("gemi"),
            keywords: &["gemi", "taşıt"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("كېمە"),
            keywords: &["قېيىق", "كېمە", "يولۇچى"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("корабель"),
            keywords: &["корабель", "транспорт"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("بحری جہاز"),
            keywords: &["بحری جہاز", "سواری"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("kema"),
            keywords: &["kema", "transport"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("tàu thủy"),
            keywords: &["hành khách", "thuyền", "tàu thủy"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("gaal gu mag"),
            keywords: &["gaal", "gaal gu mag", "ki mu yab"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("inqanawa"),
            keywords: &["inqanawa", "ipasenja", "iphenyana"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ọkọ\u{300} ojú omi ńlá"),
            keywords: &["èrò", "Ọkọ\u{300} ojú omi ńlá", "ọkọ\u{300} ojú omi"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("船"),
            keywords: &["乘客", "船", "艇"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("船"),
            keywords: &["乘客", "船", "艇"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("船"),
            keywords: &["船"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("船"),
            keywords: &["船"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("umkhumbi"),
            keywords: &["isithuthi", "umkhumbi"],
        },
    ],
};
