#[doc = "🚂"]
pub const LOCOMOTIVE: crate::Emoji = crate::Emoji {
    glyph: "🚂",
    codepoint: "1F682",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "locomotive",
    group: "Travel & Places",
    subgroup: "transport-ground",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("lokomotief"),
            keywords: &["lokomotief", "spoor", "stoom", "trein", "voertuig"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የባቡር ፉርጎ ጎታች"),
            keywords: &["ሞተር", "ባቡር", "ተሽከርካሪ", "እንፋሎት", "የባቡር መንገድ", "የባቡር ፉርጎ ጎታች"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("جرار بخار"),
            keywords: &["جرار", "جرار بخار", "قطار", "مركبة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ল’ক’মটিভ"),
            keywords: &[
                "ইঞ\u{9cd}জিন",
                "ট\u{9cd}ৰেইন",
                "ল’ক’মটিভ",
                "ষ\u{9cd}টিম",
                "ৰেইলৱে",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("lokomotiv"),
            keywords: &[
                "buxar",
                "dəmir yolu",
                "lokomotiv",
                "mühərrik",
                "nəqliyyat",
                "qatar",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("лакаматыў"),
            keywords: &["лакаматыў", "пара", "рухавік", "цягнік", "чыгунка"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("локомотив"),
            keywords: &[
                "влак",
                "железница",
                "локомотив",
                "парен",
                "превозно средство",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("লোকোমোটিভ"),
            keywords: &[
                "ইঞ\u{9cd}জিন",
                "ট\u{9cd}রেন",
                "ব\u{9be}ষ\u{9cd}প",
                "য\u{9be}নব\u{9be}হন",
                "রেলওয\u{9bc}ে",
                "লোকোমোটিভ",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("stlejerez"),
            keywords: &["hent-houarn", "stlejerez", "tren"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("lokomotiva"),
            keywords: &["lokomotiva", "motor", "para", "pruga", "voz"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("locomotora"),
            keywords: &["locomotora", "motor", "tren", "vapor", "vehicle"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏗᎦᏣᏄᎳ"),
            keywords: &["ᎠᏔᎶᎴᎬᎢ", "ᎠᏥᎳ ᏅᏃᎯ", "ᎪᏗᎢ", "ᏗᎦᏣᏄᎳ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("lokomotiva"),
            keywords: &["lokomotiva", "pára", "vlak", "vozidlo", "železnice"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("locomotif"),
            keywords: &["locomotif", "peiriant", "rheilffordd", "stêm", "trên"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("lokomotiv"),
            keywords: &["damplokomotiv", "lokomotiv", "tog"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Dampflokomotive"),
            keywords: &[
                "Dampf",
                "Dampflok",
                "Dampflokomotive",
                "Fahrzeug",
                "Lokomotive",
                "Zug",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ατμομηχανή"),
            keywords: &[
                "ατμομηχανή",
                "ατμός",
                "καρβουνιάρης",
                "μηχανή",
                "σιδηρόδρομος",
                "τρένο",
                "όχημα",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("locomotive"),
            keywords: &["engine", "locomotive", "railway", "steam", "train"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("locomotora de vapor"),
            keywords: &["locomotora", "locomotora de vapor", "tren", "vehículo"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("tren a vapor"),
            keywords: &[
                "ferrocarril",
                "locomotora",
                "transporte",
                "tren",
                "tren a vapor",
                "viajar",
                "viaje",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("locomotora"),
            keywords: &["locomotora"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &[
                "ferrocarril",
                "locomotora",
                "transporte",
                "tren",
                "tren a vapor",
            ],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("vedur"),
            keywords: &["aur", "raudtee", "rong", "sõiduk", "vedur"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("tren-makina"),
            keywords: &[
                "ibilgailu",
                "lurrun",
                "motor",
                "tren",
                "tren-makina",
                "trenbide",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("لوکوموتیو"),
            keywords: &[
                "بخار",
                "ریل",
                "قطار",
                "لوکوموتیو",
                "موتور",
                "وسیله\u{654} نقلیه",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("veturi"),
            keywords: &["ajoneuvo", "juna", "rautatie", "veturi"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("makina ng tren"),
            keywords: &["engine", "makina", "makina ng tren", "sasakyan", "tren"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("lokomotiv"),
            keywords: &["lokomotiv", "tok"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("locomotive"),
            keywords: &["locomotive", "train"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["chemin de fer", "locomotive", "train", "vapeur"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("inneall traenach"),
            keywords: &[
                "feithicil",
                "galinneall",
                "inneall",
                "inneall traenach",
                "traein",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("carbad-smùide"),
            keywords: &[
                "carbad-smùide",
                "einnsean",
                "rathad-iarainn",
                "rèile",
                "smùid",
                "trèana",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("locomotora de vapor"),
            keywords: &["locomotora", "locomotora de vapor", "tren", "vapor"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("વરાળ એન\u{acd}જિન"),
            keywords: &[
                "એન\u{acd}જિન",
                "ટ\u{acd}ર\u{ac7}ન",
                "વરાળ એન\u{acd}જિન",
                "વાહન",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("mota mai inji"),
            keywords: &["inji", "jirgin ƙasa", "mota mai inji", "reluwe", "tururi"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("קטר"),
            keywords: &["מנוע", "קטר", "קיטור", "רכבת", "תחבורה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("भाप इ\u{902}जन, लोकोमोटिव"),
            keywords: &[
                "ट\u{94d}र\u{947}न",
                "भाप इ\u{902}जन",
                "भाप इ\u{902}जन, लोकोमोटिव",
                "लोकोमोटिव",
                "वाहन",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("lokomotiva"),
            keywords: &["lokomotiva", "para", "vlak", "vozilo"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("mozdony"),
            keywords: &["gőz", "jármű", "mozdony", "vasút"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("շոգեքարշ"),
            keywords: &["գնացք", "գոլորշի", "երկաթուղի", "շոգեքարշ", "փոխադրամիջոց"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("lokomotif"),
            keywords: &["kendaraan", "kereta", "lokomotif", "mesin", "rel", "uap"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("igwe ọgịga"),
            keywords: &[
                "igwe ọgịga",
                "injin",
                "mgbanye",
                "okporoigwe",
                "ụgbọokporoigwe",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("eimreið"),
            keywords: &["eimreið", "gufulest", "lest"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("locomotiva"),
            keywords: &["locomotiva", "locomotiva a vapore", "treno", "veicolo"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("蒸気機関車"),
            keywords: &["SL", "乗り物", "列車", "蒸気機関車"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("lokomotip"),
            keywords: &["jalur ril", "lokomotip", "mesin", "sepur", "uwap"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ლოკომოტივი"),
            keywords: &[
                "ლოკომოტივი",
                "მატარებელი",
                "ორთქლი",
                "რკინიგზა",
                "ტრანსპორტი",
                "ძრავა",
                "ძრავი",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("локомотив"),
            keywords: &["бу", "локомотив", "пойыз", "темір жол", "қозғалтқыш"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("damplokomotiv"),
            keywords: &["damplokomotiv", "tog"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ក\u{17d2}បាលរថភ\u{17d2}លើង"),
            keywords: &["ក\u{17d2}បាលរថភ\u{17d2}លើង", "រថភ\u{17d2}លើង"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಲೋಕೊಮೋಟ\u{cbf}ವ\u{ccd}"),
            keywords: &[
                "ಉಗ\u{cbf}ಬಂಡ\u{cbf} ಎಂಜ\u{cbf}ನ\u{ccd}",
                "ರೈಲು",
                "ಲೋಕೊಮೋಟ\u{cbf}ವ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("기관차"),
            keywords: &["교통수단", "기관차", "기차", "엔진", "트레인"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("लोकोमोटीव"),
            keywords: &[
                "इ\u{902}जीन",
                "ट\u{94d}र\u{947}न",
                "र\u{947}ल\u{94d}व\u{947}",
                "लोकोमोटीव",
                "वाफ",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("локомотив"),
            keywords: &["кыймылдаткыч", "локомотив", "паровоз", "поезд", "темир жол"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Lokomotiv"),
            keywords: &["Damp", "Eisebunn", "Lokomotiv", "Motor", "Zuch"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຫ\u{ebb}ວລ\u{ebb}ດຈ\u{eb1}ກ"),
            keywords: &[
                "ພາຫະນະ",
                "ຫ\u{ebb}ວລ\u{ebb}ດຈ\u{eb1}ກ",
                "ເຄ\u{eb7}\u{ec8}ອງຈ\u{eb1}ກ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("lokomotyvas"),
            keywords: &[
                "garai",
                "geležinkelis",
                "lokomotyvas",
                "traukinys",
                "variklis",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("lokomotīve"),
            keywords: &[
                "dzelzceļš",
                "dzinējs",
                "lokomotīve",
                "transports",
                "vilciens",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pūkaha tereina"),
            keywords: &["mamaoa", "pūkaha", "rerewē", "tereina"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("локомотива"),
            keywords: &["возило", "железница", "локомотива", "мотор", "пареа"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ലോക\u{d4d}കോമോട\u{d4d}ടീവ\u{d4d}"),
            keywords: &[
                "ലോക\u{d4d}കോമോട\u{d4d}ടീവ\u{d4d}",
                "വ\u{d3e}ഹനം",
                "സ\u{d4d}റ\u{d4d}റീം ലോക\u{d4d}കോമോട\u{d4d}ടീവ\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("зүтгүүр"),
            keywords: &["зүтгүүр", "тэрэг", "төмөр зам", "уур"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("आगगाडीच\u{947} इ\u{902}जिन"),
            keywords: &[
                "आगगाडी",
                "आगगाडीच\u{947} इ\u{902}जिन",
                "इ\u{902}जिन",
                "र\u{947}ल\u{94d}व\u{947}",
                "वाफ",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("lokomotif"),
            keywords: &[
                "enjin",
                "kenderaan",
                "kereta api",
                "landasan kereta api",
                "lokomotif",
                "wap",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("lokomottiva"),
            keywords: &["ferrovija", "lokomottiva", "magna", "tal-fwar"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("မ\u{102e}းရထားစက\u{103a}ခေါင\u{103a}း"),
            keywords: &[
                "မ\u{102e}းရထား",
                "မ\u{102e}းရထားစက\u{103a}ခေါင\u{103a}း",
                "ရထား",
                "ရထားလမ\u{103a}း",
                "ရေန\u{103d}ေးင\u{103d}ေ\u{1037}",
                "အင\u{103a}ဂျင\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("lokomotiv"),
            keywords: &["fremkomstmiddel", "lokmotiv", "lokomotiv", "tog"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("लोकोमोटिभ"),
            keywords: &[
                "इञ\u{94d}जिन",
                "र\u{947}ल",
                "र\u{947}लमार\u{94d}ग",
                "लोकोमोटिभ",
                "वाफ",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("locomotief"),
            keywords: &["locomotief", "spoor", "stoom", "trein", "voertuig"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("lokomotiv"),
            keywords: &["framkomstmiddel", "lokomotiv", "tog"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଲୋକୋମୋଟ\u{b3f}ଭ\u{b4d}\u{200c}"),
            keywords: &[
                "ଟ\u{b4d}ରେନ\u{b4d}",
                "ବ\u{b3e}ହ\u{b3e}ନ",
                "ଲୋକୋମୋଟ\u{b3f}ଭ\u{b4d}\u{200c}",
                "ଷ\u{b4d}ଟ\u{b3f}ମ\u{b4d} ଲୋକୋମୋଟ\u{b3f}ଭ\u{b4d}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਰ\u{a47}ਲ ਇ\u{a70}ਜਣ"),
            keywords: &[
                "ਰ\u{a47}ਲ ਇ\u{a70}ਜਣ",
                "ਰ\u{a47}ਲ ਗ\u{a71}ਡੀ",
                "ਵਾਹਨ",
                "ਸਟੀਮ ਲ\u{a4b}ਕ\u{a4b}ਮ\u{a4b}ਟਿਵ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ریل دا انجن"),
            keywords: &["انجن", "بھاپ", "ریل دا انجن", "ریلوے", "ٹرین"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Lokomótív Tren"),
            keywords: &[
                "Họ\u{301}t Ea Wé De Kọmọt Wẹ\u{301}n Wọtá De Bọil",
                "Lokomótiv",
                "Lokomótív Tren",
                "Relwè",
                "Stim",
                "Tren",
                "Ẹ\u{301}njin",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("lokomotywa"),
            keywords: &[
                "ciuchcia",
                "kolej",
                "lokomotywa",
                "pociąg",
                "stara lokomotywa",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("لوکوموتيو"),
            keywords: &["انجن", "اور ګاړی", "ريلوی", "لوکوموتيو", "پخار"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("locomotiva"),
            keywords: &["locomotiva", "trem", "veículo"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &[
                "comboio",
                "linha ferroviária",
                "locomotiva",
                "máquina",
                "vapor",
                "veículo",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("locomotora"),
            keywords: &["ferrocarril", "locomotora", "motor", "puriy", "tren"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("locomotivă"),
            keywords: &[
                "aburi",
                "cale ferată",
                "locomotivă",
                "motor",
                "transport",
                "tren",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-918"),
            keywords: &["E10-918"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("паровоз"),
            keywords: &["вагон", "локомотив", "паровоз", "поезд"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("rokomotive"),
            keywords: &[
                "gari ya moshi",
                "imashini",
                "rayirayi",
                "rokomotive",
                "steam",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ريل جو انجڻ"),
            keywords: &["انجڻ", "دونهون", "ريل", "ريل جو انجڻ", "ريلوي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("එන\u{dca}ජ\u{dd2}ම"),
            keywords: &[
                "එන\u{dca}ජ\u{dd2}ම",
                "ද\u{dd4}ම\u{dca}ර\u{dd2}ය",
                "ද\u{dd4}ම\u{dca}ර\u{dd2}ය ම\u{dcf}ර\u{dca}ගය",
                "ව\u{dcf}ෂ\u{dca}ප",
                "ව\u{dcf}හනය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("rušeň"),
            keywords: &["lokomotíva", "rušeň", "vlak", "železnica"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("lokomotiva"),
            keywords: &["lokomotiva", "para", "stroj", "vlak", "vozilo", "železnica"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("dhaqdhaqaaq"),
            keywords: &["dhaqdhaqaaq", "jidka tareenka", "matoor", "tareen"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("lokomotivë"),
            keywords: &["avull", "hekurudhë", "lokomotivë", "mjet", "tren"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("локомотива"),
            keywords: &["воз", "железница", "локомотива", "машина", "пара"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["локомотива"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("lokomotiva"),
            keywords: &["lokomotiva", "mašina", "para", "voz", "železnica"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["lokomotiva"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("ånglok"),
            keywords: &["fordon", "lok", "lokomotiv", "tåg", "ånglok"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("garimoshi"),
            keywords: &["gari", "garimoshi", "injini", "mvuke", "reli", "treni"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("புகை வண\u{bcd}டி"),
            keywords: &["தொடர\u{bcd} வண\u{bcd}டி", "புகை வண\u{bcd}டி"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ఆవ\u{c3f}ర\u{c3f}త\u{c4b} నడ\u{c3f}చ\u{c47} ర\u{c48}లు"),
            keywords: &[
                "ఆవ\u{c3f}ర\u{c3f}",
                "ఆవ\u{c3f}ర\u{c3f}త\u{c4b} నడ\u{c3f}చ\u{c47} ర\u{c48}లు",
                "ర\u{c48}లు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("локомотив"),
            keywords: &["буғ", "локомотив", "муҳаррик", "роҳи оҳан", "қатора"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ห\u{e31}วรถจ\u{e31}กรไอน\u{e49}ำ"),
            keywords: &[
                "ยานพาหนะ",
                "รถไฟ",
                "ห\u{e31}วรถจ\u{e31}กรไอน\u{e49}ำ",
                "เคร\u{e37}\u{e48}องจ\u{e31}กร",
                "ไอน\u{e49}ำ",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("lokomotiw"),
            keywords: &["bug", "demir ýol", "hereketlendiriji", "lokomotiw", "otly"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("mīsini lēlue"),
            keywords: &["mīsini lēlue"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("buharlı lokomotif"),
            keywords: &["buharlı lokomotif", "lokomotif", "taşıt", "tren"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("پاراۋۇز"),
            keywords: &["رېلىس", "موتور", "پاراۋۇز", "پويىز", "ھور"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("паровий локомотив"),
            keywords: &[
                "двигун",
                "залізниця",
                "паровий",
                "паровий локомотив",
                "потяг",
                "транспорт",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ریل کا انجن"),
            keywords: &["انجن", "بھاپ", "ریل", "ریل کا انجن"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("lokomotiv"),
            keywords: &[
                "bug‘",
                "lokomotiv",
                "motor",
                "poyezd",
                "temiryo‘l",
                "transport",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("đầu máy xe lửa"),
            keywords: &[
                "hơi nước",
                "tàu hỏa",
                "đường sắt",
                "đầu máy xe lửa",
                "động cơ",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("ndaamaar"),
            keywords: &["motër", "ndaamaar", "otoraay", "raay", "wapër"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("intloko kaloliwe"),
            keywords: &[
                "injini",
                "intloko kaloliwe",
                "isiporo",
                "uloliwe",
                "umphunga",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Yiyi"),
            keywords: &["Yiyi", "ojú irin", "òru", "ẹ\u{300}rọ", "ọks ojú irin"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("蒸汽火車"),
            keywords: &["火車", "發動機", "蒸汽", "蒸汽火車", "鐵路"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("蒸汽火车"),
            keywords: &["发动机", "火车", "蒸汽", "蒸汽火车", "铁路"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("蒸汽火车"),
            keywords: &["火车", "蒸汽", "蒸汽火车"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("蒸汽火車"),
            keywords: &["火車", "蒸汽火車"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ikhanda lesitmela"),
            keywords: &[
                "ikhanda lesitmela",
                "injini",
                "isithuthi",
                "isitimela",
                "isitimu",
                "ujantshi",
            ],
        },
    ],
};
#[doc = "🚃"]
pub const RAILWAY_CAR: crate::Emoji = crate::Emoji {
    glyph: "🚃",
    codepoint: "1F683",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "railway car",
    group: "Travel & Places",
    subgroup: "transport-ground",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("treintrok"),
            keywords: &[
                "elektries",
                "motor",
                "trein",
                "treinspoor",
                "treintrok",
                "trem",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ፉርጎ"),
            keywords: &["መኪና", "ባቡር", "ተጎታች", "ኤሌክትሪክ", "የባቡር መንገድ", "ፉርጎ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("عربة قطار"),
            keywords: &["ترام", "عربة قطار", "قطار كهربائي", "كهربائي", "مركبة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ৰেইলৱেৰ গ\u{9be}ড\u{9bc}ী"),
            keywords: &[
                "ইলেক\u{9cd}ট\u{9cd}ৰিক",
                "গ\u{9be}ড\u{9bc}ী",
                "ট\u{9cd}ৰলিব\u{9be}চ",
                "ট\u{9cd}ৰ\u{9be}ম",
                "ট\u{9cd}ৰেইন",
                "ৰেইলৱে",
                "ৰেইলৱেৰ গ\u{9be}ড\u{9bc}ী",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("dəmir yolu qatarı vaqonu"),
            keywords: &[
                "dəmir yolu",
                "dəmir yolu qatarı vaqonu",
                "elektrik",
                "maşın",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("чыгуначны вагон"),
            keywords: &["вагон", "чыгуначны вагон", "чыгунка", "электрычка"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("вагон"),
            keywords: &["вагон", "влак", "електрически", "железница", "трамвай"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("রেলওয\u{9bc}ের গ\u{9be}ড\u{9bc}ি"),
            keywords: &[
                "ট\u{9cd}রলিব\u{9be}স",
                "ট\u{9cd}র\u{9be}ম",
                "ট\u{9cd}রেন",
                "বৈদ\u{9cd}য\u{9c1}তিক",
                "মোটরগ\u{9be}ড\u{9bc}ি",
                "য\u{9be}নব\u{9be}হন",
                "রেলওয\u{9bc}ে",
                "রেলওয\u{9bc}ের গ\u{9be}ড\u{9bc}ি",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("bagon"),
            keywords: &["bagon", "hent-houarn", "tren"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("vagon"),
            keywords: &["pruga", "vagon", "voz", "šina", "željeznica"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("vagó de tren elèctric"),
            keywords: &["tren elèctric", "vagó", "vagó de tren elèctric"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏗᎦᏣᏄᎳ ᏙᎴᎳ"),
            keywords: &["ᎠᎾᎦᎵᏍᎩ", "ᎠᏥᎳ ᏅᏃᎯ", "ᎤᎾᏦᏗᎢ", "ᏗᎦᏣᏄᎳ", "ᏗᎦᏣᏄᎳ ᏙᎴᎳ", "ᏙᏆᎴᎳ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("vagón"),
            keywords: &[
                "elektrický",
                "tramvaj",
                "trolejbus",
                "vagón",
                "vlak",
                "vozidlo",
                "železnice",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("car rheilffordd"),
            keywords: &["car", "rheilffordd", "trydan", "trên"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("togvogn"),
            keywords: &["tog", "togvogn"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Eisenbahnwagen"),
            keywords: &[
                "Eisenbahnwagen",
                "Fahrzeug",
                "Straßenbahn",
                "Straßenbahnwagen",
                "Tram",
                "Wagen",
                "Wagon",
                "Zug",
            ],
        },
        #[cfg(feature = "de_CH")]
        crate::Annotation {
            lang: "de_CH",
            tts: None,
            keywords: &[
                "Eisenbahnwagen",
                "Fahrzeug",
                "Strassenbahn",
                "Strassenbahnwagen",
                "Tram",
                "Wagen",
                "Wagon",
                "Zug",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("βαγόνι τρένου"),
            keywords: &[
                "βαγόνι",
                "βαγόνι τρένου",
                "ηλεκτρικός",
                "σιδηρόδρομος",
                "τρένο",
                "τραμ",
                "τρόλεϊ",
                "όχημα",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("railway car"),
            keywords: &["car", "electric", "railway", "train", "tram", "trolleybus"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: Some("railway carriage"),
            keywords: &[
                "car",
                "electric",
                "railway",
                "railway carriage",
                "train",
                "tram",
                "trolleybus",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("tram"),
            keywords: &["car", "electric", "railway", "train", "tram", "trolley bus"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("railway car"),
            keywords: &[
                "car",
                "electric",
                "railway",
                "railway carriage",
                "train",
                "tram",
                "trolley bus",
                "trolleybus",
            ],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &[
                "car",
                "electric",
                "railway",
                "railway carriage",
                "train",
                "tram",
                "trolleybus",
            ],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("vagón"),
            keywords: &[
                "ferrocarril",
                "tranvía",
                "tren eléctrico",
                "vagón",
                "vehículo",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("tren eléctrico"),
            keywords: &["eléctrico", "ferrocarril", "tranvía", "tren", "vagón"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("rongivagun"),
            keywords: &[
                "rong",
                "rongivagun",
                "rööpad",
                "sõiduk",
                "tramm",
                "troll",
                "vagun",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("bagoia"),
            keywords: &[
                "bagoi",
                "bagoia",
                "elektriko",
                "ibilgailu",
                "tranbia",
                "tren",
                "trenbide",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("واگن ریلی"),
            keywords: &[
                "الکتریکی",
                "تراموا",
                "ریل",
                "قطار",
                "واگن",
                "واگن ریلی",
                "وسیله نقلیه",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("junavaunu"),
            keywords: &["ajoneuvo", "juna", "junavaunu", "raitiovaunu", "rautatie"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("railway car"),
            keywords: &["railway car", "sasakyan", "trambiya", "tren", "trolley"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("jarnbreytarvognur"),
            keywords: &["jarnbreytarvognur", "sporvognur", "tokvognur", "tráðbussur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("wagon"),
            keywords: &["chemin de fer", "train", "voiture", "wagon"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &[
                "chemin de fer",
                "train",
                "tram",
                "trolley",
                "voiture",
                "wagon",
                "électrique",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("carráiste iarnróid"),
            keywords: &[
                "carr ráille",
                "carráiste iarnróid",
                "feithicil",
                "iarnród",
                "leictreach",
                "traein",
                "tram",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("còidse rèile"),
            keywords: &[
                "bus-troilidh",
                "càr",
                "còidse",
                "dealanach",
                "rathad-iarainn",
                "rèile",
                "slighe-iarainn",
                "trama",
                "trèana",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("vagón"),
            keywords: &["tranvía", "tren", "tren eléctrico", "vagón"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ર\u{ac7}લ\u{acd}વ\u{ac7} કાર"),
            keywords: &[
                "ઇલ\u{ac7}ક\u{acd}ટ\u{acd}રિક",
                "ટ\u{acd}રામ",
                "ટ\u{acd}ર\u{ac7}ન",
                "ર\u{ac7}લ\u{acd}વ\u{ac7}",
                "ર\u{ac7}લ\u{acd}વ\u{ac7} કાર",
                "વાહન",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("ƙaramar motar reluwe"),
            keywords: &[
                "bas mai aiki da lantarki",
                "jirgin ƙasa",
                "na lantarki",
                "reluwe",
                "tram",
                "ƙaramar mota",
                "ƙaramar motar reluwe",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("קרון רכבת"),
            keywords: &["חשמלית", "קרון", "רכבת", "תחבורה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ट\u{94d}र\u{947}न, बिजली वाली ट\u{94d}र\u{947}न"),
            keywords: &[
                "ट\u{94d}राम",
                "ट\u{94d}र\u{947}न",
                "ट\u{94d}र\u{947}न, बिजली वाली ट\u{94d}र\u{947}न",
                "बिजली",
                "बिजली वाली ट\u{94d}र\u{947}न",
                "र\u{947}लव\u{947}",
                "र\u{947}लव\u{947} कार",
                "वाहन",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("vagon"),
            keywords: &[
                "pruga",
                "tramvaj",
                "trolejbus",
                "vagon",
                "vlak",
                "željeznica",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("vasúti kocsi"),
            keywords: &[
                "elektromos",
                "kocsi",
                "vasút",
                "vasúti kocsi",
                "villamos",
                "vonat",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("երկաթուղային վագոն"),
            keywords: &[
                "գնացք",
                "երկաթուղային վագոն",
                "երկաթուղի",
                "էլեկտրական",
                "վագոն",
                "տրամվայ",
                "տրոլեյբուս",
                "փոխադրամիջոց",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("gerbong"),
            keywords: &[
                "bus listrik",
                "gerbong",
                "kereta api",
                "listrik",
                "mobil",
                "rel kereta",
                "trem",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ụgbọnta okporoigwe"),
            keywords: &[
                "electrik",
                "ogologoụgbọala",
                "okporoigwe",
                "tramụ",
                "ụgbọala",
                "ụgbọnta okporoigwe",
                "ụgbọokporoigwe",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("járnbrautarlest"),
            keywords: &["járnbrautarlest", "lestarvagn", "rafmagnslest"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("vagone"),
            keywords: &["elettrico", "ferrovia", "tram", "treno", "vagone"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("電車"),
            keywords: &["乗り物", "列車", "電車"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("bis jalur ril"),
            keywords: &[
                "bis jalur ril",
                "bis troli",
                "jalur ril",
                "listrik",
                "montor",
                "sepur",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მატარებლის ვაგონი"),
            keywords: &[
                "ელექტრო",
                "მანქანა",
                "მატარებელი",
                "მატარებლის ვაგონი",
                "რკინიგზა",
                "ტრამვაი",
                "ტრანსპორტი",
                "ტროლეიბუსი",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("темір жол вагоны"),
            keywords: &[
                "автокөлік",
                "пойыз",
                "темір жол",
                "темір жол вагоны",
                "трамвай",
                "троллейбус",
                "электр",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("togvogn"),
            keywords: &["tog", "togvogn"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ទ\u{17bc}រថភ\u{17d2}លើងផ\u{17d2}ទ\u{17bb}កទ\u{17c6}ន\u{17b7}ញ"),
            keywords: &[
                "ទ\u{17bc}រថភ\u{17d2}លើង",
                "ទ\u{17bc}រថភ\u{17d2}លើងផ\u{17d2}ទ\u{17bb}កទ\u{17c6}ន\u{17b7}ញ",
                "ផ\u{17d2}ល\u{17bc}វដែក",
                "រថភ\u{17d2}លើង",
                "រថភ\u{17d2}លើងអគ\u{17d2}គ\u{17b7}សន\u{17b8}",
                "រថយន\u{17d2}តក\u{17d2}រ\u{17bb}ងអគ\u{17d2}គ\u{17b7}សន\u{17b8}",
                "អគ\u{17d2}គ\u{17b7}សន\u{17b8}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ರೈಲು ಬೋಗ\u{cbf}"),
            keywords: &["ರೈಲು", "ರೈಲು ಬೋಗ\u{cbf}", "ವ\u{cbf}ದ\u{ccd}ಯುತ\u{ccd} ರೈಲು"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("전철"),
            keywords: &["교통수단", "엔진", "전철", "철도", "트레인"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("र\u{947}ल\u{94d}व\u{947} कार"),
            keywords: &[
                "कार",
                "ट\u{94d}र\u{947}न",
                "ट\u{94d}रॉम",
                "ट\u{94d}रोलीबस",
                "र\u{947}ल\u{94d}व\u{947}",
                "विज",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("вагон"),
            keywords: &[
                "вагон",
                "машина",
                "поезд",
                "трамвай",
                "троллейбус",
                "электр",
            ],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Zuchwaggon"),
            keywords: &[
                "Eisebunn",
                "Tram",
                "Trolleybus",
                "Waggon",
                "Zuch",
                "Zuchwaggon",
                "elektresch",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຕ\u{eb9}\u{ec9}ລ\u{ebb}ດໄຟ"),
            keywords: &["ຕ\u{eb9}\u{ec9}ລ\u{ebb}ດໄຟ", "ລ\u{ebb}ດ", "ລ\u{ebb}ດໄຟ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("traukinio vagonas"),
            keywords: &[
                "automobilis",
                "elektrinis",
                "geležinkelis",
                "tramvajus",
                "traukinio vagonas",
                "traukinys",
                "troleibusas",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("dzelzceļa vagons"),
            keywords: &[
                "dzelzceļa vagons",
                "dzelzceļš",
                "tramvajs",
                "trolejbuss",
                "vagons",
                "vilciens",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("waka rerewē"),
            keywords: &[
                "pūhiko",
                "rerewē",
                "tarāme",
                "tereina",
                "waka",
                "waka pāhiko",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("вагон"),
            keywords: &["вагон", "воз", "возило", "железница", "трамвај"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("റെയിൽവേ ക\u{d3e}ർ"),
            keywords: &["ക\u{d3e}ർ", "കോച\u{d4d}ച\u{d4d}", "റെയിൽവേ", "വ\u{d3e}ഹനം"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("төмөр замын машин"),
            keywords: &[
                "галт тэрэг",
                "машин",
                "трам",
                "троллейбус",
                "төмөр зам",
                "төмөр замын машин",
                "цахилгаан",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("र\u{947}ल\u{94d}व\u{947} ट\u{94d}र\u{947}नचा डबा"),
            keywords: &[
                "आगगाडी",
                "इल\u{947}क\u{94d}ट\u{94d}रिक",
                "कार",
                "ट\u{94d}राम",
                "ट\u{94d}रॉलीबस",
                "र\u{947}ल\u{94d}व\u{947}",
                "र\u{947}ल\u{94d}व\u{947} ट\u{94d}र\u{947}नचा डबा",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("gerabak kereta api"),
            keywords: &[
                "bas letrik",
                "elektrik",
                "gerabak kereta api",
                "kenderaan",
                "kereta",
                "kereta api",
                "landasan kereta api",
                "trem",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("karozza tal-ferrovija"),
            keywords: &[
                "elettriku",
                "ferrovija",
                "karozza",
                "karozza tal-ferrovija",
                "tramm",
                "trolleybus",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ရထားတ\u{103d}\u{1032}"),
            keywords: &[
                "ထရော\u{103a}လ\u{102e}ဘတ\u{103a}စ\u{103a}",
                "ဓာတ\u{103a}ရထား",
                "ရထား",
                "ရထားတ\u{103d}\u{1032}",
                "ရထားလမ\u{103a}း",
                "လျ\u{103e}ပ\u{103a}စစ\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("togvogn"),
            keywords: &["elektrisk", "fremkomstmiddel", "tog", "togvogn", "trikk"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("र\u{947}लव\u{947} कार"),
            keywords: &["र\u{947}कव\u{947} कार", "र\u{947}लव\u{947} कार"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("treinwagon"),
            keywords: &[
                "elektrisch",
                "spoor",
                "tram",
                "trein",
                "treinwagon",
                "trolleybus",
                "wagon",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("togvogn"),
            keywords: &["elektrisk", "framkomstmiddel", "tog", "togvogn", "trikk"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ରେଲୱେ କ\u{b3e}ର\u{b4d}\u{200c}"),
            keywords: &[
                "ଇଲେକ\u{b4d}ଟ\u{b4d}ର\u{b3f}କ\u{b4d}",
                "ଟ\u{b4d}ର\u{b3e}ମ\u{b4d}",
                "ଟ\u{b4d}ରେନ\u{b4d}",
                "ବ\u{b3e}ହ\u{b3e}ନ",
                "ରେଲୱେ",
                "ରେଲୱେ କ\u{b3e}ର\u{b4d}\u{200c}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਰ\u{a47}ਲਗ\u{a71}ਡੀ ਕਾਰ"),
            keywords: &[
                "ਇਲ\u{a48}ਕਟ\u{a4d}ਰਿਕ",
                "ਇਲ\u{a48}ਕਟ\u{a4d}ਰਿਕ ਰ\u{a47}ਲ ਗ\u{a71}ਡੀ",
                "ਟ\u{a4d}ਰ\u{a48}ਮ",
                "ਰ\u{a47}ਲ ਗ\u{a71}ਡੀ",
                "ਰ\u{a47}ਲਗ\u{a71}ਡੀ ਕਾਰ",
                "ਰ\u{a47}ਲਵ\u{a47}",
                "ਰ\u{a47}ਲਵ\u{a47} ਕਾਰ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ریل دی پٹری دی کار"),
            keywords: &[
                "بجلی نال چلن آلی بس",
                "برقی",
                "ریل دی پٹری دی کار",
                "ریلوے",
                "ٹرام",
                "ٹرین",
                "کار",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Relwé Móto"),
            keywords: &[
                "Ilẹ\u{301}ktrik",
                "Kaa",
                "Relwè",
                "Relwé Móto",
                "Tram",
                "Tren",
                "Trọ\u{301}líbọs",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("wagon kolejowy"),
            keywords: &[
                "elektryczny",
                "kolejowy",
                "pociąg",
                "pojazd",
                "szynowy",
                "tramwaj",
                "wagon kolejowy",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د اورګاډي موټر"),
            keywords: &[
                "اور ګاډی",
                "برېښنايي",
                "د اورګاډي موټر",
                "ريلوی",
                "موټر",
                "ټرالي بس",
                "ټرام",
            ],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("vagão de trem"),
            keywords: &[
                "bonde elétrico",
                "elétrico",
                "ferroviário",
                "trem elétrico",
                "trólebus",
                "vagão de trem",
                "vagão ferroviário",
                "veículo",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("carruagem"),
            keywords: &[
                "carro",
                "carruagem",
                "comboio",
                "eléctrico",
                "elétrico",
                "linha ferroviária",
                "troleicarro",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("tren ferrocarrilpaq"),
            keywords: &[
                "carru",
                "electrico",
                "ferrocarril",
                "tren ferrocarrilpaq",
                "trolebus",
                "ñan",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("vagon feroviar"),
            keywords: &[
                "electric",
                "tramvai",
                "transport",
                "troleibuz",
                "vagon",
                "vagon feroviar",
                "șină",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-919"),
            keywords: &["E10-919"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("вагон"),
            keywords: &["вагон", "поезд", "трамвай", "транспорт", "фуникулер"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("vago"),
            keywords: &[
                "gari ya mohi zikoreshwa n’amashanyarazi",
                "gari ya moshi",
                "gari ya moshi zikoresha n’amashanyarazi",
                "imodoka",
                "rayirayi",
                "vago",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ريلوي ڪار"),
            keywords: &["بجليء\u{64e}", "ريل", "ريلوي", "ٽرالي بس", "ٽرام", "ڪار"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ද\u{dd4}ම\u{dca}ර\u{dd2}ය මෝටර\u{dca} රථය"),
            keywords: &[
                "ට\u{dca}\u{200d}රෑම\u{dca}",
                "ට\u{dca}\u{200d}රොල\u{dd2} බසය",
                "ද\u{dd4}ම\u{dca}ර\u{dd2}ය",
                "ද\u{dd4}ම\u{dca}ර\u{dd2}ය ම\u{dcf}ර\u{dca}ගය",
                "ද\u{dd4}ම\u{dca}ර\u{dd2}ය මෝටර\u{dca} රථය",
                "මෝටර\u{dca} රථය",
                "ව\u{dcf}හනය",
                "ව\u{dd2}ද\u{dd4}ල\u{dd2}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("vozeň"),
            keywords: &["vagón", "vlak", "vozeň", "železnica"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("železniški vagon"),
            keywords: &[
                "avtomobil",
                "električno",
                "tramvaj",
                "trolejbus",
                "vlak",
                "vozilo",
                "železnica",
                "železniški vagon",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("gaariga jidka tareenka"),
            keywords: &[
                "baska ragaad",
                "gaari",
                "gaariga jidka tareenka",
                "jidka tareenka",
                "koronto",
                "taraam",
                "tareen",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("vagon"),
            keywords: &["elektrik", "tramvaj", "tren", "vagon"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("вагон"),
            keywords: &[
                "вагон",
                "воз",
                "возило",
                "електричи",
                "железница",
                "трамвај",
                "тролејбус",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["вагон"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("vagon"),
            keywords: &[
                "električi",
                "tramvaj",
                "trolejbus",
                "vagon",
                "voz",
                "vozilo",
                "železnica",
            ],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["vagon"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("tågvagn"),
            keywords: &["fordon", "järnväg", "tåg", "tågvagn"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("gari la moshi"),
            keywords: &[
                "basi la tramu",
                "gari",
                "gari la moshi",
                "reli",
                "tramu",
                "treni",
                "umeme",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("இரயில\u{bcd} வண\u{bcd}டி"),
            keywords: &[
                "இரயில\u{bcd} வண\u{bcd}டி",
                "மின\u{bcd}ச\u{bbe}ர இரயில\u{bcd} வண\u{bcd}டி",
                "மின\u{bcd}ச\u{bbe}ர ரயில\u{bcd}",
                "ரயில\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ర\u{c48}లు బ\u{c4b}గ\u{c40}"),
            keywords: &["బ\u{c4b}గ\u{c40}", "ర\u{c48}లు"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("вагони роҳи оҳан"),
            keywords: &[
                "вагони роҳи оҳан",
                "мошин",
                "роҳи оҳан",
                "трамвай",
                "троллейбус",
                "электрикӣ",
                "қатора",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ต\u{e39}\u{e49}รถไฟ"),
            keywords: &["ต\u{e39}\u{e49}รถไฟ", "รถราง", "รถไฟฟ\u{e49}า"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("wagon"),
            keywords: &[
                "demir ýol",
                "elektrik",
                "otly",
                "tramwaý",
                "trolleýbus",
                "wagon",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("sāliote lēlue"),
            keywords: &["sāliote lēlue"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("vagon"),
            keywords: &[
                "demir yolu",
                "elektrik",
                "elektrikli tren",
                "taşıt",
                "tramvay",
                "vagon",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ۋاگون"),
            keywords: &[
                "توكلۇق",
                "تىراللىبۇس",
                "تىرامۋاي",
                "تۆمۈريول",
                "ماشىنا",
                "پويىز",
                "ۋاگون",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("вагон"),
            keywords: &["вагон", "електричний", "залізниця", "трамвай", "тролейбус"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ریل گاڑی"),
            keywords: &["بجلی", "ریل گاڑی", "پٹری", "گاڑی"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("temiryo‘l vagoni"),
            keywords: &[
                "elektr",
                "poyezd",
                "temiryo‘l",
                "temiryo‘l vagoni",
                "tramvay",
                "transport",
                "trolleybus",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("toa tàu"),
            keywords: &[
                "toa tàu",
                "tàu hỏa",
                "tàu điện",
                "xe hơi",
                "điện",
                "đường sắt",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("otoraay"),
            keywords: &["kuuraŋ", "oto", "otoraay", "raay", "tram", "trolleybus"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("imoto yesiporo"),
            keywords: &[
                "cisiporo",
                "ibhasi yombane",
                "imoto",
                "imoto yesiporo",
                "uloliwe",
                "umbane",
                "utramu",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ọkọ Oju-irin"),
            keywords: &[
                "bọ\u{301}ọ\u{300}sì gígùn",
                "ojú irin",
                "ìná",
                "Ọkọ Oju-irin",
                "ọkọ\u{300}",
                "ọkọ\u{300} ojú irin",
                "ọ\u{300}nà ọkọ\u{300} ojú irin",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("鐵路車"),
            keywords: &["有軌電車", "火車", "車", "鐵路", "鐵路車", "電", "電車"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("铁路车"),
            keywords: &["有轨电车", "火车", "电", "电车", "车", "铁路", "铁路车"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("轨道车"),
            keywords: &["电车", "轨道车"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("有軌電車"),
            keywords: &["有軌電車", "軌道電車"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("鐵路車輛"),
            keywords: &["鐵路車輛"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("imoto eyisitimela"),
            keywords: &[
                "imoto",
                "imoto eyisitimela",
                "isitimela",
                "ithilamu",
                "ngogesi",
                "ujantshi",
            ],
        },
    ],
};
#[doc = "🚄"]
pub const HIGH_SPEED_TRAIN: crate::Emoji = crate::Emoji {
    glyph: "🚄",
    codepoint: "1F684",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "high-speed train",
    group: "Travel & Places",
    subgroup: "transport-ground",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("sneltrein"),
            keywords: &["snel", "sneltrein", "spoed", "spoor", "trein", "voertuig"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ፈጣን ባቡር"),
            keywords: &["ሺንካንሰን", "ባቡር", "የባቡር መንገድ", "ፈጣን ባቡር", "ፍጥነት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("قطار سريع"),
            keywords: &["شينكانسن", "قطار", "قطار سريع", "مركبة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("তীব\u{9cd}ৰ গতিৰ ট\u{9cd}ৰেইন"),
            keywords: &[
                "গতি",
                "চিংক\u{9be}নচেন",
                "ট\u{9cd}ৰেইন",
                "তীব\u{9cd}ৰ গতিৰ ট\u{9cd}ৰেইন",
                "ৰেইলৱে",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("yüksək sürətli qatar"),
            keywords: &[
                "dəmir yolu",
                "nəqliyyat",
                "qatar",
                "sürət",
                "sərnişin ekspressi",
                "yüksək sürətli qatar",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("высакаскорасны цягнік"),
            keywords: &[
                "высакаскорасны цягнік",
                "сінкансэн",
                "хуткасць",
                "цягнік",
                "чыгунка",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("високоскоростен влак"),
            keywords: &[
                "високоскоростен влак",
                "влак",
                "влак стрела",
                "железница",
                "шинкансен",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("উচ\u{9cd}চ-গতির ট\u{9cd}রেন"),
            keywords: &[
                "উচ\u{9cd}চ-গতির ট\u{9cd}রেন",
                "গতি",
                "ট\u{9cd}রেন",
                "য\u{9be}নব\u{9be}হন",
                "রেলওয\u{9bc}ে",
                "শিনক\u{9be}নসেন",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("TTB"),
            keywords: &[
                "TTB",
                "hent-houarn",
                "shinkansen",
                "tizh",
                "tren",
                "tren tizh bras",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("brzi voz"),
            keywords: &["brzi voz", "brzina", "voz", "vozilo", "željeznica"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("tren d’alta velocitat"),
            keywords: &[
                "alta velocitat",
                "shinkansen",
                "tren",
                "tren d’alta velocitat",
                "via del tren",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎦᏣᏄᎵ-ᎠᏥᎳᏗᎮᎩ ᏗᎦᏣᏄᎵ"),
            keywords: &["ᎠᏥᎳ ᏅᏃᎯ", "ᎦᏣᏄᎵ", "ᎦᏣᏄᎵ-ᎠᏥᎳᏗᎮᎩ ᏗᎦᏣᏄᎵ", "ᏗᎦᏣᏄᎵ", "ᏤᏇᎾ ᏗᎦᏣᏄᎵ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("pendolino"),
            keywords: &[
                "pendolino",
                "rychlost",
                "vlak",
                "vozidlo",
                "šinkansen",
                "železnice",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("trên tra chyflym"),
            keywords: &[
                "cyflymder",
                "rheilffordd",
                "shinkansen",
                "trên",
                "trên tra chyflym",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("lyntog"),
            keywords: &["lyntog", "tog"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Hochgeschwindigkeitszug mit spitzer Nase"),
            keywords: &[
                "Hochgeschwindigkeitszug mit spitzer Nase",
                "Shinkansen",
                "TGV",
                "Zug",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ταχεία"),
            keywords: &[
                "σιδηρόδρομος",
                "σινκανσέν",
                "ταχεία",
                "ταχύτητα",
                "τρένο",
                "όχημα",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("high-speed train"),
            keywords: &[
                "high-speed train",
                "railway",
                "shinkansen",
                "speed",
                "train",
            ],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: None,
            keywords: &[
                "TGV",
                "high-speed train",
                "railway",
                "shinkansen",
                "speed",
                "train",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &[
                "Shinkansen",
                "high-speed train",
                "railway",
                "speed",
                "train",
            ],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("tren de alta velocidad"),
            keywords: &[
                "ferrocarril",
                "rápido",
                "tren",
                "tren de alta velocidad",
                "velocidad",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &[
                "bala",
                "ferrocarril",
                "rápido",
                "tren",
                "tren de alta velocidad",
                "velocidad",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &[
                "bala",
                "ferrocarril",
                "rápido",
                "tren",
                "tren de alta velocidad",
                "velocidad",
            ],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kiirrong"),
            keywords: &["kiirrong", "raudtee", "sõiduk"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("abiadura handiko trena"),
            keywords: &[
                "abiadura",
                "abiadura handiko trena",
                "ibilgailu",
                "shinkansen",
                "tren",
                "trenbide",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("قطار سریع\u{200c}السیر"),
            keywords: &[
                "ریل",
                "سرعت",
                "سریع\u{200c}السیر",
                "شینکانسن",
                "قطار",
                "وسیله\u{654} نقلیه",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("pikajuna"),
            keywords: &[
                "ajoneuvo",
                "juna",
                "luotijuna",
                "pikajuna",
                "rautatie",
                "shinkansen",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("high-speed train"),
            keywords: &[
                "bullet train",
                "high-speed train",
                "sasakyan",
                "shinkansen",
                "tren",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("háferðartok"),
            keywords: &["háferðartok", "tok"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("TGV"),
            keywords: &["TGV", "train"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("train à grande vitesse"),
            keywords: &[
                "TGV",
                "chemin de fer",
                "grande vitesse",
                "shinkansen",
                "train",
                "train à grande vitesse",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("traein ardluais"),
            keywords: &["feithicil", "shinkansen", "traein", "traein ardluais"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("trèana fhìor luath"),
            keywords: &[
                "astar",
                "luaths",
                "rathad-iarainn",
                "rèile",
                "shinkansen",
                "slighe-iarainn",
                "trèana",
                "trèana fhìor luath",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("tren de alta velocidade"),
            keywords: &["AVE", "alta velocidade", "tren", "tren de alta velocidade"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some(
                "હાઇ-સ\u{acd}પીડ ટ\u{acd}ર\u{ac7}ન, શિ\u{a82}કનસ\u{ac7}ન, ટ\u{acd}ર\u{ac7}ન, વાહન",
            ),
            keywords: &[
                "ટ\u{acd}ર\u{ac7}ન",
                "વાહન",
                "શિ\u{a82}કનસ\u{ac7}ન",
                "હાઇ-સ\u{acd}પીડ ટ\u{acd}ર\u{ac7}ન",
                "હાઇ-સ\u{acd}પીડ ટ\u{acd}ર\u{ac7}ન, શિ\u{a82}કનસ\u{ac7}ન, ટ\u{acd}ર\u{ac7}ન, વાહન",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("jirgin ƙasa mai matuƙar sauri"),
            keywords: &[
                "jirgin ƙasa",
                "jirgin ƙasa mai matuƙar sauri",
                "reluwe",
                "sauri",
                "shinkansen",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("רכבת מהירה"),
            keywords: &["מהירה", "מהירות", "רכבת", "תחבורה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("त\u{947}ज\u{93c} गति वाली ट\u{94d}र\u{947}न, शि\u{902}कानस\u{947}न"),
            keywords: &[
                "ट\u{94d}र\u{947}न",
                "त\u{947}ज\u{93c} गति वाली ट\u{94d}र\u{947}न",
                "त\u{947}ज\u{93c} गति वाली ट\u{94d}र\u{947}न, शि\u{902}कानस\u{947}न",
                "र\u{947}ल",
                "वाहन",
                "शि\u{902}कानस\u{947}न",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("brzi vlak"),
            keywords: &["Japan", "brzi vlak", "brzina", "vlak", "željeznica"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("gyorsvasút"),
            keywords: &["gyorsvasút", "gyorsvonat", "jármű", "vasút"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ճեպընթաց գնացք"),
            keywords: &[
                "արագություն",
                "գնացք",
                "երկաթուղի",
                "ճեպընթաց գնացք",
                "սինկանսեն",
                "փոխադրամիջոց",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("kereta ekspres"),
            keywords: &[
                "cepat",
                "kendaraan",
                "kereta",
                "kereta ekspres",
                "rel",
                "shinkansen",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ụgbọokporoigwe oke ọsọ"),
            keywords: &[
                "okporoigwe",
                "ọsịịsọ",
                "ụgbọokporoigwe",
                "ụgbọokporoigwe oke ọsọ",
                "ụgbọokporoigweọsịịsọ",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("hraðlest"),
            keywords: &["hraðlest", "lest"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("treno alta velocità"),
            keywords: &["treno", "treno alta velocità", "veicolo"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("新幹線"),
            keywords: &["乗り物", "新幹線", "電車"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("sepur rikat"),
            keywords: &[
                "jalur ril",
                "kacepetan",
                "sepur",
                "sepur rikat",
                "shinkansen",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მაღალსიჩქარიანი მატარებელი"),
            keywords: &[
                "მატარებელი",
                "მაღალსიჩქარიანი მატარებელი",
                "რკინიგზა",
                "სინკანსენი",
                "სიჩქარე",
                "ტრანსპორტი",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("экспресс пойызы"),
            keywords: &[
                "жолаушы экспресі",
                "жылдамдық",
                "пойыз",
                "темір жол",
                "экспресс пойызы",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("lyntog"),
            keywords: &["lyntog", "tog"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("រថភ\u{17d2}លើងលឿន"),
            keywords: &[
                "ក\u{17d2}បាលរថភ\u{17d2}លើង",
                "រថភ\u{17d2}លើង",
                "រថភ\u{17d2}លើងលឿន",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ವೇಗದ ರೈಲು"),
            keywords: &[
                "ವೇಗದ ರೈಲು",
                "ವೇಗದ ರೈಲ\u{ccd}ವ\u{cc6}",
                "ಶ\u{cbf}ಂಕಾನ\u{ccd}ಸ\u{cc6}ನ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("고속열차"),
            keywords: &["KTX", "고속열차", "케이티엑스"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("उच\u{94d}च व\u{947}गाची ट\u{94d}र\u{947}न"),
            keywords: &[
                "उच\u{94d}च व\u{947}गाची ट\u{94d}र\u{947}न",
                "उच\u{94d}च-व\u{947}गाची ट\u{94d}र\u{947}न",
                "ट\u{94d}र\u{947}न",
                "र\u{947}ल\u{94d}व\u{947}",
                "व\u{947}ग",
                "शि\u{902}कानस\u{947}न",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("жогорку ылдамдыктагы поезд"),
            keywords: &[
                "жогорку ылдамдыктагы поезд",
                "поезд",
                "темир жол",
                "шинкансен",
                "ылдамдык",
            ],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Schnellzuch"),
            keywords: &["Eisebunn", "Schnellzuch", "Shinkansen", "Vitess", "Zuch"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ລ\u{ebb}ດໄຟຄວາມໄວສ\u{eb9}ງ"),
            keywords: &[
                "ຄວາມໄວ",
                "ຊ\u{eb4}ນຄ\u{eb1}ນເຊ\u{eb1}ນ",
                "ພາຫະນະ",
                "ລາງ",
                "ລ\u{ebb}ດໄຟ",
                "ລ\u{ebb}ດໄຟຄວາມໄວສ\u{eb9}ງ",
                "ໄວ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("greitasis traukinys"),
            keywords: &["geležinkelis", "greitasis", "greitis", "traukinys"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("ātrvilciens"),
            keywords: &[
                "dzelzceļš",
                "transports",
                "vilciens",
                "ātrums",
                "ātrvilciens",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tereina tino tere"),
            keywords: &[
                "rerewē",
                "shinkansen",
                "tere",
                "tereina",
                "tereina tino tere",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("брз воз"),
            keywords: &["брз воз", "брзина", "воз", "возило", "железница"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("അതിവേഗ ട\u{d4d}രെയിൻ"),
            keywords: &[
                "അതിവേഗ ട\u{d4d}രെയിൻ",
                "ട\u{d4d}രെയിൻ",
                "വ\u{d3e}ഹനം",
                "ഷിങ\u{d4d}ക\u{d3e}സെൻ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("хурдны галт тэрэг"),
            keywords: &["галт", "тэрэг", "хурдан", "хурдны галт тэрэг"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("व\u{947}गवान ट\u{94d}र\u{947}न"),
            keywords: &[
                "आगगाडी",
                "र\u{947}ल\u{94d}व\u{947}",
                "व\u{947}ग",
                "व\u{947}गवान ट\u{94d}र\u{947}न",
                "शि\u{902}कान\u{94d}स\u{947}न",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("kereta api laju"),
            keywords: &[
                "kelajuan",
                "kenderaan",
                "kereta api",
                "kereta api laju",
                "shinkansen",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("ferrovija b’velocità għolja"),
            keywords: &[
                "ferrovija",
                "ferrovija b’velocità għolja",
                "shinkansen",
                "veloċità",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အမြန\u{103a}ရထား"),
            keywords: &[
                "ရထား",
                "ရထားလမ\u{103a}း",
                "ရ\u{103e}င\u{103a}ကန\u{103a}စင\u{103a}",
                "အမြန\u{103a} ရထား",
                "အမြန\u{103a}န\u{103e}\u{102f}န\u{103a}း",
                "အမြန\u{103a}ရထား",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("høyhastighetstog"),
            keywords: &["fremkomstmiddel", "høyhastighetstog", "lyntog", "tog"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("उच\u{94d}च-गतिको र\u{947}ल"),
            keywords: &[
                "उच\u{94d}च-गतिको र\u{947}ल",
                "गति",
                "र\u{947}ल",
                "र\u{947}लमार\u{94d}ग",
                "शि\u{902}कान\u{94d}स\u{947}न",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("hogesnelheidstrein"),
            keywords: &[
                "hogesnelheidstrein",
                "shinkansen",
                "snelheid",
                "spoor",
                "trein",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("høgfartstog"),
            keywords: &["framkomstmiddel", "høgfartstog", "lyntog", "tog"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଉଚ\u{b4d}ଚ-ଗତ\u{b3f} ବ\u{b3f}ଶ\u{b3f}ଷ\u{b4d}ଟ ଟ\u{b4d}ରେନ\u{b4d}\u{200c}"),
            keywords: &[
                "ଅଧ\u{b3f}କ-ଗତ\u{b3f}ଶୀଳ ଟ\u{b4d}ରେନ\u{b4d}",
                "ଉଚ\u{b4d}ଚ-ଗତ\u{b3f} ବ\u{b3f}ଶ\u{b3f}ଷ\u{b4d}ଟ ଟ\u{b4d}ରେନ\u{b4d}\u{200c}",
                "ଟ\u{b4d}ରେନ\u{b4d}",
                "ବ\u{b3e}ହ\u{b3e}ନ",
                "ସ\u{b3f}ଙ\u{b4d}କ\u{b3e}ନସେନ\u{b4d}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਤ\u{a47}ਜ\u{a3c}-ਰਫ\u{a3c}ਤਾਰ ਰ\u{a47}ਲਗ\u{a71}ਡੀ"),
            keywords: &[
                "ਤ\u{a47}ਜ\u{a3c}-ਰਫਤਾਰ ਰ\u{a47}ਲ ਗ\u{a71}ਡੀ",
                "ਤ\u{a47}ਜ\u{a3c}-ਰਫ\u{a3c}ਤਾਰ ਰ\u{a47}ਲਗ\u{a71}ਡੀ",
                "ਰ\u{a47}ਲ ਗ\u{a71}ਡੀ",
                "ਵਾਹਨ",
                "ਸਿਨਕਾਨਸ\u{a48}ਨ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("تیز-رفتار ٹرین"),
            keywords: &["تیز-رفتار ٹرین", "رفتار", "ریلوے", "شینکیسن", "ٹرین"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Haí-spíd Tren"),
            keywords: &["Haí-spíd Tren", "Relwè", "Spit", "Tren"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("szybki pociąg"),
            keywords: &[
                "kolej",
                "pendolino",
                "pojazd szynowy",
                "shinkansen",
                "szybki pociąg",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("زیات سرعت ريل"),
            keywords: &[
                "اور ګاډی",
                "ريلوی",
                "زيات سرعت ريل",
                "زیات سرعت ريل",
                "سرعت",
                "شنکانسن",
            ],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("trem de alta velocidade"),
            keywords: &[
                "sistema de trens bala japonês",
                "trem",
                "trem de alta velocidade",
                "veículo",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("comboio de alta velocidade"),
            keywords: &[
                "comboio",
                "comboio de alta velocidade",
                "linha ferroviária",
                "shinkansen",
                "velocidade",
                "veículo",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("utqhay tren"),
            keywords: &["ferrocarril", "shinkansen", "tren", "utqhay"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("tren de mare viteză"),
            keywords: &["cale ferată", "tren", "tren de mare viteză", "viteză"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-920"),
            keywords: &["E10-920"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("скоростной поезд"),
            keywords: &[
                "дорога",
                "железная",
                "поезд",
                "скоростной поезд",
                "скорость",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("gariyamoshi y’umuvuduko munini"),
            keywords: &[
                "gari ya moshi",
                "gariyamoshi y’umuvuduko munini",
                "rayirayi",
                "shinkansen",
                "umuvuduko",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("تيز رفتار واري ٽرين"),
            keywords: &["تيز رفتار واري ٽرين", "رفتار", "ريل", "ريلوي", "شنڪانسن"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("අධ\u{dd2}වේග\u{dd3} ද\u{dd4}ම\u{dca}ර\u{dd2}ය"),
            keywords: &[
                "අධ\u{dd2}වේග\u{dd3} ද\u{dd4}ම\u{dca}ර\u{dd2}ය",
                "ද\u{dd4}ම\u{dca}ර\u{dd2}ය",
                "ද\u{dd4}ම\u{dca}ර\u{dd2}ය ම\u{dcf}ර\u{dca}ගය",
                "ව\u{dcf}හනය",
                "වේගය",
                "ෂ\u{dd2}න\u{dca}කන\u{dca}සන\u{dca}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("rýchlovlak"),
            keywords: &[
                "dopravný prostriedok",
                "rýchlostný",
                "rýchlovlak",
                "vlak",
                "šinkansen",
                "železnica",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("hitri vlak"),
            keywords: &[
                "hitri vlak",
                "hitrost",
                "shinkansen",
                "vlak",
                "vozilo",
                "železnica",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("tareen aad u dheereeya"),
            keywords: &[
                "jidka tareenka",
                "tareen",
                "tareen aad u dheereeya",
                "tareen xawaare sare",
                "xawaare",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("tren me shpejtësi të madhe"),
            keywords: &[
                "hekurudhë",
                "shinkansen",
                "shpejtësi",
                "tren",
                "tren me shpejtësi të madhe",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("брзи воз"),
            keywords: &["брзи воз", "брзина", "воз", "железница", "шинкансен"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["брзи воз"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("brzi voz"),
            keywords: &["brzi voz", "brzina", "voz", "šinkansen", "železnica"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["brzi voz"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("snabbtåg"),
            keywords: &["fordon", "snabbtåg", "tåg"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("treni yenye kasi"),
            keywords: &[
                "gari",
                "kasi",
                "reli",
                "shinkansen",
                "treni",
                "treni yenye kasi",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("விரைவு இரயில\u{bcd} வண\u{bcd}டி"),
            keywords: &[
                "விரைவு இரயில\u{bcd}",
                "விரைவு இரயில\u{bcd} வண\u{bcd}டி",
                "விரைவு ரயில\u{bcd}",
                "விரைவு ரயில\u{bcd} வண\u{bcd}டி",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("అధ\u{c3f}క వ\u{c47}గం కల\u{c3f}గ\u{c3f}న ర\u{c48}లు"),
            keywords: &[
                "అధ\u{c3f}క వ\u{c47}గం కల\u{c3f}గ\u{c3f}న ర\u{c48}లు",
                "ర\u{c48}లు",
                "వ\u{c47}గం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("қатораи баландсуръат"),
            keywords: &[
                "роҳи оҳан",
                "синкансен",
                "суръат",
                "қатора",
                "қатораи баландсуръат",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ช\u{e34}นค\u{e31}นเซ\u{e47}น"),
            keywords: &[
                "ช\u{e34}นค\u{e31}นเซ\u{e47}น",
                "รถไฟความเร\u{e47}วส\u{e39}ง",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ýokary tizlikli otly"),
            keywords: &[
                "demir ýol",
                "otly",
                "tizlik",
                "ýokary tizlikli otly",
                "ýolagçy otlusy",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("lēlue oma"),
            keywords: &["lēlue oma"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("yüksek hızlı tren"),
            keywords: &["shinkansen", "taşıt", "tren", "yüksek hızlı tren"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("تېز پويىز"),
            keywords: &["تۆمۈريول", "تېز پويىز", "تېزلىك", "شىنكانسېن", "پويىز"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("швидкісний потяг"),
            keywords: &["залізниця", "потяг", "транспорт", "швидкісний", "інтерсіті"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("تیز رفتار ٹرین"),
            keywords: &["تیز رفتار ٹرین", "رفتار", "ریل", "پٹری"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("tezyurar poyezd"),
            keywords: &["poyezd", "shinkansen", "temiryo‘l", "tezyurar", "transport"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("tàu cao tốc"),
            keywords: &[
                "tàu cao tốc",
                "tàu cao tốc Nhật Bản",
                "tàu hỏa",
                "tốc độ",
                "đường sắt",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("otoraay bu gaaw lool"),
            keywords: &[
                "gaawaay",
                "otoraay",
                "otoraay bu gaaw lool",
                "raay",
                "shinkansen",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("uloliwe obalekayo"),
            keywords: &[
                "i-shinkansen",
                "isantya",
                "isiporo",
                "uloliwe",
                "uloliwe obalekayo",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ọkọ oju-irin Alare"),
            keywords: &[
                "aré",
                "ojú irin",
                "Ọkọ oju-irin Alare",
                "ọkọ\u{300} ojú irin",
                "ọkọ\u{300} ojú irin abẹ\u{301} ilẹ\u{300}",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("高速火車"),
            keywords: &["新幹線", "火車", "速度", "鐵路", "高速火車"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("高速火车"),
            keywords: &["新干线", "火车", "速度", "铁路", "高速火车"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("高速列车"),
            keywords: &["动车", "新干线", "火车", "高速列车", "高铁"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("高鐵"),
            keywords: &["火車", "高鐵"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("高速列車"),
            keywords: &["火車", "高速列車"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("isitimela esinesivinini esikhulu"),
            keywords: &[
                "imoto",
                "isitimela",
                "isitimela esinesivinini esikhulu",
                "isivinini",
                "ujantshi",
            ],
        },
    ],
};
#[doc = "🚅"]
pub const BULLET_TRAIN: crate::Emoji = crate::Emoji {
    glyph: "🚅",
    codepoint: "1F685",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "bullet train",
    group: "Travel & Places",
    subgroup: "transport-ground",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("supersneltrein"),
            keywords: &[
                "snel",
                "spoed",
                "spoor",
                "supersneltrein",
                "trein",
                "voertuig",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("አፍንጫው ጥይት መሳይ ፈጣን ባቡር"),
            keywords: &[
                "ሺንካንሰን",
                "ባቡር",
                "አፍንጫው ጥይት መሳይ ፈጣን ባቡር",
                "የባቡር መንገድ",
                "ፍጥነት",
            ],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("قطار سريع بوجه محدب"),
            keywords: &[
                "شينكانسن بوجه محدب",
                "قطار",
                "قطار سريع بوجه محدب",
                "مركبة",
                "وجه محدب",
            ],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ব\u{9c1}লেট ট\u{9cd}ৰেইন"),
            keywords: &[
                "গতি",
                "চিংক\u{9be}নচেন",
                "ট\u{9cd}ৰেইন",
                "ব\u{9c1}লেট",
                "ৰেইলৱে",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("gülləyə bənzər ucluqlu yüksək sürət qatarı"),
            keywords: &[
                "dəmir yolu",
                "güllə",
                "gülləyə bənzər ucluqlu yüksək sürət qatarı",
                "nəqliyyat",
                "qatar",
                "sürət",
                "sərnişin ekspressi",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("цягнік-пуля"),
            keywords: &[
                "пуля",
                "сінкансэн",
                "хуткасць",
                "цягнік",
                "цягнік-пуля",
                "чыгунка",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("високоскоростен влак стрела"),
            keywords: &[
                "високоскоростен влак стрела",
                "влак",
                "влак стрела",
                "железница",
                "шинкансен",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ব\u{9c1}লেট ন\u{9be}ম য\u{9c1}ক\u{9cd}ত উচ\u{9cd}চ-গতির ট\u{9cd}রেন"),
            keywords: &[
                "গতি",
                "ট\u{9cd}রেন",
                "ব\u{9c1}লেট",
                "ব\u{9c1}লেট ন\u{9be}ম য\u{9c1}ক\u{9cd}ত উচ\u{9cd}চ-গতির ট\u{9cd}রেন",
                "য\u{9be}নব\u{9be}হন",
                "রেলওয\u{9bc}ে",
                "শিনক\u{9be}নসেন",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("tren tizh bras"),
            keywords: &[
                "TTB",
                "hent-houarn",
                "shinkansen",
                "tizh",
                "tren",
                "tren tizh bras",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("brzi voz metak"),
            keywords: &[
                "brzi voz metak",
                "brzi voz-metak",
                "pruga",
                "voz",
                "vozilo",
                "željeznica",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("tren bala"),
            keywords: &[
                "alta velocitat",
                "bala",
                "shinkansen",
                "tren",
                "via del tren",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎦᏂ ᏗᎦᏣᏄᎵ"),
            keywords: &["ᎠᏥᎳ ᏅᏃᎯ", "ᎦᏂ", "ᎦᏣᏄᎵ", "ᏗᎦᏣᏄᎵ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("japonský rychlovlak"),
            keywords: &[
                "japonský rychlovlak",
                "pendolino",
                "rychlost",
                "vlak",
                "vozidlo",
                "šinkansen",
                "špička",
                "železnice",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("trên tra chyflym gyda thrwyn fel bwled"),
            keywords: &[
                "bwled",
                "cyflymder",
                "rheilffordd",
                "trên",
                "trên tra chyflym gyda thrwyn fel bwled",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("højhastighedstog"),
            keywords: &["højhastighedstog", "tog"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Hochgeschwindigkeitszug"),
            keywords: &["Hochgeschwindigkeitszug", "Japan", "Shinkansen", "Zug"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("υπερταχεία"),
            keywords: &[
                "αεροδυναμικός",
                "σιδηρόδρομος",
                "σινκανσέν",
                "ταχύτητα",
                "τρένο",
                "υπερταχεία",
                "όχημα",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("bullet train"),
            keywords: &["bullet", "railway", "shinkansen", "speed", "train"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["Shinkansen", "bullet", "railway", "speed", "train"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("tren bala"),
            keywords: &["bala", "shinkansen", "tren", "vehículo", "velocidad"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &[
                "bala",
                "ferrocarril",
                "rápido",
                "transporte",
                "tren",
                "velocidad",
                "viajar",
                "viaje",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["bala", "ferrocarril", "rápido", "tren", "velocidad"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["bala", "ferrocarril", "rápido", "tren", "velocidad"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("terava ninaga kiirrong"),
            keywords: &["kiirrong", "raudtee", "sõiduk", "terava ninaga kiirrong"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("bala-trena"),
            keywords: &[
                "abiadura",
                "abiadura handiko trena mutur biribilduarekin",
                "bala-trena",
                "biribildu",
                "ibilgailu",
                "shinkansen",
                "tren",
                "trenbide",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("قطار تندرو"),
            keywords: &[
                "ریل",
                "سرعت",
                "سریع\u{200c}السیر",
                "شینکانسن",
                "قطار",
                "قطار تندرو",
                "گلوله",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("luotipikajuna"),
            keywords: &[
                "ajoneuvo",
                "juna",
                "luotijuna",
                "luotipikajuna",
                "rautatie",
                "shinkansen",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("bullet train"),
            keywords: &[
                "bullet nose",
                "bullet train",
                "high-speed train",
                "shinkansen",
                "tren",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("snartok"),
            keywords: &["snartok", "tok"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("train à grande vitesse"),
            keywords: &["train", "train à grande vitesse"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("train superexpress"),
            keywords: &[
                "chemin de fer",
                "shinkansen",
                "superexpress",
                "train",
                "vitesse",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("traein philéir"),
            keywords: &[
                "feithicil",
                "shinkansen",
                "shinkansen piléir",
                "traein",
                "traein ardluais",
                "traein philéir",
                "traein philéir ardluais",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("trèana fhìor luath le sròn chruinn"),
            keywords: &[
                "astar",
                "luaths",
                "rathad-iarainn",
                "rèile",
                "shinkansen",
                "slighe-iarainn",
                "sròn chruinn",
                "trèana",
                "trèana fhìor luath le sròn chruinn",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("tren bala"),
            keywords: &["alta velocidade", "tren", "tren bala"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("આગળથી બ\u{ac1}લ\u{ac7}ટના આકારની ઉચ\u{acd}ચ-ગતિની ટ\u{acd}ર\u{ac7}ન"),
            keywords: &[
                "આગળથી બ\u{ac1}લ\u{ac7}ટના આકારની ઉચ\u{acd}ચ-ગતિની ટ\u{acd}ર\u{ac7}ન",
                "ટ\u{acd}ર\u{ac7}ન",
                "બ\u{ac1}લ\u{ac7}ટ નોઝ",
                "બ\u{ac1}લ\u{ac7}ટ નોઝ સાથ\u{ac7}ન\u{ac1}\u{a82} શિ\u{a82}કનસ\u{ac7}ન",
                "વાહન",
                "શિ\u{a82}કનસ\u{ac7}ન",
                "હાઇ-સ\u{acd}પીડ ટ\u{acd}ર\u{ac7}ન",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("jirgin ƙasa mai matuƙar sauri mai hancin harsashi"),
            keywords: &[
                "harsashi",
                "jirgin ƙasa",
                "jirgin ƙasa mai matuƙar sauri mai hancin harsashi",
                "reluwe",
                "sauri",
                "shinkansen",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("רכבת מהירה עם חרטום בצורת קליע"),
            keywords: &[
                "מהירה",
                "מהירות",
                "רכבת",
                "רכבת מהירה עם חרטום בצורת קליע",
                "תחבורה",
            ],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some(
                "ब\u{941}ल\u{947}ट नोज\u{93c} क\u{947} साथ शि\u{902}कानस\u{947}न, ट\u{94d}र\u{947}न",
            ),
            keywords: &[
                "ट\u{94d}र\u{947}न",
                "त\u{947}ज\u{93c} गति वाली ट\u{94d}र\u{947}न",
                "ब\u{941}ल\u{947}ट नोज\u{93c}",
                "ब\u{941}ल\u{947}ट नोज\u{93c} क\u{947} साथ शि\u{902}कानस\u{947}न",
                "ब\u{941}ल\u{947}ट नोज\u{93c} क\u{947} साथ शि\u{902}कानस\u{947}न, ट\u{94d}र\u{947}न",
                "र\u{947}ल",
                "वाहन",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("brzi vlak s lokomotivom u obliku metka"),
            keywords: &[
                "brzi vlak s lokomotivom u obliku metka",
                "brzina",
                "japan",
                "metak",
                "vlak",
                "željeznica",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("golyóorrú gyorsvasút"),
            keywords: &[
                "golyóorrú",
                "golyóorrú gyorsvasút",
                "gyorsvonat",
                "jármű",
                "nagysebességű",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ճեպընթաց գնացք կլոր քթով"),
            keywords: &[
                "արագություն",
                "գնացք",
                "երկաթուղի",
                "կլոր քիթ",
                "ճեպընթաց գնացք կլոր քթով",
                "սինկանսեն",
                "փոխադրամիջոց",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("kereta ekspres peluru"),
            keywords: &[
                "cepat",
                "kendaraan",
                "kereta",
                "kereta ekspres peluru",
                "peluru",
                "rel",
                "shinkansen",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ụgbọokporoigwe oke ọsọ nwere imi mgbọ"),
            keywords: &[
                "mgbọ",
                "okporoigwe",
                "ọsịịsọ",
                "ụgbọokporoigwe",
                "ụgbọokporoigwe oke ọsọ nwere imi mgbọ",
                "ụgbọokporoigweọsịịsọ",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("háhraðalest"),
            keywords: &["hraðlest", "háhraðalest", "lest"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("treno alta velocità punta arrotondata"),
            keywords: &[
                "alta velocità",
                "punta arrotondata",
                "treno",
                "treno alta velocità punta arrotondata",
                "veicolo",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("0系新幹線"),
            keywords: &["0系", "0系新幹線", "丸い新幹線", "乗り物", "新幹線", "電車"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("sepur pelor"),
            keywords: &["jalur ril", "kacepetan", "pelor", "sepur", "shinkansen"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მაღალსიჩქარიანი მატარებელი ტყვიისებრი ბოლოთი"),
            keywords: &[
                "მატარებელი",
                "მაღალსიჩქარიანი მატარებელი ტყვიისებრი ბოლოთი",
                "რკინიგზა",
                "სინკანსენი",
                "სიჩქარე",
                "ტრანსპორტი",
                "ტყვია",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("тұмсығы оқ тәрізді экспресс пойызы"),
            keywords: &[
                "жолаушы экспресі",
                "жылдамдық",
                "оқ",
                "пойыз",
                "темір жол",
                "тұмсығы оқ тәрізді экспресс пойызы",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("lyntog med projektilnæse"),
            keywords: &["lyntog med projektilnæse", "tog"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("រថភ\u{17d2}លើងល\u{17d2}បឿនលឿន"),
            keywords: &[
                "ក\u{17d2}បាលស\u{17d2}រ\u{17bd}ច",
                "ផ\u{17d2}ល\u{17bc}វរថភ\u{17d2}លើង",
                "រថភ\u{17d2}លើង",
                "រថភ\u{17d2}លើងល\u{17d2}បឿនលឿន",
                "ល\u{17d2}បឿន",
                "ស\u{17ca}\u{17b8}នកាន\u{17cb}សេន",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಬುಲ\u{cc6}ಟ\u{ccd} ರೈಲು"),
            keywords: &[
                "ಬುಲ\u{cc6}ಟ\u{ccd}",
                "ಬುಲ\u{cc6}ಟ\u{ccd} ಮ\u{cc2}ಗ\u{cbf}ನ ವೇಗದ ರೈಲು",
                "ರೈಲು",
                "ರೈಲ\u{ccd}ವ\u{cc6}",
                "ವೇಗ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("고속철"),
            keywords: &["KTX", "고속철", "케이티엑스"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("ब\u{941}ल\u{947}ट ट\u{94d}र\u{947}न"),
            keywords: &[
                "ट\u{94d}र\u{947}न",
                "ब\u{941}ल\u{947}ट",
                "र\u{947}ल\u{94d}व\u{947}",
                "व\u{947}ग",
                "शि\u{902}कानस\u{947}न",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("жогорку ылдамдыктагы экспресс"),
            keywords: &[
                "жогорку ылдамдыктагы экспресс",
                "поезд",
                "темир жол",
                "шинкансен",
                "ылдамдык",
            ],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Schnellzuch mat Fligernues"),
            keywords: &[
                "Eisebunn",
                "Fliger",
                "Schnellzuch mat Fligernues",
                "Shinkansen",
                "Vitess",
                "Zuch",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ລ\u{ebb}ດໄຟຄວາມໄວສ\u{eb9}ງຫ\u{ebb}ວລ\u{eb9}ກປ\u{eb7}ນ"),
            keywords: &[
                "ຄວາມໄວສ\u{eb9}ງ",
                "ທາງລ\u{ebb}ດໄຟ",
                "ພາຫະນະ",
                "ລ\u{eb9}ກປ\u{eb7}ນ",
                "ລ\u{ebb}ດໄຟຄວາມໄວສ\u{eb9}ງຫ\u{ebb}ວລ\u{eb9}ກປ\u{eb7}ນ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("greitasis traukinys su smailu priekiu"),
            keywords: &[
                "geležinkelis",
                "greitasis traukinys su smailu priekiu",
                "greitis",
                "kulka",
                "traukinys",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("ātrvilciens ar noapaļotu priekšgalu"),
            keywords: &[
                "dzelzceļš",
                "transports",
                "vilciens",
                "ātrums",
                "ātrvilciens ar noapaļotu priekšgalu",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tereina tino tere ihu matā"),
            keywords: &[
                "matā",
                "rerewē",
                "shinkansen",
                "tere",
                "tereina",
                "tereina tino tere ihu matā",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("воз-куршум"),
            keywords: &["брзина", "воз-куршум", "возило", "железница", "куршум"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some(
                "ബ\u{d41}ള\u{d4d}ളറ\u{d4d}റ\u{d4d} മ\u{d42}ക\u{d4d}ക\u{d41}ള\u{d4d}ള അതിവേഗ ട\u{d4d}രെയിൻ",
            ),
            keywords: &[
                "ട\u{d4d}രെയിൻ",
                "ബ\u{d41}ള\u{d4d}ളറ\u{d4d}റ\u{d4d} മ\u{d42}ക\u{d4d}ക\u{d41}ള\u{d4d}ള അതിവേഗ ട\u{d4d}രെയിൻ",
                "വ\u{d3e}ഹനം",
                "ഷിങ\u{d4d}ക\u{d3e}സെൻ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("хурдны сумт галт тэрэг"),
            keywords: &[
                "галт тэрэг",
                "сум",
                "төмөр зам",
                "хурд",
                "хурдны сумт галт тэрэг",
                "шинкансен",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("ब\u{941}ल\u{947}टच\u{94d}या आकाराची व\u{947}गवान ट\u{94d}र\u{947}न"),
            keywords: &[
                "आगगाडी",
                "ब\u{941}ल\u{947}ट",
                "ब\u{941}ल\u{947}ट ट\u{94d}र\u{947}न",
                "ब\u{941}ल\u{947}टच\u{94d}या आकाराची व\u{947}गवान ट\u{94d}र\u{947}न",
                "र\u{947}ल\u{94d}व\u{947}",
                "व\u{947}ग",
                "शि\u{902}कान\u{94d}स\u{947}न",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("kereta api laju dengan muncung peluru"),
            keywords: &[
                "kelajuan",
                "kenderaan",
                "kereta api",
                "kereta api laju dengan muncung peluru",
                "peluru",
                "shinkansen",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("ferrovija b’veloċità għolja bil-bullet nose"),
            keywords: &[
                "bullet",
                "ferrovija",
                "ferrovija b’veloċità għolja bil-bullet nose",
                "shinkansen",
                "veloċità",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ကျည\u{103a}ဆ\u{1036}ရထား"),
            keywords: &[
                "ကျည\u{103a}ဆ\u{1036}",
                "ကျည\u{103a}ဆ\u{1036}ရထား",
                "ရထား",
                "ရထားလမ\u{103a}း",
                "ရ\u{103e}င\u{103a}ကန\u{103a}စင\u{103a}",
                "အမြန\u{103a}န\u{103e}\u{102f}န\u{103a}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("høyhastighetstog med kulenese"),
            keywords: &[
                "fremkomstmiddel",
                "høyhastighetstog med kulenese",
                "lyntog",
                "shinkansen",
                "tog",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("च\u{941}च\u{94d}चो अग\u{94d}रभाग भएको उच\u{94d}च-गतिको र\u{947}ल"),
            keywords: &[
                "गति",
                "गोली",
                "च\u{941}च\u{94d}चो अग\u{94d}रभाग भएको उच\u{94d}च-गतिको र\u{947}ल",
                "र\u{947}ल",
                "र\u{947}लमार\u{94d}ग",
                "शि\u{902}कान\u{94d}स\u{947}न",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("hogesnelheidstrein met kogelneus"),
            keywords: &[
                "Shinkansen",
                "hogesnelheidstrein met kogelneus",
                "kogeltrein",
                "snelheid",
                "spoor",
                "trein",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("høgfartstog med kulenase"),
            keywords: &[
                "framkomstmiddel",
                "høgfartstog med kulenase",
                "lyntog",
                "shinkansen",
                "tog",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ବ\u{b41}ଲେଟ\u{b4d}\u{200c} ଟ\u{b4d}ରେନ\u{b4d}\u{200c}"),
            keywords: &[
                "ଅଧ\u{b3f}କ-ଗତ\u{b3f}ଶୀଳ ଟ\u{b4d}ରେନ\u{b4d}",
                "ଟ\u{b4d}ରେନ\u{b4d}",
                "ବ\u{b3e}ହ\u{b3e}ନ",
                "ବ\u{b41}ଲେଟ\u{b4d} ନୋଜ\u{b4d}",
                "ବ\u{b41}ଲେଟ\u{b4d}\u{200c} ଟ\u{b4d}ରେନ\u{b4d}\u{200c}",
                "ସ\u{b3f}ଙ\u{b4d}କ\u{b3e}ନସେନ\u{b4d}",
                "ସ\u{b3f}ଙ\u{b4d}କ\u{b3e}ନସେନ\u{b4d} ସହ\u{b3f}ତ ବ\u{b41}ଲେଟ\u{b4d} ନୋଜ\u{b4d}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some(
                "ਗ\u{a4b}ਲੀ ਵਰਗ\u{a47} ਨ\u{a71}ਕ ਵਾਲੀ ਤ\u{a47}ਜ\u{a3c}-ਰਫ\u{a3c}ਤਾਰ ਰ\u{a47}ਲਗ\u{a71}ਡੀ",
            ),
            keywords: &[
                "ਗ\u{a4b}ਲੀ ਵਰਗ\u{a47} ਨ\u{a71}ਕ ਵਾਲੀ ਤ\u{a47}ਜ\u{a3c}-ਰਫ\u{a3c}ਤਾਰ ਰ\u{a47}ਲਗ\u{a71}ਡੀ",
                "ਤ\u{a47}\u{a47}ਜ\u{a3c} ਰਫਤਾਰ ਰ\u{a47}ਲ ਗ\u{a71}ਡੀ",
                "ਬ\u{a41}ਲ\u{a47}ਟ ਨ\u{a4b}ਜ",
                "ਬ\u{a41}ਲ\u{a47}ਟ ਨ\u{a4b}ਜ ਨਾਲ ਸਿਨਕਾਨਸ\u{a48}ਨ",
                "ਰ\u{a47}ਲ ਗ\u{a71}ਡੀ",
                "ਵਾਹਨ",
                "ਸਿਨਕਾਨਸ\u{a48}ਨ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("گولی دے نک وانگوں تیز-رفتار ٹرین"),
            keywords: &[
                "بندوق دی گولی",
                "رفتار",
                "ریلوے",
                "شینکیسن",
                "ٹرین",
                "گولی دے نک وانگوں تیز-رفتار ٹرین",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Búlẹ\u{301}t Tren"),
            keywords: &[
                "Búlẹt",
                "Búlẹ\u{301}t Tren",
                "Japán Relwé Sístẹm Wé Im Na Shínkansẹn",
                "Relwè",
                "Spid",
                "Tren",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("szybki pociąg z zaokrąglonym przodem"),
            keywords: &[
                "kolej",
                "pendolino",
                "pojazd szynowy",
                "szybki pociąg",
                "szybki pociąg z zaokrąglonym przodem",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("بلت ريل"),
            keywords: &["اور ګاډی", "بلت", "بلت ريل", "ريلوی", "سرعت", "شنکانسن"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("trem de alta velocidade japonês"),
            keywords: &[
                "parte dianteira em formato de bala",
                "sistema de trens bala japonês",
                "sistema de trens bala japonês com parte dianteira em formato de bala",
                "trem",
                "trem de alta velocidade japonês",
                "veículo",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("comboio bala"),
            keywords: &[
                "bala",
                "comboio",
                "comboio-bala",
                "linha ferroviária",
                "shinkansen",
                "velocidade",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: None,
            keywords: &["ferrocarril", "shinkansen", "tren", "utqhay"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("tren de mare viteză cu vârf aerodinamic"),
            keywords: &[
                "aerodinamic",
                "cale ferată",
                "tren",
                "tren de mare viteză cu vârf aerodinamic",
                "viteză",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-921"),
            keywords: &["E10-921"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("поезд-пуля"),
            keywords: &["Синкансэн", "поезд", "поезд-пуля", "пуля", "скорость"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("gariyamoshi y’umuvuduko munini n’imbere hasongoye"),
            keywords: &[
                "gari ya moshi",
                "gariyamoshi y’umuvuduko munini n’imbere hasongoye",
                "isasu",
                "rayirayi",
                "shinkansen",
                "umuvuduko",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("گولي ريل گاڏي"),
            keywords: &["رفتار", "ريل", "ريلوي", "شنڪانسن", "گولي", "گولي ريل گاڏي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some(
                "බ\u{dd4}ලට න\u{dcf}සය සහ\u{dd2}ත අධ\u{dd2}වේග\u{dd3} ද\u{dd4}ම\u{dca}ර\u{dd2}ය",
            ),
            keywords: &[
                "ද\u{dd4}ම\u{dca}ර\u{dd2}ය",
                "ද\u{dd4}ම\u{dca}ර\u{dd2}ය ම\u{dcf}ර\u{dca}ගය",
                "බ\u{dd4}ලට න\u{dcf}සය සහ\u{dd2}ත අධ\u{dd2}වේග\u{dd3} ද\u{dd4}ම\u{dca}ර\u{dd2}ය",
                "බ\u{dd4}ලට\u{dca}",
                "ව\u{dcf}හනය",
                "වේගය",
                "ෂ\u{dd2}න\u{dca}කන\u{dca}සන\u{dca}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("japonský rýchlovlak"),
            keywords: &[
                "dopravný prostriedok",
                "japonský",
                "japonský rýchlovlak",
                "rýchlostný",
                "vlak",
                "šinkansen",
                "železnica",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("hitri vlak s koničastim nosom"),
            keywords: &[
                "hitri vlak s koničastim nosom",
                "hitrost",
                "koničast nos",
                "shinkansen",
                "vlak",
                "vozilo",
                "železnica",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("tareen xawaare sare"),
            keywords: &[
                "jidka tareenka",
                "rasaas",
                "tareen",
                "tareen xawaare sare",
                "xawaare",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("tren-plumb"),
            keywords: &[
                "hekurudhë",
                "plumb",
                "shinkansen",
                "shpejtësi",
                "tren me shpejtësi të madhe me formë plumbi",
                "tren-plumb",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("брзи воз са заобљеним врхом"),
            keywords: &[
                "брзи воз са заобљеним врхом",
                "брзина",
                "воз",
                "железница",
                "шинкансен",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["брзи воз са заобљеним врхом"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("brzi voz sa zaobljenim vrhom"),
            keywords: &[
                "brzi voz sa zaobljenim vrhom",
                "brzina",
                "voz",
                "šinkansen",
                "železnica",
            ],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["brzi voz sa zaobljenim vrhom"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("höghastighetståg"),
            keywords: &["Shinkansen", "TGV", "fordon", "höghastighetståg", "tåg"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("treni yenye kasi yenye umbo la risasi"),
            keywords: &[
                "gari",
                "kasi",
                "reli",
                "risasi",
                "shinkansen",
                "treni",
                "treni yenye kasi yenye umbo la risasi",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("புல\u{bcd}லட\u{bcd} இரயில\u{bcd} வண\u{bcd}டி"),
            keywords: &[
                "புல\u{bcd}லட\u{bcd} இரயில\u{bcd} வண\u{bcd}டி",
                "புல\u{bcd}லெட\u{bcd} இரயில\u{bcd}",
                "புல\u{bcd}லெட\u{bcd} இரயில\u{bcd} வண\u{bcd}டி",
                "புல\u{bcd}லெட\u{bcd} ரயில\u{bcd}",
                "புல\u{bcd}லெட\u{bcd} ரயில\u{bcd} வண\u{bcd}டி",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some(
                "అధ\u{c3f}క వ\u{c47}గం కల\u{c3f}గ\u{c3f}న బుల\u{c4d}ల\u{c46}ట\u{c4d} ర\u{c48}లు",
            ),
            keywords: &[
                "అధ\u{c3f}క వ\u{c47}గం కల\u{c3f}గ\u{c3f}న బుల\u{c4d}ల\u{c46}ట\u{c4d} ర\u{c48}లు",
                "బుల\u{c4d}ల\u{c46}ట\u{c4d}",
                "ర\u{c48}లు",
                "వ\u{c47}గం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("қатораи баландсуръат бо нӯги тирмонанд"),
            keywords: &[
                "роҳи оҳан",
                "синкансен",
                "суръат",
                "тир",
                "қатора",
                "қатораи баландсуръат бо нӯги тирмонанд",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("รถไฟความเร\u{e47}วส\u{e39}ง"),
            keywords: &[
                "ช\u{e34}นค\u{e31}นเซน",
                "ยานพาหนะ",
                "รถไฟ",
                "รถไฟความเร\u{e47}วส\u{e39}ง",
                "ห\u{e31}วกระส\u{e38}น",
                "เร\u{e47}ว",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ok burunly otly"),
            keywords: &["demir ýol", "ok", "ok burunly otly", "otly", "tizlik"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("lēlue oma fakasiapani"),
            keywords: &["lēlue oma fakasiapani"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("yuvarlak uçlu yüksek hızlı tren"),
            keywords: &[
                "mermi burunlu",
                "mermi burunlu shinkansen",
                "shinkansen",
                "taşıt",
                "tren",
                "yuvarlak uçlu yüksek hızlı tren",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("تېز سۈرئەتلىك ئوقپويىز"),
            keywords: &[
                "ئوق",
                "تۆمۈريول",
                "تېز سۈرئەتلىك ئوقپويىز",
                "تېزلىك",
                "شىنكانسېن",
                "پويىز",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("швидкісний потяг з округлим носом"),
            keywords: &[
                "залізниця",
                "кулеподібний",
                "потяг",
                "транспорт",
                "швидкісний",
                "швидкісний потяг з округлим носом",
                "інтерсіті",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("بلٹ کے ناک والی تیز رفتار ٹرین"),
            keywords: &["بلٹ", "بلٹ کے ناک والی تیز رفتار ٹرین", "رفتار", "ٹرین"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("oldi uchli tezyurar poyezd"),
            keywords: &[
                "oldi uchli tezyurar poyezd",
                "poyezd",
                "shinkansen",
                "temiryo‘l",
                "tezyurar",
                "transport",
                "uchli",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("tàu viên đạn"),
            keywords: &[
                "tàu cao tốc Nhật Bản",
                "tàu hỏa",
                "tàu viên đạn",
                "tốc độ",
                "viên đạn",
                "đường sắt",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("otoraay bu gaaw lool ak kanam gu sew"),
            keywords: &[
                "bullet",
                "gaawaay",
                "otoraay",
                "otoraay bu gaaw lool ak kanam gu sew",
                "raay",
                "shinkansen",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("uloliwe obalekayo onempumlo yembumbulu"),
            keywords: &[
                "i-shinkansen",
                "ibhulethu",
                "isantya",
                "isiporo",
                "uloliwe",
                "uloliwe obalekayo onempumlo yembumbulu",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ọkọ oju-irin Alare Pẹlu Imu Ọta"),
            keywords: &[
                "aré",
                "ojú irin",
                "Ọkọ oju-irin Alare Pẹlu Imu Ọta",
                "ọkọ\u{300} ojú irin",
                "ọkọ\u{300} ojú irin abẹ\u{301} ilẹ\u{300}",
                "ọta",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("子彈火車"),
            keywords: &["子彈", "子彈火車", "新幹線", "火車", "速度", "鐵路"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("子弹火车"),
            keywords: &["子弹", "子弹火车", "新干线", "火车", "速度", "铁路"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("子弹头高速列车"),
            keywords: &["动车", "子弹头高速列车", "新干线", "火车", "高速", "高铁"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("高鐡車頭"),
            keywords: &["火車", "高鐡車頭", "高鐵"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("子彈火車"),
            keywords: &["子彈火車", "高速列車"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("isitimela esinesivinini esikhulu esinekhala elinjengenhlamvu"),
            keywords: &[
                "imoto",
                "inhlamvu",
                "isitimela",
                "isitimela esinesivinini esikhulu esinekhala elinjengenhlamvu",
                "isivinini",
                "ujantshi",
            ],
        },
    ],
};
#[doc = "🚆"]
pub const TRAIN: crate::Emoji = crate::Emoji {
    glyph: "🚆",
    codepoint: "1F686",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "train",
    group: "Travel & Places",
    subgroup: "transport-ground",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("trein"),
            keywords: &["spoor", "trein", "voertuig"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ባቡር"),
            keywords: &["ባቡር", "ተሽከርካሪ", "የባቡር መንገድ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("قطار"),
            keywords: &["سكة حديد", "قطار", "مركبة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ট\u{9cd}ৰেইন"),
            keywords: &["ট\u{9cd}ৰেইন", "ৰেইলৱে"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("qatar"),
            keywords: &["dəmir yolu", "nəqliyyat", "qatar"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("цягнік"),
            keywords: &["бч", "рэйкі", "цягнік", "чыгунка"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("влак"),
            keywords: &["влак", "железница", "превозно средство"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ট\u{9cd}রেন"),
            keywords: &["ট\u{9cd}রেন", "য\u{9be}নব\u{9be}হন", "রেলওয\u{9bc}ে"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("tren"),
            keywords: &["hent-houarn", "tren"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("voz"),
            keywords: &["voz", "vozilo", "željeznica"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("tren"),
            keywords: &["tren", "vehicle", "via del tren"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏗᎦᏣᏄᎵ"),
            keywords: &["ᎠᏥᎳ ᏅᏃᎯ", "ᏗᎦᏣᏄᎵ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("vlak"),
            keywords: &["vlak", "vozidlo", "železnice"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("trên"),
            keywords: &["cerbyd", "rheilffordd", "trên"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("tog"),
            keywords: &["køretøj", "tog"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Zug"),
            keywords: &["Eisenbahn", "Zug"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("τρένο"),
            keywords: &["σιδηρόδρομος", "τρένο", "όχημα"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("train"),
            keywords: &["railway", "train"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("tren"),
            keywords: &["ferrocarril", "tren", "vehículo"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["ferrocarril", "transporte", "tren", "viajar", "viaje"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("rong"),
            keywords: &["raudtee", "rong", "sõiduk"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("trena"),
            keywords: &["ibilgailu", "trena", "trenbide"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("قطار"),
            keywords: &["راه\u{200c}آهن", "ریل", "قطار", "وسیله\u{654} نقلیه"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("juna"),
            keywords: &["ajoneuvo", "juna", "rautatie"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("tren"),
            keywords: &["sasakyan", "tren"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("tok"),
            keywords: &["jarnbreyt", "tok"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("train"),
            keywords: &["chemin de fer", "train"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("traein"),
            keywords: &["feithicil", "iarnród", "traein"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("trèana"),
            keywords: &["rathad-iarainn", "rèile", "slighe-iarainn", "trèana"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("tren"),
            keywords: &["ferrocarril", "tren"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ટ\u{acd}ર\u{ac7}ન"),
            keywords: &["ટ\u{acd}ર\u{ac7}ન", "ર\u{ac7}લ\u{acd}વ\u{ac7}", "વાહન"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("jirgin ƙasa"),
            keywords: &["jirgin ƙasa", "reluwe"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("רכבת"),
            keywords: &["רכבת", "תחבורה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ट\u{94d}र\u{947}न"),
            keywords: &["ट\u{94d}र\u{947}न", "र\u{947}लव\u{947}", "वाहन"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("vlak"),
            keywords: &["vlak", "vozilo", "željeznica"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("vonat"),
            keywords: &["jármű", "vasút", "vonat"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("գնացք"),
            keywords: &["գնացք", "երկաթուղի", "փոխադրամիջոց"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("kereta"),
            keywords: &["kendaraan", "kereta", "rel"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ụgbọ okporoigwe"),
            keywords: &["okporoigwe", "ụgbọ okporoigwe"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("lest"),
            keywords: &["járnbraut", "lest"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("treno"),
            keywords: &["ferrovia", "treno", "veicolo"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("電車正面"),
            keywords: &["乗り物", "列車", "電車", "電車正面"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("sepur"),
            keywords: &["jalur ril", "sepur"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მატარებელი"),
            keywords: &["მატარებელი", "რკინიგზა", "ტრანსპორტი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("пойыз"),
            keywords: &["көлік", "пойыз", "темір жол"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("tog"),
            keywords: &["køretøj", "tog"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("រថភ\u{17d2}លើងមើលព\u{17b8}ម\u{17bb}ខ"),
            keywords: &[
                "ក\u{17d2}បាលរថភ\u{17d2}លើង",
                "រថភ\u{17d2}លើងមើលព\u{17b8}ម\u{17bb}ខ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ರೈಲು"),
            keywords: &["ರೈಲು", "ರೈಲ\u{ccd}ವೇ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("기차"),
            keywords: &["기차", "철도"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("ट\u{94d}र\u{947}न"),
            keywords: &["ट\u{94d}र\u{947}न", "र\u{947}ल\u{94d}व\u{947}"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("поезд"),
            keywords: &["поезд", "темир жол", "унаа"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Zuch"),
            keywords: &["Eisebunn", "Zuch"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ລ\u{ebb}ດໄຟ"),
            keywords: &["ພາຫະນະ", "ລ\u{ebb}ດໄຟ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("traukinys"),
            keywords: &["geležinkelis", "traukinys"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("vilciens"),
            keywords: &["dzelzceļš", "transports", "vilciens"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tereina"),
            keywords: &["rerewē", "tereina"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("воз"),
            keywords: &["воз", "возило", "железница"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ട\u{d4d}രെയിൻ"),
            keywords: &["ട\u{d4d}രെയിൻ", "റെയിൽവേ", "വ\u{d3e}ഹനം"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("галт тэрэг"),
            keywords: &["галт тэрэг", "төмөр зам"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("ट\u{94d}र\u{947}न"),
            keywords: &["आगगाडी", "ट\u{94d}र\u{947}न", "र\u{947}ल\u{94d}व\u{947}"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("kereta api"),
            keywords: &["kenderaan", "kereta api", "rel kereta api"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("ferrovija"),
            keywords: &["ferrovija"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ရထား"),
            keywords: &["ရထား", "ရထားလမ\u{103a}း"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("tog"),
            keywords: &["fremkomstmiddel", "jernbane", "tog"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("र\u{947}ल"),
            keywords: &["गाडी", "र\u{947}ल", "र\u{947}लमार\u{94d}ग"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("trein"),
            keywords: &["spoor", "trein"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("tog"),
            keywords: &["framkomstmiddel", "jernbane", "tog"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଟ\u{b4d}ରେନ\u{b4d}\u{200c}"),
            keywords: &["ଟ\u{b4d}ରେନ\u{b4d}\u{200c}", "ବ\u{b3e}ହ\u{b3e}ନ", "ରେଲୱେ"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਰ\u{a47}ਲਗ\u{a71}\u{a71}ਡੀ"),
            keywords: &[
                "ਰ\u{a47}ਲ ਗ\u{a71}\u{a71}ਡੀ",
                "ਰ\u{a47}ਲਗ\u{a71}\u{a71}ਡੀ",
                "ਰ\u{a47}ਲਵ\u{a47}",
                "ਵਾਹਨ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ٹرین"),
            keywords: &["ریلوے", "ٹرین"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Tren"),
            keywords: &["Relwè", "Tren"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("pociąg"),
            keywords: &["kolej", "pociąg", "pojazd"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("اور ګاډی"),
            keywords: &["اور ګاډی", "ريلوی"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("trem"),
            keywords: &["ferrovia", "trem", "veículo"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("comboio"),
            keywords: &["comboio", "linha ferroviária", "linha férrea"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("tren"),
            keywords: &["ferrocarril", "tren"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("tren"),
            keywords: &["cale ferată", "tren", "șine"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-922"),
            keywords: &["E10-922"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("поезд"),
            keywords: &["дорога", "ж/д", "железная дорога", "поезд", "транспорт"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("gariyamoshi"),
            keywords: &["gariyamoshi", "irayirayi"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ريل گاڏي"),
            keywords: &["ريل گاڏي", "ريلوي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ද\u{dd4}ම\u{dca}ර\u{dd2}ය"),
            keywords: &[
                "ද\u{dd4}ම\u{dca}ර\u{dd2}ය",
                "ද\u{dd4}ම\u{dca}ර\u{dd2}ය ම\u{dcf}ර\u{dca}ගය",
                "ව\u{dcf}හනය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("vlak"),
            keywords: &["dopravný prostriedok", "vlak", "železnica"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("vlak"),
            keywords: &["vlak", "vozilo", "železnica"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("tareen"),
            keywords: &["jidka tareenka", "tareen", "tareenka"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("tren"),
            keywords: &["hekurudhë", "mjet", "tren"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("воз"),
            keywords: &["воз", "жeлeзницa"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["воз"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("voz"),
            keywords: &["voz", "železnica"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["voz"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("tåg"),
            keywords: &["fordon", "järnväg", "tåg"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("treni"),
            keywords: &["gari", "reli", "treni"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("இரயில\u{bcd}"),
            keywords: &[
                "இரயில\u{bcd}",
                "இரயில\u{bcd} வண\u{bcd}டி",
                "ரயில\u{bcd}",
                "ரயில\u{bcd} வண\u{bcd}டி",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ర\u{c48}లు"),
            keywords: &[
                "ర\u{c48}లు",
                "స\u{c3e}ధ\u{c3e}రణ కర\u{c46}ంటు ల\u{c47}ద\u{c3e} డ\u{c40}జ\u{c3f}ల\u{c4d} ర\u{c48}లు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("қатора"),
            keywords: &["роҳи оҳан", "қатора"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("รถไฟ"),
            keywords: &["ยานพาหนะ", "รถไฟ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("otly"),
            keywords: &["demir ýol", "otly"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("lēlue"),
            keywords: &["lēlue"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("tren"),
            keywords: &["demiryolu", "taşıt", "tren"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("پويىز"),
            keywords: &["تۆمۈريول", "پويىز"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("потяг"),
            keywords: &["залізниця", "потяг", "транспорт"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ٹرین"),
            keywords: &["سواری", "ٹرین"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("poyezd"),
            keywords: &["poyezd", "temiryo‘l", "transport"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("tàu hỏa"),
            keywords: &["tàu hỏa", "đường sắt"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("saxaar"),
            keywords: &["raay", "saxaar"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("uloliwe"),
            keywords: &["isiporo", "uloliwe"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ṣèdánilẹ\u{301}kọ\u{300}ọ\u{301}"),
            keywords: &["Ṣèdánilẹ\u{301}kọ\u{300}ọ\u{301}", "ọkọ Oju-irin"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("火車"),
            keywords: &["火車", "鐵路"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("火车"),
            keywords: &["火车", "铁路"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("火车"),
            keywords: &["火车", "铁路"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("火車"),
            keywords: &["火車"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("isitimela"),
            keywords: &["imoto", "isitimela", "ujantshi"],
        },
    ],
};
#[doc = "🚇"]
pub const METRO: crate::Emoji = crate::Emoji {
    glyph: "🚇",
    codepoint: "1F687",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "metro",
    group: "Travel & Places",
    subgroup: "transport-ground",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("moltrein"),
            keywords: &["mol", "moltrein", "ondergronds", "trein", "voertuig"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የመሬት ውስጥ ባቡር"),
            keywords: &["ተሽከርካሪ", "የመሬት ውስጥ ባቡር"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("مترو"),
            keywords: &["أنفاق", "مترو", "مركبة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("মেট\u{9cd}ৰো"),
            keywords: &["উপপথ", "মেট\u{9cd}ৰো"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("metro"),
            keywords: &["metro", "nəqliyyat"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("метро"),
            keywords: &["м", "метрапалітэн", "метро", "рэйкі", "цягнік"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("метро"),
            keywords: &["метро", "превозно средство"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("মেট\u{9cd}রো"),
            keywords: &["মেট\u{9cd}রো", "য\u{9be}নব\u{9be}হন", "স\u{9be}বওয\u{9bc}ে"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("metro"),
            keywords: &["hent-houarn", "metro"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("metro"),
            keywords: &["metro", "podzemna", "željeznica"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("metro"),
            keywords: &["metro", "vehicle"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᏔᎾ ᏗᎦᏚᎲ"),
            keywords: &["ᎤᏔᎾ ᏗᎦᏚᎲ", "ᏗᎦᏣᏄᎵ ᏧᏪᏓᏍᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("metro"),
            keywords: &["dráha", "metro", "podzemní", "vozidlo"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("metro"),
            keywords: &["metro", "tanlwybr"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("metro"),
            keywords: &["køretøj", "metro", "undergrund", "undergrundsbane"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("U-Bahn"),
            keywords: &["Metro", "U-Bahn"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("μετρό"),
            keywords: &["μετρό", "υπόγειος"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("metro"),
            keywords: &["metro", "subway"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: None,
            keywords: &["metro", "subway", "tube", "underground"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("subway"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("metro"),
            keywords: &["metro", "subterráneo", "suburbano", "transporte"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("subterráneo"),
            keywords: &["metro", "subte", "subterráneo", "transporte"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("metro"),
            keywords: &["metro", "subterráneo", "transporte"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("metroo"),
            keywords: &["metroo", "rong", "sõiduk"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("metroa"),
            keywords: &["ibilgailu", "metro", "metroa"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("قطار شهری"),
            keywords: &[
                "راه\u{200c}آهن زیرزمینی",
                "قطار شهری",
                "مترو",
                "وسیله\u{654} نقلیه",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("metro"),
            keywords: &["ajoneuvo", "maanalainen", "metro"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("subway"),
            keywords: &["metro", "sasakyan", "subway", "underground"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("undirgrundarbreyt"),
            keywords: &["metro", "undirgrundarbreyt"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("métro"),
            keywords: &["métro"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("traein faoi thalamh"),
            keywords: &["feithicil", "meitreo", "traein faoi thalamh"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("meatro"),
            keywords: &["fo-thalamh", "meatro"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("metro"),
            keywords: &["metro"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("સબવ\u{ac7}"),
            keywords: &["મ\u{ac7}ટ\u{acd}રો", "વાહન", "સબવ\u{ac7}"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("metro"),
            keywords: &["hanyar jirgin ƙasa na rami", "metro"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("רכבת תחתית"),
            keywords: &["מטרו", "סאבוויי", "רכבת תחתית", "תחבורה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("सबव\u{947}, म\u{947}ट\u{94d}रो"),
            keywords: &[
                "म\u{947}ट\u{94d}रो",
                "वाहन",
                "सबव\u{947}",
                "सबव\u{947}, म\u{947}ट\u{94d}रो",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("podzemna željeznica"),
            keywords: &["metro", "podzemna", "podzemna željeznica", "vozilo"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("metró"),
            keywords: &["földalatti", "jármű", "metró"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("մետրո"),
            keywords: &["մետրո", "փոխադրամիջոց"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("kereta bawah tanah"),
            keywords: &["bawah", "kendaraan", "kereta bawah tanah", "tanah"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("Metiro"),
            keywords: &["Metiro", "ụzọ imeala"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("neðanjarðarlest"),
            keywords: &["farartæki", "neðanjarðarlest"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("metropolitana"),
            keywords: &["metro", "metropolitana", "veicolo"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("地下鉄"),
            keywords: &["メトロ", "乗り物", "地下鉄", "電車"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("sepur metro"),
            keywords: &["metro", "sepur metro", "sepur ngisor lemah"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მეტრო"),
            keywords: &["მეტრო", "ტრანსპორტი"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("amitṛu"),
            keywords: &["amitṛu"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("метро"),
            keywords: &["көлік", "метро"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("metro"),
            keywords: &["køretøj", "metro"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("រថភ\u{17d2}លើងម\u{17c9}េត\u{17d2}រ\u{17bc}"),
            keywords: &[
                "ម\u{17c9}េត\u{17d2}រ\u{17bc}",
                "រថភ\u{17d2}លើង",
                "រថភ\u{17d2}លើងម\u{17c9}េត\u{17d2}រ\u{17bc}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಮ\u{cc6}ಟ\u{ccd}ರೋ"),
            keywords: &["ಮ\u{cc6}ಟ\u{ccd}ರೋ", "ಸುರಂಗ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("지하철"),
            keywords: &["메트로", "전철", "지하철"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("म\u{945}ट\u{94d}रो"),
            keywords: &["म\u{945}ट\u{94d}रो", "सबव\u{947}"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("метро"),
            keywords: &["метро", "унаа"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Metro"),
            keywords: &["Metro", "U-Bahn"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ລ\u{ebb}ດໄຟໃຕ\u{ec9}ດ\u{eb4}ນ"),
            keywords: &["ພາຫານະ", "ລ\u{ebb}ດໄຟໃຕ\u{ec9}ດ\u{eb4}ນ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("metro"),
            keywords: &["metro", "transporto priemonė"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("metro"),
            keywords: &["metro", "transports"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("rarowhenua"),
            keywords: &["rarowhenua", "rerewē rarowhenua"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("метро"),
            keywords: &["возило", "железница", "метро", "подземна"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("മെട\u{d4d}രോ"),
            keywords: &["മെട\u{d4d}രോ", "വ\u{d3e}ഹനം", "സബ\u{d4d}\u{200c}വേ"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("метро"),
            keywords: &["метро"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("म\u{947}ट\u{94d}रो"),
            keywords: &[
                "भ\u{941}यारी र\u{947}ल\u{94d}व\u{947}",
                "म\u{947}ट\u{94d}रो",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("kereta api bawah tanah"),
            keywords: &["kenderaan", "kereta api bawah tanah", "kereta bawah tanah"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("metro"),
            keywords: &["metro", "subway"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("မြေအောက\u{103a}ရထား"),
            keywords: &["မက\u{103a}ထရ\u{102d}\u{102f}", "မြေအောက\u{103a}ရထား"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("tunnelbane"),
            keywords: &[
                "fremkomstmiddel",
                "metro",
                "t-bane",
                "tunnelbane",
                "undergrunnsbane",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("म\u{947}ट\u{94d}रो"),
            keywords: &["गाडी", "म\u{947}ट\u{94d}रो", "सवव\u{947}"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("metro"),
            keywords: &["metro", "ondergrondse"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("tunnelbane"),
            keywords: &[
                "framkomstmiddel",
                "metro",
                "t-bane",
                "tunnelbane",
                "undergrunnsbane",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ମେଟ\u{b4d}ରୋ"),
            keywords: &["ବ\u{b3e}ହ\u{b3e}ନ", "ମେଟ\u{b4d}ରୋ", "ସବ\u{b4d}\u{200c}ୱେ"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਮ\u{a48}ਟਰ\u{a4b}"),
            keywords: &["ਮ\u{a48}ਟਰ\u{a4b}", "ਵਾਹਨ", "ਸਬਵ\u{a47}"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("میٹرو"),
            keywords: &["زمین دوز رستہ", "میٹرو"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Mẹ\u{301}tro"),
            keywords: &["Mẹ\u{301}tro", "Sọ\u{301}bwè"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("metro"),
            keywords: &["kolejka", "metro", "pociąg", "tunel"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("میترو"),
            keywords: &["سبوی", "ميترو", "میترو"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("metrô"),
            keywords: &["metrô", "veículo"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("metro"),
            keywords: &["metro", "metropolitano"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("metro"),
            keywords: &["metro", "subterraneo"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("metrou"),
            keywords: &["metrou", "tren", "tunel"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-923"),
            keywords: &["E10-923"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("метро"),
            keywords: &["метро", "подземка", "поезд", "станция"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("metiro"),
            keywords: &["Irayirayi ryo mu kuzimu", "metiro"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ميٽرو"),
            keywords: &["زمين جي هيٺ ريل", "ميٽرو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("මෙට\u{dca}\u{200d}රො"),
            keywords: &[
                "ද\u{dd4}ම\u{dca}ර\u{dd2}ය ම\u{dcf}ර\u{dca}ගය",
                "මෙට\u{dca}\u{200d}රො",
                "ව\u{dcf}\u{dcf}හනය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("metro"),
            keywords: &["dopravný prostriedok", "dráha", "metro", "podzemná"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("podzemni vlak"),
            keywords: &["podzemna železnica", "podzemni vlak", "vozilo"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("waddo hoose"),
            keywords: &["waddo hoose"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("metro"),
            keywords: &["metro", "tunel"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("метро"),
            keywords: &["метро", "пoдзeмнa жeлeзницa"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["метро"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("metro"),
            keywords: &["metro", "podzemna železnica"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["metro"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("tunnelbana"),
            keywords: &["fordon", "metro", "tunnelbana"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("metro"),
            keywords: &["gari", "metro", "reli ya chini ya ardhi"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("மெட\u{bcd}ரோ ரயில\u{bcd}"),
            keywords: &[
                "மெட\u{bcd}ரோ இரயில\u{bcd}",
                "மெட\u{bcd}ரோ இரயில\u{bcd} வண\u{bcd}டி",
                "மெட\u{bcd}ரோ ரயில\u{bcd}",
                "மெட\u{bcd}ரோ ரயில\u{bcd} வண\u{bcd}டி",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("మ\u{c46}ట\u{c4d}ర\u{c4b} ర\u{c48}లు"),
            keywords: &["మ\u{c46}ట\u{c4d}ర\u{c4b}", "ర\u{c48}లు"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("метро"),
            keywords: &["метро"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("รถไฟใต\u{e49}ด\u{e34}น"),
            keywords: &["ยานพาหนะ", "รถไฟ", "รถไฟใต\u{e49}ด\u{e34}น"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("metro"),
            keywords: &["metro", "ýerasty ýol"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("lēlue lalofonua"),
            keywords: &["lēlue lalofonua"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("metro"),
            keywords: &["metro", "taşıt"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("مېترو"),
            keywords: &["مېترو", "يەر ئاستى يولى"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("метро"),
            keywords: &["метро", "транспорт"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("میٹرو"),
            keywords: &["ریلوے", "زیر زمین", "میٹرو"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("metro"),
            keywords: &["metro", "transport"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("tàu điện ngầm"),
            keywords: &["tàu điện ngầm", "xe điện ngầm"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("metro"),
            keywords: &["metro", "subweey"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("i-metro"),
            keywords: &["i-metro", "isiporo esihamba ngaphantsi komhlaba"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Àjà ilẹ\u{300}"),
            keywords: &["Àjà ilẹ\u{300}", "ọ\u{300}nà ọkọ\u{300} ojú irin"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("地鐵"),
            keywords: &["地鐵"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("地铁"),
            keywords: &["地铁"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("地铁"),
            keywords: &["地铁"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("地鐵"),
            keywords: &["地鐵", "捷運"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["列車", "地下鐵", "地鐵", "捷運"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("isitimela esihamba ngaphansi komhlaba"),
            keywords: &[
                "imoto",
                "isitimela esihamba ngaphansi komhlaba",
                "umzila wesitimela ongaphansi komhlaba",
            ],
        },
    ],
};
#[doc = "🚈"]
pub const LIGHT_RAIL: crate::Emoji = crate::Emoji {
    glyph: "🚈",
    codepoint: "1F688",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "light rail",
    group: "Travel & Places",
    subgroup: "transport-ground",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("smalspoortrein"),
            keywords: &["smalspoortrein", "spoor", "trein", "voertuig"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ቀላል ባቡር"),
            keywords: &["ቀላል ባቡር", "ተሽከርካሪ", "የባቡር መንገድ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("نقل خفيف"),
            keywords: &["خفيف", "سكة حديد", "مركبة", "نقل خفيف"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("প\u{9be}তল ৰেইল"),
            keywords: &["প\u{9be}তল ৰেইল", "ৰেইলৱে"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("işıq qatarı"),
            keywords: &["dəmir yolu", "işıq qatarı", "nəqliyyat"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("электрычка"),
            keywords: &["бч", "рэйкі", "чыгунка", "электрычка"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("лека железница"),
            keywords: &["железница", "лека железница", "превозно средство"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("রেলের ল\u{9be}ইট"),
            keywords: &["য\u{9be}নব\u{9be}হন", "রেলওয\u{9bc}ে", "রেলের ল\u{9be}ইট"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("metro skañv"),
            keywords: &["hent-houarn", "metro skañv"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("svjetlosna pruga"),
            keywords: &["svjetlosna pruga", "vozilo", "željeznica"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("tren lleuger"),
            keywords: &[
                "ferrocarril",
                "metro lleuger",
                "tren",
                "tren lleuger",
                "vehicle",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎦᏎᎧ ᏗᏐᏲ"),
            keywords: &["ᎠᏥᎳ ᏅᏃᎯ", "ᎦᏎᎧ ᏗᏐᏲ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("rychlodrážní tramvaj"),
            keywords: &["rychlodrážní tramvaj", "vozidlo", "železnice"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("rheilffordd ysgafn"),
            keywords: &["rheilffordd", "rheilffordd ysgafn"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("letbane"),
            keywords: &["køretøj", "letbane", "tog"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("S-Bahn"),
            keywords: &["S-Bahn", "Zug"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ελαφρύς σιδηρόδρομος"),
            keywords: &["ελαφρύς σιδηρόδρομος", "σιδηρόδρομος"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("light rail"),
            keywords: &["light rail", "railway"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("tren ligero"),
            keywords: &["ferrocarril", "transporte", "tren", "tren ligero"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kergraudtee"),
            keywords: &["kergraudtee", "raudtee", "rong"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("tren arina"),
            keywords: &["ibilgailu", "tren arina", "trenbide"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("قطار سبک شهری"),
            keywords: &[
                "راه\u{200c}آهن",
                "ریل",
                "قطار سبک شهری",
                "وسیله\u{654} نقلیه",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kevytraidejuna"),
            keywords: &["ajoneuvo", "juna", "kevytraidejuna", "rautatie"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("light rail"),
            keywords: &["light rail", "sasakyan", "tren"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("nærtok"),
            keywords: &["nærtok", "tok"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("métro léger"),
            keywords: &["métro", "métro léger"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("train de banlieue"),
            keywords: &["chemin de fer", "métro léger", "train de banlieue"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("iarnród éadrom"),
            keywords: &["feithicil", "iarnród éadrom", "éadrom. iarnród"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("rèile aotrom"),
            keywords: &["rathad-iarainn", "rèile", "rèile aotrom", "slighe-iarainn"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("tren lixeiro"),
            keywords: &["tranvía", "tren lixeiro"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("લાઇટ ર\u{ac7}લ"),
            keywords: &["ર\u{ac7}લ", "લાઇટ", "વાહન"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("reluwe na cunkoso mara yawa"),
            keywords: &["reluwe", "reluwe na cunkoso mara yawa"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("רכבת קלה"),
            keywords: &["קלה", "רכבת", "תחבורה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("लाइट र\u{947}ल"),
            keywords: &["र\u{947}ल", "लाइट र\u{947}ल", "वाहन"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("laka željeznica"),
            keywords: &["laka željeznica", "vozilo", "željeznica"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("hév"),
            keywords: &["hév", "jármű", "vasút"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("վերգետնյա մետրո"),
            keywords: &["երկաթուղի", "վերգետնյա մետրո", "փոխադրամիջոց"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("light rail"),
            keywords: &["kendaraan", "light rail", "rel"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("nwa obere ọkụ okporoigwe"),
            keywords: &["nwa obere ọkụ okporoigwe", "okporoigwe"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("léttlest"),
            keywords: &["lest", "létt", "léttlest"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("metrotranvia"),
            keywords: &["metrotranvia", "veicolo"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ライトレール"),
            keywords: &["ライトレール", "乗り物", "電車"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("sepur LRT"),
            keywords: &["jalur ril", "sepur LRT"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მსუბუქი რკინიგზა"),
            keywords: &["მსუბუქი რკინიგზა", "რკინიგზა", "ტრანსპორტი"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("amitru afess"),
            keywords: &["amitru afess"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("тар табанды темір жол"),
            keywords: &["көлік", "тар табанды темір жол", "темір жол"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("letbane"),
            keywords: &["køretøj", "letbane", "tog"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("រថភ\u{17d2}លើងក\u{17d2}ន\u{17bb}ងក\u{17d2}រ\u{17bb}ង"),
            keywords: &[
                "ក\u{17d2}បាលរថភ\u{17d2}លើង",
                "រថភ\u{17d2}លើង",
                "រថភ\u{17d2}លើងក\u{17d2}ន\u{17bb}ងក\u{17d2}រ\u{17bb}ង",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಲಘು ರೈಲು"),
            keywords: &["ರೈಲು", "ಲಘು ರೈಲು"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("경전철"),
            keywords: &["경전철", "교통수단", "기차"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("लायट र\u{947}ल"),
            keywords: &["र\u{947}ल\u{94d}व\u{947}", "लायट र\u{947}ल"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("чакан метро"),
            keywords: &["темир жол", "чакан метро"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Stadbunn"),
            keywords: &["Eisebunn", "Stadbunn"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ລາງລ\u{ebb}ດເບ\u{ebb}າ"),
            keywords: &["ພາຫະນະ", "ລາງລ\u{ebb}ດເບ\u{ebb}າ", "ລ\u{ebb}ດໄຟ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("miesto tramvajus"),
            keywords: &["geležinkelis", "miesto tramvajus"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("piepilsētas vilciens"),
            keywords: &[
                "dzelzceļš",
                "piepilsētas vilciens",
                "transports",
                "vilciens",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("rerewē māmā"),
            keywords: &["rerewē", "rerewē māmā"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("лесна железница"),
            keywords: &["возило", "железница", "лесна железница"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ലൈറ\u{d4d}റ\u{d4d} റെയിൽ"),
            keywords: &["റെയിൽ", "ലൈറ\u{d4d}റ\u{d4d}", "വ\u{d3e}ഹനം"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("хөнгөн төмөр зам"),
            keywords: &["төмөр зам", "хөнгөн", "хөнгөн төмөр зам"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("लाइट र\u{947}ल"),
            keywords: &["र\u{947}ल\u{94d}व\u{947}", "लाइट र\u{947}ल"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("rel ringan"),
            keywords: &["kenderaan", "rel kereta api", "rel ringan"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("ferrovija ħafifa"),
            keywords: &["ferrovija", "ferrovija ħafifa"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အပေါ\u{1037}စား ရထား"),
            keywords: &["ရထားလမ\u{103a}း", "အပေါ\u{1037}စား ရထား"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("lokaltog"),
            keywords: &["fremkomstmiddel", "jernbane", "lokaltog"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("हल\u{94d}का र\u{947}ल"),
            keywords: &["गाडी", "र\u{947}लव\u{947}", "हल\u{94d}का र\u{947}ल"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("lightrail"),
            keywords: &["lightrail", "spoor"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("lokaltog"),
            keywords: &["framkomstmiddel", "jernbane", "lokaltog"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ହ\u{b3e}ଲକ\u{b3e} ଟ\u{b4d}ରେନ\u{b4d}\u{200c}"),
            keywords: &[
                "ବ\u{b3e}ହ\u{b3e}ନ",
                "ରେଳ",
                "ଲ\u{b3e}ଇଟ\u{b4d}",
                "ହ\u{b3e}ଲକ\u{b3e} ଟ\u{b4d}ରେନ\u{b4d}\u{200c}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਲਾਈਟ ਰ\u{a47}ਲ"),
            keywords: &["ਰ\u{a47}ਲ", "ਲਾਈਟ ਰ\u{a47}ਲ", "ਵਾਹਨ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("لائٹ ٹرین"),
            keywords: &["ریلوے", "لائٹ ٹرین"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Laít Rel"),
            keywords: &["Laít Rel", "Relwè"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("kolej miejska"),
            keywords: &["kolej", "kolej miejska", "kolejka", "pociąg", "podmiejski"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("کوچنی اور کاډی"),
            keywords: &["ريلوی", "کوچنی اور کاډی"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("trem urbano"),
            keywords: &["leve", "trem", "trem urbano", "veículo"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("metro de superfície"),
            keywords: &["linha ferroviária", "metro de superfície"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("tren ușor"),
            keywords: &["cale ferată", "tren ușor", "șine"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-924"),
            keywords: &["E10-924"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("легкий рельсовый транспорт"),
            keywords: &[
                "легкий рельсовый транспорт",
                "трамвай",
                "транспорт",
                "электричка",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("gariyamoshi yoroheje"),
            keywords: &["gariyamoshi yoroheje", "irayirayi"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("برقي جي ري گاڏي"),
            keywords: &["برقي جي ري گاڏي", "ريلوي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("සැහැල\u{dca}ල\u{dd4} ද\u{dd4}ම\u{dca}ර\u{dd2}ය"),
            keywords: &[
                "ද\u{dd4}ම\u{dca}ර\u{dd2}ය ම\u{dcf}ර\u{dca}ගය",
                "ව\u{dcf}හනය",
                "සැහැල\u{dca}ල\u{dd4} ද\u{dd4}ම\u{dca}ර\u{dd2}ය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("ľahké metro"),
            keywords: &["dopravný prostriedok", "ľahké metro", "železnica"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("ozkotirna železnica"),
            keywords: &["ozkotirna železnica", "vozilo", "železnica"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("tareenka fudud"),
            keywords: &["jidka tareenka", "tareenka fudud"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("metro e lehtë"),
            keywords: &["hekurudhë", "metro e lehtë", "mjet"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("градска железница"),
            keywords: &["градска железница", "желeзницa"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("градска жељезница"),
            keywords: &["градска жељезница"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("gradska železnica"),
            keywords: &["gradska železnica", "železnica"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("gradska željeznica"),
            keywords: &["gradska željeznica"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("snabbspårväg"),
            keywords: &["fordon", "lättbana", "snabbspårväg"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("reli nyepesi"),
            keywords: &["gari", "reli", "reli nyepesi"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("லைட\u{bcd} ரயில\u{bcd}"),
            keywords: &["இரயில\u{bcd}", "ரயில\u{bcd}", "லைட\u{bcd} ரயில\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("తక\u{c4d}కువ పర\u{c3f}మ\u{c3e}ణ ర\u{c48}లు"),
            keywords: &[
                "తక\u{c4d}కువ పర\u{c3f}మ\u{c3e}ణ ర\u{c48}లు",
                "పర\u{c3f}మ\u{c3e}ణం",
                "ర\u{c48}లు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("метрои сабук"),
            keywords: &["метрои сабук", "роҳи оҳан"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("รถไฟรางเบา"),
            keywords: &["ยานพาหนะ", "รถไฟ", "รถไฟรางเบา"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ýeňil metro"),
            keywords: &["demir ýol", "ýeňil metro"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("kiʻi lēlue"),
            keywords: &["kiʻi lēlue"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("hafif raylı"),
            keywords: &["demiryolu", "hafif", "hafif raylı", "taşıt"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("يېنىك تۆمۈريول"),
            keywords: &["تۆمۈريول", "يېنىك تۆمۈريول"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("швидкісний трамвай"),
            keywords: &["залізниця", "транспорт", "швидкісний трамвай"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("لائٹ ریل"),
            keywords: &["ریلوے", "سواری", "لائٹ ریل"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("tor izli temiryo‘l"),
            keywords: &["temiryo‘l", "tor izli temiryo‘l", "transport"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("tàu điện nhẹ"),
            keywords: &["tàu điện nhẹ", "xe cộ", "đường sắt"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("otoraay bu moome fépp"),
            keywords: &["otoraay bu moome fépp", "raay"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("intonga yokukhanya"),
            keywords: &["intonga yokukhanya", "isiporo"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ọkọ oju-irin kekere"),
            keywords: &["Ọkọ oju-irin kekere", "ọkọ Oju-irin"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("輕鐵"),
            keywords: &["輕鐵", "鐵路"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("轻铁"),
            keywords: &["轻铁", "铁路"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("轻轨"),
            keywords: &["火车", "轻轨"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("輕軌"),
            keywords: &["火車", "輕軌"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("輕軌列車"),
            keywords: &["火車", "輕軌列車"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("isitimela esingengethilamu"),
            keywords: &["imoto", "isitimela esingengethilamu", "ujantshi"],
        },
    ],
};
#[doc = "🚉"]
pub const STATION: crate::Emoji = crate::Emoji {
    glyph: "🚉",
    codepoint: "1F689",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "station",
    group: "Travel & Places",
    subgroup: "transport-ground",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("stasie"),
            keywords: &["spoor", "stasie", "trein", "voertuig"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ጣቢያ"),
            keywords: &["ባቡር", "ተሽከርካሪ", "የባቡር መንገድ", "ጣቢያ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("محطة قطار"),
            keywords: &["قطار", "محطة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ষ\u{9cd}টেচন"),
            keywords: &["ট\u{9cd}ৰেইন", "ষ\u{9cd}টেচন", "ৰেইলৱে"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("stansiya"),
            keywords: &["dəmir yolu", "nəqliyyat", "qatar", "stansiya"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("станцыя"),
            keywords: &["прыпынак", "станцыя", "цягнік", "чыгунка"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("гара"),
            keywords: &["влак", "гара", "железница", "превозно средство"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("স\u{9cd}টেশন"),
            keywords: &[
                "ট\u{9cd}রেন",
                "য\u{9be}নব\u{9be}হন",
                "রেলওয\u{9bc}ে",
                "স\u{9cd}টেশন",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("porzh-houarn"),
            keywords: &["hent-houarn", "porzh-houarn", "tren"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("stanica"),
            keywords: &["stanica", "voz", "vozilo", "željeznica"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("estació"),
            keywords: &["estació", "tren", "vehicle", "vies"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏓᏁᎸ"),
            keywords: &["ᎠᏓᏁᎸ", "ᎠᏥᎳ ᏅᏃᎯ", "ᏗᎦᏣᏄᎵ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("stanice"),
            keywords: &[
                "nástupiště",
                "peron",
                "stanice",
                "vlak",
                "vozidlo",
                "zastávka",
                "železnice",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("gorsaf"),
            keywords: &["gorsaf", "rheilffordd", "trên"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("togstation"),
            keywords: &["station", "tog", "togstation"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Bahnhof"),
            keywords: &["Bahnhof", "Zug"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("σταθμός"),
            keywords: &["σιδηρόδρομος", "σταθμός", "τρένο", "όχημα"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("station"),
            keywords: &["railway", "station", "train"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("estación de tren"),
            keywords: &["estación", "estación de tren", "tren"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &[
                "estación de tren",
                "ferrocarril",
                "transporte",
                "tranvía",
                "tren",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("jaam"),
            keywords: &["jaam", "raudtee", "rong"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("geltokia"),
            keywords: &["geltokia", "ibilgailu", "trenbide"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("ایستگاه قطار"),
            keywords: &[
                "ایستگاه قطار",
                "راه\u{200c}آهن",
                "ریل",
                "قطار",
                "وسیله\u{654} نقلیه",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("asema"),
            keywords: &["ajoneuvo", "asema", "juna", "rautatie"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("istasyon"),
            keywords: &["istasyon", "platform", "sasakyan", "tren"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("jarnbreytarstøð"),
            keywords: &["jarnbreyt", "jarnbreytarstøð", "støð", "tok"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("gare"),
            keywords: &["gare", "train"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["chemin de fer", "gare", "train"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("stáisiún traenach"),
            keywords: &["stáisiún", "stáisiún traenach", "traein"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("stèisean"),
            keywords: &[
                "rathad-iarainn",
                "rèile",
                "slighe-iarainn",
                "stèisean",
                "trèana",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("estación"),
            keywords: &["estación", "tranvía", "tren"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ટ\u{acd}ર\u{ac7}ન સ\u{acd}ટ\u{ac7}શન"),
            keywords: &["ટ\u{acd}ર\u{ac7}ન", "સ\u{acd}ટ\u{ac7}શન"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("tasha"),
            keywords: &["jirgin ƙasa", "reluwe", "tasha"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("תחנה"),
            keywords: &["רכבת", "תחבורה", "תחנה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("स\u{94d}ट\u{947}शन"),
            keywords: &["ट\u{94d}र\u{947}न", "स\u{94d}ट\u{947}शन"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("postaja"),
            keywords: &["postaja", "vlak", "vozilo", "željeznica"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("állomás"),
            keywords: &["jármű", "vasút", "vonat", "állomás"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("կայարան"),
            keywords: &["գնացք", "երկաթուղի", "կայարան", "փոխադրամիջոց"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("stasiun"),
            keywords: &["kendaraan", "kereta", "rel", "stasiun"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ọdụ ụgbọ"),
            keywords: &["okporoigwe", "ọdụ ụgbọ", "ụgbọokporoigwe"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("lestarstöð"),
            keywords: &["lest", "lestarstöð", "stöð"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("stazione"),
            keywords: &["stazione", "treno"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("駅"),
            keywords: &["乗り物", "列車", "電車", "駅"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("setasiun"),
            keywords: &["jalur ril", "sepur", "setasiun"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("სადგური"),
            keywords: &["მატარებელი", "რკინიგზა", "სადგური", "ტრანსპორტი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("станция"),
            keywords: &["көлік", "пойыз", "станция", "темір жол"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("togstation"),
            keywords: &["tog", "togstation"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ស\u{17d2}ថាន\u{17b8}យ"),
            keywords: &[
                "ផ\u{17d2}ល\u{17bc}វរថភ\u{17d2}លើង",
                "រថភ\u{17d2}លើង",
                "ស\u{17d2}ថាន\u{17b8}យ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ನ\u{cbf}ಲ\u{ccd}ದಾಣ"),
            keywords: &["ನ\u{cbf}ಲ\u{ccd}ದಾಣ", "ರೈಲು"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("기차역"),
            keywords: &["기차역", "역", "전철역", "지하철역"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("स\u{94d}ट\u{947}शन"),
            keywords: &[
                "ट\u{94d}र\u{947}न",
                "र\u{947}ल\u{94d}व\u{947}",
                "स\u{94d}ट\u{947}शन",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("станция"),
            keywords: &["поезд", "станция", "темир жол", "унаа"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Haltestell"),
            keywords: &["Eisebunn", "Haltestell", "Zuch"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ສະຖານ\u{eb5}"),
            keywords: &["ພາຫະນະ", "ລ\u{ebb}ດໄຟ", "ສະຖານ\u{eb5}"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("stotis"),
            keywords: &["geležinkelis", "stotis", "traukinys"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("stacija"),
            keywords: &["dzelzceļš", "stacija", "transports", "vilciens"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("teihana"),
            keywords: &["rerewē", "teihana", "tereina"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("станица"),
            keywords: &["воз", "возило", "железница", "станица"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("റെയിൽവേ സ\u{d4d}റ\u{d4d}റേഷൻ"),
            keywords: &[
                "ട\u{d4d}രെയിൻ",
                "റെയിൽവേ സ\u{d4d}റ\u{d4d}റേഷൻ",
                "സ\u{d4d}റ\u{d4d}റേഷൻ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("галт тэрэгний буудал"),
            keywords: &["буудал", "галт тэрэг", "галт тэрэгний буудал"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("स\u{94d}ट\u{947}शन"),
            keywords: &["आगगाडी", "र\u{947}ल\u{94d}व\u{947}", "स\u{94d}ट\u{947}शन"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("stesen"),
            keywords: &["kenderaan", "kereta api", "rel kereta api", "stesen"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("stazzjon"),
            keywords: &["ferrovija", "stazzjon"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဘ\u{1030}တာရ\u{102f}\u{1036}"),
            keywords: &["ဘ\u{1030}တာရ\u{102f}\u{1036}", "ရထား", "ရထားလမ\u{103a}း"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("togstasjon"),
            keywords: &["jernbane", "stasjon", "tog", "togstasjon"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("स\u{94d}ट\u{947}शन"),
            keywords: &[
                "गाडी",
                "ट\u{94d}र\u{947}न",
                "र\u{947}लव\u{947}",
                "स\u{94d}ट\u{947}शन",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("treinstation"),
            keywords: &["spoor", "trein", "treinstation"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("togstasjon"),
            keywords: &["jernbane", "stasjon", "tog", "togstasjon"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଷ\u{b4d}ଟେସନ\u{b4d}\u{200c}"),
            keywords: &["ଟ\u{b4d}ରେନ\u{b4d}", "ଷ\u{b4d}ଟେସନ\u{b4d}\u{200c}"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਸਟ\u{a47}ਸ\u{a3c}ਨ"),
            keywords: &[
                "ਰ\u{a47}ਲ ਗ\u{a71}ਡੀ",
                "ਰ\u{a47}ਲ ਗ\u{a71}ਡੀ ਸਟ\u{a47}ਸ\u{a3c}ਨ",
                "ਸਟ\u{a47}ਸ\u{a3c}ਨ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("سٹیشن"),
            keywords: &["ریلوے", "سٹیشن", "ٹرین"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Stéshọn"),
            keywords: &["Relwè", "Stéshọn", "Tren"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("stacja"),
            keywords: &["dworzec", "kolej", "stacja"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("تمځای"),
            keywords: &["اور کاډی", "تمځای", "ريلوی"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("estação"),
            keywords: &["estação", "trem"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["comboio", "estação", "linha ferroviária"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("estacion"),
            keywords: &["estacion", "ferrocarril", "tren"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("gară"),
            keywords: &["cale ferată", "gară", "haltă", "stație", "tren"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-925"),
            keywords: &["E10-925"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("железнодорожный вокзал"),
            keywords: &[
                "вокзал",
                "ж/д вокзал",
                "ж/д станция",
                "железнодорожная станция",
                "железнодорожный вокзал",
                "рельсы",
                "станция",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("sitasiyo"),
            keywords: &["gariyamoshi", "irayirayi", "sitasiyo"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("اسٽيشن"),
            keywords: &["اسٽيشن", "ريل", "ريلوي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("නැවත\u{dd4}ම\u{dca}පොළ"),
            keywords: &[
                "ද\u{dd4}ම\u{dca}ර\u{dd2}ය",
                "ද\u{dd4}ම\u{dca}ර\u{dd2}ය ම\u{dcf}ර\u{dca}ගය",
                "නැවත\u{dd4}ම\u{dca}පොළ",
                "ව\u{dcf}හනය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("stanica"),
            keywords: &["dopravný prostriedok", "stanica", "vlak", "železnica"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("postaja"),
            keywords: &["postaja", "vlak", "vozilo", "železnica"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("saldhig"),
            keywords: &["jidka tareenka", "saldhig", "saldhigga", "tareen"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("stacion"),
            keywords: &["hekurudhë", "mjet", "stacion", "tren"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("станица"),
            keywords: &["воз", "жeлeзницa", "станица"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["станица"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("stanica"),
            keywords: &["stanica", "voz", "železnica"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["stanica"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("tågstation"),
            keywords: &["station", "tåg", "tågstation"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kituo"),
            keywords: &["gari", "kituo", "reli", "teni"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ரயில\u{bcd} நிலையம\u{bcd}"),
            keywords: &["இரயில\u{bcd} நிலையம\u{bcd}", "ரயில\u{bcd} நிலையம\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ర\u{c48}ల\u{c4d}వ\u{c47} స\u{c4d}ట\u{c47}షన\u{c4d}"),
            keywords: &[
                "ర\u{c48}లు",
                "ర\u{c48}ల\u{c4d}వ\u{c47} స\u{c4d}ట\u{c47}షన\u{c4d}",
                "స\u{c4d}ట\u{c47}షన\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("истгоҳ"),
            keywords: &["истгоҳ", "роҳи оҳан", "қатора"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("สถาน\u{e35}รถไฟ"),
            keywords: &["ยานพาหนะ", "รถไฟ", "สถาน\u{e35}รถไฟ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("menzil"),
            keywords: &["demir ýol", "menzil", "otly"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tauʻanga lēlue"),
            keywords: &["tauʻanga lēlue"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("tren istasyonu"),
            keywords: &["istasyon", "tren", "tren istasyonu"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ۋوگزال"),
            keywords: &["تۆمۈر يول", "پويىز", "ۋوگزال"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("станція"),
            keywords: &["cтанція", "залізниця", "потяг", "станція", "транспорт"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("اسٹیشن"),
            keywords: &["اسٹیشن", "ریلوے", "ٹرین"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("bekat"),
            keywords: &["bekat", "poyezd", "temiryo‘l", "transport"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("ga tàu"),
            keywords: &["ga tàu", "tàu hỏa", "đường sắt"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("gaar"),
            keywords: &["gaar", "otoraay", "raay"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("isitishi"),
            keywords: &["isiporo", "isitishi", "uloliwe"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ibudo"),
            keywords: &["Ibudo", "ojú-irin", "ọkọ ojú-irin"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("車站"),
            keywords: &["火車", "車站", "鐵路"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("车站"),
            keywords: &["火车", "车站", "铁路"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("车站"),
            keywords: &["火车", "车站", "铁路"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("車站"),
            keywords: &["車站"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("isiteshi"),
            keywords: &["imoto", "isiteshi", "isitimela", "ujantshi"],
        },
    ],
};
#[doc = "🚊"]
pub const TRAM: crate::Emoji = crate::Emoji {
    glyph: "🚊",
    codepoint: "1F68A",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "tram",
    group: "Travel & Places",
    subgroup: "transport-ground",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("trem"),
            keywords: &["spoor", "trem", "voertuig"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ባቡር መሰል አውቶቡስ"),
            keywords: &["ባቡር መሰል አውቶቡስ", "ተሽከርካሪ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("ترام"),
            keywords: &["ترام", "مركبة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ট\u{9cd}ৰ\u{9be}ম"),
            keywords: &["ট\u{9cd}ৰ\u{9be}ম", "ট\u{9cd}ৰ’লীব\u{9be}ছ"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("stritkar"),
            keywords: &["nəqliyyat", "stritkar", "trolleybus"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("трамвай"),
            keywords: &["рэйкі", "трамвай", "цягнік"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("трамвай"),
            keywords: &["превозно средство", "трамвай"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ট\u{9cd}র\u{9be}ম"),
            keywords: &[
                "ট\u{9cd}রলিব\u{9be}স",
                "ট\u{9cd}র\u{9be}ম",
                "য\u{9be}নব\u{9be}হন",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("tramgarr"),
            keywords: &["tramgarr", "trollebus"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("tramvaj"),
            keywords: &["tramvaj", "trolejbus", "vozilo"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("tramvia"),
            keywords: &["tramvia", "troleibús", "tròlei", "vehicle"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏗᎦᏣᏄᎵ ᎦᏚᎲ"),
            keywords: &["ᏗᎦᏣᏄᎵ ᎦᏚᎲ", "ᏴᏫ ᏗᏘᏂᏙ ᏙᎴᎳ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("tramvaj"),
            keywords: &["tramvaj", "vozidlo"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("tram"),
            keywords: &["bysys trydan", "tram"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("sporvogn"),
            keywords: &["køretøj", "sporvogn", "trolleybus"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Straßenbahn"),
            keywords: &["Straßenbahn", "Tram"],
        },
        #[cfg(feature = "de_CH")]
        crate::Annotation {
            lang: "de_CH",
            tts: Some("Strassenbahn"),
            keywords: &["Strassenbahn", "Tram"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("τραμ"),
            keywords: &["τραμ", "τρόλεϊ", "όχημα"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("tram"),
            keywords: &["tram", "trolleybus"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("oncoming light rail"),
            keywords: &[
                "light rail",
                "oncoming",
                "oncoming light rail",
                "tram",
                "trolleybus",
            ],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &[
                "car",
                "streetcar",
                "tram",
                "tramcar",
                "trolley",
                "trolley bus",
                "trolleybus",
            ],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("tranvía"),
            keywords: &["transporte", "tranvía", "trolebús"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["transporte", "tranvía"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["transporte", "tranvía", "tren ligero"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("tramm"),
            keywords: &["tramm", "troll"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("tranbia"),
            keywords: &["ibilgailu", "tranbia", "trolebus"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("تراموا"),
            keywords: &["اتوبوس برقی", "تراموا", "وسیله\u{654} نقلیه"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("raitioliikenne"),
            keywords: &["ajoneuvo", "raiteet", "raitioliikenne"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("tram"),
            keywords: &["sasakyan", "tram", "trambiya", "tren", "trolley"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("gron á sporvogni"),
            keywords: &["gron á sporvogni", "sporvognur", "tráðbussur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("tramway"),
            keywords: &["tramway", "transport"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["tram", "tramway", "trolley", "trolleybus"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("tram"),
            keywords: &["feithicil", "tram"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("trama"),
            keywords: &["bus-troilidh", "trama"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("tranvía"),
            keywords: &["tranvía"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ટ\u{acd}રામ"),
            keywords: &["ટ\u{acd}રામ", "વાહન"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("tram"),
            keywords: &["bas mai aiki da lantarki", "tram"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("חשמלית"),
            keywords: &["חשמלית", "רכבת", "תחבורה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ट\u{94d}राम"),
            keywords: &["ट\u{94d}राम", "वाहन"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("tramvaj"),
            keywords: &["tramvaj", "trolejbus", "vozilo"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("villamos"),
            keywords: &["jármű", "nagyvárosi közlekedés", "villamos"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("տրամվայ"),
            keywords: &["տրամվայ", "տրոլեյբուս", "փոխադրամիջոց"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("trem"),
            keywords: &["kendaraan", "kereta", "listrik", "trem"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("tramụ"),
            keywords: &["ogologo ụgbọala", "tramụ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("vagn"),
            keywords: &["farartæki", "sporvagn", "vagn"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("tram"),
            keywords: &["tram", "veicolo"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("路面電車正面"),
            keywords: &["乗り物", "路面電車", "路面電車正面", "電車"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("trem"),
            keywords: &["bis troli", "trem"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ტრამვაი"),
            keywords: &["ტრამვაი", "ტრანსპორტი", "ტროლეიბუსი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("трамвай"),
            keywords: &["көлік", "трамвай", "троллейбус"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("sporvogn"),
            keywords: &["køretøj", "sporvogn", "trolleybus"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some(
                "រថភ\u{17d2}លើងអគ\u{17d2}គ\u{17b7}សន\u{17b8}រថក\u{17d2}ន\u{17bb}ងក\u{17d2}រ\u{17bb}ង",
            ),
            keywords: &[
                "រថភ\u{17d2}លើង",
                "រថភ\u{17d2}លើងអគ\u{17d2}គ\u{17b7}សន\u{17b8}រថក\u{17d2}ន\u{17bb}ងក\u{17d2}រ\u{17bb}ង",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಟ\u{ccd}ರಾಮ\u{ccd}"),
            keywords: &["ಟ\u{ccd}ರಾಮ\u{ccd}", "ಟ\u{ccd}ರಾಲ\u{cbf}ಬಸ\u{ccd}", "ವಾಹನ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("트램"),
            keywords: &["전차", "트램"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("ट\u{94d}राम"),
            keywords: &["ट\u{94d}राम", "ट\u{94d}रॉलिबस"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("трамвай"),
            keywords: &["трамвай", "троллейбус", "унаа"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Tram"),
            keywords: &["Tram", "Trolleybus"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ລ\u{ebb}ດລາງ"),
            keywords: &["ພາຫະນະ", "ລ\u{ebb}ດລາງ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("tramvajus"),
            keywords: &["tramvajus", "troleibusas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("tramvajs"),
            keywords: &["tramvajs", "transports"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tarāme"),
            keywords: &["tarāme", "waka pāhiko"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("трамвај"),
            keywords: &["возило", "трамвај"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ട\u{d4d}ര\u{d3e}ം"),
            keywords: &["ട\u{d4d}ര\u{d3e}ം", "വ\u{d3e}ഹനം"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("трамвай"),
            keywords: &["машин", "трамвай"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("ट\u{94d}राम"),
            keywords: &["ट\u{94d}राम", "ट\u{94d}रॉलीबस"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("trem"),
            keywords: &["bas letrik", "kenderaan", "trem"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("tramm"),
            keywords: &["tramm", "trolleybus"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဓာတ\u{103a}ရထား"),
            keywords: &[
                "ထရော\u{103a}လ\u{102e}ဘတ\u{103a}စ\u{103a}",
                "ဓာတ\u{103a}ရထား",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("trikk"),
            keywords: &["fremkomstmiddel", "trikk"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("ट\u{94d}राम"),
            keywords: &["गाडी", "ट\u{94d}रलिबस", "ट\u{94d}राम"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("tram"),
            keywords: &["tram", "trolleybus"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("trikk"),
            keywords: &["framkomstmiddel", "trikk"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଟ\u{b4d}ର\u{b3e}ମ\u{b4d}"),
            keywords: &[
                "ଟ\u{b4d}ରଲ\u{b3f}ବସ\u{b4d}",
                "ଟ\u{b4d}ର\u{b3e}ମ\u{b4d}",
                "ବ\u{b3e}ହ\u{b3e}ନ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਟ\u{a4d}ਰ\u{a48}ਮ"),
            keywords: &["ਟ\u{a4d}ਰ\u{a48}ਮ", "ਵਾਹਨ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ٹرام"),
            keywords: &["بجلی نال چلن آلی بس", "ٹرام"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Tram"),
            keywords: &["Tram", "Trọlíbọs"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("tramwaj"),
            keywords: &["szynowy", "tramwaj", "trolejbus"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ټرام"),
            keywords: &["ټرالي بس", "ټرام"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("bonde elétrico"),
            keywords: &["bonde elétrico", "trólebus", "veículo"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("elétrico"),
            keywords: &["eléctrico", "elétrico"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("tranvia"),
            keywords: &["tranvia", "trolebus", "ñan"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("tramvai"),
            keywords: &["tramvai", "troleibuz"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-926"),
            keywords: &["E10-926"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("трамвай"),
            keywords: &["рельсы", "трамвай", "транспорт"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("taramu"),
            keywords: &["bisi ikoreshwa n’amashanyarazi", "taramu"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ٽرام"),
            keywords: &["ٽرالي بس", "ٽرام"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ට\u{dca}\u{200d}රෑම\u{dca}"),
            keywords: &[
                "ට\u{dca}\u{200d}රෑම\u{dca}",
                "ට\u{dca}\u{200d}රොල\u{dd2} බසය",
                "ව\u{dcf}හනය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("električka"),
            keywords: &["dopravný prostriedok", "električka"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("tramvaj"),
            keywords: &["tramvaj", "trolejbus", "vozilo"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("taraam"),
            keywords: &["baska ragaad", "taraam"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("tramvaj"),
            keywords: &["filobus", "mjet", "tramvaj"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("трамвај"),
            keywords: &["трoлejбус", "трамвај"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["трамвај"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("tramvaj"),
            keywords: &["tramvaj", "trolejbus"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["tramvaj"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("spårvagn"),
            keywords: &["fordon", "spårvagn"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("tramu"),
            keywords: &["basi la tramu", "mwendokasi", "tramu"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("டிர\u{bbe}ம\u{bcd}"),
            keywords: &["டிர\u{bbe}ம\u{bcd}", "டிர\u{bbe}ம\u{bcd} வண\u{bcd}டி"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ట\u{c4d}ర\u{c3e}మ\u{c4d}"),
            keywords: &[
                "ట\u{c4d}ర\u{c3e}మ\u{c4d}",
                "మందువ\u{c48}పు చూపుతున\u{c4d}న ట\u{c4d}ర\u{c3e}మ\u{c4d} క\u{c3e}రు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("трамвай"),
            keywords: &["трамвай", "троллейбус"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("รถรางบนราง"),
            keywords: &["ยานพาหนะ", "รถรางบนราง", "รถไฟ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("tramwaý"),
            keywords: &["tramwaý", "trolleýbus"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("talamu"),
            keywords: &["talamu"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("tramvay"),
            keywords: &["taşıt", "tramvay"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("تىرامۋاي"),
            keywords: &["تىراللىبۇس", "تىرامۋاي"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("трамвай"),
            keywords: &["трамвай", "транспорт", "тролейбус"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ٹرام"),
            keywords: &["سواری", "ٹرام"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("tramvay"),
            keywords: &["tramvay", "transport", "trolleybus"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("xe điện"),
            keywords: &["xe điện", "ô tô điện"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("tram"),
            keywords: &["tram", "trolleybus"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("utramu"),
            keywords: &["ibhasi yombane", "utramu"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Tiramu"),
            keywords: &["Tiramu", "Ọkọ Akero Oniwiwọ"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("電車"),
            keywords: &["有軌電車", "電車"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("电车"),
            keywords: &["有轨电车", "电车"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("路面电车"),
            keywords: &["电车", "路面电车"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("路面電車"),
            keywords: &["路面電車", "軌道電車"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("電車"),
            keywords: &["電動巴士", "電車"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ithilamu"),
            keywords: &["ibhasi", "imoto", "ithilamu"],
        },
    ],
};
#[doc = "🚝"]
pub const MONORAIL: crate::Emoji = crate::Emoji {
    glyph: "🚝",
    codepoint: "1F69D",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "monorail",
    group: "Travel & Places",
    subgroup: "transport-ground",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("enkelspoortrein"),
            keywords: &["enkelspoortrein", "spoor", "trein", "voertuig"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የባቡር መሄጃ ድልድይ"),
            keywords: &["ተሽከርካሪ", "የባቡር መሄጃ ድልድይ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("خط سكة حديد أحادي"),
            keywords: &["خط سكة حديد أحادي", "مركبة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ম’ন’ৰেইল"),
            keywords: &["ব\u{9be}হন", "ম’ন’ৰেইল"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("monorels"),
            keywords: &["monorels", "nəqliyyat"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("манарэйка"),
            keywords: &["манарэйка", "метро", "рэйкі"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("монорелсова железница"),
            keywords: &["монорелсова железница", "превозно средство"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("মোনোরেল"),
            keywords: &["মোনোরেল", "য\u{9be}নব\u{9be}হন"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("unroudenn"),
            keywords: &["karbed", "unroudenn"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("pruga s jednom tračnicom"),
            keywords: &["pruga s jednom tračnicom", "vozilo"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("monocarril"),
            keywords: &["monocarril", "vehicle"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏍᏌᏊ ᎦᏅᏅ ᏥᏴ"),
            keywords: &["ᏍᏌᏊ ᎦᏅᏅ ᏥᏴ", "ᏙᏆᎴᎵ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("jednokolejka"),
            keywords: &["jednokolejka", "vozidlo"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("trên un gledren"),
            keywords: &["cerbyd", "trên un gledren"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("monorail"),
            keywords: &["køretøj", "monorail"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Einschienenbahn"),
            keywords: &["Bahn", "Einschienenbahn", "Magnetschwebebahn"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("τρένο μονής τροχιάς"),
            keywords: &["τρένο μονής τροχιάς", "όχημα"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("monorail"),
            keywords: &["monorail", "vehicle"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("monorraíl"),
            keywords: &[
                "ferrocarril",
                "monocarril",
                "monorraíl",
                "transporte",
                "tren",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("monorriel"),
            keywords: &["monocarril", "monorriel", "transporte", "tren"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("üherööpmeline raudtee"),
            keywords: &["raudtee", "rong", "sõiduk", "üherööpmeline raudtee"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("monoraila"),
            keywords: &["ibilgailu", "monoraila"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("تک\u{200c}ریل"),
            keywords: &[
                "تک\u{200c}ریل",
                "راه\u{200c}آهن تک\u{200c}ریلی",
                "مونوریل",
                "وسیله\u{654} نقلیه",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("monorail"),
            keywords: &["ajoneuvo", "monorail", "raide", "yksiraidejuna"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("monorail"),
            keywords: &["monorail", "sasakyan", "tren"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("einsporað jarnbreyt"),
            keywords: &["einsporað jarnbreyt", "tok"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("monorail"),
            keywords: &["monorail", "véhicule"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("aonráille"),
            keywords: &["aonráille", "feithicil"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("aona-rèile"),
            keywords: &["aona-rèile", "carbad"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("monorraíl"),
            keywords: &["monorraíl"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("મોનોર\u{ac7}લ"),
            keywords: &["મોનોર\u{ac7}લ", "વાહન"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("reluwe guda"),
            keywords: &["mota", "reluwe guda"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("רכבת עילית"),
            keywords: &["עילית", "רכבת", "תחבורה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("मोनोर\u{947}ल"),
            keywords: &["मोनोर\u{947}ल", "वाहन"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("jednotračna željeznica"),
            keywords: &["jednotračna željeznica", "vozilo"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("egysínű vasút"),
            keywords: &["egysínű vasút", "jármű"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("մոնոռելս"),
            keywords: &["մոնոռելս", "փոխադրամիջոց"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("monorel"),
            keywords: &["kendaraan", "monorel"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("otù okporoigwe"),
            keywords: &["otù okporoigwe", "ụgbọala"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("einteinungur"),
            keywords: &["einteinungur", "lest"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("monorotaia"),
            keywords: &["monorotaia", "veicolo"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("モノレール"),
            keywords: &["モノレール", "乗り物", "電車"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("monoril"),
            keywords: &["monoril", "tetumpakan"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მონორელსი"),
            keywords: &["მონორელსი", "ტრანსპორტი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("дара рельсті темір жол"),
            keywords: &["дара рельсті темір жол", "көлік"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("monorail"),
            keywords: &["køretøj", "monorail"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("រថភ\u{17d2}លើងរថលើផ\u{17d2}ល\u{17bc}វតែម\u{17bd}យ"),
            keywords: &[
                "រថភ\u{17d2}លើង",
                "រថភ\u{17d2}លើងរថលើផ\u{17d2}ល\u{17bc}វតែម\u{17bd}យ",
                "រថភ\u{17d2}លើងលើផ\u{17d2}ល\u{17bc}វ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಮೋನೊರೈಲು"),
            keywords: &["ಮೋನೊರೈಲು", "ಮೋನೋರೈಲ\u{ccd}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("모노레일"),
            keywords: &["교통수단", "기차", "모노레일"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("मोनोर\u{947}ल"),
            keywords: &["मोनोर\u{947}ल", "वाहन"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("жалгыз рельс"),
            keywords: &["жалгыз рельс", "унаа"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Monorail"),
            keywords: &["Gefier", "Monorail"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ລ\u{ebb}ດໄຟລາງດຽວ"),
            keywords: &["ພາຫະນະ", "ລ\u{ebb}ດໄຟລາງດຽວ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("vienbėgis geležinkelis"),
            keywords: &["transporto priemonė", "vienbėgis geležinkelis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("viensliedes dzelzceļš"),
            keywords: &[
                "dzelzceļš",
                "transports",
                "viensliedes dzelzceļš",
                "vilciens",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("rōautahi"),
            keywords: &["rōautahi", "waka"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("едношинска железница"),
            keywords: &["возило", "едношинска железница", "железница"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("മോണോറെയിൽ"),
            keywords: &["മോണോറെയിൽ", "വ\u{d3e}ഹനം"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("дүүжин төмөр зам"),
            keywords: &["дүүжин", "дүүжин төмөр зам", "төмөр зам"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("मोनोर\u{947}ल"),
            keywords: &["मोनोर\u{947}ल", "वाहन"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("monorel"),
            keywords: &["kenderaan", "monorel"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("monorail"),
            keywords: &["monorail", "vettura"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("မ\u{102d}\u{102f}န\u{102d}\u{102f}ရထား"),
            keywords: &["မ\u{102d}\u{102f}န\u{102d}\u{102f}ရထား", "ယာဥ\u{103a}"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("monorail"),
            keywords: &["fremkomstmiddel", "monorail"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("मोनोर\u{947}ल"),
            keywords: &["गाडी", "मोनोर\u{947}ल"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("monorail"),
            keywords: &["monorail", "voertuig"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("monorail"),
            keywords: &["framkomstmiddel", "monorail"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ମୋନୋରେଲ\u{b4d}\u{200c}"),
            keywords: &[
                "ବ\u{b3e}ହ\u{b3e}ନ",
                "ମନୋରେଲ\u{b4d}\u{200c}",
                "ମୋନୋରେଲ\u{b4d}\u{200c}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਮ\u{a4b}ਨ\u{a4b}ਰ\u{a47}ਲ"),
            keywords: &["ਮ\u{a4b}ਨ\u{a4b}ਰ\u{a47}ਲ", "ਵਾਹਨ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("مونو ریل"),
            keywords: &["مونو ریل", "گڈی"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Mónórel"),
            keywords: &["Mónórel", "Móto"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("kolej jednoszynowa"),
            keywords: &["kolej", "kolej jednoszynowa", "pojazd", "szynowy"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("مونوریل"),
            keywords: &["مونوريل", "مونوریل", "ګاډی"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("monotrilho"),
            keywords: &["monotrilho", "veículo"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("monocarril"),
            keywords: &["monocarril", "veículo"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("monorrail"),
            keywords: &["carru", "monorrail"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("monorai"),
            keywords: &["monorai", "monoșină"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-945"),
            keywords: &["E10-945"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("монорельс"),
            keywords: &["легкое метро", "метро", "монорельс", "рельсы"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("gariyamoshi inyura ku muhanda umwe"),
            keywords: &["gariyamoshi inyura ku muhanda umwe", "imodoka"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("مونوريل"),
            keywords: &["مونوريل", "گاڏي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("මොනොරේල\u{dca}"),
            keywords: &["මොනොරේල\u{dca}", "ව\u{dcf}හනය"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("monorail"),
            keywords: &["dopravný prostriedok", "monorail"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("enotirna železnica"),
            keywords: &["enotirna železnica", "vozilo"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("hal jid tareen kor u qaadan"),
            keywords: &["gaari", "hal jid tareen kor u qaadan"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("hekurudhë me një shinë"),
            keywords: &["hekurudhë me një shinë", "mjet udhëtimi"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("монорејл"),
            keywords: &["вoзилo", "монорејл"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("monorejl"),
            keywords: &["monorejl", "vozilo"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("monorail"),
            keywords: &["balkbana", "fordon", "monorail", "tåg"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("reli moja"),
            keywords: &["gari", "reli moja"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("மோனோரயில\u{bcd}"),
            keywords: &["மோனோரயில\u{bcd}", "மோனோரயில\u{bcd} வண\u{bcd}டி"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ఒక\u{c47} ట\u{c4d}ర\u{c3e}క\u{c4d} ఉండ\u{c47} ర\u{c48}లు"),
            keywords: &[
                "ఒక\u{c47} ట\u{c4d}ర\u{c3e}క\u{c4d} ఉండ\u{c47} ర\u{c48}లు",
                "ట\u{c4d}ర\u{c3e}క\u{c4d}",
                "ర\u{c48}లు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("якрелса"),
            keywords: &["нақлиёт", "якрелса"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("รถไฟรางเด\u{e35}\u{e48}ยว"),
            keywords: &["ยานพาหนะ", "รถไฟรางเด\u{e35}\u{e48}ยว"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("monorels"),
            keywords: &["monorels", "ulag"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("lēlue poutaha"),
            keywords: &["lēlue poutaha"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("monoray"),
            keywords: &["monoray", "taşıt"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("بىررېلىس"),
            keywords: &["ئاپتوموبىل", "بىررېلىس"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("монорейка"),
            keywords: &["монорейка", "транспорт"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("مونو ریل"),
            keywords: &["ریل", "سواری", "مونو ریل"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("bir izli temiryo‘l"),
            keywords: &["bir izli temiryo‘l", "transport"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("đường một ray"),
            keywords: &["xe cộ", "đường một ray"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("monoraay"),
            keywords: &["monoraay", "waruwaay"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("isiporo esinenkasayiya enye"),
            keywords: &["inqwelo-mafutha", "isiporo esinenkasayiya enye"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Oju irin kan"),
            keywords: &["Oju irin kan", "nṣe ọkọ\u{301}"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("單軌"),
            keywords: &["單軌", "車輛"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("单轨"),
            keywords: &["单轨", "车辆"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("单轨"),
            keywords: &["单轨", "火车"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("單軌"),
            keywords: &["單軌", "火車"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("單軌電車"),
            keywords: &["單軌電車"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ujantshi owodwa"),
            keywords: &["imoto", "ujantshi owodwa"],
        },
    ],
};
#[doc = "🚞"]
pub const MOUNTAIN_RAILWAY: crate::Emoji = crate::Emoji {
    glyph: "🚞",
    codepoint: "1F69E",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "mountain railway",
    group: "Travel & Places",
    subgroup: "transport-ground",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("bergtreinspoor"),
            keywords: &["berg", "bergtreinspoor", "spoor", "trein", "voertuig"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የባቡር ሐዲድ ያለው ተራራ"),
            keywords: &["መኪና", "ተራራ", "ተሽከርካሪ", "የባቡር ሐዲድ ያለው ተራራ", "የባቡር መንገድ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("سكة حديد جبلية"),
            keywords: &[
                "جبل",
                "سكة حديد",
                "سكة حديد جبلية",
                "عربة قطار جبلي",
                "مركبة",
            ],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("প\u{9be}হ\u{9be}ৰৰ ৰেইলৱে"),
            keywords: &[
                "গ\u{9be}ড\u{9bc}ী",
                "প\u{9be}হ\u{9be}ৰ",
                "প\u{9be}হ\u{9be}ৰৰ ৰেইলৱে",
                "ৰেইলৱে",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("dağ yolu"),
            keywords: &["dağ", "dağ yolu", "dəmir yolu", "maşın", "nəqliyyat"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("чыгунка ў гарах"),
            keywords: &["гара", "рэйкі", "цягнік", "чыгунка", "чыгунка ў гарах"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("планинска железница"),
            keywords: &[
                "вагон",
                "железница",
                "планина",
                "планинска железница",
                "превозно средство",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("পর\u{9cd}বতের রেলওয\u{9bc}ে"),
            keywords: &[
                "পর\u{9cd}বত",
                "পর\u{9cd}বতের রেলওয\u{9bc}ে",
                "মোটরগ\u{9be}ড\u{9bc}ি",
                "য\u{9be}নব\u{9be}হন",
                "রেলওয\u{9bc}ে",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("tren ar menezioù"),
            keywords: &["hent-houarn", "tren ar menezioù"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("pruga kroz tunel"),
            keywords: &["planina", "pruga kroz tunel", "voz", "vozilo", "željeznica"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("ferrocarril de muntanya"),
            keywords: &["ferrocarril", "ferrocarril de muntanya", "muntanya"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎣᏓᎸ ᎦᏥᏄᎵ ᎤᎶᎯᏍᏗ"),
            keywords: &["ᎠᏥᎳ ᏅᏃᎯ", "ᎣᏓᎸ ᎦᏥᏄᎵ ᎤᎶᎯᏍᏗ", "ᏙᏆᎴᎵ", "ᏚᏅᏓᏢᎢ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("horská železnice"),
            keywords: &["hora", "horská železnice", "vagón", "vozidlo", "železnice"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("rheilffordd fynydd"),
            keywords: &["car", "mynydd", "rheilffordd", "rheilffordd fynydd"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("bjergbane"),
            keywords: &["bjergbane", "svævebane"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Bergbahn"),
            keywords: &["Bahn", "Bergbahn"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ορεινός σιδηρόδρομος"),
            keywords: &[
                "βαγόνι",
                "βουνό",
                "ορεινός σιδηρόδρομος",
                "σιδηρόδρομος",
                "όχημα",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("mountain railway"),
            keywords: &["car", "mountain", "railway"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("ferrocarril de montaña"),
            keywords: &[
                "ferrocarril",
                "ferrocarril de montaña",
                "montaña",
                "vehículo",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &[
                "ferrocarril",
                "ferrocarril de montaña",
                "montaña",
                "transporte",
                "tren",
                "viajar",
                "viaje",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &[
                "ferrocarril",
                "ferrocarril de montaña",
                "montaña",
                "transporte",
                "tren",
                "viajar",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &[
                "ferrocarril",
                "ferrocarril de montaña",
                "montaña",
                "transporte",
                "tren",
                "viajar",
            ],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("mägiraudtee"),
            keywords: &["mägi", "mägiraudtee", "raudtee", "rong", "vagun"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("mendiko trenbidea"),
            keywords: &[
                "auto",
                "ibilgailu",
                "mendi",
                "mendiko trenbidea",
                "trenbide",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("ریل کوهستانی"),
            keywords: &[
                "خودرو",
                "راه\u{200c}آهن",
                "ریل",
                "ریل کوهستانی",
                "وسیله\u{654} نقلیه",
                "کوه",
                "کوهستان",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("rinnerata"),
            keywords: &["ajoneuvo", "funikulaari", "juna", "rautatie", "rinnerata"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("mountain railway"),
            keywords: &["bundok", "mountain railway", "sasakyan", "tren"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("fjallajarnbreyt"),
            keywords: &["fjallajarnbreyt", "jarnbreyt", "tok"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("train de montagne"),
            keywords: &["train", "train de montagne"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &[
                "chemin de fer",
                "montagne",
                "train",
                "train de montagne",
                "voiture",
                "wagon",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("iarnród sléibhe"),
            keywords: &[
                "carr",
                "carr cábla sléibhe",
                "feithicil",
                "iarnród",
                "iarnród sléibhe",
                "sliabh",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("rèile-bheinne"),
            keywords: &[
                "beinn",
                "càr",
                "còidse",
                "rathad-iarainn",
                "rèile",
                "rèile-bheinne",
                "slighe-iarainn",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("ferrocarril de montaña"),
            keywords: &["ferrocarril", "ferrocarril de montaña"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("પર\u{acd}વતોની ર\u{ac7}લ\u{acd}વ\u{ac7}"),
            keywords: &[
                "કાર",
                "પર\u{acd}વત",
                "પર\u{acd}વતોની ક\u{ac5}બલ કાર",
                "પર\u{acd}વતોની ર\u{ac7}લ\u{acd}વ\u{ac7}",
                "ર\u{ac7}લ\u{acd}વ\u{ac7}",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("reluwen tsauni"),
            keywords: &["reluwe", "reluwen tsauni", "tsauni", "ƙaramar mota"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("רכבת בהרים"),
            keywords: &["הרים", "רכבת", "רכבת בהרים", "תחבורה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("माउ\u{902}ट\u{947}न र\u{947}लव\u{947}"),
            keywords: &[
                "कार",
                "पहाड\u{93c}ी क\u{947}बल कार",
                "पहाड\u{93c}ी र\u{947}लव\u{947}",
                "माउ\u{902}ट\u{947}न र\u{947}लव\u{947}",
                "वाहन",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("planinska željeznica"),
            keywords: &[
                "planina",
                "planinska željeznica",
                "vagon",
                "vozilo",
                "željeznica",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("hegyi vasút"),
            keywords: &["hegyi vasút", "jármű", "kocsi"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("լեռնային երկաթուղի"),
            keywords: &[
                "երկաթուղի",
                "լեռ",
                "լեռնային երկաթուղի",
                "վագոն",
                "փոխադրամիջոց",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("jalur kereta pegunungan"),
            keywords: &[
                "gunung",
                "jalur kereta pegunungan",
                "kendaraan",
                "mobil",
                "rel",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ugwu okporoigwe"),
            keywords: &["okporoigwe", "ugwu", "ụgbọala"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("fjallalest"),
            keywords: &["fjall", "fjallakláfur", "fjallalest", "kláfur", "lest"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("ferrovia di montagna"),
            keywords: &["ferrovia di montagna", "veicolo"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("登山鉄道"),
            keywords: &["乗り物", "登山鉄道", "登山電車", "電車"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("jalur sepur nggunung"),
            keywords: &["gunung", "jalur ril", "jalur sepur nggunung", "montor"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მთის რკინიგზა"),
            keywords: &["მანქანა", "მთა", "მთის რკინიგზა", "რკინიგზა", "ტრანსპორტი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("таулы аймақтағы темір жол"),
            keywords: &[
                "автокөлік",
                "көлік",
                "тау",
                "таулы аймақтағы темір жол",
                "темір жол",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("bjergbane"),
            keywords: &["bjergbane", "svævebane"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ផ\u{17d2}ល\u{17bc}វរថភ\u{17d2}លើងលើភ\u{17d2}ន\u{17c6}"),
            keywords: &[
                "ទ\u{17bc}រថភ\u{17d2}លើង",
                "ផ\u{17d2}ល\u{17bc}វរថភ\u{17d2}លើង",
                "ផ\u{17d2}ល\u{17bc}វរថភ\u{17d2}លើងលើភ\u{17d2}ន\u{17c6}",
                "ភ\u{17d2}ន\u{17c6}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಪರ\u{ccd}ವತ ರೈಲುಮಾರ\u{ccd}ಗ"),
            keywords: &[
                "ಪರ\u{ccd}ವತ ಕೇಬಲ\u{ccd} ಕಾರ\u{ccd}",
                "ಪರ\u{ccd}ವತ ರೈಲುಮಾರ\u{ccd}ಗ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("기차 터널"),
            keywords: &["기차", "산터널", "터널"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("पर\u{94d}वतीय र\u{947}ल\u{94d}व\u{947}"),
            keywords: &[
                "कार",
                "पर\u{94d}वत",
                "पर\u{94d}वतीय र\u{947}ल\u{94d}व\u{947}",
                "र\u{947}ल\u{94d}व\u{947}",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("тоодогу темир жол"),
            keywords: &["вагон", "темир жол", "тоо", "тоодогу темир жол", "унаа"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Biergzuch"),
            keywords: &["Bierg", "Biergzuch", "Eisebunn", "Waggon"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ລາງລ\u{ebb}ດໄຟພ\u{eb9}ເຂ\u{ebb}າ"),
            keywords: &["ພາຫະນະ", "ລາງລ\u{ebb}ດໄຟພ\u{eb9}ເຂ\u{ebb}າ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("kalnų traukinys"),
            keywords: &["automobilis", "geležinkelis", "kalnas", "kalnų traukinys"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("kalnu dzelzceļš"),
            keywords: &[
                "dzelzceļš",
                "kalni",
                "kalnu dzelzceļš",
                "transports",
                "vagons",
                "vilciens",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("rerewē maunga"),
            keywords: &["maunga", "rerewē", "waka"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("планинска железница"),
            keywords: &[
                "вагон",
                "возило",
                "железница",
                "планина",
                "планинска железница",
            ],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("പർവ\u{d4d}വത റെയിൽവേ"),
            keywords: &[
                "ക\u{d3e}ർ",
                "പർവ\u{d4d}വത കേബിൾ ക\u{d3e}ർ",
                "പർവ\u{d4d}വത റെയിൽവേ",
                "പർവ\u{d4d}വതം",
                "റെയിൽവേ",
                "വ\u{d3e}ഹനം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("уулын төмөр зам"),
            keywords: &["машин", "төмөр зам", "уул", "уулын төмөр зам"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("पर\u{94d}वतावरील र\u{947}ल\u{94d}व\u{947}"),
            keywords: &[
                "कार",
                "डो\u{902}गर",
                "डो\u{902}गरावरील र\u{947}ल\u{94d}व\u{947}",
                "पर\u{94d}वतावरील र\u{947}ल\u{94d}व\u{947}",
                "र\u{947}ल\u{94d}व\u{947}",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("kereta api gunung"),
            keywords: &[
                "gunung",
                "kenderaan",
                "kereta",
                "kereta api gunung",
                "rel kereta api",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("ferrovija tal-muntanji"),
            keywords: &["ferrovija", "ferrovija tal-muntanji", "karozza", "muntanja"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("တောင\u{103a}ပေါ\u{103a} ရထားလမ\u{103a}း"),
            keywords: &[
                "တောင\u{103a}တန\u{103a}း",
                "တောင\u{103a}ပေါ\u{103a} ရထားလမ\u{103a}း",
                "ရထားတ\u{103d}\u{1032}",
                "ရထားလမ\u{103a}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("fjellbane"),
            keywords: &["bane", "fjell", "fjellbane", "fremkomstmiddel"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("पर\u{94d}वतीय र\u{947}लव\u{947}"),
            keywords: &["कार", "गाडी", "पर\u{94d}वतीय", "र\u{947}लव\u{947}"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("bergspoor"),
            keywords: &["berg", "bergspoor", "spoor", "wagon"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("fjellbane"),
            keywords: &["bane", "fjell", "fjellbane", "framkomstmiddel"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ପର\u{b4d}ବତ ରେଳୱେ"),
            keywords: &[
                "କ\u{b3e}ର\u{b4d}",
                "ପର\u{b4d}ବତ ରେଳୱେ",
                "ବ\u{b3e}ହ\u{b3e}ନ",
                "ମ\u{b3e}ଉଣ\u{b4d}ଟେନ\u{b4d}",
                "ମ\u{b3e}ଉଣ\u{b4d}ଟେନ\u{b4d} କେବଲ\u{b4d} କ\u{b3e}ର\u{b4d}",
                "ରେଲୱେ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਪਹਾੜੀ ਰ\u{a47}ਲਵ\u{a47}"),
            keywords: &[
                "ਕਾਰ",
                "ਪਹਾੜ",
                "ਪਹਾੜੀ ਕ\u{a47}ਬਲ ਕਾਰ",
                "ਪਹਾੜੀ ਰ\u{a47}ਲਵ\u{a47}",
                "ਰ\u{a47}ਲਵ\u{a47}",
                "ਵਾਹਨ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("پہاڑی ریلوے"),
            keywords: &["ریلوے", "پہاڑ", "پہاڑی ریلوے", "کار"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Maúntín Relwè"),
            keywords: &["Kaa", "Maúntin", "Maúntín Relwè", "Móto", "Relwè"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("kolej górska"),
            keywords: &["górski", "kolej", "kolej górska", "pojazd", "wagon"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د غره پټلۍ"),
            keywords: &["د غره پټلۍ", "ريلوی", "غر", "موټر"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("estrada de ferro na montanha"),
            keywords: &[
                "carro",
                "estrada de ferro",
                "estrada de ferro na montanha",
                "montanha",
                "teleférico",
                "veículo",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("comboio de montanha"),
            keywords: &[
                "comboio de montanha",
                "linha ferroviária",
                "montanha",
                "transporte",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("ferrocarril urqupaq"),
            keywords: &["autu", "ferrocarril", "ferrocarril urqupaq", "urqu"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("cale ferată montană"),
            keywords: &["cale ferată", "cale ferată montană", "munte"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-946"),
            keywords: &["E10-946"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("поезд в горах"),
            keywords: &[
                "горы",
                "железная дорога",
                "поезд",
                "поезд в горах",
                "транспорт",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("gariyamoshi inyura mu misozi"),
            keywords: &["gariyamoshi inyura mu misozi", "imodoka"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("جابلو ريلوي"),
            keywords: &["جابلو ريلوي", "جبل", "ريلوي", "ڪار"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("කඳ\u{dd4} ද\u{dd4}ම\u{dca}ර\u{dd2}ය"),
            keywords: &[
                "කන\u{dca}ද",
                "කඳ\u{dd4} ද\u{dd4}ම\u{dca}ර\u{dd2}ය",
                "ද\u{dd4}ම\u{dca}ර\u{dd2}ය ම\u{dcf}ර\u{dca}ගය",
                "මෝටර\u{dca} රථය",
                "ව\u{dcf}හනය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("zubačka"),
            keywords: &[
                "dopravný prostriedok",
                "horská",
                "vozeň",
                "zubačka",
                "železnica",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("gorska železnica"),
            keywords: &["avto", "gora", "gorska železnica", "vozilo", "železnica"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("jidka tareenka buurta"),
            keywords: &["buur", "gaari", "jidka tareenka", "jidka tareenka buurta"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("hekurudhë në mal"),
            keywords: &["hekurudhë", "hekurudhë në mal", "makinë", "mal", "mjet"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("планинска железница"),
            keywords: &["возило", "железница", "планина", "планинска железница"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("планинска жељезница"),
            keywords: &["планинска жељезница"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("planinska železnica"),
            keywords: &["planina", "planinska železnica", "vozilo", "železnica"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("planinska željeznica"),
            keywords: &["planinska željeznica"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("bergbana"),
            keywords: &["bergbana", "bergsbana", "bergståg", "järnväg"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("reli ya milimani"),
            keywords: &["gari", "mlima", "reli", "reli ya milimani"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("மலைப\u{bcd} ப\u{bbe}தை ரயில\u{bcd}"),
            keywords: &["மலை ரயில\u{bcd}", "மலைப\u{bcd} ப\u{bbe}தை ரயில\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some(
                "పర\u{c4d}వత\u{c3e}ల\u{c4d}ల\u{c4b} ప\u{c4d}రయ\u{c3e}ణ\u{c3f}ంచ\u{c47} ర\u{c48}లు",
            ),
            keywords: &[
                "పర\u{c4d}వతం",
                "పర\u{c4d}వత\u{c3e}ల\u{c4d}ల\u{c4b} ప\u{c4d}రయ\u{c3e}ణ\u{c3f}ంచ\u{c47} ర\u{c48}లు",
                "ర\u{c48}లు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("роҳи оҳани куҳӣ"),
            keywords: &["куҳ", "мошин", "роҳи оҳан", "роҳи оҳани куҳӣ"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("รางรถไฟภ\u{e39}เขา"),
            keywords: &[
                "ภ\u{e39}เขา",
                "ยานพาหนะ",
                "รถ",
                "รถราง",
                "รางรถไฟภ\u{e39}เขา",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("dag demirýoly"),
            keywords: &["dag", "dag demirýoly", "demir ýol", "wagon"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("hala lēlue moʻunga"),
            keywords: &["hala lēlue moʻunga"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("dağ demiryolu"),
            keywords: &["dağ", "dağ teleferiği", "demiryolu", "taşıt", "vagon"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("تاغ تۆمۈريولى"),
            keywords: &["تاغ", "تاغ تۆمۈريولى", "تۆمۈر يول", "ماشىنا"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("залізниця в горах"),
            keywords: &[
                "вагон",
                "гора",
                "залізниця",
                "залізниця в горах",
                "транспорт",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ماؤنٹین ریلوے"),
            keywords: &["ریلوے", "ماؤنٹین ریلوے", "پہاڑ", "گاڑی"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("to‘g‘ temiryo‘li"),
            keywords: &[
                "mashina",
                "temiryo‘l",
                "tog‘",
                "to‘g‘ temiryo‘li",
                "transport",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("đường ray leo núi"),
            keywords: &["núi", "toa xe", "đường ray leo núi", "đường sắt"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("raayu tund"),
            keywords: &["montaañ", "oto", "raay", "raayu tund"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("isiporo sentaba"),
            keywords: &["imoto", "intaba", "isiporo", "isiporo sentaba"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Reluwe Oloke"),
            keywords: &["Reluwe Oloke", "òké", "ọkọ ojú-irin", "ọkọ\u{300}"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("山上鐵路"),
            keywords: &["山", "山上鐵路", "汽車", "鐵路"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("山上铁路"),
            keywords: &["山", "山上铁路", "汽车", "铁路"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("山区铁路"),
            keywords: &["山区", "山区铁路", "火车", "铁路"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("山區鐵路"),
            keywords: &["山區鐵路", "火車"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("上山鐵路"),
            keywords: &["上山鐵路", "火車"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ujantshi wasentabeni"),
            keywords: &["imoto", "intaba", "ujantshi", "ujantshi wasentabeni"],
        },
    ],
};
#[doc = "🚋"]
pub const TRAM_CAR: crate::Emoji = crate::Emoji {
    glyph: "🚋",
    codepoint: "1F68B",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "tram car",
    group: "Travel & Places",
    subgroup: "transport-ground",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("tremwa"),
            keywords: &["elektries", "trem", "tremwa", "voertuig", "wa"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የባቡር መሰል አውቶቡስ ፉርጎ"),
            keywords: &[
                "መኪና",
                "ባቡር መሰል አውቶቡስ",
                "ተሽከርካሪ",
                "ተጎታች",
                "የባቡር መሰል አውቶቡስ ፉርጎ",
            ],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("سيارة ترام"),
            keywords: &["ترام", "سيارة", "مركبة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ট\u{9cd}ৰ\u{9be}ম গ\u{9be}ড\u{9bc}ী"),
            keywords: &[
                "গ\u{9be}ড\u{9bc}ী",
                "ট\u{9cd}ৰ\u{9be}ম",
                "ট\u{9cd}ৰ’লীব\u{9be}ছ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("tramvay vaqonu"),
            keywords: &["avtomobil", "tramvay", "tramvay vaqonu", "trolleybus"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("трамвайны вагон"),
            keywords: &["вагон", "рэйкі", "трамвай", "трамвайны вагон"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("трамваен вагон"),
            keywords: &["вагон", "превозно средство", "трамваен вагон", "трамвай"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ট\u{9cd}র\u{9be}ম গ\u{9be}ড\u{9bc}ি"),
            keywords: &[
                "ট\u{9cd}রলিব\u{9be}স",
                "ট\u{9cd}র\u{9be}ম",
                "ট\u{9cd}র\u{9be}ম গ\u{9be}ড\u{9bc}ি",
                "মোটরগ\u{9be}ড\u{9bc}ি",
                "য\u{9be}নব\u{9be}হন",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("bagon tramgarr"),
            keywords: &["bagon tramgarr", "tramgarr", "trollebus"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("tramvajska kola"),
            keywords: &[
                "pruga",
                "tramvajska kola",
                "trolejbus",
                "vozilo",
                "željeznica",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("vagó de tramvia"),
            keywords: &["tramvia", "vagó", "vagó de tramvia"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏙᏆᎴᎳ ᏴᏫ ᏗᏘᏂᏙᎯ"),
            keywords: &["ᎤᎾᏦᏙᏗ", "ᏙᏆᎴᎳ ᏴᏫ ᏗᏘᏂᏙᎯ", "ᏙᏆᎴᎵ", "ᏴᏫ ᏗᏘᏂᏙ ᏙᎴᎳ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("vagón tramvaje"),
            keywords: &["tramvaj", "vagón", "vagón tramvaje", "vozidlo"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("car tram"),
            keywords: &["bysys trydan", "car", "tram"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("vogn"),
            keywords: &["køretøj", "sporvogn", "trolleybus", "vogn"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Straßenbahnwagen"),
            keywords: &[
                "Straßenbahn",
                "Straßenbahnwagen",
                "Tram",
                "Tramwagen",
                "Waggon",
            ],
        },
        #[cfg(feature = "de_CH")]
        crate::Annotation {
            lang: "de_CH",
            tts: Some("Tramwagen"),
            keywords: &["Tramwagen"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("βαγόνι τραμ"),
            keywords: &["βαγόνι", "τραμ", "τρόλεϊ", "όχημα"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("tram car"),
            keywords: &["car", "tram", "trolleybus"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("tram car"),
            keywords: &["car", "tram", "trolley bus"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("streetcar"),
            keywords: &[
                "car",
                "streetcar",
                "tram",
                "tramcar",
                "trolley",
                "trolley bus",
                "trolleybus",
            ],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("vagón de tranvía"),
            keywords: &["tranvía", "vagón", "vagón de tranvía", "vehículo"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["transporte", "tranvía", "vagón", "vagón de tranvía"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("trammivagun"),
            keywords: &["tramm", "trammivagun", "troll", "vagun"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("tranbiaren bagoi"),
            keywords: &[
                "auto",
                "ibilgailu",
                "tranbia",
                "tranbiaren bagoi",
                "trolebus",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("قطار خیابانی"),
            keywords: &[
                "تراموا",
                "خودرو",
                "قطار خیابانی",
                "واگن",
                "وسیله\u{654} نقلیه",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("raitiovaunu"),
            keywords: &["ajoneuvo", "raiteet", "raitiovaunu", "ratikka"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("tram car"),
            keywords: &["sasakyan", "tram car", "trambiya", "tren", "trolley"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("sporvognur"),
            keywords: &["sporvognur", "tráðbussur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("wagon de tramway"),
            keywords: &["tram", "trolleybus", "voiture", "wagon de tramway"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &[
                "tram",
                "trolley",
                "trolleybus",
                "voiture",
                "wagon de tramway",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("carráiste tram"),
            keywords: &["carr", "carráiste tram", "feithicil", "tram"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("còidse trama"),
            keywords: &["bus-troilidh", "càr", "còidse", "trama"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("vagón de tranvía"),
            keywords: &["tranvía", "vagón", "vagón de tranvía"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ટ\u{acd}રામ કાર"),
            keywords: &["કાર", "ટ\u{acd}રામ", "વાહન"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("ƙaramar motar tram"),
            keywords: &[
                "bas mai aiki da lantarki",
                "tram",
                "ƙaramar mota",
                "ƙaramar motar tram",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("קרון חשמלית"),
            keywords: &["חשמלית", "קרון", "רכבת", "תחבורה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ट\u{94d}राम कार"),
            keywords: &["कार", "ट\u{94d}राम", "वाहन"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("tramvajska kola"),
            keywords: &["tramvaj", "tramvajska kola", "trolejbus", "vagon", "vozilo"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("villamoskocsi"),
            keywords: &["jármű", "kocsi", "villamos", "villamoskocsi"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("տրամվայի վագոն"),
            keywords: &[
                "վագոն",
                "տրամվայ",
                "տրամվայի վագոն",
                "տրոլեյբուս",
                "փոխադրամիջոց",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("gerbong trem"),
            keywords: &["gerbong trem", "kendaraan", "kereta", "mobil", "trem"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ụgbọala ogologo tramụ"),
            keywords: &[
                "ogologo ụgbọala",
                "tramụ",
                "ụgbọala",
                "ụgbọala ogologo tramụ",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("sporvagn"),
            keywords: &["farartæki", "sporvagn", "vagn"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("vagone del tram"),
            keywords: &["tram", "vagone", "vagone del tram", "veicolo"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("路面電車"),
            keywords: &["乗り物", "路面電車", "電車"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("montor trem"),
            keywords: &["bis troli", "montor", "trem"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ტრამვაის ვაგონი"),
            keywords: &[
                "მანქანა",
                "ტრამვაი",
                "ტრამვაის ვაგონი",
                "ტრანსპორტი",
                "ტროლეიბუსი",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("трамвай вагоны"),
            keywords: &[
                "автокөлік",
                "көлік",
                "трамвай",
                "трамвай вагоны",
                "троллейбус",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("vogn"),
            keywords: &["køretøj", "sporvogn", "trolleybus", "vogn"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some(
                "រថយន\u{17d2}តក\u{17d2}រ\u{17bb}ងអគ\u{17d2}គ\u{17b7}សន\u{17b8}បើកលើផ\u{17d2}ល\u{17bc}វក\u{17c6}ណត\u{17cb}",
            ),
            keywords: &[
                "ទ\u{17bc}រថភ\u{17d2}លើង",
                "រថភ\u{17d2}លើងអគ\u{17d2}គ\u{17b7}សន\u{17b8}",
                "រថយន\u{17d2}តក\u{17d2}រ\u{17bb}ងអគ\u{17d2}គ\u{17b7}សន\u{17b8}",
                "រថយន\u{17d2}តក\u{17d2}រ\u{17bb}ងអគ\u{17d2}គ\u{17b7}សន\u{17b8}បើកលើផ\u{17d2}ល\u{17bc}វក\u{17c6}ណត\u{17cb}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಟ\u{ccd}ರಾಮ\u{ccd} ಬೋಗ\u{cbf}"),
            keywords: &[
                "ಟ\u{ccd}ರಾಮ\u{ccd}",
                "ಟ\u{ccd}ರಾಮ\u{ccd} ಕಾರು",
                "ಟ\u{ccd}ರಾಮ\u{ccd} ಬೋಗ\u{cbf}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("트램 차량"),
            keywords: &["전차 차량", "트램 차량"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("ट\u{94d}रॉम कार"),
            keywords: &["कार", "ट\u{94d}रॉम", "ट\u{94d}रॉलिबस"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("трамвай вагону"),
            keywords: &["вагон", "трамвай", "трамвай вагону", "троллейбус", "унаа"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Tramwaggon"),
            keywords: &["Tram", "Tramwaggon", "Trolleybus", "Waggon"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຕ\u{eb9}\u{ec9}ລ\u{ebb}ດລາງ"),
            keywords: &["ຕ\u{eb9}\u{ec9}ລ\u{ebb}ດລາງ", "ພາຫະນະ", "ລ\u{ebb}ດລາງ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("tramvajaus vagonas"),
            keywords: &[
                "automobilis",
                "tramvajaus vagonas",
                "tramvajus",
                "troleibusas",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("tramvaja vagons"),
            keywords: &["tramvaja vagons", "tramvajs", "transports", "vagons"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("waka tarāme"),
            keywords: &["tarāme", "waka", "waka pāhiko"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("вагон на трамвај"),
            keywords: &["вагон", "вагон на трамвај", "возило", "трамвај"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ട\u{d4d}ര\u{d3e}ം ക\u{d3e}ർ"),
            keywords: &["ക\u{d3e}ർ", "ട\u{d4d}ര\u{d3e}ം", "വ\u{d3e}ഹനം"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("трамвай машин"),
            keywords: &["машин", "трамвай", "троллейбус"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("ट\u{94d}रामचा डबा"),
            keywords: &["कार", "ट\u{94d}राम", "ट\u{94d}रामचा डबा", "ट\u{94d}रॉलीकार"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("gerabak trem"),
            keywords: &["bas letrik", "gerabak trem", "kenderaan", "kereta", "trem"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("karozza tat-tramm"),
            keywords: &["karozza tat-tramm", "karozzi", "tramm", "trolleybus"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဓာတ\u{103a}ရထားတ\u{103d}\u{1032}"),
            keywords: &[
                "ထရော\u{103a}လ\u{102e}ဘတ\u{103a}စ\u{103a}",
                "ဓာတ\u{103a}ရထား",
                "ဓာတ\u{103a}ရထားတ\u{103d}\u{1032}",
                "ရထားတ\u{103d}\u{1032}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("trikkevogn"),
            keywords: &["fremkomstmiddel", "trikk", "trikkevogn", "vogn"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("ट\u{94d}राम कार"),
            keywords: &["कार", "गाडी", "ट\u{94d}रलिबस", "ट\u{94d}राम"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("tramwagon"),
            keywords: &["tram", "tramwagon", "trolleybus", "wagon"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("trikkevogn"),
            keywords: &["framkomstmiddel", "trikk", "trikkevogn", "vogn"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଟ\u{b4d}ର\u{b3e}ମ\u{b4d}\u{200c} କ\u{b3e}ର\u{b4d}\u{200c}"),
            keywords: &[
                "କ\u{b3e}ର\u{b4d}",
                "ଟ\u{b4d}ରଲ\u{b3f}ବସ\u{b4d}",
                "ଟ\u{b4d}ର\u{b3e}ମ\u{b4d}",
                "ବ\u{b3e}ହ\u{b3e}ନ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਟ\u{a4d}ਰ\u{a48}\u{a48}ਮ ਕਾਰ"),
            keywords: &[
                "ਕਾਰ",
                "ਟ\u{a4d}ਰ\u{a48}ਮ",
                "ਟ\u{a4d}ਰ\u{a48}\u{a48}ਮ ਕਾਰ",
                "ਵਾਹਨ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ٹرام کار"),
            keywords: &["بجلی نال چلن آلی بس", "ٹرام", "کار"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Trám Kaa"),
            keywords: &["Kaa", "Móto", "Trám Kaa", "Trọ\u{301}líbọs"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("wagon tramwajowy"),
            keywords: &[
                "pojazd",
                "szynowy",
                "tramwaj",
                "trolejbus",
                "wagon",
                "wagon tramwajowy",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ټرام موټر"),
            keywords: &["موټر", "ټرالي بس", "ټرام"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("bonde"),
            keywords: &["bonde", "bonde elétrico", "carro", "trólebus", "veículo"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("carro elétrico"),
            keywords: &["carro", "elétrico"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("vagon tranviapaq"),
            keywords: &["carru", "trolebus", "vagon tranviapaq", "ñan"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("vagon de tramvai"),
            keywords: &["tramvai", "troleibuz", "vagon", "vagon de tramvai"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-927"),
            keywords: &["E10-927"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("трамвайный вагон"),
            keywords: &[
                "вагон",
                "рельсы",
                "трамвай",
                "трамвайный вагон",
                "электричество",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("gariyamoshi ya taramu"),
            keywords: &[
                "gari ya moshi ikoresha amashanyarazi",
                "gari ya moshi ikoresha mashanyarazi",
                "gariyamoshi ya taramu",
                "imodoka",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ٽرام ڪار"),
            keywords: &["ٽرالي بس", "ٽرام", "ڪار"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ට\u{dca}\u{200d}රෑම\u{dca} ක\u{dcf}ර\u{dca}"),
            keywords: &[
                "ට\u{dca}\u{200d}රෑම\u{dca}",
                "ට\u{dca}\u{200d}රෑම\u{dca} ක\u{dcf}ර\u{dca}",
                "ට\u{dca}\u{200d}රොල\u{dd2} බසය",
                "මෝටර\u{dca} රථය",
                "ව\u{dcf}හනය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("vozeň električky"),
            keywords: &[
                "dopravný prostriedok",
                "električka",
                "trolejbus",
                "vozeň",
                "vozeň električky",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("vagon tramvaja"),
            keywords: &["tramvaj", "trolejbus", "vagon", "vagon tramvaja", "vozilo"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("gaariga taraam"),
            keywords: &["baska ragaad", "gaari", "gaariga taraam", "taraam"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("vagon tramvaji"),
            keywords: &["filobus", "makinë", "mjet", "tramvaj", "vagon tramvaji"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("вагон трамваја"),
            keywords: &["вагон трамваја", "возило", "трамвај", "тролејбус"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["вагон трамваја"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("vagon tramvaja"),
            keywords: &["tramvaj", "trolejbus", "vagon tramvaja", "vozilo"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["vagon tramvaja"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("spårvagnsvagn"),
            keywords: &["fordon", "spårvagn", "spårvagnsvagn"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("gari la tramu"),
            keywords: &["basi la tramu", "gari", "gari la tramu", "tramu"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("டிர\u{bbe}ம\u{bcd} க\u{bbe}ர\u{bcd}"),
            keywords: &[
                "டிர\u{bbe}ம\u{bcd}",
                "டிர\u{bbe}ம\u{bcd} க\u{bbe}ர\u{bcd}",
                "டிர\u{bbe}ம\u{bcd} வ\u{bbe}கனம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ట\u{c4d}ర\u{c3e}మ\u{c4d} వ\u{c3e}హనం"),
            keywords: &["ట\u{c4d}ర\u{c3e}మ\u{c4d}", "వ\u{c3e}హనం"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("вагони трамвай"),
            keywords: &["вагони трамвай", "мошин", "трамвай", "троллейбус"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ต\u{e39}\u{e49}รถราง"),
            keywords: &["ต\u{e39}\u{e49}รถราง", "ยานพาหนะ", "รถ", "รถราง"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("tramwaý wagony"),
            keywords: &["tramwaý", "tramwaý wagony", "trolleýbus", "wagon"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("sāliote talamu"),
            keywords: &["sāliote talamu"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("tramvay vagonu"),
            keywords: &["taşıt", "tramvay", "tramvay vagonu", "vagon"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("تىرامۋاي ماشىنا"),
            keywords: &["تىراللىبۇس", "تىرامۋاي", "ماشىنا"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("вагон трамвая"),
            keywords: &[
                "вагон",
                "вагон трамвая",
                "трамвай",
                "транспорт",
                "тролейбус",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ٹرام کار"),
            keywords: &["ٹرالی بس", "ٹرام", "ٹرام کار", "گاڑی"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("tramvay vagoni"),
            keywords: &[
                "mashina",
                "tramvay",
                "tramvay vagoni",
                "transport",
                "trolleybus",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("tàu điện"),
            keywords: &["toa xe", "tàu điện", "xe điện", "ô tô điện"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("oto tramweey"),
            keywords: &["oto", "oto tramweey", "tram", "trolleybus"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("imoto katramu"),
            keywords: &["ibhasi yombane", "imoto", "imoto katramu", "utramu"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ọkọ Tiramu"),
            keywords: &[
                "Ọkọ Tiramu",
                "ọkọ\u{300}",
                "ọkọ\u{300} akérò oníwíwọ\u{301}",
                "ọkọ\u{300} ojú irin gígùn",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("有軌電車"),
            keywords: &["有軌電車", "汽車", "電車"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("有轨电车"),
            keywords: &["有轨电车", "汽车", "电车"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("有轨电车"),
            keywords: &["有轨电车"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("電纜車"),
            keywords: &["電纜車", "電車"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["纜車", "電纜車", "電車"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("imoto eyithilamu"),
            keywords: &["imoto", "imoto eyithilamu", "ithilamu"],
        },
    ],
};
#[doc = "🚌"]
pub const BUS: crate::Emoji = crate::Emoji {
    glyph: "🚌",
    codepoint: "1F68C",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "bus",
    group: "Travel & Places",
    subgroup: "transport-ground",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("bus"),
            keywords: &["bus", "voertuig"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("አውቶቡስ"),
            keywords: &["ተሽከርካሪ", "አውቶቡስ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("\u{202b}حافلة"),
            keywords: &["مركبة", "\u{202b}حافلة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ব\u{9be}ছ"),
            keywords: &["ব\u{9be}ছ", "ব\u{9be}হন"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("avtobus"),
            keywords: &["avtobus", "nəqliyyat"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("аўтобус"),
            keywords: &["аўтобус", "транспарт"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("автобус"),
            keywords: &["автобус", "превозно средство"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ব\u{9be}স"),
            keywords: &["ব\u{9be}স", "য\u{9be}নব\u{9be}হন"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("bus"),
            keywords: &["bus", "karbed"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("autobus"),
            keywords: &["autobus", "vozilo"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("autobús"),
            keywords: &["autobús", "bus", "vehicle"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏗᎾᏕᎶᏆᏍᎩ ᎤᎾᏦᏙᏗ"),
            keywords: &["ᏗᎾᏕᎶᏆᏍᎩ ᎤᎾᏦᏙᏗ", "ᏙᏆᎴᎵ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("autobus"),
            keywords: &["autobus", "vozidlo"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("bws"),
            keywords: &["bws", "cerbyd"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("bus"),
            keywords: &["bus", "køretøj"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Bus"),
            keywords: &["Bus", "Fahrzeug"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("λεωφορείο"),
            keywords: &["λεωφορείο", "όχημα"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("bus"),
            keywords: &["bus", "vehicle"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("autobús"),
            keywords: &["autobús", "bus", "transporte"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["autobús", "bus", "colectivo", "transporte"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &[
                "autobús",
                "bus",
                "camión",
                "colectivo",
                "ruta",
                "transporte",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("buss"),
            keywords: &["buss", "sõiduk"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("autobusa"),
            keywords: &["autobusa", "ibilgailu"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("اتوبوس"),
            keywords: &["اتوبوس", "وسیله\u{654} نقلیه"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("bussi"),
            keywords: &["ajoneuvo", "auto", "bussi", "linja-auto"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("bus"),
            keywords: &["bus", "sasakyan"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("bussur"),
            keywords: &["bussur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("bus"),
            keywords: &["bus", "véhicule"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["autobus", "bus", "véhicule"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("bus"),
            keywords: &["bus", "bus buí", "feithicil"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("bus"),
            keywords: &["bus", "carbad"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("autobús"),
            keywords: &["autobús", "autocar", "bus"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("બસ"),
            keywords: &["બસ", "વાહન"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("bas"),
            keywords: &["bas", "mota"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("אוטובוס"),
            keywords: &["אוטובוס", "תחבורה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("बस"),
            keywords: &["बस", "वाहन"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("autobus"),
            keywords: &["autobus", "vozilo"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("busz"),
            keywords: &["busz", "jármű"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ավտոբուս"),
            keywords: &["ավտոբուս", "փոխադրամիջոց"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("bus"),
            keywords: &["bus", "kendaraan"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ụgbọala ogologo"),
            keywords: &["ụgbọala", "ụgbọala ogologo"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("strætó"),
            keywords: &["rúta", "strætisvagn", "strætó"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("bus"),
            keywords: &["autobus", "bus", "veicolo"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("バス"),
            keywords: &["バス", "乗り物"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("bis"),
            keywords: &["bis", "tetumpakan"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ავტობუსი"),
            keywords: &["ავტობუსი", "ტრანსპორტი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("автобус"),
            keywords: &["автобус", "көлік"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("bus"),
            keywords: &["bus", "køretøj"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("រថយន\u{17d2}តក\u{17d2}រ\u{17bb}ង"),
            keywords: &["រថយន\u{17d2}តក\u{17d2}រ\u{17bb}ង", "ឡានក\u{17d2}រ\u{17bb}ង"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಬಸ\u{ccd}"),
            keywords: &["ಬಸ\u{ccd}", "ವಾಹನ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("버스"),
            keywords: &["교통수단", "버스", "차"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("बस"),
            keywords: &["बस", "वाहन"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("автобус"),
            keywords: &["автобус", "унаа"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Bus"),
            keywords: &["Bus", "Gefier"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ລ\u{ebb}ດເມ"),
            keywords: &["ພາຫະນະ", "ລ\u{ebb}ດເມ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("autobusas"),
            keywords: &["autobusas", "transporto priemonė"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("autobuss"),
            keywords: &["autobuss", "transports"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pahi"),
            keywords: &["pahi", "waka"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("автобус"),
            keywords: &["автобус", "возило"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ബസ\u{d4d}"),
            keywords: &["ബസ\u{d4d}", "വ\u{d3e}ഹനം"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("автобус"),
            keywords: &["автобус", "тээврийн хэрэгсэл"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("बस"),
            keywords: &["बस", "वाहन"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("bas"),
            keywords: &["bas", "kenderaan"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("xarabank"),
            keywords: &["vettura", "xarabank"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဘတ\u{103a}စ\u{103a}ကား"),
            keywords: &["ဘတ\u{103a}စ\u{103a}ကား", "ယာဥ\u{103a}"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("buss"),
            keywords: &["buss", "fremkomstmiddel"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("बस"),
            keywords: &["गाडी", "बस"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("bus"),
            keywords: &["bus", "voertuig"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("buss"),
            keywords: &["buss", "framkomstmiddel"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ବସ\u{b4d}\u{200c}"),
            keywords: &["ବସ\u{b4d}\u{200c}", "ବ\u{b3e}ହ\u{b3e}ନ"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਬ\u{a71}ਸ"),
            keywords: &["ਬ\u{a71}ਸ", "ਵਾਹਨ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("بس"),
            keywords: &["بس", "گڈی"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Bọs"),
            keywords: &["Bọs", "Móto"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("autobus"),
            keywords: &["autobus", "autokar", "pojazd"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("بس"),
            keywords: &["بس", "ګاډی"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("ônibus"),
            keywords: &["veículo", "ônibus"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("autocarro"),
            keywords: &["autocarro", "veículo"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("bus"),
            keywords: &["bus", "carru"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("autobuz"),
            keywords: &["autobuz", "vehicul"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-928"),
            keywords: &["E10-928"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("автобус"),
            keywords: &["автобус", "транспорт"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("bisi"),
            keywords: &["bisi", "imodoka"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("بس"),
            keywords: &["بس", "گاڏي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("බසය"),
            keywords: &["බසය", "ව\u{dcf}හනය"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("autobus"),
            keywords: &["autobus", "dopravný prostriedok"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("avtobus"),
            keywords: &["avtobus", "vozilo"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("bas"),
            keywords: &["bas", "gaari"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("autobus"),
            keywords: &["autobus", "mjet udhëtimi"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("аутобус"),
            keywords: &["аутобус", "вoзилo"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("autobus"),
            keywords: &["autobus", "vozilo"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("buss"),
            keywords: &["buss", "fordon"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("basi"),
            keywords: &["basi", "gari"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பேருந\u{bcd}து"),
            keywords: &["பஸ\u{bcd}", "பேருந\u{bcd}து"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ట\u{c4d}ర\u{c3e}మ\u{c4d} క\u{c3e}రు"),
            keywords: &["క\u{c3e}రు", "ట\u{c4d}ర\u{c3e}మ\u{c4d}"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("автобус"),
            keywords: &["автобус", "нақлиёт"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("รถบ\u{e31}ส"),
            keywords: &["ยานพาหนะ", "รถบ\u{e31}ส"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("awtobus"),
            keywords: &["awtobus", "ulag"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("pasi"),
            keywords: &["pasi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("otobüs"),
            keywords: &["otobüs", "taşıt"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئاپتوبۇس"),
            keywords: &["ئاپتوبۇس", "ئاپتوموبىل"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("автобус"),
            keywords: &["автобус", "транспорт"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("بس"),
            keywords: &["بس", "سواری"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("avtobus"),
            keywords: &["avtobus", "transport"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("xe buýt"),
            keywords: &["xe buýt", "xe cộ"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("otokaar"),
            keywords: &["otokaar", "waruwaay"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ibhasi"),
            keywords: &["ibhasi", "inqwelo-mafutha"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ọkọ Akero"),
            keywords: &["nṣe ọkọ\u{301}", "Ọkọ Akero"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("巴士"),
            keywords: &["巴士", "車輛"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("巴士"),
            keywords: &["巴士", "车辆"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("公交车"),
            keywords: &["公交车", "公共汽车", "大巴"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("公車"),
            keywords: &["公共汽車", "公車"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("巴士"),
            keywords: &["公共汽車", "巴士"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ibhasi"),
            keywords: &["ibhasi", "imoto"],
        },
    ],
};
#[doc = "🚍"]
pub const ONCOMING_BUS: crate::Emoji = crate::Emoji {
    glyph: "🚍",
    codepoint: "1F68D",
    status: crate::Status::FullyQualified,
    introduction_version: 0.7f32,
    name: "oncoming bus",
    group: "Travel & Places",
    subgroup: "transport-ground",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("aankomende bus"),
            keywords: &["aankomend", "aankomende bus", "bus", "voertuig"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("መጪ አውቶቡስ"),
            keywords: &["መጪ", "ተሽከርካሪ", "አውቶቡስ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("\u{202b}حافلة مقتربة"),
            keywords: &["باص", "مركبة", "مقترب", "\u{202b}حافلة مقتربة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("আহিবলগীয\u{9bc}\u{9be} ব\u{9be}ছ"),
            keywords: &["আহিবলগীয\u{9bc}\u{9be}", "ব\u{9be}ছ"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("yaxınlaşan avtobus"),
            keywords: &["avtobus", "nəqliyyat", "yaxınlaşan avtobus", "yaxınlaşma"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("набліжаецца аўтобус"),
            keywords: &["аўтобус", "набліжаецца аўтобус", "набліжэнне", "транспарт"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("приближаващ автобус"),
            keywords: &["автобус", "превозно средство", "приближаващ"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("অগ\u{9cd}রসরম\u{9be}ন ব\u{9be}স"),
            keywords: &["অগ\u{9cd}রসরম\u{9be}ন", "ব\u{9be}স", "য\u{9be}নব\u{9be}হন"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("dolazeći autobus"),
            keywords: &["autobus", "dolazeći autobus", "dolazi", "vozilo"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("autobús que arriba"),
            keywords: &[
                "autobús",
                "autobús de cara",
                "autobús que arriba",
                "bus",
                "bus de cara",
                "proper",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏗᎾᏕᎶᏆᏍᎩ ᎤᎾᏦᏙᏗ ᏂᏓᏳᏍᏗᏛ"),
            keywords: &["ᏂᏓᏳᏍᏗᏛ", "ᏗᎾᏕᎶᏆᏍᎩ ᎤᎾᏦᏙᏗ", "ᏗᎾᏕᎶᏆᏍᎩ ᎤᎾᏦᏙᏗ ᏂᏓᏳᏍᏗᏛ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("přijíždějící autobus"),
            keywords: &["autobus", "přijíždějící", "příjezd", "vozidlo"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("bws yn dod i’ch cwrdd"),
            keywords: &["bws", "bws yn dod i’ch cwrdd"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("bus forfra"),
            keywords: &["bus", "forfra", "kørende", "køretøj"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Bus von vorne"),
            keywords: &["Bus", "Bus von vorne"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("διερχόμενο λεωφορείο"),
            keywords: &["διερχόμενο", "λεωφορείο", "όχημα"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("oncoming bus"),
            keywords: &["bus", "oncoming"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("autobús próximo"),
            keywords: &["autobús", "próximo", "vehículo"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("autobús se aproxima"),
            keywords: &[
                "autobús",
                "autobús que llega",
                "autobús se aproxima",
                "bus",
                "colectivo",
                "micro",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("autobús se aproxima"),
            keywords: &["autobús se aproxima"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("buss eestvaates"),
            keywords: &["buss", "buss eestvaates", "eestvaade"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("heldu den autobusa"),
            keywords: &["autobusa", "heldu", "heldu den autobusa"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("اتوبوس روبه\u{200c}جلو"),
            keywords: &[
                "اتوبوس",
                "اتوبوس روبه\u{200c}جلو",
                "درحال آمدن",
                "نزدیک\u{200c}شونده",
                "وسیله\u{654} نقلیه",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("saapuva bussi"),
            keywords: &["ajoneuvo", "auto", "bussi", "linja-auto", "saapuva bussi"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("paparating na bus"),
            keywords: &["bus", "paparating", "paparating na bus", "sasakyan"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("gron á bussi"),
            keywords: &["bussur", "gron á bussi"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("bus de face"),
            keywords: &["bus", "bus de face"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["autobus", "bus", "bus de face", "de face", "à l’arrivé"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("bus atá ag teacht"),
            keywords: &["ag teacht", "bus", "bus atá ag teacht", "feithicil"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("bus a’ tighinn thugad"),
            keywords: &["bus", "bus a’ tighinn thugad", "tighinn"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("autobús de fronte"),
            keywords: &["autobús", "autobús de fronte", "autocar", "bus"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("આવી રહ\u{ac7}લ બસ"),
            keywords: &["આવનારી", "આવી રહ\u{ac7}લ બસ", "બસ", "વાહન"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("bas mai zuwa"),
            keywords: &["bas", "bas mai zuwa", "mai Zuwa"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("אוטובוס מלפנים"),
            keywords: &["אוטובוס", "אוטובוס מלפנים", "תחבורה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("आती ह\u{941}ई बस"),
            keywords: &["आती ह\u{941}ई", "आती ह\u{941}ई बस", "बस", "वाहन"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("autobus u dolasku"),
            keywords: &["autobus", "autobus u dolasku", "dolazak", "vozilo"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("érkező busz"),
            keywords: &["busz", "jármű", "érkezés", "érkező busz"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("մոտեցող ավտոբուս"),
            keywords: &["ավտոբուս", "մոտեցող", "փոխադրամիջոց"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("bus datang"),
            keywords: &["bus", "datang", "kendaraan"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ụgbọala ogologo na-apụta apụta"),
            keywords: &[
                "na-apụta apụta",
                "ụgbọala ogologo",
                "ụgbọala ogologo na-apụta apụta",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("strætó á móti"),
            keywords: &["strætó", "strætó nálgast", "strætó á móti"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("bus in arrivo"),
            keywords: &["bus", "bus in arrivo", "in arrivo", "veicolo"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("バス正面"),
            keywords: &["バス", "バス正面", "乗り物"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("bis katon mara"),
            keywords: &["bis", "bis katon mara", "mara"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მომავალი ავტობუსი"),
            keywords: &["ავტობუსი", "მომავალი", "ტრანსპორტი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("келе жатқан автобус"),
            keywords: &["автобус", "келе жатыр", "келе жатқан автобус", "көлік"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("bus forfra"),
            keywords: &["bus", "forfra", "kørende", "køretøj"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("រថយន\u{17d2}តក\u{17d2}រ\u{17bb}ងមើលព\u{17b8}ម\u{17bb}ខ"),
            keywords: &[
                "ច\u{17c6}ព\u{17b8}ម\u{17bb}ខ",
                "រថយន\u{17d2}តក\u{17d2}រ\u{17bb}ង",
                "រថយន\u{17d2}តក\u{17d2}រ\u{17bb}ងមើលព\u{17b8}ម\u{17bb}ខ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಮುಂದ\u{cc6} ಬರುತ\u{ccd}ತ\u{cbf}ರುವ ಬಸ\u{ccd}"),
            keywords: &[
                "ಬಸ\u{ccd}",
                "ಮುಂದ\u{cc6} ಬರುತ\u{ccd}ತ\u{cbf}ರುವ ಬಸ\u{ccd}",
                "ಮುನ\u{ccd}ನುಗ\u{ccd}ಗ\u{cbf} ಬರುವ ಬಸ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("오고 있는 버스"),
            keywords: &["버스", "오고 있는 버스"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("य\u{947}वपी बस"),
            keywords: &["बस", "य\u{947}वपी"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("келе жаткан автобус"),
            keywords: &["автобус", "келе жаткан", "келе жаткан автобус", "унаа"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("entgéintkommende Bus"),
            keywords: &["Bus", "entgéintkommend", "entgéintkommende Bus"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ລ\u{ebb}ດເມກຳລ\u{eb1}ງມາ"),
            keywords: &[
                "ກຳລ\u{eb1}ງມາ",
                "ພາຫະນະ",
                "ລ\u{ebb}ດເມ",
                "ລ\u{ebb}ດເມກຳລ\u{eb1}ງມາ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("artėjantis autobusas"),
            keywords: &["artėjantis", "autobusas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("pretī braucošs autobuss"),
            keywords: &["autobuss", "pretī braucošs autobuss", "transports"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pahi anga mai"),
            keywords: &["anga mai", "pahi", "pahi anga mai"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("автобус што пристигнува"),
            keywords: &[
                "автобус",
                "автобус што пристигнува",
                "возило",
                "пристигнува",
            ],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("വര\u{d41}ന\u{d4d}ന ബസ\u{d4d}"),
            keywords: &["ബസ\u{d4d}", "വര\u{d41}ന\u{d4d}ന ബസ\u{d4d}", "വ\u{d3e}ഹനം"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("ирж буй автобус"),
            keywords: &["автобус", "ирж буй", "ирж буй автобус"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("य\u{947}णारी बस"),
            keywords: &["बस", "य\u{947}णारी बस", "य\u{947}णार\u{947}"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("bas dari arah depan"),
            keywords: &["bas", "bas dari arah depan", "dari arah depan", "kenderaan"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("xarabank ġejja ’l hawn"),
            keywords: &["xarabank", "xarabank ġejja ’l hawn", "ġejja ’l hawn"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("လာနေသည\u{1037}\u{103a} ဘတ\u{103a}စ\u{103a}ကား"),
            keywords: &[
                "ဘတ\u{103a}စ\u{103a}ကား",
                "လာနေသည\u{1037}\u{103a} ဘတ\u{103a}စ\u{103a}ကား",
                "လာနေသည\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("motgående buss"),
            keywords: &["buss", "fremkomstmiddel", "motgående"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("आउ\u{901}द\u{948} गर\u{947}को बस"),
            keywords: &[
                "आउ\u{901}द\u{948} गर\u{947}को",
                "आउ\u{901}द\u{948} गर\u{947}को बस",
                "गाडी",
                "बस",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("naderende bus"),
            keywords: &["bus", "naderend", "naderende bus"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("motgåande buss"),
            keywords: &["buss", "framkomstmiddel", "motgåande"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ସମ\u{b4d}ମ\u{b41}ଖର\u{b41} ଆସ\u{b41}ଥ\u{b3f}ବ\u{b3e} ବସ\u{b4d}\u{200c}"),
            keywords: &[
                "ଆସ\u{b41}ଥ\u{b3f}ବ\u{b3e}",
                "ବସ\u{b4d}",
                "ବ\u{b3e}ହ\u{b3e}ନ",
                "ସମ\u{b4d}ମ\u{b41}ଖର\u{b41} ଆସ\u{b41}ଥ\u{b3f}ବ\u{b3e} ବସ\u{b4d}\u{200c}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਆ ਰਹੀ ਬ\u{a71}ਸ"),
            keywords: &["ਆ ਰਹੀ", "ਆ ਰਹੀ ਬ\u{a71}ਸ", "ਬ\u{a71}ਸ", "ਵਾਹਨ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("آن آلی بس"),
            keywords: &["آن آلی بس", "آن آلے", "بس"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Bọs Wé De Kọ\u{301}m Wiá Yu Dè"),
            keywords: &[
                "Bọs",
                "Bọs Wé De Kọ\u{301}m Wiá Yu Dè",
                "Sọ\u{301}mtin Wé De Kọ\u{301}m Wiá Yu Dè",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("nadjeżdżający autobus"),
            keywords: &["autobus", "nadjeżdżający autobus", "nadjeżdżać", "przód"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("راتلونکی بس"),
            keywords: &["بس", "راتلونکی"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("ônibus se aproximando"),
            keywords: &[
                "se aproximando",
                "veículo",
                "ônibus",
                "ônibus se aproximando",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("autocarro a aproximar-se"),
            keywords: &[
                "aproximação",
                "autocarro",
                "autocarro a aproximar-se",
                "autocarro a chegar",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("qatiq autobus"),
            keywords: &["autobus", "bus", "qatiq"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("autobuz care se apropie"),
            keywords: &["autobuz", "autobuz care se apropie", "sosire"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-929"),
            keywords: &["E10-929"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("автобус спереди"),
            keywords: &[
                "автобус",
                "автобус спереди",
                "лобовое стекло",
                "приближающийся автобус",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("bisi iza igusanga"),
            keywords: &["bisi iza igusanga"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ايندڙ بس"),
            keywords: &["ايندڙ بس", "بس", "پهچڻ واري"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ඉද\u{dd2}ර\u{dd2}යට එන බසය"),
            keywords: &[
                "ඉද\u{dd2}ර\u{dd2}යට එන",
                "ඉද\u{dd2}ර\u{dd2}යට එන බසය",
                "බසය",
                "ව\u{dcf}හනය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("prichádzajúci autobus"),
            keywords: &[
                "autobus",
                "dopravný prostriedok",
                "prichádzajúce",
                "prichádzajúci autobus",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("prihajajoči avtobus"),
            keywords: &["avtobus", "prihajajoče", "prihajajoči avtobus", "vozilo"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("bas soo socda"),
            keywords: &["bas", "bas soo socda", "soo socda"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("autobus që vjen"),
            keywords: &["autobus", "autobus që vjen", "mjet", "në ardhje", "që vjen"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("аутобус спреда"),
            keywords: &["aутoбус", "аутобус спреда", "дoлaзaк"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("аутобус сприједа"),
            keywords: &["аутобус сприједа"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("autobus spreda"),
            keywords: &["autobus", "autobus spreda", "dolazak"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("autobus sprijeda"),
            keywords: &["autobus sprijeda"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("mötande buss"),
            keywords: &["buss", "fordon", "mötande"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("basi linalokuja"),
            keywords: &["basi", "gari", "linalokuja"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("வந\u{bcd}துகொண\u{bcd}டிருக\u{bcd}கும\u{bcd} பேருந\u{bcd}து"),
            keywords: &[
                "பேருந\u{bcd}து வந\u{bcd}துகொண\u{bcd}டிருக\u{bcd}கிறது",
                "வந\u{bcd}துகொண\u{bcd}டிருக\u{bcd}கும\u{bcd} பேருந\u{bcd}து",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ముందువ\u{c48}పు వస\u{c4d}తున\u{c4d}న బస\u{c4d}సు"),
            keywords: &[
                "బస\u{c4d}సు",
                "ముందు",
                "ముందువ\u{c48}పు వస\u{c4d}తున\u{c4d}న బస\u{c4d}సు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("автобуси самти муқобил"),
            keywords: &["автобус", "автобуси самти муқобил", "самти муқобил"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("รถบ\u{e31}สกำล\u{e31}งมา"),
            keywords: &[
                "กำล\u{e31}งมา",
                "ยานพาหนะ",
                "รถบ\u{e31}ส",
                "รถบ\u{e31}สกำล\u{e31}งมา",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("gelýän awtobus"),
            keywords: &["awtobus", "gelýän"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("pasi lele mai"),
            keywords: &["pasi lele mai"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("yaklaşan otobüs"),
            keywords: &["otobüs", "taşıt", "yaklaşan"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("كېلىۋاتقان ئاپتوبۇس"),
            keywords: &["ئاپتوبۇس", "كېلىۋاتقان"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("автобус, що наближається"),
            keywords: &[
                "автобус",
                "автобус, що наближається",
                "наближатися",
                "транспорт",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("آتی ہوئی بس"),
            keywords: &["آتی ہوئی", "آتی ہوئی بس", "بس"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("yaqinlashayotgan avtobus"),
            keywords: &["avtobus", "kelayotgan", "transport", "yaqinlashayotgan"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("xe buýt đang tới"),
            keywords: &["xe buýt", "xe buýt đang tới", "đang tới"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("kaar buy ñëw"),
            keywords: &["kaar", "kaar buy ñëw", "ñëw"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ibhasi ezayo"),
            keywords: &["ezayo", "ibhasi"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ọkọ Akero Ti Nbọ"),
            keywords: &["tí ń bọ\u{300}", "Ọkọ Akero Ti Nbọ", "ọkọ\u{300} akérò"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("快到站嘅巴士"),
            keywords: &["巴士", "快到站嘅巴士", "黎緊"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("快到站嘅巴士"),
            keywords: &["巴士", "快到站嘅巴士", "黎紧"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("迎面驶来的公交车"),
            keywords: &["公共汽车", "大巴", "迎面驶来", "迎面驶来的公交车"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("公共汽車"),
            keywords: &["公共汽車", "公車"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("接近中嘅巴士"),
            keywords: &["巴士", "接近中嘅巴士"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ibhasi elizayo"),
            keywords: &["elizayo", "ibhasi", "imoto"],
        },
    ],
};
#[doc = "🚎"]
pub const TROLLEYBUS: crate::Emoji = crate::Emoji {
    glyph: "🚎",
    codepoint: "1F68E",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "trolleybus",
    group: "Travel & Places",
    subgroup: "transport-ground",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("trembus"),
            keywords: &["bus", "trem", "trembus", "voertuig"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("በኤሌትሪክ የሚጎተት አውቶቡስ"),
            keywords: &[
                "በኤሌትሪክ የሚጎተት አውቶቡስ",
                "በኤሌክትሪክ የሚጎተት",
                "ተሽከርካሪ",
                "ተጎታች",
                "አውቶቡስ",
            ],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("أتوبيس ترولي"),
            keywords: &["أتوبيس ترولي", "أتوبيس كهربائي", "ترولي", "مركبة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ট\u{9cd}ৰ’লীব\u{9be}ছ"),
            keywords: &[
                "ট\u{9cd}ৰ\u{9be}ম",
                "ট\u{9cd}ৰ’লী",
                "ট\u{9cd}ৰ’লীব\u{9be}ছ",
                "ব\u{9be}ছ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("trolleybus"),
            keywords: &["avtobus", "nəqliyyat", "tramvay", "trolleybus"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("тралейбус"),
            keywords: &["тралейбус", "тралік", "транспарт", "электрычнасць"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("тролейбус"),
            keywords: &["превозно средство", "тролей", "тролейбус"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ট\u{9cd}রলি ব\u{9be}স"),
            keywords: &[
                "ট\u{9cd}রলি",
                "ট\u{9cd}র\u{9be}ম",
                "ব\u{9be}স",
                "য\u{9be}নব\u{9be}হন",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("trollebus"),
            keywords: &["bus", "tramgarr", "trolle", "trollebus"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("trolejbus"),
            keywords: &["trolejbus", "vozilo"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("troleibús"),
            keywords: &["autobús", "bus", "tramvia", "troleibús", "tròlei"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏴᏫ ᏗᏘᏂᏙ ᏙᎴᎳ"),
            keywords: &["ᎤᎾᏦᏙᏗ", "ᏗᎾᏕᎶᏆᏍᎩ ᎤᎾᏦᏙᏗ", "ᏙᏆᎴᎵ", "ᏴᏫ ᏗᏘᏂᏙ ᏙᎴᎳ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("trolejbus"),
            keywords: &["trolej", "trolejbus", "vozidlo"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("bws trydan"),
            keywords: &["bws", "bws trydan", "cerbyd", "tram", "troli"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("trolleybus"),
            keywords: &["bus", "køretøj", "sporvogn", "trolley", "trolleybus"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Oberleitungsbus"),
            keywords: &["Oberleitungsbus", "Trolleybus"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("τρόλεϊ"),
            keywords: &["λεωφορείο", "τραμ", "τρόλεϊ", "όχημα"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("trolleybus"),
            keywords: &["bus", "tram", "trolley", "trolleybus"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("trolley bus"),
            keywords: &["bus", "tram", "trolley"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("trolley bus"),
            keywords: &["bus", "streetcar", "tram", "trolley", "trolleybus"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("trolebús"),
            keywords: &["transporte", "tranvía", "trolebús"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("trollibuss"),
            keywords: &["buss", "tramm", "troll", "trollibuss"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("trolebusa"),
            keywords: &["autobus", "ibilgailu", "tranbia", "trolebus", "trolebusa"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("اتوبوس برقی"),
            keywords: &["اتوبوس", "برقی", "تراموا", "وسیله\u{654} نقلیه"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("johdinbussi"),
            keywords: &["ajoneuvo", "auto", "johdinauto", "johdinbussi"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("trolleybus"),
            keywords: &["bus", "sasakyan", "trambiya", "trolley", "trolleybus"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("tráðbussur"),
            keywords: &["sporvognur", "tráðbussur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("trolleybus"),
            keywords: &["bus", "trolley", "trolleybus"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["bus", "tram", "trolley", "trolleybus"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("bus tralaí"),
            keywords: &["bus", "feithicil", "tralaí"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("bus-troilidh"),
            keywords: &["bus", "bus-troilidh", "trama", "troilidh"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("trolebús"),
            keywords: &["trole", "trolebús"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ટ\u{acd}રોલીબસ"),
            keywords: &["ટ\u{acd}રોલી", "ટ\u{acd}રોલીબસ", "બસ", "વાહન"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("bas mai aiki da lantarki"),
            keywords: &[
                "bas",
                "bas mai aiki da lantarki",
                "mai aiki da lantarki",
                "tram",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("אוטובוס חשמלי"),
            keywords: &["אוטובוס", "חשמלי", "תחבורה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ट\u{94d}रॉलीबस"),
            keywords: &["ट\u{94d}रॉली", "ट\u{94d}रॉलीबस", "बस", "वाहन"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("trolejbus"),
            keywords: &["autobus", "tramvaj", "trolejbus", "vozilo"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("trolibusz"),
            keywords: &["busz", "jármű", "troli", "trolibusz"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("տրոլեյբուս"),
            keywords: &["ավտոբուս", "տրամվայ", "տրոլեյբուս", "փոխադրամիջոց"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("bus listrik"),
            keywords: &["bus", "kendaraan", "listrik", "trem"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ogologo ụgbọala"),
            keywords: &[
                "igwemkpụgharị",
                "ogologo ụgbọala",
                "tramụ\u{300}",
                "ụgbọala ogologo",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("trissustrætó"),
            keywords: &[
                "rafknúinn strætisvagn",
                "rafmagnsstrætó",
                "strætó",
                "trissustrætó",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("filobus"),
            keywords: &["bus", "filobus", "veicolo"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("トロリーバス"),
            keywords: &["トロリーバス", "バス", "乗り物"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("bis troli"),
            keywords: &["bis", "trem", "troli"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ტროლეიბუსი"),
            keywords: &["ავტობუსი", "ტრამვაი", "ტრანსპორტი", "ტროლეიბუსი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("троллейбус"),
            keywords: &["автобус", "көлік", "трамвай", "троллейбус"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("trolleybus"),
            keywords: &["bus", "køretøj", "sporvogn", "trolley", "trolleybus"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("រថយន\u{17d2}តក\u{17d2}រ\u{17bb}ងអគ\u{17d2}គ\u{17b7}សន\u{17b8}"),
            keywords: &[
                "រថយន\u{17d2}តក\u{17d2}រ\u{17bb}ង",
                "រថយន\u{17d2}តក\u{17d2}រ\u{17bb}ងអគ\u{17d2}គ\u{17b7}សន\u{17b8}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಟ\u{ccd}ರಾಲ\u{cbf} ಬಸ\u{ccd}"),
            keywords: &["ಟ\u{ccd}ರಾಲ\u{cbf} ಬಸ\u{ccd}", "ಬಸ\u{ccd}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("트롤리 버스"),
            keywords: &["버스", "트롤리"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("ट\u{94d}रॉलीबस"),
            keywords: &["ट\u{94d}राम", "ट\u{94d}रॉली", "ट\u{94d}रॉलीबस", "बस"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("троллейбус"),
            keywords: &["автобус", "трамвай", "троллейбус", "унаа"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Trolleybus"),
            keywords: &["Bus", "Tram", "Trolley", "Trolleybus"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ລ\u{ebb}ດເມໄຟຟ\u{ec9}າ"),
            keywords: &["ລ\u{ebb}ດເມ", "ລ\u{ebb}ດເມໄຟຟ\u{ec9}າ", "ໄຟຟ\u{ec9}າ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("troleibusas"),
            keywords: &["autobusas", "tramvajus", "troleibusas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("trolejbuss"),
            keywords: &["transports", "trolejbuss"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("waka pāhiko"),
            keywords: &["pahi", "tarāme", "waka pāhiko"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("тролејбус"),
            keywords: &["возило", "тролејбус"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ട\u{d4d}രോളി ബസ\u{d4d}"),
            keywords: &["ട\u{d4d}രോളി", "ബസ\u{d4d}", "വ\u{d3e}ഹനം"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("троллейбус"),
            keywords: &["автобус", "трамвай", "троллейбус"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("ट\u{94d}रॉलीबस"),
            keywords: &["ट\u{94d}राम", "ट\u{94d}रॉली", "ट\u{94d}रॉलीबस", "बस"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("bas troli"),
            keywords: &["bas", "kenderaan", "trem", "troli"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("trolleybus"),
            keywords: &["tramm", "trolley", "trolleybus", "xarabank"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ထရော\u{103a}လ\u{102e}ဘတ\u{103a}စ\u{103a}ကား"),
            keywords: &[
                "ထရော\u{103a}လ\u{102e}",
                "ထရော\u{103a}လ\u{102e}ဘတ\u{103a}စ\u{103a}",
                "ထရော\u{103a}လ\u{102e}ဘတ\u{103a}စ\u{103a}ကား",
                "ဓာတ\u{103a}ရထား",
                "ဘတ\u{103a}စ\u{103a}ကား",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("trolleybuss"),
            keywords: &["buss", "fremkomstmiddel", "trolleybuss"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("ट\u{94d}रलिबस"),
            keywords: &["गाडी", "ट\u{94d}रलिबस", "ट\u{94d}रली", "ट\u{94d}राम", "बस"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("trolleybus"),
            keywords: &["bus", "tram", "trolley", "trolleybus"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("trolleybuss"),
            keywords: &["buss", "framkomstmiddel", "motgåande", "trolleybuss"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଟ\u{b4d}ରଲ\u{b3f}ବସ\u{b4d}\u{200c}"),
            keywords: &[
                "ଟ\u{b4d}ରଲ\u{b3f}ବସ\u{b4d}\u{200c}",
                "ଟ\u{b4d}ରୋଲ\u{b3f}",
                "ବସ\u{b4d}",
                "ବ\u{b3e}ହ\u{b3e}ନ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਟਰਾਲੀ ਬ\u{a71}ਸ"),
            keywords: &["ਟਰਾਲੀ", "ਬ\u{a71}ਸ", "ਵਾਹਨ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("بجلی نال چلن آلی بس"),
            keywords: &["بجلی نال چلن آلی بس", "بس", "ٹرالی", "ٹرام"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Trọlíbọs"),
            keywords: &["Bọs", "Tram", "Trọlíbọs", "Trọ\u{301}lí", "Trọ\u{301}líbọs"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("trolejbus"),
            keywords: &["autobus", "elektryczny", "pojazd", "trolejbus"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ټرالي بس"),
            keywords: &["بس", "ټرالي", "ټرام"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("trólebus"),
            keywords: &["bonde elétrico", "trólebus", "veículo", "ônibus"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("troleicarro"),
            keywords: &["autocarro", "troleicarro", "trólei"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("trolebus"),
            keywords: &["bus", "carretilla", "tranvia", "trolebus"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("troleibuz"),
            keywords: &["autobuz", "tramvai", "troleibuz", "troleu"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-930"),
            keywords: &["E10-930"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("троллейбус"),
            keywords: &[
                "дорога",
                "провода",
                "транспорт",
                "троллейбус",
                "электричество",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("bisi ikoreshwa n’amashanyarazi"),
            keywords: &[
                "bisi",
                "bisi ikoreshwa n’amashanyarazi",
                "gari ya moshi ikoresha amashanyarazi",
                "gari ya mosi ikoresha amashanyarazi",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ٽرالي بس"),
            keywords: &["بس", "ٽرالي", "ٽرام"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ට\u{dca}\u{200d}රොල\u{dd2} බසය"),
            keywords: &[
                "ට\u{dca}\u{200d}රෑම\u{dca} රථය",
                "ට\u{dca}\u{200d}රොල\u{dd2} බසය",
                "ට\u{dca}\u{200d}රොල\u{dd2} රථය",
                "බසය",
                "ව\u{dcf}හනය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("trolejbus"),
            keywords: &["autobus", "dopravný prostriedok", "električka", "trolejbus"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("trolejbus"),
            keywords: &["avtobus", "tramvaj", "trolejbus", "vozilo"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("baska ragaad"),
            keywords: &["bas", "baska ragaad", "ragaad", "taraam"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("filobus"),
            keywords: &["autobus", "filobus", "mjet", "tramvaj"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("тролејбус"),
            keywords: &["aутoбус", "вoзилo", "трaмвaj", "трoлejбус", "тролејбус"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["тролејбус"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("trolejbus"),
            keywords: &["autobus", "tramvaj", "trolejbus", "vozilo"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["trolejbus"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("trådbuss"),
            keywords: &["buss", "fordon", "trådbuss"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kiberenge"),
            keywords: &["basi", "gari", "kiberenge", "toroli", "tramu"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("டிர\u{bbe}லி பஸ\u{bcd}"),
            keywords: &[
                "டிர\u{bbe}லி பஸ\u{bcd}",
                "ட\u{bcd}ர\u{bbe}லிபஸ\u{bcd}",
                "மின\u{bcd}ச\u{bbe}ர பஸ\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some(
                "వ\u{c3f}ద\u{c4d}యుత\u{c4d} త\u{c40}గలత\u{c4b} నడ\u{c3f}చ\u{c47} బస\u{c4d}సు",
            ),
            keywords: &[
                "త\u{c40}గ",
                "బస\u{c4d}సు",
                "వ\u{c3f}ద\u{c4d}యుత\u{c4d}",
                "వ\u{c3f}ద\u{c4d}యుత\u{c4d} త\u{c40}గలత\u{c4b} నడ\u{c3f}చ\u{c47} బస\u{c4d}సు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("троллейбус"),
            keywords: &["автобус", "трамвай", "троллейбус"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("รถราง"),
            keywords: &["ยานพาหนะ", "รถราง"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("trolleýbus"),
            keywords: &["awtobus", "tramwaý", "trolleýbus"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("pasi ʻuhila"),
            keywords: &["pasi ʻuhila"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("troleybüs"),
            keywords: &["otobüs", "taşıt", "troley", "troleybüs"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("تىراللىبۇس"),
            keywords: &["ئاپتوبۇس", "تىراللىبۇس", "تىرامۋاي"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("тролейбус"),
            keywords: &["автобус", "трамвай", "транспорт", "тролейбус"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ٹرالی بس"),
            keywords: &["بس", "ٹرالی", "ٹرام"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("trolleybus"),
            keywords: &["avtobus", "tramvay", "transport", "trolleybus"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("ô tô điện"),
            keywords: &["xe buýt", "xe goòng", "xe điện", "ô tô điện"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("trolleybus"),
            keywords: &["kaar", "tram", "trolley", "trolleybus"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ibhasi yombane"),
            keywords: &["ibhasi", "ibhasi yombane", "imoto", "utramu"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ọkọ Akero Oniwiwọ"),
            keywords: &[
                "Ọkọ Akero Oniwiwọ",
                "ọkọ\u{300} akérò",
                "ọkọ\u{300} akérò oníwíwọ\u{301}",
                "ọkọ\u{300} ojú irin gígùn",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("有軌巴士"),
            keywords: &["巴士", "有軌巴士", "有軌電車", "電車"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("有轨巴士"),
            keywords: &["巴士", "有轨巴士", "有轨电车", "电车"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("无轨电车"),
            keywords: &["无轨电车", "电车"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("無軌電車"),
            keywords: &["公車", "無軌電車", "電動巴士"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("電動車"),
            keywords: &["巴士", "電動車", "電車"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ibhasi elihamba ngogesi"),
            keywords: &[
                "ibhasi",
                "ibhasi elihamba ngogesi",
                "imoto",
                "inqola",
                "ithilamu",
            ],
        },
    ],
};
#[doc = "🚐"]
pub const MINIBUS: crate::Emoji = crate::Emoji {
    glyph: "🚐",
    codepoint: "1F690",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "minibus",
    group: "Travel & Places",
    subgroup: "transport-ground",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("minibus"),
            keywords: &["bus", "minibus", "taxi", "voertuig"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ሚኒባስ"),
            keywords: &["ሚኒባስ", "ተሽከርካሪ", "አውቶቡስ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("حافلة صغيرة"),
            keywords: &["حافلة", "حافلة صغيرة", "مركبة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("মিনিব\u{9be}ছ"),
            keywords: &["ব\u{9be}ছ", "মিনিব\u{9be}ছ"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("mini avtobus"),
            keywords: &["avtobus", "mini avtobus", "nəqliyyat"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("мікрааўтобус"),
            keywords: &["аўтобус", "маршрутка", "мікрааўтобус"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("минибус"),
            keywords: &["автобус", "минибус", "превозно средство"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("মিনিব\u{9be}স"),
            keywords: &["ব\u{9be}স", "মিনিব\u{9be}স", "য\u{9be}নব\u{9be}হন"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("minibus"),
            keywords: &["bus", "minibus"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("minibus"),
            keywords: &["bus", "minibus"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("microbús"),
            keywords: &["autobús", "bus", "microbús", "minibús", "vehicle"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᏍᏗ ᏙᎴᎳ ᏴᏫ ᏗᏘᏂᏙᎯ"),
            keywords: &["ᎤᏍᏗ ᏙᎴᎳ ᏴᏫ ᏗᏘᏂᏙᎯ", "ᏗᎾᏕᎶᏆᏍᎩ ᎤᎾᏦᏙᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("minibus"),
            keywords: &["autobus", "minibus", "vozidlo"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("bws mini"),
            keywords: &["bws", "bws mini"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("minibus"),
            keywords: &["bus", "minibus"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Kleinbus"),
            keywords: &["Bus", "Kleinbus"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("μίνιμπας"),
            keywords: &["λεωφορείο", "μίνιμπας", "όχημα"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("minibus"),
            keywords: &["bus", "minibus"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("minibús"),
            keywords: &["autobús", "bus", "minibús", "transporte"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["combi", "minibús", "transporte", "van"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("väikebuss"),
            keywords: &["buss", "sõiduk", "väikebuss"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("minibusa"),
            keywords: &["autobus", "ibilgailu", "minibusa"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("مینی\u{200c}بوس"),
            keywords: &["اتوبوس", "مینی\u{200c}بوس", "وسیله\u{654} نقلیه"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("minibussi"),
            keywords: &[
                "ajoneuvo",
                "auto",
                "bussi",
                "linja-auto",
                "minibussi",
                "pikkubussi",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("minibus"),
            keywords: &["bus", "minibus", "sasakyan"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("minibussur"),
            keywords: &["bussur", "minibussur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("minibus"),
            keywords: &["bus", "minibus"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("mionbhus"),
            keywords: &["bus", "feithicil", "mionbhus"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("meanbh-bhus"),
            keywords: &["bus", "meanbh-bhus"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("minibús"),
            keywords: &["autobús", "minibús"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("મિનિબસ"),
            keywords: &["બસ", "મિનિબસ", "વાહન"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("ƙaramin bas"),
            keywords: &["bas", "ƙaramin bas"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("מיניבוס"),
            keywords: &["מיניבוס", "תחבורה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("मिनीबस"),
            keywords: &["बस", "मिनीबस", "वाहन"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("minibus"),
            keywords: &["autobus", "minibus", "vozilo"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("mikrobusz"),
            keywords: &["busz", "jármű", "mikrobusz", "minibusz"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("միկրոավտոբուս"),
            keywords: &["ավտոբուս", "միկրոավտոբուս", "փոխադրամիջոց"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("minibus"),
            keywords: &["bus", "kendaraan", "minibus"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("obere ụgbọala"),
            keywords: &["obere ụgbọala", "ụgbọala ogologo"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("smárúta"),
            keywords: &["rúta", "smárúta"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("pulmino"),
            keywords: &["bus", "pulmino", "veicolo"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("マイクロバス"),
            keywords: &["バス", "マイクロバス", "乗り物"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("bis cilik"),
            keywords: &["bis", "bis cilik"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("სამარშრუტო ტაქსი"),
            keywords: &["ავტობუსი", "სამარშრუტო ტაქსი", "ტრანსპორტი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("шағын автобус"),
            keywords: &["автобус", "көлік", "шағын автобус"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("minibus"),
            keywords: &["bus", "minibus"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("រថយន\u{17d2}ត24កៅអ\u{17b8}"),
            keywords: &[
                "រថយន\u{17d2}ត24កៅអ\u{17b8}",
                "រថយន\u{17d2}តឈ\u{17d2}ន\u{17bd}ល",
                "ឡាន",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಮ\u{cbf}ನ\u{cbf} ಬಸ\u{ccd}"),
            keywords: &[
                "ಬಸ\u{ccd}",
                "ಮ\u{cbf}ನ\u{cbf} ಬಸ\u{ccd}",
                "ಮ\u{cbf}ನ\u{cbf}ಬಸ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("미니버스"),
            keywords: &["미니버스", "소형 버스"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("मिनीबस"),
            keywords: &["बस", "मिनीबस"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("маршрутка"),
            keywords: &["автобус", "маршрутка", "унаа"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Minibus"),
            keywords: &["Bus", "Minibus"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ລ\u{ebb}ດເມນ\u{ec9}ອຍ"),
            keywords: &["ພາຫະນະ", "ລ\u{ebb}ດເມນ\u{ec9}ອຍ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("mikroautobusas"),
            keywords: &["autobusas", "mikroautobusas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("mikroautobuss"),
            keywords: &["autobuss", "mikroautobuss", "transports"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pahi iti"),
            keywords: &["pahi", "pahi iti"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("минибус"),
            keywords: &["автобус", "возило", "минибус"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("മിനിബസ\u{d4d}"),
            keywords: &["ബസ\u{d4d}", "മിനിബസ\u{d4d}", "വ\u{d3e}ഹനം"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("жижиг оврын автобус"),
            keywords: &["автобус", "жижиг оврын автобус"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("मिनीबस"),
            keywords: &["बस", "मिनीबस"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("bas mini"),
            keywords: &["bas", "bas mini", "kenderaan"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("minibus"),
            keywords: &["minibus", "xarabank"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("မ\u{102e}န\u{102e}ဘတ\u{103a}စ\u{103a}ကား"),
            keywords: &[
                "ဘတ\u{103a}စ\u{103a}ကား",
                "မ\u{102e}န\u{102e}ဘတ\u{103a}စ\u{103a}",
                "မ\u{102e}န\u{102e}ဘတ\u{103a}စ\u{103a}ကား",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("minibuss"),
            keywords: &["buss", "kjøretøy", "minibuss", "van"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("मिनिबस"),
            keywords: &["गाडी", "बस", "मिनिबस"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("minibus"),
            keywords: &["bus", "minibus"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("minibuss"),
            keywords: &["buss", "køyretøy", "minibuss", "van"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ମ\u{b3f}ନ\u{b3f}ବସ\u{b4d}\u{200c}"),
            keywords: &[
                "ବସ\u{b4d}",
                "ବ\u{b3e}ହ\u{b3e}ନ",
                "ମ\u{b3f}ନ\u{b3f} ବସ\u{b4d}",
                "ମ\u{b3f}ନ\u{b3f}ବସ\u{b4d}\u{200c}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਮਿਨੀ ਬ\u{a71}ਸ"),
            keywords: &["ਬ\u{a71}ਸ", "ਮਿਨੀ ਬ\u{a71}ਸ", "ਵਾਹਨ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("نیکی بس"),
            keywords: &["بس", "نیکی بس"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Míníbọs"),
            keywords: &["Bọs", "Mínibọs", "Míníbọs", "Smọ\u{301}lbọs"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("minibus"),
            keywords: &["busik", "minibus"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("کوچنی بس"),
            keywords: &["بس", "کوچنی بس"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("van"),
            keywords: &["van", "veículo", "ônibus"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("miniautocarro"),
            keywords: &["autocarro", "miniautocarro"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("minibus"),
            keywords: &["bus", "minibus"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("microbuz"),
            keywords: &["autobuz", "microbuz"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-932"),
            keywords: &["E10-932"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("микроавтобус"),
            keywords: &["газель", "маршрутка", "микроавтобус"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("minibisi"),
            keywords: &["bisi", "minibisi"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ننڍي بس"),
            keywords: &["بس", "ننڍي بس"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ම\u{dd2}න\u{dd2} බසය"),
            keywords: &["බසය", "ම\u{dd2}න\u{dd2} බසය", "ව\u{dcf}හනය"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("minibus"),
            keywords: &["autobus", "dopravný prostriedok", "minibus"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("minibus"),
            keywords: &["avtobus", "minibus", "vozilo"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("bas yar"),
            keywords: &["bas", "bas yar"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("autobus i vogël"),
            keywords: &["autobus", "autobus i vogël", "mjet"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("минибус"),
            keywords: &["aутoбус", "минибус"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["минибус"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("minibus"),
            keywords: &["autobus", "minibus"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["minibus"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("minibuss"),
            keywords: &["buss", "fordon", "minibuss"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("basi dogo"),
            keywords: &["basi", "basi dogo", "gari"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("சிற\u{bcd}றுந\u{bcd}து"),
            keywords: &["சிற\u{bcd}றுந\u{bcd}து", "மினி பஸ\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("తక\u{c4d}కువ పర\u{c3f}మ\u{c3e}ణ బస\u{c4d}సు"),
            keywords: &[
                "తక\u{c4d}కువ పర\u{c3f}మ\u{c3e}ణ బస\u{c4d}సు",
                "పర\u{c3f}మ\u{c3e}ణం",
                "బస\u{c4d}సు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("микроавтобус"),
            keywords: &["автобус", "микроавтобус"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ม\u{e34}น\u{e34}บ\u{e31}ส"),
            keywords: &["ม\u{e34}น\u{e34}บ\u{e31}ส", "ยานพาหนะ", "รถบ\u{e31}ส"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("mikroawtobus"),
            keywords: &["awtobus", "mikroawtobus"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("pasi iiki"),
            keywords: &["pasi iiki"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("minibüs"),
            keywords: &["minibüs", "otobüs", "taşıt"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("مىنىبۇس"),
            keywords: &["ئاپتوبۇس", "مىنىبۇس"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("мікроавтобус"),
            keywords: &["автобус", "мікроавтобус", "транспорт"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("منی بس"),
            keywords: &["بس", "سواری", "منی بس"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("minibus"),
            keywords: &["avtobus", "minibus", "transport"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("xe buýt nhỏ"),
            keywords: &["xe buýt", "xe buýt nhỏ"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("minikaar"),
            keywords: &["minikaar", "otokaar"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ibhasi encinci"),
            keywords: &["ibhasi", "ibhasi encinci"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ọkọ Akero Kekere"),
            keywords: &["Ọkọ Akero", "Ọkọ Akero Kekere"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("小巴"),
            keywords: &["小巴", "巴士"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("小巴"),
            keywords: &["小巴", "巴士"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("小巴"),
            keywords: &["公共汽车", "小巴"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("小型巴士"),
            keywords: &["小型巴士"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("小巴"),
            keywords: &["小巴"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ikhumbi"),
            keywords: &["ibhasi", "ikhumbi", "imoto"],
        },
    ],
};
#[doc = "🚑"]
pub const AMBULANCE: crate::Emoji = crate::Emoji {
    glyph: "🚑",
    codepoint: "1F691",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "ambulance",
    group: "Travel & Places",
    subgroup: "transport-ground",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("ambulans"),
            keywords: &["ambulans", "hospitaal", "voertuig"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("አምቡላንስ"),
            keywords: &["ተሽከርካሪ", "አምቡላንስ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("سيارة إسعاف"),
            keywords: &["سيارة إسعاف", "مركبة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("এম\u{9cd}ব\u{9c1}লেঞ\u{9cd}চ"),
            keywords: &["এম\u{9cd}ব\u{9c1}লেঞ\u{9cd}চ", "ব\u{9be}হন"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("təcili yardım maşını"),
            keywords: &["nəqliyyat", "təcili yardım maşını"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("хуткая дапамога"),
            keywords: &["103", "мігалка", "транспарт", "хуткая дапамога"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("линейка"),
            keywords: &["линейка", "превозно средство"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("অ\u{9cd}য\u{9be}ম\u{9cd}ব\u{9c1}লেন\u{9cd}স"),
            keywords: &[
                "অ\u{9cd}য\u{9be}ম\u{9cd}ব\u{9c1}লেন\u{9cd}স",
                "য\u{9be}নব\u{9be}হন",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("ambulañs"),
            keywords: &["ambulañs", "karbed"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("sanitet"),
            keywords: &["sanitet", "vozilo"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("ambulància"),
            keywords: &["ambulància", "emergència", "urgència", "vehicle"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏧᏂᏢᎩ ᏗᏯᏅᎯᏙᎯ"),
            keywords: &["ᏙᏆᎴᎵ", "ᏧᏂᏢᎩ ᏗᏯᏅᎯᏙᎯ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("sanitka"),
            keywords: &["ambulance", "sanitka", "vozidlo"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("ambiwlans"),
            keywords: &["ambiwlans", "cerbyd"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("ambulance"),
            keywords: &["ambulance", "køretøj"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Krankenwagen"),
            keywords: &["Krankenwagen", "Notfall"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ασθενοφόρο"),
            keywords: &["ασθενοφόρο", "όχημα"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("ambulance"),
            keywords: &["ambulance", "vehicle"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("ambulancia"),
            keywords: &["ambulancia", "asistencia médica", "transporte", "vehículo"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["ambulancia", "hospital", "transporte", "urgencia"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kiirabiauto"),
            keywords: &["kiirabiauto", "sõiduk"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("anbulantzia"),
            keywords: &["anbulantzia", "ibilgailu"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("آمبولانس"),
            keywords: &["آمبولانس", "وسیله\u{654} نقلیه"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("ambulanssi"),
            keywords: &["ajoneuvo", "ambulanssi", "auto"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("ambulansya"),
            keywords: &["ambulansya", "emergency", "sasakyan"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("sjúkrabilur"),
            keywords: &["bilur", "sjúkrabilur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("ambulance"),
            keywords: &["ambulance", "véhicule"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("otharcharr"),
            keywords: &["feithicil", "otharcharr"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("carbad-eiridinn"),
            keywords: &["carbad", "carbad-eiridinn"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("ambulancia"),
            keywords: &["ambulancia"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("એમ\u{acd}બ\u{acd}ય\u{ac1}લન\u{acd}સ"),
            keywords: &["એમ\u{acd}બ\u{acd}ય\u{ac1}લન\u{acd}સ", "વાહન"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("ambulan"),
            keywords: &["ambulan", "mota"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("אמבולנס"),
            keywords: &["אמבולנס", "חירום"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ए\u{902}ब\u{941}ल\u{947}\u{902}स"),
            keywords: &["ए\u{902}ब\u{941}ल\u{947}\u{902}स", "वाहन"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("ambulantno vozilo"),
            keywords: &["ambulantno vozilo", "vozilo"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("mentő"),
            keywords: &["jármű", "mentő"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("շտապօգնության մեքենա"),
            keywords: &["շտապ", "շտապօգնության մեքենա", "փոխադրամիջոց"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("ambulans"),
            keywords: &["ambulans", "kendaraan"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ụgbọala ụlọọgwụ\u{300}"),
            keywords: &["ụgbọala", "ụgbọala ụlọọgwụ\u{300}"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("sjúkrabíll"),
            keywords: &["sjúkrabifreið", "sjúkrabíll"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("ambulanza"),
            keywords: &["ambulanza", "veicolo"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("救急車"),
            keywords: &["乗り物", "救急車"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("ambulan"),
            keywords: &["ambulan", "tetumpakan"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("სასწრაფო მანქანა"),
            keywords: &["სასწრაფო მანქანა", "ტრანსპორტი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("жедел жәрдем"),
            keywords: &["жедел жәрдем", "көлік"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("ambulance"),
            keywords: &["ambulance", "køretøj"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ឡានពេទ\u{17d2}យ"),
            keywords: &[
                "រថយន\u{17d2}ត",
                "រថយន\u{17d2}តសង\u{17d2}គ\u{17d2}រោះបន\u{17d2}ទាន\u{17cb}",
                "ឡានពេទ\u{17d2}យ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಆಂಬುಲ\u{cc6}ನ\u{ccd}ಸ\u{ccd}"),
            keywords: &["ಆಂಬುಲ\u{cc6}ನ\u{ccd}ಸ\u{ccd}", "ವಾಹನ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("구급차"),
            keywords: &["구급차", "앰뷸런스"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("ऍम\u{94d}ब\u{94d}य\u{941}लन\u{94d}स"),
            keywords: &["ऍम\u{94d}ब\u{94d}य\u{941}लन\u{94d}स", "वाहन"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("тез жардам унаасы"),
            keywords: &["тез жардам унаасы", "унаа"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Ambulanz"),
            keywords: &["Ambulanz", "Gefier"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ລ\u{ebb}ດຄ\u{ebb}ນເຈ\u{eb1}ບ"),
            keywords: &["ພາຫະນະ", "ລ\u{ebb}ດຄ\u{ebb}ນເຈ\u{eb1}ບ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("greitosios pagalbos automobilis"),
            keywords: &["greitosios pagalbos automobilis", "transporto priemonė"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("ātrās palīdzības mašīna"),
            keywords: &["medicīna", "transports", "ārsts", "ātrās palīdzības mašīna"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("waka tūroro"),
            keywords: &["waka", "waka tūroro"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("амбуланта"),
            keywords: &["амбуланта", "возило"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ആംബ\u{d41}ലൻസ\u{d4d}"),
            keywords: &["ആംബ\u{d41}ലൻസ\u{d4d}", "വ\u{d3e}ഹനം"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("эмнэлгийн машин"),
            keywords: &["тээврийн хэрэгсэл", "эмнэлгийн машин"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("र\u{942}ग\u{94d}णवाहिका"),
            keywords: &["र\u{942}ग\u{94d}णवाहिका", "वाहन"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("ambulans"),
            keywords: &["ambulans", "kenderaan"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("ambulanza"),
            keywords: &["ambulanza", "vettura"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("လ\u{1030}နာတင\u{103a}ကား"),
            keywords: &["ယာဥ\u{103a}", "လ\u{1030}နာတင\u{103a}ကား"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("ambulanse"),
            keywords: &["ambulanse", "bil", "kjøretøy"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("एम\u{94d}ब\u{941}ल\u{947}न\u{94d}स"),
            keywords: &["एम\u{94d}ब\u{941}ल\u{947}न\u{94d}स", "गाडी"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("ambulance"),
            keywords: &["ambulance", "voertuig"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("ambulanse"),
            keywords: &["ambulanse", "bil", "køyretøy"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଆମ\u{b4d}ବ\u{b41}ଲ\u{b3e}ନ\u{b4d}ସ"),
            keywords: &[
                "ଆମ\u{b4d}ବ\u{b41}ଲ\u{b3e}ନ\u{b4d}ସ",
                "ଆମ\u{b4d}ଵ\u{b41}ଲେନ\u{b4d}ସ",
                "ବ\u{b3e}ହ\u{b3e}ନ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਐ\u{a02}ਬ\u{a42}ਲ\u{a47}\u{a02}ਸ"),
            keywords: &["ਐ\u{a02}ਬ\u{a42}ਲ\u{a47}\u{a02}ਸ", "ਵਾਹਨ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ایمبولینس"),
            keywords: &["ایمبولینس", "گڈی"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Ámbúlans"),
            keywords: &["Móto", "Ámbúlans"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("karetka pogotowia"),
            keywords: &[
                "ambulans",
                "erka",
                "karetka",
                "karetka pogotowia",
                "pogotowie",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("امبولانس"),
            keywords: &["امبولانس", "ګاړی"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("ambulância"),
            keywords: &["ambulância", "veículo"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("ambulancia"),
            keywords: &["ambulancia", "carru"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("ambulanță"),
            keywords: &["ambulanță", "asistență", "medicală", "vehicul"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-933"),
            keywords: &["E10-933"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("машина скорой помощи"),
            keywords: &[
                "больница",
                "врачи",
                "машина",
                "машина скорой помощи",
                "помощь",
                "скорая помощь",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("imbangukiragutabara"),
            keywords: &["imbangukiragutabara", "imodoka"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ايمبولينس"),
            keywords: &["ايمبولينس", "گاڏي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ග\u{dd2}ලන\u{dca} රථය"),
            keywords: &["ග\u{dd2}ලන\u{dca} රථය", "ව\u{dcf}හනය"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("sanitka"),
            keywords: &["dopravný prostriedok", "sanitka"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("reševalno vozilo"),
            keywords: &["reševalno vozilo", "vozilo"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("ambalaas"),
            keywords: &["ambalaas", "gaari"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("ambulancë"),
            keywords: &["ambulancë", "mjet udhëtimi"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("хитна помоћ"),
            keywords: &["вoзилo", "хитна помоћ"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("hitna pomoć"),
            keywords: &["hitna pomoć", "vozilo"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("ambulans"),
            keywords: &["ambulans", "fordon"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("ambulansi"),
            keywords: &["ambulansi", "gari"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ஆம\u{bcd}புலன\u{bcd}ஸ\u{bcd}"),
            keywords: &[
                "அவசரம\u{bcd}",
                "ஆம\u{bcd}புலன\u{bcd}ஸ\u{bcd}",
                "வ\u{bbe}கனம\u{bcd}",
                "விபத\u{bcd}து",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("అంబుల\u{c46}న\u{c4d}స\u{c4d}"),
            keywords: &["అంబుల\u{c46}న\u{c4d}స\u{c4d}", "వ\u{c3e}హనం"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("мошини ёрии таъҷилӣ"),
            keywords: &["мошини ёрии таъҷилӣ", "нақлиёт"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("รถพยาบาล"),
            keywords: &["ยานพาหนะ", "รถพยาบาล"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("tiz kömek ulagy"),
            keywords: &["tiz kömek ulagy", "ulag"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("meʻalele falemahaki"),
            keywords: &["meʻalele falemahaki"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("ambulans"),
            keywords: &["ambulans", "taşıt"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("قۇتقۇزۇش ماشىنىسى"),
            keywords: &["ئاپتوموبىل", "قۇتقۇزۇش ماشىنىسى"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("автомобіль швидкої допомоги"),
            keywords: &["автомобіль швидкої допомоги", "транспорт"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ایمبولنس"),
            keywords: &["ایمبولنس", "سواری"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("tez yordam mashinasi"),
            keywords: &["tez yordam mashinasi", "transport"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("xe cứu thương"),
            keywords: &["xe cộ", "xe cứu thương"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("àmbilaas"),
            keywords: &["waruwaay", "àmbilaas"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("iambulensi"),
            keywords: &["iambulensi", "inqwelo-mafutha"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ọkọ Alaisan"),
            keywords: &["nṣe ọkọ\u{301}", "Ọkọ Alaisan"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("救護車"),
            keywords: &["救護車", "車輛"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("救护车"),
            keywords: &["救护车", "车辆"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("救护车"),
            keywords: &["急救", "救护车"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("救護車"),
            keywords: &["救護車"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("i-ambulense"),
            keywords: &["i-ambulense", "imoto"],
        },
    ],
};
#[doc = "🚒"]
pub const FIRE_ENGINE: crate::Emoji = crate::Emoji {
    glyph: "🚒",
    codepoint: "1F692",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "fire engine",
    group: "Travel & Places",
    subgroup: "transport-ground",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("brandweerwa"),
            keywords: &["brand", "brandweer", "brandweerwa", "voertuig", "wa"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የእሳት አደጋ መኪና"),
            keywords: &["ሞተር", "ተሽከርካሪ", "እሳት", "የእሳት አደጋ መኪና", "የጭነት መኪና"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("سيارة إطفاء"),
            keywords: &["إطفاء", "سيارة إطفاء", "سيارة حريق", "مركبة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ফ\u{9be}য\u{9bc}\u{9be}ৰ ইঞ\u{9cd}জিন"),
            keywords: &[
                "ইঞ\u{9cd}জিন",
                "জ\u{9c1}ই",
                "ট\u{9cd}ৰ\u{9be}ক",
                "ফ\u{9be}য\u{9bc}\u{9be}ৰ ইঞ\u{9cd}জিন",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("yanğınsöndürən"),
            keywords: &[
                "mühərrik",
                "nəqliyyat",
                "yanğın",
                "yanğınsöndürən",
                "yük maşını",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("пажарная машына"),
            keywords: &["101", "грузавік", "мігалка", "пажар", "пажарная машына"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("пожарен автомобил"),
            keywords: &[
                "камион",
                "пожарен",
                "пожарен автомобил",
                "превозно средство",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("আগ\u{9c1}নের ইঞ\u{9cd}জিন"),
            keywords: &[
                "আগ\u{9c1}ন",
                "আগ\u{9c1}নের ইঞ\u{9cd}জিন",
                "ইঞ\u{9cd}জিন",
                "ট\u{9cd}র\u{9be}ক",
                "য\u{9be}নব\u{9be}হন",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("sammgarr pomperien"),
            keywords: &["pomper", "sammgarr pomperien"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("vatrogasna kola"),
            keywords: &["kamion", "vatra", "vatrogasna kola", "vozilo"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cotxe de bombers"),
            keywords: &["bombers", "camió de bombers", "cotxe", "cotxe de bombers"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏥᎳ ᎠᏥᎸ ᎠᏂᎩᏍᎩ"),
            keywords: &["ᎠᏥᎳ", "ᎠᏥᎳ ᎠᏥᎸ ᎠᏂᎩᏍᎩ", "ᎠᏦᏙᏗ", "ᎪᏗᎢ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("hasičské auto"),
            keywords: &[
                "hasiči",
                "hasičské auto",
                "oheň",
                "požár",
                "požárníci",
                "vozidlo",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("peiriant tân"),
            keywords: &["cerbyd", "peiriant", "tân"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("brandbil"),
            keywords: &["brand", "brandbil", "køretøj"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Feuerwehrauto"),
            keywords: &["Brand", "Feuerwehrauto", "Löschfahrzeug"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("πυροσβεστικό"),
            keywords: &["πυροσβεστικό", "φορτηγό", "όχημα"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("fire engine"),
            keywords: &["engine", "fire", "truck"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("fire truck"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("fire truck"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("coche de bomberos"),
            keywords: &[
                "camión",
                "camión de bomberos",
                "coche de bomberos",
                "fuego",
                "vehículo",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("camión de bomberos"),
            keywords: &[
                "bomberos",
                "camión",
                "camión de bomberos",
                "carro",
                "transporte",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("tuletõrjeauto"),
            keywords: &["auto", "sõiduk", "tuletõrje", "tuletõrjeauto"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("suhiltzaileen kamioia"),
            keywords: &["ibilgailu", "kamioi", "su", "suhiltzaileen kamioia"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("ماشین آتش\u{200c}نشانی"),
            keywords: &[
                "آتش",
                "ماشین آتش\u{200c}نشانی",
                "موتور",
                "وسیله\u{654} نقلیه",
                "کامیون",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("paloauto"),
            keywords: &["ajoneuvo", "auto", "paloauto", "tulipalo"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("fire truck"),
            keywords: &["emergency", "fire truck", "sasakyan", "sunog", "truck"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("sløkkibilur"),
            keywords: &["bilur", "eldur", "sløkkibilur", "sløkkilið"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("camion de pompier"),
            keywords: &["camion de pompier", "pompier"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &[
                "autopompe",
                "camion",
                "camion de pompier",
                "incendie",
                "pompier",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("inneall dóiteáin"),
            keywords: &[
                "dóiteán",
                "feithicil",
                "inneall",
                "inneall dóiteáin",
                "tine",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("einnsean-smàlaidh"),
            keywords: &[
                "einnsean",
                "einnsean-smàlaidh",
                "làraidh",
                "smàladh",
                "teine",
                "truca",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("coche de bombeiros"),
            keywords: &["bombeiros", "camión", "coche de bombeiros"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ફાયર એન\u{acd}જિન"),
            keywords: &["એન\u{acd}જિન", "ફાયર", "ફાયર ટ\u{acd}રક", "વાહન"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("injin wuta"),
            keywords: &["babbar mota", "inji", "injin wuta", "wuta"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("כבאית"),
            keywords: &["חירום", "כבאית", "כיבוי אש", "מכבי אש", "שריפה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("अग\u{94d}निशामक, दमकल"),
            keywords: &[
                "अग\u{94d}निशामक",
                "अग\u{94d}निशामक, दमकल",
                "आग",
                "इ\u{902}जन",
                "दमकल",
                "फ\u{93c}ायर ट\u{94d}रक",
                "वाहन",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("vatrogasno vozilo"),
            keywords: &["kamion", "vatra", "vatrogasno vozilo", "vozilo"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("tűzoltóautó"),
            keywords: &["jármű", "tűzoltóautó", "tűzoltóság"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("հրշեջ մեքենա"),
            keywords: &[
                "բեռնատար",
                "հրդեհ",
                "հրշեջ մեքենա",
                "փոխադրամիջոց",
                "քարշակ",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("mobil pemadam kebakaran"),
            keywords: &[
                "api",
                "kendaraan",
                "mesin",
                "mobil pemadam kebakaran",
                "truk",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("injin ọkụ"),
            keywords: &["injin", "ọkụ", "ụgbọala ibu"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("slökkviliðsbíll"),
            keywords: &["brunabíll", "slökkvibíll", "slökkvilið", "slökkviliðsbíll"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("camion dei pompieri"),
            keywords: &["autopompa", "camion dei pompieri", "veicolo"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("消防車"),
            keywords: &["乗り物", "消防車"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("blamwir"),
            keywords: &["blamwir", "kobongan", "trek"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("სახანძრო მანქანა"),
            keywords: &["მანქანა", "სატვირთო", "სახანძრო", "ტრანსპორტი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("өрт сөндіру автокөлігі"),
            keywords: &[
                "жүк көлігі",
                "көлік",
                "сөндіру",
                "өрт",
                "өрт сөндіру автокөлігі",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("brandbil"),
            keywords: &["brand", "brandbil", "køretøj"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("រថយន\u{17d2}តពន\u{17d2}លត\u{17cb}អគ\u{17d2}គ\u{17b8}ភ\u{17d0}យ"),
            keywords: &[
                "ម\u{17c9}ាស\u{17ca}\u{17b8}ន",
                "រថយន\u{17d2}ត",
                "រថយន\u{17d2}តពន\u{17d2}លត\u{17cb}អគ\u{17d2}គ\u{17b8}ភ\u{17d0}យ",
                "អគ\u{17d2}គ\u{17b7}ភ\u{17d0}យ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಅಗ\u{ccd}ನ\u{cbf}ಶಾಮಕ ದಳ"),
            keywords: &[
                "ಅಗ\u{ccd}ನ\u{cbf}ಶಾಮಕ ಟ\u{ccd}ರಕ\u{ccd}",
                "ಅಗ\u{ccd}ನ\u{cbf}ಶಾಮಕ ದಳ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("소방차"),
            keywords: &["소방차", "엔진", "트럭", "화재"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("उज\u{94d}या इ\u{902}जिन"),
            keywords: &[
                "इ\u{902}जिन",
                "उजो",
                "उज\u{94d}या इ\u{902}जिन",
                "ट\u{94d}रक",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("өрт өчүргүчтөр унаасы"),
            keywords: &["кыймылдаткыч", "унаа", "өрт", "өрт өчүргүчтөр унаасы"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Pompjeeswon"),
            keywords: &["Camion", "Feier", "Motor", "Pompjeeswon"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ລ\u{ebb}ດດ\u{eb1}ບເພ\u{eb5}ງ"),
            keywords: &["ພາຫະນະ", "ລ\u{ebb}ດດ\u{eb1}ບເພ\u{eb5}ງ", "ໄຟໄໝ\u{ec9}"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("ugniagesių automobilis"),
            keywords: &["sunkvežimis", "ugniagesių automobilis", "ugnis", "variklis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("ugunsdzēsēju mašīna"),
            keywords: &["transports", "uguns", "ugunsdzēsēji", "ugunsdzēsēju mašīna"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("waka tinei ahi"),
            keywords: &["ahi", "mīhini", "taraka", "waka tinei ahi"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("противпожарно возило"),
            keywords: &["возило", "камион", "пожар", "противпожарно возило"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഫയർ എഞ\u{d4d}ചിൻ"),
            keywords: &[
                "എഞ\u{d4d}ചിൻ",
                "ഫയർ",
                "ഫയർ ട\u{d4d}രക\u{d4d}ക\u{d4d}",
                "വ\u{d3e}ഹനം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("галын машин"),
            keywords: &["ачааны машин", "гал", "галын машин", "хөдөлгүүр"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("अग\u{94d}निशामक गाडीच\u{947} इ\u{902}जिन"),
            keywords: &[
                "अग\u{94d}निशामक",
                "अग\u{94d}निशामक गाडी",
                "अग\u{94d}निशामक गाडीच\u{947} इ\u{902}जिन",
                "इ\u{902}जिन",
                "ट\u{94d}रक",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("kereta bomba"),
            keywords: &["api", "enjin", "kenderaan", "kereta bomba", "trak"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("vettura tat-tifi tan-nar"),
            keywords: &["magna", "nar", "trakk", "vettura tat-tifi tan-nar"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("မ\u{102e}းသတ\u{103a}ကား"),
            keywords: &[
                "ထရပ\u{103a}ကား",
                "မ\u{102e}း",
                "မ\u{102e}းသတ\u{103a}ကား",
                "အင\u{103a}ဂျင\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("brannbil"),
            keywords: &["bil", "brannbil", "kjøretøy"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("फायर इन\u{94d}जिन"),
            keywords: &["आगो", "इन\u{94d}जिन", "ट\u{94d}रक", "फायर इन\u{94d}जिन"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("brandweerauto"),
            keywords: &["auto", "brand", "brandweerauto", "voertuig"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("brannbil"),
            keywords: &["bil", "brannbil", "køyretøy"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଫ\u{b3e}ୟ\u{b3e}ର\u{b4d}\u{200c} ଇଞ\u{b4d}ଜ\u{b3f}ନ\u{b4d}\u{200c}"),
            keywords: &[
                "ଇଞ\u{b4d}ଜ\u{b3f}ନ\u{b4d}",
                "ଫ\u{b3e}ୟ\u{b3e}ର\u{b4d}",
                "ଫ\u{b3e}ୟ\u{b3e}ର\u{b4d} ଟ\u{b4d}ରକ\u{b4d}",
                "ବ\u{b3e}ହ\u{b3e}ନ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਫਾਇਰ ਇ\u{a70}ਜਣ"),
            keywords: &[
                "ਅ\u{a71}ਗ",
                "ਇ\u{a70}ਜਣ",
                "ਫਾਇਰ ਇ\u{a70}ਜਣ",
                "ਫਾਇਰ ਟਰ\u{a71}ਕ",
                "ਵਾਹਨ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("آگ آلا انجن"),
            keywords: &["آگ آلا انجن", "انجن", "اگ", "ٹرک"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Fáyá Ẹ\u{301}njin"),
            keywords: &["Fáya", "Fáyá Ẹ\u{301}njin", "Lọ\u{301}ri", "Ẹ\u{301}njin"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("samochód strażacki"),
            keywords: &[
                "pożar",
                "samochód strażacki",
                "straż pożarna",
                "wóz strażacki",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د اور وژونکی انجن"),
            keywords: &["انجن", "اور", "د اور وژونکی انجن", "ټرک"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("carro do corpo de bombeiros"),
            keywords: &[
                "caminhão do corpo de bombeiros",
                "carro",
                "carro do corpo de bombeiros",
                "fogo",
                "veículo",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("carro de bombeiros"),
            keywords: &["bombeiros", "camião", "carro", "carro de bombeiros"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("carru bomberospaq"),
            keywords: &["carru", "carru bomberospaq", "motor", "nina"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("mașină de pompieri"),
            keywords: &["incendiu", "mașină de pompieri", "salvare", "vehicul"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-934"),
            keywords: &["E10-934"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("пожарная машина"),
            keywords: &["машина", "пожарная", "пожарные"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("kizimyamoto"),
            keywords: &["ikamyo", "imashini", "kizimyamoto", "umuriro"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("باھ جي انجڻ"),
            keywords: &["انجڻ", "باه", "باھ جي انجڻ", "ٽرڪ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ග\u{dd2}න\u{dd2} න\u{dd2}ව\u{dd3}මේ රථය"),
            keywords: &[
                "එන\u{dca}ජ\u{dd2}ම",
                "ග\u{dd2}න\u{dd2}",
                "ග\u{dd2}න\u{dd2} න\u{dd2}ව\u{dd3}මේ රථය",
                "ට\u{dca}\u{200d}රක\u{dca} රථය",
                "ව\u{dcf}හනය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("hasičské auto"),
            keywords: &[
                "auto",
                "dopravný prostriedok",
                "hasiči",
                "hasičské auto",
                "oheň",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("gasilsko vozilo"),
            keywords: &["avto", "gasilsko", "požar", "vozilo"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("mashiinka dabka"),
            keywords: &["dab", "gaari xammuul", "mashiinka dabka", "matoor"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("zjarrfikëse"),
            keywords: &["kamion", "mjet", "motor", "zjarr", "zjarrfikëse"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("ватрогасни камион"),
            keywords: &["вaтрa", "вoзилo", "ватрогасни камион"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["ватрогасни камион"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("vatrogasni kamion"),
            keywords: &["vatra", "vatrogasni kamion", "vozilo"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["vatrogasni kamion"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("brandbil"),
            keywords: &["brandbil", "fordon"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("gari la zimamoto"),
            keywords: &["gari", "gari la zimamoto", "injini", "lori", "moto"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("த\u{bc0}யணைப\u{bcd}பு வ\u{bbe}கனம\u{bcd}"),
            keywords: &[
                "த\u{bc0}யணைப\u{bcd}பு வண\u{bcd}டி",
                "த\u{bc0}யணைப\u{bcd}பு வ\u{bbe}கனம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("అగ\u{c4d}న\u{c3f} మ\u{c3e}పక యంత\u{c4d}రం"),
            keywords: &[
                "అగ\u{c4d}న\u{c3f}",
                "అగ\u{c4d}న\u{c3f} మ\u{c3e}పక యంత\u{c4d}రం",
                "యంత\u{c4d}రం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("мошини сӯхторхомӯшкунӣ"),
            keywords: &[
                "мошини боркаш",
                "мошини сӯхторхомӯшкунӣ",
                "муҳаррик",
                "оташ",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("รถด\u{e31}บเพล\u{e34}ง"),
            keywords: &[
                "ยานพาหนะ",
                "รถ",
                "รถด\u{e31}บเพล\u{e34}ง",
                "สายด\u{e31}บเพล\u{e34}ง",
                "ไฟ",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ýangyn awtoulagy"),
            keywords: &[
                "hereketlendiriji",
                "ýangyn",
                "ýangyn awtoulagy",
                "ýük ulagy",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("meʻalele tāmateafi"),
            keywords: &["meʻalele tāmateafi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("itfaiye arabası"),
            keywords: &[
                "araba",
                "itfaiye arabası",
                "itfaiye kamyonu",
                "taşıt",
                "yangın",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئوت ئۆچۈرۈش ماشىنىسى"),
            keywords: &["ئوت", "ئوت ئۆچۈرۈش ماشىنىسى", "موتور", "يۈك ماشىنىسى"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("пожежна машина"),
            keywords: &["вантажівка", "двигун", "пожежна машина", "пожежний"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("فائر انجن"),
            keywords: &["انجن", "فائر", "ٹرک"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("o‘t o‘chirish mashinasi"),
            keywords: &[
                "motor",
                "o‘t o‘chirish mashinasi",
                "transport",
                "yong‘in",
                "yuk mashinasi",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("xe cứu hỏa"),
            keywords: &["lửa", "xe cứu hỏa", "xe tải", "động cơ"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("oto pompiyee"),
            keywords: &["fire", "motër", "oto pompiyee", "truk"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("injini yomlilo"),
            keywords: &["injini", "injini yomlilo", "itraka", "umlilo"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ẹnjini Onina"),
            keywords: &["iná", "Ẹnjini Onina", "ẹ\u{300}rọ", "ọkọ\u{300} akkrù ńlá"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("消防車"),
            keywords: &["卡車", "消防車", "火", "發動機"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("消防车"),
            keywords: &["卡车", "发动机", "消防车", "火"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("消防车"),
            keywords: &["救火车", "消防车"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("消防車"),
            keywords: &["消防車"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("injini yomlilo"),
            keywords: &[
                "iloli",
                "imoto",
                "injini",
                "injini yomlilo",
                "isicishamlilo",
                "umlilo",
            ],
        },
    ],
};
#[doc = "🚓"]
pub const POLICE_CAR: crate::Emoji = crate::Emoji {
    glyph: "🚓",
    codepoint: "1F693",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "police car",
    group: "Travel & Places",
    subgroup: "transport-ground",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("polisiemotor"),
            keywords: &["kar", "motor", "polisie", "polisiemotor", "voertuig"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የፖሊስ መኪና"),
            keywords: &["መኪና", "ተሽከርካሪ", "የፖሊስ መኪና", "ፓትሮል", "ፖሊስ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("سيارة شرطة"),
            keywords: &["سيارة دورية", "سيارة شرطة", "شرطة", "مركبة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("প\u{9c1}লিচৰ গ\u{9be}ড\u{9bc}ী"),
            keywords: &[
                "গ\u{9be}ড\u{9bc}ী",
                "প\u{9c1}লিচ",
                "প\u{9c1}লিচৰ গ\u{9be}ড\u{9bc}ী",
                "পেট\u{9cd}ৰ’ল",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("polis maşını"),
            keywords: &["maşın", "nəqliyyat", "patrul", "polis", "polis maşını"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("паліцэйская машына"),
            keywords: &[
                "102",
                "мігалка",
                "міліцыя",
                "паліцыя",
                "паліцэйская машына",
                "патруль",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("полицейска кола"),
            keywords: &[
                "автомобил",
                "патрулка",
                "полицейска кола",
                "полиция",
                "превозно средство",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("প\u{9c1}লিশের গ\u{9be}ড\u{9bc}ি"),
            keywords: &[
                "টহলদ\u{9be}রী",
                "প\u{9c1}লিশ",
                "প\u{9c1}লিশের গ\u{9be}ড\u{9bc}ি",
                "মোটরগ\u{9be}ড\u{9bc}ি",
                "য\u{9be}নব\u{9be}হন",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("karr polis"),
            keywords: &["karr polis", "polis"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("policijska kola"),
            keywords: &["auto", "patrola", "policija", "policijska kola", "vozilo"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cotxe de policia"),
            keywords: &["cotxe", "cotxe de policia", "policia"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏗᏓᏂᎩᏍᎩ ᏙᎴᎳ"),
            keywords: &["ᎤᎦᏛᏂᏙᎲᎢ", "ᏗᏓᏂᎩᏍᎩ ᏙᎴᎳ", "ᏗᏓᏂᏱᏍᎩ", "ᏙᏆᎴᎵ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("policejní auto"),
            keywords: &["auto", "hlídka", "policejní auto", "policie", "vozidlo"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("car yr heddlu"),
            keywords: &["car", "car yr heddlu", "cerbyd", "heddlu", "patrôl"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("politibil"),
            keywords: &["politi", "politibil"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Polizeiwagen"),
            keywords: &["Polizei", "Polizeiwagen", "Streifenwagen"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("περιπολικό"),
            keywords: &[
                "αστυνομία",
                "αυτοκίνητο",
                "περιπολία",
                "περιπολικό",
                "όχημα",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("police car"),
            keywords: &["car", "patrol", "police"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("coche de policía"),
            keywords: &["coche de policía", "coche patrulla", "policía", "vehículo"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("auto de policía"),
            keywords: &[
                "auto",
                "auto de policía",
                "patrullero",
                "policía",
                "transporte",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &[
                "auto",
                "auto de policía",
                "patrulla",
                "policía",
                "transporte",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("patrulla"),
            keywords: &["auto", "carro", "patrulla", "policía"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("politseiauto"),
            keywords: &["auto", "patrull", "politsei", "politseiauto", "sõiduk"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("poliziaren autoa"),
            keywords: &["auto", "ibilgailu", "polizia", "poliziaren autoa"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("ماشین پلیس"),
            keywords: &[
                "خودرو",
                "ماشین پلیس",
                "وسیله\u{654} نقلیه",
                "پاترول",
                "پلیس",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("poliisiauto"),
            keywords: &["ajoneuvo", "auto", "poliisi", "poliisiauto"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("sasakyan ng polis"),
            keywords: &[
                "patrol",
                "police car",
                "pulis",
                "pulisya",
                "sasakyan",
                "sasakyan ng polis",
                "sasakyan ng pulis",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("løgreglubilur"),
            keywords: &["bilur", "løgregla", "løgreglubilur", "politi"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("voiture de police"),
            keywords: &["police", "voiture de police"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["patrouille", "police", "voiture", "voiture de police"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("carr gardaí"),
            keywords: &[
                "carr gardaí",
                "carr patróil",
                "feithicil",
                "gardaí",
                "póilíní",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("càr poileis"),
            keywords: &["càr", "càr poileis", "freiceadan", "poileas"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("coche de policía"),
            keywords: &["coche", "coche de policía", "policía"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("પોલીસની કાર"),
            keywords: &[
                "પ\u{ac7}ટ\u{acd}રોલ કાર",
                "પોલીસ",
                "પોલીસ કાર",
                "પોલીસની કાર",
                "વાહન",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("motar ’yan sanda"),
            keywords: &["motar ’yan sanda", "patiri", "ƙaramar mota", "‘yan sanda"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("ניידת משטרה"),
            keywords: &["חירום", "משטרה", "ניידת", "פשע"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("प\u{941}लिस कार"),
            keywords: &["गश\u{94d}ती दल", "प\u{941}लिस", "प\u{941}लिस कार", "वाहन"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("policijski automobil"),
            keywords: &[
                "automobil",
                "patrola",
                "policija",
                "policijski automobil",
                "vozilo",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("rendőrautó"),
            keywords: &["autó", "jármű", "járőrautó", "rendőrautó", "rendőrség"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ոստիկանական մեքենա"),
            keywords: &[
                "ավտոմեքենա",
                "ճո մեքենա",
                "ոստիկանական մեքենա",
                "ոստիկանություն",
                "պարեկ",
                "փոխադրամիջոց",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("mobil polisi"),
            keywords: &["kendaraan", "mobil", "patroli", "polisi"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ụgbọala ndị uweojii"),
            keywords: &["ndị uwe ojii", "ngagharị", "ụgbọala", "ụgbọala ndị uweojii"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("lögreglubíll"),
            keywords: &["lögregla", "lögreglubifreið", "lögreglubíll"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("macchina della polizia"),
            keywords: &[
                "auto",
                "macchina",
                "macchina della polizia",
                "polizia",
                "veicolo",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("パトカー"),
            keywords: &["パトカー", "乗り物", "警察"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("montor pulisi"),
            keywords: &["montor", "patroli", "pulisi"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("პოლიციის მანქანა"),
            keywords: &[
                "მანქანა",
                "პატრული",
                "პოლიცია",
                "პოლიციის მანქანა",
                "ტრანსპორტი",
            ],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("Takerrust n temsulta"),
            keywords: &["Takerrust n temsulta"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("полиция автокөлігі"),
            keywords: &[
                "автокөлік",
                "көлік",
                "патруль",
                "полиция",
                "полиция автокөлігі",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("politibil"),
            keywords: &["politi", "politibil"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ឡានប\u{17c9}\u{17bc}ល\u{17b8}ស"),
            keywords: &[
                "ប\u{17c9}\u{17bc}ល\u{17b8}ស",
                "យាមល\u{17d2}បាត",
                "រថយន\u{17d2}ត",
                "ឡានប\u{17c9}\u{17bc}ល\u{17b8}ស",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಪೊಲೀಸ\u{ccd} ಕಾರು"),
            keywords: &["ಆರಕ\u{ccd}ಷಕ ಕಾರು", "ಗಸ\u{ccd}ತು ಕಾರು", "ಪೊಲೀಸ\u{ccd} ಕಾರು"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("경찰차"),
            keywords: &["경찰", "경찰차"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("पोलिस कार"),
            keywords: &["कार", "गस\u{94d}त", "पोलिस कार", "पोलीस"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("милиция унаасы"),
            keywords: &["кайгуул", "машина", "милиция", "милиция унаасы", "унаа"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Policeauto"),
            keywords: &["Auto", "Patrull", "Police", "Policeauto"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ລ\u{ebb}ດຕຳຫ\u{ebc}ວດ"),
            keywords: &["ພາຫະນະ", "ລາດຕະເວນ", "ລ\u{ebb}ດຕຳຫ\u{ebc}ວດ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("policijos automobilis"),
            keywords: &[
                "automobilis",
                "patruliai",
                "policija",
                "policijos automobilis",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("policijas mašīna"),
            keywords: &[
                "automašīna",
                "mašīna",
                "policija",
                "policijas mašīna",
                "transports",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("waka pirihimana"),
            keywords: &["motokā", "pirihimana", "tira", "waka pirihimana"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("полициски автомобил"),
            keywords: &[
                "автомобил",
                "возило",
                "патрола",
                "полициски автомобил",
                "полиција",
            ],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("പൊലീസ\u{d4d} ക\u{d3e}ർ"),
            keywords: &[
                "പട\u{d4d}രോൾ ക\u{d3e}ർ",
                "പൊലീസ\u{d4d}",
                "പൊലീസ\u{d4d} ക\u{d3e}ർ",
                "വ\u{d3e}ഹനം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("цагдаагийн машин"),
            keywords: &["машин", "цагдаа", "цагдаагийн машин"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("पोलिसा\u{902}ची गाडी"),
            keywords: &[
                "कार",
                "गस\u{94d}त घालण\u{947}",
                "पोलिस",
                "पोलिसा\u{902}ची कार",
                "पोलिसा\u{902}ची गाडी",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("kereta polis"),
            keywords: &["kenderaan", "kereta", "polis", "ronda"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("karozza tal-pulizija"),
            keywords: &["karozza", "karozza tal-pulizija", "pulizija", "ronda"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ရ\u{1032}ကား"),
            keywords: &[
                "ကင\u{103a}းလ\u{103e}ည\u{1037}\u{103a}",
                "ရ\u{1032}",
                "ရ\u{1032}ကား",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("politibil"),
            keywords: &["bil", "kjøretøy", "politibil"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("प\u{941}लिस कार"),
            keywords: &["कार", "गाडी", "प\u{941}लिस", "प\u{947}ट\u{94d}रोल"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("politieauto"),
            keywords: &["auto", "politie", "politieauto", "politiewagen"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("politibil"),
            keywords: &["bil", "køyretøy", "politibil"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ପୋଲ\u{b3f}ସ\u{b4d} କ\u{b3e}ର\u{b4d}\u{200c}"),
            keywords: &[
                "କ\u{b3e}ର\u{b4d}\u{200c}",
                "ପେଟ\u{b4d}ରୋଲ\u{b4d}\u{200c}",
                "ପୋଲ\u{b3f}ସ\u{b4d}\u{200c}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਪ\u{a41}ਲਿਸ ਕਾਰ"),
            keywords: &["ਗਸ\u{a3c}ਤ ਕਾਰ", "ਪ\u{a41}ਲਿਸ", "ਪ\u{a41}ਲਿਸ ਕਾਰ", "ਵਾਹਨ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("پ\u{64f}لس دی کار"),
            keywords: &["پ\u{64f}لس", "پ\u{64f}لس دی کار", "پیٹرول", "کار"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Polís Móto"),
            keywords: &["Kaa", "Móto", "Patrol", "Polis", "Polís Móto"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("samochód policyjny"),
            keywords: &["patrol", "policja", "samochód policyjny"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("دپولیس موټر"),
            keywords: &["دپولیس موټر", "موټر", "پوليس", "ګشت"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("viatura policial"),
            keywords: &["carro patrulha", "polícia", "veículo", "viatura policial"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("carro da polícia"),
            keywords: &["carro", "carro da polícia", "patrulha", "polícia"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("policia carru"),
            keywords: &["carru", "paco", "patrulla", "policia carru"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("mașină de poliție"),
            keywords: &["autovehicul", "mașină de poliție", "patrula", "poliție"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-935"),
            keywords: &["E10-935"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("полицейская машина"),
            keywords: &["машина", "полицейская машина", "полицейские", "полиция"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("imodoka ya polisi"),
            keywords: &["imodoka", "imodoka ya polisi", "irondo", "polisi"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("پوليس ڪار"),
            keywords: &["پوليس", "ڪار", "گشت"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("පොල\u{dd2}ස\u{dca} මෝටර\u{dca} රථය"),
            keywords: &[
                "පොල\u{dd2}ස\u{dca} මෝටර\u{dca} රථය",
                "පොල\u{dd3}ස\u{dd2}ය",
                "ම\u{dd4}ර සංච\u{dcf}ර",
                "මෝටර\u{dca} රථය",
                "ව\u{dcf}හනය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("policajné auto"),
            keywords: &[
                "auto",
                "dopravný prostriedok",
                "hliadka",
                "policajné auto",
                "polícia",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("policijsko vozilo"),
            keywords: &[
                "avto",
                "patruljno",
                "policija",
                "policijsko vozilo",
                "vozilo",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("gaari boolis"),
            keywords: &["boolis", "gaari", "ilaalinta"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("makinë policie"),
            keywords: &["makinë", "makinë policie", "mjet", "patrullë", "polici"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("полицијски аутомобил"),
            keywords: &["aутoмoбил", "пaтрoлa", "пoлициja", "полицијски аутомобил"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["полицијски аутомобил"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("policijski automobil"),
            keywords: &["automobil", "patrola", "policija", "policijski automobil"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["policijski automobil"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("polisbil"),
            keywords: &["fordon", "polis", "polisbil"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("gari la polisi"),
            keywords: &["gari", "gari la polisi", "polisi", "ziara"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("போல\u{bc0}ஸ\u{bcd} வண\u{bcd}டி"),
            keywords: &[
                "போல\u{bc0}ஸ\u{bcd} க\u{bbe}ர\u{bcd}",
                "போல\u{bc0}ஸ\u{bcd} வண\u{bcd}டி",
                "ரோந\u{bcd}து வண\u{bcd}டி",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ప\u{c4b}ల\u{c40}సు వ\u{c3e}హనం"),
            keywords: &["ప\u{c4b}ల\u{c40}సు", "వ\u{c3e}హనం"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("мошини пулис"),
            keywords: &["мошин", "мошини пулис", "посбон", "пулис"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("รถตำรวจ"),
            keywords: &[
                "ตรวจการณ\u{e4c}",
                "ตำรวจ",
                "ยานพาหนะ",
                "รถตำรวจ",
                "รถยนต\u{e4c}",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("polisiýa awtoulagy"),
            keywords: &["awtoulag", "patrul", "polisiýa", "polisiýa awtoulagy"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("meʻalele polisi"),
            keywords: &["meʻalele polisi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("polis arabası"),
            keywords: &["devriye arabası", "polis", "polis arabası", "taşıt"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ساقچى ماشىنىسى"),
            keywords: &["ساقچى", "ساقچى ماشىنىسى", "ماشىنا", "چارلاش"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("поліцейська машина"),
            keywords: &[
                "автомобіль",
                "патруль",
                "поліцейська машина",
                "поліцейський автомобіль",
                "поліція",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("پولیس کار"),
            keywords: &["پولیس", "پولیس کار", "گاڑی"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("politsiya mashinasi"),
            keywords: &[
                "mashina",
                "patrul",
                "politsiya",
                "politsiya mashinasi",
                "transport",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("xe cảnh sát"),
            keywords: &["cảnh sát", "tuần tra", "xe cảnh sát", "xe hơi"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("oto poliis"),
            keywords: &["oto", "patrol", "poliis"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("imoto yamapolisa"),
            keywords: &["imoto", "imoto yamapolisa", "ipolisa", "ukugada"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ọkọ Ọlọpa"),
            keywords: &["olùṣọ\u{301}", "Ọkọ Ọlọpa", "ọkọ\u{300}", "ọlọ\u{301}pàá"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("警車"),
            keywords: &["巡邏", "汽車", "警察", "警車"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("警车"),
            keywords: &["巡逻", "汽车", "警察", "警车"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("警车"),
            keywords: &["巡逻", "警察", "警车"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("警車"),
            keywords: &["警車"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("imoto yamaphoyisa"),
            keywords: &["amaphoyisa", "imoto", "imoto yamaphoyisa", "ukuqapha"],
        },
    ],
};
#[doc = "🚔"]
pub const ONCOMING_POLICE_CAR: crate::Emoji = crate::Emoji {
    glyph: "🚔",
    codepoint: "1F694",
    status: crate::Status::FullyQualified,
    introduction_version: 0.7f32,
    name: "oncoming police car",
    group: "Travel & Places",
    subgroup: "transport-ground",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("aankomende polisiemotor"),
            keywords: &[
                "aankomend",
                "aankomende polisiemotor",
                "kar",
                "motor",
                "polisie",
                "voertuig",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("መጪ የፖሊስ መኪና"),
            keywords: &["መኪና", "መጪ", "መጪ የፖሊስ መኪና", "ተሽከርካሪ", "ፖሊስ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("سيارة شرطة مقتربة"),
            keywords: &["سيارة شرطة", "سيارة شرطة مقتربة", "شرطة", "مركبة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("আহি থক\u{9be} প\u{9c1}লিচৰ গ\u{9be}ড\u{9bc}ী"),
            keywords: &[
                "আহি থক\u{9be}",
                "আহি থক\u{9be} প\u{9c1}লিচৰ গ\u{9be}ড\u{9bc}ী",
                "গ\u{9be}ড\u{9bc}ী",
                "প\u{9c1}লিচ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("yaxınlaşan polis maşını"),
            keywords: &[
                "maşın",
                "nəqliyyat",
                "polis",
                "yaxınlaşan polis maşını",
                "yaxınlaşma",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("набліжаецца паліцэйская машына"),
            keywords: &[
                "102",
                "мігалка",
                "міліцыя",
                "набліжаецца паліцэйская машына",
                "набліжэнне",
                "паліцыя",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("приближаваща полицейска кола"),
            keywords: &[
                "автомобил",
                "полиция",
                "превозно средство",
                "приближаващ",
                "приближаваща полицейска кола",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("অগ\u{9cd}রসরম\u{9be}ন প\u{9c1}লিশের গ\u{9be}ড\u{9bc}ি"),
            keywords: &[
                "অগ\u{9cd}রসরম\u{9be}ন",
                "অগ\u{9cd}রসরম\u{9be}ন প\u{9c1}লিশের গ\u{9be}ড\u{9bc}ি",
                "প\u{9c1}লিশ",
                "মোটরগ\u{9be}ড\u{9bc}ি",
                "য\u{9be}নব\u{9be}হন",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("dolazeća policijska kola"),
            keywords: &["auto", "dolazeća policijska kola", "policija", "vozilo"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cotxe de policia que arriba"),
            keywords: &[
                "cotxe",
                "cotxe de policia de cara",
                "cotxe de policia que arriba",
                "policia",
                "proper",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏂᏓᏳᏍᏗᏛ ᏗᏓᏂᎩᏍᎩ ᏙᎴᎳ"),
            keywords: &["ᏂᏓᏳᏍᏗᏛ", "ᏂᏓᏳᏍᏗᏛ ᏗᏓᏂᎩᏍᎩ ᏙᎴᎳ", "ᏗᏓᏂᏱᏍᎩ", "ᏙᏆᎴᎵ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("přijíždějící policejní auto"),
            keywords: &[
                "auto",
                "policie",
                "přijíždějící",
                "přijíždějící policejní auto",
                "příjezd",
                "vozidlo",
                "vůz",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("car heddlu sy’n dod i’ch cwrdd"),
            keywords: &[
                "car",
                "car heddlu sy’n dod i’ch cwrdd",
                "dod i’ch cwrdd",
                "heddlu",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("politibil forfra"),
            keywords: &["kørende politibil", "politi", "politibil forfra"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Vorderansicht Polizeiwagen"),
            keywords: &["Polizei", "Streifenwagen", "Vorderansicht Polizeiwagen"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("διερχόμενο περιπολικό"),
            keywords: &[
                "αστυνομία",
                "αυτοκίνητο",
                "διερχόμενο",
                "διερχόμενο περιπολικό",
                "όχημα",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("oncoming police car"),
            keywords: &["car", "oncoming", "police"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("coche de policía próximo"),
            keywords: &[
                "coche de policía próximo",
                "coche patrulla",
                "policía",
                "próximo",
                "vehículo",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("patrullero se aproxima"),
            keywords: &[
                "auto",
                "patrullero",
                "patrullero se aproxima",
                "policía",
                "transporte",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("patrulla se aproxima"),
            keywords: &["patrulla se aproxima"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("patrulla se aproxima"),
            keywords: &["auto", "carro", "patrulla se aproxima", "policía"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("politseiauto eestvaates"),
            keywords: &[
                "auto",
                "eestvaade",
                "politsei",
                "politseiauto eestvaates",
                "sõiduk",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("heldu den poliziaren autoa"),
            keywords: &["autoa", "heldu", "heldu den poliziaren autoa", "polizia"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("ماشین پلیسی که نزدیک می\u{200c}شود"),
            keywords: &[
                "خودرو",
                "درحال آمدن",
                "ماشین پلیسی که نزدیک می\u{200c}شود",
                "نزدیک\u{200c}شونده",
                "وسیله\u{654} نقلیه",
                "پلیس",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("saapuva poliisiauto"),
            keywords: &[
                "ajoneuvo",
                "auto",
                "poliisi",
                "saapuva poliisiauto",
                "vastaantuleva",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("paparating na police car"),
            keywords: &[
                "paparating",
                "paparating na police car",
                "patrol",
                "pulis",
                "pulisya",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("gron á løgreglubili"),
            keywords: &["bilur", "gron á løgreglubili", "løgregla", "politi"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("voiture de police de face"),
            keywords: &["police", "voiture de police de face"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["de face", "police", "voiture", "voiture de police de face"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("carr gardaí ag teacht"),
            keywords: &[
                "carr gardaí",
                "carr gardaí ag teacht",
                "feithicil",
                "gardaí",
                "póilíní",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("càr poileis a’ tighinn thugad"),
            keywords: &["càr", "càr poileis a’ tighinn thugad", "poileas", "tighinn"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("coche de policía de fronte"),
            keywords: &["coche", "coche de policía de fronte", "policía"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("આવી રહ\u{ac7}લ પોલીસ કાર"),
            keywords: &[
                "આવનારી પોલીસ કાર",
                "આવી રહ\u{ac7}લ પોલીસ કાર",
                "પોલીસ",
                "પોલીસ કાર",
                "વાહન",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("motar ’yan sanda mai zuwa"),
            keywords: &[
                "mai zuwa",
                "motar ’yan sanda mai zuwa",
                "ƙaramar motar",
                "’yan sanda",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("ניידת משטרה מלפנים"),
            keywords: &["חירום", "משטרה", "ניידת", "ניידת משטרה מלפנים", "פשע"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("आती ह\u{941}ई प\u{941}लिस कार"),
            keywords: &[
                "आती ह\u{941}ई प\u{941}लिस कार",
                "प\u{941}लिस",
                "प\u{941}लिस कार",
                "वाहन",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("policijski automobil u dolasku"),
            keywords: &[
                "automobil",
                "dolazak",
                "policija",
                "policijski automobil u dolasku",
                "vozilo",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("érkező rendőrautó"),
            keywords: &[
                "autó",
                "jármű",
                "járőrautó",
                "rendőrség",
                "érkező",
                "érkező rendőrautó",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("մոտեցող ոստիկանական մեքենա"),
            keywords: &[
                "ավտոմեքենա",
                "մոտեցող",
                "մոտեցող ոստիկանական մեքենա",
                "ոստիկանություն",
                "փոխադրամիջոց",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("mobil polisi datang"),
            keywords: &["datang", "kendaraan", "mobil", "polisi"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ụgbọala ndị uweojii na-apụta apụta"),
            keywords: &[
                "na-apụta apụta",
                "ndị uwe ojii",
                "ụgbọala",
                "ụgbọala ndị uweojii na-apụta apụta",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("lögreglubíll á móti"),
            keywords: &[
                "lögregla",
                "lögreglubifreið",
                "lögreglubíll",
                "lögreglubíll á móti",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("macchina della polizia in arrivo"),
            keywords: &[
                "auto",
                "macchina",
                "macchina della polizia in arrivo",
                "polizia",
                "veicolo",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("パトカー正面"),
            keywords: &["パトカー", "パトカー正面", "乗り物", "警察"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("montor pulisi katon mara"),
            keywords: &["mara", "montor", "montor pulisi katon mara", "pulisi"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მომავალი პოლიციის მანქანა"),
            keywords: &[
                "მანქანა",
                "მომავალი",
                "მომავალი პოლიციის მანქანა",
                "პოლიცია",
                "ტრანსპორტი",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("келе жатқан полиция автокөлігі"),
            keywords: &[
                "автокөлік",
                "келе жатыр",
                "келе жатқан полиция автокөлігі",
                "көлік",
                "полиция",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("politibil forfra"),
            keywords: &["kørende politibil", "politi", "politibil forfra"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ឡានប\u{17c9}\u{17bc}ល\u{17b8}សមើលព\u{17b8}ម\u{17bb}ខ"),
            keywords: &[
                "ច\u{17c6}ព\u{17b8}ម\u{17bb}ខ",
                "ប\u{17c9}\u{17bc}ល\u{17b8}ស",
                "រថយន\u{17d2}ត",
                "ឡានប\u{17c9}\u{17bc}ល\u{17b8}សមើលព\u{17b8}ម\u{17bb}ខ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಮುಂಂದ\u{cc6} ಬರುತ\u{ccd}ತ\u{cbf}ರುವ ಪೊಲೀಸ\u{ccd} ಕಾರು"),
            keywords: &[
                "ಆರಕ\u{ccd}ಷಕ ಕಾರು",
                "ಮುಂಂದ\u{cc6} ಬರುತ\u{ccd}ತ\u{cbf}ರುವ ಪೊಲೀಸ\u{ccd} ಕಾರು",
                "ಮುನ\u{ccd}ನುಗ\u{ccd}ಗ\u{cbf} ಬರುವ ಆರಕ\u{ccd}ಷಕ ಕಾರು",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("오고 있는 경찰차"),
            keywords: &["경찰", "경찰차", "오고 있는 경찰차"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("य\u{947}वपी पॉलिसा\u{902}ची कार"),
            keywords: &[
                "कार",
                "पॉलिस",
                "य\u{947}वपी",
                "य\u{947}वपी पॉलिसा\u{902}ची कार",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("келе жаткан милиция унаасы"),
            keywords: &[
                "келе жаткан",
                "келе жаткан милиция унаасы",
                "машина",
                "милиция",
                "унаа",
            ],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("entgéintkommende Policeauto"),
            keywords: &[
                "Auto",
                "Police",
                "entgéintkommend",
                "entgéintkommende Policeauto",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ລ\u{ebb}ດຕຳຫ\u{ebc}ວດກຳລ\u{eb1}ງມາ"),
            keywords: &[
                "ກຳລ\u{eb1}ງມາ",
                "ລ\u{ebb}ດຕຳຫ\u{ebc}ວດ",
                "ລ\u{ebb}ດຕຳຫ\u{ebc}ວດກຳລ\u{eb1}ງມາ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("artėjantis policijos automobilis"),
            keywords: &[
                "artėjantis",
                "artėjantis policijos automobilis",
                "automobilis",
                "policija",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("pretī braucoša policijas mašīna"),
            keywords: &[
                "automašīna",
                "mašīna",
                "policija",
                "pretī braucoša policijas mašīna",
                "transports",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("waka pirihimana anga mai"),
            keywords: &[
                "anga mai",
                "motokā",
                "pirihimana",
                "waka pirihimana anga mai",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("полициски автомобил што пристигнува"),
            keywords: &[
                "автомобил",
                "возило",
                "полициски автомобил што пристигнува",
                "полиција",
                "пристигнува",
            ],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("വര\u{d41}ന\u{d4d}ന പൊലീസ\u{d4d} ക\u{d3e}ർ"),
            keywords: &[
                "പൊലീസ\u{d4d}",
                "പൊലീസ\u{d4d} ക\u{d3e}ർ",
                "വര\u{d41}ന\u{d4d}ന പൊലീസ\u{d4d} ക\u{d3e}ർ",
                "വ\u{d3e}ഹനം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("ирж буй цагдаагийн машин"),
            keywords: &["ирж буй", "ирж буй цагдаагийн машин", "машин", "цагдаа"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("य\u{947}णारी पोलिसा\u{902}ची गाडी"),
            keywords: &[
                "कार",
                "पोलिस",
                "य\u{947}णारी पोलिसा\u{902}ची कार",
                "य\u{947}णारी पोलिसा\u{902}ची गाडी",
                "य\u{947}णार\u{947}",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("kereta polis dari arah depan"),
            keywords: &[
                "dari arah depan",
                "kereta",
                "kereta polis dari arah depan",
                "polis",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("karozza tal-pulizija ġejja ’l hawn"),
            keywords: &[
                "karozza",
                "karozza tal-pulizija ġejja ’l hawn",
                "pulizija",
                "ġejja ’l hawn",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("လာနေသည\u{1037}\u{103a} ရ\u{1032}ကား"),
            keywords: &[
                "ရ\u{1032}",
                "ရ\u{1032}ကား",
                "လာနေသည\u{1037}\u{103a} ရ\u{1032}ကား",
                "လာနေသည\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("motgående politibil"),
            keywords: &["bil", "kjøretøy", "motgående politibil"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("आउ\u{901}द\u{948} गर\u{947}को प\u{941}लिस कार"),
            keywords: &[
                "आउ\u{901}द\u{948} गर\u{947}को",
                "आउ\u{901}द\u{948} गर\u{947}को प\u{941}लिस कार",
                "कार",
                "गाडी",
                "प\u{941}लिस",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("naderende politieauto"),
            keywords: &["auto", "naderend", "naderende politieauto", "politie"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("motgåande politibil"),
            keywords: &["bil", "køyretøy", "motgåande politibil"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some(
                "ସମ\u{b4d}ମ\u{b41}ଖର\u{b41} ଆସ\u{b41}ଥ\u{b3f}ବ\u{b3e} ପୋଲ\u{b3f}ସ\u{b4d}\u{200c} କ\u{b3e}ର\u{b4d}\u{200c}",
            ),
            keywords: &[
                "ଆସ\u{b41}ଥ\u{b3f}ବ\u{b3e}",
                "କ\u{b3e}ର\u{b4d}\u{200c}",
                "ପୋଲ\u{b3f}ସ\u{b4d}\u{200c}",
                "ସମ\u{b4d}ମ\u{b41}ଖର\u{b41} ଆସ\u{b41}ଥ\u{b3f}ବ\u{b3e} ପୋଲ\u{b3f}ସ\u{b4d}\u{200c} କ\u{b3e}ର\u{b4d}\u{200c}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਆ ਰਹੀ ਪ\u{a41}ਲਿਸ ਕਾਰ"),
            keywords: &[
                "ਆ ਰਹੀ ਪ\u{a41}ਲਿਸ ਕਾਰ",
                "ਪ\u{a41}ਲਿਸ",
                "ਪ\u{a41}ਲਿਸ ਕਾਰ",
                "ਵਾਹਨ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("آن آلی پ\u{64f}لس دی کار"),
            keywords: &["آن آلی پ\u{64f}لس دی کار", "آن آلے", "پ\u{64f}لس", "کار"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Polís Móto Wé De Kọ\u{301}m Wiá Yu Dè"),
            keywords: &[
                "Kaa",
                "Móto",
                "Polis",
                "Polís Móto Wé De Kọ\u{301}m Wiá Yu Dè",
                "Sọ\u{301}mtin Wé De Kọ\u{301}m Wiá Yu Dè",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("nadjeżdżający radiowóz"),
            keywords: &[
                "nadjeżdżający radiowóz",
                "patrol",
                "policja",
                "samochód policyjny",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("راتلونکی پولیس موټر"),
            keywords: &["راتلونکی", "موټر", "پولیس"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("viatura policial se aproximando"),
            keywords: &[
                "polícia",
                "veículo",
                "viatura policial",
                "viatura policial se aproximando",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("carro da polícia a aproximar-se"),
            keywords: &[
                "aproximação",
                "carro",
                "carro da polícia a aproximar-se",
                "polícia",
                "veículo",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("qatiq carru policiapaq"),
            keywords: &["carru", "policia", "qatiq", "qatiq carru policiapaq"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("mașină de poliție care se apropie"),
            keywords: &[
                "autovehicul",
                "mașină de poliție care se apropie",
                "poliție",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-936"),
            keywords: &["E10-936"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("полицейская машина спереди"),
            keywords: &[
                "лобовое стекло",
                "машина",
                "полицейская машина",
                "полицейская машина спереди",
                "полицейские",
                "полиция",
                "приближающаяся полицейская машина",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("imodoka ya polisi iza igusanga"),
            keywords: &[
                "imodoka",
                "imodoka ya polisi iza igusanga",
                "iri kuza",
                "polisi",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ايندڙ پوليس ڪار"),
            keywords: &["ايندڙ پوليس ڪار", "پهچڻ واري", "پوليس", "ڪار"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ඉද\u{dd2}ර\u{dd2}යට එන පොල\u{dd2}ස\u{dca} මෝටර\u{dca} රථය"),
            keywords: &[
                "ඉද\u{dd2}ර\u{dd2}යට එන",
                "ඉද\u{dd2}ර\u{dd2}යට එන පොල\u{dd2}ස\u{dca} මෝටර\u{dca} රථය",
                "පොල\u{dd3}ස\u{dd2}ය",
                "මෝටර\u{dca} රථය",
                "ව\u{dcf}හනය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("prichádzajúce policajné auto"),
            keywords: &[
                "auto",
                "dopravný prostriedok",
                "polícia",
                "prichádzajúce",
                "prichádzajúce policajné auto",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("prihajajoče policijsko vozilo"),
            keywords: &[
                "avto",
                "policija",
                "prihajajoče",
                "prihajajoče policijsko vozilo",
                "vozilo",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("gaari boolis soo socda"),
            keywords: &["boolis", "gaari", "gaari boolis soo socda", "soo socda"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("makinë policie që vjen"),
            keywords: &[
                "makinë",
                "makinë policie që vjen",
                "mjet",
                "në ardhje",
                "polici",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("полицијски аутомобил спреда"),
            keywords: &[
                "aутoмoбил",
                "дoлaзaк",
                "пoлициja",
                "полицијски аутомобил спреда",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("полицијски аутомобил сприједа"),
            keywords: &["полицијски аутомобил сприједа"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("policijski automobil spreda"),
            keywords: &[
                "automobil",
                "dolazak",
                "policija",
                "policijski automobil spreda",
            ],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("policijski automobil sprijeda"),
            keywords: &["policijski automobil sprijeda"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("mötande polisbil"),
            keywords: &["fordon", "mötande polisbil", "polis", "polisbil"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("gari la polisi linalokuja"),
            keywords: &["gari", "gari la polisi linalokuja", "linalokuja", "polisi"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some(
                "வந\u{bcd}துகொண\u{bcd}டிருக\u{bcd}கும\u{bcd} போல\u{bc0}ஸ\u{bcd} வ\u{bbe}கனம\u{bcd}",
            ),
            keywords: &[
                "போல\u{bc0}ஸ\u{bcd} வண\u{bcd}டி வந\u{bcd}துகொண\u{bcd}டிருக\u{bcd}கிறது",
                "வந\u{bcd}துகொண\u{bcd}டிருக\u{bcd}கும\u{bcd} போல\u{bc0}ஸ\u{bcd} வண\u{bcd}டி",
                "வந\u{bcd}துகொண\u{bcd}டிருக\u{bcd}கும\u{bcd} போல\u{bc0}ஸ\u{bcd} வ\u{bbe}கனம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ముందువ\u{c48}పు వస\u{c4d}తున\u{c4d}న ప\u{c4b}ల\u{c40}సు వ\u{c3e}హనం"),
            keywords: &[
                "ప\u{c4b}ల\u{c40}సు",
                "ముందు",
                "ముందువ\u{c48}పు వస\u{c4d}తున\u{c4d}న ప\u{c4b}ల\u{c40}సు వ\u{c3e}హనం",
                "వ\u{c3e}హనం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("мошини пулис аз самти муқобил"),
            keywords: &[
                "аз самти муқобил",
                "мошин",
                "мошини пулис аз самти муқобил",
                "пулис",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("รถตำรวจกำล\u{e31}งมา"),
            keywords: &[
                "กำล\u{e31}งมา",
                "ตำรวจ",
                "ยานพาหนะ",
                "รถตำรวจกำล\u{e31}งมา",
                "รถยนต\u{e4c}",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("gelýän polisiýa awtoulagy"),
            keywords: &[
                "awtoulag",
                "gelýän",
                "gelýän polisiýa awtoulagy",
                "polisiýa",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("meʻalele polisi lele mai"),
            keywords: &["meʻalele polisi lele mai"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("yaklaşan polis arabası"),
            keywords: &["polis", "polis arabası", "taşıt", "yaklaşan polis arabası"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("كېلىۋاتقان ساقچى ماشىنىسى"),
            keywords: &["ساقچى", "كېلىۋاتقان ساقچى ماشىنىسى", "كەلگەن", "ماشىنا"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("поліцейська машина, що наближається"),
            keywords: &[
                "автомобіль",
                "наближається",
                "поліцейська машина, що наближається",
                "поліцейський автомобіль, що наближається",
                "поліція",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("آتی ہوئی پولیس کار"),
            keywords: &["آتی ہوئی", "آتی ہوئی پولیس کار", "پولیس", "کار"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("yaqinlashayotgan politsiya mashinasi"),
            keywords: &[
                "kelayotgan",
                "mashina",
                "politsiya",
                "transport",
                "yaqinlashayotgan",
                "yaqinlashayotgan politsiya mashinasi",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("xe cảnh sát đang tới"),
            keywords: &["cảnh sát", "xe cảnh sát đang tới", "xe hơi", "đang tới"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("oto poliis buy ñëw"),
            keywords: &["buy ñëw", "oto", "oto poliis buy ñëw", "poliis"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("imoto yamapolisa ezayo"),
            keywords: &["ezayo", "imoto", "imoto yamapolisa ezayo", "ipolisa"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ọkọ Ọlọpa Ti Nbọ"),
            keywords: &[
                "tí ń bọ\u{300}",
                "Ọkọ Ọlọpa Ti Nbọ",
                "ọkọ\u{301}",
                "ọlọ\u{301}pàá",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("快到嘅警車"),
            keywords: &["快到", "快到嘅警車", "汽車", "警察"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("快到嘅警车"),
            keywords: &["快到", "快到嘅警车", "汽车", "警察"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("迎面驶来的警车"),
            keywords: &["警察", "警车", "迎面驶来的警车"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("警察車"),
            keywords: &["警察車", "警車"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("imoto yamaphoyisa ezayo"),
            keywords: &[
                "amaphoyisa",
                "ezayo",
                "imoto",
                "imoto yamaphoyisa ezayo",
                "isithuthi",
            ],
        },
    ],
};
#[doc = "🚕"]
pub const TAXI: crate::Emoji = crate::Emoji {
    glyph: "🚕",
    codepoint: "1F695",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "taxi",
    group: "Travel & Places",
    subgroup: "transport-ground",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("taxi"),
            keywords: &["taxi", "voertuig"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ታክሲ"),
            keywords: &["ተሽከርካሪ", "ታክሲ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("تاكسي"),
            keywords: &["تاكسي", "مركبة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("টেক\u{9cd}সি"),
            keywords: &["টেক\u{9cd}সি", "ব\u{9be}হন"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("taksi"),
            keywords: &["nəqliyyat", "taksi"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("таксі"),
            keywords: &["таксі", "транспарт"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("такси"),
            keywords: &["превозно средство", "такси"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ট\u{9cd}য\u{9be}ক\u{9cd}সি"),
            keywords: &["ট\u{9cd}য\u{9be}ক\u{9cd}সি", "য\u{9be}নব\u{9be}হন"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("taksi"),
            keywords: &["karbed", "taksi"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("taksi"),
            keywords: &["taksi", "vozilo"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("taxi"),
            keywords: &["taxi", "transport", "vehicle"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏓᏣᏁᏗ"),
            keywords: &["ᎠᏓᏣᏁᏗ", "ᏙᏆᎴᎵ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("taxík"),
            keywords: &["taxík", "vozidlo"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("tacsi"),
            keywords: &["cerbyd", "tacsi"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("taxa"),
            keywords: &["bil", "køretøj", "taxa", "taxi"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Taxi"),
            keywords: &["Auto", "Fahrzeug", "Taxi"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ταξί"),
            keywords: &["ταξί", "όχημα"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("taxi"),
            keywords: &["taxi", "vehicle"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: None,
            keywords: &["cab", "taxi", "vehicle"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("taxi"),
            keywords: &["coche", "taxi", "vehículo"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["taxi", "transporte"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("takso"),
            keywords: &["sõiduk", "takso"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("taxia"),
            keywords: &["ibilgailu", "taxia"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("تاکسی"),
            keywords: &["تاکسی", "وسیله\u{654} نقلیه"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("taksi"),
            keywords: &["ajoneuvo", "auto", "taksi"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("taxi"),
            keywords: &["sasakyan", "taxi"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("taxabilur"),
            keywords: &["bilur", "taxa", "taxabilur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("taxi"),
            keywords: &["taxi", "véhicule"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("tacsaí"),
            keywords: &["feithicil", "tacsaí"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("tacsaidh"),
            keywords: &["carbad", "tacsaidh"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("taxi"),
            keywords: &["taxi"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ટ\u{ac5}ક\u{acd}સી"),
            keywords: &["ટ\u{ac5}ક\u{acd}સી", "વાહન"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("taksi"),
            keywords: &["mota", "taksi"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("מונית"),
            keywords: &["טקסי", "מונית", "תחבורה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ट\u{948}क\u{94d}सी"),
            keywords: &["ट\u{948}क\u{94d}सी", "वाहन"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("taksi"),
            keywords: &["taksi", "vozilo"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("taxi"),
            keywords: &["jármű", "személyszállítás", "taxi"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("տաքսի"),
            keywords: &["տաքսի", "փոխադրամիջոց"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("taksi"),
            keywords: &["kendaraan", "taksi"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ụgbọala njem"),
            keywords: &["ụgbọala", "ụgbọala njem"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("leigubíll"),
            keywords: &["leigubifreið", "leigubíll"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("taxi"),
            keywords: &["taxi", "veicolo"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("タクシー"),
            keywords: &["タクシー", "乗り物"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("taksi"),
            keywords: &["taksi", "tetumpakan"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ტაქსი"),
            keywords: &["ტაქსი", "ტრანსპორტი"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("Ataksi"),
            keywords: &["Ataksi"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("такси"),
            keywords: &["көлік", "такси"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("taxa"),
            keywords: &["bil", "køretøj", "taxa"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ឡានតាក\u{17cb}ស\u{17ca}\u{17b8}"),
            keywords: &[
                "តាក\u{17cb}ស\u{17ca}\u{17b8}",
                "រថយន\u{17d2}ត",
                "ឡាន",
                "ឡានតាក\u{17cb}ស\u{17ca}\u{17b8}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಟ\u{ccd}ಯಾಕ\u{ccd}ಸ\u{cbf}"),
            keywords: &["ಟ\u{ccd}ಯಾಕ\u{ccd}ಸ\u{cbf}", "ವಾಹನ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("택시"),
            keywords: &["자동차", "택시"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("ट\u{945}क\u{94d}सी"),
            keywords: &["ट\u{945}क\u{94d}सी", "वाहन"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("такси"),
            keywords: &["такси", "унаа"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Taxi"),
            keywords: &["Gefier", "Taxi"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ລ\u{ebb}ດແທ\u{eb1}ກຊ\u{eb5}"),
            keywords: &["ພາຫະນະ", "ລ\u{ebb}ດແທ\u{eb1}ກຊ\u{eb5}"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("taksi"),
            keywords: &["taksi", "transporto priemonė"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("taksometrs"),
            keywords: &["automašīna", "mašīna", "taksometrs", "transports"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("takihī"),
            keywords: &["takihī", "waka"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("такси"),
            keywords: &["возило", "такси"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ട\u{d3e}ക\u{d4d}സി"),
            keywords: &["ട\u{d3e}ക\u{d4d}സി", "വ\u{d3e}ഹനം"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("такси"),
            keywords: &["такси", "тээврийн хэрэгсэл"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("ट\u{945}क\u{94d}सी"),
            keywords: &["ट\u{945}क\u{94d}सी", "वाहन"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("teksi"),
            keywords: &["kenderaan", "teksi"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("taxi"),
            keywords: &["taxi", "vettura"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("တက\u{103a}ကစ\u{102e}"),
            keywords: &[
                "တက\u{1039}ကစ\u{102e}",
                "တက\u{103a}ကစ\u{102e}",
                "ယာဉ\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("taxi"),
            keywords: &["bil", "kjøretøy", "taxi"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("ट\u{94d}याक\u{94d}सी"),
            keywords: &["गाडी", "ट\u{94d}याक\u{94d}सी"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("taxi"),
            keywords: &["taxi", "voertuig"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("taxi"),
            keywords: &["bil", "køyretøy", "taxi"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଟ\u{b4d}ୟ\u{b3e}କ\u{b4d}ସ\u{b3f}"),
            keywords: &[
                "ଟେକ\u{b4d}ସ\u{b3f}",
                "ଟ\u{b4d}ୟ\u{b3e}କ\u{b4d}ସ\u{b3f}",
                "ବ\u{b3e}ହ\u{b3e}ନ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਟ\u{a48}ਕਸੀ"),
            keywords: &["ਟ\u{a48}ਕਸੀ", "ਵਾਹਨ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ٹیکسی"),
            keywords: &["ٹیکسی", "گڈی"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Taksí"),
            keywords: &["Móto", "Taksí"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("taksówka"),
            keywords: &["taksówka", "taxi"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ټیکسي"),
            keywords: &["ټیکسي", "ګاډی"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("táxi"),
            keywords: &["táxi", "veículo"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("taxi"),
            keywords: &["carru", "taxi"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("taxi"),
            keywords: &["autovehicul", "taxi", "taximetrie"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-937"),
            keywords: &["E10-937"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("такси"),
            keywords: &["машина", "такси", "транспорт"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("tagisi"),
            keywords: &["imodoka", "tagisi"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ٽيڪسي"),
            keywords: &["ٽيڪسي", "گاڏي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ටැක\u{dca}ස\u{dd2}ය"),
            keywords: &["ටැක\u{dca}ස\u{dd2}ය", "ව\u{dcf}හනය"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("taxík"),
            keywords: &["dopravný prostriedok", "taxi", "taxík"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("taksi"),
            keywords: &["taksi", "vozilo"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("taksi"),
            keywords: &["gaari", "taksi"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("taksi"),
            keywords: &["mjet udhëtimi", "taksi"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("такси"),
            keywords: &["вoзилo", "такси"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("taksi"),
            keywords: &["taksi", "vozilo"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("taxi"),
            keywords: &["fordon", "taxi"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("teksi"),
            keywords: &["gari", "teksi"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ட\u{bbe}க\u{bcd}சி"),
            keywords: &["ட\u{bbe}க\u{bcd}சி", "ட\u{bbe}க\u{bcd}ஸி"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ట\u{c3e}క\u{c4d}స\u{c40}"),
            keywords: &[
                "ట\u{c3e}క\u{c4d}స\u{c40}",
                "పక\u{c4d}కకు చూపబడ\u{c47} ట\u{c3e}క\u{c4d}స\u{c40} చ\u{c3f}హ\u{c4d}నం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("такси"),
            keywords: &["нақлиёт", "такси"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("แท\u{e47}กซ\u{e35}\u{e48}"),
            keywords: &["เคร\u{e37}\u{e48}องยนต\u{e4c}", "แท\u{e47}กซ\u{e35}\u{e48}"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("taksi"),
            keywords: &["taksi", "ulag"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("meʻalele utakakai"),
            keywords: &["meʻalele utakakai"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("taksi"),
            keywords: &["taksi", "taşıt"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("تاكسى"),
            keywords: &["ئاپتوموبىل", "تاكسى"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("таксі"),
            keywords: &["таксі", "транспорт"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ٹیکسی"),
            keywords: &["سواری", "ٹیکسی"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("taksi"),
            keywords: &["taksi", "transport"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("taxi"),
            keywords: &["taxi", "xe cộ"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("taxi"),
            keywords: &["taxi", "waruwaay"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("iteksi"),
            keywords: &["inqwelo-mafutha", "iteksi"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Taasi"),
            keywords: &["Taasi", "nṣe ọkọ\u{301}"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("的士"),
            keywords: &["的士", "車輛"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("的士"),
            keywords: &["的士", "车辆"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("出租车"),
            keywords: &["出租车", "的士"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("計程車"),
            keywords: &["小黃", "計程車"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("的士"),
            keywords: &["的士", "計程車"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("itekisi"),
            keywords: &["isithuthi", "itekisi"],
        },
    ],
};
#[doc = "🚖"]
pub const ONCOMING_TAXI: crate::Emoji = crate::Emoji {
    glyph: "🚖",
    codepoint: "1F696",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "oncoming taxi",
    group: "Travel & Places",
    subgroup: "transport-ground",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("aankomende taxi"),
            keywords: &["aankomend", "aankomende taxi", "taxi", "voertuig"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("መጪ ታክሲ"),
            keywords: &["መጪ", "ተሽከርካሪ", "ታክሲ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("تاكسي مقترب"),
            keywords: &["تاكسي", "تاكسي مقترب", "مركبة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("আহি থক\u{9be} টেক\u{9cd}সি"),
            keywords: &[
                "আহি থক\u{9be}",
                "আহি থক\u{9be} টেক\u{9cd}সি",
                "টেক\u{9cd}সি",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("yaxınlaşan taksi"),
            keywords: &["nəqliyyat", "taksi", "yaxınlaşan taksi", "yaxınlaşma"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("набліжаецца таксі"),
            keywords: &["набліжаецца таксі", "набліжэнне", "таксі", "транспарт"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("приближаващо такси"),
            keywords: &[
                "превозно средство",
                "приближаващ",
                "приближаващо такси",
                "такси",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("অগ\u{9cd}রসরম\u{9be}ন ট\u{9cd}য\u{9be}ক\u{9cd}সি"),
            keywords: &[
                "অগ\u{9cd}রসরম\u{9be}ন",
                "ট\u{9cd}য\u{9be}ক\u{9cd}সি",
                "য\u{9be}নব\u{9be}হন",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("dolazeći taksi"),
            keywords: &["dolazeći taksi", "taksi"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("taxi que arriba"),
            keywords: &["proper", "taxi", "taxi de cara", "taxi que arriba"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏂᏓᏳᏍᏗᏛ ᎠᏈᏗ ᎠᏦᏙᏗ"),
            keywords: &["ᎠᏈᏗ ᎠᏦᏙᏗ", "ᏂᏓᏳᏍᏗᏛ", "ᏂᏓᏳᏍᏗᏛ ᎠᏈᏗ ᎠᏦᏙᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("přijíždějící taxík"),
            keywords: &[
                "přijíždějící",
                "přijíždějící taxík",
                "příjezd",
                "taxi",
                "vozidlo",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("tacsi sy’n dod i’ch cwrdd"),
            keywords: &["dod i’ch cwrdd", "tacsi", "tacsi sy’n dod i’ch cwrdd"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("taxa forfra"),
            keywords: &["kørende taxa", "taxa forfra"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Taxi von vorne"),
            keywords: &["Taxi", "Taxi von vorne"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("διερχόμενο ταξί"),
            keywords: &["διερχόμενο", "ταξί", "όχημα"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("oncoming taxi"),
            keywords: &["oncoming", "taxi"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: None,
            keywords: &["cab", "oncoming", "taxi"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("taxi próximo"),
            keywords: &["taxi", "taxi próximo", "vehículo"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("taxi se aproxima"),
            keywords: &["taxi", "taxi se aproxima", "transporte"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("takso eestvaates"),
            keywords: &["eestvaade", "sõiduk", "takso", "takso eestvaates"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("heldu den taxia"),
            keywords: &["heldu", "heldu den taxia", "taxia"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("تاکسی\u{200c}ای که نزدیک می\u{200c}شود"),
            keywords: &[
                "تاکسی",
                "تاکسی\u{200c}ای که نزدیک می\u{200c}شود",
                "درحال آمدن",
                "نزدیک\u{200c}شونده",
                "وسیله\u{654} نقلیه",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("saapuva taksi"),
            keywords: &["ajoneuvo", "auto", "saapuva taksi", "taksi"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("paparating na taxi"),
            keywords: &["paparating", "paparating na taxi", "sasakyan", "taxi"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("gron á taxabili"),
            keywords: &["bilur", "gron á taxabili", "taxa"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("taxi de face"),
            keywords: &["taxi", "taxi de face"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["de face", "taxi", "taxi de face"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("tacsaí ag teacht"),
            keywords: &["feithicil", "tacsaí", "tacsaí ag teacht"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("tagsaidh a’ tighinn thugad"),
            keywords: &["tagsaidh", "tagsaidh a’ tighinn thugad", "tighinn"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("taxi de fronte"),
            keywords: &["taxi", "taxi de fronte"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("આવી રહ\u{ac7}લ ટ\u{ac5}ક\u{acd}સી"),
            keywords: &[
                "આવનારી ટ\u{ac5}ક\u{acd}સી",
                "આવી રહ\u{ac7}લ ટ\u{ac5}ક\u{acd}સી",
                "ટ\u{ac5}ક\u{acd}સી",
                "વાહન",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("taksi mai zuwa"),
            keywords: &["mai zuwa", "taksi", "taksi mai zuwa"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("מונית מלפנים"),
            keywords: &["מונית", "מונית מלפנים", "תחבורה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("आती ह\u{941}ई ट\u{948}क\u{94d}सी"),
            keywords: &[
                "आती ह\u{941}ई ट\u{948}क\u{94d}सी",
                "ट\u{948}क\u{94d}सी",
                "वाहन",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("taksi u dolasku"),
            keywords: &["dolazak", "taksi", "taksi u dolasku", "vozilo"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("érkező taxi"),
            keywords: &["jármű", "személyszállítás", "taxi", "érkező"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("մոտեցող տաքսի"),
            keywords: &["մոտեցող", "տաքսի", "փոխադրամիջոց"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("taksi datang"),
            keywords: &["datang", "kendaraan", "taksi"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ụgbọala njem na-apụta apụta"),
            keywords: &[
                "na-apụta apụta",
                "ụgbọala njem",
                "ụgbọala njem na-apụta apụta",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("leigubíll á móti"),
            keywords: &["leigubíll", "leigubíll nálgast", "leigubíll á móti"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("taxi in arrivo"),
            keywords: &["taxi", "taxi in arrivo", "veicolo"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("タクシー正面"),
            keywords: &["タクシー", "タクシー正面", "乗り物"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("taksi mara"),
            keywords: &["mara", "taksi"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მომავალი ტაქსი"),
            keywords: &["მომავალი", "ტაქსი", "ტრანსპორტი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("келе жатқан такси"),
            keywords: &["келе жатыр", "келе жатқан такси", "көлік", "такси"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("taxa forfra"),
            keywords: &["kørende taxa", "taxa forfra"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ឡានតាក\u{17cb}ស\u{17ca}\u{17b8}មើលព\u{17b8}ម\u{17bb}ខ"),
            keywords: &[
                "ច\u{17c6}ព\u{17b8}ម\u{17bb}ខ",
                "តាក\u{17cb}ស\u{17ca}\u{17b8}",
                "ឡានតាក\u{17cb}ស\u{17ca}\u{17b8}មើលព\u{17b8}ម\u{17bb}ខ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಮುಂದ\u{cc6} ಬರುತ\u{ccd}ತ\u{cbf}ರುವ ಟ\u{ccd}ಯಾಕ\u{ccd}ಸ\u{cbf}"),
            keywords: &[
                "ಟ\u{ccd}ಯಾಕ\u{ccd}ಸ\u{cbf}",
                "ಮುಂದ\u{cc6} ಬರುತ\u{ccd}ತ\u{cbf}ರುವ ಟ\u{ccd}ಯಾಕ\u{ccd}ಸ\u{cbf}",
                "ಮುನ\u{ccd}ನುಗ\u{ccd}ಗ\u{cbf} ಬರುವ ಟ\u{ccd}ಯಾಕ\u{ccd}ಸ\u{cbf}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("오고 있는 택시"),
            keywords: &["오고 있는 택시", "택시"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("य\u{947}वपी ट\u{945}क\u{94d}सी"),
            keywords: &["ट\u{945}क\u{94d}सी", "य\u{947}वपी"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("келе жаткан такси"),
            keywords: &["келе жаткан", "келе жаткан такси", "такси", "унаа"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("entgéintkommenden Taxi"),
            keywords: &["Taxi", "entgéintkommend", "entgéintkommenden Taxi"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ລ\u{ebb}ດແທ\u{eb1}ກຊ\u{eb5}ກຳລ\u{eb1}ງມາ"),
            keywords: &[
                "ກຳລ\u{eb1}ງມາ",
                "ພາຫະນະ",
                "ລ\u{ebb}ດແທ\u{eb1}ກຊ\u{eb5}",
                "ລ\u{ebb}ດແທ\u{eb1}ກຊ\u{eb5}ກຳລ\u{eb1}ງມາ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("artėjantis taksi"),
            keywords: &["artėjantis", "taksi"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("pretī braucošs taksometrs"),
            keywords: &[
                "automašīna",
                "mašīna",
                "pretī braucošs taksometrs",
                "transports",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("takihī anga mai"),
            keywords: &["anga mai", "takihī", "takihī anga mai"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("такси што пристигнува"),
            keywords: &["возило", "пристигнува", "такси", "такси што пристигнува"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("വര\u{d41}ന\u{d4d}ന ട\u{d3e}ക\u{d4d}സി"),
            keywords: &[
                "ട\u{d3e}ക\u{d4d}സി",
                "വര\u{d41}ന\u{d4d}ന ട\u{d3e}ക\u{d4d}സി",
                "വ\u{d3e}ഹനം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("ирж буй такси"),
            keywords: &["ирж буй", "ирж буй такси", "такси"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("य\u{947}णारी ट\u{945}क\u{94d}सी"),
            keywords: &[
                "ट\u{945}क\u{94d}सी",
                "य\u{947}णारी ट\u{945}क\u{94d}सी",
                "य\u{947}णार\u{947}",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("teksi dari arah depan"),
            keywords: &["dari arah depan", "teksi", "teksi dari arah depan"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("taxi ġejja ’l hawn"),
            keywords: &["taxi", "taxi ġejja ’l hawn", "ġejja ’l hawn"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("လာနေသည\u{1037}\u{103a} တက\u{1039}ကစ\u{102e}"),
            keywords: &[
                "လာနေသည\u{1037}\u{103a} တက\u{1039}ကစ\u{102e}",
                "လာနေသည\u{103a}",
                "အင\u{103e}ားယာဉ\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("motgående taxi"),
            keywords: &["bil", "kjøretøy", "motgående", "taxi"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("आउ\u{901}द\u{948} गर\u{947}को ट\u{94d}याक\u{94d}सी"),
            keywords: &[
                "आइरह\u{947}को",
                "आउ\u{901}द\u{948} गर\u{947}को ट\u{94d}याक\u{94d}सी",
                "ट\u{94d}याक\u{94d}सी",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("naderende taxi"),
            keywords: &["naderend", "naderende taxi", "taxi"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("motgåande taxi"),
            keywords: &["bil", "køyretøy", "motgåande", "taxi"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some(
                "ସମ\u{b4d}ମ\u{b41}ଖର\u{b41} ଆସ\u{b41}ଥ\u{b3f}ବ\u{b3e} ଟ\u{b4d}ୟ\u{b3e}କ\u{b4d}ସ\u{b3f}",
            ),
            keywords: &[
                "ଆସ\u{b41}ଥ\u{b3f}ବ\u{b3e}",
                "ଟ\u{b4d}ୟ\u{b3e}କ\u{b4d}ସ\u{b3f}",
                "ସମ\u{b4d}ମ\u{b41}ଖର\u{b41} ଆସ\u{b41}ଥ\u{b3f}ବ\u{b3e} ଟ\u{b4d}ୟ\u{b3e}କ\u{b4d}ସ\u{b3f}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਆ ਰਹੀ ਟ\u{a48}ਕਸੀ"),
            keywords: &["ਆ ਰਹੀ ਟ\u{a48}ਕਸੀ", "ਟ\u{a48}ਕਸੀ", "ਵਾਹਨ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("آن آلی ٹیکسی"),
            keywords: &["آن آلی ٹیکسی", "آن آلے", "ٹیکسی"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Taksí Wé De Kọ\u{301}m Wiá Yu Dè"),
            keywords: &["Taksí Wé De Kọ\u{301}m Wiá Yu Dè"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("nadjeżdżająca taksówka"),
            keywords: &["nadjeżdżająca taksówka", "nadjeżdżać", "taksówka", "taxi"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("راتلونکی ټیکسي"),
            keywords: &["راتلونکی", "ټیکسي"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("táxi se aproximando"),
            keywords: &["táxi", "táxi se aproximando", "veículo"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("táxi a aproximar-se"),
            keywords: &["aproximação", "táxi", "táxi a aproximar-se", "veículo"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("qatiq taxi"),
            keywords: &["qatiq taxi"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("taxi care se apropie"),
            keywords: &[
                "apropiere",
                "autovehicul",
                "taxi care se apropie",
                "taximetrie",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-938"),
            keywords: &["E10-938"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("такси спереди"),
            keywords: &[
                "машина",
                "приближающееся такси",
                "такси",
                "такси спереди",
                "транспорт",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("tagisi iza igusanga"),
            keywords: &["igusanga", "tagisi iza", "tagisi iza igusanga"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ايندڙ ٽيڪسي"),
            keywords: &["ايندڙ ٽيڪسي", "ٽيڪسي", "پهچڻ واري"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ඉද\u{dd2}ර\u{dd2}යට එන ටැක\u{dca}ස\u{dd2}ය"),
            keywords: &[
                "ඉද\u{dd2}ර\u{dd2}යට එන",
                "ඉද\u{dd2}ර\u{dd2}යට එන ටැක\u{dca}ස\u{dd2}ය",
                "ටැක\u{dca}ස\u{dd2}ය",
                "ව\u{dcf}හනය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("prichádzajúci taxík"),
            keywords: &[
                "dopravný prostriedok",
                "prichádzajúce",
                "prichádzajúci taxík",
                "taxi",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("prihajajoči taksi"),
            keywords: &["prihajajoče", "prihajajoči taksi", "taksi", "vozilo"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("taksi soo socda"),
            keywords: &["taksi", "taksi soo socda"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("taksi që vjen"),
            keywords: &["mjet", "në ardhje", "që vjen", "taksi", "taksi që vjen"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("такси спреда"),
            keywords: &["дoлaзaк", "тaкси", "такси спреда"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["такси спреда"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("taksi spreda"),
            keywords: &["dolazak", "taksi", "taksi spreda"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["taksi spreda"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("mötande taxi"),
            keywords: &["fordon", "mötande taxi", "taxi"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("teksi inayokuja"),
            keywords: &["gari", "linalokuja", "teksi", "teksi inayokuja"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("வந\u{bcd}துகொண\u{bcd}டிருக\u{bcd}கும\u{bcd} ட\u{bbe}க\u{bcd}சி"),
            keywords: &[
                "வந\u{bcd}துகொண\u{bcd}டிருக\u{bcd}கும\u{bcd} ட\u{bbe}க\u{bcd}சி",
                "வ\u{bbe}டகை ட\u{bbe}க\u{bcd}சி",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ముందువ\u{c48}పు వస\u{c4d}తున\u{c4d}న ట\u{c3e}క\u{c4d}స\u{c40}"),
            keywords: &[
                "ట\u{c3e}క\u{c4d}స\u{c40}",
                "ముందు",
                "ముందువ\u{c48}పు వస\u{c4d}తున\u{c4d}న ట\u{c3e}క\u{c4d}స\u{c40}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("такси аз самти муқобил"),
            keywords: &["аз самти муқобил", "такси", "такси аз самти муқобил"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("แท\u{e47}กซ\u{e35}\u{e48}กำล\u{e31}งมา"),
            keywords: &[
                "กำล\u{e31}งมา",
                "ยานพาหนะ",
                "แท\u{e47}กซ\u{e35}\u{e48}",
                "แท\u{e47}กซ\u{e35}\u{e48}กำล\u{e31}งมา",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("gelýän taksi"),
            keywords: &["gelýän", "taksi"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("meʻalele utakakai lele mai"),
            keywords: &["meʻalele utakakai lele mai"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("yaklaşan taksi"),
            keywords: &["taksi", "taşıt", "yaklaşan taksi"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("كېلىۋاتقان تاكسى"),
            keywords: &["تاكسى", "كېلىۋاتقان تاكسى", "كەل"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("таксі, що наближається"),
            keywords: &[
                "наближатися",
                "таксі",
                "таксі, що наближається",
                "транспорт",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("آتی ہوئی ٹیکسی"),
            keywords: &["آتی ہوئی", "آتی ہوئی ٹیکسی", "ٹیکسی"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("yaqinlashayotgan taksi"),
            keywords: &["taksi", "transport", "yaqinlashayotgan"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("taxi đang tới"),
            keywords: &["taxi đang tới", "xe cộ"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("taxi buy ñëw"),
            keywords: &["taxi", "taxi buy ñëw", "ñëw"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("iteksi ezayo"),
            keywords: &["ezayo", "iteksi"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Taasi Ti Nbọ"),
            keywords: &["Taasi", "Taasi Ti Nbọ", "Ti Nbọ"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("快到嘅的士"),
            keywords: &["快到", "快到嘅的士", "的士"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("快到嘅的士"),
            keywords: &["快到", "快到嘅的士", "的士"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("迎面驶来的出租车"),
            keywords: &["出租车", "的士", "迎面驶来的出租车"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("小黃"),
            keywords: &["小黃", "計程車"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("接近中的計程車"),
            keywords: &["接近中的計程車", "的士"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("itekisi elizayo"),
            keywords: &["elizayo", "isithuthi", "itekisi elizayo"],
        },
    ],
};
#[doc = "🚗"]
pub const AUTOMOBILE: crate::Emoji = crate::Emoji {
    glyph: "🚗",
    codepoint: "1F697",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "automobile",
    group: "Travel & Places",
    subgroup: "transport-ground",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("motor"),
            keywords: &["kar", "motor", "voertuig"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("አውቶሞቢል"),
            keywords: &["መኪና", "ተሽከርካሪ", "አውቶሞቢል"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("سيارة"),
            keywords: &["سيارة", "مركبة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("অট’মোব\u{9be}ইল"),
            keywords: &["অট’মোব\u{9be}ইল", "গ\u{9be}ড\u{9bc}ী"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("avtomobil"),
            keywords: &["avtomobil", "maşın", "nəqliyyat"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("аўтамабіль"),
            keywords: &["аўтамабіль", "машына", "транспарт"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("автомобил"),
            keywords: &["автомобил", "превозно средство"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("অটোমোব\u{9be}ইল"),
            keywords: &[
                "অটোমোব\u{9be}ইল",
                "গ\u{9be}ড\u{9bc}ি",
                "য\u{9be}নব\u{9be}হন",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("karr-tan"),
            keywords: &["karr", "karr-tan"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("automobil"),
            keywords: &["auto", "automobil", "vozilo"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("automòbil"),
            keywords: &["automòbil", "cotxe", "vehicle"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏗᎦᏚᎴᎾ"),
            keywords: &["ᏗᎦᏚᎴᎾ", "ᏙᏆᎴᎵ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("auto"),
            keywords: &["auto", "vozidlo", "vůz"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("modur"),
            keywords: &["car", "modur"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("bil"),
            keywords: &["bil", "køretøj"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Auto"),
            keywords: &["Auto", "Fahrzeug"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("αυτοκίνητο"),
            keywords: &["αυτοκίνητο", "όχημα"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("automobile"),
            keywords: &["automobile", "car"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: Some("car"),
            keywords: &[""],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("coche"),
            keywords: &["automóvil", "coche", "vehículo"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("auto"),
            keywords: &["auto", "automóvil", "carro", "transporte"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("auto"),
            keywords: &["auto", "sõiduk"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("autoa"),
            keywords: &["auto", "autoa", "ibilgailu"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("خودرو"),
            keywords: &["خودرو", "خودروی سواری", "ماشین", "وسیله\u{654} نقلیه"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("auto"),
            keywords: &["ajoneuvo", "auto"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("kotse"),
            keywords: &["auto", "automobile", "kotse", "sasakyan"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("bilur"),
            keywords: &["bilur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("voiture"),
            keywords: &["automobile", "voiture"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["automobile", "char", "voiture"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("gluaisteán"),
            keywords: &["carr", "feithicil", "gluaisteán"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("càr"),
            keywords: &["càr"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("coche"),
            keywords: &["automóbil", "coche", "vehículo"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ઑટોમોબાઇલ"),
            keywords: &["ઑટોમોબાઇલ", "કાર", "વાહન"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("mota"),
            keywords: &["mota", "ƙaramar mota"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("מכונית"),
            keywords: &["מכונית", "תחבורה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ऑटोमोबाइल, कार"),
            keywords: &["ऑटोमोबाइल", "ऑटोमोबाइल, कार", "कार", "वाहन"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("automobil"),
            keywords: &["automobil", "vozilo"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("autó"),
            keywords: &["autó", "jármű"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ավտոմեքենա"),
            keywords: &["ավտո", "ավտոմեքենա", "մեքենա", "փոխադրամիջոց"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("mobil"),
            keywords: &["kendaraan", "mobil"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ụgbọala"),
            keywords: &["ụgbọala"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("bíll"),
            keywords: &["bifreið", "bíll"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("auto"),
            keywords: &["auto", "automobile", "macchina", "veicolo"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("自動車"),
            keywords: &["乗り物", "自動車", "車"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("montor otomatis"),
            keywords: &["montor", "montor otomatis"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ავტომობილი"),
            keywords: &["ავტომობილი", "მანქანა", "ტრანსპორტი"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("Takerrust"),
            keywords: &["Takerrust"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("автокөлік"),
            keywords: &["автокөлік", "көлік"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("bil"),
            keywords: &["bil", "køretøj"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("រថយន\u{17d2}ត"),
            keywords: &["រថយន\u{17d2}ត", "ឡាន"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಆಟೊಮೊಬೈಲ\u{ccd}"),
            keywords: &["ಆಟೊಮೊಬೈಲ\u{ccd}", "ಕಾರು", "ವಾಹನ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("자동차"),
            keywords: &["승용차", "자동차", "차량"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("ऑटोमोबायल"),
            keywords: &["ऑटोमोबायल", "कार"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("автоунаа"),
            keywords: &["автоунаа", "машина", "унаа"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Auto"),
            keywords: &["Auto", "Automobil"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ລ\u{ebb}ດຍ\u{ebb}ນ"),
            keywords: &["ພາຫະນະ", "ລ\u{ebb}ດຍ\u{ebb}ນ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("automobilis"),
            keywords: &["automobilis", "transporto priemonė"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("automašīna"),
            keywords: &["automašīna", "mašīna", "transports"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("motokā"),
            keywords: &["motokā"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("автомобил"),
            keywords: &["автомобил", "возило"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഓട\u{d4d}ടോമൊബൈൽ"),
            keywords: &["ഓട\u{d4d}ടോമൊബൈൽ", "ക\u{d3e}ർ", "വ\u{d3e}ഹനം"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("автомашин"),
            keywords: &["автомашин", "машин"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("मोटारगाडी"),
            keywords: &["कार", "मोटारगाडी", "\u{200b}\u{200b}ऑटोमोबाईल"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("kereta"),
            keywords: &["kenderaan", "kereta"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("karozza"),
            keywords: &["karozza"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("မော\u{103a}တော\u{103a}ကား"),
            keywords: &[
                "ကား",
                "မော\u{103a}တော\u{103a}ကား",
                "မော\u{103a}တော\u{103a}ယာဉ\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("bil"),
            keywords: &["bil", "kjøretøy"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("अटोमोबाइल"),
            keywords: &["अटोमोबाइल", "कार", "गाडी"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("auto"),
            keywords: &["auto", "automobiel"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("bil"),
            keywords: &["bil", "køyretøy"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଅଟୋମୋବ\u{b3e}ଇଲ\u{b4d}\u{200c}"),
            keywords: &["ଅଟୋମୋବ\u{b3e}ଇଲ\u{b4d}\u{200c}", "କ\u{b3e}ର\u{b4d}"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਆਟ\u{a4b}ਮ\u{a4b}ਬਾਈਲ"),
            keywords: &["ਆਟ\u{a4b}ਮ\u{a4b}ਬਾਈਲ", "ਕਾਰ", "ਵਾਹਨ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("آٹو موبائل"),
            keywords: &["آٹو موبائل", "کار"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Móto"),
            keywords: &["Kaa", "Móto"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("samochód"),
            keywords: &["auto", "pojazd", "samochód"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ګاډي"),
            keywords: &["موټر", "ګاډي", "ګاډی"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("carro"),
            keywords: &["automóvel", "carro", "veículo"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("automóvel"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("carru"),
            keywords: &["auto", "carru"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("automobil"),
            keywords: &["automobil", "mașină"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-939"),
            keywords: &["E10-939"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("автомобиль"),
            keywords: &["автомобиль", "машина", "транспорт"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("imodoka"),
            keywords: &["Imodoka", "imodoka"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("گاڏي"),
            keywords: &["ڪار", "گاڏي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("මෝටර\u{dca} රථය"),
            keywords: &["මෝටර\u{dca} රථය", "ව\u{dcf}හනය"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("auto"),
            keywords: &["auto", "dopravný prostriedok"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("avtomobil"),
            keywords: &["avto", "avtomobil", "vozilo"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("baabuur"),
            keywords: &["baabuur", "gaari", "gawaari"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("automobil"),
            keywords: &["automobil", "makinë", "mjet udhëtimi"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("аутомобил"),
            keywords: &["aутoмoбил", "аутомобил", "вoзилo"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["аутомобил"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("automobil"),
            keywords: &["automobil", "vozilo"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["automobil"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("bil"),
            keywords: &["bil", "fordon"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("gari"),
            keywords: &["gari", "motokaa"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("க\u{bbe}ர\u{bcd}"),
            keywords: &[
                "க\u{bbe}ர\u{bcd}",
                "மோட\u{bcd}ட\u{bbe}ர\u{bcd} வண\u{bcd}டி",
                "மோட\u{bcd}ட\u{bbe}ர\u{bcd} வ\u{bbe}கனம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("క\u{c3e}రు"),
            keywords: &[
                "ఆట\u{c4b}మ\u{c4a}బ\u{c48}ల\u{c4d}",
                "క\u{c3e}రు",
                "పక\u{c4d}కకు చూపబడ\u{c47} క\u{c3e}రు చ\u{c3f}హ\u{c4d}నం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("автомобил"),
            keywords: &["автомобил", "мошин"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("รถ"),
            keywords: &["ยานพาหนะ", "รถ", "รถยนต\u{e4c}"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("awtomobil"),
            keywords: &["awtomobil", "awtoulag"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("meʻalele"),
            keywords: &["meʻalele"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("araba"),
            keywords: &["araba", "otomobil", "taşıt"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئاپتوموبىل"),
            keywords: &["ئاپتوموبىل", "ماشىنا"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("автомобіль"),
            keywords: &["автомобіль", "транспорт"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("کار"),
            keywords: &["سواری", "کار"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("avtomobil"),
            keywords: &["avtomobil", "mashina", "transport"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("ô tô"),
            keywords: &["xe cộ", "ô tô"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("oto"),
            keywords: &["oto"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("inqwelo-mafutha"),
            keywords: &["imoto", "inqwelo-mafutha"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ọko"),
            keywords: &["Ọko", "ọkọ\u{301}"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("汽車"),
            keywords: &["汽車"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("汽车"),
            keywords: &["汽车"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("汽车"),
            keywords: &["汽车", "轿车"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("汽車"),
            keywords: &["汽車", "轎車"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("車"),
            keywords: &["汽車", "車", "轎車"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("imoto"),
            keywords: &["imoto", "isithuthi"],
        },
    ],
};
#[doc = "🚘"]
pub const ONCOMING_AUTOMOBILE: crate::Emoji = crate::Emoji {
    glyph: "🚘",
    codepoint: "1F698",
    status: crate::Status::FullyQualified,
    introduction_version: 0.7f32,
    name: "oncoming automobile",
    group: "Travel & Places",
    subgroup: "transport-ground",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("aankomende motor"),
            keywords: &["aankomend", "aankomende motor", "kar", "motor", "voertuig"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("መጪ አውቶሞቢል"),
            keywords: &["መኪና", "መጪ", "ተሽከርካሪ", "አውቶሞቢል"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("سيارة مقتربة"),
            keywords: &["سيارة", "سيارة مقتربة", "مركبة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("আহি থক\u{9be} অট’মোব\u{9be}ইল"),
            keywords: &[
                "অট’মোব\u{9be}ইল",
                "আহি থক\u{9be}",
                "আহি থক\u{9be} অট’মোব\u{9be}ইল",
                "গ\u{9be}ড\u{9bc}ী",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("yaxınlaşan avtomobil"),
            keywords: &[
                "avtomobil",
                "maşın",
                "nəqliyyat",
                "yaxınlaşan avtomobil",
                "yaxınlaşma",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("набліжаецца аўтамабіль"),
            keywords: &[
                "аўтамабіль",
                "машына",
                "набліжаецца аўтамабіль",
                "набліжэнне",
                "транспарт",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("приближаващ автомобил"),
            keywords: &["автомобил", "превозно средство", "приближаващ"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("অগ\u{9cd}রসরম\u{9be}ন অটোমোব\u{9be}ইল"),
            keywords: &[
                "অগ\u{9cd}রসরম\u{9be}ন",
                "অটোমোব\u{9be}ইল",
                "মোটরগ\u{9be}ড\u{9bc}ি",
                "য\u{9be}নব\u{9be}হন",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("dolazeći automobil"),
            keywords: &["auto", "automobil", "dolazeći automobil"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("automòbil que arriba"),
            keywords: &[
                "automòbil",
                "automòbil de cara",
                "automòbil que arriba",
                "proper",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏂᏓᏳᏍᏗᏛ ᏙᎴᎳ"),
            keywords: &["ᏂᏓᏳᏍᏗᏛ", "ᏙᎴᎳ", "ᏙᏆᎴᎵ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("přijíždějící auto"),
            keywords: &[
                "auto",
                "automobil",
                "přijíždějící",
                "příjezd",
                "vozidlo",
                "vůz",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("modur sy’n dod i’ch cwrdd"),
            keywords: &[
                "car",
                "dod i’ch cwrdd",
                "modur",
                "modur sy’n dod i’ch cwrdd",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("bil forfra"),
            keywords: &["bil", "bil forfra", "fartøj", "kørende"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Auto von vorne"),
            keywords: &["Auto", "Auto von vorne", "Automobil", "Fahrzeug"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("διερχόμενο αυτοκίνητο"),
            keywords: &["αυτοκίνητο", "αυτοκινούμενο", "διερχόμενο", "όχημα"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("oncoming automobile"),
            keywords: &["automobile", "car", "oncoming"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: Some("oncoming car"),
            keywords: &[""],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("coche próximo"),
            keywords: &["automóvil", "coche", "próximo", "vehículo"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("auto se aproxima"),
            keywords: &[
                "auto",
                "auto se aproxima",
                "automóvil",
                "carro",
                "transporte",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("auto eestvaates"),
            keywords: &["auto", "auto eestvaates", "eestvaade", "sõiduk"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("heldu den autoa"),
            keywords: &["auto", "heldu", "heldu den autoa", "ibilgailu"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("خودرویی که نزدیک می\u{200c}شود"),
            keywords: &[
                "اتوموبیل",
                "خودرو",
                "خودرویی که نزدیک می\u{200c}شود",
                "درحال آمدن",
                "ماشین",
                "نزدیک\u{200c}شونده",
                "وسیله\u{654} نقلیه",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("saapuva auto"),
            keywords: &["ajoneuvo", "auto", "saapuva auto"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("paparating na kotse"),
            keywords: &[
                "auto",
                "automobile",
                "paparating",
                "paparating na kotse",
                "sasakyan",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("bilgron"),
            keywords: &["bilgron", "bilur", "gron"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("voiture de face"),
            keywords: &["automobile", "voiture de face"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &[
                "automobile",
                "char",
                "de face",
                "voiture",
                "voiture de face",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("gluaisteán atá ag teacht"),
            keywords: &[
                "ag teacht",
                "carr",
                "carr ag teacht",
                "feithicil",
                "gluaisteán",
                "gluaisteán ag teacht",
                "gluaisteán atá ag teacht",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("càr a’ tighinn thugad"),
            keywords: &["càr", "càr a’ tighinn thugad", "tighinn"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("coche de fronte"),
            keywords: &["automóbil", "coche", "coche de fronte", "vehículo"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("આવી રહ\u{ac7}લ ઑટોમોબાઇલ"),
            keywords: &[
                "આવનાર",
                "આવનારી કાર",
                "આવી રહ\u{ac7}લ ઑટોમોબાઇલ",
                "ઑટોમોબાઇલ",
                "કાર",
                "વાહન",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("mota mai zuwa"),
            keywords: &["mai zuwa", "mota", "mota mai zuwa", "ƙaramar mota"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("מכונית מלפנים"),
            keywords: &["מכונית", "מכונית מלפנים", "תחבורה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("आती ह\u{941}ई कार"),
            keywords: &[
                "आता ह\u{941}आ",
                "आता ह\u{941}आ ऑटोमोबाइल",
                "आती ह\u{941}ई कार",
                "ऑटोमोबाइल",
                "कार",
                "वाहन",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("automobil u dolasku"),
            keywords: &["automobil", "automobil u dolasku", "dolazak", "vozilo"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("érkező autó"),
            keywords: &["autó", "jármű", "kocsi", "érkező"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("մոտեցող ավտոմեքենա"),
            keywords: &["ավտոմեքենա", "մեքենա", "մոտեցող", "փոխադրամիջոց"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("mobil datang"),
            keywords: &["datang", "kendaraan", "mobil"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ụgbọala na-apụta apụta"),
            keywords: &["na-apụta apụta", "ụgbọala", "ụgbọala na-apụta apụta"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("bíll á móti"),
            keywords: &["bíll", "bíll nálgast", "bíll á móti"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("auto in arrivo"),
            keywords: &[
                "auto in arrivo",
                "automobile",
                "automobile in arrivo",
                "in arrivo",
                "veicolo",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("自動車正面"),
            keywords: &["乗り物", "自動車", "自動車正面", "車"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("montor otomatis mara"),
            keywords: &["mara", "montor", "montor otomatis", "montor otomatis mara"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მომავალი ავტომობილი"),
            keywords: &["ავტომობილი", "მანქანა", "მომავალი", "ტრანსპორტი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("келе жатқан автокөлік"),
            keywords: &["автокөлік", "келе жатыр", "келе жатқан автокөлік", "көлік"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("bil forfra"),
            keywords: &["bil", "bil forfra", "fartøj", "kørende"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("រថយន\u{17d2}តមើលព\u{17b8}ម\u{17bb}ខ"),
            keywords: &[
                "ច\u{17c6}ព\u{17b8}ម\u{17bb}ខ",
                "យានយន\u{17d2}ត",
                "រថយន\u{17d2}ត",
                "រថយន\u{17d2}តមើលព\u{17b8}ម\u{17bb}ខ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಮುಂದ\u{cc6} ಬರುತ\u{ccd}ತ\u{cbf}ರುವ ಆಟೊಮೊಬೈಲ\u{ccd}"),
            keywords: &[
                "ಮುಂದ\u{cc6} ಬರುತ\u{ccd}ತ\u{cbf}ರುವ ಆಟೊಮೊಬೈಲ\u{ccd}",
                "ಮುನ\u{ccd}ನುಗ\u{ccd}ಗ\u{cbf} ಬರುವ ಕಾರು",
                "ಮುನ\u{ccd}ನುಗ\u{ccd}ಗ\u{cbf} ಬರುವ ವಾಹನ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("오고 있는 자동차"),
            keywords: &["오고 있는 승용차", "오고 있는 자동차"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("य\u{947}वपी ऑटोमोबायल"),
            keywords: &["ऑटोमोबायल", "कार", "य\u{947}वपी"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("келе жаткан автоунаа"),
            keywords: &[
                "автоунаа",
                "келе жаткан",
                "келе жаткан автоунаа",
                "машина",
                "унаа",
            ],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("entgéintkommenden Auto"),
            keywords: &[
                "Auto",
                "Automobil",
                "entgéintkommend",
                "entgéintkommenden Auto",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ລ\u{ebb}ດຍ\u{ebb}ນກຳລ\u{eb1}ງມາ"),
            keywords: &[
                "ກຳລ\u{eb1}ງມາ",
                "ລ\u{ebb}ດຍ\u{ebb}ນ",
                "ລ\u{ebb}ດຍ\u{ebb}ນກຳລ\u{eb1}ງມາ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("artėjantis automobilis"),
            keywords: &[
                "artėjanti",
                "artėjantis automobilis",
                "automobilis",
                "mašina",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("pretī braucoša automašīna"),
            keywords: &[
                "automašīna",
                "mašīna",
                "pretī braucoša automašīna",
                "transports",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("motokā anga mai"),
            keywords: &["anga mai", "motokā", "motokā anga mai"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("автомобил што пристигнува"),
            keywords: &[
                "автомобил",
                "автомобил што пристигнува",
                "возило",
                "пристигнува",
            ],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("വര\u{d41}ന\u{d4d}ന ഓട\u{d4d}ടോമൊബൈൽ"),
            keywords: &[
                "ഓട\u{d4d}ടോമൊബൈൽ",
                "ക\u{d3e}ർ",
                "വര\u{d41}ന\u{d4d}ന ഓട\u{d4d}ടോമൊബൈൽ",
                "വര\u{d41}ന\u{d4d}ന ക\u{d3e}ർ",
                "വ\u{d3e}ഹനം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("ирж байгаа машин"),
            keywords: &["автомашин", "ирж байгаа машин", "ирж буй", "машин"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("य\u{947}णारी मोटारगाडी"),
            keywords: &[
                "कार",
                "मोटारगाडी",
                "य\u{947}णारी मोटारगाडी",
                "य\u{947}णार\u{947}",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("kereta dari arah depan"),
            keywords: &[
                "automobil",
                "dari arah depan",
                "kereta",
                "kereta dari arah depan",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("karozza ġejja ’l hawn"),
            keywords: &["karozza", "karozza ġejja ’l hawn", "ġejja ’l hawn"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("လာနေသည\u{1037}\u{103a} မော\u{103a}တော\u{103a}ကား"),
            keywords: &[
                "ကား",
                "မော\u{103a}တော\u{103a}ယာဉ\u{103a}",
                "လာနေသည\u{1037}\u{103a} မော\u{103a}တော\u{103a}ကား",
                "လာနေသည\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("motgående bil"),
            keywords: &["bil", "kjøretøy", "motgående"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("आउ\u{901}द\u{948} गर\u{947}को अटोमोबाइल"),
            keywords: &[
                "अटोमोबाइल",
                "आइरह\u{947}को",
                "आउ\u{901}द\u{948} गर\u{947}को अटोमोबाइल",
                "कार",
                "गाडी",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("naderende auto"),
            keywords: &["auto", "automobiel", "naderend", "naderende auto"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("motgåande bil"),
            keywords: &["bil", "køyretøy", "motgåande"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some(
                "ସମ\u{b4d}ମ\u{b41}ଖର\u{b41} ଆସ\u{b41}ଥ\u{b3f}ବ\u{b3e} ଅଟୋମୋବ\u{b3e}ଇଲ\u{b4d}",
            ),
            keywords: &[
                "ଅଟୋମୋବ\u{b3e}ଇଲ\u{b4d}",
                "ଆସ\u{b3f}ବ\u{b3e}କ\u{b41}ଥ\u{b3f}ବ\u{b3e}",
                "କ\u{b3e}ର\u{b4d}",
                "ବ\u{b3e}ହନ",
                "ସମ\u{b4d}ମ\u{b41}ଖର\u{b41} ଆସ\u{b41}ଥ\u{b3f}ବ\u{b3e} ଅଟୋମୋବ\u{b3e}ଇଲ\u{b4d}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਆਉਣ ਵਾਲ\u{a47} ਆਟ\u{a4b}ਮ\u{a4b}ਬਾਈਲ"),
            keywords: &[
                "ਆਉਣ ਵਾਲ\u{a47}",
                "ਆਉਣ ਵਾਲ\u{a47} ਆਟ\u{a4b}ਮ\u{a4b}ਬਾਈਲ",
                "ਆਉਣ ਵਾਲ\u{a47} ਕਾਰ",
                "ਆਟ\u{a4b}ਮ\u{a4b}ਬਾਈਲ",
                "ਕਾਰ",
                "ਵਾਹਨ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("آن آلی آٹو موبائل"),
            keywords: &["آن آلی آٹو موبائل", "آن آلے", "آٹو موبائل", "کار"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Móto Wé De Kọ\u{301}m Wiá Yu Dè"),
            keywords: &[
                "Kaa",
                "Móto",
                "Móto Wé De Kọ\u{301}m Wiá Yu Dè",
                "Sọ\u{301}mtin Wé De Kọ\u{301}m Wiá Yu Dè",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("nadjeżdżający samochód"),
            keywords: &[
                "auto",
                "nadjeżdżające auto",
                "nadjeżdżający pojazd",
                "nadjeżdżający samochód",
                "pojazd",
                "samochód",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("راتلونکی ګاډي"),
            keywords: &["راتلونکی", "راتلونکی ګاډي", "موټر", "ګاړی"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("carro se aproximando"),
            keywords: &[
                "automóvel",
                "automóvel se aproximando",
                "carro",
                "carro se aproximando",
                "se aproximando",
                "veículo",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("automóvel a aproximar-se"),
            keywords: &[
                "aproximação",
                "automóvel",
                "automóvel a aproximar-se",
                "carro",
                "veículo",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("qatiq carru"),
            keywords: &["auto", "carru", "qatiq"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("automobil care se apropie"),
            keywords: &["automobil care se apropie", "mașină", "sosire"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-940"),
            keywords: &["E10-940"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("автомобиль спереди"),
            keywords: &[
                "автомобиль",
                "автомобиль спереди",
                "машина",
                "машина спереди",
                "приближающаяся машина",
                "приближающийся автомобиль",
                "транспорт",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("imodoka iza igusanga"),
            keywords: &["imodoka", "imodoka iza igusanga", "iri kuza"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ايندڙ گاڏي"),
            keywords: &["آٽو موبائيل", "ايندڙ گاڏي", "پهچڻ واري", "ڪار"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ඉද\u{dd2}ර\u{dd2}යට එන මෝටර\u{dca} රථය"),
            keywords: &[
                "ඉද\u{dd2}ර\u{dd2}යට එන",
                "ඉද\u{dd2}ර\u{dd2}යට එන මෝටර\u{dca} රථය",
                "ඔටෝමෝබය\u{dd2}ල\u{dca}",
                "මෝටර\u{dca} රථය",
                "ව\u{dcf}හනය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("prichádzajúce auto"),
            keywords: &["auto", "automobil", "dopravný prostriedok", "prichádzajúce"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("prihajajoči avtomobil"),
            keywords: &[
                "avto",
                "avtomobil",
                "prihajajoče",
                "prihajajoči avtomobil",
                "vozilo",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("gaari soo socda"),
            keywords: &["gaari", "gaari soo socda", "gawaarida", "soo socda"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("automobil që vjen"),
            keywords: &[
                "automobil",
                "automobil që vjen",
                "makinë",
                "mjet",
                "në ardhje",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("аутомобил спреда"),
            keywords: &["aутoмoбил", "аутомобил спреда", "вoзилo", "дoлaзaк"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("аутомобил сприједа"),
            keywords: &["аутомобил сприједа"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("automobil spreda"),
            keywords: &["automobil", "automobil spreda", "dolazak", "vozilo"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("automobil sprijeda"),
            keywords: &["automobil sprijeda"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("mötande bil"),
            keywords: &["bil", "fordon", "mötande"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("gari linalokuja"),
            keywords: &["gari", "linalokuja", "motokaa"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("வந\u{bcd}துகொண\u{bcd}டிருக\u{bcd}கும\u{bcd} க\u{bbe}ர\u{bcd}"),
            keywords: &[
                "க\u{bbe}ர\u{bcd} வந\u{bcd}துகொண\u{bcd}டிருக\u{bcd}கிறது",
                "மோட\u{bcd}ட\u{bbe}ர\u{bcd} வண\u{bcd}டி வந\u{bcd}துகொண\u{bcd}டிருக\u{bcd}கிறது",
                "வந\u{bcd}துகொண\u{bcd}டிருக\u{bcd}கும\u{bcd} க\u{bbe}ர\u{bcd}",
                "வந\u{bcd}துகொண\u{bcd}டிருக\u{bcd}கும\u{bcd} மோட\u{bcd}ட\u{bbe}ர\u{bcd} வண\u{bcd}டி",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ముందువ\u{c48}పు వస\u{c4d}తున\u{c4d}న క\u{c3e}రు"),
            keywords: &[
                "క\u{c3e}రు",
                "ముందు",
                "ముందువ\u{c48}పు వస\u{c4d}తున\u{c4d}న క\u{c3e}రు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("автомобили самти муқобил"),
            keywords: &[
                "автомобил",
                "автомобили самти муқобил",
                "мошин",
                "самти муқобил",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("รถกำล\u{e31}งมา"),
            keywords: &["รถ", "รถกำล\u{e31}งมา"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("gelýän awtomobil"),
            keywords: &["awtomobil", "awtoulag", "gelýän"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("meʻalele lele mai"),
            keywords: &["meʻalele lele mai"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("yaklaşan araba"),
            keywords: &["araba", "otomobil", "taşıt", "yaklaşan"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("كېلىۋاتقان ئاپتوموبىل"),
            keywords: &["ئاپتوموبىل", "كېلىۋاتقان ئاپتوموبىل", "كەل", "ماشىنا"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("автомобіль, що наближається"),
            keywords: &[
                "автомобіль",
                "автомобіль, що наближається",
                "машина",
                "наближається",
                "транспорт",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("آتی ہوئی کار"),
            keywords: &["آتی ہوئی", "آتی ہوئی کار", "کار"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("yaqinlashayotgan avtomobil"),
            keywords: &["avtomobil", "mashina", "transport", "yaqinlashayotgan"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("ô tô đang tới"),
            keywords: &["xe hơi", "ô tô", "ô tô đang tới", "đang tới"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("oto buy ñëw"),
            keywords: &["buy ñëw", "oto", "oto buy ñëw", "otoportaabal"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("imoto ezayo"),
            keywords: &["ezayo", "imoto"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ọkọ Ti Nbọ"),
            keywords: &["tí ń bọ\u{300}", "Ọkọ Ti Nbọ", "ọkọ\u{300}"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("快到嘅汽車"),
            keywords: &["快到", "快到嘅汽車", "汽車"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("快到嘅汽车"),
            keywords: &["快到", "快到嘅汽车", "汽车"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("迎面驶来的汽车"),
            keywords: &["轿车", "迎面驶来的汽车"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("轎車"),
            keywords: &["汽車", "轎車"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("汽車"),
            keywords: &["汽車", "車", "車輛", "轎車"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("imoto ezayo"),
            keywords: &["ezayo", "imoto", "isithuthi"],
        },
    ],
};
#[doc = "🚙"]
pub const SPORT_UTILITY_VEHICLE: crate::Emoji = crate::Emoji {
    glyph: "🚙",
    codepoint: "1F699",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "sport utility vehicle",
    group: "Travel & Places",
    subgroup: "transport-ground",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("ontspanningvoertuig"),
            keywords: &["motor", "ontspanning", "ontspanningvoertuig", "voertuig"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የመዝናኛ መኪና"),
            keywords: &["ተሽከርካሪ", "የመዝናኛ", "የመዝናኛ መኪና"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("\u{202b}مركبة رياضية"),
            keywords: &["آر في", "سيارة", "مركبة", "\u{202b}مركبة رياضية"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("বিনোদনম\u{9c2}লক ব\u{9be}হন"),
            keywords: &["বিনোদন", "বিনোদনম\u{9c2}লক ব\u{9be}হন", "মনোৰঞ\u{9cd}জন"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("rekreasiya avtomobili"),
            keywords: &["nəqliyyat", "rekreasiya", "rekreasiya avtomobili", "rn"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("джып"),
            keywords: &[
                "suv",
                "адпачынак",
                "джып",
                "машына",
                "пазадарожнік",
                "уседарожнік",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("автомобил с повишена проходимост"),
            keywords: &[
                "автомобил с повишена проходимост",
                "почивка",
                "превозно средство",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("বিনোদনম\u{9c2}লক য\u{9be}নব\u{9be}হন"),
            keywords: &["আরভি", "বিনোদনম\u{9c2}লক", "য\u{9be}নব\u{9be}হন"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("terensko vozilo"),
            keywords: &["džip", "terenac", "terensko", "vozilo"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("vehicle tot camí"),
            keywords: &["recreatiu", "tot camí", "vehicle", "vehicle tot camí"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᎳᏍᎦᎵᏗ ᎬᏙᏗ ᏙᎴᎳ"),
            keywords: &["ᎠᎳᏍᎦᎵᏗ ᎬᏙᏗ ᏙᎴᎳ", "ᎠᎾᏁᏦᏍᎩ ᎤᎾᏔᏂᏓᏍᏗ", "ᎤᎾᏛᏁᎵᏓᏍᏗᎢ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("SUV"),
            keywords: &[
                "SUV",
                "auto",
                "džíp",
                "jeep",
                "rekreace",
                "rekreační",
                "sport",
                "vozidlo",
                "vůz",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("cerbyd hamdden"),
            keywords: &["cerbyd", "hamdden"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("firehjulstrækker"),
            keywords: &["firehjulstrækker", "fritid", "jeep", "køretøj"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Wohnmobil"),
            keywords: &["Wohnmobil", "verreisen"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("όχημα αναψυχής"),
            keywords: &["αναψυχής", "όχημα"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("sport utility vehicle"),
            keywords: &["recreational", "sport utility", "sport utility vehicle"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: None,
            keywords: &["4x4", "off-road vehicle", "sport utility"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("four-wheel drive"),
            keywords: &["4WD", "four-wheel drive"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &[
                "SUV",
                "recreational",
                "sport utility",
                "sport utility vehicle",
            ],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &[
                "4x4",
                "off-road vehicle",
                "sport utility",
                "sport utility vehicle",
            ],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("vehículo deportivo utilitario"),
            keywords: &[
                "camping",
                "caravana",
                "furgoneta",
                "vacaciones",
                "vehículo",
                "vehículo deportivo utilitario",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &[
                "auto",
                "automóvil",
                "carro",
                "transporte",
                "vehículo deportivo utilitario",
                "vehículo recreativo",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("vehículo utilitario deportivo"),
            keywords: &["vehículo utilitario deportivo"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("vehículo SUV"),
            keywords: &["SUV", "recreacional", "vehículo SUV"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("mahtuniversaal"),
            keywords: &["auto", "mahtuniversaal", "sõiduk", "universaal"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("aisiarako ibilgailua"),
            keywords: &["aisia", "aisiarako ibilgailua", "ibilgailu"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("خودروی شاسی\u{200c}بلند"),
            keywords: &[
                "اس\u{200c}یووی",
                "تفریحی",
                "خودروی بیابان",
                "خودروی خانواده",
                "خودروی شاسی\u{200c}بلند",
                "شاسی\u{200c}بلند",
                "وسیله تفریحی",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("katumaasturi"),
            keywords: &["ajoneuvo", "auto", "katumaasturi"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("recreational vehicle"),
            keywords: &["recreational vehicle", "rv", "sasakyan"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("húsbilur"),
            keywords: &["bilur", "húsbilur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("véhicule utilitaire sport"),
            keywords: &["loisirs", "voiture", "véhicule utilitaire sport"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("véhicule utilitaire sport"),
            keywords: &["loisirs", "sport", "utilitaire", "véhicule"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("SUV"),
            keywords: &["SUV", "carr", "feithicil", "feithicil áineasa"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("sport utility vehicle"),
            keywords: &["cleasachail", "sport utility vehicle", "suv"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("autocaravana"),
            keywords: &["autocaravana", "vacacións", "vehículo recreativo"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("મનોર\u{a82}જન વાહન"),
            keywords: &[
                "મનોર\u{a82}જન વાહન",
                "સ\u{acd}પોર\u{acd}ટ ય\u{ac1}ટિલિટી",
                "સ\u{acd}પોર\u{acd}ટ ય\u{ac1}ટિલિટી વાહન",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("motar amfani na wasanni"),
            keywords: &[
                "amfani na wasanni",
                "motar amfani na wasanni",
                "na shaƙatawa",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("ג׳יפ"),
            keywords: &["4 על 4", "4*4", "SUV", "ג׳יפ", "תחבורה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("स\u{94d}पोर\u{94d}ट य\u{942}टिलिटी वाहन"),
            keywords: &[
                "SUV",
                "कार",
                "शौकिया वाहन",
                "स\u{94d}पोर\u{94d}ट य\u{942}टिलिटी वाहन",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("rekreacijsko vozilo"),
            keywords: &["rekreacija", "rekreacijsko vozilo", "rv", "vozilo"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("szabadidőautó"),
            keywords: &["SUV", "jármű", "lakókocsi", "szabadidőautó"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ավտոֆուրգոն"),
            keywords: &["ավտոֆուրգոն", "փոխադրամիջոց"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("kendaraan rekreasi"),
            keywords: &["RV", "kendaraan", "rekreasi"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ụgbọala ọkwụ\u{300} ọtọ ekène eze"),
            keywords: &[
                "egwuregwu mmegharị ahụ",
                "nke egwuregwu",
                "ụgbọala ọkwụ\u{300} ọtọ ekène eze",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("jeppi"),
            keywords: &["dægrastytting", "farartæki", "jeppi"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("SUV"),
            keywords: &["SUV", "auto", "veicolo"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("アールブイ車"),
            keywords: &["RV車", "SUV車", "アールブイ車", "乗り物", "自動車", "車"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("tetumpakan srana ulah raga"),
            keywords: &["rekreasi", "srana ulah raga", "tetumpakan srana ulah raga"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("დასასვენებელი ტრანსპორტი"),
            keywords: &["დასასვენებელი", "ტრანსპორტი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("кемпер"),
            keywords: &["кемпер", "көлік"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("firehjulstræk"),
            keywords: &["firehjulstræk", "fritid", "jeep", "køretøj"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("រថយន\u{17d2}តកែច\u{17d2}នៃ"),
            keywords: &["រថយន\u{17d2}ត", "រថយន\u{17d2}តកែច\u{17d2}នៃ", "ឡាន"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಮನರಂಜನ\u{cc6} ವಾಹನ"),
            keywords: &[
                "ಕ\u{ccd}ರೀಡಾ ಯುಟ\u{cbf}ಲ\u{cbf}ಟ\u{cbf} ವಾಹನ",
                "ಕ\u{ccd}ರೀಡಾ ಸ\u{ccc}ಲಭ\u{ccd}ಯ",
                "ಮನರಂಜನ\u{cc6}",
                "ಮನರಂಜನ\u{cc6} ವಾಹನ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("지프"),
            keywords: &["SUV", "지프", "지프차"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("क\u{94d}रीडा उप\u{947}गाच\u{947}\u{902} वाहन"),
            keywords: &[
                "क\u{94d}रीडा उप\u{947}गाच\u{947}\u{902}",
                "क\u{94d}रीडा उप\u{947}गाच\u{947}\u{902} वाहन",
                "मनरिजवण",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("кроссовер"),
            keywords: &["кроссовер", "спорт", "спорттук унаа", "унаа"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("SUV"),
            keywords: &["Fräizäit", "SUV", "Sportswon"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ລ\u{ebb}ດພ\u{eb1}ກຜ\u{ec8}ອນ"),
            keywords: &["ພາຫະນະ", "ລ\u{ebb}ດພ\u{eb1}ກຜ\u{ec8}ອນ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("rekreacijos automobilis"),
            keywords: &[
                "rekreacijos",
                "rekreacijos automobilis",
                "transporto priemonė",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("kemperis"),
            keywords: &["automašīna", "kemperis", "mašīna", "transports"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("taraka hākinakina"),
            keywords: &["hākinakina", "taraka hākinakina"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("кампинг возила"),
            keywords: &["возило", "камп", "кампинг возила", "рекреација"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("റീക\u{d4d}രിയേഷണൽ വെഹിക\u{d4d}കിൾ"),
            keywords: &[
                "ആർവി",
                "ക\u{d3e}ർ",
                "റിക\u{d4d}രിയേഷണൽ വെഹിക\u{d4d}കിൾ",
                "റീക\u{d4d}രിയേഷണൽ വെഹിക\u{d4d}കിൾ",
                "വ\u{d3e}ഹനം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("спорт машин"),
            keywords: &["аялалын", "спорт машин", "спорт хэрэглээний"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("मनोर\u{902}जनात\u{94d}मक वाहन"),
            keywords: &[
                "उपय\u{941}क\u{94d}तता",
                "क\u{94d}रीडा",
                "क\u{94d}रीडा उपय\u{941}क\u{94d}तता वाहन",
                "मनोर\u{902}जक",
                "मनोर\u{902}जनात\u{94d}मक वाहन",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("kenderaan rekreasi"),
            keywords: &["kenderaan", "rekreasi", "rv"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("vettura għal utilità sportiva"),
            keywords: &[
                "rikreazzjoni",
                "utilità sportiva",
                "vettura għal utilità sportiva",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ခရ\u{102e}းကြမ\u{103a}းသ\u{102f}\u{1036}းယာဉ\u{103a}"),
            keywords: &[
                "ခရ\u{102e}းကြမ\u{103a}းသ\u{102f}\u{1036}း",
                "ခရ\u{102e}းကြမ\u{103a}းသ\u{102f}\u{1036}း ယာဉ\u{103a}",
                "ခရ\u{102e}းကြမ\u{103a}းသ\u{102f}\u{1036}းယာဉ\u{103a}",
                "အပန\u{103a}းဖြေ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("SUV"),
            keywords: &["SUV", "bil", "kjøretøy"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("घ\u{941}मफिरको लागि सवारी"),
            keywords: &[
                "गाडी",
                "घ\u{941}मफिरको लागि सवारी",
                "प\u{941}नः बनाउन\u{947}",
                "प\u{941}नःबनाउन\u{947} गाडी",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("SUV"),
            keywords: &["SUV", "auto", "kampeerauto", "voertuig"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("SUV"),
            keywords: &["SUV", "bil", "køyretøy"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("କ\u{b4d}ରୀଡ\u{b3c}\u{b3e} ଉପଯୋଗୀ ଯ\u{b3e}ନବ\u{b3e}ହନ"),
            keywords: &[
                "ଆର\u{b4d}\u{200c}ଭ\u{b3f}",
                "କ\u{b3e}ର\u{b4d}",
                "କ\u{b4d}ରୀଡ\u{b3c}\u{b3e} ଉପଯୋଗୀ ଯ\u{b3e}ନବ\u{b3e}ହନ",
                "ପ\u{b41}ନଃସ\u{b43}ଷ\u{b4d}ଟ\u{b3f}ଜନ\u{b3f}ତ ବ\u{b3e}ହନ",
                "ବ\u{b3e}ହନ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਮਨ\u{a4b}ਰ\u{a70}ਜਕ ਵਾਹਨ"),
            keywords: &["RV", "ਕਾਰ", "ਮਨ\u{a4b}ਰ\u{a70}ਜਕ ਵਾਹਨ", "ਵਾਹਨ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("کھیڈ دی افادی گڈی"),
            keywords: &["تفریحی طور تے", "کھیڈ دی افادی گڈی", "کھیڈ دی افادیت"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Spọ\u{301}t Yutílítí Móto"),
            keywords: &[
                "SUV",
                "Spọ\u{301}t Yutílíti",
                "Spọ\u{301}t Yutílítí Móto",
                "Spọ\u{301}t Yutílítí Vẹ\u{301}híkul",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("samochód SUV"),
            keywords: &["pojazd", "samochód", "samochód SUV", "wypoczynkowy"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د سپورټ د استعمال موټر"),
            keywords: &["تفريحي", "د سپورټ استعمال", "د سپورټ د استعمال موټر"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("SUV"),
            keywords: &["SUV", "carro", "trailer", "veículo", "veículo recreacional"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("SUV"),
            keywords: &["SUV", "recreio", "veículo"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("autocaravana"),
            keywords: &["autocaravana", "recreacional", "ruwasqa pukllay"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("vehicul recreațional"),
            keywords: &[
                "SUV",
                "călătorii",
                "jeep",
                "vacanță",
                "vehicul",
                "vehicul recreațional",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-941"),
            keywords: &["E10-941"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("джип"),
            keywords: &["SUV", "автомобиль", "джип", "отдых", "фургон"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ijipe ya siporo"),
            keywords: &["ijipe ya siporo", "kigamije kuruhura", "pajero"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("راند جي استعمال جي گاڏي"),
            keywords: &["تفريحي", "راند جي استعمال جي گاڏي", "راند جي سهولت"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("වැඩ\u{dd2}ද\u{dd2}ය\u{dd4}ණ\u{dd4} කළ ව\u{dcf}හනය"),
            keywords: &[
                "ව\u{dcf}හනය",
                "වැඩ\u{dd2}ද\u{dd2}ය\u{dd4}ණ\u{dd4}",
                "වැඩ\u{dd2}ද\u{dd2}ය\u{dd4}ණ\u{dd4} කළ",
                "වැඩ\u{dd2}ද\u{dd2}ය\u{dd4}ණ\u{dd4} කළ ව\u{dcf}හනය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("SUV"),
            keywords: &["SUV", "dopravný prostriedok", "rekreačné"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("cestni terenec"),
            keywords: &["cestni terenec", "prostočasno", "vozilo"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("gaadiidka cayaaraha"),
            keywords: &["gaadiidka cayaaraha", "maddadaalo ah"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("makinë sportive për kamp"),
            keywords: &[
                "kamp",
                "makinë sportive",
                "makinë sportive për kamp",
                "piknik",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("камп-возило"),
            keywords: &["вoзилo", "камп-возило", "рeкрeaциja"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("kamp-vozilo"),
            keywords: &["kamp-vozilo", "rekreacija", "vozilo"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("SUV"),
            keywords: &["SUV", "bil", "fordon"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("gari la burudani"),
            keywords: &["gari", "gari la burudani", "la burudani", "rv"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("நவ\u{bc0}ன வசதிகள\u{bcd} கொண\u{bcd}ட வ\u{bbe}கனம\u{bcd}"),
            keywords: &[
                "நவ\u{bc0}ன வசதிகள\u{bcd} கொண\u{bcd}ட பேருந\u{bcd}து",
                "நவ\u{bc0}ன வசதிகள\u{bcd} கொண\u{bcd}ட வ\u{bbe}கனம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("వ\u{c3f}న\u{c4b}ద వ\u{c3e}హనం"),
            keywords: &[
                "వ\u{c3e}హనం",
                "వ\u{c3f}న\u{c4b}ద వ\u{c3e}హనం",
                "వ\u{c3f}న\u{c4b}దం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("кроссовер"),
            keywords: &["кроссовер", "мошини варзишии ҳамаҷогард", "фароғатӣ"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("รถบ\u{e49}าน"),
            keywords: &["รถ", "รถบ\u{e49}าน", "รถพ\u{e31}กผ\u{e48}อน"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ýeňil sport awtoulagy"),
            keywords: &["dynç alyş", "sport ulagy", "ýeňil sport awtoulagy"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("meʻalele sipoti"),
            keywords: &["meʻalele sipoti"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("cip"),
            keywords: &["araba", "cip", "eğlence taşıtı", "taşıt"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("دالا ماشىنىسى"),
            keywords: &["ئۆيلۈك", "تەنتەربىيە قورالى", "دالا ماشىنىسى"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("позашляховик"),
            keywords: &["житловий", "позашляховик", "транспорт", "трейлер", "фургон"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("تفریحی گاڑی"),
            keywords: &["تفریحی", "گاڑی"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("hordiq chiqarish avtomobili"),
            keywords: &["hordiq", "hordiq chiqarish avtomobili", "transport"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("xe thể thao đa dụng"),
            keywords: &["giải trí", "tiện ích thể thao", "xe thể thao đa dụng"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("oto njëkkante"),
            keywords: &["bégal-xol", "njëkkante", "oto njëkkante"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("inqwelo-mafutha yoncedo yomdlalo"),
            keywords: &[
                "inqwelo-mafutha yoncedo yomdlalo",
                "ukuzonwabisa",
                "uncedo lomdlalo",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ọkọ Agbafẹ Daradara"),
            keywords: &[
                "ìgbafẹ\u{301}",
                "òks agbafẹ\u{301} tó dára",
                "Ọkọ Agbafẹ Daradara",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("運動型多功能車"),
            keywords: &["娛樂", "運動型多功能車", "體育用品"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("运动型多功能车"),
            keywords: &["体育用品", "娱乐", "运动型多功能车"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("运动型多用途车"),
            keywords: &["SUV", "休闲车", "运动型多用途车"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("休旅車"),
            keywords: &["休旅車"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("吉普車"),
            keywords: &["休旅車", "吉普車", "旅行車"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("isithuthi sokuzithokozisa"),
            keywords: &[
                "i-rv",
                "isithuthi",
                "isithuthi sokuzithokozisa",
                "ukuzithokozisa",
            ],
        },
    ],
};
#[doc = "🛻"]
pub const PICKUP_TRUCK: crate::Emoji = crate::Emoji {
    glyph: "🛻",
    codepoint: "1F6FB",
    status: crate::Status::FullyQualified,
    introduction_version: 13f32,
    name: "pickup truck",
    group: "Travel & Places",
    subgroup: "transport-ground",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("bakkie"),
            keywords: &["bakkie", "kap", "vrag"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የመሰብሰቢያ መኪና"),
            keywords: &["የመሰብሰቢያ መኪና"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("شاحنة خفيفة"),
            keywords: &["بيك أب", "شاحنة", "شاحنة خفيفة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("পিকআপ ট\u{9cd}ৰ\u{9be}ক"),
            keywords: &["ট\u{9cd}ৰ\u{9be}ক", "পিক-আপ", "পিকআপ"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("pikap yüngül avtomobil"),
            keywords: &["pikap", "pikap yüngül avtomobil", "yük avtomobili"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("пікап"),
            keywords: &["грузавік", "пікап"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("пикап"),
            keywords: &["камион", "пикап", "товарене"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("পিকআপ ট\u{9cd}র\u{9be}ক"),
            keywords: &["ট\u{9cd}র\u{9be}ক", "পিক-আপ", "পিকআপ"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("kamionet"),
            keywords: &["kamionet", "pick-up", "teretno vozilo"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("camioneta descoberta"),
            keywords: &["camioneta", "descoberta", "pickup"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏫᏛᏗ ᎦᎾᏌᏁᏍᏙᏗ"),
            keywords: &["ᎠᎧᎵᎢ", "ᎠᏫᏛᏗ", "ᎦᎾᏌᏁᏍᏙᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("pickup"),
            keywords: &[
                "auto s korbou",
                "malá dodávka",
                "pick-up",
                "pickup",
                "polododávka",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("lori pickup"),
            keywords: &["lori pickup", "pick-up", "pickup", "tryc"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("pickup"),
            keywords: &["pickup", "pickup truck", "varevogn", "åbent lad"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Pick-up"),
            keywords: &["Laster", "Lieferwagen", "Pick-up"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("αγροτικό"),
            keywords: &["αγροτικό", "ημιφορτηγό"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("pickup truck"),
            keywords: &["pick-up", "pickup", "truck"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("ute"),
            keywords: &["pick-up", "pickup", "truck", "ute"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("camioneta"),
            keywords: &["camioneta", "pickup", "ranchera"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["camioneta", "pickup"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("camioneta pickup"),
            keywords: &["camioneta", "pick-up", "pickup"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("pikap"),
            keywords: &["kast", "maastur", "pikap"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("kamioneta"),
            keywords: &["kamioi", "kamioneta"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("وانت"),
            keywords: &["ماشین باری", "وانت", "کامیون"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("lava-auto"),
            keywords: &["avolava", "lava-auto"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("pickup truck"),
            keywords: &["pick-up", "pickup", "pickup truck", "trak"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("opin vørubilur"),
            keywords: &["bilur", "opin", "opin vørubilur", "pickup", "vøruvognur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("pick-up"),
            keywords: &["pick-up", "pickup", "véhicule"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("camionnette"),
            keywords: &["camion", "camionnette"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("trucail oscailte"),
            keywords: &["trucail", "trucail oscailte"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("truca pickup"),
            keywords: &["pick-up", "pickup", "truca"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("camioneta"),
            keywords: &["camioneta", "furgoneta", "vehículo"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("પિકઅપ ટ\u{acd}રક"),
            keywords: &["ટ\u{acd}રક", "પિક-અપ", "પિકઅપ"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("טנדר"),
            keywords: &["טנדר", "כלי רכב", "משאית קטנה", "תחבורה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("पिकअप ट\u{94d}रक"),
            keywords: &["गाड\u{93c}ी", "ट\u{94d}रक", "पिक-अप", "पिकअप", "वाहन"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("kamionet"),
            keywords: &["kamionet", "pick-up", "teretno vozilo"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("kisteherautó"),
            keywords: &["kisteherautó", "pick-up", "pickup"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("պիկապ"),
            keywords: &["ավտոմեքենա", "բեռնատար", "պիկապ", "փիքափ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("truk pikap"),
            keywords: &["pick-up", "pikap", "truk"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("pallbíll"),
            keywords: &["pallbíll", "pallur", "trukkur"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("pickup"),
            keywords: &["camioncino", "pick-up", "pickup"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("軽トラック"),
            keywords: &[
                "トラック",
                "ピックアップトラック",
                "乗り物",
                "車",
                "軽トラック",
                "配達",
            ],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("trek pikep"),
            keywords: &["methuk", "pikep", "trek"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("პიკაპი"),
            keywords: &["მანქანა", "პიკაპი", "სატვირთო", "ტვირთი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("пикап"),
            keywords: &["жүк машинасы", "пикап"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("រថយន\u{17d2}តភ\u{17b8}កអាប\u{17cb}"),
            keywords: &[
                "ភ\u{17b8}កអាប\u{17cb}",
                "រថយន\u{17d2}ត",
                "រថយន\u{17d2}តភ\u{17b8}កអាប\u{17cb}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಪ\u{cbf}ಕಪ\u{ccd} ಟ\u{ccd}ರಕ\u{ccd}"),
            keywords: &[
                "ಟ\u{ccd}ರಕ\u{ccd}",
                "ಪ\u{cbf}ಕಪ\u{ccd} ಟ\u{ccd}ರಕ\u{ccd}",
                "ಪ\u{cbf}ಕ\u{ccd}-ಅಪ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("픽업트럭"),
            keywords: &["트럭", "픽업", "픽업트럭"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("पिकअप ट\u{94d}रक"),
            keywords: &["ट\u{94d}रक", "पिक-अप", "पिकअप"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("чакан жүк ташуучу унаа"),
            keywords: &[
                "аркасы ачык",
                "жүк ташуучу унаа",
                "пикап",
                "чакан",
                "чакан жүк ташуучу унаа",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ລ\u{ebb}ດຂ\u{ebb}ນສ\u{ebb}\u{ec8}ງປ\u{eb4}ກອ\u{eb1}ບ"),
            keywords: &[
                "ລ\u{ebb}ດ",
                "ລ\u{ebb}ດກະບະ",
                "ລ\u{ebb}ດຂ\u{ebb}ນສ\u{ebb}\u{ec8}ງປ\u{eb4}ກອ\u{eb1}ບ",
                "ລ\u{ebb}ດປ\u{eb4}ກອ\u{eb1}ບ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("pikapas"),
            keywords: &["pikapas", "sunkvežimis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("piegādes auto"),
            keywords: &["mašīna", "piegāde", "piegādes auto", "pikaps"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("камионет"),
            keywords: &["камион", "камионет"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("പിക\u{d4d}കപ\u{d4d}പ\u{d4d} ട\u{d4d}രക\u{d4d}ക\u{d4d}"),
            keywords: &[
                "ട\u{d4d}രക\u{d4d}ക\u{d4d}",
                "പിക\u{d4d}കപ\u{d4d}പ\u{d4d}",
                "പിക\u{d4d}ക\u{d4d}-അപ\u{d4d}പ\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("пикап хагас чиргүүлтэй машин"),
            keywords: &["ачааны машин", "пикап", "пикап хагас чиргүүлтэй машин"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("मालवाह\u{942} ट\u{94d}रक"),
            keywords: &[
                "ट\u{94d}रक",
                "पिकअप",
                "मालवाह\u{942} ट\u{94d}रक",
                "सामान न\u{947}णारा",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("trak pikap"),
            keywords: &["pikap", "pungutan", "trak"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ပစ\u{103a}ကပ\u{103a}ကား"),
            keywords: &[
                "ထရပ\u{103a}ကား",
                "ပစ\u{103a}ကပ\u{103a}",
                "ပစ\u{103a}ကပ\u{103a}ကား",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("pickup"),
            keywords: &["lastebil", "liten", "pickup"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("पिकअप ट\u{94d}रक"),
            keywords: &["ट\u{94d}रक", "पिक-अप", "पिकअप"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("pick-up"),
            keywords: &["bestelbak", "laadbak", "laadbakwagen", "pick-up"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("pickup"),
            keywords: &["lastebil", "liten", "pickup"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ପ\u{b3f}କ\u{b4d}\u{200d}ଅପ\u{b4d}\u{200c} ଟ\u{b4d}ରକ\u{b4d}\u{200c}"),
            keywords: &[
                "ଟ\u{b4d}ରକ\u{b4d}\u{200c}",
                "ପ\u{b3f}କ\u{b4d}\u{200c}-ଅପ\u{b4d}\u{200c}",
                "ପ\u{b3f}କ\u{b4d}\u{200d}ଅପ\u{b4d}\u{200c}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਪਿ\u{a71}ਕਅ\u{a71}ਪ ਟਰ\u{a71}ਕ"),
            keywords: &["ਟਰ\u{a71}ਕ", "ਪਿ\u{a71}ਕ-ਅ\u{a71}ਪ", "ਪਿ\u{a71}ਕਅ\u{a71}ਪ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Píkọ\u{301}p"),
            keywords: &["Móto", "Pík-ọp", "Píkọp", "Píkọ\u{301}p"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("pick-up"),
            keywords: &["furgonetka", "pick-up", "pikap", "półciężarówka"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("پک اپ"),
            keywords: &["ټرک", "پيکپ", "پک اپ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("caminhonete"),
            keywords: &["caminhonete", "pick-up", "veículo"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("carrinha"),
            keywords: &["carrinha"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("camionetă"),
            keywords: &["camion", "camionetă", "mașină papuc"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E13-049"),
            keywords: &["E13-049"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("пикап"),
            keywords: &["автомобиль", "грузовик", "машина", "пикап"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("پڪ اپ ٽرڪ"),
            keywords: &["ٽرڪ", "پڪ اپ", "پڪ اپ ٽرڪ", "پڪ-اپ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("කැබ\u{dca} රථය"),
            keywords: &[
                "කැබ\u{dca} රථය",
                "ට\u{dca}\u{200d}රක\u{dca} රථය",
                "ප\u{dd2}කප\u{dca}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("pikap"),
            keywords: &["auto", "pikap", "zásobovanie"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("poltovornjak"),
            keywords: &["pick-up", "pickup", "poltovornjak"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("qabaalka"),
            keywords: &["gaari xamuul ah", "qaadista", "qabaalka", "wax qaadid"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("karroatrec"),
            keywords: &["kamion", "karroatrec", "tërheqje"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("пикап возило"),
            keywords: &["пикап", "пикап возило", "теретно возило"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("pikap vozilo"),
            keywords: &["pikap", "pikap vozilo", "teretno vozilo"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("pickup"),
            keywords: &["lastbil", "pickup", "transportvagn", "varubil"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("gari la mizigo"),
            keywords: &["gari la mizigo", "kubeba mizigo", "lori"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பிக\u{bcd}கப\u{bcd} ல\u{bbe}ரி"),
            keywords: &["பிக\u{bcd}அப\u{bcd}", "பிக\u{bcd}கப\u{bcd}", "ல\u{bbe}ரி"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ప\u{c3f}కప\u{c4d} ట\u{c4d}రక\u{c4d}"),
            keywords: &[
                "ట\u{c4d}రక\u{c4d}",
                "ప\u{c3f}కప\u{c4d}",
                "ప\u{c3f}క\u{c4d}-అప\u{c4d}",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("รถกระบะ"),
            keywords: &[
                "รถกระบะ",
                "รถป\u{e34}คอ\u{e31}พ",
                "รถป\u{e34}\u{e4a}กอ\u{e31}พ",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("pikap ulagy"),
            keywords: &["pikap", "pikap ulagy", "ýük ulagy"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("lolo tapolokepi"),
            keywords: &["lolo tapolokepi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("pikap"),
            keywords: &["kamyon", "kamyonet", "pikap"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("автомобіль-пікап"),
            keywords: &[
                "автомобіль-пікап",
                "вантажівка",
                "легка вантажівка",
                "пікап",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("پک اپ ٹرک"),
            keywords: &["ٹرک", "پک اپ", "پک اپ ٹرک"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("yuk mashinasi"),
            keywords: &["ortish", "tashish", "yuk mashinasi"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("xe bán tải"),
            keywords: &["nhận hàng", "xe bán tải", "xe tải"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("農夫車"),
            keywords: &["收集", "貨車", "農夫車"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("农夫车"),
            keywords: &["农夫车", "收集", "货车"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("敞蓬小型载货卡车"),
            keywords: &["卡车", "敞蓬小型载货卡车", "载货"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("皮卡車"),
            keywords: &["卡車", "敞篷小貨車", "皮卡車"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("iloli likadoti"),
            keywords: &["cosha", "iloli", "iloli likadoti"],
        },
    ],
};
#[doc = "🚚"]
pub const DELIVERY_TRUCK: crate::Emoji = crate::Emoji {
    glyph: "🚚",
    codepoint: "1F69A",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "delivery truck",
    group: "Travel & Places",
    subgroup: "transport-ground",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("afleweringswa"),
            keywords: &["aflewering", "afleweringswa", "voertuig", "vragmotor", "wa"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የዕቃ ማድረሻ መኪና"),
            keywords: &["ማድረሻ", "ተሽከርካሪ", "የዕቃ ማድረሻ መኪና", "የጭነት መኪና"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("شاحنة توصيل طلبات"),
            keywords: &["شاحنة", "شاحنة توصيل طلبات", "مركبة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ডেলিভ\u{9be}ৰী ট\u{9cd}ৰ\u{9be}ক"),
            keywords: &["ট\u{9cd}ৰ\u{9be}ক", "ডেলিভ\u{9be}ৰী"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("yük maşını"),
            keywords: &["nəqliyyat", "yük maşını", "çatdırılma"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("грузавік"),
            keywords: &["грузавік", "дастаўка", "развоз"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("камион за доставки"),
            keywords: &[
                "доставки",
                "камион",
                "камион за доставки",
                "превозно средство",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("সরবর\u{9be}হের ট\u{9cd}র\u{9cd}য\u{9be}ক"),
            keywords: &[
                "ট\u{9cd}র\u{9be}ক",
                "য\u{9be}নব\u{9be}হন",
                "সরবর\u{9be}হ",
                "সরবর\u{9be}হের ট\u{9cd}র\u{9cd}য\u{9be}ক",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("karr-samm degas"),
            keywords: &["degas", "karr-samm"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("dostavno vozilo"),
            keywords: &["dostava", "dostavno vozilo", "kamion"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("camió de repartiment"),
            keywords: &["camió", "camió de repartiment", "repartiment"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎦᏅᏔᏂᏙᎯ ᎦᎾᏌᏁᏍᏙᏗ"),
            keywords: &["ᎦᎾᏌᏁᏍᏙᏗ", "ᎦᏅᏔᏂᏙᎯ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("dodávka"),
            keywords: &["dodávka", "vozidlo"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("lori dosbarthu"),
            keywords: &["cerbyd", "dosbarthu", "lori"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("lastbil"),
            keywords: &["køretøj", "lastbil", "levering", "transport", "truck"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Lieferwagen"),
            keywords: &["LKW", "Lastwagen", "Lieferwagen"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("φορτηγό"),
            keywords: &["διανομή", "φορτηγό", "όχημα"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("delivery truck"),
            keywords: &["delivery", "truck"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: Some("delivery van"),
            keywords: &["delivery", "delivery van", "truck"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("camión de reparto"),
            keywords: &[
                "camión de reparto",
                "mercancías",
                "reparto",
                "transporte",
                "vehículo",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["camión", "camión de reparto", "reparto", "transporte"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kulleriauto"),
            keywords: &["kuller", "kulleriauto", "sõiduk", "veoauto"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("garraiatzeko kamioia"),
            keywords: &["garraiatzeko kamioia", "garraio", "ibilgailu", "kamioi"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("کامیون پخش"),
            keywords: &[
                "تحویل",
                "حمل\u{200c}ونقل",
                "وسیله\u{654} نقلیه",
                "کامیون",
                "کامیون پخش",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kuljetusauto"),
            keywords: &["ajoneuvo", "auto", "kuljetusauto", "rekka"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("delivery truck"),
            keywords: &["delivery", "sasakyan", "truck"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("vøruvognur"),
            keywords: &["bilur", "lastbilur", "liðbussur", "vørubilur", "vøruvognur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("camion de livraison"),
            keywords: &["camion", "camion de livraison"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["camion", "camion de livraison", "livraison"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("trucail seachadta"),
            keywords: &["feithicil", "trucail", "trucail seachadta", "veain"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("làraidh-lìbhrigidh"),
            keywords: &["làraidh", "làraidh-lìbhrigidh", "lìbhrigeadh"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("camión de reparto"),
            keywords: &["camión", "camión de reparto"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("વિતરણ ટ\u{acd}રક"),
            keywords: &["ટ\u{acd}રક", "વાહન", "વિતરણ ટ\u{acd}રક"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("babbar mota ta isarwa kaya"),
            keywords: &["babbar mota", "babbar mota ta isarwa kaya", "isarwar kaya"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("משאית"),
            keywords: &["משאית", "תחבורה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("डिलीवरी ट\u{94d}रक"),
            keywords: &["ट\u{94d}रक", "डिलीवरी ट\u{94d}रक", "वाहन"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("dostavni kamion"),
            keywords: &["dostava", "dostavni kamion", "kamion", "vozilo"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("teherautó"),
            keywords: &["autó", "jármű", "teherautó", "teherfuvarozás"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("բեռնատար"),
            keywords: &["առաքում", "բեռնատար", "փոխադրամիջոց"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("truk pengiriman"),
            keywords: &["kendaraan", "pengiriman", "truk"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ụgbọala nnyefe ibu"),
            keywords: &["nnyefe", "ụgbọala ibu", "ụgbọala nnyefe ibu"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("flutningabíll"),
            keywords: &["flutningabifreið", "flutningabíll", "sendibíll"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("camion"),
            keywords: &["camion", "veicolo"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("トラック"),
            keywords: &["トラック", "乗り物", "車", "配達"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("prahoto pangiriman"),
            keywords: &["pangiriman", "prahoto"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მიმწოდებელი სატვირთო მანქანა"),
            keywords: &[
                "მიმწოდებელი სატვირთო მანქანა",
                "მიტანა",
                "სატვირთო",
                "ტრანსპორტი",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("жүк көлігі"),
            keywords: &["жеткізу", "жүк көлігі", "көлік"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("lastbil"),
            keywords: &["køretøj", "lastbil", "levering", "transport"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("រថយន\u{17d2}តដ\u{17b9}កទ\u{17c6}ន\u{17b7}ញ"),
            keywords: &[
                "ដ\u{17b9}កទ\u{17c6}ន\u{17b7}ញ",
                "រថយន\u{17d2}ត",
                "រថយន\u{17d2}តដ\u{17b9}កទ\u{17c6}ន\u{17b7}ញ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಡ\u{cc6}ಲ\u{cbf}ವರ\u{cbf} ಟ\u{ccd}ರಕ\u{ccd}"),
            keywords: &[
                "ಟ\u{ccd}ರಕ\u{ccd}",
                "ಡ\u{cc6}ಲ\u{cbf}ವರ\u{cbf} ಟ\u{ccd}ರಕ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("운송 트럭"),
            keywords: &["운송", "운송 차량", "운송 트럭"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("डिलिवरी ट\u{94d}रक"),
            keywords: &["ट\u{94d}रक", "डिलिवरी"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("жүк ташуучу машина"),
            keywords: &["жүк ташуу", "жүк ташуучу машина", "унаа"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Liwwerwon"),
            keywords: &["Liwwerung", "Liwwerwon", "Won"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ລ\u{ebb}ດຂ\u{ebb}ນສ\u{ebb}\u{ec8}ງ"),
            keywords: &["ພາຫະນະ", "ລ\u{ebb}ດຂ\u{ebb}ນສ\u{ebb}\u{ec8}ງ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("krovininis sunkvežimis"),
            keywords: &["krovininis sunkvežimis", "pristatymas", "sunkvežimis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("kravas automašīna"),
            keywords: &[
                "automašīna",
                "krava",
                "kravas automašīna",
                "mašīna",
                "transports",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("taraka tiki"),
            keywords: &["taraka", "tiki"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("камион за испорака"),
            keywords: &["возило", "испорака", "камион", "камион за испорака"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഡെലിവറി ട\u{d4d}രക\u{d4d}ക\u{d4d}"),
            keywords: &[
                "ട\u{d4d}രക\u{d4d}ക\u{d4d}",
                "ഡെലിവറി ട\u{d4d}രക\u{d4d}ക\u{d4d}",
                "വ\u{d3e}ഹനം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("хүргэлтийн ачааны тэрэг"),
            keywords: &["ачааны машин", "хүргэлт", "хүргэлтийн ачааны тэрэг"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("वितरण करणारा ट\u{94d}रक"),
            keywords: &["ट\u{94d}रक", "वितरण", "वितरण करणारा ट\u{94d}रक"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("trak penghantaran"),
            keywords: &["kenderaan", "penghantaran", "trak"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("trakk tal-konsenji"),
            keywords: &["konsenji", "trakk", "trakk tal-konsenji"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "ပစ\u{1039}စည\u{103a}းပ\u{102d}\u{102f}\u{1037}သည\u{1037}\u{103a} ထရပ\u{103a}ကား",
            ),
            keywords: &[
                "ထရပ\u{103a}ကား",
                "ပစ\u{1039}စည\u{103a}းပ\u{102d}\u{102f}\u{1037}",
                "ပစ\u{1039}စည\u{103a}းပ\u{102d}\u{102f}\u{1037}သည\u{1037}\u{103a} ထရပ\u{103a}ကား",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("varebil"),
            keywords: &["bil", "kjøretøy", "varebil"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("ढ\u{941}वानीका लागि ट\u{94d}रक"),
            keywords: &[
                "ट\u{94d}रक",
                "ड\u{947}लिभरी",
                "ढ\u{941}वानीका लागि ट\u{94d}रक",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("bestelbus"),
            keywords: &["bestelbus", "bezorging", "bus"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("varebil"),
            keywords: &["bil", "køyretøy", "varebil"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ବ\u{b3f}ତରଣ ଟ\u{b4d}ରକ\u{b4d}\u{200c}"),
            keywords: &[
                "ଟ\u{b4d}ରକ\u{b4d}",
                "ଡେଲ\u{b3f}ଭେର\u{b3f} ଟ\u{b4d}ରକ\u{b4d}",
                "ବ\u{b3e}ହନ",
                "ବ\u{b3f}ତରଣ ଟ\u{b4d}ରକ\u{b4d}\u{200c}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਡਿਲੀਵਰੀ ਟਰ\u{a71}ਕ"),
            keywords: &["ਟਰ\u{a71}ਕ", "ਡਿਲੀਵਰੀ ਟਰ\u{a71}ਕ", "ਵਾਹਨ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ڈیلیوری آلا ٹرک"),
            keywords: &["حوالگی", "ٹرک", "ڈیلیوری آلا ٹرک"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Móto Wé De Kárí Tins To Kọ\u{301}stọ\u{301}ma-dẹm"),
            keywords: &[
                "Móto",
                "Móto Wé De Kárí Tins To Kọ\u{301}stọ\u{301}ma-dẹm",
                "To Kárí Tins To Pípul",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("samochód dostawczy"),
            keywords: &["ciężarówka", "dostawczy", "samochód dostawczy"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د وړاندې کولو لارۍ"),
            keywords: &["د وړاندې کولو لارۍ", "لارۍ", "وړاندې کول"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("caminhão de entrega"),
            keywords: &["caminhão", "caminhão de entrega", "veículo"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("camião de entregas"),
            keywords: &["camião", "camião de entregas", "entregas", "veículo"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("qupuspa camión"),
            keywords: &["camión", "qupuspa"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("camion de marfă"),
            keywords: &["camion", "camion de marfă", "livrare", "marfă"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-942"),
            keywords: &["E10-942"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("грузовик"),
            keywords: &["грузовик", "грузовой транспорт", "кузов", "транспорт"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ikamyo ipakira ibintu"),
            keywords: &["ikamyo", "ikamyo ipakira ibintu", "ipakira ibintu"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("پهچائڻ جي ٽرڪ"),
            keywords: &["ٽرڪ", "پهچائڻ", "پهچائڻ جي ٽرڪ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("බෙද\u{dcf} හැර\u{dd3}මේ ට\u{dca}\u{200d}රක\u{dca} රථය"),
            keywords: &[
                "ට\u{dca}\u{200d}රක\u{dca} රථය",
                "බෙද\u{dcf} හැර\u{dd3}ම",
                "බෙද\u{dcf} හැර\u{dd3}මේ ට\u{dca}\u{200d}රක\u{dca} රථය",
                "ව\u{dcf}හනය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("zásobovacie auto"),
            keywords: &[
                "dopravný prostriedok",
                "kamión",
                "zásobovacie auto",
                "zásobovanie",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("dostavno vozilo"),
            keywords: &["dostavno", "poltovornjak", "vozilo"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("gaari xammuulka adeegga"),
            keywords: &["gaari xammuul", "gaari xammuulka adeegga", "geynta"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("kamion transporti"),
            keywords: &["kamion", "kamion transporti", "mjet udhëtimi", "transport"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("теретни камион"),
            keywords: &["дoстaвa", "кaмиoн", "теретни камион"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["теретни камион"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("teretni kamion"),
            keywords: &["dostava", "kamion", "teretni kamion"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["teretni kamion"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("budbil"),
            keywords: &["budbil", "fordon", "skåpbil"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("gari la kusafirisha mizigo"),
            keywords: &["gari", "gari la kusafirisha mizigo", "kusafirisha", "lori"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("சரக\u{bcd}கு வண\u{bcd}டி"),
            keywords: &[
                "சரக\u{bcd}கு ல\u{bbe}ரி",
                "சரக\u{bcd}கு வண\u{bcd}டி",
                "டிரக\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("వస\u{c4d}తువుల సరఫర\u{c3e} వ\u{c3e}హనం"),
            keywords: &[
                "వస\u{c4d}తువు",
                "వస\u{c4d}తువుల సరఫర\u{c3e} వ\u{c3e}హనం",
                "వ\u{c3e}హనం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("автомобили боркаш"),
            keywords: &["автомобили боркаш", "бурдарасонӣ", "мошини боркаш"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("รถขนส\u{e48}ง"),
            keywords: &["รถ", "รถขนส\u{e48}ง"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("awtofurgon"),
            keywords: &["awtofurgon", "ýük daşaýan", "ýük ulagy"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("loli tiliva"),
            keywords: &["loli tiliva"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("nakliye kamyonu"),
            keywords: &["kamyon", "nakliye kamyonu", "taşıt"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("مال ماشىنىسى"),
            keywords: &["ماشىنىسى", "مال"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("вантажівка для доставки"),
            keywords: &["вантажівка для доставки", "доставка", "транспорт", "фургон"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ڈلیوری ٹرک"),
            keywords: &["ٹرک", "ڈلیوری"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("yetkazib beruvchi yuk mashinasi"),
            keywords: &[
                "transport",
                "yetkazib berish",
                "yetkazib beruvchi yuk mashinasi",
                "yuk mashinasi",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("xe tải giao hàng"),
            keywords: &["giao hàng", "xe tải", "xe tải giao hàng"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("kamiyoŋu bagaas"),
            keywords: &["bagaas", "kamiyoŋu"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("itraka yomthwalo"),
            keywords: &["itraka", "itraka yomthwalo", "umthwalo"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ọkọ Akẹru"),
            keywords: &["ifijiṣẹ", "Ọkọ Akẹru"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("送貨車"),
            keywords: &["卡車", "送貨", "送貨車"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("送货车"),
            keywords: &["卡车", "送货", "送货车"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("货车"),
            keywords: &["卡车", "货车"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("貨車"),
            keywords: &["卡車", "貨車"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["貨車", "送貨卡車", "送貨貨車"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("iloli lokudiliva"),
            keywords: &["iloli", "iloli lokudiliva", "isithuthi", "ukudiliva"],
        },
    ],
};
#[doc = "🚛"]
pub const ARTICULATED_LORRY: crate::Emoji = crate::Emoji {
    glyph: "🚛",
    codepoint: "1F69B",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "articulated lorry",
    group: "Travel & Places",
    subgroup: "transport-ground",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("gelede voertuig"),
            keywords: &["gelede voertuig", "trok", "voertuig", "vragmotor"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ሽፍን የጭነት ማመላለሻ መኪና"),
            keywords: &[
                "ሽፍን የጭነት ማመላለሻ መኪና",
                "ተሽከርካሪ",
                "አነስተኛ የጭነት መኪና",
                "ከፊል",
                "የጭነት መኪና",
            ],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("لوري"),
            keywords: &["شاحنة", "لوري", "لوري شبه مقطورة", "مركبة", "مقطورة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("আৰ\u{9cd}টিক\u{9c1}লেটেড লৰি"),
            keywords: &[
                "আৰ\u{9cd}টিক\u{9c1}লেটেড লৰি",
                "ছেমি",
                "ট\u{9cd}ৰ\u{9be}ক",
                "লৰি",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("konteynerli maşın"),
            keywords: &["konteynerli maşın", "nəqliyyat", "yarım", "yük maşını"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("аўтапоезд"),
            keywords: &[
                "аўтапоезд",
                "грузавік",
                "дальнабойшчык",
                "перавозка",
                "фура",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("камион с полуремарке"),
            keywords: &[
                "камион",
                "камион с полуремарке",
                "полуремарке",
                "превозно средство",
                "тир",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("আর\u{9cd}টিক\u{9c1}লেট লরি"),
            keywords: &[
                "আর\u{9cd}টিক\u{9c1}লেট লরি",
                "ট\u{9cd}র\u{9be}ক",
                "য\u{9be}নব\u{9be}হন",
                "লরি",
                "সেমি",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("sammgarr-ramoker"),
            keywords: &["sammgarr", "sammgarr-ramoker"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("teretni kamion"),
            keywords: &["kamion", "teret", "teretni kamion", "vozilo"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("camió articulat"),
            keywords: &["articulat", "camió"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎸᏁᎢᏍᏔᏅ ᎦᏅᏔᏂᏙᎯ"),
            keywords: &["ᎤᎾᏦᏙᏗ", "ᎤᏔᎾ ᎤᎾᏦᏙᏗ", "ᎦᏅᏔᏂᏙᎯ", "ᎸᏁᎢᏍᏔᏅ ᎦᏅᏔᏂᏙᎯ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("kamion"),
            keywords: &[
                "autodoprava",
                "kamion",
                "nákladní",
                "náklaďák",
                "tir",
                "tirák",
                "truck",
                "vozidlo",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("lori gymalog"),
            keywords: &["cerbyd", "lori", "lori gymalog", "rhannol"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("lastvogn"),
            keywords: &[
                "køretøj",
                "lastbil",
                "lastvogn",
                "levering",
                "transport",
                "truck",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Sattelzug"),
            keywords: &["LKW", "Lastwagen", "Sattelzug"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("τριαξονικό"),
            keywords: &[
                "επικαθήμενο",
                "ημιεπικαθήμενο",
                "συρόμενο",
                "τριαξονικό",
                "φορτηγό",
                "όχημα",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("articulated lorry"),
            keywords: &["articulated lorry", "lorry", "semi", "truck"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("articulated truck"),
            keywords: &["articulated truck", "lorry", "semi", "truck"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("semi"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("camión articulado"),
            keywords: &["camión", "camión articulado", "tráiler", "vehículo"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["acoplado", "camión", "camión articulado", "transporte"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("trailer"),
            keywords: &["trailer"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("tractocamión"),
            keywords: &[
                "acoplado",
                "camión",
                "camión de carga",
                "tractocamión",
                "transporte",
            ],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("veok"),
            keywords: &["sõiduk", "veoauto", "veok"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("kamioi artikulatua"),
            keywords: &["ibilgailu", "kamioi", "kamioi artikulatua", "semi"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("کامیون مفصلی"),
            keywords: &[
                "ماشین باری",
                "ماشین سنگین",
                "مفصل",
                "مفصلی",
                "کامیون باری",
                "کامیون دوتکه",
                "کامیون مفصلی",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("rekka-auto"),
            keywords: &["ajoneuvo", "auto", "rekka", "rekka-auto"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("semi-trailer truck"),
            keywords: &["sasakyan", "semi-trailer truck", "trailer", "truck"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("liðlastbilur"),
            keywords: &[
                "bilur",
                "lastbilur",
                "liðbussur",
                "liðlastbilur",
                "vørubilur",
                "vøruvognur",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("semi-remorque"),
            keywords: &["camion", "poids lourd", "semi", "semi-remorque"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("camion semi-remorque"),
            keywords: &["camion", "poids lourd", "semi", "semi-remorque"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("leoraí"),
            keywords: &[
                "feithicil",
                "leantóir",
                "leath",
                "leoraí",
                "leoraí altach",
                "trucail",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("làraidh altanach"),
            keywords: &["làraidh", "làraidh altanach", "semi", "truca"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("camión articulado"),
            keywords: &["camión", "camión articulado", "tráiler"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ખટારો"),
            keywords: &[
                "કલાત\u{acd}મક ખટારો",
                "ખટારો",
                "ટ\u{acd}રક",
                "ટ\u{acd}ર\u{ac7}લર",
                "વાહન",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("tirela mai tarakta"),
            keywords: &["babbar mota", "kaɗan", "tirela", "tirela mai tarakta"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("משאית מפרקית"),
            keywords: &["משאית מפרקית", "משאית עפר", "סמי"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("लॉरी, आर\u{94d}टिक\u{94d}य\u{942}ल\u{947}ट\u{947}ड लॉरी"),
            keywords: &[
                "आर\u{94d}टिक\u{94d}य\u{942}ल\u{947}ट\u{947}ड लॉरी",
                "ट\u{94d}रक",
                "ट\u{94d}र\u{947}लर",
                "लॉरी",
                "लॉरी, आर\u{94d}टिक\u{94d}य\u{942}ल\u{947}ट\u{947}ड लॉरी",
                "वाहन",
                "स\u{947}मी",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("zglobni kamion"),
            keywords: &["kamion", "prikolica", "vozilo", "zglob", "zglobni kamion"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("billenős teherautó"),
            keywords: &["autó", "billenős teherautó", "jármű", "teherfuvarozás"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("կցորդով բեռնատար"),
            keywords: &["բեռնատար", "կցորդ", "կցորդով բեռնատար", "փոխադրամիջոց"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("lori gandeng"),
            keywords: &["kendaraan", "lori", "lori gandeng", "semi", "truk"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("nnukwu ụgbọala ahàziri nke ọma"),
            keywords: &[
                "keetiti",
                "nnukwu ụgbọala ahàziri nke ọma",
                "nuukwu ụgbọala ibu",
                "ụgbọala ibu",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("vörubíll"),
            keywords: &["flutningabíll", "trukkur", "vörubifreið", "vörubíll"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("autoarticolato"),
            keywords: &["autoarticolato", "camion", "rimorchio", "veicolo"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("トレーラー"),
            keywords: &["トラック", "トレーラー", "乗り物", "車"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("lori gandheng"),
            keywords: &["lori", "lori gandheng", "prahoto", "separo"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("პატარა სატვირთო მანქანა"),
            keywords: &["პატარა სატვირთო მანქანა", "სატვირთო", "ტრანსპორტი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("автопойыз"),
            keywords: &[
                "автопойыз",
                "жартылай",
                "жүк көлігі",
                "жүк тасу көлігі",
                "көлік",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("lastvogn"),
            keywords: &["køretøj", "lastbil", "lastvogn", "levering", "transport"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ក\u{17bb}ងទ\u{17b8}ន\u{17d0}រ"),
            keywords: &[
                "ក\u{17bb}ងទ\u{17b8}ន\u{17d0}រ",
                "ឡានក\u{17bb}ងទ\u{17b8}ន\u{17d0}រ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಆರ\u{ccd}ಟ\u{cbf}ಕ\u{ccd}ಯುಲೇಟ\u{cc6}ಡ\u{ccd} ಲಾರ\u{cbf}"),
            keywords: &[
                "ಅರ\u{ccd}ಧ",
                "ಆರ\u{ccd}ಟ\u{cbf}ಕ\u{ccd}ಯುಲೇಟ\u{cc6}ಡ\u{ccd} ಲಾರ\u{cbf}",
                "ಲಾರ\u{cbf}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("트레일러 트럭"),
            keywords: &["트레일러", "트레일러 트럭"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("आर\u{94d}टिक\u{941}ल\u{947}ट\u{947}ड लॉरी"),
            keywords: &[
                "आर\u{94d}टिक\u{941}ल\u{947}ट\u{947}ड लॉरी",
                "ट\u{94d}रक",
                "लॉरी",
                "स\u{945}मी",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("чиркегичи бар жүк ташуучу унаа"),
            keywords: &[
                "жүк ташуучу",
                "унаа",
                "чиркегич",
                "чиркегичи бар жүк ташуучу унаа",
            ],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Sattelschlepper"),
            keywords: &["Camion", "Sattelschlepper", "Schlepper", "Semi"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ລ\u{ebb}ດພວງບ\u{eb1}ນທ\u{eb8}ກ"),
            keywords: &[
                "ຂ\u{ebb}ນສ\u{ebb}\u{ec8}ງ",
                "ບ\u{eb1}ນທ\u{eb8}ກ",
                "ລ\u{ebb}ດພວງ",
                "ລ\u{ebb}ດພວງບ\u{eb1}ນທ\u{eb8}ກ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("sunkvežimis su priekaba"),
            keywords: &["priekaba", "pusė", "sunkvežimis", "sunkvežimis su priekaba"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("smagā automašīna"),
            keywords: &[
                "automašīna",
                "krava",
                "mašīna",
                "smagā automašīna",
                "transports",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("taraka tautō"),
            keywords: &["hemi", "taraka", "taraka tautō"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("шлепер"),
            keywords: &["возило", "камион", "приколка", "шлепер"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ആർട\u{d4d}ടിക\u{d4d}ക\u{d41}ലേറ\u{d4d}റഡ\u{d4d} ലോറി"),
            keywords: &[
                "ആർട\u{d4d}ടിക\u{d4d}ക\u{d41}ലേറ\u{d4d}റഡ\u{d4d} ലോറി",
                "ട\u{d4d}രക\u{d4d}ക\u{d4d}",
                "ട\u{d4d}രെയിലർ",
                "ലോറി",
                "വ\u{d3e}ഹനം",
                "സെമി",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("бүхээгтэй ачааны тэрэг"),
            keywords: &["ачаа", "бүхээг", "бүхээгтэй ачааны тэрэг", "тэрэг"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("दोन भाग जोडल\u{947}ली लॉरी"),
            keywords: &[
                "आर\u{94d}टिक\u{94d}य\u{942}ल\u{947}ट\u{947}ड लॉरी",
                "ट\u{94d}रक",
                "दोन भाग जोडल\u{947}ली लॉरी",
                "लॉरी",
                "स\u{947}मी",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("lori bersendi"),
            keywords: &["kenderaan", "lori", "lori bersendi", "semi", "trak"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("trakk artikolat"),
            keywords: &["semi", "trakk", "trakk artikolat"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "ချ\u{102d}တ\u{103a}တ\u{103d}\u{1032}ထားသည\u{1037}\u{103a} လော\u{103a}ရ\u{102e}ကား",
            ),
            keywords: &[
                "ချ\u{102d}တ\u{103a}တ\u{103d}\u{1032}ထားသည\u{1037}\u{103a} လော\u{103a}ရ\u{102e}ကား",
                "ထရပ\u{103a}ကား",
                "လော\u{103a}ရ\u{102e}ကား",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("lastebil"),
            keywords: &["bil", "kjøretøy", "lastebil", "trailer", "trekkvogn"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("लरी"),
            keywords: &["अर\u{94d}ध", "गाडी", "ट\u{94d}रक", "लरी"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("vrachtwagen"),
            keywords: &[
                "truck",
                "vrachtauto",
                "vrachtwagen",
                "vrachtwagen met oplegger",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("lastebil"),
            keywords: &["bil", "køyretøy", "lastebil", "trailer", "trekkvogn"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଆର\u{b4d}ଟ\u{b3f}କ\u{b4d}ୟ\u{b41}ଲେଟେଡ\u{b4d}\u{200c} ଲର\u{b3f}"),
            keywords: &[
                "ଆର\u{b4d}ଟ\u{b3f}କ\u{b4d}ୟ\u{b41}ଲେଟେଡ\u{b4d}\u{200c} ଲର\u{b3f}",
                "ଟ\u{b4d}ରକ\u{b4d}",
                "ଟ\u{b4d}ରଲର\u{b4d}",
                "ବ\u{b3e}ହନ",
                "ଯୋଡ\u{b3c}\u{b3f} ହୋଇଥ\u{b3f}ବ\u{b3e} ଲର\u{b3f}",
                "ଲର\u{b3f}",
                "ସେମ\u{b3f}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਲਾਰੀ"),
            keywords: &[
                "ਅ\u{a71}ਧ",
                "ਟਰ\u{a71}ਕ",
                "ਟ\u{a4d}ਰ\u{a47}ਲਰ",
                "ਲਾਰੀ",
                "ਵਾਹਨ",
                "ਵਿਅਕਤ ਲਾਰੀ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("جوڑ دار لاری"),
            keywords: &["آدھا", "جوڑ دار لاری", "ٹرک", "چار پہیے آلا ٹھیلا"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Tréla"),
            keywords: &["Lọ\u{301}ri", "Tréla"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("samochód ciężarowy"),
            keywords: &["ciężarówka", "dostawczy", "samochód ciężarowy"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("دوه سرويسه"),
            keywords: &["دوه سرويسه", "لارۍ", "نيمکړې", "ټرک"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("caminhão"),
            keywords: &[
                "caminhão",
                "caminhão articulado",
                "semi",
                "trailer",
                "veículo",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("camião articulado"),
            keywords: &["camião", "camião articulado", "semirreboque", "veículo"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("articulado caminón"),
            keywords: &["articulado caminón"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("camion articulat"),
            keywords: &["articulat", "camion"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-943"),
            keywords: &["E10-943"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("фура"),
            keywords: &["перевозка", "транспорт", "фура"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("makuzungu"),
            keywords: &["gitoya", "ikamyo", "makuzungu"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ٽرالر"),
            keywords: &["لاري", "نيم", "ٽرالر", "ٽرڪ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some(
                "ට\u{dca}\u{200d}රැක\u{dca}ටර\u{dca} ට\u{dca}\u{200d}රේලර\u{dca} ලොර\u{dd2}ය",
            ),
            keywords: &[
                "ක\u{dd4}ඩ\u{dcf}",
                "ට\u{dca}\u{200d}රක\u{dca} රථය",
                "ට\u{dca}\u{200d}රැක\u{dca}ටර\u{dca} ට\u{dca}\u{200d}රේලර\u{dca} ලොර\u{dd2}ය",
                "ලොර\u{dd2}ය",
                "ව\u{dcf}හනය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("ťahač s návesom"),
            keywords: &[
                "dopravný prostriedok",
                "kamión",
                "nákladné auto",
                "náves",
                "ťahač s návesom",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("tovornjak s prikolico"),
            keywords: &[
                "kamion",
                "polpriklopnik",
                "tovornjak",
                "tovornjak s prikolico",
                "vozilo",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("looriga xammuulka"),
            keywords: &["bar", "gaari xammuul", "loori", "looriga xammuulka"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("kamion me rimorkio"),
            keywords: &[
                "gjysmë",
                "kamion",
                "kamion me rimorkio",
                "mjet udhëtimi",
                "rimorkio",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("камион са приколицом"),
            keywords: &["вoзилo", "кaмиoн", "камион са приколицом", "прикoлицa"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["камион са приколицом"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("kamion sa prikolicom"),
            keywords: &["kamion", "kamion sa prikolicom", "prikolica", "vozilo"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["kamion sa prikolicom"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("lastbil"),
            keywords: &["fordon", "lastbil"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("lori linalobeba mizigo"),
            keywords: &["gari", "lori", "lori dogo", "lori linalobeba mizigo"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("கனரக ல\u{bbe}ரி"),
            keywords: &["கனரக ல\u{bbe}ரி", "கனரக வ\u{bbe}கனம\u{bcd}", "ல\u{bbe}ரி"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some(
                "ట\u{c4d}ర\u{c48}లర\u{c4d}\u{200c}త\u{c4b} ప\u{c3e}టుగ\u{c3e} ఉన\u{c4d}న ల\u{c3e}ర\u{c40}",
            ),
            keywords: &[
                "ట\u{c4d}ర\u{c48}లర\u{c4d}",
                "ట\u{c4d}ర\u{c48}లర\u{c4d}\u{200c}త\u{c4b} ప\u{c3e}టుగ\u{c3e} ఉన\u{c4d}న ల\u{c3e}ర\u{c40}",
                "ల\u{c3e}ర\u{c40}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("нақлиёти боркаш"),
            keywords: &["боркаш", "мошини боркаш", "нақлиёти боркаш", "ним"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("รถบรรท\u{e38}ก"),
            keywords: &["ขนส\u{e48}ง", "ยานพาหนะ", "รถบรรท\u{e38}ก"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ýük awtoulagy"),
            keywords: &["ýarym", "ýük", "ýük awtoulagy", "ýük ulagy"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("loli uta lalahi"),
            keywords: &["loli uta lalahi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("tır"),
            keywords: &["taşıt", "treyler", "tır", "çekici", "çekici kamyon"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("چاتما مال ماشىنىسى"),
            keywords: &["يۈك ماشىنىسى", "يېرىم", "چاتما", "چاتما مال ماشىنىسى"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("вантажівка з причепом"),
            keywords: &["вантажівка", "вантажівка з причепом", "транспорт", "фургон"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("جوڑ والی گاڑی"),
            keywords: &["جوڑ والی گاڑی", "سواری", "لاری", "ٹرک"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("tirkamali yuk mashinasi"),
            keywords: &["tirkamali yuk mashinasi", "transport", "yuk mashinasi"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("đầu kéo rơ-moóc"),
            keywords: &["bán", "xe tải", "đầu kéo rơ-moóc"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("kamiyoŋu bu gudd lool"),
            keywords: &["kamiyoŋ", "kamiyoŋu bu gudd lool", "semi"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("itraka edityanisiweyo"),
            keywords: &["isiqingatha", "itraka", "itraka edityanisiweyo"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ọkọ Nla Akẹru"),
            keywords: &[
                "díẹ\u{300}",
                "Ọkọ Nla Akẹru",
                "ọkọ\u{300} akérò ńlá",
                "ọkọ\u{300} akẹ\u{301}rù",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("拖頭車"),
            keywords: &["半", "卡車", "拖頭車"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("拖头车"),
            keywords: &["半", "卡车", "拖头车"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("铰接式货车"),
            keywords: &["卡车", "拖车", "铰接式货车"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("卡車"),
            keywords: &["卡車", "貨車"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("貨櫃車"),
            keywords: &["貨櫃車", "貨車"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("iloli elihlangene nogandaganda"),
            keywords: &["iloli", "iloli elihlangene nogandaganda", "isithuthi"],
        },
    ],
};
#[doc = "🚜"]
pub const TRACTOR: crate::Emoji = crate::Emoji {
    glyph: "🚜",
    codepoint: "1F69C",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "tractor",
    group: "Travel & Places",
    subgroup: "transport-ground",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("trekker"),
            keywords: &["plaas", "trekker", "voertuig"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ትራክተር"),
            keywords: &["ተሽከርካሪ", "ትራክተር"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("جرار"),
            keywords: &["جرار", "مركبة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ট\u{9cd}ৰেক\u{9cd}টৰ"),
            keywords: &["ট\u{9cd}ৰেক\u{9cd}টৰ", "ব\u{9be}হন"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("traktor"),
            keywords: &["nəqliyyat", "traktor"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("трактар"),
            keywords: &["беларус", "ммвз", "мтз", "трактар", "транспарт"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("трактор"),
            keywords: &["превозно средство", "трактор"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ট\u{9cd}র\u{9cd}য\u{9be}ক\u{9cd}টর"),
            keywords: &["ট\u{9cd}র\u{9cd}য\u{9be}ক\u{9cd}টর", "য\u{9be}নব\u{9be}হন"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("traktor"),
            keywords: &["karbed", "traktor"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("traktor"),
            keywords: &["traktor", "vozilo"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("tractor"),
            keywords: &["agricultura", "tractor", "vehicle"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏗᎦᏓᎷᎩᏍᎩ ᏙᏆᎴᎳ"),
            keywords: &["ᏗᎦᏓᎷᎩᏍᎩ ᏙᏆᎴᎳ", "ᏙᏆᎴᎵ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("traktor"),
            keywords: &["traktor", "vozidlo"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("tractor"),
            keywords: &["cerbyd", "tractor"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("traktor"),
            keywords: &["køretøj", "traktor"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Traktor"),
            keywords: &["Landwirtschaft", "Traktor", "Trecker"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("τρακτέρ"),
            keywords: &["τρακτέρ", "όχημα"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("tractor"),
            keywords: &["tractor", "vehicle"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("tractor"),
            keywords: &["agricultura", "tractor", "vehículo"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["campo", "tractor", "vehículo", "vehículo de trabajo"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("traktor"),
            keywords: &["sõiduk", "traktor"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("traktorea"),
            keywords: &["ibilgailu", "traktorea"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("تراکتور"),
            keywords: &["تراکتور", "وسیله\u{654} نقلیه", "یدک\u{200c}کش"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("traktori"),
            keywords: &["ajoneuvo", "auto", "traktori"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("traktora"),
            keywords: &["sasakyan", "tractor", "traktora"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("traktorur"),
            keywords: &["traktorur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("tracteur"),
            keywords: &["tracteur", "véhicule"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("tarracóir"),
            keywords: &["feithicil", "tarracóir"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("tractar"),
            keywords: &["carbad", "tractar"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("tractor"),
            keywords: &["agricultura", "tractor"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ટ\u{acd}ર\u{ac7}ક\u{acd}ટર"),
            keywords: &["ટ\u{acd}ર\u{ac7}ક\u{acd}ટર", "વાહન"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("tarakta"),
            keywords: &["mota", "tarakta"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("טרקטור"),
            keywords: &["טרקטור", "כלי רכב"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ट\u{94d}र\u{948}क\u{94d}टर"),
            keywords: &["ट\u{94d}र\u{948}क\u{94d}टर", "वाहन"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("traktor"),
            keywords: &["traktor", "vozilo"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("traktor"),
            keywords: &["jármű", "traktor"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("տրակտոր"),
            keywords: &["տրակտոր", "փոխադրամիջոց"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("traktor"),
            keywords: &["kendaraan", "traktor"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ụgbọalaugbo"),
            keywords: &["ụgbọala", "ụgbọalaugbo"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("dráttarvél"),
            keywords: &["dráttarvél", "traktor"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("trattore"),
            keywords: &["trattore", "veicolo"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("トラクター"),
            keywords: &["トラクター", "乗り物", "車"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("traktor"),
            keywords: &["tetumpakan", "traktor"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ტრაქტორი"),
            keywords: &["ტრანსპორტი", "ტრაქტორი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("трактор"),
            keywords: &["көлік", "трактор"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("traktor"),
            keywords: &["køretøj", "traktor"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ត\u{17d2}រាក\u{17cb}ទ\u{17d0}រ"),
            keywords: &["ត\u{17d2}រាក\u{17cb}ទ\u{17d0}រ", "យានជ\u{17c6}ន\u{17b7}ះ"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಟ\u{ccd}ರ\u{ccd}ಯಾಕ\u{ccd}ಟರ\u{ccd}"),
            keywords: &[
                "ಟ\u{ccd}ರಾಕ\u{ccd}ಟರ\u{ccd}",
                "ಟ\u{ccd}ರ\u{ccd}ಯಾಕ\u{ccd}ಟರ\u{ccd}",
                "ವಾಹನ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("트랙터"),
            keywords: &["교통수단", "차량", "트랙터"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("ट\u{94d}र\u{945}क\u{94d}टर"),
            keywords: &["ट\u{94d}र\u{945}क\u{94d}टर", "वाहन"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("трактор"),
            keywords: &["трактор", "унаа"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Trakter"),
            keywords: &["Gefier", "Trakter"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ລ\u{ebb}ດແທ\u{eb1}ກເຕ\u{eb5}"),
            keywords: &["ພາຫະນະ", "ລ\u{ebb}ດແທ\u{eb1}ກເຕ\u{eb5}"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("traktorius"),
            keywords: &["traktorius", "transporto priemonė"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("traktors"),
            keywords: &["traktors", "transports"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tarakita"),
            keywords: &["tarakita", "waka"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("трактор"),
            keywords: &["возило", "трактор"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ട\u{d4d}ര\u{d3e}ക\u{d4d}\u{200c}റ\u{d4d}റർ"),
            keywords: &["ട\u{d4d}ര\u{d3e}ക\u{d4d}\u{200c}റ\u{d4d}റർ", "വ\u{d3e}ഹനം"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("трактор"),
            keywords: &["трактор", "тээврийн хэрэгсэл"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("ट\u{94d}र\u{945}क\u{94d}टर"),
            keywords: &["ट\u{94d}र\u{945}क\u{94d}टर", "वाहन"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("traktor"),
            keywords: &["kenderaan", "traktor"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("trattur"),
            keywords: &["trattur", "vettura"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("လယ\u{103a}ထ\u{103d}န\u{103a}စက\u{103a}"),
            keywords: &["ယာဥ\u{103a}", "လယ\u{103a}ထ\u{103d}န\u{103a}စက\u{103a}"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("traktor"),
            keywords: &["kjøretøy", "traktor"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("ट\u{94d}रयाक\u{94d}टर"),
            keywords: &["गाडी", "ट\u{94d}रयाक\u{94d}टर"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("tractor"),
            keywords: &["tractor", "voertuig"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("traktor"),
            keywords: &["køyretøy", "traktor"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଟ\u{b4d}ର\u{b3e}କ\u{b4d}ଟର\u{b4d}"),
            keywords: &["ଟ\u{b4d}ର\u{b3e}କ\u{b4d}ଟର\u{b4d}", "ବ\u{b3e}ହନ"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਟਰ\u{a48}ਕਟਰ"),
            keywords: &["ਟਰ\u{a48}ਕਟਰ", "ਵਾਹਨ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ٹریکٹر"),
            keywords: &["ٹریکٹر", "گڈی"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Tráktọ"),
            keywords: &["Móto", "Tráktọ"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("ciągnik"),
            keywords: &["ciągnik", "rolniczy"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ټراکټور"),
            keywords: &["ټراکټور", "ګاړی"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("trator"),
            keywords: &["trator", "veículo"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["trator"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("tractor"),
            keywords: &["carru", "tractor"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("tractor"),
            keywords: &["tractor", "vehicul"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-944"),
            keywords: &["E10-944"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("трактор"),
            keywords: &["сельское хозяйство", "трактор", "транспорт"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("imashiniihinga"),
            keywords: &["imashiniihinga", "imodoka"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ٽريڪٽر"),
            keywords: &["ٽريڪٽر", "گاڏي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ට\u{dca}\u{200d}රැක\u{dca}ටරය"),
            keywords: &["ට\u{dca}\u{200d}රැක\u{dca}ටරය", "ව\u{dcf}හනය"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("traktor"),
            keywords: &["dopravný prostriedok", "traktor"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("traktor"),
            keywords: &["traktor", "vozilo"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("cagaf-cagaf"),
            keywords: &["cagaf-cagaf", "gaari"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("traktor"),
            keywords: &["mjet udhëtimi", "traktor"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("трактор"),
            keywords: &["вoзилo", "трактор"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("traktor"),
            keywords: &["traktor", "vozilo"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("traktor"),
            keywords: &["fordon", "traktor"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("trekta"),
            keywords: &["gari", "trekta"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("டிர\u{bbe}க\u{bcd}டர\u{bcd}"),
            keywords: &[
                "டிர\u{bbe}க\u{bcd}டர\u{bcd}",
                "டிர\u{bbe}க\u{bcd}டர\u{bcd} வண\u{bcd}டி",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ట\u{c4d}ర\u{c3e}క\u{c4d}టర\u{c4d}"),
            keywords: &["ట\u{c4d}ర\u{c3e}క\u{c4d}టర\u{c4d}", "వ\u{c3e}హనం"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("трактор"),
            keywords: &["нақлиёт", "трактор"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("แทร\u{e47}กเตอร\u{e4c}"),
            keywords: &["ยานพาหนะ", "แทร\u{e47}กเตอร\u{e4c}"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("traktor"),
            keywords: &["traktor", "ulag"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("mīsini taulani"),
            keywords: &["mīsini taulani"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("traktör"),
            keywords: &["taşıt", "traktör"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("تىراكتور"),
            keywords: &["ئاپتوموبىل", "تىراكتور"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("трактор"),
            keywords: &["трактор", "транспорт"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ٹریکٹر"),
            keywords: &["سواری", "ٹریکٹر"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("traktor"),
            keywords: &["traktor", "transport"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("máy kéo"),
            keywords: &["máy kéo", "xe cộ"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("traktër"),
            keywords: &["traktër", "waruwaay"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("itrekta"),
            keywords: &["inqwelo-mafutha", "itrekta"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Katakata"),
            keywords: &["Katakata", "nṣe ọkọ\u{301}"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("拖拉機"),
            keywords: &["拖拉機", "車輛"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("拖拉机"),
            keywords: &["拖拉机", "车辆"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("拖拉机"),
            keywords: &["拖拉机"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("拖弋機"),
            keywords: &["拖弋機"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("拖拉機"),
            keywords: &["拖拉機"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ugandaganda"),
            keywords: &["isithuthi", "ugandaganda"],
        },
    ],
};
#[doc = "🏎\u{fe0f}"]
pub const RACING_CAR: crate::Emoji = crate::Emoji {
    glyph: "🏎\u{fe0f}",
    codepoint: "1F3CE FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.7f32,
    name: "racing car",
    group: "Travel & Places",
    subgroup: "transport-ground",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🏎",
        codepoint: "1F3CE",
        status: crate::Status::Unqualified,
        introduction_version: 0.7f32,
        name: "racing car",
        group: "Travel & Places",
        subgroup: "transport-ground",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("resiesmotor"),
            keywords: &["kar", "motor", "resies", "resiesmotor", "wedren"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የውድድር መኪና"),
            keywords: &["መኪና", "እሽቅድምድም", "የውድድር መኪና"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("سيارة سباق"),
            keywords: &["سباق", "سيارة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ৰেচিং গ\u{9be}ড\u{9bc}ী"),
            keywords: &["গ\u{9be}ড\u{9bc}ী", "ৰেচিং"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("yarış maşını"),
            keywords: &["maşın", "yarış", "yarış maşını"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("гоначны аўтамабіль"),
            keywords: &[
                "аўтамабіль",
                "балід",
                "гоначны аўтамабіль",
                "гонкі",
                "формула",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("състезателен автомобил"),
            keywords: &["автомобил", "състезание", "състезателен автомобил"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("রেসিং ক\u{9be}র"),
            keywords: &["গ\u{9be}ড\u{9bc}ি", "রেসিং", "রেসিং ক\u{9be}র"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("trkaći automobil"),
            keywords: &["auto", "trkaći automobil", "utrka"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cotxe de curses"),
            keywords: &[
                "carreres",
                "cotxe",
                "cotxe de curses",
                "curses",
                "fórmula 1",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏙᎩᏯᏍᏗ ᏙᏆᎴᎷ"),
            keywords: &["ᎠᏙᎩᏯᏍᏗ", "ᏙᏆᎴᎷ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("formule"),
            keywords: &["auto", "formule", "závod"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("car rasio"),
            keywords: &["car", "rasio"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("racerbil"),
            keywords: &["bil", "racerbil", "racerløb"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Rennauto"),
            keywords: &["Autorennen", "Rennauto"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("αγωνιστικό όχημα"),
            keywords: &["αγωνιστικό", "αγωνιστικό όχημα", "αυτοκίνητο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("racing car"),
            keywords: &["car", "racing"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: None,
            keywords: &["car", "motor racing", "racing"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("coche de carreras"),
            keywords: &["carreras", "coche", "coche de carreras"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("auto de carrera"),
            keywords: &["auto", "auto de carrera", "carrera"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("auto de carreras"),
            keywords: &["auto de carreras"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("võidusõiduauto"),
            keywords: &["auto", "võidusõiduauto", "võidusõit"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("lasterketa-autoa"),
            keywords: &["autoa", "lasterketa", "lasterketa-autoa"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("ماشین مسابقه"),
            keywords: &["خودرو", "ماشین مسابقه", "مسابقه"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kilpa-auto"),
            keywords: &["auto", "kilpa-ajot", "kilpa-auto"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("racing car"),
            keywords: &["karera", "kotse", "racing car"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("rasarabilur"),
            keywords: &[
                "bilur",
                "kappkoyring",
                "kappkoyringarbilur",
                "koyra kapp",
                "rasarabilur",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("voiture de course"),
            keywords: &["course", "voiture", "voiture de course"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["course", "voiture", "voiture de course"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("carr rása"),
            keywords: &["ag rásáil", "carr", "carr rása"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("càr rèisidh"),
            keywords: &["càr", "càr rèisidh", "rèis", "rèiseadh"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("coche de carreiras"),
            keywords: &["carreiras", "coche", "coche de carreiras"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ર\u{ac7}સિ\u{a82}ગ કાર"),
            keywords: &["કાર", "ર\u{ac7}સિ\u{a82}ગ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("motar tsere"),
            keywords: &["motar tsere", "tsere", "ƙaramar mota"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("מכונית מירוץ"),
            keywords: &["מירוץ", "מכונית"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("र\u{947}सि\u{902}ग कार"),
            keywords: &["कार", "र\u{947}सि\u{902}ग कार"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("trkaći automobil"),
            keywords: &["automobil", "trkaći automobil", "utrka"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("versenyautó"),
            keywords: &["autó", "verseny", "versenyautó", "versenyzés"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("մրցարշավային մեքենա"),
            keywords: &["մեքենա", "մրցարշավ", "մրցարշավային մեքենա"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("mobil balap"),
            keywords: &["balapan", "mobil", "mobil balap"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ụgbọala na-agba osọ egwuregwu"),
            keywords: &[
                "egwuregwu ịgba ọsọ",
                "ụgbọala",
                "ụgbọala na-agba osọ egwuregwu",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("kappakstursbíll"),
            keywords: &["bíll", "kappakstur", "kappakstursbíll"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("auto da corsa"),
            keywords: &["F1", "auto da corsa", "gran premio"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("レーシングカー"),
            keywords: &[
                "F1",
                "スポーツ",
                "モータースポーツ",
                "レーシングカー",
                "乗り物",
                "車",
            ],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("montor balap"),
            keywords: &["balapan", "montor", "montor balap"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("სარბოლო მანქანა"),
            keywords: &["მანქანა", "რბოლა", "სარბოლო მანქანა"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("жарыс автомобилі"),
            keywords: &["автокөлік", "жарыс автомобилі", "жарысу"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("racerbil"),
            keywords: &["bil", "racerbil", "racerløb"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ឡានប\u{17d2}រណា\u{17c6}ង"),
            keywords: &[
                "ប\u{17d2}រណា\u{17c6}ង",
                "រថយន\u{17d2}ត",
                "ឡាន",
                "ឡានប\u{17d2}រណា\u{17c6}ង",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ರೇಸ\u{cbf}ಂಗ\u{ccd} ಕಾರು"),
            keywords: &["ಕಾರು", "ರೇಸ\u{cbf}ಂಗ\u{ccd}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("경주용 자동차"),
            keywords: &["경주용 자동차", "레이싱카"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("शर\u{94d}यतीची कार"),
            keywords: &["कार", "शर\u{94d}यत", "शर\u{94d}यतीची कार"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("жарыш машинасы"),
            keywords: &["жарыш", "жарыш машинасы", "машина"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Courseauto"),
            keywords: &["Auto", "Course", "Courseauto"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ລ\u{ebb}ດແຂ\u{ec8}ງ"),
            keywords: &["ລ\u{ebb}ດ", "ລ\u{ebb}ດແຂ\u{ec8}ງ", "ແຂ\u{ec8}ງລ\u{ebb}ດ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("lenktyninis automobilis"),
            keywords: &["automobilis", "lenktyninis automobilis", "lenktynės"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("sacīkšu automašīna"),
            keywords: &["mašīna", "sacīkstes", "sacīkšu automašīna"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("motokā tauwhainga"),
            keywords: &["motokā", "tauwhainga"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("тркачки автомобил"),
            keywords: &["автомобил", "трка", "тркачки автомобил"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("റേസിംഗ\u{d4d} ക\u{d3e}ർ"),
            keywords: &["ക\u{d3e}ർ", "റേസിംഗ\u{d4d}"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("уралдааны машин"),
            keywords: &["машин", "машины уралдаан", "уралдааны машин"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("शर\u{94d}यतीची कार"),
            keywords: &["कार", "शर\u{94d}यत", "शर\u{94d}यतीची कार"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("kereta lumba"),
            keywords: &["kereta", "lumba"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("tlielaq tal-karozzi"),
            keywords: &["karozza", "tlielaq", "tlielaq tal-karozzi"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ပြ\u{102d}\u{102f}င\u{103a}ကား"),
            keywords: &[
                "ပြ\u{102d}\u{102f}င\u{103a}ကား",
                "ပြ\u{102d}\u{102f}င\u{103a}ပ\u{103d}\u{1032}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("racerbil"),
            keywords: &["bil", "billøp", "motorsport", "racerbil"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("दौ\u{902}डवाला कार"),
            keywords: &["कार", "दौ\u{902}ड", "दौ\u{902}डवाला कार"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("raceauto"),
            keywords: &["auto", "raceauto", "racen"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("racerbil"),
            keywords: &["bil", "milløp", "motorsport", "racerbil"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ରେସ\u{b3f}ଂ କ\u{b3e}ର\u{b4d}\u{200c}"),
            keywords: &["କ\u{b3e}ର\u{b4d}\u{200c}", "ରେସ\u{b3f}ଂ"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਰ\u{a47}ਸਿ\u{a70}ਗ ਕਾਰ"),
            keywords: &["ਕਾਰ", "ਕਾਰ ਰ\u{a47}ਸਿ\u{a70}ਗ", "ਰ\u{a47}ਸਿ\u{a70}ਗ ਕਾਰ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("دوڑ وچ حص\u{651}ہ لین آلی کار"),
            keywords: &["دوڑ", "دوڑ وچ حص\u{651}ہ لین آلی کار", "کار"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Móto Wé Bi Fọ Résín Kọmpitíshọn"),
            keywords: &[
                "Kaa",
                "Móto",
                "Móto Wé Bi Fọ Résín Kọmpitíshọn",
                "Résín Kọmpitíshọn",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("samochód wyścigowy"),
            keywords: &["samochód", "samochód wyścigowy", "wyścigi"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ریسنگ موټر"),
            keywords: &["ریسنگ", "موټر"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("carro de corrida"),
            keywords: &["automobilismo", "carro", "carro de corrida", "corrida"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("carrera carrupi"),
            keywords: &["carrera", "carrera carrupi", "carru"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("mașină de curse"),
            keywords: &["curse", "mașină", "mașină de curse"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-398"),
            keywords: &["E10-398"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("гоночный автомобиль"),
            keywords: &["автомобиль", "гонки", "гоночный автомобиль", "скорость"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("imodoka y’isiganwa"),
            keywords: &["imodoka", "imodoka y’isiganwa", "isiganwa"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ريسنگ جي ڪار"),
            keywords: &["ريسنگ جي ڪار", "ريسنگ، ڪار"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("රේස\u{dd2}ං මෝටර\u{dca} රථය"),
            keywords: &[
                "මෝටර\u{dca} රථය",
                "රේස\u{dd2}ං",
                "රේස\u{dd2}ං මෝටර\u{dca} රථය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("pretekárske auto"),
            keywords: &["auto", "preteky", "pretekárske auto"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("dirkalnik"),
            keywords: &["avto", "dirkalnik", "dirkanje"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("tartan gaari"),
            keywords: &["gaari", "tartan gaari", "tartanka"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("makinë garash"),
            keywords: &["garim", "garë", "makinë", "makinë garash"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("тркачки аутомобил"),
            keywords: &["aутoмoбил", "тркачки аутомобил"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["тркачки аутомобил"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("trkački automobil"),
            keywords: &["automobil", "trkački automobil"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["trkački automobil"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("racerbil"),
            keywords: &["bil", "racerbil", "sport"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("gari la mashindano"),
            keywords: &["gari", "gari la mashindano", "mashindano"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("க\u{bbe}ர\u{bcd} பந\u{bcd}தயம\u{bcd}"),
            keywords: &["க\u{bbe}ர\u{bcd}", "பந\u{bcd}தயம\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ర\u{c47}స\u{c3f}ంగ\u{c4d} క\u{c3e}ర\u{c4d}"),
            keywords: &[
                "క\u{c3e}ర\u{c4d}",
                "పంద\u{c47}లు",
                "ర\u{c47}స\u{c3f}ంగ\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("автомобили пойга"),
            keywords: &["автомобили пойга", "мошин", "пойга"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("รถแข\u{e48}ง"),
            keywords: &["รถ", "รถแข\u{e48}ง", "แข\u{e48}ง"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ýaryş awtoulagy"),
            keywords: &["awtoulag", "ýaryş", "ýaryş awtoulagy"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("meʻalele lova"),
            keywords: &["meʻalele lova"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("yarış arabası"),
            keywords: &["araba", "yarış", "yarış arabası"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("مۇسابىقە ماشىنىسى"),
            keywords: &["ماشىنا", "مۇسابىقە", "مۇسابىقە ماشىنىسى"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("cпортивний автомобіль"),
            keywords: &["cпортивний автомобіль", "автомобіль", "перегони"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ریس کی کار"),
            keywords: &["ریس", "ریس کی کار", "کار", "کھیل"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("poyga mashinasi"),
            keywords: &["mashina", "poyga", "poyga mashinasi"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("xe đua"),
            keywords: &["xe", "xe đua", "đua xe"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("kursu oto"),
            keywords: &["kursu", "oto"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("imoto yomdyarho"),
            keywords: &["imoto", "imoto yomdyarho", "umdyarho"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("ọkọ\u{300} ìdíje eré"),
            keywords: &["ìdíje eré", "ọkọ\u{300}", "ọkọ\u{300} ìdíje eré"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("賽車"),
            keywords: &["賽車", "車"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("赛车"),
            keywords: &["赛车", "车"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("赛车"),
            keywords: &["赛车", "跑车"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("賽車"),
            keywords: &["賽車"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["賽車", "車"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("imoto yomjaho"),
            keywords: &["imoto", "imoto yomjaho", "umjaho"],
        },
    ],
};
#[doc = "🏍\u{fe0f}"]
pub const MOTORCYCLE: crate::Emoji = crate::Emoji {
    glyph: "🏍\u{fe0f}",
    codepoint: "1F3CD FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.7f32,
    name: "motorcycle",
    group: "Travel & Places",
    subgroup: "transport-ground",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🏍",
        codepoint: "1F3CD",
        status: crate::Status::Unqualified,
        introduction_version: 0.7f32,
        name: "motorcycle",
        group: "Travel & Places",
        subgroup: "transport-ground",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("motorfiets"),
            keywords: &["motorfiets", "wedren"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ሞተርሳይክል"),
            keywords: &["ሞተርሳይክል", "እሽቅድምድም"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("دراجة بخارية"),
            keywords: &["دراجة بخارية", "سباق"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("মটৰ চ\u{9be}ইকেল"),
            keywords: &["মটৰ চ\u{9be}ইকেল", "ৰেচিং"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("motosiklet"),
            keywords: &["motosiklet", "yarış"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("матацыкл"),
            keywords: &["байк", "гонкі", "матацыкл", "хуткасць"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("мотоциклет"),
            keywords: &["мотоциклет", "състезание"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("মটরস\u{9be}ইকেল"),
            keywords: &["মটরস\u{9be}ইকেল", "রেসিং"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("marcʼh-tan"),
            keywords: &["karbed", "marcʼh-tan"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("motor"),
            keywords: &["motor", "utrka"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("motocicleta"),
            keywords: &["curses", "moto", "motocicleta"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏔᎵ ᏗᎦᏩᏘ ᎠᎩᎸᏙᏗ"),
            keywords: &["ᎠᏙᎩᏯᏍᏗ", "ᏔᎵ ᏗᎦᏩᏘ ᎠᎩᎸᏙᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("motorka"),
            keywords: &["motocykl", "motorka", "závod"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("beic modur"),
            keywords: &["beic modur", "rasio"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("motorcykel"),
            keywords: &["motorcykel", "racerløb"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Motorrad"),
            keywords: &["Motorrad", "Motorrennen"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("μοτοσικλέτα"),
            keywords: &["αγωνιστικό", "μοτοσικλέτα"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("motorcycle"),
            keywords: &["motorcycle", "racing"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: None,
            keywords: &["motorbike", "racing"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("moto"),
            keywords: &["carreras", "moto", "motocicleta", "vehículo"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("motocicleta"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("mootorratas"),
            keywords: &["mootorratas", "võidusõit"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("motozikleta"),
            keywords: &["lasterketa", "motozikleta"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("موتورسیکلت"),
            keywords: &["مسابقه", "موتورسیکلت"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("moottoripyörä"),
            keywords: &["kilpa-ajot", "moottoripyörä"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("motorsiklo"),
            keywords: &["karera", "motor", "motorcycle", "motorsiklo"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("motorsúkkla"),
            keywords: &["kappkoyring", "koyra kapp", "motorsúkkla"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("moto"),
            keywords: &["course", "moto"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("gluaisrothar"),
            keywords: &["ag rásáil", "gluaisrothar"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("motar-baidhg"),
            keywords: &["motar-baidhg", "rèis", "rèiseadh"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("moto"),
            keywords: &["carreiras", "moto", "motocicleta"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("મોટરસાયકલ"),
            keywords: &["મોટરસાયકલ", "ર\u{ac7}સિ\u{a82}ગ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("babur"),
            keywords: &["babur", "tsere"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("אופנוע"),
            keywords: &["אופנוע", "כלי רכב", "תחרות"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("मोटर साइकिल"),
            keywords: &["बाइक", "मोटर साइकिल"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("motocikl"),
            keywords: &["motocikl", "utrka"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("motorkerékpár"),
            keywords: &["motorkerékpár", "verseny", "versenyzés"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("մոտոցիկլետ"),
            keywords: &["մոտոցիկլետ", "մրցարշավ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("sepeda motor"),
            keywords: &["balapan", "sepeda motor"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ọgbaatumtum"),
            keywords: &["na-agba osọ egwuregwu", "ọgbaatumtum"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("mótorhjól"),
            keywords: &["kappakstur", "mótorhjól"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("motocicletta"),
            keywords: &["moto", "motocicletta"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("オートバイ"),
            keywords: &[
                "オートバイ",
                "オートレース",
                "スポーツ",
                "バイク",
                "モータースポーツ",
                "乗り物",
            ],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("pit montor"),
            keywords: &["balapan", "pit montor"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მოტოციკლეტი"),
            keywords: &["მოტოციკლეტი", "რბოლა"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("мотоцикл"),
            keywords: &["жарысу", "мотоцикл"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("motorcykel"),
            keywords: &["motorcykel", "racerløb"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ម\u{17c9}\u{17bc}ត\u{17bc}ប\u{17d2}រណា\u{17c6}ង"),
            keywords: &[
                "ប\u{17d2}រណា\u{17c6}ង",
                "ម\u{17c9}\u{17bc}ត\u{17bc}",
                "ម\u{17c9}\u{17bc}ត\u{17bc}ប\u{17d2}រណា\u{17c6}ង",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಮೋಟರ\u{ccd} ಸೈಕಲ\u{ccd}"),
            keywords: &[
                "ಮೋಟರ\u{ccd} ಸೈಕಲ\u{ccd}",
                "ಮೋಟಾರು",
                "ರೇಸ\u{cbf}ಂಗ\u{ccd}",
                "ಸೈಕಲ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("오토바이"),
            keywords: &["경주", "모터사이클", "오토바이"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("मोटरसायकल"),
            keywords: &["मोटरसायकल", "स\u{94d}पर\u{94d}धा"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("мотоцикл"),
            keywords: &["жарыш", "мотоцикл"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Motorrad"),
            keywords: &["Course", "Motorrad"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ລ\u{ebb}ດຈ\u{eb1}ກ"),
            keywords: &["ລ\u{ebb}ດຈ\u{eb1}ກ", "ແຂ\u{ec8}ງລ\u{ebb}ດ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("motociklas"),
            keywords: &["lenktynės", "motociklas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("motocikls"),
            keywords: &["motocikls", "sacīkstes"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("motopaika"),
            keywords: &["motopaika", "tauwhainga"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("мотор"),
            keywords: &["мотор", "трка"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("മോട\u{d4d}ടോർസൈക\u{d4d}കിൾ"),
            keywords: &[
                "ബൈക\u{d4d}ക\u{d4d}",
                "മോട\u{d4d}ടോർസൈക\u{d4d}കിൾ",
                "റേസിംഗ\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("мотоцикл"),
            keywords: &["мотоцикл", "мотоцикль", "уралдаан"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("मोटरसायकल"),
            keywords: &["मोटरसायकल", "शर\u{94d}यत लावण\u{947}"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("motosikal"),
            keywords: &["lumba", "motosikal"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("mutur"),
            keywords: &["mutur", "tlielaq"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("မော\u{103a}တော\u{103a}ဆ\u{102d}\u{102f}င\u{103a}ကယ\u{103a}"),
            keywords: &[
                "မော\u{103a}တော\u{103a}ဆ\u{102d}\u{102f}င\u{103a}ကယ\u{103a}",
                "အပြေးပြ\u{102d}\u{102f}င\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("motorsykkel"),
            keywords: &["motorsport", "motorsykkel", "motorsyklist"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("मोटरसाइकल"),
            keywords: &["दौ\u{902}ड", "मोटरसाइकल"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("motor"),
            keywords: &["motor", "racen"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("motorsykkel"),
            keywords: &["motorsport", "motorsykkel", "motorsyklist"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ମଟରଗ\u{b3e}ଡ\u{b3c}\u{b3f}"),
            keywords: &["ମଟରଗ\u{b3e}ଡ\u{b3c}\u{b3f}", "ରେସ\u{b3f}ଂ"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਮ\u{a4b}ਟਰਸਾਈਕਲ"),
            keywords: &[
                "ਬਾਈਕ ਰ\u{a47}ਸਿ\u{a70}ਗ",
                "ਮ\u{a4b}ਟਰਸਾਈਕਲ",
                "ਰ\u{a47}ਸਿ\u{a70}ਗ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("موٹر سائیکل"),
            keywords: &["دوڑ", "موٹر سائیکل"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Motosaíkul"),
            keywords: &["Motosaíkul", "Résín Kọmpitíshọn"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("motocykl"),
            keywords: &["motocykl", "wyścigi"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("موټرسیکل"),
            keywords: &["ريسنګ", "موټر سيکل", "موټرسیکل"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("motocicleta"),
            keywords: &["corrida", "motocicleta"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("mota"),
            keywords: &["corrida", "mota", "moto", "motociclismo", "motociclo"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("motocicleta"),
            keywords: &["carrera", "motocicleta"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("motocicletă"),
            keywords: &["curse", "motocicletă"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-397"),
            keywords: &["E10-397"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("мотоцикл"),
            keywords: &["гонки", "мотоцикл", "опасность", "скорость"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("Ipikipiki"),
            keywords: &["Ipikipiki", "isiganwa"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("موٽر سائيڪل"),
            keywords: &["ريسنگ", "موٽر سائيڪل"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("මෝටර\u{dca} බය\u{dd2}ස\u{dd2}කලය"),
            keywords: &["මෝටර\u{dca} බය\u{dd2}ස\u{dd2}කලය", "රේස\u{dd2}ං"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("motocykel"),
            keywords: &["motocykel", "motorka", "preteky"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("motor"),
            keywords: &["dirkanje", "motor"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("mooto"),
            keywords: &["mootada", "mooto", "tartanka"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("motoçikletë"),
            keywords: &["garim", "garë", "motoçikletë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("мотоцикл"),
            keywords: &["мотоцикл", "тркa"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("motocikl"),
            keywords: &["motocikl", "trka"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("motorcykel"),
            keywords: &["motorcykel", "racing"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("pikipiki"),
            keywords: &["mashindano", "pikipiki"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("மோட\u{bcd}ட\u{bbe}ர\u{bcd} சைக\u{bcd}கிள\u{bcd}"),
            keywords: &[
                "பந\u{bcd}தயம\u{bcd}",
                "மோட\u{bcd}ட\u{bbe}ர\u{bcd} சைக\u{bcd}கிள\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("మ\u{c4b}టర\u{c4d}\u{200c}స\u{c48}క\u{c3f}ల\u{c4d}"),
            keywords: &[
                "మ\u{c4b}టర\u{c4d}\u{200c}స\u{c48}క\u{c3f}ల\u{c4d}",
                "మ\u{c4b}ట\u{c3e}రు",
                "ర\u{c47}సులు",
                "వ\u{c3e}హనం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("мотосикл"),
            keywords: &["мотосикл", "пойга"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("มอเตอร\u{e4c}ไซค\u{e4c}"),
            keywords: &["มอเตอร\u{e4c}ไซค\u{e4c}", "แข\u{e48}ง"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("motosikl"),
            keywords: &["motosikl", "ýaryş"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("motopaiki"),
            keywords: &["motopaiki"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("motosiklet"),
            keywords: &["motosiklet", "yarış"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("موتوسىكلىت"),
            keywords: &["موتوسىكلىت", "مۇسابىقە"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("мотоцикл"),
            keywords: &["мотоцикл", "перегони"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("موٹر سائیکل"),
            keywords: &["ریس", "سائیکل", "موٹر"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("mototsikl"),
            keywords: &["mototsikl", "poyga"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("xe máy"),
            keywords: &["xe máy", "đua xe"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("moto"),
            keywords: &["kursu", "moto"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("i-motorcycle"),
            keywords: &["i-motorcycle", "umdyarho"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("alùpùpù"),
            keywords: &["alùpùpù", "ìdíje eré"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("電單車"),
            keywords: &["賽跑", "電單車"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("电单车"),
            keywords: &["电单车", "赛跑"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("摩托车"),
            keywords: &["摩托", "摩托车"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("機車"),
            keywords: &["摩托車", "機車"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("電單車"),
            keywords: &["賽車", "電單車"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("isithuthuthu esigijimayo"),
            keywords: &["isithuthuthu esigijimayo", "umjaho"],
        },
    ],
};
#[doc = "🛵"]
pub const MOTOR_SCOOTER: crate::Emoji = crate::Emoji {
    glyph: "🛵",
    codepoint: "1F6F5",
    status: crate::Status::FullyQualified,
    introduction_version: 3f32,
    name: "motor scooter",
    group: "Travel & Places",
    subgroup: "transport-ground",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("bromponie"),
            keywords: &["bromponie", "motorfiets", "skoeter"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ቀላል ሞተር ሳይክል"),
            keywords: &["ሞተር", "ሳይክል", "ቀላል ሞተር ሳይክል"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("سكوتر بمحرك"),
            keywords: &["سكوتر", "سكوتر بمحرك", "محرك"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("মটৰ স\u{9cd}ক\u{9c1}ট\u{9be}ৰ"),
            keywords: &["মটৰ", "স\u{9cd}ক\u{9c1}ট\u{9be}ৰ"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("motorlu skuter"),
            keywords: &["motorlu", "motosikl", "skuter"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("скутар"),
            keywords: &["скутар"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("моторен скутер"),
            keywords: &["мотор", "моторен скутер", "скутер"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("মোটর স\u{9cd}ক\u{9c1}ট\u{9be}র"),
            keywords: &[
                "মটর",
                "মোটর স\u{9cd}ক\u{9c1}ট\u{9be}র",
                "স\u{9cd}ক\u{9c1}ট\u{9be}র",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("skouter"),
            keywords: &["karbed", "skouter"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("skuter"),
            keywords: &["motor", "skuter"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("escúter"),
            keywords: &["escúter", "moto", "motocicleta", "transport"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏔᎵ ᏗᎦᏩᏘ"),
            keywords: &["ᏔᎵ", "ᏗᎦᏩᏘ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("skútr"),
            keywords: &["scooter", "skútr"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("sgwter modur"),
            keywords: &["modur", "sgwter"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("scooter"),
            keywords: &["scooter", "transportmiddel"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Motorroller"),
            keywords: &["Motorroller", "Roller", "Vespa"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("σκουτεράκι"),
            keywords: &["ηλεκτροκίνητος", "σκουτεράκι", "σκούτερ"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("motor scooter"),
            keywords: &["motor", "scooter"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("scooter"),
            keywords: &["escúter", "moto", "scooter"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("moto"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("motoneta"),
            keywords: &["motoneta"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("motoroller"),
            keywords: &["motoroller", "roller"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("motoa"),
            keywords: &["motoa", "scooter"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("اسکوتر"),
            keywords: &[
                "اسکوتر",
                "اسکوتر موتوری",
                "روروک",
                "روروک موتوری",
                "موتور",
                "چرخ پایی برقی",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("skootteri"),
            keywords: &["ajoneuvo", "skootteri"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("motor scooter"),
            keywords: &["motor", "scooter"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("skutari"),
            keywords: &["prutl", "skutari"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("scooter"),
            keywords: &["scooter"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["scooter", "scouteur"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("scútar"),
            keywords: &["inneall", "scútar"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("sgùtair-motair"),
            keywords: &["motair", "sgùtair", "sgùtair-motair"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("motocicleta"),
            keywords: &["moto", "motocicleta", "motociclismo"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("મોટર સ\u{acd}ક\u{ac2}ટર"),
            keywords: &["મોટર", "સ\u{acd}ક\u{ac2}ટર"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("sukuta na inji"),
            keywords: &["inji", "sukuta", "sukuta na inji"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("קטנוע"),
            keywords: &["וספה", "קטנוע"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("मोटर स\u{94d}क\u{942}टर"),
            keywords: &["मोटर", "स\u{94d}क\u{942}टर"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("skuter"),
            keywords: &["motor", "skuter"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("robogó"),
            keywords: &["motor", "robogó"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("սկուտեր"),
            keywords: &["մոպեդ", "սկուտեր"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("motor skuter"),
            keywords: &["motor", "skuter", "vespa"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("igwe ụgbọ egwuregwu"),
            keywords: &["egwuregwu igwe", "igwe ụgbọ egwuregwu", "ụgbọ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("vespa"),
            keywords: &["farartæki", "hjól", "mótorhjól", "skellinaðra", "vespa"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("scooter"),
            keywords: &["motorino", "scooter"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("スクーター"),
            keywords: &["スクーター", "原付"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("pespa"),
            keywords: &["pespa", "pit"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("სკუტერი ძრავით"),
            keywords: &["სკუტერი", "სკუტერი ძრავით", "ძრავა"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("скутер"),
            keywords: &["мопед", "скутер"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("scooter"),
            keywords: &["scooter", "transportmiddel"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("scooter មានម\u{17c9}ាស\u{17ca}\u{17b8}ន"),
            keywords: &[
                "scooter មានម\u{17c9}ាស\u{17ca}\u{17b8}ន",
                "ម\u{17c9}\u{17bc}ត\u{17bc}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಮೋಟಾರು ಸ\u{ccd}ಕ\u{cc2}ಟರ\u{ccd}"),
            keywords: &["ಮೋಟಾರು", "ಸ\u{ccd}ಕ\u{cc2}ಟರ\u{ccd}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("스쿠터"),
            keywords: &["스쿠터", "오토바이", "전동"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("मोटर स\u{94d}क\u{941}टर"),
            keywords: &["मोटर", "स\u{94d}क\u{941}टर"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("мопед"),
            keywords: &["мопед"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Scooter"),
            keywords: &["Motor", "Scooter"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ສະກ\u{eb9}ດເຕ\u{eb5}"),
            keywords: &["ຈ\u{eb1}ກ", "ສະກ\u{eb9}ດເຕ\u{eb5}"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("motoroleris"),
            keywords: &["motoroleris", "transportas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("motorollers"),
            keywords: &["motorollers"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("hūpaika"),
            keywords: &["hūpaika", "pūkaha"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("скутер"),
            keywords: &["мотор", "скутер"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("മോട\u{d4d}ടോർ സ\u{d4d}ക\u{d42}ട\u{d4d}ടർ"),
            keywords: &["മോട\u{d4d}ടോർ", "സ\u{d4d}ക\u{d42}ട\u{d4d}ടർ"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("моторт дугуй"),
            keywords: &["мотор", "моторт дугуй"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("मोटर स\u{94d}क\u{942}टर"),
            keywords: &["मोटर", "स\u{94d}क\u{942}टर"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("skuter bermotor"),
            keywords: &["motosikal", "skuter", "skuter bermotor"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("scooter bil-mutur"),
            keywords: &["mutur", "scooter", "scooter bil-mutur"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("မော\u{103a}တာစက\u{103a}တပ\u{103a} စက\u{1030}တာ"),
            keywords: &[
                "စက\u{1030}တာ",
                "မော\u{103a}တာ",
                "မော\u{103a}တာစက\u{103a}တပ\u{103a} စက\u{1030}တာ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("scooter"),
            keywords: &["motor", "motorsykkel", "scooter"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("मोटर स\u{94d}क\u{941}टर"),
            keywords: &["मोटर", "स\u{94d}क\u{941}टर"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("scooter"),
            keywords: &["brommer", "motor", "scooter"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("scooter"),
            keywords: &["motor", "motorsykkel", "scooter"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ମୋଟର ସ\u{b4d}କ\u{b41}ଟର\u{b4d}\u{200c}"),
            keywords: &["ମୋଟର", "ସ\u{b4d}କ\u{b41}ଟର\u{b4d}\u{200c}"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਮ\u{a4b}ਟਰ ਸਕ\u{a42}ਟਰ"),
            keywords: &["ਮ\u{a4b}ਟਰ", "ਸਕ\u{a42}ਟਰ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("موٹر سکوٹر"),
            keywords: &["سکوٹر", "موٹر"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Skúta Motosaíkul"),
            keywords: &["Motosaíkul", "Résín Kọmpitíshọn", "Skúta Motosaíkul"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("skuter"),
            keywords: &["motor", "pojazd", "skuter"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("موټر سکوټر"),
            keywords: &["سکوټر", "موټر"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("scooter"),
            keywords: &["moto", "scooter"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("lambreta"),
            keywords: &["lambreta", "motorizada", "scooter"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("patinador motorwan"),
            keywords: &["patinador motorwan"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("scuter"),
            keywords: &["motor", "motoscuter", "scuter"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1006"),
            keywords: &["E10-1006"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("скутер"),
            keywords: &["мопед", "скутер", "транспорт"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("sikuteri ya moto"),
            keywords: &["sikuteri", "sikuteri ya moto", "ya moto"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("موٽر اسڪوٽر"),
            keywords: &["اسڪوٽر", "موٽر"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("මෝටර\u{dca} ස\u{dca}ක\u{dd6}ටරය"),
            keywords: &["මෝටර\u{dca}", "ස\u{dca}ක\u{dd6}ටරය"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("skúter"),
            keywords: &["motorka", "skúter"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("skuter"),
            keywords: &["motor", "skuter"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("mooto matoor qaawan"),
            keywords: &["matoor", "mooto matoor qaawan", "mooto qaawan"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("skuter"),
            keywords: &["motor", "motoçikletë", "skuter"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("скутер"),
            keywords: &["мотор", "скутер"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("skuter"),
            keywords: &["motor", "skuter"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("skoter"),
            keywords: &["motor", "skoter"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("pikipiki (skuta)"),
            keywords: &["pikipiki", "pikipiki (skuta)"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ஸ\u{bcd}கூட\u{bcd}டர\u{bcd}"),
            keywords: &["மோட\u{bcd}ட\u{bbe}ர\u{bcd}", "ஸ\u{bcd}கூட\u{bcd}டர\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("మ\u{c4b}ట\u{c3e}ర\u{c4d} స\u{c4d}కూటర\u{c4d}"),
            keywords: &["మ\u{c4b}ట\u{c3e}ర\u{c4d}", "స\u{c4d}కూటర\u{c4d}"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("скутер"),
            keywords: &["муҳаррик", "скутер"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("รถสก\u{e39}\u{e4a}ตเตอร\u{e4c}"),
            keywords: &[
                "รถ",
                "รถสก\u{e39}\u{e4a}ตเตอร\u{e4c}",
                "สก\u{e39}\u{e4a}ตเตอร\u{e4c}",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("moto-skuter"),
            keywords: &["moto-skuter", "motor", "skuter"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("paiki sikuta"),
            keywords: &["paiki sikuta"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("motorlu skuter"),
            keywords: &["motor", "motorlu skuter", "skuter"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("كىچىك موتوسىكلىت"),
            keywords: &["كىچىك موتوسىكلىت", "موتورلۇق", "ۋېلىسىپىت"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("мопед"),
            keywords: &["мопед", "скутер"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("موٹر والا سکوٹر"),
            keywords: &["سکوٹر", "موٹر", "موٹر والا سکوٹر"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("moped"),
            keywords: &["moped", "motor", "skuter"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("xe tay ga"),
            keywords: &["mô tơ", "xe tay ga"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("eskutër"),
            keywords: &["eskutër", "moto"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("isithuthuthu semoto"),
            keywords: &["imoto", "isithuthu", "isithuthuthu semoto"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("alupupu onimọto"),
            keywords: &["alupupu", "onimọto"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("電動滑板車"),
            keywords: &["滑板車", "發動機", "電動滑板車"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("电动滑板车"),
            keywords: &["发动机", "滑板车", "电动滑板车"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("小型摩托车"),
            keywords: &["小型摩托车"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("摩托車"),
            keywords: &["摩托車", "機車"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("綿羊仔"),
            keywords: &["綿羊仔", "電單車"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("isithuthuthu"),
            keywords: &["imoto", "isithuthuthu"],
        },
    ],
};
#[doc = "🦽"]
pub const MANUAL_WHEELCHAIR: crate::Emoji = crate::Emoji {
    glyph: "🦽",
    codepoint: "1F9BD",
    status: crate::Status::FullyQualified,
    introduction_version: 12f32,
    name: "manual wheelchair",
    group: "Travel & Places",
    subgroup: "transport-ground",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("handgedrewe rolstoel"),
            keywords: &["handgedrewe rolstoel", "toeganklikheid"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የእጅ ተሽከርካሪ ወንበር"),
            keywords: &["ተደራሽነት", "የእጅ ተሽከርካሪ ወንበር"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("كرسي متحرك يدوي"),
            keywords: &["إمكانية الوصول", "احتياجات خاصة", "كرسي متحرك يدوي"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("হস\u{9cd}তচ\u{9be}লিত হ\u{9c1}ইলশ\u{9cd}বেয\u{9bc}\u{9be}ৰ"),
            keywords: &[
                "দিব\u{9cd}য\u{9be}ংগ",
                "হস\u{9cd}তচ\u{9be}লিত হ\u{9c1}ইলশ\u{9cd}বেয\u{9bc}\u{9be}ৰ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("manual təkərli kreslo"),
            keywords: &["manual təkərli kreslo", "əlverişlilik"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("інвалідная каляска з ручным прывадам"),
            keywords: &[
                "асаблівыя фізічныя патрэбы",
                "інваліднасць",
                "інвалідная каляска з ручным прывадам",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("рингова инвалидна количка"),
            keywords: &["достъпна среда", "достъпност", "рингова инвалидна количка"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ম\u{9cd}য\u{9be}ন\u{9c1}য\u{9bc}\u{9be}ল হ\u{9c1}ইলচেয\u{9bc}\u{9be}র"),
            keywords: &[
                "অ\u{9cd}য\u{9be}ক\u{9cd}সেসিবিলিটি",
                "ম\u{9cd}য\u{9be}ন\u{9c1}য\u{9bc}\u{9be}ল হ\u{9c1}ইলচেয\u{9bc}\u{9be}র",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("ručna invalidska kolica"),
            keywords: &["pomagalo", "ručna invalidska kolica"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cadira de rodes manual"),
            keywords: &["accessibilitat", "cadira de rodes manual"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎦᏆᏙᏗ ᎦᏍᎩᎶ"),
            keywords: &["ᎦᏆᏙᏗ ᎦᏍᎩᎶ", "ᎬᏴᏍᏗ ᎨᏒᎢ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("mechanický invalidní vozík"),
            keywords: &[
                "handicap",
                "hendikep",
                "invalidita",
                "invalidní",
                "mechanický invalidní vozík",
                "pomůcka",
                "postižení",
                "usnadnění",
                "zpřístupnění",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("cadair olwyn heb beiriant"),
            keywords: &["cadair olwyn heb beiriant", "hygyrchedd"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("manuel kørestol"),
            keywords: &["handikap", "manuel kørestol"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("manueller Rollstuhl"),
            keywords: &["Barrierefreiheit", "manueller Rollstuhl"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("αναπηρικό αμαξίδιο"),
            keywords: &["αναπηρικό αμαξίδιο", "προσβασιμότητα"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("manual wheelchair"),
            keywords: &["accessibility", "manual wheelchair"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("silla de ruedas manual"),
            keywords: &["accesibilidad", "silla de ruedas manual"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("manuaalratastool"),
            keywords: &["juurdepääs", "ligipääs", "manuaalratastool", "ratastool"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("eskuzko gurpil-aulkia"),
            keywords: &["eskuzko gurpil-aulkia", "irisgarritasun"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("صندلی چرخ\u{200c}دار دستی"),
            keywords: &["دسترس\u{200c}پذیری", "صندلی چرخ\u{200c}دار دستی"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("käsikäyttöinen pyörätuoli"),
            keywords: &["esteettömyys", "käsikäyttöinen pyörätuoli"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("manu-manong wheelchair"),
            keywords: &["manu-manong wheelchair", "pagiging naa-access"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("koyristólur"),
            keywords: &["hjólstólur", "koyristólur", "rullistólur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("fauteuil roulant manuel"),
            keywords: &["accessibilité", "fauteuil roulant manuel"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("cathaoir rothaí láimhe"),
            keywords: &["cathaoir rothaí láimhe", "inrochtaineacht"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("cathair-chuibhle a làimh"),
            keywords: &["cathair-chuibhle a làimh", "so-ruigsinneachd"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cadeira de rodas"),
            keywords: &["cadeira de rodas", "discapacidade", "manual"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("હાથથી ચલાવાતી વ\u{acd}હીલચ\u{ac7}ર"),
            keywords: &[
                "ઍક\u{acd}સ\u{ac7}સિબિલિટી",
                "હાથથી ચલાવાતી વ\u{acd}હીલચ\u{ac7}ર",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("כסא גלגלים ידני"),
            keywords: &["כסא גלגלים ידני", "נגישות"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("हस\u{94d}तचालित व\u{94d}हीलच\u{947}यर"),
            keywords: &[
                "व\u{94d}हीलच\u{947}यर",
                "सहायता",
                "हस\u{94d}तचालित व\u{94d}हीलच\u{947}यर",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("invalidska kolica na ručni pogon"),
            keywords: &["invalidska kolica na ručni pogon", "pomagalo"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("kézi hajtású kerekesszék"),
            keywords: &["akadálymentesség", "kézi hajtású kerekesszék"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ձեռքով կառավարվող անվասայլակ"),
            keywords: &["հաշմանդամ", "ձեռքով կառավարվող անվասայլակ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("kursi roda manual"),
            keywords: &["aksesibilitas", "kursi roda manual"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("hjólastóll"),
            keywords: &["aðgengi", "hjólastóll"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("sedia a rotelle manuale"),
            keywords: &[
                "accessibilità",
                "carrozzina manuale",
                "sedia a rotelle manuale",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("手動式車椅子"),
            keywords: &["アクセシビリティ", "手動式車椅子", "椅子", "車椅子"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("kursi rodha manual"),
            keywords: &["kalancaran", "kursi rodha manual"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("შშმ პირის მექანიკური ეტლი"),
            keywords: &[
                "განსაკუთრებული შესაძლებლობების მქონე",
                "შეზღუდული შესაძლებლობების მქონე",
                "შშმ პირი",
                "შშმ პირის მექანიკური ეტლი",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("қол жетегі бар арбаша"),
            keywords: &["мүмкіндігі шектеулі", "қол жетегі бар арбаша"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("រទេះជនព\u{17b7}ការដែលរ\u{17bb}ញដោយដៃ"),
            keywords: &[
                "រទេះជនព\u{17b7}ការដែលរ\u{17bb}ញដោយដៃ",
                "លទ\u{17d2}ធភាពទទ\u{17bd}លបាន",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಸಾಮಾನ\u{ccd}ಯ ಗಾಲ\u{cbf}ಕುರ\u{ccd}ಚ\u{cbf}"),
            keywords: &[
                "ಪ\u{ccd}ರವೇಶ\u{cbf}ಸುವ\u{cbf}ಕ\u{cc6}",
                "ಸಾಮಾನ\u{ccd}ಯ ಗಾಲ\u{cbf}ಕುರ\u{ccd}ಚ\u{cbf}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("수동 휠체어"),
            keywords: &["수동 휠체어", "접근성"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("म\u{945}न\u{94d}य\u{941}अल व\u{94d}हीलच\u{945}र"),
            keywords: &[
                "ऍक\u{94d}स\u{945}सिबिलिटी",
                "म\u{945}न\u{94d}य\u{941}अल व\u{94d}हीलच\u{945}र",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("кол менен дөңгөлөктүү отургуч"),
            keywords: &["атайын мүмкүндүк", "кол менен дөңгөлөктүү отургуч"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some(
                "ລ\u{ecd}\u{ec9}\u{200b}ຍ\u{eb9}\u{ec9}\u{200b}ແບບ\u{200b}ບ\u{eb1}ງ\u{200b}ຄ\u{eb1}ບ\u{200b}ເອງ",
            ),
            keywords: &[
                "ຄວາມ\u{200b}ສາ\u{200b}ມາດ\u{200b}ເຂ\u{ebb}\u{ec9}າ\u{200b}ເຖ\u{eb4}ງ",
                "ລ\u{ecd}\u{ec9}\u{200b}ຍ\u{eb9}\u{ec9}\u{200b}ແບບ\u{200b}ບ\u{eb1}ງ\u{200b}ຄ\u{eb1}ບ\u{200b}ເອງ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("rankomis valdomas vežimėlis"),
            keywords: &["prieinamumas", "rankomis valdomas vežimėlis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("manuāli darbināms ratiņkrēsls"),
            keywords: &["manuāli darbināms ratiņkrēsls", "pieejamība"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("инвалидска количка на рачен погон"),
            keywords: &["инвалидска количка на рачен погон", "пристапност"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("മ\u{d3e}ന\u{d4d}വൽ വീൽചെയർ"),
            keywords: &[
                "ആക\u{d4d}\u{200c}സസബിലിറ\u{d4d}റി",
                "മ\u{d3e}ന\u{d4d}വൽ വീൽചെയർ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("гар тэргэнцэр"),
            keywords: &["гар тэргэнцэр", "хүртээмж"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("व\u{94d}यक\u{94d}तिचलित व\u{94d}हीलच\u{947}अर"),
            keywords: &[
                "अ\u{945}क\u{94d}स\u{947}सिबिलिटी",
                "व\u{94d}यक\u{94d}तिचलित व\u{94d}हीलच\u{947}अर",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("kerusi roda manual"),
            keywords: &["kebolehcapaian", "kerusi roda manual"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("လ\u{1030}နာတင\u{103a} က\u{102f}လားထ\u{102d}\u{102f}င\u{103a}"),
            keywords: &[
                "လ\u{1030}နာတင\u{103a} က\u{102f}လားထ\u{102d}\u{102f}င\u{103a}",
                "အများသ\u{102f}\u{1036}းစ\u{103d}\u{1032}န\u{102d}\u{102f}င\u{103a}မ\u{103e}\u{102f}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("manuell rullestol"),
            keywords: &["manuell rullestol", "tilgjengelighet"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("म\u{94d}यान\u{941}अल व\u{94d}हीलच\u{947}यर"),
            keywords: &[
                "उपलब\u{94d}धता",
                "म\u{94d}यान\u{941}अल व\u{94d}हीलच\u{947}यर",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("rolstoel"),
            keywords: &["rolstoel", "toegankelijkheid"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("manuell rullestol"),
            keywords: &["manuell rullestol", "tilgjenge"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ମ\u{b3e}ନ\u{b41}ଆଲ\u{b4d}\u{200c} ହ\u{b4d}ୱ\u{b3f}ଲଚେୟ\u{b3e}ର"),
            keywords: &[
                "ପ\u{b4d}ରବେଶ\u{b3e}ଧ\u{b3f}କ\u{b3e}ର",
                "ମ\u{b3e}ନ\u{b41}ଆଲ\u{b4d}\u{200c} ହ\u{b4d}ୱ\u{b3f}ଲଚେୟ\u{b3e}ର",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਹ\u{a71}ਥਾ\u{a02} ਨਾਲ ਚ\u{a71}ਲਣ ਵਾਲੀ ਵ\u{a4d}ਹੀਲਚ\u{a47}ਅਰ"),
            keywords: &[
                "ਸਹ\u{a42}ਲਤ",
                "ਹ\u{a71}ਥਾ\u{a02} ਨਾਲ ਚ\u{a71}ਲਣ ਵਾਲੀ ਵ\u{a4d}ਹੀਲਚ\u{a47}ਅਰ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Wílchia Wé Nọ\u{301} Gẹ\u{301}t Ẹ\u{301}njin"),
            keywords: &["Wílchia Wé Nọ\u{301} Gẹ\u{301}t Ẹ\u{301}njin", "Ízí To Yuz"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("wózek inwalidzki ręczny"),
            keywords: &["dostępność", "wózek inwalidzki ręczny"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د معلولينو لاسي چوکۍ"),
            keywords: &["د معلولينو لاسي چوکۍ", "رسوړتيا"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("cadeira de rodas manual"),
            keywords: &["acessibilidade", "cadeira de rodas manual"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("scaun cu rotile manual"),
            keywords: &["accesibilitate", "scaun cu rotile manual"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E12–039"),
            keywords: &["E12–039"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("кресло-коляска с ручным приводом"),
            keywords: &[
                "инвалид",
                "коляска",
                "кресло",
                "кресло-коляска с ручным приводом",
                "ручной",
                "транспорт",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("دستي وهيل چيئر"),
            keywords: &["دستي وهيل چيئر", "رسائي پذيري"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("අත\u{dd2}න\u{dca} කරකවන රෝද ප\u{dd4}ට\u{dd4}ව"),
            keywords: &[
                "අත\u{dd2}න\u{dca} කරකවන රෝද ප\u{dd4}ට\u{dd4}ව",
                "ළඟ\u{dcf}ව\u{dd2}ය හැක\u{dd2} බව",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("mechanický invalidný vozík"),
            keywords: &[
                "invalid",
                "mechanický invalidný vozík",
                "pomôcka",
                "prístupnosť",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("ročni invalidski voziček"),
            keywords: &["invalid", "ročni invalidski voziček"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("kursiga curyaanka macmalka ah"),
            keywords: &["awood u yeelid", "kursiga curyaanka macmalka ah"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("karrocë invalidi manuale"),
            keywords: &["karrocë invalidi manuale", "qasshmëri"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("колица на ручни погон"),
            keywords: &["колица на ручни погон", "приступачност"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("kolica na ručni pogon"),
            keywords: &["kolica na ručni pogon", "pristupačnost"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("manuell rullstol"),
            keywords: &["manuell rullstol", "tillgänglighet"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kiti cha magurudumu kisicho na mota"),
            keywords: &["kiti cha magurudumu kisicho na mota", "ufikivu"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some(
                "மனித ஆற\u{bcd}றலில\u{bcd} இயங\u{bcd}கும\u{bcd} சக\u{bcd}கர ந\u{bbe}ற\u{bcd}க\u{bbe}லி",
            ),
            keywords: &[
                "உபகரணம\u{bcd}",
                "சக\u{bcd}கர ந\u{bbe}ற\u{bcd}க\u{bbe}லி",
                "மனித ஆற\u{bcd}றலில\u{bcd} இயங\u{bcd}கும\u{bcd} சக\u{bcd}கர ந\u{bbe}ற\u{bcd}க\u{bbe}லி",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some(
                "మ\u{c3e}న\u{c4d}యువల\u{c4d} వ\u{c40}ల\u{c4d}\u{200c}చ\u{c46}య\u{c3f}ర\u{c4d}",
            ),
            keywords: &[
                "మ\u{c3e}న\u{c4d}యువల\u{c4d} వ\u{c40}ల\u{c4d}\u{200c}చ\u{c46}య\u{c3f}ర\u{c4d}",
                "స\u{c4c}లభ\u{c4d}యం",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ว\u{e35}ลแชร\u{e4c}ธรรมดา"),
            keywords: &[
                "การช\u{e48}วยการเข\u{e49}าถ\u{e36}ง",
                "การเข\u{e49}าถ\u{e36}ง",
                "ว\u{e35}ลแชร\u{e4c}ธรรมดา",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("el maýyp arabasy"),
            keywords: &["el maýyp arabasy", "elýeterlilik"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("sāliote falemahaki"),
            keywords: &["sāliote falemahaki"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("tekerlekli sandalye"),
            keywords: &["erişilebilirlik", "tekerlekli sandalye"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("колісний візок із ручним приводом"),
            keywords: &[
                "доступність",
                "колісний візок із ручним приводом",
                "спеціальний засіб",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("دستی وہیل چئیر"),
            keywords: &["دسترس", "دستی وہیل چئیر"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("nogironlik aravachasi"),
            keywords: &["aravacha", "nogironlik", "nogironlik aravachasi"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("xe lăn tay"),
            keywords: &["hỗ trợ tiếp cận", "trợ năng", "xe lăn tay"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("手動輪椅"),
            keywords: &["手動輪椅", "無障礙"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("手动轮椅"),
            keywords: &["手动轮椅", "无障碍"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("手动轮椅"),
            keywords: &["手动轮椅", "无障碍", "轮椅"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("輪椅"),
            keywords: &["行動不便", "輪椅"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("isitulo esihanjiswayo"),
            keywords: &["isitulo esihanjiswayo", "ukufinyelela"],
        },
    ],
};
#[doc = "🦼"]
pub const MOTORIZED_WHEELCHAIR: crate::Emoji = crate::Emoji {
    glyph: "🦼",
    codepoint: "1F9BC",
    status: crate::Status::FullyQualified,
    introduction_version: 12f32,
    name: "motorized wheelchair",
    group: "Travel & Places",
    subgroup: "transport-ground",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("motoraangedrewe rolstoel"),
            keywords: &["motoraangedrewe rolstoel", "toeganklikheid"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ባለሞተር ተሽከርካሪ ወንበር"),
            keywords: &["ባለሞተር ተሽከርካሪ ወንበር", "ተደራሽነት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("كرسي متحرك كهربائي"),
            keywords: &["إمكانية الوصول", "احتياجات خاصة", "كرسي متحرك كهربائي"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("মটৰচ\u{9be}লিত হ\u{9c1}ইলশ\u{9cd}বেয\u{9bc}\u{9be}ৰ"),
            keywords: &[
                "দিব\u{9cd}য\u{9be}ংগ",
                "মটৰচ\u{9be}লিত হ\u{9c1}ইলশ\u{9cd}বেয\u{9bc}\u{9be}ৰ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("motorlu təkərli kreslo"),
            keywords: &["motorlu təkərli kreslo", "əlverişlilik"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("інвалідная каляска з маторам"),
            keywords: &[
                "асаблівыя фізічныя патрэбы",
                "інваліднасць",
                "інвалідная каляска з маторам",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("акумулаторна инвалидна количка"),
            keywords: &[
                "акумулаторна инвалидна количка",
                "достъпна среда",
                "достъпност",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("মোটরচ\u{9be}লিত হ\u{9c1}ইলচেয\u{9bc}\u{9be}র"),
            keywords: &[
                "অ\u{9cd}য\u{9be}ক\u{9cd}সেসিবিলিটি",
                "মোটরচ\u{9be}লিত হ\u{9c1}ইলচেয\u{9bc}\u{9be}র",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("elektromotorna invalidska kolica"),
            keywords: &[
                "elektromotorna invalidska kolica",
                "elektromotorno pomagalo",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cadira de rodes elèctrica"),
            keywords: &["accessibilitat", "cadira de rodes elèctrica"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏂᎩᏍᏗᏍᎩ ᎦᏆᏙᏗ ᎦᏍᎩᎶ"),
            keywords: &["ᎠᏂᎩᏍᏗᏍᎩ ᎦᏆᏙᏗ ᎦᏍᎩᎶ", "ᎬᏴᏍᏗ ᎨᏒᎢ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("elektrický invalidní vozík"),
            keywords: &[
                "elektrický invalidní vozík",
                "handicap",
                "hendikep",
                "invalidita",
                "invalidní",
                "pomůcka",
                "postižení",
                "usnadnění",
                "zpřístupnění",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("cadair olwyn â pheiriant"),
            keywords: &["cadair olwyn â pheiriant", "hygyrchedd"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("elektrisk kørestol"),
            keywords: &["elektrisk kørestol", "handikap"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("elektrischer Rollstuhl"),
            keywords: &["Barrierefreiheit", "elektrischer Rollstuhl"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ηλεκτροκίνητο αναπηρικό αμαξίδιο"),
            keywords: &["ηλεκτροκίνητο αναπηρικό αμαξίδιο", "προσβασιμότητα"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("motorized wheelchair"),
            keywords: &["accessibility", "motorized wheelchair"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: Some("powered wheelchair"),
            keywords: &["accessibility", "powered wheelchair"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("mobility scooter"),
            keywords: &["mobility scooter"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("powered wheelchair"),
            keywords: &["accessibility", "powered wheelchair"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("silla de ruedas eléctrica"),
            keywords: &["accesibilidad", "silla de ruedas eléctrica"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("elektriratastool"),
            keywords: &["elektriratastool", "juurdepääs", "ligipääs", "ratastool"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("gurpil-aulki motorduna"),
            keywords: &["gurpil-aulki motorduna", "irisgarritasun"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("صندلی چرخ\u{200c}دار برقی"),
            keywords: &["دسترس\u{200c}پذیری", "صندلی چرخ\u{200c}دار برقی"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("moottoroitu pyörätuoli"),
            keywords: &["esteettömyys", "moottoroitu pyörätuoli"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("de-kuryenteng wheelchair"),
            keywords: &["de-kuryenteng wheelchair", "pagiging naa-access"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("motorkoyristólur"),
            keywords: &[
                "koyristólur",
                "motorhjólstólur",
                "motorkoyristólur",
                "motorrullistólur",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("fauteuil motorisé"),
            keywords: &["accessibilité", "fauteuil motorisé", "fauteuil roulant"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("cathaoir rothaí mheicniúil"),
            keywords: &["cathaoir rothaí mheicniúil", "inrochtaineacht"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("cathair-chuibhle le einnsein"),
            keywords: &["cathair-chuibhle le einnsein", "so-ruigsinneachd"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cadeira de rodas motorizada"),
            keywords: &[
                "cadeira de rodas motorizada",
                "discapacidade",
                "eléctrica",
                "motorizada",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("મશીનથી ચાલતી વ\u{acd}હીલચ\u{ac7}ર"),
            keywords: &[
                "ઍક\u{acd}સ\u{ac7}સિબિલિટી",
                "મશીનથી ચાલતી વ\u{acd}હીલચ\u{ac7}ર",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("כסא גלגלים ממונע"),
            keywords: &["כסא גלגלים ממונע", "נגישות"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("मोटर व\u{94d}हीलच\u{947}यर"),
            keywords: &[
                "मोटर व\u{94d}हीलच\u{947}यर",
                "व\u{94d}हीलच\u{947}यर",
                "सहायता",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("invalidska kolica na motorni pogon"),
            keywords: &["invalidska kolica na motorni pogon", "pomagalo"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("motoros kerekesszék"),
            keywords: &["akadálymentesség", "motoros kerekesszék"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("մոտորասայլակ"),
            keywords: &["հաշմանդամ", "մոտորասայլակ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("kursi roda bermotor"),
            keywords: &["aksesibilitas", "kursi roda bermotor"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("vélknúinn hj´ólastóll"),
            keywords: &["aðgengi", "vélknúinn hj´ólastóll"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("sedia a rotelle motorizzata"),
            keywords: &[
                "accessibilità",
                "carrozzina motorizzata",
                "sedia a rotelle motorizzata",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("電動車椅子"),
            keywords: &["アクセシビリティ", "椅子", "車椅子", "電動車椅子"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("kursi rodha mesin"),
            keywords: &["kalancaran", "kursi rodha mesin"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("შშმ პირის მოტორიანი ეტლი"),
            keywords: &[
                "განსაკუთრებული შესაძლებლობების მქონე",
                "შეზღუდული შესაძლებლობების მქონე",
                "შშმ პირი",
                "შშმ პირის მოტორიანი ეტლი",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("электр жетегі бар арбаша"),
            keywords: &["мүмкіндігі шектеулі", "электр жетегі бар арбаша"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("រទេះជនព\u{17b7}ការដែលប\u{17d2}រើម\u{17c9}ាស\u{17ca}\u{17b8}ន"),
            keywords: &[
                "រទេះជនព\u{17b7}ការដែលប\u{17d2}រើម\u{17c9}ាស\u{17ca}\u{17b8}ន",
                "លទ\u{17d2}ធភាព\u{200b}ច\u{17bc}ល",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಮೋಟರ\u{ccd} ಹೊಂದ\u{cbf}ದ ಗಾಲ\u{cbf}ಕುರ\u{ccd}ಚ\u{cbf}"),
            keywords: &[
                "ಪ\u{ccd}ರವೇಶ\u{cbf}ಸುವ\u{cbf}ಕ\u{cc6}",
                "ಮೋಟರ\u{ccd} ಹೊಂದ\u{cbf}ದ ಗಾಲ\u{cbf}ಕುರ\u{ccd}ಚ\u{cbf}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("전동 휠체어"),
            keywords: &["전동 휠체어", "접근성"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("मोटोरायझ\u{94d}ड व\u{94d}हीलच\u{945}र"),
            keywords: &[
                "ऍक\u{94d}स\u{945}सिबिलिटी",
                "मोटर आसपी व\u{94d}हीलच\u{945}र",
                "मोटोरायझ\u{94d}ड व\u{94d}हीलच\u{945}र",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("майыптардын моторлуу арабасы"),
            keywords: &[
                "майып",
                "майыптардын моторлуу арабасы",
                "моторлуу араба",
                "мүмкүнчүлүктөрү чектелген",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some(
                "ລ\u{ecd}\u{ec9}\u{200b}ຍ\u{eb9}\u{ec9}\u{200b}ແບບ\u{200b}ຕ\u{eb4}ດ\u{200b}ຕ\u{eb1}\u{ec9}ງ\u{200b}ມ\u{ecd}\u{200b}ເຕ\u{eb5}\u{ec9}",
            ),
            keywords: &[
                "ຄວາມ\u{200b}ສາ\u{200b}ມາດ\u{200b}ເຂ\u{ebb}\u{ec9}າ\u{200b}ເຖ\u{eb4}ງ",
                "ລ\u{ecd}\u{ec9}\u{200b}ຍ\u{eb9}\u{ec9}\u{200b}ແບບ\u{200b}ຕ\u{eb4}ດ\u{200b}ຕ\u{eb1}\u{ec9}ງ\u{200b}ມ\u{ecd}\u{200b}ເຕ\u{eb5}\u{ec9}",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("motorizuotas vežimėlis"),
            keywords: &["motorizuotas vežimėlis", "prieinamumas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("ar motoru darbināms ratiņkrēsls"),
            keywords: &["ar motoru darbināms ratiņkrēsls", "pieejamība"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("инвалидска количка на моторен погон"),
            keywords: &["инвалидска количка на моторен погон", "пристапност"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("മോട\u{d4d}ടോറൈസ\u{d4d}\u{200c}ഡ\u{d4d} വീൽചെയർ"),
            keywords: &[
                "ആക\u{d4d}\u{200c}സസബിലിറ\u{d4d}റി",
                "മോട\u{d4d}ടോറൈസ\u{d4d}\u{200c}ഡ\u{d4d} വീൽചെയർ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("моторт тэргэнцэр"),
            keywords: &["моторт тэргэнцэр", "хүртээмж"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("मोटार असल\u{947}ली व\u{94d}हीलच\u{947}अर"),
            keywords: &[
                "अ\u{945}क\u{94d}स\u{947}सिबिलिटी",
                "मोटार असल\u{947}ली व\u{94d}हीलच\u{947}अर",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("kerosi roda bermotor"),
            keywords: &["kebolehcapaian", "kerosi roda bermotor"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("စက\u{103a}တပ\u{103a} က\u{102f}လားထ\u{102d}\u{102f}င\u{103a}"),
            keywords: &[
                "စက\u{103a}တပ\u{103a} က\u{102f}လားထ\u{102d}\u{102f}င\u{103a}",
                "အများသ\u{102f}\u{1036}းစ\u{103d}\u{1032}န\u{102d}\u{102f}င\u{103a}မ\u{103e}\u{102f}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("motorisert rullestol"),
            keywords: &["motorisert rullestol", "tilgjengelighet"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("मोटराइज\u{94d}ड व\u{94d}हीलच\u{947}यर"),
            keywords: &["उपलब\u{94d}धता", "मोटराइज\u{94d}ड व\u{94d}हीलच\u{947}यर"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("elektrische rolstoel"),
            keywords: &["elektrische rolstoel", "toegankelijkheid"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("motorisert rullestol"),
            keywords: &["motorisert rullestol", "tilgjenge"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ମୋଟୋର\u{b3e}ଇଜ\u{b3f}ଡ\u{b4d}\u{200c} ହ\u{b4d}ୱ\u{b3f}ଲଚେୟ\u{b3e}ର"),
            keywords: &[
                "ପ\u{b4d}ରବେଶ\u{b3e}ଧ\u{b3f}କ\u{b3e}ର",
                "ମୋଟୋର\u{b3e}ଇଜ\u{b3f}ଡ\u{b4d}\u{200c} ହ\u{b4d}ୱ\u{b3f}ଲଚେୟ\u{b3e}ର",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਮ\u{a4b}ਟਰ ਨਾਲ ਚ\u{a71}ਲਣ ਵਾਲੀ ਵ\u{a4d}ਹੀਲਚ\u{a47}ਅਰ"),
            keywords: &[
                "ਮ\u{a4b}ਟਰ ਨਾਲ ਚ\u{a71}ਲਣ ਵਾਲੀ ਵ\u{a4d}ਹੀਲਚ\u{a47}ਅਰ",
                "ਸਹ\u{a42}ਲਤ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Wílchia Wé Gẹ\u{301}t Ẹ\u{301}njin"),
            keywords: &["Wílchia Wé Gẹ\u{301}t Ẹ\u{301}njin", "Ízí To Yuz"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("wózek inwalidzki elektryczny"),
            keywords: &["dostępność", "wózek inwalidzki elektryczny"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د معلولينو موټري چوکۍ"),
            keywords: &["د معلولينو موټري چوکۍ", "رسوړتيا"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("cadeira de rodas motorizada"),
            keywords: &["acessibilidade", "cadeira de rodas motorizada"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("cadeira de rodas elétrica"),
            keywords: &[
                "acessibilidade",
                "cadeira de rodas elétrica",
                "cadeira de rodas motorizada",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("scaun cu rotile motorizat"),
            keywords: &["accesibilitate", "scaun cu rotile motorizat"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E12–038"),
            keywords: &["E12–038"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("кресло-коляска с мотором"),
            keywords: &[
                "инвалид",
                "кресло",
                "кресло-коляска",
                "кресло-коляска с мотором",
                "транспорт",
                "электропривод",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("موٽر واري وهيل چيئر"),
            keywords: &["رسائي پذيري", "موٽر واري وهيل چيئر"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("මෝටර\u{dca} රෝද ප\u{dd4}ට\u{dd4}ව"),
            keywords: &[
                "මෝටර\u{dca} රෝද ප\u{dd4}ට\u{dd4}ව",
                "ළඟ\u{dcf}ව\u{dd2}ය හැක\u{dd2} බව",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("elektrický invalidný vozík"),
            keywords: &[
                "elektrický invalidný vozík",
                "invalid",
                "pomôcka",
                "prístupnosť",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("motoriziran invalidski voziček"),
            keywords: &["invalid", "motoriziran invalidski voziček"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("kursiga curyaanka korontada ku shaqeeya"),
            keywords: &["awood u yeelid", "kursiga curyaanka korontada ku shaqeeya"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("karrocë invalidi me motor"),
            keywords: &["karrocë invalidi me motor", "qasshmëri"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("моторна колица"),
            keywords: &["моторна колица", "приступачност"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("motorna kolica"),
            keywords: &["motorna kolica", "pristupačnost"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("eldriven rullstol"),
            keywords: &["eldriven rullstol", "tillgänglighet"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kiti cha magurudumu chenye mota"),
            keywords: &["kiti cha magurudumu chenye mota", "ufikivu"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some(
                "மின\u{bcd}ன\u{bbe}ற\u{bcd}றலில\u{bcd} இயங\u{bcd}கும\u{bcd} சக\u{bcd}கர ந\u{bbe}ற\u{bcd}க\u{bbe}லி",
            ),
            keywords: &[
                "உபகரணம\u{bcd}",
                "சக\u{bcd}கர ந\u{bbe}ற\u{bcd}க\u{bbe}லி",
                "மின\u{bcd}ன\u{bbe}ற\u{bcd}றலில\u{bcd} இயங\u{bcd}கும\u{bcd} சக\u{bcd}கர ந\u{bbe}ற\u{bcd}க\u{bbe}லி",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("మ\u{c4b}ట\u{c3e}రు వ\u{c40}ల\u{c4d}\u{200c}చ\u{c46}య\u{c3f}ర\u{c4d}"),
            keywords: &[
                "మ\u{c4b}ట\u{c3e}రు వ\u{c40}ల\u{c4d}\u{200c}చ\u{c46}య\u{c3f}ర\u{c4d}",
                "స\u{c4c}లభ\u{c4d}యం",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ว\u{e35}ลแชร\u{e4c}ไฟฟ\u{e49}า"),
            keywords: &[
                "การช\u{e48}วยการเข\u{e49}าถ\u{e36}ง",
                "การเข\u{e49}าถ\u{e36}ง",
                "ว\u{e35}ลแชร\u{e4c}ไฟฟ\u{e49}า",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("motorly maýyp arabasy"),
            keywords: &["elýeterlilik", "motorly maýyp arabasy"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("sāliote falemahaki mīsini"),
            keywords: &["sāliote falemahaki mīsini"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("elektrikli tekerlekli sandalye"),
            keywords: &["elektrikli tekerlekli sandalye", "erişilebilirlik"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("колісний візок з електроприводом"),
            keywords: &[
                "доступність",
                "колісний візок з електроприводом",
                "спеціальний засіб",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("موٹر والی وہیل چئیر"),
            keywords: &["دسترس", "موٹر والی وہیل چئیر"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("motorli nogironlik aravachasi"),
            keywords: &[
                "motorli aravacha",
                "motorli nogironlik aravachasi",
                "nogironlik",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("xe lăn tự động"),
            keywords: &["hỗ trợ tiếp cận", "trợ năng", "xe lăn tự động"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("電動輪椅"),
            keywords: &["無障礙", "電動輪椅"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("电动轮椅"),
            keywords: &["无障碍", "电动轮椅"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("电动轮椅"),
            keywords: &["无障碍", "电动轮椅", "轮椅"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("電動輪椅"),
            keywords: &["行動不便", "電動輪椅"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("isitulo esizihambelayo"),
            keywords: &["isitulo esizihambelayo", "ukufinyelela"],
        },
    ],
};
#[doc = "🛺"]
pub const AUTO_RICKSHAW: crate::Emoji = crate::Emoji {
    glyph: "🛺",
    codepoint: "1F6FA",
    status: crate::Status::FullyQualified,
    introduction_version: 12f32,
    name: "auto rickshaw",
    group: "Travel & Places",
    subgroup: "transport-ground",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("outoriksja"),
            keywords: &["outoriksja", "toek-toek"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ራስሰር ሪክሻው"),
            keywords: &["ራስሰር ሪክሻው", "ባጃጅ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("توكتوك"),
            keywords: &["توك توك", "توكتوك"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("অট’ ৰিক\u{9cd}স\u{9be}"),
            keywords: &["অট’ ৰিক\u{9cd}স\u{9be}", "ট\u{9c1}ক ট\u{9c1}ক"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("avto-rikşa"),
            keywords: &["avto-rikşa", "tuk-tuk"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("аўтарыкша"),
            keywords: &["аўтарыкша", "тук-тук"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("авторикша"),
            keywords: &["авторикша", "тук тук"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("অটো রিক\u{9cd}স\u{9be}"),
            keywords: &["অটো রিক\u{9cd}স\u{9be}", "ট\u{9c1}ক ট\u{9c1}ক"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("auto-rikša"),
            keywords: &["auto-rikša", "tuk-tuk vozilo"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("bicitaxi amb motor"),
            keywords: &["bicitaxi", "bicitaxi amb motor", "rickshaw"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏂᎩᏍᏗᏍᎩ ᏓᏆᎴᎷ ᎢᏳᏍᏗ"),
            keywords: &["ᎠᏂᎩᏍᏗᏍᎩ ᏓᏆᎴᎷ ᎢᏳᏍᏗ", "ᏛᎩ ᏛᎩ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("autorikša"),
            keywords: &["autorikša", "tuk-tuk"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("ricshio â pheiriant"),
            keywords: &["ricshio â pheiriant", "twc twc"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("motor-rickshaw"),
            keywords: &["motor-rickshaw", "tuk tuk"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Autorikscha"),
            keywords: &["Autorikscha", "Tuk-Tuk"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ποδήλατο-ταξί"),
            keywords: &["ποδήλατο-ταξί"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("auto rickshaw"),
            keywords: &["auto rickshaw", "tuk tuk"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: None,
            keywords: &["auto rickshaw", "tuk tuk", "tuk-tuk"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["auto rickshaw", "tuk tuk", "tuk-tuk", "tuktuk"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["auto rickshaw", "tuk tuk", "tuk-tuk"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("mototaxi"),
            keywords: &["mototaxi", "rickshaw", "tuk tuk"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("autorikša"),
            keywords: &["autorikša", "tuk-tuk"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("rickshaw motorduna"),
            keywords: &["rickshaw motorduna", "tuk tuk"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("اتوریکشا"),
            keywords: &["اتوریکشا"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("autorikša"),
            keywords: &["autorikša", "tuktuk"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("auto rickshaw"),
            keywords: &["auto rickshaw", "tuk tuk"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("motor rickshaw"),
            keywords: &["motor rickshaw", "rickshaw", "tuk tuk"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("tuk tuk"),
            keywords: &["rickshaw", "taxi", "tricycle", "tuk tuk"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("ricseá uathoibríoch"),
            keywords: &["ricseá uathoibríoch", "tuc tuc"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("càr-rickshaw"),
            keywords: &["càr", "càr-rickshaw", "rickshaw", "tuk tuk"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("triciclo motorizado"),
            keywords: &[
                "motorizado",
                "mototaxi",
                "rickshaw",
                "triciclo motorizado",
                "tuk-tuk",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ઑટો રિક\u{acd}શા"),
            keywords: &["ઑટો રિક\u{acd}શા", "ટક ટક"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("ריקשה ממונעת"),
            keywords: &["טוק-טוק", "ריקשה ממונעת"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ऑटो रिक\u{94d}शा"),
            keywords: &["ऑटो रिक\u{94d}शा", "गाड\u{93c}ी", "रिक\u{94d}शा", "वाहन"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("rikša"),
            keywords: &["rikša", "tuk tuk"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("motoros riksa"),
            keywords: &["motoros riksa", "tuk tuk"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ավտոռիկշա"),
            keywords: &["ավտոռիկշա", "թըխկ-թըխկ", "ռիկշա", "տաքսի"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("bajaj"),
            keywords: &["bajaj", "tuk tuk"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("vélknúinn léttvagn"),
            keywords: &["túk-túk", "vélknúinn léttvagn"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("risciò a motore"),
            keywords: &["risciò a motore", "tuk tuk"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("三輪タクシー"),
            keywords: &[
                "オートリクシャー",
                "タクシー",
                "トゥクトゥク",
                "リクシャー",
                "三輪タクシー",
            ],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("bemo"),
            keywords: &["bemo", "bemo tuk tuk"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ავტორიქშა"),
            keywords: &["ავტორიქშა", "ელექტრო რიქშა", "მოტორიანი რიქშა", "მოტორიქშა"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("моторикша"),
            keywords: &["моторикша", "тук-тук"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some(
                "រ\u{17c9}\u{17ba}ម\u{17c9}កកង\u{17cb}ប\u{17b8}ដែល\u{200b}ប\u{17d2}រើម\u{17c9}ាស\u{17ca}\u{17b8}ន",
            ),
            keywords: &[
                "ត\u{17bb}ត\u{17bb}",
                "រ\u{17c9}\u{17ba}ម\u{17c9}កកង\u{17cb}ប\u{17b8}ដែល\u{200b}ប\u{17d2}រើម\u{17c9}ាស\u{17ca}\u{17b8}ន",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಆಟೋ ರ\u{cbf}ಕ\u{ccd}ಷಾ"),
            keywords: &["ಆಟೋ ರ\u{cbf}ಕ\u{ccd}ಷಾ", "ಟಕ\u{ccd} ಟಕ\u{ccd}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("경삼륜차"),
            keywords: &["경삼륜차", "툭툭"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("ऑटो रिक\u{94d}षा"),
            keywords: &["ऑटो रिक\u{94d}षा", "ट\u{941}क ट\u{941}क"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("авто рикша"),
            keywords: &["авто рикша", "тук тук"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ລ\u{ebb}ດ\u{200b}ລາກ\u{200b}ອ\u{eb1}ດ\u{200b}ຕະ\u{200b}ໂນ\u{200b}ມ\u{eb1}ດ"),
            keywords: &[
                "ລ\u{ebb}ດ\u{200b}ຕ\u{eb8}ກ\u{200b}ຕ\u{eb8}ກ",
                "ລ\u{ebb}ດ\u{200b}ລາກ\u{200b}ອ\u{eb1}ດ\u{200b}ຕະ\u{200b}ໂນ\u{200b}ມ\u{eb1}ດ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("autorikša"),
            keywords: &["autorikša", "tuk tuk"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("autorikša"),
            keywords: &["autorikša", "tuktuks"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("авто-рикша"),
            keywords: &["авто-рикша", "тук тук"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഓട\u{d4d}ടോറിക\u{d4d}ഷ"),
            keywords: &[
                "ഓട\u{d4d}ടോറിക\u{d4d}ഷ",
                "ടക\u{d4d}ക\u{d4d} ടക\u{d4d}ക\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("рикша"),
            keywords: &["рикша", "тук тук"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("ऑटो रिक\u{94d}षा"),
            keywords: &["ऑटो रिक\u{94d}षा", "ट\u{941}क ट\u{941}क"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("lanca auto"),
            keywords: &["lanca auto", "tuk tuk"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("သ\u{102f}\u{1036}းဘ\u{102e}း"),
            keywords: &[
                "တ\u{102f}တ\u{103a}တ\u{102f}တ\u{103a}",
                "သ\u{102f}\u{1036}းဘ\u{102e}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("autorickshaw"),
            keywords: &["autorickshaw", "mototaxi", "trehjuling", "tuk-tuk"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("अटो रिक\u{94d}सा"),
            keywords: &["अटो रिक\u{94d}सा", "ट\u{941}क ट\u{941}क"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("rik\u{ad}sja"),
            keywords: &["rik\u{ad}sja", "tuktuk"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("autorickshaw"),
            keywords: &["autorickshaw", "mototaxi", "trehjuling", "tuk-tuk"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଅଟୋ ର\u{b3f}କ\u{b4d}ସ\u{b3e}"),
            keywords: &["ଅଟୋ ର\u{b3f}କ\u{b4d}ସ\u{b3e}", "ଟ\u{b41}କ ଟ\u{b41}କ"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਆਟ\u{a4b} ਰਿਕਸ\u{a3c}ਾ"),
            keywords: &["ਆਟ\u{a4b} ਰਿਕਸ\u{a3c}ਾ", "ਟ\u{a41}ਕ ਟ\u{a41}ਕ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Kẹkẹ\u{301} Napẹp"),
            keywords: &["Kẹkẹ\u{301} Napẹp"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("autoriksza"),
            keywords: &["autoriksza", "tuk-tuk"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("آټو رکشه"),
            keywords: &["آټو رکشه", "ټک ټک"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("automóvel riquixá"),
            keywords: &["automóvel riquixá", "autorriquixá", "tuk tuk"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("riquexó motorizado"),
            keywords: &["riquexó motorizado"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("autoricșă"),
            keywords: &["autoricșă", "tuk tuk"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E12–009"),
            keywords: &["E12–009"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("авторикша"),
            keywords: &["авторикша", "мопед", "рикша", "такси", "тук-тук", "туктук"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("آٽو رڪشا"),
            keywords: &["آٽو رڪشا", "ٽڪ ٽڪ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ස\u{dca}වයං ර\u{dd2}ක\u{dca}ෂෝරථය"),
            keywords: &[
                "ත\u{dca}\u{200d}ර\u{dd3}ව\u{dd2}ලය",
                "ස\u{dca}වයං ර\u{dd2}ක\u{dca}ෂෝරථය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("autorikša"),
            keywords: &["autorikša", "motorikša", "tuk‑tuk"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("rikša z motorjem"),
            keywords: &["rikša z motorjem", "tuk tuk"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("jiide is-wada"),
            keywords: &["jiide is-wada", "tuk-tuk"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("autorikshë"),
            keywords: &["autorikshë", "karroceri me motor", "rikshë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("ауто рикша"),
            keywords: &["ауто рикша", "тук тук"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("ауто-рикша"),
            keywords: &["ауто-рикша"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("auto rikša"),
            keywords: &["auto rikša", "tuk tuk"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("auto-rikša"),
            keywords: &["auto-rikša"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("automatisk riksha"),
            keywords: &["automatisk riksha", "bilriksha", "motorriksha", "tuk-tuk"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("riksho"),
            keywords: &["riksho", "tuk tuk"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ஆட\u{bcd}டோ ரிக\u{bcd}\u{200c}ஷ\u{bbe}"),
            keywords: &[
                "ஆட\u{bcd}டோ",
                "ஆட\u{bcd}டோ ரிக\u{bcd}\u{200c}ஷ\u{bbe}",
                "மஞ\u{bcd}சள\u{bcd} ஆட\u{bcd}டோ",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ఆట\u{c4b} ర\u{c3f}క\u{c4d}ష\u{c3e}"),
            keywords: &["ఆట\u{c4b} ర\u{c3f}క\u{c4d}ష\u{c3e}", "టక\u{c4d} టక\u{c4d}"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("รถสามล\u{e49}อ"),
            keywords: &[
                "ต\u{e38}\u{e4a}กต\u{e38}\u{e4a}ก",
                "รถต\u{e38}\u{e4a}กต\u{e38}\u{e4a}ก",
                "รถสามล\u{e49}อ",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("awtorikşa"),
            keywords: &["awtorikşa", "tuktuk"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("loli siʻisiʻi"),
            keywords: &["loli siʻisiʻi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("elektrikli çekçek"),
            keywords: &["elektrikli çekçek", "tuk tuk"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("авторикша"),
            keywords: &["авторикша", "рикша", "тук-тук"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("آٹو رکشا"),
            keywords: &["آٹو رکشا", "ٹ\u{64f}ک ٹ\u{64f}ک"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("avtoriksha"),
            keywords: &["avtoriksha", "tuk tuk"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("xe lam"),
            keywords: &["tuk tuk", "túc túc", "xe lam"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("自動人力車"),
            keywords: &["篤篤", "自動人力車"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("自动人力车"),
            keywords: &["笃笃", "自动人力车"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("三轮摩托车"),
            keywords: &["三脚鸡", "三蹦子", "三轮摩托车", "嘟嘟车", "自动人力车"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("嘟嘟車"),
            keywords: &["嘟嘟車"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("篤篤車"),
            keywords: &["篤篤車"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("i-auto rickshaw"),
            keywords: &["i-auto rickshaw", "i-tuk tuk"],
        },
    ],
};
#[doc = "🚲"]
pub const BICYCLE: crate::Emoji = crate::Emoji {
    glyph: "🚲",
    codepoint: "1F6B2",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "bicycle",
    group: "Travel & Places",
    subgroup: "transport-ground",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("fiets"),
            keywords: &["fiets", "voertuig"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ብስክሌት"),
            keywords: &["ብስክሌት", "ተሽከርካሪ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("دراجة"),
            keywords: &["بسكلتة", "دراجة", "مركبة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ব\u{9be}ইচ\u{9be}ইকেল"),
            keywords: &["ব\u{9be}ইক", "ব\u{9be}ইচ\u{9be}ইকেল"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("velosiped"),
            keywords: &["nəqliyyat", "velosiped"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("веласіпед"),
            keywords: &["аіст", "веласіпед", "горнік", "ровар"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("велосипед"),
            keywords: &["велосипед", "колело", "превозно средство"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ব\u{9be}ইস\u{9be}ইকেল"),
            keywords: &["ব\u{9be}ইক", "ব\u{9be}ইস\u{9be}ইকেল", "য\u{9be}নব\u{9be}হন"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("biciklo"),
            keywords: &["bajk", "biciklo"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("bicicleta"),
            keywords: &["bici", "bicicleta", "vehicle"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏔᎵ ᏗᎦᏆᏘ ᎠᎩᎸᏙᏗ"),
            keywords: &["ᏔᎵ ᏗᎦᏆᏘ", "ᏔᎵ ᏗᎦᏆᏘ ᎠᎩᎸᏙᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("kolo"),
            keywords: &["bicykl", "kolo", "vozidlo"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("beic"),
            keywords: &["beic"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("cykel"),
            keywords: &["cykel", "tohjulet"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Fahrrad"),
            keywords: &["Fahrrad", "Rad"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ποδήλατο"),
            keywords: &["ποδήλατο", "όχημα"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("bicycle"),
            keywords: &["bicycle", "bike"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: None,
            keywords: &["bicycle", "bike", "cycle"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("bicicleta"),
            keywords: &["bici", "bicicleta", "vehículo"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["bici", "bicicleta", "transporte"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["bici", "bicicleta", "transporte"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("jalgratas"),
            keywords: &["jalgratas", "ratas", "sõiduk"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("ziklomotorra"),
            keywords: &["ibilgailu", "ziklomotor", "ziklomotorra"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("دوچرخه"),
            keywords: &["دوچرخه", "وسیله\u{654} نقلیه"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("polkupyörä"),
            keywords: &["ajoneuvo", "polkupyörä", "pyörä"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("bisikleta"),
            keywords: &["bicycle", "bike", "bisikleta", "sasakyan"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("súkkla"),
            keywords: &["súkkla"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("vélo"),
            keywords: &["vélo"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["bicyclette", "vélo"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("rothar"),
            keywords: &["bus", "feithicil", "rothar", "rothar glas"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("baidhseagal"),
            keywords: &["baic", "baidhg", "baidhseagal", "rothair"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("bicicleta"),
            keywords: &["bici", "bicicleta"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("બાઇસિકલ"),
            keywords: &["બાઇક", "બાઇસિકલ", "વાહન", "સાઇકલ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("keke"),
            keywords: &["keke"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("אופניים"),
            keywords: &["אופניים", "כלי רכב"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("बाइक, साइकिल"),
            keywords: &["बाइक", "बाइक, साइकिल", "वाहन", "साइकिल"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("bicikl"),
            keywords: &["bicikl", "vozilo"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("kerékpár"),
            keywords: &["bicikli", "jármű", "kerékpár"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("հեծանիվ"),
            keywords: &["հեծանիվ", "փոխադրամիջոց"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("sepeda"),
            keywords: &["kendaraan", "sepeda"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("igwe"),
            keywords: &["igwe", "ọgbaatumtum"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("hjólreiðar"),
            keywords: &["hjól", "hjólreiðar", "reiðhjól"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("bicicletta"),
            keywords: &["bicicletta", "veicolo"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("自転車"),
            keywords: &["乗り物", "自転車"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("sepedha"),
            keywords: &["pit", "sepedha"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ველოსიპედი"),
            keywords: &["ველოსიპედი", "ტრანსპორტი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("велосипед"),
            keywords: &["велосипед", "көлік"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("cykel"),
            keywords: &["cykel", "tohjulet"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("កង\u{17cb}"),
            keywords: &["កង\u{17cb}", "ទោចក\u{17d2}រយាន"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಬೈಸ\u{cbf}ಕಲ\u{ccd}"),
            keywords: &["ಬೈಕ\u{ccd}", "ಬೈಸ\u{cbf}ಕಲ\u{ccd}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("자전거"),
            keywords: &["교통수단", "바이크", "자전거"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("बायसिकल"),
            keywords: &["बायक", "बायसिकल"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("велосипед"),
            keywords: &["велосипед"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Vëlo"),
            keywords: &["Vëlo"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ລ\u{ebb}ດຖ\u{eb5}ບ"),
            keywords: &["ພາຫະນະ", "ລ\u{ebb}ດຖ\u{eb5}ບ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("dviratis"),
            keywords: &["dviratis", "transporto priemonė"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("velosipēds"),
            keywords: &["ritenis", "transports", "velosipēds"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pahikara"),
            keywords: &["pahikara"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("велосипед"),
            keywords: &["велосипед", "возило"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("സൈക\u{d4d}കിൾ"),
            keywords: &["വ\u{d3e}ഹനം", "സൈക\u{d4d}കിൾ"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("унадаг дугуй"),
            keywords: &["дугуй", "унадаг"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("सायकल"),
            keywords: &["द\u{941}चाकी", "सायकल"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("basikal"),
            keywords: &["basikal", "kenderaan"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("rota"),
            keywords: &["rota"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("စက\u{103a}ဘ\u{102e}း"),
            keywords: &["စက\u{103a}ဘ\u{102e}း"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("sykkel"),
            keywords: &["kjøretøy", "sykkel"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("साइकल"),
            keywords: &["गाडी", "बाइक", "साइकल"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("fiets"),
            keywords: &["fiets", "rijwiel"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("sykkel"),
            keywords: &["køyretøy", "sykkel"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ବ\u{b3e}ଇସ\u{b3e}ଇକେଲ\u{b4d}"),
            keywords: &["ବ\u{b3e}ଇକ\u{b4d}", "ବ\u{b3e}ଇସ\u{b3e}ଇକେଲ\u{b4d}"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਸਾਈਕਲ"),
            keywords: &["ਬਾਈਕ", "ਵਾਹਨ", "ਸਾਈਕਲ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("بائیسیکل"),
            keywords: &["بائیسیکل", "موٹر سائیکل"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Baísíkul"),
            keywords: &["Baik", "Baísíkul"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("rower"),
            keywords: &["pojazd", "rower", "rowerek"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("بايسکل"),
            keywords: &["بايسکل", "بايک"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("bicicleta"),
            keywords: &["bicicleta", "veículo"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["bicicleta", "bicla"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("bicicleta"),
            keywords: &["bici", "bicicleta"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("bicicletă"),
            keywords: &["bicicletă", "ciclism"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-966"),
            keywords: &["E10-966"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("велосипед"),
            keywords: &["велосипед", "колеса", "руль", "транспорт"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("igare"),
            keywords: &["igare"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("سائيڪل"),
            keywords: &["بائيڪ", "سائيڪل"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("බය\u{dd2}ස\u{dd2}කලය"),
            keywords: &["බය\u{dd2}ස\u{dd2}කලය", "ව\u{dcf}හනය"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("bicykel"),
            keywords: &["bicykel", "dopravný prostriedok"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("kolo"),
            keywords: &["kolo", "vozilo"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("baaskiil"),
            keywords: &["baaskiil", "bushkuleeti"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("biçikletë"),
            keywords: &["biçikletë", "mjet udhëtimi"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("бицикл"),
            keywords: &["бицикл", "вoзилo"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("bicikl"),
            keywords: &["bicikl", "vozilo"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("cykel"),
            keywords: &["cykel", "fordon"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("baisikeli"),
            keywords: &["baisikeli", "gari"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("சைக\u{bcd}கிள\u{bcd}"),
            keywords: &["சைக\u{bcd}கிள\u{bcd}", "சைக\u{bcd}கிள\u{bcd} வண\u{bcd}டி"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("స\u{c48}క\u{c3f}ల\u{c4d}"),
            keywords: &[
                "స\u{c48}క\u{c3f}ల\u{c4d}",
                "స\u{c48}క\u{c3f}ల\u{c4d}\u{200c}లకు మ\u{c3e}త\u{c4d}రమ\u{c47} అనుమత\u{c3f} ఉంద\u{c3f}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("дучарха"),
            keywords: &["велосипед", "дучарха"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("จ\u{e31}กรยาน"),
            keywords: &["จ\u{e31}กรยาน", "ยานพาหนะ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("welosiped"),
            keywords: &["tigir", "welosiped"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("pasikala"),
            keywords: &["pasikala"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("bisiklet"),
            keywords: &["bisiklet", "taşıt"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ۋېلىسىپىت"),
            keywords: &["ۋېلىسىپىت"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("велосипед"),
            keywords: &["велосипед", "транспорт"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("سائیکل"),
            keywords: &["سائیکل", "سواری"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("velosiped"),
            keywords: &["transport", "velosiped"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("xe đạp"),
            keywords: &["xe cộ", "xe đạp"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("welo"),
            keywords: &["welo"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ibhayisikile"),
            keywords: &["ibhayikhi", "ibhayisikile"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Kẹ\u{300}kẹ\u{301}"),
            keywords: &["Kẹ\u{300}kẹ\u{301}", "kẹ\u{300}kẹ\u{301}"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("單車"),
            keywords: &["單車"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("单车"),
            keywords: &["单车"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("自行车"),
            keywords: &["单车", "脚踏车", "自行车"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("自行車"),
            keywords: &["腳踏車", "自行車"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("單車"),
            keywords: &["單車", "腳踏車", "自行車"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ibhayisikili"),
            keywords: &["ibhayisikili", "isithuthi"],
        },
    ],
};
#[doc = "🛴"]
pub const KICK_SCOOTER: crate::Emoji = crate::Emoji {
    glyph: "🛴",
    codepoint: "1F6F4",
    status: crate::Status::FullyQualified,
    introduction_version: 3f32,
    name: "kick scooter",
    group: "Travel & Places",
    subgroup: "transport-ground",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("skopfiets"),
            keywords: &["skoeter", "skopfiets"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የግፊ ሳይክል"),
            keywords: &["መግፋት", "ሳይክል", "የግፊ ሳይክል"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("سكوتر بدون محرك"),
            keywords: &["ركل", "سكوتر", "سكوتر بدون محرك"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("কিক স\u{9cd}ক\u{9c1}ট\u{9be}ৰ"),
            keywords: &["কিক", "স\u{9cd}ক\u{9c1}ট\u{9be}ৰ"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("samokat"),
            keywords: &["samokat", "skuter"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("самакат"),
            keywords: &["самакат"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("тротинетка"),
            keywords: &["тротинетка"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("কিক স\u{9cd}ক\u{9c1}ট\u{9be}র"),
            keywords: &["কিক", "স\u{9cd}ক\u{9c1}ট\u{9be}র"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("troterez"),
            keywords: &["karbed", "troterez"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("romobil"),
            keywords: &["noga", "romobil"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("patinet"),
            keywords: &["patinet", "transport"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎦᏯᏂᏖᏍᏗ ᎠᎩᎸᏙᏗ"),
            keywords: &["ᎠᎩᎸᏙᏗ", "ᎦᏯᏂᏖᏍᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("koloběžka"),
            keywords: &["koloběžka"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("sgwter cicio"),
            keywords: &["cicio", "sgwter"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("løbehjul"),
            keywords: &["løbehjul", "transportmiddel"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Tretroller"),
            keywords: &["Tretroller"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("πατίνι"),
            keywords: &["πατίνι", "ποδοκίνητος"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("kick scooter"),
            keywords: &["kick", "scooter"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("patinete"),
            keywords: &["patinete"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("monopatín"),
            keywords: &["monopatín"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("patín del diablo"),
            keywords: &["patín del diablo"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("tõukeratas"),
            keywords: &["tõukekas", "tõukeratas"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("patinetea"),
            keywords: &["kick", "patinetea", "scooter"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("چرخ پایی"),
            keywords: &["اسباب\u{200c}بازی", "اسکوتر", "بازی", "روروک", "چرخ پایی"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("potkulauta"),
            keywords: &["lauta", "potku", "potkulauta"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("micro scooter"),
            keywords: &["micro scooter", "scooter"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("rennihjól"),
            keywords: &["løpihjul", "rennihjól"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("trottinette"),
            keywords: &["trottinette"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("scútar gan inneall"),
            keywords: &["leanbh", "scútar", "scútar gan inneall"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("sgùtair-breabaidh"),
            keywords: &["breabadh", "sgùtair", "sgùtair-breabaidh"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("patinete"),
            keywords: &["patinete", "patín", "xoguete"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("કિક સ\u{acd}ક\u{ac2}ટર"),
            keywords: &["કિક", "સ\u{acd}ક\u{ac2}ટર"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("sukuta na ƙafa"),
            keywords: &["na ƙafa", "sukuta", "sukuta na ƙafa"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("קורקינט"),
            keywords: &["קורקינט"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("किक स\u{94d}क\u{942}टर"),
            keywords: &["किक", "स\u{94d}क\u{942}टर"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("romobil"),
            keywords: &["noga", "romobil"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("roller"),
            keywords: &["roller"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ինքնագլոր"),
            keywords: &["ինքնագլոր", "սամոկատ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("otoped"),
            keywords: &["otoped", "skuter"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("igwe egwuregwu"),
            keywords: &["egwuregwu", "igwe"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("hlaupahjól"),
            keywords: &["hjól", "hlaupa", "hlaupahjól"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("monopattino"),
            keywords: &["monopattino"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("キックボード"),
            keywords: &["キックスクーター", "キックスケーター", "キックボード"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("otopet jejek"),
            keywords: &["jejek", "otopet"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ფეხის სკუტერი"),
            keywords: &["სკუტერი", "ფეხის კვრა", "ფეხის სკუტერი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("самокат"),
            keywords: &["велосипед", "самокат"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("løbehjul"),
            keywords: &["løbehjul", "transportmiddel"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("scooter អត\u{17cb}ម\u{17c9}ាស\u{17ca}\u{17b8}ន"),
            keywords: &[
                "scooter អត\u{17cb}ម\u{17c9}ាស\u{17ca}\u{17b8}ន",
                "ក\u{17bc}នកង\u{17cb}ធាក\u{17cb}",
                "ធាក\u{17cb}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕ\u{cbf}ಕ\u{ccd} ಸ\u{ccd}ಕ\u{cc2}ಟರ\u{ccd}"),
            keywords: &["ಕ\u{cbf}ಕ\u{ccd}", "ಸ\u{ccd}ಕ\u{cc2}ಟರ\u{ccd}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("킥보드"),
            keywords: &["씽씽카", "킥보드"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("किक स\u{94d}क\u{941}टर"),
            keywords: &["किक", "स\u{94d}क\u{941}टर"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("самокат"),
            keywords: &["самокат", "скутер"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Trottinette"),
            keywords: &["Trottinette", "stoussen"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ສະກ\u{eb9}ດເຕ\u{eb5}ແບບເຕະ"),
            keywords: &["ສະກ\u{eb9}ດເຕ\u{eb5}", "ສະກ\u{eb9}ດເຕ\u{eb5}ແບບເຕະ", "ເຕະ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("paspirtukas"),
            keywords: &["paspirtukas", "spirti"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("skuteris"),
            keywords: &["skuteris", "skuteris divritenis"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kuta whana"),
            keywords: &["kuta", "whana"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("тротинет"),
            keywords: &["тротинет"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("കിക\u{d4d}ക\u{d4d} സ\u{d4d}ക\u{d42}ട\u{d4d}ടർ"),
            keywords: &["കിക\u{d4d}ക\u{d4d}", "സ\u{d4d}ക\u{d42}ട\u{d4d}ടർ"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("самокат"),
            keywords: &["жийх", "самокат", "скүүтэр"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("किक स\u{94d}क\u{942}टर"),
            keywords: &["किक", "स\u{94d}क\u{942}टर"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("skuter tolak"),
            keywords: &["skuter", "tolak"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("scooter"),
            keywords: &["kick", "scooter"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("စက\u{1030}တာ"),
            keywords: &["ခြေကန\u{103a}နင\u{103a}းခြင\u{103a}း", "စက\u{1030}တာ"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("sparkesykkel"),
            keywords: &["spark", "sparkesykkel", "sykkel"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("किक स\u{94d}क\u{941}टर"),
            keywords: &["किक", "स\u{94d}क\u{941}टर"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("step"),
            keywords: &["autoped", "step", "steppen"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("sparkesykkel"),
            keywords: &["spark", "sparkesykkel", "sykkel"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("କ\u{b3f}କ\u{b4d}\u{200c} ସ\u{b4d}କ\u{b41}ଟର\u{b4d}\u{200c}"),
            keywords: &[
                "କ\u{b3f}କ\u{b4d}\u{200c}",
                "ସ\u{b4d}କ\u{b41}ଟର\u{b4d}\u{200c}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਕਿ\u{a71}ਕ ਸਕ\u{a42}ਟਰ"),
            keywords: &["ਕਿ\u{a71}ਕ ਸਕ\u{a42}ਟਰ", "ਲ\u{a71}ਤ", "ਸਕ\u{a42}ਟਰ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("کک سکوٹر"),
            keywords: &["سکوٹر", "لات مارنا", "کک سکوٹر"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Kík Skúta"),
            keywords: &["Kík", "Skúta"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("hulajnoga"),
            keywords: &["hulajnoga", "pojazd"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("کک سکوټر"),
            keywords: &["سکوټر", "کک"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("patinete"),
            keywords: &["brinquedo", "patinete"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("trotineta"),
            keywords: &["pontapé", "trotineta", "trotinete"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("patinador"),
            keywords: &["jayt’a", "patinador", "scooter"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("trotinetă"),
            keywords: &["scuter", "trotinetă"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1005"),
            keywords: &["E10-1005"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("самокат"),
            keywords: &["колеса", "руль", "самокат", "транспорт"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("moto y’umugeri"),
            keywords: &["moto", "y’umugeri"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڪڪ اسڪوٽر"),
            keywords: &["اسڪوٽر", "ڪڪ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("පෙඩල ස\u{dca}ක\u{dd6}ටරය"),
            keywords: &["පෙඩල ස\u{dca}ක\u{dd6}ටරය", "පෙඩලය", "ස\u{dca}ක\u{dd6}ටරය"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("kolobežka"),
            keywords: &["kolobežka"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("skiro"),
            keywords: &["poganjanje", "skiro"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("mooto laadid"),
            keywords: &["laad", "mooto", "mooto laadid"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("ballëz dyrrotëshe"),
            keywords: &["ballëz dyrrotëshe", "shtyrje me këmbë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("тротинет"),
            keywords: &["тротинет"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("trotinet"),
            keywords: &["trotinet"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("sparkcykel"),
            keywords: &["cykel", "sparka", "sparkcykel"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("skuta"),
            keywords: &["skuta"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("கிக\u{bcd} ஸ\u{bcd}கூட\u{bcd}டர\u{bcd}"),
            keywords: &["கிக\u{bcd}", "ஸ\u{bcd}கூட\u{bcd}டர\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("క\u{c3f}క\u{c4d} స\u{c4d}కూటర\u{c4d}"),
            keywords: &["క\u{c3f}క\u{c4d}", "స\u{c4d}కూటర\u{c4d}"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("самокат"),
            keywords: &["ба по задан", "самокат", "скутер"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("สก\u{e39}\u{e4a}ตเตอร\u{e4c}"),
            keywords: &["สก\u{e39}\u{e4a}ตเตอร\u{e4c}"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("depgili skuter"),
            keywords: &["depgili skuter", "depmek", "skuter"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("sikuta kauleka"),
            keywords: &["sikuta kauleka"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("ayakla sürülen skuter"),
            keywords: &["ayak", "ayakla sürülen skuter", "skuter"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("چاقلىق تېيىلغۇ"),
            keywords: &["توكسىكلىت", "تېيىلغۇ", "چاقلىق تېيىلغۇ"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("самокат"),
            keywords: &["самокат"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("کک سکوٹر"),
            keywords: &["سکوٹر", "کک"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("samokat"),
            keywords: &["samokat", "uchish"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("xe hẩy"),
            keywords: &["xe hẩy", "đẩy"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("welo benn tànk"),
            keywords: &["benn tànk", "welo", "welo benn tànk"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("isithuthuthu esikhatywayo"),
            keywords: &["isithuthu", "isithuthuthu esikhatywayo", "khaba"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("alupupu kekere"),
            keywords: &["Alupùpù ẹlẹ\u{301}sẹ\u{300} méjì", "alupupu kekere", "gbá"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("滑板車"),
            keywords: &["滑板車", "踢"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("滑板车"),
            keywords: &["滑板车", "踢"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("滑板车"),
            keywords: &["滑板车"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("滑板車"),
            keywords: &["滑板車", "滑行"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("isikuta esikhahlelwayo"),
            keywords: &["isikuta esikhahlelwayo", "isithuthuthu", "khahlela"],
        },
    ],
};
#[doc = "🛹"]
pub const SKATEBOARD: crate::Emoji = crate::Emoji {
    glyph: "🛹",
    codepoint: "1F6F9",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "skateboard",
    group: "Travel & Places",
    subgroup: "transport-ground",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("skaatsplank"),
            keywords: &["skaatsplank"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ስኬትቦርድ"),
            keywords: &["ስኬትቦርድ", "ቦርድ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("لوح التزلج"),
            keywords: &["لوح", "لوح التزلج"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("স\u{9cd}কেটব’ৰ\u{9cd}ড"),
            keywords: &["ব’ৰ\u{9cd}ড", "স\u{9cd}কেটব’ৰ\u{9cd}ড"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("skeytbord"),
            keywords: &["bord", "skeytbord"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("скейтборд"),
            keywords: &["дошка", "скейтборд"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("скейтборд"),
            keywords: &["дъска", "скейт", "скейтборд"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("স\u{9cd}কেটবোর\u{9cd}ড"),
            keywords: &["বোর\u{9cd}ড", "স\u{9cd}কেটবোর\u{9cd}ড"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("plankenn-ruilh"),
            keywords: &["plankenn", "plankenn-ruilh"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("skateboard"),
            keywords: &["daska", "skateboard"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("monopatí"),
            keywords: &["monopatí", "patí"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᎵᏲᏙᏗ ᏯᏖᎾ"),
            keywords: &["ᎠᎵᏲᏙᏗ ᏯᏖᎾ", "ᏯᏖᎾ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("skateboard"),
            keywords: &["prkno", "skateboard", "skejt"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("sgrialfwrdd"),
            keywords: &["bwrdd", "sgrialfwrdd"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("skateboard"),
            keywords: &["bræt", "skateboard"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Skateboard"),
            keywords: &["Skateboard", "Skateboard fahren"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("σκέιτμπορντ"),
            keywords: &["σανίδα", "σκέιτμπορντ"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("skateboard"),
            keywords: &["board", "skateboard"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("monopatín"),
            keywords: &["monopatín", "skateboard", "tabla"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("skateboard"),
            keywords: &["patineta", "skateboard", "tabla"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("patineta"),
            keywords: &["patineta", "skateboard", "tabla"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("patineta"),
            keywords: &["patineta"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("rula"),
            keywords: &["rula", "rulalaud"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("skateboard"),
            keywords: &["patinete", "skateboard"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("تخته\u{654} اسکیت"),
            keywords: &[
                "اسکیت\u{200c}بورد",
                "اسکیت\u{200c}سواری",
                "تخته",
                "تخته\u{654} اسکیت",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("rullalauta"),
            keywords: &["rullalauta", "skeittilauta"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("skateboard"),
            keywords: &["board", "skateboard"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("rennifjøl"),
            keywords: &[
                "akfjøl",
                "rennibretti",
                "rennifjøl",
                "rullibretti",
                "skateboard",
                "skoytufjøl",
                "skíðifjøl",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("planche à roulettes"),
            keywords: &[
                "glisse",
                "longboard",
                "planche à roulettes",
                "roulettes",
                "skateboard",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("clár scátála"),
            keywords: &["clár", "clár scátála"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("spèileabord"),
            keywords: &["bòrd", "spèileabord"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("monopatín"),
            keywords: &["monopatinaxe", "monopatín"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("સ\u{acd}ક\u{ac5}ટબોર\u{acd}ડ"),
            keywords: &["બૉર\u{acd}ડ", "સ\u{acd}ક\u{ac5}ટબોર\u{acd}ડ"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("סקייטבורד"),
            keywords: &["גלגשת", "סקטבורד", "סקייטבורד"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("स\u{94d}क\u{947}टबोर\u{94d}ड"),
            keywords: &["बोर\u{94d}ड", "स\u{94d}क\u{947}टबोर\u{94d}ड"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("skateboard"),
            keywords: &["skateboard"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("gördeszka"),
            keywords: &["deszka", "gördeszka"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("անվատախտակ"),
            keywords: &["անվատախտակ", "սքեյթ", "սքեյթբորդ", "տախտակ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("papan luncur"),
            keywords: &["papan", "papan luncur"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("hjólabretti"),
            keywords: &["bretti", "hjólabretti"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("skateboard"),
            keywords: &["skateboard", "tavola da skateboard"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("スケートボード"),
            keywords: &["スケボー", "スケートボード", "ボード"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("papan skate"),
  