#[doc = "🌑"]
pub const NEW_MOON: crate::Emoji = crate::Emoji {
    glyph: "🌑",
    codepoint: "1F311",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "new moon",
    group: "Travel & Places",
    subgroup: "sky & weather",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("nuwemaan"),
            keywords: &["donker", "maan", "nuwe", "nuwemaan", "ruimte", "weer"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("አዲስ ጨረቃ"),
            keywords: &["ህዋ", "አዲስ ጨረቃ", "የአየር ንብረት", "ጨለማ", "ጨረቃ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("محاق"),
            keywords: &["طقس", "فضاء", "قمر", "محاق", "معتم"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ন জোন"),
            keywords: &["আন\u{9cd}ধ\u{9be}ৰ", "চন\u{9cd}দ\u{9cd}ৰ", "ন জোন"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("yeni ay"),
            keywords: &["ay", "hava", "kosmos", "tünd", "yeni ay"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("маладзік"),
            keywords: &[
                "космас",
                "маладзік",
                "новы месяц",
                "ноч",
                "перакрой",
                "пусты месяц",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("новолуние"),
            keywords: &["време", "космос", "луна", "новолуние", "тъмен"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("আম\u{9be}বস\u{9cd}য\u{9be}"),
            keywords: &[
                "অন\u{9cd}ধক\u{9be}র",
                "আবহ\u{9be}ওয\u{9bc}\u{9be}",
                "আম\u{9be}বস\u{9cd}য\u{9be}",
                "চ\u{9be}\u{981}দ",
                "মহ\u{9be}ক\u{9be}শ",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("loar nevez"),
            keywords: &["loar", "loar nevez"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("mladi mjesec"),
            keywords: &["mjesec", "mjesečeve mijene", "mladi mjesec", "svemir"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("lluna nova"),
            keywords: &["fosc", "lluna", "nova"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎢᏤ ᏅᏓ ᎤᏒᎢ ᎡᎯ"),
            keywords: &["ᎢᏤ ᏅᏓ ᎤᏒᎢ ᎡᎯ", "ᎤᎵᏏᎩ", "ᏅᏓ ᎤᏒᎢ ᎡᎯ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("měsíc v novu"),
            keywords: &[
                "fáze měsíce",
                "měsíc",
                "měsíc v novu",
                "nov",
                "novoluní",
                "nový",
                "tma",
                "vesmír",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("lleuad newydd"),
            keywords: &["gofod", "lleuad", "lleuad newydd", "tywydd", "tywyllwch"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("nymåne"),
            keywords: &["måne", "månefase", "nymåne"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Neumond"),
            keywords: &["Mond", "Neumond"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("νέα σελήνη"),
            keywords: &["διάστημα", "καιρός", "νέα σελήνη", "σκοτάδι", "φεγγάρι"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("new moon"),
            keywords: &["dark", "moon", "new moon"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("luna nueva"),
            keywords: &["luna", "luna nueva", "oscuridad"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["clima", "espacio", "luna", "negra", "nueva"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &[
                "espacio",
                "fase lunar",
                "luna",
                "luna nueva",
                "negra",
                "nuev",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["luna", "luna nueva", "oscuridad", "oscuro"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("noorkuu"),
            keywords: &["ilm", "kosmos", "kuu", "noorkuu", "pime"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("ilargi berria"),
            keywords: &["eguraldi", "espazio", "ilargi", "ilargi berria", "ilun"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("ماه نو"),
            keywords: &["آب\u{200c}وهوا", "تاریک", "فضا", "ماه", "ماه نو"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("uusikuu"),
            keywords: &["kuu", "pimeä", "sää", "taivaankappale", "uusikuu"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("new moon"),
            keywords: &["buwan", "kalawakan", "madilim", "new moon"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("nýmáni"),
            keywords: &["máni", "nýmáni"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("nouvelle lune"),
            keywords: &["lune", "nouvelle lune"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["lune", "nouvelle"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("gealach úr"),
            keywords: &["dorcha", "duibhré", "gealach", "úr"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("gealach ùr"),
            keywords: &["dorch", "gealach", "ùr"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("lúa nova"),
            keywords: &["lúa", "nova", "novilunio"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("પ\u{acd}રતિપદાનો ચ\u{a82}દ\u{acd}ર"),
            keywords: &[
                "અમાસ",
                "ચ\u{a82}દ\u{acd}ર",
                "ડાર\u{acd}ક",
                "નવો",
                "પ\u{acd}રતિપદાનો ચ\u{a82}દ\u{acd}ર",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("sabon wata"),
            keywords: &["duhu", "sabon wata", "wata"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("ירח חדש"),
            keywords: &["חלל", "חשוך", "ירח", "ירח חדש"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("नया चा\u{901}द"),
            keywords: &["गहरा", "चा\u{901}द", "नया"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("mlađak"),
            keywords: &["mjesec", "mlađak", "mrak", "svemir", "vrijeme"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("újhold"),
            keywords: &["hold", "holdfázisok", "sötétség", "ég", "újhold"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("նորալուսին"),
            keywords: &["եղանակ", "լուսին", "մութ", "նորալուսին", "տիեզերք"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("bulan baru"),
            keywords: &["angkasa", "bulan", "bulan baru", "cuaca", "gelap"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ọnwa ọhụrụ"),
            keywords: &["ojii", "ọnwa", "ọnwa ọhụrụ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("nýtt tungl"),
            keywords: &["dökkt", "máni", "nýr máni", "nýtt", "tungl"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("luna nuova"),
            keywords: &["luna", "novilunio", "nuova"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("新月"),
            keywords: &["新月", "月"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("bulan kawitan"),
            keywords: &["bulan", "bulan kawitan", "peteng"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ახალი მთვარე"),
            keywords: &["ამინდი", "ახალი მთვარე", "კოსმოსი", "მთვარე", "მუქი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("жаңа ай"),
            keywords: &["ай", "ауа райы", "жаңа ай", "ғарыш", "қараңғы"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("nymåne"),
            keywords: &["måne", "månefase", "nymåne"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ព\u{17d2}រះច\u{17d0}ន\u{17d2}ទថ\u{17d2}ម\u{17b8}"),
            keywords: &[
                "ងង\u{17b9}ត",
                "ព\u{17d2}រះច\u{17d0}ន\u{17d2}ទថ\u{17d2}ម\u{17b8}",
                "យប\u{17cb}",
                "អាកាសធាត\u{17bb}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಅಮಾವಾಸ\u{ccd}ಯ\u{cc6}"),
            keywords: &[
                "ಅಮಾವಾಸ\u{ccd}ಯ\u{cc6}",
                "ಕತ\u{ccd}ತಲು",
                "ಚಂದ\u{ccd}ರ",
                "ಹೊಸದು",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("삭"),
            keywords: &["그믐", "그믐달", "뉴문", "달", "삭", "초승달"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("अमास"),
            keywords: &["अमास", "उमास", "काळोख"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("жаңырган ай"),
            keywords: &["ай", "жаңырган ай", "караңгы"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Neimound"),
            keywords: &["Mound", "Neimound", "däischter"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເດ\u{eb7}ອນດ\u{eb1}ບ"),
            keywords: &["ມ\u{eb7}ດ", "ເດ\u{eb7}ອນດ\u{eb1}ບ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("jaunas mėnulis"),
            keywords: &["jaunas mėnulis", "mėnulis", "tamsa"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("jauns mēness"),
            keywords: &["jauns mēness", "mēness", "tumšs"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("marama kōhiti"),
            keywords: &["marama", "marama kōhiti", "pōuri"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("млада месечина"),
            keywords: &["време", "вселена", "месечина", "млада"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("അമ\u{d3e}വ\u{d3e}സി"),
            keywords: &[
                "അമ\u{d3e}വ\u{d3e}സി",
                "കറ\u{d41}ത\u{d4d}ത ചന\u{d4d}ദ\u{d4d}രൻ",
                "കറ\u{d41}ത\u{d4d}തവ\u{d3e}വ\u{d4d}",
                "ചന\u{d4d}ദ\u{d4d}രൻ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("шинэ сар"),
            keywords: &["одон гариг", "сар", "цаг агаар", "шинэ"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("अमावस\u{94d}या"),
            keywords: &["अमावस\u{94d}या", "गडद", "च\u{902}द\u{94d}र"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("bulan baharu"),
            keywords: &["angkasa lepas", "bulan", "bulan baharu", "cuaca", "gelap"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("qamar ġdid"),
            keywords: &["qamar", "qamar ġdid", "skur"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("လက\u{103d}ယ\u{103a}"),
            keywords: &[
                "မ\u{103e}ောင\u{103a}မည\u{103a}း",
                "လ",
                "လက\u{103d}ယ\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("nymåne"),
            keywords: &["måne", "mørk", "nymåne"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("औ\u{902}सी"),
            keywords: &[
                "अ\u{901}ध\u{94d}यारो",
                "आकाशग\u{902}गा",
                "औ\u{902}सी",
                "चन\u{94d}द\u{94d}रमा",
                "मौसम",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("nieuwe maan"),
            keywords: &["donker", "maan", "nieuwe maan"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("nymåne"),
            keywords: &["måne", "mørk", "nymåne"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ନ\u{b42}ଆ ଚନ\u{b4d}ଦ\u{b4d}ର"),
            keywords: &[
                "ଅମବ\u{b3e}ସ\u{b4d}ୟ\u{b3e}",
                "ଗ\u{b3e}ଢ\u{b3c}",
                "ଚନ\u{b4d}ଦ\u{b4d}ର",
                "ନ\u{b42}ଆ ଚନ\u{b4d}ଦ\u{b4d}ର",
                "ନ\u{b42}ତନ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਨਵਾ\u{a02} ਚ\u{a70}ਦ"),
            keywords: &[
                "ਚ\u{a70}ਦ",
                "ਨਵਾ\u{a02}",
                "ਪ\u{a41}ਲਾੜ",
                "ਮ\u{a4c}ਸਮ",
                "ਹਨ\u{a47}ਰਾ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("نواں چاند"),
            keywords: &["نواں چاند", "چاند", "ہنیرا"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Níu Mun"),
            keywords: &["Dak", "Mun", "Niú Mun", "Níu Mun"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("nów"),
            keywords: &["ciemny księżyc", "nów"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("نوې سپوږمۍ"),
            keywords: &["تياره", "سپوږمۍ", "نوې سپوږمۍ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("lua nova"),
            keywords: &["escuro", "lua", "lua negra", "nova"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["escuro", "espaço", "lua", "lua nova", "meteorologia"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("unu Killa"),
            keywords: &["killa", "tuta", "unu Killa"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("lună nouă"),
            keywords: &["lună", "lună nouă", "întuneric"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-216"),
            keywords: &["E10-216"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("новолуние"),
            keywords: &["луна", "месяц", "новая луна", "новолуние", "темная ночь"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ukwezi gushya"),
            keywords: &["kijimye", "ukwezi", "ukwezi gushya"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("نئون چنڊ"),
            keywords: &["اونداهو", "نئون چنڊ", "چنڊ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("නව සඳ"),
            keywords: &[
                "අඳ\u{dd4}ර\u{dd4}",
                "අභ\u{dca}\u{200d}යවක\u{dcf}ශය",
                "ක\u{dcf}ලග\u{dd4}ණය",
                "නව සඳ",
                "සඳ",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("nov"),
            keywords: &["mesiac", "nov", "počasie", "tmavý", "vesmír"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("mlada luna"),
            keywords: &["luna", "mlada luna", "tema", "vesolje", "vreme"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("dayaxa cusub"),
            keywords: &["dayax", "dayaxa cusub", "madoow"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("hëna e re"),
            keywords: &["e errët", "hapësirë", "hëna e re", "hënë", "moti"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("млад месец"),
            keywords: &["месец", "млад месец", "мрaк"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("млад мјесец"),
            keywords: &["млад мјесец"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("mlad mesec"),
            keywords: &["mesec", "mlad mesec", "mrak"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("mlad mjesec"),
            keywords: &["mlad mjesec"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("nymåne"),
            keywords: &["måne", "nymåne"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mwezi mpya"),
            keywords: &["anga", "hali ya hewa", "mwezi", "mwezi mpya", "nyeusi"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("அம\u{bbe}வசை"),
            keywords: &["அம\u{bbe}வசை", "இரவு", "இருள\u{bcd}", "நில\u{bbe}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("అమ\u{c3e}వ\u{c3e}స\u{c4d}య"),
            keywords: &["అమ\u{c3e}వ\u{c3e}స\u{c4d}య", "చంద\u{c4d}రుడు"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("моҳи нав"),
            keywords: &["моҳ", "моҳи нав", "торик"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("จ\u{e31}นทร\u{e4c}ด\u{e31}บ"),
            keywords: &[
                "จ\u{e31}นทร\u{e4c}ด\u{e31}บ",
                "จ\u{e31}นทร\u{e4c}ม\u{e37}ด",
                "ม\u{e37}ด",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("täze aý"),
            keywords: &["aý", "garaňky", "täze aý"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("mate ʻae māhina"),
            keywords: &["mate ʻae māhina"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("yeni ay"),
            keywords: &["ay", "karanlık", "yeni"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("يېڭى ئاي"),
            keywords: &["ئاي", "قاراڭغۇ", "يېڭى ئاي"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("молодий місяць"),
            keywords: &["космос", "молодий місяць", "місяць", "погода", "темний"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("نیا چاند"),
            keywords: &["سیاہ", "موسم", "نیا چاند", "چاند"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("yangi oy"),
            keywords: &["koinot", "ob-havo", "oy", "qora", "yangi oy"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("trăng non"),
            keywords: &["bóng tối", "mặt trăng", "trăng non"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("weer wu bees"),
            keywords: &["lëndëm", "moon", "weer wu bees"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("inyanga entsha"),
            keywords: &["inyanga", "inyanga entsha", "mnyama"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Òṣùpá Tuntun"),
            keywords: &["dúdú", "Òṣùpá Tuntun", "òṣùpá"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("新月"),
            keywords: &["新月", "月亮", "黑暗"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("新月"),
            keywords: &["新月", "月亮", "黑暗"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("朔月"),
            keywords: &["新月", "月亮", "朔月"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("新月"),
            keywords: &["新月", "月亮", "朔月"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["新月", "月亮"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("inyanga entsha"),
            keywords: &[
                "inyanga",
                "inyanga entsha",
                "isimo sezulu",
                "ubumnyama",
                "umkhathi",
            ],
        },
    ],
};
#[doc = "🌒"]
pub const WAXING_CRESCENT_MOON: crate::Emoji = crate::Emoji {
    glyph: "🌒",
    codepoint: "1F312",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "waxing crescent moon",
    group: "Travel & Places",
    subgroup: "sky & weather",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("groeiende sekelmaan"),
            keywords: &[
                "groei",
                "groeiende sekelmaan",
                "maan",
                "ruimte",
                "sekel",
                "weer",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ትንሽ የበራች ግማሽ ጨረቃ"),
            keywords: &["ህዋ", "ትንሽ የበራች ግማሽ ጨረቃ", "የበራች", "የአየር ንብረት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("هلال بداية الشهر"),
            keywords: &["طقس", "فضاء", "قمر", "هلال", "هلال بداية الشهر"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("বৰ\u{9cd}দ\u{9cd}ধিত অৰ\u{9cd}দ\u{9cd}ধচন\u{9cd}দ\u{9cd}ৰ"),
            keywords: &[
                "চন\u{9cd}দ\u{9cd}ৰ",
                "বৰ\u{9cd}দ\u{9cd}ধিত",
                "বৰ\u{9cd}দ\u{9cd}ধিত অৰ\u{9cd}দ\u{9cd}ধচন\u{9cd}দ\u{9cd}ৰ",
                "ৱেক\u{9cd}সিং",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("dörddə bir aypara"),
            keywords: &[
                "ay",
                "aypara",
                "dörddə bir",
                "dörddə bir aypara",
                "hava",
                "kosmos",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("рост сярпа"),
            keywords: &[
                "космас",
                "маладзік",
                "месяц",
                "неаменія",
                "ноч",
                "рост сярпа",
                "серп",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("нарастващ полумесец на Луната"),
            keywords: &[
                "космос",
                "луна",
                "нарастващ",
                "нарастващ полумесец на Луната",
                "полумесец",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ব\u{9c3}দ\u{9cd}ধিপ\u{9cd}র\u{9be}প\u{9cd}ত অর\u{9cd}ধচন\u{9cd}দ\u{9cd}র"),
            keywords: &[
                "অর\u{9cd}ধচন\u{9cd}দ\u{9cd}র",
                "আবহ\u{9be}ওয\u{9bc}\u{9be}",
                "ওয\u{9bc}\u{9be}ক\u{9cd}সিং",
                "চ\u{9be}\u{981}দ",
                "ব\u{9c3}দ\u{9cd}ধিপ\u{9cd}র\u{9be}প\u{9cd}ত অর\u{9cd}ধচন\u{9cd}দ\u{9cd}র",
                "মহ\u{9be}ক\u{9be}শ",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("loar vihan ar cʼhresk"),
            keywords: &["loar", "loar vihan ar cʼhresk"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("uzdižući mjesec"),
            keywords: &["mjesec", "mjesečeve mijene", "uzdižući mjesec"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("lluna en quart creixent"),
            keywords: &["creixent", "lluna", "lluna en quart creixent", "quart"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎣᏂ ᏣᎢᏐ ᏅᏓ ᎤᏒ ᎡᎯ"),
            keywords: &["ᎠᏓᏲᎲ", "ᎠᏲᎶᎦ ᎠᎦᏍᎦᏂ", "ᎣᏂ ᏣᎢᏐ ᏅᏓ ᎤᏒ ᎡᎯ", "ᏅᏓ ᎤᏒ ᎡᎯ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("dorůstající měsíc po novoluní"),
            keywords: &[
                "dorůstající",
                "dorůstající měsíc po novoluní",
                "dorůstá",
                "fáze měsíce",
                "měsíc",
                "srpek",
                "vesmír",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("lleuad gilgant ar ei chynnydd"),
            keywords: &[
                "cilgant",
                "cwyro",
                "gofod",
                "lleuad",
                "lleuad gilgant ar ei chynnydd",
                "lleuad gilgant ar ei mesurydd",
                "tywydd",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("tiltagende måne"),
            keywords: &["måne", "månefase", "tiltagende måne"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("erstes Mondviertel"),
            keywords: &["Mond", "erstes Mondviertel", "zunehmend"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("αύξων μηνίσκος"),
            keywords: &["αύξων", "διάστημα", "καιρός", "μηνίσκος", "φεγγάρι"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("waxing crescent moon"),
            keywords: &["crescent", "moon", "waxing"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("luna creciente"),
            keywords: &["creciente", "cuarto", "espacio", "luna"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("luna nueva visible"),
            keywords: &["clima", "creciente", "espacio", "luna", "nueva", "visible"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["creciente", "espacio", "luna", "nueva", "visible"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["creciente", "luna", "luna nueva visible"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kasvav kuusirp"),
            keywords: &["ilm", "kasvav kuusirp", "kosmos", "kuu", "noorkuu", "sirp"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("ilgora"),
            keywords: &["ilargia", "ilgora"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("هلال فزاینده ماه"),
            keywords: &[
                "آب\u{200c}وهوا",
                "رو به بدر",
                "سوی ماه تمام",
                "فضا",
                "ماه",
                "هلال",
                "هلال فزاینده ماه",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kasvava kuunsirppi"),
            keywords: &[
                "kasvava",
                "kasvava kuunsirppi",
                "kuu",
                "sirppi",
                "sää",
                "taivaankappale",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("waxing crescent moon"),
            keywords: &[
                "buwan",
                "crescent",
                "kalawakan",
                "waxing",
                "waxing crescent moon",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("lítil vaksandi hálvmáni"),
            keywords: &["hálvmáni", "lítil vaksandi hálvmáni", "máni", "vaksandi"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("lune croissante"),
            keywords: &["lune", "lune croissante"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("premier croissant de lune"),
            keywords: &["lune", "premier croissant", "premier croissant de lune"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("corrán gealaí atá ag líonadh"),
            keywords: &[
                "corrán gealaí",
                "corrán gealaí ag dul ar gcúl",
                "corrán gealaí atá ag líonadh",
                "gealach ag líonadh",
                "gealach ag teacht ann",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("gealach chorranach a’ cinntinn"),
            keywords: &[
                "cinntinn",
                "corranach",
                "fàs",
                "gealach",
                "gealach chorranach a’ cinntinn",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("lúa nova visible"),
            keywords: &["lúa", "nova", "visible"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("બીજનો ચ\u{a82}દ\u{acd}ર"),
            keywords: &[
                "ચ\u{a82}દ\u{acd}ર",
                "બીજ",
                "બીજનો ચ\u{a82}દ\u{acd}ર",
                "વધતો",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("hilalin wata mai ƙaruwa"),
            keywords: &[
                "hilalin wata",
                "hilalin wata mai ƙaruwa",
                "mai ƙaruwa",
                "wata",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("סהר ירח מתמלא"),
            keywords: &["חלל", "ירח", "סהר", "סהר ירח מתמלא"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("द\u{942}ज का चा\u{901}द"),
            keywords: &[
                "चा\u{901}द",
                "द\u{942}ज का चा\u{901}द",
                "नवच\u{902}द\u{94d}र",
                "बालच\u{902}द\u{94d}र",
                "वर\u{94d}धमान",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("polumjesec prve četvrti"),
            keywords: &[
                "mjesec",
                "polumjesec",
                "polumjesec prve četvrti",
                "rast",
                "svemir",
                "vrijeme",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("növő, sarló alakú hold"),
            keywords: &[
                "holdfázisok",
                "növő hold",
                "növő, sarló alakú hold",
                "sarló",
                "ég",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("աճող մահիկ"),
            keywords: &["աճող", "եղանակ", "լուսին", "մահիկ", "տիեզերք"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("bulan sabit awal"),
            keywords: &[
                "angkasa",
                "bulan",
                "bulan sabit awal",
                "cuaca",
                "membesar",
                "sabit",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("imelite ọnwa gburu uhie"),
            keywords: &["gburu uhie", "imelite ọnwa gburu uhie", "mmelite", "ọnwa"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("vaxandi tungl (minna en hálft)"),
            keywords: &[
                "mánasigð",
                "máni",
                "tungl",
                "vaxandi",
                "vaxandi tungl (minna en hálft)",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("luna crescente"),
            keywords: &["crescente", "luna"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("初月"),
            keywords: &["三日月", "初月", "月"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("bulan tanggal sepisan"),
            keywords: &[
                "bulan",
                "bulan tanggal sepisan",
                "padhange nambah sithik-sithik",
                "tanggal sepisan",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მზარდი ნამგალა მთვარე"),
            keywords: &["ამინდი", "კოსმოსი", "მზარდი", "მთვარე", "ნამგალა"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("толып жатқан жарты ай"),
            keywords: &[
                "ай",
                "ауа райы",
                "жарты ай",
                "толып жатқан жарты ай",
                "толысып жатқан",
                "ғарыш",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("tiltagende måne"),
            keywords: &["måne", "månefase", "tiltagende måne"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some(
                "ព\u{17d2}រះចន\u{17d2}ទបង\u{17d2}ហាញខ\u{17d2}ល\u{17bd}នម\u{17bd}យច\u{17c6}ន\u{17b7}ត",
            ),
            keywords: &[
                "ខ\u{17d2}នើត",
                "ព\u{17d2}រះចន\u{17d2}ទ",
                "ព\u{17d2}រះចន\u{17d2}ទបង\u{17d2}ហាញខ\u{17d2}ល\u{17bd}នម\u{17bd}យច\u{17c6}ន\u{17b7}ត",
                "អឌ\u{17d2}ឍចន\u{17d2}ទ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಅರ\u{ccd}ಧ ಚಂದ\u{ccd}ರ"),
            keywords: &[
                "ಅರ\u{ccd}ಧ ಚಂದ\u{ccd}ರ",
                "ಕ\u{ccd}ರ\u{cc6}ಸ\u{cc6}ಂಟ\u{ccd}",
                "ಚಂದ\u{ccd}ರ",
                "ಮೇಣ",
                "ಮೇಣದ ಚಂದ\u{ccd}ರ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("초승달 상현"),
            keywords: &["달", "상현", "상현달", "초승달 상현"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("वाडट\u{94d}या च\u{902}द\u{94d}रकळ\u{947}ची च\u{902}द\u{94d}रकोर"),
            keywords: &[
                "च\u{902}द\u{94d}र",
                "च\u{902}द\u{94d}रकोर",
                "वाडटी च\u{902}द\u{94d}रकळा",
                "वाडट\u{94d}या च\u{902}द\u{94d}रकळ\u{947}ची च\u{902}द\u{94d}रकोर",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("толуп баштаган ай"),
            keywords: &["аба ырайы", "ай", "космос", "толуп баштаган ай", "толуу"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Séchelmound am éischte Véierel"),
            keywords: &[
                "Mound",
                "Séchelmound",
                "Séchelmound am éischte Véierel",
                "éischte Véierel",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເດ\u{eb7}ອນແຮມອອກໃໝ\u{ec8}"),
            keywords: &[
                "ເດ\u{eb7}ອນສ\u{ec9}ຽວ",
                "ເດ\u{eb7}ອນແຮມ",
                "ເດ\u{eb7}ອນແຮມອອກໃໝ\u{ec8}",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("priešpilnis mėnulis"),
            keywords: &["mėnulis", "priešpilnis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("augoša mēness sirpis"),
            keywords: &["augoša mēness sirpis", "augošs", "mēness", "sirpis"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("marama hua tipihori"),
            keywords: &["hua", "marama", "marama hua tipihori", "pewa"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("прва фаза - новина"),
            keywords: &["месечина", "новина", "прва фаза - новина"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some(
                "പ\u{d42}ർണ\u{d4d}ണത പ\u{d4d}ര\u{d3e}പിക\u{d4d}ക\u{d41}ന\u{d4d}ന ചന\u{d4d}ദ\u{d4d}രക\u{d4d}കല",
            ),
            keywords: &[
                "ചന\u{d4d}ദ\u{d4d}രക\u{d4d}കല",
                "ചന\u{d4d}ദ\u{d4d}രൻ",
                "പ\u{d42}ർണ\u{d4d}ണത പ\u{d4d}ര\u{d3e}പിക\u{d4d}ക\u{d41}ന\u{d4d}ന ചന\u{d4d}ദ\u{d4d}രക\u{d4d}കല",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("хавирган сар (баруун)"),
            keywords: &["сар", "хавирган сар", "хавирган сар (баруун)"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some(
                "अर\u{94d}ध\u{94d}\u{200d}याप\u{947}क\u{94d}षा कमी प\u{94d}रकाशित असल\u{947}ला च\u{902}द\u{94d}राचा भाग",
            ),
            keywords: &[
                "अर\u{94d}ध\u{94d}\u{200d}याप\u{947}क\u{94d}षा कमी प\u{94d}रकाशित असल\u{947}ला च\u{902}द\u{94d}राचा भाग",
                "च\u{902}द\u{94d}र",
                "च\u{902}द\u{94d}रकोर",
                "वाढणारा",
                "वाढणारी च\u{902}द\u{94d}रकोर",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("bulan sabit membesar"),
            keywords: &[
                "angkasa lepas",
                "bulan",
                "bulan sabit",
                "bulan sabit membesar",
                "cuaca",
                "membesar",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("felli qamar qed jikber"),
            keywords: &["felli", "felli qamar qed jikber", "qamar", "qed jikber"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("လဆန\u{103a}းရက\u{103a}"),
            keywords: &["လ", "လခြမ\u{103a}း", "လဆန\u{103a}းရက\u{103a}"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("voksende nymåne"),
            keywords: &["måne", "månefase", "ny", "voksende", "voksende nymåne"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("बढ\u{94d}दो चन\u{94d}द\u{94d}रमा"),
            keywords: &[
                "अर\u{94d}धचन\u{94d}द\u{94d}र",
                "चन\u{94d}द\u{94d}रमा",
                "बढ\u{94d}दो",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("jonge maansikkel"),
            keywords: &["jonge maansikkel", "maan", "sikkel", "wassend"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("veksande nymåne"),
            keywords: &["måne", "månefase", "ny", "veksande", "veksande nymåne"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some(
                "ବ\u{b43}ହତ\u{b4d}ତର ହେଉଥ\u{b3f}ବ\u{b3e} କ\u{b43}ସେଣ\u{b4d}ଟ\u{b4d} ଚନ\u{b4d}ଦ\u{b4d}ର",
            ),
            keywords: &[
                "ଅପ\u{b42}ର\u{b4d}ଣ\u{b4d}ଣଚନ\u{b4d}ଦ\u{b4d}ର",
                "ଚନ\u{b4d}ଦ\u{b4d}ର",
                "ବଢ\u{b3c}ନ\u{b4d}ତ\u{b3e}",
                "ବ\u{b43}ହତ\u{b4d}ତର ହେଉଥ\u{b3f}ବ\u{b3e} କ\u{b43}ସେଣ\u{b4d}ଟ\u{b4d} ଚନ\u{b4d}ଦ\u{b4d}ର",
                "ୱେକ\u{b4d}ସ\u{b3f}ଂ କ\u{b4d}ରେସେଣ\u{b4d}ଟ ମ\u{b41}ନ\u{b4d}\u{200c}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਵ\u{a71}ਧਦਾ ਚ\u{a70}ਦ"),
            keywords: &[
                "ਅ\u{a71}ਧਾ",
                "ਚ\u{a70}ਦ",
                "ਪ\u{a41}ਲਾੜ",
                "ਮ\u{a4c}ਸਮ",
                "ਵ\u{a71}ਧਦਾ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("نشوونما پاندا ہلالی چاند"),
            keywords: &["نشوونما پاندا ہلالی چاند", "ویکسنگ", "چاند", "ہلال"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Mun Im Braít Pat Jọ\u{301}s Stát To Bíg Mọ\u{301} Mọ"),
            keywords: &[
                "Fọ Mun To Gẹ\u{301}t Bíg Mọ\u{301} Mọ",
                "Kọ\u{301}v Shep",
                "Mun",
                "Mun Im Braít Pat",
                "Mun Im Braít Pat Jọ\u{301}s Stát To Bíg Mọ\u{301} Mọ",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("narastający półksiężyc"),
            keywords: &[
                "cieniutki księżyc",
                "księżyc",
                "narastający półksiężyc",
                "sierp",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("رغېدونکې هلال سپوږمۍ"),
            keywords: &["رغېدونکې", "سپوږمۍ", "هلال"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("lua crescente côncava"),
            keywords: &["crescente", "côncava", "lua"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("lua na primeira falcada"),
            keywords: &[
                "crescente",
                "espaço",
                "lua",
                "lua na primeira falcada",
                "meteorologia",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("tukuspa chawpi killa"),
            keywords: &["chawpi", "killa", "tukuspa"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("lună concavă în creștere"),
            keywords: &[
                "concavă",
                "creștere",
                "lună",
                "lună concavă în creștere",
                "semilună",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-217"),
            keywords: &["E10-217"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("молодая луна"),
            keywords: &["луна", "месяц", "молодая", "молодой"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("bitutu bya kane by’ukwezi"),
            keywords: &["bitutu bya kane by’ukwezi"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ننڍي چنڊ ڏانهن وڌندڙ"),
            keywords: &["ننڍو چنڊ", "ننڍي چنڊ ڏانهن وڌندڙ", "وڌندڙ چند", "چنڊ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ප\u{dd4}රපක\u{dca}ෂයේ අඩසඳ"),
            keywords: &[
                "අඩසඳ",
                "අභ\u{dca}\u{200d}යවක\u{dcf}ශය",
                "ක\u{dcf}ලග\u{dd4}ණය",
                "ප\u{dd4}ර",
                "ප\u{dd4}රපක\u{dca}ෂයේ අඩසඳ",
                "සඳ",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("dorastajúci polmesiac"),
            keywords: &[
                "dorastajúci polmesiac",
                "mesiac",
                "narastajúci",
                "polmesiac",
                "počasie",
                "vesmír",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("prvi krajec"),
            keywords: &["krajec", "luna", "prvi", "vesolje", "vreme"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("qoolaabanka dayaxa oo badanaya"),
            keywords: &[
                "badidoodka",
                "bil qoolaaban",
                "dayax",
                "qoolaabanka dayaxa oo badanaya",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("hënë e re më pak se gjysma"),
            keywords: &["hapësirë", "hënë", "hënë e re më pak se gjysma", "moti"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("месечев срп у порасту"),
            keywords: &["месец", "месечев срп у порасту", "пoлумесец"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("мјесечев срп у порасту"),
            keywords: &["мјесечев срп у порасту"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("mesečev srp u porastu"),
            keywords: &["mesec", "mesečev srp u porastu", "polumesec"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("mjesečev srp u porastu"),
            keywords: &["mjesečev srp u porastu"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("måne i första kvarteret"),
            keywords: &[
                "kvartsmåne",
                "måne",
                "måne i första kvarteret",
                "månskära",
                "tilltagande måne",
            ],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mwezi mwandamo"),
            keywords: &["anga", "hali yahewa", "kuanza", "mwezi", "mwezi mwandamo"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["anga", "hali ya hewa", "kuanza", "mwezi", "mwezi mwandamo"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("வளர\u{bcd}பிறை"),
            keywords: &["இரவு", "நில\u{bbe}", "பிறைநிலவு", "வளர\u{bcd}பிறை"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ప\u{c46}రుగుతున\u{c4d}న చంద\u{c4d}రుడు"),
            keywords: &[
                "చంద\u{c4d}రుడు",
                "ప\u{c46}రుగు",
                "ప\u{c46}రుగుతున\u{c4d}న చంద\u{c4d}రుడు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("ҳилоли нав"),
            keywords: &["калон шудани моҳ", "моҳ", "ҳилол", "ҳилоли нав"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("พระจ\u{e31}นทร\u{e4c}เส\u{e35}\u{e49}ยวข\u{e49}างข\u{e36}\u{e49}น"),
            keywords: &[
                "ข\u{e49}างข\u{e36}\u{e49}น",
                "พระจ\u{e31}นทร\u{e4c}เส\u{e35}\u{e49}ยวข\u{e49}างข\u{e36}\u{e49}น",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ýaş aý"),
            keywords: &["aý", "täze aý", "täze dogan", "ýaş aý"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("māhina ʻilo ʻehe maama"),
            keywords: &["māhina ʻilo ʻehe maama"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("büyüyen ay"),
            keywords: &["ay", "büyüyen ay", "yükselen"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("پۈتەر ئورغاق ئاي"),
            keywords: &["ئاي", "ئورغاق", "پۈتەر"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("місяць у першій чверті"),
            keywords: &[
                "зростаючий",
                "космос",
                "місяць",
                "місяць у першій чверті",
                "погода",
                "півмісяць",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("بڑھتا ہوا ہلال چاند"),
            keywords: &["بڑھتا ہوا ہلال چاند", "موسم", "چاند", "ہلال"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("kattalashib boruvchi yarim oy"),
            keywords: &[
                "kattalashib boruvchi",
                "kattalashib boruvchi yarim oy",
                "koinot",
                "ob-havo",
                "oy",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("trăng lưỡi liềm đầu tháng"),
            keywords: &[
                "lưỡi liềm",
                "mặt trăng",
                "tròn dần",
                "trăng lưỡi liềm đầu tháng",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("xaaju weer buy wàññiku"),
            keywords: &["weer", "wàññiku", "xaaj", "xaaju weer buy wàññiku"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("inyanga elicala efayo"),
            keywords: &["efayo", "elicala", "inyanga"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Yíyọ\u{301} Ààbọ\u{300} Oṣùpá"),
            keywords: &[
                "Yíyọ\u{301} Ààbọ\u{300} Oṣùpá",
                "kírísẹ\u{301}ntì",
                "yíyọ\u{301}",
                "òṣùpá",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("娥眉月"),
            keywords: &["娥眉月", "弦月", "月", "盈"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("娥眉月"),
            keywords: &["娥眉月", "弦月", "月", "盈"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("娥眉月"),
            keywords: &["三日月", "娥眉月", "弯月", "月亮", "眉月"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("眉形新月"),
            keywords: &["彎月", "眉形新月"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("娥眉月"),
            keywords: &["娥眉月", "月亮"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("inyanga ewucezu olubheke emuva"),
            keywords: &[
                "inyanga",
                "inyanga ewucezu olubheke emuva",
                "isimo sezulu",
                "ukubheka emuva",
                "umkhathi",
            ],
        },
    ],
};
#[doc = "🌓"]
pub const FIRST_QUARTER_MOON: crate::Emoji = crate::Emoji {
    glyph: "🌓",
    codepoint: "1F313",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "first quarter moon",
    group: "Travel & Places",
    subgroup: "sky & weather",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("eerstekwartiermaan"),
            keywords: &[
                "eerste",
                "eerstekwartiermaan",
                "kwartier",
                "maan",
                "ruimte",
                "weer",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የመጀመሪያ ሩብ ጨረቃ"),
            keywords: &["ህዋ", "ሩብ", "የመጀመሪያ ሩብ ጨረቃ", "የአየር ንብረት", "ጨረቃ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("تربيع أول"),
            keywords: &["أول", "تربيع", "طقس", "فضاء", "قمر"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("প\u{9cd}ৰথম চত\u{9c1}ৰ\u{9cd}থ\u{9be}ংশ চন\u{9cd}দ\u{9cd}ৰ"),
            keywords: &[
                "চত\u{9c1}ৰ\u{9cd}থ\u{9be}ংশ",
                "চন\u{9cd}দ\u{9cd}ৰ",
                "প\u{9cd}ৰথম চত\u{9c1}ৰ\u{9cd}থ\u{9be}ংশ চন\u{9cd}দ\u{9cd}ৰ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("ayın birinci dörrdə bir hissəsi"),
            keywords: &[
                "ay",
                "ayın birinci dörrdə bir hissəsi",
                "dörddə bir",
                "hava",
                "kosmos",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("першая чвэрць"),
            keywords: &[
                "квадра",
                "космас",
                "маладзік",
                "месяц",
                "ноч",
                "палова",
                "першая чвэрць",
                "чвэрць",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Луната в първа четвърт"),
            keywords: &[
                "Луната в първа четвърт",
                "време",
                "космос",
                "луна",
                "четвърт",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("চ\u{9be}\u{981}দের প\u{9cd}রথম চত\u{9c1}র\u{9cd}থ\u{9be}ংশ"),
            keywords: &[
                "আবহ\u{9be}ওয\u{9bc}\u{9be}",
                "চত\u{9c1}র\u{9cd}থ\u{9be}ংশ",
                "চ\u{9be}\u{981}দ",
                "চ\u{9be}\u{981}দের প\u{9cd}রথম চত\u{9c1}র\u{9cd}থ\u{9be}ংশ",
                "মহ\u{9be}ক\u{9be}শ",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("hanterloar ar cʼhresk"),
            keywords: &["hanterloar", "hanterloar ar cʼhresk", "loar"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("prva četvrtina"),
            keywords: &["mjesec", "mjesečeve mijene", "prva četvrtina"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("lluna en el primer quart creixent"),
            keywords: &[
                "creixent",
                "lluna",
                "lluna en el primer quart creixent",
                "quart",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏅᏓ ᎤᏒ ᎡᎯ ᎢᎬᏱᏱ ᎩᏄᏘᏗ ᎧᎸᎢ"),
            keywords: &[
                "ᎩᏄᏘᏗ",
                "ᏅᏓ ᎤᏒ ᎡᎯ",
                "ᏅᏓ ᎤᏒ ᎡᎯ ᎢᎬᏱᏱ ᎩᏄᏗ ᎧᎸᎢ",
                "ᏅᏓ ᎤᏒ ᎡᎯ ᎢᎬᏱᏱ ᎩᏄᏘᏗ ᎧᎸᎢ",
            ],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("měsíc v první čtvrti"),
            keywords: &[
                "dorůstající",
                "dorůstá",
                "fáze měsíce",
                "měsíc",
                "měsíc v první čtvrti",
                "vesmír",
                "čtvrť",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("lleuad chwarter cyntaf"),
            keywords: &["cilgant", "gofod", "lleuad", "lleuad chwarter cyntaf"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("halvmåne 1. fjerdedel"),
            keywords: &[
                "første kvarter måne",
                "halvmåne 1. fjerdedel",
                "måne",
                "månefase",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("zunehmender Halbmond"),
            keywords: &["Halbmond", "zunehmend", "zunehmender Halbmond"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("σελήνη πρώτου τετάρτου"),
            keywords: &["σελήνη πρώτου τετάρτου", "τέταρτο", "φεγγάρι"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("first quarter moon"),
            keywords: &["first quarter moon", "moon", "quarter"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: Some("first-quarter moon"),
            keywords: &["first-quarter moon"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("luna en cuarto creciente"),
            keywords: &[
                "creciente",
                "cuarto",
                "espacio",
                "luna",
                "luna en cuarto creciente",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &[
                "clima",
                "creciente",
                "cuarto",
                "espacio",
                "luna",
                "luna en cuarto creciente",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &[
                "creciente",
                "cuarto",
                "espacio",
                "fase lunar",
                "luna",
                "luna en cuarto creciente",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["cuarto", "luna", "luna en cuarto creciente"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kasvav poolkuu"),
            keywords: &["ilm", "kasvav poolkuu", "kosmos", "kuu", "poolkuu"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("ilgora-erdia"),
            keywords: &["eguraldi", "espazio", "ilargi", "ilgora-erdia"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("یک\u{200c}چهارم نخست"),
            keywords: &[
                "آب\u{200c}وهوا",
                "اول",
                "تربیع",
                "فضا",
                "نخست",
                "یک\u{200c}چهارم",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("ensimmäinen neljänneskuu"),
            keywords: &[
                "ensimmäinen neljänneskuu",
                "kuu",
                "puolikuu",
                "sää",
                "taivaankappale",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("first quarter moon"),
            keywords: &[
                "buwan",
                "first quarter",
                "first quarter moon",
                "kalawakan",
                "quarter",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("vaksandi hálvmáni"),
            keywords: &["hálvmáni", "máni", "vaksandi"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("premier quartier de lune"),
            keywords: &["lune", "premier quartier de lune"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("premier quartier de lune"),
            keywords: &["lune", "premier quartier", "premier quartier de lune"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("céad cheathrú na gealí"),
            keywords: &[
                "ceathrú gealaí",
                "céad cheathrú na gealí",
                "gealach",
                "gealach i mbéal ceathrún",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("solas ùr na gealaich"),
            keywords: &[
                "ceathramh",
                "gealach",
                "gealach sa chiad cheathramh",
                "solas ùr na gealaich",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("lúa en cuarto crecente"),
            keywords: &["crecente", "cuarto", "lúa", "lúa en cuarto crecente"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("પ\u{acd}રથમ ત\u{acd}રિમાસીનો ચ\u{a82}દ\u{acd}ર"),
            keywords: &[
                "ચ\u{a82}દ\u{acd}ર",
                "ત\u{acd}રિમાસી",
                "પ\u{acd}રથમ ત\u{acd}રિમાસી ચ\u{a82}દ\u{acd}ર",
                "પ\u{acd}રથમ ત\u{acd}રિમાસીનો ચ\u{a82}દ\u{acd}ર",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("wata na farkon kwata"),
            keywords: &["kwata", "wata", "wata na farkon kwata"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("חצי ירח מתמלא"),
            keywords: &[
                "חצי ירח מתמלא",
                "ירח",
                "ירח רבעון ראשון",
                "רבעון",
                "שבוע ראשון",
            ],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("क\u{943}ष\u{94d}ण पक\u{94d}ष अर\u{94d}धच\u{902}द\u{94d}र"),
            keywords: &[
                "क\u{943}ष\u{94d}ण पक\u{94d}ष अर\u{94d}धच\u{902}द\u{94d}र",
                "चा\u{902}द",
                "चौथाई माह",
                "चौथाई माह का चा\u{902}द",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("mjesec prve četvrti"),
            keywords: &[
                "mjesec",
                "mjesec prve četvrti",
                "svemir",
                "vrijeme",
                "četvrt",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("első negyedben lévő hold"),
            keywords: &[
                "első negyedben lévő hold",
                "hold",
                "holdfázisok",
                "negyed",
                "ég",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("լուսինն առաջին քառորդում"),
            keywords: &[
                "եղանակ",
                "լուսին",
                "լուսինն առաջին քառորդում",
                "տիեզերք",
                "քառորդ",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("bulan perbani awal"),
            keywords: &[
                "angkasa",
                "bulan",
                "bulan perbani awal",
                "cuaca",
                "seperempat",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ọnwa mbụ nke mmalite-afọ"),
            keywords: &["mbụ nke mmalite-afọ", "ọnwa", "ọnwa mbụ nke mmalite-afọ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("fyrsta kvartil tungls"),
            keywords: &["fyrsta kvartil tungls", "máni", "tungl", "vaxandi hálfmáni"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("primo quarto di luna"),
            keywords: &["luna", "primo quarto di luna", "quarto"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("上弦の月"),
            keywords: &["上弦", "上弦の月", "半月", "月"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("bulan separo"),
            keywords: &["bulan", "separo"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მთვარის პირველი მეოთხედი"),
            keywords: &[
                "ამინდი",
                "კოსმოსი",
                "მეოთხედი",
                "მთვარე",
                "მთვარის პირველი მეოთხედი",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("айдың бірінші ширегі"),
            keywords: &["ай", "айдың бірінші ширегі", "ауа райы", "ширек", "ғарыш"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("halvmåne første kvarter"),
            keywords: &[
                "første kvarter måne",
                "halvmåne første kvarter",
                "måne",
                "månefase",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ព\u{17d2}រះចន\u{17d2}ទបង\u{17d2}ហាញខ\u{17d2}ល\u{17bd}នបាន១ភាគ៤"),
            keywords: &[
                "ព\u{17d2}រះចន\u{17d2}ទបង\u{17d2}ហាញខ\u{17d2}ល\u{17bd}នបាន១ភាគ៤",
                "ព\u{17d2}រះច\u{17d0}ន\u{17d2}ទ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕಾಲುಭಾಗದಷ\u{ccd}ಟು ಚಂದ\u{ccd}ರ"),
            keywords: &[
                "ಕಾಲುಭಾಗ",
                "ಕಾಲುಭಾಗದಷ\u{ccd}ಟು ಚಂದ\u{ccd}ರ",
                "ಮೊದಲ ಕಾಲುಭಾಗದಷ\u{ccd}ಟು ಚಂದ\u{ccd}ರ. ಚಂದ\u{ccd}ರ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("오른쪽 반달"),
            keywords: &["달", "오른쪽 반달"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some(
                "उमाश\u{947}उपरा\u{902}तच\u{94d}या प\u{902}द\u{94d}रशीच\u{947}\u{902} पयल\u{947} चार दिस",
            ),
            keywords: &[
                "उमाश\u{947}उपरा\u{902}तची प\u{902}दरस",
                "उमाश\u{947}उपरा\u{902}तच\u{94d}या प\u{902}द\u{94d}रशीच\u{947}\u{902} पयल\u{947} चार दिस",
                "च\u{902}द\u{94d}र",
                "पयल\u{947} चार दिस",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("жартысы толгон ай"),
            keywords: &["ай", "жартысы толгон ай", "жарым", "космос"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("zouhuelenden Hallefmound"),
            keywords: &["Hallef", "Mound", "Véierel", "zouhuelenden Hallefmound"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເດ\u{eb7}ອນອອກໃໝ\u{ec8}ເຄ\u{eb4}\u{ec8}ງດວງ"),
            keywords: &[
                "ເຄ\u{eb4}\u{ec8}ງດວງ",
                "ເດ\u{eb7}ອນອອກໃໝ\u{ec8}",
                "ເດ\u{eb7}ອນອອກໃໝ\u{ec8}ເຄ\u{eb4}\u{ec8}ງດວງ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("pirmas fazės ketvirtis"),
            keywords: &["ketvirtis", "mėnulis", "pirmas fazės ketvirtis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("augošs pusmēness"),
            keywords: &["augošs", "mēness", "pusmēness"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("marama ahotū"),
            keywords: &["hauwhā", "marama", "marama ahotū"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("прва четвртина"),
            keywords: &["време", "вселена", "месечина", "прва", "четвртина"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("അർദ\u{d4d}ധ പ\u{d57}ർണ\u{d4d}ണമി"),
            keywords: &[
                "അർദ\u{d4d}ധ പ\u{d57}ർണ\u{d4d}ണമി",
                "അർദ\u{d4d}ധചന\u{d4d}ദ\u{d4d}രൻ",
                "ചന\u{d4d}ദ\u{d4d}രൻ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("эхний улирлын сар"),
            keywords: &["сар", "улирал", "эхний улирлын сар", "эхнийх"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("श\u{941}क\u{94d}ल पक\u{94d}षातील च\u{902}द\u{94d}र"),
            keywords: &[
                "च\u{902}द\u{94d}र",
                "चत\u{941}र\u{94d}थी",
                "चत\u{941}र\u{94d}थीचा च\u{902}द\u{94d}र",
                "श\u{941}क\u{94d}ल पक\u{94d}षातील च\u{902}द\u{94d}र",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("bulan suku pertama"),
            keywords: &[
                "angkasa lepas",
                "bulan",
                "bulan suku pertama",
                "cuaca",
                "suku",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("l-ewwel kwart tal-qamar"),
            keywords: &["kwart", "l-ewwel kwart tal-qamar", "qamar"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("လ၏ ပထမအပတ\u{103a}"),
            keywords: &[
                "လ",
                "လေးပ\u{102f}\u{1036}တစ\u{103a}ပ\u{102f}\u{1036}",
                "လ၏ ပထမအပတ\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("voksende halvmåne"),
            keywords: &[
                "første kvarter",
                "halvmåne",
                "måne",
                "månefase",
                "ny",
                "voksende halvmåne",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("पहिलो पक\u{94d}षीय चन\u{94d}द\u{94d}रमा"),
            keywords: &[
                "एक चौ\u{902}थाइ",
                "चन\u{94d}द\u{94d}रमा",
                "ठाउ\u{901}",
                "पहिलो पक\u{94d}षीय चन\u{94d}द\u{94d}रमा",
                "मौ\u{902}सम",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("maan in eerste kwartier"),
            keywords: &["kwartier", "maan", "maan in eerste kwartier"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("veksande halvmåne"),
            keywords: &[
                "første kvarter",
                "halvmåne",
                "måne",
                "månefase",
                "ny",
                "veksande halvmåne",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ପ\u{b4d}ରଥମ ଚତ\u{b41}ର\u{b4d}ଥ\u{b3e}ଂଶ ଚନ\u{b4d}ଦ\u{b4d}ର"),
            keywords: &[
                "ଅର\u{b4d}ଦ\u{b4d}ଧ ଚନ\u{b4d}ଦ\u{b4d}ର",
                "ଚନ\u{b4d}ଦ\u{b4d}ର",
                "ପ\u{b4d}ରଥମ ଅର\u{b4d}ଦ\u{b4d}ଧ ଚନ\u{b4d}ଦ\u{b4d}ର",
                "ପ\u{b4d}ରଥମ ଚତ\u{b41}ର\u{b4d}ଥ\u{b3e}ଂଶ ଚନ\u{b4d}ଦ\u{b4d}ର",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਪਹਿਲੀ ਤਿਮਾਹੀ ਚ\u{a70}ਦ"),
            keywords: &[
                "ਚ\u{a70}ਦ",
                "ਤਿਮਾਹੀ",
                "ਪਹਿਲੀ ਤਿਮਾਹੀ ਚ\u{a70}ਦ",
                "ਪ\u{a41}ਲਾੜ",
                "ਮ\u{a4c}ਸਮ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("چاند دا پہلا چوتھائی حصہ"),
            keywords: &["چاند", "چاند دا پہلا چوتھائی حصہ", "چوتھہ حص\u{651}ہ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Mún Im Fẹ\u{301}st Kwọ\u{301}ta"),
            keywords: &["Kwọ\u{301}ta", "Mun", "Mún Im Fẹ\u{301}st Kwọ\u{301}ta"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("pierwsza kwadra księżyca"),
            keywords: &["księżyc", "kwadra", "pierwsza kwadra księżyca"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د لومړۍ ربعې سپوږمۍ"),
            keywords: &["د لومړۍ ربعې سپوږمۍ", "ربع", "سپوږمۍ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("quarto crescente"),
            keywords: &[
                "lua",
                "lua de quarto crescente",
                "quarto",
                "quarto crescente",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("lua em quarto crescente"),
            keywords: &[
                "crescente",
                "espaço",
                "lua",
                "lua em quarto crescente",
                "meteorologia",
                "quatro",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("hukñiqi wañu killa"),
            keywords: &["hukñiqi wañu", "hukñiqi wañu killa", "killa"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("lună în primul pătrar"),
            keywords: &["lună", "lună în primul pătrar", "pătrar", "unu"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-218"),
            keywords: &["E10-218"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("луна в первой четверти"),
            keywords: &[
                "луна",
                "луна в первой четверти",
                "месяц",
                "небо",
                "четверть",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("icya kane cya mbere cy’ukwezi"),
            keywords: &["icya kane cya mbere cy’ukwezi", "icyakane", "ukwezi"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("پهرين عشري جو چنڊ"),
            keywords: &["ٽه ماهي", "پهرين عشري جو چنڊ", "چنڊ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("පළම\u{dd4} චත\u{dd4}ර\u{dca}ථක සඳ"),
            keywords: &[
                "අභ\u{dca}\u{200d}යවක\u{dcf}ශය",
                "ක\u{dcf}ලග\u{dd4}ණය",
                "චත\u{dd4}ර\u{dca}ථක",
                "පළම\u{dd4} චත\u{dd4}ර\u{dca}ථක සඳ",
                "සඳ",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("prvá štvrť mesiaca"),
            keywords: &["mesiac", "počasie", "prvá štvrť mesiaca", "vesmír", "štvrť"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("polovično osvetljena luna v prvem krajcu"),
            keywords: &[
                "luna",
                "polovično osvetljena luna v prvem krajcu",
                "vesolje",
                "vreme",
                "četrt",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("rubaca hore ee dayaxa"),
            keywords: &["dayax", "rubac", "rubaca hore ee dayaxa"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("hëna e çerekut të parë"),
            keywords: &[
                "hapësirë",
                "hëna e çerekut të parë",
                "hënë",
                "moti",
                "çerek",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("месец у првој четврти"),
            keywords: &["месец", "месец у првој четврти", "чeтврт"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("мјесец у првој четврти"),
            keywords: &["мјесец у првој четврти"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("mesec u prvoj četvrti"),
            keywords: &["mesec", "mesec u prvoj četvrti", "četvrt"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("mjesec u prvoj četvrti"),
            keywords: &["mjesec u prvoj četvrti"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("tilltagande halvmåne"),
            keywords: &["kvarts", "måne", "tilltagande halvmåne"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mwezi wa robo ya kwanza"),
            keywords: &[
                "anga",
                "hali ya hewa",
                "mwezi",
                "mwezi wa robo ya kwanza",
                "robo",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("அரைப\u{bbe}தி வளர\u{bcd}பிறை"),
            keywords: &[
                "அரைநிலவு",
                "அரைப\u{bbe}தி வளர\u{bcd}பிறை",
                "இரவு",
                "நில\u{bbe}",
                "வளர\u{bcd}பிறை",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("మ\u{c4a}దట\u{c3f} న\u{c3e}లుగవ వంతు చంద\u{c4d}రుడు"),
            keywords: &[
                "చంద\u{c4d}రుడు",
                "న\u{c3e}లుగవ",
                "మ\u{c4a}దట\u{c3f} న\u{c3e}లుగవ వంతు చంద\u{c4d}రుడు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("марҳилаи чоряки якуми моҳ"),
            keywords: &["марҳилаи чоряки якуми моҳ", "моҳ", "чоряк"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("พระจ\u{e31}นทร\u{e4c}คร\u{e36}\u{e48}งซ\u{e35}กขวา"),
            keywords: &[
                "คร\u{e36}\u{e48}งซ\u{e35}ก",
                "พระจ\u{e31}นทร\u{e4c}",
                "พระจ\u{e31}นทร\u{e4c}คร\u{e36}\u{e48}งซ\u{e35}กขวา",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("birinji çärýek aý"),
            keywords: &["aý", "birinji çärýek aý", "çarýek"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("māhina tuʻu efiafi"),
            keywords: &["māhina tuʻu efiafi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("ilk dördün"),
            keywords: &["ay", "ilk dördün"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("باش چارەك ئاي"),
            keywords: &["ئاي", "باش چارەك ئاي", "چارەك"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("перша чверть місяця"),
            keywords: &[
                "космос",
                "місяць",
                "перша чверть місяця",
                "погода",
                "чверть",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("پہلے کوارٹر کا چاند"),
            keywords: &["موسم", "پہلے کوارٹر کا چاند", "چاند", "کوارٹر"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("birinchi chorakdagi oy"),
            keywords: &[
                "birinchi chorakdagi oy",
                "chorak",
                "koinot",
                "ob-havo",
                "oy",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("trăng thượng huyền"),
            keywords: &["mặt trăng", "phần tư", "trăng thượng huyền"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("xaaju weer wu njëkk"),
            keywords: &["weer wu njëkk", "xaaj", "xaaju weer wu njëkk"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("inyanga yekota yokuqala"),
            keywords: &["ikota", "inyanga", "inyanga yekota yokuqala"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Oṣùpá Ìlàrin Àkọ\u{301}kọ\u{301}"),
            keywords: &[
                "Oṣùpá Ìlàrin Àkọ\u{301}kọ\u{301}",
                "ìdámẹ\u{301}rin",
                "òṣùpá",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("上弦月"),
            keywords: &["上弦月", "四分之一", "月"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("上弦月"),
            keywords: &["上弦月", "四分之一", "月"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("上弦月"),
            keywords: &["上弦月", "月亮"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("上弦月"),
            keywords: &["上弦月", "月亮"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ikota yokuqala yenyanga"),
            keywords: &[
                "ikota",
                "ikota yokuqala yenyanga",
                "inyanga",
                "isimo sezulu",
                "umkhathi",
            ],
        },
    ],
};
#[doc = "🌔"]
pub const WAXING_GIBBOUS_MOON: crate::Emoji = crate::Emoji {
    glyph: "🌔",
    codepoint: "1F314",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "waxing gibbous moon",
    group: "Travel & Places",
    subgroup: "sky & weather",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("groeiende bolmaan"),
            keywords: &[
                "bol",
                "groei",
                "groeiende bolmaan",
                "maan",
                "ruimte",
                "weer",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ትንሽ የጠቆረች ግማሽ ጨረቃ"),
            keywords: &[
                "ህዋ",
                "ትንሽ የተቀባ",
                "ትንሽ የጠቆረ",
                "ትንሽ የጠቆረች",
                "ትንሽ የጠቆረች ግማሽ ጨረቃ",
            ],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("\u{202b}قمر أحدب متزايد"),
            keywords: &["طقس", "فضاء", "قمر", "محدودب", "\u{202b}قمر أحدب متزايد"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("বৰ\u{9cd}দ\u{9cd}ধিত অৰ\u{9cd}ধ\u{9be}ধিক চন\u{9cd}দ\u{9cd}ৰ"),
            keywords: &[
                "অৰ\u{9cd}ধ\u{9be}ধিক",
                "চন\u{9cd}দ\u{9cd}ৰ",
                "বৰ\u{9cd}দ\u{9cd}ধিত অৰ\u{9cd}ধ\u{9be}ধিক চন\u{9cd}দ\u{9cd}ৰ",
                "ৱেক\u{9cd}সিং",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("dörddə bir böyüyən ay"),
            keywords: &[
                "ay",
                "böyüyən",
                "dörddə bir",
                "dörddə bir böyüyən ay",
                "hava",
                "kosmos",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("рост гарба"),
            keywords: &[
                "горб",
                "космас",
                "месяц",
                "ноч",
                "падпоўня",
                "рост",
                "рост гарба",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("нарастваща полупълна Луна"),
            keywords: &[
                "космос",
                "луна",
                "нарастваща",
                "нарастваща полупълна Луна",
                "полупълна",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some(
                "ব\u{9c3}দ\u{9cd}ধিপ\u{9cd}র\u{9be}প\u{9cd}ত অর\u{9cd}ধ\u{9be}ধিক চ\u{9be}\u{981}দ",
            ),
            keywords: &[
                "অর\u{9cd}ধ\u{9be}ধিক",
                "আবহ\u{9be}ওয\u{9bc}\u{9be}",
                "ওয\u{9bc}\u{9be}ক\u{9cd}সিং",
                "চ\u{9be}\u{981}দ",
                "ব\u{9c3}দ\u{9cd}ধিপ\u{9cd}র\u{9be}প\u{9cd}ত অর\u{9cd}ধ\u{9be}ধিক চ\u{9be}\u{981}দ",
                "মহ\u{9be}ক\u{9be}শ",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("loar vras ar c’hresk"),
            keywords: &["loar", "loar vras ar c’hresk"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("do punog mjeseca"),
            keywords: &["do punog mjeseca", "mjesec", "mjesečeve mijene"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("lluna gibosa creixent"),
            keywords: &["creixent", "gibosa", "lluna"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("Ꮲ ᏦᎢ ᎩᏄᎩᏗ ᏅᏓ ᎤᏒ ᎡᎯ"),
            keywords: &["ᎠᎦᏘᏏ ᎠᏲᎶᎦ", "ᏅᏓ ᎤᏒ ᎡᎯ", "Ꮲ ᏦᎢ ᎩᏄᎩᏗ ᏅᏓ ᎤᏒ ᎡᎯ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("dorůstající měsíc před úplňkem"),
            keywords: &[
                "dorůstající",
                "dorůstající měsíc před úplňkem",
                "dorůstá",
                "fáze měsíce",
                "měsíc",
                "vesmír",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("lleuad amgrwm ar ei chynnydd"),
            keywords: &[
                "chwarter",
                "gofod",
                "lleuad",
                "lleuad amgrwm ar ei chynnydd",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("tiltagende måne næsten fuld"),
            keywords: &["måne", "månefase", "tiltagende måne næsten fuld"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("zweites Mondviertel"),
            keywords: &["Mond", "zunehmend", "zweites Mondviertel"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("αύξων αμφίκυρτος"),
            keywords: &["αμφίκυρτος", "αύξων", "διάστημα", "καιρός", "φεγγάρι"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("waxing gibbous moon"),
            keywords: &["gibbous", "moon", "waxing"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("luna gibosa creciente"),
            keywords: &["creciente", "gibosa", "luna"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["clima", "creciente", "espacio", "gibosa", "luna"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["creciente", "espacio", "fase lunar", "gibosa", "luna"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["creciente", "gibosa", "luna"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kasvav kuu"),
            keywords: &["ilm", "kasvav", "kuu", "poolkuu"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("ilgora-bukaera"),
            keywords: &[
                "eguraldi",
                "espazio",
                "handitu",
                "ilargi",
                "ilbehera",
                "ilgora-bukaera",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("کوژماه افزاینده"),
            keywords: &[
                "آب\u{200c}وهوا",
                "بدر",
                "تحدب",
                "رو به زمین",
                "فضا",
                "ماه",
                "کوژماه افزاینده",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kasvava puolikuu"),
            keywords: &[
                "kasvava",
                "kasvava puolikuu",
                "kuu",
                "sää",
                "taivaankappale",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("waxing gibbous moon"),
            keywords: &[
                "buwan",
                "gibbous",
                "kalawakan",
                "waxing",
                "waxing gibbous moon",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("stórur vaksandi hálvmáni"),
            keywords: &["hálvmáni", "máni", "stórur vaksandi hálvmáni", "vaksandi"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("lune gibbeuse croissante"),
            keywords: &["lune", "lune gibbeuse croissante"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["gibbeuse croissante", "lune", "lune gibbeuse croissante"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("gealach scothlán atá ag líonadh"),
            keywords: &[
                "gealach",
                "gealach ag líonadh",
                "gealach ag teach ann",
                "gealach scothlán ag ag dul ar gcúl",
                "gealach scothlán atá ag líonadh",
                "líonadh",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("gealach chrotach a’ fàs"),
            keywords: &[
                "cinntinn",
                "crotach",
                "fàs",
                "gealach",
                "gealach chrotach a’ fàs",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("lúa xibosa crecente"),
            keywords: &["crecente", "lúa", "xibosa"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("વધતો ચ\u{a82}દ\u{acd}ર"),
            keywords: &[
                "અર\u{acd}ધ ચ\u{a82}દ\u{acd}ર",
                "ચ\u{a82}દ\u{acd}ર",
                "બહિર\u{acd}ગોળ",
                "વધતો",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("wata wucewa rabi mai ƙaruwa"),
            keywords: &[
                "mai ƙaruwa",
                "wata",
                "wata wucewa rabi mai ƙaruwa",
                "wucewa rabi",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("ירח כמעט מלא"),
            keywords: &["חלל", "ירח", "ירח כמעט מלא"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("उभरा ह\u{941}आ उदीयमान चा\u{901}द"),
            keywords: &[
                "उभरा ह\u{941}आ उदीयमान चा\u{901}द",
                "क\u{941}बड\u{93c}ा",
                "चा\u{901}द",
                "बढ\u{93c}ता चा\u{901}द",
                "वर\u{94d}धमान",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("mjesec rastuće prve četvrti"),
            keywords: &[
                "mjesec",
                "mjesec rastuće prve četvrti",
                "rast",
                "svemir",
                "vrijeme",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("növő domború hold"),
            keywords: &["domború", "hold", "holdfázisok", "növő domború hold", "ég"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("աճող ուռուցիկ լուսին"),
            keywords: &["աճող", "եղանակ", "լուսին", "ուռուցիկ", "տիեզերք"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("bulan cembung awal"),
            keywords: &[
                "angkasa",
                "bulan",
                "bulan cembung awal",
                "cembung",
                "cuaca",
                "membesar",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ọnwa na-achawapụta ọkara ọnwa"),
            keywords: &[
                "na-achawapụta",
                "ọkara ọnwa",
                "ọnwa",
                "ọnwa na-achawapụta ọkara ọnwa",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("vaxandi tungl (meira en hálft)"),
            keywords: &[
                "máni",
                "tungl",
                "vaxandi",
                "vaxandi tungl (meira en hálft)",
                "ávalt tungl",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("luna gibbosa crescente"),
            keywords: &["crescente", "gibbosa", "luna"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("十三夜月"),
            keywords: &["十三夜月", "十日夜の月", "月"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("bulan separo luwih"),
            keywords: &[
                "bulan",
                "bulan separo luwih",
                "padhange meh kebak",
                "padhange sithik-sithik",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მზარდი განათებული მთვარე"),
            keywords: &[
                "ამინდი",
                "კოსმოსი",
                "მზარდი",
                "მზარდი განათებული მთვარე",
                "მთვარე",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("толып жатқан дөңес ай"),
            keywords: &[
                "ай",
                "ауа райы",
                "дөңес",
                "толып жатқан дөңес ай",
                "толысып жатқан",
                "ғарыш",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("tiltagende måne næsten fuld"),
            keywords: &["måne", "månefase", "tiltagende måne næsten fuld"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ព\u{17d2}រចន\u{17d2}ទជ\u{17b7}តពេញវង\u{17cb}"),
            keywords: &[
                "ខ\u{17d2}នើត",
                "ជ\u{17b7}តពេញវង\u{17cb}",
                "ព\u{17d2}រចន\u{17d2}ទជ\u{17b7}តពេញវង\u{17cb}",
                "ព\u{17d2}រច\u{17d0}ន\u{17d2}ទ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಪೀನ ಚಂದ\u{ccd}ರ"),
            keywords: &["ಚಂದ\u{ccd}ರ", "ಪೀನ", "ಮೇಣ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("상현달"),
            keywords: &["달", "상현달"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("वाडट\u{94d}या च\u{902}द\u{94d}रकळ\u{947}चो अर\u{94d}दच\u{902}द\u{94d}र"),
            keywords: &[
                "अर\u{94d}दच\u{902}द\u{94d}र",
                "च\u{902}द\u{94d}र",
                "वाडटी च\u{902}द\u{94d}रकळा",
                "वाडट\u{94d}या च\u{902}द\u{94d}रकळ\u{947}चो अर\u{94d}दच\u{902}द\u{94d}र",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("толгону калган ай"),
            keywords: &[
                "аба ырайы",
                "ай",
                "космос",
                "толгону калган",
                "толгону калган ай",
            ],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Séchelmound am zweete Véierel"),
            keywords: &[
                "Mound",
                "Séchelmound",
                "Séchelmound am zweete Véierel",
                "zweete Véierel",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເດ\u{eb7}ອນອອກໃໝ\u{ec8}ຂ\u{ec9}ອນດວງ"),
            keywords: &[
                "ຂ\u{ec9}ອນດວງ",
                "ເດ\u{eb7}ອນອອກໃໝ\u{ec8}",
                "ເດ\u{eb7}ອນອອກໃໝ\u{ec8}ຂ\u{ec9}ອນດວງ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("priešpilnis (pabaiga)"),
            keywords: &["mėnulis", "priešpilnis", "priešpilnis (pabaiga)"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("izliekts augošs mēness"),
            keywords: &["augošs", "izliekts", "mēness"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("marama hua"),
            keywords: &["hua", "kipuha", "marama"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("последна фаза на осветлување"),
            keywords: &["месечина", "осветлување", "последна фаза на осветлување"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("മ\u{d3e}യ\u{d41}ന\u{d4d}ന ചന\u{d4d}ദ\u{d4d}രൻ"),
            keywords: &[
                "ചന\u{d4d}ദ\u{d4d}രക\u{d4d}കല",
                "മ\u{d3e}യ\u{d41}ന\u{d4d}ന ചന\u{d4d}ദ\u{d4d}രൻ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("бүтэн сарын өмнөх сар"),
            keywords: &["бүтэн сарын өмнөх сар", "гүдгэр сар", "сар"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some(
                "स\u{942}र\u{94d}यास\u{94d}ताव\u{947}ळी दिसणारा पाऊण प\u{94d}रकाशित च\u{902}द\u{94d}र",
            ),
            keywords: &[
                "क\u{941}बडा",
                "च\u{902}द\u{94d}र",
                "वाढणारा",
                "स\u{942}र\u{94d}यास\u{94d}ताव\u{947}ळी दिसणारा पाऊण प\u{94d}रकाशित च\u{902}द\u{94d}र",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("bulan hampir purnama mengambang"),
            keywords: &[
                "angkasa lepas",
                "bulan",
                "bulan hampir purnama mengambang",
                "cuaca",
                "hampir purnama",
                "membesar",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("qamar akbar minn nofs li qed jikber"),
            keywords: &[
                "akbar minn nofs",
                "qamar",
                "qamar akbar minn nofs li qed jikber",
                "qed jikber",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("လပြည\u{1037}\u{103a}မတ\u{102d}\u{102f}င\u{103a}မ\u{102e} အပတ\u{103a}"),
            keywords: &[
                "လ",
                "လဆန\u{103a}း",
                "လပြည\u{1037}\u{103a}ခါန\u{102e}း",
                "လပြည\u{1037}\u{103a}မတ\u{102d}\u{102f}င\u{103a}မ\u{102e} အပတ\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("voksende fullmåne"),
            keywords: &["måne", "månefase", "ny", "voksende fullmåne"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("बढ\u{94d}दो गिबस चन\u{94d}द\u{94d}रमा"),
            keywords: &[
                "गिबस",
                "चन\u{94d}द\u{94d}रमा",
                "ठाउ\u{901}",
                "बढ\u{94d}दो",
                "मौ\u{902}सम",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("wassende maan"),
            keywords: &["bolvormig", "maan", "wassend", "wassende maan"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("veksande fullmåne"),
            keywords: &["måne", "månefase", "ny", "veksande fullmåne"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some(
                "ୱ\u{b3e}କ\u{b4d}ସ\u{b3f}ଂରେ ଥ\u{b3f}ବ\u{b3e} ବହ\u{b3f}ର\u{b4d}ବର\u{b4d}ତ\u{b4d}ତ ହେଉଥ\u{b3f}ବ\u{b3e} ଅପ\u{b41}ର\u{b4d}ଣଚନ\u{b4d}ଦ\u{b4d}ର",
            ),
            keywords: &[
                "ଅର\u{b4d}ଦ\u{b4d}ଧର\u{b41} ଅଧ\u{b3f}କ",
                "ଅର\u{b4d}ଦ\u{b4d}ଧର\u{b41} ଅଧ\u{b3f}କ ଚନ\u{b4d}ଦ\u{b4d}ର",
                "ଚନ\u{b4d}ଦ\u{b4d}ର",
                "ବଢ\u{b3c}ନ\u{b4d}ତ\u{b3e}",
                "ବହ\u{b3f}ର\u{b4d}ବର\u{b4d}ତ\u{b4d}ତ ହେଉଥ\u{b3f}ବ\u{b3e} ଅପ\u{b41}ର\u{b4d}ଣଚନ\u{b4d}ଦ\u{b4d}ର",
                "ଶ\u{b41}କ\u{b4d}ଳପକ\u{b4d}ଷ ବଢ\u{b3c}ନ\u{b4d}ତ\u{b3e} ଚନ\u{b4d}ଦ\u{b4d}ର",
                "ୱ\u{b3e}କ\u{b4d}ସ\u{b3f}ଂରେ ଥ\u{b3f}ବ\u{b3e} ବହ\u{b3f}ର\u{b4d}ବର\u{b4d}ତ\u{b4d}ତ ହେଉଥ\u{b3f}ବ\u{b3e} ଅପ\u{b41}ର\u{b4d}ଣଚନ\u{b4d}ଦ\u{b4d}ର",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਨ\u{a4c}ਮਾਹੀ ਚ\u{a70}ਦ"),
            keywords: &[
                "ਚ\u{a70}ਦ",
                "ਨ\u{a4c}ਮਾਹੀ",
                "ਪ\u{a41}ਲਾੜ",
                "ਮ\u{a4c}ਸਮ",
                "ਵ\u{a71}ਧਦਾ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("نشوونما پاندا م\u{64f}حد\u{650}ب چاند"),
            keywords: &[
                "محدب",
                "نشوونما پاندا م\u{64f}حد\u{650}ب چاند",
                "ویکسنگ",
                "چاند",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Mun Braít Pat Bíg Pás Háf Di Mun"),
            keywords: &[
                "Fọ Mun To Bíg Mọ\u{301} Mọ",
                "Gíbọs",
                "Mun",
                "Mun Braít Pat Bíg Pás Háf Di Mun",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("narastający księżyc między pierwszą kwadrą a pełnią"),
            keywords: &[
                "księżyc z brzuszkiem",
                "narastający księżyc między pierwszą kwadrą a pełnią",
                "tłusty księżyc",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("رغېدونکې شاټوغې سپوږمۍ"),
            keywords: &["رغېدونکې", "سپوږمۍ", "شاټوغې"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("lua crescente convexa"),
            keywords: &["convexa", "crescente", "lua"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("lua na primeira giba"),
            keywords: &[
                "convexa",
                "crescente",
                "espaço",
                "lua",
                "lua na primeira giba",
                "meteorologia",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("chawpi gibosa killa"),
            keywords: &["chawpi", "gibosa", "killa"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("lună convexă în creștere"),
            keywords: &[
                "convexă",
                "creștere",
                "lună",
                "lună convexă în creștere",
                "semilună",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-219"),
            keywords: &["E10-219"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("прибывающая луна"),
            keywords: &["луна", "месяц", "небо", "прибывающая"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ukwezi kuri muri bitatu bya kane"),
            keywords: &[
                "ukwezi kuri muri bitatu bya kane",
                "ukwezi kwikubye nk’inyonjo",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("پوري چنڊ ڏانهن وڌندڙ"),
            keywords: &["وڌندڙ", "پوري چنڊ ڏانهن وڌندڙ", "چنڊ", "گبوس"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ප\u{dd4}රපක\u{dca}ෂයේ අටවක සඳ"),
            keywords: &[
                "අටවක",
                "අභ\u{dca}\u{200d}යවක\u{dcf}ශය",
                "ක\u{dcf}ලග\u{dd4}ණය",
                "ප\u{dd4}ර",
                "ප\u{dd4}රපක\u{dca}ෂයේ අටවක සඳ",
                "සඳ",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("dorastajúci mesiac"),
            keywords: &[
                "dorastajúci mesiac",
                "mesiac",
                "narastajúci",
                "počasie",
                "vesmír",
                "vypuklý",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("več kot polovično osvetljen prvi krajec"),
            keywords: &[
                "luna",
                "polovično",
                "prvi",
                "vesolje",
                "več kot polovično osvetljen prvi krajec",
                "vreme",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("weynaanta dayaxa oo sii badanaya"),
            keywords: &[
                "badidood",
                "dayaxa",
                "weynaanta",
                "weynaanta dayaxa oo sii badanaya",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("hënë e re më shumë se gjysma"),
            keywords: &["hapësirë", "hënë", "hënë e re më shumë se gjysma", "moti"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("скоро па пун месец"),
            keywords: &["месец", "рaст", "скоро па пун месец"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("скоро па пун мјесец"),
            keywords: &["скоро па пун мјесец"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("skoro pa pun mesec"),
            keywords: &["mesec", "rast", "skoro pa pun mesec"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("skoro pa pun mjesec"),
            keywords: &["skoro pa pun mjesec"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("måne i andra kvarteret"),
            keywords: &[
                "halvmåne till fullmåne",
                "måne i andra kvarteret",
                "tilltagande måne",
            ],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mwezi ulioangazwa zaidi ya nusu unaopevuka"),
            keywords: &[
                "anga",
                "mwezi",
                "mwezi ulioangazwa zaidi ya nusu unaopevuka",
                "mwezi ulioangazwa zaidi ya nusu unaotanda",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("முக\u{bcd}க\u{bbe}ல\u{bcd}பகுதி வளர\u{bcd}பிறை"),
            keywords: &[
                "இரவு",
                "நிலவொளி",
                "நில\u{bbe}",
                "பிறைநிலவு",
                "முக\u{bcd}க\u{bbe}ல\u{bcd}பகுதி வளர\u{bcd}பிறை",
                "வளர\u{bcd}பிறை",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ఉబ\u{c4d}బ\u{c46}త\u{c4d}తుగ\u{c3e} ఉన\u{c4d}న చంద\u{c4d}రుడు"),
            keywords: &[
                "ఉబ\u{c4d}బ\u{c46}త\u{c4d}తుగ\u{c3e}",
                "ఉబ\u{c4d}బ\u{c46}త\u{c4d}తుగ\u{c3e} ఉన\u{c4d}న చంద\u{c4d}రుడు",
                "చంద\u{c4d}రుడు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("марҳилаи калон шудани моҳ"),
            keywords: &[
                "калон шудани моҳ",
                "марҳилаи калон шудани моҳ",
                "марҳилаи моҳ",
                "моҳ",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ข\u{e49}างข\u{e36}\u{e49}น"),
            keywords: &[
                "ข\u{e49}างข\u{e36}\u{e49}น",
                "พระจ\u{e31}นทร\u{e4c}เก\u{e37}อบเต\u{e47}มดวง",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ulalýan aý"),
            keywords: &["aý", "ulalýan aý", "ýagty aý"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("māhina matofi"),
            keywords: &["māhina matofi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("geniş ay"),
            keywords: &["ay", "geniş ay", "yükselen", "şişkin"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("تولار چوڭ ئاي"),
            keywords: &["ئاي", "تولار", "چوڭ"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("місяць у другій чверті"),
            keywords: &[
                "зростаючий",
                "космос",
                "місяць",
                "місяць у другій чверті",
                "погода",
                "серпоподібний",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("آدھے سے زیادہ بڑھتا ہوا چاند"),
            keywords: &["آدھے سے زیادہ بڑھتا ہوا چاند", "بڑھتا ہوا", "موسم", "چاند"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("kattalashib boruvchi qavariq oy"),
            keywords: &[
                "kattalashib boruvchi qavariq oy",
                "koinot",
                "ob-havo",
                "oy",
                "qavariq",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("trăng khuyết"),
            keywords: &["mặt trăng", "tròn dần", "trăng khuyết"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("weer wu sew buy wàññiku"),
            keywords: &["sew", "weer", "weer wu sew buy wàññiku", "wàññiku"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("inyanga eliceba efayo"),
            keywords: &["efayo", "eliceba", "inyanga"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Yíyọ\u{301} Kíkún Oṣùpá"),
            keywords: &["Yíyọ\u{301} Kíkún Oṣùpá", "kíkùn", "yíyọ\u{301}", "òṣùpá"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("盈凸月"),
            keywords: &["月", "盈", "盈凸月", "突起"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("盈凸月"),
            keywords: &["月", "盈", "盈凸月", "突起"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("盈凸月"),
            keywords: &["月亮", "盈凸月"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("盈凸月"),
            keywords: &["月亮", "盈凸月"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("inyange ewucezu ebheke phambili"),
            keywords: &[
                "inyanga",
                "inyange ewucezu ebheke phambili",
                "isimo sezulu",
                "ukubhek phambili",
                "umkhathi",
            ],
        },
    ],
};
#[doc = "🌕"]
pub const FULL_MOON: crate::Emoji = crate::Emoji {
    glyph: "🌕",
    codepoint: "1F315",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "full moon",
    group: "Travel & Places",
    subgroup: "sky & weather",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("volmaan"),
            keywords: &["maan", "ruimte", "vol", "volmaan", "weer"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ሙሉ ጨረቃ"),
            keywords: &["ህዋ", "ሙሉ", "የአየር ንብረት", "ጨረቃ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("بدر"),
            keywords: &["بدر", "طقس", "فضاء", "قمر", "كامل"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("প\u{9c2}ৰ\u{9cd}ণ চন\u{9cd}দ\u{9cd}ৰ"),
            keywords: &["চন\u{9cd}দ\u{9cd}ৰ", "প\u{9c2}ৰ\u{9cd}ণ"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("tam ay"),
            keywords: &["ay", "hava", "kosmos", "tam"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("поўня"),
            keywords: &["космас", "ноч", "поўны месяц", "поўня"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("пълнолуние"),
            keywords: &["време", "космос", "луна", "пълна", "пълнолуние"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("প\u{9c2}র\u{9cd}ণিম\u{9be}"),
            keywords: &[
                "আবহ\u{9be}ওয\u{9bc}\u{9be}",
                "চ\u{9be}\u{981}দ",
                "প\u{9c2}র\u{9cd}ণ",
                "প\u{9c2}র\u{9cd}ণিম\u{9be}",
                "মহ\u{9be}ক\u{9be}শ",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("loargann"),
            keywords: &["loar", "loargann"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("pun mjesec"),
            keywords: &["mjesec", "mjesečeve mijene", "pun mjesec"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("lluna plena"),
            keywords: &["lluna", "plena"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎧᎵ ᏅᏓ ᎤᏒ ᎡᎯ"),
            keywords: &["ᎧᎵ", "ᎧᎵ ᏅᏓ ᎤᏒ ᎡᎯ", "ᏅᏓ ᎤᏒ ᎡᎯ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("měsíc v úplňku"),
            keywords: &[
                "fáze měsíce",
                "jasný",
                "měsíc",
                "měsíc v úplňku",
                "vesmír",
                "úplněk",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("lleuad lawn"),
            keywords: &["amgrwm", "gofod", "lleuad", "lleuad lawn"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("fuldmåne"),
            keywords: &["fuldmåne", "måne", "månefase"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Vollmond"),
            keywords: &["Mond", "Vollmond"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("πανσέληνος"),
            keywords: &["γεμάτο", "διάστημα", "καιρός", "πανσέληνος", "φεγγάρι"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("full moon"),
            keywords: &["full", "moon"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("luna llena"),
            keywords: &["llena", "luna", "plenilunio"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["clima", "espacio", "llena", "luna"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["espacio", "fase lunar", "llena", "luna"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["llena", "luna"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("täiskuu"),
            keywords: &["ilm", "kosmos", "täiskuu"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("ilargi betea"),
            keywords: &["bete", "eguraldi", "espazio", "ilargi", "ilargi betea"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("ماه کامل"),
            keywords: &[
                "آب\u{200c}وهوا",
                "بدر",
                "فضا",
                "ماه",
                "ماه تمام",
                "ماه کامل",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("täysikuu"),
            keywords: &["kuu", "sää", "taivaankappale", "täysi", "täysikuu"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("full moon"),
            keywords: &["bilog na buwan", "buwan", "full moon", "kalawakan"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("fullmáni"),
            keywords: &["fullmáni", "máni"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("pleine lune"),
            keywords: &["lune", "pleine lune"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["lune", "pleine"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("gealach lán"),
            keywords: &["gealach", "lán"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("làn-ghealach"),
            keywords: &["gealach", "làn", "làn-ghealach"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("lúa chea"),
            keywords: &["chea", "lúa", "plenilunio"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("પ\u{ac2}ર\u{acd}ણ ચ\u{a82}દ\u{acd}ર"),
            keywords: &[
                "ચ\u{a82}દ\u{acd}ર",
                "ત\u{ac7}જસ\u{acd}વી",
                "પ\u{ac2}ર\u{acd}ણ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("cikakken wata"),
            keywords: &["cikakke", "cikakken wata", "wata"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("ירח מלא"),
            keywords: &["חלל", "ירח", "ירח מלא", "מילוא", "שמיים"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("प\u{942}रा चा\u{901}द"),
            keywords: &[
                "चमकदार",
                "चा\u{902}द",
                "प\u{942}रा",
                "प\u{942}रा चा\u{901}द",
                "प\u{942}र\u{94d}ण च\u{902}द\u{94d}र",
                "प\u{942}र\u{94d}णिमा का चा\u{901}द",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("puni mjesec"),
            keywords: &["mjesec", "puni", "svemir", "uštap", "vrijeme"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("telihold"),
            keywords: &["hold", "holdfázisok", "telihold", "ég"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("լիալուսին"),
            keywords: &["եղանակ", "լիալուսին", "լուսին", "տիեզերք"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("bulan purnama"),
            keywords: &["angkasa", "bulan", "cuaca", "purnama"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ọnwa zuru òkè"),
            keywords: &["zuru òkè", "ọnwa", "ọnwa zuru òkè"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("fullt tungl"),
            keywords: &["fullt", "máni", "tungl"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("luna piena"),
            keywords: &["luna", "piena", "plenilunio"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("満月"),
            keywords: &["月", "満月"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("purnama sidi"),
            keywords: &["bulan", "purnama", "purnama sidi"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("სავსე მთვარე"),
            keywords: &["ამინდი", "კოსმოსი", "მთვარე", "სავსე"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("толық ай"),
            keywords: &["ай", "ауа райы", "толы", "толық ай", "ғарыш"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("fuldmåne"),
            keywords: &["fuldmåne", "måne", "månefase"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ព\u{17d2}រះចន\u{17d2}ទពេញវង\u{17cb}"),
            keywords: &[
                "ពេញវង\u{17cb}",
                "ព\u{17d2}រះចន\u{17d2}ទពេញវង\u{17cb}",
                "ព\u{17d2}រះច\u{17d0}ន\u{17d2}ទ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಪ\u{cc2}ರ\u{ccd}ಣ ಚಂದ\u{ccd}ರ"),
            keywords: &["ಚಂದ\u{ccd}ರ", "ಪ\u{cc2}ರ\u{ccd}ಣ", "ಪ\u{ccd}ರಕಾಶಮಾನ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("보름달"),
            keywords: &["달", "보름달"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("प\u{941}नव"),
            keywords: &["च\u{902}द\u{94d}र", "प\u{941}नव", "प\u{941}नव\u{947}चो"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("толгон ай"),
            keywords: &["аба ырайы", "ай", "космос", "толгон"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Vollmound"),
            keywords: &["Mound", "Vollmound", "voll"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເດ\u{eb7}ອນອອກໃໝ\u{ec8}ເຕ\u{eb1}ມດວງ"),
            keywords: &[
                "ເດ\u{eb7}ອນອອກໃໝ\u{ec8}",
                "ເດ\u{eb7}ອນອອກໃໝ\u{ec8}ເຕ\u{eb1}ມດວງ",
                "ເຕ\u{eb1}ມດວງ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("pilnatis"),
            keywords: &["mėnulis", "pilnas", "pilnatis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("pilnmēness"),
            keywords: &["mēness", "pilnmēness"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("rākaunui"),
            keywords: &["marama", "rākaunui"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("полна месечина"),
            keywords: &["време", "вселена", "месечина", "полна"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("പ\u{d42}ർണ\u{d4d}ണചന\u{d4d}ദ\u{d4d}രൻ"),
            keywords: &[
                "ചന\u{d4d}ദ\u{d4d}രൻ",
                "പ\u{d42}ർണ\u{d4d}ണചന\u{d4d}ദ\u{d4d}രൻ",
                "പ\u{d57}ർണ\u{d4d}ണമി",
                "വെള\u{d41}ത\u{d4d}തവ\u{d3e}വ\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("бүтэн сар"),
            keywords: &["бүтэн", "сар"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("पौर\u{94d}णिमा"),
            keywords: &["च\u{902}द\u{94d}र", "प\u{942}र\u{94d}ण", "पौर\u{94d}णिमा"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("bulan purnama"),
            keywords: &["angkasa lepas", "bulan", "bulan purnama", "cuaca", "penuh"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("qamar sħiħ"),
            keywords: &["qamar", "sħiħ"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("လပြည\u{1037}\u{103a}"),
            keywords: &["လ", "လပြည\u{1037}\u{103a}"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("fullmåne"),
            keywords: &["full", "fullmåne", "hel måne", "måne"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("प\u{942}र\u{94d}णिमा"),
            keywords: &[
                "आकाशग\u{902}गा",
                "प\u{942}रा",
                "प\u{942}र\u{94d}णिमा",
                "मौसम",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("volle maan"),
            keywords: &["maan", "vol", "volle maan"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("fullmåne"),
            keywords: &["full", "fullmåne", "heil måne", "måne"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ପ\u{b42}ର\u{b4d}ଣ\u{b4d}ଣ ଚନ\u{b4d}ଦ\u{b4d}ର"),
            keywords: &[
                "ଉଜ\u{b4d}ଵଳ",
                "ଚନ\u{b4d}ଦ\u{b4d}ର",
                "ପ\u{b42}ର\u{b4d}ଣ\u{b4d}ଣ",
                "ପ\u{b42}ର\u{b4d}ଣ\u{b4d}ଣ\u{b3f}ମ\u{b3e}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਪ\u{a42}ਰਾ ਚ\u{a70}ਦ"),
            keywords: &[
                "ਚਮਕਦਾ",
                "ਚ\u{a70}ਦ",
                "ਪ\u{a41}ਲਾੜ",
                "ਪ\u{a42}ਰਾ",
                "ਮ\u{a4c}ਸਮ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("پورا چاند"),
            keywords: &["پورا", "چاند"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Fúl Mun"),
            keywords: &["Fúl", "Mun"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("pełnia"),
            keywords: &["jasny księżyc", "księżyc", "pełnia", "pełny księżyc"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("بشپړه سپوږمۍ"),
            keywords: &["بشپړه", "سپوږمۍ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("lua cheia"),
            keywords: &["cheia", "lua", "luar"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["cheia", "espaço", "lua", "meteorologia"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("pura killa"),
            keywords: &["pura killa"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("lună plină"),
            keywords: &["lumină", "lună", "lună plină", "rotund"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-220"),
            keywords: &["E10-220"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("полнолуние"),
            keywords: &["луна", "месяц", "полная", "полнолуние", "полный"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("inzora y’ukwezi"),
            keywords: &["inzora y’ukwezi"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("پورو چنڊ"),
            keywords: &["پورو", "چنڊ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ප\u{dd4}රසඳ"),
            keywords: &[
                "අභ\u{dca}\u{200d}යවක\u{dcf}ශය",
                "ක\u{dcf}ලග\u{dd4}ණය",
                "ප\u{dd4}රසඳ",
                "ප\u{dd6}ර\u{dca}ණ",
                "සඳ",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("spln"),
            keywords: &["mesiac", "počasie", "spln", "vesmír"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("polna luna"),
            keywords: &["luna", "polna luna", "polno", "vesolje", "vreme"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("dayax buuxa"),
            keywords: &["buuxa", "dayax"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("hënë e plotë"),
            keywords: &["e plotë", "hapësirë", "hënë", "hënë e plotë", "moti"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("пун месец"),
            keywords: &["месец", "пун"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("пун мјесец"),
            keywords: &["пун мјесец"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("pun mesec"),
            keywords: &["mesec", "pun"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("pun mjesec"),
            keywords: &["pun mjesec"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("fullmåne"),
            keywords: &["fullmåne", "måne"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mwezi kamili"),
            keywords: &["anga", "hali ya hewa", "kamili", "mwezi"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பௌர\u{bcd}ணமி"),
            keywords: &["இரவு", "நிலவொளி", "பௌர\u{bcd}ணமி", "முழுநிலவு"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ప\u{c4c}ర\u{c4d}ణమ\u{c3f}"),
            keywords: &[
                "చంద\u{c4d}రుడు",
                "పూర\u{c4d}ణ చంద\u{c4d}రుడు",
                "ప\u{c4c}ర\u{c4d}ణమ\u{c3f}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("моҳи пурра"),
            keywords: &["моҳи пурра", "пурра"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("พระจ\u{e31}นทร\u{e4c}เต\u{e47}มดวง"),
            keywords: &[
                "พระจ\u{e31}นทร\u{e4c}",
                "พระจ\u{e31}นทร\u{e4c}เต\u{e47}มดวง",
                "เต\u{e47}มดวง",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("dolan aý"),
            keywords: &["aý", "dolan aý"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("māhina kātoa"),
            keywords: &["māhina kātoa"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("dolunay"),
            keywords: &["ay", "dolu", "dolunay", "parlak"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("تولۇن ئاي"),
            keywords: &["ئاي", "تولۇق", "تولۇن ئاي"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("повний місяць"),
            keywords: &["космос", "місяць", "повний", "погода"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("مکمل چاند"),
            keywords: &["موسم", "مکمل", "چاند"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("to‘lin oy"),
            keywords: &["koinot", "ob-havo", "to‘lin", "to‘lin oy", "to‘liq"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("trăng tròn"),
            keywords: &["mặt trăng", "tròn", "trăng tròn"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("weer wu fees"),
            keywords: &["fees", "weer", "weer wu fees"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("inyanga epheleleyo"),
            keywords: &["epheleleyo", "inyanga"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ẹ\u{300}kúnrẹ\u{301}rẹ\u{301} Òṣùpá"),
            keywords: &["Òṣùpá", "Ẹ\u{300}kúnrẹ\u{301}rẹ\u{301}"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("滿月"),
            keywords: &["月", "滿", "滿月"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("满月"),
            keywords: &["月", "满", "满月"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("满月"),
            keywords: &["月亮", "望月", "满月"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("滿月"),
            keywords: &["月亮", "望月", "滿月"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["月亮", "滿月"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("inyange egcwele"),
            keywords: &[
                "inyanga",
                "inyange egcwele",
                "isimo sezulu",
                "ukugcwala",
                "umkhathi",
            ],
        },
    ],
};
#[doc = "🌖"]
pub const WANING_GIBBOUS_MOON: crate::Emoji = crate::Emoji {
    glyph: "🌖",
    codepoint: "1F316",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "waning gibbous moon",
    group: "Travel & Places",
    subgroup: "sky & weather",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("afnemende bolmaan"),
            keywords: &[
                "afneem",
                "afnemende bolmaan",
                "bol",
                "maan",
                "ruimte",
                "weer",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("በቀኝ በኩል ትንሽ የጠቆረች ግማሽ ጨረቃ"),
            keywords: &["ህዋ", "በቀኝ በኩል ትንሽ የጠቆረች ግማሽ ጨረቃ", "ትንሽ የጠቆረ", "የአየር ንብረት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("\u{202b}قمر أحدب متناقص"),
            keywords: &["أحدب", "طقس", "فضاء", "قمر", "متناقص"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ক\u{9cd}ষীয\u{9bc}ম\u{9be}ন অৰ\u{9cd}ধ\u{9be}ধিক চন\u{9cd}দ\u{9cd}ৰ"),
            keywords: &[
                "অৰ\u{9cd}ধ\u{9be}ধিক",
                "ক\u{9cd}ষীয\u{9bc}ম\u{9be}ন",
                "চন\u{9cd}দ\u{9cd}ৰ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("sönən böyüyən ay"),
            keywords: &["ay", "böyüyən", "hava", "kosmos", "sönən"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("змяншэнне гарба"),
            keywords: &[
                "горб",
                "змяншэнне гарба",
                "космас",
                "месяц",
                "ноч",
                "сход",
                "убыванне",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("намаляваща полупълна Луна"),
            keywords: &[
                "космос",
                "луна",
                "намаляваща",
                "намаляваща полупълна Луна",
                "полупълна",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ক\u{9cd}ষীয\u{9bc}ম\u{9be}ণ অর\u{9cd}ধ\u{9be}ধিক চ\u{9be}\u{981}দ"),
            keywords: &[
                "অর\u{9cd}ধ\u{9be}ধিক",
                "আবহ\u{9be}ওয\u{9bc}\u{9be}",
                "ক\u{9cd}ষীয\u{9bc}ম\u{9be}ণ",
                "চ\u{9be}\u{981}দ",
                "মহ\u{9be}ক\u{9be}শ",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("loar vras an digresk"),
            keywords: &["loar", "loar vras an digresk"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("padajući mjesec"),
            keywords: &["mjesec", "mjesečeve mijene", "padajući mjesec"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("lluna gibosa minvant"),
            keywords: &["gibosa", "lluna", "minvant"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎩᏄᏘᏗ ᎠᏟᎵᏒ ᏅᏓ ᎤᏒ ᎡᎯ"),
            keywords: &["ᎠᎦᏘᏏ ᎠᏲᎶᎦ", "ᎠᏲᎶᎦ", "ᎩᏄᏘᏗ ᎠᏟᎵᏒ ᏅᏓ ᎤᏒ ᎡᎯ", "ᏅᏓ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("ubývající měsíc po úplňku"),
            keywords: &[
                "couvající",
                "couvá",
                "fáze měsíce",
                "měsíc",
                "ubývající",
                "ubývající měsíc po úplňku",
                "ubývá",
                "vesmír",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("lleuad amgrwm ar ei chil"),
            keywords: &["gofod", "llawn", "lleuad", "lleuad amgrwm ar ei chil"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("aftagende måne næsten fuld"),
            keywords: &["aftagende måne næsten fuld", "måne", "månefase"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("drittes Mondviertel"),
            keywords: &["Mond", "abnehmend", "drittes Mondviertel"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("φθίνων αμφίκυρτος"),
            keywords: &["αμφίκυρτος", "διάστημα", "καιρός", "φεγγάρι", "φθίνων"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("waning gibbous moon"),
            keywords: &["gibbous", "moon", "waning"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("luna gibosa menguante"),
            keywords: &["gibosa", "luna", "menguante"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["clima", "espacio", "gibosa", "luna", "menguante"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["espacio", "fase lunar", "gibosa", "luna", "menguante"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["gibosa", "luna", "menguante"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kahanev kuu"),
            keywords: &["ilm", "kahanev", "kosmos", "kuu"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("ilbehera-hasiera"),
            keywords: &["ilargia", "ilbehera", "ilbehera-hasiera", "konkorra"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("کوژماه کاهنده"),
            keywords: &[
                "افول",
                "تحدب",
                "فضا",
                "ماه",
                "محاق",
                "محدب کاهنده",
                "کوژماه کاهنده",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("vähenevä puolikuu"),
            keywords: &[
                "kuu",
                "sää",
                "taivaankappale",
                "vähenevä",
                "vähenevä puolikuu",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("waning gibbous moon"),
            keywords: &[
                "buwan",
                "gibbous",
                "kalawakan",
                "waning",
                "waning gibbous moon",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("stórur minkandi hálvmáni"),
            keywords: &["hálvmáni", "minkandi", "máni", "stórur minkandi hálvmáni"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("lune gibbeuse décroissante"),
            keywords: &["lune", "lune gibbeuse décroissante"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &[
                "gibbeuse décroissante",
                "lune",
                "lune gibbeuse décroissante",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("gealach scothlán atá ag caitheamh"),
            keywords: &[
                "gealach",
                "gealach ag caitheamh",
                "gealach ag dul ar gcúl",
                "gealach scothlán atá ag caitheamh",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("gealach chrotach a’ traoghadh"),
            keywords: &[
                "briseadh",
                "crotach",
                "gealach",
                "gealach chrotach a’ traoghadh",
                "traoghadh",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("lúa xibosa minguante"),
            keywords: &["lúa", "minguante", "xibosa"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ઘટતો ચ\u{a82}દ\u{acd}ર"),
            keywords: &[
                "અર\u{acd}ધ ચ\u{a82}દ\u{acd}ર",
                "ઘટતો",
                "ચ\u{a82}દ\u{acd}ર",
                "બહિર\u{acd}ગોળ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("wata wucewa rabi mai ragewa"),
            keywords: &[
                "mai ragewa",
                "wata",
                "wata wucewa rabi mai ragewa",
                "wucewa rabi",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("ירח מתחיל להתרוקן"),
            keywords: &["חלל", "ירח", "ירח מתחיל להתרוקן", "סהר"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("घटता चा\u{901}द"),
            keywords: &[
                "क\u{941}बड\u{93c}ा",
                "घटता चा\u{901}द",
                "घटता ह\u{941}आ",
                "चा\u{901}द",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("mjesec opadajuće prve četvrti"),
            keywords: &[
                "mjesec",
                "mjesec opadajuće prve četvrti",
                "opadanje",
                "svemir",
                "vrijeme",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("fogyó domború hold"),
            keywords: &["domború", "fogyó domború hold", "hold", "holdfázisok", "ég"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("նվազող ուռուցիկ լուսին"),
            keywords: &["եղանակ", "լուսին", "նվազող", "ուռուցիկ", "տիեզերք"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("bulan cembung akhir"),
            keywords: &[
                "angkasa",
                "bulan",
                "bulan cembung akhir",
                "cembung",
                "cuaca",
                "mengecil",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("imelata ọnwa ọkara"),
            keywords: &["imelata", "imelata ọnwa ọkara", "ọkara ọnwa", "ọnwa"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("minnkandi tungl (meira en hálft)"),
            keywords: &[
                "minnkandi",
                "minnkandi tungl (meira en hálft)",
                "máni",
                "tungl",
                "ávalt tungl",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("luna gibbosa calante"),
            keywords: &["calante", "gibbosa", "luna"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("寝待月"),
            keywords: &["寝待月", "居待月", "月"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("bulan ilang seprapat"),
            keywords: &[
                "bulan",
                "bulan ilang seprapat",
                "padhange ilang sithik-sithik",
                "padhange meh kebak",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მცხრალი განათებული მთვარე"),
            keywords: &[
                "ამინდი",
                "კოსმოსი",
                "მთვარე",
                "მცხრალი",
                "მცხრალი განათებული მთვარე",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("кішірейіп жатқан дөңес ай"),
            keywords: &[
                "ай",
                "ауа райы",
                "дөңес",
                "кішірейіп жатқан",
                "кішірейіп жатқан дөңес ай",
                "ғарыш",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("aftagende måne næsten fuld"),
            keywords: &["aftagende måne næsten fuld", "måne", "månefase"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ព\u{17d2}រះចន\u{17d2}ទបាត\u{17cb}ម\u{17bd}យច\u{17c6}ន\u{17b7}ត"),
            keywords: &[
                "ព\u{17d2}រះចន\u{17d2}ទបាត\u{17cb}ម\u{17bd}យច\u{17c6}ណ\u{17b7}តត\u{17bc}ច",
                "ព\u{17d2}រះចន\u{17d2}ទបាត\u{17cb}ម\u{17bd}យច\u{17c6}ន\u{17b7}ត",
                "ព\u{17d2}រះច\u{17d0}ន\u{17d2}ទ",
                "រនោច",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕ\u{ccd}ಷೀಣ\u{cbf}ಸುತ\u{ccd}ತ\u{cbf}ರುವ ಚಂದ\u{ccd}ರ"),
            keywords: &[
                "ಕ\u{ccd}ಷೀಣ\u{cbf}ಸುತ\u{ccd}ತ\u{cbf}ರುವ ಚಂದ\u{ccd}ರ",
                "ಕ\u{ccd}ಷೀಣ\u{cbf}ಸುವ",
                "ಚಂದ\u{ccd}",
                "ಪೀನ",
                "ಪೀನ ಚಂದ\u{ccd}ರ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("하현달"),
            keywords: &["달", "하현달"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("उणावपी च\u{902}द\u{94d}रकळ\u{947}चो अर\u{94d}दच\u{902}द\u{94d}र"),
            keywords: &[
                "अर\u{94d}दच\u{902}द\u{94d}र",
                "उणावपी च\u{902}द\u{94d}रकळा",
                "उणावपी च\u{902}द\u{94d}रकळ\u{947}चो अर\u{94d}दच\u{902}द\u{94d}र",
                "च\u{902}द\u{94d}र",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("бөксөрүп баштаган ай"),
            keywords: &[
                "аба ырайы",
                "ай",
                "бөксөрүп баштаган",
                "бөксөрүп баштаган ай",
                "космос",
            ],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Séchelmound am drëtte Véierel"),
            keywords: &[
                "Mound",
                "Séchelmound",
                "Séchelmound am drëtte Véierel",
                "drëtte Véierel",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເດ\u{eb7}ອນດ\u{eb1}ບສ\u{ec9}ຽວດວງ"),
            keywords: &[
                "ສ\u{ec9}ຽວດວງ",
                "ເດ\u{eb7}ອນດ\u{eb1}ບ",
                "ເດ\u{eb7}ອນດ\u{eb1}ບສ\u{ec9}ຽວດວງ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("delčia"),
            keywords: &["delčia", "dylantis", "mėnulis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("izliekts dilstošs mēness"),
            keywords: &["dilstošs", "izliekts", "mēness"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("marama roroku"),
            keywords: &["kipuha", "marama", "roroku"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("прва фаза на затемнување"),
            keywords: &[
                "вселена",
                "затемнување",
                "месечина",
                "прва",
                "прва фаза на затемнување",
            ],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("തെളിഞ\u{d4d}ഞ\u{d41}വര\u{d41}ന\u{d4d}ന ചന\u{d4d}ദ\u{d4d}രക\u{d4d}കല"),
            keywords: &[
                "ചന\u{d4d}ദ\u{d4d}രക\u{d4d}കല",
                "ചന\u{d4d}ദ\u{d4d}രൻ",
                "തെളിഞ\u{d4d}ഞ\u{d41}വര\u{d41}ന\u{d4d}ന ചന\u{d4d}ദ\u{d4d}രക\u{d4d}കല",
                "വളഞ\u{d4d}ഞ ചന\u{d4d}ദ\u{d4d}രൻ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("бүтэн сарын дараах сар"),
            keywords: &["бүтэн сарын дараах сар", "гүдгэр сар", "сар"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("पाऊण प\u{94d}रकाशित होणारा च\u{902}द\u{94d}र"),
            keywords: &[
                "कमी प\u{94d}रकाशित होणारा क\u{941}बडा च\u{902}द\u{94d}र",
                "कमी होणारा",
                "क\u{941}बडा",
                "च\u{902}द\u{94d}र",
                "पाऊण प\u{94d}रकाशित होणारा च\u{902}द\u{94d}र",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("bulan hampir purnama memalap"),
            keywords: &[
                "angkasa lepas",
                "bulan",
                "bulan hampir purnama memalap",
                "cuaca",
                "hampir purnama",
                "memalap",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("qamar akbar minn nofs li qed jonqos"),
            keywords: &[
                "akbar minn nofs",
                "qamar",
                "qamar akbar minn nofs li qed jonqos",
                "qed jonqos",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("လဆ\u{102f}တ\u{103a}"),
            keywords: &["လ", "လဆ\u{102f}တ\u{103a}", "လဆ\u{102f}တ\u{103a}ရက\u{103a}"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("avtakende fullmåne"),
            keywords: &["avtakende fullmåne", "måne", "månefase", "ne"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("घट\u{94d}दो गिबस चन\u{94d}द\u{94d}रमा"),
            keywords: &[
                "गिबस",
                "घट\u{94d}दो गिबस चन\u{94d}द\u{94d}रमा",
                "चन\u{94d}द\u{94d}र\u{94d}मा",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("afnemende maan"),
            keywords: &["afnemend", "afnemende maan", "bolvormig", "maan"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("avtakande fullmåne"),
            keywords: &["avtakande fullmåne", "måne", "månefase", "ne"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some(
                "ୱେନ\u{b3f}ଂରେ ଥ\u{b3f}ବ\u{b3e} ବହ\u{b3f}ର\u{b4d}ବର\u{b4d}ତ\u{b4d}ତ ହେଉଥ\u{b3f}ବ\u{b3e} ଅପ\u{b41}ର\u{b4d}ଣଚନ\u{b4d}ଦ\u{b4d}ର",
            ),
            keywords: &[
                "ଅର\u{b4d}ଦ\u{b4d}ଧର\u{b41} ଅଧ\u{b3f}କ",
                "ଅର\u{b4d}ଦ\u{b4d}ଧର\u{b41} ଅଧ\u{b3f}କ ଚନ\u{b4d}ଦ\u{b4d}ର",
                "ଚନ\u{b4d}ଦ\u{b4d}ର",
                "ମଳ\u{b3f}ନ",
                "ୱେନ\u{b3f}ଂରେ ଥ\u{b3f}ବ\u{b3e} ବହ\u{b3f}ର\u{b4d}ବର\u{b4d}ତ\u{b4d}ତ ହେଉଥ\u{b3f}ବ\u{b3e} ଅପ\u{b41}ର\u{b4d}ଣଚନ\u{b4d}ଦ\u{b4d}ର",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਘ\u{a71}ਟਦਾ ਚ\u{a70}ਦ"),
            keywords: &[
                "ਘ\u{a71}ਟਦਾ",
                "ਚ\u{a70}ਦ",
                "ਪ\u{a41}ਲਾੜ",
                "ਮ\u{a4c}ਸਮ",
                "ਵ\u{a71}ਧਦਾ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("گھٹدا ہوئیا م\u{64f}حد\u{650}ب چاند"),
            keywords: &[
                "بے نور ہونا",
                "محدب",
                "چاند",
                "گھٹدا ہوئیا م\u{64f}حد\u{650}ب چاند",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Mun Dọ\u{301}n Stát To Go"),
            keywords: &[
                "Fọ Mun To Stát To Gò",
                "Gíbọs",
                "Mun",
                "Mun Dọ\u{301}n Stát To Go",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("zanikający księżyc między pełnią a ostatnią kwadrą"),
            keywords: &[
                "chudnący",
                "księżyc",
                "księżyc z brzuszkiem",
                "tłusty księżyc",
                "zanikający księżyc między pełnią a ostatnią kwadrą",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("کمېدونکې شاټوغې سپوږمۍ"),
            keywords: &["سپوږمۍ", "شاټوغې", "کمېدونکې"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("lua minguante convexa"),
            keywords: &["convexa", "lua", "minguante"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["convexa", "espaço", "lua", "meteorologia", "minguante"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("wañu gibosa killa"),
            keywords: &["chawpi", "gibosa", "killa", "wañu"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("lună convexă în descreștere"),
            keywords: &[
                "convexă",
                "descreștere",
                "lună",
                "lună convexă în descreștere",
                "semilună",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-221"),
            keywords: &["E10-221"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("убывающая луна"),
            keywords: &["луна", "месяц", "небо", "убывающая"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ukwezi kwikubye nk’inyonjo"),
            keywords: &["ukwezi kwikubye nk’inyonjo"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ويننگ گبوس چنڊ"),
            keywords: &["ويننگ گبوس چنڊ", "چنڊ", "ڪمزور پوڻ", "گبوس"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("අවපක\u{dca}ෂයේ අටවක සඳ"),
            keywords: &[
                "අටවක",
                "අභ\u{dca}\u{200d}යවක\u{dcf}ශය",
                "අවපක\u{dca}ෂයේ අටවක සඳ",
                "අවපස",
                "ක\u{dcf}ලග\u{dd4}ණය",
                "සඳ",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("ubúdajúci mesiac"),
            keywords: &["mesiac", "počasie", "ubúdajúci", "vesmír", "vypuklý"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("več kot polovično osvetljen zadnji krajec"),
            keywords: &[
                "luna",
                "polovično",
                "vesolje",
                "več kot polovično osvetljen zadnji krajec",
                "vreme",
                "zadnji",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("gaabinta wayninka dayaxa"),
            keywords: &[
                "dayaxa",
                "gaabinta",
                "gaabinta wayninka dayaxa",
                "weynaanta",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("hënë e ngrënë më shumë se gjysma"),
            keywords: &[
                "e ngrënë",
                "hapësirë",
                "hënë",
                "hënë e ngrënë më shumë se gjysma",
                "moti",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("месец после пуног месеца"),
            keywords: &["oпaдaњe", "месец", "месец после пуног месеца"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("мјесец послије пуног мјесеца"),
            keywords: &["мјесец послије пуног мјесеца"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("mesec posle punog meseca"),
            keywords: &["mesec", "mesec posle punog meseca", "opadanje"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("mjesec poslije punog mjeseca"),
            keywords: &["mjesec poslije punog mjeseca"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("måne i tredje kvarteret"),
            keywords: &["måne", "måne i tredje kvarteret", "tilltagande"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mwezi ulioangazwa zaidi ya nusu unaofifia"),
            keywords: &[
                "anga",
                "hali ya hewa",
                "kuisha",
                "mwezi",
                "mwezi ulioangazwa zaidi ya nusu",
                "mwezi ulioangazwa zaidi ya nusu unaofifia",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("க\u{bbe}ல\u{bcd}பகுதி தேய\u{bcd}பிறை"),
            keywords: &[
                "இரவு",
                "க\u{bbe}ல\u{bcd}பகுதி தேய\u{bcd}பிறை",
                "தேய\u{bcd}பிறை",
                "நிலவொளி",
                "நில\u{bbe}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("తరుగుతున\u{c4d}న చంద\u{c4d}రుడు"),
            keywords: &["చంద\u{c4d}రుడు", "తరుగు", "తరుగుతున\u{c4d}న చంద\u{c4d}రుడు"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("марҳилаи хурд шудани моҳ"),
            keywords: &[
                "марҳилаи моҳ",
                "марҳилаи хурд шудани моҳ",
                "моҳ",
                "хурд шудани моҳ",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ข\u{e49}างแรม"),
            keywords: &[
                "ข\u{e49}างแรม",
                "พระจ\u{e31}นทร\u{e4c}เก\u{e37}อบเต\u{e47}มดวง",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("kiçelýän aý"),
            keywords: &["aý", "kiçelýän", "ýagty aý"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("māhina lekeleka"),
            keywords: &["māhina lekeleka"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("küçülen ay"),
            keywords: &["ay", "küçülen ay", "solgun", "şişkin"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("يۈتەر چوڭ ئاي"),
            keywords: &["ئاي", "يۈتەر", "چوڭ"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("місяць у третій чверті"),
            keywords: &[
                "космос",
                "місяць",
                "місяць у третій чверті",
                "погода",
                "серпоподібний",
                "спадаючий",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("گھٹتا ہوا آدھے سے زیادہ چاند"),
            keywords: &["موسم", "چاند", "گھٹتا ہوا", "گھٹتا ہوا آدھے سے زیادہ چاند"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("kichiklashib borayotgan qavariq oy"),
            keywords: &[
                "kichiklashib borayotgan qavariq oy",
                "kichrayib borayotgan",
                "koinot",
                "ob-havo",
                "oy",
                "qavariq",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("trăng khuyết cuối tháng"),
            keywords: &[
                "cuối tháng",
                "mặt trăng",
                "trăng khuyết",
                "trăng khuyết cuối tháng",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("weer wu sew buy yokk"),
            keywords: &["sew", "weer", "weer wu sew buy yokk", "yokk"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("inyanga eliceba ethwasayo"),
            keywords: &["eliceba", "ethwasayo", "inyanga"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Títàn Kíkún Oṣùpá"),
            keywords: &["Kíkún", "Oṣùpá", "Títàn"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("虧凸月"),
            keywords: &["月", "突起", "虧", "虧凸月"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("亏凸月"),
            keywords: &["亏", "亏凸月", "月", "突起"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("亏凸月"),
            keywords: &["亏凸月", "月亮"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("虧凸月"),
            keywords: &["漸盈月", "虧凸月"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["凸月", "月亮", "虧凸月"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("inyanga ebheke emuva enciphile"),
            keywords: &[
                "inyanga",
                "inyanga ebheke emuva enciphile",
                "isimo sezulu",
                "ukubheka emuva",
                "ukuncipha",
                "umkhathi",
            ],
        },
    ],
};
#[doc = "🌗"]
pub const LAST_QUARTER_MOON: crate::Emoji = crate::Emoji {
    glyph: "🌗",
    codepoint: "1F317",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "last quarter moon",
    group: "Travel & Places",
    subgroup: "sky & weather",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("laastekwartiermaan"),
            keywords: &[
                "kwartier",
                "laaste",
                "laastekwartiermaan",
                "maan",
                "ruimte",
                "weer",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የመጨረሻ ሩብ ጨረቃ"),
            keywords: &["ህዋ", "ሩብ", "የመጨረሻ ሩብ ጨረቃ", "የአየር ንብረት", "ጨረቃ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("تربيع ثان"),
            keywords: &["تربيع", "تربيع ثان", "طقس", "فضاء", "قمر"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("চন\u{9cd}দ\u{9cd}ৰৰ অন\u{9cd}তিম চত\u{9c1}ৰ\u{9cd}থ\u{9be}ংশ"),
            keywords: &[
                "চত\u{9c1}ৰ\u{9cd}থ\u{9be}ংশ",
                "চন\u{9cd}দ\u{9cd}ৰ",
                "চন\u{9cd}দ\u{9cd}ৰৰ অন\u{9cd}তিম চত\u{9c1}ৰ\u{9cd}থ\u{9be}ংশ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("ayın sonuncu dörddə bir hissəsi"),
            keywords: &[
                "ay",
                "ayın sonuncu dörddə bir hissəsi",
                "dörddə bir",
                "hava",
                "kosmos",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("апошняя чвэрць"),
            keywords: &[
                "апошняя",
                "квадра",
                "космас",
                "месяц",
                "ноч",
                "палова",
                "сход",
                "трэцяя",
                "чвэрць",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("последна четвърт на Луната"),
            keywords: &[
                "време",
                "космос",
                "луна",
                "последна четвърт на Луната",
                "четвърт",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("চ\u{9be}\u{981}দের শেষ চত\u{9c1}র\u{9cd}থ\u{9be}ংশ"),
            keywords: &[
                "আবহ\u{9be}ওয\u{9bc}\u{9be}",
                "চত\u{9c1}র\u{9cd}থ\u{9be}ংশ",
                "চ\u{9be}\u{981}দ",
                "চ\u{9be}\u{981}দের শেষ চত\u{9c1}র\u{9cd}থ\u{9be}ংশ",
                "মহ\u{9be}ক\u{9be}শ",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("hanterloar an digresk"),
            keywords: &["hanterloar", "hanterloar an digresk", "loar"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("zadnja četvrtina"),
            keywords: &["mjesec", "mjesečeve mijene", "zadnja četvrtina"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("lluna en l’últim quart minvant"),
            keywords: &[
                "lluna",
                "lluna en l’últim quart minvant",
                "minvant",
                "quart",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎣᏂᎢ ᎩᏄᏘᏗ ᏅᏓ ᎤᏒ ᎡᎯ"),
            keywords: &["ᎣᏂᎢ ᎩᏄᏘᏗ ᏅᏓ ᎤᏒ ᎡᎯ", "ᎩᏄᏘᏗ", "ᏅᏓ ᎤᏒ ᎡᎯ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("měsíc v poslední čtvrti"),
            keywords: &[
                "couvající",
                "couvá",
                "fáze měsíce",
                "měsíc",
                "měsíc v poslední čtvrti",
                "ubývající",
                "ubývá",
                "vesmír",
                "čtvrť",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("lleuad chwarter olaf"),
            keywords: &["amgrwm", "gofod", "lleuad", "lleuad chwarter olaf"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("halvmåne 4. fjerdedel"),
            keywords: &[
                "halvmåne 4. fjerdedel",
                "måne",
                "månefase",
                "sidste kvarter måne",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("abnehmender Halbmond"),
            keywords: &["Halbmond", "abnehmend", "abnehmender Halbmond"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("σελήνη τελευταίου τετάρτου"),
            keywords: &["σελήνη", "σελήνη τελευταίου τετάρτου", "τέταρτο", "φεγγάρι"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("last quarter moon"),
            keywords: &["last quarter moon", "moon", "quarter"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: Some("last-quarter moon"),
            keywords: &["last-quarter moon"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("luna en cuarto menguante"),
            keywords: &["cuarto", "luna", "luna en cuarto menguante", "menguante"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &[
                "clima",
                "cuarto",
                "espacio",
                "luna",
                "luna en cuarto menguante",
                "menguante",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &[
                "cuarto",
                "espacio",
                "fase lunar",
                "luna",
                "luna en cuarto menguante",
                "menguante",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["cuarto", "luna", "luna en cuarto menguante"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kahanev poolkuu"),
            keywords: &["ilm", "kahanev poolkuu", "kosmos", "kuu", "poolkuu"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("ilbehera-erdia"),
            keywords: &["eguraldi", "espazio", "ilargi", "ilbehera-erdia"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("یک\u{200c}چهارم پایان"),
            keywords: &[
                "آب\u{200c}وهوا",
                "آخر",
                "انتها",
                "تربیع",
                "فضا",
                "یک\u{200c}چهارم آخر",
                "یک\u{200c}چهارم پایان",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("viimeinen neljänneskuu"),
            keywords: &[
                "kuu",
                "puolikuu",
                "sää",
                "taivaankappale",
                "viimeinen neljänneskuu",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("last quarter moon"),
            keywords: &[
                "buwan",
                "kalawakan",
                "last quarter",
                "last quarter moon",
                "quarter",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("minkandi hálvmáni"),
            keywords: &["hálvmáni", "minkandi", "máni"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("dernier quartier"),
            keywords: &["dernier quartier", "lune"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("dernier quartier de lune"),
            keywords: &["dernier quartier", "dernier quartier de lune", "lune"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("ceathrú deireanach na gealaí"),
            keywords: &[
                "ceathrú",
                "ceathrú deireanach na gealaí",
                "gealach",
                "gealach ina ceathrú dheireanach",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("deireadh na gealaich"),
            keywords: &[
                "ceathramh",
                "deireadh na gealaich",
                "gealach",
                "gealach sa cheathramh mu dheireadh",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("lúa en cuarto minguante"),
            keywords: &["cuarto", "lúa", "lúa en cuarto minguante", "minguante"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("છ\u{ac7}લ\u{acd}લી ત\u{acd}રિમાસીનો ચ\u{a82}દ\u{acd}ર"),
            keywords: &[
                "અ\u{a82}તિમ ત\u{acd}રિમાસી ચ\u{a82}દ\u{acd}ર",
                "ચ\u{a82}દ\u{acd}ર",
                "છ\u{ac7}લ\u{acd}લી ત\u{acd}રિમાસીનો ચ\u{a82}દ\u{acd}ર",
                "ત\u{acd}રિમાસી",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("wata na ƙarshen kwata"),
            keywords: &["kwata", "wata", "wata na ƙarshen kwata"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("חצי ירח מתרוקן"),
            keywords: &[
                "חצי ירח מתרוקן",
                "ירח",
                "ירח רבעון אחרון",
                "רבעון",
                "שבוע אחרון",
            ],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("श\u{941}क\u{94d}ल पक\u{94d}ष अर\u{94d}धच\u{902}द\u{94d}र"),
            keywords: &[
                "आधा चा\u{901}द",
                "चा\u{901}द",
                "चौथाई",
                "श\u{941}क\u{94d}ल पक\u{94d}ष अर\u{94d}धच\u{902}द\u{94d}र",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("mjesec posljednje četvrti"),
            keywords: &[
                "mjesec",
                "mjesec posljednje četvrti",
                "svemir",
                "vrijeme",
                "četvrt",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("utolsó negyedben lévő hold"),
            keywords: &[
                "hold",
                "holdfázisok",
                "utolsó negyed",
                "utolsó negyedben lévő hold",
                "ég",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("լուսինը երկրորդ քառորդում"),
            keywords: &[
                "եղանակ",
                "լուսին",
                "լուսինը երկրորդ քառորդում",
                "տիեզերք",
                "քառորդ",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("bulan perbani akhir"),
            keywords: &[
                "angkasa",
                "bulan",
                "bulan perbani akhir",
                "cuaca",
                "seperempat",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ọnwa ikpeazu nke ọgwụgwụ-afọ"),
            keywords: &[
                "mbụ nke mmalite-afọ",
                "ọnwa",
                "ọnwa ikpeazu nke ọgwụgwụ-afọ",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("síðasta kvartil"),
            keywords: &["hálfmáni", "kvartil", "máni", "síðasta kvartil", "tungl"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("ultimo quarto di luna"),
            keywords: &["luna", "quarto", "ultimo quarto di luna"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("下弦の月"),
            keywords: &["下弦", "下弦の月", "半月", "月"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("bulan peteng separo"),
            keywords: &["bulan", "bulan peteng separo", "separo"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მთვარის ბოლო მეოთხედი"),
            keywords: &[
                "ამინდი",
                "კოსმოსი",
                "მეოთხედი",
                "მთვარე",
                "მთვარის ბოლო მეოთხედი",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("айдың соңғы ширегі"),
            keywords: &["ай", "айдың соңғы ширегі", "ауа райы", "ширек", "ғарыш"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("halvmåne sidste kvarter"),
            keywords: &[
                "halvmåne sidste kvarter",
                "måne",
                "månefase",
                "sidste kvarter måne",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ព\u{17d2}រះចន\u{17d2}ទបាត\u{17cb}អស\u{17cb}៣ភាគ៤"),
            keywords: &[
                "ព\u{17d2}រះចន\u{17d2}ទបាត\u{17cb}អស\u{17cb}៣ភាគ៤",
                "ព\u{17d2}រះច\u{17d0}ន\u{17d2}ទ",
                "ម\u{17bd}យច\u{17c6}ន\u{17b7}ត",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕೊನ\u{cc6}ಯ ಕಾಲುಭಾಗದಷ\u{ccd}ಟು ಚಂದ\u{ccd}ರ"),
            keywords: &[
                "ಕಳ\u{cc6}ದ ಕಾಲುಭಾಗದಷ\u{ccd}ಟ\u{cbf}ರುವ ಚಂದ\u{ccd}ರ",
                "ಕಾಲುಭಾಗ",
                "ಕೊನ\u{cc6}ಯ ಕಾಲುಭಾಗದಷ\u{ccd}ಟು ಚಂದ\u{ccd}ರ",
                "ಚಂದ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("왼쪽 반달"),
            keywords: &["달", "왼쪽 반달"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some(
                "प\u{941}नव\u{947}उपरा\u{902}तच\u{94d}या प\u{902}द\u{94d}रशीच\u{947}\u{902} निमाण\u{947}\u{902} चार दिस",
            ),
            keywords: &[
                "च\u{902}द\u{94d}र",
                "निमाण\u{947}\u{902} चार दिस",
                "प\u{941}नव\u{947}उपरा\u{902}तची प\u{902}दरस",
                "प\u{941}नव\u{947}उपरा\u{902}तच\u{94d}या प\u{902}द\u{94d}रशीच\u{947}\u{902} निमाण\u{947}\u{902} चार दिस",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("жартысы бөксөргөн ай"),
            keywords: &["аба ырайы", "ай", "жарты", "жартысы бөксөргөн ай", "космос"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("ofhuelenden Hallefmound"),
            keywords: &["Hallef", "Mound", "Véierel", "ofhuelenden Hallefmound"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເດ\u{eb7}ອນດ\u{eb1}ບເຄ\u{eb4}\u{ec8}ງດວງ"),
            keywords: &[
                "ເຄ\u{eb4}\u{ec8}ງດວງ",
                "ເດ\u{eb7}ອນດ\u{eb1}ບ",
                "ເດ\u{eb7}ອນດ\u{eb1}ບເຄ\u{eb4}\u{ec8}ງດວງ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("paskutinis fazės ketvirtis"),
            keywords: &["ketvirtis", "mėnulis", "paskutinis fazės ketvirtis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("dilstošs pusmēness"),
            keywords: &["dilstošs", "mēness", "pusmēness"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("marama korekore"),
            keywords: &["hauwhā", "marama", "marama korekore"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("последна четвртина"),
            keywords: &["време", "вселена", "месечина", "последна", "четвртина"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("അർദ\u{d4d}ധ അമ\u{d3e}വ\u{d3e}സി"),
            keywords: &[
                "അർദ\u{d4d}ധ അമ\u{d3e}വ\u{d3e}സി",
                "ചന\u{d4d}ദ\u{d4d}രക\u{d4d}കല",
                "ചന\u{d4d}ദ\u{d4d}രൻ",
                "വളഞ\u{d4d}ഞ ചന\u{d4d}ദ\u{d4d}രൻ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("сүүлийн улирлын сар"),
            keywords: &[
                "сар",
                "сүүлийн",
                "сүүлийн улирлын сар",
                "улирал",
                "цаг агаар",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("क\u{943}ष\u{94d}ण पक\u{94d}षातील च\u{902}द\u{94d}र"),
            keywords: &[
                "क\u{943}ष\u{94d}ण पक\u{94d}षातील च\u{902}द\u{94d}र",
                "च\u{902}द\u{94d}र",
                "चत\u{941}र\u{94d}थी",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("bulan suku terakhir"),
            keywords: &[
                "angkasa lepas",
                "bulan",
                "bulan suku terakhir",
                "cuaca",
                "suku",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("l-aħħar kwart tal-qamar"),
            keywords: &["kwart", "l-aħħar kwart tal-qamar", "qamar"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("လ၏ နောက\u{103a}ဆ\u{102f}\u{1036}းအပတ\u{103a}"),
            keywords: &[
                "လ",
                "လေးပ\u{102f}\u{1036}တစ\u{103a}ပ\u{102f}\u{1036}",
                "လ၏ နောက\u{103a}ဆ\u{102f}\u{1036}းအပတ\u{103a}",
                "လ၏ နောင\u{103a}ဆ\u{102f}\u{1036}းအပတ\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("avtakende halvmåne"),
            keywords: &[
                "avtakende halvmåne",
                "halvmåne",
                "måne",
                "månefase",
                "ne",
                "siste kvarter",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("अन\u{94d}तिम पक\u{94d}षीय चन\u{94d}द\u{94d}रमा"),
            keywords: &[
                "अन\u{94d}तिम पक\u{94d}षीय चन\u{94d}द\u{94d}रमा",
                "एक चौ\u{902}थाइ",
                "चन\u{94d}द\u{94d}रमा",
                "ठाउ\u{901}",
                "मौ\u{902}सम",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("maan in laatste kwartier"),
            keywords: &["kwartier", "maan", "maan in laatste kwartier"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("avtakande halvmåne"),
            keywords: &[
                "avtakande halvmåne",
                "halvmåne",
                "måne",
                "månefase",
                "ne",
                "siste kvarter",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଶେଷ ଚତ\u{b41}ର\u{b4d}ଥ\u{b3e}ଂଶ ଚନ\u{b4d}ଦ\u{b4d}ର"),
            keywords: &[
                "ଅର\u{b4d}ଦ\u{b4d}ଧ ଚନ\u{b4d}ଦ\u{b4d}ର",
                "କ\u{b43}ଷ\u{b4d}ଣପକ\u{b4d}ଷ ଚନ\u{b4d}ଦ\u{b4d}ର",
                "ଚନ\u{b4d}ଦ\u{b4d}ର",
                "ଶେଷ ଚତ\u{b41}ର\u{b4d}ଥ\u{b3e}ଂଶ ଚନ\u{b4d}ଦ\u{b4d}ର",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਆਖਰੀ ਤਿਮਾਹੀ ਚ\u{a70}ਦ"),
            keywords: &[
                "ਆਖਰੀ ਤਿਮਾਹੀ ਚ\u{a70}ਦ",
                "ਚ\u{a70}ਦ",
                "ਤਿਮਾਹੀ",
                "ਪਿਛਲਾ ਤਿਮਾਹੀ ਚ\u{a70}ਦ",
                "ਪ\u{a41}ਲਾੜ",
                "ਮ\u{a4c}ਸਮ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("چاند دا آخری چوتھائی حصہ"),
            keywords: &["چاند", "چاند دا آخری چوتھائی حصہ", "چوتھہ حص\u{651}ہ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Mun Im Lást Kwọ\u{301}ta"),
            keywords: &["Kwọ\u{301}ta", "Mun", "Mun Im Lást Kwọ\u{301}ta"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("ostatnia kwadra księżyca"),
            keywords: &["księżyc", "kwadra", "ostatnia kwadra księżyca"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د ورستۍ ربع سپوږمۍ"),
            keywords: &["د ورستۍ ربع سپوږمۍ", "ربع", "سپوږمۍ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("quarto minguante"),
            keywords: &[
                "lua",
                "lua de quarto minguante",
                "quarto",
                "quarto minguante",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("lua em quarto minguante"),
            keywords: &[
                "espaço",
                "lua",
                "lua em quarto minguante",
                "meteorologia",
                "minguante",
                "quatro",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("qhipa wañu killa"),
            keywords: &["hukñiqi wañu", "killa", "qhipa wañu killa"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("lună în ultimul pătrar"),
            keywords: &["lună", "lună în ultimul pătrar", "patru", "pătrar"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-222"),
            keywords: &["E10-222"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("луна в последней четверти"),
            keywords: &[
                "луна",
                "луна в последней четверти",
                "месяц",
                "небо",
                "четверть",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("icya kane cya nyuma cy’ukwezi"),
            keywords: &["icya kane cya nyuma cy’ukwezi", "icyakane", "ukwezi"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("آخري عشري جو چنڊ"),
            keywords: &["آخري عشري جو چنڊ", "عشرو", "چنڊ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("අවසන\u{dca} චත\u{dd4}ර\u{dca}ථක සඳ"),
            keywords: &[
                "අභ\u{dca}\u{200d}යවක\u{dcf}ශය",
                "අවසන\u{dca} චත\u{dd4}ර\u{dca}ථක සඳ",
                "ක\u{dcf}ලග\u{dd4}ණය",
                "චත\u{dd4}ර\u{dca}ථක",
                "සඳ",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("posledná štvrť mesiaca"),
            keywords: &[
                "mesiac",
                "posledná štvrť mesiaca",
                "počasie",
                "vesmír",
                "štvrť",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("polovično osvetljena luna v zadnjem krajcu"),
            keywords: &[
                "luna",
                "polovično osvetljena luna v zadnjem krajcu",
                "vesolje",
                "vreme",
                "četrt",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("rubaca dambe ee dayaxa"),
            keywords: &["dayax", "rubac", "rubaca dambe ee dayaxa"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("hëna e çerekut të fundit"),
            keywords: &[
                "hapësirë",
                "hëna e çerekut të fundit",
                "hënë",
                "moti",
                "çerek",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("месец у последњој четврти"),
            keywords: &["месец", "месец у последњој четврти", "чeтврт"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("мјесец у посљедњој четврти"),
            keywords: &["мјесец у посљедњој четврти"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("mesec u poslednjoj četvrti"),
            keywords: &["mesec", "mesec u poslednjoj četvrti", "četvrt"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("mjesec u posljednjoj četvrti"),
            keywords: &["mjesec u posljednjoj četvrti"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("avtagande halvmåne"),
            keywords: &["avtagande halvmåne", "avtagande måne", "halvmåne", "måne"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mwezi wa robo ya mwisho"),
            keywords: &[
                "anga",
                "hali ya hewa",
                "mwezi",
                "mwezi wa robo ya mwisho",
                "robo",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("அரைப\u{bbe}தி தேய\u{bcd}பிறை"),
            keywords: &[
                "அரைநிலவு",
                "அரைப\u{bbe}தி தேய\u{bcd}பிறை",
                "இரவு",
                "தேய\u{bcd}பிறை",
                "நில\u{bbe}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("చ\u{c3f}వర\u{c3f} న\u{c3e}లుగవ వంతు చంద\u{c4d}రుడు"),
            keywords: &[
                "చంద\u{c4d}రుడు",
                "చ\u{c3f}వర\u{c3f} న\u{c3e}లుగవ వంతు చంద\u{c4d}రుడు",
                "న\u{c3e}లుగవ",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("марҳилаи чоряки охири моҳ"),
            keywords: &["марҳилаи чоряки охири моҳ", "моҳ", "чоряк"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("พระจ\u{e31}นทร\u{e4c}คร\u{e36}\u{e48}งซ\u{e35}กซ\u{e49}าย"),
            keywords: &[
                "คร\u{e36}\u{e48}งซ\u{e35}ก",
                "พระจ\u{e31}นทร\u{e4c}",
                "พระจ\u{e31}นทร\u{e4c}คร\u{e36}\u{e48}งซ\u{e35}กซ\u{e49}าย",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("soňky çärýek aý"),
            keywords: &["aý", "soňky çärýek aý", "çarýek"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("māhina tuʻu hengihengi"),
            keywords: &["māhina tuʻu hengihengi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("son dördün"),
            keywords: &["ay", "dördün", "son dördün"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئاخىرقى چارەك ئاي"),
            keywords: &["ئاخىرقى چارەك ئاي", "ئاي", "چارەك"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("остання чверть місяця"),
            keywords: &[
                "космос",
                "місяць",
                "остання чверть місяця",
                "погода",
                "чверть",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("آخری کوارٹر کا چاند"),
            keywords: &["آخری کوارٹر کا چاند", "موسم", "چاند", "کوارٹر"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("oxirgi chorakdagi oy"),
            keywords: &["chorak", "koinot", "ob-havo", "oxirgi chorakdagi oy", "oy"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("trăng hạ huyền"),
            keywords: &["mặt trăng", "phần tư", "trăng hạ huyền"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("xaaju weer wu mujj"),
            keywords: &["weer wu njëkk", "xaaj", "xaaju weer wu mujj"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("inyanga yekota yokugqibela"),
            keywords: &["ikota", "inyanga", "inyanga yekota yokugqibela"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Oṣùpá Ìlàrin Ìgbẹ\u{300}yìn"),
            keywords: &["Oṣùpá Ìlàrin Ìgbẹ\u{300}yìn", "ìdámẹ\u{301}rin", "òṣùpá"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("下弦月"),
            keywords: &["下弦月", "四分之一", "月"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("下弦月"),
            keywords: &["下弦月", "四分之一", "月"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("下弦月"),
            keywords: &["下弦月", "月亮"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("下弦月"),
            keywords: &["下弦月", "月亮"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("inyanga yekota yokugcina"),
            keywords: &[
                "ikota",
                "inyanga",
                "inyanga yekota yokugcina",
                "isimo sezulu",
                "umkhathi",
            ],
        },
    ],
};
#[doc = "🌘"]
pub const WANING_CRESCENT_MOON: crate::Emoji = crate::Emoji {
    glyph: "🌘",
    codepoint: "1F318",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "waning crescent moon",
    group: "Travel & Places",
    subgroup: "sky & weather",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("afnemende sekelmaan"),
            keywords: &[
                "afneem",
                "afnemende sekelmaan",
                "maan",
                "ruimte",
                "sekel",
                "weer",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("በግራ በኩል ትንሽ የበራች ግማሽ ጨረቃ"),
            keywords: &[
                "ህዋ",
                "በግራ በኩል ትንሽ የበራች ግማሽ ጨረቃ",
                "የአየር ንብረት",
                "የደበዘዘ",
                "ግማሽ ጨረቃ",
            ],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("هلال آخر الشهر"),
            keywords: &["طقس", "فضاء", "قمر", "متناقص", "هلال", "هلال آخر الشهر"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ক\u{9cd}ষীয\u{9bc}ম\u{9be}ন অৰ\u{9cd}ধচন\u{9cd}দ\u{9cd}ৰ"),
            keywords: &[
                "অৰ\u{9cd}ধচন\u{9cd}দ\u{9cd}ৰ",
                "ক\u{9cd}ষীয\u{9bc}ম\u{9be}ন",
                "চন\u{9cd}দ\u{9cd}ৰ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("sönən aypara"),
            keywords: &["ay", "aypara", "hava", "kosmos", "sönən"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("змяншэнне сярпа"),
            keywords: &[
                "ветах",
                "змяншэнне сярпа",
                "космас",
                "месяц",
                "ноч",
                "серп",
                "стары",
                "убыванне",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("намаляващ полумесец на Луната"),
            keywords: &[
                "космос",
                "луна",
                "намаляващ",
                "намаляващ полумесец на Луната",
                "полумесец",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ক\u{9cd}ষীয\u{9bc}ম\u{9be}ণ অর\u{9cd}ধচন\u{9cd}দ\u{9cd}র"),
            keywords: &[
                "অর\u{9cd}ধচন\u{9cd}দ\u{9cd}র",
                "আবহ\u{9be}ওয\u{9bc}\u{9be}",
                "ক\u{9cd}ষীয\u{9bc}ম\u{9be}ণ",
                "চ\u{9be}\u{981}দ",
                "মহ\u{9be}ক\u{9be}শ",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("loar vihan an digresk"),
            keywords: &["loar", "loar vihan an digresk"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("do mladog mjeseca"),
            keywords: &["do mladog mjeseca", "mjesec", "mjesečeve mijene"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("lluna minvant"),
            keywords: &["lluna", "minvant"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᎦᏍᎦᏂᏗᏜ ᏅᏓ ᎤᏒ ᎡᎯ"),
            keywords: &["ᎠᎦᏍᎦᏂᏗᏜ ᏅᏓ ᎤᏒ ᎡᎯ", "ᎠᏓᏲᎲ", "ᎠᏲᎶᎦ ᎠᎦᏘᏏ", "ᏅᏓ ᎤᏒ ᎡᎯ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("ubývající měsíc před novoluním"),
            keywords: &[
                "couvající",
                "couvá",
                "fáze měsíce",
                "měsíc",
                "srpek",
                "ubývající",
                "ubývající měsíc před novoluním",
                "ubývá",
                "vesmír",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("lleuad cilgant ar ei chil"),
            keywords: &["chwarter", "gofod", "lleuad", "lleuad cilgant ar ei chil"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("aftagende måne"),
            keywords: &["aftagende måne", "måne", "månefase"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("letztes Mondviertel"),
            keywords: &["Mond", "abnehmend", "letztes Mondviertel"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("φθίνων μηνίσκος"),
            keywords: &["διάστημα", "καιρός", "μηνίσκος", "φεγγάρι", "φθίνων"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("waning crescent moon"),
            keywords: &["crescent", "moon", "waning"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("luna menguante"),
            keywords: &["luna", "menguante"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("luna creciente menguante"),
            keywords: &["clima", "creciente", "luna", "menguante"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["creciente", "fase lunar", "luna", "menguante"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["creciene", "luna", "luna creciente menguante", "menguante"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kahanev kuusirp"),
            keywords: &["ilm", "kahanev", "kahanev kuusirp", "kosmos", "kuu", "sirp"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("ilbehera-bukaera"),
            keywords: &[
                "eguraldi",
                "espazio",
                "ilargi",
                "ilbehera",
                "ilbehera-bukaera",
                "txikitu",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("هلال کاهنده ماه"),
            keywords: &[
                "آب\u{200c}وهوا",
                "داس ماه",
                "فضا",
                "ماه",
                "مه\u{200c}داس",
                "هلال",
                "هلال کاهنده ماه",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("vähenevä kuunsirppi"),
            keywords: &[
                "kuu",
                "sirppi",
                "sää",
                "taivaankappale",
                "vähenevä",
                "vähenevä kuunsirppi",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("waning crescent moon"),
            keywords: &[
                "buwan",
                "crescent",
                "kalawakan",
                "waning",
                "waning crescent moon",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("lítil minkandi hálvmáni"),
            keywords: &["hálvmáni", "lítil minkandi hálvmáni", "minkandi", "máni"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("lune décroissante"),
            keywords: &["lune", "lune décroissante"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("dernier croissant de lune"),
            keywords: &["dernier croissant", "dernier croissant de lune", "lune"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("corrán gealaí atá ag caitheamh"),
            keywords: &[
                "corrán gealaí ag caitheamh",
                "corrán gealaí ag dul ar gcúl",
                "corrán gealaí atá ag caitheamh",
                "gealach",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("gealach chorranach a’ traoghadh"),
            keywords: &[
                "briseadh",
                "corranach",
                "gealach",
                "gealach chorranach a’ traoghadh",
                "traoghadh",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("lúa minguante"),
            keywords: &["lúa", "minguante"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ઘટતો અર\u{acd}ધચ\u{a82}દ\u{acd}રાકાર ચ\u{a82}દ\u{acd}ર"),
            keywords: &[
                "અર\u{acd}ધચ\u{a82}દ\u{acd}રાકાર",
                "ઘટતો",
                "ચ\u{a82}દ\u{acd}ર",
                "બીજનો ચ\u{a82}દ\u{acd}ર",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("hilalin wata mai ragewa"),
            keywords: &[
                "hilalin wata",
                "hilalin wata mai ragewa",
                "mai ragewa",
                "wata",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("סהר ירח מתרוקן"),
            keywords: &["חלל", "ירח", "סהר", "סהר ירח מתרוקן"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("द\u{942}ज का अस\u{94d}तमान चा\u{901}द"),
            keywords: &[
                "घटता चा\u{901}द",
                "घटता ह\u{941}आ",
                "चा\u{901}द",
                "चापाकार घटता चा\u{901}द",
                "चापाकार च\u{902}द\u{94d}र",
                "द\u{942}ज का अस\u{94d}तमान चा\u{901}द",
                "बालच\u{902}द\u{94d}र",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("polumjesec posljednje četvrti"),
            keywords: &[
                "mjesec",
                "opadanje",
                "polumjesec",
                "polumjesec posljednje četvrti",
                "svemir",
                "vrijeme",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("fogyó, sarló alakú hold"),
            keywords: &[
                "fogyó",
                "fogyó, kifli alakú hold",
                "fogyó, sarló alakú hold",
                "hold",
                "holdfázisok",
                "sarló",
                "ég",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("նվազող մահիկ"),
            keywords: &["եղանակ", "լուսին", "մահիկ", "նվազող", "տիեզերք"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("bulan sabit akhir"),
            keywords: &[
                "angkasa",
                "bulan",
                "bulan sabit akhir",
                "cuaca",
                "mengecil",
                "sabit",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("imelata ọnwa gburu uhie"),
            keywords: &["gburu uhie", "imelata ọnwa gburu uhie", "mmelite", "ọnwa"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("minnkandi tungl (minna en hálft)"),
            keywords: &[
                "hálfmáni",
                "minnkandi",
                "minnkandi tungl (minna en hálft)",
                "máni",
                "tungl",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("luna calante"),
            keywords: &["calante", "luna"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("有明月"),
            keywords: &["三日月", "月", "有明月"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("bulan gari seprapat"),
            keywords: &[
                "bulan",
                "bulan gari seprapat",
                "padhange ilang sithik-sithik",
                "seprapat",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მცხრალი ნამგალა მთვარე"),
            keywords: &["ამინდი", "კოსმოსი", "მთვარე", "მცხრალი", "ნამგალა"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("кішірейіп жатқан жарты ай"),
            keywords: &[
                "ай",
                "ауа райы",
                "жарты ай",
                "кішірейіп жатқан",
                "кішірейіп жатқан жарты ай",
                "ғарыш",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("aftagende måne"),
            keywords: &["aftagende måne", "måne", "månefase"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ព\u{17d2}រះចន\u{17d2}ទសល\u{17cb}តែម\u{17bd}យច\u{17c6}ន\u{17b7}ត"),
            keywords: &[
                "ព\u{17d2}រះចន\u{17d2}ទ",
                "ព\u{17d2}រះចន\u{17d2}ទសល\u{17cb}តែម\u{17bd}យច\u{17c6}ន\u{17b7}ត",
                "រនោច",
                "អឌ\u{17d2}ឍចន\u{17d2}ទ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕ\u{ccd}ಷೀಣ\u{cbf}ಸುತ\u{ccd}ತ\u{cbf}ರುವ ಅರ\u{ccd}ಧ ಚಂದ\u{ccd}ರ"),
            keywords: &[
                "ಅರ\u{ccd}ಧ",
                "ಕ\u{ccd}ಷೀಣ\u{cbf}ಸುತ\u{ccd}ತ\u{cbf}ರುವ ಅರ\u{ccd}ಧ ಚಂದ\u{ccd}ರ",
                "ಕ\u{ccd}ಷೀಣ\u{cbf}ಸುತ\u{ccd}ತ\u{cbf}ರುವ ಚಂದ\u{ccd}ರ",
                "ಕ\u{ccd}ಷೀಣ\u{cbf}ಸುವ",
                "ಚಂದ\u{ccd}ರ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("그믐달 하현"),
            keywords: &["그믐달", "그믐달 하현", "달"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("उणावपी च\u{902}द\u{94d}रकळ\u{947}ची च\u{902}द\u{94d}रकोर"),
            keywords: &[
                "उणावपी च\u{902}द\u{94d}रकळा",
                "उणावपी च\u{902}द\u{94d}रकळ\u{947}ची च\u{902}द\u{94d}रकोर",
                "च\u{902}द\u{94d}र",
                "च\u{902}द\u{94d}रकोर",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("бөксөрүп бүткөнү калган ай"),
            keywords: &[
                "аба ырайы",
                "ай",
                "бөксөргөн",
                "бөксөрүп бүткөнү калган ай",
                "космос",
            ],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Séchelmound am leschte Véierel"),
            keywords: &[
                "Mound",
                "Séchelmound",
                "Séchelmound am leschte Véierel",
                "leschte Véierel",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເດ\u{eb7}ອນດ\u{eb1}ບຂ\u{ec9}ອນດວງ"),
            keywords: &[
                "ຂ\u{ec9}ອນດວງ",
                "ເດ\u{eb7}ອນດ\u{eb1}ບ",
                "ເດ\u{eb7}ອນດ\u{eb1}ບຂ\u{ec9}ອນດວງ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("delčia (pabaiga)"),
            keywords: &["delčia (pabaiga)", "mėnulis", "pusmėnulis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("dilstoša mēness sirpis"),
            keywords: &["dilstoša mēness sirpis", "dilstošs", "mēness", "sirpis"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("marama tohi"),
            keywords: &["marama", "marama tohi", "pewa", "roroku"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("последна фаза на затемнување"),
            keywords: &[
                "вселена",
                "затемнување",
                "месечина",
                "последна",
                "последна фаза на затемнување",
            ],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("വിളറിയ ചന\u{d4d}ദ\u{d4d}രൻ"),
            keywords: &[
                "ചന\u{d4d}ദ\u{d4d}രക\u{d4d}കല",
                "ചന\u{d4d}ദ\u{d4d}രൻ",
                "വളഞ\u{d4d}ഞ ചന\u{d4d}ദ\u{d4d}രൻ",
                "വിളറിയ ചന\u{d4d}ദ\u{d4d}രൻ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("хавирган сар (зүүн)"),
            keywords: &["сар", "хавирган сар", "хавирган сар (зүүн)"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("कमी प\u{94d}रकाशित होणारी च\u{902}द\u{94d}रकोर"),
            keywords: &[
                "कमी प\u{94d}रकाशित होणारी च\u{902}द\u{94d}रकोर",
                "कमी होणारा",
                "च\u{902}द\u{94d}र",
                "च\u{902}द\u{94d}रकोर",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("bulan sabit memalap"),
            keywords: &[
                "angkasa lepas",
                "bulan",
                "bulan sabit",
                "bulan sabit memalap",
                "cuaca",
                "memalap",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("felli qamar li qed jonqos"),
            keywords: &["felli", "felli qamar li qed jonqos", "qamar", "qed jonqos"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("လက\u{103d}ယ\u{103a}မတ\u{102d}\u{102f}င\u{103a}မ\u{102e} အပတ\u{103a}"),
            keywords: &[
                "လ",
                "လက\u{103d}ယ\u{103a}မတ\u{102d}\u{102f}င\u{103a}မ\u{102e} အပတ\u{103a}",
                "လခြမ\u{103a}း",
                "လဆ\u{102f}တ\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("avtakende nemåne"),
            keywords: &["avtakende", "avtakende nemåne", "måne", "månefase", "ne"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("घट\u{94d}दो क\u{94d}र\u{947}स\u{947}न\u{94d}ट चन\u{94d}द\u{94d}रमा"),
            keywords: &[
                "क\u{94d}र\u{947}स\u{947}न\u{94d}ट",
                "घट\u{94d}दो क\u{94d}र\u{947}स\u{947}न\u{94d}ट चन\u{94d}द\u{94d}रमा",
                "चन\u{94d}द\u{94d}रमा",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("asgrauwe maan"),
            keywords: &["afnemend", "asgrauwe maan", "maan", "sikkel"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("avtakande nemåne"),
            keywords: &["avtakande", "avtakande nemåne", "måne", "månefase", "ne"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some(
                "ୱେନ\u{b3f}ଂରେ ଥ\u{b3f}ବ\u{b3e} କ\u{b4d}ର\u{b3f}ସେଣ\u{b4d}ଟ\u{b4d} ଚନ\u{b4d}ଦ\u{b4d}ର",
            ),
            keywords: &[
                "ଅପ\u{b42}ର\u{b4d}ଣ\u{b4d}ଣ",
                "ଅପ\u{b42}ର\u{b4d}ଣ\u{b4d}ଣଚନ\u{b4d}ଦ\u{b4d}ର",
                "ଚନ\u{b4d}ଦ\u{b4d}ର",
                "ମଳ\u{b3f}ନ",
                "ୱେନ\u{b3f}ଂରେ ଥ\u{b3f}ବ\u{b3e} କ\u{b4d}ର\u{b3f}ସେଣ\u{b4d}ଟ\u{b4d} ଚନ\u{b4d}ଦ\u{b4d}ର",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਘ\u{a71}\u{a71}ਟਦਾ ਚ\u{a70}ਦ"),
            keywords: &[
                "ਅ\u{a71}ਧਾ",
                "ਅ\u{a71}ਧਾ ਚ\u{a70}\u{a70}ਦ",
                "ਘ\u{a71}ਟਦਾ",
                "ਘ\u{a71}\u{a71}ਟਦਾ ਚ\u{a70}ਦ",
                "ਚ\u{a70}ਦ",
                "ਪ\u{a41}ਲਾੜ ਮ\u{a4c}ਸਮ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("گھٹدا ہوئیا م\u{64f}حد\u{650}ب چن"),
            keywords: &[
                "بے نور ہونا",
                "چاند",
                "گھٹدا ہوئیا م\u{64f}حد\u{650}ب چن",
                "ہلال",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Mun Dọ\u{301}n De Niálí Gó Fínish"),
            keywords: &["Go", "Krísẹnt", "Mun", "Mun Dọ\u{301}n De Niálí Gó Fínish"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("zanikający półksiężyc"),
            keywords: &[
                "cieniutki księżyc",
                "księżyc",
                "sierp",
                "zanikający półksiężyc",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("کمېدونکې هلال سپوږمۍ"),
            keywords: &["سپوږمۍ", "هلال", "کمېدونکې"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("lua minguante côncava"),
            keywords: &["côncava", "lua", "minguante"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &[
                "crescente",
                "espaço",
                "lua",
                "lua minguante côncava",
                "meteorologia",
                "minguante",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("wañu killa"),
            keywords: &["chawpi", "killa", "wañu"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("lună concavă în descreștere"),
            keywords: &[
                "concavă",
                "descreștere",
                "lună",
                "lună concavă în descreștere",
                "semilună",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-223"),
            keywords: &["E10-223"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("старая луна"),
            keywords: &["луна", "месяц", "небо", "старая", "убывающая"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("kimwe cya kane cy’ukwezi"),
            keywords: &["kimwe cya kane cy’ukwezi"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ويننگ ڪريسينٽ چنڊ"),
            keywords: &["ويننگ ڪريسينٽ چنڊ", "وڌندڙ چند", "چنڊ", "ڪريسينٽ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("අවපක\u{dca}ෂයේ අඩසඳ"),
            keywords: &[
                "අඩසඳ",
                "අභ\u{dca}\u{200d}යවක\u{dcf}ශය",
                "අවපක\u{dca}ෂයේ අඩසඳ",
                "අවපස",
                "ක\u{dcf}ලග\u{dd4}ණය",
                "සඳ",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("ubúdajúci polmesiac"),
            keywords: &["mesiac", "polmesiac", "počasie", "ubúdajúci", "vesmír"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("zadnji krajec"),
            keywords: &["krajec", "luna", "vesolje", "vreme", "zadnji"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("gaabinta dayaxa qoolaaban"),
            keywords: &[
                "bil qoolaaban",
                "dayax",
                "gaabinta",
                "gaabinta dayaxa qoolaaban",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("hënë e ngrënë më pak se gjysma"),
            keywords: &[
                "e ngrënë",
                "hapësirë",
                "hënë",
                "hënë e ngrënë më pak se gjysma",
                "moti",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("месечев срп у опадању"),
            keywords: &["oпaдaњe", "месец", "месечев срп у опадању", "пoлумесец"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("мјесечев срп у опадању"),
            keywords: &["мјесечев срп у опадању"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("mesečev srp u opadanju"),
            keywords: &["mesec", "mesečev srp u opadanju", "opadanje", "polumesec"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("mjesečev srp u opadanju"),
            keywords: &["mjesečev srp u opadanju"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("måne i fjärde kvarteret"),
            keywords: &[
                "avtagande måne",
                "kvartsmåne",
                "måne",
                "måne i fjärde kvarteret",
                "månskära",
            ],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mwezi kongo"),
            keywords: &[
                "anga",
                "hali yahewa",
                "kuisha",
                "mwezi",
                "mwezi kongo",
                "mwezi mwandamo",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &[
                "anga",
                "hali ya hewa",
                "kuisha",
                "mwezi",
                "mwezi kongo",
                "mwezi mwandamo",
            ],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("முக\u{bcd}க\u{bbe}ல\u{bcd}பகுதி தேய\u{bcd}பிறை"),
            keywords: &[
                "இரவு",
                "தேய\u{bcd}பிறை",
                "நில\u{bbe}",
                "பிறைநிலவு",
                "முக\u{bcd}க\u{bbe}ல\u{bcd}பகுதி தேய\u{bcd}பிறை",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("తగ\u{c4d}గుతున\u{c4d}న చంద\u{c4d}రుడు"),
            keywords: &[
                "చంద\u{c4d}రుడు",
                "తగ\u{c4d}గు",
                "తగ\u{c4d}గుతున\u{c4d}న చంద\u{c4d}రుడు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("марҳилаи хурд шудани ҳилол"),
            keywords: &[
                "марҳилаи хурд шудани ҳилол",
                "моҳ",
                "хурд шудани моҳ",
                "ҳилол",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("พระจ\u{e31}นทร\u{e4c}เส\u{e35}\u{e49}ยวข\u{e49}างแรม"),
            keywords: &[
                "ข\u{e49}างแรม",
                "พระจ\u{e31}นทร\u{e4c}",
                "พระจ\u{e31}นทร\u{e4c}เส\u{e35}\u{e49}ยวข\u{e49}างแรม",
                "เส\u{e35}\u{e49}ยว",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("köne aý"),
            keywords: &["aý", "kiçelýän", "köne aý", "ýarymaý"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("māhina silipō"),
            keywords: &["māhina silipō"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("ince ay"),
            keywords: &["ay", "ince ay", "solgun"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("يۈتەر ئورغاق ئاي"),
            keywords: &["ئاي", "ئورغاق", "يۈتەر"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("місяць у четвертій чверті"),
            keywords: &[
                "космос",
                "місяць",
                "місяць у четвертій чверті",
                "погода",
                "півмісяць",
                "спадаючий",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("گھٹتا ہوا ہلال چاند"),
            keywords: &["موسم", "چاند", "گھٹتا ہوا ہلال چاند", "ہلال"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("kichiklashib borayotgan yarim oy"),
            keywords: &[
                "kichiklashib borayotgan yarim oy",
                "kichiklashib boruvchi",
                "koinot",
                "ob-havo",
                "oy",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("trăng lưỡi liềm cuối tháng"),
            keywords: &[
                "cuối tháng",
                "lưỡi liềm",
                "mặt trăng",
                "trăng lưỡi liềm cuối tháng",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("xaaju weer buy yokk"),
            keywords: &["weer", "xaaj", "xaaju weer buy yokk", "yokk"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("inyanga elicala ethwasayo"),
            keywords: &["elicala", "ethwasayo", "inyanga"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Títàn Ààbọ\u{300} Oṣùpá"),
            keywords: &[
                "Títàn Ààbọ\u{300} Oṣùpá",
                "kírísẹ\u{301}ntì",
                "òṣùpa kékeré",
                "òṣùpá",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("殘月"),
            keywords: &["弦月", "月", "殘月", "虧"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("残月"),
            keywords: &["亏", "弦月", "月", "残月"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("残月"),
            keywords: &["亏眉月", "弯月", "月亮", "残月"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("眉形殘月"),
            keywords: &["殘月", "眉形殘月"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("殘月"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("inyanga ebheke phambili enkulu"),
            keywords: &[
                "inyanga",
                "inyanga ebheke phambili enkulu",
                "isimo sezulu",
                "ukubheka phambili",
                "ukuncipha",
                "umkhathi",
            ],
        },
    ],
};
#[doc = "🌙"]
pub const CRESCENT_MOON: crate::Emoji = crate::Emoji {
    glyph: "🌙",
    codepoint: "1F319",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "crescent moon",
    group: "Travel & Places",
    subgroup: "sky & weather",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("sekelmaan"),
            keywords: &["maan", "ruimte", "sekel", "sekelmaan", "weer"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ግማሽ ጨረቃ"),
            keywords: &["ህዋ", "የአየር ንብረት", "ግማሽ ጨረቃ", "ጨረቃ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("هلال"),
            keywords: &["الهلال", "طقس", "فضاء", "قمر", "هلال"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ক\u{9be}\u{981}চিজোন"),
            keywords: &[
                "অৰ\u{9cd}ধচন\u{9cd}দ\u{9cd}ৰ",
                "ক\u{9be}\u{981}চিজোন",
                "চন\u{9cd}দ\u{9cd}ৰ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("aypara"),
            keywords: &["ay", "aypara", "hava", "kosmos"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("паўмесяц"),
            keywords: &["космас", "месяц", "ноч", "паўмесяц"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("полумесец"),
            keywords: &["време", "космос", "луна", "полумесец"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("অর\u{9cd}ধচন\u{9cd}দ\u{9cd}র"),
            keywords: &[
                "অর\u{9cd}ধচন\u{9cd}দ\u{9cd}র",
                "আবহ\u{9be}ওয\u{9bc}\u{9be}",
                "চ\u{9be}\u{981}দ",
                "মহ\u{9be}ক\u{9be}শ",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("kreskenn loar"),
            keywords: &["kreskenn", "loar"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("polumjesec"),
            keywords: &["mjesec", "polumjesec"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("lluna creixent"),
            keywords: &["creixent", "lluna"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏓᏲᎲ ᏅᏓ ᎤᏒ ᎡᎯ"),
            keywords: &["ᎠᏓᏲᎲ", "ᎠᏓᏲᎲ ᏅᏓ ᎤᏒ ᎡᎯ", "ᏅᏓ ᎤᏒ ᎡᎯ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("srpek měsíce"),
            keywords: &["měsíc", "srpek", "srpek měsíce", "vesmír"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("lleuad gilgant"),
            keywords: &["cilgant", "gofod", "lleuad", "lleuad gilgant"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("halvmåne"),
            keywords: &["halvmåne", "tiltagende måne"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Mondsichel"),
            keywords: &["Mond", "Mondsichel"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ημισέληνος"),
            keywords: &[
                "διάστημα",
                "ημισέληνος",
                "καιρός",
                "μηνίσκος",
                "πανσέληνος",
                "φεγγάρι",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("crescent moon"),
            keywords: &["crescent", "moon"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("luna"),
            keywords: &["creciente", "espacio", "luna"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("media luna"),
            keywords: &[
                "clima",
                "creciente",
                "cuarto",
                "espacio",
                "luna",
                "media luna",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &[
                "cruasán",
                "cuarto creciente",
                "fase lunar",
                "luna creciente",
                "media luna",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("luna creciente"),
            keywords: &["creciente", "luna"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kuusirp"),
            keywords: &["ilm", "kosmos", "kuu", "kuusirp", "sirp"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("ilargi-adarra"),
            keywords: &["ilargi-adarra", "ilargia", "ilgora"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("هلال ماه"),
            keywords: &[
                "آب\u{200c}وهوا",
                "داس ماه",
                "فضا",
                "ماه",
                "مه\u{200c}داس",
                "هلال",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kuunsirppi"),
            keywords: &["kuu", "kuunsirppi", "sirppi", "sää", "taivaankappale"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("crescent moon"),
            keywords: &["buwan", "crescent", "crescent moon", "kalawakan"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("hálvmáni"),
            keywords: &["hálvmáni", "máni"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("croissant de lune"),
            keywords: &["croissant de lune", "lune"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["croissant", "croissant de lune", "lune"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("corrán gealaí"),
            keywords: &["corrán gealaí", "gealach"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("gealach chorranach"),
            keywords: &["corranach", "gealach", "gealach chorranach"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("lúa crecente"),
            keywords: &["crecente", "lúa"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("બીજનો ચા\u{a82}દ"),
            keywords: &[
                "અર\u{acd}ધચ\u{a82}દ\u{acd}રાકાર",
                "ચ\u{a82}દ\u{acd}ર",
                "બીજનો ચ\u{a82}દ\u{acd}ર",
                "બીજનો ચા\u{a82}દ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("hilalin wata"),
            keywords: &["hilali", "hilalin wata", "wata"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("סהר"),
            keywords: &["ירח", "סהר"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("चापाकार च\u{902}द\u{94d}र"),
            keywords: &[
                "चा\u{901}द",
                "चापाकार च\u{902}द\u{94d}र",
                "बालच\u{902}द\u{94d}र",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("polumjesec"),
            keywords: &["mjesec", "polumjesec", "svemir", "vrijeme"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("növekvő hold"),
            keywords: &["hold", "holdfázisok", "növekvő hold", "sarló", "ég"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("մահիկ"),
            keywords: &["եղանակ", "լուսին", "մահիկ", "տիեզերք"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("bulan sabit"),
            keywords: &["angkasa", "bulan", "cuaca", "sabit"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ọnwa elu-ugwu"),
            keywords: &["mmelite", "ọnwa", "ọnwa elu-ugwu"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("hálfmáni"),
            keywords: &["hálfmáni", "máni", "tungl"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("spicchio di luna"),
            keywords: &["crescente", "luna", "spicchio di luna"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("三日月"),
            keywords: &["三日月", "月"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("bulan nanggal sepisan"),
            keywords: &["bulan", "bulan nanggal sepisan"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ნამგალა მთვარე"),
            keywords: &["ამინდი", "კოსმოსი", "მთვარე", "ნამგალა"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("жарты ай"),
            keywords: &["ай", "ауа райы", "жарты ай", "ғарыш"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("halvmåne"),
            keywords: &["aftagende måne", "halvmåne"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ច\u{17c6}ន\u{17b7}តខែ"),
            keywords: &[
                "ច\u{17c6}ន\u{17b7}តខែ",
                "ព\u{17d2}រះចន\u{17d2}ទ",
                "អឌ\u{17d2}ឍចន\u{17d2}ទ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಅರ\u{ccd}ಧಾಕಾರದ ಚಂದ\u{ccd}ರ"),
            keywords: &[
                "ಅರ\u{ccd}ಧ ಚಂದ\u{ccd}ರ",
                "ಅರ\u{ccd}ಧಾಕಾರದ ಚಂದ\u{ccd}ರ",
                "ಚಂದ\u{ccd}ರ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("초승달"),
            keywords: &["달", "초승달"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("च\u{902}द\u{94d}रकोर"),
            keywords: &["च\u{902}द\u{94d}र", "च\u{902}द\u{94d}रकोर"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("жарым ай"),
            keywords: &["аба ырайы", "ай", "жарым", "космос"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Moundséchel"),
            keywords: &["Mound", "Moundséchel", "Séchel"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເດ\u{eb7}ອນສ\u{ec9}ຽວ"),
            keywords: &["ສ\u{ec9}ຽວ", "ເດ\u{eb7}ອນ", "ເດ\u{eb7}ອນສ\u{ec9}ຽວ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("pusmėnulis"),
            keywords: &["mėnulis", "pusmėnulis", "pusė"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("mēness sirpis"),
            keywords: &["mēness", "sirpis"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("marama pewa"),
            keywords: &["marama", "pewa"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("месечев срп"),
            keywords: &["време", "вселена", "месечев срп", "месечина", "срп"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ചന\u{d4d}ദ\u{d4d}രക\u{d4d}കല"),
            keywords: &[
                "ചന\u{d4d}ദ\u{d4d}രക\u{d4d}കല",
                "ചന\u{d4d}ദ\u{d4d}രൻ",
                "വളഞ\u{d4d}ഞ ചന\u{d4d}ദ\u{d4d}രൻ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("хавирган сар"),
            keywords: &["сар", "хавирган сар"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("च\u{902}द\u{94d}रकोर"),
            keywords: &["च\u{902}द\u{94d}र", "च\u{902}द\u{94d}रकोर"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("bulan sabit"),
            keywords: &["angkasa lepas", "bulan", "bulan sabit", "cuaca"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("felli qamar"),
            keywords: &["felli", "qamar"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("လခြမ\u{103a}း"),
            keywords: &["လ", "လခြမ\u{103a}း"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("månesigd"),
            keywords: &["måne", "månesigd"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("क\u{94d}र\u{947}स\u{947}न\u{94d}ट चन\u{94d}द\u{94d}रमा"),
            keywords: &[
                "क\u{94d}र\u{947}स\u{947}न\u{94d}ट चन\u{94d}द\u{94d}रमा",
                "क\u{94d}र\u{947}स\u{947}\u{947}न\u{94d}ट",
                "चन\u{94d}द\u{94d}रमा",
                "ठाउ\u{901}",
                "मौ\u{902}सम",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("maansikkel"),
            keywords: &["maan", "maansikkel", "sikkel"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("månesigd"),
            keywords: &["måne", "månesigd"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("କ\u{b4d}ର\u{b3f}ସେଣ\u{b4d}ଟ\u{b4d} ମ\u{b41}ନ\u{b4d}"),
            keywords: &[
                "କ\u{b4d}ର\u{b3f}ସେଣ\u{b4d}ଟ\u{b4d} ମ\u{b41}ନ\u{b4d}",
                "ଚନ\u{b4d}ଦ\u{b4d}ର",
                "ବ\u{b3e}ଳଚନ\u{b4d}ଦ\u{b4d}ର",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਅ\u{a71}ਧਾ ਚ\u{a70}ਦ"),
            keywords: &[
                "ਅ\u{a71}ਧਾ",
                "ਅ\u{a71}ਧਾ ਚ\u{a70}\u{a70}ਦ",
                "ਚ\u{a70}ਦ",
                "ਪ\u{a41}ਲਾੜ",
                "ਮ\u{a4c}ਸਮ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ہلالی چاند"),
            keywords: &["چاند", "ہلال", "ہلالی چاند"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Krísẹ\u{301}nt Mun"),
            keywords: &["Krísẹnt", "Krísẹ\u{301}nt Mun", "Mun"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("półksiężyc"),
            keywords: &["księżyc", "półksiężyc", "sierp"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("هلال سپوږمۍ"),
            keywords: &["سپوږمۍ", "هلال"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("lua crescente"),
            keywords: &["crescente", "lua"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("lua crescente sem sombra"),
            keywords: &[
                "crescente",
                "espaço",
                "lua",
                "lua crescente sem sombra",
                "meteorologia",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("chawpi killa"),
            keywords: &["chawpi killa"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("semilună"),
            keywords: &["creștere", "lună", "semilună"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-224"),
            keywords: &["E10-224"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("полумесяц"),
            keywords: &["луна", "месяц", "полумесяц"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ukwezi kugenda gukura"),
            keywords: &["ukwezi kugenda gukura"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڪريسينٽ چنڊ"),
            keywords: &["چنڊ", "ڪريسينٽ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("අඩසඳ"),
            keywords: &[
                "අඩසඳ",
                "අභ\u{dca}\u{200d}යවක\u{dcf}ශය",
                "ක\u{dcf}ලග\u{dd4}ණය",
                "සඳ",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("polmesiac"),
            keywords: &["mesiac", "polmesiac", "počasie", "vesmír"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("lunin srp"),
            keywords: &["krajec", "luna", "lunin srp", "vesolje", "vreme"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("dayax qoolaaban"),
            keywords: &["bil qoolaaban", "dayax", "dayax qoolaaban"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("hënë e ngrënë"),
            keywords: &["e ngrënë", "hapësirë", "hënë", "hënë e ngrënë", "moti"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("месечев срп"),
            keywords: &["месец", "месечев срп", "пoлумесец"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("мјесечев срп"),
            keywords: &["мјесечев срп"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("mesečev srp"),
            keywords: &["mesec", "mesečev srp", "polumesec"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("mjesečev srp"),
            keywords: &["mjesečev srp"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("månskära"),
            keywords: &["måne", "månskära"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mwezi unaoandama mwezi mpya"),
            keywords: &[
                "anga",
                "hali ya hewa",
                "mwezi",
                "mwezi mwandamo",
                "mwezi unaoandama mwezi mpya",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பிறைநிலவு"),
            keywords: &[
                "தேய\u{bcd}பிறை",
                "நிலவொளி",
                "நில\u{bbe}",
                "பிறைநிலவு",
                "வளர\u{bcd}பிறை",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("న\u{c46}లవంక"),
            keywords: &["అర\u{c4d}ధచంద\u{c4d}రుడు", "చంద\u{c4d}రవంక", "న\u{c46}లవంక"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("ҳилол"),
            keywords: &["моҳ", "ҳилол"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("พระจ\u{e31}นทร\u{e4c}เส\u{e35}\u{e49}ยว"),
            keywords: &[
                "พระจ\u{e31}นทร\u{e4c}",
                "พระจ\u{e31}นทร\u{e4c}เส\u{e35}\u{e49}ยว",
                "เส\u{e35}\u{e49}ยว",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ýarym aý"),
            keywords: &["aý", "ýarym aý", "ýarymaý"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("māhina kalipa"),
            keywords: &["māhina kalipa"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("hilal"),
            keywords: &["ay", "hilal"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئورغاق ئاي"),
            keywords: &["ئاي", "ئورغاق"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("серп місяця"),
            keywords: &["космос", "місяць", "погода", "серп місяця"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ہلال چاند"),
            keywords: &["موسم", "چاند", "ہلال"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("oy"),
            keywords: &["koinot", "ob-havo", "oy", "yarim oy"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("trăng lưỡi liềm"),
            keywords: &["lưỡi liềm", "mặt trăng", "trăng lưỡi liềm"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("weer wu sew di màgg"),
            keywords: &["sew di màgg", "weer wu", "weer wu sew di màgg"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("inyanga elicala"),
            keywords: &["elicala", "inyanga"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ààbọ\u{300} Oṣùpá"),
            keywords: &["Oṣùpá", "Ààbọ\u{300}"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("弦月"),
            keywords: &["弦月", "月"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("弦月"),
            keywords: &["弦月", "月"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("弯月"),
            keywords: &["娥眉月", "弯月", "月亮"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("彎月"),
            keywords: &["彎月", "月亮", "月牙", "残月"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("inyanga enciphile"),
            keywords: &[
                "inyanga",
                "inyanga enciphile",
                "isimo sezulu",
                "ukubheka emuva",
                "umkhathi",
            ],
        },
    ],
};
#[doc = "🌚"]
pub const NEW_MOON_FACE: crate::Emoji = crate::Emoji {
    glyph: "🌚",
    codepoint: "1F31A",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "new moon face",
    group: "Travel & Places",
    subgroup: "sky & weather",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("nuwemaangesig"),
            keywords: &["gesig", "maan", "nuwe", "nuwemaangesig", "ruimte", "weer"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("አዲስ ጨረቃ ፊት"),
            keywords: &["ህዋ", "አዲስ ጨረቃ ፊት", "የአየር ንብረት", "ጨረቃ", "ፊት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("وجه محاق"),
            keywords: &["طقس", "فضاء", "قمر", "وجه", "وجه محاق"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("চন\u{9cd}দ\u{9cd}ৰৰ নত\u{9c1}ন ম\u{9c1}খ"),
            keywords: &[
                "চন\u{9cd}দ\u{9cd}ৰ",
                "চন\u{9cd}দ\u{9cd}ৰৰ নত\u{9c1}ন ম\u{9c1}খ",
                "ম\u{9c1}খ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("yeni ay üzü"),
            keywords: &["ay", "hava", "kosmos", "yeni ay üzü", "üz"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("маладзік з тварам"),
            keywords: &[
                "космас",
                "маладзік",
                "маладзік з тварам",
                "месяц",
                "ноч",
                "твар",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Луната в новолуние с лице"),
            keywords: &[
                "Луната в новолуние с лице",
                "време",
                "космос",
                "лице",
                "луна",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("চ\u{9be}\u{981}দের নত\u{9c1}ন ম\u{9c1}খ"),
            keywords: &[
                "আবহ\u{9be}ওয\u{9bc}\u{9be}",
                "চ\u{9be}\u{981}দ",
                "চ\u{9be}\u{981}দের নত\u{9c1}ন ম\u{9c1}খ",
                "মহ\u{9be}ক\u{9be}শ",
                "ম\u{9c1}খ",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("penn loar nevez"),
            keywords: &["loar", "penn", "penn loar nevez"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("mladi mjesec lice"),
            keywords: &["lice", "mjesec", "mladi mjesec lice"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cara de lluna nova"),
            keywords: &["cara", "cara de lluna nova", "lluna nova"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎢᏤ ᏅᏓ ᎤᏒ ᎡᎯ ᎤᎧᏛ"),
            keywords: &["ᎢᏤ ᏅᏓ ᎤᏒ ᎡᎯ ᎤᎧᏛ", "ᎤᎧᏛ", "ᏅᏓ ᎤᏒ ᎡᎯ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("měsíc v novu s obličejem"),
            keywords: &[
                "fáze měsíce",
                "měsíc",
                "měsíc v novu s obličejem",
                "nov",
                "novoluní",
                "nový",
                "smajlík",
                "tma",
                "tvář",
                "vesmír",
                "výraz",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("wyneb lleuad newydd"),
            keywords: &["cilgant", "gofod", "lleuad", "wyneb lleuad newydd"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("nymåne med ansigt"),
            keywords: &["ansigt i måne", "nymåne", "nymåne med ansigt"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Neumond mit Gesicht"),
            keywords: &["Gesicht", "Neumond", "Neumond mit Gesicht"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("νέα σελήνη με πρόσωπο"),
            keywords: &[
                "διάστημα",
                "καιρός",
                "νέα σελήνη με πρόσωπο",
                "πρόσωπο",
                "φεγγάρι",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("new moon face"),
            keywords: &["face", "moon", "new moon face"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("luna nueva con cara"),
            keywords: &["cara", "espacio", "luna", "luna nueva con cara"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["cara", "luna", "luna nueva con cara", "nueva"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("näoga noorkuu"),
            keywords: &["ilm", "kosmos", "kuu", "nägu", "näoga noorkuu"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("ilargi berriaren aurpegia"),
            keywords: &[
                "aurpegi",
                "eguraldi",
                "espazio",
                "ilargi",
                "ilargi berriaren aurpegia",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("صورت ماه نو"),
            keywords: &["آب\u{200c}وهوا", "صورت", "صورت ماه نو", "فضا", "ماه"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("uudenkuun kasvot"),
            keywords: &["kasvot", "kuu", "sää", "taivaankappale", "uudenkuun kasvot"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("new moon na may mukha"),
            keywords: &[
                "buwan",
                "kalawakan",
                "mukha",
                "new moon",
                "new moon na may mukha",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("andlit á nýmána"),
            keywords: &["andlit", "andlit á nýmána", "máni", "nýmáni"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("nouvelle lune avec visage"),
            keywords: &["lune", "nouvelle lune avec visage"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("nouvelle lune avec visage"),
            keywords: &["lune", "nouvelle", "nouvelle lune avec visage", "visage"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("gealach úr le haghaidh"),
            keywords: &["gealach úr le haghaidh"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("gealach ùr le aodann"),
            keywords: &["aodann", "gealach", "gealach ùr le aodann"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("lúa nova con cara"),
            keywords: &["cara", "lúa", "lúa nova con cara", "nova"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("પ\u{acd}રતિપદાના ચ\u{a82}દ\u{acd}રનો ચહ\u{ac7}રો"),
            keywords: &[
                "ચ\u{a82}દ\u{acd}ર",
                "ચહ\u{ac7}રા સાથ\u{ac7}નો પ\u{acd}રતિપદાનો ચ\u{a82}દ\u{acd}ર",
                "ચહ\u{ac7}રો",
                "પ\u{acd}રતિપદાના ચ\u{a82}દ\u{acd}રનો ચહ\u{ac7}રો",
                "પ\u{acd}રતિપદાનો ચ\u{a82}દ\u{acd}ર",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("fuskar sabon wata"),
            keywords: &["fuska", "fuskar sabon wata", "wata"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("פני ירח חדש"),
            keywords: &["ירח", "פני ירח חדש", "פנים"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("नए चा\u{901}द वाला च\u{947}हरा"),
            keywords: &[
                "चा\u{901}द",
                "च\u{947}हरा",
                "च\u{947}हर\u{947} वाला चा\u{901}द",
                "नए चा\u{901}द वाला च\u{947}हरा",
                "नया चा\u{901}द",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("mlađak s licem"),
            keywords: &["lice", "mjesec", "mlađak s licem", "svemir", "vrijeme"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("újhold arccal"),
            keywords: &[
                "arc",
                "hold",
                "holdfázisok",
                "ég",
                "újhold",
                "újhold arccal",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("դեմքով նորալուսին"),
            keywords: &["դեմք", "դեմքով նորալուսին", "եղանակ", "լուսին", "տիեզերք"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("wajah bulan baru"),
            keywords: &["angkasa", "bulan", "cuaca", "wajah", "wajah bulan baru"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ihu ọnwa ọhụrụ"),
            keywords: &["ihu", "ihu ọnwa ọhụrụ", "ọnwa"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("nýtt tungl með andliti"),
            keywords: &[
                "andlit",
                "karlinn í tunglinu",
                "máni",
                "nýtt tungl",
                "nýtt tungl með andliti",
                "tungl",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("faccina luna nuova"),
            keywords: &[
                "faccina",
                "faccina luna nuova",
                "luna",
                "luna nuova",
                "luna nuova con faccina",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("顔のある新月"),
            keywords: &["新月", "月", "顔", "顔のある新月"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("rai bulan kawitan"),
            keywords: &["bulan", "rai", "rai bulan kawitan"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ახალი მთვარის სახე"),
            keywords: &["ამინდი", "ახალი მთვარის სახე", "კოსმოსი", "მთვარე", "სახე"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("жаңа ай беті"),
            keywords: &["ай", "ауа райы", "бет", "жаңа ай беті", "ғарыш"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("nymåne med ansigt"),
            keywords: &["ansigt i måne", "nymåne", "nymåne med ansigt"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ម\u{17bb}ខព\u{17d2}រះចន\u{17d2}ទថ\u{17d2}ម\u{17b8}"),
            keywords: &[
                "ព\u{17d2}រះច\u{17d0}ន\u{17d2}ទ",
                "ម\u{17bb}ខ",
                "ម\u{17bb}ខព\u{17d2}រះចន\u{17d2}ទថ\u{17d2}ម\u{17b8}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಅಮಾವಾಸ\u{ccd}ಯ\u{cc6} ಮುಖ"),
            keywords: &[
                "ಅಮಾವಾಸ\u{ccd}ಯ\u{cc6}",
                "ಅಮಾವಾಸ\u{ccd}ಯ\u{cc6} ಮುಖ",
                "ಅಮಾವಾಸ\u{ccd}ಯ\u{cc6}ಯ ಮುಖದೊಂದ\u{cbf}ಗ\u{cc6}",
                "ಚಂದ\u{ccd}ರ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("얼굴이 있는 삭"),
            keywords: &["뉴문", "달", "달님", "삭", "얼굴이 있는 삭"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("अमाश\u{947}च\u{94d}या च\u{902}द\u{94d}राचो च\u{947}रो"),
            keywords: &[
                "अमाश\u{947}च\u{94d}या च\u{902}द\u{94d}राचो च\u{947}रो",
                "च\u{902}द\u{94d}र",
                "च\u{947}रो",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("жаңырган айдын бети"),
            keywords: &["ай", "бет", "жаңырган айды бети", "жаңырган айдын бети"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Neimoundgesiicht"),
            keywords: &["Gesiicht", "Mound", "Neimoundgesiicht"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໜ\u{ec9}າເດ\u{eb7}ອນດ\u{eb1}ບ"),
            keywords: &[
                "ເດ\u{eb7}ອນດ\u{eb1}ບ",
                "ໜ\u{ec9}າ",
                "ໜ\u{ec9}າເດ\u{eb7}ອນດ\u{eb1}ບ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("jaunas mėnulis su veidu"),
            keywords: &["jaunas mėnulis su veidu", "mėnulis", "veidas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("jauna mēness seja"),
            keywords: &["jauna mēness seja", "mēness", "seja"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("mata marama kōhiti"),
            keywords: &["marama", "mata", "mata marama kōhiti"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("млада месечина со лице"),
            keywords: &[
                "вселена",
                "лице",
                "месечина",
                "млада",
                "млада месечина со лице",
            ],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("അമ\u{d3e}വ\u{d3e}സി മ\u{d41}ഖം"),
            keywords: &[
                "അമ\u{d3e}വ\u{d3e}സി മ\u{d41}ഖം",
                "ചന\u{d4d}ദ\u{d4d}രക\u{d4d}കല",
                "ചന\u{d4d}ദ\u{d4d}രൻ",
                "വളഞ\u{d4d}ഞ ചന\u{d4d}ദ\u{d4d}രൻ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("нүүртэй шинэ сар"),
            keywords: &["нүүр", "нүүртэй шинэ сар", "сар", "шинэ"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("अमावस\u{94d}य\u{947}च\u{94d}या च\u{902}द\u{94d}राचा च\u{947}हरा"),
            keywords: &[
                "अमावस\u{94d}य\u{947}च\u{94d}या च\u{902}द\u{94d}राचा च\u{947}हरा",
                "च\u{902}द\u{94d}र",
                "च\u{947}हरा",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("muka bulan baharu"),
            keywords: &[
                "angkasa lepas",
                "bulan",
                "cuaca",
                "muka",
                "muka bulan baharu",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("wiċċ ta’ qamar ġdid"),
            keywords: &["qamar", "wiċċ", "wiċċ ta’ qamar ġdid"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("လက\u{103d}ယ\u{103a} မျက\u{103a}န\u{103e}ာ"),
            keywords: &[
                "မျက\u{103a}န\u{103e}ာ",
                "လ",
                "လက\u{103d}ယ\u{103a} မျက\u{103a}န\u{103e}ာ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("nymåneansikt"),
            keywords: &[
                "ansikt",
                "måne",
                "nymåne",
                "nymåne med ansikt",
                "nymåneansikt",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("औ\u{902}सीको चन\u{94d}द\u{94d}रमाको स\u{94d}वर\u{942}प"),
            keywords: &[
                "औ\u{902}सीको चन\u{94d}द\u{94d}रमाको स\u{94d}वर\u{942}प",
                "चन\u{94d}द\u{94d}रमाको स\u{94d}वर\u{942}प",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("nieuwe maan met gezicht"),
            keywords: &["gezicht", "maan", "nieuwe maan met gezicht"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("nymåneandlet"),
            keywords: &[
                "andlet",
                "måne",
                "nymåne",
                "nymåne med andlet",
                "nymåneandlet",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ନ\u{b42}ଆ ଚନ\u{b4d}ଦ\u{b4d}ର ମ\u{b41}ହ\u{b01}"),
            keywords: &[
                "ଅମ\u{b3e}ବ\u{b3e}ସ\u{b4d}ୟ\u{b3e}",
                "ଚନ\u{b4d}ଦ\u{b4d}ର",
                "ନ\u{b42}ଆ ଚନ\u{b4d}ଦ\u{b4d}ର ମ\u{b41}ହ\u{b01}",
                "ମ\u{b41}ଖ",
                "ମ\u{b41}ଖ ସହ\u{b3f}ତ ଅମ\u{b3e}ବ\u{b3e}ସ\u{b4d}ୟ\u{b3e}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਚ\u{a70}ਦ ਦਾ ਨਵਾ\u{a02} ਚਿਹਰਾ"),
            keywords: &[
                "ਚਿਹਰਾ",
                "ਚ\u{a70}ਦ",
                "ਚ\u{a70}ਦ ਦਾ ਨਵਾ\u{a02} ਚਿਹਰਾ",
                "ਨਵਾ\u{a02} ਚ\u{a70}ਦ",
                "ਨਵ\u{a47}\u{a02} ਚ\u{a70}ਦ ਦਾ ਚਿਹਰਾ",
                "ਪ\u{a41}ਲਾੜ",
                "ਮ\u{a4c}ਸਮ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("نوے چاند دی شکل"),
            keywords: &["دی شکل", "نوے چاند دی شکل", "چاند"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Niú Mún Fes"),
            keywords: &["Fes", "Mun", "Niú Mún Fes"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("nów z twarzą"),
            keywords: &["księżyc", "księżyc w nowiu", "nów z twarzą"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("نوې سپوږمۍ مخ"),
            keywords: &["د نوې سپوږمۍ مخ", "سپوږمۍ", "مخ", "نوې سپوږمۍ مخ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("rosto da lua nova"),
            keywords: &[
                "lua",
                "lua nova",
                "lua nova com rosto",
                "rosto",
                "rosto da lua nova",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("cara de lua nova"),
            keywords: &["cara", "cara de lua nova", "espaço", "lua", "meteorologia"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("unu killa uya"),
            keywords: &["killa", "unu killa uya", "uya"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("lună nouă cu față"),
            keywords: &["față", "lună", "lună nouă cu față", "rotundă", "întuneric"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-225"),
            keywords: &["E10-225"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("новая луна с лицом"),
            keywords: &[
                "луна с лицом",
                "новая луна",
                "новая луна с лицом",
                "новолуние",
                "темная луна",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("isura y’ukwezi gushya"),
            keywords: &["isura", "isura y’ukwezi gushya", "ukwezi"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("نئين چنڊ جو چهرو"),
            keywords: &["نئين چنڊ جو چهرو", "چنڊ", "چهرو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("නව සඳ ම\u{dd4}හ\u{dd4}ණ"),
            keywords: &[
                "අභ\u{dca}\u{200d}යවක\u{dcf}ශය",
                "ක\u{dcf}ලග\u{dd4}ණය",
                "නව සඳ ම\u{dd4}හ\u{dd4}ණ",
                "ම\u{dd4}හ\u{dd4}ණ",
                "සඳ",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("nov s\u{a0}tvárou"),
            keywords: &["mesiac", "nov s\u{a0}tvárou", "počasie", "tvár", "vesmír"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("mlada luna z obrazom"),
            keywords: &["luna", "mlada luna z obrazom", "obraz", "vesolje", "vreme"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("waji daxeedka cusub"),
            keywords: &["dayax", "waji", "waji daxeedka cusub"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("fytyra e hënës së re"),
            keywords: &["fytyra e hënës së re", "fytyrë", "hapësirë", "hënë", "moti"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("млад месец са лицем"),
            keywords: &["лице", "месец", "млад месец са лицем"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("млад мјесец са лицем"),
            keywords: &["млад мјесец са лицем"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("mlad mesec sa licem"),
            keywords: &["lice", "mesec", "mlad mesec sa licem"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("mlad mjesec sa licem"),
            keywords: &["mlad mjesec sa licem"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("nymåne med ansikte"),
            keywords: &[
                "ansikte",
                "gubben i månen",
                "månansikte",
                "måne",
                "nymåne",
                "nymåne med ansikte",
            ],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("uso wa mwezi mpya"),
            keywords: &["anga", "hali ya hewa", "mwezi", "uso", "uso wa mwezi mpya"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("அம\u{bbe}வ\u{bbe}சை முகம\u{bcd}"),
            keywords: &[
                "அம\u{bbe}வ\u{bbe}சை",
                "கருப\u{bcd}பு முகம\u{bcd}",
                "முகம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("అమ\u{c3e}వ\u{c3e}స\u{c4d}య చంద\u{c4d}రున\u{c3f} ముఖం"),
            keywords: &[
                "అమ\u{c3e}వ\u{c3e}స\u{c4d}య",
                "అమ\u{c3e}వ\u{c3e}స\u{c4d}య చంద\u{c4d}రున\u{c3f} ముఖం",
                "చంద\u{c4d}రుడు",
                "ముఖం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("чеҳраи моҳи нав"),
            keywords: &["моҳ", "рӯй", "чеҳраи моҳи нав"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("หน\u{e49}าพระจ\u{e31}นทร\u{e4c}ด\u{e31}บ"),
            keywords: &["หน\u{e49}าดำ", "หน\u{e49}าพระจ\u{e31}นทร\u{e4c}ด\u{e31}บ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("täze aý ýüz"),
            keywords: &["aý", "täze aý ýüz", "ýüz"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("mata mate ʻae māhina"),
            keywords: &["mata mate ʻae māhina"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("yeni ay yüzü"),
            keywords: &["ay", "yeni ay", "yeni ay yüzü", "yüz", "yüzü olan yeni ay"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("يۈزلۈك يېڭى ئاي"),
            keywords: &["ئاي", "يۈزلۈك يېڭى ئاي", "چىراي"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("молодий місяць з обличчям"),
            keywords: &[
                "космос",
                "молодий місяць з обличчям",
                "місяць",
                "обличчя",
                "погода",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("نئے چاند کا چہرہ"),
            keywords: &["موسم", "نئے چاند کا چہرہ", "چاند", "چہرہ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("yangi oy qiyofasi"),
            keywords: &[
                "koinot",
                "ob-havo",
                "oy",
                "oymomo",
                "yangi oy qiyofasi",
                "yuz",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("mặt trăng non"),
            keywords: &["mặt", "mặt trăng", "mặt trăng non"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("kanamu weer wu bees"),
            keywords: &["kanam", "kanamu weer wu bees", "weer"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ubuso benyanga entsha"),
            keywords: &["inyanga", "ubuso", "ubuso benyanga entsha"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Oju Òṣùpá Tuntun"),
            keywords: &["Oju Òṣùpá Tuntun", "ojú", "oṣupa"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("新月面"),
            keywords: &["新月面", "月", "面"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("新月面"),
            keywords: &["新月面", "月", "面"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("微笑的朔月"),
            keywords: &["微笑的朔月", "月亮", "朔月"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("月亮公公"),
            keywords: &["月亮", "月亮公公", "朔月"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("新月嘅面孔"),
            keywords: &["新月", "新月嘅面孔", "月亮", "有臉的新月"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ubuso benyanga entsha"),
            keywords: &[
                "inyanga",
                "isimo sezulu",
                "ubuso",
                "ubuso benyanga entsha",
                "umkhathi",
            ],
        },
    ],
};
#[doc = "🌛"]
pub const FIRST_QUARTER_MOON_FACE: crate::Emoji = crate::Emoji {
    glyph: "🌛",
    codepoint: "1F31B",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "first quarter moon face",
    group: "Travel & Places",
    subgroup: "sky & weather",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("eerstekwartiermaan met gesig"),
            keywords: &[
                "eerste",
                "eerstekwartiermaan met gesig",
                "gesig",
                "kwartier",
                "maan",
                "ruimte",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የመጀመሪያ ሩብ ጨረቃ ከፊት ጋር"),
            keywords: &["ህዋ", "ሩብ", "የመጀመሪያ ሩብ ጨረቃ ከፊት ጋር", "የአየር ንብረት", "ጨረቃ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("وجه تربيع أول"),
            keywords: &["أول", "تربيع", "طقس", "فضاء", "قمر", "وجه"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("চন\u{9cd}দ\u{9cd}ৰৰ প\u{9cd}ৰথম চত\u{9c1}ৰ\u{9cd}থ\u{9be}ংশৰ ম\u{9c1}খ"),
            keywords: &[
                "চত\u{9c1}ৰ\u{9cd}থ\u{9be}ংশ",
                "চন\u{9cd}দ\u{9cd}ৰ",
                "চন\u{9cd}দ\u{9cd}ৰৰ প\u{9cd}ৰথম চত\u{9c1}ৰ\u{9cd}থ\u{9be}ংশৰ ম\u{9c1}খ",
                "ম\u{9c1}খ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("ayın birinci dörrdə bir hissəsinin üzü"),
            keywords: &[
                "ay",
                "ayın birinci dörrdə bir hissəsinin üzü",
                "dörddə bir",
                "hava",
                "kosmos",
                "üz",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("месяц у першай чвэрці з тварам"),
            keywords: &[
                "квадра",
                "космас",
                "месяц",
                "месяц у першай чвэрці з тварам",
                "першая",
                "твар",
                "чвэрць",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Луната в първа четвърт с лице"),
            keywords: &[
                "Луната в първа четвърт с лице",
                "космос",
                "лице",
                "луна",
                "четвърт",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some(
                "ম\u{9c1}খের স\u{9be}থে চ\u{9be}\u{981}দের প\u{9cd}রথম এক চত\u{9c1}র\u{9cd}থ\u{9be}ংশ",
            ),
            keywords: &[
                "চ\u{9be}\u{981}দ",
                "মহ\u{9be}ক\u{9be}শ",
                "ম\u{9c1}খ",
                "ম\u{9c1}খের স\u{9be}থে চ\u{9be}\u{981}দের প\u{9cd}রথম এক চত\u{9c1}র\u{9cd}থ\u{9be}ংশ",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("penn loar vihan ar cʼhresk"),
            keywords: &["loar", "penn", "penn loar vihan ar cʼhresk"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("prva četvrtina lice"),
            keywords: &["lice", "mjesec", "prva četvrtina lice"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("lluna en el primer quart amb cara"),
            keywords: &[
                "cara",
                "creixent",
                "lluna",
                "lluna en el primer quart amb cara",
                "quart",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎢᎬᏱ ᎩᏄᏘᏗ ᏅᏓ ᎤᏒ ᎡᎯ ᎤᎧᏛ"),
            keywords: &["ᎢᎬᏱ ᎩᏄᏘᏗ ᏅᏓ ᎤᏒ ᎡᎯ ᎤᎧᏛ", "ᎤᎧᏛ", "ᎩᏄᏘᏗ", "ᏅᏓ ᎤᏒ ᎡᎯ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("měsíc v první čtvrti s obličejem"),
            keywords: &[
                "dorůstající",
                "dorůstá",
                "fáze měsíce",
                "měsíc",
                "měsíc v první čtvrti s obličejem",
                "smajlík",
                "tvář",
                "vesmír",
                "výraz",
                "čtvrť",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("lleuad chwarter cyntaf gydag wyneb"),
            keywords: &[
                "chwarter",
                "gofod",
                "lleuad",
                "lleuad chwarter cyntaf gydag wyneb",
                "wyneb",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("måne med ansigt 1. fjerdedel"),
            keywords: &["måne", "måne med ansigt 1. fjerdedel", "måneansigt"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Mondsichel mit Gesicht links"),
            keywords: &["Gesicht", "Mondsichel", "Mondsichel mit Gesicht links"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("σελήνη πρώτου τετάρτου με πρόσωπο"),
            keywords: &[
                "πρόσωπο",
                "σελήνη πρώτου τετάρτου με πρόσωπο",
                "τέταρτο",
                "φεγγάρι",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("first quarter moon face"),
            keywords: &["face", "first quarter moon face", "moon", "quarter"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: Some("first-quarter moon face"),
            keywords: &["first-quarter moon face"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("luna de cuarto creciente con cara"),
            keywords: &[
                "cara",
                "creciente",
                "cuarto",
                "espacio",
                "luna",
                "luna de cuarto creciente con cara",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &[
                "cara",
                "creciente",
                "cuarto",
                "luna",
                "luna de cuarto creciente con cara",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("näoga kasvav kuu"),
            keywords: &[
                "ilm",
                "kosmos",
                "kuu",
                "nägu",
                "näoga kasvav kuu",
                "poolkuu",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("lehen ilargi-laurdena aurpegiarekin"),
            keywords: &[
                "aurpegi",
                "eguraldi",
                "espazio",
                "ilargi",
                "ilargi-laurdena ezkerrera begira",
                "lehen ilargi-laurdena aurpegiarekin",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("صورت یک\u{200c}چهارم اول"),
            keywords: &[
                "آب\u{200c}وهوا",
                "اول",
                "تربیع",
                "صورت",
                "فضا",
                "نخست",
                "یک\u{200c}چهارم",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kasvava puolikuu kasvoilla"),
            keywords: &[
                "kasvava puolikuu kasvoilla",
                "kasvot",
                "kuu",
                "puolikuu",
                "sää",
                "taivaankappale",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("first quarter moon na may mukha"),
            keywords: &[
                "buwan",
                "first quarter",
                "first quarter moon na may mukha",
                "mukha",
                "quarter",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("andlit á vaksandi mána"),
            keywords: &[
                "andlit",
                "andlit á vaksandi mána",
                "hálvmáni",
                "máni",
                "vaksandi",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("premier quartier de lune avec visage"),
            keywords: &["lune", "premier quartier de lune avec visage"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("premier quartier de lune avec visage"),
            keywords: &[
                "lune",
                "premier quartier",
                "premier quartier de lune avec visage",
                "visage",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("céad cheathrú na gealaí le haghaidh"),
            keywords: &[
                "aghaidh ghealaí",
                "corrán gealaí le haghaidh",
                "céad cheathrú na gealaí le haghaidh",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("solas ùr na gealaich le aodann"),
            keywords: &[
                "aodann",
                "ceathramh",
                "gealach",
                "gealach sa chiad cheathramh le aodann",
                "solas ùr na gealaich le aodann",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("lúa en cuarto crecente con cara"),
            keywords: &[
                "cara",
                "crecente",
                "cuarto",
                "lúa",
                "lúa en cuarto crecente con cara",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ચહ\u{ac7}રાવાળો શ\u{ac1}ક\u{acd}લ પક\u{acd}ષનો ચ\u{a82}દ\u{acd}ર"),
            keywords: &[
                "અર\u{acd}ધ ચ\u{a82}દ\u{acd}ર",
                "અર\u{acd}ધ ચ\u{a82}દ\u{acd}રનો ચહ\u{ac7}રો",
                "ચ\u{a82}દ\u{acd}ર",
                "ચહ\u{ac7}રા સાથ\u{ac7}નો અર\u{acd}ધ ચ\u{a82}દ\u{acd}ર",
                "ચહ\u{ac7}રાવાળો શ\u{ac1}ક\u{acd}લ પક\u{acd}ષનો ચ\u{a82}દ\u{acd}ર",
                "ચહ\u{ac7}રો",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("wata na farkon kwata tare da fuska"),
            keywords: &[
                "fuska",
                "kwata",
                "wata",
                "wata na farkon kwata tare da fuska",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("פני סהר מתמלא"),
            keywords: &["ירח", "סהר", "פני סהר מתמלא", "פנים"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("चौथाई माह क\u{947} चा\u{901}द वाला दाई\u{902} ओर च\u{947}हरा"),
            keywords: &[
                "च\u{947}हरा",
                "च\u{947}हर\u{947} वाला चा\u{902}द",
                "चौथाई माह क\u{947} चा\u{901}द वाला दाई\u{902} ओर च\u{947}हरा",
                "चौथाई माह क\u{947} चा\u{902}द वाला च\u{947}हरा",
                "पहल\u{947} चौथाई माह का चा\u{902}द",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("mjesec prve četvrti s licem"),
            keywords: &[
                "lice",
                "mjesec",
                "mjesec prve četvrti s licem",
                "svemir",
                "vrijeme",
                "četvrt",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("első negyedben lévő hold arccal"),
            keywords: &[
                "arc",
                "első negyed",
                "első negyedben lévő hold arccal",
                "hold",
                "holdfázisok",
                "ég",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("լուսինն առաջին քառորդում դեմքով"),
            keywords: &[
                "դեմք",
                "եղանակ",
                "լուսին",
                "լուսինն առաջին քառորդում դեմքով",
                "տիեզերք",
                "քառորդ",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("wajah bulan perbani awal"),
            keywords: &[
                "angkasa",
                "bulan",
                "cuaca",
                "seperempat",
                "wajah",
                "wajah bulan perbani awal",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ọnwa mbụ nke mmalite-afọ nwere ihu"),
            keywords: &[
                "ihu",
                "mbụ nke mmalite-afọ",
                "ọnwa",
                "ọnwa mbụ nke mmalite-afọ nwere ihu",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("fyrsta kvartil tungls með andliti"),
            keywords: &[
                "andlit",
                "fyrsta kvartil tungls",
                "fyrsta kvartil tungls með andliti",
                "máni",
                "tungl",
                "tunglsigð",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("faccina primo quarto di luna"),
            keywords: &[
                "faccina",
                "faccina primo quarto di luna",
                "luna",
                "luna con faccina",
                "primo quarto di luna",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("顔のある上弦の月"),
            keywords: &["上弦の月", "月", "顔", "顔のある上弦の月"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("rai bulan separo marep ngiwa"),
            keywords: &["bulan", "rai", "rai bulan separo marep ngiwa", "separo"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მთვარის პირველი მეოთხედი სახით"),
            keywords: &[
                "ამინდი",
                "კოსმოსი",
                "მეოთხედი",
                "მთვარე",
                "მთვარის პირველი მეოთხედი სახით",
                "სახე",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("беті бар бірінші ширек айы"),
            keywords: &[
                "ай",
                "ауа райы",
                "бет",
                "беті бар бірінші ширек айы",
                "ширек",
                "ғарыш",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("måne med ansigt første kvarter"),
            keywords: &["måne", "måne med ansigt første kvarter", "måneansigt"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ម\u{17bb}ខច\u{17c6}ន\u{17b7}តខែបែទៅឆ\u{17d2}វេង"),
            keywords: &[
                "ច\u{17c6}ន\u{17b7}តខែ",
                "ទៅឆ\u{17d2}វេង",
                "ម\u{17bb}ខ",
                "ម\u{17bb}ខច\u{17c6}ន\u{17b7}តខែបែទៅឆ\u{17d2}វេង",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಮೊದಲ ಕಾಲುಭಾಗದಷ\u{ccd}ಟು ಚಂದ\u{ccd}ರನ ಮುಖ"),
            keywords: &[
                "ಚಂದ\u{ccd}ರ",
                "ಮುಖ",
                "ಮುಖದೊಂದ\u{cbf}ಗ\u{cbf}ನ ಚಂದ\u{ccd}ರ",
                "ಮುಖದೊಂದ\u{cbf}ಗ\u{cc6} ಕಾಲುಭಾಗದ ಚಂದ\u{ccd}ರ",
                "ಮೊದಲ ಕಾಲುಭಾಗದಷ\u{ccd}ಟು ಚಂದ\u{ccd}ರನ ಮುಖ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("얼굴이 있는 초승달"),
            keywords: &["달", "달님", "얼굴이 있는 초승달"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("पयल\u{94d}या प\u{902}दरशीच\u{94d}या च\u{902}द\u{94d}राचो च\u{947}रो"),
            keywords: &[
                "च\u{902}द\u{94d}र",
                "च\u{947}रो",
                "प\u{902}दरस",
                "पयल\u{94d}या प\u{902}दरशीच\u{94d}या च\u{902}द\u{94d}राचो च\u{947}रो",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("жартысы толгон айдын бети"),
            keywords: &[
                "ай",
                "бет",
                "жартысы толгон",
                "жартысы толгон айдын бети",
                "космос",
            ],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("zouhuelenden Hallefmoundgesiicht"),
            keywords: &[
                "Gesiicht",
                "Hallef",
                "Mound",
                "Véierel",
                "zouhuelenden Hallefmoundgesiicht",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໜ\u{ec9}າເດ\u{eb7}ອນເຄ\u{eb4}\u{ec8}ງດວງທຳອ\u{eb4}ດ"),
            keywords: &[
                "ເຄ\u{eb4}\u{ec8}ງດວງ",
                "ເດ\u{eb7}ອນ",
                "ໜ\u{ec9}າ",
                "ໜ\u{ec9}າເດ\u{eb7}ອນເຄ\u{eb4}\u{ec8}ງດວງທຳອ\u{eb4}ດ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("priešpilnio mėnulis su veidu"),
            keywords: &[
                "ketvirtis",
                "mėnulis",
                "priešpilnio mėnulis su veidu",
                "veidas",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("augoša mēness sirpja seja"),
            keywords: &[
                "augoša mēness sirpja seja",
                "augošs",
                "mēness",
                "seja",
                "sirpis",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("marama ahotū whai mata"),
            keywords: &["hauwhā", "marama", "marama ahotū whai mata", "mata"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("прва четвртина на месечината со лице"),
            keywords: &[
                "вселена",
                "лице",
                "месечина",
                "прва",
                "прва четвртина на месечината со лице",
            ],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("അർദ\u{d4d}ധ പ\u{d57}ർണ\u{d4d}ണമി മ\u{d41}ഖം"),
            keywords: &[
                "അർദ\u{d4d}ധ പ\u{d57}ർണ\u{d4d}ണമി മ\u{d41}ഖം",
                "ചന\u{d4d}ദ\u{d4d}രക\u{d4d}കല",
                "ചന\u{d4d}ദ\u{d4d}രനിൽ മ\u{d41}ഖം",
                "ചന\u{d4d}ദ\u{d4d}രൻ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("нүүртэй эхний хагас сар"),
            keywords: &[
                "нүүр",
                "нүүртэй эхний хагас сар",
                "сар",
                "хагас",
                "цаг агаар",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("श\u{941}क\u{94d}लपक\u{94d}षातील अर\u{94d}धच\u{902}द\u{94d}राचा च\u{947}हरा"),
            keywords: &[
                "च\u{902}द\u{94d}र",
                "चत\u{941}र\u{94d}थी",
                "च\u{947}हरा",
                "श\u{941}क\u{94d}ल पक\u{94d}षातील अर\u{94d}धच\u{902}द\u{94d}राचा च\u{947}हरा",
                "श\u{941}क\u{94d}लपक\u{94d}षातील अर\u{94d}धच\u{902}द\u{94d}राचा च\u{947}हरा",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("muka bulan suku pertama"),
            keywords: &[
                "angkasa lepas",
                "bulan",
                "cuaca",
                "muka",
                "muka bulan suku pertama",
                "suku",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("wiċċ tal-ewwel kwart tal-qamar"),
            keywords: &["kwart", "qamar", "wiċċ", "wiċċ tal-ewwel kwart tal-qamar"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("လဆန\u{103a}းစ မျက\u{103a}န\u{103e}ာ"),
            keywords: &[
                "မျက\u{103a}န\u{103e}ာ",
                "လ",
                "လဆန\u{103a}းစ မျက\u{103a}န\u{103e}ာ",
                "လေးပ\u{102f}\u{1036}တစ\u{103a}ပ\u{102f}\u{1036}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("nymåne med ansikt"),
            keywords: &["kvartmåne med ansikt", "måneansikt", "nymåne med ansikt"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("अन\u{941}हारको आक\u{943}ति भएको पहिलो पक\u{94d}षीय चन\u{94d}द\u{94d}रमा"),
            keywords: &[
                "अन\u{941}हार",
                "अन\u{941}हारको आक\u{943}ति भएको पहिलो पक\u{94d}षीय चन\u{94d}द\u{94d}रमा",
                "एक चौ\u{902}थाइ",
                "चन\u{94d}द\u{94d}रमा",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("maan met gezicht in eerste kwartier"),
            keywords: &[
                "gezicht",
                "kwartier",
                "maan",
                "maan met gezicht in eerste kwartier",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("nymåne med andlet"),
            keywords: &["kvartmåne med andlet", "måneandlet", "nymåne med andlet"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some(
                "ପ\u{b4d}ରଥମ ଚତ\u{b41}ର\u{b4d}ଥ\u{b3e}ଂଶ ଚନ\u{b4d}ଦ\u{b4d}ର ମ\u{b41}ହ\u{b01}",
            ),
            keywords: &[
                "ଅର\u{b4d}ଦ\u{b4d}ଧ ଚନ\u{b4d}ଦ\u{b4d}ର",
                "ଅର\u{b4d}ଦ\u{b4d}ଧ ଚନ\u{b4d}ଦ\u{b4d}ର ମ\u{b41}ଖ",
                "ଚନ\u{b4d}ଦ\u{b4d}ର",
                "ପ\u{b4d}ରଥମ ଅର\u{b4d}ଦ\u{b4d}ଧ ଚନ\u{b4d}ଦ\u{b4d}ର",
                "ପ\u{b4d}ରଥମ ଚତ\u{b41}ର\u{b4d}ଥ\u{b3e}ଂଶ ଚନ\u{b4d}ଦ\u{b4d}ର ମ\u{b41}ହ\u{b01}",
                "ମ\u{b41}ଖ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਪਹਿਲੀ ਤਿਮਾਹੀ ਚ\u{a70}ਦ ਦਾ ਚਿਹਰਾ"),
            keywords: &[
                "ਚਿਹਰਾ",
                "ਚ\u{a70}ਦ",
                "ਚ\u{a70}ਦ ਦਾ ਚਿਹਰਾ",
                "ਤਿਮਾਹੀ",
                "ਤਿਮਾਹੀ ਚ\u{a70}ਦ ਦਾ ਚਿਹਰਾ",
                "ਪਹਿਲਾ ਤਿਮਾਹੀ ਚ\u{a70}ਦ",
                "ਪਹਿਲੀ ਤਿਮਾਹੀ ਚ\u{a70}ਦ ਦਾ ਚਿਹਰਾ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("شکل نال چاند دا پہلا چوتھائی حصہ"),
            keywords: &[
                "دی شکل",
                "شکل نال چاند دا پہلا چوتھائی حصہ",
                "چاند",
                "چوتھہ حص\u{651}ہ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Fẹ\u{301}st Kwọ\u{301}ta Mún Fes"),
            keywords: &[
                "Fes",
                "Fẹ\u{301}st Kwọ\u{301}ta Mún Fes",
                "Kwọ\u{301}ta",
                "Mun",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("pierwsza kwadra księżyca z twarzą"),
            keywords: &[
                "księżyc z twarzą",
                "pierwsza kwadra",
                "pierwsza kwadra księżyca",
                "pierwsza kwadra księżyca z twarzą",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("په لومړۍ ربع سپوږمۍ مخ"),
            keywords: &[
                "د لومړۍ ربع سپوږمۍ مخ",
                "ربع",
                "سپوږمۍ",
                "مخ",
                "په لومړۍ ربع سپوږمۍ مخ",
            ],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("rosto da lua de quarto crescente"),
            keywords: &[
                "lua",
                "lua com rosto",
                "lua de quarto crescente",
                "quarto crescente",
                "quarto crescente com rosto",
                "rosto",
                "rosto da lua de quarto crescente",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("lua em quarto crescente com cara"),
            keywords: &[
                "cara",
                "espaço",
                "lua",
                "lua em quarto crescente com cara",
                "meteorologia",
                "quarto",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("lună cu față în primul pătrar"),
            keywords: &[
                "față",
                "lună",
                "lună cu față în primul pătrar",
                "pătrar",
                "unu",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-226"),
            keywords: &["E10-226"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("луна в первой четверти с лицом"),
            keywords: &[
                "лицо",
                "луна",
                "луна в первой четверти с лицом",
                "месяц",
                "небо",
                "четверть",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("icya kane cya mbere cy’ukwezi gifite isura"),
            keywords: &[
                "icya kane cya mbere cy’ukwezi gifite isura",
                "icyakane",
                "isura",
                "ukwezi",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("چهري سان گڏ پهري عشري جو چنڊ"),
            keywords: &["عشرو", "چنڊ", "چهرو", "چهري سان گڏ پهري عشري جو چنڊ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ම\u{dd4}හ\u{dd4}ණ සහ\u{dd2}ත පළම\u{dd4} චත\u{dd4}ර\u{dca}ථක සඳ"),
            keywords: &[
                "අභ\u{dca}\u{200d}යවක\u{dcf}ශය",
                "ක\u{dcf}ලග\u{dd4}ණය",
                "චත\u{dd4}ර\u{dca}ථකය",
                "ම\u{dd4}හ\u{dd4}ණ",
                "ම\u{dd4}හ\u{dd4}ණ සහ\u{dd2}ත පළම\u{dd4} චත\u{dd4}ර\u{dca}ථක සඳ",
                "සඳ",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("mesiac v prvej štvrti s tvárou"),
            keywords: &[
                "mesiac",
                "mesiac v prvej štvrti s tvárou",
                "počasie",
                "tvár",
                "vesmír",
                "štvrť",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("polovično osvetljena luna v prvem krajcu z obrazom"),
            keywords: &[
                "luna",
                "obraz",
                "polovično osvetljena luna v prvem krajcu z obrazom",
                "vesolje",
                "vreme",
                "četrt",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("rubaca hore ee waji dayaxeedka"),
            keywords: &[
                "dayax",
                "rubac",
                "rubaca hore ee waji dayaxeedka",
                "rubaca hore waji dayaxeedka",
                "waji",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("hëna e çerekut të parë me fytyrë"),
            keywords: &[
                "fytyrë",
                "hapësirë",
                "hëna e çerekut të parë me fytyrë",
                "hënë",
                "çerek",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("месец у првој четврти са лицем"),
            keywords: &["лице", "месец", "месец у првој четврти са лицем", "чeтврт"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("мјесец у првој четврти са лицем"),
            keywords: &["мјесец у првој четврти са лицем"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("mesec u prvoj četvrti sa licem"),
            keywords: &["lice", "mesec", "mesec u prvoj četvrti sa licem", "četvrt"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("mjesec u prvoj četvrti sa licem"),
            keywords: &["mjesec u prvoj četvrti sa licem"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("tilltagande halvmåne med ansikte"),
            keywords: &[
                "ansikte",
                "gubben i månen",
                "halvmåne",
                "månansikte",
                "måne",
                "tilltagande halvmåne med ansikte",
            ],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mwezi wa robo ya kwanza wenye uso"),
            keywords: &[
                "anga",
                "hali ya hewa",
                "mwezi",
                "mwezi wa robo ya kwanza wenye uso",
                "robo",
                "uso",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("அரைப\u{bbe}தி வளர\u{bcd}பிறை முகம\u{bcd}"),
            keywords: &[
                "அரைப\u{bbe}தி வளர\u{bcd}பிறை முகம\u{bcd}",
                "நில\u{bbe}",
                "முகம\u{bcd}",
                "வளர\u{bcd}பிறை முகம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("న\u{c3e}లుగవ వంతు చంద\u{c4d}రున\u{c3f} ముఖం"),
            keywords: &[
                "చంద\u{c4d}రుడు",
                "న\u{c3e}లుగవ",
                "న\u{c3e}లుగవ వంతు చంద\u{c4d}రున\u{c3f} ముఖం",
                "ముఖం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("чоряки якуми моҳ бо чеҳра"),
            keywords: &["моҳ", "рӯй", "чоряк", "чоряки якуми моҳ бо чеҳра"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("หน\u{e49}าพระจ\u{e31}นทร\u{e4c}เส\u{e35}\u{e49}ยวขวา"),
            keywords: &[
                "หน\u{e49}าพระจ\u{e31}นทร\u{e4c}",
                "หน\u{e49}าพระจ\u{e31}นทร\u{e4c}เส\u{e35}\u{e49}ยวขวา",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ýüzli birinji çärýek aý"),
            keywords: &["aý", "çärýek", "ýüz", "ýüzli birinji çärýek aý"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("mata māhina tuʻu efiafi"),
            keywords: &["mata māhina tuʻu efiafi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("ilk dördün ay yüzü"),
            keywords: &[
                "ay",
                "dördün",
                "ilk dördün",
                "ilk dördün ay yüzü",
                "yüz",
                "yüzü olan ay",
                "yüzü olan ilk dördün",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("يۈزلۈك باش چارەك ئاي"),
            keywords: &["ئاي", "يۈزلۈك باش چارەك ئاي", "چارەك"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("перша чверть місяця з обличчям"),
            keywords: &[
                "космос",
                "місяць",
                "обличчя",
                "перша чверть місяця з обличчям",
                "погода",
                "чверть",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("پہلے کوارٹر کا چاند مع چہرہ"),
            keywords: &["موسم", "پہلے کوارٹر کا چاند مع چہرہ", "چاند", "چہرہ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("birinchi chorakdagi oy qiyofasi"),
            keywords: &[
                "birinchi chorakdagi oy qiyofasi",
                "chorak",
                "koinot",
                "ob-havo",
                "oy",
                "yuz",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("trăng thượng huyền hình mặt người"),
            keywords: &[
                "mặt",
                "phần tư",
                "trăng",
                "trăng thượng huyền hình mặt người",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("weeru xaaj bu njëkk"),
            keywords: &["kanam", "weer", "weeru xaaj bu njëkk", "xaaj bu njëkk"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("inyanga yekota yokuqala enobuso"),
            keywords: &[
                "ikota",
                "inyanga",
                "inyanga yekota yokuqala enobuso",
                "ubuso",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Oṣùpá Ìlàrin Àkọ\u{301}kọ\u{301} Pẹ\u{300}lú Ojú"),
            keywords: &[
                "Oṣùpá Ìlàrin Àkọ\u{301}kọ\u{301} Pẹ\u{300}lú Ojú",
                "ojú",
                "ìdámẹ\u{301}rin",
                "òṣùpá",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("上弦月面"),
            keywords: &["上弦月面", "四分之一", "月", "臉"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("上弦月面"),
            keywords: &["上弦月面", "四分之一", "月", "脸"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("微笑的上弦月"),
            keywords: &["微笑的上弦月", "月亮", "蛾眉月"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("彎月臉朝左"),
            keywords: &["上弦月", "彎月臉朝左", "月亮"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("上弦月嘅面孔"),
            keywords: &["上弦月嘅面孔", "月亮"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("inyanga yekota lokuqala elinobuso"),
            keywords: &[
                "inyanga",
                "inyanga yekota lokuqala elinobuso",
                "isimo sezulu",
                "ubuso",
                "umkhathi",
            ],
        },
    ],
};
#[doc = "🌜"]
pub const LAST_QUARTER_MOON_FACE: crate::Emoji = crate::Emoji {
    glyph: "🌜",
    codepoint: "1F31C",
    status: crate::Status::FullyQualified,
    introduction_version: 0.7f32,
    name: "last quarter moon face",
    group: "Travel & Places",
    subgroup: "sky & weather",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("laastekwartiermaan met gesig"),
            keywords: &[
                "gesig",
                "kwartier",
                "laaste",
                "laastekwartiermaan met gesig",
                "maan",
                "ruimte",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የመጨረሻ ሩብ ጨረቃ ከፊት ጋር"),
            keywords: &["ህዋ", "ሩብ", "የመጨረሻ ሩብ ጨረቃ ከፊት ጋር", "የአየር ንብረት", "ጨረቃ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("وجه تربيع ثان\u{64d}"),
            keywords: &["تربيع", "طقس", "فضا", "قمر", "وجه", "وجه تربيع ثان\u{64d}"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("চন\u{9cd}দ\u{9cd}ৰৰ অন\u{9cd}তিম চত\u{9c1}ৰ\u{9cd}থ\u{9be}ংশৰ ম\u{9c1}খ"),
            keywords: &[
                "চত\u{9c1}ৰ\u{9cd}থ\u{9be}ংশ",
                "চন\u{9cd}দ\u{9cd}ৰ",
                "চন\u{9cd}দ\u{9cd}ৰৰ অন\u{9cd}তিম চত\u{9c1}ৰ\u{9cd}থ\u{9be}ংশৰ ম\u{9c1}খ",
                "ম\u{9c1}খ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("ayın sonuncu dörddə bir hissəsinin üzü"),
            keywords: &[
                "ay",
                "ayın sonuncu dörddə bir hissəsinin üzü",
                "dörddə bir",
                "hava",
                "kosmos",
                "üz",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("месяц у апошняй чвэрці з тварам"),
            keywords: &[
                "апошняя",
                "квадра",
                "космас",
                "месяц",
                "месяц у апошняй чвэрці з тварам",
                "твар",
                "чвэрць",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Луната в последна четвърт с лице"),
            keywords: &[
                "Луната в последна четвърт с лице",
                "космос",
                "лице",
                "луна",
                "четвърт",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some(
                "ম\u{9c1}খের স\u{9be}থে চ\u{9be}\u{981}দের শেষ এক চত\u{9c1}র\u{9cd}থ\u{9be}ংশ",
            ),
            keywords: &[
                "চ\u{9be}\u{981}দ",
                "মহ\u{9be}ক\u{9be}শ",
                "ম\u{9c1}খ",
                "ম\u{9c1}খের স\u{9be}থে চ\u{9be}\u{981}দের শেষ এক চত\u{9c1}র\u{9cd}থ\u{9be}ংশ",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("penn loar vihan an digresk"),
            keywords: &["loar", "penn", "penn loar vihan an digresk"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("posljednja četvrtina lice"),
            keywords: &["lice", "mjesec", "posljednja četvrtina lice"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("lluna en l’últim quart amb cara"),
            keywords: &[
                "cara",
                "lluna",
                "lluna en l’últim quart amb cara",
                "minvant",
                "quart",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎣᏂᎢ ᎩᏄᏘᏗ ᏅᏓ ᎤᏒ ᎡᎯ ᎤᎧᏛ"),
            keywords: &["ᎣᏂᎢ ᎩᏄᏘᏗ ᏅᏓ ᎤᏒ ᎡᎯ ᎤᎧᏛ", "ᎤᎧᏛ", "ᎩᏄᏘᏗ", "ᏅᏓ ᎤᏒ ᎡᎯ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("měsíc v poslední čtvrti s obličejem"),
            keywords: &[
                "couvající",
                "couvá",
                "fáze měsíce",
                "měsíc",
                "měsíc v poslední čtvrti s obličejem",
                "smajlík",
                "tvář",
                "ubývající",
                "ubývá",
                "vesmír",
                "výraz",
                "čtvrť",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("lleuad chwarter olaf gydag wyneb"),
            keywords: &[
                "chwarter",
                "gofod",
                "lleuad",
                "lleuad chwarter olaf gydag wyneb",
                "wyneb",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("måne med ansigt 4. fjerdedel"),
            keywords: &["måne", "måne med ansigt 4. fjerdedel", "måneansigt"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Mondsichel mit Gesicht rechts"),
            keywords: &["Gesicht", "Mondsichel", "Mondsichel mit Gesicht rechts"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("σελήνη τελευταίου τετάρτου με πρόσωπο"),
            keywords: &[
                "πρόσωπο",
                "σελήνη τελευταίου τετάρτου με πρόσωπο",
                "τέταρτο",
                "φεγγάρι",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("last quarter moon face"),
            keywords: &["face", "last quarter moon face", "moon", "quarter"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: Some("last-quarter moon face"),
            keywords: &["last-quarter moon face"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("luna de cuarto menguante con cara"),
            keywords: &[
                "cara",
                "creciente",
                "cuarto",
                "espacio",
                "luna",
                "luna de cuarto menguante con cara",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &[
                "cara",
                "cuarto",
                "luna",
                "luna de cuarto menguante con cara",
                "menguante",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("näoga kahanev kuu"),
            keywords: &[
                "ilm",
                "kosmos",
                "kuu",
                "nägu",
                "näoga kahanev kuu",
                "poolkuu",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("azken ilargi-laurdena aurpegiarekin"),
            keywords: &[
                "aurpegi",
                "azken ilargi-laurdena aurpegiarekin",
                "eguraldi",
                "espazio",
                "ilargi",
                "ilargi-laurdena eskuinera begira",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("صورت یک\u{200c}چهارم آخر"),
            keywords: &[
                "آب\u{200c}وهوا",
                "آفتابی",
                "اشعه",
                "روشن",
                "صورت یک\u{200c}چهارم آخر",
                "فضا",
                "پرنور",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("vähenevä puolikuu kasvoilla"),
            keywords: &[
                "kasvot",
                "kuu",
                "puolikuu",
                "sää",
                "taivaankappale",
                "vähenevä puolikuu kasvoilla",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("last quarter moon na may mukha"),
            keywords: &[
                "buwan",
                "last quarter",
                "last quarter moon na may mukha",
                "mukha",
                "quarter",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("andlit á minkandi mána"),
            keywords: &[
                "andlit",
                "andlit á minkandi mána",
                "hálvmáni",
                "minkandi",
                "máni",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("dernier quartier de lune avec visage"),
            keywords: &["dernier quartier de lune avec visage", "lune"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("dernier quartier de lune avec visage"),
            keywords: &[
                "dernier quartier",
                "dernier quartier de lune avec visage",
                "lune",
                "visage",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("ceathrú deireanach na gealaí le haghaidh"),
            keywords: &[
                "aghaidh ghealaí",
                "aghaidh ghealaí ina ceathrú dheireanach",
                "ceathrú",
                "ceathrú deireanach na gealaí le haghaidh",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("deireadh na gealaich le aodann"),
            keywords: &[
                "aodann",
                "ceathramh",
                "deireadh na gealaich le aodann",
                "gealach",
                "gealach sa cheathramh mu dheireadh le aodann",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("lúa en cuarto minguante con cara"),
            keywords: &[
                "cara",
                "cuarto",
                "lúa",
                "lúa en cuarto minguante con cara",
                "minguante",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ચહ\u{ac7}રાવાળો ક\u{ac3}ષ\u{acd}ણ પક\u{acd}ષનો ચ\u{a82}દ\u{acd}ર"),
            keywords: &[
                "અર\u{acd}ધ ચ\u{a82}દ\u{acd}ર",
                "ચ\u{a82}દ\u{acd}ર",
                "ચહ\u{ac7}રા સાથ\u{ac7}નો અર\u{acd}ધ ચ\u{a82}દ\u{acd}ર",
                "ચહ\u{ac7}રાવાળો ક\u{ac3}ષ\u{acd}ણ પક\u{acd}ષનો ચ\u{a82}દ\u{acd}ર",
                "ચહ\u{ac7}રો",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("wata na ƙarshen kwata tare da fuska"),
            keywords: &[
                "fuska",
                "kwata",
                "wata",
                "wata na ƙarshen kwata tare da fuska",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("פני סהר מתרוקן"),
            keywords: &["ירח", "סהר", "פני סהר מתרוקן", "פנים"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("चौथाई माह क\u{947} चा\u{901}द वाला बाई\u{902} ओर च\u{947}हरा"),
            keywords: &[
                "च\u{947}हरा",
                "च\u{947}हर\u{947} वाला चा\u{902}द",
                "चौथाई माह क\u{947} चा\u{901}द वाला बाई\u{902} ओर च\u{947}हरा",
                "चौथाई माह क\u{947} चा\u{902}द वाला बाई\u{902} ओर च\u{947}हरा",
                "तीसर\u{947} चौथाई माह का चा\u{902}द",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("mjesec posljednje četvrti s licem"),
            keywords: &[
                "lice",
                "mjesec",
                "mjesec posljednje četvrti s licem",
                "svemir",
                "vrijeme",
                "četvrt",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("utolsó negyedben lévő hold arccal"),
            keywords: &[
                "arc",
                "hold",
                "holdfázisok",
                "utolsó negyed",
                "utolsó negyedben lévő hold arccal",
                "ég",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("լուսինը երկրորդ քառորդում դեմքով"),
            keywords: &[
                "դեմք",
                "եղանակ",
                "լուսին",
                "լուսինը երկրորդ քառորդում դեմքով",
                "տիեզերք",
                "քառորդ",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("wajah bulan perbani akhir"),
            keywords: &[
                "angkasa",
                "bulan",
                "cuaca",
                "seperempat",
                "wajah",
                "wajah bulan perbani akhir",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ọnwa ikpeazu nke ọgwụgwụ-afọ nwere ihu"),
            keywords: &[
                "ihu",
                "mbụ nke mmalite-afọ",
                "ọnwa",
                "ọnwa ikpeazu nke ọgwụgwụ-afọ nwere ihu",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("síðasta kvartil tungls með andliti"),
            keywords: &[
                "andlit",
                "máni",
                "síðasta kvartil tungls",
                "síðasta kvartil tungls með andliti",
                "tungl",
                "tunglsigð",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("faccina ultimo quarto di luna"),
            keywords: &[
                "faccina",
                "faccina ultimo quarto di luna",
                "luna",
                "luna con faccina",
                "ultimo quarto di luna",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("顔のある下弦の月"),
            keywords: &["下弦の月", "月", "顔", "顔のある下弦の月"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("rai bulan separo marep nengen"),
            keywords: &["bulan", "rai", "rai bulan separo marep nengen", "separo"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მთვარის ბოლო მეოთხედი სახით"),
            keywords: &[
                "ამინდი",
                "კოსმოსი",
                "მეოთხედი",
                "მთვარე",
                "მთვარის ბოლო მეოთხედი სახით",
                "სახე",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("беті бар соңғы ширек айы"),
            keywords: &["ай", "бет", "беті бар соңғы ширек айы", "ширек", "ғарыш"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("måne med ansigt andet kvarter"),
            keywords: &["måne", "måne med ansigt andet kvarter", "måneansigt"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ម\u{17bb}ខច\u{17c6}ន\u{17b7}តខែបែទៅស\u{17d2}តា\u{17c6}"),
            keywords: &[
                "ច\u{17c6}ន\u{17b7}តខែ",
                "ទៅស\u{17d2}តា\u{17c6}",
                "ម\u{17bb}ខ",
                "ម\u{17bb}ខច\u{17c6}ន\u{17b7}តខែបែទៅស\u{17d2}តា\u{17c6}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕೊನ\u{cc6}ಯ ಕಾಲುಭಾಗದಷ\u{ccd}ಟು ಚಂದ\u{ccd}ರನ ಮುಖ"),
            keywords: &[
                "ಕಾಲುಭಾಗ",
                "ಕೊನ\u{cc6}ಯ ಕಾಲುಭಾಗ ಚಂದ\u{ccd}ರನ ಮುಖ",
                "ಕೊನ\u{cc6}ಯ ಕಾಲುಭಾಗದಷ\u{ccd}ಟು ಚಂದ\u{ccd}ರನ ಮುಖ",
                "ಮುಖ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("그믐달"),
            keywords: &["그믐달", "달", "달님", "얼굴이 있는 그믐달"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("निमाण\u{94d}या प\u{902}दरशीच\u{94d}या च\u{902}द\u{94d}राचो च\u{947}रो"),
            keywords: &[
                "च\u{902}द\u{94d}र",
                "च\u{947}रो",
                "निमाण\u{94d}या प\u{902}दरशीच\u{94d}या च\u{902}द\u{94d}राचो च\u{947}रो",
                "प\u{902}दरस",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("жартысы бөксөргөн айдын бети"),
            keywords: &[
                "ай",
                "бет",
                "жартысы бөксөргөн",
                "жартысы бөксөргөн айдын бети",
                "космос",
            ],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("ofhuelenden Hallefmoundgesiicht"),
            keywords: &[
                "Gesiicht",
                "Hallef",
                "Mound",
                "Véierel",
                "ofhuelenden Hallefmoundgesiicht",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໜ\u{ec9}າເດ\u{eb7}ອນເຄ\u{eb4}\u{ec8}ງດວງສ\u{eb8}ດທ\u{ec9}າຍ"),
            keywords: &[
                "ເຄ\u{eb4}\u{ec8}ງດວງ",
                "ເດ\u{eb7}ອນ",
                "ໜ\u{ec9}າ",
                "ໜ\u{ec9}າເດ\u{eb7}ອນເຄ\u{eb4}\u{ec8}ງດວງສ\u{eb8}ດທ\u{ec9}າຍ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("delčios mėnulis su veidu"),
            keywords: &["delčios mėnulis su veidu", "ketvirtis", "mėnulis", "veidas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("dilstoša mēness sirpja seja"),
            keywords: &[
                "dilstoša mēness sirpja seja",
                "dilstošs",
                "mēness",
                "seja",
                "sirpis",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("marama korekore whai mata"),
            keywords: &["hauwhā", "marama", "marama korekore whai mata", "mata"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("посл. четврт. на месечина со лице"),
            keywords: &[
                "вселена",
                "лице",
                "месечина",
                "посл. четврт. на месечина со лице",
                "последна",
                "последна четвртина на месечината со лице",
            ],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("അർദ\u{d4d}ധ അമ\u{d3e}വ\u{d3e}സി മ\u{d41}ഖം"),
            keywords: &[
                "അർദ\u{d4d}ധ അമ\u{d3e}വ\u{d3e}സി മ\u{d41}ഖം",
                "ചന\u{d4d}ദ\u{d4d}രക\u{d4d}കല",
                "ചന\u{d4d}ദ\u{d4d}രനിൽ മ\u{d41}ഖം",
                "ചന\u{d4d}ദ\u{d4d}രൻ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("нүүртэй сүүлийн хагас сар"),
            keywords: &["нүүр", "нүүртэй сүүлийн хагас сар", "сар", "хагас"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("अर\u{94d}धच\u{902}द\u{94d}राचा च\u{947}हरा"),
            keywords: &[
                "अर\u{94d}धच\u{902}द\u{94d}राचा च\u{947}हरा",
                "क\u{943}ष\u{94d}णपक\u{94d}षातील च\u{902}द\u{94d}राचा च\u{947}हरा",
                "च\u{902}द\u{94d}र",
                "चत\u{941}र\u{94d}थी",
                "च\u{947}हरा",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("muka bulan suku terakhir"),
            keywords: &[
                "angkasa lepas",
                "bulan",
                "cuaca",
                "muka",
                "muka bulan suku terakhir",
                "suku",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("wiċċ tal-aħħar kwart tal-qamar"),
            keywords: &["kwart", "qamar", "wiċċ", "wiċċ tal-aħħar kwart tal-qamar"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("လဆ\u{102f}တ\u{103a}လ\u{102f} မျက\u{103a}န\u{103e}ာ"),
            keywords: &[
                "မျက\u{103a}န\u{103e}ာ",
                "လ",
                "လဆ\u{102f}တ\u{103a}လ\u{102f} မျက\u{103a}န\u{103e}ာ",
                "လေးပ\u{102f}\u{1036}တစ\u{103a}ပ\u{102f}\u{1036}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("nemåne med ansikt"),
            keywords: &["kvartmåne med ansikt", "måneansikt", "nemåne med ansikt"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some(
                "अन\u{941}हारको आक\u{943}\u{943}ति भएको अन\u{94d}तिम पक\u{94d}षीय चन\u{94d}द\u{94d}रमा",
            ),
            keywords: &[
                "अन\u{941}हार",
                "अन\u{941}हारको आक\u{943}ति भएको अन\u{94d}तिम पक\u{94d}षीय चन\u{94d}द\u{94d}रमा",
                "अन\u{941}हारको आक\u{943}\u{943}ति भएको अन\u{94d}तिम पक\u{94d}षीय चन\u{94d}द\u{94d}रमा",
                "एक चौ\u{902}थाइ",
                "चन\u{94d}द\u{94d}रमा",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("maan met gezicht in laatste kwartier"),
            keywords: &[
                "gezicht",
                "kwartier",
                "maan",
                "maan met gezicht in laatste kwartier",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("nemåne med andlet"),
            keywords: &["kvartmåne med andlet", "måneandlet", "nemåne med andlet"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଶେଷ ଚତ\u{b41}ର\u{b4d}ଥ\u{b3e}ଂଶ ଚନ\u{b4d}ଦ\u{b4d}ର ମ\u{b41}ହ\u{b01}"),
            keywords: &[
                "ଅର\u{b4d}ଦ\u{b4d}ଧ ଚନ\u{b4d}ଦ\u{b4d}ର",
                "ଅର\u{b4d}ଦ\u{b4d}ଧ ଚନ\u{b4d}ଦ\u{b4d}ର ମ\u{b41}ଖ",
                "ଚନ\u{b4d}ଦ\u{b4d}ର",
                "ମ\u{b41}ଖ",
                "ଶେଷ ଅର\u{b4d}ଦ\u{b4d}ଧ ଚନ\u{b4d}ଦ\u{b4d}ର",
                "ଶେଷ ଚତ\u{b41}ର\u{b4d}ଥ\u{b3e}ଂଶ ଚନ\u{b4d}ଦ\u{b4d}ର ମ\u{b41}ହ\u{b01}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਆਖਰੀ ਤਿਮਾਹੀ ਚ\u{a70}ਦ ਦਾ ਚਿਹਰਾ"),
            keywords: &[
                "ਆਖਰੀ ਤਿਮਾਹੀ ਚ\u{a70}ਦ ਦਾ ਚਿਹਰਾ",
                "ਚਿਹਰਾ",
                "ਚ\u{a70}ਦ",
                "ਚ\u{a70}ਦ ਦਾ ਚਿਹਰਾ",
                "ਤਿਮਾਹੀ",
                "ਤਿਮਾਹੀ ਚ\u{a70}ਦ ਦਾ ਚਿਹਰਾ",
                "ਪਿਛਲਾ ਤਿਮਾਹੀ ਚ\u{a70}ਦ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("شکل نال چاند دا آخری چوتھائی حصہ"),
            keywords: &[
                "دی شکل",
                "شکل نال چاند دا آخری چوتھائی حصہ",
                "چاند",
                "چوتھہ حص\u{651}ہ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Lást Kwọ\u{301}ta Mún Fes"),
            keywords: &["Fes", "Kwọ\u{301}tá", "Lást Kwọ\u{301}ta Mún Fes", "Mun"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("ostatnia kwadra księżyca z twarzą"),
            keywords: &[
                "księżyc z twarzą",
                "ostatnia kwadra",
                "ostatnia kwadra księżyca",
                "ostatnia kwadra księżyca z twarzą",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د ورستۍ ربع د سپوږمۍ مخ"),
            keywords: &["د ورستۍ ربع د سپوږمۍ مخ", "ربع", "سپوږمۍ", "مخ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("rosto da lua de quarto minguante"),
            keywords: &[
                "lua",
                "lua com rosto",
                "lua de quarto minguante",
                "quarto minguante",
                "quarto minguante com rosto",
                "rosto",
                "rosto da lua de quarto minguante",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("lua em quarto minguante com cara"),
            keywords: &[
                "cara",
                "espaço",
                "lua",
                "lua em quarto minguante com cara",
                "meteorologia",
                "quarto",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("lună în ultimul pătrar cu față"),
            keywords: &[
                "față",
                "lună",
                "lună în ultimul pătrar cu față",
                "patru",
                "pătrar",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-227"),
            keywords: &["E10-227"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("луна в последней четверти с лицом"),
            keywords: &[
                "лицо",
                "луна",
                "луна в последней четверти с лицом",
                "месяц",
                "небо",
                "четверть",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("icya kane cya nyuma cy’ukwezi gifite isura"),
            keywords: &[
                "icya kane cya nyuma cy’ukwezi gifite isura",
                "icyakane",
                "isura",
                "ukwezi",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("چهري سان گڏ آخري عشري جو چنڊ"),
            keywords: &["عشرو", "چنڊ", "چهرو", "چهري سان گڏ آخري عشري جو چنڊ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ම\u{dd4}හ\u{dd4}ණ සහ\u{dd2}ත අවසන\u{dca} චත\u{dd4}ර\u{dca}ථක සඳ"),
            keywords: &[
                "අභ\u{dca}\u{200d}යවක\u{dcf}ශය",
                "ක\u{dcf}ලග\u{dd4}ණය",
                "චත\u{dd4}ර\u{dca}ථකය",
                "ම\u{dd4}හ\u{dd4}ණ",
                "ම\u{dd4}හ\u{dd4}ණ සහ\u{dd2}ත අවසන\u{dca} චත\u{dd4}ර\u{dca}ථක සඳ",
                "සඳ",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("mesiac v poslednej štvrti s tvárou"),
            keywords: &[
                "mesiac",
                "mesiac v poslednej štvrti s tvárou",
                "počasie",
                "tvár",
                "vesmír",
                "štvrť",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("polovično osvetljena luna v zadnjem krajcu z obrazom"),
            keywords: &[
                "luna",
                "obraz",
                "polovično osvetljena luna v zadnjem krajcu z obrazom",
                "vesolje",
                "vreme",
                "četrt",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("waji dayaxeedda rubaca dambe"),
            keywords: &["waji", "waji dayaxeedda rubaca dambe"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("hëna e çerekut të fundit me fytyrë"),
            keywords: &[
                "fytyrë",
                "hapësirë",
                "hëna e çerekut të fundit me fytyrë",
                "hënë",
                "çerek",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("месец у последњој четврти са лицем"),
            keywords: &[
                "лице",
                "месец",
                "месец у последњој четврти са лицем",
                "чeтврт",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("мјесец у посљедњој четврти са лицем"),
            keywords: &["мјесец у посљедњој четврти са лицем"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("mesec u poslednjoj četvrti sa licem"),
            keywords: &[
                "lice",
                "mesec",
                "mesec u poslednjoj četvrti sa licem",
                "četvrt",
            ],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("mjesec u posljednjoj četvrti sa licem"),
            keywords: &["mjesec u posljednjoj četvrti sa licem"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("avtagande halvmåne med ansikte"),
            keywords: &[
                "ansikte",
                "avtagande halvmåne med ansikte",
                "gubben i månen",
                "halvmåne",
                "månansikte",
                "måne",
            ],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mwezi wa robo ya mwisho wenye uso"),
            keywords: &[
                "anga",
                "hali ya hewa",
                "mwezi",
                "mwezi wa robo ya mwisho wenye uso",
                "robo",
                "uso",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("அரைப\u{bbe}தி தேய\u{bcd}பிறை முகம\u{bcd}"),
            keywords: &[
                "அரைப\u{bbe}தி தேய\u{bcd}பிறை முகம\u{bcd}",
                "தேய\u{bcd}பிறை முகம\u{bcd}",
                "நில\u{bbe}",
                "முகம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("చ\u{c3f}వర\u{c3f} న\u{c3e}లుగవ వంతు చంద\u{c4d}రున\u{c3f} ముఖం"),
            keywords: &[
                "చంద\u{c4d}రుడు",
                "చ\u{c3f}వర\u{c3f} న\u{c3e}లుగవ వంతు చంద\u{c4d}రున\u{c3f} ముఖం",
                "న\u{c3e}లుగవ",
                "ముఖం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("чоряки охири моҳ бо чеҳра"),
            keywords: &["моҳ", "рӯй", "чоряк", "чоряки охири моҳ бо чеҳра"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("หน\u{e49}าพระจ\u{e31}นทร\u{e4c}เส\u{e35}\u{e49}ยวซ\u{e49}าย"),
            keywords: &[
                "หน\u{e49}าพระจ\u{e31}นทร\u{e4c}",
                "หน\u{e49}าพระจ\u{e31}นทร\u{e4c}เส\u{e35}\u{e49}ยวซ\u{e49}าย",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ýüzli soňky çärýek aý"),
            keywords: &["aý", "çärýek", "ýüz", "ýüzli soňky çärýek aý"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("mata māhina tuʻu hengihengi"),
            keywords: &["mata māhina tuʻu hengihengi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("son dördün ay yüzü"),
            keywords: &[
                "ay",
                "dördün",
                "son dördün",
                "son dördün ay yüzü",
                "yüz",
                "yüzü olan ay",
                "yüzü olan son dördün",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("يۈزلۈك ئاخىرقى چارەك ئاي"),
            keywords: &["ئاي", "يۈزلۈك ئاخىرقى چارەك ئاي", "چارەك"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("остання чверть місяця з обличчям"),
            keywords: &[
                "космос",
                "місяць",
                "обличчя",
                "остання чверть місяця з обличчям",
                "погода",
                "чверть",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("آخری کوارٹر کا چاند مع چہرہ"),
            keywords: &["آخری کوارٹر کا چاند مع چہرہ", "موسم", "چاند", "چہرہ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("oxirgi chorakdagi oy qiyofasi"),
            keywords: &[
                "chorak",
                "koinot",
                "ob-havo",
                "oxirgi chorakdagi oy qiyofasi",
                "oy",
                "yuz",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("trăng hạ huyền hình mặt người"),
            keywords: &[
                "mặt",
                "mặt trăng",
                "phần tư",
                "trăng hạ huyền hình mặt người",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("weeru ñeenteelu xaaj"),
            keywords: &["kanam", "weer", "weeru ñeenteelu xaaj", "xaaj bu njëkk"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("inyanga yekota yokugqibela enobuso"),
            keywords: &[
                "ikota",
                "inyanga",
                "inyanga yekota yokugqibela enobuso",
                "ubuso",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Oṣùpá Ìlàrin Ìgbẹ\u{300}yìn Pẹ\u{300}lú Ojú"),
            keywords: &[
                "Oṣùpá Ìlàrin Ìgbẹ\u{300}yìn Pẹ\u{300}lú Ojú",
                "ojú",
                "ìdámẹ\u{301}rin",
                "òṣùpá",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("下弦月面"),
            keywords: &["下弦月面", "四分之一", "月", "臉"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("下弦月面"),
            keywords: &["下弦月面", "四分之一", "月", "脸"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("微笑的下弦月"),
            keywords: &["微笑的下弦月", "月亮", "残月"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("彎月臉朝右"),
            keywords: &["下弦月", "彎月臉朝右", "月亮"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("下弦月嘅面孔"),
            keywords: &["下弦月", "下弦月嘅面孔", "月亮"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ikota yokugcina yenyanga enobuso"),
            keywords: &[
                "ikota yokugcina yenyanga enobuso",
                "inyanga",
                "isimo sezulu",
                "ubuso",
                "umkhathi",
            ],
        },
    ],
};
#[doc = "🌡\u{fe0f}"]
pub const THERMOMETER: crate::Emoji = crate::Emoji {
    glyph: "🌡\u{fe0f}",
    codepoint: "1F321 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.7f32,
    name: "thermometer",
    group: "Travel & Places",
    subgroup: "sky & weather",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🌡",
        codepoint: "1F321",
        status: crate::Status::Unqualified,
        introduction_version: 0.7f32,
        name: "thermometer",
        group: "Travel & Places",
        subgroup: "sky & weather",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("termometer"),
            keywords: &["temperatuur", "termometer", "weer"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ቴርሞሜትር"),
            keywords: &["ቴርሞሜትር", "የአየር ንብረት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("ترمومتر"),
            keywords: &["ترمومتر", "طقس"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("থ\u{9be}ৰ\u{9cd}ম’মিট\u{9be}ৰ"),
            keywords: &["থ\u{9be}ৰ\u{9cd}ম’মিট\u{9be}ৰ", "বতৰ"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("termometr"),
            keywords: &["hava", "termometr"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("тэрмометр"),
            keywords: &["надвор’е", "тэмпература", "тэрмометр"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("термометър"),
            keywords: &["време", "термометър"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("থ\u{9be}র\u{9cd}মোমিট\u{9be}র"),
            keywords: &[
                "আবহ\u{9be}ওয\u{9bc}\u{9be}",
                "থ\u{9be}র\u{9cd}মোমিট\u{9be}র",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("gwerzverker"),
            keywords: &["amzer", "gwerzverker"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("termometar"),
            keywords: &["termometar", "vrijeme"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("termòmetre"),
            keywords: &["temperatura", "temps", "termòmetre"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᏗᏞᎬᎢ ᎤᎦᎾᏮ ᎠᏎᎯᎯ"),
            keywords: &["ᎤᏗᏞᎬᎢ ᎤᎦᎾᏮ ᎠᏎᎯᎯ", "ᏙᏱᏗᏜ ᏂᎦᎵᏍᏔᏅᏍᎬᎢ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("teploměr"),
            keywords: &["počasí", "teplo", "teploměr", "teplota", "teplé"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("thermomedr"),
            keywords: &["thermomedr", "tywydd"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("termometer"),
            keywords: &["termometer", "vejr"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Thermometer"),
            keywords: &["Temperatur", "Thermometer", "Wetter"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("θερμόμετρο"),
            keywords: &["θερμόμετρο", "καιρός"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("thermometer"),
            keywords: &["thermometer", "weather"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("termómetro"),
            keywords: &["temperatura", "termómetro"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["clima", "temperatura", "termómetro"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kraadiklaas"),
            keywords: &["ilm", "kraadiklaas"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("termometro"),
            keywords: &["eguraldi", "termometro"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("دماسنج"),
            keywords: &["آب\u{200c}وهوا", "دما", "دماسنج", "هوا"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("lämpömittari"),
            keywords: &["lämpömittari", "lämpötila", "sää"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("thermometer"),
            keywords: &["lagay ng panahon", "panahon", "thermometer"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("termometur"),
            keywords: &["fepurstokkur", "hitamálari", "termometur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("thermomètre"),
            keywords: &["météo", "thermomètre"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("teirmiméadar"),
            keywords: &["aimsir", "teirmiméadar"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("teas-mheidh"),
            keywords: &["aimsir", "sìde", "teas-mheidh"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("termómetro"),
            keywords: &["temperatura", "termómetro"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("થર\u{acd}મોમીટર"),
            keywords: &["થર\u{acd}મોમીટર", "હવામાન"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("mai aunin zafin jiki"),
            keywords: &["mai aunin zafin jiki", "yanayi"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("מדחום"),
            keywords: &["מדחום", "מזג אוויר", "תרמומטר"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("थर\u{94d}मामीटर"),
            keywords: &["थर\u{94d}मामीटर", "मौसम"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("termometar"),
            keywords: &["termometar", "vrijeme"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("hőmérő"),
            keywords: &["hőmérő", "időjárás"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ջերմաչափ"),
            keywords: &["եղանակ", "ջերմաչափ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("termometer"),
            keywords: &["cuaca", "termometer"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("tamomịta"),
            keywords: &["tamomịta", "ọnọdụ ihu eluigwe"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("hitamælir"),
            keywords: &["hitamælir", "veður"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("termometro"),
            keywords: &["clima", "meteo", "temperatura", "termometro"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("温度計"),
            keywords: &["天気", "気温", "温度", "温度計"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("termometer"),
            keywords: &["cuaca", "termometer"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("თერმომეტრი"),
            keywords: &["ამინდი", "თერმომეტრი"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("atirmumitr"),
            keywords: &["atirmumitr"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("термометр"),
            keywords: &["ауа райы", "термометр"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("termometer"),
            keywords: &["termometer", "vejr"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ឧបករណ\u{17cd}វាស\u{17cb}កម\u{17d2}តៅ"),
            keywords: &[
                "វាស\u{17cb}កម\u{17d2}តៅ",
                "ឧបករណ\u{17cd}វាស\u{17cb}កម\u{17d2}តៅ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಥರ\u{ccd}ಮಾಮೀಟರ\u{ccd}"),
            keywords: &["ಥರ\u{ccd}ಮಾಮೀಟರ\u{ccd}", "ಹವಾಮಾನ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("온도계"),
            keywords: &["온도", "온도계"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("थर\u{94d}मोमीटर"),
            keywords: &["थर\u{94d}मोमीटर", "हवामान"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("термометр"),
            keywords: &["аба ырайы", "термометр"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Thermometer"),
            keywords: &["Thermometer", "Wieder"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເຄ\u{eb7}\u{ec8}ອງວ\u{eb1}ດແທກອ\u{eb8}ນຫະພ\u{eb9}ມ"),
            keywords: &[
                "ສະພາບອາກາດ",
                "ອາກາດ",
                "ຮ\u{ec9}ອນ",
                "ເຄ\u{eb7}\u{ec8}ອງວ\u{eb1}ດແທກອ\u{eb8}ນຫະພ\u{eb9}ມ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("termometras"),
            keywords: &["oras", "termometras"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("termometrs"),
            keywords: &["temperatūra", "termometrs"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("inemahana"),
            keywords: &["huarere", "inemahana"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("термометар"),
            keywords: &["време", "температура", "термометар"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("തെർമോമീറ\u{d4d}റർ"),
            keywords: &[
                "അസ\u{d41}ഖം",
                "ക\u{d3e}ല\u{d3e}വസ\u{d4d}ഥ",
                "തെർമോമീറ\u{d4d}റർ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("термометр"),
            keywords: &["термометр", "цаг агаар"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("थर\u{94d}मामीटर"),
            keywords: &["थर\u{94d}मामीटर", "हवामान"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("termometer"),
            keywords: &["cuaca", "termometer"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("termometru"),
            keywords: &["temp", "termometru"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("သာမ\u{102d}\u{102f}မ\u{102e}တာ"),
            keywords: &["မ\u{102d}\u{102f}းလေဝသ", "သာမ\u{102d}\u{102f}မ\u{102e}တာ"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("termometer"),
            keywords: &["temperatur", "termometer", "vær"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("थर\u{94d}मोमिटर"),
            keywords: &["थर\u{94d}मोमिटर", "मौसम"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("thermometer"),
            keywords: &["thermometer", "weer"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("termometer"),
            keywords: &["temperatur", "termometer", "vêr"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଥର\u{b4d}ମୋମ\u{b3f}ଟର\u{b4d}"),
            keywords: &["ଥର\u{b4d}ମୋମ\u{b3f}ଟର\u{b4d}", "ପ\u{b3e}ଣ\u{b3f}ପ\u{b3e}ଗ"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਥਰਮਾਮੀਟਰ"),
            keywords: &["ਤਾਪਮਾਨ", "ਥਰਮਾਮੀਟਰ", "ਮ\u{a4c}ਸਮ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("حرارت پیما"),
            keywords: &["حرارت پیما", "موسم"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Tamómíta"),
            keywords: &["Tamómíta", "Wẹ\u{301}da"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("termometr"),
            keywords: &["pogoda", "temperatura", "termometr"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ترمامیتر"),
            keywords: &["ترماميتر", "ترمامیتر", "موسم"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("termômetro"),
            keywords: &["clima", "tempo", "termômetro"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("termómetro"),
            keywords: &["meteorologia", "temperatura", "termómetro"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("termometro"),
            keywords: &["llaphiya", "termometro"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("termometru"),
            keywords: &["temperatură", "termometru", "vreme"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-232"),
            keywords: &["E10-232"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("термометр"),
            keywords: &["градусник", "измерение", "температура", "термометр"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("igipimo cy’ubushyuhe"),
            keywords: &["igipimo cy’ubushyuhe", "imiterere y’ibihe"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ٿرماميٽر"),
            keywords: &["موسم", "ٿرماميٽر"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("උෂ\u{dca}ණත\u{dca}ව ම\u{dcf}නය"),
            keywords: &["උෂ\u{dca}ණත\u{dca}ව ම\u{dcf}නය", "ක\u{dcf}ලග\u{dd4}ණය"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("teplomer"),
            keywords: &["počasie", "teplomer"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("termometer"),
            keywords: &["termometer", "vreme"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("heerkul-beegge"),
            keywords: &["heerkul-beegge"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("termometër"),
            keywords: &["mot", "termometër"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("термометар"),
            keywords: &["време", "термометар"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["термометар"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("termometar"),
            keywords: &["termometar", "vreme"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["termometar"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("termometer"),
            keywords: &["termometer", "väder"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("pima joto"),
            keywords: &["hali ya hewa", "pima joto"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("வெப\u{bcd}பநிலைம\u{bbe}னி"),
            keywords: &["உடல\u{bcd}நிலை", "வெப\u{bcd}பநிலைம\u{bbe}னி"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("థర\u{c4d}మ\u{c3e}మ\u{c40}టర\u{c4d}"),
            keywords: &["థర\u{c4d}మ\u{c3e}మ\u{c40}టర\u{c4d}", "వ\u{c3e}త\u{c3e}వరణం"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("ҳароратсанҷ"),
            keywords: &["обу ҳаво", "ҳароратсанҷ"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เคร\u{e37}\u{e48}องว\u{e31}ดอ\u{e38}ณหภ\u{e39}ม\u{e34}"),
            keywords: &[
                "อ\u{e38}ณหภ\u{e39}ม\u{e34}",
                "เคร\u{e37}\u{e48}องว\u{e31}ด",
                "เคร\u{e37}\u{e48}องว\u{e31}ดอ\u{e38}ณหภ\u{e39}ม\u{e34}",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("termometr"),
            keywords: &["howa", "termometr"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("fuamāfana"),
            keywords: &["fuamāfana"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("termometre"),
            keywords: &["hava durumu", "termometre"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("تېرمومېتىر"),
            keywords: &["تېرمومېتىر", "ھاۋارايى"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("термометр"),
            keywords: &["погода", "термометр"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("تھرمامیٹر"),
            keywords: &["تھرمامیٹر", "موسم"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("termometr"),
            keywords: &["ob-havo", "termometr"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("nhiệt kế"),
            keywords: &["nhiệt kế", "thời tiết"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("termomeetar"),
            keywords: &["klimaa", "termomeetar"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("i-thermometer"),
            keywords: &["i-thermometer", "imozulu"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("òṣùwọ\u{300}n ìgbóná"),
            keywords: &["ojú ọjọ\u{301}", "òṣùwọ\u{300}n ìgbóná"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("溫度計"),
            keywords: &["天氣", "溫度計"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("温度计"),
            keywords: &["天气", "温度计"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("温度计"),
            keywords: &["天气", "气温", "温度计"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("溫度計"),
            keywords: &["溫度計"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ithemomitha"),
            keywords: &["isimo sezulu", "ithemomitha"],
        },
    ],
};
#[doc = "☀\u{fe0f}"]
pub const SUN: crate::Emoji = crate::Emoji {
    glyph: "☀\u{fe0f}",
    codepoint: "2600 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "sun",
    group: "Travel & Places",
    subgroup: "sky & weather",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "☀",
        codepoint: "2600",
        status: crate::Status::Unqualified,
        introduction_version: 0.6f32,
        name: "sun",
        group: "Travel & Places",
        subgroup: "sky & weather",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("son"),
            keywords: &["helder", "ruimte", "son", "strale", "weer"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ፀሐይ"),
            keywords: &["ህዋ", "ብሩህ", "የአየር ንብረት", "ጨረሮች", "ፀሐያማ", "ፀሐይ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("شمس"),
            keywords: &["أشعة", "ساطعة", "شمس", "طقس", "فضاء"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("স\u{9c2}ৰ\u{9cd}য\u{9cd}য"),
            keywords: &[
                "উজ\u{9cd}জ\u{9cd}বল",
                "স\u{9c2}ৰ\u{9cd}য\u{9cd}য",
                "ৰশ\u{9cd}মি",
                "ৰ’দ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("günəş"),
            keywords: &["günəş", "günəşli", "hava", "kosmos", "parlaq", "şüalar"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("сонца"),
            keywords: &["космас", "надвор’е", "промні", "сонца"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("слънце"),
            keywords: &["време", "лъчи", "слънце", "слънчев", "ярък"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("স\u{9c2}র\u{9cd}য"),
            keywords: &[
                "আবহ\u{9be}ওয\u{9bc}\u{9be}",
                "উজ\u{9cd}জ\u{9cd}বল",
                "মহ\u{9be}ক\u{9be}শ",
                "রশ\u{9cd}মি",
                "রোদ",
                "স\u{9c2}র\u{9cd}য",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("heol"),
            keywords: &["heol", "skin"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("sunčano"),
            keywords: &["prognoza", "sunce", "sunčano", "vrijeme"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("sol"),
            keywords: &["assolellat", "sol", "solejat", "temps"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏅᏓ ᎢᎦ ᎡᎯ"),
            keywords: &["ᎠᎦᎵ", "ᎢᎦᎯ", "ᏅᏓ ᎢᎦ ᎡᎯ", "ᏚᎸᏌᏛ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("slunce"),
            keywords: &["jasný", "paprsky", "počasí", "slunce", "slunečno", "vesmír"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("haul"),
            keywords: &["golau", "haul", "heulog", "pelydrau", "tywydd"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("sol"),
            keywords: &["lys", "sol", "solskin", "stråler", "vejr"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Sonne"),
            keywords: &["Sonne", "Sonnenstrahlen", "Strahlen", "Wetter", "sonnig"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ήλιος"),
            keywords: &[
                "ήλιος",
                "ακτίνες",
                "διάστημα",
                "ηλιόλουστος",
                "καιρός",
                "φωτεινός",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("sun"),
            keywords: &["bright", "rays", "sun", "sunny"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("sol"),
            keywords: &["espacio", "rayos", "sol", "soleado"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["calor", "estrella", "rayos", "sol"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["brillante", "rayos", "sol", "soleado"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("päike"),
            keywords: &["ere", "ilm", "kiired", "kosmos", "päike"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("eguzkia"),
            keywords: &[
                "argi",
                "eguraldi",
                "eguzkia",
                "eguzkitsu",
                "espazio",
                "izpi",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("خورشید"),
            keywords: &[
                "آب\u{200c}وهوا",
                "آفتابی",
                "اشعه",
                "خورشید",
                "روشن",
                "فضا",
                "پرنور",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("aurinko"),
            keywords: &["aurinko", "helle", "paiste", "säteet", "sää"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("araw"),
            keywords: &["araw", "kalawakan", "maliwanag", "panahon", "sinag"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("sól"),
            keywords: &["sól", "sólskin"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("soleil"),
            keywords: &["brillant", "météo", "rayons", "soleil"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("grian"),
            keywords: &["aimsir", "gathanna", "geal", "grian", "grianmhar", "spáis"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("a’ ghrian"),
            keywords: &["a’ ghrian", "gathan", "grianach", "soilleir"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("sol"),
            keywords: &["calor", "raios", "sol", "solleiro", "tempo"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("સ\u{ac2}ર\u{acd}ય"),
            keywords: &[
                "અવકાશ",
                "કિરણો",
                "સ\u{ac2}ર\u{acd}ય",
                "સ\u{ac2}ર\u{acd}યપ\u{acd}રકાશ",
                "હવામાન",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("rana"),
            keywords: &["da rana", "haske", "rana", "tsirkiyoyi"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("שמש"),
            keywords: &["אור", "חם", "קיץ", "שמש"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("स\u{942}र\u{94d}य"),
            keywords: &["किरण\u{947}\u{902}", "मौसम", "स\u{942}र\u{94d}य"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("sunce"),
            keywords: &["sunce", "sunčano", "svemir", "vedro", "vrijeme", "zrake"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("nap"),
            keywords: &["fényes sugarak", "időjárás", "nap", "napos", "napsugarak"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("արև"),
            keywords: &[
                "արեգակ",
                "արև",
                "արևոտ",
                "եղանակ",
                "ճառագայթներ",
                "պայծառ",
                "տիեզերք",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("matahari"),
            keywords: &["angkasa", "cerah", "cuaca", "matahari", "sinar", "terang"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("anyanwụ"),
            keywords: &["anwụ", "anyanwụ", "nchapụta", "ìhè"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("sól"),
            keywords: &["bjart", "geislar", "sól", "sólargeislar", "sólskin"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("sole"),
            keywords: &["calore", "luce", "raggi", "sole", "splendente"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("太陽"),
            keywords: &["太陽", "晴れ"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("srengenge"),
            keywords: &["clorot", "ketiga", "padhing", "srengenge"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მზე"),
            keywords: &["ამინდი", "კაშკაშა", "კოსმოსი", "მზე", "მზიანი", "სხივები"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("iṭij"),
            keywords: &["iṭij"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("күн"),
            keywords: &["ашық", "күн", "күн шығып тұр", "сәулелер", "ғарыш"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("sol"),
            keywords: &["lys", "rum", "sol", "solskin", "stråler", "vejr"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ព\u{17d2}រះអាទ\u{17b7}ត\u{17d2}យ"),
            keywords: &["ថ\u{17d2}ងៃ", "ព\u{17d2}រះអាទ\u{17b7}ត\u{17d2}យ"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಸ\u{cc2}ರ\u{ccd}ಯ"),
            keywords: &[
                "ಮುಖ",
                "ಸನ\u{ccd}ನ\u{cbf}",
                "ಸ\u{cc2}ರ\u{ccd}ಯ",
                "ಹವಾಮಾನ",
                "ಹೊಳಪು",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("태양"),
            keywords: &["더움", "맑음", "태양", "해"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("स\u{941}र\u{94d}य"),
            keywords: &["किरणा\u{902}", "प\u{94d}रकाश", "वत", "स\u{941}र\u{94d}य"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("күн"),
            keywords: &["аба ырайы", "жарык", "күн", "күнөстүү", "нур"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Sonn"),
            keywords: &["Sonn", "Stralen", "hell", "sonneg"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຕາເວ\u{eb1}ນ"),
            keywords: &[
                "ຕາເວ\u{eb1}ນ",
                "ສະພາບອາກາດ",
                "ອະວະກາດ",
                "ແຈ\u{ec9}ງ",
                "ແດດ",
                "ແສງ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("saulė"),
            keywords: &["saulė", "saulėta", "spinduliai", "šviesu"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("saule"),
            keywords: &["laikapstākļi", "laiks", "saule", "stari"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("rā"),
            keywords: &["ihi", "kanapa", "paki", "rā"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("сонце"),
            keywords: &["време", "зраци", "светло", "сонце", "сончево"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("സ\u{d42}ര\u{d4d}യൻ"),
            keywords: &[
                "വെയിൽ",
                "വെളിച\u{d4d}ചം. ക\u{d3e}ല\u{d3e}വസ\u{d4d}ഥ",
                "സ\u{d42}ര\u{d4d}യകിരണം",
                "സ\u{d42}ര\u{d4d}യൻ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("нар"),
            keywords: &["нар", "нартай", "туяа", "цэлмэг"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("स\u{942}र\u{94d}य"),
            keywords: &[
                "किरण",
                "चमकणारा",
                "स\u{942}र\u{94d}य",
                "स\u{942}र\u{94d}यप\u{94d}रकाशाचा",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("matahari"),
            keywords: &[
                "angkasa lepas",
                "cahaya",
                "cerah",
                "cuaca",
                "matahari",
                "terang",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("xemx"),
            keywords: &["raġġi", "tleqq", "xemx", "xemxi"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("နေ"),
            keywords: &["တောက\u{103a}ပ", "နေ", "နေသာ", "အလင\u{103a}းရောင\u{103a}"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("sol"),
            keywords: &[
                "lys",
                "lyst",
                "sol",
                "solfylt",
                "stråler",
                "verdensrommet",
                "vær",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("स\u{942}र\u{94d}य"),
            keywords: &["उज\u{94d}यालो", "किरण", "त\u{947}जिलो", "स\u{942}र\u{94d}य"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("zon"),
            keywords: &["helder", "stralen", "zon", "zonnig"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("sol"),
            keywords: &[
                "lys",
                "lyst",
                "sol",
                "solfylt",
                "strålar",
                "verdsrommet",
                "vêr",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ସ\u{b42}ର\u{b4d}ଯ\u{b4d}ୟ"),
            keywords: &[
                "ଉଜ\u{b4d}ଜ\u{b4d}ୱଳ",
                "କ\u{b3f}ରଣ",
                "ଖର\u{b3e}ଟ\u{b3f}ଆ",
                "ସ\u{b42}ର\u{b4d}ଯ\u{b4d}ୟ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਸ\u{a42}ਰਜ"),
            keywords: &[
                "ਚਮਕਦੀਆ\u{a02} ਕਿਰਨਾ\u{a02}",
                "ਧ\u{a41}\u{a71}ਪ",
                "ਪ\u{a41}ਲਾੜ",
                "ਮ\u{a4c}ਸਮ",
                "ਸ\u{a42}ਰਜ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("سورج"),
            keywords: &["روشن", "سورج", "شعاعواں"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Sọn"),
            keywords: &["Brait", "Plẹ\u{301}ntí Braít Lait Frọm Sọn Shain", "Sọn"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("słońce"),
            keywords: &[
                "jasne",
                "kosmos",
                "pogoda",
                "promienie",
                "słonecznie",
                "słońce",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("لمر"),
            keywords: &["رڼا", "لمر", "لمريز", "پړقيدونکي"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("sol"),
            keywords: &["clima", "dia claro", "raios", "sol", "solar", "tempo"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &[
                "brilhante",
                "espaço",
                "meteorologia",
                "raios",
                "soalheiro",
                "sol",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("inti"),
            keywords: &["inti", "k’anchay", "wach’i"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("soare"),
            keywords: &["lumină", "raze", "soare", "strălucitor", "însorit"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-041"),
            keywords: &["E10-041"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("солнце"),
            keywords: &["жарко", "лучи", "планета", "погода", "солнце"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("cyu"),
            keywords: &["cyu", "gikeye", "imirasire", "kiganjemo izuba"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("سج"),
            keywords: &["روشن", "سج", "سج جا", "ڪرڻا"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ස\u{dd6}ර\u{dca}යය\u{dcf}"),
            keywords: &[
                "අභ\u{dca}\u{200d}යවක\u{dcf}ශය",
                "ක\u{dcf}ලග\u{dd4}ණය",
                "ක\u{dd2}රණ",
                "ද\u{dd3}ප\u{dca}ත\u{dd2}මත\u{dca}",
                "ස\u{dd6}ර\u{dca}යය\u{dcf}",
                "හ\u{dd2}ර\u{dd4} සහ\u{dd2}ත",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("slnko"),
            keywords: &["jas", "lúče", "počasie", "slnečno", "slnko", "vesmír"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("sonce"),
            keywords: &["sonce", "sončno", "svetlo", "vesolje", "vreme", "žarki"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("qorrax"),
            keywords: &["dhalaal", "fallaar-ilays", "qorrax", "qorrax leh"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("diell"),
            keywords: &["diell", "i ndritshëm", "me diell", "moti", "rreze"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("сунце"),
            keywords: &["вeдрo", "зрaци", "сунце", "сунчaнo"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["сунце"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("sunce"),
            keywords: &["sunce", "sunčano", "vedro", "zraci"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["sunce"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("sol"),
            keywords: &["sol", "strålar", "väder"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("jua"),
            keywords: &["anga", "hali ya hewa", "jua", "kung’aa", "miali"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("சூரியன\u{bcd}"),
            keywords: &[
                "சூரிய கதிர\u{bcd}",
                "சூரியன\u{bcd}",
                "பிரக\u{bbe}சம\u{bcd}",
                "வெப\u{bcd}பநிலை",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("సూర\u{c4d}యుడు"),
            keywords: &[
                "ఎండ",
                "క\u{c3f}రణ\u{c3e}లు",
                "ప\u{c4d}రక\u{c3e}శవంతం",
                "సూర\u{c4d}యుడు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("офтоб"),
            keywords: &["офтоб", "офтобӣ", "равшан", "шуоъ"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("พระอาท\u{e34}ตย\u{e4c}"),
            keywords: &["พระอาท\u{e34}ตย\u{e4c}", "สว\u{e48}าง", "อากาศ", "แสงแดด"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("güneş"),
            keywords: &["güneş", "güneşli", "ýagty", "şöhle"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("laʻā"),
            keywords: &["laʻā"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("güneş"),
            keywords: &[
                "aydınlık",
                "güneş",
                "güneşli",
                "hava durumu",
                "uzay",
                "ışık",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("كۈن"),
            keywords: &["ئاپتاپ", "كۈن", "نۇر", "يورۇق"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("сонце"),
            keywords: &[
                "космос",
                "погода",
                "промені",
                "сонце",
                "сонячний",
                "яскравий",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("سورج"),
            keywords: &["سورج", "صاف", "موسم", "کرنیں"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("quyosh"),
            keywords: &[
                "koinot",
                "nurlar",
                "ob-havo",
                "quyosh",
                "quyoshli",
                "yorug‘lik",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("mặt trời"),
            keywords: &["mặt trời", "nắng", "sáng", "tia"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("jant"),
            keywords: &["jant", "naaj", "reyoŋ", "yànj"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ilanga"),
            keywords: &["ilanga", "imitha", "kunelanga", "ngokukhanyayo"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("òrùn"),
            keywords: &["itanṣan oòrùn", "ìmọ\u{301}lẹ\u{300}", "òrùn"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("太陽"),
            keywords: &["光亮", "太陽", "射線", "晴朗"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("太阳"),
            keywords: &["光亮", "太阳", "射线", "晴朗"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("太阳"),
            keywords: &["太阳", "晴", "晴天"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("太陽"),
            keywords: &["太陽"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ilanga"),
            keywords: &[
                "ilanga",
                "imisebe",
                "isikhala",
                "isimo sezulu",
                "kunelanga",
                "ukukhanya",
            ],
        },
    ],
};
#[doc = "🌝"]
pub const FULL_MOON_FACE: crate::Emoji = crate::Emoji {
    glyph: "🌝",
    codepoint: "1F31D",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "full moon face",
    group: "Travel & Places",
    subgroup: "sky & weather",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("volmaan met gesig"),
            keywords: &[
                "gesig",
                "helder",
                "maan",
                "ruimte",
                "vol",
                "volmaan met gesig",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ሙሉ ጨረቃ ከፊት ጋር"),
            keywords: &["ህዋ", "ሙሉ", "ሙሉ ጨረቃ ከፊት ጋር", "ብሩህ", "የአየር ንብረት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("وجه البدر"),
            keywords: &["ساطعة", "طقس", "فضاء", "قمر", "كامل", "وجه", "وجه البدر"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("প\u{9c2}ৰ\u{9cd}ণ চন\u{9cd}দ\u{9cd}ৰৰ ম\u{9c1}খ"),
            keywords: &[
                "উজ\u{9cd}জ\u{9cd}বল",
                "চন\u{9cd}দ\u{9cd}ৰ",
                "প\u{9c2}ৰ\u{9cd}ণ চন\u{9cd}দ\u{9cd}ৰৰ ম\u{9c1}খ",
                "ম\u{9c1}খ",
                "সম\u{9cd}প\u{9c2}ৰ\u{9cd}ণ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("üzü olan tam ay"),
            keywords: &[
                "ay",
                "hava",
                "kosmos",
                "parlaq",
                "tam",
                "üz",
                "üzü olan tam ay",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("поўня з тварам"),
            keywords: &["космас", "месяц", "ноч", "поўня", "поўня з тварам", "яркі"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Луната в пълнолуние с лице"),
            keywords: &[
                "Луната в пълнолуние с лице",
                "космос",
                "лице",
                "луна",
                "пълна",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ম\u{9c1}খের স\u{9be}থে প\u{9c2}র\u{9cd}ণ চ\u{9be}\u{981}দ"),
            keywords: &[
                "আবহ\u{9be}ওয\u{9bc}\u{9be}",
                "উজ\u{9cd}জ\u{9cd}বল",
                "চ\u{9be}\u{981}দ",
                "প\u{9c2}র\u{9cd}ণ",
                "মহ\u{9be}ক\u{9be}শ",
                "ম\u{9c1}খ",
                "ম\u{9c1}খের স\u{9be}থে প\u{9c2}র\u{9cd}ণ চ\u{9be}\u{981}দ",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("penn loargann"),
            keywords: &["loar", "loargann", "penn"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("puni mjesec lice"),
            keywords: &["lice", "mjesec", "puni mjesec lice"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("lluna plena amb cara"),
            keywords: &["cara", "lluna", "lluna plena amb cara", "plena"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎧᎵ ᏅᏓ ᎤᏒ ᎡᎯ ᎤᎧᏛ"),
            keywords: &["ᎢᎦᎯ", "ᎤᎧᏛ", "ᎧᎵ", "ᎧᎵ ᏅᏓ ᎤᏒ ᎡᎯ ᎤᎧᏛ", "ᏅᏓ ᎤᏒ ᎡᎯ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("měsíc v úplňku s obličejem"),
            keywords: &[
                "fáze měsíce",
                "jasný",
                "měsíc",
                "měsíc v úplňku s obličejem",
                "smajlík",
                "tvář",
                "vesmír",
                "výraz",
                "úplněk",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("lleuad lawn gydag wyneb"),
            keywords: &[
                "llachar",
                "llawn",
                "lleuad",
                "lleuad lawn gydag wyneb",
                "wyneb",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("fuldmåne med ansigt"),
            keywords: &[
                "fuldmåne",
                "fuldmåne med ansigt",
                "fuldmåneansigt",
                "måne med ansigt",
                "måneansigt",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Vollmond mit Gesicht"),
            keywords: &["Gesicht", "Vollmond", "Vollmond mit Gesicht"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("πανσέληνος με πρόσωπο"),
            keywords: &[
                "γεμάτο",
                "διάστημα",
                "καιρός",
                "πανσέληνος",
                "πανσέληνος με πρόσωπο",
                "πρόσωπο",
                "φεγγάρι",
                "φωτεινό",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("full moon face"),
            keywords: &["bright", "face", "full", "moon"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("full-moon face"),
            keywords: &["bright", "face", "full", "full-moon face", "moon"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("luna llena con cara"),
            keywords: &["cara", "llena", "luna", "luna llena con cara"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("näoga täiskuu"),
            keywords: &[
                "ere",
                "ilm",
                "kosmos",
                "kuu",
                "nägu",
                "näoga täiskuu",
                "täiskuu",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("ilargi betea aurpegiarekin"),
            keywords: &[
                "argi",
                "aurpegi",
                "bete",
                "eguraldi",
                "espazio",
                "ilargi",
                "ilargi betea aurpegiarekin",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("صورت ماه کامل"),
            keywords: &[
                "آب\u{200c}وهوا",
                "تمام",
                "روشن",
                "صورت",
                "صورت ماه کامل",
                "فضا",
                "ماه",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("täysikuu kasvoilla"),
            keywords: &["kasvot", "kuu", "sää", "täysikuu kasvoilla", "valo"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("full moon na may mukha"),
            keywords: &[
                "bilog na buwan",
                "buwan",
                "full moon",
                "full moon na may mukha",
                "mukha",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("andlit á fullmána"),
            keywords: &["andlit", "andlit á fullmána", "fullmáni", "máni"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("pleine lune avec visage"),
            keywords: &["lune", "pleine lune avec visage"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("pleine lune avec visage"),
            keywords: &["lune", "pleine", "pleine lune avec visage", "visage"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("aghaidh na gealaí láine"),
            keywords: &[
                "aghaidh",
                "aghaidh ar ghealach",
                "aghaidh ghealaí láine",
                "aghaidh na gealaí láine",
                "gealach",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("gealach làn le aodann"),
            keywords: &[
                "aodann",
                "gealach",
                "gealach làn le aodann",
                "làn",
                "soilleir",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("lúa chea con cara"),
            keywords: &["cara", "chea", "lúa", "lúa chea con cara"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("પ\u{ac2}નમના ચ\u{a82}દ\u{acd}રનો ચહ\u{ac7}રો"),
            keywords: &[
                "ચ\u{a82}દ\u{acd}ર",
                "ચહ\u{ac7}રાવાળો ચ\u{a82}દ\u{acd}ર",
                "ચહ\u{ac7}રો",
                "પ\u{ac2}નમના ચ\u{a82}દ\u{acd}રનો ચહ\u{ac7}રો",
                "પ\u{ac2}નમના ચ\u{a82}દ\u{acd}રવાળો ચહ\u{ac7}રો",
                "પ\u{ac2}નમનો ચ\u{a82}દ\u{acd}ર",
                "પ\u{ac2}ર\u{acd}ણ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("cikakken wata tare da fuska"),
            keywords: &[
                "cikakke",
                "cikakken wata tare da fuska",
                "fuska",
                "haske",
                "wata",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("פני ירח מלא"),
            keywords: &["ירח", "מלא", "פני ירח מלא", "פנים"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("प\u{942}र\u{947} चा\u{901}द वाला च\u{947}हरा"),
            keywords: &[
                "चा\u{902}द",
                "च\u{947}हरा",
                "च\u{947}हर\u{947} वाला चा\u{902}द",
                "च\u{947}हर\u{947} वाला प\u{942}रा चा\u{902}द",
                "प\u{942}रा",
                "प\u{942}र\u{947} चा\u{901}द वाला च\u{947}हरा",
                "प\u{942}र\u{947} चा\u{902}द वाला च\u{947}हरा",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("puni mjesec s licem"),
            keywords: &[
                "lice",
                "mjesec",
                "puni",
                "puni mjesec s licem",
                "svemir",
                "vedro",
                "vrijeme",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("telihold arccal"),
            keywords: &["arc", "holdfázisok", "telihold", "telihold arccal", "ég"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("դեմքով լիալուսին"),
            keywords: &[
                "դեմք",
                "դեմքով լիալուսին",
                "եղանակ",
                "լիալուսին",
                "լուսին",
                "պայծառ",
                "տիեզերք",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("wajah bulan purnama"),
            keywords: &["angkasa", "bulan", "cuaca", "purnama", "terang", "wajah"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ọnwa zuru òkè nwere ihu"),
            keywords: &["ihu", "zuru òkè", "ìhè", "ọnwa", "ọnwa zuru òkè nwere ihu"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("fullt tungl með andliti"),
            keywords: &[
                "andlit",
                "bjart",
                "fullt tungl",
                "fullt tungl með andliti",
                "máni",
                "tungl",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("faccina luna piena"),
            keywords: &[
                "faccina",
                "faccina luna piena",
                "luna",
                "luna con faccina",
                "luna piena",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("顔のある満月"),
            keywords: &["月", "顔", "顔のある満月"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("rai purnama sidi"),
            keywords: &["bulan", "padhang", "purnama", "rai", "rai purnama sidi"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("სავსე მთვარე სახით"),
            keywords: &[
                "ამინდი",
                "კაშკაშა",
                "კოსმოსი",
                "მთვარე",
                "სავსე",
                "სავსე მთვარე სახით",
                "სახე",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("беті бейнеленген толық ай"),
            keywords: &["ай", "ашық", "бет", "беті бейнеленген толық ай", "толы"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("fuldmåneansigt"),
            keywords: &[
                "fuldmåne",
                "fuldmåne med ansigt",
                "fuldmåneansigt",
                "måne med ansigt",
                "måneansigt",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ម\u{17bb}ខព\u{17d2}រះចន\u{17d2}ទពេញវង\u{17cb}"),
            keywords: &[
                "ពេញវង\u{17cb}",
                "ព\u{17d2}រះចន\u{17d2}ទ",
                "ម\u{17bb}ខ",
                "ម\u{17bb}ខព\u{17d2}រះចន\u{17d2}ទពេញវង\u{17cb}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಪ\u{cc2}ರ\u{ccd}ಣ ಚಂದ\u{ccd}ರನ ಮುಖ"),
            keywords: &[
                "ಚಂದ\u{ccd}ರ",
                "ಪ\u{cc2}ರ\u{ccd}ಣ",
                "ಪ\u{cc2}ರ\u{ccd}ಣ ಚಂದ\u{ccd}ರನ ಮುಖ",
                "ಮುಖ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("얼굴이 있는 보름달"),
            keywords: &["달", "달님", "얼굴이 있는 보름달"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("प\u{941}नव\u{947}च\u{94d}या च\u{902}द\u{94d}राचो च\u{947}रो"),
            keywords: &[
                "च\u{902}द\u{94d}र",
                "च\u{947}रो",
                "प\u{941}नव",
                "प\u{941}नव\u{947}च\u{94d}या च\u{902}द\u{94d}राचो च\u{947}रो",
                "प\u{94d}रकाश",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("толгон айдын бети"),
            keywords: &["ай", "бет", "жарык", "толгон", "толгон айдын бети"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Vollmoundgesiicht"),
            keywords: &["Gesiicht", "Mound", "Vollmoundgesiicht", "hell", "voll"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໜ\u{ec9}າເດ\u{eb7}ອນເຕ\u{eb1}ມດວງ"),
            keywords: &[
                "ເດ\u{eb7}ອນ",
                "ເຕ\u{eb1}ມດວງ",
                "ໜ\u{ec9}າ",
                "ໜ\u{ec9}າເດ\u{eb7}ອນເຕ\u{eb1}ມດວງ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("pilnatis su veidu"),
            keywords: &[
                "mėnulis",
                "pilnatis",
                "pilnatis su veidu",
                "veidas",
                "šviesu",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("pilnmēness seja"),
            keywords: &["mēness", "pilnmēness", "seja"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("rākaunui whai mata"),
            keywords: &["kanapa", "kī", "marama", "mata", "rākaunui whai mata"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("полна месечина со лице"),
            keywords: &[
                "вселена",
                "лице",
                "месечина",
                "полна",
                "полна месечина со лице",
            ],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("പ\u{d42}ർണ\u{d4d}ണചന\u{d4d}ദ\u{d4d}രന\u{d4d}റെ മ\u{d41}ഖം"),
            keywords: &[
                "ചന\u{d4d}ദ\u{d4d}രനിൽ മ\u{d41}ഖം",
                "ചന\u{d4d}ദ\u{d4d}രൻ",
                "പ\u{d42}ർണ\u{d4d}ണചന\u{d4d}ദ\u{d4d}രന\u{d4d}റെ മ\u{d41}ഖം",
                "പ\u{d42}ർണ\u{d4d}ണചന\u{d4d}ദ\u{d4d}രൻ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("нүүртэй бүтэн сар"),
            keywords: &["бүтэн", "гэгээтэй", "нүүр", "нүүртэй бүтэн сар", "сар"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("पौर\u{94d}णिम\u{947}च\u{94d}या च\u{902}द\u{94d}राचा च\u{947}हरा"),
            keywords: &[
                "च\u{902}द\u{94d}र",
                "चमकणारा",
                "च\u{947}हरा",
                "प\u{942}र\u{94d}ण",
                "पौर\u{94d}णिम\u{947}च\u{94d}या च\u{902}द\u{94d}राचा च\u{947}हरा",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("muka bulan purnama"),
            keywords: &[
                "angkasa lepas",
                "bulan",
                "cuaca",
                "muka",
                "muka bulan purnama",
                "penuh",
                "terang",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("wiċċ ta’ qamar sħiħ"),
            keywords: &["qamar", "sħiħ", "tleqq", "wiċċ", "wiċċ ta’ qamar sħiħ"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("လပြည\u{1037}\u{103a} မျက\u{103a}န\u{103e}ာ"),
            keywords: &[
                "တောက\u{103a}ပ",
                "မျက\u{103a}န\u{103e}ာ",
                "လ",
                "လပြည\u{1037}\u{103a} မျက\u{103a}န\u{103e}ာ",
                "အပြည\u{1037}\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("fullmåneansikt"),
            keywords: &[
                "ansikt",
                "fullmåne",
                "fullmåne med ansikt",
                "fullmåneansikt",
                "måne",
                "måne med ansikt",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("स\u{94d}वर\u{942}पसहितको प\u{942}र\u{94d}णिमा"),
            keywords: &[
                "अन\u{941}हार",
                "उज\u{94d}यालो",
                "चन\u{94d}द\u{94d}रमा",
                "प\u{942}र\u{94d}ण चन\u{94d}द\u{94d}र",
                "स\u{94d}वर\u{942}पसहितको प\u{942}र\u{94d}णिमा",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("volle maan met gezicht"),
            keywords: &["gezicht", "helder", "maan", "vol", "volle maan met gezicht"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("fullmåneandlet"),
            keywords: &[
                "andlet",
                "fullmåne",
                "fullmåne med andlet",
                "fullmåneandlet",
                "måne",
                "måne med andlet",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ପ\u{b42}ର\u{b4d}ଣ\u{b4d}ଣ ଚନ\u{b4d}ଦ\u{b4d}ର ମ\u{b41}ହ\u{b01}"),
            keywords: &[
                "ଚନ\u{b4d}ଦ\u{b4d}ର",
                "ପ\u{b42}ର\u{b4d}ଣ\u{b4d}ଣ",
                "ପ\u{b42}ର\u{b4d}ଣ\u{b4d}ଣ ଚନ\u{b4d}ଦ\u{b4d}ର ମ\u{b41}ହ\u{b01}",
                "ପ\u{b42}ର\u{b4d}ଣ\u{b4d}ଣ\u{b3f}ମ\u{b3e}",
                "ମ\u{b41}ଖ",
                "ମ\u{b41}ଖ ସହ\u{b3f}ତ ଚନ\u{b4d}ଦ\u{b4d}ର",
                "ମ\u{b41}ଖ ସହ\u{b3f}ତ ପ\u{b42}ର\u{b4d}ଣ\u{b4d}ଣ\u{b3f}ମ\u{b3e}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਪ\u{a42}ਰ\u{a47} ਚ\u{a70}ਦ ਦਾ ਚਿਹਰਾ"),
            keywords: &[
                "ਚਮਕੀਲਾ",
                "ਚਿਹਰਾ",
                "ਚਿਹਰ\u{a47} ਨਾਲ ਪ\u{a42}ਰਾ ਚ\u{a70}ਦ",
                "ਚ\u{a70}ਦ",
                "ਪ\u{a42}ਰਾ",
                "ਪ\u{a42}ਰਾ ਚ\u{a70}ਦਾ",
                "ਪ\u{a42}ਰ\u{a47} ਚ\u{a70}ਦ ਦਾ ਚਿਹਰਾ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("شکل نال پورا چاند"),
            keywords: &["دی شکل", "روشن", "شکل نال پورا چاند", "پورا", "چاند"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Fúl Mun Fes"),
            keywords: &["Brait", "Fes", "Ful", "Fúl Mun Fes", "Mun"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("pełnia z twarzą"),
            keywords: &["księżyc w pełni", "pełnia", "pełnia z twarzą"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د بشپړه سپوږمۍ مخ"),
            keywords: &["بشپړه", "د بشپړه سپوږمۍ مخ", "سپوږمۍ", "مخ", "پړقېدونکې"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("rosto da lua cheia"),
            keywords: &[
                "cheia",
                "lua",
                "lua cheia com rosto",
                "lua com rosto",
                "rosto",
                "rosto da lua cheia",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("lua cheia com cara"),
            keywords: &[
                "brilhante",
                "cara",
                "cheia",
                "espaço",
                "lua",
                "lua cheia com cara",
                "meteorologia",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("lună plină cu față"),
            keywords: &["față", "lună plină", "lună plină cu față"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-228"),
            keywords: &["E10-228"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("полная луна с лицом"),
            keywords: &[
                "круглая",
                "круглая луна",
                "лицо",
                "месяц",
                "небо",
                "полная луна",
                "полная луна с лицом",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("inzora y’ukwezi ifite isura"),
            keywords: &[
                "cyuzuye",
                "gikeye",
                "inzora y’ukwezi ifite isura",
                "isura",
                "ukwezi",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("پوري چهري سان چنڊ"),
            keywords: &["روشني", "پورو", "پوري چهري سان چنڊ", "چنڊ", "چهرو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ම\u{dd4}හ\u{dd4}ණ සහ\u{dd2}ත ප\u{dd4}රසඳ"),
            keywords: &[
                "අභ\u{dca}\u{200d}යවක\u{dcf}ශය",
                "ක\u{dcf}ලග\u{dd4}ණය",
                "ද\u{dd3}ප\u{dca}ත\u{dd2}මත\u{dca}",
                "ප\u{dd6}ර\u{dca}ණ",
                "ම\u{dd4}හ\u{dd4}ණ",
                "ම\u{dd4}හ\u{dd4}ණ සහ\u{dd2}ත ප\u{dd4}රසඳ",
                "සඳ",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("spln s tvárou"),
            keywords: &[
                "jas",
                "mesiac",
                "počasie",
                "spln",
                "spln s tvárou",
                "tvár",
                "vesmír",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("polna luna z obrazom"),
            keywords: &[
                "luna",
                "obraz",
                "polna luna z obrazom",
                "polno",
                "svetlo",
                "vesolje",
                "vreme",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("waji dayaxeed buuxa"),
            keywords: &["buuxa", "dayax", "dhalaal", "waji", "waji dayaxeed buuxa"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("hënë e plotë me fytyrë"),
            keywords: &[
                "e ndritshme",
                "e plotë",
                "fytyrë",
                "hënë",
                "hënë e plotë me fytyrë",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("пун месец са лицем"),
            keywords: &["вeдрo", "лице", "месец", "пун", "пун месец са лицем"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("пун мјесец са лицем"),
            keywords: &["пун мјесец са лицем"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("pun mesec sa licem"),
            keywords: &["lice", "mesec", "pun", "pun mesec sa licem", "vedro"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("pun mjesec sa licem"),
            keywords: &["pun mjesec sa licem"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("fullmåne med ansikte"),
            keywords: &[
                "ansikte",
                "fullmåne",
                "fullmåne med ansikte",
                "gubben i månen",
                "månansikte",
                "måne",
            ],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("uso unaokaa mwezi"),
            keywords: &[
                "anga",
                "hali ya hewa",
                "kamili",
                "kung’aa",
                "uso",
                "uso unaokaa mwezi",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("முழுநில\u{bbe} முகம\u{bcd}"),
            keywords: &[
                "நில\u{bbe}",
                "பௌர\u{bcd}ணமி",
                "முகம\u{bcd}",
                "முழுநில\u{bbe} முகம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("పూర\u{c4d}ణ చంద\u{c4d}రున\u{c3f} ముఖం"),
            keywords: &[
                "పూర\u{c4d}ణ చంద\u{c4d}రుడు",
                "పూర\u{c4d}ణ చంద\u{c4d}రున\u{c3f} ముఖం",
                "ముఖం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("моҳи пурра бо чеҳра"),
            keywords: &["моҳ", "моҳи пурра бо чеҳра", "пурра", "равшан", "рӯй"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("หน\u{e49}าพระจ\u{e31}นทร\u{e4c}เต\u{e47}มดวง"),
            keywords: &[
                "พระจ\u{e31}นทร\u{e4c}",
                "สว\u{e48}าง",
                "หน\u{e49}าพระจ\u{e31}นทร\u{e4c}เต\u{e47}มดวง",
                "เต\u{e47}มดวง",
                "ใบหน\u{e49}า",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ýüzli dolan aý"),
            keywords: &["aý", "doly", "ýagty", "ýüz", "ýüzli dolan aý"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("mata māhina kātoa"),
            keywords: &["mata māhina kātoa"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("dolunay yüzü"),
            keywords: &[
                "ay",
                "dolu",
                "dolunay",
                "dolunay yüzü",
                "yüz",
                "yüzü olan ay",
                "yüzü olan dolunay",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("يۈزلۈك تولۇن ئاي"),
            keywords: &["ئاي", "تولۇق", "يورۇق", "يۈزلۈك تولۇن ئاي", "چىراي"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("повний місяць з обличчям"),
            keywords: &[
                "місяць",
                "обличчя",
                "повний",
                "повний місяць з обличчям",
                "яскравий",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("چہرے والا پورا چاند"),
            keywords: &["خلا", "صاف", "موسم", "مکمل", "چہرہ", "چہرے والا پورا چاند"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("to‘lin oy qiyofali"),
            keywords: &[
                "koinot",
                "ob-havo",
                "osmon",
                "to‘lin",
                "to‘lin oy qiyofali",
                "to‘liq",
                "yuz",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("khuôn mặt trăng tròn"),
            keywords: &["khuôn mặt trăng tròn", "mặt", "mặt trăng", "sáng", "tròn"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("weer ñumm bu am kanam"),
            keywords: &["kanam", "weer", "weer ñumm bu am kanam", "yànj", "ñumm"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("inyanga epheleleyo enobuso"),
            keywords: &[
                "epheleleyo",
                "inyanga",
                "inyanga epheleleyo enobuso",
                "ngokukhanyayo",
                "ubuso",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ẹ\u{300}kúnrẹ\u{301}rẹ\u{301} Òṣùpá Pẹ\u{300}lú Ojú"),
            keywords: &[
                "ojú",
                "ìmọ\u{300}lẹ\u{300}",
                "òṣùpá",
                "Ẹ\u{300}kúnrẹ\u{301}rẹ\u{301} Òṣùpá Pẹ\u{300}lú Ojú",
                "ẹ\u{300}kún",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("滿月面"),
            keywords: &["光亮", "月", "滿", "滿月面", "臉"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("满月面"),
            keywords: &["光亮", "月", "满", "满月面", "脸"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("微笑的月亮"),
            keywords: &["微笑的月亮", "月亮", "望月", "满月"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("微笑的滿月"),
            keywords: &["微笑的滿月", "月亮"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("滿月嘅面孔"),
            keywords: &["月亮", "滿月嘅面孔"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("inyanga egcwele enobuso"),
            keywords: &[
                "inyanga egcwele",
                "inyanga egcwele enobuso",
                "isimo sezulu",
                "ubuso",
                "ukukhanya",
                "umkhathi",
            ],
        },
    ],
};
#[doc = "🌞"]
pub const SUN_WITH_FACE: crate::Emoji = crate::Emoji {
    glyph: "🌞",
    codepoint: "1F31E",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "sun with face",
    group: "Travel & Places",
    subgroup: "sky & weather",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("son met gesig"),
            keywords: &["gesig", "helder", "ruimte", "son", "son met gesig", "weer"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ፀሐይ ከፊት ጋር"),
            keywords: &["ህዋ", "ብሩህ", "የአየር ንብረት", "ፀሐይ", "ፀሐይ ከፊት ጋር"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("وجه الشمس"),
            keywords: &["ساطع", "شمس", "طقس", "فضاء", "وجه", "وجه الشمس"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ম\u{9c1}খৰ সৈতে স\u{9c2}ৰ\u{9cd}য\u{9cd}য"),
            keywords: &[
                "উজ\u{9cd}জ\u{9cd}বল",
                "ম\u{9c1}খ",
                "ম\u{9c1}খৰ সৈতে স\u{9c2}ৰ\u{9cd}য\u{9cd}য",
                "স\u{9c2}ৰ\u{9cd}য\u{9cd}য",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("üzü olan günəş"),
            keywords: &["günəş", "hava", "kosmos", "parlaq", "üz", "üzü olan günəş"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("сонца з тварам"),
            keywords: &[
                "космас",
                "надвор’е",
                "сонца",
                "сонца з тварам",
                "твар",
                "яркае",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Слънце с лице"),
            keywords: &["Слънце с лице", "време", "лице", "слънце", "ярък"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ম\u{9c1}খের স\u{9be}থে স\u{9c2}র\u{9cd}য"),
            keywords: &[
                "আবহ\u{9be}ওয\u{9bc}\u{9be}",
                "উজ\u{9cd}জ\u{9cd}বল",
                "মহ\u{9be}ক\u{9be}শ",
                "ম\u{9c1}খ",
                "ম\u{9c1}খের স\u{9be}থে স\u{9c2}র\u{9cd}য",
                "স\u{9c2}র\u{9cd}য",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("penn heol"),
            keywords: &["heol", "penn heol", "skin"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("sunce lice"),
            keywords: &["lice", "prognoza", "sunce", "sunčano", "vrijeme"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("sol amb cara"),
            keywords: &["cara", "sol", "sol amb cara"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏅᏓ ᎢᎦ ᎡᎯ ᎤᎧᏓ"),
            keywords: &["ᎢᎦᎯ", "ᎤᎧᏛ", "ᏅᏓ ᎢᎦ ᎡᎯ", "ᏅᏓ ᎢᎦ ᎡᎯ ᎤᎧᏓ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("slunce s obličejem"),
            keywords: &[
                "jasný",
                "počasí",
                "slunce",
                "slunce s obličejem",
                "smajlík",
                "tvář",
                "vesmír",
                "výraz",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("lleuad ag wyneb"),
            keywords: &["haul", "llachar", "lleuad ag wyneb", "tywydd", "wyneb"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("sol med ansigt"),
            keywords: &["ansigt", "sol", "sol med ansigt"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Sonne mit Gesicht"),
            keywords: &["Gesicht", "Sonne", "Sonne mit Gesicht"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ήλιος με πρόσωπο"),
            keywords: &[
                "ήλιος",
                "ήλιος με πρόσωπο",
                "διάστημα",
                "καιρός",
                "πρόσωπο",
                "φωτεινός",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("sun with face"),
            keywords: &["bright", "face", "sun", "sun with face"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("sol con cara"),
            keywords: &["brillante", "cara", "sol", "sol con cara"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("näoga päike"),
            keywords: &["ere", "ilm", "kosmos", "nägu", "näoga päike", "päike"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("eguzkia aurpegiarekin"),
            keywords: &[
                "argi",
                "aurpegi",
                "eguraldi",
                "eguzki",
                "eguzkia aurpegiarekin",
                "espazio",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("صورت خورشید"),
            keywords: &["آب\u{200c}وهوا", "خورشید", "روشن", "صورت", "فضا"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("aurinko kasvoilla"),
            keywords: &[
                "aurinko kasvoilla",
                "kasvot",
                "kuu",
                "paiste",
                "sää",
                "valo",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("araw na may mukha"),
            keywords: &["araw", "araw na may mukha", "maliwanag", "mukha", "sinag"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("andlit á sól"),
            keywords: &["andlit", "andlit á sól", "sól"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("soleil avec visage"),
            keywords: &["soleil", "soleil avec visage"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("soleil avec visage"),
            keywords: &["soleil", "soleil avec visage", "visage"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("an ghrian le haghaidh"),
            keywords: &[
                "aghaidh",
                "aghaidh ar ghrian",
                "an ghrian le haghaidh",
                "grian",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("a’ ghrian le aodann oirre"),
            keywords: &["aodann", "a’ ghrian le aodann oirre", "grian", "soilleir"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("sol con cara"),
            keywords: &["cara", "sol", "sol con cara"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("સ\u{ac2}ર\u{acd}યનો ચહ\u{ac7}રો"),
            keywords: &[
                "ચહ\u{ac7}રો",
                "સ\u{ac2}ર\u{acd}ય",
                "સ\u{ac2}ર\u{acd}યનો ચહ\u{ac7}રો",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("rana tare da fuska"),
            keywords: &["fuska", "haske", "rana", "rana tare da fuska"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("פני שמש"),
            keywords: &["פני שמש", "פנים", "שמש"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("स\u{942}र\u{94d}य वाला च\u{947}हरा"),
            keywords: &[
                "च\u{947}हरा",
                "स\u{942}रज",
                "स\u{942}र\u{94d}य",
                "स\u{942}र\u{94d}य वाला च\u{947}हरा",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("sunce s licem"),
            keywords: &[
                "lice",
                "sunce",
                "sunce s licem",
                "svemir",
                "vedro",
                "vrijeme",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("nap arccal"),
            keywords: &["arc", "időjárás", "nap", "nap arccal", "égitest"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("դեմքով արև"),
            keywords: &["արև", "դեմք", "դեմքով արև", "եղանակ", "պայծառ", "տիեզերք"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("wajah matahari"),
            keywords: &["angkasa", "cuaca", "matahari", "terang", "wajah"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("anyanwụ nwere ihu"),
            keywords: &["anyanwụ", "anyanwụ nwere ihu", "ihu", "ìhè"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("sól með andliti"),
            keywords: &["andlit", "sól", "sól með andliti"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("faccina sole"),
            keywords: &["faccina", "sole"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("顔のある太陽"),
            keywords: &["太陽", "顔", "顔のある太陽"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("srengenge katon raine"),
            keywords: &["padhang", "rai", "srengenge", "srengenge katon raine"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მზე სახით"),
            keywords: &["ამინდი", "კაშკაშა", "კოსმოსი", "მზე", "მზე სახით", "სახე"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("беті бейнеленген күн"),
            keywords: &["ашық", "бет", "беті бейнеленген күн", "күн"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("sol med ansigt"),
            keywords: &["ansigt", "sol", "sol med ansigt"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ម\u{17bb}ខព\u{17d2}រះអាទ\u{17b7}ត\u{17d2}យ"),
            keywords: &[
                "ព\u{17d2}រះអាទ\u{17b7}ត\u{17d2}យ",
                "ម\u{17bb}ខ",
                "ម\u{17bb}ខព\u{17d2}រះអាទ\u{17b7}ត\u{17d2}យ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಸ\u{cc2}ರ\u{ccd}ಯನ ಮುಖ"),
            keywords: &["ಮುಖ", "ಸ\u{cc2}ರ\u{ccd}ಯ", "ಸ\u{cc2}ರ\u{ccd}ಯನ ಮುಖ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("얼굴이 있는 해"),
            keywords: &["얼굴이 있는 해", "해 방긋", "해님"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("स\u{941}र\u{94d}याचो च\u{947}रो"),
            keywords: &[
                "च\u{947}रो",
                "प\u{94d}रकाश",
                "स\u{941}र\u{94d}य",
                "स\u{941}र\u{94d}याचो च\u{947}रो",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("күндүн бети"),
            keywords: &["бет", "жарык", "күн", "күндүн бети"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Sonnegesiicht"),
            keywords: &["Gesiicht", "Sonn", "Sonnegesiicht", "hell"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໜ\u{ec9}າຕາເວ\u{eb1}ນ"),
            keywords: &[
                "ຕາເວ\u{eb1}ນ",
                "ສະຫວ\u{ec8}າງ",
                "ໜ\u{ec9}າ",
                "ໜ\u{ec9}າຕາເວ\u{eb1}ນ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("saulė su veidu"),
            keywords: &["saulė", "saulė su veidu", "veidas", "šviesu"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("saules seja"),
            keywords: &["saule", "saules seja", "seja"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("rā whai mata"),
            keywords: &["kanapa", "mata", "rā", "rā whai mata"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("сонце со лице"),
            keywords: &["зраци", "лице", "светло", "сонце", "сонце со лице"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("സ\u{d42}ര\u{d4d}യനിൽ മ\u{d41}ഖം"),
            keywords: &["സ\u{d42}ര\u{d4d}യനിൽ മ\u{d41}ഖം", "സ\u{d42}ര\u{d4d}യൻ"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("нүүртэй нар"),
            keywords: &["нар", "нүүр", "нүүртэй нар", "цаг агаар"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("च\u{947}हरा असल\u{947}ला स\u{942}र\u{94d}य"),
            keywords: &[
                "चमकणारा",
                "च\u{947}हरा",
                "च\u{947}हरा असल\u{947}ला स\u{942}र\u{94d}य",
                "स\u{942}र\u{94d}य",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("matahari dengan muka"),
            keywords: &[
                "angkasa lepas",
                "cuaca",
                "matahari",
                "matahari dengan muka",
                "muka",
                "terang",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("xemx b’wiċċ"),
            keywords: &["tleqq", "wiċċ", "xemx b’wiċċ", "xemxi"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("နေ၏ မျက\u{103a}န\u{103e}ာ"),
            keywords: &[
                "တောက\u{103a}ပ",
                "နေ",
                "နေ၏ မျက\u{103a}န\u{103e}ာ",
                "မျက\u{103a}န\u{103e}ာ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("solansikt"),
            keywords: &["ansikt", "lys", "sol", "solansikt"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("स\u{94d}वर\u{942}पसहितको स\u{942}र\u{94d}य"),
            keywords: &[
                "अन\u{941}हार",
                "उज\u{94d}यालो",
                "स\u{942}र\u{94d}य",
                "स\u{94d}वर\u{942}पसहितको स\u{942}र\u{94d}य",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("zon met gezicht"),
            keywords: &["gezicht", "helder", "zon", "zon met gezicht"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("solandlet"),
            keywords: &["andlet", "lys", "sol", "solandlet"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ସ\u{b42}ର\u{b4d}ଯ\u{b4d}ୟ ମ\u{b41}ହ\u{b01}"),
            keywords: &[
                "ମ\u{b41}ଖ",
                "ସ\u{b42}ର\u{b4d}ଯ\u{b4d}ୟ",
                "ସ\u{b42}ର\u{b4d}ଯ\u{b4d}ୟ ମ\u{b41}ହ\u{b01}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਸ\u{a42}ਰਜ ਦਾ ਚਿਹਰਾ"),
            keywords: &[
                "ਚਮਕਣਾ",
                "ਚਮਕਦਾ",
                "ਚਿਹਰਾ",
                "ਸ\u{a42}ਰਜ",
                "ਸ\u{a42}ਰਜ ਦਾ ਚਿਹਰਾ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("شکل نال سورج"),
            keywords: &["دی شکل", "روشن", "سورج", "شکل نال سورج"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Sọn Wit Fes"),
            keywords: &["Brait", "Fes", "Sọn", "Sọn Wit Fes"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("słońce z twarzą"),
            keywords: &["ciepło", "promienny", "słońce z twarzą", "uśmiech"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("لمر د مخ سره"),
            keywords: &["لمر", "لمر د مخ سره", "مخ", "پړقېدونکې"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("rosto do sol"),
            keywords: &["rosto", "rosto do sol", "sol"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("sol com cara"),
            keywords: &[
                "brilhante",
                "cara",
                "espaço",
                "meteorologia",
                "sol",
                "sol com cara",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("inti uyawan"),
            keywords: &["inti", "inti uyawan", "k’anchay", "uya"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("soare cu față"),
            keywords: &["față", "raze", "soare", "soare cu față"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-229"),
            keywords: &["E10-229"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("солнце с лицом"),
            keywords: &["лицо", "небо", "солнце", "солнце с лицом"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("izuba rifite isura"),
            keywords: &["gikeye", "isura", "izuba", "izuba rifite isura"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("چهري سان گڏ سج"),
            keywords: &["روشن", "سج", "چهرو", "چهري سان گڏ سج"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ම\u{dd4}හ\u{dd4}ණ සහ\u{dd2}ත ස\u{dd6}ර\u{dca}යය\u{dcf}"),
            keywords: &[
                "අභ\u{dca}\u{200d}යවක\u{dcf}ශය",
                "ක\u{dcf}ලග\u{dd4}ණය",
                "ද\u{dd3}ප\u{dca}ත\u{dd2}මත\u{dca}",
                "ම\u{dd4}හ\u{dd4}ණ",
                "ම\u{dd4}හ\u{dd4}ණ සහ\u{dd2}ත ස\u{dd6}ර\u{dca}යය\u{dcf}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("slnko s tvárou"),
            keywords: &[
                "jas",
                "počasie",
                "slnko",
                "slnko s tvárou",
                "tvár",
                "vesmír",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("sonce z obrazom"),
            keywords: &[
                "obraz",
                "sonce",
                "sonce z obrazom",
                "svetlo",
                "vesolje",
                "vreme",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("qorrax wajiyeed"),
            keywords: &["dhalaal", "qorrax", "qorrax wajiyeed", "waji"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("diell me fytyrë"),
            keywords: &[
                "diell",
                "diell me fytyrë",
                "fytyrë",
                "hapësirë",
                "i ndritshëm",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("сунце са лицем"),
            keywords: &["вeдрo", "лице", "сунцe", "сунце са лицем"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["сунце са лицем"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("sunce sa licem"),
            keywords: &["lice", "sunce", "sunce sa licem", "vedro"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["sunce sa licem"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("sol med ansikte"),
            keywords: &["ansikte", "sol", "sol med ansikte"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("uso unaokaa jua"),
            keywords: &[
                "anga",
                "hali ya hewa",
                "jua",
                "kung’aa",
                "usi",
                "uso unaokaa jua",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("சூரிய முகம\u{bcd}"),
            keywords: &["சூரிய முகம\u{bcd}", "சூரியன\u{bcd}", "முகம\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("సూర\u{c4d}య ముఖం"),
            keywords: &["ముఖం", "సూర\u{c4d}య ముఖం", "సూర\u{c4d}యుడు"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("офтоб бо чеҳра"),
            keywords: &["офтоб", "офтоб бо чеҳра", "равшан", "рӯй"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("หน\u{e49}าพระอาท\u{e34}ตย\u{e4c}"),
            keywords: &[
                "พระอาท\u{e34}ตย\u{e4c}",
                "สว\u{e48}าง",
                "หน\u{e49}าพระอาท\u{e34}ตย\u{e4c}",
                "อากาศ",
                "ใบหน\u{e49}า",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ýüzli güneş"),
            keywords: &["gün", "ýagty", "ýüz", "ýüzli güneş"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("mata e laʻā"),
            keywords: &["mata e laʻā"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("güneş yüz"),
            keywords: &["güneş", "yüz"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("يۈزلۈك قۇياش"),
            keywords: &["كۈن", "يورۇق", "يۈز", "يۈزلۈك قۇياش"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("сонце з обличчям"),
            keywords: &[
                "космос",
                "обличчя",
                "погода",
                "сонце",
                "сонце з обличчям",
                "яскравий",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("چہرے والا سورج"),
            keywords: &["خلا", "سورج", "صاف", "موسم", "چہرہ", "چہرے والا سورج"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("quyosh qiyofasi"),
            keywords: &[
                "ob-havo",
                "osmon",
                "quyosh",
                "quyosh qiyofasi",
                "yorug‘ilik",
                "yuz",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("mặt trời có hình mặt người"),
            keywords: &["mặt", "mặt trời", "mặt trời có hình mặt người", "sáng"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("jant bu am kanam"),
            keywords: &["jant", "jant bu am kanam", "kanam", "yànj"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ilanga elinobuso"),
            keywords: &["ilanga", "ilanga elinobuso", "ngokukhanyayo", "ubuso"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Oorun Pẹlu Oju"),
            keywords: &["Oorun Pẹlu Oju", "ojú", "ìmọ\u{301}lẹ\u{300}", "òrùn"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("太陽表面"),
            keywords: &["光亮", "太陽", "太陽表面", "臉"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("太阳表面"),
            keywords: &["光亮", "太阳", "太阳表面", "脸"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("微笑的太阳"),
            keywords: &["太阳", "微笑的太阳"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("微笑的太陽"),
            keywords: &["太陽", "微笑的太陽"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("太陽笑面"),
            keywords: &["太陽", "太陽笑面"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ilanga elinobuso"),
            keywords: &[
                "ilanga",
                "ilanga elinobuso",
                "isimo sezulu",
                "ubuso",
                "ukukhanya",
                "umkhathi",
            ],
        },
    ],
};
#[doc = "🪐"]
pub const RINGED_PLANET: crate::Emoji = crate::Emoji {
    glyph: "🪐",
    codepoint: "1FA90",
    status: crate::Status::FullyQualified,
    introduction_version: 12f32,
    name: "ringed planet",
    group: "Travel & Places",
    subgroup: "sky & weather",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("planeet met ring om"),
            keywords: &["planeet met ring om", "saturnus"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ባለቀለበት ፕላኔት"),
            keywords: &["ሳተርን", "ባለቀለበት ፕላኔት", "የጨለመ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("كوكب داخل حلقة"),
            keywords: &["زحل", "كوكب داخل حلقة", "كوكب زحل"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("শনি গ\u{9cd}ৰহ"),
            keywords: &[
                "অপ\u{9cd}ৰফ\u{9c1}ল\u{9cd}ল",
                "শনি গ\u{9cd}ৰহ",
                "শনিগ\u{9cd}ৰহ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("üzüklü planet"),
            keywords: &["saturn", "üzüklü planet"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("планета з кальцом"),
            keywords: &["планета з кальцом", "сатурн"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("планета с пръстен"),
            keywords: &[
                "Сатурн",
                "планета с пръстен",
                "под влиянието на Сатурн",
                "под знака на Сатурн",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("বলয\u{9bc}য\u{9c1}ক\u{9cd}ত গ\u{9cd}রহ"),
            keywords: &[
                "গম\u{9cd}ভীরস\u{9cd}বভ\u{9be}ব",
                "বলয\u{9bc}য\u{9c1}ক\u{9cd}ত গ\u{9cd}রহ",
                "শনি",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("planedenn gant gwalennoù"),
            keywords: &["Sadorn", "gwalenn", "planedenn", "planedenn gant gwalennoù"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("planeta s prstenom"),
            keywords: &["planeta s prstenom", "pod uticajem saturna", "saturn"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("planeta amb anell"),
            keywords: &["planeta amb anell", "saturn", "saturní"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᎵᏰᏑᏍᏔᏬ ᎡᎶᎯ"),
            keywords: &["ᎠᎵᏰᏑᏍᏔᏬ ᎡᎶᎯ", "ᏌᏓᏂ", "ᏌᏓᏂ ᎢᏳᏍᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("planeta s prstencem"),
            keywords: &["planeta s prstencem", "saturn"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("planed cylchog"),
            keywords: &["planed", "planed cylchog", "sadwrn"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("planet med ringe"),
            keywords: &["Saturn", "planet med ringe"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Ringplanet"),
            keywords: &["Ringplanet", "Saturn"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("πλανήτης με δακτύλιο"),
            keywords: &["Κρόνος", "πλανήτης με δακτύλιο", "σαρδόνιος"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("ringed planet"),
            keywords: &["ringed planet", "saturn", "saturnine"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("planeta con anillos"),
            keywords: &["planeta con anillos", "saturnino", "saturno"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("rõngastega planeet"),
            keywords: &["Saturn", "rõngastega planeet"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("planeta eraztunduna"),
            keywords: &["Saturno", "goibel", "planeta eraztunduna"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("سیاره حلقه\u{200c}دار"),
            keywords: &["دلگیر", "زحل", "سیاره حلقه\u{200c}دار"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("rengasplaneetta"),
            keywords: &["Saturnus", "rengasplaneetta"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("planetang may singsing"),
            keywords: &["planetang may singsing", "saturn", "saturnine"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("gongustjørna við ringi"),
            keywords: &[
                "dapur",
                "gongustjørna",
                "gongustjørna við ringi",
                "saturn",
                "tunglyntur",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("planète à anneaux"),
            keywords: &["planète à anneaux", "saturne", "saturnien"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["planète à anneaux", "saturne", "saturnien", "saturnienne"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("pláinéad le fáinne"),
            keywords: &["Satarn", "pláinéad le fáinne"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("planaid fhàinneach"),
            keywords: &[
                "Rionnag nan Roth",
                "Sathairn",
                "gruamach",
                "planaid fhàinneach",
                "satarn",
                "saturn",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("planeta con aneis"),
            keywords: &["Saturno", "planeta con aneis", "sistema solar"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ફરત\u{ac7} રિ\u{a82}ગ ધરાવતો ગ\u{acd}રહ"),
            keywords: &[
                "ગ\u{acd}રહ શનિ",
                "ફરત\u{ac7} રિ\u{a82}ગ ધરાવતો ગ\u{acd}રહ",
                "શનિ",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("כוכב לכת עם טבעות"),
            keywords: &["כוכב לכת", "כוכב לכת עם טבעות", "כוכבים", "שבתאי"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("छल\u{94d}ल\u{947}दार ग\u{94d}रह"),
            keywords: &["ग\u{94d}रह", "छल\u{94d}ल\u{947}दार", "शनि ग\u{94d}रह"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("planet s prstenom"),
            keywords: &["Saturn", "planet s prstenom"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("gyűrűs bolygó"),
            keywords: &["Szaturnusz", "gyűrűs bolygó"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("օղակներով մոլորակ"),
            keywords: &["Երևակ", "Սատուրն", "օղակներով մոլորակ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("planet bercincin"),
            keywords: &["planet bercincin", "saturnus"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("pláneta með hringi"),
            keywords: &["fálátur", "pláneta með hringi", "satúrnus"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("pianeta con satellite"),
            keywords: &["Saturno", "pianeta con satellite"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("環のある惑星"),
            keywords: &["リング", "土星", "天体", "惑星", "星", "環のある惑星"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("planet anganggo ali-ali"),
            keywords: &[
                "planet anganggo ali-ali",
                "saturnus",
                "wong sing lairane ketiban sipating saturnus",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("პლანეტა სარტყელით"),
            keywords: &["პლანეტა სარტყელით", "სატურნი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("сақинасы бар планета"),
            keywords: &[
                "Сатурн белгісінде туылған",
                "сатурн",
                "сақинасы бар планета",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ភពដែលមាន\u{200b}កងរង\u{17d2}វង\u{17cb}ជ\u{17bb}\u{17c6}វ\u{17b7}ញ"),
            keywords: &[
                "ភពដែលមាន\u{200b}កងរង\u{17d2}វង\u{17cb}ជ\u{17bb}\u{17c6}វ\u{17b7}ញ",
                "ភពសៅរ\u{17cd}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ವರ\u{ccd}ತುಲವ\u{cbf}ರುವ ಗ\u{ccd}ರಹ"),
            keywords: &[
                "ವರ\u{ccd}ತುಲವ\u{cbf}ರುವ ಗ\u{ccd}ರಹ",
                "ಶನ\u{cbf}ಗ\u{ccd}ರಹ",
                "ಸ\u{ccd}ಯಾಟ\u{ccd}ರನೈನ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("고리가 있는 행성"),
            keywords: &["고리가 있는 행성", "토성"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("वलय आसपी गिरो"),
            keywords: &["वलय आसपी गिरो", "शनी", "शनीवलय"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("шакек менен курчалган планета"),
            keywords: &["сатурн", "түнт", "шакек менен курчалган планета"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ວ\u{ebb}ງ\u{200b}ແຫວນ\u{200b}ດາວ\u{200b}ເຄາະ"),
            keywords: &[
                "ດາວ\u{200b}ເສ\u{ebb}າ",
                "ວ\u{ebb}ງ\u{200b}ແຫວນ\u{200b}ດາວ\u{200b}ເຄາະ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("planeta su žiedu"),
            keywords: &["planeta su žiedu", "saturnas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("gredzenota planēta"),
            keywords: &["gredzenota planēta", "mīnijs", "saturns"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("планета со прстени"),
            keywords: &["планета со прстени", "сатурн"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("വളയങ\u{d4d}ങള\u{d41}ള\u{d4d}ള ഗ\u{d4d}രഹം"),
            keywords: &[
                "വളയങ\u{d4d}ങള\u{d41}ള\u{d4d}ള ഗ\u{d4d}രഹം",
                "ശനി",
                "ശനിഗ\u{d4d}രഹം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("тойрог замтай гараг"),
            keywords: &["санчир", "санчир гараг", "тойрог замтай гараг"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("वलया\u{902}कित ग\u{94d}रह"),
            keywords: &[
                "वलया\u{902}कित ग\u{94d}रह",
                "शनी",
                "शनी प\u{94d}रभावा\u{902}तर\u{94d}गत",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("planet bergelang"),
            keywords: &["planet bergelang", "suram", "zuhal"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "က\u{103d}င\u{103a}းပါရ\u{103e}\u{102d}သည\u{1037}\u{103a} ဂြ\u{102d}\u{102f}ဟ\u{103a}",
            ),
            keywords: &[
                "က\u{103d}င\u{103a}းပါရ\u{103e}\u{102d}သည\u{1037}\u{103a} ဂြ\u{102d}\u{102f}ဟ\u{103a}",
                "စနေဂြ\u{102d}\u{102f}ဟ\u{103a}",
                "သ\u{102f}န\u{103a}မ\u{103e}\u{102f}န\u{103a}သော",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("planet med ringer"),
            keywords: &["planet med ringer", "saturn"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("चक\u{94d}रल\u{947} घ\u{947}रिएको ग\u{943}ह"),
            keywords: &["उदास", "चक\u{94d}रल\u{947} घ\u{947}रिएको ग\u{943}ह", "शनि"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("planeet met ringen"),
            keywords: &["Saturnus", "planeet met ringen", "zwaarmoedig"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("planet med ringar"),
            keywords: &["planet med ringar", "saturn"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ର\u{b3f}ଙ\u{b4d}ଗ ଗ\u{b4d}ରହ"),
            keywords: &[
                "ବ\u{b3f}ଷର\u{b4d}ଣ\u{b4d}ଣ",
                "ର\u{b3f}ଙ\u{b4d}ଗ ଗ\u{b4d}ରହ",
                "ଶନ\u{b3f}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਚ\u{a71}ਕਰਾਕਾਰ ਗ\u{a4d}ਰਹਿ"),
            keywords: &[
                "ਚ\u{a71}ਕਰਾਕਾਰ ਗ\u{a4d}ਰਹਿ",
                "ਸ\u{a3c}ਨੀ",
                "ਸ\u{a3c}ਨੀ ਗ\u{a4d}ਰਹਿ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Plánẹt Wé Ring-dẹm Sọraund"),
            keywords: &[
                "Plánẹt Wé Ring-dẹm Sọraund",
                "Sátọn Sátọ\u{301}naín Fes",
                "Síriọs Fes Wé De Vẹks",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("planeta z pierścieniami"),
            keywords: &["pierścienie", "planeta z pierścieniami", "saturn"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("کړۍ داره سپوږمکۍ"),
            keywords: &["زحل", "سيټورنين", "کړۍ داره سپوږمکۍ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("planeta com anéis"),
            keywords: &["planeta com anéis", "saturnino", "saturno"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("planeta anelado"),
            keywords: &[
                "planeta anelado",
                "planeta com anéis",
                "saturnino",
                "saturno",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("planetă cu inele"),
            keywords: &["planetă cu inele", "saturn", "saturnian"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E12–069"),
            keywords: &["E12–069"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("планета с кольцом"),
            keywords: &[
                "кольца",
                "кольцо",
                "космос",
                "планета",
                "планета с кольцом",
                "сатурн",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("رنگ وارو پلانيٽ"),
            keywords: &["رنگ وارو پلانيٽ", "ساٽرن", "ساٽيورائن"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("වටක\u{dd4}ර\u{dd4} ග\u{dca}\u{200d}රහය\u{dcf}"),
            keywords: &[
                "නරච\u{dca}ඡ\u{dcf}ගය\u{dcf}",
                "වටක\u{dd4}ර\u{dd4} ග\u{dca}\u{200d}රහය\u{dcf}",
                "සෙනස\u{dd4}ර\u{dd4}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("planéta s prstencom"),
            keywords: &["planéta s prstencom", "saturn"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("planet z obročem"),
            keywords: &["planet z obročem", "saturn", "saturnov obroč"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("meeraha gaaban"),
            keywords: &["damman", "meeraha gaaban", "meeraha lixaad"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("planet me unazë"),
            keywords: &["Saturni", "planet me unazë", "unazë Saturni"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("планета са прстеном"),
            keywords: &["планета са прстеном", "сатурн"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("planeta sa prstenom"),
            keywords: &["planeta sa prstenom", "saturn"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("planet med ringar"),
            keywords: &["planet med ringar", "saturnine", "saturnus"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("sayari yenye duara"),
            keywords: &["baridi", "sayari yenye duara", "zohali"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("வளையம\u{bcd} உள\u{bcd}ள கோள\u{bcd}"),
            keywords: &[
                "கிரகம\u{bcd}",
                "கோள\u{bcd}",
                "சனி",
                "வளையம\u{bcd}",
                "வளையம\u{bcd} உள\u{bcd}ள கோள\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("చుట\u{c4d}టూ వలయం ఉన\u{c4d}న గ\u{c4d}రహం"),
            keywords: &[
                "చుట\u{c4d}టూ వలయం ఉన\u{c4d}న గ\u{c4d}రహం",
                "న\u{c3f}రుత\u{c4d}స\u{c3e}హం",
                "శన\u{c3f}గ\u{c4d}రహం",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ดาวเคราะห\u{e4c}ท\u{e35}\u{e48}ม\u{e35}วงแหวน"),
            keywords: &[
                "ดาวเคราะห\u{e4c}ท\u{e35}\u{e48}ม\u{e35}วงแหวน",
                "ดาวเสาร\u{e4c}",
                "แซตเท\u{e34}ร\u{e4c}นนายน\u{e4c}",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("halkaly planeta"),
            keywords: &["gamly", "halkaly planeta", "saturn"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("palanite mama"),
            keywords: &["Sātuna", "palanite mama"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("halkalı gezegen"),
            keywords: &["halkalı gezegen", "satürn"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("планета з кільцем"),
            keywords: &["планета з кільцем", "сатурн"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("حلقہ دار سیارہ"),
            keywords: &["حلقہ دار سیارہ", "زحل", "سیارہ زحل کے زیر اثر"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("halqali sayyora"),
            keywords: &["halqali sayyora", "qoʻrgʻoshin", "saturn"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("hành tinh có vành đai bao quanh"),
            keywords: &[
                "hành tinh có vành đai bao quanh",
                "sao thổ",
                "thần nông",
                "thổ tinh",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("環狀星球"),
            keywords: &["土星", "環狀星球", "陰沉"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("环状星球"),
            keywords: &["土星", "环状星球", "阴沉"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("有环行星"),
            keywords: &["土星", "有环行星"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("帶行星環的行星"),
            keywords: &["土星", "土星環", "帶行星環的行星"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("有行星環的行星"),
            keywords: &["土星", "土星環", "有行星環的行星"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("iplanethi eringayo"),
            keywords: &["i-saturine", "i-saturn", "iplanethi eringayo"],
        },
    ],
};
#[doc = "⭐"]
pub const STAR: crate::Emoji = crate::Emoji {
    glyph: "⭐",
    codepoint: "2B50",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "star",
    group: "Travel & Places",
    subgroup: "sky & weather",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("ster"),
            keywords: &["geel", "ster"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ነጭ መካከለኛ ኮከብ"),
            keywords: &["ነጭ መካከለኛ ኮከብ", "ኮከብ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("نجم متوسط أبيض"),
            keywords: &["نجم", "نجم متوسط أبيض"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("বগ\u{9be} মধ\u{9cd}যম তৰ\u{9be}"),
            keywords: &["তৰ\u{9be}", "বগ\u{9be} মধ\u{9cd}যম তৰ\u{9be}"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("ağ orta ulduz"),
            keywords: &["ağ orta ulduz", "ulduz"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("звычайная зорка"),
            keywords: &["звычайная зорка", "зорка"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("зезда"),
            keywords: &["жълта звезда", "звезда", "зезда"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("স\u{9be}দ\u{9be} ম\u{9be}ঝ\u{9be}রি ত\u{9be}র\u{9be}"),
            keywords: &[
                "ত\u{9be}র\u{9be}",
                "স\u{9be}দ\u{9be} ম\u{9be}ঝ\u{9be}রি ত\u{9be}র\u{9be}",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("steredenn"),
            keywords: &["steredenn"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("zvijezda"),
            keywords: &["zvijezda"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("estrella"),
            keywords: &["estrella"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏃᏈᏏ"),
            keywords: &["ᏃᏈᏏ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("bílá hvězda střední velikosti"),
            keywords: &["bílá hvězda střední velikosti", "hvězda"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("seren ganolig wen"),
            keywords: &["seren", "seren ganolig wen"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("stjerne"),
            keywords: &["stjerne"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("weißer mittelgroßer Stern"),
            keywords: &["Stern", "weißer mittelgroßer Stern"],
        },
        #[cfg(feature = "de_CH")]
        crate::Annotation {
            lang: "de_CH",
            tts: Some("weisser mittelgrosser Stern"),
            keywords: &["Stern", "weisser mittelgrosser Stern"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("αστέρι"),
            keywords: &["αστέρι"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("star"),
            keywords: &["star"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: None,
            keywords: &["star", "yellow medium star"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("estrella blanca mediana"),
            keywords: &["estrella", "estrella blanca mediana"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("estrella blanca"),
            keywords: &["blanca", "estrella"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("estrella"),
            keywords: &["estrella"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("täht"),
            keywords: &["täht", "tärn"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("izarra"),
            keywords: &["izar", "izar zuri ertaina", "izarra"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("ستاره سفید"),
            keywords: &["ستاره", "ستاره سفید"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("valkoinen tähti"),
            keywords: &["tähti", "valkoinen tähti"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("puting bituin na katamtamang-laki"),
            keywords: &["bituin", "puti", "puting bituin na katamtamang-laki"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("hvit og gul stjørna"),
            keywords: &["hvit og gul stjørna", "stjørna"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("étoile"),
            keywords: &["étoile"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("étoile moyenne"),
            keywords: &["étoile", "étoile moyenne"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("réalta"),
            keywords: &["réalta"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("rionnag mheadhanach gheal"),
            keywords: &["reul", "rionnag", "rionnag mheadhanach gheal"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("estrela"),
            keywords: &["estrela"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("મધ\u{acd}યમ સફ\u{ac7}દ તારો"),
            keywords: &["તારો", "મધ\u{acd}યમ સફ\u{ac7}દ તારો", "સ\u{acd}ટાર"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("farin matsakaicin tauraro"),
            keywords: &["farin matsakaicin tauraro", "tauraro"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("כוכב"),
            keywords: &["כוכב"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("मध\u{94d}यम सफ\u{93c}\u{947}द तारा"),
            keywords: &["तारा", "मध\u{94d}यम सफ\u{93c}\u{947}द तारा"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("zvijezda"),
            keywords: &["zvijezda"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("csillag"),
            keywords: &["csillag"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("սպիտակավուն աստղ"),
            keywords: &["աստղ", "սպիտակավուն աստղ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("bintang medium putih"),
            keywords: &["bintang", "bintang medium putih"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("kpakpando ọcha"),
            keywords: &["kpakpando", "kpakpando ọcha"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("hvít stjarna"),
            keywords: &["hvít stjarna", "stjarna"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("stella"),
            keywords: &["astro", "stella"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("スター"),
            keywords: &["スター", "星"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("lintang"),
            keywords: &["lintang"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("საშუალო თეთრი ვარსკვლავი"),
            keywords: &["ვარსკვლავი", "საშუალო თეთრი ვარსკვლავი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("ақ орташа жұлдыз"),
            keywords: &["ақ орташа жұлдыз", "жұлдыз"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("hvid mellemstor stjerne"),
            keywords: &["hvid mellemstor stjerne", "stjerne"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ផ\u{17d2}កាយ"),
            keywords: &["តារា", "ផ\u{17d2}កាយ"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ನಕ\u{ccd}ಷತ\u{ccd}ರ"),
            keywords: &[
                "ನಕ\u{ccd}ಷತ\u{ccd}ರ",
                "ಬ\u{cbf}ಳ\u{cbf} ಮಧ\u{ccd}ಯಮ ನಕ\u{ccd}ಷತ\u{ccd}ರ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("별"),
            keywords: &["별"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("नख\u{947}त\u{94d}र"),
            keywords: &["नख\u{947}त\u{94d}र"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("жылдыз"),
            keywords: &["жылдыз"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("mëttelgrousse wäisse Stär"),
            keywords: &["Stär", "mëttelgrousse wäisse Stär"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ດາວຂາວປານກາງ"),
            keywords: &["ດາວ", "ດາວຂາວປານກາງ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("balta vidutinė žvaigždė"),
            keywords: &["balta vidutinė žvaigždė", "žvaigždė"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("zvaigzne"),
            keywords: &["zvaigzne"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("whetū mā waenga"),
            keywords: &["whetū", "whetū mā waenga"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("средна бела ѕвезда"),
            keywords: &["средна бела ѕвезда", "ѕвезда"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("വെള\u{d4d}ള നക\u{d4d}ഷത\u{d4d}രം"),
            keywords: &[
                "ത\u{d3e}രം",
                "നക\u{d4d}ഷത\u{d4d}രം",
                "വെള\u{d4d}ള നക\u{d4d}ഷത\u{d4d}രം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("од"),
            keywords: &["од"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("पा\u{902}ढरा मध\u{94d}यम तारा"),
            keywords: &["तारा", "पा\u{902}ढरा मध\u{94d}यम तारा"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("bintang sederhana putih"),
            keywords: &["bintang", "bintang sederhana putih"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("stilla medja bajda"),
            keywords: &["stilla", "stilla medja bajda"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အဖြ\u{1030}ရောင\u{103a} အလတ\u{103a}စား ကြယ\u{103a}"),
            keywords: &[
                "ကြယ\u{103a}",
                "အဖြ\u{1030}ရောင\u{103a} အလတ\u{103a}စား ကြယ\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("stjerne"),
            keywords: &["stjerne"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("स\u{947}तो मध\u{94d}यम तारा"),
            keywords: &["तारा", "स\u{947}तो मध\u{94d}यम तारा"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("witte middelgrote ster"),
            keywords: &["ster", "witte middelgrote ster"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("stjerne"),
            keywords: &["stjerne"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ତ\u{b3e}ର\u{b3e}"),
            keywords: &["ତ\u{b3e}ର\u{b3e}"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਮ\u{a71}ਧਮ ਸਫ\u{a47}ਦ ਤਾਰਾ"),
            keywords: &["ਤਾਰਾ", "ਮ\u{a71}ਧਮ ਸਫ\u{a47}ਦ ਤਾਰਾ", "ਸਫ\u{a47}ਦ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("درمیانہ چٹ\u{651}ا ستارہ"),
            keywords: &["تارہ", "درمیانہ چٹ\u{651}ا ستارہ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Sta"),
            keywords: &["Sta"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("gwiazda"),
            keywords: &["gwiazda"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ستوری"),
            keywords: &["ستوری"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("estrela branca média"),
            keywords: &["estrela branca média"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("estrela"),
            keywords: &["estrela", "estrela amarela"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("quyllur"),
            keywords: &["quyllur"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("stea"),
            keywords: &["stea"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-161"),
            keywords: &["E10-161"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("желтая звезда"),
            keywords: &["желтая", "звезда"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("inyenyeri iringaniye y’umweru"),
            keywords: &["inyenyeri", "inyenyeri iringaniye y’umweru"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("سفيد وچولو تارو"),
            keywords: &["تارو", "سفيد وچولو تارو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ස\u{dd4}ද\u{dd4} මධ\u{dca}\u{200d}යම තර\u{dd4}ව"),
            keywords: &[
                "තර\u{dd4}ව",
                "ස\u{dd4}ද\u{dd4} මධ\u{dca}\u{200d}යම තර\u{dd4}ව",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("hviezda"),
            keywords: &["biela stredná hviezda", "hviezda"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("bela srednja zvezda"),
            keywords: &["bela srednja zvezda", "zvezda"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("Summadda xiddigta"),
            keywords: &["Summadda xiddigta", "xiddig"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("yll mesatar i bardhë"),
            keywords: &["yll", "yll mesatar i bardhë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("звезда"),
            keywords: &["звезда"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("звијезда"),
            keywords: &["звијезда"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("zvezda"),
            keywords: &["zvezda"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("zvijezda"),
            keywords: &["zvijezda"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("stjärna"),
            keywords: &["stjärna", "vit medelstor stjärna"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("nyota nyeupe ya wastani"),
            keywords: &["nyota", "nyota nyeupe ya wastani"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("வெள\u{bcd}ளை நிற நட\u{bcd}சத\u{bcd}திரம\u{bcd}"),
            keywords: &[
                "நட\u{bcd}சத\u{bcd}திரம\u{bcd}",
                "வெளிர\u{bcd}நிற நட\u{bcd}சத\u{bcd}திரம\u{bcd}",
                "வெள\u{bcd}ளை நிற நட\u{bcd}சத\u{bcd}திரம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("త\u{c46}ల\u{c4d}లన\u{c3f} నక\u{c4d}షత\u{c4d}రం"),
            keywords: &["త\u{c46}ల\u{c4d}లన\u{c3f}", "నక\u{c4d}షత\u{c4d}రం"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("ситораи миёнаи сафед"),
            keywords: &["ситора", "ситораи миёнаи сафед"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ดาวส\u{e35}ขาวขนาดกลาง"),
            keywords: &["ดวงดาว", "ดาวส\u{e35}ขาวขนาดกลาง"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ýyldyz"),
            keywords: &["ýyldyz"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("fetuʻu"),
            keywords: &["fetuʻu"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("yıldız"),
            keywords: &["beyaz orta yıldız", "yıldız"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئاق ئارا يۇلتۇز"),
            keywords: &["ئاق ئارا يۇلتۇز", "يۇلتۇز"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("зірка"),
            keywords: &["зірка", "середня біла зірка"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ستارہ"),
            keywords: &["ستارہ", "سفید میڈیم ستارہ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("oq o‘rtacha yulduz"),
            keywords: &["oq o‘rtacha yulduz", "yulduz"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("ngôi sao"),
            keywords: &["ngôi sao"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("biddeew, weexaay bu yam"),
            keywords: &["biddeew", "biddeew, weexaay bu yam"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("inkwenkwezi ephakathi emhlophe"),
            keywords: &["inkwenkwezi", "inkwenkwezi ephakathi emhlophe"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Irawọ Alaabọ Funfun"),
            keywords: &["Irawọ Alaabọ Funfun", "ìràwọ\u{300}"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("白色中等星星"),
            keywords: &["星星", "白色中等星星"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("白色中等星星"),
            keywords: &["星星", "白色中等星星"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("星星"),
            keywords: &["五角星", "星星"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("星星"),
            keywords: &["星星"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("inkanyezi ephakathi nendawo emhlophe"),
            keywords: &["inkanyezi", "inkanyezi ephakathi nendawo emhlophe"],
        },
    ],
};
#[doc = "🌟"]
pub const GLOWING_STAR: crate::Emoji = crate::Emoji {
    glyph: "🌟",
    codepoint: "1F31F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "glowing star",
    group: "Travel & Places",
    subgroup: "sky & weather",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("gloeiende ster"),
            keywords: &[
                "glans",
                "gloei",
                "gloeiende ster",
                "skitter",
                "skyn",
                "ster",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ብልጭ ድርግም የሚል ኮከብ"),
            keywords: &["ማብራት", "ማንጸባረቅ", "ብልጭ ድርግም", "ብልጭ ድርግም የሚል ኮከብ", "አብለጭለጭ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("نجم ساطع"),
            keywords: &["إشراق", "زهو", "سطوع", "لامع", "لمعان", "نجم", "نجم ساطع"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("উজ\u{9cd}জ\u{9cd}বল তৰ\u{9be}"),
            keywords: &["উজ\u{9cd}জ\u{9cd}বল", "জ\u{9be}কজমক", "তৰ\u{9be}"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("parıldayan ulduz"),
            keywords: &["işıq", "parlaq", "parıldayan", "qığılcım", "ulduz"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("бліскучая зорка"),
            keywords: &["бліскучая зорка", "бліскучы", "ззянне", "зорка", "іскра"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("блестяща звезда"),
            keywords: &["блестящ", "блестяща звезда", "блясък", "звезда", "искрящ"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("উজ\u{9cd}জ\u{9cd}বল ত\u{9be}র\u{9be}"),
            keywords: &[
                "উজ\u{9cd}জ\u{9cd}বল ত\u{9be}র\u{9be}",
                "উদ\u{9cd}ভ\u{9be}স",
                "জ\u{9cd}বলজ\u{9cd}বলে",
                "ঝকমক",
                "ত\u{9be}র\u{9be}",
                "দ\u{9cd}য\u{9c1}তি",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("steredenn skedus"),
            keywords: &["steredenn", "steredenn skedus"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("sjajna zvijezda"),
            keywords: &[
                "blistavo",
                "sjajna zvijezda",
                "sjajno",
                "svemir",
                "zvijezda",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("estrella brillant"),
            keywords: &["brillant", "brillar", "espurna", "estrella"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᏥᏍᏓᎷᎩᏍᎩ ᏃᏈᏏ"),
            keywords: &[
                "ᎠᏔᏅᎩᎠ",
                "ᎠᏥᏍᏓᎷᎩᎠ",
                "ᎠᏥᏍᏓᎷᎩᏍᎩ",
                "ᎤᏥᏍᎳ",
                "ᎤᏥᏍᏓᎷᎩᏍᎩ ᏃᏈᏏ",
                "ᏃᏈᏏ",
            ],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("zářící hvězda"),
            keywords: &["hvězda", "jas", "jiskra", "záře", "zářící"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("seren yn tywynnu"),
            keywords: &["disgleirio", "pelydru", "seren yn tywynnu", "tywynnu"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("blinkende stjerne"),
            keywords: &[
                "blinkende stjerne",
                "lysende stjerne",
                "lyser",
                "skinner",
                "stjerneskin",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("funkelnder Stern"),
            keywords: &["Stern", "funkelnder Stern"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("λαμπερό αστέρι"),
            keywords: &["αστέρι", "αστραφτερό", "γυαλιστερό", "λάμψη", "λαμπερό"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("glowing star"),
            keywords: &[
                "glittery",
                "glow",
                "glowing star",
                "shining",
                "sparkle",
                "star",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("estrella brillante"),
            keywords: &["brillante", "estrella", "resplandeciente"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["brillante", "estrella"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["brillante", "brillo", "centellar", "estrella"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("helendav täht"),
            keywords: &["helendav", "sära", "täht"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("izar distiratsua"),
            keywords: &[
                "distira",
                "distiratsu",
                "izar",
                "izar distiratsua",
                "txinparta",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("ستاره درخشان"),
            keywords: &["جرقه", "درخشان", "ستاره", "فروزان"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("loistava tähti"),
            keywords: &["loistava tähti", "loiste", "säihke", "tähti", "valo"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("kumikinang na bituin"),
            keywords: &["bituin", "kumikinang", "kumikinang na bituin", "kumikislap"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("glógvandi stjørna"),
            keywords: &["glógvandi stjørna", "stjørna"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("étoile brillante"),
            keywords: &["étoile", "étoile brillante"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["brillante", "étoile"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("réalta ag lonrú"),
            keywords: &["lonrú", "réalta", "réalta ag lonrú"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("rionnag dhealrach"),
            keywords: &[
                "boillsgeadh",
                "dealrach",
                "dealradh",
                "priobadh reul",
                "rionnag",
                "rionnag dhealrach",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("estrela brillante"),
            keywords: &["brillante", "escintilante", "estrela"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ચમકતો તારો"),
            keywords: &["ચમકતો", "ચમકદાર", "ચમકનાર", "ચળકવ\u{ac1}\u{a82}", "તારો"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("tauraro mai haske"),
            keywords: &[
                "haska",
                "haske",
                "mai ƙyalƙyali",
                "tauraro",
                "tauraro mai haske",
                "yi ƙyalƙyali",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("כוכב זוהר"),
            keywords: &["זוהר", "כוכב", "מנצנץ"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("चमकदार तारा"),
            keywords: &["चमक", "चमकदार", "चमकीला", "तारा"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("zvijezda koja sjaji"),
            keywords: &["iskre", "sjaj", "zvijezda", "zvijezda koja sjaji"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("fénylő csillag"),
            keywords: &["csillag", "csillogás", "fény", "fénylő csillag"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("փայլող աստղ"),
            keywords: &["աստղ", "կայծ", "փայլող"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("bintang bersinar"),
            keywords: &["berkilau", "bersinar", "bintang", "cemerlang"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("kpakpando na-amụke amụke"),
            keywords: &[
                "kpakpando",
                "kpakpando na-amụke amụke",
                "mmukesi",
                "mmụke",
                "mụrụmụrụ",
                "nchapụta",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("skínandi stjarna"),
            keywords: &["skínandi", "stjarna"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("stella che brilla"),
            keywords: &["brillante", "scintillante", "stella", "stella che brilla"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("きらきら星"),
            keywords: &["きらきら", "きらきら星", "スター", "星", "輝き"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("lintang cemlorot"),
            keywords: &[
                "clorot",
                "kelip-kelip",
                "kerlip-kerlip",
                "lintang",
                "lintang cemlorot",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მბრწყინავი ვარსკვლავი"),
            keywords: &["ბრწყინვა", "ვარსკვლავი", "კაშკაში", "მბრწყინავი ვარსკვლავი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("жарқырап тұрған жұлдыз"),
            keywords: &[
                "жарқырап тұрған жұлдыз",
                "жарқырау",
                "жылтылдау",
                "жылтырау",
                "жұлдыз",
                "сәуле шашу",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("blinkende stjerne"),
            keywords: &[
                "blinkende stjerne",
                "lysende stjerne",
                "lyser",
                "skinner",
                "stjerneskin",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ផ\u{17d2}កាយបញ\u{17d2}ចេញពន\u{17d2}ល\u{17ba}"),
            keywords: &[
                "តារា",
                "ផ\u{17d2}កាយ",
                "ផ\u{17d2}កាយបញ\u{17d2}ចេញពន\u{17d2}ល\u{17ba}",
                "ពន\u{17d2}ល\u{17ba}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಮ\u{cbf}ಣುಗುವ ನಕ\u{ccd}ಷತ\u{ccd}ರ"),
            keywords: &[
                "ನಕ\u{ccd}ಷತ\u{ccd}ರ",
                "ಪ\u{ccd}ರಕಾಶ",
                "ಮ\u{cbf}ಂಚ\u{cbf}ನ",
                "ಮ\u{cbf}ಣುಗುವ ನಕ\u{ccd}ಷತ\u{ccd}ರ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("반짝이는 별"),
            keywords: &["반짝이는 별", "반짝이다", "반짝임", "별"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("मिणमिणपी नख\u{947}त\u{94d}र"),
            keywords: &[
                "चकचक",
                "चकचकीत",
                "झगमग",
                "झगमगता",
                "झगमगपी नख\u{947}त\u{94d}र",
                "नख\u{947}त\u{94d}र",
                "मिणमिणपी नख\u{947}त\u{94d}र",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("жаркыраган жылдыз"),
            keywords: &["жалтылдаган", "жаркыраган жылдыз", "жылдыз", "жылтылдаган"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("liichtende Stär"),
            keywords: &[
                "Stär",
                "blénkeg",
                "blénken",
                "glënnerend",
                "liichtend",
                "liichtende Stär",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ດາວເປ\u{eb1}\u{ec8}ງປະກາຍ"),
            keywords: &["ດາວ", "ດາວເປ\u{eb1}\u{ec8}ງປະກາຍ", "ເປ\u{eb1}\u{ec8}ງປະກາຍ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("žėrinti žvaigždė"),
            keywords: &["kibirkštis", "šviesti", "žvaigždė", "žėrinti", "žėrėti"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("spīdoša zvaigzne"),
            keywords: &["spīdoša zvaigzne", "spīdēt", "zvaigzne"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("whetū mumura"),
            keywords: &[
                "hana",
                "korakora",
                "tīaho",
                "wheriko",
                "whetū",
                "whetū mumura",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("светлечка ѕвезда"),
            keywords: &["свети", "светка", "светлечка ѕвезда", "ѕвезда"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("തിളങ\u{d4d}ങ\u{d41}ന\u{d4d}ന നക\u{d4d}ഷത\u{d4d}രം"),
            keywords: &[
                "ക\u{d4d}രിസ\u{d4d}മസ\u{d4d}",
                "തിളക\u{d4d}കം",
                "തിളങ\u{d4d}ങ\u{d41}ന\u{d4d}ന നക\u{d4d}ഷത\u{d4d}രം",
                "നക\u{d4d}ഷത\u{d4d}രം",
                "മിന\u{d4d}ന\u{d41}ന\u{d4d}ന നക\u{d4d}ഷത\u{d4d}രം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("гялалзаж буй од"),
            keywords: &["гялалзаж буй од", "гялалзах", "од", "тэнгэр"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("चमकणारा तारा"),
            keywords: &["चमक", "चमकणारा", "चमकदार", "चमचमता", "तारा"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("bintang bersinar"),
            keywords: &["bercahaya", "berkilau", "berkilauan", "bersinar", "bintang"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("stilla tiddi"),
            keywords: &["jiddi", "stilla", "tiddi", "tlellex", "tleqq"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("တောက\u{103a}ပသည\u{1037}\u{103a} ကြယ\u{103a}"),
            keywords: &[
                "ကြယ\u{103a}",
                "တောက\u{103a}ပ",
                "တောက\u{103a}ပသည\u{1037}\u{103a} ကြယ\u{103a}",
                "လက\u{103a}",
                "ဝင\u{103a}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("lysende stjerne"),
            keywords: &["glitrende", "lysende stjerne", "skinnende", "stjerne"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("चम\u{94d}किरह\u{947}को तारा"),
            keywords: &[
                "उज\u{94d}यालो",
                "ग\u{94d}लिटरिङ\u{94d}",
                "चम\u{94d}किरह\u{947}को तारा",
                "चम\u{94d}क\u{947}को",
                "चम\u{94d}मिकरह\u{947}को",
                "तारा",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("stralende ster"),
            keywords: &[
                "fonkelend",
                "schitterend",
                "schittering",
                "ster",
                "stralen",
                "stralende ster",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("lysande stjerne"),
            keywords: &["glitrande", "lysande stjerne", "skinande", "stjerne"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଉଜ\u{b4d}ଜ\u{b4d}ୱଳ ତ\u{b3e}ର\u{b3e}"),
            keywords: &[
                "ଉଜ\u{b4d}ଜ\u{b4d}ୱଳ ତ\u{b3e}ର\u{b3e}",
                "ଚମକ",
                "ଚମକ\u{b41}ଥ\u{b3f}ବ\u{b3e}",
                "ତ\u{b3e}ର\u{b3e}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਜਗਮਗਾਉ\u{a02}ਦਾ ਤਾਰਾ"),
            keywords: &[
                "ਚਮਕਦਾ",
                "ਜਗਮਗਉ\u{a02}ਦਾ ਤਾਰਾ",
                "ਜਗਮਗਾਉ\u{a02}ਦਾ ਤਾਰਾ",
                "ਝਿਲਮਿਲਾਉ\u{a02}ਦਾ",
                "ਤਾਰਾ",
                "ਦਮਕਦਾ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("روشن ستارہ"),
            keywords: &[
                "تارہ",
                "جگ مگ کرنا",
                "درخشاں",
                "روشن ستارہ",
                "لہکنا",
                "چمکدا ہوئیا",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Shaínín Sta"),
            keywords: &[
                "De Glo",
                "Glo",
                "Glíta",
                "Shain",
                "Shaínín Sta",
                "Spákul",
                "Sta",
                "Sta Wé De Glo",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("błyszcząca gwiazda"),
            keywords: &[
                "błyszcząca",
                "błyszcząca gwiazda",
                "lśniąca",
                "świecąca gwiazdka",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("پړقېدونکی ستوری"),
            keywords: &["ستوری", "پړقېدونکی", "ځلا", "ځلېدونکی"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("estrela brilhante"),
            keywords: &[
                "brilhante",
                "brilho",
                "cintilante",
                "estrela",
                "luminosa",
                "reluzente",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["brilhante", "brilho", "cintilante", "estrela"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("lliphisqa quyllur"),
            keywords: &["k’anchay", "k’anchaynin", "lliphisqa", "quyllur"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("stea strălucitoare"),
            keywords: &["stea", "stea strălucitoare", "strălucire"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-230"),
            keywords: &["E10-230"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("сияющая звезда"),
            keywords: &["звезда", "свет", "сияние", "сияющая звезда"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("inyenyeri ishashagirana"),
            keywords: &[
                "cyaka",
                "gishashagirana",
                "inyenyeri",
                "inyenyeri ishashagirana",
                "kirabagirana",
                "kubengerana",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("چمڪندڙ تارو"),
            keywords: &["تارو", "ٽمڪندڙ", "چمڪ", "چمڪندڙ", "چمڪيلو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ද\u{dd2}ලෙන තර\u{dd4}ව"),
            keywords: &[
                "තර\u{dd4}ව",
                "ද\u{dd2}ද\u{dd4}ලන",
                "ද\u{dd2}ලෙන තර\u{dd4}ව",
                "ද\u{dd2}ළ\u{dd2}ස\u{dd3}ම",
                "ද\u{dd2}ළ\u{dd2}සෙන",
                "බැබළ\u{dd3}ම",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("žiariaca hviezda"),
            keywords: &[
                "hviezda",
                "jas",
                "trblietať",
                "záblesk",
                "žiariaca hviezda",
                "žiariť",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("žareča zvezda"),
            keywords: &[
                "bleščeče",
                "lesketanje",
                "sijanje",
                "zvezda",
                "žar",
                "žareča zvezda",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("xiddig kaahaya"),
            keywords: &[
                "dhalaalaya",
                "ifid",
                "kaah",
                "quruxsan",
                "xiddig",
                "xiddig kaahaya",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("yll që shkëlqen"),
            keywords: &[
                "i ndritshëm",
                "shkëlqim",
                "xixëllimë",
                "yll",
                "yll që shkëlqen",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("звезда која светли"),
            keywords: &["звeздa", "звезда која светли", "искрe", "сjaj"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("звијезда која свијетли"),
            keywords: &["звијезда која свијетли"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("zvezda koja svetli"),
            keywords: &["iskre", "sjaj", "zvezda", "zvezda koja svetli"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("zvijezda koja svijetli"),
            keywords: &["zvijezda koja svijetli"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("blänkande stjärna"),
            keywords: &["blänkande", "glittrande", "gnistrande", "stjärna"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("nyota inayong’aa"),
            keywords: &[
                "kumetameta",
                "kung’ara",
                "metameta",
                "ng’aa",
                "nyota",
                "nyota inayong’aa",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ஒளி வ\u{bc0}சும\u{bcd} நட\u{bcd}சத\u{bcd}திரம\u{bcd}"),
            keywords: &[
                "ஒளி வ\u{bc0}சும\u{bcd} நட\u{bcd}சத\u{bcd}திரம\u{bcd}",
                "திறமை",
                "நட\u{bcd}சத\u{bcd}திரம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("మ\u{c46}ర\u{c3f}స\u{c47} నక\u{c4d}షత\u{c4d}రం"),
            keywords: &["నక\u{c4d}షత\u{c4d}రం", "మ\u{c46}ర\u{c3f}స\u{c47}"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("ситораи дурахшон"),
            keywords: &[
                "дурахшидан",
                "дурахшон",
                "пурҷило",
                "ситора",
                "ситораи дурахшон",
                "ялаққос задан",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ดาวส\u{e48}องแสง"),
            keywords: &[
                "ดาว",
                "ดาวส\u{e48}องแสง",
                "ประกาย",
                "ระย\u{e34}บระย\u{e31}บ",
                "แสง",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("lowurdaýan ýyldyz"),
            keywords: &[
                "lowurdaýan ýyldyz",
                "lowurdy",
                "parlaýan",
                "uçgun",
                "ýalpyldawuk",
                "ýyldyz",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("fetuʻu ngingila"),
            keywords: &["fetuʻu ngingila"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("parıldayan yıldız"),
            keywords: &[
                "kıvılcım",
                "parıldama",
                "parıldayan yıldız",
                "pırıltı",
                "yıldız",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("چاقنار يۇلتۇز"),
            keywords: &[
                "يارقىن",
                "يالقۇن",
                "يورۇق",
                "يۇلتۇز",
                "چاقنار يۇلتۇز",
                "چاقناش",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("сяйна зірка"),
            keywords: &[
                "блискучий",
                "зірка",
                "світиться",
                "світло",
                "сяйна зірка",
                "сяє",
                "іскра",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("چمکتا ستارہ"),
            keywords: &["ستارہ", "چمکتا"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("porlayotgan yulduz"),
            keywords: &["charaqlash", "porlash", "porlayotgan", "porloq", "yulduz"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("ngôi sao lấp lánh"),
            keywords: &[
                "chiếu sáng",
                "lấp lánh",
                "ngôi sao",
                "ngôi sao lấp lánh",
                "phát sáng",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("biddeew tàkk"),
            keywords: &["biddeew", "leeraay", "tàkk", "yànj", "yànjaay"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("inkwenkwezi ekhanyayo"),
            keywords: &[
                "bengezela",
                "ekhanyayo",
                "ekhazimlayo",
                "emenyezelayo",
                "inkwenkwezi",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Irawọ Titan"),
            keywords: &["Irawọ Titan", "dán", "dídán", "tàn", "ìràwọ\u{300}"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("發光嘅星星"),
            keywords: &["星星", "發光", "發光嘅星星", "閃", "閃耀", "閃閃發光"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("发光嘅星星"),
            keywords: &["发光", "发光嘅星星", "星星", "闪", "闪耀", "闪闪发光"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("闪亮的星星"),
            keywords: &["发光", "星星", "闪亮的星星"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("閃爍的星星"),
            keywords: &["星星", "閃爍的星星"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("閃亮嘅星星"),
            keywords: &["星星", "閃亮嘅星星"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("inkanyezi ebhanyazayo"),
            keywords: &["inkanyezi", "inkanyezi ebhanyazayo", "ukubhayaza"],
        },
    ],
};
#[doc = "🌠"]
pub const SHOOTING_STAR: crate::Emoji = crate::Emoji {
    glyph: "🌠",
    codepoint: "1F320",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "shooting star",
    group: "Travel & Places",
    subgroup: "sky & weather",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("verskietende ster"),
            keywords: &[
                "ruimte",
                "skiet",
                "ster",
                "val",
                "verskiet",
                "verskietende ster",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ተወርዋሪ ኮከብ"),
            keywords: &["ህዋ", "መወርወር", "መውደቅ", "ተወርዋሪ ኮከብ", "ኮከብ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("شهاب"),
            keywords: &["انطلاق", "سقوط", "شهاب", "فضاء", "قنص", "نجم"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("উল\u{9cd}ক\u{9be}"),
            keywords: &[
                "উল\u{9cd}ক\u{9be}",
                "তৰ\u{9be}",
                "পতিত",
                "শ\u{9cd}ব\u{9c1}টিং",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("düşən ulduz"),
            keywords: &["düşən ulduz", "kosmos", "parlama", "tökülmək", "ulduz"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("знічка"),
            keywords: &["знічка", "зорка", "космас", "мара", "метэор"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("падаща звезда"),
            keywords: &["звезда", "космос", "падаща"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("উল\u{9cd}ক\u{9be}"),
            keywords: &[
                "উল\u{9cd}ক\u{9be}",
                "ত\u{9be}র\u{9be}",
                "পতিত",
                "মহ\u{9be}ক\u{9be}শ",
                "শ\u{9c1}টিং",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("steredenn-dared"),
            keywords: &["steredenn", "steredenn-dared"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("zvijezda padalica"),
            keywords: &["padalica", "svemir", "zvijezda"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("estel fugaç"),
            keywords: &["cel", "espai", "estel", "estrella", "fugaç"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᏬᎰᏒ ᏃᏈᏏ"),
            keywords: &["ᎤᏬᎰᏒ", "ᎪᎰᏍᎬᎢ", "ᏃᏈᏏ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("padající hvězda"),
            keywords: &["hvězda", "kometa", "padající", "vesmír"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("seren wib"),
            keywords: &["gofod", "gwibio", "seren wib", "syrthio"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("stjerneskud"),
            keywords: &["stjerne", "stjerneskud"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Sternschnuppe"),
            keywords: &["Himmel", "Sternschnuppe"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("αστέρι που πέφτει"),
            keywords: &["αστέρι", "αστέρι που πέφτει", "διάστημα", "που πέφτει"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("shooting star"),
            keywords: &["falling", "shooting", "star"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("estrella fugaz"),
            keywords: &["estrella", "estrella fugaz", "lluvia"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["espacio", "estrella", "fugaz"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["cayendo", "estrella", "fugaz"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("langev täht"),
            keywords: &["komeet", "kosmos", "langev", "täht"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("izar-uxoa"),
            keywords: &["espazio", "iheskor", "izar", "izar-uxoa", "uxo"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("ستاره ثاقب"),
            keywords: &[
                "افتادن",
                "دنباله\u{200c}دار",
                "ستاره",
                "ستاره ثاقب",
                "سریع",
                "فضا",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("tähdenlento"),
            keywords: &["avaruus", "toive", "tähdenlento", "tähti"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("bulalakaw"),
            keywords: &["bituin", "bulalakaw", "kalawakan", "shooting star"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("stjørnuskot"),
            keywords: &["stjørna", "stjørnuskot"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("étoile filante"),
            keywords: &["étoile", "étoile filante"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["filante", "étoile"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("réalta reatha"),
            keywords: &["réalta", "réalta reatha"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("rionnag earballach"),
            keywords: &["dreag", "earballach", "reul", "rionnag", "tuiteam"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("estrela fugaz"),
            keywords: &[
                "choiva de estrelas",
                "chuvia de estrelas",
                "estrela",
                "fugaz",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ખરતો તારો"),
            keywords: &["ખરતો", "તારો"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("mashi"),
            keywords: &["faɗuwa", "mashi"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("כוכב שביט"),
            keywords: &["חלל", "כוכב", "שביט"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("उल\u{94d}का"),
            keywords: &["उल\u{94d}का", "गिरता तारा", "ट\u{942}टता तारा", "तारा"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("zvijezda padalica"),
            keywords: &[
                "komet",
                "meteor",
                "padanje",
                "zvijezda",
                "zvijezda padalica",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("hullócsillag"),
            keywords: &["csillag", "csillaghullás", "hullócsillag", "ég"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ընկնող աստղ"),
            keywords: &["աստղ", "ընկնող", "տիեզերք"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("bintang jatuh"),
            keywords: &["angkasa", "bintang", "jatuh"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("Kpakpando na-ada ada"),
            keywords: &[
                "Kpakpando na-ada ada",
                "kpakpando",
                "na-ada àdà",
                "na-agba agba",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("stjörnuhrap"),
            keywords: &["stjarna", "stjörnuhrap", "óskastjarna"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("stella cadente"),
            keywords: &["cadente", "stella"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("流れ星"),
            keywords: &["スター", "星", "流れ星"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("lintang abuntut"),
            keywords: &["buntut", "lintang", "lintang abuntut", "tumiba"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ვარდნილი ვარსკვლავი"),
            keywords: &["ვარდნა", "ვარდნილი ვარსკვლავი", "ვარსკვლავი", "კოსმოსი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("ұшқан жұлдыз"),
            keywords: &["жұлдыз", "ғарыш", "құлау", "ұшу", "ұшқан жұлдыз"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("stjerneskud"),
            keywords: &["stjerne", "stjerneskud"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ផ\u{17d2}កាយហោះ"),
            keywords: &["តារា", "ផ\u{17d2}កាយ", "ផ\u{17d2}កាយហោះ", "ហោះ"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಬೀಳುತ\u{ccd}ತ\u{cbf}ರುವ ನಕ\u{ccd}ಷತ\u{ccd}ರ"),
            keywords: &[
                "ನಕ\u{ccd}ಷತ\u{ccd}ರ",
                "ಬೀಳುತ\u{ccd}ತ\u{cbf}ರುವ ನಕ\u{ccd}ಷತ\u{ccd}ರ",
                "ಬೀಳುವ",
                "ಶ\u{cc2}ಟ\u{cbf}ಂಗ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("별똥별"),
            keywords: &["낙성", "떨어지는 별", "별", "별똥별", "유성"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("पडपी नख\u{947}त\u{94d}र"),
            keywords: &["नख\u{947}त\u{94d}र", "पडपी", "श\u{941}टी\u{902}ग"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("учкан жылдыз"),
            keywords: &["жылдыз", "учкан жылдыз", "учту", "учуу"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Stäreschnäiz"),
            keywords: &["Stär", "Stäreschnäiz", "falend"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ດາວຕ\u{ebb}ກ"),
            keywords: &["ດາວ", "ດາວຕ\u{ebb}ກ", "ຕ\u{ebb}ກ", "ອາວະກາດ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("krintanti žvaigždė"),
            keywords: &["krintanti", "žvaigždė"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("krītoša zvaigzne"),
            keywords: &["krist", "krītoša zvaigzne", "zvaigzne"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("unahi o takero"),
            keywords: &["hinga ana", "unahi", "unahi o takero", "whetū"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("ѕвезда што паѓа"),
            keywords: &["паѓа", "ѕвезда", "ѕвезда што паѓа"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("വ\u{d3e}ൽനക\u{d4d}ഷത\u{d4d}രം"),
            keywords: &[
                "നക\u{d4d}ഷത\u{d4d}രം",
                "വ\u{d3e}ൽനക\u{d4d}ഷത\u{d4d}രം",
                "വീഴ\u{d41}ന\u{d4d}ന നക\u{d4d}ഷത\u{d4d}രം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("од харвах"),
            keywords: &["аз", "од", "харвах"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("पडणारा तारा"),
            keywords: &["तारा", "त\u{941}टण\u{947}", "पडणारा तारा", "पडण\u{947}"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("tahi bintang"),
            keywords: &["angkasa lepas", "bintang", "jatuh", "tahi bintang"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("stilla feġġa"),
            keywords: &["feġġa", "stilla", "taqa’"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ကြယ\u{103a}ကြ\u{103d}ေခြင\u{103a}း"),
            keywords: &[
                "ကြယ\u{103a}",
                "ကြယ\u{103a}ကြ\u{103d}ေခြင\u{103a}း",
                "ကြ\u{103d}ေကျခြင\u{103a}း",
                "ကြ\u{103d}ေခြင\u{103a}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("stjerneskudd"),
            keywords: &["fallende stjerne", "faller", "stjerne", "stjerneskudd"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("प\u{941}च\u{94d}छ\u{94d}र\u{947} तारा"),
            keywords: &[
                "आकाशग\u{902}गा",
                "झरिरह\u{947}को",
                "तारा",
                "प\u{941}च\u{94d}छ\u{94d}र\u{947} तारा",
                "श\u{942}टिङ\u{94d}ग",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("vallende ster"),
            keywords: &["ster", "vallen", "vallend", "vallende ster"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("stjerneskot"),
            keywords: &["fallande stjerne", "fell", "stjerne", "stjerneskot"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଉଲକ\u{b3e}"),
            keywords: &[
                "ଉଲକ\u{b3e}",
                "ଉଲକ\u{b3e}ତ\u{b3e}ର\u{b3e}",
                "ତ\u{b3e}ର\u{b3e}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਟ\u{a41}\u{a71}ਟਦਾ ਤਾਰਾ"),
            keywords: &[
                "ਟ\u{a41}\u{a71}ਟਣਾ",
                "ਟ\u{a41}\u{a71}ਟਦਾ ਤਾਰਾ",
                "ਡਿ\u{a71}ਗਣਾ",
                "ਤਾਰਾ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("شوٹنگ ستارہ"),
            keywords: &["تارہ", "شوٹنگ", "شوٹنگ ستارہ", "ڈ\u{650}گنا"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Shútín Sta"),
            keywords: &["Fọl", "Shut", "Shútín Sta", "Sta"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("spadająca gwiazda"),
            keywords: &["gwiazda", "kometa", "spadająca", "życzenie"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د ډزو ستوري"),
            keywords: &["د ډزو ستوري", "ستوری", "لوېدونکی", "ويشتونکی"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("estrela cadente"),
            keywords: &["cadente", "cai", "estrela"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["cadente", "espaço", "estrela"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("utqhay quyllur"),
            keywords: &["quyllur", "urmay", "utqhay"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("stea căzătoare"),
            keywords: &["cometă", "cădere", "meteor", "stea", "stea căzătoare"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-231"),
            keywords: &["E10-231"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("падающая звезда"),
            keywords: &["желание", "звезда", "небо", "падающая"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("kibonumwe"),
            keywords: &["gufata amafoto", "inyenyeri", "kibonumwe", "kugwa"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ٽٽندڙ تارو"),
            keywords: &["تارو", "ٽٽندڙ", "ڪرندي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("කඩ\u{dcf} වැටෙන තර\u{dd4}ව"),
            keywords: &[
                "අභ\u{dca}\u{200d}යවක\u{dcf}ශය",
                "කඩ\u{dcf} වැට\u{dd3}ම",
                "කඩ\u{dcf} වැටෙන තර\u{dd4}ව",
                "තර\u{dd4}ව",
                "වැට\u{dd3}ම",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("padajúca hviezda"),
            keywords: &["hviezda", "padajúca", "vesmír"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("utrinek"),
            keywords: &["padanje", "repatica", "utrinek", "vesolje", "zvezda"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("waran cireed"),
            keywords: &["soo dhacaya", "toogasho", "waran cireed", "xiddig"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("yll që bie"),
            keywords: &["hapësirë", "që bie", "që këputet", "yll", "yll që bie"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("звезда падалица"),
            keywords: &["звeздa", "звезда падалица", "пaдaњe", "свeмир"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("звијезда падалица"),
            keywords: &["звијезда падалица"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("zvezda padalica"),
            keywords: &["padanje", "svemir", "zvezda", "zvezda padalica"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("zvijezda padalica"),
            keywords: &["zvijezda padalica"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("stjärnfall"),
            keywords: &["fallande stjärna", "stjärnfall"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kimwondo"),
            keywords: &["anga", "kaunguka", "kimwondo", "nyota"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["anga", "kimwondo", "kuanguka", "nyota"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("எரிநட\u{bcd}சத\u{bcd}திரம\u{bcd}"),
            keywords: &[
                "இரவு",
                "எரிநட\u{bcd}சத\u{bcd}திரம\u{bcd}",
                "நட\u{bcd}சத\u{bcd}திரம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ఉల\u{c4d}క న\u{c47}ల ర\u{c3e}లడం"),
            keywords: &[
                "ఉల\u{c4d}క",
                "ఉల\u{c4d}క న\u{c47}ల ర\u{c3e}లడం",
                "న\u{c47}ల",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("ситораи думдор"),
            keywords: &["афтидан", "парондан", "ситора", "ситораи думдор"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ดาวตก"),
            keywords: &["ดาว", "ดาวตก"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("süýnýän ýyldyz"),
            keywords: &["düşýän", "süýnýän", "ýyldyz"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("fetuʻu ʻesiafi"),
            keywords: &["fetuʻu ʻesiafi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("yıldız kayması"),
            keywords: &["kayan", "yıldız", "yıldız kayması"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئاقار يۇلتۇز"),
            keywords: &["ئاتار", "ئاقار يۇلتۇز", "يۇلتۇز", "چۈشەر"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("метеор"),
            keywords: &["зірка", "космос", "метеор", "небо", "падає"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("شہاب\u{650} ثاقب"),
            keywords: &["ستارہ", "شہاب\u{650} ثاقب", "گرتا"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("uchayotgan yulduz"),
            keywords: &["koinot", "osmon", "uchayotgan", "yulduz"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("sao băng"),
            keywords: &["ngôi sao", "phóng", "rơi", "sao băng"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("biddeew buy daw"),
            keywords: &["biddeew", "biddeew buy daw", "daanu", "dóor"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("inkwenkwezi edubulayo"),
            keywords: &["ewayo", "inkwenkwezi", "inkwenkwezi edubulayo", "udubulayo"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Irawọ Yiyọ"),
            keywords: &["Irawọ Yiyọ", "jíjábọ\u{301}", "títa", "ìràwọ\u{300}"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("流星"),
            keywords: &["墜落", "射擊", "星星", "流星"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("流星"),
            keywords: &["坠落", "射击", "星星", "流星"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("流星"),
            keywords: &["流星"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("流星"),
            keywords: &["星星", "流星"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("inkanyezi edubulayo"),
            keywords: &[
                "inkanyezi",
                "inkanyezi edubulayo",
                "ukudubula",
                "ukuwa",
                "umkhathi",
            ],
        },
    ],
};
#[doc = "🌌"]
pub const MILKY_WAY: crate::Emoji = crate::Emoji {
    glyph: "🌌",
    codepoint: "1F30C",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "milky way",
    group: "Travel & Places",
    subgroup: "sky & weather",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("melkweg"),
            keywords: &["melkweg", "ruimte", "sterre"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ፍኖተ ሐሊብ"),
            keywords: &["ህዋ", "የአየር ንብረት", "ፍኖተ ሐሊብ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("درب التبانة"),
            keywords: &["درب التبانة", "مجرة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("আক\u{9be}শীগঙ\u{9cd}গ\u{9be}"),
            keywords: &["আক\u{9be}শীগঙ\u{9cd}গ\u{9be}", "মহ\u{9be}ক\u{9be}শ"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("süd yolu"),
            keywords: &["hava", "kosmos", "süd yolu"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("млечны шлях"),
            keywords: &["космас", "млечны шлях", "надвор’е", "ноч"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Млечният път"),
            keywords: &["Млечният път", "време", "космос"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("আক\u{9be}শগঙ\u{9cd}গ\u{9be}"),
            keywords: &[
                "আক\u{9be}শগঙ\u{9cd}গ\u{9be}",
                "আবহ\u{9be}ওয\u{9bc}\u{9be}",
                "মহ\u{9be}ক\u{9be}শ",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("Hent-sant-Jakez"),
            keywords: &["Hent-sant-Jakez", "egor"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("mliječni put"),
            keywords: &["mliječni put", "svemir", "vrijeme"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("Via Làctia"),
            keywords: &["Via Làctia", "espai", "temps"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏃᏈᏏ ᏂᏚᏍᏗᏓᏅ"),
            keywords: &["ᎤᏟᏅᏛᎢ", "ᏃᏈᏏ ᏂᏚᏍᏗᏓᏅ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("mléčná dráha"),
            keywords: &["mléčná dráha", "vesmír"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("y llwybr llaethog"),
            keywords: &["gofod", "tywydd", "y llwybr llaethog"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("mælkevejen"),
            keywords: &["galakse", "mælkevejen"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Milchstraße"),
            keywords: &["Galaxie", "Milchstraße"],
        },
        #[cfg(feature = "de_CH")]
        crate::Annotation {
            lang: "de_CH",
            tts: Some("Milchstrasse"),
            keywords: &["Galaxie", "Milchstrasse"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("γαλαξίας"),
            keywords: &["γαλαξίας", "διάστημα"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("milky way"),
            keywords: &["milky way", "space"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: None,
            keywords: &["galaxy", "milky way", "space"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("Milky Way"),
            keywords: &["Milky Way", "space"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("Milky Way"),
            keywords: &["Milky", "Way", "space"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("Vía Láctea"),
            keywords: &["Vía Láctea", "espacio", "galaxia", "vía láctea"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &[
                "Vía Láctea",
                "cielo",
                "estrellas",
                "galaxia",
                "láctea",
                "vía",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("Linnutee"),
            keywords: &["Linnutee", "kosmos", "tähed"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("esne-bidea"),
            keywords: &["eguraldi", "esne-bidea", "espazio"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("راه شیری"),
            keywords: &["آسمان", "راه شیری", "سپهر", "فضا"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("linnunrata"),
            keywords: &["avaruus", "galaksi", "linnunrata", "sää"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("milky way"),
            keywords: &["bituin", "galaxy", "kalawakan", "milky way"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("vetrarbreytin"),
            keywords: &["mjólkarvegur", "rúmdin", "stjørnubreyt", "vetrarbreytin"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("voie lactée"),
            keywords: &["espace", "voie lactée"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["Voie lactée", "espace", "voie lactée"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("Bealach na Bó Finne"),
            keywords: &["Bealach na Bó Finne", "Claí Mór na Réaltaí", "an Láir Bhán"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("Slighe Chlann Uisnich"),
            keywords: &["Slighe Chlann Uisnich", "fànas", "speur"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("Vía Láctea"),
            keywords: &["Vía Láctea", "espazo", "vía láctea"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("આકાશગ\u{a82}ગા"),
            keywords: &["આકાશગ\u{a82}ગા", "દ\u{ac2}ધિય\u{ac1}\u{a82}"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("milky way"),
            keywords: &["milky way", "sarari"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("שביל החלב"),
            keywords: &["חלל", "כוכבים", "שביל החלב", "שמיים"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("आकाशग\u{902}गा"),
            keywords: &["आकाशग\u{902}गा", "द\u{942}धिया"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("Mliječna staza"),
            keywords: &["Kumova slama", "Mliječna staza", "Mliječni put", "svemir"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("tejút"),
            keywords: &["csillagrendszer", "tejút", "világűr", "űr"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ծիր կաթին"),
            keywords: &["եղանակ", "ծիր կաթին", "տիեզերք"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("bima sakti"),
            keywords: &["bima sakti", "cuaca", "ruang"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ụzọ igwe kpakpando"),
            keywords: &["oghere", "ụzọ igwe kpakpando"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("vetrarbrautin"),
            keywords: &["geimurinn", "vetrarbrautin"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("Via Lattea"),
            keywords: &["Via Lattea", "lattea"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("天の川"),
            keywords: &["夜空", "天の川", "星空", "銀河"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("bima sekti"),
            keywords: &["antariksa", "bima sekti"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ირმის ნახტომი"),
            keywords: &["ამინდი", "ირმის ნახტომი", "კოსმოსი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("Құс жолы"),
            keywords: &["ауа райы", "ғарыш", "Құс жолы"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("mælkevejen"),
            keywords: &["galakse", "mælkevejen"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ល\u{17c6}ហរចក\u{17d2}រវាឡ"),
            keywords: &["មេឃ", "ល\u{17c6}ហរ", "ល\u{17c6}ហរចក\u{17d2}រវាឡ", "អកាស"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕ\u{ccd}ಷೀರ ಪಥ"),
            keywords: &[
                "ಆಕಾಶ",
                "ಕ\u{ccd}ಷೀರ ಪಥ",
                "ಕ\u{ccd}ಷೀರಪಥ",
                "ಮ\u{cbf}ಲ\u{ccd}ಕ\u{cbf} ವೇ",
                "ಹಾಲುಹಾದ\u{cbf}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("은하수"),
            keywords: &["우주", "은하", "은하수", "행성"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("द\u{942}द ग\u{902}गा"),
            keywords: &["अ\u{902}तराळ", "द\u{942}द ग\u{902}गा"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("саманчынын жолу"),
            keywords: &["аба ырайы", "космос", "саманчынын жолу"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Mëllechstrooss"),
            keywords: &["Mëllechstrooss", "Weltall"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ທາງຊ\u{ec9}າງເຜ\u{eb7}ອກ"),
            keywords: &["ດາລາສາດ", "ທາງຊ\u{ec9}າງເຜ\u{eb7}ອກ", "ອາວະກາດ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("paukščių takas"),
            keywords: &["kosmosas", "paukščių takas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("Piena ceļš"),
            keywords: &["Piena ceļš", "debesis", "kosmoss", "visums"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("ikarangi"),
            keywords: &["ikarangi", "ātea"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("млечниот пат"),
            keywords: &["време", "вселена", "млечниот пат"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ആക\u{d3e}ശഗംഗ"),
            keywords: &["ആക\u{d3e}ശഗംഗ", "മിൽക\u{d4d}കി വേ"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("сүүн зам"),
            keywords: &["сансар", "сүүн зам"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("आकाशग\u{902}गा"),
            keywords: &["अ\u{902}तराळ", "आकाशग\u{902}गा"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("bima sakti"),
            keywords: &["angkasa lepas", "bima sakti", "cuaca"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("triq ta’ Sant’Anna"),
            keywords: &["spazju", "triq ta’ Sant’Anna"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("နဂါးင\u{103d}ေ\u{1037}တန\u{103a}း"),
            keywords: &["နဂါးင\u{103d}ေ\u{1037}တန\u{103a}း", "အာကာသ"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("melkeveien"),
            keywords: &["galakse", "melkeveien", "verdensrommet"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("आकाशग\u{902}गा"),
            keywords: &["आकाशग\u{902}गा", "मौसम"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("melkweg"),
            keywords: &["melkweg", "ruimte"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("mjølkevegen"),
            keywords: &["galakse", "mjølkevegen", "verdsrommet"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଆକ\u{b3e}ଶଗଙ\u{b4d}ଗ\u{b3e}"),
            keywords: &["ଆକ\u{b3e}ଶଗଙ\u{b4d}ଗ\u{b3e}", "ଛ\u{b3e}ୟ\u{b3e}ପଥ"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਆਕਾਸ\u{a3c}ਗ\u{a70}ਗਾ"),
            keywords: &["ਆਕਾਸ\u{a3c}ਗ\u{a70}ਗਾ", "ਪ\u{a41}ਲਾੜ", "ਮ\u{a4c}ਸਮ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("کہکشاں"),
            keywords: &["جگہ", "کہکشاں"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Mílkí Wè"),
            keywords: &["Mílkí Wè", "Spes"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("Droga Mleczna"),
            keywords: &["Droga Mleczna", "droga mleczna", "gwiazdy", "niebo", "noc"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("کهکشان"),
            keywords: &["ځای", "کهکشان"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("via láctea"),
            keywords: &["céu", "estrelado", "via láctea"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("via láctea"),
            keywords: &["espaço", "via láctea"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("via lactea"),
            keywords: &["kampu", "via lactea"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("Calea Lactee"),
            keywords: &["Calea Lactee", "constelație", "stele"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-211"),
            keywords: &["E10-211"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("Млечный Путь"),
            keywords: &["Млечный Путь", "космос", "молоко", "путь"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("inzira nyamata"),
            keywords: &["inzira nyamata", "umwanya"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڪهڪشان"),
            keywords: &["خلا", "ڪهڪشان"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ක\u{dca}ෂ\u{dd3}ර පථය"),
            keywords: &[
                "අභ\u{dca}\u{200d}යවක\u{dcf}ශය",
                "ක\u{dca}ෂ\u{dd3}ර පථය",
                "ක\u{dcf}ලග\u{dd4}ණය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("mliečna dráha"),
            keywords: &["mliečna dráha", "počasie", "vesmír"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("rimska cesta"),
            keywords: &["rimska cesta", "vesolje", "vreme"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("habarjiid"),
            keywords: &["dululaati", "habarjiid"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("rruga e qumështit"),
            keywords: &["hapësirë", "moti", "rruga e qumështit"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("млечни пут"),
            keywords: &["млечни пут", "свeмир"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("млијечни пут"),
            keywords: &["млијечни пут"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("mlečni put"),
            keywords: &["mlečni put", "svemir"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("mliječni put"),
            keywords: &["mliječni put"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("Vintergatan"),
            keywords: &["Vintergatan", "galax", "rymden", "vintergatan"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kilimia"),
            keywords: &["anga", "hali ya jwa", "kilimia"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["anga", "hali ya jewa", "kilimia"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பிரபஞ\u{bcd}சம\u{bcd}"),
            keywords: &["இரவு", "பிரபஞ\u{bcd}சம\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ప\u{c3e}లపుంత"),
            keywords: &[
                "ఆక\u{c3e}శం",
                "నక\u{c4d}షత\u{c4d}రవ\u{c40}ధ\u{c3f}",
                "ప\u{c3e}లపుంత",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("роҳи Каҳкашон"),
            keywords: &["роҳи Каҳкашон", "фазо"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ทางช\u{e49}างเผ\u{e37}อก"),
            keywords: &["ดาราจ\u{e31}กร", "ทางช\u{e49}างเผ\u{e37}อก", "อวกาศ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("Akmaýanyň ýoly"),
            keywords: &["Akmaýanyň ýoly", "asman"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("kaniva"),
            keywords: &["kaniva"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("samanyolu"),
            keywords: &["gökyüzü", "samanyolu", "uzay"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("سامان يولى"),
            keywords: &["بوشلۇق", "سامان يولى"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("Чумацький шлях"),
            keywords: &["Чумацький шлях", "космос", "погода"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("کہکشاں"),
            keywords: &["خلا", "کہکشاں"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("somon yo‘li"),
            keywords: &["koinot", "ob-havo", "somon yo‘li"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("dải ngân hà"),
            keywords: &["dải ngân hà", "vũ trụ"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("asamaan aki biddéew"),
            keywords: &["asamaan aki biddéew", "espaas"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("umnyele wezulu"),
            keywords: &["isithuba", "umnyele wezulu"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ọna Oniwara"),
            keywords: &["ààyè", "Ọna Oniwara"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("銀河"),
            keywords: &["太空", "銀河"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("银河"),
            keywords: &["太空", "银河"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("银河"),
            keywords: &["星空", "银河"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("銀河"),
            keywords: &["星空", "銀河"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("imilkhi weyi"),
            keywords: &["imilkhi weyi", "isimo sezulu", "umkhathi"],
        },
    ],
};
#[doc = "☁\u{fe0f}"]
pub const CLOUD: crate::Emoji = crate::Emoji {
    glyph: "☁\u{fe0f}",
    codepoint: "2601 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "cloud",
    group: "Travel & Places",
    subgroup: "sky & weather",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "☁",
        codepoint: "2601",
        status: crate::Status::Unqualified,
        introduction_version: 0.6f32,
        name: "cloud",
        group: "Travel & Places",
        subgroup: "sky & weather",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("wolk"),
            keywords: &["weer", "wolk"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ደመና"),
            keywords: &["የአየር ንብረት", "ደመና"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("سحابة"),
            keywords: &["سحابة", "طقس"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ড\u{9be}ৱৰ"),
            keywords: &["ড\u{9be}ৱৰ", "বতৰ"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("bulud"),
            keywords: &["bulud", "hava"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("воблака"),
            keywords: &["воблака", "надвор’е", "неба", "пахмурна"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("облак"),
            keywords: &["време", "облак"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("মেঘ"),
            keywords: &["আবহ\u{9be}ওয\u{9bc}\u{9be}", "মেঘ"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("koumoulenn"),
            keywords: &["amzer", "koumoulenn"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("oblačno"),
            keywords: &["oblaci", "oblačno", "prognoza", "vrijeme"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("núvol"),
            keywords: &["núvol", "temps"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᎶᎩᎳ"),
            keywords: &["ᎤᎶᎩᎳ", "ᏙᏱᏗᏜ ᏂᎦᎵᏍᏔᏅᏍᎬᎢ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("mrak"),
            keywords: &["mrak", "oblak", "počasí"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("cwmwl"),
            keywords: &["cwmwl", "tywydd"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("sky"),
            keywords: &["sky", "vejr"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Wolke"),
            keywords: &["Wetter", "Wolke", "wolkig"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("σύννεφο"),
            keywords: &["καιρός", "σύννεφο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("cloud"),
            keywords: &["cloud", "weather"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("nube"),
            keywords: &["nube", "tiempo"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["nube", "nublado", "tiempo"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["clima", "nube", "nublado"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("pilv"),
            keywords: &["ilm", "pilv"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("hodei"),
            keywords: &["eguraldi", "hodei"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("ابر"),
            keywords: &["آب\u{200c}وهوا", "ابر"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("pilvi"),
            keywords: &["pilvi", "sää"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("ulap"),
            keywords: &["lagay ng panahon", "panahon", "ulap"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("skýggj"),
            keywords: &["skýggj", "veðrið", "veður", "yvirskýggja"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("nuage"),
            keywords: &["météo", "nuage"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("scamall"),
            keywords: &["aimsir", "scamall"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("neul"),
            keywords: &["aimsir", "neul", "sìde"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("nube"),
            keywords: &["meteoroloxía", "nube"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("વાદળ"),
            keywords: &["વાદળ", "હવામાન"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("gajimare"),
            keywords: &["gajimare", "yanayi"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("ענן"),
            keywords: &["מזג אוויר", "ענן"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("बादल"),
            keywords: &["बादल", "मौसम"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("oblak"),
            keywords: &["oblak", "vrijeme"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("felhő"),
            keywords: &["felhő", "időjárás"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ամպ"),
            keywords: &["ամպ", "եղանակ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("awan"),
            keywords: &["awan", "cuaca"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("urukpu"),
            keywords: &["urukpu", "ọnọdụ ihu eluigwe"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("ský"),
            keywords: &["ský", "skýjað", "svart ský"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("nuvola"),
            keywords: &["meteo", "nuvola"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("雲"),
            keywords: &["天気", "曇り", "雲"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("mega mendhung"),
            keywords: &["cuaca", "mega mendhung", "mendhung"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ღრუბელი"),
            keywords: &["ამინდი", "ღრუბელი"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("asigna"),
            keywords: &["asigna"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("бұлт"),
            keywords: &["ауа райы", "бұлт"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("sky"),
            keywords: &["sky", "vejr"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ពពក"),
            keywords: &["ពពក", "អាកាសធាត\u{17bb}"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಮೇಘ"),
            keywords: &["ಮೇಘ", "ಮೋಡ", "ವಾತಾವರಣ", "ಹವಾಮಾನ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("구름"),
            keywords: &["구름", "흐림"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("ढग"),
            keywords: &["ढग", "हवामान"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("булут"),
            keywords: &["аба ырайы", "булут"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Wollek"),
            keywords: &["Wieder", "Wollek"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເມກ"),
            keywords: &["ສະພາບອາກາດ", "ເມກ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("debesis"),
            keywords: &["debesis", "oras"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("mākonis"),
            keywords: &["laikapstākļi", "laiks", "mākonis"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kapua"),
            keywords: &["huarere", "kapua"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("облак"),
            keywords: &["време", "облак"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("മേഘം"),
            keywords: &["ക\u{d3e}ല\u{d3e}വസ\u{d4d}ഥ", "മേഘം"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("үүл"),
            keywords: &["цаг агаар", "үүл"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("ढग"),
            keywords: &["ढग", "हवामान"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("awan"),
            keywords: &["awan", "cuaca"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("sħaba"),
            keywords: &["sħaba", "temp"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("တ\u{102d}မ\u{103a}"),
            keywords: &["တ\u{102d}မ\u{103a}", "မ\u{102d}\u{102f}းလေဝသ"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("sky"),
            keywords: &["sky", "vær"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("बादल"),
            keywords: &["बादल", "मौसम"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("wolk"),
            keywords: &["weer", "wolk"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("sky"),
            keywords: &["sky", "vêr"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ମେଘ"),
            keywords: &["ପ\u{b3e}ଣ\u{b3f}ପ\u{b3e}ଗ", "ମେଘ"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਬ\u{a71}ਦਲ"),
            keywords: &["ਬ\u{a71}ਦਲ", "ਮ\u{a4c}ਸਮ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("بدل"),
            keywords: &["بدل", "موسم"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Klaud"),
            keywords: &["Klaud", "Wẹ\u{301}da"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("chmura"),
            keywords: &["chmura", "pogoda"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("وريځ"),
            keywords: &["موسم", "وريځ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("nuvem"),
            keywords: &["clima", "nuvem"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["meteorologia", "nuvem", "tempo"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("puyu"),
            keywords: &["llaphiya", "puyu"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("nor"),
            keywords: &["meteo", "nor", "vreme", "înnorat"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-042"),
            keywords: &["E10-042"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("облако"),
            keywords: &["небо", "облако", "туча"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("karawudi"),
            keywords: &["imiterere y’ibihe", "karawudi"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڪڪر"),
            keywords: &["موسم", "ڪڪر"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("වල\u{dcf}ක\u{dd4}ළ"),
            keywords: &["ක\u{dcf}ලග\u{dd4}ණය", "වල\u{dcf}ක\u{dd4}ළ"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("oblak"),
            keywords: &["oblak", "počasie"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("oblak"),
            keywords: &["oblak", "vreme"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("daruur"),
            keywords: &["cimilo", "daruur"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("re"),
            keywords: &["moti", "re"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("облак"),
            keywords: &["време", "облак"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["облак"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("oblak"),
            keywords: &["oblak", "vreme"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["oblak"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("moln"),
            keywords: &["moln", "väder"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("wingu"),
            keywords: &["hali ya hewa", "wingu"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("மேகம\u{bcd}"),
            keywords: &[
                "மேகமூட\u{bcd}டம\u{bcd}",
                "மேகம\u{bcd}",
                "வ\u{bbe}னிலை",
                "வெப\u{bcd}பநிலை",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("మ\u{c47}ఘం"),
            keywords: &["మ\u{c47}ఘం", "వ\u{c3e}త\u{c3e}వరణం"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("абр"),
            keywords: &["абр", "обу ҳаво"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เมฆ"),
            keywords: &["สภาพอากาศ", "เมฆ", "เมฆดำ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("bulut"),
            keywords: &["bulut", "howa"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("ʻao"),
            keywords: &["ʻao"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("bulut"),
            keywords: &["bulut", "hava durumu"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("بۇلۇت"),
            keywords: &["بۇلۇت", "ھاۋارايى"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("хмара"),
            keywords: &["погода", "хмара"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("بادل"),
            keywords: &["بادل", "موسم"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("bulut"),
            keywords: &["bulut", "ob-havo"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("đám mây"),
            keywords: &["thời tiết", "đám mây"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("niir"),
            keywords: &["klimaa", "niir"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ilifu"),
            keywords: &["ilifu", "imozulu"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("òfurufú"),
            keywords: &["ojú ọjọ\u{301}", "òfurufú"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("雲"),
            keywords: &["天氣", "雲"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("云"),
            keywords: &["云", "天气"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("云"),
            keywords: &["云", "阴"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("雲"),
            keywords: &["天氣", "雲"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ifu"),
            keywords: &["ifu", "isimo sezulu"],
        },
    ],
};
#[doc = "⛅"]
pub const SUN_BEHIND_CLOUD: crate::Emoji = crate::Emoji {
    glyph: "⛅",
    codepoint: "26C5",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "sun behind cloud",
    group: "Travel & Places",
    subgroup: "sky & weather",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("son agter wolk"),
            keywords: &["son", "son agter wolk", "weer", "wolk"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ከደመና ጀርባ ያለች ፀሐይ"),
            keywords: &["ከደመና ጀርባ ያለች ፀሐይ", "የአየር ንብረት", "ደመና", "ፀሐይ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("شمس خلف السحب"),
            keywords: &["سحابة", "شمس", "شمس خلف السحب", "شمس مع سحب"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ড\u{9be}ৱৰৰ পিছফ\u{9be}লে স\u{9c2}ৰ\u{9cd}য\u{9cd}য"),
            keywords: &[
                "ড\u{9be}ৱৰ",
                "ড\u{9be}ৱৰৰ পিছফ\u{9be}লে স\u{9c2}ৰ\u{9cd}য\u{9cd}য",
                "স\u{9c2}ৰ\u{9cd}য\u{9cd}য",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("buludun arxasında günəş"),
            keywords: &["bulud", "buludun arxasında günəş", "günəş", "hava"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("сонца за воблакам"),
            keywords: &["воблака", "надвор’е", "неба", "сонца", "сонца за воблакам"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Слънце зад облак"),
            keywords: &["Слънце зад облак", "време", "облак", "слънце"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("মেঘের পিছনে স\u{9c2}র\u{9cd}য"),
            keywords: &[
                "আবহ\u{9be}ওয\u{9bc}\u{9be}",
                "মেঘ",
                "মেঘের পিছনে স\u{9c2}র\u{9cd}য",
                "স\u{9c2}র\u{9cd}য",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("heol a-dreñv dʼar cʼhoumoul"),
            keywords: &["heol", "heol a-dreñv dʼar cʼhoumoul", "koumoul"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("umjereno oblačno"),
            keywords: &["oblaci", "prognoza", "sunce", "umjereno oblačno", "vrijeme"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("sol darrere un núvol"),
            keywords: &["núvol", "sol", "sol darrere un núvol", "temps"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏅᏓ ᎣᏂᏗᏜ ᏄᏛᎾ ᎤᎶᎩᎸᎢ"),
            keywords: &["ᎤᎶᎩᎳ", "ᏅᏓ", "ᏅᏓ ᎣᏂᏗᏜ ᏄᏛᎾ ᎤᎶᎩᎸᎢ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("slunce za mrakem"),
            keywords: &["mrak", "oblak", "počasí", "slunce", "slunce za mrakem"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("haul tu ôl i gwmwl"),
            keywords: &["cwmwl", "haul", "haul tu ôl i gwmwl", "tywydd"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("sol bag sky"),
            keywords: &["sky", "sol", "sol bag sky"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Sonne hinter Wolke"),
            keywords: &["Sonne", "Sonne hinter Wolke", "Wolke", "wolkig"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ήλιος πίσω από σύννεφο"),
            keywords: &["ήλιος", "ήλιος πίσω από σύννεφο", "καιρός", "σύννεφο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("sun behind cloud"),
            keywords: &["cloud", "sun", "sun behind cloud"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("sol detrás de una nube"),
            keywords: &["nube", "sol", "sol con nubes", "sol detrás de una nube"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("parcialmente nublado"),
            keywords: &[
                "nubes",
                "nublado",
                "parcialmente nublado",
                "sol",
                "soleado",
                "tiempo",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["nubes", "nublado", "parcialmente nublado", "sol", "tiempo"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["nube", "parcialmente nublado", "sol"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("päike pilve taga"),
            keywords: &["ilm", "pilv", "päike", "päike pilve taga"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("eguzkia hodei baten atzean"),
            keywords: &["eguraldi", "eguzki", "eguzkia hodei baten atzean", "hodei"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("خورشید پشت ابر"),
            keywords: &["آب\u{200c}وهوا", "ابر", "خورشید", "خورشید پشت ابر"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("aurinko pilvessä"),
            keywords: &["aurinko", "aurinko pilvessä", "pilvi", "sää"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("araw sa likod ng ulap"),
            keywords: &[
                "araw",
                "araw sa likod ng ulap",
                "lagay ng panahon",
                "panahon",
                "ulap",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("sólin aftanfyri skyggj"),
            keywords: &[
                "sól",
                "sólarglottar",
                "sólglottur",
                "sólin aftanfyri skyggj",
                "veðrið",
                "veður",
                "yvirskýggja",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("soleil derrière les nuages"),
            keywords: &["nuageux", "soleil", "soleil derrière les nuages"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("soleil derrière un nuage"),
            keywords: &["nuage", "nuageux", "soleil", "soleil derrière un nuage"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("grian taobh thiar de na scamaill"),
            keywords: &[
                "grian",
                "grian agus scamaill",
                "grian taobh thiar de na scamaill",
                "scamall",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("a’ ghrian air cùl sgòtha"),
            keywords: &["a’ ghrian air cùl sgòtha", "grian", "neul", "sgòth"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("ceo parcialmente cuberto"),
            keywords: &[
                "anubrado",
                "ceo parcialmente cuberto",
                "meteoroloxía",
                "nubrado",
                "sol",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("વાદળ પાછળનો સ\u{ac2}ર\u{acd}ય"),
            keywords: &[
                "વાદળ",
                "વાદળ પાછળનો સ\u{ac2}ર\u{acd}ય",
                "વાદળો સાથ\u{ac7} સ\u{ac2}ર\u{acd}ય",
                "સ\u{ac2}ર\u{acd}ય",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("rana a bayan gajimare"),
            keywords: &["gajimare", "rana", "rana a bayan gajimare"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("שמש מאחורי ענן"),
            keywords: &["מעונן", "ענן", "שמש", "שמש מאחורי ענן"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("बादलो\u{902} क\u{947} पीछ\u{947} स\u{942}र\u{94d}य"),
            keywords: &[
                "बादल",
                "बादलो\u{902} क\u{947} पीछ\u{947} स\u{942}र\u{94d}य",
                "बादलो\u{902} वाला स\u{942}र\u{94d}य",
                "स\u{942}रज",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("sunce iza oblaka"),
            keywords: &["oblak", "sunce", "sunce iza oblaka", "vrijeme"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("nap egy felhő mögött"),
            keywords: &["felhő", "időjárás", "nap", "nap egy felhő mögött"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("արև ամպի հետևում"),
            keywords: &["ամպ", "արև", "արև ամպի հետևում", "եղանակ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("matahari di balik awan"),
            keywords: &["awan", "cuaca", "matahari", "matahari di balik awan"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("anyanwụ n’àzụ urukpu"),
            keywords: &["anyanwụ", "anyanwụ n’àzụ urukpu", "urukpu"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("sól bakvið ský"),
            keywords: &["ský", "sól", "sól bakvið ský", "sól og ský"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("sole coperto"),
            keywords: &["nuvola", "sole", "sole con nuvole", "sole coperto"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("曇り時々晴れ"),
            keywords: &["天気", "太陽", "曇り", "曇り時々晴れ", "雲"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("srengenge saburine mega"),
            keywords: &["mega", "srengenge", "srengenge saburine mega"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მზე ღრუბლის უკან"),
            keywords: &["ამინდი", "მზე", "მზე ღრუბლის უკან", "ღრუბელი"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: None,
            keywords: &["asigna", "iṭij"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("бұлттың артындағы күн"),
            keywords: &["ауа райы", "бұлт", "бұлттың артындағы күн", "күн"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("sol bag sky"),
            keywords: &["sky", "sol", "sol bag sky"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ពពកបា\u{17c6}ងព\u{17d2}រះអាទ\u{17b7}ត\u{17d2}យ"),
            keywords: &[
                "បា\u{17c6}ង",
                "ពពក",
                "ពពកបា\u{17c6}ងព\u{17d2}រះអាទ\u{17b7}ត\u{17d2}យ",
                "ព\u{17d2}រះអាទ\u{17b7}ត\u{17d2}យ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಮೇಘದ\u{cbf}ಂದ ಮರ\u{cc6}ಯಾಗ\u{cbf}ರುವ ಸ\u{cc2}ರ\u{ccd}ಯ"),
            keywords: &[
                "ಮೇಘದ\u{cbf}ಂದ ಮರ\u{cc6}ಯಾಗ\u{cbf}ರುವ ಸ\u{cc2}ರ\u{ccd}ಯ",
                "ಮೋಡ",
                "ಮೋಡಗಳೊಂದ\u{cbf}ಗ\u{cc6} ಸ\u{cc2}ರ\u{ccd}ಯ",
                "ಸ\u{cc2}ರ\u{ccd}ಯ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("구름 뒤의 해"),
            keywords: &["구름", "구름 뒤의 해", "구름에 가린 해", "해"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("ढगा आडचो स\u{941}र\u{94d}य"),
            keywords: &["ढग", "ढगा आडचो स\u{941}र\u{94d}य", "स\u{941}र\u{94d}य"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("булуттун артындагы күн"),
            keywords: &["аба ырайы", "булут", "булуттун артындагы күн", "күн"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Sonn hannert Wolleken"),
            keywords: &["Sonn", "Sonn hannert Wolleken", "Wollek"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຕາເວ\u{eb1}ນຢ\u{eb9}\u{ec8}ຫ\u{ebc}\u{eb1}ງເມກ"),
            keywords: &[
                "ຕາເວ\u{eb1}ນ",
                "ຕາເວ\u{eb1}ນຢ\u{eb9}\u{ec8}ຫ\u{ebc}\u{eb1}ງເມກ",
                "ສະພາບອາກາດ",
                "ເມກ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("saulė už debesų"),
            keywords: &["debesis", "saulė", "saulė už debesų"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("saule aiz mākoņa"),
            keywords: &[
                "laikapstākļi",
                "laiks",
                "mākonis",
                "saule",
                "saule aiz mākoņa",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("rā muri kapua"),
            keywords: &["kapua", "rā", "rā muri kapua"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("сонце зад облак"),
            keywords: &["време", "облак", "сонце", "сонце зад облак"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("മേഘങ\u{d4d}ങൾക\u{d4d}ക\u{d4d} പിന\u{d4d}നിലെ സ\u{d42}ര\u{d4d}യൻ"),
            keywords: &[
                "മേഘം",
                "മേഘങ\u{d4d}ങൾക\u{d4d}ക\u{d4d} പിന\u{d4d}നിലെ സ\u{d42}ര\u{d4d}യൻ",
                "സ\u{d42}ര\u{d4d}യൻ",
                "സ\u{d42}ര\u{d4d}യൻ മേഘ\u{d3e}വ\u{d43}തം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("үүлний цаагуурх нар"),
            keywords: &["нар", "үүл", "үүлний цаагуурх нар"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("ढगा\u{902}मागील स\u{942}र\u{94d}य"),
            keywords: &[
                "ढग",
                "ढगा\u{902}मागील स\u{942}र\u{94d}य",
                "स\u{942}र\u{94d}य",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("matahari di sebalik awan"),
            keywords: &["awan", "cuaca", "matahari", "matahari di sebalik awan"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("xemx wara sħaba"),
            keywords: &["sħaba", "xemx", "xemx wara sħaba"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("တ\u{102d}မ\u{103a}နောက\u{103a}ရ\u{103e}\u{102d} နေ"),
            keywords: &[
                "တ\u{102d}မ\u{103a}",
                "တ\u{102d}မ\u{103a}နောက\u{103a}ရ\u{103e}\u{102d} နေ",
                "နေ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("sol bak sky"),
            keywords: &["sky", "sol", "sol bak sky", "sol og sky"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("बादलपछाडिको स\u{942}र\u{94d}य"),
            keywords: &[
                "बादल",
                "बादलपछाडिको स\u{942}र\u{94d}य",
                "मौसम",
                "स\u{942}र\u{94d}य",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("zon achter wolk"),
            keywords: &["wolk", "zon", "zon achter wolk"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("sol bak sky"),
            keywords: &["sky", "sol", "sol bak sky", "sol og sky"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ମେଘ ପଛରେ ସ\u{b42}ର\u{b4d}ଯ\u{b4d}ୟ"),
            keywords: &[
                "ମେଘ",
                "ମେଘ ପଛରେ ସ\u{b42}ର\u{b4d}ଯ\u{b4d}ୟ",
                "ସ\u{b42}ର\u{b4d}ଯ\u{b4d}ୟ",
                "ସ\u{b42}ର\u{b4d}ଯ\u{b4d}ୟ ସହ\u{b3f}ତ ମେଘ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਬ\u{a71}ਦਲਾ\u{a02}\u{a02} ਪਿ\u{a71}ਛ\u{a47} ਸ\u{a42}ਰਜ"),
            keywords: &[
                "ਬ\u{a71}ਦਲ",
                "ਬ\u{a71}ਦਲਾ\u{a02} ਨਾਲ ਸ\u{a42}ਰਜ",
                "ਬ\u{a71}ਦਲਾ\u{a02} ਪਿ\u{a71}ਛ\u{a47} ਸ\u{a42}ਰਜ",
                "ਬ\u{a71}ਦਲਾ\u{a02}\u{a02} ਪਿ\u{a71}ਛ\u{a47} ਸ\u{a42}ਰਜ",
                "ਸ\u{a42}ਰਜ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("بدل دے پیچھے سورج"),
            keywords: &["بدل", "بدل دے پیچھے سورج", "سورج"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Sọn Bihaínd Klaud"),
            keywords: &["Klaud", "Sọn", "Sọn Bihaínd Klaud"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("słońce zza chmury"),
            keywords: &["chmura", "pogoda", "słońce", "słońce zza chmury"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("لمر د ريځې شا ته"),
            keywords: &["لمر", "لمر د ريځې شا ته", "وريځ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("sol por trás das nuvens"),
            keywords: &["nuvem", "sol", "sol com nuvens", "sol por trás das nuvens"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("sol atrás de nuvem"),
            keywords: &["meteorologia", "nuvem", "sol", "sol atrás de nuvem"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("inti qhipa puyuman"),
            keywords: &["inti", "inti qhipa puyuman", "puyu"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("soare în nori"),
            keywords: &["nor", "soare", "soare în nori", "vreme"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-101"),
            keywords: &["E10-101"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("солнце за облаками"),
            keywords: &["облака", "облачно", "солнце", "солнце за облаками"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("izuba ryihishe inyuma y’igicu"),
            keywords: &["igicu", "izuba", "izuba ryihishe inyuma y’igicu"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڪڪر جي پويان سج"),
            keywords: &["سج", "ڪڪر", "ڪڪر جي پويان سج"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("වළ\u{dcf}ක\u{dd4}ළෙන\u{dca} වැස\u{dd4}ණ සඳ"),
            keywords: &[
                "ක\u{dcf}ලග\u{dd4}ණය",
                "වල\u{dcf}ක\u{dd4}ළ",
                "වළ\u{dcf}ක\u{dd4}ළෙන\u{dca} වැස\u{dd4}ණ සඳ",
                "ස\u{dd6}ර\u{dca}යය\u{dcf}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("slnko za oblakom"),
            keywords: &["oblak", "počasie", "slnko", "slnko za oblakom"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("sonce za oblakom"),
            keywords: &["oblak", "sonce", "sonce za oblakom", "vreme"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("qorrax ka dambaysa daruur"),
            keywords: &["daruur", "qorrax", "qorrax ka dambaysa daruur"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("diell pas reve"),
            keywords: &["diell", "diell pas reve", "moti", "re"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("сунце иза облака"),
            keywords: &["oблaк", "сунцe", "сунце иза облака"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["сунце иза облака"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("sunce iza oblaka"),
            keywords: &["oblak", "sunce", "sunce iza oblaka"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["sunce iza oblaka"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("sol bakom moln"),
            keywords: &["moln", "sol", "sol bakom moln", "sol med moln"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("jua nyuma ya wingu"),
            keywords: &["hali ya hewa", "jua", "jua nyuma ya wingu", "wingu"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("சூரியனை மேகம\u{bcd} மூடியிருக\u{bcd}கும\u{bcd} க\u{bbe}ட\u{bcd}சி"),
            keywords: &[
                "இயற\u{bcd}கை க\u{bbe}ட\u{bcd}சி",
                "சூரியனை மேகம\u{bcd} மூடியிருக\u{bcd}கும\u{bcd} க\u{bbe}ட\u{bcd}சி",
                "சூரியனை மேகம\u{bcd} மூடியிருப\u{bcd}பது போன\u{bcd}ற க\u{bbe}ட\u{bcd}சி",
                "மேகத\u{bcd}தின\u{bcd} பின\u{bcd}ன\u{bbe}ல\u{bcd} மறைந\u{bcd}திருக\u{bcd}கும\u{bcd} சூரியன\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("మబ\u{c4d}బుల చ\u{c3e}టు సూర\u{c4d}యుడు"),
            keywords: &[
                "మబ\u{c4d}బు",
                "మబ\u{c4d}బుల చ\u{c3e}టు సూర\u{c4d}యుడు",
                "సూర\u{c4d}యుడు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("офтоб паси абр"),
            keywords: &["абр", "офтоб", "офтоб паси абр"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ดวงอาท\u{e34}ตย\u{e4c}หล\u{e31}งเมฆ"),
            keywords: &[
                "ดวงอาท\u{e34}ตย\u{e4c}",
                "ดวงอาท\u{e34}ตย\u{e4c}หล\u{e31}งเมฆ",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("buludyň aňrysyndaky güneş"),
            keywords: &["buludyň aňrysyndaky güneş", "bulut", "güneş"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("laʻā ʻaoʻaofia"),
            keywords: &["laʻā ʻaoʻaofia"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("bulutlar ardındaki güneş"),
            keywords: &[
                "bulut",
                "bulutlar ardındaki güneş",
                "bulutlu güneş",
                "güneş",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("بۇلۇتلۇق قۇياش"),
            keywords: &["بۇلۇت", "بۇلۇتلۇق قۇياش", "قۇياش"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("сонце за хмарою"),
            keywords: &["погода", "сонце", "сонце за хмарою", "хмара"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("بادلوں کے پیچھے چھپا سورج"),
            keywords: &["بادل", "بادلوں کے پیچھے چھپا سورج", "سورج", "موسم"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("bulut ortidagi quyosh"),
            keywords: &["bulut", "bulut ortidagi quyosh", "ob-havo", "quyosh"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("mặt trời sau đám mây"),
            keywords: &["mây", "mặt trời", "mặt trời sau đám mây"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("jant ci ginaaw niir"),
            keywords: &["jant ci ginaaw niir", "niir", "sun"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ilanga elisemva kwamafu"),
            keywords: &["ilanga", "ilanga elisemva kwamafu", "ilifu"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Oorun Lẹhin Ofurufu"),
            keywords: &["Oorun Lẹhin Ofurufu", "òfurufú", "òòrùn"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("雲後太陽"),
            keywords: &["太陽", "雲", "雲後太陽"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("云后太阳"),
            keywords: &["云", "云后太阳", "太阳"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("阴"),
            keywords: &["乌云蔽日", "多云", "阴"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("陰天"),
            keywords: &["天氣", "陰天"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ilanga elingemuva kwefu"),
            keywords: &["ifu", "ilanga", "ilanga elingemuva kwefu", "isimo sezulu"],
        },
    ],
};
#[doc = "⛈\u{fe0f}"]
pub const CLOUD_WITH_LIGHTNING_AND_RAIN: crate::Emoji = crate::Emoji {
    glyph: "⛈\u{fe0f}",
    codepoint: "26C8 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.7f32,
    name: "cloud with lightning and rain",
    group: "Travel & Places",
    subgroup: "sky & weather",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "⛈",
        codepoint: "26C8",
        status: crate::Status::Unqualified,
        introduction_version: 0.7f32,
        name: "cloud with lightning and rain",
        group: "Travel & Places",
        subgroup: "sky & weather",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("wolk met weerlig en reën"),
            keywords: &[
                "blits",
                "donder",
                "reën",
                "weer",
                "wolk",
                "wolk met weerlig en reën",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ከመብረቅ እና ዝናብ ጋር ያለ ደመና"),
            keywords: &["መብረቅ", "ከመብረቅ እና ዝናብ ጋር ያለ ደመና", "ዝናብ", "የአየር ንብረት", "ደመና"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("سحابة وبرق ورعد"),
            keywords: &["رعد", "سحابة", "سحابة وبرق ورعد", "طقس", "مطر"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("মেঘৰ সৈতে বিজ\u{9c1}লী আৰ\u{9c1} বৰষ\u{9c1}ণ"),
            keywords: &[
                "ড\u{9be}ৱৰ",
                "বিজ\u{9c1}লী",
                "বৰষ\u{9c1}ণ",
                "মেঘৰ সৈতে বিজ\u{9c1}লী আৰ\u{9c1} বৰষ\u{9c1}ণ",
                "মেঘৰ সৈতে বিজ\u{9c1}লী আৰ\u{9c1} বৰষ\u{9c2}ণ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("ildırım və yağışlı bulud"),
            keywords: &[
                "bulud",
                "hava",
                "ildırım",
                "ildırım və yağışlı bulud",
                "yağış",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("хмара з маланкай і дажджом"),
            keywords: &[
                "гром",
                "дождж",
                "навальніца",
                "хмара",
                "хмара з маланкай і дажджом",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("облак с дъжд и светкавица"),
            keywords: &[
                "време",
                "гръм",
                "дъжд",
                "облак",
                "облак с дъжд и светкавица",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("মেঘের স\u{9be}থে বিদ\u{9cd}য\u{9c1}তের ঝলক ও ব\u{9c3}ষ\u{9cd}টি"),
            keywords: &[
                "আবহ\u{9be}ওয\u{9bc}\u{9be}",
                "ব\u{9c3}ষ\u{9cd}টি",
                "মেঘ",
                "মেঘের গর\u{9cd}জন",
                "মেঘের স\u{9be}থে বিদ\u{9cd}য\u{9c1}তের ঝলক ও ব\u{9c3}ষ\u{9cd}টি",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("koumoulenn gant lucʼhedenn ha glav"),
            keywords: &[
                "glav",
                "koumoul",
                "koumoulenn gant lucʼhedenn ha glav",
                "lucʼhed",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("oblačno s grmljavinom i kišom"),
            keywords: &[
                "grmljavina",
                "kiša",
                "oblačno s grmljavinom i kišom",
                "prognoza",
                "vrijeme",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("núvol amb llamp i pluja"),
            keywords: &[
                "llamp",
                "núvol",
                "núvol amb llamp i pluja",
                "pluja",
                "temps",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᎶᎩᎳ ᎠᎾᎦᎵᏍᎩ ᎠᎴ ᎠᎦᏍᎩ"),
            keywords: &["ᎠᎦᏍᎩ", "ᎠᏴᏓᏆᎶᏍᎩ", "ᎤᎶᎩᎳ", "ᎤᎶᎩᎳ ᎠᎾᎦᎵᏍᎩ ᎠᎴ ᎠᎦᏍᎩ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("mrak s bleskem a deštěm"),
            keywords: &[
                "blesk",
                "déšť",
                "hrom",
                "mrak",
                "mrak s bleskem a deštěm",
                "oblak",
                "počasí",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("cwmwl â mellt a glaw"),
            keywords: &["cwmwl", "cwmwl â mellt a glaw", "glau", "storm", "tywydd"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("sky med lyn og regn"),
            keywords: &["regn", "sky", "sky med lyn og regn", "torden", "vejr"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Wolke mit Blitz und Regen"),
            keywords: &[
                "Blitz",
                "Gewitter",
                "Regen",
                "Wetter",
                "Wolke",
                "Wolke mit Blitz und Regen",
                "wolkig",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("σύννεφο με αστραπή και βροχή"),
            keywords: &[
                "αστραπή",
                "βροχή",
                "καιρός",
                "σύννεφο",
                "σύννεφο με αστραπή και βροχή",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("cloud with lightning and rain"),
            keywords: &["cloud", "cloud with lightning and rain", "rain", "thunder"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("nube con rayo y lluvia"),
            keywords: &["lluvia", "nube", "nube con rayo y lluvia", "trueno"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("tormenta"),
            keywords: &["lluvia", "nube", "tiempo", "tormenta", "trueno"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &[
                "lluvia",
                "nube",
                "rayos",
                "relámpagos",
                "tormenta",
                "trueno",
            ],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("äikese- ja vihmapilv"),
            keywords: &["ilm", "pilv", "vihm", "äike", "äikese- ja vihmapilv"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("hodeia tximista eta euriarekin"),
            keywords: &[
                "eguraldi",
                "euri",
                "hodei",
                "hodeia tximista eta euriarekin",
                "trumoi",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("ابر با رعدوبرق و باران"),
            keywords: &[
                "آب\u{200c}وهوا",
                "ابر",
                "ابر با رعدوبرق و باران",
                "باران",
                "رعدوبرق",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("ukkospilvi ja sade"),
            keywords: &[
                "pilvi",
                "sade",
                "salama",
                "sää",
                "ukkonen",
                "ukkospilvi ja sade",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("ulap na may kidlat at ulan"),
            keywords: &[
                "kidlat",
                "panahon",
                "ulan",
                "ulap",
                "ulap na may kidlat at ulan",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("skýggj við regni og snarljósi"),
            keywords: &[
                "regn",
                "skýggj",
                "skýggj við regni og snarljósi",
                "snarljós",
                "tora",
                "torusláttur",
                "veðrið",
                "veður",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("nuage avec éclair et pluie"),
            keywords: &[
                "météo",
                "nuage avec éclair et pluie",
                "orage",
                "pluie",
                "éclair",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("nuage avec éclair et pluie"),
            keywords: &["nuage", "nuage avec éclair et pluie", "pluie", "éclair"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("scamall le tintreach agus fearthainn"),
            keywords: &[
                "aimsir",
                "fearthainn",
                "scamall",
                "scamall le tintreach agus fearthainn",
                "toirneach",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("neul le dealanaich ’s uisge"),
            keywords: &[
                "neul",
                "neul le dealanaich ’s uisge",
                "tàirneanach",
                "uisge",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("tormenta"),
            keywords: &["choiva", "lóstrego", "meteoroloxía", "nube", "tormenta"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("વીજળીના ચમકારા અન\u{ac7} વરસાદ સાથ\u{ac7}ન\u{ac1}\u{a82} વાદળ"),
            keywords: &[
                "મ\u{ac7}ઘગર\u{acd}જના",
                "વરસાદ",
                "વાદળ",
                "વીજળીના ચમકારા અન\u{ac7} વરસાદ સાથ\u{ac7}ન\u{ac1}\u{a82} વાદળ",
                "વીજળીનો કડાકો",
                "હવામાન",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("gajimare tare da aradu da ruwan sama"),
            keywords: &[
                "gajimare",
                "gajimare tare da aradu da ruwan sama",
                "ruwan sama",
                "tsawa",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("ענן עם ברק וגשם"),
            keywords: &["ברק", "גשם", "חורף", "ענן", "ענן עם ברק וגשם"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("बारिश और बिजली क\u{947} साथ बादल"),
            keywords: &["बारिश और बिजली क\u{947} साथ बादल", "मौसम"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("oblak s grmljavinom i kišom"),
            keywords: &[
                "grmljavina",
                "kiša",
                "oblak",
                "oblak s grmljavinom i kišom",
                "vrijeme",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("felhő villámmal és esővel"),
            keywords: &[
                "eső",
                "felhő",
                "felhő villámmal és esővel",
                "időjárás",
                "mennydörgés",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("կայծակով և անձրևով ամպ"),
            keywords: &["ամպ", "ամպրոպ", "անձրև", "եղանակ", "կայծակով և անձրևով ամպ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("awan dengan petir dan hujan"),
            keywords: &[
                "awan",
                "awan dengan petir dan hujan",
                "cuaca",
                "hujan",
                "petir",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("urukpu nwere àmụ\u{300}mà na mmiri òzùzò"),
            keywords: &[
                "egbeigwe",
                "mmiri òzùzò",
                "urukpu",
                "urukpu nwere àmụ\u{300}mà na mmiri òzùzò",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("ský með eldingu og regni"),
            keywords: &["regn", "ský", "ský með eldingu og regni", "veður", "þruma"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("temporale"),
            keywords: &["fulmini", "meteo", "nuvole", "pioggia", "temporale"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("雷雨"),
            keywords: &["天気", "稲妻", "雨", "雲", "雷", "雷雨"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("mega ngemu bledhek lan udan"),
            keywords: &["bledhek", "mega", "mega ngemu bledhek lan udan", "udan"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ღრუბელი ელვითა და წვიმით"),
            keywords: &[
                "ამინდი",
                "ქუხილი",
                "ღრუბელი",
                "ღრუბელი ელვითა და წვიმით",
                "წვიმა",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("найзағай мен жаңбыр"),
            keywords: &[
                "ауа райы",
                "бұлт",
                "жаңбыр",
                "күн күркіреуі",
                "найзағай мен жаңбыр",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("sky med lyn og regn"),
            keywords: &["regn", "sky", "sky med lyn og regn", "torden", "vejr"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ភ\u{17d2}លៀងធ\u{17d2}លាក\u{17cb}ន\u{17b7}ងមានរន\u{17d2}ទះ"),
            keywords: &[
                "ពពក",
                "ភ\u{17d2}លៀង",
                "ភ\u{17d2}លៀងធ\u{17d2}លាក\u{17cb}ន\u{17b7}ងមានរន\u{17d2}ទះ",
                "រន\u{17d2}ទះ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಮ\u{cbf}ಂಚು ಮತ\u{ccd}ತು ಮಳ\u{cc6}ಯೊಂದ\u{cbf}ಗ\u{cc6} ಮೇಘ"),
            keywords: &[
                "ಗುಡುಗು",
                "ಮಳ\u{cc6}",
                "ಮ\u{cbf}ಂಚು ಮತ\u{ccd}ತು ಮಳ\u{cc6}ಯೊಂದ\u{cbf}ಗ\u{cc6} ಮೇಘ",
                "ಮೇಘ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("번개가 치는 비구름"),
            keywords: &["구름", "번개", "번개가 치는 비구름", "비"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("गडगड आनी पावसाच\u{947} ढग"),
            keywords: &["गडगड आनी पावसाच\u{947} ढग", "ढग"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("чагылгандуу жамгыр жаап жаткан булут"),
            keywords: &[
                "аба ырайы",
                "булут",
                "жамгыр",
                "чагылган",
                "чагылган түшүп, жамгыр жаап жаткан булут",
                "чагылгандуу жамгыр жаап жаткан булут",
            ],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Wollek mat Blëtz a Reen"),
            keywords: &["Donnerwieder", "Reen", "Wollek", "Wollek mat Blëtz a Reen"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຝ\u{ebb}ນຟ\u{ec9}າຄະນອງ"),
            keywords: &[
                "ຕາເວ\u{eb1}ນ",
                "ຝ\u{ebb}ນຟ\u{ec9}າຄະນອງ",
                "ສະພາບອາກາດ",
                "ເມກ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("debesis su žaibu ir lietumi"),
            keywords: &["debesis", "debesis su žaibu ir lietumi", "lietus", "žaibas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("mākonis ar zibeni un lietu"),
            keywords: &[
                "laikapstākļi",
                "laiks",
                "lietus",
                "mākonis",
                "mākonis ar zibeni un lietu",
                "zibens",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kapua me te uira me te ua"),
            keywords: &["kapua", "kapua me te uira me te ua", "ua", "whatitiri"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("облак со гром и дожд"),
            keywords: &["време", "гром", "дожд", "облак", "облак со гром и дожд"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഇടിമിന\u{d4d}നല\u{d41}ം മഴയ\u{d41}ം"),
            keywords: &[
                "ഇടിമിന\u{d4d}നല\u{d41}ം മഴയ\u{d41}ം",
                "ഇടിമിന\u{d4d}നൽ",
                "മഴ",
                "മേഘം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("цахилгаантай, нартай бороо"),
            keywords: &["бороо", "нар", "цахилгаан", "цахилгаантай, нартай бороо"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("वीज चमकणार\u{94d}\u{200d}या आणि पावसासह ढग"),
            keywords: &[
                "गडगडाट",
                "ढग",
                "पाऊस",
                "वीज चमकणार\u{94d}\u{200d}या आणि पावसासह ढग",
                "वीज चमकणाऱ\u{94d}या आणि पावसासह ढग",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("awan dengan kilat dan hujan"),
            keywords: &[
                "awan",
                "awan dengan kilat dan hujan",
                "cuaca",
                "guruh",
                "hujan",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("sħaba b’sajjetti u x-xita"),
            keywords: &["ragħad", "sħaba", "sħaba b’sajjetti u x-xita", "xita"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "လျ\u{103e}ပ\u{103a}စ\u{102e}းလက\u{103a}ပြ\u{102e}း မ\u{102d}\u{102f}းရ\u{103d}ာနေသည\u{1037}\u{103a} တ\u{102d}မ\u{103a}",
            ),
            keywords: &[
                "တ\u{102d}မ\u{103a}",
                "မ\u{102d}\u{102f}း",
                "မ\u{102d}\u{102f}းကြ\u{102d}\u{102f}း",
                "မ\u{102d}\u{102f}းကြ\u{102d}\u{102f}းသ\u{103d}ားန\u{103e}င\u{1037}\u{103a} မ\u{102d}\u{102f}းရ\u{103d}ာနေသည\u{1037}\u{103a} တ\u{102d}မ\u{103a}",
                "လျ\u{103e}ပ\u{103a}စ\u{102e}းလက\u{103a}ပြ\u{102e}း မ\u{102d}\u{102f}းရ\u{103d}ာနေသည\u{1037}\u{103a} တ\u{102d}မ\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("sky med lyn og regn"),
            keywords: &["regn", "sky", "sky med lyn og regn", "torden", "vær"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("बिज\u{941}ली चम\u{94d}किरह\u{947}को र वर\u{94d}षासहितको बादल"),
            keywords: &[
                "गर\u{94d}जिन\u{947}",
                "बादल",
                "बिज\u{941}ली चम\u{94d}किरह\u{947}को र वर\u{94d}षासहितको बादल",
                "मौसम",
                "वर\u{94d}षा",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("wolk met bliksem en regen"),
            keywords: &["onweer", "regen", "wolk", "wolk met bliksem en regen"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("sky med lyn og regn"),
            keywords: &["regn", "sky", "sky med lyn og regn", "torevêr", "vêr"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ବ\u{b3f}ଜ\u{b41}ଳ\u{b3f} ଏବଂ ବର\u{b4d}ଷ\u{b3e} ସହ\u{b3f}ତ ମେଘ"),
            keywords: &[
                "ଘଡ\u{b3c}ଘଡ\u{b3c}\u{b3f}",
                "ବର\u{b4d}ଷ\u{b3e}",
                "ବ\u{b3f}ଜ\u{b41}ଳ\u{b3f} ଏବଂ ବର\u{b4d}ଷ\u{b3e} ସହ\u{b3f}ତ ମେଘ",
                "ମେଘ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਬ\u{a71}ਦਲ ਅਤ\u{a47} ਬਿਜਲੀ ਅਤ\u{a47} ਮੀ\u{a02}ਹ"),
            keywords: &[
                "ਤ\u{a42}ਫਾਨ",
                "ਬ\u{a71}ਦਲ",
                "ਬ\u{a71}ਦਲ ਅਤ\u{a47} ਬਿਜਲੀ ਅਤ\u{a47} ਮੀ\u{a02}ਹ",
                "ਮੀ\u{a02}ਹ",
                "ਮ\u{a4c}ਸਮ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("بجلی گرجن اتے مینہ دے نال بادل"),
            keywords: &[
                "بادل دی گرج",
                "بجلی گرجن اتے مینہ دے نال بادل",
                "بدل",
                "مینہ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Klaud Wit Laítnin An Ren"),
            keywords: &["Klaud", "Klaud Wit Laítnin An Ren", "Ren", "Tọ\u{301}nda"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("chmura z piorunem i deszczem"),
            keywords: &[
                "błyskawica",
                "chmura",
                "chmura z piorunem i deszczem",
                "deszcz",
                "piorun",
                "pogoda",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("وريځ د باران او پړقا سره"),
            keywords: &["باران", "وريځ", "وريځ د باران او پړقا سره", "پړقا"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("chuva com trovão"),
            keywords: &["chuva", "chuva com trovão", "clima", "nuvem", "trovão"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("nuvem com relâmpago e chuva"),
            keywords: &[
                "chuva",
                "meteorologia",
                "nuvem",
                "nuvem com relâmpago e chuva",
                "trovoada",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("puyu k’anchasqa parawan"),
            keywords: &["cloud", "kunuñunu", "para", "puyu k’anchasqa parawan"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("nor cu fulger și ploaie"),
            keywords: &[
                "fulger",
                "nor",
                "nor cu fulger și ploaie",
                "ploaie",
                "tunet",
                "vreme",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-102"),
            keywords: &["E10-102"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("гроза"),
            keywords: &["гроза", "гром", "дождь", "молния", "облако", "туча"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ibicu byiganjemo imirabyo n’imvura"),
            keywords: &[
                "ibicu",
                "ibicu byiganjemo imirabyo n’imvura",
                "imvura",
                "inkuba",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڪڪر سان کنوڻ ۽ برسات"),
            keywords: &["ڪڪر سان کنوڻ ۽ برسات", "ڪڪر، برسات، کنوڻ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some(
                "ව\u{dd2}ද\u{dd4}ල\u{dd2} කෙට\u{dd3}ම\u{dca} සහ වැස\u{dca}ස සහ\u{dd2}ත වල\u{dcf}ක\u{dd4}ළ",
            ),
            keywords: &[
                "ක\u{dcf}ලග\u{dd4}ණය",
                "ගෙරව\u{dd3}ම",
                "වල\u{dcf}ක\u{dd4}ළ",
                "වැස\u{dca}ස",
                "ව\u{dd2}ද\u{dd4}ල\u{dd2} කෙට\u{dd3}ම\u{dca} සහ වැස\u{dca}ස සහ\u{dd2}ත වල\u{dcf}ක\u{dd4}ළ",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("oblak s bleskom a dažďom"),
            keywords: &[
                "dážd",
                "hrom",
                "oblak",
                "oblak s bleskom a dažďom",
                "počasie",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("oblak s strelo in dežjem"),
            keywords: &[
                "dež",
                "oblak",
                "oblak s strelo in dežjem",
                "strela",
                "vreme",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("daruur leh hillaac iyo roob"),
            keywords: &["daruur", "daruur leh hillaac iyo roob", "onkod", "roob"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("re me vetëtimë dhe shi"),
            keywords: &["bubullimë", "moti", "re", "re me vetëtimë dhe shi", "shi"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("облак са муњом и кишом"),
            keywords: &["oблaк", "грмљaвинa", "кишa", "облак са муњом и кишом"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["облак са муњом и кишом"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("oblak sa munjom i kišom"),
            keywords: &["grmljavina", "kiša", "oblak", "oblak sa munjom i kišom"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["oblak sa munjom i kišom"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("moln med regn och blixtar"),
            keywords: &["moln", "moln med regn och blixtar", "oväder", "väder"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("wingu pamoja na radi na mvua"),
            keywords: &[
                "hali ya hewa",
                "mvua",
                "ngurumo",
                "wingu",
                "wingu pamoja na radi na mvua",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("இடி மின\u{bcd}னலுடன\u{bcd} மழை"),
            keywords: &[
                "இடி மின\u{bcd}னலுடன\u{bcd} மழை",
                "வ\u{bbe}னிலை",
                "வெப\u{bcd}பநிலை",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("మ\u{c46}రుస\u{c4d}తూ వ\u{c3e}న కురుస\u{c4d}తున\u{c4d}న మ\u{c47}ఘం"),
            keywords: &[
                "మ\u{c46}రుపు",
                "మ\u{c46}రుస\u{c4d}తూ వ\u{c3e}న కురుస\u{c4d}తున\u{c4d}న మ\u{c47}ఘం",
                "మ\u{c47}ఘం",
                "వ\u{c3e}న",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("абр бо чароғак ва борон"),
            keywords: &["абр", "абр бо чароғак ва борон", "борон", "тундар"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ฝนฟ\u{e49}าคะนอง"),
            keywords: &[
                "ฝน",
                "ฝนฟ\u{e49}าคะนอง",
                "ฟ\u{e49}าร\u{e49}อง",
                "สภาพอากาศ",
                "เมฆ",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ýyldyrymly we ýagyşly bulut"),
            keywords: &[
                "bulut",
                "gök gümmürdisi",
                "ýagyş",
                "ýyldyrymly we ýagyşly bulut",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("ʻao moe ʻuha moe ʻuhila"),
            keywords: &["ʻao moe ʻuha moe ʻuhila"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("şimşek ve yağmurlu bulut"),
            keywords: &[
                "bulut",
                "gökgürültüsü",
                "hava durumu",
                "yağmur",
                "şimşek ve yağmurlu bulut",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("گۈلدۈرمامىلىق يامغۇر"),
            keywords: &["بۇلۇت", "يامغۇر", "گۈلدۈرماما", "گۈلدۈرمامىلىق يامغۇر"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("хмара з блискавкою та дощем"),
            keywords: &[
                "грім",
                "дощ",
                "погода",
                "хмара",
                "хмара з блискавкою та дощем",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("گرج چمک اور بارش والے بادل"),
            keywords: &["بادل", "بارش", "موسم", "گرج چمک اور بارش والے بادل"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("bulut, chaqmoq va yomg‘ir"),
            keywords: &[
                "bulut",
                "bulut, chaqmoq va yomg‘ir",
                "chaqmoq",
                "ob-havo",
                "yomg‘ir",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("đám mây kèm chớp và mưa"),
            keywords: &["mây", "mưa", "sấm", "đám mây kèm chớp và mưa"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("niir ak melax ak taw"),
            keywords: &["dënd", "niir", "niir ak melax ak taw", "taw"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ilifu elinombane nemvula"),
            keywords: &["ilifu", "ilifu elinombane nemvula", "imvula", "indudumo"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("òfurufú pẹ\u{300}lú ṣíṣáná àti òjò"),
            keywords: &[
                "àrá",
                "òfurufú",
                "òfurufú pẹ\u{300}lú ṣíṣáná àti òjò",
                "òjò",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("閃電雲同雨雲"),
            keywords: &["閃電雲同雨雲", "雨", "雲", "雷電"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("闪电云同雨云"),
            keywords: &["云", "闪电云同雨云", "雨", "雷电"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("雷阵雨"),
            keywords: &["阵雨", "雨", "雷阵雨"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("雷雨"),
            keywords: &["天氣", "雷雨"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("有雷雨嘅雲"),
            keywords: &["天氣", "有雷雨嘅雲"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ifu elinombani kanye nemvula"),
            keywords: &[
                "ifu",
                "ifu elinombani kanye nemvula",
                "imvula",
                "isimo sezulu",
                "ukuduma",
            ],
        },
    ],
};
#[doc = "🌤\u{fe0f}"]
pub const SUN_BEHIND_SMALL_CLOUD: crate::Emoji = crate::Emoji {
    glyph: "🌤\u{fe0f}",
    codepoint: "1F324 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.7f32,
    name: "sun behind small cloud",
    group: "Travel & Places",
    subgroup: "sky & weather",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🌤",
        codepoint: "1F324",
        status: crate::Status::Unqualified,
        introduction_version: 0.7f32,
        name: "sun behind small cloud",
        group: "Travel & Places",
        subgroup: "sky & weather",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("son agter klein wolk"),
            keywords: &["son", "son agter klein wolk", "weer", "wolk"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ከትንሽ ደመና ጀርባ ያለች ፀሐይ"),
            keywords: &["ከትንሽ ደመና ጀርባ ያለች ፀሐይ", "የአየር ንብረት", "ደመና", "ፀሐይ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("شمس خلف سحابة صغيرة"),
            keywords: &["سحاب", "شمس", "شمس خلف سحابة صغيرة", "طقس"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("কম ড\u{9be}ৱৰৰ পিছফ\u{9be}লে স\u{9c2}ৰ\u{9cd}য\u{9cd}য"),
            keywords: &[
                "কম ড\u{9be}ৱৰৰ পিছফ\u{9be}লে স\u{9c2}ৰ\u{9cd}য\u{9cd}য",
                "ড\u{9be}ৱৰ",
                "স\u{9c2}ৰ\u{9cd}য\u{9cd}য",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("balaca buludun arxasına günəş"),
            keywords: &["balaca buludun arxasına günəş", "bulud", "günəş", "hava"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("сонца за маленькім воблакам"),
            keywords: &[
                "воблака",
                "надвор’е",
                "неба",
                "сонца",
                "сонца за маленькім воблакам",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Слънце зад малък облак"),
            keywords: &["Слънце зад малък облак", "време", "облак", "слънце"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("অল\u{9cd}প মেঘের পিছনে স\u{9c2}র\u{9cd}য"),
            keywords: &[
                "অল\u{9cd}প মেঘের পিছনে স\u{9c2}র\u{9cd}য",
                "আবহ\u{9be}ওয\u{9bc}\u{9be}",
                "মেঘ",
                "স\u{9c2}র\u{9cd}য",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("heol a-dreñv dʼur goumoulennig"),
            keywords: &["heol", "heol a-dreñv dʼur goumoulennig", "koumoul"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("pretežno sunčano"),
            keywords: &["oblaci", "pretežno sunčano", "prognoza", "sunce", "vrijeme"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("sol darrere d’un núvol petit"),
            keywords: &[
                "núvol petit",
                "sol",
                "sol darrere d’un núvol petit",
                "temps",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏅᏓ ᎢᎦ ᎡᎯ ᏧᏘᏍᏓ ᎤᏍᏗᎢ ᏧᎶᎩᎵᎢ ᎣᏂᏗᏢᎢ"),
            keywords: &["ᎤᎶᎩᎳ", "ᏅᏓ", "ᏅᏓ ᎢᎦ ᎡᎯ ᏧᏘᏍᏓ ᎤᏍᏗᎢ ᏧᎶᎩᎵᎢ ᎣᏂᏗᏢᎢ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("slunce za malým mrakem"),
            keywords: &[
                "mrak",
                "mráček",
                "oblak",
                "obláček",
                "polojasno",
                "počasí",
                "slunce",
                "slunce za malým mrakem",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("haul tu ôl i gwmwl bach"),
            keywords: &["cwmwl", "haul", "haul tu ôl i gwmwl bach", "tywydd"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("sol bag lille sky"),
            keywords: &["sky", "sol", "sol bag lille sky", "vejr"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Sonne hinter kleiner Wolke"),
            keywords: &[
                "Sonne",
                "Sonne hinter kleiner Wolke",
                "Wetter",
                "Wolke",
                "kleine Wolke",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ήλιος πίσω από μικρό σύννεφο"),
            keywords: &["ήλιος", "ήλιος πίσω από μικρό σύννεφο", "καιρός", "σύννεφο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("sun behind small cloud"),
            keywords: &["cloud", "sun", "sun behind small cloud"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("sol detrás de una nube pequeña"),
            keywords: &["nube", "sol", "sol detrás de una nube pequeña"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("soleado con nubes"),
            keywords: &["clima", "nube", "sol", "soleado con nubes"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("päike väikese pilve taga"),
            keywords: &["ilm", "pilv", "päike", "päike väikese pilve taga"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("eguzkia hodei txiki baten atzean"),
            keywords: &[
                "eguraldi",
                "eguzki",
                "eguzkia hodei txiki baten atzean",
                "hodei",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("خورشید پشت ابر کوچک"),
            keywords: &["آب\u{200c}وهوا", "ابر", "خورشید", "خورشید پشت ابر کوچک"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("aurinko ja pieni pilvi"),
            keywords: &["aurinko", "aurinko ja pieni pilvi", "pilvi", "sää"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("araw sa likod ng maliit na ulap"),
            keywords: &[
                "araw",
                "araw sa likod ng maliit na ulap",
                "lagay ng panahon",
                "panahon",
                "ulap",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("sólin aftanfyri eitt lítið skýggj"),
            keywords: &[
                "sól",
                "sólarglottar",
                "sólglottur",
                "sólin aftanfyri eitt lítið skýggj",
                "sólskinsveður",
                "veðrið",
                "veður",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("soleil derrière un petit nuage"),
            keywords: &["nuage", "soleil derrière un petit nuage"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("soleil derrière un petit nuage"),
            keywords: &[
                "nuage",
                "petit nuage",
                "soleil",
                "soleil derrière un petit nuage",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("grian taobh thiar de scamall beag"),
            keywords: &[
                "aimsir",
                "grian",
                "grian taobh thiar de scamall beag",
                "scamall",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("a’ ghrian air cùl neòil bhig"),
            keywords: &["a’ ghrian air cùl neòil bhig", "grian", "neul", "sgòth"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("ceo parcialmente despexado"),
            keywords: &["ceo parcialmente despexado", "meteoroloxía", "nube", "sol"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("નાના વાદળાની પાછળ સ\u{ac2}ર\u{acd}ય"),
            keywords: &[
                "નાના વાદળાની પાછળ સ\u{ac2}ર\u{acd}ય",
                "સ\u{ac2}ર\u{acd}ય",
                "હવામાન",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("rana a bayan ƙaramin gajimare"),
            keywords: &["gajimare", "rana", "rana a bayan ƙaramin gajimare"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("שמש מאחורי ענן קטן"),
            keywords: &["מעונן", "ענן", "שמש", "שמש מאחורי ענן קטן"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("छोट\u{947} बादल क\u{947} पीछ\u{947} स\u{942}र\u{94d}य"),
            keywords: &[
                "छोट\u{947} बादल क\u{947} पीछ\u{947} स\u{942}र\u{94d}य",
                "मौसम",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("sunce iza malog oblaka"),
            keywords: &["oblak", "sunce", "sunce iza malog oblaka", "vrijeme"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("nap egy kis felhő mögött"),
            keywords: &["felhő", "időjárás", "nap", "nap egy kis felhő mögött"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("արև փոքր ամպի հետևում"),
            keywords: &["ամպ", "արև", "արև փոքր ամպի հետևում", "եղանակ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("matahari di balik awan kecil"),
            keywords: &["awan", "cuaca", "matahari", "matahari di balik awan kecil"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("anyanwụ n’àzụ obere urukpu"),
            keywords: &["anyanwụ", "anyanwụ n’àzụ obere urukpu", "urukpu"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("sól á bak við ský"),
            keywords: &["ský", "sól", "sól á bak við ský", "veður"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("parzialmente nuvoloso"),
            keywords: &[
                "meteo",
                "nuvole",
                "parzialmente nuvoloso",
                "sole",
                "variabile",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("晴れ時々曇り"),
            keywords: &["天気", "太陽", "晴れ", "晴れ時々曇り", "雲"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("srengenge saburine mega cilik"),
            keywords: &["mega", "srengenge", "srengenge saburine mega cilik"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მზე პატარა ღრუბლის უკან"),
            keywords: &["ამინდი", "მზე", "მზე პატარა ღრუბლის უკან", "ღრუბელი"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: None,
            keywords: &["asigna", "iṭij"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("кіші бұлттың артындағы күн"),
            keywords: &["ауа райы", "бұлт", "кіші бұлттың артындағы күн", "күн"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("sol bag lille sky"),
            keywords: &["sky", "sol", "sol bag lille sky", "vejr"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ដ\u{17bb}\u{17c6}ពពកត\u{17bc}ចបា\u{17c6}ងព\u{17d2}រះអាទ\u{17b7}ត\u{17d2}យ"),
            keywords: &[
                "ដ\u{17bb}\u{17c6}ពពក",
                "ដ\u{17bb}\u{17c6}ពពកត\u{17bc}ចបា\u{17c6}ងព\u{17d2}រះអាទ\u{17b7}ត\u{17d2}យ",
                "បា\u{17c6}ង",
                "ព\u{17d2}រះអាទ\u{17b7}ត\u{17d2}យ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಚ\u{cbf}ಕ\u{ccd}ಕ ಮೋಡದ ಹ\u{cbf}ಂದ\u{cc6} ಸ\u{cc2}ರ\u{ccd}ಯ"),
            keywords: &[
                "ಚ\u{cbf}ಕ\u{ccd}ಕ ಮೋಡದ ಹ\u{cbf}ಂದ\u{cc6} ಸ\u{cc2}ರ\u{ccd}ಯ",
                "ಮೇಘ",
                "ಮೋಡ",
                "ಮೋಡದ ಹ\u{cbf}ಂದ\u{cc6} ಸ\u{cc2}ರ\u{ccd}ಯ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("작은 구름 뒤의 태양"),
            keywords: &["구름", "작은 구름 뒤의 태양", "해", "흐림"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("ल\u{94d}हान ढगा आडचो स\u{941}र\u{94d}य"),
            keywords: &[
                "ढग",
                "ल\u{94d}हान ढगा आडचो स\u{941}र\u{94d}य",
                "स\u{941}र\u{94d}य",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("кичине булуттун артындагы күн"),
            keywords: &["аба ырайы", "булут", "кичине булуттун артындагы күн", "күн"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Sonn hannert kleng Wolleken"),
            keywords: &["Sonn", "Sonn hannert kleng Wolleken", "Wollek"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເມກນ\u{ec9}ອຍບ\u{ebb}ດບ\u{eb1}ງຕາເວ\u{eb1}ນ"),
            keywords: &[
                "ຕາເວ\u{eb1}ນ",
                "ສະພາບອາກາດ",
                "ເມກ",
                "ເມກນ\u{ec9}ອຍບ\u{ebb}ດບ\u{eb1}ງຕາເວ\u{eb1}ນ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("saulė už nedidelio debesies"),
            keywords: &["debesis", "saulė", "saulė už nedidelio debesies"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("saule aiz maza mākoņa"),
            keywords: &[
                "laikapstākļi",
                "laiks",
                "mākonis",
                "saule",
                "saule aiz maza mākoņa",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("rā muri kapua iti"),
            keywords: &["kapua", "rā", "rā muri kapua iti"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("сонце зад мал облак"),
            keywords: &["време", "облак", "сонце", "сонце зад мал облак"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ചെറ\u{d41}മേഘങ\u{d4d}ങൾക\u{d4d}ക\u{d4d} പിന\u{d4d}നിലെ സ\u{d42}ര\u{d4d}യൻ"),
            keywords: &[
                "ക\u{d3e}ല\u{d3e}വസ\u{d4d}ഥ",
                "ചെറ\u{d41}മേഘങ\u{d4d}ങൾക\u{d4d}ക\u{d4d} പിന\u{d4d}നിലെ സ\u{d42}ര\u{d4d}യൻ",
                "മേഘം",
                "മേഘങ\u{d4d}ങള\u{d41}ം സ\u{d42}ര\u{d4d}യന\u{d41}ം",
                "സ\u{d42}ര\u{d4d}യൻ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("жижиг үүлний цаагуурх нар"),
            keywords: &["жижиг", "жижиг үүлний цаагуурх нар", "нар", "үүл"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("ढगामगील स\u{942}र\u{94d}य"),
            keywords: &[
                "ढग",
                "ढगामगील स\u{942}र\u{94d}य",
                "लहान ढगामागील स\u{942}र\u{94d}य",
                "स\u{942}र\u{94d}य",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("matahari di sebalik awan kecil"),
            keywords: &[
                "awan",
                "cuaca",
                "matahari",
                "matahari di sebalik awan kecil",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("xemx wara sħaba żgħira"),
            keywords: &["sħaba", "xemx", "xemx wara sħaba żgħira"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("တ\u{102d}မ\u{103a}ငယ\u{103a} နောက\u{103a}က နေ"),
            keywords: &[
                "တ\u{102d}မ\u{103a}",
                "တ\u{102d}မ\u{103a}ငယ\u{103a} နောက\u{103a}က နေ",
                "တ\u{102d}မ\u{103a}ငယ\u{103a}အက\u{103d}ယ\u{103a}မ\u{103e} နေထ\u{103d}က\u{103a}ပ\u{102f}\u{1036}",
                "နေ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("sol bak liten sky"),
            keywords: &["sky", "sol", "sol bak liten sky", "vær"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("सानो बादलपछाडिको स\u{942}र\u{94d}य"),
            keywords: &[
                "बादल",
                "मौसम",
                "सानो बादलपछाडिको स\u{942}र\u{94d}य",
                "स\u{942}र\u{94d}य",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("zon achter kleine wolk"),
            keywords: &["wolk", "zon", "zon achter kleine wolk"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("sol bak lita sky"),
            keywords: &["sky", "sol", "sol bak lita sky", "vêr"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଛୋଟ ମେଘ ପଛରେ ସ\u{b42}ର\u{b4d}ଯ\u{b4d}ୟ"),
            keywords: &[
                "ଛୋଟ ମେଘ ପଛରେ ସ\u{b42}ର\u{b4d}ଯ\u{b4d}ୟ",
                "ମେଘ",
                "ସ\u{b42}ର\u{b4d}ଯ\u{b4d}ୟ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਛ\u{a4b}ਟ\u{a47} ਬ\u{a71}ਦਲਾ\u{a02} ਵਿ\u{a71}ਚ ਲ\u{a41}ਕਿਆ ਸ\u{a42}ਰਜ"),
            keywords: &[
                "ਛ\u{a4b}ਟ\u{a47} ਬ\u{a71}ਦਲਾ\u{a02} ਵਿ\u{a71}ਚ ਲ\u{a41}ਕਿਆ ਸ\u{a42}ਰਜ",
                "ਧ\u{a41}\u{a71}ਪ",
                "ਬ\u{a71}ਦਲ",
                "ਮ\u{a4c}ਸਮ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ن\u{650}ک\u{651}ے بادل دے پیچھے سورج"),
            keywords: &["بدل", "سورج", "ن\u{650}ک\u{651}ے بادل دے پیچھے سورج"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Sọn Bihaínd Smọl Klaud"),
            keywords: &[
                "Klaud",
                "Sọn",
                "Sọn Bihaínd Smọl Klaud",
                "Sọn Bihaínd Smọ\u{301}l Klaud",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("słońce za chmurką"),
            keywords: &["chmura", "pogoda", "słońce", "słońce za chmurką"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("لمر د کوچنۍ وريځې شا ته"),
            keywords: &["لمر", "لمر د کوچنۍ وريځې شا ته", "وريځ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("sol com nuvens"),
            keywords: &["clima", "nuvem", "sol", "sol com nuvens"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("sol atrás de nuvem pequena"),
            keywords: &["meteorologia", "nuvem", "sol", "sol atrás de nuvem pequena"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("inti qhipa huchuy puyu"),
            keywords: &["inti", "inti qhipa huchuy puyu", "puyu"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("soare după un nor mic"),
            keywords: &["nor", "soare", "soare după un nor mic", "vreme"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-233"),
            keywords: &["E10-233"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("солнце за облачком"),
            keywords: &["облако", "облачко", "солнце", "солнце за облачком", "туча"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("izuba inyuma y’igicu gito"),
            keywords: &["igicu", "izuba", "izuba inyuma y’igicu gito"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ننڍن ڪڪرن پٺيان سج"),
            keywords: &["سج", "ننڍن ڪڪرن پٺيان سج", "ڪڪر"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ක\u{dd4}ඩ\u{dcf} වල\u{dcf}ක\u{dd4}ළකට ප\u{dd2}ට\u{dd4}පස\u{dd2}න\u{dca} සඳ"),
            keywords: &[
                "ක\u{dcf}ලග\u{dd4}ණය",
                "ක\u{dd4}ඩ\u{dcf} වල\u{dcf}ක\u{dd4}ළකට ප\u{dd2}ට\u{dd4}පස\u{dd2}න\u{dca} සඳ",
                "වල\u{dcf}ක\u{dd4}ළ",
                "ස\u{dd6}ර\u{dca}යය\u{dcf}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("slnko za malým oblakom"),
            keywords: &["oblak", "počasie", "slnko", "slnko za malým oblakom"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("sonce za oblačkom"),
            keywords: &["oblak", "sonce", "sonce za oblačkom", "vreme"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("qorrax ka dambaysa daruur yar"),
            keywords: &["daruur", "qorrax", "qorrax ka dambaysa daruur yar"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("diell pas reve të vogla"),
            keywords: &["diell", "diell pas reve të vogla", "moti", "re"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("сунце иза малог облака"),
            keywords: &["oблaк", "сунцe", "сунце иза малог облака"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["сунце иза малог облака"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("sunce iza malog oblaka"),
            keywords: &["oblak", "sunce", "sunce iza malog oblaka"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["sunce iza malog oblaka"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("sol bakom litet moln"),
            keywords: &["moln", "sol", "sol bakom litet moln", "väder"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("jua nyuma ya wingu dogo"),
            keywords: &["hali ya hewa", "jua", "jua nyuma ya wingu dogo", "wingu"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("சிறிய மேகத\u{bcd}திற\u{bcd}கு பின\u{bcd}ன\u{bbe}ல\u{bcd} சூரியன\u{bcd}"),
            keywords: &[
                "சிறிய மேகத\u{bcd}திற\u{bcd}கு பின\u{bcd}ன\u{bbe}ல\u{bcd} சூரியன\u{bcd}",
                "சூரியன\u{bcd}",
                "மேகம\u{bcd}",
                "வெப\u{bcd}பநிலை",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("చ\u{c3f}న\u{c4d}న మ\u{c47}ఘం వ\u{c46}నుక ఉన\u{c4d}న సూర\u{c4d}యుడు"),
            keywords: &[
                "చ\u{c3f}న\u{c4d}న మ\u{c47}ఘం",
                "చ\u{c3f}న\u{c4d}న మ\u{c47}ఘం వ\u{c46}నుక ఉన\u{c4d}న సూర\u{c4d}యుడు",
                "సూర\u{c4d}యుడు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("офтоб паси абри хурд"),
            keywords: &["абр", "офтоб", "офтоб паси абри хурд"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เมฆน\u{e49}อยบดบ\u{e31}งพระอาท\u{e34}ตย\u{e4c}"),
            keywords: &[
                "พระอาท\u{e34}ตย\u{e4c}",
                "สภาพอากาศ",
                "เมฆ",
                "เมฆน\u{e49}อยบดบ\u{e31}งพระอาท\u{e34}ตย\u{e4c}",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("kiçi buludyň aňrysyndaky güneş"),
            keywords: &["bulut", "güneş", "kiçi buludyň aňrysyndaky güneş"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("ʻaoʻaofia siʻi"),
            keywords: &["ʻaoʻaofia siʻi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("bulutun arkasındaki güneş"),
            keywords: &["bulut", "bulutun arkasındaki güneş", "güneş", "hava durumu"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("پارچە بۇلۇت ئارقىدا قۇياش"),
            keywords: &["بۇلۇت", "قۇياش", "پارچە بۇلۇت ئارقىدا قۇياش"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("сонце за хмаркою"),
            keywords: &["погода", "сонце", "сонце за хмаркою", "хмара"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("چھوٹے بادل کے پیچھے چھپا سورج"),
            keywords: &["بادل", "سورج", "موسم", "چھوٹے بادل کے پیچھے چھپا سورج"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("kichik bulut ortidagi quyosh"),
            keywords: &["bulut", "kichik bulut ortidagi quyosh", "ob-havo", "quyosh"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("mặt trời sau đám mây nhỏ"),
            keywords: &["mây", "mặt trời", "mặt trời sau đám mây nhỏ"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("jant ci ginaaw niir wu ndaw"),
            keywords: &["jant ci ginaaw niir wu ndaw", "niir", "sun"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ilanga elisemva kwelifu elincinane"),
            keywords: &["ilanga", "ilanga elisemva kwelifu elincinane", "ilifu"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("òòrùn lẹ\u{301}yìn òfurufú kékeré"),
            keywords: &["òfurufú", "òòrùn", "òòrùn lẹ\u{301}yìn òfurufú kékeré"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("小雲後嘅太陽"),
            keywords: &["太陽", "小雲後嘅太陽", "雲"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("小云后嘅太阳"),
            keywords: &["云", "太阳", "小云后嘅太阳"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("晴偶有云"),
            keywords: &["云", "太阳", "少云", "晴偶有云"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("晴偶有雲"),
            keywords: &["天氣", "晴偶有雲"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("太陽喺一嚿細雲後面"),
            keywords: &["天氣", "太陽喺一嚿細雲後面"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ilanga elingemuva kwefu elincane"),
            keywords: &[
                "ifu",
                "ilanga",
                "ilanga elingemuva kwefu elincane",
                "isimo sezulu",
            ],
        },
    ],
};
#[doc = "🌥\u{fe0f}"]
pub const SUN_BEHIND_LARGE_CLOUD: crate::Emoji = crate::Emoji {
    glyph: "🌥\u{fe0f}",
    codepoint: "1F325 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.7f32,
    name: "sun behind large cloud",
    group: "Travel & Places",
    subgroup: "sky & weather",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🌥",
        codepoint: "1F325",
        status: crate::Status::Unqualified,
        introduction_version: 0.7f32,
        name: "sun behind large cloud",
        group: "Travel & Places",
        subgroup: "sky & weather",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("son agter groot wolk"),
            keywords: &["son", "son agter groot wolk", "weer", "wolk"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ከትልቅ ደመና ጀርባ ያለች ፀሐይ"),
            keywords: &["ከትልቅ ደመና ጀርባ ያለች ፀሐይ", "የአየር ንብረት", "ደመና", "ፀሐይ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("شمس خلف سحابة كبيرة"),
            keywords: &["سحابة", "شمس", "شمس خلف سحابة كبيرة", "طقس"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("বেছি ড\u{9be}ৱৰৰ পিছফ\u{9be}লে স\u{9c2}ৰ\u{9cd}য\u{9cd}য"),
            keywords: &[
                "ড\u{9be}ৱৰ",
                "বেছি ড\u{9be}ৱৰৰ পিছফ\u{9be}লে স\u{9c2}ৰ\u{9cd}য\u{9cd}য",
                "স\u{9c2}ৰ\u{9cd}য\u{9cd}য",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("böyük buludun arxasında günəş"),
            keywords: &["bulud", "böyük buludun arxasında günəş", "günəş", "hava"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("сонца за вялікім воблакам"),
            keywords: &[
                "воблака",
                "надвор’е",
                "неба",
                "сонца",
                "сонца за вялікім воблакам",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Слънце зад голям облак"),
            keywords: &["Слънце зад голям облак", "време", "облак", "слънце"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("বেশি মেঘের পিছনে স\u{9c2}র\u{9cd}য"),
            keywords: &[
                "আবহ\u{9be}ওয\u{9bc}\u{9be}",
                "বেশি মেঘের পিছনে স\u{9c2}র\u{9cd}য",
                "মেঘ",
                "স\u{9c2}র\u{9cd}য",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("heol a-dreñv dʼur goumoulenn vras"),
            keywords: &["heol", "heol a-dreñv dʼur goumoulenn vras", "koumoul"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("pretežno oblačno"),
            keywords: &["oblaci", "pretežno oblačno", "prognoza", "vrijeme"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("sol darrere d’un núvol gran"),
            keywords: &["núvol gran", "sol", "sol darrere d’un núvol gran", "temps"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏅᏓ ᎢᎦ ᎡᎯ ᏧᏘᏍᏓ ᎤᏔᎾ ᏧᎶᎩᎸᎢ ᎣᏂᏗᏢᎢ"),
            keywords: &["ᎤᎶᎩᎳ", "ᏅᏓ", "ᏅᏓ ᎢᎦ ᎡᎯ ᏧᏘᏍᏓ ᎤᏔᎾ ᏧᎶᎩᎸᎢ ᎣᏂᏗᏢᎢ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("slunce za velkým mrakem"),
            keywords: &[
                "mrak",
                "oblak",
                "počasí",
                "slunce",
                "slunce za velkým mrakem",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("haul tu ôl i gwmwl mawr"),
            keywords: &["cwmwl", "haul", "haul tu ôl i gwmwl mawr", "tywydd"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("sol bag stor sky"),
            keywords: &["sky", "sol", "sol bag stor sky", "vejr"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Sonne hinter großer Wolke"),
            keywords: &[
                "Sonne",
                "Sonne hinter großer Wolke",
                "Wetter",
                "Wolke",
                "große Wolke",
            ],
        },
        #[cfg(feature = "de_CH")]
        crate::Annotation {
            lang: "de_CH",
            tts: Some("Sonne hinter grosser Wolke"),
            keywords: &[
                "Sonne",
                "Sonne hinter grosser Wolke",
                "Wetter",
                "Wolke",
                "grosse Wolke",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ήλιος πίσω από μεγάλο σύννεφο"),
            keywords: &[
                "ήλιος",
                "ήλιος πίσω από μεγάλο σύννεφο",
                "καιρός",
                "σύννεφο",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("sun behind large cloud"),
            keywords: &["cloud", "sun", "sun behind large cloud"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("sol detrás de una nube grande"),
            keywords: &["nube", "sol", "sol detrás de una nube grande"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("nublado"),
            keywords: &["clima", "nube", "nublado"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("päike suure pilve taga"),
            keywords: &["ilm", "pilv", "päike", "päike suure pilve taga"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("eguzkia hodei handi baten atzean"),
            keywords: &[
                "eguraldi",
                "eguzki",
                "eguzkia hodei handi baten atzean",
                "hodei",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("خورشید پشت ابر بزرگ"),
            keywords: &["آب\u{200c}وهوا", "ابر", "خورشید", "خورشید پشت ابر بزرگ"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("aurinko ja suuri pilvi"),
            keywords: &["aurinko", "aurinko ja suuri pilvi", "pilvi", "sää"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("araw sa likod ng malaking ulap"),
            keywords: &[
                "araw",
                "araw sa likod ng malaking ulap",
                "lagay ng panahon",
                "panahon",
                "ulap",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("sólin aftanfyri eitt stórt skýggj"),
            keywords: &[
                "sól",
                "sólarglottar",
                "sólglottur",
                "sólin aftanfyri eitt stórt skýggj",
                "veðrið",
                "veður",
                "yvirskýggja",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("soleil derrière un gros nuage"),
            keywords: &["nuage", "soleil derrière un gros nuage"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("soleil derrière un gros nuage"),
            keywords: &[
                "gros nuage",
                "nuage",
                "soleil",
                "soleil derrière un gros nuage",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("grian taobh thiar de scamall mór"),
            keywords: &[
                "aimsir",
                "grian",
                "grian taobh thiar de scamall mór",
                "scamall",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("a’ ghrian air cùl sgòtha mhòir"),
            keywords: &["a’ ghrian air cùl sgòtha mhòir", "grian", "neul", "sgòth"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("ceo cuberto"),
            keywords: &["ceo cuberto", "meteoroloxía", "nube", "sol"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("મોટા વાદળા\u{a82}ની પાછળ સ\u{ac2}ર\u{acd}ય"),
            keywords: &[
                "મોટા વાદળા\u{a82}ની પાછળ સ\u{ac2}ર\u{acd}ય",
                "સ\u{ac2}ર\u{acd}ય",
                "હવામાન",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("rana a bayan babban gajimare"),
            keywords: &["gajimare", "rana", "rana a bayan babban gajimare"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("שמש מאחורי ענן גדול"),
            keywords: &["מעונן", "ענן", "שמש", "שמש מאחורי ענן גדול"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("बड\u{93c}\u{947} बादल क\u{947} पीछ\u{947} स\u{942}र\u{94d}य"),
            keywords: &[
                "बड\u{93c}\u{947} बादल क\u{947} पीछ\u{947} स\u{942}र\u{94d}य",
                "मौसम",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("sunce iza velikog oblaka"),
            keywords: &["oblak", "sunce", "sunce iza velikog oblaka", "vrijeme"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("nap egy nagy felhő mögött"),
            keywords: &["felhő", "időjárás", "nap", "nap egy nagy felhő mögött"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("արև մեծ ամպի հետևում"),
            keywords: &["ամպ", "արև", "արև մեծ ամպի հետևում", "եղանակ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("matahari di balik awan besar"),
            keywords: &["awan", "cuaca", "matahari", "matahari di balik awan besar"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("anyanwụ n’àzụ nnukwu urukpu"),
            keywords: &["anyanwụ", "anyanwụ n’àzụ nnukwu urukpu", "urukpu"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("sól á bak við stórt ský"),
            keywords: &["ský", "sól", "sól á bak við stórt ský", "veður"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("molto nuvoloso"),
            keywords: &["coperto", "meteo", "molto nuvoloso", "nuvoloso"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("曇り一時晴れ"),
            keywords: &["天気", "太陽", "曇り", "曇り一時晴れ", "雲"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("srengenge saburine mega gedhe"),
            keywords: &["mega", "srengenge", "srengenge saburine mega gedhe"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მზე დიდი ღრუბლის უკან"),
            keywords: &["ამინდი", "მზე", "მზე დიდი ღრუბლის უკან", "ღრუბელი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("үлкен бұлттың артындағы күн"),
            keywords: &["ауа райы", "бұлт", "күн", "үлкен бұлттың артындағы күн"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("sol bag stor sky"),
            keywords: &["sky", "sol", "sol bag stor sky", "vejr"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ដ\u{17bb}\u{17c6}ពពកធ\u{17c6}បា\u{17c6}ងព\u{17d2}រះអាទ\u{17b7}ត\u{17d2}យ"),
            keywords: &[
                "ដ\u{17bb}\u{17c6}ពពក",
                "ដ\u{17bb}\u{17c6}ពពកធ\u{17c6}បា\u{17c6}ងព\u{17d2}រះអាទ\u{17b7}ត\u{17d2}យ",
                "បា\u{17c6}ង",
                "ព\u{17d2}រះអាទ\u{17b7}ត\u{17d2}យ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ದೊಡ\u{ccd}ಡ ಮೋಡದ ಹ\u{cbf}ಂದ\u{cc6} ಸ\u{cc2}ರ\u{ccd}ಯ"),
            keywords: &[
                "ದೊಡ\u{ccd}ಡ ಮೋಡದ ಹ\u{cbf}ಂದ\u{cc6} ಸ\u{cc2}ರ\u{ccd}ಯ",
                "ಮೋಡ",
                "ಸ\u{cc2}ರ\u{ccd}ಯ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("큰 구름 뒤의 태양"),
            keywords: &["구름", "큰 구름 뒤의 태양", "해", "흐림"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("व\u{94d}हडल\u{94d}या ढगा आडचो स\u{941}र\u{94d}य"),
            keywords: &[
                "ढग",
                "व\u{94d}हडल\u{94d}या ढगा आडचो स\u{941}र\u{94d}य",
                "स\u{941}र\u{94d}य",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("чоң булуттун артындагы күн"),
            keywords: &["аба ырайы", "булут", "күн", "чоң булуттун артындагы күн"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Sonn hannert grouss Wolleken"),
            keywords: &["Sonn", "Sonn hannert grouss Wolleken", "Wollek"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເມກກ\u{ec9}ອນໃຫຍ\u{ec8}ບ\u{ebb}ດບ\u{eb1}ງຕາເວ\u{eb1}ນ"),
            keywords: &[
                "ຕາເວ\u{eb1}ນ",
                "ສະພາບອາກາດ",
                "ເມກ",
                "ເມກກ\u{ec9}ອນໃຫຍ\u{ec8}ບ\u{ebb}ດບ\u{eb1}ງຕາເວ\u{eb1}ນ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("saulė už didelio debesies"),
            keywords: &["debesis", "saulė", "saulė už didelio debesies"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("saule aiz liela mākoņa"),
            keywords: &[
                "laikapstākļi",
                "laiks",
                "mākonis",
                "saule",
                "saule aiz liela mākoņa",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("rā muri kapua nui"),
            keywords: &["kapua", "rā", "rā muri kapua nui"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("сонце зад голем облак"),
            keywords: &["време", "облак", "сонце", "сонце зад голем облак"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("വലിയമേഘങ\u{d4d}ങൾക\u{d4d}ക\u{d4d} പിന\u{d4d}നിലെ സ\u{d42}ര\u{d4d}യൻ"),
            keywords: &[
                "ക\u{d3e}ല\u{d3e}വസ\u{d4d}ഥ",
                "മേഘം",
                "മേഘങ\u{d4d}ങള\u{d41}ം സ\u{d42}ര\u{d4d}യന\u{d41}ം",
                "വലിയമേഘങ\u{d4d}ങൾക\u{d4d}ക\u{d4d} പിന\u{d4d}നിലെ സ\u{d42}ര\u{d4d}യൻ",
                "സ\u{d42}ര\u{d4d}യൻ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("том үүлний цаагуурх нар"),
            keywords: &["нар", "том", "том үүлний цаагуурх нар", "үүл"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("मोठ\u{94d}या ढगामगील स\u{942}र\u{94d}य"),
            keywords: &[
                "ढग",
                "मोठ\u{94d}या ढगामगील स\u{942}र\u{94d}य",
                "मोठ\u{94d}या ढगामागील स\u{942}र\u{94d}य",
                "स\u{942}र\u{94d}य",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("matahari di sebalik awan besar"),
            keywords: &[
                "awan",
                "cuaca",
                "matahari",
                "matahari di sebalik awan besar",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("xemx wara sħaba kbira"),
            keywords: &["sħaba", "xemx", "xemx wara sħaba kbira"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("တ\u{102d}မ\u{103a}တ\u{102d}\u{102f}က\u{103a}ကြ\u{102e}း နောက\u{103a}က နေ"),
            keywords: &[
                "တ\u{102d}မ\u{103a}",
                "တ\u{102d}မ\u{103a}တ\u{102d}\u{102f}က\u{103a}ကြ\u{102e}း နောက\u{103a}က နေ",
                "တ\u{102d}မ\u{103a}တ\u{102d}\u{102f}က\u{103a}ကြ\u{102e}းနောက\u{103a}မ\u{103e} နေထ\u{103d}က\u{103a}ပ\u{102f}\u{1036}",
                "နေ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("sol bak stor sky"),
            keywords: &["sky", "sol", "sol bak stor sky", "vær"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("ठ\u{942}लो बादलपछाडिको स\u{942}र\u{94d}य"),
            keywords: &[
                "ठ\u{942}लो बादलपछाडिको स\u{942}र\u{94d}य",
                "बादल",
                "मौसम",
                "स\u{942}र\u{94d}य",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("zon achter grote wolk"),
            keywords: &["wolk", "zon", "zon achter grote wolk"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("sol bak stor sky"),
            keywords: &["sky", "sol", "sol bak stor sky", "vêr"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ବଡ ମେଘ ପଛରେ ସ\u{b42}ର\u{b4d}ଯ\u{b4d}ୟ"),
            keywords: &[
                "ବଡ ମେଘ ପଛରେ ସ\u{b42}ର\u{b4d}ଯ\u{b4d}ୟ",
                "ବଡ\u{b3c} ମେଘ ପଛରେ ସ\u{b42}ର\u{b4d}ଯ\u{b4d}ୟ",
                "ମେଘ",
                "ସ\u{b42}ର\u{b4d}ଯ\u{b4d}ୟ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਵ\u{a71}ਡ\u{a47} ਬ\u{a71}ਦਲਾ\u{a02} ਵਿ\u{a71}ਚ ਲ\u{a41}ਕਿਆ ਸ\u{a42}ਰਜ"),
            keywords: &[
                "ਧ\u{a41}\u{a71}ਪ",
                "ਬ\u{a71}ਦਲ",
                "ਮ\u{a4c}ਸਮ",
                "ਵ\u{a71}ਡ\u{a47} ਬ\u{a71}ਦਲਾ\u{a02} ਵਿ\u{a71}ਚ ਲ\u{a41}ਕਿਆ ਸ\u{a42}ਰਜ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("وڈے بادل دے پیچھے سورج"),
            keywords: &["بدل", "سورج", "وڈے بادل دے پیچھے سورج"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Sọn Bihaínd Bíg Klaud"),
            keywords: &["Klaud", "Sọn", "Sọn Bihaínd Bíg Klaud"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("słońce za chmurą"),
            keywords: &["chmura", "pogoda", "słońce", "słońce za chmurą"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("لمر د لوی وريځې شا ته"),
            keywords: &["لمر", "لمر د لوی وريځې شا ته", "وريځ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("nublado"),
            keywords: &["clima", "nublado", "nuvem", "sol"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("sol atrás de nuvem grande"),
            keywords: &["meteorologia", "nuvem", "sol", "sol atrás de nuvem grande"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("inti qhipa hatun puyu"),
            keywords: &["inti", "inti qhipa hatun puyu", "puyu"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("soare după un nor mare"),
            keywords: &["nor", "soare", "soare după un nor mare", "vreme"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-234"),
            keywords: &["E10-234"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("солнце за облаком"),
            keywords: &["облако", "солнце", "солнце за облаком", "туча"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("izuba inyuma y’igicu kinini"),
            keywords: &["igicu", "izuba", "izuba inyuma y’igicu kinini"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("وڏن ڪڪرن پويان سج"),
            keywords: &["سج", "وڏن ڪڪرن پويان سج", "ڪڪر"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some(
                "ව\u{dd2}ශ\u{dcf}ල වල\u{dcf}ක\u{dd4}ළකට ප\u{dd2}ට\u{dd4}පස\u{dd2}න\u{dca} සඳ",
            ),
            keywords: &[
                "ක\u{dcf}ලග\u{dd4}ණය",
                "වල\u{dcf}ක\u{dd4}ළ",
                "ව\u{dd2}ශ\u{dcf}ල වල\u{dcf}ක\u{dd4}ළකට ප\u{dd2}ට\u{dd4}පස\u{dd2}න\u{dca} සඳ",
                "ස\u{dd6}ර\u{dca}යය\u{dcf}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("slnko za veľkým oblakom"),
            keywords: &["oblak", "počasie", "slnko", "slnko za veľkým oblakom"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("sonce za velikim oblakom"),
            keywords: &["oblak", "sonce", "sonce za velikim oblakom", "vreme"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("qorrax ka dambaysa daruur weyn"),
            keywords: &["daruur", "qorrax", "qorrax ka dambaysa daruur weyn"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("diell pas reve të mëdha"),
            keywords: &["diell", "diell pas reve të mëdha", "moti", "re"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("сунце иза великог облака"),
            keywords: &["oблaк", "сунцe", "сунце иза великог облака"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["сунце иза великог облака"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("sunce iza velikog oblaka"),
            keywords: &["oblak", "sunce", "sunce iza velikog oblaka"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["sunce iza velikog oblaka"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("sol bakom stort moln"),
            keywords: &["moln", "sol", "sol bakom stort moln", "väder"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("jua nyuma ya wingu kubwa"),
            keywords: &["hali ya hewa", "jua", "jua nyuma ya wingu kubwa", "wingu"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பெரிய மேகத\u{bcd}திற\u{bcd}கு பின\u{bcd}ன\u{bbe}ல\u{bcd} சூரியன\u{bcd}"),
            keywords: &[
                "சூரியன\u{bcd}",
                "பெரிய மேகத\u{bcd}திற\u{bcd}கு பின\u{bcd}ன\u{bbe}ல\u{bcd} சூரியன\u{bcd}",
                "மேகம\u{bcd}",
                "வெப\u{bcd}பநிலை",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ప\u{c46}ద\u{c4d}ద మ\u{c47}ఘం వ\u{c46}నుక ఉన\u{c4d}న సూర\u{c4d}యుడు"),
            keywords: &[
                "ప\u{c46}ద\u{c4d}ద మ\u{c47}ఘం",
                "ప\u{c46}ద\u{c4d}ద మ\u{c47}ఘం వ\u{c46}నుక ఉన\u{c4d}న సూర\u{c4d}యుడు",
                "సూర\u{c4d}యుడు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("офтоб паси абри калон"),
            keywords: &["абр", "офтоб", "офтоб паси абри калон"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เมฆก\u{e49}อนใหญ\u{e48}บ\u{e31}งพระอาท\u{e34}ตย\u{e4c}"),
            keywords: &[
                "พระอาท\u{e34}ตย\u{e4c}",
                "สภาพอากาศ",
                "เมฆ",
                "เมฆก\u{e49}อนใหญ\u{e48}บ\u{e31}งพระอาท\u{e34}ตย\u{e4c}",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("uly buludyň aňrysyndaky güneş"),
            keywords: &["bulut", "güneş", "uly buludyň aňrysyndaky güneş"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("ʻaoʻaofia lahi"),
            keywords: &["ʻaoʻaofia lahi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("bulutta kaybolan güneş"),
            keywords: &["bulut", "bulutta kaybolan güneş", "güneş", "hava durumu"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("چوڭ بۇلۇت ئارقىدا قۇياش"),
            keywords: &["بۇلۇت", "قۇياش", "چوڭ بۇلۇت ئارقىدا قۇياش"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("сонце за хмариною"),
            keywords: &["погода", "сонце", "сонце за хмариною", "хмара"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("بڑے بادل کے پیچھے چھپا سورج"),
            keywords: &["بادل", "بڑے بادل کے پیچھے چھپا سورج", "سورج", "موسم"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("bulutlar ortidagi quyosh"),
            keywords: &["bulut", "bulutlar ortidagi quyosh", "ob-havo", "quyosh"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("mặt trời sau đám mây lớn"),
            keywords: &["mây", "mặt trời", "mặt trời sau đám mây lớn"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("jant ci ginaaw niir wu rëy"),
            keywords: &["jant ci ginaaw niir wu rëy", "niir", "sun"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ilanga elisemva kwelifu elikhulu"),
            keywords: &["ilanga", "ilanga elisemva kwelifu elikhulu", "ilifu"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("òòrùn lẹ\u{301}yìn òfurufú tó tóbi"),
            keywords: &["òfurufú", "òòrùn", "òòrùn lẹ\u{301}yìn òfurufú tó tóbi"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("大雲後嘅太陽"),
            keywords: &["大雲後嘅太陽", "太陽", "雲"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("大云后嘅太阳"),
            keywords: &["云", "大云后嘅太阳", "太阳"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("多云"),
            keywords: &["云", "多云", "太阳"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("晴時多雲"),
            keywords: &["天氣", "晴時多雲"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("太陽喺一大片雲後面"),
            keywords: &["天氣", "太陽喺一大片雲後面"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ilanga elingemuva kwef elikhul"),
            keywords: &[
                "ifu",
                "ilanga",
                "ilanga elingemuva kwef elikhul",
                "isimo sezulu",
            ],
        },
    ],
};
#[doc = "🌦\u{fe0f}"]
pub const SUN_BEHIND_RAIN_CLOUD: crate::Emoji = crate::Emoji {
    glyph: "🌦\u{fe0f}",
    codepoint: "1F326 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.7f32,
    name: "sun behind rain cloud",
    group: "Travel & Places",
    subgroup: "sky & weather",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🌦",
        codepoint: "1F326",
        status: crate::Status::Unqualified,
        introduction_version: 0.7f32,
        name: "sun behind rain cloud",
        group: "Travel & Places",
        subgroup: "sky & weather",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("son agter wolk met reën"),
            keywords: &["reën", "son", "son agter wolk met reën", "weer", "wolk"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ዝናብ ካለው ደመና ጀርባ ያለች ፀሐይ"),
            keywords: &["ዝናብ", "ዝናብ ካለው ደመና ጀርባ ያለች ፀሐይ", "የአየር ንብረት", "ደመና", "ፀሐይ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("شمس خلف سحابة ومطر"),
            keywords: &["سحب", "شمس", "شمس خلف سحابة ومطر", "طقس", "مطر"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("বৰষ\u{9c1}ণৰ পিছফ\u{9be}লে স\u{9c2}ৰ\u{9cd}য\u{9cd}য"),
            keywords: &[
                "ড\u{9be}ৱৰ",
                "বৰষ\u{9c1}ণ",
                "বৰষ\u{9c1}ণৰ পিছফ\u{9be}লে স\u{9c2}ৰ\u{9cd}য\u{9cd}য",
                "স\u{9c2}ৰ\u{9cd}য\u{9cd}য",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("yağışlı buludun arxasında günəş"),
            keywords: &[
                "bulud",
                "günəş",
                "hava",
                "yağış",
                "yağışlı buludun arxasında günəş",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("сонца за дажджавой хмарай"),
            keywords: &[
                "дождж",
                "надвор’е",
                "сонца",
                "сонца за дажджавой хмарай",
                "хмара",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Слънце зад облак с дъжд"),
            keywords: &[
                "Слънце зад облак с дъжд",
                "време",
                "дъжд",
                "облак",
                "слънце",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("মেঘের স\u{9be}থে ব\u{9c3}ষ\u{9cd}টির পিছনে স\u{9c2}র\u{9cd}য"),
            keywords: &[
                "আবহ\u{9be}ওয\u{9bc}\u{9be}",
                "ব\u{9c3}ষ\u{9cd}টি",
                "মেঘ",
                "মেঘের স\u{9be}থে ব\u{9c3}ষ\u{9cd}টির পিছনে স\u{9c2}র\u{9cd}য",
                "স\u{9c2}র\u{9cd}য",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("heol a-dreñv dʼur goumoulenn cʼhlav"),
            keywords: &["heol", "heol a-dreñv dʼur goumoulenn cʼhlav", "koumoul"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("umjereno oblačno s kišom"),
            keywords: &[
                "kiša",
                "oblaci",
                "prognoza",
                "umjereno oblačno s kišom",
                "vrijeme",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("sol darrere d’un núvol amb pluja"),
            keywords: &[
                "núvol",
                "pluja",
                "sol",
                "sol darrere d’un núvol amb pluja",
                "temps",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏅᏓ ᎢᎦ ᎡᎯ ᏧᏘᏍᏓ ᎠᎦᏍᎩᎢ ᏧᎶᎩᎸᎢ ᎣᏂᏗᏢᎢ"),
            keywords: &[
                "ᎠᎦᏍᎩ",
                "ᎤᎶᎩᎳ",
                "ᏅᏓ ᎢᎦ ᎡᎯ",
                "ᏅᏓ ᎢᎦ ᎡᎯ ᏧᏘᏍᏓ ᎠᎦᏍᎩᎢ ᏧᎶᎩᎸᎢ ᎣᏂᏗᏢᎢ",
            ],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("slunce za dešťovým mrakem"),
            keywords: &[
                "déšť",
                "mrak",
                "oblak",
                "počasí",
                "slunce",
                "slunce za dešťovým mrakem",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("haul tu ôl i gwmwl gyda glaw"),
            keywords: &[
                "cwmwl",
                "glaw",
                "haul",
                "haul tu ôl i gwmwl gyda glaw",
                "tywydd",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("sol bag sky med regn"),
            keywords: &["regn", "sky", "sol", "sol bag sky med regn", "vejr"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Sonne hinter Regenwolke"),
            keywords: &["Regenwolke", "Sonne", "Sonne hinter Regenwolke", "Wetter"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ήλιος πίσω από σύννεφο με βροχή"),
            keywords: &[
                "ήλιος",
                "ήλιος πίσω από σύννεφο με βροχή",
                "βροχή",
                "καιρός",
                "σύννεφο",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("sun behind rain cloud"),
            keywords: &["cloud", "rain", "sun", "sun behind rain cloud"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("sol detrás de una nube con lluvia"),
            keywords: &["lluvia", "nube", "sol", "sol detrás de una nube con lluvia"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("soleado con lluvia"),
            keywords: &["clima", "lluvia", "nube", "sol", "soleado con lluvia"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("päike vihmapilve taga"),
            keywords: &["ilm", "pilv", "päike", "päike vihmapilve taga", "vihm"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("eguzkia hodei baten atzean euriarekin"),
            keywords: &[
                "eguraldi",
                "eguzki",
                "eguzkia hodei baten atzean euriarekin",
                "euri",
                "hodei",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("خورشید پشت ابر بارانی"),
            keywords: &[
                "آب\u{200c}وهوا",
                "ابر",
                "باران",
                "خورشید",
                "خورشید پشت ابر بارانی",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("aurinko sadepilvessä"),
            keywords: &["aurinko", "aurinko sadepilvessä", "pilvi", "sade", "sää"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("araw sa likod ng ulap na may ulan"),
            keywords: &[
                "araw",
                "araw sa likod ng ulap na may ulan",
                "lagay ng panahon",
                "ulan",
                "ulap",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("sólin aftanfyri eitt regnskýggj"),
            keywords: &[
                "avfall",
                "regn",
                "sól",
                "sólarglottar",
                "sólglottur",
                "sólin aftanfyri eitt regnskýggj",
                "veðrið",
                "veður",
                "yvirskýggja",
                "æl",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("soleil derrière un nuage de pluie"),
            keywords: &["nuage", "soleil derrière un nuage de pluie"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("soleil derrière un nuage de pluie"),
            keywords: &[
                "nuage",
                "nuage de pluie",
                "soleil",
                "soleil derrière un nuage de pluie",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("grian taobh thiar de scamall le fearthainn"),
            keywords: &[
                "aimsir",
                "fearthainn",
                "grian",
                "grian taobh thiar de scamall le fearthainn",
                "scamall",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("a’ ghrian air cùl sgòtha uisge"),
            keywords: &[
                "a’ ghrian air cùl sgòtha uisge",
                "grian",
                "neul",
                "sgòth",
                "uisge",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("ceo cuberto con choiva"),
            keywords: &[
                "ceo cuberto con choiva",
                "choiva",
                "meteoroloxía",
                "nube",
                "sol",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("વરસાદ સાથ\u{ac7}ના વાદળાની પાછળ સ\u{ac2}ર\u{acd}ય"),
            keywords: &[
                "વરસાદ",
                "વરસાદ સાથ\u{ac7}ના વાદળાની પાછળ સ\u{ac2}ર\u{acd}ય",
                "સ\u{ac2}ર\u{acd}ય",
                "હવામાન",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("rana a bayan gajimaren ruwan sama"),
            keywords: &[
                "gajimare",
                "rana",
                "rana a bayan gajimaren ruwan sama",
                "ruwan sama",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("שמש מאחורי ענן עם גשם"),
            keywords: &["גשם", "חורף", "ענן", "שמש", "שמש מאחורי ענן עם גשם"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("बारिश वाल\u{947} बादल क\u{947} पीछ\u{947}"),
            keywords: &[
                "बादलो\u{902} म\u{947}\u{902} छिपा स\u{942}रज",
                "बारिश और स\u{942}रज",
                "बारिश वाल\u{947} बादल क\u{947} पीछ\u{947}",
                "मौसम",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("sunce iza kišnog oblaka"),
            keywords: &[
                "kiša",
                "oblak",
                "sunce",
                "sunce iza kišnog oblaka",
                "sunce iza oblaka s kišom",
                "vrijeme",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("nap a felhő mögött esővel"),
            keywords: &[
                "eső",
                "felhő",
                "időjárás",
                "nap",
                "nap a felhő mögött esővel",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("արև անձրևով ամպի հետևում"),
            keywords: &["ամպ", "անձրև", "արև", "արև անձրևով ամպի հետևում", "եղանակ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("matahari di balik awan hujan"),
            keywords: &[
                "awan",
                "cuaca",
                "hujan",
                "matahari",
                "matahari di balik awan hujan",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("anyanwụ n’àzụ urukpu mmiri òzùzò"),
            keywords: &[
                "anyanwụ",
                "anyanwụ n’àzụ urukpu mmiri òzùzò",
                "mmiri òzùzò",
                "urukpu",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("sól á bak við regnský"),
            keywords: &["regn", "ský", "sól", "sól á bak við regnský", "veður"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("sole coperto e pioggia"),
            keywords: &["meteo", "pioggia", "sole", "sole coperto e pioggia"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("雨時々晴れ"),
            keywords: &["天気", "天気雨", "太陽", "曇り", "雨時々晴れ", "雲"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("srengenge saburine mega ngemu udan"),
            keywords: &[
                "mega",
                "srengenge",
                "srengenge saburine mega ngemu udan",
                "udan",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მზე წვიმიანი ღრუბლის უკან"),
            keywords: &[
                "ამინდი",
                "მზე",
                "მზე წვიმიანი ღრუბლის უკან",
                "ღრუბელი",
                "წვიმა",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("жаңбыр жауып тұрған бұлттың артындағы күн"),
            keywords: &[
                "ауа райы",
                "бұлт",
                "жаңбыр",
                "жаңбыр жауып тұрған бұлттың артындағы күн",
                "күн",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("sol bag sky med regn"),
            keywords: &["regn", "sky", "sol", "sol bag sky med regn", "vejr"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some(
                "ពពកបា\u{17c6}ងព\u{17d2}រះអាទ\u{17b7}ត\u{17d2}យមានភ\u{17d2}លៀងធ\u{17d2}លាក\u{17cb}",
            ),
            keywords: &[
                "ពពក",
                "ពពកបា\u{17c6}ងព\u{17d2}រះអាទ\u{17b7}ត\u{17d2}យមានភ\u{17d2}លៀងធ\u{17d2}លាក\u{17cb}",
                "ព\u{17d2}រះអាទ\u{17b7}ត\u{17d2}យ",
                "ភ\u{17d2}លៀង",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಬ\u{cbf}ಸ\u{cbf}ಲು ಮಳ\u{cc6}"),
            keywords: &[
                "ಬ\u{cbf}ಸ\u{cbf}ಲು ಮಳ\u{cc6}",
                "ಮಳ\u{cc6}",
                "ಮೇಘ",
                "ಮೋಡ",
                "ಹವಾಮಾನ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("비구름 뒤의 태양"),
            keywords: &["구름", "비", "비구름 뒤의 태양", "해"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("पावसाच\u{94d}या ढगा आडचो स\u{941}र\u{94d}य"),
            keywords: &[
                "ढग",
                "पावस",
                "पावसाच\u{94d}या ढगा आडचो स\u{941}र\u{94d}य",
                "स\u{941}र\u{94d}य",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("жамгыр жааган булуттун артындагы күн"),
            keywords: &[
                "аба ырайы",
                "булут",
                "жамгыр",
                "жамгыр жааган булуттун артындагы күн",
                "жамгыр жаап жаткан булуттун артындагы күн",
                "күн",
            ],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Sonn hannert Reewollek"),
            keywords: &["Reen", "Sonn", "Sonn hannert Reewollek", "Wollek"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເມກຝ\u{ebb}ນບ\u{ebb}ດບ\u{eb1}ງຕາເວ\u{eb1}ນ"),
            keywords: &[
                "ຕາເວ\u{eb1}ນ",
                "ຝ\u{ebb}ນ",
                "ສະພາບອາກາດ",
                "ເມກ",
                "ເມກຝ\u{ebb}ນບ\u{ebb}ດບ\u{eb1}ງຕາເວ\u{eb1}ນ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("saulė už debesies, iš kurio lyja"),
            keywords: &[
                "debesis",
                "lietus",
                "saulė",
                "saulė už debesies, iš kurio lyja",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("saule aiz lietus mākoņa"),
            keywords: &[
                "laikapstākļi",
                "laiks",
                "lietus",
                "mākonis",
                "saule",
                "saule aiz lietus mākoņa",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("rā muri kapua ua"),
            keywords: &["kapua", "rā", "rā muri kapua ua", "ua"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("сонце зад облак со дожд"),
            keywords: &["време", "дожд", "облак", "сонце", "сонце зад облак со дожд"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("മഴമേഘങ\u{d4d}ങൾക\u{d4d}ക\u{d4d} പിന\u{d4d}നിലെ സ\u{d42}ര\u{d4d}യൻ"),
            keywords: &[
                "ക\u{d3e}ല\u{d3e}വസ\u{d4d}ഥ",
                "മഴ",
                "മഴമേഘങ\u{d4d}ങൾ",
                "മഴമേഘങ\u{d4d}ങൾക\u{d4d}ക\u{d4d} പിന\u{d4d}നിലെ സ\u{d42}ര\u{d4d}യൻ",
                "മേഘം",
                "സ\u{d42}ര\u{d4d}യൻ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("бороотой үүлний цаагуурх нар"),
            keywords: &["бороо", "бороотой үүлний цаагуурх нар", "нар", "үүл"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("पावसासह ढगामागील स\u{942}र\u{94d}य"),
            keywords: &[
                "ढग",
                "पाऊस",
                "पावसाच\u{94d}या ढगामागील स\u{942}र\u{94d}य",
                "पावसासह ढगामागील स\u{942}र\u{94d}य",
                "स\u{942}र\u{94d}य",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("matahari di sebalik awan hujan"),
            keywords: &[
                "awan",
                "cuaca",
                "hujan",
                "matahari",
                "matahari di sebalik awan hujan",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("xemx wara sħaba tax-xita"),
            keywords: &["sħaba", "xemx", "xemx wara sħaba tax-xita", "xita"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "မ\u{102d}\u{102f}းန\u{103e}င\u{1037}\u{103a}တ\u{102d}မ\u{103a}နောက\u{103a}က နေ",
            ),
            keywords: &[
                "တ\u{102d}မ\u{103a}",
                "နေ",
                "မ\u{102d}\u{102f}း",
                "မ\u{102d}\u{102f}းတ\u{102d}မ\u{103a}အက\u{103d}ယ\u{103a}မ\u{103e} နေ",
                "မ\u{102d}\u{102f}းန\u{103e}င\u{1037}\u{103a}တ\u{102d}မ\u{103a}နောက\u{103a}က နေ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("sol bak sky med regn"),
            keywords: &["regn", "sky", "sol", "sol bak sky med regn", "vær"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("बादल पानीको साथमा घाम"),
            keywords: &[
                "घाम",
                "बादल",
                "बादल पानीको साथमा घाम",
                "मौ\u{902}सम",
                "वर\u{94d}षा",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("zon achter regenwolk"),
            keywords: &["regen", "wolk", "zon", "zon achter regenwolk"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("sol bak sky med regn"),
            keywords: &["regn", "sky", "sol", "sol bak sky med regn", "vêr"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ବର\u{b4d}ଷ\u{b3e} ବ\u{b3e}ଦଳ ପଛରେ ସ\u{b42}ର\u{b4d}ଯ\u{b4d}ୟ"),
            keywords: &[
                "ବର\u{b4d}ଷ\u{b3e}",
                "ବର\u{b4d}ଷ\u{b3e} ବ\u{b3e}ଦଲ ପଛରେ ସ\u{b42}ର\u{b4d}ଯ\u{b4d}ୟ",
                "ବର\u{b4d}ଷ\u{b3e} ବ\u{b3e}ଦଳ ପଛରେ ସ\u{b42}ର\u{b4d}ଯ\u{b4d}ୟ",
                "ମେଘ",
                "ସ\u{b42}ର\u{b4d}ଯ\u{b4d}ୟ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਬ\u{a71}ਦਲਾ\u{a02} ਵਿ\u{a71}ਚ ਲ\u{a41}ਕਿਆ ਸ\u{a42}ਰਜ ਅਤ\u{a47} ਮੀ\u{a02}ਹ"),
            keywords: &[
                "ਧ\u{a41}\u{a71}ਪ",
                "ਬ\u{a71}ਦਲ",
                "ਬ\u{a71}ਦਲਾ\u{a02} ਵਿ\u{a71}ਚ ਲ\u{a41}ਕਿਆ ਸ\u{a42}ਰਜ ਅਤ\u{a47} ਮੀ\u{a02}ਹ",
                "ਮੀ\u{a02}\u{a02}ਹ ਦਾ ਮ\u{a4c}ਸਮ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("مینہ دے بادل پیچھے سورج"),
            keywords: &["بدل", "سورج", "مینہ", "مینہ دے بادل پیچھے سورج"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Sọn Bihaínd Klaud Wé De Bríng Ren"),
            keywords: &["Klaud", "Ren", "Sọn", "Sọn Bihaínd Klaud Wé De Bríng Ren"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("słońce za chmurą i deszcz"),
            keywords: &[
                "chmura",
                "deszcz",
                "pogoda",
                "słońce",
                "słońce za chmurą i deszcz",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("لمر د باران د وريځ شا ته"),
            keywords: &["باران", "لمر", "لمر د باران د وريځ شا ته", "وريځ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("sol com chuva"),
            keywords: &["chuva", "clima", "nuvem", "sol", "sol com chuva"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("sol atrás de nuvem com chuva"),
            keywords: &[
                "chuva",
                "meteorologia",
                "nuvem",
                "sol",
                "sol atrás de nuvem com chuva",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("inti qhipa para puyupi"),
            keywords: &["inti", "inti qhipa para puyupi", "para", "puyu"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("soare după nor cu ploaie"),
            keywords: &["nor", "ploaie", "soare", "soare după nor cu ploaie"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-235"),
            keywords: &["E10-235"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("слепой дождь"),
            keywords: &[
                "грибной дождь",
                "дождь",
                "облако",
                "осадки",
                "слепой дождь",
                "солнце",
                "туча",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("izuba inyuma y’igicu kirimo imvura"),
            keywords: &[
                "igicu",
                "imvura",
                "izuba",
                "izuba inyuma y’igicu kirimo imvura",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("برساتي ڪڪرن پٺيان سج"),
            keywords: &["برساتي ڪڪرن پٺيان سج", "سج", "ٻرسات", "ڪڪر"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("වැස\u{dd2} වල\u{dcf}ක\u{dd4}ළකට ප\u{dd2}ට\u{dd4}පස\u{dd2}න\u{dca} සඳ"),
            keywords: &[
                "ක\u{dcf}ලග\u{dd4}ණය",
                "වල\u{dcf}ක\u{dd4}ළ",
                "වැස\u{dca}ස",
                "වැස\u{dd2} වල\u{dcf}ක\u{dd4}ළකට ප\u{dd2}ට\u{dd4}පස\u{dd2}න\u{dca} සඳ",
                "ස\u{dd6}ර\u{dca}යය\u{dcf}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("slnko za dažďovým oblakom"),
            keywords: &[
                "dážď",
                "oblak",
                "počasie",
                "slnko",
                "slnko za dažďovým oblakom",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("sonce za oblakom z dežjem"),
            keywords: &[
                "dež",
                "oblak",
                "sonce",
                "sonce za oblakom z dežjem",
                "vreme",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("qorrax ka dambaysa daruur roobeed"),
            keywords: &[
                "daruur",
                "qorrax",
                "qorrax ka dambaysa daruur roobeed",
                "roob",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("diell pas reve me shi"),
            keywords: &["diell", "diell pas reve me shi", "moti", "re", "shi"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("сунце иза кишног облака"),
            keywords: &["oблaк", "кишa", "сунцe", "сунце иза кишног облака"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["сунце иза кишног облака"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("sunce iza kišnog oblaka"),
            keywords: &["kiša", "oblak", "sunce", "sunce iza kišnog oblaka"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["sunce iza kišnog oblaka"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("sol bakom moln med regn"),
            keywords: &["moln", "regn", "sol", "sol bakom moln med regn", "väder"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("jua nyuma ya wingu lenye mvua"),
            keywords: &[
                "hali ya jewa",
                "jua",
                "jua nyuma ya wingu lenye mvua",
                "mvua",
                "wingu",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some(
                "மழை பெய\u{bcd}யும\u{bcd} மேகத\u{bcd}திற\u{bcd}கு பின\u{bcd}ன\u{bbe}ல\u{bcd} சூரியன\u{bcd}",
            ),
            keywords: &[
                "சூரியன\u{bcd}",
                "மழை",
                "மழை பெய\u{bcd}யும\u{bcd} மேகத\u{bcd}திற\u{bcd}கு பின\u{bcd}ன\u{bbe}ல\u{bcd} சூரியன\u{bcd}",
                "மேகம\u{bcd}",
                "வெப\u{bcd}பநிலை",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("వ\u{c3e}నల\u{c4b} మ\u{c47}ఘం వ\u{c46}నుక ఉన\u{c4d}న సూర\u{c4d}యుడు"),
            keywords: &[
                "మ\u{c47}ఘం",
                "వ\u{c3e}న",
                "వ\u{c3e}నల\u{c4b} మ\u{c47}ఘం వ\u{c46}నుక ఉన\u{c4d}న సూర\u{c4d}యుడు",
                "సూర\u{c4d}యుడు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("офтоб паси абри боронӣ"),
            keywords: &["абр", "борон", "офтоб", "офтоб паси абри боронӣ"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เมฆฝนบดบ\u{e31}งพระอาท\u{e34}ตย\u{e4c}"),
            keywords: &[
                "ฝน",
                "พระอาท\u{e34}ตย\u{e4c}",
                "สภาพอากาศ",
                "เมฆ",
                "เมฆฝนบดบ\u{e31}งพระอาท\u{e34}ตย\u{e4c}",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ýagyşly buludyň aňrysyndaky güneş"),
            keywords: &[
                "bulut",
                "güneş",
                "ýagyş",
                "ýagyşly buludyň aňrysyndaky güneş",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("ʻaoʻaofia ʻuha"),
            keywords: &["ʻaoʻaofia ʻuha"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("yağmur bulutunun arkasındaki güneş"),
            keywords: &[
                "bulut",
                "güneş",
                "hava durumu",
                "yağmur",
                "yağmur bulutunun arkasındaki güneş",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("يامغۇرلۇق بۇلۇت ئارقىدا قۇياش"),
            keywords: &["بۇلۇت", "قۇياش", "يامغۇر", "يامغۇرلۇق بۇلۇت ئارقىدا قۇياش"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("сонце за дощовою хмарою"),
            keywords: &["дощ", "погода", "сонце", "сонце за дощовою хмарою", "хмара"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("بارش کے بادل پیچھے چھپا سورج"),
            keywords: &[
                "بادل",
                "بارش",
                "بارش کے بادل پیچھے چھپا سورج",
                "سورج",
                "موسم",
            ],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("yomg‘irli bulutlar ortidagi quyosh"),
            keywords: &[
                "bulut",
                "ob-havo",
                "quyosh",
                "yomg‘ir",
                "yomg‘irli bulutlar ortidagi quyosh",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("mặt trời sau đám mây mưa"),
            keywords: &["mây", "mưa", "mặt trời", "mặt trời sau đám mây mưa"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("jant ci ginaaw taw niir"),
            keywords: &["jant", "jant ci ginaaw taw niir", "niir", "taw"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ilanga elisemva kwelifu lemvula"),
            keywords: &[
                "ilanga",
                "ilanga elisemva kwelifu lemvula",
                "ilifu",
                "imvula",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("òòrùn lẹ\u{301}yìn òfurufú òjò"),
            keywords: &["òfurufú", "òjò", "òòrùn", "òòrùn lẹ\u{301}yìn òfurufú òjò"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("雨雲後嘅太陽"),
            keywords: &["太陽", "雨", "雨雲後嘅太陽", "雲"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("雨云后嘅太阳"),
            keywords: &["云", "太阳", "雨", "雨云后嘅太阳"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("晴转雨"),
            keywords: &["云", "太阳", "晴转雨", "雨"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("晴時有雨"),
            keywords: &["天氣", "晴時有雨"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("太陽喺雨雲後面"),
            keywords: &["天氣", "太陽喺雨雲後面"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ilanga elingemuva kwefu elinemvula"),
            keywords: &[
                "ifu",
                "ilanga",
                "ilanga elingemuva kwefu elinemvula",
                "imvula",
                "isimo sezulu",
            ],
        },
    ],
};
#[doc = "🌧\u{fe0f}"]
pub const CLOUD_WITH_RAIN: crate::Emoji = crate::Emoji {
    glyph: "🌧\u{fe0f}",
    codepoint: "1F327 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.7f32,
    name: "cloud with rain",
    group: "Travel & Places",
    subgroup: "sky & weather",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🌧",
        codepoint: "1F327",
        status: crate::Status::Unqualified,
        introduction_version: 0.7f32,
        name: "cloud with rain",
        group: "Travel & Places",
        subgroup: "sky & weather",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("wolk met reën"),
            keywords: &["reën", "weer", "wolk", "wolk met reën"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ደመና ከዝናብ ጋር"),
            keywords: &["ዝናብ", "የአየር ንብረት", "ደመና", "ደመና ከዝናብ ጋር"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("سحابة ومطر"),
            keywords: &["سحابة ومطر", "سحب", "طقس", "مطر"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("বৰষ\u{9c1}ণৰ সৈতে ড\u{9be}ৱৰ"),
            keywords: &["ড\u{9be}ৱৰ", "বৰষ\u{9c1}ণ", "বৰষ\u{9c1}ণৰ সৈতে ড\u{9be}ৱৰ"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("yağışlı bulud"),
            keywords: &["bulud", "hava", "yağış", "yağışlı bulud"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("хмара і дождж"),
            keywords: &["ападкі", "дождж", "надвор’е", "хмара", "хмара і дождж"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("облак с дъжд"),
            keywords: &["време", "дъжд", "облак", "облак с дъжд"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ব\u{9c3}ষ\u{9cd}টির স\u{9be}থে মেঘ"),
            keywords: &[
                "আবহ\u{9be}ওয\u{9bc}\u{9be}",
                "ব\u{9c3}ষ\u{9cd}টি",
                "ব\u{9c3}ষ\u{9cd}টির স\u{9be}থে মেঘ",
                "মেঘ",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("koumoulenn gant glav"),
            keywords: &["glav", "koumoul", "koumoulenn gant glav"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("oblačno s kišom"),
            keywords: &["kiša", "oblaci", "oblačno s kišom", "prognoza", "vrijeme"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("núvol amb pluja"),
            keywords: &["núvol", "núvol amb pluja", "pluja", "temps"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᎶᎩᎳ ᎠᎦᏍᎩ"),
            keywords: &["ᎠᎦᏍᎩ", "ᎤᎶᎩᎳ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("mrak s deštěm"),
            keywords: &["déšť", "mrak", "mrak s deštěm", "oblak", "počasí"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("cwmwl gyda glaw"),
            keywords: &["cwmwl", "cwmwl gyda glaw", "glaw", "tywydd"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("sky med regn"),
            keywords: &["regn", "sky", "sky med regn", "vejr"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Wolke mit Regen"),
            keywords: &["Regen", "Regenwolke", "Wetter", "Wolke", "Wolke mit Regen"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("σύννεφο με βροχή"),
            keywords: &["βροχή", "καιρός", "σύννεφο", "σύννεφο με βροχή"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("cloud with rain"),
            keywords: &["cloud", "cloud with rain", "rain"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("nube con lluvia"),
            keywords: &["lluvia", "nube", "nube con lluvia"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("lluvia"),
            keywords: &["clima", "lluvia", "nube"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("vihmapilv"),
            keywords: &["ilm", "pilv", "vihm", "vihmapilv"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("hodeia euriarekin"),
            keywords: &["eguraldi", "euri", "hodei", "hodeia euriarekin"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("ابر بارانی"),
            keywords: &["آب\u{200c}وهوا", "ابر", "ابر بارانی", "باران"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("sadepilvi"),
            keywords: &["pilvi", "sade", "sadepilvi", "sää"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("ulap na may ulan"),
            keywords: &[
                "lagay ng panahon",
                "panahon",
                "ulan",
                "ulap",
                "ulap na may ulan",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("skýggj og regn"),
            keywords: &["avfall", "regn", "skýggj og regn", "veðrið", "veður", "æl"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("nuage avec pluie"),
            keywords: &[
                "averse",
                "mauvais temps",
                "météo",
                "nuage avec pluie",
                "pluie",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("nuage de pluie"),
            keywords: &["nuage", "nuage de pluie", "pluie"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("scamall le fearthainn"),
            keywords: &["aimsir", "fearthainn", "scamall", "scamall le fearthainn"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("sgòth le uisge"),
            keywords: &["neul", "sgòth", "sgòth le uisge", "uisge"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("choiva"),
            keywords: &["choiva", "chuvia", "meteoroloxía", "nube"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("વરસાદ સાથ\u{ac7}નો વાદળ\u{ac1}\u{a82}"),
            keywords: &[
                "વરસાદ",
                "વરસાદ સાથ\u{ac7}નો વાદળ\u{ac1}\u{a82}",
                "વર\u{acd}ષા",
                "હવામાન",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("gajimare tare da ruwan sama"),
            keywords: &["gajimare", "gajimare tare da ruwan sama", "ruwan sama"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("ענן עם גשם"),
            keywords: &["גשם", "חורף", "ענן", "ענן עם גשם"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("बारिश क\u{947} साथ बादल"),
            keywords: &["बारिश क\u{947} साथ बादल", "मौसम"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("oblak s kišom"),
            keywords: &["kiša", "oblak", "oblak s kišom", "vrijeme"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("felhő esővel"),
            keywords: &["eső", "felhő", "felhő esővel", "időjárás"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("անձրևով ամպ"),
            keywords: &["ամպ", "անձրև", "անձրևով ամպ", "եղանակ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("awan hujan"),
            keywords: &["awan", "cuaca", "hujan"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("urukpu nwere mmiri òzùzò"),
            keywords: &["mmiri òzùzò", "urukpu", "urukpu nwere mmiri òzùzò"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("regnský"),
            keywords: &["regn", "regnský", "ský", "veður"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("pioggia"),
            keywords: &["meteo", "nuvole", "pioggia"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("雨雲"),
            keywords: &["天気", "雨", "雨雲", "雲"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("mega ngemu udan"),
            keywords: &["mega", "mega ngemu udan", "udan"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ღრუბელი წვიმით"),
            keywords: &["ამინდი", "ღრუბელი", "ღრუბელი წვიმით", "წვიმა"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("жаңбыр жауып тұрған бұлт"),
            keywords: &["ауа райы", "бұлт", "жаңбыр жауып тұрған бұлт", "күн"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("sky med regn"),
            keywords: &["regn", "sky", "sky med regn", "vejr"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ពពកមានភ\u{17d2}លៀងធ\u{17d2}លាក\u{17cb}"),
            keywords: &[
                "ពពក",
                "ពពកមានភ\u{17d2}លៀងធ\u{17d2}លាក\u{17cb}",
                "ភ\u{17d2}លៀង",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಮೋಡದ ಜೊತ\u{cc6} ಮಳ\u{cc6}"),
            keywords: &[
                "ಮಳ\u{cc6}",
                "ಮೇಘ",
                "ಮೋಡ",
                "ಮೋಡದ ಜೊತ\u{cc6} ಮಳ\u{cc6}",
                "ಹವಾಮಾನ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("비구름"),
            keywords: &["구름", "비", "비구름"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("पावसाचो ढग"),
            keywords: &["ढग", "पावस", "पावसाचो ढग"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("жамгыр жаап жаткан булут"),
            keywords: &["аба ырайы", "булут", "жамгыр", "жамгыр жаап жаткан булут"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Wollek mat Reen"),
            keywords: &["Reen", "Wollek", "Wollek mat Reen"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເມກຝ\u{ebb}ນ"),
            keywords: &["ຝ\u{ebb}ນ", "ສະພາບອາກາດ", "ເມກ", "ເມກຝ\u{ebb}ນ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("debesis, iš kurio lyja"),
            keywords: &["debesis", "debesis, iš kurio lyja", "lietus"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("lietus mākonis"),
            keywords: &["laikapstākļi", "laiks", "lietus", "mākonis"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kapua me te ua"),
            keywords: &["kapua", "kapua me te ua", "ua"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("облак со дожд"),
            keywords: &["време", "дожд", "облак", "облак со дожд"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("മഴയ\u{d41}ം മേഘവ\u{d41}ം"),
            keywords: &[
                "ക\u{d3e}ല\u{d3e}വസ\u{d4d}ഥ",
                "മഴ",
                "മഴയ\u{d41}ം മേഘവ\u{d41}ം",
                "മേഘം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("бороотой үүл"),
            keywords: &["бороо", "бороотой үүл", "үүл"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("पावसासह ढग"),
            keywords: &["ढग", "पाऊस", "पावसासह ढग"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("awan dengan hujan"),
            keywords: &["awan", "awan dengan hujan", "cuaca", "hujan"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("sħaba bix-xita"),
            keywords: &["sħaba", "sħaba bix-xita", "xita"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("မ\u{102d}\u{102f}းန\u{103e}င\u{1037}\u{103a} တ\u{102d}မ\u{103a}"),
            keywords: &[
                "တ\u{102d}မ\u{103a}",
                "မ\u{102d}\u{102f}း",
                "မ\u{102d}\u{102f}းန\u{103e}င\u{1037}\u{103a} တ\u{102d}မ\u{103a}",
                "မ\u{102d}\u{102f}းန\u{103e}င\u{1037}\u{103a} တ\u{102d}မ\u{103a}တ\u{102d}\u{102f}က\u{103a}ပ\u{102f}\u{1036}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("sky med regn"),
            keywords: &["regn", "sky", "sky med regn", "vær"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("बादलसहितको वर\u{94d}षा"),
            keywords: &[
                "बादल",
                "बादलसहितको वर\u{94d}षा",
                "मौ\u{902}सम",
                "वर\u{94d}षा",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("wolk met regen"),
            keywords: &["regen", "wolk", "wolk met regen"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("sky med regn"),
            keywords: &["regn", "sky", "sky med regn", "vêr"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ବର\u{b4d}ଷ\u{b3e} ସହ\u{b3f}ତ ମେଘ"),
            keywords: &[
                "ବର\u{b4d}ଷ\u{b3e}",
                "ବର\u{b4d}ଷ\u{b3e} ସହ\u{b3f}ତ ମେଘ",
                "ମେଘ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਬ\u{a71}ਦਲ ਅਤ\u{a47} ਮੀ\u{a02}ਹ"),
            keywords: &[
                "ਬ\u{a71}ਦਲ",
                "ਬ\u{a71}ਦਲ ਅਤ\u{a47} ਮੀ\u{a02}ਹ",
                "ਮੀ\u{a02}ਹ ਦਾ ਮ\u{a4c}ਸਮ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("بادل نال مینہ"),
            keywords: &["بادل نال مینہ", "بدل", "مینہ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Klaud Wit Ren"),
            keywords: &["Klaud", "Klaud Wit Ren", "Ren"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("chmura i deszcz"),
            keywords: &["chmura", "chmura i deszcz", "deszcz", "pogoda"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ورېځ سره باران"),
            keywords: &["باران", "وريځ", "وريځ سره باران", "ورېځ سره باران"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("nuvem com chuva"),
            keywords: &["chuva", "clima", "nuvem", "nuvem com chuva"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["chuva", "meteorologia", "nuvem", "nuvem com chuva"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("puyu parawan"),
            keywords: &["para", "puyu", "puyu parawan"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("nor cu ploaie"),
            keywords: &["nor", "nor cu ploaie", "ploaie", "vreme"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-236"),
            keywords: &["E10-236"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("дождь"),
            keywords: &["дождь", "осадки", "туча"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ibicu birimo"),
            keywords: &["ibicu", "ibicu birimo", "imvura"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڪڪر سان گڏ برسات"),
            keywords: &["برسات", "ڪڪر", "ڪڪر سان گڏ برسات"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("වැස\u{dca}ස සහ\u{dd2}ත වල\u{dcf}ක\u{dd4}ළ"),
            keywords: &[
                "ක\u{dcf}ලග\u{dd4}ණය",
                "වල\u{dcf}ක\u{dd4}ළ",
                "වැස\u{dca}ස",
                "වැස\u{dca}ස සහ\u{dd2}ත වල\u{dcf}ක\u{dd4}ළ",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("dažďový oblak"),
            keywords: &["dažďový oblak", "dážď", "oblak", "počasie"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("oblak z dežjem"),
            keywords: &["dež", "oblak", "oblak z dežjem", "vreme"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("daruur roobeed"),
            keywords: &["darruur wadata baraf", "daruur", "daruur roobeed", "roob"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("re me shi"),
            keywords: &["moti", "re", "re me shi", "shi"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("облак са кишом"),
            keywords: &["oблaк", "кишa", "облак са кишом"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["облак са кишом"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("oblak sa kišom"),
            keywords: &["kiša", "oblak", "oblak sa kišom"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["oblak sa kišom"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("regnmoln"),
            keywords: &["moln", "regn", "regnmoln", "väder"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("wingu lenye mvua"),
            keywords: &["hali ya hewa", "mvua", "wingu", "wingu lenye mvua"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("மழைப\u{bcd}பொழியும\u{bcd} மேகம\u{bcd}"),
            keywords: &[
                "மழை",
                "மழைப\u{bcd}பொழியும\u{bcd} மேகம\u{bcd}",
                "மேகம\u{bcd}",
                "வெப\u{bcd}பநிலை",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("వ\u{c3e}న కురుస\u{c4d}తున\u{c4d}న మ\u{c47}ఘం"),
            keywords: &[
                "మ\u{c47}ఘం",
                "వ\u{c3e}న",
                "వ\u{c3e}న కురుస\u{c4d}తున\u{c4d}న మ\u{c47}ఘం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("абр бо борон"),
            keywords: &["абр", "абр бо борон", "борон"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เมฆฝน"),
            keywords: &["ฝน", "สภาพอากาศ", "เมฆ", "เมฆฝน"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ýagyşly bulut"),
            keywords: &["bulut", "ýagyş", "ýagyşly bulut"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("ʻuha ʻaoʻaofia"),
            keywords: &["ʻuha ʻaoʻaofia"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("yağmur bulutu"),
            keywords: &["bulut", "hava durumu", "yağmur", "yağmur bulutu"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("يامغۇرلۇق بۇلۇت"),
            keywords: &["بۇلۇت", "يامغۇر", "يامغۇرلۇق بۇلۇت"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("хмара з дощем"),
            keywords: &["дощ", "погода", "хмара", "хмара з дощем"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("بادل اور بارش"),
            keywords: &["بادل", "بادل اور بارش", "بارش", "موسم"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("yomg‘irli bulut"),
            keywords: &["bulut", "ob-havo", "yomg‘ir", "yomg‘irli bulut"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("mây và mưa"),
            keywords: &["mây", "mây và mưa", "mưa"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("niir ak taw"),
            keywords: &["niir", "niir ak taw", "taw"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ilifu elinemvula"),
            keywords: &["ilifu", "ilifu elinemvula", "imvula"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("òfurufú pẹ\u{300}lú òjò"),
            keywords: &["òfurufú", "òfurufú pẹ\u{300}lú òjò", "òjò"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("雨雲"),
            keywords: &["雨", "雨雲", "雲"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("雨云"),
            keywords: &["云", "雨", "雨云"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("下雨"),
            keywords: &["下雨", "云", "雨"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("雨天"),
            keywords: &["天氣", "雨天"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("雨雲"),
            keywords: &["天氣", "雨雲"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ifu elinemvula"),
            keywords: &["ifu", "ifu elinemvula", "imvula", "isimo sezulu"],
        },
    ],
};
#[doc = "🌨\u{fe0f}"]
pub const CLOUD_WITH_SNOW: crate::Emoji = crate::Emoji {
    glyph: "🌨\u{fe0f}",
    codepoint: "1F328 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.7f32,
    name: "cloud with snow",
    group: "Travel & Places",
    subgroup: "sky & weather",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🌨",
        codepoint: "1F328",
        status: crate::Status::Unqualified,
        introduction_version: 0.7f32,
        name: "cloud with snow",
        group: "Travel & Places",
        subgroup: "sky & weather",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("wolk met sneeu"),
            keywords: &["koud", "sneeu", "weer", "wolk", "wolk met sneeu"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ደመና ከበረዶ ጋር"),
            keywords: &["ቀዝቃዛ", "በረዶ", "የአየር ንብረት", "ደመና", "ደመና ከበረዶ ጋር"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("سحابة وثلج"),
            keywords: &["بارد", "ثلج", "سحابة", "سحابة وثلج", "طقس"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("বৰফৰ সৈতে ড\u{9be}ৱৰ"),
            keywords: &[
                "ঠ\u{9be}ণ\u{9cd}ড\u{9be}",
                "ড\u{9be}ৱৰ",
                "বৰফ",
                "বৰফৰ সৈতে ড\u{9be}ৱৰ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("qarlı bulud"),
            keywords: &["bulud", "hava", "qar", "qarlı bulud", "soyuq"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("хмара і снег"),
            keywords: &["ападкі", "надвор’е", "снег", "хмара", "хмара і снег"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("облак със сняг"),
            keywords: &["време", "облак", "облак със сняг", "сняг", "студен"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("বরফের স\u{9be}থে মেঘ"),
            keywords: &[
                "আবহ\u{9be}ওয\u{9bc}\u{9be}",
                "ঠ\u{9be}ন\u{9cd}ড\u{9be}",
                "ত\u{9c1}ষ\u{9be}রপ\u{9be}ত",
                "বরফের স\u{9be}থে মেঘ",
                "মেঘ",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("koumoulenn gant ercʼh"),
            keywords: &["ercʼh", "koumoul", "koumoulenn gant ercʼh"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("oblačno sa snijegom"),
            keywords: &[
                "oblaci",
                "oblačno sa snijegom",
                "prognoza",
                "snijeg",
                "vrijeme",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("núvol amb neu"),
            keywords: &["neu", "núvol", "núvol amb neu", "temps"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᎶᎩᎳ ᎥᏂᏥ"),
            keywords: &["ᎤᎶᎩᎳ", "ᎤᏴᏝ", "ᎥᏂᏥ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("mrak se sněhem"),
            keywords: &["mrak", "mrak se sněhem", "oblak", "počasí", "sníh", "zima"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("cwmwl gydag eira"),
            keywords: &["cwmwl", "cwmwl gydag eira", "eira", "oer", "tywydd"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("sky med sne"),
            keywords: &["kulde", "sky", "sky med sne", "sne", "vejr"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Wolke mit Schnee"),
            keywords: &["Schnee", "Wetter", "Wolke", "Wolke mit Schnee"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("σύννεφο με χιόνι"),
            keywords: &["καιρός", "κρύο", "σύννεφο", "σύννεφο με χιόνι", "χιόνι"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("cloud with snow"),
            keywords: &["cloud", "cloud with snow", "cold", "snow"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("nube con nieve"),
            keywords: &["frío", "nieve", "nube", "nube con nieve"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("nieve"),
            keywords: &["clima", "nieve", "nube"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["frío", "nieve", "nube"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("lumepilv"),
            keywords: &["ilm", "külm", "lumepilv", "lumi", "pilv"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("hodeia elurrarekin"),
            keywords: &["eguraldi", "elur", "hodei", "hodeia elurrarekin", "hotz"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("ابر برفی"),
            keywords: &["آب\u{200c}وهوا", "ابر", "ابر برفی", "برف", "سرما"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("lumisadepilvi"),
            keywords: &["lumi", "lumisade", "lumisadepilvi", "pilvi", "pyry", "sää"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("ulap na may niyebe"),
            keywords: &[
                "lagay ng panahon",
                "niyebe",
                "taglamig",
                "ulap",
                "ulap na may niyebe",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("skýggj og kavi"),
            keywords: &[
                "kavar",
                "kavaveður",
                "kavi",
                "skýggj og kavi",
                "veðrið",
                "veður",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("nuage avec neige"),
            keywords: &["flocons", "hiver", "météo", "neige", "nuage avec neige"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("nuage avec de la neige"),
            keywords: &["flocons", "neige", "nuage", "nuage avec de la neige"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("scamall le sneachta"),
            keywords: &[
                "aimsir",
                "fuar",
                "scamall",
                "scamall le sneachta",
                "sneachta",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("sgòth le sneachd"),
            keywords: &["fuar", "neul", "sgòth", "sgòth le sneachd", "sneachd"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("neve"),
            keywords: &["frío", "inverno", "meteoroloxía", "neve"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("બરફ સાથ\u{ac7}ન\u{ac1}\u{a82} વાદળ\u{ac1}\u{a82}"),
            keywords: &[
                "ઠ\u{a82}ડ\u{ac1}\u{a82}",
                "બરફ સાથ\u{ac7}ન\u{ac1}\u{a82} વાદળ\u{ac1}\u{a82}",
                "શીત",
                "હવામાન",
                "હિમવર\u{acd}ષા",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("gajimare tare da ƙanƙara"),
            keywords: &["gajimare", "gajimare tare da ƙanƙara", "sanyi", "ƙanƙara"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("ענן עם שלג"),
            keywords: &["חורף", "ענן", "ענן עם שלג", "שלג"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("बर\u{94d}फ\u{93c} क\u{947} साथ बादल"),
            keywords: &["बर\u{94d}फ\u{93c} क\u{947} साथ बादल", "मौसम"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("oblak sa snijegom"),
            keywords: &["hladno", "oblak", "oblak sa snijegom", "snijeg", "vrijeme"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("felhő hóval"),
            keywords: &["felhő", "felhő hóval", "hideg", "hó", "időjárás"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ձյունով ամպ"),
            keywords: &["ամպ", "եղանակ", "ձյուն", "ձյունով ամպ", "սառը"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("awan salju"),
            keywords: &["awan", "cuaca", "dingin", "salju"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("urukpu nwere akwụrụ mmiri"),
            keywords: &["akwụrụ mmiri", "oyi", "urukpu", "urukpu nwere akwụrụ mmiri"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("snjóský"),
            keywords: &["kalt", "ský", "snjór", "snjóský", "veður"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("neve"),
            keywords: &["freddo", "meteo", "neve", "nevica"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("雪雲"),
            keywords: &["天気", "雪", "雪雲", "雲"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("mega ngemu salju"),
            keywords: &["adhem", "mega", "mega ngemu salju", "salju"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ღრუბელი თოვლით"),
            keywords: &["ამინდი", "თოვლი", "ღრუბელი", "ღრუბელი თოვლით", "ცივი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("қар жауып тұрған бұлт"),
            keywords: &["ауа райы", "бұлт", "суық", "қар", "қар жауып тұрған бұлт"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("sky med sne"),
            keywords: &["kulde", "sky", "sky med sne", "sne", "vejr"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ពពកមានធ\u{17d2}លាក\u{17cb}ព\u{17d2}រ\u{17b7}ល"),
            keywords: &[
                "ពពក",
                "ពពកមានធ\u{17d2}លាក\u{17cb}ព\u{17d2}រ\u{17b7}ល",
                "ព\u{17d2}រ\u{17b7}ល",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಮಂಜ\u{cbf}ನ\u{cbf}ಂದ ಕ\u{cc2}ಡ\u{cbf}ದ ಮೋಡ"),
            keywords: &[
                "ಮಂಜ\u{cbf}ನ\u{cbf}ಂದ ಕ\u{cc2}ಡ\u{cbf}ದ ಮೋಡ",
                "ಮಂಜ\u{cbf}ನ\u{cbf}ಂದ ಕ\u{cc2}ಡ\u{cbf}ದ ಹ\u{cbf}ಮ",
                "ಮಂಜು",
                "ಹವಾಮಾನ",
                "ಹ\u{cbf}ಮ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("눈구름"),
            keywords: &["구름", "날씨", "눈", "눈구름"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("हीम ढग"),
            keywords: &["ढग", "थ\u{902}ड", "बर\u{94d}फ", "हिम ढग", "हीम ढग"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("кар жаап жаткан булут"),
            keywords: &["аба ырайы", "булут", "кар", "кар жаап жаткан булут", "суук"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Wollek mat Schnéi"),
            keywords: &["Schnéi", "Wollek", "Wollek mat Schnéi", "kal"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເມກແລະຫ\u{eb4}ມະ"),
            keywords: &["ສະພາບອາກາດ", "ຫ\u{eb4}ມະ", "ເມກ", "ເມກແລະຫ\u{eb4}ມະ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("debesis, iš kurio sninga"),
            keywords: &["debesis", "debesis, iš kurio sninga", "sniegas", "šaltis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("sniega mākonis"),
            keywords: &[
                "laikapstākļi",
                "laiks",
                "mākonis",
                "sniega mākonis",
                "sniegs",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kapua me te hukarere"),
            keywords: &["hukarere", "kapua", "kapua me te hukarere", "makariri"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("облак со снег"),
            keywords: &["време", "облак", "облак со снег", "снег"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("മഞ\u{d4d}ഞ\u{d41}ം മഴയ\u{d41}ം"),
            keywords: &[
                "ക\u{d3e}ല\u{d3e}വസ\u{d4d}ഥ",
                "തണ\u{d41}പ\u{d4d}പ\u{d4d}",
                "മഞ\u{d4d}ഞ\u{d41}ം മഴയ\u{d41}ം",
                "മഞ\u{d4d}ഞ\u{d4d}",
                "മഴ",
                "മേഘം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("цастай үүл"),
            keywords: &["цас", "цастай үүл", "үүл"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("हिमवर\u{94d}षावासह ढग"),
            keywords: &[
                "ढग",
                "थ\u{902}ड",
                "हिमवर\u{94d}षाव",
                "हिमवर\u{94d}षावासह ढग",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("awan dengan salji"),
            keywords: &["awan", "awan dengan salji", "cuaca", "salji", "sejuk"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("sħaba bis-silġ"),
            keywords: &["kiesaħ", "silġ", "sħaba", "sħaba bis-silġ"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဆ\u{102e}းန\u{103e}င\u{103a}းန\u{103e}င\u{1037}\u{103a} တ\u{102d}မ\u{103a}"),
            keywords: &[
                "ဆ\u{102e}းန\u{103e}င\u{103a}းန\u{103e}င\u{1037}\u{103a} တ\u{102d}မ\u{103a}",
                "တ\u{102d}မ\u{103a}",
                "န\u{103e}င\u{103a}း",
                "န\u{103e}င\u{103a}းန\u{103e}င\u{1037}\u{103a} တ\u{102d}မ\u{103a}တ\u{102d}\u{102f}က\u{103a}ပ\u{102f}\u{1036}",
                "အေး",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("sky med snø"),
            keywords: &["kaldt", "sky", "sky med snø", "snø", "vær"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("हिउ\u{901}सहितको बादल"),
            keywords: &[
                "चिसो",
                "बादल",
                "मौसम",
                "हिउ\u{901}",
                "हिउ\u{901}सहितको बादल",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("wolk met sneeuw"),
            keywords: &["koud", "sneeuw", "wolk", "wolk met sneeuw"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("sky med snø"),
            keywords: &["kaldt", "sky", "sky med snø", "vêr"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ବରଫ ସହ\u{b3f}ତ ମେଘ"),
            keywords: &["ଥଣ\u{b4d}ଡ\u{b3e}", "ବରଫ", "ବରଫ ସହ\u{b3f}ତ ମେଘ", "ମେଘ"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਬ\u{a71}ਦਲ ਅਤ\u{a47} ਬਰਫ"),
            keywords: &[
                "ਠ\u{a70}ਡ",
                "ਬਰਫ ਪ\u{a48}ਣੀ",
                "ਬ\u{a71}ਦਲ",
                "ਬ\u{a71}ਦਲ ਅਤ\u{a47} ਬਰਫ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("بادل نال برف باری"),
            keywords: &["بادل نال برف باری", "بدل", "برف باری", "ٹھنڈا"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Klaud Wit Sno"),
            keywords: &["Klaud", "Klaud Wit Sno", "Kold", "Sno"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("chmura i śnieg"),
            keywords: &["chmura", "chmura i śnieg", "pogoda", "zimno", "śnieg"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ورېځ سره واوره"),
            keywords: &["واوره", "ورېځ", "ورېځ سره واوره", "يخ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("nuvem com neve"),
            keywords: &["clima", "frio", "neve", "nuvem", "nuvem com neve"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["frio", "meteorologia", "neve", "nuvem", "nuvem com neve"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("puyu rit’iwan"),
            keywords: &["chiri", "puyu", "puyu rit’iwan", "rit’i"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("nor de ninsoare"),
            keywords: &["fulgi", "ninsoare", "nor", "nor de ninsoare"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-237"),
            keywords: &["E10-237"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("снег"),
            keywords: &["осадки", "снег", "туча"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ibicu birimo urubura"),
            keywords: &["gikonje", "ibicu", "ibicu birimo urubura", "urubura"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڪڪر سان گڏ برفباري"),
            keywords: &["برف", "ٿڌ", "ڪڪر", "ڪڪر سان گڏ برفباري"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("හ\u{dd2}ම සහ\u{dd2}ත වල\u{dcf}ක\u{dd4}ළ"),
            keywords: &[
                "ක\u{dcf}ලග\u{dd4}ණය",
                "වල\u{dcf}ක\u{dd4}ළ",
                "ශ\u{dd3}තල",
                "හ\u{dd2}ම",
                "හ\u{dd2}ම සහ\u{dd2}ත වල\u{dcf}ක\u{dd4}ළ",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("snehový oblak"),
            keywords: &["oblak", "počasie", "sneh", "snehový oblak", "studený"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("oblak s snegom"),
            keywords: &["mrzlo", "oblak", "oblak s snegom", "sneg", "vreme"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("darruur wadata baraf"),
            keywords: &["baraf", "darruur wadata baraf", "daruur", "qaboow"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("re me borë"),
            keywords: &["borë", "ftohtë", "moti", "re", "re me borë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("облак са снегом"),
            keywords: &["oблaк", "облак са снегом", "снeг", "хлaднo"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("облак са снијегом"),
            keywords: &["облак са снијегом"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("oblak sa snegom"),
            keywords: &["hladno", "oblak", "oblak sa snegom", "sneg"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("oblak sa snijegom"),
            keywords: &["oblak sa snijegom"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("moln med snö"),
            keywords: &["moln", "moln med snö", "snö", "väder"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("wingu lenye theluji"),
            keywords: &[
                "baridi",
                "hali ya hewa",
                "theluji",
                "wingu",
                "wingu lenye theluji",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பனிபொழிவுடன\u{bcd} மேகம\u{bcd}"),
            keywords: &[
                "பனிபொழிவு",
                "பனிபொழிவுடன\u{bcd} மேகம\u{bcd}",
                "மேகம\u{bcd}",
                "வெப\u{bcd}பநிலை",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("మంచుత\u{c4b} ఉన\u{c4d}న మ\u{c47}ఘం"),
            keywords: &["మంచు", "మంచుత\u{c4b} ఉన\u{c4d}న మ\u{c47}ఘం", "మ\u{c47}ఘం"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("абр бо барф"),
            keywords: &["абр", "абр бо барф", "барф", "хунук"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เมฆและห\u{e34}มะ"),
            keywords: &["สภาพอากาศ", "ห\u{e34}มะ", "เมฆ", "เมฆและห\u{e34}มะ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("garly bulut"),
            keywords: &["bulut", "gar", "garly bulut", "sowuk"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("sinou ʻaoʻaofia"),
            keywords: &["sinou ʻaoʻaofia"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("kar bulutu"),
            keywords: &["bulut", "hava durumu", "kar", "kar bulutu", "soğuk"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("قارلىق بۇلۇت"),
            keywords: &["بۇلۇت", "سوغۇق", "قار", "قارلىق بۇلۇت"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("хмара зі снігом"),
            keywords: &["погода", "сніг", "хмара", "хмара зі снігом", "холодний"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("بادل اور برفباری"),
            keywords: &["بادل", "بادل اور برفباری", "برف", "موسم"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("qor yog‘ayotgan bulut"),
            keywords: &["bulut", "ob-havo", "qor", "qor yog‘ayotgan bulut", "sovuq"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("đám mây với tuyết"),
            keywords: &["lạnh", "mây", "tuyết", "đám mây với tuyết"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("niir ak nees"),
            keywords: &["nees", "niir", "niir ak nees", "sedd"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ilifu elinekhephu"),
            keywords: &["ikhephu", "ilifu", "ilifu elinekhephu", "ukubanda"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("òfurufú pẹ\u{300}lú yìnyín"),
            keywords: &["yìnyín", "òfurufú", "òfurufú pẹ\u{300}lú yìnyín", "òtútù"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("雪雲"),
            keywords: &["寒冷", "雪", "雪雲", "雲"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("雪云"),
            keywords: &["云", "寒冷", "雪", "雪云"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("下雪"),
            keywords: &["下雪", "云", "雪"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("下雪"),
            keywords: &["下雪", "天氣"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("落雪嘅雲"),
            keywords: &["天氣", "落雪嘅雲"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ifu elinesithwathwa"),
            keywords: &[
                "ifu",
                "ifu elinesithwathwa",
                "isimo sezulu",
                "isithwathwa",
                "ukubanda",
            ],
        },
    ],
};
#[doc = "🌩\u{fe0f}"]
pub const CLOUD_WITH_LIGHTNING: crate::Emoji = crate::Emoji {
    glyph: "🌩\u{fe0f}",
    codepoint: "1F329 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.7f32,
    name: "cloud with lightning",
    group: "Travel & Places",
    subgroup: "sky & weather",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🌩",
        codepoint: "1F329",
        status: crate::Status::Unqualified,
        introduction_version: 0.7f32,
        name: "cloud with lightning",
        group: "Travel & Places",
        subgroup: "sky & weather",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("wolk met weerlig"),
            keywords: &["blits", "weer", "weerlig", "wolk", "wolk met weerlig"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ደመና ከመብረቅ ጋር"),
            keywords: &["ነጎድጓድ", "የአየር ንብረት", "ደመና", "ደመና ከመብረቅ ጋር"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("سحابة وبرق"),
            keywords: &["برق", "سحابة", "سحابة وبرق", "طقس"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("বিজ\u{9c1}লীৰ সৈতে ড\u{9be}ৱৰ"),
            keywords: &[
                "ড\u{9be}ৱৰ",
                "বিজ\u{9c1}লী",
                "বিজ\u{9c1}লীৰ সৈতে ড\u{9be}ৱৰ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("ildırımlı bulud"),
            keywords: &["bulud", "hava", "ildırım", "ildırımlı bulud"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("хмара з маланкай"),
            keywords: &[
                "бліскавіца",
                "маланка",
                "надвор’е",
                "хмара",
                "хмара з маланкай",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("облак със светкавица"),
            keywords: &["време", "облак", "облак със светкавица", "светкавица"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("বিদ\u{9cd}য\u{9c1}তের ঝলকের স\u{9be}থে মেঘ"),
            keywords: &[
                "আবহ\u{9be}ওয\u{9bc}\u{9be}",
                "বিদ\u{9cd}য\u{9c1}তের ঝলকের স\u{9be}থে মেঘ",
                "বিদ\u{9cd}য\u{9c1}ৎ চমক",
                "মেঘ",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("koumoulenn gant lucʼhedenn"),
            keywords: &["koumoul", "koumoulenn gant lucʼhedenn", "lucʼhedenn"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("oblačno s grmljavinom"),
            keywords: &[
                "grmljavina",
                "oblaci",
                "oblačno s grmljavinom",
                "prognoza",
                "vrijeme",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("núvol amb llamp"),
            keywords: &["llamp", "núvol", "núvol amb llamp", "temps"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᎶᎩᎳ ᎠᎾᎦᎵᎭ"),
            keywords: &["ᎠᎾᎦᎵᎭ", "ᎤᎶᎩᎳ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("mrak s bleskem"),
            keywords: &["blesk", "mrak", "mrak s bleskem", "oblak", "počasí"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("cwmwl gyda mellt"),
            keywords: &["cwmwl", "cwmwl gyda mellt", "mellt", "tywydd"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("tordensky"),
            keywords: &["lyn", "sky", "tordensky", "vejr"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Wolke mit Blitz"),
            keywords: &["Blitz", "Gewitter", "Wetter", "Wolke", "Wolke mit Blitz"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("σύννεφο με αστραπή"),
            keywords: &["αστραπή", "καιρός", "σύννεφο", "σύννεφο με αστραπή"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("cloud with lightning"),
            keywords: &["cloud", "cloud with lightning", "lightning"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("nube con rayo"),
            keywords: &["nube", "nube con rayo", "rayo"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("nubes y relámpagos"),
            keywords: &["clima", "nubes", "nubes y relámpagos", "relámpagos"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("nube y relámpagos"),
            keywords: &["nube", "nube y relámpagos", "rayos", "relámpagos"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("äikesepilv"),
            keywords: &["ilm", "pilv", "välk", "äike", "äikesepilv"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("hodeia tximistarekin"),
            keywords: &["eguraldi", "hodei", "hodeia tximistarekin", "tximista"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("ابر با برق"),
            keywords: &["آب\u{200c}وهوا", "ابر", "ابر با برق", "رعدوبرق"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("ukkospilvi"),
            keywords: &["pilvi", "salama", "sää", "ukkonen", "ukkospilvi"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("ulap na may kidlat"),
            keywords: &[
                "kidlat",
                "lagay ng panahon",
                "panahon",
                "ulap",
                "ulap na may kidlat",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("skýggj og snarljós"),
            keywords: &[
                "skýggj og snarljós",
                "snarljós",
                "tora",
                "torusláttur",
                "veðrið",
                "veður",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("nuage avec éclair"),
            keywords: &["nuage", "nuage avec éclair"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("nuage avec un éclair"),
            keywords: &["nuage", "nuage avec un éclair", "éclair"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("scamall le tintreach"),
            keywords: &["aimsir", "scamall", "scamall le tintreach", "tintreach"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("neul le dealanaich"),
            keywords: &["dealanaich", "neul", "neul le dealanaich", "sgòth"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("lóstregos"),
            keywords: &["lóstrego", "lóstregos", "meteoroloxía", "nube"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ચમકારા સાથ\u{ac7}ન\u{ac1}\u{a82} વાદળ\u{ac1}\u{a82}"),
            keywords: &[
                "ચમકારા સાથ\u{ac7}ન\u{ac1}\u{a82} વાદળ\u{ac1}\u{a82}",
                "વીજળીનો ચમકારો",
                "હવામાન",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("gajimare tare da aradu"),
            keywords: &["aradu", "gajimare", "gajimare tare da aradu"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("ענן עם ברק"),
            keywords: &["ברק", "חורף", "ענן", "ענן עם ברק"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("बिजली क\u{947} साथ बादल"),
            keywords: &["बिजली क\u{947} साथ बादल", "मौसम"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("oblak s grmljavinom"),
            keywords: &["grmljavina", "oblak", "oblak s grmljavinom", "vrijeme"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("felhő villámmal"),
            keywords: &["felhő", "felhő villámmal", "időjárás", "villám"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("կայծակով ամպ"),
            keywords: &["ամպ", "եղանակ", "կայծակ", "կայծակով ամպ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("awan petir"),
            keywords: &["awan", "awan petir", "cuaca", "kilat"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("urukpu nwere àmụ\u{300}mà"),
            keywords: &["urukpu", "urukpu nwere àmụ\u{300}mà", "àmụ\u{300}mà"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("eldingarský"),
            keywords: &["elding", "eldingarský", "ský", "veður"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("fulmini"),
            keywords: &["fulmini", "meteo", "nuvole"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("雷雲"),
            keywords: &["天気", "稲妻", "雲", "雷", "雷雲"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("mega ngemu bledhek"),
            keywords: &["bledhek", "mega", "mega ngemu bledhek"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ღრუბელი ელვით"),
            keywords: &["ამინდი", "ელვა", "მეხი", "ღრუბელი", "ღრუბელი ელვით"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("найзағай соғып тұрған бұлт"),
            keywords: &["ауа райы", "бұлт", "найзағай", "найзағай соғып тұрған бұлт"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("tordensky"),
            keywords: &["lyn", "sky", "tordensky", "vejr"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ពពកមានរន\u{17d2}ទះ"),
            keywords: &["ពពក", "ពពកមានរន\u{17d2}ទះ", "រន\u{17d2}ទះ"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಮ\u{cbf}ಂಚ\u{cbf}ನೊಂದ\u{cbf}ಗ\u{cc6} ಮೋಡ"),
            keywords: &[
                "ಮ\u{cbf}ಂಚ\u{cbf}ನೊಂದ\u{cbf}ಗ\u{cc6} ಮೋಡ",
                "ಮ\u{cbf}ಂಚು",
                "ಮೋಡ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("번개구름"),
            keywords: &["구름", "번개", "번개구름"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("विजा\u{902}चो ढग"),
            keywords: &["ढग", "विजा\u{902}चो ढग"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("чагылган түшүп жаткан булут"),
            keywords: &[
                "аба ырайы",
                "булут",
                "чагылган",
                "чагылган түшүп жаткан булут",
            ],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Wollek mat Blëtz"),
            keywords: &["Blëtz", "Wollek", "Wollek mat Blëtz"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເມກແລະຟ\u{ec9}າເຫ\u{ebc}\u{eb7}\u{ec9}ອມ"),
            keywords: &[
                "ຟ\u{ec9}າເຫ\u{ebc}\u{eb7}\u{ec9}ອມ",
                "ສະພາບອາກາດ",
                "ເມກ",
                "ເມກແລະຟ\u{ec9}າເຫ\u{ebc}\u{eb7}\u{ec9}ອມ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("debesis su žaibu"),
            keywords: &["debesis", "debesis su žaibu", "žaibas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("mākonis ar zibeni"),
            keywords: &[
                "laikapstākļi",
                "laiks",
                "mākonis",
                "mākonis ar zibeni",
                "zibens",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kapua me te uira"),
            keywords: &["kapua", "kapua me te uira", "uira"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("облак со гром"),
            keywords: &["време", "гром", "облак", "облак со гром"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("മിന\u{d4d}നല\u{d41}ം മേഘവ\u{d41}ം"),
            keywords: &[
                "ഇടിയ\u{d41}ം മിന\u{d4d}നല\u{d41}ം മഴയ\u{d41}ം",
                "ക\u{d3e}ല\u{d3e}വസ\u{d4d}ഥ",
                "മിന\u{d4d}നല\u{d41}ം മേഘവ\u{d41}ം",
                "മിന\u{d4d}നൽ",
                "മേഘം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("цахилгаантай үүл"),
            keywords: &[
                "хур тунадас",
                "цаг агаар",
                "цахилгаан",
                "цахилгаантай үүл",
                "үүл",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("चमकणार\u{94d}\u{200d}या वीज\u{947}सह ढग"),
            keywords: &[
                "चमकणारी वीज",
                "चमकणार\u{94d}\u{200d}या वीज\u{947}सह ढग",
                "चमकणाऱ\u{94d}या वीज\u{947}सह ढग",
                "ढग",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("awan dengan kilat"),
            keywords: &["awan", "awan dengan kilat", "cuaca", "kilat"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("sħaba bis-sajjetti"),
            keywords: &["sajjetti", "sħaba", "sħaba bis-sajjetti"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("လျ\u{103e}ပ\u{103a}စ\u{102e}းန\u{103e}င\u{1037}\u{103a}တ\u{102d}မ\u{103a}"),
            keywords: &[
                "တ\u{102d}မ\u{103a}",
                "မ\u{102d}\u{102f}းကြ\u{102d}\u{102f}း",
                "မ\u{102d}\u{102f}းကြ\u{102d}\u{102f}းန\u{103e}င\u{1037}\u{103a} တ\u{102d}မ\u{103a}တ\u{102d}\u{102f}က\u{103a}ပ\u{102f}\u{1036}",
                "လျ\u{103e}ပ\u{103a}စ\u{102e}းန\u{103e}င\u{1037}\u{103a}တ\u{102d}မ\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("sky med lyn"),
            keywords: &["lyn", "sky", "sky med lyn", "vær"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("बिज\u{941}ली चम\u{94d}कि\u{901}दाको बादल"),
            keywords: &[
                "बादल",
                "बिज\u{941}ली चम\u{94d}कि\u{901}दाको बादल",
                "बिज\u{941}ली चम\u{94d}किरह\u{947}को",
                "मौसम",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("wolk met bliksem"),
            keywords: &["bliksem", "wolk", "wolk met bliksem"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("sky med lyn"),
            keywords: &["lyn", "sky", "sky med lyn", "vêr"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ବ\u{b3f}ଜ\u{b41}ଳ\u{b3f} ସହ\u{b3f}ତ ମେଘ"),
            keywords: &[
                "ବ\u{b3f}ଜ\u{b41}ଳ\u{b3f}",
                "ବ\u{b3f}ଜ\u{b41}ଳ\u{b3f} ସହ\u{b3f}ତ ମେଘ",
                "ମେଘ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਬ\u{a71}ਦਲ ਅਤ\u{a47} ਬਿਜਲੀ"),
            keywords: &[
                "ਬਿਜਲੀ ਲਸ\u{a3c}ਕਣਾ",
                "ਬ\u{a71}ਦਲ",
                "ਬ\u{a71}ਦਲ ਅਤ\u{a47} ਬਿਜਲੀ",
                "ਮ\u{a4c}ਸਮ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("بادل نال بجلی"),
            keywords: &["بادل نال بجلی", "بجلی دی چمک", "بدل"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Klaud Wit Laítnin"),
            keywords: &["Klaud", "Klaud Wit Laítnin", "Laítnin"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("chmura i piorun"),
            keywords: &[
                "błyskawica",
                "chmura",
                "chmura i piorun",
                "piorun",
                "pogoda",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("وريځ د پړقا سره"),
            keywords: &["وريځ", "وريځ د پړقا سره", "ورېځ د پړقا سره", "پړقا"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("nuvem com trovão"),
            keywords: &["clima", "nuvem", "nuvem com trovão", "relâmpago"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("nuvem com relâmpago"),
            keywords: &["meteorologia", "nuvem", "nuvem com relâmpago", "relâmpago"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("puyu lliphiwan"),
            keywords: &["k’anchaynin", "puyu", "puyu lliphiwan"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("nor cu fulger"),
            keywords: &["fulger", "nor", "nor cu fulger"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-238"),
            keywords: &["E10-238"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("молния"),
            keywords: &["гром", "молния", "облако", "туча"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ibicu birimo imirabyo"),
            keywords: &["ibicu", "ibicu birimo imirabyo", "umurabyo"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڪڪر سان گڏ کنوڻ"),
            keywords: &["کنوڻ", "ڪڪر", "ڪڪر سان گڏ کنوڻ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ව\u{dd2}ද\u{dd4}ල\u{dd2} කෙට\u{dd3}ම සහ\u{dd2}ත වල\u{dcf}ක\u{dd4}ළ"),
            keywords: &[
                "ක\u{dcf}ලග\u{dd4}ණය",
                "වල\u{dcf}ක\u{dd4}ළ",
                "ව\u{dd2}ද\u{dd4}ල\u{dd2} කෙට\u{dd3}ම",
                "ව\u{dd2}ද\u{dd4}ල\u{dd2} කෙට\u{dd3}ම සහ\u{dd2}ත වල\u{dcf}ක\u{dd4}ළ",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("oblak s bleskom"),
            keywords: &["blesk", "oblak", "oblak s bleskom", "počasie"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("oblak s strelo"),
            keywords: &["oblak", "oblak s strelo", "strela", "vreme"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("daruur hillaac leh"),
            keywords: &["daruur", "daruur hillaac leh", "hillaac"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("re me vetëtimë"),
            keywords: &["moti", "re", "re me vetëtimë", "vetëtimë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("облак са муњом"),
            keywords: &["oблaк", "муња", "облак са муњом"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["облак са муњом"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("oblak sa munjom"),
            keywords: &["munja", "oblak", "oblak sa munjom"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["oblak sa munjom"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("moln med blixt"),
            keywords: &["moln", "moln med blixt", "oväder", "väder"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("wingu lenye radi"),
            keywords: &["hali ya hewa", "radi", "wingu", "wingu lenye radi"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("மின\u{bcd}னலுடன\u{bcd} மேகம\u{bcd}"),
            keywords: &[
                "மின\u{bcd}னலுடன\u{bcd} மேகம\u{bcd}",
                "மின\u{bcd}னல\u{bcd}",
                "மேகம\u{bcd}",
                "வெப\u{bcd}பநிலை",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("మ\u{c46}రుస\u{c4d}తున\u{c4d}న మ\u{c47}ఘం"),
            keywords: &[
                "మ\u{c46}రుపు",
                "మ\u{c46}రుస\u{c4d}తున\u{c4d}న మ\u{c47}ఘం",
                "మ\u{c47}ఘం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("абр бо чароғак"),
            keywords: &["абр", "абр бо чароғак", "чароғак"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เมฆและฟ\u{e49}าแลบ"),
            keywords: &["ฟ\u{e49}าแลบ", "สภาพอากาศ", "เมฆ", "เมฆและฟ\u{e49}าแลบ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ýyldyrymly bulut"),
            keywords: &["bulut", "ýyldyrym", "ýyldyrymly bulut"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("ʻuhila ʻaoʻaofia"),
            keywords: &["ʻuhila ʻaoʻaofia"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("şimşek bulutu"),
            keywords: &["bulut", "hava durumu", "yıldırım", "şimşek bulutu"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("چاقماقلىق بۇلۇت"),
            keywords: &["بۇلۇت", "چاقماق", "چاقماقلىق بۇلۇت"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("хмара з блискавкою"),
            keywords: &["блискавка", "погода", "хмара", "хмара з блискавкою"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("بادل اور گرج چمک"),
            keywords: &["بادل", "بادل اور گرج چمک", "بجلی کی چمک", "موسم"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("chaqmoq chaqayotgan bulut"),
            keywords: &[
                "bulut",
                "chaqmoq",
                "chaqmoq chaqayotgan bulut",
                "ob-havo",
                "yashin",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("đám mây với tia chớp"),
            keywords: &["mây", "sét", "đám mây với tia chớp"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("niir ak melax"),
            keywords: &["melax", "niir", "niir ak melax"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ilifu elinombane"),
            keywords: &["ilifu", "ilifu elinombane", "ukubaneka"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("òfurufú pẹlu ṣíṣáná"),
            keywords: &["òfurufú", "òfurufú pẹlu ṣíṣáná", "ṣíṣáná"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("閃電雲"),
            keywords: &["閃電", "閃電雲", "雲"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("闪电云"),
            keywords: &["云", "闪电", "闪电云"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("打雷"),
            keywords: &["云", "打雷", "闪电", "雷"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("閃電"),
            keywords: &["天氣", "閃電"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ifu elinombani"),
            keywords: &["ifu", "ifu elinombani", "isimo sezulu", "umbani"],
        },
    ],
};
#[doc = "🌪\u{fe0f}"]
pub const TORNADO: crate::Emoji = crate::Emoji {
    glyph: "🌪\u{fe0f}",
    codepoint: "1F32A FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.7f32,
    name: "tornado",
    group: "Travel & Places",
    subgroup: "sky & weather",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🌪",
        codepoint: "1F32A",
        status: crate::Status::Unqualified,
        introduction_version: 0.7f32,
        name: "tornado",
        group: "Travel & Places",
        subgroup: "sky & weather",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("tornado"),
            keywords: &["storm", "tornado", "warrel", "weer", "wolk"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ቶርኔዶ"),
            keywords: &["ቶርኔዶ", "አውሎ ነፋስ", "የአየር ንብረት", "ደመና"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("إعصار"),
            keywords: &["إعصار", "سحابة", "طقس"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ঘ\u{9c2}ৰ\u{9cd}ণিবত\u{9be}হ"),
            keywords: &["ঘ\u{9c2}ৰ\u{9cd}ণিবত\u{9be}হ", "ড\u{9be}ৱৰ"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("qasırğa"),
            keywords: &["bulud", "hava", "qasırğa"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("тарнада"),
            keywords: &["віхор", "надвор’е", "смерч", "тарнада", "хмара"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("торнадо"),
            keywords: &["вихрушка", "време", "облак", "торнадо"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ঘ\u{9c2}র\u{9cd}ণিঝড\u{9bc}"),
            keywords: &[
                "আবহ\u{9be}ওয\u{9bc}\u{9be}",
                "ঘ\u{9c2}র\u{9cd}ণিঝড\u{9bc}",
                "মেঘ",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("tornadenn"),
            keywords: &["koumoul", "tornadenn"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("tornado"),
            keywords: &["oblaci", "prognoza", "tornado", "vihor", "vrijeme"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("tornado"),
            keywords: &["remolí", "temps", "tornado"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᎦᎷᎦ ᎤᏔᎾ"),
            keywords: &["ᎠᎦᎷᎦ", "ᎠᎦᎷᎦ ᎤᏔᎾ", "ᎤᎶᎩᎳ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("tornádo"),
            keywords: &["mrak", "oblak", "počasí", "tornádo", "vír"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("corwynt"),
            keywords: &["chwyrlwynt", "corwynt", "cwmwl", "tywydd"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("tornado"),
            keywords: &["hvirvelvind", "sky", "skypumpe", "tornado", "vejr"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Wirbelsturm"),
            keywords: &["Wetter", "Wirbelsturm"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ανεμοστρόβιλος"),
            keywords: &["ανεμοστρόβιλος", "καιρός", "σύννεφο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("tornado"),
            keywords: &["cloud", "tornado", "whirlwind"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: None,
            keywords: &["cloud", "tornado", "twister", "whirlwind"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("tornado"),
            keywords: &["nube", "torbellino", "tornado"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["clima", "nube", "tornado", "viento"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["nube", "torbellino", "tornado"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("keeristorm"),
            keywords: &["ilm", "keeris", "keeristorm", "tornaado"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("tornadoa"),
            keywords: &["eguraldi", "hodei", "tornado", "tornadoa", "zurrunbilo"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("گردباد"),
            keywords: &[
                "آب\u{200c}وهوا",
                "ابر",
                "تورنادو",
                "چرخ\u{200c}باد",
                "گردباد",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("hurrikaani"),
            keywords: &["hirmumyrsky", "hurrikaani", "sää", "tornado"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("ipu-ipo"),
            keywords: &["buhawi", "ipu-ipo", "lagay ng panahon", "panahon", "unos"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("melduródn"),
            keywords: &["hvirla", "meldurhvirla", "melduródn"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("tornade"),
            keywords: &["météo", "nuage", "tornade", "tourbillon"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["nuage", "tornade", "tourbillon"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("tornádó"),
            keywords: &["aimsir", "iomghaoth", "scamall", "tornádó"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("tornàdo"),
            keywords: &["neul", "sgòth", "tornàdo"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("tornado"),
            keywords: &["furacán", "meteoroloxía", "tornado"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("તોફાન"),
            keywords: &["ચક\u{acd}રવાત", "તોફાન", "વાદળ", "વાવ\u{a82}ટોળ", "હવામાન"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("guguwa mai ƙarfi"),
            keywords: &["gajimare", "guguwa", "guguwa mai ƙarfi"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("טורנדו"),
            keywords: &["טורנדו", "סופה", "סערה", "רוח"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("त\u{942}फ\u{93c}ान"),
            keywords: &["त\u{942}फ\u{93c}ान", "मौसम"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("tornado"),
            keywords: &["oblak", "pijavica", "tornado", "vihor", "vrijeme"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("tornádó"),
            keywords: &["felhő", "időjárás", "tornádó"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("պտտահողմ"),
            keywords: &["ամպ", "եղանակ", "պտտահողմ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("tornado"),
            keywords: &["angin", "awan", "cuaca", "pusaran", "tornado"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ajọọ ìkùkù"),
            keywords: &["ajọọ ìkùkù", "oke ìkùkù", "urukpu"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("skýstrókur"),
            keywords: &["hvirfilbylur", "ský", "skýstrókur", "veður"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("tornado"),
            keywords: &["tornado", "tromba d’aria"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("竜巻"),
            keywords: &["天気", "突風", "竜巻"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("angin puyuh"),
            keywords: &["angin puyuh", "mendhung", "tornado"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ტორნადო"),
            keywords: &["ამინდი", "ტორნადო", "ქარბორბალა", "ღრუბელი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("торнадо"),
            keywords: &["ауа райы", "бұлт", "торнадо", "құйын"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("tornado"),
            keywords: &["hvirvelvind", "sky", "skypumpe", "tornado", "vejr"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ខ\u{17d2}យល\u{17cb}ក\u{17bd}ច"),
            keywords: &[
                "ក\u{17bd}ច",
                "ខ\u{17d2}យល\u{17cb}",
                "ខ\u{17d2}យល\u{17cb}ក\u{17bd}ច",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಸುಂಟರಗಾಳ\u{cbf}"),
            keywords: &["ಮೋಡ", "ಸುಂಚರಗಾಳ\u{cbf}", "ಸುಂಟರಗಾಳ\u{cbf}", "ಹವಾಮಾನ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("토네이도"),
            keywords: &["소용돌이", "태풍", "토네이도"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("टोर\u{94d}नाडो"),
            keywords: &["चक\u{94d}रीवादळ", "टोर\u{94d}नाडो", "ढग"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("торнадо"),
            keywords: &["аба ырайы", "булут", "куюн", "торнадо"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Tornado"),
            keywords: &["Tornado", "Wirbelwand", "Wollek"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ພະຍ\u{eb8}ທ\u{ecd}ນາໂດ"),
            keywords: &[
                "ພະຍ\u{eb8}ທ\u{ecd}ນາໂດ",
                "ພະຍ\u{eb8}ໝ\u{eb9}ນ",
                "ສະພາບອາກາດ",
                "ເມກ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("tornadas"),
            keywords: &["debesis", "sūkurys", "tornadas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("tornado"),
            keywords: &[
                "laikapstākļi",
                "laiks",
                "mākonis",
                "tornado",
                "viesulis",
                "virpulis",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("āwhā"),
            keywords: &["kapua", "paroro", "āwhā"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("торнадо"),
            keywords: &["ветер", "време", "торнадо"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ച\u{d41}ഴലിക\u{d4d}ക\u{d3e}റ\u{d4d}റ\u{d4d}"),
            keywords: &[
                "ക\u{d3e}ല\u{d3e}വസ\u{d4d}ഥ",
                "ച\u{d41}ഴലിക\u{d4d}ക\u{d3e}റ\u{d4d}റ\u{d4d}",
                "മേഘം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("хар салхи"),
            keywords: &["угалз", "хар салхи", "үүл"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("वावटळ"),
            keywords: &["चक\u{94d}रवात", "ढग", "वावटळ"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("puting beliung"),
            keywords: &["awan", "cuaca", "puting beliung"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("tornado"),
            keywords: &["buffuri", "sħaba", "tornado"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("လေဆင\u{103a}န\u{103e}ာမောင\u{103a}း"),
            keywords: &[
                "တ\u{102d}မ\u{103a}",
                "လေဆင\u{103a}န\u{103e}ာမောင\u{103a}း",
                "လေပြင\u{103a}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("tornado"),
            keywords: &["sky", "tornado", "vær"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("भवन\u{94d}डर"),
            keywords: &["चक\u{94d}रवात", "बादल", "भवन\u{94d}डर", "मौसम"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("tornado"),
            keywords: &["tornado", "wervelwind", "wolk"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("tornado"),
            keywords: &["sky", "tornado", "vêr"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଘ\u{b42}ର\u{b4d}ଣ\u{b4d}ଣ\u{b3f}ବ\u{b3e}ତ\u{b4d}ୟ\u{b3e}"),
            keywords: &[
                "ଘ\u{b42}ର\u{b4d}ଣ\u{b4d}ଣ\u{b3f}ବ\u{b3e}ତ\u{b4d}ୟ\u{b3e}",
                "ପ\u{b4d}ରବଳ ତୋଫ\u{b3e}ନ",
                "ମେଘ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਤ\u{a42}ਫਾਨ"),
            keywords: &[
                "ਤ\u{a42}ਫਾਨ",
                "ਬ\u{a71}\u{a71}ਦਲ",
                "ਮ\u{a4c}ਸਮ",
                "ਵਾਵਰ\u{a4b}ਲ\u{a47}",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("طوفان"),
            keywords: &["بدل", "طوفان", "گردباد"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Tọnádo"),
            keywords: &["Klaud", "Strọ\u{301}ng Wind", "Tọnádo"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("tornado"),
            keywords: &["chmura", "lej", "pogoda", "tornado", "wir powietrzny"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("بړبوکۍ"),
            keywords: &["بادامه", "بړبوکۍ", "ورېځ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("tornado"),
            keywords: &["clima", "furacão", "nuvem", "tornado"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["furacão", "meteorologia", "nuvem", "tornado"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("wayrakuna"),
            keywords: &["puyu", "wayra", "wayrakuna"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("tornadă"),
            keywords: &["nor", "tornadă", "vârtej"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-239"),
            keywords: &["E10-239"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("торнадо"),
            keywords: &["вихрь", "катастрофа", "смерч", "торнадо", "ураган"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umuyaga ukaze"),
            keywords: &["ibicu", "serwakira", "umuyaga ukaze"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("طوفان"),
            keywords: &["آنڌي", "طوفان", "ڪڪر"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ටොන\u{dcf}ඩෝ"),
            keywords: &[
                "ක\u{dcf}ලග\u{dd4}ණය",
                "ටොන\u{dcf}ඩෝ",
                "වල\u{dcf}ක\u{dd4}ළ",
                "ස\u{dd4}ළ\u{dd2} ක\u{dd4}ණ\u{dcf}ට\u{dd4}ව",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("tornádo"),
            keywords: &["oblak", "počasie", "tornádo", "vzdušný vír"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("tornado"),
            keywords: &["oblak", "tornado", "vreme", "vrtinec"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("tornaado"),
            keywords: &["daruur", "meerkac dabayleed", "tornaado"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("tornado"),
            keywords: &["mot", "re", "tornado", "vorbull ere"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("торнадо"),
            keywords: &["oблaк", "вртлог", "торнадо"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["торнадо"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("tornado"),
            keywords: &["oblak", "tornado", "vrtlog"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["tornado"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("tornado"),
            keywords: &["tornado", "virvelvind", "väder"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kimbunga"),
            keywords: &["hali ya hewa", "kimbunga", "wingu"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("சூற\u{bbe}வளி"),
            keywords: &["சூற\u{bbe}வளி", "வெப\u{bcd}பநிலை"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("సుడ\u{c3f}గ\u{c3e}ల\u{c3f}"),
            keywords: &[
                "గ\u{c3e}ల\u{c3f}",
                "సుడ\u{c3f}",
                "సుడ\u{c3f}గ\u{c3e}ల\u{c3f}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("торнадо"),
            keywords: &["абр", "гирдбод", "торнадо"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("พาย\u{e38}ทอร\u{e4c}นาโด"),
            keywords: &[
                "พาย\u{e38}ทอร\u{e4c}นาโด",
                "พาย\u{e38}หม\u{e38}น",
                "อากาศ",
                "เมฆ",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("tornado"),
            keywords: &["bulut", "tornado", "tüweleý"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("ʻahiohio"),
            keywords: &["ʻahiohio"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("hortum"),
            keywords: &["bulut", "hava durumu", "hortum"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("قۇيۇن"),
            keywords: &["بۇلۇت", "قۇيۇن"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("торнадо"),
            keywords: &["погода", "торнадо", "ураган", "хмара"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("جھکڑ"),
            keywords: &["بادل", "تیز ہوا", "جھکڑ", "موسم"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("quyun"),
            keywords: &["bulut", "dovul", "ob-havo", "quyun", "shamol"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("lốc xoáy"),
            keywords: &["cơn lốc", "lốc xoáy", "mây"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("Tawu-ngelaw"),
            keywords: &["Tawu-ngelaw", "niir", "turbiyoŋ"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("isaqhwithi"),
            keywords: &["ilifu", "isaqhwithi", "isivunguvane"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("ìjì tó le"),
            keywords: &["ìjì", "ìjì tó le", "òfurufú"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("閃電"),
            keywords: &["旋風", "閃電", "雲"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("闪电"),
            keywords: &["云", "旋风", "闪电"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("龙卷风"),
            keywords: &["云", "旋风", "龙卷风"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("龍捲風"),
            keywords: &["天氣", "龍捲風"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("inkanyamba"),
            keywords: &["ifu", "inkanyamba", "isimo sezulu", "umoya ovunguzayo"],
        },
    ],
};
#[doc = "🌫\u{fe0f}"]
pub const FOG: crate::Emoji = crate::Emoji {
    glyph: "🌫\u{fe0f}",
    codepoint: "1F32B FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.7f32,
    name: "fog",
    group: "Travel & Places",
    subgroup: "sky & weather",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🌫",
        codepoint: "1F32B",
        status: crate::Status::Unqualified,
        introduction_version: 0.7f32,
        name: "fog",
        group: "Travel & Places",
        subgroup: "sky & weather",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("mis"),
            keywords: &["mis", "weer", "wolk"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ጉም"),
            keywords: &["የአየር ንብረት", "ደመና", "ጉም"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("ضبابي"),
            keywords: &["سحب", "ضبابي", "طقس"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ক\u{9c1}\u{981}ৱলি"),
            keywords: &["ক\u{9c1}\u{981}ৱলি", "ড\u{9be}ৱৰ"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("duman"),
            keywords: &["bulud", "duman", "hava"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("туман"),
            keywords: &["бачнасць", "воблака", "надвор’е", "нізкая", "туман"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("мъгла"),
            keywords: &["време", "мъгла", "облак"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ক\u{9c1}য\u{9bc}\u{9be}শ\u{9be}"),
            keywords: &[
                "আবহ\u{9be}ওয\u{9bc}\u{9be}",
                "ক\u{9c1}য\u{9bc}\u{9be}শ\u{9be}",
                "মেঘ",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("latar"),
            keywords: &["koumoul", "latar"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("magla"),
            keywords: &["magla", "oblaci", "prognoza", "vrijeme"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("boira"),
            keywords: &["boira", "núvol", "temps"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᎬᎭᏗ"),
            keywords: &["ᎤᎬᎭᏗ", "ᎤᎶᎩᎳ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("mlhavé počasí"),
            keywords: &["mlha", "mlhavé počasí", "mrak", "oblak", "počasí"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("niwl"),
            keywords: &["cwmwl", "niwl"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("tåge"),
            keywords: &["sky", "tåge", "vejr"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Nebel"),
            keywords: &["Nebel", "Wetter", "neblig"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ομίχλη"),
            keywords: &["καιρός", "ομίχλη", "σύννεφο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("fog"),
            keywords: &["cloud", "fog"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("niebla"),
            keywords: &["niebla", "nube"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("neblina"),
            keywords: &["clima", "neblina", "nieve"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["neblina", "nube"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("udu"),
            keywords: &["ilm", "pilv", "udu"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("lainoa"),
            keywords: &["eguraldi", "hodei", "lainoa"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("مه"),
            keywords: &["آب\u{200c}وهوا", "ابر", "مه"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("sumu"),
            keywords: &["sumu", "sää", "usva", "utu"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("hamog"),
            keywords: &["fog", "hamog", "lagay ng panahon", "panahon", "ulap"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("mjørki"),
            keywords: &["mjørki", "toka"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("brouillard"),
            keywords: &["brouillard", "météo", "nuage"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["brouillard", "nuage"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("ceo"),
            keywords: &["aimsir", "ceo", "scamall"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("ceò"),
            keywords: &["ceò", "neul"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("néboa"),
            keywords: &["meteoroloxía", "nebuloso", "néboa"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ધ\u{ac1}મ\u{acd}મ\u{acd}સ"),
            keywords: &["ધ\u{ac1}મ\u{acd}મ\u{acd}સ", "વાદળ", "હવામાન"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("hazo"),
            keywords: &["gajimare", "hazo"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("ערפל"),
            keywords: &["מזג אוויר", "ענן", "ערפל"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("कोहरा"),
            keywords: &["कोहरा", "मौसम"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("magla"),
            keywords: &["magla", "oblak", "vrijeme"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("köd"),
            keywords: &["felhő", "időjárás", "köd"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("մառախուղ"),
            keywords: &["ամպ", "եղանակ", "մառախուղ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("kabut"),
            keywords: &["awan", "cuaca", "kabut"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("igirigi nnukwu"),
            keywords: &["igirigi nnukwu", "urukpu"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("þoka"),
            keywords: &["ský", "veður", "þoka"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("nebbia"),
            keywords: &["foschia", "meteo", "nebbia", "visibilità ridotta"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("霧"),
            keywords: &["天気", "霧"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("pedhut"),
            keywords: &["mega", "pedhut"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ნისლი"),
            keywords: &["ამინდი", "ნისლი", "ღრუბელი"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: None,
            keywords: &["asigna"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("тұман"),
            keywords: &["ауа райы", "бұлт", "тұман"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("tåge"),
            keywords: &["sky", "tåge", "vejr"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("អ\u{17d0}ព\u{17d2}ទ"),
            keywords: &["ពពក", "អាកាសធាត\u{17bb}", "អ\u{17d0}ព\u{17d2}ទ"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಮಂಜು"),
            keywords: &["ಮಂಜು", "ಹವಾಮಾನ", "ಹ\u{cbf}ಮ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("안개"),
            keywords: &["구름", "물결표시", "안개"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("ध\u{941}क\u{947}\u{902}"),
            keywords: &["ढग", "ध\u{941}क\u{947}\u{902}"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("туман"),
            keywords: &["аба ырайы", "булут", "туман"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Niwwel"),
            keywords: &["Niwwel", "Wollek"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໝອກ"),
            keywords: &["ສະພາບອາກາດ", "ເມກ", "ໝອກ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("ūkana"),
            keywords: &["debesis", "ūkana"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("migla"),
            keywords: &["laikapstākļi", "laiks", "migla", "mākonis"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kohu"),
            keywords: &["kapua", "kohu"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("магла"),
            keywords: &["време", "магла", "облак"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("മ\u{d42}ടൽമഞ\u{d4d}ഞ\u{d4d}"),
            keywords: &[
                "ക\u{d3e}ല\u{d3e}വസ\u{d4d}ഥ",
                "മഞ\u{d4d}ഞ\u{d4d}",
                "മ\u{d42}ടൽമഞ\u{d4d}ഞ\u{d4d}",
                "മേഘം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("манан"),
            keywords: &["манан", "үүл"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("ध\u{941}क\u{947}"),
            keywords: &["ढग", "ध\u{941}क\u{947}"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("kabus"),
            keywords: &["awan", "cuaca", "kabus"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("ċpar"),
            keywords: &["sħaba", "ċpar"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("မြ\u{1030}"),
            keywords: &["တ\u{102d}မ\u{103a}", "မြ\u{1030}"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("tåke"),
            keywords: &["sky", "tåke", "vær"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("क\u{941}हिरोल\u{947} ढाक\u{947}को"),
            keywords: &["क\u{941}हिरोल\u{947} ढाक\u{947}को", "बादल", "मौसम"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("mist"),
            keywords: &["mist", "wolk"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("tåke"),
            keywords: &["sky", "tåke", "vÊr"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("କ\u{b41}ହ\u{b41}ଡ\u{b3c}\u{b3f}"),
            keywords: &["କ\u{b41}ହ\u{b41}ଡ\u{b3c}\u{b3f}", "ମେଘ"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਧ\u{a41}\u{a70}ਦ"),
            keywords: &["ਧ\u{a41}\u{a70}ਦ", "ਬ\u{a71}ਦਲ", "ਮ\u{a4c}ਸਮ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("دھ\u{64f}ند"),
            keywords: &["بدل", "دھ\u{64f}ند"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Fọg"),
            keywords: &["Fọg", "Klaud"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("mgła"),
            keywords: &["mgła", "pogoda"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("خوپڼه"),
            keywords: &["خوپټه", "خوپڼه", "ورېځ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("nevoeiro"),
            keywords: &["clima", "furacão", "nevoeiro", "nuvem"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("nevoeiro"),
            keywords: &["meteorologia", "nevoeiro", "nuvem", "névoa"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("pukutay"),
            keywords: &["pukutay", "puyu"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("ceață"),
            keywords: &["ceață", "nor", "vreme"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-240"),
            keywords: &["E10-240"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("густой туман"),
            keywords: &[
                "видимость",
                "густой туман",
                "низкая видимость",
                "плохая видимость",
                "туман",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ibihu"),
            keywords: &["ibihu", "karawudi"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڌنڌ"),
            keywords: &["ڌنڌ", "ڪڪر"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ම\u{dd3}ද\u{dd4}ම"),
            keywords: &[
                "ක\u{dcf}ලග\u{dd4}ණය",
                "ම\u{dd3}ද\u{dd4}ම",
                "වල\u{dcf}ක\u{dd4}ළ",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("hmla"),
            keywords: &["hmla", "oblak", "počasie"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("megla"),
            keywords: &["megla", "oblak", "vreme"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("ciiryaamo"),
            keywords: &["ciiryaamo", "daruur"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("mjegull"),
            keywords: &["mjegull", "moti", "re"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("магла"),
            keywords: &["oблaк", "магла"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["магла"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("magla"),
            keywords: &["magla", "oblak"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["magla"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("dimma"),
            keywords: &["dimma", "dimmigt", "väder"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("ukungu"),
            keywords: &["hali ya hewa", "ukungu", "wingu"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("மூடுபனி"),
            keywords: &["மூடுபனி", "வெப\u{bcd}பநிலை"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ప\u{c4a}గమంచు"),
            keywords: &["ప\u{c4a}గ", "ప\u{c4a}గమంచు", "మంచు"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("туман"),
            keywords: &["абр", "туман"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("หมอก"),
            keywords: &["สภาพอากาศ", "หมอก", "เมฆ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ümür"),
            keywords: &["bulut", "ümür"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("kakapu"),
            keywords: &["kakapu"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("sis"),
            keywords: &["bulut", "hava durumu", "sis"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("تۇمان"),
            keywords: &["بۇلۇت", "تۇمان"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("туман"),
            keywords: &["погода", "туман", "хмара"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ک\u{64f}ہر"),
            keywords: &["بادل", "موسم", "ک\u{64f}ہر"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("tuman"),
            keywords: &["bulut", "ob-havo", "tuman"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("sương mù"),
            keywords: &["mây", "sương mù"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("ab lay"),
            keywords: &["ab lay", "niir"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("inkungu"),
            keywords: &["ilifu", "inkungu"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("kùrukùru"),
            keywords: &["kùrukùru", "òfurufú"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("霧"),
            keywords: &["雲", "霧"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("雾"),
            keywords: &["云", "雾"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("雾"),
            keywords: &["雾", "霾"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("有霧"),
            keywords: &["天氣", "有霧"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("inkungu"),
            keywords: &["ifu", "inkungu", "isimo sezulu"],
        },
    ],
};
#[doc = "🌬\u{fe0f}"]
pub const WIND_FACE: crate::Emoji = crate::Emoji {
    glyph: "🌬\u{fe0f}",
    codepoint: "1F32C FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.7f32,
    name: "wind face",
    group: "Travel & Places",
    subgroup: "sky & weather",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🌬",
        codepoint: "1F32C",
        status: crate::Status::Unqualified,
        introduction_version: 0.7f32,
        name: "wind face",
        group: "Travel & Places",
        subgroup: "sky & weather",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("windgesig"),
            keywords: &["blaas", "gesig", "weer", "wind", "windgesig", "wolk"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የነፋስ ፊት"),
            keywords: &["መንፈስ", "ነፋስ", "የነፋስ ፊት", "የአየር ንብረት", "ደመና"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("رياح"),
            keywords: &["رياح", "سحاب", "طقس", "هبوب", "وجه"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("বত\u{9be}হৰ ম\u{9c1}খ"),
            keywords: &[
                "ড\u{9be}ৱৰ",
                "বত\u{9be}হ",
                "বত\u{9be}হৰ ম\u{9c1}খ",
                "ম\u{9c1}খ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("külək üzü"),
            keywords: &["bulud", "hava", "külək", "külək üzü", "üz", "əsmək"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("твар ветру"),
            keywords: &["вецер", "надвор’е", "твар", "твар ветру"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("лице, издухващо вятър"),
            keywords: &[
                "време",
                "вятър",
                "издухвам",
                "лице",
                "лице, издухващо вятър",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("হ\u{9be}ওয\u{9bc}\u{9be}র ম\u{9c1}খ"),
            keywords: &[
                "আবহ\u{9be}ওয\u{9bc}\u{9be}",
                "ম\u{9c1}খ",
                "মেঘ",
                "হ\u{9be}ওয\u{9bc}\u{9be}",
                "হ\u{9be}ওয\u{9bc}\u{9be}র ম\u{9c1}খ",
                "হ\u{9be}ল\u{9cd}ক\u{9be} হ\u{9be}ওয\u{9bc}\u{9be}",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("lice u vjetru"),
            keywords: &["lice", "lice u vjetru", "prognoza", "vjetar", "vrijeme"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("vent"),
            keywords: &["bufar", "cara", "núvol", "vent"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎦᏃᎸᏍᎬ ᎤᎸᏛ"),
            keywords: &["ᎤᎧᏛ", "ᎤᎶᎩᎳ", "ᎦᏃᎸᏍᎩ", "ᎦᏃᎸᏍᎬ", "ᎦᏃᎸᏍᎬ ᎤᎸᏛ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("větrný obličej"),
            keywords: &[
                "foukající",
                "foukat",
                "fouká",
                "mrak",
                "oblak",
                "počasí",
                "smajlík",
                "tvář",
                "vane",
                "vanoucí",
                "vánek",
                "vát",
                "vítr",
                "výraz",
                "větrný obličej",
                "větřík",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("wyneb gwyntog"),
            keywords: &["chwythu", "cwmwl", "wyneb", "wyneb gwyntog"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("vindansigt"),
            keywords: &["ansigt", "blæse", "sky", "vejr", "vind", "vindansigt"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Wind"),
            keywords: &["Wetter", "Wind", "windig"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("πρόσωπο ανέμου"),
            keywords: &[
                "άνεμος",
                "αέρας",
                "καιρός",
                "πρόσωπο",
                "πρόσωπο ανέμου",
                "σύννεφο",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("wind face"),
            keywords: &["blow", "cloud", "face", "wind"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("cara de viento"),
            keywords: &["cara", "cara de viento", "nube", "soplar", "viento"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["cara", "cara de viento", "clima", "soplar", "viento"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["cara", "cara de viento", "nube", "soplar", "viento"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("näoga tuul"),
            keywords: &["ilm", "nägu", "näoga tuul", "tuul"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("haize-aurpegia"),
            keywords: &[
                "aurpegia",
                "eguraldia",
                "haize-aurpegia",
                "haizea",
                "hodeia",
                "putz",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("صورت باد"),
            keywords: &["آب\u{200c}وهوا", "ابر", "باد", "صورت", "وزیدن"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("puhuri"),
            keywords: &["pilvi", "puhuri", "puuska", "sää", "tuuli"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("mukha ng hangin"),
            keywords: &[
                "hangin",
                "lagay ng panahon",
                "mukha",
                "mukha ng hangin",
                "umiihip",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("andlit sum blæsur vind"),
            keywords: &["andlit", "andlit sum blæsur vind", "blás", "skýggj", "vind"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("vent avec visage"),
            keywords: &["météo", "souffle", "vent", "vent avec visage", "visage"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("visage qui souffle du vent"),
            keywords: &[
                "météo",
                "souffle",
                "vent",
                "visage",
                "visage qui souffle du vent",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("aghaidh na gaoithe"),
            keywords: &[
                "aghaidh",
                "aghaidh gaothach",
                "aghaidh na gaoithe",
                "gaoth",
                "scamall",
                "séideadh",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("aodann na gaoithe"),
            keywords: &[
                "aodann",
                "aodann na gaoithe",
                "gaoth",
                "neul",
                "sgòth",
                "sèideadh",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("vento"),
            keywords: &["cara", "meteoroloxía", "soprar", "vento"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("પવનનો ચહ\u{ac7}રો"),
            keywords: &[
                "ચહ\u{ac7}રો",
                "પવનનો ચહ\u{ac7}રો",
                "વાદળ",
                "વાય\u{ac1}",
                "હવા",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("fuskar iska"),
            keywords: &["fuska", "fuskar iska", "gajimare", "iska", "kaɗe"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("פני רוח נושבת"),
            keywords: &["נושבת", "פני רוח נושבת", "פנים", "רוח"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("तिरछा च\u{947}हरा"),
            keywords: &["च\u{947}हरा", "तिरछा च\u{947}हरा"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("lice vjetra"),
            keywords: &[
                "lice",
                "lice vjetra",
                "oblak",
                "puhanje",
                "vjetar",
                "vrijeme",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("szélarc"),
            keywords: &["arc", "időjárás", "szeles", "szél", "szélarc"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("քամու երես"),
            keywords: &["ամպ", "դեմք", "եղանակ", "փչել", "քամի", "քամու երես"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("wajah tertiup angin"),
            keywords: &[
                "angin",
                "awan",
                "cuaca",
                "hembusan",
                "wajah",
                "wajah tertiup angin",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ihu ìkùkù"),
            keywords: &["fepụ", "ihu", "urukpu", "ìkùkù"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("veðurandlit"),
            keywords: &["andlit", "blæs", "ský", "veðurandlit", "vindur"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("vento"),
            keywords: &["Eolo", "aria", "vento"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("顔のある風"),
            keywords: &["顔", "顔のある風", "風"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("rai anyebul angin"),
            keywords: &["angin", "mega", "nyebul", "rai", "rai anyebul angin"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ქარის სახე"),
            keywords: &["ამინდი", "სახე", "ქარი", "ქარის სახე", "ღრუბელი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("бет көрінісіндегі жел"),
            keywords: &["бет", "бет көрінісіндегі жел", "бұлт", "жел", "жел соғу"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("vindansigt"),
            keywords: &["ansigt", "blæse", "sky", "vejr", "vind", "vindansigt"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ម\u{17bb}ខខ\u{17d2}យល\u{17cb}"),
            keywords: &[
                "ខ\u{17d2}យល\u{17cb}",
                "ផ\u{17d2}ល\u{17bb}\u{17c6}",
                "ម\u{17bb}ខ",
                "ម\u{17bb}ខខ\u{17d2}យល\u{17cb}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಗಾಳ\u{cbf}ಯ ಮುಖ"),
            keywords: &[
                "ಗಾಳ\u{cbf}",
                "ಗಾಳ\u{cbf}ಯ ಮುಖ",
                "ಗಾಳ\u{cbf}ಯ\u{cbf}ಂದ ಕ\u{cc2}ಡ\u{cbf}ದ ಹವಾಮಾನ",
                "ಮುಖ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("얼굴이 있는 바람"),
            keywords: &["바람", "바람 얼굴", "얼굴이 있는 바람"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("वा-याचो च\u{947}रो"),
            keywords: &[
                "च\u{947}रो",
                "ढग",
                "वा-याचो च\u{947}रो",
                "वार\u{947}\u{902}",
                "व\u{94d}हा\u{902}वता",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("шамалдын бети"),
            keywords: &["бет", "булут", "шамал", "шамалдын бети", "үйлө"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Wandgesiicht"),
            keywords: &["Gesiicht", "Wand", "Wandgesiicht", "Wollek", "blosen"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໜ\u{ec9}າເປ\u{ebb}\u{ec8}າລ\u{ebb}ມ"),
            keywords: &[
                "ລ\u{ebb}ມ",
                "ລ\u{ebb}ມພ\u{eb1}ດ",
                "ສະພາບອາກາດ",
                "ໜ\u{ec9}າ",
                "ໜ\u{ec9}າເປ\u{ebb}\u{ec8}າລ\u{ebb}ມ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("vėjo veidas"),
            keywords: &["debesis", "pūsti", "veidas", "vėjas", "vėjo veidas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("pūš vējš"),
            keywords: &["laikapstākļi", "laiks", "pūst", "pūš vējš", "vējš"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kanohi hau"),
            keywords: &["hau", "kanohi", "kapua", "pupuhi"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("лице на ветер"),
            keywords: &["време", "дува", "лице", "лице на ветер", "облак"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ക\u{d3e}റ\u{d4d}റ\u{d4d}"),
            keywords: &[
                "ക\u{d3e}റ\u{d4d}റ\u{d4d}",
                "ക\u{d3e}ല\u{d3e}വസ\u{d4d}ഥ",
                "മേഘം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("салхиар үлээж буй нүүр"),
            keywords: &["нүүр", "салхи", "салхиар үлээж буй нүүр", "үлээх", "үүл"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("वार\u{94d}\u{200d}यासमोर"),
            keywords: &[
                "च\u{947}हरा",
                "ढग",
                "वारा",
                "वार\u{94d}\u{200d}यासमोर",
                "वाऱ\u{94d}यासमोर",
                "वाहण\u{947}",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("muka angin"),
            keywords: &["angin", "awan", "cuaca", "meniup", "muka"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("wiċċ tar-riħ"),
            keywords: &["jonfoħ", "riħ", "sħaba", "wiċċ", "wiċċ tar-riħ"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("လေတ\u{102d}\u{102f}က\u{103a} မျက\u{103a}န\u{103e}ာ"),
            keywords: &[
                "တ\u{102d}မ\u{103a}",
                "မျက\u{103a}န\u{103e}ာ",
                "လေ",
                "လေတ\u{102d}\u{102f}က\u{103a} မျက\u{103a}န\u{103e}ာ",
                "လေတ\u{102d}\u{102f}က\u{103a}ခြင\u{103a}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("vindansikt"),
            keywords: &["blåse", "fjes", "sky", "vind", "vindansikt", "vær"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("स\u{941}स\u{94d}ताइरह\u{947}को अन\u{941}हार"),
            keywords: &[
                "अन\u{941}हार",
                "प\u{94d}रवाह",
                "बादल",
                "स\u{941}स\u{94d}ताइरह\u{947}को अन\u{941}हार",
                "हावा",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("gezicht dat wind blaast"),
            keywords: &[
                "blazen",
                "gezicht",
                "gezicht dat wind blaast",
                "wind",
                "wolk",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("vindandlet"),
            keywords: &["blåse", "fjes", "sky", "vind", "vindandlet", "vêr"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ପବନ ମ\u{b41}ହ\u{b01}"),
            keywords: &[
                "ଉଡ\u{b3c}\u{b3e}ଇବ\u{b3e}",
                "ପବନ",
                "ମ\u{b41}ହ\u{b01}",
                "ମେଘ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਹਵਾ"),
            keywords: &[
                "ਚਿਹਰਾ",
                "ਬ\u{a71}ਦਲ",
                "ਮ\u{a4c}ਸਮ",
                "ਹਵਾ",
                "ਹਵਾ ਦਾ ਬ\u{a41}\u{a71}ਲਾ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("شکل تے پ\u{64f}ھونک مارنا"),
            keywords: &[
                "اڈا لے جانا",
                "بدل",
                "دی شکل",
                "شکل تے پ\u{64f}ھونک مارنا",
                "ہوا",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Wínd Fes"),
            keywords: &["Blo", "Fes", "Klaud", "Wind", "Wínd Fes"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("dmuchająca twarz wiatru"),
            keywords: &[
                "chmura",
                "dmuchająca twarz wiatru",
                "pogoda",
                "twarz",
                "wiatr",
                "wiać",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د باد مخ"),
            keywords: &["الوتل", "باد", "د باد مخ", "مخ", "ورېځ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("rosto de vento"),
            keywords: &[
                "clima",
                "nuvem",
                "rosto",
                "rosto de vento",
                "sopro",
                "vento",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("cara de vento"),
            keywords: &[
                "cara",
                "cara de vento",
                "meteorologia",
                "nuvem",
                "soprar",
                "vento",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("wayra uya"),
            keywords: &["phukuy", "puyu", "uya", "wayra"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("față suflând vânt"),
            keywords: &["față", "față suflând vânt", "suflare", "vânt"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-241"),
            keywords: &["E10-241"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("дует ветер"),
            keywords: &["ветер", "дует", "лицо"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("isura yahushywe n’umuyaga"),
            keywords: &[
                "guhuha",
                "ibicu",
                "isura",
                "isura yahushywe n’umuyaga",
                "umuyaga",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("هوائي چهرو"),
            keywords: &["لڳڻ", "هوا", "هوائي چهرو", "چهرو", "ڪڪر"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ස\u{dd4}ළං ම\u{dd4}හ\u{dd4}ණත"),
            keywords: &[
                "ක\u{dcf}ලග\u{dd4}ණය",
                "ප\u{dd2}ඹ\u{dd3}ම",
                "ම\u{dd4}හ\u{dd4}ණ",
                "වල\u{dcf}ක\u{dd4}ළ",
                "ස\u{dd4}ළං ම\u{dd4}හ\u{dd4}ණත",
                "ස\u{dd4}ළඟ",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("vietor"),
            keywords: &["fúkanie", "oblak", "počasie", "tvár", "vietor"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("obraz, ki piha veter"),
            keywords: &[
                "oblak",
                "obraz",
                "obraz, ki piha veter",
                "pihati",
                "veter",
                "vreme",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("waji dabayl"),
            keywords: &["afuuf", "dabayl", "daruur", "waji"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("fytyrë në erë"),
            keywords: &["erë", "fryj", "fytyrë", "fytyrë në erë", "moti"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("лице ветра"),
            keywords: &["oблaк", "вeтaр", "дување", "лице", "лице ветра"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("лице вјетра"),
            keywords: &["лице вјетра"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("lice vetra"),
            keywords: &["duvanje", "lice", "lice vetra", "oblak", "vetar"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("lice vjetra"),
            keywords: &["lice vjetra"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("blåser vind"),
            keywords: &["blåser", "vind", "väder"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("uso unaopuliza upepo"),
            keywords: &[
                "hali ya hewa",
                "puliza",
                "upepo",
                "uso",
                "uso unaopuliza upepo",
                "wingu",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("க\u{bbe}ற\u{bcd}று வ\u{bc0}சும\u{bcd} க\u{bbe}ட\u{bcd}சி"),
            keywords: &[
                "க\u{bbe}ற\u{bcd}று",
                "க\u{bbe}ற\u{bcd}று வ\u{bc0}சுதல\u{bcd}",
                "க\u{bbe}ற\u{bcd}று வ\u{bc0}சும\u{bcd} க\u{bbe}ட\u{bcd}சி",
                "வெப\u{bcd}பநிலை",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("గ\u{c3e}ల\u{c3f} ముఖం"),
            keywords: &["గ\u{c3e}ల\u{c3f}", "ముఖం"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("рӯи шамол"),
            keywords: &["абр", "вазидан", "рӯи шамол", "рӯй", "шамол"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("พ\u{e48}นลม"),
            keywords: &["พ\u{e48}นลม", "ลมพ\u{e31}ด", "สภาพอากาศ", "เมฆ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("şemal ýüz"),
            keywords: &["bulut", "öwüsmek", "ýüz", "şemal"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("mataʻi matangi"),
            keywords: &["mataʻi matangi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("rüzgar"),
            keywords: &["esme", "hava durumu", "rüzgar"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("شامال چىراي"),
            keywords: &["بۇلۇت", "شامال", "پۈۋلەش", "چىراي"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("обличчя, що дме"),
            keywords: &[
                "вітер",
                "віяти",
                "обличчя",
                "обличчя, що дме",
                "погода",
                "хмара",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("منہ سے ہوا نکالتا چہرہ"),
            keywords: &["بادل", "منہ سے ہوا نکالتا چہرہ", "موسم", "چہرہ", "ہوا"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("shamol qiyofasi"),
            keywords: &[
                "bulut",
                "esish",
                "ob-havo",
                "puflash",
                "shamol",
                "shamol qiyofasi",
                "yuz",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("khuôn mặt gió"),
            keywords: &["gió", "khuôn mặt gió", "mặt", "thổi", "đám mây"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("kanamu ngelaw"),
            keywords: &["kanam", "kanamu ngelaw", "ngelaw", "niir", "uppu"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ubuso bomoya"),
            keywords: &["ilifu", "ubuso", "ubuso bomoya", "umoya", "vuthela"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("ojú atẹ\u{301}gùn"),
            keywords: &["atẹ\u{301}gùn", "ojú", "tayọ", "òfurufú"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("風臉"),
            keywords: &["吹", "臉", "雲", "風", "風臉"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("风脸"),
            keywords: &["云", "吹", "脸", "风", "风脸"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("大风"),
            keywords: &["大风", "狂风"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("刮風"),
            keywords: &["刮風", "天氣"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("風吹臉"),
            keywords: &["刮風", "天氣", "風吹臉"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ubuso bomoya"),
            keywords: &[
                "ifu",
                "isimo sezulu",
                "phephetha",
                "ubuso",
                "ubuso bomoya",
                "umoya",
            ],
        },
    ],
};
#[doc = "🌀"]
pub const CYCLONE: crate::Emoji = crate::Emoji {
    glyph: "🌀",
    codepoint: "1F300",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "cyclone",
    group: "Travel & Places",
    subgroup: "sky & weather",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("sikloon"),
            keywords: &["duiselig", "sikloon", "storm", "tifoon", "weer"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ሳይክሎን"),
            keywords: &["ሳይክሎን", "ታይፉን", "ትዊስተር", "የአየር ንብረት", "ዲዚ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("عاصفة"),
            keywords: &["إعصار", "تيفون", "دوار", "طقس", "عاصفة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ঘ\u{9c2}ৰ\u{9cd}ণিব\u{9be}য\u{9bc}\u{9c1}"),
            keywords: &[
                "ঘ\u{9c2}ৰ\u{9cd}ণিব\u{9be}য\u{9bc}\u{9c1}",
                "ট\u{9be}ইফ’ন",
                "ট\u{9c1}ইষ\u{9cd}ট\u{9be}ৰ",
                "বিভ\u{9cd}ৰ\u{9be}ন\u{9cd}তিকৰ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("siklon"),
            keywords: &["başgicəllənmə", "hava", "qasırğa", "siklon", "tufan"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("цыклон"),
            keywords: &["завіхрэнне", "надвор’е", "тайфун", "ураган", "цыклон"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("циклон"),
            keywords: &["вихър", "време", "тайфун", "циклон"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("স\u{9be}ইক\u{9cd}লোন"),
            keywords: &[
                "আবহ\u{9be}ওয\u{9bc}\u{9be}",
                "ট\u{9be}ইফ\u{9c1}ন",
                "বিভ\u{9cd}র\u{9be}ন\u{9cd}তিকর",
                "স\u{9be}ইক\u{9cd}লোন",
                "হতব\u{9c1}দ\u{9cd}ধি",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("kelcʼhwidenn"),
            keywords: &["kelcʼhwidenn", "tifon"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("ciklon"),
            keywords: &["ciklon", "prognoza", "tajfun", "vrijeme"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cicló"),
            keywords: &["cicló", "mareig", "remolí", "temps", "tifó"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᎦᎷᎦ ᎡᏆ"),
            keywords: &["ᎠᎦᎷᎦ ᎡᏆ", "ᎠᎦᎷᎦ ᎤᏍᏗ", "ᎠᎦᎷᎦ ᎤᏔᎾ", "ᎠᎺᏉᎯ ᎡᏙᎲ ᎠᎦᎷᎦ", "ᎤᎸᏕᎯᏓ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("cyklóna"),
            keywords: &[
                "cyklón", "cyklóna", "hurikán", "počasí", "tajfun", "twister", "závrať",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("seiclon"),
            keywords: &["corwynt", "penysgafn", "seiclon", "twister", "typhoon"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("cyklon"),
            keywords: &["cyklon", "svimmel", "tornado", "tyfon"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Wirbel"),
            keywords: &["Spirale", "Wirbel", "Wirbelsturm"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κυκλώνας"),
            keywords: &["ζαλισμένος", "καιρός", "κυκλώνας", "τυφώνας"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("cyclone"),
            keywords: &["cyclone", "dizzy", "hurricane", "twister", "typhoon"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: None,
            keywords: &["cyclone", "dizzy", "hurricane", "typhoon"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("ciclón"),
            keywords: &["ciclón", "mareo", "tifón", "tornado"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["ciclón", "clima", "huracán", "tifón", "tornado"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["ciclón", "huracán", "mareado", "tifón", "tornado"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("tsüklon"),
            keywords: &["ilm", "orkaan", "taifuun", "tornaado", "tsüklon"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("zikloia"),
            keywords: &["eguraldi", "tifoi", "tornado", "zikloia", "zorabio"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("چرخند"),
            keywords: &[
                "آب\u{200c}وهوا",
                "طوفان موسمی",
                "پیچند",
                "چرخند",
                "چرخ\u{200c}باد",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("pyörremyrsky"),
            keywords: &["hirmumyrsky", "pyörre", "pyörremyrsky", "sykloni", "sää"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("buhawi"),
            keywords: &["bagyo", "buhawi", "ipu-ipo", "nahihilo", "panahon"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("meldurhvirla"),
            keywords: &[
                "meldurhvirla",
                "stormur",
                "tropisk ódn",
                "veðrið",
                "veður",
                "ódn",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("cyclone"),
            keywords: &["cyclone", "tourbillon"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("cyclone"),
            keywords: &["cyclone", "ouragan", "tourbillon", "typhon"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("cioclón"),
            keywords: &["cioclón", "cuaranfa", "iomghaoth"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("cuairt-gaoithe"),
            keywords: &["cuairt", "cuairt-gaoithe", "gaoith", "tuaineal"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("ciclón"),
            keywords: &["ciclón", "furacán", "tifón", "tornado"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ચક\u{acd}રવાત"),
            keywords: &[
                "ચક\u{acd}રવાત",
                "ટ\u{acd}વિસ\u{acd}ટર",
                "પ\u{acd}રચ\u{a82}ડ તોફાન",
                "વ\u{a82}ટોળિયો",
                "વાવાઝોડ\u{ac1}",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("babban ruwa da iska"),
            keywords: &[
                "babban ruwa da iska",
                "guguwa mai ƙarfi",
                "guguwar iska tare da ruwa",
                "jiri",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("הוריקן"),
            keywords: &["הוריקן", "מסתובב", "מסתלסל", "ספירלה", "ציקלון"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("चक\u{94d}रवात, त\u{942}फ\u{93c}ान"),
            keywords: &[
                "चक\u{94d}कर",
                "चक\u{94d}रवात",
                "चक\u{94d}रवात, त\u{942}फ\u{93c}ान",
                "त\u{942}फ\u{93c}ान",
                "बव\u{902}डर",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("ciklona"),
            keywords: &[
                "ciklona",
                "orkan",
                "pijavica",
                "tajfun",
                "vrijeme",
                "vrtoglavica",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("ciklon"),
            keywords: &["ciklon", "hurrikán", "időjárás", "tájfun"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ցիկլոն"),
            keywords: &["եղանակ", "թայֆուն", "պտտվող", "ցիկլոն"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("topan"),
            keywords: &["berputar-putar", "cuaca", "pusaran", "topan"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("oke ìkùkù okirikiri"),
            keywords: &[
                "ajọo ìkùkù na mmiri",
                "ajụ\u{300}",
                "ntụghị",
                "oke ìkùkù okirikiri",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("fellibylur"),
            keywords: &[
                "fellibylur",
                "hvirfilbylur",
                "hvirfilvindur",
                "snýst",
                "stormsveipur",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("ciclone"),
            keywords: &["ciclone", "tifone", "tornado"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("渦巻き"),
            keywords: &[
                "めまい",
                "もやもや",
                "サイクロン",
                "ハリケーン",
                "台風",
                "渦巻き",
            ],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("angin siklon"),
            keywords: &[
                "angin ribut",
                "angin siklon",
                "muser-muser",
                "siklon",
                "topan",
                "tornado",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ციკლონი"),
            keywords: &["ამინდი", "გაბრუებული", "ტაიფუნი", "ქარბორბალა", "ციკლონი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("циклон"),
            keywords: &["айналу", "ауа райы", "боран", "тайфун", "циклон"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("cyklon"),
            keywords: &["cyklon", "svimmel", "tornado", "tyfon"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("រង\u{17d2}វង\u{17cb}គ\u{17bc}ថខ\u{17d2}យង"),
            keywords: &[
                "ក\u{17bc}ច",
                "គ\u{17bc}ថខ\u{17d2}យង",
                "រង\u{17d2}វង\u{17cb}",
                "រង\u{17d2}វង\u{17cb}គ\u{17bc}ថខ\u{17d2}យង",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಚಂಡಮಾರುತ"),
            keywords: &[
                "ಚಂಡಮಾರುತ",
                "ಟೈಫ\u{cc2}ನ\u{ccd}",
                "ಟ\u{ccd}ವ\u{cbf}ಸ\u{ccd}ಟರ\u{ccd}",
                "ಹರ\u{cbf}ಕೇನ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("태풍"),
            keywords: &["사이클론", "소용돌이", "태풍", "태풍의 눈"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("चक\u{94d}रीवादळ"),
            keywords: &[
                "घ\u{941}स\u{94d}पल\u{94d}ल\u{947}\u{902}",
                "चक\u{94d}कर",
                "चक\u{94d}रीवादळ",
                "टायफ\u{942}न",
                "ह\u{941}रीक\u{947}न",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("циклон"),
            keywords: &["аба ырайы", "смерч", "тайфун", "циклон"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Zyklon"),
            keywords: &["Schwindel", "Taifun", "Twister", "Zyklon"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ລ\u{ebb}ມໝ\u{eb9}ນ"),
            keywords: &[
                "ພະຍ\u{eb8}ໝ\u{eb9}ນ",
                "ລ\u{ebb}ມໝ\u{eb9}ນ",
                "ໄຕ\u{ec9}ຝ\u{eb8}\u{ec8}ນ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("ciklonas"),
            keywords: &["apsvaigęs", "ciklonas", "spiralė", "taifūnas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("ciklons"),
            keywords: &["ciklons", "laikapstākļi", "laiks"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kurahau awatea"),
            keywords: &["huripari", "kurahau awatea", "paroro", "āmaimai"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("циклон"),
            keywords: &["ветер", "време", "циклон"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("കൊട\u{d41}ങ\u{d4d}ക\u{d3e}റ\u{d4d}റ\u{d4d}"),
            keywords: &[
                "കൊട\u{d41}ങ\u{d4d}ക\u{d3e}റ\u{d4d}റ\u{d4d}",
                "ച\u{d41}ഴലിക\u{d4d}ക\u{d3e}റ\u{d4d}റ\u{d4d}",
                "ടൈഫ\u{d42}ൺ",
                "സൈക\u{d4d}ലോൺ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("циклон"),
            keywords: &["угалз", "хар салхи", "хуй салхи", "циклон"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("चक\u{94d}रीवादळ"),
            keywords: &[
                "चक\u{94d}रीवादळ",
                "त\u{941}फान",
                "प\u{94d}रच\u{902}ड चक\u{94d}रीवादळ",
                "भोवरा",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("taufan"),
            keywords: &["cuaca", "pening", "puting beliung", "taufan"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("ċiklun"),
            keywords: &["stordut", "tifun", "twister", "ċiklun"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဆ\u{102d}\u{102f}င\u{103a}ကလ\u{102f}န\u{103a}း"),
            keywords: &[
                "ဆ\u{102d}\u{102f}က\u{103a}ကလ\u{102f}န\u{103a}း",
                "ဆ\u{102d}\u{102f}င\u{103a}ကလ\u{102f}န\u{103a}း",
                "တ\u{102d}\u{102f}င\u{103a}ဖ\u{102f}န\u{103a}း",
                "မ\u{1030}းဝေခြင\u{103a}း",
                "လေဆင\u{103a}န\u{103e}ာမောင\u{103a}း",
                "ဟာရ\u{102e}က\u{102d}န\u{103a}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("syklon"),
            keywords: &["orkan", "svimmel", "syklon", "tornado"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("ह\u{941}ण\u{94d}डरी"),
            keywords: &[
                "ट\u{94d}विस\u{94d}टर",
                "मौ\u{902}सम",
                "रि\u{902}गटा",
                "ह\u{941}ण\u{94d}डरी",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("cycloon"),
            keywords: &["cycloon", "duizelig", "twister", "tyfoon"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("syklon"),
            keywords: &["orkan", "svimmel", "syklon", "tornado"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ବ\u{b3e}ତ\u{b4d}ୟ\u{b3e}"),
            keywords: &[
                "ଖଣ\u{b4d}ଡ\u{b3f}ଆଭ\u{b42}ତ",
                "ତୋଫ\u{b3e}ନ",
                "ପ\u{b4d}ରବଳ ଝଡ\u{b3c}",
                "ବ\u{b3e}ତ\u{b4d}ୟ\u{b3e}",
                "ମ\u{b41}ଣ\u{b4d}ଡ ଘ\u{b41}ର\u{b3e}ଇ ଦେବ\u{b3e} ଅବସ\u{b4d}ଥ\u{b3e}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਝ\u{a71}ਖੜ"),
            keywords: &[
                "ਝ\u{a71}ਖੜ",
                "ਟਵਿਸਟਰ",
                "ਤ\u{a42}ਫ\u{a3c}ਾਨ",
                "ਧ\u{a41}\u{a70}ਦਲਾ",
                "ਬ\u{a47}ਹ\u{a4b}ਸ\u{a3c}ੀ",
                "ਮ\u{a4c}ਸਮ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ہنیری"),
            keywords: &["بدحواس", "طوفانی ہوا", "مڑوڑن آلی شے", "ہنیری"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Saiklon"),
            keywords: &[
                "Ai De Tọ\u{301}n Pẹ\u{301}sin",
                "Họ\u{301}riken",
                "Saiklon",
                "Taifun",
                "Tonédo Wind Wé De Tọ\u{301}n Raúnd An Raund",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("cyklon"),
            keywords: &["cyklon", "pogoda", "spirala", "tajfun"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("سایکلون"),
            keywords: &[
                "بړبوکۍ",
                "تاويدونکي",
                "سايکلون",
                "سایکلون",
                "سر تاوېدل",
                "طوفان",
            ],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("ciclone"),
            keywords: &["ciclone", "furacão", "twister", "zonzo"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["ciclone", "meteorologia", "tufão"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("ciclón"),
            keywords: &["ciclón"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("ciclon"),
            keywords: &["ciclon", "taifun", "uragan", "vârtej"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-199"),
            keywords: &["E10-199"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("циклон"),
            keywords: &["завихрение", "тайфун", "циклон"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("serwakira"),
            keywords: &["isata", "isereri", "serwakira"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("سائيڪلون"),
            keywords: &["آنڌي", "سائيڪلون", "شهتير", "چڪر"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("සය\u{dd2}ක\u{dca}ලෝනය"),
            keywords: &[
                "කරකැවෙන",
                "ක\u{dcf}ලග\u{dd4}ණය",
              