#[doc = "⛪"]
pub const CHURCH: crate::Emoji = crate::Emoji {
    glyph: "⛪",
    codepoint: "26EA",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "church",
    group: "Travel & Places",
    subgroup: "place-religious",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("kerk"),
            keywords: &["christelik", "gebou", "godsdiens", "kerk", "kruis"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ቤተክርስትያን"),
            keywords: &["ሕንጻ", "መስቀል", "ቤተክርስትያን", "ኃይማኖት", "ክርስትያን"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("كنيسة"),
            keywords: &["كنيسة", "مبنى"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("গীৰ\u{9cd}জ\u{9be}ঘৰ"),
            keywords: &[
                "ক\u{9cd}ৰছ",
                "খ\u{9cd}ৰীষ\u{9cd}ট\u{9be}ন",
                "গীৰ\u{9cd}জ\u{9be}ঘৰ",
                "ধৰ\u{9cd}ম",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("kilsə"),
            keywords: &["bina", "din", "kilsə", "xaç", "xristian"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("царква"),
            keywords: &["касцёл", "рэлігія", "хрысціянства", "царква"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("църква"),
            keywords: &["кръст", "религия", "сграда", "християнство", "църква"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("চ\u{9be}র\u{9cd}চ"),
            keywords: &[
                "ক\u{9cd}রস",
                "খ\u{9c3}স\u{9cd}ট\u{9be}ন",
                "চ\u{9be}র\u{9cd}চ",
                "ধর\u{9cd}ম",
                "বিল\u{9cd}ডিং",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("iliz"),
            keywords: &["iliz", "kristen", "kroaz", "relijion"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("crkva"),
            keywords: &["crkva", "katolicizam", "krst", "religija", "zgrada"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("església"),
            keywords: &["creu", "cristià", "edifici", "església", "religió"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏧᏂᎳᏫᏍᏗ"),
            keywords: &["ᎤᏃᎯᏳᏒᎢ", "ᏓᏓᎿᏫᏍᏛ", "ᏧᏁᏟᏗ", "ᏧᏂᎳᏫᏍᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("kostel"),
            keywords: &["budova", "kostel", "křesťanství", "kříž", "náboženství"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("eglwys"),
            keywords: &["adeilad", "crefydd", "cristnogol", "croes", "eglwys"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("kirke"),
            keywords: &["bygning", "kirke", "kors", "kristen", "religion"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Kirche"),
            keywords: &[
                "Christ",
                "Christentum",
                "Gebäude",
                "Kirche",
                "Kreuz",
                "Religion",
                "christlich",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("εκκλησία"),
            keywords: &["εκκλησία", "θρησκεία", "σταυρός", "χριστιανικό"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("church"),
            keywords: &["Christian", "church", "cross", "religion"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("iglesia"),
            keywords: &["cristianismo", "cruz", "edificio", "iglesia", "religión"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["cristianismo", "edificio", "iglesia", "religión"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kirik"),
            keywords: &["kirik", "kristlus", "maja", "rist", "usk"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("eliza"),
            keywords: &["eliza", "eraikin", "erlijio", "gurutze", "kristau"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("کلیسا"),
            keywords: &["دین", "ساختمان", "صلیب", "مذهب", "مسیحیت", "کلیسا"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kirkko"),
            keywords: &["kirkko", "kristinusko", "rakennus", "uskonto"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("simbahan"),
            keywords: &[
                "gusali",
                "katoliko",
                "kristiyanismo",
                "krus",
                "relihiyon",
                "sambahan",
                "simbahan",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("kirkja"),
            keywords: &[
                "kirkja",
                "kristin",
                "religión",
                "trúgv",
                "átrúnaður",
                "átrúni",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("église"),
            keywords: &["bâtiment", "chrétien", "croix", "religion", "église"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("séipéal"),
            keywords: &["foirgneamh", "séipéal"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("eaglais"),
            keywords: &["creideamh", "crois", "crìostaidh", "eaglais"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("igrexa"),
            keywords: &["capela", "cristianismo", "edificio", "igrexa", "relixión"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ચર\u{acd}ચ"),
            keywords: &[
                "ક\u{acd}રોસ",
                "ખ\u{acd}રિસ\u{acd}તી",
                "ચર\u{acd}ચ",
                "ધર\u{acd}મ",
                "ભવન",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("coci"),
            keywords: &["Kirista", "addini", "coci", "kuros"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("כנסייה"),
            keywords: &["דת", "כנסייה", "נוצרי", "נצרות"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("चर\u{94d}च, भवन"),
            keywords: &["चर\u{94d}च", "चर\u{94d}च, भवन", "भवन"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("crkva"),
            keywords: &["crkva", "križ", "kršćanstvo", "religija", "zgrada"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("templom"),
            keywords: &["kereszt", "keresztény", "templom", "vallás", "épület"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("եկեղեցի"),
            keywords: &["եկեղեցի", "խաչ", "կրոն", "շենք", "քրիստոնեական"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("gereja"),
            keywords: &["agama", "bangunan", "gereja", "kristen", "salib"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ụlọụkà"),
            keywords: &["Ndị òtù Christi", "obe", "okpukperechi", "ụlọụkà"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("kirkja"),
            keywords: &["bygging", "kirkja", "kross", "trú"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("chiesa"),
            keywords: &["chiesa", "edificio"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("教会"),
            keywords: &["キリスト教", "宗教", "建物", "教会"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("greja"),
            keywords: &["Kristen", "agama", "greja", "salib"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ეკლესია"),
            keywords: &[
                "ეკლესია",
                "რელიგია",
                "ქრისტიანობა",
                "ქრისტიანული",
                "შენობა",
                "ჯვარი",
            ],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("tamezgida n imasiḥiyen"),
            keywords: &["tamezgida n imasiḥiyen"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("шіркеу"),
            keywords: &["дін", "крест", "христиан", "шіркеу", "құру"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("kirke"),
            keywords: &["bygning", "kirke", "kors", "kristen", "religion"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("វ\u{17b7}ហារ (សាសនាគ\u{17d2}រ\u{17b7}ស\u{17d2}ទ)"),
            keywords: &[
                "គ\u{17d2}រ\u{17b7}ស\u{17d2}ត",
                "ព\u{17d2}រាះវ\u{17b7}ហារ",
                "វ\u{17b7}ហារ (សាសនាគ\u{17d2}រ\u{17b7}ស\u{17d2}ទ)",
                "សាសានា",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಚರ\u{ccd}ಚ\u{ccd}"),
            keywords: &[
                "ಕ\u{ccd}ರ\u{cbf}ಶ\u{ccd}ಚ\u{cbf}ಯನ\u{ccd}",
                "ಚರ\u{ccd}ಚ\u{ccd}",
                "ಧರ\u{ccd}ಮ",
                "ಶ\u{cbf}ಲುಬ\u{cc6}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("교회"),
            keywords: &["건물", "교회", "빌딩", "크리스찬"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("चर\u{94d}च"),
            keywords: &[
                "किरिस\u{94d}ता\u{902}व",
                "क\u{94d}रॉस",
                "चर\u{94d}च",
                "धर\u{94d}म",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("чиркөө"),
            keywords: &["дин", "имарат", "крест", "христиан", "чиркөө"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Kierch"),
            keywords: &["Kierch", "Kräiz", "Relioun", "chrëschtlech"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໂບດ"),
            keywords: &["ຄຣ\u{eb4}ສ", "ສາສະໜາ", "ໂບດ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("bažnyčia"),
            keywords: &["bažnyčia", "krikščionis", "kryžius", "pastatas", "religija"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("baznīca"),
            keywords: &[
                "baznīca",
                "kristieši",
                "krusts",
                "lūgties",
                "māja",
                "reliģija",
                "ēka",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("hāhi"),
            keywords: &["hāhi", "karaitiana", "momo karakia", "rīpeka"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("црква"),
            keywords: &["градба", "крст", "религија", "христијанска", "црква"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("പള\u{d4d}ളി"),
            keywords: &[
                "ക\u{d4d}രിസ\u{d4d}\u{200c}ത\u{d4d}യ\u{d3e}നി",
                "പള\u{d4d}ളി",
                "പ\u{d4d}ര\u{d3e}ർത\u{d4d}ഥന",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("сүм"),
            keywords: &["загалмай", "сүм", "христ", "шашин"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("चर\u{94d}च"),
            keywords: &[
                "क\u{94d}रॉस",
                "ख\u{94d}रिश\u{94d}चन",
                "चर\u{94d}च",
                "धर\u{94d}म",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("gereja"),
            keywords: &["agama", "bangunan", "gereja", "kristian", "salib"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("knisja"),
            keywords: &["Kristjan", "knisja", "reliġjon", "salib"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ခရစ\u{103a}ယာန\u{103a} ဘ\u{102f}ရားကျောင\u{103a}း"),
            keywords: &[
                "ခရစ\u{103a}ယာန\u{103a}",
                "ခရစ\u{103a}ယာန\u{103a} ဘ\u{102f}ရားကျောင\u{103a}း",
                "ဘာသာရေး",
                "လက\u{103a}ဝါးကပ\u{103a}တ\u{102d}\u{102f}င\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("kirke"),
            keywords: &["bygning", "kirke", "kors", "kristen", "religion"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("गिर\u{94d}जाघर"),
            keywords: &[
                "क\u{94d}रस",
                "क\u{94d}रिस\u{94d}चियन",
                "गिर\u{94d}जाघर",
                "चर\u{94d}च",
                "धर\u{94d}म",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("kerk"),
            keywords: &["christelijk", "geloof", "kerk", "kruis"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("kyrkje"),
            keywords: &["bygning", "kristen", "kross", "kyrkje", "religion"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଗୀର\u{b4d}ଜ\u{b3e}"),
            keywords: &[
                "କୋଠ\u{b3e}",
                "ଗୀର\u{b4d}ଜ\u{b3e}",
                "ଚର\u{b4d}ଚ\u{b4d}",
                "ଚର\u{b4d}ଚ\u{b4d}ଚ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਗਿਰਜਾ ਘਰ"),
            keywords: &["ਇਮਾਰਤ", "ਕ\u{a4d}ਰਾਸ", "ਗਿਰਜਾ ਘਰ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("چرچ"),
            keywords: &["عیسائی", "مذہب", "پار کرنا", "چرچ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Chọch"),
            keywords: &["Chọch", "Krístian", "Krọs", "Rilíjọn"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("kościół"),
            keywords: &["chrześcijański", "kościół", "krzyż", "religia", "świątynia"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("کلیسا"),
            keywords: &["صليب", "عيسايي", "مذهب", "کليسا", "کلیسا"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("igreja"),
            keywords: &["igreja", "prédio"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["cristão", "cruz", "igreja", "religião"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("iglesia"),
            keywords: &["Cristiano", "chakana", "iglesia", "religion"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("biserică"),
            keywords: &[
                "biserică",
                "clădire",
                "creștin",
                "creștinism",
                "cruce",
                "rugăciune",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-109"),
            keywords: &["E10-109"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("церковь"),
            keywords: &["здание", "религия", "христианство", "церковь"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("kiliziya"),
            keywords: &["Umukirisitiu", "idini", "kiliziya", "umusaraba"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("چرچ"),
            keywords: &["عيسائي", "مذهب", "چرچ", "ڪراس"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("පල\u{dca}ල\u{dd2}ය"),
            keywords: &[
                "ආගම",
                "ඉද\u{dd2} ක\u{dd2}ර\u{dd3}ම",
                "ක\u{dca}\u{200d}ර\u{dd2}ස\u{dca}ත\u{dd2}ය\u{dcf}න\u{dd2}",
                "ක\u{dd4}ර\u{dd4}සය",
                "පල\u{dca}ල\u{dd2}ය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("kostol"),
            keywords: &["budova", "kostol", "kresťan", "kríž", "náboženstvo"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("cerkev"),
            keywords: &["cerkev", "križ", "krščansko", "vera", "zgradba"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("Kaniisad"),
            keywords: &["Kaniisad", "diin", "kaniisad", "mactab", "masiixi"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("kishë"),
            keywords: &["e krishterë", "fe", "kishë", "kryq", "ndërtesë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("црква"),
            keywords: &["крст", "рeлигиja", "хришћaнствo", "црква"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["црква"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("crkva"),
            keywords: &["crkva", "hrišćanstvo", "krst", "religija"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["crkva"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("kyrka"),
            keywords: &["byggnad", "kristen", "kyrka"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kanisa"),
            keywords: &["dini", "jengo", "kanisa", "msalaba", "ukristo"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("தேவ\u{bbe}லயம\u{bcd}"),
            keywords: &[
                "ஆலயம\u{bcd}",
                "கடவுள\u{bcd}",
                "கோயில\u{bcd}",
                "தேவ\u{bbe}லயம\u{bcd}",
                "பிர\u{bbe}ர\u{bcd}த\u{bcd}தனை",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("చర\u{c4d}చ\u{c3f}"),
            keywords: &["చర\u{c4d}చ\u{c3f}", "చర\u{c4d}చ\u{c4d}"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("калисо"),
            keywords: &["Насронӣ", "дин", "калисо", "салиб"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("โบสถ\u{e4c}"),
            keywords: &[
                "คร\u{e34}สต\u{e4c}",
                "ศาสนสถาน",
                "ศาสนา",
                "โบสถ\u{e4c}",
                "ไม\u{e49}กางเขน",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("buthana"),
            keywords: &["Hristian", "buthana", "din", "haç"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("falelotu"),
            keywords: &["falelotu"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("kilise"),
            keywords: &["Hristiyan", "din", "haç", "kilise"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("چېركاۋ"),
            keywords: &["خىرىستىيان", "دىن", "كىرېست", "چېركاۋ"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("церква"),
            keywords: &["релігія", "хрест", "християнський", "церква"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("گرجا گھر"),
            keywords: &["عمارت", "عیسائیت", "کراس", "گرجا گھر"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("cherkov"),
            keywords: &["bino", "cherkov", "din", "nasroniylik", "xoch"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("nhà thờ"),
            keywords: &["cây thánh giá", "nhà thờ", "tôn giáo", "Đạo cơ đốc"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("jàngu"),
            keywords: &["Kreceŋ", "diine", "jàngu", "kruwaa"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("icawe"),
            keywords: &["Umkristu", "icawe", "umnqamlezo", "unqulo"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ṣọọṣi"),
            keywords: &[
                "àgbélèbú",
                "Ṣọọṣi",
                "ẹlẹ\u{301}sìn ìgbàgbó\u{329}",
                "ẹ\u{300}sìn",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("教堂"),
            keywords: &["十字架", "基督徒", "宗教", "教堂"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("教堂"),
            keywords: &["十字架", "基督徒", "宗教", "教堂"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("教堂"),
            keywords: &["基督", "宗教", "教堂"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("教堂"),
            keywords: &["十字架", "基督教", "教堂"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("isonto"),
            keywords: &["inkolo", "isakhiwo", "isiphambano", "isonto", "umzalwane"],
        },
    ],
};
#[doc = "🕌"]
pub const MOSQUE: crate::Emoji = crate::Emoji {
    glyph: "🕌",
    codepoint: "1F54C",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "mosque",
    group: "Travel & Places",
    subgroup: "place-religious",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("moskee"),
            keywords: &["godsdiens", "islam", "moskee", "moslem"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("መስጂድ"),
            keywords: &["መስጂድ", "ሙስሊም", "ኃይማኖት", "እስላም"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("مسجد"),
            keywords: &["إسلام", "دين", "مسجد", "مسلمون"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("মছজিদ"),
            keywords: &["ইছল\u{9be}ম", "ধৰ\u{9cd}ম", "মছজিদ", "ম\u{9c1}ছলম\u{9be}ন"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("məscid"),
            keywords: &["din", "islam", "müsəlman", "məscid"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("мячэць"),
            keywords: &["мусульманскі", "мячэць", "рэлігія", "іслам"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("джамия"),
            keywords: &["джамия", "ислям", "мюсюлманин", "религия"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("মসজিদ"),
            keywords: &["ইসল\u{9be}ম", "ধর\u{9cd}ম", "মসজিদ", "ম\u{9c1}সলিম"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("moskeenn"),
            keywords: &["islam", "moskeenn", "muzulman", "relijion"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("džamija"),
            keywords: &["džamija", "islam", "musliman", "religija"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("mesquita"),
            keywords: &["islam", "mesquita", "musulmà", "religió"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏗᎦᎳᏫᏍᏗ"),
            keywords: &["ᎢᏏᎳᎻ", "ᎤᏃᎯᏳᏒ", "ᎹᏏᎳᎻ", "ᏗᎦᎳᏫᏍᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("mešita"),
            keywords: &["islám", "mešita", "muslim", "náboženství"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("mosg"),
            keywords: &["crefydd", "islam", "mosg", "mwslim"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("moské"),
            keywords: &["islam", "moské", "muslim", "religion"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Moschee"),
            keywords: &["Islam", "Moschee", "Moslem", "Muslim", "Religion"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("τέμενος"),
            keywords: &["θρησκεία", "ισλάμ", "μουσουλμανικός", "τέμενος"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("mosque"),
            keywords: &["Muslim", "islam", "mosque", "religion"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["Islam", "Muslim", "mosque", "religion"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["Islam", "Muslim", "mosque", "religion"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("mezquita"),
            keywords: &["islam", "mezquita", "religión"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["edificio", "islam", "mezquita", "musulmán", "religión"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["edificio", "islam", "mezquita", "musulmán", "religión"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("mošee"),
            keywords: &["islam", "moslem", "mošee", "usk"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("meskita"),
            keywords: &["erlijio", "islam", "meskita", "musulman"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("مسجد"),
            keywords: &["اسلام", "دین", "مسجد", "مسلمان"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("moskeija"),
            keywords: &["islam", "moskeija", "muslimi", "rakennus", "uskonto"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("mosque"),
            keywords: &["islam", "mosque", "muslim", "relihiyon", "sambahan"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("moska"),
            keywords: &[
                "bønhús",
                "islamskt",
                "moska",
                "muslimur",
                "religión",
                "trúgv",
                "átrúnaður",
                "átrúni",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("mosquée"),
            keywords: &["islam", "mosquée", "musulman", "religion"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("mosc"),
            keywords: &["creideamh", "ioslam", "mosc", "moslamach"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("mosg"),
            keywords: &["creideamh", "ioslam", "mosg", "muslamach"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("mesquita"),
            keywords: &["edificio", "islamismo", "mesquita", "musulmán", "relixión"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("મસ\u{acd}જિદ"),
            keywords: &[
                "ઇસ\u{acd}લામ",
                "ધર\u{acd}મ",
                "મસ\u{acd}જિદ",
                "મ\u{ac1}સ\u{acd}લિમ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("masallaci"),
            keywords: &["Musulmi", "addini", "islam", "masallaci"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("מסגד"),
            keywords: &["איסלם", "דת", "מוסלמי", "מסגד"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("मस\u{94d}जिद, इस\u{94d}लाम धर\u{94d}म"),
            keywords: &[
                "इस\u{94d}लाम",
                "धर\u{94d}म",
                "मस\u{94d}जिद",
                "मस\u{94d}जिद, इस\u{94d}लाम धर\u{94d}म",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("džamija"),
            keywords: &["džamija", "islam", "religija"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("mecset"),
            keywords: &["iszlám", "mecset", "mohamedán", "muszlim", "vallás"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("մզկիթ"),
            keywords: &["իսլամ", "կրոն", "մզկիթ", "մուսուլման"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("masjid"),
            keywords: &["agama", "islam", "masjid", "muslim"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ụlọ ekpere ndị Alakụba"),
            keywords: &[
                "Ndị Alakụba",
                "okpukperechi",
                "ụka Alakụba",
                "ụlọ ekpere ndị Alakụba",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("moska"),
            keywords: &["moska", "múslimi", "trúarbrögð", "íslam"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("moschea"),
            keywords: &["islamismo", "moschea", "religione"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("モスク"),
            keywords: &["イスラム教", "モスク", "宗教", "建物"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("mesjid"),
            keywords: &["Islam", "Muslim", "agama", "mesjid"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მეჩეთი"),
            keywords: &["ისლამი", "მეჩეთი", "მუსლიმანური", "რელიგია"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("tamezgida n inselmen"),
            keywords: &["tamezgida n inselmen"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("мешіт"),
            keywords: &["дін", "ислам", "мешіт", "мұсылман"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("moské"),
            keywords: &["islam", "moské", "muslim", "religion"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("វ\u{17b7}ហារអ\u{17ca}\u{17b8}ស\u{17d2}លាម"),
            keywords: &[
                "វ\u{17b7}ហារ",
                "វ\u{17b7}ហារអ\u{17ca}\u{17b8}ស\u{17d2}លាម",
                "សាសនា",
                "អ\u{17ca}\u{17b8}ស\u{17d2}លាម",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಮಸೀದ\u{cbf}"),
            keywords: &["ಇಸ\u{ccd}ಲಾಂ", "ಧರ\u{ccd}ಮ", "ಮಸೀದ\u{cbf}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("모스크"),
            keywords: &["모스크", "사원", "이슬람", "종교"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("मश\u{94d}जीद"),
            keywords: &[
                "ईस\u{94d}लाम",
                "धर\u{94d}म",
                "मश\u{94d}जीद",
                "म\u{941}सलमान",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("мечит"),
            keywords: &["дин", "ислам", "мечит", "мусулман"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Moschee"),
            keywords: &["Islam", "Moschee", "Moslem", "Relioun"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ມ\u{eb1}ດສະຍ\u{eb4}ບ"),
            keywords: &[
                "ມ\u{eb1}ດສະຍ\u{eb4}ບ",
                "ມ\u{eb8}ດສະລ\u{eb4}ມ",
                "ສາສະໜາ",
                "ອ\u{eb4}ດສະລາມ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("mečetė"),
            keywords: &["islamas", "mečetė", "musulmonas", "religija"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("mošeja"),
            keywords: &[
                "islams",
                "lūgties",
                "mošeja",
                "musulmaņi",
                "māja",
                "reliģija",
                "ēka",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("mōhiku"),
            keywords: &["ihirama", "momo karakia", "muhurimi", "mōhiku"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("џамија"),
            keywords: &["ислам", "муслиманска", "религија", "џамија"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("മ\u{d41}സ\u{d4d}ലീം പള\u{d4d}ളി"),
            keywords: &[
                "ഇസ\u{d4d}ല\u{d3e}ം പള\u{d4d}ളി",
                "നിസ\u{d4d}\u{200c}ക\u{d4d}ക\u{d3e}രം",
                "മതം",
                "മ\u{d41}സ\u{d4d}ലീം പള\u{d4d}ളി",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("лалын сүм"),
            keywords: &["бурхан", "лалын сүм", "мөргөл", "шашин", "шинто"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("मशीद"),
            keywords: &["इस\u{94d}लाम", "धर\u{94d}म", "मशीद", "म\u{941}स\u{94d}लिम"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("masjid"),
            keywords: &["agama", "islam", "masjid", "orang islam"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("moskea"),
            keywords: &["Islam", "Musulmana", "moskea", "reliġjon"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဗလ\u{102e}ကျောင\u{103a}း"),
            keywords: &[
                "ဗလ\u{102e}ကျောင\u{103a}း",
                "ဘာသာရေး",
                "မ\u{103d}တ\u{103a}စလင\u{103a}",
                "အစ\u{1039}စလမ\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("moské"),
            keywords: &["bygning", "islam", "moské", "muslim", "religion"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("मस\u{94d}जिद"),
            keywords: &[
                "इस\u{94d}लाम",
                "धर\u{94d}म",
                "मस\u{94d}जिद",
                "म\u{941}स\u{94d}लिम",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("moskee"),
            keywords: &["geloof", "islam", "moskee", "moslim"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("moské"),
            keywords: &["bygning", "islam", "moské", "muslim", "religion"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ମସଜ\u{b3f}ଦ\u{b4d}"),
            keywords: &[
                "ଇସଲ\u{b3e}ମ",
                "ଧର\u{b4d}ମ",
                "ମସଜ\u{b3f}ଦ\u{b4d}",
                "ମ\u{b41}ସଲମ\u{b3e}ନ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਮਸੀਤ"),
            keywords: &["ਇਸਲਾਮ", "ਧਰਮ", "ਮਸੀਤ", "ਮ\u{a41}ਸਲਮਾਨ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("مسیت"),
            keywords: &["اسلام", "مذہب", "مسلمان", "مسیت"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Mọsk"),
            keywords: &["Múslim", "Mọsk", "Rilíjọn", "Íslam"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("meczet"),
            keywords: &["islam", "meczet", "muzułmanin", "religia"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("جومات"),
            keywords: &["اسلام", "جومات", "مذهب", "مسلمان"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("mesquita"),
            keywords: &["islã", "mesquita", "muçulmano", "religião"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["islão", "mesquita", "muçulmano", "religião"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("mezquita"),
            keywords: &["Musulman", "islam", "mezquita", "religion"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("moschee"),
            keywords: &["cult", "islam", "moschee", "musulman", "religie"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-765"),
            keywords: &["E10-765"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("мечеть"),
            keywords: &["здание", "ислам", "мечеть", "мусульмане", "религия"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umusigiti"),
            keywords: &["Umusilamu", "idini", "isilamu", "umusigiti"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("مسجد"),
            keywords: &["اسلام", "مذهب", "مسجد", "مسلم"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ම\u{dd4}ස\u{dca}ල\u{dd2}ම\u{dca} පල\u{dca}ල\u{dd2}ය"),
            keywords: &[
                "ආගම",
                "ඉස\u{dca}ල\u{dcf}ම\u{dca}",
                "ම\u{dd4}ස\u{dca}ල\u{dd2}ම\u{dca}",
                "ම\u{dd4}ස\u{dca}ල\u{dd2}ම\u{dca} පල\u{dca}ල\u{dd2}ය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("mešita"),
            keywords: &["budova", "islam", "mešita", "moslim", "náboženstvo"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("mošeja"),
            keywords: &["islam", "mošeja", "muslimansko", "vera"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("masaajid"),
            keywords: &["Islaam", "Muslim", "diin", "masaajid"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("xhami"),
            keywords: &["fe", "islam", "mysliman", "xhami"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("џамија"),
            keywords: &["ислaм", "муслимани", "рeлигиja", "џамија"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("džamija"),
            keywords: &["džamija", "islam", "muslimani", "religija"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("moské"),
            keywords: &["islam", "moské", "muslim", "religion"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("msikiti"),
            keywords: &["dini", "msikiti", "muislamu", "uislamu"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("மசூதி"),
            keywords: &[
                "இஸ\u{bcd}ல\u{bbe}மியம\u{bcd}",
                "இஸ\u{bcd}ல\u{bbe}ம\u{bcd}",
                "மசூதி",
                "மதம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("మస\u{c40}దు"),
            keywords: &[
                "ఇస\u{c4d}ల\u{c3e}ం",
                "మతం",
                "మస\u{c40}దు",
                "ముస\u{c4d}ల\u{c3f}ం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("масҷид"),
            keywords: &["Ислом", "дин", "масҷид", "мусулмон"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ม\u{e31}สย\u{e34}ด"),
            keywords: &[
                "ม\u{e31}สย\u{e34}ด",
                "ม\u{e38}สล\u{e34}ม",
                "ศาสนา",
                "อ\u{e34}สลาม",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("metjit"),
            keywords: &["din", "metjit", "musulman", "yslam"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("falelotu fakaʻisilami"),
            keywords: &["falelotu fakaʻisilami"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("cami"),
            keywords: &["Müslüman", "cami", "din", "İslam"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("مەسچىت"),
            keywords: &["ئىسلام", "دىن", "مۇسۇلمان", "مەسچىت"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("мечеть"),
            keywords: &["мечеть", "мусульманський", "релігія", "іслам"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("مسجد"),
            keywords: &["عبادت", "عمارت", "مسجد", "مسلمان"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("masjid"),
            keywords: &["din", "islom", "masjid", "muslim"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("nhà thờ hồi giáo"),
            keywords: &["hồi giáo", "nhà thờ hồi giáo", "thuộc hồi giáo", "tôn giáo"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("Jàkka"),
            keywords: &["Jullit", "Jàkka", "diine", "islam"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("i-mosque"),
            keywords: &["i-Muslim", "i-islam", "i-mosque", "unqulo"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Mọ\u{301}ṣáláṣí"),
            keywords: &["Mùsùlùmí", "Mọ\u{301}ṣáláṣí", "Ìmàle", "ẹ\u{300}sìn"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("清真寺"),
            keywords: &["伊斯蘭教徒", "宗教", "清真寺", "穆斯林"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("清真寺"),
            keywords: &["伊斯兰教徒", "宗教", "清真寺", "穆斯林"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("清真寺"),
            keywords: &["伊斯兰", "宗教", "清真寺", "穆斯林"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("清真寺"),
            keywords: &["伊斯蘭建築", "清真寺"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["清真寺", "穆斯林"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("isonto lamasulumane"),
            keywords: &["amasulumane", "inkolo", "isonto lamasulumane"],
        },
    ],
};
#[doc = "🛕"]
pub const HINDU_TEMPLE: crate::Emoji = crate::Emoji {
    glyph: "🛕",
    codepoint: "1F6D5",
    status: crate::Status::FullyQualified,
    introduction_version: 12f32,
    name: "hindu temple",
    group: "Travel & Places",
    subgroup: "place-religious",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("Hindoetempel"),
            keywords: &["Hindoetempel", "hindoe", "tempel"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የሂንዱ ምኩራብ"),
            keywords: &["ሂንዱ", "ምኩራብ", "የሂንዱ ምኩራብ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("معبد هندوسي"),
            keywords: &["معبد", "هندوسي", "هندوسية"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("হিন\u{9cd}দ\u{9c1} মন\u{9cd}দিৰ"),
            keywords: &["মন\u{9cd}দিৰ", "হিন\u{9cd}দ\u{9c1}"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("hindu məbədi"),
            keywords: &["hindu", "məbədi"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("індуісцкі храм"),
            keywords: &["храм", "індуісцкі"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("индуистки храм"),
            keywords: &["индуизъм", "индуистки храм", "храм"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("হিন\u{9cd}দ\u{9c1} মন\u{9cd}দির"),
            keywords: &["মন\u{9cd}দির", "হিন\u{9cd}দ\u{9c1}"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("templ hindou"),
            keywords: &["hindou", "templ"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("hinduistički hram"),
            keywords: &["hinduistički hram", "hinduizam", "hram"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("temple hindú"),
            keywords: &["hinduisme", "hindú", "temple"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎯᏂᏚ ᏧᏂᎳᏫᏍᏗ"),
            keywords: &["ᎯᏂᏚ", "ᏧᏂᎳᏫᏍᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("hinduistický chrám"),
            keywords: &["chrám", "hinduismus", "hinduistický chrám", "svatyně"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("teml hindwaidd"),
            keywords: &["hindw", "teml", "teml hindwaidd"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("hindutempel"),
            keywords: &["hindu", "hindutempel", "tempel"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Hindutempel"),
            keywords: &["Hindu", "Hindutempel", "Tempel"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ινδουιστικός ναός"),
            keywords: &["ινδουιστής", "ινδουιστικός ναός", "ναός"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("hindu temple"),
            keywords: &["hindu", "temple"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("Hindu temple"),
            keywords: &["Hindu", "temple"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("templo hindú"),
            keywords: &["hindú", "templo"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("hinduistlik tempel"),
            keywords: &["hindu", "hinduism", "hinduistlik tempel", "tempel"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("tenplu hindua"),
            keywords: &["hindu", "tenplu", "tenplu hindua"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("معبد هندو"),
            keywords: &["معبد", "هندو"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("hindutemppeli"),
            keywords: &["hindu", "hindutemppeli", "temppeli"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("hindu temple"),
            keywords: &["hindu", "hindu temple", "sambahan", "templo"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("hinduitempul"),
            keywords: &["hindui", "hinduitempul", "tempul"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("temple hindou"),
            keywords: &["hindou", "religion", "stūpa", "temple"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["hindou", "temple"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("teampall hiondúch"),
            keywords: &["hiondúch", "teampall"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("teampall Hionduthach"),
            keywords: &["Hionduthach", "teampall"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("templo hindú"),
            keywords: &["hinduísmo", "hindú", "relixión", "templo"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("હિન\u{acd}દ\u{ac1} મ\u{a82}દિર"),
            keywords: &["મ\u{a82}દિર", "હિન\u{acd}દ\u{ac1}"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("מקדש הינדי"),
            keywords: &["דת", "הודו", "הינדואיזם", "מקדש", "מקדש הינדי"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("हि\u{902}द\u{942} म\u{902}दिर"),
            keywords: &["म\u{902}दिर", "हि\u{902}द\u{942}"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("hinduski hram"),
            keywords: &["hinduski", "hram"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("hindu templom"),
            keywords: &["hindu", "templom"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("հինդուիստական տաճար"),
            keywords: &["հինդուիստական տաճար", "հինուիզմ", "տաճար"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("pura"),
            keywords: &["hindu", "pura"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("hindúahof"),
            keywords: &["hindú", "hindúahof", "hof"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("tempio indù"),
            keywords: &["induismo", "tempio induista", "tempio indù"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ヒンドゥー教の寺院"),
            keywords: &["ヒンズー教", "ヒンドゥー教の寺院", "宗教", "寺", "建物"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("pura Hindu"),
            keywords: &["Hindu", "pura"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ინდუისტური ტაძარი"),
            keywords: &["ინდუისტური", "ტაძარი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("үнді ғибадатханасы"),
            keywords: &["ғибадатхана", "үнді", "үнді ғибадатханасы"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("វ\u{17b7}ហារសាសនាហ\u{17b7}ណ\u{17d2}ឌ\u{17bc}"),
            keywords: &[
                "វ\u{17b7}ហារ",
                "វ\u{17b7}ហារសាសនាហ\u{17b7}ណ\u{17d2}ឌ\u{17bc}",
                "ហ\u{17b7}ណ\u{17d2}ឌ\u{17bc}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಹ\u{cbf}ಂದ\u{cc2} ದೇವಾಲಯ"),
            keywords: &["ದೇವಾಲಯ", "ಹ\u{cbf}ಂದ\u{cc2}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("힌두교 사원"),
            keywords: &["사원", "힌두교"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("हि\u{902}द\u{941} द\u{947}व\u{941}ळ"),
            keywords: &["द\u{947}व\u{941}ळ", "हि\u{902}द\u{941}"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("индус храмы"),
            keywords: &["индус", "храмы"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ວ\u{eb1}ດ\u{200b}ຮ\u{eb4}ນ\u{200b}ດ\u{eb9}"),
            keywords: &[
                "ວ\u{eb1}ດ",
                "ວ\u{eb1}ດ\u{200b}ຮ\u{eb4}ນ\u{200b}ດ\u{eb9}",
                "ຮ\u{eb4}ນ\u{200b}ດ\u{eb9}",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("induistų šventykla"),
            keywords: &["induistai", "induistų šventykla", "šventykla"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("hinduistu templis"),
            keywords: &["hinduistu", "templis"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("хиндуски храм"),
            keywords: &["хиндуски", "храм"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഹിന\u{d4d}ദ\u{d41} ക\u{d4d}ഷേത\u{d4d}രം"),
            keywords: &["ക\u{d4d}ഷേത\u{d4d}രം", "ഹിന\u{d4d}ദ\u{d41}"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("хиндү сүм"),
            keywords: &["сүм", "хиндү"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("हि\u{902}द\u{942} म\u{902}दीर"),
            keywords: &["म\u{902}दीर", "हि\u{902}द\u{942}"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("kuil hindu"),
            keywords: &["hindu", "kuil"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဟ\u{102d}န\u{1039}ဒ\u{1030} ဘ\u{102f}ရားကျောင\u{103a}း"),
            keywords: &["ဘ\u{102f}ရားကျောင\u{103a}း", "ဟ\u{102d}န\u{1039}ဒ\u{1030}"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("hindutempel"),
            keywords: &["hindu", "hindutempel", "tempel"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("हिन\u{94d}द\u{941}को मन\u{94d}दिर"),
            keywords: &[
                "मन\u{94d}दिर",
                "हिन\u{94d}द\u{941}को मन\u{94d}दिर",
                "हिन\u{94d}द\u{942}",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("hindoetempel"),
            keywords: &["hindoe", "hindoetempel", "tempel"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("hindutempel"),
            keywords: &["hindu", "hindutempel", "tempel"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ହ\u{b3f}ନ\u{b4d}ଦ\u{b41} ମନ\u{b4d}ଦ\u{b3f}ର"),
            keywords: &["ମନ\u{b4d}ଦ\u{b3f}ର", "ହ\u{b3f}ନ\u{b4d}ଦ\u{b41}"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਹਿ\u{a70}ਦ\u{a42} ਮ\u{a70}ਦਿਰ"),
            keywords: &["ਮ\u{a70}ਦਿਰ", "ਹਿ\u{a70}ਦ\u{a42}"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Híndú Tẹ\u{301}mpul"),
            keywords: &["Híndu", "Híndú Tẹ\u{301}mpul", "Tẹ\u{301}mpul"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("świątynia hinduistyczna"),
            keywords: &["hinduizm", "świątynia", "świątynia hinduistyczna"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د هندوانو معبد"),
            keywords: &["د هندوانو معبد", "معبد", "هندو"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("templo hindu"),
            keywords: &["hindu", "templo"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("templu hindus"),
            keywords: &["hindus", "templu"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E12–008"),
            keywords: &["E12–008"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("индуистский храм"),
            keywords: &[
                "ашрам",
                "индийский",
                "индуизм",
                "индуистский храм",
                "храм",
                "церковь",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("هندو مندر"),
            keywords: &["مندر", "هندو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("හ\u{dd2}න\u{dca}ද\u{dd4} කෝව\u{dd2}ල"),
            keywords: &["කෝව\u{dd2}ල", "හ\u{dd2}න\u{dca}ද\u{dd4}"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("hinduistický chrám"),
            keywords: &[
                "chrám",
                "hinduista",
                "hinduistický chrám",
                "hinduizmus",
                "svätyňa",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("hindujski tempelj"),
            keywords: &["hindu", "hindujski tempelj", "tempelj"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("macbadka hindida"),
            keywords: &["hindi", "macbadka", "macbadka hindida"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("tempull indian"),
            keywords: &["hindu", "indian", "tempull"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("хинду храм"),
            keywords: &["хинду", "храм"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("hindu hram"),
            keywords: &["hindu", "hram"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("hindutempel"),
            keywords: &["hindu", "hindutempel", "tempel"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("hekalu la kihindi"),
            keywords: &["hekalu", "hekalu la kihindi", "mhindu"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("இந\u{bcd}து கோவில\u{bcd}"),
            keywords: &["இந\u{bcd}து", "கோவில\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("హ\u{c3f}ందూ ద\u{c47}వ\u{c3e}లయం"),
            keywords: &["ద\u{c47}వ\u{c3e}లయం", "హ\u{c3f}ందూ"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ว\u{e31}ดฮ\u{e34}นด\u{e39}"),
            keywords: &[
                "ว\u{e31}ด",
                "ว\u{e31}ดฮ\u{e34}นด\u{e39}",
                "ฮ\u{e34}นด\u{e39}",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("indus ybadathanasy"),
            keywords: &["indus", "indus ybadathanasy", "ybadathana"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("falelotu fakahinitū"),
            keywords: &["falelotu fakahinitū"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("Hindu tapınağı"),
            keywords: &["Hindu tapınağı", "hindu", "tapınak"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("індуїстський храм"),
            keywords: &["храм", "індуїстський"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ہندو مندر"),
            keywords: &["مندر", "ہندو"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("hindu ibodatxonasi"),
            keywords: &["hindu", "hindu ibodatxonasi", "ibodatxona", "sigʻinish"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("đền hindu"),
            keywords: &["hin đu", "hin-đu", "hindu", "đền"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("印度寺"),
            keywords: &["印度寺", "寺廟"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("印度寺"),
            keywords: &["印度寺", "寺庙"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("印度寺庙"),
            keywords: &["佛寺", "佛教", "印度寺庙", "寺庙", "寺院", "庙宇"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("印度廟"),
            keywords: &["印度", "印度廟", "廟"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ithempeli le-hindu"),
            keywords: &["i-hindu", "ithempeli", "ithempeli le-hindu"],
        },
    ],
};
#[doc = "🕍"]
pub const SYNAGOGUE: crate::Emoji = crate::Emoji {
    glyph: "🕍",
    codepoint: "1F54D",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "synagogue",
    group: "Travel & Places",
    subgroup: "place-religious",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("sinagoge"),
            keywords: &["godsdiens", "joods", "sinagoge", "tempel"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ቤተ መቅደስ"),
            keywords: &["ቤተ መቅደስ", "ኃይማኖት", "አይሁዳዊ", "አይሁድ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("معبد يهودي"),
            keywords: &["دين", "معبد", "معبد يهودي", "يهود", "يهودية"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("আৰ\u{9be}ধন\u{9be}লয\u{9bc}"),
            keywords: &[
                "আৰ\u{9be}ধন\u{9be}লয\u{9bc}",
                "ইহ\u{9c1}দি",
                "ধৰ\u{9cd}ম",
                "মন\u{9cd}দিৰ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("sinaqoq"),
            keywords: &["din", "məbəd", "sinaqoq", "yəhudi"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("сінагога"),
            keywords: &["рэлігія", "сінагога", "храм", "яўрэй", "іудаізм"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("синагога"),
            keywords: &["евреин", "религия", "синагога", "храм", "юдаизъм"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ইহ\u{9c1}দিদের ধর\u{9cd}মস\u{9cd}থ\u{9be}ন"),
            keywords: &[
                "ইহ\u{9c1}দি",
                "ইহ\u{9c1}দিদের ধর\u{9cd}মস\u{9cd}থ\u{9be}ন",
                "ধর\u{9cd}ম",
                "মন\u{9cd}দির",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("sinagogenn"),
            keywords: &["relijion", "sinagogenn", "templ", "yuzev"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("sinagoga"),
            keywords: &["hram", "religija", "sinagoga", "židov"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("sinagoga"),
            keywords: &["jueu", "religió", "sinagoga", "temple"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏂᏧᏏ ᏧᏂᎳᏫᏍᏗ"),
            keywords: &["ᎠᏂᏧᏏ", "ᎤᏃᎯᏳᏒ", "ᏧᎾᏁᏟᏗ", "ᏧᏂᎳᏫᏍᏗ", "ᏧᏫ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("synagoga"),
            keywords: &["chrám", "náboženství", "synagoga", "žid", "židovský"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("synagog"),
            keywords: &["crefydd", "iddew", "iddewig", "synagog", "teml"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("synagoge"),
            keywords: &["jøde", "jødisk", "religion", "synagoge", "tempel"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Synagoge"),
            keywords: &["Jude", "Religion", "Synagoge", "Tempel", "jüdisch"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("συναγωγή"),
            keywords: &["εβραίος", "εβραϊκός", "θρησκεία", "ναός", "συναγωγή"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("synagogue"),
            keywords: &["Jew", "Jewish", "religion", "synagogue", "temple"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["Jew", "Jewish", "religion", "shul", "synagogue", "temple"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("sinagoga"),
            keywords: &["judaísmo", "religión", "sinagoga"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["edificio", "judaísmo", "religión", "sinagoga", "templo"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["edificio", "judaísmo", "religión", "sinagoga", "templo"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("sünagoog"),
            keywords: &["judaism", "juut", "sünagoog", "usk"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("sinagoga"),
            keywords: &["erlijio", "judu", "judutar", "sinagoga", "tenplu"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("کنیسه"),
            keywords: &["دین", "مذهب", "معبد", "کنیسه", "یهود", "یهودی"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("synagoga"),
            keywords: &[
                "juutalaisuus",
                "rakennus",
                "synagoga",
                "temppeli",
                "uskonto",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("sinagoga"),
            keywords: &[
                "Hudyo",
                "Judaismo",
                "relihiyon",
                "sambahan",
                "sinagoga",
                "templo",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("synagoga"),
            keywords: &[
                "gýðingur",
                "jødi",
                "jødiskur",
                "religión",
                "samkomuhús",
                "synagoga",
                "trúgv",
                "átrúnaður",
                "átrúni",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("synagogue"),
            keywords: &["juif", "juive", "religion", "synagogue", "temple"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("sionagóg"),
            keywords: &["creideamh", "giúdach", "sionagóg", "teampall"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("sionagog"),
            keywords: &["creideamh", "iùdhach", "sionagog", "teampall"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("sinagoga"),
            keywords: &["edificio", "relixión", "sinagoga", "xudaísmo", "xudeu"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("યહ\u{ac2}દી પ\u{acd}રાર\u{acd}થનાગ\u{ac3}હ"),
            keywords: &[
                "ધર\u{acd}મ",
                "મ\u{a82}દિર",
                "યહ\u{ac2}દી પ\u{acd}રાર\u{acd}થનાગ\u{ac3}હ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("wurin ibada na yahudawa"),
            keywords: &[
                "Na yahudu",
                "Yahudu",
                "addini",
                "wurin ibada",
                "wurin ibada na yahudawa",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("בית כנסת"),
            keywords: &["בית כנסת", "דת", "יהדות", "יהודי"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("यह\u{942}दी प\u{94d}रार\u{94d}थनाग\u{943}ह"),
            keywords: &["म\u{902}दिर", "यह\u{942}दी प\u{94d}रार\u{94d}थनाग\u{943}ह"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("sinagoga"),
            keywords: &["hram", "judaizam", "religija", "sinagoga", "židovstvo"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("zsinagóga"),
            keywords: &["szentély", "templom", "vallás", "zsidó", "zsinagóga"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("սինագոգ"),
            keywords: &["կրոն", "հրեա", "հրեական", "սինագոգ", "տաճար"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("sinagog"),
            keywords: &["agama", "kuil", "sinagog", "yahudi"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ụlọ ekpere"),
            keywords: &["Ju", "Ndị Ju", "okpukperechi", "ụlọ ekpere"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("sýnagóga"),
            keywords: &[
                "gyðingatrú",
                "gyðingur",
                "samkunduhús",
                "sýnagóga",
                "trúarbrögð",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("sinagoga"),
            keywords: &["ebraismo", "religione", "sinagoga", "tempio ebraico"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("シナゴーグ"),
            keywords: &["シナゴーグ", "ユダヤ教", "宗教", "建物"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("sinagoga"),
            keywords: &["Yahudi", "agama", "kuil", "sinagoga", "wong Yahudi"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("სინაგოგა"),
            keywords: &["ებრაელი", "ებრაული", "რელიგია", "სინაგოგა", "ტაძარი"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("tamezgida n udayen"),
            keywords: &["tamezgida n udayen"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("синагога"),
            keywords: &["дін", "иврит", "синагога", "храм"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("synagoge"),
            keywords: &["jøde", "jødisk", "religion", "synagoge", "tempel"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("វ\u{17b7}ហារជនជាត\u{17b7}ជ\u{17d2}វ\u{17b8}ស"),
            keywords: &[
                "វ\u{17b7}ហារ",
                "វ\u{17b7}ហារជនជាត\u{17b7}ជ\u{17d2}វ\u{17b8}ស",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಸ\u{cbf}ನಗಾಗ\u{ccd}"),
            keywords: &[
                "ಜುವ\u{cbf}ಶ\u{ccd}",
                "ಜ\u{ccd}ಯ\u{cc2}",
                "ಧರ\u{ccd}ಮ",
                "ಮಂದ\u{cbf}ರ",
                "ಸ\u{cbf}ನಗಾಗ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("시나고그"),
            keywords: &["사원", "시나고그", "유대교", "종교"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("सिन\u{947}गोग"),
            keywords: &[
                "ज\u{94d}य\u{941} लोक",
                "ज\u{94d}य\u{942}",
                "द\u{947}व\u{941}ळ",
                "धर\u{94d}म",
                "सिन\u{947}गोग",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("синагога"),
            keywords: &["дин", "жөөт", "синагога", "храм"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Synagog"),
            keywords: &["Judd", "Relioun", "Synagog", "Tempel", "jiddesch"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໂບດຊາວຢ\u{eb4}ວ"),
            keywords: &["ຢ\u{eb4}ວ", "ສາສະໜາ", "ໂບດ", "ໂບດຊາວຢ\u{eb4}ວ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("sinagoga"),
            keywords: &["religija", "sinagoga", "šventykla", "žydas", "žydų"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("sinagoga"),
            keywords: &[
                "ebreji",
                "lūgties",
                "māja",
                "reliģija",
                "sinagoga",
                "templis",
                "ēka",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("whare karakia hūrae"),
            keywords: &["hūrae", "momo karakia", "temepara", "whare karakia hūrae"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("синагога"),
            keywords: &["евреин", "религија", "синагога", "храм", "јудаизам"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ജ\u{d42}തദേവ\u{d3e}ലയം"),
            keywords: &[
                "ജ\u{d42}തദേവ\u{d3e}ലയം",
                "ജ\u{d42}തപള\u{d4d}ളി",
                "ജ\u{d42}തമതം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("жүүдийн сүм"),
            keywords: &["жүүдийн сүм", "шашин"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("ज\u{94d}य\u{942} लोका\u{902}च\u{947} उपासनास\u{94d}थान"),
            keywords: &[
                "ज\u{94d}य\u{942}",
                "ज\u{94d}य\u{942} लोका\u{902}च\u{947} उपासनास\u{94d}थान",
                "ज\u{94d}य\u{942}इश",
                "द\u{947}ऊळ",
                "धर\u{94d}म",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("saumaah"),
            keywords: &["agama", "kuil", "orang yahudi", "saumaah", "yahudi"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("sinagoga"),
            keywords: &["Lhudi", "reliġjon", "sinagoga", "tempju"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဂျ\u{1030}းဘ\u{102f}ရားရ\u{103e}\u{102d}ခ\u{102d}\u{102f}းကျောင\u{103a}း"),
            keywords: &[
                "ဂျ\u{1030}း",
                "ဂျ\u{1030}း ဘ\u{102f}ရားရ\u{103e}\u{102d}ခ\u{102d}\u{102f}းကျောင\u{103a}း",
                "ဂျ\u{1030}းဘ\u{102f}ရားရ\u{103e}\u{102d}ခ\u{102d}\u{102f}းကျောင\u{103a}း",
                "ဂျ\u{1030}းလ\u{1030}မျ\u{102d}\u{102f}း",
                "ဘာသာရေး",
                "ဘ\u{102f}ရားကျောင\u{103a}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("synagoge"),
            keywords: &[
                "bygning", "jøde", "jødisk", "religion", "synagoge", "tempel",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("आराधनालय"),
            keywords: &[
                "आराधनालय",
                "धर\u{94d}म",
                "प\u{941}जनिय स\u{94d}थल",
                "मन\u{94d}दिर",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("synagoge"),
            keywords: &["geloof", "jood", "joods", "synagoge", "tempel"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("synagoge"),
            keywords: &[
                "bygning", "jøde", "jødisk", "religion", "synagoge", "tempel",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ସ\u{b3f}ନ\u{b3e}ଗଗ\u{b4d}"),
            keywords: &[
                "ଇହ\u{b41}ଦୀ ଧର\u{b4d}ମ ସମ\u{b4d}ବନ\u{b4d}ଧୀୟ",
                "ଜ\u{b4d}ୟ\u{b41}",
                "ଧର\u{b4d}ମ",
                "ମନ\u{b4d}ଦ\u{b3f}ର",
                "ସ\u{b3f}ନ\u{b3e}ଗଗ\u{b4d}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਪ\u{a4d}ਰਾਰਥਨਾ ਸਥਾਨ"),
            keywords: &[
                "ਪ\u{a4d}ਰਾਰਥਨਾ ਸਥਾਨ",
                "ਮ\u{a70}ਦਿਰ",
                "ਯਹ\u{a42}ਦੀ",
                "ਯਹ\u{a42}ਦੀ ਪ\u{a4d}ਰਰਾਥਨਾ ਘਰ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("یہودیاں-دی-عبادت-گاہ"),
            keywords: &["مذہب", "مندر", "یہودی", "یہودیاں-دی-عبادت-گاہ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Judiá Pípol Dẹm Preya Haus"),
            keywords: &[
                "Gọd-Haus",
                "Ju",
                "Judiá Pípol Dẹm Preya Haus",
                "Jú Pípul Dẹm Preya Haus",
                "Rilíjọn",
                "Sínágọg",
                "Sọ\u{301}mtin Wé Kọnẹ\u{301}kt Wit Jú Pípul",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("synagoga"),
            keywords: &["religia", "synagoga", "świątynia", "żyd", "żydowski"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د يهودانو جومات"),
            keywords: &["د يهودانو جومات", "مذهب", "يهود", "يهودي", "ګرجا"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("sinagoga"),
            keywords: &["judaísmo", "judeu", "religião", "sinagoga", "templo"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("sinagoga"),
            keywords: &["sinagoga"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("sinagogă"),
            keywords: &["cult", "evreiesc", "religie", "sinagogă", "templu"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-766"),
            keywords: &["E10-766"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("синагога"),
            keywords: &["евреи", "здание", "иудаизм", "религия", "синагога"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("isinagogi"),
            keywords: &[
                "Ufitanye isano n’Abayahudi",
                "Umuyahudi",
                "idini",
                "isinagogi",
                "urusengero",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("سناگاگ"),
            keywords: &["سناگاگ", "مذهب", "مندر", "يهودي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ස\u{dd2}නගෝගය"),
            keywords: &[
                "ආගම",
                "දේවස\u{dca}ථ\u{dcf}නය",
                "ය\u{dd4}දෙව\u{dca}",
                "ය\u{dd4}දෙව\u{dca}වන\u{dca}",
                "ස\u{dd2}නගෝගය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("synagóga"),
            keywords: &["budova", "chrám", "náboženstvo", "synagóga", "žid"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("sinagoga"),
            keywords: &["jud", "judovsko", "sinagoga", "tempelj", "vera"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("kaniisad Yuhuud"),
            keywords: &["Macbadka", "Yuhuud", "Yuhuudi", "diin", "kaniisad Yuhuud"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("sinagogë"),
            keywords: &["fe", "hebraik", "hebre", "sinagogë", "tempull"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("синагога"),
            keywords: &["jудaизaм", "рeлигиja", "синагога", "хрaм", "јевреји"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("sinagoga"),
            keywords: &["hram", "jevreji", "judaizam", "religija", "sinagoga"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("synagoga"),
            keywords: &["judisk", "religion", "synagoga", "tempel"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("hekalu la kiyahudi"),
            keywords: &["dini", "hekalu", "hekalu la kiyahudi", "myahudi", "uyahudi"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ஜெப ஆலயம\u{bcd}"),
            keywords: &[
                "ஜெப ஆலயம\u{bcd}",
                "மதம\u{bcd}",
                "யூத மதம\u{bcd}",
                "யூதர\u{bcd}கள\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("యూదుల మంద\u{c3f}రం"),
            keywords: &["మంద\u{c3f}రం", "యూదుల మంద\u{c3f}రం", "యూదులు"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("каниса"),
            keywords: &["дин", "каниса", "маъбад", "яҳуд", "яҳудӣ"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("โบสถ\u{e4c}ย\u{e34}ว"),
            keywords: &[
                "ย\u{e34}ว",
                "ย\u{e39}ดาย",
                "ศาสนา",
                "โบสถ\u{e4c}",
                "โบสถ\u{e4c}ย\u{e34}ว",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("sinagog"),
            keywords: &["din", "sinagog", "ybadathana", "ýewreý", "ýewreý dini"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("falelotu fakasiu"),
            keywords: &["falelotu fakasiu"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("sinagog"),
            keywords: &["Yahudi", "din", "sinagog", "tapınak"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("سىناگوگ"),
            keywords: &["ئىبادەتخانا", "ئىسرائىل", "دىن", "سىناگوگ", "يەھۇدى"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("синагога"),
            keywords: &["релігія", "синагога", "храм", "єврей", "єврейський"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("یہودیوں کی عبادت گاہ"),
            keywords: &["عبادت گاہ", "یہودی", "یہودیوں کی عبادت گاہ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("sinagog"),
            keywords: &["din", "ibodatxona", "ibroniy", "sinagog", "yahudiy"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("giáo đường Do thái"),
            keywords: &[
                "chùa",
                "do thái",
                "giáo đường Do thái",
                "người do thái",
                "tôn giáo",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("sinaagog"),
            keywords: &["Juif", "diine", "sinaagog", "tàmpal"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("isinagoga"),
            keywords: &["UmJuda", "isinagoga", "itempile", "obuJuda", "unqulo"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Sínágọ\u{301}gù"),
            keywords: &[
                "Eẹlẹ\u{301}sìn júù",
                "Sínágọ\u{301}gù",
                "júù",
                "tẹ\u{301}pílì",
                "ẹ\u{300}sìn",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("猶太教堂"),
            keywords: &["宗教", "寺廟", "猶太教", "猶太教堂", "猶太教徒"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("犹太教堂"),
            keywords: &["宗教", "寺庙", "犹太教", "犹太教堂", "犹太教徒"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("犹太教堂"),
            keywords: &["会堂", "宗教", "犹太", "犹太教堂"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("猶太教堂"),
            keywords: &["教堂", "猶太教堂"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("猶太教會"),
            keywords: &["猶太", "猶太教會"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("isinagoge"),
            keywords: &["inkolo", "isinagoge", "ithempeli", "umjuda"],
        },
    ],
};
#[doc = "⛩\u{fe0f}"]
pub const SHINTO_SHRINE: crate::Emoji = crate::Emoji {
    glyph: "⛩\u{fe0f}",
    codepoint: "26E9 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.7f32,
    name: "shinto shrine",
    group: "Travel & Places",
    subgroup: "place-religious",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "⛩",
        codepoint: "26E9",
        status: crate::Status::Unqualified,
        introduction_version: 0.7f32,
        name: "shinto shrine",
        group: "Travel & Places",
        subgroup: "place-religious",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("sjinto-altaar"),
            keywords: &["altaar", "godsdiens", "sjinto", "sjinto-altaar", "tempel"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የሺንቶ መካነ መቃብር"),
            keywords: &["ሺንቶ", "ኃይማኖት", "የሺንቶ መካነ መቃብር", "የተቀደሰ መካነ መቃብር"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("ضريح"),
            keywords: &["دين", "شنتو", "ضريح"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("চিণ\u{9cd}টো মন\u{9cd}দিৰ"),
            keywords: &["চিণ\u{9cd}টো", "ধৰ\u{9cd}ম", "মন\u{9cd}দিৰ"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("sinto məbədi"),
            keywords: &["din", "məbəd", "sinto", "sinto məbədi"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("сінтаісцкі храм"),
            keywords: &["рэлігія", "сінтаізм", "сінтаісцкі храм", "храм"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("шинтоистки храм"),
            keywords: &["религия", "храм", "шинто", "шинтоистки храм"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("শিন\u{9cd}তো মন\u{9cd}দির"),
            keywords: &[
                "ধর\u{9cd}ম",
                "মঠ",
                "শিন\u{9cd}টো",
                "শিন\u{9cd}তো মন\u{9cd}দির",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("santual shinto"),
            keywords: &["relijion", "santual", "shinto"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("shinto oltar"),
            keywords: &["oltar", "religija", "shinto"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("santuari xintoista"),
            keywords: &["religió", "santuari", "temple", "xintoista"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏏᏂᏙᎯ ᎠᏤᎵᏍᏛᎢ"),
            keywords: &["ᎠᏤᎵᏍᏛᎢ", "ᎤᏃᎯᏳᏒ", "ᏏᏂᏙᎯ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("šintoistická svatyně"),
            keywords: &[
                "náboženství",
                "svatyně",
                "šintoismus",
                "šintoistická svatyně",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("cysegrfa shinto"),
            keywords: &["crefydd", "cysegrfa", "shinto"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("Shinto-helligdom"),
            keywords: &["Shinto-helligdom", "alter", "religion", "shinto"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Shinto-Schrein"),
            keywords: &["Religion", "Schrein", "Shinto", "Shinto-Schrein"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("σιντοϊστικός ναός"),
            keywords: &["θρησκεία", "ναός", "σιντοϊστικός"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("shinto shrine"),
            keywords: &["religion", "shinto", "shrine"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("Shinto shrine"),
            keywords: &["Shinto", "religion", "shrine"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("Shinto shrine"),
            keywords: &["Shinto", "religion", "shrine"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("santuario sintoísta"),
            keywords: &[
                "japón",
                "religión",
                "santuario",
                "santuario sintoísta",
                "sintoísmo",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &[
                "Japón",
                "edificio",
                "jinja",
                "religión",
                "santuario",
                "santuario sintoísta",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("shinto tempel"),
            keywords: &["shinto", "tempel", "usk"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("shinto santutegia"),
            keywords: &["erlijio", "santutegi", "shinto", "shinto santutegia"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("معبد شینتو"),
            keywords: &["شینتو", "مذهب", "معبد"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("shinto-temppeli"),
            keywords: &["rakennus", "shinto-temppeli", "shintolaisuus", "uskonto"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("shinto shrine"),
            keywords: &["japanese", "relihiyon", "shinto", "shrine", "templo"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("shinto altar"),
            keywords: &[
                "halgidómur",
                "halgimannagrøv",
                "halgiskrín",
                "japan",
                "religión",
                "shinto altar",
                "trúgv",
                "átrúnaður",
                "átrúni",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("sanctuaire shinto"),
            keywords: &["sanctuaire shinto", "shinto"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["religion", "sanctuaire", "shinto"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("scrín Sinteochais"),
            keywords: &[
                "creideamh",
                "scrín",
                "scrín Sinteochais",
                "scrín sinteocha",
                "sinteochas",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("naomh-chiste shinto"),
            keywords: &["creideamh", "naomh-chiste", "shinto"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("santuario xintoísta"),
            keywords: &["Xapón", "relixión", "santuario xintoísta", "xintoísmo"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("શિ\u{a82}ટો શ\u{acd}રાઇન"),
            keywords: &[
                "જાપાની ધર\u{acd}મસ\u{acd}થળ",
                "ધર\u{acd}મ",
                "શિ\u{a82}ટો શ\u{acd}રાઇન",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("wurin addu’a na shinto"),
            keywords: &["addini", "shinto", "wurin addu’a", "wurin addu’a na shinto"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("מקדש שינטו"),
            keywords: &["דת", "יפן", "מקדש", "שינטו"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("शि\u{902}टो श\u{94d}राइन, जापानी धर\u{94d}म स\u{94d}थल"),
            keywords: &[
                "जापानी धर\u{94d}म स\u{94d}थल",
                "शि\u{902}टो श\u{94d}राइन",
                "शि\u{902}टो श\u{94d}राइन, जापानी धर\u{94d}म स\u{94d}थल",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("šintoistički hram"),
            keywords: &[
                "hram",
                "religija",
                "svetište",
                "šintoistički hram",
                "šintoizam",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("sintó szentély"),
            keywords: &["sintó", "szentély", "vallás"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("սինտոյական տաճար"),
            keywords: &["կրոն", "սինտոյական", "տաճար"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("kuil Shinto"),
            keywords: &["agama", "kuil", "kuil Shinto", "shinto"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ụlọ ekpere shinto"),
            keywords: &["okpukperechi", "shinto", "ụlọ ekpere", "ụlọ ekpere shinto"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("sjintó-hof"),
            keywords: &["hof", "sjintó", "sjintó-hof", "trúarbrögð"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("santuario shintoista"),
            keywords: &["jinja", "religione", "santuario shintoista"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("鳥居"),
            keywords: &["宗教", "建物", "神社", "神道", "鳥居"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("kuil Shinto"),
            keywords: &["Shinto", "agama", "kuil"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("შინტოს ტაძარი"),
            keywords: &["რელიგია", "ტაძარი", "შინტო", "შინტოს ტაძარი"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("lemqam shrine"),
            keywords: &["lemqam shrine"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("синтоистік храм"),
            keywords: &["дін", "синтоистік", "храм"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("shinto-alter"),
            keywords: &["alter", "religion", "shinto", "shinto-alter"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("វ\u{17b7}ហារស\u{17ca}\u{17b8}នត\u{17bb} (ជប\u{17c9}\u{17bb}ន)"),
            keywords: &[
                "វ\u{17b7}ហារ",
                "វ\u{17b7}ហារស\u{17ca}\u{17b8}នត\u{17bb} (ជប\u{17c9}\u{17bb}ន)",
                "សាសនា",
                "ស\u{17ca}\u{17b8}នត\u{17bc}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಶ\u{cbf}ಂಟೊ ದೇವಾಲಯ"),
            keywords: &["ಧರ\u{ccd}ಮ", "ಶ\u{cbf}ಂಟೊ", "ಶ\u{cbf}ಂಟೊ ದೇವಾಲಯ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("신토 신사"),
            keywords: &["신사", "신토 신사", "일본 신사", "종교"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("शि\u{902}तो म\u{902}दीर"),
            keywords: &["धर\u{94d}म", "म\u{902}दीर", "शि\u{902}तो"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("синто храмы"),
            keywords: &["дин", "синто", "синто храмы", "храм"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Shinto-Schräin"),
            keywords: &["Relioun", "Schräin", "Shinto", "Shinto-Schräin"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ສານເຈ\u{ebb}\u{ec9}າຊ\u{eb4}ນໂຕ"),
            keywords: &[
                "ຊ\u{eb4}ນໂຕ",
                "ລ\u{eb1}ດທ\u{eb4}",
                "ສານເຈ\u{ebb}\u{ec9}າ",
                "ສານເຈ\u{ebb}\u{ec9}າຊ\u{eb4}ນໂຕ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("Šintoizmo šventykla"),
            keywords: &["religija", "Šintoizmo šventykla", "šintoizmas", "šventykla"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("sintoistu svētnīca"),
            keywords: &[
                "lūgties",
                "reliģija",
                "sintoisms",
                "sintoistu svētnīca",
                "svētnīca",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("wāhi tapu hinito"),
            keywords: &["hinito", "momo karakia", "wāhi tapu", "wāhi tapu hinito"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("шинтоистички храм"),
            keywords: &["религија", "храм", "шинтоизам", "шинтоистички храм"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ജപ\u{d4d}പ\u{d3e}നിലെ പ\u{d42}ർവ\u{d4d}വിക മത ദേവ\u{d3e}ലയം"),
            keywords: &[
                "ജപ\u{d4d}പ\u{d3e}നിലെ പ\u{d42}ർവ\u{d4d}വിക മത ദേവ\u{d3e}ലയം",
                "ജപ\u{d4d}പ\u{d3e}ൻ",
                "മതം",
                "ഷിന\u{d4d}റോ ഷ\u{d4d}രൈൻ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("бурхны газар"),
            keywords: &["бурхны газар", "хийд", "шашин", "шинто"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("शिन\u{94d}तो पवित\u{94d}र जागा"),
            keywords: &[
                "धर\u{94d}म",
                "पवित\u{94d}र जागा",
                "शिन\u{94d}तो",
                "शिन\u{94d}तो पवित\u{94d}र जागा",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("kuil shinto"),
            keywords: &["agama", "kuil", "shinto"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("maqdes shinto"),
            keywords: &["maqdes", "reliġjon", "shinto"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ရ\u{103e}င\u{103a}တ\u{102d}\u{102f} ဘ\u{102f}ရားကျောင\u{103a}း"),
            keywords: &[
                "ဘာသာရေး",
                "ဘ\u{102f}ရားကျောင\u{103a}း",
                "ရ\u{103e}င\u{103a}တ\u{102d}\u{102f}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("Shinto-alter"),
            keywords: &["Shinto-alter", "alter", "religion", "shinto"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("शिन\u{94d}तो धर\u{94d}मको तीर\u{94d}थ"),
            keywords: &[
                "घर\u{94d}म",
                "तीर\u{94d}थ",
                "शिन\u{94d}तो",
                "शिन\u{94d}तो धर\u{94d}मको तीर\u{94d}थ",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("shinto-tempel"),
            keywords: &["geloof", "shinto", "shinto-tempel", "tempel"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("Shinto-alter"),
            keywords: &["Shinto-alter", "alter", "religion", "shinto"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଶ\u{b3f}ଣ\u{b4d}ଟୋ ପବ\u{b3f}ତ\u{b4d}ରସ\u{b4d}ଥଳ"),
            keywords: &[
                "ଧର\u{b4d}ମ",
                "ପବ\u{b3f}ତ\u{b4d}ରସ\u{b4d}ଥଳ",
                "ଶ\u{b3f}ଣ\u{b4d}ଟୋ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਸਿ\u{a70}ਟ\u{a4b} ਮ\u{a70}ਦਿਰ"),
            keywords: &[
                "ਧਰਮ",
                "ਮ\u{a70}ਦਿਰ",
                "ਸ\u{a3c}ਿ\u{a70}ਟ\u{a4b}",
                "ਸਿ\u{a70}ਟ\u{a4b} ਮ\u{a70}ਦਿਰ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("درگاہ شنٹو"),
            keywords: &["درگاہ شنٹو", "شنٹو", "مذہب", "مزار"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Japán Rilíjọn Jujú Haus"),
            keywords: &[
                "Japán Rilíjọn Jujú Haus",
                "Jujú Haus",
                "Rilíjọn",
                "Shrain",
                "Wọ\u{301}n Ọf Japán Rílíjọn",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("świątynia shinto"),
            keywords: &["japońska", "religia", "shinto", "świątynia"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("شینټو مزار"),
            keywords: &["شینټو", "مذهب", "مزار"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("santuário japonês"),
            keywords: &["japonês", "oriental", "religião", "santuário japonês"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("templo xintoísta"),
            keywords: &["religião", "templo", "templo xintoísta", "xintoísmo"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("sintoismo santuario"),
            keywords: &["religion", "santuario", "sintoismo"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("altar shinto"),
            keywords: &["altar", "cult", "religie", "sanctuar", "shinto", "templu"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-108"),
            keywords: &["E10-108"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("синтоистский храм"),
            keywords: &["дзиндзя", "синтоизм", "синтоистский храм", "храм"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("aho bashengerera h’idini ya shinto"),
            keywords: &[
                "aho bashengerera",
                "aho bashengerera h’idini ya shinto",
                "idini",
                "shinto",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("شنٽو جي مزار"),
            keywords: &["شنٽو", "شنٽو جي مزار", "مذهب", "مزار"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ෂ\u{dd2}න\u{dca}ටෝ දේවස\u{dca}ථ\u{dcf}නය"),
            keywords: &[
                "ආගම",
                "ආශ\u{dca}\u{200d}රමය",
                "ෂ\u{dd2}න\u{dca}ටෝ",
                "ෂ\u{dd2}න\u{dca}ටෝ දේවස\u{dca}ථ\u{dcf}නය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("šintoistická svätyňa"),
            keywords: &["náboženstvo", "svätyňa", "šintoistická svätyňa", "šintó"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("šintoistično svetišče"),
            keywords: &["svetišče", "vera", "šinto", "šintoistično svetišče"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("Meel Caabudaad"),
            keywords: &["Meel Caabudaad", "diin", "diinta Jabbaan"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("faltore shinto"),
            keywords: &["faltore", "fe", "shinto"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("шинтоистички храм"),
            keywords: &["рeлигиja", "хрaм", "шинтoизaм", "шинтоистички храм"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["шинтоистички храм"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("šintoistički hram"),
            keywords: &["hram", "religija", "šintoistički hram", "šintoizam"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["šintoistički hram"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("shintohelgedom"),
            keywords: &["religion", "shinto", "shintohelgedom"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("madhabahu ya shinto"),
            keywords: &["dini", "madhabahu", "madhabahu ya shinto", "shinto"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ஷிண\u{bcd}டோ ஸ\u{bcd}ரைன\u{bcd}"),
            keywords: &["மதம\u{bcd}", "ஷிண\u{bcd}டோ", "ஸ\u{bcd}ரைன\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("జపన\u{c40}యుల ప\u{c4d}ర\u{c3e}ర\u{c4d}థన\u{c3e} మంద\u{c3f}రం"),
            keywords: &[
                "జపన\u{c40}యుల ప\u{c4d}ర\u{c3e}ర\u{c4d}థన\u{c3e} మంద\u{c3f}రం",
                "జప\u{c3e}న\u{c4d}",
                "ప\u{c4d}ర\u{c3e}ర\u{c4d}థన",
                "మంద\u{c3f}రం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("ҷои муқаддаси синто"),
            keywords: &["дин", "синто", "ҷои муқаддас", "ҷои муқаддаси синто"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ศาลเจ\u{e49}าช\u{e34}นโต"),
            keywords: &[
                "ช\u{e34}นโต",
                "ล\u{e31}ทธ\u{e34}",
                "ศาลเจ\u{e49}า",
                "ศาลเจ\u{e49}าช\u{e34}นโต",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("şinto ybadathanasy"),
            keywords: &["din", "ybadathana", "şinto", "şinto ybadathanasy"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("falelotu fakasiapani"),
            keywords: &["falelotu fakasiapani"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("Şinto tapınağı"),
            keywords: &["din", "tapınak", "Şinto tapınağı", "şinto"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("شىنتو ئىبادەتخانىسى"),
            keywords: &["ئىبادەتخانا", "دىن", "شىنتو", "شىنتو ئىبادەتخانىسى"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("синтоїстський храм"),
            keywords: &["релігія", "святиня", "синтоїстський", "синтоїстський храм"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("شنٹو مزار"),
            keywords: &["شنٹو مزار", "مذہب", "مزار"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("shinto shrin"),
            keywords: &["din", "shinto", "shrin"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("đền thờ Nhật Bản"),
            keywords: &["tôn giáo", "đền thờ", "đền thờ Nhật Bản"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("armeeli Shinto"),
            keywords: &["armeel", "armeeli Shinto", "diine", "shinto"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("itempilo ye-shinto"),
            keywords: &["i-shinto", "itempile", "itempilo ye-shinto", "unqulo"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("ilé òrìṣà ṣíntò"),
            keywords: &["ilé òrìṣà", "ilé òrìṣà ṣíntò", "ṣíntò", "ẹ\u{300}sìn"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("神教神社"),
            keywords: &["宗教", "神教", "神教神社", "神社"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("神教神社"),
            keywords: &["宗教", "神教", "神教神社", "神社"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("神社"),
            keywords: &["宗教", "日本", "神社", "神道教"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("神社"),
            keywords: &["神社", "鳥居"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("shinto shrine"),
            keywords: &["inkolo", "shinto", "shrine"],
        },
    ],
};
#[doc = "🕋"]
pub const KAABA: crate::Emoji = crate::Emoji {
    glyph: "🕋",
    codepoint: "1F54B",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "kaaba",
    group: "Travel & Places",
    subgroup: "place-religious",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("kaäba"),
            keywords: &["godsdiens", "islam", "kaäba", "moslem"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የሙስሊም ካባ"),
            keywords: &["ሙስሊም", "ኃይማኖት", "እስላም", "የሙስሊም ካባ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("الكعبة"),
            keywords: &["إسلام", "الكعبة", "دين", "مسلم"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ক\u{9be}ব\u{9be}"),
            keywords: &[
                "ইছ\u{9cd}ল\u{9be}ম",
                "ক\u{9be}ব\u{9be}",
                "ধৰ\u{9cd}ম",
                "ম\u{9c1}ছলম\u{9be}ন",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("kəbə"),
            keywords: &["din", "islam", "kəbə", "müsəlman"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("кааба"),
            keywords: &["кааба", "мусульманскі", "рэлігія", "іслам"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("кааба"),
            keywords: &["ислям", "кааба", "мюсюлманин", "религия"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ক\u{9be}ব\u{9be}"),
            keywords: &[
                "ইসল\u{9be}ম",
                "ক\u{9be}ব\u{9be}",
                "ধর\u{9cd}ম",
                "ম\u{9c1}সলিম",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("kaaba"),
            keywords: &["islam", "kaaba", "muzulman", "relijion"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("kaba"),
            keywords: &["islam", "kaba", "musliman", "religija"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("Ka’ba"),
            keywords: &["Ka’ba", "islam", "musulmà", "religió"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎧᏆ"),
            keywords: &["ᎢᏏᎳᎻ", "ᎤᏃᎯᏳᏒ", "ᎧᏆ", "ᎹᏏᎳᎻ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("Kába"),
            keywords: &["Kába", "islám", "kaaba", "kába", "muslim", "náboženství"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("kaaba"),
            keywords: &["Mwslim", "crefydd", "islam", "kaaba"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("Kabaen"),
            keywords: &["Kabaen", "islam", "muslim", "religion"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Kaaba"),
            keywords: &["Islam", "Kaaba", "Moslem", "Muslim", "Religion"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("καάμπα"),
            keywords: &["θρησκεία", "ισλάμ", "καάμπα", "μουσουλμανικός"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("kaaba"),
            keywords: &["Muslim", "islam", "kaaba", "religion"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("Kaaba"),
            keywords: &["Islam", "Kaaba", "Muslim", "religion"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["Islam", "Kaaba", "Muslim", "kaaba", "religion"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("Kaaba"),
            keywords: &["Kaaba", "islam", "kaaba", "religión"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["Kaaba", "edificio", "islam", "musulmán", "religión"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &[
                "El Cubo",
                "Kaaba",
                "edificio",
                "islam",
                "musulmán",
                "religión",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kaaba"),
            keywords: &["islam", "kaaba", "moslem", "usk"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("kaaba"),
            keywords: &["erlijio", "islam", "kaaba", "musulman"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("کعبه"),
            keywords: &["اسلام", "حج", "دین", "مسلمان", "مکه", "کعبه"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("Kaaba"),
            keywords: &["Kaaba", "islam", "muslimi", "rakennus", "uskonto"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("kaaba"),
            keywords: &["cube", "islam", "kaaba", "muslim", "relihiyon"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("Kaaba"),
            keywords: &[
                "Kaaba",
                "halgidómur",
                "islam",
                "islamskt",
                "mekka",
                "muslimur",
                "religión",
                "trúgv",
                "átrúnaður",
                "átrúni",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("kaaba"),
            keywords: &["islam", "kaaba", "musulman", "religion"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("cába"),
            keywords: &["creideamh", "cába", "ioslam", "moslamach"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("ka’aba"),
            keywords: &["creideamh", "ioslam", "ka’aba", "muslamach"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("Kaaba"),
            keywords: &["A Meca", "Kaaba", "islamismo", "musulmán", "relixión"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("કાબા"),
            keywords: &["ઇસ\u{acd}લામ", "કાબા", "ધર\u{acd}મ", "મ\u{ac1}સ\u{acd}લિમ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("kaaba"),
            keywords: &["Musulmi", "addini", "islam", "kaaba"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("כעבה"),
            keywords: &["איסלם", "דת", "כעבה", "מוסלמי"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("काबा, म\u{941}स\u{94d}लिम धर\u{94d}म"),
            keywords: &[
                "काबा",
                "काबा, म\u{941}स\u{94d}लिम धर\u{94d}म",
                "धर\u{94d}म",
                "म\u{941}स\u{94d}लिम",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("kaba"),
            keywords: &["islam", "kaba", "religija"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("kába"),
            keywords: &["iszlám", "kába", "mohamedán", "muszlim", "vallás"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("կաաբա"),
            keywords: &["իսլամ", "կաաբա", "կրոն", "մուսուլման"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("ka’bah"),
            keywords: &["agama", "islam", "ka’bah", "muslim"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("kaaba"),
            keywords: &["Ndị Alakụba", "kaaba", "okpukperechi", "ụka Alakụba"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("kaaba-byggingin"),
            keywords: &["kaaba-byggingin", "múslimi", "trúarbrögð", "íslam"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("Kaaba"),
            keywords: &[
                "Arabia Saudita",
                "Kaaba",
                "La Mecca",
                "islamismo",
                "religione",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("カーバ"),
            keywords: &["イスラム教", "カーバ", "メッカ", "宗教", "建物", "聖地"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("Kakbah"),
            keywords: &["Islam", "Kakbah", "Muslim", "agama"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ქააბა"),
            keywords: &["ისლამი", "მუსლიმანური", "რელიგია", "ქააბა"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("lkaɛva"),
            keywords: &["lkaɛva"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("Қағба"),
            keywords: &["дін", "ислам", "мұсылман", "Қағба"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("kaaba"),
            keywords: &["islam", "kaaba", "muslim", "religion"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("វ\u{17b7}ហារកាបា (សាសនាអ\u{17ca}\u{17b8}ស\u{17d2}លាម)"),
            keywords: &[
                "វ\u{17b7}ហារ",
                "វ\u{17b7}ហារកាបា (សាសនាអ\u{17ca}\u{17b8}ស\u{17d2}លាម)",
                "សាសនា",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕಾಬಾ"),
            keywords: &["ಇಸ\u{ccd}ಲಾಂ", "ಕಾಬಾ", "ಮುಸ\u{ccd}ಲ\u{cbf}ಂ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("카바"),
            keywords: &["이슬람", "종교", "카바"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("काबा"),
            keywords: &["ईस\u{94d}लाम", "काबा", "धर\u{94d}म", "म\u{941}सलमान"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("кааба"),
            keywords: &["дин", "ислам", "кааба", "мусулман"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Kaaba"),
            keywords: &["Islam", "Kaaba", "Moslem", "Relioun"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ວ\u{eb4}ຫານກະບະ"),
            keywords: &[
                "ມ\u{eb8}ດສະລ\u{eb4}ມ",
                "ວ\u{eb4}ຫານ",
                "ວ\u{eb4}ຫານກະບະ",
                "ສາສະໜາ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("kaaba"),
            keywords: &["islamas", "kaaba", "musulmonas", "religija"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("kaaba"),
            keywords: &[
                "islams",
                "kaaba",
                "lūgties",
                "musulmaņi",
                "māja",
                "reliģija",
                "ēka",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kaapa"),
            keywords: &["ihirama", "kaapa", "momo karakia", "muhurimi"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("ќаба"),
            keywords: &["ислам", "муслиманска", "религија", "ќаба"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("കഅബ"),
            keywords: &[
                "ഇസ\u{d4d}ല\u{d3e}മിക വിശ\u{d4d}വ\u{d3e}സം",
                "കഅബ",
                "നിസ\u{d4d}\u{200c}ക\u{d4d}ക\u{d3e}രം",
                "മ\u{d41}സ\u{d4d}ലീം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("кааба"),
            keywords: &["ислам", "кааба", "шашин"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("काबा"),
            keywords: &["इस\u{94d}लाम", "काबा", "धर\u{94d}म", "म\u{941}स\u{94d}लिम"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("kaabah"),
            keywords: &["agama", "islam", "kaabah", "orang islam"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("kaaba"),
            keywords: &["Islam", "Musulmana", "kaaba", "reliġjon"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ကပ\u{103a}ဘာ"),
            keywords: &[
                "ကပ\u{103a}ဘာ",
                "ဘာသာရေး",
                "မ\u{1030}ဆလင\u{103a}",
                "အစ\u{1039}စလာမ\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("Kaba"),
            keywords: &["Kaba", "islam", "muslim", "religion"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("काबा"),
            keywords: &["इस\u{94d}लाम", "काबा", "धर\u{94d}म", "म\u{941}स\u{94d}लिम"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("kaäba"),
            keywords: &["geloof", "islam", "kaäba", "moslim"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("Kaba"),
            keywords: &["Kaba", "islam", "muslim", "religion"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("କ\u{b3e}ବ\u{b3e}"),
            keywords: &[
                "ଇସଲ\u{b3e}ମ",
                "କ\u{b3e}ବ\u{b3e}",
                "ଧର\u{b4d}ମ",
                "ମ\u{b41}ସଲମ\u{b3e}ନ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਕਾਬਾ"),
            keywords: &["ਇਸਲਾਮ", "ਕਾਬਾ", "ਧਰਮ", "ਮ\u{a41}ਸਲਮਾਨ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("کعبہ"),
            keywords: &["اسلام", "مذہب", "مسلمان", "کعبہ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Kaaba"),
            keywords: &["Kaaba", "Múslim", "Rilíjọn", "Íslam"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("kaaba"),
            keywords: &["islam", "kaaba", "muzułmanin", "religia"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("کعبه"),
            keywords: &["اسلام", "مذهب", "مسلمان", "کعبه"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("caaba islã"),
            keywords: &["caaba islã", "islã", "muçulmano", "religião"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("caaba"),
            keywords: &["caaba", "islamismo", "muçulmano", "religião"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("kaaba"),
            keywords: &["Musulman", "islam", "kaaba", "religion"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("lăcaș de cult islamic kaaba"),
            keywords: &[
                "cult",
                "islam",
                "kaaba",
                "lăcaș de cult islamic kaaba",
                "religie",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-764"),
            keywords: &["E10-764"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("Кааба"),
            keywords: &[
                "Кааба",
                "ислам",
                "кааба",
                "мусульмане",
                "религия",
                "святыня",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("akaba"),
            keywords: &["Umusilamu", "akaba", "idini", "isilamu"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڪعبو"),
            keywords: &["اسلام", "مذهب", "مسلم", "ڪعبو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ක\u{dcf}බ\u{dcf}"),
            keywords: &[
                "ආගම",
                "ඉස\u{dca}ල\u{dcf}ම\u{dca}",
                "ක\u{dcf}බ\u{dcf}",
                "ම\u{dd4}ස\u{dca}ල\u{dd2}ම\u{dca}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("kába"),
            keywords: &["islam", "kába", "moslim", "náboženstvo"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("kaaba"),
            keywords: &["islam", "kaaba", "muslimansko", "vera"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("Kacbah"),
            keywords: &["Islaam", "Kacbah", "Muslim", "diin"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("qabeja"),
            keywords: &["fe", "islam", "mysliman", "qabeja"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("каба"),
            keywords: &["ислaм", "каба", "муслимани", "рeлигиja"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("kaba"),
            keywords: &["islam", "kaba", "muslimani", "religija"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("kaba"),
            keywords: &["islam", "kaba", "muslim", "religion"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kaaba"),
            keywords: &["dini", "kaaba", "muislamu", "uislamu"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("க\u{bbe}ப\u{bbe}"),
            keywords: &[
                "இஸ\u{bcd}ல\u{bbe}மியம\u{bcd}",
                "இஸ\u{bcd}ல\u{bbe}ம\u{bcd}",
                "க\u{bbe}ப\u{bbe}",
                "மதம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("మక\u{c4d}క\u{c3e} మస\u{c40}దు"),
            keywords: &["మక\u{c4d}క\u{c3e}", "మస\u{c40}దు"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("каъба"),
            keywords: &["Ислом", "дин", "каъба", "мусулмон"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ว\u{e34}หารกะอ\u{e4c}บะฮ\u{e4c}"),
            keywords: &[
                "ม\u{e38}สล\u{e34}ม",
                "ว\u{e34}หารกะอ\u{e4c}บะฮ\u{e4c}",
                "ศาสนา",
                "อ\u{e34}สลาม",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("Käbe"),
            keywords: &["Käbe", "din", "musulman", "yslam"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("fale māʻoniʻoni fakaʻisilami"),
            keywords: &["fale māʻoniʻoni fakaʻisilami"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("Kâbe"),
            keywords: &["Kâbe", "din", "islam", "müslüman"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("كەبە"),
            keywords: &["ئىسلام", "دىن", "كەبە", "مۇسۇلمان"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("Кааба"),
            keywords: &["Кааба", "мусульманський", "релігія", "іслам"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("کعبہ"),
            keywords: &["عبادت", "عمارت", "مسلمان", "مکہ", "کعبہ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("kabatulloh"),
            keywords: &["din", "islom", "kabatulloh", "muslim"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("kaaba"),
            keywords: &["hồi giáo", "kaaba", "thuộc hồi giáo", "tôn giáo"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("Kaaba"),
            keywords: &["Jullit", "Kaaba", "diine", "islam"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("i-kaaba"),
            keywords: &["i-Muslim", "i-islam", "i-kaaba", "unqulo"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Kaaba"),
            keywords: &["Kaaba", "Mùsùlùmí", "Ìmàle", "ẹ\u{300}sìn"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("天房"),
            keywords: &["伊斯蘭教徒", "天房", "宗教", "穆斯林"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("天房"),
            keywords: &["伊斯兰教徒", "天房", "宗教", "穆斯林"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("克尔白"),
            keywords: &["伊斯兰", "克尔白", "天房", "宗教", "穆斯林"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("天房"),
            keywords: &["伊斯蘭建築", "天房"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("麥加"),
            keywords: &["神社", "穆斯林", "聖堂", "麥加"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("i-kaaba"),
            keywords: &["amasulumane", "i-kaaba", "inkolo"],
        },
    ],
};
