#[doc = "⛲"]
pub const FOUNTAIN: crate::Emoji = crate::Emoji {
    glyph: "⛲",
    codepoint: "26F2",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "fountain",
    group: "Travel & Places",
    subgroup: "place-other",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("fontein"),
            keywords: &["fontein"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ፏፏቴ"),
            keywords: &["ፏፏቴ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("نافورة"),
            keywords: &["نافورة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ফোৱ\u{9be}ৰ\u{9be}"),
            keywords: &["ফোৱ\u{9be}ৰ\u{9be}"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("fontan"),
            keywords: &["fontan"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("фантан"),
            keywords: &["фантан"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("фонтан"),
            keywords: &["фонтан"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ফোয\u{9bc}\u{9be}র\u{9be}"),
            keywords: &["ফোয\u{9bc}\u{9be}র\u{9be}"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("feunteun"),
            keywords: &["feunteun"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("fontana"),
            keywords: &["fontana"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("font"),
            keywords: &["font"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᎹ ᎤᎾᏄᎪᎢᏍᏗ"),
            keywords: &["ᎠᎹ ᎤᎾᏄᎪᎢᏍᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("fontána"),
            keywords: &["fontána", "vodotrysk"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("ffynnon"),
            keywords: &["ffynnon"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("springvand"),
            keywords: &["fontæne", "springvand"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Springbrunnen"),
            keywords: &["Brunnen", "Garten", "Park", "Springbrunnen"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("σιντριβάνι"),
            keywords: &["πηγή", "σιντριβάνι"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("fountain"),
            keywords: &["fountain"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("fuente"),
            keywords: &["fuente"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("purskkaev"),
            keywords: &["purskkaev"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("iturria"),
            keywords: &["iturri", "iturria"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("فواره"),
            keywords: &["آب\u{200c}فشان", "حوض و فواره", "فشانه", "فواره"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("suihkulähde"),
            keywords: &["suihku", "suihkulähde", "vesi"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("fountain"),
            keywords: &["fountain"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("gosvatn"),
            keywords: &["gosbrunnur", "gosvatn"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("fontaine"),
            keywords: &["fontaine"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("scairdeán"),
            keywords: &["fuarán", "scairdeán", "scardán"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("fuaran"),
            keywords: &["fuaran"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("fonte"),
            keywords: &["fonte"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ફ\u{ac1}વારો"),
            keywords: &["ફ\u{ac1}વારો"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("marmaro"),
            keywords: &["marmaro"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("מזרקה"),
            keywords: &["מזרקה", "מים"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("फ\u{93c}व\u{94d}वारा"),
            keywords: &["झरना", "फव\u{94d}वारा", "फ\u{93c}व\u{94d}वारा"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("fontana"),
            keywords: &["fontana", "vodoskok"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("szökőkút"),
            keywords: &["szökőkút"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("շատրվան"),
            keywords: &["շատրվան"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("air mancur"),
            keywords: &["air", "air mancur", "pancuran"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ebe mgbapụta mmiri"),
            keywords: &["ebe mgbapụta mmiri"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("gosbrunnur"),
            keywords: &["brunnur", "gosbrunnur"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("fontana"),
            keywords: &["acqua che scorre", "fontana"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("噴水"),
            keywords: &["噴水"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("banyu muncrat"),
            keywords: &["banyu muncrat"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("შადრევანი"),
            keywords: &["შადრევანი"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("tala"),
            keywords: &["tala"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("бұрқақ"),
            keywords: &["бұрқақ"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("springvand"),
            keywords: &["fontæne", "springvand"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ស\u{17bd}នបាញ\u{17cb}ទ\u{17b9}ក"),
            keywords: &[
                "បាញ\u{17cb}ទ\u{17b9}ក",
                "ស\u{17bd}ន",
                "ស\u{17bd}នបាញ\u{17cb}ទ\u{17b9}ក",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕಾರಂಜ\u{cbf}"),
            keywords: &["ಕಾರಂಜ\u{cbf}", "ನೀರು ಚ\u{cbf}ಮ\u{ccd}ಮುವ ಕುಂಡ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("분수"),
            keywords: &["분수", "분수대"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("झरो"),
            keywords: &["झरो"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("фонтан"),
            keywords: &["фонтан"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Sprangbuer"),
            keywords: &["Sprangbuer"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ນ\u{ecd}\u{ec9}າພ\u{eb8}"),
            keywords: &["ນ\u{ecd}\u{ec9}າພ\u{eb8}"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("fontanas"),
            keywords: &["fontanas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("strūklaka"),
            keywords: &["strūklaka", "ūdens"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("puna torotī"),
            keywords: &["puna torotī"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("фонтана"),
            keywords: &["фонтана"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ജലധ\u{d3e}ര"),
            keywords: &[
                "ജലധ\u{d3e}ര",
                "ജലധ\u{d3e}ര\u{d3e}യന\u{d4d}ത\u{d4d}രം",
                "ഫ\u{d57}ണ\u{d4d}ടെയിൻ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("усан оргилуур"),
            keywords: &["оргилуур", "ус", "усан оргилуур"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("कार\u{902}ज\u{947}"),
            keywords: &["कार\u{902}ज\u{947}"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("air pancut"),
            keywords: &["air pancut"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("funtana"),
            keywords: &["funtana"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အလ\u{103e}ပြ ရေပန\u{103a}း"),
            keywords: &["ရေပန\u{103a}း", "အလ\u{103e}ပြ ရေပန\u{103a}း"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("fontene"),
            keywords: &["fontene"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("झरणा"),
            keywords: &["झरणा"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("fontein"),
            keywords: &["fontein"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("fontene"),
            keywords: &["fontene"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଝରଣ\u{b3e}"),
            keywords: &["ଝରଣ\u{b3e}", "ଫ\u{b3e}ଉଣ\u{b4d}ଟେନ\u{b4d}"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਫ\u{a41}ਹਾਰਾ"),
            keywords: &["ਝਰਨਾ", "ਫ\u{a41}ਹਾਰਾ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("فوارہ"),
            keywords: &["فوارہ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Sọ\u{301}mtin Wé De Pọ\u{301}mp Wọtá Gó Ọp"),
            keywords: &["Sọ\u{301}mtin Wé De Pọ\u{301}mp Wọtá Gó Ọp"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("fontanna"),
            keywords: &["fontanna"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("مورينه"),
            keywords: &["مورينه"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("fonte"),
            keywords: &["chafariz", "fonte"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("pukyu"),
            keywords: &["pukyu"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("fântână arteziană"),
            keywords: &["apă", "fântână", "fântână arteziană"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-112"),
            keywords: &["E10-112"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("фонтан"),
            keywords: &["брызги", "вода", "фонтан"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umugezi"),
            keywords: &["umugezi"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڦوهارو"),
            keywords: &["ڦوهارو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("වත\u{dd4}ර මල\u{dca}"),
            keywords: &["වත\u{dd4}ර මල", "වත\u{dd4}ර මල\u{dca}"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("fontána"),
            keywords: &["fontána", "vodomet", "vodostrek"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("fontana"),
            keywords: &["fontana", "vodnjak"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("tuubo biyo kor u ganta"),
            keywords: &["tuubo biyo kor u ganta"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("shatërvan"),
            keywords: &["shatërvan"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("фонтана"),
            keywords: &["вoдoскoк", "фoнтaнa", "фонтана"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["фонтана"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("fontana"),
            keywords: &["fontana", "vodoskok"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["fontana"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("fontän"),
            keywords: &["fontän", "springbrunn"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mlizamu"),
            keywords: &["mlizamu"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ந\u{bc0}ருற\u{bcd}று"),
            keywords: &[
                "தோட\u{bcd}டம\u{bcd}",
                "ந\u{bc0}ருற\u{bcd}று",
                "பூங\u{bcd}க\u{bbe}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ఫ\u{c4c}ంట\u{c46}య\u{c3f}న\u{c4d}"),
            keywords: &["ఫ\u{c4c}ంట\u{c46}య\u{c3f}న\u{c4d}"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("фаввора"),
            keywords: &["фаввора"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("น\u{e49}ำพ\u{e38}"),
            keywords: &["น\u{e49}ำพ\u{e38}"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("çüwdürim"),
            keywords: &["çüwdürim"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("fauniteni"),
            keywords: &["fauniteni"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("fıskiye"),
            keywords: &["fıskiye", "çeşme"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئوقبۇلاق"),
            keywords: &["ئوقبۇلاق"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("фонтан"),
            keywords: &["фонтан"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("چشمہ"),
            keywords: &["فاؤنٹين", "فواره", "پانی کا چشمہ", "چشمہ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("fontan"),
            keywords: &["fontan"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("đài phun nước"),
            keywords: &["đài phun nước"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("ndax muy sànni"),
            keywords: &["ndax muy sànni"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ingxangxasi"),
            keywords: &["ingxangxasi"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Orísun omi"),
            keywords: &["Orísun omi"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("噴水池"),
            keywords: &["噴水池"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("喷水池"),
            keywords: &["喷水池"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("喷泉"),
            keywords: &["喷泉"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("噴泉"),
            keywords: &["噴水池", "噴泉"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("umthombo"),
            keywords: &["umthombo"],
        },
    ],
};
#[doc = "⛺"]
pub const TENT: crate::Emoji = crate::Emoji {
    glyph: "⛺",
    codepoint: "26FA",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "tent",
    group: "Travel & Places",
    subgroup: "place-other",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("tent"),
            keywords: &["kampeer", "nag", "tent"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ድንኳን"),
            keywords: &["በድንኳን መስፈር", "ድንኳን"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("خيمة"),
            keywords: &["تخييم", "خيمة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("টেণ\u{9cd}ট"),
            keywords: &["কেম\u{9cd}পিং", "টেণ\u{9cd}ট"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("çadır"),
            keywords: &["kempinq", "çadır"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("палатка"),
            keywords: &["кемпінг", "палатка"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("палатка"),
            keywords: &["къмпинг", "палатка"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ত\u{9be}ব\u{9c1}"),
            keywords: &[
                "ত\u{9be}ব\u{9c1}",
                "ত\u{9be}ব\u{9c1} খ\u{9be}\u{981}ট\u{9be}নো",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("teltenn"),
            keywords: &["kampiñ", "teltenn"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("šator"),
            keywords: &["kampovanje", "šator"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("tenda"),
            keywords: &[
                "acampada",
                "campament",
                "càmping",
                "tenda",
                "tenda de campanya",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎦᎵᏦᏛ"),
            keywords: &["ᎦᎵᏦᏛ", "ᏓᏂᎵᏦᏛᏍᎬᎢ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("stan"),
            keywords: &["kemp", "kempování", "stan", "tábor", "táboření"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("pabell"),
            keywords: &["gwersylla", "pabell"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("telt"),
            keywords: &["camping", "telt"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Zelt"),
            keywords: &["Camping", "Campingurlaub", "Zelt", "Zeltplatz"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("σκηνή"),
            keywords: &["κατασκήνωση", "σκηνή"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("tent"),
            keywords: &["camping", "tent"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("tienda de campaña"),
            keywords: &[
                "campaña",
                "camping",
                "tienda",
                "tienda de campaña",
                "vacaciones",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("carpa"),
            keywords: &["acampar", "campamento", "camping", "carpa"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("casa de campaña"),
            keywords: &["casa de campaña"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("telk"),
            keywords: &["laager", "telk", "telkimine"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("denda"),
            keywords: &["denda", "kanpin"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("چادر"),
            keywords: &["خیمه", "چادر", "چادر زدن", "چادرزنی", "کمپینگ"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("teltta"),
            keywords: &["leirintä", "teltta", "telttailu"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("tent"),
            keywords: &["camping", "scout", "tent"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("tjald"),
            keywords: &[
                "kampingpláss",
                "legupláss",
                "legutilvera",
                "tjald",
                "tjalda",
                "tjalding",
                "tjaldlega",
                "tjaldstaður",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("tente"),
            keywords: &["camping", "tente"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("puball"),
            keywords: &["campa", "campáil", "puball"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("teanta"),
            keywords: &["campachadh", "teanta"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("tenda de campaña"),
            keywords: &["acampar", "campamento", "cámping", "tenda de campaña"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ત\u{a82}બ\u{ac1}"),
            keywords: &["ક\u{ac7}મ\u{acd}પિ\u{a82}ગ", "ત\u{a82}બ\u{ac1}"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("tanti"),
            keywords: &["tanti", "zaman ruga"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("אוהל"),
            keywords: &["אוהל", "מחנה", "קמפינג"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ट\u{947}\u{902}ट, क\u{948}\u{902}पि\u{902}ग"),
            keywords: &[
                "क\u{948}\u{902}पि\u{902}ग",
                "ट\u{947}\u{902}ट",
                "ट\u{947}\u{902}ट, क\u{948}\u{902}पि\u{902}ग",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("šator"),
            keywords: &["kampiranje", "šator"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("sátor"),
            keywords: &["kempingezés", "szállás", "sátor"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("վրան"),
            keywords: &["ճամբար", "վրան"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("tenda"),
            keywords: &["berkemah", "tenda"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ụlọ akwà"),
            keywords: &["ọgbakọ nzuruike", "ụlọ akwà"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("tjald"),
            keywords: &["tjald", "tjaldstæði", "útilega"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("tenda"),
            keywords: &["campeggio", "tenda"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("テント"),
            keywords: &["キャンプ", "テント"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("tendha"),
            keywords: &["kemah", "tendha"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("კარავი"),
            keywords: &["კარავი", "ლაშქრობა"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("aqiḍun"),
            keywords: &["aqiḍun"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("шатыр"),
            keywords: &["кемпинг", "шатыр"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("telt"),
            keywords: &["telt"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("តង\u{17cb}"),
            keywords: &["ជ\u{17c6}រ\u{17bb}\u{17c6}", "តង\u{17cb}"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಟ\u{cc6}ಂಟ\u{ccd}"),
            keywords: &["ಕ\u{ccd}ಯಾಂಪ\u{cbf}ಂಗ\u{ccd}", "ಟ\u{cc6}ಂಟ\u{ccd}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("텐트"),
            keywords: &["캠프", "캠핑", "텐트"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("त\u{902}ब\u{942}"),
            keywords: &["छावणी", "त\u{902}ब\u{942}"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("чатыр"),
            keywords: &["лагерь", "чатыр"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Zelt"),
            keywords: &["Camping", "Zelt"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເຕ\u{eb1}ນ"),
            keywords: &["ຕ\u{eb1}\u{ec9}ງແຄ\u{eb1}ມ", "ເຕ\u{eb1}ນ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("palapinė"),
            keywords: &["palapinė", "stovyklavimas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("telts"),
            keywords: &["kempings", "telts"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tēneti"),
            keywords: &["puninga", "tēneti"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("шатор"),
            keywords: &["кампување", "шатор"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ക\u{d42}ട\u{d3e}രം"),
            keywords: &["ക\u{d42}ട\u{d3e}രം", "ക\u{d4d}യ\u{d3e}മ\u{d4d}പിംഗ\u{d4d}"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("майхан"),
            keywords: &["зугаалга", "майхан"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("त\u{902}ब\u{942}"),
            keywords: &["क\u{945}म\u{94d}पि\u{902}ग", "त\u{902}ब\u{942}"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("khemah"),
            keywords: &["khemah", "perkhemahan"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("tinda"),
            keywords: &["kampeġġ", "tinda"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ရ\u{103d}က\u{103a}ဖျင\u{103a}တ\u{1032}"),
            keywords: &[
                "စခန\u{103a}းချခြင\u{103a}း",
                "တ\u{1032}",
                "ရ\u{103d}က\u{103a}ဖျင\u{103a}တ\u{1032}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("telt"),
            keywords: &["camping", "telt", "telttur"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("ट\u{947}न\u{94d}ट"),
            keywords: &["क\u{94d}याम\u{94d}पिङ", "ट\u{947}न\u{94d}ट"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("tent"),
            keywords: &["kamperen", "tent"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("telt"),
            keywords: &["camping", "telt", "telttur"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ତମ\u{b4d}ବ\u{b41}"),
            keywords: &[
                "ଟେଣ\u{b4d}ଟ\u{b4d}",
                "ତମ\u{b4d}ବ\u{b41}",
                "ଶ\u{b3f}ବ\u{b3f}ର",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਟ\u{a48}\u{a02}ਟ"),
            keywords: &["ਕ\u{a48}\u{a02}ਪਿ\u{a70}ਗ", "ਟ\u{a48}\u{a02}ਟ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("خیمہ"),
            keywords: &["خیمہ", "خیمہ زنی"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Tẹnt"),
            keywords: &["Kamp", "Tẹnt"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("namiot"),
            keywords: &["kemping", "namiot", "obóz", "pole namiotowe"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("خيمه"),
            keywords: &["خيمه", "خيمه رغول"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("barraca"),
            keywords: &["acampamento", "barraca"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("tenda"),
            keywords: &["campismo", "tenda"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("carpa"),
            keywords: &["carpa", "tampuchay"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("cort"),
            keywords: &["camping", "cort"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-119"),
            keywords: &["E10-119"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("палатка"),
            keywords: &["кемпинг", "лагерь", "палатка", "тент"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ihema"),
            keywords: &["ihema", "ingando"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("خيمو"),
            keywords: &["خيمه گاه", "خيمو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ක\u{dd6}ඩ\u{dcf}රම"),
            keywords: &["කඳව\u{dd4}ර\u{dd4} බැඳ\u{dd3}ම", "ක\u{dd6}ඩ\u{dcf}රම"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("stan"),
            keywords: &["kempovať", "stan", "táboriť"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("šotor"),
            keywords: &["taborjenje", "šotor"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("teendho"),
            keywords: &["teendho", "xero"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("tendë"),
            keywords: &["kamp", "tendë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("шатор"),
            keywords: &["кaмповање", "шатор"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("šator"),
            keywords: &["kampovanje", "šator"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("tält"),
            keywords: &["camping", "tält"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("hema"),
            keywords: &["hema", "kupiga kambi"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("கூட\u{bbe}ரம\u{bcd}"),
            keywords: &["கூட\u{bbe}ரம\u{bcd}", "பயிற\u{bcd}சி", "முக\u{bbe}ம\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("గుడ\u{c3e}రం"),
            keywords: &["ఆశ\u{c4d}రయం", "గుడ\u{c3e}రం"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("хайма"),
            keywords: &["хайма", "хаймазанӣ"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เต\u{e47}นท\u{e4c}"),
            keywords: &["ต\u{e31}\u{e49}งแคมป\u{e4c}", "เต\u{e47}นท\u{e4c}"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("çadyr"),
            keywords: &["kemping", "çadyr"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("teniti"),
            keywords: &["teniti"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("çadır"),
            keywords: &["kamp yeri", "çadır"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("چېدىر"),
            keywords: &["دالىدا قونۇش", "چېدىر"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("намет"),
            keywords: &["намет", "похід"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("خیمہ"),
            keywords: &["خیمہ", "شامیانہ", "ڈیرا", "کیمپنگ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("chodir"),
            keywords: &["chodir", "lager"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("lều"),
            keywords: &["cắm trại", "lều"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("tant"),
            keywords: &["kampiŋ", "tant"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("intente"),
            keywords: &["intente", "ukuhlala ententeni"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Àgọ\u{301}"),
            keywords: &["pípàgọ\u{301}", "Àgọ\u{301}"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("帳篷"),
            keywords: &["帳篷", "露營"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("帐篷"),
            keywords: &["帐篷", "露营"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("帐篷"),
            keywords: &["帐篷", "露营"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("帳篷"),
            keywords: &["帳篷", "露營"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("itende"),
            keywords: &["itende", "ukulala etendeni"],
        },
    ],
};
#[doc = "🌁"]
pub const FOGGY: crate::Emoji = crate::Emoji {
    glyph: "🌁",
    codepoint: "1F301",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "foggy",
    group: "Travel & Places",
    subgroup: "place-other",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("mistig"),
            keywords: &["mis", "mistig", "weer"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ጭጋጋማ"),
            keywords: &["የአየር ንብረት", "ጭጋጋማ", "ጭጋግ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("ضباب"),
            keywords: &["ضباب", "طقس"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ক\u{9c1}\u{981}ৱলিময\u{9bc}"),
            keywords: &["ক\u{9c1}\u{981}ৱলি", "ক\u{9c1}\u{981}ৱলিময\u{9bc}"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("dumanlı"),
            keywords: &["duman", "dumanlı", "hava"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("туманнае надвор’е"),
            keywords: &["надвор’е", "туман", "туманнае надвор’е"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("мъгливо"),
            keywords: &["време", "мъгла", "мъгливо"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ক\u{9c1}য\u{9bc}\u{9be}শ\u{9be}চ\u{9cd}ছন\u{9cd}ন"),
            keywords: &[
                "আবহ\u{9be}ওয\u{9bc}\u{9be}",
                "ক\u{9c1}য\u{9bc}\u{9be}শ\u{9be}",
                "ক\u{9c1}য\u{9bc}\u{9be}শ\u{9be}চ\u{9cd}ছন\u{9cd}ন",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("brumennek"),
            keywords: &["brumennek", "latar"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("maglovito"),
            keywords: &["magla", "maglovito", "vrijeme"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("paisatge emboirat"),
            keywords: &["boira", "paisatge", "paisatge emboirat"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᎬᎭᏓ"),
            keywords: &["ᎤᎬᎭᏓ", "ᎤᎬᎭᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("mlha"),
            keywords: &["mlha", "počasí"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("niwlog"),
            keywords: &["niwl", "niwlog"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("tåget"),
            keywords: &["tåge", "tåget"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("neblig"),
            keywords: &["Nebel", "Wetter", "neblig"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ομιχλώδες τοπίο"),
            keywords: &["καιρός", "ομίχλη", "ομιχλώδες τοπίο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("foggy"),
            keywords: &["fog", "foggy"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("bruma"),
            keywords: &["bruma", "niebla"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("niebla"),
            keywords: &["bruma", "neblina", "niebla"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("udune"),
            keywords: &["ilm", "udu", "udune"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("lainotu"),
            keywords: &["eguraldi", "laino", "lainotu"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("مه\u{200c}آلود"),
            keywords: &["آب\u{200c}وهوا", "مه", "مه\u{200c}آلود"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("sumuinen"),
            keywords: &["sumu", "sumuinen", "sää"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("mahamog"),
            keywords: &["bundok", "hamog", "lagay ng panahon", "mahamog", "panahon"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("fjallatoppur og mjørki"),
            keywords: &["fjallatoppur", "fjallatoppur og mjørki", "mjørki", "toka"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("brume"),
            keywords: &["brouillard", "brume"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("ceomhar"),
            keywords: &["ceo", "ceomhar"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("ceòthach"),
            keywords: &["ceò", "ceòthach"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("paisaxe nebulosa"),
            keywords: &[
                "borraxeira",
                "meteoroloxía",
                "neboeira",
                "nebuloso",
                "paisaxe nebulosa",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ધ\u{ac1}મ\u{acd}મસિય\u{ac1}\u{a82}"),
            keywords: &["ધ\u{ac1}મ\u{acd}મસ", "ધ\u{ac1}મ\u{acd}મસિય\u{ac1}\u{a82}"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("mai hazo"),
            keywords: &["hazo", "mai hazo"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("מזג אוויר ערפילי"),
            keywords: &["מזג אוויר", "מזג אוויר ערפילי", "ערפל"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("क\u{941}हासा, कोहरा"),
            keywords: &["क\u{941}हासा", "क\u{941}हासा, कोहरा", "कोहरा"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("maglovito"),
            keywords: &["magla", "maglovito", "vrijeme"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("ködös"),
            keywords: &["időjárás", "köd", "ködös"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("մառախլապատ"),
            keywords: &["եղանակ", "մառախլապատ", "մառախուղ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("berkabut"),
            keywords: &["berkabut", "cuaca", "kabut"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("igirigi obere"),
            keywords: &["igirigi nnukwu", "igirigi obere"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("þokukennt"),
            keywords: &["veður", "þoka", "þokukennt"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("nebbioso"),
            keywords: &["clima", "meteo", "nebbia", "nebbioso"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("霧の都会"),
            keywords: &["都会", "霧", "霧の都会"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("katutup pedhut"),
            keywords: &["katutup pedhut", "pedhut"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ნისლიანი ამინდი"),
            keywords: &["ამინდი", "ნისლი", "ნისლიანი ამინდი"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("agu"),
            keywords: &["agu"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("тұманды"),
            keywords: &["ауа райы", "тұман", "тұманды"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("tåget"),
            keywords: &["tåge", "tåget"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("អ\u{17d0}ព\u{17d2}ទបា\u{17c6}ងភ\u{17d2}ន\u{17c6}"),
            keywords: &[
                "ម\u{17b7}នច\u{17d2}បាស\u{17cb}",
                "អ\u{17d0}ព\u{17d2}ទ",
                "អ\u{17d0}ព\u{17d2}ទបា\u{17c6}ងភ\u{17d2}ន\u{17c6}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಮಂಜ\u{cbf}ನ"),
            keywords: &["ಮಂಜ\u{cbf}ನ", "ಮಂಜು"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("자욱한 안개"),
            keywords: &["날씨", "스모그", "자욱한 안개"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("ध\u{941}काळ"),
            keywords: &["ध\u{941}काळ", "ध\u{941}क\u{947}\u{902}"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("туман баскан"),
            keywords: &["аба ырайы", "туман", "туман баскан"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("niwweleg"),
            keywords: &["Niwwel", "niwweleg"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໝອກລ\u{ebb}ງ"),
            keywords: &["ໝອກ", "ໝອກລ\u{ebb}ງ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("rūkas"),
            keywords: &["oras", "rūkas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("miglains"),
            keywords: &["laikapstākļi", "laiks", "migla", "miglains"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kohukohu"),
            keywords: &["kohu", "kohukohu"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("магливо"),
            keywords: &["време", "магла", "магливо"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("മ\u{d42}ടികെട\u{d4d}ടിയ"),
            keywords: &[
                "മഞ\u{d4d}ഞ\u{d4d}",
                "മ\u{d42}ടികെട\u{d4d}ടിയ",
                "മ\u{d42}ടൽമഞ\u{d4d}ഞ\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("манантай"),
            keywords: &["манан", "манантай", "цаг агаар"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("ध\u{941}क\u{947} असल\u{947}ल\u{947}"),
            keywords: &["ध\u{941}क\u{947}", "ध\u{941}क\u{947} असल\u{947}ल\u{947}"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("berkabus"),
            keywords: &["berkabus", "cuaca", "kabus"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("imċajpar"),
            keywords: &["imċajpar", "ċpar"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("မြ\u{1030}အ\u{102f}\u{1036}\u{1037}ဆ\u{102d}\u{102f}င\u{103a}းသော"),
            keywords: &[
                "မြ\u{1030}",
                "မြ\u{1030}အ\u{102f}\u{1036}\u{1037}ဆ\u{102d}\u{102f}င\u{103a}းသော",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("tåkete"),
            keywords: &["tåke", "tåkete", "vær"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("ह\u{941}स\u{94d}स\u{941} लाग\u{947}को"),
            keywords: &[
                "ह\u{941}स\u{94d}स\u{941}",
                "ह\u{941}स\u{94d}स\u{941} लाग\u{947}को",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("mistig"),
            keywords: &["mist", "mistig"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("tåkete"),
            keywords: &["tåke", "tåkete", "vêr"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("କ\u{b41}ହ\u{b41}ଡ\u{b3c}\u{b3f}ଆ"),
            keywords: &[
                "କ\u{b41}ହ\u{b41}ଡ\u{b3c}\u{b3f}",
                "କ\u{b41}ହ\u{b41}ଡ\u{b3c}\u{b3f}ଆ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਧ\u{a41}\u{a70}ਦਲਾ"),
            keywords: &["ਧ\u{a41}\u{a70}ਦ", "ਧ\u{a41}\u{a70}ਦਲਾ", "ਮ\u{a4c}ਸਮ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("د\u{64f}ھندلا"),
            keywords: &["د\u{64f}ھندلا", "دھ\u{64f}ند"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Tík Klaud Wé Nọ\u{301} De Grí Pẹ\u{301}sin Sí Rod Wẹl"),
            keywords: &[
                "Fọg",
                "Tík Klaud",
                "Tík Klaud Wé Nọ\u{301} De Grí Pẹ\u{301}sin Sí Rod Wẹl",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("zamglenie"),
            keywords: &["mglisto", "mgła", "pogoda", "zamglenie", "zamglone"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("دهند"),
            keywords: &["خوپه", "دهند"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("enevoado"),
            keywords: &["bruma", "enevoado", "neblina", "nevoeiro", "névoa"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["enevoado", "nevoeiro", "nublado"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("kamanchaka"),
            keywords: &["kamanchaka", "pukutay"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("încețoșat"),
            keywords: &["ceață", "vreme", "încețoșat"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-200"),
            keywords: &["E10-200"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("туман"),
            keywords: &["дымка", "нечетко", "неясно", "облака", "туман", "туманно"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("kiganjemo igihu"),
            keywords: &["ibihu", "kiganjemo igihu"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("دهند"),
            keywords: &["دهند", "ماڪ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ම\u{dd3}ද\u{dd4}ම\u{dd2}න\u{dca} වැස\u{dd4}ණ"),
            keywords: &[
                "ක\u{dcf}ලග\u{dd4}ණය",
                "ම\u{dd3}ද\u{dd4}ම\u{dd2}න\u{dca} වැස\u{dd4}ණ",
                "ව\u{dd3}ද\u{dd4}ම",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("hmlisto"),
            keywords: &["hmla", "hmlisto", "počasie"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("megleno"),
            keywords: &["megla", "megleno", "vreme"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("ciryaamo leh"),
            keywords: &["ciiryaamo", "ciiryaamo leh", "ciryaamo leh"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("me mjegull"),
            keywords: &["me mjegull", "mjegull", "moti"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("магловито"),
            keywords: &["мaглa", "магловито"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["магловито"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("maglovito"),
            keywords: &["magla", "maglovito"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["maglovito"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("dimmigt"),
            keywords: &["dimma", "dimmigt"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mandhari yenye ukungu"),
            keywords: &["hali ya hewa", "mandhari yenye ukungu"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பனிமூட\u{bcd}டம\u{bcd}"),
            keywords: &[
                "பனிப\u{bcd}புகை",
                "பனிமூட\u{bcd}டம\u{bcd}",
                "வெண\u{bcd}புகை",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ప\u{c4a}గ రూపంల\u{c4b}న\u{c3f} మంచు"),
            keywords: &["ప\u{c4a}గ", "ప\u{c4a}గ రూపంల\u{c4b}న\u{c3f} మంచు", "మంచు"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("тумандор"),
            keywords: &["туман", "тумандор"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("หมอกลง"),
            keywords: &["หมอก", "หมอกลง"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ümürli"),
            keywords: &["ümür", "ümürli"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("fuʻukakapu"),
            keywords: &["fuʻukakapu"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("sisli"),
            keywords: &["sis", "sisli"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("تۇمانلىق"),
            keywords: &["تۇمان", "تۇمانلىق"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("туманно"),
            keywords: &["погода", "туман", "туманно"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ک\u{64f}ہر آلود"),
            keywords: &["دھند", "موسم", "ک\u{64f}ہر آلود"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("tumanli"),
            keywords: &["ob-havo", "tuman", "tumanli"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("có sương"),
            keywords: &["có sương", "thời tiết"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("lay"),
            keywords: &["ab lay", "lay"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("kunenkungu"),
            keywords: &["inkungu", "kunenkungu"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ojuju"),
            keywords: &["Ojuju", "kùrukùru"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("有霧"),
            keywords: &["大霧", "有霧"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("有雾"),
            keywords: &["大雾", "有雾"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("有雾"),
            keywords: &["有雾", "雾", "霾"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("霧"),
            keywords: &["天氣", "霧"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["有霧", "霧"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("kunezinkungu"),
            keywords: &["isimo sezulu", "izinkungu", "kunezinkungu"],
        },
    ],
};
#[doc = "🌃"]
pub const NIGHT_WITH_STARS: crate::Emoji = crate::Emoji {
    glyph: "🌃",
    codepoint: "1F303",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "night with stars",
    group: "Travel & Places",
    subgroup: "place-other",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("nag met sterre"),
            keywords: &["nag", "nag met sterre", "stad", "ster", "weer"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ከዋክብት ያሉበት ለሊት"),
            keywords: &["ሌሊት", "ከዋክብት ያሉበት ለሊት", "ኮከብ", "የአየር ንብረት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("\u{202b}ليل مع نجوم"),
            keywords: &["طقس", "ليل", "\u{202b}ليل مع نجوم"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("তৰ\u{9be}ৰে ভৰি থক\u{9be} ৰ\u{9be}তি"),
            keywords: &[
                "তৰ\u{9be}",
                "তৰ\u{9be}ৰে ভৰি থক\u{9be} ৰ\u{9be}তি",
                "ৰ\u{9be}তি",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("ulduzlu gecə"),
            keywords: &["axşam", "hava", "ulduz", "ulduzlu gecə"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("зорная ноч"),
            keywords: &["зорка", "зорная ноч", "надвор’е", "ноч"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Звездна нощ"),
            keywords: &["Звездна нощ", "време", "звезда", "нощ"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ত\u{9be}র\u{9be} ভর\u{9be} র\u{9be}ত"),
            keywords: &[
                "আবহ\u{9be}ওয\u{9bc}\u{9be}",
                "ত\u{9be}র\u{9be}",
                "ত\u{9be}র\u{9be} ভর\u{9be} র\u{9be}ত",
                "র\u{9be}ত",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("stergann"),
            keywords: &["noz", "stered", "stergann"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("zvjezdana noć"),
            keywords: &["noć", "vrijeme", "zvijezda", "zvjezdana noć"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("nit estrellada"),
            keywords: &["estrelles", "nit", "nit estrellada"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᏒᏗᏜ ᏃᏈᏏ"),
            keywords: &["ᎤᏒᎢ", "ᎤᏒᏗᏜ ᏃᏈᏏ", "ᏃᏈᏏ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("hvězdná noc"),
            keywords: &["hvězda", "hvězdná noc", "noc", "počasí"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("noson â sêr"),
            keywords: &["nos", "noson â sêr", "seren"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("stjernehimmel"),
            keywords: &["nat", "stjernehimmel", "stjerner"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Sternenhimmel"),
            keywords: &["Nacht", "Sterne", "Sternenhimmel"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("έναστρη νύχτα"),
            keywords: &["έναστρη νύχτα", "αστέρι", "νύχτα"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("night with stars"),
            keywords: &["night", "night with stars", "star"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("noche estrellada"),
            keywords: &["estrellas", "noche", "noche estrellada"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("öine tähistaevas"),
            keywords: &["ilm", "täht", "öine tähistaevas", "öö"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("gaua eta izarrak"),
            keywords: &["eguraldi", "gau", "gaua eta izarrak", "izar"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("شب پرستاره"),
            keywords: &["آسمان شب", "ستاره", "شب", "شب پرستاره"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("tähtitaivas"),
            keywords: &["sää", "tähti", "tähtitaivas", "yö"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("gabing maraming bituin"),
            keywords: &[
                "bituin",
                "cityscape",
                "gabi",
                "gabing maraming bituin",
                "lungsod",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("nátt við stjørnum"),
            keywords: &["kvøld", "nátt", "nátt við stjørnum", "stjørnur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("nuit étoilée"),
            keywords: &["nuit", "nuit étoilée", "étoiles"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["nuit", "étoiles", "étoilée"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("oíche le réaltaí"),
            keywords: &["oíche", "oíche le réaltaí", "réalta", "réaltaí"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("oidhche rionnagach"),
            keywords: &["oidhche", "oidhche rionnagach", "rionnag"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("noite estrelada"),
            keywords: &[
                "cidade",
                "estrelas",
                "meteoroloxía",
                "noite",
                "noite estrelada",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("તારા સાથ\u{ac7}ન\u{ac1}\u{a82} આકાશ"),
            keywords: &[
                "તારા",
                "તારા સાથ\u{ac7}ન\u{ac1}\u{a82} આકાશ",
                "રાત",
                "રાતના તારા",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("dare mai taurari"),
            keywords: &["dare", "dare mai taurari", "tauraro"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("לילה עם כוכבים"),
            keywords: &["בניינים", "גורדי שחקים", "לילה", "לילה עם כוכבים", "עיר"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("रात क\u{947} तार\u{947}, तार\u{947}, रात"),
            keywords: &[
                "तार\u{947}",
                "रात",
                "रात क\u{947} तार\u{947}",
                "रात क\u{947} तार\u{947}, तार\u{947}, रात",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("zvjezdana noć"),
            keywords: &["noć", "vrijeme", "zvijezde", "zvjezdana noć"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("éjszaka csillagokkal"),
            keywords: &["csillag", "derült idő", "éjszaka", "éjszaka csillagokkal"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("աստղազարդ գիշեր"),
            keywords: &["աստղ", "աստղազարդ գիշեր", "գիշեր", "եղանակ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("malam berbintang"),
            keywords: &["bintang", "cuaca", "malam", "malam berbintang"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("abalị nwere kpakpando"),
            keywords: &["abalị", "abalị nwere kpakpando", "kpakpando"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("stjörnuhiminn"),
            keywords: &["næturhiminn", "nótt", "stjörnuhiminn", "stjörnur"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("notte stellata"),
            keywords: &["notte", "notte stellata", "stelle"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("夜の都会"),
            keywords: &["夜", "夜の都会", "夜景", "星"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("bengi ana lintang"),
            keywords: &["bengi", "bengi ana lintang", "lintang"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ღამე ვარსკვლავებით"),
            keywords: &["ამინდი", "ვარსკვლავი", "ღამე", "ღამე ვარსკვლავებით"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("iḍ s itran"),
            keywords: &["iḍ s itran"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("жұлдызды түн"),
            keywords: &["ауа райы", "жұлдыз", "жұлдызды түн", "түн"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("stjernehimmel"),
            keywords: &["stjernehimmel", "stjerner"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("រាត\u{17d2}រ\u{17b8}មានផ\u{17d2}កាយរះ"),
            keywords: &[
                "ព\u{17d2}រះខែ",
                "យប\u{17cb}",
                "រាត\u{17d2}រ\u{17b8}",
                "រាត\u{17d2}រ\u{17b8}មានផ\u{17d2}កាយរះ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ನಕ\u{ccd}ಷತ\u{ccd}ರ ತುಂಬ\u{cbf}ದ ರಾತ\u{ccd}ರ\u{cbf}"),
            keywords: &[
                "ನಕ\u{ccd}ಷತ\u{ccd}ರ ತುಂಬ\u{cbf}ದ ರಾತ\u{ccd}ರ\u{cbf}",
                "ನಕ\u{ccd}ಷತ\u{ccd}ರಗಳು",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("밤하늘 별"),
            keywords: &["밤하늘 별", "야경"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("नख\u{947}त\u{94d}रा\u{902}ची रात"),
            keywords: &[
                "नख\u{947}त\u{94d}र",
                "नख\u{947}त\u{94d}रा\u{902}ची रात",
                "रात",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("жылдыздуу түн"),
            keywords: &["аба ырайы", "жылдыз", "жылдыздуу түн", "түн"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Stärenhimmel"),
            keywords: &["Himmel", "Nuecht", "Stär", "Stärenhimmel"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ກາງຄ\u{eb7}ນທ\u{eb5}\u{ec8}ມ\u{eb5}ດາວ"),
            keywords: &[
                "ກາງຄ\u{eb7}ນ",
                "ກາງຄ\u{eb7}ນທ\u{eb5}\u{ec8}ມ\u{eb5}ດາວ",
                "ດາວ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("žvaigždėta naktis"),
            keywords: &["naktis", "žvaigždė", "žvaigždėta naktis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("zvaigžņota debess"),
            keywords: &["nakts", "zvaigzne", "zvaigžņota debess"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pō whai whetū"),
            keywords: &["pō", "pō whai whetū", "whetū"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("ноќ со ѕвезди"),
            keywords: &["време", "ноќ", "ноќ со ѕвезди", "ѕвезди"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("നക\u{d4d}ഷത\u{d4d}രങ\u{d4d}ങൾ നിറഞ\u{d4d}ഞ ര\u{d3e}ത\u{d4d}രി"),
            keywords: &[
                "നക\u{d4d}ഷത\u{d4d}രം",
                "നക\u{d4d}ഷത\u{d4d}രങ\u{d4d}ങൾ",
                "നക\u{d4d}ഷത\u{d4d}രങ\u{d4d}ങൾ നിറഞ\u{d4d}ഞ ര\u{d3e}ത\u{d4d}രി",
                "ര\u{d3e}ത\u{d4d}രി",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("одтой шөнө"),
            keywords: &["од", "одтой шөнө", "шөнө"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("चा\u{902}दणी रात\u{94d}र"),
            keywords: &["चा\u{902}दणी रात\u{94d}र", "तार\u{947}", "रात\u{94d}र"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("malam berbintang"),
            keywords: &["bintang", "cuaca", "malam", "malam berbintang"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("lejl bl-istilel"),
            keywords: &["bil-lejl", "lejl bl-istilel", "stilla"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ကြယ\u{103a}များလင\u{103a}းသည\u{1037}\u{103a} ည"),
            keywords: &[
                "ကြယ\u{103a}",
                "ကြယ\u{103a}များလင\u{103a}းသည\u{1037}\u{103a} ည",
                "ည",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("stjernenatt"),
            keywords: &["natt", "stjernenatt", "stjerner"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("ताराहर\u{942} चम\u{94d}क\u{947}को रात"),
            keywords: &["तारा", "ताराहर\u{942} चम\u{94d}क\u{947}को रात", "रात"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("sterrenhemel"),
            keywords: &["nacht", "sterren", "sterrenhemel"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("stjernenatt"),
            keywords: &["natt", "stjernenatt", "stjerner"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ତ\u{b3e}ର\u{b3e} ଗହଣରେ ର\u{b3e}ତ\u{b3f}"),
            keywords: &[
                "ତ\u{b3e}ର\u{b3e}",
                "ତ\u{b3e}ର\u{b3e} ଗହଣରେ ର\u{b3e}ତ\u{b3f}",
                "ର\u{b3e}ତ\u{b3f}",
                "ର\u{b3e}ତ\u{b4d}ର ତ\u{b3e}ର\u{b3e}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਰਾਤੀ ਤਾਰ\u{a47}"),
            keywords: &[
                "ਤਾਰਿਆ\u{a02} ਵਾਲੀ ਰਾਤ",
                "ਤਾਰ\u{a47}",
                "ਰਾਤ",
                "ਰਾਤੀ ਤਾਰ\u{a47}",
                "ਰਾਤੀ\u{a02} ਤਾਰ\u{a47}",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ستاریاں نال رات"),
            keywords: &["تارہ", "رات", "ستاریاں نال رات"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Nait Wit Sta-dẹm"),
            keywords: &["Nait", "Nait Wit Sta-dẹm", "Sta"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("noc z gwiazdami"),
            keywords: &["gwiazdy", "noc z gwiazdami", "rozgwieżdżone niebo"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("شپه د ستورو سره"),
            keywords: &["ستوری", "شپه", "شپه د ستورو سره"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("noite estrelada"),
            keywords: &["estrelas", "noite", "noite estrelada"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("noite com estrelas"),
            keywords: &["estrelas", "noite", "noite com estrelas"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("tuta chʼaskakunawan"),
            keywords: &["ch’aska", "tuta", "tuta chʼaskakunawan"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("noapte înstelată"),
            keywords: &["noapte", "noapte înstelată", "stele"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-202"),
            keywords: &["E10-202"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("звездная ночь"),
            keywords: &["звездная ночь", "звезды", "ночь"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ijoro ririmo inyenyeri"),
            keywords: &["ijoro", "ijoro ririmo inyenyeri", "inyenyeri"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("تارن واري رات"),
            keywords: &["تارن واري رات", "تارو", "رات"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("තර\u{dd4} සහ\u{dd2}ත ර\u{dcf}ත\u{dca}\u{200d}ර\u{dd2}ය"),
            keywords: &[
                "ක\u{dcf}ලග\u{dd4}ණය",
                "තර\u{dd4} සහ\u{dd2}ත ර\u{dcf}ත\u{dca}\u{200d}ර\u{dd2}ය",
                "තර\u{dd4}ව",
                "ර\u{dcf}\u{dcf}ත\u{dca}\u{200d}ර\u{dd2}ය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("noc s hviezdami"),
            keywords: &["hviezda", "noc", "noc s hviezdami", "počasie"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("zvezdnata noč"),
            keywords: &["noč", "vreme", "zvezda", "zvezdnata noč"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("habbeenka xiddigaha"),
            keywords: &["habbeenka xiddigaha", "habeenka xiddigaha", "xiddig"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("natë me yje"),
            keywords: &["moti", "natë", "natë me yje", "yll"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("звездана ноћ"),
            keywords: &["звeздe", "звездана ноћ", "нoћ"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("звјездана ноћ"),
            keywords: &["звјездана ноћ"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("zvezdana noć"),
            keywords: &["noć", "zvezdana noć", "zvezde"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("zvjezdana noć"),
            keywords: &["zvjezdana noć"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("stjärnklar natt"),
            keywords: &["natt", "stjärnklar natt", "stjärnor"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("usiku wenye nyota"),
            keywords: &["hali ya hewa", "nyota", "usiku", "usiku wenye nyota"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some(
                "நட\u{bcd}சத\u{bcd}திரங\u{bcd}கள\u{bcd} மிளிரும\u{bcd} இரவு நேர வ\u{bbe}னம\u{bcd}",
            ),
            keywords: &[
                "இரவில\u{bcd} நட\u{bcd}சத\u{bcd}திரங\u{bcd}கள\u{bcd}",
                "இரவு",
                "நகரம\u{bcd}",
                "நட\u{bcd}சத\u{bcd}திரங\u{bcd}கள\u{bcd} மிளிரும\u{bcd} இரவு நேர வ\u{bbe}னம\u{bcd}",
                "நட\u{bcd}சத\u{bcd}திரம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("నక\u{c4d}షత\u{c4d}ర\u{c3e}లత\u{c4b} ర\u{c3e}త\u{c4d}ర\u{c3f}"),
            keywords: &[
                "నక\u{c4d}షత\u{c4d}రం",
                "నక\u{c4d}షత\u{c4d}ర\u{c3e}లత\u{c4b} ర\u{c3e}త\u{c4d}ర\u{c3f}",
                "ర\u{c3e}త\u{c4d}ర\u{c3f}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("шаби ситорадор"),
            keywords: &["ситора", "шаб", "шаби ситорадор"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ดาว"),
            keywords: &["กลางค\u{e37}น", "ดาว", "ดาวยามค\u{e48}ำค\u{e37}น"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ýyldyzly gije"),
            keywords: &["gije", "ýyldyz", "ýyldyzly gije"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("pō fetuʻuʻia"),
            keywords: &["pō fetuʻuʻia"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("yıldızlı gece"),
            keywords: &["gece", "yıldızlar", "yıldızlı gece"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("يۇلتۇزلۇق كېچە"),
            keywords: &["كېچە", "يۇلتۇز", "يۇلتۇزلۇق كېچە"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("зоряна ніч"),
            keywords: &["зоряна ніч", "зірка", "ніч", "погода"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ستاروں بھری رات"),
            keywords: &["رات", "ستاروں بھری رات", "ستارے", "موسم"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("yulduzli tun"),
            keywords: &["ob-havo", "tun", "yulduz", "yulduzli tun"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("đêm có sao"),
            keywords: &["sao", "đêm", "đêm có sao"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("guddi ak ay biddéew"),
            keywords: &["biddeew", "guddi", "guddi ak ay biddéew"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ubusuku obuneenkwenkwezi"),
            keywords: &["inkwenkwezi", "ubusuku", "ubusuku obuneenkwenkwezi"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Aṣalẹ Pẹlu Awọn Irawọ"),
            keywords: &["Aṣalẹ Pẹlu Awọn Irawọ", "alẹ\u{301}", "ìràwọ\u{300}"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("星夜"),
            keywords: &["夜晚", "星夜", "星星"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("星夜"),
            keywords: &["夜晚", "星夜", "星星"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("夜晚"),
            keywords: &["夜晚", "星空", "晚上"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("星空"),
            keywords: &["星夜", "星空"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["城市", "夜景", "天際線", "星空"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ubusuku obunezinkanyezi"),
            keywords: &["inkanyezi", "ubusuku", "ubusuku obunezinkanyezi"],
        },
    ],
};
#[doc = "🏙\u{fe0f}"]
pub const CITYSCAPE: crate::Emoji = crate::Emoji {
    glyph: "🏙\u{fe0f}",
    codepoint: "1F3D9 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.7f32,
    name: "cityscape",
    group: "Travel & Places",
    subgroup: "place-other",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🏙",
        codepoint: "1F3D9",
        status: crate::Status::Unqualified,
        introduction_version: 0.7f32,
        name: "cityscape",
        group: "Travel & Places",
        subgroup: "place-other",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("stadslandskap"),
            keywords: &["geboue", "stad", "stadslandskap"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የከተማ መልክዓ ምድር"),
            keywords: &["ሕንጻ", "ከተማ", "የከተማ መልክዓ ምድር"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("ناطحات سحاب"),
            keywords: &["مباني", "مدينة", "ناطحات سحاب"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("চিটীস\u{9cd}কেপ"),
            keywords: &["চহৰ", "চিটীস\u{9cd}কেপ"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("şəhər mənzərəsi"),
            keywords: &["bina", "şəhər", "şəhər mənzərəsi"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("гарадскі краявід"),
            keywords: &["будынкі", "гарадскі краявід", "горад"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("градски изглед"),
            keywords: &["град", "градски изглед", "сграда"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("সিটিস\u{9cd}কেপ"),
            keywords: &["শহর", "সিটিস\u{9cd}কেপ"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("gweledva kêr"),
            keywords: &["gweledva kêr", "kêr"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("pogled na grad"),
            keywords: &["grad", "pogled na grad", "zgrada"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("paisatge urbà"),
            keywords: &["paisatge", "urbà"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎦᏚᎲᎢ ᎠᏍᏛᎢ"),
            keywords: &["ᎦᏚᎲᎢ", "ᎦᏚᎲᎢ ᎠᏍᏛᎢ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("městská zástavba"),
            keywords: &[
                "budova",
                "krajina",
                "město",
                "městská",
                "městská zástavba",
                "silueta",
                "vyhlídka",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("dinaslun"),
            keywords: &["dinas", "dinaslun"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("bylandskab"),
            keywords: &["by", "bygning", "bylandskab"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Skyline"),
            keywords: &[
                "Gebäude",
                "Hochhäuser",
                "Häuser",
                "Skyline",
                "Stadt",
                "Wolkenkratzer",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("αστικό τοπίο"),
            keywords: &["αστικό τοπίο", "κτίριο", "περίγραμμα πόλης", "πόλη"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("cityscape"),
            keywords: &["city", "cityscape"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("paisaje urbano"),
            keywords: &["ciudad", "edificio", "paisaje", "paisaje urbano"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["ciudad", "edificios", "paisaje urbano"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("linna siluett"),
            keywords: &["linn", "linna siluett", "maja"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("hiri-paisaia"),
            keywords: &["eraikin", "hiri", "hiri-paisaia"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("نمای شهر"),
            keywords: &["شهر", "شهری", "منظره", "نما", "نمای شهر"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kaupunkimaisema"),
            keywords: &["kaupunki", "kaupunkimaisema", "rakennus"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("cityscape"),
            keywords: &["cityscape", "gusali", "lungsod"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("stórbýur"),
            keywords: &["býur", "stórbýur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("ville"),
            keywords: &["bâtiment", "ville"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("paysage urbain"),
            keywords: &["bâtiment", "paysage urbain", "ville"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("dreach cathrach"),
            keywords: &["cathair", "dreach cathrach", "foirgneamh"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("mòr-bhaile"),
            keywords: &["baile", "mòr-bhaile"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("paisaxe urbana"),
            keywords: &["cidade", "edificios", "paisaxe urbana"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("શહ\u{ac7}રી ઈમારતો"),
            keywords: &["શહ\u{ac7}ર", "શહ\u{ac7}રી ઈમારતો"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("ganowar birni"),
            keywords: &["birni", "ganowar birni"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("נוף עירוני"),
            keywords: &[
                "בניינים",
                "גורדי שחקים",
                "מבנים",
                "מגדלים",
                "נוף עירוני",
                "עיר",
            ],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("शहर का द\u{943}श\u{94d}य"),
            keywords: &["इमारत", "शहर", "शहर का द\u{943}श\u{94d}य"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("panorama grada"),
            keywords: &["grad", "panorama grada", "zgrada"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("városkép"),
            keywords: &["város", "városkép", "épületek"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("քաղաքի համայնապատկեր"),
            keywords: &["շենք", "քաղաք", "քաղաքի համայնապատկեր"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("panorama kota"),
            keywords: &["bangunan", "kota", "panorama kota"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("akaranhụcha obodo"),
            keywords: &["akaranhụcha obodo", "obodo"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("borgarlandslag"),
            keywords: &["borg", "borgarlandslag", "byggingar"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("paesaggio urbano"),
            keywords: &["città", "edifici", "grattacieli", "paesaggio urbano"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("高層ビル"),
            keywords: &["ビル群", "都会", "高層ビル"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("gedhung-gedhung anyakar mega"),
            keywords: &["gedhung-gedhung anyakar mega", "kutha"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ქალაქის ხედი"),
            keywords: &["ქალაქი", "ქალაქის ხედი", "შენობა"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("tamdint"),
            keywords: &["tamdint"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("қала көрінісі"),
            keywords: &["қала", "қала көрінісі", "құру"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("bylandskab"),
            keywords: &["by", "bygning", "bylandskab"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("អគារខ\u{17d2}ពស\u{17cb}ៗ"),
            keywords: &[
                "អគារ",
                "អគារខ\u{17d2}ពស\u{17cb}",
                "អគារខ\u{17d2}ពស\u{17cb}ៗ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ನಗರದೃಶ\u{ccd}ಯ"),
            keywords: &["ನಗರ", "ನಗರದೃಶ\u{ccd}ಯ", "ನಗರಸ\u{ccd}ಕೇಪ\u{ccd}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("도시 전경"),
            keywords: &["건물", "도시", "도시 전경"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("शारीवाठार"),
            keywords: &["शार", "शारीवाठार"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("шаар көрүнүшү"),
            keywords: &["имарат", "шаар", "шаар көрүнүшү"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Stadlandschaft"),
            keywords: &["Stad", "Stadlandschaft"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ພາບທ\u{eb4}ວທ\u{eb1}ດຂອງເມ\u{eb7}ອງ"),
            keywords: &[
                "ພາບທ\u{eb4}ວທ\u{eb1}ດ",
                "ພາບທ\u{eb4}ວທ\u{eb1}ດຂອງເມ\u{eb7}ອງ",
                "ອາຄານ",
                "ເມ\u{eb7}ອງ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("miesto vaizdas"),
            keywords: &["miestas", "miesto vaizdas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("pilsētas panorāma"),
            keywords: &["māja", "panorāma", "pilsēta", "pilsētas panorāma"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("ataata tāonenui"),
            keywords: &["ataata tāonenui", "tāonenui"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("градски пејзаж"),
            keywords: &["град", "градба", "градски пејзаж"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("നഗരം"),
            keywords: &["കെട\u{d4d}ടിടം", "നഗരം", "സിറ\u{d4d}റി"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("хот"),
            keywords: &["барилга", "хот"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("शहराच\u{947} द\u{943}श\u{94d}य"),
            keywords: &["शहर", "शहराच\u{947} द\u{943}श\u{94d}य"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("panorama kota"),
            keywords: &["bandar", "bangunan", "panorama kota"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("silwett tal-belt"),
            keywords: &["belt", "silwett tal-belt"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("မြ\u{102d}\u{102f}\u{1037}ပြရ\u{103e}\u{102f}ခင\u{103a}း"),
            keywords: &[
                "မြ\u{102d}\u{102f}\u{1037}",
                "မြ\u{102d}\u{102f}\u{1037}ပြရ\u{103e}\u{102f}ခင\u{103a}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("bylandskap"),
            keywords: &["by", "bylandskap"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("सिटिस\u{94d}क\u{947}प"),
            keywords: &["नगरको द\u{943}श\u{94d}य", "सहर", "सिटिस\u{94d}क\u{947}प"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("stadsgezicht"),
            keywords: &["stad", "stadsgezicht"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("bylandskap"),
            keywords: &["by", "bylandskap"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ସହରୀ ପର\u{b3f}ଦ\u{b43}ଶ\u{b4d}ୟ"),
            keywords: &["ସହର", "ସହରୀ ପର\u{b3f}ଦ\u{b43}ଶ\u{b4d}ୟ"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਉ\u{a71}ਚੀਆ\u{a02} ਇਮਾਰਤਾ\u{a02} ਦਾ ਦ\u{a4d}ਰਿਸ\u{a3c}"),
            keywords: &[
                "ਉ\u{a71}ਚੀਆ\u{a02}",
                "ਉ\u{a71}ਚੀਆ\u{a02} ਇਮਾਰਤਾ\u{a02} ਦਾ ਦ\u{a4d}ਰਿਸ\u{a3c}",
                "ਸ\u{a3c}ਹਿਰ",
                "ਸ\u{a3c}ਹਿਰੀ ਇਮਾਰਤਾ\u{a02}",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("شہر دا نظارہ"),
            keywords: &["شہر", "شہر دا نظارہ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Taun Píkchọ\u{301}"),
            keywords: &["Taun", "Taun Píkchọ\u{301}"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("drapacze chmur"),
            keywords: &["drapacze chmur", "miasto", "wieżowce"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د ښار منظره"),
            keywords: &["د ښار منظره", "ښار"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("cidade"),
            keywords: &["cidade", "prédios"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("paisagem urbana"),
            keywords: &["cidade", "edifícios", "paisagem urbana"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("paisaje llaqtapi"),
            keywords: &["llaqta", "paisaje llaqtapi"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("peisaj urban"),
            keywords: &["oraș", "orizont citadin", "peisaj urban", "zgârie-nori"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-409"),
            keywords: &["E10-409"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("ночной город"),
            keywords: &[
                "вечер",
                "город",
                "городской пейзаж",
                "ночной город",
                "ночь",
                "пейзаж",
                "темно",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("uko umujyi ugaragara"),
            keywords: &["uko umujyi ugaragara", "umujyi"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("شهر جو منظر"),
            keywords: &["شهر", "شهر جو منظر"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("නගරය"),
            keywords: &["ඉද\u{dd2} ක\u{dd2}ර\u{dd3}ම", "නගරය"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("mestská panoráma"),
            keywords: &["budova", "mesto", "mestská panoráma"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("mestna pokrajina"),
            keywords: &["mestna pokrajina", "mesto", "zgradba"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("muuqaal magaalo"),
            keywords: &["magaalo", "muuqaal magaalo"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("panoramë qyteti"),
            keywords: &["ndërtesë", "panoramë qyteti", "qytet"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("градски пејзаж"),
            keywords: &["грaд", "градски пејзаж"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["градски пејзаж"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("gradski pejzaž"),
            keywords: &["grad", "gradski pejzaž"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["gradski pejzaž"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("stadsbild"),
            keywords: &["höga hus", "skyskrapa", "stadsbild", "storstad"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mwonekano wa jiji"),
            keywords: &["jengo", "jiji", "mwonekano wa jiji"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("நகர அமைப\u{bcd}பு"),
            keywords: &["நகர அமைப\u{bcd}பு", "நகரம\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("నగర దృశ\u{c4d}యం"),
            keywords: &["నగర దృశ\u{c4d}యం", "నగరం", "భవనం"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("манзараи шаҳр"),
            keywords: &["манзараи шаҳр", "шаҳр"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("หม\u{e39}\u{e48}ต\u{e36}กส\u{e39}ง"),
            keywords: &[
                "ต\u{e36}กส\u{e39}ง",
                "หม\u{e39}\u{e48}ต\u{e36}กส\u{e39}ง",
                "เม\u{e37}อง",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("şäher görnüşi"),
            keywords: &["şäher", "şäher görnüşi"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("fale lalahi lotokolo"),
            keywords: &["fale lalahi lotokolo"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("şehir manzarası"),
            keywords: &["bina", "şehir", "şehir manzarası"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("شەھەر مەنزىرىسى"),
            keywords: &["شەھەر", "شەھەر مەنزىرىسى"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("міський краєвид"),
            keywords: &["будівля", "краєвид міста", "міський краєвид"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("اونچی عمارتیں"),
            keywords: &["اونچی عمارتیں", "شہر", "عمارت"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("shahar manzarasi"),
            keywords: &["bino", "shahar", "shahar manzarasi"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("khung cảnh thành phố"),
            keywords: &["khung cảnh thành phố", "thành phố"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("cityscape"),
            keywords: &["city", "cityscape"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("i-cityscape"),
            keywords: &["i-cityscape", "isixeko"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("fífẹ\u{300}ìlú"),
            keywords: &["fífẹ\u{300}ìlú", "ìlú"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("城市景色"),
            keywords: &["城市", "城市景色"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("城市景色"),
            keywords: &["城市", "城市景色"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("城市风光"),
            keywords: &["城市风光", "都市", "都市景观", "高楼大厦"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("都市風景"),
            keywords: &["城市", "都市風景"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("城市景觀"),
            keywords: &["城市", "城市景觀"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ukubukeka kwedolobha"),
            keywords: &["idolobha", "ukubukeka kwedolobha"],
        },
    ],
};
#[doc = "🌄"]
pub const SUNRISE_OVER_MOUNTAINS: crate::Emoji = crate::Emoji {
    glyph: "🌄",
    codepoint: "1F304",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "sunrise over mountains",
    group: "Travel & Places",
    subgroup: "place-other",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("sonsopkoms oor berge"),
            keywords: &[
                "berg",
                "oggend",
                "opkoms",
                "son",
                "sonsopkoms oor berge",
                "weer",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("በተራሮች አናት ላይ የምትወጣ ፀሐይ"),
            keywords: &["በተራሮች አናት ላይ የምትወጣ ፀሐይ", "ተራራ", "የአየር ንብረት", "ጠዋት", "ፀሐይ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("شروق على جبل"),
            keywords: &["شروق على جبل", "شمس الصباح"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("পৰ\u{9cd}ব\u{9cd}বতৰ ওপৰত স\u{9c2}ৰ\u{9cd}যোদয\u{9bc}"),
            keywords: &[
                "পৰ\u{9cd}ব\u{9cd}বত",
                "পৰ\u{9cd}ব\u{9cd}বতৰ ওপৰত স\u{9c2}ৰ\u{9cd}যোদয\u{9bc}",
                "স\u{9c2}ৰ\u{9cd}যোদয\u{9bc}",
                "স\u{9c2}ৰ\u{9cd}য\u{9cd}য",
                "ৰ\u{9be}তিপ\u{9c1}ৱ\u{9be}",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("dağlardan qalxan günəş"),
            keywords: &[
                "dağ",
                "dağlardan qalxan günəş",
                "günəş",
                "günəşin doğması",
                "hava",
                "səhər",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("узыход сонца над гарамі"),
            keywords: &[
                "гара",
                "надвор’е",
                "раніца",
                "сонца",
                "узыход сонца над гарамі",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("изгрев над планини"),
            keywords: &[
                "изгрев",
                "изгрев над планини",
                "планина",
                "слънце",
                "сутрин",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("পর\u{9cd}বতের উপর স\u{9c2}র\u{9cd}যোদয\u{9bc}"),
            keywords: &[
                "আবহ\u{9be}ওয\u{9bc}\u{9be}",
                "পর\u{9cd}বত",
                "পর\u{9cd}বতের উপর স\u{9c2}র\u{9cd}যোদয\u{9bc}",
                "সক\u{9be}ল",
                "স\u{9c2}র\u{9cd}য",
                "স\u{9c2}র\u{9cd}যোদয\u{9bc}",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("sav-heol war ar menezioù"),
            keywords: &[
                "beure",
                "heol",
                "menez",
                "mintin",
                "sav-heol",
                "sav-heol war ar menezioù",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("izlazak sunca preko planina"),
            keywords: &[
                "izlazak sunca",
                "izlazak sunca preko planina",
                "jutro",
                "planina",
                "sunce",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("alba sobre les muntanyes"),
            keywords: &["alba sobre les muntanyes", "muntanyes", "sortida del sol"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᎩᏥᏍᎬ ᎦᏚ ᏚᏙᏓᎸ"),
            keywords: &["ᎣᏓᎳ", "ᎤᎩᏥᏍᎬ", "ᎤᎩᏥᏍᎬ ᎦᏚ ᏚᏙᏓᎸ", "ᏅᏓ ᎢᎦ ᎡᎯ", "ᏑᎾᏉᎢ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("svítání nad horami"),
            keywords: &[
                "hora",
                "počasí",
                "ráno",
                "slunce",
                "svítání",
                "svítání nad horami",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("codiad haul dros fynyddoedd"),
            keywords: &[
                "bore",
                "codiad",
                "codiad haul dros fynyddoedd",
                "haul",
                "mynydd",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("solopgang over bjerge"),
            keywords: &["bjerge", "morgensol", "solopgang over bjerge"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Sonnenaufgang über Bergen"),
            keywords: &["Berge", "Sonnenaufgang", "Sonnenaufgang über Bergen"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("αυγή πίσω από βουνά"),
            keywords: &["ήλιος", "αυγή", "αυγή πίσω από βουνά", "βουνό", "πρωί"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("sunrise over mountains"),
            keywords: &[
                "morning",
                "mountain",
                "sun",
                "sunrise",
                "sunrise over mountains",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("amanecer sobre montañas"),
            keywords: &[
                "amanecer",
                "amanecer sobre montañas",
                "montaña",
                "salida",
                "sol",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("amanecer en las montañas"),
            keywords: &[
                "amanecer",
                "amanecer en las montañas",
                "atardecer",
                "montaña",
                "sol",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("päikesetõus mägedes"),
            keywords: &[
                "hommik",
                "ilm",
                "mägi",
                "päike",
                "päikesetõus",
                "päikesetõus mägedes",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("egunsentia mendien artean"),
            keywords: &[
                "egunsenti",
                "egunsentia mendien artean",
                "eguraldi",
                "eguzki",
                "goiz",
                "mendi",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("طلوع در کوهستان"),
            keywords: &[
                "بامداد",
                "خورشید",
                "صبح",
                "طلوع",
                "طلوع در کوهستان",
                "کوه",
                "کوهستان",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("auringonnousu vuorten takaa"),
            keywords: &["aamu", "auringonnousu vuorten takaa", "aurinko", "sää"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("pagsikat ng araw sa mga bundok"),
            keywords: &[
                "araw",
                "bundok",
                "pagsikat ng araw",
                "pagsikat ng araw sa mga bundok",
                "umaga",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("sólarris ímillum fjøll"),
            keywords: &[
                "fjall",
                "fjøll",
                "morgun",
                "sól",
                "sólarris",
                "sólarris ímillum fjøll",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("soleil levant derrière les montagnes"),
            keywords: &["soleil", "soleil levant derrière les montagnes"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("lever de soleil sur les montagnes"),
            keywords: &[
                "lever",
                "lever de soleil sur les montagnes",
                "montagnes",
                "soleil",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("éirí na gréine thar na sléibhte"),
            keywords: &[
                "grian na maidine",
                "sliabh",
                "éirí na gréine",
                "éirí na gréine ar shléibhte",
                "éirí na gréine thar na sléibhte",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("èirigh na grèine thar bheanntan"),
            keywords: &[
                "beinn",
                "camhanaich",
                "grian",
                "madainn",
                "èirigh na grèine",
                "èirigh na grèine thar bheanntan",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("amencer sobre as montañas"),
            keywords: &[
                "amencer",
                "amencer sobre as montañas",
                "meteoroloxía",
                "montañas",
                "sol",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("પર\u{acd}વતો પર સ\u{ac2}ર\u{acd}યોદય"),
            keywords: &[
                "પર\u{acd}વત",
                "પર\u{acd}વતો પર સ\u{ac2}ર\u{acd}યોદય",
                "સવારનો સ\u{ac2}ર\u{acd}ય",
                "સ\u{ac2}ર\u{acd}યોદય",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("fitowar rana bisa tsaunuka"),
            keywords: &[
                "fitowar rana",
                "fitowar rana bisa tsaunuka",
                "rana",
                "safiya",
                "tsauni",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("זריחה בהרים"),
            keywords: &["בוקר", "הרים", "זריחה", "זריחה בהרים"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("पहाड\u{93c} क\u{947} ऊपर स\u{942}र\u{94d}योदय"),
            keywords: &[
                "पहाड\u{93c}",
                "पहाड\u{93c} क\u{947} ऊपर स\u{942}र\u{94d}योदय",
                "पहाड\u{93c} म\u{947}\u{902} स\u{942}र\u{94d}योदय",
                "स\u{941}प\u{94d}रभात",
                "स\u{941}बह का स\u{942}र\u{94d}य",
                "स\u{942}र\u{94d}योदय",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("izlazak sunca iznad planina"),
            keywords: &[
                "izlazak sunca iznad planina",
                "jutro",
                "planina",
                "sunce",
                "vrijeme",
                "zora",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("hegyek mögött felkelő nap"),
            keywords: &["hegyek", "hegyek mögött felkelő nap", "nap", "napfelkelte"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("արևածագը լեռներում"),
            keywords: &[
                "առավոտ",
                "արև",
                "արևածագ",
                "արևածագը լեռներում",
                "եղանակ",
                "լեռ",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("matahari terbit di antara gunung"),
            keywords: &[
                "cuaca",
                "gunung",
                "matahari",
                "matahari terbit di antara gunung",
                "pagi",
                "terbit",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ọwụwa anyanwụ n’elu ugwu"),
            keywords: &[
                "anyanwụ",
                "ugwu",
                "ọwụwa anyanwụ",
                "ọwụwa anyanwụ n’elu ugwu",
                "ụtụtụ",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("sólarupprás yfir fjöllum"),
            keywords: &[
                "fjall",
                "morgunsól",
                "sól kemur upp",
                "sólarupprás yfir fjöllum",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("alba sulle montagne"),
            keywords: &["alba sulle montagne", "sole che sorge"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("山から日の出"),
            keywords: &["ご来光", "太陽", "山から日の出", "日の出", "朝", "朝日"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("srengenge mlethek sadhuwuring kendheng"),
            keywords: &[
                "esuk",
                "gunung",
                "srengenge",
                "srengenge mlethek",
                "srengenge mlethek sadhuwuring kendheng",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მზის ამოსვლა მთებში"),
            keywords: &[
                "ამინდი",
                "დილა",
                "მზე",
                "მზის ამოსვლა",
                "მზის ამოსვლა მთებში",
                "მთა",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("таулардың артынан шыққан күн"),
            keywords: &[
                "күн",
                "күн шығысы",
                "тау",
                "таулардың артынан шыққан күн",
                "таңертең",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("solopgang over bjerge"),
            keywords: &["bjerge", "morgensol", "solopgang over bjerge"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ព\u{17d2}រះអាទ\u{17b7}ត\u{17d2}យលើក\u{17c6}ព\u{17bc}លភ\u{17d2}ន\u{17c6}"),
            keywords: &[
                "ថ\u{17d2}ងៃរះ",
                "ពេលព\u{17d2}រ\u{17b9}ក",
                "ព\u{17d2}រះអាទ\u{17b7}ត\u{17d2}យ",
                "ព\u{17d2}រះអាទ\u{17b7}ត\u{17d2}យលើក\u{17c6}ព\u{17bc}លភ\u{17d2}ន\u{17c6}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಪರ\u{ccd}ವತಗಳ ಮೇಲ\u{cc6} ಸ\u{cc2}ರ\u{ccd}ಯೋದಯ"),
            keywords: &[
                "ಪರ\u{ccd}ವತಗಳ ಮೇಲ\u{cc6} ಸ\u{cc2}ರ\u{ccd}ಯೋದಯ",
                "ಬ\u{cc6}ಳಗ\u{cbf}ನ ಸ\u{cc2}ರ\u{ccd}ಯ",
                "ಸ\u{cc2}ರ\u{ccd}ಯೋದಯ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("산에서 떠오르는 해"),
            keywords: &[
                "산",
                "산에 해가 뜸",
                "산에서 떠오르는 해",
                "아침 해",
                "해",
                "해가 뜸",
            ],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("पर\u{94d}वता फाटलो स\u{941}र\u{94d}योदय"),
            keywords: &[
                "पर\u{94d}वत",
                "पर\u{94d}वता फाटलो स\u{941}र\u{94d}योदय",
                "पर\u{94d}वता फाटल\u{94d}यान जावपी स\u{941}र\u{94d}योदय",
                "सकाळ",
                "स\u{941}र\u{94d}य",
                "स\u{941}र\u{94d}योदय",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("күндүн тоодон чыгышы"),
            keywords: &["күн", "күндүн тоодон чыгышы", "күндүн чыгышы", "таң", "тоо"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Sonnenopgang an de Bierger"),
            keywords: &[
                "Bierg",
                "Moien",
                "Sonn",
                "Sonnenopgang",
                "Sonnenopgang an de Bierger",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຕາເວ\u{eb1}ນຜ\u{ec8}ານພ\u{eb9}ເຂ\u{ebb}າ"),
            keywords: &[
                "ຕາເວ\u{eb1}ນ",
                "ຕາເວ\u{eb1}ນຜ\u{ec8}ານພ\u{eb9}ເຂ\u{ebb}າ",
                "ພ\u{eb9}ເຂ\u{ebb}າ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("saulėtekis virš kalnų"),
            keywords: &[
                "kalnas",
                "rytas",
                "saulė",
                "saulėtekis",
                "saulėtekis virš kalnų",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("saullēkts pār kalniem"),
            keywords: &[
                "kalns",
                "rīts",
                "saule",
                "saullēkts",
                "saullēkts pār kalniem",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("whitinga rā runga maunga"),
            keywords: &[
                "ata",
                "maunga",
                "rā",
                "rā whiti",
                "whitinga rā runga maunga",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("изгрејсонце над планините"),
            keywords: &[
                "време",
                "изгрејсонце",
                "изгрејсонце над планините",
                "планина",
                "сонце",
                "утро",
            ],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("മലമ\u{d41}കളിലെ സ\u{d42}ര\u{d4d}യോദയം"),
            keywords: &[
                "പ\u{d4d}രഭ\u{d3e}തം",
                "മല",
                "മലമ\u{d41}കളിലെ സ\u{d42}ര\u{d4d}യോദയം",
                "സ\u{d42}ര\u{d4d}യോദയം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("уулын толгод дээгүүр нар мандах"),
            keywords: &[
                "дээгүүр",
                "мандах",
                "нар",
                "толгод",
                "уул",
                "уулын толгод дээгүүр нар мандах",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("डो\u{902}गरात\u{942}न उगवणारा स\u{942}र\u{94d}य"),
            keywords: &[
                "डो\u{902}गर",
                "डो\u{902}गरात\u{942}न उगवणारा स\u{942}र\u{94d}य",
                "डो\u{902}गरावरील स\u{942}र\u{94d}योदय",
                "सकाळ",
                "स\u{942}र\u{94d}य",
                "स\u{942}र\u{94d}योदय",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("matahari terbit di banjaran pergunungan"),
            keywords: &[
                "gunung",
                "matahari terbit",
                "matahari terbit di banjaran pergunungan",
                "pagi",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("tlugħ ix-xemx fuq il-muntanji"),
            keywords: &[
                "filgħodu",
                "muntanja",
                "tlugħ ix-xemx",
                "tlugħ ix-xemx fuq il-muntanji",
                "xemx",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("တောင\u{103a}ကြောပေါ\u{103a}မ\u{103e}ာ နေထ\u{103d}က\u{103a}ခြင\u{103a}း"),
            keywords: &[
                "တောင\u{103a}",
                "တောင\u{103a}ကြောပေါ\u{103a}မ\u{103e} နေထ\u{103d}က\u{103a}ခြင\u{103a}း",
                "တောင\u{103a}ကြောပေါ\u{103a}မ\u{103e}ာ နေထ\u{103d}က\u{103a}ခြင\u{103a}း",
                "နေ",
                "နေထ\u{103d}က\u{103a}ခြင\u{103a}း",
                "န\u{1036}နက\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("soloppgang over fjell"),
            keywords: &[
                "fjell",
                "fjellsol",
                "morgen",
                "morgensol",
                "sol",
                "soloppgang over fjell",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("पर\u{94d}वतहर\u{942}मा स\u{942}र\u{94d}योदय"),
            keywords: &[
                "पर\u{94d}वत",
                "पर\u{94d}वतहर\u{942}मा स\u{942}र\u{94d}योदय",
                "बिहानी",
                "स\u{942}र\u{94d}य",
                "स\u{942}र\u{94d}योदय",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("zonsopgang in de bergen"),
            keywords: &[
                "berg",
                "ochtend",
                "zon",
                "zonsopgang",
                "zonsopgang in de bergen",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("soloppgang over fjell"),
            keywords: &[
                "fjell",
                "fjellsol",
                "morgon",
                "morgonsol",
                "sol",
                "soloppgang over fjell",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ପର\u{b4d}ବତମ\u{b3e}ଳ\u{b3e}ରେ ସ\u{b42}ର\u{b4d}ଯ\u{b4d}ୟୋଦୟ"),
            keywords: &[
                "ପର\u{b4d}ବତମ\u{b3e}ଳ\u{b3e}ରେ ସ\u{b42}ର\u{b4d}ଯ\u{b4d}ୟୋଦୟ",
                "ପ\u{b3e}ହ\u{b3e}ଡ\u{b3c}",
                "ପ\u{b3e}ହ\u{b3e}ଡ\u{b3c} ଉପରେ ସ\u{b42}ର\u{b4d}ଯ\u{b4d}ୟଉଦୟ",
                "ସଖ\u{b3e}ଳ\u{b41}ଆ ସ\u{b42}ର\u{b4d}ଯ\u{b4d}ୟ",
                "ସ\u{b42}ର\u{b4d}ଯ\u{b4d}ୟଉଦୟ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਪਹਾੜਾ\u{a02} ਵਿ\u{a71}\u{a71}ਚ ਚੜ\u{a4d}ਹਦਾ ਸ\u{a42}ਰਜ"),
            keywords: &[
                "ਪਹਾੜ",
                "ਪਹਾੜਾ\u{a02} ਦੀ ਸਵ\u{a47}ਰ",
                "ਪਹਾੜਾ\u{a02} ਵਿ\u{a71}\u{a71}ਚ ਚੜ\u{a4d}ਹਦਾ ਸ\u{a42}ਰਜ",
                "ਮ\u{a4c}ਸਮ",
                "ਸਵ\u{a47}ਰ",
                "ਸਵ\u{a47}ਰ\u{a47} ਸ\u{a42}ਰਜ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("پہاڑاں اوتے سورج نکلنا"),
            keywords: &[
                "سورج",
                "سورج نکلنا",
                "صبح",
                "پہاڑ",
                "پہاڑاں اوتے سورج نکلنا",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Sọn As I De Kọmọ\u{301}t Ọn Tọ\u{301}p Maúntin"),
            keywords: &[
                "Di Taim Wé Sọn De Kọmọt",
                "Maúntin",
                "Mọ\u{301}nin",
                "Sọn",
                "Sọn As I De Kọmọ\u{301}t Ọn Tọ\u{301}p Maúntin",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("wschód słońca zza gór"),
            keywords: &["góry", "ranek", "słońce", "wschód", "wschód słońca zza gór"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("په غرونو کې لمر"),
            keywords: &["سهار", "غر", "لمر", "لمر راختل", "په غرونو کې لمر"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("aurora sobre montanhas"),
            keywords: &[
                "aurora sobre montanhas",
                "montanha",
                "nascer do sol sobre as montanhas",
                "sol da manhã",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("nascer do sol nas montanhas"),
            keywords: &[
                "manhã",
                "montanha",
                "nascer do sol",
                "nascer do sol nas montanhas",
                "sol",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("paqarin urqukunapura"),
            keywords: &["inti", "paqar", "paqarin", "paqarin urqukunapura", "urqu"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("răsărit după munți"),
            keywords: &[
                "dimineață",
                "munți",
                "răsărit",
                "răsărit după munți",
                "soare",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-203"),
            keywords: &["E10-203"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("восход солнца над горами"),
            keywords: &[
                "восход",
                "восход солнца над горами",
                "горы",
                "заря",
                "рассвет",
                "солнце",
                "утро",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("izuba rirasiye ku misozi"),
            keywords: &[
                "igitondo",
                "izuba",
                "izuba rirasiye ku misozi",
                "kurasa kw’izuba",
                "umusozi",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("جبلن مٿان سج اڀرندي"),
            keywords: &["جبل", "جبلن مٿان سج اڀرندي", "سج", "سج اڀرڻ", "صبح"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("කඳ\u{dd4}වලට ඉහළ\u{dd2}න\u{dca} හ\u{dd2}ර\u{dd4} නැග\u{dd3}ම"),
            keywords: &[
                "උදෑසන",
                "කන\u{dca}ද",
                "කඳ\u{dd4}වලට ඉහළ\u{dd2}න\u{dca} හ\u{dd2}ර\u{dd4} නැග\u{dd3}ම",
                "ක\u{dcf}ලග\u{dd4}ණය",
                "ස\u{dd6}ර\u{dca}යය\u{dcf}",
                "හ\u{dd2}ර\u{dd4} නැග\u{dd3}ම",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("východ slnka nad horami"),
            keywords: &[
                "hora",
                "počasie",
                "ráno",
                "slnko",
                "východ slnka",
                "východ slnka nad horami",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("sončni vzhod v gorah"),
            keywords: &[
                "gora",
                "jutro",
                "sonce",
                "sončni vzhod",
                "sončni vzhod v gorah",
                "vreme",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("qorrax ka soo baxa buuraha"),
            keywords: &[
                "buur",
                "qorrax",
                "qorrax ka soo baxa buuraha",
                "qorrax soo bax",
                "subax",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("lindja e diellit mbi male"),
            keywords: &[
                "diell",
                "lindja e diellit mbi male",
                "lindje dielli",
                "mëngjes",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("излазак сунца изнад планина"),
            keywords: &[
                "излазак сунца",
                "излазак сунца изнад планина",
                "планина",
                "сунце",
                "јутро",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["излазак сунца изнад планина"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("izlazak sunca iznad planina"),
            keywords: &[
                "izlazak sunca",
                "izlazak sunca iznad planina",
                "jutro",
                "planina",
                "sunce",
            ],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["izlazak sunca iznad planina"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("soluppgång över berg"),
            keywords: &[
                "berg",
                "morgonsol",
                "soluppgång",
                "soluppgång vid berg",
                "soluppgång över berg",
            ],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("macheo kwenye milima"),
            keywords: &[
                "asubuhi",
                "hali yahewa",
                "jua",
                "macheo",
                "macheo kwenye milima",
                "mlima",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &[
                "asubuhi",
                "hali ya hewa",
                "jua",
                "macheo",
                "macheo kwenye milima",
                "mlima",
            ],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("உதயசூரியன\u{bcd}"),
            keywords: &[
                "உதயசூரியன\u{bcd}",
                "க\u{bbe}லை வெயில\u{bcd}",
                "க\u{bbe}லைச\u{bcd}சூரியன\u{bcd}",
                "சூரியோதயம\u{bcd}",
                "மலை",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some(
                "పర\u{c4d}వత\u{c3e}ల మ\u{c40}దుగ\u{c3e} ఉదయ\u{c3f}స\u{c4d}తున\u{c4d}న సూర\u{c4d}యుడు",
            ),
            keywords: &[
                "పర\u{c4d}వతం",
                "పర\u{c4d}వత\u{c3e}ల మ\u{c40}దుగ\u{c3e} ఉదయ\u{c3f}స\u{c4d}తున\u{c4d}న సూర\u{c4d}యుడు",
                "సూర\u{c4d}యుడు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("Тулӯи офтоб аз болои куҳҳо"),
            keywords: &[
                "Тулӯи офтоб аз болои куҳҳо",
                "куҳ",
                "офтоб",
                "саҳар",
                "тулӯи офтоб",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ดวงอาท\u{e34}ตย\u{e4c}โผล\u{e48}พ\u{e49}นเขา"),
            keywords: &[
                "ดวงอาท\u{e34}ตย\u{e4c}ตอนเช\u{e49}า",
                "ดวงอาท\u{e34}ตย\u{e4c}โผล\u{e48}พ\u{e49}นเขา",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("dagyň aňrysyndan günüň dogşy"),
            keywords: &[
                "dag",
                "dagyň aňrysyndan günüň dogşy",
                "gün",
                "günüň dogşy",
                "säher",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("hopo ʻae laʻā he funga moʻunga"),
            keywords: &["hopo ʻae laʻā he funga moʻunga"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("dağların arasından güneşin doğuşu"),
            keywords: &[
                "dağ",
                "dağların arasından güneşin doğuşu",
                "dağların ardında güneş",
                "sabah güneşi",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("تاغدىن كۈن چىقىش"),
            keywords: &["ئەتىگەن", "تاغ", "تاغدىن كۈن چىقىش", "كۈن", "چىقىش"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("схід сонця над горами"),
            keywords: &[
                "гора",
                "погода",
                "ранок",
                "сонце",
                "схід",
                "схід сонця над горами",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("پہاڑوں پر طلوع آفتاب"),
            keywords: &["سورج", "طلوع", "موسم", "پہاڑ", "پہاڑوں پر طلوع آفتاب"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("tog‘lar ortidan quyosh chiqishi"),
            keywords: &[
                "ob-havo",
                "quyosh",
                "quyosh chiqishi",
                "tog‘",
                "tog‘lar ortidan quyosh chiqishi",
                "tong",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("bình minh trên núi"),
            keywords: &[
                "buổi sáng",
                "bình minh",
                "bình minh trên núi",
                "mặt trời",
                "núi",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("jant buy fenk ci tund"),
            keywords: &[
                "jant",
                "jant buy fenk",
                "jant buy fenk ci tund",
                "suba",
                "tundu",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ukuphuma kwelanga phezu kweentaba"),
            keywords: &[
                "ilanga",
                "intaba",
                "kusasa",
                "ukuphuma kwelanga",
                "ukuphuma kwelanga phezu kweentaba",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Lila Oorun Lori Awọn Oke"),
            keywords: &[
                "Lila Oorun Lori Awọn Oke",
                "àárọ\u{300}",
                "ìla òrùn",
                "òkè",
                "òrù",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("山上日出"),
            keywords: &["太陽", "山", "山上日出", "日出", "早上"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("山上日出"),
            keywords: &["太阳", "山", "山上日出", "日出", "早上"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("山顶日出"),
            keywords: &["太阳", "山", "山顶日出", "日出", "清晨"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("日出"),
            keywords: &["日出", "黎明"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("山頭嘅日出"),
            keywords: &["山頭嘅日出", "日出", "黎明"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ukuphuma kwelanga ezintabeni"),
            keywords: &["ekuseni", "ilanga", "ukuphuma kwelanga ezintabeni"],
        },
    ],
};
#[doc = "🌅"]
pub const SUNRISE: crate::Emoji = crate::Emoji {
    glyph: "🌅",
    codepoint: "1F305",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "sunrise",
    group: "Travel & Places",
    subgroup: "place-other",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("sonsopkoms"),
            keywords: &["oggend", "opkoms", "son", "sonsopkoms", "weer"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የፀሐይ ውጣት"),
            keywords: &["የአየር ንብረት", "የፀሐይ ውጣት", "ጠዋት", "ፀሐይ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("شروق"),
            keywords: &["شروق", "شمس", "صباح", "طقس"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("স\u{9c2}ৰ\u{9cd}যোদয\u{9bc}"),
            keywords: &[
                "স\u{9c2}ৰ\u{9cd}যোদয\u{9bc}",
                "স\u{9c2}ৰ\u{9cd}য\u{9cd}য",
                "ৰ\u{9be}তিপ\u{9c1}ৱ\u{9be}",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("gün doğumu"),
            keywords: &["gün doğumu", "günəş", "hava", "səhər"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("узыход сонца"),
            keywords: &["надвор’е", "раніца", "світанне", "сонца", "узыход сонца"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("изгрев"),
            keywords: &["време", "изгрев", "слънце", "сутрин"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("স\u{9c2}র\u{9cd}যোদয\u{9bc}"),
            keywords: &[
                "আবহ\u{9be}ওয\u{9bc}\u{9be}",
                "সক\u{9be}ল",
                "স\u{9c2}র\u{9cd}য",
                "স\u{9c2}র\u{9cd}যোদয\u{9bc}",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("sav-heol"),
            keywords: &["beure", "heol", "mintin", "sav-heol"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("izlazak sunca"),
            keywords: &["izlazak sunca", "jutro", "sunce", "vrijeme"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("alba"),
            keywords: &["alba", "matí", "sol", "sortida del sol", "temps"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᎩᏥᏍᎬ"),
            keywords: &["ᎤᎩᏥᏍᎬ", "ᏅᏓ ᎢᎦ ᎡᎯ", "ᏑᎾᎴᎢ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("východ slunce"),
            keywords: &["počasí", "ráno", "slunce", "východ slunce"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("codiad haul"),
            keywords: &["bore", "codiad haul", "haul"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("solopgang"),
            keywords: &["morgensol", "solopgang"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Sonnenaufgang über dem Meer"),
            keywords: &["Meer", "Sonnenaufgang", "Sonnenaufgang über dem Meer"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("αυγή"),
            keywords: &["ήλιος", "αυγή", "καιρός", "πρωί"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("sunrise"),
            keywords: &["morning", "sun", "sunrise"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("amanecer"),
            keywords: &["amanecer", "salida del sol"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["amanecer", "atardecer", "puesta", "sol"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["amancer", "amanecer", "atardecer", "puesta de sol", "sol"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("päikesetõus"),
            keywords: &["hommik", "ilm", "päike", "päikesetõus"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("egunsentia"),
            keywords: &["egunsentia", "eguraldi", "eguzki", "goiz"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("طلوع"),
            keywords: &["آفتاب", "بامداد", "خورشید", "صبح", "صبح زود", "طلوع"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("auringonnousu"),
            keywords: &["aamu", "auringonnousu", "aurinko", "sää"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("pagsikat ng araw"),
            keywords: &["araw", "dagat", "pagsikat ng araw", "umaga"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("sólarris"),
            keywords: &["dagsbrún", "lýsing", "morgun", "sól", "sólarris"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("soleil levant"),
            keywords: &["soleil", "soleil levant"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("lever de soleil"),
            keywords: &["levant", "lever de soleil", "matin", "soleil"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("éirí na gréine"),
            keywords: &["grian na maidine", "éirí na gréine"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("èirigh na grèine"),
            keywords: &["camhanaich", "grian", "madainn", "èirigh na grèine"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("amencer"),
            keywords: &["amencer", "meteoroloxía", "sol"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("સ\u{ac2}ર\u{acd}યોદય"),
            keywords: &["સવારનો સ\u{ac2}ર\u{acd}ય", "સ\u{ac2}ર\u{acd}યોદય"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("fitowar rana"),
            keywords: &["fitowar rana", "rana", "safiya"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("זריחה"),
            keywords: &["בוקר", "זריחה", "ים", "שמש"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("स\u{942}र\u{94d}योदय, स\u{941}बह का स\u{942}रज"),
            keywords: &[
                "स\u{941}बह का स\u{942}रज",
                "स\u{942}र\u{94d}योदय",
                "स\u{942}र\u{94d}योदय, स\u{941}बह का स\u{942}रज",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("izlazak sunca"),
            keywords: &["izlazak sunca", "jutro", "sunce", "vrijeme"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("napfelkelte"),
            keywords: &["felkelő nap", "nap", "napfelkelte", "reggel"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("արևածագ"),
            keywords: &["առավոտ", "արև", "արևածագ", "եղանակ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("matahari terbit"),
            keywords: &["cuaca", "matahari", "matahari terbit", "pagi"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ọwụwa anyawụ"),
            keywords: &["anyanwụ", "ọwụwa anyawụ", "ụtụtụ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("sólarupprás"),
            keywords: &["morgunn", "sól", "sólarupprás"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("alba"),
            keywords: &["alba", "sole che sorge"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("日の出"),
            keywords: &["太陽", "日の出", "朝", "朝日"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("srengenge mlethek"),
            keywords: &["esuk", "srengenge", "srengenge mlethek"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მზის ამოსვლა"),
            keywords: &["ამინდი", "დილა", "მზე", "მზის ამოსვლა"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("таң атуы"),
            keywords: &["ауа райы", "күн", "таң атуы", "таң ертең"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("solopgang"),
            keywords: &["morgensol", "solopgang"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ព\u{17d2}រះអាទ\u{17b7}ត\u{17d2}ររះព\u{17b8}ផ\u{17d2}ទៃទ\u{17b9}ក"),
            keywords: &[
                "ថ\u{17d2}ងៃរះ",
                "ពេលព\u{17d2}រ\u{17b9}ក",
                "ព\u{17d2}រះអាទ\u{17b7}ត\u{17d2}យរះ",
                "ព\u{17d2}រះអាទ\u{17b7}ត\u{17d2}ររះព\u{17b8}ផ\u{17d2}ទៃទ\u{17b9}ក",
                "រះ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಸ\u{cc2}ರ\u{ccd}ಯೋದಯ"),
            keywords: &[
                "ಬ\u{cc6}ಳಗ\u{cbf}ನ ಸ\u{cc2}ರ\u{ccd}ಯ",
                "ಸ\u{cc2}ರ\u{ccd}ಯೋದಯ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("일출"),
            keywords: &["아침 해", "일출", "해", "해가 뜸"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("स\u{941}र\u{94d}योदय"),
            keywords: &["सकाळ", "स\u{941}र\u{94d}य", "स\u{941}र\u{94d}योदय"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("күндүн чыгышы"),
            keywords: &["күн", "күндүн чыгышы", "таң"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Sonnenopgang"),
            keywords: &["Moien", "Sonn", "Sonnenopgang"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຕາເວ\u{eb1}ນຂ\u{eb6}\u{ec9}ນ"),
            keywords: &[
                "ຕອນເຊ\u{ebb}\u{ec9}າ",
                "ຕາເວ\u{eb1}ນ",
                "ຕາເວ\u{eb1}ນຂ\u{eb6}\u{ec9}ນ",
                "ສະພາບອາກາດ",
                "ອາກາດ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("saulėtekis"),
            keywords: &["rytas", "saulė", "saulėtekis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("saullēkts"),
            keywords: &["rīts", "saule", "saullēkts"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("whitinga o te rā"),
            keywords: &["ata", "rā", "whitinga o te rā"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("изгрејсонце"),
            keywords: &["време", "изгрејсонце", "сонце", "утро"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("സ\u{d42}ര\u{d4d}യോദയം"),
            keywords: &[
                "പ\u{d4d}രഭ\u{d3e}തം",
                "ര\u{d3e}വിലെ",
                "സ\u{d42}ര\u{d4d}യോദയം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("нар мандах"),
            keywords: &["мандах", "нар"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("स\u{942}र\u{94d}योदय"),
            keywords: &["सकाळ", "स\u{942}र\u{94d}य", "स\u{942}र\u{94d}योदय"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("matahari terbit"),
            keywords: &["cuaca", "matahari", "matahari terbit", "pagi"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("tlugħ ix-xemx"),
            keywords: &["filgħodu", "tlugħ ix-xemx", "xemx"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("နေထ\u{103d}က\u{103a}ခြင\u{103a}း"),
            keywords: &[
                "နေ",
                "နေထ\u{103d}က\u{103a}ခြင\u{103a}း",
                "န\u{1036}နက\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("soloppgang"),
            keywords: &["morgen", "morgensol", "sol", "soloppgang"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("स\u{942}र\u{94d}योदय"),
            keywords: &[
                "बिहानी",
                "मौसम",
                "स\u{942}र\u{94d}य",
                "स\u{942}र\u{94d}योदय",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("zonsopgang"),
            keywords: &["ochtend", "zon", "zonsopgang"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("soloppgang"),
            keywords: &["morgon", "morgonsol", "sol", "soloppgang"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ସ\u{b42}ର\u{b4d}ଯ\u{b4d}ୟୋଦୟ"),
            keywords: &[
                "ସଖ\u{b3e}ଳ\u{b41}ଆ ସ\u{b42}ର\u{b4d}ଯ\u{b4d}ୟ",
                "ସ\u{b42}ର\u{b4d}ଯ\u{b4d}ୟଉଦୟ",
                "ସ\u{b42}ର\u{b4d}ଯ\u{b4d}ୟୋଦୟ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਚੜ\u{a4d}ਹਦਾ ਸ\u{a42}ਰਜ"),
            keywords: &[
                "ਚੜ\u{a4d}ਹਦਾ ਸ\u{a42}ਰਜ",
                "ਮ\u{a4c}ਸਮ",
                "ਸਵ\u{a47}ਰ",
                "ਸ\u{a42}ਰਜ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("سورج نکلنا"),
            keywords: &["سورج", "سورج نکلنا", "صبح"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Di Taim Wé Sọn De Kọmọt"),
            keywords: &["Di Taim Wé Sọn De Kọmọt", "Mọ\u{301}nin", "Sọn"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("wschód słońca"),
            keywords: &["brzask", "wschód słońca"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("لمرخاته"),
            keywords: &["سهار", "لمر", "لمر خاته", "لمرخاته"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("aurora sobre água"),
            keywords: &["aurora sobre água", "rio", "sol da manhã", "sol nascendo"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("nascer do sol"),
            keywords: &["manhã", "nascer do sol", "sol"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("paqarin"),
            keywords: &["inti", "paqar", "paqarin"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("răsărit"),
            keywords: &["dimineață", "răsărit", "soare"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-204"),
            keywords: &["E10-204"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("восход"),
            keywords: &[
                "восход",
                "восход солнца",
                "заря",
                "рассвет",
                "солнце",
                "утро",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("kurasa kw’izuba"),
            keywords: &["Ikoti rirerire inyuma", "kurasa kw’izuba"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("سج اڀرڻ"),
            keywords: &["سج", "سج اڀرڻ", "صبح"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("හ\u{dd2}ර\u{dd4} නැග\u{dd3}ම"),
            keywords: &[
                "උදෑසන",
                "ක\u{dcf}ලග\u{dd4}ණය",
                "ස\u{dd6}ර\u{dca}යය\u{dcf}",
                "හ\u{dd2}ර\u{dd4} නැග\u{dd3}ම",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("východ slnka"),
            keywords: &["počasie", "ráno", "slnko", "východ slnka"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("sončni vzhod"),
            keywords: &["jutro", "sonce", "sončni vzhod", "vreme"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("qorrax soo bax"),
            keywords: &["qorrax", "qorrax soo bax", "subax"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("lindja e diellit"),
            keywords: &["diell", "lindja e diellit", "moti", "mëngjes"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("излазак сунца"),
            keywords: &["jутрo", "излазак сунца", "сунцe"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["излазак сунца"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("izlazak sunca"),
            keywords: &["izlazak sunca", "jutro", "sunce"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["izlazak sunca"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("soluppgång"),
            keywords: &["morgonsol", "soluppgång"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("macheo"),
            keywords: &["asubuhi", "hali ya hewa", "jua", "macheo"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("சூரியோதயம\u{bcd}"),
            keywords: &[
                "கடலும\u{bcd} சூரியனும\u{bcd}",
                "க\u{bbe}லை",
                "க\u{bbe}லைச\u{bcd}சூரியன\u{bcd}",
                "சூரியோதயம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ఉదయ\u{c3f}స\u{c4d}తున\u{c4d}న సూర\u{c4d}యుడు"),
            keywords: &[
                "ఉదయం",
                "ఉదయ\u{c3f}స\u{c4d}తున\u{c4d}న సూర\u{c4d}యుడు",
                "సూర\u{c4d}యుడు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("тулӯъ"),
            keywords: &["офтоб", "саҳар", "тулӯъ"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ดวงอาท\u{e34}ตย\u{e4c}ข\u{e36}\u{e49}น"),
            keywords: &[
                "ดวงอาท\u{e34}ตย\u{e4c}ข\u{e36}\u{e49}น",
                "ดวงอาท\u{e34}ตย\u{e4c}ตอนเช\u{e49}า",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("günüň dogşy"),
            keywords: &["gün", "günüň dogşy", "säher"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("hopo ʻae laʻā"),
            keywords: &["hopo ʻae laʻā"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("güneşin doğuşu"),
            keywords: &["güneşin doğuşu", "sabah güneşi"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("كۈن چىقىش"),
            keywords: &["ئەتىگەن", "كۈن", "كۈن چىقىش"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("схід сонця"),
            keywords: &["погода", "ранок", "сонце", "схід сонця"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("طلوع آفتاب"),
            keywords: &["سورج", "صبح", "طلوع آفتاب", "موسم"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("quyosh chiqishi"),
            keywords: &["ob-havo", "quyosh", "quyosh chiqishi", "tong"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("bình minh"),
            keywords: &["buổi sáng", "bình minh", "mặt trời"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("jant buy fenk"),
            keywords: &["jant", "jant buy fenk", "suba"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ukuphuma kwelanga"),
            keywords: &["ilanga", "kusasa", "ukuphuma kwelanga"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ìlà oòrùn"),
            keywords: &["Ìlà oòrùn", "àárọ\u{300}", "òrùn"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("日出"),
            keywords: &["太陽", "日出", "早上"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("日出"),
            keywords: &["太阳", "日出", "早上"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("日出"),
            keywords: &["太阳", "日出", "清晨"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("旭日"),
            keywords: &["旭日", "朝陽"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("日出"),
            keywords: &["太陽", "日出", "陽光"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ukuphuma kwelanga"),
            keywords: &["ilanga", "isimo sezulu", "ukuphuma kwelanga"],
        },
    ],
};
#[doc = "🌆"]
pub const CITYSCAPE_AT_DUSK: crate::Emoji = crate::Emoji {
    glyph: "🌆",
    codepoint: "1F306",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "cityscape at dusk",
    group: "Travel & Places",
    subgroup: "place-other",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("skemer stadslandskap"),
            keywords: &[
                "aand",
                "skemer",
                "skemer stadslandskap",
                "stad",
                "stad teen skemer",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የከተማ መልክዓ ምድር በምሽት"),
            keywords: &["መልክዓ ምድር", "ምሽት", "ከተማ", "የከተማ መልክዓ ምድር በምሽት", "የፀሐይ ግባት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("غروب مدينة"),
            keywords: &["غروب مدينة", "غسق"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("সন\u{9cd}ধিয\u{9bc}\u{9be} বেলিক\u{9be} চহৰৰ দ\u{9c3}শ\u{9cd}য"),
            keywords: &[
                "আবেলি",
                "চহৰ",
                "পৰিদ\u{9c3}শ\u{9cd}য",
                "সন\u{9cd}ধিয\u{9bc}\u{9be} বেলিক\u{9be} চহৰৰ দ\u{9c3}শ\u{9cd}য",
                "সন\u{9cd}ধ\u{9cd}য\u{9be}",
                "স\u{9c2}ৰ\u{9cd}য\u{9be}স\u{9cd}ত",
                "স\u{9c2}ৰ\u{9cd}য\u{9cd}য",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("hava qaralanda şəhər mənzərəsi"),
            keywords: &[
                "bina",
                "günəş",
                "günəşin batması",
                "hava qaralanda şəhər mənzərəsi",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("гарадскі краявід у змярканні"),
            keywords: &[
                "будынак",
                "вечар",
                "гарадскі краявід у змярканні",
                "горад",
                "захад",
                "змярканне",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("градски изглед по здрач"),
            keywords: &["вечер", "град", "градски изглед по здрач", "залез", "здрач"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("গোধ\u{9c2}লিতে শহরের দ\u{9c3}শ\u{9cd}য"),
            keywords: &[
                "আবহ\u{9be}ওয\u{9bc}\u{9be}",
                "গোধ\u{9c2}লি",
                "গোধ\u{9c2}লিতে শহরের দ\u{9c3}শ\u{9cd}য",
                "বিল\u{9cd}ডিং",
                "ভ\u{9c2}দ\u{9c3}শ\u{9cd}য",
                "শহর",
                "সন\u{9cd}ধ\u{9cd}য\u{9be}",
                "স\u{9c2}র\u{9cd}য",
                "স\u{9c2}র\u{9cd}য\u{9be}স\u{9cd}ত",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("gweledva kêr da serr-noz"),
            keywords: &["gweledva", "gweledva kêr da serr-noz", "kêr", "serr-noz"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("pogled na grad u sumrak"),
            keywords: &[
                "grad",
                "pejzaž",
                "pogled na grad u sumrak",
                "sumrak",
                "večer",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("paisatge urbà al vespre"),
            keywords: &["paisatge urbà", "paisatge urbà al vespre", "vespre"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎦᎫᎲᎢᎤᏙᏢᏒᎢ ᎤᏒᎯᏰᏱ"),
            keywords: &[
                "ᎤᏒᎯᏰᏱ",
                "ᎤᏕᎵᎬᎢ",
                "ᎦᎫᎲᎢᎤᏙᏢᏒᎢ ᎤᏒᎯᏰᏱ",
                "ᎦᏙᎢ ᎤᏍᏛᎢ",
                "ᎦᏚᎲᎢ",
                "ᏒᎯᏰᏱ",
            ],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("město za soumraku"),
            keywords: &[
                "budova",
                "krajina",
                "město",
                "město za soumraku",
                "městská",
                "počasí",
                "silueta",
                "slunce",
                "soumrak",
                "večer",
                "vyhlídka",
                "západ",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("dinaslun cyfnos"),
            keywords: &[
                "cyfnos",
                "dinas",
                "dinaslun cyfnos",
                "machlud haul",
                "tirwedd",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("by i solnedgang"),
            keywords: &["aften", "by", "by i solnedgang", "højhuse", "solnedgang"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Abendstimmung in der Stadt"),
            keywords: &[
                "Abendstimmung in der Stadt",
                "Hochhäuser",
                "Sonnenuntergang",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("αστικό τοπίο το σούρουπο"),
            keywords: &[
                "αστικό τοπίο το σούρουπο",
                "βράδυ",
                "ηλιοβασίλεμα",
                "πόλη",
                "σούρουπο",
                "τοπίο",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("cityscape at dusk"),
            keywords: &[
                "city",
                "cityscape at dusk",
                "dusk",
                "evening",
                "landscape",
                "sunset",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("ciudad al atardecer"),
            keywords: &[
                "atardecer",
                "ciudad",
                "ciudad al atardecer",
                "edificios",
                "paisaje",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &[
                "ciudad",
                "ciudad al atardecer",
                "noche",
                "paisaje",
                "puesta de sol",
            ],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("linna siluett videvikus"),
            keywords: &[
                "hoone",
                "ilm",
                "linna siluett videvikus",
                "loojang",
                "siluett",
                "videvik",
                "õhtu",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("hiri-paisaia ilunabarrean"),
            keywords: &[
                "arratsaldea",
                "eguraldia",
                "eraikina",
                "hiri-paisaia ilunabarrean",
                "hiria",
                "ilunabarra",
                "paisaia",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("نمای شهر هنگام غروب"),
            keywords: &[
                "خورشید",
                "شهر",
                "عصر",
                "غروب",
                "منظره",
                "نمای شهر هنگام غروب",
                "چشم\u{200c}انداز",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kaupunkimaisema illanhämärässä"),
            keywords: &[
                "aurinko",
                "ilta",
                "kaupunki",
                "kaupunkimaisema illanhämärässä",
                "sää",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("cityscape sa takipsilim"),
            keywords: &[
                "cityscape",
                "cityscape sa takipsilim",
                "gusali",
                "lungsod",
                "takipsilim",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("skýming í stórbýi"),
            keywords: &[
                "kvøld",
                "myrkja",
                "skýming",
                "skýming í stórbýi",
                "stórbýur",
                "sólsetur",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("ville au crépuscule"),
            keywords: &[
                "coucher de soleil",
                "crépuscule",
                "immeubles",
                "soir",
                "ville au crépuscule",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &[
                "coucher",
                "crépuscule",
                "paysage urbain",
                "soir",
                "soleil",
                "ville",
                "ville au crépuscule",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("dreach cathrach i dtitim na hoíche"),
            keywords: &[
                "breacdhorcha",
                "breacdhorchadas",
                "cathair",
                "dreach cathrach",
                "dreach cathrach i dtitim na hoíche",
                "foirgneamh",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("ciaradh sa bhaile mhòr"),
            keywords: &[
                "baile",
                "ciaradh",
                "ciaradh sa bhaile mhòr",
                "dreach-tìre",
                "feasgar",
                "grian",
                "laighe na grèine",
                "mòr-bhaile",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("luscofusco"),
            keywords: &["cidade", "luscofusco", "meteoroloxía", "noitiña"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("સા\u{a82}જના સમય\u{ac7} શહ\u{ac7}ર"),
            keywords: &[
                "લ\u{ac7}ન\u{acd}ડસ\u{acd}ક\u{ac7}પ",
                "શહ\u{ac7}ર",
                "સમીસા\u{a82}જ",
                "સા\u{a82}જ",
                "સા\u{a82}જના સમય\u{ac7} શહ\u{ac7}ર",
                "સ\u{ac2}ર\u{acd}યાસ\u{acd}ત",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("ganowar birni a magariba"),
            keywords: &[
                "birni",
                "faɗuwar rana",
                "ganowar birni a magariba",
                "magariba",
                "rana",
                "tsarin gari",
                "yamma",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("נוף עירוני בשעת בין-ערביים"),
            keywords: &[
                "בין-ערביים",
                "בניינים",
                "גורדי שחקים",
                "מגדלים",
                "נוף עירוני בשעת בין-ערביים",
                "עיר",
                "שקיעה",
            ],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("शाम का शहर"),
            keywords: &[
                "इमारत",
                "गोध\u{942}लि",
                "भवन",
                "ल\u{948}\u{902}डस\u{94d}क\u{947}प",
                "शहर",
                "शाम",
                "शाम का शहर",
                "स\u{942}र\u{94d}यास\u{94d}त",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("panorama grada u sumrak"),
            keywords: &[
                "grad",
                "krajolik",
                "panorama grada u sumrak",
                "sumrak",
                "večer",
                "zalazak",
                "zgrada",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("városkép alkonyatkor"),
            keywords: &[
                "alkonyat",
                "este",
                "naplemente",
                "város",
                "városkép alkonyatkor",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("քաղաքի համայնապատկեր մթնշաղին"),
            keywords: &[
                "արև",
                "եղանակ",
                "երեկո",
                "լանդշաֆտ",
                "մայրամուտ",
                "մթնշաղ",
                "շենք",
                "քաղաք",
                "քաղաքի համայնապատկեր մթնշաղին",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("panorama kota di sore hari"),
            keywords: &[
                "kota",
                "matahari terbenam",
                "panorama kota di sore hari",
                "pemandangan",
                "senja",
                "sore",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ihe nkiri obodo n’abalị"),
            keywords: &[
                "abalị",
                "akaraụzọ",
                "anyanwụ",
                "ihe nkiri obodo n’abalị",
                "mgbèdè",
                "obodo",
                "ọdịda anyanwụ",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("borg um kvöld"),
            keywords: &[
                "borg",
                "borg um kvöld",
                "borg í rökkurró",
                "borgarlandslag",
                "kvöld",
                "sólarlag",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("città al tramonto"),
            keywords: &[
                "città",
                "città al tramonto",
                "edifici",
                "paesaggio",
                "tramonto",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("夕暮れの都会"),
            keywords: &["夕方", "夕日", "夕暮れ", "夕暮れの都会", "都会"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("gedhung-gedhung wayah sandhekala"),
            keywords: &[
                "bawana",
                "gedhung-gedhung wayah sandhekala",
                "kutha",
                "sandhekala",
                "sore",
                "srengenge mudhun",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ქალაქის ხედი დაბინდებისას"),
            keywords: &[
                "ამინდი",
                "ბინდი",
                "მზე",
                "მზის ჩასვლა",
                "პეიზაჟი",
                "საღამო",
                "ქალაქი",
                "ქალაქის ხედი დაბინდებისას",
                "შენობა",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("ымырттағы қала көрінісі"),
            keywords: &[
                "кеш",
                "күн",
                "күн батысы",
                "ландшафт",
                "ымырт",
                "ымырттағы қала көрінісі",
                "қала",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("by i solnedgang"),
            keywords: &["aften", "by", "by i solnedgang", "højhuse", "solnedgang"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ទ\u{17b8}ក\u{17d2}រ\u{17bb}ងពេលព\u{17d2}រលប\u{17cb}"),
            keywords: &[
                "ទ\u{17b7}ដ\u{17d2}ឋភាពទ\u{17b8}ក\u{17d2}រ\u{17bb}ងពេលព\u{17d2}រលប\u{17cb}",
                "ទ\u{17b8}ក\u{17d2}រ\u{17bb}ង",
                "ទ\u{17b8}ក\u{17d2}រ\u{17bb}ងពេលព\u{17d2}រលប\u{17cb}",
                "ទេសភាព",
                "ព\u{17d2}រលប\u{17cb}",
                "ព\u{17d2}រះអាទ\u{17b7}ត\u{17d2}យល\u{17b7}ច",
                "ល\u{17d2}ងាច",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಮುಸ\u{ccd}ಸಂಜ\u{cc6}ಯಲ\u{ccd}ಲ\u{cbf} ನಗರದ ದೃಶ\u{ccd}ಯ"),
            keywords: &[
                "ಮುಸ\u{ccd}ಸಂಜ\u{cc6}",
                "ಮುಸ\u{ccd}ಸಂಜ\u{cc6}ಯ ನಗರ",
                "ಮುಸ\u{ccd}ಸಂಜ\u{cc6}ಯಲ\u{ccd}ಲ\u{cbf} ನಗರದ ದೃಶ\u{ccd}ಯ",
                "ಸ\u{cc2}ರ\u{ccd}ಯಾಸ\u{ccd}ತದಲ\u{ccd}ಲ\u{cbf} ಕಟ\u{ccd}ಟಡಗಳದೃಶ\u{ccd}ಯ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("도시 야경"),
            keywords: &["건물", "도시", "야경", "일몰", "저녁", "해질녘"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("फातोड\u{94d}ड\u{947}वयलो शारीवाठार"),
            keywords: &[
                "फातोड\u{94d}ड\u{947}वयलो शारीवाठार",
                "फोतोड\u{94d}ड",
                "भ\u{942}\u{902}य",
                "शार",
                "सा\u{902}ज",
                "स\u{941}र\u{94d}यास\u{94d}त",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("күүгүмдөгү шаардын көрүнүшү"),
            keywords: &[
                "кеч",
                "күндүн батышы",
                "күүгүм",
                "күүгүмдөгү шаардын көрүнүшү",
                "шаар",
            ],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Stad an der Dämmerung"),
            keywords: &[
                "Dämmerung",
                "Landschaft",
                "Owend",
                "Sonn",
                "Sonnenënnergang",
                "Stad",
                "Stad an der Dämmerung",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ພາບທ\u{eb4}ວທ\u{eb1}ດເມ\u{eb7}ອງເວລາຕາເວ\u{eb1}ນຕ\u{ebb}ກ"),
            keywords: &[
                "ຕາເວ\u{eb1}ນຕ\u{ebb}ກ",
                "ຕ\u{ebb}ວເມ\u{eb7}ອງ",
                "ພາບທ\u{eb4}ວທ\u{eb1}ດ",
                "ພາບທ\u{eb4}ວທ\u{eb1}ດເມ\u{eb7}ອງເວລາຕາເວ\u{eb1}ນຕ\u{ebb}ກ",
                "ອາຄານ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("sutemos virš miesto"),
            keywords: &[
                "kraštovaizdis",
                "miestas",
                "pastatas",
                "saulėlydis",
                "sutemos virš miesto",
                "vakaras",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("pilsētas panorāma krēslā"),
            keywords: &[
                "ainava",
                "krēsla",
                "māja",
                "panorāma",
                "pilsēta",
                "pilsētas panorāma krēslā",
                "ēka",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("whakahuahua tāonenui porehu"),
            keywords: &[
                "ahiahi",
                "paewhenua",
                "porehu",
                "rā",
                "rātō",
                "tāonenui",
                "whakahuahua tāonenui porehu",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("градски пејзаж во приквечерина"),
            keywords: &[
                "вечер",
                "град",
                "градски пејзаж во приквечерина",
                "зајдисонце",
                "пејзаж",
                "самрак",
            ],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("നഗരത\u{d4d}തിലെ സ\u{d3e}യ\u{d3e}ഹ\u{d4d}നം"),
            keywords: &[
                "അസ\u{d4d}തമയം",
                "നഗരം",
                "നഗരത\u{d4d}തിലെ സ\u{d3e}യ\u{d3e}ഹ\u{d4d}നം",
                "സ\u{d3e}യ\u{d3e}ഹ\u{d4d}നം",
                "സ\u{d42}ര\u{d4d}യ\u{d3e}സ\u{d4d}തമയം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("үдшийн бүрийд хотын харагдац"),
            keywords: &[
                "бүрий",
                "нар жаргах",
                "харагдац",
                "хот",
                "үдшийн бүрийд хотын харагдац",
                "үдэш",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("साय\u{902}काळच\u{947} शहराच\u{947} द\u{943}श\u{94d}\u{200d}य"),
            keywords: &[
                "तिन\u{94d}हीसा\u{902}ज",
                "तिन\u{94d}हीसा\u{902}ज\u{947}च\u{947} शहराच\u{947} द\u{943}श\u{94d}य",
                "भ\u{942}द\u{943}श\u{94d}य",
                "शहर",
                "स\u{902}ध\u{94d}याकाळ",
                "साय\u{902}काळच\u{947} शहराच\u{947} द\u{943}श\u{94d}\u{200d}य",
                "स\u{942}र\u{94d}य",
                "स\u{942}र\u{94d}यास\u{94d}त",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("panorama kota waktu senja"),
            keywords: &[
                "bandar",
                "bangunan",
                "cuaca",
                "landskap",
                "matahari",
                "matahari terbenam",
                "panorama kota waktu senja",
                "petang",
                "senja",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("silwett tal-belt fi nżul ix-xemx"),
            keywords: &[
                "belt",
                "fl-għaxija",
                "inżul ix-xemx",
                "pajsaġġ",
                "silwett tal-belt fi nżul ix-xemx",
                "xemx",
                "żerniq",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "နေဝင\u{103a}ဆည\u{103a}းဆာချ\u{102d}န\u{103a} မြ\u{102d}\u{102f}\u{1037}ပြရ\u{103e}\u{102f}ခင\u{103a}း",
            ),
            keywords: &[
                "ညနေ",
                "နေဝင\u{103a}ချ\u{102d}န\u{103a}",
                "နေဝင\u{103a}ဆည\u{103a}းဆာ",
                "နေဝင\u{103a}ဆည\u{103a}းဆာချ\u{102d}န\u{103a} မြ\u{102d}\u{102f}\u{1037}ပြရ\u{103e}\u{102f}ခင\u{103a}း",
                "ရ\u{103e}\u{102f}ခင\u{103a}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("bylandskap i skumring"),
            keywords: &[
                "by",
                "bygning",
                "byhorisont",
                "bylandskap i skumring",
                "skumring",
                "sol",
                "solnedgang",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("गोध\u{942}ली समयको सिटिस\u{94d}क\u{947}प"),
            keywords: &[
                "गोध\u{942}ली समयको सिटिस\u{94d}क\u{947}प",
                "सिटिस\u{94d}क\u{947}पको गोध\u{942}ली समय",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("stad bij schemering"),
            keywords: &[
                "avond",
                "landschap",
                "schemer",
                "stad",
                "stad bij schemering",
                "zonsondergang",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("bylandskap i skumring"),
            keywords: &[
                "by",
                "bygning",
                "byhorisont",
                "bylandskap i skumring",
                "skumring",
                "sol",
                "solnedgang",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ପ\u{b4d}ରଦୋଷ ସମୟରେ ସହରର ପର\u{b3f}ଦ\u{b43}ଶ\u{b4d}ୟ"),
            keywords: &[
                "ପ\u{b4d}ରଦୋଷ",
                "ପ\u{b4d}ରଦୋଷ ସମୟରେ ସହରର ଦ\u{b43}ଶ\u{b4d}ୟ",
                "ପ\u{b4d}ରଦୋଷ ସମୟରେ ସହରର ପର\u{b3f}ଦ\u{b43}ଶ\u{b4d}ୟ",
                "ଭ\u{b42}ଭ\u{b3e}ଗର ଦ\u{b43}ଶ\u{b4d}ୟ",
                "ସହର",
                "ସ\u{b42}ର\u{b4d}ଯ\u{b3e}ସ\u{b4d}ତ",
                "\u{200d}ସନ\u{b4d}ଧ\u{b4d}ୟ\u{b3e}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਸ\u{a3c}ਾਮ ਵ\u{a47}ਲ\u{a47} ਸ\u{a3c}ਹਿਰ ਦਾ ਦ\u{a4d}ਰਿਸ"),
            keywords: &[
                "ਇਮਾਰਤ",
                "ਸ\u{a3c}ਹਿਰ",
                "ਸ\u{a3c}ਹਿਰ ਦੀ ਸ\u{a3c}ਾਮ",
                "ਸ\u{a3c}ਾਮ ਦਾ ਨਜ\u{a3c}ਾਰਾ",
                "ਸ\u{a3c}ਾਮ ਵ\u{a47}ਲ\u{a47} ਸ\u{a3c}ਹਿਰ ਦਾ ਦ\u{a4d}ਰਿਸ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("تاریکی تے سٹی سکیپ"),
            keywords: &[
                "تاریکی تے سٹی سکیپ",
                "سورج",
                "سورج غروب ہونا",
                "شام",
                "شہر",
                "نیم تاریکی",
                "پیش نظر",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Taun Im Píkchọ Wẹ\u{301}n Nait Dọ\u{301}n De Niálí Rich"),
            keywords: &[
                "Sọn Dọ\u{301}n De Gò",
                "Taun",
                "Taun Im Píkchọ Wẹ\u{301}n Nait Dọ\u{301}n De Niálí Rich",
                "Ívnin",
                "Ẹ\u{301}vrítin Yọ Ai Fít Si Wẹ\u{301}n Yú Lúk Aúsaid At Bíg Land",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("miasto o zmierzchu"),
            keywords: &[
                "budynki",
                "miasto",
                "miasto o zmierzchu",
                "wieżowce",
                "zachód słońca",
                "zmierzch",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د ښار منظره په ماښام کې"),
            keywords: &[
                "د ښار منظره په ماښام کې",
                "لمر لوېده",
                "ماښام",
                "منظره",
                "ښار",
            ],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("cidade ao anoitecer"),
            keywords: &[
                "anoitecer",
                "cidade",
                "cidade ao anoitecer",
                "noite",
                "paisagem",
                "prédio",
                "pôr do sol",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("paisagem urbana ao anoitecer"),
            keywords: &[
                "anoitecer",
                "cidade",
                "crepúsculo",
                "paisagem",
                "paisagem urbana ao anoitecer",
                "pôr do sol",
                "sol",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("rikusqa llaqtamanta tutapi"),
            keywords: &[
                "ch’isi",
                "inti-haykupuynin",
                "llaqta",
                "rikchay",
                "rikusqa llaqtamanta tutapi",
                "tuta",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("peisaj urban la apus"),
            keywords: &[
                "apus",
                "oraș",
                "peisaj urban la apus",
                "seară",
                "soare",
                "zgârie-nori",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-205"),
            keywords: &["E10-205"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("закат в городе"),
            keywords: &[
                "вечер",
                "город",
                "закат",
                "закат в городе",
                "заход",
                "солнце",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("igice cy’umujyi kirengeweho n’izuba"),
            keywords: &[
                "igice cy’umujyi kirengeweho n’izuba",
                "izuba",
                "izuba rirenga",
                "kurenga kw’izuba",
                "landscape",
                "umugoroba",
                "umujyi",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("سج لهڻ تي شهر جو منظر"),
            keywords: &["سج لهڻ تي شهر جو منظر", "شهر، سج لهڻ، شام، سج، نظارو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("සන\u{dca}ධ\u{dca}\u{200d}ය\u{dcf} ක\u{dcf}ලයේ නගරය"),
            keywords: &[
                "අඳ\u{dd4}ර",
                "ක\u{dcf}ලග\u{dd4}ණය",
                "ගොඩනැග\u{dd2}ල\u{dca}ල",
                "නගරය",
                "පර\u{dd2}දර\u{dca}ශනය",
                "සන\u{dca}ධ\u{dca}\u{200d}ය\u{dcf} ක\u{dcf}ලයේ නගරය",
                "සන\u{dca}ධ\u{dca}\u{200d}ය\u{dcf}ව",
                "ස\u{dd6}ර\u{dca}යය\u{dcf}",
                "හ\u{dd2}ර\u{dd4} බැස\u{dd3}ම",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("mestská panoráma pri súmraku"),
            keywords: &[
                "mesto",
                "mestská panoráma pri súmraku",
                "panoráma",
                "večer",
                "zotmenie",
                "západ slnka",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("mestna pokrajina v mraku"),
            keywords: &[
                "mestna pokrajina v mraku",
                "mesto",
                "mrak",
                "pokrajina",
                "sonce",
                "sončni zahod",
                "večer",
                "vreme",
                "zgradba",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("muuqaal magaalo ee qorrax dhaca"),
            keywords: &[
                "dhicista",
                "fiid",
                "magaalo",
                "muuqaal magaalo",
                "muuqaal magaalo ee qorrax dhaca",
                "qorrax dhac",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("panoramë qyteti në muzg"),
            keywords: &[
                "diell",
                "mbrëmje",
                "ndërtesë",
                "panoramë",
                "panoramë qyteti në muzg",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("град у сумрак"),
            keywords: &[
                "вече",
                "град",
                "град у сумрак",
                "залазак",
                "пејзаж",
                "сумрак",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["град у сумрак"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("grad u sumrak"),
            keywords: &[
                "grad",
                "grad u sumrak",
                "pejzaž",
                "sumrak",
                "veče",
                "zalazak",
            ],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["grad u sumrak"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("stad i skymning"),
            keywords: &[
                "byggnader",
                "kväll",
                "skymning",
                "solnedgång",
                "stad i skymning",
                "stadsvy",
            ],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mwonekano wa jiji usiku"),
            keywords: &[
                "jiji",
                "jioni",
                "machweo",
                "mandhari",
                "mwonekano wa jiji usiku",
                "usiku",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("சூரிய அஸ\u{bcd}தமனத\u{bcd}தின\u{bcd} போது நகரம\u{bcd}"),
            keywords: &[
                "அஸ\u{bcd}தமனம\u{bcd}",
                "சூரிய அஸ\u{bcd}தமனத\u{bcd}தின\u{bcd} போது நகரம\u{bcd}",
                "சூரிய அஸ\u{bcd}தமனம\u{bcd}",
                "நகரம\u{bcd}",
                "ம\u{bbe}லை",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("సంధ\u{c4d}య\u{c3e} సమయంల\u{c4b} నగర వ\u{c40}క\u{c4d}షణ"),
            keywords: &[
                "నగరం",
                "సంధ\u{c4d}య\u{c3e}",
                "సంధ\u{c4d}య\u{c3e} సమయంల\u{c4b} నగర వ\u{c40}క\u{c4d}షణ",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("манзараи шаҳр дар шом"),
            keywords: &[
                "бегоҳ",
                "манзара",
                "манзараи шаҳр дар шом",
                "офтоб",
                "шаҳр",
                "шом",
                "ғуруби офтоб",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เม\u{e37}องยามโพล\u{e49}เพล\u{e49}"),
            keywords: &[
                "ตอนเย\u{e47}น",
                "เม\u{e37}องยามโพล\u{e49}เพล\u{e49}",
                "โพล\u{e49}เพล\u{e49}",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("agşamara şäher peýzažy"),
            keywords: &[
                "agşamara şäher peýzažy",
                "agşamara şäher sudury",
                "alagaraňky",
                "günüň ýaşmagy",
                "peýzaž",
                "tozan",
                "şäher",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("fale lalahi lotokolo mamalu efiafi"),
            keywords: &["fale lalahi lotokolo mamalu efiafi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("şehirde alacakaranlık"),
            keywords: &[
                "akşam",
                "alacakaranlık",
                "bina",
                "gün batımı",
                "manzara",
                "şehir",
                "şehirde alacakaranlık",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("گۇگۇمدىكى شەھەر"),
            keywords: &[
                "ئۇپۇق",
                "شەھەر",
                "كۈن",
                "كۈن پېتىش",
                "كەچ",
                "گۇگۇم",
                "گۇگۇمدىكى شەھەر",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("місто в сутінках"),
            keywords: &[
                "вечір",
                "захід",
                "ландшафт",
                "місто",
                "місто в сутінках",
                "сутінки",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("شام کے وقت اونچی عمارتیں"),
            keywords: &["سورج", "شام", "شام کے وقت اونچی عمارتیں", "عمارت", "موسم"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("kunbotar mahaldagi shahar manzarasi"),
            keywords: &[
                "bino",
                "kechqurun",
                "kunbotar mahaldagi shahar manzarasi",
                "manzara",
                "quyosh",
                "quyosh botishi",
                "shahar",
                "shom",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("khung cảnh thành phố lúc chạng vạng"),
            keywords: &[
                "buổi tối",
                "hoàng hôn",
                "khung cảnh thành phố lúc chạng vạng",
                "mặt trời lặn",
                "phong cảnh",
                "thành phố",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("timis ci réewu taax"),
            keywords: &[
                "dëkk",
                "guddi",
                "jant",
                "jant buy so",
                "peyisaas",
                "timis",
                "timis ci réewu taax",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("i-cityscape ngorhatya"),
            keywords: &[
                "i-cityscape ngorhatya",
                "ilanga",
                "isixeko",
                "ngokuhlwa",
                "ukutshona kwelanga",
                "umhlaba",
                "urhatya",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Iwo Ilu Ni Aṣalẹ"),
            keywords: &[
                "Iwo Ilu Ni Aṣalẹ",
                "oníbùú",
                "àṣàlẹ\u{301}",
                "ìlú",
                "ìwọ òrùn",
                "òrùn",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("黃昏時嘅城市景觀"),
            keywords: &[
                "傍晚",
                "城市",
                "太陽",
                "日落",
                "景觀",
                "黃昏",
                "黃昏時嘅城市景觀",
            ],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("黄昏时嘅城市景观"),
            keywords: &[
                "傍晚",
                "城市",
                "太阳",
                "日落",
                "景观",
                "黄昏",
                "黄昏时嘅城市景观",
            ],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("城市黄昏"),
            keywords: &["城市黄昏", "夜晚", "日落", "都市", "黄昏"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("黃昏"),
            keywords: &["暮色", "黃昏"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["夕陽", "日落", "黃昏"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ukubukeka kwedolobha ukushona kwelanga"),
            keywords: &[
                "idolobha",
                "isakhiwo",
                "ukubukeka kwedolobha ukushona kwelanga",
                "ukushona kwelanga",
            ],
        },
    ],
};
#[doc = "🌇"]
pub const SUNSET: crate::Emoji = crate::Emoji {
    glyph: "🌇",
    codepoint: "1F307",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "sunset",
    group: "Travel & Places",
    subgroup: "place-other",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("sonsondergang"),
            keywords: &["gebou", "skemer", "son", "sonsondergang", "weer"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የፀሐይ ግባት"),
            keywords: &["ሕንጻ", "የአየር ንብረት", "የፀሐይ ግባት", "ጨለማ", "ፀሐይ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("غسق"),
            keywords: &["شمس تغرب", "غسق"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("স\u{9c2}ৰ\u{9cd}য\u{9be}স\u{9cd}ত"),
            keywords: &[
                "সন\u{9cd}ধ\u{9cd}য\u{9be}",
                "স\u{9c2}ৰ\u{9cd}য\u{9be}স\u{9cd}ত",
                "স\u{9c2}ৰ\u{9cd}য\u{9cd}য",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("gün batımı"),
            keywords: &["bina", "gün batımı", "günəş", "hava", "toran"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("захад сонца"),
            keywords: &["будынак", "захад сонца", "змярканне", "надвор’е", "сонца"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("залез"),
            keywords: &["време", "залез", "здрач", "сграда", "слънце"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("স\u{9c2}র\u{9cd}য\u{9be}স\u{9cd}ত"),
            keywords: &[
                "আবহ\u{9be}ওয\u{9bc}\u{9be}",
                "গোধ\u{9c2}লি",
                "বিল\u{9cd}ডিং",
                "স\u{9c2}র\u{9cd}য",
                "স\u{9c2}র\u{9cd}য\u{9be}স\u{9cd}ত",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("kuzh-heol"),
            keywords: &["heol", "kuzh-heol", "serr-noz"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("zalazak sunca"),
            keywords: &["sumrak", "sunce", "vrijeme", "zalazak sunca", "zgrada"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("posta de sol"),
            keywords: &["ciutat", "crepuscle", "posta de sol"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᏕᎵᎬᎢ"),
            keywords: &["ᎤᏒᎯᏰᏱ", "ᎤᏕᎵᎬᎢ", "ᏅᏓ ᎢᎦ ᎡᎯ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("západ slunce"),
            keywords: &["počasí", "slunce", "soumrak", "večer", "západ"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("machlud haul"),
            keywords: &["cyfnos", "dinas", "machlud haul"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("solnedgang"),
            keywords: &["skumring", "solnedgang", "solnedgang bag bygninger"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Sonnenuntergang in der Stadt"),
            keywords: &[
                "Hochhäuser",
                "Sonnenuntergang",
                "Sonnenuntergang in der Stadt",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ηλιοβασίλεμα"),
            keywords: &["ήλιος", "ηλιοβασίλεμα", "σούρουπο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("sunset"),
            keywords: &["dusk", "sun", "sunset"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("puesta del sol"),
            keywords: &["edificios", "puesta del sol"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("puesta de sol sobre edificios"),
            keywords: &[
                "amanecer",
                "atardecer",
                "edificios",
                "puesta",
                "puesta de sol sobre edificios",
                "sol",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &[
                "amanecer",
                "atardecer",
                "edificios",
                "puesta",
                "puesta de sol sobre edificios",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &[
                "atardecer",
                "puesta de sol",
                "puesta de sol sobre edificios",
                "sol",
            ],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("päikeseloojang"),
            keywords: &["hoone", "ilm", "loojang", "päike", "päikeseloojang"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("ilunabarra"),
            keywords: &["eguraldi", "eguzki", "eraikin", "ilunabar", "ilunabarra"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("غروب"),
            keywords: &[
                "خورشید",
                "غروب",
                "غروب آفتاب",
                "منظره",
                "چشم\u{200c}انداز",
                "گرگ\u{200c}ومیش",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("auringonlasku"),
            keywords: &["auringonlasku", "aurinko", "ilta", "sää"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("paglubog ng araw"),
            keywords: &[
                "agaw-dilim",
                "araw",
                "cityscape",
                "dapit-hapon",
                "paglubog ng araw",
                "takipsilim",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("sólsetur"),
            keywords: &["kvøld", "myrkja", "skýming", "sólsetur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("coucher de soleil"),
            keywords: &["coucher de soleil", "soleil"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["coucher", "coucher de soleil", "crépuscule", "soleil"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("dul faoi na gréine"),
            keywords: &[
                "breacdhorcha",
                "dul faoi na gréine",
                "foirgneamh",
                "foirgnimh",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("laighe na grèine"),
            keywords: &["ciaradh", "grian", "laighe na grèine"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("solpor"),
            keywords: &["cidade", "meteoroloxía", "ocaso", "posta de sol", "solpor"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("સ\u{ac2}ર\u{acd}યાસ\u{acd}ત"),
            keywords: &[
                "ઈમારત",
                "ઈમારતો પર સ\u{ac2}ર\u{acd}યાસ\u{acd}ત",
                "સમીસા\u{a82}જ",
                "સ\u{ac2}ર\u{acd}યાસ\u{acd}ત",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("faɗuwar rana"),
            keywords: &["faɗuwar rana", "magariba", "rana"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("שקיעה"),
            keywords: &[
                "בניינים",
                "גורדי שחקים",
                "מגדלים",
                "עיר",
                "ערב",
                "שמש",
                "שקיעה",
            ],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("स\u{942}र\u{94d}यास\u{94d}त"),
            keywords: &[
                "इमारतो\u{902} क\u{947} पीछ\u{947} स\u{942}र\u{94d}यास\u{94d}त",
                "भवन",
                "स\u{902}ध\u{94d}याकाल",
                "स\u{942}र\u{94d}यास\u{94d}त",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("zalazak sunca"),
            keywords: &["sumrak", "sunce", "vrijeme", "zalazak sunca", "zgrada"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("naplemente"),
            keywords: &["alkonyat", "lemenő nap", "nap", "naplemente", "épületek"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("մայրամուտ"),
            keywords: &["արև", "եղանակ", "մայրամուտ", "մթնշաղ", "շենք"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("matahari terbenam"),
            keywords: &[
                "bangunan",
                "cuaca",
                "matahari",
                "matahari terbenam",
                "senja",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ọdịda-anyanwụ"),
            keywords: &["abalị", "anyanwụ", "ọdịda-anyanwụ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("sólarlag"),
            keywords: &["hús", "rökkur", "sólarlag", "sólarlag yfir húsum"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("tramonto"),
            keywords: &["sole che tramonta sulla città", "tramonto"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("夕日"),
            keywords: &["夕方", "夕日", "夕暮れ", "太陽"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("srengenge mudhun"),
            keywords: &["sandhekala", "srengenge", "srengenge mudhun"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მზის ჩასვლა"),
            keywords: &["ამინდი", "ბინდი", "მზე", "მზის ჩასვლა", "შენობა"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("күннің батуы"),
            keywords: &["ауа райы", "күн", "күннің батуы", "ымырт", "ғимарат"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("solnedgang"),
            keywords: &["skumring", "solnedgang", "solnedgang bag bygninger"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ទ\u{17b8}ក\u{17d2}រ\u{17bb}ងពេលថ\u{17d2}ងៃល\u{17b7}ច"),
            keywords: &[
                "ថ\u{17d2}ងៃល\u{17b7}ច",
                "ទ\u{17b8}ក\u{17d2}រ\u{17bb}ង",
                "ទ\u{17b8}ក\u{17d2}រ\u{17bb}ងពេលថ\u{17d2}ងៃល\u{17b7}ច",
                "ពេលថ\u{17d2}ងៃល\u{17b7}ច",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಸ\u{cc2}ರ\u{ccd}ಯಾಸ\u{ccd}ತ"),
            keywords: &["ಮುಸ\u{ccd}ಸಂಜ\u{cc6}ಯ", "ಸ\u{cc2}ರ\u{ccd}ಯಾಸ\u{ccd}ತ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("일몰"),
            keywords: &["도시에 해가 짐", "일몰", "해가 짐", "해질녘"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("स\u{941}र\u{94d}यास\u{94d}त"),
            keywords: &[
                "फातोड\u{94d}ड",
                "स\u{941}र\u{94d}य",
                "स\u{941}र\u{94d}यास\u{94d}त",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("күндүн батышы"),
            keywords: &["аба ырайы", "имарат", "күн", "күндүн батышы", "күүгүм"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Sonnenënnergang"),
            keywords: &["Dämmerung", "Sonn", "Sonnenënnergang"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຕາເວ\u{eb1}ນຕ\u{ebb}ກ"),
            keywords: &["ຕາເວ\u{eb1}ນ", "ຕາເວ\u{eb1}ນຕ\u{ebb}ກ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("saulėlydis"),
            keywords: &["saulė", "saulėlydis", "sutemos"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("saulriets"),
            keywords: &["māja", "saule", "saulriets", "ēka"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tōnga o te rā"),
            keywords: &["porehu", "rā", "tōnga o te rā"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("зајдисонце"),
            keywords: &["градба", "зајдисонце", "самрак", "сонце"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("സ\u{d42}ര\u{d4d}യ\u{d3e}സ\u{d4d}\u{200c}തമയം"),
            keywords: &[
                "അസ\u{d4d}തമയം",
                "കെട\u{d4d}ടിടങ\u{d4d}ങൾ",
                "സ\u{d42}ര\u{d4d}യ\u{d3e}സ\u{d4d}\u{200c}തമയം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("нар жаргах"),
            keywords: &["жаргах", "нар"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("स\u{942}र\u{94d}यास\u{94d}त"),
            keywords: &[
                "तिन\u{94d}हीसा\u{902}ज",
                "स\u{942}र\u{94d}य",
                "स\u{942}र\u{94d}यास\u{94d}त",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("matahari terbenam"),
            keywords: &[
                "bangunan",
                "cuaca",
                "matahari",
                "matahari terbenam",
                "senja",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("nżul ix-xemx"),
            keywords: &["nżul ix-xemx", "xemx", "żerniq"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("နေဝင\u{103a}ချ\u{102d}န\u{103a}"),
            keywords: &[
                "နေ",
                "နေဝင\u{103a}ချ\u{102d}န\u{103a}",
                "နေဝင\u{103a}ဆည\u{103a}းဆာ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("solnedgang"),
            keywords: &[
                "bygning",
                "skumring",
                "sol",
                "solnedgang",
                "solnedgang over byhorisont",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("स\u{942}र\u{94d}यास\u{94d}त"),
            keywords: &[
                "गोध\u{942}ली सा\u{901}झ",
                "स\u{942}र\u{94d}य",
                "स\u{942}र\u{94d}यास\u{94d}त",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("zonsondergang"),
            keywords: &["schemer", "zon", "zonsondergang"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("solnedgang"),
            keywords: &[
                "bygning",
                "skumring",
                "sol",
                "solnedgang",
                "solnedgang over byhorisont",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ସ\u{b42}ର\u{b4d}ଯ\u{b4d}ୟ\u{b3e}ସ\u{b4d}ତ"),
            keywords: &[
                "କୋଠ\u{b3e}",
                "କୋଠ\u{b3e} ଉପରେ ସ\u{b42}ର\u{b4d}ଯ\u{b4d}ୟ\u{b3e}ସ\u{b4d}ତ",
                "ସନ\u{b4d}ଧ\u{b4d}ୟ\u{b3e}କ\u{b3e}ଳ",
                "ସ\u{b42}ର\u{b4d}ଯ\u{b4d}ୟ\u{b3e}ସ\u{b4d}ତ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਸ\u{a3c}ਾਮ"),
            keywords: &[
                "ਇਮਾਰਤ",
                "ਇਮਾਰਤਾ\u{a02} ਤ\u{a47} ਸ\u{a3c}ਾਮ",
                "ਮ\u{a4c}ਸਮ",
                "ਸ\u{a3c}ਾਮ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("سورج غروب ہونا"),
            keywords: &["سورج", "سورج غروب ہونا", "نیم تاریکی"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Sọn Dọ\u{301}n De Gò"),
            keywords: &[
                "Sọn",
                "Sọn Dọ\u{301}n De Gò",
                "Wẹn Nait Dọ\u{301}n De Niálí Rich",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("zachód słońca"),
            keywords: &["budynki", "miasto", "zachód słońca", "zmierzch"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("لمر لوېده"),
            keywords: &["لمر", "لمر لوېده", "ماښام"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("pôr do sol"),
            keywords: &[
                "anoitecer",
                "prédio",
                "pôr do sol",
                "pôr do sol sobre prédios",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["crepúsculo", "edifícios", "pôr do sol", "pôr-do-sol", "sol"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("inti-haykupuynin"),
            keywords: &["inti", "inti-haykupuynin", "tuta"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("apus"),
            keywords: &["amurg", "apus", "crepuscul", "soare"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-206"),
            keywords: &["E10-206"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("закат"),
            keywords: &["вечер", "закат", "заход", "солнце"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("kurenga kw’izuba"),
            keywords: &["izuba", "izuba rirenga", "kurenga kw’izuba"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("سج لهڻ"),
            keywords: &["سج لهڻ", "سج لهڻ، اندهيرو ٿيڻ، شام"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("හ\u{dd2}ර\u{dd4} බැස\u{dd3}ම"),
            keywords: &[
                "අඳ\u{dd4}ර",
                "ක\u{dcf}ලග\u{dd4}ණය",
                "ගොඩනැග\u{dd2}ල\u{dca}ල",
                "ස\u{dd6}ර\u{dca}යය\u{dcf}",
                "හ\u{dd2}ර\u{dd4} බැස\u{dd3}ම",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("západ slnka"),
            keywords: &["budova", "počasie", "slnko", "zotmenie", "západ slnka"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("sončni zahod"),
            keywords: &["mrak", "sonce", "sončni zahod", "vreme", "zgradba"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("qorrax dhac"),
            keywords: &["qorrax", "qorrax dhac", "qorrax dhaca"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("perëndim dielli"),
            keywords: &["diell", "moti", "muzg", "ndërtesë", "perëndim dielli"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("залазак сунца"),
            keywords: &["залазак сунца", "сумрaк", "сунцe"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["залазак сунца"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("zalazak sunca"),
            keywords: &["sumrak", "sunce", "zalazak sunca"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["zalazak sunca"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("solnedgång"),
            keywords: &[
                "byggnader",
                "skymning",
                "solnedgång",
                "solnedgång över stad",
            ],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("machweo"),
            keywords: &["giza", "hali ya hewa", "jengo", "jua", "machweo"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("சூரிய அஸ\u{bcd}தமனம\u{bcd}"),
            keywords: &[
                "சூரிய அஸ\u{bcd}தமனம\u{bcd}",
                "நகரத\u{bcd}தில\u{bcd} சூரிய அஸ\u{bcd}தமனம\u{bcd}",
                "ம\u{bbe}லை",
                "வேலை நேர முடிவு",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("సూర\u{c4d}య\u{c3e}స\u{c4d}తమయం"),
            keywords: &[
                "అస\u{c4d}తమయం",
                "సూర\u{c4d}య",
                "సూర\u{c4d}య\u{c3e}స\u{c4d}తమయం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("ғуруб"),
            keywords: &["офтоб", "шом", "ғуруб"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ดวงอาท\u{e34}ตย\u{e4c}ตก"),
            keywords: &[
                "ดวงอาท\u{e34}ตย\u{e4c}ตก",
                "ดวงอาท\u{e34}ตย\u{e4c}ตกเหน\u{e37}อต\u{e36}ก",
                "โพล\u{e49}เพล\u{e49}",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("günüň ýaşmagy"),
            keywords: &["alagaraňky", "gün", "günüň ýaşmagy"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tō ʻae laʻā"),
            keywords: &["tō ʻae laʻā"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("gün batımı"),
            keywords: &[
                "alacakaranlık",
                "bina",
                "binaların üzerinden gün batımı",
                "gün batımı",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("كۈن پېتىش"),
            keywords: &["كۈن", "كۈن پېتىش", "گۇگۇم"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("захід сонця"),
            keywords: &["захід сонця", "сонце", "сутінки"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("غروب\u{650} آفتاب"),
            keywords: &["سورج", "عمارت", "غروب", "غروب\u{650} آفتاب", "موسم"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("quyosh botishi"),
            keywords: &["bino", "ob-havo", "quyosh", "quyosh botishi"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("hoàng hôn"),
            keywords: &["chạng vạng", "hoàng hôn", "mặt trời"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("jant bu so ci réewu taax"),
            keywords: &["jant", "jant bu so ci réewu taax", "so"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("intshona langa"),
            keywords: &["ilanga", "intshona langa", "ngorhatya"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ìwọ\u{300} oòrùn"),
            keywords: &["Ìwọ\u{300} oòrùn", "àṣálé", "òrún"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("日落"),
            keywords: &["太陽", "日落", "黃昏"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("日落"),
            keywords: &["太阳", "日落", "黄昏"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("日落"),
            keywords: &["夕阳", "日落"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("夕陽"),
            keywords: &["夕陽", "日落"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("夕陽"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ukushona kwelanga"),
            keywords: &["isakhiwo", "isimo sezulu", "ukushona kwelanga"],
        },
    ],
};
#[doc = "🌉"]
pub const BRIDGE_AT_NIGHT: crate::Emoji = crate::Emoji {
    glyph: "🌉",
    codepoint: "1F309",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "bridge at night",
    group: "Travel & Places",
    subgroup: "place-other",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("brug in die aand"),
            keywords: &["brug", "brug in die aand", "nag", "weer"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ድልድይ በለሊት"),
            keywords: &["ሌሊት", "የአየር ንብረት", "ድልድይ", "ድልድይ በለሊት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("جسر في الليل"),
            keywords: &["جسر", "جسر في الليل", "طقس", "ليل"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("নিশ\u{9be}ৰ সেত\u{9c1}"),
            keywords: &["নিশ\u{9be}", "নিশ\u{9be}ৰ সেত\u{9c1}", "সেত\u{9c1}"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("gecə körpü"),
            keywords: &["axşam", "gecə körpü", "hava", "körpü"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("мост уначы"),
            keywords: &["мост", "мост уначы", "надвор’е", "ноч"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Мост през нощта"),
            keywords: &["Мост през нощта", "време", "мост", "нощ"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("র\u{9be}তে সেত\u{9c1}"),
            keywords: &[
                "আবহ\u{9be}ওয\u{9bc}\u{9be}",
                "র\u{9be}ত",
                "র\u{9be}তে সেত\u{9c1}",
                "সেত\u{9c1}",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("pont en noz"),
            keywords: &["noz", "pont", "pont en noz"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("most noću"),
            keywords: &["most", "most noću", "noć", "vrijeme"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("pont de nit"),
            keywords: &["nit", "pont", "pont de nit"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏒᏢᎢ ᎤᏒᎢ"),
            keywords: &["ᎠᏒᏢᎢ", "ᎤᏒᎢ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("most v noci"),
            keywords: &["most", "most v noci", "noc", "počasí"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("pont gyda’r nos"),
            keywords: &["nos", "pont", "pont gyda’r nos", "tywydd"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("bro i mørke"),
            keywords: &["bro i mørke", "bro i natten", "nat"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Brücke vor Nachthimmel"),
            keywords: &[
                "Brücke",
                "Brücke vor Nachthimmel",
                "Golden Gate",
                "Nacht",
                "nachts",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("γέφυρα τη νύχτα"),
            keywords: &["γέφυρα", "γέφυρα τη νύχτα", "νύχτα"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("bridge at night"),
            keywords: &["bridge", "bridge at night", "night"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("puente de noche"),
            keywords: &["noche", "puente", "puente de noche"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("sild öösel"),
            keywords: &["ilm", "sild", "sild öösel", "öö"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("zubia gauez"),
            keywords: &["eguraldi", "gau", "zubi", "zubia gauez"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("پل در شب"),
            keywords: &["روی پل", "شب", "پل", "پل در شب"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("silta yöllä"),
            keywords: &["silta", "silta yöllä", "sää", "yö"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("tulay sa gabi"),
            keywords: &["bituin", "gabi", "tulay", "tulay sa gabi"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("brúgv á nátt"),
            keywords: &["brúgv", "brúgv á nátt", "nátt"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("pont de nuit"),
            keywords: &["pont", "pont de nuit"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("pont de nuit"),
            keywords: &["nuit", "pont", "pont de nuit"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("droichead istoíche"),
            keywords: &["droichead", "droichead istoíche", "oíche"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("drochaid air an oidhche"),
            keywords: &["drochaid", "drochaid air an oidhche", "oidhche"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("ponte de noite"),
            keywords: &[
                "estrelas",
                "meteoroloxía",
                "noite",
                "ponte",
                "ponte de noite",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("રાતના સમય\u{ac7} બ\u{acd}રિજ"),
            keywords: &[
                "નાઇટ બ\u{acd}રિજ",
                "રાત",
                "રાતના સમય\u{ac7} બ\u{acd}રિજ",
                "રાત\u{acd}ર\u{ac7} પ\u{ac1}લ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("gada a dare"),
            keywords: &["dare", "gada", "gada a dare"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("גשר בלילה"),
            keywords: &["גשר", "גשר בלילה", "לילה", "עיר"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("रात म\u{947}\u{902} प\u{941}ल"),
            keywords: &["प\u{941}ल और रात", "रात", "रात म\u{947}\u{902} प\u{941}ल"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("most noću"),
            keywords: &["most", "most noću", "noć", "vrijeme", "zvijezde"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("híd éjszaka"),
            keywords: &["híd", "éjszaka"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("կամուրջը գիշերով"),
            keywords: &["գիշեր", "եղանակ", "կամուրջ", "կամուրջը գիշերով"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("jembatan di malam hari"),
            keywords: &["cuaca", "jembatan", "jembatan di malam hari", "malam"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("àkwà mmiri n’abalị"),
            keywords: &["abalị", "àkwà", "àkwà mmiri n’abalị"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("brú um nótt"),
            keywords: &["brú", "brú um nótt", "nótt"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("ponte di notte"),
            keywords: &["notte", "ponte", "ponte di notte"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("夜の橋"),
            keywords: &["夜", "夜の橋", "夜景", "橋"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("kreteg ing wayah bengi"),
            keywords: &["bengi", "kreteg", "kreteg ing wayah bengi"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ხიდი ღამით"),
            keywords: &["ამინდი", "ღამე", "ხიდი", "ხიდი ღამით"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("көпірдің түнгі көрінісі"),
            keywords: &["ауа райы", "көпір", "көпірдің түнгі көрінісі", "түн"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("bro i mørke"),
            keywords: &["bro i mørke", "bro i natten", "nat"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ស\u{17d2}ពានពេលយប\u{17cb}"),
            keywords: &["ពេលយប\u{17cb}", "ស\u{17d2}ពាន", "ស\u{17d2}ពានពេលយប\u{17cb}"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ರಾತ\u{ccd}ರ\u{cbf}ಯಲ\u{ccd}ಲ\u{cbf} ಸೇತುವ\u{cc6}"),
            keywords: &[
                "ರಾತ\u{ccd}ರ\u{cbf}ಯ ಸೇತುವ\u{cc6}",
                "ರಾತ\u{ccd}ರ\u{cbf}ಯಲ\u{ccd}ಲ\u{cbf} ಸೇತುವ\u{cc6}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("밤하늘을 배경으로 하는 다리"),
            keywords: &[
                "다리",
                "달과 다리",
                "밤",
                "밤의 다리",
                "밤하늘을 배경으로 하는 다리",
                "별과 다리",
            ],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("रातचो प\u{941}ल"),
            keywords: &["प\u{941}ल", "रात", "रातचो प\u{941}ल"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("түнкү көпүрө"),
            keywords: &["аба ырайы", "көпүрө", "түн", "түнкү көпүрө"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Bréck nuets"),
            keywords: &["Bréck", "Nuecht", "nuets"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຂ\u{ebb}ວໃນຕອນກາງຄ\u{eb7}ນ"),
            keywords: &["ກາງຄ\u{eb7}ນ", "ຂ\u{ebb}ວ", "ຂ\u{ebb}ວໃນຕອນກາງຄ\u{eb7}ນ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("tiltas naktį"),
            keywords: &["naktis", "tiltas", "tiltas naktį"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("tilts naktī"),
            keywords: &["nakts", "tilts", "tilts naktī"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("arawhata i te pō"),
            keywords: &["arawhata", "arawhata i te pō", "pō"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("мост навечер"),
            keywords: &["вечер", "време", "мост", "мост навечер"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("പ\u{d3e}ലത\u{d4d}തിന\u{d4d}റെ നിശ\u{d3e}ദ\u{d43}ശ\u{d4d}യം"),
            keywords: &[
                "പ\u{d3e}ലം",
                "പ\u{d3e}ലത\u{d4d}തിന\u{d4d}റെ നിശ\u{d3e}ദ\u{d43}ശ\u{d4d}യം",
                "ര\u{d3e}ത\u{d4d}രി",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("шөнийн гүүр"),
            keywords: &["гүүр", "шөнийн гүүр", "шөнө"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("रात\u{94d}रीच\u{94d}या व\u{947}ळी दिसणारा प\u{942}ल"),
            keywords: &[
                "प\u{942}ल",
                "रात\u{94d}र",
                "रात\u{94d}रीच\u{94d}या व\u{947}ळी दिसणारा प\u{942}ल",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("jambatan pada waktu malam"),
            keywords: &["cuaca", "jambatan", "jambatan pada waktu malam", "malam"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("pont billejl"),
            keywords: &["billejl", "pont"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ညအချ\u{102d}န\u{103a}မ\u{103e}ာ တ\u{1036}တား"),
            keywords: &[
                "ည",
                "ညအချ\u{102d}န\u{103a}မ\u{103e}ာ တ\u{1036}တား",
                "တ\u{1036}တား",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("bro om natten"),
            keywords: &["bro", "bro om natten", "natt"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("रातको समयमा प\u{942}ल"),
            keywords: &["द\u{941}लही", "मौसम", "रात", "रातको समयमा प\u{942}ल"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("brug bij nacht"),
            keywords: &["brug", "brug bij nacht", "nacht"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("bru om natta"),
            keywords: &["bru", "bru om natta", "natt"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ର\u{b3e}ତ\u{b3f}ରେ ପୋଲ"),
            keywords: &[
                "ର\u{b3e}ତ\u{b3f}ରେ ପୋଲ",
                "ର\u{b3e}ତ\u{b4d}ର\u{b3f}",
                "ର\u{b3e}ତ\u{b4d}ର\u{b3f} ବ\u{b4d}ର\u{b3f}ଜ\u{b4d}",
                "ର\u{b3e}ତ\u{b4d}ର\u{b3f}ରେ ବ\u{b4d}ର\u{b3f}ର\u{b4d}ଜ\u{b4d}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਰਾਤ ਨ\u{a42}\u{a70} ਪ\u{a41}\u{a71}ਲ ਦਾ ਦ\u{a4d}ਰਿਸ\u{a3c}"),
            keywords: &[
                "ਪ\u{a41}\u{a71}ਲ ਤ\u{a47} ਰਾਤ",
                "ਮ\u{a4c}ਸਮ",
                "ਰਾਤ",
                "ਰਾਤ ਨ\u{a42}\u{a70} ਪ\u{a41}\u{a71}ਲ ਦਾ ਦ\u{a4d}ਰਿਸ\u{a3c}",
                "ਰਾਤ ਪ\u{a41}\u{a71}ਲ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("رات ویلے پ\u{64f}ل"),
            keywords: &["رات", "رات ویلے پ\u{64f}ل", "پ\u{64f}ل"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Haú Brij Bì Wẹn Yú Lúk Am Fọ Naít Taim"),
            keywords: &["Brij", "Haú Brij Bì Wẹn Yú Lúk Am Fọ Naít Taim", "Nait"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("most nocą"),
            keywords: &["most nocą", "most w nocy"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("په شپه کې پل"),
            keywords: &["شپه", "پل", "په شپه کې پل"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("ponte à noite"),
            keywords: &["noite", "ponte da noite", "ponte à noite"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("ponte à noite"),
            keywords: &["noite", "ponte", "ponte à noite"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("chaka tutapi"),
            keywords: &["chaka", "chaka tutapi", "tuta"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("pod luminat noaptea"),
            keywords: &["lumină", "noapte", "pod", "pod luminat noaptea"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-208"),
            keywords: &["E10-208"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("мост ночью"),
            keywords: &["мост", "мост ночью", "ночь"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ikiraro kigaragara mu ijoro"),
            keywords: &["ijoro", "ikiraro", "ikiraro kigaragara mu ijoro"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("رات ۾ پل"),
            keywords: &["رات", "رات ۾ پل", "پل"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ර\u{dcf}ත\u{dca}\u{200d}ර\u{dd2}යේද\u{dd3} ප\u{dcf}ලම"),
            keywords: &[
                "ක\u{dcf}ලග\u{dd4}ණය",
                "ප\u{dcf}ලම",
                "ර\u{dcf}ත\u{dca}\u{200d}ර\u{dd2}ය",
                "ර\u{dcf}ත\u{dca}\u{200d}ර\u{dd2}යේද\u{dd3} ප\u{dcf}ලම",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("most v noci"),
            keywords: &["most", "most v noci", "noc", "počasie"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("most ponoči"),
            keywords: &["most", "most ponoči", "noč", "vreme"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("buundada habeenkii"),
            keywords: &["buundada habeenkii", "buundo", "habeen"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("urë natën"),
            keywords: &["mot", "natë", "urë", "urë natën"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("мост ноћу"),
            keywords: &["мoст", "мост ноћу", "нoћ"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["мост ноћу"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("most noću"),
            keywords: &["most", "most noću", "noć"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["most noću"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("bro på natten"),
            keywords: &["bro", "bro på natten", "natt"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("daraja usiku"),
            keywords: &["daraja", "hali ya hewa", "usiku"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("இரவில\u{bcd} ப\u{bbe}லம\u{bcd}"),
            keywords: &[
                "இரவின\u{bcd} பின\u{bcd}னணியில\u{bcd} ப\u{bbe}லம\u{bcd}",
                "இரவில\u{bcd} ப\u{bbe}லம\u{bcd}",
                "இரவு",
                "ப\u{bbe}லம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ర\u{c3e}త\u{c4d}ర\u{c3f}పూట వంత\u{c46}న"),
            keywords: &[
                "ర\u{c3e}త\u{c4d}ర\u{c3f}",
                "ర\u{c3e}త\u{c4d}ర\u{c3f}పూట వంత\u{c46}న",
                "వంత\u{c46}న",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("кӯпрук дар шаб"),
            keywords: &["кӯпрук", "кӯпрук дар шаб", "шаб"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("สะพานกลางค\u{e37}น"),
            keywords: &["กลางค\u{e37}น", "สะพาน", "สะพานกลางค\u{e37}น"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("gijeki köpri"),
            keywords: &["gije", "gijeki köpri", "köpri"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("hala kavakava poʻuli"),
            keywords: &["hala kavakava poʻuli"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("gece vakti köprü"),
            keywords: &["gece", "gece vakti köprü"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("كېچىدىكى كۆۋرۈك"),
            keywords: &["كۆۋرۈك", "كېچىدىكى كۆۋرۈك", "كېچە"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("міст уночі"),
            keywords: &["міст", "міст уночі", "ніч", "погода"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("رات کے وقت پ\u{64f}ل"),
            keywords: &["رات", "رات کے وقت پ\u{64f}ل", "موسم", "پل"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("tundagi ko‘prik"),
            keywords: &["ko‘prik", "ob-havo", "tun", "tundagi ko‘prik"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("cây cầu về đêm"),
            keywords: &["cây cầu về đêm", "cầu", "đêm"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("pom ci guddi"),
            keywords: &["guddi", "pom", "pom ci guddi"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ibrorho ebusuku"),
            keywords: &["ibrorho", "ibrorho ebusuku", "ubusuku"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Afara Ni Aṣalẹ"),
            keywords: &["Afara Ni Aṣalẹ", "afárá", "alẹ\u{301}"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("晚上嘅大橋"),
            keywords: &["大橋", "晚上", "晚上嘅大橋"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("晚上嘅大桥"),
            keywords: &["大桥", "晚上", "晚上嘅大桥"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("夜幕下的桥"),
            keywords: &["夜幕下的桥", "晚上", "桥"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("夜橋"),
            keywords: &["夜景", "夜橋"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("夜晚嘅橋"),
            keywords: &["夜晚嘅橋", "夜景"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ibhuloho ebusuku"),
            keywords: &["ebusuku", "ibhuloho", "isimo sezulu"],
        },
    ],
};
#[doc = "♨\u{fe0f}"]
pub const HOT_SPRINGS: crate::Emoji = crate::Emoji {
    glyph: "♨\u{fe0f}",
    codepoint: "2668 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "hot springs",
    group: "Travel & Places",
    subgroup: "place-other",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "♨",
        codepoint: "2668",
        status: crate::Status::Unqualified,
        introduction_version: 0.6f32,
        name: "hot springs",
        group: "Travel & Places",
        subgroup: "place-other",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("warmbron"),
            keywords: &["fontein", "stoom", "warm", "warmbron", "water"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ትኩስ ፍልውሃ"),
            keywords: &["ምንጮች", "ትኩስ", "እንፋሎት", "ፍልውሃ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("ينابيع ساخنة"),
            keywords: &["ساخن", "عيون", "متبخر", "ينابيع ساخنة", "ينبوع ساخن"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("হট স\u{9cd}প\u{9cd}ৰিং"),
            keywords: &["ষ\u{9cd}টিমিং", "স\u{9cd}প\u{9cd}ৰিং", "হট"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("qaynar bulaqlar"),
            keywords: &["bulaqlar", "buxarlanan", "isti", "qaynar bulaqlar"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("гарачыя крыніцы"),
            keywords: &["гарачы", "гарачыя крыніцы", "крыніцы", "пара"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("горещ извор"),
            keywords: &["горещ", "извор", "пара"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("উষ\u{9cd}ণ প\u{9cd}রস\u{9cd}রবণ"),
            keywords: &[
                "উষ\u{9cd}ণ প\u{9cd}রস\u{9cd}রবণ",
                "গরম",
                "প\u{9cd}রস\u{9cd}রবণ",
                "ভ\u{9be}প\u{9be}নো",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("andon tomm"),
            keywords: &["andon", "tomm"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("izvori vruće vode"),
            keywords: &["izvor", "izvori vruće vode", "para", "vruć", "vrućina"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("fonts termals"),
            keywords: &[
                "aigües termals",
                "calor",
                "complex turístic",
                "fonts termals",
                "vapor",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᏗᏞᎦ ᏕᎦᏅᎪᎬᎢ"),
            keywords: &["ᎠᏔᎶᎴᎬᎢ", "ᎤᏗᏞᎦ", "ᎤᏗᏞᎦ ᎦᏅᎪᎬᎢ", "ᏕᎦᏅᎪᎬᎢ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("horké prameny"),
            keywords: &["horko", "horké prameny", "horký pramen", "lázeň", "pára"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("tarddelli poeth"),
            keywords: &["poeth", "stêm", "tarddelli"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("varme kilder"),
            keywords: &["damp", "kilder", "varm", "varme kilder"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("heiße Quellen"),
            keywords: &["Dampf", "Quellen", "dampfend", "heiß", "heiße Quellen"],
        },
        #[cfg(feature = "de_CH")]
        crate::Annotation {
            lang: "de_CH",
            tts: Some("Heisse Quellen"),
            keywords: &[
                "Dampf",
                "Heisse Quellen",
                "Quellen",
                "dampfend",
                "heiss",
                "heisse Quellen",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("θερμές πηγές"),
            keywords: &["βγάζει καπνούς", "ζέστη", "θερμές πηγές", "πηγές"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("hot springs"),
            keywords: &["hot", "hotsprings", "springs", "steaming"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("aguas termales"),
            keywords: &["aguas termales", "termas", "vapor"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &[
                "aguas",
                "caliente",
                "fuentes termales",
                "termales",
                "termas",
                "vapor",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &[
                "aguas",
                "caliente",
                "fuentes termales",
                "termales",
                "termas",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["aguas termales", "caliente", "vapor"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kuumaveeallikad"),
            keywords: &["allikas", "aur", "kuum", "kuumaveeallikad", "soe"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("iturri termalak"),
            keywords: &["bero", "iturri", "iturri termalak", "ke", "termal"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("چشمه\u{654} آب گرم"),
            keywords: &[
                "بخار",
                "داغ",
                "چشمه",
                "چشمه آب گرم",
                "چشمه\u{654} آب گرم",
                "گرم",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kuumat lähteet"),
            keywords: &["kuumat lähteet", "kylpylä", "lähde", "vesi"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("hot springs"),
            keywords: &["hot springs", "japanese", "mainit", "onsen", "umuusok"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("heit kelda"),
            keywords: &["heit", "kelda"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("sources chaudes"),
            keywords: &["source", "sources chaudes"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("sources thermales"),
            keywords: &["source", "sources thermales", "thermale"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("foinse the"),
            keywords: &["ag galú", "foinse the", "foinsí", "foinsí teo", "te"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("fuaran teth"),
            keywords: &["ceò", "fuaran", "teth"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("augas termais"),
            keywords: &["auga termal", "augas termais", "quente", "vapor"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ગરમ પાણીના ઝરા"),
            keywords: &[
                "ઉકળતા\u{a82}",
                "ગરમ",
                "ગરમ પાણીના ઝરા",
                "ઝરા",
                "વરાળ નીકળતા\u{a82}",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("maɓuɓɓuga mai zafi"),
            keywords: &["mai tururi", "maɓuɓɓuga", "maɓuɓɓuga mai zafi", "zafi"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("מעיינות חמים"),
            keywords: &["אדים", "חם", "מעיינות", "מעיינות חמים", "קיטור"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("गरम सोता"),
            keywords: &["गरम सोता", "गर\u{94d}म", "भाप य\u{941}क\u{94d}त"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("termalni izvori"),
            keywords: &["izvor", "para", "termalni izvori", "vruće"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("hőforrás"),
            keywords: &["forrás", "forró", "gőz", "hőforrás"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("տաք աղբյուրներ"),
            keywords: &["աղբյուրներ", "հոսք", "տաք"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("sumber air panas"),
            keywords: &["air", "mata", "mengepul", "panas", "sumber"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("mmiri ọkụ"),
            keywords: &[
                "mmiri okwute",
                "mmiri ọkụ",
                "mmiriọkụ",
                "ọgbụgbọ mmiri",
                "ọkụ",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("hverir"),
            keywords: &["gufa", "heitt", "hverir", "laugar"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("sorgenti termali"),
            keywords: &[
                "acqua sorgente",
                "acqua termale",
                "sorgenti termali",
                "terme",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("温泉マーク"),
            keywords: &["温泉", "温泉マーク"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("tuk banyu panas"),
            keywords: &["kemepul", "panas", "tuk", "tuk banyu panas"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ცხელი წყაროები"),
            keywords: &["ორთქლი", "ცხელი", "წყაროები"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("гейзер"),
            keywords: &["бу шығару", "гейзер", "көздер", "ыстық"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("varme kilder"),
            keywords: &["damp", "kilder", "varm", "varme kilder"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ច\u{17c6}ហាយក\u{17d2}តៅហ\u{17ca}\u{17bb}យឡើង"),
            keywords: &[
                "ក\u{17d2}ដៅ",
                "ច\u{17c6}ហាយ",
                "ច\u{17c6}ហាយក\u{17d2}តៅហ\u{17ca}\u{17bb}យឡើង",
                "ច\u{17c6}ហាយទ\u{17b9}កក\u{17d2}ដៅ",
                "ទ\u{17b9}កក\u{17d2}ដៅធម\u{17d2}មជាត\u{17b7}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಬ\u{cbf}ಸ\u{cbf}ನೀರ\u{cbf}ನ ಬುಗ\u{ccd}ಗ\u{cc6}ಗಳು"),
            keywords: &[
                "ಆವ\u{cbf}",
                "ಬ\u{cbf}ಸ\u{cbf}",
                "ಬ\u{cbf}ಸ\u{cbf}ನೀರ\u{cbf}ನ ಬುಗ\u{ccd}ಗ\u{cc6}ಗಳು",
                "ಹಾಟ\u{ccd} ಸ\u{ccd}ಪ\u{ccd}ರ\u{cbf}ಂಗ\u{ccd}\u{200c}ಗಳು",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("온천"),
            keywords: &["뜨거움", "목욕탕", "온천"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("उष\u{94d}ण गीम"),
            keywords: &["उष\u{94d}ण", "उष\u{94d}णगीम", "गीम", "वाफ"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("ысык булактар"),
            keywords: &["булактар", "бууланган", "ысык"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("waarm Quellen"),
            keywords: &["Quellen", "dämpend", "waarm"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ນ\u{ecd}\u{ec9}າພ\u{eb8}ຮ\u{ec9}ອນ"),
            keywords: &[
                "ນ\u{ecd}\u{ec9}າພ\u{eb8}",
                "ນ\u{ecd}\u{ec9}າພ\u{eb8}ຮ\u{ec9}ອນ",
                "ຮ\u{ec9}ອນ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("karštosios versmės"),
            keywords: &["garai", "karšta", "karštosios versmės", "versmės"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("karstie avoti"),
            keywords: &["avots", "karstie avoti", "karsts"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("wai ariki"),
            keywords: &["korohuhū", "puna", "wai ariki", "waiariki", "wera"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("извори на топла вода"),
            keywords: &["вода", "жешка", "извори", "извори на топла вода", "топла"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ച\u{d42}ട\u{d41}റവകൾ"),
            keywords: &["ഉറവ", "ച\u{d42}ട\u{d41}റവകൾ"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("халуун рашаан"),
            keywords: &["рашаан", "уур", "халуун"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("गरम झरा"),
            keywords: &[
                "गरम",
                "गरम झरा",
                "गरम पाण\u{94d}याच\u{947} झर\u{947}",
                "गरमपाण\u{94d}याच\u{947} झर\u{947}",
                "झर\u{947}",
                "वाफा य\u{947}णार\u{947}",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("mata air panas"),
            keywords: &["berwap", "mata air", "mata air panas", "panas"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("nixxigħat sħan"),
            keywords: &["fwar", "nixxigħat", "nixxigħat sħan", "sħun"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ရေပ\u{1030}စမ\u{103a}းများ"),
            keywords: &[
                "စမ\u{103a}း",
                "ပ\u{1030}",
                "ရေပ\u{1030}စမ\u{103a}းများ",
                "အင\u{103d}ေ\u{1037}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("varme kilder"),
            keywords: &["kilder", "rykende", "vame kilder", "varm", "varme kilder"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("तातो पानीको म\u{942}ल"),
            keywords: &[
                "तात\u{947}को",
                "तातो",
                "तातो पानीको म\u{942}ल",
                "तातोपानीको म\u{942}लहर\u{942}",
                "म\u{942}ल",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("warmwaterbronnen"),
            keywords: &["bronnen", "stomend", "warm", "warmwaterbronnen"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("varme kjelder"),
            keywords: &["kjelder", "rykande", "varm", "varme kjelder"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଉଷ\u{b4d}ମ ପ\u{b4d}ରସବଣଗ\u{b41}ଡ\u{b3c}\u{b3f}କ"),
            keywords: &[
                "ଉଷ\u{b4d}ମ ପ\u{b4d}ରସବଣଗ\u{b41}ଡ\u{b3c}\u{b3f}କ",
                "ଗରମ",
                "ଝରଣ\u{b3e}ଗ\u{b41}ଡ\u{b3c}\u{b3f}କ",
                "ବ\u{b3e}ମ\u{b4d}ଫ ବ\u{b3e}ହ\u{b3e}ର\u{b3f}ବ\u{b3e}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਬਹ\u{a41}ਤ ਗਰਮ"),
            keywords: &["ਗਰਮ", "ਬਹ\u{a41}ਤ ਗਰਮ", "ਭਾਫ\u{a3c}"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("تت\u{651}ے چشمے"),
            keywords: &[
                "بھاپ نکلدی",
                "بہاراں",
                "تتا",
                "تت\u{651}ے چشمے",
                "ہاٹ سپرنگز",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Họt Wọtá Wé De Kọmọ\u{301}t Frọm Ínsaíd Graun"),
            keywords: &[
                "Họt",
                "Họt Wọtá Wé De Kọmọ\u{301}t Frọm Ínsaíd Graun",
                "Sọ\u{301}mtin Wé Dé Họt Wẹ\u{301}l Wẹl",
                "Wọtá Wé De Kọmọ\u{301}t Frọm Ínsaíd Graun",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("gorące źródła"),
            keywords: &["gorące", "gorące źródła", "para", "woda", "źródło"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("تودې چينې"),
            keywords: &["تود", "تودې چينې", "خوټکېدونکې", "چينې"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("chamas"),
            keywords: &["calor", "chamas", "fogo"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("termas"),
            keywords: &["nascentes", "quente", "termas", "vapor", "águas termais"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("q’uñi yaku"),
            keywords: &["q’uñi", "q’uñi yaku", "t’ikmu", "wapsi"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("izvoare termale"),
            keywords: &["aburi", "apă", "căldură", "izvoare termale", "izvor"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-080"),
            keywords: &["E10-080"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("горячие источники"),
            keywords: &["гейзер", "горячие", "источники", "пар", "поток"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("amashyuza"),
            keywords: &["amashyuza", "amasoko", "gishyushye", "steaming"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("گرم چشما"),
            keywords: &["ٻاڦڻ", "چشما", "گرم"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("උණ\u{dd4} ද\u{dd2}ය උල\u{dca}පත\u{dca}"),
            keywords: &[
                "උණ\u{dd4} ද\u{dd2}ය උල\u{dca}පත\u{dca}",
                "උණ\u{dd4}ස\u{dd4}ම\u{dca}",
                "උල\u{dca}පත\u{dca}",
                "බ\u{dd4}බ\u{dd4}ළ\u{dd4} දැම\u{dd3}ම",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("horúce pramene"),
            keywords: &["horúce", "horúce pramene", "para", "žriedla"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("termalni vrelec"),
            keywords: &["izvir", "termalni vrelec", "vrelec", "vrelo", "vroče"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("ilo kulul"),
            keywords: &["ilo", "kulul", "uumigga"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("llixhë"),
            keywords: &["burim", "i nxehtë", "llixhë", "me avull"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("термални извори"),
            keywords: &["врућe", "извoр", "пaрa", "термални извори", "термално"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("termalni izvori"),
            keywords: &["izvor", "para", "termalni izvori", "termalno", "vruće"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("varma källor"),
            keywords: &["het källa", "termalkälla", "varma källor", "ångande"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("chemichemi za maji ya moto"),
            keywords: &[
                "chemchemi",
                "chemcheni za maji moto",
                "chemichemi za maji ya moto",
                "moto",
                "mvuke",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &[
                "chemchemi za maji moto",
                "chemichemi",
                "chemichemi za maji ya moto",
                "moto",
                "mvuke",
            ],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ஹ\u{bbe}ட\u{bcd} ஸ\u{bcd}பிரிங\u{bcd}க\u{bcd}ஸ\u{bcd}"),
            keywords: &[
                "சூடு",
                "த\u{bc0}",
                "ஹ\u{bbe}ட\u{bcd} ஸ\u{bcd}பிரிங\u{bcd}க\u{bcd}ஸ\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("వ\u{c47}డ\u{c3f} న\u{c40}ట\u{c3f}క\u{c4a}లనులు"),
            keywords: &[
                "న\u{c40}రు",
                "బుగ\u{c4d}గ",
                "వ\u{c47}డ\u{c3f}",
                "వ\u{c47}డ\u{c3f} న\u{c40}ట\u{c3f}క\u{c4a}లనులు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("чашмаҳои гарм"),
            keywords: &["гарм", "чашмаҳо", "чашмаҳои гарм", "ҷӯшидаистода"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("น\u{e49}ำพ\u{e38}ร\u{e49}อน"),
            keywords: &[
                "น\u{e49}ำพ\u{e38}",
                "น\u{e49}ำพ\u{e38}ร\u{e49}อน",
                "ไอน\u{e49}ำ",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("gyzgyn çeşme"),
            keywords: &["bugarýan", "gyzgyn", "gyzgyn çeşme", "çeşmeler", "ýylysuw"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("vaipuna mao"),
            keywords: &["vaipuna mao"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("kaplıca"),
            keywords: &["hamam", "kaplıca", "sıcak", "ılıca"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئىسسىق بۇلاق"),
            keywords: &["ئىسسىق بۇلاق", "ئىسسىق سۇ", "بۇلاق", "قىزىق", "ھور"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("гарячі джерела"),
            keywords: &["гарячий", "гарячі джерела", "джерело", "паруючі"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("گرم ندی"),
            keywords: &["بھاپ", "ندی", "گرم"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("issiq buloq"),
            keywords: &["bug‘", "buloq", "issiq"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("suối nước nóng"),
            keywords: &["hơi nước", "nóng", "suối", "suối nước nóng"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("cooroon bu tàng"),
            keywords: &[
                "cooroon",
                "cooroon bu tàng",
                "cooroon yu tàng",
                "saxaar",
                "tàng",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("i-hot springs"),
            keywords: &[
                "eqhumayo",
                "eshushu",
                "i-hot springs",
                "i-hotsprings",
                "i-springs",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("omi àtilẹ\u{300}wá"),
            keywords: &["gbígbóná", "omi àtilẹ\u{300}wá", "oru"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("溫泉"),
            keywords: &["泉", "溫泉", "熱", "熱騰騰"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("温泉"),
            keywords: &["泉", "温泉", "热", "热腾腾"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("温泉"),
            keywords: &["水", "泉", "温泉", "热气腾腾"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("溫泉"),
            keywords: &["泡湯", "溫泉"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("iziphethu ezinamanzi ashisayo"),
            keywords: &[
                "iziphethu",
                "iziphethu ezinamanzi ashisayo",
                "kuyashisa",
                "kuyathunya",
            ],
        },
    ],
};
#[doc = "🎠"]
pub const CAROUSEL_HORSE: crate::Emoji = crate::Emoji {
    glyph: "🎠",
    codepoint: "1F3A0",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "carousel horse",
    group: "Travel & Places",
    subgroup: "place-other",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("mallemeuleperd"),
            keywords: &["mallemeule", "mallemeuleperd", "perd"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ካሮሴል ፈረስ"),
            keywords: &["ካሮሴል", "ፈረስ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("حصان الدوامة"),
            keywords: &["ترفيه", "حصان", "حصان الدوامة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("কৰোজেল হৰ\u{9cd}চ"),
            keywords: &["কৰোজেল", "কৰোজেল হৰ\u{9cd}চ", "ঘোৰ\u{9be}"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("karusel at"),
            keywords: &["at", "karusel"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("конік з каруселі"),
            keywords: &["карусель", "конь", "конік", "конік з каруселі"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("кон от въртележка"),
            keywords: &["въртележка", "кон", "кон от въртележка"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ন\u{9be}গরদোলন\u{9be} ঘোড\u{9bc}\u{9be}"),
            keywords: &["ঘোড\u{9bc}\u{9be}", "ন\u{9be}গরদোলন\u{9be}"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("kazeg-vezevenn"),
            keywords: &["kazeg", "kazeg-vezevenn", "manej"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("vrteška"),
            keywords: &["konjić", "vrteška"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cavallets"),
            keywords: &["atraccions", "cavallets"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏕᏲᎯ ᏐᏈᎵ"),
            keywords: &["ᎠᏕᏲᎯ", "ᏐᏈᎵ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("kolotočový kůň"),
            keywords: &["kolotoč", "kolotočový kůň", "kůň"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("ceffyl carwsél"),
            keywords: &["carwsél", "ceffyl"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("karrusel"),
            keywords: &["karrusel", "karruselhest", "karruseltur", "køre i karrusel"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Karussellpferd"),
            keywords: &["Karussell", "Karussellpferd", "Pferd"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("αλογάκι καρουσέλ"),
            keywords: &["άλογο", "αλογάκι καρουσέλ"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("carousel horse"),
            keywords: &["carousel", "horse"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: None,
            keywords: &["carousel", "horse", "merry-go-round"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("merry-go-round"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("caballo de tiovivo"),
            keywords: &[
                "caballo",
                "caballo de tiovivo",
                "entretenimiento",
                "tiovivo",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("caballo de carrusel"),
            keywords: &["caballo", "caballo de carrusel", "calesita", "carrusel"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("karussellihobune"),
            keywords: &["hobune", "karussell", "karussellihobune"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("karrusela"),
            keywords: &["karrusela", "zaldia"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("چرخ\u{200c}وفلک اسبی"),
            keywords: &["اسب", "چرخ\u{200c}وفلک", "چرخ\u{200c}وفلک اسبی"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("karusellihevonen"),
            keywords: &["hevonen", "karuselli", "karusellihevonen"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("kabayo sa carousel"),
            keywords: &[
                "amusement park",
                "carousel",
                "kabayo",
                "kabayo sa carousel",
                "merry-go-round",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("karusellhestur"),
            keywords: &[
                "hestur",
                "karusell",
                "karusellhestur",
                "tivoli",
                "undirhaldsgarður",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("cheval de manège"),
            keywords: &["cheval", "cheval de manège", "manège"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("cheval de carrousel"),
            keywords: &["carrousel", "cheval", "cheval de carrousel", "manège"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("capall an roithleagáin ró"),
            keywords: &[
                "capall",
                "capall an roithleagáin ró",
                "capall roithleagáin ró",
                "roithleagán ró",
                "siamsaíocht",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("each-timcheallain"),
            keywords: &["each", "each-timcheallain", "timcheallan"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cabaliño de carrusel"),
            keywords: &["cabaliño de carrusel", "cabaliños", "cabalo", "carrusel"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ઘોડાની બ\u{ac7}ઠકવાળો ચકડોળ"),
            keywords: &[
                "ઘોડાની બ\u{ac7}ઠકવાળો ચકડોળ",
                "ઘોડો",
                "ચકડોળ",
                "મનોર\u{a82}જન",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("dokin lilon mai juyawa"),
            keywords: &["doki", "dokin lilon mai juyawa", "lilon mai juyawa"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("סוס בקרוסלה"),
            keywords: &["לונה פארק", "סוס", "סוס בקרוסלה", "קרוסלה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("घोड\u{93c}\u{947} वाला झ\u{942}ला"),
            keywords: &[
                "घोड\u{93c}ा",
                "घोड\u{93c}\u{947} वाला झ\u{942}ला",
                "झ\u{942}ला",
                "मनोर\u{902}जन",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("konjić na vrtuljku"),
            keywords: &["konj", "konjić na vrtuljku", "vrtuljak"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("ló a körhintáról"),
            keywords: &["játék", "körhinta", "ló a körhintáról", "vidámpark"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("կարուսելի ձի"),
            keywords: &["կարուսել", "կարուսելի ձի", "ձի"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("komidi putar"),
            keywords: &["karosel", "komidi putar", "kuda"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("inyịnya igwe okirikiri"),
            keywords: &["inyịnya igwe", "inyịnya igwe okirikiri", "okirikiri"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("hringekjuhestur"),
            keywords: &["hestur", "hringekja", "hringekjuhestur", "skemmtun"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("cavallo da giostra"),
            keywords: &[
                "cavallo",
                "cavallo da giostra",
                "giostra",
                "intrattenimento",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("メリーゴーランド"),
            keywords: &["メリーゴーランド", "遊園地"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("jaran komidhi puter"),
            keywords: &["jaran", "jaran komidhi puter", "komidhi puter"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("კარუსელის ცხენი"),
            keywords: &["კარუსელი", "კარუსელის ცხენი", "ცხენი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("әткеншектегі ат"),
            keywords: &["жылқы", "әткеншек", "әткеншектегі ат"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("karrusel"),
            keywords: &["karrusel", "karruselhest", "karruseltur", "køre i karrusel"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("សេះទោងវ\u{17b7}ល"),
            keywords: &["ទោងវ\u{17b7}ល", "សេះទោងវ\u{17b7}ល", "សេះវ\u{17b7}ល"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕ\u{ccd}ಯರೋಸ\u{cc6}ಲ\u{ccd} ಕುದುರ\u{cc6}"),
            keywords: &[
                "ಏರ\u{cbf}ಳ\u{cbf}ಕ\u{cc6}",
                "ಕುದುರ\u{cc6}",
                "ಕ\u{ccd}ಯರೋಸ\u{cc6}ಲ\u{ccd} ಕುದುರ\u{cc6}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("회전 목마"),
            keywords: &["놀이공원", "목마", "유원지", "회전 목마"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("शर\u{94d}यतीचो घोडो"),
            keywords: &["घोडो", "शर\u{94d}यत", "शर\u{94d}यतीचो घोडो"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("айланкөчөктөгү ат"),
            keywords: &["айланкөчөк", "айланкөчөктөгү ат", "ат"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Karussellpäerdchen"),
            keywords: &["Karussell", "Karussellpäerdchen", "Päerdchen"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ມ\u{ec9}າໝ\u{eb9}ນ"),
            keywords: &["ມ\u{ec9}າໝ\u{eb9}ນ", "ສວນສະໜ\u{eb8}ກ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("karuselės arkliukas"),
            keywords: &["arklys", "karuselė", "karuselės arkliukas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("karuseļa zirdziņš"),
            keywords: &["karuselis", "karuseļa zirdziņš", "zirgs"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("hōiho porowhawhe"),
            keywords: &["hōiho", "porowhawhe"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("коњче од вртелешка"),
            keywords: &["вртелешка", "коњ", "коњче од вртелешка", "рингишпил"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("യന\u{d4d}ത\u{d4d}രക\u{d4d}ക\u{d41}തിര"),
            keywords: &[
                "കറങ\u{d4d}ങ\u{d41}ം ക\u{d41}തിര",
                "ക\u{d41}തിര യന\u{d4d}ത\u{d4d}രം",
                "യന\u{d4d}ത\u{d4d}രക\u{d4d}ക\u{d41}തിര",
                "സവ\u{d3e}രി",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("морин тойруулга"),
            keywords: &["морин тойруулга", "морь"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("फिरत\u{94d}या पट\u{94d}ट\u{94d}यावरील घोडा"),
            keywords: &[
                "घोडा",
                "फिरता पट\u{94d}टा",
                "फिरत\u{94d}या पट\u{94d}ट\u{94d}यावरील घोडा",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("kuda karusel"),
            keywords: &["karusel", "kuda"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("żiemel tal-karusell"),
            keywords: &["karusell", "żiemel", "żiemel tal-karusell"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ချားရဟတ\u{103a} မြင\u{103a}း"),
            keywords: &["ချားရဟတ\u{103a}", "မြင\u{103a}း"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("karusellhest"),
            keywords: &[
                "fornøyelsespark",
                "hest",
                "karusell",
                "karusellhest",
                "tivoli",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("काराउज\u{947}ल घोडा"),
            keywords: &[
                "काराउज\u{947}ल घोडा",
                "घ\u{941}म\u{94d}न\u{947} घोडा",
                "घोडा",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("draaimolenpaard"),
            keywords: &["draaimolen", "draaimolenpaard", "paard"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("karusellhest"),
            keywords: &["hest", "karusell", "karusellhest", "moropark", "tivoli"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଘ\u{b42}ର\u{b4d}ଣ\u{b4d}ଣୟମ\u{b3e}ନ ଘୋଡ\u{b3c}\u{b3e}"),
            keywords: &[
                "ଘ\u{b42}ର\u{b4d}ଣ\u{b4d}ଣନଶୀଳ ବ\u{b3e}ହକ ଯନ\u{b4d}ତ\u{b4d}ର",
                "ଘ\u{b42}ର\u{b4d}ଣ\u{b4d}ଣୟମ\u{b3e}ନ ଘୋଡ\u{b3c}\u{b3e}",
                "ଘୋଡ\u{b3c}\u{b3e}",
                "ବ\u{b3e}ହକ ଘୋଡ\u{b3c}\u{b3e}",
                "ମନୋରଞ\u{b4d}ଜନ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਘ\u{a4b}ੜ\u{a47} ਵਾਲਾ ਝ\u{a42}ਲਾ"),
            keywords: &[
                "ਘ\u{a4b}ੜਾ",
                "ਘ\u{a4b}ੜ\u{a47} ਵਾਲਾ ਝ\u{a42}ਲਾ",
                "ਝ\u{a42}ਲਾ",
                "ਮਨ\u{a4b}ਰ\u{a70}ਜਨ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ہنڈولا گھوڑا"),
            keywords: &["چکر پھیری دی کھیڈ", "گھوڑا", "ہنڈولا گھوڑا"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Hápí-Gó-Raúnd Họs"),
            keywords: &["Hápí-Gó-Raúnd", "Họs"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("koń z karuzeli"),
            keywords: &["konik", "koń z karuzeli"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("کارطوس آس"),
            keywords: &["آس", "کارطوس"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("carrossel"),
            keywords: &[
                "carrossel",
                "cavalo",
                "cavalo de carrossel",
                "entretenimento",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("cavalo de carrossel"),
            keywords: &["carrossel", "cavalo", "cavalo de carrossel"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("carrusel kawallu"),
            keywords: &["carrusel", "kawallu"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("căluț de carusel"),
            keywords: &["carusel", "căluț", "căluț de carusel"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-352"),
            keywords: &["E10-352"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("лошадь на карусели"),
            keywords: &["карусель", "лошадка", "лошадь", "лошадь на карусели"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ifarasi y’igikorano"),
            keywords: &["ifarasi y’igikorano"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("جهولي جو گهوڙو"),
            keywords: &["جهولو، گهوڙو", "جهولي جو گهوڙو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("කැරව\u{dd4}සල\u{dca} අශ\u{dca}වය\u{dcf}"),
            keywords: &["අශ\u{dca}වය\u{dcf}", "කැරව\u{dd4}සල\u{dca}"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("kolotočový kôň"),
            keywords: &["kolotoč", "kolotočový kôň", "kôň"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("konj na vrtiljaku"),
            keywords: &["konj", "konj na vrtiljaku", "vrtiljak"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("faraska farxad wareegga"),
            keywords: &["faras", "faraska farxad wareegga", "farxad wareeg"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("kalë në karusel"),
            keywords: &["kalë", "kalë në karusel", "karusel"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("коњ са вртешке"),
            keywords: &["вртешка", "кoњ", "коњ са вртешке"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["коњ са вртешке"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("konj sa vrteške"),
            keywords: &["konj", "konj sa vrteške", "vrteška"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["konj sa vrteške"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("karusellhäst"),
            keywords: &["häst", "karusell", "karusellhäst"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("farasi inayozunguka"),
            keywords: &["farasi", "farasi inayozunguka", "kuzunguka"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("கேர\u{bbe}சூல\u{bcd} குதிரை"),
            keywords: &[
                "இர\u{bbe}ட\u{bcd}டினம\u{bcd}",
                "குதிரை",
                "கேர\u{bbe}சூல\u{bcd}",
                "பொழுதுபோக\u{bcd}கு",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("క\u{c3e}ర\u{c4b}స\u{c3f}ల\u{c4d} గుర\u{c4d}రం"),
            keywords: &["క\u{c3e}ర\u{c4b}స\u{c3f}ల\u{c4d}", "గుర\u{c4d}రం"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("аспаки чархуфалак"),
            keywords: &["аспак", "аспаки чархуфалак", "чархуфалак"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ม\u{e49}าหม\u{e38}น"),
            keywords: &["ม\u{e49}าหม\u{e38}น", "สวนสน\u{e38}ก"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("karusel aty"),
            keywords: &["at", "karusel", "karusel aty"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("hoosi vaʻinga"),
            keywords: &["hoosi vaʻinga"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("atlıkarınca"),
            keywords: &["at", "atlıkarınca", "atlıkarınca atı", "eğlence"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئايلانما ئۆي"),
            keywords: &["ئايلانما", "ئۆي"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("коник на каруселі"),
            keywords: &["карусель", "коник на каруселі", "кінь"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("گھومتے جھولے کا گھوڑا"),
            keywords: &["جھولا", "گھومتے جھولے کا گھوڑا", "گھومنا", "گھوڑا"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("karusel oti"),
            keywords: &["karusel", "karusel oti", "ot"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("ngựa đu quay"),
            keywords: &["ngựa", "ngựa đu quay", "đu quay ngựa"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("fasu kurusel"),
            keywords: &["fasu", "kurusel"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ihashe lomthayi"),
            keywords: &["ihashe", "ihashe lomthayi", "umthayi"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ẹṣin Aladun"),
            keywords: &["aládùn", "Ẹṣin Aladun", "ẹṣin"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("旋轉木馬"),
            keywords: &["旋轉", "旋轉木馬", "馬"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("旋转木马"),
            keywords: &["旋转", "旋转木马", "马"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("旋转木马"),
            keywords: &["旋转木马", "木马", "游乐园"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("旋轉木馬"),
            keywords: &["旋轉木馬"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ihhashi lekharaseli"),
            keywords: &["ihhashi", "ihhashi lekharaseli", "ikharaseli"],
        },
    ],
};
#[doc = "🎡"]
pub const FERRIS_WHEEL: crate::Emoji = crate::Emoji {
    glyph: "🎡",
    codepoint: "1F3A1",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "ferris wheel",
    group: "Travel & Places",
    subgroup: "place-other",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("ferriswiel"),
            keywords: &["ferris", "ferriswiel", "pretpark", "wiel"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ፌሪስ ዊል እሽክርክሮሽ"),
            keywords: &["መዘውር", "መዝናኛ ፖርክ", "ትልክ መርከብ", "ፌሪስ ዊል እሽክርክሮሽ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("\u{202b}عجلة دوارة"),
            keywords: &[
                "ترفيه",
                "حديقة",
                "دولاب ملاهي",
                "دولاب هواء",
                "عجلة فيريس",
                "\u{202b}عجلة دوارة",
            ],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ফেৰিৰ চক\u{9be}"),
            keywords: &[
                "চক\u{9be}",
                "ফেৰি",
                "ফেৰিৰ চক\u{9be}",
                "বিনোদন উদ\u{9cd}য\u{9be}ন",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("şeytan çarxı"),
            keywords: &["lunapark", "çarx", "şeytan", "şeytan çarxı"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("кола агляду"),
            keywords: &["забаўляльны парк", "кола агляду"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("виенско колело"),
            keywords: &["виенско", "колело", "лунапарк", "увеселителен парк"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("বড\u{9bc}ো ন\u{9be}গরদোল\u{9be}"),
            keywords: &[
                "চ\u{9be}ক\u{9be}",
                "চিত\u{9cd}তবিনোদন প\u{9be}র\u{9cd}ক",
                "ফেরিস",
                "বড\u{9bc}ো ন\u{9be}গরদোল\u{9be}",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("rod vras"),
            keywords: &["rod", "rod vras", "tachenn ar cʼhoarioù"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("ringišpil"),
            keywords: &["ringišpil", "zabavni park"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("roda de fira"),
            keywords: &["fira", "roda", "roda de fira"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏥᏳᏓᏔᎸ ᎦᏆᏙᏗ"),
            keywords: &["ᎠᏰᎵᎢ ᎤᏁᏓᏍᏗᎢ", "ᎦᏆᏘ", "ᏥᏳᏓᏔᎸ ᎦᏆᏙᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("ruské kolo"),
            keywords: &["ruské kolo", "zábavní park"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("olwyn fawr"),
            keywords: &["olwyn", "olwyn fawr", "parc diddanu"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("pariserhjul"),
            keywords: &["forlystelse", "forlystelsespark", "pariserhjul", "tivoli"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Riesenrad"),
            keywords: &["Freizeitpark", "Rad", "Riesenrad", "Volksfest"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ρόδα λούνα-παρκ"),
            keywords: &["λούνα παρκ", "ρόδα", "ρόδα λούνα-παρκ"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("ferris wheel"),
            keywords: &["amusement park", "ferris", "wheel"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: None,
            keywords: &["amusement park", "ferris", "theme park", "wheel"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("Ferris wheel"),
            keywords: &["Ferris", "amusement park", "theme park", "wheel"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("noria de feria"),
            keywords: &[
                "atracciones",
                "entretenimiento",
                "feria",
                "noria",
                "noria de feria",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("noria"),
            keywords: &["diversiones", "mundo", "noria", "parque", "vuelta"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("rueda de la fortuna"),
            keywords: &["rueda de la fortuna"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("vaateratas"),
            keywords: &["lõbustuspark", "vaateratas"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("noria"),
            keywords: &["gurpil", "jolas", "noria", "parke"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("چرخ\u{200c}وفلک"),
            keywords: &["شهر بازی", "چرخ", "چرخ و فلک", "چرخ\u{200c}وفلک"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("maailmanpyörä"),
            keywords: &["huvipuisto", "maailmanpyörä"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("ferris wheel"),
            keywords: &["amusement park", "ferris", "ferris wheel", "gulong"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("parísarhjól"),
            keywords: &["parísarhjól", "tivoli", "undirhaldsgarður"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("grande roue"),
            keywords: &["grande roue", "roue"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["grande roue", "parc d’attractions"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("roth Ferris"),
            keywords: &[
                "páirc siamsaíochta",
                "roth Ferris",
                "roth mór",
                "siamsaíochta",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("roth-mòr"),
            keywords: &["cuibhle", "pàirc fhaoin-chleasan", "roth-mòr"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("nora"),
            keywords: &["nora", "noria", "parque de atraccións"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ફ\u{ac7}રીસ વ\u{acd}હીલ"),
            keywords: &[
                "એમ\u{acd}ય\u{ac1}ઝમ\u{ac7}ન\u{acd}ટ પાર\u{acd}ક",
                "ચગડોળ",
                "પ\u{ac8}ડ\u{ac1}\u{a82}",
                "ફ\u{ac7}રીસ",
                "ફ\u{ac7}રીસ વ\u{acd}હીલ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("babban lilo"),
            keywords: &["babban", "lilo", "wurin shaƙatawa"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("גלגל ענק"),
            keywords: &["גלגל ענק", "לונה פארק"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("फ\u{93c}\u{947}रीज झ\u{942}ला"),
            keywords: &[
                "झ\u{942}ला",
                "फ\u{93c}\u{947}रीज",
                "बड\u{93c}ा ऊ\u{902}चा झ\u{942}ला",
                "मनोर\u{902}जन",
                "मनोर\u{902}जन पार\u{94d}क",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("panoramski kotač"),
            keywords: &["kotač", "panorama", "panoramski kotač", "zabavni park"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("óriáskerék"),
            keywords: &["játék", "vidámpark", "óriáskerék"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("սատանայի անիվ"),
            keywords: &["անիվ", "զվարճանքների այգի", "սատանայի"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("kincir ria"),
            keywords: &["hiburan", "kincir", "kincir ria", "roda", "taman"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ụkwụ ferris"),
            keywords: &["ama egwuregwu", "ferris", "ụkwụ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("parísarhjól"),
            keywords: &["parísarhjól", "skemmtigarður", "skemmtun"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("ruota panoramica"),
            keywords: &[
                "intrattenimento",
                "panoramica",
                "parco divertimenti",
                "ruota",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("観覧車"),
            keywords: &["観覧車", "遊園地"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("jinantra"),
            keywords: &["jinantra", "rodha", "taman hiburan"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ეშმაკის ბორბალი"),
            keywords: &["ბორბალი", "გასართობი პარკი", "ეშმაკი", "ეშმაკის ბორბალი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("сайтан доңғалағы"),
            keywords: &["доңғалақ", "ойын-сауық паркі", "сайтан доңғалағы", "феррис"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("pariserhjul"),
            keywords: &["forlystelse", "forlystelsespark", "pariserhjul", "tivoli"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("កន\u{17d2}ត\u{17d2}រកវ\u{17b7}ល"),
            keywords: &[
                "កន\u{17d2}ត\u{17d2}រកវ\u{17b7}ល",
                "ទោងវ\u{17b7}ល",
                "ស\u{17bd}នកម\u{17d2}សាន\u{17d2}ត",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಫ\u{cc6}ರ\u{cbf}ಸ\u{ccd} ವೀಲ\u{ccd}"),
            keywords: &[
                "ಚಕ\u{ccd}ರ",
                "ಫ\u{cc6}ರ\u{cbf}ಸ\u{ccd} ವೀಲ\u{ccd}",
                "ಮನರಂಜನಾ ಪಾರ\u{ccd}ಕ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("관람차"),
            keywords: &["관람차", "놀이공원", "유원지"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("जात\u{94d}र\u{947}तल\u{947}\u{902} चाक"),
            keywords: &[
                "चाक",
                "जात\u{94d}रा",
                "जात\u{94d}र\u{947}तल\u{947}\u{902} चाक",
                "मनरिजवण उद\u{94d}यान",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("шайтан дөңгөлөгү"),
            keywords: &["дөңгөлөк", "көңүл ачуу сейилбагы", "шайтан дөңгөлөгү"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Riserad"),
            keywords: &["Fouer", "Fräizäitpark", "Rad", "Riserad"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຊ\u{eb4}ງຊ\u{ec9}າສະຫວ\u{eb1}ນ"),
            keywords: &["ຊ\u{eb4}ງຊ\u{ec9}າສະຫວ\u{eb1}ນ", "ສວນສະໜ\u{eb8}ກ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("apžvalgos ratas"),
            keywords: &["apžvalgos", "atrakcionų parkas", "ratas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("panorāmas rats"),
            keywords: &["atrakciju parks", "panorāma", "panorāmas rats", "rats"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("wīra pērihi"),
            keywords: &["papa whakangahau", "pērihi", "wīra"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("панорамско тркало"),
            keywords: &["забавен парк", "панорама", "панорамско тркало", "тркало"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഫെരിസ\u{d4d} വീൽ"),
            keywords: &[
                "കറങ\u{d4d}ങ\u{d41}ം ക\u{d41}തിര",
                "ക\u{d41}തിര യന\u{d4d}ത\u{d4d}രം",
                "ഫെരിസ\u{d4d} വീൽ",
                "സവ\u{d3e}രി",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("алсыг харагч"),
            keywords: &["алсыг харагч", "соёл амралтын хүрээлэн"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("आकाश पाळणा"),
            keywords: &[
                "आकाश पाळणा",
                "आकाशपाळणा",
                "करमण\u{942}क पार\u{94d}क",
                "पाळणा",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("roda ferris"),
            keywords: &["ferris", "roda", "taman hiburan"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("ferris wheel"),
            keywords: &["ferris", "ferris wheel", "park tad-divertiment", "rota"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ချားရဟတ\u{103a}"),
            keywords: &[
                "ချားရဟတ\u{103a}",
                "ပျော\u{103a}ပ\u{103d}\u{1032}ရ\u{103d}\u{103e}င\u{103a}ပ\u{103d}\u{1032} ပန\u{103a}းခြ\u{1036}",
                "ရဟတ\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("pariserhjul"),
            keywords: &["fornøyelsespark", "pariserhjul", "tivoli"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("फ\u{947}र\u{94d}रिस चक\u{94d}र"),
            keywords: &[
                "चक\u{94d}र",
                "फ\u{947}र\u{94d}रिस",
                "मनोरञ\u{94d}जन पार\u{94d}क",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("reuzenrad"),
            keywords: &["pretpark", "rad", "reuzenrad"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("pariserhjul"),
            keywords: &["moropark", "pariserhjul", "tivoli"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଫେର\u{b3f}ସ\u{b4d} ହ\u{b4d}ୱ\u{b3f}ଲ\u{b4d}"),
            keywords: &[
                "ଚକ",
                "ଫେର\u{b3f}ସ\u{b4d} ହ\u{b4d}ୱ\u{b3f}ଲ\u{b4d}",
                "ଫେର\u{b3f}ସ\u{b4d}\u{200c}",
                "ମନୋରଞ\u{b4d}ଜନ ପ\u{b3e}ର\u{b4d}କ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਫ\u{a47}ਰੀਸ ਚ\u{a71}ਕਰ"),
            keywords: &[
                "ਚ\u{a71}ਕਰ",
                "ਫ\u{a47}ਰੀਸ",
                "ਮਨ\u{a4b}ਰ\u{a70}ਜਨ",
                "ਮਨ\u{a4b}ਰ\u{a70}ਜਨ ਪਾਰਕ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("فیرس وہیل"),
            keywords: &["تفریحی پارک", "فیرس وہیل", "پہیہ", "ہنڈولا"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Fẹ\u{301}rís Wiil"),
            keywords: &[
                "Amiúzmẹ\u{301}nt Pak",
                "Fẹ\u{301}ris",
                "Fẹ\u{301}rís Wiil",
                "Wiil",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("diabelski młyn"),
            keywords: &[
                "diabelski",
                "karuzela",
                "młyn",
                "park rozrywki",
                "wesołe miasteczko",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د فيرس پايه"),
            keywords: &["د فيرس پايه", "د لوبو ټوقو پارک", "فيرس", "پايه"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("roda gigante"),
            keywords: &["entretenimento", "gigante", "parque de diversões", "roda"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["gigante", "parque de diversões", "roda"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("noria qhatunapi"),
            keywords: &["jawka parque", "muyu", "noria", "noria qhatunapi"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("roata mare"),
            keywords: &[
                "bâlci",
                "carnaval",
                "distracție",
                "parc de distracție",
                "roata mare",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-353"),
            keywords: &["E10-353"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("колесо обозрения"),
            keywords: &["колесо", "колесо обозрения", "чертово"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ipine rinini"),
            keywords: &["ahantu nyaburanga", "bicundaho", "icyuma", "ipine rinini"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("فيرس ڦيٿو"),
            keywords: &["تفريحي پارڪ", "فيرس", "ڦيٿو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ෆෙර\u{dd2}ස\u{dca} රෝදය"),
            keywords: &["රෝදය", "ව\u{dd2}නෝද උයන", "ෆෙර\u{dd2}ස\u{dca}"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("ruské koleso"),
            keywords: &["koleso", "lunapark", "ruské"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("panoramsko kolo"),
            keywords: &["lunapark", "panoramsko kolo"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("shaagga gaariga markabka"),
            keywords: &[
                "carwada maddadaalada",
                "gaariga markabka",
                "shaagga",
                "shaagga gaariga markabka",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("rrotullame"),
            keywords: &["park lojërash", "rrotullame"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("панорамска вртешка"),
            keywords: &["вртешка", "зaбaвни пaрк", "панорамска вртешка"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["панорамска вртешка"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("panoramska vrteška"),
            keywords: &["panoramska vrteška", "vrteška", "zabavni park"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["panoramska vrteška"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("pariserhjul"),
            keywords: &["karusell", "nöjespark", "pariserhjul"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("gurudumu linalozunguka"),
            keywords: &[
                "ferris",
                "gurudumu",
                "gurudumu linalozunguka",
                "sehemu za burudani",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ஃபெர\u{bcd}ரிஸ\u{bcd} சக\u{bcd}கரம\u{bcd}"),
            keywords: &[
                "ஃபெர\u{bcd}ரிஸ\u{bcd}",
                "சக\u{bcd}கரம\u{bcd}",
                "பூங\u{bcd}க\u{bbe}",
                "பொழுதுபோக\u{bcd}கு",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("రంగుల ర\u{c3e}ట\u{c4d}నం"),
            keywords: &["రంగు", "రంగుల ర\u{c3e}ట\u{c4d}నం", "ర\u{c3e}ట\u{c4d}నం"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("чархуфалак"),
            keywords: &["парки фароғатӣ", "феррис", "чарх", "чархуфалак"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ช\u{e34}งช\u{e49}าสวรรค\u{e4c}"),
            keywords: &["ช\u{e34}งช\u{e49}าสวรรค\u{e4c}", "สวนสน\u{e38}ก"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("şeýtan çarhy"),
            keywords: &["dynç alyş seýilgähi", "tigir", "şeýtan çarhy"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("veʻeteka vaʻinga"),
            keywords: &["veʻeteka vaʻinga"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("dönme dolap"),
            keywords: &["dolap", "dönme", "eğlence", "eğlence parkı"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئويۇن چاقپەلىكى"),
            keywords: &["ئويۇن چاقپەلىكى", "كۆڭۈل ئېچىش", "چاق", "چۆرۈلمە"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("чортове колесо"),
            keywords: &["колесо", "огляд", "парк розваг", "чортове колесо"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("آسمانی جھولا"),
            keywords: &["آسمانی جھولا", "جھولا", "پارک", "پہیہ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("charxpalak"),
            keywords: &["charxpalak", "ko‘ngilochar park"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("vòng đu quay"),
            keywords: &["bánh xe", "công viên giải trí", "vòng đu quay", "đu quay"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("pëno bu kawe lool"),
            keywords: &["barabu bégal xol", "kawe lool", "pëno", "pëno bu kawe lool"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ivili le-ferris"),
            keywords: &[
                "i-ferris",
                "ipaki yokuzonwabisa",
                "ivili",
                "ivili le-ferris",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Kẹ\u{300}kẹ\u{301} Ferris"),
            keywords: &[
                "Kẹ\u{300}kẹ\u{301} Ferris",
                "ferris",
                "páàkì ìgbafẹ\u{301}",
                "róboto",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("摩天輪"),
            keywords: &["摩天輪", "輪", "遊樂場"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("摩天轮"),
            keywords: &["摩天轮", "游乐场", "轮"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("摩天轮"),
            keywords: &["摩天轮", "游乐园"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("摩天輪"),
            keywords: &["摩天輪"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("isondo leferisi"),
            keywords: &["iferisi", "isondo", "isondo leferisi"],
        },
    ],
};
#[doc = "🎢"]
pub const ROLLER_COASTER: crate::Emoji = crate::Emoji {
    glyph: "🎢",
    codepoint: "1F3A2",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "roller coaster",
    group: "Travel & Places",
    subgroup: "place-other",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("tuimeltrein"),
            keywords: &["pretpark", "trein", "tuimel", "tuimeltrein"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ሮለር ኮስተር እሽክርክሮሽ"),
            keywords: &["መዝናኛ ፖርክ", "ሮለር", "ሮለር ኮስተር እሽክርክሮሽ", "ኮስተር"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("قطار ملاهي"),
            keywords: &["ترفيه", "حديقة", "قطار", "قطار ملاهي"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ৰ’ল\u{9be}ৰ ক’ষ\u{9cd}ট\u{9be}ৰ"),
            keywords: &[
                "কষ\u{9cd}ট\u{9be}ৰ",
                "বিনোদন উদ\u{9cd}য\u{9be}ন",
                "ৰ’ল\u{9be}ৰ",
                "ৰ’ল\u{9be}ৰ ক’ষ\u{9cd}ট\u{9be}ৰ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("maneəli dəmir yolu attraksionu"),
            keywords: &[
                "attraksion",
                "lunapark",
                "maneəli dəmir yolu attraksionu",
                "çarx",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("амерыканскія горкі"),
            keywords: &[
                "амерыканскія горкі",
                "атракцыён",
                "горка",
                "забаўляльны парк",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("влакче в увеселителен парк"),
            keywords: &[
                "влакче",
                "влакче в увеселителен парк",
                "лунапарк",
                "увеселителен парк",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("রোল\u{9be}র কোস\u{9cd}ট\u{9be}র"),
            keywords: &[
                "কোস\u{9cd}ট\u{9be}র",
                "চিত\u{9cd}তবিনোদন প\u{9be}র\u{9cd}ক",
                "রোল\u{9be}র",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("sav-diskenn"),
            keywords: &["sav-diskenn", "tachenn ar cʼhoarioù"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("voz smrti"),
            keywords: &["tobogan smrti", "voz", "voz smrti", "zabavni park"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("muntanya russa"),
            keywords: &["muntanya", "parc d’atraccions", "russa"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏚᎨᏓᎵᏍᏛ ᎠᏦᏙᏗ"),
            keywords: &["ᎠᏦᏙᏗ", "ᎠᏰᎵᎢ ᎤᏁᏓᏍᏗᎢ", "ᏚᎨᏓᎵᏍᏛ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("horská dráha"),
            keywords: &["horská dráha", "zábavní park"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("cert sglefrio"),
            keywords: &["cert", "parc diddanu", "sglefrio"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("rutsjebane"),
            keywords: &["forlystelse", "forlystelsespark", "rutsjebane", "tivoli"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Achterbahn"),
            keywords: &["Achterbahn", "Freizeitpark", "Volksfest"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("τρενάκι"),
            keywords: &["λούνα παρκ", "τρενάκι"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("roller coaster"),
            keywords: &["amusement park", "coaster", "roller"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: Some("rollercoaster"),
            keywords: &[
                "amusement park",
                "coaster",
                "roller",
                "rollercoaster",
                "theme park",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("montaña rusa"),
            keywords: &[
                "atracciones",
                "entretenimiento",
                "feria",
                "montaña rusa",
                "parque",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["diversiones", "montaña", "parque", "rusa"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &[
                "feria",
                "montaña rusa",
                "parque",
                "parque de atracciones",
                "rusa",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["montaña rusa", "parque de diversiones"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("Ameerika mäed"),
            keywords: &["Ameerika", "lõbustuspark", "mäed"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("errusiar mendia"),
            keywords: &["errusiar", "errusiar mendia", "jolas", "mendi", "parke"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("ترن هوایی"),
            keywords: &["ترن هوایی", "رولر", "شهر بازی"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("vuoristorata"),
            keywords: &["huvipuisto", "vuoristorata"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("roller coaster"),
            keywords: &["amusement park", "coaster", "roller"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("russjibani"),
            keywords: &[
                "glíðibreyt",
                "russjibani",
                "tivoli",
                "undirhaldsgarður",
                "øka",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("montagnes russes"),
            keywords: &["montagnes", "russes"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["montagnes", "parc d’attractions", "russes"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("rollchóstóir"),
            keywords: &[
                "aonach",
                "páirc siamsaíochta",
                "rollchóstóir",
                "siamsaíocht",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("rolair-còrsair"),
            keywords: &[
                "còrsair",
                "pàirc fhaoin-chleasan",
                "rolair",
                "rolair-còrsair",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("montaña rusa"),
            keywords: &["montaña rusa", "parque de atraccións"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("રોલર કોસ\u{acd}ટર"),
            keywords: &[
                "એમ\u{acd}ય\u{ac1}ઝમ\u{ac7}ન\u{acd}ટ પાર\u{acd}ક",
                "કોસ\u{acd}ટર",
                "મનોર\u{a82}જન",
                "રોલર",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("motocin masa masu juyawa"),
            keywords: &[
                "masu juyawa",
                "motocin masa masu juyawa",
                "motocin wasa",
                "wurin shaƙatawa",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("רכבת הרים"),
            keywords: &["לונה פארק", "רכבת הרים"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("रोलर कोस\u{94d}टर"),
            keywords: &[
                "कोस\u{94d}टर",
                "मनोर\u{902}जन",
                "मनोर\u{902}जन पार\u{94d}क",
                "रोलर",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("vlak smrti"),
            keywords: &["smrt", "vlak", "vlak smrti", "zabavni park"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("hullámvasút"),
            keywords: &["hullámnvasút", "hullámvasút", "játék", "vidámpark"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ամերիկյան բլուրներ"),
            keywords: &["ամերիկյան", "բլուրներ", "զվարճանքների այգի"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("roller coaster"),
            keywords: &["coaster", "hiburan", "roller", "taman"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("igwe egwuregwu mkpọda"),
            keywords: &[
                "ama egwuregwu",
                "igwe egwuregwu",
                "igwe egwuregwu mkpọda",
                "mkpọda",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("rússíbani"),
            keywords: &["rússíbani", "skemmtigarður", "skemmtun"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("montagne russe"),
            keywords: &["intrattenimento", "montagne", "parco divertimenti", "russe"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ジェットコースター"),
            keywords: &["ジェットコースター", "遊園地"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("kreta sluncur"),
            keywords: &["kreta", "sluncur", "taman hiburan"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ამერიკული გორაკები"),
            keywords: &["ამერიკული გორაკები", "ატრაქციონი", "გასართობი პარკი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("аттракцион"),
            keywords: &["аттракцион", "доңғалақ", "ойын-сауық паркі"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("rutsjebane"),
            keywords: &["forlystelse", "forlystelsespark", "rutsjebane", "tivoli"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("រទេះភ\u{17d2}លើងហោះ (សម\u{17d2}រាប\u{17cb}កម\u{17d2}សាន\u{17d2}ត)"),
            keywords: &[
                "រថភ\u{17d2}លើងហោះ",
                "រទេះភ\u{17d2}លើងហោះ",
                "រទេះភ\u{17d2}លើងហោះ (សម\u{17d2}រាប\u{17cb}កម\u{17d2}សាន\u{17d2}ត)",
                "ស\u{17bd}នកម\u{17d2}សាន\u{17d2}ត",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ರೋಲರ\u{ccd} ಕೋಸ\u{ccd}ಟರ\u{ccd}"),
            keywords: &[
                "ಮನರಂಜನಾ ಪಾರ\u{ccd}ಕ\u{ccd}",
                "ರೋಲರ\u{ccd} ಕೋಸ\u{ccd}ಟರ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("롤러코스터"),
            keywords: &["놀이공원", "롤러코스터", "유원지"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("रोलर कोस\u{94d}टर"),
            keywords: &["कोस\u{94d}टर", "मनरिजवण उद\u{94d}यान", "रोलर"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("америка тоосу"),
            keywords: &["америка жылгаягы", "америка тоосу", "көңүл ачуу сейил багы"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Achterbahn"),
            keywords: &["Achterbahn", "Fräizäitpark"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ລ\u{ebb}ດໄຟເຫາະ"),
            keywords: &["ລ\u{ebb}ດໄຟເຫາະ", "ສວນສະໜ\u{eb8}ກ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("linksmieji kalneliai"),
            keywords: &["atrakcionų parkas", "kalneliai", "linksmieji"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("amerikāņu kalniņi"),
            keywords: &["amerikāņu kalniņi", "atrakciju parks"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tereina tō-ā-papa whakangahau"),
            keywords: &[
                "papa whakangahau",
                "pūkawe",
                "takataka",
                "tereina tō-ā-papa whakangahau",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("тобоган"),
            keywords: &["забавен парк", "тобоган"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("റോളർ കോസ\u{d4d}റ\u{d4d}റർ"),
            keywords: &["പ\u{d3e}ർക\u{d4d}ക\u{d4d}", "റോളർ കോസ\u{d4d}റ\u{d4d}റർ"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("галзуу хулгана"),
            keywords: &["галзуу хулгана", "соёл амралтын хүрээлэн"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("रोलर कोस\u{94d}टर"),
            keywords: &["करमण\u{942}क पार\u{94d}क", "कोस\u{94d}टर", "रोलर"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("roller coaster"),
            keywords: &["coaster", "roller", "taman hiburan"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("roller coaster"),
            keywords: &["coaster", "park tad-divertiment", "roller"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("သည\u{103a}းဖ\u{102d}\u{102f}ရထား"),
            keywords: &[
                "က\u{102d}\u{102f}စတာ",
                "ပျော\u{103a}ပ\u{103d}\u{1032}ရ\u{103d}\u{103e}င\u{103a}ပ\u{103d}\u{1032} ပန\u{103a}းခြ\u{1036}",
                "ရ\u{102d}\u{102f}လာ",
                "သည\u{103a}းဖ\u{102d}\u{102f}ရထား",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("berg-og-dal-bane"),
            keywords: &["berg-og-dal-bane", "fornøyelsespark", "tivoli"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("रोलर कोस\u{94d}टर"),
            keywords: &[
                "कोस\u{94d}टर",
                "मनोरञ\u{94d}जन पार\u{94d}क",
                "रोलर कोस\u{94d}टर",
                "रोल\u{94d}लर",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("achtbaan"),
            keywords: &["achtbaan", "baan", "pretpark"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("berg-og-dal-bane"),
            keywords: &["berg-og-dal-bane", "moropark", "tivoli"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ରୋଲର\u{b4d}\u{200c} କୋଷ\u{b4d}ଟର\u{b4d}\u{200c}"),
            keywords: &[
                "ଉପକ\u{b42}ଳବ\u{b3e}ହୀ ଜ\u{b3e}ହ\u{b3e}ଜ",
                "ମନୋରଞ\u{b4d}ଜନ ପ\u{b3e}ର\u{b4d}କ",
                "ରୋଲର\u{b4d}\u{200c}",
                "ରୋଲର\u{b4d}\u{200c} କୋଷ\u{b4d}ଟର\u{b4d}\u{200c}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਰ\u{a4b}ਲਰ ਕ\u{a4b}ਸਟਰ"),
            keywords: &[
                "ਕ\u{a70}ਢਾ",
                "ਮਨ\u{a4b}ਰ\u{a70}ਜਨ",
                "ਮਨ\u{a4b}ਰ\u{a70}ਜਨ ਪਾਰਕ",
                "ਰ\u{a4b}ਲਰ",
                "ਰ\u{a4b}ਲਰ ਕ\u{a4b}ਸਟਰ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("تفریحی پارک وچ لگی بالاں دی ریل"),
            keywords: &[
                "تفریحی پارک",
                "تفریحی پارک وچ لگی بالاں دی ریل",
                "کوسٹر",
                "گول گھمدا ہوئیا",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Rólá Kósta"),
            keywords: &["Amiúzmẹ\u{301}nt Pak", "Kósta", "Róla", "Rólá Kósta"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("kolejka górska"),
            keywords: &["kolejka górska", "park rozrywki", "wesołe miasteczko"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("رولر کوستر"),
            keywords: &["رولر کوستر"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("montanha russa"),
            keywords: &["entretenimento", "montanha", "parque de diversões", "russa"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("montanha-russa"),
            keywords: &["montanha-russa", "parque de diversões"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("montaña rusa"),
            keywords: &["jawka parque", "montaña rusa", "muyuq"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("montagne russe"),
            keywords: &["adrenalină", "montagne russe", "parc de distracție"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-354"),
            keywords: &["E10-354"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("американские горки"),
            keywords: &["американские", "горки"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umwicungo"),
            keywords: &[
                "ahatu nyaburanga",
                "imashini iringaniza",
                "umwicungo",
                "utuye ku nkengero",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("رولر ڪوسٽر"),
            keywords: &["تفريحي پارڪ", "رولر", "ڪوسٽر"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("රෝලර\u{dca} කෝස\u{dca}ටර\u{dca}"),
            keywords: &["කෝස\u{dca}ටර\u{dca}", "රෝලර\u{dca}", "ව\u{dd2}නෝද උයන"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("horská dráha"),
            keywords: &["dráha", "horská dráha", "lunapark"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("vlakec smrti"),
            keywords: &["lunapark", "vlak smrti", "vlakec smrti"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("dusha sare ee tareeka"),
            keywords: &["carwada maddadaalada", "dusha sare ee tareeka"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("tren lojërash me valëzim"),
            keywords: &["park lojërash", "tren lojërash", "tren lojërash me valëzim"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("ролеркостер"),
            keywords: &["воз", "зaбaвни пaрк", "ролеркостер"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("rolerkoster"),
            keywords: &["rolerkoster", "voz", "zabavni park"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("berg- och dalbana"),
            keywords: &["berg- och dalbana", "karusell", "nöjespark"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("rola kosta"),
            keywords: &[
                "gurudumu",
                "rola kosta",
                "sehemu za burudani",
                "viti vinavyozunguka",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ரோலர\u{bcd} கோஸ\u{bcd}டர\u{bcd}"),
            keywords: &[
                "கோஸ\u{bcd}டர\u{bcd}",
                "பூங\u{bcd}க\u{bbe}",
                "பொழுதுபோக\u{bcd}கு",
                "பொழுதுபோக\u{bcd}குப\u{bcd} பூங\u{bcd}க\u{bbe}",
                "ரோலர\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ర\u{c4b}లర\u{c4d} క\u{c4b}స\u{c4d}టర\u{c4d}"),
            keywords: &["క\u{c4b}స\u{c4d}టర\u{c4d}", "ర\u{c4b}లర\u{c4d}"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("роҳи оҳани лағжишбозӣ"),
            keywords: &[
                "каток",
                "лағжишбозӣ",
                "парки фароғатӣ",
                "роҳи оҳани лағжишбозӣ",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("รถไฟเหาะ"),
            keywords: &["รถไฟเหาะ", "สวนสน\u{e38}ก", "โรลเลอร\u{e4c}โคสเตอร\u{e4c}"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("Amerikan gorkisi"),
            keywords: &[
                "Amerikan gorkisi",
                "dynç alyş seýilgähi",
                "gorka",
                "typançak",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("lola vaʻinga"),
            keywords: &["lola vaʻinga"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("hız treni"),
            keywords: &["eğlence", "eğlence parkı", "hız", "hız treni", "tren"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ھاھۇ پەلەك"),
            keywords: &["ئايلانما", "كۆڭۈل ئېچىش", "ھاھۇ پەلەك"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("американські гірки"),
            keywords: &[
                "американський",
                "американські гірки",
                "гірки",
                "парк розваг",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("رولر کوسٹر"),
            keywords: &["رولر", "پارک", "کوسٹر"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("g‘ildiratma hayinchak"),
            keywords: &["g‘ildiratma", "hayinchak", "ko‘ngilochar park"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("tàu lượn siêu tốc"),
            keywords: &[
                "con lăn",
                "công viên giải trí",
                "tàu lao dốc",
                "tàu lượn siêu tốc",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("tundu risi"),
            keywords: &["barabu bégal xol", "risi", "tundu"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("umahla-ndeyuka"),
            keywords: &["ipaki yokuzonwabisa", "ndenyuka", "umahla-ndeyuka", "umhla"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Kẹkẹ Olobiri"),
            keywords: &["Kẹkẹ Olobiri", "olóbírí", "páàkì ìgbafẹ\u{301}", "yíyí"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("過山車"),
            keywords: &["滾筒", "貨船", "遊樂場", "過山車"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("过山车"),
            keywords: &["游乐场", "滚筒", "货船", "过山车"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("过山车"),
            keywords: &["游乐园", "过山车"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("雲霄飛車"),
            keywords: &["雲霄飛車"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("過山車"),
            keywords: &["過山車"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("i-roller coaster"),
            keywords: &["i-roller coaster", "ipaki", "okokushushuluza"],
        },
    ],
};
#[doc = "💈"]
pub const BARBER_POLE: crate::Emoji = crate::Emoji {
    glyph: "💈",
    codepoint: "1F488",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "barber pole",
    group: "Travel & Places",
    subgroup: "place-other",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("barbierpaal"),
            keywords: &["barbier", "barbierpaal", "haarsny", "paal"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የጸጉር አስተካካይ ስልክ እንጨት"),
            keywords: &["ስልክ እንጨት", "የጸጉር አስተካካይ ስልክ እንጨት", "ጸጉር መቆረጥ", "ጸጉር ቆራጭ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("محل حلاقة"),
            keywords: &["حلاق", "شارة", "محل حلاقة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ন\u{9be}পিতৰ পোল"),
            keywords: &[
                "চ\u{9c1}লি কট\u{9be}",
                "ন\u{9be}পিত",
                "ন\u{9be}পিতৰ পোল",
                "পোল",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("şlaqbaum"),
            keywords: &["bərbər", "saç düzümü", "sütun", "şlaqbaum"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("каляровы слуп"),
            keywords: &[
                "барбершоп",
                "знак цырульні",
                "каляровы слуп",
                "слуп",
                "цырульня",
                "цырульнік",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("знак на бръснар"),
            keywords: &["бръснар", "знак", "знак на бръснар"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ন\u{9be}পিতের পোল"),
            keywords: &[
                "চ\u{9c1}ল ক\u{9be}ট\u{9be}",
                "ন\u{9be}পিত",
                "ন\u{9be}পিতের পোল",
                "পোল",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("barr-ti barver"),
            keywords: &["barr-ti", "barver"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("oznaka berbernice"),
            keywords: &["berbernica", "oznaka berbernice", "znak", "šišanje"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("barberia"),
            keywords: &["barber", "barberia", "pal", "tallada de cabells"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏗᏓᏍᏙᏰᏍᎩ ᎨᏛᎢ"),
            keywords: &["ᎠᏥᏍᏙᏰᎥᎢ", "ᎨᏛᎢ", "ᏗᏓᏍᏙᏰᏍᎩ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("značka holičství"),
            keywords: &["holič", "stříhání", "tyč", "značka holičství"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("polyn barbwr"),
            keywords: &["barbwr", "polyn", "toriad gwallt"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("barber"),
            keywords: &["barber", "barbersalon"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Barbershop-Säule"),
            keywords: &["Barbershop-Säule", "Herrenfriseur", "Säule"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("σύμβολο κουρείου"),
            keywords: &["κοντάρι", "κουρέας", "κούρεμα", "σύμβολο κουρείου"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("barber pole"),
            keywords: &["barber", "haircut", "pole"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: Some("barber’s pole"),
            keywords: &["barber", "barber’s pole", "haircut", "pole"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("barber pole"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("poste de barbero"),
            keywords: &[
                "barbero",
                "barbería",
                "peluquero",
                "poste",
                "poste de barbero",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("barbería"),
            keywords: &["barbero", "barbería", "peluquería"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("peluquería"),
            keywords: &["peluquería"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("signo de barbería"),
            keywords: &["barbero", "barbería", "peluquería", "signo de barbería"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("habemeajaja tähis"),
            keywords: &["habemeajaja", "habemeajaja tähis", "juuksur"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("bizarginaren adierazle birakaria"),
            keywords: &[
                "adierazle",
                "bizar",
                "bizargin",
                "bizarginaren adierazle birakaria",
                "moztu",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("چراغ سلمانی"),
            keywords: &["آرایشگر", "سلمانی", "نماد", "چراغ", "کوتاه کردن مو"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("punasiniraitainen pylväs"),
            keywords: &["kampaaja", "parturi", "punasiniraitainen pylväs", "raidat"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("barber pole"),
            keywords: &[
                "barber pole",
                "barbero",
                "buhok",
                "gupit",
                "pagpapagupit ng buhok",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("hárskeraskelti"),
            keywords: &["hárklipping", "hárskeraskelti", "hárskering"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("enseigne de barbier"),
            keywords: &["barbier", "coiffure", "enseigne", "enseigne de barbier"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["barbier", "coiffure", "enseigne", "enseigne de barbier"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("cuaille bearbóra"),
            keywords: &[
                "bearbóir",
                "cuaille bearbóra",
                "gruagaire",
                "pol an bhearbóra",
                "siopa an bhearbóra",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("pòla barbair"),
            keywords: &["barbair", "cliop", "gruagaire", "pòla"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("poste de barbeiro"),
            keywords: &[
                "barbaría",
                "barbeiro",
                "barbería",
                "poste de barbeiro",
                "salón de peiteado",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("વાળ\u{a82}દની દ\u{ac1}કાન"),
            keywords: &[
                "થા\u{a82}ભલો",
                "વાળ\u{a82}દ",
                "વાળ\u{a82}દની દ\u{ac1}કાન",
                "વાળ\u{a82}દનો થા\u{a82}ભલો",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("sandar mai aski"),
            keywords: &["aski", "mai aski", "sanda", "sandar mai aski"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("עמוד מספרה"),
            keywords: &["מספרה", "עמוד מספרה", "תספורת"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("बार\u{94d}बर पोल"),
            keywords: &["नाई", "नाई की द\u{941}कान", "पोल", "बार\u{94d}बर पोल"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("stup koji označava brijačnicu"),
            keywords: &["brijač", "frizer", "stup", "stup koji označava brijačnicu"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("fodrászcégér"),
            keywords: &["borbély", "cégér", "fodrász", "fodrászcégér", "hajvágás"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("վարսավիրի ձող"),
            keywords: &["ձող", "սանրվածք", "վարսավիր", "վարսավիրի ձող"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("tanda salon"),
            keywords: &["potong", "rambut", "salon", "tanda salon", "tiang"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("osisi onye ọkpụ isi"),
            keywords: &["osisi", "osisi onye ọkpụ isi", "ọkpụ isi", "ọkpụkpụisi"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("rakarastofa"),
            keywords: &["rakarastofa", "rakari"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("barbiere"),
            keywords: &["barbiere", "insegna"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("床屋"),
            keywords: &[
                "バーバー",
                "ヘアサロン",
                "床屋",
                "理髪店",
                "美容室",
                "美容院",
            ],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("panandha kiyose tukang cukur"),
            keywords: &[
                "cukur rambut",
                "panandha",
                "panandha kiyose tukang cukur",
                "tukang cukur",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("დალაქის სვეტი"),
            keywords: &[
                "დალაქი",
                "დალაქის სვეტი",
                "თმის შეჭრა",
                "პარიკმახერი",
                "სვეტი",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("шаштараз бағаны"),
            keywords: &["баған", "шаш қидыру", "шаштараз", "шаштараз бағаны"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("barber"),
            keywords: &["barber", "barbersalon"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("បង\u{17d2}គោលនៅកន\u{17d2}លែងកាត\u{17cb}សក\u{17cb}"),
            keywords: &[
                "កាត\u{17cb}សក\u{17cb}",
                "ជាងកាត\u{17cb}សក\u{17cb}",
                "បង\u{17d2}គោល",
                "បង\u{17d2}គោលនៅកន\u{17d2}លែងកាត\u{17cb}សក\u{17cb}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಬಾರ\u{ccd}ಬರ\u{ccd} ಪೋಲ\u{ccd}"),
            keywords: &[
                "ಕ\u{ccd}ಷ\u{ccc}ರ\u{cbf}ಕ ಅಂಗಡ\u{cbf}",
                "ಕ\u{ccd}ಷ\u{ccc}ರ\u{cbf}ಕ ಕಂಬ",
                "ಬಾರ\u{ccd}ಬರ\u{ccd} ಪೋಲ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("이발소"),
            keywords: &["이발사", "이발소", "이발소 표시"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("म\u{94d}हाला खा\u{902}बो"),
            keywords: &[
                "क\u{947}\u{902}सकातरप",
                "खा\u{902}बो",
                "म\u{94d}हाला खा\u{902}बो",
                "म\u{94d}हालो",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("чачтарач белгиси"),
            keywords: &["белги", "чач жасалгасы", "чачтарач", "чачтарач белгиси"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Coifferssail"),
            keywords: &["Coiffer", "Coifferssail", "Coupe", "Sail"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຮ\u{ec9}ານຕ\u{eb1}ດຜ\u{ebb}ມ"),
            keywords: &["ຕ\u{eb1}ດຜ\u{ebb}ມ", "ຮ\u{ec9}ານຕ\u{eb1}ດຜ\u{ebb}ມ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("kirpėjo suktukas"),
            keywords: &["kirpėjas", "kirpėjo suktukas", "suktukas", "šukuosena"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("friziera izkārtne"),
            keywords: &["bārddzinis", "friziera izkārtne", "frizieris"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pou kaikuti-makawe"),
            keywords: &["kaikuti-makawe", "kutinga-makawe", "pou"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("столб пред берберница"),
            keywords: &["бербер", "столб", "столб пред берберница", "стрижење"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ബ\u{d3e}ർബർ പോൾ"),
            keywords: &[
                "ബ\u{d3e}ർബർ",
                "ബ\u{d3e}ർബർ കട",
                "ബ\u{d3e}ർബർ പോൾ",
                "ബ\u{d3e}ർബർ ഷോപ\u{d4d}പ\u{d4d}",
                "സല\u{d42}ൺ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("үсчин салон"),
            keywords: &["салон", "үсчин"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("न\u{94d}हाव\u{94d}\u{200d}याच\u{94d}या द\u{941}कानाच\u{947} चिन\u{94d}ह"),
            keywords: &[
                "खा\u{902}ब",
                "न\u{94d}हावी",
                "न\u{94d}हाव\u{94d}\u{200d}याच\u{94d}या द\u{941}कानाच\u{947} चिन\u{94d}ह",
                "ह\u{947}अरकट",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("jalur kedai gunting rambut"),
            keywords: &[
                "gunting rambut",
                "jalur",
                "jalur kedai gunting rambut",
                "tukang gunting",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("arblu tal-barbier"),
            keywords: &["arblu", "arblu tal-barbier", "barbier", "qatgħa xagħar"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "ဆ\u{1036}ပင\u{103a}ည\u{103e}ပ\u{103a}ဆ\u{102d}\u{102f}င\u{103a} တ\u{102d}\u{102f}င\u{103a}",
            ),
            keywords: &[
                "ဆ\u{1036}ပင\u{103a}ည\u{103e}ပ\u{103a}ခြင\u{103a}း",
                "ဆ\u{1036}ပင\u{103a}ည\u{103e}ပ\u{103a}ဆရာ",
                "ဆ\u{1036}ပင\u{103a}ည\u{103e}ပ\u{103a}ဆ\u{102d}\u{102f}င\u{103a} တ\u{102d}\u{102f}င\u{103a}",
                "တ\u{102d}\u{102f}င\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("barberskilt"),
            keywords: &[
                "barberer",
                "barberersøyle",
                "barberskilt",
                "frisør",
                "frisørsalong",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("हजामको खम\u{94d}बा"),
            keywords: &["कपाल कटाइ", "खम\u{94d}बा", "हजाम", "हजामको खम\u{94d}बा"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("kapperspaal"),
            keywords: &["kapper", "kapperspaal", "kapsel", "paal"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("barberskilt"),
            keywords: &[
                "barberarsøyle",
                "barberer",
                "barberskilt",
                "frisør",
                "frisørsalong",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ବ\u{b3e}ର\u{b4d}ବର\u{b4d}\u{200c} ପୋଲ\u{b4d}\u{200c}"),
            keywords: &[
                "ପୋଲ\u{b4d}",
                "ବ\u{b3e}ର\u{b4d}ବର\u{b4d}\u{200c}",
                "ବ\u{b3e}ର\u{b4d}ବର\u{b4d}\u{200c} ଶପ\u{b4d}\u{200c}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਬਾਰਬਰ ਪ\u{a4b}ਲ"),
            keywords: &[
                "ਨਾਈ",
                "ਨਾਈ ਦੀ ਦ\u{a41}ਕਾਨ",
                "ਪ\u{a4b}ਲ",
                "ਬਾਰਬਰ ਪ\u{a4b}ਲ",
                "ਹ\u{a47}ਅਰਕ\u{a71}ਟ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("نائی دا قطب"),
            keywords: &["حجامت", "نائی", "نائی دا قطب", "کھمبا"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Bába Pol"),
            keywords: &["Báb Hea", "Bába", "Pol"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("słup fryzjerski"),
            keywords: &["fryzjer", "słup fryzjerski"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د نايي نښه"),
            keywords: &["د نايي نښه", "نايي", "نښه", "ويښتان پريکول"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("barbearia"),
            keywords: &[
                "barbearia",
                "barbeiro",
                "barber pole",
                "poste",
                "poste de barbeiro",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("símbolo de barbearia"),
            keywords: &[
                "barbearia",
                "barbeiro",
                "corte de cabelo",
                "símbolo de barbearia",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("poste barberopaq"),
            keywords: &["barbero", "poste", "poste barberopaq", "rutuy"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("semn de frizerie"),
            keywords: &["bărbier", "indicator", "semn de frizerie", "tuns"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-581"),
            keywords: &["E10-581"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("парикмахерская"),
            keywords: &["волосы", "парикмахерская", "салон", "стрижка", "цирюльник"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("icyapa cy’aho bogoshera"),
            keywords: &[
                "ahatu nyaburanga",
                "icyapa cy’aho bogoshera",
                "impera",
                "kwogosha umusatsi",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("حجام جي نشاني"),
            keywords: &["حجام", "حجام جي نشاني", "وار ڪٽائڻ", "ٿنڀو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("බ\u{dcf}බර\u{dca} පෝල\u{dca}"),
            keywords: &[
                "කොණ\u{dca}ඩය කැප\u{dd3}ම",
                "පෝල\u{dca}",
                "බ\u{dcf}බර\u{dca}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("pútač holičstva"),
            keywords: &["holič", "pútač", "pútač holičstva", "účes"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("brivski izvesek"),
            keywords: &["brivec", "brivski izvesek", "izvesek", "striženje"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("tiirka tima-jaraha"),
            keywords: &["tiir", "tiirka tima-jaraha", "timo-jare", "timo-jaris"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("shenja e berberit"),
            keywords: &["berber", "prerje flokësh", "shenja e berberit", "shenjë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("знак за берберницу"),
            keywords: &["берберин", "знак за берберницу", "стуб", "фризeр"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["знак за берберницу"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("znak za berbernicu"),
            keywords: &["berberin", "frizer", "stub", "znak za berbernicu"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["znak za berbernicu"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("barberarstolpe"),
            keywords: &["barberare", "barberarstolpe", "frisör", "stolpe"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("nguzo ya kinyozi"),
            keywords: &["kinyozi", "kunyolewa", "nguzo", "nguzo ya kinyozi"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ப\u{bbe}ர\u{bcd}பர\u{bcd} ஃபோல\u{bcd}"),
            keywords: &[
                "ப\u{bbe}ர\u{bcd}பர\u{bcd} ஃபோல\u{bcd}",
                "ப\u{bbe}ர\u{bcd}பர\u{bcd} கடை",
                "முடிதிருத\u{bcd}துதல\u{bcd}",
                "முடிதிருத\u{bcd}துபவர\u{bcd}",
                "முடிதிருத\u{bcd}தும\u{bcd} கடை",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("మంగల\u{c3f} ర\u{c3e}య\u{c3f}"),
            keywords: &["మంగల\u{c3f}", "ర\u{c3e}య\u{c3f}"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("сутун бо ранги сурху сафеди морпеч"),
            keywords: &[
                "мӯйгирӣ",
                "сартарош",
                "сутун бо ранги сурху сафеди морпеч",
                "қутб",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ร\u{e49}านต\u{e31}ดผม"),
            keywords: &["บาร\u{e4c}เบอร\u{e4c}", "ร\u{e49}านต\u{e31}ดผม"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ala-mula spiral"),
            keywords: &["ala-mula spiral", "dellek", "saç deňletmek", "taýak"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("pou kosiʻulu"),
            keywords: &["pou kosiʻulu"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("berber dükkanı"),
            keywords: &["berber", "berber dükkanı", "berber işareti", "işaret"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ساتراچ تۈۋرۈكى"),
            keywords: &["تۈۋرۈك", "ساتراچ", "ساتراچ تۈۋرۈكى", "چاچ ياساش"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("вивіска перукаря (смугастий стовп)"),
            keywords: &[
                "вивіска",
                "вивіска перукаря (смугастий стовп)",
                "зачіска",
                "перукар",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("حجام کا پول"),
            keywords: &["حجام", "حجام کا پول", "پول"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("sartaroshlar ustuni"),
            keywords: &[
                "sartarosh",
                "sartaroshlar ustuni",
                "soch kaltalatish",
                "ustun",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("biển hiệu của thợ cắt tóc"),
            keywords: &["biển hiệu của thợ cắt tóc", "cắt tóc", "cột", "thợ cắt tóc"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("tablo watkat"),
            keywords: &["tablo", "wateef", "watkat"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ipali yomchebi weenwele"),
            keywords: &[
                "ipali",
                "ipali yomchebi weenwele",
                "ukucheba iinwele",
                "umchebi",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Opo Onigbajamọ"),
            keywords: &["Opo Onigbajamọ", "agerun", "gérun", "òpó"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("髪型屋招牌"),
            keywords: &["招牌", "理髮", "髪型屋", "髪型屋招牌"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("髪型屋招牌"),
            keywords: &["招牌", "理发", "髪型屋", "髪型屋招牌"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("理发店"),
            keywords: &["旋转", "柱", "理发", "理发店"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("理髮店"),
            keywords: &["理髮店"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("髮型屋招牌"),
            keywords: &["髮型屋", "髮型屋招牌"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ipholi yomgundi wezinwele"),
            keywords: &[
                "ipholi yomgundi wezinwele",
                "ukugunda izinwele",
                "umgundi wezinwele",
            ],
        },
    ],
};
#[doc = "🎪"]
pub const CIRCUS_TENT: crate::Emoji = crate::Emoji {
    glyph: "🎪",
    codepoint: "1F3AA",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "circus tent",
    group: "Travel & Places",
    subgroup: "place-other",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("sirkustent"),
            keywords: &["sirkus", "sirkustent", "tent"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የሰርከስ ድንኳን"),
            keywords: &["ሰርከስ", "የሰርከስ ድንኳን", "ድንኳን"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("\u{202b}خيمة سيرك"),
            keywords: &["ترفيه", "خيمة", "خيمة سرك", "\u{202b}خيمة سيرك"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("চ\u{9be}ৰ\u{9cd}ক\u{9be}চৰ টেণ\u{9cd}ট"),
            keywords: &[
                "চ\u{9be}ক\u{9be}ৰ\u{9cd}চৰ টেণ\u{9cd}ট",
                "চ\u{9be}ৰ\u{9cd}ক\u{9be}চ",
                "চ\u{9be}ৰ\u{9cd}ক\u{9be}চৰ টেণ\u{9cd}ট",
                "টেণ\u{9cd}ট",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("sirk çadırı"),
            keywords: &["sirk", "sirk çadırı", "çadır"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("цыркавая палатка"),
            keywords: &["палатка", "цырк", "цыркавая палатка", "шапіто"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("циркова шатра"),
            keywords: &["цирк", "циркова шатра", "шапито", "шатра"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("স\u{9be}র\u{9cd}ক\u{9be}সের ত\u{9be}ব\u{9c1}"),
            keywords: &[
                "ত\u{9be}\u{981}ব\u{9c1}",
                "স\u{9be}র\u{9cd}ক\u{9be}স",
                "স\u{9be}র\u{9cd}ক\u{9be}সের ত\u{9be}ব\u{9c1}",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("pabell sirk"),
            keywords: &["pabell", "sirk"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("cirkuski šator"),
            keywords: &["cirkus", "cirkuski šator", "šator"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("carpa de circ"),
            keywords: &["carpa", "carpa de circ", "circ"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᎾᏛᏁᎵᏍᎩ ᎤᎾᎵᏦᏛᎢ"),
            keywords: &["ᎠᎾᏛᏁᎵᏍᎩ", "ᎤᎾᎵᏦᏛᎢ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("cirkusový stan"),
            keywords: &["cirkus", "cirkusový stan", "stan", "šapitó"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("tent syrcas"),
            keywords: &["syrcas", "tent"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("cirkus"),
            keywords: &["cirkus", "cirkustelt", "telt"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Zirkuszelt"),
            keywords: &["Unterhaltung", "Zelt", "Zirkus", "Zirkuszelt"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("σκηνή τσίρκου"),
            keywords: &["σκηνή", "σκηνή τσίρκου", "τσίρκο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("circus tent"),
            keywords: &["circus", "tent"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("big top"),
            keywords: &["big top", "circus"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("carpa de circo"),
            keywords: &["carpa", "carpa de circo", "circo", "entretenimiento"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("circo"),
            keywords: &["carpa", "circo"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &[
                "carpa",
                "circo",
                "entretenimiento",
                "espectáculo artístico",
                "show de circo",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("carpa de circo"),
            keywords: &["carpa", "carpa de circo", "circo"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("tsirkusetelk"),
            keywords: &["telk", "tsirkus", "tsirkusetelk"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("zirkoaren karpa"),
            keywords: &["karpa", "zirkoaren karpa", "zirkua"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("چادر سیرک"),
            keywords: &["سیرک", "چادر"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("sirkusteltta"),
            keywords: &["sirkus", "sirkusteltta", "teltta"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("circus tent"),
            keywords: &["circus", "tent"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("sirkustjald"),
            keywords: &["sirkus", "sirkustjald", "tjald"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("chapiteau"),
            keywords: &["chapiteau", "cirque"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("sorcas"),
            keywords: &["puball", "puball sorcais", "sorcas"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("pàillean siorcais"),
            keywords: &["pàillean", "pàillean siorcais", "siorcas", "teanta"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("carpa do circo"),
            keywords: &["carpa", "carpa do circo", "circo"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("સર\u{acd}કસન\u{ac1}\u{a82} ત\u{a82}બ\u{ac1}"),
            keywords: &[
                "ત\u{a82}બ\u{ac1}",
                "મનોર\u{a82}જન",
                "સર\u{acd}કસ",
                "સર\u{acd}કસન\u{ac1}\u{a82} ત\u{a82}બ\u{ac1}",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("tantin ’yan wasa"),
            keywords: &["tanti", "tantin ’yan wasa", "’yan wasa"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("אוהל קרקס"),
            keywords: &["אוהל", "קרקס"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("सर\u{94d}कस ट\u{947}\u{902}ट"),
            keywords: &["ट\u{947}\u{902}ट", "मनोर\u{902}जन", "सर\u{94d}कस"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("cirkuski šator"),
            keywords: &["cirkus", "cirkuski šator", "šator"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("cirkuszsátor"),
            keywords: &["cirkusz", "cirkuszsátor", "sátor"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("կրկեսային վրան"),
            keywords: &["կրկես", "կրկեսային վրան", "վրան"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("tenda sirkus"),
            keywords: &["sirkus", "tenda"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ụlọ akanya ihe nkiri"),
            keywords: &["ihe nkiri", "ụlọ akanya", "ụlọ akanya ihe nkiri"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("sirkus"),
            keywords: &["sirkus", "sirkustjald", "skemmtun", "tjald"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("circo"),
            keywords: &["circo", "intrattenimento", "tenda", "tenda da circo"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("サーカス"),
            keywords: &["サーカス", "テント"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("tendha sirkus"),
            keywords: &["sirkus", "tendha"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ცირკის კარავი"),
            keywords: &["კარავი", "ცირკი", "ცირკის კარავი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("цирк шатыры"),
            keywords: &["цирк", "цирк шатыры", "шатыр"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("cirkus"),
            keywords: &["cirkus", "cirkustelt", "telt"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("រោងសៀក"),
            keywords: &["រោង", "រោងសៀក", "សៀក"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಸರ\u{ccd}ಕಸ\u{ccd} ಟ\u{cc6}ಂಟ\u{ccd}"),
            keywords: &["ಸರ\u{ccd}ಕಸ\u{ccd}", "ಸರ\u{ccd}ಕಸ\u{ccd} ಟ\u{cc6}ಂಟ\u{ccd}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("서커스"),
            keywords: &["서커스", "텐트"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("सर\u{94d}कसीचो त\u{902}ब\u{942}"),
            keywords: &[
                "त\u{902}ब\u{942}",
                "सर\u{94d}कस",
                "सर\u{94d}कसीचो त\u{902}ब\u{942}",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("цирк чатыры"),
            keywords: &["цирк", "цирк чатыры", "чатыр"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Zirkuszelt"),
            keywords: &["Zelt", "Zirkus", "Zirkuszelt"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຊ\u{eb8}\u{ec9}ມນອນໂຮງລະຄອນສ\u{eb1}ດ"),
            keywords: &[
                "ຊ\u{eb8}\u{ec9}ມນອນໂຮງລະຄອນສ\u{eb1}ດ",
                "ໂຮງກາຍະສ\u{eb4}ນ",
                "ໂຮງລະຄອນສ\u{eb1}ດ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("cirko palapinė"),
            keywords: &["cirkas", "cirko palapinė", "palapinė"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("cirka telts"),
            keywords: &["cirka telts", "cirks", "telts"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tēneti manini rau"),
            keywords: &["manini rau", "tēneti", "tēneti manini rau"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("циркуски шатор"),
            keywords: &["циркус", "циркуски шатор", "шатор"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("സർക\u{d4d}കസ\u{d4d} ക\u{d42}ട\u{d3e}രം"),
            keywords: &["ക\u{d42}ട\u{d3e}രം", "സർക\u{d4d}കസ\u{d4d}"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("циркийн майхан"),
            keywords: &["майхан", "цирк", "циркийн майхан"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("सर\u{94d}कशीचा त\u{902}ब\u{942}"),
            keywords: &[
                "त\u{902}ब\u{942}",
                "सर\u{94d}कशीचा त\u{902}ब\u{942}",
                "सर\u{94d}कस",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("khemah sarkas"),
            keywords: &["khemah", "sarkas"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("tinda taċ-ċirklu"),
            keywords: &["tinda", "tinda taċ-ċirklu", "ċirklu"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဆပ\u{103a}ကပ\u{103a}တ\u{1032}"),
            keywords: &[
                "ဆပ\u{103a}ကပ\u{103a}",
                "ဆပ\u{103a}ကပ\u{103a}တ\u{1032}",
                "တ\u{1032}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("sirkustelt"),
            keywords: &["sirkus", "sirkustelt", "telt", "underholdning"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("सर\u{94d}कसको पाल"),
            keywords: &["ट\u{947}न\u{94d}ट", "सर\u{94d}कस", "सर\u{94d}कसको पाल"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("circustent"),
            keywords: &["circus", "circustent", "tent"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("sirkustelt"),
            keywords: &["sirkus", "sirkustelt", "telt", "underhaldning"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ସର\u{b4d}କସ\u{b4d}\u{200c} ତମ\u{b4d}ବ\u{b41}"),
            keywords: &[
                "ତମ\u{b4d}ବ\u{b41}",
                "ମନୋରଞ\u{b4d}ଜନ",
                "ସର\u{b4d}କସ\u{b4d}\u{200c} ତମ\u{b4d}ବ\u{b41}",
                "ସର\u{b4d}କସ\u{200c}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਸਰਕਸ ਤ\u{a70}ਬ\u{a42}"),
            keywords: &["ਤ\u{a70}ਬ\u{a42}", "ਮਨ\u{a4b}ਰ\u{a70}ਜਨ", "ਸਰਕਸ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("سرکس دے تنبو"),
            keywords: &["خیمہ", "سرکس", "سرکس دے تنبو"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Sẹkọ\u{301}s Tẹnt"),
            keywords: &["Sẹkọs", "Sẹkọ\u{301}s Tẹnt", "Tẹnt"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("namiot cyrkowy"),
            keywords: &["namiot", "namiot cyrkowy"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د سرکس خیمه"),
            keywords: &["خیمه", "د سرکس خیمه", "سرکس"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("circo"),
            keywords: &["circo", "entretenimento", "lona", "lona de circo"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("tenda de circo"),
            keywords: &["circo", "tenda", "tenda de circo"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("cort de circ"),
            keywords: &["circ", "cort", "cort de circ"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-362"),
            keywords: &["E10-362"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("цирковой шатер"),
            keywords: &["цирк", "цирковой шатер", "шатер"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ihema ry’uruziga"),
            keywords: &["ihema ry’uruziga"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("سرڪس تنبو"),
            keywords: &["تنبو", "سرڪس"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("සර\u{dca}කස\u{dca} ක\u{dd6}ඩ\u{dcf}රම"),
            keywords: &["ක\u{dd6}ඩ\u{dcf}රම", "සර\u{dca}කස\u{dca}"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("šapito"),
            keywords: &["cirkus", "stan", "šapito"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("cirkuški šotor"),
            keywords: &["cirkus", "cirkuški šotor", "šotor"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("teendho rogad"),
            keywords: &["rogadka", "teendho", "teendho rogad"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("tendë cirku"),
            keywords: &["cirk", "tendë", "tendë cirku"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("циркуски шатор"),
            keywords: &["циркус", "циркуски шатор", "шaтoр"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["циркуски шатор"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("cirkuski šator"),
            keywords: &["cirkus", "cirkuski šator", "šator"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["cirkuski šator"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("cirkustält"),
            keywords: &["cirkus", "cirkustält", "tält"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("hema ya sarakasi"),
            keywords: &["hema", "hema ya sarakasi", "sarakasi"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("சர\u{bcd}க\u{bcd}கஸ\u{bcd} கூட\u{bbe}ரம\u{bcd}"),
            keywords: &[
                "கூட\u{bbe}ரம\u{bcd}",
                "சர\u{bcd}க\u{bcd}கஸ\u{bcd}",
                "பொழுதுபோக\u{bcd}கு",
                "மகிழ\u{bcd}ச\u{bcd}சி",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("సర\u{c4d}కస\u{c4d} ట\u{c46}ంట\u{c4d}"),
            keywords: &["ట\u{c46}ంట\u{c4d}", "సర\u{c4d}కస\u{c4d}"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("хаймаи сирк"),
            keywords: &["сирк", "хайма", "хаймаи сирк"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ละครส\u{e31}ตว\u{e4c}"),
            keywords: &[
                "ละครส\u{e31}ตว\u{e4c}",
                "เต\u{e4a}นท\u{e4c}ละครส\u{e31}ตว\u{e4c}",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("sirk çadyry"),
            keywords: &["sirk", "sirk çadyry", "çadyr"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("teniti sākisi"),
            keywords: &["teniti sākisi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("sirk çadırı"),
            keywords: &["eğlence", "sirk çadırı", "çadır"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("سېرىك چېدىرى"),
            keywords: &["سېرىك", "چېدىرى"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("циркове шатро"),
            keywords: &["намет", "цирк", "циркове шатро"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("سرکس کا ٹینٹ"),
            keywords: &["سرکس", "سرکس کا ٹینٹ", "ٹینٹ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("sirk chodiri"),
            keywords: &["chodir", "sirk", "sirk chodiri"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("lều rạp xiếc"),
            keywords: &["lều", "lều rạp xiếc", "rạp xiếc"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("barabu sirk"),
            keywords: &["barabu", "sirk"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("intente yesekisi"),
            keywords: &["intente", "intente yesekisi", "isekisi"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Aba Ere-idaraya"),
            keywords: &["Aba", "Ere-idaraya"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("馬戲團帳篷"),
            keywords: &["帳篷", "馬戲團", "馬戲團帳篷"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("马戏团帐篷"),
            keywords: &["帐篷", "马戏团", "马戏团帐篷"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("马戏团帐篷"),
            keywords: &["帐篷", "马戏团", "马戏团帐篷"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("馬戲團"),
            keywords: &["馬戲團", "馬戲團帳篷"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("itende lesekisi"),
            keywords: &["isekisi", "itende", "itende lesekisi"],
        },
    ],
};
