#[doc = "🌍"]
pub const GLOBE_SHOWING_EUROPE_AFRICA: crate::Emoji = crate::Emoji {
    glyph: "🌍",
    codepoint: "1F30D",
    status: crate::Status::FullyQualified,
    introduction_version: 0.7f32,
    name: "globe showing Europe-Africa",
    group: "Travel & Places",
    subgroup: "place-map",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("aardbol met europa-afrika"),
            keywords: &[
                "aardbol",
                "aardbol met europa-afrika",
                "aarde",
                "afrika",
                "europa",
                "wêreld",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("አውሮፓና አፍሪካ የሚያሳይ ሉል"),
            keywords: &["ሉል", "መሬት", "አውሮጳ", "አውሮፓና አፍሪካ የሚያሳይ ሉል", "አፍሪካ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("\u{202b}كرة أرضية تعرض أوروبا وإفريقيا"),
            keywords: &[
                "أوروبا",
                "إفريقيا",
                "\u{202b}كرة أرضية تعرض أوروبا وإفريقيا",
            ],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("গ\u{9cd}ল’বত ইউৰোপ-আফ\u{9cd}ৰিক\u{9be} দেখ\u{9c1}ৱ\u{9be}ইছে"),
            keywords: &[
                "আফ\u{9cd}ৰিক\u{9be}",
                "ইউৰোপ",
                "গ\u{9cd}ল’ব",
                "গ\u{9cd}ল’বত ইউৰোপ-আফ\u{9cd}ৰিক\u{9be} দেখ\u{9c1}ৱ\u{9be}ইছে",
                "প\u{9c3}থিৱী",
                "বিশ\u{9cd}ব",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("Avropa-Afrikanı göstərən qlobus"),
            keywords: &[
                "Avropa-Afrikanı göstərən qlobus",
                "afrika",
                "avropa",
                "dünya",
                "qlobus",
                "yer kürəsi",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("зямны шар (еўропа і афрыка)"),
            keywords: &[
                "афрыка",
                "еўропа",
                "зямля",
                "зямны шар (еўропа і афрыка)",
                "свет",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("глобус с Европа и Африка"),
            keywords: &[
                "африка",
                "глобус",
                "глобус с Европа и Африка",
                "европа",
                "земята",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("গ\u{9cd}লোব ইউরোপ আফ\u{9cd}রিক\u{9be} দেখ\u{9be}চ\u{9cd}ছে"),
            keywords: &[
                "আফ\u{9cd}রিক\u{9be}",
                "ইউরোপ",
                "গ\u{9cd}লোব",
                "গ\u{9cd}লোব ইউরোপ আফ\u{9cd}রিক\u{9be} দেখ\u{9be}চ\u{9cd}ছে",
                "প\u{9c3}থিবী",
                "বিশ\u{9cd}ব",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("boul douar o tiskouez Europa hag Afrika"),
            keywords: &[
                "Afrika",
                "Europa",
                "bed",
                "boul",
                "boul douar o tiskouez Europa hag Afrika",
                "douar",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("globus prikazuje Evropu i Afriku"),
            keywords: &[
                "Zemlja",
                "globus",
                "globus prikazuje Evropu i Afriku",
                "kugla",
                "svijet",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("globus terraqüi amb Europa i Àfrica"),
            keywords: &[
                "Europa",
                "globus terraqüi amb Europa i Àfrica",
                "món",
                "Àfrica",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎡᎶᎯ ᏗᏟᎶᏍᏔᏅ ᎬᏂᎨᏒ ᏂᎬᎾ ᏳᎳᏈ-ᎬᎿᎨᏍᏛ"),
            keywords: &[
                "ᎡᎶᎯ",
                "ᎡᎶᎯ ᏗᏟᎶᏍᏔᏅ",
                "ᎡᎶᎯ ᏗᏟᎶᏍᏔᏅ ᎬᏂᎨᏒ ᏂᎬᎾ ᏳᎳᏈ-ᎬᎿᎨᏍᏛ",
                "ᎧᎵ ᎡᎶᎯ",
                "ᎬᎿᎨᏍᏛᎢ",
                "ᏳᎳᏈ",
            ],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("glóbus s Evropou a Afrikou"),
            keywords: &[
                "afrika",
                "evropa",
                "glóbus s Evropou a Afrikou",
                "svět",
                "země",
                "zeměkoule",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("glôb yn dangos Ewrop-Affrica"),
            keywords: &[
                "Affrica",
                "Ewrop",
                "byd",
                "glôb yn dangos Ewrop-Affrica",
                "y ddaear",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("globus med Europa og Afrika"),
            keywords: &["Afrika", "Europa", "globus med Europa og Afrika", "jorden"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Globus mit Europa und Afrika"),
            keywords: &[
                "Afrika",
                "Europa",
                "Globus mit Europa und Afrika",
                "Weltkugel",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("υδρόγειος με Ευρώπη και Αφρική"),
            keywords: &[
                "Αφρική",
                "Ευρώπη",
                "γη",
                "κόσμος",
                "υδρόγειος",
                "υδρόγειος με Ευρώπη και Αφρική",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("globe showing Europe-Africa"),
            keywords: &[
                "Africa",
                "Europe",
                "earth",
                "globe",
                "globe showing Europe-Africa",
                "world",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("globo terráqueo mostrando Europa y África"),
            keywords: &[
                "Europa",
                "Tierra",
                "globo terráqueo mostrando Europa y África",
                "mundo",
                "planeta",
                "África",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("globo terráqueo Europa/África"),
            keywords: &[
                "Europa",
                "globo",
                "globo terráqueo Europa/África",
                "mapa",
                "terráqueo",
                "África",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["Europa", "globo", "globo terráqueo Europa/África", "África"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("Euroopa ja Aafrika gloobusel"),
            keywords: &[
                "Aafrika",
                "Euroopa",
                "Euroopa ja Aafrika gloobusel",
                "gloobus",
                "maa",
                "maailm",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("europa eta afrika ikusgai dituen lur-globoa"),
            keywords: &[
                "afrika",
                "europa",
                "europa eta afrika ikusgai dituen lur-globoa",
                "globo",
                "lur",
                "mundu",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("نقشه\u{654} اروپا-افریقا روی کره"),
            keywords: &[
                "اروپا",
                "افریقا",
                "زمین",
                "نقشه\u{654} اروپا-افریقا روی کره",
                "کره\u{654} جغرافیایی",
                "کره\u{654} زمین",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("maapallo jossa näkyy Eurooppa ja Afrikka"),
            keywords: &[
                "Afrikka",
                "Eurooppa",
                "maailma",
                "maapallo",
                "maapallo jossa näkyy Eurooppa ja Afrikka",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("globong nagpapakita sa europe at africa"),
            keywords: &[
                "africa",
                "europe",
                "globo",
                "globong nagpapakita sa europe at africa",
                "mundo",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("globus har Evropa og Afrika síggjast"),
            keywords: &[
                "Afrika",
                "Evropa",
                "globus",
                "globus har Evropa og Afrika síggjast",
                "heimurin",
                "jørðin",
                "verðin",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("globe tourné sur l’Afrique et l’Europe"),
            keywords: &[
                "afrique",
                "europe",
                "globe tourné sur l’Afrique et l’Europe",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("globe qui montre l’Europe et l’Afrique"),
            keywords: &[
                "Afrique",
                "Europe",
                "globe",
                "globe qui montre l’Europe et l’Afrique",
                "monde",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("cruinneog ag taispeáint na hEorpa agus na hAfraice"),
            keywords: &[
                "an Afraic",
                "an Eoraip",
                "an chruinne",
                "an domhan",
                "cruinneog",
                "cruinneog ag taispeáint na hEorpa agus na hAfraice",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("cruinne leis an Roinn-Eòrpa ’s Afraga"),
            keywords: &[
                "afraga",
                "cruinne",
                "cruinne leis an Roinn-Eòrpa ’s Afraga",
                "globa",
                "globa a’ sealltainn an Roinn-Eòrpa agus Afraga",
                "globa a’ sealltainn an Roinn-Eòrpa ’s Afraga",
                "roinn-eòrpa",
                "saoghal",
                "talamh",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("globo terráqueo Europa-África"),
            keywords: &[
                "Europa",
                "Terra",
                "globo terráqueo Europa-África",
                "mundo",
                "África",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ય\u{ac1}રોપ-આફ\u{acd}રિકા બતાવતો પ\u{ac3}થ\u{acd}વીનો ગોળો"),
            keywords: &[
                "આફ\u{acd}રિકા",
                "ગ\u{acd}લોબ",
                "પ\u{ac3}થ\u{acd}વી",
                "ય\u{ac1}રોપ",
                "ય\u{ac1}રોપ-આફ\u{acd}રિકા બતાવતી ગ\u{acd}લોબ",
                "ય\u{ac1}રોપ-આફ\u{acd}રિકા બતાવત\u{ac1}\u{a82} ગ\u{acd}લોબ",
                "ય\u{ac1}રોપ-આફ\u{acd}રિકા બતાવતો પ\u{ac3}થ\u{acd}વીનો ગોળો",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("gulob na duniya mai nunawa Turai-Afrika"),
            keywords: &[
                "Afirika",
                "Turai",
                "duniya",
                "gulab na duniya",
                "gulob na duniya mai nunawa Turai-Afrika",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("גלובוס עם אירופה ואפריקה"),
            keywords: &[
                "אירופה",
                "אפריקה",
                "גלובוס",
                "גלובוס עם אירופה ואפריקה",
                "כדור הארץ",
                "עולם",
            ],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("य\u{942}रोप-अफ\u{93c}\u{94d}रीका दिखाता ग\u{94d}लोब"),
            keywords: &[
                "अफ\u{93c}\u{94d}रीका",
                "ग\u{94d}लोब",
                "ग\u{94d}लोब, प\u{943}थ\u{94d}वी, य\u{942}रोप, अफ\u{93c}\u{94d}रीका",
                "प\u{943}थ\u{94d}वी",
                "य\u{942}रोप",
                "य\u{942}रोप-अफ\u{93c}\u{94d}रीका दिखाता ग\u{94d}लोब",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("globus s prikazom Europe i Afrike"),
            keywords: &[
                "Afrika",
                "Europa",
                "Zemlja",
                "globus",
                "globus s prikazom Europe i Afrike",
                "svijet",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("Európát és Afrikát mutató földgömb"),
            keywords: &[
                "Afrika",
                "Európa",
                "Európát és Afrikát mutató földgömb",
                "föld",
                "földgömb",
                "világ",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("Եվրոպան և Աֆրիկան պատկերող գլոբուս"),
            keywords: &[
                "Աֆրիկա",
                "Եվրոպա",
                "Եվրոպան և Աֆրիկան պատկերող գլոբուս",
                "աշխարհ",
                "գլոբուս",
                "երկիր",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("bola dunia Eropa-Afrika"),
            keywords: &[
                "afrika",
                "bola dunia Eropa-Afrika",
                "bumi",
                "dunia",
                "eropa",
                "globe",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ụwa na-egosi Europe-Afrika"),
            keywords: &[
                "Afrika",
                "Europe",
                "ụwa",
                "ụwa dum",
                "ụwa na-egosi Europe-Afrika",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("hnöttur sem sýnir Evrópu-Afríku"),
            keywords: &[
                "Afríka",
                "Evrópa",
                "hnöttur sem sýnir Evrópu-Afríku",
                "jörðin",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("Europa e Africa"),
            keywords: &["Africa", "Europa", "Europa e Africa", "terra"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("地球（ヨーロッパとアフリカ）"),
            keywords: &[
                "アフリカ",
                "ヨーロッパ",
                "地球",
                "地球（ヨーロッパとアフリカ）",
            ],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("globe sing nuduhake benua Eropa-Afrika"),
            keywords: &[
                "Afrika",
                "Eropa",
                "bumi",
                "donya",
                "globe",
                "globe sing nuduhake benua Eropa-Afrika",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("გლობუსი, რომელზეც ჩანს ევროპა და აფრიკა"),
            keywords: &[
                "აფრიკა",
                "გლობუსი",
                "გლობუსი, რომელზეც ჩანს ევროპა და აფრიკა",
                "დედამიწა",
                "ევროპა",
                "მსოფლიო",
            ],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("amtiweg turuft tafriqt"),
            keywords: &["amtiweg turuft tafriqt"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("Еуропа мен Африка көрсетілген глобус"),
            keywords: &[
                "Еуропа мен Африка көрсетілген глобус",
                "африка",
                "глобус",
                "еуропа",
                "жер",
                "әлем",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("globus med europa og afrika"),
            keywords: &["Afrika", "Europa", "globus med europa og afrika", "jorden"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some(
                "ផែនដ\u{17b8}បង\u{17d2}ហាញទ\u{17d2}វ\u{17b8}បអ\u{17ba}រ\u{17c9}\u{17bb}បន\u{17b7}ងអាហ\u{17d2}រ\u{17d2}វ\u{17b7}ក",
            ),
            keywords: &[
                "ផែនដ\u{17b8}",
                "ផែនដ\u{17b8}បង\u{17d2}ហាញទ\u{17d2}វ\u{17b8}បអ\u{17ba}រ\u{17c9}\u{17bb}បន\u{17b7}ងអាហ\u{17d2}រ\u{17d2}វ\u{17b7}ក",
                "ព\u{17b7}ភពលោក",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some(
                "ಯ\u{cc2}ರೋಪ\u{ccd}-ಆಫ\u{ccd}ರ\u{cbf}ಕಾ ತೋರ\u{cbf}ಸುತ\u{ccd}ತ\u{cbf}ರುವ ಭ\u{cc2}ಗೋಳ",
            ),
            keywords: &[
                "ಜಗತ\u{ccd}ತು",
                "ಭ\u{cc2}ಮ\u{cbf}",
                "ಯ\u{cc2}ರೋಪ\u{ccd}-ಆಫ\u{ccd}ರ\u{cbf}ಕಾ ತೋರ\u{cbf}ಸುತ\u{ccd}ತ\u{cbf}ರುವ ಜಗತ\u{ccd}ತು",
                "ಯ\u{cc2}ರೋಪ\u{ccd}-ಆಫ\u{ccd}ರ\u{cbf}ಕಾ ತೋರ\u{cbf}ಸುತ\u{ccd}ತ\u{cbf}ರುವ ಭ\u{cc2}ಗೋಳ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("유럽과 아프리카가 보이는 지구"),
            keywords: &[
                "아프리카",
                "유럽",
                "유럽과 아프리카가 보이는 지구",
                "지구본",
            ],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("य\u{941}रोप-आफ\u{94d}रिका दाखोवपी विश\u{94d}वगोल"),
            keywords: &[
                "आफ\u{94d}रिका",
                "जग",
                "प\u{943}थ\u{94d}वी",
                "य\u{941}रोप",
                "य\u{941}रोप-आफ\u{94d}रिका दाखोवपी विश\u{94d}वगोल",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("европа-африканы көрсөткөн глобус"),
            keywords: &[
                "африка",
                "дүйнө",
                "европа",
                "европа-африканы көрсөткөн глобус",
                "жер",
            ],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Globus (zentréiert op Europa an Afrika)"),
            keywords: &[
                "Afrika",
                "Europa",
                "Globus",
                "Globus (zentréiert op Europa an Afrika)",
                "Welt",
                "Äerd",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໜ\u{ec8}ວຍໂລກທ\u{eb5}\u{ec8}ສະແດງເອ\u{eb5}ຣ\u{ebb}ບ-ອາຝຣ\u{eb4}ກາ"),
            keywords: &[
                "ອາຝຣ\u{eb4}ກາ",
                "ເອ\u{eb5}ຣ\u{ebb}ບ",
                "ໜ\u{ec8}ວຍໂລກ",
                "ໜ\u{ec8}ວຍໂລກທ\u{eb5}\u{ec8}ສະແດງເອ\u{eb5}ຣ\u{ebb}ບ-ອາຝຣ\u{eb4}ກາ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("žemės rutulys su Europos ir Afrikos žemynais"),
            keywords: &[
                "Afrika",
                "Europa",
                "gaublys",
                "pasaulis",
                "žemė",
                "žemės rutulys su Europos ir Afrikos žemynais",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("globuss ar Eiropu un Āfriku"),
            keywords: &[
                "Eiropa",
                "globuss",
                "globuss ar Eiropu un Āfriku",
                "pasaule",
                "zemeslode",
                "Āfrika",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("ao whakakite Uropi-Āwherika"),
            keywords: &[
                "Uropi",
                "ao",
                "ao whakakite Uropi-Āwherika",
                "whenua",
                "Āwherika",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("глобус што ги покажува Европа и Африка"),
            keywords: &[
                "Африка",
                "Европа",
                "глобус",
                "глобус што ги покажува Европа и Африка",
                "земја",
            ],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some(
                "യ\u{d42}റോപ\u{d4d}പ\u{d4d}-ആഫ\u{d4d}രിക\u{d4d}ക ക\u{d3e}ണിക\u{d4d}ക\u{d41}ന\u{d4d}ന ഭ\u{d42}ഗോളം",
            ),
            keywords: &[
                "ആഫ\u{d4d}രിക\u{d4d}ക",
                "ഗ\u{d4d}ലോബ\u{d4d}",
                "ഭ\u{d42}ഗോളം",
                "ഭ\u{d42}മി",
                "യ\u{d42}റോപ\u{d4d}പ\u{d4d}",
                "യ\u{d42}റോപ\u{d4d}പ\u{d4d}-ആഫ\u{d4d}രിക\u{d4d}ക ക\u{d3e}ണിക\u{d4d}ക\u{d41}ന\u{d4d}ന ഭ\u{d42}ഗോളം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("Европ-Африкийг харуулсан бөмбөрцөг"),
            keywords: &[
                "Африк",
                "Европ",
                "Европ-Африкийг харуулсан бөмбөрцөг",
                "бөмбөрцөг",
                "дэлхий",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("य\u{941}रोप-आफ\u{94d}रिका दर\u{94d}शविणारा प\u{943}थ\u{94d}वीचा गोल"),
            keywords: &[
                "आफ\u{94d}रिका",
                "जग",
                "प\u{943}थ\u{94d}वी",
                "प\u{943}थ\u{94d}वीचा गोल",
                "य\u{941}रोप",
                "य\u{941}रोप-आफ\u{94d}रिका दर\u{94d}शविणारा प\u{943}थ\u{94d}वीचा गोल",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("peta glob Eropah-Afrika"),
            keywords: &[
                "afrika",
                "bumi",
                "dunia",
                "eropah",
                "glob",
                "peta glob Eropah-Afrika",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("globu juri l-Ewropa-Afrika"),
            keywords: &[
                "Afrika",
                "dinja",
                "globu",
                "globu juri l-Ewropa-Afrika",
                "l-Ewropa",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "ဥရောပန\u{103e}င\u{1037}\u{103a} အာဖရ\u{102d}ကက\u{102d}\u{102f} ပြသထားသည\u{1037}\u{103a} ကမ\u{1039}ဘာလ\u{102f}\u{1036}း",
            ),
            keywords: &[
                "ကမ\u{1039}ဘာ",
                "ကမ\u{1039}ဘာလ\u{102f}\u{1036}း",
                "အာဖရ\u{102d}က",
                "ဥရောပ",
                "ဥရောပန\u{103e}င\u{1037}\u{103a} အာဖရ\u{102d}ကက\u{102d}\u{102f} ပြထားသည\u{1037}\u{103a} ကမ\u{1039}ဘာလ\u{102f}\u{1036}း",
                "ဥရောပန\u{103e}င\u{1037}\u{103a} အာဖရ\u{102d}ကက\u{102d}\u{102f} ပြသထားသည\u{1037}\u{103a} ကမ\u{1039}ဘာလ\u{102f}\u{1036}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("jordklode med Europa og Afrika"),
            keywords: &[
                "Afrika",
                "Europa",
                "jorden",
                "jordklode med Europa og Afrika",
                "verden",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("य\u{942}रोप-अफ\u{94d}रिका द\u{947}खाइएको विश\u{94d}वको मानचित\u{94d}र"),
            keywords: &[
                "अफ\u{94d}रिका",
                "प\u{943}थ\u{94d}वी",
                "य\u{942}रोप",
                "य\u{942}रोप-अफ\u{94d}रिका द\u{947}खाइएको विश\u{94d}वको मानचित\u{94d}र",
                "विश\u{94d}व",
                "स\u{902}सार",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("wereldbol met Europa-Afrika"),
            keywords: &[
                "Afrika",
                "Europa",
                "aarde",
                "wereld",
                "wereldbol",
                "wereldbol met Europa-Afrika",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("jordklode med Europa og Afrika"),
            keywords: &[
                "Afrika",
                "Europa",
                "jorda",
                "jordklode med Europa og Afrika",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some(
                "ୟ\u{b41}ରୋପ\u{b4d}\u{200c}-ଆଫ\u{b4d}ର\u{b3f}କ\u{b3e} ଦେଖ\u{b3e}ଉଥ\u{b3f}ବ\u{b3e} ଗ\u{b4d}ଲୋବ\u{b4d}\u{200c}",
            ),
            keywords: &[
                "ଆଫ\u{b4d}ର\u{b3f}କ\u{b3e}",
                "ପ\u{b43}ଥ\u{b3f}ବୀ",
                "ବ\u{b3f}ଶ\u{b4d}ଵ",
                "ୟ\u{b41}ରୋପ",
                "ୟ\u{b41}ରୋପ\u{b4d}\u{200c}-ଆଫ\u{b4d}ର\u{b3f}କ\u{b3e} ଦେଖ\u{b3e}ଉଥ\u{b3f}ବ\u{b3e} ଗ\u{b4d}ଲୋବ\u{b4d}\u{200c}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਯ\u{a42}ਰਪ-ਅਫਰੀਕਾ ਵਿਖਾਉ\u{a02}ਦਾ ਗਲ\u{a4b}ਬ"),
            keywords: &[
                "ਅਫਰੀਕਾ",
                "ਧਰਤੀ",
                "ਯ\u{a42}ਰਪ-ਅਫਰੀਕਾ ਵਿਖਾਉ\u{a02}ਦਾ ਗਲ\u{a4b}ਬ",
                "ਯ\u{a42}ਰ\u{a4b}ਪ",
                "ਸ\u{a70}ਸਾਰ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("گلوب یورپ ـ افریقہ وکھا رہیا اے"),
            keywords: &[
                "ارض نما کرہ",
                "افریقہ",
                "دنیا",
                "زمین",
                "گلوب یورپ ـ افریقہ وکھا رہیا اے",
                "یورپ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Raúnd Wọ\u{301}ld Map Wẹ De Shó Yúrop-Áfrika"),
            keywords: &[
                "Map",
                "Raúnd Wọ\u{301}ld Map",
                "Raúnd Wọ\u{301}ld Map Wẹ De Shó Yúrop-Áfrika",
                "Wọld",
                "Yúrop",
                "Áfríka",
                "Ẹt",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("kula ziemska przedstawiająca Europę i Afrykę"),
            keywords: &[
                "Afryka",
                "Europa",
                "Ziemia",
                "kula ziemska przedstawiająca Europę i Afrykę",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("نړۍ ښيي اروپا-افریقا"),
            keywords: &[
                "اروپا",
                "افريقا",
                "زمکه",
                "نړۍ",
                "نړۍ ښيي اروپا-افریقا",
                "کره",
            ],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("globo mostrando Europa e África"),
            keywords: &[
                "Europa",
                "Terra",
                "globo mostrando Europa e África",
                "África",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("globo com a Europa e a África visíveis"),
            keywords: &[
                "Europa",
                "Terra",
                "globo",
                "globo com a Europa e a África visíveis",
                "mundo",
                "África",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("saywasiqʼi Europa, Africapas Qawachkan"),
            keywords: &[
                "Africa",
                "Europa",
                "kawsay pacha",
                "pacha",
                "saywasiqʼi Europa, Africapas Qawachkan",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("Europa și Africa pe glob"),
            keywords: &[
                "Africa",
                "Europa",
                "Europa și Africa pe glob",
                "Pământ",
                "glob",
                "lume",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-212"),
            keywords: &["E10-212"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("Европа и Африка на земном шаре"),
            keywords: &[
                "Африка",
                "Европа",
                "Европа и Африка на земном шаре",
                "Земля",
                "глобус",
                "земной шар",
                "шар",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umubumbe w’isi werekana Uburayi n’Afurika"),
            keywords: &[
                "Afurika",
                "Uburayi",
                "isi",
                "umubumbe w’isi",
                "umubumbe w’isi werekana Uburayi n’Afurika",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("گلوب يورپ ايشيا ڏيکاري پيو"),
            keywords: &[
                "آفريقا، زمين، يورپ، گلوب، دنيا",
                "گلوب يورپ ايشيا ڏيکاري پيو",
            ],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some(
                "ය\u{dd4}රෝප\u{dcf}-අප\u{dca}\u{200d}ර\u{dd2}ක\u{dcf}ව පෙන\u{dca}වන ලෝක ගෝලය",
            ),
            keywords: &[
                "අප\u{dca}\u{200d}ර\u{dd2}ක\u{dcf}ව",
                "පෘථ\u{dd2}ව\u{dd2}ය",
                "ය\u{dd4}රෝපය",
                "ය\u{dd4}රෝප\u{dcf}-අප\u{dca}\u{200d}ර\u{dd2}ක\u{dcf}ව පෙන\u{dca}වන ලෝක ගෝලය",
                "ලෝක ගෝලය",
                "ලෝකය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("zemeguľa s Európou a Afrikou"),
            keywords: &[
                "afrika",
                "európa",
                "glóbus",
                "svet",
                "zem",
                "zemeguľa s Európou a Afrikou",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("globus z Evropo in Afriko"),
            keywords: &[
                "Afrika",
                "Evropa",
                "globus",
                "globus z Evropo in Afriko",
                "svet",
                "zemlja",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("adduunka muujinaya Yurub-Afrika"),
            keywords: &[
                "Afrika",
                "Yurub",
                "adduunka",
                "adduunka muujinaya Yurub-Afrika",
                "dhulka",
                "dunida",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("globi që tregon Evropën dhe Afrikën"),
            keywords: &[
                "Afrikë",
                "Bota",
                "Evropa",
                "Globi",
                "globi që tregon Evropën dhe Afrikën",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("глобус са Европом и Африком"),
            keywords: &[
                "Африкa",
                "Еврoпa",
                "Земља",
                "глобус",
                "глобус са Европом и Африком",
                "свет",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["глобус са Европом и Африком"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("globus sa Evropom i Afrikom"),
            keywords: &[
                "Afrika",
                "Evropa",
                "Zemlja",
                "globus",
                "globus sa Evropom i Afrikom",
                "svet",
            ],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["globus sa Evropom i Afrikom"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("jordglob Europa–Afrika"),
            keywords: &["Afrika", "Europa", "jorden", "jordglob Europa–Afrika"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("tufe linaloonyesha ulaya-afrika"),
            keywords: &[
                "afrika",
                "dunia",
                "tufe",
                "tufe linaloonyesha ulaya-afrika",
                "ulaya",
                "ulimwengu",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ஐரோப\u{bcd}ப\u{bbe}-ஆப\u{bcd}பிரிக\u{bcd}க\u{bbe}"),
            keywords: &[
                "ஆப\u{bcd}பிரிக\u{bcd}க\u{bbe}",
                "உலக உருண\u{bcd}டை",
                "ஐரோப\u{bcd}ப\u{bbe}",
                "ஐரோப\u{bcd}ப\u{bbe}-ஆப\u{bcd}பிரிக\u{bcd}க\u{bbe}",
                "பூமி",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some(
                "యూరప\u{c4d}-ఆఫ\u{c4d}ర\u{c3f}క\u{c3e}ను చూప\u{c47} గ\u{c4d}ల\u{c4b}బ\u{c4d}",
            ),
            keywords: &[
                "ఆఫ\u{c4d}ర\u{c3f}క\u{c3e}",
                "భూగ\u{c4b}ళం",
                "భూమ\u{c3f}",
                "యూరప\u{c4d}",
                "యూరప\u{c4d}-ఆఫ\u{c4d}ర\u{c3f}క\u{c3e}ను చూప\u{c47} గ\u{c4d}ల\u{c4b}బ\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("глобусе, ки Аврупо-Африкаро намоиш медиҳад"),
            keywords: &[
                "Аврупо",
                "Африка",
                "глобус",
                "глобусе, ки Аврупо-Африкаро намоиш медиҳад",
                "замин",
                "ҷаҳон",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ล\u{e39}กโลกแสดงทว\u{e35}ปย\u{e38}โรปและแอฟร\u{e34}กา"),
            keywords: &[
                "ย\u{e38}โรป",
                "ล\u{e39}กโลก",
                "ล\u{e39}กโลกแสดงทว\u{e35}ปย\u{e38}โรปและแอฟร\u{e34}กา",
                "แอฟร\u{e34}กา",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("Ýewropa-Afrikany görkezýän globus"),
            keywords: &[
                "Afrika",
                "dünýä",
                "Ýewropa",
                "Ýewropa-Afrikany görkezýän globus",
                "ýer",
                "ýer togalagy",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("kolope ʻasi mai ʻEulope-ʻAfilika"),
            keywords: &["kolope ʻasi mai ʻEulope-ʻAfilika"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("yerkürede Avrupa-Afrika"),
            keywords: &["Afrika", "Avrupa", "dünya", "yerkürede Avrupa-Afrika"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ياۋروپا-ئافرىقىنى كۆرسەتكەن گىلوبۇس"),
            keywords: &[
                "ئافرىقا",
                "دۇنيا",
                "ياۋروپا",
                "ياۋروپا-ئافرىقىنى كۆرسەتكەن گىلوبۇس",
                "يەرشارى",
                "گىلوبۇس",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("глобус, що показує Європу й Африку"),
            keywords: &[
                "африка",
                "глобус",
                "глобус, що показує Європу й Африку",
                "земля",
                "світ",
                "європа",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("یورپ اور افریقہ کو دکھاتا گلوب"),
            keywords: &[
                "افریقہ",
                "دنیا",
                "زمین",
                "گلوب",
                "یورپ اور افریقہ کو دکھاتا گلوب",
            ],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("globusda yevropa va afrika qit’asi"),
            keywords: &[
                "afrika",
                "dunyo",
                "globus",
                "globusda yevropa va afrika qit’asi",
                "yer",
                "yevropa",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("địa cầu thể hiện Châu Âu-Châu Phi"),
            keywords: &[
                "Châu Phi",
                "Châu Âu",
                "thế giới",
                "trái đất",
                "địa cầu",
                "địa cầu thể hiện Châu Âu-Châu Phi",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("glob buy wane ërop ak afrik"),
            keywords: &[
                "Africa",
                "glob",
                "glob buy wane ërop ak afrik",
                "suuf",
                "Ërop",
                "àdduna",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("iglobhu ebonisa iYurophu-Afrika"),
            keywords: &[
                "Afrika",
                "Yurophu",
                "iglobhu",
                "iglobhu ebonisa iYurophu-Afrika",
                "ihlabathi",
                "umhlaba",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Gulobu To N Ṣafihan Uropu-Afirika"),
            keywords: &[
                "Gulobu To N Ṣafihan Uropu-Afirika",
                "ayé",
                "gílóbù",
                "àgbáyé",
                "áfíríkà",
                "írópù",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("顯示歐洲 - 非洲嘅地球儀"),
            keywords: &[
                "世界",
                "地球",
                "地球儀",
                "歐洲",
                "非洲",
                "顯示歐洲 - 非洲嘅地球儀",
            ],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("显示欧洲 - 非洲嘅地球仪"),
            keywords: &[
                "世界",
                "地球",
                "地球仪",
                "显示欧洲 - 非洲嘅地球仪",
                "欧洲",
                "非洲",
            ],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("地球上的欧洲非洲"),
            keywords: &["世界", "地球", "地球上的欧洲非洲", "欧洲", "非洲"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("歐洲及非洲"),
            keywords: &["地球", "歐洲及非洲"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("顯示歐洲同非洲嘅地球"),
            keywords: &[
                "地球",
                "星球",
                "非洲地球",
                "顯示歐洲同非洲嘅地球",
                "顯示歐洲和非洲的地球",
            ],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("igilobhu eliveza i-europe-afrika"),
            keywords: &[
                "afrika",
                "europe",
                "igilobhu",
                "igilobhu eliveza i-europe-afrika",
                "umhlaba",
            ],
        },
    ],
};
#[doc = "🌎"]
pub const GLOBE_SHOWING_AMERICAS: crate::Emoji = crate::Emoji {
    glyph: "🌎",
    codepoint: "1F30E",
    status: crate::Status::FullyQualified,
    introduction_version: 0.7f32,
    name: "globe showing Americas",
    group: "Travel & Places",
    subgroup: "place-map",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("aardbol met amerikas"),
            keywords: &[
                "aardbol",
                "aardbol met amerikas",
                "aarde",
                "amerika",
                "wêreld",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ሰሜንና ደቡብ አሜሪካ የሚያሳይ ሉል"),
            keywords: &[
                "ሉል",
                "መሬት",
                "ሰሜንና ደቡብ አሜሪካ",
                "ሰሜንና ደቡብ አሜሪካ የሚያሳይ ሉል",
                "ዓለም",
            ],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("\u{202b}كرة أرضية تعرض الأمريكتين"),
            keywords: &["أمريكا", "\u{202b}كرة أرضية تعرض الأمريكتين"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("গ\u{9cd}ল’বত আমেৰিক\u{9be} দেখ\u{9c1}ৱ\u{9be}ইছে"),
            keywords: &[
                "আমেৰিক\u{9be}",
                "গ\u{9cd}ল’ব",
                "গ\u{9cd}ল’বত আমেৰিক\u{9be} দেখ\u{9c1}ৱ\u{9be}ইছে",
                "প\u{9c3}থিৱী",
                "বিশ\u{9cd}ব",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("amerika-qitələrini göstərən qlobus"),
            keywords: &[
                "amerika",
                "amerika-qitələrini göstərən qlobus",
                "dünya",
                "qlobus",
                "yer kürəsi",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("зямны шар (паўночная і паўднёвая амерыкі)"),
            keywords: &[
                "зямля",
                "зямны шар (паўночная і паўднёвая амерыкі)",
                "паўднёвая амерыка",
                "паўночная амерыка",
                "свет",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("глобус със Северна и Южна Америка"),
            keywords: &[
                "глобус",
                "глобус със Северна и Южна Америка",
                "земята",
                "северна америка",
                "южна америка",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("গ\u{9cd}লোব আমেরিক\u{9be} দেখ\u{9be}চ\u{9cd}ছে"),
            keywords: &[
                "আমেরিক\u{9be}",
                "গ\u{9cd}লোব",
                "গ\u{9cd}লোব আমেরিক\u{9be} দেখ\u{9be}চ\u{9cd}ছে",
                "প\u{9c3}থিবী",
                "বিশ\u{9cd}ব",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("boul douar o tiskouez Amerika"),
            keywords: &[
                "Amerika",
                "bed",
                "boul",
                "boul douar o tiskouez Amerika",
                "douar",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("globus prikazuje Sjevernu i Južnu Ameriku"),
            keywords: &[
                "Amerika",
                "Zemlja",
                "globus prikazuje Sjevernu i Južnu Ameriku",
                "svijet",
                "zemaljska kugla",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("globus terraqüi amb Amèrica"),
            keywords: &["Amèrica", "globus terraqüi amb Amèrica", "món"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎡᎶᎯ ᏗᏟᎶᏍᏔᏅ ᎬᏂᎨᏒ ᏂᎬᎾ ᎠᎹᏰᎵ"),
            keywords: &[
                "ᎠᎺᎵᎧᏏ",
                "ᎡᎶᎯ",
                "ᎡᎶᎯ ᏗᏟᎶᏍᏔᏅ",
                "ᎡᎶᎯ ᏗᏟᎶᏍᏔᏅ ᎬᏂᎨᏒ ᏂᎬᎾ ᎠᎹᏰᎵ",
                "ᎧᎵ ᎡᎶᎯ",
            ],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("glóbus se Severní a Jižní Amerikou"),
            keywords: &[
                "amerika",
                "glóbus se Severní a Jižní Amerikou",
                "svět",
                "země",
                "zeměkoule",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("glôb yn dangos yr Americas"),
            keywords: &["Americas", "byd", "glôb yn dangos yr Americas", "y ddaear"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("globus med Nord- og Sydamerika"),
            keywords: &[
                "Amerika",
                "Nord- og Sydamerika",
                "globus med Nord- og Sydamerika",
                "jorden",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Globus mit Amerika"),
            keywords: &[
                "Globus mit Amerika",
                "Nordamerika",
                "Südamerika",
                "Weltkugel",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("υδρόγειος με Βόρεια και Νότια Αμερική"),
            keywords: &[
                "Αμερική",
                "γη",
                "κόσμος",
                "υδρόγειος",
                "υδρόγειος με Βόρεια και Νότια Αμερική",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("globe showing Americas"),
            keywords: &[
                "Americas",
                "earth",
                "globe",
                "globe showing Americas",
                "world",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("globo terráqueo mostrando América"),
            keywords: &[
                "América",
                "Tierra",
                "globo",
                "globo terráqueo mostrando América",
                "mundo",
                "planeta",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("globo terráqueo América"),
            keywords: &["América", "globo", "mapa", "terráqueo"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &[
                "América",
                "globo",
                "globo terraqueo",
                "globo terraqueo América",
                "globo terráqueo América",
                "tierra",
            ],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("Ameerika mandrid gloobusel"),
            keywords: &[
                "Ameerika",
                "Ameerika mandrid gloobusel",
                "gloobus",
                "maa",
                "maailm",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("america ikusgai duen lur-globoa"),
            keywords: &[
                "america ikusgai duen lur-globoa",
                "amerika",
                "globo",
                "lur",
                "mundu",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("نقشه\u{654} قاره\u{654} امریکا روی کره"),
            keywords: &[
                "امریکای شمالی و جنوبی",
                "جهان",
                "دنیا",
                "زمین",
                "نقشه\u{654} قاره\u{654} امریکا روی کره",
                "کره\u{654} جغرافیایی",
                "کره\u{654} زمین",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("maapallo jossa näkyy Amerikka"),
            keywords: &[
                "Amerikka",
                "maailma",
                "maapallo",
                "maapallo jossa näkyy Amerikka",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("globong nagpapakita sa America"),
            keywords: &[
                "america",
                "amerika",
                "globo",
                "globong nagpapakita sa America",
                "globong nagpapakita sa hilaga at timog amerika",
                "mundo",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("globus har Amerika sæst"),
            keywords: &[
                "Amerika",
                "globus",
                "globus har Amerika sæst",
                "heimurin",
                "jørðin",
                "verðin",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("globe tourné sur les Amériques"),
            keywords: &["amérique", "globe tourné sur les Amériques"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("globe qui montre l’Amérique"),
            keywords: &["Amérique", "globe", "globe qui montre l’Amérique", "monde"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("cruinneog ag taispeáint Chríocha Mheiriceá"),
            keywords: &[
                "Meiriceá",
                "an domhan",
                "cruinneog",
                "cruinneog ag taispeáint Chríocha Mheiriceá",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("cruinne le Aimeireaga"),
            keywords: &[
                "aimeireaga",
                "cruinne",
                "cruinne le Aimeireaga",
                "globa",
                "globa a’ sealltainn an dà Aimeireaga",
                "saoghal",
                "talamh",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("globo terráqueo América"),
            keywords: &["América", "Terra", "globo terráqueo América", "mundo"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("અમ\u{ac7}રિકા બતાવતો પ\u{ac3}થ\u{acd}વીનો ગોળો"),
            keywords: &[
                "અમ\u{ac7}રિકા",
                "અમ\u{ac7}રિકા બતાવત\u{ac1}\u{a82} ગ\u{acd}લોબ",
                "અમ\u{ac7}રિકા બતાવતો પ\u{ac3}થ\u{acd}વીનો ગોળો",
                "અમ\u{ac7}રિકાઝ બતાવતી ગ\u{acd}લોબ",
                "ગ\u{acd}લોબ",
                "પ\u{ac3}થ\u{acd}વી",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("gulob mai nunawa Ƙasashen Amurika"),
            keywords: &[
                "duniya",
                "gulab na duniya",
                "gulob mai nunawa Ƙasashen Amurika",
                "Ƙasashen Amurka",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("גלובוס עם אמריקה"),
            keywords: &["אמריקה", "גלובוס", "גלובוס עם אמריקה", "כדור הארץ", "עולם"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ग\u{94d}लोब, प\u{943}थ\u{94d}वी, अम\u{947}रिकाज\u{93c}, अम\u{947}रिका"),
            keywords: &[
                "अम\u{947}रिका",
                "अम\u{947}रिकाज\u{93c}",
                "ग\u{94d}लोब",
                "ग\u{94d}लोब, प\u{943}थ\u{94d}वी, अम\u{947}रिकाज\u{93c}, अम\u{947}रिका",
                "प\u{943}थ\u{94d}वी",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("globus s prikazom Amerika"),
            keywords: &[
                "Amerika",
                "Zemlja",
                "globus",
                "globus s prikazom Amerika",
                "južna",
                "sjeverna",
                "svijet",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("Amerikát mutató földgömb"),
            keywords: &[
                "Amerika",
                "Amerikát mutató földgömb",
                "föld",
                "földgömb",
                "földrajz",
                "világ",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("Ամերիկաները պատկերող գլոբուս"),
            keywords: &[
                "Ամերիկաներ",
                "Ամերիկաները պատկերող գլոբուս",
                "աշխարհ",
                "գլոբուս",
                "երկիր",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("bola dunia Amerika"),
            keywords: &["amerika", "bola dunia Amerika", "bumi", "dunia", "globe"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ụwa dum na-egosi Amerikansị"),
            keywords: &[
                "Amerikansi",
                "ụwa",
                "ụwa dum",
                "ụwa dum na-egosi Amerikansị",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("hnöttur sem sýnir Ameríku"),
            keywords: &[
                "Ameríka",
                "N- og S-Ameríka",
                "hnöttur sem sýnir Ameríku",
                "jörðin",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("America"),
            keywords: &["America", "Americhe", "terra"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("地球（アメリカ大陸）"),
            keywords: &["アメリカ", "アメリカ大陸", "地球", "地球（アメリカ大陸）"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("globe sing nuduhake benua Amerika"),
            keywords: &[
                "Amerika",
                "bumi",
                "donya",
                "globe",
                "globe sing nuduhake benua Amerika",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("გლობუსი, რომელზეც ჩანს ამერიკა"),
            keywords: &[
                "ამერიკა",
                "გლობუსი",
                "გლობუსი, რომელზეც ჩანს ამერიკა",
                "დედამიწა",
                "მსოფლიო",
            ],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("amtiweg timrikin"),
            keywords: &["amtiweg timrikin"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("Екі Америка құрлығы көрсетілген глобус"),
            keywords: &[
                "Екі Америка құрлығы көрсетілген глобус",
                "америка құрлықтары",
                "глобус",
                "жер",
                "әлем",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("globus med nord- og sydamerika"),
            keywords: &[
                "Amerika",
                "Nord- og Sydamerika",
                "globus med nord- og sydamerika",
                "jorden",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ផែនដ\u{17b8}បង\u{17d2}ហាញទ\u{17d2}វ\u{17b8}បអាមេរ\u{17b7}ក"),
            keywords: &[
                "ផែនដ\u{17b8}",
                "ផែនដ\u{17b8}បង\u{17d2}ហាញទ\u{17d2}វ\u{17b8}បអាមេរ\u{17b7}ក",
                "ព\u{17b7}ភពលោក",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಅಮ\u{cc6}ರ\u{cbf}ಕ ತೋರ\u{cbf}ಸುತ\u{ccd}ತ\u{cbf}ರುವ ಭ\u{cc2}ಗೋಳ"),
            keywords: &[
                "ಅಮ\u{cc6}ರ\u{cbf}ಕ ತೋರ\u{cbf}ಸುತ\u{ccd}ತ\u{cbf}ರುವ ಜಗತ\u{ccd}ತು",
                "ಅಮ\u{cc6}ರ\u{cbf}ಕ ತೋರ\u{cbf}ಸುತ\u{ccd}ತ\u{cbf}ರುವ ಭ\u{cc2}ಗೋಳ",
                "ಗೋಳ",
                "ಭ\u{cc2}ಮ\u{cbf}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("미대륙이 보이는 지구"),
            keywords: &["미대륙", "미대륙이 보이는 지구", "미주", "세계", "지구본"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("अम\u{947}रीका दाखोवपी विश\u{94d}वगोल"),
            keywords: &[
                "अम\u{947}रिका",
                "अम\u{947}रिका दाखोवपी विश\u{94d}वगोल",
                "अम\u{947}रीका दाखोवपी विश\u{94d}वगोल",
                "जग",
                "प\u{943}थ\u{94d}वी",
                "विश\u{94d}वगोल",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("американы көрсөткөн глобус"),
            keywords: &[
                "америка",
                "американы көрсөткөн глобус",
                "глобус",
                "дүйнө",
                "жер",
            ],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Globus (zentréiert op Nord-/Südamerika)"),
            keywords: &[
                "Globus",
                "Globus (zentréiert op Nord-/Südamerika)",
                "Nordamerika",
                "Südamerika",
                "Welt",
                "Äerd",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໜ\u{ec8}ວຍໂລກທ\u{eb5}\u{ec8}ສະແດງອາເມລ\u{eb4}ກາ"),
            keywords: &[
                "ອາເມລ\u{eb4}ກາ",
                "ໜ\u{ec8}ວຍໂລກ",
                "ໜ\u{ec8}ວຍໂລກທ\u{eb5}\u{ec8}ສະແດງອາເມລ\u{eb4}ກາ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("žemės rutulys su Šiaurės ir Pietų Amerikos žemynais"),
            keywords: &[
                "Amerika",
                "gaublys",
                "pasaulis",
                "žemė",
                "žemės rutulys su Šiaurės ir Pietų Amerikos žemynais",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("globuss ar Ameriku"),
            keywords: &[
                "Dienvidamerika",
                "Ziemeļamerika",
                "globuss",
                "globuss ar Ameriku",
                "pasaule",
                "zemeslode",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("ao whakakite i ngā Amerika"),
            keywords: &["ao", "ao whakakite i ngā Amerika", "ngā Amerika", "whenua"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("глобус со Јужна и Северна Америка"),
            keywords: &[
                "Америка",
                "глобус",
                "глобус со Јужна и Северна Америка",
                "земја",
            ],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("അമേരിക\u{d4d}ക ക\u{d3e}ണിക\u{d4d}ക\u{d41}ന\u{d4d}ന ഭ\u{d42}ഗോളം"),
            keywords: &[
                "അമേരിക\u{d4d}ക",
                "അമേരിക\u{d4d}ക ക\u{d3e}ണിക\u{d4d}ക\u{d41}ന\u{d4d}ന ഭ\u{d42}ഗോളം",
                "അമേരിക\u{d4d}കൻ",
                "ഗ\u{d4d}ലോബ\u{d4d}",
                "ഭ\u{d42}ഗോളം",
                "ഭ\u{d42}മി",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("Америкийг харуулсан бөмбөрцөг"),
            keywords: &[
                "Америк",
                "Америкийг харуулсан бөмбөрцөг",
                "бөмбөрцөг",
                "дэлхий",
                "харуулах",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("अम\u{947}रिका दर\u{94d}शविणारा प\u{943}थ\u{94d}वीचा गोल"),
            keywords: &[
                "अम\u{947}रिका",
                "अम\u{947}रिका दर\u{94d}शविणारा प\u{943}थ\u{94d}वीचा गोल",
                "जग",
                "प\u{943}थ\u{94d}वी",
                "प\u{943}थ\u{94d}वीचा गोल",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("peta glob Amerika"),
            keywords: &["amerika", "bumi", "dunia", "glob", "peta glob Amerika"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("globu juri l-Ameriki"),
            keywords: &["dinja", "globu", "globu juri l-Ameriki", "l-Ameriki"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "အမေရ\u{102d}ကတ\u{102d}\u{102f}က\u{103a}များက\u{102d}\u{102f} ပြသထားသည\u{1037}\u{103a} ကမ\u{1039}ဘာလ\u{102f}\u{1036}း",
            ),
            keywords: &[
                "ကမ\u{1039}ဘာ",
                "ကမ\u{1039}ဘာမြေ",
                "ကမ\u{1039}ဘာလ\u{102f}\u{1036}း",
                "အမေရ\u{102d}က",
                "အမေရ\u{102d}ကတ\u{102d}\u{102f}က\u{103a}များက\u{102d}\u{102f} ပြသထားသည\u{1037}\u{103a} ကမ\u{1039}ဘာလ\u{102f}\u{1036}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("jordklode med Amerika"),
            keywords: &[
                "Amerika",
                "USA",
                "jorden",
                "jordklode med Amerika",
                "verden",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("अम\u{947}रिका द\u{947}खाउन\u{947} विश\u{94d}वको मानचित\u{94d}र"),
            keywords: &[
                "अम\u{947}रिका",
                "अम\u{947}रिका द\u{947}खाउन\u{947} विश\u{94d}वको मानचित\u{94d}र",
                "प\u{943}थ\u{94d}वी",
                "विश\u{94d}व",
                "स\u{902}सार",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("wereldbol met Noord- en Zuid-Amerika"),
            keywords: &[
                "Noord- en Zuid-Amerika",
                "aarde",
                "wereld",
                "wereldbol",
                "wereldbol met Noord- en Zuid-Amerika",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("jordklode med Amerika"),
            keywords: &["Amerika", "USA", "jorda", "jordklode med Amerika"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଆମେର\u{b3f}କ\u{b3e} ଦେଖ\u{b3e}ଉଥ\u{b3f}ବ\u{b3e} ଗ\u{b4d}ଲୋବ\u{b4d}\u{200c}"),
            keywords: &[
                "ଆମେର\u{b3f}କ\u{b3e}",
                "ଆମେର\u{b3f}କ\u{b3e} ଦେଖ\u{b3e}ଉଥ\u{b3f}ବ\u{b3e} ଗ\u{b4d}ଲୋବ\u{b4d}\u{200c}",
                "ଆମେର\u{b3f}କୀୟ",
                "ପ\u{b43}ଥ\u{b3f}ବୀ",
                "ବ\u{b3f}ଶ\u{b4d}ଵ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਅਮਰੀਕਾ ਵਿਖਾਉ\u{a02}ਦਾ ਗਲ\u{a4b}ਬ"),
            keywords: &[
                "ਅਮਰੀਕਾ",
                "ਅਮਰੀਕਾ ਵਿਖਾਉ\u{a02}ਦਾ ਗਲ\u{a4b}ਬ",
                "ਧਰਤੀ",
                "ਸ\u{a70}ਸਾਰ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("گلوب امریکہ یکھا رہیا اے"),
            keywords: &[
                "ارض نما کرہ",
                "امریکہ دے رہن آلے",
                "دنیا",
                "زمین",
                "گلوب امریکہ یکھا رہیا اے",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Raúnd Wọ\u{301}ld Map Wé De Shó Amẹ\u{301}ríkas"),
            keywords: &[
                "Glob",
                "Land-dẹm Wé Dé Fọ Nọ\u{301}t An Saút Amẹ\u{301}ríka",
                "Map",
                "Raúnd Wọ\u{301}ld Map",
                "Raúnd Wọ\u{301}ld Map Wé De Shó Amẹ\u{301}ríkas",
                "Raúnd Wọ\u{301}ld Map Wẹ De Shó Land-dẹm Wé Dé Fọ Nọ\u{301}t An Saút Amẹ\u{301}ríka",
                "Wọld",
                "Ẹt",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("kula ziemska przedstawiająca Ameryki"),
            keywords: &[
                "Ameryka",
                "Ameryka Północna i Południowa",
                "Ziemia",
                "kula ziemska przedstawiająca Ameryki",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("نړۍ ښيي امریکا"),
            keywords: &["امريکا", "زمکه", "نړۍ", "نړۍ ښيي امریکا"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("globo mostrando as Américas"),
            keywords: &[
                "América",
                "Terra",
                "as Américas",
                "globo mostrando as Américas",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("globo com as Américas visíveis"),
            keywords: &[
                "Américas",
                "Terra",
                "globo",
                "globo com as Américas visíveis",
                "mundo",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("saywasiqʼi america qawachkan"),
            keywords: &[
                "America",
                "kawsay pacha",
                "pacha",
                "saywasiqʼi america qawachkan",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("Americile pe glob"),
            keywords: &["Americi", "Americile pe glob", "Pământ", "glob", "lume"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-213"),
            keywords: &["E10-213"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("Америка на земном шаре"),
            keywords: &[
                "Америка",
                "Америка на земном шаре",
                "Северная Америка",
                "Южная Америка",
                "земной шар",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umubumbe w’isi werekana Amerika zombi"),
            keywords: &[
                "Amerika",
                "isi",
                "umubumbe w’isi",
                "umubumbe w’isi werekana Amerika zombi",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("گلوب آمريڪا ڏيکاري پيو"),
            keywords: &["آمريڪا، زمين، گلوب، دنيا", "گلوب آمريڪا ڏيکاري پيو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ඇමෙර\u{dd2}ක\u{dcf}ව පෙන\u{dca}වන ලෝක ගෝලය"),
            keywords: &[
                "ඇමර\u{dd2}ක\u{dcf}ව",
                "ඇමෙර\u{dd2}ක\u{dcf}ව පෙන\u{dca}වන ලෝක ගෝලය",
                "පෘථ\u{dd2}ව\u{dd2}ය",
                "ලෝක ගෝලය",
                "ලෝකය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("zemeguľa s\u{a0}Amerikou"),
            keywords: &[
                "amerika",
                "glóbus",
                "svet",
                "zem",
                "zemeguľa s\u{a0}Amerikou",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("globus s Severno in Južno Ameriko"),
            keywords: &[
                "Ameriki",
                "globus",
                "globus s Severno in Južno Ameriko",
                "svet",
                "zemlja",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("adduunka oo muujinaya Ameerika"),
            keywords: &[
                "Ameerika",
                "adduunka",
                "adduunka muujinaya Ameerika",
                "adduunka oo muujinaya Ameerika",
                "dhulka",
                "dunida",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("globi që tregon Amerikat"),
            keywords: &[
                "Amerikat",
                "Bota",
                "Globi",
                "Toka",
                "globi që tregon Amerikat",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("глобус са Америком"),
            keywords: &[
                "Америке",
                "Земља",
                "глобус",
                "глобус са Америкама",
                "глобус са Америком",
                "свет",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["глобус са Америком"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("globus sa Amerikom"),
            keywords: &[
                "Amerike",
                "Zemlja",
                "globus",
                "globus sa Amerikama",
                "globus sa Amerikom",
                "svet",
            ],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["globus sa Amerikom"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("jordglob nord- och sydamerika"),
            keywords: &[
                "jorden",
                "jordglob",
                "jordglob nord- och sydamerika",
                "nord- och sydamerika",
            ],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("tufe linaloonyesha amerika"),
            keywords: &[
                "dunia",
                "marekani",
                "tufe",
                "tufe linaloonyesha amerika",
                "ulimwengu",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("அமெரிக\u{bcd}க\u{bbe}"),
            keywords: &[
                "அமெரிக\u{bcd}க\u{bbe}",
                "உலக உருண\u{bcd}டை",
                "தென\u{bcd} அமெரிக\u{bcd}க\u{bbe}",
                "பூமி",
                "வட அமெரிக\u{bcd}க\u{bbe}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("అమ\u{c46}ర\u{c3f}క\u{c3e}ను చూప\u{c47} గ\u{c4d}ల\u{c4b}బ\u{c4d}"),
            keywords: &[
                "అమ\u{c46}ర\u{c3f}క\u{c3e}",
                "అమ\u{c46}ర\u{c3f}క\u{c3e}ను చూప\u{c47} గ\u{c4d}ల\u{c4b}బ\u{c4d}",
                "అమ\u{c46}ర\u{c3f}క\u{c3e}స\u{c4d}",
                "భూగ\u{c4b}ళం",
                "భూమ\u{c3f}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("глобусе, ки Америкаҳоро намоиш медиҳад"),
            keywords: &[
                "Америкаҳо",
                "глобус",
                "глобусе, ки Америкаҳоро намоиш медиҳад",
                "замин",
                "ҷаҳон",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ล\u{e39}กโลกแสดงทว\u{e35}ปอเมร\u{e34}กา"),
            keywords: &[
                "ล\u{e39}กโลก",
                "ล\u{e39}กโลกแสดงทว\u{e35}ปอเมร\u{e34}กา",
                "อเมร\u{e34}กา",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("Amerikany görkezýän globus"),
            keywords: &[
                "Amerika",
                "Amerikany görkezýän globus",
                "dünýä",
                "ýer",
                "ýer togalagy",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("kolope ʻasi mai ongo ʻAmelika"),
            keywords: &["kolope ʻasi mai ongo ʻAmelika"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("yerkürede Amerika"),
            keywords: &["Amerika", "Amerika bölgeleri", "dünya", "yerkürede Amerika"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئىككى ئامېرىكىنى كۆرسەتكەن گىلوبۇس"),
            keywords: &[
                "ئامېرىكا",
                "ئىككى ئامېرىكىنى كۆرسەتكەن گىلوبۇس",
                "دۇنيا",
                "يەرشارى",
                "گىلوبۇس",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("глобус, що показує Америки"),
            keywords: &[
                "америка",
                "глобус",
                "глобус, що показує Америки",
                "земля",
                "світ",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("امریکہ کو دکھاتا گلوب"),
            keywords: &["امریکہ", "امریکہ کو دکھاتا گلوب", "دنیا", "زمین", "گلوب"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("globusda amerika qit’asi"),
            keywords: &[
                "amerika",
                "dunyo",
                "globus",
                "globusda amerika qit’asi",
                "yer",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("địa cầu thể hiện Châu Mỹ"),
            keywords: &[
                "Châu Mỹ",
                "thế giới",
                "trái đất",
                "địa cầu",
                "địa cầu thể hiện Châu Mỹ",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("glob buy wane amerik"),
            keywords: &["Amerika", "glob", "glob buy wane amerik", "suuf", "àdduna"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("iglobhu ebonisa i-America"),
            keywords: &[
                "I-Americas",
                "iglobhu",
                "iglobhu ebonisa i-America",
                "ihlabathi",
                "umhlaba",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Gulobu To N Ṣafihan Amẹrika"),
            keywords: &[
                "Gulobu To N Ṣafihan Amẹrika",
                "ayé",
                "gúlóbù",
                "àgbáyé",
                "àwọn amẹ\u{301}ríkà",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("顯示美洲嘅地球儀"),
            keywords: &["世界", "地球", "地球儀", "美洲", "顯示美洲嘅地球儀"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("显示美洲嘅地球仪"),
            keywords: &["世界", "地球", "地球仪", "显示美洲嘅地球仪", "美洲"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("地球上的美洲"),
            keywords: &["世界", "地球", "地球上的美洲", "美洲"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("美洲"),
            keywords: &["地球", "美洲"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("顯示美洲嘅地球"),
            keywords: &["地球", "美洲地球", "顯示美洲嘅地球", "顯示美洲的地球"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("igilobhu eliveza emelika"),
            keywords: &["igilobhu", "igilobhu eliveza emelika", "melika", "umhlaba"],
        },
    ],
};
#[doc = "🌏"]
pub const GLOBE_SHOWING_ASIA_AUSTRALIA: crate::Emoji = crate::Emoji {
    glyph: "🌏",
    codepoint: "1F30F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "globe showing Asia-Australia",
    group: "Travel & Places",
    subgroup: "place-map",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("aardbol met asië-australië"),
            keywords: &[
                "aardbol",
                "aardbol met asië-australië",
                "aarde",
                "asië",
                "australië",
                "wêreld",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("እስያና አውስትራሊያ የሚያሳይ ሉል"),
            keywords: &["ሉል", "መሬት", "አውስትራሊያ", "እስያ", "እስያና አውስትራሊያ የሚያሳይ ሉል"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("\u{202b}كرة أرضية تعرض آسيا وأستراليا"),
            keywords: &["آسيا", "أستراليا", "\u{202b}كرة أرضية تعرض آسيا وأستراليا"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some(
                "গ\u{9cd}ল’বত এছিয\u{9bc}\u{9be}-অষ\u{9cd}ট\u{9cd}ৰেলিয\u{9bc}\u{9be} দেখ\u{9c1}ৱ\u{9be}ইছে",
            ),
            keywords: &[
                "অষ\u{9cd}ট\u{9cd}ৰেলিয\u{9bc}\u{9be}",
                "এছিয\u{9bc}\u{9be}",
                "গ\u{9cd}ল’ব",
                "গ\u{9cd}ল’বত এছিয\u{9bc}\u{9be}-অষ\u{9cd}ট\u{9cd}ৰেলিয\u{9bc}\u{9be} দেখ\u{9c1}ৱ\u{9be}ইছে",
                "প\u{9c3}থিৱী",
                "বিশ\u{9cd}ব",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("asiya-avstraliya qitələrini göstərən qlobus"),
            keywords: &[
                "asiya",
                "asiya-avstraliya qitələrini göstərən qlobus",
                "avstraliya",
                "dünya",
                "qlobus",
                "yer kürəsi",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("зямны шар (аўстралія і азія)"),
            keywords: &[
                "азія",
                "аўстралія",
                "зямля",
                "зямны шар (аўстралія і азія)",
                "свет",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("глобус с Азия и Австралия"),
            keywords: &[
                "австралия",
                "азия",
                "глобус",
                "глобус с Азия и Австралия",
                "земята",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some(
                "গ\u{9cd}লোব এশিয\u{9bc}\u{9be}-অস\u{9cd}ট\u{9cd}রেলিয\u{9bc}\u{9be} দেখ\u{9be}চ\u{9cd}ছে",
            ),
            keywords: &[
                "অস\u{9cd}ট\u{9cd}রেলিয\u{9bc}\u{9be}",
                "এশিয\u{9bc}\u{9be}",
                "গ\u{9cd}লোব",
                "গ\u{9cd}লোব এশিয\u{9bc}\u{9be}-অস\u{9cd}ট\u{9cd}রেলিয\u{9bc}\u{9be} দেখ\u{9be}চ\u{9cd}ছে",
                "প\u{9c3}থিবী",
                "বিশ\u{9cd}ব",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("boul douar o tiskouez Azia hag Aostralia"),
            keywords: &[
                "Aostralia",
                "Azia",
                "bed",
                "boul",
                "boul douar o tiskouez Azia hag Aostralia",
                "douar",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("globus pokazuje Aziju i Australiju"),
            keywords: &[
                "Zemlja",
                "globus",
                "globus pokazuje Aziju i Australiju",
                "svijet",
                "zemaljska kugla",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("globus terraqüi amb Àsia i Austràlia"),
            keywords: &[
                "Austràlia",
                "globus terraqüi amb Àsia i Austràlia",
                "món",
                "Àsia",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎡᎶᎯ ᏗᏟᎶᏍᏔᏅ ᎬᏂᎨᏒ ᏂᎬᎾ ᏓᎶᏂᎨ-ᎡᎳᏗ"),
            keywords: &[
                "ᎡᎳᏗᏜ",
                "ᎡᎶᎯ",
                "ᎡᎶᎯ ᏗᏟᎶᏍᏔᏅ",
                "ᎡᎶᎯ ᏗᏟᎶᏍᏔᏅ ᎬᏂᎨᏒ ᏂᎬᎾ ᏓᎶᏂ-ᎡᎳᏗ",
                "ᎡᎶᎯ ᏗᏟᎶᏍᏔᏅ ᎬᏂᎨᏒ ᏂᎬᎾ ᏓᎶᏂᎨ-ᎡᎳᏗ",
                "ᎧᎵ ᎡᎶᎯ",
                "ᏓᎶᏂᎨᏍᏛ",
            ],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("glóbus s Asií a Austrálií"),
            keywords: &[
                "asie",
                "austrálie",
                "glóbus s Asií a Austrálií",
                "svět",
                "země",
                "zeměkoule",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("glôb yn dangos Asia-Awstralia"),
            keywords: &[
                "Asia",
                "Awstralia",
                "byd",
                "glôb yn dangos Asia-Awstralia",
                "y ddaear",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("globus med Asien og Australien"),
            keywords: &[
                "Asien",
                "Australien",
                "globus med Asien og Australien",
                "jorden",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Globus mit Asien und Australien"),
            keywords: &[
                "Asien",
                "Australien",
                "Globus mit Asien und Australien",
                "Weltkugel",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("υδρόγειος με Ασία και Αυστραλία"),
            keywords: &[
                "Ασία",
                "Αυστραλία",
                "γη",
                "κόσμος",
                "υδρόγειος",
                "υδρόγειος με Ασία και Αυστραλία",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("globe showing Asia-Australia"),
            keywords: &[
                "Asia",
                "Australia",
                "earth",
                "globe",
                "globe showing Asia-Australia",
                "world",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("globo terráqueo mostrando Asia y Australia"),
            keywords: &[
                "Asia",
                "Australia",
                "Tierra",
                "globo terráqueo mostrando Asia y Australia",
                "mundo",
                "planeta",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("globo terráqueo Asia/Oceanía"),
            keywords: &[
                "Asia",
                "Australia",
                "Oceanía",
                "globo",
                "globo terráqueo Asia/Oceanía",
                "mapa",
                "terráqueo",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["Asia", "Australia", "globo", "globo terráqueo Asia/Oceanía"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("Aasia ja Austraalia gloobusel"),
            keywords: &[
                "Aasia",
                "Aasia ja Austraalia gloobusel",
                "austraalia",
                "gloobus",
                "maa",
                "maailm",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("asia eta australia ikusgai dituen lur-globoa"),
            keywords: &[
                "asia",
                "asia eta australia ikusgai dituen lur-globoa",
                "australia",
                "globo",
                "lur",
                "mundu",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("نقشه\u{654} آسیا-اقیانوسیه روی کره"),
            keywords: &[
                "آسیا",
                "استرالیا",
                "جهان",
                "زمین",
                "نقشه\u{654} آسیا-اقیانوسیه روی کره",
                "کره\u{654} جغرافیایی",
                "کره\u{654} زمین",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("maapallo jossa näkyy Aasia ja Australia"),
            keywords: &[
                "Aasia",
                "Australia",
                "maailma",
                "maapallo",
                "maapallo jossa näkyy Aasia ja Australia",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("globong nagpapakita sa asia at australia"),
            keywords: &[
                "asia",
                "australia",
                "globo",
                "globong nagpapakita sa asia at australia",
                "mundo",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("globus har Asia og Avstralia síggjast"),
            keywords: &[
                "Asia",
                "Avstralia",
                "globus",
                "globus har Asia og Avstralia síggjast",
                "heimurin",
                "jørðin",
                "verðin",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("globe tourné sur l’Asie et l’Australie"),
            keywords: &[
                "asie",
                "australie",
                "globe tourné sur l’Asie et l’Australie",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("globe qui montre l’Asie et l’Australie"),
            keywords: &[
                "Asie",
                "Australie",
                "globe",
                "globe qui montre l’Asie et l’Australie",
                "monde",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("cruinneog ag taispeáint na hÁsie agus na hAstráile"),
            keywords: &[
                "an Astráil",
                "an domhan",
                "an Áis",
                "cruinneog",
                "cruinneog ag taispeáint na hÁsie agus na hAstráile",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("cruinne le Àisia ’s Astràilia"),
            keywords: &[
                "astràilia",
                "cruinne",
                "cruinne le Àisia ’s Astràilia",
                "globa",
                "globa a’ sealltainn Àisia agus Astràilia",
                "globa a’ sealltainn Àisia ’s Astràilia",
                "saoghal",
                "talamh",
                "àisia",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("globo terráqueo Asia-Australia"),
            keywords: &[
                "Asia",
                "Australia",
                "Terra",
                "globo terráqueo Asia-Australia",
                "mundo",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("એશિયા-ઓસ\u{acd}ટ\u{acd}ર\u{ac7}લિયા બતાવતો પ\u{ac3}થ\u{acd}વીનો ગોળો"),
            keywords: &[
                "એશિયા",
                "એશિયા-ઓસ\u{acd}ટ\u{acd}ર\u{ac7}લિયા બતાવતી ગ\u{acd}લોબ",
                "એશિયા-ઓસ\u{acd}ટ\u{acd}ર\u{ac7}લિયા બતાવત\u{ac1}\u{a82} ગ\u{acd}લોબ",
                "એશિયા-ઓસ\u{acd}ટ\u{acd}ર\u{ac7}લિયા બતાવતો પ\u{ac3}થ\u{acd}વીનો ગોળો",
                "ઓસ\u{acd}ટ\u{acd}ર\u{ac7}લિયા",
                "ગ\u{acd}લોબ",
                "પ\u{ac3}થ\u{acd}વી",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("gulob na duniya mai nunawa Asia-Australia"),
            keywords: &[
                "Asia",
                "Australia",
                "duniya",
                "gulab na duniya",
                "gulob na duniya mai nunawa Asia-Australia",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("גלובוס עם אסיה ואוסטרליה"),
            keywords: &[
                "אוסטרליה",
                "אסיה",
                "גלובוס",
                "גלובוס עם אסיה ואוסטרליה",
                "כדור הארץ",
            ],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ग\u{94d}लोब, प\u{943}थ\u{94d}वी, एशिया, ऑस\u{94d}ट\u{94d}र\u{947}लिया"),
            keywords: &[
                "एशिया",
                "ऑस\u{94d}ट\u{94d}र\u{947}लिया",
                "ग\u{94d}लोब",
                "ग\u{94d}लोब, प\u{943}थ\u{94d}वी, एशिया, ऑस\u{94d}ट\u{94d}र\u{947}लिया",
                "प\u{943}थ\u{94d}वी",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("globus s prikazom Azije i Australije"),
            keywords: &[
                "Australija",
                "Azija",
                "Zemlja",
                "globus",
                "globus s prikazom Azije i Australije",
                "svijet",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("Ázsiát és Ausztráliát mutató földgömb"),
            keywords: &[
                "Ausztrália",
                "föld",
                "világ",
                "Ázsia",
                "Ázsiát és Ausztráliát mutató földgömb",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("Ասիան և Ավստրալիան պատկերող գլոբուս"),
            keywords: &[
                "Ասիա",
                "Ասիան և Ավստրալիան պատկերող գլոբուս",
                "Ավստրալիա",
                "աշխարհ",
                "գլոբուս",
                "երկիր",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("bola dunia Asia-Australia"),
            keywords: &[
                "asia",
                "australia",
                "bola dunia Asia-Australia",
                "bumi",
                "dunia",
                "globe",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ụwa dum na-egosi Asia-Australia"),
            keywords: &[
                "Asia",
                "Australia",
                "ụwa",
                "ụwa dum",
                "ụwa dum na-egosi Asia-Australia",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("hnöttur sem sýnir Asíu-Ástralíu"),
            keywords: &[
                "Asía",
                "hnöttur sem sýnir Asíu-Ástralíu",
                "jörðin",
                "Ástralía",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("Asia e Australia"),
            keywords: &["Asia", "Asia e Australia", "Australia", "terra"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("地球（アジアとオーストラリア）"),
            keywords: &[
                "アジア",
                "オーストラリア",
                "地球",
                "地球（アジアとオーストラリア）",
            ],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("globe sing nuduhake benua Asia-Australia"),
            keywords: &[
                "Asia",
                "Australia",
                "bumi",
                "donya",
                "globe",
                "globe sing nuduhake benua Asia-Australia",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("გლობუსი, რომელზეც ჩანს აზია და ავსტრალია"),
            keywords: &[
                "ავსტრალია",
                "აზია",
                "გლობუსი",
                "გლობუსი, რომელზეც ჩანს აზია და ავსტრალია",
                "დედამიწა",
                "მსოფლიო",
            ],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("amtiweg asya ustralya"),
            keywords: &["amtiweg asya ustralya"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("Азия мен Австралия көрсетілген глобус"),
            keywords: &[
                "Азия мен Австралия көрсетілген глобус",
                "австралия",
                "азия",
                "глобус",
                "жер",
                "әлем",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("globus med asien og australien"),
            keywords: &[
                "Asien",
                "Australien",
                "globus med asien og australien",
                "jorden",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some(
                "ផែនដ\u{17b8}បង\u{17d2}ហាញទ\u{17d2}វ\u{17b8}បអាស\u{17ca}\u{17b8}ន\u{17b7}ងអ\u{17bc}ស\u{17d2}ត\u{17d2}រាល\u{17b8}",
            ),
            keywords: &[
                "ផែនដ\u{17b8}",
                "ផែនដ\u{17b8}បង\u{17d2}ហាញទ\u{17d2}វ\u{17b8}បអាស\u{17ca}\u{17b8}ន\u{17b7}ងអ\u{17bc}ស\u{17d2}ត\u{17d2}រាល\u{17b8}",
                "ព\u{17b7}ភពលោក",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some(
                "ಏಷ\u{cbf}ಯಾ-ಆಸ\u{ccd}ಟ\u{ccd}ರೇಲ\u{cbf}ಯಾ ತೋರ\u{cbf}ಸುತ\u{ccd}ತ\u{cbf}ರುವ ಭ\u{cc2}ಗೋಳ",
            ),
            keywords: &[
                "ಏಷ\u{cbf}ಯಾ-ಆಸ\u{ccd}ಟ\u{ccd}ರೇಲ\u{cbf}ಯಾ ತೋರ\u{cbf}ಸುತ\u{ccd}ತ\u{cbf}ರುವ ಜಗತ\u{ccd}ತು",
                "ಏಷ\u{cbf}ಯಾ-ಆಸ\u{ccd}ಟ\u{ccd}ರೇಲ\u{cbf}ಯಾ ತೋರ\u{cbf}ಸುತ\u{ccd}ತ\u{cbf}ರುವ ಭ\u{cc2}ಗೋಳ",
                "ಗೋಳ",
                "ಭ\u{cc2}ಮ\u{cbf}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("아시아와 호주가 보이는 지구"),
            keywords: &["아시아", "아시아와 호주가 보이는 지구", "지구본", "호주"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("आशिया-ऑस\u{94d}ट\u{94d}र\u{947}लिया दाखोवपी विश\u{94d}वगोल"),
            keywords: &[
                "आशिया",
                "आशिया-ऑस\u{94d}ट\u{94d}र\u{947}लिया दाखोवपी विश\u{94d}वगोल",
                "ऑस\u{94d}ट\u{94d}र\u{947}लिया",
                "जग",
                "प\u{943}थ\u{94d}वी",
                "विश\u{94d}वगोल",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("азия-австралияны көрсөткөн глобус"),
            keywords: &[
                "австралия",
                "азия",
                "азия-австралияны көрсөткөн глобус",
                "дүйнө",
                "жер",
            ],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Globus (zentréiert op Asien an Australien)"),
            keywords: &[
                "Asien",
                "Australien",
                "Globus",
                "Globus (zentréiert op Asien an Australien)",
                "Welt",
                "Äerd",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໜ\u{ec8}ວຍໂລກທ\u{eb5}\u{ec8}ສະແດງອາຊ\u{eb5}-ອ\u{ebb}ດສະຕາລ\u{eb5}"),
            keywords: &[
                "ອາຊ\u{eb5}",
                "ອ\u{ebb}ດສະຕາລ\u{eb5}",
                "ໜ\u{ec8}ວຍໂລກ",
                "ໜ\u{ec8}ວຍໂລກທ\u{eb5}\u{ec8}ສະແດງອາຊ\u{eb5}-ອ\u{ebb}ດສະຕາລ\u{eb5}",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("žemės rutulys su Azijos ir Australijos žemynais"),
            keywords: &[
                "Australija",
                "Azija",
                "gaublys",
                "pasaulis",
                "žemė",
                "žemės rutulys su Azijos ir Australijos žemynais",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("globuss ar Āziju un Austrāliju"),
            keywords: &[
                "Austrālija",
                "globuss",
                "globuss ar Āziju un Austrāliju",
                "pasaule",
                "zemeslode",
                "Āzija",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("ao whakakite Āhia-Ahitereiria"),
            keywords: &[
                "Ahitereiria",
                "ao",
                "ao whakakite Āhia-Ahitereiria",
                "whenua",
                "Āhia",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("глобус со Азија и Австралија"),
            keywords: &[
                "Австралија",
                "Азија",
                "глобус",
                "глобус со Азија и Австралија",
                "земја",
                "свет",
            ],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some(
                "ഏഷ\u{d4d}യ-ഓസ\u{d4d}\u{200c}ട\u{d4d}രേലിയ ക\u{d3e}ണിക\u{d4d}ക\u{d41}ന\u{d4d}ന ഭ\u{d42}ഗോളം",
            ),
            keywords: &[
                "ആസ\u{d4d}ട\u{d4d}രേലിയ",
                "ആസ\u{d4d}ത\u{d4d}രേലിയ",
                "ഏഷ\u{d4d}യ",
                "ഏഷ\u{d4d}യ-ഓസ\u{d4d}\u{200c}ട\u{d4d}രേലിയ ക\u{d3e}ണിക\u{d4d}ക\u{d41}ന\u{d4d}ന ഭ\u{d42}ഗോളം",
                "ഓസ\u{d4d}ത\u{d4d}രേലിയ",
                "ഗ\u{d4d}ലോബ\u{d4d}",
                "ഭ\u{d42}ഗോളം",
                "ഭ\u{d42}മി",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("Ази-Австралийг харуулсан бөмбөрцөг"),
            keywords: &[
                "Австрали",
                "Ази",
                "Ази-Австралийг харуулсан бөмбөрцөг",
                "бөмбөрцөг",
                "дэлхий",
                "харуулах",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some(
                "आशिया-ऑस\u{94d}ट\u{94d}र\u{947}लिया दर\u{94d}शविणारा प\u{943}थ\u{94d}वीचा गोल",
            ),
            keywords: &[
                "आशिया",
                "आशिया-ऑस\u{94d}ट\u{94d}र\u{947}लिया दर\u{94d}शविणारा प\u{943}थ\u{94d}वीचा गोल",
                "ऑस\u{94d}ट\u{94d}र\u{947}लिया",
                "जग",
                "प\u{943}थ\u{94d}वी",
                "प\u{943}थ\u{94d}वीचा गोल",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("peta glob Asia-Australia"),
            keywords: &[
                "asia",
                "australia",
                "bumi",
                "dunia",
                "glob",
                "peta glob Asia-Australia",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("globu juri l-Asja-Awstralja"),
            keywords: &[
                "dinja",
                "globu",
                "globu juri l-Asja-Awstralja",
                "l-Asja",
                "l-Awstralja",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "အာရ\u{103e}−ဩစတြေးလျက\u{102d}\u{102f} ပြသထားသည\u{1037}\u{103a} ကမ\u{1039}ဘာလ\u{102f}\u{1036}း",
            ),
            keywords: &[
                "ကမ\u{1039}ဘာ",
                "ကမ\u{1039}ဘာမြေ",
                "ကမ\u{1039}ဘာလ\u{102f}\u{1036}း",
                "သြစတြေးလျ",
                "အာရ\u{103e}",
                "အာရ\u{103e}-သြစတြေးလျက\u{102d}\u{102f} ပြသထားသည\u{1037}\u{103a} ကမ\u{1039}ဘာလ\u{102f}\u{1036}း",
                "အာရ\u{103e}−ဩစတြေးလျက\u{102d}\u{102f} ပြသထားသည\u{1037}\u{103a} ကမ\u{1039}ဘာလ\u{102f}\u{1036}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("jordklode med Asia og Australia"),
            keywords: &[
                "Asia",
                "Australia",
                "jorden",
                "jordklode med Asia og Australia",
                "verden",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some(
                "एसिया-अस\u{94d}ट\u{94d}र\u{947}लिया द\u{947}खाउन\u{947} विश\u{94d}वको मानचित\u{94d}र",
            ),
            keywords: &[
                "अस\u{94d}ट\u{94d}र\u{947}लिया",
                "एसिया",
                "एसिया-अस\u{94d}ट\u{94d}र\u{947}लिया द\u{947}खाउन\u{947} विश\u{94d}वको मानचित\u{94d}र",
                "प\u{943}थ\u{94d}वी",
                "विश\u{94d}व",
                "स\u{902}सार",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("wereldbol met Azië-Australië"),
            keywords: &[
                "Australië",
                "Azië",
                "aarde",
                "wereld",
                "wereldbol",
                "wereldbol met Azië-Australië",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("jordklode med Asia og Australia"),
            keywords: &[
                "Asia",
                "Australia",
                "jorda",
                "jordklode med Asia og Australia",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some(
                "ଏସ\u{b3f}ଆ-ଅଷ\u{b4d}ଟ\u{b4d}ରେଲ\u{b3f}ଆ ଦେଖ\u{b3e}ଉଥ\u{b3f}ବ\u{b3e} ଗ\u{b4d}ଲୋବ\u{b4d}\u{200c}",
            ),
            keywords: &[
                "ଅଷ\u{b4d}ଟ\u{b4d}ରେଲ\u{b3f}ଆ",
                "ଏସ\u{b3f}ଆ",
                "ଏସ\u{b3f}ଆ-ଅଷ\u{b4d}ଟ\u{b4d}ରେଲ\u{b3f}ଆ ଦେଖ\u{b3e}ଉଥ\u{b3f}ବ\u{b3e} ଗ\u{b4d}ଲୋବ\u{b4d}\u{200c}",
                "ପ\u{b43}ଥ\u{b3f}ବୀ",
                "ବ\u{b3f}ଶ\u{b4d}ଵ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਏਸ\u{a3c}ੀਆ-ਆਸਟ\u{a4d}ਰ\u{a47}ਲੀਆ ਵਿਖਾਉ\u{a02}ਦਾ ਗਲ\u{a4b}ਬ"),
            keywords: &[
                "ਆਸਟਰ\u{a47}ਲੀਆ",
                "ਏਸ\u{a3c}ੀਆ",
                "ਏਸ\u{a3c}ੀਆ-ਆਸਟ\u{a4d}ਰ\u{a47}ਲੀਆ ਵਿਖਾਉ\u{a02}ਦਾ ਗਲ\u{a4b}ਬ",
                "ਧਰਤੀ",
                "ਸ\u{a70}ਸਾਰ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("گلوب ایشیا ـ آسٹریلیا وکھا رہیا اے"),
            keywords: &[
                "آسٹریلیا",
                "ارض نما کرہ",
                "ایشیاء",
                "دنیا",
                "زمین",
                "گلوب ایشیا ـ آسٹریلیا وکھا رہیا اے",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Raúnd Wọ\u{301}ld Map Wé De Shó Éshia-Ọstrélia"),
            keywords: &[
                "Glob",
                "Raúnd Wọ\u{301}ld Map Wé De Shó Éshia-Ọstrélia",
                "Raúnd Wọ\u{301}ld Map Wẹ De Shó Land-dẹm Wé Dé Fọ Éshia-Ọstrélia",
                "Wọld",
                "Éshia",
                "Ẹt",
                "Ọstrélia",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("kula ziemska przedstawiająca Azję i Australię"),
            keywords: &[
                "Australia",
                "Azja",
                "Ziemia",
                "kula ziemska przedstawiająca Azję i Australię",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("نړۍ ښيي آسیا - آسټرالیا"),
            keywords: &["آسيا", "آسټراليا", "نړۍ", "نړۍ ښيي آسیا - آسټرالیا", "ځمکه"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("globo mostrando Ásia e Oceania"),
            keywords: &[
                "Austrália",
                "Terra",
                "globo mostrando Ásia e Oceania",
                "Ásia",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("globo a mostrar Ásia e Austrália"),
            keywords: &[
                "Austrália",
                "Terra",
                "globo",
                "globo a mostrar Ásia e Austrália",
                "globo com a Ásia e a Austrália visíveis",
                "mundo",
                "Ásia",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("saywasiqʼi asia, austrakia qawachkan"),
            keywords: &[
                "Asia",
                "Australia",
                "kawsay pacha",
                "pacha",
                "saywasiqʼi asia, austrakia qawachkan",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("Asia și Australia pe glob"),
            keywords: &[
                "Asia",
                "Asia și Australia pe glob",
                "Australia",
                "glob",
                "lume",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-214"),
            keywords: &["E10-214"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("Азия и Австралия на земном шаре"),
            keywords: &[
                "Австралия",
                "Азия",
                "Азия и Австралия на земном шаре",
                "Земля",
                "глобус",
                "земной шар",
                "шар",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umubumbe w’isi werekana Aziya na Ositarariya"),
            keywords: &[
                "Aziya",
                "Ositarariya",
                "isi",
                "umubumbe w’isi",
                "umubumbe w’isi werekana Aziya na Ositarariya",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("گلوب ايشيا آسٽريليا ڏيکاري پيو"),
            keywords: &[
                "ايشيا، آسٽريليا، زمين، گلوب، دنيا",
                "گلوب ايشيا آسٽريليا ڏيکاري پيو",
            ],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some(
                "ආස\u{dd2}ය\u{dcf}-ඕස\u{dca}ට\u{dca}\u{200d}රේල\u{dd2}ය\u{dcf}ව පෙන\u{dca}වන ලෝක ගෝලය",
            ),
            keywords: &[
                "ආස\u{dd2}ය\u{dcf}-ඕස\u{dca}ට\u{dca}\u{200d}රේල\u{dd2}ය\u{dcf}ව පෙන\u{dca}වන ලෝක ගෝලය",
                "ආස\u{dd2}ය\u{dcf}ව",
                "ඕස\u{dca}ට\u{dca}\u{200d}රේල\u{dd2}ය\u{dcf}ව",
                "පෘථ\u{dd2}ව\u{dd2}ය",
                "ලෝක ගෝලය",
                "ලෝකය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("zemeguľa s Áziou a Austráliou"),
            keywords: &[
                "austrália",
                "glóbus",
                "svet",
                "zem",
                "zemeguľa s Áziou a Austráliou",
                "ázia",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("globus z Azijo in Avstralijo"),
            keywords: &[
                "Avstralija",
                "Azija",
                "globus",
                "globus z Azijo in Avstralijo",
                "svet",
                "zemlja",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("adduunka muujinaya Aasiya-Awstaraaliya"),
            keywords: &[
                "Aasiya",
                "Awstaraaliya",
                "adduunka",
                "adduunka muujinaya Aasiya-Awstaraaliya",
                "dhulka",
                "dunida",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("globi që tregon Azinë dhe Australinë"),
            keywords: &[
                "Australi",
                "Azi",
                "Bota",
                "globi që tregon Azinë dhe Australinë",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("глобус са Азијом и Аустралијом"),
            keywords: &[
                "Азија",
                "Аустралија",
                "Земља",
                "глoбус",
                "глобус са Азијом и Аустралијом",
                "свeт",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["глобус са Азијом и Аустралијом"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("globus sa Azijom i Australijom"),
            keywords: &[
                "Australija",
                "Azija",
                "Zemlja",
                "globus",
                "globus sa Azijom i Australijom",
                "svet",
            ],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["globus sa Azijom i Australijom"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("jordglob Asien–Australien"),
            keywords: &["Asien", "Australien", "jorden", "jordglob Asien–Australien"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("tufe linaloonyesha asia-australia"),
            keywords: &[
                "asia",
                "australia",
                "dunia",
                "tufe",
                "tufe linaloonyesha asia-australia",
                "ulimwengu",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ஆசிய\u{bbe}-ஆஸ\u{bcd}திரேலிய\u{bbe}"),
            keywords: &[
                "ஆசிய\u{bbe}",
                "ஆசிய\u{bbe}-ஆஸ\u{bcd}திரேலிய\u{bbe}",
                "ஆஸ\u{bcd}திரேலிய\u{bbe}",
                "உலக உருண\u{bcd}டை",
                "பூமி",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some(
                "ఆస\u{c3f}య\u{c3e}-ఆస\u{c4d}ట\u{c4d}ర\u{c47}ల\u{c3f}య\u{c3e}ను చూప\u{c47} గ\u{c4d}ల\u{c4b}బ\u{c4d}",
            ),
            keywords: &[
                "ఆస\u{c3f}య\u{c3e}",
                "ఆస\u{c3f}య\u{c3e}-ఆస\u{c4d}ట\u{c4d}ర\u{c47}ల\u{c3f}య\u{c3e}ను చూప\u{c47} గ\u{c4d}ల\u{c4b}బ\u{c4d}",
                "ఆస\u{c4d}ట\u{c4d}ర\u{c47}ల\u{c3f}య\u{c3e}",
                "భూగ\u{c4b}ళం",
                "భూమ\u{c3f}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("глобусе, ки Осиё-Австралияро намоиш медиҳад"),
            keywords: &[
                "Австралия",
                "Осиё",
                "глобус",
                "глобусе, ки Осиё-Австралияро намоиш медиҳад",
                "замин",
                "ҷаҳон",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ล\u{e39}กโลกแสดงทว\u{e35}ปเอเช\u{e35}ยและออสเตรเล\u{e35}ย"),
            keywords: &[
                "ล\u{e39}กโลก",
                "ล\u{e39}กโลกแสดงทว\u{e35}ปเอเช\u{e35}ยและออสเตรเล\u{e35}ย",
                "ออสเตรเล\u{e35}ย",
                "เอเช\u{e35}ย",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("Aziýa-Awstraliýany görkezýän globus"),
            keywords: &[
                "Awstraliýa",
                "Aziýa",
                "Aziýa-Awstraliýany görkezýän globus",
                "dünýä",
                "ýer",
                "ýer togalagy",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("kolope ʻasi mai ʻĒsia-ʻAositelēlia"),
            keywords: &["kolope ʻasi mai ʻĒsia-ʻAositelēlia"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("yerkürede Asya-Avustralya"),
            keywords: &["Asya", "Avustralya", "dünya", "yerkürede Asya-Avustralya"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئاسىيا-ئاۋسترالىيەنى كۆرسەتكەن گىلوبۇس"),
            keywords: &[
                "ئاسىيا",
                "ئاسىيا-ئاۋسترالىيەنى كۆرسەتكەن گىلوبۇس",
                "ئاۋسترالىيە",
                "دۇنيا",
                "يەرشارى",
                "گىلوبۇس",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("глобус, що показує Азію і Австралію"),
            keywords: &[
                "австралія",
                "азія",
                "глобус",
                "глобус, що показує Азію і Австралію",
                "земля",
                "світ",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ایشیا اور آسٹریلیا کو دکھاتا گلوب"),
            keywords: &[
                "آسٹریلیا",
                "ایشیا",
                "ایشیا اور آسٹریلیا کو دکھاتا گلوب",
                "زمین",
                "گلوب",
            ],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("globusda osiyo va avstraliya qit’asi"),
            keywords: &[
                "avstraliya",
                "dunyo",
                "globus",
                "globusda osiyo va avstraliya qit’asi",
                "osiyo",
                "yer",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("địa cầu thể hiện Châu Á-Châu Úc"),
            keywords: &[
                "Châu Á",
                "Châu Úc",
                "thế giới",
                "trái đất",
                "địa cầu",
                "địa cầu thể hiện Châu Á-Châu Úc",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("glob buy wane asi ak óstraali"),
            keywords: &[
                "Asi",
                "glob",
                "glob buy wane asi ak óstraali",
                "ostralia",
                "suuf",
                "àdduna",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("iglobhu ebonisa i-Asia-Ostreliya"),
            keywords: &[
                "I-Asia",
                "Ostreliya",
                "iglobhu",
                "iglobhu ebonisa i-Asia-Ostreliya",
                "ihlabathi",
                "umhlaba",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Gulobu To N Ṣafihan Aṣia-Ọsiteria"),
            keywords: &[
                "Gulobu To N Ṣafihan Aṣia-Ọsiteria",
                "ayé",
                "gúlóbù",
                "àgbáyé",
                "áṣíà",
                "ọsiteria",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("顯示亞洲 - 澳洲嘅地球儀"),
            keywords: &[
                "世界",
                "亞洲",
                "地球",
                "地球儀",
                "澳洲",
                "顯示亞洲 - 澳洲嘅地球儀",
            ],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("显示亚洲 - 澳洲嘅地球仪"),
            keywords: &[
                "世界",
                "亚洲",
                "地球",
                "地球仪",
                "显示亚洲 - 澳洲嘅地球仪",
                "澳洲",
            ],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("地球上的亚洲澳洲"),
            keywords: &["世界", "亚洲", "地球", "地球上的亚洲澳洲", "澳洲"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("亞洲及澳洲"),
            keywords: &["亞洲及澳洲", "地球"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("顯示亞洲和澳洲的地球"),
            keywords: &[
                "世界",
                "亞洲和澳洲地球",
                "亞洲地球",
                "地球",
                "顯示亞洲和澳洲的地球",
            ],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("igilobhu eliveza asia-australia"),
            keywords: &[
                "asia",
                "australia",
                "igilobhu",
                "igilobhu eliveza asia-australia",
                "umhlaba",
            ],
        },
    ],
};
#[doc = "🌐"]
pub const GLOBE_WITH_MERIDIANS: crate::Emoji = crate::Emoji {
    glyph: "🌐",
    codepoint: "1F310",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "globe with meridians",
    group: "Travel & Places",
    subgroup: "place-map",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("aardbol met kringlyne"),
            keywords: &[
                "aardbol",
                "aardbol met kringlyne",
                "aarde",
                "kring",
                "lyn",
                "wêreld",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ሜሪዲያኖች ያሉበት ሉል"),
            keywords: &["ሉል", "መሬት", "ሜሪዲያኖች", "ሜሪዲያኖች ያሉበት ሉል", "ዓለም"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("كرة أرضية بخطوط طول"),
            keywords: &["خطوط طول", "كرة أرضية بخطوط طول"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("মেৰিডিয\u{9bc}\u{9be}নৰ সৈতে গ\u{9cd}ল’ব"),
            keywords: &[
                "গ\u{9cd}ল’ব",
                "প\u{9c3}থিৱী",
                "বিশ\u{9cd}ব",
                "মেৰিডিয\u{9bc}\u{9be}ন",
                "মেৰিডিয\u{9bc}\u{9be}নৰ সৈতে গ\u{9cd}ল’ব",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("meridianları olan qlobus"),
            keywords: &[
                "dünya",
                "meridianlar",
                "meridianları olan qlobus",
                "qlobus",
                "yer kürəsi",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("зямны шар з мерыдыянамі"),
            keywords: &["зямля", "зямны шар з мерыдыянамі", "мерыдыяны", "свет"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("глобус с меридиани"),
            keywords: &["глобус", "глобус с меридиани", "земята", "меридиани"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("গ\u{9cd}লোবে মেরিডিয\u{9bc}\u{9be}ন"),
            keywords: &[
                "গ\u{9cd}লোব",
                "গ\u{9cd}লোবে মেরিডিয\u{9bc}\u{9be}ন",
                "প\u{9c3}থিবী",
                "প\u{9c3}থিবীর মধ\u{9cd}যরেখ\u{9be}",
                "বিশ\u{9cd}ব",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("boul douar gant hedredennoù"),
            keywords: &[
                "bed",
                "boul",
                "boul douar gant hedredennoù",
                "douar",
                "hedredennoù",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("globus s meridijanima"),
            keywords: &[
                "Zemlja",
                "globus s meridijanima",
                "meridijani",
                "svijet",
                "zemaljska kugla",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("globus terraqüi amb meridians"),
            keywords: &["globus terraqüi amb meridians", "meridians", "món"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎡᎶᎯ ᏗᏟᎶᏍᏔᏅᎢ ᎬᏩᏠᏯᏍᏗ ᎹᎵᏗᏂᏱᏏ"),
            keywords: &[
                "ᎡᎶᎯ",
                "ᎡᎶᎯ ᏗᏟᎶᏍᏔᏅ",
                "ᎡᎶᎯ ᏗᏟᎶᏍᏔᏅᎢ ᎬᏩᏠᏯᏍᏗ ᎹᎵᏗᏂᏱᏏ",
                "ᎧᎵ ᎡᎶᎯ",
                "ᎹᎵᏗᏯᏂᎢ",
            ],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("glóbus s poledníky a rovnoběžkami"),
            keywords: &[
                "glóbus s poledníky a rovnoběžkami",
                "poledníky",
                "rovnoběžky",
                "svět",
                "země",
                "zeměkoule",
                "zeměpisná síť",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("glôb gyda meridianau"),
            keywords: &["byd", "glôb gyda meridianau", "y ddaear"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("globus med meridianer"),
            keywords: &["breddegrader", "globus med meridianer", "længdegrader"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Globus mit Meridianen"),
            keywords: &["Breitengrad", "Globus mit Meridianen", "Längengrad"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("υδρόγειος με μεσημβρινούς"),
            keywords: &[
                "γη",
                "κόσμος",
                "μεσημβρινοί",
                "υδρόγειος",
                "υδρόγειος με μεσημβρινούς",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("globe with meridians"),
            keywords: &[
                "earth",
                "globe",
                "globe with meridians",
                "meridians",
                "world",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("globo terráqueo con meridianos"),
            keywords: &[
                "Tierra",
                "globo",
                "globo terráqueo con meridianos",
                "meridianos",
                "mundo",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &[
                "Tierra",
                "globo",
                "globo terráqueo con meridianos",
                "meridianos",
                "mundo",
                "paralelos",
                "terráqueo",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &[
                "globo",
                "globo terráqueo con meridianos",
                "meridianos",
                "mundo",
                "paralelos",
                "terráqueo",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &[
                "globo",
                "globo terráqueo con meridianos",
                "meridianos",
                "mundo",
                "paralelos",
                "terráqueo",
            ],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("meridiaanidega gloobus"),
            keywords: &[
                "gloobus",
                "maa",
                "maailm",
                "meridiaanid",
                "meridiaanidega gloobus",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("globoa eta meridianoak"),
            keywords: &[
                "globo",
                "globoa eta meridianoak",
                "lur",
                "meridiano",
                "mundu",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("کره با نصف\u{200c}النهارها"),
            keywords: &[
                "جهان",
                "دنیا",
                "زمین",
                "نصف\u{200c}النهار",
                "کره با نصف\u{200c}النهارها",
                "کره\u{654} جغرافیایی",
                "کره\u{654} زمین",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("maapallo jossa näkyy pituuspiirit"),
            keywords: &[
                "maailma",
                "maapallo",
                "maapallo jossa näkyy pituuspiirit",
                "pituuspiirit",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("globong may mga meridian"),
            keywords: &[
                "globe",
                "globo",
                "globong may mga meridian",
                "meridian",
                "mundo",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("globus við longdarstigum"),
            keywords: &[
                "globus",
                "globus við longdarstigum",
                "heimurin",
                "jørðin",
                "longdarstig",
                "meridianur",
                "verðin",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("globe avec méridiens"),
            keywords: &["globe avec méridiens", "globe terrestre"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("globe qui montre les méridiens"),
            keywords: &[
                "globe",
                "globe qui montre les méridiens",
                "monde",
                "méridiens",
                "terre",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("cruinneog le fadlínte"),
            keywords: &["an domhan", "cruinneog", "cruinneog le fadlínte"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("cruinne le meadhan-loidhnichean"),
            keywords: &[
                "cruinne",
                "cruinne le meadhan-loidhnichean",
                "globa",
                "globa le meadhan-loidhnichean",
                "meadhan-loidhne",
                "meadhan-loidhnichean",
                "saoghal",
                "talamh",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("globo terráqueo con meridianos"),
            keywords: &[
                "Terra",
                "globo",
                "globo terráqueo con meridianos",
                "meridianos",
                "mundo",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("યામ\u{acd}યોત\u{acd}તર વ\u{ac3}ત\u{acd}ત બતાવતો પ\u{ac3}થ\u{acd}વીનો ગોળો"),
            keywords: &[
                "ગ\u{acd}લોબ",
                "યામ\u{acd}યોત\u{acd}તર વ\u{ac3}ત\u{acd}ત",
                "યામ\u{acd}યોત\u{acd}તર વ\u{ac3}ત\u{acd}ત બતાવતી ગ\u{acd}લોબ",
                "યામ\u{acd}યોત\u{acd}તર વ\u{ac3}ત\u{acd}ત બતાવત\u{ac1}\u{a82} ગ\u{acd}લોબ",
                "યામ\u{acd}યોત\u{acd}તર વ\u{ac3}ત\u{acd}ત બતાવતો પ\u{ac3}થ\u{acd}વીનો ગોળો",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("gulob na duniya mai nunawa layukan lokaci"),
            keywords: &[
                "duniya",
                "gulab na duniya",
                "gulob na duniya mai nunawa layukan lokaci",
                "layukan lokaci",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("גלובוס עם קווי אורך ורוחב"),
            keywords: &[
                "גלובוס",
                "גלובוס עם קווי אורך ורוחב",
                "כדור הארץ",
                "קווי אורך",
                "קווי רוחב",
            ],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("द\u{947}शा\u{902}तर र\u{947}खाओ\u{902} क\u{947} साथ ग\u{94d}लोब"),
            keywords: &[
                "ग\u{94d}लोब",
                "ग\u{94d}लोब, विश\u{94d}व र\u{947}खाए\u{902}",
                "द\u{947}शा\u{902}तर र\u{947}खाओ\u{902} क\u{947} साथ ग\u{94d}लोब",
                "विश\u{94d}व र\u{947}खाए\u{902}",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("globus s meridijanima"),
            keywords: &[
                "globus",
                "globus s meridijanima",
                "meridijani",
                "svijet",
                "zemlja",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("földgömb délkörökkel"),
            keywords: &[
                "délkörök",
                "föld",
                "földgömb",
                "földgömb délkörökkel",
                "földrajz",
                "világ",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("միջօրեականներով գլոբուս"),
            keywords: &[
                "աշխարհ",
                "գլոբուս",
                "երկիր",
                "միջօրեականներ",
                "միջօրեականներով գլոբուս",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("bola dunia dengan garis meridian"),
            keywords: &[
                "asia",
                "bola dunia dengan garis meridian",
                "dunia",
                "globe",
                "meridien",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ụwa nwere meridiansị"),
            keywords: &["meridiansị", "ụwa", "ụwa dum", "ụwa nwere meridiansị"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("hnöttur sem sýnir lengdarbauga"),
            keywords: &[
                "breiddargráður",
                "hnöttur sem sýnir lengdarbauga",
                "lengdargráður",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("globo con meridiani"),
            keywords: &["globo con meridiani", "meridiani"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("子午線のある地球"),
            keywords: &["地球", "子午線", "子午線のある地球"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("globe mawa garis meridian"),
            keywords: &[
                "bumi",
                "donya",
                "globe",
                "globe mawa garis meridian",
                "meridian",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("გლობუსი მერიდიანებით"),
            keywords: &[
                "გლობუსი",
                "გლობუსი მერიდიანებით",
                "დედამიწა",
                "მერიდიანები",
                "მსოფლიო",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("Меридиандары көрсетілген глобус"),
            keywords: &[
                "Меридиандары көрсетілген глобус",
                "глобус",
                "жер",
                "меридиан сызықтары",
                "әлем",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("globus med længdegrader"),
            keywords: &["globus med længdegrader", "meridianer"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ផែនដ\u{17b8}ផ\u{17d2}គ\u{17bb}\u{17c6}ដោយខ\u{17d2}សែវណ\u{17d2}ឌ"),
            keywords: &[
                "ផែនដ\u{17b8}",
                "ផែនដ\u{17b8}ផ\u{17d2}គ\u{17bb}\u{17c6}ដោយខ\u{17d2}សែវណ\u{17d2}ឌ",
                "ព\u{17b7}ភពលោក",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಮ\u{cc6}ರ\u{cbf}ಡ\u{cbf}ಯನ\u{ccd}\u{200c}ಗಳ\u{cbf}ರುವ ಭ\u{cc2}ಗೋಳ"),
            keywords: &[
                "ಜಗತ\u{ccd}ತು",
                "ಮ\u{cc6}ರ\u{cbf}ಡ\u{cbf}ಯನ\u{ccd}\u{200c}ಗಳ\u{cbf}ರುವ ಭ\u{cc2}ಗೋಳ",
                "ಮ\u{cc6}ರ\u{cbf}ಡ\u{cbf}ಯನ\u{ccd}\u{200c}ಗಳೊಂದ\u{cbf}ಗ\u{cc6} ಜಗತ\u{ccd}ತು",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("자오선 지구"),
            keywords: &["경도", "위도", "자오선 지구", "지구"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("याम\u{947}यातर व\u{943}त\u{94d}त दाखोवपी विश\u{94d}वगोल"),
            keywords: &[
                "जग",
                "प\u{943}थ\u{94d}वी",
                "याम\u{947}यातर व\u{943}त\u{94d}त",
                "याम\u{947}यातर व\u{943}त\u{94d}त दाखोवपी विश\u{94d}वगोल",
                "विश\u{94d}वगोल",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("меридиан сызыктары менен глобус"),
            keywords: &[
                "глобус",
                "дүйнө",
                "жер",
                "меридиан сызыктары менен глобус",
                "меридиандар",
            ],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Meridianglobus"),
            keywords: &["Globus", "Meridian", "Meridianglobus", "Welt", "Äerd"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໜ\u{ec8}ວຍໂລກທ\u{eb5}\u{ec8}ມ\u{eb5}ເສ\u{eb1}\u{ec9}ນເມຣ\u{eb4}ດຽນ"),
            keywords: &[
                "ເສ\u{eb1}\u{ec9}ນເມຣ\u{eb4}ດຽນ",
                "ໜ\u{ec8}ວຍໂລກ",
                "ໜ\u{ec8}ວຍໂລກທ\u{eb5}\u{ec8}ມ\u{eb5}ເສ\u{eb1}\u{ec9}ນເມຣ\u{eb4}ດຽນ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("žemės rutulys su dienovidiniais"),
            keywords: &[
                "dienovidiniai",
                "gaublys",
                "pasaulis",
                "žemė",
                "žemės rutulys su dienovidiniais",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("globuss ar meridiāniem"),
            keywords: &["globuss", "globuss ar meridiāniem", "meridiāni"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("ao whai poutūmārō"),
            keywords: &["ao", "ao whai poutūmārō", "ngā poutūmārō", "whenua"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("глобус со меридијаните"),
            keywords: &[
                "глобус",
                "глобус со меридијаните",
                "земја",
                "меридијани",
                "свет",
            ],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ധ\u{d4d}ര\u{d41}വരേഖകള\u{d41}ള\u{d4d}ള ഭ\u{d42}ഗോളം"),
            keywords: &[
                "ഗ\u{d4d}ലോബ\u{d4d}",
                "ധ\u{d4d}ര\u{d41}വരേഖ",
                "ധ\u{d4d}ര\u{d41}വരേഖകള\u{d41}ള\u{d4d}ള ഭ\u{d42}ഗോളം",
                "ഭ\u{d42}ഗോളം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("уртраг, өргөргийн зураастай бөмбөрцөг"),
            keywords: &[
                "бөмбөрцөг",
                "дэлхий",
                "зураас",
                "уртраг",
                "уртраг, өргөргийн зураастай бөмбөрцөг",
                "өргөрөг",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("र\u{947}खाव\u{943}त\u{94d}त असल\u{947}ला प\u{943}थ\u{94d}वीचा गोल"),
            keywords: &[
                "जग",
                "प\u{943}थ\u{94d}वी",
                "प\u{943}थ\u{94d}वीचा गोल",
                "र\u{947}खाव\u{943}त\u{94d}त",
                "र\u{947}खाव\u{943}त\u{94d}त असल\u{947}ला प\u{943}थ\u{94d}वीचा गोल",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("glob dengan garisan meridian"),
            keywords: &[
                "bumi",
                "dunia",
                "glob",
                "glob dengan garisan meridian",
                "meridian",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("globu bil-meridjani"),
            keywords: &["dinja", "globu", "globu bil-meridjani", "meridjani"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "လောင\u{103a}ဂျ\u{102e}တ\u{103d}ဒ\u{103a}များပါသည\u{1037}\u{103a} ကမ\u{1039}ဘာလ\u{102f}\u{1036}း",
            ),
            keywords: &[
                "ကမ\u{1039}ဘာ",
                "ကမ\u{1039}ဘာမြေ",
                "ကမ\u{1039}ဘာလ\u{102f}\u{1036}း",
                "လောင\u{103a}ဂျ\u{102e}တ\u{103d}ဒ\u{103a}များ",
                "လောင\u{103a}ဂျ\u{102e}တ\u{103d}ဒ\u{103a}များပါသည\u{1037}\u{103a} ကမ\u{1039}ဘာလ\u{102f}\u{1036}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("jordklode med meridianer"),
            keywords: &[
                "jorden",
                "jordklode med meridianer",
                "lengde- og breddegrader",
                "verden",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("भ\u{942}-मध\u{94d}य र\u{947}खासहितको विश\u{94d}व"),
            keywords: &[
                "प\u{943}थ\u{94d}वी",
                "भ\u{942}-मध\u{94d}य र\u{947}खासहितको विश\u{94d}व",
                "भ\u{942}मध\u{94d}य र\u{947}खा",
                "विश\u{94d}व",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("wereldbol met meridianen"),
            keywords: &[
                "aarde",
                "meridianen",
                "wereld",
                "wereldbol",
                "wereldbol met meridianen",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("jordklode med meridianar"),
            keywords: &[
                "jorda",
                "jordklode med meridianar",
                "lengde- og breiddegrader",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some(
                "ଦ\u{b4d}ର\u{b3e}ଘ\u{b3f}ମ\u{b3e}ଗ\u{b41}ଡ\u{b3c}\u{b3f}କ ଥ\u{b3f}ବ\u{b3e} ଗ\u{b4d}ଲୋବ\u{b4d}\u{200c}",
            ),
            keywords: &[
                "ଦ\u{b4d}ର\u{b3e}ଘ\u{b3f}ମ\u{b3e}",
                "ଦ\u{b4d}ର\u{b3e}ଘ\u{b3f}ମ\u{b3e}ଗ\u{b41}ଡ\u{b3c}\u{b3f}କ ଥ\u{b3f}ବ\u{b3e} ଗ\u{b4d}ଲୋବ\u{b4d}\u{200c}",
                "ପ\u{b43}ଥ\u{b3f}ବୀ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਮ\u{a48}ਰੀਡੀਅਨ ਨਾਲ ਗਲ\u{a4b}ਬ"),
            keywords: &[
                "ਗਲ\u{a4b}ਬ",
                "ਧਰਤੀ",
                "ਮ\u{a48}ਰੀਡੀਅਨ",
                "ਮ\u{a48}ਰੀਡੀਅਨ ਨਾਲ ਗਲ\u{a4b}ਬ",
                "ਸ\u{a70}ਸਾਰ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("طول البدل نال گلوب"),
            keywords: &[
                "ارض نما کرہ",
                "دنیا",
                "زمین",
                "طول البدل نال گلوب",
                "نصف النہار",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Raúnd Wọ\u{301}ld Map Wit Mẹrídían Lain-dẹm"),
            keywords: &[
                "Glob",
                "Mẹrídían Lain-dẹm",
                "Raúnd Wọ\u{301}ld Map Mẹrídían Lain-dẹm",
                "Raúnd Wọ\u{301}ld Map Wit Mẹrídían Lain-dẹm",
                "Wọld",
                "Ẹt",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("kula ziemska z południkami"),
            keywords: &[
                "glob",
                "globus",
                "kula ziemska z południkami",
                "południki",
                "równoleżniki",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("نړۍ د نصف لنهارليکې سره"),
            keywords: &[
                "د نصف لنهار ليکه",
                "نصف لنهار",
                "نړۍ",
                "نړۍ د نصف لنهارليکې سره",
                "ځمکه",
                "کره",
            ],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("globo com meridianos"),
            keywords: &["globo com meridianos", "meridianos"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &[
                "Terra",
                "globo",
                "globo com meridianos",
                "meridianos",
                "mundo",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("saywasiqʼi meridianoswan"),
            keywords: &[
                "kawsay pacha",
                "meridianos",
                "pacha",
                "saywasiqʼi meridianoswan",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("glob cu meridiane"),
            keywords: &["Pământ", "glob", "glob cu meridiane", "lume", "meridiane"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-215"),
            keywords: &["E10-215"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("меридианы"),
            keywords: &[
                "Земля",
                "глобус",
                "земной шар",
                "меридиан",
                "меридианы",
                "шар",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umubumbe w’isi werekana imirongo miganda"),
            keywords: &[
                "isi",
                "meridians",
                "umubumbe w’isi",
                "umubumbe w’isi werekana imirongo miganda",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ميريڊيئن سان گلوب"),
            keywords: &["زمين، گلوب، ميريڊيئن، دنيا", "ميريڊيئن سان گلوب"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ධ\u{dca}\u{200d}රැවක රේඛ\u{dcf} සහ\u{dd2}ත ලෝක ගෝලය"),
            keywords: &[
                "ධ\u{dca}\u{200d}රැවක රේඛ\u{dcf} සහ\u{dd2}ත ලෝක ගෝලය",
                "ධ\u{dca}\u{200d}රැවක රේඛ\u{dcf}ව",
                "පෘථ\u{dd2}ව\u{dd2}ය",
                "ලෝක ගෝලය",
                "ලෝකය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("zemeguľa s poludníkmi"),
            keywords: &[
                "glóbus",
                "poludníky",
                "svet",
                "zem",
                "zemeguľa s poludníkmi",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("globus s poldnevniki"),
            keywords: &[
                "globus",
                "globus s poldnevniki",
                "poldnevniki",
                "svet",
                "zemlja",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("adduunka oo leh dhigo"),
            keywords: &[
                "adduunka",
                "adduunka oo leh dhigo",
                "dhigo",
                "dhulka",
                "dunida",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("globi me meridianë"),
            keywords: &["Bota", "Globi", "Toka", "globi me meridianë", "meridianë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("глобус са меридијанима"),
            keywords: &[
                "глoбус",
                "глобус са меридијанима",
                "зeмљa",
                "мeридиjaни",
                "свeт",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["глобус са меридијанима"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("globus sa meridijanima"),
            keywords: &[
                "globus",
                "globus sa meridijanima",
                "meridijani",
                "svet",
                "zemlja",
            ],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["globus sa meridijanima"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("jordglob med meridianer"),
            keywords: &["jordglob med meridianer", "meridianer"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("tufe lenye meridiani"),
            keywords: &[
                "dunia",
                "meridiani",
                "tufe",
                "tufe lenye meridiani",
                "ulimwengu",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("த\u{bc0}ர\u{bcd}க\u{bcd}கரேகைகளுடன\u{bcd} உலக உருண\u{bcd}டை"),
            keywords: &[
                "அட\u{bcd}சரேகை",
                "உலக உருண\u{bcd}டை",
                "த\u{bc0}ர\u{bcd}க\u{bcd}கரேகை",
                "த\u{bc0}ர\u{bcd}க\u{bcd}கரேகைகளுடன\u{bcd} உலக உருண\u{bcd}டை",
                "பூமி",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("మధ\u{c4d}య\u{c3e}హ\u{c4d}న ర\u{c47}ఖలత\u{c4b} గ\u{c4d}ల\u{c4b}బ\u{c4d}"),
            keywords: &[
                "ధృవర\u{c47}ఖలు",
                "భూగ\u{c4b}ళం",
                "మధ\u{c4d}య\u{c3e}హ\u{c4d}న ర\u{c47}ఖలత\u{c4b} గ\u{c4d}ల\u{c4b}బ\u{c4d}",
                "మధ\u{c4d}య\u{c3e}హ\u{c4d}న\u{c3e} ర\u{c47}ఖలు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("глобус бо меридианаҳо"),
            keywords: &[
                "глобус",
                "глобус бо меридианаҳо",
                "замин",
                "меридианҳо",
                "ҷаҳон",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ล\u{e39}กโลกแสดงเส\u{e49}นเมร\u{e34}เด\u{e35}ยน"),
            keywords: &[
                "ล\u{e39}กโลก",
                "ล\u{e39}กโลกแสดงเส\u{e49}นเมร\u{e34}เด\u{e35}ยน",
                "เส\u{e49}นเมร\u{e34}เด\u{e35}ยน",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("meridianly globus"),
            keywords: &[
                "dünýä",
                "meridianlar",
                "meridianly globus",
                "ýer",
                "ýer togalagy",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("kolope moe ngaahi melitiane"),
            keywords: &["kolope moe ngaahi melitiane"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("meridyenli yerküre"),
            keywords: &[
                "boylamlar",
                "dünya",
                "meridyen",
                "meridyenli yerküre",
                "yerküre",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("مېردىيانلىق گىلوبۇس"),
            keywords: &[
                "دۇنيا",
                "مېردىيان",
                "مېردىيانلىق گىلوبۇس",
                "يەرشارى",
                "گىلوبۇس",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("земна куля з меридіанами"),
            keywords: &[
                "глобус",
                "земля",
                "земна куля з меридіанами",
                "меридіани",
                "світ",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("طول البلد کو دکھاتا گلوب"),
            keywords: &[
                "دنیا",
                "زمین",
                "طول البلد",
                "طول البلد کو دکھاتا گلوب",
                "گلوب",
            ],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("meridian chiziqli globus"),
            keywords: &[
                "dunyo",
                "globus",
                "meridian",
                "meridian chiziqli globus",
                "yer",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("địa cầu có đường kinh tuyến"),
            keywords: &[
                "kinh tuyến",
                "quả địa cầu",
                "thế giới",
                "trái đất",
                "địa cầu có đường kinh tuyến",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("glob buy wane merijeŋ yi"),
            keywords: &[
                "glob",
                "glob buy wane merijeŋ yi",
                "merijeŋ",
                "suuf",
                "àdduna",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("iglobhu enemeridian"),
            keywords: &[
                "i-meridians",
                "iglobhu",
                "iglobhu enemeridian",
                "ihlabathi",
                "umhlaba",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Gulobu Pẹlu Mẹridiani"),
            keywords: &[
                "Gulobu Pẹlu Mẹridiani",
                "ayé",
                "gúlóbù",
                "mẹ\u{300}rídíánì",
                "àgbáyé",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("有子午線嘅地球儀"),
            keywords: &["世界", "地球", "地球儀", "子午線", "有子午線嘅地球儀"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("有子午线嘅地球仪"),
            keywords: &["世界", "地球", "地球仪", "子午线", "有子午线嘅地球仪"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("带经纬线的地球"),
            keywords: &["世界", "地球", "子午线", "带经纬线的地球", "经纬"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("子午線"),
            keywords: &["地球", "子午線"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("帶有經緯嘅地球"),
            keywords: &["地球", "帶有經緯嘅地球", "經緯"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("igilobhu elinemeridians"),
            keywords: &[
                "igilobhu",
                "igilobhu elinemeridians",
                "meridians",
                "umhlaba",
            ],
        },
    ],
};
#[doc = "🗺\u{fe0f}"]
pub const WORLD_MAP: crate::Emoji = crate::Emoji {
    glyph: "🗺\u{fe0f}",
    codepoint: "1F5FA FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.7f32,
    name: "world map",
    group: "Travel & Places",
    subgroup: "place-map",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🗺",
        codepoint: "1F5FA",
        status: crate::Status::Unqualified,
        introduction_version: 0.7f32,
        name: "world map",
        group: "Travel & Places",
        subgroup: "place-map",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("wêreldkaart"),
            keywords: &["kaart", "wêreld", "wêreldkaart"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የዓለም ካርታ"),
            keywords: &["ካርታ", "ዓለም", "የዓለም ካርታ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("خريطة العالم"),
            keywords: &["خريطة", "خريطة العالم", "عالم"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("বিশ\u{9cd}ব ম\u{9be}নচিত\u{9cd}ৰ"),
            keywords: &["বিশ\u{9cd}ব", "ম\u{9be}নচিত\u{9cd}ৰ"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("dünya xəritəsi"),
            keywords: &["dünya", "dünya xəritəsi", "xəritə"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("карта свету"),
            keywords: &["карта", "карта свету", "мапа", "свет"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("карта на света"),
            keywords: &["карта", "карта на света", "свят"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("বিশ\u{9cd}বের ম\u{9be}নচিত\u{9cd}র"),
            keywords: &[
                "বিশ\u{9cd}ব",
                "বিশ\u{9cd}বের ম\u{9be}নচিত\u{9cd}র",
                "ম\u{9be}নচিত\u{9cd}র",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("kartenn ar bed"),
            keywords: &["bed", "kartenn", "kartenn ar bed"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("karta svijeta"),
            keywords: &["karta", "karta svijeta", "mapa", "svijet"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("mapa del món"),
            keywords: &["mapa", "mapa del món", "món"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄛\u{11128}𑄖\u{11134}\u{11128}𑄟\u{11128} 𑄟\u{11133}𑄠𑄛\u{11134}"),
            keywords: &["𑄛\u{11128}𑄖\u{11134}\u{11128}𑄟\u{11128} 𑄟\u{11133}𑄠𑄛\u{11134}"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎧᎵ ᎡᎶᎯ ᎡᎶᎯ ᏓᏟᎶᏍᏛᎢ"),
            keywords: &["ᎡᎶᎯ ᏓᏟᎶᏍᏛᎢ", "ᎧᎵ ᎡᎶᎯ", "ᎧᎵ ᎡᎶᎯ ᎡᎶᎯ ᏓᏟᎶᏍᏛᎢ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("mapa světa"),
            keywords: &["mapa", "mapa světa", "svět"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("map o’r byd"),
            keywords: &["byd", "map", "map o’r byd"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("verdenskort"),
            keywords: &["kort", "verden", "verdenskort"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Weltkarte"),
            keywords: &["Karte", "Welt", "Weltkarte"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("παγκόσμιος χάρτης"),
            keywords: &["κόσμος", "παγκόσμιος χάρτης", "χάρτης"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("world map"),
            keywords: &["map", "world"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("mapa mundial"),
            keywords: &["mapa", "mapa mundial", "mapamundi", "mundo"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("mapamundi"),
            keywords: &["mapa", "mapamundi", "mundo"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("maailmakaart"),
            keywords: &["kaart", "maailm", "maailmakaart"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("munduko mapa"),
            keywords: &["mapa", "mundu", "munduko mapa"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("نقشه\u{654} جهان"),
            keywords: &["دنیا", "نقشه", "نقشه\u{654} جهان"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("maailmankartta"),
            keywords: &["kartta", "maailma", "maailmankartta"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("mapa ng mundo"),
            keywords: &["mapa", "mapa ng mundo", "mundo"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("verðinskort"),
            keywords: &["heimurin", "jørðin", "kort", "verðin", "verðinskort"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("carte du monde"),
            keywords: &["carte", "carte du monde"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["carte", "carte du monde", "monde"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("léarscáil an domhain"),
            keywords: &["domhan", "léarscáil", "léarscáil an domhain"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("mapa an t-saoghail"),
            keywords: &["mapa", "mapa an t-saoghail", "saoghal"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("mapa do mundo"),
            keywords: &["mapa", "mapa do mundo", "mapamundi", "mundo"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("વિશ\u{acd}વનો નકશો"),
            keywords: &["નકશો", "વિશ\u{acd}વ", "વિશ\u{acd}વનો નકશો"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("taswirar duniya"),
            keywords: &["duniya", "taswira", "taswirar duniya"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("מפת העולם"),
            keywords: &["מפה", "מפת העולם", "עולם"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("विश\u{94d}व मानचित\u{94d}र, विश\u{94d}व"),
            keywords: &[
                "विश\u{94d}व",
                "विश\u{94d}व मानचित\u{94d}र",
                "विश\u{94d}व मानचित\u{94d}र, विश\u{94d}व",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("karta svijeta"),
            keywords: &["karta", "karta svijeta", "svijet"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("világtérkép"),
            keywords: &["föld", "térkép", "világ", "világtérkép"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("աշխարհի քարտեզ"),
            keywords: &["աշխարհ", "աշխարհի քարտեզ", "քարտեզ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("peta dunia"),
            keywords: &["dunia", "peta"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("maapụ ụwa"),
            keywords: &["maapụ", "ụwa"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("heimskort"),
            keywords: &["heimskort", "heimur", "kort"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("mappa mondiale"),
            keywords: &["cartina", "mappa", "mappa mondiale", "mondo"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("世界地図"),
            keywords: &["世界", "世界地図", "地図"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("peta donya"),
            keywords: &["donya", "peta"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მსოფლიო რუკა"),
            keywords: &["მსოფლიო", "რუკა"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("takarḍa n umaḍal"),
            keywords: &["takarḍa n umaḍal"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("карта"),
            keywords: &["карта", "әлем"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("verdenskort"),
            keywords: &["kort", "verden", "verdenskort"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ផែនទ\u{17b8}ព\u{17b7}ភពលោក"),
            keywords: &[
                "ផែនទ\u{17b8}",
                "ផែនទ\u{17b8}ព\u{17b7}ភពលោក",
                "ព\u{17b7}ភពលោក",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಪ\u{ccd}ರಪಂಚ ನಕ\u{ccd}ಷ\u{cc6}"),
            keywords: &["ನಕ\u{ccd}ಷ\u{cc6}", "ಪ\u{ccd}ರಪಂಚ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("세계 지도"),
            keywords: &["세계", "지도"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("जगातलो नकसो"),
            keywords: &["जग", "जगातलो नकसो", "नकसो"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("дүйнө картасы"),
            keywords: &["дүйнө", "дүйнө картасы", "карта"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Weltkaart"),
            keywords: &["Kaart", "Welt", "Weltkaart"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ແຜນທ\u{eb5}\u{ec8}ໂລກ"),
            keywords: &["ແຜນທ\u{eb5}\u{ec8}", "ແຜນທ\u{eb5}\u{ec8}ໂລກ", "ໂລກ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("pasaulio žemėlapis"),
            keywords: &["pasaulio žemėlapis", "pasaulis", "žemėlapis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("pasaules karte"),
            keywords: &["karte", "pasaule", "pasaules karte"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("mahere ao"),
            keywords: &["ao", "mahere"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("карта на светот"),
            keywords: &["карта", "карта на светот", "свет"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ലോക മ\u{d3e}പ\u{d4d}പ\u{d4d}"),
            keywords: &[
                "മ\u{d3e}പ\u{d4d}പ\u{d4d}",
                "ലോക മ\u{d3e}പ\u{d4d}പ\u{d4d}",
                "ലോകം",
                "വേൾഡ\u{d4d} മ\u{d3e}പ\u{d4d}പ\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("дэлхийн газрын зураг"),
            keywords: &["газрын зураг", "дэлхий", "дэлхийн газрын зураг"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("जगाचा नकाशा"),
            keywords: &["जग", "जगाचा नकाशा", "नकाशा"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("peta dunia"),
            keywords: &["dunia", "peta"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("mappa tad-dinjija"),
            keywords: &["dinja", "mappa", "mappa tad-dinjija"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ကမ\u{1039}ဘာ\u{1037}မြေပ\u{102f}\u{1036}"),
            keywords: &[
                "ကမ\u{1039}ဘာ",
                "ကမ\u{1039}ဘာ\u{1037}မြေပ\u{102f}\u{1036}",
                "မြေပ\u{102f}\u{1036}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("verdenskart"),
            keywords: &["kart", "verden", "verdenskart"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("विश\u{94d}वको नक\u{94d}सा"),
            keywords: &["नक\u{94d}सा", "विश\u{94d}व", "विश\u{94d}वको नक\u{94d}सा"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("wereldkaart"),
            keywords: &["kaart", "wereld", "wereldkaart"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("verdskart"),
            keywords: &["kart", "verda", "verdskart"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ବ\u{b3f}ଶ\u{b4d}ୱ ମ\u{b3e}ନଚ\u{b3f}ତ\u{b4d}ର"),
            keywords: &["ବ\u{b3f}ଶ\u{b4d}ୱ", "ମ\u{b3e}ନଚ\u{b3f}ତ\u{b4d}ର"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਸ\u{a70}ਸਾਰ ਦਾ ਨਕਸ\u{a3c}ਾ"),
            keywords: &["ਨਕਸ\u{a3c}ਾ", "ਸ\u{a70}ਸਾਰ", "ਸ\u{a70}ਸਾਰ ਦਾ ਨਕਸ\u{a3c}ਾ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("دنیا دا نقشہ"),
            keywords: &["دنیا", "دنیا دا نقشہ", "نقشہ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Wọ\u{301}ld Map"),
            keywords: &["Map", "Wọld", "Wọ\u{301}ld Map"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("mapa świata"),
            keywords: &["mapa", "mapa świata", "świat"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د نړۍ نقشه"),
            keywords: &["د نړۍ نقشه", "نقشه", "نړۍ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("mapa-múndi"),
            keywords: &["geografia", "mapa", "mapa-múndi", "mundo"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("mapa do mundo"),
            keywords: &["mapa", "mapa do mundo", "mundo"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("pacha saywasiq’i"),
            keywords: &["pacha", "saywasiq’i"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("harta lumii"),
            keywords: &["harta lumii", "hartă", "lume"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-830"),
            keywords: &["E10-830"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("карта мира"),
            keywords: &["карта", "карта мира", "мир"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("Ikarita y’isi"),
            keywords: &["Ikarita y’isi", "ikarita", "isi"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("دنيا جو نقشو"),
            keywords: &["دنيا جو نقشو", "نقشو، دنيا"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ලෝක ස\u{dd2}ත\u{dd2}යම"),
            keywords: &["ලෝක ස\u{dd2}ත\u{dd2}යම", "ලෝකය", "ස\u{dd2}ත\u{dd2}යම"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("mapa sveta"),
            keywords: &["mapa", "mapa sveta", "svet"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("zemljevid sveta"),
            keywords: &["svet", "zemljevid", "zemljevid sveta"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("khariiradadda dunida"),
            keywords: &["dunida", "khariirad", "khariiradadda dunida"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("harta e botës"),
            keywords: &["botë", "harta e botës", "hartë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("мапа света"),
            keywords: &["кaртa", "мапа", "мапа света", "свeт"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("мапа свијета"),
            keywords: &["мапа свијета"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("mapa sveta"),
            keywords: &["karta", "mapa", "mapa sveta", "svet"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("mapa svijeta"),
            keywords: &["mapa svijeta"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("världskarta"),
            keywords: &["karta", "världen", "världskarta"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("ramani ya dunia"),
            keywords: &["dunia", "ramani", "ramani ya dunia"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("உலக வரைபடம\u{bcd}"),
            keywords: &["உலக வரைபடம\u{bcd}", "உலகம\u{bcd}", "வரைபடம\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ప\u{c4d}రపంచపటం"),
            keywords: &[
                "ప\u{c4d}రపంచం",
                "ప\u{c4d}రపంచపటం",
                "మ\u{c4d}య\u{c3e}ప\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("харитаи ҷаҳон"),
            keywords: &["харита", "харитаи ҷаҳон", "ҷаҳон"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("แผนท\u{e35}\u{e48}โลก"),
            keywords: &["แผนท\u{e35}\u{e48}", "แผนท\u{e35}\u{e48}โลก", "โลก"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("dünýä kartasy"),
            keywords: &["dünýä", "dünýä kartasy", "karta"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("mape ʻo māmani"),
            keywords: &["mape ʻo māmani"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("dünya haritası"),
            keywords: &["dünya", "dünya haritası", "harita"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("دۇنيا خەرىتىسى"),
            keywords: &["خەرىتە", "دۇنيا", "دۇنيا خەرىتىسى"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("карта світу"),
            keywords: &["карта", "карта світу", "світ"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("دنیا کا نقشہ"),
            keywords: &["دنیا", "دنیا کا نقشہ", "نقشہ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("dunyo xaritasi"),
            keywords: &["dunyo", "dunyo xaritasi", "xarita"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("bản đồ thế giới"),
            keywords: &["bản đồ", "bản đồ thế giới", "thế giới"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("kàrtu àdduna"),
            keywords: &["kàrt", "kàrtu àdduna", "àdduna"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("imaphu yehlabathi"),
            keywords: &["ihlabathi", "imaphu", "imaphu yehlabathi"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("máàpù àgbáyé"),
            keywords: &["máàpù", "àgbáyé"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("世界地圖"),
            keywords: &["世界", "世界地圖", "地圖"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("世界地图"),
            keywords: &["世界", "世界地图", "地图"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("世界地图"),
            keywords: &["世界", "世界地图", "地图"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("世界地圖"),
            keywords: &["世界", "世界地圖", "地圖"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("世界"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ibalazwe lomhlaba"),
            keywords: &["ibalazwe", "ibalazwe lomhlaba", "umhlaba"],
        },
    ],
};
#[doc = "🗾"]
pub const MAP_OF_JAPAN: crate::Emoji = crate::Emoji {
    glyph: "🗾",
    codepoint: "1F5FE",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "map of Japan",
    group: "Travel & Places",
    subgroup: "place-map",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("kaart van japan"),
            keywords: &["japan", "kaart", "kaart van japan"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የጃፓን ካርታ"),
            keywords: &["ካርታ", "የጃፓን ካርታ", "ጃፓን"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("خريطة اليابان"),
            keywords: &["اليابان", "خريطة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("জ\u{9be}প\u{9be}নৰ ম\u{9be}নচিত\u{9cd}ৰ"),
            keywords: &[
                "জ\u{9be}প\u{9be}ন",
                "জ\u{9be}প\u{9be}নৰ ম\u{9be}নচিত\u{9cd}ৰ",
                "ম\u{9be}নচিত\u{9cd}ৰ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("yaponiyanın xəritəsi"),
            keywords: &["xəritə", "yaponiya", "yaponiyanın xəritəsi"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("карта японіі"),
            keywords: &["карта", "карта японіі", "мапа", "японія"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("карта на Япония"),
            keywords: &["карта", "карта на Япония", "япония"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("জ\u{9be}প\u{9be}নের ম\u{9cd}য\u{9be}প"),
            keywords: &[
                "জ\u{9be}প\u{9be}ন",
                "জ\u{9be}প\u{9be}নের ম\u{9cd}য\u{9be}প",
                "ম\u{9be}নচিত\u{9cd}র",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("kartenn Japan"),
            keywords: &["Japan", "kartenn"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("karta Japana"),
            keywords: &["Japan", "karta", "karta Japana"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("mapa del Japó"),
            keywords: &["Japó", "mapa", "mapa del Japó"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄎𑄛𑄚\u{11127}𑄢\u{11134} 𑄟\u{11133}𑄠𑄛\u{11134}"),
            keywords: &["𑄎𑄛𑄚\u{11127}𑄢\u{11134} 𑄟\u{11133}𑄠𑄛\u{11134}"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎡᎶᎯ ᏓᏟᎶᏍᏛ ᎾᎿ ᏤᏇᎾ"),
            keywords: &["ᎡᎶᎯ ᏓᏟᎶᏍᏛ", "ᎡᎶᎯ ᏓᏟᎶᏍᏛ ᎾᎿ ᏤᏇᎾ", "ᏤᏇᎾ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("mapa Japonska"),
            keywords: &["japonsko", "mapa", "mapa Japonska"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("map o Japan"),
            keywords: &["Japan", "map", "map o Japan"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("kort over Japan"),
            keywords: &["Japan", "kort", "kort over Japan"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Umriss von Japan"),
            keywords: &["Japan", "Karte", "Umriss von Japan"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("χάρτης της Ιαπωνίας"),
            keywords: &["Ιαπωνία", "χάρτης", "χάρτης της Ιαπωνίας"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("map of Japan"),
            keywords: &["Japan", "map", "map of Japan"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("mapa de Japón"),
            keywords: &["Japón", "mapa", "mapa de Japón", "mapa de japón"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["japón", "mapa", "mapa de Japón", "mapa de japón"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("Jaapani kaart"),
            keywords: &["Jaapan", "Jaapani kaart", "kaart"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("japoniako mapa"),
            keywords: &["japonia", "japoniako mapa", "mapa"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("نقشه\u{654} ژاپن"),
            keywords: &["نقشه", "نقشه\u{654} ژاپن", "ژاپن"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("Japanin kartta"),
            keywords: &["Japani", "Japanin kartta", "kartta"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("mapa ng japan"),
            keywords: &["japan", "mapa", "mapa ng japan"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("kort av Japan"),
            keywords: &["Japan", "kort", "kort av Japan"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("carte du Japon"),
            keywords: &["carte", "carte du Japon", "japon"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["Japon", "carte", "carte du Japon"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("léarscáil na Seapáine"),
            keywords: &["an tSeapáin", "léarscáil", "léarscáil na Seapáine"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("mapa dhen t-Seapan"),
            keywords: &["iapan", "mapa", "mapa dhen t-Seapan", "seapan"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("mapa do Xapón"),
            keywords: &["O Xapón", "mapa", "mapa do Xapón"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("જાપાનનો નકશો"),
            keywords: &["જાપાન", "જાપાનનો નકશો", "નકશો"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("taswirar Japan"),
            keywords: &["Japan", "taswira", "taswirar Japan"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("מפת יפן"),
            keywords: &["יפן", "מפה", "מפת יפן"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("जापान का नक\u{93c}\u{94d}शा"),
            keywords: &["जापान", "जापान का नक\u{93c}\u{94d}शा", "नक\u{93c}\u{94d}शा"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("karta Japana"),
            keywords: &["japan", "karta", "karta Japana"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("Japán térképe"),
            keywords: &["Japán", "Japán térképe", "földrajz", "térkép"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("Ճապոնիայի քարտեզը"),
            keywords: &["Ճապոնիա", "Ճապոնիայի քարտեզը", "քարտեզ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("peta Jepang"),
            keywords: &["jepang", "peta", "peta Jepang"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("mappụ nke Japan"),
            keywords: &["Japan", "maapụ\u{300}", "mappụ nke Japan"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("kort af Japan"),
            keywords: &["Japan", "kort", "kort af Japan"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("mappa del Giappone"),
            keywords: &["Giappone", "mappa", "mappa del Giappone"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("日本地図"),
            keywords: &["地図", "日本", "日本地図"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("peta Jepang"),
            keywords: &["Jepang", "peta"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("იაპონიის რუკა"),
            keywords: &["იაპონია", "იაპონიის რუკა", "რუკა"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("takarḍa n Japun"),
            keywords: &["takarḍa n Japun"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("Жапония картасы"),
            keywords: &["Жапония картасы", "жапон", "карта"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("Japan"),
            keywords: &["Japan", "kort over Japan"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ផែនទ\u{17b8}ប\u{17d2}រទេសជប\u{17c9}\u{17bb}ន"),
            keywords: &[
                "ជប\u{17c9}\u{17bb}ន",
                "ផែនទ\u{17b8}",
                "ផែនទ\u{17b8}ប\u{17d2}រទេសជប\u{17c9}\u{17bb}ន",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಜಪಾನ\u{ccd} ನಕ\u{ccd}ಷ\u{cc6}"),
            keywords: &["ಜಪಾನ\u{ccd} ನಕ\u{ccd}ಷ\u{cc6}", "ನಕ\u{ccd}ಷ\u{cc6}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("일본 지도"),
            keywords: &["일본", "지도"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("जपानचो नकसो"),
            keywords: &["जपान", "जपानचो नकसो", "नकसो"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("жапония картасы"),
            keywords: &["жапония картасы", "жапончоия", "карта"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Kaart vu Japan"),
            keywords: &["Japan", "Kaart", "Kaart vu Japan"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ແຜນທ\u{eb5}\u{ec8}ຍ\u{eb5}\u{ec8}ປ\u{eb8}ນ"),
            keywords: &[
                "ຍ\u{eb5}\u{ec8}ປ\u{eb8}ນ",
                "ແຜນທ\u{eb5}\u{ec8}",
                "ແຜນທ\u{eb5}\u{ec8}ຍ\u{eb5}\u{ec8}ປ\u{eb8}ນ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("Japonijos žemėlapis"),
            keywords: &["Japonijos", "žemėlapis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("Japānas karte"),
            keywords: &["Japāna", "Japānas karte", "karte"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("mahere o Hapani"),
            keywords: &["Hapani", "mahere", "mahere o Hapani"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("карта на Јапонија"),
            keywords: &["Јапонија", "карта", "карта на Јапонија"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ജപ\u{d4d}പ\u{d3e}ന\u{d4d}റെ മ\u{d3e}പ\u{d4d}പ\u{d4d}"),
            keywords: &[
                "ജപ\u{d4d}പ\u{d3e}ന\u{d4d}റെ മ\u{d3e}പ\u{d4d}പ\u{d4d}",
                "ജപ\u{d4d}പ\u{d3e}ൻ",
                "മ\u{d3e}പ\u{d4d}പ\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("Япон улсын газрын зураг"),
            keywords: &["Япон", "Япон улсын газрын зураг", "газрын зураг"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("जपानचा नकाशा"),
            keywords: &["जपान", "जपानचा नकाशा", "नकाशा"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("peta Jepun"),
            keywords: &["jepun", "peta", "peta Jepun"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("mappa tal-Ġappun"),
            keywords: &["mappa", "mappa tal-Ġappun", "Ġappun"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဂျပန\u{103a}န\u{102d}\u{102f}င\u{103a}င\u{1036}မြေပ\u{102f}\u{1036}"),
            keywords: &[
                "ဂျပန\u{103a}",
                "ဂျပန\u{103a}န\u{102d}\u{102f}င\u{103a}င\u{1036}မြေပ\u{102f}\u{1036}",
                "မြေပ\u{102f}\u{1036}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("kart over Japan"),
            keywords: &["Japan", "kart", "kart over Japan"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("जापानको नक\u{94d}सा"),
            keywords: &["जापान", "जापानको नक\u{94d}सा", "नक\u{94d}सा"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("kaart van Japan"),
            keywords: &["Japan", "kaart", "kaart van Japan"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("kart over Japan"),
            keywords: &["Japan", "kart", "kart over Japan"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଜ\u{b3e}ପ\u{b3e}ନର ମ\u{b3e}ନଚ\u{b3f}ତ\u{b4d}ର"),
            keywords: &[
                "ଜ\u{b3e}ପ\u{b3e}ନର ମ\u{b3e}ନଚ\u{b3f}ତ\u{b4d}ର",
                "ଜ\u{b3e}ପ\u{b3e}ନ\u{b4d}",
                "ମ\u{b4d}ୟ\u{b3e}ପ\u{b4d}",
                "ମ\u{b4d}ୟ\u{b3e}ପ\u{b4d} ଅଫ\u{b4d} ଜ\u{b3e}ପ\u{b3e}ନ\u{b4d}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਜਾਪਾਨ ਦਾ ਨਕਸ\u{a3c}ਾ"),
            keywords: &["ਜਾਪਾਨ", "ਜਾਪਾਨ ਦਾ ਨਕਸ\u{a3c}ਾ", "ਨਕਸ\u{a3c}ਾ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("جاپان دا نقشہ"),
            keywords: &["جاپان", "جاپان دا نقشہ", "نقشہ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Japán Map"),
            keywords: &["Japan", "Japán Map", "Map"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("mapa Japonii"),
            keywords: &["japonia", "mapa", "mapa Japonii"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د جاپان نقشه"),
            keywords: &["جاپان", "د جاپان نقشه", "نقشه"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("mapa do Japão"),
            keywords: &["Japão", "mapa", "mapa do Japão"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("mapa do Japão"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("Japñon Saywasiqʼi"),
            keywords: &["Japñon Saywasiqʼi", "Japón", "saywasiq’i"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("harta Japoniei"),
            keywords: &["Japonia", "harta Japoniei", "hartă"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-834"),
            keywords: &["E10-834"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("карта Японии"),
            keywords: &["Япония", "карта", "карта Японии"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ikarita y’ubuyapani"),
            keywords: &["Ubuyapani", "ikarita", "ikarita y’ubuyapani"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("جاپاني نقشو"),
            keywords: &["جاپان، نقشو", "جاپاني نقشو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ජප\u{dcf}නයේ ස\u{dd2}ත\u{dd2}යම"),
            keywords: &[
                "ජප\u{dcf}නය",
                "ජප\u{dcf}නයේ ස\u{dd2}ත\u{dd2}යම",
                "ස\u{dd2}ත\u{dd2}යම",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("mapa Japonska"),
            keywords: &["japonsko", "mapa", "mapa Japonska"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("zemljevid Japonske"),
            keywords: &["Japonska", "zemljevid", "zemljevid Japonske"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("khariidadda Jabbaan"),
            keywords: &["Jabbaan", "khariidad", "khariidadda Jabbaan"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("harta e Japonisë"),
            keywords: &["harta e Japonisë", "hartë", "japoni"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("мапа Јапана"),
            keywords: &["Jaпaн", "мапа", "мапа Јапана"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["мапа Јапана"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("mapa Japana"),
            keywords: &["Japan", "mapa", "mapa Japana"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["mapa Japana"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("karta över Japan"),
            keywords: &["Japan", "karta", "karta över Japan"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("ramani ya japani"),
            keywords: &["japani", "ramani", "ramani ya japani"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ஜப\u{bcd}ப\u{bbe}ன\u{bcd} வரைபடம\u{bcd}"),
            keywords: &["ஜப\u{bcd}ப\u{bbe}ன\u{bcd}", "மேப\u{bcd}", "வரைபடம\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("జప\u{c3e}న\u{c4d} మ\u{c4d}య\u{c3e}ప\u{c4d}"),
            keywords: &[
                "జప\u{c3e}న\u{c4d}",
                "జప\u{c3e}న\u{c4d} మ\u{c4d}య\u{c3e}ప\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("харитаи Ҷопон"),
            keywords: &["харита", "харитаи Ҷопон", "Ҷопон"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("แผนท\u{e35}\u{e48}ญ\u{e35}\u{e48}ป\u{e38}\u{e48}น"),
            keywords: &[
                "ญ\u{e35}\u{e48}ป\u{e38}\u{e48}น",
                "แผนท\u{e35}\u{e48}ญ\u{e35}\u{e48}ป\u{e38}\u{e48}น",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("Ýaponiýa kartasy"),
            keywords: &["karta", "Ýaponiýa", "Ýaponiýa kartasy"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("mape ʻoe Siapani"),
            keywords: &["mape ʻoe Siapani"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("Japonya haritası"),
            keywords: &["Japonya", "Japonya haritası", "harita"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ياپونىيە خەرىتىسى"),
            keywords: &["خەرىتە", "ياپونىيە", "ياپونىيە خەرىتىسى"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("карта Японії"),
            keywords: &["карта", "карта Японії", "японія"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("جاپان کا نقشہ"),
            keywords: &["جاپان", "جاپان کا نقشہ", "نقشہ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("yaponiya xaritasi"),
            keywords: &["xarita", "yapon", "yaponiya xaritasi"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("bản đồ Nhật Bản"),
            keywords: &["bản đồ", "bản đồ Nhật Bản", "nhật bản"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("kàrtu sapoŋ"),
            keywords: &["Sapoŋ", "kàrt", "kàrtu sapoŋ"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("imaphu yaseJapan"),
            keywords: &["I-Japan", "imaphu", "imaphu yaseJapan"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Maapu Ti Japanu"),
            keywords: &["Maapu Ti Japanu", "jàpánù", "máàpù"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("日本地圖"),
            keywords: &["地圖", "日本", "日本地圖"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("日本地图"),
            keywords: &["地图", "日本", "日本地图"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("日本地图"),
            keywords: &["地图", "日本", "日本地图"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("日本"),
            keywords: &["日本", "日本列島"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["日本", "日本地圖", "日本鳥瞰圖"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ibalazwe lejapan"),
            keywords: &["ibalazwe", "ibalazwe lejapan", "japan"],
        },
    ],
};
#[doc = "🧭"]
pub const COMPASS: crate::Emoji = crate::Emoji {
    glyph: "🧭",
    codepoint: "1F9ED",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "compass",
    group: "Travel & Places",
    subgroup: "place-map",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("kompas"),
            keywords: &["kompas", "magneties", "navigasie", "oriëntering"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ኮምፓስ"),
            keywords: &["ማሰስ", "ማቅጠጥ", "ማግኔቲክ", "ኮምፓስ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("بوصلة"),
            keywords: &["استرشاد بالبوصلة", "بوصلة", "تنقل", "مغناطيسي"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("কম\u{9cd}প\u{9be}ছ"),
            keywords: &[
                "অ’ৰিয\u{9bc}েণ\u{9cd}ট\u{9be}ৰিং",
                "কম\u{9cd}প\u{9be}ছ",
                "চ\u{9c1}ম\u{9cd}বকীয\u{9bc}",
                "নেভিগেশ\u{9cd}বন",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("kompas"),
            keywords: &["kompas", "maqnit", "naviqasiya", "orientasiya"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("компас"),
            keywords: &["арыентаванне", "компас", "магнетызм", "навігацыя"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("компас"),
            keywords: &["компас", "магнит", "навигация", "ориентиране", "север"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("কম\u{9cd}প\u{9be}স"),
            keywords: &[
                "ওরিয\u{9bc}েন\u{9cd}টিয\u{9bc}\u{9be}রিং",
                "কম\u{9cd}প\u{9be}স",
                "চ\u{9c1}ম\u{9cd}বকীয\u{9bc}",
                "ন\u{9cd}য\u{9be}ভিগেশন",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("nadoz-vor"),
            keywords: &["magnetek", "merdeiñ", "nadoz-vor"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("kompas"),
            keywords: &["kompas", "navigacija", "orijentacija"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("brúixola"),
            keywords: &["brúixola", "magnètic", "navegació", "orientació"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᎳᏂ ᎠᎦᏙᏗ"),
            keywords: &[
                "ᎠᎳᏂ ᎠᎦᏙᏗ",
                "ᎠᎾᏓᎪᎾᏗᏍᎬ ᎡᎶᎯ ᎠᏟᎶᎥᎢ ᎬᏔᏅᎢ",
                "ᎠᏓᏘᏂᏙᎯ",
                "ᏔᎷᎩᏍᎩ ᎦᏌᏁᏍᎩ",
            ],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("kompas"),
            keywords: &["kompas", "magnetický", "navigace", "orientace"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("cwmpawd"),
            keywords: &["cwmpawd", "cyfeiriadu", "llywio", "magnetig"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("kompas"),
            keywords: &["kompas", "magnetisk", "navigation", "verdenshjørne"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Kompass"),
            keywords: &[
                "Himmelsrichtung",
                "Kompass",
                "Navigation",
                "Orientierung",
                "Windrose",
                "magnetisch",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("πυξίδα"),
            keywords: &[
                "αγωνιστικός προσανατολισμός",
                "μαγνητικό",
                "πλοήγηση",
                "πυξίδα",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("compass"),
            keywords: &["compass", "magnetic", "navigation", "orienteering"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("brújula"),
            keywords: &[
                "brújula",
                "compás",
                "magnético",
                "navegación",
                "orientación",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("brújula"),
            keywords: &[
                "brújula",
                "dirección",
                "magnetismo",
                "navegación",
                "orientación",
                "rumbo",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("brújula"),
            keywords: &["brújula"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kompass"),
            keywords: &["kompass", "magnetiline", "navigeerimine", "orienteerumine"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("iparrorratz"),
            keywords: &["iparrorratz", "magnetiko", "nabigazio", "orientazio"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("قطب\u{200c}نما"),
            keywords: &[
                "رهیابی",
                "قطب\u{200c}نما",
                "مسابق\u{654} دوصحرایی به\u{200c}کمک قطب\u{200c}نما",
                "مسیریابی",
                "مغناطیس",
                "مغناطیسی",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kompassi"),
            keywords: &["kompassi", "magneettinen", "navigointi", "suunnistus"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("compass"),
            keywords: &["compass", "direksyon", "magnetic", "nabigasyon"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("kumpass"),
            keywords: &["kumpass", "kós", "tól", "ætt"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("boussole"),
            keywords: &["boussole", "magnétique", "navigation", "orientation"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("compás"),
            keywords: &["compás", "loingseoireacht", "maighnéadach", "treodóireacht"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("combaist"),
            keywords: &[
                "clach-iùil",
                "combaist",
                "iùil",
                "magnaiteach",
                "seòladaireachd",
                "sligheadaireachd",
                "stiùireadh",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("compás"),
            keywords: &["compás", "magnético", "navegación", "orientación"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ક\u{a82}પાસ"),
            keywords: &[
                "ઓરિએન\u{acd}ટરી\u{a82}ગ",
                "ક\u{a82}પાસ",
                "ચ\u{ac1}\u{a82}બકીય",
                "ન\u{ac7}વિગ\u{ac7}શન",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("מצפן"),
            keywords: &["התמצאות", "מגנטי", "מצפן", "ניווט", "צפון"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("दिशास\u{942}चक"),
            keywords: &[
                "ओरिए\u{902}टीयरि\u{902}ग",
                "च\u{941}\u{902}बकीय",
                "दिशास\u{942}चक",
                "न\u{947}विग\u{947}शन",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("kompas"),
            keywords: &["kompas", "magnetski", "navigacija", "orijentacija"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("iránytű"),
            keywords: &["iránytű", "mágneses", "navigáció", "tájékozódás"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("կողմնացույց"),
            keywords: &["կողմնացույց", "կողմնորոշում", "մագնիսային", "նավարկում"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("kompas"),
            keywords: &["kompas", "magnetis", "navigasi", "orientasi"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("áttaviti"),
            keywords: &[
                "kompás",
                "leiðarlýsing",
                "leiðsögn",
                "segulmagn",
                "áttaviti",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("bussola"),
            keywords: &[
                "bussola",
                "bussola magnetica",
                "navigazione",
                "orientamento",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("コンパス"),
            keywords: &["オリエンテーリング", "コンパス", "磁石", "航海", "航空"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("kompas"),
            keywords: &["kompas", "magnetik", "navigasi", "pangarahan"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("კომპასი"),
            keywords: &["კომპასი", "მაგნიტი", "ნავიგაცია", "ორიენტირება"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("tabusult"),
            keywords: &["tabusult"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("компас"),
            keywords: &["бағыт алу", "компас", "магнит", "навигация"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ត\u{17d2}រ\u{17b8}វ\u{17b7}ស\u{17d0}យ"),
            keywords: &[
                "ការរ\u{17bb}ករកផ\u{17d2}ល\u{17bc}វ",
                "ក\u{17b8}ឡារ\u{17bb}ករកផ\u{17d2}ល\u{17bc}វ",
                "ត\u{17d2}រ\u{17b8}វ\u{17b7}ស\u{17d0}យ",
                "ម\u{17c9}ាញេទ\u{17b7}ច",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ದ\u{cbf}ಕ\u{ccd}ಸ\u{cc2}ಚ\u{cbf}"),
            keywords: &[
                "ಓರ\u{cbf}ಯಂಟ\u{cbf}ರ\u{cbf}ಂಗ\u{ccd}",
                "ದ\u{cbf}ಕ\u{ccd}ಸ\u{cc2}ಚ\u{cbf}",
                "ನ\u{ccd}ಯಾವ\u{cbf}ಗೇಶನ\u{ccd}",
                "ಮ\u{ccd}ಯಾಗ\u{ccd}ನ\u{cc6}ಟ\u{cbf}ಕ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("나침반"),
            keywords: &["나침반", "오리엔티어링", "자석"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("कम\u{94d}पास"),
            keywords: &[
                "ओर\u{947}\u{902}टियरी\u{902}ग",
                "कम\u{94d}पास",
                "च\u{941}\u{902}बकीय",
                "प\u{94d}रवास",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("компас"),
            keywords: &["багыт алуу", "компас", "магниттик", "навигация"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເຂ\u{eb1}ມທ\u{eb4}ດ"),
            keywords: &[
                "ການກວດກາ",
                "ຕ\u{ebb}ວວ\u{eb1}ດທ\u{eb4}ດ",
                "ພ\u{ebb}ງກ\u{eb4}ນເຫ\u{ebc}\u{eb1}ດ",
                "ເຂ\u{eb1}ມທ\u{eb4}ດ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("kompasas"),
            keywords: &["kompasas", "magnetinis", "navigacija", "orientacinis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("kompass"),
            keywords: &["kompass", "magnētisks", "navigācija", "orientēšanās"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("компас"),
            keywords: &["компас", "магнетно", "навигација", "ориентирање"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("കോമ\u{d4d}പസ\u{d4d}സ\u{d4d}"),
            keywords: &[
                "ഓറിയന\u{d4d}റീയറിംഗ\u{d4d}",
                "കോമ\u{d4d}പസ\u{d4d}സ\u{d4d}",
                "ന\u{d3e}വിഗേഷൻ",
                "മ\u{d3e}ഗ\u{d4d}\u{200c}നെറ\u{d4d}റിക\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("луужин"),
            keywords: &["луужин", "навигаци", "соронз", "чиглүүлэх"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("होकाय\u{902}त\u{94d}र"),
            keywords: &[
                "ओरिएन\u{94d}टीअरि\u{902}ग",
                "च\u{941}\u{902}बकीय",
                "न\u{947}व\u{94d}हिग\u{947}शन",
                "होकाय\u{902}त\u{94d}र",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("kompas"),
            keywords: &["bermagnet", "kompas", "mengorientasi", "navigasi"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("သ\u{1036}လ\u{102d}\u{102f}က\u{103a}အ\u{102d}မ\u{103a}မြ\u{103e}ောင\u{103a}"),
            keywords: &[
                "မြေပ\u{102f}\u{1036}န\u{103e}င\u{1037}\u{103a}သ\u{1036}လ\u{102d}\u{102f}က\u{103a}အ\u{102d}မ\u{103a}မြ\u{103e}ောင\u{103a}သ\u{102f}\u{1036}း တောလမ\u{103a}းခရ\u{102e}း ခြေကျင\u{103a}လျ\u{103e}ောက\u{103a}ပြ\u{102d}\u{102f}င\u{103a}ပ\u{103d}\u{1032}",
                "လမ\u{103a}းည\u{103d}\u{103e}န\u{103a}",
                "သ\u{1036}လ\u{102d}\u{102f}က\u{103a}သတ\u{1039}တ\u{102d}",
                "သ\u{1036}လ\u{102d}\u{102f}က\u{103a}အ\u{102d}မ\u{103a}မြ\u{103e}ောင\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("kompass"),
            keywords: &["kompass", "magnetisk", "navigasjon", "orientering"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("कम\u{94d}पास"),
            keywords: &[
                "ओरियन\u{94d}टरिङ",
                "कम\u{94d}पास",
                "च\u{941}म\u{94d}बकीय",
                "न\u{947}भिग\u{947}सन",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("kompas"),
            keywords: &["kompas", "magnetisch", "navigatie", "oriëntatielopen"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("kompass"),
            keywords: &["kompass", "magnetisk", "navigasjon", "orientering"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("କମ\u{b4d}ପ\u{b3e}ସ"),
            keywords: &[
                "ଓଇଅଣ\u{b4d}ଟ\u{b3f}ଂ",
                "କମ\u{b4d}ପ\u{b3e}ସ",
                "ଚ\u{b41}ମବ\u{b4d}କୀୟ",
                "ନ\u{b3e}ଭ\u{b3f}ଗେସନ\u{b4d}\u{200c}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਕ\u{a70}ਪਾਸ"),
            keywords: &[
                "ਕ\u{a70}ਪਾਸ",
                "ਚ\u{a41}\u{a70}ਬਕੀ",
                "ਦਿਸ\u{a3c}ਾਮਾਨ",
                "ਨ\u{a47}ਵੀਗ\u{a47}ਸ\u{a3c}ਨ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Kọ\u{301}mpas To Ték Nó Dairẹ\u{301}kshọn"),
            keywords: &[
                "Kọ\u{301}mpas",
                "Kọ\u{301}mpas To Ték Nó Dairẹ\u{301}kshọn",
                "Magnẹ\u{301}tọ",
                "To Faínd Di Dairẹ\u{301}kshọn Wé Yu Go Fọ\u{301}ló Gó Sọm Ples",
                "To Hól Kọ\u{301}mpas An Map To Ték Faínd Rod As Yu De Rọ\u{301}n Fọ Bush",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("kompas"),
            keywords: &["kompas", "magnetyzm", "nawigacja", "orientacja w terenie"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("قطب نما"),
            keywords: &["اورنټيرينګ", "قطب نما", "مقناطيسي", "پلټنه"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("bússola"),
            keywords: &["bússola", "bússola magnética", "navegação", "orientação"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("busolă"),
            keywords: &["busolă", "magnetic", "navigație", "orientare"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E11-055"),
            keywords: &["E11-055"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("компас"),
            keywords: &["компас", "прибор", "путешествие", "стороны света"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڪمپاس"),
            keywords: &["اوريئينٽيئرنگ", "ميگنيٽڪ", "نيويگيشن", "ڪمپاس"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ම\u{dcf}ල\u{dd2}ම\u{dcf}ව"),
            keywords: &[
                "ච\u{dd4}ම\u{dca}බක",
                "ම\u{dcf}ල\u{dd2}ම\u{dcf}ව",
                "ය\u{dcf}ත\u{dca}\u{200d}රණය",
                "ස\u{dd2}ත\u{dd2}යම\u{dca} බල\u{dcf} ගමන\u{dca} ක\u{dd2}ර\u{dd3}ම",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("kompas"),
            keywords: &["buzola", "kompas", "magnet", "navigácia", "orientácia"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("kompas"),
            keywords: &["kompas", "magnet", "navigacija", "orientacija"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("jiheeye"),
            keywords: &["birlabeed", "haggaajinta", "jiheeye", "maaxid"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("busull"),
            keywords: &["busull", "fushë magnetike", "orientim"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("компас"),
            keywords: &["компас", "магнетни", "навигација", "оријентација"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("kompas"),
            keywords: &["kompas", "magnetni", "navigacija", "orijentacija"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("kompass"),
            keywords: &["kompass", "magnetisk", "navigation", "orientering"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("dira"),
            keywords: &["dira", "maelekezo", "smaku", "usafiri"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("க\u{bbe}ம\u{bcd}பஸ\u{bcd}"),
            keywords: &[
                "ஓரியன\u{bcd}ட\u{bcd}",
                "க\u{bbe}ம\u{bcd}பஸ\u{bcd}",
                "நேவிகேஷன\u{bcd}",
                "மேக\u{bcd}னட\u{bcd}டிக\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ద\u{c3f}క\u{c4d}సూచ\u{c3f}"),
            keywords: &[
                "అయస\u{c4d}క\u{c3e}ంతం",
                "ఓర\u{c3f}య\u{c46}ంట\u{c40}ర\u{c3f}ంగ\u{c4d}",
                "ద\u{c3f}క\u{c4d}సూచ\u{c3f}",
                "న\u{c3e}వ\u{c3f}గ\u{c47}షన\u{c4d}",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เข\u{e47}มท\u{e34}ศ"),
            keywords: &[
                "การนำทาง",
                "ข\u{e31}\u{e49}วแม\u{e48}เหล\u{e47}ก",
                "เข\u{e47}มท\u{e34}ศ",
                "โอเรนเท\u{e35}ยร\u{e34}\u{e48}ง",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("kompas"),
            keywords: &["kompas", "magnit", "nawigasiýa", "ugur tapma"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("kāpasa"),
            keywords: &["kāpasa"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("pusula"),
            keywords: &["manyetik", "navigasyon", "orienteering", "pusula"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("компас"),
            keywords: &[
                "компас",
                "магнетизм",
                "магніт",
                "навігація",
                "орієнтування",
                "сторони світу",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ق\u{64f}طب ن\u{64f}ما"),
            keywords: &[
                "ق\u{64f}طب ن\u{64f}ما",
                "مقناطیسی",
                "نقشے کی مدد سے راستہ تلاش کرنا",
                "نیویگیشن",
            ],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("kompas"),
            keywords: &["asbob", "dunyo tomonlari", "kompas", "magnitli", "sayohat"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("la bàn"),
            keywords: &["la bàn", "từ tính", "điều hướng", "định hướng"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("指南針"),
            keywords: &["導航", "指南針", "方位", "磁力"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("指南针"),
            keywords: &["导航", "指南针", "方位", "磁力"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("指南针"),
            keywords: &["定向", "导航", "指南针", "磁性"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("指南針"),
            keywords: &["定向", "導航", "指南針", "磁鐵"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("i-compass"),
            keywords: &["i-compass", "magnetic", "navigation", "orienteering"],
        },
    ],
};
