#[doc = "🏔\u{fe0f}"]
pub const SNOW_CAPPED_MOUNTAIN: crate::Emoji = crate::Emoji {
    glyph: "🏔\u{fe0f}",
    codepoint: "1F3D4 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.7f32,
    name: "snow-capped mountain",
    group: "Travel & Places",
    subgroup: "place-geographic",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🏔",
        codepoint: "1F3D4",
        status: crate::Status::Unqualified,
        introduction_version: 0.7f32,
        name: "snow-capped mountain",
        group: "Travel & Places",
        subgroup: "place-geographic",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("berg met sneeu op"),
            keywords: &["berg", "berg met sneeu op", "koud", "sneeu"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ጫፉ በረዶ ያለበት ተራራ"),
            keywords: &["ቀዝቃዛ", "በረዶ", "ተራራ", "ጫፉ በረዶ ያለበት ተራራ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("جبل بقمة ثلجية"),
            keywords: &["برد", "جبل", "جبل بقمة ثلجية", "جليد"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("বৰফ\u{9be}ব\u{9c3}ত পৰ\u{9cd}ব\u{9cd}বত"),
            keywords: &[
                "ঠ\u{9be}ণ\u{9cd}ড\u{9be}",
                "ত\u{9c1}ষ\u{9be}ৰ",
                "পৰ\u{9cd}ব\u{9cd}বত",
                "বৰফ\u{9be}ব\u{9c3}ত পৰ\u{9cd}ব\u{9cd}বত",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("başı qarla örtülmüş dağ"),
            keywords: &["başı qarla örtülmüş dağ", "dağ", "qar", "soyuq"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("заснежаная гара"),
            keywords: &["гара", "заснежаная гара", "снег", "халодны"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("покрита със сняг планина"),
            keywords: &["планина", "покрита със сняг планина", "сняг", "студен"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ত\u{9c1}ষ\u{9be}র\u{9be}ব\u{9c3}ত পর\u{9cd}বত"),
            keywords: &[
                "ঠ\u{9be}ন\u{9cd}ড\u{9be}",
                "ত\u{9c1}ষ\u{9be}র",
                "ত\u{9c1}ষ\u{9be}র\u{9be}ব\u{9c3}ত পর\u{9cd}বত",
                "পর\u{9cd}বত",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("menez ercʼhek"),
            keywords: &["ercʼh", "menez", "menez ercʼhek"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("sniježni planinski vrh"),
            keywords: &["hladan", "planina", "snijeg", "sniježni planinski vrh"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("muntanya amb neu al cim"),
            keywords: &[
                "fred",
                "muntanya",
                "muntanya amb neu al cim",
                "muntanya nevada",
                "neu",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎥᏃᏥ-ᏚᏭᏝᎥᎢ ᎤᏓᎳ"),
            keywords: &["ᎣᏓᎳ", "ᎤᏴᏝ", "ᎥᏃᏥ", "ᎥᏃᏥ-ᏚᏭᏝᎥᎢ ᎤᏓᎳ", "ᎥᏃᏥ-ᏚᏭᏝᎥᎢ ᏚᏅᏓᏢᎢ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("zasněžená hora"),
            keywords: &["hora", "sníh", "zasněžená hora", "zima"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("mynydd wedi’i orchuddio mewn eira"),
            keywords: &["eira", "mynydd", "mynydd wedi’i orchuddio mewn eira", "oer"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("sneklædt bjerg"),
            keywords: &["bjerg", "koldt", "sne", "sneklædt bjerg"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("schneebedeckter Berg"),
            keywords: &["Berg", "Schnee", "kalt", "schneebedeckter Berg"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("χιονισμένο βουνό"),
            keywords: &["βουνό", "κρύο", "χιονισμένο βουνό", "χιόνι"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("snow-capped mountain"),
            keywords: &["cold", "mountain", "snow", "snow-capped mountain"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("montaña con nieve"),
            keywords: &["frío", "montaña", "montaña con nieve", "nieve"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("montañas nevadas"),
            keywords: &["frío", "montaña", "montañas nevadas", "nieve"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("lumine mägi"),
            keywords: &["külm", "lumi", "lumine mägi", "mägi"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("tontorrean elurra duen mendia"),
            keywords: &["elur", "hotz", "mendi", "tontorrean elurra duen mendia"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("قله\u{654} برفی"),
            keywords: &["برف", "سرد", "قله\u{654} برفی", "کوه"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("lumihuippuinen vuori"),
            keywords: &["kylmä", "lumi", "lumihuippuinen vuori", "vuori"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("bundok na may niyebe sa tuktok"),
            keywords: &[
                "bundok",
                "bundok na may niyebe sa tuktok",
                "malamig",
                "niyebe",
                "taglamig",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("fjall við kava á toppinum"),
            keywords: &["fjall", "fjall við kava á toppinum", "kavi"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("montagne enneigée"),
            keywords: &["montagne", "montagne enneigée"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["enneigée", "montagne", "neige"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("sliabh le sneachta"),
            keywords: &["fuar", "sliabh", "sliabh le sneachta", "sneachta"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("beinn le sneachd air a mullach"),
            keywords: &["beinn", "beinn le sneachd air a mullach", "fuar", "sneachd"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("montañas nevadas"),
            keywords: &["frío", "inverno", "montaña", "montañas nevadas", "neve"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("બરફના શિખરવાળો પર\u{acd}વત"),
            keywords: &["પહાડ", "બરફ", "બરફના શિખરવાળો પર\u{acd}વત", "હિમ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("tsauni mai saman ƙanƙara"),
            keywords: &["sanyi", "tsauni", "tsauni mai saman ƙanƙara", "ƙanƙara"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("הר עם פסגה מושלגת"),
            keywords: &["גבוה", "הר", "הר עם פסגה מושלגת", "קר", "שלג"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("बर\u{94d}फील\u{947} शिखर वाला पर\u{94d}वत, बर\u{94d}फ"),
            keywords: &[
                "बर\u{94d}फ",
                "बर\u{94d}फील\u{947} शिखर वाला पर\u{94d}वत",
                "बर\u{94d}फील\u{947} शिखर वाला पर\u{94d}वत, बर\u{94d}फ",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("planina sa snježnim vrhovima"),
            keywords: &[
                "hladno",
                "planina",
                "planina sa snježnim vrhovima",
                "snijeg",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("hegy hótakaróval"),
            keywords: &["hegy", "hegy hótakaróval", "hideg", "hó"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ձյունածածկ գագաթով լեռ"),
            keywords: &["լեռ", "ձյուն", "ձյունածածկ գագաթով լեռ", "սառը"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("gunung dengan puncak bersalju"),
            keywords: &["dingin", "gunung", "gunung dengan puncak bersalju", "salju"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ugwu akụrụ mmiri-kpuchiri"),
            keywords: &["akụrụ mmiri", "oyi", "ugwu", "ugwu akụrụ mmiri-kpuchiri"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("snæviþakinn fjallstindur"),
            keywords: &["fjall", "kalt", "snjór", "snæviþakinn fjallstindur"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("montagna innevata"),
            keywords: &[
                "cima",
                "ghiacciaio",
                "inverno",
                "montagna",
                "montagna innevata",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("雪山"),
            keywords: &["冠雪", "山", "雪", "雪山"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("gunung punthuke katutup salju"),
            keywords: &["adhem", "gunung", "gunung punthuke katutup salju", "salju"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("თოვლით დაფარული მთა"),
            keywords: &["თოვლი", "თოვლით დაფარული მთა", "მთა", "ცივი"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("adrar n udfel"),
            keywords: &["adrar n udfel"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("төбесін қар басқан тау"),
            keywords: &["суық", "тау", "төбесін қар басқан тау", "қар"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("sneklædt bjerg"),
            keywords: &["bjerg", "koldt", "sne", "sneklædt bjerg"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ភ\u{17d2}ន\u{17c6}ក\u{17c6}ព\u{17bc}លទ\u{17b9}កកក"),
            keywords: &[
                "ទ\u{17b9}កកក",
                "ភ\u{17d2}ន\u{17c6}",
                "ភ\u{17d2}ន\u{17c6}ក\u{17c6}ព\u{17bc}លទ\u{17b9}កកក",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಹ\u{cbf}ಮ ಆವೃತ ಪರ\u{ccd}ವತ"),
            keywords: &["ಪರ\u{ccd}ವತ", "ಹ\u{cbf}ಮ", "ಹ\u{cbf}ಮ ಆವೃತ ಪರ\u{ccd}ವತ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("눈 덮인 산"),
            keywords: &["눈", "눈 덮인 산", "산", "설산"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("बर\u{94d}फा-च\u{94d}छादीत पर\u{94d}वत"),
            keywords: &[
                "थ\u{902}ड",
                "पर\u{94d}वत",
                "बर\u{94d}फ",
                "बर\u{94d}फा-च\u{94d}छादीत पर\u{94d}वत",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("ак мөңгүлүү тоо"),
            keywords: &["ак мөңгүлүү тоо", "кар", "суук", "тоо"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("mat Schnéi bedeckte Bierg"),
            keywords: &["Bierg", "Schnéi", "kal", "mat Schnéi bedeckte Bierg"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ພ\u{eb9}ເຂ\u{ebb}າທ\u{eb5}\u{ec8}ປ\u{ebb}ກຄ\u{eb8}ມດ\u{ec9}ວຍຫ\u{eb4}ມະ"),
            keywords: &[
                "ພ\u{eb9}ເຂ\u{ebb}າ",
                "ພ\u{eb9}ເຂ\u{ebb}າທ\u{eb5}\u{ec8}ປ\u{ebb}ກຄ\u{eb8}ມດ\u{ec9}ວຍຫ\u{eb4}ມະ",
                "ຫ\u{eb4}ມະ",
                "\u{200b} ໜາວ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("kalnas su snieguota viršūne"),
            keywords: &["kalnas", "kalnas su snieguota viršūne", "sniegas", "šaltis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("sniegoti kalni"),
            keywords: &["auksts", "kalni", "sniegoti kalni", "sniegs"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("maunga tihi-hukarere"),
            keywords: &["hukarere", "makariri", "maunga", "maunga tihi-hukarere"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("планина со снежен врв"),
            keywords: &["планина", "планина со снежен врв", "снег", "студено"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("മഞ\u{d4d}ഞ\u{d41}മ\u{d42}ടിയ മലനിര"),
            keywords: &[
                "തണ\u{d41}പ\u{d4d}പ\u{d4d}",
                "മഞ\u{d4d}ഞ\u{d41}മല",
                "മഞ\u{d4d}ഞ\u{d41}മ\u{d42}ടിയ മലനിര",
                "മഞ\u{d4d}ഞ\u{d4d}",
                "മല",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("цаст уул"),
            keywords: &["уул", "хүйтэн", "цас", "цаст уул"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("हिमाच\u{94d}छादित पर\u{94d}वत"),
            keywords: &[
                "थ\u{902}ड",
                "पर\u{94d}वत",
                "हिम",
                "हिमाच\u{94d}छादित पर\u{94d}वत",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("gunung dengan puncak bersalji"),
            keywords: &["gunung", "gunung dengan puncak bersalji", "salji", "sejuk"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("muntanja miksija bis-silġ"),
            keywords: &["kiesaħ", "muntanja", "muntanja miksija bis-silġ", "silġ"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "ဆ\u{102e}းန\u{103e}င\u{103a}းဖ\u{102f}\u{1036}းနေသည\u{1037}\u{103a} တောင\u{103a}",
            ),
            keywords: &[
                "ဆ\u{102e}းန\u{103e}င\u{103a}း",
                "ဆ\u{102e}းန\u{103e}င\u{103a}းဖ\u{102f}\u{1036}းနေသည\u{1037}\u{103a} တောင\u{103a}",
                "တောင\u{103a}",
                "အေး",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("snødekt fjell"),
            keywords: &["fjell", "kaldt", "snø", "snødekt fjell"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("हिउ\u{901}ल\u{947}-ढाक\u{947}को पर\u{94d}वत"),
            keywords: &[
                "चिसो",
                "पर\u{94d}वत",
                "हिउ\u{901}",
                "हिउ\u{901}ल\u{947}-ढाक\u{947}को पर\u{94d}वत",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("berg met besneeuwde toppen"),
            keywords: &["berg", "berg met besneeuwde toppen", "koud", "sneeuw"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("snødekt fjell"),
            keywords: &["fjell", "kaldt", "snø", "snødekt fjell"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ତ\u{b41}ଷ\u{b3e}ର\u{b3e}ଛନ\u{b4d}ନ ପର\u{b4d}ବତ"),
            keywords: &[
                "ତ\u{b41}ଷ\u{b3e}ର",
                "ତ\u{b41}ଷ\u{b3e}ର\u{b3e}ଛନ\u{b4d}ନ ପର\u{b4d}ବତ",
                "ଥଣ\u{b4d}ଡ\u{b3e}",
                "ପର\u{b4d}ବତ",
                "ବରଫ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਬਰਫੀਲੀ ਚ\u{a4b}ਟੀ ਵਾਲਾ ਪਹਾੜ"),
            keywords: &[
                "ਚ\u{a4b}ਟੀ",
                "ਠ\u{a70}ਡ",
                "ਪਹਾੜ",
                "ਬਰਫ",
                "ਬਰਫੀਲੀ ਚ\u{a4b}ਟੀ ਵਾਲਾ ਪਹਾੜ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("برف نال-ڈھکے پہاڑ"),
            keywords: &["برف باری", "برف نال-ڈھکے پہاڑ", "ٹھنڈا", "پہاڑ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Maúntin Wé Sno Kọ\u{301}vá Di Tọp"),
            keywords: &[
                "Kold",
                "Maúntin",
                "Maúntin Wé Sno Kọ\u{301}vá Di Tọp",
                "Sno",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("góra z czapą lodową"),
            keywords: &["góra", "góra z czapą lodową", "zima", "śnieg"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د واورې ډک غر"),
            keywords: &["د واورې ډک غر", "غر", "واوره", "يخ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("montanha com neve"),
            keywords: &["frio", "montanha", "montanha com neve", "neve"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("montanha coberta de neve"),
            keywords: &["frio", "montanha", "montanha coberta de neve", "neve"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("rit’i urqupi"),
            keywords: &["chiri", "rit’i", "rit’i urqupi", "urqu"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("vârf de munte înzăpezit"),
            keywords: &["frig", "munte", "vârf", "vârf de munte înzăpezit", "zăpadă"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-404"),
            keywords: &["E10-404"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("гора со снежной шапкой"),
            keywords: &["вершина", "гора", "гора со снежной шапкой", "снег"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umusozi utwikiriwe n’urubura"),
            keywords: &[
                "gikonje",
                "umusozi",
                "umusozi utwikiriwe n’urubura",
                "urubura",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("برف سان ڍڪيل جبل"),
            keywords: &["برف سان ڍڪيل جبل", "ٿڌ، جبل، برف"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("හ\u{dd2}ම සහ\u{dd2}ත කඳ\u{dd4} ම\u{dd4}ද\u{dd4}න"),
            keywords: &[
                "කන\u{dca}ද",
                "ස\u{dd3}ත",
                "හ\u{dd2}ම",
                "හ\u{dd2}ම සහ\u{dd2}ත කඳ\u{dd4} ම\u{dd4}ද\u{dd4}න",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("zasnežený vrch"),
            keywords: &["chlad", "hora", "sneh", "vrch", "zasnežený vrch"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("zasnežena gora"),
            keywords: &["gora", "hladno", "sneg", "zasnežena gora"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("buur baraf ah"),
            keywords: &["baraf", "buur", "buur baraf ah", "qabow"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("mal i mbuluar me borë në majë"),
            keywords: &["borë", "ftohtë", "mal", "mal i mbuluar me borë në majë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("снежни врх планине"),
            keywords: &["плaнинa", "снeг", "снежни врх планине", "хлaднo"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("сњежни врх планине"),
            keywords: &["сњежни врх планине"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("snežni vrh planine"),
            keywords: &["hladno", "planina", "sneg", "snežni vrh planine"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("snježni vrh planine"),
            keywords: &["snježni vrh planine"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("snöklätt berg"),
            keywords: &["berg", "kallt", "snö", "snöklätt berg"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mlima wenye theluji"),
            keywords: &["baridi", "mlima", "mlima wenye theluji", "theluji"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பனி சூழ\u{bcd}ந\u{bcd}த மலை"),
            keywords: &["குளிர\u{bcd}", "பனி", "பனி சூழ\u{bcd}ந\u{bcd}த மலை", "மலை"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("మంచుత\u{c4b} కప\u{c4d}పబడ\u{c3f}న పర\u{c4d}వతం"),
            keywords: &[
                "చల\u{c3f}",
                "పర\u{c4d}వతం",
                "మంచు",
                "మంచుత\u{c4b} కప\u{c4d}పబడ\u{c3f}న పర\u{c4d}వతం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("куҳи бо барф пӯшида"),
            keywords: &["барф", "куҳ", "куҳи бо барф пӯшида", "хунук"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ภ\u{e39}เขาม\u{e35}ห\u{e34}มะ"),
            keywords: &[
                "ภ\u{e39}เขา",
                "ภ\u{e39}เขาม\u{e35}ห\u{e34}มะ",
                "หนาว",
                "ห\u{e34}มะ",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("üsti garly dag"),
            keywords: &["dag", "gar", "sowuk", "üsti garly dag"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("moʻunga ʻufiʻufiʻaki he sinou"),
            keywords: &["moʻunga ʻufiʻufiʻaki he sinou"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("karla kaplı dağ"),
            keywords: &["dağ", "kar", "karla kaplı dağ", "soğuk"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("قارلىق تاغ"),
            keywords: &["تاغ", "سوغۇق", "قار", "قارلىق تاغ"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("гора із засніженою верхівкою"),
            keywords: &["гора", "гора із засніженою верхівкою", "сніг", "холодний"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("برف سے ڈھکا پہاڑ"),
            keywords: &["برف", "برف سے ڈھکا پہاڑ", "ٹھنڈ", "پہاڑ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("qor qoplagan tog‘"),
            keywords: &["qor", "qor qoplagan tog‘", "sovuq", "tog‘"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("đỉnh núi phủ tuyết"),
            keywords: &["lạnh", "núi", "tuyết", "đỉnh núi phủ tuyết"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("nees bu muur montaañ"),
            keywords: &["montaañ", "nees", "nees bu muur montaañ", "sedd"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("intyaba egcwele ikhephu"),
            keywords: &["ikhephu", "ingqele", "intaba", "intyaba egcwele ikhephu"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("òkè yìnyín"),
            keywords: &["yìnyín", "òkè", "òtútù"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("雪山"),
            keywords: &["寒冷的", "山", "雪", "雪山"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("雪山"),
            keywords: &["寒冷的", "山", "雪", "雪山"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("雪山"),
            keywords: &["冷", "山", "雪", "雪山"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("雪山"),
            keywords: &["雪山", "雪峰"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("intaba embethe iqhwa"),
            keywords: &["intaba", "intaba embethe iqhwa", "iqhwa", "ukubanda"],
        },
    ],
};
#[doc = "⛰\u{fe0f}"]
pub const MOUNTAIN: crate::Emoji = crate::Emoji {
    glyph: "⛰\u{fe0f}",
    codepoint: "26F0 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.7f32,
    name: "mountain",
    group: "Travel & Places",
    subgroup: "place-geographic",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "⛰",
        codepoint: "26F0",
        status: crate::Status::Unqualified,
        introduction_version: 0.7f32,
        name: "mountain",
        group: "Travel & Places",
        subgroup: "place-geographic",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("berg"),
            keywords: &["berg"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ተራራ"),
            keywords: &["ተራራ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("جبل"),
            keywords: &["جبل"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("পৰ\u{9cd}ব\u{9cd}বত"),
            keywords: &["পৰ\u{9cd}ব\u{9cd}বত"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("dağ"),
            keywords: &["dağ"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("гара"),
            keywords: &["гара"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("планина"),
            keywords: &["планина"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("পর\u{9cd}বত"),
            keywords: &["পর\u{9cd}বত", "প\u{9be}হ\u{9be}ড\u{9bc}"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("menez"),
            keywords: &["menez"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("planina"),
            keywords: &["planina"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("muntanya"),
            keywords: &["muntanya"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᏅᏓᏢᎢ"),
            keywords: &["ᎤᏅᏓᏢᎢ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("hora"),
            keywords: &["hora", "kopec", "pohoří"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("mynydd"),
            keywords: &["mynydd"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("bjerg"),
            keywords: &["bjerg"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Berg"),
            keywords: &["Berg", "Gebirge"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("βουνό"),
            keywords: &["βουνό"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("mountain"),
            keywords: &["mountain"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("montaña"),
            keywords: &["montaña", "monte"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("montañas"),
            keywords: &["montaña", "montañas"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("mägi"),
            keywords: &["mägi"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("mendia"),
            keywords: &["mendi", "mendia"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("کوه"),
            keywords: &["کوه", "کوهستان"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("vuori"),
            keywords: &["vuori", "vuoristo"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("bundok"),
            keywords: &["bundok", "tuktok"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("fjall"),
            keywords: &["fjall"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("montagne"),
            keywords: &["montagne"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("sliabh"),
            keywords: &["sliabh"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("beinn"),
            keywords: &["beinn"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("montañas"),
            keywords: &["montaña", "montañas"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("પર\u{acd}વત"),
            keywords: &["પર\u{acd}વત", "પહાડ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("tsauni"),
            keywords: &["tsauni"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("הר"),
            keywords: &["גבוה", "הר"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("पहाड\u{93c}"),
            keywords: &["पर\u{94d}वत", "पहाड\u{93c}"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("planina"),
            keywords: &["planina"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("hegy"),
            keywords: &["hegy", "hegység"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("լեռ"),
            keywords: &["լեռ", "սար"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("gunung"),
            keywords: &["gunung"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ugwu"),
            keywords: &["ugwu"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("fjall"),
            keywords: &["fjall"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("montagna"),
            keywords: &["cima", "montagna"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("山"),
            keywords: &["山", "山岳"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("gunung"),
            keywords: &["gunung"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მთა"),
            keywords: &["მთა"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("adrar"),
            keywords: &["adrar"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("тау"),
            keywords: &["тау"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("bjerg"),
            keywords: &["bjerg"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ភ\u{17d2}ន\u{17c6}\u{200b}"),
            keywords: &["ក\u{17c6}ព\u{17bc}ល", "ភ\u{17d2}ន\u{17c6}\u{200b}"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಪರ\u{ccd}ವತ"),
            keywords: &["ಪರ\u{ccd}ವತ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("산"),
            keywords: &["산", "산 정상"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("पर\u{94d}वत"),
            keywords: &["पर\u{94d}वत"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("тоо"),
            keywords: &["тоо"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Bierg"),
            keywords: &["Bierg"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ພ\u{eb9}"),
            keywords: &["ພ\u{eb9}"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("kalnas"),
            keywords: &["kalnas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("kalns"),
            keywords: &["kalns"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("maunga"),
            keywords: &["maunga"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("планина"),
            keywords: &["планина"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("മലനിര"),
            keywords: &["മല", "മലനിര"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("уул"),
            keywords: &["уул"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("पर\u{94d}वत"),
            keywords: &["पर\u{94d}वत"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("gunung"),
            keywords: &["gunung"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("muntanja"),
            keywords: &["muntanja"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("တောင\u{103a}"),
            keywords: &["တောင\u{103a}"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("fjell"),
            keywords: &["berg", "fjell"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("हिमाल"),
            keywords: &["हिमाल"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("berg"),
            keywords: &["berg"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("fjell"),
            keywords: &["berg", "fjell"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ପର\u{b4d}ବତ"),
            keywords: &["ପର\u{b4d}ବତ"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਪਰਬਤ"),
            keywords: &["ਪਰਬਤ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("پہاڑ"),
            keywords: &["پہاڑ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Maúntin"),
            keywords: &["Hai", "Maúntin"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("góra"),
            keywords: &["góra"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("غر"),
            keywords: &["غر"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("montanha"),
            keywords: &["montanha"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["montanha", "monte"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("urqu"),
            keywords: &["urqu"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("munte"),
            keywords: &["masiv", "munte", "stâncă"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-110"),
            keywords: &["E10-110"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("гора"),
            keywords: &["вершина", "гора", "пик"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umusozi"),
            keywords: &["umusozi"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("جبل"),
            keywords: &["جبل"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("කන\u{dca}ද"),
            keywords: &["කන\u{dca}ද"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("vrch"),
            keywords: &["hora", "vrch", "štít"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("gora"),
            keywords: &["gora"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("buur"),
            keywords: &["buur"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("mal"),
            keywords: &["mal"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("планина"),
            keywords: &["плaнинa", "планина"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["планина"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("planina"),
            keywords: &["planina"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["planina"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("berg"),
            keywords: &["berg"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mlima"),
            keywords: &["mlima"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("மலை"),
            keywords: &["மலை"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("పర\u{c4d}వతం"),
            keywords: &["పర\u{c4d}వతం"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("куҳ"),
            keywords: &["куҳ"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ภ\u{e39}เขา"),
            keywords: &["ภ\u{e39}เขา"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("dag"),
            keywords: &["dag"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("moʻunga"),
            keywords: &["moʻunga"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("dağ"),
            keywords: &["dağ"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("تاغ"),
            keywords: &["تاغ"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("гора"),
            keywords: &["гора"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("پہاڑ"),
            keywords: &["پہاڑ", "چٹان"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("tog‘"),
            keywords: &["tog‘"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("núi"),
            keywords: &["núi"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("montaañ"),
            keywords: &["montaañ"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("intaba"),
            keywords: &["intaba"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("òkè"),
            keywords: &["òkè"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("山"),
            keywords: &["山"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("山"),
            keywords: &["山"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("山"),
            keywords: &["山"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("山"),
            keywords: &["山", "山峰"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("intaba"),
            keywords: &["intaba"],
        },
    ],
};
#[doc = "🌋"]
pub const VOLCANO: crate::Emoji = crate::Emoji {
    glyph: "🌋",
    codepoint: "1F30B",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "volcano",
    group: "Travel & Places",
    subgroup: "place-geographic",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("vulkaan"),
            keywords: &["berg", "uitbarsting", "vulkaan", "weer"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("እሳተ ጎመራ"),
            keywords: &["ተራራ", "እሳተ ጎመራ", "የአየር ንብረት", "ፍንዳታ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("بركان"),
            keywords: &["انفجار", "بركان", "ثوران", "جبل", "طقس"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("আগ\u{9cd}নেয\u{9bc}গিৰি"),
            keywords: &[
                "আগ\u{9cd}নেয\u{9bc}গিৰি",
                "উদ\u{9cd}গীৰণ",
                "পৰ\u{9cd}ব\u{9cd}বত",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("vulkan"),
            keywords: &["dağ", "hava", "püskürmə", "vulkan"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("вулкан"),
            keywords: &["вулкан", "вывяржэнне", "гара", "лава", "надвор’е"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("вулкан"),
            keywords: &["време", "вулкан", "изригване", "планина"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("আগ\u{9cd}নেয\u{9bc}গিরি"),
            keywords: &[
                "অগ\u{9cd}ন\u{9cd}য\u{9c1}ৎপ\u{9be}ত",
                "আগ\u{9cd}নেয\u{9bc}গিরি",
                "আবহ\u{9be}ওয\u{9bc}\u{9be}",
                "পর\u{9cd}বত",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("menez-tan"),
            keywords: &["dislonkadenn", "menez-tan"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("vulkan"),
            keywords: &["erupcija", "planina", "vrijeme", "vulkan"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("volcà"),
            keywords: &["erupció", "muntanya", "volcà"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄃𑄉\u{1112a}𑄚\u{1112e}𑄢\u{11134} 𑄜\u{1112a}𑄘𑄋𑄢\u{11133}𑄦"),
            keywords: &["𑄃𑄉\u{1112a}𑄚\u{1112e}𑄢\u{11134} 𑄜\u{1112a}𑄘𑄋𑄢\u{11133}𑄦"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎦᏙ ᎠᏔᎴᏒ ᎠᏔᏍᎩᏍᎩ"),
            keywords: &["ᎠᏣᎷᏘᏍᎬᎢ", "ᎣᏓᎳ", "ᎦᏙ ᎠᏔᎴᏒ ᎠᏔᏍᎩᏍᎩ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("sopka"),
            keywords: &["erupce", "hora", "sopka", "vulkán", "výbuch"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("llosgfynydd"),
            keywords: &["echdoriad", "llosgfynydd", "mynydd", "tywydd"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("vulkan"),
            keywords: &["vulkan", "vulkanudbrud"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Vulkan"),
            keywords: &["Ausbruch", "Berg", "Vulkan", "Wetter"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ηφαίστειο"),
            keywords: &["έκρηξη", "βουνό", "ηφαίστειο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("volcano"),
            keywords: &["eruption", "mountain", "volcano"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("volcán"),
            keywords: &["erupción", "erupción volcánica", "volcán"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["erupción", "fuego", "volcán"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("vulkaan"),
            keywords: &["laava", "mägi", "purse", "vulkaan"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("sumendia"),
            keywords: &["eguraldi", "erupzio", "mendi", "sumendia"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("آتشفشان"),
            keywords: &["آب\u{200c}وهوا", "آتشفشان", "فوران", "کوه", "کوهستان"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("tulivuori"),
            keywords: &["sää", "tulivuorenpurkaus", "tulivuori", "vuori"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("bulkan"),
            keywords: &["aktibidad ng bulkan", "bulkan", "bundok", "pagsabog"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("gosfjall"),
            keywords: &["eldfjall", "eldgos", "gos", "gosfjall", "útbrot"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("volcan"),
            keywords: &["volcan", "éruption"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["montagne", "volcan", "éruption"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("bolcán"),
            keywords: &["bolcán", "brúchtadh bolcáin"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("beinn-theine"),
            keywords: &["beinn", "beinn-theine", "spreadhadh"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("volcán"),
            keywords: &["erupción", "volcán"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("જ\u{acd}વાળામ\u{ac1}ખી"),
            keywords: &[
                "જ\u{acd}વાળામ\u{ac1}ખી",
                "જ\u{acd}વાળામ\u{ac1}ખી વિસ\u{acd}ફોટ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("dutse mai aman wuta"),
            keywords: &["aman wuta", "dutse mai aman wuta", "tsauni"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("הר געש"),
            keywords: &["הר געש", "התפרצות", "לבה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ज\u{94d}वालाम\u{941}खी"),
            keywords: &[
                "ज\u{94d}वालाम\u{941}खी",
                "ज\u{94d}वालाम\u{941}खी विस\u{94d}फोट",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("vulkan"),
            keywords: &["erupcija", "planina", "vrijeme", "vulkan"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("vulkán"),
            keywords: &["kitörés", "tűzhányó", "vulkán"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("հրաբուխ"),
            keywords: &["եղանակ", "ժայթքում", "լեռ", "հրաբուխ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("gunung berapi"),
            keywords: &["cuaca", "erupsi", "gunung", "gunung berapi"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("mgbawa ugwu"),
            keywords: &["mgbawa", "ugwu"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("eldfjall"),
            keywords: &["eldfjall", "eldgos"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("vulcano"),
            keywords: &["vulcano", "vulcano in eruzione"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("火山"),
            keywords: &["噴火", "山", "火山"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("gunung geni"),
            keywords: &["gunung", "gunung geni", "njeblug"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ვულკანი"),
            keywords: &["ამინდი", "ამოფრქვევა", "ვულკანი", "მთა"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("aburkan"),
            keywords: &["aburkan"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("вулкан"),
            keywords: &["атылу", "ауа райы", "вулкан", "тау"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("vulkan"),
            keywords: &["vulkan", "vulkanudbrud"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ភ\u{17d2}ន\u{17c6}ភ\u{17d2}លើង"),
            keywords: &[
                "ផ\u{17d2}ទ\u{17bb}ះ",
                "ភ\u{17d2}ន\u{17c6}",
                "ភ\u{17d2}ន\u{17c6}ភ\u{17d2}លើង",
                "អាកាសធាត\u{17bb}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಜ\u{ccd}ವಾಲಾಮುಖ\u{cbf}"),
            keywords: &[
                "ಜ\u{ccd}ವಾಲಾಮುಖ\u{cbf}",
                "ಜ\u{ccd}ವಾಲಾಮುಖ\u{cbf} ಸ\u{ccd}ಪೋಟ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("화산"),
            keywords: &["화산", "화산 폭발"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("ज\u{94d}वालाम\u{941}खी"),
            keywords: &[
                "ज\u{94d}वालाम\u{941}खी",
                "ज\u{94d}वालास\u{94d}फोट",
                "पर\u{94d}वत",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("вулкан"),
            keywords: &["аба-ырайы", "атылуу", "вулкан", "тоо"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Vulkan"),
            keywords: &["Bierg", "Eruptioun", "Vulkan"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ພ\u{eb9}ເຂ\u{ebb}າໄຟ"),
            keywords: &[
                "ປະທ\u{eb8}",
                "ພ\u{eb9}",
                "ພ\u{eb9}ເຂ\u{ebb}າໄຟ",
                "ສະພາບອາກາດ",
                "ຮ\u{ec9}ອນ",
                "ເດ\u{eb7}ອດ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("ugnikalnis"),
            keywords: &["išsiveržimas", "kalnas", "ugnikalnis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("vulkāns"),
            keywords: &["izvirdums", "kalns", "vulkāns"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("puia"),
            keywords: &["maunga", "puia"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("вулкан"),
            keywords: &["вулкан", "ерупција", "планина"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("അഗ\u{d4d}നിപർവ\u{d4d}വതം"),
            keywords: &[
                "അഗ\u{d4d}നിപർവതം",
                "അഗ\u{d4d}നിപർവ\u{d4d}വതം",
                "സ\u{d4d}ഫോടനം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("галт уул"),
            keywords: &["галт", "уул", "цаг агаар"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("ज\u{94d}वालाम\u{941}खी"),
            keywords: &[
                "ज\u{94d}वालाम\u{941}खी",
                "ज\u{94d}वालाम\u{941}खीचा उद\u{94d}र\u{947}क",
                "पर\u{94d}वत",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("gunung berapi"),
            keywords: &["cuaca", "gunung", "gunung berapi", "letusan"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("vulkan"),
            keywords: &["eruzzjoni", "muntanja", "vulkan"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("မ\u{102e}းတောင\u{103a}"),
            keywords: &[
                "တောင\u{103a}",
                "ပေါက\u{103a}က\u{103d}\u{1032}",
                "မ\u{102e}းတောင\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("vulkan"),
            keywords: &["utbrudd", "vulkan", "vulkanutbrudd"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("ज\u{94d}वालाम\u{941}खी"),
            keywords: &[
                "ज\u{94d}वालाम\u{941}खी",
                "निस\u{94d}कन\u{947} कार\u{94d}य",
                "मौ\u{902}सम",
                "हिमाल",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("vulkaan"),
            keywords: &["berg", "vulkaan", "vulkaanuitbarsting"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("vulkan"),
            keywords: &["utbrot", "vulkan", "vulkanutbrot"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଭଲ\u{b4d}କ\u{b3e}ନୋ"),
            keywords: &[
                "ଆଗ\u{b4d}ନେୟଗ\u{b3f}ର\u{b3f}",
                "ଆଗ\u{b4d}ନେୟଗ\u{b3f}ର\u{b3f} ବ\u{b3f}ସ\u{b4d}ଫୋଟ",
                "ଆଗ\u{b4d}ନେୟଗୀର",
                "ଭଲ\u{b4d}କ\u{b3e}ନୋ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਜਵਾਲਾਮ\u{a41}ਖੀ"),
            keywords: &[
                "ਜਵਾਲਾਮ\u{a41}ਖੀ",
                "ਜਵਾਲਾਮ\u{a41}ਖੀ ਫ\u{a71}ਟਣਾ",
                "ਪਹਾੜ",
                "ਮ\u{a4c}ਸਮ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("آتش فشاں"),
            keywords: &["آتش فشاں", "پھٹن دا عمل", "پہاڑ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Volkáno"),
            keywords: &["Blo", "Maúntin", "Volkáno"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("wulkan"),
            keywords: &["erupcja", "góra", "wulkan"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("آتش فشان غر"),
            keywords: &["آتش فشان غر", "آتش فشاڼ", "راوتل", "غر"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("vulcão"),
            keywords: &["erupção vulcânica", "vulcão"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["erupção", "montanha", "vulcão"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("ariq"),
            keywords: &["ariq", "erupcion", "urqu"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("vulcan"),
            keywords: &["erupție", "lavă", "munte", "vulcan"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-210"),
            keywords: &["E10-210"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("вулкан"),
            keywords: &["вулкан", "извержение вулкана", "кратер", "лава"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ikirunga"),
            keywords: &["ikirunga", "kuruka kw’ikirunga", "umusozi"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ٻرندڙ جبل"),
            keywords: &["ٻرندڙ جبل", "ڦٽڻ، جبل"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ග\u{dd2}න\u{dd2}කන\u{dca}ද"),
            keywords: &[
                "කන\u{dca}ද",
                "ක\u{dcf}ලග\u{dd4}ණය",
                "ග\u{dd2}න\u{dd2}කන\u{dca}ද",
                "ප\u{dd2}ප\u{dd2}ර\u{dd3}ම",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("sopka"),
            keywords: &["erupcia", "hora", "sopka", "vrch"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("vulkan"),
            keywords: &["gora", "izbruh", "vreme", "vulkan"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("folkano"),
            keywords: &["buur", "folkano", "qarax"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("vullkan"),
            keywords: &["mal", "moti", "shpërthim", "vullkan"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("вулкан"),
            keywords: &["eрупциja", "вулкан", "плaнинa"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["вулкан"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("vulkan"),
            keywords: &["erupcija", "planina", "vulkan"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["vulkan"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("vulkan"),
            keywords: &["vulkan", "vulkanutbrott"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("volkano"),
            keywords: &["hali ya hewa", "kulipuka", "mlima", "volkano"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("எரிமலை"),
            keywords: &[
                "எரிமலை",
                "நெருப\u{bcd}பு",
                "ல\u{bbe}வ\u{bbe}",
                "வெடிக\u{bcd}கும\u{bcd} எரிமலை",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("అగ\u{c4d}న\u{c3f}పర\u{c4d}వతం"),
            keywords: &[
                "అగ\u{c4d}న\u{c3f} పర\u{c4d}వతం బద\u{c4d}దలవ\u{c4d}వడం",
                "అగ\u{c4d}న\u{c3f}పర\u{c4d}వతం",
                "క\u{c4b}పం కట\u{c4d}టలు త\u{c46}ంచుక\u{c4b}వడం",
                "ల\u{c3e}వ\u{c3e} ఎగజ\u{c3f}మ\u{c4d}మడం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("вулқон"),
            keywords: &["вулқон", "куҳ", "оташфишонӣ"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ภ\u{e39}เขาไฟ"),
            keywords: &["ภ\u{e39}เขาไฟ", "ภ\u{e39}เขาไฟระเบ\u{e34}ด"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ýanardag"),
            keywords: &["dag", "partlama", "ýanardag"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("moʻungaafi"),
            keywords: &["moʻungaafi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("yanardağ"),
            keywords: &["dağ", "volkan", "yanardağ", "yanardağ patlaması"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("يانارتاغ"),
            keywords: &["ئۆرلەش", "تاغ", "يانارتاغ"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("вулкан"),
            keywords: &["виверження", "вулкан", "гора"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("آتش فشاں"),
            keywords: &["آتش فشاں", "آگ", "موسم", "پھٹنا", "پہاڑ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("vulqon"),
            keywords: &["ob-havo", "tog‘", "vulqon"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("núi lửa"),
            keywords: &["núi", "núi lửa", "phun trào"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("géeju xal"),
            keywords: &["géeju xal", "montaañ", "xal yuy génn"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("intabamlilo"),
            keywords: &["intaba", "intabamlilo", "ukudubula"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ifẹ-ilẹ"),
            keywords: &["Ifẹ-ilẹ", "ìfẹ\u{300} ilẹ\u{300}", "òkè"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("火山"),
            keywords: &["山", "火山", "爆發"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("火山"),
            keywords: &["山", "火山", "爆发"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("火山"),
            keywords: &["喷发", "山", "火山", "爆发"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("火山"),
            keywords: &["火山", "火山爆發"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("intabamlilo"),
            keywords: &["intaba", "intabamlilo", "isimo sezulu", "ukuqhuma"],
        },
    ],
};
#[doc = "🗻"]
pub const MOUNT_FUJI: crate::Emoji = crate::Emoji {
    glyph: "🗻",
    codepoint: "1F5FB",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "mount fuji",
    group: "Travel & Places",
    subgroup: "place-geographic",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("berg foedji"),
            keywords: &["berg", "foedji", "fuji", "japan"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የፉጂ ተራራ"),
            keywords: &["ተራራ", "የፉጂ ተራራ", "ፉጂ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("جبل فوجي"),
            keywords: &["جبل", "جبل فوجي"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ম\u{9be}উণ\u{9cd}ট ফ\u{9c1}জি"),
            keywords: &[
                "পৰ\u{9cd}ব\u{9cd}বত",
                "ফ\u{9c1}জি",
                "ম\u{9be}উণ\u{9cd}ট ফ\u{9c1}জি",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("fuji dağı"),
            keywords: &["dağ", "fuji", "fuji dağı"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("гара фудзі"),
            keywords: &["гара", "фудзі", "фудзіяма", "японія"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("връх Фуджи"),
            keywords: &["връх Фуджи", "планина", "фуджи"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ম\u{9be}উন\u{9cd}ট ফ\u{9c1}জি"),
            keywords: &["পর\u{9cd}বত", "ফ\u{9c1}জি", "ম\u{9be}উন\u{9cd}ট ফ\u{9c1}জি"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("menez Fuji"),
            keywords: &["Fuji", "menez"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("planina fudži"),
            keywords: &["fudži", "planina"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("mont Fuji"),
            keywords: &["Fuji", "mont", "muntanya"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏡᏥ ᎣᏓᎸ"),
            keywords: &["ᎣᏓᎳ", "ᏡᏥ", "ᏡᏥ ᎣᏓᎸ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("hora Fudži"),
            keywords: &["fudži", "fuji", "hora", "hora Fudži"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("mynydd Fuji"),
            keywords: &["fuji", "mynydd", "mynydd Fuji"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("Fuji-bjerget"),
            keywords: &["Fuji", "Fuji-bjerget", "bjerg"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Fuji"),
            keywords: &["Berg", "Fuji"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ηφαίστειο Φούτζι"),
            keywords: &["Φούτζι", "βουνό", "ηφαίστειο Φούτζι"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("mount fuji"),
            keywords: &["fuji", "mount fuji", "mountain"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("mount Fuji"),
            keywords: &["Fuji", "mount Fuji", "mountain"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("mount Fuji"),
            keywords: &["Fuji", "mount Fuji", "mountain"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("monte Fuji"),
            keywords: &["montaña", "monte Fuji", "monte fuji"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["montaña", "monte", "monte Fuji"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("Fuji mägi"),
            keywords: &["Fuji", "mägi"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("fuji mendia"),
            keywords: &["fuji", "fuji mendia", "mendi"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("کوه فوجی"),
            keywords: &["فوجی", "کوه"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("Fuji-vuori"),
            keywords: &["Fuji", "Fuji-vuori", "vuori"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("bundok fuji"),
            keywords: &["bundok", "fuji", "japan", "mount fuji", "mt fuji"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("fuji"),
            keywords: &["fjall", "fuji"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("mont Fuji"),
            keywords: &["mont Fuji", "montagne"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["Fuji", "mont", "montagne"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("Sliabh Fuji"),
            keywords: &["Sliabh Fuji"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("Beinn Fuji"),
            keywords: &["Beinn Fuji", "beinn", "fuji"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("monte Fuji"),
            keywords: &["Xapón", "montaña", "monte", "monte Fuji"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("માઉન\u{acd}ટ ફ\u{ac1}જી"),
            keywords: &["પર\u{acd}વત", "મા. ફ\u{ac1}જી", "માઉન\u{acd}ટ ફ\u{ac1}જી"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("tsaunin fuji"),
            keywords: &["fuji", "tsauni", "tsaunin fuji"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("הר פוג׳י"),
            keywords: &["הר געש", "הר פוג׳י", "יפן"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("माउ\u{902}ट फ\u{93c}\u{942}जी"),
            keywords: &["पहाड\u{93c}ी", "माउ\u{902}ट फ\u{93c}\u{942}जी"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("planina Fuji"),
            keywords: &["fuji", "planina", "planina Fuji"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("Fudzsi-hegy"),
            keywords: &["Fudzsi-hegy", "fudzsi", "hegy"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("Ֆուջի լեռ"),
            keywords: &[
                "Ֆուձի",
                "Ֆուձիյամա",
                "Ֆուջի լեռ",
                "գագաթ",
                "լեռ",
                "սար",
                "ֆուջի",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("gunung Fuji"),
            keywords: &["fuji", "gunung", "gunung Fuji"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ugwu fuji"),
            keywords: &["fuji", "ugwu"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("fuji-fjall"),
            keywords: &["fjall", "fuji", "fuji-fjall"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("Monte Fuji"),
            keywords: &["Monte Fuji", "montagna"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("富士山"),
            keywords: &["富士山", "山"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("gunung fuji"),
            keywords: &["fuji", "gunung"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მთა ფუძი"),
            keywords: &["მთა", "ფუძი", "ფუჯი"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("Taqacuct Fuji"),
            keywords: &["Taqacuct Fuji"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("Фудзияма"),
            keywords: &["Фудзияма", "тау", "фудзияма"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("Mount Fuji"),
            keywords: &["Fuji", "Fuji-bjerget", "Mount Fuji", "bjerg"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ភ\u{17d2}ន\u{17c6}ហ\u{17d2}វ\u{17bc}ជ\u{17b8} (នៅជប\u{17c9}\u{17bb}ន)"),
            keywords: &[
                "ភ\u{17d2}ន\u{17c6}",
                "ភ\u{17d2}ន\u{17c6}ហ\u{17d2}វ\u{17bc}ជ\u{17b8} (នៅជប\u{17c9}\u{17bb}ន)",
                "ហ\u{17d2}វ\u{17bc}ជ\u{17b8}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಮ\u{ccc}ಂಟ\u{ccd} ಫುಜ\u{cbf}"),
            keywords: &["ಪರ\u{ccd}ವತ", "ಮ\u{ccc}ಂಟ\u{ccd} ಫುಜ\u{cbf}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("후지산"),
            keywords: &["산", "후지산"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("माव\u{902}ट फ\u{941}जी"),
            keywords: &["पर\u{94d}वत", "फ\u{941}जी", "माव\u{902}ट फ\u{941}जी"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("фудзияма тоосу"),
            keywords: &["тоо", "фудзияма", "фудзияма тоосу"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Mount Fuji"),
            keywords: &["Bierg", "Fuji", "Mount Fuji"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ພ\u{eb9}ເຂ\u{ebb}າໄຟຟ\u{eb9}ຈ\u{eb4}"),
            keywords: &[
                "ພ\u{eb9}ເຂ\u{ebb}າໄຟ",
                "ພ\u{eb9}ເຂ\u{ebb}າໄຟຟ\u{eb9}ຈ\u{eb4}",
                "ພ\u{eb9}ໄຟ",
                "ຟ\u{eb9}ຈ\u{eb4}",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("Fudžio kalnas"),
            keywords: &["Fudžio kalnas", "Fudžis", "kalnas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("Fudzi kalns"),
            keywords: &["Fudzi", "kalns"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("maunga fuji"),
            keywords: &["fuji", "maunga"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("планината Фуџи"),
            keywords: &["Фуџи", "планина", "планината Фуџи"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഫ\u{d41}ജി പർവ\u{d4d}വതം"),
            keywords: &[
                "ഫ\u{d41}ജി പർവ\u{d4d}വതം",
                "ഫ\u{d4d}യ\u{d42}ജി",
                "ഫ\u{d4d}യ\u{d42}ജി പർവ\u{d4d}വതം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("фүжи уул"),
            keywords: &["уул", "фүжи"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("फ\u{941}जी पर\u{94d}वत"),
            keywords: &[
                "फ\u{941}जी",
                "फ\u{941}जी पर\u{94d}वत",
                "माउ\u{902}ट फ\u{941}जी",
                "माउ\u{902}टन",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("gunung fuji"),
            keywords: &["fuji", "gunung"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("muntanja fuji"),
            keywords: &["fuji", "muntanja"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဖ\u{1030}ဂျ\u{102e}တောင\u{103a}"),
            keywords: &[
                "တောင\u{103a}",
                "ဖ\u{1030}ဂျ\u{102e}",
                "ဖ\u{1030}ဂျ\u{102e}တောင\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("Fuji-fjellet"),
            keywords: &["Fuji-fjellet", "fjell", "fuji"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("फ\u{941}जी हिमाल"),
            keywords: &["फ\u{941}जी", "हिमाल"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("berg Fuji"),
            keywords: &["Fuji", "berg"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("Fuji-fjellet"),
            keywords: &["Fuji-fjellet", "fjell", "fuji"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ମ\u{b3e}ଉଣ\u{b4d}ଟ ଫ\u{b41}ଜ\u{b3f}"),
            keywords: &[
                "ପ\u{b3e}ହ\u{b3e}ଡ\u{b3c}",
                "ମ\u{b3e}ଉଣ\u{b4d}ଟ ଫ\u{b41}ଜ\u{b3f}",
                "ମ\u{b3e}ଉଣ\u{b4d}ଟ\u{b4d}. ଫ\u{b41}ଜ\u{b3f}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਮਾਊ\u{a02}ਟ ਫ\u{a42}ਜੀ"),
            keywords: &["ਪਹਾੜੀ", "ਫ\u{a42}ਜੀ", "ਮਾਊ\u{a02}ਟ ਫ\u{a42}ਜੀ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ماؤنٹ فجی"),
            keywords: &["فوجی", "ماؤنٹ فجی", "پہاڑ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Fújí Maúntin"),
            keywords: &["Fúji", "Fújí Maúntin", "Maúntin"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("góra Fudżi"),
            keywords: &["fudżi", "fuji", "góra", "góra Fudżi"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د فوجي غر"),
            keywords: &["د فوجي غر", "غر", "فوجي"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("Monte Fuji"),
            keywords: &["Monte Fuji", "montanha"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("monte Fuji"),
            keywords: &["fuji", "montanha", "monte Fuji"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("fuji urqi"),
            keywords: &["fuji", "fuji urqi", "urqu"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("muntele Fuji"),
            keywords: &["Fuji", "munte", "muntele Fuji"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-831"),
            keywords: &["E10-831"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("Фудзияма"),
            keywords: &["Фудзияма", "вулкан", "гора"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umusozi wa fuji"),
            keywords: &["fuji", "umusozi", "umusozi wa fuji"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("مائونٽ فوجي"),
            keywords: &["فوجي، جبل", "مائونٽ فوجي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ෆ\u{dd3}ජ\u{dd2} කන\u{dca}ද"),
            keywords: &["කන\u{dca}ද", "ෆ\u{dd3}ජ\u{dd2}"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("Fudžisan"),
            keywords: &["Fudžisan", "fudži", "hora", "vrch"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("gora Fuji"),
            keywords: &["Fuji", "gora"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("buurta fuji"),
            keywords: &["buur", "buurta fuji", "fuji"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("mali i Fuxhit"),
            keywords: &["Fuxhi", "mal", "mali i Fuxhit"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("планина фуџи"),
            keywords: &["плaнинa", "планина фуџи", "фуџи"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("planina fudži"),
            keywords: &["fudži", "planina"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("Fuji"),
            keywords: &["Fuji", "berg"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mlima fuji"),
            keywords: &["fuji", "mlima"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("எவரெஸ\u{bcd}ட\u{bcd}"),
            keywords: &["எவரெஸ\u{bcd}ட\u{bcd}", "சிகரம\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ఫుజ\u{c3f} పర\u{c4d}వతం"),
            keywords: &[
                "ఫుజ\u{c3f} పర\u{c4d}వతం",
                "మంచుత\u{c4b} కప\u{c4d}పబడ\u{c3f}న పర\u{c4d}వతం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("теппаи Фуҷи"),
            keywords: &["куҳ", "теппаи Фуҷи", "фуҷи"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ภ\u{e39}เขาไฟฟ\u{e39}จ\u{e34}"),
            keywords: &["ภ\u{e39}เขา", "ภ\u{e39}เขาไฟฟ\u{e39}จ\u{e34}"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("Fuji dagy"),
            keywords: &["Fuji dagy", "dag", "fuji"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("moʻunga ko Fusi"),
            keywords: &["moʻunga ko Fusi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("Fuji Dağı"),
            keywords: &["Fuji Dağı", "dağ"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("فۇجى تېغى"),
            keywords: &["تاغ", "فۇجى", "فۇجى تېغى"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("гора Фудзі"),
            keywords: &["гора", "гора Фудзі", "фудзі"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ماؤنٹ فیوجی"),
            keywords: &["فیوجی", "ماؤنٹ فیوجی", "پہاڑ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("fuji tog‘i"),
            keywords: &["fuji", "fuji tog‘i", "tog‘"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("núi Phú Sĩ"),
            keywords: &["Phú Sĩ", "núi", "núi Phú Sĩ"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("tundu fuji"),
            keywords: &["fuji", "montaañ", "tundu fuji"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("intaba i-fuji"),
            keywords: &["i-fuji", "intaba"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Oke Fuji"),
            keywords: &["Oke Fuji", "fújì", "òkè"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("富士山"),
            keywords: &["富士", "富士山", "山"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("富士山"),
            keywords: &["富士", "富士山", "山"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("富士山"),
            keywords: &["富士山", "山"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("富士山"),
            keywords: &["富士山", "山峰"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("intaba ifuji"),
            keywords: &["ifuji", "intaba"],
        },
    ],
};
#[doc = "🏕\u{fe0f}"]
pub const CAMPING: crate::Emoji = crate::Emoji {
    glyph: "🏕\u{fe0f}",
    codepoint: "1F3D5 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.7f32,
    name: "camping",
    group: "Travel & Places",
    subgroup: "place-geographic",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🏕",
        codepoint: "1F3D5",
        status: crate::Status::Unqualified,
        introduction_version: 0.7f32,
        name: "camping",
        group: "Travel & Places",
        subgroup: "place-geographic",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("kampeer"),
            keywords: &["kampeer", "tent", "veld"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ሰፈራ"),
            keywords: &["ሰፈራ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("تخييم"),
            keywords: &["تخييم", "خيمة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("কেম\u{9cd}পিং"),
            keywords: &["কেম\u{9cd}পিং"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("kempinq"),
            keywords: &["kempinq"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("кемпінг"),
            keywords: &["кемпінг"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("къмпинг"),
            keywords: &["къмпинг"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ত\u{9be}ব\u{9c1} খ\u{9be}\u{981}ট\u{9be}নো"),
            keywords: &["ত\u{9be}ব\u{9c1} খ\u{9be}\u{981}ট\u{9be}নো"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("kampiñ"),
            keywords: &["kampiñ"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("kampovanje"),
            keywords: &["kamp", "kampovanje"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("acampada"),
            keywords: &["acampada", "campament", "càmping"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏓᏂᎵᏦᏛᏍᎬᎢ"),
            keywords: &["ᏓᏂᎵᏦᏛᏍᎬᎢ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("tábor"),
            keywords: &["kemp", "kempování", "stan", "tábor", "táboření"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("gwersyllu"),
            keywords: &["gwersylla", "gwersyllu"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("camping"),
            keywords: &["camping", "telt"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Camping"),
            keywords: &["Camping", "Zelt", "campen", "zelten"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κατασκήνωση"),
            keywords: &["κατασκήνωση"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("camping"),
            keywords: &["camping"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: None,
            keywords: &["camping", "tent"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("camping"),
            keywords: &["acampada", "campamento", "camping", "vacaciones"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("campamento"),
            keywords: &["acampar", "campamento", "carpa", "vacaciones"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("telkimine"),
            keywords: &["telk", "telkimine"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("kanpina"),
            keywords: &["kanpin", "kanpina"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("چادرزنی"),
            keywords: &["اردو", "چادر زدن", "چادرزنی", "کمپینگ"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("telttailu"),
            keywords: &["leiri", "leirintäalue", "teltta", "telttailu"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("camping"),
            keywords: &["camping", "scout", "tent"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("tjaldstaður"),
            keywords: &[
                "kampingpláss",
                "legupláss",
                "legutilvera",
                "tjald",
                "tjalding",
                "tjaldlega",
                "tjaldstaður",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("camping"),
            keywords: &["camping"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("ag campáil"),
            keywords: &["ag campáil"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("campachadh"),
            keywords: &["campachadh"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cámping"),
            keywords: &["campismo", "cámping"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ક\u{ac7}મ\u{acd}પિ\u{a82}ગ"),
            keywords: &["ક\u{ac7}મ\u{acd}પિ\u{a82}ગ", "ત\u{a82}બ\u{ac1} લગાવવો"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("zaman ruga"),
            keywords: &["zaman ruga"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("מחנאות"),
            keywords: &["אוהל", "טיול", "מחנאות", "מחנה", "קמפינג"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("त\u{902}ब\u{942}, त\u{902}ब\u{942} लगाना"),
            keywords: &[
                "त\u{902}ब\u{942}",
                "त\u{902}ब\u{942} लगाना",
                "त\u{902}ब\u{942}, त\u{902}ब\u{942} लगाना",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("kampiranje"),
            keywords: &["kampiranje"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("sátorozás"),
            keywords: &["kemping", "sátorozás"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ճամբար"),
            keywords: &["արշավ", "ճամբար", "վրաններ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("berkemah"),
            keywords: &["berkemah", "kemah", "tenda"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ọgbakọ nzuruike"),
            keywords: &["ọgbakọ nzuruike"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("tjaldstæði"),
            keywords: &["ferðalag", "tjald", "tjaldstæði"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("campeggio"),
            keywords: &["campeggio", "tenda", "vacanza"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("キャンプ"),
            keywords: &["キャンプ", "テント", "山"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("kemah"),
            keywords: &["kemah"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("კემპინგი"),
            keywords: &["კემპინგი"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("asdar"),
            keywords: &["asdar"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("кемпинг"),
            keywords: &["кемпинг"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("camping"),
            keywords: &["camping", "telt"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("បោះជ\u{17c6}រ\u{17bb}\u{17c6}"),
            keywords: &[
                "ជ\u{17c6}រ\u{17bb}\u{17c6}",
                "បោះជ\u{17c6}រ\u{17bb}\u{17c6}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕ\u{ccd}ಯಾಂಪ\u{cbf}ಂಗ\u{ccd}"),
            keywords: &["ಕ\u{ccd}ಯಾಂಪ\u{cbf}ಂಗ\u{ccd}", "ಶ\u{cbf}ಬ\u{cbf}ರಗಳು"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("캠핑"),
            keywords: &["캠핑", "텐트"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("छावणी"),
            keywords: &["छावणी"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("өргү жасоо"),
            keywords: &["лагерь", "өргү жасоо"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Camping"),
            keywords: &["Camping"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ການຕ\u{eb1}\u{ec9}ງແຄ\u{eb1}ມ"),
            keywords: &["ການຕ\u{eb1}\u{ec9}ງແຄ\u{eb1}ມ", "ເຕ\u{eb1}ນ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("stovyklavimas"),
            keywords: &["stovyklavimas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("kempings"),
            keywords: &["kempings", "nometne", "telts"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("puninga"),
            keywords: &["puninga"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("кампување"),
            keywords: &["кампување"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ക\u{d4d}യ\u{d3e}മ\u{d4d}പിംഗ\u{d4d}"),
            keywords: &[
                "ക\u{d4d}യ\u{d3e}മ\u{d4d}പിംഗ\u{d4d}",
                "ക\u{d4d}യ\u{d3e}മ\u{d4d}പ\u{d41}ചെയ\u{d4d}യ\u{d41}ക",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("аялал"),
            keywords: &["аялал", "майхан", "хээр хонох"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("क\u{945}म\u{94d}पि\u{902}ग"),
            keywords: &["क\u{945}म\u{94d}पि\u{902}ग"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("berkhemah"),
            keywords: &["berkhemah"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("kampeġġ"),
            keywords: &["kampeġġ"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("စခန\u{103a}းချနေခြင\u{103a}း"),
            keywords: &["စခန\u{103a}းချနေခြင\u{103a}း"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("telttur"),
            keywords: &["camping", "telttur"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("क\u{94d}याम\u{94d}पिङ"),
            keywords: &["क\u{94d}याम\u{94d}पिङ"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("kamperen"),
            keywords: &["kamperen"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("telttur"),
            keywords: &["camping", "telttur"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଶ\u{b3f}ବ\u{b3f}ର ସ\u{b4d}ଥ\u{b3e}ପନ କର\u{b3f}ବ\u{b3e}"),
            keywords: &["ଶ\u{b3f}ବ\u{b3f}ର ସ\u{b4d}ଥ\u{b3e}ପନ କର\u{b3f}ବ\u{b3e}"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਤ\u{a70}ਬ\u{a42} ਲਗਾਉਣਾ"),
            keywords: &[
                "ਕ\u{a48}\u{a02}ਪ",
                "ਕ\u{a48}\u{a02}ਪ ਲਗਾਉਣਾ",
                "ਤ\u{a70}ਬ\u{a42}",
                "ਤ\u{a70}ਬ\u{a42} ਲਗਾਉਣਾ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("خیمہ زنی"),
            keywords: &["خیمہ زنی"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Kamp"),
            keywords: &["Kamp"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("kemping"),
            keywords: &["kamping", "kemping", "namiot", "obóz"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("کیمپنګ"),
            keywords: &["کیمپنګ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("acampamento"),
            keywords: &["acampamento", "barraca"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("campismo"),
            keywords: &["acampar", "campismo"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("tampuchay"),
            keywords: &["tampuchay"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("camping"),
            keywords: &["camping", "cort"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-405"),
            keywords: &["E10-405"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("кемпинг"),
            keywords: &["кемпинг", "лагерь", "палатка"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ingando"),
            keywords: &["ingando"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڪيمپ لڳائڻ"),
            keywords: &["ڪيمپ لڳائڻ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("කඳව\u{dd4}ර\u{dd4} බැඳ\u{dd3}ම"),
            keywords: &["කඳව\u{dd4}ර\u{dd4} බැඳ\u{dd3}ම"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("stanovanie"),
            keywords: &["kemping", "stanovanie", "táborenie"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("kampiranje"),
            keywords: &["kampiranje", "šotor"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("xero"),
            keywords: &["xero"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("kamp"),
            keywords: &["kamp"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("камповање"),
            keywords: &["кaмповање", "камповање"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["камповање"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("kampovanje"),
            keywords: &["kampovanje"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["kampovanje"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("camping"),
            keywords: &["camping", "tält"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kupiga kambi"),
            keywords: &["kupiga kambi"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("முக\u{bbe}மிடுதல\u{bcd}"),
            keywords: &["முக\u{bbe}மிடுதல\u{bcd}", "முக\u{bbe}ம\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("శ\u{c3f}బ\u{c3f}రం"),
            keywords: &["శ\u{c3f}బ\u{c3f}రం"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("хаймазанӣ"),
            keywords: &["хаймазанӣ"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ต\u{e31}\u{e49}งแคมป\u{e4c}"),
            keywords: &[
                "ต\u{e31}\u{e49}งแคมป\u{e4c}",
                "เต\u{e47}นท\u{e4c}",
                "แคมป\u{e4c}",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("kemping"),
            keywords: &["kemping"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("fakateniti"),
            keywords: &["fakateniti"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("kamp"),
            keywords: &["kamp", "kamp yapma"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("دالىدا قونۇش"),
            keywords: &["دالىدا قونۇش"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("кемпінг"),
            keywords: &["кемпінг", "похід"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("پڑاؤ"),
            keywords: &["سفر", "پڑاؤ", "ڈیرا", "کیمپنگ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("tabiat qo‘ynida dam"),
            keywords: &["tabiat qo‘ynida dam"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("cắm trại"),
            keywords: &["cắm trại"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("kampiŋ"),
            keywords: &["kampiŋ"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ukuhlala ententeni"),
            keywords: &["ukuhlala ententeni"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("pípàgọ\u{301}"),
            keywords: &["pípàgọ\u{301}"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("露營"),
            keywords: &["露營"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("露营"),
            keywords: &["露营"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("露营"),
            keywords: &["帐篷", "露营"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("露營"),
            keywords: &["帳篷露營", "露營"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["帳篷", "露營"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ukukhempa"),
            keywords: &["ukukhempa"],
        },
    ],
};
#[doc = "🏖\u{fe0f}"]
pub const BEACH_WITH_UMBRELLA: crate::Emoji = crate::Emoji {
    glyph: "🏖\u{fe0f}",
    codepoint: "1F3D6 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.7f32,
    name: "beach with umbrella",
    group: "Travel & Places",
    subgroup: "place-geographic",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🏖",
        codepoint: "1F3D6",
        status: crate::Status::Unqualified,
        introduction_version: 0.7f32,
        name: "beach with umbrella",
        group: "Travel & Places",
        subgroup: "place-geographic",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("strand met sambreel"),
            keywords: &["sambreel", "see", "strand", "strand met sambreel"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የባሕር ዳርቻ ከዣንጥላ ጋር"),
            keywords: &["ዣንጥላ", "የባሕር ዳርቻ", "የባሕር ዳርቻ ከዣንጥላ ጋር"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("شاطئ وشمسية"),
            keywords: &["شاطئ", "شاطئ وشمسية", "شمسية"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ছ\u{9be}তি সহ সম\u{9c1}দ\u{9cd}ৰতীৰ"),
            keywords: &[
                "ছ\u{9be}তি",
                "ছ\u{9be}তি সহ সম\u{9c1}দ\u{9cd}ৰতীৰ",
                "সম\u{9c1}দ\u{9cd}ৰতীৰ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("çətirli çimərlik"),
            keywords: &["çimərlik", "çətir", "çətirli çimərlik"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("пляж і парасон"),
            keywords: &["парасон", "пляж", "пляж і парасон"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("плаж с чадър"),
            keywords: &["плаж", "плаж с чадър", "чадър"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("সম\u{9c1}দ\u{9cd}র সৈকতে ছ\u{9be}ত\u{9be}"),
            keywords: &[
                "ছ\u{9be}ত\u{9be}",
                "সম\u{9c1}দ\u{9cd}র সৈকতে ছ\u{9be}ত\u{9be}",
                "সৈকত",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("traezhenn gant disheolier"),
            keywords: &["disheolier", "traezhenn", "traezhenn gant disheolier"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("plaža sa suncobranom"),
            keywords: &["plaža", "plaža sa suncobranom", "suncobran"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("platja amb para-sol"),
            keywords: &["para-sol", "platja", "platja amb para-sol"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏃᏳᎯ ᎠᏓᏩᏗᏍᏙᏗ"),
            keywords: &["ᎠᏓᏩᏗᏍᏙᏗ", "ᏃᏳᎯ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("pláž se slunečníkem"),
            keywords: &["deštník", "pláž", "pláž se slunečníkem", "slunečník"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("traeth ag ymbarél"),
            keywords: &["traeth", "traeth ag ymbarél", "ymbarél"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("strand med parasol"),
            keywords: &["parasol", "strand", "strand med parasol"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Strand mit Sonnenschirm"),
            keywords: &["Meer", "Sonnenschirm", "Strand", "Strand mit Sonnenschirm"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("παραλία με ομπρέλα"),
            keywords: &["ομπρέλα", "παραλία", "παραλία με ομπρέλα"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("beach with umbrella"),
            keywords: &["beach", "beach with umbrella", "umbrella"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: None,
            keywords: &["beach", "beach with umbrella", "parasol", "umbrella"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("playa y sombrilla"),
            keywords: &["playa", "playa y sombrilla", "sombrilla"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &[
                "mar",
                "playa",
                "playa y sombrilla",
                "sombrilla",
                "vacaciones",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("päikesevari rannas"),
            keywords: &["päikesevari", "päikesevari rannas", "rand"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("eguzkitakoa hondartzan"),
            keywords: &["eguzkitako", "eguzkitakoa hondartzan", "hondartza"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("ساحل و سایبان"),
            keywords: &["ساحل", "ساحل و سایبان", "سایه\u{200c}بان", "چتر"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("ranta ja aurinkovarjo"),
            keywords: &["aurinkovarjo", "ranta", "ranta ja aurinkovarjo"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("beach na may payong"),
            keywords: &["beach", "beach na may payong", "dagat", "payong", "summer"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("sólskjól á strond"),
            keywords: &["strond", "sólskjól", "sólskjól á strond"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("plage avec parasol"),
            keywords: &["parasol", "plage", "plage avec parasol"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("plage et parasol"),
            keywords: &["parasol", "plage", "plage et parasol"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("trá le scáth gréine"),
            keywords: &["scáth", "trá", "trá le scáth", "trá le scáth gréine"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("tràigh le sgàilean"),
            keywords: &["sgàilean", "tràigh", "tràigh le sgàilean"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("praia e parasol"),
            keywords: &["parasol", "praia", "praia e parasol", "vacacións", "verán"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("છત\u{acd}રી સાથ\u{ac7}નો સમ\u{ac1}દ\u{acd}રતટ"),
            keywords: &[
                "છત\u{acd}રી",
                "છત\u{acd}રી સાથ\u{ac7}નો સમ\u{ac1}દ\u{acd}રતટ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("bakin teku tare da laima"),
            keywords: &["bakin teku", "bakin teku tare da laima", "laima"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("חוף עם שמשיה"),
            keywords: &["חוף", "חוף עם שמשיה", "ים", "קיץ", "שמשיה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("छात\u{947} क\u{947} साथ सम\u{941}द\u{94d}री किनारा, छाता"),
            keywords: &[
                "छाता",
                "छात\u{947} क\u{947} साथ सम\u{941}द\u{94d}री किनारा",
                "छात\u{947} क\u{947} साथ सम\u{941}द\u{94d}री किनारा, छाता",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("plaža sa suncobranom"),
            keywords: &["plaža", "plaža sa suncobranom", "suncobran"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("strand napernyővel"),
            keywords: &["napernyő", "strand", "strand napernyővel", "tengerpart"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("լողափ հովանոցով"),
            keywords: &["լողափ", "լողափ հովանոցով", "հովանոց"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("pantai dan payung"),
            keywords: &["pantai", "pantai dan payung", "payung"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("akụkụ mmiri nwere umbrali"),
            keywords: &["akụkụ mmiri", "akụkụ mmiri nwere umbrali", "umbrali"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("strönd með sólhlíf"),
            keywords: &["strönd", "strönd með sólhlíf", "sólhlíf"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("spiaggia con ombrellone"),
            keywords: &[
                "estate",
                "mare",
                "ombrellone",
                "ombrellone in spiaggia",
                "spiaggia",
                "spiaggia con ombrellone",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ビーチパラソル"),
            keywords: &["パラソル", "ビーチ", "ビーチパラソル", "砂浜"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("pasisir karo payung tumancep"),
            keywords: &["pasisir", "pasisir karo payung tumancep", "payung"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("პლაჟი და ქოლგა"),
            keywords: &["პლაჟი", "პლაჟი და ქოლგა", "ქოლგა"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("жағажайда шатырмен"),
            keywords: &["жағажай", "жағажайда шатырмен", "қол шатыр"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("strand med parasol"),
            keywords: &["parasol", "strand", "strand med parasol"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ឆ\u{17d0}ត\u{17d2}របើកនៅលើឆ\u{17d2}នេរខ\u{17d2}សាច\u{17cb}"),
            keywords: &[
                "ឆ\u{17d0}ត\u{17d2}របើកនៅលើឆ\u{17d2}នេរខ\u{17d2}សាច\u{17cb}",
                "ឆ\u{17d2}នេរសម\u{17bb}ទ\u{17d2}រ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕೊಡ\u{cc6}ಯೊಂದ\u{cbf}ಗ\u{cc6} ಬೀಚ\u{ccd}"),
            keywords: &[
                "ಕೊಡ\u{cc6}",
                "ಕೊಡ\u{cc6}ಯೊಂದ\u{cbf}ಗ\u{cc6} ಬೀಚ\u{ccd}",
                "ಬೀಚ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("파라솔이 있는 해변"),
            keywords: &["파라솔", "파라솔이 있는 해변", "해변"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("बिचाच\u{947}र सत\u{94d}री आसा"),
            keywords: &["बिचाच\u{947}र सत\u{94d}री आसा", "बीच", "सत\u{94d}री"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("жээктеги чатыр"),
            keywords: &["жээк", "жээктеги чатыр", "чатыр"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Plage mat Sonneprabbeli"),
            keywords: &["Plage", "Plage mat Sonneprabbeli", "Prabbeli"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຫາດຊາຍກ\u{eb1}ບຄ\u{eb1}ນຮ\u{ebb}\u{ec8}ມ"),
            keywords: &[
                "ຄ\u{eb1}ນຮ\u{ebb}\u{ec8}ມ",
                "ຫາດຊາຍ",
                "ຫາດຊາຍກ\u{eb1}ບຄ\u{eb1}ນຮ\u{ebb}\u{ec8}ມ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("paplūdimys ir skėtis"),
            keywords: &["paplūdimys", "paplūdimys ir skėtis", "skėtis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("pludmale ar saulessargu"),
            keywords: &["pludmale", "pludmale ar saulessargu", "saulessargs"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("onepū me te hāmarara"),
            keywords: &["hāmarara", "onepū", "onepū me te hāmarara"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("плажа со чадор за сонце"),
            keywords: &["плажа", "плажа со чадор за сонце", "чадор"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ക\u{d41}ടയ\u{d41}ള\u{d4d}ള ബീച\u{d4d}ച\u{d4d}"),
            keywords: &[
                "കടൽ",
                "കടൽത\u{d4d}തീരം",
                "ക\u{d41}ട",
                "ക\u{d41}ടയ\u{d41}ള\u{d4d}ള ബീച\u{d4d}ച\u{d4d}",
                "ബീച\u{d4d}ച\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("далайн эрэг"),
            keywords: &["далай", "далайн эрэг", "шүхэр", "элс", "эрэг"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("छत\u{94d}र\u{94d}या\u{902}सह सम\u{941}द\u{94d}रकिनारा"),
            keywords: &[
                "छत\u{94d}री",
                "छत\u{94d}रीसह सम\u{941}द\u{94d}रकिनारा",
                "छत\u{94d}र\u{94d}या\u{902}सह सम\u{941}द\u{94d}रकिनारा",
                "सम\u{941}द\u{94d}रकिनारा",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("pantai dengan payung"),
            keywords: &["pantai", "pantai dengan payung", "payung"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("bajja b’umbrella"),
            keywords: &["bajja", "bajja b’umbrella", "umbrella"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ကမ\u{103a}းခြေန\u{103e}င\u{1037}\u{103a} ထ\u{102e}း"),
            keywords: &[
                "ကမ\u{103a}းခြေ",
                "ကမ\u{103a}းခြေန\u{103e}င\u{1037}\u{103a} ထ\u{102e}း",
                "ထ\u{102e}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("strand med parasoll"),
            keywords: &["parasoll", "strand", "strand med parasoll"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("छाता राखिएको सम\u{941}द\u{94d}री किनारा"),
            keywords: &[
                "छाता",
                "छाता राखिएको सम\u{941}द\u{94d}री किनारा",
                "सम\u{941}द\u{94d}री किनारा",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("strand met parasol"),
            keywords: &["parasol", "strand", "strand met parasol"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("strand med parasoll"),
            keywords: &["parasoll", "strand", "strand med parasoll"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଛତ\u{b3e} ସହ\u{b3f}ତ ବେଳ\u{b3e}ଭ\u{b42}ମ\u{b3f}"),
            keywords: &[
                "ଛତ\u{b3e}",
                "ଛତ\u{b3e} ସହ ବେଳ\u{b3e}ଭ\u{b42}ମ\u{b3f}",
                "ଛତ\u{b3e} ସହ\u{b3f}ତ ବେଳ\u{b3e}ଭ\u{b42}ମ\u{b3f}",
                "ବେଳ\u{b3e}ଭ\u{b42}ମ\u{b3f}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਛ\u{a71}ਤਰੀ ਨਾਲ ਸਮ\u{a41}\u{a70}ਦਰੀ ਕਿਨਾਰਾ"),
            keywords: &[
                "ਛ\u{a71}ਤਰੀ",
                "ਛ\u{a71}ਤਰੀ ਨਾਲ ਸਮ\u{a41}\u{a70}ਦਰੀ ਕਿਨਾਰਾ",
                "ਬੀਚ",
                "ਸਮ\u{a41}\u{a70}ਦਰੀ ਕਿਨਾਰਾ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("چھتری نال ساحل سمندر"),
            keywords: &["ساحل سمندر", "چھتری", "چھتری نال ساحل سمندر"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Bich Wit Ọ\u{301}mbrẹ\u{301}la"),
            keywords: &[
                "Bich",
                "Bich Wit Ọ\u{301}mbrẹ\u{301}la",
                "Bich Wít Ọ\u{301}mbrẹ\u{301}la",
                "Ọ\u{301}mbrẹ\u{301}la",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("parasol na plaży"),
            keywords: &["morze", "parasol", "parasol na plaży", "piasek", "plaża"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ساحل د چتری سره"),
            keywords: &["ساحل د چتری سره", "ساحل، ساحل د چترۍ سره، چترۍ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("praia e guarda-sol"),
            keywords: &["guarda-sol", "praia", "praia e guarda-sol"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("praia com guarda-sol"),
            keywords: &["guarda-sol", "praia", "praia com guarda-sol"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("maqya paqa achiwawan"),
            keywords: &["maqya", "maqya paqa achiwawan", "para achiwa"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("umbrelă pe plajă"),
            keywords: &["plajă", "umbrelă", "umbrelă pe plajă"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-406"),
            keywords: &["E10-406"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("пляж"),
            keywords: &["зонт", "море", "пляж"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ahantu ku mucanga hari umutaka"),
            keywords: &["ahantu ku mucanga hari umutaka", "ku mucanga", "umutaka"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڇٽي سان سامونڊي ڪناري"),
            keywords: &["سامونڊي ڪناري، ڇٽي", "ڇٽي سان سامونڊي ڪناري"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ක\u{dd4}ඩය හ\u{dcf} ම\u{dd4}හ\u{dd4}ද"),
            keywords: &[
                "ක\u{dd4}ඩය",
                "ක\u{dd4}ඩය හ\u{dcf} ම\u{dd4}හ\u{dd4}ද",
                "වෙරළ",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("pláž so slnečníkom"),
            keywords: &["pláž", "pláž so slnečníkom", "slnečník"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("plaža s senčnikom"),
            keywords: &["plaža", "plaža s senčnikom", "senčnik"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("dallad kula xeeb qaadashada"),
            keywords: &["dallad", "dallad kula xeeb qaadashada", "xeeb"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("plazh me çadër"),
            keywords: &["plazh", "plazh me çadër", "çadër"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("плажа са сунцобраном"),
            keywords: &["плaжa", "плажа са сунцобраном", "сунцoбрaн"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("plaža sa suncobranom"),
            keywords: &["plaža", "plaža sa suncobranom", "suncobran"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("strand med parasoll"),
            keywords: &["parasoll", "strand", "strand med parasoll"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("ufuo na mwavuli"),
            keywords: &["mwavuli", "ufuo", "ufuo na mwavuli"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("கடற\u{bcd}கரையில\u{bcd} குடையுடன\u{bcd}"),
            keywords: &[
                "கடற\u{bcd}கரை",
                "கடற\u{bcd}கரையில\u{bcd} குடையுடன\u{bcd}",
                "குடை",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("గ\u{c4a}డుగు ఉన\u{c4d}న సముద\u{c4d}ర త\u{c40}రం"),
            keywords: &[
                "గ\u{c4a}డుగు",
                "గ\u{c4a}డుగు ఉన\u{c4d}న సముద\u{c4d}ర త\u{c40}రం",
                "సముద\u{c4d}రత\u{c40}రం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("соҳил бо чатр"),
            keywords: &["соҳил", "соҳил бо чатр", "чатр"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ร\u{e48}มชายหาด"),
            keywords: &["ชายหาด", "ร\u{e48}ม", "ร\u{e48}มชายหาด"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("saýawanly kenar"),
            keywords: &["kenar", "saýawan", "saýawanly kenar"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("matātahi moe fakamalu"),
            keywords: &["matātahi moe fakamalu"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("plaj ve şemsiye"),
            keywords: &["kumsal", "plaj", "plaj ve şemsiye", "şemsiye"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("قىرغاق ۋە كۈنلۈك"),
            keywords: &["قىرغاق", "قىرغاق ۋە كۈنلۈك", "كۈنلۈك"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("пляж і парасолька"),
            keywords: &["парасоля", "пляж", "пляж і парасолька"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ساحل اور چھتری"),
            keywords: &["ساحل", "ساحل اور چھتری", "چھتری"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("qirg‘oq va soyabon"),
            keywords: &["qirg‘oq", "qirg‘oq va soyabon", "soyabon"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("bãi biển với chiếc ô"),
            keywords: &["bãi biển", "bãi biển với chiếc ô", "ô"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("tefes ak parasol"),
            keywords: &["parasol", "tefes", "tefes ak parasol"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("unxweme kunye nesambreli"),
            keywords: &["isambreli", "unxweme", "unxweme kunye nesambreli"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("ọ\u{300}sà pẹ\u{300}lú agbòrùn"),
            keywords: &["agbòrùn", "ọ\u{300}sà", "ọ\u{300}sà pẹ\u{300}lú agbòrùn"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("海灘同遮"),
            keywords: &["海灘", "海灘同遮", "遮"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("海滩同遮"),
            keywords: &["海滩", "海滩同遮", "遮"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("沙滩伞"),
            keywords: &["伞", "沙滩", "沙滩伞"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("海灘陽傘"),
            keywords: &["海灘", "海灘陽傘"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ibhishi nesambulela"),
            keywords: &["ibhishi", "ibhishi nesambulela", "isambulela"],
        },
    ],
};
#[doc = "🏜\u{fe0f}"]
pub const DESERT: crate::Emoji = crate::Emoji {
    glyph: "🏜\u{fe0f}",
    codepoint: "1F3DC FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.7f32,
    name: "desert",
    group: "Travel & Places",
    subgroup: "place-geographic",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🏜",
        codepoint: "1F3DC",
        status: crate::Status::Unqualified,
        introduction_version: 0.7f32,
        name: "desert",
        group: "Travel & Places",
        subgroup: "place-geographic",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("woestyn"),
            keywords: &["kaktus", "woestyn"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("በርሃ"),
            keywords: &["በርሃ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("صحراء"),
            keywords: &["بادية", "صحراء"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("মৰ\u{9c1}ভ\u{9c2}মি"),
            keywords: &["মৰ\u{9c1}ভ\u{9c2}মি"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("səhra"),
            keywords: &["səhra"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("пустыня"),
            keywords: &["пустыня"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("пустиня"),
            keywords: &["пустиня"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("মর\u{9c1}ভ\u{9c1}মি"),
            keywords: &["মর\u{9c1}ভ\u{9c1}মি"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("dezerzh"),
            keywords: &["dezerzh"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("pustinja"),
            keywords: &["pustinja"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("desert"),
            keywords: &["desert", "desèrtic"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎢᎪᏛ"),
            keywords: &["ᎢᎪᏛ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("poušť"),
            keywords: &["poušť"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("anialwch"),
            keywords: &["anialwch"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("ørken"),
            keywords: &["kaktus", "sol", "ørken"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Wüste"),
            keywords: &["Wüste"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("έρημος"),
            keywords: &["έρημος"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("desert"),
            keywords: &["desert"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("desierto"),
            keywords: &["arena", "desierto"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["arena", "desierto"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["arena", "desierto", "seco", "sequía"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kõrb"),
            keywords: &["kõrb"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("basamortua"),
            keywords: &["basamortu", "basamortua"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("بیابان"),
            keywords: &["بیابان", "کویر"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("autiomaa"),
            keywords: &["aavikko", "autiomaa", "kaktus"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("disyerto"),
            keywords: &["cactus", "disyerto", "mainit"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("oyðimørk"),
            keywords: &["oyðimørk"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("désert"),
            keywords: &["désert"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("fásach"),
            keywords: &["fásach"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("fàsach"),
            keywords: &["fàsach"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("deserto"),
            keywords: &["deserto"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("રણ"),
            keywords: &["રણ", "રણપ\u{acd}રદ\u{ac7}શ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("hamada"),
            keywords: &["hamada"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("מדבר"),
            keywords: &["חם", "יבש", "מדבר", "קקטוס"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("र\u{947}गिस\u{94d}तान, मर\u{941}स\u{94d}थल"),
            keywords: &[
                "मर\u{941}स\u{94d}थल",
                "र\u{947}गिस\u{94d}तान",
                "र\u{947}गिस\u{94d}तान, मर\u{941}स\u{94d}थल",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("pustinja"),
            keywords: &["pustinja"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("sivatag"),
            keywords: &["kaktusz", "sivatag"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("անապատ"),
            keywords: &["անապատ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("gurun"),
            keywords: &["gurun"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ọ\u{300}zàrà"),
            keywords: &["ọ\u{300}zàrà"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("eyðimörk"),
            keywords: &["eyðimörk"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("deserto"),
            keywords: &["arido", "caldo", "deserto", "sole cocente"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("砂漠"),
            keywords: &["サボテン", "サボテンのある砂漠", "砂漠"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("ara-ara"),
            keywords: &["ara-ara"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("უდაბნო"),
            keywords: &["უდაბნო"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("aneẓruf"),
            keywords: &["aneẓruf"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("шөл"),
            keywords: &["шөл"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("ørken"),
            keywords: &["kaktus", "sol", "ørken"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("វាលខ\u{17d2}សាច\u{17cb}"),
            keywords: &[
                "វាលខ\u{17d2}សាច\u{17cb}",
                "សម\u{17bb}ទ\u{17d2}រខ\u{17d2}សាច\u{17cb}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಮರುಭ\u{cc2}ಮ\u{cbf}"),
            keywords: &["ಮರುಭ\u{cc2}ಮ\u{cbf}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("사막"),
            keywords: &["사막", "선인장", "태양"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("वाळव\u{902}ट"),
            keywords: &["वाळव\u{902}ट"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("чөл"),
            keywords: &["чөл"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Wüst"),
            keywords: &["Wüst"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ທະເລຊາຍ"),
            keywords: &["ທະເລຊາຍ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("dykuma"),
            keywords: &["dykuma"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("tuksnesis"),
            keywords: &["tuksnesis"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kōraha"),
            keywords: &["kōraha"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("пустина"),
            keywords: &["пустина"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("മര\u{d41}ഭ\u{d42}മി"),
            keywords: &["മര\u{d41}ഭ\u{d42}മി"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("цөл"),
            keywords: &["кактус", "цөл", "элс"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("वाळव\u{902}ट"),
            keywords: &["वाळव\u{902}ट"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("padang pasir"),
            keywords: &["padang pasir"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("deżert"),
            keywords: &["deżert"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("သ\u{1032}ကန\u{103a}တာရ"),
            keywords: &["သ\u{1032}ကန\u{103a}တာရ"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("ørken"),
            keywords: &["ørken"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("मर\u{942}भ\u{942}मि"),
            keywords: &["मर\u{942}भ\u{942}मि"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("woestijn"),
            keywords: &["woestijn"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("ørken"),
            keywords: &["ørken"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ମର\u{b41}ଭ\u{b42}ମ\u{b3f}"),
            keywords: &["ମର\u{b41}ଭ\u{b42}ମ\u{b3f}"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਮਾਰ\u{a42}ਥਲ"),
            keywords: &["ਮਾਰ\u{a42}ਥਲ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("صحرا"),
            keywords: &["صحرا"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Dẹ\u{301}zat"),
            keywords: &["Dẹ\u{301}zat"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("pustynia"),
            keywords: &["pustynia"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("دښته"),
            keywords: &["دښته"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("deserto"),
            keywords: &["deserto"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["areia", "cato", "deserto"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("purum"),
            keywords: &["purum"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("deșert"),
            keywords: &["deșert", "nisip"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-412"),
            keywords: &["E10-412"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("пустыня"),
            keywords: &["кактус", "песок", "пустыня", "солнце"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ubutayu"),
            keywords: &["ubutayu"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ريگستاني"),
            keywords: &["ريگستاني"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ක\u{dcf}න\u{dca}ත\u{dcf}රය"),
            keywords: &["ක\u{dcf}න\u{dca}ත\u{dcf}රය"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("púšť"),
            keywords: &["pustatina", "púšť"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("puščava"),
            keywords: &["puščava"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("lamadegaan"),
            keywords: &["lamadegaan"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("shkretëtirë"),
            keywords: &["shkretëtirë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("пустиња"),
            keywords: &["пустињa", "пустиња"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["пустиња"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("pustinja"),
            keywords: &["pustinja"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["pustinja"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("öken"),
            keywords: &["torrt", "varmt", "öken"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("jangwa"),
            keywords: &["jangwa"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ப\u{bbe}லைவனம\u{bcd}"),
            keywords: &["ப\u{bbe}லைவனம\u{bcd}", "வறட\u{bcd}சி"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ఎడ\u{c3e}ర\u{c3f}"),
            keywords: &["ఎడ\u{c3e}ర\u{c3f}"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("биёбон"),
            keywords: &["биёбон"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ทะเลทราย"),
            keywords: &["ทะเลทราย"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("çöl"),
            keywords: &["çöl"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("toafa"),
            keywords: &["toafa"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("çöl"),
            keywords: &["çöl"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("قۇملۇق"),
            keywords: &["قۇملۇق"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("пустеля"),
            keywords: &["пустеля"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("صحرا"),
            keywords: &["بیابان", "ریگستان", "صحرا"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("sahro"),
            keywords: &["sahro"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("sa mạc"),
            keywords: &["sa mạc"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("desert"),
            keywords: &["desert"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("intlango"),
            keywords: &["intlango"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("aṣálẹ\u{300}"),
            keywords: &["aṣálẹ\u{300}"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("沙漠"),
            keywords: &["沙漠"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("沙漠"),
            keywords: &["沙漠"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("沙漠"),
            keywords: &["沙漠", "荒漠"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("沙漠"),
            keywords: &["沙漠"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ugwadule"),
            keywords: &["isiqhingi", "ugwadule"],
        },
    ],
};
#[doc = "🏝\u{fe0f}"]
pub const DESERT_ISLAND: crate::Emoji = crate::Emoji {
    glyph: "🏝\u{fe0f}",
    codepoint: "1F3DD FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.7f32,
    name: "desert island",
    group: "Travel & Places",
    subgroup: "place-geographic",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🏝",
        codepoint: "1F3DD",
        status: crate::Status::Unqualified,
        introduction_version: 0.7f32,
        name: "desert island",
        group: "Travel & Places",
        subgroup: "place-geographic",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("woestyneiland"),
            keywords: &["eiland", "palm", "woestyn", "woestyneiland"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የበርሃ ደሴት"),
            keywords: &["በርሃ", "የበርሃ ደሴት", "ደሴት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("جزيرة صحراوية"),
            keywords: &["جزيرة", "جزيرة صحراوية", "صحراء"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("মৰ\u{9c1}ভ\u{9c2}মি দ\u{9cd}বীপ"),
            keywords: &["দ\u{9cd}বীপ", "মৰ\u{9c1}ভ\u{9c2}মি"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("tənha ada"),
            keywords: &["ada", "səhra", "tənha ada"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("ненаселены востраў"),
            keywords: &["бязлюдны", "востраў", "ненаселены"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("необитаем остров"),
            keywords: &["необитаем", "остров"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("মর\u{9c1}ভ\u{9c2}মির দ\u{9cd}বীপ"),
            keywords: &[
                "দ\u{9cd}বীপ",
                "মর\u{9c1}ভ\u{9c2}মি",
                "মর\u{9c1}ভ\u{9c2}মির দ\u{9cd}বীপ",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("enezenn didud"),
            keywords: &["didud", "enezenn"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("pusti otok"),
            keywords: &["otok", "pusti otok", "pustinja"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("illa deserta"),
            keywords: &["deserta", "illa"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎢᎪᏛ ᎤᎦᏚᏛᎢ"),
            keywords: &["ᎢᎪᏛ", "ᎤᎦᏚᏛᎢ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("pustý ostrov"),
            keywords: &[
                "opuštěný",
                "ostrov",
                "palma",
                "pláž",
                "poušť",
                "pustý ostrov",
                "tropický",
                "tropy",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("ynys anghyfannedd"),
            keywords: &["anghyfannedd", "ynys"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("øde ø"),
            keywords: &["ø", "øde"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("einsame Insel"),
            keywords: &[
                "Insel",
                "Meer",
                "Strand",
                "einsam",
                "einsame Insel",
                "verlassen",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ερημονήσι"),
            keywords: &["έρημο", "ερημονήσι", "νησί"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("desert island"),
            keywords: &["desert", "island"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("isla desierta"),
            keywords: &["desierta", "isla"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["isla", "isla desierta"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("asustamata saar"),
            keywords: &["asustamata", "saar"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("uharte bakartia"),
            keywords: &["basamortu", "uharte", "uharte bakartia"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("جزیره\u{654} خالی از سکنه"),
            keywords: &["بدون سکنه", "جزیره", "جزیره\u{654} خالی از سکنه", "متروکه"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("autiosaari"),
            keywords: &["autio", "autiosaari", "saari"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("islang walang nakatira"),
            keywords: &[
                "desert island",
                "isla",
                "islang walang nakatira",
                "walang nakatira",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("oyðin oyggj"),
            keywords: &["oyggj", "oyðin", "plámatræ"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("île déserte"),
            keywords: &["île", "île déserte"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["déserte", "île"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("oileán díthreibhe"),
            keywords: &["fásach", "oileán", "oileán díthreibhe"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("eilean fàs"),
            keywords: &["eilean", "eilean fàs", "fàsach"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("illa deserta"),
            keywords: &["deserta", "illa"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("રણમા\u{a82} દ\u{acd}વિપ"),
            keywords: &[
                "આઇલ\u{ac7}ન\u{acd}ડ",
                "દ\u{acd}વિપ",
                "રણમા\u{a82} દ\u{acd}વિપ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("tsibirin hamada"),
            keywords: &["hamada", "tsibiri", "tsibirin hamada"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("אי בודד"),
            keywords: &["אי בודד", "ים"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("र\u{947}गिस\u{94d}तान म\u{947}\u{902} द\u{94d}वीप, द\u{94d}वीप"),
            keywords: &[
                "द\u{94d}वीप",
                "र\u{947}गिस\u{94d}तान म\u{947}\u{902} द\u{94d}वीप",
                "र\u{947}गिस\u{94d}तान म\u{947}\u{902} द\u{94d}वीप, द\u{94d}वीप",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("pusti otok"),
            keywords: &["otok", "pusti otok", "pusto"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("lakatlan sziget"),
            keywords: &["lakatlan sziget", "sivatag", "sziget"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("անմարդաբնակ կղզի"),
            keywords: &["անմարդաբնակ", "կղզի"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("pulau terpencil"),
            keywords: &["gurun", "pulau", "pulau terpencil"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("àgwaetiti ọ\u{300}zàrà"),
            keywords: &["àgwaetiti", "ọ\u{300}zàrà"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("eyðieyja"),
            keywords: &["eyja", "eyðieyja", "eyðimörk"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("isola deserta"),
            keywords: &["isola deserta", "naufrago", "solitudine"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("無人島"),
            keywords: &["ヤシ", "ヤシの木のある島", "島", "無人島"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("pulo ara-ara"),
            keywords: &["ara-ara", "pulo"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("უკაცრიელი კუნძული"),
            keywords: &["კუნძული", "უკაცრიელი"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("tigzirt taneẓruft"),
            keywords: &["tigzirt taneẓruft"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("шөлді арал"),
            keywords: &["арал", "шөл", "шөлді арал"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("øde ø"),
            keywords: &["ø", "øde"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("កោះដាច\u{17cb}ស\u{17d2}រយាល"),
            keywords: &["កោះ", "កោះដាច\u{17cb}ស\u{17d2}រយាល"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಮರಳುಗಾಡು ದ\u{ccd}ವೀಪ"),
            keywords: &["ದ\u{ccd}ವೀಪ", "ಮರಳುಗಾಡು"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("사막 섬"),
            keywords: &["사막", "섬"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("वाळव\u{902}टीय ज\u{941}व\u{947}\u{902}"),
            keywords: &[
                "ज\u{941}व\u{947}\u{902}",
                "वाळव\u{902}ट",
                "वाळव\u{902}टीय ज\u{941}व\u{947}\u{902}",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("чөл аралы"),
            keywords: &["арал", "чөл", "чөл аралы"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Wüsteninsel"),
            keywords: &["Insel", "Wüst", "Wüsteninsel"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເກາະທະເລຊາຍ"),
            keywords: &["ທະເລຊາຍ", "ເກາະ", "ເກາະທະເລຊາຍ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("atoki sala"),
            keywords: &["atoki sala", "dykuma", "sala"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("vientuļa sala"),
            keywords: &["sala", "vientuļa sala", "vientuļš"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("motu kōraha"),
            keywords: &["kōraha", "motu"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("пуст остров"),
            keywords: &["остров", "пуст"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("മര\u{d41}ദ\u{d4d}വീപ\u{d4d}"),
            keywords: &[
                "ദ\u{d4d}വീപ\u{d4d}",
                "മര\u{d41}ദ\u{d4d}വീപ\u{d4d}",
                "മര\u{d41}പ\u{d4d}പച\u{d4d}ച",
                "മര\u{d41}ഭ\u{d42}മി",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("арал"),
            keywords: &["арал", "цөл"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("वाळव\u{902}ट असल\u{947}ल\u{947} ब\u{947}ट"),
            keywords: &[
                "ब\u{947}ट",
                "वाळव\u{902}ट",
                "वाळव\u{902}ट असल\u{947}ल\u{947} ब\u{947}ट",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("pulau padang pasir"),
            keywords: &["padang pasir", "pulau", "pulau padang pasir"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("gżira deżert"),
            keywords: &["deżert", "gżira"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("လ\u{1030}သ\u{1030}မ\u{1032}\u{1037}ကျ\u{103d}န\u{103a}း"),
            keywords: &[
                "ကျ\u{103d}န\u{103a}း",
                "လ\u{1030}သ\u{1030}မ\u{1032}\u{1037}ကျ\u{103d}န\u{103a}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("øde øy"),
            keywords: &["øde", "øy"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("मर\u{942}भ\u{942}मि टाप\u{942}"),
            keywords: &["टाप\u{942}", "मर\u{942}भ\u{942}मि"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("onbewoond eiland"),
            keywords: &["eiland", "onbewoond"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("aude øy"),
            keywords: &["aude", "øy"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ମର\u{b41}ଭ\u{b42}ମ\u{b3f} ଦ\u{b4d}ୱୀପ"),
            keywords: &["ଦ\u{b4d}ୱୀପ", "ମର\u{b41}ଭ\u{b42}ମ\u{b3f}"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਮਾਰ\u{a42}\u{a42}ਥਲ ਟਾਪ\u{a42}"),
            keywords: &[
                "ਟਾਪ\u{a42}",
                "ਮਾਰ\u{a42}ਥਲ",
                "ਮਾਰ\u{a42}\u{a42}ਥਲ ਟਾਪ\u{a42}",
                "ਸਮ\u{a41}\u{a70}ਦਰੀ ਟਾਪ\u{a42}",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("صحرائی جزیرہ"),
            keywords: &["جزیرہ", "صحرا", "صحرائی جزیرہ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Dẹ\u{301}zát Aíland"),
            keywords: &["Aíland", "Dẹ\u{301}zat", "Dẹ\u{301}zát Aíland"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("bezludna wyspa"),
            keywords: &["bezludna", "pusta", "pustynia", "samotna", "wyspa"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("دښتې ټاپو"),
            keywords: &["دښته، ټاپو", "دښتې ټاپو"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("ilha deserta"),
            keywords: &["ilha", "ilha deserta"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["deserta", "ilha"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("purum wat’a"),
            keywords: &["purum", "wat’a"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("insulă pustie"),
            keywords: &["insulă", "insulă pustie", "pustiu"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-413"),
            keywords: &["E10-413"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("остров"),
            keywords: &["необитаемый", "остров", "пальма", "пустыня"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ikirwa cy’ubutayu"),
            keywords: &["ikirwa", "ikirwa cy’ubutayu", "ubutayu"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ريگستاني ٻيٽ"),
            keywords: &["ريگستان، ٻيٽ", "ريگستاني ٻيٽ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ක\u{dcf}න\u{dca}ත\u{dcf}ර ද\u{dd6}පත"),
            keywords: &[
                "ක\u{dcf}න\u{dca}ත\u{dcf}ර ද\u{dd6}පත",
                "ක\u{dcf}න\u{dca}ත\u{dcf}රය",
                "ද\u{dd6}පත",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("opustený ostrov"),
            keywords: &["opustený", "ostrov"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("samotni otok"),
            keywords: &["otok", "puščava", "samotni otok"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("jasiirad lamadegaan ah"),
            keywords: &["jasiirad lamadegaan ah", "lamadegaan"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("ishull shkretëtirë"),
            keywords: &["ishull", "shkretëtirë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("пусто острво"),
            keywords: &["острво", "пустo", "пусто острво"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["пусто острво"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("pusto ostrvo"),
            keywords: &["ostrvo", "pusto"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["pusto ostrvo"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("öde ö"),
            keywords: &["ö", "öde"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kisiwa cha jangwa"),
            keywords: &["jangwa", "kisiwa", "kisiwa cha jangwa"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ப\u{bbe}லைவனத\u{bcd} த\u{bc0}வு"),
            keywords: &["ப\u{bbe}லைவனத\u{bcd} த\u{bc0}வு", "ப\u{bbe}லைவனம\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ఎడ\u{c3e}ర\u{c3f} ద\u{c4d}వ\u{c40}పం"),
            keywords: &["ఎడ\u{c3e}ర\u{c3f}", "ద\u{c4d}వ\u{c40}పం"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("ҷазираи биёбон"),
            keywords: &["биёбон", "ҷазира", "ҷазираи биёбон"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เกาะ"),
            keywords: &["เกาะ", "เกาะร\u{e49}าง"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("çölli ada"),
            keywords: &["ada", "çöl", "çölli ada"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("motu liʻekina"),
            keywords: &["motu liʻekina"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("ıssız ada"),
            keywords: &["ada", "çöl", "ıssız ada"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("قۇملۇق ئارال"),
            keywords: &["ئارال", "قۇملۇق"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("безлюдний острів"),
            keywords: &["безлюдний", "острів"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("صحرائی جزیرہ"),
            keywords: &["جزیرہ", "صحرا", "صحرائی جزیرہ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("cho‘l orol"),
            keywords: &["cho‘l", "orol"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("đảo hoang"),
            keywords: &["hoang", "đảo"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("desert dun"),
            keywords: &["desert", "dun"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("isiqithi sentlango"),
            keywords: &["intlango", "isiqithi", "isiqithi sentlango"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("erékùṣù aṣálẹ\u{300}"),
            keywords: &["aṣálẹ\u{300}", "erékùṣù"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("荒島"),
            keywords: &["島", "沙漠", "荒島"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("荒岛"),
            keywords: &["岛", "沙漠", "荒岛"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("无人荒岛"),
            keywords: &["无人荒岛", "荒岛"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("熱帶小島"),
            keywords: &["沙灘小島", "熱帶小島"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("荒島"),
            keywords: &["荒島"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("isiqhingi sasogwadule"),
            keywords: &["isiqhingi", "isiqhingi sasogwadule", "ugwadule"],
        },
    ],
};
#[doc = "🏞\u{fe0f}"]
pub const NATIONAL_PARK: crate::Emoji = crate::Emoji {
    glyph: "🏞\u{fe0f}",
    codepoint: "1F3DE FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.7f32,
    name: "national park",
    group: "Travel & Places",
    subgroup: "place-geographic",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🏞",
        codepoint: "1F3DE",
        status: crate::Status::Unqualified,
        introduction_version: 0.7f32,
        name: "national park",
        group: "Travel & Places",
        subgroup: "place-geographic",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("nasionale park"),
            keywords: &["nasionale park", "park", "reservaat", "wildtuin"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ብሔራዊ ፖርክ"),
            keywords: &["ብሔራዊ ፖርክ", "ፖርክ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("حديقة وطنية"),
            keywords: &["حديقة وطنية", "متنزه"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ৰ\u{9be}ষ\u{9cd}ট\u{9cd}ৰীয\u{9bc} উদ\u{9cd}য\u{9be}ন"),
            keywords: &[
                "উদ\u{9cd}য\u{9be}ন",
                "ৰ\u{9be}ষ\u{9cd}ট\u{9cd}ৰীয\u{9bc} উদ\u{9cd}য\u{9be}ন",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("milli park"),
            keywords: &["milli park", "park"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("нацыянальны парк"),
            keywords: &["нацыянальны парк", "парк"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("национален парк"),
            keywords: &["национален парк", "парк"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("জ\u{9be}তীয\u{9bc} উদ\u{9cd}য\u{9be}ন"),
            keywords: &["জ\u{9be}তীয\u{9bc} উদ\u{9cd}য\u{9be}ন", "প\u{9be}র\u{9cd}ক"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("park broadel"),
            keywords: &["park", "park broadel"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("nacionalni park"),
            keywords: &["nacionalni park", "park"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("parc nacional"),
            keywords: &["nacional", "parc"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎢᎬᎾᏕᎾ ᎠᏰᎵ ᎡᏓᏍᏗᎢ"),
            keywords: &["ᎠᏰᎵ ᎡᏓᏍᏗᎢ", "ᎢᎬᎾᏕᎾ ᎠᏰᎵ ᎡᏓᏍᏗᎢ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("národní park"),
            keywords: &["národní park", "park", "rezervace"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("parc cenedlaethol"),
            keywords: &["parc", "parc cenedlaethol"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("nationalpark"),
            keywords: &["nationalpark", "park"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Nationalpark"),
            keywords: &["Nationalpark", "Park"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("εθνικό πάρκο"),
            keywords: &["εθνικό πάρκο", "πάρκο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("national park"),
            keywords: &["national park", "park"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("parque nacional"),
            keywords: &["nacional", "parque"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["atracción", "parque", "parque nacional", "vacaciones"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &[
                "atracción",
                "naturaleza",
                "parque",
                "parque nacional",
                "vacaciones",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("rahvuspark"),
            keywords: &["park", "rahvuspark"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("parke nazionala"),
            keywords: &["parke", "parke nazionala"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("پارک ملی"),
            keywords: &["پارک", "پارک ملی"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kansallispuisto"),
            keywords: &["kansallispuisto", "puisto"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("national park"),
            keywords: &["national park", "parke"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("tjóðarpark"),
            keywords: &["friðað øki", "park", "tjóðarpark", "tjóðgarður", "tjóðlund"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("parc national"),
            keywords: &["nature", "parc national"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["national", "parc"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("páirc náisiúnta"),
            keywords: &["páirc", "páirc náisiúnta"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("pàirc nàiseanta"),
            keywords: &["pàirc", "pàirc nàiseanta"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("parque nacional"),
            keywords: &["parque", "parque nacional"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("રાષ\u{acd}ટ\u{acd}રીય ઉદ\u{acd}યાન"),
            keywords: &["પાર\u{acd}ક", "બગીચો", "રાષ\u{acd}ટ\u{acd}રીય ઉદ\u{acd}યાન"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("gandun daji na ƙasa"),
            keywords: &["gandu", "gandun daji na ƙasa"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("שמורת טבע"),
            keywords: &["טבע", "טיול", "פארק", "שמורת טבע"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("राष\u{94d}ट\u{94d}रीय उद\u{94d}यान"),
            keywords: &[
                "उद\u{94d}यान",
                "बगीचा",
                "राष\u{94d}ट\u{94d}रीय उद\u{94d}यान",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("nacionalni park"),
            keywords: &["nacionalni park", "park"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("nemzeti park"),
            keywords: &["nemzeti park", "park", "védett terület"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ազգային պարկ"),
            keywords: &["ազգային պարկ", "պարկ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("taman nasional"),
            keywords: &["taman", "taman nasional"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ọdụ\u{300} obodo"),
            keywords: &["ọdụ\u{300}", "ọdụ\u{300} obodo"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("þjóðgarður"),
            keywords: &["garður", "þjóðgarður"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("parco nazionale"),
            keywords: &["escursione", "natura", "parco nazionale"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("国立公園"),
            keywords: &["公園", "国立公園", "自然"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("taman nasional"),
            keywords: &["taman", "taman nasional"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ეროვნული პარკი"),
            keywords: &["ეროვნული პარკი", "პარკი"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("amṛaḥ aɣelnaw"),
            keywords: &["amṛaḥ aɣelnaw"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("ұлттық парк"),
            keywords: &["парк", "ұлттық парк"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("nationalpark"),
            keywords: &["nationalpark"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ឧទ\u{17d2}យានជាត\u{17b7}"),
            keywords: &[
                "កន\u{17d2}លែងកម\u{17d2}សាន\u{17d2}ត",
                "ឧទ\u{17d2}យាន",
                "ឧទ\u{17d2}យានជាត\u{17b7}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ರಾಷ\u{ccd}ಟ\u{ccd}ರೀಯ ಉದ\u{ccd}ಯಾನ"),
            keywords: &["ಉದ\u{ccd}ಯಾನ", "ರಾಷ\u{ccd}ಟ\u{ccd}ರೀಯ ಉದ\u{ccd}ಯಾನ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("국립공원"),
            keywords: &["공원", "국립", "국립공원"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("राष\u{94d}ट\u{94d}रीय उद\u{94d}यान"),
            keywords: &["उद\u{94d}यान", "राष\u{94d}ट\u{94d}रीय उद\u{94d}यान"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("улуттук сейилбак"),
            keywords: &["сейилбак", "улуттук сейилбак"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Nationalpark"),
            keywords: &["Nationalpark", "Park"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ປ\u{ec8}າສະຫງວນແຫ\u{ec8}ງຊາດ"),
            keywords: &[
                "ຕ\u{ebb}\u{ec9}ນໄມ\u{ec9}",
                "ປ\u{ec8}າສະຫງວນ",
                "ປ\u{ec8}າສະຫງວນແຫ\u{ec8}ງຊາດ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("nacionalinis parkas"),
            keywords: &["nacionalinis parkas", "parkas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("nacionālais parks"),
            keywords: &["daba", "nacionālais parks", "parks"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("papa rēhia ā-motu"),
            keywords: &["papa rēhia", "papa rēhia ā-motu"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("национален парк"),
            keywords: &["национален парк", "парк"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ദേശീയോദ\u{d4d}യ\u{d3e}നം"),
            keywords: &[
                "ഉദ\u{d4d}യ\u{d3e}നം",
                "ദേശീയോദ\u{d4d}യ\u{d3e}നം",
                "പ\u{d3e}ർക\u{d4d}ക\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("үндэсний цэцэрлэгт хүрээлэн"),
            keywords: &["ус", "үндэсний цэцэрлэгт хүрээлэн"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("राष\u{94d}ट\u{94d}रीय उद\u{94d}यान"),
            keywords: &["उद\u{94d}यान", "राष\u{94d}ट\u{94d}रीय उद\u{94d}यान"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("taman negara"),
            keywords: &["taman", "taman negara"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("park nazzjonali"),
            keywords: &["park", "park nazzjonali"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အမျ\u{102d}\u{102f}းသား ဥယျာဉ\u{103a}"),
            keywords: &["အမျ\u{102d}\u{102f}းသား ဥယျာဉ\u{103a}", "ဥယျာဥ\u{103a}"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("nasjonalpark"),
            keywords: &["nasjonalpark", "park"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("राष\u{94d}ट\u{94d}रिय निक\u{941}ञ\u{94d}ज"),
            keywords: &["पार\u{94d}क", "राष\u{94d}ट\u{94d}रिय निक\u{941}ञ\u{94d}ज"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("nationaal park"),
            keywords: &["nationaal park", "park"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("nasjonalpark"),
            keywords: &["nasjonalpark", "park"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଜ\u{b3e}ତୀୟ ଉଦ\u{b4d}ୟ\u{b3e}ନ"),
            keywords: &["ଉଦ\u{b4d}ୟ\u{b3e}ନ", "ଜ\u{b3e}ତୀୟ ଉଦ\u{b4d}ୟ\u{b3e}ନ"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਨ\u{a48}ਸ\u{a3c}ਨਲ ਪਾਰਕ"),
            keywords: &["ਨ\u{a48}ਸ\u{a3c}ਨਲ", "ਪਾਰਕ", "ਬਗੀਚਾ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("قومی پارک"),
            keywords: &["قومی پارک", "پارک"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Náshọ\u{301}nál Pak"),
            keywords: &["Náshọ\u{301}nál Pak", "Pak"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("park narodowy"),
            keywords: &["natura", "park", "park narodowy", "przyroda"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ملي پارک"),
            keywords: &["ملي پارک", "پارک"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("parque nacional"),
            keywords: &["parque", "parque com rio", "parque nacional", "rio"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("parque nacional"),
            keywords: &["parque", "parque nacional"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("nacional parque"),
            keywords: &["nacional parque", "parque"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("parc național"),
            keywords: &["parc", "parc național"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-414"),
            keywords: &["E10-414"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("национальный парк"),
            keywords: &["заповедник", "национальный парк", "парк", "природа"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("parike y’igihugu"),
            keywords: &["guparika", "parike y’igihugu"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("قومي پارڪ"),
            keywords: &["قومي پارڪ", "پارڪ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ජ\u{dcf}ත\u{dd2}ක උද\u{dca}\u{200d}ය\u{dcf}නය"),
            keywords: &[
                "උද\u{dca}\u{200d}ය\u{dcf}නය",
                "ජ\u{dcf}ත\u{dd2}ක උද\u{dca}\u{200d}ය\u{dcf}නය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("národný park"),
            keywords: &["národný park", "park", "rezervácia"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("nacionalni park"),
            keywords: &["nacionalni park", "park"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("carwo qaran"),
            keywords: &["carwo", "carwo qaran"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("park kombëtar"),
            keywords: &["park", "park kombëtar"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("национални парк"),
            keywords: &["национални парк", "пaрк"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("nacionalni park"),
            keywords: &["nacionalni park", "park"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("nationalpark"),
            keywords: &["nationalpark", "park"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mbuga ya taifa ya wanyama"),
            keywords: &["mbuga", "mbuga ya taifa ya wanyama"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("தேசியப\u{bcd} பூங\u{bcd}க\u{bbe}"),
            keywords: &["தேசியப\u{bcd} பூங\u{bcd}க\u{bbe}", "பூங\u{bcd}க\u{bbe}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("జ\u{c3e}త\u{c40}య ప\u{c3e}ర\u{c4d}క\u{c4d}"),
            keywords: &[
                "జ\u{c3e}త\u{c40}య ప\u{c3e}ర\u{c4d}క\u{c4d}",
                "ప\u{c3e}ర\u{c4d}క\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("парки миллӣ"),
            keywords: &["парк", "парки миллӣ"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("อ\u{e38}ทยาน"),
            keywords: &["อ\u{e38}ทยาน", "อ\u{e38}ทยานแห\u{e48}งชาต\u{e34}"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("milli seýilgäh"),
            keywords: &["milli seýilgäh", "seýilgäh"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("paʻake fakafonua"),
            keywords: &["paʻake fakafonua"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("milli park"),
            keywords: &["milli park", "park", "ulusal park"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("دۆلەتلىك باغچا"),
            keywords: &["باغچا", "دۆلەتلىك باغچا"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("національний парк"),
            keywords: &["національний парк", "парк"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("نیشنل پارک"),
            keywords: &["نیشنل پارک", "پارک"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("istirohat bog‘i"),
            keywords: &["bog‘", "istirohat bog‘i", "park"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("công viên quốc gia"),
            keywords: &["công viên", "công viên quốc gia"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("park national"),
            keywords: &["park", "park national"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ipaki yelizwe"),
            keywords: &["ipaki", "ipaki yelizwe"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("páàkì orílẹ\u{300}"),
            keywords: &["páàkì", "páàkì orílẹ\u{300}"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("國家公園"),
            keywords: &["公園", "國家公園"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("国家公园"),
            keywords: &["公园", "国家公园"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("国家公园"),
            keywords: &["公园", "国家公园", "自然", "风景"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("國家公園"),
            keywords: &["公園", "國家公園"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ipaki likazwelonke"),
            keywords: &["ipaki", "ipaki likazwelonke"],
        },
    ],
};
