#[doc = "♈"]
pub const ARIES: crate::Emoji = crate::Emoji {
    glyph: "♈",
    codepoint: "2648",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "Aries",
    group: "Symbols",
    subgroup: "zodiac",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("Ram-sterrebeeld"),
            keywords: &["Ram-sterrebeeld", "diereriem", "ram"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ኤሪስ"),
            keywords: &["ኤሪስ", "ወንድ በግ", "ዞዲያክ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("الحمل"),
            keywords: &["الأبراج", "الحمل"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("মেষ ৰ\u{9be}শি"),
            keywords: &[
                "ভেড\u{9bc}\u{9be}",
                "মেষ ৰ\u{9be}শি",
                "ৰ\u{9be}শিচক\u{9cd}ৰ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("qoç bürcü"),
            keywords: &["qoç", "qoç bürcü", "zodiak"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("знак задыяка Авен"),
            keywords: &["авен", "задыяк", "знак задыяка Авен"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Зодиакален знак овен"),
            keywords: &[
                "Зодиакален знак овен",
                "зодиак",
                "зодиакален знак",
                "зодия",
                "овен",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("মেষ"),
            keywords: &["মেষ", "র\u{9be}শিচক\u{9cd}র"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("an Tourz"),
            keywords: &["Ari", "Tourz", "an Tourz", "zodiak"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("znak ovan"),
            keywords: &["horoskop", "znak", "znak ovan", "zodijak"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("Àries"),
            keywords: &["marrà", "zodíac", "Àries"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏓᎿᏩ"),
            keywords: &["ᎤᏃᏕᎾ ᏧᎧᏅᏍᏕᎾ", "ᏃᏈᏏ ᏓᏟᎶᏍᏛᎲᎢ", "ᏓᎿᏩ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("skopec"),
            keywords: &["beran", "skopec", "zvěrokruh"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("yr Hwrdd"),
            keywords: &["hwrdd", "sidydd", "yr Hwrdd"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("vædderen"),
            keywords: &["stjernetegn", "vædderen"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Widder (Sternzeichen)"),
            keywords: &["Sternzeichen", "Widder", "Widder (Sternzeichen)"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("Κριός"),
            keywords: &["Κριός", "ζώδιο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("Aries"),
            keywords: &["Aries", "ram", "zodiac"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("Aries"),
            keywords: &["Aries", "aries", "carnero", "zodiaco"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["Aries", "aries", "carnero", "zodíaco"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("Jäär"),
            keywords: &["Jäär", "sodiaak"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("aries"),
            keywords: &["aries", "zikiro", "zodiako"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("برج حمل"),
            keywords: &["برج", "حمل", "فروردین"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("oinas-merkki"),
            keywords: &["horoskooppi", "horoskooppimerkki", "oinas", "oinas-merkki"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("Aries"),
            keywords: &["Aries", "ram", "zodiac"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("Veðrurin"),
            keywords: &["Veðrurin", "stjørnumerki", "veðramerki", "veðrur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("bélier zodiaque"),
            keywords: &["bélier zodiaque", "zodiaque"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("Bélier zodiaque"),
            keywords: &["Bélier zodiaque", "bélier", "zodiaque"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("an Reithe"),
            keywords: &["Aries", "an Reithe", "stoidiaca"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("An Reithe"),
            keywords: &[
                "An Reithe",
                "aries",
                "grian-chrios",
                "grian-chriosach",
                "reithe",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("Aries"),
            keywords: &["Aries", "Ariete", "carneiro", "zodíaco"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("મ\u{ac7}ષ"),
            keywords: &["મ\u{ac7}ષ", "રાશિચક\u{acd}ર"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("Aries"),
            keywords: &["Aries", "rago", "zodiac"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("מזל טלה"),
            keywords: &["גלגל המזלות", "טלה", "מזל"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("म\u{947}ष"),
            keywords: &["म\u{947}ष", "म\u{947}ष, राशि", "राशि"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("astrološki znak ovna"),
            keywords: &["astrološki znak ovna", "ovan", "zodijak"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("kos csillagjegy"),
            keywords: &["horoszkóp", "kos", "kos csillagjegy"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("Խոյ"),
            keywords: &["Խոյ", "կենդանակերպ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("Aries"),
            keywords: &["Aries", "aries", "domba", "zodiak"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("Ariis"),
            keywords: &["Ariis", "zodịak", "èbùlà"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("hrúturinn"),
            keywords: &["hrútur", "hrúturinn", "stjörnumerki"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("Segno zodiacale dell’Ariete"),
            keywords: &["Ariete", "Segno zodiacale dell’Ariete", "zodiaco"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("おひつじ座"),
            keywords: &["おひつじ座", "星座", "牡羊座"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("Lintang Aries"),
            keywords: &["Aries", "Lintang Aries", "palintangan", "wedhus gembel"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ვერძი"),
            keywords: &["ერკემალი", "ვერძი", "ზოდიაქო", "ჰოროსკოპი"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("Ikerri"),
            keywords: &["Ikerri"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("тоқты белгісі"),
            keywords: &["зодиак", "тоқты", "тоқты белгісі"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("vædderen"),
            keywords: &["stjernetegn", "vædderen"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some(
                "សញ\u{17d2}ញាតារាសាស\u{17d2}ត\u{17d2}រអ\u{17ca}\u{17ba}រ\u{17c9}\u{17bb}បប\u{17d2}រភទទ\u{17b8}១ ចៀមឈ\u{17d2}មោល",
            ),
            keywords: &[
                "កណ\u{17d2}ត\u{17bb}រ",
                "ជ\u{17bc}ត",
                "សញ\u{17d2}ញាតារាសាស\u{17d2}ត\u{17d2}រអ\u{17ca}\u{17ba}រ\u{17c9}\u{17bb}បប\u{17d2}រភទទ\u{17b8}១ ចៀមឈ\u{17d2}មោល",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಮೇಷ"),
            keywords: &["ಮೇಷ", "ರಾಶ\u{cbf}ಚಕ\u{ccd}ರ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("양자리"),
            keywords: &["별", "별자리", "양", "양자리"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("म\u{947}ष"),
            keywords: &["म\u{947}\u{902}ढो", "म\u{947}ष", "म\u{947}षरास", "रास"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("кой жылдызы"),
            keywords: &["зодиак", "кой", "кой жылдызы"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Widder (Stärzeechen)"),
            keywords: &["Stärzeechen", "Widder", "Widder (Stärzeechen)"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ລາສ\u{eb5}ເມກ"),
            keywords: &["ລາສ\u{eb5}", "ລາສ\u{eb5}ເມກ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("avinas"),
            keywords: &["avinas", "zodiakas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("zodiaka zīme Auns"),
            keywords: &["auns", "zodiaka zīme Auns", "zodiaks"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("Aries"),
            keywords: &["Aries", "poutiriao", "rāme"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("хороскопски знак овен"),
            keywords: &["овен", "хороскоп", "хороскопски знак овен"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("മേടം"),
            keywords: &["മേടം", "ര\u{d3e}ശി"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("хонины орд"),
            keywords: &["орд", "хонины орд", "хонь"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("म\u{947}ष रास"),
            keywords: &["म\u{947}ष", "म\u{947}ष रास", "राशी"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("Aries"),
            keywords: &["Aries", "ram", "zodiak"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("Aries"),
            keywords: &["Aries", "muntun", "żodjaku"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("မ\u{102d}ဿ"),
            keywords: &[
                "ဆယ\u{1037}\u{103a}န\u{103e}စ\u{103a}ရာသ\u{102e}ခ\u{103d}င\u{103a}",
                "မ\u{102d}ဿ",
                "မ\u{102d}ဿရာသ\u{102e}",
                "သ\u{102d}\u{102f}းထ\u{102e}းပ\u{102f}\u{1036} မ\u{102d}ဿရာသ\u{102e}ရ\u{102f}ပ\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("Væren"),
            keywords: &["Væren", "stjernetegn", "vær"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("म\u{947}ष"),
            keywords: &["म\u{947}ष", "राम", "राशि"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("ram (sterrenbeeld)"),
            keywords: &["Aries", "dierenriem", "ram", "ram (sterrenbeeld)"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("Vêren"),
            keywords: &["Vêren", "stjerneteikn", "vêr"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ମେଷ"),
            keywords: &["ମେଣ\u{b4d}ଢ\u{b3e} । ର\u{b3e}ଶ\u{b3f}ଚକ\u{b4d}ର", "ମେଷ"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਮ\u{a47}ਖ ਰਾਸ\u{a3c}ੀ"),
            keywords: &["ਮ\u{a47}ਖ", "ਰਾਸ\u{a3c}ੀ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ب\u{64f}رج ح\u{64e}م\u{64e}ل"),
            keywords: &["ب\u{64f}رج", "ب\u{64f}رج ح\u{64e}م\u{64e}ل", "دنبہ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("É\u{301}riz"),
            keywords: &["Ram", "Zódiak", "É\u{301}riz"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("Baran"),
            keywords: &["Baran", "baran", "znak zodiaku", "zodiak"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("وری"),
            keywords: &["مرغومی", "وری", "ګډ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("signo de Áries"),
            keywords: &["carneiro", "signo de Áries", "zodíaco", "Áries"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("Carneiro"),
            keywords: &["Carneiro", "carneiro", "signo"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("Aries"),
            keywords: &["Aries", "carnero", "zodiaco"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("zodia Berbec"),
            keywords: &["berbec", "zodia Berbec", "zodiac", "zodie"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-064"),
            keywords: &["E10-064"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("знак зодиака Овен"),
            keywords: &["знак", "знак зодиака Овен", "зодиак", "овен"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("Isekurume y’intama"),
            keywords: &["Isekurume y’intama", "rugeyo", "zodiyake"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("برج حمل"),
            keywords: &["برج حمل", "راس چڪر، حمل", "ريم"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("මේෂ"),
            keywords: &["මේෂ", "ර\u{dcf}ශ\u{dd2}ය"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("znamenie barana"),
            keywords: &["baran", "znamenie barana", "zverokruh"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("astrološki znak ovna"),
            keywords: &["astrološki znak ovna", "oven", "zodiak"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("laxo"),
            keywords: &["laxo", "mactabka meecaad", "wan"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("dashi"),
            keywords: &["dashi", "zodiak"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("ован у хороскопу"),
            keywords: &["oвaн", "зoдиjaк", "ован у хороскопу"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("ovan u horoskopu"),
            keywords: &["ovan", "ovan u horoskopu", "zodijak"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("Väduren"),
            keywords: &["Väduren", "stjärntecken"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("nyota ya kondoo"),
            keywords: &["nyota ya kondoo", "zodiaki"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("மேஷம\u{bcd}"),
            keywords: &[
                "இர\u{bbe}சி",
                "நட\u{bcd}சத\u{bcd}திரம\u{bcd}",
                "மேஷம\u{bcd}",
                "ர\u{bbe}சி",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("మ\u{c47}షర\u{c3e}శ\u{c3f}"),
            keywords: &["చక\u{c4d}రం", "మ\u{c47}షర\u{c3e}శ\u{c3f}"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("Ҳамал"),
            keywords: &["бурҷи дувоздаҳгона", "қӯшқор", "Ҳамал"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ราศ\u{e35}เมษ"),
            keywords: &["จ\u{e31}กรราศ\u{e35}", "ราศ\u{e35}เมษ"],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ኣሬስ"),
            keywords: &["ራም", "ኣሬስ", "ዞድያክ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("Guzy"),
            keywords: &["Guzy", "goç", "täleýnama"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("Sipi tangata (pupunga)"),
            keywords: &["Sipi tangata (pupunga)"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("koç burcu"),
            keywords: &["burçlar", "koç burcu"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ھەمەل"),
            keywords: &["قوشقار", "مۆچەل", "ھەمەل"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("Овен"),
            keywords: &["Овен", "баран", "зодіак"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("برج حمل"),
            keywords: &["برج", "حمل"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("qo‘y burji"),
            keywords: &["burj", "qo‘y", "qo‘y burji"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("Bạch Dương"),
            keywords: &["Bạch Dương", "cung hoàng đạo", "cừu đực"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("Kuy"),
            keywords: &["Kuy", "ram", "sojak"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("I-Aries"),
            keywords: &["I-Aries", "i-zodiac", "inkunzi yegusha"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Aries"),
            keywords: &["Aries", "àgbò", "àmi oṣù ìbí"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("白羊座"),
            keywords: &["公羊", "星座", "白羊座"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("白羊座"),
            keywords: &["公羊", "星座", "白羊座"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("白羊座"),
            keywords: &["公羊", "星座", "白羊座"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("牡羊座"),
            keywords: &["星座", "牡羊座"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("白羊座"),
            keywords: &["星座", "牡羊座", "白羊座"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("aries"),
            keywords: &["aries", "inkanyezi", "isiklabhu"],
        },
    ],
};
#[doc = "♉"]
pub const TAURUS: crate::Emoji = crate::Emoji {
    glyph: "♉",
    codepoint: "2649",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "Taurus",
    group: "Symbols",
    subgroup: "zodiac",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("Bul-sterrebeeld"),
            keywords: &["Bul-sterrebeeld", "bul", "diereriem", "os"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ታውረስ"),
            keywords: &["በሬ", "ታውረስ", "ኮርማ", "ዞዲያክ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("الثور"),
            keywords: &["الأبراج", "الثور"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ব\u{9c3}ষ ৰ\u{9be}শি"),
            keywords: &[
                "বলধ",
                "ব\u{9c3}ষ ৰ\u{9be}শি",
                "ষ\u{9be}\u{981}ড\u{9bc}",
                "ৰ\u{9be}শিচক\u{9cd}ৰ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("buğa"),
            keywords: &["buğa", "ox", "zodiak", "öküz"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("знак задыяка Цялец"),
            keywords: &["бык", "задыяк", "знак задыяка Цялец", "цялец"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Зодиакален знак телец"),
            keywords: &[
                "Зодиакален знак телец",
                "зодиак",
                "зодиакален знак",
                "зодия",
                "телец",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ব\u{9c3}ষ"),
            keywords: &["ব\u{9c1}ল", "ব\u{9c3}ষ", "র\u{9be}শিচক\u{9cd}র"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("an Tarv"),
            keywords: &["Tarv", "Tau", "an Tarv", "zodiak"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("bik"),
            keywords: &["bik", "horoskop", "znak", "zodijak"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("Taure"),
            keywords: &["Taure", "bou", "brau", "zodíac"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏧᎧᏅᏍᏕᎾ"),
            keywords: &["ᎠᎧᏏ", "ᏃᏈᏏ ᏓᏟᎶᏍᏗᎲᎢ", "ᏧᎧᏅᏍᏕᎾ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("býk"),
            keywords: &["býk", "vůl", "zvěrokruh"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("y Tarw"),
            keywords: &["sidydd", "tarw", "y Tarw", "ych"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("tyren"),
            keywords: &["stjernetegn", "tyren"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Stier (Sternzeichen)"),
            keywords: &["Sternzeichen", "Stier", "Stier (Sternzeichen)"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("Ταύρος"),
            keywords: &["Ταύρος", "βόδι", "ζώδιο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("Taurus"),
            keywords: &["Taurus", "bull", "ox", "zodiac"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("Tauro"),
            keywords: &["Tauro", "buey", "tauro", "toro", "zodiaco"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["Tauro", "buey", "tauro", "toro", "zodíaco"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("Sõnn"),
            keywords: &["Sõnn", "sodiaak"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("taurus"),
            keywords: &["idi", "taurus", "zezen", "zodiako"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("برج ثور"),
            keywords: &["اردیبهشت", "برج", "ثور"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("härkä-merkki"),
            keywords: &["horoskooppi", "horoskooppimerkki", "härkä", "härkä-merkki"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("Taurus"),
            keywords: &["Taurus", "toro", "zodiac"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("Tarvurin"),
            keywords: &["Tarvurin", "oksi", "stjørnumerki", "tarvsmerkið", "tarvur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("taureau"),
            keywords: &["taureau", "zodiaque"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("Taureau"),
            keywords: &["Taureau", "zodiaque"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("an Tarbh"),
            keywords: &["Taurus", "an Tarbh", "stoidiaca"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("An Tarbh"),
            keywords: &[
                "An Tarbh",
                "damh",
                "grian-chrios",
                "grian-chriosach",
                "tarbh",
                "taurus",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("Tauro"),
            keywords: &["Tauro", "Taurus", "touro", "zodíaco"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("વ\u{ac3}ષભ"),
            keywords: &["રાશિચક\u{acd}ર", "વ\u{ac3}ષભ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("Taurus"),
            keywords: &["Taurus", "sa", "takarkari", "zodiac"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("מזל שור"),
            keywords: &["גלגל המזלות", "מזל", "שור"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("व\u{943}षभ"),
            keywords: &["राशि", "व\u{943}षभ", "व\u{943}षभ, राशि"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("astrološki znak bika"),
            keywords: &["astrološki znak bika", "bik", "zodijak"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("bika csillagjegy"),
            keywords: &["bika", "bika csillagjegy", "horoszkóp"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("Ցուլ"),
            keywords: &["Ցուլ", "կենդանակերպ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("Taurus"),
            keywords: &["Taurus", "banteng", "taurus", "zodiak"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("Tọrus"),
            keywords: &["Tọrus", "oke ehi", "zodịak"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("nautið"),
            keywords: &["naut", "nautið", "stjörnumerki"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("Segno zodiacale del Toro"),
            keywords: &["Segno zodiacale del Toro", "Toro", "zodiaco"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("おうし座"),
            keywords: &["おうし座", "星座", "牡牛座"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("Lintang Taurus"),
            keywords: &["Lintang Taurus", "Taurus", "bantheng", "palintangan"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("კურო"),
            keywords: &["ზოდიაქო", "კურო", "ხარი", "ჰოროსკოპი"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("Aramul"),
            keywords: &["Aramul"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("торпақ белгісі"),
            keywords: &["бұқа", "зодиак", "торпақ белгісі", "өгіз"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("tyren"),
            keywords: &["stjernetegn", "tyren"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some(
                "សញ\u{17d2}ញាតារាសាស\u{17d2}ត\u{17d2}រអ\u{17ca}\u{17ba}រ\u{17c9}\u{17bb}បប\u{17d2}រភទទ\u{17b8}២ គោព\u{17d2}រៃ",
            ),
            keywords: &[
                "គោ",
                "ឆ\u{17d2}ល\u{17bc}វ",
                "សញ\u{17d2}ញាតារាសាស\u{17d2}ត\u{17d2}រអ\u{17ca}\u{17ba}រ\u{17c9}\u{17bb}បប\u{17d2}រភទទ\u{17b8}២ គោព\u{17d2}រៃ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ವೃಷಭ"),
            keywords: &["ರಾಶ\u{cbf}ಚಕ\u{ccd}ರ", "ವೃಷಭ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("황소자리"),
            keywords: &["별", "별자리", "황소", "황소자리"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("व\u{943}षभ"),
            keywords: &["पाडो", "ब\u{948}ल", "रास", "व\u{943}षभ", "व\u{943}षभरास"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("букачар"),
            keywords: &["бука", "букачар", "зодиак", "өгүз"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Stéier"),
            keywords: &["Ochs", "Stärzeechen", "Stéier"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ລາສ\u{eb5}ງ\u{ebb}ວ"),
            keywords: &["ລາສ\u{eb5}", "ລາສ\u{eb5}ງ\u{ebb}ວ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("tauras"),
            keywords: &["bulius", "tauras", "zodiakas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("zodiaka zīme Vērsis"),
            keywords: &["vērsis", "zodiaka zīme Vērsis", "zodiaks"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("Taurus"),
            keywords: &["Taurus", "poutiriao", "pūru"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("хороскопски знак бик"),
            keywords: &["бик", "хороскоп", "хороскопски знак бик"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഇടവം"),
            keywords: &["ഇടവം", "ര\u{d3e}ശി"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("үхрийн орд"),
            keywords: &["орд", "үхрийн орд", "үхэр"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("व\u{943}षभ रास"),
            keywords: &["ब\u{948}ल", "रास", "व\u{943}षभ"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("Taurus"),
            keywords: &["Taurus", "lembu", "lembu jantan", "zodiak"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("Taurus"),
            keywords: &["Taurus", "barri", "bhima", "żodjaku"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ပြ\u{102d}ဿ"),
            keywords: &[
                "ဆယ\u{1037}\u{103a}န\u{103e}စ\u{103a}ရာသ\u{102e}ခ\u{103d}င\u{103a}",
                "န\u{103d}ားလားပ\u{102f}\u{1036}",
                "န\u{103d}ားလားပ\u{102f}\u{1036} ပြ\u{102d}ဿရာသ\u{102e}ရ\u{102f}ပ\u{103a}",
                "ပြ\u{102d}ဿ",
                "ပြ\u{102d}ဿရာသ\u{102e}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("Tyren"),
            keywords: &["Tyren", "okse", "stjernetegn", "tyr"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("व\u{943}ष"),
            keywords: &["गोर\u{942}", "राशि", "व\u{943}ष"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("stier (sterrenbeeld)"),
            keywords: &[
                "Taurus",
                "dierenriem",
                "os",
                "stier",
                "stier (sterrenbeeld)",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("Tyren"),
            keywords: &["Tyren", "okse", "stjerneteikn", "tyr"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ବ\u{b43}ଷ"),
            keywords: &[
                "ବଳଦ",
                "ବ\u{b43}ଷ",
                "ର\u{b3e}ଶ\u{b3f}ଚକ\u{b4d}ର",
                "ଷଣ\u{b4d}ଢ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਵ\u{a4d}ਰਸ\u{a3c} ਰਾਸ\u{a3c}ੀ"),
            keywords: &["ਰਾਸ\u{a3c}ੀ", "ਵ\u{a4d}ਰਸ\u{a3c}"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ب\u{64f}رج ثور"),
            keywords: &["ب\u{64f}رج", "ب\u{64f}رج ثور", "ٹگا"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Tọ\u{301}rus"),
            keywords: &["Bul", "Mán-kau", "Tọ\u{301}rus", "Zódiak"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("Byk"),
            keywords: &["Byk", "byk", "znak zodiaku", "zodiak"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("تورس"),
            keywords: &["تورس", "غوايي", "مرغومی"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("signo de Touro"),
            keywords: &["boi", "signo de Touro", "touro", "zodíaco"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("Touro"),
            keywords: &["Touro", "signo"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("Tauro"),
            keywords: &["Tauro", "buey", "toro", "zodiaco"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("zodia Taur"),
            keywords: &["taur", "zodia Taur", "zodiac", "zodie"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-065"),
            keywords: &["E10-065"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("знак зодиака Телец"),
            keywords: &["знак", "знак зодиака Телец", "зодиак", "телец"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ikimenyesto cya Torisi"),
            keywords: &["ikimasa", "ikimenyesto cya Torisi", "imfizi", "zodiyake"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("برج ثور"),
            keywords: &["برج ثور", "راس چڪر", "ڍڳو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("වෘෂභ"),
            keywords: &["ගවය\u{dcf}", "ගොන\u{dcf}", "ර\u{dcf}ශ\u{dd2}ය", "වෘෂභ"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("znamenie býka"),
            keywords: &["byvol", "býk", "znamenie býka", "zverokruh"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("bik"),
            keywords: &["bik", "vol", "zodiak"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("dibigga Taurus"),
            keywords: &["baqay", "dibbi", "dibigga Taurus", "mactabka meecaad"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("demi"),
            keywords: &["buall", "dem", "demi", "zodiak"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("бик у хороскопу"),
            keywords: &["бик", "бик у хороскопу", "зoдиjaк"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("bik u horoskopu"),
            keywords: &["bik", "bik u horoskopu", "zodijak"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("Oxen"),
            keywords: &["Oxen", "stjärntecken"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("fahali"),
            keywords: &["dume", "fahali", "zodiaki"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ரிஷபம\u{bcd}"),
            keywords: &[
                "இர\u{bbe}சி",
                "நட\u{bcd}சத\u{bcd}திரம\u{bcd}",
                "ர\u{bbe}சி",
                "ரிஷபம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("వృషభర\u{c3e}శ\u{c3f}"),
            keywords: &["చక\u{c4d}రం", "వృషభర\u{c3e}శ\u{c3f}"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("Савр"),
            keywords: &["Савр", "бурҷи дувоздаҳгона", "буққа"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ราศ\u{e35}พฤษภ"),
            keywords: &["จ\u{e31}กรราศ\u{e35}", "ราศ\u{e35}พฤษภ"],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ታውሩስ"),
            keywords: &["Taurus", "zodiac", "ብዕራይ", "ታውሩስ", "ኣርሓ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("Sowur"),
            keywords: &["Sowur", "täleýnama", "öküz", "öküzçe"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("Pulu tau (pupunga)"),
            keywords: &["Pulu tau (pupunga)", "pulu", "pupunga", "tau"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("boğa burcu"),
            keywords: &["boğa burcu", "burçlar"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئۇي"),
            keywords: &["ئۆكۈز", "ئۇي", "بۇقا", "مۆچەل"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("Телець"),
            keywords: &["Телець", "бик", "віл", "зодіак"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("برج ثور"),
            keywords: &["برج", "برج ثور", "بیل"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("buzoq burji"),
            keywords: &["burj", "buzoq", "buzoq burji"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("Kim Ngưu"),
            keywords: &["Kim Ngưu", "bò đực", "cung hoàng đạo"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("Nag wu góor"),
            keywords: &["Nag wu góor", "nag", "sojak", "yékk"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("I-Taurus"),
            keywords: &["I-Taurus", "i-zodiac", "inkunzi", "inkunzi yenkomo"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Taurus"),
            keywords: &["Taurus", "màlúù igbò", "àmi oṣù ìbí", "ẹgbọrọ màlúù"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("金牛座"),
            keywords: &["公牛", "星座", "牛", "金牛座"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("金牛座"),
            keywords: &["公牛", "星座", "牛", "金牛座"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("金牛座"),
            keywords: &["公牛", "星座", "金牛座"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("金牛座"),
            keywords: &["星座", "金牛座"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("taurus"),
            keywords: &["inkanyezi", "inkunzi", "taurus"],
        },
    ],
};
#[doc = "♊"]
pub const GEMINI: crate::Emoji = crate::Emoji {
    glyph: "♊",
    codepoint: "264A",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "Gemini",
    group: "Symbols",
    subgroup: "zodiac",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("Tweeling-sterrebeeld"),
            keywords: &["Tweeling-sterrebeeld", "diereriem", "tweeling"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ጄሚኒ"),
            keywords: &["መንትዮች", "ዞዲያክ", "ጄሚኒ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("الجوزاء"),
            keywords: &["الأبراج", "الجوزاء"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("মিথ\u{9c1}ন ৰ\u{9be}শি"),
            keywords: &[
                "মিথ\u{9c1}ন ৰ\u{9be}শি",
                "য\u{981}জ\u{9be} শিশ\u{9c1}",
                "ৰ\u{9be}শিচক\u{9cd}ৰ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("əkizlər"),
            keywords: &["zodiak", "əkizlər"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("знак задыяка Блізняты"),
            keywords: &["блізняты", "задыяк", "знак задыяка Блізняты"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Зодиакален знак близнаци"),
            keywords: &[
                "Зодиакален знак близнаци",
                "близнаци",
                "зодиак",
                "зодиакален знак",
                "зодия",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("মিথ\u{9c1}ন"),
            keywords: &[
                "মিথ\u{9c1}ন",
                "মিথ\u{9c1}নর\u{9be}শি",
                "র\u{9be}শিচক\u{9cd}র",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("ar Gevelled"),
            keywords: &["Gem", "Gevelled", "ar Gevelled", "zodiak"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("blizanci"),
            keywords: &["blizanci", "horoskop", "znak", "zodijak"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("Bessons"),
            keywords: &["Bessons", "Gèmini", "zodíac"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏥᎹᎾᏱ"),
            keywords: &["ᏃᏈᏏ ᏓᏟᎶᏍᏗᎲᎢ", "ᏗᏂᏝᏫ", "ᏥᎹᎾᏱ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("blíženci"),
            keywords: &["blíženci", "blíženec", "dvojčata", "zvěrokruh"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("yr Efeilliaid"),
            keywords: &["efeilliaid", "sidydd", "yr Efeilliaid"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("tvillingen"),
            keywords: &["stjernetegn", "tvillingen"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Zwilling (Sternzeichen)"),
            keywords: &["Sternzeichen", "Zwilling", "Zwilling (Sternzeichen)"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("Δίδυμοι"),
            keywords: &["Δίδυμοι", "ζώδιο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("Gemini"),
            keywords: &["Gemini", "twins", "zodiac"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("Géminis"),
            keywords: &["Géminis", "gemelos", "géminis", "zodiaco"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["Géminis", "géminis", "mellizos", "zodíaco"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("Kaksikud"),
            keywords: &["Kaksikud", "sodiaak"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("gemini"),
            keywords: &["biki", "gemini", "zodiako"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("برج جوزا"),
            keywords: &["برج", "جوزا", "خرداد"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kaksonen-merkki"),
            keywords: &[
                "horoskooppi",
                "horoskooppimerkki",
                "kaksonen",
                "kaksonen-merkki",
                "kaksoset",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("Gemini"),
            keywords: &["Gemini", "kambal", "zodiac"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("Tvíburarnir"),
            keywords: &["Tvíburarnir", "stjørnumerki", "tvíburamerki", "tvíburar"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("gémeaux"),
            keywords: &["gémeaux", "zodiaque"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("Gémeaux"),
            keywords: &["Gémeaux", "zodiaque"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("an Cúpla"),
            keywords: &["Gemini", "an Cúpla", "stoidiaca"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("Na Leth-aonan"),
            keywords: &[
                "Na Leth-aonan",
                "gemini",
                "grian-chrios",
                "grian-chriosach",
                "leth-aon",
                "leth-aonan",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("Xémini"),
            keywords: &["Gemini", "Xémini", "xemelgos", "zodíaco"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("મિથ\u{ac1}ન"),
            keywords: &["મિથ\u{ac1}ન", "રાશિચક\u{acd}ર"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("Gemini"),
            keywords: &["Gemini", "tagwai", "zodiac"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("מזל תאומים"),
            keywords: &["גלגל המזלות", "מזל", "תאומים"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("मिथ\u{941}न"),
            keywords: &["मिथ\u{941}न", "मिथ\u{941}न, राशि", "राशि"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("astrološki znak blizanaca"),
            keywords: &["astrološki znak blizanaca", "blizanci", "zodijak"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("ikrek csillagjegy"),
            keywords: &["horoszkóp", "ikrek", "ikrek csillagjegy"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("Երկվորյակներ"),
            keywords: &["Երկվորյակներ", "կենդանակերպ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("Gemini"),
            keywords: &["Gemini", "gemini", "kembar", "zodiak"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("Gemini"),
            keywords: &["Gemini", "ejima", "zodịak"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("tvíburar"),
            keywords: &["stjörnumerki", "tvíburar"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("Segno zodiacale dei Gemelli"),
            keywords: &["Gemelli", "Segno zodiacale dei Gemelli", "zodiaco"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ふたご座"),
            keywords: &["ふたご座", "双子座", "星座"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("Lintang Gemini"),
            keywords: &["Gemini", "Lintang Gemini", "anak kembar", "palintangan"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ტყუპები"),
            keywords: &["ზოდიაქო", "მარჩბივი", "ტყუპები", "ჰოროსკოპი"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("Akniwen"),
            keywords: &["Akniwen"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("егіздер белгісі"),
            keywords: &["егіздер", "егіздер белгісі", "зодиак"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("tvillingen"),
            keywords: &["stjernetegn", "tvillingen"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some(
                "សញ\u{17d2}ញាតារាសាស\u{17d2}ត\u{17d2}រអ\u{17ca}\u{17ba}រ\u{17c9}\u{17bb}បប\u{17d2}រភទទ\u{17b8}៣ ក\u{17bc}នភ\u{17d2}លោះ",
            ),
            keywords: &[
                "ខាល",
                "ខ\u{17d2}លា",
                "សញ\u{17d2}ញាតារាសាស\u{17d2}ត\u{17d2}រអ\u{17ca}\u{17ba}រ\u{17c9}\u{17bb}បប\u{17d2}រភទទ\u{17b8}៣ ក\u{17bc}នភ\u{17d2}លោះ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಮ\u{cbf}ಥುನ"),
            keywords: &["ಮ\u{cbf}ಥುನ", "ರಾಶ\u{cbf}ಚಕ\u{ccd}ರ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("쌍둥이 자리"),
            keywords: &["별", "별자리", "쌍둥이", "쌍둥이 자리"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("मिथ\u{941}न"),
            keywords: &["ज\u{941}ळी\u{902}", "मिथ\u{941}न", "मिथ\u{941}नरास", "रास"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("эгиздер"),
            keywords: &["зодиак", "эгиздер"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Zwilling"),
            keywords: &["Stärzeechen", "Zwilling"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ລາສ\u{eb5}ເມຖ\u{eb8}ນ"),
            keywords: &["ລາສ\u{eb5}", "ລາສ\u{eb5}ເມຖ\u{eb8}ນ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("dvyniai"),
            keywords: &["dvyniai", "zodiakas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("zodiaka zīme Dvīņi"),
            keywords: &["dvīņi", "zodiaka zīme Dvīņi", "zodiaks"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("Gemini"),
            keywords: &["Gemini", "ngā māhanga", "poutiriao"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("хороскопски знак близнаци"),
            keywords: &["близнаци", "хороскоп", "хороскопски знак близнаци"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("മിഥ\u{d41}നം"),
            keywords: &["മിഥ\u{d41}നം", "ര\u{d3e}ശി"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("ихрийн орд"),
            keywords: &["ихрийн орд", "ихэр", "орд"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("मिथ\u{941}न रास"),
            keywords: &["ज\u{941}ळ\u{947}", "मिथ\u{941}न रास", "रास"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("Gemini"),
            keywords: &["Gemini", "kembar", "zodiak"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("Gemini"),
            keywords: &["Gemini", "it-tewmin", "żodjaku"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("မေထ\u{102f}န\u{103a}"),
            keywords: &[
                "ဆယ\u{1037}\u{103a}န\u{103e}စ\u{103a}ရာသ\u{102e}ခ\u{103d}င\u{103a}",
                "မေထ\u{102f}န\u{103a}",
                "မေထ\u{102f}န\u{103a}ရာသ\u{102e}",
                "မေထ\u{102f}န\u{103a}ရာသ\u{102e}ရ\u{102f}ပ\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("Tvillingene"),
            keywords: &["Tvillingene", "stjernetegn", "tvillinger"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("मिथ\u{941}न"),
            keywords: &["मिथ\u{941}न", "राशि", "समान"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("tweelingen (sterrenbeeld)"),
            keywords: &[
                "Gemini",
                "dierenriem",
                "tweelingen",
                "tweelingen (sterrenbeeld)",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("Tvillingane"),
            keywords: &["Tvillingane", "stjerneteikn", "tvillingar"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ମ\u{b3f}ଥ\u{b41}ନ"),
            keywords: &[
                "ଜ\u{b3e}ଆ\u{b01}ଳ\u{b3e} । ର\u{b3e}ଶ\u{b3f}ଚକ\u{b4d}ର",
                "ମ\u{b3f}ଥ\u{b41}ନ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਮਿਥ\u{a41}ਨ ਰਾਸ\u{a3c}ੀ"),
            keywords: &["ਮਿਥ\u{a41}ਨ", "ਰਾਸ\u{a3c}ੀ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ب\u{64f}رج\u{650} جوزا"),
            keywords: &["ب\u{64f}رج", "ب\u{64f}رج\u{650} جوزا", "جڑواں"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Jẹ\u{301}míni"),
            keywords: &["Jẹ\u{301}míni", "Twins", "Zódiak"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("Bliźnięta"),
            keywords: &["Bliźnięta", "bliźnięta", "znak zodiaku", "zodiak"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("جمني"),
            keywords: &["جمني", "غبرګوني", "مرغومی"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("signo de Gêmeos"),
            keywords: &["gêmeos", "signo de Gêmeos", "zodíaco"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("Gémeos"),
            keywords: &["Gémeos", "signo"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("Geminis"),
            keywords: &["Geminis", "wispa", "zodiaco"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("zodia Gemeni"),
            keywords: &["gemeni", "zodia Gemeni", "zodiac", "zodie"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-066"),
            keywords: &["E10-066"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("знак зодиака Близнецы"),
            keywords: &["близнецы", "знак", "знак зодиака Близнецы", "зодиак"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("Jemini"),
            keywords: &["Jemini", "impanga", "zodiyake"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("برج جوزا"),
            keywords: &["برج جوزا", "جاڙا", "راس چڪر"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ම\u{dd2}ථ\u{dd4}න"),
            keywords: &[
                "න\u{dd2}ව\u{dd4}න\u{dca}න\u{dd4}",
                "ම\u{dd2}ථ\u{dd4}න",
                "ර\u{dcf}ශ\u{dd2}ය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("znamenie blížencov"),
            keywords: &["dvojičky", "znamenie blížencov", "zverokruh"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("dvojčka"),
            keywords: &["dvojčka", "zodiak"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("mataanaha"),
            keywords: &["mactabka meecaad", "mataan", "mataanaha"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("binjakët"),
            keywords: &["binjakë", "binjakët", "zodiak"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("близанци у хороскопу"),
            keywords: &["близaнци", "близанци у хороскопу", "зoдиjaк"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("blizanci u horoskopu"),
            keywords: &["blizanci", "blizanci u horoskopu", "zodijak"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("Tvillingarna"),
            keywords: &["Tvillingarna", "stjärntecken"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mapacha"),
            keywords: &["mapacha", "zodiaki"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("மிதுனம\u{bcd}"),
            keywords: &[
                "இர\u{bbe}சி",
                "நட\u{bcd}சத\u{bcd}திரம\u{bcd}",
                "மிதுனம\u{bcd}",
                "ர\u{bbe}சி",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("మ\u{c3f}ధునర\u{c3e}శ\u{c3f}"),
            keywords: &["చక\u{c4d}రం", "మ\u{c3f}ధునర\u{c3e}శ\u{c3f}"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("Ҷавзо"),
            keywords: &["бурҷи дувоздаҳгона", "дугоник", "Ҷавзо"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ราศ\u{e35}เมถ\u{e38}น"),
            keywords: &["จ\u{e31}กรราศ\u{e35}", "ราศ\u{e35}เมถ\u{e38}น"],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ጀሚኒ"),
            keywords: &["ማንታ", "ዞድያክ", "ጀሚኒ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("Ekizler"),
            keywords: &["Ekizler", "ekizler", "täleýnama"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("Māhanga taʻane (pupunga)"),
            keywords: &["Māhanga taʻane (pupunga)", "māhanga", "pupunga", "taʻane"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("ikizler burcu"),
            keywords: &["burçlar", "ikizler burcu"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("قوشكېزەك"),
            keywords: &["قوشكېزەك", "مۆچەل"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("Близнюки"),
            keywords: &["Близнюки", "зодіак"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("برج جوزا"),
            keywords: &["برج", "برج جوزا", "ج\u{64f}ڑواں"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("egizaklar burji"),
            keywords: &["burj", "egizaklar", "egizaklar burji"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("Song Tử"),
            keywords: &["Song Tử", "cung hoàng đạo", "song sinh"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("Jemóo"),
            keywords: &["Jemóo", "ay seex", "sojak"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("I-Gemini"),
            keywords: &["I-Gemini", "amawele", "i-zodiac"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Gemini"),
            keywords: &["Gemini", "àmi oṣù ìbí", "ìbejì"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("雙子座"),
            keywords: &["星座", "雙子", "雙子座"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("双子座"),
            keywords: &["双子", "双子座", "星座"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("双子座"),
            keywords: &["双子座", "孪生子", "星座"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("雙子座"),
            keywords: &["星座", "雙子座"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("gemini"),
            keywords: &["amawele", "gemini", "inkanyezi"],
        },
    ],
};
#[doc = "♋"]
pub const CANCER: crate::Emoji = crate::Emoji {
    glyph: "♋",
    codepoint: "264B",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "Cancer",
    group: "Symbols",
    subgroup: "zodiac",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("Kreef-sterrebeeld"),
            keywords: &["Kreef-sterrebeeld", "diereriem", "krap"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ካንሰር"),
            keywords: &["ካንሰር", "ክራብ", "ዞዲያክ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("السرطان"),
            keywords: &["الأبراج", "السرطان"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("কৰ\u{9cd}কট ৰ\u{9be}শি"),
            keywords: &[
                "কে\u{981}কোৰ\u{9be}",
                "কৰ\u{9cd}কট ৰ\u{9be}শি",
                "ৰ\u{9be}শিচক\u{9cd}ৰ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("xərçəng"),
            keywords: &["xərçəng", "zodiak"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("знак задыяка Рак"),
            keywords: &["задыяк", "знак задыяка Рак", "краб", "рак"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Зодиакален знак рак"),
            keywords: &[
                "Зодиакален знак рак",
                "зодиак",
                "зодиакален знак",
                "зодия",
                "рак",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("কর\u{9cd}কট"),
            keywords: &[
                "কর\u{9cd}কট",
                "কর\u{9cd}কটর\u{9be}শি",
                "র\u{9be}শিচক\u{9cd}র",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("ar Cʼhrank"),
            keywords: &["Cnc", "Krank", "ar Cʼhrank", "zodiak"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("znak rak"),
            keywords: &["horoskop", "znak", "znak rak", "zodijak"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("Càncer"),
            keywords: &["Cranc", "Càncer", "zodíac"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏓᏰᏍᎩ"),
            keywords: &["ᎠᏓᏰᏍᎩ", "ᎤᏯᏍᎦ", "ᏃᏈᏏ ᏓᏟᎶᏍᏗᎲᎢ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("rak"),
            keywords: &["rak", "zvěrokruh"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("y Cranc"),
            keywords: &["cranc", "sidydd", "y Cranc"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("krebsen"),
            keywords: &["krebsen", "stjernetegn"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Krebs (Sternzeichen)"),
            keywords: &["Krebs", "Krebs (Sternzeichen)", "Sternzeichen"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("Καρκίνος"),
            keywords: &["Καρκίνος", "ζώδιο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("Cancer"),
            keywords: &["Cancer", "crab", "zodiac"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("Cáncer"),
            keywords: &["Cáncer", "cangrejo", "cáncer", "zodiaco"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["Cáncer", "cangrejo", "cáncer", "zodíaco"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("Vähk"),
            keywords: &["Vähk", "sodiaak"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("cancer"),
            keywords: &["cancer", "karramarro", "zodiako"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("برج سرطان"),
            keywords: &["برج", "تیر", "سرطان"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("rapu-merkki"),
            keywords: &["horoskooppi", "horoskooppimerkki", "rapu", "rapu-merkki"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("Cancer"),
            keywords: &["Cancer", "alimango", "zodiac"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("Krabbin"),
            keywords: &["Krabbin", "krabbamerkið", "krabbi", "stjørnumerki"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("cancer"),
            keywords: &["cancer", "zodiaque"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("Cancer"),
            keywords: &["Cancer", "zodiaque"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("an Portán"),
            keywords: &["Cancer", "an Portán", "stoidiaca"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("Am Partan"),
            keywords: &[
                "Am Partan",
                "cancer",
                "grian-chrios",
                "grian-chriosach",
                "partan",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("Cáncer"),
            keywords: &["Cáncer", "cangrexo", "caranguexo", "zodíaco"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("કર\u{acd}ક"),
            keywords: &["કર\u{acd}ક", "રાશિચક\u{acd}ર"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("Cancer"),
            keywords: &["Cancer", "zodiac", "ƙaguwa"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("מזל סרטן"),
            keywords: &["גלגל המזלות", "מזל", "סרטן"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("कर\u{94d}क"),
            keywords: &["कर\u{94d}क", "कर\u{94d}क, राशि", "राशि"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("astrološki znak raka"),
            keywords: &["astrološki znak raka", "rak", "zodijak"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("rák csillagjegy"),
            keywords: &["horoszkóp", "rák", "rák csillagjegy"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("Խեցգետին"),
            keywords: &["Խեցգետին", "կենդանակերպ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("Cancer"),
            keywords: &["Cancer", "cancer", "kepiting", "zodiak"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("Ịzi ọbara"),
            keywords: &["nshịkọ", "zodịak", "Ịzi ọbara"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("krabbinn"),
            keywords: &["krabbi", "krabbinn", "stjörnumerki"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("Segno zodiacale del Cancro"),
            keywords: &["Cancro", "Segno zodiacale del Cancro", "zodiaco"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("かに座"),
            keywords: &["かに座", "星座", "蟹座"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("Lintang Cancer"),
            keywords: &["Cancer", "Lintang Cancer", "palintangan", "yuyu"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("კირჩხიბი"),
            keywords: &["ზოდიაქო", "კიბო", "კიბორჩხალა", "კირჩხიბი", "ჰოროსკოპი"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("Afurray"),
            keywords: &["Afurray"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("шаян белгісі"),
            keywords: &["зодиак", "шаян", "шаян белгісі"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("krebsen"),
            keywords: &["krebsen", "stjernetegn"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some(
                "សញ\u{17d2}ញាតារាសាស\u{17d2}ត\u{17d2}រអ\u{17ca}\u{17ba}រ\u{17c9}\u{17bb}បប\u{17d2}រភទទ\u{17b8}៤ ក\u{17d2}តាម",
            ),
            keywords: &[
                "ថោះ",
                "ទន\u{17d2}សាយ",
                "សញ\u{17d2}ញាតារាសាស\u{17d2}ត\u{17d2}រអ\u{17ca}\u{17ba}រ\u{17c9}\u{17bb}បប\u{17d2}រភទទ\u{17b8}៤ ក\u{17d2}តាម",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕರ\u{ccd}ಕಾಟಕ"),
            keywords: &["ಕರ\u{ccd}ಕಾಟಕ", "ರಾಶ\u{cbf}ಚಕ\u{ccd}ರ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("게자리"),
            keywords: &["게자리", "별자리"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("कर\u{94d}क"),
            keywords: &["कर\u{94d}क", "कर\u{94d}करास", "क\u{941}ल\u{94d}ली", "रास"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("бөйөн жылдызы"),
            keywords: &["бөйөн", "бөйөн жылдызы", "зодиак"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Kriibs (Stärzeechen)"),
            keywords: &["Kriibs", "Kriibs (Stärzeechen)", "Stärzeechen"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ລາສ\u{eb5}ກ\u{ebb}ດ"),
            keywords: &["ລາສ\u{eb5}", "ລາສ\u{eb5}ກ\u{ebb}ດ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("vėžys"),
            keywords: &["krabas", "vėžys", "zodiakas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("zodiaka zīme Vēzis"),
            keywords: &["vēzis", "zodiaka zīme Vēzis", "zodiaks"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("Cancer"),
            keywords: &["Cancer", "poutiriao", "pāpaka"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("хороскопски знак рак"),
            keywords: &["рак", "хороскоп", "хороскопски знак рак"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("കർക\u{d4d}കടകം"),
            keywords: &["കർക\u{d4d}കടകം", "ര\u{d3e}ശി"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("мэлхийн орд"),
            keywords: &["мэлхий", "мэлхийн орд", "орд"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("कर\u{94d}क रास"),
            keywords: &["कर\u{94d}क", "कर\u{94d}क रास", "राशी"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("Cancer"),
            keywords: &["Cancer", "ketam", "zodiak"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("Cancer"),
            keywords: &["Cancer", "granċ", "żodjaku"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ကရကဋ\u{103a}"),
            keywords: &[
                "ကရကဋ\u{103a}",
                "ကရကဋ\u{103a}ရာသ\u{102e}",
                "ဆယ\u{1037}\u{103a}န\u{103e}စ\u{103a}ရာသ\u{102e}ခ\u{103d}င\u{103a}",
                "ပ\u{102f}စ\u{103d}န\u{103a}လ\u{102f}\u{1036}းပ\u{102f}\u{1036} ကရကဋ\u{103a}ရာသ\u{102e}ရ\u{102f}ပ\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("Krepsen"),
            keywords: &["Krepsen", "krabbe", "kreps", "stjernetegn"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("कर\u{94d}कट"),
            keywords: &["कर\u{94d}कट", "राशि"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("kreeft (sterrenbeeld)"),
            keywords: &["Cancer", "dierenriem", "kreeft", "kreeft (sterrenbeeld)"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("Krepsen"),
            keywords: &["Krepsen", "krabbe", "kreps", "stjerneteikn"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("କର\u{b4d}କଟ"),
            keywords: &[
                "କଙ\u{b4d}କଡ\u{b3e} । ର\u{b3e}ଶ\u{b3f}ଚକ\u{b4d}ର",
                "କର\u{b4d}କଟ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਕਰਕ ਰਾਸ\u{a3c}ੀ"),
            keywords: &["ਕਰਕ", "ਰਾਸ\u{a3c}ੀ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ب\u{64f}رج سرطان"),
            keywords: &["اخبوط", "ب\u{64f}رج", "ب\u{64f}رج سرطان"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Kánsa"),
            keywords: &["Krab", "Kánsa", "Zódiak"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("Rak"),
            keywords: &["Rak", "rak", "znak zodiaku", "zodiak"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د سرطان ناروغي"),
            keywords: &["د سرطان ناروغي", "سرطان", "مرغوم", "کوني ګبر"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("signo de Câncer"),
            keywords: &["caranguejo", "câncer", "signo de Câncer", "zodíaco"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("Caranguejo"),
            keywords: &["Caranguejo", "signo"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("Cancer"),
            keywords: &["Cancer", "apanqura", "zodiaco"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("zodia Rac"),
            keywords: &["rac", "zodia Rac", "zodiac", "zodie"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-067"),
            keywords: &["E10-067"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("знак зодиака Рак"),
            keywords: &["знак", "знак зодиака Рак", "зодиак", "рак"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("Kanseri"),
            keywords: &["Kanseri", "karabu", "zodiyake"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("برج سرطان"),
            keywords: &["برج سرطان", "راس چڪر", "سرطان"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("කටක"),
            keywords: &["කටක", "කටක ර\u{dcf}ශ\u{dd2}ය"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("znamenie raka"),
            keywords: &["rak", "znamenie raka", "zverokruh"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("rak"),
            keywords: &["rak", "zodiak"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("naaf"),
            keywords: &["carsaanyo", "mactab meecaad", "naaf"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("gaforrja"),
            keywords: &["gaforre", "gaforrja", "zodiak"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("рак у хороскопу"),
            keywords: &["зoдиjaк", "рaк", "рак у хороскопу"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("rak u horoskopu"),
            keywords: &["rak", "rak u horoskopu", "zodijak"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("Kräftan"),
            keywords: &["Kräftan", "stjärntecken"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("nyota ya kaa"),
            keywords: &["nyota ya kaa", "zodiaki"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("கடகம\u{bcd}"),
            keywords: &[
                "இர\u{bbe}சி",
                "கடகம\u{bcd}",
                "நட\u{bcd}சத\u{bcd}திரம\u{bcd}",
                "ர\u{bbe}சி",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("కర\u{c4d}క\u{c3e}టకర\u{c3e}శ\u{c3f}"),
            keywords: &["కర\u{c4d}క\u{c3e}టకర\u{c3e}శ\u{c3f}", "చక\u{c4d}రం"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("Саратон"),
            keywords: &["Саратон", "ақраб", "бурҷи дувоздаҳгона"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ราศ\u{e35}กรกฎ"),
            keywords: &["จ\u{e31}กรราศ\u{e35}", "ราศ\u{e35}กรกฎ"],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("መንሽሮ"),
            keywords: &["መንሽሮ", "መንሾ", "ክሮብ", "ዞድያክ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("Seretan"),
            keywords: &["Seretan", "leňňeç", "täleýnama"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("ʻUo (pupunga)"),
            keywords: &["paka", "pupunga", "ʻUo (pupunga)", "ʻuo"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("yengeç burcu"),
            keywords: &["burçlar", "yengeç burcu"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("سەرەتان"),
            keywords: &["سەرەتان", "قىسقۇچپاقا", "مۆچەل"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("Рак"),
            keywords: &["Рак", "зодіак", "краб"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("برج سرطان"),
            keywords: &["برج", "برج سرطان", "کيکڑا"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("qisqichbaqa burji"),
            keywords: &["burj", "qisqichbaqa", "qisqichbaqa burji"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("Cự Giải"),
            keywords: &["Cự Giải", "con cua", "cung hoàng đạo"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("Kàŋseer"),
            keywords: &["Kàŋseer", "junxoob", "sojak"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("I-Cancer"),
            keywords: &["I-Cancer", "i-zodiac", "unonkala"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Cancer"),
            keywords: &["Cancer", "akàn", "àmi oṣù ìbí"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("巨蟹座"),
            keywords: &["巨蟹座", "星座", "蟹"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("巨蟹座"),
            keywords: &["巨蟹座", "星座", "蟹"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("巨蟹座"),
            keywords: &["巨蟹座", "星座", "螃蟹"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("巨蟹座"),
            keywords: &["巨蟹座", "星座"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("cancer"),
            keywords: &["cancer", "inkalankala", "inkanyezi"],
        },
    ],
};
#[doc = "♌"]
pub const LEO: crate::Emoji = crate::Emoji {
    glyph: "♌",
    codepoint: "264C",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "Leo",
    group: "Symbols",
    subgroup: "zodiac",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("Leeu-sterrebeeld"),
            keywords: &["Leeu-sterrebeeld", "diereriem", "leeu"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ሊዮ"),
            keywords: &["ሊዮ", "አንበሳ", "ዞዲያክ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("الأسد"),
            keywords: &["الأبراج", "الأسد"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("সিংহ ৰ\u{9be}শি"),
            keywords: &["সিংহ", "সিংহ ৰ\u{9be}শি", "ৰ\u{9be}শিচক\u{9cd}ৰ"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("şir"),
            keywords: &["aslan", "zodiak", "şir"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("знак задыяка Леў"),
            keywords: &["задыяк", "знак задыяка Леў", "леў"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Зодиакален знак лъв"),
            keywords: &[
                "Зодиакален знак лъв",
                "зодиак",
                "зодиакален знак",
                "зодия",
                "лъв",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("সিংহ র\u{9be}শি"),
            keywords: &["র\u{9be}শিচক\u{9cd}র", "সিংহ", "সিংহ র\u{9be}শি"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("al Leon"),
            keywords: &["Leo", "Leon", "al Leon", "zodiak"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("lav"),
            keywords: &["horoskop", "lav", "znak", "zodijak"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("Lleó"),
            keywords: &["Lleó", "zodíac"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎵᏲ"),
            keywords: &["ᎵᏲ", "ᏃᏈᏏ ᏓᏟᎶᏍᏗᎲᎢ", "ᏢᏓᏥ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("lev"),
            keywords: &["lev", "zvěrokruh"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("y Llew"),
            keywords: &["llew", "sidydd", "y Llew"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("løven"),
            keywords: &["løven", "stjernetegn"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Löwe (Sternzeichen)"),
            keywords: &["Löwe", "Löwe (Sternzeichen)", "Sternzeichen"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("Λέων"),
            keywords: &["Λέων", "ζώδιο", "λιοντάρι"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("Leo"),
            keywords: &["Leo", "lion", "zodiac"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("Leo"),
            keywords: &["Leo", "leo", "león", "zodiaco"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["Leo", "leo", "león", "zodíaco"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("Lõvi"),
            keywords: &["Lõvi", "sodiaak"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("leo"),
            keywords: &["leo", "leoi", "zodiako"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("برج اسد"),
            keywords: &["اسد", "برج", "مرداد"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("leijona-merkki"),
            keywords: &[
                "horoskooppi",
                "horoskooppimerkki",
                "leijona",
                "leijona-merkki",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("Leo"),
            keywords: &["Leo", "leon", "zodiac"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("Ljónið"),
            keywords: &["Ljónið", "leyva", "ljónsmerkið", "stjørnumerki"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("lion"),
            keywords: &["lion", "zodiaque"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("Lion"),
            keywords: &["Lion", "zodiaque"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("an Leon"),
            keywords: &["Leo", "an Leon", "stoidiaca"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("An Leòmhann"),
            keywords: &[
                "An Leòmhann",
                "grian-chrios",
                "grian-chriosach",
                "leo",
                "leòmhann",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("León"),
            keywords: &["Leo", "León", "león", "zodíaco"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("સિ\u{a82}હ"),
            keywords: &["રાશિચક\u{acd}ર", "સિ\u{a82}હ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("Leo"),
            keywords: &["Leo", "zaki", "zodiac"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("מזל אריה"),
            keywords: &["אריה", "גלגל המזלות", "מזל"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("सि\u{902}ह"),
            keywords: &["राशि", "सि\u{902}ह", "सि\u{902}ह, राशि"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("astrološki znak lava"),
            keywords: &["astrološki znak lava", "lav", "zodijak"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("oroszlán csillagjegy"),
            keywords: &["horoszkóp", "oroszlán", "oroszlán csillagjegy"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("Առյուծ"),
            keywords: &["Առյուծ", "կենդանակերպ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("Leo"),
            keywords: &["Leo", "leo", "singa", "zodiak"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("Lio"),
            keywords: &["Lio", "zodịak", "ọdụm"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("ljónið"),
            keywords: &["ljón", "ljónið", "stjörnumerki"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("Segno zodiacale del Leone"),
            keywords: &["Leone", "Segno zodiacale del Leone", "zodiaco"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("しし座"),
            keywords: &["しし座", "星座", "獅子座"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("Lintang Leo"),
            keywords: &["Leo", "Lintang Leo", "palintangan", "singa"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ლომი"),
            keywords: &["ზოდიაქო", "ლომი", "ჰოროსკოპი"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("Izem"),
            keywords: &["Izem"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("арыстан белгісі"),
            keywords: &["арыстан", "арыстан белгісі", "зодиак"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("løven"),
            keywords: &["løven", "stjernetegn"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some(
                "សញ\u{17d2}ញាតារាសាស\u{17d2}ត\u{17d2}រអ\u{17ca}\u{17ba}រ\u{17c9}\u{17bb}បប\u{17d2}រភទទ\u{17b8}៥ តោ",
            ),
            keywords: &[
                "នាគ",
                "រោង",
                "សញ\u{17d2}ញាតារាសាស\u{17d2}ត\u{17d2}រអ\u{17ca}\u{17ba}រ\u{17c9}\u{17bb}បប\u{17d2}រភទទ\u{17b8}៥ តោ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಸ\u{cbf}ಂಹ"),
            keywords: &["ರಾಶ\u{cbf}ಚಕ\u{ccd}ರ", "ಸ\u{cbf}ಂಹ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("사자자리"),
            keywords: &["별", "별자리", "사자", "사자자리"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("सि\u{902}ह"),
            keywords: &["रास", "शी\u{902}व", "सि\u{902}ह", "सि\u{902}हरास"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("арстан"),
            keywords: &["арстан", "зодиак"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Léif"),
            keywords: &["Léif", "Stärzeechen"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ລາສ\u{eb5}ສ\u{eb4}ງ"),
            keywords: &["ລາສ\u{eb5}", "ລາສ\u{eb5}ສ\u{eb4}ງ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("liūtas"),
            keywords: &["liūtas", "zodiakas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("zodiaka zīme Lauva"),
            keywords: &["lauva", "zodiaka zīme Lauva", "zodiaks"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("Leo"),
            keywords: &["Leo", "poutiriao", "raiona"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("хороскопски знак лав"),
            keywords: &["лав", "хороскоп", "хороскопски знак лав"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ചിങ\u{d4d}ങം"),
            keywords: &["ചിങ\u{d4d}ങം", "ര\u{d3e}ശി"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("Арслангийн орд"),
            keywords: &["Арслангийн орд", "арслан", "орд"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("सि\u{902}ह रास"),
            keywords: &["रास", "सि\u{902}ह"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("Leo"),
            keywords: &["Leo", "singa", "zodiak"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("Leo"),
            keywords: &["Leo", "iljun", "żodjaku"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("သ\u{102d}ဟ\u{103a}"),
            keywords: &[
                "ခြင\u{103a}\u{1039}သေ\u{1037}ပ\u{102f}\u{1036} သ\u{102d}ဟ\u{103a}ရာသ\u{102e}ရ\u{102f}ပ\u{103a}",
                "ဆယ\u{1037}\u{103a}န\u{103e}စ\u{103a}ရာသ\u{102e}ခ\u{103d}င\u{103a}",
                "သ\u{102d}ဟ\u{103a}",
                "သ\u{102d}ဟ\u{103a}ရာသ\u{102e}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("Løven"),
            keywords: &["Løven", "løve", "stjernetegn"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("सि\u{902}ह"),
            keywords: &["राशि", "सि\u{902}ह"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("leeuw (sterrenbeeld)"),
            keywords: &["Leo", "dierenriem", "leeuw", "leeuw (sterrenbeeld)"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("Løva"),
            keywords: &["Løva", "løve", "stjerneteikn"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ସ\u{b3f}ଂହର\u{b3e}ଶ\u{b3f}"),
            keywords: &[
                "ସ\u{b3f}ଂହ",
                "ସ\u{b3f}ଂହ । ର\u{b3e}ଶ\u{b3f}ଚକ\u{b4d}ର",
                "ସ\u{b3f}ଂହର\u{b3e}ଶ\u{b3f}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਸਿ\u{a70}ਗ ਰਾਸ\u{a3c}ੀ"),
            keywords: &["ਰਾਸ\u{a3c}ੀ", "ਸਿ\u{a70}ਗ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ب\u{64f}رج اسد"),
            keywords: &["ب\u{64f}رج", "ب\u{64f}رج اسد", "شیر"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Lío"),
            keywords: &["Láyọn", "Lío", "Zódiak"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("Lew"),
            keywords: &["Lew", "lew", "znak zodiaku", "zodiak"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("اسد"),
            keywords: &["اسد", "شير", "مرغومی"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("signo de Leão"),
            keywords: &["leão", "signo de Leão", "zodíaco"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("Leão"),
            keywords: &["Leão", "signo"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("Leo"),
            keywords: &["Leo", "leon", "zodiaco"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("zodia Leu"),
            keywords: &["leu", "zodia Leu", "zodiac", "zodie"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-068"),
            keywords: &["E10-068"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("знак зодиака Лев"),
            keywords: &["знак", "знак зодиака Лев", "зодиак", "лев"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("Lewo"),
            keywords: &["Lewo", "intare", "zodiyake"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("برج اسد"),
            keywords: &["برج اسد", "راس چڪر", "شينهن"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ස\u{dd2}ංහ"),
            keywords: &["ර\u{dcf}ශ\u{dd2}ය", "ස\u{dd2}ංහ"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("znamenie leva"),
            keywords: &["lev", "znamenie leva", "zverokruh"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("zodiak: lev"),
            keywords: &["lev", "zodiak", "zodiak: lev"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("boqorka libaaxa"),
            keywords: &["boqorka libaaxa", "libaax", "mactab meecaad"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("luani"),
            keywords: &["luan", "luani", "zodiak"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("лав у хороскопу"),
            keywords: &["зoдиjaк", "лaв", "лав у хороскопу"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("lav u horoskopu"),
            keywords: &["lav", "lav u horoskopu", "zodijak"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("Lejonet"),
            keywords: &["Lejonet", "stjärntecken"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("nyota ya simba"),
            keywords: &["nyota ya simba", "simba", "zodiaki"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("சிம\u{bcd}மம\u{bcd}"),
            keywords: &[
                "இர\u{bbe}சி",
                "சிம\u{bcd}மம\u{bcd}",
                "நட\u{bcd}சத\u{bcd}திரம\u{bcd}",
                "ர\u{bbe}சி",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("స\u{c3f}ంహర\u{c3e}శ\u{c3f}"),
            keywords: &["చక\u{c4d}రం", "స\u{c3f}ంహర\u{c3e}శ\u{c3f}"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("Асад"),
            keywords: &["Асад", "бурҷи дувоздаҳгона", "шер"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ราศ\u{e35}ส\u{e34}งห\u{e4c}"),
            keywords: &["จ\u{e31}กรราศ\u{e35}", "ราศ\u{e35}ส\u{e34}งห\u{e4c}"],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ሌዮ"),
            keywords: &["ሊዮ", "ሌዮ", "ኣንበሳ", "ዞድያክ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("Şir"),
            keywords: &["täleýnama", "ýolbars", "Şir"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("Laione (pupunga)"),
            keywords: &["Laione (pupunga)", "laione", "pupunga"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("aslan burcu"),
            keywords: &["aslan burcu", "burçlar"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("شىر"),
            keywords: &["شىر", "مۆچەل"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("Лев (знак зодіаку)"),
            keywords: &["Лев", "Лев (знак зодіаку)", "зодіак"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("برج اسد"),
            keywords: &["برج", "برج اسد", "شیر"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("arslon burji"),
            keywords: &["arslon burji", "asrlon", "burj"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("Sư Tử"),
            keywords: &["Sư Tử", "cung hoàng đạo", "sư tử"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("Gaynde"),
            keywords: &["Gaynde", "lion", "sojak"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("I-Leo"),
            keywords: &["I-Leo", "i-zodiac", "ingonyama"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Leo"),
            keywords: &["Leo", "kìnìhún", "àmi oṣù ìbí"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("獅子座"),
            keywords: &["星座", "獅子", "獅子座"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("狮子座"),
            keywords: &["星座", "狮子", "狮子座"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("狮子座"),
            keywords: &["星座", "狮子座", "雄狮"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("獅子座"),
            keywords: &["星座", "獅子座"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("leo"),
            keywords: &["ibhubesi", "inkanyezi", "leo"],
        },
    ],
};
#[doc = "♍"]
pub const VIRGO: crate::Emoji = crate::Emoji {
    glyph: "♍",
    codepoint: "264D",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "Virgo",
    group: "Symbols",
    subgroup: "zodiac",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("Maagd-sterrebeeld"),
            keywords: &["Maagd-sterrebeeld", "diereriem"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ቪርጎ"),
            keywords: &["ቪርጎ", "ኮረዳ", "ዞዲያክ", "ድንግል"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("العذراء"),
            keywords: &["الأبراج", "العذراء"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("কন\u{9cd}য\u{9be} ৰ\u{9be}শি"),
            keywords: &["কন\u{9cd}য\u{9be} ৰ\u{9be}শি", "ৰ\u{9be}শিচক\u{9cd}ৰ"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("qız"),
            keywords: &["bakirə", "qız", "zodiak"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("знак задыяка Дзева"),
            keywords: &["дзева", "задыяк", "знак задыяка Дзева"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Зодиакален знак дева"),
            keywords: &[
                "Зодиакален знак дева",
                "дева",
                "зодиак",
                "зодиакален знак",
                "зодия",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("কন\u{9cd}য\u{9be}"),
            keywords: &[
                "কন\u{9cd}য\u{9be}",
                "ক\u{9c1}ম\u{9be}রী",
                "র\u{9be}শিচক\u{9cd}র",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("ar Wercʼhez"),
            keywords: &["Gwercʼhez", "Vir", "ar Wercʼhez", "zodiak"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("djevica"),
            keywords: &["djevica", "horoskop", "znak", "zodijak"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("Verge"),
            keywords: &["Verge", "Virgo", "zodíac"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏇᎵᎪ"),
            keywords: &["ᏃᏈᏏ ᏓᏟᎶᏍᏗᎲᎢ", "ᏇᎵᎪ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("panna"),
            keywords: &["panna", "zvěrokruh"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("y Forwyn"),
            keywords: &["morwyn", "sidydd", "y Forwyn"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("jomfruen"),
            keywords: &["jomfruen", "stjernetegn"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Jungfrau (Sternzeichen)"),
            keywords: &["Jungfrau", "Jungfrau (Sternzeichen)", "Sternzeichen"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("Παρθένος"),
            keywords: &["Παρθένος", "ζώδιο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("Virgo"),
            keywords: &["Virgo", "zodiac"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["Virgo", "virgin", "zodiac"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("Virgo"),
            keywords: &["Virgo", "virgo", "zodiaco"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["Virgo", "virgen", "virgo", "zodíaco"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("Neitsi"),
            keywords: &["Neitsi", "sodiaak"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("virgo"),
            keywords: &["birjina", "ezkongabe", "virgo", "zodiako"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("برج سنبله"),
            keywords: &["برج", "سنبله", "شهریور"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("neitsyt-merkki"),
            keywords: &[
                "horoskooppi",
                "horoskooppimerkki",
                "neitsyt",
                "neitsyt-merkki",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("Virgo"),
            keywords: &["Virgo", "zodiac"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("Moyggin"),
            keywords: &["Moyggin", "moyarmerkið", "moyggj", "stjørnumerki"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("vierge"),
            keywords: &["vierge", "zodiaque"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("Vierge"),
            keywords: &["Vierge", "zodiaque"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("an Mhaighdean"),
            keywords: &["Virgo", "an Mhaighdean", "stoidiaca"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("A’ Mhaighdeann"),
            keywords: &[
                "A’ Mhaighdeann",
                "crian-chriosach",
                "grian-chrios",
                "maighdeann",
                "virgo",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("Virgo"),
            keywords: &["Virgo", "virxe", "zodíaco"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("કન\u{acd}યા"),
            keywords: &["કન\u{acd}યા", "રાશિચક\u{acd}ર"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("Virgo"),
            keywords: &["Virgo", "zodiac"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("מזל בתולה"),
            keywords: &["בתולה", "גלגל המזלות", "מזל"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("कन\u{94d}या"),
            keywords: &["कन\u{94d}या", "कन\u{94d}या, राशि", "राशि"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("astrološki znak djevice"),
            keywords: &["astrološki znak djevice", "djevica", "zodijak"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("szűz csillagjegy"),
            keywords: &["horoszkóp", "szűz", "szűz csillagjegy"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("Կույս"),
            keywords: &["Կույս", "կենդանակերպ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("Virgo"),
            keywords: &["Virgo", "zodiak"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("Vigo"),
            keywords: &["Vigo", "zodịak"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("meyja"),
            keywords: &["meyja", "stjörnumerki"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("Segno zodiacale della Vergine"),
            keywords: &["Segno zodiacale della Vergine", "Vergine", "zodiaco"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("おとめ座"),
            keywords: &["おとめ座", "乙女座", "星座"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("Lintang Virgo"),
            keywords: &["Lintang Virgo", "Virgo", "palintangan"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ქალწული"),
            keywords: &["ზოდიაქო", "ქალიშვილი", "ქალწული", "ჰოროსკოპი"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("Taḥbayrit"),
            keywords: &["Taḥbayrit"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("бикеш белгісі"),
            keywords: &["бикеш", "бикеш белгісі", "зодиак", "қыз"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("jomfruen"),
            keywords: &["jomfruen", "stjernetegn"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some(
                "សញ\u{17d2}ញាតារាសាស\u{17d2}ត\u{17d2}រអ\u{17ca}\u{17ba}រ\u{17c9}\u{17bb}បប\u{17d2}រភទទ\u{17b8}៦ ស\u{17d2}ត\u{17b8}\u{17d2}រក\u{17d2}រម\u{17bb}\u{17c6}",
            ),
            keywords: &[
                "ពស\u{17cb}",
                "ម\u{17d2}សាញ\u{17cb}",
                "សញ\u{17d2}ញាតារាសាស\u{17d2}ត\u{17d2}រអ\u{17ca}\u{17ba}រ\u{17c9}\u{17bb}បប\u{17d2}រភទទ\u{17b8}៦ ស\u{17d2}ត\u{17b8}\u{17d2}រក\u{17d2}រម\u{17bb}\u{17c6}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕನ\u{ccd}ಯಾರಾಶ\u{cbf}"),
            keywords: &["ಕನ\u{ccd}ಯಾರಾಶ\u{cbf}", "ರಾಶ\u{cbf}ಚಕ\u{ccd}ರ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("처녀자리"),
            keywords: &["별", "별자리", "처녀", "처녀자리"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("कन\u{94d}या"),
            keywords: &["कन\u{94d}या", "कन\u{94d}यारास", "रास"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("бийкеч"),
            keywords: &["бийкеч", "зодиак"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Jongfra"),
            keywords: &["Jongfra", "Stärzeechen"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ລາສ\u{eb5}ກ\u{eb1}ນ"),
            keywords: &["ລາສ\u{eb5}", "ລາສ\u{eb5}ກ\u{eb1}ນ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("mergelė"),
            keywords: &["mergelė", "zodiakas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("zodiaka zīme Jaunava"),
            keywords: &["jaunava", "zodiaka zīme Jaunava", "zodiaks"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("Virgo"),
            keywords: &["Virgo", "poutiriao"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("хороскопски знак девица"),
            keywords: &["девица", "хороскоп", "хороскопски знак девица"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("കന\u{d4d}നി"),
            keywords: &["കന\u{d4d}നി", "ര\u{d3e}ശി"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("Охины орд"),
            keywords: &["Охины орд", "орд"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("कन\u{94d}या रास"),
            keywords: &["कन\u{94d}या", "कन\u{94d}या रास"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("Virgo"),
            keywords: &["Virgo", "anak dara", "perempuan muda", "zodiak"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("Virgo"),
            keywords: &["Virgo", "żodjaku"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ကန\u{103a}"),
            keywords: &[
                "ကန\u{103a}",
                "ကန\u{103a}ရာသ\u{102e}",
                "ဆယ\u{1037}\u{103a}န\u{103e}စ\u{103a}ရာသ\u{102e}ခ\u{103d}င\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("Jomfruen"),
            keywords: &["Jomfruen", "stjernetegn"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("कन\u{94d}या"),
            keywords: &["कन\u{94d}या", "क\u{941}मारी", "राशि"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("maagd (sterrenbeeld)"),
            keywords: &["Virgo", "dierenriem", "maagd (sterrenbeeld)"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("Jomfrua"),
            keywords: &["Jomfrua", "stjerneteikn"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("କନ\u{b4d}ୟ\u{b3e}"),
            keywords: &["କନ\u{b4d}ୟ\u{b3e}", "ର\u{b3e}ଶ\u{b3f}ଚକ\u{b4d}ର"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਕ\u{a70}ਨਿਆ ਰਾਸ\u{a3c}ੀ"),
            keywords: &["ਕ\u{a70}ਨਿਆ", "ਰਾਸ\u{a3c}ੀ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ب\u{64f}رج سنبلہ"),
            keywords: &["ب\u{64f}رج", "ب\u{64f}رج سنبلہ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Vẹ\u{301}go"),
            keywords: &["Vẹ\u{301}go", "Zódiak"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("Panna"),
            keywords: &["Panna", "panna", "znak zodiaku", "zodiak"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("زاڼه"),
            keywords: &["زاڼه", "مرغومی"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("signo de Virgem"),
            keywords: &["signo de Virgem", "virgem", "zodíaco"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("Virgem"),
            keywords: &["Virgem", "signo"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("Virgo"),
            keywords: &["Virgo", "zodiaco"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("zodia Fecioară"),
            keywords: &["fecioară", "zodia Fecioară", "zodiac", "zodie"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-069"),
            keywords: &["E10-069"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("знак зодиака Дева"),
            keywords: &["дева", "знак", "знак зодиака Дева", "зодиак"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("Virigo"),
            keywords: &["Virigo", "zodiyaki"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("برج سنبله"),
            keywords: &["برج سنبله", "بروجي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("කන\u{dca}\u{200d}ය\u{dcf}"),
            keywords: &[
                "කන\u{dca}\u{200d}ය\u{dcf}",
                "කන\u{dca}\u{200d}ය\u{dcf}ව",
                "ර\u{dcf}ශ\u{dd2}ය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("znamenie panny"),
            keywords: &["panna", "znamenie panny", "zverokruh"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("devica"),
            keywords: &["deva", "devica", "zodiak"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("afaggaal"),
            keywords: &["afaggaal", "mactab meecaad"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("virgjëresha"),
            keywords: &["vajzë", "virgjëresha", "virgjëreshë", "zodiak"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("девица у хороскопу"),
            keywords: &["дeвицa", "девица у хороскопу", "зoдиjaк"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("дјевица у хороскопу"),
            keywords: &["дјевица у хороскопу"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("devica u horoskopu"),
            keywords: &["devica", "devica u horoskopu", "zodijak"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("djevica u horoskopu"),
            keywords: &["djevica u horoskopu"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("Jungfrun"),
            keywords: &["Jungfrun", "stjärntecken"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mashuke"),
            keywords: &["bikira", "mashuke", "mwali", "zodiaki"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("கன\u{bcd}னி"),
            keywords: &[
                "இர\u{bbe}சி",
                "கன\u{bcd}னி",
                "நட\u{bcd}சத\u{bcd}திரம\u{bcd}",
                "ர\u{bbe}சி",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("కన\u{c4d}య\u{c3e}ర\u{c3e}శ\u{c3f}"),
            keywords: &["కన\u{c4d}య\u{c3e}ర\u{c3e}శ\u{c3f}", "చక\u{c4d}రం"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("Сунбула"),
            keywords: &["Сунбула", "бурҷи дувоздаҳгона"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ราศ\u{e35}ก\u{e31}นย\u{e4c}"),
            keywords: &["จ\u{e31}กรราศ\u{e35}", "ราศ\u{e35}ก\u{e31}นย\u{e4c}"],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ቪርጎ"),
            keywords: &["ቪርጎ", "ዞድያክ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("Sünbüle"),
            keywords: &["Sünbüle", "zodiak"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("Taupoʻou (pupunga)"),
            keywords: &["Taupoʻou (pupunga)", "pupunga", "taupoʻou"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("başak burcu"),
            keywords: &["başak burcu", "burçlar"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("بۇغدايباش"),
            keywords: &["بۇغدايباش", "مۆچەل"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("Діва"),
            keywords: &["Діва", "зодіак"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("برج سنبلہ"),
            keywords: &["برج", "برج سنبلہ", "عورت"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("parizod burji"),
            keywords: &["burj", "parizod", "parizod burji"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("Xử Nữ"),
            keywords: &["Xử Nữ", "cung hoàng đạo"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("Wiyerse"),
            keywords: &["Wiyerse", "sojak"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("I-Virgo"),
            keywords: &["I-Virgo", "i-zodiac"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Virgo"),
            keywords: &["Virgo", "àmi oṣù ìbí"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("處女座"),
            keywords: &["星座", "處女座"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("处女座"),
            keywords: &["处女座", "星座"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("处女座"),
            keywords: &["处女座", "星座", "黄道十二宫"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("處女座"),
            keywords: &["星座", "處女座"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("virgo"),
            keywords: &["inkanyezi", "intombi", "virgo"],
        },
    ],
};
#[doc = "♎"]
pub const LIBRA: crate::Emoji = crate::Emoji {
    glyph: "♎",
    codepoint: "264E",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "Libra",
    group: "Symbols",
    subgroup: "zodiac",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("Weegskaal-sterrebeeld"),
            keywords: &[
                "Weegskaal-sterrebeeld",
                "balans",
                "diereriem",
                "geregtigheid",
                "skaal",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ሊብራ"),
            keywords: &["ሊብራ", "ሚዛን", "ዞዲያክ", "የተመጣጠነ", "ፍትሕ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("الميزان"),
            keywords: &["الأبراج", "الميزان"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ত\u{9c1}ল\u{9be} ৰ\u{9be}শি"),
            keywords: &[
                "ত\u{9c1}ল\u{9be} ৰ\u{9be}শি",
                "ন\u{9cd}য\u{9be}য\u{9bc}",
                "ন\u{9cd}য\u{9be}য\u{9bc}ৰ ত\u{9c1}ল\u{9be}চনী",
                "ৰ\u{9be}শিচক\u{9cd}ৰ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("tərəzi"),
            keywords: &["balans", "tərəzi", "zodiak", "ədalət"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("знак задыяка Шалі"),
            keywords: &[
                "баланс",
                "задыяк",
                "знак задыяка Шалі",
                "правасуддзе",
                "шалі",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Зодиакален знак везни"),
            keywords: &[
                "Зодиакален знак везни",
                "везни",
                "зодиак",
                "зодиакален знак",
                "зодия",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ত\u{9c1}ল\u{9be}"),
            keywords: &[
                "ত\u{9c1}ল\u{9be}",
                "বিচ\u{9be}র",
                "ভ\u{9be}রস\u{9be}ম\u{9cd}য",
                "র\u{9be}শিচক\u{9cd}র",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("ar Balañsoù"),
            keywords: &["Balañsoù", "Lib", "ar Balañsoù", "zodiak"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("znak vaga"),
            keywords: &["horoskop", "znak", "znak vaga", "zodijak"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("Balança"),
            keywords: &["Balança", "bàscula", "justícia", "zodíac"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎵᏆ"),
            keywords: &["ᎢᎦᏘᎭ", "ᎵᏆ", "ᏃᏈᏏ ᏓᏟᎶᏍᏗᎲᎢ", "ᏗᎦᏛᏗ", "ᏗᎧᎿᏩᏛᏍᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("váhy"),
            keywords: &["rovnováha", "spravedlnost", "váha", "váhy", "zvěrokruh"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("y Fantol"),
            keywords: &["clorian", "cyfiawnder", "mantol", "sidydd", "y Fantol"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("vægten"),
            keywords: &["stjernetegn", "vægten"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Waage (Sternzeichen)"),
            keywords: &["Sternzeichen", "Waage", "Waage (Sternzeichen)"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("Ζυγός"),
            keywords: &["Ζυγός", "δικαιοσύνη", "ζυγαριά", "ζώδιο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("Libra"),
            keywords: &["Libra", "balance", "justice", "scales", "zodiac"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("Libra"),
            keywords: &["Libra", "balanza", "escala", "justicia", "libra", "zodiaco"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("Libra"),
            keywords: &["Libra", "balanza", "justicia", "libra", "zodíaco"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("Kaalud"),
            keywords: &["Kaalud", "sodiaak"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("libra"),
            keywords: &["balantza", "justizia", "libra", "oreka", "zodiako"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("برج میزان"),
            keywords: &["برج", "مهر", "میزان"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("vaaka-merkki"),
            keywords: &["horoskooppi", "horoskooppimerkki", "vaaka", "vaaka-merkki"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("Libra"),
            keywords: &["Libra", "balanse", "hustisya", "timbangan", "zodiac"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("Vágin"),
            keywords: &["Vágin", "stjørnumerki", "vekt", "vágmerkið", "vágskál"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("balance"),
            keywords: &["balance", "zodiaque"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("Balance"),
            keywords: &["Balance", "zodiaque"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("an Mheá"),
            keywords: &["Libra", "an Mheá", "stoidiaca"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("A’ Mheidh"),
            keywords: &[
                "A’ Mheidh",
                "britheamh",
                "cothrom",
                "cuideam",
                "grian-chrios",
                "grian-chriosach",
                "libra",
                "meidh",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("Libra"),
            keywords: &["Libra", "balanza", "zodíaco"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ત\u{ac1}લા"),
            keywords: &["ત\u{ac1}લા", "રાશિચક\u{acd}ર"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("Libra"),
            keywords: &["Libra", "adalci", "daidaito", "sikeloli", "zodiac"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("מזל מאזניים"),
            keywords: &["גלגל המזלות", "מאזניים", "מזל", "משפט", "צדק"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("त\u{941}ला"),
            keywords: &["त\u{941}ला", "त\u{941}ला, राशि", "राशि"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("astrološki znak vage"),
            keywords: &["astrološki znak vage", "vaga", "zodijak"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("mérleg csillagjegy"),
            keywords: &["horoszkóp", "mérleg", "mérleg csillagjegy"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("Կշեռք"),
            keywords: &[
                "Կշեռք",
                "արդարադատություն",
                "կենդանակերպ",
                "հավասարակշռություն",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("Libra"),
            keywords: &["Libra", "adil", "libra", "seimbang", "timbangan", "zodiak"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("Libra"),
            keywords: &["Libra", "ikpe kwụọtọ", "nhatanha", "nsalọ", "zodịak"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("vogin"),
            keywords: &["stjörnumerki", "vog", "vogin"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("Segno zodiacale della Bilancia"),
            keywords: &["Bilancia", "Segno zodiacale della Bilancia", "zodiaco"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("てんびん座"),
            keywords: &["てんびん座", "天秤座", "星座"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("Lintang Libra"),
            keywords: &[
                "Libra",
                "Lintang Libra",
                "adil",
                "imbang",
                "palintangan",
                "timbangan",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("სასწორი"),
            keywords: &["ზოდიაქო", "სამართლიანობა", "სასწორი", "ჰოროსკოპი"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("Tacihant"),
            keywords: &["Tacihant"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("таразы белгісі"),
            keywords: &["зодиак", "сот", "таразы", "таразы белгісі", "тепетеңдік"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("vægten"),
            keywords: &["stjernetegn", "vægten"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some(
                "សញ\u{17d2}ញាតារាសាស\u{17d2}ត\u{17d2}រអ\u{17ca}\u{17ba}រ\u{17c9}\u{17bb}បប\u{17d2}រភទទ\u{17b8}៧ ជញ\u{17d2}ជ\u{17b8}ងថ\u{17d2}ល\u{17b9}ង",
            ),
            keywords: &[
                "មម\u{17b8}",
                "សញ\u{17d2}ញាតារាសាស\u{17d2}ត\u{17d2}រអ\u{17ca}\u{17ba}រ\u{17c9}\u{17bb}បប\u{17d2}រភទទ\u{17b8}៧ ជញ\u{17d2}ជ\u{17b8}ងថ\u{17d2}ល\u{17b9}ង",
                "សេះ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ತುಲಾ"),
            keywords: &["ತುಲಾ", "ರಾಶ\u{cbf}ಚಕ\u{ccd}ರ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("천칭자리"),
            keywords: &["별", "별자리", "천칭", "천칭자리"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("त\u{941}ळ"),
            keywords: &[
                "तागडी",
                "त\u{941}ळ",
                "त\u{941}ळरास",
                "न\u{94d}याय",
                "रास",
                "समतोल",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("тараза жылдызы"),
            keywords: &["адилеттик", "зодиак", "тараза", "тараза жылдызы"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Wo (Stärzeechen)"),
            keywords: &[
                "Geriicht",
                "Justiz",
                "Stärzeechen",
                "Wo",
                "Wo (Stärzeechen)",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ລາສ\u{eb5}ຕ\u{eb8}ລາ"),
            keywords: &["ລາສ\u{eb5}", "ລາສ\u{eb5}ຕ\u{eb8}ລາ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("svarstyklės"),
            keywords: &["pusiausvyra", "svarstyklės", "teisingumas", "zodiakas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("zodiaka zīme Svari"),
            keywords: &["svari", "zodiaka zīme Svari", "zodiaks"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("Libra"),
            keywords: &["Libra", "poutiriao", "whakawā", "whārite", "ōrite"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("хороскопски знак вага"),
            keywords: &["вага", "хороскоп", "хороскопски знак вага"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ത\u{d41}ല\u{d3e}ം"),
            keywords: &["ത\u{d41}ല\u{d3e}ം", "ര\u{d3e}ശി"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("Жинлүүрийн орд"),
            keywords: &["Жинлүүрийн орд", "жинлүүр", "жинлүүрийн орд", "орд"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("त\u{942}ळ रास"),
            keywords: &[
                "त\u{942}ळ रास",
                "न\u{94d}याय",
                "पारदर\u{94d}शकता",
                "मोजण\u{947}",
                "रास",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("Libra"),
            keywords: &["Libra", "keadilan", "kira-kira", "penimbang", "zodiak"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("Libra"),
            keywords: &["Libra", "bilanċ", "miżien", "ġustizzja", "żodjaku"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("တ\u{1030} ရာသ\u{102e}"),
            keywords: &[
                "ချ\u{102d}န\u{103a}ခ\u{103d}င\u{103a}",
                "ချ\u{102d}န\u{103a}ခ\u{103d}င\u{103a}က\u{102d}\u{102f}င\u{103a} တ\u{1030}ရာသ\u{102e}ရ\u{102f}ပ\u{103a}",
                "ဆယ\u{1037}\u{103a}န\u{103e}စ\u{103a}ရာသ\u{102e}ခ\u{103d}င\u{103a}",
                "တ\u{1030} ရာသ\u{102e}",
                "တ\u{1030}ရာသ\u{102e}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("Vekten"),
            keywords: &["Vekten", "rettferdighet", "stjernetegn", "vekt"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("त\u{941}ला"),
            keywords: &[
                "त\u{941}ला",
                "न\u{94d}याय",
                "राशि",
                "सन\u{94d}त\u{941}लन",
                "स\u{94d}क\u{947}ल",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("weegschaal (sterrenbeeld)"),
            keywords: &[
                "Libra",
                "balans",
                "dierenriem",
                "gerechtigheid",
                "weegschaal",
                "weegschaal (sterrenbeeld)",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("Vekta"),
            keywords: &["Vekta", "rettferd", "stjerneteikn", "vekt"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ତ\u{b41}ଳ\u{b3e}"),
            keywords: &[
                "ତ\u{b41}ଳ\u{b3e}",
                "ନ\u{b4d}ୟ\u{b3e}ୟ",
                "ଭ\u{b3e}ରସ\u{b3e}ମ\u{b4d}ୟ",
                "ର\u{b3e}ଶ\u{b3f} ଚକ\u{b4d}ର",
                "ସ\u{b4d}କେଲ\u{b4d}\u{200c}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਤ\u{a41}ਲਾ ਰਾਸ\u{a3c}ੀ"),
            keywords: &["ਇਨਸਾਫ", "ਤ\u{a41}ਲਾ", "ਤ\u{a71}ਕੜੀ", "ਰਾਸ\u{a3c}ੀ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ب\u{64f}رج میزان"),
            keywords: &["انصاف", "ب\u{64f}رج", "ب\u{64f}رج میزان", "تکڑی", "متوازن"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Líbra"),
            keywords: &["Bálans", "Jọ\u{301}stis", "Líbra", "Skel-dẹm", "Zódiak"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("Waga"),
            keywords: &["Waga", "waga", "znak zodiaku", "zodiak"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("تله"),
            keywords: &["انصاف", "ترازو", "تله", "توازن", "مرغومی"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("signo de Libra"),
            keywords: &[
                "balança",
                "justiça",
                "libra",
                "signo de Libra",
                "signo de Virgem",
                "zodíaco",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("Balança"),
            keywords: &["Balança", "signo"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("Libra"),
            keywords: &["Libra", "aysana", "justicia", "zodiaco", "ñiqichanakuna"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("zodia Balanță"),
            keywords: &["balanță", "justiție", "zodia Balanță", "zodiac", "zodie"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-070"),
            keywords: &["E10-070"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("знак зодиака Весы"),
            keywords: &["весы", "знак", "знак зодиака Весы", "зодиак"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("Libura"),
            keywords: &["Libura", "ibipimo", "kuringaniza", "ubutabera", "zodiyake"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("برج ميزان"),
            keywords: &["انصاف", "برابري", "برج ميزان", "راس چڪر", "معيار"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ත\u{dd4}ල\u{dcf}"),
            keywords: &[
                "ත\u{dd4}ලනය",
                "ත\u{dd4}ල\u{dcf}",
                "ර\u{dcf}ශ\u{dd2}ය",
                "ස\u{dcf}ධ\u{dcf}රණත\u{dca}වය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("znamenie váh"),
            keywords: &[
                "rovnováha",
                "spravodlivosť",
                "váhy",
                "znamenie váh",
                "zverokruh",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("tehnica"),
            keywords: &["pravičnost", "ravnovesje", "tehnica", "tehtnica", "zodiak"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("cutubka miisaanka"),
            keywords: &[
                "caddaalad",
                "cutubka meecaad",
                "cutubka miisaanka",
                "isku dheelitirka",
                "miisaan",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("peshorja"),
            keywords: &["drejtësi", "ekuilibër", "peshore", "peshorja", "zodiak"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("вага у хороскопу"),
            keywords: &["вaгa", "вага у хороскопу", "зoдиjaк"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("vaga u horoskopu"),
            keywords: &["vaga", "vaga u horoskopu", "zodijak"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("Vågen"),
            keywords: &["Vågen", "balans", "rättvisa", "stjärntecken"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mizani"),
            keywords: &["haki", "mizani", "pima", "zodiaki"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("துல\u{bbe}ம\u{bcd}"),
            keywords: &[
                "இர\u{bbe}சி",
                "துல\u{bbe}ம\u{bcd}",
                "நட\u{bcd}சத\u{bcd}திரம\u{bcd}",
                "ர\u{bbe}சி",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("తుల\u{c3e}ర\u{c3e}శ\u{c3f}"),
            keywords: &["చక\u{c4d}రం", "తుల\u{c3e}ర\u{c3e}శ\u{c3f}"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("Мизон"),
            keywords: &["Мизон", "адолат", "бурҷи дувоздаҳгона", "тавозун", "тарозу"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ราศ\u{e35}ต\u{e38}ลย\u{e4c}"),
            keywords: &["จ\u{e31}กรราศ\u{e35}", "ราศ\u{e35}ต\u{e38}ลย\u{e4c}"],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ሊብራ"),
            keywords: &["ሊብራ", "ምጡን", "ስካይልስ", "ዞድያክ", "ፍትሒ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("Mizan"),
            keywords: &["Mizan", "adalat", "deňagramlylyk", "terezi", "täleýnama"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("Fuatautau (pupunga)"),
            keywords: &["Fuatautau (pupunga)", "fuatautau", "pupunga"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("terazi burcu"),
            keywords: &["burçlar", "terazi burcu"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("چەل"),
            keywords: &["ئادالەت", "ئۆلچەم", "تەڭپۇڭ", "مۆچەل", "چەل"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("Терези"),
            keywords: &["Терези", "зодіак", "рівновага", "справедливість"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("برج میزان"),
            keywords: &["برج", "میزان"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("tarozi burji"),
            keywords: &["adolat", "burj", "tarozi", "tarozi burji"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("Thiên Bình"),
            keywords: &[
                "Thiên Bình",
                "cung hoàng đạo",
                "cân",
                "cân đối",
                "công bằng",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("Balaas"),
            keywords: &["Balaas", "balaas", "sojak", "yoon"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("I-Libra"),
            keywords: &[
                "I-Libra",
                "i-zodiac",
                "izikali",
                "okusesikweni",
                "ukulinganisa",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Libra"),
            keywords: &[
                "Libra",
                "Ìwọ\u{300}ntúnwò\u{329}nsì",
                "àmi oṣù ìbí",
                "ìdájó\u{329}",
                "òṣùwò\u{329}n",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("天秤座"),
            keywords: &["天秤", "天秤座", "星座", "正義", "秤"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("天秤座"),
            keywords: &["天秤", "天秤座", "星座", "正义", "秤"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("天秤座"),
            keywords: &["天秤座", "平衡", "星座", "正义"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("天秤座"),
            keywords: &["天秤座", "星座"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("libra"),
            keywords: &[
                "inkanyezi",
                "iziklali",
                "libra",
                "ubulungiswa",
                "ukulingana",
            ],
        },
    ],
};
#[doc = "♏"]
pub const SCORPIO: crate::Emoji = crate::Emoji {
    glyph: "♏",
    codepoint: "264F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "Scorpio",
    group: "Symbols",
    subgroup: "zodiac",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("Skerpioen-sterrebeeld"),
            keywords: &["Skerpioen-sterrebeeld", "diereriem", "skerpioen"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ስኮርፒዮ"),
            keywords: &["ስኮርፒዮ", "ስኮርፒዮን", "ዞዲያክ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("العقرب"),
            keywords: &["الأبراج", "العقرب"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ব\u{9c3}শ\u{9cd}চিক ৰ\u{9be}শি"),
            keywords: &[
                "ব\u{9c3}শ\u{9cd}চিক",
                "ব\u{9c3}শ\u{9cd}চিক ৰ\u{9be}শি",
                "ৰ\u{9be}শিচক\u{9cd}ৰ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("əqrəb bürcü"),
            keywords: &["zodiak", "əqrəb", "əqrəb bürcü"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("знак задыяка Скарпіён"),
            keywords: &["задыяк", "знак задыяка Скарпіён", "скарпіён"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Зодиакален знак скорпион"),
            keywords: &[
                "Зодиакален знак скорпион",
                "зодиак",
                "зодиакален знак",
                "зодия",
                "скорпион",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ব\u{9c3}শ\u{9cd}চিক"),
            keywords: &["ব\u{9c3}শ\u{9cd}চিক", "র\u{9be}শিচক\u{9cd}র"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("ar Grug"),
            keywords: &["Krug", "Sco", "ar Grug", "zodiak"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("škorpija"),
            keywords: &["horoskop", "znak", "znak škorpion", "zodijak", "škorpija"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("Escorpió"),
            keywords: &["Escorpió", "Escorpí", "zodíac"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏍᎪᏈᏴᏍ"),
            keywords: &["ᏃᏈᏏ ᏓᏟᎶᏍᏗᎲᎢ", "ᏍᎪᏈᏴᏍ", "ᏥᏍᏛᎾ ᎠᏓᏨᏍᎩ", "ᏧᏁᎵᏁ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("štír"),
            keywords: &["zvěrokruh", "štír"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("y Sgorpion"),
            keywords: &["sgorpio", "sgorpion", "sidydd", "y Sgorpion"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("skorpionen"),
            keywords: &["skorpionen", "stjernetegn"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Skorpion (Sternzeichen)"),
            keywords: &["Skorpion", "Skorpion (Sternzeichen)", "Sternzeichen"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("Σκορπιός (ζώδιο)"),
            keywords: &["Σκορπιός (ζώδιο)", "ζώδιο", "σκορπιός"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("Scorpio"),
            keywords: &["Scorpio", "scorpion", "scorpius", "zodiac"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("Scorpio"),
            keywords: &["Scorpio", "Scorpius", "scorpion", "zodiac"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("Escorpio"),
            keywords: &["Escorpio", "escorpio", "escorpión", "zodiaco"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["Escorpio", "escorpio", "escorpión", "zodíaco"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("Skorpion"),
            keywords: &["Skorpion", "sodiaak"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("scorpio"),
            keywords: &["eskorpioi", "scorpio", "zodiako"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("برج عقرب"),
            keywords: &["آبان", "برج", "عقرب"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("skorpioni-merkki"),
            keywords: &[
                "horoskooppi",
                "horoskooppimerkki",
                "skorpioni",
                "skorpioni-merkki",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("Scorpio"),
            keywords: &["Scorpio", "alakdan", "scorpion", "scorpius", "zodiac"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("Sporðdrekin"),
            keywords: &[
                "Sporðdrekin",
                "skorpión",
                "sporðdrekamerkið",
                "stjørnumerki",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("scorpion zodiaque"),
            keywords: &["scorpion zodiaque", "zodiaque"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("Scorpion zodiaque"),
            keywords: &["Scorpion", "zodiaque"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("an Scairp"),
            keywords: &["Scorpion", "Scorpius", "an Scairp", "stoidiaca"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("An Sgairp"),
            keywords: &[
                "An Sgairp",
                "grian-chrios",
                "grian-chriosach",
                "scorpio",
                "scorpius",
                "sgairp",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("Escorpión"),
            keywords: &["Escorpión", "Scorpius", "escorpión", "zodíaco"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("વ\u{ac3}શ\u{acd}ચિક"),
            keywords: &[
                "રાશિચક\u{acd}ર",
                "વ\u{ac3}શ\u{acd}ચિક",
                "સ\u{acd}કોર\u{acd}પિઅસ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("Scorpius"),
            keywords: &["Scorpius", "kunama", "scorpio", "zodiac"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("מזל עקרב"),
            keywords: &["גלגל המזלות", "מזל", "עקרב"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("व\u{943}श\u{94d}चिक"),
            keywords: &["राशि", "व\u{943}श\u{94d}चिक", "व\u{943}श\u{94d}चिक, राशि"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("astrološki znak škorpiona"),
            keywords: &["astrološki znak škorpiona", "zodijak", "škorpion"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("skorpió csillagjegy"),
            keywords: &["horoszkóp", "skorpió", "skorpió csillagjegy"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("Կարիճ"),
            keywords: &["Կարիճ", "կենդանակերպ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("Scorpio"),
            keywords: &["Scorpio", "kalajengking", "scorpio", "zodiak"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("Akpì"),
            keywords: &["Akpì", "akpị", "zodịak"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("sporðdrekinn"),
            keywords: &["sporðdreki", "sporðdrekinn", "stjörnumerki"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("Segno zodiacale dello Scorpione"),
            keywords: &["Scorpione", "Segno zodiacale dello Scorpione", "zodiaco"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("さそり座"),
            keywords: &["さそり座", "星座", "蠍座"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("Lintang Scorpio"),
            keywords: &[
                "Lintang Scorpio",
                "Scorpio",
                "ketonggeng",
                "palintangan",
                "scorpius",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ღრიანკალი"),
            keywords: &["ზოდიაქო", "მორიელი", "ღრიანკალი", "ჰოროსკოპი"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("Tiɣirdemt"),
            keywords: &["Tiɣirdemt"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("сарышаян белгісі"),
            keywords: &["зодиак", "сарышаян", "сарышаян белгісі"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("skorpionen"),
            keywords: &["skorpionen", "stjernetegn"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("Scorpio"),
            keywords: &[
                "Scorpio",
                "ខ\u{17d2}យាដ\u{17c6}រ\u{17b8}",
                "ពពែ",
                "មមែ",
                "សញ\u{17d2}ញាតារាសាស\u{17d2}ត\u{17d2}រអ\u{17ca}\u{17ba}រ\u{17c9}\u{17bb}បប\u{17d2}រភទទ\u{17b8}៨ ខ\u{17d2}យាដ\u{17c6}រ\u{17b8}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ವೃಷ\u{ccd}ಚ\u{cbf}ಕ"),
            keywords: &["ಚೇಳು", "ರಾಶ\u{cbf}ಚಕ\u{ccd}ರ", "ವೃಷ\u{ccd}ಚ\u{cbf}ಕ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("전갈자리"),
            keywords: &["별", "별자리", "스콜피온", "전갈", "전갈자리"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("व\u{943}श\u{94d}चीक"),
            keywords: &[
                "रास",
                "वि\u{902}च\u{942}",
                "व\u{943}श\u{94d}चीक",
                "व\u{943}श\u{94d}चीकरास",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("чаян жылдызы"),
            keywords: &["зодиак", "чаян", "чаян жылдызы"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Skorpioun (Stärzeechen)"),
            keywords: &["Skorpioun", "Skorpioun (Stärzeechen)", "Stärzeechen"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ລາສ\u{eb5}ພະຈ\u{eb4}ກ"),
            keywords: &["ລາສ\u{eb5}", "ລາສ\u{eb5}ພະຈ\u{eb4}ກ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("skorpionas"),
            keywords: &["skorpionas", "zodiakas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("zodiaka zīme Skorpions"),
            keywords: &["skorpions", "zodiaka zīme Skorpions", "zodiaks"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("Scorpius"),
            keywords: &["Scorpius", "kopio", "kopiona", "poutiriao"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("хороскопски знак скорпија"),
            keywords: &["скорпија", "хороскоп", "хороскопски знак скорпија"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("വ\u{d43}ശ\u{d4d}ചികം"),
            keywords: &["ര\u{d3e}ശി", "വ\u{d43}ശ\u{d4d}ചികം"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("Хилэнцийн орд"),
            keywords: &["Хилэнцийн орд", "орд", "хилэнц", "хилэнцийн орд"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("व\u{943}श\u{94d}चिक रास"),
            keywords: &["रास", "व\u{943}श\u{94d}चिक"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("Scorpio"),
            keywords: &["Scorpio", "kala jengking", "scorpio", "zodiak"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("Scorpius"),
            keywords: &["Scorpius", "scorpio", "skorpjun", "żodjaku"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဗြ\u{102d}စ\u{1039}ဆာ"),
            keywords: &[
                "ကင\u{103a}းမြ\u{102e}းကောက\u{103a}ပ\u{102f}\u{1036} ဗြ\u{102d}စ\u{1039}ဆာရာသ\u{102e}ရ\u{102f}ပ\u{103a}",
                "ဆယ\u{1037}\u{103a}န\u{103e}စ\u{103a}ရာသ\u{102e}ခ\u{103d}င\u{103a}",
                "ဗြ\u{102d}စ\u{1039}ဆာ",
                "ဗြ\u{102d}စ\u{1039}ဆာရာသ\u{102e}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("Skorpionen"),
            keywords: &["Skorpionen", "skorpion", "stjernetegn"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("व\u{943}श\u{94d}चिक"),
            keywords: &["राशि", "विच\u{94d}छ\u{941}", "व\u{943}श\u{94d}चिक"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("schorpioen (sterrenbeeld)"),
            keywords: &[
                "Scorpio",
                "dierenriem",
                "schorpioen",
                "schorpioen (sterrenbeeld)",
                "scorpius",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("Skorpionen"),
            keywords: &["Skorpionen", "skorpion", "stjerneteikn"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ବ\u{b3f}ଛ\u{b3e}"),
            keywords: &[
                "ବ\u{b3f}ଛ\u{b3e}",
                "ବ\u{b43}ଶ\u{b4d}ଚ\u{b3f}କ ର\u{b3e}ଶ\u{b3f}",
                "ର\u{b3e}ଶ\u{b3f}ଚକ\u{b4d}ର",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਵ\u{a4d}ਰਿਸ\u{a3c}ਚਕ ਰਾਸ\u{a3c}ੀ"),
            keywords: &["ਬਿ\u{a71}ਛ\u{a42}", "ਰਾਸ\u{a3c}ੀ", "ਵ\u{a4d}ਰਿਸ\u{a3c}ਚਕ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ب\u{64f}رج عقرب"),
            keywords: &["ب\u{64f}رج", "بچھو", "عقرب"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Skọ\u{301}pio"),
            keywords: &[
                "Skọ\u{301}pio",
                "Skọ\u{301}pius",
                "Skọ\u{301}piọn",
                "Zódiak",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("Skorpion"),
            keywords: &["Skorpion", "skorpion", "znak zodiaku", "zodiak"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("لړم"),
            keywords: &["سکارپيو", "لړم", "مرغومی"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("signo de Escorpião"),
            keywords: &["escorpião", "signo de Escorpião", "zodíaco"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("Escorpião"),
            keywords: &["Escorpião", "signo"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("Escorpion"),
            keywords: &["Escorpio", "Escorpion", "escorpion", "zodiaco"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("zodia Scorpion"),
            keywords: &["scorpion", "zodia Scorpion", "zodiac", "zodie"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-071"),
            keywords: &["E10-071"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("знак зодиака Скорпион"),
            keywords: &["знак", "знак зодиака Скорпион", "зодиак", "скорпион"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("Sikorupiyusi"),
            keywords: &[
                "Sikorupiyusi",
                "sikorupiyo imwe",
                "sikorupiyo nyinshi",
                "zodiyake",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("برج عقرب"),
            keywords: &["برج عقرب", "برج عقرب وارو", "راس چڪر"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("වෘශ\u{dca}ච\u{dd2}ක"),
            keywords: &[
                "ගෝන\u{dd4}ස\u{dca}ස\u{dcf}",
                "ර\u{dcf}ශ\u{dd2}ය",
                "වෘශ\u{dca}ච\u{dd2}ක",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("znamenie škorpióna"),
            keywords: &["znamenie škorpióna", "zverokruh", "škorpión"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("astrološki znak škorpijona"),
            keywords: &["astrološki znak škorpijona", "zodiak", "škorpijon"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("dib-qallooc"),
            keywords: &["cutubka meecaad", "daba-aleele", "dib-qallooc"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("akrepi"),
            keywords: &["akrep", "akrepi", "zodiak"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("шкорпија у хороскопу"),
            keywords: &["зoдиjaк", "шкoрпија", "шкорпија у хороскопу"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("škorpija u horoskopu"),
            keywords: &["zodijak", "škorpija", "škorpija u horoskopu"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("Skorpionen"),
            keywords: &["Skorpionen", "stjärntecken"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("nyota ya ng’e"),
            keywords: &["nge", "nyota ya ng’e", "zodiaki"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("nyota ya nge"),
            keywords: &["nge", "nyota ya nge", "zodiaki"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("விருச\u{bcd}சிகம\u{bcd}"),
            keywords: &[
                "இர\u{bbe}சி",
                "நட\u{bcd}சத\u{bcd}திரம\u{bcd}",
                "ர\u{bbe}சி",
                "விருச\u{bcd}சிகம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("వృశ\u{c4d}చ\u{c3f}కర\u{c3e}శ\u{c3f}"),
            keywords: &["చక\u{c4d}రం", "వృశ\u{c4d}చ\u{c3f}కర\u{c3e}శ\u{c3f}"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("Ақраб"),
            keywords: &["Ақраб", "бурҷи дувоздаҳгона", "каждум"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ราศ\u{e35}พ\u{e34}จ\u{e34}ก"),
            keywords: &["จ\u{e31}กรราศ\u{e35}", "ราศ\u{e35}พ\u{e34}จ\u{e34}ก"],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ስኮርፕዮ"),
            keywords: &["ስኮርፒዩስ", "ስኮርፕዮ", "ዕንቅርቢት", "ዞድያክ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("Akrap"),
            keywords: &["Akrap", "akrap", "içýan", "täleýnama"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("Sikipio (pupunga)"),
            keywords: &["Sikipio (pupunga)", "pupunga", "skipio"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("akrep burcu"),
            keywords: &["akrep burcu", "burçlar"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئەقرەب"),
            keywords: &["ئېشەك", "ئەقرەب", "مۆچەل", "چايان"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("Скорпіон (знак зодіаку)"),
            keywords: &["Скорпіон (знак зодіаку)", "зодіак", "скорпіон"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("برج عقرب"),
            keywords: &["برج", "برج عقرب", "بچھو"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("chayon burji"),
            keywords: &["burj", "chayon", "chayon burji"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("Thiên Yết"),
            keywords: &["Thiên Yết", "bọ cạp", "cung bọ cạp", "cung hoàng đạo"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("Eskorpiyoŋ"),
            keywords: &["Eskorpiyoŋ", "jiit", "sojak"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("I-scorpius"),
            keywords: &["I-scorpius", "i-scorpio", "i-scorpion", "i-zodiac"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Scorpius"),
            keywords: &["Scorpius", "scorpio", "àkeèké", "àmi oṣù ìbí"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("天蠍座"),
            keywords: &["天蠍座", "星座", "蠍子"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("天蝎座"),
            keywords: &["天蝎座", "星座", "蝎子"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("天蝎座"),
            keywords: &["天蝎座", "星座", "蝎子"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("天蠍座"),
            keywords: &["天蠍座", "星座"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("scorpius"),
            keywords: &["inkanyezi", "scorpius", "ufezela"],
        },
    ],
};
#[doc = "♐"]
pub const SAGITTARIUS: crate::Emoji = crate::Emoji {
    glyph: "♐",
    codepoint: "2650",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "Sagittarius",
    group: "Symbols",
    subgroup: "zodiac",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("Boogskutter-sterrebeeld"),
            keywords: &["Boogskutter-sterrebeeld", "boogskutter", "diereriem"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ሳጂታሪየስ"),
            keywords: &["መልህቅ", "ሳጂታሪየስ", "ዞዲያክ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("القوس"),
            keywords: &["الأبراج", "القوس"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ধন\u{9c1} ৰ\u{9be}শি"),
            keywords: &[
                "ধন\u{9c1} ৰ\u{9be}শি",
                "ধন\u{9c1}ৰ\u{9cd}ধৰ",
                "ৰ\u{9be}শিচক\u{9cd}ৰ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("oxatan"),
            keywords: &["oxatan", "zodiak"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("знак задыяка Стралец"),
            keywords: &["задыяк", "знак задыяка Стралец", "стралец"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Зодиакален знак стрелец"),
            keywords: &[
                "Зодиакален знак стрелец",
                "зодиак",
                "зодиакален знак",
                "зодия",
                "стрелец",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ধন\u{9c1}"),
            keywords: &["ধন\u{9c1}", "র\u{9be}শিচক\u{9cd}র"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("ar Saezhataer"),
            keywords: &["Saezhataer", "Sgr", "ar Saezhataer", "zodiak"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("strijelac"),
            keywords: &["horoskop", "strijelac", "znak", "zodijak"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("Sagitari"),
            keywords: &["Sagitari", "arquer", "zodíac"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎦᎵᏣᏗᏍᎩ"),
            keywords: &["ᎠᏉᏂᏍᎩ", "ᎦᎵᏣᏗᏍᎩ", "ᏃᏈᏏ ᏓᏟᎶᏍᏗᏍᎲᎢ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("střelec"),
            keywords: &["střelec", "zvěrokruh"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("y Saethydd"),
            keywords: &["saethwr", "sidydd", "y Saethydd"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("skytten"),
            keywords: &["skytten", "stjernetegn"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Schütze (Sternzeichen)"),
            keywords: &["Schütze", "Schütze (Sternzeichen)", "Sternzeichen"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("Τοξότης"),
            keywords: &["Τοξότης", "ζώδιο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("Sagittarius"),
            keywords: &["Sagittarius", "archer", "zodiac"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["Sagittarius", "archer", "centaur", "zodiac"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("Sagitario"),
            keywords: &["Sagitario", "arquero", "sagitario", "zodiaco"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["Sagitario", "arquero", "sagitario", "zodíaco"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("Ambur"),
            keywords: &["Ambur", "sodiaak"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("sagittarius"),
            keywords: &["arkulari", "sagittarius", "zodiako"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("برج قوس"),
            keywords: &["آذر", "برج", "قوس"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("jousimies-merkki"),
            keywords: &[
                "horoskooppi",
                "horoskooppimerkki",
                "jousimies",
                "jousimies-merkki",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("Sagittarius"),
            keywords: &["Sagittarius", "archer", "pana", "zodiac"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("Bogamaðurin"),
            keywords: &["Bogamaðurin", "bogamaður", "skotmaður", "stjørnumerki"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("sagittaire"),
            keywords: &["sagittaire", "zodiaque"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("Sagittaire"),
            keywords: &["Sagittaire", "zodiaque"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("an Saighdeoir"),
            keywords: &["Sagittarius", "an Saighdeoir", "stoidiaca"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("An Saighdear"),
            keywords: &[
                "An Saighdear",
                "boghadair",
                "grian-chrios",
                "grian-chriosach",
                "sagittarius",
                "saighdear",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("Saxitario"),
            keywords: &["Sagittarius", "Saxitario", "arqueiro", "zodíaco"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ધન\u{ac1}"),
            keywords: &["ધન\u{ac1}", "રાશિચક\u{acd}ર"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("Sagittarius"),
            keywords: &["Sagittarius", "mai baka", "zodiac"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("מזל קשת"),
            keywords: &["גלגל המזלות", "מזל", "קשת"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("धन\u{941}"),
            keywords: &["धन\u{941}", "धन\u{941}, राशि", "राशि"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("astrološki znak strijelca"),
            keywords: &["astrološki znak strijelca", "strijelac", "zodijak"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("nyilas csillagjegy"),
            keywords: &["horoszkóp", "nyilas", "nyilas csillagjegy"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("Աղեղնավոր"),
            keywords: &["Աղեղնավոր", "կենդանակերպ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("Sagitarius"),
            keywords: &["Sagitarius", "pemanah", "sagitarius", "zodiak"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("Sagịtarius"),
            keywords: &["Sagịtarius", "onye agha", "zodịak"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("bogmaður"),
            keywords: &["bogamaður", "bogmaður", "stjörnumerki"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("Segno zodiacale del Saggitario"),
            keywords: &["Sagittario", "Segno zodiacale del Saggitario", "zodiaco"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("いて座"),
            keywords: &["いて座", "射手座", "星座"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("Lintang Sagittarius"),
            keywords: &[
                "Lintang Sagittarius",
                "Sagitarius",
                "palintangan",
                "pamanah",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მშვილდოსანი"),
            keywords: &["ზოდიაქო", "მოისარი", "მშვილდოსანი", "ჰოროსკოპი"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("Amnaccab"),
            keywords: &["Amnaccab"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("мерген белгісі"),
            keywords: &["зодиак", "мерген белгісі", "садақшы"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("skytten"),
            keywords: &["skytten", "stjernetegn"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some(
                "សញ\u{17d2}ញាតារាសាស\u{17d2}ត\u{17d2}រអ\u{17ca}\u{17ba}រ\u{17c9}\u{17bb}បប\u{17d2}រភទទ\u{17b8}៩ អ\u{17d2}នកបាញ\u{17cb}ធ\u{17d2}ន\u{17bc}",
            ),
            keywords: &[
                "វក",
                "សញ\u{17d2}ញាតារាសាស\u{17d2}ត\u{17d2}រអ\u{17ca}\u{17ba}រ\u{17c9}\u{17bb}បប\u{17d2}រភទទ\u{17b8}៩ អ\u{17d2}នកបាញ\u{17cb}ធ\u{17d2}ន\u{17bc}",
                "ស\u{17d2}វា",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಧನು"),
            keywords: &["ಧನು", "ಧನು ರಾಶ\u{cbf}", "ರಾಶ\u{cbf}ಚಕ\u{ccd}ರ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("사수자리"),
            keywords: &["별", "별자리", "사수자리", "활"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("धन\u{941}"),
            keywords: &["धन\u{941}", "धन\u{941}र\u{94d}धर", "रास"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("жаачы"),
            keywords: &["жаачы", "зодиак"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Schütze"),
            keywords: &["Bouschéisser", "Schütze", "Stärzeechen"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ລາສ\u{eb5}ທະນ\u{eb9}"),
            keywords: &["ລາສ\u{eb5}", "ລາສ\u{eb5}ທະນ\u{eb9}"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("šaulys"),
            keywords: &["zodiakas", "šaulys"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("zodiaka zīme Strēlnieks"),
            keywords: &["strēlnieks", "zodiaka zīme Strēlnieks", "zodiaks"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("Sagittarius"),
            keywords: &["Sagittarius", "kaikōpere", "poutiriao"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("хороскопски знак стрелец"),
            keywords: &["стрелец", "хороскоп", "хороскопски знак стрелец"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ധന\u{d41}"),
            keywords: &["ധന\u{d41}", "ര\u{d3e}ശി"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("нумын орд"),
            keywords: &["нум", "нумын орд", "орд"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("धन\u{941} रास"),
            keywords: &["धन\u{941}", "धन\u{941} रास", "राशी"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("Sagittarius"),
            keywords: &["Sagittarius", "pemanah", "zodiak"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("Sagittarius"),
            keywords: &["Sagittarius", "arċier", "żodjaku"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဓန\u{102f}"),
            keywords: &[
                "ဆယ\u{1037}\u{103a}န\u{103e}စ\u{103a}ရာသ\u{102e}ခ\u{103d}င\u{103a}",
                "ဓန\u{102f}",
                "ဓန\u{102f}ရာသ\u{102e}",
                "ဓန\u{102f}ရာသ\u{102e}ရ\u{102f}ပ\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("Skytten"),
            keywords: &["Skytten", "bueskytter", "stjernetegn"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("धन\u{941}"),
            keywords: &["धन\u{941}", "राशि"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("boogschutter (sterrenbeeld)"),
            keywords: &[
                "Sagittarius",
                "boogschutter",
                "boogschutter (sterrenbeeld)",
                "dierenriem",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("Skyttaren"),
            keywords: &["Skyttaren", "bogeskyttar", "stjerneteikn"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଧନ\u{b41}"),
            keywords: &[
                "ଧନ\u{b41}",
                "ଧନ\u{b41}ର\u{b4d}ଦ\u{b4d}ଧର",
                "ର\u{b3e}ଶ\u{b3f}ଚକ\u{b4d}ର",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਧਨ\u{a41} ਰਾਸ\u{a3c}ੀ"),
            keywords: &["ਧਨ\u{a41}", "ਰਾਸ\u{a3c}ੀ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ب\u{64f}رج ق\u{64e}وس"),
            keywords: &["ب\u{64f}رج", "ب\u{64f}رج ق\u{64e}وس", "تیر انداز"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Sajitérius"),
            keywords: &[
                "Pẹ\u{301}sin Wé De Shút Wit Bó An Áro",
                "Sajitérius",
                "Zódiak",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("Strzelec"),
            keywords: &["Strzelec", "strzelec", "znak zodiaku", "zodiak"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("نخښه ويشتونکی"),
            keywords: &["مرغومی", "نخښه ويشتونکی", "ښکارزن"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("signo de Sagitário"),
            keywords: &["arqueiro", "sagitário", "signo de Sagitário", "zodíaco"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("Sagitário"),
            keywords: &["Sagitário", "signo"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("Sagitario"),
            keywords: &["Sagitario", "arquero", "zodiaco"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("zodia Săgetător"),
            keywords: &["arcaș", "săgetător", "zodia Săgetător", "zodiac", "zodie"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-072"),
            keywords: &["E10-072"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("знак зодиака Стрелец"),
            keywords: &["знак", "знак зодиака Стрелец", "зодиак", "стрелец"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("sajitariyusi"),
            keywords: &["sajitariyusi", "umurashi w’umuheto", "zodiyake"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("برج قوس"),
            keywords: &["برج قوس", "تير انداز", "راس چڪر"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ධන\u{dd4}"),
            keywords: &[
                "ද\u{dd4}න\u{dd4}\u{dd4}ව\u{dcf}ය\u{dcf}",
                "ධන\u{dd4}",
                "ර\u{dcf}ශ\u{dd2}ය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("znamenie strelca"),
            keywords: &["strelec", "znamenie strelca", "zverokruh"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("strelec"),
            keywords: &["strelec", "zodiak"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("dameerajoogeen"),
            keywords: &["cutubka meecaad", "dameerajoogeen", "qaanso toog"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("shigjetari"),
            keywords: &["harkëtar", "shigjetari", "zodiak"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("стрелац у хороскопу"),
            keywords: &["зoдиjaк", "стрeлaц", "стрелац у хороскопу"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("стријелац у хороскопу"),
            keywords: &["стријелац у хороскопу"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("strelac u horoskopu"),
            keywords: &["strelac", "strelac u horoskopu", "zodijak"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("strijelac u horoskopu"),
            keywords: &["strijelac u horoskopu"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("Skytten"),
            keywords: &["Skytten", "stjärntecken"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mshale"),
            keywords: &["mpiga mishale", "mshale", "zodiaki"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("தனுசு"),
            keywords: &[
                "இர\u{bbe}சி",
                "தனுசு",
                "நட\u{bcd}சத\u{bcd}திரம\u{bcd}",
                "ர\u{bbe}சி",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ధనూర\u{c3e}శ\u{c3f}"),
            keywords: &["చక\u{c4d}రం", "ధనూర\u{c3e}శ\u{c3f}"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("Қавс"),
            keywords: &["бурҷи дувоздаҳгона", "Қавс", "қавс"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ราศ\u{e35}ธน\u{e39}"),
            keywords: &["จ\u{e31}กรราศ\u{e35}", "ราศ\u{e35}ธน\u{e39}"],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ሲጊታሩስ"),
            keywords: &["ሲጊታሩስ", "ኣንከር", "ዞድያክ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("Kowus"),
            keywords: &["Kowus", "okçy", "täleýnama"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("Tangata fana (pupunga)"),
            keywords: &["Tangata fana (pupunga)", "fana", "pupunga", "tangata"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("yay burcu"),
            keywords: &["burçlar", "yay burcu"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ياچاق"),
            keywords: &["مۆچەل", "ياچاق"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("Стрілець"),
            keywords: &["Стрілець", "зодіак"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("برج قوس"),
            keywords: &["برج", "برج قوس", "تیر انداز"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("o‘qotar burji"),
            keywords: &["burj", "o‘qotar", "o‘qotar burji"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("Nhân Mã"),
            keywords: &["Nhân Mã", "cung hoàng đạo", "người bắn cung"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("Sajiteer"),
            keywords: &["Sajiteer", "ark", "sojak"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("I-Sagittarius"),
            keywords: &["I-Sagittarius", "i-zodiac", "umtoli"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Sagittarius"),
            keywords: &["Sagittarius", "tafàtafà", "àmi oṣù ìbí"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("人馬座"),
            keywords: &["人馬座", "射手", "星座"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("人马座"),
            keywords: &["人马座", "射手", "星座"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("射手座"),
            keywords: &["射手座", "弓箭手", "星座"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("射手座"),
            keywords: &["射手座", "星座"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("sagittarius"),
            keywords: &["inkanyezi", "insika", "sagittarius"],
        },
    ],
};
#[doc = "♑"]
pub const CAPRICORN: crate::Emoji = crate::Emoji {
    glyph: "♑",
    codepoint: "2651",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "Capricorn",
    group: "Symbols",
    subgroup: "zodiac",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("Steenbok-sterrebeeld"),
            keywords: &["Steenbok-sterrebeeld", "boerbok", "diereriem"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ካፕሪኮርን"),
            keywords: &["ካፕሪኮርን", "ዞዲያክ", "ፍየል"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("الجدي"),
            keywords: &["الأبراج", "الجدي"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("মকৰ ৰ\u{9be}শি"),
            keywords: &["ছ\u{9be}গলী", "মকৰ ৰ\u{9be}শি", "ৰ\u{9be}শিচক\u{9cd}ৰ"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("oğlaq"),
            keywords: &["keçi", "oğlaq", "zodiak"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("знак задыяка Казярог"),
            keywords: &["задыяк", "знак задыяка Казярог", "казярог", "казёл"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Зодиакален знак козирог"),
            keywords: &[
                "Зодиакален знак козирог",
                "зодиак",
                "зодиакален знак",
                "зодия",
                "козирог",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("মকর"),
            keywords: &["মকর", "র\u{9be}শিচক\u{9cd}র"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("ar Cʼhavr"),
            keywords: &["Cap", "Gavr", "ar Cʼhavr", "zodiak"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("jarac"),
            keywords: &["horoskop", "jarac", "znak", "zodijak"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("Capricorn"),
            keywords: &["Capricorn", "cabra", "zodíac"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎧᏈᎪᏂ"),
            keywords: &["ᎤᎦᏐᏣᏁᏓ", "ᎧᏈᎪᏂ", "ᏃᏈᏏ ᏓᏟᎶᏍᏗᎲᎢ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("kozoroh"),
            keywords: &["koza", "kozoroh", "zvěrokruh"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("yr Afr"),
            keywords: &["gafr", "sidydd", "yr Afr"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("stenbukken"),
            keywords: &["stenbukken", "stjernetegn"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Steinbock (Sternzeichen)"),
            keywords: &["Steinbock", "Steinbock (Sternzeichen)", "Sternzeichen"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("Αιγόκερως"),
            keywords: &["Αιγόκερως", "ζώδιο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("Capricorn"),
            keywords: &["Capricorn", "goat", "zodiac"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("Capricornio"),
            keywords: &["Capricornio", "cabra", "capricornio", "zodiaco"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["Capricornio", "cabra", "capricornio", "zodíaco"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("Kaljukits"),
            keywords: &["Kaljukits", "sodiaak"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("capricornus"),
            keywords: &["ahuntz", "capricornus", "zodiako"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("برج جدی"),
            keywords: &["برج", "جدی", "دی"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kauris-merkki"),
            keywords: &[
                "horoskooppi",
                "horoskooppimerkki",
                "kauris",
                "kauris-merkki",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("Capricorn"),
            keywords: &["Capricorn", "kambing", "zodiac"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("Steingeitin"),
            keywords: &["Steingeitin", "geit", "steingeitarmerki", "stjørnumerki"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("capricorne"),
            keywords: &["capricorne", "zodiaque"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("Capricorne"),
            keywords: &["Capricorne", "zodiaque"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("an Gabhar"),
            keywords: &["Capricorn", "an Gabhar", "stoidiaca"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("An Gobhar"),
            keywords: &[
                "An Gobhar",
                "capricorn",
                "gobhar",
                "grian-chrios",
                "grian-chriosach",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("Capricornio"),
            keywords: &["Capricornio", "Capricornus", "cabra", "zodíaco"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("મકર"),
            keywords: &["મકર", "રાશિચક\u{acd}ર"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("Capricorn"),
            keywords: &["Capricorn", "akuya", "zodiac"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("מזל גדי"),
            keywords: &["גדי", "גלגל המזלות", "מזל"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("मकर"),
            keywords: &["मकर", "मकर, राशि", "राशि"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("astrološki znak jarca"),
            keywords: &["astrološki znak jarca", "jarac", "zodijak"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("bak csillagjegy"),
            keywords: &["bak", "bak csillagjegy", "horoszkóp"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("Այծեղջյուր"),
            keywords: &["Այծեղջյուր", "այծ", "կենդանակերպ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("Capricorn"),
            keywords: &["Capricorn", "capricorn", "kambing", "zodiak"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("Kaprịkọn"),
            keywords: &["Kaprịkọn", "ewu", "zodịak"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("steingeit"),
            keywords: &["steingeit", "stjörnumerki"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("Segno zodiacale del Capricorno"),
            keywords: &["Capricorno", "Segno zodiacale del Capricorno", "zodiaco"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("やぎ座"),
            keywords: &["やぎ座", "山羊座", "星座"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("Lintang Capricorn"),
            keywords: &["Capricorn", "Lintang Capricorn", "palintangan", "wedhus"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("თხის რქა"),
            keywords: &["ზოდიაქო", "თხა", "თხის რქა", "ჰოროსკოპი"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("Aqelwac"),
            keywords: &["Aqelwac"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("тауешкі белгісі"),
            keywords: &["ешкі", "зодиак", "тауешкі белгісі"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("stenbukken"),
            keywords: &["stenbukken", "stjernetegn"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some(
                "សញ\u{17d2}ញាតារាសាស\u{17d2}ត\u{17d2}រអ\u{17ca}\u{17ba}រ\u{17c9}\u{17bb}បប\u{17d2}រភទទ\u{17b8}១០ ពពែ",
            ),
            keywords: &[
                "មាន\u{17cb}",
                "រកា",
                "សញ\u{17d2}ញាតារាសាស\u{17d2}ត\u{17d2}រអ\u{17ca}\u{17ba}រ\u{17c9}\u{17bb}បប\u{17d2}រភទទ\u{17b8}១០ ពពែ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಮಕರ"),
            keywords: &["ಮಕರ", "ರಾಶ\u{cbf}ಚಕ\u{ccd}ರ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("염소자리"),
            keywords: &["별", "별자리", "염소", "염소자리"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("मकर"),
            keywords: &["बोकडी", "मकर", "रास"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("текечер"),
            keywords: &["зодиак", "текечер", "эчки"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Steebock"),
            keywords: &["Gees", "Steebock", "Stärzeechen"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ລາສ\u{eb5}ມ\u{eb1}ງກອນ"),
            keywords: &["ລາສ\u{eb5}", "ລາສ\u{eb5}ມ\u{eb1}ງກອນ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("ožiaragis"),
            keywords: &["ožiaragis", "ožys", "zodiakas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("zodiaka zīme Mežāzis"),
            keywords: &["mežāzis", "zodiaka zīme Mežāzis", "zodiaks"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("Capricorn"),
            keywords: &["Capricorn", "koati", "poutiriao"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("хороскопски знак јарец"),
            keywords: &["хороскоп", "хороскопски знак јарец", "јарец"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("മകരം"),
            keywords: &["മകരം", "ര\u{d3e}ശി"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("матрын орд"),
            keywords: &["матар", "матрын орд", "орд"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("मकर रास"),
            keywords: &["मकर", "रास"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("Capricorn"),
            keywords: &["Capricorn", "kambing", "zodiak"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("Capricorn"),
            keywords: &["Capricorn", "mogħża", "żodjaku"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("မကရ"),
            keywords: &[
                "ဆယ\u{1037}\u{103a}န\u{103e}စ\u{103a}ရာသ\u{102e}ခ\u{103d}င\u{103a}",
                "မကရ",
                "မကရရာသ\u{102e}",
                "မကရရာသ\u{102e}ရ\u{102f}ပ\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("Steinbukken"),
            keywords: &["Steinbukken", "geit", "stjernetegn"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("मकर"),
            keywords: &["बाख\u{94d}रा", "मकर", "राशि"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("steenbok (sterrenbeeld)"),
            keywords: &[
                "Capricorn",
                "dierenriem",
                "steenbok",
                "steenbok (sterrenbeeld)",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("Steinbukken"),
            keywords: &["Steinbukken", "geit", "stjerneteikn"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ମକର"),
            keywords: &["ଛେଳ\u{b3f}", "ମକର", "ର\u{b3e}ଶ\u{b3f}ଚକ\u{b4d}ର"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਮ\u{a71}ਕਰ ਰਾਸ\u{a3c}ੀ"),
            keywords: &["ਮ\u{a71}ਕਰ", "ਰਾਸ\u{a3c}ੀ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ب\u{64f}رج مکر راس"),
            keywords: &["ب\u{64f}رج", "ب\u{64f}رج مکر راس", "بکری"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Kápríkọn"),
            keywords: &["Got", "Kápríkọn", "Zódiak"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("Koziorożec"),
            keywords: &["Koziorożec", "koziorożec", "znak zodiaku", "zodiak"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("مرغومی"),
            keywords: &["بيزه", "غرڅه", "مرغومی"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("signo de Capricórnio"),
            keywords: &["cabra", "capricórnio", "signo de Capricórnio", "zodíaco"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("Capricórnio"),
            keywords: &["Capricórnio", "signo"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("Capricornio"),
            keywords: &["Capricornio", "chiwu", "zodiaco"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("zodia Capricorn"),
            keywords: &["capricorn", "zodia Capricorn", "zodiac", "zodie"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-073"),
            keywords: &["E10-073"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("знак зодиака Козерог"),
            keywords: &["знак", "знак зодиака Козерог", "зодиак", "козерог"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("Kapurikorune"),
            keywords: &["Kapurikorune", "ihene", "zodiyake"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("برج جدي"),
            keywords: &["برج جدي", "راس چڪر", "ٻڪري"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("මකර"),
            keywords: &["එළ\u{dd4}ව\u{dcf}", "මකර", "ර\u{dcf}ශ\u{dd2}ය"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("znamenie kozorožca"),
            keywords: &["koza", "znamenie kozorožca", "zverokruh"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("kozorog"),
            keywords: &["koza", "kozorog", "zodiak"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("riyaha"),
            keywords: &["cutubka meecaad", "ri", "riyaha"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("bricjapi"),
            keywords: &["bricjapi", "dhi", "zodiak"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("јарац у хороскопу"),
            keywords: &["jaрaц", "зoдиjaк", "јарац у хороскопу"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("jarac u horoskopu"),
            keywords: &["jarac", "jarac u horoskopu", "zodijak"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("Stenbocken"),
            keywords: &["Stenbocken", "stjärntecken"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("nyota ya mbuzi"),
            keywords: &["nyota ya mbuzi", "zodiaki"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("மகரம\u{bcd}"),
            keywords: &[
                "இர\u{bbe}சி",
                "நட\u{bcd}சத\u{bcd}திரம\u{bcd}",
                "மகரம\u{bcd}",
                "ர\u{bbe}சி",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("మకరర\u{c3e}శ\u{c3f}"),
            keywords: &["చక\u{c4d}రం", "మకరర\u{c3e}శ\u{c3f}"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("Ҷадӣ"),
            keywords: &["бурҷи дувоздаҳгона", "Ҷадӣ", "ҷадӣ"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ราศ\u{e35}ม\u{e31}งกร"),
            keywords: &["จ\u{e31}กรราศ\u{e35}", "ราศ\u{e35}ม\u{e31}งกร"],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ወጠጦ"),
            keywords: &["ወጠጦ", "ዞዲያክ", "ጤል"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("Owlak"),
            keywords: &["Owlak", "geçi", "täleýnama"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("Kositahi (pupunga)"),
            keywords: &["Kositahi (pupunga)", "kosi", "kositahi", "pupunga"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("oğlak burcu"),
            keywords: &["burçlar", "oğlak burcu"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئوغلاق"),
            keywords: &["ئوغلاق", "ئۆچكە", "مۆچەل"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("Козоріг"),
            keywords: &["Козеріг", "Козоріг", "зодіак", "коза"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("برج جدی"),
            keywords: &["برج", "برج جدی", "بکرا"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("tog‘ echkisi burji"),
            keywords: &["burj", "echki", "tog‘ echkisi burji"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("Ma Kết"),
            keywords: &["Ma Kết", "con dê", "cung hoàng đạo"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("Kaprikorn"),
            keywords: &["Kaprikorn", "bëy", "sojak"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("I-Capricorn"),
            keywords: &["I-Capricorn", "i-zodiac", "ibhokhwe"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Capricorn"),
            keywords: &["Capricorn", "ewúré\u{329}", "àmi oṣù ìbí"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("山羊座"),
            keywords: &["山羊", "山羊座", "星座"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("山羊座"),
            keywords: &["山羊", "山羊座", "星座"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("摩羯座"),
            keywords: &["山羊", "摩羯座", "星座"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("摩羯座"),
            keywords: &["摩羯座", "星座"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("山羊座"),
            keywords: &["山羊座", "星座"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("capricorn"),
            keywords: &["capricorn", "imbuzi", "inkanyezi"],
        },
    ],
};
#[doc = "♒"]
pub const AQUARIUS: crate::Emoji = crate::Emoji {
    glyph: "♒",
    codepoint: "2652",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "Aquarius",
    group: "Symbols",
    subgroup: "zodiac",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("Waterdraer-sterrebeeld"),
            keywords: &["Waterdraer-sterrebeeld", "diereriem", "draer", "water"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("አኳይረስ"),
            keywords: &["ተሸካሚ", "አኳይረስ", "ውሃ", "ዞዲያክ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("الدلو"),
            keywords: &["الأبراج", "الدلو"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ক\u{9c1}ম\u{9cd}ভ ৰ\u{9be}শি"),
            keywords: &[
                "ক\u{9c1}ম\u{9cd}ভ ৰ\u{9be}শি",
                "প\u{9be}নী",
                "বহনক\u{9be}ৰী",
                "ৰ\u{9be}শিচক\u{9cd}ৰ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("dolça"),
            keywords: &["daşıyan", "dolça", "su", "zodiak"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("знак задыяка Вадалей"),
            keywords: &["вада", "вадаліў", "задыяк", "знак задыяка Вадалей"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Зодиакален знак водолей"),
            keywords: &[
                "Зодиакален знак водолей",
                "водолей",
                "зодиак",
                "зодиакален знак",
                "зодия",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ক\u{9c1}ম\u{9cd}ভ"),
            keywords: &["ক\u{9c1}ম\u{9cd}ভ", "জল", "র\u{9be}শিচক\u{9cd}র"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("ar Skuilher-dour"),
            keywords: &["Aqr", "Skuilher-dour", "ar Skuilher-dour", "zodiak"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("vodolija"),
            keywords: &["horoskop", "vodolija", "znak", "zodijak"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("Aquari"),
            keywords: &["Aquari", "aigua", "zodíac"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᎹ ᎦᏅᏥᏙ"),
            keywords: &["ᎠᎹ", "ᎠᎹ ᎦᏅᏥᏙ", "ᎠᏱᏙᎯ", "ᏃᏈᏏ ᏓᏟᎶᏍᏗᎲᎢ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("vodnář"),
            keywords: &["voda", "vodnář", "vodonoš", "zvěrokruh"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("y Dyfrwr"),
            keywords: &["cludwr", "dŵr", "sidydd", "y Dyfrwr"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("vandmanden"),
            keywords: &["stjernetegn", "vandmanden"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Wassermann (Sternzeichen)"),
            keywords: &["Sternzeichen", "Wassermann", "Wassermann (Sternzeichen)"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("Υδροχόος"),
            keywords: &["Υδροχόος", "ζώδιο", "κομιστής", "νερό"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("Aquarius"),
            keywords: &["Aquarius", "bearer", "water", "zodiac"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["Aquarius", "water bearer", "zodiac"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("Acuario"),
            keywords: &["Acuario", "acuario", "agua", "zodiaco"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["Acuario", "acuario", "agua", "zodíaco"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("Veevalaja"),
            keywords: &["Veevalaja", "sodiaak"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("aquarius"),
            keywords: &["aquarius", "berri-ekarle", "ur", "zodiako"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("برج دلو"),
            keywords: &["برج", "بهمن", "دلو"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("vesimies-merkki"),
            keywords: &[
                "horoskooppi",
                "horoskooppimerkki",
                "vesimies",
                "vesimies-merkki",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("Aquarius"),
            keywords: &["Aquarius", "tubig", "zodiac"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("Vatnberin"),
            keywords: &["Vatnberin", "berari", "stjørnumerki", "vatn"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("verseau"),
            keywords: &["verseau", "zodiaque"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("Verseau"),
            keywords: &["Verseau", "zodiaque"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("Iompróir an Uisce"),
            keywords: &["Aquarius", "Iompróir an Uisce", "stoidiaca"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("Am Fear-giùlain Uisge"),
            keywords: &[
                "Am Fear-giùlain Uisge",
                "aquarius",
                "giùlan",
                "grian-chrios",
                "grian-chriosach",
                "uisge",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("Acuario"),
            keywords: &["Acuario", "Aquarius", "auga", "vendedor de auga", "zodíaco"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ક\u{ac1}\u{a82}ભ"),
            keywords: &["ક\u{ac1}\u{a82}ભ", "રાશિચક\u{acd}ર"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("Aquarius"),
            keywords: &["Aquarius", "maɗauki", "ruwa", "zodiac"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("מזל דלי"),
            keywords: &["גלגל המזלות", "דלי", "מזל", "מים"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("क\u{941}\u{902}भ"),
            keywords: &["क\u{941}\u{902}भ", "क\u{941}\u{902}भ, राशि", "राशि"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("astrološki znak vodenjaka"),
            keywords: &["astrološki znak vodenjaka", "vodenjak", "zodijak"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("vízöntő csillagjegy"),
            keywords: &["horoszkóp", "vízöntő", "vízöntő csillagjegy"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("Ջրհոս"),
            keywords: &["Ջրհոս", "կենդանակերպ", "կրող", "ջուր"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("Aquarius"),
            keywords: &["Aquarius", "air", "aquarius", "pembawa", "zodiak"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("Akwarius"),
            keywords: &["Akwarius", "mmiri", "zodịak", "ọgba mgbochi"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("vatnsberi"),
            keywords: &["stjörnumerki", "vatnsberi"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("Segno zodiacale dell’Acquario"),
            keywords: &["Acquario", "Segno zodiacale dell’Acquario", "zodiaco"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("みずがめ座"),
            keywords: &["みずがめ座", "星座", "水瓶座"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("Lintang Aquarius"),
            keywords: &[
                "Aquarius",
                "Lintang Aquarius",
                "banyu",
                "palintangan",
                "sing nggawa",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მერწყული"),
            keywords: &["ზოდიაქო", "მერწყული", "წყალი", "ჰოროსკოპი"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("Azfuf"),
            keywords: &["Azfuf"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("суқұйғыш белгісі"),
            keywords: &["зодиак", "су", "суқұйғыш белгісі", "құюшы"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("vandmanden"),
            keywords: &["stjernetegn", "vandmanden"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some(
                "សញ\u{17d2}ញាតារាសាស\u{17d2}ត\u{17d2}រអ\u{17ca}\u{17ba}រ\u{17c9}\u{17bb}បប\u{17d2}រភទទ\u{17b8}១១ ទ\u{17b9}ក",
            ),
            keywords: &[
                "ច",
                "ឆ\u{17d2}កែ",
                "សញ\u{17d2}ញាតារាសាស\u{17d2}ត\u{17d2}រអ\u{17ca}\u{17ba}រ\u{17c9}\u{17bb}បប\u{17d2}រភទទ\u{17b8}១១ ទ\u{17b9}ក",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕುಂಭ"),
            keywords: &["ಕುಂಭ", "ರಾಶ\u{cbf}ಚಕ\u{ccd}ರ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("물병자리"),
            keywords: &["물", "물병", "물병자리", "별", "별자리"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("क\u{941}\u{902}भ"),
            keywords: &["उदक", "क\u{941}\u{902}भ", "ब\u{947}रर", "रास"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("суупери"),
            keywords: &["зодиак", "суу", "суупери"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Waassermann"),
            keywords: &["Stärzeechen", "Träger", "Waasser", "Waassermann"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ລາສ\u{eb5}ກ\u{eb8}ມ"),
            keywords: &["ລາສ\u{eb5}", "ລາສ\u{eb5}ກ\u{eb8}ມ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("vandenio ženklas"),
            keywords: &["vandenio ženklas", "vanduo", "zodiakas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("zodiaka zīme Ūdensvīrs"),
            keywords: &["zodiaka zīme Ūdensvīrs", "zodiaks", "ūdensvīrs"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("Aquarius"),
            keywords: &["Aquarius", "kaikawe", "poutiriao", "wai"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("хороскопски знак водолија"),
            keywords: &["водолија", "хороскоп", "хороскопски знак водолија"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ക\u{d41}ംഭം"),
            keywords: &["ക\u{d41}ംഭം", "ര\u{d3e}ശി"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("бумбын орд"),
            keywords: &["бумба", "бумбын орд", "орд"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("क\u{941}\u{902}भ रास"),
            keywords: &["क\u{941}\u{902}भ", "पाणी", "रास", "वाहक"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("Aquarius"),
            keywords: &["Aquarius", "air", "pembawa", "zodiak"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("Aquarius"),
            keywords: &["Aquarius", "ilma", "portatur", "żodjaku"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("က\u{102f}\u{1036}"),
            keywords: &[
                "က\u{102f}\u{1036}",
                "က\u{102f}\u{1036}ရာသ\u{102e}",
                "က\u{102f}\u{1036}ရာသ\u{102e}ရ\u{102f}ပ\u{103a}",
                "ဆယ\u{1037}\u{103a}န\u{103e}စ\u{103a}ရာသ\u{102e}ခ\u{103d}င\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("Vannmannen"),
            keywords: &["Vannmannen", "stjernetegn", "vann"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("क\u{941}म\u{94d}भ"),
            keywords: &["क\u{941}म\u{94d}भ", "धारक", "पानी", "राशि"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("waterman (sterrenbeeld)"),
            keywords: &[
                "Aquarius",
                "dierenriem",
                "drager",
                "water",
                "waterman (sterrenbeeld)",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("Vassmannen"),
            keywords: &["Vassmannen", "stjerneteikn", "vatn"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("କ\u{b41}ମ\u{b4d}ଭ"),
            keywords: &[
                "କ\u{b41}ମ\u{b4d}ଭ",
                "ଜଳ",
                "ବ\u{b3e}ହକ",
                "ର\u{b3e}ଶ\u{b3f}ଚକ\u{b4d}ର",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਕ\u{a41}\u{a70}ਭ ਰਾਸ\u{a3c}ੀ"),
            keywords: &["ਕ\u{a41}\u{a70}ਭ", "ਰਾਸ\u{a3c}ੀ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("برج دلو"),
            keywords: &["برج دلو", "ب\u{64f}رج", "بیرا", "پانی"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Akwériọs"),
            keywords: &[
                "Akwériọs",
                "Pẹ\u{301}sin Wé Kárí Sọ\u{301}mtin",
                "Water",
                "Zódiak",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("Wodnik"),
            keywords: &["Wodnik", "wodnik", "znak zodiaku", "zodiak"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("دلو"),
            keywords: &["اوبه", "دلو", "مرغومی", "وړونکی"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("signo de Aquário"),
            keywords: &["aquário", "signo de Aquário", "zodíaco", "água"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("Aquário"),
            keywords: &["Aquário", "signo"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("Acuario"),
            keywords: &["Acuario", "soporte", "yaku", "zodiaco"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("zodia Vărsător"),
            keywords: &["vărsător", "zodia Vărsător", "zodiac", "zodie"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-074"),
            keywords: &["E10-074"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("знак зодиака Водолей"),
            keywords: &["водолей", "знак", "знак зодиака Водолей", "зодиак"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("akwariyusi"),
            keywords: &["akwariyusi", "amazi", "intumwa", "zodiyake"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("برج دلو"),
            keywords: &["برج دلو", "راس چڪر", "پاڻي", "پرچي وارو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ක\u{dd4}ම\u{dca}භ"),
            keywords: &[
                "ක\u{dd4}ම\u{dca}භ",
                "භ\u{dcf}රකර\u{dd4}",
                "ර\u{dcf}ශ\u{dd2}ය",
                "වත\u{dd4}ර",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("znamenie vodnára"),
            keywords: &["vodna", "vodnár", "znamenie vodnára", "zverokruh"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("vodnar"),
            keywords: &["nosec", "voda", "vodnar", "zodiak"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("cutubka xiddigga biyaha"),
            keywords: &[
                "biyo",
                "cutubka meecaad",
                "cutubka xiddigga biyaha",
                "sidaha",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("ujori"),
            keywords: &["mbajtës", "ujori", "ujë", "zodiak"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("водолија у хороскопу"),
            keywords: &["вoдолија", "водолија у хороскопу", "зoдиjaк"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("vodolija u horoskopu"),
            keywords: &["vodolija", "vodolija u horoskopu", "zodijak"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("Vattumannen"),
            keywords: &["Vattumannen", "stjärntecken"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("nyota ya ndoo"),
            keywords: &["hamali", "maji", "ndoo", "nyota ya ndoo", "zodiaki"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("கும\u{bcd}ப ர\u{bbe}சி"),
            keywords: &[
                "இர\u{bbe}சி",
                "கும\u{bcd}ப ர\u{bbe}சி",
                "கும\u{bcd}பம\u{bcd}",
                "நட\u{bcd}சத\u{bcd}திரம\u{bcd}",
                "ர\u{bbe}சி",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("కుంభర\u{c3e}శ\u{c3f}"),
            keywords: &["కుంభర\u{c3e}శ\u{c3f}", "చక\u{c4d}రం"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("Далв"),
            keywords: &["Далв", "бурҷи дувоздаҳгона", "доранда", "об"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ราศ\u{e35}ก\u{e38}มภ\u{e4c}"),
            keywords: &["จ\u{e31}กรราศ\u{e35}", "ราศ\u{e35}ก\u{e38}มภ\u{e4c}"],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ኣክዋርዩስ"),
            keywords: &["መበጻጽሒ", "ማይ", "ኣክዋርዩስ", "ዞድያክ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("Gowa"),
            keywords: &["Gowa", "göteriji", "suw", "täleýnama"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("Fineʻutuvai (pupunga)"),
            keywords: &[
                "Fineʻutuvai (pupunga)",
                "fefine",
                "pupunga",
                "tangata",
                "ʻutuvai",
            ],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("kova burcu"),
            keywords: &["burçlar", "kova burcu"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("سوغلا"),
            keywords: &["تۇتار", "سوغلا", "سۇ", "مۆچەل"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("Водолій"),
            keywords: &["Водолій", "вода", "зодіак", "носій"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("برج دلو"),
            keywords: &["برج", "برج دلو", "پانی"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("qovg‘a burji"),
            keywords: &["burj", "qovg‘a", "qovg‘a burji"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("Bảo Bình"),
            keywords: &["Bảo Bình", "cung hoàng đạo", "người mang", "nước"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("Wersóo"),
            keywords: &["Wersóo", "ndox", "sojak", "yanukat"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("I-Aquarius"),
            keywords: &["I-Aquarius", "amanzi", "i-zodiac", "umthwali"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Aquarius"),
            keywords: &["Aquarius", "olùjẹ\u{301} orúkọ", "omi", "àmi oṣù ìbí"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("水瓶座"),
            keywords: &["搬運嘅人", "星座", "水", "水瓶座"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("水瓶座"),
            keywords: &["搬运嘅人", "星座", "水", "水瓶座"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("水瓶座"),
            keywords: &["星座", "水", "水瓶座"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("水瓶座"),
            keywords: &["星座", "水瓶座"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("aquarius"),
            keywords: &["amanzi", "aquarius", "inkanyezi", "isithiyi"],
        },
    ],
};
#[doc = "♓"]
pub const PISCES: crate::Emoji = crate::Emoji {
    glyph: "♓",
    codepoint: "2653",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "Pisces",
    group: "Symbols",
    subgroup: "zodiac",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("Visse-sterrebeeld"),
            keywords: &["Visse-sterrebeeld", "diereriem", "vis"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ፓይሲስ"),
            keywords: &["ዓሣ", "ዞዲያክ", "ፓይሲስ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("الحوت"),
            keywords: &["الأبراج", "الحوت"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("মীন ৰ\u{9be}শি"),
            keywords: &["মীন ৰ\u{9be}শি", "মৎস\u{9cd}য", "ৰ\u{9be}শিচক\u{9cd}ৰ"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("balıqlar"),
            keywords: &["balıq", "balıqlar", "zodiak"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("знак задыяка Рыбы"),
            keywords: &["задыяк", "знак задыяка Рыбы", "рыба", "рыбы"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Зодиакален знак риби"),
            keywords: &[
                "Зодиакален знак риби",
                "зодиак",
                "зодиакален знак",
                "зодия",
                "риби",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("মীন"),
            keywords: &["মীন", "র\u{9be}শিচক\u{9cd}র"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("ar Pesked"),
            keywords: &["Pesked", "Psc", "ar Pesked", "zodiak"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("ribe"),
            keywords: &["horoskop", "ribe", "znak", "zodijak"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("Peixos"),
            keywords: &["Peixos", "peix", "zodíac"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏂᏣᏗ"),
            keywords: &["ᎠᏂᏣᏗ", "ᎠᏣᏗ", "ᏃᏈᏏ ᏓᏟᎶᏍᏗᏍᎲᎢ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("ryby"),
            keywords: &["ryba", "ryby", "zvěrokruh"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("y Pysgod"),
            keywords: &["pysgod", "sidydd", "y Pysgod"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("fisken"),
            keywords: &["fisken", "stjernetegn"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Fische (Sternzeichen)"),
            keywords: &["Fische", "Fische (Sternzeichen)", "Sternzeichen"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("Ιχθύς"),
            keywords: &["Ιχθύες", "Ιχθύς", "ζώδιο", "ψάρι", "ψάρια"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("Pisces"),
            keywords: &["Pisces", "fish", "zodiac"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("Piscis"),
            keywords: &["Piscis", "pescado", "pez", "piscis", "zodiaco"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["Piscis", "pez", "piscis", "zodíaco"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("Kalad"),
            keywords: &["Kalad", "sodiaak"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("pisces"),
            keywords: &["arrain", "pisces", "zodiako"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("برج حوت"),
            keywords: &["اسفند", "برج", "حوت"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kalat-merkki"),
            keywords: &["horoskooppi", "horoskooppimerkki", "kalat", "kalat-merkki"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("Pisces"),
            keywords: &["Pisces", "isda", "zodiac"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("Fiskarnir"),
            keywords: &["Fiskarnir", "fiskamerkið", "fiskur", "stjørnumerki"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("poissons"),
            keywords: &["poissons", "zodiaque"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("Poissons"),
            keywords: &["Poissons", "zodiaque"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("na hÉisc"),
            keywords: &["Pisces", "na hÉisc", "stoidiaca"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("Na h-Èisg"),
            keywords: &[
                "Na h-Èisg",
                "grian-chrios",
                "grian-chriosach",
                "iasg",
                "pisces",
                "èisg",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("Pisces"),
            keywords: &["Pisces", "peixes", "zodíaco"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("મીન"),
            keywords: &["મીન", "રાશિચક\u{acd}ર"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("Pisces"),
            keywords: &["Pisces", "kifi", "zodiac"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("מזל דגים"),
            keywords: &["גלגל המזלות", "דגים", "מזל"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("मीन, राशि"),
            keywords: &["मीन", "मीन, राशि", "राशि"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("astrološki znak riba"),
            keywords: &["astrološki znak riba", "ribe", "zodijak"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("halak csillagjegy"),
            keywords: &["halak", "halak csillagjegy", "horoszkóp"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("Ձկներ"),
            keywords: &["Ձկներ", "կենդանակերպ", "ձուկ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("Pisces"),
            keywords: &["Pisces", "ikan", "pisces", "zodiak"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("Paịces"),
            keywords: &["Azụ\u{300}", "Paịces", "zodịak"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("fiskar"),
            keywords: &["fiskar", "stjörnumerki"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("Segno zodiacale dei Pesci"),
            keywords: &["Pesci", "Segno zodiacale dei Pesci", "zodiaco"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("うお座"),
            keywords: &["うお座", "星座", "魚座"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("Lintang Pisces"),
            keywords: &["Lintang Pisces", "Pisces", "iwak", "palintangan"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("თევზები"),
            keywords: &["ზოდიაქო", "თევზები", "თევზი", "ჰოროსკოპი"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("Islem"),
            keywords: &["Islem"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("балықтар белгісі"),
            keywords: &["балық", "балықтар белгісі", "зодиак"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("fisken"),
            keywords: &["fisken", "stjernetegn"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some(
                "សញ\u{17d2}ញាតារាសាស\u{17d2}ត\u{17d2}រអ\u{17ca}\u{17ba}រ\u{17c9}\u{17bb}បប\u{17d2}រភទទ\u{17b8}១២ ត\u{17d2}រ\u{17b8}",
            ),
            keywords: &[
                "ក\u{17bb}រ",
                "ជ\u{17d2}រ\u{17bc}ក",
                "សញ\u{17d2}ញាតារាសាស\u{17d2}ត\u{17d2}រអ\u{17ca}\u{17ba}រ\u{17c9}\u{17bb}បប\u{17d2}រភទទ\u{17b8}១២ ត\u{17d2}រ\u{17b8}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಮೀನ"),
            keywords: &["ಮೀನ", "ರಾಶ\u{cbf}ಚಕ\u{ccd}ರ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("물고기자리"),
            keywords: &["물고기", "물고기자리", "별", "별자리"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("मीन"),
            keywords: &["न\u{941}स\u{94d}त\u{94d}य\u{947}\u{902}", "मीन", "रास"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("балыктар"),
            keywords: &["балык", "балыктар", "зодиак"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Fësch (Stärzeechen)"),
            keywords: &["Fësch", "Fësch (Stärzeechen)", "Stärzeechen"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ລາສ\u{eb5}ມ\u{eb4}ນ"),
            keywords: &["ລາສ\u{eb5}", "ລາສ\u{eb5}ມ\u{eb4}ນ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("žuvys"),
            keywords: &["zodiakas", "žuvis", "žuvys"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("zodiaka zīme Zivis"),
            keywords: &["zivis", "zodiaka zīme Zivis", "zodiaks"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("Pisces"),
            keywords: &["Pisces", "ika", "poutiriao"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("хороскопски знак риби"),
            keywords: &["риби", "хороскоп", "хороскопски знак риби"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("മീനം"),
            keywords: &["മീനം", "ര\u{d3e}ശി"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("загасны орд"),
            keywords: &["загас", "загасны орд", "орд"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("मीन रास"),
            keywords: &["मीन", "मीन रास", "राशी"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("Pisces"),
            keywords: &["Pisces", "ikan", "zodiak"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("Pisces"),
            keywords: &["Pisces", "ħut", "żodjaku"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("မ\u{102d}န\u{103a}"),
            keywords: &[
                "ဆယ\u{1037}\u{103a}န\u{103e}စ\u{103a}ရာသ\u{102e}ခ\u{103d}င\u{103a}",
                "မ\u{102d}န\u{103a}",
                "မ\u{102d}န\u{103a}ရာသ\u{102e}",
                "မ\u{102d}န\u{103a}ရာသ\u{102e}ရ\u{102f}ပ\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("Fiskene"),
            keywords: &["Fiskene", "fisk", "stjernetegn"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("मिन"),
            keywords: &["माछा", "मिन", "राशि"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("vissen (sterrenbeeld)"),
            keywords: &["Pisces", "dierenriem", "vissen", "vissen (sterrenbeeld)"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("Fiskane"),
            keywords: &["Fiskane", "fisk", "stjerneteikn"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ମୀନ"),
            keywords: &["ମ\u{b3e}ଛ", "ମୀନ", "ର\u{b3e}ଶ\u{b3f}ଚକ\u{b4d}ର"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਮੀਨ ਰਾਸ\u{a3c}ੀ"),
            keywords: &["ਮੀਨ", "ਰਾਸ\u{a3c}ੀ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ب\u{64f}رج حوت"),
            keywords: &["ب\u{64f}رج", "ب\u{64f}رج حوت", "مچھی"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Paísiz"),
            keywords: &["Fish", "Paísiz", "Zódiak"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("Ryby"),
            keywords: &["Ryby", "ryby", "znak zodiaku", "zodiak"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("حوت"),
            keywords: &["حوت", "مرغومی", "کب"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("signo de Peixes"),
            keywords: &["peixes", "signo de Peixes", "zodíaco"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("Peixes"),
            keywords: &["Peixes", "signo"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("Piscis"),
            keywords: &["Piscis", "challwa", "zodiaco"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("zodia Pești"),
            keywords: &["pești", "zodia Pești", "zodiac", "zodie"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-075"),
            keywords: &["E10-075"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("знак зодиака Рыбы"),
            keywords: &["знак", "знак зодиака Рыбы", "зодиак", "рыбы"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("Pisikesi"),
            keywords: &["Pisikesi", "ifi", "zodiyake"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("برج حوت"),
            keywords: &["برج حوت", "راس چڪر", "مڇي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ම\u{dd3}න"),
            keywords: &["ම\u{dd3}න", "ර\u{dcf}ශ\u{dd2}ය"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("znamenie rýb"),
            keywords: &["ryba", "znamenie rýb", "zverokruh"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("ribi"),
            keywords: &["riba", "ribi", "zodiak"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("cutubka xiddiga ee kalluunka"),
            keywords: &["cutubka meecaad", "cutubka xiddiga ee kalluunka", "kalluun"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("peshqit"),
            keywords: &["peshk", "peshqit", "zodiak"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("рибе у хороскопу"),
            keywords: &["зoдиjaк", "рибe", "рибе у хороскопу"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("ribe u horoskopu"),
            keywords: &["ribe", "ribe u horoskopu", "zodijak"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("Fiskarna"),
            keywords: &["Fiskarna", "stjärntecken"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("nyota ya samaki"),
            keywords: &["nyota ya samaki", "zodiaki"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ம\u{bc0}னம\u{bcd}"),
            keywords: &[
                "இர\u{bbe}சி",
                "நட\u{bcd}சத\u{bcd}திரம\u{bcd}",
                "ம\u{bc0}னம\u{bcd}",
                "ர\u{bbe}சி",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("మ\u{c40}నర\u{c3e}శ\u{c3f}"),
            keywords: &["చక\u{c4d}రం", "మ\u{c40}నర\u{c3e}శ\u{c3f}"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("Ҳут"),
            keywords: &["бурҷи дувоздаҳгона", "Ҳут", "ҳут"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ราศ\u{e35}ม\u{e35}น"),
            keywords: &["จ\u{e31}กรราศ\u{e35}", "ราศ\u{e35}ม\u{e35}น"],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ፒስከስ"),
            keywords: &["ዓሳ", "ዞድያክ", "ፒስከስ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("Hut"),
            keywords: &["Hut", "balyk", "täleýnama"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("Ongo ika (pupunga)"),
            keywords: &["Ongo ika (pupunga)", "ika", "ongo", "pupunga"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("balık burcu"),
            keywords: &["balık burcu", "burçlar"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("بېلىقچى"),
            keywords: &["بېلىق", "بېلىقچى", "مۆچەل"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("Риби"),
            keywords: &["Риби", "зодіак", "риба"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("برج حوت"),
            keywords: &["برج", "برج حوت", "مچھلی"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("baliq burji"),
            keywords: &["baliq", "baliq burji", "burj"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("Song Ngư"),
            keywords: &["Song Ngư", "con cá", "cung hoàng đạo", "song ngư"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("Jën yi"),
            keywords: &["Jën yi", "jën", "sojak"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("I-Pisces"),
            keywords: &["I-Pisces", "i-zodiac", "intlanzi"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Pisces"),
            keywords: &["Pisces", "àmi oṣù ìbí", "ẹja"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("雙魚座"),
            keywords: &["星座", "雙魚座", "魚"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("双鱼座"),
            keywords: &["双鱼座", "星座", "鱼"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("双鱼座"),
            keywords: &["双鱼座", "星座", "鱼"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("雙魚座"),
            keywords: &["星座", "雙魚座"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("pisces"),
            keywords: &["inhlanzi", "inkanyezi", "pisces"],
        },
    ],
};
#[doc = "⛎"]
pub const OPHIUCHUS: crate::Emoji = crate::Emoji {
    glyph: "⛎",
    codepoint: "26CE",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "Ophiuchus",
    group: "Symbols",
    subgroup: "zodiac",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("Slangdraer-sterrebeeld"),
            keywords: &["Slangdraer-sterrebeeld", "diereriem", "draer", "slang"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ኦፊዩቹስ"),
            keywords: &["ተሸካሚ", "እባብ", "ኦፊዩቹስ", "ዞዲያክ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("الحواء"),
            keywords: &["الأبراج", "الحواء"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("অফিউক\u{9be}ছ"),
            keywords: &[
                "অফিউক\u{9be}ছ",
                "বহনক\u{9be}ৰী",
                "সৰীস\u{9c3}প",
                "সৰ\u{9cd}প",
                "ৰ\u{9be}শিচক\u{9cd}ৰ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("ilandaşıyan"),
            keywords: &["daşıyan", "ilan", "ilandaşıyan", "zodiak"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("знак задыяка Змеяносец"),
            keywords: &[
                "задыяк",
                "змеяносец",
                "змяя",
                "знак задыяка Змеяносец",
                "спакушальнік",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Зодиакален знак змиеносец"),
            keywords: &[
                "Зодиакален знак змиеносец",
                "змиеносец",
                "зодиак",
                "зодиакален знак",
                "зодия",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("অফিউচ\u{9c1}স"),
            keywords: &[
                "অফিউচ\u{9c1}স",
                "ব\u{9be}হক",
                "র\u{9be}শিচক\u{9cd}র",
                "স\u{9be}প",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("Naeretaer"),
            keywords: &["Naeretaer", "Oph", "zodiak"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("zmijonosac"),
            keywords: &["guja", "horoskop", "zmija", "zmijonosac", "zodijak"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("Ofiüc"),
            keywords: &["Ofiüc", "Serpentari", "serp", "zodíac"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎢᎾᏓ ᎦᏂᏴᏓ"),
            keywords: &["ᎠᏱᏙᎯ", "ᎢᎾᏓ", "ᎢᎾᏓ ᎦᏂᏴᏓ", "ᏃᏈᏏ ᏓᏟᎶᏍᏗᎲᎢ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("hadonoš"),
            keywords: &["had", "hadonoš", "plaz", "zvěrokruh"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("ophiuchus"),
            keywords: &["cludwr", "neidr", "ophiuchus", "sarff", "sidydd"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("slangebæreren"),
            keywords: &["slangebæreren", "stjernebillede"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Schlangenträger"),
            keywords: &["Schlangenträger", "Sternbild"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("Οφιούχος"),
            keywords: &["Οφιούχος", "ζώδιο", "φίδι"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("Ophiuchus"),
            keywords: &["Ophiuchus", "bearer", "serpent", "snake", "zodiac"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("Ofiuco"),
            keywords: &["Ofiuco", "ofiuco", "serpiente", "zodiaco"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["Ofiuco", "ofiuco", "serpiente", "zodíaco"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("Maokandja"),
            keywords: &["Maokandja", "sodiaak"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("ofiuko"),
            keywords: &["berri-ekarle", "ofiuko", "suge", "zodiako"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("برج حوا"),
            keywords: &["برج حوا", "برج فلکی", "حامل", "حوا", "زودیاک", "مار"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("käärmeenkantaja"),
            keywords: &[
                "horoskooppi",
                "horoskooppimerkki",
                "käärme",
                "käärmeenkantaja",
                "ophiuchus",
                "tähtikuvio",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("Ophiuchus"),
            keywords: &["Ophiuchus", "ahas", "serpiyente", "zodiac"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("Ormberin"),
            keywords: &["Ormberin", "berari", "ormur", "slanga", "stjørnumerki"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("serpentaire"),
            keywords: &["ophiuchus", "serpentaire", "zodiaque"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("Serpentaire"),
            keywords: &["Serpentaire", "zodiaque"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("Ophiuchus"),
            keywords: &["Ophiuchus", "stoidiaca"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("An Giùlanair-nathrach"),
            keywords: &[
                "An Giùlanair-nathrach",
                "giùlanair",
                "grian-chrios",
                "grian-chriosach",
                "nathair",
                "ophiuchus",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("Ofiúco"),
            keywords: &[
                "Ofiúco",
                "Ophiuchus",
                "cazador de serpes",
                "serpe",
                "zodíaco",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ત\u{ac7}રમી રાશિ (ઑફિકસ)"),
            keywords: &["ત\u{ac7}રમી રાશિ (ઑફિકસ)", "રાશિચક\u{acd}ર"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("Taurarin Ophiuchus"),
            keywords: &[
                "Taurarin Ophiuchus",
                "gamsheƙa",
                "maciji",
                "maɗauki kaya",
                "zodiac",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("נושא הנחש"),
            keywords: &["גלגל המזלות", "מזל", "נושא הנחש"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("सर\u{94d}प"),
            keywords: &["राशि", "सर\u{94d}प", "सर\u{94d}प, राशि"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("astrološki znak zmijonosca"),
            keywords: &[
                "astrološki znak zmijonosca",
                "zmija",
                "zmijonosac",
                "zodijak",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("kígyótartó"),
            keywords: &["csillagjegy", "horoszkóp", "kígyótartó"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("Օձակիր"),
            keywords: &["Օձակիր", "կենդանակերպ", "կրող", "օձ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("Ophiuchus"),
            keywords: &["Ophiuchus", "ophiuchus", "pembawa", "ular", "zodiak"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("Ofiukus"),
            keywords: &["Ofiukus", "agwọ", "zodịak", "ọgba mgbochi"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("naðurvaldi"),
            keywords: &["naðra", "naðurvaldi", "snákur", "stjörnumerki"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("Segno zodiacale dell’Ofiuco"),
            keywords: &["Ofiuco", "Segno zodiacale dell’Ofiuco", "zodiaco"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("へびつかい座"),
            keywords: &["へびつかい座", "星座", "蛇遣座"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("Lintang Ophiuchus"),
            keywords: &[
                "Lintang Ophiuchus",
                "Ophiuchus",
                "nggremet",
                "palintangan",
                "sing nggawa",
                "ula",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("გველისმჭერი"),
            keywords: &["გველი", "გველისმჭერი", "ზოდიაქო", "ჰოროსკოპი"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: None,
            keywords: &["Aẓudyak"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("жылан көтеруші белгісі"),
            keywords: &["жылан", "жылан көтеруші белгісі", "зодиак", "құюшы"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("slangebæreren"),
            keywords: &["slangebæreren", "stjernebillede"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some(
                "សញ\u{17d2}ញាតារាសាស\u{17d2}ត\u{17d2}រអ\u{17ca}\u{17ba}រ\u{17c9}\u{17bb}បប\u{17d2}រភទទ\u{17b8}១៣ ពស\u{17cb}",
            ),
            keywords: &[
                "ពស\u{17cb}",
                "ម\u{17d2}សាញ\u{17cb}",
                "សញ\u{17d2}ញាតារាសស\u{17d2}ត\u{17d2}រអ\u{17ca}\u{17ba}រ\u{17c9}\u{17bb}បប\u{17d2}រភទទ\u{17b8}១៣ ពស\u{17cb}",
                "សញ\u{17d2}ញាតារាសាស\u{17d2}ត\u{17d2}រអ\u{17ca}\u{17ba}រ\u{17c9}\u{17bb}បប\u{17d2}រភទទ\u{17b8}១៣ ពស\u{17cb}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಆಫ\u{ccd}ಯ\u{cc2}ಕಸ\u{ccd}"),
            keywords: &[
                "ಅಫ\u{ccd}ಯ\u{cc2}ಕಸ\u{ccd}",
                "ಆಫ\u{ccd}ಯ\u{cc2}ಕಸ\u{ccd}",
                "ರಾಶ\u{cbf}",
                "ಸರ\u{ccd}ಪ",
                "ಹಾವು",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("뱀주인자리"),
            keywords: &["뱀주인자리", "별자리"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("भ\u{941}ज\u{902}गधारी"),
            keywords: &[
                "जिवाण\u{947}\u{902}",
                "ब\u{947}रर",
                "भ\u{941}ज\u{902}गधारी",
                "रास",
                "सरपटपी",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("жыланчы"),
            keywords: &["балык", "жыланчы", "зодиак"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Schlaangenträger (Ophiuchus)"),
            keywords: &[
                "Schlaang",
                "Schlaangenträger",
                "Schlaangenträger (Ophiuchus)",
                "Stärzeechen",
                "Träger",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ລາສ\u{eb5}ງ\u{eb9}"),
            keywords: &["ລາສ\u{eb5}", "ລາສ\u{eb5}ງ\u{eb9}"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("gyvatnešis"),
            keywords: &["gyvatnešis", "gyvatė", "nešėjas", "zodiakas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("zodiaka zīme Čūsknesis"),
            keywords: &["zodiaka zīme Čūsknesis", "zodiaks", "čūsknesis"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("Ophiuchus"),
            keywords: &["Ophiuchus", "kaikawe", "nākahi", "poutiriao"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("хороскопски знак змијоносец"),
            keywords: &["змијоносец", "хороскоп", "хороскопски знак змијоносец"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("സർപ\u{d4d}പധരൻ"),
            keywords: &["സർപ\u{d4d}പധരൻ"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("одны орд"),
            keywords: &["од", "одны орд", "орд"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("ऑफिय\u{941}चस"),
            keywords: &["ऑफिय\u{941}चस", "नागमोडी", "रास", "वाहक", "साप"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("Ophiuchus"),
            keywords: &["Ophiuchus", "pembawa", "ular", "zodiak"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("Ophiuchus"),
            keywords: &["Ophiuchus", "portatur", "serp", "serpent", "żodjaku"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အော\u{1037}ဖ\u{102e}ယ\u{1030}းကပ\u{103a}စ\u{103a}"),
            keywords: &[
                "ဆယ\u{1037}\u{103a}န\u{103e}စ\u{103a}ရာသ\u{102e}ခ\u{103d}င\u{103a}",
                "မြ\u{103d}ေနဂါး",
                "အော\u{1037}ဖ\u{102e}ယ\u{1030}းကပ\u{103a}စ\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("Slangebæreren"),
            keywords: &["Slangebæreren", "bærer", "slange", "stjernetegn"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("अफिक\u{941}अस"),
            keywords: &["अफिक\u{941}अस", "धारक", "नाग", "राशि", "सर\u{94d}प"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("slangendrager (sterrenbeeld)"),
            keywords: &[
                "Ophiuchus",
                "dierenriem",
                "drager",
                "serpent",
                "slang",
                "slangendrager (sterrenbeeld)",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("Slangeberaren"),
            keywords: &["Slangeberaren", "berar", "slange", "stjerneteikn"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଓଫ\u{b3f}ଉଚ\u{b41}ସ\u{b4d}\u{200c}"),
            keywords: &[
                "ଓଫ\u{b3f}ଉଚ\u{b41}ସ\u{b4d}\u{200c}",
                "ବଡ ସ\u{b3e}ପ",
                "ବ\u{b3e}ହକ",
                "ର\u{b3e}ଶ\u{b3f}ଚକ\u{b4d}ର",
                "ସ\u{b3e}ପ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਓਪੀਊਚਸ"),
            keywords: &[
                "ਅਹ\u{a41}ਦ\u{a47}ਦਾਰ",
                "ਇ\u{a71}ਕ ਵ\u{a71}ਡਾ ਸ\u{a71}ਪ",
                "ਓਪੀਊਚਸ",
                "ਰਾਸ\u{a3c}ੀ ਚ\u{a71}ਕਰ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("علم النجوم"),
            keywords: &["اژدھا", "ب\u{64f}رج", "بیرا", "سپ", "علم النجوم"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Ọfiúkus"),
            keywords: &[
                "Pẹ\u{301}sin Wé Kárí Sọ\u{301}mtin",
                "Snek",
                "Sápẹnt",
                "Zódiak",
                "Ọfiúkus",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("Wężownik"),
            keywords: &["Wężownik", "wężownik", "znak zodiaku", "zodiak"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("اوفیوچس"),
            keywords: &["اوفیوچس", "اژدها", "مار", "مرغومی", "وړونکی"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("signo de Ofiúco"),
            keywords: &["Ofiúco", "cobra", "serpente", "signo de Ofiúco", "zodíaco"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("Serpentário"),
            keywords: &["Serpentário", "zodíaco"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("Ofiuco"),
            keywords: &["Ofiuco", "katari", "soporte", "zodiaco"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("zodia Ofiucus"),
            keywords: &["ofiucus", "zodia Ofiucus", "zodiac", "zodie", "șarpe"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-103"),
            keywords: &["E10-103"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("знак зодиака Змееносец"),
            keywords: &["змееносец", "знак", "знак зодиака Змееносец", "зодиак"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("Ofiyukusi"),
            keywords: &["Ofiyukusi", "intumwa", "inzoka", "zodiyake"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("علم نجوم"),
            keywords: &["ازدها", "بيرو", "راس چڪر", "علم نجوم", "نانگ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ඔෆ\u{dd2}කස\u{dca}"),
            keywords: &[
                "ඔෆ\u{dd2}කස\u{dca}",
                "දරන\u{dca}න\u{dcf}",
                "නය\u{dcf}",
                "ර\u{dcf}ශ\u{dd2}ය",
                "සර\u{dca}පය\u{dcf}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("znamenie hadonosa"),
            keywords: &["had", "znamenie hadonosa", "zverokruh"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("kačenosec"),
            keywords: &["kača", "kačenosec", "nosec", "zodiak"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("abeeso"),
            keywords: &["abeeso", "cutubka meecaad", "mas", "sidaha"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("ofiuku"),
            keywords: &["gjarpër", "mbajtës", "ofiuku", "zodiak"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("змијоноша"),
            keywords: &["зoдиjaк", "змиja", "змиjoнoша", "змијоноша"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("zmijonoša"),
            keywords: &["zmija", "zmijonoša", "zodijak"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("Ormbäraren"),
            keywords: &["Ormbäraren", "stjärnbild"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("opichasi"),
            keywords: &["hamali", "joka", "nyoka", "opichasi", "zodiaki"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ஓஃபிய\u{bbe}கெஸ\u{bcd}"),
            keywords: &["ஓஃபிய\u{bbe}கெஸ\u{bcd}", "நட\u{bcd}சத\u{bcd}திரம\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("జపన\u{c40}స\u{c4d} ర\u{c3e}శ\u{c3f}చక\u{c4d}రంల\u{c4b} 13వ గుర\u{c4d}తు"),
            keywords: &[
                "జపన\u{c40}స\u{c4d} ర\u{c3e}శ\u{c3f}చక\u{c4d}రంల\u{c4b} 13వ గుర\u{c4d}తు",
                "జప\u{c3e}న\u{c4d}",
                "ర\u{c3e}శ\u{c3f}చక\u{c4d}రం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("Ophiuchus"),
            keywords: &["Ophiuchus", "бурҷи дувоздаҳгона", "доранда", "мор"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("กล\u{e38}\u{e48}มดาวคนแบกง\u{e39}"),
            keywords: &["กล\u{e38}\u{e48}มดาวคนแบกง\u{e39}", "จ\u{e31}กรราศ\u{e35}"],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ኦፊኩስ"),
            keywords: &["መበጻጽሒ", "ሰርፐንት", "ተመን", "ኦፊኩስ", "ዞድያክ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("Ýylançy"),
            keywords: &["göteriji", "süýreniji", "täleýnama", "Ýylançy", "ýylan"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("Tangata toʻo ngata (pupunga)"),
            keywords: &[
                "Tangata",
                "Tangata toʻo ngata (pupunga)",
                "ngata",
                "pupunga",
            ],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("Yılancı"),
            keywords: &["Yılancı", "burçlar"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("يىلانچى"),
            keywords: &["تۇتار", "مۆچەل", "يىلان", "يىلانچى"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("Змієносець"),
            keywords: &["Змієносець", "змія", "зодіак", "носій"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("برج حوا"),
            keywords: &["برج", "برج حوا", "سانپ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("ilon tashuvchi"),
            keywords: &["burj", "ilon", "ilon tashuvchi"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("Xà Phu"),
            keywords: &["Xà Phu", "con rắn", "cung hoàng đạo", "người mang", "rắn"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("U buñ baare"),
            keywords: &["U buñ baare", "jaan", "sojak", "yanukat"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("I-Ophiuchus"),
            keywords: &["I-Ophiuchus", "i-zodiac", "inyoka", "irhamncwa", "umthwali"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ophiuchus"),
            keywords: &["Ophiuchus", "afàyàfà", "ejò", "àmi oṣù ìbí", "ẹní gba ǹkan"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("蛇夫座"),
            keywords: &["搬運嘅人", "生肖", "蛇", "蛇夫座"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("蛇夫座"),
            keywords: &["搬运嘅人", "生肖", "蛇", "蛇夫座"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("蛇夫座"),
            keywords: &["星座", "蛇", "蛇夫座"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("蛇夫座"),
            keywords: &["星座", "蛇夫座"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ophiuchus"),
            keywords: &["inkanyezi", "inyoka", "isithiyi", "ophiuchus"],
        },
    ],
};
