#[doc = "🏧"]
pub const ATM_SIGN: crate::Emoji = crate::Emoji {
    glyph: "🏧",
    codepoint: "1F3E7",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "ATM sign",
    group: "Symbols",
    subgroup: "transport-sign",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("ATM-teken"),
            keywords: &["ATM-teken", "OTM", "bank", "kassier", "kitsbank"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የኤቲኤም ምልክት"),
            keywords: &["ራስ-ሰር", "ባንክ", "ኤቲኤም", "የኤቲኤም ምልክት", "ገንዘብ ከፋይ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("علامة ماكينة صرف آلي"),
            keywords: &[
                "ATM",
                "صراف آلي",
                "علامة صراف آلي",
                "علامة ماكينة صراف آلي",
                "علامة ماكينة صرف آلي",
            ],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("এটিএম চিহ\u{9cd}ন"),
            keywords: &[
                "এটিএম",
                "এটিএম চিহ\u{9cd}ন",
                "টেল\u{9be}ৰ",
                "বেংক",
                "স\u{9cd}বয\u{9bc}ংক\u{9cd}ৰিয\u{9bc}",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("Bankomat işarəsi"),
            keywords: &["Bankomat işarəsi", "avtomat", "bank", "bankomat", "kassir"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("знак банкамата"),
            keywords: &[
                "банкамат",
                "гатоўка",
                "знак",
                "знак банкамата",
                "наяўныя",
                "тэрмінал",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("знак за банкомат"),
            keywords: &["банка", "банков автомат", "банкомат", "знак за банкомат"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("এটিএম চিহ\u{9cd}ন"),
            keywords: &[
                "এটিএম",
                "এটিএম চিহ\u{9cd}ন",
                "টেল\u{9be}র",
                "ব\u{9cd}য\u{9be}ংক",
                "স\u{9cd}বয\u{9bc}ংক\u{9cd}রিয\u{9bc}",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("arlun bilhedaouer"),
            keywords: &["arcʼhant", "arlun bilhedaouer", "bank", "bilhedaouer"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("oznaka bankomata"),
            keywords: &["banka", "bankomat", "blagajna", "oznaka bankomata", "znak"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("signe de caixer automàtic"),
            keywords: &[
                "atm",
                "banc",
                "caixer",
                "caixer automàtic",
                "signe de caixer automàtic",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ATM ᎪᏪᎵ"),
            keywords: &["ATM ᎪᏪᎵ", "atm", "ᎠᏕᎳ ᏧᏂᏗᎢ", "ᎠᏕᎳ ᏧᏂᏗᎢ ᏧᎸᏫᏍᏓᏁᎯ", "ᎤᏩᏌ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("značka bankomatu"),
            keywords: &["atm", "automat", "banka", "bankomat", "značka bankomatu"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("arwydd peiriant codi arian"),
            keywords: &[
                "arwydd peiriant codi arian",
                "atm",
                "awtomataidd",
                "banc",
                "clerc",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("hæveautomat"),
            keywords: &["dankortautomat", "hæve penge", "hæveautomat"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Symbol „Geldautomat“"),
            keywords: &["ATM", "Symbol „Geldautomat“"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("σήμα ATM"),
            keywords: &["ATM", "αυτοματοποιημένο", "αυτόματο", "σήμα ATM", "τράπεζα"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("ATM sign"),
            keywords: &["ATM sign", "atm", "automated", "bank", "teller"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: None,
            keywords: &[
                "ATM sign",
                "atm",
                "automated",
                "bank",
                "cashpoint",
                "teller",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("señal de cajero automático"),
            keywords: &["atm", "banco", "cajero", "señal de cajero automático"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("cajero automático"),
            keywords: &[
                "atm",
                "banco",
                "cajero",
                "cajero automático",
                "señal de cajero automático",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("cartel de cajero automático"),
            keywords: &["cartel de cajero automático"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("pangaautomaat"),
            keywords: &["pangaautomaat", "sularaha", "teller"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("kutxazainaren seinalea"),
            keywords: &["automatiko", "banku", "kutxazain", "kutxazainaren seinalea"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("نشان عابربانک"),
            keywords: &[
                "ای تی ام",
                "بانک",
                "خودپرداز",
                "دستگاه",
                "عابربانک",
                "نشان خودپرداز",
                "نشان عابربانک",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("pankkiautomaatti"),
            keywords: &["automaatti", "otto", "pankki", "pankkiautomaatti"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("tanda ng ATM"),
            keywords: &[
                "ATM",
                "automated",
                "bangko",
                "karatula",
                "tanda ng ATM",
                "teller",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("sjálvtøkuskeltið"),
            keywords: &["automat", "pengar", "sjálvtøka", "sjálvtøkuskeltið", "út"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("distributeur de billets"),
            keywords: &["argent", "dab", "distributeur de billets"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("guichet automatique bancaire"),
            keywords: &[
                "bancaire",
                "banque",
                "gab",
                "guichet",
                "guichet automatique bancaire",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("comhartha ATM"),
            keywords: &[
                "ATM",
                "UMB",
                "comhartha ATM",
                "meaisín bainc",
                "poll an bhainc",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("sanas ATM"),
            keywords: &[
                "airgead",
                "airgead-làimhe",
                "atm",
                "banca",
                "fèin-obrachail",
                "inneal",
                "neach-cunntaidh",
                "sanas ATM",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("sinal de caixeiro automático"),
            keywords: &[
                "banco",
                "caixeiro",
                "diñeiro",
                "sinal de caixeiro automático",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("એટીએમન\u{ac1}\u{a82} ચિહ\u{acd}ન"),
            keywords: &[
                "એટીએમ",
                "એટીએમન\u{ac1}\u{a82} ચિહ\u{acd}ન",
                "ઑટોમ\u{ac7}ટ\u{ac7}ડ",
                "ટ\u{ac7}લર",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("alamar ATM"),
            keywords: &["alamar ATM", "atm", "banki", "mai sarrafa kansa", "tela"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("שלט כספומט"),
            keywords: &["בנק", "כסף", "כספומט", "שלט כספומט"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ATM का चिह\u{94d}न"),
            keywords: &[
                "ATM का चिह\u{94d}न",
                "एटीएम",
                "ऑटोम\u{948}ट\u{947}ड ट\u{947}लर",
                "ट\u{947}लर",
                "स\u{94d}वचालित",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("znak za bankomat"),
            keywords: &["bankomat", "znak za bankomat"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("ATM-jel"),
            keywords: &["ATM-jel", "atm", "bankautomata"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("բանկոմատի նշան"),
            keywords: &["atm", "բանկ", "բանկոմատ", "բանկոմատի նշան", "գանձապահ"],
        },
        #[cfg(feature = "ia")]
        crate::Annotation {
            lang: "ia",
            tts: Some("signo de cassa automatic"),
            keywords: &[
                "automatic",
                "banca",
                "billetes",
                "cassa",
                "distributor",
                "signo de cassa automatic",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("tanda ATM"),
            keywords: &["atm", "bank", "otomatis", "tanda ATM", "teller"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("akara ATM"),
            keywords: &[
                "akara ATM",
                "akwụkwọ nnataego",
                "atm",
                "mmereonwe",
                "ụloakụ",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("hraðbanki"),
            keywords: &["banki", "hraðbanki"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("simbolo dello sportello bancomat"),
            keywords: &["ATM", "bancomat", "simbolo dello sportello bancomat"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ATM"),
            keywords: &["ATM", "現金自動預け払い機", "銀行"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("tandha ATM"),
            keywords: &["atm", "bank", "otomatis", "tandha ATM", "teller"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ბანკომატის ნიშანი"),
            keywords: &["ბანკი", "ბანკომატი", "ბანკომატის ნიშანი"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("tamacint n tedrimt tawurmant"),
            keywords: &["tamacint n tedrimt tawurmant"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("банкомат белгісі"),
            keywords: &[
                "автоматты",
                "банк",
                "банкомат",
                "банкомат белгісі",
                "есепші",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("pengeautomat"),
            keywords: &["dankortsautomat", "hæve penge", "pengeautomat"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("សញ\u{17d2}ញា អេធ\u{17b8}អ\u{17b9}ម"),
            keywords: &[
                "atm",
                "ធនាគារ",
                "សញ\u{17d2}ញា ATM",
                "សញ\u{17d2}ញា អេធ\u{17b8}អ\u{17b9}ម",
                "ស\u{17d2}វ\u{17d0}យប\u{17d2}រវត\u{17d2}ត\u{17b7}",
                "អេធ\u{17b8}អ\u{17b9}ម",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಎಟ\u{cbf}ಎಂ ಚ\u{cbf}ಹ\u{ccd}ನ\u{cc6}"),
            keywords: &[
                "ಎಟ\u{cbf}ಎಂ ಚ\u{cbf}ಹ\u{ccd}ನ\u{cc6}",
                "ಟ\u{cc6}ಲ\u{ccd}ಲರ\u{ccd}",
                "ಬ\u{ccd}ಯಾಂಕ\u{ccd}",
                "ಸ\u{ccd}ವಯಂಚಾಲ\u{cbf}ತ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("에이티엠"),
            keywords: &["ATM", "에이티엠", "현금인출기"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("एटीएम चिन\u{94d}न"),
            keywords: &[
                "एटीएम",
                "एटीएम चिन\u{94d}न",
                "ट\u{947}लर",
                "ब\u{901}क",
                "स\u{94d}वय\u{902}चलीत",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("банкомат белгиси"),
            keywords: &["банк", "банкомат", "банкомат белгиси"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Bancomat"),
            keywords: &["ATM", "Bancomat", "Bank", "ophiewen"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເອທ\u{eb5}ເອ\u{eb1}ມ"),
            keywords: &["ຕ\u{eb9}\u{ec9}ກ\u{ebb}ດເງ\u{eb4}ນ", "ເອທ\u{eb5}ເອ\u{eb1}ມ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("bankomato ženklas"),
            keywords: &[
                "automatinis",
                "bankas",
                "bankomatas",
                "bankomato ženklas",
                "kasininkas",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("bankomāta zīme"),
            keywords: &["ATM", "bankomāta zīme", "bankomāts", "nauda"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tohu ATM"),
            keywords: &["atm", "kaiwhitimoni", "pēke", "tohu ATM", "whakaaunoa"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("банкомат"),
            keywords: &["банка", "банкомат", "пари"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ATM ചിഹ\u{d4d}നം"),
            keywords: &["ATM ചിഹ\u{d4d}നം", "ടെല\u{d4d}ലർ മെഷീൻ"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("ATM-н тэмдэг"),
            keywords: &["ATM", "ATM-н тэмдэг", "автоматжуулсан", "банк", "теллер"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("ATM चिन\u{94d}ह"),
            keywords: &[
                "ATM चिन\u{94d}ह",
                "एटीएम",
                "ऑटोम\u{947}ट\u{947}ड",
                "ट\u{947}लर",
                "ब\u{901}क",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("tanda ATM"),
            keywords: &["atm", "automatik", "bank", "juruwang", "tanda ATM"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("tabella tal-ATM"),
            keywords: &["atm", "awtomatiku", "bank", "kaxxiera", "tabella tal-ATM"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "အေတ\u{102e}အမ\u{103a} င\u{103d}ေထ\u{102f}တ\u{103a}စက\u{103a} သင\u{103a}\u{1039}ကေတ",
            ),
            keywords: &[
                "ဘဏ\u{103a}င\u{103d}ေထ\u{102f}တ\u{103a}စက\u{103a}",
                "အလ\u{102d}\u{102f}အလျောက\u{103a}",
                "အေတ\u{102e}အမ\u{103a}",
                "အေတ\u{102e}အမ\u{103a} င\u{103d}ေထ\u{102f}တ\u{103a}စက\u{103a} သင\u{103a}\u{1039}ကေတ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("minibankskilt"),
            keywords: &["automatisk", "bank", "minibank", "minibankskilt", "penger"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("एटिएमको स\u{902}क\u{947}त"),
            keywords: &[
                "एटिएम",
                "एटिएम चिन\u{94d}ह",
                "एटिएमको स\u{902}क\u{947}त",
                "ट\u{947}लर",
                "ब\u{948}\u{902}क",
                "स\u{94d}वचालित",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("pinautomaat"),
            keywords: &["automaat", "pinautomaat", "pinnen"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("minibankskilt"),
            keywords: &["automatisk", "bank", "minibank", "minibankskilt", "pengar"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ATM ଚ\u{b3f}ହ\u{b4d}ନ"),
            keywords: &[
                "ATM ଚ\u{b3f}ହ\u{b4d}ନ",
                "atm",
                "ବ\u{b4d}ୟ\u{b3e}ଙ\u{b4d}କ । ଟେଲର\u{b4d}\u{200c}",
                "ସ\u{b4d}ୱଚ\u{b3e}ଳ\u{b3f}ତ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ATM ਚਿ\u{a70}ਨ\u{a4d}ਹ"),
            keywords: &[
                "ATM ਚਿ\u{a70}ਨ\u{a4d}ਹ",
                "ਏਟੀਐਮ",
                "ਗਿਣਨਾ",
                "ਸਵ\u{a48}-ਚਲਤ",
                "ਸਵ\u{a48}-ਚਲਤ ਗਿਣਤੀ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ATM دی علامت"),
            keywords: &["ATM دی علامت", "اے ٹی ایم", "بولن آلا", "بینک", "خودکار"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("ATM Sain"),
            keywords: &["ATM", "ATM Sain", "Bank", "Tẹ\u{301}la", "Ọtọmátik"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("znak bankomatu"),
            keywords: &["ATM", "znak bankomatu"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د ای ټي ايم نښه"),
            keywords: &["اټوماټ", "ای ټي ايم", "بانک", "د ای ټي ايم نښه", "ټيلر"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("símbolo de caixa automático"),
            keywords: &[
                "automático",
                "banco",
                "caixa",
                "símbolo de caixa automático",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("sinal de caixa automática"),
            keywords: &[
                "banco",
                "caixa",
                "sinal de caixa automática",
                "sinal de multibanco",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("ATM unancha"),
            keywords: &["ATM unancha", "atm", "banco", "cajero", "kikichansqa"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("simbol pentru bancomat"),
            keywords: &[
                "atm",
                "automat bancar",
                "bancomat",
                "simbol pentru bancomat",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-423"),
            keywords: &["E10-423"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("значок банкомата"),
            keywords: &[
                "банкомат",
                "выдача",
                "деньги",
                "значок банкомата",
                "наличные",
                "терминал",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("icyapa cy’imashini ya ATM"),
            keywords: &[
                "banki",
                "cyikoresha",
                "icyapa cy’imashini ya ATM",
                "icyuma cya atm",
                "ukora kuri gishe",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("اي ٽي ايم جي نشاني"),
            keywords: &[
                "اي ٽي ايم",
                "اي ٽي ايم جي نشاني",
                "بئنڪ",
                "خودڪار ٿيل",
                "ٽيلر",
            ],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ATM ලක\u{dd4}ණ"),
            keywords: &[
                "ATM ලක\u{dd4}ණ",
                "atm",
                "ටෙලර\u{dca}",
                "ස\u{dca}වයංක\u{dca}\u{200d}ර\u{dd2}ය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("bankomat"),
            keywords: &["automat", "banka", "bankomat", "hotovosť"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("znak za bankomat"),
            keywords: &["avtomat", "bankomat", "denar", "znak za bankomat"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("calaamadda ATM"),
            keywords: &["atm", "bangiga", "baqshinka", "calaamadda ATM", "tooska ah"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("shenja e bankomatit"),
            keywords: &["atm", "bankomat", "bankë", "shenja e bankomatit", "sportel"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("знак за банкомат"),
            keywords: &["бaнкoмaт", "знак за банкомат"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("znak za bankomat"),
            keywords: &["bankomat", "znak za bankomat"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("bankomat"),
            keywords: &["bankomat", "bankomatskylt", "pengar", "uttagsautomat"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("alama ya ATM"),
            keywords: &[
                "alama ya ATM",
                "atm",
                "benki",
                "mwenye kuhesabu",
                "otomatiki",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ஏடிஎம\u{bcd}"),
            keywords: &[
                "ஏடிஎம\u{bcd}",
                "த\u{bbe}னியங\u{bcd}கி இயந\u{bcd}திரம\u{bcd}",
                "வங\u{bcd}கி",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ఏట\u{c3f}ఎమ\u{c4d}"),
            keywords: &[
                "ఆట\u{c4b}మ\u{c47}ట\u{c46}డ\u{c4d}",
                "ఎట\u{c3f}ఎమ\u{c4d}",
                "ఏట\u{c3f}ఎమ\u{c4d}",
                "ట\u{c46}ల\u{c4d}లర\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("аломати \"Банкомат\""),
            keywords: &[
                "аломати \"Банкомат\"",
                "банкомат",
                "бонк",
                "гӯянда",
                "худкор",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เอท\u{e35}เอ\u{e47}ม"),
            keywords: &[
                "ธนาคาร",
                "ฝาก-ถอน",
                "อ\u{e31}ตโนม\u{e31}ต\u{e34}",
                "เคร\u{e37}\u{e48}องกดเง\u{e34}น",
                "เง\u{e34}น",
                "เอท\u{e35}เอ\u{e47}ม",
            ],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ምልክት ATM"),
            keywords: &["atm", "ምልክት ATM", "ቅልጡፍ", "ባንክ", "ተሓዚ ገንዘብ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("bankomat belgisi"),
            keywords: &[
                "atm",
                "awtomatlaşdyrylan",
                "bank",
                "bankomat",
                "bankomat belgisi",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("mīsini toho paʻanga"),
            keywords: &["mīsini", "mīsini toho paʻanga", "pangikē", "toho paʻanga"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("ATM işareti"),
            keywords: &["ATM işareti", "otomatik", "vezne"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("پۇلئالغۇ بەلگىسى"),
            keywords: &["atm", "ئاپتوماتىك", "بانكا", "پۇلئالغۇ", "پۇلئالغۇ بەلگىسى"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("символ банкомата"),
            keywords: &[
                "банкомат",
                "банківський автомат",
                "знак банкомата",
                "символ банкомата",
                "термінал самообслуговування",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("اے ٹی ایم کی علامت"),
            keywords: &["آٹو میٹک", "اے ٹی ایم", "اے ٹی ایم کی علامت", "بنک", "رقم"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("bankomat"),
            keywords: &["atm", "bank", "bankomat"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("ký hiệu ATM"),
            keywords: &["atm", "ký hiệu ATM", "máy rút tiền", "ngân hàng", "tự động"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("màndarga ATM"),
            keywords: &["atm", "bànk", "màndarga ATM", "otomated", "waxkat"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("uphawu lwe-ATM"),
            keywords: &[
                "ezenzekelayo",
                "i-atm",
                "ibhanki",
                "ithela",
                "uphawu lwe-ATM",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Aami ATM"),
            keywords: &[
                "Aami ATM",
                "ilé-ìfowópamó\u{329}",
                "tẹ\u{301}là",
                "àdásísẹ\u{301}",
                "ẹ\u{300}rọ apọwó",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("自動櫃員機標誌"),
            keywords: &["櫃檯職員", "自動化", "自動櫃員機", "自動櫃員機標誌", "銀行"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("自动柜员机标志"),
            keywords: &["柜台职员", "自动化", "自动柜员机", "自动柜员机标志", "银行"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("取款机"),
            keywords: &["取款机", "柜员机", "标识", "银行"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("提款機"),
            keywords: &["提款機"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("uphawu lwe-ATM"),
            keywords: &[
                "i-atm",
                "ibhange",
                "okuzenzakalelayo",
                "uphawu lwe-ATM",
                "uthela",
            ],
        },
    ],
};
#[doc = "🚮"]
pub const LITTER_IN_BIN_SIGN: crate::Emoji = crate::Emoji {
    glyph: "🚮",
    codepoint: "1F6AE",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "litter in bin sign",
    group: "Symbols",
    subgroup: "transport-sign",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("\"vullis in drom\"-teken"),
            keywords: &["\"vullis in drom\"-teken", "vullis", "vullisblik"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("በቆሻሻ መጣያ ጣሉ ምልክት"),
            keywords: &["ቆሻሻ", "ቆሻሻሣጥን", "በቆሻሻ መጣያ ጣሉ ምልክት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("إشارة صندوق النفايات"),
            keywords: &[
                "إشارة",
                "إشارة صندوق النفايات",
                "صندوق نفايات",
                "ضع النفايات في مكانها",
            ],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("এই প\u{9be}ত\u{9cd}ৰত আৱৰ\u{9cd}জন\u{9be} পেল\u{9be}ব চিহ\u{9cd}ন"),
            keywords: &[
                "আৱৰ\u{9cd}জন\u{9be}",
                "আৱৰ\u{9cd}জন\u{9be}ৰ প\u{9be}ত\u{9cd}ৰ",
                "এই প\u{9be}ত\u{9cd}ৰত আৱৰ\u{9cd}জন\u{9be} পেল\u{9be}ব চিহ\u{9cd}ন",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("zibili qutuya atın işarəsi"),
            keywords: &["zibil", "zibil qutusu", "zibili qutuya atın işarəsi"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("знак «кідайце смецце ў урну»"),
            keywords: &["знак", "знак «кідайце смецце ў урну»", "сметніца", "урна"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("символ за място за изхвърляне на боклук"),
            keywords: &[
                "боклук",
                "кошче за боклук",
                "символ за място за изхвърляне на боклук",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("বিন চিহ\u{9cd}নে লিট\u{9be}র"),
            keywords: &[
                "জঞ\u{9cd}জ\u{9be}ল",
                "জঞ\u{9cd}জ\u{9be}ল ব\u{9be}ক\u{9cd}স",
                "বিন চিহ\u{9cd}নে লিট\u{9be}র",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("arlun pod-lastez"),
            keywords: &["arlun pod-lastez", "pod-lastez", "poubelenn"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("znak za odlaganje otpada"),
            keywords: &["kanta", "otpaci", "smeće", "znak za odlaganje otpada"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("signe de paperera"),
            keywords: &["brossa", "paperera", "signe de paperera", "tirar la brossa"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᏲ ᏩᏗᏅᏗ ᎠᎪᎵᏰᏗ"),
            keywords: &["ᎤᏲ ᏩᏗᏅᏗ", "ᎤᏲ ᏩᏗᏅᏗ ᎠᎪᎵᏰᏗ", "ᎤᏲ ᏩᏗᏅᏗ ᎤᏒᏙᎾ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("značka odpadkového koše"),
            keywords: &[
                "koš",
                "odpad",
                "odpadky",
                "smetí",
                "značka odpadkového koše",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("arwydd sbwriel mewn bin"),
            keywords: &["arwydd sbwriel mewn bin", "bin sbwriel", "sbwriel"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("brug affaldsspanden"),
            keywords: &["brug affaldsspanden", "skraldespand"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Symbol „Papierkorb“"),
            keywords: &["Müll", "Sauberkeit", "Symbol „Papierkorb“"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("σήμα ρίψης σκουπιδιών σε κάδο"),
            keywords: &[
                "απορρίμματα",
                "κάδος απορριμμάτων",
                "κάδος σκουπιδιών",
                "σήμα ρίψης απορριμμάτων σε κάδο",
                "σήμα ρίψης σκουπιδιών σε κάδο",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("litter in bin sign"),
            keywords: &["litter", "litter bin", "litter in bin sign"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: None,
            keywords: &["litter", "litter bin", "litter in bin sign", "rubbish"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &[
                "garbage",
                "litter",
                "litter bin",
                "litter in bin sign",
                "trash",
            ],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("señal de usar papelera"),
            keywords: &[
                "basura",
                "papelera",
                "señal",
                "señal de usar papelera",
                "tirar la basura en la papelera",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("cartel cesto de basura"),
            keywords: &[
                "basura",
                "cartel cesto de basura",
                "papelera",
                "señal",
                "señal de usar papelera",
                "tirar la basura en la papelera",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["basura", "cartel cesto de basura", "cesto de basura"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("prügikasti silt"),
            keywords: &["praht", "prügikast", "prügikasti silt"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("zaborra ontzira botatzeko seinalea"),
            keywords: &[
                "zabor",
                "zaborra ontzira botatzeko seinalea",
                "zaborrontzi",
                "zakarrontzi",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("علامت ریختن زباله در زباله\u{200c}دان"),
            keywords: &[
                "آشغال",
                "زباله",
                "زباله\u{200c}دان",
                "سطل آشغال",
                "علامت ریختن زباله در زباله\u{200c}دان",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("roskat-merkki"),
            keywords: &["roska", "roskakori", "roskat-merkki"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("tanda na magtapon sa basurahan"),
            keywords: &[
                "basura",
                "basurahan",
                "magtapon",
                "palatandaan",
                "tanda na magtapon sa basurahan",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("ruskílatskelti"),
            keywords: &["burturkast", "rusk", "ruskílatskelti", "órudd"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("icône Poubelle"),
            keywords: &["icône Poubelle", "poubelle"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("comhartha bosca bruscair"),
            keywords: &[
                "bosca bruscair",
                "caith bruscar sa bhosca brúscair",
                "comhartha",
                "comhartha bosca bruscair",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("samhla “Sgudal dhan bhiona”"),
            keywords: &[
                "biona",
                "biona-sgudail",
                "samhla “Sgudal dhan bhiona”",
                "sgudal",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("sinal de tirar lixo na papeleira"),
            keywords: &["lixo", "papeleira", "sinal de tirar lixo na papeleira"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("કચરો કચરાપ\u{ac7}ટીમા\u{a82} ના\u{a82}ખોન\u{ac1}\u{a82} ચિહ\u{acd}ન"),
            keywords: &[
                "કચરા પ\u{ac7}ટી",
                "કચરાન\u{ac7} ત\u{ac7}ના સ\u{acd}થાન\u{ac7} ના\u{a82}ખો",
                "કચરાપ\u{ac7}ટીન\u{ac1}\u{a82} ચિહ\u{acd}ન",
                "કચરો કચરાપ\u{ac7}ટીમા\u{a82} ના\u{a82}ખોન\u{ac1}\u{a82} ચિહ\u{acd}ન",
                "ચિહ\u{acd}ન",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("alamar shara a cikin bola"),
            keywords: &["alamar shara a cikin bola", "kwandon shara", "shara"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("שלט פסולת לפח"),
            keywords: &["זבל", "פח", "פסולת", "שלט פסולת לפח"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("प\u{947}टी म\u{947}\u{902} कचरा डालन\u{947} का चिह\u{94d}न"),
            keywords: &[
                "कचरा",
                "कचरा प\u{947}टी",
                "प\u{947}टी म\u{947}\u{902} कचरा डालन\u{947} का चिह\u{94d}न",
                "प\u{947}टी म\u{947}\u{902} कचरा डाल\u{947}\u{902}",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("znak za koš za smeće"),
            keywords: &["koš za smeće", "otpad", "smeće", "znak za koš za smeće"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("szemét a kukában szimbólum"),
            keywords: &[
                "környezettudatosság",
                "szemetes",
                "szemét",
                "szemét a kukában szimbólum",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("աղբամանի նշան"),
            keywords: &["աղբ", "աղբամանի նշան", "աղբարկղ"],
        },
        #[cfg(feature = "ia")]
        crate::Annotation {
            lang: "ia",
            tts: Some("signo de receptaculo de immunditias"),
            keywords: &[
                "immunditias",
                "jectar",
                "receptaculo",
                "recipiente",
                "signo de receptaculo de immunditias",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("tanda membuang sampah"),
            keywords: &["keranjang sampah", "sampah", "tanda membuang sampah"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ntụsasị n’akara nkata"),
            keywords: &["nkata ntụsa", "ntụsasị", "ntụsasị n’akara nkata"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("merki, rusl í ruslatunnu"),
            keywords: &["merki, rusl í ruslatunnu", "rusl", "ruslafata"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("simbolo per la raccolta dei rifiuti"),
            keywords: &[
                "raccolta rifiuti",
                "simbolo",
                "simbolo per la raccolta dei rifiuti",
                "simbolo raccolta rifiuti",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ゴミ箱"),
            keywords: &["くずかご", "ごみ箱", "ゴミ捨て", "ゴミ箱"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("tandha mbuwang rereged ing wadhahe"),
            keywords: &[
                "rereged",
                "tandha mbuwang rereged ing wadhahe",
                "wadhah sampah",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ურნის ნიშანი"),
            keywords: &["ნაგავი", "ნაგვის ყუთი", "ურნის ნიშანი"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("tignit n iḍumman"),
            keywords: &["tignit n iḍumman"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("қоқысты себетке тастау белгісі"),
            keywords: &["қоқыс", "қоқыс жәшігі", "қоқысты себетке тастау белгісі"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("smid i skraldespanden"),
            keywords: &["skraldespand", "smid i skraldespanden"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("សញ\u{17d2}ញាចោលស\u{17c6}រាមក\u{17d2}ន\u{17bb}ងធ\u{17bb}ង"),
            keywords: &[
                "ក\u{17d2}ន\u{17bb}ងធ\u{17bb}ង",
                "ចោលស\u{17c6}រាម",
                "សញ\u{17d2}ញាចោលស\u{17c6}រាមក\u{17d2}ន\u{17bb}ងធ\u{17bb}ង",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕಸದ ಪ\u{cc6}ಟ\u{ccd}ಟ\u{cbf}ಗ\u{cc6} ಚ\u{cbf}ಹ\u{ccd}ನ\u{cc6}"),
            keywords: &[
                "ಅದರ ಸ\u{ccd}ಥಳದಲ\u{ccd}ಲ\u{cbf} ಕಸವನ\u{ccd}ನು ಹಾಕ\u{cbf}",
                "ಕಸದ ಪ\u{cc6}ಟ\u{ccd}ಟ\u{cbf}ಗ\u{cc6}",
                "ಕಸದ ಪ\u{cc6}ಟ\u{ccd}ಟ\u{cbf}ಗ\u{cc6} ಚ\u{cbf}ಹ\u{ccd}ನ\u{cc6}",
                "ಚ\u{cbf}ಹ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("쓰레기는 쓰레기통에"),
            keywords: &["쓰레기", "쓰레기는 쓰레기통에", "쓰레기통"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("लिटर इन बिन चिन\u{94d}न"),
            keywords: &["कचरो प\u{947}टी", "लिटर इन बिन चिन\u{94d}न", "लिटर बिन"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("таштандыга салуу белгиси"),
            keywords: &["куту", "таштанды", "таштандыга салуу белгиси"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Poubelleszeechen"),
            keywords: &["Dreck", "Poubelle", "Poubelleszeechen"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຖ\u{eb4}\u{ec9}ມຂ\u{eb5}\u{ec9}ເຫຍ\u{eb7}\u{ec9}ອໃສ\u{ec8}ຖ\u{eb1}ງ"),
            keywords: &[
                "ຖ\u{eb1}ງ",
                "ຖ\u{eb4}\u{ec9}ມຂ\u{eb5}\u{ec9}ເຫຍ\u{eb7}\u{ec9}ອ",
                "ຖ\u{eb4}\u{ec9}ມຂ\u{eb5}\u{ec9}ເຫຍ\u{eb7}\u{ec9}ອໃສ\u{ec8}ຖ\u{eb1}ງ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("šiukšlių metimo į šiukšliadėžes ženklas"),
            keywords: &[
                "šiukšliadėžė",
                "šiukšlių metimo į šiukšliadėžes ženklas",
                "šiukšlė",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("atkritumu urnas zīme"),
            keywords: &["atkritumi", "atkritumu urnas zīme", "urna"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tohu para roto ipu"),
            keywords: &["ipu para", "para", "tohu para roto ipu"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("канта за отпадоци"),
            keywords: &["канта", "канта за отпадоци", "отпадоци"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some(
                "ചവറ\u{d41}കൾ, ചവറ\u{d4d}റ\u{d41}ക\u{d41}ട\u{d4d}ടയിൽ നിക\u{d4d}ഷേപിക\u{d4d}ക\u{d41}ക",
            ),
            keywords: &[
                "ചവറ\u{d41}കൾ, ചവറ\u{d4d}റ\u{d41}ക\u{d41}ട\u{d4d}ടയിൽ നിക\u{d4d}ഷേപിക\u{d4d}ക\u{d41}ക",
                "ചവർ ഇടേണ\u{d4d}ടിടത\u{d4d}ത\u{d4d} ഇട\u{d41}ക",
                "ഡസ\u{d4d}റ\u{d4d}റ\u{d4d} ബിൻ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("хогоо хогийн саванд хийх тэмдэг"),
            keywords: &["хог", "хогийн сав", "хогоо хогийн саванд хийх тэмдэг"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("कचराप\u{947}टीच\u{947} चिन\u{94d}ह"),
            keywords: &[
                "कचरा",
                "कचरा प\u{947}टी",
                "कचरा प\u{947}टीच\u{947} चिन\u{94d}ह",
                "कचराप\u{947}टीच\u{947} चिन\u{94d}ह",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("tanda buang ke dalam tong sampah"),
            keywords: &["sampah", "tanda buang ke dalam tong sampah", "tong sampah"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("tabella ta’ barmil taż-żibel"),
            keywords: &["barmil taż-żibel", "tabella ta’ barmil taż-żibel", "żibel"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "အမ\u{103e}\u{102d}\u{102f}က\u{103a}ထည\u{1037}\u{103a}ရန\u{103a} ဆ\u{102d}\u{102f}င\u{103a}းဘ\u{102f}တ\u{103a}",
            ),
            keywords: &[
                "အမ\u{103e}\u{102d}\u{102f}က\u{103a}",
                "အမ\u{103e}\u{102d}\u{102f}က\u{103a}ထည\u{1037}\u{103a}ရန\u{103a} ဆ\u{102d}\u{102f}င\u{103a}းဘ\u{102f}တ\u{103a}",
                "အမ\u{103e}\u{102d}\u{102f}က\u{103a}ပ\u{102f}\u{1036}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("avfallsskilt"),
            keywords: &["avfall", "avfallsskilt", "skilt", "søppel"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("रद\u{94d}दी टोकरीको स\u{902}क\u{947}तमा फोहोर फालौ\u{902}"),
            keywords: &[
                "फोहोर",
                "फोहोर फाल\u{94d}न\u{947} टोकरी",
                "रद\u{94d}दी टोकरीको स\u{902}क\u{947}तमा फोहोर फालौ\u{902}",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("prullenbaksymbool"),
            keywords: &["afval", "prullenbak", "prullenbaksymbool"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("avfallsskilt"),
            keywords: &["avfall", "avfallsskilt", "skilt", "søppel"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଅଳ\u{b3f}ଆ ଡବ\u{b3e}ରେ ଫ\u{b3f}ଙ\u{b4d}ଗ\u{b3f}ବ\u{b3e} ଚ\u{b3f}ହ\u{b4d}ନ"),
            keywords: &[
                "ଅବର\u{b4d}ଜନ\u{b3e}",
                "ଅବର\u{b4d}ଜନ\u{b3e} ବ\u{b3e}କ\u{b4d}ସ",
                "ଅଳ\u{b3f}ଆ ଡବ\u{b3e}ରେ ଫ\u{b3f}ଙ\u{b4d}ଗ\u{b3f}ବ\u{b3e} ଚ\u{b3f}ହ\u{b4d}ନ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਕ\u{a42}ੜਾ ਇ\u{a71}ਥ\u{a47} ਸ\u{a41}\u{a71}ਟ\u{a4b} ਚਿ\u{a70}ਨ\u{a4d}ਹ"),
            keywords: &[
                "ਕ\u{a42}ੜਾ ਇ\u{a71}ਥ\u{a47} ਸ\u{a41}\u{a71}ਟ\u{a4b} ਚਿ\u{a70}ਨ\u{a4d}ਹ",
                "ਕ\u{a42}ੜਾ ਬਾਕਸ",
                "ਕ\u{a42}ੜ\u{a47} ਨ\u{a42}\u{a70} ਉਸ ਦੀ ਥਾ\u{a02} ‘ਤ\u{a47} ਸ\u{a41}\u{a71}ਟ\u{a4b}",
                "ਚਿ\u{a70}ਨ\u{a4d}ਹ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("کوڑا ٹوکری وچ س\u{64f}ٹن دی علامت"),
            keywords: &["کوڑا ٹوکری وچ س\u{64f}ٹن دی علامت", "کوڑا کرکٹ", "کچرا دان"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Dọtí Ínsaíd Dọstbin"),
            keywords: &["Dọstbin", "Dọtí", "Dọtí Ínsaíd Dọstbin"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("znak kosza na śmieci"),
            keywords: &[
                "kosz",
                "nie śmiecić",
                "znak kosza na śmieci",
                "śmieci",
                "śmiecić",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ورخړ په فاضلدانۍ کې نښه"),
            keywords: &["د ورخړ فاضلدانۍ", "ورخړ", "ورخړ په فاضلدانۍ کې نښه"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("símbolo de lixeira"),
            keywords: &[
                "coloque o lixo no lixo",
                "lixeira",
                "símbolo",
                "símbolo de lixeira",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("sinal de lixo no caixote do lixo"),
            keywords: &["cesto do lixo", "lixo", "sinal de lixo no caixote do lixo"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("chuqasqa qʼupa unancha"),
            keywords: &["chuqaq", "chuqasqa qʼupa", "chuqasqa qʼupa unancha"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("simbol pentru folosiți coșul de gunoi"),
            keywords: &[
                "coș de gunoi",
                "gunoi",
                "simbol pentru folosirea coșului de gunoi",
                "simbol pentru folosiți coșul de gunoi",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-962"),
            keywords: &["E10-962"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("бросайте мусор в урну"),
            keywords: &[
                "бросайте мусор в урну",
                "мусор",
                "мусорить запрещено",
                "урна",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("icyapa kigaragaza ahashyirwa imyanda"),
            keywords: &[
                "agatebo k’imyanda",
                "icyapa kigaragaza ahashyirwa imyanda",
                "imyanda",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڪچرو دٻي ۾ اڇلائڻ جي نشاني"),
            keywords: &["ڪچرو دٻي ۾ اڇلائڻ جي نشاني", "ڪچرو، ڪچرو جو ڏٻو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("අපද\u{dca}\u{200d}රව\u{dca}\u{200d}ය බඳ\u{dd4}නට දමන ලක\u{dd4}ණ"),
            keywords: &[
                "අපද\u{dca}\u{200d}රව\u{dca}\u{200d}ය",
                "අපද\u{dca}\u{200d}රව\u{dca}\u{200d}ය බඳ\u{dd4}න",
                "අපද\u{dca}\u{200d}රව\u{dca}\u{200d}ය බඳ\u{dd4}නට දමන ලක\u{dd4}ණ",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("symbol odpadkového koša"),
            keywords: &[
                "odpadkový kôš",
                "odpadky",
                "smeti",
                "symbol",
                "symbol odpadkového koša",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("znak za smeti v košu"),
            keywords: &["koš", "smeti", "znak za smeti v košu"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("calaamadda qashin qubidda"),
            keywords: &["calaamadda qashin qubidda", "qashin", "sanduuqa qashinka"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("shenja e koshit të mbeturinave"),
            keywords: &["kosh", "mbeturinë", "shenja e koshit të mbeturinave"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("бацање отпада у корпу"),
            keywords: &["oтпaд", "бацање отпада у корпу", "корпа зa oтпaткe"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("bacanje otpada u korpu"),
            keywords: &["bacanje otpada u korpu", "korpa za otpatke", "otpad"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("soptunna"),
            keywords: &["slänga skräp", "soptunna", "symbol"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("weka taka kwenye pipa"),
            keywords: &["pipa la taka", "taka", "weka taka kwenye pipa"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("குப\u{bcd}பையை உரிய இடத\u{bcd}தில\u{bcd} போடும\u{bcd} சின\u{bcd}னம\u{bcd}"),
            keywords: &[
                "குப\u{bcd}பையை உரிய இடத\u{bcd}தில\u{bcd} போடவும\u{bcd}",
                "குப\u{bcd}பையை உரிய இடத\u{bcd}தில\u{bcd} போடும\u{bcd} சின\u{bcd}னம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("చ\u{c46}త\u{c4d}త ప\u{c3e}రవ\u{c47}స\u{c47} స\u{c4d}థలం"),
            keywords: &[
                "ఇక\u{c4d}కడ చ\u{c46}త\u{c4d}త వ\u{c47}యండ\u{c3f}",
                "ఎక\u{c4d}కడ పడ\u{c3f}త\u{c47} అక\u{c4d}కడ చ\u{c46}త\u{c4d}త వ\u{c47}యవద\u{c4d}దు",
                "చ\u{c46}త\u{c4d}త ప\u{c3e}రవ\u{c47}స\u{c47} స\u{c4d}థలం",
                "చ\u{c46}త\u{c4d}త బుట\u{c4d}ట",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("аломати \"Партов ба қуттӣ\""),
            keywords: &["аломати \"Партов ба қуттӣ\"", "партов", "қуттии партовҳо"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ท\u{e34}\u{e49}งขยะให\u{e49}ลงถ\u{e31}ง"),
            keywords: &[
                "ท\u{e34}\u{e49}งขยะให\u{e49}ลงถ\u{e31}ง",
                "ป\u{e49}ายถ\u{e31}งขยะ",
            ],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ጎሓፍ ኣብ ምልክት ናይ መጉሓፊ"),
            keywords: &["ኣብ ምልክት ናይ መጉሓፊ", "ጎሓፍ", "ጎሓፍ መጉሓፊ", "ጎሓፍ ኣብ ምልክት ናይ መጉሓፊ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("zibili bedrä taşla belgisi"),
            keywords: &[
                "zibili bedrä taşla belgisi",
                "zir-zibil",
                "zir-zibil gutusy",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("ʻilonga kapa veve"),
            keywords: &["kapa veve", "veve", "ʻilonga", "ʻilonga kapa veve"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("çöp kutusu işareti"),
            keywords: &[
                "işaret",
                "çöp kutusu",
                "çöp kutusu işareti",
                "çöpü yerine atın",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("سېۋەتكە ئەخلەت تاشلاش بەلگىسى"),
            keywords: &["ئەخلەت", "ئەخلەت قاچىسى", "سېۋەتكە ئەخلەت تاشلاش بەلگىسى"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("знак кидати сміття в урну"),
            keywords: &[
                "знак кидати сміття в урну",
                "памʼятка не смітити",
                "сміття",
                "урна",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("کوڑا ٹوکری میں کا سائن"),
            keywords: &["ردی", "ٹوکری", "کوڑا ٹوکری میں کا سائن"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("axlatni o‘z joyiga tashlash"),
            keywords: &["axlat", "axlat qutisi", "axlatni o‘z joyiga tashlash"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("ký hiệu bỏ rác vào thùng"),
            keywords: &["ký hiệu bỏ rác vào thùng", "thùng rác", "xả rác"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("màndarga mbalit ci pot"),
            keywords: &["mbalit", "màndarga mbalit ci pot", "potu mbalit"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("uphawu lwenkunkuma esemgqomeni"),
            keywords: &[
                "inkunkuma",
                "umgqomo wenkunkuma",
                "uphawu lwenkunkuma esemgqomeni",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("idoti ninu aami idọti"),
            keywords: &["dọ\u{300}tí", "idoti ninu aami idọti", "ike ìdalẹ\u{300}sí"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("垃圾桶標誌"),
            keywords: &["垃圾", "垃圾桶", "垃圾桶標誌"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("垃圾桶标志"),
            keywords: &["垃圾", "垃圾桶", "垃圾桶标志"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("倒垃圾"),
            keywords: &["倒垃圾", "垃圾丢弃处", "垃圾入篓"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("垃圾桶"),
            keywords: &["垃圾桶"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("垃圾桶標誌"),
            keywords: &["垃圾桶", "垃圾桶標誌"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("uphawu lomgqomo wezibi"),
            keywords: &["ibhokisi lezibi", "izibi", "uphawu lomgqomo wezibi"],
        },
    ],
};
#[doc = "🚰"]
pub const POTABLE_WATER: crate::Emoji = crate::Emoji {
    glyph: "🚰",
    codepoint: "1F6B0",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "potable water",
    group: "Symbols",
    subgroup: "transport-sign",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("drinkbare water"),
            keywords: &["drink", "drinkbaar", "drinkbare water", "water"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የሚጠጣ ውሃ"),
            keywords: &["ውሃ", "የሚጠጣ", "ጠጣ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("مياه صالحة للشرب"),
            keywords: &["إشارة مياه شرب", "مياه صالحة للشرب"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("খোৱ\u{9be}প\u{9be}নী"),
            keywords: &[
                "খোৱ\u{9be}প\u{9be}নী",
                "প\u{9be}ন কৰ\u{9be}",
                "প\u{9be}নী",
                "পেয\u{9bc}",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("içməli su"),
            keywords: &["içmək", "içməli", "su"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("пітная вада"),
            keywords: &["вада", "пітная", "піццё"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("питейна вода"),
            keywords: &["Питейна вода", "вода", "питейна"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("পেয\u{9bc} জল"),
            keywords: &[
                "জল",
                "প\u{9be}ন কর\u{9be}",
                "প\u{9be}নীয\u{9bc}",
                "পেয\u{9bc} জল",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("dour mat da evañ"),
            keywords: &["dour", "dour mat da evañ", "evañ"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("pitka voda"),
            keywords: &["pitka", "piće", "voda"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("aigua potable"),
            keywords: &["aigua", "potable"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏗᏔᏍᏗ ᎠᎹ"),
            keywords: &["ᎠᎹ", "ᎠᏓᏅᏏᏙ", "ᎠᏗᏔᏍᎩ", "ᎠᏗᏔᏍᏗ ᎠᎹ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("pitná voda"),
            keywords: &["kohoutek", "nápoj", "pitná", "pití", "voda"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("dŵr yfed"),
            keywords: &["diod", "dŵr", "yfed"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("drikkevand"),
            keywords: &["drik", "drikkevand", "vand"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Trinkwasser"),
            keywords: &["Trinkwasser", "Wasser"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("πόσιμο νερό"),
            keywords: &["νερό", "πίνω", "πόσιμο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("potable water"),
            keywords: &["drinking", "potable", "water"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: Some("drinking water"),
            keywords: &["drinking water"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["drinking", "potable", "water"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("agua potable"),
            keywords: &["agua", "potable"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("joogivesi"),
            keywords: &["joodav", "joogivesi", "vesi"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("edateko ura"),
            keywords: &["edan", "edateko", "edateko ura", "ur"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("آب آشامیدنی"),
            keywords: &[
                "آب آشامیدنی",
                "آب شرب",
                "آشامیدنی",
                "قابل شرب",
                "قابل نوشیدن",
                "نوشیدن",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("juomakelpoista vettä"),
            keywords: &["juoma", "juomakelpoista vettä", "juotava", "vesi"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("naiinom na tubig"),
            keywords: &["inumin", "naiinom", "naiinom na tubig", "tubig"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("drekkivatn"),
            keywords: &["drekkandi", "drekkingarvatn", "drekkivatn", "vatn"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("eau potable"),
            keywords: &["eau", "eau potable"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("uisce inólta"),
            keywords: &["comhartha uisce óil", "uisce inólta", "uisce óil"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("uisge so-òlta"),
            keywords: &["so-òlta", "uisge", "òl"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("sinal de auga potable"),
            keywords: &["auga", "beber", "fonte", "potable", "sinal de auga potable"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("પીવાન\u{ac1}\u{a82} પાણી"),
            keywords: &[
                "પાણી",
                "પીવા માટ\u{ac7}ન\u{ac1}\u{a82} પાણી",
                "પીવાન\u{ac1}\u{a82} પાણી",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("ruwan sha"),
            keywords: &["mai sha", "ruwa", "ruwan sha", "sha"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("שלט מי שתייה"),
            keywords: &["ברז", "מים", "שלט מי שתייה", "שתייה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("पीन\u{947} का पानी"),
            keywords: &[
                "पीन\u{947} का पानी",
                "पीन\u{947} क\u{947} पानी का चिह\u{94d}न",
                "प\u{947}यजल",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("pitka voda"),
            keywords: &["pitka", "piće", "voda"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("ivóvíz"),
            keywords: &["fogyasztható víz", "iható", "ivóvíz"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("խմելու ջուր"),
            keywords: &["խմել", "խմելու", "ջուր"],
        },
        #[cfg(feature = "ia")]
        crate::Annotation {
            lang: "ia",
            tts: Some("aqua potabile"),
            keywords: &["aqua", "biber", "bibibile", "potabile"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("air dapat diminum"),
            keywords: &["air", "air dapat diminum", "dapat diminum", "minum"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("mmiri ọṅụṅụ dị mma"),
            keywords: &["dị mma", "mmiri", "mmiri ọṅụṅụ dị mma", "na-aṅụ mmanya"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("drykkjarvatn"),
            keywords: &["drykkjarvatn", "vatn"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("acqua potabile"),
            keywords: &["acqua", "potabile", "simbolo"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("飲料水"),
            keywords: &["水", "水道", "飲み水", "飲料水"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("banyu kran kena diombe"),
            keywords: &["banyu", "banyu kran kena diombe", "ngombe", "ombe langsung"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("სასმელი წყალი"),
            keywords: &["დალევა", "დასალევი", "სასმელი", "სმა", "წყალი"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("aman deg ufus"),
            keywords: &["aman deg ufus"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("ішетін су"),
            keywords: &["су", "ішетін", "ішу"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("drikkevand"),
            keywords: &["drik", "drikkevand", "vand"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ទ\u{17b9}កស\u{17d2}អាត"),
            keywords: &[
                "ទ\u{17b9}ក",
                "ទ\u{17b9}កស\u{17d2}អាត",
                "ផ\u{17b9}ក",
                "ស\u{17d2}អាត",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಪೋರ\u{ccd}ಟಬಲ\u{ccd} ನೀರು"),
            keywords: &[
                "ಕುಡ\u{cbf}ಯುವ ನೀರ\u{cbf}ನ ಚ\u{cbf}ಹ\u{ccd}ನ\u{cc6}",
                "ಪೋರ\u{ccd}ಟಬಲ\u{ccd} ನೀರು",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("음수대"),
            keywords: &["식수대", "음수대"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("पिय\u{947}वपाच\u{947}\u{902} उदक"),
            keywords: &[
                "उदक",
                "पिय\u{947}वपाच\u{947}\u{902}",
                "पिवपाच\u{947}\u{902}",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("иче турган суу"),
            keywords: &["ич", "иче турган суу", "суу"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Drénkwaasser"),
            keywords: &["Drénkwaasser", "Waasser", "drénkbar", "drénken"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ນ\u{ecd}\u{ec9}າທ\u{eb5}\u{ec8}ດ\u{eb7}\u{ec8}ມໄດ\u{ec9}"),
            keywords: &[
                "ກ\u{eb1}ອກ",
                "ດ\u{eb7}\u{ec8}ມໄດ\u{ec9}",
                "ນ\u{ecd}\u{ec9}າ",
                "ນ\u{ecd}\u{ec9}າທ\u{eb5}\u{ec8}ດ\u{eb7}\u{ec8}ມໄດ\u{ec9}",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("geriamasis vanduo"),
            keywords: &["geriamas", "geriamasis vanduo", "gerti", "vanduo"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("dzeramais ūdens"),
            keywords: &["dzeramais ūdens", "dzert", "ūdens"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("wai pai hei unu"),
            keywords: &["inu", "wai", "wai pai", "wai pai hei unu"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("вода за пиење"),
            keywords: &["вода", "вода за пиење", "пиење"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ക\u{d41}ടിവെള\u{d4d}ളം"),
            keywords: &[
                "ക\u{d41}ടിവെള\u{d4d}ളം",
                "പ\u{d3e}നം",
                "വെള\u{d4d}ളം",
                "ശ\u{d41}ദ\u{d4d}ധം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("ундны ус"),
            keywords: &["унд", "ундны ус", "ус"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("पिण\u{94d}\u{200d}यास योग\u{94d}य असल\u{947}ल\u{947} पाणी"),
            keywords: &[
                "पाणी",
                "पिण\u{94d}याच\u{947}",
                "पिण\u{94d}यास योग\u{94d}य",
                "पिण\u{94d}\u{200d}यास योग\u{94d}य असल\u{947}ल\u{947} पाणी",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("air minum"),
            keywords: &["air", "boleh diminum", "minum"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("ilma tax-xorb"),
            keywords: &["ilma", "tax-xorb", "xorb"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("သောက\u{103a}ရေ"),
            keywords: &["ရေ", "သောက\u{103a}", "သောက\u{103a}ရေ"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("drikkevann"),
            keywords: &["drikke", "drikkevann", "vann"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("पिउन योग\u{94d}य पानी"),
            keywords: &[
                "पानी",
                "पिउन योग\u{94d}य पानी",
                "पिउनयोग\u{94d}य",
                "पिउन\u{947}",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("drinkwater"),
            keywords: &["drinkwater", "drinkwatersymbool"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("drikkevatn"),
            keywords: &["drikke", "drikkevatn", "vatn"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ପ\u{b3e}ତ\u{b4d}ରରେ ଭର\u{b3f}ବ\u{b3e} ଯୋଗ\u{b4d}ୟ ଜଳ"),
            keywords: &[
                "ପ\u{b3e}ତ\u{b4d}ରରେ ଭର\u{b3f}ବ\u{b3e} ଯୋଗ\u{b4d}ୟ ଜଳ",
                "ପ\u{b3e}ନୀୟ । ପ\u{b3e}ତ\u{b4d}ରରେ ଭର\u{b3f}ବ\u{b3e}ଯୋଗ\u{b4d}ୟ । ଜଳ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਪੀਣ ਵਾਲਾ ਪਾਣੀ"),
            keywords: &[
                "ਚਿ\u{a70}ਨ\u{a4d}ਹ",
                "ਪੀਣ ਵਾਲਾ ਪਾਣੀ",
                "ਪੀਣ ਵਾਲਾ ਪਾਣੀ ਨਿਸ\u{a3c}ਾਨ",
                "ਪੀਣਾ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("پین دے قابل پانی"),
            keywords: &["پانی", "پین دے قابل", "پین دے قابل پانی", "پینا"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Klín Wọtá"),
            keywords: &["De Drink", "Klín Wọtá", "Wọtá"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("woda pitna"),
            keywords: &["kran", "pitna", "pić", "woda"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د څښاک اوبه"),
            keywords: &["اوبه", "د څښاک اوبه", "څښاک", "څکل"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("água potável"),
            keywords: &["beber", "potável", "água"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["beber", "potável", "água"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("potable yaku unancha"),
            keywords: &["potable", "potable yaku unancha", "upyay", "yaku"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("apă potabilă"),
            keywords: &["apă", "hidratare", "potabilă"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-964"),
            keywords: &["E10-964"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("питьевая вода"),
            keywords: &["вода", "кран", "пить", "питьевая"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("amazi meza"),
            keywords: &[
                "amazi",
                "amazi meza",
                "gishobora kunyobwa nta nkurikizi",
                "kunywa",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("پيئڻ جو پاڻي"),
            keywords: &["پاڻي", "پيئندي", "پيئڻ جو", "پيئڻ جو پاڻي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ප\u{dd2}ර\u{dd2}ස\u{dd2}ද\u{dd4} ප\u{dcf}න\u{dd3}ය ජලය"),
            keywords: &[
                "ජලය",
                "ප\u{dcf}නය කළ හැක\u{dd2}",
                "ප\u{dcf}න\u{dd3}ය",
                "ප\u{dd2}ර\u{dd2}ස\u{dd2}ද\u{dd4} ප\u{dcf}න\u{dd3}ය ජලය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("pitná voda"),
            keywords: &["pitie", "pitná", "voda"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("pitna voda"),
            keywords: &["piti", "pitna voda", "pitno", "voda"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("biyaha la cabi karo"),
            keywords: &["biyaha la cabi karo", "biyo", "cabidda", "la cabi karo"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("ujë i pijshëm"),
            keywords: &["i pijshëm", "pi", "pije", "ujë", "ujë i pijshëm"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("вода за пиће"),
            keywords: &["вoдa", "вода за пиће", "питка"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["вода за пиће"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("voda za piće"),
            keywords: &["pitka", "voda", "voda za piće"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["voda za piće"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("dricksvatten"),
            keywords: &["drickbart vatten", "dricksvatten", "symbol"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("maji safi ya kunywa"),
            keywords: &["kunywa", "maji", "maji safi ya kunywa", "safi kwa kunywa"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("குடிந\u{bc0}ர\u{bcd}"),
            keywords: &[
                "குடி தண\u{bcd}ண\u{bc0}ர\u{bcd} சின\u{bcd}னம\u{bcd}",
                "குடிந\u{bc0}ர\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("త\u{c4d}ర\u{c3e}గున\u{c40}రు"),
            keywords: &[
                "త\u{c4d}ర\u{c3e}గున\u{c40}రు",
                "సురక\u{c4d}ష\u{c3f}త న\u{c40}రు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("оби нӯшокӣ"),
            keywords: &["нӯшидан", "нӯшокӣ", "об", "оби нӯшокӣ"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("น\u{e49}ำด\u{e37}\u{e48}ม"),
            keywords: &["ก\u{e4a}อก", "น\u{e49}ำด\u{e37}\u{e48}ม"],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ጽሩይ ዝስተ ማይ"),
            keywords: &["ማይ", "ዝስተ", "ጽሩይ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("içilýän suw"),
            keywords: &["agyz suwy", "içilýän suw", "içmek", "suw"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("vai inu"),
            keywords: &["inu", "vai"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("içilebilir su"),
            keywords: &["içilebilir su", "içme suyu", "işaret"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئىچىملىك سۇ"),
            keywords: &["ئىچىش", "ئىچىملىك", "سۇ"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("питна вода"),
            keywords: &["вода", "питна", "придатна для пиття"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("پینے کا پانی"),
            keywords: &["پانی", "پینا", "پینے کا پانی"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("ichimlik suvi"),
            keywords: &["ichimlik suvi", "ichish", "ichishga yaroqli", "suv"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("nước uống"),
            keywords: &["nước", "uống", "uống được"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("ndox mu sell"),
            keywords: &["naan", "ndox", "ndox mu sell", "sell"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("amanzi aphathwayo"),
            keywords: &["amanzi", "amanzi aphathwayo", "elahlwayo", "ukusuka"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("omi aṣeegbe kiri"),
            keywords: &["lábó\u{329}dé", "mímu", "omi", "omi aṣeegbe kiri"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("自來水"),
            keywords: &["水", "自來水", "飲水", "飲用"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("自来水"),
            keywords: &["水", "自来水", "饮水", "饮用"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("饮用水"),
            keywords: &["喝水", "接水", "水", "水龙头", "饮用水"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("飲用水"),
            keywords: &["飲用水"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("amanzi asempompini"),
            keywords: &["amanzi", "amanzi asempompini", "ukuphuza", "umpompi"],
        },
    ],
};
#[doc = "♿"]
pub const WHEELCHAIR_SYMBOL: crate::Emoji = crate::Emoji {
    glyph: "♿",
    codepoint: "267F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "wheelchair symbol",
    group: "Symbols",
    subgroup: "transport-sign",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("rolstoel-simbool"),
            keywords: &["rolstoel-simbool", "toegang"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የአካል ጉዳተኛ ዊልቸር"),
            keywords: &["መዳረሻ", "የአካል ጉዳተኛ ዊልቸር"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("كرسي متحرك"),
            keywords: &["إشارة", "دخول", "رمز كرسي متحرك", "كرسي متحرك"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("হ\u{9c1}ইলচেয\u{9bc}\u{9be}ৰ চিহ\u{9cd}ন"),
            keywords: &[
                "প\u{9cd}ৰৱেশ\u{9be}ধিক\u{9be}ৰ",
                "হ\u{9c1}ইলচেয\u{9bc}\u{9be}ৰ চিহ\u{9cd}ন",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("əlil arabası"),
            keywords: &["giriş", "əlil arabası"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("знак «для інвалідаў»"),
            keywords: &["доступ", "знак «для інвалідаў»", "каляска", "інвалід"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("символ за инвалидна количка"),
            keywords: &["достъп", "символ за инвалидна количка"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("হ\u{9c1}ইলচেয\u{9bc}\u{9be}র"),
            keywords: &["প\u{9cd}রবেশ", "হ\u{9c1}ইলচেয\u{9bc}\u{9be}র"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("arouez kador-ruilh"),
            keywords: &["arouez kador-ruilh", "kador-ruilh", "moned"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("invalidska kolica"),
            keywords: &["invalidska kolica", "prilaz"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("símbol de cadira de rodes"),
            keywords: &[
                "accessible",
                "accés",
                "cadira",
                "rodes",
                "símbol de cadira de rodes",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎦᏍᎩᎶ ᎠᏦᏙᏗ ᎦᏯᎸᎢ"),
            keywords: &["ᎠᏴᎯᏍᏗ", "ᎦᏍᎩᎶ ᎠᏦᏙᏗ ᎦᏯᎸᎢ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("symbol invalidního vozíku"),
            keywords: &[
                "bezbariérový",
                "invalidy",
                "přístup",
                "symbol invalidního vozíku",
                "vozík",
                "zpřístupnění",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("cadair olwyn"),
            keywords: &["cadair olwyn", "mynediad"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("symbol for kørestol"),
            keywords: &["adgang", "handicap", "rullestol", "symbol for kørestol"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Symbol „Rollstuhl“"),
            keywords: &["Symbol „Rollstuhl“", "barrierefrei", "behindertengerecht"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("αναπηρικό καροτσάκι"),
            keywords: &["αναπηρικό αμαξίδιο", "αναπηρικό καροτσάκι", "πρόσβαση"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("wheelchair symbol"),
            keywords: &["access", "wheelchair symbol"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["access", "disabled access", "wheelchair symbol"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("símbolo de silla de ruedas"),
            keywords: &[
                "acceso",
                "señal",
                "silla",
                "silla de ruedas",
                "símbolo",
                "símbolo de silla de ruedas",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("acceso para silla de ruedas"),
            keywords: &[
                "acceso",
                "acceso para silla de ruedas",
                "señal",
                "silla de ruedas",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("señal de acceso para silla de ruedas"),
            keywords: &["señal de acceso para silla de ruedas"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("cartel silla de ruedas"),
            keywords: &["acceso", "cartel silla de ruedas"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("ratastool"),
            keywords: &["juurdepääs", "ratastool"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("gurpil-aulkia"),
            keywords: &["erabilerraztasun", "gurpil-aulkia"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("علامت صندلی چرخ\u{200c}دار"),
            keywords: &["دسترسی", "علامت صندلی چرخ\u{200c}دار", "معلول"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("pyörätuoli"),
            keywords: &["esteettömyys", "pyörätuoli"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("wheelchair"),
            keywords: &["kapansanan", "magagamit", "wheelchair"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("koyristólur symbol"),
            keywords: &["atgongd", "hjólstólur", "koyristólur symbol", "rullistólur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("symbole Accès handicapés"),
            keywords: &["accès handicapés", "symbole Accès handicapés"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("symbole de fauteuil roulant"),
            keywords: &["accès handicapés", "symbole de fauteuil roulant"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("bealach isteach do chathaoireacha rothaí"),
            keywords: &[
                "bealach isteach",
                "bealach isteach do chathaoireacha rothaí",
                "cathaoir rothaí",
                "comhartha",
                "siombal cathaoireacha rothaí",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("samhla sèitheir-chuibhle"),
            keywords: &["inntrigeadh", "samhla sèitheir-chuibhle"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("sinal de acceso para cadeira de rodas"),
            keywords: &[
                "acceso",
                "cadeira de rodas",
                "sinal de acceso para cadeira de rodas",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("વ\u{acd}હીલચ\u{ac7}ર"),
            keywords: &[
                "અ\u{200d}\u{ac5}ક\u{acd}સ\u{ac7}સ",
                "ચિહ\u{acd}ન",
                "વ\u{acd}હીલચ\u{ac7}ર",
                "વ\u{acd}હીલચ\u{ac7}રન\u{ac1}\u{a82} પ\u{acd}રતીક",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("alamar kujera mai wili"),
            keywords: &["alamar kujera mai wili", "samun dama"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("שלט לנכים בלבד"),
            keywords: &[
                "גישה",
                "לנכים בלבד",
                "נגיש",
                "נכה",
                "נכים",
                "שלט לנכים בלבד",
            ],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ह\u{94d}वीलच\u{947}यर का प\u{94d}रतीक"),
            keywords: &[
                "ऐक\u{94d}स\u{947}स",
                "ह\u{94d}वीलच\u{947}यर का प\u{94d}रतीक",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("invalidska kolica"),
            keywords: &["invalidska kolica", "pristup"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("kerekesszék"),
            keywords: &["akadálymentesség", "kerekesszék"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("անվասայլակի նշան"),
            keywords: &["անվասայլակ", "անվասայլակի նշան", "մատչելիություն"],
        },
        #[cfg(feature = "ia")]
        crate::Annotation {
            lang: "ia",
            tts: Some("symbolo de sedia rolante"),
            keywords: &[
                "accesso",
                "rolante",
                "rotas",
                "sede",
                "sedia",
                "symbolo de sedia rolante",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("simbol kursi roda"),
            keywords: &["akses", "simbol kursi roda"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("akara ocheigwe"),
            keywords: &["akara ocheigwe", "nnwetaohere"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("hjólastólaaðgengi"),
            keywords: &["aðgengi", "fatlaðir", "hjólastólaaðgengi", "hjólastóll"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("simbolo della disabilità"),
            keywords: &[
                "accesso",
                "accesso sedia a rotelle",
                "sedia a rotelle",
                "simbolo",
                "simbolo della disabilità",
                "simbolo sedia a rotelle",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("車椅子"),
            keywords: &["バリアフリー", "バリヤフリー", "車椅子"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("tandha kursi rodha"),
            keywords: &["dalan", "tandha kursi rodha"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ინვალიდის სავარძელი"),
            keywords: &["ინვალიდის სავარძელი", "მისადგომი"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("azamul n unekcum n uneɛyabu"),
            keywords: &["azamul n unekcum n uneɛyabu"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("мүгедектер арбашасы"),
            keywords: &["кіру", "мүгедектер арбашасы"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("rullestolsadgang"),
            keywords: &["adgang", "rullestol", "rullestolsadgang"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("សញ\u{17d2}ញាជនព\u{17b7}ការ"),
            keywords: &[
                "ជនព\u{17b7}ការ",
                "សញ\u{17d2}ញា",
                "សញ\u{17d2}ញាជនព\u{17b7}ការ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಗಾಲ\u{cbf}ಕುರ\u{ccd}ಚ\u{cbf} ಚ\u{cbf}ಹ\u{ccd}ನ\u{cc6}"),
            keywords: &[
                "ಗಾಲ\u{cbf}ಕುರ\u{ccd}ಚ\u{cbf} ಚ\u{cbf}ಹ\u{ccd}ನ\u{cc6}",
                "ಗಾಲ\u{cbf}ಕುರ\u{ccd}ಚ\u{cbf} ಚ\u{cbf}ಹ\u{ccd}ನ\u{cc6} ಸಂಕೇತ",
                "ಪ\u{ccd}ರವೇಶ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("휠체어"),
            keywords: &["장애인", "휠체어"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("व\u{94d}हीलचक\u{94d}र चिन\u{94d}न"),
            keywords: &[
                "एक\u{94d}स\u{945}स",
                "व\u{94d}हिलच\u{945}र चिन\u{94d}न",
                "व\u{94d}हीलचक\u{94d}र चिन\u{94d}न",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("майыптардын арабасы"),
            keywords: &["майып", "майыптардын арабасы"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Rollstullzeechen"),
            keywords: &["Rollstullzeechen", "Zougank"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ລ\u{ebb}ດນ\u{eb1}\u{ec8}ງຄ\u{ebb}ນພ\u{eb4}ການ"),
            keywords: &[
                "ຄ\u{ebb}ນພ\u{eb4}ການ",
                "ລ\u{ebb}ດນ\u{eb1}\u{ec8}ງ",
                "ລ\u{ebb}ດນ\u{eb1}\u{ec8}ງຄ\u{ebb}ນພ\u{eb4}ການ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("neįgaliojo vežimėlio simbolis"),
            keywords: &["neįgaliojo vežimėlio simbolis", "pasiekiamumas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("ratiņkrēsls"),
            keywords: &["piekļūt", "ratiņkrēsls"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tohu kōrea"),
            keywords: &["tohu kōrea", "urunga"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("инвалидска количка"),
            keywords: &["инвалиди", "инвалидска количка", "пристап"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("വീൽചെയർ ചിഹ\u{d4d}നം"),
            keywords: &["വീൽചെയർ", "വീൽചെയർ ചിഹ\u{d4d}നം", "സിംബൽ"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("тэргэнцэрийн тэмдэг"),
            keywords: &["тэргэнцэрийн тэмдэг", "хүртээмж"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("व\u{94d}हील च\u{947}अर"),
            keywords: &[
                "प\u{94d}रव\u{947}श",
                "व\u{94d}हील च\u{947}अर",
                "व\u{94d}हील च\u{947}अरच\u{947} चिन\u{94d}ह",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("kerusi roda"),
            keywords: &["akses", "kerusi roda"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("simbolu ta’ siġġu tar-roti"),
            keywords: &["aċċess", "simbolu ta’ siġġu tar-roti"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဘ\u{102e}းတပ\u{103a}က\u{102f}လားထ\u{102d}\u{102f}င\u{103a}"),
            keywords: &[
                "ဘ\u{102e}းတပ\u{103a}က\u{102f}လားထ\u{102d}\u{102f}င\u{103a}",
                "သ\u{102f}\u{1036}းန\u{102d}\u{102f}င\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("rullestolsymbol"),
            keywords: &[
                "handikaptilgang",
                "rullestol",
                "rullestolbruker",
                "rullestolsymbol",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("ह\u{94d}विलच\u{947}यरको स\u{902}क\u{947}त"),
            keywords: &[
                "पह\u{941}\u{901}च",
                "ह\u{94d}विलच\u{947}यरको स\u{902}क\u{947}त",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("rolstoelsymbool"),
            keywords: &["rolstoelsymbool", "toegang"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("rullestolsymbol"),
            keywords: &[
                "handikaptilgang",
                "rullestol",
                "rullestolbrukar",
                "rullestolsymbol",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ହ\u{b41}ଇଲଚେୟ\u{b3e}ର\u{b4d}\u{200c} ସଙ\u{b4d}କେତ"),
            keywords: &[
                "ପ\u{b4d}ରବେଶ",
                "ହ\u{b41}ଇଲଚେୟ\u{b3e}ର\u{b4d}\u{200c} ସଙ\u{b4d}କେତ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਪਹੀਆ ਕ\u{a41}ਰਸੀ"),
            keywords: &[
                "ਨਿਸ\u{a3c}ਾਨ",
                "ਪਹੀਆ ਕ\u{a41}ਰਸੀ",
                "ਪਹੀਆ ਕ\u{a41}ਰਸੀ ਪਹ\u{a41}\u{a70}ਚ",
                "ਪਹੀਆ ਕ\u{a41}ਰਸੀ ਪ\u{a4d}ਰਤੀਕ",
                "ਪਹ\u{a41}\u{a70}ਚ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("وئیل چئیر دی علامت"),
            keywords: &["رسائی", "وئیل چئیر دی علامت"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Wílchiá Símbul"),
            keywords: &["Wílchiá Símbul", "Ízí To Yuz"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("symbol wózka inwalidzkiego"),
            keywords: &[
                "inwalida",
                "na wózku",
                "niepełnosprawny",
                "symbol wózka inwalidzkiego",
                "wózek",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د ویلچیر نښه"),
            keywords: &["د ويلچير نښه", "د ویلچیر نښه", "لاسرسی"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("símbolo de cadeira de rodas"),
            keywords: &[
                "acesso",
                "cadeira de rodas",
                "sinal",
                "símbolo de cadeira de rodas",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("símbolo de cadeira de rodas"),
            keywords: &["acessibilidade", "símbolo de cadeira de rodas"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("tiyana ruedaspi unancha"),
            keywords: &["tiyana ruedaspi unancha", "yaykuy"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("simbol pentru scaun cu rotile"),
            keywords: &[
                "accesibilitate",
                "simbol pentru cărucior cu rotile",
                "simbol pentru scaun cu rotile",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-082"),
            keywords: &["E10-082"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("значок «для инвалидов»"),
            keywords: &[
                "возможности",
                "доступ",
                "значок",
                "значок \"для инвалидов\"",
                "значок «для инвалидов»",
                "инвалидная коляска",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ikimenyetso cy’akagare k’abafite ubumuga"),
            keywords: &["ikimenyetso cy’akagare k’abafite ubumuga", "kwinjira"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڦيٿي واري ڪرسي جي نشاني"),
            keywords: &["رسائي", "ڦيٿي واري ڪرسي جي نشاني"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("රෝද ප\u{dd4}ට\u{dd4}ව"),
            keywords: &["ප\u{dca}\u{200d}රවේශය", "රෝද ප\u{dd4}ට\u{dd4}ව"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("invalidný vozík"),
            keywords: &["invalidný vozík", "prístup"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("invalidski voziček"),
            keywords: &["dostop", "invalidski voziček"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("calaamadda kursiga curyaanka"),
            keywords: &["calaamadda kursiga curyaanka", "helitaanka"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("karrocë me rrota"),
            keywords: &["karrocë me rrota", "qasje"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("инвалидска колица"),
            keywords: &[
                "инвалидска колица",
                "приступ",
                "симбол за инвалидска колица",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["инвалидска колица"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("invalidska kolica"),
            keywords: &[
                "invalidska kolica",
                "pristup",
                "simbol za invalidska kolica",
            ],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["invalidska kolica"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("rullstolssymbol"),
            keywords: &["rullstol", "rullstolssymbol", "symbol", "tillgänglighet"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kiti cha magurudumu"),
            keywords: &["kiti cha magurudumu", "ufikiaji"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("சக\u{bcd}கர ந\u{bbe}ற\u{bcd}க\u{bbe}லி"),
            keywords: &[
                "சக\u{bcd}கர ந\u{bbe}ற\u{bcd}க\u{bbe}லி",
                "சக\u{bcd}கர ந\u{bbe}ற\u{bcd}க\u{bbe}லி சின\u{bcd}னம\u{bcd}",
                "ம\u{bbe}ற\u{bcd}றுத\u{bcd}திறன\u{bbe}ளி",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("చక\u{c4d}ర\u{c3e}ల కుర\u{c4d}చ\u{c40}"),
            keywords: &[
                "చక\u{c4d}ర\u{c3e}ల కుర\u{c4d}చ\u{c40}",
                "వ\u{c3f}కల\u{c3e}ంగులు",
                "వ\u{c40}ల\u{c4d} చ\u{c46}య\u{c3f}ర\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("аломати \"Курсии чархдор\""),
            keywords: &["аломати \"Курсии чархдор\"", "дастрасӣ"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("รถเข\u{e47}นผ\u{e39}\u{e49}ป\u{e48}วย"),
            keywords: &["คนพ\u{e34}การ", "รถเข\u{e47}นผ\u{e39}\u{e49}ป\u{e48}วย"],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ምልክት ናይ መበጻጽሒ ሰድያ"),
            keywords: &["ምልክት", "ምልክት ናይ መበጻጽሒ ሰድያ", "ናይ መበጻጽሒ ሰድያ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("maýyp arabajygy simwoly"),
            keywords: &["maýyp arabajygy simwoly", "ýetmek"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("sea poliō"),
            keywords: &["sea poliō"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("tekerlekli sandalye sembolü"),
            keywords: &[
                "erişim",
                "işaret",
                "tekerlekli sandalye",
                "tekerlekli sandalye erişimi",
                "tekerlekli sandalye sembolü",
                "tekerlekli sandalye simgesi",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("مېيىپلار ھارۋىسىنىڭ بەلگىسى"),
            keywords: &["كىرىش", "مېيىپلار ھارۋىسىنىڭ بەلگىسى"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("символ крісла-візка"),
            keywords: &["доступність", "символ візка", "символ крісла-візка"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("وہیل چیئر"),
            keywords: &["رسائی", "وہیل چیئر", "پہیے", "کرسی"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("nogironlar aravachasi"),
            keywords: &["maxsus imkoniyat", "nogironlar aravachasi"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("biểu tượng xe lăn"),
            keywords: &["biểu tượng xe lăn", "lối vào"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("màndarga puus-puus"),
            keywords: &["jot", "màndarga puus-puus"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("isimboli yesitulo samavili"),
            keywords: &["isimboli yesitulo samavili", "ufikelelo"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("àmì kẹkẹ ẹni-ẹsẹ-ndun"),
            keywords: &["àmì kẹkẹ ẹni-ẹsẹ-ndun", "ìfàyègbà"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("輪椅標誌"),
            keywords: &["無障礙", "輪椅標誌"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("轮椅标志"),
            keywords: &["无障碍", "轮椅标志"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("轮椅标识"),
            keywords: &["无障碍", "残疾", "残障", "轮椅", "轮椅标识", "轮椅符号"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("無障礙空間"),
            keywords: &["無障礙空間", "行動不便者", "身障人士"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("輪椅符號"),
            keywords: &["傷殘人士", "殘障人士", "無障礙空間", "輪椅符號"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("isihlalo esinamasondo sabantu abaphila nokukhubazeka"),
            keywords: &[
                "isihlalo esinamasondo sabantu abaphila nokukhubazeka",
                "ukungena",
            ],
        },
    ],
};
#[doc = "🚹"]
pub const MENS_ROOM: crate::Emoji = crate::Emoji {
    glyph: "🚹",
    codepoint: "1F6B9",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "men’s room",
    group: "Symbols",
    subgroup: "transport-sign",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("manskleedkamer"),
            keywords: &["kleedkamer", "man", "manskleedkamer", "toilet"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የወንድ መጸዳጃ"),
            keywords: &["መጸዳጃ", "ሽንት ቤት", "ወንድ", "የወንድ መጸዳጃ", "ደብልዩ ሲ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("للرجال"),
            keywords: &["إشارة", "علامة رجال", "غرفة رجال", "للرجال"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("প\u{9c1}ৰ\u{9c1}ষৰ শৌচ-প\u{9cd}ৰস\u{9cd}ৰ\u{9be}ৱ কৰ\u{9be} কোঠ\u{9be}"),
            keywords: &[
                "ডব\u{9cd}লিউচি",
                "প\u{9c1}ৰ\u{9c1}ষ",
                "প\u{9c1}ৰ\u{9c1}ষৰ শৌচ-প\u{9cd}ৰস\u{9cd}ৰ\u{9be}ৱ কৰ\u{9be} কোঠ\u{9be}",
                "শৌচ\u{9be}গ\u{9be}ৰ",
                "ৰেষ\u{9cd}টৰ\u{9c1}ম",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("kişi tualeti"),
            keywords: &["ayaqyolu", "kişi", "kişi tualeti", "tualet", "wc"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("мужчынскі туалет"),
            keywords: &["мужчына", "мужчынскі туалет", "прыбіральня", "туалет"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("мъжка тоалетна"),
            keywords: &["WC", "мъже", "мъжка тоалетна", "тоалетна"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("প\u{9c1}র\u{9c1}ষদের কক\u{9cd}ষ"),
            keywords: &[
                "প\u{9c1}র\u{9c1}ষ",
                "প\u{9c1}র\u{9c1}ষদের কক\u{9cd}ষ",
                "রেস\u{9cd}টর\u{9c1}ম",
                "শৌচ\u{9be}গ\u{9be}র",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("privezioù paotred"),
            keywords: &["WC", "golcʼhiri", "paotred", "privezioù"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("muški zahod"),
            keywords: &["muški", "toalet", "wc", "zahod"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("lavabo d’homes"),
            keywords: &["homes", "lavabo", "lavabo d’homes", "servei"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏂᏍᎦᏯ ᎤᏂᏴᏍᏗ"),
            keywords: &["wc", "ᎠᏂᏍᎦᏯ ᎤᏂᏴᏍᏗ", "ᎠᏍᎦᏯ", "ᎤᎾᏓᏅᎦᏟᏗ ᎧᏅᏑᎸ", "ᏙᏱ ᎤᎾᏨᏍᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("pánské toalety"),
            keywords: &["muž", "pánské toalety", "toaleta", "wc", "záchod"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("ystafell ymolchi i ddynion"),
            keywords: &["dyn", "toiled", "tŷ bach", "ystafell ymolchi i ddynion"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("herretoilet"),
            keywords: &["herrer", "herretoilet", "toilet", "wc"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Herren"),
            keywords: &["Herren", "Herrentoilette"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("τουαλέτα ανδρών"),
            keywords: &[
                "WC",
                "άνδρας",
                "τουαλέτα",
                "τουαλέτα ανδρών",
                "τουαλέτα αντρών",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("men’s room"),
            keywords: &["lavatory", "man", "men’s room", "restroom", "wc"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: Some("men’s toilet"),
            keywords: &["lavatory", "man", "men’s toilet", "restroom", "wc"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("men’s room"),
            keywords: &[
                "bathroom",
                "lavatory",
                "man",
                "men’s",
                "men’s room",
                "restroom",
                "washroom",
                "wc",
            ],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("aseo para hombres"),
            keywords: &[
                "aseo de caballeros",
                "aseo para hombres",
                "baño",
                "servicio",
                "señal",
                "señal con un hombre",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("símbolo de hombre"),
            keywords: &[
                "aseo de caballeros",
                "aseo para hombres",
                "baño",
                "servicio",
                "señal",
                "señal con un hombre",
                "símbolo de hombre",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("señal del baño de los hombres"),
            keywords: &["señal del baño de los hombres"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("baño de hombres"),
            keywords: &["baño", "baño de hombres", "hombre", "sanitarios", "wc"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("meeste-WC"),
            keywords: &["mees", "meeste-WC", "tualett", "wc"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("gizonen komuna"),
            keywords: &["gizon", "gizonen komuna", "komun", "wc"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("توالت مردانه"),
            keywords: &["توالت", "توالت مردانه", "سرویس بهداشتی", "مردان"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("miesten wc"),
            keywords: &["miesten wc", "miestenhuone", "vessa", "wc"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("banyong panlalaki"),
            keywords: &["banyo", "banyong panlalaki", "cr", "lalaki", "panlalaki"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("mannfólkaves"),
            keywords: &["mannfólkaves", "maður", "ves", "wc"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("symbole Toilettes hommes"),
            keywords: &["WC", "homme", "symbole Toilettes hommes", "toilettes"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("toilettes pour hommes"),
            keywords: &["sanitaires", "toilettes", "toilettes pour hommes"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("Fir"),
            keywords: &["Comhartha Fear", "Fir", "Seomra na bhFear", "comhartha"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("taigh-beag nam fireannach"),
            keywords: &[
                "duine",
                "fear",
                "fireannach",
                "taigh-beag",
                "taigh-beag nam fireannach",
                "wc",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("sinal de aseo de homes"),
            keywords: &["aseo", "baño", "homes", "sinal de aseo de homes"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("પ\u{ac1}ર\u{ac1}ષોનો ર\u{ac2}મ"),
            keywords: &[
                "પ\u{ac1}ર\u{ac1}ષ",
                "પ\u{ac1}ર\u{ac1}ષોનો ર\u{ac2}મ",
                "ર\u{ac7}સ\u{acd}ટર\u{ac2}મ",
                "શૌચાલય",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("ɗakin maza"),
            keywords: &["bayan gida", "makewayi", "mutum", "wc", "ɗakin maza"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("שלט שירותי גברים"),
            keywords: &["גברים", "ציבוריים", "שירותים", "שלט שירותי גברים"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("प\u{941}र\u{941}ष कक\u{94d}ष"),
            keywords: &[
                "चिह\u{94d}न",
                "प\u{941}र\u{941}ष कक\u{94d}ष",
                "प\u{941}र\u{941}ष का चिह\u{94d}न",
                "प\u{941}र\u{941}ष का प\u{94d}रतीक",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("muški toalet"),
            keywords: &["muški", "toalet", "zahod"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("férfimosdó"),
            keywords: &["WC", "férfiak", "férfimosdó", "mosdó", "vécé"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("տղամարդկանց զուգարան"),
            keywords: &["wc", "զուգարան", "տղամարդ", "տղամարդկանց զուգարան"],
        },
        #[cfg(feature = "ia")]
        crate::Annotation {
            lang: "ia",
            tts: Some("lavatorio pro homines"),
            keywords: &[
                "cabinetto",
                "homine",
                "lavatorio",
                "lavatorio pro homines",
                "toilette",
                "wc",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("toilet pria"),
            keywords: &["kamar kecil", "pria", "toilet", "wc"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ọnụ ụlọ ụmụnwoke"),
            keywords: &[
                "nwoke",
                "wc",
                "ọnụ ụlọ ụmụnwoke",
                "ụlọ maamịrị",
                "ụlọ mpochi",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("karlaklósett"),
            keywords: &["karl", "karlaklósett", "klósett", "salerni", "snyrting"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("simbolo del bagno degli uomini"),
            keywords: &[
                "Uomini",
                "bagno uomini",
                "simbolo",
                "simbolo bagno uomini",
                "simbolo del bagno degli uomini",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("男子トイレ"),
            keywords: &["WC", "お手洗い", "トイレ", "化粧室", "男子トイレ", "男性"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("pakiwan lanang"),
            keywords: &["jumbleng", "lanang", "pakiwan", "wese"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("კაცების საპირფარეშო"),
            keywords: &[
                "კაცების საპირფარეშო",
                "კაცი",
                "საპირფარეშო",
                "საჭირო ოთახი",
                "ტუალეტი",
            ],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("azamul n urgaz"),
            keywords: &["azamul n urgaz"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("ерлер бөлмесі"),
            keywords: &["дәретхана", "ер", "ерлер бөлмесі", "әжетхана", "әйел"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("mænd"),
            keywords: &["mænd", "wc"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("សញ\u{17d2}ញាបន\u{17d2}ទប\u{17cb}ប\u{17bb}រស"),
            keywords: &[
                "បន\u{17d2}ទប\u{17cb}ទ\u{17b9}ក",
                "បន\u{17d2}ទប\u{17cb}ប\u{17bb}រស",
                "សញ\u{17d2}ញា",
                "សញ\u{17d2}ញាបន\u{17d2}ទប\u{17cb}ទ\u{17b9}កប\u{17bb}រស",
                "សញ\u{17d2}ញាបន\u{17d2}ទប\u{17cb}ប\u{17bb}រស",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಪುರುಷರ ಕೊಠಡ\u{cbf}"),
            keywords: &[
                "ಡಬ\u{ccd}ಯ\u{cc2}ಸ\u{cbf}",
                "ಪುರುಷ",
                "ಪುರುಷರ ಕೊಠಡ\u{cbf}",
                "ಪುರುಷರ ಕೋಣ\u{cc6}",
                "ರ\u{cc6}ಸ\u{ccd}ಟ\u{ccd} ರ\u{cc2}ಂ",
                "ಶ\u{ccc}ಚಾಲಯ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("남자 화장실"),
            keywords: &["남성", "남성용", "남자 화장실", "남자용"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("दादल\u{94d}याची म\u{941}तरी"),
            keywords: &[
                "टॉयल\u{947}ट",
                "दादलो",
                "दादल\u{94d}याची म\u{941}तरी",
                "र\u{947}स\u{94d}टर\u{942}म",
                "वॉशर\u{942}म",
                "स\u{902}डास",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("эркектердин дааратканасы"),
            keywords: &["даараткана", "эркек", "эркектердин дааратканасы"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Männertoilett"),
            keywords: &["Mann", "Männer", "Männertoilett", "Toilett", "WC"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຫ\u{ec9}ອງຜ\u{eb9}\u{ec9}ຊາຍ"),
            keywords: &[
                "ຜ\u{eb9}\u{ec9}ຊາຍ",
                "ຫ\u{ec9}ອງ",
                "ຫ\u{ec9}ອງຜ\u{eb9}\u{ec9}ຊາຍ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("vyrų tualetas"),
            keywords: &["tualetas", "vyras", "vyrų tualetas", "wc"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("vīriešu tualete"),
            keywords: &["WC", "tualete", "vīriešu"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("taiwhanga tāne"),
            keywords: &[
                "heketua",
                "rūma whakatā",
                "taiwhanga tāne",
                "tāne",
                "wharepaku",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("машки тоалет"),
            keywords: &["мажи", "машки тоалет", "тоалет"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("പ\u{d41}ര\u{d41}ഷൻമ\u{d3e}ർക\u{d4d}ക\u{d41}ള\u{d4d}ള മ\u{d41}റി"),
            keywords: &[
                "പ\u{d41}ര\u{d41}ഷന\u{d4d}മ\u{d3e}ർ ചിഹ\u{d4d}നം",
                "പ\u{d41}ര\u{d41}ഷൻമ\u{d3e}ർക\u{d4d}ക\u{d41}ള\u{d4d}ള മ\u{d41}റി",
                "സിംബൽ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("эрэгтэйчүүдийн өрөө"),
            keywords: &[
                "00",
                "ариун цэврийн өрөө",
                "жорлон",
                "эрэгтэй",
                "эрэгтэйчүүдийн өрөө",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("प\u{941}र\u{942}षाची खोली"),
            keywords: &[
                "डब\u{94d}ल\u{94d}य\u{942}सी",
                "प\u{941}र\u{941}ष",
                "प\u{941}र\u{942}षा\u{902}ची खोली",
                "प\u{941}र\u{942}षाची खोली",
                "प\u{94d}रसाधनग\u{943}ह",
                "विश\u{94d}रामग\u{943}ह",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("tandas lelaki"),
            keywords: &["bilik air", "lelaki", "tandas", "wc"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("kamra tal-irġiel"),
            keywords: &["kamra tal-irġiel", "latrina", "raġel", "toilet", "wc"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အမျ\u{102d}\u{102f}းသား သန\u{1037}\u{103a}စင\u{103a}ခန\u{103a}း"),
            keywords: &[
                "ရေအ\u{102d}မ\u{103a}",
                "အမျ\u{102d}\u{102f}းသား သန\u{1037}\u{103a}စင\u{103a}ခန\u{103a}း",
                "အမျ\u{102d}\u{102f}းသား အ\u{102d}မ\u{103a}သာ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("herretoalett"),
            keywords: &[
                "do",
                "herrer",
                "herretoalett",
                "mannesymbol",
                "toalett",
                "wc",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("प\u{941}र\u{941}षको कोठा"),
            keywords: &[
                "पानी पाइन\u{947} ठाउ\u{901}",
                "प\u{941}र\u{941}षको कोठा",
                "प\u{941}र\u{942}ष",
                "प\u{941}र\u{942}षको कोठा",
                "शौ\u{902}चालय",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("herentoilet"),
            keywords: &["herentoilet", "man", "toilet", "wc"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("herretoalett"),
            keywords: &[
                "do",
                "herrar",
                "herretoalett",
                "mannesymbol",
                "toalett",
                "wc",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ପ\u{b41}ର\u{b41}ଷଙ\u{b4d}କ କକ\u{b4d}ଷ"),
            keywords: &[
                "wc",
                "ଆର\u{b3e}ମକକ\u{b4d}ଷ",
                "ପ\u{b3e}ଇଖ\u{b3e}ନ\u{b3e}",
                "ପ\u{b41}ର\u{b41}ଷ",
                "ପ\u{b41}ର\u{b41}ଷଙ\u{b4d}କ କକ\u{b4d}ଷ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਬ\u{a70}ਦਿਆ\u{a02} ਦਾ ਕਮਰਾ"),
            keywords: &[
                "ਚਿ\u{a70}ਨ\u{a4d}ਹ",
                "ਨਿਸ\u{a3c}ਾਨ",
                "ਬ\u{a70}ਦਿਆ\u{a02} ਦਾ ਕਮਰਾ",
                "ਬ\u{a70}ਦਿਆ\u{a02} ਦਾ ਪ\u{a4d}ਰਤੀਕ",
                "ਬ\u{a70}ਦ\u{a47}",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("بندیاں دا کمرہ"),
            keywords: &["wc", "بندہ", "بندیاں دا کمرہ", "غسل خانہ", "لیٹرین"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Man-dẹm Tọílẹ\u{301}t Rum"),
            keywords: &[
                "Lávétri",
                "Man",
                "Man-dẹm Tọílẹ\u{301}t Rum",
                "Rẹ\u{301}strum",
                "WC",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("toaleta męska"),
            keywords: &[
                "męski",
                "szalet",
                "toaleta",
                "toaleta męska",
                "ubikacja",
                "ustęp",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د نارینه خونه"),
            keywords: &[
                "تشناب",
                "د آرام خونه",
                "د نارينه خونه",
                "د نارینه خونه",
                "سړی",
                "ډبليو سي",
            ],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("banheiro masculino"),
            keywords: &[
                "banheiro",
                "homem",
                "lavatório",
                "masculino",
                "toalete",
                "wc",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("casa de banho para homens"),
            keywords: &[
                "casa de banho para homens",
                "homem",
                "quarto de banho",
                "wc",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("runapaq unancha"),
            keywords: &["baño nisqa", "runakuna", "runapaq unancha", "wc"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("toaletă bărbați"),
            keywords: &["bărbați", "closet", "toaletă", "wc"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-973"),
            keywords: &["E10-973"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("мужской туалет"),
            keywords: &["кабинки", "мужской туалет", "мужчины", "туалет", "уборная"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ubwiherero bw’abagabo"),
            keywords: &["ubwiherero", "ubwiherero bw’abagabo", "umuntu", "wc"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("مردن جو ڪمرو"),
            keywords: &["آرام جو ڪمرو", "غسل خانو", "مرد", "مردن جو ڪمرو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ප\u{dd2}ර\u{dd2}ම\u{dd2}ය\u{dcf}ගේ ක\u{dcf}මරය"),
            keywords: &[
                "wc",
                "ප\u{dd2}ර\u{dd2}ම\u{dd2}",
                "ප\u{dd2}ර\u{dd2}ම\u{dd2}ය\u{dcf}ගේ ක\u{dcf}මරය",
                "වැස\u{dd2}ක\u{dd2}ළ\u{dd2}ය",
                "ව\u{dd2}වේක ක\u{dcf}මරය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("pánske toalety"),
            keywords: &["muž", "pánske toalety", "toaleta", "wc", "záchod"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("stranišče za moške"),
            keywords: &["moški", "stranišče", "stranišče za moške", "wc"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("qolka ragga"),
            keywords: &["nin", "qol musquleed", "qolka ragga", "suuligga", "wc"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("banja e meshkujve"),
            keywords: &["banja e meshkujve", "banjë", "burrë", "tualet", "wc"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("мушки тоалет"),
            keywords: &["ве-це", "мушки", "мушки тоалет", "тoaлeт"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("muški toalet"),
            keywords: &["muški", "toalet", "ve-ce"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("herrtoalett"),
            keywords: &["herrtoalett", "män", "symbol för män", "toalett"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("maliwato ya wanaume"),
            keywords: &["maliwato", "maliwato ya wanaume", "mwanamume"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ஆண\u{bcd}கள\u{bcd} பகுதி"),
            keywords: &["ஆண\u{bcd}கள\u{bcd}", "ஆண\u{bcd}கள\u{bcd} பகுதி"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("పురుషుల వ\u{c3f}శ\u{c4d}ర\u{c3e}ంత\u{c3f} గద\u{c3f}"),
            keywords: &[
                "పురుషుల వ\u{c3f}శ\u{c4d}ర\u{c3e}ంత\u{c3f} గద\u{c3f}",
                "పురుషులు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("ҳоҷатхона барои мардон"),
            keywords: &["мард", "ҳоҷатхона", "ҳоҷатхона барои мардон"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ห\u{e49}องน\u{e49}ำชาย"),
            keywords: &[
                "ผ\u{e39}\u{e49}ชาย",
                "ส\u{e38}ขภ\u{e31}ณฑ\u{e4c}",
                "ส\u{e38}ขา",
                "ห\u{e49}องชาย",
                "ห\u{e49}องน\u{e49}ำ",
                "ห\u{e49}องน\u{e49}ำชาย",
            ],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ክፍሊ ሰብኡት"),
            keywords: &[
                "wc",
                "ሰብኣይ",
                "ሽቃቅ",
                "ናይ ክዳውንቲ መሕጸቢ ኣቕሓ",
                "ክፍሊ ሰብኡት",
                "ክፍሊ ናይ ሰብኣይ",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("erkekler otagy"),
            keywords: &[
                "dynç otagy",
                "erkek",
                "erkekler otagy",
                "hajathana",
                "tualet",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("fale mālōlō tangata"),
            keywords: &["fale mālōlō", "fale mālōlō tangata", "tangata"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("erkekler tuvaleti"),
            keywords: &["erkekler tuvaleti", "işaret", "tuvalet"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئەرلەر ھاجەتخانىسى"),
            keywords: &[
                "ئەر",
                "ئەرلەر ھاجەتخانىسى",
                "تازىلىق ئۆيى",
                "سۇخانا",
                "ھاجەتخانا",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("чоловіча вбиральня"),
            keywords: &[
                "вбиральня",
                "для чоловіків",
                "клозет",
                "туалетна кімната",
                "чоловіча вбиральня",
                "чоловічий туалет",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("مردوں کا ٹوائلٹ"),
            keywords: &["مرد", "مردوں کا ٹوائلٹ", "ٹوائلٹ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("erkaklar xonasi"),
            keywords: &["erkak", "erkaklar xonasi", "hojatxona"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("nhà vệ sinh nam"),
            keywords: &[
                "nam",
                "nhà vệ sinh",
                "nhà vệ sinh nam",
                "phòng vệ sinh",
                "wc",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("néegu góor ñi"),
            keywords: &["duus", "góor", "noppalukaay", "néegu góor ñi", "wc"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("igumbi lamadoda"),
            keywords: &[
                "i-wc",
                "igumbi lamadoda",
                "igumbi lokuphumla",
                "indoda",
                "ithoyilethi",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("iyara awọn ọkunrin"),
            keywords: &[
                "ilé ìgbò\u{329}nṣẹ\u{300} olómi",
                "ilé ìgbọ\u{300}nṣẹ\u{300}",
                "iyara awọn ọkunrin",
                "ìyàrá ìsinmi",
                "ọkùnrin",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("男廁"),
            keywords: &["廁所", "洗手間", "男", "男廁", "衛生間"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("男厕"),
            keywords: &["卫生间", "厕所", "洗手间", "男", "男厕"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("男厕"),
            keywords: &["卫生间", "厕所", "洗手间", "男厕", "男士"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("男廁"),
            keywords: &["男廁"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("indlu yangasese yamadoda"),
            keywords: &["indlu yangasese", "indlu yangasese yamadoda", "indoda"],
        },
    ],
};
#[doc = "🚺"]
pub const WOMENS_ROOM: crate::Emoji = crate::Emoji {
    glyph: "🚺",
    codepoint: "1F6BA",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "women’s room",
    group: "Symbols",
    subgroup: "transport-sign",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("vrouekleedkamer"),
            keywords: &["kleedkamer", "toilet", "vrou", "vrouekleedkamer"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የሴት መጸዳጃ"),
            keywords: &["መጸዳጃ", "ሴት", "ሽንት ቤት", "የሴት መጸዳጃ", "ደብልዩ ሲ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("للسيدات"),
            keywords: &["إشارة", "علامة سيدات", "غرفة سيدات", "للسيدات"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("মহিল\u{9be}ৰ শৌচ-প\u{9cd}ৰস\u{9cd}ৰ\u{9be}ৱ কৰ\u{9be} কোঠ\u{9be}"),
            keywords: &[
                "ডব\u{9cd}লিউচি",
                "মহিল\u{9be}",
                "মহিল\u{9be}ৰ শৌচ-প\u{9cd}ৰস\u{9cd}ৰ\u{9be}ৱ কৰ\u{9be} কোঠ\u{9be}",
                "শৌচ\u{9be}গ\u{9be}ৰ",
                "ৰেষ\u{9cd}টৰ\u{9c1}ম",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("qadın tualeti"),
            keywords: &["ayaqyolu", "qadın", "qadın tualeti", "tualet", "wc"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("жаночы туалет"),
            keywords: &["жаночы туалет", "жанчына", "прыбіральня", "туалет"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("женска тоалетна"),
            keywords: &["WC", "жени", "женска тоалетна", "тоалетна"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("মহিল\u{9be}দের কক\u{9cd}ষ"),
            keywords: &[
                "ন\u{9be}রী",
                "মহিল\u{9be}দের কক\u{9cd}ষ",
                "রেস\u{9cd}টর\u{9c1}ম",
                "শৌচ\u{9be}গ\u{9be}র",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("privezioù mercʼhed"),
            keywords: &["WC", "golcʼhiri", "mercʼhed", "privezioù"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("ženski zahod"),
            keywords: &["toalet", "wc", "zahod", "ženski"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("lavabo de dones"),
            keywords: &["dones", "lavabo", "lavabo de dones", "servei"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᎨᏯ ᎤᏴᏍᏗᎢ"),
            keywords: &["wc", "ᎠᎨᏯ", "ᎠᎨᏯ ᎤᏴᏍᏗᎢ", "ᎤᎾᏓᏅᎦᏟᏗ ᎧᏅᏑᎸ", "ᏙᏱ ᎤᎾᏨᏍᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("dámské toalety"),
            keywords: &["dámské toalety", "toaleta", "wc", "záchod", "žena"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("ystafell ymolchi i fenywod"),
            keywords: &["menyw", "toiled", "tŷbach", "ystafell ymolchi i fenywod"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("dametoilet"),
            keywords: &["damer", "dametoilet", "toilet", "wc"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Damen"),
            keywords: &["Damen", "Damentoilette"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("τουαλέτα γυναικών"),
            keywords: &["WC", "γυναίκα", "τουαλέτα", "τουαλέτα γυναικών"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("women’s room"),
            keywords: &["lavatory", "restroom", "wc", "woman", "women’s room"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: Some("women’s toilet"),
            keywords: &["lavatory", "restroom", "wc", "woman", "women’s toilet"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &[
                "ladies room",
                "lavatory",
                "restroom",
                "wc",
                "woman",
                "women’s toilet",
            ],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("women’s room"),
            keywords: &[
                "bathroom",
                "lavatory",
                "restroom",
                "washroom",
                "wc",
                "woman",
                "women’s",
                "women’s room",
            ],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("señal de aseo para mujeres"),
            keywords: &[
                "aseo de señoras",
                "baño",
                "servicio",
                "señal",
                "señal con una mujer",
                "señal de aseo para mujeres",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("símbolo de mujer"),
            keywords: &[
                "aseo de señoras",
                "baño",
                "servicio",
                "señal",
                "señal con una mujer",
                "señal de aseo para mujeres",
                "símbolo de mujer",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("señal del baño de las mujeres"),
            keywords: &["señal del baño de las mujeres"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("baño de mujeres"),
            keywords: &["baño", "baño de mujeres", "mujer", "sanitarios", "wc"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("naiste-WC"),
            keywords: &["naine", "naiste-WC", "tualett", "wc"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("emakumeen komuna"),
            keywords: &["emakume", "emakumeen komuna", "komun", "wc"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("توالت زنانه"),
            keywords: &["توالت", "توالت زنانه", "زنان", "سرویس بهداشتی"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("naisten wc"),
            keywords: &["naisten wc", "naistenhuone", "vessa", "wc"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("banyong pambabae"),
            keywords: &["babae", "banyo", "banyong pambabae", "cr", "pambabae"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("konufólkaves"),
            keywords: &["kona", "konufólkaves", "kvinna", "ves", "wc"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("symbole Toilettes femmes"),
            keywords: &["WC", "femme", "symbole Toilettes femmes", "toilettes"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("toilettes pour femmes"),
            keywords: &["sanitaires", "toilettes", "toilettes pour femmes"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("Mná"),
            keywords: &["Comhartha na mBan", "Mná", "Seomra na mBan", "comhartha"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("taigh-beag nam boireannach"),
            keywords: &[
                "boireannach",
                "taigh-beag",
                "taigh-beag nam boireannach",
                "tè",
                "wc",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("sinal de aseo de mulleres"),
            keywords: &["aseo", "baño", "mulleres", "sinal de aseo de mulleres"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("મહિલાઓનો ર\u{ac2}મ"),
            keywords: &[
                "મહિલા",
                "મહિલાઓનો ર\u{ac2}મ",
                "ર\u{ac7}સ\u{acd}ટર\u{ac2}મ",
                "શૌચાલય",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("ɗakin mata"),
            keywords: &["bayan gida", "mace", "makewayi", "wc", "ɗakin mata"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("שלט שירותי נשים"),
            keywords: &["נשים", "ציבוריים", "שירותים", "שלט שירותי נשים"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("महिला कक\u{94d}ष"),
            keywords: &[
                "चिह\u{94d}न",
                "महिला कक\u{94d}ष",
                "महिला का चिह\u{94d}न",
                "महिला का प\u{94d}रतीक",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("ženski toalet"),
            keywords: &["toalet", "zahod", "ženski"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("női mosdó"),
            keywords: &["WC", "mosdó", "női mosdó", "nők", "vécé"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("կանանց զուգարան"),
            keywords: &["wc", "զուգարան", "կանանց զուգարան", "կին"],
        },
        #[cfg(feature = "ia")]
        crate::Annotation {
            lang: "ia",
            tts: Some("lavatorio pro feminas"),
            keywords: &[
                "cabinetto",
                "femina",
                "lavatorio",
                "lavatorio pro feminas",
                "toilette",
                "wc",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("toilet wanita"),
            keywords: &["kamar kecil", "toilet", "wanita", "wc"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ọnụ ụlọ ụmụnwaanyị"),
            keywords: &[
                "nwanyị",
                "wc",
                "ọnụ ụlọ ụmụnwaanyị",
                "ụlọ maamịrị",
                "ụlọ mpochi",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("kvennaklósett"),
            keywords: &["klósett", "kona", "kvennaklósett", "salerni", "snyrting"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("simbolo del bagno delle donne"),
            keywords: &[
                "Donne",
                "bagno donne",
                "simbolo",
                "simbolo bagno donne",
                "simbolo del bagno delle donne",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("女子トイレ"),
            keywords: &["WC", "お手洗い", "トイレ", "化粧室", "女子トイレ", "女性"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("pakiwan wadon"),
            keywords: &["jumbleng", "pakiwan", "wadon", "wese"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ქალების საპირფარეშო"),
            keywords: &[
                "საპირფარეშო",
                "საჭირო ოთახი",
                "ტუალეტი",
                "ქალების საპირფარეშო",
                "ქალი",
            ],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("azamul n tmeṭṭut"),
            keywords: &["azamul n tmeṭṭut"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("әйелдер бөлмесі"),
            keywords: &["дәретхана", "әжетхана", "әйел", "әйелдер бөлмесі"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("kvinder"),
            keywords: &["kvinder", "wc"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("សញ\u{17d2}ញាបន\u{17d2}ទប\u{17cb}នារ\u{17b8}"),
            keywords: &[
                "បន\u{17d2}ទប\u{17cb}ទ\u{17b9}ក",
                "បន\u{17d2}ទប\u{17cb}ទ\u{17b9}កនារ\u{17b8}",
                "សញ\u{17d2}ញា",
                "សញ\u{17d2}ញាបន\u{17d2}ទប\u{17cb}នារ\u{17b8}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಮಹ\u{cbf}ಳ\u{cc6}ಯರ ಕೊಠಡ\u{cbf}"),
            keywords: &[
                "ಡಬ\u{ccd}ಯ\u{cc2}ಸ\u{cbf}",
                "ಮಹ\u{cbf}ಳ\u{cc6}",
                "ಮಹ\u{cbf}ಳ\u{cc6}ಯರ ಕೊಠಡ\u{cbf}",
                "ಮಹ\u{cbf}ಳ\u{cc6}ಯರ ಕೋಣ\u{cc6}",
                "ರ\u{cc6}ಸ\u{ccd}ಟ\u{ccd} ರ\u{cc2}ಂ",
                "ಶ\u{ccc}ಚಾಲಯ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("여자 화장실"),
            keywords: &["여성", "여성용", "여자 화장실", "여자용"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("बायला\u{902}ची म\u{941}तरी"),
            keywords: &[
                "टॉयल\u{947}ट",
                "बायल",
                "बायला\u{902}ची म\u{941}तरी",
                "बायल\u{947}ची म\u{941}तरी",
                "र\u{947}स\u{94d}टर\u{942}म",
                "वॉशर\u{942}म",
                "स\u{902}डास",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("аялдардын дааратканасы"),
            keywords: &["аял", "аялдардын дааратканасы", "даараткана"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Fraentoilett"),
            keywords: &["Fra", "Fraen", "Fraentoilett", "Toilett", "WC"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຫ\u{ec9}ອງແມ\u{ec8}ຍ\u{eb4}ງ"),
            keywords: &[
                "ຫ\u{ec9}ອງ",
                "ຫ\u{ec9}ອງແມ\u{ec8}ຍ\u{eb4}ງ",
                "ແມ\u{ec8}ຍ\u{eb4}ງ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("moterų tualetas"),
            keywords: &["moteris", "moterų tualetas", "tualetas", "wc"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("sieviešu tualete"),
            keywords: &["WC", "sieviešu", "tualete"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("taiwhanga wāhine"),
            keywords: &[
                "heketua",
                "rūma whakatā",
                "taiwhanga wāhine",
                "wahine",
                "wharepaku",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("женски тоалет"),
            keywords: &["жени", "женски тоалет", "тоалет"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("സ\u{d4d}\u{200c}ത\u{d4d}രീകൾക\u{d4d}ക\u{d41}ള\u{d4d}ള മ\u{d41}റി"),
            keywords: &[
                "സിംബൽ",
                "സ\u{d4d}ത\u{d4d}രീകൾ ചിഹ\u{d4d}നം",
                "സ\u{d4d}\u{200c}ത\u{d4d}രീകൾക\u{d4d}ക\u{d41}ള\u{d4d}ള മ\u{d41}റി",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("эмэгтэйчүүдийн өрөө"),
            keywords: &[
                "00",
                "ариун цэврийн өрөө",
                "жорлон",
                "эмэгтэй",
                "эмэгтэйчүүдийн өрөө",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("महिला\u{902}ची खोली"),
            keywords: &[
                "डब\u{94d}ल\u{94d}य\u{942}सी",
                "प\u{94d}रसाधनग\u{943}ह",
                "महिला",
                "महिला\u{902}ची खोली",
                "विश\u{94d}रामग\u{943}ह",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("tandas wanita"),
            keywords: &["bilik air", "tandas", "wanita", "wc"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("kamra tan-nisa"),
            keywords: &["kamra tan-nisa", "latrina", "mara", "toilet", "wc"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အမျ\u{102d}\u{102f}းသမ\u{102e}း သန\u{1037}\u{103a}စင\u{103a}ခန\u{103a}း"),
            keywords: &[
                "ရေအ\u{102d}မ\u{103a}",
                "အမျ\u{102d}\u{102f}းသမ\u{102e}း သန\u{1037}\u{103a}စင\u{103a}ခန\u{103a}း",
                "အ\u{102d}မ\u{103a}သာ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("dametoalett"),
            keywords: &[
                "damer",
                "dametoalett",
                "do",
                "kvinnesymbol",
                "toalett",
                "wc",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("महिलाको कोठा"),
            keywords: &[
                "पानी पाइन\u{947} ठाउ\u{901}",
                "महिला",
                "महिलाको कोठा",
                "शौ\u{902}चालय",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("damestoilet"),
            keywords: &["damestoilet", "toilet", "vrouw", "wc"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("dametoalett"),
            keywords: &[
                "damer",
                "dametoalett",
                "do",
                "kvinnesymbol",
                "toalett",
                "wc",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ମହ\u{b3f}ଳ\u{b3e}ଙ\u{b4d}କ କକ\u{b4d}ଷ"),
            keywords: &[
                "wc",
                "ଆର\u{b3e}ମକକକ\u{b4d}ଷ",
                "ପ\u{b3e}ଇଖ\u{b3e}ନ\u{b3e}",
                "ମହ\u{b3f}ଳ\u{b3e}",
                "ମହ\u{b3f}ଳ\u{b3e}ଙ\u{b4d}କ କକ\u{b4d}ଷ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਔਰਤਾ\u{a02} ਦਾ ਕਮਰਾ"),
            keywords: &[
                "ਔਰਤਾ\u{a02} ਦਾ ਕਮਰਾ",
                "ਔਰਤਾ\u{a02} ਦਾ ਪ\u{a4d}ਰਤੀਕ",
                "ਔਰਤਾ\u{a02} ਨਿਸ\u{a3c}ਾਨ",
                "ਚਿ\u{a70}ਨ\u{a4d}ਹ",
                "ਨਿਸ\u{a3c}ਾਨ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("زنانیاں دا کمرہ"),
            keywords: &["wc", "زنانی", "زنانیاں دا کمرہ", "غسل خانہ", "لیٹرین"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Wúman-dẹm Tọílẹ\u{301}t Rum"),
            keywords: &[
                "Lávétri",
                "Rẹ\u{301}strum",
                "WC",
                "Wúman",
                "Wúman-dẹm Tọílẹ\u{301}t Rum",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("toaleta damska"),
            keywords: &[
                "damski",
                "szalet",
                "toaleta",
                "toaleta damska",
                "ubikacja",
                "ustęp",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د ښځو خونه"),
            keywords: &["تشناب", "د آرام خونه", "د ښځو خونه", "ډبليو سي", "ښځه"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("banheiro feminino"),
            keywords: &[
                "banheiro",
                "feminino",
                "lavatório",
                "mulher",
                "toalete",
                "wc",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("casa de banho para senhoras"),
            keywords: &[
                "casa de banho para senhoras",
                "quarto de banho",
                "senhora",
                "wc",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("warmipaq unancha"),
            keywords: &["baño nisqa", "warmikuna", "warmipaq unancha", "wc"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("toaletă femei"),
            keywords: &["closet", "femei", "toaletă", "wc"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-974"),
            keywords: &["E10-974"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("женский туалет"),
            keywords: &["женский туалет", "женщины", "кабинки", "туалет", "уборная"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ubwiherero bw’abagore"),
            keywords: &[
                "aho bituma",
                "ubwiherero",
                "ubwiherero bw’abagore",
                "umugore",
                "wc",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("عورتن جو ڪمرو"),
            keywords: &["آرام جو ڪمرو", "عورت", "عورتن جو ڪمرو", "غسل خانو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ක\u{dcf}න\u{dca}ත\u{dcf}වගේ ක\u{dcf}මරය"),
            keywords: &[
                "wc",
                "ක\u{dcf}න\u{dca}ත\u{dcf}",
                "ක\u{dcf}න\u{dca}ත\u{dcf}වගේ ක\u{dcf}මරය",
                "වැස\u{dd2}ක\u{dd2}ළ\u{dd2}ය",
                "ව\u{dd2}වේක ක\u{dcf}මරය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("dámske toalety"),
            keywords: &["dámske toalety", "toaleta", "wc", "záchod", "žena"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("stranišče za ženske"),
            keywords: &["stranišče", "stranišče za ženske", "wc", "ženska"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("qolka haweenka"),
            keywords: &["haween", "musqul", "qolka haweenka", "suuli", "wc"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("banja e femrave"),
            keywords: &["banja e femrave", "banjë", "femër", "tualet", "wc"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("женски тоалет"),
            keywords: &["ве-це", "жeнски", "женски тоалет", "тoaлeт"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("ženski toalet"),
            keywords: &["toalet", "ve-ce", "ženski"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("damtoalett"),
            keywords: &["damtoalett", "kvinnor", "symbol för kvinnor", "toalett"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("maliwato ya wanawake"),
            keywords: &["maliwato", "maliwato ya wanawake", "mwanamke"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பெண\u{bcd}கள\u{bcd} பகுதி"),
            keywords: &["பெண\u{bcd}கள\u{bcd}", "பெண\u{bcd}கள\u{bcd} பகுதி"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("స\u{c4d}త\u{c4d}ర\u{c40}ల వ\u{c3f}శ\u{c4d}ర\u{c3e}ంత\u{c3f} గద\u{c3f}"),
            keywords: &[
                "స\u{c4d}త\u{c4d}ర\u{c40}ల వ\u{c3f}శ\u{c4d}ర\u{c3e}ంత\u{c3f} గద\u{c3f}",
                "స\u{c4d}త\u{c4d}ర\u{c40}లు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("ҳоҷатхона барои занон"),
            keywords: &["зан", "ҳоҷатхона", "ҳоҷатхона барои занон"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ห\u{e49}องน\u{e49}ำหญ\u{e34}ง"),
            keywords: &[
                "ผ\u{e39}\u{e49}หญ\u{e34}ง",
                "ส\u{e38}ขภ\u{e31}ณฑ\u{e4c}",
                "ส\u{e38}ขา",
                "ห\u{e49}องน\u{e49}ำ",
                "ห\u{e49}องน\u{e49}ำหญ\u{e34}ง",
                "ห\u{e49}องหญ\u{e34}ง",
            ],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ክፍሊ ናይ ኣንስቲ"),
            keywords: &["wc", "ሰበይቲ", "ሽቃቅ", "ናይ ክዳውንቲ መሕጸቢ ኣቕሓ", "ክፍሊ ናይ ኣንስቲ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("aýallar otagy"),
            keywords: &[
                "aýallar otagy",
                "dynç otagy",
                "hajathana",
                "tualet",
                "zenan",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("fale mālōlō fefine"),
            keywords: &["fale mālōlō", "fale mālōlō fefine", "fefine"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("kadınlar tuvaleti"),
            keywords: &["işaret", "kadınlar tuvaleti", "tuvalet"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئاياللار ھاجەتخانىسى"),
            keywords: &[
                "ئايال",
                "ئاياللار ھاجەتخانىسى",
                "تازىلىق ئۆيى",
                "سۇخانا",
                "ھاجەتخانا",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("жіноча вбиральня"),
            keywords: &[
                "для жінок",
                "жіноча вбиральня",
                "жіночий туалет",
                "убиральня",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("عورتوں کا ٹوائلٹ"),
            keywords: &["عورتوں کا ٹوائلٹ", "عورتیں", "ٹوائلٹ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("ayollar xonasi"),
            keywords: &["ayol", "ayollar xonasi", "hojatxona"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("nhà vệ sinh nữ"),
            keywords: &["nhà vệ sinh", "nhà vệ sinh nữ", "nữ", "phòng vệ sinh", "wc"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("néegu jigéen ñi"),
            keywords: &["duus", "jigéen", "noppalukaay", "néegu jigéen ñi", "wc"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("igumi lamabhinqa"),
            keywords: &[
                "i-wc",
                "ibhinqa",
                "igumbi lokuphumla",
                "igumi lamabhinqa",
                "ithoyilethi",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("iyara awọn obinrin"),
            keywords: &[
                "ilé ìgbò\u{329}nṣẹ\u{300} olómi",
                "ilé ìgbọ\u{300}nṣẹ\u{300}",
                "iyara awọn obinrin",
                "obìnrin",
                "ìyàrá ìsinmi",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("女廁"),
            keywords: &["女", "女廁", "廁所", "洗手間", "衛生間"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("女厕"),
            keywords: &["卫生间", "厕所", "女", "女厕", "洗手间"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("女厕"),
            keywords: &["卫生间", "厕所", "女厕", "女士", "洗手间"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("女廁"),
            keywords: &["女廁"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("indlu yangasese yabesimame"),
            keywords: &["abesimame", "indlu yangasese", "indlu yangasese yabesimame"],
        },
    ],
};
#[doc = "🚻"]
pub const RESTROOM: crate::Emoji = crate::Emoji {
    glyph: "🚻",
    codepoint: "1F6BB",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "restroom",
    group: "Symbols",
    subgroup: "transport-sign",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("kleedkamer"),
            keywords: &["kleedkamer", "toilet"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("መጸዳጃ ቤት"),
            keywords: &["መጸዳጃ ቤት", "ሽንት ቤት", "ደብልዩ ሲ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("دورة مياه"),
            keywords: &["حمام", "دورة مياه", "مرحاض"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ৰেষ\u{9cd}টৰ\u{9c1}ম"),
            keywords: &[
                "ডব\u{9cd}লিউচি",
                "শৌচ\u{9be}গ\u{9be}ৰ",
                "ৰেষ\u{9cd}টৰ\u{9c1}ম",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("ayaqyolu"),
            keywords: &["ayaqyolu", "wc"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("прыбіральня"),
            keywords: &["прыбіральня", "туалет"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("обществена тоалетна"),
            keywords: &["WC", "обществена тоалетна", "тоалетна"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("আর\u{9be}মের কক\u{9cd}ষ"),
            keywords: &["আর\u{9be}মের কক\u{9cd}ষ", "শৌচ\u{9be}গ\u{9be}র"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("golcʼhiri"),
            keywords: &["WC", "golcʼhiri", "privezioù"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("zahod"),
            keywords: &["toalet", "wc", "zahod"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("lavabos"),
            keywords: &["lavabo", "lavabos", "servei", "tocador", "wc"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎡᏓᏍᏗ"),
            keywords: &["WC", "ᎡᏓᏍᏗ", "ᏙᏱ ᎤᎾᏨᏍᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("toalety"),
            keywords: &["toaleta", "toalety", "wc", "záchod"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("ystafell ymolchi"),
            keywords: &["toiled", "ystafell ymolchi"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("toiletskilt"),
            keywords: &["toilet", "toiletskilt", "wc"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Toiletten"),
            keywords: &["Toilette", "Toiletten", "WC"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("δημόσια τουαλέτα"),
            keywords: &[
                "WC",
                "δημόσια τουαλέτα",
                "δημόσιες τουαλέτες",
                "τουαλέτα",
                "τουαλέτες",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("restroom"),
            keywords: &["WC", "lavatory", "restroom"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: Some("toilets"),
            keywords: &["WC", "lavatory", "restroom", "toilets"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("washroom"),
            keywords: &["WC", "bathroom", "lavatory", "restroom", "washroom"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("señal de aseos"),
            keywords: &["aseos", "servicios", "señal de aseos", "wc"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("señal de baño"),
            keywords: &["baño", "público", "servicios", "señal", "señal de baño"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("baño"),
            keywords: &["baño", "sanitarios", "wc"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("tualett"),
            keywords: &["tualett", "wc"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("komuna"),
            keywords: &["komun", "komuna", "wc"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("توالت عمومی"),
            keywords: &["توالت", "توالت عمومی", "سرویس بهداشتی"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("wc"),
            keywords: &["saniteetti", "vessa", "wc"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("banyo"),
            keywords: &["banyo", "cr", "palikuran"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("ves symbol"),
            keywords: &["ves", "ves symbol", "wc"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("panneau Toilettes"),
            keywords: &["WC", "panneau Toilettes", "toilettes"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("toilettes"),
            keywords: &["toilettes"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("comhartha na leithreas"),
            keywords: &["comhartha na leithreas", "leithreas"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("sanas taighe-bhig"),
            keywords: &["sanas taighe-bhig", "taigh-beag", "wc"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("sinal de aseos"),
            keywords: &["aseos", "baño", "homes", "mulleres", "sinal de aseos"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("શૌચાલય"),
            keywords: &[
                "WC",
                "ર\u{ac7}સ\u{acd}ટર\u{ac2}મ",
                "ર\u{ac7}સ\u{acd}ટર\u{ac2}મ ચિહ\u{acd}ન",
                "શૌચાલય",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("bayan gida"),
            keywords: &["WC", "bayan gida", "makewayi"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("שלט שירותים"),
            keywords: &["ציבוריים", "שירותים", "שלט שירותים"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("स\u{941}विधाघर"),
            keywords: &[
                "बाथर\u{942}म",
                "शौचालय",
                "स\u{941}विधाघर",
                "स\u{941}विधाघर का चिह\u{94d}न",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("toalet"),
            keywords: &["toalet", "zahod"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("mosdó"),
            keywords: &["mosdó", "toalett", "vécé"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ընդհանուր զուգարան"),
            keywords: &["wc", "զուգարան", "ընդհանուր զուգարան"],
        },
        #[cfg(feature = "ia")]
        crate::Annotation {
            lang: "ia",
            tts: Some("lavatorio"),
            keywords: &["cabinetto", "lavatorio", "toilette", "toilettes", "wc"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("kamar kecil"),
            keywords: &["WC", "kamar kecil", "toilet"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ụlọ maamịrị"),
            keywords: &["WC", "ụlọ maamịrị", "ụlọ mpochi"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("salernisaðstaða"),
            keywords: &["WC", "klósett", "salernisaðstaða", "snyrting"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("simbolo dei servizi igienici"),
            keywords: &["bagni", "simbolo", "simbolo dei servizi igienici", "wc"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("トイレ"),
            keywords: &["WC", "お手洗い", "トイレ", "化粧室"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("pakiwan"),
            keywords: &["jumbleng", "pakiwan", "wese"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("საპირფარეშო"),
            keywords: &["საპირფარეშო", "საჭირო ოთახი", "ტუალეტი"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("azamul n teslalayt"),
            keywords: &["azamul n teslalayt"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("әжетхана"),
            keywords: &["әжетхана", "әйел"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("toiletskilt"),
            keywords: &["toilet-skilt", "toiletskilt"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("សញ\u{17d2}ញាបន\u{17d2}ទប\u{17cb}ទ\u{17b9}ក"),
            keywords: &[
                "បន\u{17d2}ទប\u{17cb}",
                "បន\u{17d2}ទប\u{17cb}ទ\u{17b9}ក",
                "សញ\u{17d2}ញា",
                "សញ\u{17d2}ញាបន\u{17d2}ទប\u{17cb}ទ\u{17b9}ក",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ರ\u{cc6}ಸ\u{ccd}ಟ\u{ccd} ರ\u{cc2}ಂ"),
            keywords: &[
                "ಡಬ\u{ccd}ಲ\u{ccd}ಯ\u{cc2}ಸ\u{cbf}",
                "ರ\u{cc6}ಸ\u{ccd}ಟ\u{ccd} ರ\u{cc2}ಂ",
                "ರ\u{cc6}ಸ\u{ccd}ಟ\u{ccd} ರ\u{cc2}ಂ ಸಂಕೇತ",
                "ಶ\u{ccc}ಚಾಲಯದ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("화장실"),
            keywords: &["공중화장실", "화장실"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("र\u{947}स\u{94d}टर\u{942}म"),
            keywords: &[
                "टॉयल\u{947}ट",
                "म\u{941}तरी",
                "र\u{947}स\u{94d}टर\u{942}म",
                "वॉशर\u{942}म",
                "स\u{902}डास",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("даараткана"),
            keywords: &["ажааткана", "даараткана"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Toiletten"),
            keywords: &["Toilett", "Toiletten", "WC"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຫ\u{ec9}ອງນ\u{ecd}\u{ec9}າ"),
            keywords: &["ຫ\u{ec9}ອງນ\u{ecd}\u{ec9}າ", "ຫ\u{ec9}ອງສ\u{eb8}ຂາ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("tualeto kambarys"),
            keywords: &["moteris", "tualetas", "tualeto kambarys", "wc"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("tualete"),
            keywords: &["WC", "tualete"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("rūma whakatā"),
            keywords: &["heketua", "rūma whakatā", "wharepaku"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("тоалет"),
            keywords: &["вц", "тоалет"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("റെസ\u{d4d}\u{200c}റ\u{d4d}റ\u{d4d} റ\u{d42}ം"),
            keywords: &[
                "ടോയ\u{d4d}\u{200c}ലെറ\u{d4d}റ\u{d4d}",
                "റെസ\u{d4d}\u{200c}റ\u{d4d}റ\u{d4d} റ\u{d42}ം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("ариун цэврийн өрөө"),
            keywords: &["00", "ариун цэврийн өрөө", "жорлон"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("विश\u{94d}रामग\u{943}ह"),
            keywords: &[
                "डब\u{94d}ल\u{94d}य\u{942}सी",
                "प\u{94d}रसाधनग\u{943}ह",
                "विश\u{94d}रामग\u{943}ह",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("bilik air"),
            keywords: &["bilik air", "tandas", "wc"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("toilets"),
            keywords: &["WC", "lavatory", "toilet", "toilets"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အများသ\u{102f}\u{1036}း ရေအ\u{102d}မ\u{103a}"),
            keywords: &[
                "ရေအ\u{102d}မ\u{103a}",
                "အများသ\u{102f}\u{1036}း ရေအ\u{102d}မ\u{103a}",
                "အများသ\u{102f}\u{1036}း သန\u{1037}\u{103a}စင\u{103a}ခန\u{103a}း",
                "အ\u{102d}မ\u{103a}သာ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("toalettskilt"),
            keywords: &["WC", "do", "toalett", "toalettskilt"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("शौ\u{902}चालय"),
            keywords: &["पानी पाइन\u{947} ठाउ\u{901}", "शौ\u{902}चालय"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("toiletten"),
            keywords: &["toilet", "toiletten", "wc"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("toalettskilt"),
            keywords: &["WC", "do", "toalett", "toalettskilt"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଆର\u{b3e}ମ କକ\u{b4d}ଷ"),
            keywords: &["WC", "ଆର\u{b3e}ମ କକ\u{b4d}ଷ", "ପ\u{b3e}ଇଖ\u{b3e}ନ\u{b3e}"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਆਰਾਮ ਕਮਰਾ"),
            keywords: &["wc", "ਆਰਾਮ ਕਮਰਾ", "ਆਰਾਮ ਕਮਰਾ ਚਿ\u{a70}ਨ\u{a4d}ਹ", "ਟਾਇਲਟ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("لیٹرین"),
            keywords: &["WC", "غسل خانہ", "لیٹرین"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Tọílẹ\u{301}t Rum"),
            keywords: &["Lávétri", "Rẹ\u{301}strum", "Tọílẹ\u{301}t Rum", "WC"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("toalety"),
            keywords: &["toaleta", "toalety", "ubikacja", "łazienka"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د آرام خونه"),
            keywords: &["تشناب", "د آرام خونه", "ډبليو سي"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("banheiro"),
            keywords: &["banheiro", "lavabo", "sanitário", "toalete"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("casa de banho"),
            keywords: &["casa de banho", "quarto de banho", "wc"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("baños"),
            keywords: &["baño nisqa", "baños", "wc"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("toaletă mixtă"),
            keywords: &["baie", "closet", "toaletă", "toaletă mixtă", "wc"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-975"),
            keywords: &["E10-975"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("уборная"),
            keywords: &["WC", "туалет", "уборная"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ubwiherero"),
            keywords: &["WC", "aho bituma", "ubwiherero"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("آرام جو ڪمرو"),
            keywords: &["آرام جو ڪمرو", "غسل خانو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ව\u{dd2}වේක ක\u{dcf}මරය"),
            keywords: &[
                "wc",
                "වැස\u{dd2}ක\u{dd2}ළ\u{dd2}ය",
                "ව\u{dd2}වේක ක\u{dcf}මරය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("toalety"),
            keywords: &["toalety", "wc", "záchod"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("javno stranišče"),
            keywords: &["javno stranišče", "wc"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("suuliga"),
            keywords: &["WC", "musqusha", "suuliga", "suuligga"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("banja"),
            keywords: &["banja", "banjë", "tualet", "wc"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("тоалет"),
            keywords: &["ве-це", "тoaлeт", "тоалет"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("toalet"),
            keywords: &["toalet", "ve-ce"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("wc-skylt"),
            keywords: &["toalett", "wc", "wc-skylt"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("maliwato"),
            keywords: &["choo", "maliwato"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("கழிவறை"),
            keywords: &[
                "கழிவறை",
                "ட\u{bbe}ய\u{bcd}லெட\u{bcd}",
                "ப\u{bbe}த\u{bcd}ரூம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("వ\u{c3f}శ\u{c4d}ర\u{c3e}ంత\u{c3f} గద\u{c3f}"),
            keywords: &[
                "బ\u{c3e}త\u{c4d}రూం",
                "వ\u{c3f}శ\u{c4d}ర\u{c3e}ంత\u{c3f} గద\u{c3f}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("ташноб"),
            keywords: &["ташноб", "ҳоҷатхона", "ҳоҷтхона"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ห\u{e49}องน\u{e49}ำ"),
            keywords: &["ส\u{e38}ขภ\u{e31}ณฑ\u{e4c}", "ห\u{e49}องน\u{e49}ำ"],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ሽቃቅ"),
            keywords: &["WC", "ሽቃቅ", "ናይ ክዳውንቲ መሕጸቢ ኣቕሓ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("tualet"),
            keywords: &["dynç otagy", "hajathana", "tualet"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("fale mālōlō"),
            keywords: &["fale mālōlō"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("tuvalet"),
            keywords: &["lavabo", "tuvalet", "wc"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("تازىلىق ئۆيى"),
            keywords: &["تازىلىق ئۆيى", "سۇخانا", "ھاجەتخانا"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("громадський туалет"),
            keywords: &["вбиральня", "громадський туалет", "клозет", "туалет"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ریسٹ روم"),
            keywords: &["ریسٹ روم", "ٹوائلٹ", "کمرہ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("pardoz-andoz xonasi"),
            keywords: &["hojatxona", "pardoz-andoz xonasi"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("nhà vệ sinh"),
            keywords: &["nhà vệ sinh", "phòng vệ sinh", "wc"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("néegu noppalukaay"),
            keywords: &["WC", "duus", "noppalukaay", "néegu noppalukaay"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("igumbi lokuphumla"),
            keywords: &["i-WC", "igumbi lokuphumla", "ithoyilethi"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("iléìyàgbẹ\u{301}"),
            keywords: &[
                "ilé ìgbò\u{329}nṣẹ\u{300} olómi",
                "ilé ìgbọ\u{300}nṣẹ\u{300}",
                "iléìyàgbẹ\u{301}",
                "ìyàrá ìsinmi",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("洗手間"),
            keywords: &["廁所", "洗手間", "衛生間"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("洗手间"),
            keywords: &["卫生间", "厕所", "洗手间"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("卫生间"),
            keywords: &["卫生间", "厕所", "洗手间"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("洗手間"),
            keywords: &["洗手間"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("洗手間"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("indlu encane"),
            keywords: &["indlu encane", "indlu yangasese"],
        },
    ],
};
#[doc = "🚼"]
pub const BABY_SYMBOL: crate::Emoji = crate::Emoji {
    glyph: "🚼",
    codepoint: "1F6BC",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "baby symbol",
    group: "Symbols",
    subgroup: "transport-sign",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("babasimbool"),
            keywords: &["baba", "babasimbool", "doekomruil"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የሕፃን ምልክት"),
            keywords: &["ሕፃን", "መለወጥ", "የሕፃን ምልክት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("إشارة طفل"),
            keywords: &[
                "إشارة طفل",
                "طفل",
                "طفل داخل السيارة",
                "محطة تغيير ملابس أطفال",
            ],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("কে\u{981}চ\u{9c1}ৱ\u{9be} চিহ\u{9cd}ন"),
            keywords: &[
                "কে\u{981}চ\u{9c1}ৱ\u{9be}",
                "কে\u{981}চ\u{9c1}ৱ\u{9be} চিহ\u{9cd}ন",
                "কে\u{981}চ\u{9c1}ৱ\u{9be}ৰ ক\u{9be}পোৰ সলোৱ\u{9be} স\u{9cd}থ\u{9be}ন",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("körpə simvolu"),
            keywords: &["dəyişiklik", "körpə", "körpə simvolu"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("знак «немаўля»"),
            keywords: &["дзіця", "знак «немаўля»", "спавіванне"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("символ на бебе"),
            keywords: &["бебе", "повиване", "символ на бебе"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("শিশ\u{9c1}র চিহ\u{9cd}ন"),
            keywords: &["চেঞ\u{9cd}জিং", "শিশ\u{9c1}", "শিশ\u{9c1}র চিহ\u{9cd}ন"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("arouez babig"),
            keywords: &["arouez babig", "babig"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("slika bebe"),
            keywords: &["beba", "presvlačenje", "slika bebe"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("símbol de nadó"),
            keywords: &["bebè", "nadó", "símbol de bebè", "símbol de nadó"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᏍᏗ ᏗᏟᎶᏍᏔᏅᎢ"),
            keywords: &["ᎤᏍᏗ", "ᎤᏍᏗ ᏗᏟᎶᏍᏔᏅᎢ", "ᏛᎦᏁᏟᏴᎡᎲᎢ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("symbol dítěte"),
            keywords: &["dítě", "přebalení", "přebalovací", "symbol dítěte"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("symbol babi"),
            keywords: &["babi", "newid", "symbol babi"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("babysymbol"),
            keywords: &["baby", "babyskilt", "babysymbol", "bleskift", "skifte"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Symbol „Baby“"),
            keywords: &["Symbol „Baby“", "Wickelraum"],
        },
        #[cfg(feature = "de_CH")]
        crate::Annotation {
            lang: "de_CH",
            tts: Some("Baby-Symbol"),
            keywords: &["Baby-Symbol", "Symbol „Baby“", "Wickelraum"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("σύμβολο μωρού"),
            keywords: &["αλλάζω", "μωρό", "σύμβολο μωρού"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("baby symbol"),
            keywords: &["baby", "baby symbol", "changing"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["baby", "baby symbol", "change room", "changing"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("señal de bebé"),
            keywords: &["bebé", "cambiar", "lactancia", "señal de bebé"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["bebé", "bordo", "cambiador", "señal", "señal de bebé"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["bebé", "cambiador", "señal", "señal de bebé"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["bebé", "cambio", "señal de bebé"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("beebi sümbol"),
            keywords: &["beebi", "beebi sümbol", "imik", "mähe"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("haurtxoen aldagela"),
            keywords: &["aldatu", "haurtxo", "haurtxoen aldagela"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("نماد نوزاد"),
            keywords: &["اتاق مادر و کودک", "بچه", "تعویض", "نماد نوزاد", "پوشک"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("vauva-merkki"),
            keywords: &["lapsenhoito", "vauva", "vauva-merkki"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("pansanggol"),
            keywords: &["palitan", "pansanggol", "simbolo"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("pinkubarna symbol"),
            keywords: &["pinkubarna symbol", "skiftingarrúm", "skiftirúm"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("symbole Bébé"),
            keywords: &["bébé", "espace de change", "symbole Bébé"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("symbole bébé"),
            keywords: &["bébé", "symbole bébé", "table à langer"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("comhartha linbh"),
            keywords: &["bord athraithe", "comhartha linbh", "leanbh"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("samhla leanabhain"),
            keywords: &["badan", "leanabh", "naoidhean", "samhla leanabhain"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("sinal de cambiador de bebés"),
            keywords: &[
                "bebé",
                "cambiador",
                "sala de lactación",
                "sinal de cambiador de bebés",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("બાળકન\u{ac1}\u{a82} ચિહ\u{acd}ન"),
            keywords: &[
                "અ\u{a82}દર બાળક છ\u{ac7}",
                "બાળક",
                "બાળકના વસ\u{acd}ત\u{acd}ર બદલવાન\u{ac1}\u{a82} સ\u{acd}થાન",
                "બાળકન\u{ac1}\u{a82} ચિહ\u{acd}ન",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("alamar jariri"),
            keywords: &["alamar jariri", "canzawa", "jariri"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("סמל של תינוק"),
            keywords: &["החתלה", "להחליף חיתול", "סמל של תינוק", "תינוק"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("गाड\u{93c}ी म\u{947}\u{902} शिश\u{941} ह\u{948}"),
            keywords: &[
                "गाड\u{93c}ी म\u{947}\u{902} शिश\u{941} ह\u{948}",
                "बच\u{94d}च\u{947} का चिह\u{94d}न",
                "बच\u{94d}च\u{947} क\u{947} कपड\u{93c}\u{947} बदलन\u{947} का स\u{94d}थान",
                "शिश\u{941}",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("simbol bebe"),
            keywords: &["beba", "presvlačenje", "simbol bebe"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("baba szimbólum"),
            keywords: &["baba szimbólum", "kisbaba", "pelenkázó"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("նորածնի նշան"),
            keywords: &["նորածին", "նորածնի նշան", "փոխել"],
        },
        #[cfg(feature = "ia")]
        crate::Annotation {
            lang: "ia",
            tts: Some("symbolo de bebe"),
            keywords: &[
                "baby",
                "bebe",
                "cambiar",
                "fascia",
                "neonato",
                "symbolo de bebe",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("simbol bayi"),
            keywords: &["bayi", "ganti", "simbol bayi"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("akara nwata ọhụrụ"),
            keywords: &["akara nwata ọhụrụ", "na-agbanwe", "nwata ọhụrụ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("barnamerki"),
            keywords: &["barn um borð", "barnamerki", "bleyjuskipti", "skiptiborð"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("simbolo con immagine di bambino"),
            keywords: &[
                "bambino a bordo",
                "cartello neonato",
                "fasciatoio",
                "simbolo con immagine di bambino",
                "simbolo neonato",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ベビーシート"),
            keywords: &["ベビー", "ベビーシート", "赤ちゃん", "赤ん坊"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("tandha bayi"),
            keywords: &["bayi", "nyalini bayi", "tandha bayi"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ბავშვის სიმბოლო"),
            keywords: &["ბავშვი", "ბავშვის სიმბოლო", "გამოცვლა"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("azamul n ṣebyan"),
            keywords: &["azamul n ṣebyan"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("сәбилер"),
            keywords: &["киім ауыстыру", "сәби", "сәбилер"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("babysymbol"),
            keywords: &["baby-skilt", "babysymbol", "skifte"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("សញ\u{17d2}ញាមានទារក"),
            keywords: &[
                "ទារក",
                "ប\u{17d2}ដ\u{17bc}រកន\u{17d2}ទប",
                "សញ\u{17d2}ញាទារក",
                "សញ\u{17d2}ញាមានទារក",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಮಗುವ\u{cbf}ನ ಚ\u{cbf}ಹ\u{ccd}ನ\u{cc6}"),
            keywords: &[
                "ಬೋರ\u{ccd}ಡ\u{ccd}\u{200c}ನಲ\u{ccd}ಲ\u{cbf} ಮಗು",
                "ಮಗು",
                "ಮಗು ಬದಲಾಯ\u{cbf}ಸುವ ನ\u{cbf}ಲ\u{ccd}ದಾಣ",
                "ಮಗುವ\u{cbf}ನ ಚ\u{cbf}ಹ\u{ccd}ನ\u{cc6}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("수유실"),
            keywords: &["기저귀", "수유실"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("शिश\u{942} चिन\u{94d}न"),
            keywords: &[
                "डायपर च\u{947}\u{902}जि\u{902}ग र\u{942}म",
                "शिश\u{942}",
                "शिश\u{942} चिन\u{94d}न",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("бала символу"),
            keywords: &["бала", "бала символу"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Bëbeeszeechen"),
            keywords: &["Bëbee", "Bëbeeszeechen", "wéckelen"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ສ\u{eb1}ນຍາລ\u{eb1}ກເດ\u{eb1}ກນ\u{ec9}ອຍ"),
            keywords: &[
                "ສ\u{eb1}ນຍາລ\u{eb1}ກ",
                "ສ\u{eb1}ນຍາລ\u{eb1}ກເດ\u{eb1}ກນ\u{ec9}ອຍ",
                "ເດ\u{eb1}ກນ\u{ec9}ອຍ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("kūdikio simbolis"),
            keywords: &["kūdikio simbolis", "kūdikis", "vystyklų keitimas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("zīdaiņa simbols"),
            keywords: &["pārtīt", "zīdainis", "zīdaiņa simbols"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tohu pēpi"),
            keywords: &["pēpi", "tohu pēpi", "whakapaipai"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("простор за преслекување бебе"),
            keywords: &["бебе", "преслекување", "простор за преслекување бебе"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ശിശ\u{d41} ചിഹ\u{d4d}നം"),
            keywords: &["ശിശ\u{d41} ചിഹ\u{d4d}നം", "ശിശ\u{d41} സിംബൽ"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("нялх хүүхдийн дүрс тэмдэг"),
            keywords: &["нялх хүүхдийн дүрс тэмдэг", "нялх хүүхэд", "өөрчлөлт"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("बाळाच\u{947} चिन\u{94d}ह"),
            keywords: &["कपड\u{947} बदलण\u{947}", "बाळ", "बाळाच\u{947} चिन\u{94d}ह"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("simbol bayi"),
            keywords: &["bayi", "simbol bayi", "tukar lampin"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("simbolu ta’ trabi"),
            keywords: &["simbolu ta’ trabi", "tarbija", "tbiddel"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ကလေး သင\u{103a}\u{1039}ကေတ"),
            keywords: &["ကလေး", "ကလေး သင\u{103a}\u{1039}ကေတ", "လ\u{1032}ရန\u{103a}"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("babysymbol"),
            keywords: &["babyskilt", "babysymbol", "stellestasjon"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("बच\u{94d}चाको स\u{902}क\u{947}त"),
            keywords: &[
                "कपडा फ\u{947}र\u{94d}न\u{947}",
                "बच\u{94d}चा",
                "बच\u{94d}चाको स\u{902}क\u{947}त",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("babysymbool"),
            keywords: &["baby", "baby aan boord", "babyruimte", "babysymbool"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("babysymbol"),
            keywords: &["babyskilt", "babysymbol", "stellestasjon"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଛୋଟ ପ\u{b3f}ଲ\u{b3e} ସଙ\u{b4d}କେତ"),
            keywords: &[
                "ଛୋଟ ପ\u{b3f}ଲ\u{b3e} ସଙ\u{b4d}କେତ",
                "ବଦଳ\u{b3e}ଇବ\u{b3e}",
                "ଶ\u{b3f}ଶ\u{b41}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਬ\u{a71}ਚ\u{a47} ਦਾ ਚਿ\u{a70}ਨ\u{a4d}ਹ"),
            keywords: &[
                "ਚਿ\u{a70}ਨ\u{a4d}ਹ",
                "ਬਦਲਣਾ",
                "ਬ\u{a4b}ਰਡ ਤ\u{a47} ਬ\u{a71}ਚਾ",
                "ਬ\u{a71}ਚਾ",
                "ਬ\u{a71}ਚ\u{a47} ਦਾ ਚਿ\u{a70}ਨ\u{a4d}ਹ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("بال دی علامت"),
            keywords: &["بال", "بال دی علامت", "بدلنا"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Bébí Símbul"),
            keywords: &["Bébi", "Bébí Símbul", "Chenj"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("symbol niemowlęcia"),
            keywords: &["niemowlę", "symbol niemowlęcia"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د ماشوم نښه"),
            keywords: &["بدلول", "د ماشوم نښه", "ماشوم"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("símbolo de bebê"),
            keywords: &["bebê", "fralda", "fraldário", "símbolo de bebê"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("símbolo de fraldário"),
            keywords: &["bebé", "símbolo de fraldário", "trocar fraldas"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("wawapaq unancha"),
            keywords: &["tiraypaq", "wawa", "wawapaq unancha"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("simbol bebeluș"),
            keywords: &["bebeluș", "scutece", "simbol bebeluș"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-976"),
            keywords: &["E10-976"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("пеленальная"),
            keywords: &["дети", "младенцы", "пеленальная", "пеленки", "стол"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ikimenyetso cy’umwana"),
            keywords: &["guhindura", "ikimenyetso cy’umwana", "uruhinja"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ٻار جو نشان"),
            keywords: &["ٻار", "ٻار جو نشان", "ڪپڙا مٽائڻ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ළදර\u{dd4} සංකේතය"),
            keywords: &[
                "ඇඳ\u{dd4}ම\u{dca} ම\u{dcf}ර\u{dd4} ක\u{dd2}ර\u{dd3}ම",
                "ළදර\u{dd4} සංකේතය",
                "ළදර\u{dd4}ව\u{dcf}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("prebaľovacia miestnosť"),
            keywords: &["dieťa", "prebalenie", "prebaľovacia miestnosť"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("simbol dojenčka"),
            keywords: &["dojenček", "previjanje", "simbol dojenčka"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("calaamadda ilmaha"),
            keywords: &["beddelka", "calaamadda ilmaha", "ilmo"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("simboli i bebes"),
            keywords: &["bebe", "në ndryshim", "simboli i bebes"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("симбол за бебу"),
            keywords: &["бeбa", "прeсвлaчeњe", "симбол за бебу"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("simbol za bebu"),
            keywords: &["beba", "presvlačenje", "simbol za bebu"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("bebissymbol"),
            keywords: &["bebis", "bebissymbol", "skötrum"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("alama ya mtoto"),
            keywords: &["alama ya mtoto", "kubadilisha nguo", "mtoto"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("கைக\u{bcd}குழந\u{bcd}தை"),
            keywords: &[
                "குழந\u{bcd}தை",
                "கைக\u{bcd}குழந\u{bcd}தை",
                "ப\u{bbe}ப\u{bcd}ப\u{bbe}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("చ\u{c3f}న\u{c4d}న ప\u{c3f}ల\u{c4d}లలు"),
            keywords: &[
                "చ\u{c3f}న\u{c4d}న ప\u{c3f}ల\u{c4d}లలకు అనువ\u{c48}న గద\u{c3f}",
                "చ\u{c3f}న\u{c4d}న ప\u{c3f}ల\u{c4d}లలు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("аломати \"Кӯдак\""),
            keywords: &["аломати \"Кӯдак\"", "кӯдак", "тағйир додан"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ป\u{e49}ายทารก"),
            keywords: &[
                "ท\u{e35}\u{e48}เปล\u{e35}\u{e48}ยนผ\u{e49}าอ\u{e49}อมเด\u{e47}ก",
                "ป\u{e49}ายทารก",
            ],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ምልክት ናይ ቆልዓ"),
            keywords: &["ምልክት ናይ ቆልዓ", "ምልዋጥ", "ቆልዓ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("bäbek nyşany"),
            keywords: &["arlygyny çalyşmak", "bäbek", "bäbek nyşany"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("ʻilonga valevale"),
            keywords: &["valevale", "ʻilonga"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("bebek işareti"),
            keywords: &[
                "bebek",
                "bebek alt değiştirme yeri",
                "bebek işareti",
                "bebek teknede",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("بوۋاق بەلگىسى"),
            keywords: &["ئۆزگىرىش", "بوۋاق", "بوۋاق بەلگىسى"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("символ немовляти"),
            keywords: &[
                "для немовлят",
                "заміна пелюшок",
                "немовля",
                "символ немовляти",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("بے بی کی علامت"),
            keywords: &["بے بی", "بے بی کی علامت", "سائن"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("chaqaloq belgisi"),
            keywords: &["chaqaloq", "chaqaloq belgisi"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("biểu tượng trẻ em"),
            keywords: &["biểu tượng trẻ em", "thay đồ", "trẻ em"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("màndarga liir"),
            keywords: &["fomp", "liir", "màndarga liir"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("isimboli yosana"),
            keywords: &["isimboli yosana", "ukutshintsha", "usana"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("àmì ọmọ"),
            keywords: &["àmì ọmọ", "àyípadà", "ọmọ ìkókó"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("嬰兒標誌"),
            keywords: &["嬰兒", "嬰兒標誌", "換片"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("婴儿标志"),
            keywords: &["婴儿", "婴儿标志", "换片"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("宝宝"),
            keywords: &["婴儿", "宝宝", "母婴室"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("寶寶"),
            keywords: &["嬰兒", "寶寶"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("嬰兒符號"),
            keywords: &["嬰兒", "嬰兒符號"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("uphawu lwengane"),
            keywords: &["ingane", "ukushintsha", "uphawu lwengane"],
        },
    ],
};
#[doc = "🚾"]
pub const WATER_CLOSET: crate::Emoji = crate::Emoji {
    glyph: "🚾",
    codepoint: "1F6BE",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "water closet",
    group: "Symbols",
    subgroup: "transport-sign",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("WC"),
            keywords: &["WC", "kleedkamer", "toilet", "water"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ባኞ ቤት"),
            keywords: &["መጸዳጃ", "ቁም ሣጥን", "ባኞ ቤት", "ውሃ", "ደብልዩ ሲ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("حمام"),
            keywords: &["حمام", "مرحاض"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("প\u{9be}নীৰ সংযোগ থক\u{9be} শৌচ\u{9be}গ\u{9be}ৰ"),
            keywords: &[
                "ক\u{9cd}লজেট",
                "ডব\u{9cd}লিউচি",
                "প\u{9be}নী",
                "প\u{9be}নীৰ সংযোগ থক\u{9be} শৌচ\u{9be}গ\u{9be}ৰ",
                "শৌচ\u{9be}গ\u{9be}ৰ",
                "ৰেষ\u{9cd}টৰ\u{9c1}ম",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("wc"),
            keywords: &["ayaqyolu", "su", "tualet", "wc"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("туалет"),
            keywords: &["грамадская", "прыбіральня", "туалет"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("тоалетна"),
            keywords: &["WC", "тоалетна"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ব\u{9be}থর\u{9c1}ম"),
            keywords: &["জল", "ব\u{9be}থর\u{9c1}ম", "রেস\u{9cd}টর\u{9c1}ম"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("WC"),
            keywords: &["WC", "golcʼhiri", "privezioù"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("toalet"),
            keywords: &["klozet", "toalet", "voda", "wc", "zahod"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("vàter"),
            keywords: &["bany", "lavabo", "servei", "vàter", "wc"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎧᏅᏑᎸᎢ"),
            keywords: &["wc", "ᎠᎹ", "ᎡᏓᏍᏗ", "ᎧᏅᏑᎸᎢ", "ᏙᏱ ᎤᎾᏨᏍᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("záchod"),
            keywords: &["toaleta", "voda", "wc", "záchod"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("tŷ bach"),
            keywords: &["dŵr", "toiled", "tŷ bach", "tŷbach"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("wc"),
            keywords: &["toilet", "wc"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("WC"),
            keywords: &["Toilette", "WC"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("WC"),
            keywords: &["WC", "τουαλέτα", "τουαλέτες"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("water closet"),
            keywords: &["closet", "lavatory", "restroom", "water", "wc"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("WC"),
            keywords: &[
                "WC",
                "amenities",
                "bathroom",
                "restroom",
                "toilet",
                "water closet",
                "wc",
            ],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("aseos"),
            keywords: &["WC", "aseos", "lavabo", "servicios"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("servicios"),
            keywords: &["baño", "servicios", "señal"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["agua", "baño", "sanitarios", "servicios", "wc"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("WC"),
            keywords: &["WC", "tualett", "vesi", "wc"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("komunak"),
            keywords: &["komun", "komunak", "ur", "wc"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("سرویس بهداشتی"),
            keywords: &["توالت", "سرویس بهداشتی"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("vessa"),
            keywords: &["huussi", "käymälä", "vessa", "wc"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("comfort room"),
            keywords: &[
                "aparador",
                "banyo",
                "comfort room",
                "kubeta",
                "palikuran",
                "tubig",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("wc symbol"),
            keywords: &["ves", "vesi", "wc", "wc symbol"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("WC"),
            keywords: &["WC", "toilettes"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("symbole Toilettes"),
            keywords: &["symbole Toilettes", "toilettes"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("na leithris"),
            keywords: &["leithreas", "na leithris"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("clòsaid-uisge"),
            keywords: &["clòsaid", "clòsaid-uisge", "taigh-beag", "uisge", "wc"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("sinal de aseo"),
            keywords: &["aseo", "baños", "sinal de aseo", "váter"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("વૉટર ક\u{acd}લોઝ\u{ac7}ટ"),
            keywords: &[
                "wc",
                "ર\u{ac7}સ\u{acd}ટર\u{ac2}મ",
                "વૉટર ક\u{acd}લોઝ\u{ac7}ટ",
                "શૌચાલય",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("babban ɗaki"),
            keywords: &[
                "babban ɗaki",
                "bayan gida",
                "mai rufewa",
                "makewayi",
                "ruwa",
                "wc",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("שלט WC"),
            keywords: &["ציבוריים", "שירותים", "שלט WC"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("वॉटर क\u{94d}लोस\u{947}ट"),
            keywords: &[
                "WC",
                "लावाटोरी",
                "वॉटर क\u{94d}लोस\u{947}ट",
                "स\u{941}विधाघर",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("nužnik"),
            keywords: &["nužnik", "toalet", "wc", "zahod"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("toalett"),
            keywords: &["WC", "mellékhelyiség", "mosdó", "toalett", "vécé"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("զուգարան"),
            keywords: &["wc", "զուգարան", "ջուր"],
        },
        #[cfg(feature = "ia")]
        crate::Annotation {
            lang: "ia",
            tts: Some("water-closet"),
            keywords: &[
                "aqua",
                "cabinetto",
                "lavatorio",
                "toilette",
                "water-closet",
                "wc",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("kloset air"),
            keywords: &["air", "kamar kecil", "kloset", "toilet", "wc"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("nchekwa mmiri"),
            keywords: &["mmiri", "nchekwa", "wc", "ụlọ maamịrị", "ụlọ mpochi"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("salerni"),
            keywords: &["WC", "klósett", "salerni", "snyrting"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("simbolo del WC"),
            keywords: &["WC", "bagno", "gabinetto", "simbolo del WC"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("WC"),
            keywords: &["WC", "お手洗い", "トイレ", "化粧室"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("wese"),
            keywords: &["banyu", "jedhing", "jumbleng", "pakiwan", "wese"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("საპირფარეშო ოთახი"),
            keywords: &[
                "საპირფარეშო",
                "საპირფარეშო ოთახი",
                "საჭირო ოთახი",
                "ტუალეტი",
                "წყალი",
            ],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("taslalayt"),
            keywords: &["taslalayt"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("ватерклозет"),
            keywords: &["ватерклозет", "дәретхана", "су", "шкаф", "әжетхана"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("wc"),
            keywords: &["toilet", "wc"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("សញ\u{17d2}ញាបង\u{17d2}គន\u{17cb}"),
            keywords: &[
                "WC",
                "បង\u{17d2}គន\u{17cb}",
                "សញ\u{17d2}ញា",
                "សញ\u{17d2}ញាបង\u{17d2}គន\u{17cb}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ವಾಟರ\u{ccd} ಕ\u{ccd}ಲಾಸ\u{cc6}ಟ\u{ccd}"),
            keywords: &[
                "ಡಬ\u{ccd}ಲ\u{ccd}ಯ\u{cc2}ಸ\u{cbf}",
                "ರ\u{cc6}ಸ\u{ccd}ಟ\u{ccd} ರ\u{cc2}ಂ",
                "ವಾಟರ\u{ccd} ಕ\u{ccd}ಲಾಸ\u{cc6}ಟ\u{ccd}",
                "ಶ\u{ccc}ಚಾಲಯದ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("더블유씨"),
            keywords: &["공중화장실", "더블유씨", "화장실"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("उदकाचो नळ"),
            keywords: &[
                "उदकाचो नळ",
                "टॉयल\u{947}ट",
                "म\u{941}तरी",
                "र\u{947}स\u{94d}टर\u{942}म",
                "वॉशर\u{942}म",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("даараткана белгиси"),
            keywords: &["даараткана", "даараткана белгиси", "суу"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("WC-Zeechen"),
            keywords: &["Toilett", "Toiletten", "WC", "WC-Zeechen", "Waasser"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ປ\u{ec9}າຍຫ\u{ec9}ອງນ\u{ecd}\u{ec9}າ"),
            keywords: &[
                "ປ\u{ec9}າຍ",
                "ປ\u{ec9}າຍຫ\u{ec9}ອງນ\u{ecd}\u{ec9}າ",
                "ຫ\u{ec9}ອງນ\u{ecd}\u{ec9}າ",
                "ຫ\u{ec9}ອງສ\u{eb8}ຂາ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("tualeto patalpa"),
            keywords: &["tualetas", "tualeto patalpa", "vanduo", "wc"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("ateja"),
            keywords: &["WC", "ateja", "tualete"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("wharepaku"),
            keywords: &["heketua", "rūma whakatā", "taiwhanga", "wai", "wharepaku"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("вц"),
            keywords: &["вц", "тоалет"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("വ\u{d3e}ട\u{d4d}ടർ ക\u{d4d}ലോസറ\u{d4d}റ\u{d4d}"),
            keywords: &[
                "ക\u{d4d}ലോസറ\u{d4d}റ\u{d4d}",
                "റെസ\u{d4d}റ\u{d4d}റ\u{d4d} റ\u{d42}ം",
                "വ\u{d3e}ട\u{d4d}ടർ ക\u{d4d}ലോസറ\u{d4d}റ\u{d4d}",
                "വെള\u{d4d}ളം",
                "ശ\u{d41}ചിമ\u{d41}റി",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("жорлонгийн суултуур"),
            keywords: &[
                "00",
                "бие засах газар",
                "жорлон",
                "жорлонгийн суултуур",
                "ус",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("प\u{94d}रसाधनग\u{943}ह"),
            keywords: &[
                "डब\u{94d}ल\u{94d}य\u{942}सी",
                "पाणी",
                "प\u{94d}रसाधनग\u{943}ह",
                "विश\u{94d}रा\u{902}तीग\u{943}ह",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("tandas pam"),
            keywords: &["air", "bilik", "tandas pam", "wc"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("wc"),
            keywords: &["ilma", "kmajra", "latrina", "toilet", "wc"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ရေအ\u{102d}မ\u{103a}"),
            keywords: &[
                "ရေအ\u{102d}မ\u{103a}",
                "ရေအ\u{102d}မ\u{103a} သင\u{103a}\u{1039}ကေတ",
                "သန\u{1037}\u{103a}စင\u{103a}ခန\u{103a}း",
                "အ\u{102d}မ\u{103a}သာ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("do"),
            keywords: &["WC", "do", "toalett"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("पानी पाइन\u{947} ठाउ\u{901}"),
            keywords: &[
                "कोठा",
                "पानी",
                "पानी पाइन\u{947} ठाउ\u{901}",
                "शौ\u{902}चालय",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("wc"),
            keywords: &["toilet", "wasgelegenheid", "water", "wc"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("do"),
            keywords: &["WC", "do", "toalett"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଶୌଚ\u{b3e}ଳୟ"),
            keywords: &[
                "wc",
                "ଆର\u{b3e}ମକକ\u{b4d}ଷ",
                "ଜଳ",
                "ପ\u{b3e}ଇଖ\u{b3e}ନ\u{b3e}",
                "ଶୌଚ\u{b3e}ଳୟ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਪਾਣੀ ਦਾ ਟ\u{a48}\u{a02}ਕੀ"),
            keywords: &[
                "WC",
                "ਟਾਇਲਟ",
                "ਟ\u{a48}\u{a02}ਕੀ",
                "ਪਾਣੀ ਦਾ ਟ\u{a48}\u{a02}ਕੀ",
                "ਫਲ\u{a71}ਸ\u{a3c}",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("پانی آلا بیت الخلاء"),
            keywords: &[
                "wc",
                "خلوت خانہ",
                "غسل خانہ",
                "لیٹرین",
                "پانی",
                "پانی آلا بیت الخلاء",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Wọ\u{301}tá Kọnténa"),
            keywords: &[
                "Lávétri",
                "Rẹ\u{301}strum",
                "WC",
                "Wọ\u{301}ta",
                "Wọ\u{301}tá Kọnténa",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("WC"),
            keywords: &["WC", "szalet", "toaleta", "ubikacja", "ustęp", "wc"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د تشناب د اوبو لوښی"),
            keywords: &[
                "اوبه",
                "تشناب",
                "د آرام خونه",
                "د اوبو لوښی",
                "د تشناب د اوبو لوښی",
                "ډبليو سي",
            ],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("WC"),
            keywords: &["WC", "latrina", "lavabo", "toalete"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("WC"),
            keywords: &["WC", "casa de banho", "wc"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("inodoro"),
            keywords: &["baño nisqa", "baños", "inodoro", "wc", "yaku"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("wc"),
            keywords: &["bărbați", "closet", "toaletă", "wc"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-978"),
            keywords: &["E10-978"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("туалет"),
            keywords: &[
                "WC",
                "женский туалет",
                "мужской туалет",
                "общественный туалет",
                "туалет",
                "уборная",
                "унитаз",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("wese"),
            keywords: &["aho bisukurira", "aho bituma", "ubwiherero", "wc", "wese"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("پاڻي جو هبار"),
            keywords: &[
                "آرام جو ڪمرو",
                "الماري",
                "غسل خانو",
                "پاڻي",
                "پاڻي جو هبار",
                "ڊبليوسي",
            ],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some(
                "ජල ම\u{dd4}ද\u{dca}\u{200d}ර\u{dd2}ත වැස\u{dd2}ක\u{dd2}ළ\u{dd2} කට\u{dca}ටලය",
            ),
            keywords: &[
                "wc",
                "ජල ම\u{dd4}ද\u{dca}\u{200d}ර\u{dd2}ත",
                "ජල ම\u{dd4}ද\u{dca}\u{200d}ර\u{dd2}ත වැස\u{dd2}ක\u{dd2}ළ\u{dd2} කට\u{dca}ටලය",
                "ජලය",
                "වැස\u{dd2}ක\u{dd2}ළ\u{dd2}ය",
                "ව\u{dd2}වේක ක\u{dcf}මරය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("splachovací záchod"),
            keywords: &["splachovací záchod", "toaleta", "voda", "wc", "záchod"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("wc"),
            keywords: &["stranišče", "voda", "wc"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("qolka biyaha"),
            keywords: &[
                "biyo",
                "musqul",
                "qolka biyaha",
                "qolka kaydinta",
                "suuli",
                "wc",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("banjë"),
            keywords: &["banjë", "tualet", "ujë", "wc"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("ве-це"),
            keywords: &["ве-це", "нужник", "тoaлeт"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("ve-ce"),
            keywords: &["nužnik", "toalet", "ve-ce"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("WC"),
            keywords: &["WC", "toalett", "uthus", "wc"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("msala"),
            keywords: &["choo", "maji", "maliwato", "msala"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("வ\u{bbe}ட\u{bcd}டர\u{bcd} குளோசட\u{bcd}"),
            keywords: &[
                "சிறுந\u{bc0}ர\u{bcd} கழிப\u{bcd}பிடம\u{bcd}",
                "வ\u{bbe}ட\u{bcd}டர\u{bcd} குளோசட\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("వ\u{c3e}టర\u{c4d} క\u{c4d}ల\u{c4b}స\u{c46}ట\u{c4d}"),
            keywords: &[
                "గదుల\u{c4d}ల\u{c4b} అంతర\u{c4d}గతంగ\u{c3e} న\u{c40}ట\u{c3f} ప\u{c48}పుల స\u{c4c}లభ\u{c4d}యం",
                "వ\u{c3e}టర\u{c4d} క\u{c4d}ల\u{c4b}స\u{c46}ట\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("мабраз"),
            keywords: &["мабраз", "об", "обхона", "ташноб", "ҳоҷатхона"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ป\u{e49}ายห\u{e49}องน\u{e49}ำ"),
            keywords: &["ป\u{e49}ายห\u{e49}องน\u{e49}ำ", "ห\u{e49}องน\u{e49}ำ"],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("መዕቆሪ ማይ"),
            keywords: &["wc", "መዕቆሪ", "ማይ", "ሽቃቅ", "ናይ ክዳውንቲ መሕጸቢ ኣቕሓ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("unitaz"),
            keywords: &["dynç otagy", "hajathana", "suw", "tualet", "unitaz"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("toileti"),
            keywords: &["fale mālōlō", "toileti"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("wc"),
            keywords: &["WC", "lavabo", "tuvalet", "wc"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("سۇخانا"),
            keywords: &["تازىلىق ئۆيى", "سۇ", "سۇخانا", "ھاجەتخانا"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("символ убиральні [WC]"),
            keywords: &[
                "ванна",
                "вбиральня",
                "знак убиральні WC",
                "кімната",
                "символ убиральні WC",
                "символ убиральні [WC]",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("واش روم"),
            keywords: &["واش روم", "ٹوائلٹ", "کمرہ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("hojatxona"),
            keywords: &["hojatxona", "suv"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("WC"),
            keywords: &["WC", "nhà vệ sinh", "nước", "phòng vệ sinh", "wc"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("tuurukaayu ndox"),
            keywords: &[
                "duus",
                "ndox",
                "noppalukaay",
                "tuurukaayu ndox",
                "wanag",
                "wc",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ithoyilethi egungxulwayo"),
            keywords: &[
                "amanzi",
                "i-wc",
                "igumbi lokuphumla",
                "indlu yangasese",
                "ithoyilethi egungxulwayo",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("iléìyàgbẹ\u{301} olomi"),
            keywords: &[
                "ilé ìgbọ\u{300}nṣẹ\u{300}",
                "ilé ìgbọ\u{300}nṣẹ\u{300} olómi",
                "iléìyàgbẹ\u{301} olomi",
                "omi",
                "ìyàrá ìsinmi",
                "ìyẹ\u{300}wù",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("衛生間"),
            keywords: &["廁所", "水", "洗手間", "衛生間"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("卫生间"),
            keywords: &["卫生间", "厕所", "水", "洗手间"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("厕所"),
            keywords: &["卫生间", "厕所", "洗手间", "盥洗室"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("廁所"),
            keywords: &["廁所", "盥洗室"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("WC"),
            keywords: &["WC", "廁所", "洗手間"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("indawo yamanzi"),
            keywords: &["amanzi", "indawo yamanzi", "indlu yangasese"],
        },
    ],
};
#[doc = "🛂"]
pub const PASSPORT_CONTROL: crate::Emoji = crate::Emoji {
    glyph: "🛂",
    codepoint: "1F6C2",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "passport control",
    group: "Symbols",
    subgroup: "transport-sign",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("paspoortkontrole"),
            keywords: &[
                "beheer",
                "kontrole",
                "paspoort",
                "paspoortbeheer",
                "paspoortkontrole",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የፖስፖርት መቆጣጠሪያ"),
            keywords: &["መቆጣጠሪያ", "የፖስፖርት መቆጣጠሪያ", "ፖስፖርት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("مراقبة جوازات السفر"),
            keywords: &["جواز سفر", "مراقبة", "مراقبة جوازات السفر"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("প\u{9be}ৰপত\u{9cd}ৰ নিয\u{9bc}ন\u{9cd}ত\u{9cd}ৰণ"),
            keywords: &["নিয\u{9bc}ন\u{9cd}ত\u{9cd}ৰণ", "প\u{9be}ৰপত\u{9cd}ৰ"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("pasport yoxlaması"),
            keywords: &["idarə", "pasport", "pasport yoxlaması"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("пашпартны кантроль"),
            keywords: &["кантроль", "пашпарт", "пашпартны кантроль", "праверка"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("паспортен контрол"),
            keywords: &["контрол", "паспорт", "паспортен контрол"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("প\u{9be}সপোর\u{9cd}ট নিয\u{9bc}ন\u{9cd}ত\u{9cd}রণ"),
            keywords: &["নিয\u{9bc}ন\u{9cd}ত\u{9cd}রণ", "প\u{9be}সপোর\u{9cd}ট"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("kontroll paseporzhioù"),
            keywords: &["kontroll", "kontroll paseporzhioù", "paseporzh"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("pasoška kontrola"),
            keywords: &["kontrola", "pasoš", "pasoška kontrola"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("control de passaports"),
            keywords: &["control", "control de passaports", "passaport"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎦᎶᎯᏍᏙᏗ ᏗᎫᎩᏗᏍᎩ"),
            keywords: &["ᎦᎶᎯᏍᏙᏗ", "ᏗᎫᎩᏗᏍᎩ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("pasová kontrola"),
            keywords: &["kontrola", "pas", "pasová kontrola"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("arolygaeth pasbort"),
            keywords: &["arolygaeth", "pasbort"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("paskontrol"),
            keywords: &["pas", "paskontrol"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Passkontrolle"),
            keywords: &["Pass", "Passkontrolle"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("έλεγχος διαβατηρίων"),
            keywords: &["έλεγχος", "έλεγχος διαβατηρίων", "διαβατήριο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("passport control"),
            keywords: &["control", "passport"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("border security"),
            keywords: &["border", "control", "passport", "security"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("control de pasaportes"),
            keywords: &["control", "control de pasaportes", "pasaportes"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("inspección de pasaportes"),
            keywords: &[
                "control",
                "control de pasaportes",
                "inspección de pasaportes",
                "pasaportes",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("passikontroll"),
            keywords: &["kontroll", "pass", "passikontroll"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("pasaporte-kontrola"),
            keywords: &["kontrol", "pasaporte", "pasaporte-kontrola"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("کنترل گذرنامه"),
            keywords: &["کنترل", "گذرنامه"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("passintarkastus"),
            keywords: &["passi", "passintarkastus", "tarkastus"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("passport control"),
            keywords: &["kontrol", "pasaporte", "passport control"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("passeftirlit"),
            keywords: &["eftirlit", "landamark", "pass", "passeftirlit"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("contrôle des passeports"),
            keywords: &["contrôle", "contrôle des passeports", "passeport"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["contrôle", "contrôle des passeports", "douane", "passeport"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("rialú pasanna"),
            keywords: &["pas", "rialú", "rialú pasanna"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("sgrùdadh nam pas"),
            keywords: &["cead-siubhail", "pas", "sgrùdadh", "sgrùdadh nam pas"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("sinal de control de pasaportes"),
            keywords: &["control", "pasaporte", "sinal de control de pasaportes"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("પાસપોર\u{acd}ટ કન\u{acd}ટ\u{acd}રોલ"),
            keywords: &["કન\u{acd}ટ\u{acd}રોલ", "પાસપોર\u{acd}ટ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("mai dubawa fasfo"),
            keywords: &["dubawa", "fasfo", "mai dubawa fasfo"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("שלט עמדת דרכונים"),
            keywords: &["דרכון", "דרכונים", "שלט עמדת דרכונים"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("पासपोर\u{94d}ट निय\u{902}त\u{94d}रण"),
            keywords: &["निय\u{902}त\u{94d}रण", "पासपोर\u{94d}ट"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("kontrola putovnica"),
            keywords: &["kontrola", "putovnica"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("útlevél-ellenőrzés"),
            keywords: &["ellenőrzés", "útlevél", "útlevél-ellenőrzés"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("անձնագրային ստուգում"),
            keywords: &[
                "անձնագիր",
                "անձնագրային ստուգում",
                "անձնագրի ստուգում",
                "ստուգում",
            ],
        },
        #[cfg(feature = "ia")]
        crate::Annotation {
            lang: "ia",
            tts: Some("controlo de passaportos"),
            keywords: &["controlo", "controlo de passaportos", "passaporto"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("kontrol paspor"),
            keywords: &["kontrol", "paspor"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("njizi passpọtụ"),
            keywords: &["njizi", "passpọtụ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("vegabréfaeftirlit"),
            keywords: &["eftirlit", "vegabréf", "vegabréfaeftirlit"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("simbolo del controllo passaporti"),
            keywords: &[
                "controllo",
                "dogana",
                "passaporti",
                "simbolo del controllo passaporti",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("出入国審査"),
            keywords: &["パスポートコントロール", "入出国", "出入国", "出入国審査"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("priksa paspor"),
            keywords: &["pamriksan", "paspor", "priksa paspor"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("საპასპორტო კონტროლი"),
            keywords: &["კონტროლი", "პასპორტი", "საპასპორტო კონტროლი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("құжаттарды тексеру"),
            keywords: &["бақылау", "төлқұжат", "құжаттарды тексеру"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("paskontrol"),
            keywords: &["pas", "paskontrol"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("សញ\u{17d2}ញាព\u{17b7}ន\u{17b7}ត\u{17d2}យល\u{17b7}ខ\u{17b7}តឆ\u{17d2}លងដែន"),
            keywords: &[
                "ល\u{17b7}ខ\u{17b7}តឆ\u{17d2}លងដែន",
                "សញ\u{17d2}ញា",
                "សញ\u{17d2}ញាព\u{17b7}ន\u{17b7}ត\u{17d2}យល\u{17b7}ខ\u{17b7}តឆ\u{17d2}លងដែន",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಪಾಸ\u{ccd}\u{200c}ಪೋರ\u{ccd}ಟ\u{ccd} ನ\u{cbf}ಯಂತ\u{ccd}ರಣ"),
            keywords: &[
                "ನ\u{cbf}ಯಂತ\u{ccd}ರಣ",
                "ಪಾಸ\u{ccd}\u{200c}ಪೋರ\u{ccd}ಟ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("출입국 심사"),
            keywords: &["여권", "출입국 심사"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("पारपत\u{94d}र निय\u{902}त\u{94d}रण"),
            keywords: &["निय\u{902}त\u{94d}रण", "पारपत\u{94d}र"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("паспортту текшерүү"),
            keywords: &["паспорт", "паспортту текшерүү", "текшерүү"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Passkontroll"),
            keywords: &["Kontroll", "Pass", "Passkontroll"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ການຄວບຄ\u{eb8}ມໜ\u{eb1}ງສ\u{eb7}ຜ\u{ec8}ານແດນ"),
            keywords: &[
                "ການຄວບຄ\u{eb8}ມ",
                "ການຄວບຄ\u{eb8}ມໜ\u{eb1}ງສ\u{eb7}ຜ\u{ec8}ານແດນ",
                "ໜ\u{eb1}ງສ\u{eb7}ຜ\u{ec8}ານແດນ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("pasų kontrolė"),
            keywords: &["kontrolė", "pasas", "pasų kontrolė"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("pasu kontrole"),
            keywords: &["kontrole", "pase", "pasu kontrole"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("mana uruwhenua"),
            keywords: &["mana", "uruwhenua"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("пасошка контрола"),
            keywords: &["контрола", "пасош", "пасошка контрола"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("പ\u{d3e}സ\u{d4d}\u{200c}പോർട\u{d4d}ട\u{d4d} കൺട\u{d4d}രോൾ"),
            keywords: &[
                "കൺട\u{d4d}രോൾ",
                "പ\u{d3e}സ\u{d4d}\u{200c}പോർട\u{d4d}ട\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("паспортын шалгалт"),
            keywords: &["паспортын шалгалт", "пасспорт", "шалгалт"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("पासपोर\u{94d}ट निय\u{902}त\u{94d}रण"),
            keywords: &["निय\u{902}त\u{94d}रण", "पासपोर\u{94d}ट"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("kawalan pasport"),
            keywords: &["kawalan", "pasport"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("kontroll tal-passaport"),
            keywords: &["kontroll", "kontroll tal-passaport", "passaport"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "န\u{102d}\u{102f}င\u{103a}င\u{1036}က\u{1030}းလက\u{103a}မ\u{103e}တ\u{103a} စစ\u{103a}ဆေးရေးဌာန",
            ),
            keywords: &[
                "န\u{102d}\u{102f}င\u{103a}င\u{1036}က\u{1030}းလက\u{103a}မ\u{103e}တ\u{103a}",
                "န\u{102d}\u{102f}င\u{103a}င\u{1036}က\u{1030}းလက\u{103a}မ\u{103e}တ\u{103a} စစ\u{103a}ဆေးရေးဌာန",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("passkontroll"),
            keywords: &["kontroll", "pass", "passkontroll"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("पासपोर\u{94d}ट च\u{947}कजा\u{901}च"),
            keywords: &["च\u{947}कजा\u{901}च", "पासपोर\u{94d}ट"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("paspoortcontrole"),
            keywords: &["controle", "paspoort", "paspoortcontrole"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("passkontroll"),
            keywords: &["kontroll", "pass", "passkontroll"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ପ\u{b3e}ସ\u{b4d}\u{200c}ପୋର\u{b4d}ଟ ନ\u{b3f}ୟନ\u{b4d}ତ\u{b4d}ରଣ"),
            keywords: &[
                "ନ\u{b3f}ୟନ\u{b4d}ତ\u{b4d}ରଣ",
                "ପ\u{b3e}ସ\u{b4d}\u{200c}ପୋର\u{b4d}ଟ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਪਾਸਪ\u{a4b}ਰਟ ਕ\u{a70}ਟਰ\u{a4b}ਲ"),
            keywords: &["ਕ\u{a70}ਟਰ\u{a4b}ਲ", "ਪਾਸਪ\u{a4b}ਰਟ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("پاسپورٹ کنٹرول"),
            keywords: &["پاس پورٹ", "پاسپورٹ کنٹرول", "کنٹرول کرنا"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Páspọ\u{301}t Kọntrol"),
            keywords: &["Kọntrol", "Páspọt", "Páspọ\u{301}t Kọntrol"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("kontrola paszportowa"),
            keywords: &[
                "granica",
                "graniczna",
                "kontrola",
                "kontrola paszportowa",
                "paszport",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د پاسپورت کنټرول"),
            keywords: &["د پاسپورت کنټرول", "پاسپورټ", "کنټرول"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("controle de passaportes"),
            keywords: &["controle", "controle de passaportes", "passaporte"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("controlo de passaportes"),
            keywords: &["controlo", "controlo de passaportes", "passaporte"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("pasaporte chiqaqchaynin"),
            keywords: &["chiqaqchayninpaq", "pasaporte", "pasaporte chiqaqchaynin"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("control pașapoarte"),
            keywords: &["control", "control pașapoarte", "pașaport"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-982"),
            keywords: &["E10-982"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("паспортный контроль"),
            keywords: &["контроль", "паспортный", "печать", "проверка"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ahagenzurirwa pasiporo"),
            keywords: &[
                "ahagenzurirwa pasiporo",
                "igenzura",
                "urwandiko rw’abajya mu mahanga",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("پاسپورٽ ڪنٽرول"),
            keywords: &["پاسپورٽ", "ڪنٽرول"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ගමන\u{dca} බලපත\u{dca}\u{200d}ර ප\u{dcf}ලනය"),
            keywords: &[
                "ගමන\u{dca} බලපත\u{dca}\u{200d}ර ප\u{dcf}ලනය",
                "ගමන\u{dca} බලපත\u{dca}\u{200d}රය",
                "ප\u{dcf}ලනය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("pasová kontrola"),
            keywords: &["hranica", "kontrola", "pas", "pasová kontrola"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("pregled dokumentov"),
            keywords: &["nadzor", "potni list", "pregled dokumentov"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("xakamaynta baasaboorka"),
            keywords: &["baasaboor", "xakamaynta baasaboorka", "xukun"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("kontrolli i pasaportave"),
            keywords: &["kontroll", "kontrolli i pasaportave", "pasaportë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("контрола пасоша"),
            keywords: &["кoнтрoлa", "контрола пасоша", "пасош"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["контрола пасоша"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("kontrola pasoša"),
            keywords: &["kontrola", "kontrola pasoša", "pasoš"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["kontrola pasoša"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("passkontroll"),
            keywords: &["kontroll", "pass", "passkontroll"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("udhibiti wa pasipoti"),
            keywords: &["pasipoti", "udhibiti", "udhibiti wa pasipoti"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ப\u{bbe}ஸ\u{bcd}போர\u{bcd}ட\u{bcd} கட\u{bcd}டுப\u{bcd}ப\u{bbe}டு"),
            keywords: &[
                "ப\u{bbe}ஸ\u{bcd}போர\u{bcd}ட\u{bcd}",
                "ப\u{bbe}ஸ\u{bcd}போர\u{bcd}ட\u{bcd} கட\u{bcd}டுப\u{bcd}ப\u{bbe}டு",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ప\u{c3e}స\u{c4d}\u{200c}ప\u{c4b}ర\u{c4d}ట\u{c4d} తన\u{c3f}ఖ\u{c40}"),
            keywords: &[
                "తన\u{c3f}ఖ\u{c40}",
                "ప\u{c3e}స\u{c4d}\u{200c}ప\u{c4b}ర\u{c4d}ట\u{c4d}",
                "ప\u{c4d}రయ\u{c3e}ణం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("назорати шиносномаҳо"),
            keywords: &["назорат", "назорати шиносномаҳо", "шиноснома"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ตรวจพาสปอร\u{e4c}ต"),
            keywords: &["ตรวจพาสปอร\u{e4c}ต", "พาสปอร\u{e4c}ต"],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ናይ ፓስስፖርት ቁጽጽር"),
            keywords: &["ቁጽጽር", "ናይ ፓስስፖርት ቁጽጽር", "ፓስፖርት"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("pasport barlagy"),
            keywords: &["barlag", "pasport", "pasport barlagy"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("ʻofisa tohifolau"),
            keywords: &["ʻofisa tohifolau"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("pasaport kontrolü"),
            keywords: &["kontrol", "pasaport", "pasaport kontrolü"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("پارول تىزگىنى"),
            keywords: &["تىزگىن", "پارول", "پارول تىزگىنى"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("паспортний контроль"),
            keywords: &["контроль", "паспортний"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("پاسپورٹ کنٹرول"),
            keywords: &["پاسپورٹ", "کنٹرول"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("pasport nazorati"),
            keywords: &["nazorat", "pasport", "pasport nazorati"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("kiểm soát hộ chiếu"),
            keywords: &["hộ chiếu", "kiểm soát", "kiểm soát hộ chiếu"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("xool sa paaspoor"),
            keywords: &["paaspoor", "xool", "xool sa paaspoor"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ulawulo lwephaspoti"),
            keywords: &["iphaspoti", "ulawulo", "ulawulo lwephaspoti"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("iṣakoso aworan ori"),
            keywords: &["darí", "iṣakoso aworan ori", "ìwé ìrìnnà"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("護照檢查"),
            keywords: &["檢查", "護照", "護照檢查"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("护照检查"),
            keywords: &["护照", "护照检查", "检查"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("护照检查"),
            keywords: &["安检", "护照检查", "检查", "通行证"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("護照查驗"),
            keywords: &["護照", "護照查驗"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("通關檢查"),
            keywords: &["通關檢查"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ukulawula iphasiphothi"),
            keywords: &["iphasiphothi", "ukulawula"],
        },
    ],
};
#[doc = "🛃"]
pub const CUSTOMS: crate::Emoji = crate::Emoji {
    glyph: "🛃",
    codepoint: "1F6C3",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "customs",
    group: "Symbols",
    subgroup: "transport-sign",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("doeane"),
            keywords: &["doeane"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ጉምሩክ"),
            keywords: &["ጉምሩክ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("جمارك"),
            keywords: &["جمارك", "جمرك"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("সীম\u{9be}শ\u{9c1}ল\u{9cd}ক"),
            keywords: &["সীম\u{9be}শ\u{9c1}ল\u{9cd}ক"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("gömrük"),
            keywords: &["gömrük"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("мытня"),
            keywords: &["кантроль", "мытня", "мытнік", "праверка"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("митница"),
            keywords: &["митница"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ক\u{9be}স\u{9cd}টম"),
            keywords: &["ক\u{9be}স\u{9cd}টম", "ক\u{9be}স\u{9cd}টমস"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("maltouterezh"),
            keywords: &["maltouterezh"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("carina"),
            keywords: &["carina"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("duana"),
            keywords: &["duana"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏄᏍᏛᎢ ᎢᏳᎾᏛᏁᏗ"),
            keywords: &["ᏄᏍᏛᎢ ᎢᏳᎾᏛᏁᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("celnice"),
            keywords: &["celnice", "clo", "deklarovat", "zboží"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("tollau"),
            keywords: &["tollau"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("told"),
            keywords: &["told"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Zollkontrolle"),
            keywords: &["Zoll", "Zollkontrolle"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("τελωνείο"),
            keywords: &["τελωνείο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("customs"),
            keywords: &["customs"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("aduana"),
            keywords: &["aduana"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["aduana"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("toll"),
            keywords: &["toll"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("aduanak"),
            keywords: &["aduanak"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("گمرک"),
            keywords: &["اداره گمرک", "دفتر گمرک", "گمرک", "گمرکات"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("tulli"),
            keywords: &["tulli"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("customs"),
            keywords: &["customs"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("tolleftirlit"),
            keywords: &["eftirlit", "toll", "tolleftirlit", "tollur", "tollverk"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("douane"),
            keywords: &["douane"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("custaim"),
            keywords: &["custaim"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("cusbainn"),
            keywords: &["cusbainn"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("sinal de alfándega"),
            keywords: &["aduana", "alfándega", "sinal de alfándega"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("કસ\u{acd}ટમ\u{acd}સ"),
            keywords: &["કસ\u{acd}ટમ\u{acd}સ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("kwastam"),
            keywords: &["kwastam"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("שלט עמדת מכס"),
            keywords: &["בדיקה", "מכס", "שלט עמדת מכס"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("कस\u{94d}टम"),
            keywords: &["कस\u{94d}टम"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("carina"),
            keywords: &["carina"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("vám"),
            keywords: &["ellenőrzés", "vám"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("մաքսատուն"),
            keywords: &["մաքսային ծառայություն", "մաքսատուն"],
        },
        #[cfg(feature = "ia")]
        crate::Annotation {
            lang: "ia",
            tts: Some("doana"),
            keywords: &["doana"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("bea cukai"),
            keywords: &["bea cukai"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("pụrụiche"),
            keywords: &["pụrụiche"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("tollur"),
            keywords: &["tollhlið", "tollur"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("simbolo della dogana"),
            keywords: &[
                "confine di Stato",
                "controllo doganale",
                "dogana",
                "frontiera",
                "simbolo della dogana",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("税関"),
            keywords: &["税関", "通関"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("pabean"),
            keywords: &["pabean"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("საბაჟო"),
            keywords: &["საბაჟო"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("кеден тексерісі"),
            keywords: &["кеден тексерісі"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("told"),
            keywords: &["told"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("សញ\u{17d2}ញាពន\u{17d2}ធគយ"),
            keywords: &[
                "គយ",
                "ពន\u{17d2}ធគយ",
                "សញ\u{17d2}ញា",
                "សញ\u{17d2}ញាពន\u{17d2}ធគយ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕಸ\u{ccd}ಟಮ\u{ccd}ಸ\u{ccd}"),
            keywords: &["ಕಸ\u{ccd}ಟಮ\u{ccd}ಸ\u{ccd}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("세관"),
            keywords: &["세관"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("कस\u{94d}टम\u{94d}स"),
            keywords: &["कस\u{94d}टम\u{94d}स"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("бажы салыгы"),
            keywords: &["бажы", "бажы салыгы"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Douane"),
            keywords: &["Douane"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ພາສ\u{eb5}"),
            keywords: &["ພາສ\u{eb5}"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("muitinė"),
            keywords: &["muitinė"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("muita"),
            keywords: &["muita"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tari taupare"),
            keywords: &["tari taupare"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("царина"),
            keywords: &["царина"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("കസ\u{d4d}റ\u{d4d}റംസ\u{d4d}"),
            keywords: &["കസ\u{d4d}റ\u{d4d}റംസ\u{d4d}"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("гааль"),
            keywords: &["гааль"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("जकात"),
            keywords: &["जकात", "सीमाश\u{941}ल\u{94d}क"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("kastam"),
            keywords: &["kastam"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("dwana"),
            keywords: &["dwana"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အကောက\u{103a}ခ\u{103d}န\u{103a}"),
            keywords: &["အကောက\u{103a}ခ\u{103d}န\u{103a}"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("toll"),
            keywords: &["grense", "toll"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("भन\u{94d}सार"),
            keywords: &["भन\u{94d}सार"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("douane"),
            keywords: &["douane"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("toll"),
            keywords: &["grense", "toll"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("କଷ\u{b4d}ଟମସ\u{b4d}\u{200c}"),
            keywords: &["କଷ\u{b4d}ଟମସ\u{b4d}\u{200c}"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਕਸਟਮਜ\u{a3c}"),
            keywords: &["ਕਸਟਮਜ\u{a3c}"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("رسومات"),
            keywords: &["رسومات"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Kọ\u{301}stọ\u{301}m Pípol"),
            keywords: &["Kọ\u{301}stọ\u{301}m Pípol"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("kontrola celna"),
            keywords: &["celna", "komora celna", "kontrola"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ګمرک"),
            keywords: &["ګمرک"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("alfândega"),
            keywords: &["aduana", "alfândega", "bens", "impostos"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["aduana", "alfândega"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("aduanas"),
            keywords: &["aduanas"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("vamă"),
            keywords: &["punct vamal", "vamă"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-983"),
            keywords: &["E10-983"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("таможня"),
            keywords: &["багаж", "проверка", "таможенник", "таможня"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("gasutamo"),
            keywords: &["gasutamo"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڪسٽمز"),
            keywords: &["ڪسٽمز"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("රේග\u{dd4}ව"),
            keywords: &["රේග\u{dd4}ව"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("colná prehliadka"),
            keywords: &["colnica", "colná prehliadka", "hranica"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("carina"),
            keywords: &["carina", "carinik"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("canshuurta"),
            keywords: &["canshuurta"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("doganë"),
            keywords: &["doganë", "shenjë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("царина"),
            keywords: &["цaринa", "царина"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["царина"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("carina"),
            keywords: &["carina"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["carina"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("tull"),
            keywords: &["tull", "tullkontroll"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("forodha"),
            keywords: &["eneo la kuingia", "forodha"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("சுங\u{bcd}கம\u{bcd}"),
            keywords: &["கஸ\u{bcd}டம\u{bcd}ஸ\u{bcd}", "சுங\u{bcd}கம\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("కస\u{c4d}టమ\u{c4d}స\u{c4d}"),
            keywords: &[
                "అధ\u{c3f}క\u{c3e}రులు",
                "కస\u{c4d}టమ\u{c4d}స\u{c4d}",
                "తన\u{c3f}ఖ\u{c40}",
                "స\u{c3e}మ\u{c3e}గ\u{c4d}ర\u{c3f}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("гумрук"),
            keywords: &["гумрук"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ศ\u{e38}ลกากร"),
            keywords: &["ภาษ\u{e35}", "ศ\u{e38}ลกากร"],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ጉምሩክ"),
            keywords: &["ጉምሩክ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("gümrük nokady"),
            keywords: &["gümrük nokady"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tute"),
            keywords: &["kasitomu", "tute"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("gümrük"),
            keywords: &["gümrük"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("تاموژنا"),
            keywords: &["تاموژنا"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("митниця"),
            keywords: &["митний контроль", "митниця"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("کسٹمز"),
            keywords: &["ادارہ", "کسٹمز"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("bojxona"),
            keywords: &["bojxona"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("hải quan"),
            keywords: &["hải quan"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("duwaan"),
            keywords: &["duwaan"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("amasiko"),
            keywords: &["amasiko"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("awọn aṣọbode"),
            keywords: &["awọn aṣọbode"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("海關"),
            keywords: &["海關"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("海关"),
            keywords: &["海关"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("海关"),
            keywords: &["海关"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("海關"),
            keywords: &["海關"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("customs"),
            keywords: &["customs"],
        },
    ],
};
#[doc = "🛄"]
pub const BAGGAGE_CLAIM: crate::Emoji = crate::Emoji {
    glyph: "🛄",
    codepoint: "1F6C4",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "baggage claim",
    group: "Symbols",
    subgroup: "transport-sign",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("bagasiesaal"),
            keywords: &["bagasie", "bagasiesaal", "haal"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ሻንጣ መረከቢያ"),
            keywords: &["መጠየቂያ", "ሻንጣ", "ሻንጣ መረከቢያ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("استرداد الحقائب"),
            keywords: &["استرداد الحقائب", "حقائب"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("য\u{9be}ত\u{9cd}ৰীৰ বয\u{9bc}-বস\u{9cd}ত\u{9c1} সংগ\u{9cd}ৰহ"),
            keywords: &[
                "বয\u{9bc}-বস\u{9cd}ত\u{9c1}",
                "য\u{9be}ত\u{9cd}ৰীৰ বয\u{9bc}-বস\u{9cd}ত\u{9c1} সংগ\u{9cd}ৰহ",
                "সংগ\u{9cd}ৰহ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("baqaj tələbi"),
            keywords: &["baqaj", "baqaj tələbi", "tələb"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("атрыманне багажу"),
            keywords: &["атрыманне", "атрыманне багажу", "багаж"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("получаване на багаж"),
            keywords: &["багаж", "получаване", "получаване на багаж"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("জিনিসপত\u{9cd}র দ\u{9be}বি কর\u{9be}"),
            keywords: &[
                "জিনিসপত\u{9cd}র দ\u{9be}বি কর\u{9be}",
                "দ\u{9be}বি",
                "ব\u{9cd}য\u{9be}গেজ",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("adtapout bagajoù"),
            keywords: &["adtapout", "bagajoù"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("preuzimanje prtljaga"),
            keywords: &["preuzimanje", "preuzimanje prtljaga", "prtljag"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("recollida d’equipatges"),
            keywords: &["equipatges", "recollida", "recollida d’equipatges"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎦᏅᏔᏅᏙᏗ ᎪᎯᏳᏗᏍᎩ"),
            keywords: &["ᎦᏅᏔᏅᏙᏗ", "ᎪᎯᏳᏗᏍᎩ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("výdej zavazadel"),
            keywords: &["výdej", "výdej zavazadel", "zavazadlo"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("hawlio bagiau"),
            keywords: &["bagiau", "hawlio"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("bagageudlevering"),
            keywords: &["bagageudlevering", "baggage"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Gepäckausgabe"),
            keywords: &["Gepäck", "Gepäckausgabe"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("παραλαβή αποσκευών"),
            keywords: &["αποσκευές", "παραλαβή", "παραλαβή αποσκευών"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("baggage claim"),
            keywords: &["baggage", "claim"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("recogida de equipajes"),
            keywords: &["equipaje", "maleta", "recogida de equipajes"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("reclamo de equipaje"),
            keywords: &["equipaje", "reclamo", "reclamo de equipaje", "señal"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["equipaje", "reclamo", "reclamo de equipaje"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("pagasi kättesaamine"),
            keywords: &["kättesaamine", "pagas", "pagasi kättesaamine"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("maletak jasotzeko eremua"),
            keywords: &["ekipajea", "jaso", "maletak jasotzeko eremua"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("دریافت بار"),
            keywords: &["بار", "دریافت"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("matkatavarat"),
            keywords: &["hihna", "luovutus", "matkatavarat"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("kuhanan ng bagahe"),
            keywords: &["bagahe", "kuhanan", "kuhanan ng bagahe", "maleta"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("viðførisútflýggjan"),
            keywords: &["viðføri", "viðførisútflýggjan", "útflýggjan"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("retrait des bagages"),
            keywords: &["bagages", "retrait des bagages"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["bagages", "retrait des bagages", "tapis à bagages"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("limistéar bagáiste"),
            keywords: &["bagáiste", "limistéar bagáiste"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("ionad-tagraidh bagaist"),
            keywords: &["baga", "bagaist", "faighinn", "ionad-tagraidh", "tagradh"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("sinal de recollida de equipaxes"),
            keywords: &[
                "equipaxes",
                "maletas",
                "recollida",
                "sinal de recollida de equipaxes",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("બ\u{ac5}ગ\u{ac7}જનો દાવો"),
            keywords: &[
                "બ\u{ac5}ગ\u{ac7}જ",
                "બ\u{ac5}ગ\u{ac7}જ દાવો",
                "બ\u{ac5}ગ\u{ac7}જનો દાવો",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("hakkin kaya"),
            keywords: &["hakki", "hakkin kaya", "kaya"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("שלט איסוף כבודה"),
            keywords: &["איסוף", "כבודה", "מטען", "שלט איסוף כבודה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("सामान वापसी"),
            keywords: &["ब\u{948}ग\u{947}ज", "सामान वापसी"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("preuzimanje prtljage"),
            keywords: &["preuzimanje", "preuzimanje prtljage", "prtljaga"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("poggyászfelvétel"),
            keywords: &["felvétel", "poggyász", "poggyászfelvétel"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ուղեբեռի վերաբերյալ բողոք"),
            keywords: &["բողոք", "ուղեբեռ", "ուղեբեռի վերաբերյալ բողոք"],
        },
        #[cfg(feature = "ia")]
        crate::Annotation {
            lang: "ia",
            tts: Some("collecta de bagage"),
            keywords: &[
                "bagage",
                "collecta",
                "collecta de bagage",
                "reception",
                "retiro",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("pengambilan bagasi"),
            keywords: &["bagasi", "pengambilan"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ibu enwere"),
            keywords: &["enwere", "ibu"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("töskur"),
            keywords: &["farangur", "ferðataska", "töskur"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("simbolo del ritiro bagagli"),
            keywords: &["bagagli", "ritiro", "simbolo del ritiro bagagli"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("手荷物受取"),
            keywords: &["スーツケース", "バゲッジクレーム", "手荷物", "手荷物受取"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("njupuk koper"),
            keywords: &["koper", "njupuk"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ბარგის გაცემა"),
            keywords: &["ბარგი", "ბარგის გაცემა", "გაცემა"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("жолжүкті беру"),
            keywords: &["беру", "жолжүк", "жолжүкті беру"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("baggageudlevering"),
            keywords: &["baggage", "baggageudlevering"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("កន\u{17d2}លែងយកអ\u{17b8}វ\u{17c9}ាន\u{17cb}"),
            keywords: &[
                "កន\u{17d2}លែងយកអ\u{17b8}វ\u{17c9}ាន\u{17cb}",
                "សញ\u{17d2}ញា",
                "សញ\u{17d2}ញាមកយកឥវ\u{17c9}ាន\u{17cb}",
                "ឥវ\u{17c9}ាន\u{17cb}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಸರಕು ಹಕ\u{ccd}ಕು"),
            keywords: &["ಸರಕು", "ಸರಕು ಹಕ\u{ccd}ಕು"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("짐 찾는 곳"),
            keywords: &["짐", "짐 찾는 곳", "화물"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("ब\u{945}ग\u{947}ज दावो"),
            keywords: &["दावो", "ब\u{945}ग\u{947}ज"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("багажды алуу"),
            keywords: &["алуу", "багаж", "багажды алуу"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Gepäckausgab"),
            keywords: &["Ausgab", "Gepäck", "Gepäckausgab"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ບ\u{ec8}ອນເອ\u{ebb}າກະເປ\u{ebb}\u{ecb}າເດ\u{eb5}ນທາງ"),
            keywords: &[
                "ກະເປ\u{ebb}\u{ecb}າເດ\u{eb5}ນທາງ",
                "ບ\u{ec8}ອນເອ\u{ebb}າກະເປ\u{ebb}\u{ecb}າເດ\u{eb5}ນທາງ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("bagažo skyrius"),
            keywords: &["atsiimti", "bagažas", "bagažo skyrius"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("bagāžas saņemšana"),
            keywords: &["bagāža", "bagāžas saņemšana"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kerēme pāhi"),
            keywords: &["kerēme", "pāhi"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("подигање багаж"),
            keywords: &["багаж", "подигање"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ബ\u{d3e}ഗേജ\u{d4d} ക\u{d4d}ലെയിം"),
            keywords: &["ക\u{d4d}ലെയിം", "ബ\u{d3e}ഗേജ\u{d4d}"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("ачаа тээшээ авах"),
            keywords: &["ачаа тээш", "ачаа тээшээ авах", "ачаа тээшээ авах хэсэг"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("सामानाचा दावा"),
            keywords: &["दावा", "सामान", "सामानाचा दावा"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("tuntutan bagasi"),
            keywords: &["bagasi", "tuntutan"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("uffiċċju tal-bagalji"),
            keywords: &["bagalji", "uffiċċju", "uffiċċju tal-bagalji"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ပစ\u{1039}စည\u{103a}းရ\u{103d}ေးရန\u{103a}"),
            keywords: &[
                "ခရ\u{102e}းဆောင\u{103a}အ\u{102d}တ\u{103a}",
                "ခရ\u{102e}းဆောင\u{103a}အ\u{102d}တ\u{103a} ရ\u{103d}ေးရန\u{103a}",
                "ပစ\u{1039}စည\u{103a}းရ\u{103d}ေးရန\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("bagasjebånd"),
            keywords: &["bagasje", "bagasjebånd", "rullebånd"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("ब\u{94d}याग\u{947}ज क\u{94d}ल\u{947}म"),
            keywords: &[
                "दावी",
                "ब\u{94d}याग\u{947}ज",
                "ब\u{94d}याग\u{947}ज क\u{94d}ल\u{947}म",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("bagage afhalen"),
            keywords: &["bagage", "bagage afhalen"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("bagasjeband"),
            keywords: &["bagasje", "bagasjeband", "rulleband"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଜ\u{b3f}ନ\u{b3f}ଷପତ\u{b4d}ର ଦ\u{b3e}ବ\u{b3f}"),
            keywords: &["ଜ\u{b3f}ନ\u{b3f}ଷପତ\u{b4d}ର", "ଦ\u{b3e}ବ\u{b3f}"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਸਾਮਾਨ ‘ਤ\u{a47} ਦਾਅਵਾ"),
            keywords: &["ਸਾਮਾਨ", "ਸਾਮਾਨ ਤ\u{a47} ਦਾਅਵਾ", "ਸਾਮਾਨ ‘ਤ\u{a47} ਦਾਅਵਾ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("سازو سامان دا دعوی\u{670}"),
            keywords: &["دعویدار ہونا", "سازو سامان", "سازو سامان دا دعوی\u{670}"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Wiá To Kọlẹ\u{301}kt Bágej"),
            keywords: &["Bágej", "Kọlẹkt", "Lod", "Wiá To Kọlẹ\u{301}kt Bágej"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("odbiór bagażu"),
            keywords: &["bagaż", "odbiór", "odbiór bagażu"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د سامانونو ادعا"),
            keywords: &["ادعا", "د سامانونو ادعا", "سامان"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("restituição de bagagem"),
            keywords: &["bagagem", "restituição de bagagem"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("recolha de bagagem"),
            keywords: &["bagagem", "recolha", "recolha de bagagem"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("chaskimuy qipikuna"),
            keywords: &["chaskimuy qipikuna"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("recuperare bagaje"),
            keywords: &["bagaje", "recuperare"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-984"),
            keywords: &["E10-984"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("получение багажа"),
            keywords: &["багаж", "лента", "получение багажа"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("aho bafatira ibikapu"),
            keywords: &["aho bafatira ibikapu"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("سامان جو دعوو"),
            keywords: &["دعوو", "سامان", "سامان جو دعوو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ගමන\u{dca} මළ\u{dd4} හ\u{dd2}ම\u{dd2}කම\u{dca}"),
            keywords: &[
                "ගමන\u{dca} මළ\u{dd4}",
                "ගමන\u{dca} මළ\u{dd4} හ\u{dd2}ම\u{dd2}කම\u{dca}",
                "හ\u{dd2}ම\u{dd2}කම",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("výdaj batožiny"),
            keywords: &["batožina", "výdaj", "výdaj batožiny"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("prevzem prtljage"),
            keywords: &["prevzem", "prevzem prtljage", "prtljaga"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("boorso sheegasho"),
            keywords: &["boorso", "sheegasho"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("marrje bagazhesh"),
            keywords: &["bagazh", "marrje", "marrje bagazhesh"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("преузимање пртљага"),
            keywords: &["прeузимaњe", "преузимање пртљага", "пртљaг"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["преузимање пртљага"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("preuzimanje prtljaga"),
            keywords: &["preuzimanje", "preuzimanje prtljaga", "prtljag"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["preuzimanje prtljaga"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("bagagehämtning"),
            keywords: &["bagage", "bagagehämtning"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("madai ya mzigo"),
            keywords: &["dai", "madai ya mzigo", "mzigo"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("உடைமை பெறுமிடம\u{bcd}"),
            keywords: &[
                "உடைமை பெறுமிடம\u{bcd}",
                "பேக\u{bcd}கேஜ\u{bcd} வ\u{bbe}ங\u{bcd}குமிடம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("స\u{c3e}మ\u{c3e}ను త\u{c40}సుక\u{c4b}వడం"),
            keywords: &[
                "క\u{c4d}ల\u{c46}య\u{c3f}మ\u{c4d}",
                "లగ\u{c47}జ\u{c40}",
                "స\u{c3e}మ\u{c3e}ను త\u{c40}సుక\u{c4b}వడం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("гирифтани бағочҳо"),
            keywords: &["бағоч", "гирифтан", "гирифтани бағочҳо"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ร\u{e31}บส\u{e31}มภาระ"),
            keywords: &["กระเป\u{e4b}าเด\u{e34}นทาง", "ร\u{e31}บส\u{e31}มภาระ"],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("መበጻጽሒ ሳንጣ"),
            keywords: &["መበጻጽሒ", "መበጻጽሒ ሳንጣ", "ባልጃ/ሳንጣ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("goş almak"),
            keywords: &["almak", "goş"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("maʻuʻanga katoleta"),
            keywords: &["maʻuʻanga katoleta"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("bagaj teslim"),
            keywords: &["bagaj", "bagaj teslim"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("يۈك-تاق ئورنى"),
            keywords: &["ئېلىش", "يۈك-تاق", "يۈك-تاق ئورنى"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("видача багажу"),
            keywords: &["багаж", "видача", "видача багажу", "отримання"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("سامان کا کلیم"),
            keywords: &["سامان", "سامان کا کلیم", "کلیم"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("yuklarni olish joyi"),
            keywords: &["da’vo", "yuk", "yuklarni olish joyi"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("nơi nhận hành lý"),
            keywords: &["hành lý", "nhận", "nơi nhận hành lý"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("laajte say bagaas"),
            keywords: &["bagaas", "laajte", "laajte say bagaas"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ukulanda impahla"),
            keywords: &["impahla", "ukulanda"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("igba ẹru ẹni"),
            keywords: &["gba", "igba ẹru ẹni", "ẹrù"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("行李領取"),
            keywords: &["行李", "行李領取", "領取"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("行李领取"),
            keywords: &["行李", "行李领取", "领取"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("提取行李"),
            keywords: &["提取", "提取行李", "行李"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("提取行李"),
            keywords: &["提取行李"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ukulanda isikhwama"),
            keywords: &["isikhwama", "landa", "ukulanda isikhwama"],
        },
    ],
};
#[doc = "🛅"]
pub const LEFT_LUGGAGE: crate::Emoji = crate::Emoji {
    glyph: "🛅",
    codepoint: "1F6C5",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "left luggage",
    group: "Symbols",
    subgroup: "transport-sign",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("bagasiesluitkas"),
            keywords: &["bagasie", "bagasiesluitkas", "sluitkas"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የተረሳ ሻንጣ"),
            keywords: &["ሻንጣ", "ተቆላፊ የግድግዳ ሣጥን", "የተረሳ ሻንጣ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("أمتعة"),
            keywords: &["أمتعة", "خدمة حقائب السفر"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("য\u{9be}ত\u{9cd}ৰীয\u{9bc}ে এৰি যোৱ\u{9be} বয\u{9bc}-বস\u{9cd}ত\u{9c1}"),
            keywords: &[
                "বয\u{9bc}-বস\u{9cd}ত\u{9c1}",
                "ম\u{9be}ল-বস\u{9cd}ত\u{9c1}",
                "য\u{9be}ত\u{9cd}ৰীয\u{9bc}ে এৰি যোৱ\u{9be} বয\u{9bc}-বস\u{9cd}ত\u{9c1}",
                "লক\u{9be}ৰ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("saxlama kamerası"),
            keywords: &["baqaj", "saxlama kamerası", "yük", "şkaf"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("камера для хавання"),
            keywords: &["багаж", "камера", "камера для хавання", "хаванне", "шафа"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("съхранение на багаж"),
            keywords: &["багаж", "съхранение на багаж", "шкафче"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ম\u{9be}লপত\u{9cd}র ছেড\u{9bc}ে য\u{9be}ওয\u{9bc}\u{9be}"),
            keywords: &[
                "ব\u{9cd}য\u{9be}গেজ",
                "ম\u{9be}লপত\u{9cd}র ছেড\u{9bc}ে য\u{9be}ওয\u{9bc}\u{9be}",
                "লক\u{9be}র",
                "ল\u{9be}গেজ",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("fizlecʼh"),
            keywords: &["bagajoù", "fizlecʼh"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("garderoba"),
            keywords: &["garderoba", "ormar", "prtljag"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("consigna"),
            keywords: &[
                "armari",
                "consigna",
                "equipatge",
                "maletes",
                "servei de consigna",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᎦᏍᎦᏂ ᏕᎦᎸᏛᎢ"),
            keywords: &["ᎠᎦᏍᎦᏂ ᏕᎦᎸᏛᎢ", "ᎦᏅᏔᏅᏙᏗ", "ᏍᏓᏱ ᎠᏍᏚᏗ", "ᏕᎦᎸᏛᎢ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("úschovna zavazadel"),
            keywords: &[
                "odložení",
                "skříňky",
                "zavazadla",
                "úschova",
                "úschovna",
                "úschovna zavazadel",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("bagiau wedi’u gadael"),
            keywords: &["bagiau", "bagiau wedi’u gadael", "coffor"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("bagageopbevaring"),
            keywords: &["bagageopbevaring", "locker", "rejsegods"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Gepäckaufbewahrung"),
            keywords: &["Gepäck", "Gepäckaufbewahrung", "Schließfach"],
        },
        #[cfg(feature = "de_CH")]
        crate::Annotation {
            lang: "de_CH",
            tts: None,
            keywords: &["Gepäckaufbewahrung"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("φύλαξη αποσκευών"),
            keywords: &[
                "αποσκευές",
                "βαλίτσες",
                "ντουλάπι",
                "φοριαμός",
                "φύλαξη αποσκευών",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("left luggage"),
            keywords: &["baggage", "left luggage", "locker", "luggage"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("consigna"),
            keywords: &[
                "consigna",
                "depósito",
                "equipaje",
                "servicio de equipaje en depósito",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("depósito de equipaje"),
            keywords: &[
                "depósito",
                "depósito de equipaje",
                "equipaje",
                "locker",
                "señal",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["depósito de equipaje", "equipaje", "locker"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("hoiukapid"),
            keywords: &["hoiukapid", "kapp", "pagas"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("ahaztutako maletak"),
            keywords: &["ahaztutako maletak", "ekipaje", "maleta"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("امانت بار"),
            keywords: &["امانت", "بار", "چمدان"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("säilytyslokero"),
            keywords: &[
                "matkatavarat",
                "säilytys",
                "säilytyslokero",
                "tavarasäilytys",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("naiwang bagahe"),
            keywords: &["bagahe", "locker", "maleta", "naiwan", "naiwang bagahe"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("gloymt viðføri"),
            keywords: &["gloymt", "viðføri"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("consigne"),
            keywords: &["bagages", "consigne"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("consigne à bagages"),
            keywords: &["bagages", "consigne à bagages"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("bagáiste"),
            keywords: &["bagáiste", "seirbhís bhagáiste"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("bagaist air fhàgail"),
            keywords: &["bagaist", "bagaist air fhàgail", "preas", "trealaich"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("sinal de consigna"),
            keywords: &[
                "baixo chave",
                "consigna",
                "equipaxes",
                "maletas",
                "sinal de consigna",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("સામાન મ\u{ac2}કો"),
            keywords: &[
                "બ\u{ac5}ગ\u{ac7}જ",
                "બ\u{ac5}ગ\u{ac7}જ સ\u{ac7}વા",
                "સામાન",
                "સામાન મ\u{ac2}કો",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("wurin ajiye kaya"),
            keywords: &["kabad mai makulli", "kaya", "wurin ajiye kaya"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("שלט אחסון כבודה"),
            keywords: &["אחסון", "כבודה", "מזוודות", "שלט אחסון כבודה", "תיקים"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("छ\u{942}टा सामान"),
            keywords: &["छ\u{942}टा सामान", "ब\u{948}ग", "सामान", "सामान स\u{947}वा"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("odlaganje prtljage"),
            keywords: &["odlaganje", "odlaganje prtljage", "ormarići", "prtljaga"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("csomagmegőrző"),
            keywords: &["csomag", "csomagmegőrző", "megőrzés", "poggyász"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("մոռացված ուղեբեռ"),
            keywords: &["բեռ", "մոռացված ուղեբեռ", "ուղեբեռ", "պահարան"],
        },
        #[cfg(feature = "ia")]
        crate::Annotation {
            lang: "ia",
            tts: Some("deposito de bagage"),
            keywords: &["bagage", "consigna", "deposito", "deposito de bagage"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("koper tertinggal"),
            keywords: &[
                "bagasi",
                "barang tertinggal",
                "koper",
                "koper tertinggal",
                "loker",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ibu akaèkpè"),
            keywords: &["enwere", "ibu", "ibu akaèkpè", "mgbachi"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("farangursgeymsla"),
            keywords: &["farangur", "farangursgeymsla", "lás", "skápar"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("simbolo del deposito bagagli"),
            keywords: &[
                "bagagli",
                "deposito bagagli",
                "servizio bagagli",
                "simbolo del deposito bagagli",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("手荷物預かり"),
            keywords: &["スーツケース", "ロッカー", "手荷物", "手荷物預かり"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("koper ditinggal"),
            keywords: &["koper", "koper ditinggal", "loker"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("შემნახველი კამერა"),
            keywords: &["ბარგი", "კამერა", "შემნახველი კამერა"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("сақтау камерасы"),
            keywords: &["жолжүк", "жүк", "сақтау камерасы"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("hittegods"),
            keywords: &["baggage", "hittegods"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("សញ\u{17d2}ញាឥវ\u{17c9}ាន\u{17cb}ដែលភ\u{17d2}លេច"),
            keywords: &[
                "សញ\u{17d2}ញា",
                "សញ\u{17d2}ញាឥវ\u{17c9}ាន\u{17cb}ដែលភ\u{17d2}លេច",
                "ឥវ\u{17c9}ាន\u{17cb}ភ\u{17d2}លេច",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಲ\u{cc6}ಫ\u{ccd}ಟ\u{ccd} ಲಗೇಜ\u{ccd}"),
            keywords: &[
                "ಲ\u{cc6}ಫ\u{ccd}ಟ\u{ccd} ಲಗೇಜ\u{ccd}",
                "ಸರಕು",
                "ಸರಕು ಸೇವ\u{cc6}",
                "ಸಾಮಾನು",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("화물 서비스"),
            keywords: &["짐", "화물", "화물 서비스"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("उरिल\u{94d}ल\u{947}\u{902} सामान"),
            keywords: &["उरिल\u{94d}ल\u{947}\u{902} सामान", "लॉकर", "सामान"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("калтырылган жүк"),
            keywords: &["багаж", "бекитүү", "калтырылган жүк"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Gepäckschléissfach"),
            keywords: &["Casier", "Gepäck", "Gepäckschléissfach", "Schléissfach"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ບ\u{ecd}ລ\u{eb4}ການຝາກກະເປ\u{ebb}\u{ec8}າເດ\u{eb5}ນທາງ"),
            keywords: &[
                "ກະເປ\u{ebb}\u{ecb}າເດ\u{eb5}ນທາງ",
                "ບ\u{ecd}ລ\u{eb4}ການຝາກກະເປ\u{ebb}\u{ec8}າເດ\u{eb5}ນທາງ",
                "ຮ\u{eb1}ບຝາກ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("paliktas bagažas"),
            keywords: &["bagažas", "lagaminas", "paliktas bagažas", "spintelė"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("bagāžas glabātava"),
            keywords: &["bagāža", "bagāžas glabātava", "glabāt"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pāhi mahue"),
            keywords: &["pāhi", "pāhi mahue", "raraka"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("чување багаж"),
            keywords: &["багаж", "чување багаж", "шкафче"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഇടത\u{d4d} ലഗേജ\u{d4d}"),
            keywords: &[
                "ഇടത\u{d4d} ലഗേജ\u{d4d}",
                "ബ\u{d3e}ഗേജ\u{d4d}",
                "ലഗേജ\u{d4d}",
                "സർവീസ\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("орхисон тээш"),
            keywords: &["орхисон тээш", "орхих", "тээш"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("डावीकडच\u{947} सामान"),
            keywords: &["डावीकडच\u{947} सामान", "लॉकर", "सामान"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("bagasi tertinggal"),
            keywords: &["bagasi", "bagasi tertinggal", "lokar"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("bagalji mitlufa"),
            keywords: &["bagalji", "bagalji mitlufa", "loker"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ပစ\u{1039}စည\u{103a}းအပ\u{103a}ရန\u{103a}"),
            keywords: &[
                "ခရ\u{102e}းဆောင\u{103a}အ\u{102d}တ\u{103a}",
                "ခရ\u{102e}းဆောင\u{103a}အ\u{102d}တ\u{103a} အပ\u{103a}ရန\u{103a}ဌာန",
                "ခေတ\u{1039}တ ပစ\u{1039}စည\u{103a}းအပ\u{103a}ရန\u{103a} နေရာ",
                "ပစ\u{1039}စည\u{103a}းအပ\u{103a}ရန\u{103a}",
                "အထ\u{102f}ပ\u{103a}အပ\u{102d}\u{102f}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("bagasjeoppbevaring"),
            keywords: &[
                "bagasje",
                "bagasjeoppbevaring",
                "oppbevaring",
                "oppbevaringsboks",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("छाडिएको सामान"),
            keywords: &["छाडिएको सामान", "ब\u{94d}याग\u{947}ज", "लकर", "लग\u{947}ज"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("bagagekluis"),
            keywords: &["bagage", "bagagekluis", "bagageservice", "koffers"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("bagasjeoppbevaring"),
            keywords: &[
                "bagasje",
                "bagasjeoppbevaring",
                "oppbevaring",
                "oppbevaringsboks",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଛ\u{b3e}ଡ\u{b3c}\u{b3f}ଥ\u{b3f}ବ\u{b3e} ଜ\u{b3f}ନ\u{b3f}ଷପତ\u{b4d}ର"),
            keywords: &[
                "ଛ\u{b3e}ଡ\u{b3c}\u{b3f}ଥ\u{b3f}ବ\u{b3e} ଜ\u{b3f}ନ\u{b3f}ଷପତ\u{b4d}ର",
                "ଜ\u{b3f}ନ\u{b3f}ଷପତ\u{b4d}ର",
                "ମ\u{b3e}ଲପତ\u{b4d}ର",
                "ଲକର\u{b4d}\u{200c}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਛ\u{a71}ਡਿਆ ਹ\u{a4b}ਇਆ ਸਾਮਾਨ"),
            keywords: &[
                "ਛ\u{a71}ਡਿਆ ਸਾਮਾਨ",
                "ਛ\u{a71}ਡਿਆ ਹ\u{a4b}ਇਆ ਸਾਮਾਨ",
                "ਲਾਕਰ",
                "ਸਾਮਾਨ",
                "ਸਾਮਾਨ ਸ\u{a47}ਵਾ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("کھبا سفری سامان"),
            keywords: &[
                "سازو سامان",
                "سفری سامان",
                "قفل دار تجوری",
                "کھبا سفری سامان",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Lọ\u{301}gej Wé Pípol Lív Bihaind"),
            keywords: &["Bágej", "Lọ\u{301}gej", "Lọ\u{301}gej Wé Pípol Lív Bihaind"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("przechowalnia bagażu"),
            keywords: &[
                "kluczyk",
                "pozostawiony bagaż",
                "przechowalnia bagażu",
                "walizka",
                "zamknięcie",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("پاتې سامانونو"),
            keywords: &["توخه", "سامان", "پاتې سامان", "پاتې سامانونو", "کلپ خانه"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("depósito de bagagem"),
            keywords: &[
                "bagagem",
                "depósito de bagagem",
                "malas",
                "serviço de bagagem",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("depósito de bagagem"),
            keywords: &["bagagem", "cacifo", "depósito de bagagem"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("lluqsina qipikuna"),
            keywords: &["harkaq", "lluqsina qipikuna", "qipi", "qipikuna"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("depozitare bagaje"),
            keywords: &["bagaje", "depozitare bagaje", "dulap", "valize"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-985"),
            keywords: &["E10-985"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("забытый багаж"),
            keywords: &["багаж", "забытый багаж", "кабинка", "потерянный багаж"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ibikapu byabuze ba nyirabyo"),
            keywords: &[
                "ahabikwa imizigo",
                "ibikapu byabuze ba nyirabyo",
                "imizigo",
                "umuzigo",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڇڏيل سامان"),
            keywords: &["سامان", "لاڪر", "ڇڏيل سامان"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ගමන\u{dca} මළ\u{dd4} දම\u{dcf} ය\u{dcf}ම"),
            keywords: &[
                "ගමන\u{dca} මල\u{dca}ල",
                "ගමන\u{dca} මළ\u{dd4} දම\u{dcf} ය\u{dcf}ම",
                "මල\u{dca}ල",
                "ලොකර\u{dca}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("úschovňa batožiny"),
            keywords: &["batožina", "tašky", "úschovňa", "úschovňa batožiny"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("prtljaga v garderobi"),
            keywords: &["kovčki", "omarica", "prtljaga", "prtljaga v garderobi"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("ka tagid cafash"),
            keywords: &["boorso", "cafash", "ka tagid cafash", "sanduuq"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("bagazh i lënë"),
            keywords: &["bagazh", "bagazh i lënë", "dollap", "kyç"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("остављени пртљаг"),
            keywords: &["oрмaрић", "остављени пртљаг", "пртљaг", "пртљаг"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["остављени пртљаг"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("ostavljeni prtljag"),
            keywords: &["ormarić", "ostavljeni prtljag", "prtljag"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["ostavljeni prtljag"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("kvarlämnat bagage"),
            keywords: &["bagage", "bagageservice", "kvarlämnat bagage"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mahali pa kuhifadhi mizigo"),
            keywords: &["hifadhi", "mahali pa kuhifadhi mizigo", "mzigo"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("உடைமை விடுமிடம\u{bcd}"),
            keywords: &[
                "உடைமை விடுமிடம\u{bcd}",
                "பேக\u{bcd}கேஜ\u{bcd} விடும\u{bcd} இடம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("వద\u{c3f}ల\u{c3f}వ\u{c47}స\u{c3f}న స\u{c3e}మ\u{c3e}ను"),
            keywords: &[
                "లగ\u{c47}జ\u{c40}",
                "వద\u{c3f}ల\u{c3f}వ\u{c47}స\u{c3f}న స\u{c3e}మ\u{c3e}ను",
                "స\u{c3e}మ\u{c3e}గ\u{c4d}ర\u{c3f}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("бағочҳои боқимонда"),
            keywords: &["бағоч", "бағочхона", "бағочҳои боқимонда"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("บร\u{e34}การฝากกระเป\u{e4b}า"),
            keywords: &[
                "กระเป\u{e4b}า",
                "บร\u{e34}การฝากกระเป\u{e4b}า",
                "ร\u{e31}บฝาก",
                "ล\u{e47}อกเกอร\u{e4c}",
            ],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ጸጋማይ ሳንጣ"),
            keywords: &["መዕጸዊ", "ሳንጣ", "ባልጃ", "ጸጋማይ ሳንጣ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("galdyrylan goş"),
            keywords: &["bagaž", "galdyrylan goş", "goş", "saklanýan ýer"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("toloa katoleta"),
            keywords: &["toloa katoleta"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("eşya emanet"),
            keywords: &["bagaj", "bagaj hizmeti", "eşya emanet"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("قالدۇق يۈك-تاق"),
            keywords: &["ئىشكاپ", "سومكا", "قالدۇق يۈك-تاق", "يۈك-تاق"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("камера схову"),
            keywords: &[
                "багаж",
                "залишені речі",
                "камера схову",
                "комірка для зберігання",
                "поклажа",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("چ\u{64f}ھوٹا ہوا سامان"),
            keywords: &["سامان", "لاکر", "محفوظ", "چ\u{64f}ھوٹا ہوا سامان"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("saqlash xonasida qoldirilgan yuk"),
            keywords: &[
                "bagaj",
                "saqlash xonasi",
                "saqlash xonasida qoldirilgan yuk",
                "yuk",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("hành lý bỏ quên"),
            keywords: &["hành lý", "hành lý bỏ quên", "tủ khóa"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("bagaas yiñ bàyyi"),
            keywords: &["bagaas", "bagaas yiñ bàyyi", "làkk", "tëjukaay"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("umthwalo wasekhohlo"),
            keywords: &["impahla", "isitshixo", "umthwalo wasekhohlo"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("fifi ẹru silẹ"),
            keywords: &["fifi ẹru silẹ", "àtìpa", "ẹrù"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("行李寄存"),
            keywords: &["寄存", "行李", "行李寄存"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("行李寄存"),
            keywords: &["寄存", "行李", "行李寄存"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("寄存行李"),
            keywords: &["寄存", "寄存行李", "行李"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("寄存行李"),
            keywords: &["寄存行李", "寄物"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("寄存行李"),
            keywords: &["寄存行李"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("impahla esele"),
            keywords: &["impahla", "impahla esele", "indawo ekhiywayo", "umthwalo"],
        },
    ],
};
