#[doc = "🛐"]
pub const PLACE_OF_WORSHIP: crate::Emoji = crate::Emoji {
    glyph: "🛐",
    codepoint: "1F6D0",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "place of worship",
    group: "Symbols",
    subgroup: "religion",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("plek van aanbidding"),
            keywords: &["aanbidding", "godsdiens", "plek van aanbidding"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የአምልኮ ቦታ"),
            keywords: &["ማምለክ", "ኃይማኖት", "የአምልኮ ቦታ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("مكان عبادة"),
            keywords: &["دين", "عبادة", "مصلى", "مكان عبادة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("উপ\u{9be}সন\u{9be}ৰ ঠ\u{9be}ই"),
            keywords: &[
                "উপ\u{9be}সন\u{9be}",
                "উপ\u{9be}সন\u{9be}ৰ ঠ\u{9be}ই",
                "ধৰ\u{9cd}ম",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("tapınaq"),
            keywords: &["din", "tapınaq", "tapınmaq"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("культавае памяшканне"),
            keywords: &["культ", "культавае памяшканне", "пакланенне", "рэлігія"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("място за религиозно преклонение"),
            keywords: &["място за религиозно преклонение", "преклонение", "религия"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("উপ\u{9be}সন\u{9be}র স\u{9cd}থ\u{9be}ন"),
            keywords: &[
                "উপ\u{9be}সন\u{9be}র স\u{9cd}থ\u{9be}ন",
                "ধর\u{9cd}ম",
                "প\u{9c2}জ\u{9be}",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("lec’h azeuliñ"),
            keywords: &["azeuliñ", "lec’h azeuliñ", "relijion"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("bogomolja"),
            keywords: &["bogomolja", "religija", "vjerovanje"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("lloc de culte"),
            keywords: &["culte", "lloc", "lloc de culte", "religió"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᏙᏢᏒ ᏧᏂᎳᏫᏍᏗᎢ"),
            keywords: &["ᎤᏃᎯᏳᏒᎢ", "ᎤᏙᏢᏒ ᏧᏂᎳᏫᏍᏗᎢ", "ᏧᏂᎳᏫᏍᏗᎢ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("modlitebna"),
            keywords: &["modlitebna", "náboženství", "svatostánek", "víra"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("man addoli"),
            keywords: &["addoli", "crefydd", "man addoli"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("bedested"),
            keywords: &["bedested", "bøn", "religion"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("religiöse Stätte"),
            keywords: &["Religion", "religiöse Stätte"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("τόπος λατρείας"),
            keywords: &["θρησκεία", "λατρεία", "τόπος λατρείας"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("place of worship"),
            keywords: &["place of worship", "religion", "worship"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("lugar de culto"),
            keywords: &["culto", "lugar de culto", "religión"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &[
                "lugar",
                "lugar de culto",
                "lugar de oración",
                "oración",
                "religión",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("pühakoda"),
            keywords: &["palvetamine", "pühakoda", "usk"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("otoizlekua"),
            keywords: &["erlijio", "otoitz", "otoizlekua"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("محل عبادت"),
            keywords: &["عبادت", "محل عبادت", "مذهب"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("pyhä rakennus"),
            keywords: &[
                "palvonta",
                "palvontapaikka",
                "pyhä rakennus",
                "pyhäkkö",
                "uskonto",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("sambahan"),
            keywords: &["pagsamba", "relihiyon", "sambahan", "simbahan"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("bønarstað"),
            keywords: &["bøn", "bønarstað", "religión", "trúgv", "átrúnaður"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("lieu de culte"),
            keywords: &["culte", "lieu de culte", "religion"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["culte", "lieu de culte", "religion"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("teach adhartha"),
            keywords: &["adhartha", "creideamh", "teach adhartha"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("àite-adhraidh"),
            keywords: &["adhradh", "creideamh", "àite-adhraidh"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("sinal de lugar de culto"),
            keywords: &["culto", "oración", "relixión", "sinal de lugar de culto"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("આરાધના સ\u{acd}થળ"),
            keywords: &["આરાધના સ\u{acd}થળ", "ધર\u{acd}મ", "પ\u{acd}રાર\u{acd}થના"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("wurin Ibada"),
            keywords: &["addini", "ibada", "wurin Ibada"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("בית תפילה"),
            keywords: &["בית תפילה", "דת", "תפילה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("प\u{942}जा स\u{94d}थल"),
            keywords: &[
                "आराधना स\u{94d}थल",
                "आराधना स\u{94d}थल, प\u{942}जा",
                "धर\u{94d}म",
                "प\u{942}जा",
                "प\u{942}जा स\u{94d}थल",
                "प\u{94d}रार\u{94d}थना",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("mjesto za bogoslužje"),
            keywords: &["bogoslužje", "mjesto za bogoslužje", "religija"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("imahely"),
            keywords: &["ima", "imahely", "vallás"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("աղոթատեղի"),
            keywords: &["աղոթատեղի", "կրոն", "պաշտամունք"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("tempat ibadah"),
            keywords: &["agama", "pemujaan", "tempat ibadah"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ebe nke okpukperechi"),
            keywords: &["ebe nke okpukperechi", "okpukperechi", "òfùfè"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("tilbeiðslustaður"),
            keywords: &["tilbeiðsla", "tilbeiðslustaður", "trúarbrögð"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("luogo di culto"),
            keywords: &[
                "luogo di culto",
                "luogo di preghiera",
                "luogo sacro",
                "pregare",
                "preghiera",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("礼拝所"),
            keywords: &["宗教", "礼拝所", "祈り"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("papan sembahyang"),
            keywords: &["agama", "papan sembahyang", "sembahyang"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("სალოცავი ადგილი"),
            keywords: &["ლოცვა", "რელიგია", "სალოცავი ადგილი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("табыну орны"),
            keywords: &["дін", "табыну", "табыну орны"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("bedested"),
            keywords: &["bedested", "bøn", "religion"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("សញ\u{17d2}ញាកន\u{17d2}លែងថ\u{17d2}វាយបង\u{17d2}គ\u{17c6}"),
            keywords: &[
                "ថ\u{17d2}វាយបង\u{17d2}គ\u{17c6}",
                "សញ\u{17d2}ញា",
                "សញ\u{17d2}ញាកន\u{17d2}លែងថ\u{17d2}វាយបង\u{17d2}គ\u{17c6}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಪ\u{cc2}ಜಾ ಸ\u{ccd}ಥಳ"),
            keywords: &[
                "ಕಾರ\u{ccd}ಯ",
                "ಕ\u{cc6}ಲಸ",
                "ಪ\u{cc2}ಜಾ ಸ\u{ccd}ಥಳ",
                "ಸಂಬಂಧ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("예배공간"),
            keywords: &["기도", "사원", "예배", "예배공간"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("प\u{94d}रार\u{94d}थन\u{947}ची स\u{941}वात"),
            keywords: &[
                "धर\u{94d}म",
                "प\u{94d}रार\u{94d}थना",
                "प\u{94d}रार\u{94d}थन\u{947}ची स\u{941}वात",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("ыйык жер"),
            keywords: &["дин", "ыйык", "ыйык жер"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Gotteshaus"),
            keywords: &["Gotteshaus", "Relioun", "Veréierung"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ສະຖານທ\u{eb5}\u{ec8}ບ\u{eb9}ຊາ"),
            keywords: &[
                "ບ\u{eb9}ຊາ",
                "ສະຖານທ\u{eb5}\u{ec8}",
                "ສະຖານທ\u{eb5}\u{ec8}ບ\u{eb9}ຊາ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("garbinimo vieta"),
            keywords: &["garbinimo vieta", "garbinti", "religija"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("lūgšanu vieta"),
            keywords: &["lūgšanas", "lūgšanu vieta", "reliģija"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("wāhi karakia"),
            keywords: &["karakia", "momo karakia", "wāhi karakia"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("место за богослужба"),
            keywords: &["богослужба", "место за богослужба", "религија"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ആര\u{d3e}ധന\u{d3e}ലയം"),
            keywords: &[
                "ആര\u{d3e}ധന\u{d3e}ലയം",
                "പ\u{d4d}ര\u{d3e}ർത\u{d4d}ഥന",
                "മതം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("мөргөлийн газар"),
            keywords: &["мөргөл", "мөргөлийн газар", "шашин"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("प\u{942}जा करण\u{94d}\u{200d}याच\u{947} स\u{94d}थान"),
            keywords: &[
                "धर\u{94d}म",
                "प\u{942}जा",
                "प\u{942}जा करण\u{94d}\u{200d}याच\u{947} स\u{94d}थान",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("tempat ibadat"),
            keywords: &["agama", "ibadah", "tempat ibadat"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("post ta’ qima"),
            keywords: &["post ta’ qima", "qima", "reliġjon"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဝတ\u{103a}ပြ\u{102f}ရာနေရာ"),
            keywords: &[
                "ဘာသာရေး",
                "ဝတ\u{103a}ပြ\u{102f}ခြင\u{103a}း",
                "ဝတ\u{103a}ပြ\u{102f}ရန\u{103a}နေရာ",
                "ဝတ\u{103a}ပြ\u{102f}ရာနေရာ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("religiøst samlingssted"),
            keywords: &["religion", "religiøst samlingssted", "tilbedelse"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("प\u{942}जा गर\u{94d}न\u{947} ठाउ\u{901}"),
            keywords: &[
                "धर\u{94d}म",
                "प\u{942}जा गर\u{94d}न\u{947}",
                "प\u{942}जा गर\u{94d}न\u{947} ठाउ\u{901}",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("gebedsruimte"),
            keywords: &["bidden", "gebedsruimte", "religie"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("religiøs samlingsstad"),
            keywords: &["religion", "religiøs samlingsstad", "tilbeding"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ପ\u{b42}ଜ\u{b3e} ସ\u{b4d}ଥ\u{b3e}ନ"),
            keywords: &[
                "ଧର\u{b4d}ମ",
                "ପ\u{b42}ଜ\u{b3e} କର\u{b3f}ବ\u{b3e}",
                "ପ\u{b42}ଜ\u{b3e} ସ\u{b4d}ଥ\u{b3e}ନ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਭਗਤੀ ਕਰਨ ਦੀ ਥਾ\u{a02}"),
            keywords: &["ਧਰਮ", "ਭਗਤੀ", "ਭਗਤੀ ਕਰਨ ਦੀ ਥਾ\u{a02}", "ਭਗਤੀ ਕਰਨਾ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("عبادت دی تھاں"),
            keywords: &["عبادت", "عبادت دی تھاں", "مذہب"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Ples Wiá Pípul De Prè"),
            keywords: &["Ples Wiá Pípul De Prè", "Prè", "Rilíjọn"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("miejsce kultu"),
            keywords: &[
                "kościół",
                "kult",
                "miejsce kultu",
                "modlitwa",
                "religia",
                "świątynia",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د عبادت ځای"),
            keywords: &["د عبادت ځای", "عبادت", "مذهب"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("local de culto"),
            keywords: &["culto", "local de culto", "religião"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("local de culto"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("muchʼay kiti"),
            keywords: &["muchʼay kiti", "munaynin", "religion"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("lăcaș de cult"),
            keywords: &["cult", "lăcaș", "lăcaș de cult", "religie"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-991"),
            keywords: &["E10-991"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("религия"),
            keywords: &[
                "место",
                "место поклонения",
                "поклонение",
                "религия",
                "святое",
                "святыня",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("aho bashengerera"),
            keywords: &["aho bashengerera", "iyobokamana", "kuramya"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("عبادت جي جڳھ"),
            keywords: &["عبادت", "عبادت جي جڳھ", "مذهب"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ප\u{dd6}ජන\u{dd3}ය ස\u{dca}ථ\u{dcf}නය"),
            keywords: &[
                "ආගම",
                "ප\u{dd6}ජන\u{dd3}ය ස\u{dca}ථ\u{dcf}නය",
                "වැඳ\u{dd3}ම",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("modlitebné miesto"),
            keywords: &["bohoslužba", "modlitba", "modlitebné miesto", "náboženstvo"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("božji hram"),
            keywords: &["božji hram", "vera", "čaščenje"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("goobta cibaadada"),
            keywords: &["caabudid", "diin", "goobta cibaadada"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("vend kulti"),
            keywords: &["adhuroj", "falem", "fe", "vend kulti"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("верски објекат"),
            keywords: &["верски објекат", "рeлигиja", "светилиште"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("вјерски објекат"),
            keywords: &["вјерски објекат"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("verski objekat"),
            keywords: &["religija", "svetilište", "verski objekat"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("vjerski objekat"),
            keywords: &["vjerski objekat"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("plats för tillbedjan"),
            keywords: &["plats för tillbedjan", "religion", "tempel", "tillbedjan"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mahali pa kuabudu"),
            keywords: &["abudu", "dini", "mahali pa kuabudu"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("வழிபடும\u{bcd} இடம\u{bcd}"),
            keywords: &[
                "பிர\u{bbe}ர\u{bcd}த\u{bcd}தனை",
                "மதம\u{bcd}",
                "வழிபடும\u{bcd} இடம\u{bcd}",
                "வழிபடும\u{bcd} தலம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ప\u{c4d}ర\u{c3e}ర\u{c4d}థన\u{c3e} స\u{c4d}థలం"),
            keywords: &[
                "ప\u{c4d}ర\u{c3e}ర\u{c4d}థన",
                "ప\u{c4d}ర\u{c3e}ర\u{c4d}థన\u{c3e} స\u{c4d}థలం",
                "మతం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("ҷои ибодат"),
            keywords: &["дин", "ибодат", "ҷои ибодат"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ท\u{e35}\u{e48}บ\u{e39}ชา"),
            keywords: &[
                "ท\u{e35}\u{e48}บ\u{e39}ชา",
                "บ\u{e39}ชา",
                "ศาสนา",
                "ส\u{e31}กการะ",
            ],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ናይ ኣምልኾ ቦታ"),
            keywords: &["ናይ ኣምልኾ ቦታ", "ኣምልኾ", "እምነት"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ybadat ýeri"),
            keywords: &["din", "ybadat", "ybadat ýeri"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("feituʻu faiʻanga lotu"),
            keywords: &["feituʻu", "feituʻu faiʻanga lotu", "lotu"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("ibadethane"),
            keywords: &["din", "ibadethane", "tapınma"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئىبادەتخانا"),
            keywords: &["ئىبادەتخانا", "ئېتىقاد", "دىن"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("культова споруда"),
            keywords: &[
                "культова споруда",
                "молитовний дім",
                "поклоніння",
                "релігія",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("عبادت گاہ"),
            keywords: &["جگہ", "عبادت", "عبادت گاہ", "مذہب"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("ibodatxona"),
            keywords: &["din", "ibodatxona"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("nơi thờ phụng"),
            keywords: &["nơi thờ phụng", "tôn giáo", "tôn sùng"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("barabu jaamukaay"),
            keywords: &["barabu jaamukaay", "diine", "jaamu"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("indawo yokunqula"),
            keywords: &["indawo yokunqula", "ukunqula", "unqulo"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("ibi ijọsin"),
            keywords: &["ibi ijọsin", "ìjó\u{329}sìn", "ẹ\u{300}sìn"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("宗教場所"),
            keywords: &["場所", "宗教", "宗教場所"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("宗教场所"),
            keywords: &["场所", "宗教", "宗教场所"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("宗教场所"),
            keywords: &["地点", "宗教场所", "礼拜", "祈祷"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("祈禱"),
            keywords: &["祈禱", "祝禱"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("祈禱室符號"),
            keywords: &["祈禱", "祈禱室", "祈禱室符號"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("indawo yokukhonza"),
            keywords: &["indawo yokukhonza", "inkolo", "ukukhonza"],
        },
    ],
};
#[doc = "⚛\u{fe0f}"]
pub const ATOM_SYMBOL: crate::Emoji = crate::Emoji {
    glyph: "⚛\u{fe0f}",
    codepoint: "269B FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "atom symbol",
    group: "Symbols",
    subgroup: "religion",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "⚛",
        codepoint: "269B",
        status: crate::Status::Unqualified,
        introduction_version: 1f32,
        name: "atom symbol",
        group: "Symbols",
        subgroup: "religion",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("atoomsimbool"),
            keywords: &["ateïs", "atoom", "atoomsimbool"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የአቶም ምልክት"),
            keywords: &["መናፍቅ", "አተም", "የአቶም ምልክት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("نووي"),
            keywords: &["إلحاد", "نواة", "نووي"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("পৰম\u{9be}ণ\u{9c1} চিহ\u{9cd}ন"),
            keywords: &[
                "ন\u{9be}স\u{9cd}তিক",
                "পৰম\u{9be}ণ\u{9c1}",
                "পৰম\u{9be}ণ\u{9c1} চিহ\u{9cd}ন",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("atom simvolu"),
            keywords: &["ateist", "atom", "atom simvolu"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("сімвал атама"),
            keywords: &["атам", "атэізм", "сімвал атама", "фізіка"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("символ на атом"),
            keywords: &["атеист", "атом", "символ на атом"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("কণিক\u{9be}র চিহ\u{9cd}ন"),
            keywords: &[
                "কণিক\u{9be}র চিহ\u{9cd}ন",
                "ন\u{9be}স\u{9cd}তিক",
                "পরম\u{9be}ণ\u{9c1}",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("arouez an atom"),
            keywords: &["arouez an atom", "atom", "dizoue"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("simbol atoma"),
            keywords: &["ateista", "atom", "simbol atoma"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("símbol d’àtom"),
            keywords: &["ateisme", "ateu", "símbol", "símbol d’àtom", "àtom"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎢᎦᏓ ᎪᏪᎸ"),
            keywords: &["ᎢᎦᏓ", "ᎢᎦᏓ ᎪᏪᎸ", "ᏄᏬᎯᏳᏒᎾ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("symbol atomu"),
            keywords: &["ateismus", "atom", "symbol atomu"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("symbol o atom"),
            keywords: &["anffyddiwr", "atom", "symbol o atom"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("atomsymbol"),
            keywords: &["ateist", "atom", "atomsymbol"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Atomzeichen"),
            keywords: &["Atheist", "Atom", "Atomzeichen"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("σύμβολο ατόμου"),
            keywords: &["άθεος", "άτομο", "σύμβολο ατόμου"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("atom symbol"),
            keywords: &["atheist", "atom", "atom symbol"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("símbolo de átomo"),
            keywords: &["símbolo", "símbolo de átomo", "átomo"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["ateo", "símbolo atómico", "símbolo de átomo", "átomo"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("aatomi sümbol"),
            keywords: &["aatom", "aatomi sümbol", "ateist"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("atomoaren ikurra"),
            keywords: &["ateista", "atomo", "atomoaren ikurra"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("نماد اتم"),
            keywords: &["اتم", "بی\u{200c}دین", "نماد اتم"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("atomi"),
            keywords: &["ateisti", "atomi"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("atom"),
            keywords: &["agham", "atom", "siyensya"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("atom symbol"),
            keywords: &[
                "ateistur",
                "atom",
                "atom symbol",
                "gudloysingur",
                "gudsnoktari",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("symbole de l’atome"),
            keywords: &["athée", "atome", "symbole de l’atome"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("siombail adaimh"),
            keywords: &["adamh", "aindiachaí", "siombail adaimh", "siombal adamh"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("samhla ataim"),
            keywords: &[
                "atam",
                "eas-creideach",
                "eas-creidmheach",
                "neo-dhiadhaire",
                "samhla ataim",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("símbolo atómico"),
            keywords: &["ateísmo", "símbolo atómico", "átomo"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("અણ\u{ac1}ન\u{ac1}\u{a82} પ\u{acd}રતીક"),
            keywords: &["અણ\u{ac1}", "અણ\u{ac1}ન\u{ac1}\u{a82} પ\u{acd}રતીક"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("alamar ƙwayar zarra"),
            keywords: &["alamar ƙwayar zarra", "kafiri", "ƙwayar zarra"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("סמל האטום"),
            keywords: &["אטום", "אתאיזם", "אתאיסט", "סמל האטום"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("अण\u{941} चिह\u{94d}न"),
            keywords: &["अण\u{941} चिह\u{94d}न", "नास\u{94d}तिक"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("simbol atoma"),
            keywords: &["ateizam", "atom", "simbol atoma"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("atom szimbólum"),
            keywords: &["ateista", "atom", "atom szimbólum"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ատոմի նշան"),
            keywords: &["աթեիստ", "ատոմ", "ատոմի նշան"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("simbol atom"),
            keywords: &["ateis", "atom", "simbol atom"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("Ọdịmara atọm"),
            keywords: &["atọm", "onye ekweghị na Chukwu", "Ọdịmara atọm"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("frumeindartákn"),
            keywords: &["frumeind", "frumeindartákn", "trúleysingi"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("simbolo dell’atomo"),
            keywords: &["ateismo", "atomo", "simbolo dell’atomo"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("原子のシンボル"),
            keywords: &["元素", "分子", "原子", "原子のシンボル", "無神論"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("tandha atom"),
            keywords: &["ateis", "atom", "tandha atom"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ატომის სიმბოლო"),
            keywords: &["ათეისტი", "ატომი", "ატომის სიმბოლო"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("атом белгісі"),
            keywords: &["атеист", "атом", "атом белгісі"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("atomsymbol"),
            keywords: &["ateist", "atom", "atomsymbol"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("សញ\u{17d2}ញាអាត\u{17bc}ម"),
            keywords: &["សញ\u{17d2}ញា", "សញ\u{17d2}ញាអាត\u{17bc}ម", "អាត\u{17bc}ម"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಪರಮಾಣು ಚ\u{cbf}ಹ\u{ccd}ನ\u{cc6}"),
            keywords: &["ಆಟಮ\u{ccd}", "ಚ\u{cbf}ಹ\u{ccd}ನ\u{cc6}", "ಪರಮಾಣು"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("원자 기호"),
            keywords: &["원자", "원자 기호"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("अण\u{942} चिन\u{94d}न"),
            keywords: &[
                "अण\u{942}",
                "अण\u{942} चिन\u{94d}न",
                "अथ\u{947}यस\u{94d}ट",
                "नास\u{94d}तिक",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("атом символу"),
            keywords: &["атесит", "атом", "атом символу"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Atomzeechen"),
            keywords: &["Atheist", "Atom", "Atomzeechen"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ສ\u{eb1}ນຍາລ\u{eb1}ກອາຕອມ"),
            keywords: &["ສ\u{eb1}ນຍາລ\u{eb1}ກ", "ສ\u{eb1}ນຍາລ\u{eb1}ກອາຕອມ", "ອາຕອມ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("atomo simbolis"),
            keywords: &["ateistas", "atomas", "atomo simbolis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("atoma simbols"),
            keywords: &["ateisms", "atoma simbols", "atoms"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tohu ngota"),
            keywords: &["kaiwhakakāhore-atua", "ngota", "tohu ngota"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("атом"),
            keywords: &["атеист", "атом"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ആറ\u{d4d}റം ചിഹ\u{d4d}നം"),
            keywords: &[
                "ആറ\u{d4d}റം",
                "ആറ\u{d4d}റം ചിഹ\u{d4d}നം",
                "നിരീശ\u{d4d}വരവ\u{d3e}ദി",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("атомын тэмдэг"),
            keywords: &["атом", "атомын тэмдэг", "шашингүй үзэлтэн"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("अण\u{942}च\u{947} चिन\u{94d}ह"),
            keywords: &[
                "अण\u{942}",
                "अण\u{942}च\u{947} चिन\u{94d}ह",
                "नास\u{94d}तिक",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("simbol atom"),
            keywords: &["ateis", "atom", "simbol atom"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("simbolu tal-atomu"),
            keywords: &["ateu", "atomu", "simbolu tal-atomu"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အဏ\u{102f}မြ\u{1030} သင\u{103a}\u{1039}ကေတ"),
            keywords: &[
                "ဘ\u{102f}ရားမ\u{1032}\u{1037}ဝါဒ\u{102e}",
                "အဏ\u{102f}မြ\u{1030}",
                "အဏ\u{102f}မြ\u{1030} သင\u{103a}\u{1039}ကေတ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("atomsymbol"),
            keywords: &["ateist", "atom", "atomsymbol"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("परमाण\u{941}को स\u{902}क\u{947}त"),
            keywords: &[
                "नास\u{94d}तिक",
                "परमाण\u{941}",
                "परमाण\u{941}को स\u{902}क\u{947}त",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("atoomsymbool"),
            keywords: &["atheïst", "atoom", "atoomsymbool"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("atomsymbol"),
            keywords: &["ateist", "atom", "atomsymbol"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ପରମ\u{b3e}ଣ\u{b41} ସଙ\u{b4d}କେତ"),
            keywords: &[
                "ନ\u{b3e}ସ\u{b4d}ତ\u{b3f}କ",
                "ପରମ\u{b3e}ଣ\u{b41}",
                "ପରମ\u{b3e}ଣ\u{b41} ସଙ\u{b4d}କେତ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਐਟਮ ਦਾ ਚਿ\u{a70}ਨ\u{a4d}ਹ"),
            keywords: &[
                "ਐਟਮ ਚਿ\u{a70}ਨ\u{a4d}ਹ",
                "ਐਟਮ ਦਾ ਚਿ\u{a70}ਨ\u{a4d}ਹ",
                "ਨਾਸਤਕ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ایٹم دی علامت"),
            keywords: &["ایٹم", "ایٹم دی علامت", "ملحد"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Átọ\u{301}m Símbul"),
            keywords: &[
                "Pẹ\u{301}sin Wé Bilív Sé Gọd Nọ\u{301} Dè",
                "Átọm",
                "Átọ\u{301}m Símbul",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("symbol atomu"),
            keywords: &["atom", "symbol atomu"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د ايټم سمبول"),
            keywords: &["ايټم", "د ايټم سمبول", "کافر"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("símbolo de átomo"),
            keywords: &["ateísmo", "símbolo de átomo", "átomo"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("símbolo do átomo"),
            keywords: &["ateísta", "símbolo do átomo"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("atomo unancha"),
            keywords: &["ateismo", "atomo", "atomo unancha"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("simbol pentru atom"),
            keywords: &["ateu", "atom", "simbol de atom", "simbol pentru atom"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-090"),
            keywords: &["E10-090"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("символ атома"),
            keywords: &["атеизм", "атом", "символ атома"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ikimenyetso cya atome"),
            keywords: &["atome", "ikimenyetso cya atome", "umuhakanyi"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ائٽم جي نشاني"),
            keywords: &["ائٽم جي نشاني", "ايٽم", "منڪر"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("පරම\u{dcf}ණ\u{dd4}වේ සංකේතය"),
            keywords: &[
                "අදේවව\u{dcf}ද\u{dd3}",
                "පරම\u{dcf}ණ\u{dd4}ව",
                "පරම\u{dcf}ණ\u{dd4}වේ සංකේතය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("symbol atómu"),
            keywords: &["atóm", "symbol atómu"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("simbol za atom"),
            keywords: &["ateist", "atom", "simbol za atom"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("calaamadda atam"),
            keywords: &["atam", "calaamadda atam", "diin laawe"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("simboli i atomit"),
            keywords: &["ateist", "atom", "simboli i atomit"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("симбол за атом"),
            keywords: &["aтeизaм", "aтoм", "симбол за атом"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("simbol za atom"),
            keywords: &["ateizam", "atom", "simbol za atom"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("symbol för atom"),
            keywords: &["ateist", "atom", "naturvetenskap", "symbol för atom"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("alama ya atomu"),
            keywords: &["alama ya atomu", "asiyemwamini Mungu", "atomu"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("அணுச\u{bcd} சின\u{bcd}னம\u{bcd}"),
            keywords: &["அணுச\u{bcd} சின\u{bcd}னம\u{bcd}", "கோலம\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("అణువు"),
            keywords: &["అణువు", "న\u{c3e}స\u{c4d}త\u{c3f}కుడు"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("аломати \"атом\""),
            keywords: &["аломати \"атом\"", "атеист", "атом"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("อะตอม"),
            keywords: &["อะตอม", "อเทวน\u{e34}ยม"],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ናይ ኣቶም ኣርማ"),
            keywords: &["ናይ ኣቶም ኣርማ", "ኣቴስት", "ኣቶም"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("atom nyşany"),
            keywords: &["ateist", "atom", "atom nyşany"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("ʻātomi"),
            keywords: &["taʻelotu", "ʻilonga", "ʻātomi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("atom sembolü"),
            keywords: &["ateist", "atom", "atom sembolü"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئاتوم بەلگىسى"),
            keywords: &["ئاتوم", "ئاتوم بەلگىسى", "ئاتېزىم"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("символ атома"),
            keywords: &["атеїст", "атом", "символ атома"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ایٹم کی علامت"),
            keywords: &["ایٹم", "ایٹم کی علامت", "لادین"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("atom belgisi"),
            keywords: &["ateist", "atom", "atom belgisi"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("biểu tượng nguyên tử"),
            keywords: &["biểu tượng nguyên tử", "nguyên tử", "người vô thần"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("màndarga atom"),
            keywords: &["atom", "màndarga atom", "yéefar"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("isimboli yeatom"),
            keywords: &["iatom", "isimboli yeatom", "umntu ongakholwayo kuThixo"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("àmì átọ\u{301}mù"),
            keywords: &["aláìgbàgbó\u{329}", "àmì átọ\u{301}mù", "átọ\u{301}mù"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("原子符號"),
            keywords: &["原子", "原子符號", "無神論者"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("原子符号"),
            keywords: &["原子", "原子符号", "无神论者"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("原子符号"),
            keywords: &["原子符号", "无神论", "物质"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("原子"),
            keywords: &["原子"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("原子符號"),
            keywords: &["原子", "原子符號"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("uphawu lokungakhonzi"),
            keywords: &["ongakholwa", "ukungakhonzi", "uphawu lokungakhonzi"],
        },
    ],
};
#[doc = "🕉\u{fe0f}"]
pub const OM: crate::Emoji = crate::Emoji {
    glyph: "🕉\u{fe0f}",
    codepoint: "1F549 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.7f32,
    name: "om",
    group: "Symbols",
    subgroup: "religion",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🕉",
        codepoint: "1F549",
        status: crate::Status::Unqualified,
        introduction_version: 0.7f32,
        name: "om",
        group: "Symbols",
        subgroup: "religion",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("om"),
            keywords: &["Hindoe", "godsdiens", "om"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ኦኤም"),
            keywords: &["ሂንዱ", "ኃይማኖት", "ኦኤም"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("دين هندوسي"),
            keywords: &["دين", "هندوسي"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ঔ\u{981}ম"),
            keywords: &["ঔ\u{981}ম", "ধৰ\u{9cd}ম", "হিন\u{9cd}দ\u{9c1}"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("om"),
            keywords: &["din", "hindu", "om"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("ом"),
            keywords: &["мантра", "ом", "рэлігія", "індуізм"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("ом"),
            keywords: &["ом", "религия", "хиндуизъм"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ওম"),
            keywords: &["ওম", "ধর\u{9cd}ম", "হিন\u{9cd}দ\u{9c1}"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("om"),
            keywords: &["hindou", "om", "relijion"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("simbol om"),
            keywords: &["hindu", "religija", "simbol om"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("símbol d’om"),
            keywords: &["hinduisme", "hindú", "om", "religió", "símbol d’om"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎣᎹ"),
            keywords: &["ᎣᎹ", "ᎯᏚᎯ", "ᏚᎾᏁᏟᏛ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("óm"),
            keywords: &["hinduismus", "náboženství", "óm"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("om"),
            keywords: &["crefydd", "hindŵ", "om"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("om"),
            keywords: &["hindu", "om", "religion"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("om"),
            keywords: &["Hinduismus", "Religion", "om"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("σύμβολο ομ"),
            keywords: &["θρησκεία", "ινδουιστικό", "σύμβολο ομ"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("om"),
            keywords: &["Hindu", "om", "religion"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: None,
            keywords: &["Hindu", "aum", "om", "religion"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("om"),
            keywords: &["hindú", "om", "religión"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("hinduism"),
            keywords: &["hindu", "hinduism", "usk"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("om"),
            keywords: &["erlijio", "hindu", "om"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("ا\u{64f}م"),
            keywords: &["ا\u{64f}م", "مذهب", "هندو"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("om-tavu"),
            keywords: &[
                "hindu",
                "hindulaisuus",
                "om-tavu",
                "symboli",
                "tavu",
                "uskonto",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("om"),
            keywords: &["Hindu", "india", "om", "relihiyon"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("aúm"),
            keywords: &["aúm", "hindui", "om", "religión", "trúgv", "átrúnaður"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("om"),
            keywords: &["hindou", "om", "religion"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("om"),
            keywords: &["creideamh", "hiondúch", "om"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("om"),
            keywords: &["creideamh", "hindu", "om"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("símbolo de om"),
            keywords: &["hinduísmo", "om", "relixión", "símbolo de om"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ૐ"),
            keywords: &["ધર\u{acd}મ", "હિન\u{acd}દ\u{ac1}", "ૐ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("om"),
            keywords: &["Hindu", "addini", "om"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("אום"),
            keywords: &["אום", "דת", "הינדו", "הינדי"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ॐ"),
            keywords: &["ओम", "धर\u{94d}म", "हि\u{902}द\u{942}", "ॐ"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("om"),
            keywords: &["hinduizam", "om", "religija"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("om"),
            keywords: &["hindu", "om", "vallás"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("օմ"),
            keywords: &["կրոն", "հնդիկ", "օմ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("om"),
            keywords: &["Hindu", "agama", "om"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("om"),
            keywords: &["Hindu", "okpukperechi", "om"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("om-merki"),
            keywords: &["hindúismi", "om-merki", "trúarbrögð"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("Om"),
            keywords: &["Om", "induismo", "mantra", "religione induista"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("オーム"),
            keywords: &["オーム", "ヒンドゥー教", "宗教"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("Om"),
            keywords: &["Hindu", "Om", "agama", "om"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ომი"),
            keywords: &["ინდუიზმი", "ომი", "რელიგია"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("ом белгісі"),
            keywords: &["дін", "ом белгісі", "хинду"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("om"),
            keywords: &["hindu", "om", "religion"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("សញ\u{17d2}ញាស\u{17bc}រសម\u{17d2}លេងអ\u{17bc}ម"),
            keywords: &[
                "សញ\u{17d2}ញា",
                "សញ\u{17d2}ញាស\u{17bc}រសម\u{17d2}លេងអ\u{17bc}ម",
                "សម\u{17d2}លេង",
                "អ\u{17bc}ម",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಓಂ"),
            keywords: &["ಓಂ", "ಧರ\u{ccd}ಮ", "ಧಾರ\u{ccd}ಮ\u{cbf}ಕ", "ಹ\u{cbf}ಂದು"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("옴"),
            keywords: &["옴", "힌두교"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("ओम"),
            keywords: &["ओम", "धर\u{94d}म", "हि\u{902}द\u{941}"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("ом"),
            keywords: &["дин", "ом", "хинди"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("OM"),
            keywords: &["Hindu", "OM", "Relioun"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ສ\u{eb1}ນຍາລ\u{eb1}ກໂອມ"),
            keywords: &["ສ\u{eb1}ນຍາລ\u{eb1}ກ", "ສ\u{eb1}ນຍາລ\u{eb1}ກໂອມ", "ໂອມ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("Om"),
            keywords: &["Om", "hindu", "religija"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("om simbols"),
            keywords: &["hinduisms", "om simbols", "reliģija"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("om"),
            keywords: &["Hiniru", "momo karakia", "om"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("ом"),
            keywords: &["ом", "религија", "хиндуизам"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഓം"),
            keywords: &["ഓം", "മതം", "ഹിന\u{d4d}ദ\u{d41}"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("маань"),
            keywords: &["маань", "шашин"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("ॐ"),
            keywords: &["ओम", "धर\u{94d}म", "हि\u{902}द\u{942}", "ॐ"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("om"),
            keywords: &["agama", "hindu", "om"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("om"),
            keywords: &["Hindu", "om", "reliġjon"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဥ\u{102f}\u{1036}"),
            keywords: &[
                "ဘာသာရေး",
                "ဟ\u{102d}န\u{1039}ဒ\u{1030}",
                "ဥ\u{102f}\u{1036}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("om"),
            keywords: &["hindu", "om", "religion"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("ओम"),
            keywords: &["ओम", "धर\u{94d}म", "हिन\u{94d}द\u{941}"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("om-symbool"),
            keywords: &["hindoeïsme", "om", "om-symbool", "religie"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("om"),
            keywords: &["hindu", "om", "religion"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଓମ\u{b4d}\u{200c}"),
            keywords: &[
                "ଓମ\u{b4d}\u{200c}",
                "ଧର\u{b4d}ମ",
                "ହ\u{b3f}ନ\u{b4d}ଦ\u{b41}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਓਮ"),
            keywords: &["ਓਮ", "ਓਮ ਚਿ\u{a70}ਨ\u{a4d}ਹ", "ਧਰਮ", "ਹਿ\u{a70}ਦ\u{a42}"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ہندو مذہب دا راہنما"),
            keywords: &["مذہب", "ہندو", "ہندو مذہب دا راہنما"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Om"),
            keywords: &["Híndu", "Om", "Rilíjọn"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("om"),
            keywords: &["hinduizm", "om", "religia"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("اوم"),
            keywords: &["اوم", "مذهب", "هندو"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("om"),
            keywords: &["hindu", "om", "religião"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["hinduísmo", "om", "religião"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("om"),
            keywords: &["Hindu", "om", "religion"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("simbol hindus om"),
            keywords: &["hindusă", "religie", "simbol hindus om"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-762"),
            keywords: &["E10-762"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("ом"),
            keywords: &["аум", "мантра", "ом", "религия"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("om"),
            keywords: &["Hindu", "iyobokamana", "om"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("اوم"),
            keywords: &["اوم", "مذهب", "ھندو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ඕම\u{dca}"),
            keywords: &["ආගම", "ඕම\u{dca}", "හ\u{dd2}න\u{dca}ද\u{dd4}"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("óm"),
            keywords: &["indické", "náboženstvo", "óm"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("om"),
            keywords: &["hinduistično", "om", "vera"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("Xuruuf diini ee Hindida"),
            keywords: &["Hindi ah", "Xuruuf diini ee Hindida", "diin"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("om"),
            keywords: &["fe", "hindu", "om"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("ом"),
            keywords: &["ом", "рeлигиja", "хиндуизaм"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("om"),
            keywords: &["hinduizam", "om", "religija"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("aum-tecken"),
            keywords: &["aum-tecken", "hinduism", "ohm-tecken", "religion"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("omu"),
            keywords: &["dini", "kihindi", "omu"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ஓம\u{bcd}"),
            keywords: &[
                "இந\u{bcd}து மதம\u{bcd}",
                "ஓம\u{bcd}",
                "மந\u{bcd}திரம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ఓం"),
            keywords: &["ఓం", "మతం", "హ\u{c3f}ందు"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("ом"),
            keywords: &["дин", "ом", "Ҳинду"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เคร\u{e37}\u{e48}องหมายโอม"),
            keywords: &["ศาสนา", "ฮ\u{e34}นด\u{e39}", "เคร\u{e37}\u{e48}องหมายโอม"],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("om"),
            keywords: &["om", "ሂንዱ", "እምነት"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("om"),
            keywords: &["Hindu", "din", "om"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("omikala"),
            keywords: &["Hinitū", "lotu", "omikala"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("om"),
            keywords: &["Hinduizm", "din", "om"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئوم"),
            keywords: &["ئوم", "دىن", "ھىندى"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("звук ом"),
            keywords: &["звук ом", "ом", "релігія", "індуїзм"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("اوم"),
            keywords: &["اوم", "مذہب", "ہندو"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("om"),
            keywords: &["din", "hind", "om"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("om"),
            keywords: &["hindu", "om", "tôn giáo"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("om"),
            keywords: &["Endo", "diine", "om"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("i-om"),
            keywords: &["I-Hindu", "i-om", "unqulo"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("om"),
            keywords: &["Híndù", "om", "ẹ\u{300}sìn"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("唵"),
            keywords: &["印度教", "唵", "宗教"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("唵"),
            keywords: &["印度教", "唵", "宗教"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("奥姆"),
            keywords: &["印度", "奥姆", "宗教"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("唵"),
            keywords: &["唵", "梵文"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("om"),
            keywords: &["hindu", "inkolo", "om"],
        },
    ],
};
#[doc = "✡\u{fe0f}"]
pub const STAR_OF_DAVID: crate::Emoji = crate::Emoji {
    glyph: "✡\u{fe0f}",
    codepoint: "2721 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.7f32,
    name: "star of David",
    group: "Symbols",
    subgroup: "religion",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "✡",
        codepoint: "2721",
        status: crate::Status::Unqualified,
        introduction_version: 0.7f32,
        name: "star of David",
        group: "Symbols",
        subgroup: "religion",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("Dawidster"),
            keywords: &["Dawid", "Dawidster", "Jood", "Joods", "godsdiens", "ster"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የዳዊት ኮከብ"),
            keywords: &["ኃይማኖት", "አይሁዳዊ", "አይሁድ", "ኮከብ", "የዳዊት ኮከብ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("نجمة داوود"),
            keywords: &["داوود", "دين", "نجم", "نجمة داوود", "يهود", "يهودي"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ডেভিদৰ তৰ\u{9be}"),
            keywords: &[
                "ইহ\u{9c1}দি",
                "ইহ\u{9c1}দি সম\u{9cd}পৰ\u{9cd}কীয\u{9bc}",
                "ডেভিদ",
                "ডেভিদৰ তৰ\u{9be}",
                "তৰ\u{9be}",
                "ধৰ\u{9cd}ম",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("davud ulduzu"),
            keywords: &["davud", "davud ulduzu", "din", "ulduz", "yəhudi"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("зорка Давіда"),
            keywords: &[
                "Давід",
                "зорка",
                "зорка Давіда",
                "рэлігія",
                "яўрэй",
                "іудаізм",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Звезда на Давид"),
            keywords: &[
                "Звезда на Давид",
                "давид",
                "евреин",
                "еврейска",
                "звезда",
                "религия",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ডেভিড নক\u{9cd}ষত\u{9cd}র"),
            keywords: &[
                "ইহ\u{9c1}দি",
                "ডেভিড",
                "ডেভিড নক\u{9cd}ষত\u{9cd}র",
                "ত\u{9be}র\u{9be}",
                "ধর\u{9cd}ম",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("steredenn David"),
            keywords: &["relijion", "steredenn David", "yuzev"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("davidova zvijezda"),
            keywords: &[
                "david",
                "davidova zvijezda",
                "religija",
                "zvijezda",
                "židov",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("estrella de David"),
            keywords: &[
                "estrella",
                "estrella de David",
                "judaisme",
                "jueu",
                "religió",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏃᏈᏏ ᏕᏫ"),
            keywords: &["ᎠᏂᏧᏏ", "ᎠᏧᏏ", "ᎤᏃᎯᏳᏒᎢ", "ᏃᏈᏏ", "ᏕᏫ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("Davidova hvězda"),
            keywords: &[
                "Davidova hvězda",
                "david",
                "hvězda",
                "náboženství",
                "žid",
                "židovský",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("seren Dafydd"),
            keywords: &["Dafydd", "Iddew", "Iddewig", "seren"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("davidsstjerne"),
            keywords: &[
                "david",
                "davidsstjerne",
                "jøde",
                "jødisk",
                "religion",
                "stjerne",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Davidstern"),
            keywords: &["Davidstern", "Religion", "jüdisch"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("άστρο του Δαβίδ"),
            keywords: &["Δαβίδ", "άστρο του Δαβίδ", "αστέρι", "εβραϊκό", "θρησκεία"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("star of David"),
            keywords: &[
                "David",
                "Jew",
                "Jewish",
                "religion",
                "star",
                "star of David",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("estrella de David"),
            keywords: &[
                "david",
                "estrella",
                "estrella de David",
                "estrella de david",
                "judaísmo",
                "religión",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &[
                "David",
                "estrella de David",
                "judaísmo",
                "judío",
                "religión",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &[
                "David",
                "estrella",
                "estrella de David",
                "judaísmo",
                "judío",
                "religión",
            ],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("Taaveti täht"),
            keywords: &["Taaveti täht", "judaism", "juut", "taavet", "täht", "usk"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("daviden izarra"),
            keywords: &[
                "david",
                "daviden izarra",
                "erlijio",
                "izar",
                "judaismo",
                "judu",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("ستاره\u{654} داود"),
            keywords: &[
                "داود",
                "ستاره",
                "ستاره\u{654} داود",
                "مذهب",
                "یهود",
                "یهودی",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("Daavidin tähti"),
            keywords: &[
                "Daavid",
                "Daavidin tähti",
                "daavidintähti",
                "juutalaisuus",
                "tähti",
                "uskonto",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("star of david"),
            keywords: &[
                "David",
                "Hudyo",
                "Jew",
                "Jewish",
                "bituin",
                "relihiyon",
                "star of david",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("dávidsstjørna"),
            keywords: &[
                "dávidsstjørna",
                "gýðingastjørna",
                "gýðingur",
                "jødi",
                "jødiskur",
                "stjørna",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("étoile de David"),
            keywords: &[
                "David",
                "Juif",
                "juif",
                "religion",
                "étoile",
                "étoile de David",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("Réalta Dháiví"),
            keywords: &["Réalta Dháiví", "creideamh", "dáiví", "giúdach", "réalta"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("reul Dhaibhidh"),
            keywords: &["creideamh", "daibhidh", "iùdhach", "reul", "reul Dhaibhidh"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("estrela de David"),
            keywords: &[
                "estrela",
                "estrela de David",
                "relixión",
                "xudaísmo",
                "xudeus",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ડ\u{ac7}વિડનો તારો"),
            keywords: &[
                "ડ\u{ac7}વિડ",
                "ડ\u{ac7}વિડનો તારો",
                "તારો",
                "ધર\u{acd}મ",
                "યહોદી",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("tauraron Dauda"),
            keywords: &[
                "Dauda",
                "Na yahudu",
                "Yahudu",
                "addini",
                "tauraro",
                "tauraron Dauda",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("מגן דוד"),
            keywords: &["דוד", "דת", "יהדות", "יהודי", "מגן דוד"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("यह\u{942}दी धर\u{94d}म का चिह\u{94d}न"),
            keywords: &[
                "ड\u{947}विड",
                "ड\u{947}विड, यह\u{942}दी धर\u{94d}म",
                "तारा",
                "धर\u{94d}म",
                "यह\u{942}दी",
                "यह\u{942}दी धर\u{94d}म का चिह\u{94d}न",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("davidova zvijezda"),
            keywords: &[
                "David",
                "davidova zvijezda",
                "religija",
                "zvijezda",
                "židovstvo",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("Dávid-csillag"),
            keywords: &["Dávid", "Dávid-csillag", "csillag", "vallás", "zsidó"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("դավթի աստղ"),
            keywords: &["աստղ", "դավթի աստղ", "դավիթ", "կրոն", "հրեա", "հրեական"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("bintang Daud"),
            keywords: &["Daud", "Yahudi", "agama", "bintang"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("kpakpando nke David"),
            keywords: &[
                "David",
                "Ju",
                "Ndị Ju",
                "kpakpando",
                "kpakpando nke David",
                "okpukperechi",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("davíðsstjarna"),
            keywords: &[
                "Davíð",
                "davíðsstjarna",
                "gyðingdómur",
                "gyðingur",
                "stjarna",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("stella di David"),
            keywords: &[
                "David",
                "Ebraismo",
                "ebreo",
                "simbolo ebraico",
                "stella di David",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ダビデの星"),
            keywords: &["ダビデの星", "ユダヤ教", "宗教", "星"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("lintang Dawud"),
            keywords: &["Dawud", "Yahudi", "agama", "lintang", "wong Yahudi"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("დავითის ვარსკვლავი"),
            keywords: &[
                "დავითი",
                "დავითის ვარსკვლავი",
                "ებრაელი",
                "ებრაული",
                "ვარსკვლავი",
                "რელიგია",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("Давид жұлдызы"),
            keywords: &[
                "Давид жұлдызы",
                "давид",
                "дін",
                "жұлдыз",
                "иврит",
                "ивриттік",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("davidsstjerne"),
            keywords: &[
                "david",
                "davidsstjerne",
                "jøde",
                "jødisk",
                "religion",
                "stjerne",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("សញ\u{17d2}ញាផ\u{17d2}កាយរបស\u{17cb}ជនជាត\u{17b7}ជ\u{17d2}វ\u{17b8}ស"),
            keywords: &[
                "ផ\u{17d2}កាយ",
                "សញ\u{17d2}ញា",
                "សញ\u{17d2}ញាផ\u{17d2}កាយរបស\u{17cb}ជនជាត\u{17b7}ជ\u{17d2}វ\u{17b8}ស",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಡ\u{cc6}ವ\u{cbf}ಡ\u{ccd}\u{200c}ನ ಚ\u{cbf}ಹ\u{ccd}ನ\u{cc6}"),
            keywords: &[
                "ಜ\u{ccd}ಯ\u{cc2}ಯ\u{cbf}ಶ\u{ccd}",
                "ಡ\u{cc6}ವ\u{cbf}ಡ\u{ccd}\u{200c}ನ ಚ\u{cbf}ಹ\u{ccd}ನ\u{cc6}",
                "ಡೇವ\u{cbf}ಡ\u{ccd}",
                "ಧರ\u{ccd}ಮ",
                "ಯಹ\u{cc2}ದ\u{cbf}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("다비드별"),
            keywords: &["다비드", "다비드별", "별", "유대교"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("स\u{94d}टार ऑफ ड\u{945}विड"),
            keywords: &[
                "ज\u{94d}य\u{941}",
                "ड\u{945}विड",
                "धर\u{94d}म",
                "नख\u{947}त\u{94d}र",
                "स\u{94d}टार ऑफ ड\u{945}विड",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("давид жылдызы"),
            keywords: &["давид", "давид жылдызы", "дин", "жылдыз", "жөөт"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Davidstär"),
            keywords: &["David", "Davidstär", "Judd", "Relioun", "Stär", "jiddesch"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຮ\u{eb9}ບດາວຫ\u{ebc}\u{ebb}ກຫ\u{ebc}\u{ec8}ຽມ"),
            keywords: &[
                "ດາວ",
                "ຫ\u{ebc}\u{ebb}ກຫ\u{ebc}\u{ec8}ຽມ",
                "ຮ\u{eb9}ບດາວຫ\u{ebc}\u{ebb}ກຫ\u{ebc}\u{ec8}ຽມ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("Dovydo žvaigždė"),
            keywords: &[
                "Dovydas",
                "Dovydo žvaigždė",
                "religija",
                "žvaigždė",
                "žydas",
                "žydų",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("Dāvida zvaigzne"),
            keywords: &[
                "Dāvida zvaigzne",
                "Dāvids",
                "ebreji",
                "ebreju",
                "jūdi",
                "reliģija",
                "zvaigzne",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("whetū o Rāwiri"),
            keywords: &["Hūrae", "Rāwiri", "momo karakia", "whetū", "whetū o Rāwiri"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("ѕвездата на Давид"),
            keywords: &[
                "евреин",
                "религија",
                "ѕвезда",
                "ѕвездата на Давид",
                "јудаизам",
            ],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("സ\u{d4d}\u{200c}റ\u{d4d}റ\u{d3e}ർ ഓഫ\u{d4d} ഡേവിഡ\u{d4d}"),
            keywords: &[
                "ജ\u{d4d}യ\u{d42}തമതം",
                "ഡേവിഡ\u{d4d}",
                "നക\u{d4d}ഷത\u{d4d}രം",
                "മതം",
                "സ\u{d4d}\u{200c}റ\u{d4d}റ\u{d3e}ർ ഓഫ\u{d4d} ഡേവിഡ\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("давидийн од"),
            keywords: &["давид", "давидийн од", "од", "шашин"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("ड\u{947}व\u{94d}हिडच\u{947} चिन\u{94d}ह"),
            keywords: &[
                "ज\u{94d}य\u{942}",
                "ज\u{94d}य\u{942}इश",
                "ड\u{947}व\u{94d}हिड",
                "ड\u{947}व\u{94d}हिडच\u{947} चिन\u{94d}ह",
                "तारा",
                "धर\u{94d}म",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("bintang daud"),
            keywords: &["agama", "bintang", "daud", "orang yahudi", "yahudi"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("l-istilla ta’ David"),
            keywords: &[
                "David",
                "Lhudi",
                "l-istilla ta’ David",
                "reliġjon",
                "stilla",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဒေးဗစ\u{103a}ကြယ\u{103a}"),
            keywords: &[
                "ကြယ\u{103a}",
                "ဂျ\u{1030}း",
                "ဂျ\u{1030}းလ\u{1030}မျ\u{102d}\u{102f}း",
                "ဒေးဗစ\u{103a}",
                "ဒေးဗစ\u{103a}ကြယ\u{103a}",
                "ဘာသာရေး",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("Davidstjerne"),
            keywords: &[
                "David",
                "Davidstjerne",
                "jøde",
                "jødisk",
                "religion",
                "stjerne",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("ड\u{947}भिडको तारा"),
            keywords: &[
                "ड\u{947}भिड",
                "ड\u{947}भिडको तारा",
                "तारा",
                "धर\u{94d}म",
                "यह\u{942}दी",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("davidster"),
            keywords: &["david", "davidster", "jodendom", "joods", "religie", "ster"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("Davidstjerne"),
            keywords: &[
                "David",
                "Davidstjerne",
                "jøde",
                "jødisk",
                "religion",
                "stjerne",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଡେଭ\u{b3f}ଡ\u{b4d} ତ\u{b3e}ର\u{b3e}"),
            keywords: &[
                "ଇହ\u{b41}ଦୀ ଧର\u{b4d}ମ ସମ\u{b4d}ବନ\u{b4d}ଧୀୟ",
                "ଜ\u{b4d}ୟ\u{b41}",
                "ଡେଭ\u{b3f}ଡ\u{b4d}\u{200c}",
                "ତ\u{b3e}ର\u{b3e}",
                "ଧର\u{b4d}ମ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਡ\u{a4d}ਰਾਵਿਡ ਤਾਰਾ"),
            keywords: &["ਡ\u{a47}ਵਿਡ", "ਡ\u{a4d}ਰਾਵਿਡ ਤਾਰਾ", "ਯਹ\u{a42}ਦੀ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("داؤد دا ستارہ"),
            keywords: &["تارہ", "داؤد", "داؤد دا ستارہ", "مذہب", "یہودی"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Stá Ọf Dévid"),
            keywords: &[
                "Dévid",
                "Judiá Pẹ\u{301}sin",
                "Rilíjọn",
                "Sta",
                "Stá Ọf Dévid",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("gwiazda Dawida"),
            keywords: &[
                "Dawid",
                "gwiazda",
                "gwiazda Dawida",
                "gwiazda dawidowa",
                "religia",
                "żyd",
                "żydowska",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د ډیویډ ستوری"),
            keywords: &["د ډیویډ ستوری", "ستوری", "مذهب", "يهودي", "ډيويډ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("estrela de Davi"),
            keywords: &[
                "davi",
                "estrela",
                "estrela de Davi",
                "judaico",
                "judeu",
                "religião",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("estrela de David"),
            keywords: &[
                "david",
                "estrela",
                "estrela de David",
                "judaísmo",
                "judeu",
                "religião",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("quyllur Davidmanta"),
            keywords: &[
                "David",
                "Judio",
                "quyllur",
                "quyllur Davidmanta",
                "religion",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("steaua lui David"),
            keywords: &["David", "evreu", "iudaism", "stea", "steaua lui David"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-134"),
            keywords: &["E10-134"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("звезда Давида"),
            keywords: &[
                "вера",
                "давид",
                "еврей",
                "звезда",
                "звезда Давида",
                "иудаизм",
                "религия",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("Inyenyeri ya Dawudi"),
            keywords: &[
                "Dawudi",
                "Inyenyeri ya Dawudi",
                "Umuyahudi",
                "cy’Abayahudi",
                "inyenyeri",
                "iyobokamana",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڊيوڊ جو تارو"),
            keywords: &["تارو", "مذهب", "يهودي", "ڊيوڊ جو تارو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ස\u{dca}ට\u{dcf}ර\u{dca} ඔෆ\u{dca} ඩේව\u{dd2}ඩ\u{dca}"),
            keywords: &[
                "ආගම",
                "ඩේව\u{dd2}ඩ\u{dca}",
                "තර\u{dd4}ව",
                "ය\u{dd4}දෙව\u{dca}",
                "ය\u{dd4}දෙව\u{dca}ව\u{dcf}",
                "ස\u{dca}ට\u{dcf}ර\u{dca} ඔෆ\u{dca} ඩේව\u{dd2}ඩ\u{dca}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("Dávidova hviezda"),
            keywords: &[
                "Dávidova hviezda",
                "hviezda",
                "náboženstvo",
                "žid",
                "židovské",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("davidova zvezda"),
            keywords: &[
                "david",
                "davidova zvezda",
                "jud",
                "judovsko",
                "vera",
                "zvezda",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("xiddigga Da’uud"),
            keywords: &[
                "Da’uud",
                "Yuhuud",
                "Yuhuudi",
                "diin",
                "xiddig",
                "xiddigga Da’uud",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("ylli i davidit"),
            keywords: &[
                "fe",
                "hebraik",
                "hebre",
                "yll",
                "ylli i Davidit",
                "ylli i davidit",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("давидова звезда"),
            keywords: &[
                "дaвид",
                "давидова звезда",
                "звeздa",
                "рeлигиja",
                "јевреји",
                "јудаизам",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("давидова звијезда"),
            keywords: &["давидова звијезда"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("davidova zvezda"),
            keywords: &[
                "david",
                "davidova zvezda",
                "jevreji",
                "judaizam",
                "religija",
                "zvezda",
            ],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("davidova zvijezda"),
            keywords: &["davidova zvijezda"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("davidsstjärna"),
            keywords: &["davidsstjärna", "jude", "judendom", "religion", "stjärna"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("nyota ya daudi"),
            keywords: &[
                "daudi",
                "dini",
                "myahudi",
                "nyota",
                "nyota ya daudi",
                "uyahudi",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("நட\u{bcd}சத\u{bcd}திரம\u{bcd}"),
            keywords: &["நட\u{bcd}சத\u{bcd}திரம\u{bcd}", "மதம\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("డ\u{c47}వ\u{c3f}డ\u{c4d} స\u{c4d}ట\u{c3e}ర\u{c4d}"),
            keywords: &[
                "డ\u{c47}వ\u{c3f}డ\u{c4d}",
                "డ\u{c47}వ\u{c3f}డ\u{c4d} స\u{c4d}ట\u{c3e}ర\u{c4d}",
                "మతం",
                "యూదుడు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("ситораи Дейвид"),
            keywords: &["Дейвид", "дин", "ситора", "ситораи Дейвид", "яҳуд", "яҳудӣ"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("สตาร\u{e4c}ออฟเดว\u{e34}ด"),
            keywords: &[
                "ดาว",
                "ดาว\u{e34}ด",
                "ย\u{e34}ว",
                "ย\u{e39}ดาย",
                "ศาสนา",
                "สตาร\u{e4c}ออฟเดว\u{e34}ด",
            ],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ኮኾብ ናይ ዳዊት"),
            keywords: &["ኣይሁድ", "እምነት", "ኮኾብ", "ኮኾብ ናይ ዳዊት", "ዳዊት"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("Dawudyň ýyldyzy"),
            keywords: &[
                "Dawudyň ýyldyzy",
                "Dawut",
                "din",
                "ýewreý",
                "ýewreý dini",
                "ýyldyz",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("fetuʻu ʻo Tēvita"),
            keywords: &["Siu", "Tēvita", "fetuʻu", "fetuʻu ʻo Tēvita", "lotu"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("Davut yıldızı"),
            keywords: &["Davut", "Davut yıldızı", "Yahudi", "din", "yıldız"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("داۋۇت يۇلتۇزى"),
            keywords: &[
                "ئىسرائىل",
                "داۋۇت",
                "داۋۇت يۇلتۇزى",
                "دىن",
                "يۇلتۇز",
                "يەھۇدى",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("зірка Давида"),
            keywords: &[
                "давид",
                "зірка",
                "зірка Давида",
                "релігія",
                "єврей",
                "єврейський",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("داؤد کا ستارہ"),
            keywords: &["داؤد", "داؤد کا ستارہ", "ستارہ", "مذہب", "پیغمبر", "یہودی"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("dovud yulduzi"),
            keywords: &[
                "din",
                "dovud",
                "dovud yulduzi",
                "ibroniy",
                "yahudiy",
                "yulduz",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("ngôi sao sáu cánh"),
            keywords: &[
                "david",
                "do thái",
                "ngôi sao",
                "ngôi sao sáu cánh",
                "người do thái",
                "tôn giáo",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("biddeew of Dawuda"),
            keywords: &["Dawuda", "Yawuut", "biddeew", "biddeew of Dawuda", "diine"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("inkwenkwezi kaDavide"),
            keywords: &[
                "UDavide",
                "inkwenkwezi",
                "inkwenkwezi kaDavide",
                "unqulo",
                "yomJuda",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("ìràwọ\u{300} Dáfídì"),
            keywords: &[
                "Dáfídì",
                "E\u{329}lẹ\u{301}sìn júù",
                "Júù",
                "ìràwọ\u{300}",
                "ẹ\u{300}sìn",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("大衛之星"),
            keywords: &["大衛", "大衛之星", "宗教", "星", "猶太人", "猶太教"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("大卫之星"),
            keywords: &["大卫", "大卫之星", "宗教", "星", "犹太人", "犹太教"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("六芒星"),
            keywords: &["六芒星", "大卫之星", "宗教", "犹太"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("六芒星"),
            keywords: &["六芒星", "六角星"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("六角星"),
            keywords: &["六角星"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("inkanyezi kadavide"),
            keywords: &[
                "inkanyezi",
                "inkanyezi kadavide",
                "inkolo",
                "udavide",
                "umjuda",
            ],
        },
    ],
};
#[doc = "☸\u{fe0f}"]
pub const WHEEL_OF_DHARMA: crate::Emoji = crate::Emoji {
    glyph: "☸\u{fe0f}",
    codepoint: "2638 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.7f32,
    name: "wheel of dharma",
    group: "Symbols",
    subgroup: "religion",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "☸",
        codepoint: "2638",
        status: crate::Status::Unqualified,
        introduction_version: 0.7f32,
        name: "wheel of dharma",
        group: "Symbols",
        subgroup: "religion",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("dharmawiel"),
            keywords: &["Boeddhis", "dharma", "dharmawiel", "godsdiens", "wiel"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የዳርማ መዘውር"),
            keywords: &["መዘውር", "ቡድሂስት", "ኃይማኖት", "የዳርማ መዘውር", "ዳህርማ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("عجلة دارما"),
            keywords: &["بوذي", "دارما", "دين", "عجلة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ধৰ\u{9cd}ম-চক\u{9cd}ৰ"),
            keywords: &[
                "চক\u{9cd}ৰ",
                "ধৰ\u{9cd}ম",
                "ধৰ\u{9cd}ম-চক\u{9cd}ৰ",
                "বৌদ\u{9cd}ধ মত\u{9be}ৱলম\u{9cd}বী",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("dharma çarxı"),
            keywords: &["buddist", "dharma", "dharma çarxı", "din", "çarx"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("кола дхармы"),
            keywords: &["будызм", "дхарма", "кола", "кола дхармы", "рэлігія"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Колелото на дхарма"),
            keywords: &[
                "Колелото на дхарма",
                "будизъм",
                "дхарма",
                "колело",
                "религия",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ধর\u{9cd}মের চ\u{9be}ক\u{9be}"),
            keywords: &[
                "চ\u{9be}ক\u{9be}",
                "ধর\u{9cd}ম",
                "ধর\u{9cd}মের চ\u{9be}ক\u{9be}",
                "বৌদ\u{9cd}ধ",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("rod an dharma"),
            keywords: &["boudaat", "relijion", "rod an dharma"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("točak dharme"),
            keywords: &["budizam", "dharma", "religija", "točak", "točak dharme"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("roda del dharma"),
            keywords: &["budisme", "budista", "dharma", "religió", "roda del dharma"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎦᏩᏘ ᏓᎭᎹ"),
            keywords: &["ᎦᏩᏘ", "ᏓᎭᎹ", "ᏚᎾᏁᏟᏛᎢ", "ᏣᏩᏂᏏ ᏧᏁᏟᏙᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("kolo dharmy"),
            keywords: &["buddhismus", "dharma", "kolo", "kolo dharmy", "náboženství"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("olwyn dharma"),
            keywords: &["bwdhaidd", "crefydd", "dharma", "olwyn"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("dharma-hjul"),
            keywords: &["buddhist", "dharma", "dharma-hjul", "hjul", "religion"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Dharma-Rad"),
            keywords: &["Buddhismus", "Dharma", "Dharma-Rad"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("τροχός ντάρμα"),
            keywords: &["βουδιστικός", "θρησκεία", "ντάρμα", "τροχός"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("wheel of dharma"),
            keywords: &["Buddhist", "dharma", "religion", "wheel", "wheel of dharma"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: None,
            keywords: &[
                "Buddhist",
                "dharma",
                "dharmachakra",
                "religion",
                "wheel",
                "wheel of dharma",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("rueda del dharma"),
            keywords: &["budismo", "dharma", "religión", "rueda", "rueda del dharma"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("dharma"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("rueda del dharma"),
            keywords: &["rueda del dharma"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("dharma ratas"),
            keywords: &["budism", "dharma", "ratas", "usk"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("dharmaren gurpila"),
            keywords: &[
                "budista",
                "dharma",
                "dharmaren gurpila",
                "erlijio",
                "gurpil",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("چرخ دارما"),
            keywords: &["بودائی", "دارما", "مذهب", "چرخ"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("dharma-pyörä"),
            keywords: &[
                "buddha",
                "buddhalaisuus",
                "dharma",
                "dharma-pyörä",
                "pyörä",
                "ratas",
                "uskonto",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("gulong ng dharma"),
            keywords: &[
                "Buddhist",
                "dharma",
                "gulong",
                "gulong ng dharma",
                "relihiyon",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("dharmahjól"),
            keywords: &["buddistur", "dharmahjól", "religión", "trúgv", "átrúnaður"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("roue du Dharma"),
            keywords: &["bouddhiste", "dharma", "religion", "roue", "roue du Dharma"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("roth dharma"),
            keywords: &["búdaí", "creideamh", "dharma", "roth", "roth an dharma"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("cuibhle dharma"),
            keywords: &["budach", "creideamh", "cuibhle", "dharma"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("roda do dharma"),
            keywords: &["budismo", "dharma", "relixión", "roda", "roda do dharma"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ધર\u{acd}મ ચક\u{acd}ર"),
            keywords: &["ચક\u{acd}ર", "ધર\u{acd}મ", "બૌદ\u{acd}ધ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("wilin dharma"),
            keywords: &[
                "Mai addini Buddha",
                "addini",
                "dharma",
                "wili",
                "wilin dharma",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("גלגל הדהרמה"),
            keywords: &["בודהיזם", "בודהיסט", "גלגל", "גלגל הדהרמה", "דהרמה", "דת"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("धर\u{94d}म चक\u{94d}र"),
            keywords: &["चक\u{94d}र", "धर\u{94d}म", "बौद\u{94d}ध"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("kotač dharme"),
            keywords: &["budizam", "dharma", "kotač", "kotač dharme", "religija"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("dharma-kerék"),
            keywords: &["buddha", "buddhizmus", "dharma-kerék", "kerék", "vallás"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("դհարմայի անիվ"),
            keywords: &["անիվ", "բուդդայական", "դհարմա", "դհարմայի անիվ", "կրոն"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("roda dharma"),
            keywords: &["agama", "budha", "dharma", "roda"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("whelụ nke dharma"),
            keywords: &[
                "Buddhist",
                "dharma",
                "okpukperechi",
                "whelụ",
                "whelụ nke dharma",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("dharmahjól"),
            keywords: &["búddisti", "dharma", "dharmahjól", "hjól", "trúarbrögð"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("ruota del Dharma"),
            keywords: &[
                "Buddhismo",
                "Dharmacakra",
                "religione buddhista",
                "ruota a otto raggi",
                "ruota del Dharma",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("法輪"),
            keywords: &["仏教", "宗教", "法輪", "転法輪"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("rodha darma"),
            keywords: &["Buda", "agama", "darma", "rodha"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("დჰარმას ბორბალი"),
            keywords: &[
                "ბორბალი",
                "ბუდიზმი",
                "ბუდისტური",
                "დჰარმა",
                "დჰარმას ბორბალი",
                "რელიგია",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("дхарма доңғалағы"),
            keywords: &["буддист", "доңғалақ", "дхарма", "дхарма доңғалағы", "дін"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("dharma-hjul"),
            keywords: &["buddhist", "dharma", "dharma-hjul", "hjul", "religion"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some(
                "សញ\u{17d2}ញាចង\u{17d2}ក\u{17bc}តទ\u{17bc}កក\u{17d2}តោង (សម\u{17d2}គាល\u{17cb}សាសនាព\u{17d2}រះព\u{17bb}ទ\u{17d2}ធ)",
            ),
            keywords: &[
                "ចង\u{17d2}ក\u{17bc}តទ\u{17bc}ក",
                "សញ\u{17d2}ញា",
                "សញ\u{17d2}ញាចង\u{17d2}ក\u{17bc}តទ\u{17bc}កក\u{17d2}តោង (សម\u{17d2}គាល\u{17cb}សាសនាព\u{17d2}រះព\u{17bb}ទ\u{17d2}ធ)",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಧರ\u{ccd}ಮದ ಚಕ\u{ccd}ರ"),
            keywords: &[
                "ಚಕ\u{ccd}ರ",
                "ಧರ\u{ccd}ಮ",
                "ಧರ\u{ccd}ಮದ ಚಕ\u{ccd}ರ",
                "ಬ\u{ccc}ದ\u{ccd}ಧ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("진리의 수레바퀴"),
            keywords: &["다르마", "바퀴", "불교", "수레바퀴", "진리의 수레바퀴"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("धर\u{94d}म चक\u{94d}र"),
            keywords: &[
                "चक\u{94d}र",
                "धर\u{94d}म",
                "धर\u{94d}मचक\u{94d}र",
                "ब\u{941}ध\u{94d}दीश\u{94d}ठ",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("дхарма дөңгөлөгү"),
            keywords: &["буддист", "дин", "дхарма", "дхарма дөңгөлөгү"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Dharma-Rad"),
            keywords: &["Buddhist", "Dharma", "Dharma-Rad", "Rad", "Relioun"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ກ\u{ebb}ງລ\u{ecd}\u{ec9}ແຫ\u{ec8}ງທຳມະ"),
            keywords: &[
                "ກ\u{ebb}ງລ\u{ecd}\u{ec9}",
                "ກ\u{ebb}ງລ\u{ecd}\u{ec9}ແຫ\u{ec8}ງທຳມະ",
                "ທຳມະ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("Dharmos ratas"),
            keywords: &["Dharmos ratas", "budistas", "dharma", "ratas", "religija"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("darmas rats"),
            keywords: &["budisms", "darma", "darmas rats", "rats", "reliģija"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("wīra o tārama"),
            keywords: &["Putihi", "momo karakia", "tārama", "wīra", "wīra o tārama"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("тркалото на дарма"),
            keywords: &["будизам", "религија", "тркало", "тркалото на дарма"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ധർമ\u{d4d}മ ചക\u{d4d}രം"),
            keywords: &[
                "ചക\u{d4d}രം",
                "ധർമ\u{d4d}മ",
                "ബ\u{d41}ദ\u{d4d}ധിസ\u{d4d}\u{200c}റ\u{d4d}റ\u{d4d}",
                "മതം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("хүрд"),
            keywords: &["будда", "хүрд", "шашин"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("धर\u{94d}मचक\u{94d}र"),
            keywords: &[
                "धर\u{94d}म",
                "धर\u{94d}मचक\u{94d}र",
                "ब\u{941}द\u{94d}ध धर\u{94d}माच\u{947}",
                "व\u{94d}हील",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("roda dharma"),
            keywords: &["agama", "dharma", "penganut buddha", "roda"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("ir-rota ta’ dharma"),
            keywords: &[
                "Buddhist",
                "dharma",
                "ir-rota ta’ dharma",
                "reliġjon",
                "rota",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဓမ\u{1039}မစကြာ"),
            keywords: &[
                "စကြာ",
                "ဓမ\u{1039}မ",
                "ဓမ\u{1039}မစကြာ",
                "ဗ\u{102f}ဒ\u{1039}ဓဝါဒ\u{102e}",
                "ဘာသာရေး",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("dharmas hjul"),
            keywords: &["buddhist", "dharma", "dharmas hjul", "hjul", "religion"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("धर\u{94d}मको पाङ\u{94d}ग\u{94d}रा"),
            keywords: &[
                "धर\u{94d}म",
                "धर\u{94d}मको पाङ\u{94d}ग\u{94d}रा",
                "धर\u{94d}मा",
                "पाङ\u{94d}ग\u{94d}रा",
                "ब\u{941}द\u{94d}धिस\u{94d}ट",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("wiel van dharma"),
            keywords: &["boeddhist", "dharma", "religie", "wiel", "wiel van dharma"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("dharmahjulet"),
            keywords: &["buddhist", "dharma", "dharmahjulet", "hjul", "religion"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଧର\u{b4d}ମର ଚକ\u{b4d}ର"),
            keywords: &[
                "ଚକ\u{b4d}ର",
                "ଧର\u{b4d}ମ",
                "ଧର\u{b4d}ମର ଚକ\u{b4d}ର",
                "ବୌଦ\u{b4d}ଧଧର\u{b4d}ମୀ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਧਰਮ ਚ\u{a71}ਕਰ"),
            keywords: &["ਚ\u{a71}ਕਰ", "ਧਰਮ", "ਬ\u{a4b}ਧੀ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ویل آف درھما"),
            keywords: &["بدھ مت", "مذہب", "ویل آف درھما", "پہیہ", "ہندو مت"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Dhárma Wil"),
            keywords: &["Búdist", "Dhárma", "Dhárma Wíl", "Rilíjọn", "Wil"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("koło dharmy"),
            keywords: &[
                "buddysta",
                "buddyzm",
                "dharma",
                "koło",
                "koło dharmy",
                "religia",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د دهرما پايه"),
            keywords: &["بده مت", "د دهرما پايه", "دهرما", "مذهب", "پايه"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("roda do Dharma"),
            keywords: &["budista", "dharma", "religião", "roda", "roda do Dharma"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("muyu dharmanimanta"),
            keywords: &[
                "Budista",
                "dharma",
                "muyu",
                "muyu dharmanimanta",
                "religion",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("roata dharmei"),
            keywords: &[
                "budism",
                "dharma",
                "religie",
                "roata dharma",
                "roata dharmei",
                "roată",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-059"),
            keywords: &["E10-059"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("колесо дхармы"),
            keywords: &["буддизм", "дхарма", "колесо", "колесо дхармы", "религия"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("uruziga rwa daharama"),
            keywords: &[
                "daharama",
                "iyobokamana",
                "uruziga",
                "uruziga rwa daharama",
                "uwemera Buda",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڌرما جو ڦيٿو"),
            keywords: &["مذهب", "ٻڌمت", "ڌرما", "ڌرما جو ڦيٿو", "ڦيٿو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ධර\u{dca}ම චක\u{dca}\u{200d}රය"),
            keywords: &["ආගම", "චක\u{dca}\u{200d}රය", "ධර\u{dca}ම", "බෞද\u{dca}ධ"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("koleso dharmy"),
            keywords: &[
                "budhista",
                "dharma",
                "koleso",
                "koleso dharmy",
                "náboženstvo",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("kolo darme"),
            keywords: &["budistično", "darma", "kolo", "kolo darme", "vera"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("diinta Hindida ee dharma"),
            keywords: &["diin", "diinta Hindida ee dharma", "qof caabuda budhcada"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("rrota e darmës"),
            keywords: &["budist", "darmë", "fe", "rrota e darmës", "rrotë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("дармин точак"),
            keywords: &["будизaм", "дарма", "дармин точак", "рeлигиja", "точак"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("darmin točak"),
            keywords: &["budizam", "darma", "darmin točak", "religija", "točak"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("livets hjul"),
            keywords: &["buddhist", "hjul", "livets hjul", "livshjul", "religion"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("gurudumu la dharma"),
            keywords: &[
                "dharma",
                "dini",
                "gurudumu",
                "gurudumu la dharma",
                "mfuasi wa budha",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("தர\u{bcd}மச\u{bcd} சக\u{bcd}கரம\u{bcd}"),
            keywords: &[
                "தர\u{bcd}மச\u{bcd} சக\u{bcd}கரம\u{bcd}",
                "புத\u{bcd}த மதம\u{bcd}",
                "மதச\u{bcd}சின\u{bcd}னம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ధర\u{c4d}మచక\u{c4d}రం"),
            keywords: &[
                "చక\u{c4d}రం",
                "ధర\u{c4d}మచక\u{c4d}రం",
                "బ\u{c4c}ద\u{c4d}ధుడు",
                "మతం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("чархи дарма"),
            keywords: &["Буддист", "дарма", "дин", "чарх", "чархи дарма"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ธรรมจ\u{e31}กร"),
            keywords: &[
                "จ\u{e31}กร",
                "ธรรมจ\u{e31}กร",
                "ธรรมะ",
                "พ\u{e38}ทธ",
                "ศาสนา",
            ],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("መንኮርኮር ናይ ዳርማ"),
            keywords: &["መንኮርኮር", "መንኮርኮር ናይ ዳርማ", "ቡድሂስት", "እምኘጥ", "ዳርማ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("darmanyň çarhy"),
            keywords: &["Buddist", "darma", "darmanyň çarhy", "din", "çarh"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("veʻeteka ʻo Tāma"),
            keywords: &["Tāma", "veʻeteka", "veʻeteka ʻo Tāma"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("darma çemberi"),
            keywords: &[
                "Budist",
                "darma çemberi",
                "dharma",
                "dharma tekeri",
                "din",
                "çember",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("دارما چاقى"),
            keywords: &["بۇددىست", "دارما", "دارما چاقى", "دىن", "چاق"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("колесо дхарми"),
            keywords: &["буддист", "дхарма", "колесо", "колесо дхарми", "релігія"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("دھرم چکر"),
            keywords: &["بدھ مت", "دھرم", "دھرم چکر", "مذہب", "پہیہ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("dharma g‘ildiragi"),
            keywords: &["budda", "buddist", "dharma g‘ildiragi", "din", "g‘ildirak"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("pháp luân"),
            keywords: &["bánh xe", "pháp", "pháp luân", "phật giáo", "tôn giáo"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("pëno dharma"),
            keywords: &["Buddhist", "dharma", "diine", "pëno"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ivili le-dharma"),
            keywords: &[
                "I-Buddhist",
                "i-dharma",
                "ivili le-dharma",
                "iviliheel",
                "unqulo",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("kẹ\u{300}ké\u{329} è\u{329}sìn dáámà"),
            keywords: &[
                "E\u{329}lẹ\u{301}sìn bó\u{329}ó\u{329}dà",
                "kè\u{329}ké\u{329}",
                "kẹ\u{300}ké\u{329} è\u{329}sìn dáámà",
                "ẹlẹ\u{301}sìn dáámà",
                "ẹ\u{300}sìn",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("佛法輪"),
            keywords: &["佛教", "佛法", "佛法輪", "宗教", "輪"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("佛法轮"),
            keywords: &["佛教", "佛法", "佛法轮", "宗教", "轮"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("法轮"),
            keywords: &["佛", "宗教", "法轮", "达摩"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("法輪"),
            keywords: &["法輪"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("法則輪"),
            keywords: &["法則輪"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("isondo likadharma"),
            keywords: &["dharma", "inkolo", "isondo", "isondo likadharma", "umbhuda"],
        },
    ],
};
#[doc = "☯\u{fe0f}"]
pub const YIN_YANG: crate::Emoji = crate::Emoji {
    glyph: "☯\u{fe0f}",
    codepoint: "262F FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.7f32,
    name: "yin yang",
    group: "Symbols",
    subgroup: "religion",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "☯",
        codepoint: "262F",
        status: crate::Status::Unqualified,
        introduction_version: 0.7f32,
        name: "yin yang",
        group: "Symbols",
        subgroup: "religion",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("jin-jang"),
            keywords: &["godsdiens", "jang", "jin", "jin-jang", "tao", "taois"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ዩን ያንግ"),
            keywords: &["ታኦ", "ታኦይስት", "ኃይማኖት", "ዩን ያንግ", "ዪን", "ያንግ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("نصفان متكاملان"),
            keywords: &["تكامل", "دين", "نصفان متكاملان"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("য\u{9bc}িন য\u{9bc}\u{9be}ং"),
            keywords: &[
                "ট\u{9be}ও",
                "ট\u{9be}ও দৰ\u{9cd}শন অন\u{9c1}সৰণক\u{9be}ৰী",
                "ধৰ\u{9cd}ম",
                "য\u{9bc}\u{9be}ং",
                "য\u{9bc}িন",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("in yan"),
            keywords: &["dao", "daoist", "din", "in", "yan"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("інь і ян"),
            keywords: &["даасізм", "рэлігія", "ян", "інь", "інь і ян"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("ин и ян"),
            keywords: &["ин", "ин и ян", "религия", "тао", "ян"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ইন ইয\u{9bc}\u{9be}ঙ\u{9cd}গ"),
            keywords: &[
                "ইন",
                "ইন ইয\u{9bc}\u{9be}ঙ\u{9cd}গ",
                "ইয\u{9bc}\u{9be}ং",
                "ত\u{9be}ও",
                "ত\u{9be}ওব\u{9be}দী",
                "ধর\u{9cd}ম",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("yin yang"),
            keywords: &["relijion", "tao", "yang", "yin"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("jin jang"),
            keywords: &["jang", "jin", "religija", "tao", "taoizam"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("yin-yang"),
            keywords: &[
                "religió",
                "tao",
                "taoisme",
                "taoista",
                "yin i yang",
                "yin-yang",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏱᏂ ᏰᎾᎩ"),
            keywords: &["ᎠᏂᏔᎣ", "ᏔᎣ", "ᏚᎾᏁᏟᏛ", "ᏰᎩ", "ᏱᏂ", "ᏱᏂ ᏰᎾᎩ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("jin a jang"),
            keywords: &[
                "jang",
                "jin",
                "jin a jang",
                "náboženství",
                "tao",
                "taoismus",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("yin yang"),
            keywords: &["crefydd", "tao", "taoaidd", "yin yang"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("yin og yang"),
            keywords: &["religion", "tao", "taoist", "yang", "yin", "yin og yang"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Yin und Yang"),
            keywords: &["Daoismus", "Religion", "Yang", "Yin", "Yin und Yang"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("γιν γιανγκ"),
            keywords: &["γιανγκ", "γιν", "θρησκεία", "τάο", "ταοϊστικός"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("yin yang"),
            keywords: &["religion", "tao", "taoist", "yang", "yin"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["Tao", "Taoist", "religion", "yang", "yin"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("yin yang"),
            keywords: &["religión", "taoísmo", "yang", "yin"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("yin-yang"),
            keywords: &["taoism", "usk", "yang", "yin", "yin-yang"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("yin eta yang"),
            keywords: &["erlijio", "tao", "taoista", "yang", "yin", "yin eta yang"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("یین و ینگ"),
            keywords: &["تائو", "مذهب", "یانگ", "یین", "یین و ینگ"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("jin ja jang"),
            keywords: &["jang", "jin", "jin ja jang", "tao", "taolaisuus", "uskonto"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("yin yang"),
            keywords: &["Tsina", "pilosopiya", "relihiyon", "yang", "yin"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("jin yang"),
            keywords: &["jin yang", "yang taoisma", "yin"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("yin yang"),
            keywords: &["religion", "tao", "yang", "yin"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("yin yang"),
            keywords: &["creideamh", "tao", "taoch", "yang", "yin"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("Ying Yang"),
            keywords: &["Ying Yang", "creideamh", "tao", "taothach", "yang", "yin"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("yin-yang"),
            keywords: &["relixión", "taoísmo", "yang", "yin", "yin-yang"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("યિન યા\u{a82}ગ"),
            keywords: &["તાઓ", "ધર\u{acd}મ", "યા\u{a82}ગ", "યિન"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("yin yang"),
            keywords: &["addini", "mai bin tao", "tao", "yang", "yin"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("יין-יאנג"),
            keywords: &["דאו", "דאואיזם", "דאואיסט", "דת", "יין-יאנג"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("यि\u{902}ग या\u{902}ग"),
            keywords: &["ताओ", "ताओवादी", "धर\u{94d}म", "या\u{902}ग", "यि\u{902}ग"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("jin i jang"),
            keywords: &["jang", "jin", "jin i jang", "religija", "taoizam"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("jin-jang"),
            keywords: &["jang", "jin", "jin-jang", "tao", "taoizmus", "vallás"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ին և յան"),
            keywords: &["դաո", "դաոսիստ", "ին", "ին և յան", "կրոն", "յան"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("yin yang"),
            keywords: &["agama", "tao", "taoisme", "yang", "yin"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("yin yang"),
            keywords: &["okpukperechi", "tao", "taoist", "yang", "yin"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("jin jang"),
            keywords: &["jang", "jin", "taó", "taóisti", "trúarbrögð"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("Yin e Yang"),
            keywords: &["Confucianesimo", "Taoismo", "Yin e Yang", "simbolo"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("陰陽"),
            keywords: &["インヤン", "宗教", "道教", "陰陽"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("yinyang"),
            keywords: &["agama", "tao", "umat tao", "yang", "yin", "yinyang"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ინი და იანი"),
            keywords: &["იანი", "ინი", "ინი და იანი", "რელიგია", "ტაო", "ტაოისტური"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("инь-ян белгісі"),
            keywords: &["дін", "инь", "инь-ян белгісі", "тао", "таоист", "ян"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("yin og yang"),
            keywords: &["religion", "tao", "taoist", "yang", "yin", "yin og yang"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("សញ\u{17d2}ញាយ\u{17b7}នន\u{17b7}ងយ\u{17c9}ាង"),
            keywords: &[
                "យ\u{17b7}នយ\u{17c9}ាង",
                "សញ\u{17d2}ញា",
                "សញ\u{17d2}ញាយ\u{17b7}នន\u{17b7}ងយ\u{17c9}ាង",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಯ\u{cbf}ನ\u{ccd} ಯಾಂಗ\u{ccd}"),
            keywords: &["ಟಾವೊ", "ಧರ\u{ccd}ಮ", "ಯಾಂಗ\u{ccd}", "ಯ\u{cbf}ನ\u{ccd}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("음양"),
            keywords: &["양", "음", "음양"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("यीन या\u{902}ग"),
            keywords: &["टाओ", "टाओयिस\u{94d}ट", "धर\u{94d}म", "या\u{902}ग", "यीन"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("Инь-ян"),
            keywords: &["Инь-ян", "дао", "дин", "инь", "ян"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Yin-Yang"),
            keywords: &["Relioun", "Tao", "Taoist", "Yang", "Yin", "Yin-Yang"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຢ\u{eb4}ນຢາງ"),
            keywords: &["ຢ\u{eb4}ນຢາງ", "ສ\u{eb1}ນຍາລ\u{eb1}ກ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("In ir Jang"),
            keywords: &["In ir Jang", "in", "jang", "religija", "tao", "taoizmas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("iņ un jaņ"),
            keywords: &["daoisms", "iņ", "iņ un jaņ", "jaņ", "reliģija"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("yin yang"),
            keywords: &["momo karakia", "tangata tao", "tao", "yang", "yin"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("јин јанг"),
            keywords: &["религија", "таоизам", "јанг", "јин"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("യിൻ യ\u{d3e}ങ\u{d4d}"),
            keywords: &[
                "ട\u{d3e}വോ",
                "ട\u{d3e}വോയിസ\u{d4d}റ\u{d4d}റ\u{d4d}",
                "മതം",
                "യ\u{d3e}ങ\u{d4d}",
                "യിൻ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("арга билиг"),
            keywords: &["арга", "билиг", "шашин"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("यिन या\u{902}ग"),
            keywords: &["टाओ", "टाओवादी", "धर\u{94d}म", "या\u{902}ग", "यिन"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("yin yang"),
            keywords: &["agama", "penganut tao", "tao", "yang", "yin"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("yin yang"),
            keywords: &["reliġjon", "tao", "taoist", "yang", "yin"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ယင\u{103a}ယန\u{103a}း"),
            keywords: &[
                "တာအ\u{102d}\u{102f}",
                "တာအ\u{102d}\u{102f}ဝါဒ\u{102e}",
                "ဘာသာရေ",
                "ယင\u{103a}",
                "ယင\u{103a}ယန\u{103a}း",
                "ယန\u{103a}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("yin yang"),
            keywords: &["religion", "tao", "taoist", "yang", "yin"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("यिन याङ\u{94d}ग"),
            keywords: &["टाविस\u{94d}ट", "टावो", "धर\u{94d}म", "याङ\u{94d}ग", "यिन"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("yin en yang"),
            keywords: &["religie", "tao", "taoïst", "yang", "yin", "yin en yang"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("yin yang"),
            keywords: &["religion", "tao", "taoist", "yang", "yin"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ୟ\u{b3f}ଙ\u{b4d}ଗ ୟ\u{b3e}ଙ\u{b4d}ଗ"),
            keywords: &[
                "ତ\u{b3e}ଓ",
                "ତ\u{b3e}ଓଧର\u{b4d}ମୀ",
                "ଧର\u{b4d}ମ",
                "ୟ\u{b3e}ଙ\u{b4d}ଗ",
                "ୟ\u{b3f}ଙ\u{b4d}ଗ ୟ\u{b3e}ଙ\u{b4d}ଗ",
                "ୟ\u{b3f}ନ\u{b4d}\u{200c}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਯਿਨ ਯ\u{a48}\u{a02}ਗ"),
            keywords: &["ਤਾਓ", "ਤਾਓਵਾਦੀ", "ਧਰਮ", "ਯਿਨ", "ਯ\u{a48}\u{a02}ਗ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ی\u{650}ن یانگ"),
            keywords: &["تاؤ", "تاؤمت", "مذہب", "ین", "ینگ", "ی\u{650}ن یانگ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Yin Yang"),
            keywords: &["Rilíjọn", "Táo", "Táóist", "Yang", "Yin"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("yin-yang"),
            keywords: &["religia", "tao", "taoizm", "yang", "yin", "yin-yang"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ین یانگ"),
            keywords: &["مذهب", "ين", "ينګ", "ټاو", "ټاوسټ", "ین یانگ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("yin yang"),
            keywords: &["religião", "tao", "taoista", "yang", "yin"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("yin yang"),
            keywords: &["religião", "taoismo", "taoista", "yang", "yin"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("yin yang"),
            keywords: &["religion", "tao", "taoista", "yang", "yin"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("yin yang"),
            keywords: &["religie", "taoism", "yang", "yin"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-058"),
            keywords: &["E10-058"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("инь-ян"),
            keywords: &["инь", "инь-ян", "религия", "тао", "ян"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("yini yangi"),
            keywords: &["cya tawo", "iyobokamana", "tawo", "yangi", "yini"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ين يينگ"),
            keywords: &["تائو", "تائو مذهب جو پيروڪار", "مذهب", "ين", "يينگ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ය\u{dd2}න\u{dca} යැන\u{dca}"),
            keywords: &[
                "ආගම",
                "ත\u{dcf}ඕ",
                "ත\u{dcf}ඕ ආගම අදහන\u{dca}න\u{dcf}",
                "යැන\u{dca}",
                "ය\u{dd2}න\u{dca}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("jin a jang"),
            keywords: &["jang", "jin", "jin a jang", "náboženstvo", "tao", "taoista"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("jin jang"),
            keywords: &["jang", "jin", "tao", "taoistično", "vera"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("diinta Shiinaha ee yin yang"),
            keywords: &[
                "diin",
                "diinta Shiinaha ee yin yang",
                "diinta tao",
                "diinta taoist",
                "diinta yang",
                "diinta yin",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("jin jang"),
            keywords: &["fe", "jang", "jin", "tao", "taoist"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("јин и јанг"),
            keywords: &["jaнг", "jин", "рeлигиja", "тaoизaм", "јин и јанг"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("jin i jang"),
            keywords: &["jang", "jin", "jin i jang", "religija", "taoizam"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("yin och yang"),
            keywords: &["religion", "tao", "taoist", "yang", "yin", "yin och yang"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("yin yang"),
            keywords: &["dini", "mfuasi wa tao", "tao", "yang", "yin"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("யின\u{bcd} ய\u{bbe}ங\u{bcd}"),
            keywords: &[
                "மதம\u{bcd}",
                "ய\u{bbe}ங\u{bcd}",
                "யின\u{bcd} ய\u{bbe}ங\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("య\u{c3f}న\u{c4d} య\u{c3e}ంగ\u{c4d}"),
            keywords: &[
                "ట\u{c3e}వ\u{c4b}",
                "మతం",
                "య\u{c3e}ంగ\u{c4d}",
                "య\u{c3f}న\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("йин янг"),
            keywords: &["дин", "йин", "тао", "таоист", "янг"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("หย\u{e34}นหยาง"),
            keywords: &["ล\u{e31}ทธ\u{e34}", "หย\u{e34}นหยาง", "เต\u{e4b}า"],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ዪን ያንግ"),
            keywords: &["ተኸታሊ ታኦ", "ታኦ", "እምነት", "ዪን", "ያንግ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ýin ýang"),
            keywords: &["din", "tao", "taoist", "ýang", "ýin"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("ingi-iangi"),
            keywords: &["ingi-iangi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("yin yang"),
            keywords: &["din", "tao", "taocu", "yang", "yin"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("يىن ياڭ"),
            keywords: &["داۋ", "داۋزىم", "دىن", "ياڭ", "يىن"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("інь-ян"),
            keywords: &["дао", "даосизм", "релігія", "янь", "інь", "інь-ян"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ین یینگ"),
            keywords: &["تاؤ", "مذہب", "ین", "ین یینگ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("yin yang"),
            keywords: &["din", "tao", "taoist", "yang", "yin"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("âm dương"),
            keywords: &["dương", "người theo đạo", "tôn giáo", "âm", "đạo"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("yin yang"),
            keywords: &["diine", "tao", "wu-tao", "yang", "yin"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("i-yin yang"),
            keywords: &[
                "i-tao",
                "i-taoist",
                "i-yang",
                "i-yin",
                "i-yin yang",
                "unqulo",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("yínì yángì"),
            keywords: &["táó", "yángì", "yínì", "ẹlé\u{329}sìn táó", "ẹ\u{300}sìn"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("陰陽"),
            keywords: &["宗教", "道", "道教", "陰", "陰陽", "陽"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("阴阳"),
            keywords: &["宗教", "道", "道教", "阳", "阴", "阴阳"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("阴阳"),
            keywords: &["太极", "宗教", "道", "道教", "阳", "阴", "阴阳"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("陰陽"),
            keywords: &["陰陽"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("yin yang"),
            keywords: &["inkolo", "tao", "yang", "yin yang", "ying"],
        },
    ],
};
#[doc = "✝\u{fe0f}"]
pub const LATIN_CROSS: crate::Emoji = crate::Emoji {
    glyph: "✝\u{fe0f}",
    codepoint: "271D FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.7f32,
    name: "latin cross",
    group: "Symbols",
    subgroup: "religion",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "✝",
        codepoint: "271D",
        status: crate::Status::Unqualified,
        introduction_version: 0.7f32,
        name: "latin cross",
        group: "Symbols",
        subgroup: "religion",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("Latynse kruis"),
            keywords: &["Latynse kruis", "christen", "godsdiens", "kruis"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የላቲን መስቀል"),
            keywords: &["መስቀል", "ኃይማኖት", "ክርስትያን", "የላቲን መስቀል"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("صليب لاتيني"),
            keywords: &["دين", "صليب", "صليب لاتيني", "مسيحي"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("লেটিন ক\u{9cd}ৰ\u{9c1}ছ"),
            keywords: &[
                "ক\u{9cd}ৰ\u{9c1}ছ",
                "খ\u{9cd}ৰীষ\u{9cd}ট\u{9cd}ৰিয\u{9bc}\u{9be}ন",
                "ধৰ\u{9cd}ম",
                "লেটিন ক\u{9cd}ৰ\u{9c1}ছ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("latın xaçı"),
            keywords: &["din", "latın xaçı", "xaç", "xristian"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("каталіцкі крыж"),
            keywords: &[
                "каталіцкі крыж",
                "каталіцтва",
                "крыж",
                "рэлігія",
                "хрысціянства",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Латински кръст"),
            keywords: &["Латински кръст", "кръст", "религия", "християнство"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ল\u{9cd}য\u{9be}টিন ক\u{9cd}রস"),
            keywords: &[
                "ক\u{9cd}রস",
                "খ\u{9c3}স\u{9cd}ট\u{9be}ন",
                "ধর\u{9cd}ম",
                "ল\u{9cd}য\u{9be}টিন ক\u{9cd}রস",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("kroaz latin"),
            keywords: &["kristen", "kroaz latin", "relijion"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("latinski krst"),
            keywords: &["katolicizam", "krst", "latinski krst", "religija"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("creu llatina"),
            keywords: &["creu", "creu llatina", "cristianisme", "cristià", "religió"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎴᏔᏂ ᎤᎾᏤᎵ ᏓᏓᎿᏫᏍᏛ"),
            keywords: &["ᎤᏃᎯᏳᏒᎢ", "ᎴᏔᏂ ᎤᎾᏤᎵ ᏓᏓᎿᏫᏍᏛ", "ᏓᏓᎿᏫᏍᏛ", "ᏧᏁᏟᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("latinský kříž"),
            keywords: &[
                "křesťan",
                "křesťanský",
                "křesťanství",
                "kříž",
                "latinský kříž",
                "náboženství",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("croes ladin"),
            keywords: &["crefydd", "cristnogol", "croes", "croes ladin"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("latinsk kors"),
            keywords: &["kors", "kristen", "latinsk kors", "religion"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("römisches Kreuz"),
            keywords: &[
                "Christentum",
                "Kreuz",
                "Religion",
                "römisch",
                "römisches Kreuz",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("λατινικός σταυρός"),
            keywords: &["θρησκεία", "λατινικός σταυρός", "σταυρός", "χριστιανικός"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("latin cross"),
            keywords: &["Christian", "cross", "latin cross", "religion"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("Christian cross"),
            keywords: &["Christian", "cross", "religion"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("Latin cross"),
            keywords: &["Christian", "Latin cross", "cross", "religion"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("cruz latina"),
            keywords: &["cristianismo", "cruz", "cruz latina", "religión"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("cruz latina"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("ladina rist"),
            keywords: &["kristlus", "ladina rist", "rist", "usk"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("gurutze latindarra"),
            keywords: &["erlijio", "gurutze", "gurutze latindarra", "kristau"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("صلیب"),
            keywords: &["صلیب", "مذهب", "مسیحیت"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("latinalainen risti"),
            keywords: &["kristinusko", "latinalainen risti", "risti", "uskonto"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("latin na krus"),
            keywords: &[
                "Kristiyanismo",
                "Latin",
                "krus",
                "latin na krus",
                "relihiyon",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("latínskur krossur"),
            keywords: &[
                "kristin",
                "krossur",
                "latínskur krossur",
                "religión",
                "trúgv",
                "átrúnaður",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("croix latine"),
            keywords: &["chrétien", "croix", "croix latine", "religion"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("cros laidineach"),
            keywords: &["creideamh", "cros", "cros laidineach", "críostaí"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("crois Laideann"),
            keywords: &["creideamh", "crois", "crois Laideann", "crìostaidh"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cruz latina"),
            keywords: &["cristianismo", "cruz", "cruz latina", "relixión"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("લ\u{ac7}ટિન ક\u{acd}રોસ"),
            keywords: &[
                "ક\u{acd}રોસ",
                "ખ\u{acd}રિસ\u{acd}તી",
                "ધર\u{acd}મ",
                "લ\u{ac7}ટિન ક\u{acd}રોસ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("kuros na latin"),
            keywords: &["Kirista", "addini", "kuros", "kuros na latin"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("צלב"),
            keywords: &["דת", "נוצרי", "נצרות", "צלב"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ल\u{948}टिन क\u{94d}रॉस"),
            keywords: &["ईसाई", "धर\u{94d}म", "ल\u{948}टिन क\u{94d}रॉस"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("latinski križ"),
            keywords: &["križ", "kršćanstvo", "latinski križ", "religija"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("latin kereszt"),
            keywords: &["kereszt", "kereszténység", "latin kereszt", "vallás"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("լատինական խաչ"),
            keywords: &["լատինական խաչ", "խաչ", "կրոն", "քրիստոնյա"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("salib latin"),
            keywords: &["agama", "kristen", "salib", "salib latin"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("obe latin"),
            keywords: &["Ndị òtù Christi", "obe", "obe latin", "okpukperechi"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("latneskur kross"),
            keywords: &["kristni", "kross", "latneskur kross", "trúarbrögð"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("croce latina"),
            keywords: &["Cristianesimo", "croce", "croce latina", "religione"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("十字架"),
            keywords: &["キリスト教", "クロス", "十字架", "宗教"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("salib latin"),
            keywords: &["Kristen", "agama", "salib", "salib latin"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ლათინური ჯვარი"),
            keywords: &[
                "ლათინური ჯვარი",
                "რელიგია",
                "ქრისტიანობა",
                "ქრისტიანული",
                "ჯვარი",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("латынша крест"),
            keywords: &["дін", "крест", "латынша крест", "христиан"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("latinsk kors"),
            keywords: &["kors", "kristen", "latinsk kors", "religion"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("សញ\u{17d2}ញឈើឆ\u{17d2}កាង"),
            keywords: &[
                "ឈើឆ\u{17d2}កាង",
                "សញ\u{17d2}ញឈើឆ\u{17d2}កាង",
                "សញ\u{17d2}ញា",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಲ\u{ccd}ಯಾಟ\u{cbf}ನ\u{ccd} ಕ\u{ccd}ರಾಸ\u{ccd}"),
            keywords: &[
                "ಕ\u{ccd}ರಾಸ\u{ccd}",
                "ಕ\u{ccd}ರ\u{cbf}ಶ\u{ccd}ಚ\u{cbf}ಯನ\u{ccd}",
                "ಧರ\u{ccd}ಮ",
                "ಲ\u{ccd}ಯಾಟ\u{cbf}ನ\u{ccd} ಕ\u{ccd}ರಾಸ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("라틴 십자가"),
            keywords: &["기독교", "라틴 십자가", "십자가", "종교"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("ल\u{945}टीन क\u{94d}रॉस"),
            keywords: &[
                "क\u{94d}रॉस",
                "ख\u{94d}रिश\u{94d}चन",
                "धर\u{94d}म",
                "ल\u{945}टीन क\u{94d}रॉस",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("латын крести"),
            keywords: &["дин", "крест", "латын крести", "христиан"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("latäinescht Kräiz"),
            keywords: &["Kräiz", "Relioun", "chrëschtlech", "latäinescht Kräiz"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໄມ\u{ec9}ກາງເຂນ"),
            keywords: &["ສ\u{eb1}ນຍາລ\u{eb1}ກ", "ໄມ\u{ec9}ກາງເຂນ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("Romos katalikų kryžius"),
            keywords: &[
                "Romos katalikų kryžius",
                "krikščionis",
                "kryžius",
                "religija",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("kristiešu krusts"),
            keywords: &["kristietība", "kristiešu krusts", "krusts", "reliģija"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("rīpeka ratini"),
            keywords: &["karaitiana", "momo karakia", "rīpeka", "rīpeka ratini"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("латински крст"),
            keywords: &["крст", "латински крст", "религија", "христијанство"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ല\u{d3e}റ\u{d4d}റിൻ ക\u{d4d}രോസ\u{d4d}"),
            keywords: &[
                "ക\u{d41}രിശ\u{d4d}",
                "ക\u{d4d}രിസ\u{d4d}\u{200c}ത\u{d41}മതം",
                "മതം",
                "ല\u{d3e}റ\u{d4d}റിൻ ക\u{d4d}രോസ\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("латин загалмай"),
            keywords: &["Христийн", "загалмай", "латин загалмай", "шашин"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("ल\u{945}टिन"),
            keywords: &[
                "क\u{94d}रॉस",
                "ख\u{94d}रिश\u{94d}चन",
                "धर\u{94d}म",
                "ल\u{945}टिन",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("salib latin"),
            keywords: &["agama", "kristian", "salib", "salib latin"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("salib latin"),
            keywords: &["Kristjan", "reliġjon", "salib", "salib latin"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("လက\u{103a}တင\u{103a} လက\u{103a}ဝါးကပ\u{103a}တ\u{102d}\u{102f}င\u{103a}"),
            keywords: &[
                "ကားတ\u{102d}\u{102f}င\u{103a}",
                "ခရစ\u{103a}ယာန\u{103a}",
                "ဘာသာရေး",
                "လက\u{103a}တင\u{103a} ကားတ\u{102d}\u{102f}င\u{103a}",
                "လက\u{103a}တင\u{103a} လက\u{103a}ဝါးကပ\u{103a}တ\u{102d}\u{102f}င\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("latinsk kors"),
            keywords: &["kors", "kristen", "latinsk kors", "religion"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("ल\u{94d}याटिन क\u{94d}रस"),
            keywords: &[
                "क\u{94d}रस",
                "क\u{94d}रिस\u{94d}चियन",
                "धर\u{94d}म",
                "ल\u{94d}याटिन क\u{94d}रस",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("christelijk kruis"),
            keywords: &["christelijk kruis", "christendom", "kruis", "religie"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("latisnk kross"),
            keywords: &[
                "kristen",
                "kross",
                "latinsk kross",
                "latisnk kross",
                "religion",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଲ\u{b3e}ଟ\u{b3f}ନ\u{b4d}\u{200c} କ\u{b4d}ରସ\u{b4d}\u{200c}"),
            keywords: &[
                "କ\u{b4d}ରସ\u{b4d}\u{200c}",
                "ଖ\u{b4d}ରୀଷ\u{b4d}ଟ\u{b3f}ଆନ\u{b4d}\u{200c}",
                "ଧର\u{b4d}ମ",
                "ଲ\u{b3e}ଟ\u{b3f}ନ\u{b4d}\u{200c} କ\u{b4d}ରସ\u{b4d}\u{200c}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਲਾਤੀਨੀ ਕਰ\u{a4c}ਸ"),
            keywords: &[
                "ਇਸਾਈ",
                "ਕ\u{a4d}ਰਾਸ ਦਾ ਚਿ\u{a70}ਨ\u{a4d}ਹ",
                "ਧਰਮ",
                "ਲਾਤੀਨੀ ਕਰ\u{a4c}ਸ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("لاطینی صلیب"),
            keywords: &["عیسائی", "لاطینی صلیب", "مذہب", "پار کرنا"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Látín Krọs"),
            keywords: &["Krístien", "Krọs", "Látín Krọs", "Rilíjọn"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("krzyż łaciński"),
            keywords: &[
                "chrześcijaństwo",
                "krzyż",
                "krzyż łaciński",
                "krzyżyk",
                "religia",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("لاتیني صلیب"),
            keywords: &["صليب", "عيسايي", "لاتيني صليب", "لاتیني صلیب", "مذهب"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("cruz latina"),
            keywords: &["cristão", "cruz", "cruz latina", "religião"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["cristã", "cruz", "cruz latina", "religião"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("latina chakana"),
            keywords: &["Cristiano", "chakana", "latina chakana", "religion"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("cruce latină"),
            keywords: &["creștinism", "cruce", "cruce latină", "religie"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-133"),
            keywords: &["E10-133"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("латинский крест"),
            keywords: &[
                "длинный крест",
                "крест",
                "латинский крест",
                "религия",
                "христианство",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umusaraba w’abalatini"),
            keywords: &[
                "Umukirisitiu",
                "idini",
                "umusaraba",
                "umusaraba w’abalatini",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("لاطيني ڪراس"),
            keywords: &["عيسائي", "لاطيني ڪراس", "مذهب", "ڪراس"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ලත\u{dd2}න\u{dca} ක\u{dd4}ර\u{dd4}සය"),
            keywords: &[
                "ආගම",
                "ක\u{dca}\u{200d}ර\u{dd2}ස\u{dca}ත\u{dd2}ය\u{dcf}න\u{dd2}",
                "ක\u{dd4}ර\u{dd4}සය",
                "ලත\u{dd2}න\u{dca} ක\u{dd4}ර\u{dd4}සය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("latinský kríž"),
            keywords: &["kresťanské", "kríž", "latinský kríž", "náboženstvo"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("krščanski križ"),
            keywords: &["križ", "krščanski križ", "krščansko", "vera"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("mactabka latin"),
            keywords: &["diin", "mactab", "mactabka latin", "qof masiixi"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("kryqi latin"),
            keywords: &["fe", "i krishterë", "kryq", "kryqi latin"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("латински крст"),
            keywords: &["крст", "латински крст", "рeлигиja", "хришћaнствo"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("latinski krst"),
            keywords: &["hrišćanstvo", "krst", "latinski krst", "religija"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("latinskt kors"),
            keywords: &["kors", "kristendom", "latinskt kors", "religion"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("msalaba wa kilatini"),
            keywords: &["dini", "mkristo", "msalaba", "msalaba wa kilatini"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("லத\u{bcd}த\u{bc0}ன\u{bcd} சிலுவை"),
            keywords: &[
                "கிறிஸ\u{bcd}தவ மதம\u{bcd}",
                "லத\u{bcd}த\u{bc0}ன\u{bcd} சிலுவை",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ల\u{c3e}ట\u{c3f}న\u{c4d} క\u{c4d}ర\u{c3e}స\u{c4d}"),
            keywords: &[
                "క\u{c4d}ర\u{c3e}స\u{c4d}",
                "క\u{c4d}ర\u{c48}స\u{c4d}తవుడు",
                "మతం",
                "ల\u{c3e}ట\u{c3f}న\u{c4d} క\u{c4d}ర\u{c3e}స\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("салиби лотинӣ"),
            keywords: &["Насронӣ", "дин", "салиб", "салиби лотинӣ"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ไม\u{e49}กางเขนละต\u{e34}น"),
            keywords: &[
                "คร\u{e34}สต\u{e4c}",
                "ศาสนา",
                "ไม\u{e49}กางเขน",
                "ไม\u{e49}กางเขนละต\u{e34}น",
            ],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ናይ ላቲን መስቀል"),
            keywords: &["ሃይማኖት", "መስቀል", "ናይ ላቲን መስቀል", "ክርስትያን"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("katolik haçy"),
            keywords: &["Hristian", "din", "haç", "katolik haçy"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("kolosi fakalatina"),
            keywords: &["fakalatina", "kolosi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("Latin haçı"),
            keywords: &["Hristiyan", "Latin haçı", "din", "haç", "İsa"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("لاتىن كىرېست"),
            keywords: &["خىرىستىيان", "دىن", "كىرېست", "لاتىن كىرېست"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("латинський хрест"),
            keywords: &[
                "католицький хрест",
                "латинський хрест",
                "релігія",
                "хрест",
                "християнин",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("لاطینی کراس"),
            keywords: &["عیسائیت", "لاطینی کراس", "مذہب", "کراس"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("lotin xoch"),
            keywords: &["din", "lotin xoch", "nasroniylik", "xoch"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("thánh giá la-tinh"),
            keywords: &["chữ thập", "cơ đốc", "thánh giá la-tinh", "tôn giáo"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("kruwaa lateŋ"),
            keywords: &["Kreceŋ", "diine", "kruwaa", "kruwaa lateŋ"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("umnqamlezo we-latin"),
            keywords: &["Umkristu", "umnqamlezo", "umnqamlezo we-latin", "unqulo"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("àgbélèbú látíìnì"),
            keywords: &[
                "àgbélèbú",
                "àgbélèbú látíìnì",
                "ẹlẹ\u{301}sìn ìgbàgbó\u{329}",
                "ẹ\u{300}sìn",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("拉丁十字架"),
            keywords: &["十字架", "基督教", "宗教", "拉丁十字架"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("拉丁十字架"),
            keywords: &["十字架", "基督教", "宗教", "拉丁十字架"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("十字架"),
            keywords: &["十字架", "基督", "天主教", "宗教"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("拉丁十字架"),
            keywords: &["十字架", "拉丁十字架"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("isiphambano sobulatini"),
            keywords: &[
                "inkolo",
                "isiphambano",
                "isiphambano sobulatini",
                "ubukristu",
            ],
        },
    ],
};
#[doc = "☦\u{fe0f}"]
pub const ORTHODOX_CROSS: crate::Emoji = crate::Emoji {
    glyph: "☦\u{fe0f}",
    codepoint: "2626 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "orthodox cross",
    group: "Symbols",
    subgroup: "religion",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "☦",
        codepoint: "2626",
        status: crate::Status::Unqualified,
        introduction_version: 1f32,
        name: "orthodox cross",
        group: "Symbols",
        subgroup: "religion",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("ortodokse kruis"),
            keywords: &["christen", "godsdiens", "kruis", "ortodokse kruis"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የኦርቶዶክስ መስቀል"),
            keywords: &["መስቀል", "ኃይማኖት", "ክርስትያን", "የኦርቶዶክስ መስቀል"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("صليب أرثوزوكس"),
            keywords: &["دين", "صليب", "صليب أرثوزوكس", "مسيحية"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("অৰ\u{9cd}থডক\u{9cd}স ক\u{9cd}ৰ\u{9c1}ছ"),
            keywords: &[
                "অৰ\u{9cd}থডক\u{9cd}স ক\u{9cd}ৰ\u{9c1}ছ",
                "ক\u{9cd}ৰ\u{9c1}ছ",
                "খ\u{9cd}ৰীষ\u{9cd}ট\u{9cd}ৰিয\u{9bc}\u{9be}ন",
                "ধৰ\u{9cd}ম",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("ortodoks xaçı"),
            keywords: &["din", "ortodoks xaçı", "xaç", "xristian"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("праваслаўны крыж"),
            keywords: &[
                "крыж",
                "праваслаўе",
                "праваслаўны крыж",
                "рэлігія",
                "хрысціянства",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Православен кръст"),
            keywords: &["Православен кръст", "кръст", "религия", "християнство"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("অর\u{9cd}থডক\u{9cd}স ক\u{9cd}রস"),
            keywords: &[
                "অর\u{9cd}থডক\u{9cd}স ক\u{9cd}রস",
                "ক\u{9cd}রস",
                "খ\u{9c3}স\u{9cd}ট\u{9be}ন",
                "ধর\u{9cd}ম",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("kroaz ortodoks"),
            keywords: &["kristen", "kroaz ortodoks", "relijion"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("pravoslavni krst"),
            keywords: &["krst", "pravoslavlje", "pravoslavni krst", "religija"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("creu ortodoxa"),
            keywords: &["creu", "ortodoxa", "religió"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏂᏧᏏ ᎤᎾᏤᎵ ᏓᏓᎿᏫᏍᏛ"),
            keywords: &["ᎠᏂᏧᏏ ᎤᎾᏤᎵ ᏓᏓᎿᏫᏍᏛ", "ᎤᏃᎯᏳᏒᎢ", "ᏓᏓᎿᏫᏍᏛ", "ᏧᏁᏟᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("pravoslavný kříž"),
            keywords: &[
                "křesťan",
                "křesťanský",
                "křesťanství",
                "kříž",
                "náboženství",
                "pravoslavný kříž",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("croes uniongred"),
            keywords: &["crefydd", "cristnogol", "croes", "croes uniongred"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("ortodokst kors"),
            keywords: &["kors", "kristen", "ortodokst kors", "religion"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("orthodoxes Kreuz"),
            keywords: &[
                "Christentum",
                "Kreuz",
                "Orthodox",
                "Religion",
                "orthodoxes Kreuz",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ορθόδοξος σταυρός"),
            keywords: &["θρησκεία", "ορθόδοξος σταυρός", "σταυρός", "χριστιανικός"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("orthodox cross"),
            keywords: &["Christian", "cross", "orthodox cross", "religion"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("Orthodox cross"),
            keywords: &["Christian", "Orthodox cross", "cross", "religion"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("cruz ortodoxa"),
            keywords: &["cruz", "cruz ortodoxa", "religión"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["cristianismo", "cruz", "ortodoxa", "religión"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("õigeusu rist"),
            keywords: &["kristlus", "rist", "usk", "õigeusu rist"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("gurutze ortodoxoa"),
            keywords: &["erlijio", "gurutze", "gurutze ortodoxoa", "kristau"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("صلیب ارتدوکسی"),
            keywords: &["صلیب", "صلیب ارتدوکسی", "مذهب", "مسیحیت"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("ortodoksiristi"),
            keywords: &[
                "kristinusko",
                "ortodoksiristi",
                "ortodoksisuus",
                "risti",
                "uskonto",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("orthodox na krus"),
            keywords: &[
                "Kristiyanismo",
                "Orthodox",
                "krus",
                "orthodox na krus",
                "relihiyon",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("ortodoksur krossur"),
            keywords: &[
                "kristin",
                "krossur",
                "ortodoksur krossur",
                "religión",
                "trúgv",
                "átrúnaður",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("croix orthodoxe"),
            keywords: &["chrétien", "croix", "croix orthodoxe", "religion"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["chrétien", "croix", "orthodoxe", "réligion"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("cros ortadocsach"),
            keywords: &["creideamh", "cros", "cros ortadocsach", "críostaí"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("crois nan Ortodogsach"),
            keywords: &["creideamh", "crois", "crois nan Ortodogsach", "crìostaidh"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cruz ortodoxa"),
            keywords: &["cristianismo", "cruz", "cruz ortodoxa", "relixión"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ઑર\u{acd}થોડોક\u{acd}સ ક\u{acd}રોસ"),
            keywords: &[
                "ઑર\u{acd}થોડોક\u{acd}સ ક\u{acd}રોસ",
                "ક\u{acd}રોસ",
                "ધર\u{acd}મ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("kuros na gargajiya"),
            keywords: &["Kirista", "addini", "kuros", "kuros na gargajiya"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("צלב אורתודוכסי"),
            keywords: &["אורתודוכסי", "דת", "נוצרי", "נצרות", "צלב"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ऑर\u{94d}थडॉक\u{94d}स क\u{94d}रॉस"),
            keywords: &[
                "ईसाई",
                "ऑर\u{94d}थडॉक\u{94d}स क\u{94d}रॉस",
                "क\u{94d}रॉस",
                "धर\u{94d}म",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("pravoslavni križ"),
            keywords: &["križ", "kršćanstvo", "pravoslavni križ", "religija"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("ortodox kereszt"),
            keywords: &["kereszt", "kereszténység", "ortodox kereszt", "vallás"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ուղղափառ խաչ"),
            keywords: &["խաչ", "կրոն", "ուղղափառ խաչ", "քրիստոնյա"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("salib ortodoks"),
            keywords: &["agama", "kristen", "salib", "salib ortodoks"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("obe ọthọdọsụ"),
            keywords: &["Ndị òtù Christi", "obe", "obe ọthọdọsụ", "okpukperechi"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("rétttrúnaðarkross"),
            keywords: &["kristni", "kross", "rétttrúnaðarkross", "trúarbrögð"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("croce ortodossa"),
            keywords: &[
                "Cristianesimo",
                "croce",
                "croce ortodossa",
                "ortodossi",
                "religione",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("八端十字架"),
            keywords: &["キリスト教", "八端十字架", "十字架", "宗教"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("salib ortodoks"),
            keywords: &["Kristen", "agama", "salib", "salib ortodoks"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მართმადიდებლური ჯვარი"),
            keywords: &[
                "მართმადიდებლური ჯვარი",
                "რელიგია",
                "ქრისტიანობა",
                "ქრისტიანული",
                "ჯვარი",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("ортодоксалдық крест"),
            keywords: &["дін", "крест", "ортодоксалдық крест", "христиан"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("ortodokst kors"),
            keywords: &["kors", "kristen", "ortodokst kors", "religion"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("សញ\u{17d2}ញាឈើឆ\u{17d2}កាងប\u{17bb}រាណ"),
            keywords: &[
                "ឈើឆ\u{17d2}កាង",
                "សញ\u{17d2}ញា",
                "សញ\u{17d2}ញាឈើឆ\u{17d2}កាងប\u{17bb}រាណ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಸಾಂಪ\u{ccd}ರದಾಯ\u{cbf}ಕ ಕ\u{ccd}ರಾಸ\u{ccd}"),
            keywords: &[
                "ಕ\u{ccd}ರಾಸ\u{ccd}",
                "ಕ\u{ccd}ರ\u{cbf}ಶ\u{ccd}ಚ\u{cbf}ಯನ\u{ccd}",
                "ಧರ\u{ccd}ಮ",
                "ಸಾಂಪ\u{ccd}ರದಾಯ\u{cbf}ಕ ಕ\u{ccd}ರಾಸ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("전통적인 십자가"),
            keywords: &["기독교", "십자가", "전통적인 십자가", "종교"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("सनातनी क\u{94d}रॉस"),
            keywords: &[
                "क\u{94d}रॉस",
                "ख\u{94d}रिश\u{94d}चन",
                "धर\u{94d}म",
                "सनातनी क\u{94d}रॉस",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("ортодокс крести"),
            keywords: &["дин", "крест", "ортодокс крести", "христиан"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("orthodoxt Kräiz"),
            keywords: &["Kräiz", "Relioun", "chrëschtlech", "orthodoxt Kräiz"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໄມ\u{ec9}ກາງເຂນໂອທ\u{ecd}ດ\u{eb1}ອກ"),
            keywords: &[
                "ໂອທ\u{ecd}ດ\u{eb1}ອກ",
                "ໄມ\u{ec9}ກາງເຂນ",
                "ໄມ\u{ec9}ກາງເຂນໂອທ\u{ecd}ດ\u{eb1}ອກ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("ortodoksų kryžius"),
            keywords: &["krikščionis", "kryžius", "ortodoksų kryžius", "religija"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("pareizticīgo krusts"),
            keywords: &[
                "kristietība",
                "krusts",
                "pareizticība",
                "pareizticīgo krusts",
                "reliģija",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("rīpeka tukuiho"),
            keywords: &["karaitiana", "momo karakia", "rīpeka", "rīpeka tukuiho"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("православен крст"),
            keywords: &["крст", "православен крст", "религија", "христијанство"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഓർത\u{d4d}തഡോക\u{d4d}\u{200c}സ\u{d4d} ക\u{d4d}രോസ\u{d4d}"),
            keywords: &[
                "ഓർത\u{d4d}തഡോക\u{d4d}\u{200c}സ\u{d4d} ക\u{d4d}രോസ\u{d4d}",
                "ക\u{d41}രിശ\u{d4d}",
                "ക\u{d4d}രിസ\u{d4d}\u{200c}ത\u{d41}മതം",
                "മതം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("ортодокс загалмай"),
            keywords: &["Христийн", "загалмай", "ортодокс загалмай", "шашин"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("ऑर\u{94d}थोडॉक\u{94d}स क\u{94d}रॉस"),
            keywords: &[
                "ऑर\u{94d}थोडॉक\u{94d}स क\u{94d}रॉस",
                "क\u{94d}रॉस",
                "ख\u{94d}रिश\u{94d}चन",
                "धर\u{94d}म",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("salib ortodoks"),
            keywords: &["agama", "kristian", "salib", "salib ortodoks"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("salib ortodoss"),
            keywords: &["Kristjan", "reliġjon", "salib", "salib ortodoss"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "ရ\u{103e}ေးရ\u{102d}\u{102f}းခရစ\u{103a}ယာန\u{103a} အသင\u{103a}းတော\u{103a} လက\u{103a}ဝါးကပ\u{103a}တ\u{102d}\u{102f}င\u{103a}",
            ),
            keywords: &[
                "ကားတ\u{102d}\u{102f}င\u{103a}",
                "ခရစ\u{103a}ယာန\u{103a}",
                "ဘာသာရေး",
                "ရ\u{103e}ေးရ\u{102d}\u{102f}းခရစ\u{103a}ယာန\u{103a} အသင\u{103a}းတော\u{103a} လက\u{103a}ဝါးကပ\u{103a}တ\u{102d}\u{102f}င\u{103a}",
                "အောတ\u{102d}\u{102f}ဒ\u{102d}\u{102f}စ\u{103a} ကားတ\u{102d}\u{102f}င\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("ortodokst kors"),
            keywords: &["kors", "kristen", "ortodoks", "ortodokst kors", "religion"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("अर\u{94d}थडक\u{94d}स क\u{94d}रस"),
            keywords: &[
                "अर\u{94d}थडक\u{94d}स क\u{94d}रस",
                "क\u{94d}रस",
                "क\u{94d}रिस\u{94d}चियन",
                "धर\u{94d}म",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("russisch kruis"),
            keywords: &["christendom", "kruis", "religie", "russisch kruis"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("ortodoks kross"),
            keywords: &["kristen ortodoks", "kross", "ortodoks kross", "religion"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଅର\u{b4d}ଥୋଡକ\u{b4d}ସ କ\u{b4d}ରସ\u{b4d}\u{200c}"),
            keywords: &[
                "ଅର\u{b4d}ଥୋଡକ\u{b4d}ସ କ\u{b4d}ରସ\u{b4d}\u{200c}",
                "କ\u{b4d}ରସ\u{b4d}\u{200c}",
                "ଖ\u{b4d}ରୀଷ\u{b4d}ଟ\u{b3f}ଆନ\u{b4d}\u{200c}",
                "ଧର\u{b4d}ମ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਰ\u{a42}ੜ\u{a4d}ਹੀਬ\u{a71}ਧ ਕਰ\u{a4c}ਸ"),
            keywords: &[
                "ਇਸਾਈ",
                "ਕ\u{a4d}ਰਾਸ ਦਾ ਚਿ\u{a70}ਨ\u{a4d}ਹ",
                "ਧਰਮ",
                "ਰ\u{a42}ੜ\u{a4d}ਹੀਬ\u{a71}ਧ ਕਰ\u{a4c}ਸ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("اورتھوڈکس کراس"),
            keywords: &["اورتھوڈکس کراس", "عیسائی", "مذہب", "پار کرنا"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Ọ\u{301}tọ\u{301}dọ\u{301}ks Krọs"),
            keywords: &[
                "Krístien",
                "Krọs",
                "Rilíjọn",
                "Ọ\u{301}tọ\u{301}dọ\u{301}ks Krọs",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("krzyż prawosławny"),
            keywords: &[
                "chrześcijaństwo",
                "krzyż",
                "krzyż ortodoksyjny",
                "krzyż prawosławny",
                "krzyżyk",
                "religia",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د ارتودکس صلیب"),
            keywords: &["ارتودکس صليب", "د ارتودکس صلیب", "صليب", "عيسايي", "مذهب"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("cruz ortodoxa"),
            keywords: &["cristão", "cruz", "cruz ortodoxa", "religião"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["cristã", "cruz", "ortodoxa", "religião"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("ortodoxa chakana"),
            keywords: &["Cristiano", "chakana", "ortodoxa chakana", "religion"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("cruce ortodoxă"),
            keywords: &[
                "creștinism",
                "cruce",
                "cruce ortodoxă",
                "ortodoxie",
                "religie",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-055"),
            keywords: &["E10-055"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("православный крест"),
            keywords: &["крест", "православие", "православный крест", "религия"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umusaraba w’aba-orthodox"),
            keywords: &[
                "Umukirisitiu",
                "idini",
                "umusaraba",
                "umusaraba w’aba-orthodox",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("آرٿوڊوڪس ڪراس"),
            keywords: &["آرٿوڊوڪس ڪراس", "عيسائي", "مذهب", "ڪراس"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ස\u{dcf}ධ\u{dcf}ර\u{dca}ම\u{dd2}ක ක\u{dd4}ර\u{dd4}සය"),
            keywords: &[
                "ආගම",
                "ක\u{dca}\u{200d}ර\u{dd2}ස\u{dca}ත\u{dd2}ය\u{dcf}න\u{dd2}",
                "ක\u{dd4}ර\u{dd4}සය",
                "ස\u{dcf}ධ\u{dcf}ර\u{dca}ම\u{dd2}ක ක\u{dd4}ර\u{dd4}සය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("pravoslávny kríž"),
            keywords: &["kresťanské", "kríž", "náboženstvo", "pravoslávny kríž"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("pravoslavni križ"),
            keywords: &["križ", "krščansko", "pravoslavni križ", "vera"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("mactabka diinta asal-raacnimada"),
            keywords: &[
                "diin",
                "mactab",
                "mactabka diinta asal-raaca",
                "mactabka diinta asal-raacnimada",
                "qof masiixi",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("kryq ortodoks"),
            keywords: &["fe", "i krishterë", "kryq", "kryq ortodoks"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("православни крст"),
            keywords: &["крст", "православни крст", "рeлигиja", "хришћaнствo"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("pravoslavni krst"),
            keywords: &["hrišćanstvo", "krst", "pravoslavni krst", "religija"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("ortodoxt kors"),
            keywords: &["kors", "kristendom", "ortodoxt kors", "religion"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("msalaba"),
            keywords: &["dini", "mkristo", "msalaba"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ஆர\u{bcd}த\u{bcd}தோட\u{bbe}க\u{bcd}ஸ\u{bcd} சிலுவை"),
            keywords: &[
                "ஆர\u{bcd}த\u{bcd}தோட\u{bbe}க\u{bcd}ஸ\u{bcd} சிலுவை",
                "ஆர\u{bcd}த\u{bcd}தோட\u{bbe}ஸ\u{bcd} சிலுவை",
                "கிறிஸ\u{bcd}தவ மதம\u{bcd}",
                "கிறிஸ\u{bcd}தவம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("సన\u{c3e}తన క\u{c4d}ర\u{c3e}స\u{c4d}"),
            keywords: &[
                "క\u{c4d}ర\u{c3e}స\u{c4d}",
                "క\u{c4d}ర\u{c48}స\u{c4d}తవుడు",
                "మతం",
                "సన\u{c3e}తన క\u{c4d}ర\u{c3e}స\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("салиби православӣ"),
            keywords: &["Насронӣ", "дин", "салиб", "салиби православӣ"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ไม\u{e49}กางเขนออร\u{e4c}โธดอกซ\u{e4c}"),
            keywords: &[
                "คร\u{e34}สต\u{e4c}",
                "ศาสนา",
                "ไม\u{e49}กางเขน",
                "ไม\u{e49}กางเขนออร\u{e4c}โธดอกซ\u{e4c}",
            ],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ናይ ኦርቶዶክስ መስቀል"),
            keywords: &["ሃይማኖት", "መስቀል", "ናይ ኦርቶዶክስ መስቀል", "ክርስትያን"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("prawoslaw haçy"),
            keywords: &["Hristian", "din", "haç", "prawoslaw haçy"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("kolosi fakakalisi"),
            keywords: &["fakakalisi", "kolosi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("Ortodoks haçı"),
            keywords: &["Hristiyan", "Ortodoks haçı", "din", "haç", "İsa"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئورتودوكس"),
            keywords: &["ئورتودوكس", "خىرىستىيان", "دىن", "كىرېست"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("православний хрест"),
            keywords: &["православний хрест", "релігія", "хрест", "християнин"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("روایتی مذہبی کراس"),
            keywords: &["روایتی مذہبی کراس", "عیسائیت", "مذہب", "کراس"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("pravoslav xoch"),
            keywords: &["din", "nasroniylik", "pravoslav xoch", "xoch"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("thập giá chính thống giáo"),
            keywords: &[
                "cơ đốc",
                "thập giá",
                "thập giá chính thống giáo",
                "tôn giáo",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("kruwaa ortodoks"),
            keywords: &["Kreceŋ", "diine", "kruwaa", "kruwaa ortodoks"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("umnqamlezo we-orthodox"),
            keywords: &["Umkristu", "umnqamlezo", "umnqamlezo we-orthodox", "unqulo"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("àgbélèbú àtijó"),
            keywords: &[
                "àgbélèbú",
                "àgbélèbú àtijó",
                "ẹlẹ\u{301}sìn ìgbàgbó\u{329}",
                "ẹ\u{300}sìn",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("正統十字架"),
            keywords: &["十字架", "基督教", "宗教", "正統十字架"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("正统十字架"),
            keywords: &["十字架", "基督教", "宗教", "正统十字架"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("东正教十字架"),
            keywords: &["东正教", "东正教十字架", "十字架", "基督", "宗教"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("東正教十字架"),
            keywords: &["十字架", "東正教十字架"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("正教會十字"),
            keywords: &["十字", "十字架", "東正教十字架", "正教會十字"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("isiphambano senkolo"),
            keywords: &["inkolo", "isiphambano", "isiphambano senkolo", "ubukristu"],
        },
    ],
};
#[doc = "☪\u{fe0f}"]
pub const STAR_AND_CRESCENT: crate::Emoji = crate::Emoji {
    glyph: "☪\u{fe0f}",
    codepoint: "262A FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.7f32,
    name: "star and crescent",
    group: "Symbols",
    subgroup: "religion",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "☪",
        codepoint: "262A",
        status: crate::Status::Unqualified,
        introduction_version: 0.7f32,
        name: "star and crescent",
        group: "Symbols",
        subgroup: "religion",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("ster en sekelmaan"),
            keywords: &["Islam", "godsdiens", "moslem", "ster en sekelmaan"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ኮከብ እና ግማሽ ጨረቃ"),
            keywords: &["ሙስሊም", "ኃይማኖት", "እስላም", "ኮከብ እና ግማሽ ጨረቃ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("هلال ونجمة"),
            keywords: &["إسلام", "دين", "مسلم", "هلال ونجمة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("তৰ\u{9be} আৰ\u{9c1} ক\u{9be}\u{981}চিজোন"),
            keywords: &[
                "ইছল\u{9be}ম",
                "তৰ\u{9be} আৰ\u{9c1} ক\u{9be}\u{981}চিজোন",
                "ধৰ\u{9cd}ম",
                "ম\u{9c1}ছলম\u{9be}ন",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("ulduz və aypara"),
            keywords: &["din", "islam", "müsəlman", "ulduz və aypara"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("зорка і паўмесяц"),
            keywords: &["зорка і паўмесяц", "мусульманскі", "рэлігія", "іслам"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("полумесец със звезда"),
            keywords: &["ислям", "мюсюлманин", "полумесец със звезда", "религия"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ত\u{9be}র\u{9be} এবং অর\u{9cd}ধচন\u{9cd}দ\u{9cd}র\u{9be}ক\u{9be}র"),
            keywords: &[
                "ইসল\u{9be}ম",
                "ত\u{9be}র\u{9be} এবং অর\u{9cd}ধচন\u{9cd}দ\u{9cd}র\u{9be}ক\u{9be}র",
                "ধর\u{9cd}ম",
                "ম\u{9c1}সলিম",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("steredenn ha kreskenn"),
            keywords: &["islam", "muzulman", "relijion", "steredenn ha kreskenn"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("polumjesec i zvijezda"),
            keywords: &["islam", "musliman", "polumjesec i zvijezda", "religija"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("creixent lunar i estel"),
            keywords: &["creixent lunar i estel", "islamisme", "musulmà", "religió"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏃᏈᏏ ᎠᎴ ᎤᏓᏍᏈᏘ"),
            keywords: &["ᎢᏏᎳᎻ", "ᎤᏃᎯᏳᏒᎢ", "ᎹᏏᎳᎻ", "ᏃᏈᏏ ᎠᎴ ᎤᏓᏍᏈᏘ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("hvězda a půlměsíc"),
            keywords: &[
                "hvězda a půlměsíc",
                "islám",
                "islámský",
                "muslim",
                "muslimský",
                "náboženství",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("seren a chilgant"),
            keywords: &["crefydd", "islam", "mwslim", "seren a chilgant"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("stjerne og halvmåne"),
            keywords: &["islam", "muslim", "religion", "stjerne og halvmåne"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Hilal und Stern"),
            keywords: &["Hilal", "Hilal und Stern", "Islam", "Religion", "Stern"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("αστέρι και ημισέληνος"),
            keywords: &[
                "αστέρι και ημισέληνος",
                "θρησκεία",
                "ισλάμ",
                "μουσουλμανικός",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("star and crescent"),
            keywords: &["Muslim", "islam", "religion", "star and crescent"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["Islam", "Muslim", "religion", "star and crescent"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("media luna y estrella"),
            keywords: &[
                "estrella",
                "islam",
                "luna",
                "media luna y estrella",
                "religión",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("estrella y creciente"),
            keywords: &[
                "estrella",
                "estrella y creciente",
                "islam",
                "luna",
                "media luna y estrella",
                "religión",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["Musulmán", "estrella y creciente", "islam", "religión"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("täht ja kuusirp"),
            keywords: &["islam", "moslem", "täht ja kuusirp", "usk"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("izarra eta ilargierdia"),
            keywords: &["erlijio", "islam", "izarra eta ilargierdia", "musulman"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("هلال و ستاره"),
            keywords: &["اسلام", "مذهب", "مسلمان", "هلال و ستاره"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kuunsirppi ja tähti"),
            keywords: &[
                "islam",
                "kuu",
                "kuunsirppi ja tähti",
                "muslimi",
                "tähti",
                "uskonto",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("star and crescent"),
            keywords: &[
                "Islam",
                "bituin",
                "buwan",
                "crescent",
                "muslim",
                "relihiyon",
                "star and crescent",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("stjørna og hálvmáni"),
            keywords: &[
                "islam",
                "muslimur",
                "religión",
                "stjørna og hálvmáni",
                "trúgv",
                "átrúnaður",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("lune et étoile"),
            keywords: &["lune", "lune et étoile", "musulman", "religion", "étoile"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("étoile et croissant de lune"),
            keywords: &[
                "croissant",
                "islam",
                "musulman",
                "religion",
                "étoile",
                "étoile et croissant de lune",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("réalta agus corrán"),
            keywords: &["creideamh", "ioslam", "moslamach", "réalta agus corrán"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("corran is rionnag"),
            keywords: &["corran is rionnag", "creideamh", "ioslam", "muslamach"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("media lúa e estrela"),
            keywords: &[
                "islam",
                "islamismo",
                "media lúa",
                "media lúa e estrela",
                "relixión",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ચા\u{a82}દ અન\u{ac7} તારો"),
            keywords: &[
                "ઇસ\u{acd}લામ",
                "ચા\u{a82}દ અન\u{ac7} તારો",
                "ધર\u{acd}મ",
                "મ\u{ac1}સ\u{acd}લિમ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("tauroro da hilali"),
            keywords: &["Musulmi", "addini", "islam", "tauroro da hilali"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("כוכב וסהר"),
            keywords: &["איסלם", "דת", "כוכב", "כוכב וסהר", "מוסלמי", "סהר"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("चा\u{901}द और तारा"),
            keywords: &[
                "इस\u{94d}लाम",
                "चा\u{901}द और तारा",
                "चा\u{902}द और तारा",
                "चा\u{902}द और तारा, इस\u{94d}लाम धर\u{94d}म",
                "धर\u{94d}म",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("zvijezda i polumjesec"),
            keywords: &["islam", "religija", "zvijezda i polumjesec"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("csillag és félhold"),
            keywords: &["csillag és félhold", "iszlám", "muszlim", "vallás"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("աստղ և մահիկ"),
            keywords: &["աստղ և մահիկ", "իսլամ", "կրոն", "մուսուլման"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("bintang dan bulan"),
            keywords: &["agama", "bintang dan bulan", "islam", "muslim"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("kpakpando na enyo"),
            keywords: &[
                "Ndị Alakụba",
                "kpakpando na enyo",
                "okpukperechi",
                "ụka Alakụba",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("stjarna og skarður máni"),
            keywords: &["múslimi", "stjarna og skarður máni", "trúarbrögð", "íslam"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("mezzaluna e stella"),
            keywords: &[
                "Islamismo",
                "mezzaluna",
                "mezzaluna e stella",
                "religione",
                "stella",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("星と三日月"),
            keywords: &["イスラム教", "三日月", "宗教", "星", "星と三日月"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("lintang lan mbulan anyaran"),
            keywords: &["Islam", "Muslim", "agama", "lintang lan mbulan anyaran"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ვარსკვლავი და ნახევარმთვარე"),
            keywords: &[
                "ვარსკვლავი და ნახევარმთვარე",
                "ისლამი",
                "მუსლიმანური",
                "რელიგია",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("жұлдыз бен жарым ай"),
            keywords: &["дін", "жұлдыз бен жарым ай", "ислам", "мұсылман"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("stjerne og halvmåne"),
            keywords: &["islam", "muslim", "religion", "stjerne og halvmåne"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("សញ\u{17d2}ញាអឌ\u{17d2}ឍច\u{17d0}ន\u{17d2}ទន\u{17b7}ងផ\u{17d2}កាយ"),
            keywords: &[
                "ផ\u{17d2}កាយ",
                "សញ\u{17d2}ញា",
                "សញ\u{17d2}ញាអឌ\u{17d2}ឍច\u{17d0}ន\u{17d2}ទន\u{17b7}ងផ\u{17d2}កាយ",
                "អឌ\u{17d2}ឍច\u{17d0}ន\u{17d2}ទ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ನಕ\u{ccd}ಷತ\u{ccd}ರ ಮತ\u{ccd}ತು ಅರ\u{ccd}ಧಚಂದ\u{ccd}ರ"),
            keywords: &[
                "ಇಸ\u{ccd}ಲಾಂ ಧರ\u{ccd}ಮ",
                "ಧರ\u{ccd}ಮ",
                "ನಕ\u{ccd}ಷತ\u{ccd}ರ ಮತ\u{ccd}ತು ಅರ\u{ccd}ಧಚಂದ\u{ccd}ರ",
                "ಮುಸ\u{ccd}ಲ\u{cbf}ಂ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("초승달과 별"),
            keywords: &["별", "이슬람", "종교", "초승달", "초승달과 별"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("नख\u{947}त\u{94d}र आनी च\u{902}द\u{94d}रकोर"),
            keywords: &[
                "ईस\u{94d}लाम",
                "धर\u{94d}म",
                "नख\u{947}त\u{94d}र आनी च\u{902}द\u{94d}रकोर",
                "म\u{941}स\u{94d}लीम",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("ай жана жылдыз"),
            keywords: &["ай жана жылдыз", "дин", "ислам", "мусулман"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Stär an Hallefmound"),
            keywords: &["Islam", "Moslem", "Relioun", "Stär an Hallefmound"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ພະຈ\u{eb1}ນສ\u{ec9}ຽວ ແລະ ດາວ"),
            keywords: &[
                "ພະຈ\u{eb1}ນສ\u{ec9}ຽວ ແລະ ດາວ",
                "ມ\u{eb8}ດສະລ\u{eb4}ມ",
                "ສາສະໜາ",
                "ອ\u{eb4}ດສະລາມ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("žvaigždė ir pusmėnulis"),
            keywords: &[
                "islamas",
                "musulmonas",
                "religija",
                "žvaigždė ir pusmėnulis",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("zvaigzne un pusmēness"),
            keywords: &["islāms", "musulmaņi", "reliģija", "zvaigzne un pusmēness"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("whetū me pewa"),
            keywords: &["ihirama", "momo karakia", "muhurimi", "whetū me pewa"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("ѕвезда и полумесечина"),
            keywords: &["ислам", "муслиман", "религија", "ѕвезда и полумесечина"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഇസ\u{d4d}ല\u{d3e}മിക ചിഹ\u{d4d}നം"),
            keywords: &[
                "ഇസ\u{d4d}ല\u{d3e}ം",
                "ഇസ\u{d4d}ല\u{d3e}മിക ചിഹ\u{d4d}നം",
                "മതം",
                "മ\u{d41}സ\u{d4d}ലീം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("од ба хавирган сар"),
            keywords: &[
                "Муслим",
                "ислам",
                "од ба хавирган сар",
                "од, хавирган сар",
                "шашин",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("तारा आणि च\u{902}द\u{94d}रकोर"),
            keywords: &[
                "इस\u{94d}लाम",
                "तारा आणि च\u{902}द\u{94d}रकोर",
                "धर\u{94d}म",
                "म\u{941}स\u{94d}लीम",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("bintang dan bulan sabit"),
            keywords: &["agama", "bintang dan bulan sabit", "islam", "orang islam"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("stilla u nofs qamar"),
            keywords: &["Islam", "Musulmana", "reliġjon", "stilla u nofs qamar"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ကြယ\u{103a}န\u{103e}င\u{1037}\u{103a} လခြမ\u{103a}း"),
            keywords: &[
                "ကြယ\u{103a}န\u{103e}င\u{1037}\u{103a} လခြမ\u{103a}း",
                "ဘာသာရေး",
                "မ\u{1030}ဆလင\u{103a}",
                "အစ\u{1039}စလာမ\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("stjerne og halvmåne"),
            keywords: &["islam", "muslim", "religion", "stjerne og halvmåne"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("तारा र अर\u{94d}धचन\u{94d}द\u{94d}र"),
            keywords: &[
                "इस\u{94d}लाम",
                "तारा र अर\u{94d}धचन\u{94d}द\u{94d}र",
                "धर\u{94d}म",
                "म\u{941}स\u{94d}लिम",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("wassende maan en ster"),
            keywords: &["islam", "moslim", "religie", "wassende maan en ster"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("stjerne og halvmåne"),
            keywords: &["islam", "muslim", "religion", "stjerne og halvmåne"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ତ\u{b3e}ର\u{b3e} ଏବଂ ଅପ\u{b42}ର\u{b4d}ଣ\u{b4d}ଣ ଚନ\u{b4d}ଦ\u{b4d}ର"),
            keywords: &[
                "ଇସଲ\u{b3e}ମ",
                "ତ\u{b3e}ର\u{b3e} ଏବଂ ଅପ\u{b42}ର\u{b4d}ଣ\u{b4d}ଣ ଚନ\u{b4d}ଦ\u{b4d}ର",
                "ଧର\u{b4d}ମ",
                "ମ\u{b41}ସଲମ\u{b3e}ନ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਤਾਰਾ ਅਤ\u{a47} ਇਸਲਾਮੀ ਰਾਜ ਦਾ ਚਿ\u{a70}ਨ\u{a4d}ਹ"),
            keywords: &[
                "ਇਸਲਾਮ",
                "ਤਾਰਾ ਅਤ\u{a47} ਇਸਲਾਮੀ ਰਾਜ ਦਾ ਚਿ\u{a70}ਨ\u{a4d}ਹ",
                "ਧਰਮ",
                "ਮ\u{a41}ਸਲਿਮ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ستارہ اتے ہلال"),
            keywords: &["اسلام", "ستارہ اتے ہلال", "مذہب", "مسلمان"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Sta An Mun Wé Kọv"),
            keywords: &["Múslim", "Rilíjọn", "Sta An Mun Wé Kọv", "Íslam"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("gwiazda i półksiężyc"),
            keywords: &["gwiazda i półksiężyc", "islam", "muzułmanin", "religia"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("هلال او ستوری"),
            keywords: &["اسلام", "مذهب", "مسلمان", "هلال او ستوری"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("estrela e lua crescente"),
            keywords: &["estrela e lua crescente", "islã", "muçulmano", "religião"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("estrela e lua crescente"),
            keywords: &["Islão", "estrela e lua crescente", "muçulmano", "religião"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("quyllur chaymanta chawpi killa"),
            keywords: &[
                "Musulman",
                "islam",
                "quyllur chaymanta chawpi killa",
                "religion",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("stea și semilună"),
            keywords: &[
                "islamism",
                "musulman",
                "musulmană",
                "religie",
                "stea și semilună",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-056"),
            keywords: &["E10-056"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("звезда и полумесяц"),
            keywords: &[
                "звезда",
                "звезда и полумесяц",
                "ислам",
                "мусульманство",
                "полумесяц",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("inyenyeri n’ukwezi kw’imboneka"),
            keywords: &[
                "Umusilamu",
                "idini",
                "inyenyeri n’ukwezi kw’imboneka",
                "isilamu",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("تارو ۽ چنڊ"),
            keywords: &["اسلام", "تارو ۽ چنڊ", "مذهب", "مسلم"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("අඩසඳ සහ තර\u{dd4}ව"),
            keywords: &[
                "අඩසඳ සහ තර\u{dd4}ව",
                "ආගම",
                "ඉස\u{dca}ල\u{dcf}ම\u{dca}",
                "ම\u{dd4}ස\u{dca}ල\u{dd2}ම\u{dca}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("hviezda a polmesiac"),
            keywords: &["hviezda a polmesiac", "islam", "moslim", "náboženstvo"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("zvezda in polmesec"),
            keywords: &["islam", "muslimansko", "vera", "zvezda in polmesec"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("bil iyo xiddig"),
            keywords: &["Muslim", "bil iyo xiddig", "diin", "islaam"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("yll dhe gjysmëhënë"),
            keywords: &["fe", "islam", "mysliman", "yll dhe gjysmëhënë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("звезда и полумесец"),
            keywords: &["звезда и полумесец", "ислaм", "муслимани", "рeлигиja"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("звијезда и полумјесец"),
            keywords: &["звијезда и полумјесец"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("zvezda i polumesec"),
            keywords: &["islam", "muslimani", "religija", "zvezda i polumesec"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("zvijezda i polumjesec"),
            keywords: &["zvijezda i polumjesec"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("stjärna och halvmåne"),
            keywords: &[
                "halvmåne",
                "islam",
                "muslim",
                "religion",
                "stjärna och halvmåne",
            ],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("nyota na mwezi mwandamo"),
            keywords: &["dini", "muislamu", "nyota na mwezi mwandamo", "uislamu"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("இஸ\u{bcd}ல\u{bbe}ம\u{bcd} சின\u{bcd}னம\u{bcd}"),
            keywords: &[
                "இஸ\u{bcd}ல\u{bbe}மியம\u{bcd}",
                "இஸ\u{bcd}ல\u{bbe}ம\u{bcd} சின\u{bcd}னம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("నక\u{c4d}షత\u{c4d}రం మర\u{c3f}యు చంద\u{c4d}రవంక"),
            keywords: &[
                "ఇస\u{c4d}ల\u{c3e}ం",
                "నక\u{c4d}షత\u{c4d}రం మర\u{c3f}యు చంద\u{c4d}రవంక",
                "మతం",
                "ముస\u{c4d}ల\u{c3f}ం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("ситора ва салиб"),
            keywords: &["Ислом", "дин", "мусулмон", "ситора ва салиб"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("พระจ\u{e31}นทร\u{e4c}เส\u{e35}\u{e49}ยวและดาว"),
            keywords: &[
                "พระจ\u{e31}นทร\u{e4c}เส\u{e35}\u{e49}ยวและดาว",
                "ม\u{e38}สล\u{e34}ม",
                "ศาสนา",
                "อ\u{e34}สลาม",
            ],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ኮኾብ ከምኡ`ውን ቅርጺ ማዕጺድ"),
            keywords: &["ሃይማኖት", "ምስልምና", "ሞስሊም", "ኮኾብ ከምኡ`ውን ቅርጺ ማዕጺድ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ýyldyz we ýarymaý"),
            keywords: &["din", "musulman", "yslam", "ýyldyz we ýarymaý"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("fetuʻu moe kalipa"),
            keywords: &["fakamahometi", "fetuʻu", "fetuʻu moe kalipa", "kalipa"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("ay yıldız"),
            keywords: &["Müslüman", "ay yıldız", "din", "İslam"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("يۇلتۇز ۋە ھىلال ئاي"),
            keywords: &["ئىسلام", "دىن", "مۇسۇلمان", "يۇلتۇز ۋە ھىلال ئاي"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("зірка і півмісяць"),
            keywords: &["зірка і півмісяць", "мусульманин", "релігія", "іслам"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ستارہ اور ہلال"),
            keywords: &["اسلام", "ستارہ اور ہلال", "ستارہ و ہلال", "مذہب", "مسلمان"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("yulduz va yarim oy"),
            keywords: &["din", "islom", "muslim", "yulduz va yarim oy"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("sao và trăng lưỡi liềm"),
            keywords: &[
                "hồi giáo",
                "người theo đạo hồi",
                "sao và trăng lưỡi liềm",
                "tôn giáo",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("biddeew ak weer"),
            keywords: &["Jullit", "biddeew ak weer", "diine", "islam"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("inkwenkwezi neceba"),
            keywords: &["i-Muslim", "i-islam", "inkwenkwezi neceba", "unqulo"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("ìràwọ\u{300} àti òṣùpá tí kò tí yọ tán"),
            keywords: &[
                "Mùsùlùmí",
                "Ìmàle",
                "ìràwọ\u{300} àti òṣùpá tí kò tí yọ tán",
                "ẹ\u{300}sìn",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("星同新月"),
            keywords: &["伊斯蘭教", "宗教", "星同新月", "穆斯林"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("星同新月"),
            keywords: &["伊斯兰教", "宗教", "星同新月", "穆斯林"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("星月"),
            keywords: &["伊斯兰", "宗教", "星月", "穆斯林"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("伊斯蘭教星月"),
            keywords: &["伊斯蘭教星月", "星月"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("星月"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("inkanyezi nocezu lwenyanga"),
            keywords: &[
                "inkanyezi nocezu lwenyanga",
                "inkolo",
                "isulumane",
                "ubusulumane",
            ],
        },
    ],
};
#[doc = "☮\u{fe0f}"]
pub const PEACE_SYMBOL: crate::Emoji = crate::Emoji {
    glyph: "☮\u{fe0f}",
    codepoint: "262E FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "peace symbol",
    group: "Symbols",
    subgroup: "religion",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "☮",
        codepoint: "262E",
        status: crate::Status::Unqualified,
        introduction_version: 1f32,
        name: "peace symbol",
        group: "Symbols",
        subgroup: "religion",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("vredesimbool"),
            keywords: &["vrede", "vredesimbool"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የሰላም ምልክት"),
            keywords: &["ሰላም", "የሰላም ምልክት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("رمز سلام"),
            keywords: &["رمز سلام", "سلام"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("শ\u{9be}ন\u{9cd}তিৰ প\u{9cd}ৰতীক"),
            keywords: &["শ\u{9be}ন\u{9cd}তি", "শ\u{9be}ন\u{9cd}তিৰ প\u{9cd}ৰতীক"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("sülh simvolu"),
            keywords: &["sülh", "sülh simvolu"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("пацыфік"),
            keywords: &["мір", "пацыфік", "сімвал"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("символ на мира"),
            keywords: &["мир", "символ на мира"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("শ\u{9be}ন\u{9cd}তির চিহ\u{9cd}ন"),
            keywords: &["শ\u{9be}ন\u{9cd}তি", "শ\u{9be}ন\u{9cd}তির চিহ\u{9cd}ন"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("arouez ar peocʼh"),
            keywords: &["arouez ar peocʼh", "peocʼh"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("simbol za mir"),
            keywords: &["mir", "simbol za mir"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("símbol de la pau"),
            keywords: &["pau", "símbol", "símbol de la pau"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏅᏩᏙᎯᏯᏛ ᎪᏪᎵ"),
            keywords: &["ᏅᏩᏙᎯᏯᏛ", "ᏅᏩᏙᎯᏯᏛ ᎪᏪᎵ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("symbol míru"),
            keywords: &["mír", "symbol míru"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("symbol hedd"),
            keywords: &["heddwch", "symbol hedd"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("fredssymbol"),
            keywords: &["fred", "fredssymbol"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Friedenszeichen"),
            keywords: &["Friedensbewegung", "Friedenssymbol", "Friedenszeichen"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("σύμβολο ειρήνης"),
            keywords: &["ειρήνη", "σύμβολο ειρήνης"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("peace symbol"),
            keywords: &["peace", "peace symbol"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("símbolo de la paz"),
            keywords: &["paz", "símbolo de la paz"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("rahu sümbol"),
            keywords: &["rahu", "rahu sümbol"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("bakearen ikurra"),
            keywords: &["bake", "bakearen ikurra"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("نماد صلح"),
            keywords: &["صلح", "نماد صلح"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("rauhansymboli"),
            keywords: &["rauha", "rauhansymboli"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("simbolo ng kapayapaan"),
            keywords: &[
                "kapayapaan",
                "katahimikan",
                "simbolo",
                "simbolo ng kapayapaan",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("friðarsymbol"),
            keywords: &["frið", "friðarsymbol", "friður"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("symbole de paix"),
            keywords: &["paix", "symbole de paix"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("siombail síochána"),
            keywords: &["siombail síochána", "síocháin"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("samhla sìthe"),
            keywords: &["menorah", "samhla sìthe"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("símbolo da paz"),
            keywords: &["paz", "símbolo", "símbolo da paz"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("શા\u{a82}તિન\u{ac1}\u{a82} પ\u{acd}રતીક"),
            keywords: &["શા\u{a82}તિ", "શા\u{a82}તિન\u{ac1}\u{a82} પ\u{acd}રતીક"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("alamar zaman lafiya"),
            keywords: &["alamar zaman lafiya", "zaman lafiya"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("סמל השלום"),
            keywords: &["סמל השלום", "שלום"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("शा\u{902}ति का प\u{94d}रतीक"),
            keywords: &["शा\u{902}ति", "शा\u{902}ति का प\u{94d}रतीक"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("simbol mira"),
            keywords: &["mir", "simbol mira"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("békejel"),
            keywords: &["béke", "békejel"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("խաղաղության նշան"),
            keywords: &["խաղաղության նշան", "խաղաղություն"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("simbol damai"),
            keywords: &["damai", "simbol damai"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("akara udo"),
            keywords: &["akara udo", "udo"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("friðartákn"),
            keywords: &["friðartákn", "friður"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("simbolo della pace"),
            keywords: &[
                "Pace e amore",
                "Peace and Love",
                "pace",
                "simbolo della pace",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ピースマーク"),
            keywords: &["ピースマーク", "平和"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("tandha perdhamean"),
            keywords: &["perdhamean", "tandha perdhamean"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მშვიდობის სიმბოლო"),
            keywords: &["მშვიდობა", "მშვიდობის სიმბოლო"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("тыныштық белгісі"),
            keywords: &["тыныштық", "тыныштық белгісі"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("fredssymbol"),
            keywords: &["fred", "fredssymbol"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("សញ\u{17d2}ញាសន\u{17d2}ត\u{17b7}ភាព"),
            keywords: &[
                "សញ\u{17d2}ញា",
                "សញ\u{17d2}ញាសន\u{17d2}ត\u{17b7}ភាព",
                "សន\u{17d2}ត\u{17b7}ភាព",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಶಾಂತ\u{cbf}ಯ ಸಂಕೇತ"),
            keywords: &["ಶಾಂತ\u{cbf}", "ಶಾಂತ\u{cbf}ಯ ಸಂಕೇತ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("평화 기호"),
            keywords: &["평화", "평화 기호"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("शा\u{902}तीच\u{947}\u{902} चिन\u{94d}न"),
            keywords: &["शा\u{902}ती", "शा\u{902}तीच\u{947}\u{902} चिन\u{94d}न"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("тынчтыктын символу"),
            keywords: &["тынчтык", "тынчтыктын символу"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Friddenszeechen"),
            keywords: &["Fridden", "Friddenszeechen"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ສ\u{eb1}ນຍາລ\u{eb1}ກສ\u{eb1}ນຕ\u{eb4}ພາບ"),
            keywords: &[
                "ສ\u{eb1}ນຍາລ\u{eb1}ກສ\u{eb1}ນຕ\u{eb4}ພາບ",
                "ສ\u{eb1}ນຕ\u{eb4}ພາບ",
                "ສ\u{eb1}ນຕ\u{eb4}ສ\u{eb8}ກ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("taikos simbolis"),
            keywords: &["taika", "taikos simbolis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("miera simbols"),
            keywords: &["miera simbols", "miers"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tohu rongomau"),
            keywords: &["rongomau", "tohu rongomau"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("мир"),
            keywords: &["мир", "симбол"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("സമ\u{d3e}ധ\u{d3e}ന ചിഹ\u{d4d}നം"),
            keywords: &["സമ\u{d3e}ധ\u{d3e}ന ചിഹ\u{d4d}നം", "സമ\u{d3e}ധ\u{d3e}നം"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("энх тайвны бэлгэ тэмдэг"),
            keywords: &["энх тайван", "энх тайвны бэлгэ тэмдэг"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("शा\u{902}तीच\u{947} चिन\u{94d}ह"),
            keywords: &["शा\u{902}ती", "शा\u{902}तीच\u{947} चिन\u{94d}ह"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("simbol keamanan"),
            keywords: &["keamanan", "simbol keamanan"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("is-simbolu tal-paċi"),
            keywords: &["is-simbolu tal-paċi", "paċi"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ငြ\u{102d}မ\u{103a}းချမ\u{103a}းရေး အမ\u{103e}တ\u{103a}အသား"),
            keywords: &[
                "ငြ\u{102d}မ\u{103a}းချမ\u{103a}းရေး",
                "ငြ\u{102d}မ\u{103a}းချမ\u{103a}းရေး အမ\u{103e}တ\u{103a}အသား",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("fredssymbol"),
            keywords: &["fred", "fredssymbol"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("शान\u{94d}तिको प\u{94d}रतिक"),
            keywords: &["शान\u{94d}ति", "शान\u{94d}तिको प\u{94d}रतिक"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("vredessymbool"),
            keywords: &["vrede", "vredessymbool"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("fredssymbol"),
            keywords: &["fred", "fredssymbol"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଶ\u{b3e}ନ\u{b4d}ତ\u{b3f} ସଙ\u{b4d}କେତ"),
            keywords: &[
                "ଶ\u{b3e}ନ\u{b4d}ତ\u{b3f}",
                "ଶ\u{b3e}ନ\u{b4d}ତ\u{b3f} ସଙ\u{b4d}କେତ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਅਮਨ ਚਿ\u{a70}ਨ\u{a4d}ਹ"),
            keywords: &["ਅਮਨ", "ਅਮਨ ਚਿ\u{a70}ਨ\u{a4d}ਹ", "ਚ\u{a48}ਨ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("امن دی علامت"),
            keywords: &["امن", "امن دی علامت"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Piís Símbul"),
            keywords: &["Piis", "Piís Símbul"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("symbol pokoju"),
            keywords: &["pacyfa", "symbol pokoju"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د سولې سمبول"),
            keywords: &["د سولې سمبول", "سوله"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("símbolo da paz"),
            keywords: &["paz", "símbolo", "símbolo da paz"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["paz", "símbolo da paz"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("qhasi kay unancha"),
            keywords: &["qhasi kay", "qhasi kay unancha"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("semnul păcii"),
            keywords: &["pace", "semnul păcii"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-057"),
            keywords: &["E10-057"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("пацифик"),
            keywords: &["значок", "мир", "пацифизм", "пацифик", "символ"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ikimenyetso cy’amahoro"),
            keywords: &["amahoro", "ikimenyetso cy’amahoro"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("امن جي نشاني"),
            keywords: &["امن", "امن جي نشاني"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ස\u{dcf}ම සංකේතය"),
            keywords: &["ස\u{dcf}ම සංකේතය", "ස\u{dcf}මය"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("symbol mieru"),
            keywords: &["mier", "symbol mieru"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("simbol za mir"),
            keywords: &["mir", "simbol za mir"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("calaamadda nabadda"),
            keywords: &["calaamadda nabadda", "nabad"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("simboli i paqes"),
            keywords: &["faqe", "simboli i paqes"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("симбол мира"),
            keywords: &["мир", "симбол мира"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("simbol mira"),
            keywords: &["mir", "simbol mira"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("fredssymbol"),
            keywords: &["fred", "fredssymbol", "peace"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("alama ya amani"),
            keywords: &["alama ya amani", "amani"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("அமைதி சின\u{bcd}னம\u{bcd}"),
            keywords: &["அமைதி சின\u{bcd}னம\u{bcd}", "சம\u{bbe}த\u{bbe}னம\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("శ\u{c3e}ంత\u{c3f}"),
            keywords: &["శ\u{c3e}ంత\u{c3f}", "సంధ\u{c3f}"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("аломати \"сулҳ\""),
            keywords: &["аломати \"сулҳ\"", "сулҳ"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เคร\u{e37}\u{e48}องหมายส\u{e31}นต\u{e34}ภาพ"),
            keywords: &[
                "ส\u{e31}นต\u{e34}",
                "ส\u{e31}นต\u{e34}ภาพ",
                "ส\u{e31}นต\u{e34}ส\u{e38}ข",
                "เคร\u{e37}\u{e48}องหมายส\u{e31}นต\u{e34}ภาพ",
            ],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ናይ ሰላም ኣርማ"),
            keywords: &["ሰላም", "ናይ ሰላም ኣርማ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("parahatçylygyň nyşany"),
            keywords: &["parahatçylygyň nyşany", "parahatçylyk"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("ʻilonga fakamelino"),
            keywords: &["melino", "ʻilonga", "ʻilonga fakamelino"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("barış sembolü"),
            keywords: &["barış", "barış sembolü"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("تىنچلىق بەلگىسى"),
            keywords: &["تىنچلىق", "تىنچلىق بەلگىسى"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("символ миру"),
            keywords: &["мир", "символ миру"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("امن کا نشان"),
            keywords: &["امن", "امن کا نشان", "نشان"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("tinchlik ramzi"),
            keywords: &["tinchlik", "tinchlik ramzi"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("biểu tượng hòa bình"),
            keywords: &["biểu tượng hòa bình", "hòa bình"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("màndarga jàmm"),
            keywords: &["jàmm", "màndarga jàmm"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("isimboli yoxolo"),
            keywords: &["isimboli yoxolo", "uxolo"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("àmì àláàáfíà"),
            keywords: &["àláàáfíà", "àmì àláàáfíà"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("和平符號"),
            keywords: &["和平", "和平符號"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("和平符号"),
            keywords: &["和平", "和平符号"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("和平符号"),
            keywords: &["和平", "和平符号"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("和平"),
            keywords: &["和平"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("和平符號"),
            keywords: &["和平", "和平符號"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("uphawu lokuthula"),
            keywords: &["ukuthula", "uphawu lokuthula"],
        },
    ],
};
#[doc = "🕎"]
pub const MENORAH: crate::Emoji = crate::Emoji {
    glyph: "🕎",
    codepoint: "1F54E",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "menorah",
    group: "Symbols",
    subgroup: "religion",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("menora"),
            keywords: &["godsdiens", "kandelaber", "kershouer", "menora"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ሜኖራሃ"),
            keywords: &["ሜኖራሃ", "ኃይማኖት", "ካንድልቡረም", "የሻማ መቅረዝ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("\u{202b}شمعدان شعار اليهودية"),
            keywords: &["دين", "شموع", "\u{202b}شمعدان شعار اليهودية"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("মমব\u{9be}তি গছ\u{9be}"),
            keywords: &[
                "দীপ\u{9be}ধ\u{9be}ৰ",
                "ধৰ\u{9cd}ম",
                "মমব\u{9be}তি গছ\u{9be}",
                "স\u{9c1}দ\u{9c3}শ\u{9cd}য দীপ\u{9be}ধ\u{9be}ৰ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("hanukiya"),
            keywords: &["din", "hanukiya", "kandelyabr", "şamdan"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("сямісвечнік"),
            keywords: &["Ханука", "падсвечнік", "рэлігія", "свечка", "сямісвечнік"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("менора"),
            keywords: &["менора", "религия", "свещник"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("মেনোর\u{9be}"),
            keywords: &[
                "দীপ\u{9be}ধ\u{9be}র",
                "ধর\u{9cd}ম",
                "ব\u{9be}তিদ\u{9be}ন",
                "মেনোর\u{9be}",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("menorah"),
            keywords: &["menorah", "relijion"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("menora"),
            keywords: &["menora", "religija", "svijeća", "svijećnjak"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("canelobre de set braços"),
            keywords: &[
                "canelobre",
                "canelobre de set braços",
                "menorà",
                "religió",
                "set braços",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎦᎵᏉᎩ ᏗᏨᏍᏗ"),
            keywords: &["ᎠᏨᏍᏗ ᎦᎪᏗ", "ᎤᎧᎾᏫ ᎠᏨᏍᏗ", "ᎤᏃᎯᏳᏒᎢ", "ᎦᎵᏉᎩ ᏗᏨᏍᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("sedmiramenný svícen"),
            keywords: &["menora", "náboženství", "sedmiramenný svícen", "svícen"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("menorah"),
            keywords: &["canhwyllbren", "crefydd", "menorah", "sêr canhwyllau"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("syvarmet lysestage"),
            keywords: &["lysestage", "religion", "syvarmet lysestage"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Menora"),
            keywords: &["Leuchter", "Menora", "Religion"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("επτάφωτη λυχνία"),
            keywords: &["επτάφωτη λυχνία", "θρησκεία", "κηροπήγιο", "μενορά"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("menorah"),
            keywords: &["candelabrum", "candlestick", "menorah", "religion"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("menorá"),
            keywords: &["candelabro", "menorá", "religión"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["candelabro", "judaísmo", "judío", "menorá", "religión"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["candelabro", "menorá", "religión", "vela"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("menoraa"),
            keywords: &["küünlajalg", "menoraa", "usk"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("menorah"),
            keywords: &["erlijio", "menorah", "zutargi"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("منورا"),
            keywords: &["جای شمع", "مذهب", "منورا"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("menora"),
            keywords: &[
                "juutalaisuus",
                "kynttilä",
                "menora",
                "seitsenhaarainen",
                "uskonto",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("menorah"),
            keywords: &[
                "Hudyo",
                "Judaism",
                "Judaismo",
                "kandelabra",
                "menorah",
                "relihiyon",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("menorah"),
            keywords: &["ljósastaki", "menorah", "religión", "trúgv", "átrúnaður"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("chandelier à sept branches"),
            keywords: &[
                "chandelier",
                "chandelier à sept branches",
                "menora",
                "religion",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("menora"),
            keywords: &["chandelier", "menora", "religion"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("meanóra"),
            keywords: &["coinnleoir", "coinnleoir craobhach", "creideamh", "meanóra"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("menorah"),
            keywords: &["coinnlear", "coinnlear meurach", "creideamh", "menorah"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("menorá"),
            keywords: &["7 brazos", "candelabro", "menorá", "relixión", "xudaísmo"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("મ\u{ac7}નોરાહ"),
            keywords: &[
                "ક\u{ac7}ન\u{acd}ડલસ\u{acd}ટિક",
                "ધર\u{acd}મ",
                "મ\u{ac7}નોરાહ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("menorah"),
            keywords: &["addini", "alkukin", "candelabrum", "menorah"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("חנוכיה"),
            keywords: &["דת", "חנוכה", "חנוכיה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("म\u{947}नोरा"),
            keywords: &[
                "दीपाधार",
                "दीपाधार, मोमबत\u{94d}ती",
                "धर\u{94d}म",
                "म\u{947}नोरा",
                "मोमबत\u{94d}ती",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("menora"),
            keywords: &["menora", "religija", "svijećnjak"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("menóra"),
            keywords: &["gyertyatartó", "menóra", "vallás"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("մենորա"),
            keywords: &["աշտանակ", "կրոն", "մենորա", "մոմակալ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("menorah"),
            keywords: &["agama", "candelabra", "menorah", "tempat lilin"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("menorah"),
            keywords: &[
                "kandelabrum",
                "menorah",
                "okpukperechi",
                "osisikandụ\u{300}l",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("menorah-ljósastika"),
            keywords: &[
                "ljósastjaki",
                "margálma kertastjaki",
                "menorah-ljósastika",
                "trúarbrögð",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("Menorah"),
            keywords: &["Ebraismo", "Menorah", "candelabro", "sette bracci"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("メノーラー"),
            keywords: &["メノラー", "メノーラー", "ユダヤ教", "宗教", "燭台"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("menorah lilin"),
            keywords: &["agama", "lilin", "menorah", "wadhah lilin sanga"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მენორა"),
            keywords: &["მენორა", "რელიგია", "სანთლები", "საშანდლე"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("менора"),
            keywords: &["дін", "канделябр", "менора", "шамдал"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("syvarmet lysestage"),
            keywords: &["lysestage", "religion", "syvarmet lysestage"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("សញ\u{17d2}ញាជើងទៀនជាជ\u{17bd}រ"),
            keywords: &["ជើងទៀន", "សញ\u{17d2}ញា", "សញ\u{17d2}ញាជើងទៀនជាជ\u{17bd}រ"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಸಪ\u{ccd}ತ ದೀಪಸ\u{ccd}ತಂಭ"),
            keywords: &[
                "ಕ\u{ccd}ಯಾಂಡಲ\u{ccd}",
                "ಕ\u{ccd}ಯಾಂಡಲ\u{ccd}\u{200c}ಸ\u{ccd}ಟ\u{cbf}ಕ\u{ccd}",
                "ಚ\u{cbf}ಹ\u{ccd}ನ\u{cc6}",
                "ಧಾರ\u{ccd}ಮ\u{cbf}ಕ",
                "ಸಪ\u{ccd}ತ ದೀಪಸ\u{ccd}ತಂಭ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("메노라"),
            keywords: &["메노라", "유대교", "촛대"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("मनोरा"),
            keywords: &[
                "क\u{901}डलस\u{94d}टिक",
                "क\u{901}डलाब\u{94d}रम",
                "धर\u{94d}म",
                "मनोरा",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("менора"),
            keywords: &["дин", "менора", "шам койгуч"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Menorah"),
            keywords: &["Käerzestänner", "Menorah", "Relioun"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ສ\u{eb1}ນຍາລ\u{eb1}ກໂຄມປ\u{eb1}ກທຽນ"),
            keywords: &["ທຽນ", "ສ\u{eb1}ນຍາລ\u{eb1}ກໂຄມປ\u{eb1}ກທຽນ", "ສາສະໜາ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("menora"),
            keywords: &["menora", "religija", "žvakidė", "žvakės"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("menora"),
            keywords: &["menora", "reliģija", "svečturis"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("menoraha"),
            keywords: &[
                "menoraha",
                "momo karakia",
                "tūnga kānara",
                "whatanga-kānara",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("менора"),
            keywords: &["менора", "религија", "јудаизам"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("മെന\u{d3e}റോ"),
            keywords: &[
                "മതം",
                "മെന\u{d3e}റോ",
                "മെഴ\u{d41}ക\u{d41}തിരി",
                "മെഴ\u{d41}ക\u{d41}തിരിക\u{d4d}ക\u{d3e}ൽ",
                "മെഴ\u{d41}ക\u{d41}തിരിസ\u{d4d}\u{200c}റ\u{d4d}റിക\u{d4d}ക\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("лааны суурь"),
            keywords: &["лааны суурь", "шүтлэг"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("मिनोराह"),
            keywords: &[
                "धर\u{94d}म",
                "मिनोराह",
                "म\u{947}णबत\u{94d}ती",
                "म\u{947}णबत\u{94d}ती ठावायच\u{947} घर",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("menorah"),
            keywords: &["agama", "kaki lilin", "kandelabrum", "menorah"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("menora"),
            keywords: &["gandelabru", "gandlier", "menora", "reliġjon"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဖယောင\u{103a}းတ\u{102d}\u{102f}င\u{103a}စင\u{103a}"),
            keywords: &[
                "ဖယောင\u{103a}းတ\u{102d}\u{102f}င\u{103a}စင\u{103a}",
                "ဘာသာရေး",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("menora"),
            keywords: &["lysestake", "menora", "religion"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("मनोराह"),
            keywords: &[
                "क\u{94d}यान\u{94d}ड\u{947}लस\u{94d}टिक",
                "क\u{94d}यान\u{94d}ड\u{947}लाब\u{94d}रम",
                "धर\u{94d}म",
                "मनोराह",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("menora"),
            keywords: &["kandelaar", "kandelaber", "menora", "religie"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("menora"),
            keywords: &["lysestake", "menora", "religion"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ମେନୋର\u{b3e}ହ"),
            keywords: &[
                "କ\u{b3e}ଣ\u{b4d}ଡେଲବ\u{b4d}ରମ\u{b4d}\u{200c}",
                "ଧର\u{b4d}ମ",
                "ମହମବତ\u{b3f}",
                "ମେନୋର\u{b3e}ହ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਮ\u{a4b}ਮਬ\u{a71}ਤੀ ਸਟ\u{a48}\u{a02}ਡ"),
            keywords: &[
                "ਕ\u{a48}\u{a02}ਡਲ ਹ\u{a4b}ਲਡਰ",
                "ਧਰਮ",
                "ਮ\u{a4b}ਮਬ\u{a71}ਤੀ",
                "ਮ\u{a4b}ਮਬ\u{a71}ਤੀ ਸਟ\u{a48}\u{a02}ਡ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("نو باوواں آلا شمع دان"),
            keywords: &["ج\u{64e}ل چراغ", "شمع دان", "مذہب", "نو باوواں آلا شمع دان"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Mẹnóra"),
            keywords: &[
                "Kándúlstand",
                "Kándúlstand Wé Gẹ\u{301}t Pás Wọ\u{301}n Hand",
                "Kándúlábrum",
                "Mẹnóra",
                "Rilíjọn",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("menora"),
            keywords: &["kandelabr", "menora", "religia", "świecznik"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("مینوره"),
            keywords: &["مذهب", "مينوره", "مینوره", "کينډلبرم", "کينډلسټک"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("menorá"),
            keywords: &["candelabro", "castiçal", "menorá", "religião"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("menorá"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("menorah"),
            keywords: &["candelabro", "candelero", "menorah", "monorah", "relligion"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("menorah"),
            keywords: &["menorah", "religie", "sfeșnic"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-767"),
            keywords: &["E10-767"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("менора"),
            keywords: &[
                "менора",
                "подсвечник",
                "религия",
                "свечи",
                "ханука",
                "ханукия",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("menora"),
            keywords: &[
                "buji",
                "iyobokamana",
                "menora",
                "umutako uriho buji nyinshi",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("مينوره"),
            keywords: &["مذهب", "مينوره", "ميڻ بتي", "ڏيئو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("මෙනොර\u{dcf}"),
            keywords: &[
                "ආගම",
                "ඉට\u{dd2}පන\u{dca}දම\u{dca} ක\u{dd6}ර",
                "ඉට\u{dd2}පන\u{dca}දම\u{dca} පහන",
                "මෙනොර\u{dcf}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("menóra"),
            keywords: &["menóra", "náboženstvo", "svietnik", "židovstvo"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("menora"),
            keywords: &["menora", "namizni svečnik", "svečnik", "vera"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("shumac caabudaan Yuhuudda"),
            keywords: &[
                "caabudidaa shumaca ee Yuhuudda",
                "diin",
                "shumac caabudaan Yuhuudda",
                "shumac weyn",
                "ulaha shumaca",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("hanukia"),
            keywords: &["fe", "hanukia", "shandan"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("менора"),
            keywords: &["менора", "рeлигиja", "свeћњaк", "свећа"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["менора"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("menora"),
            keywords: &["menora", "religija", "sveća", "svećnjak"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["menora"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("menora"),
            keywords: &["judendom", "ljusstake", "menora"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("menorah"),
            keywords: &[
                "dini",
                "kinara cha mishumaa",
                "kinara cha mishumaa mingi",
                "menorah",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("மெழுகுவர\u{bcd}த\u{bcd}தி ஸ\u{bcd}டிக\u{bcd}"),
            keywords: &[
                "மெழுகுவர\u{bcd}த\u{bcd}தி ஏற\u{bcd}றுதல\u{bcd}",
                "மெழுகுவர\u{bcd}த\u{bcd}தி ஸ\u{bcd}டிக\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("మ\u{c46}న\u{c4b}ర\u{c3e}"),
            keywords: &[
                "క\u{c4a}వ\u{c4d}వ\u{c4a}త\u{c4d}త\u{c3f}",
                "మతం",
                "మ\u{c46}న\u{c4b}ర\u{c3e}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("менораҳ"),
            keywords: &["дин", "менораҳ", "шамъдон", "қандил"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เช\u{e34}งเท\u{e35}ยน 7 ก\u{e34}\u{e48}ง"),
            keywords: &[
                "ศาสนา",
                "เช\u{e34}งเท\u{e35}ยน",
                "เช\u{e34}งเท\u{e35}ยน 7 ก\u{e34}\u{e48}ง",
                "เท\u{e35}ยน",
            ],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("7 ቀንዴል"),
            keywords: &["7 ቀንዴል", "ሃይማኖት", "ቀንዴል"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("menora"),
            keywords: &["din", "menora", "şem", "şemdan"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("menola"),
            keywords: &["menola"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("Yahudi şamdanı"),
            keywords: &["Yahudi şamdanı", "din", "menora", "mum", "şamdan"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("قەندىل"),
            keywords: &["دىن", "قەندىل", "قەندەل", "قەندەل قويغۇچ"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("менора"),
            keywords: &["канделябр", "менора", "підсвічник", "релігія"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("مینورہ"),
            keywords: &["مذہب", "مینورہ", "کینڈل اسٹک"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("yadaim"),
            keywords: &["din", "yadaim"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("cây đèn menorah"),
            keywords: &["cây đèn menorah", "cây đèn nến", "giá đỡ nến", "tôn giáo"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("menorah"),
            keywords: &["diine", "menorah", "sondeel", "tegukaayu sondeel"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("i-menorah"),
            keywords: &[
                "i-candelabrum",
                "i-menorah",
                "isiphatho sekhandlela",
                "unqulo",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("menorah"),
            keywords: &[
                "menorah",
                "ìdúró kándù",
                "ìdúró àbé\u{329}là",
                "ẹ\u{300}sìn",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("燭台"),
            keywords: &["大燭台", "宗教", "燭台"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("烛台"),
            keywords: &["大烛台", "宗教", "烛台"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("烛台"),
            keywords: &["光明节", "宗教", "灯台", "烛台"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("猶太燭台"),
            keywords: &["猶太燭台"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("光明節燈台"),
            keywords: &["光明節燈台"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("imenora"),
            keywords: &["i-candelabrum", "imenora", "induku yekhandlela", "inkolo"],
        },
    ],
};
#[doc = "🔯"]
pub const DOTTED_SIX_POINTED_STAR: crate::Emoji = crate::Emoji {
    glyph: "🔯",
    codepoint: "1F52F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "dotted six-pointed star",
    group: "Symbols",
    subgroup: "religion",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("sespuntster met kol"),
            keywords: &["fortuin", "sespuntster met kol", "ster"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ባለነጥብ ስድስት አንጓ ኮከብ"),
            keywords: &["ሀብት", "ባለነጥብ ስድስት አንጓ ኮከብ", "ኮከብ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("نجمة سداسية"),
            keywords: &["تنجيم", "نجمة", "نجمة سداسية"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ষষ\u{9cd}ঠম\u{9c1}খী বিন\u{9cd}দ\u{9c1}য\u{9c1}ক\u{9cd}ত তৰ\u{9be}"),
            keywords: &[
                "তৰ\u{9be}",
                "ভ\u{9be}গ\u{9cd}য",
                "ষষ\u{9cd}ঠম\u{9c1}খী বিন\u{9cd}দ\u{9c1}য\u{9c1}ক\u{9cd}ত তৰ\u{9be}",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("nöqtəli altıguşəli ulduz"),
            keywords: &["nöqtəli altıguşəli ulduz", "ulduz", "var-dövlət"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("шасціканцовая зорка з кропкай"),
            keywords: &[
                "Давід",
                "зорка",
                "шасціканцовая",
                "шасціканцовая зорка з кропкай",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("шестолъчна звезда с точка"),
            keywords: &["звезда", "съдба", "шестолъчна звезда с точка"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ডট-য\u{9c1}ক\u{9cd}ত ছটি পয\u{9bc}েন\u{9cd}টের ত\u{9be}র\u{9be}"),
            keywords: &[
                "ডট-য\u{9c1}ক\u{9cd}ত ছটি পয\u{9bc}েন\u{9cd}টের ত\u{9be}র\u{9be}",
                "ত\u{9be}র\u{9be}",
                "সৌভ\u{9be}গ\u{9cd}য",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("steredenn cʼhwecʼh brecʼh"),
            keywords: &["chañs", "steredenn", "steredenn cʼhwecʼh brecʼh"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("šestokraka zvijezda s tačkom u sredini"),
            keywords: &["zvijezda", "šestokraka zvijezda s tačkom u sredini"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("estrella de sis puntes amb punt"),
            keywords: &[
                "estrella",
                "estrella de sis puntes amb punt",
                "fortuna",
                "punt",
                "sis puntes",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᏅᏥ ᏑᏓᎵ-ᏕᎪᏍᏓᏯ ᏃᏈᏏ"),
            keywords: &["ᎤᏅᏥ ᏑᏓᎵ-ᏕᎪᏍᏓᏯ ᏃᏈᏏ", "ᎤᏪᎿ", "ᏃᏈᏏ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("šesticípá hvězda s tečkou uprostřed"),
            keywords: &[
                "hvězda",
                "šesticípá hvězda s tečkou uprostřed",
                "štěstí",
                "štěstěna",
                "šťastná",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("seren chwe ochr dotiog"),
            keywords: &["ffortiwn", "seren", "seren chwe ochr dotiog"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("sekstakket stjerne med prik"),
            keywords: &["horoskop", "sekstakket stjerne med prik", "stjerne"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Hexagramm mit Punkt"),
            keywords: &["Hexagramm mit Punkt", "Wahrsager"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("εξάλφα με σημάδι"),
            keywords: &["αστέρι", "εξάλφα με σημάδι", "τύχη"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("dotted six-pointed star"),
            keywords: &["dotted six-pointed star", "fortune", "star"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("estrella de seis puntas"),
            keywords: &[
                "adivinación",
                "buena fortuna",
                "estrella",
                "estrella de seis puntas",
                "seis puntas",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("estrella de seis puntas"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &[
                "David",
                "estrella de David",
                "estrella de seis puntas",
                "hexagrama",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("punktiga kuusnurkne täht"),
            keywords: &["punktiga kuusnurkne täht", "täht", "õnn"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("erdian puntu bat duen sei puntako izarra"),
            keywords: &["erdian puntu bat duen sei puntako izarra", "izar", "zorte"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("ستاره\u{654} شش\u{200c}پر"),
            keywords: &["اقبال", "بخت", "ستاره", "ستاره\u{654} شش\u{200c}پر"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kuusisakarainen tähti pisteellä"),
            keywords: &[
                "kuusisakarainen tähti pisteellä",
                "onnentähti",
                "tähti",
                "uskonto",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("six-pointed star na may tuldok"),
            keywords: &[
                "David",
                "Hudyo",
                "Judaism",
                "bituin",
                "relihiyon",
                "six-pointed star na may tuldok",
                "tuldok",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("stjørna við seks spískum"),
            keywords: &["eydna", "lagna", "stjørna", "stjørna við seks spískum"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("étoile à 6 branches"),
            keywords: &["chance", "étoile", "étoile à 6 branches"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("étoile à 6 branches et point au milieu"),
            keywords: &[
                "6 branches",
                "fortune",
                "six branches",
                "étoile",
                "étoile à 6 branches et point au milieu",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("réalta shé-rinneach le ponc sa lár"),
            keywords: &[
                "réalta shé-rinneach le ponc sa lár",
                "réalta sé-rinneach agus ponc sa lár",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("rionnag shia-rinneach dhotagach"),
            keywords: &[
                "fortan",
                "reul",
                "rionnag",
                "rionnag shia-rinneach dhotagach",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("estrela de seis puntas con punto"),
            keywords: &[
                "adiviñación",
                "estrela de David",
                "estrela de seis puntas con punto",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("છ-પોઇ\u{a82}ટવાળો તારો"),
            keywords: &[
                "છ-પોઇ\u{a82}ટવાળો",
                "તારો",
                "ભાગ\u{acd}ય",
                "ભાગ\u{acd}ય કથન",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("tauraro mai tsini-shida mai ɗigo"),
            keywords: &["dukiya", "tauraro", "tauraro mai tsini-shida mai ɗigo"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("מגן דוד עם נקודה באמצע"),
            keywords: &["דת", "יהדות", "יהודי", "מגן דוד", "מגן דוד עם נקודה באמצע"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("छह म\u{941}खी तारा, भविष\u{94d}य"),
            keywords: &[
                "छह म\u{941}खी तारा",
                "छह म\u{941}खी तारा, भविष\u{94d}य",
                "छह सिर\u{947}",
                "तारा",
                "भविष\u{94d}य",
                "भविष\u{94d}य बताना",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("šesterokraka zvijezda s točkom"),
            keywords: &["sreća", "zvijezda", "šesterokraka zvijezda s točkom"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("hatágú csillag ponttal"),
            keywords: &["csillag", "hatágú csillag ponttal", "szerencse"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("կետիկով վեցթևանի աստղ"),
            keywords: &["աստղ", "բախտ", "կետիկով վեցթևանի աստղ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("bintang sudut enam bertitik"),
            keywords: &["bintang", "bintang sudut enam bertitik", "ramalan"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("nwere ntụpọ nrụaka kpakpando-isii"),
            keywords: &["kpakpando", "nwere ntụpọ nrụaka kpakpando-isii", "uru"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("sexhyrnd stjarna"),
            keywords: &["sexhyrnd", "spá", "spádómur", "stjarna"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("stella a sei punte"),
            keywords: &[
                "chiromanzia",
                "futuro",
                "sei punte",
                "stella",
                "stella a sei punte",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("六芒星"),
            keywords: &["ダビデ", "六芒星", "六角星", "占い", "星"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("lintang mata enem mawa titik tengah"),
            keywords: &["kabegjan", "lintang", "lintang mata enem mawa titik tengah"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("შემოზღუდული ექვსქიმიანი ვარსკვლავი"),
            keywords: &[
                "ვარსკვლავი",
                "მომავალი",
                "შემოზღუდული ექვსქიმიანი ვარსკვლავი",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("нүктелі алты бұрышты жұлдыз"),
            keywords: &["жұлдыз", "нүктелі алты бұрышты жұлдыз", "сәттілік"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("sekstakket stjerne med prik"),
            keywords: &["horoskop", "sekstakket stjerne med prik", "stjerne"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("សញ\u{17d2}ញាផ\u{17d2}កាយម\u{17bb}ខប\u{17d2}រា\u{17c6}ម\u{17bd}យ"),
            keywords: &[
                "ប\u{17d2}រា\u{17c6}ម\u{17bd}យ",
                "ផ\u{17d2}កាយ",
                "សញ\u{17d2}ញា",
                "សញ\u{17d2}ញាផ\u{17d2}កាយម\u{17bb}ខប\u{17d2}រា\u{17c6}ម\u{17bd}យ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಚುಕ\u{ccd}ಕ\u{cc6}ಗಳ ಆರು ಬ\u{cbf}ಂದುಗಳ ನಕ\u{ccd}ಷತ\u{ccd}ರ"),
            keywords: &[
                "ಅದೃಷ\u{ccd}ಟ",
                "ಆರು ಬ\u{cbf}ಂದುಗಳ ನಕ\u{ccd}ಷತ\u{ccd}ರದ",
                "ಚುಕ\u{ccd}ಕ\u{cc6}ಗಳ ಆರು ಬ\u{cbf}ಂದುಗಳ ನಕ\u{ccd}ಷತ\u{ccd}ರ",
                "ನಕ\u{ccd}ಷತ\u{ccd}ರ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("육각 별"),
            keywords: &["별", "육각 별", "육각형 별"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some(
                "बि\u{902}द\u{941}\u{902}च\u{947}\u{902} स-आ\u{902}सा\u{902}च\u{947}\u{902} नख\u{947}त\u{94d}र",
            ),
            keywords: &[
                "नख\u{947}त\u{94d}र",
                "फॉर\u{94d}च\u{94d}य\u{941}न",
                "बि\u{902}द\u{941}\u{902}च\u{947}\u{902} स-आ\u{902}सा\u{902}च\u{947}\u{902} नख\u{947}त\u{94d}र",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("чекиттүү алты жылдыз"),
            keywords: &["жылдыз", "тагдыр", "чекиттүү алты жылдыз"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("sechszackege Stär mat Punkt an der Mëtt"),
            keywords: &["Gléck", "Stär", "sechszackege Stär mat Punkt an der Mëtt"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ດາວຫ\u{ebc}\u{ebb}ກແຈມ\u{eb5}ຈ\u{ecd}\u{ec9}າຢ\u{eb9}\u{ec8}ກາງ"),
            keywords: &[
                "ຈ\u{ecd}\u{ec9}າກາງ",
                "ດາວ",
                "ດາວຫ\u{ebc}\u{ebb}ກແຈມ\u{eb5}ຈ\u{ecd}\u{ec9}າຢ\u{eb9}\u{ec8}ກາງ",
                "ຫ\u{ebc}\u{ebb}ກແຈ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("šešiakampė žvaigždė su tašku"),
            keywords: &["sėkmė", "šešiakampė žvaigždė su tašku", "žvaigždė"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("sešstaru zvaigzne ar punktu vidū"),
            keywords: &["laime", "sešstaru zvaigzne ar punktu vidū", "zvaigzne"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("whetū ono-pito iraira"),
            keywords: &["matakite", "whetū", "whetū ono-pito iraira"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("шестокрака ѕвезда со точка"),
            keywords: &[
                "религија",
                "шестокрака ѕвезда со точка",
                "ѕвезда",
                "јудаизам",
            ],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഭ\u{d3e}വി പ\u{d4d}രവചനം"),
            keywords: &[
                "ആറ\u{d4d} മ\u{d42}ലകള\u{d41}ള\u{d4d}ള നക\u{d4d}ഷത\u{d4d}രം",
                "നക\u{d4d}ഷത\u{d4d}രം",
                "ഭ\u{d3e}വി",
                "ഭ\u{d3e}വി പ\u{d4d}രവചനം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("6 хошуутай од"),
            keywords: &["6", "6 хошуутай од", "од", "хошуу"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("बि\u{902}द\u{942} असल\u{947}ला सहा टोका\u{902}चा तारा"),
            keywords: &[
                "तारा",
                "बि\u{902}द\u{942} असल\u{947}ला सहा टोका\u{902}चा तारा",
                "भविष\u{94d}य",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("bintang berpenjuru enam berbintik"),
            keywords: &["bintang", "bintang berpenjuru enam berbintik", "nasib"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("stilla bit-tikek b’sitt ponot"),
            keywords: &["fortuna", "stilla", "stilla bit-tikek b’sitt ponot"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "အစက\u{103a}ချထားသည\u{1037}\u{103a} ခြောက\u{103a}ထောင\u{1037}\u{103a}ကြယ\u{103a}",
            ),
            keywords: &[
                "က\u{1036}",
                "ကြယ\u{103a}",
                "အစက\u{103a}ချထားသည\u{1037}\u{103a} ခြောက\u{103a}ထောင\u{1037}\u{103a}ကြယ\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("sekstagget stjerne med prikk"),
            keywords: &[
                "magi",
                "sekskantet",
                "sekstagget stjerne med prikk",
                "stjerne",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("डट गर\u{947}को-छ-विन\u{94d}द\u{942} तारा"),
            keywords: &[
                "डट गर\u{947}को-छ-विन\u{94d}द\u{942} तारा",
                "तारा",
                "भाग\u{94d}य",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("zespuntige ster"),
            keywords: &["ster", "waarzeggen", "zespuntige ster"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("sekstagga stjerne med prikk"),
            keywords: &[
                "magi",
                "sekskanta",
                "sekstagga stjerne med prikk",
                "stjerne",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some(
                "ବ\u{b3f}ନ\u{b4d}ଦ\u{b41}ଯ\u{b41}କ\u{b4d}ତ ଛଅ-ପଏଣ\u{b4d}ଟ ବ\u{b3f}ଶ\u{b3f}ଷ\u{b4d}ଟ ତ\u{b3e}ର\u{b3e}",
            ),
            keywords: &[
                "ତ\u{b3e}ର\u{b3e}",
                "ଫର\u{b4d}ଚ\u{b4d}ୟ\u{b42}ନ\u{b4d}\u{200c}",
                "ବ\u{b3f}ନ\u{b4d}ଦ\u{b41}ଯ\u{b41}କ\u{b4d}ତ ଛଅ-ପଏଣ\u{b4d}ଟ ବ\u{b3f}ଶ\u{b3f}ଷ\u{b4d}ଟ ତ\u{b3e}ର\u{b3e}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਛ\u{a47}-ਬਿ\u{a70}ਦ\u{a42} ਤਾਰਾ"),
            keywords: &["ਕਿਸਮਤ", "ਕਿਸਮਤ ਦਸਣਾ", "ਛ\u{a47}-ਬਿ\u{a70}ਦ\u{a42}", "ਤਾਰਾ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("نقطہ لگے چھے ـ نوکدار ستارے"),
            keywords: &["تارہ", "قسمت", "نقطہ لگے چھے ـ نوکدار ستارے"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Síks Pọínt Sta Wit Dọt Fọ Mídul"),
            keywords: &[
                "Bíg Mọní",
                "Fọ\u{301}tiun",
                "Lọk",
                "Ríchis",
                "Sta",
                "Síks Pọínt Sta Wit Dọt Fọ Mídul",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("gwiazda sześcioramienna z kropką"),
            keywords: &["gwiazda sześcioramienna z kropką", "szczęście"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("داغدار شپږ ګوټی ستوری"),
            keywords: &["داغدار شپږ ګوټی ستوری", "ستوری", "نصيب"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("estrela de seis pontas"),
            keywords: &[
                "adivinhação",
                "destino",
                "estrela de seis pontas",
                "seis pontas",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("estrela de seis pontas com ponto"),
            keywords: &["estrela", "estrela de seis pontas com ponto", "sorte"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("suqta ñawpinkunawan quyllur"),
            keywords: &["fortuna", "quyllur", "suqta ñawpinkunawan quyllur"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("stea cu șase colțuri și punct în centru"),
            keywords: &["noroc", "stea", "stea cu șase colțuri și punct în centru"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-747"),
            keywords: &["E10-747"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("шестиконечная звезда"),
            keywords: &["звезда", "звезда Давида", "шестиконечная звезда"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("inyenyeri ifite amaguru atandatu"),
            keywords: &["amahirwe", "inyenyeri", "inyenyeri ifite amaguru atandatu"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڊاٽ وارو ڇھ نقطن وارو تارو"),
            keywords: &["ستارو", "قسمت", "ڊاٽ وارو ڇھ نقطن وارو تارو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ත\u{dd2}ත\u{dca} සහ\u{dd2}ත කොණ\u{dca}-6 තර\u{dd4}ව"),
            keywords: &[
                "තර\u{dd4}ව",
                "ත\u{dd2}ත\u{dca} සහ\u{dd2}ත කොණ\u{dca}-6 තර\u{dd4}ව",
                "ව\u{dcf}සන\u{dcf}ව",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("šesťcípa hviezda s bodkou uprostred"),
            keywords: &["hviezda", "šesťcípa hviezda s bodkou uprostred", "šťastie"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("šestkraka zvezda s piko"),
            keywords: &["sreča", "zvezda", "šestkraka zvezda s piko"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("xiddig lix geeslood oo dhibic leh"),
            keywords: &[
                "maal",
                "xidddig lix geesood oo dhibic leh",
                "xiddig",
                "xiddig lix geeslood oo dhibic leh",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("yll me gjashtë cepa me pikë"),
            keywords: &["fat", "yll", "yll me gjashtë cepa me pikë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("шестокрака звезда са тачком"),
            keywords: &["звeздa", "срeћa", "шестокрака звезда са тачком"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("шестокрака звијезда са тачком"),
            keywords: &["шестокрака звијезда са тачком"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("šestokraka zvezda sa tačkom"),
            keywords: &["sreća", "zvezda", "šestokraka zvezda sa tačkom"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("šestokraka zvijezda sa tačkom"),
            keywords: &["šestokraka zvijezda sa tačkom"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("sexuddig stjärna med prick"),
            keywords: &["sexuddig stjärna med prick", "spådom", "stjärna"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("nyota yenye pembe sita na kitone katikati"),
            keywords: &[
                "bahati",
                "nyota",
                "nyota yenye pembe sita na kitone katikati",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ஆறு முனை நட\u{bcd}சத\u{bcd}திரம\u{bcd}"),
            keywords: &[
                "ஆறு முனை நட\u{bcd}சத\u{bcd}திரம\u{bcd}",
                "நட\u{bcd}சத\u{bcd}திரம\u{bcd}",
                "ஸ\u{bcd}ட\u{bbe}ர\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("చుక\u{c4d}కలత\u{c4b} ఆరు క\u{c4b}ణ\u{c3e}ల నక\u{c4d}షత\u{c4d}రం"),
            keywords: &[
                "ఆరు క\u{c4b}ణ\u{c3e}ల నక\u{c4d}షత\u{c4d}రం",
                "చుక\u{c4d}కలత\u{c4b} ఆరు క\u{c4b}ణ\u{c3e}ల నక\u{c4d}షత\u{c4d}రం",
                "యూద\u{c3f}య\u{c3e} మతం చ\u{c3f}హ\u{c4d}నం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("ситораи холдори шашгӯша"),
            keywords: &["ситора", "ситораи холдори шашгӯша", "тақдир"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ดาว 6 แฉก"),
            keywords: &["ดาว", "ดาว 6 แฉก"],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ነጥብጣብ 6-ጫፍ ኮኾብ"),
            keywords: &["ነጥብጣብ 6-ጫፍ ኮኾብ", "ኮኾብ", "ዕድል"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("nokatly altyburç ýyldyz"),
            keywords: &["nokatly altyburç ýyldyz", "pal", "ýyldyz"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("fetuʻu tapaono moe ʻila"),
            keywords: &["fetuʻu", "fetuʻu tapaono moe ʻila", "tapaono", "ʻila"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("altı köşeli yıldız"),
            keywords: &[
                "altı köşeli",
                "altı köşeli yıldız",
                "fal",
                "fal bakma",
                "yıldız",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئالتە بۇرجەكلىك يۇلتۇز"),
            keywords: &["ئالتە بۇرجەكلىك يۇلتۇز", "خەزىنە", "يۇلتۇز"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("шестикутна зірка з крапкою"),
            keywords: &["зірка", "удача", "шестикутна зірка з крапкою"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("نکتہ دار چھ کونوں والا ستارہ"),
            keywords: &[
                "ستارہ",
                "قسمت",
                "نکتہ دار چھ کونوں والا ستارہ",
                "چھ",
                "کونے",
            ],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("nuqtali olti qirrali yulduz"),
            keywords: &["nuqtali olti qirrali yulduz", "taqdir", "yulduz"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("ngôi sao sáu cánh có dấu chấm"),
            keywords: &["may mắn", "ngôi sao", "ngôi sao sáu cánh có dấu chấm"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("biddéewu 6 car"),
            keywords: &["biddeew", "biddéewu 6 car", "wërsëk"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("inkwenkwezi eneekona ezintandathu enechaphaza"),
            keywords: &[
                "inkwenkwezi",
                "inkwenkwezi eneekona ezintandathu enechaphaza",
                "ithamsanqa",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("irawọ totooto oni-mẹfa"),
            keywords: &["irawọ totooto oni-mẹfa", "oríre", "ìràwọ\u{300}"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("有點嘅六角星"),
            keywords: &["幸運", "星", "有點嘅六角星"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("有点嘅六角星"),
            keywords: &["幸运", "星", "有点嘅六角星"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("带中间点的六芒星"),
            keywords: &["六角星", "命运", "带中间点的六芒星"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("六芒星加圓點"),
            keywords: &["六芒星加圓點", "六角星"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("中間帶點的六角星"),
            keywords: &["中間帶點的六角星", "六角星"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("intanyezi enechashazi ekhombe kasithupha"),
            keywords: &[
                "inhlanhla",
                "inkanyezi",
                "intanyezi enechashazi ekhombe kasithupha",
            ],
        },
    ],
};
