#[doc = "‼\u{fe0f}"]
pub const DOUBLE_EXCLAMATION_MARK: crate::Emoji = crate::Emoji {
    glyph: "‼\u{fe0f}",
    codepoint: "203C FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "double exclamation mark",
    group: "Symbols",
    subgroup: "punctuation",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "‼",
        codepoint: "203C",
        status: crate::Status::Unqualified,
        introduction_version: 0.6f32,
        name: "double exclamation mark",
        group: "Symbols",
        subgroup: "punctuation",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("dubbeluitroepteken"),
            keywords: &["dubbeluitroepteken", "leesteken", "teken", "uitroep"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ድርብ የቃለ አጋኖ ምልክት"),
            keywords: &[
                "ምልክት",
                "ሥርዓተ ነጥብ",
                "ቃለ አጋኖ",
                "ድርብ ቃለ አጋኖ",
                "ድርብ የቃለ አጋኖ ምልክት",
            ],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("تعجب مزدوج"),
            keywords: &["تعجب", "تعجب مزدوج", "علامة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("দ\u{9cd}বৈত ভ\u{9be}ৱবোধক চিহ\u{9cd}ন"),
            keywords: &[
                "!",
                "!!",
                "দ\u{9cd}বৈত ভ\u{9be}ৱবোধক চিহ\u{9cd}ন",
                "বেংবেং",
                "যতি-চিহ\u{9cd}ন",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("qoşa nida işarəsi"),
            keywords: &[
                "durğu işarəsi",
                "işarə",
                "nida",
                "qoşa nida",
                "qoşa nida işarəsi",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("два клічнікі"),
            keywords: &[
                "!",
                "!!",
                "вокліч",
                "два клічнікі",
                "знак",
                "клічнікі",
                "пунктуацыя",
                "шум",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Двойна удивителна"),
            keywords: &["Двойна удивителна", "двойна", "пунктуация", "удивителна"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("দ\u{9c1}টি বিস\u{9cd}ময\u{9bc}বোধক চিহ\u{9cd}ন"),
            keywords: &[
                "চিহ\u{9cd}ন",
                "দ\u{9c1}টি বিস\u{9cd}ময\u{9bc}বোধক চিহ\u{9cd}ন",
                "বিস\u{9cd}ময\u{9bc}বোধক",
                "ব\u{9cd}য\u{9be}ং ব\u{9cd}য\u{9be}ং",
                "যতিচিহ\u{9cd}ন",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("pik-estlamm doubl"),
            keywords: &["!", "!!", "pik-estlamm", "pik-estlamm doubl"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("dupli uzvičnik"),
            keywords: &[
                "!",
                "!!",
                "bum bum",
                "dupli uzvičnik",
                "interpunkcija",
                "oznaka",
                "uzvik",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("signe d’exclamació doble"),
            keywords: &[
                "!",
                "!!",
                "doble exclamació",
                "exclamació",
                "signe d’exclamació doble",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏔᎵᎭ ᏍᏓᏱ ᎤᏃᏴᎩ ᎤᏙᏪᎸ"),
            keywords: &[
                "!",
                "!!",
                "ᎤᏙᏪᎸ",
                "ᏇᏂᎩᏇᏂᎩ",
                "ᏍᏓᏱ ᎤᏃᏴᎩ",
                "ᏔᎵᎭ ᏍᏓᏱ ᎤᏃᏴᎩ ᎤᏙᏪᎸ",
                "ᏚᏙᏪᎸ",
            ],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("dvojitý vykřičník"),
            keywords: &[
                "!",
                "!!",
                "dvojitý vykřičník",
                "interpunkční znaménka",
                "vykřičník",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("ebychnod dwbl"),
            keywords: &[
                "!!",
                "atalnodiad",
                "bangbang",
                "ebychnod",
                "ebychnod dwbl",
                "marc",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("dobbelt udråbstegn"),
            keywords: &["!", "!!", "dobbelt udråbstegn", "tegnsætning", "udråbstegn"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("doppeltes Ausrufezeichen"),
            keywords: &[
                "Ausrufezeichen",
                "Satzzeichen",
                "doppelt",
                "doppeltes Ausrufezeichen",
                "rot",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("διπλό θαυμαστικό"),
            keywords: &[
                "!",
                "!!",
                "διπλό θαυμαστικό",
                "θαυμαστικό",
                "θόρυβος",
                "σημείο",
                "στίξη",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("double exclamation mark"),
            keywords: &[
                "!",
                "!!",
                "bangbang",
                "double exclamation mark",
                "exclamation",
                "mark",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &[
                "double exclamation mark",
                "exclamation",
                "mark",
                "punctuation",
            ],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("exclamación doble"),
            keywords: &[
                "!!",
                "exclamación",
                "exclamación doble",
                "puntuación",
                "sorpresa",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("topelthüüumärk"),
            keywords: &["hüüumärk", "topelthüüumärk"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("harridura-marka bikoitza"),
            keywords: &["!", "!!", "harridura-marka bikoitza", "marka"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("علامت تعجب دوتایی"),
            keywords: &[
                "دو علامت تعجب",
                "علامت تعجب",
                "علامت تعجب دوتایی",
                "علامت\u{200c}گذاری",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kaksoishuutomerkki"),
            keywords: &[
                "2",
                "huutomerkki",
                "kaksoishuutomerkki",
                "merkki",
                "välimerkki",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("dobleng tandang padamdam"),
            keywords: &[
                "bangbang",
                "bantas",
                "doble",
                "dobleng tandang padamdam",
                "marka",
                "padamdam",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("dupult rópitekn"),
            keywords: &["dupult", "rópitekn", "teknseting"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("double point d’exclamation"),
            keywords: &[
                "!",
                "!!",
                "double point d’exclamation",
                "exclamation",
                "point",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("comhartha uaillbhreasa dúbailte"),
            keywords: &[
                "!",
                "!!",
                "comhartha uaillbhreasa dúbailte",
                "marc",
                "poncaíocht",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("clisg-phuing dhùbailte"),
            keywords: &[
                "!",
                "!!",
                "clisg-phuing",
                "clisg-phuing dhùbailte",
                "comharra",
                "dùbailte",
                "puingeachadh",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("signo de exclamación dobre"),
            keywords: &[
                "!!",
                "admiración",
                "dobre signo de exclamación",
                "exclamación",
                "signo de exclamación dobre",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("બ\u{ac7} ઉદ\u{acd}ગાર ચિહ\u{acd}ન"),
            keywords: &[
                "!",
                "!!",
                "ઉદ\u{acd}ગારચિહ\u{acd}ન",
                "ચિહ\u{acd}ન",
                "બ\u{ac7} ઉદ\u{acd}ગાર ચિહ\u{acd}ન",
                "વિરામચિહ\u{acd}ન",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("alamar motsin rai biyu"),
            keywords: &[
                "alama",
                "alamar motsin rai",
                "alamar motsin rai biyu",
                "alamomin rubutu",
                "bangbang",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("סימן קריאה כפול"),
            keywords: &["הדגשה", "כפול", "סימן קריאה", "סימן קריאה כפול", "פיסוק"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("दोहरा विस\u{94d}मयादिबोधक चिह\u{94d}न"),
            keywords: &[
                "चिह\u{94d}न",
                "चिह\u{94d}न विचार",
                "दोहरा विस\u{94d}मयादिबोधक चिह\u{94d}न",
                "विस\u{94d}मयादिबोधक",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("dvostruki uskličnik"),
            keywords: &["dvostruki uskličnik", "interpunkcija", "uskličnik", "znak"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("dupla felkiáltójel"),
            keywords: &["dupla felkiáltójel", "felkiáltás", "központozás", "írásjel"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("կրկնակի բացականչական նշան"),
            keywords: &[
                "բացականչություն",
                "կետադրություն",
                "կրկնակի բացականչական նշան",
                "նշան",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("tanda seru ganda"),
            keywords: &[
                "bangbang",
                "tanda",
                "tanda baca",
                "tanda seru",
                "tanda seru ganda",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("akara ntimkpu mkpị"),
            keywords: &[
                "akara",
                "akara ntimkpu mkpị",
                "bangbang",
                "ntimkpu",
                "ntụpọ",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("tvöfalt upphrópunarmerki"),
            keywords: &[
                "greinarmerki",
                "merki",
                "tvöfalt upphrópunarmerki",
                "upphr´ópunarmerki",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("doppio punto esclamativo"),
            keywords: &[
                "doppio punto esclamativo",
                "esclamazione",
                "punteggiatura",
                "punto esclamativo",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("二重感嘆符"),
            keywords: &[
                "!",
                "びっくりマーク",
                "エクスクラメーションマーク",
                "二重感嘆符",
                "約物",
                "記号",
            ],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("tandha penthung dhobel"),
            keywords: &[
                "!",
                "!!",
                "mak cethor pindho",
                "mbangetake",
                "tandha",
                "tandha penthung dhobel",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ორმაგი ძახილის ნიშანი"),
            keywords: &["ნიშანი", "ორმაგი ძახილის ნიშანი", "პუნქტუაცია", "ძახილი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("қос леп белгісі"),
            keywords: &[
                "бангбанг",
                "белгі",
                "леп белгісі",
                "пунктуация",
                "қос леп белгісі",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("dobbelt udråbstegn"),
            keywords: &["dobbelt udråbstegn", "tegnsætning", "udråbstegn"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("សញ\u{17d2}ញាឧទានព\u{17b8}រ"),
            keywords: &[
                "!",
                "!!",
                "សញ\u{17d2}ញា",
                "សញ\u{17d2}ញាឧទានព\u{17b8}រ",
                "ឧទាន",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಎರಡು ಆಶ\u{ccd}ಚರ\u{ccd}ಯಸ\u{cc2}ಚಕ ಗುರುತು"),
            keywords: &[
                "!",
                "!!",
                "ಆಶ\u{ccd}ಚರ\u{ccd}ಯಸ\u{cc2}ಚಕ",
                "ಎರಡು ಆಶ\u{ccd}ಚರ\u{ccd}ಯಸ\u{cc2}ಚಕ ಗುರುತು",
                "ಗುರುತು",
                "ಡಬಲ\u{ccd} ಆಶ\u{ccd}ಚರ\u{ccd}ಯಸ\u{cc2}ಚಕ ಚ\u{cbf}ಹ\u{ccd}ನ\u{cc6}",
                "ಬ\u{ccd}ಯಾಂಗ\u{ccd}\u{200c}ಬ\u{ccd}ಯಾಂಗ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("두 개의 느낌표"),
            keywords: &["느낌표", "두 개의 느낌표"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("दोट\u{94d}टी उद\u{94d}गार चिन\u{94d}न"),
            keywords: &[
                "!",
                "!!",
                "उद\u{94d}गगार",
                "चिन\u{94d}न",
                "दोट\u{94d}टी उद\u{94d}गार चिन\u{94d}न",
                "ब\u{901}गब\u{901}ग",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("кош илеп белгиси"),
            keywords: &["белги", "илеп", "кош илеп белгиси", "пунктуация"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("duebelt Ausruffzeechen"),
            keywords: &[
                "Ausruff",
                "Interpunktioun",
                "Zeechen",
                "duebelt Ausruffzeechen",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເຄ\u{eb7}\u{ec8}ອງໝາຍທ\u{ec9}ວງຄ\u{eb9}\u{ec8}"),
            keywords: &[
                "ຕ\u{ebb}ກໃຈ",
                "ເຄ\u{eb7}\u{ec8}ອງໝາຍທ\u{ec9}ວງ",
                "ເຄ\u{eb7}\u{ec8}ອງໝາຍທ\u{ec9}ວງຄ\u{eb9}\u{ec8}",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("du šauktukai"),
            keywords: &["du šauktukai", "skyryba", "šauktukas", "žymė"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("divas izsaukuma zīmes"),
            keywords: &[
                "!",
                "!!",
                "divas izsaukuma zīmes",
                "izsaukums",
                "pieturzīme",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tohuhā taurua"),
            keywords: &["tohu", "tohuhā", "tohuhā taurua", "tohutuhi"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("двоен извичник"),
            keywords: &["!", "!!", "двоен извичник", "знак", "извичник"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഇരട\u{d4d}ട ആശ\u{d4d}ചര\u{d4d}യ ചിഹ\u{d4d}നം"),
            keywords: &[
                "ആശ\u{d4d}\u{200c}ചര\u{d4d}യചിഹ\u{d4d}നം",
                "ഇരട\u{d4d}ട ആശ\u{d4d}ചര\u{d4d}യ ചിഹ\u{d4d}നം",
                "ബ\u{d3e}ങ\u{d4d}ബ\u{d3e}ങ\u{d4d}",
                "വിര\u{d3e}മം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("хоёр анхааруулгын тэмдэг"),
            keywords: &[
                "!",
                "!!",
                "анхааруулах",
                "давхар анхаарлын тэмдэг",
                "тас тас",
                "тэмдэг",
                "хоёр анхааруулгын тэмдэг",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("दोन उद\u{94d}गारवाचकचिन\u{94d}ह"),
            keywords: &[
                "उद\u{94d}गारवाचक",
                "चिन\u{94d}ह",
                "दोन उद\u{94d}गारवाचकचिन\u{94d}ह",
                "ध\u{941}माक\u{942}ळ",
                "विरामचिन\u{94d}ह",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("tanda seru berganda"),
            keywords: &[
                "bangbang",
                "seru",
                "tanda",
                "tanda baca",
                "tanda seru berganda",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("punt doppju esklamattiv"),
            keywords: &[
                "bangbang",
                "esklamazzjoni",
                "marka",
                "punt doppju esklamattiv",
                "punteġġjatura",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "အာမေဍ\u{102d}တ\u{103a} သင\u{103a}\u{1039}ကေတ န\u{103e}စ\u{103a}ထပ\u{103a}က\u{103d}မ\u{103a}း",
            ),
            keywords: &[
                "ပ\u{102f}ဒ\u{103a}ဖြတ\u{103a}ပ\u{102f}ဒ\u{103a}ရပ\u{103a}",
                "ဘန\u{103a}းဘန\u{103a}း သင\u{103a}\u{1039}ကေတ",
                "အာမေဍ\u{102d}တ\u{103a} သင\u{103a}\u{1039}ကေတ",
                "အာမေဍ\u{102d}တ\u{103a} သင\u{103a}\u{1039}ကေတ န\u{103e}စ\u{103a}ထပ\u{103a}က\u{103d}မ\u{103a}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("dobbelt utropstegn"),
            keywords: &[
                "!",
                "!!",
                "bangbang",
                "dobbelt utropstegn",
                "tegn",
                "tegnsetting",
                "utropstegn",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("दोहोरो विस\u{94d}मयाधिबोधक चिन\u{94d}ह"),
            keywords: &[
                "चिन\u{94d}ह",
                "दोहोरो विस\u{94d}मयाधिबोधक चिन\u{94d}ह",
                "ब\u{94d}याङ\u{94d}ब\u{94d}याङ\u{94d}",
                "विराम चिन\u{94d}ह",
                "विस\u{94d}मयाधिबोधक चिन\u{94d}ह",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("dubbel uitroepteken"),
            keywords: &[
                "!",
                "!!",
                "dubbel uitroepteken",
                "interpunctie",
                "teken",
                "uitroep",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("dobbelt utropsteikn"),
            keywords: &[
                "!",
                "!!",
                "bangbang",
                "dobbelt utropsteikn",
                "teikn",
                "teiknsetjing",
                "utropsteikn",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଦ\u{b41}ଇଟ\u{b3f} ବ\u{b3f}ସ\u{b4d}ମୟସ\u{b42}ଚକ ଚ\u{b3f}ହ\u{b4d}ନ"),
            keywords: &[
                "!",
                "!!",
                "ଚ\u{b3f}ହ\u{b4d}ନ",
                "ଦ\u{b41}ଇଟ\u{b3f} ବ\u{b3f}ସ\u{b4d}ମୟସ\u{b42}ଚକ ଚ\u{b3f}ହ\u{b4d}ନ",
                "ବ\u{b3f}ର\u{b3e}ମ ଚ\u{b3f}ହ\u{b4d}ନ",
                "ବ\u{b3f}ସ\u{b4d}ମୟସ\u{b42}ଚକ",
                "ବ\u{b4d}ୟ\u{b3e}ଙ\u{b4d}ଗବ\u{b4d}ୟ\u{b3e}ଙ\u{b4d}ଗ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਦ\u{a4b}ਹਰਾ ਹ\u{a48}ਰਾਨੀਵਾਚਕ ਚਿ\u{a70}ਨ\u{a4d}ਹ"),
            keywords: &[
                "ਚਿ\u{a70}ਨ\u{a4d}ਹ",
                "ਦ\u{a4b}ਹਰਾ ਹ\u{a48}ਰਾਨੀਵਾਚਕ ਚਿ\u{a70}ਨ\u{a4d}ਹ",
                "ਬ\u{a48}\u{a02}ਗ-ਬ\u{a48}\u{a02}ਗ",
                "ਵਿਰਾਮ ਚਿ\u{a70}ਨ\u{a4d}ਹ",
                "ਹ\u{a48}ਰਾਨੀਵਾਚਕ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("دوپرا فجائی نشان"),
            keywords: &[
                "دوپرا فجائی نشان",
                "رموز اوقاف",
                "زور دار دھماکہ",
                "نشان لانا",
                "چیخ و پکار",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Dọ\u{301}búl Ẹksklaméshọn Mak"),
            keywords: &[
                "!",
                "!!",
                "Bángbang",
                "Dọ\u{301}búl Ẹksklaméshọn Mak",
                "Mak",
                "Ẹksklaméshọn",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("podwójny wykrzyknik"),
            keywords: &[
                "!",
                "!!",
                "krzyk",
                "okrzyk",
                "podwójny wykrzyknik",
                "wykrzykniki",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("غبرګې ندا نښې"),
            keywords: &[
                "!",
                "!!",
                "بينګ بينګ",
                "غبرګ",
                "غبرګې ندا نښې",
                "ندا",
                "نښه",
                "وقفه",
            ],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("dupla exclamação"),
            keywords: &[
                "!",
                "!!",
                "dupla exclamação",
                "exclamação",
                "explosão",
                "ponto de exclamação duplo",
                "pontuação",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("ponto de exclamação duplo"),
            keywords: &[
                "!",
                "!!",
                "exclamação",
                "ponto de exclamação duplo",
                "pontuação",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("iskay qapariq yupiy"),
            keywords: &["iskay qapariq yupiy"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("semn dublu de exclamare"),
            keywords: &[
                "!",
                "exclamație",
                "punctuație",
                "semn",
                "semn dublu de exclamare",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-002"),
            keywords: &["E10-002"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("два восклицательных знака"),
            keywords: &[
                "восклицание",
                "восклицательные",
                "восклицательный",
                "два восклицательных знака",
                "знак",
                "знаки",
                "пунктуация",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("udutangaro tubiri"),
            keywords: &[
                "akarango",
                "akatuzo",
                "bangabanga",
                "gutangara",
                "udutangaro tubiri",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ٻٽي عجب جي نشاني"),
            keywords: &["!", "!!", "بينگ بينگ", "عجب", "نسان", "ٻٽي عجب جي نشاني"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ද\u{dca}ව\u{dd2} ව\u{dd2}ස\u{dca}මය\u{dcf}ර\u{dca}ථ ලක\u{dd4}ණ"),
            keywords: &[
                "ද\u{dca}ව\u{dd2} ව\u{dd2}ස\u{dca}මය\u{dcf}ර\u{dca}ථ ලක\u{dd4}ණ",
                "බැන\u{dca}ග\u{dca}බැන\u{dca}ග\u{dca}",
                "ලක\u{dd4}ණ",
                "ව\u{dd2}ර\u{dcf}ම ලක\u{dd4}ණ",
                "ව\u{dd2}ස\u{dca}මය\u{dcf}ර\u{dca}ථය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("dvojitý výkričník"),
            keywords: &[
                "!",
                "!!",
                "dvojitý výkričník",
                "interpunkcia",
                "výkričník",
                "znak",
                "zvolanie",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("dvojni klicaj"),
            keywords: &[
                "!",
                "!!",
                "dva klicaja",
                "dvojni klicaj",
                "klicaj",
                "ločilo",
                "znak",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("laba calaamadood cajiib ah"),
            keywords: &[
                "!",
                "!!",
                "cajiib",
                "calaamad",
                "dhawaaq",
                "laba calaamadood cajiib ah",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("dy pikëçuditje"),
            keywords: &["dy pikëçuditje", "pikësim", "pikëçuditje", "shenjë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("двоструки узвичник"),
            keywords: &["двоструки узвичник", "знaк", "интeрпункциja", "узвичник"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("dvostruki uzvičnik"),
            keywords: &["dvostruki uzvičnik", "interpunkcija", "uzvičnik", "znak"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("dubbla utropstecken"),
            keywords: &["dubbla utropstecken", "två", "utropstecken"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("alama mbili za mshangao"),
            keywords: &[
                "!",
                "!!",
                "alama",
                "alama mbili za mshangao",
                "mlio mkubwa",
                "mshangao",
                "uakifishaji",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("இரட\u{bcd}டை ஆச\u{bcd}சர\u{bcd}யக\u{bcd} குறி"),
            keywords: &[
                "ஆச\u{bcd}சர\u{bcd}யம\u{bcd}",
                "இரட\u{bcd}டை ஆச\u{bcd}சர\u{bcd}யக\u{bcd} குறி",
                "குறி",
                "நிறுத\u{bcd}தற\u{bcd}குறி",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ఆశ\u{c4d}చర\u{c4d}య\u{c3e}ర\u{c4d}థకం గుర\u{c4d}తులు"),
            keywords: &[
                "ఆశ\u{c4d}చర\u{c4d}య\u{c3e}ర\u{c4d}థకం",
                "ఆశ\u{c4d}చర\u{c4d}య\u{c3e}ర\u{c4d}థకం గుర\u{c4d}తులు",
                "గుర\u{c4d}తు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("аломати хитоби дукарата"),
            keywords: &[
                "аломат",
                "аломати хитоби дукарата",
                "аломатҳои китобатӣ",
                "банг-банг",
                "хитоб",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เคร\u{e37}\u{e48}องหมายอ\u{e31}ศเจร\u{e35}ย\u{e4c}ค\u{e39}\u{e48}"),
            keywords: &[
                "!",
                "!!",
                "ป\u{e31}งป\u{e31}ง",
                "เคร\u{e37}\u{e48}องหมายวรรคตอน",
                "เคร\u{e37}\u{e48}องหมายอ\u{e31}ศเจร\u{e35}ย\u{e4c}ค\u{e39}\u{e48}",
            ],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ድርብ ምልክት ስምዒት"),
            keywords: &["!", "!!", "ምልክት", "ስምዒት", "ባንግባንግ", "ድርብ ምልክት ስምዒት"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("goşa ýüzlenme belgisi"),
            keywords: &["belgi", "bum-bum", "goşa ýüzlenme belgisi", "ýüzlenme"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("fakaʻiloʻilonga kalanga"),
            keywords: &["fakaʻiloʻilonga", "kalanga"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("çift ünlem"),
            keywords: &["!", "!!", "işaret", "noktalama", "çift ünlem", "ünlem"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("قوش ئۈندەش بەلگىسى"),
            keywords: &["ئۇرۇش", "ئۈندەش", "بەلگە", "تىنىش", "قوش ئۈندەش بەلگىسى"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("подвійний знак оклику"),
            keywords: &[
                "!",
                "!!",
                "бенгбенг",
                "лігатура",
                "оклик",
                "подвійний знак оклику",
                "розділовий знак",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("دوہری علامت\u{650} ندائیہ"),
            keywords: &[
                "!",
                "!!",
                "بینگ بینگ",
                "دوہری علامت\u{650} ندائیہ",
                "علامت",
                "علامت ندائیہ",
            ],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("juft undov belgisi"),
            keywords: &["!", "!!", "belgi", "juft undov belgisi", "paq-puq", "undov"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("hai dấu chấm than"),
            keywords: &["chấm câu", "chấm than", "dấu", "hai dấu chấm than"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("ñaarte màndarga esklamaasiyoŋ"),
            keywords: &[
                "bangbang",
                "esklamaasiyoŋ",
                "màndarga",
                "tomb",
                "ñaarte màndarga esklamaasiyoŋ",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("uphawu lwesikhuzo ophindaphindeneyo"),
            keywords: &[
                "i-bangbang",
                "isikhuzo",
                "isiphumlisi",
                "uphawu",
                "uphawu lwesikhuzo ophindaphindeneyo",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("àmì ìyanu oníbejì"),
            keywords: &["gbàgbà", "àmì", "àmì ìyanu", "àmì ìyanu oníbejì", "ìfàmìsí"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("雙感歎號"),
            keywords: &["!", "!!", "嘭嘭", "感歎號", "標點符號", "符號", "雙感歎號"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("双感叹号"),
            keywords: &["双感叹号", "嘭嘭", "感叹号", "标点符号", "符号"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("双感叹号"),
            keywords: &["两个", "双感叹号", "吃惊", "标点符号", "！", "！！"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("雙驚嘆號"),
            keywords: &["標點", "雙驚嘆號"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("雙感嘆號"),
            keywords: &["雙感嘆號"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("uphawu lwesibabazi oluphindekile"),
            keywords: &["isibabazi", "uphawu", "uphawu lwesibabazi oluphindekile"],
        },
    ],
};
#[doc = "⁉\u{fe0f}"]
pub const EXCLAMATION_QUESTION_MARK: crate::Emoji = crate::Emoji {
    glyph: "⁉\u{fe0f}",
    codepoint: "2049 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "exclamation question mark",
    group: "Symbols",
    subgroup: "punctuation",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "⁉",
        codepoint: "2049",
        status: crate::Status::Unqualified,
        introduction_version: 0.6f32,
        name: "exclamation question mark",
        group: "Symbols",
        subgroup: "punctuation",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("uitroep-vraagteken"),
            keywords: &[
                "leesteken",
                "teken",
                "uitroep",
                "uitroep-vraagteken",
                "vraag",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ቃለ አጋኖ ከጥያቄ ምልክት ጋር"),
            keywords: &["ምልክት", "ሥርዓተ ነጥብ", "ቃለ አጋኖ", "ቃለ አጋኖ ከጥያቄ ምልክት ጋር", "ጥያቄ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("تعجب واستفهام"),
            keywords: &["استفهام", "التعجب", "ترقيم", "تعجب واستفهام", "علامة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ভ\u{9be}ৱবোধক প\u{9cd}ৰশ\u{9cd}নবোধক চিহ\u{9cd}ন"),
            keywords: &[
                "!",
                "!?",
                "?",
                "চিহ\u{9cd}ন",
                "প\u{9cd}ৰশ\u{9cd}ন",
                "ভ\u{9be}ৱবোধক",
                "ভ\u{9be}ৱবোধক আৰ\u{9c1} প\u{9cd}ৰশ\u{9cd}নবোধক",
                "ভ\u{9be}ৱবোধক প\u{9cd}ৰশ\u{9cd}নবোধক চিহ\u{9cd}ন",
                "যতি-চিহ\u{9cd}ন",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("nida və sual işarəsi"),
            keywords: &[
                "durğu işarəsi",
                "işarə",
                "nida",
                "nida və sual işarələrinin liqaturası",
                "nida və sual işarəsi",
                "sual",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("клічнік з пытальнікам"),
            keywords: &[
                "!",
                "!?",
                "?",
                "знак",
                "клічнік",
                "клічнік з пытальнікам",
                "пунктуацыя",
                "пытальнік",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Удивителна и въпросителна"),
            keywords: &[
                "Удивителна и въпросителна",
                "въпросителна",
                "пунктуация",
                "удивителна",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("বিস\u{9cd}ময\u{9bc}বোধক প\u{9cd}রশ\u{9cd}নবোধক চিহ\u{9cd}ন"),
            keywords: &[
                "!",
                "!?",
                "?",
                "প\u{9cd}রশ\u{9cd}ন",
                "বিস\u{9cd}ময\u{9bc}বোধক",
                "বিস\u{9cd}ময\u{9bc}বোধক এবং প\u{9cd}রশ\u{9cd}নবোধক",
                "বিস\u{9cd}ময\u{9bc}বোধক প\u{9cd}রশ\u{9cd}নবোধক চিহ\u{9cd}ন",
                "যতিচিহ\u{9cd}ন",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("pik-goulenn estlamm"),
            keywords: &[
                "!",
                "!?",
                "?",
                "estlamm",
                "goulenn",
                "pik-goulenn estlamm",
                "poentadur",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("uzvičnik upitnik"),
            keywords: &[
                "!",
                "!?",
                "?",
                "interpunkcija",
                "upit",
                "uzvik",
                "uzvičnik upitnik",
                "čuđenje",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("signe d’exclamació i d’interrogació"),
            keywords: &[
                "!",
                "!?",
                "?",
                "exclamació",
                "interrogació",
                "pregunta",
                "puntuació",
                "signe",
                "signe d’exclamació i d’interrogació",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏍᏓᏱ ᎤᏃᏴᎩ ᎠᏛᏛᎲᏍᎩ ᎤᏙᏪᎸ"),
            keywords: &[
                "!",
                "!?",
                "?",
                "ᎠᏛᏛᎲᏍᎩ",
                "ᎢᏂᏖᎶᏇᏂᎩ",
                "ᎤᏙᏪᎸ",
                "ᏍᏓᏱ ᎤᏃᏴᎩ",
                "ᏍᏓᏱ ᎤᏃᏴᎩ ᎠᏛᏛᎲᏍᎩ ᎤᏙᏪᎸ",
                "ᏚᏙᏪᎸ",
            ],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("vykřičník a otazník"),
            keywords: &[
                "!",
                "!?",
                "?",
                "interpunkční znaménka",
                "otazník",
                "vykřičník",
                "vykřičník a otazník",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("marc cwestiwn ag ebychnod"),
            keywords: &[
                "!",
                "!?",
                "?",
                "cwestiwn",
                "ebychnod",
                "holnod ebychol",
                "marc",
                "marc cwestiwn ag ebychnod",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("udråbstegn og spørgsmålstegn"),
            keywords: &[
                "spørgsmål",
                "tegn",
                "tegnsætning",
                "udråbstegn",
                "udråbstegn og spørgsmålstegn",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Ausrufe- und Fragezeichen"),
            keywords: &[
                "Ausrufe- und Fragezeichen",
                "Ausrufezeichen",
                "Fragezeichen",
                "Satzzeichen",
                "rot",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("θαυμαστικό με ερωτηματικό"),
            keywords: &[
                "!",
                "!?",
                "?",
                "ερωτηματικό",
                "ερώτηση",
                "θαυμαστικό",
                "θαυμαστικό με ερωτηματικό",
                "σημείο",
                "στίξη",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("exclamation question mark"),
            keywords: &[
                "!",
                "!?",
                "?",
                "exclamation",
                "interrobang",
                "mark",
                "punctuation",
                "question",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["exclamation", "mark", "punctuation", "question"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("exclamación e interrogación"),
            keywords: &[
                "!",
                "!?",
                "?",
                "exclamación",
                "exclamación e interrogación",
                "interrogación",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &[
                "!",
                "!?",
                "?",
                "exclamación",
                "exclamación e interrogación",
                "interrogación",
                "pregunta",
            ],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("küsimärgiga hüüumärk"),
            keywords: &[
                "!",
                "!?",
                "?",
                "hüüumärk",
                "küsimärgiga hüüumärk",
                "küsimärk",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("harridura- eta galdera-ikurra"),
            keywords: &["!", "!?", "?", "harridura- eta galdera-ikurra", "marka"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("علامت تعجب و سؤال"),
            keywords: &[
                "!",
                "؟!",
                "علامت تعجب",
                "علامت تعجب و سؤال",
                "علامت سؤال",
                "علامت\u{200c}گذاری",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("huuto-kysymysmerkki"),
            keywords: &[
                "2",
                "huuto-kysymysmerkki",
                "huutomerkki",
                "kysymysmerkki",
                "merkki",
                "välimerkki",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("tandang padamdam at pananong"),
            keywords: &[
                "bantas",
                "interrobang",
                "marka",
                "padamdam",
                "tandang padamdam at pananong",
                "tanong",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("rópitekn og spurnartekn"),
            keywords: &[
                "rópitekn",
                "rópitekn og spurnartekn",
                "spurnartekn",
                "teknseting",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("points d’exclamation et d’interrogation"),
            keywords: &[
                "!",
                "!?",
                "?",
                "exclamation",
                "point",
                "points d’exclamation et d’interrogation",
                "points d’interrogation et d’exclamation",
                "ponctuation",
                "question",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("comhartha ceiste agus uaillbhreasa"),
            keywords: &[
                "!?",
                "comhartha ceiste agus uaillbhreasa",
                "exclamation",
                "mark",
                "punctuation",
                "question",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("clisg-phuing is comharra-ceiste"),
            keywords: &[
                "!",
                "!?",
                "?",
                "clisg-phuing",
                "clisg-phuing is comharra-ceiste",
                "comharra",
                "comharra-ceiste",
                "puingeachadh",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("signo de exclamación e interrogación"),
            keywords: &[
                "!?",
                "admiración",
                "exclamación",
                "interrogación",
                "signo de exclamación e interrogación",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ઉદ\u{acd}ગાર પ\u{acd}રશ\u{acd}નાર\u{acd}થ ચિહ\u{acd}ન"),
            keywords: &[
                "!",
                "!?",
                "?",
                "ઉદ\u{acd}ગાર પ\u{acd}રશ\u{acd}નાર\u{acd}થ ચિહ\u{acd}ન",
                "ઉદ\u{acd}ગારચિહ\u{acd}ન",
                "ચિહ\u{acd}ન",
                "પ\u{acd}રશ\u{acd}ન",
                "પ\u{acd}રશ\u{acd}નાર\u{acd}થ ચિહ\u{acd}ન",
                "વિરામચિહ\u{acd}ન",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("alamar motsin rai da tambaya"),
            keywords: &[
                "alamar motsin rai",
                "alamar motsin rai da tambaya",
                "alamar motsin rai tare da tambaya",
                "alamomin rubutu",
                "tambaya",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("סימן שאלה וסימן קריאה"),
            keywords: &[
                "הדגשה",
                "סימן קריאה",
                "סימן שאלה",
                "סימן שאלה וסימן קריאה",
                "פיסוק",
                "שאלה",
            ],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("विस\u{94d}मयादिबोधक प\u{94d}रश\u{94d}न चिह\u{94d}न"),
            keywords: &[
                "चिह\u{94d}न",
                "चिह\u{94d}न विचार",
                "प\u{94d}रश\u{94d}न",
                "विस\u{94d}मयादिबोधक",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("uskličnik-upitnik"),
            keywords: &[
                "interpunkcija",
                "pitanje",
                "upitnik",
                "uskličnik",
                "uskličnik-upitnik",
                "znak",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("felkiáltójel kérdőjellel"),
            keywords: &[
                "felkiáltás",
                "felkiáltójel kérdőjellel",
                "kérdés",
                "központozás",
                "írásjel",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("բացականչական հարցական նշան"),
            keywords: &[
                "բացականչական հարցական նշան",
                "բացականչություն",
                "կետադրություն",
                "հարց",
                "նշան",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("tanda seru dan tanya"),
            keywords: &[
                "pertanyaan",
                "tanda",
                "tanda baca",
                "tanda seru",
                "tanda seru dan tanya",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("akara njụajụjụ ntimkpu"),
            keywords: &["akara", "njụajụjụ", "ntimiiwubang", "ntimkpu", "ntụpọ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("upphrópunarmerki og spurningarmerki"),
            keywords: &[
                "!",
                "!?",
                "?",
                "greinarmerki",
                "interrobang",
                "spurningarmerki",
                "upphrópunarmerki",
                "upphrópunarmerki og spurningarmerki",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("punto esclamativo e interrogativo"),
            keywords: &[
                "punteggiatura",
                "punto esclamativo",
                "punto esclamativo e interrogativo",
                "punto interrogativo",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("感嘆符疑問符"),
            keywords: &[
                "!",
                "?",
                "はてなマーク",
                "びっくりマーク",
                "感嘆符疑問符",
                "記号",
            ],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("tandha penthung lan pitakon"),
            keywords: &[
                "!",
                "!?",
                "?",
                "pitakon",
                "tandha",
                "tandha penthung lan pitakon",
                "tandha wacan",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("კითხვა-ძახილის ნიშანი"),
            keywords: &[
                "კითხვა",
                "კითხვა-ძახილი",
                "კითხვა-ძახილის ნიშანი",
                "ნიშანი",
                "პუნქტუაცია",
                "ძახილი",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("леп және сұрақ белгісі"),
            keywords: &[
                "белгі",
                "леп белгісі",
                "леп және сұрақ белгісі",
                "пунктуация",
                "сұрақ",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("udråbstegn og spørgsmålstegn"),
            keywords: &[
                "spørgsmål",
                "tegn",
                "tegnsætning",
                "udråbstegn",
                "udråbstegn og spørgsmålstegn",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("សញ\u{17d2}ញាឧទានន\u{17b7}ងសញ\u{17d2}ញាស\u{17bd}រ"),
            keywords: &[
                "!",
                "!?",
                "?",
                "សញ\u{17d2}ញាឧទាន",
                "សញ\u{17d2}ញាឧទានន\u{17b7}ងសញ\u{17d2}ញាស\u{17bd}រ",
                "ស\u{17bd}រ",
                "ឧទាន",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಆಶ\u{ccd}ಚರ\u{ccd}ಯ ಪ\u{ccd}ರಶ\u{ccd}ನಾರ\u{ccd}ಥಕ ಗುರುತು"),
            keywords: &[
                "!?",
                "?",
                "ಆಶ\u{ccd}ಚರ\u{ccd}ಯ ಪ\u{ccd}ರಶ\u{ccd}ನಾರ\u{ccd}ಥಕ ಗುರುತು",
                "ಆಶ\u{ccd}ಚರ\u{ccd}ಯಸ\u{cc2}ಚಕ",
                "ಇಂಟರೊಬ\u{ccd}ಯಾಂಗ\u{ccd}",
                "ಗುರುತು",
                "ಪ\u{ccd}ರಶ\u{ccd}ನ\u{cc6}",
                "ವ\u{cbf}ರಾಮಚ\u{cbf}ಹ\u{ccd}ನ\u{cc6}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("느낌표와 물음표"),
            keywords: &["느낌표", "느낌표와 물음표", "물음표", "부호"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("उद\u{94d}गार प\u{94d}रस\u{94d}न चिन\u{94d}न"),
            keywords: &[
                "!",
                "!?",
                "?",
                "इ\u{902}टोरोब\u{901}ग",
                "उद\u{94d}गार",
                "उद\u{94d}गार प\u{94d}रस\u{94d}न चिन\u{94d}न",
                "ख\u{942}ण",
                "विराम चिन\u{94d}न। प\u{94d}रस\u{94d}न",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("суроолу илеп белгиси"),
            keywords: &[
                "белги",
                "илеп",
                "пунктуация",
                "суроолу",
                "суроолу илеп белгиси",
            ],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Ausrufffragezeechen"),
            keywords: &[
                "Ausruff",
                "Ausrufffragezeechen",
                "Fragezeechen",
                "Fro",
                "Interpunktioun",
                "Zeechen",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເຄ\u{eb7}\u{ec8}ອງໝາຍທ\u{ec9}ວງກ\u{eb1}ບໝາຍຖາມ"),
            keywords: &[
                "ເຄ\u{eb7}\u{ec8}ອງໝາຍທ\u{ec9}ວງ",
                "ເຄ\u{eb7}\u{ec8}ອງໝາຍທ\u{ec9}ວງກ\u{eb1}ບໝາຍຖາມ",
                "ໝາຍຖາມ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("šauktukas ir klaustukas"),
            keywords: &[
                "klausimas",
                "skyryba",
                "šauktukas",
                "šauktukas ir klaustukas",
                "žymė",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("izsaukuma un jautājuma zīme"),
            keywords: &[
                "!",
                "!?",
                "?",
                "izsaukuma un jautājuma zīme",
                "izsaukums",
                "jautājums",
                "pieturzīme",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tohu tohuhā-pātai"),
            keywords: &["pātai", "tohu", "tohuhā", "tohuhā-pātai", "tohutuhi"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("извичник и прашалник"),
            keywords: &[
                "знак",
                "извичник",
                "извичник и прашалник",
                "интерпункција",
                "прашалник",
            ],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ആശ\u{d4d}ചര\u{d4d}യ ചോദ\u{d4d}യ ചിഹ\u{d4d}നം"),
            keywords: &[
                "!",
                "!?",
                "?",
                "ആശ\u{d4d}ചര\u{d4d}യ ചോദ\u{d4d}യ ചിഹ\u{d4d}നം",
                "ചോദ\u{d4d}യം",
                "വിര\u{d3e}മം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("анхааруулгын, асуултын тэмдэг"),
            keywords: &[
                "!",
                "!?",
                "?",
                "анхаарлын болон асуултын тэмдэгээс бүрдсэн нийлмэл тэмдэг",
                "анхаарлын тэмдэг",
                "анхааруулгын, асуултын тэмдэг",
                "асуулт",
                "тэмдэг",
                "цэг",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("उद\u{94d}गारवाचक प\u{94d}रश\u{94d}न चिन\u{94d}ह"),
            keywords: &[
                "आ\u{902}तरजाग\u{943}ती",
                "उद\u{94d}गारवाचक",
                "चिन\u{94d}ह",
                "प\u{94d}रश\u{94d}न",
                "विरामचिन\u{94d}ह",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("tanda soal seru"),
            keywords: &[
                "interrobang",
                "seru",
                "soalan",
                "tanda",
                "tanda baca",
                "tanda soal seru",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("punt interrogattiv ta’ esklamazzjoni"),
            keywords: &[
                "esklamazzjoni",
                "interrobang",
                "marka",
                "mistoqsija",
                "punt interrogattiv ta’ esklamazzjoni",
                "punteġġjatura",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အာမေဍ\u{102d}တ\u{103a} မေးခ\u{103d}န\u{103a}း သင\u{103a}\u{1039}ကေတ"),
            keywords: &[
                "ပ\u{102f}ဒ\u{103a}ဖြတ\u{103a}ပ\u{102f}ဒ\u{103a}ရပ\u{103a}",
                "မေးခ\u{103d}န\u{103a}း",
                "အာမေဍ\u{102d}တ\u{103a}",
                "အာမေဍ\u{102d}တ\u{103a} မေးခ\u{103d}န\u{103a}း သင\u{103a}\u{1039}ကေတ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("utropstegn og spørsmålstegn"),
            keywords: &[
                "!",
                "!?",
                "?",
                "interrobang",
                "spørsmålstegn",
                "tegn",
                "tegnsetting",
                "utropstegn",
                "utropstegn og spørsmålstegn",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("विस\u{94d}मयाधिबोधक प\u{94d}रश\u{94d}न चिन\u{94d}ह"),
            keywords: &[
                "इन\u{94d}ट\u{94d}रोब\u{94d}याङ\u{94d}ग",
                "चिन\u{94d}ह",
                "प\u{94d}रश\u{94d}न",
                "विराम चिन\u{94d}ह",
                "विस\u{94d}मयाधिबोधक",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("uitroepteken en vraagteken"),
            keywords: &[
                "!",
                "!?",
                "?",
                "in\u{ad}ter\u{ad}punc\u{ad}tie",
                "teken",
                "uitroep",
                "uitroepteken en vraagteken",
                "vraag",
                "vraagteken-uitroepteken",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("utropsteikn og spørsmålsteikn"),
            keywords: &[
                "!",
                "!?",
                "?",
                "spørsmål",
                "spørsmålsteikn",
                "teikn",
                "teiknsetjing",
                "utrop",
                "utropsteikn",
                "utropsteikn og spørsmålsteikn",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some(
                "ବ\u{b3f}ସ\u{b4d}ମୟସ\u{b42}ଚକ ପ\u{b4d}ରଶ\u{b4d}ନବ\u{b3e}ଚକ ଚ\u{b3f}ହ\u{b4d}ନ",
            ),
            keywords: &[
                "!",
                "!?",
                "?",
                "ଇଣ\u{b4d}ଟେରୋବ\u{b4d}ୟ\u{b3e}ଙ\u{b4d}ଗ",
                "ଚ\u{b3f}ହ\u{b4d}ନ",
                "ପ\u{b4d}ରଶ\u{b4d}ନ",
                "ବ\u{b3f}ର\u{b3e}ମ ଚ\u{b3f}ହ\u{b4d}ନ",
                "ବ\u{b3f}ସ\u{b4d}ମୟସ\u{b42}ଚକ",
                "ବ\u{b3f}ସ\u{b4d}ମୟସ\u{b42}ଚକ ପ\u{b4d}ରଶ\u{b4d}ନବ\u{b3e}ଚକ ଚ\u{b3f}ହ\u{b4d}ନ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਹ\u{a48}ਰਾਨੀਵਾਚਕ ਸਵਾਲ ਚਿ\u{a70}ਨ\u{a4d}ਹ"),
            keywords: &[
                "ਚਿ\u{a70}ਨ\u{a4d}ਹ",
                "ਵਿਰਾਮ ਚਿ\u{a70}ਨ\u{a4d}ਹ",
                "ਸਵਾਲ",
                "ਸਵਾਲਿਆ ਚਿ\u{a70}ਨ\u{a4d}ਹ",
                "ਹ\u{a48}ਰਾਨੀਵਾਚਕ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("فجائیہ سوالیہ نشان"),
            keywords: &[
                "رموز اوقاف",
                "سوال",
                "سوالیہ اتے فجائی علامت دی اشتراکی علامت",
                "فجائیہ سوالیہ نشان",
                "نشان لانا",
                "چیخ و پکار",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Ẹksklaméshọn Kwẹ\u{301}shọn Mak"),
            keywords: &[
                "!",
                "!?",
                "?",
                "Kwẹ\u{301}shọn",
                "Mak",
                "Pọnkchuéshọn",
                "Ẹksklaméshọn",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("wykrzyknik ze znakiem zapytania"),
            keywords: &[
                "!",
                "!?",
                "?",
                "nie rozumiem",
                "pytajnik",
                "pytanie",
                "wykrzyknik",
                "wykrzyknik ze znakiem zapytania",
                "zaskoczenie",
                "znak zapytania",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ندا پوښتنښه"),
            keywords: &[
                "!",
                "!?",
                "?",
                "انټروبينګ",
                "ندا",
                "ندا پوښتنښه",
                "نښه",
                "وقفه",
                "پوښتنه",
            ],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("exclamação com interrogação"),
            keywords: &[
                "!",
                "!?",
                "?",
                "exclamação",
                "exclamação com interrogação",
                "pergunta",
                "pontuação",
                "sinal",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("pontos de exclamação e de interrogação"),
            keywords: &[
                "!",
                "!?",
                "?",
                "exclamação",
                "interrogação",
                "pergunta",
                "pontos de exclamação e de interrogação",
                "pontuação",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("qapariq tapuna chinpuy"),
            keywords: &["qapariq tapuna chinpuy"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("semn de exclamare și întrebare"),
            keywords: &[
                "!",
                "!?",
                "?",
                "exclamație",
                "punctuație",
                "semn de exclamare și întrebare",
                "întrebare",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-003"),
            keywords: &["E10-003"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("восклицательный и вопросительный знаки"),
            keywords: &[
                "вопрос",
                "восклицание",
                "восклицательный и вопросительный знаки",
                "знак",
                "пунктуация",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("agatangaro n’akabazo"),
            keywords: &[
                "agatangaro n’akabazo",
                "akabazo n’agatangaro",
                "akarango",
                "akatuzo",
                "gutangara",
                "ikibazo",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("عجب جي سوال جو نشان"),
            keywords: &[
                "!",
                "!?",
                "?",
                "انٽر روبنگ",
                "سوال",
                "عجب",
                "عجب جي سوال جو نشان",
                "مارڪ",
                "پنڪچويشن",
            ],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some(
                "ව\u{dd2}ස\u{dca}මය\u{dcf}ර\u{dca}ථ ප\u{dca}\u{200d}රශ\u{dca}නය\u{dcf}ර\u{dca}ථ ලක\u{dd4}ණ",
            ),
            keywords: &[
                "ඉන\u{dca}ටෙරොබැන\u{dca}ග\u{dca}",
                "ප\u{dca}\u{200d}රශ\u{dca}නය",
                "ලක\u{dd4}ණ",
                "ව\u{dd2}ර\u{dcf}ම ලක\u{dd4}ණ",
                "ව\u{dd2}ස\u{dca}මය\u{dcf}ර\u{dca}ථ ප\u{dca}\u{200d}රශ\u{dca}නය\u{dcf}ර\u{dca}ථ ලක\u{dd4}ණ",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("výkričník s otáznikom"),
            keywords: &[
                "interpunkcia",
                "otázka",
                "výkričník",
                "výkričník s otáznikom",
                "znak",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("klicaj in vprašaj"),
            keywords: &[
                "!",
                "!?",
                "?",
                "klicaj",
                "klicaj in vprašaj",
                "klicaj-vprašaj",
                "ločilo",
                "vprašaj",
                "znak",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("calaamad cajiib su’aal ah"),
            keywords: &[
                "!",
                "!?",
                "?",
                "cajiib",
                "calaamad",
                "calaamad cajiib su’aal ah",
                "su’aal",
                "xarakayn",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("shenja e pikëpyetjes dhe pikëçuditjes"),
            keywords: &[
                "pikëpyetje",
                "pikësim",
                "pikëçuditje",
                "pyetje",
                "shenja e pikëpyetjes dhe pikëçuditjes",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("узвичник и упитник"),
            keywords: &[
                "знaк",
                "интeрпункциja",
                "питaњe",
                "узвичник",
                "узвичник и упитник",
                "упитник",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("uzvičnik i upitnik"),
            keywords: &[
                "interpunkcija",
                "pitanje",
                "upitnik",
                "uzvičnik",
                "uzvičnik i upitnik",
                "znak",
            ],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("utropstecken och frågetecken"),
            keywords: &[
                "frågetecken",
                "utropstecken",
                "utropstecken och frågetecken",
            ],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("alama ya mshangao na kuuliza"),
            keywords: &[
                "!",
                "!?",
                "?",
                "alama ya mshangao na kuuliza",
                "mshangao",
                "swali",
                "uakifishaji",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some(
                "ஆச\u{bcd}சர\u{bcd}யக\u{bcd} குறியும\u{bcd} கேள\u{bcd}விக\u{bcd}குறியும\u{bcd}",
            ),
            keywords: &[
                "ஆச\u{bcd}சரியக\u{bcd} குறியும\u{bcd} கேள\u{bcd}விக\u{bcd}குறியும\u{bcd}",
                "ஆச\u{bcd}சரியக\u{bcd}குறி",
                "ஆச\u{bcd}சரியம\u{bcd}",
                "ஆச\u{bcd}சர\u{bcd}யக\u{bcd} குறியும\u{bcd} கேள\u{bcd}விக\u{bcd}குறியும\u{bcd}",
                "கேள\u{bcd}விக\u{bcd}குறி",
                "நிறுத\u{bcd}தற\u{bcd}குறி",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some(
                "ఆశ\u{c4d}చర\u{c4d}య\u{c3e}ర\u{c4d}థకం ప\u{c4d}రశ\u{c4d}న\u{c3e}ర\u{c4d}థకం గుర\u{c4d}తు",
            ),
            keywords: &[
                "ఆశ\u{c4d}చర\u{c4d}య\u{c3e}ర\u{c4d}థకం",
                "గుర\u{c4d}తు",
                "ప\u{c4d}రశ\u{c4d}న\u{c3e}ర\u{c4d}థకం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("аломати хитобу савол"),
            keywords: &[
                "аломат",
                "аломати китобатӣ",
                "аломати хитобу савол",
                "интерробанг",
                "савол",
                "хитоб",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เคร\u{e37}\u{e48}องหมายอ\u{e31}ศเจร\u{e35}ย\u{e4c}และคำถาม"),
            keywords: &[
                "!",
                "!?",
                "?",
                "อ\u{e31}ศเจร\u{e35}ย\u{e4c}",
                "เคร\u{e37}\u{e48}องหมายอ\u{e31}ศเจร\u{e35}ย\u{e4c}และคำถาม",
                "เคร\u{e37}\u{e48}องหมายอ\u{e31}ศเจร\u{e35}ย\u{e4c}และเคร\u{e37}\u{e48}องหมายคำถาม",
            ],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("!"),
            keywords: &["!", "ቀይሕ ምልክት ሕቶ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ýüzlenme sorag belgisi"),
            keywords: &[
                "!",
                "!?",
                "?",
                "belgi",
                "dyngy",
                "sorag",
                "ýüzlenme",
                "ýüzlenme sorag belgisi",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("fakaʻiloʻilonga kalanga-fehuʻi"),
            keywords: &[
                "fakaʻiloʻilonga",
                "fakaʻiloʻilonga kalanga-fehuʻi",
                "fehuʻi",
                "kalanga",
            ],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("ünlemli soru işareti"),
            keywords: &[
                "!",
                "!?",
                "?",
                "işaret",
                "noktalama",
                "soru",
                "ünlem",
                "ünlemli soru işareti",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئۈندەشلىك سوئال بەلگىسى"),
            keywords: &[
                "ئۈندەش",
                "ئۈندەشلىك سوئال بەلگىسى",
                "بەلگە",
                "تىنىش",
                "سوئال",
                "سوئاللىق ئۈندەش",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("знак олкику і питання"),
            keywords: &[
                "!?",
                "знак олкику і питання",
                "лігатура з ! і ?",
                "оклик",
                "питання",
                "розділовий знак",
                "інтеробенг",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ندائیہ سوالیہ نشان"),
            keywords: &[
                "!",
                "!?",
                "?",
                "رموزواوقاف",
                "سوال",
                "سوالیہ بینگ",
                "علامت",
                "ندائیہ",
                "ندائیہ سوالیہ نشان",
            ],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("undov soʻroq belgisi"),
            keywords: &[
                "!",
                "!?",
                "?",
                "belgi",
                "savol",
                "tinish belgisi",
                "undov",
                "undov soʻroq belgisi",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("dấu chấm than và dấu chấm hỏi"),
            keywords: &[
                "chấm câu",
                "chấm hỏi",
                "chấm than",
                "dấu",
                "dấu chấm than và dấu chấm hỏi",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("màndarga esklamaasiyoŋ laajte"),
            keywords: &["esklamaasiyoŋ", "interrobang", "laajte", "màndarga", "tomb"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("uphawu lombuzo lwesikhuzo"),
            keywords: &[
                "i-interrobang",
                "isikhuzo",
                "isiphumlisi",
                "umbuzo",
                "uphawu",
                "uphawu lombuzo lwesikhuzo",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("àmì ìyanu oníbéèrè"),
            keywords: &[
                "àmì",
                "àmì ìyanu",
                "àmì ìyanu oníbéèrè",
                "ìfàmìsí",
                "ìfọ\u{300}rọ\u{300}wánilé\u{329}nuwò",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("感歎問號"),
            keywords: &[
                "!",
                "!?",
                "?",
                "問題",
                "感歎問號",
                "感歎號",
                "標誌",
                "標點符號",
            ],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("感叹问号"),
            keywords: &["感叹号", "感叹问号", "标志", "标点符号", "问题"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("感叹疑问号"),
            keywords: &["吃惊", "感叹疑问号", "标点符号", "问号", "！", "！？", "？"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("驚嘆號加問號"),
            keywords: &["標點", "驚嘆號加問號"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("感嘆號加問號"),
            keywords: &["感嘆號加問號", "標點"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("uphawu lombuzo oluyisibabazi"),
            keywords: &[
                "isibabazi",
                "umbuzo",
                "uphawu",
                "uphawu lombuzo oluyisibabazi",
            ],
        },
    ],
};
#[doc = "❓"]
pub const RED_QUESTION_MARK: crate::Emoji = crate::Emoji {
    glyph: "❓",
    codepoint: "2753",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "red question mark",
    group: "Symbols",
    subgroup: "punctuation",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("rooi vraagteken"),
            keywords: &[
                "leesteken",
                "rooi vraagteken",
                "teken",
                "vraag",
                "vraagteken",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የጥያቄ ምልክት"),
            keywords: &["ምልክት", "ሥርዓተ ነጥብ", "የጥያቄ ምልክት", "ጥያቄ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("علامة استفهام حمراء"),
            keywords: &["استفهام", "علامة استفهام", "علامة استفهام حمراء"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ৰঙ\u{9be} ৰঙৰ প\u{9cd}ৰশ\u{9cd}নবোধক চিহ\u{9cd}ন"),
            keywords: &[
                "?",
                "চিন",
                "প\u{9cd}ৰশ\u{9cd}ন",
                "প\u{9cd}ৰশ\u{9cd}নবোধক চিহ\u{9cd}ন",
                "যতি-চিহ\u{9cd}ন",
                "ৰঙ\u{9be} ৰঙৰ প\u{9cd}ৰশ\u{9cd}নবোধক চিহ\u{9cd}ন",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("sual işarəsi"),
            keywords: &["durğu işarəsi", "işarə", "sual", "sual işarəsi"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("пытальнік"),
            keywords: &["?", "знак", "пунктуацыя", "пытальнік", "пытанне"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("въпросителна"),
            keywords: &["въпросителна", "пунктуация"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("প\u{9cd}রশ\u{9cd}নবোধক চিহ\u{9cd}ন"),
            keywords: &[
                "?",
                "চিহ\u{9cd}ন",
                "প\u{9cd}রশ\u{9cd}ন",
                "প\u{9cd}রশ\u{9cd}নবোধক চিহ\u{9cd}ন",
                "যতিচিহ\u{9cd}ন চিহ\u{9cd}ন",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("pik-goulenn ruz"),
            keywords: &["?", "goulenn", "pik-goulenn", "poentadur", "ruz"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("crveni upitnik"),
            keywords: &[
                "?",
                "crveni upitnik",
                "interpunkcija",
                "oznaka",
                "pitanje",
                "upitnik",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("signe d’interrogació vermell"),
            keywords: &[
                "?",
                "interrogació",
                "puntuació",
                "signe",
                "signe d’interrogació",
                "signe d’interrogació vermell",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏛᏛᎲᏍᎩ ᎤᏙᏪᎸ"),
            keywords: &["?", "ᎠᏛᏛᎲᏍᎩ", "ᎤᏙᏪᎸ", "ᏚᏙᏪᎸ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("červený otazník"),
            keywords: &["?", "interpunkční znaménka", "otazník", "červený otazník"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("marc cwestiwn"),
            keywords: &["?", "atalnodiad", "cwestiwn", "marc"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("rødt spørgsmålstegn"),
            keywords: &[
                "?",
                "rødt spørgsmålstegn",
                "spørgsmål",
                "spørgsmålstegn",
                "tegn",
                "tegnsætning",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("rotes Fragezeichen"),
            keywords: &["Fragezeichen", "Satzzeichen", "rot", "rotes Fragezeichen"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κόκκινο λατινικό ερωτηματικό"),
            keywords: &[
                "?",
                "ερώτηση",
                "κόκκινο λατινικό ερωτηματικό",
                "λατινικό ερωτηματικό",
                "σημείο",
                "στίξη",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("red question mark"),
            keywords: &["?", "mark", "punctuation", "question", "red question mark"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("interrogación roja"),
            keywords: &[
                "?",
                "interrogación",
                "interrogación roja",
                "pregunta",
                "puntuación",
                "signo de interrogación",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("signo de interrogación"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("signo de interrogación rojo"),
            keywords: &[
                "?",
                "interrogación",
                "pregunta",
                "puntuación",
                "signo de interrogación",
                "signo de interrogación rojo",
            ],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("punane küsimärk"),
            keywords: &[
                "?",
                "kirjavahemärk",
                "küsimus",
                "küsimärk",
                "punane küsimärk",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("galdera-marka gorria"),
            keywords: &[
                "?",
                "galdera",
                "galdera-marka",
                "galdera-marka gorria",
                "puntuazioa",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("علامت سؤال قرمز"),
            keywords: &[
                "؟",
                "سؤال",
                "علامت",
                "علامت سؤال قرمز",
                "علامت\u{200c}گذاری",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kysymysmerkki"),
            keywords: &["kysymysmerkki", "merkki", "välimerkki"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("tandang pananong"),
            keywords: &[
                "bantas",
                "marka",
                "pananda",
                "pananong",
                "tanda",
                "tandang pananong",
                "tanong",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("spurnartekn"),
            keywords: &["spurnartekn", "spurningur", "teknseting"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("point d’interrogation rouge"),
            keywords: &[
                "?",
                "interrogation",
                "point d’interrogation",
                "point d’interrogation rouge",
                "ponctuation",
                "question",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &[
                "point d’interrogation",
                "point d’interrogation rouge",
                "ponctuation",
                "question",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("comhartha ceiste dearg"),
            keywords: &[
                "?",
                "ceist",
                "comhartha ceiste",
                "comhartha ceiste dearg",
                "marc",
                "poncaíocht",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("comharra-ceiste dearg"),
            keywords: &[
                "?",
                "comharra",
                "comharra-ceiste",
                "comharra-ceiste dearg",
                "puingeachadh",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("signo de interrogación vermello"),
            keywords: &[
                "?",
                "interrogación",
                "pregunta",
                "signo de interrogación",
                "signo de interrogación vermello",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("લાલ પ\u{acd}રશ\u{acd}નાર\u{acd}થ ચિહ\u{acd}ન"),
            keywords: &[
                "?",
                "પ\u{acd}રશ\u{acd}ન",
                "પ\u{acd}રશ\u{acd}નાર\u{acd}થ ચિહ\u{acd}ન",
                "લાલ પ\u{acd}રશ\u{acd}નાર\u{acd}થ ચિહ\u{acd}ન",
                "વિરામચિહ\u{acd}ન",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("alamar tambaya"),
            keywords: &["alama", "alamar tambaya", "alamomin rubutu", "tambaya"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("סימן שאלה אדום"),
            keywords: &["סימן שאלה", "סימן שאלה אדום", "שאלה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("प\u{94d}रश\u{94d}न चिह\u{94d}न"),
            keywords: &[
                "चिह\u{94d}न",
                "चिह\u{94d}न विचार",
                "प\u{94d}रश\u{94d}न",
                "लाल प\u{94d}रश\u{94d}न चिह\u{94d}न",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("crveni upitnik"),
            keywords: &[
                "crveni upitnik",
                "interpunkcija",
                "pitanje",
                "upitnik",
                "znak",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("piros kérdőjel"),
            keywords: &[
                "kérdés",
                "kérdőjel",
                "központozás",
                "piros kérdőjel",
                "írásjel",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("հարցական նշան"),
            keywords: &["?", "կետադրություն", "հարց", "հարցական նշան", "նշան"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("tanda tanya merah"),
            keywords: &[
                "pertanyaan",
                "tanda",
                "tanda baca",
                "tanda tanya",
                "tanda tanya merah",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("akara njụajụjụ"),
            keywords: &["akara", "njụajụjụ", "ntụpọ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("rautt spurningarmerki"),
            keywords: &[
                "greinarmerki",
                "merki",
                "rautt spurningarmerki",
                "spurning",
                "spurningarmerki",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("punto interrogativo rosso"),
            keywords: &[
                "domanda",
                "punto di domanda pieno",
                "punto interrogativo rosso",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("赤い疑問符"),
            keywords: &[
                "?",
                "はてなマーク",
                "クエスチョンマーク",
                "疑問符",
                "約物",
                "記号",
                "赤い疑問符",
            ],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("tandha pitakon abang"),
            keywords: &[
                "?",
                "pitakon",
                "tandha",
                "tandha pitakon abang",
                "tandha wacan",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("წითელი კითხვის ნიშანი"),
            keywords: &[
                "კითხვა",
                "კითხვის ნიშანი",
                "ნიშანი",
                "პუნქტუაცია",
                "წითელი კითხვის ნიშანი",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("сұрақ белгісі"),
            keywords: &["белгі", "пунктуация", "сұрақ", "сұрақ белгісі"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("spørgsmålstegn"),
            keywords: &["spørgsmål", "spørgsmålstegn", "tegn", "tegnsætning"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("សញ\u{17d2}ញាស\u{17bd}រ"),
            keywords: &[
                "?",
                "វណ\u{17d2}ណយ\u{17bb}ត\u{17d2}ត",
                "សញ\u{17d2}ញា",
                "សញ\u{17d2}ញាស\u{17bd}រ",
                "ស\u{17bd}រ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some(
                "ಕ\u{cc6}ಂಪು ಬಣ\u{ccd}ಣದ ಪ\u{ccd}ರಶ\u{ccd}ನಾರ\u{ccd}ಥಕ ಚ\u{cbf}ಹ\u{ccd}ನ\u{cc6}",
            ),
            keywords: &[
                "?",
                "ಕ\u{cc6}ಂಪು ಬಣ\u{ccd}ಣದ ಪ\u{ccd}ರಶ\u{ccd}ನಾರ\u{ccd}ಥಕ ಚ\u{cbf}ಹ\u{ccd}ನ\u{cc6}",
                "ಪ\u{ccd}ರಶ\u{ccd}ನಾರ\u{ccd}ಥಕ ಗುರುತು",
                "ಪ\u{ccd}ರಶ\u{ccd}ನಾರ\u{ccd}ಥಕ ಚ\u{cbf}ಹ\u{ccd}ನ\u{cc6}",
                "ಪ\u{ccd}ರಶ\u{ccd}ನ\u{cc6}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("빨간색 물음표"),
            keywords: &["물음", "물음표", "빨간색 물음표", "의문", "질문"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("प\u{94d}रस\u{94d}न चिन\u{94d}न"),
            keywords: &["?", "चिन\u{94d}न", "प\u{94d}रस\u{94d}न", "विरामचिन\u{94d}न"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("кызыл суроо белгиси"),
            keywords: &[
                "белги",
                "кызыл суроо белгиси",
                "пунктуация",
                "суроо",
                "суроо белгиси",
            ],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Fragezeechen"),
            keywords: &["Fragezeechen", "Fro", "Interpunktioun", "Zeechen"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເຄ\u{eb7}\u{ec8}ອງໝາຍຖາມ"),
            keywords: &["ຄຳຖາມ", "ເຄ\u{eb7}\u{ec8}ອງໝາຍ", "ເຄ\u{eb7}\u{ec8}ອງໝາຍຖາມ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("raudonas klaustukas"),
            keywords: &[
                "klausimas",
                "klaustukas",
                "raudonas klaustukas",
                "skyryba",
                "žymė",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("sarkana jautājuma zīme"),
            keywords: &[
                "?",
                "jautājuma zīme",
                "jautājums",
                "pieturzīme",
                "sarkana jautājuma zīme",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tohu pātai"),
            keywords: &["pātai", "tohu", "tohutuhi"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("црвен прашалник"),
            keywords: &["знак", "интерпункција", "прашалник", "црвен прашалник"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ച\u{d41}വന\u{d4d}ന ചോദ\u{d4d}യ ചിഹ\u{d4d}നം"),
            keywords: &[
                "?",
                "ചിഹ\u{d4d}നം",
                "ച\u{d41}വന\u{d4d}ന ചോദ\u{d4d}യ ചിഹ\u{d4d}നം",
                "ചോദ\u{d4d}യം",
                "വിര\u{d3e}മ ചിഹ\u{d4d}നം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("улаан асуултын тэмдэг"),
            keywords: &[
                "?",
                "асуулт",
                "асуултын тэмдэг",
                "улаан асуултын тэмдэг",
                "цэг тэмдэг",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("प\u{94d}रश\u{94d}नचिन\u{94d}ह"),
            keywords: &[
                "चिन\u{94d}ह",
                "प\u{94d}रश\u{94d}न",
                "प\u{94d}रश\u{94d}नचिन\u{94d}ह",
                "विरामचिन\u{94d}ह",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("tanda soal"),
            keywords: &["?", "soalan", "tanda", "tanda baca", "tanda soal"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("punt interrogattiv"),
            keywords: &["marka", "mistoqsija", "punt interrogattiv", "punteġġjatura"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("မေးခ\u{103d}န\u{103a}း သင\u{103a}\u{1039}ကေတ"),
            keywords: &[
                "ပ\u{102f}ဒ\u{103a}ဖြတ\u{103a}ပ\u{102f}ဒ\u{103a}ရပ\u{103a}",
                "မေးခ\u{103d}န\u{103a}း သင\u{103a}\u{1039}ကေတ",
                "အမ\u{103e}တ\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("rødt spørsmålstegn"),
            keywords: &["?", "rødt spørsmålstegn", "spørsmål", "spørsmålstegn"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("प\u{94d}रश\u{94d}न चिन\u{94d}ह"),
            keywords: &["चिन\u{94d}ह", "प\u{94d}रश\u{94d}न", "विराम चिन\u{94d}ह"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("rood vraagteken"),
            keywords: &["?", "interpunctie", "rood vraagteken", "teken", "vraag"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("raudt spørsmålsteikn"),
            keywords: &["?", "raudt spørsmålsteikn", "spørsmål", "spørsmålsteikn"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଲ\u{b3e}ଲ\u{b4d} ପ\u{b4d}ରଶ\u{b4d}ନବ\u{b3e}ଚକ ଚ\u{b3f}ହ\u{b4d}"),
            keywords: &[
                "?",
                "ଚ\u{b3f}ହ\u{b4d}ନ",
                "ପ\u{b4d}ରଶ\u{b4d}ନ",
                "ପ\u{b4d}ରଶ\u{b4d}ନବ\u{b3e}ଚକ ଚ\u{b3f}ହ\u{b4d}ନ",
                "ବ\u{b3f}ର\u{b3e}ମ ଚ\u{b3f}ହ\u{b4d}ନ",
                "ଲ\u{b3e}ଲ\u{b4d} ପ\u{b4d}ରଶ\u{b4d}ନବ\u{b3e}ଚକ ଚ\u{b3f}ହ\u{b4d}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਸਵਾਲ ਚਿ\u{a70}ਨ\u{a4d}ਹ"),
            keywords: &["ਚਿ\u{a70}ਨ\u{a4d}ਹ", "ਸਵਾਲ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("سوالیہ نشان"),
            keywords: &["رموز اوقاف", "سوال", "سوالیہ نشان", "نشان لانا"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Kwẹ\u{301}shọn Mak"),
            keywords: &["?", "Kwẹ\u{301}shọn", "Mak", "Pọnkchuéshọn"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("czerwony znak zapytania"),
            keywords: &[
                "?",
                "czerwony znak zapytania",
                "o co chodzi",
                "pytajnik",
                "pytanie",
                "znak zapytania",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("پوښتنښه"),
            keywords: &["?", "د وقفې علامت", "نښه", "پوښتنه", "پوښتنښه"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("ponto de interrogação vermelho"),
            keywords: &[
                "?",
                "pergunta",
                "ponto de interrogação",
                "ponto de interrogação vermelho",
                "pontuação",
                "sinal",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("ponto de interrogação vermelho"),
            keywords: &[
                "?",
                "interrogação",
                "pergunta",
                "ponto de interrogação",
                "ponto de interrogação vermelho",
                "pontuação",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("semnul întrebării roșu"),
            keywords: &[
                "punctuație",
                "semn",
                "semnul întrebării",
                "semnul întrebării roșu",
                "întrebare",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-142"),
            keywords: &["E10-142"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("красный вопросительный знак"),
            keywords: &[
                "вопрос",
                "вопросительный знак",
                "знак",
                "красный",
                "красный вопросительный знак",
                "пунктуация",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("akabazo gacuritse"),
            keywords: &["akabazo gacuritse", "akarango", "akatuzo", "ikibazo"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڳاڙهي سوال جي نشاني"),
            keywords: &[
                "?",
                "سوال",
                "سوال جي نشاني",
                "مارڪ",
                "پنڪچويشن",
                "ڳاڙهي سوال جي نشاني",
            ],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ප\u{dca}\u{200d}රශ\u{dca}නය\u{dcf}ර\u{dca}ථ ලක\u{dd4}ණ"),
            keywords: &[
                "ප\u{dca}\u{200d}රශ\u{dca}නය",
                "ප\u{dca}\u{200d}රශ\u{dca}නය\u{dcf}ර\u{dca}ථ ලක\u{dd4}ණ",
                "ලක\u{dd4}ණ",
                "ව\u{dd2}ර\u{dcf}ම ලක\u{dd4}ණ",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("červený otáznik"),
            keywords: &[
                "?",
                "interpunkcia",
                "otázka",
                "otáznik",
                "znak",
                "červený otáznik",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("rdeč vprašaj"),
            keywords: &["?", "ločilo", "rdeč vprašaj", "vprašaj", "znak"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("calaamad su’aal"),
            keywords: &["?", "calaamad", "su’aal", "xarakayn"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("shenja e pikëpyetjes e kuqe"),
            keywords: &[
                "pikëpyetje",
                "pikësim",
                "pyetje",
                "shenja e pikëpyetjes e kuqe",
                "shenjë",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("упитник"),
            keywords: &["знaк", "интeрпункциja", "питaњe", "упитник"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("upitnik"),
            keywords: &["interpunkcija", "pitanje", "upitnik", "znak"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("rött frågetecken"),
            keywords: &["fråga", "frågetecken", "rött frågetecken"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("alama nyekundu ya kuuliza"),
            keywords: &[
                "?",
                "alama",
                "alama nyekundu ya kuuliza",
                "alama ya kuuliza",
                "swali",
                "uakifishaji",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some(
                "கேள\u{bcd}விக\u{bcd} குறி, அடர\u{bcd} நிறக\u{bcd} கேள\u{bcd}விக\u{bcd} குறி",
            ),
            keywords: &[
                "அடர\u{bcd} நிற கேள\u{bcd}விக\u{bcd} குறி",
                "குறி",
                "கேள\u{bcd}விக\u{bcd} குறி",
                "கேள\u{bcd}விக\u{bcd} குறி, அடர\u{bcd} நிறக\u{bcd} கேள\u{bcd}விக\u{bcd} குறி",
                "நிறுத\u{bcd}தற\u{bcd}குறி",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ఎరుపు రంగు ప\u{c4d}రశ\u{c4d}న గుర\u{c4d}తు"),
            keywords: &[
                "ఎరుపు రంగు ప\u{c4d}రశ\u{c4d}న గుర\u{c4d}తు",
                "గుర\u{c4d}తు",
                "ప\u{c4d}రశ\u{c4d}న",
                "వ\u{c3f}ర\u{c3e}మ చ\u{c3f}హ\u{c4d}నం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("аломати савол"),
            keywords: &["аломат", "аломати китобатӣ", "аломати савол", "савол"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เคร\u{e37}\u{e48}องหมายคำถาม"),
            keywords: &[
                "?",
                "คำถาม",
                "เคร\u{e37}\u{e48}องหมาย",
                "เคร\u{e37}\u{e48}องหมายคำถาม",
                "เคร\u{e37}\u{e48}องหมายวรรคตอน",
            ],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ቀይሕ ምልክት ሕቶ"),
            keywords: &["ቀይሕ ምልክት ሕቶ", "ጻዕዳ ምልክት ሕቶ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("gyzyl sorag belgisi"),
            keywords: &[
                "?",
                "belgi",
                "dyngy",
                "gyzyl sorag belgisi",
                "sorag",
                "sorag belgisi",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("fakaʻilonga fehuʻi kulokula"),
            keywords: &["fakaʻilonga", "fakaʻilonga fehuʻi kulokula", "fehuʻi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("kırmızı soru işareti"),
            keywords: &[
                "?",
                "işaret",
                "kırmızı soru işareti",
                "noktalama",
                "soru",
                "soru işareti",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("سوئال بەلگىسى"),
            keywords: &["بەلگە", "تىنىش", "سوئال", "سوئال بەلگىسى"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("червоний знак питання"),
            keywords: &[
                "?",
                "знак питання",
                "питання",
                "пунктуація",
                "розділовий знак",
                "червоний знак питання",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("سرخ سوالیہ نشان"),
            keywords: &[
                "?",
                "رموز\u{650} اوقاف",
                "سرخ سوالیہ نشان",
                "سوال",
                "سوالیہ نشان",
                "علامت",
            ],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("qizil soʻroq belgisi"),
            keywords: &[
                "?",
                "belgi",
                "qizil soʻroq belgisi",
                "savol",
                "soʻroq belgisi",
                "tinish belgisi",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("dấu chấm hỏi"),
            keywords: &["chấm câu", "dấu", "dấu chấm hỏi", "hỏi"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("tombu laajte"),
            keywords: &["laajte", "màndarga", "tomb", "tombu laajte"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("uphawu lombuzo"),
            keywords: &["isiphumlisi", "umbuzo", "uphawu", "uphawu lombuzo"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("àmì ìbéèrè ìdàkodò"),
            keywords: &["àmì", "àmì ìbéèrè ìdàkodò", "ìbéèrè", "ìfàmìsí"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("紅色問號"),
            keywords: &["?", "問號", "問題", "標點符號", "符號", "紅色問號"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("红色问号"),
            keywords: &["?", "标点符号", "符号", "红色问号", "问号", "问题"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("红色问号"),
            keywords: &["为什么", "标点符号", "红色问号", "问号"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("紅色問號"),
            keywords: &["問號", "標點", "紅色問號"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["問號", "問題", "標點", "紅色問號"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("uphawu lombuzo"),
            keywords: &["umbuzo", "uphaqu", "uphawu lombuzo"],
        },
    ],
};
#[doc = "❔"]
pub const WHITE_QUESTION_MARK: crate::Emoji = crate::Emoji {
    glyph: "❔",
    codepoint: "2754",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "white question mark",
    group: "Symbols",
    subgroup: "punctuation",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("wit vraagteken"),
            keywords: &["buitelyn", "leesteken", "teken", "vraag", "wit vraagteken"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ነጭ የጥያቄ ምልክት"),
            keywords: &["ምልክት", "ሥርዓተ ነጥብ", "ነጭ የጥያቄ ምልክት", "የተነደፈ", "ጥያቄ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("علامة استفهام بيضاء"),
            keywords: &["استفهام", "علامة استفهام بيضاء"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("বগ\u{9be} ৰঙৰ প\u{9cd}ৰশ\u{9cd}নবোধক চিন"),
            keywords: &[
                "?",
                "চিন",
                "প\u{9cd}ৰশ\u{9cd}ন",
                "প\u{9cd}ৰ\u{9be}ন\u{9cd}তৰেখ\u{9be}য\u{9c1}ক\u{9cd}ত",
                "বগ\u{9be} ৰঙৰ প\u{9cd}ৰশ\u{9cd}নবোধক চিন",
                "যতি-চিহ\u{9cd}ন",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("ağ sual işarəsi"),
            keywords: &[
                "ağ sual işarəsi",
                "durğu işarəsi",
                "işarə",
                "qeyd edilmiş",
                "sual",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("белы пытальнік"),
            keywords: &[
                "?",
                "белы пытальнік",
                "знак",
                "контур",
                "пунктуацыя",
                "пытанне",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Бяла въпросителна"),
            keywords: &["Бяла въпросителна", "въпросителна", "контур", "пунктуация"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("স\u{9be}দ\u{9be} প\u{9cd}রশ\u{9cd}নবোধক চিহ\u{9cd}ন"),
            keywords: &[
                "?",
                "চিহ\u{9cd}ন",
                "প\u{9cd}রশ\u{9cd}ন",
                "যতিচিহ\u{9cd}ন",
                "র\u{9c2}পরেখ\u{9be}",
                "স\u{9be}দ\u{9be} প\u{9cd}রশ\u{9cd}নবোধক চিহ\u{9cd}ন",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("pik-goulenn gwenn"),
            keywords: &["?", "goulenn", "gwenn", "pik-goulenn", "poentadur"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("bijeli upitnik"),
            keywords: &[
                "?",
                "bijeli upitnik",
                "interpunkcija",
                "ocrtano",
                "oznaka",
                "pitanje",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("signe d’interrogació blanc"),
            keywords: &[
                "?",
                "blanc",
                "interrogació",
                "puntuació",
                "signe",
                "signe d’interrogació blanc",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᏁᎦ ᎠᏛᏛᎲᏍᎩ ᎤᏙᏪᎸ"),
            keywords: &["?", "ᎠᏛᏛᎲᏍᎩ", "ᎤᏁᎦ ᎠᏛᏛᎲᏍᎩ ᎤᏙᏪᎸ", "ᎤᏙᏪᎸ", "ᎦᏕᏱᏍᏔᏅᎢ", "ᏚᏙᏪᎸ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("bílý otazník"),
            keywords: &[
                "?",
                "bílý otazník",
                "interpunkční znaménka",
                "obrys",
                "otazník",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("marc cwestiwn gwyn"),
            keywords: &[
                "?",
                "amlinelliad",
                "atalnodiad",
                "cwestiwn",
                "marc",
                "marc cwestiwn gwyn",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("hvidt spørgsmålstegn"),
            keywords: &[
                "hvidt spørgsmålstegn",
                "omrids",
                "spørgsmål",
                "tegn",
                "tegnsætning",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("weißes Fragezeichen"),
            keywords: &["Satzzeichen", "weiß", "weißes Fragezeichen"],
        },
        #[cfg(feature = "de_CH")]
        crate::Annotation {
            lang: "de_CH",
            tts: Some("weisses Fragezeichen"),
            keywords: &["Satzzeichen", "weiss", "weisses Fragezeichen"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("λευκό λατινικό ερωτηματικό"),
            keywords: &[
                "?",
                "αχνό",
                "ερώτηση",
                "λευκό λατινικό ερωτηματικό",
                "σημείο",
                "στίξη",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("white question mark"),
            keywords: &[
                "?",
                "mark",
                "outlined",
                "punctuation",
                "question",
                "white question mark",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("interrogación blanca"),
            keywords: &[
                "?",
                "interrogación",
                "interrogación blanca",
                "pregunta",
                "puntuación",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("signo de interrogación gris"),
            keywords: &[
                "?",
                "interrogación",
                "interrogación blanca",
                "pregunta",
                "puntuación",
                "signo de interrogación gris",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("signo de interrogación blanco"),
            keywords: &[
                "?",
                "pregunta",
                "puntuación",
                "signo",
                "signo de interrogación blanco",
                "signo interrogación blanco",
            ],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("valge küsimärk"),
            keywords: &[
                "?",
                "kirjavahemärk",
                "küsimus",
                "küsimärk",
                "valge küsimärk",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("galdera-marka zuria"),
            keywords: &[
                "galdera",
                "galdera-marka zuria",
                "marka",
                "nabarmendu",
                "puntuazio",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("علامت سؤال سفید"),
            keywords: &[
                "؟",
                "سؤال",
                "علامت",
                "علامت سؤال سفید",
                "علامت\u{200c}گذاری",
                "نقطه\u{200c}گذاری",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("valkoinen kysymysmerkki"),
            keywords: &[
                "kysymysmerkki",
                "merkki",
                "valkoinen kysymysmerkki",
                "välimerkki",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("puting tandang pananong"),
            keywords: &[
                "?",
                "bantas",
                "marka",
                "naka-outline",
                "puting tandang pananong",
                "tanong",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("hvítt spurnartekn"),
            keywords: &[
                "greinarmerki",
                "hvítt spurnartekn",
                "spurnartekn",
                "teknseting",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("point d’interrogation blanc"),
            keywords: &[
                "?",
                "interrogation",
                "point d’interrogation blanc",
                "ponctuation",
                "question",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &[
                "point d’interrogation",
                "point d’interrogation blanc",
                "ponctuation",
                "question",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("comhartha ceiste bán"),
            keywords: &[
                "?",
                "comhartha ceiste bán",
                "imlínithe",
                "marc",
                "poncaíocht",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("comharra-ceiste geal"),
            keywords: &[
                "?",
                "comharra",
                "comharra-ceiste",
                "comharra-ceiste geal",
                "oir-loidhne",
                "puingeachadh",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("signo de interrogación branco"),
            keywords: &[
                "?",
                "interrogación",
                "pregunta",
                "signo de interrogación branco",
                "símbolo de interrogación",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("સફ\u{ac7}દ પ\u{acd}રશ\u{acd}નાર\u{acd}થ ચિહ\u{acd}ન"),
            keywords: &[
                "?",
                "ચિહ\u{acd}ન",
                "પ\u{acd}રશ\u{acd}ન",
                "પ\u{acd}રશ\u{acd}નાર\u{acd}થ ચિહ\u{acd}ન",
                "બાહ\u{acd}યર\u{ac7}ખા\u{a82}કિત",
                "વિરામચિહ\u{acd}ન",
                "સફ\u{ac7}દ પ\u{acd}રશ\u{acd}નાર\u{acd}થ ચિહ\u{acd}ન",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("farar alamar tambaya"),
            keywords: &[
                "alama",
                "alamomin rubutu",
                "farar alamar tambaya",
                "mai rubutu a gefe",
                "tambaya",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("סימן שאלה לבן"),
            keywords: &["סימן שאלה", "סימן שאלה לבן", "שאלה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("सफ\u{93c}\u{947}द प\u{94d}रश\u{94d}न चिह\u{94d}न"),
            keywords: &[
                "चिह\u{94d}न",
                "चिह\u{94d}न विचार",
                "प\u{94d}रश\u{94d}न",
                "सफ\u{93c}\u{947}द प\u{94d}रश\u{94d}न चिह\u{94d}न",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("bijeli upitnik"),
            keywords: &[
                "bijeli upitnik",
                "interpunkcija",
                "obris",
                "pitanje",
                "znak",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("fehér kérdőjel"),
            keywords: &[
                "fehér",
                "fehér kérdőjel",
                "kérdés",
                "központozás",
                "írásjel",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("սպիտակ հարցական նշան"),
            keywords: &[
                "կետադրություն",
                "հարց",
                "նշան",
                "ուրվագծված",
                "սպիտակ հարցական նշան",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("tanda tanya putih"),
            keywords: &[
                "garis luar",
                "pertanyaan",
                "tanda",
                "tanda baca",
                "tanda tanya putih",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("akara njụajụjụ dị ọcha"),
            keywords: &[
                "akara",
                "akara njụajụjụ dị ọcha",
                "ndepụta",
                "njụajụjụ",
                "ntụpọ",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("hvítt spurningarmerki"),
            keywords: &["greinarmerki", "hvítt spurningarmerki", "merki", "spurning"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("punto interrogativo bianco"),
            keywords: &[
                "domanda",
                "punto di domanda vuoto",
                "punto interrogativo bianco",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("白い疑問符"),
            keywords: &[
                "?",
                "はてなマーク",
                "クエスチョンマーク",
                "白い疑問符",
                "約物",
                "記号",
            ],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("tandha pitakon putih"),
            keywords: &[
                "?",
                "garis pinggir cetha",
                "pitakon",
                "tandha",
                "tandha pitakon putih",
                "tandha wacan",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("თეთრი კითხვის ნიშანი"),
            keywords: &[
                "თეთრი კითხვის ნიშანი",
                "კითხვა",
                "კონტურიანი",
                "ნიშანი",
                "პუნქტუაცია",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("ақ сұрақ белгісі"),
            keywords: &["ақ сұрақ белгісі", "белгі", "пунктуация", "сызулы", "сұрақ"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("hvidt spørgsmålstegn"),
            keywords: &[
                "hvidt spørgsmålstegn",
                "omrids",
                "spørgsmål",
                "tegn",
                "tegnsætning",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("សញ\u{17d2}ញាស\u{17bd}រពណ\u{17cc}ស"),
            keywords: &[
                "?",
                "សញ\u{17d2}ញា",
                "សញ\u{17d2}ញាស\u{17bd}រពណ\u{17cc}ស",
                "ស\u{17bd}រ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಬ\u{cbf}ಳ\u{cbf} ಪ\u{ccd}ರಶ\u{ccd}ನಾರ\u{ccd}ಥಕ ಗುರುತು"),
            keywords: &[
                "ಪ\u{ccd}ರಶ\u{ccd}ನಾರ\u{ccd}ಥಕ ಚ\u{cbf}ಹ\u{ccd}ನ\u{cc6}",
                "ಪ\u{ccd}ರಶ\u{ccd}ನ\u{cc6}",
                "ಬ\u{cbf}ಳ\u{cbf} ಪ\u{ccd}ರಶ\u{ccd}ನಾರ\u{ccd}ಥಕ ಗುರುತು",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("하얀색 물음표"),
            keywords: &["물음", "의문", "질문", "하얀색 물음표"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("धव\u{947}\u{902} प\u{94d}रस\u{94d}न चिन\u{94d}न"),
            keywords: &[
                "?",
                "चिन\u{94d}न",
                "धव\u{947}\u{902} प\u{94d}रस\u{94d}न चिन\u{94d}न",
                "प\u{94d}रस\u{94d}न",
                "र\u{941}पर\u{947}खा",
                "विरामचिन\u{94d}न",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("ак суроо белгиси"),
            keywords: &["ак суроо белгиси", "белги", "пунктуация", "суроо"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("wäisst Fragezeechen"),
            keywords: &[
                "Fro",
                "Interpunktioun",
                "Kontur",
                "Zeechen",
                "wäisst Fragezeechen",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເຄ\u{eb7}\u{ec8}ອງໝາຍຖາມສ\u{eb5}ຂາວ"),
            keywords: &[
                "ຄ\u{ecd}າຖາມ",
                "ສ\u{eb5}ຂາວ",
                "ເຄ\u{eb7}\u{ec8}ອງໝາຍ",
                "ເຄ\u{eb7}\u{ec8}ອງໝາຍຖາມສ\u{eb5}ຂາວ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("baltas klaustukas"),
            keywords: &[
                "baltas klaustukas",
                "klausimas",
                "kontūras",
                "skyryba",
                "žymė",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("balta jautājuma zīme"),
            keywords: &["?", "balta jautājuma zīme", "jautājums", "pieturzīme"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tohu pātai mā"),
            keywords: &["pātai", "tohu", "tohu pātai mā", "tohutuhi", "whakahuahua"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("бел прашалник"),
            keywords: &["бел прашалник", "знак", "интерпункција", "прашалник"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("വെള\u{d41}ത\u{d4d}ത ചോദ\u{d4d}യ ചിഹ\u{d4d}നം"),
            keywords: &[
                "?",
                "അടിവരയിട\u{d4d}ടത\u{d4d}",
                "ചോദ\u{d4d}യം",
                "വെള\u{d41}ത\u{d4d}ത ചോദ\u{d4d}യ ചിഹ\u{d4d}നം",
                "വെള\u{d41}പ\u{d4d}പ\u{d4d} ചോദ\u{d4d}യ ചിഹ\u{d4d}നം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("цагаан асуултын тэмдэг"),
            keywords: &["?", "асуулт", "тэмдэг", "цагаан асуултын тэмдэг", "цэг"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("पा\u{902}ढर\u{947} प\u{94d}रश\u{94d}नचिन\u{94d}ह"),
            keywords: &[
                "आराखडा",
                "चिन\u{94d}ह",
                "पा\u{902}ढर\u{947} प\u{94d}रश\u{94d}न चिन\u{94d}ह",
                "पा\u{902}ढर\u{947} प\u{94d}रश\u{94d}नचिन\u{94d}ह",
                "प\u{94d}रश\u{94d}न",
                "विरामचिन\u{94d}ह",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("tanda soal putih"),
            keywords: &[
                "?",
                "digaris",
                "soalan",
                "tanda",
                "tanda baca",
                "tanda soal putih",
                "tanda soalan putih",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("punt interrogattiv abjad"),
            keywords: &[
                "marka",
                "mistoqsija",
                "punt interrogattiv abjad",
                "punteġġjatura",
                "spjegati",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အဖြ\u{1030}ရောင\u{103a} မေးခ\u{103d}န\u{103a}း သင\u{103a}\u{1039}ကေတ"),
            keywords: &[
                "ပ\u{102f}ဒ\u{103a}ဖြတ\u{103a}ပ\u{102f}ဒ\u{103a}ရပ\u{103a}",
                "မေးခ\u{103d}န\u{103a}း",
                "အဖြ\u{1030}ရောင\u{103a} မေးခ\u{103d}န\u{103a}း သင\u{103a}\u{1039}ကေတ",
                "အမ\u{103e}တ\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("hvitt spørsmålstegn"),
            keywords: &["?", "hvitt spørsmålstegn", "spørsmål"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("स\u{947}तो प\u{94d}रश\u{94d}न चिन\u{94d}ह"),
            keywords: &[
                "चिन\u{94d}ह",
                "प\u{94d}रश\u{94d}न",
                "बाहिरि र\u{947}खा",
                "विराम चिन\u{94d}ह",
                "स\u{947}तो प\u{94d}रश\u{94d}न चिन\u{94d}ह",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("wit vraagteken"),
            keywords: &[
                "?",
                "contour",
                "interpunctie",
                "teken",
                "vraag",
                "wit vraagteken",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("kvitt spørsmålsteikn"),
            keywords: &["?", "kvitt spørsmålsteikn", "spørsmål"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଧଳ\u{b3e} ପ\u{b4d}ରଶ\u{b4d}ନବ\u{b3e}ଚକ ଚ\u{b3f}ହ\u{b4d}ନ"),
            keywords: &[
                "?",
                "ଚ\u{b3f}ହ\u{b4d}ନ । ବ\u{b3e}ହ\u{b4d}ୟରେଖ\u{b3e}କ\u{b43}ତ । ବ\u{b3f}ର\u{b3e}ମ ଚ\u{b3f}ହ\u{b4d}ନ । ପ\u{b4d}ରଶ\u{b4d}ନ",
                "ଧଳ\u{b3e} ପ\u{b4d}ରଶ\u{b4d}ନବ\u{b3e}ଚକ ଚ\u{b3f}ହ\u{b4d}ନ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਸਫ\u{a47}ਦ ਸਵਾਲ ਚਿ\u{a70}ਨ\u{a4d}ਹ"),
            keywords: &[
                "ਵਿਰਾਮ ਚਿ\u{a70}ਨ\u{a4d}ਹ",
                "ਸਫ\u{a47}ਦ ਸਵਾਲ ਚਿ\u{a70}ਨ\u{a4d}ਹ",
                "ਸਵਾਲ",
                "ਸਵਾਲ ਚਿ\u{a70}ਨ\u{a4d}ਹ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("چٹ\u{651}ا سوالیہ نشان"),
            keywords: &[
                "خاکہ ش\u{64f}دہ",
                "رموز اوقاف",
                "سوال",
                "نشان لانا",
                "چٹ\u{651}ا سوالیہ نشان",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Waít Kwẹ\u{301}shọn Mak"),
            keywords: &[
                "?",
                "Aútlain",
                "Kwẹ\u{301}shọn",
                "Mak",
                "Pọnkchuéshọn",
                "Waít Kwẹ\u{301}shọn Mak",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("biały znak zapytania"),
            keywords: &[
                "biały znak zapytania",
                "o co chodzi?",
                "pytajnik",
                "pytanie",
                "znak zapytania",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("سپينه پوښتنښه"),
            keywords: &["حاشيه", "د وقفې علامت", "سپينه پوښتنښه", "نښه", "پوښتنه"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("ponto de interrogação branco"),
            keywords: &[
                "?",
                "delineado",
                "pergunta",
                "ponto de interrogação branco",
                "pontuação",
                "sinal",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &[
                "?",
                "delineado",
                "pergunta",
                "ponto de interrogação branco",
                "pontuação",
                "sinal",
                "sinal de interrogação branco",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("yuraq tapukuna yupiy"),
            keywords: &["yuraq tapukuna yupiy"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("semnul întrebării alb"),
            keywords: &[
                "contur",
                "punctuație",
                "semn",
                "semnul întrebării alb",
                "întrebare",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-143"),
            keywords: &["E10-143"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("белый вопросительный знак"),
            keywords: &[
                "белый",
                "белый вопросительный знак",
                "вопрос",
                "знак",
                "пунктуация",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ikimenyetso cy’akabazo k’umweru"),
            keywords: &[
                "akarango",
                "akatuzo",
                "cyagaragajwe",
                "ikibazo",
                "ikimenyetso cy’akabazo k’umweru",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("سفيد سوال جي نشاني"),
            keywords: &[
                "?",
                "آئوٽ لائن ٿيل",
                "سفيد سوال جي نشاني",
                "سوال",
                "مارڪ",
                "پنڪچويشن",
            ],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ස\u{dd4}ද\u{dd4} ප\u{dca}\u{200d}රශ\u{dca}නය\u{dcf}ර\u{dca}ථ ලක\u{dd4}ණ"),
            keywords: &[
                "ප\u{dca}\u{200d}රශ\u{dca}නය",
                "ලක\u{dd4}ණ",
                "ව\u{dd2}ර\u{dcf}ම ලක\u{dd4}ණ",
                "ව\u{dd2}ැට\u{dd2}සන",
                "ස\u{dd4}ද\u{dd4} ප\u{dca}\u{200d}රශ\u{dca}නය\u{dcf}ර\u{dca}ථ ලක\u{dd4}ණ",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("biely otáznik"),
            keywords: &["biely otáznik", "interpunkcia", "obrys", "otázka", "znak"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("bel vprašaj"),
            keywords: &[
                "?",
                "bel vprašaj",
                "ločilo",
                "obrobljeno",
                "oznaka",
                "vprašaj",
                "vprašanje",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("ccalaamad su’aal cad"),
            keywords: &[
                "?",
                "calaamad",
                "ccalaamad su’aal cad",
                "kormaris",
                "su’aal",
                "xarakayn",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("pikëpyetje e bardhë"),
            keywords: &["?", "e konturuar", "pikëpyetje e bardhë", "pikësim"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("бели упитник"),
            keywords: &["oбрис", "бели упитник", "знaк", "интeрпункциja", "питaњe"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("бијели упитник"),
            keywords: &["бијели упитник"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("beli upitnik"),
            keywords: &["beli upitnik", "interpunkcija", "obris", "pitanje", "znak"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("bijeli upitnik"),
            keywords: &["bijeli upitnik"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("vitt frågetecken"),
            keywords: &["fråga", "frågetecken", "vitt frågetecken"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("alama nyeupe ya kuuliza"),
            keywords: &[
                "?",
                "alama",
                "alama nyeupe ya kuuliza",
                "iliyobainishwa",
                "swali",
                "uakifishaji",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("வெள\u{bcd}ளை நிறக\u{bcd} கேள\u{bcd}விக\u{bcd}குறி"),
            keywords: &[
                "குறி",
                "கேள\u{bcd}விக\u{bcd} குறி",
                "நிறுத\u{bcd}தற\u{bcd}குறி",
                "வெளிர\u{bcd} நிறக\u{bcd} கேள\u{bcd}விக\u{bcd} குறி",
                "வெள\u{bcd}ளை நிறக\u{bcd} கேள\u{bcd}விக\u{bcd}குறி",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("త\u{c46}లుపు రంగు ప\u{c4d}రశ\u{c4d}న\u{c3e}ర\u{c4d}థకం గుర\u{c4d}తు"),
            keywords: &[
                "గుర\u{c4d}తు",
                "త\u{c46}లుపు",
                "త\u{c46}లుపు రంగు ప\u{c4d}రశ\u{c4d}న\u{c3e}ర\u{c4d}థకం గుర\u{c4d}తు",
                "ప\u{c4d}రశ\u{c4d}న\u{c3e}ర\u{c4d}థకం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("аломати саволи сафед"),
            keywords: &[
                "аломат",
                "аломати китобатӣ",
                "аломати саволи сафед",
                "баёншуда",
                "савол",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เคร\u{e37}\u{e48}องหมายคำถามส\u{e35}ขาว"),
            keywords: &[
                "?",
                "คำถาม",
                "เคร\u{e37}\u{e48}องหมาย",
                "เคร\u{e37}\u{e48}องหมายคำถามส\u{e35}ขาว",
                "เคร\u{e37}\u{e48}องหมายวรรคตอน",
            ],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ጻዕዳ ምልክት ሕቶ"),
            keywords: &[
                "?",
                "ምልክት",
                "ምልክት ሕቶ",
                "ንድፊ",
                "ንድፊ ሕቶ",
                "ጻዕዳ",
                "ጻዕዳ ምልክት ሕቶ",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ak sorag belgisi"),
            keywords: &[
                "?",
                "ak sorag belgisi",
                "belgi",
                "dyngy",
                "sorag",
                "çarçuwaly",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("fakaʻilonga fehuʻi hinehina"),
            keywords: &["fakaʻilonga", "fakaʻilonga fehuʻi hinehina", "fehuʻi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("beyaz soru işareti"),
            keywords: &["?", "beyaz soru işareti", "işaret", "noktalama", "soru"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئاق سوئال بەلگىسى"),
            keywords: &["ئاق سوئال بەلگىسى", "بەلگە", "تىنىش", "سوئال", "سىزىق"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("білий знак питання"),
            keywords: &[
                "?",
                "білий знак питання",
                "контурний",
                "питання",
                "пунктуація",
                "розділовий знак",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("سفید سوالیہ نشان"),
            keywords: &[
                "?",
                "آؤٹ لائن",
                "رموز\u{650} اوقاف",
                "سفید سوالیہ نشان",
                "سوال",
                "علامت",
            ],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("oq soʻroq belgisi"),
            keywords: &[
                "?",
                "belgi",
                "belgilangan",
                "oq soʻroq belgisi",
                "savol",
                "tinish belgisi",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("dấu chấm hỏi màu trắng"),
            keywords: &[
                "chấm",
                "chấm câu",
                "dấu chấm hỏi màu trắng",
                "dấu hỏi",
                "mờ",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("tombu laajte bu weex"),
            keywords: &[
                "fësal",
                "laajte",
                "màndarga",
                "tomb",
                "tombu laajte bu weex",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("uphawu lombuzo olumhlophe"),
            keywords: &[
                "ibalaseliswe umphandle",
                "isiphumlisi",
                "umbuzo",
                "uphawu",
                "uphawu lombuzo olumhlophe",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("aami ibeere funfun"),
            keywords: &["aami ibeere funfun", "àmì", "ààtò", "ìbéèrè", "ìfàmìsí"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("白色問號"),
            keywords: &["?", "問題", "外框", "標點符號", "白色問號", "符號"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("白色问号"),
            keywords: &["?", "外框", "标点符号", "白色问号", "符号", "问题"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("白色问号"),
            keywords: &["为什么", "标点符号", "白色问号", "空心", "？"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("白色問號"),
            keywords: &["標點", "白色問號"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["問號", "標點", "白色問號"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("uphawu lombuzo olumhlophe"),
            keywords: &[
                "okudwetshiwe",
                "umbuzo",
                "upahu",
                "uphawu lombuzo olumhlophe",
            ],
        },
    ],
};
#[doc = "❕"]
pub const WHITE_EXCLAMATION_MARK: crate::Emoji = crate::Emoji {
    glyph: "❕",
    codepoint: "2755",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "white exclamation mark",
    group: "Symbols",
    subgroup: "punctuation",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("wit uitroepteken"),
            keywords: &[
                "buitelyn",
                "leesteken",
                "teken",
                "uitroep",
                "wit uitroepteken",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ነጭ የቃለ አጋኖ ምልክት"),
            keywords: &["ምልክት", "ሥርዓተ ነጥብ", "ቃለ አጋኖ", "ነጭ የቃለ አጋኖ ምልክት", "የተነደፈ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("\u{202b}علامة تعجب بيضاء"),
            keywords: &["تعجب", "\u{202b}علامة تعجب بيضاء"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("বগ\u{9be} ৰঙৰ ভ\u{9be}ৱবোধক চিহ\u{9cd}ন"),
            keywords: &[
                "!",
                "চিহ\u{9cd}ন",
                "প\u{9cd}ৰ\u{9be}ন\u{9cd}তৰেখ\u{9be}য\u{9c1}ক\u{9cd}ত",
                "বগ\u{9be} ৰঙৰ প\u{9cd}ৰশ\u{9cd}নবোধক চিহ\u{9cd}ন",
                "বগ\u{9be} ৰঙৰ ভ\u{9be}ৱবোধক চিহ\u{9cd}ন",
                "ভ\u{9be}ৱবোধক",
                "যতি-চিহ\u{9cd}ন",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("ağ nida işarəsi"),
            keywords: &[
                "ağ nida işarəsi",
                "durğu işarəsi",
                "işarə",
                "nida",
                "qeyd edilmiş",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("белы клічнік"),
            keywords: &[
                "!",
                "белы клічнік",
                "вокліч",
                "знак",
                "контур",
                "пунктуацыя",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Бяла удивителна"),
            keywords: &["Бяла удивителна", "контур", "пунктуация", "удивителна"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("স\u{9be}দ\u{9be} বিস\u{9cd}ময\u{9bc}বোধক চিহ\u{9cd}ন"),
            keywords: &[
                "!",
                "চিহ\u{9cd}ন",
                "বিস\u{9cd}ময\u{9bc}বোধক",
                "যতিচিহ\u{9cd}ন",
                "র\u{9c2}পরেখ\u{9be}",
                "স\u{9be}দ\u{9be} বিস\u{9cd}ময\u{9bc}বোধক চিহ\u{9cd}ন",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("pik-estlamm gwenn"),
            keywords: &["!", "estlamm", "gwenn", "pik-estlamm", "poentadur"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("bijeli uzvičnik"),
            keywords: &[
                "!",
                "bijeli uzvičnik",
                "interpunkcija",
                "ocrtano",
                "oznaka",
                "uzvik",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("signe d’exclamació blanc"),
            keywords: &[
                "!",
                "blanc",
                "exclamació",
                "puntuació",
                "signe",
                "signe d’exclamació blanc",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᏁᎦ ᏍᏓᏱ ᎤᏃᏴᎩ ᎤᏙᏪᎸ"),
            keywords: &[
                "!",
                "ᎤᏁᎦ ᏍᏓᏱ ᎤᏃᏴᎩ ᎤᏙᏪᎸ",
                "ᎤᏙᏪᎸ",
                "ᎦᏕᏱᏍᏔᏅᎢ",
                "ᏍᏓᏱ ᎤᏃᏴᎩ",
                "ᏚᏙᏪᎸ",
            ],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("bílý vykřičník"),
            keywords: &[
                "!",
                "bílý vykřičník",
                "interpunkční znaménka",
                "obrys",
                "vykřičník",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("ebychnod gwyn"),
            keywords: &[
                "!",
                "amlinelliad",
                "atalnodiad",
                "ebychnod",
                "ebychnod gwyn",
                "marc",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("hvidt udråbstegn"),
            keywords: &[
                "hvidt udråbstegn",
                "omrids",
                "tegnsætning",
                "udråb",
                "udråbstegn",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("weißes Ausrufezeichen"),
            keywords: &["Satzzeichen", "weiß", "weißes Ausrufezeichen"],
        },
        #[cfg(feature = "de_CH")]
        crate::Annotation {
            lang: "de_CH",
            tts: Some("weisses Ausrufezeichen"),
            keywords: &["Satzzeichen", "weiss", "weisses Ausrufezeichen"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("λευκό θαυμαστικό"),
            keywords: &[
                "!",
                "αχνό",
                "θαυμαστικό",
                "λευκό θαυμαστικό",
                "σημείο",
                "στίξη",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("white exclamation mark"),
            keywords: &[
                "!",
                "exclamation",
                "mark",
                "outlined",
                "punctuation",
                "white exclamation mark",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("exclamación blanca"),
            keywords: &["!", "exclamación", "exclamación blanca", "puntuación"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("signo de exclamación gris"),
            keywords: &[
                "!",
                "exclamación",
                "exclamación blanca",
                "puntuación",
                "signo de exclamación gris",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("signo de exclamación blanco"),
            keywords: &[
                "!",
                "exclamación",
                "pregunta",
                "puntuación",
                "signo",
                "signo de exclamación blanco",
                "signo exclamación blanco",
            ],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("valge hüüumärk"),
            keywords: &["!", "hüüumärk", "valge hüüumärk"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("harridura-marka zuria"),
            keywords: &[
                "harridura",
                "harridura-marka zuria",
                "marka",
                "nabarmendu",
                "puntuazio",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("علامت تعجب سفید"),
            keywords: &[
                "!",
                "تعجب",
                "سفید",
                "علامت",
                "علامت\u{200c}گذاری",
                "نقطه\u{200c}گذاری",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("valkoinen huutomerkki"),
            keywords: &[
                "huutomerkki",
                "merkki",
                "valkoinen huutomerkki",
                "välimerkki",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("puting tandang padamdam"),
            keywords: &[
                "bantas",
                "padamdam",
                "pananda",
                "puti",
                "puting tandang padamdam",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("hvítt rópitekn"),
            keywords: &["greinarmerki", "hvítt rópitekn", "rópitekn", "teknseting"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("point d’exclamation blanc"),
            keywords: &[
                "!",
                "exclamation",
                "point d’exclamation blanc",
                "ponctuation",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &[
                "point d’exclamation",
                "point d’exclamation blanc",
                "ponctuation",
                "question",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("comhartha uailbhresa bán"),
            keywords: &[
                "!",
                "comhartha uailbhreasa",
                "comhartha uailbhresa bán",
                "comhartha uaillbhreasa bán",
                "imlíntieh",
                "poncaíocht",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("clisg-phuing gheal"),
            keywords: &[
                "!",
                "clisg-phuing",
                "clisg-phuing gheal",
                "comharra",
                "oir-loidhne",
                "puingeachadh",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("signo de exclamación branco"),
            keywords: &[
                "!",
                "admiración",
                "exclamación",
                "signo de exclamación branco",
                "símbolo de exclamación",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("સફ\u{ac7}દ ઉદ\u{acd}ગાર ચિહ\u{acd}ન"),
            keywords: &[
                "!",
                "ઉદ\u{acd}ગારવાચક",
                "ચિહ\u{acd}ન",
                "બાહ\u{acd}યર\u{ac7}ખા\u{a82}કિત",
                "વિરામચિહ\u{acd}ન",
                "સફ\u{ac7}દ ઉદ\u{acd}ગાર ચિહ\u{acd}ન",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("farar alamar motsin rai"),
            keywords: &[
                "alama",
                "alamar motsin rai",
                "alamomin rubutu",
                "farar alamar motsin rai",
                "mai rubutu a gefe",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("סימן קריאה לבן"),
            keywords: &["הדגשה", "סימן קריאה", "סימן קריאה לבן"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("सफ\u{93c}\u{947}द विस\u{94d}मयादिबोधक चिह\u{94d}न"),
            keywords: &[
                "चिह\u{94d}न",
                "विस\u{94d}मयादिबोधक",
                "सफ\u{93c}\u{947}द विस\u{94d}मयादिबोधक",
                "सफ\u{93c}\u{947}द विस\u{94d}मयादिबोधक चिह\u{94d}न",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("bijeli uskličnik"),
            keywords: &[
                "bijeli uskličnik",
                "interpunkcija",
                "obris",
                "uskličnik",
                "znak",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("fehér felkiáltójel"),
            keywords: &[
                "fehér",
                "fehér felkiáltójel",
                "felkiáltás",
                "központozás",
                "írásjel",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("սպիտակ բացականչական նշան"),
            keywords: &[
                "բացականչություն",
                "կետադրություն",
                "նշան",
                "ուրվագծված",
                "սպիտակ բացականչական նշան",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("tanda seru putih"),
            keywords: &[
                "garis luar",
                "tanda",
                "tanda baca",
                "tanda seru",
                "tanda seru putih",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("Akara Mkpu dị Ọcha"),
            keywords: &[
                "Akara Mkpu dị Ọcha",
                "akara",
                "edepụtara",
                "ntimkpu",
                "ntụpọ",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("hvítt upphrópunarmerki"),
            keywords: &[
                "greinarmerki",
                "hvítt upphrópunarmerki",
                "merki",
                "upphrópun",
                "útlínur",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("punto esclamativo bianco"),
            keywords: &[
                "esclamazione",
                "punto esclamativo bianco",
                "punto esclamativo vuoto",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("白い感嘆符"),
            keywords: &[
                "!",
                "びっくりマーク",
                "エクスクラメーションマーク",
                "白い感嘆符",
                "約物",
                "記号",
            ],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("tandha penthung putih"),
            keywords: &[
                "!",
                "garis pinggir cetha",
                "mbangetake",
                "tandha",
                "tandha penthung putih",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("თეთრი ძახილის ნიშანი"),
            keywords: &[
                "თეთრი ძახილის ნიშანი",
                "კონტურიანი",
                "ნიშანი",
                "პუნქტუაცია",
                "ძახილი",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("ақ леп белгісі"),
            keywords: &[
                "ақ леп белгісі",
                "белгі",
                "леп белгісі",
                "пунктуация",
                "сызулы",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("hvidt udråbstegn"),
            keywords: &["fixed to avoid duplicate", "hvidt udråbstegn"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("សញ\u{17d2}ញាឧទានពណ\u{17cc}ស"),
            keywords: &["!", "សញ\u{17d2}ញា", "សញ\u{17d2}ញាឧទានពណ\u{17cc}ស", "ឧទាន"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಬ\u{cbf}ಳ\u{cbf} ಆಶ\u{ccd}ಚರ\u{ccd}ಯಸ\u{cc2}ಚಕ ಗುರುತು"),
            keywords: &[
                "ಘೋಷಣಾ",
                "ಘೋಷಣಾ ಚ\u{cbf}ಹ\u{ccd}ನ\u{cc6}",
                "ಬ\u{cbf}ಳ\u{cbf} ಆಶ\u{ccd}ಚರ\u{ccd}ಯಸ\u{cc2}ಚಕ ಗುರುತು",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("하얀색 느낌표"),
            keywords: &["느낌", "하얀색 느낌표"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("धव\u{947}\u{902} उद\u{94d}गार चिन\u{94d}न"),
            keywords: &[
                "!",
                "उद\u{94d}गार",
                "चिन\u{94d}न",
                "धव\u{947}\u{902} उद\u{94d}गार चिन\u{94d}न",
                "र\u{941}पर\u{947}खा",
                "विरामचिन\u{94d}न",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("ак илеп белгиси"),
            keywords: &["ак илеп белгиси", "белги", "илеп", "пунктуация"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("wäisst Ausruffzeechen"),
            keywords: &[
                "Ausruff",
                "Interpunktioun",
                "Kontur",
                "Zeechen",
                "wäisst Ausruffzeechen",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເຄ\u{eb7}\u{ec8}ອງໝາຍທ\u{ec9}ວງສ\u{eb5}ຂາວ"),
            keywords: &[
                "ສ\u{eb5}ຂາວ",
                "ອ\u{eb1}ດສະຈ\u{eb1}ນ",
                "ເຄ\u{eb7}\u{ec8}ອງໝາຍທ\u{ec9}ວງ",
                "ເຄ\u{eb7}\u{ec8}ອງໝາຍທ\u{ec9}ວງສ\u{eb5}ຂາວ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("baltas šauktukas"),
            keywords: &[
                "baltas šauktukas",
                "kontūras",
                "skyryba",
                "šauktukas",
                "žymė",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("balta izsaukuma zīme"),
            keywords: &["!", "balta izsaukuma zīme", "izsaukums", "pieturzīme"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tohuhā mā"),
            keywords: &["tohu", "tohuhā", "tohuhā mā", "tohutuhi", "whakahuahua"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("бел извичник"),
            keywords: &["бел извичник", "знак", "извичник", "интерпункција"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("വെള\u{d41}ത\u{d4d}ത ആശ\u{d4d}ചര\u{d4d}യ ചിഹ\u{d4d}നം"),
            keywords: &[
                "!",
                "ആശ\u{d4d}\u{200c}ചര\u{d4d}യം",
                "ചിഹ\u{d4d}നം",
                "വിര\u{d3e}മം",
                "വെള\u{d41}ത\u{d4d}ത ആശ\u{d4d}ചര\u{d4d}യ ചിഹ\u{d4d}നം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("цагаан анхааруулгын тэмдэг"),
            keywords: &[
                "!",
                "анхаарлын тэмдэг",
                "тэмдэг",
                "цагаан анхаарлын тэмдэг",
                "цагаан анхааруулгын тэмдэг",
                "цэг",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("पा\u{902}ढर\u{947} उद\u{94d}गारवाचक चिन\u{94d}ह"),
            keywords: &[
                "आराखडा",
                "उद\u{94d}गारवाचक",
                "चिन\u{94d}ह",
                "पा\u{902}ढर\u{947} उद\u{94d}गारवाचक चिन\u{94d}ह",
                "विरामचिन\u{94d}ह",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("tanda seru putih"),
            keywords: &[
                "digariskan",
                "seru",
                "tanda",
                "tanda baca",
                "tanda seru putih",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("punt esklamattiv abjad"),
            keywords: &[
                "esklamazzjoni",
                "marka",
                "punt esklamattiv abjad",
                "punteġġjatura",
                "spjegati",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အဖြ\u{1030}ရောင\u{103a} အာမေဍ\u{102d}တ\u{103a} သင\u{103a}\u{1039}ကေတ"),
            keywords: &[
                "ပ\u{102f}ဒ\u{103a}ဖြတ\u{103a}ပ\u{102f}ဒ\u{103a}ရပ\u{103a}",
                "အဖြ\u{1030}ရောင\u{103a} အာမေဍ\u{102d}တ\u{103a} သင\u{103a}\u{1039}ကေတ",
                "အမ\u{103e}တ\u{103a}",
                "အာမေဍ\u{102d}တ\u{103a} သင\u{103a}\u{1039}ကေတ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("hvitt utropstegn"),
            keywords: &["!", "hvitt utropstegn", "utrop"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("स\u{947}तो विस\u{94d}मयाधिबोधक चिन\u{94d}ह"),
            keywords: &[
                "चिन\u{94d}ह",
                "बाहिरि र\u{947}खा",
                "विराम चिन\u{94d}ह",
                "विस\u{94d}मयाधिबोधक",
                "स\u{947}तो विस\u{94d}मयाधिबोधक चिन\u{94d}ह",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("wit uitroepteken"),
            keywords: &[
                "!",
                "contour",
                "interpunctie",
                "teken",
                "uitroep",
                "wit uitroepteken",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("kvitt utropsteikn"),
            keywords: &["!", "kvitt utropsteikn", "utrop"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଧଳ\u{b3e} ବ\u{b3f}ସ\u{b4d}ମୟସ\u{b42}ଚକ ଚ\u{b3f}ହ\u{b4d}ନ"),
            keywords: &[
                "!",
                "ଚ\u{b3f}ହ\u{b4d}ନ",
                "ଧଳ\u{b3e} ବ\u{b3f}ସ\u{b4d}ମୟସ\u{b42}ଚକ ଚ\u{b3f}ହ\u{b4d}ନ",
                "ବ\u{b3e}ହ\u{b4d}ୟରେଖ\u{b3e}କ\u{b43}ତ",
                "ବ\u{b3f}ର\u{b3e}ମ ଚ\u{b3f}ହ\u{b4d}ନ",
                "ବ\u{b3f}ସ\u{b4d}ମୟସ\u{b42}ଚକ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਸਫ\u{a47}\u{a47}ਦ ਹ\u{a48}ਰਾਨੀਵਾਚਕ ਚਿ\u{a70}ਨ\u{a4d}ਹ"),
            keywords: &[
                "ਚਿ\u{a70}ਨ\u{a4d}ਹ",
                "ਵਿਰਾਮ ਚਿ\u{a70}ਨ\u{a4d}ਹ",
                "ਵਿਸਮ\u{a41}ਕ",
                "ਸਫ\u{a47}\u{a47}ਦ ਹ\u{a48}ਰਾਨੀਵਾਚਕ ਚਿ\u{a70}ਨ\u{a4d}ਹ",
                "ਹ\u{a48}ਰਾਨੀਵਾਚਕ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("چٹ\u{651}ا فجائی نشان"),
            keywords: &[
                "خاکہ ش\u{64f}دہ",
                "رموز اوقاف",
                "نشان لانا",
                "چٹ\u{651}ا فجائی نشان",
                "چیخ و پکار",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Wait Ẹksklaméshọn Mak"),
            keywords: &[
                "!",
                "Aútlain",
                "Mak",
                "Pọnkchuéshọn",
                "Wait Ẹksklaméshọn Mak",
                "Ẹksklaméshọn",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("biały wykrzyknik"),
            keywords: &["!", "biały wykrzyknik", "krzyk", "okrzyk", "wykrzyknik"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("سپينه ندا نښه"),
            keywords: &["حاشيه", "د وقفې علامت", "سپينه ندا نښه", "ندا", "نښه"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("ponto de exclamação branco"),
            keywords: &[
                "!",
                "delineado",
                "mark",
                "ponto de exclamação branco",
                "pontuação",
                "sinal",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &[
                "!",
                "delineado",
                "exclamação",
                "ponto de exclamação branco",
                "pontuação",
                "sinal",
                "sinal de exclamação branco",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("yuraq qapariq yupiy"),
            keywords: &["yuraq qapariq yupiy"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("semnul exclamării alb"),
            keywords: &[
                "contur",
                "exclamație",
                "punctuație",
                "semn",
                "semnul exclamării alb",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-144"),
            keywords: &["E10-144"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("белый восклицательный знак"),
            keywords: &[
                "белый",
                "белый восклицательный знак",
                "восклицание",
                "знак",
                "пунктуация",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ikimenyetso cy’agatangaro k’umweru"),
            keywords: &[
                "akarango",
                "akatuzo",
                "cyagaragajwe",
                "gutangara",
                "ikimenyetso cy’agatangaro k’umweru",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("سفيد عجب جي نشاني"),
            keywords: &[
                "!",
                "آئوٽ لائن ٿيل",
                "سفيد عجب جي نشاني",
                "عجب",
                "مارڪ",
                "پنڪچويشن",
            ],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ස\u{dd4}ද\u{dd4} ව\u{dd2}ස\u{dca}මය\u{dcf}ර\u{dca}ථ ලක\u{dd4}ණ"),
            keywords: &[
                "ලක\u{dd4}ණ",
                "වැට\u{dd2}සන",
                "ව\u{dd2}ර\u{dcf}ම ලක\u{dd4}ණ",
                "ව\u{dd2}ස\u{dca}මය\u{dcf}ර\u{dca}ථය",
                "ස\u{dd4}ද\u{dd4} ව\u{dd2}ස\u{dca}මය\u{dcf}ර\u{dca}ථ ලක\u{dd4}ණ",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("biely výkričník"),
            keywords: &[
                "biely výkričník",
                "interpunkcia",
                "obrys",
                "výkričník",
                "znak",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("bel klicaj"),
            keywords: &["!", "bel klicaj", "klicaj", "obrobljeno", "znak"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("calaamad cajiib cad"),
            keywords: &[
                "!",
                "cajiib",
                "calaamad",
                "calaamad cajiib cad",
                "kormaris",
                "xarakayn",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("shenjë pikëçuditje e bardhë"),
            keywords: &[
                "e konturuar",
                "pikësim",
                "pikëçuditje",
                "shenjë",
                "shenjë pikëçuditje e bardhë",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("бели узвичник"),
            keywords: &[
                "oбрис",
                "бели узвичник",
                "знaк",
                "интeрпункциja",
                "узвичник",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("бијели узвичник"),
            keywords: &["бијели узвичник"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("beli uzvičnik"),
            keywords: &[
                "beli uzvičnik",
                "interpunkcija",
                "obris",
                "uzvičnik",
                "znak",
            ],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("bijeli uzvičnik"),
            keywords: &["bijeli uzvičnik"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("vitt utropstecken"),
            keywords: &["kommatering", "utropstecken", "vitt"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("alama nyeupe ya mshangao"),
            keywords: &[
                "!",
                "alama",
                "alama nyeupe ya mshangao",
                "iliyobainishwa",
                "mshangao",
                "uakifishaji",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("வெள\u{bcd}ளை நிறக\u{bcd} ஆச\u{bcd}சரியக\u{bcd}குறி"),
            keywords: &[
                "ஆச\u{bcd}சரியக\u{bcd}குறி",
                "குறி",
                "நிறுத\u{bcd}தற\u{bcd}குறி",
                "வெள\u{bcd}ளை நிறக\u{bcd} ஆச\u{bcd}சரியக\u{bcd}குறி",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("త\u{c46}లుపు రంగు ఆశ\u{c4d}చర\u{c4d}య\u{c3e}ర\u{c4d}థకం గుర\u{c4d}తు"),
            keywords: &[
                "ఆశ\u{c4d}చర\u{c4d}య\u{c3e}ర\u{c4d}థకం",
                "గుర\u{c4d}తు",
                "త\u{c46}లుపు",
                "త\u{c46}లుపు రంగు ఆశ\u{c4d}చర\u{c4d}య\u{c3e}ర\u{c4d}థకం గుర\u{c4d}తు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("аломати хитоби сафед"),
            keywords: &[
                "аломат",
                "аломати хитоби сафед",
                "аломатҳои китобатӣ",
                "баёншуда",
                "хитоб",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เคร\u{e37}\u{e48}องหมายอ\u{e31}ศเจร\u{e35}ย\u{e4c}ส\u{e35}ขาว"),
            keywords: &[
                "!",
                "เคร\u{e37}\u{e48}องหมาย",
                "เคร\u{e37}\u{e48}องหมายวรรคตอน",
                "เคร\u{e37}\u{e48}องหมายอ\u{e31}ศเจร\u{e35}ย\u{e4c}",
                "เคร\u{e37}\u{e48}องหมายอ\u{e31}ศเจร\u{e35}ย\u{e4c}ส\u{e35}ขาว",
            ],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ጻዕዳ ምልክት ስምዒት"),
            keywords: &["!", "ምልክት", "ስምዒት", "ንድፊ", "ጻዕዳ ምልክት ስምዒት"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ak ýüzlenme belgisi"),
            keywords: &[
                "!",
                "ak ýüzlenme belgisi",
                "belgi",
                "dyngy",
                "çarçuwaly",
                "ýüzlenme",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("fakaʻilonga kalanga hinehina"),
            keywords: &["fakaʻilonga", "fakaʻilonga kalanga hinehina", "kalanga"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("beyaz ünlem işareti"),
            keywords: &["!", "beyaz ünlem işareti", "işaret", "noktalama", "ünlem"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئاق ئۈندەش بەلگىسى"),
            keywords: &["ئاق ئۈندەش بەلگىسى", "ئۈندەش", "بەلگە", "تىنىش", "سىزىق"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("білий знак оклику"),
            keywords: &[
                "!",
                "білий знак оклику",
                "контурний",
                "оклик",
                "пунктуація",
                "розділовий знак",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("سفید ندائیہ نشان"),
            keywords: &[
                "!",
                "آؤٹ لائن",
                "رموز\u{650} اوقاف",
                "سفید ندائیہ نشان",
                "علامت",
                "ندائیہ",
            ],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("oq undov belgisi"),
            keywords: &[
                "!",
                "belgi",
                "belgilangan",
                "oq undov belgisi",
                "tinish belgisi",
                "undov",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("dấu chấm than màu trắng"),
            keywords: &["chấm", "cảm thán", "dấu", "dấu chấm than màu trắng", "mờ"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("tombu esklamaasiyoŋ bu weex"),
            keywords: &[
                "esklamaasiyoŋ",
                "fësal",
                "màndarga",
                "tomb",
                "tombu esklamaasiyoŋ bu weex",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("uphawu lwesikhuzo olumhlophe"),
            keywords: &[
                "ibalaseliswe umphandle",
                "isikhuzo",
                "isiphumlisi",
                "uphawu",
                "uphawu lwesikhuzo olumhlophe",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("aami iyalẹnu funfun"),
            keywords: &["aami iyalẹnu funfun", "àmì", "àmì ìyanu", "ààtò", "ìfàmìsí"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("白色感歎號"),
            keywords: &["!", "外框", "感歎號", "標點符號", "白色感歎號", "符號"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("白色感叹号"),
            keywords: &["!", "外框", "感叹号", "标点符号", "白色感叹号", "符号"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("白色感叹号"),
            keywords: &["吃惊", "标点符号", "白色感叹号", "空心", "！"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("白色驚嘆號"),
            keywords: &["標點", "白色驚嘆號"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("白色感嘆號"),
            keywords: &["標點", "白色感嘆號"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("uphawu lwesibabazi olumhlophe"),
            keywords: &[
                "isibabazi",
                "okudwetshiwe",
                "uphawu",
                "uphawu lwesibabazi olumhlophe",
            ],
        },
    ],
};
#[doc = "❗"]
pub const RED_EXCLAMATION_MARK: crate::Emoji = crate::Emoji {
    glyph: "❗",
    codepoint: "2757",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "red exclamation mark",
    group: "Symbols",
    subgroup: "punctuation",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("rooi uitroepteken"),
            keywords: &["leesteken", "rooi", "teken", "uitroep", "uitroepteken"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ቀይ የቃለ አጋኖ ምልክት"),
            keywords: &["ምልክት", "ሥርዓተ ነጥብ", "ቀይ የቃለ አጋኖ ምልክት", "ቃለ አጋኖ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("\u{202b}علامة تعجب"),
            keywords: &["ترقيم", "علامة", "\u{202b}علامة تعجب"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ৰঙ\u{9be} ৰঙৰ ভ\u{9be}ৱবোধক চিহ\u{9cd}ন"),
            keywords: &[
                "!",
                "চিহ\u{9cd}ন",
                "ভ\u{9be}ৱবোধক",
                "যতি-চিহ\u{9cd}ন",
                "ৰঙ\u{9be} ৰঙৰ ভ\u{9be}ৱবোধক চিহ\u{9cd}ন",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("nida işarəsi"),
            keywords: &["durğu işarəsi", "işarə", "nida", "nida işarəsi"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("чырвоны клічнік"),
            keywords: &[
                "!",
                "вокліч",
                "знак",
                "клічнік",
                "пунктуацыя",
                "чырвоны клічнік",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("удивителна"),
            keywords: &["пунктуация", "удивителна"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("বিস\u{9cd}ময\u{9bc}বোধক চিহ\u{9cd}ন"),
            keywords: &[
                "!",
                "চিহ\u{9cd}ন",
                "বিস\u{9cd}ময\u{9bc}বোধক",
                "যতিচিহ\u{9cd}ন",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("pik-estlamm ruz"),
            keywords: &["!", "estlamm", "pik-estlamm", "poentadur", "ruz"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("crveni uzvičnik"),
            keywords: &[
                "!",
                "crveni uzvičnik",
                "interpunkcija",
                "oznaka",
                "uzvik",
                "uzvičnik",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("signe d’exclamació vermell"),
            keywords: &[
                "!",
                "exclamació",
                "puntuació",
                "signe",
                "signe d’exclamació",
                "signe d’exclamació vermell",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏍᏓᏱ ᎤᏃᏴᎩ ᎤᏙᏪᎸ"),
            keywords: &["!", "ᎤᏙᏪᎸ", "ᏍᏓᏱ ᎤᏃᏴᎩ", "ᏍᏓᏱ ᎤᏃᏴᎩ ᎤᏙᏪᎸ", "ᏚᏙᏪᎸ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("červený vykřičník"),
            keywords: &[
                "!",
                "interpunkční znaménka",
                "vykřičník",
                "červený vykřičník",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("ebychnod"),
            keywords: &["!", "atalnodiad", "ebychnod", "marc"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("rødt udråbstegn"),
            keywords: &["rødt udråbstegn", "tegnsætning", "udråbstegn"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("rotes Ausrufezeichen"),
            keywords: &[
                "Ausrufezeichen",
                "Satzzeichen",
                "rot",
                "rotes Ausrufezeichen",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κόκκινο θαυμαστικό"),
            keywords: &["!", "θαυμαστικό", "κόκκινο θαυμαστικό", "σημείο", "στίξη"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("red exclamation mark"),
            keywords: &[
                "!",
                "exclamation",
                "mark",
                "punctuation",
                "red exclamation mark",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("exclamación roja"),
            keywords: &[
                "!",
                "exclamación",
                "exclamación roja",
                "puntuación",
                "signo de exclamación",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("signo de exclamación"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("signo de exclamación rojo"),
            keywords: &[
                "!",
                "exclamación",
                "puntuación",
                "signo de exclamación",
                "signo de exclamación rojo",
            ],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("punane hüüumärk"),
            keywords: &["!", "hüüumärk", "kirjavahemärk", "punane hüüumärk"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("harridura-marka gorria"),
            keywords: &[
                "harridura",
                "harridura-marka",
                "harridura-marka gorria",
                "marka",
                "puntuazioa",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("علامت تعجب قرمز"),
            keywords: &[
                "!",
                "علامت",
                "علامت تعجب",
                "علامت تعجب قرمز",
                "علامت\u{200c}گذاری",
                "نقطه\u{200c}گذاری",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("huutomerkki"),
            keywords: &["huutomerkki", "merkki", "välimerkki"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("tandang padamdam"),
            keywords: &["bantas", "padamdam", "pananda", "tanda", "tandang padamdam"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("rópitekn"),
            keywords: &["greinarmerki", "rópitekn", "teknseting"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("point d’exclamation rouge"),
            keywords: &[
                "!",
                "exclamation",
                "point d’exclamation",
                "point d’exclamation rouge",
                "ponctuation",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("comhartha uaillbhreasa dearg"),
            keywords: &[
                "!",
                "comhartha uaillbhreasa",
                "comhartha uaillbhreasa dearg",
                "marc",
                "poncaíocht",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("clisg-phuing dhearg"),
            keywords: &[
                "!",
                "clisg-phuing",
                "clisg-phuing dhearg",
                "comharra",
                "puingeachadh",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("signo de exclamación vermello"),
            keywords: &[
                "!",
                "admiración",
                "exclamación",
                "signo de exclamación",
                "signo de exclamación vermello",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ઉદ\u{acd}ગાર ચિહ\u{acd}ન"),
            keywords: &[
                "!",
                "ઉદ\u{acd}ગાર ચિહ\u{acd}ન",
                "ચિહ\u{acd}ન",
                "વિરામચિહ\u{acd}ન",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("alamar motsin rai"),
            keywords: &["alama", "alamar motsin rai", "alamomin rubutu"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("סימן קריאה אדום"),
            keywords: &["הדגשה", "סימן קריאה", "סימן קריאה אדום"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("लाल विस\u{94d}मयादिबोधक चिह\u{94d}न"),
            keywords: &[
                "चिह\u{94d}न",
                "चिह\u{94d}न विचार",
                "लाल विस\u{94d}मयादिबोधक चिह\u{94d}न",
                "विस\u{94d}मयादिबोधक",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("crveni uskličnik"),
            keywords: &["crveni uskličnik", "interpunkcija", "uskličnik", "znak"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("piros felkiáltójel"),
            keywords: &[
                "felkiáltás",
                "felkiáltójel",
                "központozás",
                "piros felkiáltójel",
                "írásjel",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("բացականչական նշան"),
            keywords: &[
                "բացականչական նշան",
                "բացականչություն",
                "կետադրություն",
                "նշան",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("tanda seru merah"),
            keywords: &["tanda", "tanda baca", "tanda seru", "tanda seru merah"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("akara ntimkpu"),
            keywords: &["akara", "ntimkpu", "ntụpọ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("rautt upphrópunarmerki"),
            keywords: &[
                "greinarmerki",
                "merki",
                "rautt upphrópunarmerki",
                "upphrópun",
                "upphrópunarmerki",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("punto esclamativo rosso"),
            keywords: &[
                "esclamazione",
                "punteggiatura",
                "punto esclamativo",
                "punto esclamativo pieno",
                "punto esclamativo rosso",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("赤い感嘆符"),
            keywords: &[
                "!",
                "びっくりマーク",
                "エクスクラメーションマーク",
                "感嘆符",
                "約物",
                "記号",
                "赤い感嘆符",
            ],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("tandha penthung abang"),
            keywords: &[
                "!",
                "mbangetake",
                "tandha",
                "tandha penthung",
                "tandha penthung abang",
                "tandha wacan",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("წითელი ძახილის ნიშანი"),
            keywords: &[
                "ნიშანი",
                "პუნქტუაცია",
                "ძახილი",
                "ძახილის ნიშანი",
                "წითელი ძახილის ნიშანი",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("леп белгісі"),
            keywords: &["белгі", "леп белгісі", "пунктуация"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("udråbstegn"),
            keywords: &["tegnsætning", "udråbstegn"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("សញ\u{17d2}ញាឧទាន"),
            keywords: &["!", "សញ\u{17d2}ញា", "សញ\u{17d2}ញាឧទាន", "ឧទាន"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಆಶ\u{ccd}ಚರ\u{ccd}ಯ ಸ\u{cc2}ಚಕ ಚ\u{cbf}ಹ\u{ccd}ನ\u{cc6}"),
            keywords: &[
                "ಆಶ\u{ccd}ಚರ\u{ccd}ಯ ಸ\u{cc2}ಚಕ ಚ\u{cbf}ಹ\u{ccd}ನ\u{cc6}",
                "ಆಶ\u{ccd}ಚರ\u{ccd}ಯಸ\u{cc2}ಚಕ",
                "ಗುರುತು",
                "ವ\u{cbf}ರಾಮ ಚ\u{cbf}ಹ\u{ccd}ನ\u{cc6}ಗಳು",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("빨간색 느낌표"),
            keywords: &["느낌표", "부호", "빨간색 느낌표"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("उद\u{94d}गार चिन\u{94d}न"),
            keywords: &["!", "उद\u{94d}गार", "चिन\u{94d}न", "विरामचिन\u{94d}न"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("кызыл илеп белгиси"),
            keywords: &[
                "белги",
                "илеп",
                "илеп белгиси",
                "кызыл илеп белгиси",
                "пунктуация",
            ],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Ausruffzeechen"),
            keywords: &["Ausruff", "Ausruffzeechen", "Interpunktioun", "Zeechen"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເຄ\u{eb7}\u{ec8}ອງໝາຍທ\u{ec9}ວງ"),
            keywords: &[
                "ຕ\u{ebb}ກໃຈ",
                "ອ\u{eb1}ດສະຈ\u{eb1}ນ",
                "ເຄ\u{eb7}\u{ec8}ອງໝາຍທ\u{ec9}ວງ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("raudonas šauktukas"),
            keywords: &["raudonas šauktukas", "skyryba", "šauktukas", "žymė"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("sarkana izsaukuma zīme"),
            keywords: &[
                "!",
                "izsaukuma zīme",
                "izsaukums",
                "pieturzīme",
                "sarkana izsaukuma zīme",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tohuhā"),
            keywords: &["tohu", "tohu reo", "tohuhā"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("црвен извичник"),
            keywords: &["знак", "извичник", "интерпункција", "црвен извичник"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ച\u{d41}വന\u{d4d}ന ആശ\u{d4d}ചര\u{d4d}യ ചിഹ\u{d4d}നം"),
            keywords: &[
                "!",
                "ആശ\u{d4d}ചര\u{d4d}യ ചിഹ\u{d4d}നം",
                "ചിഹ\u{d4d}നം",
                "ച\u{d41}വന\u{d4d}ന ആശ\u{d4d}ചര\u{d4d}യ ചിഹ\u{d4d}നം",
                "വിര\u{d3e}മം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("улаан анхаарлын тэмдэг"),
            keywords: &[
                "!",
                "анхааруулах",
                "тэмдэг",
                "улаан анхаарлын тэмдэг",
                "цэг",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("उद\u{94d}गारवाचक चिन\u{94d}ह"),
            keywords: &["उद\u{94d}गारवाचक", "चिन\u{94d}ह", "विरामचिन\u{94d}ह"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("tanda seru merah"),
            keywords: &["!", "seru", "tanda", "tanda baca", "tanda seru merah"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("punt esklamattiv"),
            keywords: &[
                "esklamazzjoni",
                "marka",
                "punt esklamattiv",
                "punteġġjatura",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အာမေဍ\u{102d}တ\u{103a} သင\u{103a}\u{1039}ကေတ"),
            keywords: &[
                "ပ\u{102f}ဒ\u{103a}ဖြတ\u{103a}ပ\u{102f}ဒ\u{103a}ရပ\u{103a}",
                "အမ\u{103e}တ\u{103a}",
                "အာမေဍ\u{102d}တ\u{103a}",
                "အာမေဍ\u{102d}တ\u{103a} သင\u{103a}\u{1039}ကေတ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("rødt utropstegn"),
            keywords: &[
                "!",
                "rødt utropstegn",
                "tegn",
                "tegnsetting",
                "utrop",
                "utropstegn",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("विस\u{94d}मयाधिबोधक चिन\u{94d}ह"),
            keywords: &["चिन\u{94d}ह", "विराम चिन\u{94d}ह", "विस\u{94d}मयाधिबोधक"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("rood uitroepteken"),
            keywords: &[
                "!",
                "interpunctie",
                "rood uitroepteken",
                "teken",
                "uitroep",
                "uitroepteken",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("raudt utropsteikn"),
            keywords: &[
                "!",
                "raudt utropsteikn",
                "teikn",
                "teiknsetjing",
                "utrop",
                "utropsteikn",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ବ\u{b3f}ସ\u{b4d}ମୟସ\u{b42}ଚକ ଚ\u{b3f}ହ\u{b4d}ନ"),
            keywords: &[
                "!",
                "ଚ\u{b3f}ହ\u{b4d}ନ",
                "ବ\u{b3e}ହ\u{b4d}ୟରେଖ\u{b3e}ଯ\u{b41}କ\u{b4d}ତ",
                "ବ\u{b3f}ର\u{b3e}ମ ଚ\u{b3f}ହ\u{b4d}ନ",
                "ବ\u{b3f}ସ\u{b4d}ମୟସ\u{b42}ଚକ ଚ\u{b3f}ହ\u{b4d}ନ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਲਾਲ ਹ\u{a48}ਰਾਨੀਵਾਚਕ ਚਿ\u{a70}ਨ\u{a4d}ਹ"),
            keywords: &[
                "ਚਿ\u{a70}ਨ\u{a4d}ਹ",
                "ਲਾਲ ਹ\u{a48}ਰਾਨੀਵਾਚਕ ਚਿ\u{a70}ਨ\u{a4d}ਹ",
                "ਵਿਰਾਮ ਚਿ\u{a70}ਨ\u{a4d}ਹ",
                "ਹ\u{a48}ਰਾਨੀਵਾਚਕ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("پ\u{64f}ٹھا فجائی نشان"),
            keywords: &[
                "رموز اوقاف",
                "نشان لانا",
                "پ\u{64f}ٹھا فجائی نشان",
                "چیخ و پکار",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Rẹ\u{301}d Ẹksklaméshọn Mak"),
            keywords: &[
                "!",
                "Mak",
                "Pọnkchuéshọn",
                "Rẹ\u{301}d Ẹksklaméshọn Mak",
                "Ẹksklaméshọn",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("czerwony wykrzyknik"),
            keywords: &["!", "czerwony wykrzyknik", "krzyk", "okrzyk", "wykrzyknik"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ندا نښه"),
            keywords: &["!", "د وقفې علامت", "ندا", "نښه"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("ponto de exclamação vermelho"),
            keywords: &[
                "!",
                "exclamação",
                "ponto de exclamação",
                "ponto de exclamação vermelho",
                "pontuação",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("ponto de exclamação vermelho"),
            keywords: &[
                "!",
                "exclamação",
                "ponto de exclamação",
                "ponto de exclamação vermelho",
                "pontuação",
                "sinal",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("semnul exclamării"),
            keywords: &[
                "!",
                "exclamație",
                "mirare",
                "punctuație",
                "semn",
                "semnul exclamării",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-145"),
            keywords: &["E10-145"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("красный восклицательный знак"),
            keywords: &[
                "восклицание",
                "восклицательный знак",
                "знак",
                "красный",
                "красный восклицательный знак",
                "пунктуация",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("agatangaro gacuritse"),
            keywords: &["agatangaro", "agatangaro gacuritse", "akarango", "akatuzo"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڳاڙهي عجب جي نشاني"),
            keywords: &[
                "!",
                "عجب",
                "عجب جي نشاني",
                "مارڪ",
                "پنڪچويشن",
                "ڳاڙهي عجب جي نشاني",
            ],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ව\u{dd2}ස\u{dca}මය\u{dcf}ර\u{dca}ථ ලක\u{dd4}ණ"),
            keywords: &[
                "ලක\u{dd4}ණ",
                "ව\u{dd2}ර\u{dcf}ම ලක\u{dd4}ණ",
                "ව\u{dd2}ස\u{dca}මය\u{dcf}ර\u{dca}ථ ලක\u{dd4}ණ",
                "ව\u{dd2}ස\u{dca}මය\u{dcf}ර\u{dca}ථය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("červený výkričník"),
            keywords: &[
                "!",
                "interpunkcia",
                "výkričník",
                "znak",
                "zvolanie",
                "červený výkričník",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("rdeč klicaj"),
            keywords: &["!", "klicaj", "ločilo", "rdeč klicaj", "znak"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("calaamad cajiib"),
            keywords: &["!", "cajiib", "calaamad", "xarakayn"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("shenja e pikëçuditjes"),
            keywords: &["pikësim", "pikëçuditje", "shenja e pikëçuditjes", "shenjë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("узвичник"),
            keywords: &["знaк", "интeрпункциja", "узвичник"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("uzvičnik"),
            keywords: &["interpunkcija", "uzvičnik", "znak"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("rött utropstecken"),
            keywords: &["kommatering", "rött", "utropstecken"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("alama nyekundu ya mshangao"),
            keywords: &[
                "!",
                "alama",
                "alama nyekundu ya mshangao",
                "alama ya mshangao",
                "mshangao",
                "uakifishaji",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ஆச\u{bcd}சர\u{bcd}யக\u{bcd} குறி"),
            keywords: &[
                "ஆச\u{bcd}சரியக\u{bcd}குறி",
                "ஆச\u{bcd}சர\u{bcd}யக\u{bcd} குறி",
                "குறி",
                "சிவப\u{bcd}பு நிற ஆச\u{bcd}சரியக\u{bcd}குறி",
                "நிறுத\u{bcd}தற\u{bcd}குறி",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ఆశ\u{c4d}చర\u{c4d}య\u{c3e}ర\u{c4d}థకం గుర\u{c4d}తు"),
            keywords: &["ఆశ\u{c4d}చర\u{c4d}య\u{c3e}ర\u{c4d}థకం", "గుర\u{c4d}తు"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("аломати хитоб"),
            keywords: &["аломат", "аломати хитоб", "аломатҳои китобатӣ", "хитоб"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เคร\u{e37}\u{e48}องหมายอ\u{e31}ศเจร\u{e35}ย\u{e4c}ส\u{e35}แดง"),
            keywords: &[
                "!",
                "เคร\u{e37}\u{e48}องหมาย",
                "เคร\u{e37}\u{e48}องหมายวรรคตอน",
                "เคร\u{e37}\u{e48}องหมายอ\u{e31}ศเจร\u{e35}ย\u{e4c}",
                "เคร\u{e37}\u{e48}องหมายอ\u{e31}ศเจร\u{e35}ย\u{e4c}ส\u{e35}แดง",
            ],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ቀይሕ ምልክት ስምዒት"),
            keywords: &["!", "ምልክት", "ስምዒት", "ስርዓተ-ነጥብታት", "ቀይሕ ምልክት ስምዒት"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("gyzyl ýüzlenme belgisi"),
            keywords: &[
                "!",
                "belgi",
                "dyngy",
                "gyzyl ýüzlenme belgisi",
                "ýüzlenme",
                "ýüzlenme belgisi",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("fakaʻilonga kalanga kulokula"),
            keywords: &["fakaʻilonga", "fakaʻilonga kalanga kulokula", "kalanga"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("kırmızı ünlem işareti"),
            keywords: &[
                "!",
                "kırmızı ünlem işareti",
                "noktalama",
                "ünlem",
                "ünlem işareti",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئۈندەش بەلگىسى"),
            keywords: &["ئۈندەش", "ئۈندەش بەلگىسى", "بەلگە", "تىنىش"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("червоний знак оклику"),
            keywords: &[
                "!",
                "знак оклику",
                "оклик",
                "пунктуація",
                "розділовий знак",
                "червоний знак оклику",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ندائیہ نشان"),
            keywords: &[
                "!",
                "رموز\u{650} اوقاف",
                "علامت",
                "ندائیہ علامت",
                "ندائیہ نشان",
            ],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("qizil undov belgisi"),
            keywords: &[
                "!",
                "belgi",
                "qizil undov belgisi",
                "tinish belgisi",
                "undov",
                "undov belgisi",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("dấu chấm than đỏ"),
            keywords: &[
                "chấm",
                "cảm thán",
                "dấu",
                "dấu chấm than",
                "dấu chấm than đỏ",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("tombu esklamaasiyoŋ"),
            keywords: &["esklamaasiyoŋ", "màndarga", "tomb", "tombu esklamaasiyoŋ"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("uphawu lwesikhuzo"),
            keywords: &["isikhuzo", "isiphumlisi", "uphawu", "uphawu lwesikhuzo"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("àmì ìyàlẹ\u{301}nu ìdàkodò"),
            keywords: &["àmì", "àmì ìyanu", "àmì ìyàlẹ\u{301}nu ìdàkodò", "ìfàmìsí"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("感歎號"),
            keywords: &["感歎號", "標點符號", "符號"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("红色感叹号"),
            keywords: &["感叹号", "标点符号", "符号", "红色感叹号"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("红色感叹号"),
            keywords: &["吃惊", "感叹号", "标点符号", "红色感叹号", "！"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("紅色驚嘆號"),
            keywords: &["標點", "紅色驚嘆號", "驚嘆號"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("感嘆號"),
            keywords: &["感嘆號", "標點"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("uphawu lwesibabazi"),
            keywords: &["isibabazi", "uphawu", "uphawu lwesibabazi"],
        },
    ],
};
#[doc = "〰\u{fe0f}"]
pub const WAVY_DASH: crate::Emoji = crate::Emoji {
    glyph: "〰\u{fe0f}",
    codepoint: "3030 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "wavy dash",
    group: "Symbols",
    subgroup: "punctuation",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "〰",
        codepoint: "3030",
        status: crate::Status::Unqualified,
        introduction_version: 0.6f32,
        name: "wavy dash",
        group: "Symbols",
        subgroup: "punctuation",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("golfstreep"),
            keywords: &["golf", "golfstreep", "leesteken", "streep"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ሞገዳማ ሰረዝ"),
            keywords: &["ሞገዳማ", "ሞገዳማ ሰረዝ", "ሥርዓተ ነጥብ", "ሰርዝ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("شرطة مموجة"),
            keywords: &["شرطة", "شرطة مموجة", "علامة صوت طويل", "مموج"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ঢৌ খেলোৱ\u{9be} ডেছ"),
            keywords: &[
                "ডেছ",
                "ঢৌ খেলোৱ\u{9be}",
                "ঢৌ খেলোৱ\u{9be} ডেছ",
                "যতি-চিহ\u{9cd}ন",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("dalğalı tire"),
            keywords: &["dalğalı tire", "dalğavari", "durğu işarəsi", "tire"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("хвалісты працяжнік"),
            keywords: &["працяжнік", "пунктуацыя", "хвалісты"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Вълнообразно тире"),
            keywords: &["Вълнообразно тире", "вълнообразно", "пунктуация", "тире"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("তরঙ\u{9cd}গ\u{9be}য\u{9bc}িত ড\u{9cd}য\u{9be}শ"),
            keywords: &[
                "ড\u{9cd}য\u{9be}শ",
                "তরঙ\u{9cd}গ\u{9be}য\u{9bc}িত",
                "যতিচিহ\u{9cd}ন",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("talasasta crta"),
            keywords: &["crtice", "interpunkcija", "talas", "talasasta crta"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("guió ondulat"),
            keywords: &["guió", "ondulat", "puntuació"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᎵᏐᏰᎭ ᎤᏓᏂᏴᎢ"),
            keywords: &["ᎠᎵᏐᏰᎭ", "ᎤᏓᏂᏴᎢ", "ᏚᏙᏪᎸ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("dlouhá vlnovka"),
            keywords: &[
                "dlouhá vlnovka",
                "interpunkce",
                "interpunkční",
                "pomlčka",
                "vlnitá",
                "vlny",
                "znaménka",
                "čára",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("llinell donnog"),
            keywords: &["atalnodiad", "llinell", "llinell donnog", "tonnog"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("bølgestreg"),
            keywords: &["bølgestreg", "bølget", "tegn", "tegnsætning"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Wellenlinie"),
            keywords: &["Linie", "Wellenlinie", "gewellt"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κυματιστή παύλα"),
            keywords: &["κυματιστή παύλα", "κυματιστό", "παύλα", "στίξη"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("wavy dash"),
            keywords: &["dash", "punctuation", "wavy"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("guion ondulado"),
            keywords: &["guion", "marca de sonido largo", "ondulado"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("línea ondulada"),
            keywords: &[
                "guion",
                "línea ondulada",
                "marca de sonido largo",
                "ondulado",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("laineline kriips"),
            keywords: &["kirjavahemärk", "kriips", "laineline"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("marratxo ondulatua"),
            keywords: &["marratxo", "marratxo ondulatua", "ondulatu", "puntuazio"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("خط موج\u{200c}دار"),
            keywords: &["خط", "علامت\u{200c}گذاری", "موج\u{200c}دار"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("aaltoviiva"),
            keywords: &["aaltoileva", "aaltoviiva", "viiva", "välimerkki"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("maalon na gitling"),
            keywords: &["bantas", "gitling", "maalon", "maalon na gitling"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("aldandi tankastrika"),
            keywords: &["aldandi", "greinarmerki", "tankastrika", "teknseting"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("ligne ondulée"),
            keywords: &[
                "ligne ondulée",
                "ponctuation",
                "trait d’union ondulé",
                "vague",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("dais chorrach"),
            keywords: &["corrach", "dais", "dais chorrach", "fuaim-mharc fada"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("loidhne lùbach"),
            keywords: &["comharra", "dais", "loidhne", "lùbach", "puingeachadh"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("liña ondulada"),
            keywords: &["liña ondulada", "onda", "ondulado", "son largo", "trazo"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("લહ\u{ac7}રાતો ડ\u{ac7}શ"),
            keywords: &[
                "ડ\u{ac7}શ",
                "લહ\u{ac7}રાત\u{ac1}\u{a82}",
                "લહ\u{ac7}રાતો ડ\u{ac7}શ",
                "લા\u{a82}બ\u{ac1}\u{a82} ધ\u{acd}વનિ ચિહ\u{acd}ન",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("alamar fid da ma’ana mai igiyar ruwa"),
            keywords: &[
                "alamar fid da ma’ana",
                "alamar fid da ma’ana mai igiyar ruwa",
                "alamomin rubutu",
                "mai igiyar ruwa",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("קו גלי"),
            keywords: &["גלי", "סימני פיסוק", "קו גלי", "קו מפריד"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("लहरिल ड\u{948}श"),
            keywords: &["चिह\u{94d}न विचार", "ड\u{948}श", "लहरिल"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("valovita crta"),
            keywords: &["crta", "interpunkcija", "valovita crta", "valovito"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("hullámos gondolatjel"),
            keywords: &["gondolatjel", "hullámos", "központozás"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ալիքաձև գծիկ"),
            keywords: &["ալիքաձև", "գծիկ", "կետադրություն"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("garis bergelombang"),
            keywords: &[
                "garis bergelombang",
                "gelombang",
                "tanda baca",
                "tanda pisah",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("akara mgbagọ"),
            keywords: &["akara mgbagọ", "kpọm", "ntụpọ", "wavy"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("bugðustrik"),
            keywords: &["alda", "bugða", "bugðustrik", "strik"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("trattino ondulato"),
            keywords: &["ondulato", "trattino"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("波線"),
            keywords: &["波線", "約物", "記号"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("setrip ngeluk"),
            keywords: &["ngeluk", "setrip", "tandha wacan"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ტალღოვანი ტირე"),
            keywords: &["პუნქტუაცია", "ტალღოვანი", "ტირე"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("ирек сызықша"),
            keywords: &["ирек", "пунктуация", "сызықша"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("bølgestreg"),
            keywords: &["bølgestreg", "bølget", "tegn", "tegnsætning"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("សញ\u{17d2}ញាទ\u{17b9}ករលក"),
            keywords: &["រលក", "សញ\u{17d2}ញា", "សញ\u{17d2}ញាទ\u{17b9}ករលក"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಅಲ\u{cc6}ಯಾದ ಡ\u{ccd}ಯಾಶ\u{ccd}"),
            keywords: &[
                "ಅಲ\u{cc6} ಅಲ\u{cc6}ಯಾದ ಡ\u{ccd}ಯಾಶ\u{ccd}",
                "ಅಲ\u{cc6}ಯಾದ ಡ\u{ccd}ಯಾಶ\u{ccd}",
                "ದೀರ\u{ccd}ಘವಾದ ಶಬ\u{ccd}ದದ ಗುರುತು",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("물결 모양 대시"),
            keywords: &["물결", "물결 모양 대시", "물결표"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("तर\u{902}ग ड\u{945}श"),
            keywords: &["ड\u{945}श", "तर\u{902}ग", "विरामचिन\u{94d}न"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("толкундуу сызыкча"),
            keywords: &["пунктуация", "сызыкча", "толкундуу"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("gewellte Stréch"),
            keywords: &["Interpunktioun", "Stréch", "gewellt", "gewellte Stréch"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເສ\u{eb1}\u{ec9}ນຄ\u{eb7}\u{ec9}ນ"),
            keywords: &[
                "ຄ\u{eb7}\u{ec9}ນ",
                "ເຄ\u{eb7}\u{ec8}ອງໝາຍ",
                "ເສ\u{eb1}\u{ec9}ນ",
                "ເສ\u{eb1}\u{ec9}ນຄ\u{eb7}\u{ec9}ນ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("vingiuotas brūkšnys"),
            keywords: &["brūkšnys", "skyryba", "vingiuotas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("viļņota domuzīme"),
            keywords: &["domuzīme", "viļņota"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pīhono karekare"),
            keywords: &["karekare", "pīhono", "tohutuhi"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("брановидна цртичка"),
            keywords: &["брановидна цртичка", "знак", "интерпункција", "цртичка"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("വേവി ഡ\u{d3e}ഷ\u{d4d}"),
            keywords: &[
                "ഡ\u{d3e}ഷ\u{d4d}",
                "തരംഗ ഡ\u{d3e}ഷ\u{d4d}",
                "തിരകൾ",
                "വേവി ഡ\u{d3e}ഷ\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("долгионтой зураас"),
            keywords: &["долгионтой зураас", "зураас", "цэг"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("नागमोडी ड\u{945}श"),
            keywords: &["ड\u{945}श", "नागमोडी", "विरामचिन\u{94d}ह"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("sengkang berombak-ombak"),
            keywords: &["berombak-ombak", "sengkang", "tanda baca"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("sing immewwweġ"),
            keywords: &["mmewwweġ", "punteġġjatura", "sing", "sing immewwweġ"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "လ\u{103e}\u{102d}\u{102f}င\u{103a}းထနေသည\u{1037}\u{103a} မျဉ\u{103a}းရ\u{103e}ည\u{103a}",
            ),
            keywords: &[
                "ပ\u{102f}ဒ\u{103a}ဖြတ\u{103a}ပ\u{102f}ဒ\u{103a}ရပ\u{103a}",
                "မျဥ\u{103a}းရ\u{103e}ည\u{103a}",
                "လ\u{103e}\u{102d}\u{102f}င\u{103a}း သင\u{103a}\u{1039}ကေတ",
                "လ\u{103e}\u{102d}\u{102f}င\u{103a}းထနေသည\u{1037}\u{103a} မျဉ\u{103a}းရ\u{103e}ည\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("bølgestrek"),
            keywords: &[
                "bølge",
                "bølgestrek",
                "bølget bindestrek",
                "tegn for lang lyd",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("झ\u{941}न\u{94d}डिएको ड\u{94d}याश"),
            keywords: &["झ\u{941}न\u{94d}डिएको", "ड\u{94d}याश", "विराम चिन\u{94d}ह"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("golvend streepje"),
            keywords: &["golvend", "lang geluid", "streepje"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("bølgjestrek"),
            keywords: &[
                "bølgja bindestrek",
                "bølgje",
                "bølgjestrek",
                "teikn for lang lyd",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("କ\u{b41}ଣ\u{b4d}ଡଳ\u{b3e}କ\u{b3e}ର ଡ\u{b4d}ୟ\u{b3e}ଶ\u{b4d}\u{200c}"),
            keywords: &[
                "କ\u{b41}ଣ\u{b4d}ଡଳ\u{b3e}କ\u{b3e}ର ଡ\u{b4d}ୟ\u{b3e}ଶ\u{b4d}\u{200c}",
                "ଡ\u{b4d}ୟ\u{b3e}ଶ\u{b4d}\u{200c} । ବ\u{b3f}ର\u{b3e}ମ ଚ\u{b3f}ହ\u{b4d}ନ । କ\u{b41}ଣ\u{b4d}ଡଳ\u{b3e}କ\u{b3e}ର",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਲਹਿਰ ਡ\u{a48}ਸ"),
            keywords: &["ਡ\u{a48}ਸ", "ਲਹਿਰ", "ਲ\u{a70}ਮੀ ਆਵਾਜ\u{a3c} ਨਿਸ\u{a3c}ਾਨ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("لہراندی ڈیش"),
            keywords: &["رموز اوقاف", "لہراندی ڈیش", "لہردار", "مارنا"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Kọv-kọ\u{301}v Dash"),
            keywords: &["Dash", "Kọv-kọ\u{301}v", "Pọnkchuéshọn"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("falista kreska"),
            keywords: &["fala", "falista kreska", "linia", "pofalowana"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("کوږ ډيش"),
            keywords: &["د وقفې علامت", "ډيش", "کوږ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("travessão ondulado"),
            keywords: &["ondulado", "pontuação", "travessão"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("traço ondulado"),
            keywords: &["ondulado", "pontuação", "traço"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("muyuq rakiqch’iku"),
            keywords: &["muyuq rakiqch’iku"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("liniuță ondulată"),
            keywords: &["liniuță", "liniuță ondulată", "ondulat"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-163"),
            keywords: &["E10-163"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("волнистая линия"),
            keywords: &["волна", "волнистая", "знак", "линия", "пунктуация"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("akanyerezo - muvumba"),
            keywords: &["akanyerezo", "akanyerezo - muvumba", "akatuzo", "akavumba"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("لڏندڙ ڊيش"),
            keywords: &["لڏندڙ", "وقف جي علامت", "ڊيش"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("රැළ\u{dd2} සහ\u{dd2}ත කෙට\u{dd2} ඉර"),
            keywords: &[
                "කෙට\u{dd2} ඉර",
                "රැළ\u{dd2}",
                "රැළ\u{dd2} සහ\u{dd2}ත කෙට\u{dd2} ඉර",
                "ව\u{dd2}ර\u{dcf}ම ලක\u{dd4}ණ",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("vlnovková pomlčka"),
            keywords: &[
                "interpunkcia",
                "vlnovka",
                "vlnovkovitá",
                "vlnovková pomlčka",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("valovit pomišljaj"),
            keywords: &["ločilo", "pomišljaj", "valovit pomišljaj", "valovito"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("qulqulka hirka"),
            keywords: &[
                "calaamadda qulqulka hirka oo kale",
                "qaab hir oo kale",
                "qulqulka hirka",
                "xarakayn",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("vijë e valëzuar"),
            keywords: &["e valëzuar", "pikësim", "vijë", "vijë e valëzuar"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("таласаста црта"),
            keywords: &["интерпункција", "таласаста црта", "таласасто", "црта"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["таласаста црта"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("talasasta crta"),
            keywords: &["crta", "interpunkcija", "talasasta crta", "talasasto"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["talasasta crta"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("vågigt tankstreck"),
            keywords: &["tankstreck", "vågig", "vågigt tankstreck"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("dashi iliyopinda"),
            keywords: &["dashi", "dashi iliyopinda", "kupinda", "uakifishaji"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("அலை"),
            keywords: &[
                "அலை",
                "அலை ஓசை",
                "அலை சத\u{bcd}தம\u{bcd}",
                "இரைச\u{bcd}சல\u{bcd} சத\u{bcd}தம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("తరంగ\u{c3e}ల గుర\u{c4d}తు"),
            keywords: &["గుర\u{c4d}తు", "తరంగం", "తరంగ\u{c3e}ల గుర\u{c4d}తు"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("тиреи мавҷдор"),
            keywords: &["аломати китобатӣ", "мавҷдор", "тире", "тиреи мавҷдор"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เส\u{e49}นคล\u{e37}\u{e48}น"),
            keywords: &[
                "คล\u{e37}\u{e48}น",
                "เคร\u{e37}\u{e48}องหมาย",
                "เส\u{e49}น",
                "เส\u{e49}นคล\u{e37}\u{e48}น",
            ],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ሞገዳዊ ዳሽ"),
            keywords: &["ሞገዳዊ", "ስርዓተ-ነጥብታት", "ዳሽ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("tolkunly kese çyzyk"),
            keywords: &["dyngy", "kese çyzyk", "tolkunly", "tolkunly kese çyzyk"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("fakaʻilonga kohi fafasi"),
            keywords: &["fafasi", "fakaʻilonga", "kohi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("dalgalı çizgi"),
            keywords: &["dalgalı", "uzun ses işareti", "çizgi"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("دولقۇنلۇق كۆپ چېكىت"),
            keywords: &["تىنىش", "دولقۇنلق", "دولقۇنلۇق كۆپ چېكىت", "چېكىت"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("хвилясте тире"),
            keywords: &["пунктуація", "тире", "хвилясте тире", "хвилястий"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("لہردار ڈیش"),
            keywords: &["رموز\u{650} اوقاف", "لہردار", "ڈیش"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("to‘lqinli chiziq"),
            keywords: &["defis", "tinish", "to‘lqinli", "to‘lqinli chiziq"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("dấu gạch ngang lượn sóng"),
            keywords: &[
                "dấu",
                "dấu gạch ngang",
                "dấu gạch ngang lượn sóng",
                "lượn sóng",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("tiire ondule"),
            keywords: &["ondule", "tiire", "tomb"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("idesh ewangawangisayo"),
            keywords: &[
                "idesh ewangawangisayo",
                "ideshi",
                "isiphumlisi",
                "wangawangisayo",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("dáàṣì onísàn omi"),
            keywords: &["dáàṣì", "dáàṣì onísàn omi", "ìfàmìsí", "ìsàn omi"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("波浪破折號"),
            keywords: &["標點符號", "波浪", "波浪破折號", "破折號"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("波浪破折号"),
            keywords: &["标点符号", "波浪", "波浪破折号", "破折号"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("波浪型破折号"),
            keywords: &["标点符号", "波浪型破折号", "浪花"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("波浪線"),
            keywords: &["標點", "波浪線"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("波浪破折號"),
            keywords: &["標點", "波浪破折號"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("udeshi osagagasi"),
            keywords: &["okusagagasi", "udeshi", "udeshi osagagasi"],
        },
    ],
};
