#[doc = "⚕\u{fe0f}"]
pub const MEDICAL_SYMBOL: crate::Emoji = crate::Emoji {
    glyph: "⚕\u{fe0f}",
    codepoint: "2695 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "medical symbol",
    group: "Symbols",
    subgroup: "other-symbol",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "⚕",
        codepoint: "2695",
        status: crate::Status::Unqualified,
        introduction_version: 4f32,
        name: "medical symbol",
        group: "Symbols",
        subgroup: "other-symbol",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("mediese simbool"),
            keywords: &["eskulaap", "mediese simbool"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የመድሃኒት ምልክት"),
            keywords: &["መድሃኒት", "የመድሃኒት ምልክት", "የስራ ባልደረባ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("رمز طبي"),
            keywords: &["رمز طبي", "طب", "فريق"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("চিকিৎস\u{9be}-সম\u{9cd}বন\u{9cd}ধীয\u{9bc} চিহ\u{9cd}ন"),
            keywords: &[
                "কৰ\u{9cd}মচ\u{9be}ৰীবৰ\u{9cd}গ",
                "চিকিৎস\u{9be}-সম\u{9cd}বন\u{9cd}ধীয\u{9bc} চিহ\u{9cd}ন",
                "ড\u{9be}ক\u{9cd}তৰী",
                "দৰৱ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("tibb işarəsi"),
            keywords: &["eskulap", "heyət", "tibb", "tibb işarəsi"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("медыцынскі сімвал"),
            keywords: &[
                "Асклепій",
                "медыцына",
                "медыцынскі сімвал",
                "посах",
                "эскулап",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("символ за медицина"),
            keywords: &["медицина", "медицински символ", "символ за медицина"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("চিকিৎস\u{9be}র চিহ\u{9cd}ন"),
            keywords: &[
                "অ\u{9cd}য\u{9be}সক\u{9cd}লিপিয\u{9bc}স",
                "ঔযদ",
                "চিকিৎস\u{9be}",
                "চিকিৎস\u{9be}র চিহ\u{9cd}ন",
                "স\u{9cd}ট\u{9be}ফ",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("naerwialenn"),
            keywords: &["medisinerezh", "mezegiezh", "naerwialenn"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("medicinski simbol"),
            keywords: &["aesculapius", "medicina", "medicinski simbol", "osoblje"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("símbol mèdic"),
            keywords: &["Esculapi", "medicina", "personal", "serp", "símbol mèdic"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏅᏬᏘ ᎤᏙᏢᎭ"),
            keywords: &["ᎤᏓᎳᏄᏍᏘ", "ᏅᏬᏘ", "ᏅᏬᏘ ᎢᎾᏓ", "ᏅᏬᏘ ᎤᏙᏢᎭ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("znak medicíny"),
            keywords: &[
                "aesculap",
                "aesculapova",
                "aeskulap",
                "aeskulapova",
                "doktor",
                "eskulap",
                "eskulapova",
                "hůl",
                "lékař",
                "lékařství",
                "lékárna",
                "lékárník",
                "medicína",
                "nemocnice",
                "znak medicíny",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("arwydd meddygol"),
            keywords: &["arwydd meddygol", "esgwlapaidd", "meddyginiaeth", "staff"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("medicinsymbol"),
            keywords: &[
                "lægekunst",
                "lægevidenskab",
                "medicin",
                "medicinsymbol",
                "slange",
                "stav",
                "æskulap",
                "æskulapstav",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Äskulapstab"),
            keywords: &["Apotheke", "Asklepiosstab", "Medizin", "Äskulapstab"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ιατρικό σύμβολο"),
            keywords: &["ιατρική", "ιατρικό σύμβολο", "ράβδος", "σύμβολο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("medical symbol"),
            keywords: &["aesculapius", "medical symbol", "medicine", "staff"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("símbolo de medicina"),
            keywords: &[
                "asclepio",
                "esculapio",
                "medicina",
                "serpiente",
                "símbolo de medicina",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &[
                "asclepio",
                "esculapio",
                "medicina",
                "serpiente",
                "símbolo de medicina",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &[
                "asclepio",
                "esculapio",
                "medicina",
                "serpiente",
                "símbolo de medicina",
            ],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("meditsiinisümbol"),
            keywords: &["Asklepios", "meditsiin", "meditsiinisümbol"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("ikur medikoa"),
            keywords: &["Asklepio", "ikur medikoa", "medizina", "sendagile"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("نماد پزشکی"),
            keywords: &[
                "عصای آسک\u{650}ل\u{650}پیوس",
                "مار و عصا",
                "نماد مار و عصا",
                "نماد پزشکی",
                "چوبدست اسقلبیوس",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("lääketieteen symboli"),
            keywords: &["Asklepioksen sauva", "lääketieteen symboli"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("simbolong pang-medikal"),
            keywords: &[
                "aesculapius",
                "gamot",
                "medisina",
                "simbolo",
                "simbolong pang-medikal",
                "staff",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("læknavísind symbol"),
            keywords: &[
                "eskulápusarstavur",
                "læknafrøði",
                "læknavísind symbol",
                "læknavísindanna",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("caducée"),
            keywords: &["caducée", "médecine", "personnel"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("symbole la médecine"),
            keywords: &[
                "Asclépios",
                "médecine",
                "professionnel de la santé",
                "symbole de la médecine",
                "symbole la médecine",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("siombail leighis"),
            keywords: &[
                "aescaláipias",
                "foireann",
                "leigheas",
                "siombail leighis",
                "siombal leighis",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("samhla meadaigeach"),
            keywords: &["aesculapius", "bata", "leigheas", "samhla meadaigeach"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("símbolo da medicina"),
            keywords: &[
                "Esculapio",
                "farmacia",
                "medicina",
                "serpe",
                "símbolo da medicina",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("મ\u{ac7}ડિકલ સિમ\u{acd}બલ"),
            keywords: &["દવા", "મ\u{ac7}ડિકલ સિમ\u{acd}બલ", "સ\u{acd}ટાફ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("alamar kula da lafiya"),
            keywords: &[
                "aesculapius",
                "alamar kula da lafiya",
                "magani",
                "ma’aikata",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("סמל הרפואה"),
            keywords: &[
                "אל הרפואה במיתולוגיה היוונית והרומית",
                "אסקלפיוס",
                "סמל הרפואה",
                "רפואה",
            ],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("चिकित\u{94d}सा प\u{94d}रतीक"),
            keywords: &[
                "कर\u{94d}मचारी",
                "चिकित\u{94d}सा",
                "चिकित\u{94d}सा प\u{94d}रतीक",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("simbol medicine"),
            keywords: &["Asklepijev štap", "simbol medicine"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("orvosi szimbólum"),
            keywords: &[
                "Aszklépiosz",
                "bot",
                "orvos",
                "orvosi szimbólum",
                "orvoslás",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("բժշկության խորհրդանիշ"),
            keywords: &["բժիշկ", "բժշկության խորհրդանիշ", "բժշկություն"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("simbol kedokteran"),
            keywords: &["aesculapius", "kedokteran", "simbol kedokteran", "tongkat"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ọdịmara ngwaọrụ ụlọ ọgwụ"),
            keywords: &[
                "aesculapius",
                "ngwaọrụ ụlọ ọgwụ",
                "staff",
                "ọdịmara ngwaọrụ ụlọ ọgwụ",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("lækningamerki"),
            keywords: &[
                "læknavísindi",
                "lækningamerki",
                "lækningar",
                "læknir",
                "merki",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("simbolo della medicina"),
            keywords: &["bastone di esculapio", "medicina", "simbolo della medicina"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("医療のシンボル"),
            keywords: &[
                "アスクレピオスの杖",
                "医療",
                "医療のシンボル",
                "医者",
                "治療",
            ],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("tandha medhis"),
            keywords: &["aesculapius", "obat", "pegawe", "tandha medhis"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("სამედიცინო ნიშანი"),
            keywords: &["პერსონალი", "სამედიცინო ნიშანი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("медицина таңбасы"),
            keywords: &["медицина", "медицина таңбасы", "таңба"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("medicinsymbol"),
            keywords: &[
                "lægekunst",
                "lægevidenskab",
                "medicin",
                "medicinsymbol",
                "slange",
                "stav",
                "æskulap",
                "æskulapstav",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("សញ\u{17d2}ញាពេទ\u{17d2}យ"),
            keywords: &["ពេទ\u{17d2}យ", "ព\u{17d2}យាបាល", "សញ\u{17d2}ញាពេទ\u{17d2}យ"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ವೈದ\u{ccd}ಯಕೀಯ ಚ\u{cbf}ಹ\u{ccd}ನ\u{cc6}"),
            keywords: &[
                "ಏಸ\u{ccd}ಕುಲೇಪ\u{cbf}ಯಸ\u{ccd}",
                "ಔಷಧ\u{cbf}",
                "ವೈದ\u{ccd}ಯಕೀಯ ಚ\u{cbf}ಹ\u{ccd}ನ\u{cc6}",
                "ಸ\u{cbf}ಬ\u{ccd}ಬಂದ\u{cbf}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("의학 기호"),
            keywords: &["의술의 신", "의학", "의학 기호"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("व\u{948}द\u{94d}यकीय चिन\u{94d}न"),
            keywords: &[
                "एस\u{94d}क\u{941}लापियस",
                "व\u{948}द\u{94d}यकीय",
                "व\u{948}द\u{94d}यकीय चिन\u{94d}न",
                "स\u{94d}टाफ",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("эскулап белгиси"),
            keywords: &["дары-дармек", "эскулап", "эскулап белгиси"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("medezinescht Symbol"),
            keywords: &["Asklepios", "Medezin", "Personal", "medezinescht Symbol"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ສ\u{eb1}ນຍາລ\u{eb1}ກການຢາ"),
            keywords: &["ການຢາ", "ຢາ", "ສ\u{eb1}ນຍາລ\u{eb1}ກການຢາ", "ແພດ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("medicinos simbolis"),
            keywords: &["asklepijus", "medicina", "medicinos simbolis", "personalas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("medicīnas simbols"),
            keywords: &["eskulaps", "medicīna", "medicīnas simbols", "personāls"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tohu rongoā"),
            keywords: &["pou", "rata", "rongoā", "tohu rongoā"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("медицински симбол"),
            keywords: &["медицина", "медицински симбол"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("മെഡിക\u{d4d}കൽ അടയ\u{d3e}ളം"),
            keywords: &["അടയ\u{d3e}ളം", "ചിഹ\u{d4d}നം", "മെഡിക\u{d4d}കൽ"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("эмнэлгийн тэмдэг"),
            keywords: &["ажилтан", "эм", "эмнэлгийн тэмдэг", "эскулап"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("व\u{948}द\u{94d}यकीय चिन\u{94d}ह"),
            keywords: &[
                "अ\u{945}स\u{94d}क\u{94d}य\u{942}ल\u{947}पियस",
                "औषध",
                "कर\u{94d}मचारी",
                "व\u{948}द\u{94d}यकीय चिन\u{94d}ह",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("simbol perubatan"),
            keywords: &["perubatan", "simbol perubatan", "staf"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("simbolu mediku"),
            keywords: &["aesculapius", "mediċina", "persunal", "simbolu mediku"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဆေးဘက\u{103a}ဆ\u{102d}\u{102f}င\u{103a}ရာ သင\u{103a}\u{1039}ကေတ"),
            keywords: &[
                "ဆေးဘက\u{103a}ဆ\u{102d}\u{102f}င\u{103a}ရာ",
                "ဆေးဘက\u{103a}ဆ\u{102d}\u{102f}င\u{103a}ရာ သင\u{103a}\u{1039}ကေတ",
                "ဆေးဝါး",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("legesymbol"),
            keywords: &["asklepiosstav", "lege", "legesymbol", "medisin"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("चिकित\u{94d}सीय चिन\u{94d}ह"),
            keywords: &[
                "एस\u{94d}क\u{941}लापियस",
                "औ\u{902}षधि",
                "चिकित\u{94d}सीय चिन\u{94d}ह",
                "स\u{94d}टाफ",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("esculaap"),
            keywords: &["dokter", "esculaap"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("legesymbol"),
            keywords: &["asklepiosstav", "lege", "legesymbol", "medisin"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଡ\u{b3e}କ\u{b4d}ତରୀ ସଙ\u{b4d}କେତ"),
            keywords: &[
                "ଏସ\u{b41}ଲ\u{b3e}ପ\u{b3f}ୟସ",
                "ଔଷଧ",
                "କର\u{b4d}ମଚ\u{b3e}ରୀ",
                "ଡ\u{b3e}କ\u{b4d}ତରୀ ସଙ\u{b4d}କେତ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਡਾਕਟਰੀ ਚਿ\u{a70}ਨ\u{a4d}ਹ"),
            keywords: &[
                "ਅਮਲਾ",
                "ਚਿਕਿਤਸਾ ਸ\u{a70}ਕ\u{a47}ਤ",
                "ਡਾਕਟਰੀ ਚਿ\u{a70}ਨ\u{a4d}ਹ",
                "ਦਵਾਈ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("طبی علامت"),
            keywords: &["دوائی", "طب دا بانی", "طبی علامت", "عملہ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Mẹ\u{301}díkál Sain"),
            keywords: &[
                "Mẹ\u{301}díkál Sain",
                "Mẹ\u{301}dísin",
                "Wọ\u{301}ka-dẹm",
                "Wọ\u{301}kas",
                "Éskiulépiọs Mẹ\u{301}díkál Sain",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("symbol medycyny"),
            keywords: &["eskulap", "laska", "medycyna", "symbol medycyny"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("طبي سمبول"),
            keywords: &["ايسکولاپيس", "درمل", "طبي سمبول", "عمله"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("símbolo da medicina"),
            keywords: &[
                "bastão de asclépio",
                "esculápio",
                "medicina",
                "símbolo",
                "símbolo da medicina",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("símbolo médico"),
            keywords: &["esculápio", "medicina", "pessoal", "símbolo médico"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("hampiq unancha"),
            keywords: &["hampiq unancha"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("simbol medical"),
            keywords: &["Esculap", "medicamente", "personal", "simbol medical"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-086"),
            keywords: &["E10-086"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("медицинский символ"),
            keywords: &[
                "асклепий",
                "жезл",
                "медицина",
                "медицинский символ",
                "посох со змеей",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ikimenyetso cy’ubuvuzi"),
            keywords: &[
                "ikiganga",
                "ikimenyetso cy’ubuvuzi",
                "n’ikigirwamana cy’ubuvuzi",
                "ubuyobozi",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ميڊيڪل جي نشاني"),
            keywords: &["دوا", "طب جو ديوتا", "عملو", "ميڊيڪل جي نشاني"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("වෛද\u{dca}\u{200d}ය සංකේතය"),
            keywords: &[
                "ඖෂධ",
                "ක\u{dcf}ර\u{dca}ය මණ\u{dca}ඩලය",
                "වෛද\u{dca}\u{200d}ය සංකේතය",
                "සංජ\u{dcf}නනය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("lekársky symbol"),
            keywords: &["asklépios", "lekársky symbol", "lekárstvo", "medicína"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("simbol zdravstva"),
            keywords: &[
                "eskulapova palica",
                "medicina",
                "osebje",
                "simbol zdravstva",
                "zdravnik",
                "zdravstvo",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("calaamad caafimaad"),
            keywords: &[
                "calaamad caafimaad",
                "daawo",
                "dawo diineed hore ee Giriigga",
                "shaqaale",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("simboli mjekësor"),
            keywords: &[
                "asklepiu",
                "mjekësi",
                "personel mjekësor",
                "simboli mjekësor",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("медицински знак"),
            keywords: &[
                "ескулапијус",
                "знак",
                "медицина",
                "медицински знак",
                "особље",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("medicinski znak"),
            keywords: &[
                "eskulapijus",
                "medicina",
                "medicinski znak",
                "osoblje",
                "znak",
            ],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("medicinsk symbol"),
            keywords: &["aesculapius", "medicin", "medicinsk symbol", "personal"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("ishara ya taaluma ya matibabu"),
            keywords: &["dawa", "ishara", "ishara ya taaluma ya matibabu", "tiba"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("மருத\u{bcd}துவச\u{bcd} சின\u{bcd}னம\u{bcd}"),
            keywords: &[
                "ட\u{bbe}க\u{bcd}டர\u{bcd}",
                "மருத\u{bcd}துவச\u{bcd} சின\u{bcd}னம\u{bcd}",
                "மருத\u{bcd}துவர\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("వ\u{c48}ద\u{c4d}య చ\u{c3f}హ\u{c4d}నం"),
            keywords: &[
                "వ\u{c48}ద\u{c4d}య చ\u{c3f}హ\u{c4d}నం",
                "వ\u{c48}ద\u{c4d}యం",
                "వ\u{c4d}య\u{c3e}ధులను నయం చ\u{c47}స\u{c47} వ\u{c4d}యక\u{c4d}త\u{c3f}",
                "స\u{c3f}బ\u{c4d}బంద\u{c3f}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("аломати тиббӣ"),
            keywords: &["аломати тиббӣ", "дору", "кормандон", "табиб"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เคร\u{e37}\u{e48}องหมายการแพทย\u{e4c}"),
            keywords: &[
                "การแพทย\u{e4c}",
                "คทาง\u{e39}ไขว\u{e49}",
                "เคร\u{e37}\u{e48}องหมายการแพทย\u{e4c}",
                "แอสค\u{e39}ลาป\u{e34}อ\u{e38}ส",
                "ไม\u{e49}เท\u{e49}า",
            ],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ኣርማ ሕክምና"),
            keywords: &["ኣርማ ሕክምና", "ኣስኩልፒዩስ", "ኣባላት", "ፈውሲ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("lukmançylygyň nyşany"),
            keywords: &[
                "daşy ýylanly hasa",
                "hasa",
                "lukmançylygyň nyşany",
                "lukmançylyk",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("ʻilonga tōketā"),
            keywords: &["tōketā", "ʻilonga"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("tıp sembolü"),
            keywords: &[
                "Asklepios",
                "medikal sembol",
                "tıbbi sembol",
                "tıp",
                "tıp sembolü",
                "tıp çalışanı",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("دورا بەلگىسى"),
            keywords: &["ئاسكۇلاپىيۇس", "خادىم", "دورا", "دورا بەلگىسى"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("символ медицини"),
            keywords: &[
                "ескулап",
                "медицина",
                "медичний символ",
                "персонал",
                "символ медицини",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("طبی علامت"),
            keywords: &["صحت", "طبی", "علامت", "نشان"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("tibbiy ramz"),
            keywords: &["eskulap", "tibbiy ramz", "tibbiyot", "xodimlar"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("biểu tượng y tế"),
            keywords: &["biểu tượng y tế", "cán bộ", "rắn thần", "y học"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("màndarga medsin"),
            keywords: &["eskalapuus", "liggéeykat", "medsin", "màndarga medsin"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("isimboli yezonyango"),
            keywords: &[
                "abasebenzi",
                "amayeza",
                "i-aesculapius",
                "isimboli yezonyango",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("àmì egbògiogùn"),
            keywords: &["aesculapius", "àmì egbògiogùn", "ògùn", "òṣìṣẹ\u{301}"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("醫療符號"),
            keywords: &["員工", "埃斯科拉庇俄斯", "醫療符號", "醫藥"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("医疗符号"),
            keywords: &["医疗符号", "医药", "员工", "埃斯科拉庇俄斯"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("医疗标志"),
            keywords: &["医疗标志", "蛇杖", "阿斯克勒庇俄斯"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("醫療符號"),
            keywords: &["醫療符號"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("蛇杖"),
            keywords: &["蛇杖"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("uphawu losizo lwezempilo"),
            keywords: &["abasebenzi", "umuthi", "uphawu losizo lwezempilo"],
        },
    ],
};
#[doc = "♻\u{fe0f}"]
pub const RECYCLING_SYMBOL: crate::Emoji = crate::Emoji {
    glyph: "♻\u{fe0f}",
    codepoint: "267B FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "recycling symbol",
    group: "Symbols",
    subgroup: "other-symbol",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "♻",
        codepoint: "267B",
        status: crate::Status::Unqualified,
        introduction_version: 0.6f32,
        name: "recycling symbol",
        group: "Symbols",
        subgroup: "other-symbol",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("herwinningsimbool"),
            keywords: &["herwin", "herwinning", "herwinningsimbool"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የመልሶ ጥቅም ላይ ማዋል ምልክት"),
            keywords: &["መልሶ መጠቀም", "የመልሶ ጥቅም ላይ ማዋል ምልክት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("رمز تدوير"),
            keywords: &[
                "إشارة",
                "تدوير",
                "رمز تدوير",
                "صلبة",
                "علامة تدوير النفايات الصلبة",
            ],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("প\u{9c1}নৰ\u{9be}ৱৰ\u{9cd}তন চিহ\u{9cd}ন"),
            keywords: &[
                "প\u{9c1}নৰ\u{9be}ৱৰ\u{9cd}তন",
                "প\u{9c1}নৰ\u{9be}ৱৰ\u{9cd}তন চিহ\u{9cd}ন",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("təkrar istifadə simvolu"),
            keywords: &["təkrar istifadə", "təkrar istifadə simvolu"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("сімвал перапрацоўкі"),
            keywords: &["перапрацоўка", "сімвал перапрацоўкі", "утылізацыя"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Символ за рециклиране"),
            keywords: &["Символ за рециклиране", "рециклиране"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("রিস\u{9be}ইকেলিং চিহ\u{9cd}ন"),
            keywords: &[
                "প\u{9c1}নর\u{9cd}ব\u{9cd}যবহ\u{9be}র",
                "রিস\u{9be}ইকেলিং চিহ\u{9cd}ন",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("arouez adaozañ"),
            keywords: &["adaozañ", "arouez adaozañ"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("simbol za reciklažu"),
            keywords: &["reciklaža", "simbol za reciklažu"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("símbol de reciclatge"),
            keywords: &["reciclatge", "símbol", "símbol de reciclatge"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎢᎬᎦᏔᏂᏓᏍᏗ ᎪᏪᎵ"),
            keywords: &["ᎢᎬᎦᏔᏂᏓᏍᏗ", "ᎢᎬᎦᏔᏂᏓᏍᏗ ᎪᏪᎵ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("symbol recyklace"),
            keywords: &["recyklace", "symbol recyklace"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("symbol ailgylchu"),
            keywords: &["ailgylchu", "symbol ailgylchu"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("genbrug"),
            keywords: &["genbrug", "genbrugssymbol"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Recycling-Symbol"),
            keywords: &["Recycling", "Recycling-Symbol"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("σύμβολο ανακύκλωσης"),
            keywords: &["ανακυκλώνω", "σύμβολο ανακύκλωσης"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("recycling symbol"),
            keywords: &["recycle", "recycling symbol"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("símbolo de reciclaje"),
            keywords: &[
                "reciclaje",
                "reciclar",
                "señal",
                "símbolo de reciclaje",
                "símbolo universal de reciclaje sólido",
                "universal",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &[
                "reciclado",
                "reciclaje",
                "reciclar",
                "símbolo",
                "símbolo de reciclaje",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("taaskasutuse sümbol"),
            keywords: &["taaskasutus", "taaskasutuse sümbol"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("birziklatzeko ikurra"),
            keywords: &["birziklatu", "birziklatzeko ikurra"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("نماد بازیافت"),
            keywords: &["بازیافت", "نماد بازیافت"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kierrätyssymboli"),
            keywords: &["kierrättää", "kierrätys", "kierrätyssymboli"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("simbolo ng pag-recycle"),
            keywords: &["recycle", "simbolo", "simbolo ng pag-recycle"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("endurnýtslasymbol"),
            keywords: &["endurnýtsla", "endurnýtslasymbol"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("symbole Recyclage"),
            keywords: &["recyclage", "symbole Recyclage"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("symbole de recyclage"),
            keywords: &["recyclage", "symbole de recyclage"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("siombail athchúrsála"),
            keywords: &[
                "athchúrsáil",
                "comhartha",
                "siombail athchúrsála",
                "siombal athchúrsala soladach uilíoch",
                "siombal athchúrsála",
                "soladach",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("samhla ath-chuartachaidh"),
            keywords: &[
                "ath-chuairteachadh",
                "ath-chuairtich",
                "samhla ath-chuartachaidh",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("símbolo de reciclaxe"),
            keywords: &["reciclado", "reciclaxe", "símbolo", "símbolo de reciclaxe"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("રિસાયક\u{acd}લિ\u{a82}ગન\u{ac1}\u{a82} પ\u{acd}રતીક"),
            keywords: &[
                "ચિહ\u{acd}ન",
                "નક\u{acd}કર સાર\u{acd}વત\u{acd}રિક રિસાયક\u{acd}લિ\u{a82}ગન\u{ac1}\u{a82} પ\u{acd}રતીક",
                "રિસાયક\u{acd}લિ\u{a82}ગ",
                "રિસાયક\u{acd}લિ\u{a82}ગન\u{ac1}\u{a82} પ\u{acd}રતીક",
                "સાર\u{acd}વત\u{acd}રિક",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("alamar maimaita"),
            keywords: &["alamar maimaita", "maimaita"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("סמל מיחזור"),
            keywords: &["אקולוגיה", "מחזור", "מיחזור", "סביבה", "סמל מיחזור"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some(
                "प\u{941}नर\u{94d}चक\u{94d}रीकरण प\u{94d}रतीक, रीसाइक\u{94d}लि\u{902}ग, व\u{948}श\u{94d}विक, चिह\u{94d}न",
            ),
            keywords: &[
                "चिह\u{94d}न",
                "ठोस व\u{948}श\u{94d}विक प\u{941}नर\u{94d}चक\u{94d}रीकरण प\u{94d}रतीक",
                "प\u{941}नर\u{94d}चक\u{94d}रीकरण प\u{94d}रतीक",
                "प\u{941}नर\u{94d}चक\u{94d}रीकरण प\u{94d}रतीक, रीसाइक\u{94d}लि\u{902}ग, व\u{948}श\u{94d}विक, चिह\u{94d}न",
                "रीसाइक\u{94d}लि\u{902}ग",
                "व\u{948}श\u{94d}विक",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("simbol recikliranja"),
            keywords: &["recikliranje", "simbol recikliranja"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("újrahasznosítás szimbólum"),
            keywords: &["újra", "újrahasznosítás", "újrahasznosítás szimbólum"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("վերամշակման նշան"),
            keywords: &["վերամշակել", "վերամշակման նշան"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("simbol daur ulang"),
            keywords: &["daur ulang", "simbol daur ulang"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("akara mmegharịa"),
            keywords: &["akara mmegharịa", "megharịa"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("endurvinnsla"),
            keywords: &[
                "alþjóðlegt endurvinnslumerki",
                "endurvinnsla",
                "endurvinnslumerki",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("simbolo del riciclaggio"),
            keywords: &[
                "raccolta differenziata",
                "riciclaggio",
                "riciclare",
                "riciclo",
                "simbolo",
                "simbolo del riciclaggio",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("リサイクルマーク"),
            keywords: &["リサイクル", "リサイクルマーク", "再利用", "再生"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("tandha dhaur ulang"),
            keywords: &["dhaur ulang", "tandha dhaur ulang"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("გადამუშავების სიმბოლო"),
            keywords: &["გადამუშავება", "გადამუშავების სიმბოლო"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("қайта өңдеу белгісі"),
            keywords: &["қайта өңдеу", "қайта өңдеу белгісі"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("genbrug"),
            keywords: &["genbrug", "genbrugssymbol"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("សញ\u{17d2}ញាកែច\u{17d2}នៃឡើងវ\u{17b7}ញ"),
            keywords: &[
                "កែច\u{17d2}នៃ",
                "សញ\u{17d2}ញា",
                "សញ\u{17d2}ញាកែច\u{17d2}នៃឡើងវ\u{17b7}ញ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಮರುಬಳಕ\u{cc6}ಯ ಚ\u{cbf}ಹ\u{ccd}ನ\u{cc6}"),
            keywords: &[
                "ಮರುಬಳಕ\u{cc6}",
                "ಮರುಬಳಕ\u{cc6} ಚ\u{cbf}ಹ\u{ccd}ನ\u{cc6}",
                "ಮರುಬಳಕ\u{cc6}ಯ ಚ\u{cbf}ಹ\u{ccd}ನ\u{cc6}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("재활용 표시"),
            keywords: &["재활용", "재활용 표시"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("रिसायकली\u{902}ग चिन\u{94d}न"),
            keywords: &["रिसायकल", "रिसायकली\u{902}ग चिन\u{94d}न"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("кайра иштетүү символу"),
            keywords: &["кайра иштетүү", "кайра иштетүү символу"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Recycling-Zeechen"),
            keywords: &["Recycling-Zeechen", "recyléieren"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ສ\u{eb1}ນຍາລ\u{eb1}ກການນຳກ\u{eb1}ບມາໃຊ\u{ec9}ໃໝ\u{ec8}"),
            keywords: &[
                "ນຳກ\u{eb1}ບມາໃຊ\u{ec9}ໃໝ\u{ec8}",
                "ສ\u{eb1}ນຍາລ\u{eb1}ກການນຳກ\u{eb1}ບມາໃຊ\u{ec9}ໃໝ\u{ec8}",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("perdirbimo simbolis"),
            keywords: &["perdirbimo simbolis", "perdirbti"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("atkritumu pārstrādes simbols"),
            keywords: &["atkritumu pārstrādes simbols", "pārstrāde"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tohu tukurua"),
            keywords: &["tohu tukurua", "tukurua"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("симбол за рециклирање"),
            keywords: &["рециклирање", "симбол за рециклирање"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("റീസൈക\u{d4d}കിൾ ചിഹ\u{d4d}നം"),
            keywords: &["ചിഹ\u{d4d}നം", "റീസൈക\u{d4d}കിൾ"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("дахин боловсруулах тэмдэг"),
            keywords: &["дахин боловсруулах", "дахин боловсруулах тэмдэг"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("रिसायकलि\u{902}गच\u{947} चिन\u{94d}ह"),
            keywords: &["रिसायकल", "रिसायकलि\u{902}गच\u{947} चिन\u{94d}ह"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("simbol kitar semula"),
            keywords: &["kitar semula", "simbol kitar semula"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("simbolu tar-riċiklaġġ"),
            keywords: &["irriċikla", "simbolu tar-riċiklaġġ"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "ထပ\u{103a}တလ\u{1032}လ\u{1032}သ\u{102f}\u{1036}းမ\u{103e}\u{102f} သင\u{103a}\u{1039}ကေတ",
            ),
            keywords: &[
                "ထပ\u{103a}တလ\u{1032}လ\u{1032}သ\u{102f}\u{1036}းစ\u{103d}\u{1032}ခြင\u{103a}း",
                "ထပ\u{103a}တလ\u{1032}လ\u{1032}သ\u{102f}\u{1036}းစ\u{103d}\u{1032}ခြင\u{103a}း သင\u{103a}\u{1039}ကေတ",
                "ထပ\u{103a}တလ\u{1032}လ\u{1032}သ\u{102f}\u{1036}းမ\u{103e}\u{102f} သင\u{103a}\u{1039}ကေတ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("resirkuleringssymbol"),
            keywords: &[
                "resirkulering",
                "resirkuleringssymbol",
                "symbol",
                "universelt",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("रिसाइकलिङ\u{94d}को प\u{94d}रतिक"),
            keywords: &["रिसाइकल", "रिसाइकलिङ\u{94d}को प\u{94d}रतिक"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("recycling-symbool"),
            keywords: &["recycling", "recycling-symbool"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("resirkuleringssymbol"),
            keywords: &[
                "resirkulering",
                "resirkuleringssymbol",
                "symbol",
                "universelt",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ନବୀକରଣ କର\u{b3f}ବ\u{b3e} ସଙ\u{b4d}କେତ"),
            keywords: &[
                "ନବୀକରଣ କର\u{b3f}ବ\u{b3e} ସଙ\u{b4d}କେତ",
                "ର\u{b3f}ସ\u{b3e}ଇକେଲ\u{b4d}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਰੀਸਾਈਕਲਿ\u{a70}ਗ ਚਿ\u{a70}ਨ\u{a4d}ਹ"),
            keywords: &[
                "ਨਿਸ\u{a3c}ਾਨ",
                "ਯ\u{a42}ਨੀਵਰਸਲ",
                "ਰੀਸਾਈਕਲ ਪ\u{a4d}ਰਤੀਕ",
                "ਰੀਸਾਈਕਲਿ\u{a70}ਗ",
                "ਰੀਸਾਈਕਲਿ\u{a70}ਗ ਚਿ\u{a70}ਨ\u{a4d}ਹ",
                "ਸਾਲੀਡ ਯ\u{a42}ਨੀਵਰਸਲ ਰੀਸਾਈਕਲਿ\u{a70}ਗ ਪ\u{a4d}ਰਤੀਕ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("فیر کار آمد بنان دی علامت"),
            keywords: &["فیر کار آمد بنان دی علامت", "فیر کارآمد بنانا"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Risaíkúl Sain"),
            keywords: &["Risaíkul", "Risaíkúl Sain"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("recykling"),
            keywords: &["odpady", "recykling", "surowce wtórne"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د ري سايکلنګ سمبول"),
            keywords: &["د ري سايکلنګ سمبول", "ري سايکل"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("símbolo de reciclagem"),
            keywords: &["reciclagem", "símbolo de reciclagem"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["reciclar", "símbolo de reciclagem"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("allinyachiy unancha"),
            keywords: &["allinyachiy unancha"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("simbolul pentru reciclare"),
            keywords: &["reciclare", "simbolul pentru reciclare"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-081"),
            keywords: &["E10-081"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("утилизация"),
            keywords: &["отходы", "переработка", "переработка отходов", "утилизация"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ikimenyetso cyo kongera gutunganywa"),
            keywords: &["guhindurwa", "ikimenyetso cyo kongera gutunganywa"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ٻيهر استعمال جي نشاني"),
            keywords: &["ٻيهر استعمال جي نشاني", "ٻيهر استعمال ڪرڻ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ප\u{dca}\u{200d}රත\u{dd2}චක\u{dca}\u{200d}ර\u{dd3}කරණ සංකේතය"),
            keywords: &[
                "ප\u{dca}\u{200d}රත\u{dd2}චක\u{dca}\u{200d}ර\u{dd3}කරණ සංකේතය",
                "ප\u{dca}\u{200d}රත\u{dd2}චක\u{dca}\u{200d}ර\u{dd3}කරණය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("symbol recyklácie"),
            keywords: &["recyklovať", "symbol recyklácie"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("simbol za recikliranje"),
            keywords: &["reciklirati", "simbol za recikliranje"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("calaamadda dib-u-warshadaynta"),
            keywords: &["calaamadda dib-u-warshadaynta", "dib-u-warshadee"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("simboli i riciklimit"),
            keywords: &["ricikloj", "simboli i riciklimit"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("симбол за рециклирање"),
            keywords: &["рeциклирaњe", "симбол за рециклирање"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("simbol za recikliranje"),
            keywords: &["recikliranje", "simbol za recikliranje"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("återvinningssymbol"),
            keywords: &["symbol", "återvinning", "återvinningssymbol"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("alama ya kutumia tena"),
            keywords: &["alama ya kutumia tena", "tumia tena"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("மறுசுழற\u{bcd}சி"),
            keywords: &["சின\u{bcd}னம\u{bcd}", "மறுசுழற\u{bcd}சி"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ర\u{c40}స\u{c48}క\u{c4d}ల\u{c3f}ంగ\u{c4d}"),
            keywords: &[
                "పునరుపయ\u{c4b}గం",
                "ర\u{c40}స\u{c48}క\u{c4d}ల\u{c3f}ంగ\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("аломати \"азнавкоркардкунӣ\""),
            keywords: &["аз нав коркард кардан", "аломати \"азнавкоркардкунӣ\""],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ส\u{e31}ญล\u{e31}กษณ\u{e4c}ร\u{e35}ไซเค\u{e34}ล"),
            keywords: &[
                "การร\u{e35}ไซเค\u{e34}ล",
                "ป\u{e49}ายร\u{e35}ไซเค\u{e34}ล",
                "ส\u{e31}ญล\u{e31}กษณ\u{e4c}ร\u{e35}ไซเค\u{e34}ล",
            ],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ኣርማ ረሳይክል"),
            keywords: &["ረሳይክል", "ኣርማ ረሳይክል"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("gaýtadan işlemek nyşany"),
            keywords: &["gaýtadan işlemek", "gaýtadan işlemek nyşany"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("ʻilonga ngāueʻaki foʻou"),
            keywords: &["ngāueʻaki foʻou", "ʻilonga", "ʻilonga ngāueʻaki foʻou"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("geri dönüşüm simgesi"),
            keywords: &[
                "evrensel",
                "geri dönüşüm",
                "geri dönüşüm simgesi",
                "işaret",
                "koyu renk evrensel geri dönüşüm simgesi",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("يىغىپ ئىشلەش بەلگىسى"),
            keywords: &["يىغىپ ئىشلەش", "يىغىپ ئىشلەش بەلگىسى"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("символ утилізації"),
            keywords: &["переробка", "символ утилізації", "утилізація"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ری سائیکلنگ کا نشان"),
            keywords: &["ری سائیکلنگ", "ری سائیکلنگ کا نشان", "نشان"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("qayta ishlash belgisi"),
            keywords: &["qayta ishlash", "qayta ishlash belgisi"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("biểu tượng tái chế"),
            keywords: &["biểu tượng tái chế", "tái chế"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("màndarga defaraat"),
            keywords: &["defaraat", "màndarga defaraat"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("isimboli yokubuyisela kwimo yangaphambili"),
            keywords: &[
                "buyisela kwimo yangaphambili",
                "isimboli yokubuyisela kwimo yangaphambili",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("àmì àtúnrọ"),
            keywords: &["àmì àtúnrọ", "àtúnrọ"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("循環再造符號"),
            keywords: &["循環再造", "循環再造符號"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("循环再造符号"),
            keywords: &["循环再造", "循环再造符号"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("回收标志"),
            keywords: &["再利用", "回收标志", "循环"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("回收"),
            keywords: &["可回收資源", "回收"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["回收", "循環再用", "資源回收"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("uphawu lokuvuselela"),
            keywords: &["uphawu lokuvuselela", "vuselela"],
        },
    ],
};
#[doc = "⚜\u{fe0f}"]
pub const FLEUR_DE_LIS: crate::Emoji = crate::Emoji {
    glyph: "⚜\u{fe0f}",
    codepoint: "269C FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "fleur-de-lis",
    group: "Symbols",
    subgroup: "other-symbol",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "⚜",
        codepoint: "269C",
        status: crate::Status::Unqualified,
        introduction_version: 1f32,
        name: "fleur-de-lis",
        group: "Symbols",
        subgroup: "other-symbol",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("fleur de lis"),
            keywords: &["fleur", "fleur de lis", "lelie"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የማጌጫ ምልክት"),
            keywords: &["የማጌጫ ምልክት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("زنبقة"),
            keywords: &["زنبقة", "زهرة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ফ\u{9cd}ল-দ\u{9cd}য-লি"),
            keywords: &["ফ\u{9cd}ল-দ\u{9cd}য-লি"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("zanbaq"),
            keywords: &["zanbaq"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("геральдычная лілея"),
            keywords: &[
                "Францыя",
                "геральдычная лілея",
                "лілея",
                "флёр-дэ-ліс",
                "эмблема",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("хералдическа лилия"),
            keywords: &["хералдическа лилия"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("প\u{9c1}ষ\u{9cd}পবিশেষ"),
            keywords: &[
                "প\u{9c1}ষ\u{9cd}পবিশেষ",
                "ফ\u{9cd}ল\u{9be}র-ডি-লিস (একধরনের ফ\u{9c1}ল)",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("flourdiliz"),
            keywords: &["flourdiliz"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("ljiljan"),
            keywords: &["ljiljan"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("flor de lis"),
            keywords: &["flor", "flor de lis", "lis"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏥᎳ ᎠᏁᎶᎯ ᎠᏥᎸᏍᎩ"),
            keywords: &["ᎠᏥᎳ ᎠᏁᎶᎯ ᎠᏥᎸᏍᎩ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("heraldická lilie"),
            keywords: &["erb", "heraldická lilie", "lilie"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("gellesgen"),
            keywords: &["gellesgen"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("fransk lilje"),
            keywords: &[
                "fleur-de-lis",
                "fransk lilje",
                "heraldik",
                "heraldisk lilje",
                "lilje",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Lilie"),
            keywords: &["Fleur-de-Lis", "Lilie"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("άνθος του κρίνου"),
            keywords: &[
                "άνθος του κρίνου",
                "έμβλημα",
                "έμβλημα με κρίνο",
                "κρίνο",
                "σύμβολο",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("fleur-de-lis"),
            keywords: &["fleur-de-lis"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("flor de lis"),
            keywords: &["flor", "flor de lis", "lis"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("prantsuse liilia"),
            keywords: &["Bourbonide liilia", "fleur-de-lis", "prantsuse liilia"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("lis-lore"),
            keywords: &["lis-lore"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("نماد گل زنبق"),
            keywords: &["فلور د\u{650} لی", "فلور-د-لی", "نماد گل زنبق"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("Ranskan lilja"),
            keywords: &[
                "Ranskan lilja",
                "fleur-de-lis",
                "heraldinen lilja",
                "lilja",
                "ranskanlilja",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("flordelis"),
            keywords: &["fleur-de-lis", "flordelis"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("liljumynd sum skjaldarmerki"),
            keywords: &[
                "liljumynd",
                "liljumynd sum skjaldarmerki",
                "skjaldarmerki",
                "svørðlilja",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("fleur de lys"),
            keywords: &["fleur de lys"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("fleur-de-lis"),
            keywords: &["fleur-de-lis", "flór de lúis"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("fleur-de-lis"),
            keywords: &["fleur-de-lis"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("flor de lis"),
            keywords: &["flor", "flor de lis", "lis"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ફ\u{acd}લ\u{ac7}ઉર-દ\u{ac7}-લિસ"),
            keywords: &["ફ\u{acd}લ\u{ac7}ઉર-દ\u{ac7}-લિસ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("fleur-de-lis"),
            keywords: &["fleur-de-lis"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("שושן צחור"),
            keywords: &["חבצלת", "מלוכה", "פלר דה ליס", "שושן צחור"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("क\u{941}म\u{941}दिनी का फ\u{942}ल"),
            keywords: &["क\u{941}म\u{941}दिनी का फ\u{942}ल"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("heraldički ljiljan"),
            keywords: &["fleur-de-lis", "heraldički ljiljan"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("Anjou-liliom"),
            keywords: &["Anjou", "Anjou-liliom", "liliom"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("թագավորական շուշան"),
            keywords: &["թագավորական շուշան"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("fleur-de-lis"),
            keywords: &["fleur-de-lis", "tanda"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("fleur-de-lis"),
            keywords: &["fleur-de-lis"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("fleur-de-lis-tákn"),
            keywords: &["fleur-de-lis", "fleur-de-lis-tákn"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("giglio araldico"),
            keywords: &["fiore", "giglio", "giglio araldico", "simbolo", "stemma"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("フルール・ド・リス"),
            keywords: &[
                "エンブレム",
                "フランス王家",
                "フルール・ド・リス",
                "ユリ",
                "紋章",
            ],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("lambang fleur-de-lis [kembang Lili]"),
            keywords: &[
                "lambang fleur-de-lis",
                "lambang fleur-de-lis [kembang Lili]",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ჰერალდიკური შროშანი"),
            keywords: &["შროშანი", "ჰერალდიკური"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("француз лилиясы"),
            keywords: &["лилия", "таңба", "француз лилиясы"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("fransk lilje"),
            keywords: &[
                "fleur-de-lis",
                "fransk lilje",
                "heraldik",
                "heraldisk lilje",
                "lilje",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("សញ\u{17d2}ញារាងដ\u{17bc}ចផ\u{17d2}កាល\u{17b8}ល\u{17b8}"),
            keywords: &[
                "ផ\u{17d2}កា",
                "ផ\u{17d2}កាល\u{17b8}ល\u{17b8}",
                "សញ\u{17d2}ញា",
                "សញ\u{17d2}ញារាងដ\u{17bc}ចផ\u{17d2}កាល\u{17b8}ល\u{17b8}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ನಾಣ\u{ccd}ಯದ ಲ\u{cbf}ಸ\u{ccd}"),
            keywords: &[
                "ನಾಣ\u{ccd}ಯದ ಲ\u{cbf}ಸ\u{ccd}",
                "ಫ\u{ccd}ಲ\u{cbf}ಯರ\u{ccd}-ಡ\u{cbf}-ಲ\u{cbf}ಸ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("백합 문장"),
            keywords: &["문장", "백합"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("फ\u{94d}ल\u{941}र - द\u{947} -लीस"),
            keywords: &[
                "फ\u{94d}ल\u{941}र - द\u{947} -लीस",
                "फ\u{94d}ल\u{941}र -द\u{947} -लीस",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("геральд лилиясы"),
            keywords: &["геральд лилиясы"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Lilie"),
            keywords: &["Lilie"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ດອກໄອລ\u{eb4}ສ"),
            keywords: &["ດອກໄມ\u{ec9}", "ດອກໄອລ\u{eb4}ສ", "ໄອລ\u{eb4}ສ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("lelijos simbolis"),
            keywords: &["lelija", "lelijos simbolis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("lilijas simbols"),
            keywords: &["lilija", "lilijas simbols"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("putiputi rengarenga"),
            keywords: &["putiputi rengarenga"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("трилистен цвет од лилјан"),
            keywords: &["лилјан", "трилистен цвет од лилјан", "цвет"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഫ\u{d4d}ലർ ഡേ ലിസ\u{d4d}"),
            keywords: &["ചിഹ\u{d4d}നം", "ഫ\u{d4d}ലർ ഡേ ലിസ\u{d4d}"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("сараана цэцэг"),
            keywords: &["сараана", "цэцэг"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("फ\u{94d}ल\u{947}उर-द\u{947}-लिस"),
            keywords: &["फ\u{94d}ल\u{947}उर-द\u{947}-लिस"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("fleur-de-lis"),
            keywords: &["fleur-de-lis"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("fleur-de-lis"),
            keywords: &["fleur-de-lis"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("န\u{103e}င\u{103a}းပန\u{103a}းပ\u{102f}\u{1036}စ\u{1036}"),
            keywords: &[
                "န\u{103e}င\u{103a}းပန\u{103a}း",
                "န\u{103e}င\u{103a}းပန\u{103a}းပ\u{102f}\u{1036}စ\u{1036}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("fransk lilje"),
            keywords: &["fleur-de-lis", "fransk lilje"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("फ\u{94d}लिउर-ड\u{947}-लिस"),
            keywords: &["फ\u{94d}लिउर-ड\u{947}-लिस"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("fleur de lis"),
            keywords: &["fleur de lis", "franse lelie"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("fransk lilje"),
            keywords: &["fleur-de-lis", "fransk lilje"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଫ\u{b4d}ଲ\u{b3f}ଉର\u{b4d}\u{200c}-ଡ\u{b3f}-ଲ\u{b3f}ସ\u{b4d}\u{200c}"),
            keywords: &["ଫ\u{b4d}ଲ\u{b3f}ଉର\u{b4d}\u{200c}-ଡ\u{b3f}-ଲ\u{b3f}ସ\u{b4d}\u{200c}"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਕਮ\u{a41}ਦਿਨੀ ਦਾ ਫ\u{a41}\u{a71}ਲ"),
            keywords: &["ਕਮ\u{a41}ਦਿਨੀ ਦਾ ਫ\u{a41}\u{a71}ਲ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("فرانس دا شاہی نشان"),
            keywords: &["فرانس دا شاہی نشان"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Flẹ\u{301}-De-Lis"),
            keywords: &["Flẹ\u{301}-De-Lis"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("lilijka"),
            keywords: &["harcerze", "lilijka"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("فليور دي لوس"),
            keywords: &["فليور دي لوس"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("flor-de-lis"),
            keywords: &["flor-de-lis", "símbolo"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["fleur-de-lis", "flor-de-lis"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("flor de lis"),
            keywords: &["flor de lis"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("floare de crin stilizată"),
            keywords: &[
                "Franța",
                "crin",
                "fleur de lis",
                "floare de crin stilizată",
                "regalitate",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-091"),
            keywords: &["E10-091"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("геральдическая лилия"),
            keywords: &[
                "геральдика",
                "геральдическая лилия",
                "герб",
                "лилия",
                "фигура",
                "флер-де-лис",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ururabo rwa lili"),
            keywords: &["ururabo rwa lili"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("للي جو گل"),
            keywords: &["للي جو گل"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ප\u{dca}\u{200d}රංශයේ ර\u{dcf}ජ\u{dca}\u{200d}ය සලක\u{dd4}ණ"),
            keywords: &["ප\u{dca}\u{200d}රංශයේ ර\u{dcf}ජ\u{dca}\u{200d}ය සලක\u{dd4}ණ"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("heraldický symbol ľalie"),
            keywords: &["heraldický symbol ľalie", "ľalia"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("lilija"),
            keywords: &["lilija"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("saddex midnimada quduuska"),
            keywords: &["saddex midnimada quduuska"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("shpatore"),
            keywords: &["shpatore", "simbol"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("љиљан"),
            keywords: &["љиљан"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("ljiljan"),
            keywords: &["ljiljan"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("fransk lilja"),
            keywords: &["fleur de lys", "fransk lilja", "heraldisk lilja"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("ua la yungi"),
            keywords: &["ua la yungi", "yungiyungi"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பூ"),
            keywords: &["பூ"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ఫ\u{c4d}లూర\u{c4d} డ\u{c3f}-ల\u{c3f}స\u{c4d}"),
            keywords: &[
                "కలువ",
                "పువ\u{c4d}వు",
                "ఫ\u{c4d}లూర\u{c4d} డ\u{c3f}-ల\u{c3f}స\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("савсан"),
            keywords: &["савсан"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ส\u{e31}ญล\u{e31}กษณ\u{e4c}ดอกล\u{e34}ลล\u{e35}\u{e48}"),
            keywords: &[
                "ดอกล\u{e34}ลล\u{e35}\u{e48}",
                "ดอกไม\u{e49}",
                "ดอกไอร\u{e34}ส",
                "ล\u{e34}ลล\u{e35}\u{e48}",
                "ส\u{e31}ญล\u{e31}กษณ\u{e4c}ดอกล\u{e34}ลล\u{e35}\u{e48}",
            ],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("fleur-de-lis"),
            keywords: &["fleur-de-lis"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("iris"),
            keywords: &["iris"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("ʻilonga lile"),
            keywords: &["Falanisē", "lile", "ʻilonga"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("zambak"),
            keywords: &["fleur-de-lis", "zambak"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("نەقىش"),
            keywords: &["نەقىش"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("геральдична лілія"),
            keywords: &["геральдична лілія"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("تین پتیوں والا للی"),
            keywords: &["آسٹریلیا", "تین", "تین پتیوں والا للی", "پتیاں", "پھول"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("gulsapsar"),
            keywords: &["gulsapsar"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("hoa diên vĩ"),
            keywords: &["hoa bách hợp", "hoa diên vĩ"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("flëru-lis"),
            keywords: &["flëru-lis"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("i-fleur-de-lis"),
            keywords: &["i-fleur-de-lis"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("fleur-de-lis"),
            keywords: &["fleur-de-lis"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("鳶尾花"),
            keywords: &["鳶尾花"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("鸢尾花"),
            keywords: &["鸢尾花"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("百合花饰"),
            keywords: &["百合花饰", "鸢尾花"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("鳶尾花"),
            keywords: &["鳶尾花"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("i-fleur-de-lis"),
            keywords: &["i-fleur-de-lis"],
        },
    ],
};
#[doc = "🔱"]
pub const TRIDENT_EMBLEM: crate::Emoji = crate::Emoji {
    glyph: "🔱",
    codepoint: "1F531",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "trident emblem",
    group: "Symbols",
    subgroup: "other-symbol",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("drietandvurkembleem"),
            keywords: &[
                "anker",
                "drie",
                "drietandvurkembleem",
                "embleem",
                "skip",
                "vurk",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ትሪደንት አርማ"),
            keywords: &["መልህቅ", "መሣሪያ", "መርከብ", "ትሪደንት", "አርማ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("رمز ثلاثي الشعب"),
            keywords: &["رمز ثلاثي الشعب", "شعار", "مرساة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ত\u{9cd}ৰিশ\u{9c2}ল প\u{9cd}ৰতীক"),
            keywords: &[
                "জ\u{9be}হ\u{9be}জ",
                "ত\u{9cd}ৰিশ\u{9c2}ল",
                "প\u{9cd}ৰতীক",
                "লংগৰ",
                "স\u{981}জ\u{9c1}লি",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("üçdiş emblem"),
            keywords: &["alət", "emblem", "gəmi", "lövbər", "üçdiş"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("трызубец"),
            keywords: &["карабель", "сімвал", "трызубец", "эмблема", "якар"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("тризъбец"),
            keywords: &["емблема", "инструмент", "тризъбец"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ত\u{9cd}রিশ\u{9c2}ল প\u{9cd}রতীক"),
            keywords: &[
                "জ\u{9be}হ\u{9be}জ",
                "ত\u{9cd}রিশ\u{9c2}ল",
                "নোঙ\u{9cd}গর",
                "প\u{9cd}রতীক",
                "সরঞ\u{9cd}জ\u{9be}ম",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("tridant"),
            keywords: &["bag", "benveg", "eor", "lestr", "tridant"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("trozubac amblem"),
            keywords: &["brod", "emblem", "sidro", "trozubac", "trozubac amblem"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("marca de trident"),
            keywords: &["marca", "marca de trident", "trident", "àncora"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏴᎩ ᏓᏟᎶᏍᏛ"),
            keywords: &["ᎤᏙᏪᎸᎢ", "ᎬᏔᏂᏓᏍᏗ", "ᏗᎦᏃᏣᎵᏍᎩ", "ᏥᏳ", "ᏴᎩ", "ᏴᎩ ᏓᏟᎶᏍᏛ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("emblém trojzubce"),
            keywords: &[
                "emblém",
                "emblém trojzubce",
                "kotva",
                "loď",
                "nástroj",
                "trojzubec",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("arwyddlun tryfer"),
            keywords: &["angor", "arwyddlun", "llong", "tryfer"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("trefork"),
            keywords: &["trefork", "trefork-symbol"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Dreizack"),
            keywords: &["Anker", "Dreizack", "Triton"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("έμβλημα τρίαινας"),
            keywords: &[
                "άγκυρα",
                "έμβλημα",
                "έμβλημα τρίαινας",
                "εργαλείο",
                "πλοίο",
                "τρίαινα",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("trident emblem"),
            keywords: &["anchor", "emblem", "ship", "tool", "trident"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("emblema de tridente"),
            keywords: &["ancla", "emblema", "emblema de tridente", "tridente"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &[
                "barco",
                "emblema",
                "emblema de tridente",
                "navegación",
                "neptuno",
                "tridente",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kolmhargi sümbol"),
            keywords: &["ankur", "embleem", "kolmhargi sümbol", "kolmhark", "laev"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("hiruhortza"),
            keywords: &["aingura", "enblema", "hiruhortza", "itsasontzia", "tresna"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("نیزه\u{654} سه\u{200c}شاخه"),
            keywords: &[
                "ابزار",
                "سه\u{200c}شاخه",
                "لنگر",
                "نیزه",
                "نیزه\u{654} سه\u{200c}شاخه",
                "کشتی",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kolmikärki"),
            keywords: &["ankkuri", "atrain", "kolme", "kolmikärki", "laiva", "meri"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("trident emblem"),
            keywords: &["anchor", "angkla", "emblem", "sibat", "trident"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("trítindað kvísl"),
            keywords: &[
                "Poseidon",
                "kvísl",
                "trítindakvísl",
                "trítindað kvísl",
                "trítindur",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("trident"),
            keywords: &["ancre", "bateau", "trident"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("comhartha trírinne"),
            keywords: &["comhartha trírinne", "trírinn"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("samhla muirgheidh"),
            keywords: &[
                "acainn",
                "acair",
                "inneal",
                "long",
                "muirgheadh",
                "samhla muirgheidh",
                "suaicheantas",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("emblema de tridente"),
            keywords: &["emblema", "emblema de tridente", "tridente", "áncora"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ત\u{acd}રિશ\u{ac2}ળન\u{ac1}\u{a82} ચિહ\u{acd}ન"),
            keywords: &[
                "એ\u{a82}કર",
                "ત\u{acd}રિશ\u{ac2}ળ",
                "ત\u{acd}રિશ\u{ac2}ળન\u{ac1}\u{a82} ચિહ\u{acd}ન",
                "સ\u{a82}જ\u{acd}ઞા",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("alamar mashi mai ƙarshe uku"),
            keywords: &[
                "alama",
                "alamar mashi mai ƙarshe uku",
                "jirgin ruwa",
                "kayan aiki",
                "mashi mai ƙarshe uku",
                "ƙugiya",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("סמל קילשון"),
            keywords: &["סמל", "ספינה", "עוגן", "קילשון"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("त\u{94d}रिश\u{942}ल का चिह\u{94d}न"),
            keywords: &[
                "ए\u{902}कर",
                "त\u{94d}रिश\u{942}ल",
                "त\u{94d}रिश\u{942}ल का चिह\u{94d}न",
                "त\u{94d}रिश\u{942}ल का चिह\u{94d}न, ए\u{902}कर",
                "प\u{94d}रतीक",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("znak trozupca"),
            keywords: &["alat", "brod", "grb", "sidro", "trozubac", "znak trozupca"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("háromágú szigony"),
            keywords: &[
                "embléma",
                "hajó",
                "háromágú szigony",
                "jel",
                "szigony",
                "vasmacska",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("եռաժանի խորհրդանշան"),
            keywords: &[
                "գործիք",
                "եռաժանի",
                "եռաժանի խորհրդանշան",
                "զինանշան",
                "խարիսխ",
                "նավ",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("emblem trisula"),
            keywords: &["alat", "emblem", "jangkar", "kapal", "trisula"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ihe mmado ube akụkụ atọ"),
            keywords: &[
                "anchor",
                "ihe mmado",
                "ihe mmado ube akụkụ atọ",
                "ngwaọrụ",
                "ube akụkụ atọ",
                "ụgbọmmiri",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("þríforkur"),
            keywords: &["akkeri", "skip", "tákn", "tól", "þríforkur"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("tridente"),
            keywords: &["ancora", "simbolo tridente", "tridente"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("トライデント"),
            keywords: &["エンブレム", "トライデント", "三つ又", "海"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("lambang trisula"),
            keywords: &[
                "emblem",
                "jangkar",
                "kapal",
                "lambang trisula",
                "pranti",
                "trisula",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("სამკბილა ემბლემა"),
            keywords: &[
                "გემი",
                "ემბლემა",
                "ინსტრუმენტი",
                "სამკბილა",
                "ღუზა",
                "ხელსაწყო",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("үш ашалы айыр белгісі"),
            keywords: &[
                "зәкір",
                "кеме",
                "нышан",
                "құрал",
                "үш ашалы",
                "үш ашалы айыр белгісі",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("trefork"),
            keywords: &["trefork", "trefork-symbol"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("សញ\u{17d2}ញាដ\u{17bc}ចល\u{17c6}ពែងម\u{17bb}ខប\u{17b8}"),
            keywords: &[
                "ម\u{17bb}ខប\u{17b8}",
                "ល\u{17c6}ពែង",
                "សញ\u{17d2}ញា",
                "សញ\u{17d2}ញាដ\u{17bc}ចល\u{17c6}ពែងម\u{17bb}ខប\u{17b8}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ತ\u{ccd}ರ\u{cbf}ಶ\u{cc2}ಲ ಸಂಕೇತ"),
            keywords: &[
                "ತ\u{ccd}ರ\u{cbf}ಶ\u{cc2}ಲ",
                "ತ\u{ccd}ರ\u{cbf}ಶ\u{cc2}ಲ ಸಂಕೇತ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("삼지창"),
            keywords: &["삼지창", "창"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("त\u{94d}रिश\u{942}ळ चिन\u{94d}न"),
            keywords: &[
                "चिन\u{94d}न",
                "जहाज",
                "त\u{94d}रिश\u{942}ळ",
                "ना\u{902}गर",
                "साधन",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("үч тиштүү эмблема"),
            keywords: &["кеме", "курал", "эмблема", "үч тиштүү эмблема"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Dräizack"),
            keywords: &[
                "Anker",
                "Dräizack",
                "Handwierksgeschir",
                "Ofzeechen",
                "Schëff",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ສະໝ\u{ecd}ສາມງ\u{ec8}າມ"),
            keywords: &[
                "ສະໝ\u{ecd}",
                "ສະໝ\u{ecd}ສາມງ\u{ec8}າມ",
                "ເຄ\u{eb7}\u{ec8}ອງມ\u{eb7}",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("trišakė emblema"),
            keywords: &[
                "emblema",
                "inkaras",
                "laivas",
                "trišakis",
                "trišakė emblema",
                "įrankis",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("trijzaris"),
            keywords: &["enkurs", "kuģis", "trijzaris"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tohu mārau"),
            keywords: &["mārau", "punga", "tohu", "utauta", "waipuke"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("трозабец"),
            keywords: &["амблем", "брод", "сидро", "трозабец"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ത\u{d4d}രിശ\u{d42}ല ചിഹ\u{d4d}നം"),
            keywords: &[
                "ത\u{d4d}രിശ\u{d42}ല ചിഹ\u{d4d}നം",
                "ത\u{d4d}രിശ\u{d42}ലം",
                "നങ\u{d4d}ക\u{d42}രം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("лусын хааны сэрээ"),
            keywords: &[
                "багаж",
                "зангуу",
                "лусын хааны сэрээ",
                "сэрээ",
                "сүлд",
                "усан онгоц",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("त\u{94d}रिश\u{941}ळाच\u{947} चिन\u{94d}ह"),
            keywords: &[
                "अ\u{901}कर",
                "त\u{94d}रिश\u{941}ळाच\u{947} चिन\u{94d}ह",
                "त\u{94d}रिश\u{942}ळ",
                "त\u{94d}रिश\u{942}ळाची निशाणी",
                "निशाणी",
                "पाठवण\u{947}",
                "साधन",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("lambang trisula"),
            keywords: &["alat", "kapal", "lambang", "sauh", "trisula"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("emblema trident"),
            keywords: &["ankra", "bastiment", "emblema", "għodda", "trident"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("တြ\u{102d}ဒဏ\u{1039}ဍ တ\u{1036}ဆ\u{102d}ပ\u{103a}"),
            keywords: &[
                "ကျောက\u{103a}ဆ\u{1030}း",
                "တြ\u{102d}ဒဏ\u{1039}ဍ",
                "တြ\u{102d}ဒဏ\u{1039}ဍ တ\u{1036}ဆ\u{102d}ပ\u{103a}",
                "သင\u{103a}\u{1039}ဘော",
                "အမ\u{103e}တ\u{103a}တ\u{1036}ဆ\u{102d}ပ\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("treforkemblem"),
            keywords: &[
                "anker",
                "emblem",
                "treenighet",
                "trefork",
                "treforkemblem",
                "tridentsymbol",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("ट\u{94d}रिड\u{947}न\u{94d}ट राजचिन\u{94d}ह"),
            keywords: &[
                "उद\u{94d}घोषक",
                "उपकरण",
                "ट\u{94d}रिड\u{947}न\u{94d}ट",
                "ट\u{94d}रिड\u{947}न\u{94d}ट राजचिन\u{94d}ह",
                "ड\u{941}ङ\u{94d}गा",
                "प\u{94d}रतिक",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("drietand-symbool"),
            keywords: &[
                "anker",
                "drietand",
                "drietand-symbool",
                "embleem",
                "gereedschap",
                "schip",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("treforkemblem"),
            keywords: &[
                "anker",
                "emblem",
                "treeining",
                "trefork",
                "treforkemblem",
                "tridentsymbol",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ତ\u{b4d}ର\u{b3f}ଶ\u{b42}ଳ ପ\u{b4d}ରତୀକ"),
            keywords: &[
                "ଆଙ\u{b4d}କର\u{b4d}\u{200c}",
                "ଜ\u{b3e}ହ\u{b3e}ଜ",
                "ତ\u{b4d}ର\u{b3f}ଶ\u{b42}ଳ",
                "ପ\u{b4d}ରତୀକ",
                "ଯନ\u{b4d}ତ\u{b4d}ରପ\u{b3e}ତ\u{b3f}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਤਿਰਸ\u{a3c}\u{a42}ਲ"),
            keywords: &[
                "ਤਿਰਸ\u{a3c}\u{a42}ਲ",
                "ਤਿਰਸ\u{a3c}\u{a42}ਲ ਦਾ ਨਿਸ\u{a3c}ਾਨ",
                "ਤਿਰਸ\u{a42}ਲ ਨਿਸ\u{a3c}ਾਨ",
                "ਨਿਸ\u{a3c}ਾਨ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ت\u{64e}رش\u{64f}ول دا نشان"),
            keywords: &[
                "اوزار",
                "بحری-جہاز",
                "ت\u{64e}رش\u{64f}ول دا نشان",
                "سہ شاخہ نیزا",
                "شبیہ",
                "لنگر",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Traidẹ\u{301}nt Sain"),
            keywords: &[
                "Hẹ\u{301}ví Áyọ\u{301}n Huk Wé De Hól Ship Fọ Wọ\u{301}n Ples Ínsaíd Wọtá",
                "Sain",
                "Ship",
                "Spia Wé Gẹ\u{301}t Tírí Maut",
                "Traidẹ\u{301}nt Sain",
                "Traídẹnt",
                "Tul",
                "Ánkọ",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("emblemat z trójzębem"),
            keywords: &[
                "emblemat",
                "emblemat z trójzębem",
                "kotwica",
                "okręt",
                "statek",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د درې غاښۍ نښه"),
            keywords: &["اله", "بادبان", "بېړۍ", "د درې غاښۍ نښه", "درې غاښۍ", "نښه"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("emblema de tridente"),
            keywords: &[
                "emblema",
                "emblema de tridente",
                "ferramenta",
                "navio",
                "tridente",
                "âncora",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &[
                "emblema",
                "emblema de tridente",
                "navio",
                "tridente",
                "âncora",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("tridente unancha"),
            keywords: &["ancla", "llamkana", "tridente", "unancha", "wamp’u"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("emblemă trident"),
            keywords: &[
                "corabie",
                "emblemă trident",
                "furcă",
                "instrument",
                "maritim",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-749"),
            keywords: &["E10-749"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("трезубец"),
            keywords: &["символ", "трезубец", "эмблема"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("tirida"),
            keywords: &[
                "igikoresho",
                "ikirango",
                "inanga",
                "majagu",
                "tirida",
                "ubwato",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ترشول جو نشان"),
            keywords: &[
                "اوزار",
                "ترشول",
                "ترشول جو نشان",
                "لنگر",
                "مونوگرام",
                "ٻيڙي",
            ],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ත\u{dca}\u{200d}ර\u{dd2}ශ\u{dd6}ලය"),
            keywords: &[
                "ත\u{dca}\u{200d}ර\u{dd2}ශ\u{dd6}ලය",
                "නැංග\u{dd4}රම",
                "නැව",
                "මෙවලම",
                "ල\u{dcf}ංඡනය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("emblém trojzubca"),
            keywords: &[
                "emblém",
                "emblém trojzubca",
                "kotva",
                "loď",
                "nástroj",
                "trojzubec",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("trizobo znamenje"),
            keywords: &[
                "ladja",
                "orodje",
                "sidro",
                "trizob",
                "trizobo znamenje",
                "znamenje",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("astaanta garab"),
            keywords: &[
                "astaan",
                "astaanta garab",
                "baroosiin",
                "garab",
                "markab",
                "qalab",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("emblemë e fuzhnjës tredhëmbëshe"),
            keywords: &[
                "anije",
                "emblemë",
                "emblemë e fuzhnjës tredhëmbëshe",
                "fuzhnjë tredhëmbëshe",
                "vegël",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("амблем трозупца"),
            keywords: &[
                "aлaт",
                "амблем",
                "амблем трозупца",
                "брoд",
                "сидрo",
                "трoзубaц",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("amblem trozupca"),
            keywords: &[
                "alat",
                "amblem",
                "amblem trozupca",
                "brod",
                "sidro",
                "trozubac",
            ],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("treudd"),
            keywords: &["hav", "treudd"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("nembo ya ncha tatu"),
            keywords: &[
                "meli",
                "mkuki wa vyembe vitatu",
                "nanga",
                "nembo",
                "nembo ya chusa chenye ncha tatu",
                "nembo ya ncha tatu",
                "zana",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("திரிசூலம\u{bcd}"),
            keywords: &[
                "இலச\u{bcd}சினை",
                "சின\u{bcd}னம\u{bcd}",
                "சூலம\u{bcd}",
                "திரிசூலம\u{bcd}",
                "நங\u{bcd}கூரம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("త\u{c4d}ర\u{c3f}శూల చ\u{c3f}హ\u{c4d}నం"),
            keywords: &[
                "త\u{c4d}ర\u{c3f}శూల చ\u{c3f}హ\u{c4d}నం",
                "త\u{c4d}ర\u{c3f}శూలం చ\u{c3f}హ\u{c4d}నం",
                "పంగలకర\u{c4d}ర గుర\u{c4d}తు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("нишони Соскан"),
            keywords: &[
                "асбоб",
                "киштӣ",
                "лангар",
                "нишон",
                "нишони Соскан",
                "соскан",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ฉมวก"),
            keywords: &[
                "ฉมวก",
                "ตรา",
                "สมอ",
                "สามง\u{e48}าม",
                "เคร\u{e37}\u{e48}องม\u{e37}อ",
                "เร\u{e37}อ",
            ],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ኣርማ ትሪደንት"),
            keywords: &["መልህቕ", "መርክብ", "መሳርሒ", "ትሪደንት", "ኣርማ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("üçdiş emblemasy"),
            keywords: &[
                "emblema",
                "gural",
                "gämi",
                "labyr",
                "üç dişli",
                "üçdiş emblemasy",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tao matatolu"),
            keywords: &["matatolu", "tahi", "tao"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("üçlü çatal işareti"),
            keywords: &["amblem", "çıpa", "üçlü çatal", "üçlü çatal işareti"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئارا بەلگە"),
            keywords: &["ئارا", "بەلگە", "قورال", "كېمە", "لەڭگەر"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("тризуб"),
            keywords: &["емблема", "корабель", "тризуб", "якір", "інструмент"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("سہ شاخہ آلہ"),
            keywords: &["آلہ", "اینکر", "بحری جہاز", "سہ شاخہ آلہ", "علامت"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("uch shoxli nayza"),
            keywords: &[
                "kema",
                "langar",
                "nishon",
                "uch shoxli nayza",
                "uch tishli nayza",
                "uskuna",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("biểu tượng đinh ba"),
            keywords: &[
                "biểu tượng",
                "biểu tượng đinh ba",
                "công cụ",
                "neo",
                "tàu",
                "đinh ba",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("xeeju ñatti bopp"),
            keywords: &[
                "bato",
                "jumtukaay",
                "raaya",
                "serukaay",
                "xeeju ñatti bopp",
                "ñatti-fett",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("umfuziselo womkhonto oneencam ezintathu"),
            keywords: &[
                "iankile",
                "inqanawa",
                "isixhobo",
                "umfuziselo",
                "umfuziselo womkhonto oneencam ezintathu",
                "umkhonto oneencam ezintathu",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("aami apẹẹrẹ trident"),
            keywords: &[
                "aami apẹẹrẹ trident",
                "irinṣé\u{329}",
                "tírídẹ\u{300}ntì",
                "ìdákọ\u{300}ró",
                "ẹ\u{300}mbé\u{329}ẹ\u{300}mù",
                "ọkọ\u{300}",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("三叉戟徽章"),
            keywords: &["三叉戟", "三叉戟徽章", "工具", "徽章", "船", "錨"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("三叉戟徽章"),
            keywords: &["三叉戟", "三叉戟徽章", "工具", "徽章", "船", "锚"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("三叉戟徽章"),
            keywords: &["三叉戟徽章", "工具", "船", "锚"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("三叉戟"),
            keywords: &["三叉戟"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("uphawu lwensika"),
            keywords: &[
                "insika",
                "ithuluzi",
                "umkhumbi",
                "uphawu",
                "uphawu lwensika",
            ],
        },
    ],
};
#[doc = "📛"]
pub const NAME_BADGE: crate::Emoji = crate::Emoji {
    glyph: "📛",
    codepoint: "1F4DB",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "name badge",
    group: "Symbols",
    subgroup: "other-symbol",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("naametiket"),
            keywords: &["etiket", "naam", "naametiket"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የስም መለያ"),
            keywords: &["ስም", "የስም መለያ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("ملصق اسم"),
            keywords: &["اسم", "ملصق"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ন\u{9be}ম বেজ"),
            keywords: &["ন\u{9be}ম", "বেজ"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("ad nişanı"),
            keywords: &["ad", "ad nişanı", "nişan"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("бэйдж з імем"),
            keywords: &["бэйдж", "бэйдж з імем", "бірка", "імя"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("бадж"),
            keywords: &["бадж", "име", "табелка"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ন\u{9be}মের ব\u{9cd}য\u{9be}জ"),
            keywords: &[
                "ন\u{9be}ম",
                "ন\u{9be}মের ব\u{9cd}য\u{9be}জ",
                "ব\u{9cd}য\u{9be}জ",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("badj-anv"),
            keywords: &["anv", "badj", "badj-anv"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("značka za ime"),
            keywords: &["ime", "značka", "značka za ime"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("etiqueta identificadora"),
            keywords: &["etiqueta", "etiqueta identificadora", "identificació"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏙᏙᎥᎢ ᎦᏗ"),
            keywords: &["ᎠᎧᏁᏍᏗ", "ᏙᏙᎥᎢ", "ᏙᏙᎥᎢ ᎦᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("jmenovka"),
            keywords: &["cedulka", "jmenovka", "jméno"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("bathodyn enw"),
            keywords: &["bathodyn", "enw"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("navneskilt"),
            keywords: &["navn", "navneskilt", "skilt"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Namensschild"),
            keywords: &["Namensschild", "Schild"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ταμπέλα ονόματος"),
            keywords: &["κάρτα με όνομα", "σήμα", "ταμπέλα ονόματος", "όνομα"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("name badge"),
            keywords: &["badge", "name"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("etiqueta identificativa"),
            keywords: &["etiqueta", "etiqueta identificativa", "nombre"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("identificación con nombre"),
            keywords: &[
                "identificación",
                "identificación con nombre",
                "nombre",
                "prendedor",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("gafete"),
            keywords: &["gafete"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("nimesilt"),
            keywords: &["märk", "nimesilt", "nimi"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("izen-bereizgarria"),
            keywords: &["bereizgarri", "izen", "izen-bereizgarria"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("برچسب نام"),
            keywords: &["برچسب", "نام"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("nimikyltti"),
            keywords: &["kyltti", "lappu", "nimi", "nimikyltti"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("badge ng pangalan"),
            keywords: &["badge", "badge ng pangalan", "pangalan"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("navnaspjaldur"),
            keywords: &["navn", "navnaspjaldur", "spjaldur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("badge nominatif"),
            keywords: &["badge", "badge nominatif", "nom"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("suaitheantas ainm"),
            keywords: &["ainm", "suaitheantas ainm"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("baidse ainm"),
            keywords: &["ainm", "baidse"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("tarxeta identificativa"),
            keywords: &[
                "etiqueta",
                "identificación",
                "nome",
                "tarxeta",
                "tarxeta identificativa",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("નામનો બ\u{ac7}જ"),
            keywords: &["નામ", "નામનો બ\u{ac7}જ", "બ\u{ac7}જ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("bajon suna"),
            keywords: &["bajo", "bajon suna", "suna"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("תג שם"),
            keywords: &["שם", "תג"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("नाम ब\u{948}ज, ब\u{948}ज"),
            keywords: &[
                "नाम",
                "नाम ब\u{948}ज, ब\u{948}ज",
                "बिल\u{94d}ला",
                "ब\u{948}ज",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("bedž s imenom"),
            keywords: &["bedž", "bedž s imenom", "ime"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("kitűző"),
            keywords: &["jelvény", "kitűző", "név"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("բեյջ"),
            keywords: &["անուն", "բեյջ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("lencana nama"),
            keywords: &["lencana", "nama"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("aha baajị"),
            keywords: &["aha", "baajị"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("nafnspjald"),
            keywords: &["nafn", "nafnspjald", "spjald"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("tesserino per nome"),
            keywords: &["nome", "tesserino", "tesserino per nome"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("名札"),
            keywords: &["保育園", "保育所", "名札", "幼稚園"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("emblem jeneng"),
            keywords: &["emblem", "jeneng"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("სახელიანი ბეჯი"),
            keywords: &["ბეჯი", "სახელი", "სახელიანი ბეჯი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("ат бейджигі"),
            keywords: &["ат бейджигі", "аты", "бейджик"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("navneskilt"),
            keywords: &["navn", "navneskilt", "skilt"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("សញ\u{17d2}ញាស\u{17d2}លាកឈ\u{17d2}មោះ"),
            keywords: &[
                "ឈ\u{17d2}មោះ",
                "សញ\u{17d2}ញាស\u{17d2}លាកឈ\u{17d2}មោះ",
                "ស\u{17d2}លាក",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಹ\u{cc6}ಸರ\u{cbf}ನ ಬ\u{ccd}ಯಾಡ\u{ccd}ಜ\u{ccd}"),
            keywords: &[
                "ಬ\u{ccd}ಯಾಡ\u{ccd}ಜ\u{ccd}",
                "ಹ\u{cc6}ಸರ\u{cbf}ನ ಬ\u{ccd}ಯಾಡ\u{ccd}ಜ\u{ccd}",
                "ಹ\u{cc6}ಸರು",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("이름표"),
            keywords: &["명찰", "이름표"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("ना\u{902}वाचो बिल\u{94d}लो"),
            keywords: &["ना\u{902}व", "ना\u{902}वाचो बिल\u{94d}लो", "बिल\u{94d}लो"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("ысым бейджиги"),
            keywords: &["бейджик", "ысым", "ысым бейджиги"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Nummschëld"),
            keywords: &["Numm", "Nummschëld", "Schëld"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ປ\u{ec9}າຍຊ\u{eb7}\u{ec8}"),
            keywords: &["ຊ\u{eb7}\u{ec8}", "ປ\u{ec9}າຍ", "ປ\u{ec9}າຍຊ\u{eb7}\u{ec8}"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("vardo ženklelis"),
            keywords: &["vardas", "vardo ženklelis", "ženklelis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("vārda nozīmīte"),
            keywords: &["nozīmīte", "vārda nozīmīte", "vārds"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tohu ingoa"),
            keywords: &["ingoa", "tohu"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("значка со име"),
            keywords: &["беџ", "значка со име", "име"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("നെയിം ബ\u{d3e}ഡ\u{d4d}ജ\u{d4d}"),
            keywords: &["നെയിം", "ബ\u{d3e}ഡ\u{d4d}ജ\u{d4d}"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("нэрийн тэмдэг"),
            keywords: &["нэр", "нэрийн тэмдэг"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("नावाचा ब\u{945}ज"),
            keywords: &["नाव", "नावाचा ब\u{945}ज", "ब\u{945}ज"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("lencana nama"),
            keywords: &["lencana", "nama"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("beġġ bl-isem"),
            keywords: &["beġġ", "beġġ bl-isem", "isem"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အမည\u{103a} တ\u{1036}ဆ\u{102d}ပ\u{103a}"),
            keywords: &[
                "တ\u{1036}ဆ\u{102d}ပ\u{103a}",
                "နာမည\u{103a}",
                "အမည\u{103a} တ\u{1036}ဆ\u{102d}ပ\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("navneskilt"),
            keywords: &["navn", "navneskilt", "skilt"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("नामको ब\u{94d}याड\u{94d}ज"),
            keywords: &["नाम", "नामको ब\u{94d}याड\u{94d}ज", "ब\u{94d}याड\u{94d}ज"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("naamkaartje"),
            keywords: &["kaartje", "naam", "naamkaartje"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("namneskilt"),
            keywords: &["namn", "namneskilt", "skilt"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ନ\u{b3e}ମ ବ\u{b4d}ୟ\u{b3e}ଜ\u{b4d}\u{200c}"),
            keywords: &["ନ\u{b3e}ମ", "ବ\u{b4d}ୟ\u{b3e}ଜ\u{b4d}"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਨਾਉ\u{a02} ਵਾਲਾ ਬਿ\u{a71}ਲਾ"),
            keywords: &[
                "ਨਾਉ\u{a02} ਵਾਲਾ ਬਿ\u{a71}ਲਾ",
                "ਨਾਮ",
                "ਨਾਮ ਦਾ ਬ\u{a48}ਜ",
                "ਬ\u{a48}ਜ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ناں دا بیج"),
            keywords: &["بیج", "ناں", "ناں دا بیج"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Ném Baj"),
            keywords: &["Baj", "Nem", "Ném Baj"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("plakietka"),
            keywords: &["plakietka", "z imieniem"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("نوم بیج"),
            keywords: &["بيج", "نوم", "نوم بیج"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("crachá"),
            keywords: &["crachá", "identificação", "nome"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("dístico"),
            keywords: &["dístico", "nome"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("nina rawra"),
            keywords: &["nina", "rawra"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("ecuson cu nume"),
            keywords: &["ecuson", "ecuson cu nume", "legitimație", "nume"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-664"),
            keywords: &["E10-664"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("бейдж"),
            keywords: &["бейдж", "бейджик", "значок", "значок с именем", "имя"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ibaje ndangazina"),
            keywords: &["ibaje ndangazina", "ikarita", "izina"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("نالي جو بيج"),
            keywords: &["بيج", "نالو", "نالي جو بيج"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("නම\u{dca} ල\u{dcf}ංඡනය"),
            keywords: &["නම", "නම\u{dca} ල\u{dcf}ංඡනය", "ල\u{dcf}ංඡනය"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("menovka"),
            keywords: &["meno", "menovka"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("značka za ime"),
            keywords: &["ime", "značka", "značka za ime"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("calaamadda magaca"),
            keywords: &["calaamad", "calaamadda magaca", "magac"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("etiketë emri"),
            keywords: &["emër", "etiketë", "etiketë emri"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("значка са именом"),
            keywords: &["значка", "значка са именом", "име"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("značka sa imenom"),
            keywords: &["ime", "značka", "značka sa imenom"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("namnskylt"),
            keywords: &["namn", "namnskylt", "skylt"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("beji ya jina"),
            keywords: &["beji", "beji ya jina", "jina"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("நேம\u{bcd} பேட\u{bcd}ஜ\u{bcd}"),
            keywords: &[
                "நேம\u{bcd} பேட\u{bcd}ஜ\u{bcd}",
                "பெயர\u{bcd} எழுதும\u{bcd} இடம\u{bcd}",
                "பெயர\u{bcd} பட\u{bcd}டி",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ప\u{c47}రు బ\u{c4d}య\u{c3e}డ\u{c4d}జ\u{c4d}"),
            keywords: &[
                "ప\u{c47}రు ట\u{c4d}య\u{c3e}గ\u{c4d}",
                "ప\u{c47}రు బ\u{c4d}య\u{c3e}డ\u{c4d}జ\u{c40}",
                "ప\u{c47}రు బ\u{c4d}య\u{c3e}డ\u{c4d}జ\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("нишонаи ном"),
            keywords: &["нишона", "нишонаи ном", "ном"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ป\u{e49}ายช\u{e37}\u{e48}อ"),
            keywords: &[
                "ช\u{e37}\u{e48}อ",
                "ป\u{e49}าย",
                "ป\u{e49}ายช\u{e37}\u{e48}อ",
            ],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ሽም ባድጀ"),
            keywords: &["ሽም", "ባድጀ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("at tarketkasy"),
            keywords: &["at", "at tarketkasy", "tarketka"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("kaati hingoa"),
            keywords: &["hingoa", "kaati"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("ad rozeti"),
            keywords: &["ad", "ad rozeti", "rozet"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئىزنەك"),
            keywords: &["ئىزنەك", "نام"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("бейдж з іменем"),
            keywords: &["бейдж", "бейдж з іменем", "ім’я"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("نام کا بیج"),
            keywords: &["بیج", "نام", "نام کا بیج"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("ism yoziladigan nishon"),
            keywords: &["ism yoziladigan nishon", "nishon", "nom"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("thẻ tên"),
            keywords: &["thẻ", "tên"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("badsu tur"),
            keywords: &["badsu", "tur"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("igama lebheji"),
            keywords: &["ibheji", "igama", "igama lebheji"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("orúkọ àmì"),
            keywords: &["báájì", "orúkọ", "orúkọ àmì"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("名牌"),
            keywords: &["名牌", "姓名"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("名牌"),
            keywords: &["名牌", "姓名", "牌"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("姓名牌"),
            keywords: &["姓名牌", "胸牌", "证章"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("名牌"),
            keywords: &["名牌", "胸牌"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("姓名牌"),
            keywords: &["名牌", "姓名牌"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ibheji legama"),
            keywords: &["ibheji", "ibheji legama", "igama"],
        },
    ],
};
#[doc = "🔰"]
pub const JAPANESE_SYMBOL_FOR_BEGINNER: crate::Emoji = crate::Emoji {
    glyph: "🔰",
    codepoint: "1F530",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "Japanese symbol for beginner",
    group: "Symbols",
    subgroup: "other-symbol",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("japanse beginnersimbool"),
            keywords: &[
                "beginner",
                "blaar",
                "chevron",
                "geel",
                "groen",
                "japannees",
                "japanse beginnersimbool",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የጃፓን የጀማሪ ምልክት"),
            keywords: &["ቅጠል", "የጃፓን", "የጃፓን የጀማሪ ምልክት", "ጀማሪ ሼቭሮን"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("ورقة خضراء وصفراء"),
            keywords: &["أخضر وأصفر", "مبتدئ", "ورقة خضراء وصفراء", "ياباني"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("শিক\u{9be}ৰ\u{9c1}ৰ ব\u{9be}বে জ\u{9be}প\u{9be}নী চিহ\u{9cd}ন"),
            keywords: &[
                "জ\u{9be}প\u{9be}নী",
                "ধৰণ",
                "প\u{9be}ত",
                "শিক\u{9be}ৰ\u{9c1}",
                "শিক\u{9be}ৰ\u{9c1}ৰ ব\u{9be}বে জ\u{9be}প\u{9be}নী চিহ\u{9cd}ন",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("yaponların başlayan üçün simvolu"),
            keywords: &[
                "alət",
                "başlayan",
                "sarı",
                "yapon",
                "yaponların başlayan üçün simvolu",
                "şevron",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("японскі сімвал «пачатковец»"),
            keywords: &[
                "жоўты",
                "зялёны",
                "навічок",
                "пачатковец",
                "шаўрон",
                "японскі",
                "японскі сімвал «пачатковец»",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Японски символ за начинаещ"),
            keywords: &["Японски символ за начинаещ", "начинаещ", "японски"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("শিক\u{9cd}ষ\u{9be}নবিসদের জন\u{9cd}য জ\u{9be}প\u{9be}নী প\u{9cd}রতীক"),
            keywords: &[
                "জ\u{9be}প\u{9be}নি",
                "প\u{9be}ত\u{9be}",
                "শিক\u{9cd}ষ\u{9be}নবিস",
                "শিক\u{9cd}ষ\u{9be}নবিসদের জন\u{9cd}য জ\u{9be}প\u{9be}নি প\u{9cd}রতীক",
                "শিক\u{9cd}ষ\u{9be}নবিসদের জন\u{9cd}য জ\u{9be}প\u{9be}নী প\u{9cd}রতীক",
                "শেভ\u{9cd}রন",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("arouez japanat evit an deraouidi"),
            keywords: &[
                "Japan",
                "arouez",
                "arouez japanat evit an deraouidi",
                "deraouad",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("japanski simbol za početnike"),
            keywords: &[
                "japanski",
                "japanski simbol za početnike",
                "list",
                "početnik",
                "zeleno-žuto",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("símbol japonès de principiant"),
            keywords: &[
                "japonès",
                "principiant",
                "símbol",
                "símbol japonès de principiant",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏣᏩᏂᏏ ᏓᏟᎶᏍᏗᏍᎬᎢ ᎾᏍᎩ ᎬᏩᏙᏗ ᎠᎴᏂᏍᎩ"),
            keywords: &[
                "ᎠᎧᏁᏍᏗ",
                "ᎠᎴᏂᏍᎩ",
                "ᎤᎦᎶᎦ",
                "ᏣᏩᏂᏏ",
                "ᏣᏩᏂᏏ ᏓᏟᎶᏍᏗᏍᎬᎢ ᎾᏍᎩ ᎬᏩᏙᏗ ᎠᎴᏂᏍᎩ",
            ],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("japonský symbol pro začátečníka"),
            keywords: &[
                "japonský",
                "japonský symbol pro začátečníka",
                "list",
                "pomůcka",
                "začátečník",
                "zelená",
                "žlutá",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("symbol Japaneaidd am ddechreuwr"),
            keywords: &[
                "Japaneaidd",
                "dechreuwr",
                "deilen",
                "gwyrdd",
                "symbol Japaneaidd am ddechreuwr",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("japansk begyndersymbol"),
            keywords: &["grønt og gult", "japansk begyndersymbol"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("japanisches Anfänger-Zeichen"),
            keywords: &[
                "Anfänger",
                "japanisches Anfänger-Zeichen",
                "japanisches Symbol",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ιαπωνικό σύμβολο για αρχάριους"),
            keywords: &[
                "αρχάριος",
                "διάσημα",
                "ιαπωνικό",
                "ιαπωνικό σύμβολο για αρχάριους",
                "φύλλο",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("Japanese symbol for beginner"),
            keywords: &[
                "Japanese",
                "Japanese symbol for beginner",
                "beginner",
                "chevron",
                "leaf",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("símbolo japonés para principiante"),
            keywords: &[
                "amarillo",
                "japonés",
                "principiante",
                "símbolo japonés para principiante",
                "verde",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("símbolo japonés de principiante"),
            keywords: &[
                "amarillo",
                "japonés",
                "principiante",
                "símbolo japonés de principiante",
                "símbolo japonés para principiante",
                "verde",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &[
                "bandera",
                "hoja",
                "japonés",
                "principiante",
                "símbolo japonés de principiante",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &[
                "bandera",
                "hoja",
                "japonés",
                "principiante",
                "símbolo japonés de principiante",
            ],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("algaja sümbol"),
            keywords: &["algaja", "algaja sümbol", "kollane", "leht", "roheline"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("hasiberriaren japonierako ikurra"),
            keywords: &[
                "berdea",
                "hasiberria",
                "hasiberria irudikatzen duen japonierako ikurra",
                "hasiberriaren japonierako ikurra",
                "hostoa",
                "japoniera",
                "komatxoa",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("نماد ژاپنی سطح مبتدی"),
            keywords: &[
                "برگ",
                "درجه نظامی",
                "زرد",
                "مبتدی",
                "نماد ژاپنی سطح مبتدی",
                "ژاپنی",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("japanilainen symboli aloittelijalle"),
            keywords: &[
                "Japani",
                "ajokortti",
                "aloittelija",
                "auto",
                "japanilainen symboli aloittelijalle",
                "shoshinsha",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("japanese na simbolo para sa baguhan"),
            keywords: &[
                "Hapones",
                "baguhan",
                "berde",
                "dahon",
                "dilaw",
                "japanese na simbolo para sa baguhan",
                "simbolo",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("japanskt symbol fyri byrjandi"),
            keywords: &[
                "byrjandi",
                "byrjari",
                "japanskt",
                "japanskt symbol fyri byrjandi",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("symbole japonais de débutant"),
            keywords: &["débutant", "symbole japonais de débutant"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("symbole japonais du débutant"),
            keywords: &[
                "chevron",
                "débutant",
                "feuille",
                "japonais",
                "symbole",
                "symbole japonais du débutant",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("siombal Sheapánach le haghaidh tosaitheoirí"),
            keywords: &["siombal Sheapánach le haghaidh tosaitheoirí", "tosaitheoir"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("samhla Seapanach air neach-tòiseachaidh"),
            keywords: &[
                "acainn",
                "buidhe",
                "duilleag",
                "iapanach",
                "inneal",
                "neach-tòiseachaidh",
                "saidh",
                "samhla Seapanach air neach-tòiseachaidh",
                "samhla Seapanach airson neach-tòiseachaidh",
                "seapanach",
                "tòiseachadh",
                "uaine",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("símbolo xaponés para principiante"),
            keywords: &[
                "amarelo",
                "principiante",
                "símbolo xaponés para principiante",
                "verde",
                "xaponés",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("પ\u{acd}રાર\u{a82}ભકર\u{acd}તા માટ\u{ac7} જાપાની પ\u{acd}રતીક"),
            keywords: &[
                "જાપાનીઝ",
                "પ\u{acd}રાર\u{a82}ભકર\u{acd}તા",
                "પ\u{acd}રાર\u{a82}ભકર\u{acd}તા માટ\u{ac7} જાપાની પ\u{acd}રતીક",
                "લીલ\u{ac1}\u{a82} અન\u{ac7} પીળ\u{ac1}\u{a82}",
                "લીલ\u{ac1}\u{a82} અન\u{ac7} પીળ\u{ac1}\u{a82} પા\u{a82}દડ\u{ac1}",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("alama Na Japan don ɗan koyo"),
            keywords: &[
                "Na Japan",
                "alama Na Japan don ɗan koyo",
                "chevron",
                "ganye",
                "kayan aiki",
                "kore",
                "rawaya",
                "ɗan koyo",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("סמל יפני לרמת מתחילים"),
            keywords: &["יפני", "מתחיל", "סמל יפני לרמת מתחילים", "עלה", "שברון"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some(
                "हरी और पीली पत\u{94d}ती, श\u{941}र\u{941}आतकर\u{94d}ता क\u{947} लिए जापानी चिह\u{94d}न",
            ),
            keywords: &[
                "श\u{941}र\u{941}आतकर\u{94d}ता क\u{947} लिए जापानी चिह\u{94d}न",
                "हरा और पीला",
                "हरी और पीली पत\u{94d}ती",
                "हरी और पीली पत\u{94d}ती, श\u{941}र\u{941}आतकर\u{94d}ता क\u{947} लिए जापानी चिह\u{94d}न",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("japanski simbol za početnika"),
            keywords: &[
                "japanski",
                "japanski simbol za početnika",
                "list",
                "početnik",
                "čin",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("a kezdő japán szimbóluma"),
            keywords: &[
                "a kezdő japán szimbóluma",
                "japán",
                "kezdő",
                "levél",
                "sárga",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("սկսնակ լինելու ճապոնական նշան"),
            keywords: &[
                "գործիք",
                "դեղին",
                "կանաչ",
                "հեծանակ",
                "ճապոնական",
                "սկսնակ",
                "սկսնակ լինելու ճապոնական նշան",
                "տերև",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("simbol jepang untuk pemula"),
            keywords: &[
                "Jepang",
                "daun",
                "pemula",
                "simbol jepang untuk pemula",
                "tanda pangkat",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("akara Japan maka nke isimbìdo"),
            keywords: &[
                "Ndị Japan",
                "akara Japan maka nke isimbìdo",
                "akwụkwọnri",
                "chevron",
                "isimbìdo",
                "ndụ ndụ",
                "ngwaọrụ",
                "èdò edò",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("græn og gul lauf"),
            keywords: &["byrjandi", "græn og gul", "græn og gul lauf", "japanskt"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("ideogramma giapponese di “Principiante”"),
            keywords: &[
                "etichetta gialla e verde principiante",
                "ideogramma giapponese di “Principiante”",
                "principiante",
                "simbolo principiante Giappone",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("初心者マーク"),
            keywords: &["初心者", "初心者マーク", "若葉マーク"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("tandha wong anyaran cara Jepang"),
            keywords: &[
                "anyaran",
                "emblem",
                "godhong",
                "tandha wong anyaran cara Jepang",
                "wong Jepang",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("იაპონური დამწყების სიმბოლო"),
            keywords: &[
                "დამწყები",
                "იაპონური",
                "იაპონური დამწყების სიმბოლო",
                "ინსტრუმენტი",
                "ფოთოლი",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("бастаушыларға арналған жапон белгісі"),
            keywords: &[
                "бастаушыларға арналған жапон белгісі",
                "бастауыш",
                "жапон",
                "жапырақ",
                "шеврон",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("grønt og gult blad"),
            keywords: &["grønt og gult", "grønt og gult blad"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some(
                "សញ\u{17d2}ញាបន\u{17d2}ទះសញ\u{17d2}ញាព\u{17d2}រ\u{17bd}ញច\u{17bb}ះក\u{17d2}រោម (សម\u{17d2}គាល\u{17cb}អ\u{17d2}នកចាប\u{17cb}ផ\u{17d2}តើមដ\u{17c6}ប\u{17bc}ង)",
            ),
            keywords: &[
                "ព\u{17d2}រ\u{17bd}ញ",
                "សញ\u{17d2}ញា",
                "សញ\u{17d2}ញាបន\u{17d2}ទះសញ\u{17d2}ញាព\u{17d2}រ\u{17bd}ញច\u{17bb}ះក\u{17d2}រោម (សម\u{17d2}គាល\u{17cb}អ\u{17d2}នកចាប\u{17cb}ផ\u{17d2}តើមដ\u{17c6}ប\u{17bc}ង)",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some(
                "ಪ\u{ccd}ರಾರಂಭ\u{cbf}ಕರ\u{cbf}ಗ\u{cc6} ಜಪಾನೀಸ\u{ccd} ಚ\u{cbf}ಹ\u{ccd}ನ\u{cc6}",
            ),
            keywords: &[
                "ಪ\u{ccd}ರಾರಂಭ\u{cbf}ಕರ\u{cbf}ಗ\u{cc6} ಜಪಾನೀಸ\u{ccd} ಚ\u{cbf}ಹ\u{ccd}ನ\u{cc6}",
                "ಹಸ\u{cbf}ರು ಮತ\u{ccd}ತು ಹಳದ\u{cbf}",
                "ಹಸ\u{cbf}ರು ಮತ\u{ccd}ತು ಹಳದ\u{cbf} ಎಲ\u{cc6}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("노란색 초록색 이파리 모양"),
            keywords: &["노란색 초록색", "노란색 초록색 이파리 모양", "초보자"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("स\u{941}रवात करप\u{94d}या\u{902} खातीर जपानी चिन\u{94d}न"),
            keywords: &[
                "जपानी",
                "पान",
                "श\u{945}वरॉन",
                "स\u{941}रवात करपी",
                "स\u{941}रवात करप\u{94d}या\u{902} खातीर जपानी चिन\u{94d}न",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("жапончочо үйрөнчүктөр символу"),
            keywords: &[
                "жалбырак",
                "жапончо",
                "жапончочо үйрөнчүктөр символу",
                "жашыл",
                "үйрөнчүк",
            ],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Ufängerzeechen (Japan)"),
            keywords: &[
                "Blat",
                "Ufänger",
                "Ufängerzeechen (Japan)",
                "Wopen",
                "giel",
                "gréng",
                "japanesch",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some(
                "ສ\u{eb1}ນຍາລ\u{eb1}ກຍ\u{eb5}\u{ec8}ປ\u{eb8}\u{ec8}ນສຳລ\u{eb1}ບຜ\u{eb9}\u{ec9}ເລ\u{eb5}\u{ec8}ມຕ\u{ebb}\u{ec9}ນ",
            ),
            keywords: &[
                "ຍ\u{eb5}\u{ec8}ປ\u{eb8}\u{ec8}ນ",
                "ຜ\u{eb9}\u{ec9}ເລ\u{eb5}\u{ec8}ມຕ\u{ebb}\u{ec9}ນ",
                "ສ\u{eb1}ນຍາລ\u{eb1}ກຍ\u{eb5}\u{ec8}ປ\u{eb8}\u{ec8}ນສຳລ\u{eb1}ບຜ\u{eb9}\u{ec9}ເລ\u{eb5}\u{ec8}ມຕ\u{ebb}\u{ec9}ນ",
                "ສ\u{eb5}ຂຽວ",
                "ສ\u{eb5}ເຫ\u{ebc}\u{eb7}ອງ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("japoniškas pradedančiojo simbolis"),
            keywords: &[
                "geltonas",
                "japoniškas pradedančiojo simbolis",
                "japonų",
                "lapas",
                "pradedantysis",
                "simbolis",
                "įrankis",
                "žalias",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("japāņu simbols, kas apzīmē iesācēju"),
            keywords: &[
                "iesācējs",
                "japāņu",
                "japāņu apzīmējums iesācējam",
                "japāņu simbols, kas apzīmē iesācēju",
                "simbols",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tohu Hapanīhi mō te tauhou"),
            keywords: &[
                "Hapanīhi",
                "kaitīmata",
                "kaokao",
                "kākāriki",
                "kōwhai",
                "rau",
                "tohu Hapanīhi mō te tauhou",
                "utauta",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("почетник на јапонски"),
            keywords: &[
                "жолт",
                "зелен",
                "лист",
                "почетник",
                "почетник на јапонски",
                "јапонски",
            ],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some(
                "ത\u{d41}ടക\u{d4d}കക\u{d4d}ക\u{d3e}ർക\u{d4d}ക\u{d41}ള\u{d4d}ള ജപ\u{d4d}പ\u{d3e}നീസ\u{d4d} ചിഹ\u{d4d}നം",
            ),
            keywords: &[
                "ഇല",
                "ജ\u{d3e}പ\u{d4d}പനീസ\u{d4d}",
                "ത\u{d41}ടക\u{d4d}കക\u{d4d}ക\u{d3e}രൻ",
                "ത\u{d41}ടക\u{d4d}കക\u{d4d}ക\u{d3e}ർക\u{d4d}ക\u{d41}ള\u{d4d}ള ജപ\u{d4d}പ\u{d3e}നീസ\u{d4d} ചിഹ\u{d4d}നം",
                "ത\u{d41}ടക\u{d4d}കക\u{d4d}ക\u{d3e}ർക\u{d4d}ക\u{d41}ള\u{d4d}ള ജ\u{d3e}പ\u{d4d}പനീസ\u{d4d} ചിഹ\u{d4d}നം",
                "ഷെവ\u{d4d}റോൺ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("Японы анхлан суралцагчийн тэмдэг"),
            keywords: &[
                "Японы",
                "Японы анхлан суралцагчийн тэмдэг",
                "анхлан суралцагч",
                "навч",
                "шеврон",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some(
                "आर\u{902}भ करण\u{94d}\u{200d}यार\u{94d}\u{200d}या\u{902}साठी जपानी चिन\u{94d}ह",
            ),
            keywords: &[
                "आर\u{902}भ करण\u{94d}\u{200d}यार\u{94d}\u{200d}या\u{902}साठी जपानी चिन\u{94d}ह",
                "जपानी",
                "नवशिक\u{94d}या",
                "पान",
                "पिवळ\u{947}",
                "श\u{947}वरॉन",
                "हिरव\u{947}",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("simbol Jepun untuk pemula"),
            keywords: &[
                "Jepun",
                "chevron",
                "daun",
                "pemula",
                "simbol Jepun untuk pemula",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("simbolu Ġappuniż għal prinċipjant"),
            keywords: &[
                "aħdar",
                "chevron",
                "għodda",
                "isfar",
                "prinċipjant",
                "simbolu Ġappuniż għal prinċipjant",
                "werqa",
                "Ġappuniż",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("စသင\u{103a}သ\u{1030}အတ\u{103d}က\u{103a} ဂျပန\u{103a} သင\u{103a}\u{1039}ကေတ"),
            keywords: &[
                "ဂျပန\u{103a}",
                "စသင\u{103a}သ\u{1030}",
                "စသင\u{103a}သ\u{1030}ဖြစ\u{103a}ကြောင\u{103a}းပြသသည\u{1037}\u{103a} ဂျပန\u{103a}သင\u{103a}\u{1039}ကေတ",
                "စသင\u{103a}သ\u{1030}အတ\u{103d}က\u{103a} ဂျပန\u{103a} သင\u{103a}\u{1039}ကေတ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("japansk tegn for nybegynner"),
            keywords: &[
                "grønn og gul",
                "grønt og gult blad",
                "japansk",
                "japansk tegn for nybegynner",
                "nybegynner",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("स\u{941}र\u{941}वातकर\u{94d}ताको लागि जापानिज प\u{94d}रतिक"),
            keywords: &[
                "च\u{947}भरोन",
                "जापानिज",
                "पह\u{947}\u{901}लो",
                "पात",
                "साधन",
                "स\u{941}र\u{941}वात गर\u{94d}न\u{947}",
                "स\u{941}र\u{941}वातकर\u{94d}ताको लागि जापानिज प\u{94d}रतिक",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("Japans symbool voor beginner"),
            keywords: &[
                "Japans",
                "Japans symbool voor beginner",
                "beginner",
                "blad",
                "chevron",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("japansk teikn for nybyrjar"),
            keywords: &[
                "grøn og gul",
                "grønt og gult blad",
                "japansk",
                "japansk teikn for nybyrjar",
                "nybyrjar",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some(
                "ନ\u{b42}ଆ ଶ\u{b3f}ଖ\u{b3e}ଳ\u{b3f}ଙ\u{b4d}କ ପ\u{b3e}ଇ\u{b01} ଜ\u{b3e}ପ\u{b3e}ନୀୟ ସଙ\u{b4d}କେତ",
            ),
            keywords: &[
                "ଚେଭ\u{b4d}ରନ\u{b4d}\u{200c}",
                "ଜ\u{b3e}ପ\u{b3e}ନୀୟ",
                "ନ\u{b42}ଆ ଶ\u{b3f}ଖ\u{b3e}ଳ\u{b3f}ଙ\u{b4d}କ ପ\u{b3e}ଇ\u{b01} ଜ\u{b3e}ପ\u{b3e}ନୀୟ ସଙ\u{b4d}କେତ",
                "ପତ\u{b4d}ର",
                "ଯନ\u{b4d}ତ\u{b4d}ରପ\u{b3e}ତ\u{b3f}",
                "ଶ\u{b3f}କ\u{b4d}ଷ\u{b3e}ର\u{b4d}ଥୀ",
                "ସବ\u{b41}ଜ",
                "ହଳଦ\u{b3f}ଆ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਸ\u{a3c}\u{a41}ਰ\u{a42}ਆਤ ਲਈ ਜਾਪਾਨੀ ਚਿ\u{a70}ਨ\u{a4d}ਹ"),
            keywords: &[
                "ਜਾਪਾਨੀ",
                "ਸ\u{a3c}\u{a41}ਰ\u{a42}ਆਤ ਲਈ ਜਾਪਾਨੀ ਚਿ\u{a70}ਨ\u{a4d}ਹ",
                "ਸ\u{a3c}\u{a42}ਰ\u{a41}ਆਤੀ",
                "ਹਰਾ ਅਤ\u{a47} ਪੀਲਾ",
                "ਹਰਾ ਅਤ\u{a47} ਪੀਲਾ ਪ\u{a71}ਤਾ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("شروع کرن آلیاں لئی جاپانی علامت"),
            keywords: &[
                "آغاز کرن آلا",
                "اوزار",
                "بت\u{651}ا",
                "جاپانی",
                "شروع کرن آلیاں لئی جاپانی علامت",
                "شیوران",
                "پیلا",
                "ہرا",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Japán Sain Fọ Bigína"),
            keywords: &[
                "Bigína",
                "Japán",
                "Japán Sain Fọ Bigína",
                "Lif",
                "Shẹ\u{301}vrọn",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("japoński symbol początkującego kierowcy"),
            keywords: &[
                "japoński symbol początkującego kierowcy",
                "niebieski",
                "początkujący",
                "szewron",
                "w dół",
                "żółty",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د ابتکار لپاره جاپاني سمبول"),
            keywords: &[
                "ابتکار",
                "جاپاني",
                "د ابتکار لپاره جاپاني سمبول",
                "پاڼه",
                "چيوران",
            ],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("símbolo japonês de principiante"),
            keywords: &[
                "folha verde e amarela",
                "iniciante",
                "japonês",
                "símbolo japonês de principiante",
                "verde e amarela",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("símbolo japonês para principiante"),
            keywords: &[
                "amarelo",
                "insígnia",
                "japonês",
                "principiante",
                "símbolo japonês para principiante",
                "verde",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("japones unancha qallariqkunapaq"),
            keywords: &["japones unancha qallariqkunapaq"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("simbol japonez pentru începător"),
            keywords: &[
                "Japonia",
                "japonez",
                "simbol japonez pentru începător",
                "începător",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-748"),
            keywords: &["E10-748"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("символ новичка"),
            keywords: &[
                "Япония",
                "новичок",
                "символ",
                "символ новичка",
                "японский символ новичка",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ikimenyetso cy’ikiyapani cy’umutangizi"),
            keywords: &[
                "Nyapani",
                "icyatsi",
                "igikoresho",
                "ikibabi",
                "ikimenyetso cy’ikiyapani cy’umutangizi",
                "ipeti",
                "umuhondo",
                "umutangizi",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("شروعات ڪندڙ جي لاء\u{650} جاپاني نشاني"),
            keywords: &[
                "اوزار",
                "جاپاني",
                "سائو",
                "شروعات ڪندڙ",
                "شروعات ڪندڙ جي لاء\u{650} جاپاني نشاني",
                "شيوران",
                "پن",
                "پيلو",
            ],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("නවකය\u{dcf} ප\u{dd2}ළ\u{dd2}බඳ ජපන\u{dca} සංකේතය"),
            keywords: &[
                "කොළය",
                "චෙව\u{dca}රන\u{dca}",
                "ජපන\u{dca}",
                "නවකය\u{dcf}",
                "නවකය\u{dcf} ප\u{dd2}ළ\u{dd2}බඳ ජපන\u{dca} සංකේතය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("japonský symbol pre začiatočníka"),
            keywords: &[
                "japonská",
                "japonský symbol pre začiatočníka",
                "list",
                "páska",
                "začiatočník",
                "zelená",
                "žltá",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("japonski simbol za začetnika"),
            keywords: &[
                "cik-cak",
                "japonski simbol za začetnika",
                "japonsko",
                "list",
                "orodje",
                "puščica",
                "rumeno",
                "začetnik",
                "zeleno",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("calaamadda Jabbaaka ee dadka bilowga ah"),
            keywords: &[
                "calaamadda Jabbaaka ee dadka bilowga ah",
                "caleen",
                "darajada",
                "qof bilow ah",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("simboli japonez për fillestar"),
            keywords: &[
                "fillestar",
                "gjethe",
                "shirit",
                "simboli japonez për fillestar",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("јапански симбол за почетника"),
            keywords: &[
                "лист",
                "почетник",
                "јапански",
                "јапански симбол за почетника",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["јапански симбол за почетника"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("japanski simbol za početnika"),
            keywords: &[
                "japanski",
                "japanski simbol za početnika",
                "list",
                "početnik",
            ],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["japanski simbol za početnika"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("japansk symbol för nybörjare"),
            keywords: &["grönt och gult blad", "japansk symbol för nybörjare"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("alama ya kijapani ya anayeanza"),
            keywords: &[
                "alama ya kijapani ya anayeanza",
                "anayeanza",
                "kijapani",
                "tawi",
                "tepe ya V",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some(
                "புதியவர\u{bcd} என\u{bcd}பதைக\u{bcd} க\u{bbe}ட\u{bcd}டும\u{bcd} ஜப\u{bcd}ப\u{bbe}ன\u{bcd} சின\u{bcd}னம\u{bcd}",
            ),
            keywords: &[
                "இளங\u{bcd}கன\u{bcd}று",
                "பச\u{bcd}சை & மஞ\u{bcd}சள\u{bcd}",
                "புதியவர\u{bcd}",
                "புதியவர\u{bcd} என\u{bcd}பதைக\u{bcd} க\u{bbe}ட\u{bcd}டும\u{bcd} ஜப\u{bcd}ப\u{bbe}ன\u{bcd} சின\u{bcd}னம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some(
                "జప\u{c3e}న\u{c4d}\u{200c}ల\u{c4b} డ\u{c4d}ర\u{c48}వ\u{c3f}ంగ\u{c4d} న\u{c47}ర\u{c4d}చుకున\u{c47}వ\u{c3e}రు ప\u{c4d}రదర\u{c4d}శ\u{c3f}ంచ\u{c47} గుర\u{c4d}తు",
            ),
            keywords: &[
                "జప\u{c3e}న\u{c4d} వ\u{c3e}హన శ\u{c3f}క\u{c4d}షకులు ప\u{c4d}రదర\u{c4d}శ\u{c3f}ంచ\u{c47} గుర\u{c4d}తు",
                "జప\u{c3e}న\u{c4d}\u{200c}ల\u{c4b} డ\u{c4d}ర\u{c48}వ\u{c3f}ంగ\u{c4d} న\u{c47}ర\u{c4d}చుకున\u{c47}వ\u{c3e}రు ప\u{c4d}రదర\u{c4d}శ\u{c3f}ంచ\u{c47} గుర\u{c4d}తు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("аломати ҷопонӣ барои навомӯз"),
            keywords: &[
                "аломати ҷопонӣ барои навомӯз",
                "асбоб",
                "барг",
                "зард",
                "навомӯз",
                "сабз",
                "шеврон",
                "ҷопонӣ",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ส\u{e31}ญล\u{e31}กษณ\u{e4c}ม\u{e37}อใหม\u{e48}ห\u{e31}ดข\u{e31}บ"),
            keywords: &[
                "บ\u{e31}\u{e49}ง",
                "ส\u{e31}ญล\u{e31}กษณ\u{e4c}ม\u{e37}อใหม\u{e48}ห\u{e31}ดข\u{e31}บ",
                "เข\u{e35}ยว",
                "เคร\u{e37}\u{e48}องม\u{e37}อ",
                "เหล\u{e37}อง",
                "ใบไม\u{e49}",
            ],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ጃፓናዊ ምልክት ን ጀማሪ"),
            keywords: &["ቆጽሊ", "ቸቭሮን", "ጀማሪ", "ጃፓናዊ", "ጃፓናዊ ምልክት ን ጀማሪ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("öwrenjeler üçin ýaponça nyşany"),
            keywords: &[
                "öwrenje",
                "öwrenjeler üçin ýaponça nyşany",
                "ýapon",
                "ýaprak",
                "şewron",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tokotaha langalangafoʻou fakasiapani"),
            keywords: &["fakasiapani", "langalangafoʻou", "tokotaha"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("Japonca yeni başlayan sembolü"),
            keywords: &[
                "Japonca",
                "Japonca yeni başlayan sembolü",
                "yeni başlayan",
                "yeşil ve sarı",
                "yeşil ve sarı yaprak",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ياپونچە باشلانغۇچ بەلگىسى"),
            keywords: &[
                "ئاچىماق",
                "باشلىغۇچى",
                "سېرىق",
                "قورال",
                "ياپراق",
                "ياپونچە",
                "ياپونچە باشلانغۇچ بەلگىسى",
                "يېشىل",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("японський символ «початківець»"),
            keywords: &[
                "листок",
                "початківець",
                "шеврон",
                "японський",
                "японський символ «початківець»",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("شروعات کرنے والے کا جاپانی نشان"),
            keywords: &[
                "جاپانی",
                "شروعات",
                "شروعات کرنے والے کا جاپانی نشان",
                "نشان",
            ],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("boshlovchi yaponcha belgi"),
            keywords: &[
                "barg",
                "boshlovchi",
                "boshlovchi darajasini bildiruvchi yaponcha belgi",
                "boshlovchi yaponcha belgi",
                "yaponcha",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("ký hiệu của Nhật cho người mới bắt đầu"),
            keywords: &[
                "Nhật",
                "hình V",
                "ký hiệu của Nhật cho người mới bắt đầu",
                "lá",
                "người mới bắt đầu",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("màndarga sapone, soog a door"),
            keywords: &[
                "Sapone",
                "gëm",
                "jumtukaay",
                "mboq",
                "màndarga sapone, soog a door",
                "tàmbalikat",
                "wert",
                "xob",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("isimboli yaseJapan yabaqalayo"),
            keywords: &[
                "i-chevron",
                "igqabi",
                "isimboli yaseJapan yabaqalayo",
                "isixhobo",
                "luhlaza",
                "mthubi",
                "oqalayo",
                "yaseJapan",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Àmì Japanisi fun olubẹre"),
            keywords: &[
                "Jàpànísì",
                "ewé",
                "irjnṣé\u{329}",
                "yé\u{329}lò",
                "Àmì Japanisi fun olubẹre",
                "Ìbẹ\u{300}rè\u{329}",
                "àwò\u{329} ewé",
                "ṣé\u{329}fúró\u{329}ọ\u{300}nù",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("初學者嘅日本符號"),
            keywords: &[
                "初學者",
                "初學者嘅日本符號",
                "工具",
                "日本",
                "綠色",
                "葉",
                "黃色",
            ],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("初学者嘅日本符号"),
            keywords: &[
                "初学者",
                "初学者嘅日本符号",
                "叶",
                "工具",
                "日本",
                "绿色",
                "黄色",
            ],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("日本新手驾驶标志"),
            keywords: &["V形图案", "叶状", "实习", "日本新手驾驶标志", "箭尾"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("日本初學者符號"),
            keywords: &["新手", "日本初學者符號"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("日本嘅初學者符號"),
            keywords: &["日本嘅初學者符號", "日本新手標誌", "日本新手駕駛標誌"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("uphawu lamajapanese lomuntu oqalayo"),
            keywords: &[
                "chevroni",
                "iqabunga",
                "ithuluzi",
                "japanese",
                "luhlaza satshani",
                "qanda",
                "umqali",
                "uphawu lamajapanese lomuntu oqalayo",
            ],
        },
    ],
};
#[doc = "⭕"]
pub const HOLLOW_RED_CIRCLE: crate::Emoji = crate::Emoji {
    glyph: "⭕",
    codepoint: "2B55",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "hollow red circle",
    group: "Symbols",
    subgroup: "other-symbol",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("hol rooi sirkel"),
            keywords: &["groot", "hol rooi sirkel", "o", "rooi", "sirkel"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ወፍራም ግዙፍ ክብ"),
            keywords: &["ኦ", "ክብ", "ወፍራም ግዙፍ ክብ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("دائرة كبيرة سميكة"),
            keywords: &["o", "دائرة", "دائرة كبيرة سميكة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ফো\u{981}পোল\u{9be} ৰঙ\u{9be} চক\u{9cd}ৰ"),
            keywords: &[
                "o",
                "চক\u{9cd}ৰ",
                "ড\u{9be}ঙৰ",
                "ফো\u{981}পোল\u{9be} ৰঙ\u{9be} চক\u{9cd}ৰ",
                "ৰঙ\u{9be}",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("qalın böyük dairə"),
            keywords: &["dairə", "o", "qalın böyük dairə"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("чырвонае кольца"),
            keywords: &["вялікае", "кола", "о", "чырвонае кольца"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Удебелена голяма окръжност"),
            keywords: &["Удебелена голяма окръжност", "окръжност"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ফ\u{9be}\u{981}প\u{9be} ল\u{9be}ল ব\u{9c3}ত\u{9cd}ত"),
            keywords: &[
                "ইংর\u{9be}জী ‘ও’ চিহ\u{9cd}ন",
                "ফ\u{9be}\u{981}প\u{9be} ল\u{9be}ল ব\u{9c3}ত\u{9cd}ত",
                "বড\u{9bc}",
                "ব\u{9c3}ত\u{9cd}ত",
                "ল\u{9be}ল",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("kelcʼh ruz"),
            keywords: &["kelcʼh", "o", "ruz"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("podebljani veliki crveni krug"),
            keywords: &[
                "crvena",
                "krug",
                "o",
                "podebljani veliki crveni krug",
                "podebljani veliki krug",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cercle buit vermell"),
            keywords: &["cercle", "cercle buit vermell", "gran", "o", "vermell"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᏒᏙᏂ ᎩᎦᎨ ᎦᏐᏆᎳ"),
            keywords: &["o", "ᎤᏒᏙᏂ ᎩᎦᎨ ᎦᏐᏆᎳ", "ᎤᏔᎾ", "ᎩᎦᎨ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("červený kruh bez výplně"),
            keywords: &["kruh", "o", "velký", "červený kruh bez výplně"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("cylch coch gwag"),
            keywords: &["coch", "cylch", "cylch coch gwag", "mawr", "o"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("stor rød cirkel"),
            keywords: &["bred", "cirkel", "kraftig", "o", "stor rød cirkel"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("hohler roter Kreis"),
            keywords: &["Kreis", "großer Kreis", "hohler roter Kreis", "o", "rot"],
        },
        #[cfg(feature = "de_CH")]
        crate::Annotation {
            lang: "de_CH",
            tts: Some("Grosser Kreis"),
            keywords: &["Grosser Kreis", "Kreis", "o", "rot"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κενός κόκκινος κύκλος"),
            keywords: &[
                "κενός κόκκινος κύκλος",
                "κόκκινος",
                "κύκλος",
                "μεγάλος",
                "ο",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("hollow red circle"),
            keywords: &["circle", "hollow red circle", "large", "o", "red"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("círculo rojo hueco"),
            keywords: &["aro", "círculo", "círculo rojo hueco", "o", "rojo"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("seest tühi punane ringjoon"),
            keywords: &["o", "rõngas", "seest tühi punane ringjoon", "suur ringjoon"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("zirkulu gorri hutsa"),
            keywords: &["gorri", "handi", "o", "zirkulu", "zirkulu gorri hutsa"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("دایره قرمز توخالی"),
            keywords: &["حلقه", "دایره", "دایره قرمز", "دایره قرمز توخالی", "صحیح"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("suuri ympyrä"),
            keywords: &["O", "suuri ympyrä", "ympyrä"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("malaking bilog"),
            keywords: &["bilog", "makapal", "malaki", "malaking bilog", "o"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("innanopin reyður sirkul"),
            keywords: &[
                "innanopin reyður sirkul",
                "o",
                "reytt",
                "reyður",
                "ringur",
                "sirkul",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("cercle rouge"),
            keywords: &["0", "anneau", "cercle", "o", "rouge"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["cercle", "grand", "o", "rouge"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("ciorcal dearg toll"),
            keywords: &["ciorcal", "ciorcal dearg toll", "dearg", "mór", "o"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("cearcall dearg falamh"),
            keywords: &["cearcall", "cearcall dearg falamh", "dearg", "mòr", "o"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("círculo groso"),
            keywords: &["círculo", "círculo groso", "o"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("પોલ\u{ac1}\u{a82} લાલ ર\u{a82}ગન\u{ac1}\u{a82} ગોળ"),
            keywords: &[
                "o",
                "ગોળ",
                "પોલ\u{ac1}\u{a82} લાલ ર\u{a82}ગન\u{ac1}\u{a82} ગોળ",
                "મોટ\u{ac1}\u{a82}",
                "લાલ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("babbar da’ira mai nauyi"),
            keywords: &["babbar da’ira mai nauyi", "da’ira", "o"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("עיגול אדום חלול"),
            keywords: &["0", "אדום", "גדול", "חישוק", "עיגול", "עיגול אדום חלול"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("बड\u{93c}ा लाल छल\u{94d}ला"),
            keywords: &[
                "गोला",
                "बड\u{93c}ा लाल छल\u{94d}ला",
                "व\u{943}त\u{94d}त",
                "व\u{943}त\u{94d}त, गोला",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("crveni krug s rupom"),
            keywords: &["crveni", "crveni krug s rupom", "krug", "o", "veliki"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("nagy, vastag kör"),
            keywords: &["kör", "nagy, vastag kör", "o"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("կարմիր դատարկ շրջան"),
            keywords: &["կարմիր", "կարմիր դատարկ շրջան", "մեծ", "շրջան", "օղակ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("lingkaran besar tebal"),
            keywords: &["lingkaran", "lingkaran besar tebal", "o"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("nnukwu okirikiri buru ibu"),
            keywords: &["nnukwu okirikiri buru ibu", "o", "okirikiri"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("holur rauður hringur"),
            keywords: &["holur rauður hringur", "hringur", "o", "rauður", "stór"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("cerchio"),
            keywords: &["cerchio", "gioco", "pallino", "tris"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("太い丸"),
            keywords: &["円", "太い丸", "記号", "輪"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("bunderan abang bolong"),
            keywords: &["abang", "bunder", "bunderan abang bolong", "gendhe", "o"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მსხვილი დიდი წრე"),
            keywords: &["o", "მსხვილი დიდი წრე", "რგოლი", "წრე"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("Қалың, үлкен шеңбер"),
            keywords: &["o", "шеңбер", "Қалың, үлкен шеңбер"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("stor kraftig cirkel"),
            keywords: &["cirkel", "o", "stor kraftig cirkel"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("រង\u{17d2}វង\u{17cb}ក\u{17d2}រហម"),
            keywords: &["រង\u{17d2}វង\u{17cb}", "រង\u{17d2}វង\u{17cb}ក\u{17d2}រហម"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಟೊಳ\u{ccd}ಳಾದ ಕ\u{cc6}ಂಪು ವೃತ\u{ccd}ತ"),
            keywords: &[
                "o",
                "ಟೊಳ\u{ccd}ಳಾದ ಕ\u{cc6}ಂಪು ವೃತ\u{ccd}ತ",
                "ಭಾರ\u{cbf} ದೊಡ\u{ccd}ಡ ವೃತ\u{ccd}ತ",
                "ವೃತ\u{ccd}ತ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("크고 진한 동그라미"),
            keywords: &["동그라미", "원", "크고 진한 동그라미"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("हॉलो ता\u{902}बड\u{947}\u{902} वर\u{94d}त\u{941}ळ"),
            keywords: &[
                "o",
                "ता\u{902}बड\u{947}\u{902}",
                "वर\u{94d}त\u{941}ळ",
                "व\u{94d}हड",
                "हॉलो ता\u{902}बड\u{947}\u{902} वर\u{94d}त\u{941}ळ",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("жоон, ири тегерек"),
            keywords: &["жоон, ири тегерек", "тегерек"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("groussen décke Krees"),
            keywords: &["Krees", "groussen décke Krees", "o"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some(
                "ວ\u{ebb}ງມ\u{ebb}ນເປ\u{eb1}\u{200b}ນ\u{200b}ຮ\u{eb9}\u{200b}ສ\u{eb5}\u{200b}ແດງ",
            ),
            keywords: &[
                "ວ\u{ebb}ງມ\u{ebb}ນ",
                "ວ\u{ebb}ງມ\u{ebb}ນເປ\u{eb1}\u{200b}ນ\u{200b}ຮ\u{eb9}\u{200b}ສ\u{eb5}\u{200b}ແດງ",
                "ວ\u{ebb}ງມ\u{ebb}ນໃຫຍ\u{ec8}ໜາ",
                "ໃຫຍ\u{ec8}ໜາ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("ryškus didelis ratas"),
            keywords: &["o", "ratas", "ryškus didelis ratas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("liels aplis"),
            keywords: &["aplis", "liels", "o", "riņķis", "sarkans"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("porohita rahi taumaha"),
            keywords: &["o", "porohita", "porohita rahi taumaha"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("празен црвен круг"),
            keywords: &["голем", "круг", "о", "празен црвен круг", "црвен"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ച\u{d41}വന\u{d4d}ന പൊള\u{d4d}ള വ\u{d43}ത\u{d4d}തം"),
            keywords: &[
                "o",
                "ച\u{d41}വന\u{d4d}ന പൊള\u{d4d}ള വ\u{d43}ത\u{d4d}തം",
                "ച\u{d41}വപ\u{d4d}പ\u{d4d}",
                "വലിയ വ\u{d43}ത\u{d4d}തം",
                "വല\u{d41}ത\u{d4d}",
                "വ\u{d43}ത\u{d4d}തം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("том бөөрөнхий"),
            keywords: &["бөөрөнхий", "том"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("मोठ\u{947} लाल वर\u{94d}त\u{941}ळ"),
            keywords: &[
                "पोकळ लाल वर\u{94d}त\u{941}ळ",
                "मोठ\u{947}",
                "लाल",
                "वर\u{94d}त\u{941}ळ",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("lohong bulatan besar"),
            keywords: &["besar", "bulatan", "lohong bulatan besar", "merah", "o"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("ċirku kbir grassett"),
            keywords: &["o", "ċirku", "ċirku kbir grassett"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "အကြ\u{102e}းစား အန\u{102e}ရောင\u{103a} စက\u{103a}ဝ\u{102d}\u{102f}င\u{103a}း",
            ),
            keywords: &[
                "စက\u{103a}ဝ\u{102d}\u{102f}င\u{103a}း",
                "စက\u{103a}ဝ\u{102d}\u{102f}င\u{103a}းသင\u{103a}\u{1039}ကေတ",
                "အကြ\u{102e}းစား",
                "အန\u{102e}ရောင\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("tykk rød sirkel"),
            keywords: &["o", "rød", "sirkel", "stor", "tykk rød sirkel"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("खाली रातो व\u{943}त\u{94d}त"),
            keywords: &[
                "ओ",
                "खाली रातो व\u{943}त\u{94d}त",
                "ठ\u{942}लो",
                "रातो",
                "व\u{943}त\u{94d}त",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("lege rode cirkel"),
            keywords: &["cirkel", "groot", "lege rode cirkel", "o", "rood"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("tjukk raud sirkel"),
            keywords: &["o", "raud", "sirkel", "stor", "tjukk"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ପୋଲ\u{b3e} ଲ\u{b3e}ଲ\u{b3f} ବ\u{b43}ତ\u{b4d}ତ"),
            keywords: &[
                "o",
                "ପୋଲ\u{b3e} ଲ\u{b3e}ଲ\u{b3f} ବ\u{b43}ତ\u{b4d}ତ",
                "ବଡ\u{b3c}",
                "ବ\u{b43}ତ\u{b4d}ତ",
                "ଲ\u{b3e}ଲ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਗ\u{a42}ੜ\u{a4d}ਹਾ ਲਾਲ ਘ\u{a47}ਰਾ"),
            keywords: &[
                "o",
                "ਗ\u{a42}ੜ\u{a4d}ਹਾ ਲਾਲ ਘ\u{a47}ਰਾ",
                "ਗ\u{a4b}ਲਾ",
                "ਗ\u{a4b}ਲ\u{a47} ਦਾ ਚਿ\u{a70}ਨ\u{a4d}ਹ",
                "ਲਾਲ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("وڈا بھارا دائرہ"),
            keywords: &["o", "دائرہ", "وڈا بھارا دائرہ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Rẹd Sẹ\u{301}kul Wé Gẹ\u{301}t Hol"),
            keywords: &[
                "Big",
                "Rẹd",
                "Rẹd Sẹ\u{301}kul Wé Gẹ\u{301}t Hol",
                "Sẹ\u{301}kul",
                "o",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("gruby czerwony okrąg"),
            keywords: &["gruby czerwony okrąg", "koło", "kółko", "o", "okrąg"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ګوګ سره دايره"),
            keywords: &["o", "دايره", "سره", "لوی", "ګوګ سره دايره"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("círculo grande oco"),
            keywords: &["círculo", "círculo grande oco", "grande", "o", "vermelho"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("círculo vermelho oco"),
            keywords: &[
                "círculo",
                "círculo vermelho oco",
                "encarnado",
                "grande",
                "o",
                "vermelho",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("cerc roșu gol"),
            keywords: &["cerc", "cerc roșu gol", "mare", "o", "roșu"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-162"),
            keywords: &["E10-162"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("красное кольцо"),
            keywords: &["большое кольцо", "кольцо", "красное кольцо", "круг"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("uruziga runini rutsitse"),
            keywords: &["o", "uruziga", "uruziga runini rutsitse"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ٿلهو وڏو دائرو"),
            keywords: &["o", "دائرو", "وڏو", "ٿلهو وڏو دائرو", "ڳاڙهو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("බර ව\u{dd2}ශ\u{dcf}ල රෝදය"),
            keywords: &["ඔ", "බර ව\u{dd2}ශ\u{dcf}ල රෝදය", "රව\u{dd4}ම"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("prázdny červený kruh"),
            keywords: &["kruh", "prázdny červený kruh", "veľký", "červený"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("velik prazen krog"),
            keywords: &["krog", "o", "rdeč", "velik", "velik prazen krog"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("goobo cas dalool leh"),
            keywords: &["cas", "goobo", "goobo cas dalool leh", "o", "weyn"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("rreth i madh i trashë"),
            keywords: &["o", "rreth", "rreth i madh i trashë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("окс"),
            keywords: &["o", "круг", "окс"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("oks"),
            keywords: &["krug", "o", "oks"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("tung stor cirkel"),
            keywords: &["cirkel", "o", "röd", "tung stor cirkel"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mduara mwekundu wenye shimo"),
            keywords: &[
                "mduara",
                "mduara mwekundu wenye shimo",
                "mkubwa",
                "mwekundu",
                "o",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("சிவப\u{bcd}பு நிற பெரிய வட\u{bcd}டம\u{bcd}"),
            keywords: &[
                "சிவப\u{bcd}பு நிற பெரிய வட\u{bcd}டம\u{bcd}",
                "சிவப\u{bcd}பு வட\u{bcd}டம\u{bcd}",
                "வட\u{bcd}டம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("అత\u{c4d}యంత భ\u{c3e}ర\u{c40} వృత\u{c4d}తం"),
            keywords: &[
                "అత\u{c4d}యంత భ\u{c3e}ర\u{c40} వృత\u{c4d}తం",
                "వృత\u{c4d}తం",
                "సర\u{c4d}క\u{c3f}ల\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("давраи калони вазнин"),
            keywords: &["давра", "давраи калони вазнин", "о"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("วงกลมกลวงส\u{e35}แดง"),
            keywords: &[
                "o",
                "วงกลม",
                "วงกลมกลวงส\u{e35}แดง",
                "ส\u{e35}แดง",
                "ใหญ\u{e48}",
            ],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ክፉት ቀይሕ ዓንኬል"),
            keywords: &["o", "ቀይሕ", "ክፉት ቀይሕ ዓንኬል", "ዓቢ", "ዓንኬል"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("içi boş gyzyl tegelek"),
            keywords: &[
                "goýy uly halka",
                "gyzyl",
                "halka",
                "içi boş gyzyl tegelek",
                "o",
                "uly",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("fuopotopoto mamafa"),
            keywords: &["fuopotopoto", "fuopotopoto mamafa", "ngeʻesi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("kalın kırmızı çember"),
            keywords: &["kalın kırmızı çember", "kalın çember", "o", "çember"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("چوڭ ئېغىر ھالقا"),
            keywords: &["o", "چوڭ ئېغىر ھالقا", "ھالقا"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("порожнисте червоне коло"),
            keywords: &["велике", "коло", "о", "порожнисте червоне коло", "червоне"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("کھوکھلا سرخ دائرہ"),
            keywords: &["o", "بڑا", "دائرہ", "سرخ", "کھوکھلا سرخ دائرہ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("boʻsh qizil doira"),
            keywords: &["aylana", "boʻsh qizil doira", "katta", "o", "qizil"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("vòng tròn lớn đậm"),
            keywords: &["o", "vòng tròn", "vòng tròn lớn đậm"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("sarkal bu rëy te diis"),
            keywords: &["o", "sarkal bu rëy te diis", "serkal"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("isangqa esikhulu esingqindilili"),
            keywords: &["isangqa esikhulu esingqindilili", "isanqa", "o"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("roboto wiwo nla"),
            keywords: &["o", "roboto wiwo nla", "òdo"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("粗大圓形"),
            keywords: &["o", "圓形", "粗大圓形", "紅色"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("粗大圆形"),
            keywords: &["o", "圆形", "粗大圆形"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("红色空心圆圈"),
            keywords: &["O形", "圆圈", "大", "红", "红色空心圆圈"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("圓圈"),
            keywords: &["圓圈"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("indingilizi enkulu oluwugqinsi ebomvu"),
            keywords: &[
                "ebomvu",
                "enkulu",
                "indingilizi",
                "indingilizi enkulu oluwugqinsi ebomvu",
                "o",
            ],
        },
    ],
};
#[doc = "✅"]
pub const CHECK_MARK_BUTTON: crate::Emoji = crate::Emoji {
    glyph: "✅",
    codepoint: "2705",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "check mark button",
    group: "Symbols",
    subgroup: "other-symbol",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("regmerkknoppie"),
            keywords: &["knoppie", "merk", "regmerk", "regmerkknoppie", "✓"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ነጭ ወፍራም ምልክት ማድረጊያ"),
            keywords: &["ምልክት", "ነጭ ወፍራም ምልክት ማድረጊያ", "ፈትሽ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("\u{202b}علامة تحديد بيضاء"),
            keywords: &["تحديد", "\u{202b}علامة تحديد بيضاء"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("শ\u{9c1}দ\u{9cd}ধ চিনৰ ব\u{9c1}ট\u{9be}ম"),
            keywords: &[
                "চিন",
                "পৰীক\u{9cd}ষ\u{9be} কৰ\u{9be}",
                "ব\u{9c1}ট\u{9be}ম",
                "শ\u{9c1}দ\u{9cd}ধ চিনৰ ব\u{9c1}ট\u{9be}ম",
                "✓",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("ağ qalın təsdiq işarəsi"),
            keywords: &["ağ qalın təsdiq işarəsi", "işarə", "işarələ"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("вялікая белая птушка"),
            keywords: &["белая", "вялікая белая птушка", "знак", "птушка"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Удебелена бяла отметка"),
            keywords: &["Удебелена бяла отметка", "отметка"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("স\u{9be}দ\u{9be} চেক ম\u{9be}র\u{9cd}ক বোত\u{9be}ম"),
            keywords: &[
                "চিহ\u{9cd}ন",
                "টিক চিহ\u{9cd}ন",
                "বোত\u{9be}ম",
                "স\u{9be}দ\u{9be} চেক ম\u{9be}র\u{9cd}ক বোত\u{9be}ম",
                "✓",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("bouton askañ"),
            keywords: &["ask", "bouton askañ", "✓"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("podebljana kvačica"),
            keywords: &[
                "kvačica",
                "oznaka",
                "podebljana bijela kvačica",
                "podebljana kvačica",
                "potvrđivanje",
                "✓",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("botó de marca de verificació"),
            keywords: &[
                "botó",
                "botó de marca de verificació",
                "marca",
                "selecció",
                "verificació",
                "✓",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎪᏪᎳᏅᎯ ᎠᏍᏓᏅᏅᎢ"),
            keywords: &["ᎠᏍᏓᏅᏅᎢ", "ᎤᏙᏪᎸ", "ᎪᏪᎳᏅᎯ", "✓"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("tlačítko se značkou zaškrtnutí"),
            keywords: &[
                "tlačítko",
                "tlačítko se značkou zaškrtnutí",
                "zaškrtnutí",
                "značka",
                "✓",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("marc tic gwyn trwm"),
            keywords: &["marc", "marc tic gwyn trwm", "tic", "✓"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("hvidt flueben"),
            keywords: &["hvidt flueben", "markering"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("weißes Häkchen"),
            keywords: &["abgehakt", "erledigt", "weißes Häkchen"],
        },
        #[cfg(feature = "de_CH")]
        crate::Annotation {
            lang: "de_CH",
            tts: Some("Weisses Häkchen"),
            keywords: &["Weisses Häkchen", "abgehakt", "erledigt"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κουμπί σημαδιού επιλογής"),
            keywords: &[
                "επιλογή",
                "κουμπί",
                "κουμπί σημαδιού επιλογής",
                "σημάδι",
                "✓",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("check mark button"),
            keywords: &["button", "check", "mark", "✓"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: Some("tick button"),
            keywords: &["button", "mark", "tick", "✓"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("check mark button"),
            keywords: &["button", "check", "mark", "tick", "✓"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("tick button"),
            keywords: &["button", "mark", "tick", "✓"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("botón de marca de verificación"),
            keywords: &[
                "botón",
                "botón de marca de verificación",
                "marca",
                "selección",
                "verificación",
                "✓",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &[
                "botón",
                "botón de marca de verificación",
                "marca",
                "selección",
                "verificación",
                "✓",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("märkenupp"),
            keywords: &["märge", "märkenupp", "suur valge märge"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("tiletaren botoia"),
            keywords: &["botoi", "markatu", "tilet", "tiletaren botoia", "✓"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("علامت تأیید"),
            keywords: &["دکمه", "علامت تأیید", "علامت تیک", "✓"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("valkoinen valintamerkki"),
            keywords: &[
                "V",
                "merkki",
                "rasti",
                "tarkistusmerkki",
                "valkoinen valintamerkki",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("puting tsek"),
            keywords: &["makapal", "marka", "putik", "puting tsek", "tsek"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("hvítt tjúkt flugubein"),
            keywords: &["flugubein", "hvítt tjúkt flugubein"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("bouton coché"),
            keywords: &[
                "bouton coché",
                "carré",
                "coche",
                "marque",
                "oui",
                "sélection",
                "✓",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("cnaipe ticmhairc"),
            keywords: &["cnaipe", "cnaipe ticmhairc", "marc", "tic"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("putan cromaige"),
            keywords: &["comharra", "cromag", "putan", "putan cromaige"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("caixa coa marca de verificación"),
            keywords: &[
                "ben",
                "caixa coa marca de verificación",
                "correcto",
                "marca de verificación",
                "verificación",
                "✓",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ચ\u{ac7}ક માર\u{acd}કના ચિહ\u{acd}નવાળ\u{ac1}\u{a82} બટન"),
            keywords: &[
                "ચ\u{ac7}ક",
                "ચ\u{ac7}ક માર\u{acd}કના ચિહ\u{acd}નવાળ\u{ac1}\u{a82} બટન",
                "બટન",
                "માર\u{acd}ક",
                "સફ\u{ac7}દ ચ\u{ac7}ક માર\u{acd}કના ચિહ\u{acd}નવાળ\u{ac1}\u{a82} બટન",
                "✓",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("farar alamar yarda mai nauyi"),
            keywords: &["alama", "farar alamar yarda mai nauyi", "yarda"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("סימן אישור"),
            keywords: &[
                "אישור",
                "בחירה",
                "וי",
                "כפתור אישור",
                "לחצן אישור",
                "סימן אישור",
                "סימן ביקורת",
            ],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("सफ\u{947}द च\u{947}क मार\u{94d}क, सही का चिह\u{94d}न"),
            keywords: &[
                "च\u{947}क",
                "च\u{947}क मार\u{94d}क",
                "बड\u{93c}ा च\u{947}क मार\u{94d}क",
                "सफ\u{947}द च\u{947}क मार\u{94d}क, सही का चिह\u{94d}न",
                "सही का चिह\u{94d}न",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("tipka s kvačicom"),
            keywords: &["gumb", "kvačica", "oznaka", "tipka s kvačicom", "✓"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("vastag fehér pipa"),
            keywords: &["jel", "pipa", "vastag fehér pipa"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ստուգանշանի կոճակ"),
            keywords: &[
                "թռչնիկ",
                "կոճակ",
                "նշան",
                "ստուգանշան",
                "ստուգանշանի կոճակ",
                "✓",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("tanda centang putih tebal"),
            keywords: &["centang", "tanda", "tanda centang putih tebal"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("nnukwu ntule akara ọcha"),
            keywords: &["akara", "nnukwu ntule akara ọcha", "ntule"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("hakmerki"),
            keywords: &["hak", "hakmerki", "hnappur", "merki"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("pulsante segno di spunta"),
            keywords: &[
                "baffo",
                "pulsante segno di spunta",
                "segno di spunta",
                "segno di spunta grande",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("白抜きのチェック"),
            keywords: &["チェック", "チェックマーク", "白抜きのチェック", "記号"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("tombol tenger centhang"),
            keywords: &["centhang", "tenger", "tombol", "✓"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მსხვილი თეთრი მონიშვნის ნიშანი"),
            keywords: &["მონიშვნა", "მსხვილი თეთრი მონიშვნის ნიშანი", "ნიშანი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("Ақ, қалың құсбелгі"),
            keywords: &["Ақ, қалың құсбелгі", "белгі", "құсбелгі"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("flueben"),
            keywords: &["flueben", "markering"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("សញ\u{17d2}ញាគ\u{17d2}រ\u{17b8}ស"),
            keywords: &[
                "គ\u{17d2}រ\u{17b8}ស",
                "ធ\u{17b8}ក",
                "ប\u{17ca}\u{17bc}ត\u{17bb}ង",
                "សញ\u{17d2}ញា",
                "សញ\u{17d2}ញាគ\u{17d2}រ\u{17b8}ស",
                "✓",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಚ\u{cc6}ಕ\u{ccd} ಗುರುತು ಬಟನ\u{ccd}"),
            keywords: &[
                "ಗುರುತು",
                "ಚ\u{cc6}ಕ\u{ccd} ಗುರುತು ಬಟನ\u{ccd}",
                "ಪರ\u{cbf}ಶೀಲ\u{cbf}ಸ\u{cbf}",
                "ಬಟನ\u{ccd}",
                "✓",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("체크 표시"),
            keywords: &["체크", "체크 표시"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("तपासणी चिन\u{94d}न ख\u{942}ण"),
            keywords: &[
                "चिन\u{94d}न",
                "तपासणी",
                "तपासणी चिन\u{94d}न ख\u{942}ण",
                "बटण",
                "✓",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("ак «туура» белгиси"),
            keywords: &[
                "ак «туура» белгиси",
                "ак «чымчыкча» белгиси",
                "белги",
                "чымчыкча",
            ],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("fettgedréckte wäisse Kreepchen"),
            keywords: &["Kreepchen", "Krop", "fettgedréckte wäisse Kreepchen"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເຄ\u{eb7}\u{ec8}ອງໝາຍຕ\u{eb4}ກ"),
            keywords: &[
                "ສ\u{eb5}ຂາວ",
                "ເຄ\u{eb7}\u{ec8}ອງໝາຍຕ\u{eb4}ກ",
                "ເຄ\u{eb7}\u{ec8}ອງໝາຍຕ\u{eb4}ກສ\u{eb5}ຂາວໃຫຍ\u{ec8}ໜາ",
                "ໃຫຍ\u{ec8}ໜາ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("balta paryškinta varnelė"),
            keywords: &["balta paryškinta varnelė", "varnelė", "žymė"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("balta kontrolzīme"),
            keywords: &["atzīme", "balta kontrolzīme", "ķeksītis", "✓"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tohu taki mā taumaha"),
            keywords: &["taki", "tohu", "tohu taki mā taumaha"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("копче за штиклирање"),
            keywords: &["копче", "копче за штиклирање", "штиклирање", "✓"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("വെള\u{d41}ത\u{d4d}ത ചെക\u{d4d}ക\u{d4d} അടയ\u{d3e}ളം"),
            keywords: &[
                "അടയ\u{d3e}ളം",
                "ചെക\u{d4d}ക\u{d4d}",
                "ചെക\u{d4d}ക\u{d4d} മ\u{d3e}ർക\u{d4d}ക\u{d4d}",
                "വെള\u{d41}ത\u{d4d}ത ചെക\u{d4d}ക\u{d4d} അടയ\u{d3e}ളം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("цагаан зөвлөх тэмдэг"),
            keywords: &["зөвлөх", "тэмдэг", "цагаан"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("च\u{947}क क\u{947}ल\u{94d}याच\u{947} पा\u{902}ढर\u{947} चिन\u{94d}ह"),
            keywords: &[
                "चिन\u{94d}ह",
                "च\u{947}क",
                "च\u{947}क क\u{947}ल\u{94d}याच\u{947} पा\u{902}ढर\u{947} चिन\u{94d}ह",
                "बटण",
                "✓",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("butang tanda rait"),
            keywords: &["butang", "rait", "tanda", "✓"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("marka ta’ verifika bajda grassett"),
            keywords: &["marka", "marka ta’ verifika bajda grassett", "verifika"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အကြ\u{102e}းစား ခြစ\u{103a}မ\u{103e}တ\u{103a}ဖြ\u{1030}"),
            keywords: &[
                "အကြ\u{102e}းစား ခြစ\u{103a}မ\u{103e}တ\u{103a}ဖြ\u{1030}",
                "အကြ\u{102e}းစား အမ\u{103e}န\u{103a}ခြစ\u{103a}မ\u{103e}တ\u{103a}ဖြ\u{1030}",
                "အမ\u{103e}တ\u{103a}",
                "အမ\u{103e}န\u{103a}ခြစ\u{103a}မ\u{103e}တ\u{103a} သင\u{103a}\u{1039}ကေတ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("hakemerke i firkant"),
            keywords: &[
                "avkryssing",
                "avmerking",
                "hake",
                "hakemerke i firkant",
                "✓",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("स\u{947}तो भारी ठ\u{942}लो चिन\u{94d}ह"),
            keywords: &[
                "चिन\u{94d}ह",
                "जा\u{901}च",
                "स\u{947}तो भारी ठ\u{942}लो चिन\u{94d}ह",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("knop voor vinkje"),
            keywords: &["knop", "knop voor vinkje", "teken", "vinkje", "✓"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("hakemerke i firkant"),
            keywords: &[
                "avkryssing",
                "avmerking",
                "hake",
                "hakemerke i firkant",
                "✓",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଚେକ ମ\u{b3e}ର\u{b4d}କ ବଟନ"),
            keywords: &["ଚେକ", "ବଟନ", "ମ\u{b3e}ର\u{b4d}କ", "✓"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਠੀਕ ਦਾ ਵ\u{a71}ਡਾ ਚਿ\u{a70}ਨ\u{a4d}ਹ"),
            keywords: &[
                "ਠੀਕ",
                "ਠੀਕ ਚਿ\u{a70}ਨ\u{a4d}ਹ",
                "ਠੀਕ ਦਾ ਵ\u{a71}ਡਾ ਚਿ\u{a70}ਨ\u{a4d}ਹ",
                "ਭਾਰੀ ਠੀਕ ਚਿ\u{a70}ਨ\u{a4d}ਹ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("چیٹ\u{651}ا بوجھل پڑتال دا نشان"),
            keywords: &["نشان لانا", "پڑتال کرنا", "چیٹ\u{651}ا بوجھل پڑتال دا نشان"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Chẹ\u{301}k Mák Bọ\u{301}tin"),
            keywords: &[
                "Bọ\u{301}tin",
                "Chẹk",
                "Chẹ\u{301}k Mák Bọ\u{301}tin",
                "Gud",
                "Mak",
                "✓",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("przycisk ze znacznikiem wyboru"),
            keywords: &[
                "parafka",
                "przycisk ze znacznikiem wyboru",
                "ptaszek",
                "zaznaczenie",
                "znacznik wyboru",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د خوښنښې بټن"),
            keywords: &["بټن", "د خوښنښې بټن", "نښه", "چيک", "✓"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("marca de seleção branca"),
            keywords: &[
                "botão",
                "marca",
                "marca de seleção branca",
                "verificação",
                "✓",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("botão de visto"),
            keywords: &["botão", "botão de visto", "visto", "✓"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("buton de bifă"),
            keywords: &["bifă", "buton", "buton de bifă", "✓"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-122"),
            keywords: &["E10-122"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("белая галочка"),
            keywords: &["белая", "галочка", "знак"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ikimenyetso kinini cy’umweru cyo kuvivura"),
            keywords: &[
                "akarango",
                "ikimenyetso kinini cy’umweru cyo kuvivura",
                "ivivura",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("چيڪ مارڪ بٽڻ"),
            keywords: &["بٽڻ", "مارڪ", "چيڪ", "✓"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ස\u{dd4}ද\u{dd4} බර හර\u{dd2} ලක\u{dd4}ණ"),
            keywords: &[
                "ලක\u{dd4}ණ",
                "ස\u{dd4}ද\u{dd4} බර හර\u{dd2} ලක\u{dd4}ණ",
                "හර\u{dd2}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("začiarkavacie políčko"),
            keywords: &["začiarkavacie políčko", "začiarknutie", "začiarknuť", "✓"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("gumb s kljukico"),
            keywords: &["gumb", "gumb s kljukico", "kljukica", "potrditev", "✓"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("badhanka calaamadda sax"),
            keywords: &[
                "badhan",
                "badhanka calaamadda sax",
                "calaamad",
                "calaamadee",
                "✓",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("shenja e zgjedhjes e bardhë e trashë"),
            keywords: &["shenja e zgjedhjes e bardhë e trashë", "shenjë", "zgjedhje"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("дугме са знаком потврде"),
            keywords: &["дугме са знаком потврде", "знaк", "потврда"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("dugme sa znakom potvrde"),
            keywords: &["dugme sa znakom potvrde", "potvrda", "znak"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("vit bockmarkering"),
            keywords: &["bock", "vit bockmarkering", "vit fet bockmarkering"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("alama nyeupe ya tiki"),
            keywords: &[
                "alama nyeupe ya tiki",
                "kitufe",
                "tia tiki",
                "tiki nyeupe",
                "✓",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("அடர\u{bcd}வெள\u{bcd}ளை நிற டிக\u{bcd} சின\u{bcd}னம\u{bcd}"),
            keywords: &[
                "அடர\u{bcd}வெள\u{bcd}ளை நிற டிக\u{bcd} சின\u{bcd}னம\u{bcd}",
                "டிக\u{bcd} செய\u{bcd}யவும\u{bcd}",
                "டிக\u{bcd} ம\u{bbe}ர\u{bcd}க\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("తన\u{c3f}ఖ\u{c40} గుర\u{c4d}తు బటన\u{c4d}"),
            keywords: &["గుర\u{c4d}తు", "తన\u{c3f}ఖ\u{c40}", "బటన\u{c4d}", "✓"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("аломати вазнини қайди сафед"),
            keywords: &["аломат", "аломати вазнини қайди сафед", "қайд"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ป\u{e38}\u{e48}มเคร\u{e37}\u{e48}องหมายถ\u{e39}ก"),
            keywords: &[
                "ป\u{e38}\u{e48}ม",
                "ป\u{e38}\u{e48}มเคร\u{e37}\u{e48}องหมายถ\u{e39}ก",
                "เคร\u{e37}\u{e48}องหมาย",
                "เคร\u{e37}\u{e48}องหมายถ\u{e39}ก",
                "✓",
            ],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ምልክት መልጎም ኣረጋግጽ"),
            keywords: &["መልጎም", "ምልክት", "ኣረጋግጽ", "✓"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("barlag belligi düwmesi"),
            keywords: &["barlag", "barlag belligi düwmesi", "bellik", "düwme", "✓"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("fakaʻilonga sivi hinehina"),
            keywords: &["fakaʻilonga", "fakaʻilonga sivi hinehina", "sivi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("onay işareti düğmesi"),
            keywords: &["düğme", "işaret", "onay", "onay işareti düğmesi", "✓"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئاق ئېغىر توغرا بەلگىسى"),
            keywords: &["ئاق ئېغىر توغرا بەلگىسى", "بەلگە", "تاللاش"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("кнопка з галочкою"),
            keywords: &[
                "галочка",
                "кнопка",
                "кнопка з галочкою",
                "опція",
                "позначка",
                "✓",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("سفید بھاری چیک کا نشان"),
            keywords: &["بٹن", "سفید بھاری چیک کا نشان", "علامت", "چیک", "✓"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("belgilash tugmasi belgisi"),
            keywords: &[
                "belgi",
                "belgilash",
                "belgilash tugmasi belgisi",
                "tugma",
                "✓",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("dấu chọn đậm màu trắng"),
            keywords: &["chọn", "dấu", "dấu chọn đậm màu trắng", "nút", "✓"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("màndarga nangu bu weex te rëy"),
            keywords: &["marke", "màndarga nangu bu weex te rëy", "xàmme"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("uphawu lokuhlola olungqindilili olumhlophe"),
            keywords: &[
                "khetha",
                "uphawu",
                "uphawu lokuhlola olungqindilili olumhlophe",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("maaki iṣayewo funfun nla"),
            keywords: &["maaki iṣayewo funfun nla", "àmì", "àyẹ\u{300}wò"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("白色粗剔號"),
            keywords: &["✓", "剔號", "按鈕", "標誌", "白色粗剔號"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("白色粗剔号"),
            keywords: &["剔号", "标志", "白色粗剔号"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("勾号按钮"),
            keywords: &["勾", "勾号", "勾号按钮", "打勾", "按钮"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("白色勾勾"),
            keywords: &["勾號", "白色勾勾"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("白色勾"),
            keywords: &["剔", "剔號", "白色勾"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("uphawu lokuhlola okukhulu"),
            keywords: &[
                "inkinobho",
                "ukuhlola",
                "uphawo",
                "uphawu lokuhlola okukhulu",
                "✓",
            ],
        },
    ],
};
#[doc = "☑\u{fe0f}"]
pub const CHECK_BOX_WITH_CHECK: crate::Emoji = crate::Emoji {
    glyph: "☑\u{fe0f}",
    codepoint: "2611 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "check box with check",
    group: "Symbols",
    subgroup: "other-symbol",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "☑",
        codepoint: "2611",
        status: crate::Status::Unqualified,
        introduction_version: 0.6f32,
        name: "check box with check",
        group: "Symbols",
        subgroup: "other-symbol",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("merkblokkie met regmerk"),
            keywords: &["blokkie", "merkblokkie met regmerk", "regmerk", "✓"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የድምፅ መስጫ ሳጥን ከምልክት ማድረጊያ ጋር"),
            keywords: &["ሣጥን", "የድምፅ መስጫ ሳጥን ከምልክት ማድረጊያ ጋር", "የድምፅ ካርድ", "ፈትሽ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("مربع اقتراع محدد"),
            keywords: &["اختيار", "اقتراع", "مربع", "مربع اقتراع محدد"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("শ\u{9c1}দ\u{9cd}ধ চিনৰ পৰীক\u{9cd}ষণ ব\u{9be}কচ"),
            keywords: &[
                "পৰীক\u{9cd}ষ\u{9be} কৰ\u{9be}",
                "ব\u{9be}কচ",
                "শ\u{9c1}দ\u{9cd}ধ চিনৰ পৰীক\u{9cd}ষণ ব\u{9be}কচ",
                "✓",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("təsdiqlənmiş seçki qutusu"),
            keywords: &["işarələ", "qutu", "seçki", "təsdiqlənmiş seçki qutusu"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("квадрат з птушкай"),
            keywords: &["адзнака", "квадрат з птушкай", "клетка", "птушка"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Урна за гласуване с отметка"),
            keywords: &[
                "Урна за гласуване с отметка",
                "гласуване",
                "кутия",
                "отметка",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("চেকের স\u{9be}থে ব\u{9cd}য\u{9be}লট বক\u{9cd}স"),
            keywords: &[
                "চেক",
                "চেকের স\u{9be}থে চেক বক\u{9cd}স",
                "চেকের স\u{9be}থে ব\u{9cd}য\u{9be}লট বক\u{9cd}স",
                "বক\u{9cd}স",
                "✓",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("log asket"),
            keywords: &["ask", "log asket", "✓"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("polje za potvrdu s kvačicom"),
            keywords: &[
                "kvačica",
                "polje za potvrdu",
                "polje za potvrdu s kvačicom",
                "✓",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("casella amb marca de verificació"),
            keywords: &[
                "casella",
                "casella amb marca de verificació",
                "selecció",
                "verificació",
                "✓",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎪᏪᎳᏅᎯ ᎧᏁᏌᎢ"),
            keywords: &["ᎧᏁᏌᎢ", "ᎪᏪᎳᏅᎯ", "✓"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("zaškrtnuté políčko"),
            keywords: &["okénko", "políčko", "zaškrtnuté políčko", "zaškrtnutí", "✓"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("blwch pleidlais gyda thic"),
            keywords: &[
                "blwch",
                "blwch pleidlais gyda thic",
                "pleidlais",
                "tic",
                "✓",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("afkrydsningsfelt med flueben"),
            keywords: &["afkrydsningsfelt med flueben", "felt", "flueben", "✓"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("abgehaktes Kästchen"),
            keywords: &[
                "Feld",
                "Kästchen",
                "Kästchen mit Häkchen",
                "abgehaktes Kästchen",
                "✓",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("πλαίσιο επιλογής με σημάδι επιλογής"),
            keywords: &[
                "επιλογή",
                "πλαίσιο",
                "πλαίσιο επιλογής με σημάδι επιλογής",
                "✓",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("check box with check"),
            keywords: &["box", "check", "check box with check", "✓"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: Some("tick box with tick"),
            keywords: &["box", "tick", "tick box with tick", "✓"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["ballot", "box", "tick", "tick box with tick"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("check box with check"),
            keywords: &[
                "box",
                "check",
                "check box with check",
                "tick",
                "tick box with tick",
                "✓",
            ],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("tick box with tick"),
            keywords: &["box", "tick", "tick box with tick", "✓"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("casilla con marca de verificación"),
            keywords: &[
                "casilla",
                "casilla con marca de verificación",
                "marca",
                "selección",
                "verificación",
                "✓",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("casilla seleccionada"),
            keywords: &[
                "casilla",
                "casilla con marca de verificación",
                "casilla seleccionada",
                "marca",
                "selección",
                "verificación",
                "✓",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &[
                "casilla",
                "casilla seleccionada",
                "marca",
                "selección",
                "verificación",
                "✓",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("märgitud ruut"),
            keywords: &["märge", "märgitud ruut"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("tileta duen koadroa"),
            keywords: &["koadro", "tilet", "tileta duen koadroa", "✓"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("مربع با علامت تیک"),
            keywords: &[
                "علامت تأیید",
                "علامت تیک",
                "مربع انتخاب با تیک",
                "مربع با علامت تیک",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("punainen valintamerkki"),
            keywords: &[
                "V",
                "merkki",
                "punainen valintamerkki",
                "rasti",
                "tarkistusmerkki",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("balotang may tsek"),
            keywords: &["balota", "balotang may tsek", "kahon", "tsek"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("flugubein í fýrakanti"),
            keywords: &["flugubein", "flugubein í fýrakanti", "fýrakantur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("case cochée"),
            keywords: &[
                "bouton",
                "carré",
                "case cochée",
                "coche",
                "oui",
                "sélection",
                "✓",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("bosca ballóide le tic"),
            keywords: &["bosca", "bosca ballóide le tic", "tic"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("bogsa-cromaige le cromag"),
            keywords: &["bogsa", "bogsa-cromaige le cromag", "cromag"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("recadro con marca de verificación"),
            keywords: &[
                "marca",
                "recadro",
                "recadro con marca de verificación",
                "verificación",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ચ\u{ac7}ક માર\u{acd}કના ચિહ\u{acd}નવાળ\u{ac1}\u{a82} ચ\u{ac7}ક બૉક\u{acd}સ"),
            keywords: &[
                "ચ\u{ac7}ક",
                "ચ\u{ac7}ક માર\u{acd}કના ચિહ\u{acd}નવાળ\u{ac1}\u{a82} ચ\u{ac7}ક બૉક\u{acd}સ",
                "ચ\u{ac7}કના ચિહ\u{acd}નવાળ\u{ac1}\u{a82} ચ\u{ac7}ક બૉક\u{acd}સ",
                "બૉક\u{acd}સ",
                "✓",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("akwatin ƙuri’a mai alamar yarda"),
            keywords: &[
                "akwati",
                "akwatin ƙuri’a mai alamar yarda",
                "yarda",
                "ƙuri’a",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("סימן אישור בתוך משבצת"),
            keywords: &[
                "לסמן",
                "סימון",
                "סימן אישור בתוך משבצת",
                "סימן ביקורת בתוך משבצת",
                "קלפי",
                "תיבה",
                "תיבת קלפי עם סימן ביקורת",
            ],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("च\u{947}क क\u{947} साथ मतपत\u{94d}र, मतपत\u{94d}र"),
            keywords: &[
                "च\u{947}क क\u{947} साथ मतपत\u{94d}र",
                "च\u{947}क क\u{947} साथ मतपत\u{94d}र, मतपत\u{94d}र",
                "बॉक\u{94d}स",
                "मतपत\u{94d}र",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("potvrdni okvir s kvačicom"),
            keywords: &["okvir", "potvrda", "potvrdni okvir s kvačicom", "✓"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("jelölőnégyzet pipával"),
            keywords: &["jelölőnégyzet pipával", "négyzet", "pipa", "szavazás"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("նշված վանդակ"),
            keywords: &["թռչնիկ", "նշավանդակ", "նշված վանդակ", "վանդակ", "✓"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("kotak bercentang"),
            keywords: &["centang", "kotak", "kotak bercentang"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("igbe igbe ngụ nwere ntule"),
            keywords: &["igbe", "igbe igbe ngụ nwere ntule", "igbe ngụ", "ntule"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("hakreitur með hakmerki"),
            keywords: &[
                "hak",
                "hakreitur með haki",
                "hakreitur með hakmerki",
                "reitur",
                "✓",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("riquadro con spunta"),
            keywords: &["grigio", "riquadro", "riquadro con spunta", "spunta"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("チェックボックス"),
            keywords: &["チェック", "チェックボックス", "チェックマーク", "記号"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("kothak centhang ana centhange"),
            keywords: &["centhang", "kothak", "kothak centhang ana centhange", "✓"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მონიშნული მოსანიშნი უჯრა"),
            keywords: &["მონიშვნა", "მონიშნული მოსანიშნი უჯრა", "ყუთი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("Құсбелгісі бар дауыс беру шаршысы"),
            keywords: &[
                "дауыс беру",
                "орын",
                "Құсбелгісі бар дауыс беру шаршысы",
                "құсбелгі",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("afkrydsningsfelt med flueben"),
            keywords: &[
                "afkrydsning",
                "afkrydsningsfelt med flueben",
                "flueben",
                "markere",
                "stemme",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ប\u{17d2}រអប\u{17cb}ធ\u{17b8}កដែលមានសញ\u{17d2}ញាធ\u{17b8}ក"),
            keywords: &[
                "ធ\u{17b8}ក",
                "ប\u{17d2}រអប\u{17cb}",
                "ប\u{17d2}រអប\u{17cb}ធ\u{17b8}កដែលមានសញ\u{17d2}ញាធ\u{17b8}ក",
                "✓",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some(
                "ಚ\u{cc6}ಕ\u{ccd}\u{200c}ನೊಂದ\u{cbf}ಗ\u{cc6} ಚ\u{cc6}ಕ\u{ccd} ಬಾಕ\u{ccd}ಸ\u{ccd}",
            ),
            keywords: &[
                "ಚ\u{cc6}ಕ\u{ccd} ಜೊತ\u{cc6}ಗ\u{cc6} ಚ\u{cc6}ಕ\u{ccd} ಬಾಕ\u{ccd}ಸ\u{ccd}",
                "ಚ\u{cc6}ಕ\u{ccd}\u{200c}ನೊಂದ\u{cbf}ಗ\u{cc6} ಚ\u{cc6}ಕ\u{ccd} ಬಾಕ\u{ccd}ಸ\u{ccd}",
                "ಪರ\u{cbf}ಶೀಲ\u{cbf}ಸ\u{cbf}",
                "ಬಾಕ\u{ccd}ಸ\u{ccd}",
                "✓",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("체크박스"),
            keywords: &["체크박스", "체크상자", "체크표시된 투표란", "투표"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("तपास चिन\u{94d}ना सयत तपासणी बॉक\u{94d}स"),
            keywords: &[
                "तपास चिन\u{94d}ना सयत तपासणी बॉक\u{94d}स",
                "तपासणी",
                "तपासणी चिन\u{94d}ना सयत तपासणी बॉक\u{94d}स",
                "बॉक\u{94d}स",
                "✓",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("«чымчыкча» белгиси менен кутуча"),
            keywords: &[
                "«туура» белгиси менен кутуча",
                "«чымчыкча» белгиси менен кутуча",
                "белги",
                "кутуча",
            ],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Urn mat Kreepchen"),
            keywords: &["Kreepchen", "Krop", "Këscht", "Urn", "Urn mat Kreepchen"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ປ\u{ec8}ອງມ\u{eb5}ເຄ\u{eb7}\u{ec8}ອງໝາຍຖ\u{eb7}ກ"),
            keywords: &[
                "ກ\u{ec8}ອງ",
                "ກ\u{ec8}ອງໝາຍ",
                "ປ\u{ec8}ອງມ\u{eb5}ເຄ\u{eb7}\u{ec8}ອງໝາຍຖ\u{eb7}ກ",
                "ໝາຍຖ\u{eb7}ກ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("balsavimo laukelis su varnele"),
            keywords: &[
                "balsavimas",
                "balsavimo laukelis su varnele",
                "laukelis",
                "varnelė",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("atzīmēta izvēles rūtiņa"),
            keywords: &[
                "atzīme",
                "atzīmēta izvēles rūtiņa",
                "rūtiņa",
                "ķeksītis",
                "✓",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pouaka pōti whai taki"),
            keywords: &["pouaka", "pouaka pōti whai taki", "pōti", "taki"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("штиклирано поле"),
            keywords: &["поле", "штиклирано поле", "штиклирање", "✓"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some(
                "ചെക\u{d4d}ക\u{d4d} അടയ\u{d3e}ളമ\u{d41}ള\u{d4d}ള ബ\u{d3e}ലറ\u{d4d}റ\u{d4d} പെട\u{d4d}ടി",
            ),
            keywords: &[
                "ചെക\u{d4d}ക\u{d4d} അടയ\u{d3e}ളം",
                "ചെക\u{d4d}ക\u{d4d} അടയ\u{d3e}ളമ\u{d41}ള\u{d4d}ള ബ\u{d3e}ലറ\u{d4d}റ\u{d4d} പെട\u{d4d}ടി",
                "പരിശോധന",
                "ബ\u{d3e}ലറ\u{d4d}റ\u{d4d} പെട\u{d4d}ടി",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("дөрвөлжинд байгаа зөвлөх тэмдэг"),
            keywords: &[
                "дөрвөлжин",
                "дөрвөлжинд байгаа зөвлөх тэмдэг",
                "зөвлөх",
                "тэмдэг",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("च\u{947}कबॉक\u{94d}ससह च\u{947}क"),
            keywords: &[
                "च\u{947}क",
                "च\u{947}कबॉक\u{94d}ससह च\u{947}क",
                "बॉक\u{94d}स",
                "✓",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("peti undi dengan tanda semak"),
            keywords: &[
                "kotak",
                "peti undi dengan tanda rait",
                "peti undi dengan tanda semak",
                "rait",
                "✓",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("kaxxa tal-votazzjoni b’marka"),
            keywords: &[
                "kaxxa",
                "kaxxa tal-votazzjoni b’marka",
                "marka",
                "votazzjoni",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "ခြစ\u{103a}မ\u{103e}တ\u{103a}ပါသည\u{1037}\u{103a} မ\u{1032}ပ\u{102f}\u{1036}း",
            ),
            keywords: &[
                "ခြစ\u{103a}မ\u{103e}တ\u{103a}ပါ မ\u{1032}ပ\u{102f}\u{1036}း",
                "ခြစ\u{103a}မ\u{103e}တ\u{103a}ပါသည\u{1037}\u{103a} မ\u{1032}ပ\u{102f}\u{1036}း",
                "မ\u{1032}ပ\u{102f}\u{1036}း",
                "အမ\u{103e}န\u{103a}ခြစ\u{103a}မ\u{103e}တ\u{103a}",
                "အမ\u{103e}န\u{103a}ခြစ\u{103a}မ\u{103e}တ\u{103a} သင\u{103a}\u{1039}ကေတ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("boks med hakemerke"),
            keywords: &[
                "avkrysset boks",
                "boks",
                "boks med hakemerke",
                "hakemerke",
                "✓",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("च\u{947}कको साथ मतदान बक\u{94d}स"),
            keywords: &[
                "च\u{947}कको साथ मतदान बक\u{94d}स",
                "जा\u{901}च",
                "बक\u{94d}स",
                "मतदान",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("vinkje in vak"),
            keywords: &["vak", "vinkje", "vinkje in vak", "✓"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("boks med hakemerke"),
            keywords: &[
                "avkryssa boks",
                "boks",
                "boks med hakemerke",
                "hakemerke",
                "✓",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଚେକ ସହ\u{b3f}ତ ଚେକ ବକ\u{b4d}ସ"),
            keywords: &["ଚେକ", "ଚେକ ସହ\u{b3f}ତ ଚେକ ବକ\u{b4d}ସ", "ବକ\u{b4d}ସ"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਨਿਸ\u{a3c}ਾਨ ਵਾਲੀ ਮਤਦਾਨ ਪ\u{a47}ਟੀ"),
            keywords: &[
                "ਚ\u{a48}\u{a71}ਕ ਚਿ\u{a70}ਨ\u{a4d}ਹ",
                "ਨਿਸ\u{a3c}ਾਨ ਵਾਲੀ ਮਤਦਾਨ ਪ\u{a47}ਟੀ",
                "ਬਕਸਾ",
                "ਬ\u{a48}ਲਟ",
                "ਮਤਦਾਨ ਪ\u{a47}ਟੀ",
                "ਸਹੀ ਦਾ ਨਿਸ\u{a3c}ਾਨ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("پڑتال نال بیلٹ باکس"),
            keywords: &[
                "مخفی رائے دہی آلی پرچی",
                "پڑتال نال بیلٹ باکس",
                "پڑتال کرنا",
                "ڈبہ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Chẹ\u{301}k Bọks Wit Chẹk"),
            keywords: &[
                "Bọks",
                "Chẹk",
                "Chẹ\u{301}k Bọks Wit Chẹk",
                "Gud",
                "Gúd Bọks Wit Gud",
                "✓",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("pole ze znacznikiem wyboru"),
            keywords: &[
                "parafka",
                "pole ze znacznikiem wyboru",
                "ptaszek",
                "zaznaczenie",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("چيک بوکسه د چيک سره"),
            keywords: &["بوکسه", "چيک", "چيک بوکسه د چيک سره", "✓"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("caixa de seleção marcada com tique"),
            keywords: &[
                "caixa",
                "caixa de seleção marcada com tique",
                "marca de verificação",
                "✓",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("caixa com visto"),
            keywords: &["caixa", "caixa com visto", "visto"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("casetă de votare bifată"),
            keywords: &["bifă", "casetă", "casetă de votare bifată", "vot"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-047"),
            keywords: &["E10-047"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("галочка в квадрате"),
            keywords: &[
                "бюллетень",
                "бюллетень с галочкой",
                "выполнено",
                "галочка",
                "галочка в квадрате",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("Agasanduku k’amatora bifashisha mu kubara amajwi"),
            keywords: &[
                "Agasanduku k’amatora bifashisha mu kubara amajwi",
                "agasanduku gashyirwamo impapuro z’itora",
                "kugenzura",
                "urupapuro rw’itora",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("چيڪ سان چيڪ باڪس"),
            keywords: &["باڪس", "چيڪ", "چيڪ سان چيڪ باڪس", "✓"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("හර\u{dd2} ලක\u{dd4}ණ සහ\u{dd2}ත ඡන\u{dca}ද පෙට\u{dca}ට\u{dd2}ය"),
            keywords: &[
                "ඡන\u{dca}ද",
                "පෙට\u{dca}ට\u{dd2}ය",
                "ලක\u{dd4}ණ",
                "හර\u{dd2} ලක\u{dd4}ණ සහ\u{dd2}ත ඡන\u{dca}ද පෙට\u{dca}ට\u{dd2}ය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("začiarknuté políčko"),
            keywords: &[
                "začiarknutie",
                "začiarknuté",
                "začiarknuté políčko",
                "začiarknuť",
                "✓",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("potrditveno polje s kljukico"),
            keywords: &[
                "kljukica",
                "polje",
                "potrditveno polje s kjukico",
                "potrditveno polje s kljukico",
                "✓",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("ku calaamadee sanduuqa sax"),
            keywords: &["calaamadee", "ku calaamadee sanduuqa sax", "sanduuq", "✓"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("kutia e votimit me shenjën e zgjedhjes"),
            keywords: &[
                "kuti",
                "kutia e votimit me shenjën e zgjedhjes",
                "votim",
                "votë",
                "zgjedhje",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("опција са знаком потврде"),
            keywords: &["oквир", "знaк", "опција", "опција са знаком потврде"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("opcija sa znakom potvrde"),
            keywords: &["okvir", "opcija", "opcija sa znakom potvrde", "znak"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("kryssruta med bockmarkering"),
            keywords: &[
                "avbockad",
                "bock",
                "kryssruta",
                "kryssruta med bock",
                "kryssruta med bockmarkering",
            ],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("sanduku la kuteua lenye tiki"),
            keywords: &["sanduku", "sanduku la kuteua lenye tiki", "tia tiki", "✓"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("டிக\u{bcd} செய\u{bcd}த வ\u{bbe}க\u{bcd}குப\u{bcd} பெட\u{bcd}டி"),
            keywords: &[
                "டிக\u{bcd} செய\u{bcd}த வ\u{bbe}க\u{bcd}குப\u{bcd} பெட\u{bcd}டி",
                "டிக\u{bcd} ம\u{bbe}ர\u{bcd}க\u{bcd}",
                "பெட\u{bcd}டி",
                "வ\u{bbe}க\u{bcd}குப\u{bcd} பெட\u{bcd}டி",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some(
                "బ\u{c4d}య\u{c3e}ల\u{c46}ట\u{c4d} ప\u{c46}ట\u{c4d}ట\u{c46}ల\u{c4b} తన\u{c3f}ఖ\u{c40} గుర\u{c4d}తు",
            ),
            keywords: &[
                "ఎంప\u{c3f}క",
                "ప\u{c46}ట\u{c4d}ట\u{c46}",
                "బ\u{c4d}య\u{c3e}ల\u{c46}ట\u{c4d}",
                "బ\u{c4d}య\u{c3e}ల\u{c46}ట\u{c4d} ప\u{c46}ట\u{c4d}ట\u{c46}ల\u{c4b} తన\u{c3f}ఖ\u{c40} గుర\u{c4d}తు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("қуттии бюллетенҳо бо қайд"),
            keywords: &["бюллетен", "қайд", "қуттии бюллетенҳо бо қайд", "қуттӣ"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some(
                "กล\u{e48}องกาเคร\u{e37}\u{e48}องหมายม\u{e35}เคร\u{e37}\u{e48}องหมายถ\u{e39}ก",
            ),
            keywords: &[
                "กล\u{e48}อง",
                "กล\u{e48}องกาเคร\u{e37}\u{e48}องหมายม\u{e35}เคร\u{e37}\u{e48}องหมายถ\u{e39}ก",
                "เคร\u{e37}\u{e48}องหมายถ\u{e39}ก",
                "✓",
            ],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ነቲ ሳንዱቕ ኣረጋግጾ"),
            keywords: &["ሳንዱቕ", "ነቲ ሳንዱቕ ኣረጋግጾ", "ኣረጋግጾ", "✓"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("barlag bellikli barlag gutusy"),
            keywords: &["barlag", "barlag bellikli barlag gutusy", "guty", "✓"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("puha fili moe fakaʻilonga sivi"),
            keywords: &[
                "fakaʻilonga",
                "fili",
                "puha",
                "puha fili moe fakaʻilonga sivi",
                "sivi",
            ],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("seçilmiş onay kutusu"),
            keywords: &[
                "kutu",
                "kutulu",
                "onay",
                "seçili onay işareti",
                "seçilmiş onay kutusu",
                "✓",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("تاللانغان بېلەت ساندۇقى"),
            keywords: &["بېلەت", "تاللاش", "تاللانغان بېلەت ساندۇقى", "ساندۇق"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("клітинка з галочкою"),
            keywords: &[
                "відмічена клітинка",
                "галочка",
                "клітина",
                "клітинка з галочкою",
                "позначка",
                "✓",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("چیک کے نشان والا بیلٹ باکس"),
            keywords: &[
                "خانہ",
                "چیک",
                "چیک کے ساتھ چیک باکس",
                "چیک کے نشان والا بیلٹ باکس",
                "✓",
            ],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("belgilangan belgilash maydonchasi"),
            keywords: &[
                "belgilangan belgilash maydonchasi",
                "belgilash",
                "maydoncha",
                "✓",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("hộp kiểm có dấu chọn"),
            keywords: &["chọn", "hộp", "hộp kiểm có dấu chọn", "✓"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("kaasu boyet ak xàmme"),
            keywords: &["boyet", "kaas", "kaasu boyet ak xàmme", "xàmme"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ibhokisi yebhalothi yokhetho"),
            keywords: &[
                "ibhalothi",
                "ibhokisi",
                "ibhokisi yebhalothi yokhetho",
                "khetha",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("àyẹ\u{300}wò àpótí ìdìbò"),
            keywords: &[
                "àpótí",
                "àpótí ìdìbò",
                "àyẹ\u{300}wò",
                "àyẹ\u{300}wò àpótí ìdìbò",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("有剔嘅選框"),
            keywords: &["✓", "剔號", "有剔嘅選框", "盒", "選框"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("有剔嘅选框"),
            keywords: &["剔号", "有剔嘅选框", "盒", "选框"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("勾选框"),
            keywords: &["勾号", "勾选框", "复选框", "带勾方格", "打勾"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("勾選"),
            keywords: &["勾號", "勾選"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("剔選"),
            keywords: &["剔號", "剔選"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ibhokisi lebhalothi elinokuhlola"),
            keywords: &[
                "ibhalothi",
                "ibhokisi",
                "ibhokisi lebhalothi elinokuhlola",
                "ukuhlola",
            ],
        },
    ],
};
#[doc = "✔\u{fe0f}"]
pub const CHECK_MARK: crate::Emoji = crate::Emoji {
    glyph: "✔\u{fe0f}",
    codepoint: "2714 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "check mark",
    group: "Symbols",
    subgroup: "other-symbol",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "✔",
        codepoint: "2714",
        status: crate::Status::Unqualified,
        introduction_version: 0.6f32,
        name: "check mark",
        group: "Symbols",
        subgroup: "other-symbol",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("regmerk"),
            keywords: &["dik regmerk", "merk", "reg", "regmerk"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ወፍራም ምልክት ማድረጊያ"),
            keywords: &["ምልክት", "ወፍራም ምልክት ማድረጊያ", "ፈትሽ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("علامة صح"),
            keywords: &["تحديد", "علامة", "علامة صح"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("শ\u{9c1}দ\u{9cd}ধ চিন"),
            keywords: &[
                "চিন",
                "পৰীক\u{9cd}ষ\u{9be} কৰ\u{9be}",
                "শ\u{9c1}দ\u{9cd}ধ চিন",
                "✓",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("qalın təsdiq işarəsi"),
            keywords: &["işarə", "işarələ", "qalın təsdiq işarəsi"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("знак птушкі"),
            keywords: &["знак", "знак птушкі", "птушка"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Удебелена отметка"),
            keywords: &["Удебелена отметка", "отметка"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("চেক ম\u{9be}র\u{9cd}ক"),
            keywords: &["চিহ\u{9cd}ন", "চেক ম\u{9be}র\u{9cd}ক", "✓"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("ask"),
            keywords: &["ask", "✓"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("kvačica"),
            keywords: &["kvačica", "oznaka", "✓"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("marca de verificació"),
            keywords: &[
                "marca",
                "marca de verificació",
                "selecció",
                "verificació",
                "✓",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎪᏪᎳᏅᎯ"),
            keywords: &["ᎤᏙᏪᎸ", "ᎪᏪᎳᏅᎯ", "✓"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("značka zaškrtnutí"),
            keywords: &["zaškrtnutí", "značka", "✓"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("marc tic trwm"),
            keywords: &["marc", "marc tic trwm", "tic", "✓"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("flueben"),
            keywords: &["flueben", "markering", "✓"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("kräftiges Häkchen"),
            keywords: &["Häkchen", "abhaken", "erledigt", "kräftiges Häkchen"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("σημάδι επιλογής"),
            keywords: &["επιλογή", "σημάδι", "σημάδι επιλογής", "✓"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("check mark"),
            keywords: &["check", "mark", "✓"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: Some("tick"),
            keywords: &["mark", "tick", "✓"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["heavy tick mark", "mark", "tick"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("check mark"),
            keywords: &["check", "mark", "✓"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("tick"),
            keywords: &["mark", "tick", "✓"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("marca de verificación"),
            keywords: &[
                "marca",
                "marca de verificación",
                "selección",
                "verificación",
                "✓",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("marca de verificación grande"),
            keywords: &[
                "marca",
                "marca de verificación",
                "marca de verificación grande",
                "selección",
                "verificación",
                "✓",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("marca de verificación"),
            keywords: &[
                "marca",
                "marca de verificación",
                "selección",
                "verificación",
                "✓",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("marca de verificación"),
            keywords: &["marca", "marca de verificación", "✓"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("märge"),
            keywords: &["märge", "suur märge"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("hautamarka"),
            keywords: &["hautamarka", "markatu", "tilet", "tileta", "✓"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("علامت تیک"),
            keywords: &["علامت تأیید", "علامت تیک"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("paksu valintamerkki"),
            keywords: &[
                "V",
                "merkki",
                "paksu valintamerkki",
                "tarkistusmerkki",
                "valintamerkki",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("malaking tsek"),
            keywords: &["makapal", "malaking tsek", "marka", "tsek"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("tjúkt flugubein"),
            keywords: &["flugubein", "tjúkt flugubein"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("coche"),
            keywords: &["coche", "oui", "sélection", "✓"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["coche", "coche noire", "marque"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("ticmharc"),
            keywords: &["marc", "tic", "ticmharc"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("cromag dearbhaidh"),
            keywords: &["comharra", "cromag", "cromag dearbhaidh"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("marca de verificación"),
            keywords: &[
                "ben",
                "correcto",
                "marca de verificación",
                "verificación",
                "✓",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ચ\u{ac7}ક માર\u{acd}ક"),
            keywords: &["ચ\u{ac7}ક", "માર\u{acd}ક", "✓"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("alamar yarda mai nauyi"),
            keywords: &["alama", "alamar yarda mai nauyi", "yarda"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("סימן אישור ירוק"),
            keywords: &[
                "אישור",
                "לסמן",
                "סימן אישור ירוק",
                "סימן בחירה",
                "סימן ביקורת",
            ],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("बड\u{93c}ा च\u{947}क मार\u{94d}क"),
            keywords: &[
                "च\u{947}क",
                "बड\u{93c}ा च\u{947}क मार\u{94d}क",
                "मार\u{94d}क",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("kvačica"),
            keywords: &["kvačica", "oznaka", "✓"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("vastag pipa"),
            keywords: &["jel", "pipa", "vastag pipa"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ստուգանշան"),
            keywords: &["թռչնիկ", "ստուգանշան", "✓"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("tanda centang tebal"),
            keywords: &["centang", "tanda", "tanda centang tebal"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("nnukwu akara ntule"),
            keywords: &["akara", "nnukwu akara ntule", "ntule"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("hak"),
            keywords: &["hak", "merki", "✓"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("segno di spunta"),
            keywords: &["baffo", "segno di spunta", "spunta"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("太字のチェック"),
            keywords: &["チェック", "チェックマーク", "太字のチェック", "記号"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("tenger centhang"),
            keywords: &["centhang", "tenger", "✓"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მსხვილი მონიშვნის ნიშანი"),
            keywords: &["მონიშვნა", "მსხვილი მონიშვნის ნიშანი", "ნიშანი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("қалың құсбелгі"),
            keywords: &["белгі", "қалың құсбелгі", "құсбелгі"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("stort flueben"),
            keywords: &["flueben", "stort flueben"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("សញ\u{17d2}ញាធ\u{17b8}ក"),
            keywords: &["ធ\u{17b8}ក", "សញ\u{17d2}ញាធ\u{17b8}ក", "✓"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಚ\u{cc6}ಕ\u{ccd} ಮಾರ\u{ccd}ಕ\u{ccd}"),
            keywords: &[
                "ಗುರುತು",
                "ಚ\u{cc6}ಕ\u{ccd} ಮಾರ\u{ccd}ಕ\u{ccd}",
                "ಮಾರ\u{ccd}ಕ\u{ccd}",
                "✓",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("진한 체크 표시"),
            keywords: &["진한 체크 표시", "진한 체크표시", "체크표시"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("तपासणी चिन\u{94d}न"),
            keywords: &["चिन\u{94d}न", "तपासणी", "✓"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("жоон «туура» белгиси"),
            keywords: &["белги", "жоон «туура» белгиси", "жоон «чымчыкча» белгиси"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("fettgedréckte Kreepchen"),
            keywords: &["Kreepchen", "Krop", "fettgedréckte Kreepchen"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເຄ\u{eb7}\u{ec8}ອງໝາຍຕ\u{eb4}ກໃຫຍ\u{ec8}ໜາ"),
            keywords: &[
                "ເຄ\u{eb7}\u{ec8}ອງໝາຍຕ\u{eb4}ກ",
                "ເຄ\u{eb7}\u{ec8}ອງໝາຍຕ\u{eb4}ກໃຫຍ\u{ec8}ໜາ",
                "ໃຫຍ\u{ec8}ໜາ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("paryškinta varnelė"),
            keywords: &["paryškinta varnelė", "varnelė", "žymė"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("kontrolzīme"),
            keywords: &["atzīme", "kontrolzīme", "ķeksītis", "✓"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tohu taki taumaha"),
            keywords: &["taki", "tohu", "tohu taki taumaha"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("знак за штиклирање"),
            keywords: &["знак за штиклирање", "ознака", "штиклирање", "✓"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ചെക\u{d4d}ക\u{d4d} അടയ\u{d3e}ളം"),
            keywords: &[
                "അടയ\u{d3e}ളം",
                "ചെക\u{d4d}ക\u{d4d}",
                "മ\u{d3e}ർക\u{d4d}ക\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("зөвлөх тэмдэг"),
            keywords: &["зөвлөх", "тэмдэг"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("मोठ\u{947} च\u{947}क करण\u{94d}\u{200d}याच\u{947} चिन\u{94d}ह"),
            keywords: &[
                "चिन\u{94d}ह",
                "च\u{947}क",
                "मोठ\u{947} च\u{947}क करण\u{94d}\u{200d}याच\u{947} चिन\u{94d}ह",
                "✓",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("tanda rait"),
            keywords: &["rait", "tanda", "✓"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("marka ta’ verifika grassett"),
            keywords: &["marka", "marka ta’ verifika grassett", "verifika"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အကြ\u{102e}းစား ခြစ\u{103a}မ\u{103e}တ\u{103a}"),
            keywords: &[
                "အကြ\u{102e}းစား ခြစ\u{103a}မ\u{103e}တ\u{103a}",
                "အကြ\u{102e}းစား အမ\u{103e}န\u{103a} ခြစ\u{103a}မ\u{103e}တ\u{103a}",
                "အမ\u{103e}တ\u{103a}",
                "အမ\u{103e}န\u{103a} ခြစ\u{103a}မ\u{103e}တ\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("hakemerke"),
            keywords: &["hake", "hakemerke", "merke", "✓"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("भारी च\u{947}क चिन\u{94d}ह"),
            keywords: &["चिन\u{94d}ह", "जा\u{901}च", "भारी च\u{947}क चिन\u{94d}ह"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("vinkje"),
            keywords: &["teken", "vinkje", "✓"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("hakemerke"),
            keywords: &["hake", "hakemerke", "merke", "✓"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଚେକ ମ\u{b3e}ର\u{b4d}କ"),
            keywords: &["ଚେକ", "ମ\u{b3e}ର\u{b4d}କ", "✓"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਗ\u{a42}ੜ\u{a4d}ਹਾ ਸਹੀ ਦਾ ਨਿਸ\u{a3c}ਾਨ"),
            keywords: &[
                "ਗ\u{a42}ੜ\u{a4d}ਹਾ ਸਹੀ ਦਾ ਨਿਸ\u{a3c}ਾਨ",
                "ਚ\u{a48}\u{a71}ਕ ਕਰਨਾ",
                "ਚ\u{a48}\u{a71}ਕ ਚਿ\u{a70}ਨ\u{a4d}ਹ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("وڈا پڑتال دا نشان"),
            keywords: &["نشان لانا", "وڈا پڑتال دا نشان", "پڑتال کرنا"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Chẹ\u{301}k Mak"),
            keywords: &["Chẹk", "Chẹ\u{301}k Mak", "Gud", "Mak"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("znacznik wyboru"),
            keywords: &[
                "gruby znacznik wyboru",
                "parafka",
                "ptaszek",
                "zaznaczenie",
                "znacznik wyboru",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("خوښنښه"),
            keywords: &["خوښنښه", "نښه", "چيک", "✓"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("marca de seleção"),
            keywords: &["marca", "marca de seleção", "verificação", "✓"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("visto"),
            keywords: &["marca de verificação", "visto", "✓"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("bifă îngroșată"),
            keywords: &["bifă", "bifă îngroșată"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-131"),
            keywords: &["E10-131"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("галочка"),
            keywords: &["галочка", "знак", "значок", "черная галочка", "черный"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("Ikimenyetso kinini cya bihwanye"),
            keywords: &["Ikimenyetso kinini cya bihwanye", "akarango", "ivivura"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("چيڪ مارڪ"),
            keywords: &["مارڪ", "چيڪ", "✓"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("බර හර\u{dd2} ලක\u{dd4}ණ"),
            keywords: &["බර හර\u{dd2} ලක\u{dd4}ණ", "ලක\u{dd4}ණ", "හර\u{dd2}"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("znak začiarknutia"),
            keywords: &["začiarknuť", "znak", "znak začiarknutia"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("kljukica"),
            keywords: &["kljukica", "znak", "✓"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("ku calaamadee calaamad"),
            keywords: &["calaamad", "calaamadee", "ku calaamadee calaamad", "✓"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("shenja e zgjedhjes e trashë"),
            keywords: &[
                "shenja e zgjedhjes e trashë",
                "shenjë",
                "zgjedh",
                "zgjedhje",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("црни знак потврде"),
            keywords: &["знaк", "потврда", "црни знак потврде"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("crni znak potvrde"),
            keywords: &["crni znak potvrde", "potvrda", "znak"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("bockmarkering"),
            keywords: &["avbockad", "bock", "bockmarkering"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("alama ya tiki"),
            keywords: &["alama ya tiki", "tia tiki", "tiki ya kijani", "✓"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("கருப\u{bcd}பு நிற டிக\u{bcd} சின\u{bcd}னம\u{bcd}"),
            keywords: &[
                "கருப\u{bcd}பு நிற டிக\u{bcd}",
                "கருப\u{bcd}பு நிற டிக\u{bcd} சின\u{bcd}னம\u{bcd}",
                "சரி",
                "டிக\u{bcd} ம\u{bbe}ர\u{bcd}க\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("భ\u{c3e}ర\u{c40} తన\u{c3f}ఖ\u{c40} గుర\u{c4d}తు"),
            keywords: &[
                "ఎంప\u{c3f}క",
                "గుర\u{c4d}తు",
                "తన\u{c3f}ఖ\u{c40}",
                "భ\u{c3e}ర\u{c40} తన\u{c3f}ఖ\u{c40} గుర\u{c4d}తు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("аломати вазнини қайд"),
            keywords: &["аломат", "аломати вазнини қайд", "қайд"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เคร\u{e37}\u{e48}องหมายถ\u{e39}ก"),
            keywords: &[
                "เคร\u{e37}\u{e48}องหมาย",
                "เคร\u{e37}\u{e48}องหมายถ\u{e39}ก",
                "✓",
            ],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ምልክት ኣረጋግጽ"),
            keywords: &["ምልክት", "ኣረጋግጽ", "✓"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("barlag belligi"),
            keywords: &["barlag", "barlag belligi", "bellik", "✓"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("fakaʻilonga sivi mamafa"),
            keywords: &["fakaʻilonga", "fakaʻilonga sivi mamafa", "sivi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("onay işareti"),
            keywords: &["işaret", "onay", "onay işareti", "✓"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئېغىر توغرا بەلگىسى"),
            keywords: &["ئېغىر توغرا بەلگىسى", "بەلگە", "تاللاش"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("галочка"),
            keywords: &["відмітка", "галочка", "позначка", "✓"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("بھاری چیک کا نشان"),
            keywords: &["بھاری چیک کا نشان", "علامت", "چیک", "✓"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("belgilash belgisi"),
            keywords: &["belgi", "belgilash", "belgilash belgisi", "✓"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("dấu chọn"),
            keywords: &["chọn", "dấu", "✓"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("màndarga nangu bu rëy"),
            keywords: &["marke", "màndarga nangu bu rëy", "xàmme"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("uphawu lokhetho olungqindilili"),
            keywords: &["khetha", "uphawu", "uphawu lokhetho olungqindilili"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("fínnífínní"),
            keywords: &["fínnífínní", "àmì", "àyẹ\u{300}wò"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("粗剔號"),
            keywords: &["✓", "剔號", "標誌", "粗剔號"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("粗剔号"),
            keywords: &["剔号", "标志", "粗剔号"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("勾号"),
            keywords: &["勾号", "对勾", "打勾", "正确", "符号"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("打勾"),
            keywords: &["勾號", "打勾"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("剔號"),
            keywords: &["剔", "剔號"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("uphawu lokuhlola oluwugqinsi"),
            keywords: &["ukuhlola", "uphawu", "uphawu lokuhlola oluwugqinsi"],
        },
    ],
};
#[doc = "❌"]
pub const CROSS_MARK: crate::Emoji = crate::Emoji {
    glyph: "❌",
    codepoint: "274C",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "cross mark",
    group: "Symbols",
    subgroup: "other-symbol",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("kruismerkie"),
            keywords: &[
                "kanselleer",
                "kruismerkie",
                "maal",
                "verkeerd",
                "vermenigvuldig",
                "x",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የስረዛ ምልክት"),
            keywords: &["ማባዛት", "ምልክት", "ተወው", "አባዛ", "የስረዛ ምልክት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("علامة X"),
            keywords: &["إلغاء", "اكس", "ضرب", "علامة", "علامة X", "مضاعفة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("অশ\u{9c1}দ\u{9cd}ধ চিন"),
            keywords: &[
                "x",
                "×",
                "অশ\u{9c1}দ\u{9cd}ধ চিন",
                "কট\u{9be}-কটি চিন",
                "চিন",
                "প\u{9c2}ৰণ",
                "প\u{9c2}ৰণ কৰ\u{9be}",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("çarpazlamaq işarəsi"),
            keywords: &[
                "işarə",
                "ləğv et",
                "vurma",
                "vurmaq",
                "x",
                "çarpazlamaq işarəsi",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("крыжык"),
            keywords: &["знак", "крыжык", "множанне", "скасаванне", "х"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("кръстче"),
            keywords: &["кръстче", "отказ", "умножение"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ক\u{9cd}রস ম\u{9be}র\u{9cd}ক"),
            keywords: &[
                "x",
                "×",
                "ক\u{9cd}রস ম\u{9be}র\u{9cd}ক",
                "গ\u{9c1}ণ",
                "গ\u{9c1}ন কর\u{9be}",
                "চিহ\u{9cd}ন",
                "ব\u{9be}তিল",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("kroaz"),
            keywords: &["kroaz", "×"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("križić"),
            keywords: &[
                "križić",
                "otkaži",
                "oznaka prekriženo",
                "puta",
                "umnoži",
                "×",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("marca de creu"),
            keywords: &[
                "cancel·lar",
                "creu",
                "marca",
                "marca de creu",
                "multiplicació",
                "multiplicar",
                "x",
                "×",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏓᏓᎿᏫᏍᏛ ᎤᏙᏪᎸ"),
            keywords: &["x", "×", "ᎠᏎᏒᏗ", "ᎤᏙᏪᎸ", "ᎧᏁᏉᎢᏍᏗ", "ᏓᏓᎿᏫᏍᏛ ᎤᏙᏪᎸ", "ᏗᏎᏢᎢ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("křížek"),
            keywords: &[
                "krát",
                "křížek",
                "násobení",
                "součin",
                "x",
                "značka",
                "zrušení",
                "×",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("marc croes"),
            keywords: &["canslo", "lluosi", "marc", "marc croes", "x", "×"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("kryds"),
            keywords: &[
                "annuller",
                "gange",
                "kryds",
                "markering",
                "multiplikation",
                "x",
                "×",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Kreuzzeichen"),
            keywords: &[
                "Kreuzzeichen",
                "Multiplikation",
                "abbrechen",
                "durchgestrichen",
                "multiplizieren",
                "x",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("σημάδι x"),
            keywords: &[
                "x",
                "×",
                "ακύρωση",
                "πολλαπλασιάζω",
                "πολλαπλασιασμός",
                "σημάδι",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("cross mark"),
            keywords: &[
                "cancel",
                "cross",
                "mark",
                "multiplication",
                "multiply",
                "x",
                "×",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("marca de cruz"),
            keywords: &[
                "cancelar",
                "cruz",
                "marca de cruz",
                "marca de tachado",
                "tachar",
                "x",
                "×",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("cruz"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("tache"),
            keywords: &[
                "cancelar",
                "cruz",
                "marca de cruz",
                "marca de tachado",
                "tachar",
                "tache",
                "×",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("rist"),
            keywords: &["ei", "korrutamine", "korrutusmärk", "rist", "x", "×"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("gurutze-ikurra"),
            keywords: &[
                "biderkatu",
                "biderketa",
                "gurutze-ikurra",
                "gurutzea",
                "markatu",
                "utzi",
                "×",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("ضربدر"),
            keywords: &["ضرب", "ضربدر", "علامت ضرب", "لغو", "نادرست"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("punainen rastimerkki"),
            keywords: &[
                "X",
                "kertolasku",
                "merkki",
                "peruuta",
                "punainen rastimerkki",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("ekis"),
            keywords: &[
                "ekis",
                "kansela",
                "marka",
                "multiplication",
                "multiply",
                "x",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("kross symbol"),
            keywords: &[
                "annullera",
                "falda",
                "ganga",
                "kross",
                "kross symbol",
                "strika",
                "x",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("croix"),
            keywords: &["annuler", "croix", "multiplication", "multiplier", "x", "×"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("croix"),
            keywords: &["annuler", "croix", "multiplication", "multiplier", "x"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("crosmharc"),
            keywords: &["cealaigh", "crosmharc", "iolrúchán", "marc", "x"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("samhla croise"),
            keywords: &[
                "comharra",
                "iomadachadh",
                "iomadaich",
                "samhla croise",
                "sguir dheth",
                "sgur dheth",
                "x",
                "×",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("signo de multiplicar"),
            keywords: &[
                "X",
                "cancelar",
                "multiplicación",
                "multiplicar",
                "signo de multiplicar",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ચોકડીન\u{ac1}\u{a82} ચિહ\u{acd}ન"),
            keywords: &[
                "x",
                "×",
                "ખોટ\u{ac1}\u{a82}",
                "ગ\u{ac1}ણાકાર",
                "ગ\u{ac1}ણાકાર કરો",
                "ચોકડી",
                "ચોકડીન\u{ac1}\u{a82} ચિહ\u{acd}ન",
                "રદ કરો",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("alamar kuros"),
            keywords: &["alamar", "alamar kuros", "riɓa", "sau", "soke", "x"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("איקס אדום"),
            keywords: &[
                "איקס",
                "איקס אדום",
                "אסור",
                "ביטול",
                "כפל",
                "לא",
                "נפסל",
                "סימון",
                "פסול",
            ],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("क\u{94d}रॉस चिह\u{94d}न"),
            keywords: &["x", "क\u{94d}रॉस चिह\u{94d}न", "ग\u{941}णा"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("križić"),
            keywords: &[
                "križić",
                "množenje",
                "odustajanje",
                "oznaka križića",
                "puta",
                "x",
                "znak",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("áthúzásjel"),
            keywords: &["jel", "mégse", "szorzás", "x", "áthúzásjel"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("խաչի նշան"),
            keywords: &["բազմապատկում", "խաչ", "խաչի նշան", "նշան", "չեղարկել"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("tanda silang"),
            keywords: &["batal", "kali", "perkalian", "tanda", "tanda silang", "x"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("akara nkachi"),
            keywords: &["akara", "akara nkachi", "gbakọọ", "kàgbuo", "mgbakọ", "x"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("kross"),
            keywords: &[
                "hætta við",
                "kross",
                "krossmerki",
                "margfalda",
                "margföldun",
                "x",
                "×",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("croce"),
            keywords: &["X", "croce"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("バツ"),
            keywords: &["キャンセル", "バツ", "ペケ", "乗算", "掛け算", "記号"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("tenger ping"),
            keywords: &[
                "ditikelake",
                "ping",
                "ping-pingan",
                "tenger",
                "wurung",
                "x",
                "×",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ჯვრით მონიშვნა"),
            keywords: &["x", "გამრავლება", "გაუქმება", "ნიშანი", "ჯვრით მონიშვნა"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("қиылысқан сызықтар белгісі"),
            keywords: &[
                "x",
                "бас тарту",
                "белгі",
                "көбейту",
                "қиылысқан сызықтар белгісі",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("kryds"),
            keywords: &[
                "annuller",
                "gange",
                "kryds",
                "multiplicer",
                "multiplikation",
                "mærke",
                "x",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("សញ\u{17d2}ញាខ\u{17d2}វែង"),
            keywords: &[
                "ខ\u{17d2}វែង",
                "ពណ\u{17cc}ក\u{17d2}រហម",
                "សញ\u{17d2}ញា",
                "សញ\u{17d2}ញាខ\u{17d2}វែង",
                "សញ\u{17d2}ញាខ\u{17d2}វែងពណ\u{17cc}ក\u{17d2}រហម",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕ\u{ccd}ರಾಸ\u{ccd} ಮಾರ\u{ccd}ಕ\u{ccd}"),
            keywords: &[
                "x",
                "ಕ\u{ccd}ರಾಸ\u{ccd} ಮಾರ\u{ccd}ಕ\u{ccd}",
                "ಗುಣಾಕಾರ",
                "ಗುಣ\u{cbf}ಸು",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("엑스 표시"),
            keywords: &["엑스", "엑스 표시", "엑스표"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("क\u{94d}रॉस मार\u{94d}क"),
            keywords: &[
                "x",
                "×",
                "क\u{94d}रॉस",
                "क\u{94d}रॉस मार\u{94d}क",
                "ख\u{942}ण",
                "ग\u{941}णाकार",
                "ग\u{941}णाकार करप",
                "रद\u{94d}द",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("кайчылаш белгиси"),
            keywords: &["белги", "жокко чыгар", "кайчылаш белгиси", "көбөйтүү"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Kräizzeechen"),
            keywords: &[
                "Kräizzeechen",
                "Multiplikatioun",
                "Zeechen",
                "multiplizéieren",
                "ofbriechen",
                "x",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເຄ\u{eb7}\u{ec8}ອງໝາຍກາກະບາດ"),
            keywords: &[
                "ກາກະບາດ",
                "ຍ\u{ebb}ກເລ\u{eb5}ກ",
                "ເຄ\u{eb7}\u{ec8}ອງໝາຍ",
                "ເຄ\u{eb7}\u{ec8}ອງໝາຍກາກະບາດ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("kryžiukas"),
            keywords: &["atšaukti", "dauginti", "daugyba", "kryžiukas", "x", "žymė"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("krustiņš"),
            keywords: &["atcelt", "krustiņš", "reizināt", "x", "×"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tohu whiri"),
            keywords: &[
                "tohu",
                "tohu whiri",
                "whakakore",
                "whakarea",
                "whakareatanga",
                "x",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("знак за пречкртано"),
            keywords: &[
                "x",
                "×",
                "знак",
                "знак за пречкртано",
                "множење",
                "множи",
                "откажи",
                "пречкртано",
            ],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("തെറ\u{d4d}റ\u{d4d} അടയ\u{d3e}ളം"),
            keywords: &[
                "ക\u{d4d}രോസ\u{d4d}",
                "ഗ\u{d41}ണനം",
                "ഗ\u{d41}ണനചിഹ\u{d4d}നം",
                "ഗ\u{d41}ണിക\u{d4d}ക\u{d41}ക",
                "ചിഹ\u{d4d}നം",
                "തെറ\u{d4d}റ\u{d4d} അടയ\u{d3e}ളം",
                "മ\u{d3e}ർക\u{d4d}ക\u{d4d}",
                "റദ\u{d4d}ദ\u{d3e}ക\u{d4d}കൽ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("хэрээсэн тэмдэг"),
            keywords: &[
                "x",
                "×",
                "тэмдэг",
                "хэрээс",
                "хэрээсэн тэмдэг",
                "цуцлах",
                "үржвэр",
                "үржих",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("फ\u{941}लीच\u{947} चिन\u{94d}ह"),
            keywords: &[
                "×",
                "क\u{94d}रॉस",
                "ग\u{941}णाकार",
                "ग\u{941}णिल\u{947}",
                "चिन\u{94d}ह",
                "फ\u{941}लीच\u{947} चिन\u{94d}ह",
                "रद\u{94d}द करा",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("tanda pangkah"),
            keywords: &[
                "batal",
                "darab",
                "pendaraban",
                "tanda",
                "tanda pangkah",
                "x",
                "×",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("marka salib"),
            keywords: &[
                "ikkanċella",
                "immoltiplika",
                "marka",
                "marka salib",
                "multiplikazzjoni",
                "x",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ကြက\u{103a}ခြေခတ\u{103a} အမ\u{103e}တ\u{103a}"),
            keywords: &[
                "ကြက\u{103a}ခြေခတ\u{103a} အမ\u{103e}တ\u{103a}",
                "ဖျက\u{103a}သ\u{102d}မ\u{103a}းခြင\u{103a}း",
                "အမြ\u{103e}ောက\u{103a}",
                "အမြ\u{103e}ောက\u{103a}လက\u{1039}ခဏာ",
                "အမ\u{103e}တ\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("kryss"),
            keywords: &["X", "kryss", "rødt kryss", "x", "×"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("क\u{94d}रस चिन\u{94d}ह"),
            keywords: &[
                "एक\u{94d}स",
                "क\u{94d}रस चिन\u{94d}ह",
                "ग\u{941}णाङ\u{94d}क",
                "ग\u{941}णान",
                "चिन\u{94d}ह",
                "रद\u{94d}द",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("kruisteken"),
            keywords: &[
                "annuleren",
                "kruis",
                "kruisteken",
                "teken",
                "vermenigvuldigen",
                "vermenigvuldiging",
                "x",
                "×",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("kryss"),
            keywords: &["X", "kryss", "raudt kryss", "x", "×"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଛକ\u{b3f} ଚ\u{b3f}ହ\u{b4d}ନ"),
            keywords: &[
                "x",
                "×",
                "ଗ\u{b41}ଣନ",
                "ଗ\u{b41}ଣନ କର\u{b3f}ବ\u{b3e}",
                "ଚ\u{b3f}ହ\u{b4d}ନ",
                "ଛକ\u{b3f} ଚ\u{b3f}ହ\u{b4d}ନ",
                "ବ\u{b3e}ତ\u{b3f}ଲ\u{b4d}\u{200c}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਕ\u{a4d}ਰਾਸ ਮਾਰਕ"),
            keywords: &["ਕਰਾਸ ਚਿ\u{a70}ਨ\u{a4d}ਹ", "ਕ\u{a4d}ਰਾਸ ਮਾਰਕ", "“X”"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("کراس دا نشان"),
            keywords: &["x", "ضرب", "ضرب دینا", "منسوخ کرنا", "نشان", "کراس دا نشان"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Krọ\u{301}s Mak"),
            keywords: &[
                "Krọs",
                "Krọ\u{301}s Mak",
                "Kánsul",
                "Mak",
                "Mọltiplai",
                "Taims",
                "X",
                "×",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("znak krzyżyka"),
            keywords: &[
                "anuluj",
                "krzyżyk",
                "mnożenie",
                "x",
                "znak",
                "znak krzyżyka",
                "znak mnożenia",
                "×",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د صليب نښه"),
            keywords: &["x", "×", "د صليب نښه", "ضرب", "ضرب کول", "فسخ کول", "نښه"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("xis"),
            keywords: &["X", "cancelar", "multiplicar", "multiplicação", "xis", "×"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("cruz"),
            keywords: &["cancelar", "cruz", "multiplicar", "multiplicação", "x", "×"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("chakana chinpu"),
            keywords: &["chakana chinpu"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("semnul x"),
            keywords: &["anulare", "semnul x", "x", "×", "închidere", "înmulțire"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-140"),
            keywords: &["E10-140"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("крестик"),
            keywords: &["закрытие", "значок", "крестик", "отмена", "умножение"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("akamenyetso k’umusaraba"),
            keywords: &[
                "akamenyetso k’umusaraba",
                "gukuba",
                "ikimenyetso",
                "ikimenyetso cyo gukuba (x)",
                "ikuba",
                "kuburizamo",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڪراس جي نشاني"),
            keywords: &[
                "x",
                "×",
                "ضرب",
                "ضرب ڪريو",
                "مارڪ",
                "منسوخ",
                "ڪراس",
                "ڪراس جي نشاني",
            ],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("කත\u{dd2}ර ලක\u{dd4}ණ"),
            keywords: &[
                "x",
                "අවලංග\u{dd4}",
                "කත\u{dd2}ර ලක\u{dd4}ණ",
                "ග\u{dd4}ණ ක\u{dd2}ර\u{dd3}ම",
                "ග\u{dd4}ණ\u{dd2}තය",
                "ලක\u{dd4}ණ",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("krížik"),
            keywords: &["krížik", "násobenie", "násobiť", "x", "znak", "zrušiť", "×"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("križec"),
            keywords: &[
                "križec",
                "množenje",
                "množiti",
                "oznaka",
                "preklic",
                "x",
                "×",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("calaamadda iskutallaabta"),
            keywords: &[
                "baaji",
                "calaamadda iskutallaabta",
                "calamad",
                "isku talaab",
                "iskudhufasho",
                "iskudhufo",
                "x",
                "×",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("shenja e vendosjes së kryqit"),
            keywords: &[
                "anulo",
                "shenja e shumëzimit",
                "shenja e vendosjes së kryqit",
                "shenjë",
                "shumëzim",
                "x",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("икс"),
            keywords: &["x", "знaк", "икс", "мнoжeњe", "отказивање", "путa"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("iks"),
            keywords: &["iks", "množenje", "otkazivanje", "puta", "x", "znak"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("rött kryss"),
            keywords: &["X", "kryss", "rött kryss"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("alama ya X"),
            keywords: &[
                "alama",
                "alama ya X",
                "ghairi",
                "kuzidisha",
                "x",
                "zidisha",
                "×",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பெருக\u{bcd}கல\u{bcd} குறி"),
            keywords: &[
                "கணக\u{bcd}கு",
                "சின\u{bcd}னம\u{bcd}",
                "பெருக\u{bcd}கல\u{bcd} குறி",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("క\u{c4d}ర\u{c3e}స\u{c4d} గుర\u{c4d}తు"),
            keywords: &[
                "కూడల\u{c3f}",
                "క\u{c4d}ర\u{c3e}స\u{c4d} గుర\u{c4d}తు",
                "గుణక\u{c3e}రం గుర\u{c4d}తు",
                "నలుపు రంగు వ\u{c4d}యత\u{c3f}ర\u{c47}కం గుర\u{c4d}తు",
                "వ\u{c4d}యత\u{c3f}ర\u{c47}కం గుర\u{c4d}తు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("аломати салиб"),
            keywords: &[
                "аломат",
                "аломати салиб",
                "бекор кардан",
                "зарб задан",
                "зарбзанӣ",
                "х",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เคร\u{e37}\u{e48}องหมายกากบาท"),
            keywords: &[
                "x",
                "กากบาท",
                "ค\u{e39}ณ",
                "ยกเล\u{e34}ก",
                "เคร\u{e37}\u{e48}องหมายกากบาท",
                "เคร\u{e37}\u{e48}องหมายค\u{e39}ณ",
            ],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ተማሓላላፊ ምልክት"),
            keywords: &["x", "×", "ምልክት", "ምርባሕ", "ሰረዘ", "ተማሓላላፊ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("atanak belgisi"),
            keywords: &[
                "alamat",
                "atanak",
                "atanak belgisi",
                "bes et",
                "köpelt",
                "köpeltmek",
                "x",
                "×",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("fakaʻilonga kolosi"),
            keywords: &["fakaʻilonga", "kolosi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("çarpı işareti"),
            keywords: &[
                "iptal",
                "işaret",
                "x",
                "×",
                "çarpma",
                "çarpı",
                "çarpı işareti",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("خاتا بەلگىسى"),
            keywords: &[
                "x",
                "بىكار قىلىش",
                "بەلگە",
                "خاتا بەلگىسى",
                "كۆپەيت",
                "كۆپەيتىش",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("хрестик"),
            keywords: &[
                "×",
                "значок",
                "множення",
                "позначка",
                "помножити",
                "скасувати",
                "х",
                "хрестик",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("کراس کا نشان"),
            keywords: &[
                "x",
                "x منسوخ کرنا",
                "ضرب",
                "ضرب کرنا",
                "علامت",
                "کراس",
                "کراس کا نشان",
            ],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("krest belgisi"),
            keywords: &[
                "bekor qilish",
                "belgi",
                "koʻpaytirish",
                "koʻpaytiruv",
                "krest",
                "krest belgisi",
                "x",
                "×",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("dấu gạch chéo"),
            keywords: &["dấu", "dấu gạch chéo", "hủy", "nhân", "x"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("kruwaa"),
            keywords: &["fuul", "kruwaa", "màndarga", "x"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("uphawu lomnqamlezo"),
            keywords: &[
                "phindaphinda",
                "rhoxisa",
                "uphawu",
                "uphawu lomnqamlezo",
                "uphindaphindo",
                "x",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("aami idabu"),
            keywords: &["aami idabu", "fagilé", "x", "àmì", "ìsọdipúpò\u{329}"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("交叉"),
            keywords: &["X", "x", "乘", "乘法", "交叉", "取消", "標誌"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("交叉"),
            keywords: &["X", "乘", "乘法", "交叉", "取消", "标志"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("叉号"),
            keywords: &["交叉", "叉号", "取消", "相乘", "符号"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("叉"),
            keywords: &["叉"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("交叉"),
            keywords: &["交叉"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("uphawu lwesiphambano"),
            keywords: &[
                "khansela",
                "ukuphindaphinda",
                "uphawu",
                "uphawu lwesiphambano",
            ],
        },
    ],
};
#[doc = "❎"]
pub const CROSS_MARK_BUTTON: crate::Emoji = crate::Emoji {
    glyph: "❎",
    codepoint: "274E",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "cross mark button",
    group: "Symbols",
    subgroup: "other-symbol",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("kruismerkknoppie"),
            keywords: &[
                "kanselleer",
                "kruismerkknoppie",
                "maal",
                "verkeerd",
                "vermenigvuldig",
                "x",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የስረዛ ምልክት አዝራር"),
            keywords: &["ምልክት", "ካሬ", "የስረዛ ምልክት አዝራር"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("علامة X في مربع"),
            keywords: &["علامة", "علامة X في مربع", "مربع"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("অশ\u{9c1}দ\u{9cd}ধ চিনৰ ব\u{9c1}ট\u{9be}ম"),
            keywords: &[
                "x",
                "×",
                "অশ\u{9c1}দ\u{9cd}ধ চিনৰ ব\u{9c1}ট\u{9be}ম",
                "চিন",
                "বৰ\u{9cd}গ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("çarpazlamaq düyməsi"),
            keywords: &["işarə", "kvadrat", "çarpazlamaq düyməsi"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("кнопка з крыжыкам"),
            keywords: &["×", "знак", "квадрат", "кнопка з крыжыкам", "крыжык", "х"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Бутон с кръстче"),
            keywords: &["Бутон с кръстче", "квадрат"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ক\u{9cd}রস ম\u{9be}র\u{9cd}কের বোত\u{9be}ম"),
            keywords: &[
                "x",
                "×",
                "ক\u{9cd}রস ম\u{9be}র\u{9cd}কের বোত\u{9be}ম",
                "চিহ\u{9cd}ন",
                "বর\u{9cd}গ\u{9be}ক\u{9be}র",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("bouton kroaz"),
            keywords: &["bouton kroaz", "kroaz", "×"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("dugme križić"),
            keywords: &["dugme križić", "kvadratić", "oznaka", "×"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("botó de creu"),
            keywords: &["botó de creu", "marca", "quadrat", "x", "×"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏓᏓᎿᏫᏍᏛ ᎤᏙᏪᎸ ᎠᏍᏓᏅᏅᎢ"),
            keywords: &["x", "×", "ᎤᏙᏪᎸ", "ᏅᎩ ᏧᏅᏏᏯ", "ᏓᏓᎿᏫᏍᏛ ᎤᏙᏪᎸ ᎠᏍᏓᏅᏅᎢ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("tlačítko s křížkem"),
            keywords: &[
                "tlačítko",
                "tlačítko s křížkem",
                "x",
                "znak",
                "značka",
                "×",
                "čtverec",
                "čtvereček",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("botwm croes"),
            keywords: &["botwm croes", "marc", "sgwâr", "x", "×"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("krydsknap"),
            keywords: &["krydsknap", "kvadrat", "mærke", "x"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("angekreuztes Kästchen"),
            keywords: &[
                "Feld",
                "Kreuz",
                "Quadrat",
                "X",
                "angekreuztes Feld",
                "angekreuztes Kästchen",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κουμπί σημαδιού x"),
            keywords: &["×", "κουμπί σημαδιού x", "σημάδι", "τετράγωνο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("cross mark button"),
            keywords: &["cross mark button", "mark", "square", "x", "×"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("botón con marca de cruz"),
            keywords: &[
                "botón con marca de cruz",
                "casilla",
                "cruz",
                "marca",
                "x",
                "×",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("cruz con recuadro"),
            keywords: &[
                "botón con marca de cruz",
                "casilla",
                "cruz",
                "cruz con recuadro",
                "marca",
                "x",
                "×",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("korrutusmärgiga nupp"),
            keywords: &["korrutusmärgiga nupp", "märk", "ruut", "x", "×"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("gurutze-ikurraren botoia"),
            keywords: &["gurutze-ikurraren botoia", "ikur", "karratu", "x", "×"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("دکمه ایکس"),
            keywords: &["دکمه ایکس", "دکمه بستن", "علامت", "مربع"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("rastimerkki"),
            keywords: &[
                "X",
                "kertolasku",
                "laatikko",
                "merkki",
                "peruuta",
                "rastimerkki",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("button na ekis"),
            keywords: &["button na ekis", "ekis", "marka", "parisukat"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("kross symbol knappur"),
            keywords: &[
                "annullera",
                "falda",
                "ganga",
                "kross",
                "kross symbol knappur",
                "strika",
                "x",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("bouton croix"),
            keywords: &["bouton croix", "croix", "x", "×"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("cnaipe crosmhairc"),
            keywords: &["cnaipe crosmhairc", "cnáipe crosmharc", "crosmharc", "x"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("samhla croise ann am putan"),
            keywords: &[
                "ceàrnag",
                "comharra",
                "samhla croise ann am putan",
                "x",
                "×",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("botón “X”"),
            keywords: &["X", "botón “X”", "cancelar", "pechar", "recadro"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ચોકડીન\u{ac1}\u{a82} બટન"),
            keywords: &[
                "x",
                "×",
                "ચિહ\u{acd}ન",
                "ચોકડીના ચિહ\u{acd}નવાળ\u{ac1}\u{a82} બટન",
                "ચોકડીન\u{ac1}\u{a82} બટન",
                "ચોરસ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("maɓallin alamar kuros"),
            keywords: &["alama", "maɓallin alamar kuros", "murabba’i"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("סימן איקס"),
            keywords: &[
                "כפתור סימן איקס",
                "לחצן עם איקס",
                "לסמן",
                "סימן איקס",
                "ריבוע",
            ],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("क\u{94d}रॉस चिह\u{94d}न बटन"),
            keywords: &["क\u{94d}रॉस चिह\u{94d}न बटन", "चिह\u{94d}न", "वर\u{94d}ग"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("tipka s oznakom križića"),
            keywords: &["kvadrat", "tipka s oznakom križića", "znak"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("áthúzásjel gomb"),
            keywords: &["jel", "négyzet", "áthúzásjel gomb"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("խաչի նշանով կոճակ"),
            keywords: &["խաչի նշանով կոճակ", "նշել", "քառակուսի"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("tombol tanda silang"),
            keywords: &["kotak", "tanda", "tombol tanda silang"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ọdụmbị akara nkachi"),
            keywords: &["akara", "sụkwai", "ọdụmbị akara nkachi"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("krosshnappur"),
            keywords: &["ferningur", "krosshnappur", "merki", "×"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("croce con quadrato"),
            keywords: &["X con quadrato", "croce con quadrato"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("白抜きのバツ"),
            keywords: &[
                "キャンセル",
                "バツ",
                "ペケ",
                "乗算",
                "掛け算",
                "白抜きのバツ",
                "記号",
            ],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("tombol tenger ping"),
            keywords: &["kothak", "tenger", "tombol tenger ping", "x", "×"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ჯვრით მონიშვნის ღილაკი"),
            keywords: &["კვადრატი", "ნიშანი", "ჯვრით მონიშვნის ღილაკი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("қиылысқан сызықтар түймесі"),
            keywords: &["белгі", "шаршы", "қиылысқан сызықтар түймесі"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("krydsknap"),
            keywords: &["krydsknap", "kvadrat", "mærke", "x"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ប\u{17ca}\u{17bc}ត\u{17bb}ងសញ\u{17d2}ញាខ\u{17d2}វែង"),
            keywords: &[
                "x",
                "×",
                "ប\u{17bd}នជ\u{17d2}រ\u{17bb}ង",
                "ប\u{17ca}\u{17bc}ត\u{17bb}ងសញ\u{17d2}ញាខ\u{17d2}វែង",
                "សញ\u{17d2}ញា",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕ\u{ccd}ರಾಸ\u{ccd} ಮಾರ\u{ccd}ಕ\u{ccd} ಬಟನ\u{ccd}"),
            keywords: &[
                "×",
                "ಕ\u{ccd}ರಾಸ\u{ccd} ಮಾರ\u{ccd}ಕ\u{ccd} ಬಟನ\u{ccd}",
                "ಗುರುತು",
                "ಚ\u{ccc}ಕ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("초록 상자 안 엑스표"),
            keywords: &["상자 안 엑스표", "엑스표", "초록 상자 안 엑스표"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("क\u{94d}रॉस चिन\u{94d}न बटण"),
            keywords: &[
                "x",
                "×",
                "क\u{94d}रॉस ख\u{942}ण बटण",
                "क\u{94d}रॉस चिन\u{94d}न बटण",
                "ख\u{942}ण",
                "चवकोण",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("кайчылаш белги баскычы"),
            keywords: &["белги", "кайчылаш белги баскычы", "чарчы"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("X-Knäppchen"),
            keywords: &["Quadrat", "X-Knäppchen", "Zeechen"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ປ\u{eb8}\u{ec8}ມເຄ\u{eb7}\u{ec8}ອງໝາຍກາກະບາດ"),
            keywords: &[
                "ກາລະບາດ",
                "ປ\u{eb8}\u{ec8}ມເຄ\u{eb7}\u{ec8}ອງໝາຍ",
                "ປ\u{eb8}\u{ec8}ມເຄ\u{eb7}\u{ec8}ອງໝາຍກາກະບາດ",
                "ປ\u{eb8}\u{ec8}ມເຄ\u{eb7}\u{ec8}ອງໝາຍກາລະບາດ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("kryžiuko mygtukas"),
            keywords: &["kryžiuko mygtukas", "kvadratas", "žymė"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("krustiņa poga"),
            keywords: &[
                "atcelt",
                "krustiņa poga",
                "krustiņš",
                "reizināt",
                "rūtiņa",
                "x",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pātene tohu whiri"),
            keywords: &["pātene tohu whiri", "tapawhā", "tohu"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("копче со знак за пречкртано"),
            keywords: &[
                "x",
                "×",
                "копче со знак за пречкртано",
                "ознака",
                "пречкртано",
            ],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("തെറ\u{d4d}റ\u{d4d} അടയ\u{d3e}ള ബട\u{d4d}ടൺ"),
            keywords: &[
                "ക\u{d4d}രോസ\u{d4d} മ\u{d3e}ർക\u{d4d}ക\u{d4d}",
                "ഗ\u{d41}ണന ചിഹ\u{d4d}നം",
                "തെറ\u{d4d}റ\u{d4d} അടയ\u{d3e}ള ബട\u{d4d}ടൺ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("хэрээсэн товч"),
            keywords: &[
                "x",
                "×",
                "дөрвөлжин",
                "тэмдэг",
                "хэрээс тэмдэгт товч",
                "хэрээсэн товч",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("फ\u{941}ली असल\u{947}ल\u{94d}या चिन\u{94d}हाच\u{947} बटण"),
            keywords: &[
                "x",
                "×",
                "क\u{94d}रॉसच\u{94d}या चिन\u{94d}हाच\u{947} बटण",
                "चिन\u{94d}ह",
                "चौरस",
                "फ\u{941}ली असल\u{947}ल\u{94d}या चिन\u{94d}हाच\u{947} बटण",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("butang tanda pangkah"),
            keywords: &["butang tanda pangkah", "segi empat sama", "tanda", "x", "×"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("buttuna ta’ marka salib"),
            keywords: &["buttuna ta’ marka salib", "kwadru", "marka"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ကြက\u{103a}ခြေခတ\u{103a} အမ\u{103e}တ\u{103a} ခလ\u{102f}တ\u{103a}"),
            keywords: &[
                "ကြက\u{103a}ခြေခတ\u{103a} အမ\u{103e}တ\u{103a} ခလ\u{102f}တ\u{103a}",
                "ကြက\u{103a}ခြေခတ\u{103a}အမ\u{103e}တ\u{103a} ခလ\u{102f}တ\u{103a}",
                "လေးထောင\u{1037}\u{103a}က\u{103d}က\u{103a}",
                "အမ\u{103e}တ\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("kryss i firkant"),
            keywords: &["kryss", "kryss i firkant", "kvadrat", "x", "×"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("क\u{94d}रम चिन\u{94d}ह बटन"),
            keywords: &["क\u{94d}रम चिन\u{94d}ह बटन", "चिन\u{94d}ह", "वर\u{94d}ग"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("knop voor kruis"),
            keywords: &["knop voor kruis", "teken", "vierkant", "x", "×"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("kryss i firkant"),
            keywords: &["kryss", "kryss i firkant", "kvadrat", "x", "×"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଛକ\u{b3f} ଚ\u{b3f}ହ\u{b4d}ନ ବଟନ\u{b4d}\u{200c}"),
            keywords: &[
                "x",
                "×",
                "ଚ\u{b3f}ହ\u{b4d}ନ । ବର\u{b4d}ଗ",
                "ଛକ\u{b3f} ଚ\u{b3f}ହ\u{b4d}ନ ବଟନ\u{b4d}\u{200c}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਕ\u{a4d}ਰਾਸ ਮਾਰਕ ਬਟਨ"),
            keywords: &[
                "ਕਰਾਸ ਚਿ\u{a70}ਨ\u{a4d}ਹ",
                "ਕ\u{a4d}ਰਾਸ ਮਾਰਕ ਬਟਨ",
                "ਖ\u{a3c}ਾਨ\u{a47} ਵਿ\u{a71}ਚ “X”",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("کراس دے نشان دا بٹن"),
            keywords: &["مربع", "نشان لانا", "کراس دے نشان دا بٹن"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Krọ\u{301}s Mák Bọ\u{301}tin"),
            keywords: &["Krọ\u{301}s Mák Bọ\u{301}tin", "Mak", "Skwea", "X", "x"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("przycisk z krzyżykiem"),
            keywords: &[
                "anuluj",
                "iks",
                "iks w kwadracie",
                "krzyżyk w kwadracie",
                "mnożenie",
                "przycisk z krzyżykiem",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د کراس نښې بټن"),
            keywords: &["x", "×", "د کراس نښې بټن", "مربع", "نښه"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("botão de xis"),
            keywords: &[
                "botão de caixa com X",
                "botão de xis",
                "marcado",
                "quadrado",
                "x",
                "×",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("botão com cruz"),
            keywords: &["botão com cruz", "quadrado", "x", "×"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("chakana chinpu ñitina"),
            keywords: &["chakana chinpu ñitina"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("buton x"),
            keywords: &["buton", "pătrat", "x", "×"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-141"),
            keywords: &["E10-141"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("кнопка «крестик»"),
            keywords: &[
                "квадрат",
                "кнопка",
                "кнопка \"крестик\"",
                "кнопка «крестик»",
                "крестик",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("buto y’akamenyetso y’umusaraba"),
            keywords: &[
                "akarango",
                "buto y’akamenyetso y’umusaraba",
                "ubwikube kabiri",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڪراس نشاني وارو بٽڻ"),
            keywords: &[
                "x",
                "×",
                "مارڪ",
                "چورس",
                "ڪراس مارڪ وارو بٽڻ",
                "ڪراس نشاني وارو بٽڻ",
            ],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("කත\u{dd2}ර ලක\u{dd4}ණ\u{dd4} බොත\u{dca}තම"),
            keywords: &[
                "කත\u{dd2}ර ලක\u{dd4}ණ\u{dd4} බොත\u{dca}තම",
                "කොට\u{dd4}ව",
                "ලක\u{dd4}ණ",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("tlačidlo s krížikom"),
            keywords: &["tlačidlo s krížikom", "x", "znak", "×", "štvorec"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("gumb s križcem"),
            keywords: &["gumb s križcem", "kvadrat", "oznaka", "x", "×"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("badhanka calaamadda iskutallaabta"),
            keywords: &[
                "afar jibaar",
                "badhanka calaamadda iskutallaabta",
                "calaamad",
                "x",
                "×",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("butoni me shenjën e shumëzimit"),
            keywords: &["butoni me shenjën e shumëzimit", "katror", "shenjë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("дугме са знаком икс"),
            keywords: &["дугме са знаком икс", "знaк", "квaдрaт"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("dugme sa znakom iks"),
            keywords: &["dugme sa znakom iks", "kvadrat", "znak"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("vitt kryss i ruta"),
            keywords: &["X i ruta", "kryss", "vitt kryss i ruta"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kitufe cha alama ya kuzidisha"),
            keywords: &["alama", "kitufe cha alama ya kuzidisha", "mraba", "x", "×"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("சதுரத\u{bcd}திற\u{bcd}குள\u{bcd} பெருக\u{bcd}கல\u{bcd} குறி"),
            keywords: &[
                "கணக\u{bcd}கு",
                "சதுரத\u{bcd}திற\u{bcd}குள\u{bcd} பெருக\u{bcd}கல\u{bcd} குறி",
                "சின\u{bcd}னம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("క\u{c4d}ర\u{c3e}స\u{c4d} గుర\u{c4d}తు బటన\u{c4d}"),
            keywords: &[
                "కూడల\u{c3f}",
                "క\u{c4d}ర\u{c3e}స\u{c4d} గుర\u{c4d}తు బటన\u{c4d}",
                "గుణక\u{c3e}రం గుర\u{c4d}తు",
                "నలుపు రంగు న\u{c47}పథ\u{c4d}యంల\u{c4b} త\u{c46}లుపు రంగు వ\u{c4d}యత\u{c3f}ర\u{c47}కం గుర\u{c4d}తు",
                "వ\u{c4d}యత\u{c3f}ర\u{c47}కం గుర\u{c4d}తు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("тугмаи \"Аломати салиб\""),
            keywords: &["аломат", "тугмаи \"Аломати салиб\"", "чоркунҷа"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ป\u{e38}\u{e48}มเคร\u{e37}\u{e48}องหมายกากบาท"),
            keywords: &[
                "x",
                "×",
                "ป\u{e38}\u{e48}มเคร\u{e37}\u{e48}องหมายกากบาท",
                "ส\u{e35}\u{e48}เหล\u{e35}\u{e48}ยม",
                "เคร\u{e37}\u{e48}องหมาย",
            ],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ተማሓላላፊ ምልክት መልጎም"),
            keywords: &["x", "×", "ምልክት", "ተማሓላላፊ ምልክት መልጎም", "ትርብዒት"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("atanak belgili düwme"),
            keywords: &["atanak belgili düwme", "bellik", "inedördül", "x", "×"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("meʻalolomi fakaʻilonga kolosi"),
            keywords: &["fakaʻilonga", "kolosi", "meʻalolomi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("çarpı işareti düğmesi"),
            keywords: &["kare", "x", "×", "çarpı işareti düğmesi"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("خاتا بەلگە كۇنۇپكىسى"),
            keywords: &["بەلگە", "خاتا بەلگە كۇنۇپكىسى", "كىۋادرات"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("кнопка з хрестиком"),
            keywords: &[
                "×",
                "значок",
                "квадрат",
                "кнопка з хрестиком",
                "позначка",
                "х",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("کراس کے نشان کا بٹن"),
            keywords: &[
                "x",
                "×",
                "علامت",
                "مربع",
                "کراس کی علامت کا بٹن",
                "کراس کے نشان کا بٹن",
            ],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("krest belgili tugma"),
            keywords: &[
                "belgi",
                "belgilash",
                "krest belgili tugma",
                "toʻrtburchak",
                "x",
                "×",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("nút dấu gạch chéo"),
            keywords: &["dấu", "hình vuông", "nút dấu gạch chéo"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("bitoŋ kruwaa"),
            keywords: &["bitoŋ kruwaa", "kaare", "màndarga"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("iqhosha lophawu lomnqamlezo"),
            keywords: &["iqhosha lophawu lomnqamlezo", "iskwere", "uphawu"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("bọtini aami idabu"),
            keywords: &["bọtini aami idabu", "oníhàmẹ\u{301}rin", "àmì"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("交叉按鈕"),
            keywords: &["x", "×", "交叉按鈕", "正方形", "符號"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("交叉按钮"),
            keywords: &["交叉按钮", "正方形", "符号"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("叉号按钮"),
            keywords: &["叉号按钮", "取消", "方形"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("叉叉"),
            keywords: &["叉", "叉叉"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("交叉符號"),
            keywords: &["交叉", "交叉符號"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("inkinobho yophawu lwesiphambano"),
            keywords: &["inkinobho yophawu lwesiphambano", "iskwele", "umaka"],
        },
    ],
};
#[doc = "➰"]
pub const CURLY_LOOP: crate::Emoji = crate::Emoji {
    glyph: "➰",
    codepoint: "27B0",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "curly loop",
    group: "Symbols",
    subgroup: "other-symbol",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("krullus"),
            keywords: &["krul", "krullus", "lus"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ጥቅልል ሸምቀቆ"),
            keywords: &["ሸምቀቆ", "ጥቅልል"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("عقدة"),
            keywords: &["أنشوطة", "عقدة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("কে\u{981}কোৰ\u{9be} প\u{9be}ক"),
            keywords: &["কে\u{981}কোৰ\u{9be}", "প\u{9be}ক"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("spiral ilmə"),
            keywords: &["ilmə", "spiral"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("звілістая пятля"),
            keywords: &["звілістая пятля", "звілісты", "пятля"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("примка"),
            keywords: &["клуп", "примка"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ক\u{9be}র\u{9cd}লি ল\u{9c1}প"),
            keywords: &[
                "ক\u{9be}র\u{9cd}লি ল\u{9c1}প",
                "ক\u{9c1}ন\u{9cd}ডলী প\u{9be}ক\u{9be}নো",
                "ল\u{9c1}প",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("boukl"),
            keywords: &["boukl"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("uvrnuta petlja"),
            keywords: &["petlja", "rotor", "uvrnuta petlja"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("llaç arrissat"),
            keywords: &["bucle", "llaç", "llaç arrissat"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᎵᏥᏍᏆᏁᏓ ᎦᏕᏱᏍᏛᎢ"),
            keywords: &["ᎤᎵᏥᏍᏆᏁᏓ", "ᎦᏕᏱᏍᏛᎢ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("smyčka"),
            keywords: &["smyčka", "spirálka"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("dolen gyrliog"),
            keywords: &["cwrl", "dolen", "dolen gyrliog"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("krølle"),
            keywords: &["krølle", "loop", "løkke"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Schleife"),
            keywords: &["Schleife"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("βρόχος"),
            keywords: &["βρόγχος", "βρόχος", "μπούκλα"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("curly loop"),
            keywords: &["curl", "curly loop", "loop"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("bucle"),
            keywords: &["bucle", "giro", "tirabuzón"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("silmus"),
            keywords: &["lokk", "silmus"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("malgukia"),
            keywords: &["malguki", "malgukia"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("حلقه مجعد"),
            keywords: &["حلقه", "مجعد"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("silmukka"),
            keywords: &["kaareva silmukka", "silmukka"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("curly loop"),
            keywords: &["curly loop", "kulot", "silo"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("bukt"),
            keywords: &["bukt", "lykkja", "sloyfa", "snar"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("boucle"),
            keywords: &["boucle", "bouclette"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("lúb chatach"),
            keywords: &["cas", "lúb", "lúb chatach"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("lùb dhualach"),
            keywords: &["dualach", "lùb", "lùb dhualach"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("bucle"),
            keywords: &["bucle"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("વા\u{a82}કડિય\u{ac1} લ\u{ac2}પ"),
            keywords: &["લ\u{ac2}પ", "વળા\u{a82}ક", "વા\u{a82}કડિય\u{ac1} લ\u{ac2}પ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("lanƙwasasshen maɗauki"),
            keywords: &["lanƙwasa", "lanƙwasasshen maɗauki", "maɗauki"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("לולאה"),
            keywords: &["לולאה", "תלתל"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("लहरदार फ\u{902}दा"),
            keywords: &["मोड\u{93c}", "लहरदार फ\u{902}दा", "ल\u{942}प"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("vitičasta petlja"),
            keywords: &["petlja", "vitica", "vitičasta petlja"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("hurok"),
            keywords: &["hurok"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ոլորուն հանգույց"),
            keywords: &["հանգույց", "ոլորուն հանգույց", "ոլորված"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("untaian bergelombang"),
            keywords: &["gelombang", "putaran", "untaian bergelombang"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("memmenwè gbagọrọ agbagọ"),
            keywords: &["gbagọọ", "memmenwè", "memmenwè gbagọrọ agbagọ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("lykkja"),
            keywords: &["lykkja"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("occhiello"),
            keywords: &["cerchio", "occhiello"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ループ"),
            keywords: &["ループ", "記号", "輪っか", "長音"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("garis cunthel"),
            keywords: &["cunthel", "garis cunthel", "mlungker"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ხვეული მარყუჟი"),
            keywords: &["მარყუჟი", "ხვეული"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("ілмек"),
            keywords: &["цикл", "ілмек"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("krølle"),
            keywords: &["krølle", "loop", "løkke"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("សញ\u{17d2}ញាខ\u{17d2}សែម\u{17bd}យរង\u{17d2}វេល"),
            keywords: &[
                "ខ\u{17d2}សែ",
                "រង\u{17d2}វេល",
                "សញ\u{17d2}ញា",
                "សញ\u{17d2}ញាខ\u{17d2}សែម\u{17bd}យរង\u{17d2}វេល",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಆರಂಭ\u{cbf}ಕ ಸುರುಳ\u{cbf}"),
            keywords: &["ಆರಂಭ\u{cbf}ಕ ಸುರುಳ\u{cbf}", "ತ\u{cbf}ರುಗ\u{cbf}ಸ\u{cbf}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("고리"),
            keywords: &["고리", "루프"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("क\u{941}रळो वलय"),
            keywords: &["क\u{941}रळो", "वलय"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("тармал кайчылаш"),
            keywords: &["кайчылаш", "тармал"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Schleef"),
            keywords: &["Kréngel", "Schleef"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຫ\u{ec8}ວງ"),
            keywords: &["ວ\u{ebb}ງ", "ຫ\u{ec8}ວງ", "ເສ\u{eb1}\u{ec9}ນໂຄ\u{ec9}ງ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("kilpelė"),
            keywords: &["kilpa", "kilpelė", "raityti"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("cilpiņa"),
            keywords: &["cilpa", "cilpiņa", "sproga"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("koromeke hūmenge"),
            keywords: &["hūmenge", "koromeke"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("свиткана јамка"),
            keywords: &["свиткана", "јамка"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഒര\u{d41} ച\u{d41}ര\u{d41}ള\u{d41}ള\u{d4d}ള ല\u{d42}പ\u{d4d}പ\u{d4d}"),
            keywords: &[
                "ഒര\u{d41} ച\u{d41}ര\u{d41}ള\u{d41}ള\u{d4d}ള ല\u{d42}പ\u{d4d}പ\u{d4d}",
                "ച\u{d41}ര\u{d41}ണ\u{d4d}ട ല\u{d42}പ\u{d4d}പ\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("буржгар хүрд"),
            keywords: &["буржгар", "хүрд"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("वळणदार ल\u{941}प"),
            keywords: &["ल\u{941}प", "वळण", "वळणदार ल\u{941}प"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("gelung ikal"),
            keywords: &["gelung", "ikal"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("loop innukklata"),
            keywords: &["innukklata", "loop"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("လ\u{102d}မ\u{103a}နေသည\u{1037}\u{103a} အက\u{103d}င\u{103a}း"),
            keywords: &[
                "ကြ\u{102d}\u{102f}းက\u{103d}င\u{103a}း",
                "လ\u{102d}မ\u{103a}",
                "လ\u{102d}မ\u{103a}နေသည\u{1037}\u{103a} ကြ\u{102d}\u{102f}းက\u{103d}င\u{103a}း",
                "လ\u{102d}မ\u{103a}နေသည\u{1037}\u{103a} အက\u{103d}င\u{103a}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("løkke"),
            keywords: &["løkke", "løkketegn"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("कर\u{94d}ली ल\u{941}प"),
            keywords: &["कर\u{94d}ली", "ल\u{941}प"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("gekrulde lus"),
            keywords: &["gedraaid", "gekrulde lus", "lus"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("løkke"),
            keywords: &["løkke", "løkketeikn"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("କ\u{b41}ଟୀଳ ବନ\u{b4d}ଧନୀ"),
            keywords: &[
                "କର\u{b4d}ଲ\u{b4d}\u{200c}",
                "କ\u{b41}ଟୀଳ ବନ\u{b4d}ଧନୀ",
                "ଲ\u{b41}ପ\u{b4d}\u{200c}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਕਰਲੀ ਲ\u{a42}ਪ"),
            keywords: &["ਕਰਲੀ ਲ\u{a42}ਪ", "ਮ\u{a4b}ੜ", "ਲ\u{a42}ਪ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("خم دار رسی"),
            keywords: &["خم دار رسی", "رسی", "گھونگر"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Raúnd Shép Rop"),
            keywords: &["Raund", "Raúnd Shép Rop", "Rop"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("pętla"),
            keywords: &["pętla", "zawijas"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("تاو کړۍ"),
            keywords: &["تاو", "کړۍ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("laço encaracolado"),
            keywords: &["laço encaracolado", "loop", "loop ondulado", "volta"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("laço encaracolado"),
            keywords: &["caracol", "laço", "laço encaracolado"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("bucle"),
            keywords: &["bucle"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("buclă ondulată"),
            keywords: &["buclă", "buclă ondulată", "cârlionț", "onduleu"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-152"),
            keywords: &["E10-152"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("петля"),
            keywords: &["значок", "петелька", "петля"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("uruziga rutsitse"),
            keywords: &["gihese", "uruziga rutsitse"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("گھنڊيدار لوپ"),
            keywords: &["مڙيل لوپ", "گھنڊيدار لوپ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("රැළ\u{dd2} ල\u{dd6}පය"),
            keywords: &["රැල\u{dca}ල", "රැළ\u{dd2} ල\u{dd6}පය", "ල\u{dd6}පය"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("slučka"),
            keywords: &["slučka"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("zavita pentlja"),
            keywords: &["pentlja", "spirala", "zanka", "zavita pentlja"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("laaban oo sargo’an"),
            keywords: &["laab", "laaban", "laaban oo sargo’an"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("lak i përdredhur"),
            keywords: &["lak", "lak i përdredhur", "përdredhje"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("петља"),
            keywords: &["заобљено", "пeтљa", "петља"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("petlja"),
            keywords: &["petlja", "zaobljeno"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("ögla"),
            keywords: &["kurva", "slinga", "ögla"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kitanzi kilichopinda"),
            keywords: &["kitanzi", "kitanzi kilichopinda", "pinda"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("சுருள\u{bcd} வளைவு"),
            keywords: &["சுருள\u{bcd}", "சுருள\u{bcd} வளைவு"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("కర\u{c4d}ల\u{c40} లూప\u{c4d}"),
            keywords: &[
                "కర\u{c4d}ల\u{c40} లూప\u{c4d}",
                "మ\u{c46}ల\u{c3f} త\u{c3f}ర\u{c3f}గ\u{c3f}న వంపు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("ҳалқаи пурпечутоб"),
            keywords: &["печ", "ҳалқа", "ҳалқаи пурпечутоб"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ห\u{e48}วง"),
            keywords: &["วง", "ห\u{e48}วง"],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ዕኽሉል ጥውይዋይ"),
            keywords: &["ዕኽሉል ጥውይዋይ", "ጥውይዋይ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("buýra halka"),
            keywords: &["buýra", "halka"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("laine fakasākisi"),
            keywords: &["laine", "laine fakasākisi", "sākisi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("kıvrık döngü"),
            keywords: &["döngü", "dönüş", "kıvrık döngü"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئەگمە ھالقا"),
            keywords: &["ئەگمە", "ھالقا"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("закручена петля"),
            keywords: &["закручена петля", "закручений", "петля"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("کرل ہوئی رسی"),
            keywords: &["رسی", "کرل ہوئی", "کرل ہوئی رسی"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("jingalak halqa"),
            keywords: &["davr", "jingalak", "jingalak halqa", "takror"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("vòng lặp"),
            keywords: &["cong", "vòng lặp"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("buum gu lemu benn yoon"),
            keywords: &["buum gu lemu benn yoon", "lemu", "loop"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("irhintyela eliphotheneyo"),
            keywords: &["irhintyela", "irhintyela eliphotheneyo", "ukuphithana"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("iho wọlọwọlo"),
            keywords: &["iho wọlọwọlo", "lúpù", "ìyípọ\u{300}"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("捲曲圈"),
            keywords: &["圈", "捲曲", "捲曲圈"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("卷曲圈"),
            keywords: &["卷曲", "卷曲圈", "圈"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("卷曲环"),
            keywords: &["单环", "卷曲环", "标志"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("日本單環標誌"),
            keywords: &["單環", "日本單環標誌"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("彎曲線"),
            keywords: &["彎曲線"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("iluphu egobile"),
            keywords: &["iluphu", "iluphu egobile", "ukugoba"],
        },
    ],
};
#[doc = "➿"]
pub const DOUBLE_CURLY_LOOP: crate::Emoji = crate::Emoji {
    glyph: "➿",
    codepoint: "27BF",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "double curly loop",
    group: "Symbols",
    subgroup: "other-symbol",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("dubbelkrullus"),
            keywords: &["dubbel", "dubbelkrullus", "krul", "lus"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ድርብ ጥቅልል ሸምቀቆ"),
            keywords: &["ሸምቀቆ", "ድርብ", "ጥቅልል"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("عقدة مزدوجة"),
            keywords: &["اتصال مجاني", "اليابان", "عقدة", "عقدة مزدوجة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("দ\u{9cd}বৈত কে\u{981}কোৰ\u{9be} প\u{9be}ক"),
            keywords: &["কে\u{981}কোৰ\u{9be}", "দ\u{9cd}বৈত", "প\u{9be}ক"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("ikiqat spiral ilmə"),
            keywords: &["ikiqat", "ilmə", "spiral"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("падвойная звілістая пятля"),
            keywords: &["звілістая", "падвойная", "пятля"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Двойна примка"),
            keywords: &["Двойна примка", "двойна", "примка"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("দ\u{9c1}টি ক\u{9be}র\u{9cd}লি ল\u{9c1}প"),
            keywords: &[
                "ক\u{9c1}ন\u{9cd}ডলী প\u{9be}ক\u{9be}নো",
                "দ\u{9c1}টি ক\u{9be}র\u{9cd}লি ল\u{9c1}প",
                "দ\u{9cd}বিগ\u{9c1}ণ",
                "ল\u{9c1}প",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("boukl doubl"),
            keywords: &["boukl", "boukl doubl"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("dupla uvrnuta petlja"),
            keywords: &["dupla", "dupla uvrnuta petlja", "petlja", "rotor"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("bucle doble"),
            keywords: &["bucle", "doble"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏔᎵ ᏧᎵᏥᏍᏆᏁᏓ ᎦᏕᏱᏍᏛ"),
            keywords: &["ᎤᎵᏥᏍᏆᏁᏓ", "ᎦᏕᏱᏍᏛᎢ", "ᏔᎵ ᏧᎵᏥᏍᏆᏁᏓ ᎦᏕᏱᏍᏛ", "ᏔᎵᎭ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("dvojitá smyčka"),
            keywords: &["dvojitá smyčka", "dvojitý", "smyčka", "spirálka"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("dolen gyrliog ddwbl"),
            keywords: &["cwrl", "dolen", "dolen gyrliog ddwbl", "dwbl"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("dobbelt krølle"),
            keywords: &["dobbelt", "krølle", "loop", "løkke"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Doppelschleife"),
            keywords: &["Doppelschleife", "Rechteck", "Schleife"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("διπλός βρόχος"),
            keywords: &["βρόγχος", "διπλός", "διπλός βρόχος", "μπούκλα"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("double curly loop"),
            keywords: &["curl", "double", "double curly loop", "loop"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("bucle doble"),
            keywords: &["bucle", "doble"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["bucle doble", "doble", "giro"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("topeltsilmus"),
            keywords: &["silmus", "topelt", "topeltsilmus"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("malguki bikoitza"),
            keywords: &["bikoitz", "malguki", "malguki bikoitza"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("حلقه مجعد دوتایی"),
            keywords: &["حلقه", "حلقه مجعد دوتایی", "دوبل", "دوگانه", "مجعد"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kaksoissilmukka"),
            keywords: &["2", "kaksoissilmukka", "nauhuri", "silmukka", "vastaaja"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("dobleng curly loop"),
            keywords: &["doble", "dobleng curly loop", "kulot", "silo"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("dupult bukt"),
            keywords: &["bukt", "dupult", "lykkja", "sloyfa", "snar"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("double boucle"),
            keywords: &["boucle", "double boucle"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("lúb dhúbailte chatach"),
            keywords: &["lúb chatach", "lúb dhúbailte chatach"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("lùb dhualach dhùbailte"),
            keywords: &["dualach", "dùbailte", "lùb", "lùb dhualach dhùbailte"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("bucle dobre"),
            keywords: &["bucle", "dobre"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ડબલ વા\u{a82}કડિય\u{ac1}\u{a82} લ\u{ac2}પ"),
            keywords: &[
                "જાપાન",
                "ડબલ વા\u{a82}કડિય\u{ac1}\u{a82} લ\u{ac2}પ",
                "ફ\u{acd}રી ડાયલ",
                "વા\u{a82}કડિય\u{ac1} લ\u{ac2}પ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("lanƙwasasshen maɗauki biyu"),
            keywords: &["biyu", "lanƙwasa", "lanƙwasasshen maɗauki biyu", "maɗauki"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("לולאה כפולה"),
            keywords: &["כפולה", "לולאה", "תלתל"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("दोहरा कर\u{94d}ली ल\u{942}प"),
            keywords: &[
                "दोहरा कर\u{94d}ली ल\u{942}प",
                "दोहरा लहरदार फ\u{902}दा",
                "लहरदार फ\u{902}दा",
                "ल\u{942}प",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("dvostruka vitičasta petlja"),
            keywords: &[
                "dvostruka vitičasta petlja",
                "dvostruko",
                "petlja",
                "vitica",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("dupla hurok"),
            keywords: &["dupla", "hurok"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("կրկնակի ոլորուն հանգույց"),
            keywords: &["կրկնակի", "կրկնակի ոլորուն հանգույց", "հանգույց", "ոլորված"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("untaian bergelombang ganda"),
            keywords: &[
                "dobel",
                "gelombang",
                "putaran",
                "untaian bergelombang ganda",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("mkpị memmenwè gbagọrọ agbagọ"),
            keywords: &["gbagọo", "memmenwè", "mkpị", "mkpị memmenwè gbagọrọ agbagọ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("tvöföld lykkja"),
            keywords: &["gormur", "lykkjur", "tvöföld lykkja"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("doppio occhiello"),
            keywords: &["doppio", "occhiello"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ダブルループ"),
            keywords: &["ダブルループ", "フリーダイヤル", "ループ", "記号", "輪っか"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("garis cunthel dhobel"),
            keywords: &["cunthel", "dhobel", "garis cunthel dhobel", "mlungker"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ორმაგი ხვეული მარყუჟი"),
            keywords: &["მარყუჟი", "ორმაგი", "ხვეული"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("қос ілмек"),
            keywords: &["цикл", "ілмек", "қос"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("dobbelt krølle"),
            keywords: &["dobbelt", "krølle", "loop", "løkke"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("សញ\u{17d2}ញាខ\u{17d2}សែព\u{17b8}ររង\u{17d2}វេល"),
            keywords: &[
                "ខ\u{17d2}សែ",
                "រង\u{17d2}វេល",
                "សញ\u{17d2}ញា",
                "សញ\u{17d2}ញាខ\u{17d2}សែព\u{17b8}ររង\u{17d2}វេល",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಎರಡು ಆರಂಭ\u{cbf}ಕ ಸುರುಳ\u{cbf}"),
            keywords: &[
                "ಎರಡು ಆರಂಭ\u{cbf}ಕ ಸುರಳ\u{cbf}",
                "ಎರಡು ಆರಂಭ\u{cbf}ಕ ಸುರುಳ\u{cbf}",
                "ಸುರಳ\u{cbf} ಲ\u{cc2}ಪ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("두 개의 고리"),
            keywords: &["두 개의 고리", "두 개의 루프"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("दोट\u{94d}टी क\u{941}रळो वलय"),
            keywords: &["क\u{941}रळो", "दोट\u{94d}टी", "वलय"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("кош тармал кайчылаш"),
            keywords: &["кош", "кош тармал кайчылаш", "тармал"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("duebel Schleef"),
            keywords: &["Kréngel", "Schleef", "duebel"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຫ\u{ec8}ວງຄ\u{eb9}\u{ec8}"),
            keywords: &[
                "ວ\u{ebb}ງ",
                "ຫ\u{ec8}ວງ",
                "ຫ\u{ec8}ວງຄ\u{eb9}\u{ec8}",
                "ເສ\u{eb1}\u{ec9}ນໂຄ\u{ec9}ງ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("dviguba kilpelė"),
            keywords: &["dviguba", "dviguba kilpelė", "kilpa", "raityti"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("dubulta cilpa"),
            keywords: &["cilpa", "dubulta cilpa"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("koromeke hūmenge taurua"),
            keywords: &["hūmenge", "koromeke", "taurua"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("двојна свиткана јамка"),
            keywords: &["двојна", "свиткана", "јамка"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some(
                "രണ\u{d4d}ട\u{d4d} ച\u{d41}ര\u{d41}ള\u{d41}ള\u{d4d}ള ല\u{d42}പ\u{d4d}പ\u{d4d}",
            ),
            keywords: &[
                "ഇരട\u{d4d}ട ച\u{d41}ര\u{d41}ണ\u{d4d}ട ല\u{d42}പ\u{d4d}പ\u{d4d}",
                "രണ\u{d4d}ട\u{d4d} ച\u{d41}ര\u{d41}ള\u{d41}ള\u{d4d}ള ല\u{d42}പ\u{d4d}പ\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("хоёр буржгартай хүрд"),
            keywords: &["буржгар", "хоёр", "хоёр буржгартай хүрд", "хүрд"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("द\u{941}ह\u{947}री वळणदार ल\u{941}प"),
            keywords: &[
                "द\u{941}ह\u{947}री",
                "द\u{941}ह\u{947}री वळणदार ल\u{941}प",
                "ल\u{941}प",
                "वळण",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("gelung ikal berganda"),
            keywords: &["berganda", "gelung", "ikal"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("loop innukklata doppja"),
            keywords: &["doppju", "innukklata", "loop", "loop innukklata doppja"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "လ\u{102d}မ\u{103a}နေသည\u{1037}\u{103a} အက\u{103d}င\u{103a}း န\u{103e}စ\u{103a}ထပ\u{103a}က\u{103d}မ\u{103a}း",
            ),
            keywords: &[
                "ကြ\u{102d}\u{102f}းက\u{103d}င\u{103a}း",
                "န\u{103e}စ\u{103a}ထပ\u{103a}",
                "လ\u{102d}မ\u{103a}",
                "လ\u{102d}မ\u{103a}နေသည\u{1037}\u{103a} ကြ\u{102d}\u{102f}းက\u{103d}င\u{103a}း န\u{103e}စ\u{103a}ထပ\u{103a}က\u{103d}မ\u{103a}း",
                "လ\u{102d}မ\u{103a}နေသည\u{1037}\u{103a} အက\u{103d}င\u{103a}း န\u{103e}စ\u{103a}ထပ\u{103a}က\u{103d}မ\u{103a}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("dobbel løkke"),
            keywords: &["dobbel løkke", "dobbel løkke-tegn"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("दोहोरो कर\u{94d}ली ल\u{941}प"),
            keywords: &["कर\u{94d}ली", "दोहोरो", "ल\u{941}प"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("dubbele gekrulde lus"),
            keywords: &["dubbel", "dubbele gekrulde lus", "krul", "lus"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("dobbel løkke"),
            keywords: &["dobbel løkke", "dobbel løkke-teikn"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଦ\u{b41}ଇଟ\u{b3f} କ\u{b41}ଟୀଳ ବନ\u{b4d}ଧନୀ"),
            keywords: &[
                "କର\u{b4d}ଲ\u{b4d}\u{200c}",
                "ଦ\u{b41}ଇଟ\u{b3f}",
                "ଦ\u{b41}ଇଟ\u{b3f} କ\u{b41}ଟୀଳ ବନ\u{b4d}ଧନୀ",
                "ଲ\u{b41}ପ\u{b4d}\u{200c}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਡਬਲ ਕਰਲੀ ਲ\u{a42}ਪ"),
            keywords: &[
                "ਕਰਲੀ ਲ\u{a42}ਪ",
                "ਜਾਪਾਨ",
                "ਡਬਲ ਕਰਲੀ ਲ\u{a42}ਪ",
                "ਫ\u{a4d}ਰੀ ਡਾਇਲ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("دوہری خم دار رسی"),
            keywords: &["دوہری خم دار رسی", "د\u{64f}گنا", "رسی", "گھونگر"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Dọ\u{301}búl Raúnd Shép Rop"),
            keywords: &[
                "Dọ\u{301}búl",
                "Dọ\u{301}búl Raúnd Shép Rop",
                "Raúnd",
                "Rop",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("podwójna pętla"),
            keywords: &["podwójna", "pętla", "zawijas"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("دوه ځل تاو کړۍ"),
            keywords: &["تاو", "دوه ځل", "دوه ځل تاو کړۍ", "کړۍ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("loop encaracolado duas vezes"),
            keywords: &[
                "duas vezes",
                "duplo",
                "encaradolado",
                "loop",
                "loop encaracolado duas vezes",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("laço encaracolado duplo"),
            keywords: &["caracol", "duplo", "laço", "laço encaracolado duplo"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("iskay bucle"),
            keywords: &["iskay bucle"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("buclă ondulată dublă"),
            keywords: &[
                "buclă",
                "buclă dublă",
                "buclă ondulată dublă",
                "dublu",
                "onduleu",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-153"),
            keywords: &["E10-153"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("двойная петля"),
            keywords: &["две", "двойная", "петля"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("inziga ebyiri zitsitse"),
            keywords: &["gihese", "inshuro ebyiri", "inziga ebyiri zitsitse"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ٻٽي مڙيل لوپ"),
            keywords: &["لوپ", "مڙيل", "ٻٽو", "ٻٽي مڙيل لوپ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ද\u{dca}ව\u{dd2} රැළ\u{dd2} ල\u{dd6}පය"),
            keywords: &[
                "ද\u{dca}ව\u{dd2}",
                "ද\u{dca}ව\u{dd2} රැළ\u{dd2} ල\u{dd6}පය",
                "රැල\u{dca}ල",
                "ල\u{dd6}පය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("dvojitá slučka"),
            keywords: &["dvojitá", "slučka"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("dvojna zavita pentlja"),
            keywords: &[
                "dvojna zavita pentlja",
                "dvojno",
                "pentlja",
                "spirala",
                "zanka",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("maroogsin sargo’an oo laban-laab ah"),
            keywords: &[
                "laab",
                "laban-laab",
                "maroogsin sargo’an oo laban-laab",
                "maroogsin sargo’an oo laban-laab ah",
                "sargo’an",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("lak i përdredhur dy herë"),
            keywords: &[
                "dy herë",
                "i dyfishtë",
                "lak",
                "lak i përdredhur dy herë",
                "përdredhje",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("двострука петља"),
            keywords: &["двoструкo", "двострука петља", "заобљено", "пeтљa"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("dvostruka petlja"),
            keywords: &["dvostruka petlja", "dvostruko", "petlja", "zaobljeno"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("dubbel ögla"),
            keywords: &["dubbel ögla", "öglor"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kitanzi kilichopinda mara mbili"),
            keywords: &[
                "kitanzi",
                "kitanzi kilichopinda mara mbili",
                "mara mbili",
                "pinda",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("இரட\u{bcd}டை சுருள\u{bcd} வளைவு"),
            keywords: &[
                "இரட\u{bcd}டை சுருள\u{bcd}",
                "இரட\u{bcd}டை சுருள\u{bcd} வளைவு",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("డబుల\u{c4d} కర\u{c4d}ల\u{c40} లూప\u{c4d}"),
            keywords: &[
                "డబుల\u{c4d}",
                "డబుల\u{c4d} కర\u{c4d}ల\u{c40} లూప\u{c4d}",
                "మ\u{c46}ల\u{c3f}క",
                "లూప\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("ҳалқаи дутарафа пурпечутоб"),
            keywords: &["дутарфа", "печ", "ҳалқа", "ҳалқаи дутарафа пурпечутоб"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ห\u{e48}วง 2 ร\u{e39}"),
            keywords: &[
                "ห\u{e48}วง",
                "ห\u{e48}วง 2 ร\u{e39}",
                "เส\u{e49}นโค\u{e49}ง",
            ],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ድርብ ዕኽሉል ጥውይዋይ"),
            keywords: &["ድርብ", "ድርብ ዕኽሉል ጥውይዋይ", "ጥውይዋይ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("goşa buýra halka"),
            keywords: &["buýra", "goşa", "halka"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("laine fakasākisi lōua"),
            keywords: &["laine", "laine fakasākisi lōua", "sākisi", "ua"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("çift kıvrık döngü"),
            keywords: &[
                "Japonya",
                "kıvrık döngü",
                "çift kıvrık döngü",
                "ücretsiz numara",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("قوش ئەگمە ھالقا"),
            keywords: &["ئەگمە", "قوش", "ھالقا"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("подвійна закручена петля"),
            keywords: &[
                "закручений",
                "петля",
                "подвійна закручена петля",
                "подвійний",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("دوہری کرل ہوئی رسی"),
            keywords: &["دوہری", "دوہری کرل ہوئی رسی", "رسی", "کرل ہوئی"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("qo‘sh jingalak halqa"),
            keywords: &[
                "davr",
                "ikki marta",
                "jingalak",
                "qo‘sh jingalak halqa",
                "takror",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("vòng lặp đôi"),
            keywords: &["cong", "kép", "vòng lặp", "vòng lặp đôi"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("buum gu lemu ñaari yoon"),
            keywords: &["buukal", "buum gu lemu ñaari yoon", "lemu", "ñaarte"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("irhintyela eliphotheneyo kabini"),
            keywords: &[
                "irhintyela",
                "irhintyela eliphotheneyo kabini",
                "kabini",
                "ukuphithana",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("iho wọlọwọlo meji"),
            keywords: &["iho wọlọwọlo meji", "lúpù", "méjì", "àyípọ\u{300}"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("雙捲曲圈"),
            keywords: &["圈", "捲曲", "雙", "雙捲曲圈"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("双卷曲圈"),
            keywords: &["卷曲", "双", "双卷曲圈", "圈"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("双卷曲环"),
            keywords: &["双卷曲环", "双环", "标志"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("日本免費電話標誌"),
            keywords: &["免費電話", "日本免費電話標誌"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("雙彎曲線"),
            keywords: &["彎曲線", "雙彎曲", "雙彎曲線"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("iluphu eligobile eliyimpinda"),
            keywords: &[
                "iluphu",
                "iluphu eligobile eliyimpinda",
                "impinda",
                "ukugoba",
            ],
        },
    ],
};
#[doc = "〽\u{fe0f}"]
pub const PART_ALTERNATION_MARK: crate::Emoji = crate::Emoji {
    glyph: "〽\u{fe0f}",
    codepoint: "303D FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "part alternation mark",
    group: "Symbols",
    subgroup: "other-symbol",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "〽",
        codepoint: "303D",
        status: crate::Status::Unqualified,
        introduction_version: 0.6f32,
        name: "part alternation mark",
        group: "Symbols",
        subgroup: "other-symbol",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("stembeginteken"),
            keywords: &["begin", "merk", "stem", "stembeginteken"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የክፍል መቀየሪያ ምልክት"),
            keywords: &["ምልክት", "ክፍል", "የክፍል መቀየሪያ ምልክት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("بديل"),
            keywords: &["بديل", "جزء", "علامة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("গ\u{9be}য\u{9bc}কে গ\u{9be}বলগীয\u{9bc}\u{9be} গীতৰ কলি সলনিৰ চিন"),
            keywords: &[
                "গ\u{9be}য\u{9bc}কে গ\u{9be}বলগীয\u{9bc}\u{9be} গীতৰ কলি সলনিৰ চিন",
                "চিন",
                "সংগীতৰ কলি",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("hissələri bir-birindən ayırmaq işarəsi"),
            keywords: &["hissə", "hissələri bir-birindən ayırmaq işarəsi", "işarə"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("знак змены партыі"),
            keywords: &["знак", "знак змены партыі", "песенны", "японскі", "іарытэн"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Знак за смяна на ролята"),
            keywords: &["Знак за смяна на ролята", "знак", "роля"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("অংশ পরিবর\u{9cd}তনের চিহ\u{9cd}ন"),
            keywords: &["অংশ", "অংশ পরিবর\u{9cd}তনের চিহ\u{9cd}ন", "চিহ\u{9cd}ন"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("pebeilad"),
            keywords: &["arouez", "pebeilad"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("oznaka djelimične alteracije"),
            keywords: &["dio", "oznaka", "oznaka djelimične alteracije"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("signe d’alternança"),
            keywords: &["alternança", "signe", "signe d’alternança"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎢᎦᏛ ᎦᏁᏟᏴᏍᏗ ᎤᏙᏪᎸ"),
            keywords: &["ᎢᎦᏛ ᎦᏁᏟᏴᏍᏗ ᎤᏙᏪᎸ", "ᎪᏪᎵ", "ᏱᎦᎥᎢ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("značka přechodu mezi částmi skladby"),
            keywords: &[
                "part",
                "symbol",
                "začátek",
                "znak",
                "značka",
                "značka přechodu mezi částmi skladby",
                "zpěv",
                "zpěvák",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("marc aryneilio rhannol"),
            keywords: &["marc", "marc aryneilio rhannol", "rhan"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("japansk kommatering"),
            keywords: &["del", "japansk", "kommatering"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Teilalternationszeichen"),
            keywords: &["Teilalternationszeichen", "Zeichensetzung", "japanisch"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("σύμβολο εναλλαγής μέρους"),
            keywords: &["σημάδι", "σύμβολο εναλλαγής μέρους", "τμήμα"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("part alternation mark"),
            keywords: &["mark", "part", "part alternation mark"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("marca de alternancia"),
            keywords: &["alternancia", "marca", "marca de alternancia"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("alternancia"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("osa vaheldumise märk"),
            keywords: &["märk", "osa", "osa vaheldumise märk"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("txanda-markatzailea"),
            keywords: &["markatu", "txanda", "txanda-markatzailea"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("علامت تناوب بخش"),
            keywords: &["بخش", "علامت", "علامت تناوب بخش"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("osanvaihtomerkki"),
            keywords: &["ioriten", "japani", "merkki", "osanvaihtomerkki"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("part alternation mark"),
            keywords: &["bahagi", "marka", "pag-alternate", "part alternation mark"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("umskiftistekn"),
            keywords: &["broytin", "frábregði", "umskifti", "umskiftistekn"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("alternance"),
            keywords: &["alternance", "symbole"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("symbole japonais indiquant le début de la musique"),
            keywords: &[
                "début de la musique",
                "japonais",
                "marque",
                "partition",
                "symbole",
                "symbole japonais indiquant le début de la musique",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("cuid de mharc ailtéarnaithe"),
            keywords: &[
                "cuid",
                "cuid de marc ailtéarnú",
                "cuid de mharc ailtéarnaithe",
                "marc",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("comharra airson atharrachadh phàirtean"),
            keywords: &[
                "atharrachadh",
                "comharra",
                "comharra airson atharrachadh phàirtean",
                "pàirt",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("signo de alternancia"),
            keywords: &["alternancia", "signo", "signo de alternancia"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("જાપાની ચિહ\u{acd}ન"),
            keywords: &["ચિહ\u{acd}ન", "જાપાની ચિહ\u{acd}ન", "ભાગ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("alamar maimaitawar kashi"),
            keywords: &["alamar", "alamar maimaitawar kashi", "kashi"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("סמל יפני מתחום המוזיקה"),
            keywords: &["מוזיקה", "סימון", "סמל יפני מתחום המוזיקה", "תחילת שיר"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("भाग परिवर\u{94d}तन चिह\u{94d}न"),
            keywords: &["एक भाग", "चिह\u{94d}न", "भाग परिवर\u{94d}तन चिह\u{94d}न"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("oznaka djelomične alternacije"),
            keywords: &["djelomično", "oznaka djelomične alternacije", "znak"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("részelválasztó"),
            keywords: &["jel", "részelválasztó", "választó"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("իորիտեն"),
            keywords: &["իորիտեն", "մաս", "նշել"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("tanda alternasi bagian"),
            keywords: &["bagian", "tanda", "tanda alternasi bagian"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("akụkụ akara ọzọ"),
            keywords: &["akara", "akụkụ", "akụkụ akara ọzọ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("japanskt upphafsmerki söngs"),
            keywords: &["japanskt upphafsmerki söngs", "merki"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("simbolo di alternanza delle parti"),
            keywords: &[
                "canzone",
                "divisione spartito",
                "parti musicali",
                "segno",
                "simbolo di alternanza delle parti",
                "suddivisione parti",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("いおりてん"),
            keywords: &["いおりてん", "庵点", "歌記号", "約物", "記号"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("tandha rikala sindhen wiwit nyanyi"),
            keywords: &["bageyan", "tandha", "tandha rikala sindhen wiwit nyanyi"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ჯერის ცვლის ნიშანი"),
            keywords: &["ნიშანი", "ჯერი", "ჯერის ცვლის ნიშანი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("бөліктің өзгеру белгісі"),
            keywords: &["белгі", "бөлік", "бөліктің өзгеру белгісі"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("japansk kommatering"),
            keywords: &["del", "japansk", "kommatering"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some(
                "សញ\u{17d2}ញាដ\u{17bc}ចអក\u{17d2}សរ M ធ\u{17c6}ប\u{17d2}រើសម\u{17d2}គាល\u{17cb}ផ\u{17d2}នែកចាប\u{17cb}ផ\u{17d2}តើមច\u{17d2}រៀងក\u{17d2}ន\u{17bb}ងភាសាជប\u{17c9}\u{17bb}ន",
            ),
            keywords: &[
                "M",
                "ច\u{17d2}រៀង",
                "សញ\u{17d2}ញា",
                "សញ\u{17d2}ញាដ\u{17bc}ចអក\u{17d2}សរ M ធ\u{17c6}ប\u{17d2}រើសម\u{17d2}គាល\u{17cb}ផ\u{17d2}នែកចាប\u{17cb}ផ\u{17d2}តើមច\u{17d2}រៀងក\u{17d2}ន\u{17bb}ងភាសាជប\u{17c9}\u{17bb}ន",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಭಾಗ ಪರ\u{ccd}ಯಾಯ ಗುರುತು"),
            keywords: &["ಗುರುತು", "ಭಾಗ ಪರ\u{ccd}ಯಾಯ ಗುರುತು"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("부분 교체 기호"),
            keywords: &["기호", "부분", "부분 교체 기호"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("भाग बदलपाच\u{947}\u{902} चिन\u{94d}न"),
            keywords: &["चिन\u{94d}न", "भाग", "भाग बदलपाच\u{947}\u{902} चिन\u{94d}न"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("өзгөртүү белгиси"),
            keywords: &["белги", "өзгөртүү", "өзгөртүү белгиси"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Deelzeechen"),
            keywords: &["Deelzeechen", "Zeechen", "deelen"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເຄ\u{eb7}\u{ec8}ອງໝາຍປ\u{ec8}ຽນສ\u{ec8}ວນ"),
            keywords: &[
                "ສ\u{ec8}ວນ",
                "ເຄ\u{eb7}\u{ec8}ອງໝາຍ",
                "ເຄ\u{eb7}\u{ec8}ອງໝາຍປ\u{ec8}ຽນສ\u{ec8}ວນ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("dalių apkeitimo ženklas"),
            keywords: &["dalis", "dalių apkeitimo ženklas", "žymė"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("partijas sākuma zīme"),
            keywords: &["mūzika", "partijas sākuma zīme", "zīme"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tohu wāhi whirihoa"),
            keywords: &["tohu", "tohu wāhi whirihoa", "wāhi"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("почеток на пеење"),
            keywords: &["ознака", "пеење", "почеток", "почеток на пеење", "јапонски"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("പ\u{d3e}ർട\u{d4d}ട\u{d4d} ആൾട\u{d4d}ടർനേഷൻ മ\u{d3e}ർക\u{d4d}ക\u{d4d}"),
            keywords: &[
                "അടയ\u{d3e}ളം",
                "പ\u{d3e}ർട\u{d4d}ട\u{d4d}",
                "പ\u{d3e}ർട\u{d4d}ട\u{d4d} ആൾട\u{d4d}ടർനേഷൻ മ\u{d3e}ർക\u{d4d}ക\u{d4d}",
                "ഭ\u{d3e}ഗം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("хэсэг нь ээлжилсэн тэмдэг"),
            keywords: &["тэмдэг", "хэсэг", "хэсэг нь ээлжилсэн тэмдэг", "ээлжлэх"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("पार\u{94d}ट अल\u{94d}टरन\u{947}शन चिन\u{94d}ह"),
            keywords: &[
                "चिन\u{94d}ह",
                "पार\u{94d}ट",
                "पार\u{94d}ट अल\u{94d}टरन\u{947}शन चिन\u{94d}ह",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("tanda penyelingan bahagian"),
            keywords: &["bahagian", "tanda", "tanda penyelingan bahagian"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("marka ta’ alternanza ta’ parti"),
            keywords: &["marka", "marka ta’ alternanza ta’ parti", "parti"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ပစ\u{1039}စည\u{103a}း လ\u{1032}ထားသည\u{1037}\u{103a} အမ\u{103e}တ\u{103a}"),
            keywords: &[
                "ပစ\u{1039}စည\u{103a}း",
                "ပစ\u{1039}စည\u{103a}း လ\u{1032}ထားသည\u{1037}\u{103a} အမ\u{103e}တ\u{103a}",
                "အမ\u{103e}တ\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("merke for nytt parti"),
            keywords: &["merke", "merke for nytt parti", "nytt", "parti"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("भाग प\u{94d}रत\u{94d}यावर\u{94d}तन चिन\u{94d}ह"),
            keywords: &[
                "चिन\u{94d}ह",
                "भाग",
                "भाग प\u{94d}रत\u{94d}यावर\u{94d}तन चिन\u{94d}ह",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("rolwisselingsmarkering"),
            keywords: &["markering", "rolwisselingsmarkering", "teken"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("merke for nytt parti"),
            keywords: &["merke", "merke for nytt parti", "nytt", "parti"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଅଂଶ ବ\u{b3f}କଳ\u{b4d}ପ ଚ\u{b3f}ହ\u{b4d}ନ"),
            keywords: &[
                "ଅଂଶ",
                "ଅଂଶ ବ\u{b3f}କଳ\u{b4d}ପ ଚ\u{b3f}ହ\u{b4d}ନ",
                "ଚ\u{b3f}ହ\u{b4d}ନ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਭਾਗ ਅਦਲਾ-ਬਦਲੀ ਚਿ\u{a70}ਨ\u{a4d}ਹ"),
            keywords: &[
                "ਅ\u{a71}ਖਰ",
                "ਚਿ\u{a70}ਨ\u{a4d}ਹ",
                "ਭਾਗ",
                "ਭਾਗ ਅਦਲਾ-ਬਦਲੀ ਚਿ\u{a70}ਨ\u{a4d}ਹ",
                "ਹਿ\u{a71}ਸਾ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("حص\u{651}ے دی ادلی بدلی دا نشان"),
            keywords: &["حص\u{651}ہ", "حص\u{651}ے دی ادلی بدلی دا نشان", "نشان لانا"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Pát Ọltanéshọn Mak"),
            keywords: &["Mak", "Pat", "Pát Ọltanéshọn Mak"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("początek partii wokalnej"),
            keywords: &["początek partii wokalnej", "znak", "zygzak"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د برخې بدلولو نښه"),
            keywords: &["برخه", "برخه بدلول نښه", "د برخې بدلولو نښه", "نښه"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("sinal japonês indicando início de música"),
            keywords: &[
                "canto",
                "japonês",
                "sinal japonês indicando início de música",
                "símbolo japonês de canto",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("marca de alternância parcial"),
            keywords: &["entrada", "marca de alternância parcial", "música"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("alternancia patma unancha"),
            keywords: &["alternancia patma unancha"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("alternare cântăreț"),
            keywords: &[
                "alternare cântăreț",
                "cântăreț",
                "marcaj",
                "schimbare",
                "semn",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-164"),
            keywords: &["E10-164"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("вступает другой голос"),
            keywords: &[
                "вступает другой голос",
                "голос",
                "другой голос",
                "знак",
                "певцы",
                "япония",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("akarango k’igice cy’ihinduranya"),
            keywords: &["akarango", "akarango k’igice cy’ihinduranya", "igice"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("حصو ڦير جو نشان"),
            keywords: &["حصو", "حصو ڦير جو نشان", "نشان"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("කොටසක\u{dca} වෙනස\u{dca} ක\u{dd2}ර\u{dd3}මේ ලක\u{dd4}ණ"),
            keywords: &[
                "කොටස",
                "කොටසක\u{dca} වෙනස\u{dca} ක\u{dd2}ර\u{dd3}මේ ලක\u{dd4}ණ",
                "ලක\u{dd4}ණ",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("znak začiatku partu"),
            keywords: &["part", "znak", "znak začiatku partu"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("znak za part"),
            keywords: &["part", "znak", "znak za part"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("qaybta calaamadda talantaalliga ah"),
            keywords: &["calaamad", "qayb", "qaybta calaamadda talantaalliga ah"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("shenja e ndryshimit të pjesës"),
            keywords: &["pjesë", "shenja e ndryshimit të pjesës", "shenjë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("знак за раздвајање делова"),
            keywords: &["део", "знaк", "знак за раздвајање делова"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("знак за раздвајање дијелова"),
            keywords: &["знак за раздвајање дијелова"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("znak za razdvajanje delova"),
            keywords: &["deo", "znak", "znak za razdvajanje delova"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("znak za razdvajanje dijelova"),
            keywords: &["znak za razdvajanje dijelova"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("japansk kommatering"),
            keywords: &["japansk", "kommatering"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("alama ya mbadala ya sehemu"),
            keywords: &["alama", "alama ya mbadala ya sehemu", "sehemu"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பகுதியளவு ம\u{bbe}றும\u{bcd} சின\u{bcd}னம\u{bcd}"),
            keywords: &[
                "பகுதியளவு ம\u{bbe}றும\u{bcd} சின\u{bcd}னம\u{bcd}",
                "ப\u{bbe}தி ம\u{bbe}றும\u{bcd} சின\u{bcd}னம\u{bcd}",
                "ம\u{bbe}றும\u{bcd} சின\u{bcd}னம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ప\u{c3e}క\u{c4d}ష\u{c3f}క సవరణ గుర\u{c4d}తు"),
            keywords: &[
                "గుర\u{c4d}తు",
                "ప\u{c3e}క\u{c4d}ష\u{c3f}క సవరణ గుర\u{c4d}తు",
                "ప\u{c3e}క\u{c4d}ష\u{c3f}కం",
                "భ\u{c3e}గం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("аломати тағйирёбии қисм"),
            keywords: &["аломат", "аломати тағйирёбии қисм", "қисм"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เคร\u{e37}\u{e48}องหมายเปล\u{e35}\u{e48}ยนท\u{e48}อน"),
            keywords: &[
                "ท\u{e48}อน",
                "เคร\u{e37}\u{e48}องหมาย",
                "เคร\u{e37}\u{e48}องหมายเปล\u{e35}\u{e48}ยนท\u{e48}อน",
            ],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ኣማራጺ ምልክት ክፋል"),
            keywords: &["ምልክት", "ኣማራጺ ምልክት ክፋል", "ክፋል"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("bölek çalşyk belgisi"),
            keywords: &["bellijek", "bölek", "bölek çalşyk belgisi"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("fakaʻilonga liliu faʻahi"),
            keywords: &["fakaʻilonga", "faʻahi", "liliu"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("parça değiştirme işareti"),
            keywords: &["işaret", "parça", "parça değiştirme işareti"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("قىسمەن ئۆزگەرتىش بەلگىسى"),
            keywords: &["بەلگە", "قىسمەن", "قىسمەن ئۆزگەرتىش بەلگىسى"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("японський знак початку частини пісні"),
            keywords: &["значок", "частина", "японський знак початку частини пісні"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("باری کی تبدیلی کا نشان"),
            keywords: &["باری", "باری کی تبدیلی کا نشان", "علامت", "موسیقار"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("ovoz almashinuvi belgisi"),
            keywords: &["belgi", "ovoz almashinuvi belgisi", "qism"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("ký hiệu thay đổi luân phiên"),
            keywords: &[
                "ký hiệu",
                "ký hiệu thay đổi luân phiên",
                "thay đổi luân phiên",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("màndarga beneen wàll"),
            keywords: &["màndarga", "màndarga beneen wàll", "wàll"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("uphawu lwenguqulelo oluyinxalenye"),
            keywords: &["inxalenye", "uphawu", "uphawu lwenguqulelo oluyinxalenye"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("ara máàkì ti a ti tọwó\u{329}bọ\u{300}"),
            keywords: &["ara", "ara máàkì ti a ti tọwó\u{329}bọ\u{300}", "àmì"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("歌記號"),
            keywords: &["標誌", "歌記號"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("歌记号"),
            keywords: &["标志", "歌记号"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("庵点"),
            keywords: &["庵点", "开始歌唱", "符号"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("歌唱"),
            keywords: &["歌唱", "歌記號"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("歌謠開始記號"),
            keywords: &["歌謠開始記號", "開始記號"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("upahwu lokulungisa ingxenye"),
            keywords: &["ingxenye", "upahwu lokulungisa ingxenye", "uphawu"],
        },
    ],
};
#[doc = "✳\u{fe0f}"]
pub const EIGHT_SPOKED_ASTERISK: crate::Emoji = crate::Emoji {
    glyph: "✳\u{fe0f}",
    codepoint: "2733 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "eight-spoked asterisk",
    group: "Symbols",
    subgroup: "other-symbol",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "✳",
        codepoint: "2733",
        status: crate::Status::Unqualified,
        introduction_version: 0.6f32,
        name: "eight-spoked asterisk",
        group: "Symbols",
        subgroup: "other-symbol",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("agtspeekasterisk"),
            keywords: &["agtspeekasterisk", "asterisk", "ster"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ባለ ስምንት ቀስት አስትሪክስ"),
            keywords: &["ባለ ስምንት ቀስት አስትሪክስ", "አስትሪክስ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("نجمة ثمانية"),
            keywords: &["نجمة", "نجمة ثمانية"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("অষ\u{9cd}ট-অৰ দণ\u{9cd}ডবিশিষ\u{9cd}ট তৰ\u{9be} চিন"),
            keywords: &[
                "*",
                "অষ\u{9cd}ট-অৰ দণ\u{9cd}ডবিশিষ\u{9cd}ট তৰ\u{9be} চিন",
                "তৰ\u{9be} চিন",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("səkkiz tərəfli ulduz"),
            keywords: &["səkkiz tərəfli ulduz", "ulduz"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("васьміканцовая зорачка"),
            keywords: &["*", "астэрыск", "васьміканцовая", "зорачка"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Звезда с осем лъча"),
            keywords: &["Звезда с осем лъча", "звезда"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("আটটি -স\u{9cd}পোকের ত\u{9be}রক\u{9be}চিহ\u{9cd}ন"),
            keywords: &[
                "*",
                "আটটি -স\u{9cd}পোকের ত\u{9be}রক\u{9be}চিহ\u{9cd}ন",
                "ত\u{9be}রক\u{9be}চিহ\u{9cd}ন",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("steredennig eizh brecʼh"),
            keywords: &["*", "steredennig", "steredennig eizh brecʼh"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("osmerokraka zvjezdica"),
            keywords: &["*", "osmerokraka zvjezdica", "zvjezdica"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("asterisc de vuit radis"),
            keywords: &["*", "asterisc", "asterisc de vuit radis"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏧᏁᎳ-ᏧᏯᏓᏘ ᎤᏙᏪᎸ"),
            keywords: &["*", "ᎤᏙᏪᎸ", "ᏧᏁᎳ-ᏧᏯᏓᏘ ᎤᏙᏪᎸ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("osmicípá hvězdička"),
            keywords: &["*", "hvězdička", "osmicípá hvězdička"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("asterics wyth pwynt"),
            keywords: &["*", "asterics", "asterics wyth pwynt"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("ottetakket spids stjerne"),
            keywords: &["*", "asterisk", "ottetakket spids stjerne"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("achtzackiger Stern"),
            keywords: &[
                "Achtzackiger Stern",
                "Quadrat",
                "Stern",
                "achtzackig",
                "achtzackiger Stern",
                "grün",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("οκτάκτινος αστερίσκος"),
            keywords: &["*", "αστερίσκος", "οκτάκτινος αστερίσκος"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("eight-spoked asterisk"),
            keywords: &["*", "asterisk", "eight-spoked asterisk"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("asterisco de ocho puntas"),
            keywords: &["*", "asterisco", "asterisco de ocho puntas"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kaheksa tipuga tärn"),
            keywords: &["*", "kaheksa tipuga tärn", "tärn"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("zortzi puntako izartxoa"),
            keywords: &["izartxo", "zortzi puntako izartxoa"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("ستاره هشت\u{200c}پره"),
            keywords: &["ستاره", "ستاره هشت پر", "ستاره هشت\u{200c}پره"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kahdeksanpiikkinen tähtimerkki"),
            keywords: &[
                "8",
                "asteriski",
                "kahdeksanpiikkinen tähtimerkki",
                "tähti",
                "tähtimerkki",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("asterisk na may walong sulok"),
            keywords: &["asterisk", "asterisk na may walong sulok", "sulok", "walo"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("áttatinda stjørna"),
            keywords: &["stjørna", "áttatinda stjørna"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("astérisque huit branches"),
            keywords: &[
                "*",
                "astérisque",
                "astérisque huit branches",
                "huit",
                "étoile",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("astérique à huit branches"),
            keywords: &["astérique", "astérique à huit branches", "huit branches"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("réiltín le hocht spóca"),
            keywords: &["* réiltín", "réiltín le hocht spóca"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("reultag le ochd rinnean"),
            keywords: &["*", "reultag", "reultag le ochd rinnean"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("asterisco de oito raios"),
            keywords: &["*", "asterisco", "asterisco de oito raios", "estrela"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("આઠ કિનારીવાળ\u{ac1}\u{a82} તારાન\u{ac1}\u{a82} ચિહ\u{acd}ન"),
            keywords: &[
                "*",
                "આઠ કિનારીવાળ\u{ac1}\u{a82} તારાન\u{ac1}\u{a82} ચિહ\u{acd}ન",
                "તારો",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("asterisk mai tsini takwas"),
            keywords: &["alamar asterisk", "asterisk mai tsini takwas"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("כוכבית עם שמונה פינות"),
            keywords: &["אסטריסק", "כוכבית", "כוכבית עם שמונה פינות"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("आठ सिरो\u{902} वाला तारक चिह\u{94d}न"),
            keywords: &["आठ सिरो\u{902} वाला तारक चिह\u{94d}न", "चिह\u{94d}न"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("osmerokraka zvjezdica"),
            keywords: &["osmerokraka zvjezdica", "zvjezdica"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("nyolcágú csillag"),
            keywords: &["csillag", "nyolcágú csillag"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ութ թևանի աստղանիշ"),
            keywords: &["աստղանիշ", "ութ թևանի աստղանիշ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("bintang berujung lancip delapan"),
            keywords: &["bintang berujung lancip delapan", "tanda bintang"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("otù n’ime akàràmmùke-asatọ"),
            keywords: &["akàràmmùke", "otù n’ime akàràmmùke-asatọ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("áttarma stjörnumerki"),
            keywords: &["*", "stjarna", "áttarma stjarna", "áttarma stjörnumerki"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("asterisco"),
            keywords: &["asterisco", "otto punte", "sfondo verde"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("八角アスタリスク"),
            keywords: &["アスタリスク", "八角アスタリスク", "約物", "記号"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("asterisk kembang wolu"),
            keywords: &["*", "asterisk", "asterisk kembang wolu"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("რვაქიმიანი ასტერისკი"),
            keywords: &["ასტერისკი", "რვაქიმიანი ასტერისკი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("сегіз бұрышты жұлдыз"),
            keywords: &["жұлдызша", "сегіз бұрышты жұлдыз"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("ottetakket spids stjerne"),
            keywords: &["asterisk", "ottetakket spids stjerne", "stjerne"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some(
                "សញ\u{17d2}ញាផ\u{17d2}កាយម\u{17bb}ខស\u{17d2}រ\u{17bd}ចប\u{17d2}រា\u{17c6}ប\u{17b8}",
            ),
            keywords: &[
                "*",
                "ផ\u{17d2}កាយ",
                "សញ\u{17d2}ញាផ\u{17d2}កាយ",
                "សញ\u{17d2}ញាផ\u{17d2}កាយម\u{17bb}ខស\u{17d2}រ\u{17bd}ចប\u{17d2}រា\u{17c6}ប\u{17b8}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಎಂಟು-ಸ\u{ccd}ಪೋಕ\u{ccd} ನಕ\u{ccd}ಷತ\u{ccd}ರ"),
            keywords: &[
                "*",
                "ಆಸ\u{ccd}ಟ\u{ccd}ರ\u{cbf}ಕ\u{ccd}ಸ\u{ccd}",
                "ಎಂಟು-ಸ\u{ccd}ಪೋಕ\u{ccd} ನಕ\u{ccd}ಷತ\u{ccd}ರ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("여덟 갈래 별표"),
            keywords: &["별표", "여덟 갈래 별표"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("आठ-आ\u{902}साच\u{947}\u{902} नख\u{947}त\u{94d}र"),
            keywords: &[
                "*",
                "आठ-आ\u{902}साच\u{947}\u{902} नख\u{947}त\u{94d}र",
                "नख\u{947}त\u{94d}र",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("сегиз жылдыз"),
            keywords: &["жылдызча", "сегиз жылдыз"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("aachtzackege Stärchen"),
            keywords: &["Asterisk", "aachtzackege Stärchen"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເຄ\u{eb7}\u{ec8}ອງໝາຍດອກຈ\u{eb1}ນ"),
            keywords: &[
                "ດອກຈ\u{eb1}ນ",
                "ເຄ\u{eb7}\u{ec8}ອງໝາຍ",
                "ເຄ\u{eb7}\u{ec8}ອງໝາຍດອກຈ\u{eb1}ນ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("aštuoniakampė žvaigždutė"),
            keywords: &["aštuoniakampė žvaigždutė", "žvaigždutė"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("astoņstaru zvaigznīte"),
            keywords: &["*", "astoņstaru zvaigznīte", "zvaigznīte"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("whetūriki waru-pito"),
            keywords: &["whetūriki", "whetūriki waru-pito"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("ѕвездичка со осум крака"),
            keywords: &["*", "ѕвездичка", "ѕвездичка со осум крака"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some(
                "എയ\u{d4d}\u{200c}റ\u{d4d}റ\u{d4d} സ\u{d4d}\u{200c}പോക\u{d4d}ക\u{d4d}ഡ\u{d4d} ആസ\u{d4d}\u{200c}റ\u{d4d}റെറിസ\u{d4d}\u{200c}ക\u{d4d}ക\u{d4d}",
            ),
            keywords: &[
                "*",
                "ആസ\u{d4d}\u{200c}റ\u{d4d}റെറിസ\u{d4d}\u{200c}ക\u{d4d}ക\u{d4d}",
                "എട\u{d4d}ട\u{d4d} ഭ\u{d41}ജങ\u{d4d}ങള\u{d41}ള\u{d4d}ള നക\u{d4d}ഷത\u{d4d}രം",
                "എയ\u{d4d}\u{200c}റ\u{d4d}റ\u{d4d} സ\u{d4d}\u{200c}പോക\u{d4d}ക\u{d4d}ഡ\u{d4d} ആസ\u{d4d}\u{200c}റ\u{d4d}റെറിസ\u{d4d}\u{200c}ക\u{d4d}ക\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("найман зовхист од"),
            keywords: &["*", "найман зовхист од", "од"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("आठ-तारा असल\u{947}ला तारा"),
            keywords: &["आठ-तारा असल\u{947}ला तारा", "तारा"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("asterisk berjejari lapan"),
            keywords: &["*", "asterisk", "asterisk berjejari lapan"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("stilla bi tmien linji"),
            keywords: &["stilla", "stilla bi tmien linji"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ရ\u{103e}စ\u{103a}ချ\u{103d}န\u{103a}း ခရေပ\u{103d}င\u{1037}\u{103a}"),
            keywords: &[
                "ခရေပ\u{103d}င\u{1037}\u{103a}",
                "ရ\u{103e}စ\u{103a}ချ\u{103d}န\u{103a}း ခရေပ\u{103d}င\u{1037}\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("asterisk med åtte spisser"),
            keywords: &["*", "asterisk", "asterisk med åtte spisser", "stjerne"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("आठवटा-बोल\u{947}को तारा\u{902}कन चिन\u{94d}ह"),
            keywords: &[
                "आठवटा-बोल\u{947}को तारा\u{902}कन चिन\u{94d}ह",
                "तारा\u{902}कन चिन\u{94d}ह",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("achtpuntige asterisk"),
            keywords: &["*", "achtpuntige asterisk", "asterisk"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("asterisk med åtte spissar"),
            keywords: &["*", "asterisk", "asterisk med åtte spissar", "stjerne"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some(
                "ଆଠ-ଖ\u{b3e}ଡ\u{b3c}\u{b3f} ଯ\u{b41}କ\u{b4d}ତ ତ\u{b3e}ର\u{b3e}କ\u{b43}ତ\u{b3f} ଚ\u{b3f}ହ\u{b4d}ନ",
            ),
            keywords: &[
                "ଆଠ-ଖ\u{b3e}ଡ\u{b3c}\u{b3f} ଯ\u{b41}କ\u{b4d}ତ ତ\u{b3e}ର\u{b3e}କ\u{b43}ତ\u{b3f} ଚ\u{b3f}ହ\u{b4d}ନ",
                "ତ\u{b3e}ର\u{b3e}କ\u{b43}ତ\u{b3f} ଚ\u{b3f}ହ\u{b4d}ନ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਅ\u{a71}ਠ-ਕਿਰਨਾ\u{a02} ਵਾਲਾ ਤਾਰਾ"),
            keywords: &["ਅ\u{a71}ਠ-ਕਿਰਨਾ\u{a02} ਵਾਲਾ ਤਾਰਾ", "ਤਾਰਾ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("آٹھ-بولیاں گئیاں نشانیاں"),
            keywords: &["آٹھ-بولیاں گئیاں نشانیاں", "نجمہ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Astẹ\u{301}risk Wé Gẹ\u{301}t Ẹ\u{301}t Spok"),
            keywords: &[
                "Astẹ\u{301}risk",
                "Astẹ\u{301}risk Wé Gẹ\u{301}t Ẹ\u{301}t Spok",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("gwiazdka ośmioramienna"),
            keywords: &["*", "gwiazdka", "gwiazdka ośmioramienna"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("اته ګوټې اسټيريسک"),
            keywords: &["*", "اته کوټی اسټيريسک", "اته ګوټې اسټيريسک", "اسټيريسک"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("asterisco de oito pontas"),
            keywords: &["*", "asterisco", "asterisco de oito pontas"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("asterisco com oito raios"),
            keywords: &["*", "asterisco", "asterisco com oito raios"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("pusaq siqiwan asterisco"),
            keywords: &["pusaq siqiwan asterisco"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("asterisc cu opt colțuri"),
            keywords: &["asterisc", "asterisc cu opt colțuri"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-136"),
            keywords: &["E10-136"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("восьмиконечная звездочка"),
            keywords: &["восьмиконечная", "звезда", "звездочка"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("akanyenyeri kagizwe n’imitwe umunani"),
            keywords: &["akanyenyeri", "akanyenyeri kagizwe n’imitwe umunani"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("اٺ ڳالهائڻ جا ايسٽيرڪ"),
            keywords: &["*", "ايسٽيرڪ", "اٺ ڳالهائڻ جا ايسٽيرڪ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ගර\u{dcf}ද\u{dd2} අටේ තර\u{dd4} ලක\u{dd4}ණ"),
            keywords: &[
                "ඇස\u{dca}ටර\u{dd2}ස\u{dca}ක\u{dca}",
                "ගර\u{dcf}ද\u{dd2} අටේ තර\u{dd4} ලක\u{dd4}ණ",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("osemcípa hviezdička"),
            keywords: &["*", "hviezdička", "osemcípa"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("zvezdica z osmimi špicami"),
            keywords: &["*", "zvezdica", "zvezdica z osmimi špicami"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("siddeed geesood oo isku nooc u taaggan"),
            keywords: &["*", "calaamad", "siddeed geesood oo isku nooc u taaggan"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("yllth me tetë cepa me majë"),
            keywords: &["yllth", "yllth me tetë cepa me majë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("осмокрака звезда"),
            keywords: &["звeздицa", "осмокрака звезда"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("осмокрака звијезда"),
            keywords: &["осмокрака звијезда"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("osmokraka zvezda"),
            keywords: &["osmokraka zvezda", "zvezdica"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("osmokraka zvijezda"),
            keywords: &["osmokraka zvijezda"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("åttauddig spetsig stjärna"),
            keywords: &["spetsig", "stjärna", "åttauddig"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kinyota chenye ncha nane"),
            keywords: &["*", "kinyota", "kinyota chenye ncha nane"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("எட\u{bcd}டு முனை உடுக\u{bcd}குறி"),
            keywords: &[
                "எட\u{bcd}டு முனை உடுக\u{bcd}குறி",
                "நட\u{bcd}சத\u{bcd}திரக\u{bcd} குறி",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some(
                "ఎన\u{c3f}మ\u{c3f}ద\u{c3f} మ\u{c4a}నలు గల య\u{c3e}స\u{c4d}ట\u{c46}ర\u{c3f}స\u{c4d}క\u{c4d}",
            ),
            keywords: &[
                "ఎన\u{c3f}మ\u{c3f}ద\u{c3f}",
                "ఎన\u{c3f}మ\u{c3f}ద\u{c3f} మ\u{c4a}నలు గల య\u{c3e}స\u{c4d}ట\u{c46}ర\u{c3f}స\u{c4d}క\u{c4d}",
                "య\u{c3e}స\u{c4d}ట\u{c46}ర\u{c3f}స\u{c4d}క\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("ситорачаи ҳашт паррадор"),
            keywords: &["ситорача", "ситорачаи ҳашт паррадор"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ดอกจ\u{e31}น 8 ซ\u{e35}\u{e48}"),
            keywords: &[
                "*",
                "ดอกจ\u{e31}น 8 ซ\u{e35}\u{e48}",
                "ดอกจ\u{e31}น 8 แฉก",
                "เคร\u{e37}\u{e48}องหมายดอกจ\u{e31}น",
            ],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ሻሙናይ-መሳልል ኣስተሪስክ"),
            keywords: &["*", "ሻሙናይ-መሳልል ኣስተሪስክ", "ኣስተሪስክ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("bellijek"),
            keywords: &["*", "bellijek", "sekiz uçly ýyldyz", "ýyldyz"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("fakaʻilonga fakafetuʻu huelovalu"),
            keywords: &[
                "fakaʻilonga",
                "fakaʻilonga fakafetuʻu huelovalu",
                "fetuʻu",
                "huelo",
                "valu",
            ],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("sekiz uçlu yıldız"),
            keywords: &["*", "asterisk", "sekiz uçlu yıldız", "yıldız"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("سەككىز بۇرجەكلىك يۇلتۇز بەلگىسى"),
            keywords: &["سەككىز بۇرجەكلىك يۇلتۇز بەلگىسى", "يۇلتۇز بەلگىسى"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("восьмикутний астериск"),
            keywords: &[
                "*",
                "астериск",
                "восьмикутна зірка",
                "восьмикутний астериск",
                "знак",
                "зірочка",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("آٹھ کانٹوں والا اسٹیرسک"),
            keywords: &[
                "*",
                "آٹھ کانٹوں والا اسٹیرسک",
                "آٹھ کونوں والا ستارہ",
                "ستارہ",
            ],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("sakkiz qirrali yulduz"),
            keywords: &["*", "sakkiz qirrali yulduz", "yulduzcha"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("dấu hoa thị tám cánh"),
            keywords: &["dấu hoa thị", "dấu hoa thị tám cánh"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("asterisk bu 8 car"),
            keywords: &["asterisk", "asterisk bu 8 car"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("inkwenkwezana eneencam ezisibhozo"),
            keywords: &["ikwenkwezana", "inkwenkwezana eneencam ezisibhozo"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("àmì àkíyèsí onígbá-mé\u{329}jọ"),
            keywords: &["àmì àkíyèsí onígbá-mé\u{329}jọ", "àmì àkíyésì"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("八角星"),
            keywords: &["*", "八角星", "星"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("八角星"),
            keywords: &["八角星", "星"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("八轮辐星号"),
            keywords: &["八轮辐星号", "星号"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("八芒星"),
            keywords: &["八芒星"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["八芒星", "八角星"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("inkanyezi enemigxa eyisishiyagalombili"),
            keywords: &["inkanyezi", "inkanyezi enemigxa eyisishiyagalombili"],
        },
    ],
};
#[doc = "✴\u{fe0f}"]
pub const EIGHT_POINTED_STAR: crate::Emoji = crate::Emoji {
    glyph: "✴\u{fe0f}",
    codepoint: "2734 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "eight-pointed star",
    group: "Symbols",
    subgroup: "other-symbol",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "✴",
        codepoint: "2734",
        status: crate::Status::Unqualified,
        introduction_version: 0.6f32,
        name: "eight-pointed star",
        group: "Symbols",
        subgroup: "other-symbol",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("agtpuntster"),
            keywords: &["agtpuntster", "ster"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ባለስምንት ነጥብ ኮከብ"),
            keywords: &["ባለስምንት ነጥብ ኮከብ", "ኮከብ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("نجمة بثمان نقاط"),
            keywords: &["نجمة", "نجمة بثمان نقاط"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("অষ\u{9cd}ট\u{9be}গ\u{9cd}ৰবিশিষ\u{9cd}ট তৰ\u{9be} চিন"),
            keywords: &[
                "*",
                "অষ\u{9cd}ট\u{9be}গ\u{9cd}ৰবিশিষ\u{9cd}ট তৰ\u{9be} চিন",
                "তৰ\u{9be}",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("səkkiz guşəli ulduz"),
            keywords: &["səkkiz guşəli ulduz", "ulduz"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("васьміканцовая зорка"),
            keywords: &["*", "васьміканцовая зорка", "зорка"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Осмолъчна звезда"),
            keywords: &["Осмолъчна звезда", "звезда"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("আটটি পয\u{9bc}েন\u{9cd}টের ত\u{9be}র\u{9be}"),
            keywords: &[
                "*",
                "আটটি পয\u{9bc}েন\u{9cd}টের ত\u{9be}র\u{9be}",
                "ত\u{9be}র\u{9be}",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("steredenn eizh brecʼh"),
            keywords: &["*", "steredenn", "steredenn eizh brecʼh"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("osmerokraka zvijezda"),
            keywords: &["*", "osmerokraka zvijezda", "zvijezda"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("estrella de vuit puntes"),
            keywords: &["*", "estrella", "estrella de vuit puntes"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏧᏁᎳ-ᏗᎪᏍᏓᏱ ᏃᏈᏏ"),
            keywords: &["*", "ᏃᏈᏏ", "ᏧᏁᎳ-ᏗᎪᏍᏓᏱ ᏃᏈᏏ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("osmicípá hvězda"),
            keywords: &["*", "hvězda", "osmicípá hvězda"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("seren wyth pwynt"),
            keywords: &["*", "seren", "seren wyth pwynt"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("ottetakket stjerne"),
            keywords: &["*", "ottetakket stjerne", "stjerne"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("achtstrahliger Stern"),
            keywords: &["*", "Stern", "achtstrahliger Stern"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("οκτάκτινο αστέρι"),
            keywords: &["*", "αστέρι", "οκτάκτινο αστέρι"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("eight-pointed star"),
            keywords: &["*", "eight-pointed star", "star"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("estrella de ocho puntas"),
            keywords: &["*", "estrella", "estrella de ocho puntas"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kaheksa tipuga täht"),
            keywords: &["*", "kaheksa tipuga täht", "täht"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("zortzi puntako izarra"),
            keywords: &["izar", "zortzi puntako izarra"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("ستاره هشت\u{200c}پر"),
            keywords: &["ستاره", "ستاره هشت\u{200c}پر"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kahdeksankärkinen tähti"),
            keywords: &[
                "8",
                "asteriski",
                "kahdeksankärkinen tähti",
                "tähti",
                "tähtimerkki",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("bituin na may walong sulok"),
            keywords: &[
                "bituin",
                "bituin na may walong sulok",
                "matulis",
                "sulok",
                "walo",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("áttaspíska stjørna"),
            keywords: &["stjørna", "áttaspíska stjørna"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("étoile huit branches"),
            keywords: &["*", "astérisque", "huit", "étoile", "étoile huit branches"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("étoile à huit branches"),
            keywords: &["huit branches", "étoile", "étoile à huit branches"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("réalta le hocht bpointe"),
            keywords: &["*", "réalta", "réalta le hocht bpointe"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("rionnag le ochd rinnean"),
            keywords: &["*", "rionnag", "rionnag le ochd rinnean"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("estrela de oito puntas"),
            keywords: &["*", "asterisco", "estrela", "estrela de oito puntas"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("આઠ કિનારીવાળો તારો"),
            keywords: &["*", "આઠ કિનારીવાળો તારો", "તારો"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("tauraro mai tsini takwas"),
            keywords: &["tauraro", "tauraro mai tsini takwas"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("כוכב עם שמונה פינות"),
            keywords: &["כוכב", "כוכב עם שמונה פינות"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("आठ किनारो\u{902} वाला तारा"),
            keywords: &["आठ किनारो\u{902} वाला तारा", "चिह\u{94d}न"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("osmerokraka zvijezda"),
            keywords: &["osmerokraka zvijezda", "zvijezda"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("nyolcas csillag"),
            keywords: &["csillag", "nyolcas csillag"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ութ թևանի աստղ"),
            keywords: &["*", "աստղ", "ութ թևանի աստղ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("bintang berujung delapan"),
            keywords: &["bintang", "bintang berujung delapan"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("kpakpando asatọ-arụtụrụ aka"),
            keywords: &["kpakpando", "kpakpando asatọ-arụtụrụ aka"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("áttarma stjarna"),
            keywords: &["stjarna", "áttarma stjarna"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("stella stilizzata"),
            keywords: &["asterisco", "stella stilizzata"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("八角星"),
            keywords: &["八角星", "星", "約物", "記号"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("lintang mata wolu"),
            keywords: &["*", "lintang", "lintang mata wolu"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("რვაქიმიანი ვარსკვლავი"),
            keywords: &["ვარსკვლავი", "რვაქიმიანი ვარსკვლავი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("сегіз қырлы жұлдыз"),
            keywords: &["жұлдыз", "сегіз қырлы жұлдыз"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("ottetakket stjerne"),
            keywords: &["ottetakket stjerne", "stjerne"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("សញ\u{17d2}ញាផ\u{17d2}កាយម\u{17bb}ខប\u{17d2}រា\u{17c6}ប\u{17b8}"),
            keywords: &[
                "*",
                "ផ\u{17d2}កាយ",
                "សញ\u{17d2}ញាផ\u{17d2}កាយម\u{17bb}ខប\u{17d2}រា\u{17c6}ប\u{17b8}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಎಂಟು ಬ\u{cbf}ಂದುಗಳ ನಕ\u{ccd}ಷತ\u{ccd}ರ"),
            keywords: &[
                "*",
                "ಎಂಟು ಬ\u{cbf}ಂದುಗಳ ನಕ\u{ccd}ಷತ\u{ccd}ರ",
                "ನಕ\u{ccd}ಷತ\u{ccd}ರ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("팔각 별"),
            keywords: &["별", "팔각 별"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("आठ-बि\u{902}द\u{941}\u{902}च\u{947}\u{902} नख\u{947}त\u{94d}र"),
            keywords: &[
                "*",
                "आठ-बि\u{902}द\u{941}\u{902}च\u{947}\u{902} नख\u{947}त\u{94d}र",
                "नख\u{947}त\u{94d}र",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("төрт жылдыз"),
            keywords: &["жылдыз", "төрт жылдыз"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("aachtzackege Stär"),
            keywords: &["Stär", "aachtzackege Stär"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ດາວແປດແຈ"),
            keywords: &["ດາວ", "ດາວແປດແຈ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("aštuoniakampė žvaigždė"),
            keywords: &["aštuoniakampė žvaigždė", "žvaigždė"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("četrstaru zvaigzne"),
            keywords: &["*", "astoņstaru zvaigzne", "zvaigzne", "četrstaru zvaigzne"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("whetū waru-pito"),
            keywords: &["whetū", "whetū waru-pito"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("ѕвезда со осум крака"),
            keywords: &["*", "ѕвезда", "ѕвезда со осум крака"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("എട\u{d4d}ട\u{d4d} ഭ\u{d41}ജങ\u{d4d}ങള\u{d41}ള\u{d4d}ള നക\u{d4d}ഷത\u{d4d}രം"),
            keywords: &[
                "*",
                "എട\u{d4d}ട\u{d4d} ഭ\u{d41}ജങ\u{d4d}ങള\u{d41}ള\u{d4d}ള നക\u{d4d}ഷത\u{d4d}രം",
                "നക\u{d4d}ഷത\u{d4d}രം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("найман хошуутай од"),
            keywords: &["*", "найман хошуутай од", "од"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("आठ-टोक\u{947} असल\u{947}ला तारा"),
            keywords: &["आठ-टोक\u{947} असल\u{947}ला तारा", "तारा"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("bintang berpenjuru lapan"),
            keywords: &["*", "bintang", "bintang berpenjuru lapan"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("stilla bi tmien ponot"),
            keywords: &["stilla", "stilla bi tmien ponot"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ရ\u{103e}စ\u{103a}ထောင\u{1037}\u{103a} ကြယ\u{103a}"),
            keywords: &[
                "ကြယ\u{103a}",
                "ရ\u{103e}စ\u{103a}ထောင\u{1037}\u{103a} ကြယ\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("åttetagget stjerne"),
            keywords: &["*", "stjerne", "åttetagget stjerne"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("आठवटा-विन\u{94d}द\u{942} भएको तारा"),
            keywords: &["आठवटा-विन\u{94d}द\u{942} भएको तारा", "तारा"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("achtpuntige ster"),
            keywords: &["*", "achtpuntige ster", "ster"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("åttetagga stjerne"),
            keywords: &["*", "stjerne", "åttetagga stjerne"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଆଠ-ମ\u{b41}ନ\u{b3f}ଆ ତ\u{b3e}ର\u{b3e}"),
            keywords: &[
                "*",
                "ଆଠ-ମ\u{b41}ନ\u{b3f}ଆ ତ\u{b3e}ର\u{b3e}",
                "ତ\u{b3e}ର\u{b3e}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਅ\u{a71}ਠ-ਬਿ\u{a70}ਦ\u{a42}ਆ\u{a02} ਵਾਲਾ ਤਾਰਾ"),
            keywords: &["ਅ\u{a71}ਠ-ਬਿ\u{a70}ਦ\u{a42}ਆ\u{a02} ਵਾਲਾ ਤਾਰਾ", "ਤਾਰਾ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("آٹھ-اشارہ کیتے ستارے"),
            keywords: &["آٹھ-اشارہ کیتے ستارے", "تارہ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Sta Wé Gẹ\u{301}t Ẹ\u{301}t Pọint"),
            keywords: &["Sta", "Sta Wé Gẹ\u{301}t Ẹ\u{301}t Pọint"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("gwiazda ośmioramienna"),
            keywords: &["*", "gwiazda", "gwiazda ośmioramienna"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("اته ګوټی ستوري"),
            keywords: &["*", "اته ګوټی ستوري", "اته ګوټی ستوری", "ستوری"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("estrela de oito pontas"),
            keywords: &["*", "estrela", "estrela de oito pontas"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("estrela com oito pontas"),
            keywords: &["estrela", "estrela com oito pontas"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("pusaq ñawpikunawan quyllur"),
            keywords: &["pusaq ñawpikunawan quyllur"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("stea cu opt colțuri"),
            keywords: &["stea", "stea cu opt colțuri"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-137"),
            keywords: &["E10-137"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("восьмиконечная звезда"),
            keywords: &["восьмиконечная", "звезда"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("inyenyeri igizwe n’imitwe umunani"),
            keywords: &["inyenyeri", "inyenyeri igizwe n’imitwe umunani"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("اٺ نوڪدار نشان"),
            keywords: &["*", "اٺ نوڪدار نشان", "تارو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("කොණ\u{dca} අටේ තර\u{dd4}ව"),
            keywords: &["කොණ\u{dca} අටේ තර\u{dd4}ව", "තර\u{dd4}ව"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("osemcípa hviezda"),
            keywords: &["*", "hviezda", "osemcípa"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("osemkraka zvezda"),
            keywords: &["*", "osemkraka zvezda", "zvezda"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("xiddig siddeed geeslood oo tilmaama"),
            keywords: &[
                "* xiddig siddeed geeslood oo tilmaama",
                "xiddig",
                "xiddig siddeed geeslood oo tilmaama",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("yll me tetë cepa"),
            keywords: &["yll", "yll me tetë cepa"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("осмокрака звездица"),
            keywords: &["звeздa", "осмокрака звездица"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("осмокрака звјездица"),
            keywords: &["осмокрака звјездица"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("osmokraka zvezdica"),
            keywords: &["osmokraka zvezdica", "zvezda"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("osmokraka zvjezdica"),
            keywords: &["osmokraka zvjezdica"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("åttauddig stjärna"),
            keywords: &["stjärna", "åttauddig"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("nyota yenye ncha nane"),
            keywords: &["*", "nyota", "nyota yenye ncha nane"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("எட\u{bcd}டு முனை நட\u{bcd}சத\u{bcd}திரம\u{bcd}"),
            keywords: &[
                "எட\u{bcd}டு முனை",
                "எட\u{bcd}டு முனை நட\u{bcd}சத\u{bcd}திரம\u{bcd}",
                "நட\u{bcd}சத\u{bcd}திரம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ఎన\u{c3f}మ\u{c3f}ద\u{c3f} క\u{c4b}ణ\u{c3e}ల నక\u{c4d}షత\u{c4d}రం"),
            keywords: &[
                "ఎన\u{c3f}మ\u{c3f}ద\u{c3f}",
                "ఎన\u{c3f}మ\u{c3f}ద\u{c3f} క\u{c4b}ణ\u{c3e}ల నక\u{c4d}షత\u{c4d}రం",
                "త\u{c3e}ర",
                "నక\u{c4d}షత\u{c4d}రం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("ситораи ҳашт нӯгдор"),
            keywords: &["ситора", "ситораи ҳашт нӯгдор"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ดาว 8 แฉก"),
            keywords: &["*", "ดาว", "ดาว 8 แฉก"],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ሻሙናይ-ነጥቢ ኮኾብ"),
            keywords: &["*", "ሻሙናይ-ነጥቢ ኮኾብ", "ኮኾብ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("sekiz tikenli ýyldyzjyk"),
            keywords: &["sekiz tikenli ýyldyzjyk", "sekiz uçly ýyldyz", "ýyldyz"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("fakaʻilonga fakafetuʻu tapavalu"),
            keywords: &[
                "fakaʻilonga",
                "fakaʻilonga fakafetuʻu tapavalu",
                "fetuʻu",
                "tapa",
                "valu",
            ],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("sekiz noktalı yıldız"),
            keywords: &["*", "sekiz noktalı yıldız", "yıldız"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("سەككىز بۇرجەكلىك يۇلتۇز"),
            keywords: &["سەككىز بۇرجەكلىك يۇلتۇز", "يۇلتۇز"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("восьмикінцева зірка"),
            keywords: &["*", "восьмикінцева зірка", "вісім виступів", "зірка"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("آٹھ کونوں والا ستارہ"),
            keywords: &["*", "آٹھ کونوں والا ستارہ", "ستارہ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("sakkiz burchakli yulduz"),
            keywords: &["*", "sakkiz burchakli yulduz", "yulduz"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("ngôi sao tám cánh"),
            keywords: &["ngôi sao tám cánh"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("biddeewu 8 cat"),
            keywords: &["biddeew", "biddeewu 8 cat"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("inkwenkwezi eneencam ezisibhozo"),
            keywords: &["inkwenkwezi", "inkwenkwezi eneencam ezisibhozo"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("àmì àkíyèsí onígun-mé\u{329}jọ"),
            keywords: &["àmì àkíyèsí onígun-mé\u{329}jọ", "ìràwọ\u{300}"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("八角星星"),
            keywords: &["*", "八角星星", "星"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("八角星星"),
            keywords: &["八角星星", "星"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("八角星"),
            keywords: &["八角星", "星", "符号"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("八角星"),
            keywords: &["八角星"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("八角星"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("inkanyezi ecije kayisishayagalombili"),
            keywords: &["inkanyezi", "inkanyezi ecije kayisishayagalombili"],
        },
    ],
};
#[doc = "❇\u{fe0f}"]
pub const SPARKLE: crate::Emoji = crate::Emoji {
    glyph: "❇\u{fe0f}",
    codepoint: "2747 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "sparkle",
    group: "Symbols",
    subgroup: "other-symbol",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "❇",
        codepoint: "2747",
        status: crate::Status::Unqualified,
        introduction_version: 0.6f32,
        name: "sparkle",
        group: "Symbols",
        subgroup: "other-symbol",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("vonkster"),
            keywords: &["ster", "vonk", "vonkster"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("አንጸባራቂ"),
            keywords: &["አንጸባራቂ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("ومضة"),
            keywords: &["شرارة", "ومضة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("তিৰবিৰণি"),
            keywords: &["*", "তিৰবিৰণি"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("qığılcım"),
            keywords: &["qığılcım"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("іскра"),
            keywords: &["*", "іскра"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Искра"),
            keywords: &["Искра", "искра"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("জ\u{9cd}বলজ\u{9cd}বল কর\u{9be}"),
            keywords: &["*", "জ\u{9cd}বলজ\u{9cd}বল কর\u{9be}"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("strinkad"),
            keywords: &["*", "strinkad"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("iskra"),
            keywords: &["*", "iskra"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("espurna"),
            keywords: &["*", "espurna"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᏥᏍᏓᎷᎩᏍᎩ"),
            keywords: &["ᎤᏥᏍᏓᎷᎩᏍᎩ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("jiskra"),
            keywords: &["*", "jiskra", "jiskérka", "jiskřička"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("fflachiad"),
            keywords: &["*", "fflachiad"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("funkle"),
            keywords: &["*", "funkle"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Funkeln"),
            keywords: &["*", "Funkeln"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("σπινθήρας"),
            keywords: &["*", "λάμψη", "σπινθήρας"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("sparkle"),
            keywords: &["*", "sparkle"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("chispa"),
            keywords: &["*", "chispa"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["chispa"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("sädelus"),
            keywords: &["*", "sädelus"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("txinparta"),
            keywords: &["*", "txinparta"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("جرقه"),
            keywords: &["برق", "تلألو", "جرقه", "جرقه زدن", "درخشش"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kipinä"),
            keywords: &["kipinä", "säihke", "tähti"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("kinang"),
            keywords: &["kinang", "kislap"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("glampi"),
            keywords: &[
                "glampa", "glampi", "glitra", "glógva", "ljóma", "skyggja", "stjørna",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("éclat"),
            keywords: &["*", "briller", "scintiller", "éclat", "étinceler"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("gealán"),
            keywords: &["*", "gealán"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("lainnir"),
            keywords: &["*", "lainnir"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("chispa"),
            keywords: &["*", "chispa"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ચમક"),
            keywords: &["*", "ચમક", "સ\u{acd}પાર\u{acd}કલ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("ƙyalƙyali"),
            keywords: &["ƙyalƙyali"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("נוצץ"),
            keywords: &["כוכבית", "נוצץ", "נצנוץ"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("जगमगाहट"),
            keywords: &["चि\u{902}गारी", "चिह\u{94d}न", "जगमगाहट"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("iskra"),
            keywords: &["iskra", "zvjezdica"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("szikra"),
            keywords: &["szikra"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("կայծիկ"),
            keywords: &["*", "կայծիկ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("kilauan"),
            keywords: &["*", "kilauan"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("icheku ọkụ"),
            keywords: &["icheku ọkụ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("leiftur"),
            keywords: &["*", "leiftur"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("scintilla stilizzata"),
            keywords: &["scintilla", "scintilla stilizzata", "sfondo verde"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("スパークル"),
            keywords: &["アスタリスク", "スパークル", "約物", "記号"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("kelip-kelip"),
            keywords: &["*", "kelip-kelip"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ნაპერწკალი"),
            keywords: &["ნაპერწკალი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("ұшқын"),
            keywords: &["ұшқын"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("funkle"),
            keywords: &["funkle", "funklen", "glans", "stråle"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ពន\u{17d2}ល\u{17ba}ចា\u{17c6}ង"),
            keywords: &["*", "ចា\u{17c6}ង", "ពន\u{17d2}ល\u{17ba}ចា\u{17c6}ង"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಸ\u{ccd}ಪಾರ\u{ccd}ಕಲ\u{ccd}"),
            keywords: &["*", "ಸ\u{ccd}ಪಾರ\u{ccd}ಕಲ\u{ccd}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("반짝임"),
            keywords: &["반짝", "반짝임"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("चकचक"),
            keywords: &["*", "चकचक"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("жалтылдак"),
            keywords: &["жалтылдак", "жылдызча"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Fonken"),
            keywords: &["Fonken"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ປະກາຍ"),
            keywords: &["ປະກາຍ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("kibirkštėlė"),
            keywords: &["kibirkštis", "kibirkštėlė"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("dzirkstis"),
            keywords: &["*", "dzirkstis"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("korakora"),
            keywords: &["korakora"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("искра"),
            keywords: &["*", "искра"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("സ\u{d4d}\u{200c}പ\u{d3e}ർക\u{d4d}കിൾ"),
            keywords: &["*", "സ\u{d4d}\u{200c}പ\u{d3e}ർക\u{d4d}കിൾ"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("оч"),
            keywords: &["*", "гялбаа", "оч"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("चमक"),
            keywords: &["चमक"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("kilauan"),
            keywords: &["*", "kilauan"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("ileħħ"),
            keywords: &["ileħħ"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အရောင\u{103a}လက\u{103a}နေခြင\u{103a}း"),
            keywords: &[
                "ဝင\u{103a}းလက\u{103a}",
                "အရောင\u{103a}လက\u{103a}နေခြင\u{103a}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("gnist"),
            keywords: &["*", "gnist"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("चम\u{94d}किन\u{947}"),
            keywords: &["चम\u{94d}किन\u{947}"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("sprankeling"),
            keywords: &["*", "sprankelen", "sprankeling"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("gnist"),
            keywords: &["*", "gnist"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଚମକ"),
            keywords: &["*", "ଚମକ"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਚਮਕ"),
            keywords: &["ਚਮਕ", "ਚਮਕਣਾ", "ਲਿਸ\u{a3c}ਕ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("جگ مگ کرنا"),
            keywords: &["جگ مگ کرنا"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Spákul"),
            keywords: &["Spákul"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("iskra"),
            keywords: &["*", "iskra"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ځلېدل"),
            keywords: &["*", "ځلېدل"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("faísca"),
            keywords: &["*", "faísca"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["*", "brilho", "centelha", "faísca"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("k’anchay"),
            keywords: &["k’anchay"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("strălucire"),
            keywords: &["*", "lumină", "strălucire"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-139"),
            keywords: &["E10-139"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("искра"),
            keywords: &["искра", "мерцание"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("igishashi"),
            keywords: &["igishashi"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ٽمڪڻ"),
            keywords: &["ٽمڪڻ", "ڦلجڙي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ද\u{dd2}ද\u{dd4}ලන"),
            keywords: &["ද\u{dd2}ද\u{dd4}ලන", "ස\u{dca}ප\u{dcf}කල\u{dca}"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("iskra"),
            keywords: &["*", "iskra", "trblietanie"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("iskra"),
            keywords: &["*", "iskra"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("dhalaal"),
            keywords: &["*", "dhalaal"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("xixëllim"),
            keywords: &["xixëllim"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("искра"),
            keywords: &["искрa", "искра"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("iskra"),
            keywords: &["iskra"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("glittra"),
            keywords: &["glittra", "gnistra"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("metameta"),
            keywords: &["*", "metameta"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ஸ\u{bcd}ப\u{bbe}ர\u{bcd}கில\u{bcd}"),
            keywords: &[
                "திட\u{bc0}ர\u{bcd} வெளிச\u{bcd}சம\u{bcd}",
                "ஸ\u{bcd}ப\u{bbe}ர\u{bcd}கில\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("మ\u{c46}రుపు"),
            keywords: &["క\u{c3e}ంత\u{c3f}", "మ\u{c46}రుపు"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("ялаққос задан"),
            keywords: &["ялаққос задан"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เปล\u{e48}งประกาย"),
            keywords: &["*", "ประกาย", "เปล\u{e48}งประกาย"],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ኣብለጭላጪ"),
            keywords: &["*", "ኣብለጭላጪ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("uçgun"),
            keywords: &["*", "uçgun"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("ʻilonga fetapatapaki"),
            keywords: &["fetapatapaki", "ʻilonga"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("parlama"),
            keywords: &["*", "parlama"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("چاقناش"),
            keywords: &["چاقناش"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("блискітка"),
            keywords: &["*", "блискітка"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("چمک"),
            keywords: &["*", "چمک"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("uchqun"),
            keywords: &["*", "uchqun"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("lấp lánh"),
            keywords: &["lấp lánh"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("eklaa"),
            keywords: &["eklaa"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("khazimla"),
            keywords: &["khazimla"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("dán"),
            keywords: &["dán"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("閃閃"),
            keywords: &["*", "閃閃"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("闪闪"),
            keywords: &["闪闪"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("火花"),
            keywords: &["火花", "烟火", "闪耀"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("火花"),
            keywords: &["火花"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["火花", "閃光"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ukubhanyaza"),
            keywords: &["ukubhanyaza"],
        },
    ],
};
#[doc = "©\u{fe0f}"]
pub const COPYRIGHT: crate::Emoji = crate::Emoji {
    glyph: "©\u{fe0f}",
    codepoint: "00A9 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "copyright",
    group: "Symbols",
    subgroup: "other-symbol",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "©",
        codepoint: "00A9",
        status: crate::Status::Unqualified,
        introduction_version: 0.6f32,
        name: "copyright",
        group: "Symbols",
        subgroup: "other-symbol",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("kopieregmerk"),
            keywords: &["kopiereg", "kopieregmerk"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የቅጂ መብት"),
            keywords: &["የቅጂ መብት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("علامة حقوق نشر"),
            keywords: &["حقوق طبع", "علامة حقوق نشر"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("স\u{9cd}বত\u{9cd}ব\u{9be}ধিক\u{9be}ৰ চিহ\u{9cd}ন"),
            keywords: &[
                "c",
                "স\u{9cd}বত\u{9cd}ব\u{9be}ধিক\u{9be}ৰ",
                "স\u{9cd}বত\u{9cd}ব\u{9be}ধিক\u{9be}ৰ চিহ\u{9cd}ন",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("müəllif hüququ"),
            keywords: &["müəllif hüququ"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("значок аўтарскага права"),
            keywords: &["аўтарскае права", "значок аўтарскага права"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Авторско право"),
            keywords: &["Авторско право", "авторско право"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("কপির\u{9be}ইট"),
            keywords: &["c", "কপির\u{9be}ইট"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("copyright"),
            keywords: &["c", "copyright"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("autorsko pravo"),
            keywords: &["autorska prava", "autorsko pravo", "c"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("drets d’autor"),
            keywords: &["copyright", "drets d’autor"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᏤᎵᎢ ᎤᎯᏴᎢ"),
            keywords: &["c", "ᎤᏤᎵᎢ ᎤᎯᏴᎢ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("znak ochrany autorského práva"),
            keywords: &[
                "autorská práva",
                "c",
                "copyright",
                "znak ochrany autorského práva",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("hawlfraint"),
            keywords: &["c", "hawlfraint"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("copyright"),
            keywords: &["copyright", "copyright-tegn", "ophavsret"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Copyright"),
            keywords: &["C", "Copyright"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("πνευματική ιδιοκτησία"),
            keywords: &["c", "πνευματικά δικαιώματα", "πνευματική ιδιοκτησία"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("copyright"),
            keywords: &["c", "copyright"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("copyright"),
            keywords: &["c", "copyright", "símbolo"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("signo de derechos autor"),
            keywords: &["autor", "copyright", "derechos", "signo de derechos autor"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("símbolo de derechos de autor"),
            keywords: &[
                "autor",
                "copyright",
                "derechos",
                "signo de derechos autor",
                "símbolo de derechos de autor",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("autoriõigus"),
            keywords: &["autoriõigus", "c"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("copyrighta"),
            keywords: &["copyright", "copyrighta"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("حق نسخه\u{200c}برداری"),
            keywords: &[
                "حق تکثیر",
                "حق طبع و نشر",
                "حق نسخه\u{200c}برداری",
                "حق نشر",
                "حق چاپ",
                "کپی رایت",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("tekijänoikeusmerkki"),
            keywords: &["C", "tekijänoikeus", "tekijänoikeusmerkki"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("karapatang magpalathala"),
            keywords: &[
                "karapatan",
                "karapatang magpalathala",
                "magpalathala",
                "pag-aari",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("upphavsrættur"),
            keywords: &["c", "upphavsrætt", "upphavsrættur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("symbole copyright"),
            keywords: &["c", "copyright", "symbole copyright", "©"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["copyright", "symbole copyright"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("cóipcheart"),
            keywords: &["c", "cóipcheart"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("còir-lethbhreac"),
            keywords: &["(c)", "c", "còir-lethbhreac", "©"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("copyright"),
            keywords: &["C", "autor", "copyright", "dereitos"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("કૉપિરાઇટન\u{ac1}\u{a82} ચિહ\u{acd}ન"),
            keywords: &["c", "કૉપિરાઇટ", "કૉપિરાઇટન\u{ac1}\u{a82} ચિહ\u{acd}ન"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("haƙƙin mallaka"),
            keywords: &["haƙƙin mallaka"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("זכויות יוצרים"),
            keywords: &["זכויות יוצרים"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("कॉपीराइट"),
            keywords: &["कॉपीराइट", "कॉपीराइट चिह\u{94d}न"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("znak za autorska prava"),
            keywords: &["autorska prava", "copyright", "znak za autorska prava"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("copyright (szerzői jog által védett)"),
            keywords: &[
                "copyright (szerzői jog által védett)",
                "szerzői jog",
                "védett",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("հեղինակային իրավունք"),
            keywords: &["հեղինակային իրավունք"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("hak cipta"),
            keywords: &["hak cipta"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ènwemikikere ọrụnkà"),
            keywords: &["ènwemikikere ọrụnkà"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("höfundarréttarmerki"),
            keywords: &[
                "höfundarréttarmerki",
                "höfundarréttarvarið",
                "höfundarréttur",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("copyright"),
            keywords: &["copyright"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("著作権マーク"),
            keywords: &["Cマーク", "コピーライト", "著作権", "著作権マーク", "記号"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("hak cipta"),
            keywords: &["c", "hak cipta"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("საავტორო უფლება"),
            keywords: &["საავტორო უფლება", "საავტორო უფლებები"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("авторлық құқық белгісі"),
            keywords: &["авторлық", "авторлық құқық белгісі", "белгі", "құқық"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("copyright"),
            keywords: &["copyright", "copyright-tegn", "ophavsret"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ស\u{17b7}ទ\u{17d2}ធ\u{17b7}ចម\u{17d2}លង"),
            keywords: &[
                "c",
                "រក\u{17d2}សាស\u{17b7}ទ\u{17d2}ធ\u{17b7}",
                "ស\u{17b7}ទ\u{17d2}ធ\u{17b7}ចម\u{17d2}លង",
                "ស\u{17b7}ទ\u{17d2}ធ\u{17b7}អ\u{17d2}នកន\u{17b7}ពន\u{17d2}ធ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕೃತ\u{cbf}ಸ\u{ccd}ವಾಮ\u{ccd}ಯ"),
            keywords: &[
                "ಕೃ",
                "ಕೃತ\u{cbf}ಸ\u{ccd}ವಾಮ\u{ccd}ಯ",
                "ಕೃತ\u{cbf}ಸ\u{ccd}ವಾಮ\u{ccd}ಯ ಚ\u{cbf}ಹ\u{ccd}ನ\u{cc6}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("저작권"),
            keywords: &["동그라미 C", "씨", "저작권"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("मालकीहक\u{94d}क"),
            keywords: &["c", "मालकीहक\u{94d}क"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("автордук укук"),
            keywords: &["автордук укук"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Copyright"),
            keywords: &["Copyright"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເຄ\u{eb7}\u{ec8}ອງໝາຍລ\u{eb4}ຂະສ\u{eb4}ດ"),
            keywords: &[
                "ລ\u{eb4}ຂະສ\u{eb4}ດ",
                "ເຄ\u{eb7}\u{ec8}ອງໝາຍລ\u{eb4}ຂະສ\u{eb4}ດ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("autorių teisės"),
            keywords: &["autorių teisės"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("autortiesības"),
            keywords: &["(C)", "autortiesības", "c"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("manatārua"),
            keywords: &["manatārua"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("авторски права"),
            keywords: &["авторски", "права"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("പകർപ\u{d4d}പവക\u{d3e}ശ ചിഹ\u{d4d}നം"),
            keywords: &[
                "C",
                "പകർപ\u{d4d}പവക\u{d3e}ശ ചിഹ\u{d4d}നം",
                "പകർപ\u{d4d}പവക\u{d3e}ശം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("зохиогчийн эрх"),
            keywords: &["c", "зохиогчийн эрх"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("कॉपीराइट चिन\u{94d}ह"),
            keywords: &["कॉपीराइट", "कॉपीराइट चिन\u{94d}ह"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("hak cipta"),
            keywords: &["c", "hak cipta"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("drittijiet tal-awtur"),
            keywords: &["drittijiet tal-awtur"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("မ\u{1030}ပ\u{102d}\u{102f}င\u{103a}ခ\u{103d}င\u{1037}\u{103a}"),
            keywords: &["မ\u{1030}ပ\u{102d}\u{102f}င\u{103a}ခ\u{103d}င\u{1037}\u{103a}"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("opphavsrett"),
            keywords: &["copyright", "opphavsrett"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("प\u{94d}रतिलिपि अधिकार"),
            keywords: &["प\u{94d}रतिलिपि अधिकार"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("copyright"),
            keywords: &["c", "copyright"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("opphavsrett"),
            keywords: &["copyright", "opphavsrett"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("କପ\u{b3f}ର\u{b3e}ଇଟ\u{b4d}\u{200c}"),
            keywords: &["c", "କପ\u{b3f}ର\u{b3e}ଇଟ\u{b4d}\u{200c}"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਕਾਪੀਰਾਈਟ ਚਿ\u{a70}ਨ\u{a4d}ਹ"),
            keywords: &[
                "ਕਾਪੀਰਾਈਟ",
                "ਕਾਪੀਰਾਈਟ ਚਿ\u{a70}ਨ\u{a4d}ਹ",
                "ਕਾਪੀਰਾਈਟ ਪ\u{a4d}ਰਤੀਕ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("حق\u{650} اشاعت"),
            keywords: &["حق\u{650} اشاعت"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Kọ\u{301}pírait"),
            keywords: &["Kọ\u{301}pírait", "c"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("znak praw autorskich"),
            keywords: &["copyright", "prawa autorskie", "znak praw autorskich"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د چاپ حق"),
            keywords: &["د چاپ حق", "سي"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("símbolo de copyright"),
            keywords: &["copyright", "símbolo de copyright"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("direitos de autor"),
            keywords: &["c", "direitos de autor"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("copyright"),
            keywords: &["copyright"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("drepturi de autor"),
            keywords: &["c", "copyright", "drepturi de autor"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-000"),
            keywords: &["E10-000"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("значок защиты авторского права"),
            keywords: &[
                "авторские права",
                "авторское право",
                "защита авторских прав",
                "значок защиты авторского права",
                "копирайт",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("kipirayiti"),
            keywords: &["kipirayiti"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڪاپي رائيٽ"),
            keywords: &["c", "ڪاپي رائيٽ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("කත\u{dd4}හ\u{dd2}ම\u{dd2}කම"),
            keywords: &["කත\u{dd4}හ\u{dd2}ම\u{dd2}කම"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("copyright"),
            keywords: &["autorské právo", "copyright"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("avtorske pravice"),
            keywords: &["avtorske pravice", "c"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("xuquuqda daabacaadda"),
            keywords: &["c", "xuquuqda daabacaadda"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("të drejtat e autorit"),
            keywords: &["të drejtat e autorit"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("ауторска права"),
            keywords: &["aутoрскa прaвa", "ауторска права"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("autorska prava"),
            keywords: &["autorska prava"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("upphovsrättssymbol"),
            keywords: &["copyright", "upphovsrätt", "upphovsrättssymbol"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("hakimiliki"),
            keywords: &["c", "hakimiliki"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பதிப\u{bcd}புரிமைச\u{bcd} சின\u{bcd}னம\u{bcd}"),
            keywords: &[
                "பதிப\u{bcd}புரிமை",
                "பதிப\u{bcd}புரிமைச\u{bcd} சின\u{bcd}னம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("క\u{c3e}ప\u{c40}ర\u{c48}ట\u{c4d} చ\u{c3f}హ\u{c4d}నం"),
            keywords: &["క\u{c3e}ప\u{c40}ర\u{c48}ట\u{c4d}", "చ\u{c3f}హ\u{c4d}నం"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("ҳуқуқи муааллиф"),
            keywords: &["ҳуқуқи муааллиф"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ล\u{e34}ขส\u{e34}ทธ\u{e34}\u{e4c}"),
            keywords: &["c", "ล\u{e34}ขส\u{e34}ทธ\u{e34}\u{e4c}"],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("መሰል ደራሲ"),
            keywords: &["c", "መሰል ደራሲ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("awtorlyk hukugy"),
            keywords: &["awtorlyk hukugy", "c"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("fakaʻilonga mafai-pulusi"),
            keywords: &["fakaʻilonga", "mafai-pulusi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("telif hakkı işareti"),
            keywords: &["c", "telif hakkı", "telif hakkı işareti"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("نەشر ھوقۇقى"),
            keywords: &["نەشر ھوقۇقى"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("авторське право"),
            keywords: &["авторське право", "копірайт", "с"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("کاپی رائٹ"),
            keywords: &["c", "کاپی رائٹ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("mualliflik huquqi"),
            keywords: &["c", "mualliflik huquqi"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("bản quyền"),
            keywords: &["bản quyền"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("àqu moomeel"),
            keywords: &["àqu moomeel"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ilungelo lokukopa"),
            keywords: &["ilungelo lokukopa"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("òfin ìdábòbò iṣẹ\u{301}"),
            keywords: &["òfin ìdábòbò iṣẹ\u{301}"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("版權"),
            keywords: &["版權"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("版权"),
            keywords: &["版权"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("版权"),
            keywords: &["版权"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("版權"),
            keywords: &["版權"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ilungelo lokukopisha"),
            keywords: &["ilungelo lokukopisha"],
        },
    ],
};
#[doc = "®\u{fe0f}"]
pub const REGISTERED: crate::Emoji = crate::Emoji {
    glyph: "®\u{fe0f}",
    codepoint: "00AE FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "registered",
    group: "Symbols",
    subgroup: "other-symbol",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "®",
        codepoint: "00AE",
        status: crate::Status::Unqualified,
        introduction_version: 0.6f32,
        name: "registered",
        group: "Symbols",
        subgroup: "other-symbol",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("registrasiemerk"),
            keywords: &["geregistreer", "registrasie", "registrasiemerk"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የተመዘገበ ንግድ ምልክት"),
            keywords: &["ተመዝግቧል", "የተመዘገበ ንግድ ምልክት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("مسج\u{64e}\u{651}ل"),
            keywords: &["علامة التسجيل", "مسج\u{64e}\u{651}ل"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("পঞ\u{9cd}জীভ\u{9c1}ক\u{9cd}ত"),
            keywords: &["r", "পঞ\u{9cd}জীভ\u{9c1}ক\u{9cd}ত"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("qeydiyyata alınmış"),
            keywords: &["qeydiyyata alınmış", "qeydiyyatlı"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("зарэгістраваны таварны знак"),
            keywords: &["зарэгістраваны", "зарэгістраваны таварны знак"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Регистрирана търговска марка"),
            keywords: &[
                "Регистрирана търговска марка",
                "регистрирана търговска марка",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("নিবন\u{9cd}ধিত"),
            keywords: &["r", "নিবন\u{9cd}ধিত"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("merk marilhet"),
            keywords: &["merk marilhet", "r"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("registriran"),
            keywords: &["r", "registracija", "registriran"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("marca registrada"),
            keywords: &["marca", "registrada"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᎪᏪᎳᏅᎢ"),
            keywords: &["r", "ᎠᎪᏪᎳᏅᎢ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("znak registrované ochranné známky"),
            keywords: &[
                "ochranná známka",
                "r",
                "registrováno",
                "znak registrované ochranné známky",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("cofrestredig"),
            keywords: &["cofrestredig", "r"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("registreret varemærke"),
            keywords: &["registreret", "registreret varemærke"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Registered-Trademark"),
            keywords: &["Markenzeichen", "R", "Registered-Trademark"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("σήμα κατατεθέν"),
            keywords: &["r", "αναγνωρισμένο", "καταχωρισμένο", "σήμα κατατεθέν"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("registered"),
            keywords: &["r", "registered"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("marca registrada"),
            keywords: &["marca registrada", "r", "símbolo de marca registrada"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("signo de marca registrada"),
            keywords: &["marca", "registrada", "signo de marca registrada"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("símbolo de marca registrada"),
            keywords: &[
                "marca",
                "registrada",
                "signo de marca registrada",
                "símbolo de marca registrada",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("registreeritud"),
            keywords: &["r", "registreeritud"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("marka erregistratua"),
            keywords: &["erregistratu", "marka", "marka erregistratua"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("نشان تجاری ثبت\u{200c}شده"),
            keywords: &[
                "ثبت\u{200c}شده",
                "علامت تجاری ثبت\u{200c}شده",
                "نشان تجاری ثبت\u{200c}شده",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("rekisteröity-merkki"),
            keywords: &["R", "rekisteröity", "rekisteröity-merkki"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("rehistrado"),
            keywords: &["legal", "rehistrado"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("skrásett"),
            keywords: &["r", "skrásett", "skrásettur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("marque déposée"),
            keywords: &["marque commerciale", "marque déposée", "r", "®"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("cláraithe"),
            keywords: &["cláraithe", "r"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("clàraichte"),
            keywords: &["(r)", "clàraichte", "r", "®"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("marca rexistrada “R”"),
            keywords: &["R", "marca rexistrada “R”", "rexistrada"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("નો\u{a82}ધાય\u{ac7}લન\u{ac1}\u{a82} ચિહ\u{acd}ન"),
            keywords: &[
                "r",
                "નો\u{a82}ધાય\u{ac7}લ",
                "નો\u{a82}ધાય\u{ac7}લન\u{ac1}\u{a82} ચિહ\u{acd}ન",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("an yi rajista"),
            keywords: &["an yi rajista"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("סימן רשום"),
            keywords: &["סימן רשום"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("प\u{902}जीक\u{943}त चिह\u{94d}न"),
            keywords: &["प\u{902}जीक\u{943}त", "प\u{902}जीक\u{943}त चिह\u{94d}न"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("znak za registrirano"),
            keywords: &["registrirano", "znak za registrirano"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("registered (bejegyzett)"),
            keywords: &["bejegyzett", "registered (bejegyzett)", "védjegy"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("գրանցված"),
            keywords: &["գրանցված"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("terdaftar"),
            keywords: &["terdaftar"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("edebanyere"),
            keywords: &["edebanyere"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("skráð"),
            keywords: &["skráð", "skráð vörumerki"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("marchio registrato"),
            keywords: &["marchio registrato", "marchio registrato cerchiato"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("登録商標マーク"),
            keywords: &["Rマーク", "登録商標", "登録商標マーク", "記号"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("kadhaptar"),
            keywords: &["kadhaptar", "r"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("რეგისტრირებული სასაქონლო ნიშანი"),
            keywords: &["R", "რეგისტრირებული სასაქონლო ნიშანი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("тіркелген сауда белгісі"),
            keywords: &["белгі", "сауда", "тіркелген", "тіркелген сауда белгісі"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("registreret varemærke"),
            keywords: &["registreret", "registreret varemærke"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some(
                "សញ\u{17d2}ញាអក\u{17d2}សរ R ក\u{17d2}ន\u{17bb}ងរង\u{17d2}វង\u{17cb}សម\u{17d2}គាល\u{17cb}ថាបានច\u{17bb}ះឈ\u{17d2}មោះ",
            ),
            keywords: &[
                "R",
                "ច\u{17bb}ះឈ\u{17d2}មោះ",
                "រង\u{17d2}វង\u{17cb}",
                "សញ\u{17d2}ញា",
                "សញ\u{17d2}ញាអក\u{17d2}សរ R ក\u{17d2}ន\u{17bb}ងរង\u{17d2}វង\u{17cb}សម\u{17d2}គាល\u{17cb}ថាបានច\u{17bb}ះឈ\u{17d2}មោះ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ನೋಂದಾಯ\u{cbf}ತ"),
            keywords: &["ನೋಂದಾಯ\u{cbf}ತ", "ನೋಂದಾಯ\u{cbf}ತ ಚ\u{cbf}ಹ\u{ccd}ನ\u{cc6}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("등록상표"),
            keywords: &["동그라미 R", "등록상표", "알"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("नो\u{902}दणीक\u{943}त"),
            keywords: &["r", "नो\u{902}दणीक\u{943}त"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("катталган"),
            keywords: &["катталган"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("agedroen"),
            keywords: &["agedroen"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເຄ\u{eb7}\u{ec8}ອງໝາຍຈ\u{ebb}ດທະບຽນ"),
            keywords: &["ຈ\u{ebb}ດທະບຽນ", "ເຄ\u{eb7}\u{ec8}ອງໝາຍຈ\u{ebb}ດທະບຽນ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("užregistruota"),
            keywords: &["užregistruota"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("reģistrēta preču zīme"),
            keywords: &[
                "(R)",
                "preču zīme",
                "r",
                "reģistrēta preču zīme",
                "reģistrēts",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("rēhitatia"),
            keywords: &["rēhitatia"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("регистриран"),
            keywords: &["регистриран"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("രജിസ\u{d4d}ട\u{d4d}രേഷൻ ചിഹ\u{d4d}നം"),
            keywords: &[
                "ചിഹ\u{d4d}നം",
                "രജിസ\u{d4d}ട\u{d4d}രേഡ\u{d4d}",
                "രജിസ\u{d4d}ട\u{d4d}രേഷൻ ചിഹ\u{d4d}നം",
                "രജിസ\u{d4d}\u{200c}റ\u{d4d}റർചെയ\u{d4d}\u{200c}തത\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("бүртгэлтэй"),
            keywords: &["r", "бүртгэлтэй"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("नो\u{902}दणीक\u{943}त चिन\u{94d}ह"),
            keywords: &["नो\u{902}दणीक\u{943}त", "नो\u{902}दणीक\u{943}त चिन\u{94d}ह"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("berdaftar"),
            keywords: &["berdaftar", "r"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("reġistrati"),
            keywords: &["reġistrati"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("မ\u{103e}တ\u{103a}ပ\u{102f}\u{1036}တင\u{103a}ထားသော"),
            keywords: &["မ\u{103e}တ\u{103a}ပ\u{102f}\u{1036}တင\u{103a}ထားသော"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("registrert varemerke"),
            keywords: &["r", "registrert varemerke", "varemerkesymbol"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("दर\u{94d}ता गरिएको"),
            keywords: &["दर\u{94d}ता गरिएको"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("gedeponeerd"),
            keywords: &["gedeponeerd", "r"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("registrert varemerke"),
            keywords: &["r", "registrert varemerke", "varemerkesymbol"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ପଞ\u{b4d}ଜ\u{b3f}କ\u{b43}ତ"),
            keywords: &["r", "ପଞ\u{b4d}ଜ\u{b3f}କ\u{b43}ତ"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਰਜਿਸਟਰਡ ਚਿ\u{a70}ਨ\u{a4d}ਹ"),
            keywords: &[
                "ਰਜਿਸਟਰਡ",
                "ਰਜਿਸਟਰਡ ਚਿ\u{a70}ਨ\u{a4d}ਹ",
                "ਰਜਿਸਟਰਡ ਪ\u{a4d}ਰਤੀਕ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("اندراج ش\u{64f}دہ"),
            keywords: &["اندراج ش\u{64f}دہ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Rẹ\u{301}jísta"),
            keywords: &["Rẹ\u{301}jísta", "r"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("zarejestrowany znak towarowy"),
            keywords: &[
                "R",
                "towarowy",
                "zarejestrowany",
                "zarejestrowany znak towarowy",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("راجستر شوی"),
            keywords: &["آر", "راجستر شوی"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("símbolo de registrado"),
            keywords: &[
                "marca registrada",
                "marca registrada “R”",
                "símbolo de registrado",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("marca registada"),
            keywords: &["marca registada", "r"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("yaykusqa"),
            keywords: &["yaykusqa"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("marcă înregistrată"),
            keywords: &["marcă înregistrată", "r", "înregistrat"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-001"),
            keywords: &["E10-001"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("зарегистрированный товарный знак"),
            keywords: &[
                "зарегистрированный товарный знак",
                "зарегистрировано",
                "товарный знак",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ibaruwe"),
            keywords: &["ibaruwe"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("رجسٽر ٿيل"),
            keywords: &["r", "رجسٽر ٿيل"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ල\u{dd2}ය\u{dcf}පද\u{dd2}ංච\u{dd2}"),
            keywords: &["ල\u{dd2}ය\u{dcf}පද\u{dd2}ංච\u{dd2}"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("registrovaná známka"),
            keywords: &["registrovaná známka", "registrované"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("registrirano"),
            keywords: &["r", "registrirano"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("diiwaan gashan"),
            keywords: &["diiwaan gashan", "r"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("i regjistruar"),
            keywords: &["i regjistruar"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("регистровано"),
            keywords: &["рeгистровано", "регистровано"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("registrovano"),
            keywords: &["registrovano"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("registrerat varumärke"),
            keywords: &["registrerat", "registrerat varumärke"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("iliyosajiliwa"),
            keywords: &["iliyosajiliwa", "r"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பதிவுசெய\u{bcd}யப\u{bcd}பட\u{bcd}டது"),
            keywords: &[
                "பதிவு சின\u{bcd}னம\u{bcd}",
                "பதிவுசெய\u{bcd}த சின\u{bcd}னம\u{bcd}",
                "பதிவுசெய\u{bcd}யப\u{bcd}பட\u{bcd}டது",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some(
                "ర\u{c3f}జ\u{c3f}స\u{c4d}టర\u{c4d}డ\u{c4d} ట\u{c4d}ర\u{c47}డ\u{c4d} మ\u{c3e}ర\u{c4d}క\u{c4d}",
            ),
            keywords: &[
                "మ\u{c3e}ర\u{c4d}క\u{c4d}",
                "ర\u{c3f}జ\u{c3f}స\u{c4d}టర\u{c4d}డ\u{c4d}",
                "ర\u{c3f}జ\u{c3f}స\u{c4d}టర\u{c4d}డ\u{c4d} ట\u{c4d}ర\u{c47}డ\u{c4d} మ\u{c3e}ర\u{c4d}క\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("ба қайд гирифташуда"),
            keywords: &["ба қайд гирифташуда"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("จดทะเบ\u{e35}ยน"),
            keywords: &["r", "จดทะเบ\u{e35}ยน"],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ምዝጉብ"),
            keywords: &["r", "ምዝጉብ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("bellige alnan"),
            keywords: &["bellige alnan", "r"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("fakaʻilonga lēsisita"),
            keywords: &["fakaʻilonga", "lēsisita"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("tescil işareti"),
            keywords: &["r", "tescil işareti", "tescilli", "tescilli işareti"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("تىزىملاتقان"),
            keywords: &["تىزىملاتقان"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("зареєстрована торговельна марка"),
            keywords: &["зареєстрована торговельна марка", "зареєстровано"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("رجسٹرڈ"),
            keywords: &["r", "رجسٹرڈ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("qayd qilingan"),
            keywords: &["qayd qilingan", "r"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("đã đăng ký"),
            keywords: &["đã đăng ký"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("bindu na"),
            keywords: &["bindu na"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ibhalisiwe"),
            keywords: &["ibhalisiwe"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("ìforúkọsílẹ"),
            keywords: &["ìforúkọsílẹ"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("註冊"),
            keywords: &["註冊"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("注册"),
            keywords: &["注册"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("注册"),
            keywords: &["注册", "注册标记"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("註冊"),
            keywords: &["註冊"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("okubhalisiwe"),
            keywords: &["okubhalisiwe"],
        },
    ],
};
#[doc = "™\u{fe0f}"]
pub const TRADE_MARK: crate::Emoji = crate::Emoji {
    glyph: "™\u{fe0f}",
    codepoint: "2122 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "trade mark",
    group: "Symbols",
    subgroup: "other-symbol",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "™",
        codepoint: "2122",
        status: crate::Status::Unqualified,
        introduction_version: 0.6f32,
        name: "trade mark",
        group: "Symbols",
        subgroup: "other-symbol",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("handelmerk"),
            keywords: &["handelmerk", "handelsmerk", "merk", "tm"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የንግድ ምልክት"),
            keywords: &["ምልክት", "ንግድ ምልክት", "የንግድ ምልክት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("إشارة علامة تجارية"),
            keywords: &["إشارة", "إشارة علامة تجارية", "علامة تجارية"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("পণ\u{9cd}যচিহ\u{9cd}ন"),
            keywords: &[
                "চিহ\u{9cd}ন",
                "ট\u{9cd}ৰেডম\u{9be}ৰ\u{9cd}ক",
                "পণ\u{9cd}যচিহ\u{9cd}ন",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("ticarət nişanı"),
            keywords: &["işarə", "ticarət nişanı", "tn"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("таварны знак"),
            keywords: &["ТМ", "знак", "таварны"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Търговска марка"),
            keywords: &["Търговска марка", "търговска марка"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ট\u{9cd}রেড ম\u{9be}র\u{9cd}ক"),
            keywords: &[
                "TM",
                "চিহ\u{9cd}ন",
                "ট\u{9cd}রেড ম\u{9be}র\u{9cd}ক",
                "ট\u{9cd}রেডম\u{9be}র\u{9cd}ক",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("merk kenwerzhel marilhet"),
            keywords: &["merk kenwerzhel marilhet", "tm"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("zaštitni znak"),
            keywords: &["oznaka", "tm", "zaštitni znak"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("marca comercial"),
            keywords: &["comercial", "marca comercial", "símbol de marca comercial"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᎵᏱᏛᎢ ᎪᏪᎸ"),
            keywords: &["tm", "ᎠᎵᏱᏛᎢ ᎪᏪᎸ", "ᎠᎵᏱᏛᎢᎪᏪᎸ", "ᎪᏪᎸ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("znak ochranné známky"),
            keywords: &["tm", "trademark", "znak ochranné známky", "značka"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("nod masnach"),
            keywords: &["marc", "nod masnach"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("varemærke"),
            keywords: &["TM", "varemærke"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Markenzeichen"),
            keywords: &["Markenzeichen", "TM", "Trademark"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("εμπορικό σήμα"),
            keywords: &["tm", "εμπορικό σήμα", "σήμα"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("trade mark"),
            keywords: &["mark", "tm", "trade mark", "trademark"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: Some("trademark"),
            keywords: &["mark", "tm", "trademark"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["mark", "tm", "trade mark", "trademark"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("símbolo de marca comercial"),
            keywords: &["marca comercial", "símbolo de marca comercial"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &[
                "marca",
                "registrada",
                "símbolo",
                "símbolo de marca comercial",
                "símbolo de marca registrada",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("marca registrada"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &[
                "marca",
                "registrada",
                "símbolo",
                "símbolo de marca comercial",
            ],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kaubamärk"),
            keywords: &["kaubamärk", "märk"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("marka komertziala"),
            keywords: &["komertzial", "marka", "marka komertziala", "tm"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("نماد بازرگانی"),
            keywords: &[
                "TM",
                "tm",
                "تی\u{200c}ام",
                "علامت",
                "علامت تجاری",
                "نشان تجاری",
                "نماد بازرگانی",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("tavaramerkki"),
            keywords: &["TM", "merkki", "tavaramerkki"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("trade mark"),
            keywords: &["mark", "marka", "tm", "trade", "trademark"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("virkisrættindi"),
            keywords: &[
                "fyritøkumerki",
                "fyritøkurættindi",
                "virkismerki",
                "virkisrættindi",
                "vøruheiti",
                "vørumerki",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("marque commerciale déposée"),
            keywords: &["marque commerciale déposée", "marque déposée"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("marque de commerce"),
            keywords: &["marque de commerce", "marque déposée", "md"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("comhartha trádmhairc"),
            keywords: &["comhartha", "comhartha trádmhairc", "trádmharc"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("comharra-malairt"),
            keywords: &["comharra", "comharra-malairt", "tm"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("marca rexistrada “TM”"),
            keywords: &["TM", "marca rexistrada “TM”", "rexistrada"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ટ\u{acd}ર\u{ac7}ડ માર\u{acd}કન\u{ac1}\u{a82} ચિહ\u{acd}ન"),
            keywords: &[
                "ચિહ\u{acd}ન",
                "ટ\u{acd}ર\u{ac7}ડ માર\u{acd}ક",
                "ટ\u{acd}ર\u{ac7}ડ માર\u{acd}કન\u{ac1}\u{a82} ચિહ\u{acd}ન",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("tambarin kamfani"),
            keywords: &["maki", "tambarin kamfani", "tm"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("סימן מסחרי"),
            keywords: &["tm", "זכויות", "סימן", "סימן מסחרי"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ट\u{94d}र\u{947}ड मार\u{94d}क चिह\u{94d}न"),
            keywords: &[
                "चिह\u{94d}न",
                "ट\u{94d}र\u{947}ड मार\u{94d}क चिह\u{94d}न",
                "व\u{94d}यापार चिह\u{94d}न",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("zaštitni znak tm"),
            keywords: &["tm", "zaštitni znak", "zaštitni znak tm", "znak"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("védjegy"),
            keywords: &["tm", "védjegy"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ապրանքանիշ"),
            keywords: &["ապրանքանիշ", "նշան"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("merek dagang"),
            keywords: &["merek dagang", "tanda", "tanda merek", "tm"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("akara-ụlọọrụ"),
            keywords: &["akara", "akara-ụlọọrụ", "tm"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("skrásett vörumerki"),
            keywords: &["skrásett vörumerki", "vörumerki"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("marchio"),
            keywords: &[
                "TM",
                "marchio",
                "marchio commerciale",
                "marchio di fabbrica",
                "marchio registrato",
                "trademark",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("商標マーク"),
            keywords: &["TMマーク", "トレードマーク", "商標", "商標マーク", "記号"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("merek dagang"),
            keywords: &["merek dagang", "tandha", "tm"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("სავაჭრო ნიშანი"),
            keywords: &["ნიშანი", "სავაჭრო ნიშანი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("сауда белгісі"),
            keywords: &["tm", "белгі", "сауда белгісі"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("varemærke"),
            keywords: &["varemærke"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some(
                "សញ\u{17d2}ញាអក\u{17d2}សរ TM សម\u{17d2}គាល\u{17cb}ថាជាម\u{17c9}ាកទ\u{17c6}ន\u{17b7}ញ",
            ),
            keywords: &[
                "TM",
                "ម\u{17c9}ាក",
                "សញ\u{17d2}ញា",
                "សញ\u{17d2}ញាអក\u{17d2}សរ TM សម\u{17d2}គាល\u{17cb}ថាជាម\u{17c9}ាកទ\u{17c6}ន\u{17b7}ញ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಟ\u{ccd}ರೇಡ\u{ccd} ಮಾರ\u{ccd}ಕ\u{ccd}"),
            keywords: &[
                "ಚ\u{cbf}ಹ\u{ccd}ನ\u{cc6}",
                "ಟ\u{ccd}ರೇಡ\u{ccd} ಮಾರ\u{ccd}ಕ\u{ccd}",
                "ಟ\u{ccd}ರೇಡ\u{ccd} ಮಾರ\u{ccd}ಕ\u{ccd} ಚ\u{cbf}ಹ\u{ccd}ನ\u{cc6}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("상표"),
            keywords: &["상표", "상표 표시", "트레이드 마크 표시"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("व\u{947}पार चिन\u{94d}न"),
            keywords: &[
                "tm",
                "चिन\u{94d}न",
                "व\u{947}पार चिन\u{94d}न",
                "व\u{947}पारचिन\u{94d}न",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("соода маркасы"),
            keywords: &["соода белгиси", "соода маркасы"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Markenzeechen"),
            keywords: &["Markenzeechen", "TM", "Trademark", "Zeechen"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເຄ\u{eb7}\u{ec8}ອງໝາຍການຄ\u{ec9}າ"),
            keywords: &[
                "ການຄ\u{ec9}າ",
                "ເຄ\u{eb7}\u{ec8}ອງໝາຍ",
                "ເຄ\u{eb7}\u{ec8}ອງໝາຍການຄ\u{ec9}າ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("prekės ženklas"),
            keywords: &["prekės ženklas", "žymė"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("preču zīme"),
            keywords: &["TM", "preču zīme"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tohu hoko"),
            keywords: &["tohu", "tohu hoko", "tohuhoko"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("заштитен знак"),
            keywords: &["заштитен знак", "марка"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ട\u{d4d}രേഡ\u{d4d}\u{200c}മ\u{d3e}ർക\u{d4d}ക\u{d4d}"),
            keywords: &[
                "ട\u{d4d}രേഡ\u{d4d}\u{200c}മ\u{d3e}ർക\u{d4d}ക\u{d4d}",
                "വ\u{d4d}യ\u{d3e}പ\u{d3e}രമ\u{d41}ദ\u{d4d}ര",
                "സൈൻ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("барааны тэмдэг"),
            keywords: &["бараа", "барааны тэмдэг", "тэмдэг"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("ट\u{94d}र\u{947}डमार\u{94d}क"),
            keywords: &[
                "चिन\u{94d}ह",
                "टीएम",
                "ट\u{94d}र\u{947}ड मार\u{94d}क",
                "ट\u{94d}र\u{947}डमार\u{94d}क",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("tanda dagangan"),
            keywords: &["tanda", "tanda dagangan", "tm"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("trade mark"),
            keywords: &["marka", "tm", "trade mark", "trademark"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("က\u{102f}န\u{103a} အမ\u{103e}တ\u{103a}တ\u{1036}ဆ\u{102d}ပ\u{103a}"),
            keywords: &[
                "က\u{102f}န\u{103a} အမ\u{103e}တ\u{103a}တ\u{1036}ဆ\u{102d}ပ\u{103a}",
                "က\u{102f}န\u{103a}အမ\u{103e}တ\u{103a}တ\u{1036}ဆ\u{102d}ပ\u{103a}",
                "က\u{102f}န\u{103a}အမ\u{103e}တ\u{103a}တ\u{1036}ဆ\u{102d}ပ\u{103a} သင\u{103a}\u{1039}ကေတ",
                "အမ\u{103e}တ\u{103a}တ\u{1036}ဆ\u{102d}ပ\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("varemerke"),
            keywords: &["tm", "trademark", "varemerke"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("व\u{94d}यापार चिन\u{94d}ह"),
            keywords: &["चिन\u{94d}ह", "टिएम", "व\u{94d}यापार चिन\u{94d}ह"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("handelsmerksymbool"),
            keywords: &["handelsmerk", "handelsmerksymbool", "symbool", "tm"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("varemerke"),
            keywords: &["tm", "trademark", "varemerke"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଟ\u{b4d}ରେଡ\u{b4d}\u{200c} ଚ\u{b3f}ହ\u{b4d}ନ"),
            keywords: &[
                "tm",
                "ଚ\u{b3f}ହ\u{b4d}ନ",
                "ଟ\u{b4d}ରେଡମ\u{b3e}ର\u{b4d}କ\u{b4d}\u{200c}",
                "ଟ\u{b4d}ରେଡ\u{b4d}\u{200c} ଚ\u{b3f}ହ\u{b4d}ନ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਟ\u{a4d}ਰ\u{a47}ਡਮਾਰਕ"),
            keywords: &[
                "ਚਿ\u{a70}ਨ\u{a4d}ਹ",
                "ਟ\u{a4d}ਰ\u{a47}ਡਮਾਰਕ",
                "ਨਿਸ\u{a3c}ਾਨ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("تجارت دا نشان"),
            keywords: &[
                "تجارت دا نشان",
                "نشان تجارت",
                "نشان لانا",
                "نشان\u{650} تجارت",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Tréd Mak"),
            keywords: &["Mak", "TM", "Tréd Mak", "Trédmak"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("znak towarowy"),
            keywords: &["TM", "znak towarowy"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("تجارتي نښان"),
            keywords: &["تجارتي نښان", "تجارتي نښه", "نښه", "ټي ايم"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("símbolo de marca registrada"),
            keywords: &[
                "marca registrada",
                "marca registrada “TM”",
                "símbolo",
                "símbolo de marca registrada",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("marca comercial"),
            keywords: &["marca", "marca comercial", "tm"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("waqaychasqa chinpuy"),
            keywords: &["waqaychasqa chinpuy"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("marcă comercială"),
            keywords: &["comercială", "marcă"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-004"),
            keywords: &["E10-004"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("товарный знак"),
            keywords: &[
                "ТМ",
                "товарная марка",
                "товарный знак",
                "торговая марка",
                "торговый знак",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ikirango"),
            keywords: &["akarango", "ikirango", "tm"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ٽريڊ مارڪ"),
            keywords: &["نشان", "ٽريڊ مارڪ", "ٽريڊمارڪ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("වෙළඳ ලක\u{dd4}ණ"),
            keywords: &["ලක\u{dd4}ණ", "වෙළඳ ලක\u{dd4}ණ", "වෙළඳ සලක\u{dd4}ණ"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("obchodná známka"),
            keywords: &["obchodná značka", "obchodná známka", "tm", "znak"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("blagovna znamka"),
            keywords: &["TM", "blagovna znamka", "znak"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("sumadda ganacsiga"),
            keywords: &["sumadda", "sumadda ganacsiga", "sumaddaganacsiga", "tm"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("markë tregtare"),
            keywords: &["markë tregtare", "shenjë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("жиг"),
            keywords: &["жиг", "зaштитни знaк", "знaк"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("žig"),
            keywords: &["zaštitni znak", "znak", "žig"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("skyddat varumärke"),
            keywords: &["skyddat varumärke", "varumärke"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("chapa ya biashara"),
            keywords: &["alama", "alama ya biashara", "chapa ya biashara"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("வர\u{bcd}த\u{bcd}தக முத\u{bcd}திரை"),
            keywords: &[
                "வர\u{bcd}த\u{bcd}தக முத\u{bcd}திரை",
                "வர\u{bcd}த\u{bcd}தக முத\u{bcd}திரைச\u{bcd} சின\u{bcd}னம\u{bcd}",
                "வர\u{bcd}த\u{bcd}தகச\u{bcd} சின\u{bcd}னம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ట\u{c4d}ర\u{c47}డ\u{c4d} మ\u{c3e}ర\u{c4d}క\u{c4d} చ\u{c3f}హ\u{c4d}నం"),
            keywords: &[
                "ట\u{c4d}ర\u{c47}డ\u{c4d}",
                "ట\u{c4d}ర\u{c47}డ\u{c4d} మ\u{c3e}ర\u{c4d}క\u{c4d} చ\u{c3f}హ\u{c4d}నం",
                "మ\u{c3e}ర\u{c4d}క\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("тамғаи савдо"),
            keywords: &["аломат", "тамғаи савдо"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เคร\u{e37}\u{e48}องหมายการค\u{e49}า"),
            keywords: &[
                "ป\u{e49}ายเคร\u{e37}\u{e48}องหมายการค\u{e49}า",
                "เคร\u{e37}\u{e48}องหมายการค\u{e49}า",
            ],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ምልክት ንግዲ"),
            keywords: &["tm", "ምልክት", "ምልክት ንግዲ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("söwda belgisi"),
            keywords: &["belgi", "söwda belgisi", "tm"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("fakaʻilonga fefakatauʻaki"),
            keywords: &["fakaʻilonga", "fefakatauʻaki"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("ticari marka işareti"),
            keywords: &["işaret", "ticari marka", "ticari marka işareti"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("سودا ماركىسى"),
            keywords: &["س م", "سودا ماركىسى", "ماركا"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("торговельна марка"),
            keywords: &["tm", "марка", "торговельна марка"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("تجارتی نشان"),
            keywords: &["تجارت", "تجارتی نشان", "نشان"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("savdo belgisi"),
            keywords: &["belgi", "savdo belgisi", "tm"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("nhãn hiệu"),
            keywords: &["dấu", "nhãn hiệu", "tm"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("turu liggéey"),
            keywords: &["màndarga", "tm", "turu liggéey", "turu-liggéey"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("uphawu lorhwebo"),
            keywords: &["i-tm", "uphawu", "uphawu lorhwebo"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("àmì ìdánimọ\u{300} iléeṣẹ\u{301}"),
            keywords: &[
                "tm",
                "àmì",
                "àmì ìdámọ\u{300} fún iléeṣẹ\u{301}",
                "àmì ìdánimọ\u{300} iléeṣẹ\u{301}",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("商標"),
            keywords: &["tm", "商標", "標記"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("商标"),
            keywords: &["tm", "商标", "标记"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("商标"),
            keywords: &["产品", "商标", "标志"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("商標"),
            keywords: &["商標"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("uphawu lokuhweba"),
            keywords: &["uphawu", "uphawu lokuhweba"],
        },
    ],
};
