#[doc = "✖\u{fe0f}"]
pub const MULTIPLY: crate::Emoji = crate::Emoji {
    glyph: "✖\u{fe0f}",
    codepoint: "2716 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "multiply",
    group: "Symbols",
    subgroup: "math",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "✖",
        codepoint: "2716",
        status: crate::Status::Unqualified,
        introduction_version: 0.6f32,
        name: "multiply",
        group: "Symbols",
        subgroup: "math",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("maal"),
            keywords: &[
                "kanselleer",
                "maal",
                "maalteken",
                "verkeerd",
                "vermenigvuldig",
                "x",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የማባዛት"),
            keywords: &["x", "×", "ማባዛት", "ምልክት", "ተወው", "አባዛ", "የማባዛት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("ضرب"),
            keywords: &["x", "×", "إلغاء", "ضرب", "علامة ضرب", "مضاعفة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("প\u{9c2}ৰণ"),
            keywords: &[
                "x",
                "×",
                "চিন",
                "প\u{9c2}ৰণ",
                "প\u{9c2}ৰণ কৰ\u{9be}",
                "ব\u{9be}তিল",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("qalın vurma x"),
            keywords: &["işarə", "ləğv et", "qalın vurma x", "vur", "vurma", "×"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("знак множання"),
            keywords: &["знак множання", "множанне", "скасаванне", "х"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Удебелен знак за умножение"),
            keywords: &["Удебелен знак за умножение", "отказ", "умножение"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("গ\u{9c1}ণ"),
            keywords: &[
                "×",
                "গ\u{9c1}ণ",
                "গ\u{9c1}ণ চিহ\u{9cd}ন",
                "গ\u{9c1}ন কর\u{9be}",
                "ব\u{9be}তিল",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("liesaat"),
            keywords: &["arouezenn", "beskroaz", "liesaat", "matematikoù", "×"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("znak množenja"),
            keywords: &["križić", "množenje", "otkaži", "x", "znak množenja"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("signe de multiplicar"),
            keywords: &[
                "cancel·lar",
                "multiplicació",
                "multiplicar",
                "signe",
                "signe de multiplicar",
                "x",
                "×",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᏓᎨᏓ ᏗᏎᏢᎢ ᎤᏙᏪᎸ"),
            keywords: &[
                "x",
                "×",
                "ᎠᏎᏒᏗ",
                "ᎤᏓᎨᏓ ᏗᏎᏢᎢ",
                "ᎤᏓᎨᏓ ᏗᏎᏢᎢ ᎤᏙᏪᎸ",
                "ᎤᏙᏪᎸ",
                "ᎧᏁᏉᎢᏍᏗ",
                "ᏗᏎᏢᎢ",
            ],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("znak násobení"),
            keywords: &["krát", "násobení", "součin", "x", "znak", "zrušení", "×"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("lluosi"),
            keywords: &["arwydd", "canslo", "lluosi", "lluosiad", "x", "×"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("gange"),
            keywords: &[
                "annuller",
                "gange",
                "multiplikation",
                "multiplikationstegn",
                "tegn",
                "x",
                "×",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("mal"),
            keywords: &[
                "Multiplikation",
                "Multiplikationszeichen",
                "abbrechen",
                "mal",
                "multiplizieren",
                "x",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("πολλαπλασιασμός"),
            keywords: &[
                "x",
                "×",
                "άκυρο",
                "ακύρωση",
                "πολλαπλασιάζω",
                "πολλαπλασιασμός",
                "σύμβολο",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("multiply"),
            keywords: &["cancel", "multiplication", "multiply", "sign", "x", "×"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: None,
            keywords: &["cancel", "multiplication", "multiply", "sign", "x", "×"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &[
                "cancel",
                "heavy multiplication x",
                "multiplication",
                "multiply",
                "sign",
                "x",
                "×",
            ],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["cancel", "multiplication", "multiply", "sign", "x", "×"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("multiplicación"),
            keywords: &[
                "cancelar",
                "marca",
                "multiplicación",
                "prohibido",
                "signo de multiplicación",
                "x",
                "×",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("multiplicación"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("signo de multiplicación"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("korrutamine"),
            keywords: &["korrutamine", "korrutusmärk", "suur korrutusmärk", "x"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("biderkatu"),
            keywords: &["biderkatu", "biderketa", "ikur", "utzi", "x", "×"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("ضرب کردن"),
            keywords: &["x", "×", "ضرب کردن", "علامت", "علامت ضرب", "لغو"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kertomerkki"),
            keywords: &["kertolasku", "kertomerkki", "merkki", "peruuta", "x", "×"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("malaking multiplication x"),
            keywords: &[
                "kansela",
                "malaking multiplication x",
                "multiplication",
                "multiply",
                "sign",
                "x",
                "×",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("falda"),
            keywords: &["annullera", "falda", "ganga", "x", "×"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("signe multiplier"),
            keywords: &[
                "*",
                "annuler",
                "multiplier",
                "non",
                "signe multiplier",
                "x",
                "×",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("signe de multiplication"),
            keywords: &[
                "*",
                "annuler",
                "multiplier",
                "non",
                "signe de multiplication",
                "x",
                "×",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("comhartha iolrúcháin"),
            keywords: &[
                "cealaigh",
                "comhartha iolrúcháin",
                "iolrú",
                "iolrúchán",
                "iolrúchán x trom",
                "x",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("iomadaich"),
            keywords: &[
                "iomadachadh",
                "iomadaich",
                "samhla",
                "samhla iomadachaidh",
                "sguir dheth",
                "sgur dheth",
                "x",
                "x iomadachaidh throm",
                "×",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("multiplicación"),
            keywords: &["X", "cancelar", "matemáticas", "multiplicación", "signo"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ગ\u{ac1}ણાકાર"),
            keywords: &[
                "x",
                "×",
                "ગ\u{ac1}ણાકાર",
                "ગ\u{ac1}ણાકાર કરો",
                "નિશાની",
                "રદ કરો",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("x sau mai nauyi"),
            keywords: &["riɓa", "sau", "soke", "x", "x sau mai nauyi"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("סימן כפל"),
            keywords: &["איקס עבה", "ביטול", "כפול X", "סימן כפל", "פסילה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ग\u{941}णा"),
            keywords: &["x", "ग\u{941}णा", "बड\u{93c}ा क\u{94d}रॉस चिह\u{94d}न"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("znak množenja"),
            keywords: &[
                "množenje",
                "operator",
                "otkaži",
                "pomnoži",
                "x",
                "znak množenja",
                "×",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("szorzás"),
            keywords: &["jel", "mégse", "szorzás", "x", "×"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("բազմապատկում"),
            keywords: &["բազմապատկման նշան", "բազմապատկում", "նշան", "չեղարկել"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("kali"),
            keywords: &["batal", "kali", "perkalian", "tanda", "x"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("nnukwu mgbakọ x"),
            keywords: &["gbakọọ", "kàgbuo", "mgbakọ", "nnukwu mgbakọ x", "x"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("margföldunartákn"),
            keywords: &[
                "hætta við",
                "margfalda",
                "margföldun",
                "margföldunartákn",
                "tákn",
                "x",
                "×",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("segno moltiplicazione"),
            keywords: &[
                "X",
                "cancellare",
                "moltiplicazione",
                "segno moltiplicazione",
                "segno per",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("掛け算"),
            keywords: &["キャンセル", "バツ", "ペケ", "乗算", "掛け算", "記号"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("tandha ping-pingan"),
            keywords: &["ditikelake", "ping-pingan", "tandha", "wurung", "x", "×"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("გამრავლება"),
            keywords: &["x", "×", "გამრავლება", "გაუქმება", "მსხვილი გამრავლება"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("көбейту"),
            keywords: &["x", "×", "бас тарту", "белгі", "көбейту", "көбейтінді"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("stort kryds"),
            keywords: &[
                "annuller",
                "gange",
                "gangetegn",
                "multiplicer",
                "multiplikation",
                "stort kryds",
                "x",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("សញ\u{17d2}ញាគ\u{17bb}ណ"),
            keywords: &[
                "x",
                "×",
                "ខ\u{17d2}វែង",
                "គ\u{17bb}ណ",
                "បោះបង\u{17cb}",
                "សញ\u{17d2}ញា",
                "សញ\u{17d2}ញាគ\u{17bb}ណ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಗುಣಾಕಾರ ಚ\u{cbf}ಹ\u{ccd}ನ\u{cc6}"),
            keywords: &[
                "x",
                "×",
                "ಗುಣಾಕಾರ",
                "ಗುಣ\u{cbf}ಸು",
                "ಚ\u{cbf}ಹ\u{ccd}ನ\u{cc6}",
                "ರದ\u{ccd}ದುಮಾಡು",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("곱하기"),
            keywords: &["곱셈", "곱셈기호", "곱하기", "엑스", "취소"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("ग\u{941}णाकार"),
            keywords: &[
                "x",
                "×",
                "ग\u{941}णाकार",
                "ग\u{941}ण\u{941}ल\u{947}",
                "चिन\u{94d}न",
                "रद\u{94d}द",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("көбөйтүү"),
            keywords: &["x", "×", "белги", "жокко чыгаруу", "көбөйтүү"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("fettgedrécktent Multiplikatiounszeechen"),
            keywords: &[
                "Multiplikatioun",
                "fettgedrécktent Multiplikatiounszeechen",
                "multiplizéieren",
                "ofbriechen",
                "x",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເຄ\u{eb7}\u{ec8}ອງໝາຍຄ\u{eb9}ນ"),
            keywords: &[
                "ຄ\u{eb9}ນ",
                "ເຄ\u{eb7}\u{ec8}ອງໝາຍ",
                "ເຄ\u{eb7}\u{ec8}ອງໝາຍຄ\u{eb9}ນ",
                "ເຄ\u{eb7}\u{ec8}ອງໝາຍຄ\u{eb9}ນໃຫຍ\u{ec8}ໜາ",
                "ໃຫຍ\u{ec8}ໜາ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("paryškintas daugybos ženklas"),
            keywords: &[
                "atšaukti",
                "dauginti",
                "daugyba",
                "paryškintas daugybos ženklas",
                "x",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("reizināt"),
            keywords: &[
                "atcelt",
                "krustiņš",
                "matemātika",
                "reizināt",
                "reizināšanas zīme",
                "x",
                "×",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("x whakarea taumaha"),
            keywords: &[
                "whakakore",
                "whakarea",
                "whakareatanga",
                "x",
                "x whakarea taumaha",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("множење"),
            keywords: &["x", "×", "знак", "множење", "множи", "откажи"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഗ\u{d41}ണിക\u{d4d}ക\u{d41}ക"),
            keywords: &[
                "x",
                "×",
                "ഗ\u{d41}ണനം",
                "ഗ\u{d41}ണിക\u{d4d}ക\u{d41}ക",
                "ചിഹ\u{d4d}നം",
                "റദ\u{d4d}ദ\u{d3e}ക\u{d4d}ക\u{d41}ക",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("үржүүлэх"),
            keywords: &["×", "тэмдэг", "х", "цуцлах", "үржвэр", "үржүүлэх"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("ग\u{941}णाकार करा"),
            keywords: &[
                "x । रद\u{94d}द करा । ग\u{941}णाकार । ग\u{941}णाकार करा । चिन\u{94d}ह ।",
                "ग\u{941}णाकार करा",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("darab"),
            keywords: &["batal", "darab", "pendaraban", "simbol", "x"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("multiplikazzjoni grassett x"),
            keywords: &[
                "ikkanċella",
                "immoltiplika",
                "multiplikazzjoni",
                "multiplikazzjoni grassett x",
                "x",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အမြ\u{103e}ောက\u{103a} သင\u{103a}\u{1039}ကေတ"),
            keywords: &[
                "ဖျက\u{103a}သ\u{102d}မ\u{103a}းခြင\u{103a}း",
                "အမြ\u{103e}ောက\u{103a}",
                "အမြ\u{103e}ောက\u{103a} သင\u{103a}\u{1039}ကေတ",
                "အမြ\u{103e}ောက\u{103a}လက\u{1039}ခဏာ",
                "အမြ\u{103e}ောက\u{103a}လက\u{1039}ခဏာ သင\u{103a}\u{1039}ကေတအကြ\u{102e}းစား",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("gange"),
            keywords: &[
                "avbryt",
                "gange",
                "gangetegn",
                "multiplikasjon",
                "multiplisere",
                "x",
                "×",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("ग\u{941}णन"),
            keywords: &[
                "x",
                "×",
                "ग\u{941}णन",
                "ग\u{941}णन गर\u{94d}न\u{947}",
                "चिन\u{94d}ह",
                "रद\u{94d}द",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("vermenigvuldigen"),
            keywords: &[
                "annuleren",
                "teken",
                "vermenigvuldigen",
                "vermenigvuldiging",
                "x",
                "×",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("gongeteikn"),
            keywords: &["avbryt", "gongeteikn", "multiplikasjon", "multiplisere"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଗ\u{b41}ଣନ କର\u{b3f}ବ\u{b3e}"),
            keywords: &[
                "x",
                "×",
                "ଗ\u{b41}ଣନ",
                "ଗ\u{b41}ଣନ କର\u{b3f}ବ\u{b3e}",
                "ବ\u{b3e}ତ\u{b3f}ଲ\u{b4d}\u{200c}",
                "ସଙ\u{b4d}କେତ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਗ\u{a41}ਣਾ"),
            keywords: &[
                "x",
                "×",
                "ਗ\u{a41}ਣਾ",
                "ਗ\u{a41}ਣਾ ਕਰਨਾ",
                "ਚਿ\u{a70}ਨ\u{a4d}ਹ",
                "ਨਿਸ\u{a3c}ਾਨ",
                "ਰ\u{a71}ਦ ਕਰਨਾ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("وڈی ضرب x"),
            keywords: &["x", "ضرب", "ضرب دینا", "منسوخ کرنا", "وڈی ضرب x"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Taims Sain"),
            keywords: &["Kánsul", "Sain", "Taims", "To Mọltiplai", "X", "x"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("znak mnożenia"),
            keywords: &[
                "anuluj",
                "iks",
                "mnożenie",
                "x",
                "znak",
                "znak mnożenia",
                "×",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د ضرب نښه"),
            keywords: &[
                "x",
                "×",
                "د ضرب نښه",
                "ضرب",
                "ضرب کول",
                "فسخ کول",
                "لوی د ضرب x",
                "نښه",
            ],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("sinal de multiplicação"),
            keywords: &[
                "X",
                "cancelar",
                "multiplicar",
                "multiplicação",
                "sinal de multiplicação",
                "x de multiplicação",
                "×",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("multiplicação"),
            keywords: &[
                "cancelar",
                "multiplicar",
                "multiplicação",
                "sinal de multiplicação",
                "×",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("mirachiy"),
            keywords: &["chinkachiy", "mirachiy", "multiplicacion", "unancha", "x"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("înmulțire"),
            keywords: &["anulare", "semn", "x", "înmulțire"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-132"),
            keywords: &["E10-132"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("знак умножения"),
            keywords: &[
                "знак умножения",
                "значок",
                "значок умножения",
                "умножение",
                "х",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("Ikimenyetso cya x kinini cyo gukuba"),
            keywords: &[
                "Ikimenyetso cya x kinini cyo gukuba",
                "gukaba",
                "ikimenyetso cyo gukuba",
                "ikuba",
                "kuburizamo",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ضرب"),
            keywords: &["×", "ضرب", "ضرب ڪريو", "منسوخ", "نشاني"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ග\u{dd4}ණ ක\u{dd2}ර\u{dd3}ම"),
            keywords: &[
                "×",
                "අවලංග\u{dd4}",
                "ග\u{dd4}ණ ක\u{dd2}ර\u{dd3}ම",
                "ග\u{dd4}ණ\u{dd2}තය",
                "ලක\u{dd4}ණ",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("krát"),
            keywords: &["krát", "násobenie", "násobiť", "x", "znak", "zrušiť", "×"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("množi"),
            keywords: &[
                "množenje",
                "množi",
                "množiti",
                "prekliči",
                "x",
                "znak",
                "znak za množenje",
                "×",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("calaamadda isku dhufashada"),
            keywords: &[
                "calaamad",
                "calaamadda isku dhufashada",
                "isku dhufasho",
                "isku dhufo",
                "kansal",
                "x",
                "×",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("shenja x e shumëzimit e trashë"),
            keywords: &[
                "anulo",
                "shenja x e shumëzimit e trashë",
                "shumëzim",
                "shumëzoj",
                "x",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("црни знак за множење"),
            keywords: &["x", "мнoжeњe", "отказивање", "путa", "црни знак за множење"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("crni znak za množenje"),
            keywords: &[
                "crni znak za množenje",
                "množenje",
                "otkazivanje",
                "puta",
                "x",
            ],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("multiplicera"),
            keywords: &[
                "avbryt",
                "multiplicera",
                "multiplikation",
                "tecken",
                "x",
                "×",
            ],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("zidisha"),
            keywords: &["alama", "alama ya kuzidisha", "ghairi", "zidisha", "×"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பெருக\u{bcd}கல\u{bcd} சின\u{bcd}னம\u{bcd}"),
            keywords: &[
                "குறிய\u{bc0}டு",
                "பெருக\u{bcd}கல\u{bcd}",
                "பெருக\u{bcd}கல\u{bcd} குறி",
                "பெருக\u{bcd}கல\u{bcd} சின\u{bcd}னம\u{bcd}",
                "ரத\u{bcd}து செய\u{bcd}தல\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("గుణక\u{c3e}రం చ\u{c47}యడం"),
            keywords: &[
                "x",
                "×",
                "గుణక\u{c3e}రం",
                "గుణక\u{c3e}రం చ\u{c47}యడం",
                "గుర\u{c4d}తు",
                "రద\u{c4d}దు చ\u{c47}య\u{c3f}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("зарбзании вазнин х"),
            keywords: &[
                "бекор кардан",
                "зарб задан",
                "зарбзании вазнин х",
                "зарбзанӣ",
                "х",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ค\u{e39}ณ"),
            keywords: &[
                "x",
                "×",
                "การค\u{e39}ณ",
                "ค\u{e39}ณ",
                "ยกเล\u{e34}ก",
                "เคร\u{e37}\u{e48}องหมาย",
                "เคร\u{e37}\u{e48}องหมายค\u{e39}ณ",
            ],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ሕሳብ"),
            keywords: &["x", "×", "ሕሳብ", "ምልክት", "ምርባሕ", "ምጥፋእ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("köpeltmek"),
            keywords: &["alamat", "bes et", "köpelt", "köpeltmek", "x", "×"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("fakaʻilonga liunga mamafa"),
            keywords: &["fakaʻilonga", "fakaʻilonga liunga mamafa", "liunga"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("çarpım işareti"),
            keywords: &[
                "iptal",
                "işaret",
                "x",
                "×",
                "çarpma",
                "çarpım",
                "çarpım işareti",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئېغىر كۆپەيتىش بەلگىسى"),
            keywords: &[
                "x",
                "ئېغىر كۆپەيتىش بەلگىسى",
                "بىكار قىلىش",
                "كۆپەيت",
                "كۆپەيتىش",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("множення"),
            keywords: &[
                "×",
                "знак",
                "кратність",
                "множення",
                "помножити",
                "скасувати",
                "х",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ضرب"),
            keywords: &["x", "×", "ضرب", "ضرب کرنا", "علامت", "منسوخ کرنا"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("koʻpaytiruv"),
            keywords: &[
                "bekor qilish",
                "belgi",
                "koʻpaytirish",
                "koʻpaytirish belgisi",
                "koʻpaytiruv",
                "x",
                "×",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("dấu nhân"),
            keywords: &["dấu", "hủy", "nhân", "x", "×"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("x fuul bu rëy"),
            keywords: &["bàyyi", "fuul", "x", "x fuul bu rëy"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("uphindaphindo olungqindilili x"),
            keywords: &[
                "phindaphinda",
                "rhoxisa",
                "uphindaphindo",
                "uphindaphindo olungqindilili x",
                "x",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("ìsọdipúpò\u{329} tó nípọn x"),
            keywords: &[
                "fagilé",
                "x",
                "ìsọdipúpò\u{329}",
                "ìsọdipúpò\u{329} tó nípọn x",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("粗乘號"),
            keywords: &["X", "x", "乘", "乘法", "交叉", "取消", "標誌", "粗乘號"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("粗乘号"),
            keywords: &["X", "乘", "乘法", "取消", "粗乘号"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("乘"),
            keywords: &["乘", "乘号", "取消", "相乘", "符号"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("乘"),
            keywords: &["x", "×", "乘", "乘法", "乘法號", "乘號", "取消", "符號"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("打交叉"),
            keywords: &["交叉", "打交叉"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("phindaphinda"),
            keywords: &[
                "phindaphinda",
                "ukukhansela",
                "ukuphindaphinda",
                "uphawu lokuphindaphinda oluwugqinsi",
            ],
        },
    ],
};
#[doc = "➕"]
pub const PLUS: crate::Emoji = crate::Emoji {
    glyph: "➕",
    codepoint: "2795",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "plus",
    group: "Symbols",
    subgroup: "math",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("plus"),
            keywords: &["plus", "teken", "wiskunde"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ወፍራም የመደመር ምልክት"),
            keywords: &["+", "ሒሳብ", "ምልክት", "ወፍራም የመደመር ምልክት", "የመደመር"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("\u{202b}علامة جمع"),
            keywords: &["+", "جمع", "رياضيات", "\u{202b}علامة جمع"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("যোগ"),
            keywords: &["+", "অংক", "চিন", "যোগ"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("qalın plus işarəsi"),
            keywords: &["plus", "qalın plus işarəsi", "riyaziyyat"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("знак складання"),
            keywords: &["+", "знак складання", "матэматыка", "плюс", "складанне"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Удебелен знак плюс"),
            keywords: &["Удебелен знак плюс", "математика", "плюс"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("যোগ"),
            keywords: &["+", "গণিত", "চিহ\u{9cd}ন", "যোগ"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("mui"),
            keywords: &["+", "arouezenn", "matematikoù", "mui"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("znak plus"),
            keywords: &["+", "matematika", "plus", "znak plus"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("signe de sumar"),
            keywords: &["+", "matemàtiques", "més", "signe", "signe de sumar"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᏓᎨᏓ ᎧᏁᏉᎩ ᎤᏙᏪᎸ"),
            keywords: &["+", "ᎤᏓᎨᏓ ᎧᏁᏉᎩ ᎤᏙᏪᎸ", "ᎤᏙᏪᎸ", "ᎧᏁᏉᎩ", "ᏗᏎᏍᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("znak plus"),
            keywords: &["+", "matematika", "plus", "součet", "sčítání", "znak plus"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("adio"),
            keywords: &["+", "adio", "arwydd", "mathemateg"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("plus"),
            keywords: &["+", "matematik", "plus", "plustegn", "tegn"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("plus"),
            keywords: &["Plus", "Pluszeichen", "plus"],
        },
        #[cfg(feature = "de_CH")]
        crate::Annotation {
            lang: "de_CH",
            tts: Some("Plus"),
            keywords: &["Plus"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("συν"),
            keywords: &["+", "μαθηματικά", "πρόσθεση", "συν", "σύμβολο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("plus"),
            keywords: &["+", "math", "plus", "sign"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: None,
            keywords: &["+", "math", "maths", "plus", "sign"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["+", "add", "addition", "math", "maths", "plus", "sign"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["+", "math", "plus", "sign"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["+", "math", "maths", "plus", "sign"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("más"),
            keywords: &["+", "más", "signo", "suma"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("suma"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("signo de suma"),
            keywords: &["+", "más", "signo", "signo de suma", "suma"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("liitmine"),
            keywords: &["+", "liitmine", "matemaatika", "pluss", "plussmärk"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("plus"),
            keywords: &["+", "ikur", "matematika", "plus"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("بعلاوه"),
            keywords: &["+", "بعلاوه", "ریاضی", "علامت"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("plusmerkki"),
            keywords: &["+", "matematiikka", "plus", "plusmerkki"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("malaking plus sign"),
            keywords: &[
                "makapal",
                "malaking plus sign",
                "matematika",
                "plus",
                "senyas",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("pluss"),
            keywords: &[
                "+",
                "matematikk",
                "pluss",
                "plussmerki",
                "rokning",
                "støddfrøði",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("plus"),
            keywords: &[
                "+",
                "addition",
                "arithmétique",
                "mathématiques",
                "plus",
                "signe plus",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("signe d’addition"),
            keywords: &[
                "+",
                "addition",
                "arithmétique",
                "mathématiques",
                "plus",
                "signe d’addition",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("móide"),
            keywords: &["+", "comhartha", "mata", "móide"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("cuir ris"),
            keywords: &[
                "+",
                "cuir ris",
                "cur ris",
                "matamataig",
                "plus",
                "samhla",
                "samhla cuir-ris",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("suma"),
            keywords: &["+", "matemáticas", "máis", "signo", "suma"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("વત\u{acd}તા"),
            keywords: &["+", "ગણિત", "ચિહ\u{acd}ન", "વત\u{acd}તા"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("alamar tarawa mai nauyi"),
            keywords: &["alamar tarawa mai nauyi", "ilimin lissafi", "tarawa"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("סימן חיבור"),
            keywords: &["חשבון", "מתמטיקה", "סימן חיבור", "פלוס"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("धन चिह\u{94d}न"),
            keywords: &["+", "गणित", "चिह\u{94d}न", "धन"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("znak plus"),
            keywords: &["matematika", "plus", "znak plus"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("plusz"),
            keywords: &["+", "jel", "matematika", "plusz"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("գումարման նշան"),
            keywords: &[
                "+",
                "գումարման նշան",
                "թվաբանություն",
                "մաթեմատիկա",
                "նշան",
                "պլյուս",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("tambah"),
            keywords: &["+", "matematika", "plus", "tambah", "tanda"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("nnukwu akara mgbakwunye"),
            keywords: &["mgbakwụnye", "nnukwu akara mgbakwunye", "sọm"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("plús"),
            keywords: &["+", "merki", "plús", "plúsmerki", "stærðfræði"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("simbolo dell’addizione"),
            keywords: &["addizione", "più", "simbolo dell’addizione"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("プラス"),
            keywords: &["+", "プラス", "加算", "記号", "足し算", "足す"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("tambah"),
            keywords: &["+", "matematika", "tambah", "tandha"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("პლუსი"),
            keywords: &["+", "მათემატიკა", "მიმატება", "პლუსი", "პლუსის ნიშანი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("плюс"),
            keywords: &["+", "амал", "белгі", "плюс"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("plus"),
            keywords: &["plus", "plustegn"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("សញ\u{17d2}ញាប\u{17bc}ក"),
            keywords: &[
                "+",
                "គណ\u{17b7}តវ\u{17b7}ទ\u{17d2}យា",
                "ប\u{17bc}ក",
                "សញ\u{17d2}ញា",
                "សញ\u{17d2}ញាប\u{17bc}ក",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಸಂಕಲನ ಚ\u{cbf}ಹ\u{ccd}ನ\u{cc6}"),
            keywords: &["+", "ಗಣ\u{cbf}ತ", "ಚ\u{cbf}ಹ\u{ccd}ನ\u{cc6}", "ಸಂಕಲನ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("더하기"),
            keywords: &["더하기", "더하기 표시", "플러스"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("अदीक"),
            keywords: &["+", "अदीक", "गणीत", "चिन\u{94d}न"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("плюс"),
            keywords: &["+", "белги", "математика", "плюс"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("fettgedrécktent Pluszeechen"),
            keywords: &["Mathematik", "Plus", "fettgedrécktent Pluszeechen"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເຄ\u{eb7}\u{ec8}ອງໝາຍບວກ"),
            keywords: &["ບວກ", "ເຄ\u{eb7}\u{ec8}ອງໝາຍ", "ເຄ\u{eb7}\u{ec8}ອງໝາຍບວກ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("paryškintas pliusas"),
            keywords: &["matematika", "paryškintas pliusas", "pliusas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("pluszīme"),
            keywords: &["+", "matemātika", "plus", "pluszīme", "saskaitīt"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tohu tāpiri taumaha"),
            keywords: &["pāngarau", "tohu tāpiri taumaha", "tāpiri"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("плус"),
            keywords: &["+", "знак", "математика", "плус"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ക\u{d42}ട\u{d4d}ട\u{d41}ക"),
            keywords: &["+", "ക\u{d42}ട\u{d4d}ട\u{d41}ക", "ഗണിതം", "ചിഹ\u{d4d}നം"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("нэмэх"),
            keywords: &["+", "математик", "нэмэх", "тэмдэг"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("अधिक"),
            keywords: &["+ । गणित । अधिक । चिन\u{94d}ह", "अधिक"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("tambah"),
            keywords: &["+", "matematik", "simbol", "tambah"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("sinjal plus grassett"),
            keywords: &["matematika", "plus", "sinjal plus grassett"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အပေါင\u{103a}း"),
            keywords: &[
                "သင\u{103a}\u{1039}ကေတ",
                "သင\u{103a}\u{1039}ချာ",
                "အပေါင\u{103a}း",
                "အပေါင\u{103a}း လက\u{1039}ခဏာ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("pluss"),
            keywords: &[
                "+",
                "addisjon",
                "fortegn",
                "matte",
                "pluss",
                "plusstegn",
                "positivt",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("जोड"),
            keywords: &["+", "गणित", "चिन\u{94d}ह", "जोड"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("plus"),
            keywords: &["+", "plus", "teken", "wiskunde"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("pluss"),
            keywords: &["forteikn", "matte", "pluss", "plussteikn", "positivt"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଯ\u{b41}କ\u{b4d}ତ ଚ\u{b3f}ହ\u{b4d}ନ"),
            keywords: &["+", "ଗଣ\u{b3f}ତ", "ଚ\u{b3f}ହ\u{b4d}ନ", "ଯ\u{b41}କ\u{b4d}ତ"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਜਮ\u{a4d}ਹਾ\u{a02}"),
            keywords: &[
                "+",
                "ਗਣਿਤ",
                "ਚਿ\u{a70}ਨ\u{a4d}ਹ",
                "ਜਮ\u{a4d}ਹਾ\u{a02}",
                "ਨਿਸ\u{a3c}ਾਨ",
                "ਹਿਸਾਬ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("وڈی جمع دی علامت"),
            keywords: &["جمع", "ریاضی", "وڈی جمع دی علامت"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Plọs"),
            keywords: &["+", "Mats", "Plọs", "Sain"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("znak plus"),
            keywords: &[
                "+",
                "dodawanie",
                "dodawać",
                "dodać",
                "matematyka",
                "plus",
                "znak",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د جمع نښه"),
            keywords: &["+", "جمع", "د جمع نښه", "رياضي", "نښه"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("símbolo de adição"),
            keywords: &[
                "+",
                "matemática",
                "sinal",
                "sinal de mais",
                "símbolo de adição",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("adição"),
            keywords: &["+", "adição", "mais", "matemática", "sinal de adição"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("yapana"),
            keywords: &["+", "matematicas", "unancha", "yapana"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("plus"),
            keywords: &["+", "adunare", "matematică", "plus", "semn"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-148"),
            keywords: &["E10-148"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("знак сложения"),
            keywords: &[
                "знак сложения",
                "значок",
                "значок сложения",
                "плюс",
                "сложение",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ikimenyetso kinini cyo guteranya"),
            keywords: &["guteranyaho", "ikimenyetso kinini cyo guteranya", "imibare"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("واڌو جي نشاني"),
            keywords: &["+", "حساب", "نشاني", "واڌو", "واڌو جي نشاني"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ධන"),
            keywords: &["+", "ගණ\u{dd2}තය", "ධන", "ලක\u{dd4}ණ"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("plus"),
            keywords: &["+", "matematika", "plus", "znak", "znak sčítania"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("plus"),
            keywords: &["+", "matematika", "plus", "znak"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("calaamadda isugeynta"),
            keywords: &["+", "calaamad", "calaamadda isugeynta", "isu gee", "xisaab"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("shenja plus e trashë"),
            keywords: &["matematikë", "plus", "shenja plus e trashë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("црни знак плус"),
            keywords: &["мaтeмaтикa", "плус", "црни знак плус"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("crni znak plus"),
            keywords: &["crni znak plus", "matematika", "plus"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("addera"),
            keywords: &["+", "addera", "matte", "plus", "tecken"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kuongeza"),
            keywords: &["+", "alama", "alama ya kuongeza", "hisabati", "kuongeza"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("கூட\u{bcd}டற\u{bcd}குறி"),
            keywords: &[
                "கணக\u{bcd}கு",
                "குறிய\u{bc0}டு",
                "கூட\u{bcd}டற\u{bcd}குறி",
                "கூட\u{bcd}டல\u{bcd}",
                "கூட\u{bcd}டல\u{bcd} குறி",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("కూడ\u{c3f}క చ\u{c47}యడం"),
            keywords: &[
                "+",
                "కూడ\u{c3f}క",
                "కూడ\u{c3f}క చ\u{c47}యడం",
                "గుర\u{c4d}తు",
                "ల\u{c46}క\u{c4d}క",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("аломати вазнини ҷамъ"),
            keywords: &["аломати вазнини ҷамъ", "риёзӣ", "ҷамъ"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("บวก"),
            keywords: &["+", "คณ\u{e34}ต", "บวก", "เคร\u{e37}\u{e48}องหมาย"],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ምድማር"),
            keywords: &["+", "ሕሳብ", "ምልክት", "ምድማር"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("goşmak"),
            keywords: &["+", "belgi", "goşmak", "matematika"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("fakaʻilonga tānaki mamafa"),
            keywords: &["fakaʻilonga", "fakaʻilonga tānaki mamafa", "tānaki"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("artı"),
            keywords: &["+", "artı", "artı işareti", "işaret", "matematik"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئېغىر قوشۇش بەلگىسى"),
            keywords: &["ئېغىر قوشۇش بەلگىسى", "قوشۇش", "ماتېماتىكا"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("плюс"),
            keywords: &["+", "знак", "математичний", "плюс"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("جمع"),
            keywords: &["+", "جمع", "ریاضی", "علامت"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("qoʻshuv"),
            keywords: &[
                "+",
                "belgi",
                "matematika",
                "plus",
                "plyus",
                "qoʻshish belgisi",
                "qoʻshuv",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("cộng"),
            keywords: &["+", "cộng", "dấu", "toán"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("màndargay yokk bu rëy"),
            keywords: &["mat", "màndargay yokk bu rëy", "yokk"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("uphawu lokudibanisa olungqindilili"),
            keywords: &["dibanisa", "ubalo", "uphawu lokudibanisa olungqindilili"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("aami àròpọ\u{300} nla"),
            keywords: &[
                "aami àròpọ\u{300} nla",
                "àròpọ\u{300}",
                "ẹ\u{300}kó\u{329} ìsirò",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("粗加號"),
            keywords: &["+", "加", "數學", "粗加號"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("粗加号"),
            keywords: &["加", "数学", "粗加号"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("加"),
            keywords: &["加", "加号", "十字", "数学", "相加", "符号"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("加"),
            keywords: &["+", "加", "加號", "數學", "符號"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("加號標誌"),
            keywords: &["加號", "加號標誌"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("hlanganisa"),
            keywords: &[
                "hlanganisa",
                "ukubala",
                "ukuhlanganisa",
                "uphawu lokuhlanganisa oluwugqinsi",
            ],
        },
    ],
};
#[doc = "➖"]
pub const MINUS: crate::Emoji = crate::Emoji {
    glyph: "➖",
    codepoint: "2796",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "minus",
    group: "Symbols",
    subgroup: "math",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("minus"),
            keywords: &["minus", "teken", "wiskunde"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ማይነስ"),
            keywords: &["-", "ሒሳብ", "ማይነስ", "ምልክት", "−"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("\u{202b}علامة طرح"),
            keywords: &["رياضيات", "طرح", "\u{202b}علامة طرح", "−"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("বিয\u{9bc}োগ"),
            keywords: &["-", "অংক", "চিন", "বিয\u{9bc}োগ", "−"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("qalın minus işarəsi"),
            keywords: &["minus", "qalın minus işarəsi", "riyaziyyat"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("знак аднімання"),
            keywords: &[
                "-",
                "адніманне",
                "знак аднімання",
                "матэматыка",
                "мінус",
                "−",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Удебелен знак минус"),
            keywords: &["Удебелен знак минус", "математика", "минус"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("বিয\u{9bc}োগ"),
            keywords: &["-", "গণিত", "চিহ\u{9cd}ন", "বিয\u{9bc}োগ", "−"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("nemet"),
            keywords: &["-", "arouezenn", "matematikoù", "nemet"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("znak minus"),
            keywords: &["-", "matematika", "minus", "znak minus", "−"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("signe de restar"),
            keywords: &[
                "-",
                "matemàtiques",
                "menys",
                "signe",
                "signe de restar",
                "−",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᏓᎨᏓ ᎠᎦᏲᎶᏗᏍᎩ ᎤᏙᏪᎸ"),
            keywords: &["-", "ᎠᎦᏲᎶᏗᏍᎩ", "ᎤᏓᎨᏓ ᎠᎦᏲᎶᏗᏍᎩ ᎤᏙᏪᎸ", "ᎤᏙᏪᎸ", "ᏗᏎᏍᏗ", "−"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("znak minus"),
            keywords: &[
                "-",
                "matematika",
                "minus",
                "odčítání",
                "rozdíl",
                "znak minus",
                "−",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("tynnu"),
            keywords: &["-", "arwydd", "mathemateg", "tynnu", "−"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("minus"),
            keywords: &["-", "matematik", "minus", "minustegn", "tegn", "−"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("minus"),
            keywords: &["Minus", "Minuszeichen", "minus"],
        },
        #[cfg(feature = "de_CH")]
        crate::Annotation {
            lang: "de_CH",
            tts: Some("Minus"),
            keywords: &["Minus"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("πλην"),
            keywords: &[
                "-",
                "αφαίρεση",
                "μαθηματικά",
                "μείον",
                "πλην",
                "σύμβολο",
                "−",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("minus"),
            keywords: &["-", "math", "minus", "sign", "−"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: None,
            keywords: &["-", "math", "maths", "minus", "sign", "−"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["-", "math", "maths", "minus", "sign", "subtraction", "–"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["-", "math", "minus", "sign", "−"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["-", "math", "maths", "minus", "sign", "−"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("menos"),
            keywords: &["-", "menos", "resta", "signo", "−"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("resta"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("signo de resta"),
            keywords: &["-", "menos", "resta", "signo", "signo de resta", "−"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("lahutamine"),
            keywords: &[
                "-",
                "lahutamine",
                "matemaatika",
                "miinus",
                "miinusmärk",
                "−",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("minus"),
            keywords: &["-", "ikur", "matematika", "minus", "−"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("تفریق"),
            keywords: &["-", "تفریق", "ریاضی", "علامت", "−"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("miinusmerkki"),
            keywords: &["-", "matematiikka", "miinus", "miinusmerkki", "vähennys"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("malaking minus sign"),
            keywords: &[
                "makapal",
                "malaking minus sign",
                "matematika",
                "minus",
                "senyas",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("minus"),
            keywords: &[
                "-",
                "matematikk",
                "minus",
                "minusmerki",
                "rokning",
                "støddfrøði",
                "−",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("moins"),
            keywords: &[
                "-",
                "arithmétique",
                "mathématiques",
                "moins",
                "signe moins",
                "soustraction",
                "−",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("signe de soustraction"),
            keywords: &[
                "-",
                "arithmétique",
                "mathématiques",
                "moins",
                "signe de soustraction",
                "soustraction",
                "−",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("lúide"),
            keywords: &["-", "comhartha", "lúide", "mata"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("thoir air falbh"),
            keywords: &[
                "-",
                "matamataig",
                "minus",
                "samhla",
                "samhla toirt air falbh",
                "thoir air falbh",
                "toirt air falbh",
                "–",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("resta"),
            keywords: &["-", "matemáticas", "menos", "resta", "signo", "−"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("બાદબાકી"),
            keywords: &["-", "ગણિત", "ચિહ\u{acd}ન", "બાદબાકી", "−"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("alamar deɓewa mai nauyi"),
            keywords: &["alamar deɓewa", "alamar deɓewa mai nauyi", "ilimin lissafi"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("סימן חיסור"),
            keywords: &["חשבון", "מינוס", "מתמטיקה", "סימן חיסור"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ऋण"),
            keywords: &["-", "ऋण", "गणित", "चिह\u{94d}न", "−"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("znak minus"),
            keywords: &["matematika", "minus", "znak minus"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("mínusz"),
            keywords: &["-", "jel", "matematika", "mínusz", "−"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("հանման նշան"),
            keywords: &[
                "-",
                "թվաբանություն",
                "հանման նշան",
                "մաթեմատիկա",
                "մինուս",
                "նշան",
                "−",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("kurang"),
            keywords: &["-", "kurang", "matematika", "minus", "tanda", "−"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("nnukwu akara mwepụ"),
            keywords: &["mwepụ", "nnukwu akara mwepụ", "sọm"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("mínus"),
            keywords: &["-", "merki", "mínus", "mínusmerki", "stærðfræði", "–"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("simbolo della sottrazione"),
            keywords: &["meno", "simbolo della sottrazione", "sottrazione"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("マイナス"),
            keywords: &["-", "マイナス", "引き算", "引く", "減算", "記号"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("kurang"),
            keywords: &["-", "kurang", "matematika", "tandha", "−"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მინუსი"),
            keywords: &[
                "-",
                "გამოკლება",
                "მათემატიკა",
                "მინუსი",
                "მინუსის ნიშანი",
                "−",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("минус"),
            keywords: &["-", "амал", "белгі", "минус", "−"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("minus"),
            keywords: &["minus", "minustegn"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("សញ\u{17d2}ញាដក"),
            keywords: &[
                "-",
                "គណ\u{17b7}តវ\u{17b7}ទ\u{17d2}យា",
                "ដក",
                "សញ\u{17d2}ញា",
                "សញ\u{17d2}ញាដក",
                "−",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ವ\u{ccd}ಯವಕಲನ ಚ\u{cbf}ಹ\u{ccd}ನ\u{cc6}"),
            keywords: &[
                "-",
                "ಗಣ\u{cbf}ತ",
                "ಚ\u{cbf}ಹ\u{ccd}ನ\u{cc6}",
                "ವ\u{ccd}ಯವಕಲನ ಚ\u{cbf}ಹ\u{ccd}ನ\u{cc6}",
                "−",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("빼기"),
            keywords: &["마이너스", "빼기", "빼기 표시"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("वजा"),
            keywords: &["-", "गणीत", "चिन\u{94d}न", "वजा", "−"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("минус"),
            keywords: &["-", "белги", "математика", "минус", "−"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("fettgedrécktent Minuszeechen"),
            keywords: &["Mathematik", "Minus", "fettgedrécktent Minuszeechen"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເຄ\u{eb7}\u{ec8}ອງໝາຍລ\u{ebb}ບ"),
            keywords: &[
                "ລ\u{ebb}ບ",
                "ເຄ\u{eb7}\u{ec8}ອງໝາຍ",
                "ເຄ\u{eb7}\u{ec8}ອງໝາຍລ\u{ebb}ບ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("paryškintas minusas"),
            keywords: &["matematika", "minusas", "paryškintas minusas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("mīnuss"),
            keywords: &["-", "atņemt", "matemātika", "mīnuss", "mīnuszīme", "–"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tohu tango taumaha"),
            keywords: &["pāngarau", "tango", "tohu tango taumaha"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("минус"),
            keywords: &["-", "знак", "математика", "минус", "−"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("കിഴിക\u{d4d}ക\u{d41}ക"),
            keywords: &["-", "കിഴിക\u{d4d}ക\u{d41}ക", "ഗണിതം", "ചിഹ\u{d4d}നം", "−"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("хасах"),
            keywords: &["-", "маткематик", "тэмдэг", "хасах", "−"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("वजा"),
            keywords: &["-", "गणित । वजा । चिन\u{94d}ह", "वजा", "−"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("tolak"),
            keywords: &["-", "matematik", "simbol", "tolak", "−"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("sinjal minus grassett"),
            keywords: &["matematika", "minus", "sinjal minus grassett"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အန\u{102f}တ\u{103a}"),
            keywords: &[
                "သင\u{103a}\u{1039}ကေတ",
                "သင\u{103a}\u{1039}ချာ",
                "အန\u{102f}တ\u{103a}",
                "အန\u{102f}တ\u{103a}လက\u{1039}ခဏာ သင\u{103a}\u{1039}ကေတ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("minus"),
            keywords: &[
                "-",
                "fortegn",
                "matte",
                "minus",
                "minustegn",
                "negativt",
                "subtraksjon",
                "−",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("घटाउ"),
            keywords: &["-", "गणित", "घटाउ", "चिन\u{94d}ह", "−"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("min"),
            keywords: &["-", "min", "teken", "wiskunde", "−"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("minus"),
            keywords: &[
                "-",
                "forteikn",
                "matte",
                "minus",
                "minusteikn",
                "negativt",
                "–",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଫେଡ\u{b3e}ଣ ଚ\u{b3f}ହ\u{b4d}ନ"),
            keywords: &["-", "ଗଣ\u{b3f}ତ", "ଚ\u{b3f}ହ\u{b4d}ନ", "ଫେଡ\u{b3e}ଣ", "−"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਘਟਾਓ"),
            keywords: &[
                "-",
                "ਗਣਿਤ",
                "ਘਟਾਓ",
                "ਚਿ\u{a70}ਨ\u{a4d}ਹ",
                "ਨਿਸ\u{a3c}ਾਨ",
                "ਹਿਸਾਬ",
                "−",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("وڈی منفی دی علامت"),
            keywords: &["ریاضی", "منفی", "وڈی منفی دی علامت"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Maínọs"),
            keywords: &["-", "Mats", "Maínọs", "Sain"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("znak minus"),
            keywords: &["-", "matematyka", "odejmowanie", "znak", "znak minus", "−"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د منفي نښه"),
            keywords: &["-", "د منفي نښه", "رياضي", "منفي", "نښه", "−"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("símbolo de subtração"),
            keywords: &[
                "-",
                "matemática",
                "menos",
                "sinal",
                "símbolo de subtração",
                "−",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("subtração"),
            keywords: &[
                "-",
                "matemática",
                "menos",
                "sinal de subtração",
                "subtracção",
                "subtração",
                "−",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("qhichuna"),
            keywords: &["-", "matematicas", "qhichuna", "qichuna", "unancha"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("minus"),
            keywords: &["-", "matematică", "minus", "scădere", "semn minus", "–"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-149"),
            keywords: &["E10-149"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("знак вычитания"),
            keywords: &[
                "вычитание",
                "знак вычитания",
                "значок",
                "значок вычитания",
                "минус",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ikimenyetso kinini cyo gukuramo"),
            keywords: &["gukuramo", "ikimenyetso kinini cyo gukuramo", "imibare"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڪاٽو جي نشاني"),
            keywords: &["-", "حساب", "نشاني", "ڪاٽو", "ڪاٽو جي نشاني", "−"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ඍණ"),
            keywords: &["-", "ඍණ", "ගණ\u{dd2}තය", "ලක\u{dd4}ණ", "−"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("mínus"),
            keywords: &["-", "matematika", "mínus", "znak", "znak odčítania", "−"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("minus"),
            keywords: &["-", "matematika", "minus", "znak", "−"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("calaamadda ka jar"),
            keywords: &[
                "-",
                "calaamad",
                "calaamadda ka jar",
                "ka jar",
                "xisaab",
                "−",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("shenja minus e trashë"),
            keywords: &["matematikë", "minus", "shenja minus e trashë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("црни знак минус"),
            keywords: &["-", "знак", "мaтeмaтикa", "минус", "црни знак минус", "−"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("crni znak minus"),
            keywords: &["-", "crni znak minus", "matematika", "minus", "znak", "−"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("subtrahera"),
            keywords: &["-", "matte", "minus", "subtrahera", "tecken", "−"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kutoa"),
            keywords: &["-", "alama", "alama ya kutoa", "hisabati", "kutoa", "−"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("கழித\u{bcd}தல\u{bcd} குறி"),
            keywords: &[
                "கணக\u{bcd}கு",
                "கழித\u{bcd}தல\u{bcd}",
                "கழித\u{bcd}தல\u{bcd} குறி",
                "குறிய\u{bc0}டு",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("త\u{c40}స\u{c3f}వ\u{c47}త"),
            keywords: &[
                "-",
                "చ\u{c3f}హ\u{c4d}నం",
                "త\u{c40}స\u{c3f}వ\u{c47}త",
                "ల\u{c46}క\u{c4d}క",
                "−",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("аломати вазнини тарҳ"),
            keywords: &["аломати вазнини тарҳ", "риёзӣ", "тарҳ"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ลบ"),
            keywords: &["-", "คณ\u{e34}ต", "ลบ", "เคร\u{e37}\u{e48}องหมาย", "−"],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ምጉዳል"),
            keywords: &["-", "ሕሳብ", "ምልክት", "ምጉዳል", "−"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("aýyrmak"),
            keywords: &["-", "aýyrmak", "belgi", "matematika", "−"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("fakaʻilonga kole mamafa"),
            keywords: &["fakaʻilonga", "fakaʻilonga kole mamafa", "kole"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("eksi"),
            keywords: &["-", "eksi", "eksi işareti", "işaret", "matematik", "−"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئېغىر ئېلىش بەلگىسى"),
            keywords: &["ئېغىر ئېلىش بەلگىسى", "ئېلىش", "ماتېماتىكا"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("мінус"),
            keywords: &["-", "знак", "математичний", "мінус", "−"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("منفی"),
            keywords: &["-", "ریاضی", "علامت", "منفی", "−"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("ayiruv"),
            keywords: &[
                "-",
                "ayirish belgisi",
                "ayiruv",
                "belgi",
                "manfiy",
                "matematika",
                "minus",
                "−",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("trừ"),
            keywords: &["-", "dấu", "toán", "trừ", "−"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("màndargay wàññi bu rëy"),
            keywords: &["mat", "màndargay wàññi bu rëy", "wàññi"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("uphawu lokuthabatha olungqindilili"),
            keywords: &["thabatha", "ubalo", "uphawu lokuthabatha olungqindilili"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("aami ayọkuro nla"),
            keywords: &["aami ayọkuro nla", "àyọkúrò", "ẹ\u{300}kó\u{329} ìsirò"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("粗減號"),
            keywords: &["-", "−", "數學", "減", "粗減號"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("粗减号"),
            keywords: &["减", "数学", "粗减号"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("减"),
            keywords: &["减", "减号", "数学", "横线", "符号"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("減"),
            keywords: &["-", "−", "數學", "減", "減號", "符號"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("減號"),
            keywords: &["-", "−", "數學", "減", "減號", "符號"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("uphawu lokususa oluwugqinsi"),
            keywords: &["ukuhlanganisa", "ukususa", "uphawu lokususa oluwugqinsi"],
        },
    ],
};
#[doc = "➗"]
pub const DIVIDE: crate::Emoji = crate::Emoji {
    glyph: "➗",
    codepoint: "2797",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "divide",
    group: "Symbols",
    subgroup: "math",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("deel"),
            keywords: &["deel", "teken", "wiskunde"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ማካፈል"),
            keywords: &["÷", "ሒሳብ", "ማካፈል", "ምልክት", "የማካፈል"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("\u{202b}علامة قسمة"),
            keywords: &["÷", "رياضيات", "قسمة", "\u{202b}علامة قسمة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("হৰণ"),
            keywords: &["÷", "অংক", "চিন", "হৰণ"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("qalın bölmə işarəsi"),
            keywords: &["bölmə", "qalın bölmə işarəsi", "riyaziyyat"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("знак дзялення"),
            keywords: &["÷", "дзяленне", "знак дзялення", "матэматыка"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Удебелен знак за деление"),
            keywords: &["Удебелен знак за деление", "деление", "математика"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ভ\u{9be}গ"),
            keywords: &["÷", "গণিত", "চিহ\u{9cd}ন", "ভ\u{9be}গ"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("rannañ"),
            keywords: &["arouezenn", "matematikoù", "rannañ", "÷"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("znak dijeljenja"),
            keywords: &["dijeljenje", "matematika", "znak dijeljenja", "÷"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("signe de dividir"),
            keywords: &["divisió", "matemàtiques", "signe", "signe de dividir", "÷"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᏓᎨᏓ ᏱᎦᏛᎢ ᎤᏙᏪᎸ"),
            keywords: &["÷", "ᎤᏓᎨᏓ ᏱᎦᏛᎢ", "ᎤᏓᎨᏓ ᏱᎦᏛᎢ ᎤᏙᏪᎸ", "ᎤᏙᏪᎸ", "ᏗᏎᏍᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("znak dělení"),
            keywords: &[
                "děleno",
                "dělení",
                "matematika",
                "podíl",
                "znak dělení",
                "÷",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("rhannu"),
            keywords: &["arwydd", "mathemateg", "rhannu", "÷"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("dividere"),
            keywords: &[
                "dividere",
                "division",
                "divisionstegn",
                "matematik",
                "tegn",
                "÷",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("geteilt durch"),
            keywords: &["Division", "geteilt durch"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("διαίρεση"),
            keywords: &["÷", "διαίρεση", "μαθηματικά", "σύμβολο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("divide"),
            keywords: &["divide", "division", "math", "sign", "÷"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: None,
            keywords: &[
                "divide",
                "division",
                "heavy division sign",
                "math",
                "maths",
                "÷",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["divide", "division", "math", "sign", "÷"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["divide", "division", "math", "sign", "÷"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &[
                "divide",
                "division",
                "heavy division sign",
                "math",
                "maths",
                "÷",
            ],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("división"),
            keywords: &["división", "signo", "signo de división", "÷"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("signo de división"),
            keywords: &["división", "signo", "signo de división", "÷"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("jagamine"),
            keywords: &["jagamine", "jagamismärk", "matemaatika", "märk", "÷"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("zatitu"),
            keywords: &["ikur", "matematika", "zatiketa", "zatitu", "÷"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("تقسیم کردن"),
            keywords: &["÷", "تقسیم", "تقسیم کردن", "ریاضی", "علامت"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("jakomerkki"),
            keywords: &["/", "jako", "jakomerkki", "jakoviiva", "matematiikka"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("malaking division sign"),
            keywords: &[
                "division",
                "makapal",
                "malaking division sign",
                "matematika",
                "math",
                "senyas",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("deila"),
            keywords: &["býti", "deila", "matematikk", "rokning", "støddfrøði", "÷"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("signe diviser"),
            keywords: &["diviser", "division", "mathématiques", "signe", "÷"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("signe de division"),
            keywords: &[
                "/",
                "arithmétique",
                "division",
                "mathématiques",
                "signe de division",
                "÷",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("roinnte"),
            keywords: &["comhartha", "mata", "roinn", "roinnte", "÷"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("roinn"),
            keywords: &[
                "/",
                "matamataig",
                "roinn",
                "roinn le",
                "roinneadh",
                "samhla",
                "samhla roinnidh",
                "÷",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("división"),
            keywords: &["división", "matemáticas", "signo", "÷"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ભાગાકાર"),
            keywords: &["÷", "ગણિત", "ચિહ\u{acd}ન", "ભાગાકાર"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("alamar rabawa mai nauyi"),
            keywords: &["alamar rabawa mai nauyi", "ilimin lissafi", "rabawa"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("סימן חילוק"),
            keywords: &[
                "חילוק",
                "חלקי",
                "חשבון",
                "מתמטיקה",
                "סימן חילוק",
                "סימן חילוק עבה",
            ],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("भाग"),
            keywords: &["÷", "गणित", "चिह\u{94d}न", "भाग"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("znak dijeljenja"),
            keywords: &["dijeljenje", "matematika", "znak dijeljenja"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("osztás"),
            keywords: &["jel", "matematika", "osztás", "÷"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("բաժանում"),
            keywords: &[
                "÷",
                "բաժանման նշան",
                "բաժանում",
                "թվաբանություն",
                "մաթեմատիկա",
                "նշան",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("bagi"),
            keywords: &["bagi", "matematika", "pembagian", "tanda", "÷"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("nnukwu akara nkewa"),
            keywords: &["nkewa", "nnukwu akara nkewa", "sọm"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("deiling"),
            keywords: &["deiling", "deilingarmerki", "merki", "stærðfræði", "÷"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("simbolo della divisione"),
            keywords: &["divisione", "diviso", "simbolo della divisione"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("割り算"),
            keywords: &["/", "割り算", "割る", "記号", "除算"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("tandha para"),
            keywords: &["matematika", "paran", "tandha", "tandha para", "÷"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("გაყოფა"),
            keywords: &["÷", "გაყოფა", "გაყოფის ნიშანი", "მათემატიკა"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("бөлу"),
            keywords: &["÷", "амал", "белгі", "бөлу"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("division"),
            keywords: &["division", "divisionstegn"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("សញ\u{17d2}ញាចែក"),
            keywords: &[
                "÷",
                "គណ\u{17b7}តវ\u{17b7}ទ\u{17d2}យា",
                "ចែក",
                "សញ\u{17d2}ញា",
                "សញ\u{17d2}ញាចែក",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ವ\u{cbf}ಭಜನ\u{cc6} ಚ\u{cbf}ಹ\u{ccd}ನ\u{cc6}"),
            keywords: &[
                "÷",
                "ಗಣ\u{cbf}ತ",
                "ಚ\u{cbf}ಹ\u{ccd}ನ\u{cc6}",
                "ಭಾಗಾಕಾರ",
                "ವ\u{cbf}ಭಜನ\u{cc6} ಚ\u{cbf}ಹ\u{ccd}ನ\u{cc6}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("나누기"),
            keywords: &["나누기", "나누기 표시"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("भागाकार"),
            keywords: &["÷", "गणीत", "चिन\u{94d}न", "भागाकार"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("бөлүү"),
            keywords: &["÷", "белги", "бөлүү", "математика"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("fettgedrécktent Divisiounszeechen"),
            keywords: &[
                "Divisioun",
                "Mathematik",
                "fettgedrécktent Divisiounszeechen",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຫານ"),
            keywords: &["ຫານ", "ເຄ\u{eb7}\u{ec8}ອງໝາຍ", "ເຄ\u{eb7}\u{ec8}ອງໝາຍຫານ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("paryškintas dalybos ženklas"),
            keywords: &["dalyba", "matematika", "paryškintas dalybos ženklas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("dalīt"),
            keywords: &["/", "dalīt", "dalīšanas zīme", "matemātika", "÷"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tohu whakawehe taumaha"),
            keywords: &["pāngarau", "tohu whakawehe taumaha", "whakawehe"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("делење"),
            keywords: &["÷", "делење", "знак", "математика"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഹരിക\u{d4d}ക\u{d41}ക"),
            keywords: &["÷", "ഗണിതം", "ചിഹ\u{d4d}നം", "ഹരണം", "ഹരിക\u{d4d}ക\u{d41}ക"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("хуваах"),
            keywords: &["÷", "математик", "тэмдэг", "хуваах"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("भागाकार"),
            keywords: &["÷ । भागाकार । गणित । चिन\u{94d}ह", "भागाकार"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("bahagi"),
            keywords: &["bahagi", "matematik", "simbol", "÷"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("sinjal diviżjoni grassett"),
            keywords: &["diviżjoni", "matematika", "sinjal diviżjoni grassett"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အစားလက\u{1039}ခဏာသင\u{103a}\u{1039}ကေတ"),
            keywords: &[
                "စားခြင\u{103a}း",
                "သင\u{103a}\u{1039}ကေတ",
                "သင\u{103a}\u{1039}ချာ",
                "အစားလက\u{1039}ခဏာ",
                "အစားလက\u{1039}ခဏာသင\u{103a}\u{1039}ကေတ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("dele"),
            keywords: &[
                "dele",
                "deletegn",
                "deling",
                "divisjon",
                "divisjonstegn",
                "÷",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("भाग"),
            keywords: &["÷", "गणित", "चिन\u{94d}ह", "भाग"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("delen"),
            keywords: &["delen", "teken", "wiskunde", "÷"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("deleteikn"),
            keywords: &[
                "dele",
                "deleteikn",
                "delilng",
                "divisjon",
                "divisjonsteikn",
                "÷",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ହରଣ କର\u{b3f}ବ\u{b3e}"),
            keywords: &[
                "÷",
                "ଗଣ\u{b3f}ତ",
                "ଚ\u{b3f}ହ\u{b4d}ନ",
                "ହରଣ",
                "ହରଣ କର\u{b3f}ବ\u{b3e}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਤਕਸੀਮ"),
            keywords: &[
                "÷",
                "ਗਣਿਤ",
                "ਚਿ\u{a70}ਨ\u{a4d}ਹ",
                "ਤਕਸੀਮ",
                "ਨਿਸ\u{a3c}ਾਨ",
                "ਭਾਗ",
                "ਵ\u{a70}ਡ",
                "ਹਿਸਾਬ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("وڈی تقسیم دی علامت"),
            keywords: &["تقسیم", "ریاضی", "وڈی تقسیم دی علامت"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Divaid"),
            keywords: &["Divaid", "Divíshọn", "Mats", "Sain", "÷"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("znak dzielenia"),
            keywords: &["dzielenie", "matematyka", "znak", "znak dzielenia", "÷"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د تقسيم نښه"),
            keywords: &["÷", "تقسيم", "د تقسيم نښه", "رياضي", "نښه"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("símbolo de divisão"),
            keywords: &["divisão", "matemática", "sinal", "símbolo de divisão", "÷"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("divisão"),
            keywords: &["divisão", "matemática", "sinal de divisão", "÷"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("împărțire"),
            keywords: &["matematică", "semn", "împărțire", "÷"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-150"),
            keywords: &["E10-150"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("знак деления"),
            keywords: &["деление", "знак деления", "значок", "значок деления"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ikimenyetso kinini cyo kugabanya"),
            keywords: &["ikimenyetso kinini cyo kugabanya", "imibare", "kugabanya"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ونڊ"),
            keywords: &["÷", "حساب", "نشاني", "ونڊ", "ونڊ جي نشاني"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("බෙද\u{dd3}ම"),
            keywords: &["÷", "ගණ\u{dd2}තය", "බෙද\u{dd3}ම", "ලක\u{dd4}ණ"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("deleno"),
            keywords: &[
                "delenie",
                "deleno",
                "deliť",
                "matematika",
                "znak",
                "znak delenia",
                "÷",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("deli"),
            keywords: &[
                "deli",
                "deljenje",
                "matematika",
                "znak",
                "znak za deljenje",
                "÷",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("calaamadda isu qaybinta"),
            keywords: &[
                "calaamad",
                "calaamadda isu qaybinta",
                "isu qaybin",
                "qaybi",
                "xisaab",
                "÷",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("shenja e pjesëtimit e trashë"),
            keywords: &["matematikë", "ndarje", "shenja e pjesëtimit e trashë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("црни знак за дељење"),
            keywords: &[
                "÷",
                "дeљeњe",
                "дели",
                "знак",
                "мaтeмaтикa",
                "црни знак за дељење",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("црни знак за дијељење"),
            keywords: &["црни знак за дијељење"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("crni znak za deljenje"),
            keywords: &[
                "crni znak za deljenje",
                "deli",
                "deljenje",
                "matematika",
                "znak",
                "÷",
            ],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("crni znak za dijeljenje"),
            keywords: &["crni znak za dijeljenje"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("dividera"),
            keywords: &["dividera", "division", "matte", "tecken", "÷"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("gawanya"),
            keywords: &[
                "alama",
                "alama ya kugawanya",
                "gawanya",
                "hisabati",
                "kugawanya",
                "÷",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("வகுத\u{bcd}தற\u{bcd}குறி"),
            keywords: &[
                "கணக\u{bcd}கு",
                "குறிய\u{bc0}டு",
                "வகுத\u{bcd}தற\u{bcd}குறி",
                "வகுத\u{bcd}தல\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("భ\u{c3e}గహ\u{c3e}రం"),
            keywords: &[
                "÷",
                "చ\u{c3f}హ\u{c4d}నం",
                "భ\u{c3e}గహ\u{c3e}రం",
                "భ\u{c3e}గ\u{c3e}హ\u{c3e}రం",
                "ల\u{c46}క\u{c4d}క",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("аломати вазнини тақсим"),
            keywords: &["аломати вазнини тақсим", "риёзӣ", "тақсим"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("หาร"),
            keywords: &["÷", "คณ\u{e34}ต", "หาร", "เคร\u{e37}\u{e48}องหมาย"],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ምምቃል"),
            keywords: &["÷", "ሕሳብ", "ምልክት", "ምምቃል"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("bölmek"),
            keywords: &["belgi", "böl", "bölmek", "matematika", "÷"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("fakaʻilonga vahevahe mamafa"),
            keywords: &["fakaʻilonga", "fakaʻilonga vahevahe mamafa", "vahevahe"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("bölü işareti"),
            keywords: &["bölü", "bölü işareti", "işaret", "matematik", "÷"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئېغىر بۆلۈش بەلگىسى"),
            keywords: &["ئېغىر بۆلۈش بەلگىسى", "بۆلۈش", "ماتېماتىكا"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("ділення"),
            keywords: &["÷", "ділення", "знак", "математичний"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("تقسیم"),
            keywords: &["÷", "تقسیم", "تقسیم کرنا", "ریاضی", "علامت"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("boʻluv"),
            keywords: &[
                "belgi",
                "boʻlish",
                "boʻlish belgisi",
                "boʻluv",
                "matematika",
                "÷",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("dấu chia"),
            keywords: &["chia", "dấu", "toán", "÷"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("màndargay xaajale bu rëy"),
            keywords: &["diwise", "mat", "màndargay xaajale bu rëy"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("uphawu lolwahlulo olungqindilili"),
            keywords: &["ubalo", "ukwahlula", "uphawu lolwahlulo olungqindilili"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("aami gige nla"),
            keywords: &["aami gige nla", "ìpín", "ẹ\u{300}kọ\u{301} ìsirò"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("粗除號"),
            keywords: &["÷", "數學", "粗除號", "除"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("粗除号"),
            keywords: &["数学", "粗除号", "除"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("除"),
            keywords: &["数学", "相除", "符号", "除", "除号"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("除"),
            keywords: &["÷", "數學", "符號", "除", "除法", "除號"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("uphawu lokwahlukanisa oluwugqinsi"),
            keywords: &[
                "ukuhlanganisa",
                "ukwahlukanisa",
                "uphawu lokwahlukanisa oluwugqinsi",
            ],
        },
    ],
};
#[doc = "♾\u{fe0f}"]
pub const INFINITY: crate::Emoji = crate::Emoji {
    glyph: "♾\u{fe0f}",
    codepoint: "267E FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "infinity",
    group: "Symbols",
    subgroup: "math",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "♾",
        codepoint: "267E",
        status: crate::Status::Unqualified,
        introduction_version: 11f32,
        name: "infinity",
        group: "Symbols",
        subgroup: "math",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("oneindigheid"),
            keywords: &[
                "altyd",
                "oneindig",
                "oneindigheid",
                "universeel",
                "vir ewig",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ወሰን የሌለው"),
            keywords: &["አለም አቀፍ", "እስከ መጨራሻው", "ወሰን የሌለው", "ያልተገደበ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("اللا نهاية"),
            keywords: &[
                "إلى الأبد",
                "اللا نهائية",
                "اللا نهاية",
                "المالا نهاية",
                "مالا نهاية",
            ],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("সীম\u{9be}হীন"),
            keywords: &["অসীমিত", "চিৰদিন", "বিশ\u{9cd}বজনীন", "সীম\u{9be}হীন"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("sonsuzluq"),
            keywords: &["həmişəlik", "limitsiz", "sonsuzluq", "universal"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("бясконцасць"),
            keywords: &["безгранічны", "бясконцасць", "вечны", "універсальны"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("безкрайност"),
            keywords: &["безкрайност", "вечност", "завинаги", "неограничено"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("অনন\u{9cd}ত"),
            keywords: &["অনন\u{9cd}ত", "অসীম", "চিরতরে", "বিশ\u{9cd}বজনীন"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("anfin"),
            keywords: &["anfin", "arouezenn", "matematikoù"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("beskonačnost"),
            keywords: &["beskonačno", "beskonačnost", "neograničeno", "univerzalno"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("infinit"),
            keywords: &["il·limitat", "infinit", "per sempre", "universal"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎢᎪᎯᏓ"),
            keywords: &["ᎢᎪᎯᏓ", "ᎢᎪᎯᏛᏉ ᎨᏒᎢ", "ᎢᎬᏩᏓᎴᎩ", "ᎤᎶᏒᏍᏔᏅᎢ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("nekonečno"),
            keywords: &[
                "bez hranic",
                "nekonečno",
                "nekonečnost",
                "neomezenost",
                "věčnost",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("anfeidredd"),
            keywords: &["am byth", "anfeidredd", "cyfun", "diderfyn"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("uendelig"),
            keywords: &[
                "ubegrænset",
                "uendelig",
                "uendelighed",
                "uendelighedstegn",
                "universel",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Unendlichkeit"),
            keywords: &["Unendlichkeit", "ewig", "grenzenlos", "unendlich"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("άπειρο"),
            keywords: &["άπειρο", "αιώνια", "απεριόριστα", "για πάντα", "καθολικό"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("infinity"),
            keywords: &["forever", "infinity", "unbounded", "universal"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["eternal", "forever", "infinity", "unbound", "universal"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("infinito"),
            keywords: &["ilimitado", "infinito", "siempre", "universal"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("infinito"),
            keywords: &["eterno", "ilimitado", "infinito", "universal"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("infinito"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("lõpmatus"),
            keywords: &["igavesti", "kõikehaarav", "lõpmatu", "lõpmatus"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("infinitu"),
            keywords: &["beti", "infinitu", "mugagabe", "unibertsal"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("بی\u{200c}نهایت"),
            keywords: &["برای همیشه", "بی\u{200c}حدوحصر", "بی\u{200c}نهایت", "کلی"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("äärettömyys"),
            keywords: &[
                "aina",
                "ikuinen",
                "rajaton",
                "universaali",
                "äärettömyys",
                "ääretön",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("infinity"),
            keywords: &[
                "forever",
                "infinity",
                "panghabang buhay",
                "walang katapusan",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("óendaligt"),
            keywords: &["endaleyst", "í allar ævir", "óendalig", "óendaligt"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("infini"),
            keywords: &["illimité", "infini", "universel", "éternité"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("éigríoch"),
            keywords: &["gan srian", "go deo", "uilíoch", "éigríoch"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("neo-chrìochnachd"),
            keywords: &[
                "buan",
                "daonnan",
                "gun chrìch",
                "gun chrìoch",
                "neo-chrìochnachd",
                "uile-choicheann",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("infinito"),
            keywords: &["eterno", "ilimitado", "infinito", "símbolo", "universal"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("અસીમ"),
            keywords: &["અમર", "અસીમ", "કાયમ", "સાર\u{acd}વત\u{acd}રિક"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("אינסוף"),
            keywords: &["אוניברסלי", "אין-סוף", "אינסוף", "בלתי מוגבל"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("अन\u{902}त"),
            keywords: &["अन\u{902}त", "अपार", "सार\u{94d}वभौमिक", "हम\u{947}शा"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("beskonačnost"),
            keywords: &["beskonačnost", "beskrajno", "univerzalno", "zauvijek"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("végtelen"),
            keywords: &["korlátlan", "univerzális", "végtelen", "örökké"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("անվերջություն"),
            keywords: &["անսահման", "անվերջ", "անվերջություն", "մշտնջենական"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("tak terhingga"),
            keywords: &["selamanya", "tak terbatas", "tak terhingga", "universal"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("óendanleiki"),
            keywords: &["algilt", "eilífð", "takmarkaleysi", "óendanleiki"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("simbolo dell’infinito"),
            keywords: &[
                "eternità",
                "illimitato",
                "per sempre",
                "simbolo dell’infinito",
                "universale",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("無限大"),
            keywords: &["万物", "永遠", "無限", "無限大"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("tanpa wates"),
            keywords: &["abadi", "tanpa kaiket", "tanpa wates", "universal"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("უსასრულობა"),
            keywords: &["სამუდამოდ", "უნივერსალური", "უსასრულობა"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("шексіздік"),
            keywords: &["мәңгі", "шексіз", "шексіздік", "әмбебап"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("សញ\u{17d2}ញាអនន\u{17d2}ត"),
            keywords: &[
                "គ\u{17d2}មានព\u{17d2}រ\u{17c6}ដែន",
                "ជារៀងរហ\u{17bc}ត",
                "ជាសកល",
                "សញ\u{17d2}ញាអនន\u{17d2}ត",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಅಪರ\u{cbf}ಮ\u{cbf}ತ"),
            keywords: &[
                "ಅಪರ\u{cbf}ಮ\u{cbf}ತ",
                "ಮ\u{cbf}ತ\u{cbf}ರಹ\u{cbf}ತ",
                "ಶಾಶ\u{ccd}ವತ",
                "ಸಾರ\u{ccd}ವತ\u{ccd}ರ\u{cbf}ಕ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("무한"),
            keywords: &["뫼비우스", "무한", "영원"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("अन\u{902}त"),
            keywords: &[
                "अन\u{902}त",
                "य\u{941}निवर\u{94d}सल",
                "शिमनाशिल\u{94d}ल\u{947}\u{902}",
                "सदा\u{902}काळ",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("чексиз"),
            keywords: &["аалам", "түбөлүк", "чексиз", "чектелбеген"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ອະສ\u{ebb}ງໄຂ"),
            keywords: &[
                "ຈ\u{eb1}ກກະວານ",
                "ຕະລອດການ",
                "ບ\u{ecd}\u{ec8}ມ\u{eb5}ຂອບເຂດ",
                "ອະສ\u{ebb}ງໄຂ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("begalybė"),
            keywords: &["amžinai", "begalybė", "neribotas", "universalus"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("bezgalība"),
            keywords: &["bezgalība", "bezgalīgs", "mūžība", "vispārīgs"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("бесконечност"),
            keywords: &["бесконечност", "засекогаш", "неограничено", "универзално"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("അനന\u{d4d}തത"),
            keywords: &[
                "അതിരില\u{d4d}ല\u{d3e}ത\u{d4d}ത",
                "അനന\u{d4d}തത",
                "എന\u{d4d}നന\u{d4d}നേയ\u{d4d}\u{200c}ക\u{d4d}ക\u{d41}ം",
                "സ\u{d3e}ർവ\u{d4d}വല\u{d57}കികം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("хязгааргүй"),
            keywords: &["мөнхийн", "универсал", "хязгааргүй"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("अन\u{902}त"),
            keywords: &["अन\u{902}त", "अमर\u{94d}याद", "कायम", "व\u{948}श\u{94d}विक"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("infiniti"),
            keywords: &["infiniti", "sejagat", "selama-lamanya", "tidak terbatas"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အနန\u{103a}တ"),
            keywords: &[
                "ကမ\u{1039}ဘာလ\u{102f}\u{1036}းဆ\u{102d}\u{102f}င\u{103a}ရာ",
                "ထာဝရ",
                "အကန\u{1037}\u{103a}အသတ\u{103a}မ\u{1032}\u{1037}",
                "အနန\u{1039}တ",
                "အနန\u{103a}တ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("uendelig"),
            keywords: &[
                "for alltid",
                "grenseløs",
                "uendelig",
                "universal",
                "universell",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("अपरिमित"),
            keywords: &[
                "अपरिमित",
                "बिना रोकटोकवाला",
                "विश\u{94d}वव\u{94d}यापी",
                "सदाका लागि",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("oneindig"),
            keywords: &["eeuwig", "grenzeloos", "oneindig", "universeel"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("uendeleg"),
            keywords: &[
                "for alltid",
                "grenselaus",
                "uendeleg",
                "universal",
                "universell",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଇନଫ\u{b3f}ନ\u{b3f}ଟୀ"),
            keywords: &[
                "ଅନନ\u{b4d}ତତ\u{b3e}",
                "ଅସମ\u{b4d}ବନ\u{b4d}ଧ",
                "ଇନଫ\u{b3f}ନ\u{b3f}ଟୀ",
                "ସବ\u{b41} ସମୟ ପ\u{b3e}ଇ\u{b01}",
                "ସ\u{b3e}ର\u{b4d}ବଭୌମ\u{b3f}କ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਅਨ\u{a70}ਤਤਾ"),
            keywords: &["ਅਨ\u{a70}ਤਤਾ", "ਬ\u{a47}ਅ\u{a70}ਤ", "ਵਿਆਪਕ", "ਸਦਾ ਲਈ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Infíníti"),
            keywords: &[
                "Fọ Ẹ\u{301}vríwia",
                "Fọrẹ\u{301}va",
                "Infíníti",
                "Jẹ\u{301}náral",
                "Nọ\u{301} Gẹ\u{301}t Límit",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("nieskończoność"),
            keywords: &["bezgraniczność", "nieskończoność", "wieczność"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("لا محدود"),
            keywords: &["تلپاتې", "عالمي", "لا محدود", "ډېر زيات"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("infinito"),
            keywords: &["eternidade", "ilimitado", "infinito", "universal"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("infinit"),
            keywords: &["etern", "infinit", "nelimitat", "universal"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E11-002"),
            keywords: &["E11-002"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("бесконечность"),
            keywords: &[
                "бесконечность",
                "знак бесконечности",
                "навсегда",
                "постоянно",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("انفينٽي"),
            keywords: &["انفينٽي", "غير محدود", "هميشه لاء\u{650}", "يونيورسل"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("අනන\u{dca}තය"),
            keywords: &[
                "අනන\u{dca}තය",
                "අස\u{dd3}ම\u{dd2}තය\u{dd2}",
                "ව\u{dd2}ශ\u{dca}ව",
                "සදහටම",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("nekonečno"),
            keywords: &["navždy", "nekonečno", "večný"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("neskončnost"),
            keywords: &["neomejeno", "neskončnost", "univerzalno", "večno"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("xad la’aan"),
            keywords: &["aan xad lahayn", "abid", "guud ahaan", "xad la’aan"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("pafundësi"),
            keywords: &["pafundësi", "pakufi", "përgjithmonë", "universale"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("бесконачност"),
            keywords: &["безгранично", "бесконачност", "вечно", "универзално"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["бесконачност"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("beskonačnost"),
            keywords: &["beskonačnost", "bezgranično", "univerzalno", "večno"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["beskonačnost"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("oändlighet"),
            keywords: &["evig", "obegränsad", "oändlighet", "universal"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("milele"),
            keywords: &["bila kikomo", "kote", "milele"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("முடிவிலி"),
            keywords: &[
                "உலகள\u{bbe}வியது",
                "முடிவற\u{bcd}றது",
                "முடிவிலி",
                "வரம\u{bcd}பற\u{bcd}றது",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("అప\u{c3e}రత"),
            keywords: &[
                "అపర\u{c3f}మ\u{c3f}తం",
                "అప\u{c3e}రత",
                "శ\u{c3e}శ\u{c4d}వతం",
                "స\u{c3e}ర\u{c4d}వత\u{c4d}ర\u{c3f}కం",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ไม\u{e48}ม\u{e35}ท\u{e35}\u{e48}ส\u{e34}\u{e49}นส\u{e38}ด"),
            keywords: &[
                "ตลอดกาล",
                "ตลอดไป",
                "ไม\u{e48}ม\u{e35}ขอบเขต",
                "ไม\u{e48}ม\u{e35}ท\u{e35}\u{e48}ส\u{e34}\u{e49}นส\u{e38}ด",
            ],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ደረት ኣልቦነት"),
            keywords: &["ዓለም-ለኻዊ", "ደረት ኣልቦነት"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("tükeniksizlik"),
            keywords: &["baky", "tükeniksizlik", "uniwersal", "çäksiz"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("fakaʻilonga taʻengata mamafa"),
            keywords: &["fakaʻilonga", "fakaʻilonga taʻengata mamafa", "taʻengata"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("sonsuz"),
            keywords: &["evrensel", "sonsuz", "sonsuzluk", "sınırsız"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("нескінченність"),
            keywords: &[
                "безкінечність",
                "безкінченність",
                "вісімка",
                "нескінченність",
                "універсальність",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("لامحدود"),
            keywords: &["عالمگیر", "غیر محدود", "لامحدود", "ہمیشہ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("cheksizilik"),
            keywords: &[
                "abadiy",
                "cheksizilik",
                "cheksizlik",
                "cheksizlik belgisi",
                "doimiy",
                "muntazam",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("vô cực"),
            keywords: &["mãi mãi", "toàn cầu", "vô cực", "vô tận"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("無限"),
            keywords: &["世界", "永遠", "無限", "無限制"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("无限"),
            keywords: &["世界", "无限", "无限制", "永远"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("无穷大"),
            keywords: &["宇宙", "无尽", "无穷大", "极大"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("無限大"),
            keywords: &["全體", "永遠", "無限", "無限大"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("無限"),
            keywords: &["永遠", "無限"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ingunaphakade"),
            keywords: &["forever", "ingunaphakade", "unbounded", "universal"],
        },
    ],
};
