#[doc = "🔴"]
pub const RED_CIRCLE: crate::Emoji = crate::Emoji {
    glyph: "🔴",
    codepoint: "1F534",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "red circle",
    group: "Symbols",
    subgroup: "geometric",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("rooi sirkel"),
            keywords: &["geometries", "rooi", "sirkel"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ቀይ ክብ"),
            keywords: &["ቀይ", "ክብ", "ጂኦሜትሪያዊ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("دائرة حمراء"),
            keywords: &["أحمر", "دائرة", "دائرة حمراء", "دائرة حمراء كبيرة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ৰঙ\u{9be} ব\u{9c3}ত\u{9cd}ত"),
            keywords: &["জ\u{9cd}য\u{9be}মিতিক", "ব\u{9c3}ত\u{9cd}ত", "ৰঙ\u{9be}"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("qırmızı dairə"),
            keywords: &["dairə", "həndəsi", "qırmızı"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("чырвоны круг"),
            keywords: &["аб’ект", "геаметрычны", "круг", "чырвоны"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Червен кръг"),
            keywords: &["Червен кръг", "геометричен", "кръг", "червен"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ল\u{9be}ল ব\u{9c3}ত\u{9cd}ত"),
            keywords: &["জ\u{9cd}য\u{9be}মিতিক", "ব\u{9c3}ত\u{9cd}ত", "ল\u{9be}ল"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("crveni krug"),
            keywords: &["crveni krug", "crveno", "geometrija", "krug"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cercle vermell"),
            keywords: &["cercle", "geometria", "vermell"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎩᎦᎨ ᎦᏐᏆᎸ"),
            keywords: &["ᎤᏙᏢᏒ", "ᎦᏐᏆᎸ", "ᎩᎦᎨ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("červený kroužek"),
            keywords: &["geometrie", "kruh", "červená", "červený kroužek"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("cylch coch"),
            keywords: &["coch", "cylch", "geometrig"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("rød cirkel"),
            keywords: &["cirkel", "geometrisk", "rød"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("roter Punkt"),
            keywords: &["Ball", "Punkt", "rot", "roter Punkt"],
        },
        #[cfg(feature = "de_CH")]
        crate::Annotation {
            lang: "de_CH",
            tts: Some("Grosser roter Kreis"),
            keywords: &["Ball", "Grosser roter Kreis", "Kreis", "rot"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κόκκινος κύκλος"),
            keywords: &["γεωμετρικό", "κόκκινο", "κόκκινος κύκλος", "κύκλος"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("red circle"),
            keywords: &["circle", "geometric", "red"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("círculo rojo grande"),
            keywords: &["círculo", "círculo rojo grande", "geometría", "rojo"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("círculo rojo"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("punane ring"),
            keywords: &["geomeetria", "punane", "ring"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("zirkulu gorria"),
            keywords: &["geometriko", "gorri", "zirkulu", "zirkulu gorria"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("دایره قرمز"),
            keywords: &["دایره", "شکل هندسی", "قرمز"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("punainen ympyrä"),
            keywords: &["muoto", "punainen", "ympyrä"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("pulang bilog"),
            keywords: &["bilog", "hugis", "pula", "pulang bilog"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("reyður sirkul"),
            keywords: &["reytt", "reyður", "sirkul"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("disque rouge"),
            keywords: &[
                "cercle",
                "disque rouge",
                "forme géométrique",
                "géométrie",
                "rond",
                "rouge",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["cercle", "disque", "géométrie", "rond", "rouge", "sphère"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("ciorcal dearg"),
            keywords: &["ciorcal", "dearg", "geoiméadrach"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("cearcall dearg"),
            keywords: &["cearcall", "dearg", "geomatrach"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("círculo vermello"),
            keywords: &["círculo", "vermello"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("લાલ ગોળ"),
            keywords: &[
                "મોટ\u{ac1}\u{a82} લાલ વર\u{acd}ત\u{ac1}ળ",
                "મોટ\u{ac1}\u{a82} વર\u{acd}ત\u{ac1}ળ",
                "લાલ",
                "લાલ ગોળ",
                "વર\u{acd}ત\u{ac1}ળ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("jan da’ira"),
            keywords: &["da’ira", "ilimin halayen sura", "ja", "jan da’ira"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("עיגול אדום"),
            keywords: &["אדום", "עיגול", "צורה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("लाल व\u{943}त\u{94d}त"),
            keywords: &["ज\u{94d}यामिति", "लाल", "लाल व\u{943}त\u{94d}त"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("crveni krug"),
            keywords: &["crveni krug", "crveno", "geometrija", "krug"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("piros kör"),
            keywords: &["alakzat", "kör", "piros"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("կարմիր շրջան"),
            keywords: &["երկրաչափական", "կարմիր", "շրջան"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("lingkaran merah"),
            keywords: &["geometri", "lingkaran", "merah"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("okirikiri ọbara"),
            keywords: &["mgbakọ", "okirikiri", "ọbara"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("stór rauður hringur"),
            keywords: &["hringur", "rauður", "rúmfræði", "stór rauður hringur"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("cerchio rosso"),
            keywords: &["cerchio", "geometria", "rosso"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("赤い丸"),
            keywords: &["丸", "丸いボタン", "赤", "赤い丸"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("bunderan abang"),
            keywords: &["abang", "bunder", "bunderan abang", "geometrik"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("წითელი წრე"),
            keywords: &["გეომეტრია", "გეომეტრიული", "რგოლი", "წითელი", "წრე"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("қызыл дөңгелек"),
            keywords: &["геометриялық", "шеңбер", "қызыл", "қызыл дөңгелек"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("rød cirkel"),
            keywords: &["cirkel", "geometrisk", "rød"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("រង\u{17d2}វង\u{17cb}ពណ\u{17cc}ក\u{17d2}រហម"),
            keywords: &[
                "ក\u{17d2}រហម",
                "ធរណ\u{17b8}មាត\u{17d2}រ",
                "រង\u{17d2}វង\u{17cb}",
                "រង\u{17d2}វង\u{17cb}ពណ\u{17cc}ក\u{17d2}រហម",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕ\u{cc6}ಂಪು ವೃತ\u{ccd}ತ"),
            keywords: &[
                "ಕ\u{cc6}ಂಪು ವೃತ\u{ccd}ತ",
                "ದೊಡ\u{ccd}ಡ ಕ\u{cc6}ಂಪು ವೃತ\u{ccd}ತ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("빨간 원"),
            keywords: &["빨간 원", "빨강", "원", "큰 빨간 원"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("ता\u{902}बड\u{947}\u{902} वर\u{94d}त\u{941}ळ"),
            keywords: &[
                "जियोम\u{945}ट\u{94d}रीक",
                "ता\u{902}बड\u{947}\u{902}",
                "वर\u{94d}त\u{941}ळ",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("кызыл тегерек"),
            keywords: &["геометрия", "кызыл", "тегерек"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("roude Krees"),
            keywords: &["Krees", "geometresch", "roude Krees", "rout"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ວ\u{ebb}ງມ\u{ebb}ນແດງ"),
            keywords: &["ວ\u{ebb}ງມ\u{ebb}ນ", "ວ\u{ebb}ງມ\u{ebb}ນແດງ", "ສ\u{eb5}ແດງ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("raudonas apskritimas"),
            keywords: &["apskritimas", "geometrija", "raudonas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("sarkans aplis"),
            keywords: &["aplis", "sarkans aplis", "ģeometrija"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("porohita whero"),
            keywords: &["porohita", "whero", "āhuahanga"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("црвен круг"),
            keywords: &["геометрија", "круг", "црвен"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ച\u{d41}വന\u{d4d}ന വ\u{d43}ത\u{d4d}തം"),
            keywords: &[
                "ച\u{d41}വന\u{d4d}ന വ\u{d43}ത\u{d4d}തം",
                "ച\u{d41}വപ\u{d4d}പ\u{d4d}",
                "ജ\u{d4d}യ\u{d3e}മിതീയമ\u{d3e}യത\u{d4d}",
                "വലിയ ച\u{d41}വന\u{d4d}ന വ\u{d43}ത\u{d4d}തം",
                "വ\u{d43}ത\u{d4d}തം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("улаан тойрог"),
            keywords: &["геометр", "тойрог", "улаан"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("लाल वर\u{94d}त\u{941}ळ"),
            keywords: &["भ\u{942}मितीय", "लाल", "वर\u{94d}त\u{941}ळ"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("bulatan merah"),
            keywords: &["bulatan", "geometri", "merah"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("ċirku aħmar"),
            keywords: &["aħmar", "ċirku", "ġeometriku"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အန\u{102e}ရောင\u{103a} စက\u{103a}ဝ\u{102d}\u{102f}င\u{103a}း"),
            keywords: &[
                "ဂျ\u{102e}သြမေတြ\u{102e}",
                "အန\u{102e}ရောင\u{103a} စက\u{103a}ဝ\u{102d}\u{102f}င\u{103a}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("rød sirkel"),
            keywords: &["geometrisk", "rød", "sirkel"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("रातो घ\u{947}रा"),
            keywords: &["घ\u{947}रा", "ज\u{94d}यामितीय", "रातो"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("rode cirkel"),
            keywords: &["cirkel", "geometrisch", "rode cirkel", "rood"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("raud sirkel"),
            keywords: &["geometrisk", "raud", "sirkel"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଲ\u{b3e}ଲ ବ\u{b43}ତ\u{b4d}ତ"),
            keywords: &[
                "ଜ\u{b4d}ୟ\u{b3e}ମ\u{b3f}ତ\u{b3f}କ",
                "ବ\u{b43}ତ\u{b4d}ତ",
                "ଲ\u{b3e}ଲ ବ\u{b43}ତ\u{b4d}ତ",
                "ଲ\u{b3e}ଲ\u{b4d}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਲਾਲ ਗ\u{a4b}ਲਾ"),
            keywords: &["ਗ\u{a4b}ਲਾ", "ਘ\u{a47}ਰਾ", "ਜਯਾਮਿਤੀ", "ਲਾਲ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("لال چکر"),
            keywords: &["جیومیٹری دے متعلق", "دائرہ", "لال", "لال چکر"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Rẹ\u{301}d Sẹ\u{301}kul"),
            keywords: &[
                "Jiọ\u{301}mẹ\u{301}tri",
                "Rẹd",
                "Rẹ\u{301}d Sẹ\u{301}kul",
                "Sẹ\u{301}kul",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("czerwone koło"),
            keywords: &["czerwone", "figura geometryczna", "koło", "kółko"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("سره دايره"),
            keywords: &["جيوميتريکي", "دايره", "سره"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("círculo vermelho"),
            keywords: &["círculo", "geométrico", "vermelho"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["círculo", "geométrico", "vermelho"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("cerc roșu"),
            keywords: &["cerc", "geometric", "roșu"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-752"),
            keywords: &["E10-752"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("красный круг"),
            keywords: &["геометрия", "красный", "круг", "фигура", "шар"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("uruziga rutukura"),
            keywords: &[
                "byerekeye jewometiri",
                "umutuku",
                "uruziga",
                "uruziga rutukura",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڳاڙهو دائرو"),
            keywords: &["جيوميٽرڪ", "دائرو", "ڳاڙهو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("රත\u{dd4} රව\u{dd4}ම"),
            keywords: &[
                "ජ\u{dca}\u{200d}ය\u{dcf}ම\u{dd2}ත\u{dd2}ක",
                "රත\u{dd4}",
                "රව\u{dd4}ම",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("červený kruh"),
            keywords: &["geometria", "kruh", "červený"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("rdeč krog"),
            keywords: &["geometrično", "krog", "rdeč krog", "rdeče"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("goobada cas"),
            keywords: &["cas", "goobada cas", "goobo", "joometriyeed"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("rreth i kuq"),
            keywords: &["gjeometrik", "i kuq", "rreth", "rreth i kuq"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("црвени круг"),
            keywords: &["геометријски", "круг", "црвени круг", "црвено"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["црвени круг"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("crveni krug"),
            keywords: &["crveni krug", "crveno", "geometrijski", "krug"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["crveni krug"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("röd cirkel"),
            keywords: &["cirkel", "geometrisk", "röd"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mduara mwekundu"),
            keywords: &["jiometri", "mduara", "mduara mwekundu", "nyekundu"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("சிவப\u{bcd}பு வட\u{bcd}டம\u{bcd}"),
            keywords: &[
                "சிவப\u{bcd}பு வட\u{bcd}டம\u{bcd}",
                "ரெட\u{bcd} சர\u{bcd}க\u{bcd}கிள\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ప\u{c46}ద\u{c4d}ద ఎరుపు రంగు వృత\u{c4d}తం"),
            keywords: &[
                "ఎరుపు రంగు",
                "ప\u{c46}ద\u{c4d}ద ఎరుపు రంగు వృత\u{c4d}తం",
                "వృత\u{c4d}తం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("доираи сурх"),
            keywords: &["геометрӣ", "доира", "доираи сурх", "сурх"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("วงกลมส\u{e35}แดง"),
            keywords: &["วงกลม", "วงกลมส\u{e35}แดง", "แดง"],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ቀይሕ ዓንኬል"),
            keywords: &["ቀይሕ", "ዓንኬል", "ጂኦሜትሪክ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("gyzyl halka"),
            keywords: &["geometrik", "gyzyl", "halka"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("fuopotopoto kulokula"),
            keywords: &["fuopotopoto", "kulokula"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("kırmızı daire"),
            keywords: &["büyük kırmızı çember", "kırmızı", "kırmızı daire", "çember"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("قىزىل چەمبەر"),
            keywords: &["قىزىل", "چەمبەر", "گېئومېتىرىيە"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("червоний круг"),
            keywords: &["геометричний", "коло", "червоне", "червоний круг"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("سرخ دائرہ"),
            keywords: &["جیومیٹری", "دائرہ", "سرخ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("qizil doira"),
            keywords: &["aylana", "geometriya", "qizil", "qizil doira"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("hình tròn màu đỏ"),
            keywords: &["hình học", "hình tròn", "hình tròn màu đỏ", "đỏ"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("serkal xonk"),
            keywords: &["serkal", "wu-geometri", "xonk"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("isangqa esibomvu"),
            keywords: &["bomvu", "ijiyometriki", "isangqa", "isangqa esibomvu"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Rogodo Aláwọ\u{300} pupa"),
            keywords: &[
                "Rogodo",
                "Rogodo Aláwọ\u{300} pupa",
                "jiomẹ\u{301}tíríkì",
                "pupa",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("紅色圓形"),
            keywords: &["圓形", "幾何", "紅色", "紅色圓形"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("红色圆形"),
            keywords: &["几何", "圆形", "红色", "红色圆形"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("红色圆"),
            keywords: &["圆", "圈", "红", "红色", "红色圆"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("大紅色圓形"),
            keywords: &["圓形", "大紅色圓形"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("紅色大圓圈"),
            keywords: &["圓圈", "紅色", "紅色大圓圈"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("indingilizi ebomvu"),
            keywords: &["bomvu", "indingilizi", "indingilizi ebomvu", "jiyometrikhi"],
        },
    ],
};
#[doc = "🟠"]
pub const ORANGE_CIRCLE: crate::Emoji = crate::Emoji {
    glyph: "🟠",
    codepoint: "1F7E0",
    status: crate::Status::FullyQualified,
    introduction_version: 12f32,
    name: "orange circle",
    group: "Symbols",
    subgroup: "geometric",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("oranje sirkel"),
            keywords: &["oranje", "sirkel"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ብርቱካን ክብ"),
            keywords: &["ብርቱካን", "ክብ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("دائرة برتقالية"),
            keywords: &["برتقالي", "دائرة", "دائرة برتقالية"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("কমল\u{9be}ৰঙী ব\u{9c3}ত\u{9cd}ত"),
            keywords: &[
                "কমল\u{9be}",
                "কমল\u{9be}ৰঙী ব\u{9c3}ত\u{9cd}ত",
                "ব\u{9c3}ত\u{9cd}ত",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("narıncı çevrə"),
            keywords: &["narıncı", "çevrə"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("аранжавы круг"),
            keywords: &["аранжавы", "круг"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("оранжев кръг"),
            keywords: &["кръг", "оранжев кръг", "оранжево"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("কমল\u{9be} ব\u{9c3}ত\u{9cd}ত"),
            keywords: &["কমল\u{9be}", "ব\u{9c3}ত\u{9cd}ত"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("narandžasti krug"),
            keywords: &["krug", "narandžasta", "narandžasti krug"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cercle taronja"),
            keywords: &["cercle", "taronja"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏓᎶᏂᎨ ᎦᏐᏆᎸ"),
            keywords: &["ᎠᏓᎶᏂᎨ", "ᎦᏐᏆᎸ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("oranžový kroužek"),
            keywords: &["kolečko", "kroužek", "kruh", "oranžová", "oranžový kroužek"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("cylch oren"),
            keywords: &["cylch", "oren"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("orange cirkel"),
            keywords: &["orange cirkel"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("oranger Punkt"),
            keywords: &["Punkt", "orange", "oranger Punkt"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("πορτοκαλί κύκλος"),
            keywords: &["κύκλος", "πορτοκαλί"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("orange circle"),
            keywords: &["circle", "orange"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("círculo naranja"),
            keywords: &["círculo", "naranja"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("oranž ring"),
            keywords: &["kera", "oranž", "ring"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("zirkulu laranja"),
            keywords: &["laranja", "zirkulu"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("دایره نارنجی"),
            keywords: &["دایره", "نارنجی"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("oranssi ympyrä"),
            keywords: &["oranssi", "ympyrä"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("orange na bilog"),
            keywords: &["bilog", "orange", "orange na bilog"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("appilsingulur sirkul"),
            keywords: &["appilsingult", "appilsingulur", "sirkul"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("disque orange"),
            keywords: &[
                "cercle",
                "disque orange",
                "forme géométrique",
                "géométrie",
                "orange",
                "rond",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("cercle orange"),
            keywords: &["cercle", "disque", "géométrie", "orange", "rond", "sphère"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("ciorcal flannbhuí"),
            keywords: &["ciorcal", "flannbhuí", "oráiste"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("cearcall orainds"),
            keywords: &["cearcall", "orainds", "orains"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("círculo laranxa"),
            keywords: &["círculo", "laranxa"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("નાર\u{a82}ગી વર\u{acd}ત\u{ac1}ળ"),
            keywords: &["નાર\u{a82}ગી", "વર\u{acd}ત\u{ac1}ળ"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("עיגול כתום"),
            keywords: &["כתום", "מעגל", "עיגול"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("नार\u{902}गी र\u{902}ग का व\u{943}त\u{94d}त"),
            keywords: &[
                "आक\u{943}ति",
                "ग\u{947}\u{902}द",
                "गोला",
                "नार\u{902}गी",
                "नार\u{902}गी र\u{902}ग का व\u{943}त\u{94d}त",
                "व\u{943}त\u{94d}त",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("narančasti krug"),
            keywords: &["krug", "narančasti"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("narancssárga kör"),
            keywords: &["kör", "narancssárga"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("նարնջագույն շրջան"),
            keywords: &["նարնջագույն", "շրջան"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("lingkaran oranye"),
            keywords: &["lingkaran", "oranye"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("appelsínugulur hringur"),
            keywords: &["appelsínugulur", "hringur"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("cerchio arancione"),
            keywords: &["cerchio", "cerchio arancio", "cerchio arancione"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("オレンジの丸"),
            keywords: &["オレンジ", "オレンジの丸", "丸", "丸いボタン"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("bunderan kunir"),
            keywords: &["bunder", "bunderan kunir", "kunir"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ნარინჯისფერი წრე"),
            keywords: &["ნარინჯისფერი", "წრე"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("қызғылт сары дөңгелек"),
            keywords: &["дөңгелек", "қызғылт сары", "қызғылт сары дөңгелек"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("រង\u{17d2}វង\u{17cb}ពណ\u{17cc}ទ\u{17b9}កក\u{17d2}រ\u{17bc}ច"),
            keywords: &[
                "ពណ\u{17cc}ទ\u{17b9}កក\u{17d2}រ\u{17bc}ច",
                "រង\u{17d2}វង\u{17cb}",
                "រង\u{17d2}វង\u{17cb}ពណ\u{17cc}ទ\u{17b9}កក\u{17d2}រ\u{17bc}ច",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕ\u{cbf}ತ\u{ccd}ತಳ\u{cc6}ಬಣ\u{ccd}ಣದ ವೃತ\u{ccd}ತ"),
            keywords: &[
                "ಕ\u{cbf}ತ\u{ccd}ತಳ\u{cc6}",
                "ಕ\u{cbf}ತ\u{ccd}ತಳ\u{cc6}ಬಣ\u{ccd}ಣದ ವೃತ\u{ccd}ತ",
                "ವೃತ\u{ccd}ತ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("오렌지색 원"),
            keywords: &["오렌지색", "원"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("लारा\u{902}जी वर\u{94d}त\u{941}ळ"),
            keywords: &[
                "नार\u{902}गी",
                "लारा\u{902}जी वर\u{94d}त\u{941}ळ",
                "वर\u{94d}त\u{941}ळ",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("кызгылт сары айлана"),
            keywords: &["айлана", "кызгылт сары", "кызгылт сары айлана"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ວ\u{ebb}ງ\u{200b}ມ\u{ebb}ນ\u{200b}ສ\u{ebb}\u{ec9}ມ"),
            keywords: &[
                "ວ\u{ebb}ງ\u{200b}ມ\u{ebb}ນ",
                "ວ\u{ebb}ງ\u{200b}ມ\u{ebb}ນ\u{200b}ສ\u{ebb}\u{ec9}ມ",
                "ສ\u{eb5}\u{200b}ສ\u{ebb}\u{ec9}ມ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("oranžinis apskritimas"),
            keywords: &["apskritimas", "oranžinis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("oranžs aplis"),
            keywords: &["aplis", "oranžs"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("портокалов круг"),
            keywords: &["круг", "портокалов"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഓറഞ\u{d4d}ച\u{d4d} വ\u{d43}ത\u{d4d}തം"),
            keywords: &["ഓറഞ\u{d4d}ച\u{d4d}", "വ\u{d43}ത\u{d4d}തം"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("улбар шар тойрог"),
            keywords: &["тойрог", "улбар шар", "улбар шар тойрог"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("नारि\u{902}गी वर\u{94d}त\u{941}ळ"),
            keywords: &[
                "नारि\u{902}ग",
                "नारि\u{902}गी वर\u{94d}त\u{941}ळ",
                "वर\u{94d}त\u{941}ळ",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("bulatan jingga"),
            keywords: &["bulatan", "jingga"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "လ\u{102d}မ\u{1039}မော\u{103a}ရောင\u{103a} စက\u{103a}ဝ\u{102d}\u{102f}င\u{103a}း",
            ),
            keywords: &[
                "စက\u{103a}ဝ\u{102d}\u{102f}င\u{103a}း",
                "လ\u{102d}မ\u{1039}မော\u{103a}ရောင\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("oransje sirkel"),
            keywords: &["oransje", "sirkel"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("स\u{941}न\u{94d}तला व\u{943}त\u{94d}त"),
            keywords: &["व\u{943}त\u{94d}त", "स\u{941}न\u{94d}तला"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("oranje cirkel"),
            keywords: &["cirkel", "oranje"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("oransje sirkel"),
            keywords: &["oransje", "sirkel"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("କମଳ\u{b3e} ବ\u{b43}ତ\u{b4d}ତ"),
            keywords: &["କମଳ\u{b3e}", "ବ\u{b43}ତ\u{b4d}ତ"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਸ\u{a70}ਤਰੀ ਗ\u{a4b}ਲਾ"),
            keywords: &["ਗ\u{a4b}ਲਾ", "ਸ\u{a70}ਤਰੀ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Ọ\u{301}rénj Kọ\u{301}lọ Sẹ\u{301}kul"),
            keywords: &[
                "Sẹ\u{301}kul",
                "Ọ\u{301}rénj Kọ\u{301}lọ",
                "Ọ\u{301}rénj Kọ\u{301}lọ Sẹ\u{301}kul",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("pomarańczowe koło"),
            keywords: &["koło", "kółko", "pomarańczowe"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("نارنجي دايره"),
            keywords: &["دايره", "نارنجي"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("círculo laranja"),
            keywords: &["círculo", "laranja"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("círculo cor de laranja"),
            keywords: &["cor de laranja", "círculo", "círculo cor de laranja"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("cerc portocaliu"),
            keywords: &["cerc", "portocaliu"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E12–010"),
            keywords: &["E12–010"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("оранжевый круг"),
            keywords: &["геометрия", "круг", "оранжевый", "фигура", "шар"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("نارنگي دائرو"),
            keywords: &["دائرو", "نارنگي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("තැඹ\u{dd2}ල\u{dd2} රව\u{dd4}ම"),
            keywords: &["තැඹ\u{dd2}ල\u{dd2}", "රව\u{dd4}ම"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("oranžový kruh"),
            keywords: &["koliesko", "kruh", "krúžok", "oranžová", "oranžový kruh"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("oranžen krog"),
            keywords: &["krog", "oranžen"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("goobada oranjiga ah"),
            keywords: &["goobada oranjiga ah", "goobo", "oranji"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("rreth i portokalltë"),
            keywords: &[
                "gjeometrik",
                "i portokalltë",
                "rreth",
                "rreth i portokalltë",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("наранџаст круг"),
            keywords: &["круг", "наранџаст круг", "наранџасто"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["наранџаст круг"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("narandžast krug"),
            keywords: &["krug", "narandžast krug", "narandžasto"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["narandžast krug"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("orange cirkel"),
            keywords: &["cirkel", "orange"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mduara wa chungwa"),
            keywords: &["chungwa", "mduara", "mduara wa chungwa"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ஆரஞ\u{bcd}சு வட\u{bcd}டம\u{bcd}"),
            keywords: &["ஆரஞ\u{bcd}சு", "வட\u{bcd}டம\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("న\u{c3e}ర\u{c3f}ంజరంగు వృత\u{c4d}తం"),
            keywords: &["న\u{c3e}ర\u{c3f}ంజరంగు", "వృత\u{c4d}తం"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("วงกลมส\u{e35}ส\u{e49}ม"),
            keywords: &["วงกลม", "วงกลมส\u{e35}ส\u{e49}ม", "ส\u{e35}ส\u{e49}ม"],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ኣራንሾኒ ዓንኬል"),
            keywords: &["ኣራንሾኒ", "ዓንኬል"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("narynç tegelek"),
            keywords: &["narynç", "tegelek"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("fuopotopoto lanumoli"),
            keywords: &["fuopotopoto", "lanumoli"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("turuncu daire"),
            keywords: &["daire", "turuncu"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("оранжевий круг"),
            keywords: &["круг", "оранжевий"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("نارنجی دائرہ"),
            keywords: &["دائرہ", "نارنجی"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("sabzirang doira"),
            keywords: &["doira", "sabzirang doira", "sariq"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("hình tròn màu cam"),
            keywords: &[
                "da cam",
                "hình tròn",
                "hình tròn màu cam",
                "màu cam",
                "vòng tròn",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("橙色圓形"),
            keywords: &["圓形", "橙色", "橙色圓形"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("橙色圆形"),
            keywords: &["圆形", "橙色", "橙色圆形"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("橙色圆"),
            keywords: &["圆", "圈", "橙", "橙色圆"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("橘色圓形"),
            keywords: &["圓形", "橘色", "橘色圓形"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("橙色圓形"),
            keywords: &["圓形", "橙色", "橙色圓形"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("isikokela esi-orintshi"),
            keywords: &["isikokela", "isikokela esi-orintshi"],
        },
    ],
};
#[doc = "🟡"]
pub const YELLOW_CIRCLE: crate::Emoji = crate::Emoji {
    glyph: "🟡",
    codepoint: "1F7E1",
    status: crate::Status::FullyQualified,
    introduction_version: 12f32,
    name: "yellow circle",
    group: "Symbols",
    subgroup: "geometric",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("geel sirkel"),
            keywords: &["geel", "sirkel"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ቢጫ ክብ"),
            keywords: &["ቢጫ", "ክብ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("دائرة صفراء"),
            keywords: &["أصفر", "دائرة", "دائرة صفراء"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("হ\u{9be}লধীয\u{9bc}\u{9be} ব\u{9c3}ত\u{9cd}ত"),
            keywords: &["ব\u{9c3}ত\u{9cd}ত", "হ\u{9be}লধীয\u{9bc}\u{9be}"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("sarı çevrə"),
            keywords: &["sarı", "çevrə"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("жоўты круг"),
            keywords: &["жоўты", "круг"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("жълт кръг"),
            keywords: &["жълт кръг", "жълто", "кръг"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("হদ\u{9c1}ল ব\u{9c3}ত\u{9cd}ত"),
            keywords: &[
                "ব\u{9c3}ত\u{9cd}ত",
                "হদ\u{9c1}ল ব\u{9c3}ত\u{9cd}ত",
                "হল\u{9c1}দ",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("žuti krug"),
            keywords: &["krug", "žuta", "žuti krug"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cercle groc"),
            keywords: &["cercle", "groc"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏓᎶᏂᎨ ᎦᏐᏆᎸ"),
            keywords: &["ᎦᏐᏆᎸ", "ᏓᎶᏂᎨ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("žlutý kroužek"),
            keywords: &["kolečko", "kroužek", "kruh", "žlutá", "žlutý kroužek"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("cylch melyn"),
            keywords: &["cylch", "melyn"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("gul cirkel"),
            keywords: &["gul cirkel"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("gelber Punkt"),
            keywords: &["Punkt", "gelb", "gelber Punkt"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κίτρινος κύκλος"),
            keywords: &["κίτρινος", "κύκλος"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("yellow circle"),
            keywords: &["circle", "yellow"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("círculo amarillo"),
            keywords: &["amarillo", "círculo"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kollane ring"),
            keywords: &["kera", "kollane", "ring"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("zirkulu horia"),
            keywords: &["hori", "zirkulu", "zirkulu horia"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("دایره زرد"),
            keywords: &["دایره", "زرد"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("keltainen ympyrä"),
            keywords: &["keltainen", "ympyrä"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("dilaw na bilog"),
            keywords: &["bilog", "dilaw", "dilaw na bilog"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("gulur sirkul"),
            keywords: &["gult", "gulur", "sirkul"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("disque jaune"),
            keywords: &[
                "cercle",
                "disque jaune",
                "forme géométrique",
                "géométrie",
                "jaune",
                "rond",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("cercle jaune"),
            keywords: &["cercle", "disque", "géométrie", "jaune", "rond", "sphère"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("ciorcal buí"),
            keywords: &["buí", "ciorcal"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("cearcall buidhe"),
            keywords: &["buidhe", "cearcall"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("círculo amarelo"),
            keywords: &["amarelo", "círculo"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("પીળા ર\u{a82}ગન\u{ac1}\u{a82} વર\u{acd}ત\u{ac1}ળ"),
            keywords: &[
                "પીળા ર\u{a82}ગન\u{ac1}\u{a82}",
                "પીળા ર\u{a82}ગન\u{ac1}\u{a82} વર\u{acd}ત\u{ac1}ળ",
                "વર\u{acd}ત\u{ac1}ળ",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("עיגול צהוב"),
            keywords: &["מעגל", "עיגול", "צהוב"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("पीला व\u{943}त\u{94d}त"),
            keywords: &[
                "आक\u{943}ति",
                "ग\u{947}\u{902}द",
                "गोला",
                "पीला",
                "पीली",
                "व\u{943}त\u{94d}त",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("žuti krug"),
            keywords: &["krug", "žuti"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("sárga kör"),
            keywords: &["kör", "sárga"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("դեղին շրջան"),
            keywords: &["դեղին", "շրջան"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("lingkaran kuning"),
            keywords: &["kuning", "lingkaran"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("gulur hringur"),
            keywords: &["gulur", "hringur"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("cerchio giallo"),
            keywords: &["cerchio", "cerchio di colore giallo", "cerchio giallo"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("黄色い丸"),
            keywords: &["丸", "丸いボタン", "黄色", "黄色い丸"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("bunderan kuning"),
            keywords: &["bunder", "bunderan kuning", "kuning"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ყვითელი წრე"),
            keywords: &["ყვითელი", "წრე"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("сары дөңгелек"),
            keywords: &["дөңгелек", "сары"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("រង\u{17d2}វង\u{17cb}ពណ\u{17cc}លឿង"),
            keywords: &[
                "ពណ\u{17cc}លឿង",
                "រង\u{17d2}វង\u{17cb}",
                "រង\u{17d2}វង\u{17cb}ពណ\u{17cc}លឿង",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಹಳದ\u{cbf} ವೃತ\u{ccd}ತ"),
            keywords: &["ವೃತ\u{ccd}ತ", "ಹಳದ\u{cbf}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("노란색 원"),
            keywords: &["노란색", "원"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("हळद\u{941}व\u{947}\u{902} वर\u{94d}त\u{941}ळ"),
            keywords: &["वर\u{94d}त\u{941}ळ", "हळद\u{941}व\u{947}\u{902}"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("сары айлана"),
            keywords: &["айлана", "сары"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ວ\u{ebb}ງ\u{200b}ມ\u{ebb}ນ\u{200b}ເຫ\u{ebc}\u{eb7}ອງ"),
            keywords: &[
                "ວ\u{ebb}ງ\u{200b}ມ\u{ebb}ນ",
                "ວ\u{ebb}ງ\u{200b}ມ\u{ebb}ນ\u{200b}ເຫ\u{ebc}\u{eb7}ອງ",
                "ສ\u{eb5}\u{200b}ເຫ\u{ebc}\u{eb7}ອງ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("geltonas apskritimas"),
            keywords: &["apskritimas", "geltonas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("dzeltens aplis"),
            keywords: &["aplis", "dzeltens"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("жолт круг"),
            keywords: &["жолт", "круг"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("മഞ\u{d4d}ഞ വ\u{d43}ത\u{d4d}തം"),
            keywords: &["മഞ\u{d4d}ഞ", "വ\u{d43}ത\u{d4d}തം"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("шар тойрог"),
            keywords: &["тойрог", "шар"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("पिवळ\u{947} वर\u{94d}त\u{941}ळ"),
            keywords: &["पिवळ\u{947}", "वर\u{94d}त\u{941}ळ"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("bulatan kuning"),
            keywords: &["bulatan", "kuning"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အဝါရောင\u{103a} စက\u{103a}ဝ\u{102d}\u{102f}င\u{103a}း"),
            keywords: &["စက\u{103a}ဝ\u{102d}\u{102f}င\u{103a}း", "အဝါရောင\u{103a}"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("gul sirkel"),
            keywords: &["gul", "sirkel"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("पह\u{947}\u{901}लो व\u{943}त\u{94d}त"),
            keywords: &["पह\u{947}\u{901}लो", "व\u{943}त\u{94d}त"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("gele cirkel"),
            keywords: &["cirkel", "geel", "gele cirkel"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("gul sirkel"),
            keywords: &["gul", "sirkel"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ହଳଦ\u{b3f}ଆ ବ\u{b43}ତ\u{b4d}ତ"),
            keywords: &["ବ\u{b43}ତ\u{b4d}ତ", "ହଳଦ\u{b3f}ଆ"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਪੀਲਾ ਗ\u{a4b}ਲਾ"),
            keywords: &["ਗ\u{a4b}ਲਾ", "ਪੀਲਾ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Yẹ\u{301}ló Sẹ\u{301}kul"),
            keywords: &["Sẹ\u{301}kul", "Yẹ\u{301}ló"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("żółte koło"),
            keywords: &["koło", "kółko", "żółte"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("زېړه دايره"),
            keywords: &["دايره", "زېړه"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("círculo amarelo"),
            keywords: &["amarelo", "círculo"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("cerc galben"),
            keywords: &["cerc", "galben"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E12–011"),
            keywords: &["E12–011"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("желтый круг"),
            keywords: &["геометрия", "желтый", "круг", "фигура", "шар"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("پيلو دائرو"),
            keywords: &["دائرو", "پيلو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("කහ රව\u{dd4}ම"),
            keywords: &["කහ", "රව\u{dd4}ම"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("žltý kruh"),
            keywords: &["koliesko", "kruh", "krúžok", "žltá", "žltý kruh"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("rumen krog"),
            keywords: &["krog", "rumen"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("goobada jaallaha ah"),
            keywords: &["goobada jaallaha ah", "goobo", "jaalle"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("rreth i verdhë"),
            keywords: &["gjeometri", "i verdhë", "rreth", "rreth i verdhë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("жут круг"),
            keywords: &["жут круг", "жуто", "круг"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["жут круг"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("žut krug"),
            keywords: &["krug", "žut krug", "žuto"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["žut krug"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("gul cirkel"),
            keywords: &["cirkel", "gul"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mduara wa manjano"),
            keywords: &["manjano", "mduara", "mduara wa manjano"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("மஞ\u{bcd}சள\u{bcd} வட\u{bcd}டம\u{bcd}"),
            keywords: &["மஞ\u{bcd}சள\u{bcd}", "வட\u{bcd}டம\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("పసుపురంగు వృత\u{c4d}తం"),
            keywords: &["పసుపురంగు", "వృత\u{c4d}తం"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("วงกลมส\u{e35}เหล\u{e37}อง"),
            keywords: &["วงกลม", "วงกลมส\u{e35}เหล\u{e37}อง", "ส\u{e35}เหล\u{e37}อง"],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ቢጫ ዓንኬል"),
            keywords: &["ቢጫ", "ዓንኬል"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("sary tegelek"),
            keywords: &["sary", "tegelek"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("fuopotopoto engeenga"),
            keywords: &["engeenga", "fuopotopoto"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("sarı daire"),
            keywords: &["daire", "sarı"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("жовтий круг"),
            keywords: &["жовтий", "круг"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("پیلا دائرہ"),
            keywords: &["دائرہ", "پیلا"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("sariq doira"),
            keywords: &["aylana", "doira", "sariq"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("hình tròn màu vàng"),
            keywords: &["hình tròn", "hình tròn màu vàng", "màu vàng", "vòng tròn"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("黃色圓形"),
            keywords: &["圓形", "黃色", "黃色圓形"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("黄色圆形"),
            keywords: &["圆形", "黄色", "黄色圆形"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("黄色圆"),
            keywords: &["圆", "圈", "黄", "黄色圆"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("黃色圓形"),
            keywords: &["圓形", "黃色", "黃色圓形"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("isikokela esiphuzi"),
            keywords: &["isikokela esiphuzi"],
        },
    ],
};
#[doc = "🟢"]
pub const GREEN_CIRCLE: crate::Emoji = crate::Emoji {
    glyph: "🟢",
    codepoint: "1F7E2",
    status: crate::Status::FullyQualified,
    introduction_version: 12f32,
    name: "green circle",
    group: "Symbols",
    subgroup: "geometric",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("groen sirkel"),
            keywords: &["groen", "sirkel"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("አረንጓዴ ክብ"),
            keywords: &["አረንጓዴ", "ክብ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("دائرة خضراء"),
            keywords: &["أخضر", "دائرة", "دائرة خضراء"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("সেউজীয\u{9bc}\u{9be} ব\u{9c3}ত\u{9cd}ত"),
            keywords: &["ব\u{9c3}ত\u{9cd}ত", "সেউজীয\u{9bc}\u{9be}"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("yaşıl çevrə"),
            keywords: &["yaşıl", "çevrə"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("зялёны круг"),
            keywords: &["зялёны", "круг"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("зелен кръг"),
            keywords: &["зелен кръг", "зелено", "кръг"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("সব\u{9c1}জ ব\u{9c3}ত\u{9cd}ত"),
            keywords: &["ব\u{9c3}ত\u{9cd}ত", "সব\u{9c1}জ"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("zeleni krug"),
            keywords: &["krug", "zelena", "zeleni krug"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cercle verd"),
            keywords: &["cercle", "verd"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎢᏤ ᎢᏳᏍᏗ ᎦᏐᏆᎸ"),
            keywords: &["ᎢᏤ ᎢᏳᏍᏗ", "ᎢᏤ ᎢᏳᏍᏗ ᎦᏐᏆᎸ", "ᎦᏐᏆᎸ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("zelený kroužek"),
            keywords: &["kolečko", "kroužek", "kruh", "zelená", "zelený kroužek"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("cylch gwyrdd"),
            keywords: &["cylch", "gwyrdd"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("grøn cirkel"),
            keywords: &["grøn cirkel"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("grüner Punkt"),
            keywords: &["Punkt", "grün", "grüner Punkt"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("πράσινος κύκλος"),
            keywords: &["κύκλος", "πράσινος"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("green circle"),
            keywords: &["circle", "green"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("círculo verde"),
            keywords: &["círculo", "verde"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("roheline ring"),
            keywords: &["kera", "ring", "roheline"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("zirkulu berdea"),
            keywords: &["berde", "zirkulu", "zirkulu berdea"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("دایره سبز"),
            keywords: &["دایره", "سبز"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("vihreä ympyrä"),
            keywords: &["vihreä", "ympyrä"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("berdeng bilog"),
            keywords: &["berde", "berdeng bilog", "bilog"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("grønur sirkul"),
            keywords: &["grønt", "grønur", "sirkul"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("disque vert"),
            keywords: &[
                "cercle",
                "disque vert",
                "forme géométrique",
                "géométrie",
                "rond",
                "vert",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("cercle vert"),
            keywords: &[
                "cercle",
                "cercle vert",
                "disque",
                "géométrie",
                "jaune",
                "rond",
                "sphère",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("ciorcal glas"),
            keywords: &["ciorcal", "glas"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("cearcall uaine"),
            keywords: &["cearcall", "uaine"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("círculo verde"),
            keywords: &["círculo", "verde"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("લીલા ર\u{a82}ગન\u{ac1}\u{a82} વર\u{acd}ત\u{ac1}ળ"),
            keywords: &[
                "લીલા ર\u{a82}ગન\u{ac1}\u{a82} વર\u{acd}ત\u{ac1}ળ",
                "લીલ\u{ac1}\u{a82}",
                "વર\u{acd}ત\u{ac1}ળ",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("עיגול ירוק"),
            keywords: &["ירוק", "מעגל", "עיגול"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("हरा व\u{943}त\u{94d}त"),
            keywords: &[
                "आक\u{943}ति",
                "ग\u{947}\u{902}द",
                "गोला",
                "व\u{943}त\u{94d}त",
                "हरा",
                "हरी",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("zeleni krug"),
            keywords: &["krug", "zeleni"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("zöld kör"),
            keywords: &["kör", "zöld"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("կանաչ շրջան"),
            keywords: &["կանաչ", "շրջան"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("lingkaran hijau"),
            keywords: &["hijau", "lingkaran"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("grænn hringur"),
            keywords: &["grænn", "hringur"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("cerchio verde"),
            keywords: &["cerchio", "cerchio di colore verde", "cerchio verde"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("緑の丸"),
            keywords: &["丸", "丸いボタン", "緑", "緑の丸"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("bunderan ijo"),
            keywords: &["bunder", "bunderan ijo", "ijo"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მწვანე წრე"),
            keywords: &["მწვანე", "წრე"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("жасыл дөңгелек"),
            keywords: &["дөңгелек", "жасыл"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("រង\u{17d2}វង\u{17cb}ពណ\u{17cc}បៃតង"),
            keywords: &[
                "ពណ\u{17cc}បៃតង",
                "រង\u{17d2}វង\u{17cb}",
                "រង\u{17d2}វង\u{17cb}ពណ\u{17cc}បៃតង",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಹಸ\u{cbf}ರು ವೃತ\u{ccd}ತ"),
            keywords: &["ವೃತ\u{ccd}ತ", "ಹಸ\u{cbf}ರು"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("녹색 원"),
            keywords: &["녹색", "원"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("पाचव\u{947}\u{902} वर\u{94d}त\u{941}ळ"),
            keywords: &["पाचव\u{947}\u{902}", "वर\u{94d}त\u{941}ळ"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("жашыл айлана"),
            keywords: &["айлана", "жашыл"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ວ\u{ebb}ງ\u{200b}ມ\u{ebb}ນ\u{200b}ຂຽວ"),
            keywords: &[
                "ວ\u{ebb}ງ\u{200b}ມ\u{ebb}ນ",
                "ວ\u{ebb}ງ\u{200b}ມ\u{ebb}ນ\u{200b}ຂຽວ",
                "ສ\u{eb5}\u{200b}ຂຽວ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("žalias apskritimas"),
            keywords: &["apskritimas", "žalias"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("zaļš aplis"),
            keywords: &["aplis", "zaļš"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("зелен круг"),
            keywords: &["зелен", "круг"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("പച\u{d4d}ച വ\u{d43}ത\u{d4d}തം"),
            keywords: &["പച\u{d4d}ച", "വ\u{d43}ത\u{d4d}തം"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("ногоон тойрог"),
            keywords: &["ногоон", "тойрог"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("हिरव\u{947} वर\u{94d}त\u{941}ळ"),
            keywords: &["वर\u{94d}त\u{941}ळ", "हिरव\u{947}"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("bulatan hijau"),
            keywords: &["bulatan", "hijau"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အစ\u{102d}မ\u{103a}းရောင\u{103a} စက\u{103a}ဝ\u{102d}\u{102f}င\u{103a}း"),
            keywords: &[
                "စက\u{103a}ဝ\u{102d}\u{102f}င\u{103a}း",
                "အစ\u{102d}မ\u{103a}းရောင\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("grønn sirkel"),
            keywords: &["grønn", "sirkel"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("हरियो व\u{943}त\u{94d}त"),
            keywords: &["व\u{943}त\u{94d}त", "हरियो"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("groene cirkel"),
            keywords: &["cirkel", "groen", "groene cirkel"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("grøn sirkel"),
            keywords: &["grøn", "sirkel"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ସବ\u{b41}ଜ ବ\u{b43}ତ\u{b4d}ତ"),
            keywords: &["ବ\u{b43}ତ\u{b4d}ତ", "ସବ\u{b41}ଜ"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਹਰਾ ਗ\u{a4b}ਲਾ"),
            keywords: &["ਗ\u{a4b}ਲਾ", "ਹਰਾ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Grín Sẹ\u{301}kul"),
            keywords: &["Grin", "Grín Sẹ\u{301}kul", "Sẹ\u{301}kul"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("zielone koło"),
            keywords: &["koło", "kółko", "zielone"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("شنه دايره"),
            keywords: &["دايره", "شنه"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("círculo verde"),
            keywords: &["círculo", "verde"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("cerc verde"),
            keywords: &["cerc", "verde"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E12–012"),
            keywords: &["E12–012"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("зеленый круг"),
            keywords: &["геометрия", "зеленый", "круг", "фигура", "шар"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("سائو دائرو"),
            keywords: &["دائرو", "سائو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("කොළ රව\u{dd4}ම"),
            keywords: &["කොළ", "රව\u{dd4}ම"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("zelený kruh"),
            keywords: &["koliesko", "kruh", "krúžok", "zelená", "zelený kruh"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("zelen krog"),
            keywords: &["krog", "zelen"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("goobada caggaarka ah"),
            keywords: &["caggaar", "goobada caggaarka ah", "goobo"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("rreth i gjelbër"),
            keywords: &["gjeometri", "i gjelbër", "rreth", "rreth i gjelbër"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("зелен круг"),
            keywords: &["зелен круг", "зелено", "круг"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["зелен круг"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("zelen krug"),
            keywords: &["krug", "zelen krug", "zeleno"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["zelen krug"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("grön cirkel"),
            keywords: &["cirkel", "grön"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mduara wa kijani"),
            keywords: &["kijani", "mduara", "mduara wa kijani"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பச\u{bcd}சை வட\u{bcd}டம\u{bcd}"),
            keywords: &["பச\u{bcd}சை", "வட\u{bcd}டம\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("పచ\u{c4d}చరంగు వృత\u{c4d}తం"),
            keywords: &["పచ\u{c4d}చరంగు", "వృత\u{c4d}తం"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("วงกลมส\u{e35}เข\u{e35}ยว"),
            keywords: &["วงกลม", "วงกลมส\u{e35}เข\u{e35}ยว", "ส\u{e35}เข\u{e35}ยว"],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ቀጠልያ ዓንኬል"),
            keywords: &["ቀጠልያ", "ዓንኬል"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ýaşyl tegelek"),
            keywords: &["tegelek", "ýaşyl"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("fuopotopoto lanumata"),
            keywords: &["fuopotopoto", "lanumata"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("yeşil daire"),
            keywords: &["daire", "yeşil"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("зелений круг"),
            keywords: &["зелений", "круг"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("سبز دائرہ"),
            keywords: &["دائرہ", "سبز"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("yashil doira"),
            keywords: &["aylana", "doira", "yashil"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("hình tròn màu xanh lá cây"),
            keywords: &[
                "hình tròn",
                "hình tròn màu xanh lá cây",
                "màu xanh lá cây",
                "vòng tròn",
                "xanh lá",
                "xanh lục",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("綠色圓形"),
            keywords: &["圓形", "綠色", "綠色圓形"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("绿色圆形"),
            keywords: &["圆形", "绿色", "绿色圆形"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("绿色圆"),
            keywords: &["圆", "圈", "绿", "绿色圆"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("綠色圓形"),
            keywords: &["圓形", "綠色", "綠色圓形"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("isikokela esihlaza"),
            keywords: &["isikokela esihlaza"],
        },
    ],
};
#[doc = "🔵"]
pub const BLUE_CIRCLE: crate::Emoji = crate::Emoji {
    glyph: "🔵",
    codepoint: "1F535",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "blue circle",
    group: "Symbols",
    subgroup: "geometric",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("blou sirkel"),
            keywords: &["blou", "geometries", "sirkel"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ሰማያዊ ክብ"),
            keywords: &["ሰማያዊ", "ክብ", "ጂኦሜትሪያዊ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("دائرة زرقاء"),
            keywords: &["أزرق", "دائرة", "دائرة زرقاء", "دائرة زرقاء كبيرة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("নীল\u{9be} ব\u{9c3}ত\u{9cd}ত"),
            keywords: &["জ\u{9cd}য\u{9be}মিতিক", "নীল\u{9be}", "ব\u{9c3}ত\u{9cd}ত"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("mavi dairə"),
            keywords: &["dairə", "həndəsi", "mavi"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("сіні круг"),
            keywords: &["аб’ект", "геаметрычны", "круг", "сіні"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Син кръг"),
            keywords: &["Син кръг", "геометричен", "кръг", "син"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("নীল ব\u{9c3}ত\u{9cd}ত"),
            keywords: &["জ\u{9cd}য\u{9be}মিতিক", "নীল", "ব\u{9c3}ত\u{9cd}ত"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("plavi krug"),
            keywords: &["geometrija", "krug", "plava", "plavi krug"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cercle blau"),
            keywords: &["blau", "cercle", "geometria"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏌᎪᏂᎨ ᎦᏐᏆᎸ"),
            keywords: &["ᎤᏙᏢᏒ", "ᎦᏐᏆᎸ", "ᏌᎪᏂᎨ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("modrý kroužek"),
            keywords: &["geometrie", "kruh", "modrá", "modrý kroužek"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("cylch glas"),
            keywords: &["cylch", "geometrig", "glas"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("blå cirkel"),
            keywords: &["blå", "cirkel", "geometrisk"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("blauer Punkt"),
            keywords: &["Ball", "Punkt", "blau", "blauer Punkt"],
        },
        #[cfg(feature = "de_CH")]
        crate::Annotation {
            lang: "de_CH",
            tts: Some("Grosser blauer Kreis"),
            keywords: &["Ball", "Grosser blauer Kreis", "Kreis", "blau"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("μπλε κύκλος"),
            keywords: &["γεωμετρικό", "κύκλος", "μπλε"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("blue circle"),
            keywords: &["blue", "circle", "geometric"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("círculo azul grande"),
            keywords: &["azul", "círculo", "círculo azul grande", "geometría"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("círculo azul"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["azul", "círculo", "geométrico"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("sinine ring"),
            keywords: &["geomeetria", "ring", "sinine"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("zirkulu urdina"),
            keywords: &["geometriko", "urdin", "zirkulu", "zirkulu urdina"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("دایره آبی"),
            keywords: &["آبی", "دایره", "شکل هندسی"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("sininen ympyrä"),
            keywords: &["muoto", "sininen", "ympyrä"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("asul na bilog"),
            keywords: &["asul", "asul na bilog", "bilog", "hugis"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("bláur sirkul"),
            keywords: &["blátt", "bláur", "sirkul"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("disque bleu"),
            keywords: &[
                "bleu",
                "cercle",
                "disque bleu",
                "forme géométrique",
                "géométrie",
                "rond",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("rond bleu"),
            keywords: &["bleu", "cercle", "disque", "géométrie", "rond", "sphère"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("ciorcal gorm"),
            keywords: &["ciorcal gorm", "ciorcal mór gorm"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("cearcall gorm"),
            keywords: &["cearcall", "geomatrach", "gorm"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("círculo azul"),
            keywords: &["azul", "círculo"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("વાદળી ગોળ"),
            keywords: &[
                "મોટ\u{ac1}\u{a82} વર\u{acd}ત\u{ac1}ળ",
                "મોટ\u{ac1}\u{a82} વાદળી વર\u{acd}ત\u{ac1}ળ",
                "વર\u{acd}ત\u{ac1}ળ",
                "વાદળી",
                "વાદળી ગોળ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("shuɗin da’ira"),
            keywords: &["da’ira", "ilimin halayen sura", "shuɗi", "shuɗin da’ira"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("עיגול כחול"),
            keywords: &["כחול", "עיגול", "צורה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("नीला व\u{943}त\u{94d}त"),
            keywords: &[
                "ज\u{94d}यामिति",
                "नीला गोला",
                "नीला व\u{943}त\u{94d}त",
                "व\u{943}त\u{94d}त",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("plavi krug"),
            keywords: &["geometrija", "krug", "plavi krug", "plavo"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("kék kör"),
            keywords: &["alakzat", "kék", "kör"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("կապույտ շրջան"),
            keywords: &["երկրաչափական", "կապույտ", "շրջան"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("lingkaran biru"),
            keywords: &["biru", "geometri", "lingkaran"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("okirikiri anụnụ"),
            keywords: &["anụnụ", "mgbakọ", "okirikiri"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("stór blár hringur"),
            keywords: &["blár", "hringur", "rúmfræði", "stór blár hringur"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("cerchio blu"),
            keywords: &["blu", "cerchio", "geometria"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("青い丸"),
            keywords: &["丸", "丸いボタン", "青", "青い丸"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("bunderan biru"),
            keywords: &["biru", "bunder", "bunderan biru", "geometrik"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ლურჯი წრე"),
            keywords: &[
                "გეომეტრია",
                "გეომეტრიული",
                "ლურჯი",
                "რგოლი",
                "ცისფერი",
                "წრე",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("көк дөңгелек"),
            keywords: &["геометриялық", "көк", "көк дөңгелек", "шеңбер"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("blå cirkel"),
            keywords: &["blå", "cirkel", "geometrisk"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("រង\u{17d2}វង\u{17cb}ពណ\u{17cc}ខៀវ"),
            keywords: &[
                "ខៀវ",
                "ធរណ\u{17b8}មាត\u{17d2}រ",
                "រង\u{17d2}វង\u{17cb}",
                "រង\u{17d2}វង\u{17cb}ពណ\u{17cc}ខៀវ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ನೀಲ\u{cbf} ವೃತ\u{ccd}ತ"),
            keywords: &[
                "ದೊಡ\u{ccd}ಡ ನೀಲ\u{cbf} ವೃತ\u{ccd}ತ",
                "ನೀಲ\u{cbf} ವೃತ\u{ccd}ತ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("파란 원"),
            keywords: &["원", "큰 파란 원", "파란 원", "파랑"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("निळ\u{947}\u{902} वर\u{94d}त\u{941}ळ"),
            keywords: &[
                "जियोम\u{945}ट\u{94d}रिक",
                "निळ\u{947}\u{902}",
                "वर\u{94d}त\u{941}ळ",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("көк тегерек"),
            keywords: &["геометрия", "көк", "тегерек"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("bloe Krees"),
            keywords: &["Krees", "blo", "bloe Krees", "geometresch"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ວ\u{ebb}ງມ\u{ebb}ນຟ\u{ec9}າ"),
            keywords: &[
                "ວ\u{ebb}ງມ\u{ebb}ນ",
                "ວ\u{ebb}ງມ\u{ebb}ນຟ\u{ec9}າ",
                "ສ\u{eb5}ຟ\u{ec9}າ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("mėlynas apskritimas"),
            keywords: &["apskritimas", "geometrija", "mėlynas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("zils aplis"),
            keywords: &["aplis", "zils aplis", "ģeometrija"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("porohita kikorangi"),
            keywords: &["kikorangi", "porohita", "āhuahanga"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("син круг"),
            keywords: &["геометрија", "круг", "син"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("നീല വ\u{d43}ത\u{d4d}തം"),
            keywords: &[
                "നീല",
                "വലിയ നീല വ\u{d43}ത\u{d4d}തം",
                "വലിയ വ\u{d43}ത\u{d4d}തം",
                "വ\u{d43}ത\u{d4d}തം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("цэнхэр тойрог"),
            keywords: &["геометр", "тойрог", "цэнхэр"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("निळ\u{947} वर\u{94d}त\u{941}ळ"),
            keywords: &["निळ\u{947}", "भ\u{942}मितीय", "वर\u{94d}त\u{941}ळ"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("bulatan biru"),
            keywords: &["biru", "bulatan", "geometri"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("ċirku blu"),
            keywords: &["blu", "ċirku", "ġeometriku"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အပြာရောင\u{103a}စက\u{103a}ဝ\u{102d}\u{102f}င\u{103a}း"),
            keywords: &[
                "စက\u{103a}ဝ\u{102d}\u{102f}င\u{103a}း",
                "အပြာရောင\u{103a}",
                "အပြာရောင\u{103a}စက\u{103a}ဝ\u{102d}\u{102f}င\u{103a}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("blå sirkel"),
            keywords: &["blå", "geometrisk", "sirkel"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("नीलो घ\u{947}रा"),
            keywords: &["घ\u{947}रा", "ज\u{94d}यामितीय", "नीलो"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("blauwe cirkel"),
            keywords: &["blauw", "blauwe cirkel", "cirkel", "geometrisch"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("blå sirkel"),
            keywords: &["blå", "geometrisk", "sirkel"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ନୀଳ ବ\u{b43}ତ\u{b4d}ତ"),
            keywords: &[
                "ଜ\u{b4d}ୟ\u{b3e}ମ\u{b3f}ତ\u{b3f}କ",
                "ନୀଳ",
                "ବ\u{b43}ତ\u{b4d}ତ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਨੀਲਾ ਗ\u{a4b}ਲਾ"),
            keywords: &["ਗ\u{a4b}ਲਾ", "ਘ\u{a47}ਰਾ", "ਜਯਾਮਿਤੀ", "ਨੀਲਾ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("نیلا چکر"),
            keywords: &["جیومیٹری دے متعلق", "دائرہ", "نیلا", "نیلا چکر"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Blú Sẹ\u{301}kul"),
            keywords: &[
                "Blu",
                "Blú Sẹ\u{301}kul",
                "Jiọ\u{301}mẹ\u{301}tri",
                "Sẹ\u{301}kul",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("niebieskie koło"),
            keywords: &["figura geometryczna", "koło", "kółko", "niebieskie"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("آسماني رنګ دايره"),
            keywords: &["آسماني رنګ", "آسماني رنګ دايره", "جيوميتريکي", "دايره"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("círculo azul"),
            keywords: &["azul", "círculo", "geométrico"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["azul", "círculo", "geométrico"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("cerc albastru"),
            keywords: &["albastru", "cerc", "geometric"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-753"),
            keywords: &["E10-753"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("голубой круг"),
            keywords: &["геометрия", "голубой", "круг", "фигура", "шар"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("uruziga rw’ubururu"),
            keywords: &[
                "byerekeye jewometiri",
                "ubururu",
                "uruziga",
                "uruziga rw’ubururu",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("نيرو دائرو"),
            keywords: &["جيوميٽرڪ", "دائرو", "نيرو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("න\u{dd2}ල\u{dca} රව\u{dd4}ම"),
            keywords: &[
                "ජ\u{dca}\u{200d}ය\u{dcf}ම\u{dd2}ත\u{dd2}ක",
                "න\u{dd2}ල\u{dca}",
                "රව\u{dd4}ම",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("modrý kruh"),
            keywords: &["geometria", "kruh", "modrý"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("moder krog"),
            keywords: &["geometrično", "krog", "moder krog", "modro"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("goobada buluugga"),
            keywords: &["buluug", "goobada buluugga", "goobo", "joometriyeed"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("rreth blu"),
            keywords: &["blu", "gjeometri", "rreth"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("плави круг"),
            keywords: &["геометријски", "круг", "плави круг", "плаво"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["плави круг"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("plavi krug"),
            keywords: &["geometrijski", "krug", "plavi krug", "plavo"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["plavi krug"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("blå cirkel"),
            keywords: &["blå", "cirkel", "geometrisk"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mduara wa samawati"),
            keywords: &["jiometri", "mduara", "mduara wa samawati", "samawati"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ந\u{bc0}ல வட\u{bcd}டம\u{bcd}"),
            keywords: &[
                "சர\u{bcd}க\u{bcd}கிள\u{bcd}",
                "ந\u{bc0}ல வட\u{bcd}டம\u{bcd}",
                "ப\u{bcd}ளூ",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ప\u{c46}ద\u{c4d}ద న\u{c40}ల\u{c3f} రంగు వృత\u{c4d}తం"),
            keywords: &[
                "న\u{c40}ల\u{c3f} రంగు",
                "ప\u{c46}ద\u{c4d}ద న\u{c40}ల\u{c3f} రంగు వృత\u{c4d}తం",
                "వృత\u{c4d}తం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("доираи кабуд"),
            keywords: &["геометрӣ", "доира", "доираи кабуд", "кабуд"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("วงกลมส\u{e35}น\u{e49}ำเง\u{e34}น"),
            keywords: &[
                "น\u{e49}ำเง\u{e34}น",
                "วงกลม",
                "วงกลมส\u{e35}น\u{e49}ำเง\u{e34}น",
            ],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ሰማያዊ ዓንኬል"),
            keywords: &["ሰማያዊ", "ዓንኬል", "ጂኦሜትሪክ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("gök halka"),
            keywords: &["geometrik", "gök", "halka"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("fuopotopoto lanupulū"),
            keywords: &["fuopotopoto", "lanupulū"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("mavi daire"),
            keywords: &["büyük mavi çember", "mavi", "mavi daire", "çember"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("كۆك چەمبەر"),
            keywords: &["كۆك", "چەمبەر", "گېئومېتىرىيە"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("cиній круг"),
            keywords: &["cиній круг", "геометричний", "коло", "синє"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("نیلا دائرہ"),
            keywords: &["جیومیٹری", "دائرہ", "نیلا"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("ko‘k doira"),
            keywords: &["aylana", "geometriya", "ko‘k", "ko‘k doira"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("hình tròn màu lam"),
            keywords: &["hình học", "hình tròn", "hình tròn màu lam", "màu lam"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("serkal baxa"),
            keywords: &["baxa", "serkal", "wu-geometri"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("isangqa esibhlowu"),
            keywords: &["bhlowu", "ijiyometriki", "isangqa", "isangqa esibhlowu"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Rogodo Búlúù"),
            keywords: &["Búlù", "Rogodo Búlúù", "jiomẹ\u{301}tíríkì", "rogodo"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("藍色圓形"),
            keywords: &["圓形", "幾何", "藍色", "藍色圓形"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("蓝色圆形"),
            keywords: &["几何", "圆形", "蓝色", "蓝色圆形"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("蓝色圆"),
            keywords: &["圈", "蓝", "蓝色圆"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("大藍色圓形"),
            keywords: &["圓形", "大藍色圓形"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("藍色大圓圈"),
            keywords: &["圓圈", "藍色", "藍色大圓圈"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("indingilizi eluhlaza sasibhakabhaka"),
            keywords: &[
                "indingiliza",
                "indingilizi eluhlaza sasibhakabhaka",
                "jiyometrikhi",
                "luhlaza sasibhakabhaka",
            ],
        },
    ],
};
#[doc = "🟣"]
pub const PURPLE_CIRCLE: crate::Emoji = crate::Emoji {
    glyph: "🟣",
    codepoint: "1F7E3",
    status: crate::Status::FullyQualified,
    introduction_version: 12f32,
    name: "purple circle",
    group: "Symbols",
    subgroup: "geometric",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("pers sirkel"),
            keywords: &["pers", "sirkel"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ሐምራዊ ክብ"),
            keywords: &["ሐምራዊ", "ክብ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("دائرة بنفسجية"),
            keywords: &["بنفسجي", "دائرة", "دائرة بنفسجية"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("বেঙ\u{9c1}নীয\u{9bc}\u{9be} ব\u{9c3}ত\u{9cd}ত"),
            keywords: &["ব\u{9c3}ত\u{9cd}ত", "বেঙ\u{9c1}নীয\u{9bc}\u{9be}"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("bənövşəyi çevrə"),
            keywords: &["bənövşəyi", "çevrə"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("фіялетавы круг"),
            keywords: &["круг", "фіялетавы"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("лилав кръг"),
            keywords: &["кръг", "лилав"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("বেগ\u{9c1}নী ব\u{9c3}ত\u{9cd}ত"),
            keywords: &["ব\u{9c3}ত\u{9cd}ত", "বেগ\u{9c1}নী"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("ljubičasti krug"),
            keywords: &["krug", "ljubičasta", "ljubičasti krug"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cercle lila"),
            keywords: &["cercle", "lila", "morat", "violeta"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏓᎲᎵᎨ ᎦᏐᏆᎸ"),
            keywords: &["ᎠᏓᎲᎵᎨ", "ᎦᏐᏆᎸ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("fialový kroužek"),
            keywords: &["fialová", "fialový kroužek", "kolečko", "kroužek", "kruh"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("cylch piws"),
            keywords: &["cylch", "piws"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("lilla cirkel"),
            keywords: &["lilla cirkel"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("lila Punkt"),
            keywords: &["Punkt", "lila"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("μοβ κύκλος"),
            keywords: &["κύκλος", "μοβ", "μωβ"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("purple circle"),
            keywords: &["circle", "purple"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("círculo morado"),
            keywords: &["círculo", "lila", "morado", "púrpura"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("lilla ring"),
            keywords: &["kera", "lilla", "ring"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("zirkulu morea"),
            keywords: &["more", "zirkulu", "zirkulu morea"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("دایره بنفش"),
            keywords: &["بنفش", "دایره"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("violetti ympyrä"),
            keywords: &["violetti", "ympyrä"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("lilang bilog"),
            keywords: &["bilog", "lila", "lilang bilog"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("lillafarvaður sirkul"),
            keywords: &[
                "korkalitt",
                "korkalittur",
                "korkalitur",
                "lillafarva",
                "lillafarvaður",
                "reyðblátt",
                "reyðbláur",
                "sirkul",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("disque violet"),
            keywords: &[
                "cercle",
                "disque violet",
                "forme géométrique",
                "géométrie",
                "rond",
                "violet",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("cercle violet"),
            keywords: &["cercle", "disque", "géométrie", "rond", "sphère", "violet"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("ciorcal corcra"),
            keywords: &["ciorcal", "corcra"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("cearcall purpaidh"),
            keywords: &["cearcall", "corca", "purpaidh"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("círculo violeta"),
            keywords: &["círculo", "violeta"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("જા\u{a82}બલી વર\u{acd}ત\u{ac1}ળ"),
            keywords: &["જા\u{a82}બલી", "વર\u{acd}ત\u{ac1}ળ"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("עיגול סגול"),
            keywords: &["מעגל", "סגול", "עיגול"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ब\u{948}\u{902}गनी व\u{943}त\u{94d}त"),
            keywords: &[
                "आक\u{943}ति",
                "ग\u{947}\u{902}द",
                "गोला",
                "ज\u{94d}यामिति",
                "ब\u{948}\u{902}गनी",
                "व\u{943}त\u{94d}त",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("ljubičasti krug"),
            keywords: &["krug", "ljubičasti"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("lila kör"),
            keywords: &["kör", "lila"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("մանուշակագույն շրջան"),
            keywords: &["մանուշակագույն", "շրջան"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("lingkaran ungu"),
            keywords: &["lingkaran", "ungu"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("fjólublár hringur"),
            keywords: &["fjólublár", "hringur"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("cerchio viola"),
            keywords: &["cerchio", "cerchio di colore viola", "cerchio viola"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("紫の丸"),
            keywords: &["丸", "丸いボタン", "紫", "紫の丸"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("bunderan wungu"),
            keywords: &["bunder", "bunderan wungu", "wungu"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("იისფერი წრე"),
            keywords: &["იისფერი", "წრე"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("күлгін дөңгелек"),
            keywords: &["дөңгелек", "күлгін"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("រង\u{17d2}វង\u{17cb}ពណ\u{17cc}ស\u{17d2}វាយ"),
            keywords: &[
                "ពណ\u{17cc}ស\u{17d2}វាយ",
                "រង\u{17d2}វង\u{17cb}",
                "រង\u{17d2}វង\u{17cb}ពណ\u{17cc}ស\u{17d2}វាយ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ನೇರಳ\u{cc6} ವೃತ\u{ccd}ತ"),
            keywords: &["ನೇರಳ\u{cc6}", "ವೃತ\u{ccd}ತ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("보라색 원"),
            keywords: &["보라색", "원"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("जा\u{902}भळ\u{947}\u{902} वर\u{94d}त\u{941}ळ"),
            keywords: &["जा\u{902}भळ\u{947}\u{902}", "वर\u{94d}त\u{941}ळ"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("кызгылт көк айлана"),
            keywords: &["айлана", "кызгылт көк", "кызгылт көк айлана"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ວ\u{ebb}ງ\u{200b}ມ\u{ebb}ນ\u{200b}ມ\u{ec8}ວງ"),
            keywords: &[
                "ວ\u{ebb}ງ\u{200b}ມ\u{ebb}ນ",
                "ວ\u{ebb}ງ\u{200b}ມ\u{ebb}ນ\u{200b}ມ\u{ec8}ວງ",
                "ສ\u{eb5}\u{200b}ມ\u{ec8}ວງ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("violetinis apskritimas"),
            keywords: &["apskritimas", "violetinis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("violets aplis"),
            keywords: &["aplis", "violets"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("виолетов круг"),
            keywords: &["виолетов", "круг"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("പർപ\u{d4d}പിൾ വ\u{d43}ത\u{d4d}തം"),
            keywords: &["പർപ\u{d4d}പിൾ", "വ\u{d43}ത\u{d4d}തം"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("нил ягаан тойрог"),
            keywords: &["нил ягаан", "нил ягаан тойрог", "тойрог"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("जा\u{902}भळ\u{947} वर\u{94d}त\u{941}ळ"),
            keywords: &["जा\u{902}भळ\u{947}", "वर\u{94d}त\u{941}ळ"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("bulatan ungu"),
            keywords: &["bulatan", "ungu"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ခရမ\u{103a}းရောင\u{103a} စက\u{103a}ဝ\u{102d}\u{102f}င\u{103a}း"),
            keywords: &[
                "ခရမ\u{103a}းရောင\u{103a}",
                "စက\u{103a}ဝ\u{102d}\u{102f}င\u{103a}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("lilla sirkel"),
            keywords: &["lilla", "sirkel"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("ब\u{948}जनी व\u{943}त\u{94d}त"),
            keywords: &["ब\u{948}जनी", "व\u{943}त\u{94d}त"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("paarse cirkel"),
            keywords: &["cirkel", "paars", "paarse cirkel"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("lilla sirkel"),
            keywords: &["lilla", "sirkel"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ବ\u{b3e}ଇଗଣୀ ବ\u{b43}ତ\u{b4d}ତ"),
            keywords: &["ବ\u{b3e}ଇଗଣୀ", "ବ\u{b43}ତ\u{b4d}ତ"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਜਾਮਣੀ ਗ\u{a4b}ਲਾ"),
            keywords: &["ਗ\u{a4b}ਲਾ", "ਜਾਮਣੀ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Pọ\u{301}púl Kọ\u{301}lọ Sẹ\u{301}kul"),
            keywords: &[
                "Pọ\u{301}púl Kọ\u{301}lọ",
                "Pọ\u{301}púl Kọ\u{301}lọ Sẹ\u{301}kul",
                "Sẹ\u{301}kul",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("fioletowe koło"),
            keywords: &["fioletowe", "koło", "kółko"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ارغواني دايره"),
            keywords: &["ارغواني", "دايره"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("círculo roxo"),
            keywords: &["círculo", "roxo"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("cerc violet"),
            keywords: &["cerc", "violet"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E12–013"),
            keywords: &["E12–013"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("фиолетовый круг"),
            keywords: &["геометрия", "круг", "фигура", "фиолетовый", "шар"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("جامني دائرو"),
            keywords: &["جامني", "دائرو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("දම\u{dca} රව\u{dd4}ම"),
            keywords: &["දම\u{dca}", "රව\u{dd4}ම"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("fialový kruh"),
            keywords: &["fialová", "fialový kruh", "koliesko", "kruh", "krúžok"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("škrlaten krog"),
            keywords: &["krog", "škrlaten"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("goobada buluug-guduudka ah"),
            keywords: &["buluug-guduud", "goobada buluug-guduudka ah", "goobo"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("rreth në ngjyrë vjollce"),
            keywords: &["ngjyrë vjollce", "rreth", "rreth në ngjyrë vjollce"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("љубичаст круг"),
            keywords: &["круг", "љубичаст круг", "љубичасто"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["љубичаст круг"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("ljubičast krug"),
            keywords: &["krug", "ljubičast krug", "ljubičasto"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["ljubičast krug"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("lila cirkel"),
            keywords: &["cirkel", "lila"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mduara wa zambarau"),
            keywords: &["mduara", "mduara wa zambarau", "zambarau"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பர\u{bcd}பிள\u{bcd} வட\u{bcd}டம\u{bcd}"),
            keywords: &["பர\u{bcd}பிள\u{bcd}", "வட\u{bcd}டம\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ఊద\u{c3e}రంగు వృత\u{c4d}తం"),
            keywords: &["ఊద\u{c3e}రంగు", "వృత\u{c4d}తం"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("วงกลมส\u{e35}ม\u{e48}วง"),
            keywords: &["วงกลม", "วงกลมส\u{e35}ม\u{e48}วง", "ส\u{e35}ม\u{e48}วง"],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ሊላ ዓንኬል"),
            keywords: &["ሊላ", "ዓንኬል"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("melewşe tegelek"),
            keywords: &["melewşe", "tegelek"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("fuopotopoto lanuvaioleti"),
            keywords: &["fuopotopoto", "lanuvaioleti"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("mor daire"),
            keywords: &["daire", "mor"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("пурпуровий круг"),
            keywords: &["круг", "пурпуровий"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ارغوانی دائرہ"),
            keywords: &["ارغوانی", "دائرہ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("binafsharang doira"),
            keywords: &["aylana", "binafsharang", "doira"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("hình tròn màu tím"),
            keywords: &[
                "hình tròn",
                "hình tròn màu tím",
                "màu tím",
                "tía",
                "vòng tròn",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("紫色圓形"),
            keywords: &["圓形", "紫色", "紫色圓形"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("紫色圆形"),
            keywords: &["圆形", "紫色", "紫色圆形"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("紫色圆"),
            keywords: &["圆", "圈", "紫", "紫色圆"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("紫色圓形"),
            keywords: &["圓形", "紫色", "紫色圓形"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("isikokela esibukhwebezane"),
            keywords: &["isikokela esibukhwebezane"],
        },
    ],
};
#[doc = "🟤"]
pub const BROWN_CIRCLE: crate::Emoji = crate::Emoji {
    glyph: "🟤",
    codepoint: "1F7E4",
    status: crate::Status::FullyQualified,
    introduction_version: 12f32,
    name: "brown circle",
    group: "Symbols",
    subgroup: "geometric",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("bruin sirkel"),
            keywords: &["bruin", "sirkel"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ቡናማ ክብ"),
            keywords: &["ቡናማ", "ክብ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("دائرة بنية"),
            keywords: &["بني", "دائرة", "دائرة بنية"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ম\u{9c2}গ\u{9be} ব\u{9c3}ত\u{9cd}ত"),
            keywords: &["ব\u{9c3}ত\u{9cd}ত", "ম\u{9c2}গ\u{9be}"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("qəhvəyi çevrə"),
            keywords: &["qəhvəyi", "çevrə"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("карычневы круг"),
            keywords: &["карычневы", "круг"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("кафяв кръг"),
            keywords: &["кафяв кръг", "кафяво", "кръг"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ব\u{9be}দ\u{9be}মি ব\u{9c3}ত\u{9cd}ত"),
            keywords: &["ব\u{9be}দ\u{9be}মি", "ব\u{9c3}ত\u{9cd}ত"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("smeđi krug"),
            keywords: &["krug", "smeđa", "smeđi krug"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cercle marró"),
            keywords: &["cercle", "marró"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᏬᏗᎨ ᎦᏐᏆᎸ"),
            keywords: &["ᎤᏬᏗᎨ", "ᎦᏐᏆᎸ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("hnědý kroužek"),
            keywords: &["hnědá", "hnědý kroužek", "kolečko", "kroužek", "kruh"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("cylch brown"),
            keywords: &["brown", "cylch"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("brun cirkel"),
            keywords: &["brun cirkel"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("brauner Punkt"),
            keywords: &["Punkt", "braun", "brauner Punkt"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("καφέ κύκλος"),
            keywords: &["καφέ", "κύκλος"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("brown circle"),
            keywords: &["brown", "circle"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("círculo marrón"),
            keywords: &["círculo", "marrón"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("círculo café"),
            keywords: &["círculo café"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("círculo café"),
            keywords: &["café", "círculo", "marrón"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("pruun ring"),
            keywords: &["kera", "pruun", "ring"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("zirkulu marroia"),
            keywords: &["marroi", "zirkulu", "zirkulu marroia"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("دایره قهوه\u{200c}ای"),
            keywords: &["دایره", "قهوه\u{200c}ای"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("ruskea ympyrä"),
            keywords: &["ruskea", "ympyrä"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("brown na bilog"),
            keywords: &["bilog", "brown", "brown na bilog"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("brúnur sirkul"),
            keywords: &["brúnt", "brúnur", "sirkul"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("disque marron"),
            keywords: &[
                "cercle",
                "disque marron",
                "forme géométrique",
                "géométrie",
                "marron",
                "rond",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("cercle brun"),
            keywords: &["brun", "cercle", "disque", "géométrie", "rond", "sphère"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("ciorcal donn"),
            keywords: &["ciorcal", "donn"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("cearcall donn"),
            keywords: &["cearcall", "donn"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("círculo marrón"),
            keywords: &["castaño", "círculo", "marrón"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("કથ\u{acd}થઈ વર\u{acd}ત\u{ac1}ળ"),
            keywords: &["કથ\u{acd}થઈ", "વર\u{acd}ત\u{ac1}ળ"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("עיגול חום"),
            keywords: &["חום", "מעגל", "עיגול"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("भ\u{942}रा व\u{943}त\u{94d}त"),
            keywords: &[
                "आक\u{943}ति",
                "ग\u{947}\u{902}द",
                "गोला",
                "ज\u{94d}यामिति",
                "भ\u{942}रा",
                "भ\u{942}री",
                "व\u{943}त\u{94d}त",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("smeđi krug"),
            keywords: &["krug", "smeđi"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("barna kör"),
            keywords: &["barna", "kör"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("դարչնագույն շրջան"),
            keywords: &["դարչնագույն", "շրջան"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("lingkaran cokelat"),
            keywords: &["cokelat", "lingkaran"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("brúnn hringur"),
            keywords: &["brúnn", "hringur"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("cerchio marrone"),
            keywords: &["cerchio di colore marrone", "cerchio marrone", "marrone"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("茶色の丸"),
            keywords: &["丸", "丸いボタン", "茶色", "茶色の丸"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("bunderan soklat"),
            keywords: &["bunderan", "soklat"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ყავისფერი წრე"),
            keywords: &["ყავისფერი", "წრე"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("қоңыр дөңгелек"),
            keywords: &["дөңгелек", "қоңыр"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("រង\u{17d2}វង\u{17cb}ពណ\u{17cc}ត\u{17d2}នោត"),
            keywords: &[
                "ពណ\u{17cc}ត\u{17d2}នោត",
                "រង\u{17d2}វង\u{17cb}",
                "រង\u{17d2}វង\u{17cb}ពណ\u{17cc}ត\u{17d2}នោត",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕಂದುಬಣ\u{ccd}ಣದ ವೃತ\u{ccd}ತ"),
            keywords: &[
                "ಕಂದುಬಣ\u{ccd}ಣ",
                "ಕಂದುಬಣ\u{ccd}ಣದ ವೃತ\u{ccd}ತ",
                "ವೃತ\u{ccd}ತ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("갈색 원"),
            keywords: &["갈색", "원"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("तपकिरी वर\u{94d}त\u{941}ळ"),
            keywords: &["तपकिरी", "वर\u{94d}त\u{941}ळ"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("күрөң айлана"),
            keywords: &["айлана", "күрөң"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ວ\u{ebb}ງ\u{200b}ມ\u{ebb}ນ\u{200b}ນ\u{ec9}ຳ\u{200b}ຕານ"),
            keywords: &[
                "ວ\u{ebb}ງ\u{200b}ມ\u{ebb}ນ\u{200b}ນ\u{ec9}ຳ\u{200b}ຕານ",
                "ວ\u{ebb}ງ\u{200b}ມ\u{ebb}\u{200b}ນ",
                "ສ\u{eb5}\u{200b}ນ\u{ec9}ຳ\u{200b}ຕານ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("rudas apskritimas"),
            keywords: &["apskritimas", "rudas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("brūns aplis"),
            keywords: &["aplis", "brūns"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("кафен круг"),
            keywords: &["кафен", "круг"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ബ\u{d4d}ര\u{d57}ൺ വ\u{d43}ത\u{d4d}തം"),
            keywords: &["ബ\u{d4d}ര\u{d57}ൺ", "വ\u{d43}ത\u{d4d}തം"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("бор тойрог"),
            keywords: &["бор", "тойрог"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("तपकिरी वर\u{94d}त\u{941}ळ"),
            keywords: &["तपकिरी", "वर\u{94d}त\u{941}ळ"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("bulatan perang"),
            keywords: &["bulatan", "perang"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အည\u{102d}\u{102f}ရောင\u{103a} စက\u{103a}ဝ\u{102d}\u{102f}င\u{103a}း"),
            keywords: &[
                "စက\u{103a}ဝ\u{102d}\u{102f}င\u{103a}း",
                "အည\u{102d}\u{102f}ရောင\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("brun sirkel"),
            keywords: &["brun", "sirkel"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("ख\u{948}रो व\u{943}\u{94d}त"),
            keywords: &[
                "ख\u{948}रो",
                "ख\u{948}रो व\u{943}\u{94d}त",
                "व\u{943}त\u{94d}त",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("bruine cirkel"),
            keywords: &["bruin", "bruine cirkel", "cirkel"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("brun sirkel"),
            keywords: &["brun", "sirkel"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ବ\u{b3e}ଦ\u{b3e}ମୀ ବ\u{b43}ତ\u{b4d}ତ"),
            keywords: &["ବ\u{b3e}ଦ\u{b3e}ମୀ", "ବ\u{b43}ତ\u{b4d}ତ"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਭ\u{a42}ਰਾ ਗ\u{a4b}ਲਾ"),
            keywords: &["ਗ\u{a4b}ਲਾ", "ਭ\u{a42}ਰਾ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Braún Sẹ\u{301}kul"),
            keywords: &["Braun", "Braún Sẹ\u{301}kul", "Sẹ\u{301}kul"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("brązowe koło"),
            keywords: &["brązowe", "koło", "kółko"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("نسواري دايره"),
            keywords: &["دايره", "نسواري"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("círculo marrom"),
            keywords: &["círculo", "marrom"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("círculo castanho"),
            keywords: &["castanho", "círculo"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("cerc maro"),
            keywords: &["cerc", "maro"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E12–014"),
            keywords: &["E12–014"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("коричневый круг"),
            keywords: &["геометрия", "коричневый", "круг", "фигура", "шар"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("برائون دائرو"),
            keywords: &["برائون", "دائرو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ද\u{dd4}ඹ\u{dd4}ර\u{dd4} රව\u{dd4}ම"),
            keywords: &["ද\u{dd4}ඹ\u{dd4}ර\u{dd4}", "රව\u{dd4}ම"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("hnedý kruh"),
            keywords: &["hnedá", "hnedý kruh", "koliesko", "kruh", "krúžok"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("rjav krog"),
            keywords: &["krog", "rjav"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("goobada bunniga ah"),
            keywords: &["bunni", "goobada bunniga ah", "goobo"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("rreth në ngjyrë kafe"),
            keywords: &["gjeometri", "ngjyrë kafe", "rreth", "rreth në ngjyrë kafe"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("браон круг"),
            keywords: &["браон", "круг"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("braon krug"),
            keywords: &["braon", "krug"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("brun cirkel"),
            keywords: &["brun", "cirkel"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mduara wa hudhurungi"),
            keywords: &["hudhurungi", "mduara", "mduara wa hudhurungi"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பழுப\u{bcd}பு வட\u{bcd}டம\u{bcd}"),
            keywords: &["பழுப\u{bcd}பு", "வட\u{bcd}டம\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("గ\u{c4b}ధుమరంగు వృత\u{c4d}తం"),
            keywords: &["గ\u{c4b}ధుమరంగు", "వృత\u{c4d}తం"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("วงกลมส\u{e35}น\u{e49}ำตาล"),
            keywords: &["วงกลม", "วงกลมส\u{e35}น\u{e49}ำตาล", "ส\u{e35}น\u{e49}ำตาล"],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ቡናዊ ዓንኬል"),
            keywords: &["ቡናዊ", "ዓንኬል"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("goňur tegelek"),
            keywords: &["goňur", "tegelek"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("fuopotopoto melomelo"),
            keywords: &["fuopotopoto", "melomelo"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("kahverengi daire"),
            keywords: &["daire", "kahverengi"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("коричневий круг"),
            keywords: &["коричневий", "круг"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("بھورا دائرہ"),
            keywords: &["بھورا", "دائرہ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("jigarrang doira"),
            keywords: &["aylana", "doira", "jigarrang"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("hình tròn màu nâu"),
            keywords: &["hình tròn", "hình tròn màu nâu", "màu nâu", "vòng tròn"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("啡色圓形"),
            keywords: &["啡色", "啡色圓形", "圓形"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("啡色圆形"),
            keywords: &["啡色", "啡色圆形", "圆形"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("棕色圆"),
            keywords: &["圆", "圈", "棕", "棕色圆"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("褐色圓形"),
            keywords: &["圓形", "褐色", "褐色圓形"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("啡色圓形"),
            keywords: &["啡色", "啡色圓形", "圓形"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("indilinga e-brown"),
            keywords: &["brown", "indilinga", "indilinga e-brown"],
        },
    ],
};
#[doc = "⚫"]
pub const BLACK_CIRCLE: crate::Emoji = crate::Emoji {
    glyph: "⚫",
    codepoint: "26AB",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "black circle",
    group: "Symbols",
    subgroup: "geometric",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("swart sirkel"),
            keywords: &["geometries", "sirkel", "swart"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ጥቁር ክብ"),
            keywords: &["ክብ", "ጂኦሜትሪያዊ", "ጥቁር ክብ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("دائرة سوداء"),
            keywords: &["دائرة", "دائرة سوداء", "هندسية"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ক’ল\u{9be} ব\u{9c3}ত\u{9cd}ত"),
            keywords: &[
                "ক’ল\u{9be} ব\u{9c3}ত\u{9cd}ত",
                "জ\u{9cd}য\u{9be}মিতিক",
                "ব\u{9c3}ত\u{9cd}ত",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("qara dairə"),
            keywords: &["dairə", "həndəsi", "qara dairə"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("чорны круг"),
            keywords: &["аб’ект", "геаметрычны", "круг", "чорны"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Черен кръг"),
            keywords: &["Черен кръг", "геометричен", "кръг"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ক\u{9be}লো ব\u{9c3}ত\u{9cd}ত"),
            keywords: &[
                "ক\u{9be}লো ব\u{9c3}ত\u{9cd}ত",
                "জ\u{9cd}য\u{9be}মিতিক",
                "ব\u{9c3}ত\u{9cd}ত",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("crni krug"),
            keywords: &["crni krug", "geometrija", "krug"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cercle negre"),
            keywords: &["cercle", "geometria", "negre"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎬᎿᎨᎢ ᎦᏐᏆᎸ"),
            keywords: &["ᎤᏙᏢᏒ", "ᎦᏐᏆᎸ", "ᎬᎿᎨᎢ ᎦᏐᏆᎸ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("černý kroužek"),
            keywords: &["geometrie", "kruh", "černá", "černý kroužek"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("cylch du"),
            keywords: &["cylch", "cylch du", "geometrig"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("sort cirkel"),
            keywords: &["cirkel", "geometrisk", "sort cirkel"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("schwarzer Punkt"),
            keywords: &["Ball", "Punkt", "schwarz", "schwarzer Punkt"],
        },
        #[cfg(feature = "de_CH")]
        crate::Annotation {
            lang: "de_CH",
            tts: Some("Grosser schwarzer Kreis"),
            keywords: &["Ball", "Grosser schwarzer Kreis", "Kreis", "schwarz"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("μαύρος κύκλος"),
            keywords: &["γεωμετρικό", "κύκλος", "μαύρος κύκλος"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("black circle"),
            keywords: &["black circle", "circle", "geometric"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("círculo negro"),
            keywords: &["círculo", "círculo negro", "geometría"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("must ring"),
            keywords: &["geomeetria", "must ring", "ring"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("zirkulu beltza"),
            keywords: &["geometriko", "zirkulu", "zirkulu beltza"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("دایره مشکی"),
            keywords: &["دایره", "دایره مشکی", "شکل هندسی"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("musta ympyrä"),
            keywords: &["muoto", "musta ympyrä", "ympyrä"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("itim na bilog"),
            keywords: &["bilog", "hugis", "itim", "itim na bilog"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("svartur sirkul"),
            keywords: &["mátingarfrøði", "sirkul", "svartur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("disque noir"),
            keywords: &[
                "cercle",
                "disque noir",
                "forme géométrique",
                "géométrie",
                "noir",
                "rond",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("rond noir"),
            keywords: &["cercle", "disque", "géométrie", "noir", "rond", "sphère"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("ciorcal dubh"),
            keywords: &["ciorcal", "ciorcal dubh", "geoiméadrach"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("cearcall dubh"),
            keywords: &["cearcall", "cearcall dubh", "geomatrach"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("círculo negro"),
            keywords: &["círculo", "negro"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("કાળ\u{ac1}\u{a82} ગોળ"),
            keywords: &["કાળ\u{ac1}\u{a82} ગોળ", "ગોળ", "ભૌમિતિક"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("baƙin da’ira"),
            keywords: &["baƙin da’ira", "da’ira", "ilimin halayen sura"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("עיגול שחור"),
            keywords: &["עיגול", "צורה", "שחור"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("काला व\u{943}त\u{94d}त"),
            keywords: &["काला व\u{943}त\u{94d}त", "गोला", "ज\u{94d}यामिति"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("crni krug"),
            keywords: &["crni krug", "geometrija", "krug"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("fekete kör"),
            keywords: &["alakzat", "fekete kör", "kör"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("սև շրջանակ"),
            keywords: &["երկրաչափական", "շրջան", "սև շրջան", "սև շրջանակ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("lingkaran hitam"),
            keywords: &["geometri", "lingkaran", "lingkaran hitam"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("okirikiri ojii"),
            keywords: &["mgbakọ", "okirikiri", "okirikiri ojii"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("svartur hringur"),
            keywords: &["hringur", "rúmfræði", "svartur"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("cerchio nero"),
            keywords: &["cerchio", "geometria", "nero"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("黒い丸"),
            keywords: &["丸", "丸いボタン", "黒", "黒い丸"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("bunderan ireng"),
            keywords: &["bunder", "bunderan ireng", "geometrik"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("შავი წრე"),
            keywords: &["გეომეტრია", "გეომეტრიული", "რგოლი", "შავი წრე", "წრე"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("қара дөңгелек"),
            keywords: &["геометриялық", "шеңбер", "қара дөңгелек"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("sort cirkel"),
            keywords: &["cirkel", "geometrisk", "sort cirkel"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("រង\u{17d2}វង\u{17cb}ពណ\u{17cc}ខ\u{17d2}មៅ"),
            keywords: &[
                "ខ\u{17d2}មៅ",
                "ពណ\u{17cc}",
                "រង\u{17d2}វង\u{17cb}",
                "រង\u{17d2}វង\u{17cb}ពណ\u{17cc}ខ\u{17d2}មៅ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕಪ\u{ccd}ಪು ವೃತ\u{ccd}ತ"),
            keywords: &[
                "ಕಪ\u{ccd}ಪು ವೃತ\u{ccd}ತ",
                "ದೊಡ\u{ccd}ಡ ಕಪ\u{ccd}ಪು ವೃತ\u{ccd}ತ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("검은색 원"),
            keywords: &["검은색 원", "동그라미", "원"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("काळ\u{947}\u{902} वर\u{94d}त\u{941}ळ"),
            keywords: &[
                "काळ\u{947}\u{902} वर\u{94d}त\u{941}ळ",
                "जियोम\u{945}ट\u{94d}रीक",
                "वर\u{94d}त\u{941}ळ",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("кара тегерек"),
            keywords: &["геометрия", "кара тегерек", "тегерек"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("schwaarze Krees"),
            keywords: &["Krees", "geometresch", "schwaarze Krees"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ວ\u{ebb}ງມ\u{ebb}ນດຳ"),
            keywords: &["ວ\u{ebb}ງມ\u{ebb}ນ", "ວ\u{ebb}ງມ\u{ebb}ນດຳ", "ສ\u{eb5}ດຳ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("juodas apskritimas"),
            keywords: &["geometrija", "juodas apskritimas", "rutulys"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("melns aplis"),
            keywords: &["aplis", "melns aplis", "ģeometrija"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("porohita pango"),
            keywords: &["porohita", "porohita pango", "āhuahanga"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("црн круг"),
            keywords: &["геометрија", "круг", "црн"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("കറ\u{d41}ത\u{d4d}ത വ\u{d43}ത\u{d4d}തം"),
            keywords: &[
                "കറ\u{d41}ത\u{d4d}ത വ\u{d43}ത\u{d4d}തം",
                "ജിയോമെട\u{d4d}രിക\u{d4d}ക\u{d4d}",
                "വട\u{d4d}ടം",
                "വ\u{d43}ത\u{d4d}തം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("хар тойрог"),
            keywords: &["геометр", "тойрог", "хар тойрог"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("काळ\u{947} वर\u{94d}त\u{941}ळ"),
            keywords: &[
                "काळ\u{947} वर\u{94d}त\u{941}ळ",
                "भ\u{942}मितीय",
                "वर\u{94d}त\u{941}ळ",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("bulatan hitam"),
            keywords: &["bulatan", "bulatan hitam", "geometri"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("ċirku iswed"),
            keywords: &["ċirku", "ċirku iswed", "ġeometriku"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အနက\u{103a}ရောင\u{103a} စက\u{103a}ဝ\u{102d}\u{102f}င\u{103a}း"),
            keywords: &[
                "ဂျ\u{102e}ဩမေတြ\u{102e}",
                "စက\u{103a}ဝ\u{102d}\u{102f}င\u{103a}း",
                "အနက\u{103a}ရောင\u{103a} စက\u{103a}ဝ\u{102d}\u{102f}င\u{103a}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("svart sirkel"),
            keywords: &["geometrisk", "sirkel", "svart sirkel"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("कालो घ\u{947}रा"),
            keywords: &["कालो घ\u{947}रा", "घ\u{947}रा", "ज\u{94d}यामितीय"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("zwarte cirkel"),
            keywords: &["cirkel", "geometrisch", "zwarte cirkel"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("svart sirkel"),
            keywords: &["geometrisk", "sirkel", "svart sirkel"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("କଳ\u{b3e} ବ\u{b43}ତ\u{b4d}ତ"),
            keywords: &[
                "କଳ\u{b3e} ବ\u{b43}ତ\u{b4d}ତ",
                "ଜ\u{b4d}ୟ\u{b3e}ମ\u{b3f}ତ\u{b3f}କ",
                "ବ\u{b43}ତ\u{b4d}ତ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਕਾਲਾ ਗ\u{a4b}ਲਾ"),
            keywords: &["ਕਾਲਾ ਗ\u{a4b}ਲਾ", "ਗ\u{a4b}ਲਾ", "ਚ\u{a71}ਕਰ", "ਜਯਾਮਿਤੀ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("کالا چکر"),
            keywords: &["جیومیٹری دے متعلق", "دائرہ", "کالا چکر"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Blák Sẹ\u{301}kul"),
            keywords: &[
                "Blák Sẹ\u{301}kul",
                "Jiọ\u{301}mẹ\u{301}tri",
                "Sẹ\u{301}kul",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("czarne koło"),
            keywords: &["czarne", "figura geometryczna", "koło", "kółko"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("توره دايره"),
            keywords: &["توره دايره", "جيوميتريکي", "دايره"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("círculo preto"),
            keywords: &["círculo", "círculo preto", "geométrico"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["círculo", "círculo preto", "geométrico"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("cerc negru"),
            keywords: &["cerc", "geometric", "negru"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-095"),
            keywords: &["E10-095"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("черный круг"),
            keywords: &["геометрия", "круг", "фигура", "черный", "шар"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("uruziga rw’umukara"),
            keywords: &["jewometiri", "uruziga", "uruziga rw’umukara"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڪارو دائرو"),
            keywords: &["جيوميٽرڪ", "دائرو", "ڪارو دائرو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("කළ\u{dd4} රව\u{dd4}ම"),
            keywords: &[
                "කළ\u{dd4} රව\u{dd4}ම",
                "ජ\u{dca}\u{200d}ය\u{dcf}ම\u{dd2}ත\u{dd2}ක",
                "රව\u{dd4}ම",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("čierny kruh"),
            keywords: &["geometria", "kruh", "čierny kruh"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("črn krog"),
            keywords: &["geometrično", "krog", "črn krog"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("goobo madow"),
            keywords: &["goobo", "goobo madow", "joometriyeed"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("rreth i zi"),
            keywords: &["gjeometri", "rreth", "rreth i zi"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("црни круг"),
            keywords: &["гeoмeтриja", "круг", "црни круг"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("crni krug"),
            keywords: &["crni krug", "geometrija", "krug"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("svart cirkel"),
            keywords: &["cirkel", "geometrisk", "svart cirkel"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mduara mweusi"),
            keywords: &["jiometri", "mduara", "mduara mweusi"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("கருப\u{bcd}பு வட\u{bcd}டம\u{bcd}"),
            keywords: &[
                "கருப\u{bcd}பு வட\u{bcd}டம\u{bcd}",
                "சர\u{bcd}க\u{bcd}கிள\u{bcd}",
                "ஜியோமெட\u{bcd}ரிக\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("నలుపు రంగు వృత\u{c4d}తం"),
            keywords: &["నలుపు రంగు", "నలుపు రంగు వృత\u{c4d}తం", "వృత\u{c4d}తం"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("доираи сиёҳ"),
            keywords: &["геометрӣ", "доира", "доираи сиёҳ"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("วงกลมส\u{e35}ดำ"),
            keywords: &["วงกลม", "วงกลมส\u{e35}ดำ", "ส\u{e35}ดำ"],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ጸሊም ዓንኬል"),
            keywords: &["ዓንኬል", "ጂኦሜትሪክ", "ጸሊም ዓንኬል"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("gara halka"),
            keywords: &["gara halka", "geometrik", "halka"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("fuopotopoto ʻuluʻuli"),
            keywords: &["fuopotopoto", "ʻuluʻuli"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("siyah daire"),
            keywords: &["daire", "geometri", "siyah daire"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("قارا چەمبەر"),
            keywords: &["قارا چەمبەر", "چەمبەر", "گېئومېتىرىيە"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("чорний круг"),
            keywords: &["геометричний", "коло", "чорне", "чорний круг"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("کالا دائرہ"),
            keywords: &["جیومیٹری", "دائرہ", "کالا"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("qora doira"),
            keywords: &["doira", "geometriya", "qora doira"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("hình tròn màu đen"),
            keywords: &["hình học", "hình tròn", "hình tròn màu đen"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("serkal ñuul"),
            keywords: &["serkal", "serkal ñuul", "wu-geometri"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("isangqa esimnyama"),
            keywords: &["ijiyometriki", "isangqa", "isangqa esimnyama"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Rogodo Aláwọ\u{300} dúdú"),
            keywords: &["Rogodo", "Rogodo Aláwọ\u{300} dúdú"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("黑色圓形"),
            keywords: &["圓形", "幾何", "黑色圓形"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("黑色圆形"),
            keywords: &["几何", "圆形", "黑色圆形"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("黑色圆"),
            keywords: &["圈", "黑", "黑色圆"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("黑色圓形"),
            keywords: &["圓形", "黑色圓形"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("黑色大圓圈"),
            keywords: &["圓圈", "黑色", "黑色大圓圈"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("indingilizi emnyama"),
            keywords: &["indingilizi", "indingilizi emnyama", "jiyometrikhi"],
        },
    ],
};
#[doc = "⚪"]
pub const WHITE_CIRCLE: crate::Emoji = crate::Emoji {
    glyph: "⚪",
    codepoint: "26AA",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "white circle",
    group: "Symbols",
    subgroup: "geometric",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("wit sirkel"),
            keywords: &["geometries", "sirkel", "wit"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ነጭ ክብ"),
            keywords: &["ነጭ ክብ", "ክብ", "ጂኦሜትሪያዊ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("دائرة بيضاء"),
            keywords: &["دائرة", "دائرة بيضاء", "هندسي"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("বগ\u{9be} ব\u{9c3}ত\u{9cd}ত"),
            keywords: &[
                "জ\u{9cd}য\u{9be}মিতিক",
                "বগ\u{9be} ব\u{9c3}ত\u{9cd}ত",
                "ব\u{9c3}ত\u{9cd}ত",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("ağ dairə"),
            keywords: &["ağ dairə", "dairə", "həndəsi"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("белы круг"),
            keywords: &["аб’ект", "белы", "геаметрычны", "круг"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Бял кръг"),
            keywords: &["Бял кръг", "геометричен", "кръг"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("স\u{9be}দ\u{9be} ব\u{9c3}ত\u{9cd}ত"),
            keywords: &[
                "জ\u{9cd}য\u{9be}মিতিক",
                "ব\u{9c3}ত\u{9cd}ত",
                "স\u{9be}দ\u{9be} ব\u{9c3}ত\u{9cd}ত",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("bijeli krug"),
            keywords: &["bijeli krug", "geometrija", "krug"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cercle blanc"),
            keywords: &["blanc", "cercle", "geometria"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᏁᎦ ᎦᏕᏯᏍᏛ"),
            keywords: &["ᎤᏁᎦ ᎦᏕᏯᏍᏛ", "ᎤᏙᏢᏒ", "ᎦᏐᏆᎸ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("bílý kroužek"),
            keywords: &["bílá", "bílý kroužek", "geometrie", "kruh"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("cylch gwyn"),
            keywords: &["cylch", "cylch gwyn", "geometrig"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("hvid cirkel"),
            keywords: &["cirkel", "geometrisk", "hvid cirkel"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("weißer Punkt"),
            keywords: &["Ball", "Punkt", "weiß", "weißer Punkt"],
        },
        #[cfg(feature = "de_CH")]
        crate::Annotation {
            lang: "de_CH",
            tts: Some("Grosser weisser Kreis"),
            keywords: &["Ball", "Grosser weisser Kreis", "Kreis", "weiss"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("λευκός κύκλος"),
            keywords: &["γεωμετρικό", "κύκλος", "λευκός κύκλος"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("white circle"),
            keywords: &["circle", "geometric", "white circle"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("círculo blanco"),
            keywords: &["círculo", "círculo blanco", "geometría"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["círculo", "círculo blanco", "geométrico"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("valge ring"),
            keywords: &["geomeetria", "ring", "valge ring"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("zirkulu zuria"),
            keywords: &["geometriko", "zirkulu", "zirkulu zuria"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("دایره سفید"),
            keywords: &["دایره", "دایره سفید", "شکل هندسی"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("valkoinen ympyrä"),
            keywords: &["muoto", "valkoinen ympyrä", "ympyrä"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("puting bilog"),
            keywords: &["bilog", "hugis", "puti", "puting bilog"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("hvítur sirkul"),
            keywords: &["hvítur", "mátingarfrøði", "sirkul"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("disque blanc"),
            keywords: &[
                "blanc",
                "cercle",
                "disque blanc",
                "forme géométrique",
                "géométrie",
                "rond",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("rond blanc"),
            keywords: &["blanc", "cercle", "disque", "géométrie", "rond", "sphère"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("ciorcal bán"),
            keywords: &["ciorcal", "ciorcal bán", "geoiméadrach"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("cearcall geal"),
            keywords: &["cearcall", "cearcall geal", "geomatrach"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("círculo branco"),
            keywords: &["branco", "círculo"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("સફ\u{ac7}દ ગોળ"),
            keywords: &["ગોળ", "ભૌમિતિક", "સફ\u{ac7}દ ગોળ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("farin da’ira"),
            keywords: &["da’ira", "farin da’ira", "ilimin halayen sura"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("עיגול לבן"),
            keywords: &["לבן", "עיגול", "צורה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("सफ\u{93c}\u{947}द व\u{943}त\u{94d}त"),
            keywords: &[
                "ज\u{94d}यामिति",
                "सफ\u{93c}\u{947}द व\u{943}त\u{94d}त",
                "सफ\u{947}द व\u{943}त\u{94d}त",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("bijeli krug"),
            keywords: &["bijeli krug", "geometrija", "krug"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("fehér kör"),
            keywords: &["alakzat", "fehér kör", "kör"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("սպիտակ շրջան"),
            keywords: &["երկրաչափական", "շրջան", "սպիտակ շրջան"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("lingkaran putih"),
            keywords: &["geometri", "lingkaran", "lingkaran putih"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("okirikiri ọcha"),
            keywords: &["mgbakọ", "okirikiri", "okirikiri ọcha"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("hvítur hringur"),
            keywords: &["hringur", "hvítur", "rúmfræði"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("cerchio bianco"),
            keywords: &["bianco", "cerchio", "geometria"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("白い丸"),
            keywords: &["丸", "丸いボタン", "白", "白い丸"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("bunderan putih"),
            keywords: &["bunder", "bunderan putih", "geometrik"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("თეთრი წრე"),
            keywords: &["გეომეტრია", "გეომეტრიული", "თეთრი წრე", "რგოლი", "წრე"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("ақ дөңгелек"),
            keywords: &["ақ дөңгелек", "геометриялық", "шеңбер"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("hvid cirkel"),
            keywords: &["cirkel", "geometrisk", "hvid cirkel"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("រង\u{17d2}វង\u{17cb}ពណ\u{17cc}ស"),
            keywords: &[
                "ពណ\u{17cc}",
                "រង\u{17d2}វង\u{17cb}",
                "រង\u{17d2}វង\u{17cb}ពណ\u{17cc}ស",
                "ស",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಬ\u{cbf}ಳ\u{cbf} ವೃತ\u{ccd}ತ"),
            keywords: &[
                "ದೊಡ\u{ccd}ಡ ಬ\u{cbf}ಳ\u{cbf} ವೃತ\u{ccd}ತ",
                "ಬ\u{cbf}ಳ\u{cbf} ವೃತ\u{ccd}ತ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("흰색 원"),
            keywords: &["동그라미", "원", "흰색 원"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("धव\u{947}\u{902} वर\u{94d}त\u{941}ळ"),
            keywords: &[
                "जियोम\u{945}ट\u{94d}रीक",
                "धव\u{947}\u{902} वर\u{94d}त\u{941}ळ",
                "वर\u{94d}त\u{941}ळ",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("ак тегерек"),
            keywords: &["ак тегерек", "геометрия", "тегерек"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("wäisse Krees"),
            keywords: &["Krees", "geometresch", "wäisse Krees"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ວ\u{ebb}ງມ\u{ebb}ນຂາວ"),
            keywords: &["ວ\u{ebb}ງມ\u{ebb}ນ", "ວ\u{ebb}ງມ\u{ebb}ນຂາວ", "ສ\u{eb5}ຂາວ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("baltas apskritimas"),
            keywords: &["baltas apskritimas", "geometrija", "rutulys"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("balts aplis"),
            keywords: &["aplis", "balts aplis", "ģeometrija"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("porohita mā"),
            keywords: &["porohita", "porohita mā", "āhuahanga"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("бел круг"),
            keywords: &["бел", "геометрија", "круг"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("വെള\u{d41}ത\u{d4d}ത വ\u{d43}ത\u{d4d}തം"),
            keywords: &[
                "ജിയോമെട\u{d4d}രിക\u{d4d}ക\u{d4d}",
                "വട\u{d4d}ടം",
                "വ\u{d43}ത\u{d4d}തം",
                "വെള\u{d41}ത\u{d4d}ത വ\u{d43}ത\u{d4d}തം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("цагаан тойрог"),
            keywords: &["геометр", "тойрог", "цагаан тойрог"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("पा\u{902}ढर\u{947} वर\u{94d}त\u{941}ळ"),
            keywords: &[
                "पा\u{902}ढर\u{947} वर\u{94d}त\u{941}ळ",
                "भ\u{942}मितीय",
                "वर\u{94d}त\u{941}ळ",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("bulatan putih"),
            keywords: &["bulatan", "bulatan putih", "geometri"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("ċirku abjad"),
            keywords: &["ċirku", "ċirku abjad", "ġeometriku"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အဖြ\u{1030}ရောင\u{103a} စက\u{103a}ဝ\u{102d}\u{102f}င\u{103a}း"),
            keywords: &[
                "ဂျ\u{102e}ဩမေတြ\u{102e}",
                "စက\u{103a}ဝ\u{102d}\u{102f}င\u{103a}း",
                "အဖြ\u{1030}ရောင\u{103a} စက\u{103a}ဝ\u{102d}\u{102f}င\u{103a}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("hvit sirkel"),
            keywords: &["geometrisk", "hvit sirkel", "sirkel"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("स\u{947}तो घ\u{947}रा"),
            keywords: &["घ\u{947}रा", "ज\u{94d}यामितीय", "स\u{947}तो घ\u{947}रा"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("witte cirkel"),
            keywords: &["cirkel", "geometrisch", "witte cirkel"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("kvit sirkel"),
            keywords: &["geometrisk", "kvit sirkel", "sirkel"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଧଳ\u{b3e} ବ\u{b43}ତ\u{b4d}ତ"),
            keywords: &[
                "ଜ\u{b4d}ୟ\u{b3e}ମ\u{b3f}ତ\u{b3f}କ",
                "ଧଳ\u{b3e} ବ\u{b43}ତ\u{b4d}ତ",
                "ବ\u{b43}ତ\u{b4d}ତ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਚਿ\u{a71}ਟਾ ਗ\u{a4b}ਲਾ"),
            keywords: &[
                "ਗ\u{a4b}ਲਾ",
                "ਚਿ\u{a71}ਟਾ ਗ\u{a4b}ਲਾ",
                "ਚ\u{a71}ਕਰ",
                "ਜਯਾਮਿਤੀ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("چٹ\u{651}ا چکر"),
            keywords: &["جیومیٹری دے متعلق", "دائرہ", "چٹ\u{651}ا چکر"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Waít Sẹ\u{301}kul"),
            keywords: &[
                "Jiọ\u{301}mẹ\u{301}tri",
                "Sẹ\u{301}kul",
                "Waít Sẹ\u{301}kul",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("białe koło"),
            keywords: &["białe", "figura geometryczna", "koło", "kółko"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("سپينه دايره"),
            keywords: &["جيوميتريکي", "دايره", "سپينه دايره"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("círculo branco"),
            keywords: &["círculo", "círculo branco", "geométrico"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["círculo", "círculo branco", "geométrico"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("cerc alb"),
            keywords: &["alb", "cerc", "geometric"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-094"),
            keywords: &["E10-094"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("белый круг"),
            keywords: &["белый", "геометрия", "круг", "фигура", "шар"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("uruziga rw’umweru"),
            keywords: &["jewometiri", "uruziga", "uruziga rw’umweru"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("اڇو دائرو"),
            keywords: &["اڇو دائرو", "جيوميٽرڪ", "دائرو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ස\u{dd4}ද\u{dd4} රව\u{dd4}ම"),
            keywords: &[
                "ජ\u{dca}\u{200d}ය\u{dcf}ම\u{dd2}ත\u{dd2}ක",
                "රව\u{dd4}ම",
                "ස\u{dd4}ද\u{dd4} රව\u{dd4}ම",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("biely kruh"),
            keywords: &["biely kruh", "geometria", "kruh"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("bel krog"),
            keywords: &["bel krog", "geometrično", "krog"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("goobo cad"),
            keywords: &["goobo", "goobo cad", "joometriyeed"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("rreth i bardhë"),
            keywords: &["gjeometrik", "rreth", "rreth i bardhë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("бели круг"),
            keywords: &["бели круг", "гeoмeтриja", "круг"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("бијели круг"),
            keywords: &["бијели круг"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("beli krug"),
            keywords: &["beli krug", "geometrija", "krug"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("bijeli krug"),
            keywords: &["bijeli krug"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("vit cirkel"),
            keywords: &["cirkel", "geometrisk", "vit cirkel"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mduara mweupe"),
            keywords: &["jiometri", "mduara", "mduara mweupe"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("வெள\u{bcd}ளை வட\u{bcd}டம\u{bcd}"),
            keywords: &[
                "ஜியோமெட\u{bcd}ரிக\u{bcd}",
                "வட\u{bcd}டம\u{bcd}",
                "வெள\u{bcd}ளை வட\u{bcd}டம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("త\u{c46}లుపు రంగు వృత\u{c4d}తం"),
            keywords: &[
                "త\u{c46}లుపు రంగు",
                "త\u{c46}లుపు రంగు వృత\u{c4d}తం",
                "వృత\u{c4d}తం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("доираи сафед"),
            keywords: &["геометрӣ", "доира", "доираи сафед"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("วงกลมส\u{e35}ขาว"),
            keywords: &["วงกลม", "วงกลมส\u{e35}ขาว", "ส\u{e35}ขาว"],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ጻዕዳ ዓንኬል"),
            keywords: &["ዓንኬል", "ጂኦሜትሪክ", "ጻዕዳ ዓንኬል"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ak halka"),
            keywords: &["ak halka", "geometrik", "halka"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("fuopotopoto hinehina"),
            keywords: &["fuopotopoto", "hinehina"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("beyaz daire"),
            keywords: &["beyaz daire", "daire", "geometri"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئاق چەمبەر"),
            keywords: &["ئاق چەمبەر", "چەمبەر", "گېئومېتىرىيە"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("білий круг"),
            keywords: &["біле", "білий круг", "геометричний", "коло"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("سفید دائرہ"),
            keywords: &["جیومیٹری", "دائرہ", "سفید"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("oq doira"),
            keywords: &["doira", "geometriya", "oq doira"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("hình tròn màu trắng"),
            keywords: &["hình học", "hình tròn", "hình tròn màu trắng"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("serkal bu weex"),
            keywords: &["serkal", "serkal bu weex", "wu-geometri"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("isangqa esimhlophe"),
            keywords: &["ijiyometriki", "isangqa", "isangqa esimhlophe"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Rogodo Funfun"),
            keywords: &["Rogodo", "Rogodo Funfun"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("白色圓形"),
            keywords: &["圓形", "幾何", "白色圓形"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("白色圆形"),
            keywords: &["几何", "圆形", "白色圆形"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("白色圆"),
            keywords: &["圈", "白", "白色圆"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("白色圓形"),
            keywords: &["圓形", "白色圓形"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("白色大圓圈"),
            keywords: &["圓圈", "白色", "白色大圓圈"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("indingilizi emhlophe"),
            keywords: &["indingilizi", "indingilizi emhlophe", "jiyometrikhi"],
        },
    ],
};
#[doc = "🟥"]
pub const RED_SQUARE: crate::Emoji = crate::Emoji {
    glyph: "🟥",
    codepoint: "1F7E5",
    status: crate::Status::FullyQualified,
    introduction_version: 12f32,
    name: "red square",
    group: "Symbols",
    subgroup: "geometric",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("rooi vierkant"),
            keywords: &["rooi", "vierkant"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ቀይ አራት ማእዝን"),
            keywords: &["ቀይ", "ቀይ አራት ማእዝን", "አራት ማእዝን"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("مربع أحمر"),
            keywords: &["أحمر", "مربع"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ৰঙ\u{9be} বৰ\u{9cd}গ"),
            keywords: &["বৰ\u{9cd}গ", "ৰঙ\u{9be}"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("qırmızı kvadrat"),
            keywords: &["qırmızı", "qırmızı kvadrat", "çevrə"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("чырвоны квадрат"),
            keywords: &["квадрат", "чырвоны"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("червен квадрат"),
            keywords: &["квадрат", "червен квадрат", "червено"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ল\u{9be}ল বর\u{9cd}গক\u{9cd}ষেত\u{9cd}র"),
            keywords: &["বর\u{9cd}গক\u{9cd}ষেত\u{9cd}র", "ল\u{9be}ল"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("karrez ruz"),
            keywords: &["karrez", "ruz"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("crveni kvadrat"),
            keywords: &["crvena", "crveni kvadrat", "kvadrat"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("quadrat vermell"),
            keywords: &["quadrat", "vermell"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎩᎦᎨ ᏅᎩ ᏧᏅᏏᏯ"),
            keywords: &["ᎩᎦᎨ", "ᎩᎦᎨ ᏅᎩ ᏧᏅᏏᏯ", "ᏅᎩ ᏧᏅᏏᏯ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("červený čtvereček"),
            keywords: &["červená", "červený čtvereček", "čtverec", "čtvereček"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("sgwâr coch"),
            keywords: &["coch", "sgwâr"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("rød firkant"),
            keywords: &["firkant", "rød"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("rotes Quadrat"),
            keywords: &["Quadrat", "rot", "rotes Quadrat"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κόκκινο τετράγωνο"),
            keywords: &["κόκκινο", "τετράγωνο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("red square"),
            keywords: &["red", "square"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("cuadrado rojo"),
            keywords: &["cuadrado", "rojo"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("punane ruut"),
            keywords: &["nelinurk", "punane", "ruut"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("karratu gorria"),
            keywords: &["gorri", "karratu", "karratu gorria"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("مربع سرخ"),
            keywords: &["سرخ", "قرمز", "مربع"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("punainen neliö"),
            keywords: &["neliö", "punainen"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("pulang parisukat"),
            keywords: &["parisukat", "pula", "pulang parisukat"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("reyður fýrakantur"),
            keywords: &["fýrakantur", "reytt", "reyður"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("carré rouge"),
            keywords: &["carré rouge", "forme géométrique", "géométrie", "rouge"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["carré", "rouge"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("cearnóg dhearg"),
            keywords: &["cearnóg dhearg"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("ceàrnach dearg"),
            keywords: &["ceàrnach", "dearg"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cadrado vermello"),
            keywords: &["cadrado", "vermello"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("લાલ ચોરસ"),
            keywords: &["ચોરસ", "લાલ"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("ריבוע אדום"),
            keywords: &["אדום", "מרובע", "ריבוע"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("लाल वर\u{94d}ग"),
            keywords: &["आक\u{943}ति", "ज\u{94d}यामिति", "लाल", "वर\u{94d}ग"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("crveni kvadrat"),
            keywords: &["crveni", "kvadrat"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("vörös négyzet"),
            keywords: &["négyzet", "vörös"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("կարմիր քառակուսի"),
            keywords: &["կարմիր", "քառակուսի"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("persegi merah"),
            keywords: &["merah", "persegi"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("rauður ferningur"),
            keywords: &["ferningur", "rauður"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("quadrato rosso"),
            keywords: &["quadrato", "quadrato di colore rosso", "rosso"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("赤い四角"),
            keywords: &["四角", "正方形", "赤", "赤い四角"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("kothak abang"),
            keywords: &["abang", "kothak"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("წითელი კვადრატი"),
            keywords: &["კვადრატი", "წითელი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("қызыл шаршы"),
            keywords: &["шаршы", "қызыл"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ការ\u{17c9}េ\u{200b}ពណ\u{17cc}ក\u{17d2}រហម"),
            keywords: &[
                "ការ\u{17c9}េ",
                "ការ\u{17c9}េ\u{200b}ពណ\u{17cc}ក\u{17d2}រហម",
                "ពណ\u{17cc}ក\u{17d2}រហម",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕ\u{cc6}ಂಪು ಚ\u{ccc}ಕ"),
            keywords: &["ಕ\u{cc6}ಂಪು", "ಚ\u{ccc}ಕ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("빨간색 사각형"),
            keywords: &["빨간색", "사각형"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("ता\u{902}बडो चवकोन"),
            keywords: &["चवकोन", "ता\u{902}बडो"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("кызыл квадрат"),
            keywords: &["квадрат", "кызыл"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ສ\u{eb5}\u{ec8}ຫ\u{ebc}\u{ec8}ຽມ\u{200b}ແດງ"),
            keywords: &[
                "ສ\u{eb5}\u{ec8}ຫ\u{ebc}\u{ec8}ຽມ",
                "ສ\u{eb5}\u{ec8}ຫ\u{ebc}\u{ec8}ຽມ\u{200b}ແດງ",
                "ສ\u{eb5}\u{200b}ແດງ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("raudonas kvadratas"),
            keywords: &["kvadratas", "raudonas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("sarkans kvadrāts"),
            keywords: &["kvadrāts", "sarkans"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("црвен квадрат"),
            keywords: &["квадрат", "црвен"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ച\u{d41}വന\u{d4d}ന ചത\u{d41}രം"),
            keywords: &[
                "ചത\u{d41}രം",
                "ച\u{d41}വന\u{d4d}ന ചത\u{d41}രം",
                "ച\u{d41}വപ\u{d4d}പ\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("улаан дөрвөлжин"),
            keywords: &["дөрвөлжин", "улаан"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("लाल चौकोन"),
            keywords: &["चौकोन", "लाल"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("persegi merah"),
            keywords: &["merah", "persegi"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အန\u{102e}ရောင\u{103a} စတ\u{102f}ရမ\u{103a}းက\u{103d}က\u{103a}"),
            keywords: &[
                "စတ\u{102f}ရမ\u{103a}းက\u{103d}က\u{103a}",
                "အန\u{102e}ရောင\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("rødt kvadrat"),
            keywords: &["kvadrat", "rød", "rødt"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("रातो वर\u{94d}ग"),
            keywords: &["रातो", "वर\u{94d}ग"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("rood vierkant"),
            keywords: &["rood", "vierkant"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("raudt kvadrat"),
            keywords: &["kvadrat", "raud", "raudt"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଲ\u{b3e}ଲ ବର\u{b4d}ଗକ\u{b4d}ଷେତ\u{b4d}ର"),
            keywords: &["ବର\u{b4d}ଗକ\u{b4d}ଷେତ\u{b4d}ର", "ଲ\u{b3e}ଲ"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਲਾਲ ਵਰਗ"),
            keywords: &["ਲਾਲ", "ਵਰਗ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Rẹ\u{301}d Skwea"),
            keywords: &["Rẹd", "Rẹ\u{301}d Skwea", "Skwea"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("czerwony kwadrat"),
            keywords: &["czerwony", "kwadrat", "kwadratowy"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("سره مربع"),
            keywords: &["سره", "مربع"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("quadrado vermelho"),
            keywords: &["quadrado", "vermelho"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("pătrat roșu"),
            keywords: &["pătrat", "roșu"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E12–015"),
            keywords: &["E12–015"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("красный квадрат"),
            keywords: &["геометрия", "квадрат", "красный", "прямоугольник", "фигура"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڳاڙهو چورس"),
            keywords: &["دائرو", "ڳاڙهو", "ڳاڙهو چورس"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("රත\u{dd4} චත\u{dd4}රස\u{dca}\u{200d}රය"),
            keywords: &["චත\u{dd4}රස\u{dca}\u{200d}රය", "රත\u{dd4}"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("červený štvorec"),
            keywords: &["červená", "červený štvorec", "štvorec", "štvorček"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("rdeč kvadrat"),
            keywords: &["kvadrat", "rdeč"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("afar geeska casaanka ah"),
            keywords: &["afar gees", "afar geeska casaanka ah", "casaan"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("katror i kuq"),
            keywords: &["i kuq", "katror", "katror i kuq"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("црвени квадрат"),
            keywords: &["квадрат", "црвени квадрат", "црвено"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["црвени квадрат"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("crveni kvadrat"),
            keywords: &["crveni kvadrat", "crveno", "kvadrat"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["crveni kvadrat"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("röd kvadrat"),
            keywords: &["kvadrat", "röd"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mraba mwekundu"),
            keywords: &["mraba", "mraba mwekundu", "nyekundu"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("சிவப\u{bcd}பு சதுரம\u{bcd}"),
            keywords: &["சதுரம\u{bcd}", "சிவப\u{bcd}பு"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ఎరుపురంగు చతురస\u{c4d}రం"),
            keywords: &["ఎరుపురంగు", "చతురస\u{c4d}రం"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ส\u{e35}\u{e48}เหล\u{e35}\u{e48}ยมส\u{e35}แดง"),
            keywords: &[
                "ส\u{e35}แดง",
                "ส\u{e35}\u{e48}เหล\u{e35}\u{e48}ยม",
                "ส\u{e35}\u{e48}เหล\u{e35}\u{e48}ยมส\u{e35}แดง",
            ],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ቀይሕ ትርብዒት"),
            keywords: &["ቀይሕ", "ትርብዒት"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("gyzyl inedördül"),
            keywords: &["gyzyl", "inedördül"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tapafā kulokula"),
            keywords: &["kulokula", "tapafā"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("kırmızı kare"),
            keywords: &["kare", "kırmızı"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("червоний квадрат"),
            keywords: &["квадрат", "червоний"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("سرخ چوکور"),
            keywords: &["سرخ", "چوکور"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("qizil kvadrat"),
            keywords: &["aylana", "doira", "qizil", "qizil kvadrat"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("hình vuông màu đỏ"),
            keywords: &["hình vuông", "hình vuông màu đỏ", "màu đỏ", "ô vuông"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("紅色正方形"),
            keywords: &["正方形", "紅色", "紅色正方形"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("红色正方形"),
            keywords: &["正方形", "红色", "红色正方形"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("红色方块"),
            keywords: &["方块", "方框", "正方形", "红", "红色方块"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("紅色方形"),
            keywords: &["方形", "紅色", "紅色方形"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("紅色正方形"),
            keywords: &["正方形", "紅色", "紅色正方形"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("isikwele esibomvu"),
            keywords: &["isikwele", "isikwele esibomvu", "okubomvu"],
        },
    ],
};
#[doc = "🟧"]
pub const ORANGE_SQUARE: crate::Emoji = crate::Emoji {
    glyph: "🟧",
    codepoint: "1F7E7",
    status: crate::Status::FullyQualified,
    introduction_version: 12f32,
    name: "orange square",
    group: "Symbols",
    subgroup: "geometric",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("oranje vierkant"),
            keywords: &["oranje", "vierkant"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ብርቱካናማ አራት ማእዝን"),
            keywords: &["ብርቱካናማ", "ብርቱካናማ አራት ማእዝን", "አራት ማእዝን"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("مربع برتقالي"),
            keywords: &["برتقالي", "مربع"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("কমল\u{9be}ৰঙী বৰ\u{9cd}গ"),
            keywords: &["কমল\u{9be} ৰং", "কমল\u{9be}ৰঙী বৰ\u{9cd}গ", "বৰ\u{9cd}গ"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("narıncı kvadrat"),
            keywords: &["kvadrat", "narıncı"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("аранжавы квадрат"),
            keywords: &["аранжавы", "квадрат"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("оранжев квадрат"),
            keywords: &["квадрат", "оранжев квадрат", "оранжево"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("কমল\u{9be} বর\u{9cd}গক\u{9cd}ষেত\u{9cd}র"),
            keywords: &["কমল\u{9be}", "বর\u{9cd}গক\u{9cd}ষেত\u{9cd}র"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("karrez orañjez"),
            keywords: &["karrez", "orañjez"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("narandžasti kvadrat"),
            keywords: &["kvadrat", "narandžasta", "narandžasti kvadrat"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("quadrat taronja"),
            keywords: &["quadrat", "taronja"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏓᎶᏂᎨ ᏅᎩ ᏧᏅᏏᏯ"),
            keywords: &["ᎠᏓᎶᏂᎨ", "ᎠᏓᎶᏂᎨ ᏅᎩ ᏧᏅᏏᏯ", "ᏅᎩ ᏧᏅᏏᏯ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("oranžový čtvereček"),
            keywords: &["oranžová", "oranžový čtvereček", "čtverec", "čtvereček"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("sgwâr oren"),
            keywords: &["oren", "sgwâr"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("orange firkant"),
            keywords: &["firkant", "orange"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("oranges Quadrat"),
            keywords: &["Quadrat", "orange", "oranges Quadrat"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("πορτοκαλί τετράγωνο"),
            keywords: &["πορτοκαλί", "τετράγωνο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("orange square"),
            keywords: &["orange", "square"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("cuadrado naranja"),
            keywords: &["cuadrado", "naranja"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("oranž ruut"),
            keywords: &["nelinurk", "oranž", "ruut"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("karratu laranja"),
            keywords: &["karratu", "laranja"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("مربع نارنجی"),
            keywords: &["مربع", "نارنجی"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("oranssi neliö"),
            keywords: &["neliö", "oranssi"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("orange na parisukat"),
            keywords: &["orange", "orange na parisukat", "parisukat"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("appilsingulur fýrakantur"),
            keywords: &["appilsingult", "appilsingulur", "fýrakantur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("carré orange"),
            keywords: &["carré orange", "forme géométrique", "géométrie", "orange"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["carré", "orange"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("cearnóg fhlannbhuí"),
            keywords: &["cearnóg", "cearnóg fhlannbhuí", "flannbhuí", "oráiste"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("ceàrnach orainds"),
            keywords: &["ceàrnach", "orainds", "orains"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cadrado laranxa"),
            keywords: &["cadrado", "laranxa"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("નાર\u{a82}ગી ચોરસ"),
            keywords: &["ચોરસ", "નાર\u{a82}ગી"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("ריבוע כתום"),
            keywords: &["כתום", "מרובע", "ריבוע"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("नार\u{902}गी र\u{902}ग का वर\u{94d}ग"),
            keywords: &[
                "आक\u{943}ति",
                "ज\u{94d}यामिति",
                "नार\u{902}गी र\u{902}ग",
                "नार\u{902}गी र\u{902}ग का वर\u{94d}ग",
                "वर\u{94d}ग",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("narančasti kvadrat"),
            keywords: &["kvadrat", "narančasti"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("narancssárga négyzet"),
            keywords: &["narancssárga", "négyzet"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("նարնջագույն քառակուսի"),
            keywords: &["նարնջագույն", "քառակուսի"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("persegi oranye"),
            keywords: &["oranye", "persegi"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("appelsínugulur ferningur"),
            keywords: &["appelsínugulur", "ferningur"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("quadrato arancione"),
            keywords: &["arancione", "quadrato", "quadrato di colore arancione"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("オレンジの四角"),
            keywords: &["オレンジ", "オレンジの四角", "四角", "正方形"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("kothak kunir"),
            keywords: &["kothak", "kunir"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ნარინჯისფერი კვადრატი"),
            keywords: &["კვადრატი", "ნარინჯისფერი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("қызғылт сары шаршы"),
            keywords: &["шаршы", "қызғылт сары", "қызғылт сары шаршы"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ការ\u{17c9}េ\u{200b}ពណ\u{17cc}ទ\u{17b9}កក\u{17d2}រ\u{17bc}ច"),
            keywords: &[
                "ការ\u{17c9}េ",
                "ការ\u{17c9}េ\u{200b}ពណ\u{17cc}ទ\u{17b9}កក\u{17d2}រ\u{17bc}ច",
                "ពណ\u{17cc}ទ\u{17b9}កក\u{17d2}រ\u{17bc}ច",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕ\u{cbf}ತ\u{ccd}ತಳ\u{cc6}ಬಣ\u{ccd}ಣದ ಚ\u{ccc}ಕ"),
            keywords: &[
                "ಕ\u{cbf}ತ\u{ccd}ತಳ\u{cc6}ಬಣ\u{ccd}ಣ",
                "ಕ\u{cbf}ತ\u{ccd}ತಳ\u{cc6}ಬಣ\u{ccd}ಣದ ಚ\u{ccc}ಕ",
                "ಚ\u{ccc}ಕ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("오렌지색 사각형"),
            keywords: &["사각형", "오렌지색"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("नार\u{902}गी चवकोन"),
            keywords: &["चवकोन", "नार\u{902}गी"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("кызгылт сары квадрат"),
            keywords: &["квадрат", "кызгыл сары", "кызгылт сары квадрат"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ສ\u{eb5}\u{ec8}ຫ\u{ebc}\u{ec8}ຽມ\u{200b}ສ\u{ebb}\u{ec9}ມ"),
            keywords: &[
                "ສ\u{eb5}\u{ec8}ຫ\u{ebc}\u{ec8}ຽມ",
                "ສ\u{eb5}\u{ec8}ຫ\u{ebc}\u{ec8}ຽມ\u{200b}ສ\u{ebb}\u{ec9}ມ",
                "ສ\u{eb5}\u{200b}ສ\u{ebb}\u{ec9}ມ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("oranžinis kvadratas"),
            keywords: &["kvadratas", "oranžinis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("oranžs kvadrāts"),
            keywords: &["kvadrāts", "oranžs"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("портокалов квадрат"),
            keywords: &["квадрат", "портокалов"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഓറഞ\u{d4d}ച\u{d4d} ചത\u{d41}രം"),
            keywords: &["ഓറഞ\u{d4d}ച\u{d4d}", "ചത\u{d41}രം"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("улбар шар дөрвөлжин"),
            keywords: &["дөрвөлжин", "улбар шар", "улбар шар дөрвөлжин"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("नारि\u{902}गी चौकोन"),
            keywords: &["चौकोन", "नारि\u{902}गी"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("persegi jingga"),
            keywords: &["jingga", "persegi"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "လ\u{102d}မ\u{1039}မော\u{103a}ရောင\u{103a} စတ\u{102f}ရမ\u{103a}းက\u{103d}က\u{103a}",
            ),
            keywords: &[
                "စတ\u{102f}ရမ\u{103a}းက\u{103d}က\u{103a}",
                "လ\u{102d}မ\u{1039}မောရောင\u{103a}",
                "လ\u{102d}မ\u{1039}မော\u{103a}ရောင\u{103a} စတ\u{102f}ရမ\u{103a}းက\u{103d}က\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("oransje kvadrat"),
            keywords: &["kvadrat", "oransje"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("स\u{941}न\u{94d}तला वर\u{94d}ग"),
            keywords: &["वर\u{94d}ग", "स\u{941}न\u{94d}तला"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("oranje vierkant"),
            keywords: &["oranje", "vierkant"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("oransje kvadrat"),
            keywords: &["kvadrat", "oransje"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("କମଳ\u{b3e} ବର\u{b4d}ଗକ\u{b4d}ଷେତ\u{b4d}ର"),
            keywords: &["କମଳ\u{b3e}", "ବର\u{b4d}ଗକ\u{b4d}ଷେତ\u{b4d}ର"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਸ\u{a70}ਤਰੀ ਵਰਗ"),
            keywords: &["ਵਰਗ", "ਸ\u{a70}ਤਰੀ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Ọ\u{301}rénj Kọ\u{301}lọ Skwea"),
            keywords: &[
                "Skwea",
                "Ọ\u{301}rénj Kọ\u{301}lọ",
                "Ọ\u{301}rénj Kọ\u{301}lọ Skwea",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("pomarańczowy kwadrat"),
            keywords: &["kwadrat", "kwadratowy", "pomarańczowy"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("نارنجي مربع"),
            keywords: &["مربع", "نارنجي"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("quadrado laranja"),
            keywords: &["laranja", "quadrado"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("quadrado cor de laranja"),
            keywords: &["cor de laranja", "quadrado", "quadrado cor de laranja"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("pătrat portocaliu"),
            keywords: &["portocaliu", "pătrat"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E12–017"),
            keywords: &["E12–017"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("оранжевый квадрат"),
            keywords: &[
                "геометрия",
                "квадрат",
                "оранжевый",
                "прямоугольник",
                "фигура",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("نارنگي چورس"),
            keywords: &["نارنگي", "چورس"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("තැඹ\u{dd2}ල\u{dd2} චත\u{dd4}රස\u{dca}\u{200d}රය"),
            keywords: &["චත\u{dd4}රස\u{dca}\u{200d}රය", "තැඹ\u{dd2}ල\u{dd2}"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("oranžový štvorec"),
            keywords: &["oranžová", "oranžový štvorec", "štvorec", "štvorček"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("oranžen kvadrat"),
            keywords: &["kvadrat", "oranžen"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("afar geeska oranjiga ah"),
            keywords: &["afar geeska", "afar geeska oranjiga ah", "oranjiga"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("katror i portokalltë"),
            keywords: &["i portokalltë", "katror", "katror i portokalltë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("наранџасти квадрат"),
            keywords: &["квадрат", "наранџасти квадрат", "наранџасто"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["наранџасти квадрат"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("narandžasti kvadrat"),
            keywords: &["kvadrat", "narandžasti kvadrat", "narandžasto"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["narandžasti kvadrat"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("orange kvadrat"),
            keywords: &["kvadrat", "orange"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mraba wa chungwa"),
            keywords: &["chungwa", "mraba", "mraba wa chungwa"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ஆரஞ\u{bcd}சு சதுரம\u{bcd}"),
            keywords: &["ஆரஞ\u{bcd}சு", "சதுரம\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("న\u{c3e}ర\u{c3f}ంజరంగు చతురస\u{c4d}రం"),
            keywords: &["చతురస\u{c4d}రం", "న\u{c3e}ర\u{c3f}ంజరంగు"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ส\u{e35}\u{e48}เหล\u{e35}\u{e48}ยมส\u{e35}ส\u{e49}ม"),
            keywords: &[
                "ส\u{e35}ส\u{e49}ม",
                "ส\u{e35}\u{e48}เหล\u{e35}\u{e48}ยม",
                "ส\u{e35}\u{e48}เหล\u{e35}\u{e48}ยมส\u{e35}ส\u{e49}ม",
            ],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ኣራንሾኒ ትርብዒት"),
            keywords: &["ትርብዒት", "ኣራንሾኒ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("narynç inedördül"),
            keywords: &["inedördül", "narynç"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tapafā lanumoli"),
            keywords: &["lanumoli", "tapafā"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("turuncu kare"),
            keywords: &["kare", "turuncu"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("оранжевий квадрат"),
            keywords: &["квадрат", "оранжевий"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("نارنجی چوکور"),
            keywords: &["نارنجی", "چوکور"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("apelsinrang kvadrat"),
            keywords: &["apelsinrang", "kvadrat", "toʻrtburchak"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("hình vuông màu cam"),
            keywords: &[
                "da cam",
                "hình vuông",
                "hình vuông màu cam",
                "màu cam",
                "ô vuông",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("橙色正方形"),
            keywords: &["橙色", "橙色正方形", "正方形"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("橙色正方形"),
            keywords: &["橙色", "橙色正方形", "正方形"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("橙色方块"),
            keywords: &["方块", "方框", "橙", "橙色方块", "正方形"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("橘色方形"),
            keywords: &["方形", "橘色", "橘色方形"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("橙色正方形"),
            keywords: &["橙色", "橙色正方形", "正方形"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("isikwele esi-orange"),
            keywords: &["isikwele", "isikwele esi-orange", "orange"],
        },
    ],
};
#[doc = "🟨"]
pub const YELLOW_SQUARE: crate::Emoji = crate::Emoji {
    glyph: "🟨",
    codepoint: "1F7E8",
    status: crate::Status::FullyQualified,
    introduction_version: 12f32,
    name: "yellow square",
    group: "Symbols",
    subgroup: "geometric",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("geel vierkant"),
            keywords: &["geel", "vierkant"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ቢጫ አራት ማእዝን"),
            keywords: &["ቢጫ", "ቢጫ አራት ማእዝን", "አራት ማእዝን"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("مربع أصفر"),
            keywords: &["أصفر", "مربع"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("হ\u{9be}লধীয\u{9bc}\u{9be} বৰ\u{9cd}গ"),
            keywords: &["বৰ\u{9cd}গ", "হ\u{9be}লধীয\u{9bc}\u{9be}"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("sarı kvadrat"),
            keywords: &["kvadrat", "sarı"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("жоўты квадрат"),
            keywords: &["жоўты", "квадрат"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("жълт квадрат"),
            keywords: &["жълт квадрат", "жълто", "квадрат"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("হল\u{9c1}দ বর\u{9cd}গক\u{9cd}ষেত\u{9cd}র"),
            keywords: &["বর\u{9cd}গক\u{9cd}ষেত\u{9cd}র", "হল\u{9c1}দ"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("karrez melen"),
            keywords: &["karrez", "melen"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("žuti kvadrat"),
            keywords: &["kvadrat", "žuta", "žuti kvadrat"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("quadrat groc"),
            keywords: &["groc", "quadrat"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏓᎶᏂᎨ ᏅᎩ ᏧᏅᏏᏯ"),
            keywords: &["ᏅᎩ ᏧᏅᏏᏯ", "ᏓᎶᏂᎨ", "ᏓᎶᏂᎨ ᏅᎩ ᏧᏅᏏᏯ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("žlutý čtvereček"),
            keywords: &["čtverec", "čtvereček", "žlutá", "žlutý čtvereček"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("sgwâr melyn"),
            keywords: &["melyn", "sgwâr"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("gul firkant"),
            keywords: &["firkant", "gul"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("gelbes Quadrat"),
            keywords: &["Quadrat", "gelb", "gelbes Quadrat"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κίτρινο τετράγωνο"),
            keywords: &["κίτρινο", "τετράγωνο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("yellow square"),
            keywords: &["square", "yellow"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("cuadrado amarillo"),
            keywords: &["amarillo", "cuadrado"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kollane ruut"),
            keywords: &["kollane", "nelinurk", "ruut"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("karratu horia"),
            keywords: &["hori", "karratu", "karratu horia"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("مربع زرد"),
            keywords: &["زرد", "مربع"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("keltainen neliö"),
            keywords: &["keltainen", "neliö"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("dilaw na parisukat"),
            keywords: &["dilaw", "dilaw na parisukat", "parisukat"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("gulur fýrakantur"),
            keywords: &["fýrakantur", "gult", "gulur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("carré jaune"),
            keywords: &["carré jaune", "forme géométrique", "géométrie", "jaune"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["carré", "jaune"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("cearnóg bhuí"),
            keywords: &["buí", "cearnóg", "cearnóg bhuí"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("ceàrnach buidhe"),
            keywords: &["buidhe", "ceàrnach"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cadrado amarelo"),
            keywords: &["amarelo", "cadrado"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("પીળા ર\u{a82}ગન\u{ac1}\u{a82} ચોરસ"),
            keywords: &[
                "ચોરસ",
                "પીળા ર\u{a82}ગન\u{ac1}\u{a82} ચોરસ",
                "પીળ\u{ac1}\u{a82}",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("ריבוע צהוב"),
            keywords: &["מרובע", "צהוב", "ריבוע"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("पीला वर\u{94d}ग"),
            keywords: &[
                "आक\u{943}ति",
                "ज\u{94d}यामिति",
                "पीला",
                "पीली",
                "वर\u{94d}ग",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("žuti kvadrat"),
            keywords: &["kvadrat", "žuti"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("sárga négyzet"),
            keywords: &["négyzet", "sárga"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("դեղին քառակուսի"),
            keywords: &["դեղին", "քառակուսի"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("persegi kuning"),
            keywords: &["kuning", "persegi"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("gulur ferningur"),
            keywords: &["ferningur", "gulur"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("quadrato giallo"),
            keywords: &["giallo", "quadrato", "quadrato di colore giallo"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("黄色い四角"),
            keywords: &["四角", "正方形", "黄色", "黄色い四角"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("kothak kuning"),
            keywords: &["kothak", "kuning"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ყვითელი კვადრატი"),
            keywords: &["კვადრატი", "ყვითელი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("сары шаршы"),
            keywords: &["сары", "шаршы"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ការ\u{17c9}េ\u{200b}ពណ\u{17cc}\u{200b}លឿង"),
            keywords: &[
                "ការ\u{17c9}េ",
                "ការ\u{17c9}េ\u{200b}ពណ\u{17cc}\u{200b}លឿង",
                "ពណ\u{17cc}លឿង",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಹಳದ\u{cbf} ಚ\u{ccc}ಕ"),
            keywords: &["ಚ\u{ccc}ಕ", "ಹಳದ\u{cbf}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("노란색 사각형"),
            keywords: &["노란색", "사각형"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("हळद\u{941}वो चवकोन"),
            keywords: &["चवकोन", "हळद\u{941}वो"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("сары квадрат"),
            keywords: &["квадрат", "сары"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ສ\u{eb5}\u{ec8}ຫ\u{ebc}\u{ec8}ຽມ\u{200b}ເຫ\u{ebc}\u{eb7}ອງ"),
            keywords: &[
                "ສ\u{eb5}\u{ec8}ຫ\u{ebc}\u{ec8}ຽມ",
                "ສ\u{eb5}\u{ec8}ຫ\u{ebc}\u{ec8}ຽມ\u{200b}ເຫ\u{ebc}\u{eb7}ອງ",
                "ສ\u{eb5}\u{200b}ເຫ\u{ebc}\u{eb7}ອງ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("geltonas kvadratas"),
            keywords: &["geltonas", "kvadratas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("dzeltens kvadrāts"),
            keywords: &["dzeltens", "kvadrāts"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("жолт квадрат"),
            keywords: &["жолт", "квадрат"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("മഞ\u{d4d}ഞ ചത\u{d41}രം"),
            keywords: &["ചത\u{d41}രം", "മഞ\u{d4d}ഞ"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("шар дөрвөлжин"),
            keywords: &["дөрвөлжин", "шар"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("पिवळा चौकोन"),
            keywords: &["चौकोन", "पिवळा"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("persegi kuning"),
            keywords: &["kuning", "persegi"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အဝါရောင\u{103a} စတ\u{102f}ရမ\u{103a}းက\u{103d}က\u{103a}"),
            keywords: &["စတ\u{102f}ရမ\u{103a}းက\u{103d}က\u{103a}", "အဝါရောင\u{103a}"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("gult kvadrat"),
            keywords: &["gul", "gult", "kvadrat"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("पह\u{947}\u{901}लो वर\u{94d}ग"),
            keywords: &["पह\u{947}\u{901}लो", "वर\u{94d}ग"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("geel vierkant"),
            keywords: &["geel", "vierkant"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("gult kvadrat"),
            keywords: &["gul", "gult", "kvadrat"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ହଳଦ\u{b3f}ଆ ବର\u{b4d}ଗକ\u{b4d}ଷେତ\u{b4d}ର"),
            keywords: &["ବର\u{b4d}ଗକ\u{b4d}ଷେତ\u{b4d}ର", "ହଳଦ\u{b3f}ଆ"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਪੀਲਾ ਵਰਗ"),
            keywords: &["ਪੀਲਾ", "ਵਰਗ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Yẹ\u{301}ló Skwea"),
            keywords: &["Skwea", "Yẹ\u{301}ló"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("żółty kwadrat"),
            keywords: &["kwadrat", "kwadratowy", "żółty"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("زېړه مربع"),
            keywords: &["زېړه", "مربع"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("quadrado amarelo"),
            keywords: &["amarelo", "quadrado"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("pătrat galben"),
            keywords: &["galben", "pătrat"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E12–018"),
            keywords: &["E12–018"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("желтый квадрат"),
            keywords: &["геометрия", "желтый", "квадрат", "прямоугольник", "фигура"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("پيلو چورس"),
            keywords: &["پيلو", "چورس"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("කහ චත\u{dd4}රස\u{dca}\u{200d}රය"),
            keywords: &["කහ", "චත\u{dd4}රස\u{dca}\u{200d}රය"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("žltý štvorec"),
            keywords: &["štvorec", "štvorček", "žltá", "žltý štvorec"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("rumen kvadrat"),
            keywords: &["kvadrat", "rumen"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("afar geeska jaalaha"),
            keywords: &["afar gees", "afar geeska jaalaha", "jaalle"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("katror i verdhë"),
            keywords: &["i verdhë", "katror", "katror i verdhë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("жути квадрат"),
            keywords: &["жути квадрат", "жуто", "квадрат"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["жути квадрат"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("žuti kvadrat"),
            keywords: &["kvadrat", "žuti kvadrat", "žuto"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["žuti kvadrat"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("gul kvadrat"),
            keywords: &["gul", "kvadrat"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mraba wa manjano"),
            keywords: &["manjano", "mraba", "mraba wa manjano"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("மஞ\u{bcd}சள\u{bcd} சதுரம\u{bcd}"),
            keywords: &["சதுரம\u{bcd}", "மஞ\u{bcd}சள\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("పసుపురంగు చతురస\u{c4d}రం"),
            keywords: &["చతురస\u{c4d}రం", "పసుపురంగు"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ส\u{e35}\u{e48}เหล\u{e35}\u{e48}ยมส\u{e35}เหล\u{e37}อง"),
            keywords: &[
                "ส\u{e35}เหล\u{e37}อง",
                "ส\u{e35}\u{e48}เหล\u{e35}\u{e48}ยม",
                "ส\u{e35}\u{e48}เหล\u{e35}\u{e48}ยมส\u{e35}เหล\u{e37}อง",
            ],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ቢጫ ትርብዒት"),
            keywords: &["ቢጫ", "ትርብዒት"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("sary inedördül"),
            keywords: &["inedördül", "sary"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tapafā engeenga"),
            keywords: &["engeenga", "tapafā"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("sarı kare"),
            keywords: &["kare", "sarı"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("жовтий квадрат"),
            keywords: &["жовтий", "квадрат"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("پیلا چوکور"),
            keywords: &["پیلا", "چوکور"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("sariq kvadrat"),
            keywords: &["kvadrat", "sariq", "toʻrtburchak"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("hình vuông màu vàng"),
            keywords: &["hình vuông", "hình vuông màu vàng", "màu vàng", "ô vuông"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("黃色正方形"),
            keywords: &["正方形", "黃色", "黃色正方形"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("黄色正方形"),
            keywords: &["正方形", "黄色", "黄色正方形"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("黄色方块"),
            keywords: &["方块", "方框", "正方形", "黄", "黄色方块"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("黃色方形"),
            keywords: &["方形", "黃色", "黃色方形"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("黃色正方形"),
            keywords: &["正方形", "黃色", "黃色正方形"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("isikwele esi-yellow"),
            keywords: &["isikwele", "isikwele esi-yellow", "yellow"],
        },
    ],
};
#[doc = "🟩"]
pub const GREEN_SQUARE: crate::Emoji = crate::Emoji {
    glyph: "🟩",
    codepoint: "1F7E9",
    status: crate::Status::FullyQualified,
    introduction_version: 12f32,
    name: "green square",
    group: "Symbols",
    subgroup: "geometric",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("groen vierkant"),
            keywords: &["groen", "vierkant"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("አረንጓዴ አራት ማእዝን"),
            keywords: &["አረንጓዴ", "አረንጓዴ አራት ማእዝን", "አራት ማእዝን"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("مربع أخضر"),
            keywords: &["أخضر", "مربع"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("সেউজীয\u{9bc}\u{9be} বৰ\u{9cd}গ"),
            keywords: &["বৰ\u{9cd}গ", "সেউজীয\u{9bc}\u{9be}"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("yaşıl kvadrat"),
            keywords: &["kvadrat", "yaşıl"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("зялёны квадрат"),
            keywords: &["зялёны", "квадрат"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("зелен квадрат"),
            keywords: &["зелен квадрат", "зелено", "квадрат"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("সব\u{9c1}জ বর\u{9cd}গক\u{9cd}ষেত\u{9cd}র"),
            keywords: &["বর\u{9cd}গক\u{9cd}ষেত\u{9cd}র", "সব\u{9c1}জ"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("karrez gwer"),
            keywords: &["gwer", "karrez"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("zeleni kvadrat"),
            keywords: &["kvadrat", "zelena", "zeleni kvadrat"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("quadrat verd"),
            keywords: &["quadrat", "verd"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎢᏤ ᎢᏳᏍᏗ ᏅᎩ ᏧᏅᏏᏯ"),
            keywords: &["ᎢᏤ ᎢᏳᏍᏗ", "ᎢᏤ ᎢᏳᏍᏗ ᏅᎩ ᏧᏅᏏᏯ", "ᏅᎩ ᏧᏅᏏᏯ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("zelený čtvereček"),
            keywords: &["zelená", "zelený čtvereček", "čtverec", "čtvereček"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("sgwâr gwyrdd"),
            keywords: &["gwyrdd", "sgwâr"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("grøn firkant"),
            keywords: &["firkant", "grøn"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("grünes Quadrat"),
            keywords: &["Quadrat", "grün", "grünes Quadrat"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("πράσινο τετράγωνο"),
            keywords: &["πράσινο", "τετράγωνο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("green square"),
            keywords: &["green", "square"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("cuadrado verde"),
            keywords: &["cuadrado", "verde"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("roheline ruut"),
            keywords: &["nelinurk", "roheline", "ruut"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("karratu berdea"),
            keywords: &["berde", "karratu", "karratu berdea"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("مربع سبز"),
            keywords: &["سبز", "مربع"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("vihreä neliö"),
            keywords: &["neliö", "vihreä"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("berdeng parisukat"),
            keywords: &["berde", "berdeng parisukat", "parisukat"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("grønur fýrakantur"),
            keywords: &["fýrakantur", "grønt", "grønur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("carré vert"),
            keywords: &["carré vert", "forme géométrique", "géométrie", "vert"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["carré", "vert"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("cearnóg ghlas"),
            keywords: &["cearnóg", "cearnóg ghlas", "glas"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("ceàrnach uaine"),
            keywords: &["ceàrnach", "uaine"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cadrado verde"),
            keywords: &["cadrado", "verde"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("લીલા ર\u{a82}ગન\u{ac1}\u{a82} ચોરસ"),
            keywords: &[
                "ચોરસ",
                "લીલા ર\u{a82}ગન\u{ac1}\u{a82} ચોરસ",
                "લીલ\u{ac1}\u{a82}",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("ריבוע ירוק"),
            keywords: &["ירוק", "מרובע", "ריבוע"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("हरा वर\u{94d}ग"),
            keywords: &["आक\u{943}ति", "ज\u{94d}यामिति", "वर\u{94d}ग", "हरा", "हरी"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("zeleni kvadrat"),
            keywords: &["kvadrat", "zeleni"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("zöld négyzet"),
            keywords: &["négyzet", "zöld"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("կանաչ քառակուսի"),
            keywords: &["կանաչ", "քառակուսի"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("persegi hijau"),
            keywords: &["hijau", "persegi"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("grænn ferningur"),
            keywords: &["ferningur", "grænn"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("quadrato verde"),
            keywords: &["quadrato", "quadrato di colore verde", "verde"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("緑の四角"),
            keywords: &["四角", "正方形", "緑", "緑の四角"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("kothak ijo"),
            keywords: &["ijo", "kothak"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მწვანე კვადრატი"),
            keywords: &["კვადრატი", "მწვანე"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("жасыл шаршы"),
            keywords: &["жасыл", "шаршы"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ការ\u{17c9}េ\u{200b}ពណ\u{17cc}បៃតង"),
            keywords: &[
                "ការ\u{17c9}េ",
                "ការ\u{17c9}េ\u{200b}ពណ\u{17cc}បៃតង",
                "ពណ\u{17cc}បៃតង",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಹಸ\u{cbf}ರು ಚ\u{ccc}ಕ"),
            keywords: &["ಚ\u{ccc}ಕ", "ಹಸ\u{cbf}ರು"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("녹색 사각형"),
            keywords: &["녹색", "사각형"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("पाचवो चवकोन"),
            keywords: &["चवकोन", "पाचवो"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("жашыл квадрат"),
            keywords: &["жашыл", "квадрат"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ສ\u{eb5}\u{ec8}ຫ\u{ebc}\u{ec8}ຽມ\u{200b}ຂຽວ"),
            keywords: &[
                "ສ\u{eb5}\u{ec8}ຫ\u{ebc}\u{ec8}ຽມ",
                "ສ\u{eb5}\u{ec8}ຫ\u{ebc}\u{ec8}ຽມ\u{200b}ຂຽວ",
                "ສ\u{eb5}\u{200b}ຂຽວ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("žalias kvadratas"),
            keywords: &["kvadratas", "žalias"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("zaļš kvadrāts"),
            keywords: &["kvadrāts", "zaļš"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("зелен квадрат"),
            keywords: &["зелен", "квадрат"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("പച\u{d4d}ച ചത\u{d41}രം"),
            keywords: &["ചത\u{d41}രം", "പച\u{d4d}ച"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("ногоон дөрвөлжин"),
            keywords: &["дөрвөлжин", "ногоон"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("हिरवा चौकोन"),
            keywords: &["चौकोन", "हिरवा"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("persegi hijau"),
            keywords: &["hijau", "persegi"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အစ\u{102d}မ\u{103a}းရောင\u{103a} စတ\u{102f}ရမ\u{103a}းက\u{103d}က\u{103a}"),
            keywords: &[
                "စတ\u{102f}ရမ\u{103a}းက\u{103d}က\u{103a}",
                "အစ\u{102d}မ\u{103a}းရောင\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("grønt kvadrat"),
            keywords: &["grønn", "grønt", "kvadrat"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("हरियो वर\u{94d}ग"),
            keywords: &["वर\u{94d}ग", "हरियो"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("groen vierkant"),
            keywords: &["groen", "vierkant"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("grønt kvadrat"),
            keywords: &["grøn", "grønt", "kvadrat"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ସବ\u{b41}ଜ ବର\u{b4d}ଗକ\u{b4d}ଷେତ\u{b4d}ର"),
            keywords: &["ବର\u{b4d}ଗକ\u{b4d}ଷେତ\u{b4d}ର", "ସବ\u{b41}ଜ"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਹਰਾ ਵਰਗ"),
            keywords: &["ਵਰਗ", "ਹਰਾ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Grín Skwea"),
            keywords: &["Grin", "Grín Skwea", "Skwea"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("zielony kwadrat"),
            keywords: &["kwadrat", "kwadratowy", "zielony"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("شنه مربع"),
            keywords: &["شنه", "مربع"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("quadrado verde"),
            keywords: &["quadrado", "verde"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("pătrat verde"),
            keywords: &["pătrat", "verde"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E12–019"),
            keywords: &["E12–019"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("зеленый квадрат"),
            keywords: &["геометрия", "зеленый", "квадрат", "прямоугольник", "фигура"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("سائو چورس"),
            keywords: &["سائو", "چورس"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("කොළ චත\u{dd4}රස\u{dca}\u{200d}රය"),
            keywords: &["කොළ", "චත\u{dd4}රස\u{dca}\u{200d}රය"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("zelený štvorec"),
            keywords: &["zelená", "zelený štvorec", "štvorec", "štvorček"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("zelen kvadrat"),
            keywords: &["kvadrat", "zelen"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("afar geeska caggaarka ah"),
            keywords: &["afar gees", "afar geeska caggaarka ah", "caggaar"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("katror i gjelbër"),
            keywords: &["i gjelbër", "katror", "katror i gjelbër"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("зелени квадрат"),
            keywords: &["зелени квадрат", "зелено", "квадрат"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["зелени квадрат"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("zeleni kvadrat"),
            keywords: &["kvadrat", "zeleni kvadrat", "zeleno"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["zeleni kvadrat"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("grön kvadrat"),
            keywords: &["grön", "kvadrat"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mraba wa kijani"),
            keywords: &["kijani", "mraba", "mraba wa kijani"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பச\u{bcd}சை சதுரம\u{bcd}"),
            keywords: &["சதுரம\u{bcd}", "பச\u{bcd}சை"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("పచ\u{c4d}చరంగు చతురస\u{c4d}రం"),
            keywords: &["చతురస\u{c4d}రం", "పచ\u{c4d}చరంగు"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ส\u{e35}\u{e48}เหล\u{e35}\u{e48}ยมส\u{e35}เข\u{e35}ยว"),
            keywords: &[
                "ส\u{e35}เข\u{e35}ยว",
                "ส\u{e35}\u{e48}เหล\u{e35}\u{e48}ยม",
                "ส\u{e35}\u{e48}เหล\u{e35}\u{e48}ยมส\u{e35}เข\u{e35}ยว",
            ],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ቀጠልያ ትርብዒት"),
            keywords: &["ቀጠልያ", "ትርብዒት"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ýaşyl inedördül"),
            keywords: &["inedördül", "ýaşyl"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tapafā lanumata"),
            keywords: &["lanumata", "tapafā"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("yeşil kare"),
            keywords: &["kare", "yeşil"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("зелений квадрат"),
            keywords: &["зелений", "квадрат"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("سبز چوکور"),
            keywords: &["سبز", "چوکور"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("yashil kvadrat"),
            keywords: &["kvadrat", "toʻrtburchak", "yashil"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("hình vuông màu xanh lá cây"),
            keywords: &[
                "hình vuông",
                "hình vuông màu xanh lá cây",
                "màu xanh lá cây",
                "xanh lá",
                "xanh lục",
                "ô vuông",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("綠色正方形"),
            keywords: &["正方形", "綠色", "綠色正方形"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("绿色正方形"),
            keywords: &["正方形", "绿色", "绿色正方形"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("绿色方块"),
            keywords: &["方块", "方框", "正方形", "绿", "绿色方块"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("綠色方形"),
            keywords: &["方形", "綠色", "綠色方形"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("綠色正方形"),
            keywords: &["正方形", "綠色", "綠色正方形"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("isikwele esiluhlaza satshani"),
            keywords: &["isikwele esiluhlaza satshani"],
        },
    ],
};
#[doc = "🟦"]
pub const BLUE_SQUARE: crate::Emoji = crate::Emoji {
    glyph: "🟦",
    codepoint: "1F7E6",
    status: crate::Status::FullyQualified,
    introduction_version: 12f32,
    name: "blue square",
    group: "Symbols",
    subgroup: "geometric",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("blou vierkant"),
            keywords: &["blou", "vierkant"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ሰማያዊ አራት ማእዝን"),
            keywords: &["ሰማያዊ", "ሰማያዊ አራት ማእዝን", "አራት ማእዝን"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("مربع أزرق"),
            keywords: &["أزرق", "مربع"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("নীল\u{9be} বৰ\u{9cd}গ"),
            keywords: &["নীল\u{9be}", "বৰ\u{9cd}গ"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("göy kvadrat"),
            keywords: &["göy", "kvadrat"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("сіні квадрат"),
            keywords: &["квадрат", "сіні"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("син квадрат"),
            keywords: &["квадрат", "син квадрат", "синьо"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("নীল বর\u{9cd}গক\u{9cd}ষেত\u{9cd}র"),
            keywords: &["নীল", "বর\u{9cd}গক\u{9cd}ষেত\u{9cd}র"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("karrez glas"),
            keywords: &["glas", "karrez"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("plavi kvadrat"),
            keywords: &["kvadrat", "plava", "plavi kvadrat"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("quadrat blau"),
            keywords: &["blau", "quadrat"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏌᎪᏂᎨ ᏅᎩ ᏧᏅᏏᏯ"),
            keywords: &["ᏅᎩ ᏧᏅᏏᏯ", "ᏌᎪᏂᎨ", "ᏌᎪᏂᎨ ᏅᎩ ᏧᏅᏏᏯ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("modrý čtvereček"),
            keywords: &["modrá", "modrý čtvereček", "čtverec", "čtvereček"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("sgwâr glas"),
            keywords: &["glas", "sgwâr"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("blå firkant"),
            keywords: &["blå", "firkant"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("blaues Quadrat"),
            keywords: &["Quadrat", "blau", "blaues Quadrat"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("μπλε τετράγωνο"),
            keywords: &["μπλε", "τετράγωνο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("blue square"),
            keywords: &["blue", "square"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("cuadrado azul"),
            keywords: &["azul", "cuadrado"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("sinine ruut"),
            keywords: &["nelinurk", "ruut", "sinine"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("karratu urdina"),
            keywords: &["karratu", "karratu urdina", "urdin"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("مربع آبی"),
            keywords: &["آبی", "مربع"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("sininen neliö"),
            keywords: &["neliö", "sininen"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("asul na parisukat"),
            keywords: &["asul", "asul na parisukat", "parisukat"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("blaúr fýrakantur"),
            keywords: &["blaúr fýrakantur", "blátt", "bláur", "fýrakantur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("carré bleu"),
            keywords: &["bleu", "carré bleu", "forme géométrique", "géométrie"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["bleu", "carré"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("cearnóg ghorm"),
            keywords: &["cearnóg", "cearnóg ghorm", "gorm"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("ceàrnach gorm"),
            keywords: &["ceàrnach", "gorm"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cadrado azul"),
            keywords: &["azul", "cadrado"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("વાદળી ચોરસ"),
            keywords: &["ચોરસ", "વાદળી"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("ריבוע כחול"),
            keywords: &["כחול", "מרובע", "ריבוע"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("नीला वर\u{94d}ग"),
            keywords: &[
                "आक\u{943}ति",
                "ज\u{94d}यामिति",
                "नीला",
                "नीली",
                "वर\u{94d}ग",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("plavi kvadrat"),
            keywords: &["kvadrat", "plavi"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("kék négyzet"),
            keywords: &["kék", "négyzet"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("կապույտ քառակուսի"),
            keywords: &["կապույտ", "քառակուսի"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("persegi biru"),
            keywords: &["biru", "persegi"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("blár ferningur"),
            keywords: &["blár", "ferningur"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("quadrato blu"),
            keywords: &["blu", "quadrato", "quadrato di colore blu"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("青い四角"),
            keywords: &["四角", "正方形", "青", "青い四角"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("kothak biru"),
            keywords: &["biru", "kothak"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ლურჯი კვადრატი"),
            keywords: &["კვადრატი", "ლურჯი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("көк шаршы"),
            keywords: &["көк", "шаршы"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ការ\u{17c9}េពណ\u{17cc}ខៀវ"),
            keywords: &["ការ\u{17c9}េ", "ការ\u{17c9}េពណ\u{17cc}ខៀវ", "ពណ\u{17cc}ខៀវ"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ನೀಲ\u{cbf} ಚ\u{ccc}ಕ"),
            keywords: &["ಚ\u{ccc}ಕ", "ನೀಲ\u{cbf}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("파란색 사각형"),
            keywords: &["사각형", "파란색"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("निळो चवकोन"),
            keywords: &["चवकोन", "निळो"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("көк квадрат"),
            keywords: &["квадрат", "көк"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ສ\u{eb5}\u{ec8}ຫ\u{ebc}\u{ec8}ຽມ\u{200b}ຟ\u{ec9}າ"),
            keywords: &[
                "ສ\u{eb5}\u{ec8}ຫ\u{ebc}\u{ec8}ຽມ",
                "ສ\u{eb5}\u{ec8}ຫ\u{ebc}\u{ec8}ຽມ\u{200b}ຟ\u{ec9}າ",
                "ສ\u{eb5}\u{200b}ຟ\u{ec9}າ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("mėlynas kvadratas"),
            keywords: &["kvadratas", "mėlynas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("zils kvadrāts"),
            keywords: &["kvadrāts", "zils"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("син квадрат"),
            keywords: &["квадрат", "син"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("നീല ചത\u{d41}രം"),
            keywords: &["ചത\u{d41}രം", "നീല"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("хөх дөрвөлжин"),
            keywords: &["дөрвөлжин", "хөх"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("निळा चौकोन"),
            keywords: &["चौकोन", "निळा"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("persegi biru"),
            keywords: &["biru", "persegi"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အပြာရောင\u{103a} စတ\u{102f}ရမ\u{103a}းက\u{103d}က\u{103a}"),
            keywords: &[
                "စတ\u{102f}ရမ\u{103a}းက\u{103d}က\u{103a}",
                "အပြာရောင\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("blått kvadrat"),
            keywords: &["blå", "blått", "kvadrat"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("नीलो वर\u{94d}ग"),
            keywords: &["नीलो", "वर\u{94d}ग"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("blauw vierkant"),
            keywords: &["blauw", "vierkant"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("blått kvadrat"),
            keywords: &["blå", "blått", "kvadrat"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ନୀଳ ବର\u{b4d}ଗକ\u{b4d}ଷେତ\u{b4d}ର"),
            keywords: &["ନୀଳ", "ବର\u{b4d}ଗକ\u{b4d}ଷେତ\u{b4d}ର"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਨੀਲਾ ਵਰਗ"),
            keywords: &["ਨੀਲਾ", "ਵਰਗ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Blú Skwea"),
            keywords: &["Blu", "Blú Skwea", "Skwea"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("niebieski kwadrat"),
            keywords: &["kwadrat", "kwadratowy", "niebieski"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("آسماني رنګ مربع"),
            keywords: &["آسماني رنګ", "آسماني رنګ مربع", "مربع"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("quadrado azul"),
            keywords: &["azul", "quadrado"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("pătrat albastru"),
            keywords: &["albastru", "pătrat"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E12–016"),
            keywords: &["E12–016"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("синий квадрат"),
            keywords: &["геометрия", "квадрат", "прямоугольник", "синий", "фигура"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("نيرو چورس"),
            keywords: &["نيرو", "چورس"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("න\u{dd2}ල චත\u{dd4}රස\u{dca}\u{200d}රය"),
            keywords: &[
                "චත\u{dd4}රස\u{dca}\u{200d}රය",
                "න\u{dd2}ල චත\u{dd4}රස\u{dca}\u{200d}රය",
                "න\u{dd2}ල\u{dca}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("modrý štvorec"),
            keywords: &["modrá", "modrý štvorec", "štvorec", "štvorček"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("moder kvadrat"),
            keywords: &["kvadrat", "moder"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("afar geeska buluugga ah"),
            keywords: &["afar gees", "afar geeska buluugga ah", "buluug"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("katror i kaltër"),
            keywords: &["i kaltër", "katror", "katror i kaltër"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("плави квадрат"),
            keywords: &["квадрат", "плави квадрат", "плаво"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["плави квадрат"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("plavi kvadrat"),
            keywords: &["kvadrat", "plavi kvadrat", "plavo"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["plavi kvadrat"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("blå kvadrat"),
            keywords: &["blå", "kvadrat"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mraba wa samawati"),
            keywords: &["mraba", "mraba wa samawati", "samawati"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ந\u{bc0}ல சதுரம\u{bcd}"),
            keywords: &[
                "சதுரம\u{bcd}",
                "ந\u{bc0}ல சதுரம\u{bcd}",
                "ந\u{bc0}லம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("న\u{c40}ల\u{c3f}రంగు చతురస\u{c4d}రం"),
            keywords: &["చతురస\u{c4d}రం", "న\u{c40}ల\u{c3f}రంగు"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ส\u{e35}\u{e48}เหล\u{e35}\u{e48}ยมส\u{e35}น\u{e49}ำเง\u{e34}น"),
            keywords: &[
                "ส\u{e35}น\u{e49}ำเง\u{e34}น",
                "ส\u{e35}\u{e48}เหล\u{e35}\u{e48}ยม",
                "ส\u{e35}\u{e48}เหล\u{e35}\u{e48}ยมส\u{e35}น\u{e49}ำเง\u{e34}น",
            ],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ሰማያዊ ትርብዒት"),
            keywords: &["ሰማያዊ", "ትርብዒት"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("gök inedördül"),
            keywords: &["gök", "inedördül"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tapafā lanupulū"),
            keywords: &["lanupulū", "tapafā"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("mavi kare"),
            keywords: &["kare", "mavi"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("синій квадрат"),
            keywords: &["квадрат", "синій"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("نیلا چوکور"),
            keywords: &["نیلا", "چوکور"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("koʻk kvadrat"),
            keywords: &["koʻk", "kvadrat", "toʻrtburchak"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("hình vuông màu xanh da trời"),
            keywords: &[
                "hình vuông",
                "hình vuông màu xanh da trời",
                "màu xanh da trời",
                "ô vuông",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("藍色正方形"),
            keywords: &["正方形", "藍色", "藍色正方形"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("蓝色正方形"),
            keywords: &["正方形", "蓝色", "蓝色正方形"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("蓝色方块"),
            keywords: &["方块", "方框", "正方形", "蓝", "蓝色方块"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("藍色方形"),
            keywords: &["方形", "藍色", "藍色方形"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("藍色正方形"),
            keywords: &["正方形", "藍色", "藍色正方形"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("isikwele esiluhlaza"),
            keywords: &["isikwele esiluhlaza"],
        },
    ],
};
#[doc = "🟪"]
pub const PURPLE_SQUARE: crate::Emoji = crate::Emoji {
    glyph: "🟪",
    codepoint: "1F7EA",
    status: crate::Status::FullyQualified,
    introduction_version: 12f32,
    name: "purple square",
    group: "Symbols",
    subgroup: "geometric",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("pers vierkant"),
            keywords: &["pers", "vierkant"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ሐምራዊ አራት ማእዝን"),
            keywords: &["ሐምራዊ", "ሐምራዊ አራት ማእዝን", "አራት ማእዝን"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("مربع بنفسجي"),
            keywords: &["بنفسجي", "مربع"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("বেঙ\u{9c1}নীয\u{9bc}\u{9be} বৰ\u{9cd}গ"),
            keywords: &["বেঙ\u{9c1}নীয\u{9bc}\u{9be}", "বৰ\u{9cd}গ"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("bənövşəyi kvadrat"),
            keywords: &["bənövşəyi", "kvadrat"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("фіялетавы квадрат"),
            keywords: &["квадрат", "фіялетавы"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("лилав квадрат"),
            keywords: &["квадрат", "лилав квадрат", "лилаво"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("বেগ\u{9c1}নী বর\u{9cd}গক\u{9cd}ষেত\u{9cd}র"),
            keywords: &["বর\u{9cd}গক\u{9cd}ষেত\u{9cd}র", "বেগ\u{9c1}নী"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("karrez limestra"),
            keywords: &["karrez", "limestra"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("ljubičasti kvadrat"),
            keywords: &["kvadrat", "ljubičasta", "ljubičasti kvadrat"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("quadrat lila"),
            keywords: &["lila", "morat", "quadrat", "violeta"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏓᎲᎵᎨ ᏅᎩ ᏧᏅᏏᏯ"),
            keywords: &["ᎠᏓᎲᎵᎨ", "ᎠᏓᎲᎵᎨ ᏅᎩ ᏧᏅᏏᏯ", "ᏅᎩ ᏧᏅᏏᏯ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("fialový čtvereček"),
            keywords: &["fialová", "fialový čtvereček", "čtverec", "čtvereček"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("sgwâr piws"),
            keywords: &["piws", "sgwâr"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("lilla firkant"),
            keywords: &["firkant", "lilla"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("lila Quadrat"),
            keywords: &["Quadrat", "lila"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("μοβ τετράγωνο"),
            keywords: &["μοβ", "μωβ", "τετράγωνο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("purple square"),
            keywords: &["purple", "square"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("cuadrado morado"),
            keywords: &["cuadrado", "lila", "morado", "púrpura"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("lilla ruut"),
            keywords: &["lilla", "nelinurk", "ruut"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("karratu morea"),
            keywords: &["karratu", "karratu morea", "more"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("مربع بنفش"),
            keywords: &["بنفش", "مربع"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("violetti neliö"),
            keywords: &["neliö", "violetti"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("lilang parisukat"),
            keywords: &["lila", "lilang parisukat", "parisukat"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("lillafarvaður fýrakantur"),
            keywords: &[
                "fýrakantur",
                "korkalitt",
                "korkalittur",
                "korkalitur",
                "lillafarva",
                "lillafarvaður",
                "reyðblátt",
                "reyðbláur",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("carré violet"),
            keywords: &["carré violet", "forme géométrique", "géométrie", "violet"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["carré", "violet"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("cearnóg chorcra"),
            keywords: &["cearnóg", "cearnóg chorcra", "corcra"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("ceàrnach purpaidh"),
            keywords: &["ceàrnach", "corca", "purpaidh"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cadrado violeta"),
            keywords: &["cadrado", "violeta"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("જા\u{a82}બલી ચોરસ"),
            keywords: &["ચોરસ", "જા\u{a82}બલી"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("ריבוע סגול"),
            keywords: &["מרובע", "סגול", "ריבוע"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ब\u{948}\u{902}गनी वर\u{94d}ग"),
            keywords: &[
                "आक\u{943}ति",
                "ज\u{94d}यामिति",
                "ब\u{948}\u{902}गनी",
                "वर\u{94d}ग",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("ljubičasti kvadrat"),
            keywords: &["kvadrat", "ljubičasti"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("lila négyzet"),
            keywords: &["lila", "négyzet"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("մանուշակագույն քառակուսի"),
            keywords: &["մանուշակագույն", "քառակուսի"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("persegi ungu"),
            keywords: &["persegi", "ungu"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("fjólublár ferningur"),
            keywords: &["ferningur", "fjólublár"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("quadrato viola"),
            keywords: &["quadrato", "quadrato di colore viola", "viola"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("紫の四角"),
            keywords: &["四角", "正方形", "紫", "紫の四角"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("kothak wungu"),
            keywords: &["kothak", "wungu"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("იისფერი კვადრატი"),
            keywords: &["იისფერი", "კვადრატი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("күлгін шаршы"),
            keywords: &["күлгін", "шаршы"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ការ\u{17c9}េ\u{200b}ពណ\u{17cc}ស\u{17d2}វាយ"),
            keywords: &[
                "ការ\u{17c9}េ",
                "ការ\u{17c9}េ\u{200b}ពណ\u{17cc}ស\u{17d2}វាយ",
                "ពណ\u{17cc}ស\u{17d2}វាយ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ನೇರಳ\u{cc6} ಚ\u{ccc}ಕ"),
            keywords: &["ಚ\u{ccc}ಕ", "ನೇರಳ\u{cc6}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("보라색 사각형"),
            keywords: &["보라색", "사각형"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("जा\u{902}भळो चवकोन"),
            keywords: &["चवकोन", "जा\u{902}भळो"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("кызгылт көк квадрат"),
            keywords: &["квадрат", "кызгылт көк", "кызгылт көк квадрат"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ສ\u{eb5}\u{ec8}ຫ\u{ebc}\u{ec8}ຽມ\u{200b}ມ\u{ec8}ວງ"),
            keywords: &[
                "ສ\u{eb5}\u{ec8}ຫ\u{ebc}\u{ec8}ຽມ",
                "ສ\u{eb5}\u{ec8}ຫ\u{ebc}\u{ec8}ຽມ\u{200b}ມ\u{ec8}ວງ",
                "ສ\u{eb5}\u{200b}ມ\u{ec8}ວງ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("violetinis kvadratas"),
            keywords: &["kvadratas", "violetinis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("violets kvadrāts"),
            keywords: &["kvadrāts", "violets"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("виолетов квадрат"),
            keywords: &["виолетов", "квадрат"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("പർപ\u{d4d}പിൾ ചത\u{d41}രം"),
            keywords: &["ചത\u{d41}രം", "പർപ\u{d4d}പിൾ"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("нил ягаан дөрвөлжин"),
            keywords: &["дөрвөлжин", "нил ягаан", "нил ягаан дөрвөлжин"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("जा\u{902}भळा चौकोन"),
            keywords: &["चौकोन", "जा\u{902}भळा"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("persegi ungu"),
            keywords: &["persegi", "ungu"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ခရမ\u{103a}းရောင\u{103a} စတ\u{102f}ရမ\u{103a}းက\u{103d}က\u{103a}"),
            keywords: &[
                "ခရမ\u{103a}းရောင\u{103a}",
                "စတ\u{102f}ရမ\u{103a}းက\u{103d}က\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("lilla kvadrat"),
            keywords: &["kvadrat", "lilla"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("ब\u{948}जनी वर\u{94d}ग"),
            keywords: &["ब\u{948}जनी", "वर\u{94d}ग"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("paars vierkant"),
            keywords: &["paars", "vierkant"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("lilla kvadrat"),
            keywords: &["kvadrat", "lilla"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ବ\u{b3e}ଇଗଣୀ ବର\u{b4d}ଗକ\u{b4d}ଷେତ\u{b4d}ର"),
            keywords: &["ବର\u{b4d}ଗକ\u{b4d}ଷେତ\u{b4d}ର", "ବ\u{b3e}ଇଗଣୀ"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਜਾਮਣੀ ਵਰਗ"),
            keywords: &["ਜਾਮਣੀ", "ਵਰਗ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Pọ\u{301}púl Kọ\u{301}lọ Skwea"),
            keywords: &[
                "Pọ\u{301}púl Kọ\u{301}lọ",
                "Pọ\u{301}púl Kọ\u{301}lọ Skwea",
                "Skwea",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("fioletowy kwadrat"),
            keywords: &["fioletowy", "kwadrat", "kwadratowy"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ارغواني مربع"),
            keywords: &["ارغواني", "مربع"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("quadrado roxo"),
            keywords: &["quadrado", "roxo"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("pătrat violet"),
            keywords: &["pătrat", "violet"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E12–020"),
            keywords: &["E12–020"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("фиолетовый квадрат"),
            keywords: &[
                "геометрия",
                "квадрат",
                "прямоугольник",
                "фигура",
                "фиолетовый",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("جامني چورس"),
            keywords: &["جامني", "چورس"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("දම\u{dca} චත\u{dd4}රස\u{dca}\u{200d}රය"),
            keywords: &["චත\u{dd4}රස\u{dca}\u{200d}රය", "දම\u{dca}"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("fialový štvorec"),
            keywords: &["fialová", "fialový štvorec", "štvorec", "štvorček"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("škrlaten kvadrat"),
            keywords: &["kvadrat", "škrlaten"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("afar geeska buluug-guduudka ah"),
            keywords: &[
                "afar gees",
                "afar geeska buluug-guduudka ah",
                "buluug-guduud",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("katror në ngjyrë vjollce"),
            keywords: &["katror", "katror në ngjyrë vjollce", "ngjyrë vjollce"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("љубичасти квадрат"),
            keywords: &["квадрат", "љубичасти квадрат", "љубичасто"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["љубичасти квадрат"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("ljubičasti kvadrat"),
            keywords: &["kvadrat", "ljubičasti kvadrat", "ljubičasto"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["ljubičasti kvadrat"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("lila kvadrat"),
            keywords: &["kvadrat", "lila"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mraba wa zambarau"),
            keywords: &["mraba", "mraba wa zambarau", "zambarau"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பர\u{bcd}பிள\u{bcd} சதுரம\u{bcd}"),
            keywords: &["சதுரம\u{bcd}", "பர\u{bcd}பிள\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ఊద\u{c3e}రంగు చతురస\u{c4d}రం"),
            keywords: &["ఊద\u{c3e}రంగు", "చతురస\u{c4d}రం"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ส\u{e35}\u{e48}เหล\u{e35}\u{e48}ยมส\u{e35}ม\u{e48}วง"),
            keywords: &[
                "ส\u{e35}ม\u{e48}วง",
                "ส\u{e35}\u{e48}เหล\u{e35}\u{e48}ยม",
                "ส\u{e35}\u{e48}เหล\u{e35}\u{e48}ยมส\u{e35}ม\u{e48}วง",
            ],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ሊላ ትርብዒት"),
            keywords: &["ሊላ", "ትርብዒት"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("melewşe inedördül"),
            keywords: &["inedördül", "melewşe"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tapafā lanuvaioleti"),
            keywords: &["lanuvaioleti", "tapafā"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("mor kare"),
            keywords: &["kare", "mor"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("пурпуровий квадрат"),
            keywords: &["квадрат", "пурпуровий"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ارغوانی چوکور"),
            keywords: &["ارغوانی", "چوکور"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("binafsharang kvadrat"),
            keywords: &["binafsharang", "kvadrat", "toʻrtburchak"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("hình vuông màu tím"),
            keywords: &[
                "hình vuông",
                "hình vuông màu tím",
                "màu tía",
                "màu tím",
                "ô vuông",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("紫色正方形"),
            keywords: &["正方形", "紫色", "紫色正方形"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("紫色正方形"),
            keywords: &["正方形", "紫色", "紫色正方形"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("紫色方块"),
            keywords: &["方块", "方框", "正方形", "紫", "紫色方块"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("紫色方形"),
            keywords: &["方形", "紫色", "紫色方形"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("紫色正方形"),
            keywords: &["正方形", "紫色", "紫色正方形"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("isikwele esiphephuli"),
            keywords: &["isikwele esiphephuli", "purple", "square"],
        },
    ],
};
#[doc = "🟫"]
pub const BROWN_SQUARE: crate::Emoji = crate::Emoji {
    glyph: "🟫",
    codepoint: "1F7EB",
    status: crate::Status::FullyQualified,
    introduction_version: 12f32,
    name: "brown square",
    group: "Symbols",
    subgroup: "geometric",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("bruin vierkant"),
            keywords: &["bruin", "vierkant"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ቡናማ አራት ማእዝን"),
            keywords: &["ቡናማ", "ቡናማ አራት ማእዝን", "አራት ማእዝን"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("مربع بني"),
            keywords: &["بني", "مربع"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ম\u{9c2}গ\u{9be} বৰ\u{9cd}গ"),
            keywords: &["বৰ\u{9cd}গ", "ম\u{9c2}গ\u{9be}"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("qəhvəyi kvadrat"),
            keywords: &["kvadrat", "qəhvəyi"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("карычневы квадрат"),
            keywords: &["карычневы", "квадрат"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("кафяв квадрат"),
            keywords: &["кафяв квадрат", "кафяво", "квадрат"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("খয\u{9bc}েরি বর\u{9cd}গক\u{9cd}ষেত\u{9cd}র"),
            keywords: &[
                "খয\u{9bc}েরি বর\u{9cd}গক\u{9cd}ষেত\u{9cd}র",
                "বর\u{9cd}গক\u{9cd}ষেত\u{9cd}র",
                "ব\u{9be}দ\u{9be}মি",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("karrez gell"),
            keywords: &["gell", "karrez"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("smeđi kvadrat"),
            keywords: &["kvadrat", "smeđa", "smeđi kvadrat"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("quadrat marró"),
            keywords: &["marró", "quadrat"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᏬᏗᎨ ᏅᎩ ᏧᏅᏏᏯ"),
            keywords: &["ᎤᏬᏗᎨ", "ᎤᏬᏗᎨ ᏅᎩ ᏧᏅᏏᏯ", "ᏅᎩ ᏧᏅᏏᏯ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("hnědý čtvereček"),
            keywords: &["hnědá", "hnědý čtvereček", "čtverec", "čtvereček"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("sgwâr brown"),
            keywords: &["brown", "sgwâr"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("brun firkant"),
            keywords: &["brun", "firkant"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("braunes Quadrat"),
            keywords: &["Quadrat", "braun", "braunes Quadrat"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("καφέ τετράγωνο"),
            keywords: &["καφέ", "τετράγωνο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("brown square"),
            keywords: &["brown", "square"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("cuadrado marrón"),
            keywords: &["cuadrado", "marrón"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("cuadrado café"),
            keywords: &["cuadrado café"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("cuadrado café"),
            keywords: &["café", "cuadrado", "marrón"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("pruun ruut"),
            keywords: &["nelinurk", "pruun", "ruut"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("karratu marroia"),
            keywords: &["karratu", "karratu marroia", "marroi"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("مربع قهوه\u{200c}ای"),
            keywords: &["قهوه\u{200c}ای", "مربع"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("ruskea neliö"),
            keywords: &["neliö", "ruskea"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("brown na parisukat"),
            keywords: &["brown", "brown na parisukat", "parisukat"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("brúnur fýrakantur"),
            keywords: &["brúnt", "brúnur", "fýrakantur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("carré marron"),
            keywords: &["carré marron", "forme géométrique", "géométrie", "marron"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("carré brun"),
            keywords: &["carré brun"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("cearnóg dhonn"),
            keywords: &["cearnóg", "cearnóg dhonn", "donn"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("ceàrnach donn"),
            keywords: &["ceàrnach", "donn"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cadrado marrón"),
            keywords: &["cadrado", "castaño", "marrón"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("કથ\u{acd}થઈ ચોરસ"),
            keywords: &["કથ\u{acd}થઈ", "ચોરસ"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("ריבוע חום"),
            keywords: &["חום", "מרובע", "ריבוע"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("भ\u{942}रा वर\u{94d}ग"),
            keywords: &[
                "आक\u{943}ति",
                "ज\u{94d}यामिति",
                "भ\u{942}रा",
                "भ\u{942}री",
                "वर\u{94d}ग",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("smeđi kvadrat"),
            keywords: &["kvadrat", "smeđi"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("barna négyzet"),
            keywords: &["barna", "négyzet"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("շագանակագույն քառակուսի"),
            keywords: &["շագանակագույն", "քառակուսի"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("persegi cokelat"),
            keywords: &["cokelat", "persegi"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("brúnn ferningur"),
            keywords: &["brúnn", "ferningur"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("quadrato marrone"),
            keywords: &["quadrato", "quadrato di colore marrone", "quadrato marrone"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("茶色い四角"),
            keywords: &["四角", "正方形", "茶色", "茶色い四角"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("kothak soklat"),
            keywords: &["kothak", "soklat"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ყავისფერი კვადრატი"),
            keywords: &["კვადრატი", "ყავისფერი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("қоңыр шаршы"),
            keywords: &["шаршы", "қоңыр"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ការ\u{17c9}េពណ\u{17cc}ត\u{17d2}នោត"),
            keywords: &[
                "ការ\u{17c9}េ",
                "ការ\u{17c9}េពណ\u{17cc}ត\u{17d2}នោត",
                "ពណ\u{17cc}ត\u{17d2}នោត",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕಂದುಬಣ\u{ccd}ಣದ ಚ\u{ccc}ಕ"),
            keywords: &["ಕಂದುಬಣ\u{ccd}ಣ", "ಕಂದುಬಣ\u{ccd}ಣದ ಚ\u{ccc}ಕ", "ಚ\u{ccc}ಕ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("갈색 사각형"),
            keywords: &["갈색", "사각형"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("तपकिरी चवकोन"),
            keywords: &["चवकोन", "तपकिरी"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("күрөң квадрат"),
            keywords: &["квадрат", "күрөң"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ສ\u{eb5}\u{ec8}ຫ\u{ebc}\u{ec8}ຽມ\u{200b}ນ\u{ec9}ຳ\u{200b}ຕານ"),
            keywords: &[
                "ສ\u{eb5}\u{ec8}ຫ\u{ebc}\u{ec8}ຽມ",
                "ສ\u{eb5}\u{ec8}ຫ\u{ebc}\u{ec8}ຽມ\u{200b}ນ\u{ec9}ຳ\u{200b}ຕານ",
                "ສ\u{eb5}\u{200b}ນ\u{ec9}ຳ\u{200b}ຕານ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("rudas kvadratas"),
            keywords: &["kvadratas", "rudas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("brūns kvadrāts"),
            keywords: &["brūns", "kvadrāts"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("кафен квадрат"),
            keywords: &["кафен", "квадрат"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ബ\u{d4d}ര\u{d57}ൺ ചത\u{d41}രം"),
            keywords: &["ചത\u{d41}രം", "ബ\u{d4d}ര\u{d57}ൺ"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("бор дөрвөлжин"),
            keywords: &["бор", "дөрвөлжин"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("तपकिरी चौकोन"),
            keywords: &["चौकोन", "तपकिरी"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("persegi perang"),
            keywords: &["perang", "persegi"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အည\u{102d}\u{102f}ရောင\u{103a} စတ\u{102f}ရမ\u{103a}းက\u{103d}က\u{103a}"),
            keywords: &[
                "စတ\u{102f}ရမ\u{103a}းက\u{103d}က\u{103a}",
                "အည\u{102d}\u{102f}ရောင\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("brunt kvadrat"),
            keywords: &["brun", "brunt", "kvadrat"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("ख\u{948}रो वर\u{94d}ग"),
            keywords: &["ख\u{948}रो", "वर\u{94d}ग"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("bruin vierkant"),
            keywords: &["bruin", "vierkant"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("brunt kvadrat"),
            keywords: &["brun", "brunt", "kvadrat"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ବ\u{b3e}ଦ\u{b3e}ମୀ ବର\u{b4d}ଗକ\u{b4d}ଷେତ\u{b4d}ର"),
            keywords: &["ବର\u{b4d}ଗକ\u{b4d}ଷେତ\u{b4d}ର", "ବ\u{b3e}ଦ\u{b3e}ମୀ"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਭ\u{a42}ਰ\u{a47} ਰ\u{a70}ਗ ਦਾ ਵਰਗ"),
            keywords: &["ਭ\u{a42}ਰਾ", "ਭ\u{a42}ਰ\u{a47} ਰ\u{a70}ਗ ਦਾ ਵਰਗ", "ਵਰਗ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Braún Skwea"),
            keywords: &["Braun", "Braún Skwea", "Skwea"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("brązowy kwadrat"),
            keywords: &["brązowy", "kwadrat", "kwadratowy"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("نسواري مربع"),
            keywords: &["مربع", "نسواري"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("quadrado marrom"),
            keywords: &["marrom", "quadrado"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("quadrado castanho"),
            keywords: &["castanho", "quadrado"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("pătrat maro"),
            keywords: &["maro", "pătrat"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E12–021"),
            keywords: &["E12–021"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("коричневый квадрат"),
            keywords: &[
                "геометрия",
                "квадрат",
                "коричневый",
                "прямоугольник",
                "фигура",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("برائون چورس"),
            keywords: &["برائون", "چورس"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ද\u{dd4}ඹ\u{dd4}ර\u{dd4} චත\u{dd4}රස\u{dca}\u{200d}රය"),
            keywords: &["චත\u{dd4}රස\u{dca}\u{200d}රය", "ද\u{dd4}ඹ\u{dd4}ර\u{dd4}"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("hnedý štvorec"),
            keywords: &["hnedá", "hnedý štvorec", "štvorec", "štvorček"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("rjav kvadrat"),
            keywords: &["kvadrat", "rjav"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("afar geeska bunniga ah"),
            keywords: &["afar gees", "afar geeska bunniga ah", "bunni"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("katror në ngjyrë kafe"),
            keywords: &["katror", "katror në ngjyrë kafe", "ngjyrë kafe"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("браон квадрат"),
            keywords: &["браон", "квадрат"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("braon kvadrat"),
            keywords: &["braon", "kvadrat"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("brun kvadrat"),
            keywords: &["brun", "kvadrat"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mraba wa hudhurungi"),
            keywords: &["hudhurungi", "mraba", "mraba wa hudhurungi"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பழுப\u{bcd}பு சதுரம\u{bcd}"),
            keywords: &["சதுரம\u{bcd}", "பழுப\u{bcd}பு"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("గ\u{c4b}ధుమరంగు చతురస\u{c4d}రం"),
            keywords: &["గ\u{c4b}ధుమరంగు", "చతురస\u{c4d}రం"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ส\u{e35}\u{e48}เหล\u{e35}\u{e48}ยมส\u{e35}น\u{e49}ำตาล"),
            keywords: &[
                "ส\u{e35}น\u{e49}ำตาล",
                "ส\u{e35}\u{e48}เหล\u{e35}\u{e48}ยม",
                "ส\u{e35}\u{e48}เหล\u{e35}\u{e48}ยมส\u{e35}น\u{e49}ำตาล",
            ],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ቡናዊ ትርብዒት"),
            keywords: &["ቡናዊ", "ትርብዒት"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("goňur inedördül"),
            keywords: &["goňur", "inedördül"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tapafā melomelo"),
            keywords: &["melomelo", "tapafā"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("kahverengi kare"),
            keywords: &["kahverengi", "kare"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("коричневий квадрат"),
            keywords: &["квадрат", "коричневий"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("بھورا چوکور"),
            keywords: &["بھورا", "چوکور"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("jigarrang kvadrat"),
            keywords: &["jigarrang", "kvadrat", "toʻrtburchak"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("hình vuông màu nâu"),
            keywords: &["hình vuông", "hình vuông màu nâu", "màu nâu", "ô vuông"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("啡色正方形"),
            keywords: &["啡色", "啡色正方形", "正方形"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("啡色正方形"),
            keywords: &["啡色", "啡色正方形", "正方形"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("棕色方块"),
            keywords: &["方块", "方框", "棕", "棕色方块", "正方形"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("褐色方形"),
            keywords: &["方形", "褐色", "褐色方形"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("啡色正方形"),
            keywords: &["啡色", "啡色正方形", "正方形"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("esikwele esi-brown"),
            keywords: &["brown", "esikwele esi-brown", "skwele"],
        },
    ],
};
#[doc = "⬛"]
pub const BLACK_LARGE_SQUARE: crate::Emoji = crate::Emoji {
    glyph: "⬛",
    codepoint: "2B1B",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "black large square",
    group: "Symbols",
    subgroup: "geometric",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("groot swart vierkant"),
            keywords: &["geometries", "groot swart vierkant", "swart", "vierkant"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ጥቁር ትልቅ ካሬ"),
            keywords: &["ካሬ", "ጂኦሜትሪያዊ", "ጥቁር ትልቅ ካሬ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("مربع كبير أسود"),
            keywords: &["مربع", "مربع كبير أسود", "هندسي"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ক’ল\u{9be} ড\u{9be}ঙৰ বৰ\u{9cd}গ"),
            keywords: &[
                "ক’ল\u{9be} ড\u{9be}ঙৰ বৰ\u{9cd}গ",
                "জ\u{9cd}য\u{9be}মিতিক",
                "বৰ\u{9cd}গ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("qara böyük kvadrat"),
            keywords: &["həndəsi", "kvadrat", "qara böyük kvadrat"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("вялікі чорны квадрат"),
            keywords: &["аб’ект", "вялікі чорны квадрат", "геаметрычны", "квадрат"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Черен голям квадрат"),
            keywords: &["Черен голям квадрат", "геометричен", "квадрат"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ক\u{9be}লো বড\u{9bc} বর\u{9cd}গক\u{9cd}ষেত\u{9cd}র"),
            keywords: &[
                "ক\u{9be}লো বড\u{9bc} বর\u{9cd}গক\u{9cd}ষেত\u{9cd}র",
                "জ\u{9cd}য\u{9be}মিতিক",
                "বর\u{9cd}গ\u{9be}ক\u{9be}র",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("karrez bras du"),
            keywords: &["bras", "karrez", "karrez bras du"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("crni veliki kvadrat"),
            keywords: &["crni veliki kvadrat", "geometrija", "kvadrat"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("quadrat gran negre"),
            keywords: &["geometria", "gran", "negre", "quadrat"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎬᎿᎨ ᎤᏔᎾ ᎾᎩ ᏧᏅᏏᏱ"),
            keywords: &["ᎬᎿᎨ ᎤᏔᎾ ᎾᎩ ᏧᏅᏏᏱ", "ᏅᎩ ᏧᏅᏏᏯ", "ᏗᏎᏍᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("velký černý čtverec"),
            keywords: &["geometrie", "velký černý čtverec", "čtverec"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("sgwâr mawr du"),
            keywords: &["geometrig", "sgwâr", "sgwâr mawr du"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("stort sort kvadrat"),
            keywords: &["geometrisk", "kvadrat", "stort sort kvadrat"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("großes schwarzes Quadrat"),
            keywords: &["Quadrat", "großes schwarzes Quadrat", "schwarz"],
        },
        #[cfg(feature = "de_CH")]
        crate::Annotation {
            lang: "de_CH",
            tts: Some("Grosses schwarzes Quadrat"),
            keywords: &["Grosses schwarzes Quadrat", "Quadrat", "schwarz"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("μεγάλο μαύρο τετράγωνο"),
            keywords: &["γεωμετρικό", "μεγάλο μαύρο τετράγωνο", "τετράγωνο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("black large square"),
            keywords: &["black large square", "geometric", "square"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("cuadrado negro grande"),
            keywords: &["cuadrado", "cuadrado negro grande", "geometría", "negro"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["cuadrado", "cuadrado negro grande", "geométrico"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("suur must ruut"),
            keywords: &["geomeetria", "ruut", "suur must ruut"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("karratu beltz handia"),
            keywords: &["geometriko", "karratu", "karratu beltz handia"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("مربع مشکی بزرگ"),
            keywords: &["شکل هندسی", "مربع", "مربع مشکی بزرگ"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("iso musta neliö"),
            keywords: &["iso musta neliö", "muoto", "neliö"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("malaking itim na parisukat"),
            keywords: &[
                "hugis",
                "itim",
                "malaki",
                "malaking itim na parisukat",
                "parisukat",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("stórur svartur fýrakantur"),
            keywords: &[
                "fýrakantur",
                "mátingarfrøðiligur",
                "stórur svartur fýrakantur",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("grand carré noir"),
            keywords: &["carré", "forme géométrique", "grand carré noir"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("cearnóg mhór dhubh"),
            keywords: &[
                "cearnóg",
                "cearnóg dubh mór",
                "cearnóg mhór dhubh",
                "geoiméadrach",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("ceàrnag mhòr dhubh"),
            keywords: &["ceàrnag", "ceàrnag mhòr dhubh", "geomatrach"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cadrado grande negro"),
            keywords: &["cadrado", "grande", "negro"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("કાળો મોટો ચોરસ"),
            keywords: &["કાળો મોટો ચોરસ", "ચોરસ", "ભૌમિતિક"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("baƙin babban murabba’i"),
            keywords: &["baƙin babban murabba’i", "ilimin halayen sura", "murabba’i"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("ריבוע גדול שחור"),
            keywords: &["צורה", "ריבוע", "ריבוע גדול שחור", "שחור"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("काला बड\u{93c}ा वर\u{94d}ग"),
            keywords: &["काला बड\u{93c}ा वर\u{94d}ग", "ज\u{94d}यामिति", "वर\u{94d}ग"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("veliki crni kvadrat"),
            keywords: &["geometrija", "kvadrat", "veliki crni kvadrat"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("nagy fekete négyzet"),
            keywords: &["geometria", "nagy fekete négyzet", "négyzet"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("սև մեծ քառակուսի"),
            keywords: &["երկրաչափական", "սև մեծ քառակուսի", "քառակուսի"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("persegi besar hitam"),
            keywords: &["geometri", "persegi", "persegi besar hitam"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("sukwia nnukwu ojii"),
            keywords: &["mgbakọ", "sukwia", "sukwia nnukwu ojii"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("stór svartur ferningur"),
            keywords: &["ferningur", "rúmfræði", "stór svartur ferningur"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("quadrato nero grande"),
            keywords: &["geometria", "quadrato", "quadrato nero grande"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("黒四角特大"),
            keywords: &["四角", "正方形", "黒", "黒四角特大"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("kothak gedhe ireng"),
            keywords: &["geometrik", "kothak", "kothak gedhe ireng"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("დიდი შავი კვადრატი"),
            keywords: &["გეომეტრია", "გეომეტრიული", "დიდი შავი კვადრატი", "კვადრატი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("үлкен қара шаршы"),
            keywords: &["геометриялық", "шаршы", "үлкен қара шаршы"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("stort sort kvadrat"),
            keywords: &["geometrisk", "kvadrat", "stort sort kvadrat"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ប\u{17bd}នជ\u{17d2}រ\u{17bb}ងធ\u{17c6}ពណ\u{17cc}ខ\u{17d2}មៅ"),
            keywords: &[
                "ខ\u{17d2}មៅ",
                "ធ\u{17c6}",
                "ប\u{17bd}នជ\u{17d2}រ\u{17bb}ង",
                "ប\u{17bd}នជ\u{17d2}រ\u{17bb}ងធ\u{17c6}ពណ\u{17cc}ខ\u{17d2}មៅ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ದೊಡ\u{ccd}ಡ ಕಪ\u{ccd}ಪು ಚ\u{ccc}ಕ"),
            keywords: &[
                "ಚದರ",
                "ಜ\u{ccd}ಯಾಮ\u{cbf}ತೀಯ",
                "ದೊಡ\u{ccd}ಡ ಕಪ\u{ccd}ಪು ಚ\u{ccc}ಕ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("큰 검은색 사각형"),
            keywords: &["무늬", "사각형", "큰 검은색 사각형"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("काळो व\u{94d}हड चवकोन"),
            keywords: &[
                "काळो व\u{94d}हड चवकोन",
                "कोळो व\u{94d}हड चवकोन",
                "चवकोन",
                "जियोम\u{945}ट\u{94d}रीक",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("чоң кара чарчы"),
            keywords: &["геометрия", "чарчы", "чоң кара чарчы"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("schwaarze grousse Quadrat"),
            keywords: &["Quadrat", "geometresch", "schwaarze grousse Quadrat"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ສ\u{eb5}\u{ec8}ຫ\u{ebc}\u{ec8}ຽມໃຫຍ\u{ec8}ສ\u{eb5}ດຳ"),
            keywords: &[
                "ສ\u{eb5}\u{ec8}ຫ\u{ebc}\u{ec8}ຽມ",
                "ສ\u{eb5}\u{ec8}ຫ\u{ebc}\u{ec8}ຽມໃຫຍ\u{ec8}ສ\u{eb5}ດຳ",
                "ເລຂາຄະນ\u{eb4}ດ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("juodas didelis kvadratas"),
            keywords: &["geometrija", "juodas didelis kvadratas", "kvadratas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("liels melns kvadrāts"),
            keywords: &["kvadrāts", "liels melns kvadrāts", "ģeometrija"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tapawhā rite pango rahi"),
            keywords: &["tapawhā rite", "tapawhā rite pango rahi", "āhuahanga"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("голем црн квадрат"),
            keywords: &["геометрија", "голем црн квадрат", "квадрат"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("വലിയ കറ\u{d41}ത\u{d4d}ത ചത\u{d41}രം"),
            keywords: &[
                "കളം",
                "ചത\u{d41}രം",
                "ജിയോമെട\u{d4d}രിക\u{d4d}ക\u{d4d}",
                "വലിയ കറ\u{d41}ത\u{d4d}ത ചത\u{d41}രം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("том хар дөрвөлжин"),
            keywords: &["геометр", "дөрвөлжин", "том хар дөрвөлжин"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("काळा मोठा चौरस"),
            keywords: &["काळा मोठा चौरस", "चौरस", "भ\u{942}मितीय"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("persegi besar hitam"),
            keywords: &["geometri", "persegi", "persegi besar hitam"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("kwadrat kbir iswed"),
            keywords: &["kwadrat kbir iswed", "kwadru", "ġeometrika"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "အနက\u{103a}ရောင\u{103a} လေးထောင\u{1037}\u{103a}က\u{103d}က\u{103a} အကြ\u{102e}း",
            ),
            keywords: &[
                "ဂျ\u{102e}ဩမေတြ\u{102e}",
                "လေးထောင\u{1037}\u{103a}က\u{103d}က\u{103a}",
                "အနက\u{103a}ရောင\u{103a} လေးထောင\u{1037}\u{103a}က\u{103d}က\u{103a} အကြ\u{102e}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("stor svart firkant"),
            keywords: &["firkant", "geometrisk", "kvadrat", "stor svart firkant"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("कालो ठ\u{942}लो वर\u{94d}ग"),
            keywords: &[
                "कालो ठ\u{942}लो वर\u{94d}ग",
                "ज\u{94d}यामितीय",
                "वर\u{94d}ग",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("groot zwart vierkant"),
            keywords: &["geometrisch", "groot zwart vierkant", "vierkant"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("stor svart firkant"),
            keywords: &["firkant", "geometrisk", "kvadrat", "stor svart firkant"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("କଳ\u{b3e} ବ\u{b43}ହତ\u{b4d}\u{200c} ବର\u{b4d}ଗକ\u{b4d}ଷେତ\u{b4d}ର"),
            keywords: &[
                "କଳ\u{b3e} ବ\u{b43}ହତ\u{b4d}\u{200c} ବର\u{b4d}ଗକ\u{b4d}ଷେତ\u{b4d}ର",
                "ଜ\u{b4d}ୟ\u{b3e}ମ\u{b3f}ତ\u{b3f}କ",
                "ବର\u{b4d}ଗକ\u{b4d}ଷେତ\u{b4d}ର",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਵ\u{a71}ਡਾ ਕਾਲਾ ਵਰਗ"),
            keywords: &["ਜਯਾਮਿਤੀ", "ਵਰਗ", "ਵ\u{a71}ਡਾ ਕਾਲਾ ਵਰਗ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("کالا وڈھا مربع"),
            keywords: &["جیومیٹری دے متعلق", "مربع", "کالا وڈھا مربع"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Blák Bíg Skwea"),
            keywords: &["Blák Bíg Skwea", "Jiọ\u{301}mẹ\u{301}tri", "Skwea"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("duży czarny kwadrat"),
            keywords: &["czarny", "duży", "figura geometryczna", "kwadrat", "średni"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("توره لوی مربع"),
            keywords: &["توره لوی مربع", "جيوميتريکي", "مربع"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("quadrado preto grande"),
            keywords: &["geométrico", "quadrado", "quadrado preto grande"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["geométrico", "quadrado", "quadrado preto grande"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("pătrat negru mare"),
            keywords: &["geometric", "negru", "pătrat", "pătrat negru mare"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-159"),
            keywords: &["E10-159"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("большой черный квадрат"),
            keywords: &[
                "большой квадрат",
                "большой черный квадрат",
                "геометрия",
                "квадрат",
                "фигура",
                "черный",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("kare nini y’umukara"),
            keywords: &["ishusho", "kare", "kare nini y’umukara"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڪارو وڏو چورس"),
            keywords: &["جيوميٽرڪ", "چورس", "ڪارو وڏو چورس"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("කළ\u{dd4} ව\u{dd2}ශ\u{dcf}ල කොට\u{dd4}ව"),
            keywords: &[
                "කළ\u{dd4} ව\u{dd2}ශ\u{dcf}ල කොට\u{dd4}ව",
                "ජ\u{dca}\u{200d}ය\u{dcf}ම\u{dd2}ත\u{dd2}ක",
                "හතරැස\u{dca}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("veľký čierny štvorec"),
            keywords: &["geometria", "veľký čierny štvorec", "štvorec"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("velik črn kvadrat"),
            keywords: &["geometrično", "kvadrat", "velik črn kvadrat"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("afar gees weyn oo madow"),
            keywords: &["afar gees", "afar gees weyn oo madow", "joometriyeed"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("katror i madh i zi"),
            keywords: &["gjeometri", "katror", "katror i madh i zi"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("велики црни квадрат"),
            keywords: &["велики црни квадрат", "гeoмeтриja", "квaдрaт"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("veliki crni kvadrat"),
            keywords: &["geometrija", "kvadrat", "veliki crni kvadrat"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("stor svart ruta"),
            keywords: &["geometrisk", "ruta", "stor svart ruta", "svart"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mraba mkubwa mweusi"),
            keywords: &["jiometri", "mraba", "mraba mkubwa mweusi"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பெரிய கருப\u{bcd}பு சதுரம\u{bcd}"),
            keywords: &[
                "பிள\u{bbe}க\u{bcd}",
                "பெரிய கருப\u{bcd}பு சதுரம\u{bcd}",
                "ல\u{bbe}ர\u{bcd}ஜ\u{bcd} ஸ\u{bcd}கொயர\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ప\u{c46}ద\u{c4d}ద నలుపు రంగు చతురస\u{c4d}రం"),
            keywords: &[
                "చతురస\u{c4d}రం",
                "నలుపు రంగు",
                "ప\u{c46}ద\u{c4d}ద నలుపు రంగు చతురస\u{c4d}రం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("чоркунҷаи калони сиёҳ"),
            keywords: &["геометрӣ", "чоркунҷа", "чоркунҷаи калони сиёҳ"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ส\u{e35}\u{e48}เหล\u{e35}\u{e48}ยมใหญ\u{e48}ส\u{e35}ดำ"),
            keywords: &[
                "ส\u{e35}\u{e48}เหล\u{e35}\u{e48}ยม",
                "ส\u{e35}\u{e48}เหล\u{e35}\u{e48}ยมใหญ\u{e48}ส\u{e35}ดำ",
                "เรขาคณ\u{e34}ต",
            ],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ጸሊም ዓቢ ትርብዒት"),
            keywords: &["ትርብዒት", "ጂኦሜትሪክ", "ጸሊም ዓቢ ትርብዒት"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("gara uly inedördül"),
            keywords: &["gara uly inedördül", "geometrik", "inedördül"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tapafā lahi mo ʻuliʻuli"),
            keywords: &["tapafā", "tapafā lahi mo ʻuliʻuli", "ʻuliʻuli"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("büyük siyah kare"),
            keywords: &["büyük siyah kare", "geometri", "kare"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("قارا چوڭ كىۋادرات"),
            keywords: &["قارا چوڭ كىۋادرات", "كىۋادرات", "گېئومېتىرىيە"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("великий чорний квадрат"),
            keywords: &["великий чорний квадрат", "геометричний", "квадрат"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("کالا بڑا چوکور"),
            keywords: &["بڑا", "جیومیٹری", "چوکور", "کالا"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("katta qora kvadrat"),
            keywords: &["geometrik", "katta qora kvadrat", "kvadrat"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("hình vuông lớn màu đen"),
            keywords: &["hình học", "hình vuông", "hình vuông lớn màu đen"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("kaare bu rëy te ñuul"),
            keywords: &["bu-geometri", "kaare", "kaare bu rëy te ñuul"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("iskwere esikhulu esimnyama"),
            keywords: &["ijiyometriki", "iskwere", "iskwere esikhulu esimnyama"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("onigunmẹrin dudu nla"),
            keywords: &[
                "ilà onigun mé\u{329}rin",
                "jiomé\u{329}tíríkì",
                "onigunmẹrin dudu nla",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("大黑色正方形"),
            keywords: &["大黑色正方形", "幾何", "正方形"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("大黑色正方形"),
            keywords: &["几何", "大黑色正方形", "正方形"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("黑线大方框"),
            keywords: &["大", "正方形", "黑线大方框", "黑色"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("黑色大方塊"),
            keywords: &["方形", "黑色大方塊"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("黑色大正方形"),
            keywords: &["中黑色正方形", "正方形", "黑色中正方形", "黑色大正方形"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("iskwele esikhulu esimnyama"),
            keywords: &["iskwele", "iskwele esikhulu esimnyama", "jiyometrikhi"],
        },
    ],
};
#[doc = "⬜"]
pub const WHITE_LARGE_SQUARE: crate::Emoji = crate::Emoji {
    glyph: "⬜",
    codepoint: "2B1C",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "white large square",
    group: "Symbols",
    subgroup: "geometric",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("groot wit vierkant"),
            keywords: &["geometries", "groot wit vierkant", "vierkant", "wit"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ነጭ ትልቅ ካሬ"),
            keywords: &["ነጭ ትልቅ ካሬ", "ካሬ", "ጂኦሜትሪያዊ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("مربع كبير أبيض"),
            keywords: &["مربع", "مربع كبير أبيض", "هندسي"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("বগ\u{9be} ড\u{9be}ঙৰ বৰ\u{9cd}গ"),
            keywords: &[
                "জ\u{9cd}য\u{9be}মিতিক",
                "বগ\u{9be} ড\u{9be}ঙৰ বৰ\u{9cd}গ",
                "বৰ\u{9cd}গ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("ağ böyük kvadrat"),
            keywords: &["ağ böyük kvadrat", "həndəsi", "kvadrat"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("вялікі белы квадрат"),
            keywords: &["аб’ект", "вялікі белы квадрат", "геаметрычны", "квадрат"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Бял голям квадрат"),
            keywords: &["Бял голям квадрат", "геометричен", "квадрат"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("স\u{9be}দ\u{9be} বড\u{9bc} বর\u{9cd}গক\u{9cd}ষেত\u{9cd}র"),
            keywords: &[
                "জ\u{9cd}য\u{9be}মিতিক",
                "বর\u{9cd}গ\u{9be}ক\u{9be}র",
                "স\u{9be}দ\u{9be} বড\u{9bc} বর\u{9cd}গক\u{9cd}ষেত\u{9cd}র",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("karrez bras gwenn"),
            keywords: &["gwenn", "karrez", "karrez bras gwenn"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("bijeli veliki kvadrat"),
            keywords: &["bijeli veliki kvadrat", "geometrija", "kvadrat"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("quadrat gran blanc"),
            keywords: &["blanc", "geometria", "gran", "quadrat"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᏁᎦ ᎤᏔᎾ ᏅᎩ ᏗᏧᏅᏏᏯ"),
            keywords: &["ᎤᏁᎦ ᎤᏔᎾ ᏅᎩ ᏗᏧᏅᏏᏯ", "ᏅᎩ ᏧᏅᏏᏯ", "ᏗᏎᏍᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("velký bílý čtverec"),
            keywords: &["geometrie", "velký bílý čtverec", "čtverec"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("sgwâr mawr wyn"),
            keywords: &["geometrig", "sgwâr", "sgwâr mawr wyn"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("stort hvidt kvadrat"),
            keywords: &["geometrisk", "kvadrat", "stort hvidt kvadrat"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("großes weißes Quadrat"),
            keywords: &["Quadrat", "großes weißes Quadrat", "weiß"],
        },
        #[cfg(feature = "de_CH")]
        crate::Annotation {
            lang: "de_CH",
            tts: Some("Grosses weisses Quadrat"),
            keywords: &["Grosses weisses Quadrat", "Quadrat", "weiss"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("μεγάλο λευκό τετράγωνο"),
            keywords: &["γεωμετρικό", "μεγάλο λευκό τετράγωνο", "τετράγωνο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("white large square"),
            keywords: &["geometric", "square", "white large square"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("cuadrado blanco grande"),
            keywords: &["blanco", "cuadrado", "cuadrado blanco grande", "geometría"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["blanco", "cuadrado", "grande"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["cuadrado", "cuadrado blanco grande", "geométrico"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("suur valge ruut"),
            keywords: &["geomeetria", "ruut", "suur valge ruut"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("karratu zuri handia"),
            keywords: &["geometriko", "karratu", "karratu zuri handia"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("مربع سفید بزرگ"),
            keywords: &["شکل هندسی", "مربع", "مربع سفید بزرگ"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("iso valkoinen neliö"),
            keywords: &["iso valkoinen neliö", "muoto", "neliö"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("malaking puting parisukat"),
            keywords: &[
                "hugis",
                "malaki",
                "malaking puting parisukat",
                "parisukat",
                "puti",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("stórur hvítur fýrakantur"),
            keywords: &[
                "fýrakantur",
                "mátingarfrøðiligur",
                "stórur hvítur fýrakantur",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("grand carré blanc"),
            keywords: &["forme", "grand carré blanc", "géométrie"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("cearnóg mhór bhán"),
            keywords: &[
                "cearnóg",
                "cearnóg bán mór",
                "cearnóg mhór bhán",
                "geoiméadrach",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("ceàrnag mhòr gheal"),
            keywords: &["ceàrnag", "ceàrnag mhòr gheal", "geomatrach"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cadrado grande branco"),
            keywords: &["branco", "cadrado", "grande"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("સફ\u{ac7}દ મોટો ચોરસ"),
            keywords: &["ચોરસ", "ભૌમિતિક", "સફ\u{ac7}દ મોટો ચોરસ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("farin babban murabba’i"),
            keywords: &["farin babban murabba’i", "ilimin halayen sura", "murabba’i"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("ריבוע גדול לבן"),
            keywords: &["לבן", "צורה", "ריבוע", "ריבוע גדול לבן"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("बड\u{93c}ा सफ\u{93c}\u{947}द वर\u{94d}ग"),
            keywords: &[
                "ज\u{94d}यामिति",
                "बड\u{93c}ा वर\u{94d}ग",
                "बड\u{93c}ा सफ\u{93c}\u{947}द वर\u{94d}ग",
                "बड\u{93c}ा सफ\u{947}द वर\u{94d}ग",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("veliki bijeli kvadrat"),
            keywords: &["geometrija", "kvadrat", "veliki bijeli kvadrat"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("nagy fehér négyzet"),
            keywords: &["geometria", "nagy fehér négyzet", "négyzet"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("սպիտակ մեծ քառակուսի"),
            keywords: &["երկրաչափական", "սպիտակ մեծ քառակուսի", "քառակուսի"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("persegi besar putih"),
            keywords: &["geometri", "persegi", "persegi besar putih"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("sukwia nnukwu ọcha"),
            keywords: &["mgbakọ", "sukwia", "sukwia nnukwu ọcha"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("stór hvítur ferningur"),
            keywords: &["ferningur", "rúmfræði", "stór hvítur ferningur"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("quadrato bianco grande"),
            keywords: &["geometria", "quadrato", "quadrato bianco grande"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("白四角特大"),
            keywords: &["四角", "正方形", "白", "白四角特大"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("kothak gedhe putih"),
            keywords: &["geometrik", "kothak", "kothak gedhe putih"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("დიდი თეთრი კვადრატი"),
            keywords: &[
                "გეომეტრია",
                "გეომეტრიული",
                "დიდი თეთრი კვადრატი",
                "კვადრატი",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("үлкен ақ шаршы"),
            keywords: &["геометриялық", "шаршы", "үлкен ақ шаршы"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("stort hvidt kvadrat"),
            keywords: &["geometrisk", "kvadrat", "stort hvidt kvadrat"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ប\u{17bd}នជ\u{17d2}រ\u{17bb}ងធ\u{17c6}ពណ\u{17cc}ស"),
            keywords: &[
                "ធ\u{17c6}",
                "ប\u{17bd}នជ\u{17d2}រ\u{17bb}ង",
                "ប\u{17bd}នជ\u{17d2}រ\u{17bb}ងធ\u{17c6}ពណ\u{17cc}ស",
                "\u{200b} ស",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ದೊಡ\u{ccd}ಡ ಬ\u{cbf}ಳ\u{cbf} ಚ\u{ccc}ಕ"),
            keywords: &[
                "ದೊಡ\u{ccd}ಡ ಬ\u{cbf}ಳ\u{cbf} ಚ\u{ccc}ಕ",
                "ಬ\u{cbf}ಳ\u{cbf} ಬಣ\u{ccd}ಣದ ದೊಡ\u{ccd}ಡ ಚ\u{ccc}ಕ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("큰 흰색 사각형"),
            keywords: &["무늬", "사각형", "큰 흰색 사각형"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("धवो व\u{94d}हड चवकोन"),
            keywords: &["चवकोन", "जियोम\u{945}ट\u{94d}रीक", "धवो व\u{94d}हड चवकोन"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("чоң ак чарчы"),
            keywords: &["геометрия", "чарчы", "чоң ак чарчы"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("wäisse grousse Quadrat"),
            keywords: &["Quadrat", "geometresch", "wäisse grousse Quadrat"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ສ\u{eb5}\u{ec8}ຫ\u{ebc}\u{ec8}ຽມໃຫຍ\u{ec8}ສ\u{eb5}ຂາວ"),
            keywords: &[
                "ສ\u{eb5}\u{ec8}ຫ\u{ebc}\u{ec8}ຽມ",
                "ສ\u{eb5}\u{ec8}ຫ\u{ebc}\u{ec8}ຽມໃຫຍ\u{ec8}ສ\u{eb5}ຂາວ",
                "ເລຂາຄະນ\u{eb4}ດ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("baltas didelis kvadratas"),
            keywords: &["baltas didelis kvadratas", "geometrija", "kvadratas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("liels balts kvadrāts"),
            keywords: &["kvadrāts", "liels balts kvadrāts", "ģeometrija"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tapawhā rite mā rahi"),
            keywords: &["tapawhā rite", "tapawhā rite mā rahi", "āhuahanga"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("голем бел квадрат"),
            keywords: &["геометрија", "голем бел квадрат", "квадрат"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("വലിയ വെള\u{d41}ത\u{d4d}ത ചത\u{d41}രം"),
            keywords: &[
                "കളം",
                "ചത\u{d41}രം",
                "ജിയോമെട\u{d4d}രിക\u{d4d}ക\u{d4d}",
                "വലിയ വെള\u{d41}ത\u{d4d}ത ചത\u{d41}രം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("том цагаан дөрвөлжин"),
            keywords: &["геометр", "дөрвөлжин", "том цагаан дөрвөлжин"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("पा\u{902}ढरा मोठा चौरस"),
            keywords: &["चौरस", "पा\u{902}ढरा मोठा चौरस", "भ\u{942}मितीय"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("persegi besar putih"),
            keywords: &["geometri", "persegi", "persegi besar putih"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("kwadrat kbir abjad"),
            keywords: &["kwadrat kbir abjad", "kwadru", "ġeometrika"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "အဖြ\u{1030}ရောင\u{103a} လေးထောင\u{1037}\u{103a}က\u{103d}က\u{103a} အကြ\u{102e}း",
            ),
            keywords: &[
                "ဂျ\u{102e}ဩမေတြ\u{102e}",
                "လေးထောင\u{1037}\u{103a}က\u{103d}က\u{103a}",
                "အဖြ\u{1030}ရောင\u{103a} လေးထောင\u{1037}\u{103a}က\u{103d}က\u{103a} အကြ\u{102e}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("stor hvit firkant"),
            keywords: &["firkant", "geometrisk", "kvadrat", "stor hvit firkant"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("स\u{947}तो ठ\u{942}लो वर\u{94d}ग"),
            keywords: &[
                "ज\u{94d}यामितीय",
                "वर\u{94d}ग",
                "स\u{947}तो ठ\u{942}लो वर\u{94d}ग",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("groot wit vierkant"),
            keywords: &["geometrisch", "groot wit vierkant", "vierkant"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("stor kvit firkant"),
            keywords: &["firkant", "geometrisk", "kvadrat", "stor kvit firkant"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଧଳ\u{b3e} ବ\u{b43}ହତ\u{b4d}\u{200c} ବର\u{b4d}ଗକ\u{b4d}ଷେତ\u{b4d}ର"),
            keywords: &[
                "ଜ\u{b4d}ୟ\u{b3e}ମ\u{b3f}ତ\u{b3f}କ",
                "ଧଳ\u{b3e} ବ\u{b43}ହତ\u{b4d}\u{200c} ବର\u{b4d}ଗକ\u{b4d}ଷେତ\u{b4d}ର",
                "ବର\u{b4d}ଗକ\u{b4d}ଷେତ\u{b4d}ର",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਵ\u{a71}ਡਾ ਚਿ\u{a71}ਟਾ ਵਰਗ"),
            keywords: &["ਜਯਾਮਿਤੀ", "ਵਰਗ", "ਵ\u{a71}ਡਾ ਚਿ\u{a71}ਟਾ ਵਰਗ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("چٹ\u{651}ا وڈھا مربع"),
            keywords: &["جیومیٹری دے متعلق", "مربع", "چٹ\u{651}ا وڈھا مربع"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Waít Bíg Skwea"),
            keywords: &["Jiọ\u{301}mẹ\u{301}tri", "Skwea", "Waít Bíg Skwea"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("duży biały kwadrat"),
            keywords: &["biały", "duży", "figura geometryczna", "kwadrat"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("سپينه لوی مربع"),
            keywords: &["جيوميتريکي", "سپينه لوی مربع", "مربع"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("quadrado branco grande"),
            keywords: &["geométrico", "quadrado", "quadrado branco grande"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["geométrico", "quadrado", "quadrado branco grande"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("pătrat alb mare"),
            keywords: &["alb", "geometric", "pătrat", "pătrat alb mare"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-160"),
            keywords: &["E10-160"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("большой белый квадрат"),
            keywords: &[
                "белый",
                "большой белый квадрат",
                "большой квадрат",
                "геометрия",
                "квадрат",
                "фигура",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("kare nini y’umweru"),
            keywords: &["ishusho", "kare", "kare nini y’umweru"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("سفيد وڏو چورس"),
            keywords: &["جيوميٽرڪ", "سفيد وڏو چورس", "چورس"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ස\u{dd4}ද\u{dd4} ව\u{dd2}ශ\u{dcf}ල කොට\u{dd4}ව"),
            keywords: &[
                "ජ\u{dca}\u{200d}ය\u{dcf}ම\u{dd2}ත\u{dd2}ක",
                "ස\u{dd4}ද\u{dd4} ව\u{dd2}ශ\u{dcf}ල කොට\u{dd4}ව",
                "හතරැස\u{dca}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("veľký biely štvorec"),
            keywords: &["geometria", "veľký biely štvorec", "štvorec"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("velik bel kvadrat"),
            keywords: &["geometrično", "kvadrat", "velik bel kvadrat"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("afar gees weyn oo cad"),
            keywords: &["afar gees", "afar gees weyn oo cad", "joometriyeed"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("katror i madh i bardhë"),
            keywords: &["gjeometrik", "katror", "katror i madh i bardhë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("велики бели квадрат"),
            keywords: &["велики бели квадрат", "гeoмeтриja", "квaдрaт"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("велики бијели квадрат"),
            keywords: &["велики бијели квадрат"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("veliki beli kvadrat"),
            keywords: &["geometrija", "kvadrat", "veliki beli kvadrat"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("veliki bijeli kvadrat"),
            keywords: &["veliki bijeli kvadrat"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("stor vit ruta"),
            keywords: &["geometrisk", "ruta", "stor vit ruta"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mraba mkubwa mweupe"),
            keywords: &["jiometri", "mraba", "mraba mkubwa mweupe"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பெரிய வெள\u{bcd}ளை சதுரம\u{bcd}"),
            keywords: &[
                "ஒயிட\u{bcd}",
                "பெரிய வெள\u{bcd}ளை சதுரம\u{bcd}",
                "ல\u{bbe}ர\u{bcd}ஜ\u{bcd} ஸ\u{bcd}கொயர\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ప\u{c46}ద\u{c4d}ద త\u{c46}లుపు రంగు చతురస\u{c4d}రం"),
            keywords: &[
                "చతురస\u{c4d}రం",
                "త\u{c46}లుపు రంగు",
                "ప\u{c46}ద\u{c4d}ద త\u{c46}లుపు రంగు చతురస\u{c4d}రం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("чоркунҷаи калони сафед"),
            keywords: &["геометрӣ", "чоркунҷа", "чоркунҷаи калони сафед"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ส\u{e35}\u{e48}เหล\u{e35}\u{e48}ยมใหญ\u{e48}ส\u{e35}ขาว"),
            keywords: &[
                "ส\u{e35}\u{e48}เหล\u{e35}\u{e48}ยม",
                "ส\u{e35}\u{e48}เหล\u{e35}\u{e48}ยมใหญ\u{e48}ส\u{e35}ขาว",
                "เรขาคณ\u{e34}ต",
            ],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ጻዕዳ ዓቢ ትርብዒት"),
            keywords: &["ትርብዒት", "ጂኦሜትሪክ", "ጻዕዳ ዓቢ ትርብዒት"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ak uly inedördül"),
            keywords: &["ak uly inedördül", "geometrik", "inedördül"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tapafā lahi mo hinehina"),
            keywords: &["hinehina", "tapafā", "tapafā lahi mo hinehina"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("büyük beyaz kare"),
            keywords: &["büyük beyaz kare", "geometri", "kare"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئاق چوڭ كىۋادرات"),
            keywords: &["ئاق چوڭ كىۋادرات", "كىۋادرات", "گېئومېتىرىيە"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("великий білий квадрат"),
            keywords: &["великий білий квадрат", "геометричний", "квадрат"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("سفید بڑا چوکور"),
            keywords: &["بڑا", "جیومیٹری", "سفید", "چوکور"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("katta oq kvadrat"),
            keywords: &["geometrik", "katta oq kvadrat", "kvadrat"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("hình vuông lớn màu trắng"),
            keywords: &["hình học", "hình vuông", "hình vuông lớn màu trắng"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("kaare bu rëy te weex"),
            keywords: &["bu-geometri", "kaare", "kaare bu rëy te weex"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("iskwere esikhulu esimhlophe"),
            keywords: &["ijiyometriki", "iskwere", "iskwere esikhulu esimhlophe"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("onigunmẹrin funfun nla"),
            keywords: &[
                "ilà onigun mé\u{329}rin",
                "jiomé\u{329}tíríkì",
                "onigunmẹrin funfun nla",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("大白色正方形"),
            keywords: &["大白色正方形", "幾何", "正方形"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("大白色正方形"),
            keywords: &["几何", "大白色正方形", "正方形"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("白线大方框"),
            keywords: &["大", "正方形", "白线大方框", "白色"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("白色大方塊"),
            keywords: &["方形", "白色大方塊"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("白色大正方形"),
            keywords: &["大白色正方形", "正方形", "白色大正方形"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("iskwele esimhlophe esikhulu"),
            keywords: &["iskwele", "iskwele esimhlophe esikhulu", "jiyometrikhi"],
        },
    ],
};
#[doc = "◼\u{fe0f}"]
pub const BLACK_MEDIUM_SQUARE: crate::Emoji = crate::Emoji {
    glyph: "◼\u{fe0f}",
    codepoint: "25FC FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "black medium square",
    group: "Symbols",
    subgroup: "geometric",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "◼",
        codepoint: "25FC",
        status: crate::Status::Unqualified,
        introduction_version: 0.6f32,
        name: "black medium square",
        group: "Symbols",
        subgroup: "geometric",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("swart mediumvierkant"),
            keywords: &["geometries", "swart", "swart mediumvierkant", "vierkant"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ጥቁር መካከለኛ ካሬ"),
            keywords: &["ካሬ", "ጂኦሜትሪያዊ", "ጥቁር መካከለኛ ካሬ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("مربع متوسط أسود"),
            keywords: &["مربع", "مربع متوسط أسود", "هندسي"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ক’ল\u{9be} মধ\u{9cd}যমীয\u{9bc}\u{9be} বৰ\u{9cd}গ"),
            keywords: &[
                "ক’ল\u{9be} মধ\u{9cd}যমীয\u{9bc}\u{9be} বৰ\u{9cd}গ",
                "জ\u{9cd}য\u{9be}মিতিক",
                "বৰ\u{9cd}গ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("qara orta ölçülü kvadrat"),
            keywords: &["həndəsi", "kvadrat", "qara orta ölçülü kvadrat"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("чорны сярэдні квадрат"),
            keywords: &["аб’ект", "геаметрычны", "квадрат", "чорны сярэдні квадрат"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Черен среден квадрат"),
            keywords: &["Черен среден квадрат", "геометричен", "квадрат"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ক\u{9be}লো ম\u{9be}ঝ\u{9be}রি বর\u{9cd}গক\u{9cd}ষেত\u{9cd}র"),
            keywords: &[
                "ক\u{9be}লো ম\u{9be}ঝ\u{9be}রি বর\u{9cd}গক\u{9cd}ষেত\u{9cd}র",
                "জ\u{9cd}য\u{9be}মিতিক",
                "বর\u{9cd}গ\u{9be}ক\u{9be}র",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("karrez etre du"),
            keywords: &["etre", "karrez", "karrez etre du"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("crni kvadrat"),
            keywords: &["crni kvadrat", "geometrija", "kvadrat"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("quadrat mitjà negre"),
            keywords: &["geometria", "mitjà", "negre", "quadrat"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎬᎿᎨ ᎠᏲᏟᎨ ᏅᎩ ᏧᏅᏏᏯ"),
            keywords: &["ᎬᎿᎨ ᎠᏲᏟᎨ ᏅᎩ ᏧᏅᏏᏯ", "ᏅᎩ ᏧᏅᏏᏯ", "ᏗᏎᏍᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("střední černý čtverec"),
            keywords: &["geometrie", "střední černý čtverec", "čtverec"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("sgwâr canolig du"),
            keywords: &["geometrig", "sgwâr", "sgwâr canolig du"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("mellemstort sort kvadrat"),
            keywords: &["geometrisk", "kvadrat", "mellemstort sort kvadrat"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("mittelgroßes schwarzes Quadrat"),
            keywords: &["Quadrat", "mittelgroßes schwarzes Quadrat", "schwarz"],
        },
        #[cfg(feature = "de_CH")]
        crate::Annotation {
            lang: "de_CH",
            tts: Some("Mittelgrosses schwarzes Quadrat"),
            keywords: &["Mittelgrosses schwarzes Quadrat", "Quadrat", "schwarz"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("μεσαίο μαύρο τετράγωνο"),
            keywords: &["γεωμετρικό", "μεσαίο μαύρο τετράγωνο", "τετράγωνο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("black medium square"),
            keywords: &["black medium square", "geometric", "square"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("cuadrado negro mediano"),
            keywords: &["cuadrado", "cuadrado negro mediano", "geometría", "negro"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["cuadrado", "mediano", "negro"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["cuadrado", "cuadrado negro mediano", "geométrico"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("keskmine must ruut"),
            keywords: &["geomeetria", "keskmine must ruut", "ruut"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("karratu beltz ertaina"),
            keywords: &["geometriko", "karratu", "karratu beltz ertaina"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("مربع مشکی متوسط"),
            keywords: &["شکل هندسی", "مربع", "مربع مشکی متوسط"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("keskikokoinen musta neliö"),
            keywords: &["keskikokoinen musta neliö", "muoto", "neliö"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("katamtamang itim na parisukat"),
            keywords: &[
                "hugis",
                "itim",
                "katamtaman",
                "katamtamang itim na parisukat",
                "parisukat",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("svartur fýrakantur"),
            keywords: &["fýrakantur", "mátingarfrøðiligur", "svartur fýrakantur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("carré moyen noir"),
            keywords: &["carré", "carré moyen noir", "forme géométrique"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("carré noir de taille moyenne"),
            keywords: &["carré noir de taille moyenne", "forme", "géométrie"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("meánchearnóg dhubh"),
            keywords: &[
                "cearnóg",
                "geoiméadrach",
                "meáncearnóg dubh",
                "meánchearnóg dhubh",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("ceàrnag mheadhanach dhubh"),
            keywords: &["ceàrnag", "ceàrnag mheadhanach dhubh", "geomatrach"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cadrado mediano negro"),
            keywords: &["cadrado", "mediano", "negro"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("કાળો મધ\u{acd}યમ ચોરસ"),
            keywords: &["કાળો મધ\u{acd}યમ ચોરસ", "ચોરસ", "ભૌમિતિક"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("baƙin matsakaicin murabba’i"),
            keywords: &[
                "baƙin matsakaicin murabba’i",
                "ilimin halayen sura",
                "murabba’i",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("ריבוע שחור בינוני"),
            keywords: &["צורה", "ריבוע", "ריבוע שחור בינוני", "שחור"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("काला मध\u{94d}यम वर\u{94d}ग"),
            keywords: &["काला मध\u{94d}यम वर\u{94d}ग", "ज\u{94d}यामिति"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("srednji crni kvadrat"),
            keywords: &["geometrija", "kvadrat", "srednji crni kvadrat"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("közepes fekete négyzet"),
            keywords: &["geometria", "közepes fekete négyzet", "négyzet"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("սև միջին չափի քառակուսի"),
            keywords: &["երկրաչափական", "սև միջին չափի քառակուսի", "քառակուսի"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("persegi medium hitam"),
            keywords: &["geometri", "persegi", "persegi medium hitam"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("sukwia keetiti ojii"),
            keywords: &["mgbakọ", "sukwia", "sukwia keetiti ojii"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("svartur meðalstór ferningur"),
            keywords: &["ferningur", "rúmfræði", "svartur meðalstór ferningur"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("quadrato nero medio"),
            keywords: &["geometria", "quadrato", "quadrato nero medio"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("黒四角大"),
            keywords: &["四角", "正方形", "黒", "黒四角大"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("kothak sedhengan ireng"),
            keywords: &["geometrik", "kothak", "kothak sedhengan ireng"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("საშუალო შავი კვადრატი"),
            keywords: &[
                "გეომეტრია",
                "გეომეტრიული",
                "კვადრატი",
                "საშუალო შავი კვადრატი",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("орташа қара шаршы"),
            keywords: &["геометриялық", "орташа қара шаршы", "шаршы"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("mellemstort sort kvadrat"),
            keywords: &["geometrisk", "kvadrat", "mellemstort sort kvadrat"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ប\u{17bd}នជ\u{17d2}រ\u{17bb}ងធ\u{17c6}ល\u{17d2}មមពណ\u{17cc}ខ\u{17d2}មៅ"),
            keywords: &[
                "ធ\u{17c6}ល\u{17d2}មម",
                "ប\u{17bd}នជ\u{17d2}រ\u{17bb}ង",
                "ប\u{17bd}នជ\u{17d2}រ\u{17bb}ងធ\u{17c6}ល\u{17d2}មមពណ\u{17cc}ខ\u{17d2}មៅ",
                "\u{200b}ខ\u{17d2}មៅ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕಪ\u{ccd}ಪು ಬಣ\u{ccd}ಣದ ಮಧ\u{ccd}ಯಮ ಚ\u{ccc}ಕ"),
            keywords: &[
                "ಕಪ\u{ccd}ಪು ಬಣ\u{ccd}ಣದ ಚ\u{ccc}ಕ",
                "ಕಪ\u{ccd}ಪು ಬಣ\u{ccd}ಣದ ಮಧ\u{ccd}ಯಮ ಚ\u{ccc}ಕ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("중간 검은색 사각형"),
            keywords: &["무늬", "사각형", "중간 검은색 사각형"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("काळो मध\u{94d}यम चवकोन"),
            keywords: &["काळो मध\u{94d}यम चवकोन", "चवकोन", "जियोम\u{945}ट\u{94d}रीक"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("орточо кара чарчы"),
            keywords: &["геометрия", "орточо кара чарчы", "чарчы"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("mëttelgrousse schwaarze Quadrat"),
            keywords: &["Quadrat", "geometresch", "mëttelgrousse schwaarze Quadrat"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ສ\u{eb5}\u{ec8}ຫ\u{ebc}\u{ec8}ຽມປານກາງສ\u{eb5}ດຳ"),
            keywords: &[
                "ສ\u{eb5}\u{ec8}ຫ\u{ebc}\u{ec8}ຽມ",
                "ສ\u{eb5}\u{ec8}ຫ\u{ebc}\u{ec8}ຽມປານກາງສ\u{eb5}ດຳ",
                "ເລຂາຄະນ\u{eb4}ດ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("juodas vidutinis kvadratas"),
            keywords: &["geometrija", "juodas vidutinis kvadratas", "kvadratas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("vidējs melns kvadrāts"),
            keywords: &["kvadrāts", "vidējs melns kvadrāts", "ģeometrija"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tapawhā rite pango waenga"),
            keywords: &["tapawhā rite", "tapawhā rite pango waenga", "āhuahanga"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("среден црн квадрат"),
            keywords: &["геометрија", "квадрат", "среден црн квадрат"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഇടത\u{d4d}തരം കറ\u{d41}ത\u{d4d}ത ചത\u{d41}രം"),
            keywords: &[
                "ഇടത\u{d4d}തരം കറ\u{d41}ത\u{d4d}ത ചത\u{d41}രം",
                "കളം",
                "ചത\u{d41}രം",
                "ജിയോമെട\u{d4d}രിക\u{d4d}ക\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("хар дундаж дөрвөлжин"),
            keywords: &["геометр", "дөрвөлжин", "хар дундаж дөрвөлжин"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("काळा मध\u{94d}\u{200d}यम आकाराचा चौरस"),
            keywords: &[
                "काळा मध\u{94d}\u{200d}यम आकाराचा चौरस",
                "चौरस",
                "भ\u{942}मितीय",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("persegi sederhana hitam"),
            keywords: &["geometri", "persegi", "persegi sederhana hitam"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("kwadrat medju iswed"),
            keywords: &["kwadrat medju iswed", "kwadru", "ġeometrika"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "အနက\u{103a}ရောင\u{103a} လေးထောင\u{1037}\u{103a}က\u{103d}က\u{103a} အလတ\u{103a}စား",
            ),
            keywords: &[
                "ဂျ\u{102e}ဩမေတြ\u{102e}",
                "လေးထောင\u{1037}\u{103a}က\u{103d}က\u{103a}",
                "အနက\u{103a}ရောင\u{103a} လေးထောင\u{1037}\u{103a}က\u{103d}က\u{103a} အလတ\u{103a}စား",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("mellomstor svart firkant"),
            keywords: &[
                "firkant",
                "geometrisk",
                "kvadrat",
                "mellomstor svart firkant",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("कालो मध\u{94d}यम वर\u{94d}ग"),
            keywords: &[
                "कालो मध\u{94d}यम वर\u{94d}ग",
                "ज\u{94d}यामितीय",
                "वर\u{94d}ग",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("middelgroot zwart vierkant"),
            keywords: &["geometrisch", "middelgroot zwart vierkant", "vierkant"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("mellomstor svart firkant"),
            keywords: &[
                "firkant",
                "geometrisk",
                "kvadrat",
                "mellomstor svart firkant",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("କଳ\u{b3e} ମଧ\u{b4d}ୟମ ବର\u{b4d}ଗକ\u{b4d}ଷେତ\u{b4d}ର"),
            keywords: &[
                "କଳ\u{b3e} ମଧ\u{b4d}ୟମ ବର\u{b4d}ଗକ\u{b4d}ଷେତ\u{b4d}ର",
                "ଜ\u{b4d}ୟ\u{b3e}ମ\u{b3f}ତ\u{b3f}କ",
                "ବର\u{b4d}ଗକ\u{b4d}ଷେତ\u{b4d}ର",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਦਰਮਿਆਨਾ ਕਾਲਾ ਵਰਗ"),
            keywords: &["ਜਯਾਮਿਤੀ", "ਦਰਮਿਆਨਾ ਕਾਲਾ ਵਰਗ", "ਵਰਗ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("کالا درمیانہ مربع"),
            keywords: &["جیومیٹری دے متعلق", "مربع", "کالا درمیانہ مربع"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Blák Mídiọ\u{301}m Saíz Skwea"),
            keywords: &[
                "Blák Mídiọ\u{301}m Saíz Skwea",
                "Jiọ\u{301}mẹ\u{301}tri",
                "Skwea",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("średni czarny kwadrat"),
            keywords: &["czarny", "duży", "figura geometryczna", "kwadrat", "średni"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("توره منځنۍ مربع"),
            keywords: &["توره منځنۍ مربع", "جيوميتريکي", "مربع"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("quadrado preto médio"),
            keywords: &["geométrico", "quadrado", "quadrado preto médio"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["geométrico", "quadrado", "quadrado preto médio"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("pătrat negru mediu"),
            keywords: &["geometric", "negru", "pătrat", "pătrat negru mediu"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-038"),
            keywords: &["E10-038"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("черный квадрат"),
            keywords: &["геометрия", "квадрат", "фигура", "черный"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("kare y’umukara iringaniye"),
            keywords: &["ishusho", "kare", "kare y’umukara iringaniye"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڪارو وچولو چورس"),
            keywords: &["جيوميٽرڪ", "چورس", "ڪارو وچولو چورس"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("කළ\u{dd4} මධ\u{dca}\u{200d}යම ප\u{dca}\u{200d}රම\u{dcf}ණයේ කොට\u{dd4}ව"),
            keywords: &[
                "කළ\u{dd4} මධ\u{dca}\u{200d}යම ප\u{dca}\u{200d}රම\u{dcf}ණයේ කොට\u{dd4}ව",
                "ජ\u{dca}\u{200d}ය\u{dcf}ම\u{dd2}ත\u{dd2}ක",
                "හතරැස\u{dca}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("stredný čierny štvorec"),
            keywords: &["geometria", "stredný čierny štvorec", "štvorec"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("srednji črn kvadrat"),
            keywords: &["geometrično", "kvadrat", "srednji črn kvadrat"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("afar gees dhexdhexaad oo madow"),
            keywords: &[
                "afar gees",
                "afar gees dhexdhexaad oo madow",
                "joometriyeed",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("katror mesatar i zi"),
            keywords: &["gjeometri", "katror", "katror mesatar i zi"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("црни квадрат средње величине"),
            keywords: &["гeoмeтриja", "квaдрaт", "црни квадрат средње величине"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("crni kvadrat srednje veličine"),
            keywords: &["crni kvadrat srednje veličine", "geometrija", "kvadrat"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("mellanstor svart ruta"),
            keywords: &["geometrisk", "mellanstor svart ruta", "ruta", "svart"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mraba wa wastani mweusi"),
            keywords: &["jiometri", "mraba", "mraba wa wastani mweusi"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("நடுத\u{bcd}தர கருப\u{bcd}பு சதுரம\u{bcd}"),
            keywords: &[
                "கருப\u{bcd}பு சதுரம\u{bcd}",
                "நடுத\u{bcd}தர கருப\u{bcd}பு சதுரம\u{bcd}",
                "ம\u{bc0}டியோ பிள\u{bbe}க\u{bcd} ஸ\u{bcd}கொயர\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("మధ\u{c4d}యస\u{c4d}థ నలుపు రంగు చతురస\u{c4d}రం"),
            keywords: &[
                "చతురస\u{c4d}రం",
                "నలుపు రంగు",
                "మధ\u{c4d}యస\u{c4d}థ నలుపు రంగు చతురస\u{c4d}రం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("чоркунҷаи миёнаи сиёҳ"),
            keywords: &["геометрӣ", "чоркунҷа", "чоркунҷаи миёнаи сиёҳ"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ส\u{e35}\u{e48}เหล\u{e35}\u{e48}ยมขนาดกลางส\u{e35}ดำ"),
            keywords: &[
                "ส\u{e35}\u{e48}เหล\u{e35}\u{e48}ยม",
                "ส\u{e35}\u{e48}เหล\u{e35}\u{e48}ยมขนาดกลางส\u{e35}ดำ",
                "เรขาคณ\u{e34}ต",
            ],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ጸሊም ማእከላይ ትርብዒት"),
            keywords: &["ትርብዒት", "ጂኦሜትሪክ", "ጸሊም ማእከላይ ትርብዒት"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("gara ortaça inedördül"),
            keywords: &["gara ortaça inedördül", "geometrik", "inedördül"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tapafā tauloto mo ʻuliʻuli"),
            keywords: &["tapafā", "tapafā tauloto mo ʻuliʻuli", "ʻuliʻuli"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("orta boy siyah kare"),
            keywords: &["geometri", "kare", "orta boy siyah kare"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("قارا ئارا كىۋادرات"),
            keywords: &["قارا ئارا كىۋادرات", "كىۋادرات", "گېئومېتىرىيە"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("середній чорний квадрат"),
            keywords: &["геометричний", "квадрат", "середній чорний квадрат"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("کالا میڈیم چوکور"),
            keywords: &["جیومیٹری", "میڈیم", "چوکور", "کالا"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("o‘rtacha qora kvadrat"),
            keywords: &["geometrik", "kvadrat", "o‘rtacha qora kvadrat"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("hình vuông trung bình màu đen"),
            keywords: &["hình học", "hình vuông", "hình vuông trung bình màu đen"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("kaare bu yam te ñuul"),
            keywords: &["bu-geometri", "kaare", "kaare bu yam te ñuul"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("iskwere esiphakathi esimnyama"),
            keywords: &["ijiyometriki", "iskwere", "iskwere esiphakathi esimnyama"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("ilà onígun mé\u{329}rin aláàárín dúdú"),
            keywords: &[
                "ilà onigun mé\u{329}rin",
                "ilà onígun mé\u{329}rin aláàárín dúdú",
                "jiomé\u{329}tíríkì",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("中黑色正方形"),
            keywords: &["中黑色正方形", "幾何", "正方形"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("中黑色正方形"),
            keywords: &["中黑色正方形", "几何", "正方形"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("黑色中方块"),
            keywords: &["中等", "正方形", "黑色", "黑色中方块"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("黑色中方塊"),
            keywords: &["方形", "黑色中方塊"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("黑色中正方形"),
            keywords: &["中黑色正方形", "正方形", "黑色中正方形"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("iskwele esimnyama esimaphakathi"),
            keywords: &["iskwele", "iskwele esimnyama esimaphakathi", "jiyometrikhi"],
        },
    ],
};
#[doc = "◻\u{fe0f}"]
pub const WHITE_MEDIUM_SQUARE: crate::Emoji = crate::Emoji {
    glyph: "◻\u{fe0f}",
    codepoint: "25FB FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "white medium square",
    group: "Symbols",
    subgroup: "geometric",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "◻",
        codepoint: "25FB",
        status: crate::Status::Unqualified,
        introduction_version: 0.6f32,
        name: "white medium square",
        group: "Symbols",
        subgroup: "geometric",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("wit mediumvierkant"),
            keywords: &["geometries", "vierkant", "wit", "wit mediumvierkant"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ነጭ መካከለኛ ካሬ"),
            keywords: &["ነጭ መካከለኛ ካሬ", "ካሬ", "ጂኦሜትሪያዊ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("مربع متوسط أبيض"),
            keywords: &["مربع", "مربع متوسط أبيض", "هندسي"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("বগ\u{9be} মধ\u{9cd}যমীয\u{9bc}\u{9be} বৰ\u{9cd}গ"),
            keywords: &[
                "জ\u{9cd}য\u{9be}মিতিক",
                "বগ\u{9be} মধ\u{9cd}যমীয\u{9bc}\u{9be} বৰ\u{9cd}গ",
                "বৰ\u{9cd}গ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("ağ orta ölçülü kvadrat"),
            keywords: &["ağ orta ölçülü kvadrat", "həndəsi", "kvadrat"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("белы сярэдні квадрат"),
            keywords: &["аб’ект", "белы сярэдні квадрат", "геаметрычны", "квадрат"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Бял среден квадрат"),
            keywords: &["Бял среден квадрат", "геометричен", "квадрат"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("স\u{9be}দ\u{9be} ম\u{9be}ঝ\u{9be}রি বর\u{9cd}গক\u{9cd}ষেত\u{9cd}র"),
            keywords: &[
                "জ\u{9cd}য\u{9be}মিতিক",
                "বর\u{9cd}গ\u{9be}ক\u{9be}র",
                "স\u{9be}দ\u{9be} ম\u{9be}ঝ\u{9be}রি বর\u{9cd}গক\u{9cd}ষেত\u{9cd}র",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("karrez etre gwenn"),
            keywords: &["gwenn", "karrez", "karrez etre gwenn"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("bijeli kvadrat"),
            keywords: &["bijeli kvadrat", "geometrija", "kvadrat"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("quadrat mitjà blanc"),
            keywords: &["blanc", "geometria", "mitjà", "quadrat"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᏁᎦ ᎠᏲᏟᎨ ᏅᎩ ᏧᏅᏏᏯ"),
            keywords: &["ᎤᏁᎦ ᎠᏲᏟᎨ ᏅᎩ ᏧᏅᏏᏯ", "ᏅᎩ ᏧᏅᏏᏯ", "ᏗᏎᏍᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("střední bílý čtverec"),
            keywords: &["geometrie", "střední bílý čtverec", "čtverec"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("sgwâr canolig gwyn"),
            keywords: &["geometrig", "sgwâr", "sgwâr canolig gwyn"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("mellemstort hvidt kvadrat"),
            keywords: &["geometrisk", "kvadrat", "mellemstort hvidt kvadrat"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("mittelgroßes weißes Quadrat"),
            keywords: &["Quadrat", "mittelgroßes weißes Quadrat", "weiß"],
        },
        #[cfg(feature = "de_CH")]
        crate::Annotation {
            lang: "de_CH",
            tts: Some("Mittelgrosses weisses Quadrat"),
            keywords: &["Mittelgrosses weisses Quadrat", "Quadrat", "weiss"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("μεσαίο λευκό τετράγωνο"),
            keywords: &["γεωμετρικό", "μεσαίο λευκό τετράγωνο", "τετράγωνο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("white medium square"),
            keywords: &["geometric", "square", "white medium square"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("cuadrado blanco mediano"),
            keywords: &["blanco", "cuadrado", "cuadrado blanco mediano", "geometría"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["cuadrado", "cuadrado blanco mediano", "geométrico"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("keskmine valge ruut"),
            keywords: &["geomeetria", "keskmine valge ruut", "ruut"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("karratu zuri ertaina"),
            keywords: &["geometriko", "karratu", "karratu zuri ertaina"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("مربع سفید متوسط"),
            keywords: &["شکل هندسی", "مربع", "مربع سفید متوسط"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("keskikokoinen valkoinen neliö"),
            keywords: &["keskikokoinen valkoinen neliö", "muoto", "neliö"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("katamtamang puting parisukat"),
            keywords: &[
                "hugis",
                "katamtaman",
                "katamtamang puting parisukat",
                "parisukat",
                "puti",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("hvítur fýrakantur"),
            keywords: &["fýrakantur", "hvítur fýrakantur", "mátingarfrøðiligur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("carré moyen blanc"),
            keywords: &["carré", "carré moyen blanc", "forme géométrique"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("carré blanc de taille moyenne"),
            keywords: &["carré blanc de taille moyenne", "forme", "géométrie"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("meánchearnóg bhán"),
            keywords: &[
                "cearnóg",
                "geoiméadrach",
                "meáncearnóg bán",
                "meánchearnóg bhán",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("ceàrnag mheadhanach gheal"),
            keywords: &["ceàrnag", "ceàrnag mheadhanach gheal", "geomatrach"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cadrado mediano branco"),
            keywords: &["branco", "cadrado", "mediano"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("સફ\u{ac7}દ મધ\u{acd}યમ ચોરસ"),
            keywords: &["ચોરસ", "ભૌમિતિક", "સફ\u{ac7}દ મધ\u{acd}યમ ચોરસ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("farin matsakaicin murabba’i"),
            keywords: &[
                "farin matsakaicin murabba’i",
                "ilimin halayen sura",
                "murabba’i",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("ריבוע לבן בינוני"),
            keywords: &["לבן", "צורה", "ריבוע", "ריבוע לבן בינוני"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("सफ\u{93c}\u{947}द मध\u{94d}यम वर\u{94d}ग"),
            keywords: &["ज\u{94d}यामिति", "सफ\u{93c}\u{947}द मध\u{94d}यम वर\u{94d}ग"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("srednji bijeli kvadrat"),
            keywords: &["geometrija", "kvadrat", "srednji bijeli kvadrat"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("közepes fehér négyzet"),
            keywords: &["geometria", "közepes fehér négyzet", "négyzet"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("սպիտակ միջին չափի քառակուսի"),
            keywords: &["երկրաչափական", "սպիտակ միջին չափի քառակուսի", "քառակուսի"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("persegi medium putih"),
            keywords: &["geometri", "persegi", "persegi medium putih"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("sukwia keetiti ọcha"),
            keywords: &["mgbakọ", "sukwia", "sukwia keetiti ọcha"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("hvítur meðalstór ferningur"),
            keywords: &["ferningur", "hvítur meðalstór ferningur", "rúmfræði"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("quadrato bianco medio"),
            keywords: &["geometria", "quadrato", "quadrato bianco medio"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("白四角大"),
            keywords: &["四角", "正方形", "白", "白四角大"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("kothak sedhengan putih"),
            keywords: &["geometrik", "kothak", "kothak sedhengan putih"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("საშუალო თეთრი კვადრატი"),
            keywords: &[
                "გეომეტრია",
                "გეომეტრიული",
                "კვადრატი",
                "საშუალო თეთრი კვადრატი",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("орташа ақ шаршы"),
            keywords: &["геометриялық", "орташа ақ шаршы", "шаршы"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("mellemstort hvidt kvadrat"),
            keywords: &["geometrisk", "kvadrat", "mellemstort hvidt kvadrat"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ប\u{17bd}នជ\u{17d2}រ\u{17bb}ងធ\u{17c6}ល\u{17d2}មមពណ\u{17cc}ស"),
            keywords: &[
                "ធ\u{17c6}ល\u{17d2}មម",
                "ប\u{17bd}នជ\u{17d2}រ\u{17bb}ង",
                "ប\u{17bd}នជ\u{17d2}រ\u{17bb}ងធ\u{17c6}ល\u{17d2}មមពណ\u{17cc}ស",
                "ស",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಬ\u{cbf}ಳ\u{cbf} ಬಣ\u{ccd}ಣದ ಮಧ\u{ccd}ಯಮ ಚ\u{ccc}ಕ"),
            keywords: &[
                "ಬ\u{cbf}ಳ\u{cbf} ಬಣ\u{ccd}ಣದ ಚ\u{ccc}ಕ",
                "ಬ\u{cbf}ಳ\u{cbf} ಬಣ\u{ccd}ಣದ ಮಧ\u{ccd}ಯಮ ಚ\u{ccc}ಕ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("중간 흰색 사각형"),
            keywords: &["무늬", "사각형", "중간 흰색 사각형"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("धवो मध\u{94d}यम चवकोन"),
            keywords: &["चवकोन", "जियोम\u{945}ट\u{94d}रीक", "धवो मध\u{94d}यम चवकोन"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("орточо ак чарчы"),
            keywords: &["геометрия", "орточо ак чарчы", "чарчы"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("mëttelgrousse wäisse Quadrat"),
            keywords: &["Quadrat", "geometresch", "mëttelgrousse wäisse Quadrat"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ສ\u{eb5}\u{ec8}ຫ\u{ebc}\u{ec8}ຽມປານກາງສ\u{eb5}ຂາວ"),
            keywords: &[
                "ສ\u{eb5}\u{ec8}ຫ\u{ebc}\u{ec8}ຽມ",
                "ສ\u{eb5}\u{ec8}ຫ\u{ebc}\u{ec8}ຽມປານກາງສ\u{eb5}ຂາວ",
                "ເລຂາຄະນ\u{eb4}ດ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("baltas vidutinis kvadratas"),
            keywords: &["baltas vidutinis kvadratas", "geometrija", "kvadratas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("vidējs balts kvadrāts"),
            keywords: &["kvadrāts", "vidējs balts kvadrāts", "ģeometrija"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tapawhā rite mā waenga"),
            keywords: &["tapawhā rite", "tapawhā rite mā waenga", "āhuahanga"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("среден бел квадрат"),
            keywords: &["геометрија", "квадрат", "среден бел квадрат"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഇടത\u{d4d}തരം വെള\u{d41}ത\u{d4d}ത ചത\u{d41}രം"),
            keywords: &[
                "ഇടത\u{d4d}തരം വെള\u{d41}ത\u{d4d}ത ചത\u{d41}രം",
                "കളം",
                "ചത\u{d41}രം",
                "ജിയോമെട\u{d4d}രിക\u{d4d}ക\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("цагаан дундаж дөрвөлжин"),
            keywords: &["геометр", "дөрвөлжин", "цагаан дундаж дөрвөлжин"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("पा\u{902}ढरा मध\u{94d}\u{200d}यम आकाराचा चौरस"),
            keywords: &[
                "चौरस",
                "पा\u{902}ढरा मध\u{94d}\u{200d}यम आकाराचा चौरस",
                "पा\u{902}ढरा लहान चौरस",
                "भ\u{942}मितीय",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("persegi sederhana putih"),
            keywords: &["geometri", "persegi", "persegi sederhana putih"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("kwadrat medju abjad"),
            keywords: &["kwadrat medju abjad", "kwadru", "ġeometrika"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "အဖြ\u{1030}ရောင\u{103a} လေးထောင\u{1037}\u{103a}က\u{103d}က\u{103a} အလတ\u{103a}စား",
            ),
            keywords: &[
                "ဂျ\u{102e}ဩမေတြ\u{102e}",
                "လေးထောင\u{1037}\u{103a}က\u{103d}က\u{103a}",
                "အဖြ\u{1030}ရောင\u{103a} လေးထောင\u{1037}\u{103a}က\u{103d}က\u{103a} အလတ\u{103a}စား",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("mellomstor hvit firkant"),
            keywords: &[
                "firkant",
                "geometrisk",
                "kvadrat",
                "mellomstor hvit firkant",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("स\u{947}तो मध\u{94d}यम वर\u{94d}ग"),
            keywords: &[
                "ज\u{94d}यामितीय",
                "वर\u{94d}ग",
                "स\u{947}तो मध\u{94d}यम वर\u{94d}ग",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("middelgroot wit vierkant"),
            keywords: &["middelgroot", "vierkant", "wit"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଧଳ\u{b3e} ମଧ\u{b4d}ୟମ ବର\u{b4d}ଗକ\u{b4d}ଷେତ\u{b4d}ର"),
            keywords: &[
                "ଜ\u{b4d}ୟ\u{b3e}ମ\u{b3f}ତ\u{b3f}କ",
                "ଧଳ\u{b3e} ମଧ\u{b4d}ୟମ ବର\u{b4d}ଗକ\u{b4d}ଷେତ\u{b4d}ର",
                "ବର\u{b4d}ଗକ\u{b4d}ଷେତ\u{b4d}ର",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਦਰਮਿਆਨਾ ਚਿ\u{a71}ਟਾ ਵਰਗ"),
            keywords: &["ਜਯਾਮਿਤੀ", "ਦਰਮਿਆਨਾ ਚਿ\u{a71}ਟਾ ਵਰਗ", "ਵਰਗ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("چ\u{650}یٹا درمیانہ مربع"),
            keywords: &["جیومیٹری دے متعلق", "مربع", "چ\u{650}یٹا درمیانہ مربع"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Waít Mídiọ\u{301}m Saíz Skwea"),
            keywords: &[
                "Jiọ\u{301}mẹ\u{301}tri",
                "Skwea",
                "Waít Mídiọ\u{301}m Saíz Skwea",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("średni biały kwadrat"),
            keywords: &["biały", "duży", "figura geometryczna", "kwadrat", "średni"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("سپينه ميانه مربع"),
            keywords: &["جيوميتريکي", "سپينه ميانه مربع", "مربع"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("quadrado branco médio"),
            keywords: &["geométrico", "quadrado", "quadrado branco médio"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["geométrico", "quadrado", "quadrado branco médio"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("pătrat alb mediu"),
            keywords: &["alb", "geometric", "pătrat", "pătrat alb mediu"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-037"),
            keywords: &["E10-037"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("белый квадрат"),
            keywords: &["белый", "геометрия", "квадрат", "фигура"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("kare y’umweru iringaniye"),
            keywords: &["ishusho", "kare", "kare y’umweru iringaniye"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("سفيد وچولو چورس"),
            keywords: &["جيوميٽرڪ", "سفيد وچولو چورس", "چورس"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some(
                "ස\u{dd4}ද\u{dd4} මධ\u{dca}\u{200d}යම ප\u{dca}\u{200d}රම\u{dcf}ණයේ කොට\u{dd4}ව",
            ),
            keywords: &[
                "ජ\u{dca}\u{200d}ය\u{dcf}ම\u{dd2}ත\u{dd2}ක",
                "ස\u{dd4}ද\u{dd4} මධ\u{dca}\u{200d}යම ප\u{dca}\u{200d}රම\u{dcf}ණයේ කොට\u{dd4}ව",
                "හතරැස\u{dca}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("stredný biely štvorec"),
            keywords: &["geometria", "stredný biely štvorec", "štvorec"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("srednji bel kvadrat"),
            keywords: &["geometrično", "kvadrat", "srednji bel kvadrat"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("afar gees dhexdhexaad oo cad"),
            keywords: &["afar gees", "afar gees dhexdhexaad oo cad", "joometriyeed"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("katror mesatar i bardhë"),
            keywords: &["gjeometrik", "katror", "katror mesatar i bardhë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("бели квадрат средње величине"),
            keywords: &["бели квадрат средње величине", "гeoмeтриja", "квaдрaт"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("бијели квадрат средње величине"),
            keywords: &["бијели квадрат средње величине"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("beli kvadrat srednje veličine"),
            keywords: &["beli kvadrat srednje veličine", "geometrija", "kvadrat"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("bijeli kvadrat srednje veličine"),
            keywords: &["bijeli kvadrat srednje veličine"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("mellanstor vit ruta"),
            keywords: &["geometrisk", "mellanstor vit ruta", "ruta", "vit"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mraba wa wastani mweupe"),
            keywords: &["jiometri", "mraba", "mraba wa wastani mweupe"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("நடுத\u{bcd}தர வெள\u{bcd}ளை சதுரம\u{bcd}"),
            keywords: &[
                "நடுத\u{bcd}தர வெள\u{bcd}ளை சதுரம\u{bcd}",
                "ம\u{bc0}டியம\u{bcd} ஸ\u{bcd}கொயர\u{bcd}",
                "வெள\u{bcd}ளை சதுரம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("మధ\u{c4d}యస\u{c4d}థ త\u{c46}లుపు రంగు చతురస\u{c4d}రం"),
            keywords: &[
                "చతురస\u{c4d}రం",
                "త\u{c46}లుపు రంగు",
                "మధ\u{c4d}యస\u{c4d}థ త\u{c46}లుపు రంగు చతురస\u{c4d}రం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("чоркунҷаи миёнаи сафед"),
            keywords: &["геометрӣ", "чоркунҷа", "чоркунҷаи миёнаи сафед"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ส\u{e35}\u{e48}เหล\u{e35}\u{e48}ยมขนาดกลางส\u{e35}ขาว"),
            keywords: &[
                "ส\u{e35}\u{e48}เหล\u{e35}\u{e48}ยม",
                "ส\u{e35}\u{e48}เหล\u{e35}\u{e48}ยมขนาดกลางส\u{e35}ขาว",
                "เรขาคณ\u{e34}ต",
            ],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ጻዕዳ ማእከላይ ትርብዒት"),
            keywords: &["ትርብዒት", "ጂኦሜትሪክ", "ጻዕዳ ማእከላይ ትርብዒት"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ak ortaça inedördül"),
            keywords: &["ak ortaça inedördül", "geometrik", "inedördül"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tapafā tauloto mo hinehina"),
            keywords: &["hinehina", "tapafā", "tapafā tauloto mo hinehina"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("orta boy beyaz kare"),
            keywords: &["geometri", "kare", "orta boy beyaz kare"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئاق ئارا كىۋادرات"),
            keywords: &["ئاق ئارا كىۋادرات", "كىۋادرات", "گېئومېتىرىيە"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("середній білий квадрат"),
            keywords: &["геометричний", "квадрат", "середній білий квадрат"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("سفید میڈیم چوکور"),
            keywords: &[
                "جیومیٹری",
                "سفید",
                "سفید میڈیم چوکور",
                "میڈ\u{650}م",
                "چوکور",
            ],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("o‘rtacha oq kvadrat"),
            keywords: &["geometrik", "kvadrat", "o‘rtacha oq kvadrat"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("hình vuông trung bình màu trắng"),
            keywords: &["hình học", "hình vuông", "hình vuông trung bình màu trắng"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("kaare bu yam te weex"),
            keywords: &["bu-geometri", "kaare", "kaare bu yam te weex"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("iskwere esiphakathi esimhlophe"),
            keywords: &["ijiyometriki", "iskwere", "iskwere esiphakathi esimhlophe"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("ilà onígun mé\u{329}rin aláàárín funfun"),
            keywords: &[
                "ilà onigun mé\u{329}rin",
                "ilà onígun mé\u{329}rin aláàárín funfun",
                "jiomé\u{329}tíríkì",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("中白色正方形"),
            keywords: &["中白色正方形", "幾何", "正方形"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("中白色正方形"),
            keywords: &["中白色正方形", "几何", "正方形"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("白色中方块"),
            keywords: &["中等", "正方形", "白色", "白色中方块"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("白色中方塊"),
            keywords: &["方形", "白色中方塊"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("白色中正方形"),
            keywords: &["中白色正方形", "正方形", "白色中正方形"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("isikwele esimhlophe esimaphakathi"),
            keywords: &[
                "isikwele esimhlophe esimaphakathi",
                "iskwele",
                "jiyometrikhi",
            ],
        },
    ],
};
#[doc = "◾"]
pub const BLACK_MEDIUM_SMALL_SQUARE: crate::Emoji = crate::Emoji {
    glyph: "◾",
    codepoint: "25FE",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "black medium-small square",
    group: "Symbols",
    subgroup: "geometric",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("swart mediumklein vierkant"),
            keywords: &[
                "geometries",
                "swart",
                "swart mediumklein vierkant",
                "vierkant",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ጥቁር መካከለኛ-ትንሽ ካሬ"),
            keywords: &["ካሬ", "ጂኦሜትሪያዊ", "ጥቁር መካከለኛ-ትንሽ ካሬ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("مربع صغير متوسط أسود"),
            keywords: &["مربع", "مربع صغير متوسط أسود", "هندسي"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ক’ল\u{9be} মধ\u{9cd}যমীয\u{9bc}\u{9be}-সৰ\u{9c1} বৰ\u{9cd}গ"),
            keywords: &[
                "ক’ল\u{9be} মধ\u{9cd}যমীয\u{9bc}\u{9be}-সৰ\u{9c1} বৰ\u{9cd}গ",
                "জ\u{9cd}য\u{9be}মিতিক",
                "বৰ\u{9cd}গ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("qara orta kiçiklikdə kvadrat"),
            keywords: &["həndəsi", "kvadrat", "qara orta kiçiklikdə kvadrat"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("невялікі чорны квадрат"),
            keywords: &["аб’ект", "геаметрычны", "квадрат", "невялікі чорны квадрат"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Черен средномалък квадрат"),
            keywords: &["Черен средномалък квадрат", "геометричен", "квадрат"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ক\u{9be}লো ম\u{9be}ঝ\u{9be}রি ছোট বর\u{9cd}গক\u{9cd}ষেত\u{9cd}র"),
            keywords: &[
                "ক\u{9be}লো ম\u{9be}ঝ\u{9be}রি ছোট বর\u{9cd}গক\u{9cd}ষেত\u{9cd}র",
                "জ\u{9cd}য\u{9be}মিতিক",
                "বর\u{9cd}গ\u{9be}ক\u{9be}র",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("crni srednje mali kvadrat"),
            keywords: &["crni srednje mali kvadrat", "geometrija", "kvadrat"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("quadrat negre petit-mitjà"),
            keywords: &["geometria", "negre", "petit-mitjà", "quadrat"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎬᎿᎨ ᎠᏲᏟᎨ-ᎤᏍᏗ ᎾᎩ ᏧᏅᏏᏯ"),
            keywords: &["ᎬᎿᎨ ᎠᏲᏟᎨ-ᎤᏍᏗ ᎾᎩ ᏧᏅᏏᏯ", "ᏅᎩ ᏧᏅᏏᏯ", "ᏗᏎᏍᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("větší černý čtvereček"),
            keywords: &["geometrie", "větší černý čtvereček", "čtverec"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("sgwâr canolig-bach du"),
            keywords: &["geometrig", "sgwâr", "sgwâr canolig-bach du"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("halvlille sort kvadrat"),
            keywords: &["geometrisk", "halvlille sort kvadrat", "kvadrat"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("mittelkleines schwarzes Quadrat"),
            keywords: &["Quadrat", "mittelkleines schwarzes Quadrat", "schwarz"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("μικρομεσαίο μαύρο τετράγωνο"),
            keywords: &["γεωμετρικό", "μικρομεσαίο μαύρο τετράγωνο", "τετράγωνο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("black medium-small square"),
            keywords: &["black medium-small square", "geometric", "square"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("cuadrado negro mediano-pequeño"),
            keywords: &[
                "cuadrado",
                "cuadrado negro mediano-pequeño",
                "geometría",
                "negro",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &[
                "cuadrado",
                "cuadrado negro mediano-pequeño",
                "mediano",
                "negro",
                "pequeño",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("väiksem must ruut"),
            keywords: &["geomeetria", "ruut", "väiksem must ruut"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("karratu beltz ertaina/txikia"),
            keywords: &["geometriko", "karratu", "karratu beltz ertaina/txikia"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("مربع مشکی نسبتا\u{64b} کوچک"),
            keywords: &["شکل هندسی", "مربع", "مربع مشکی نسبتا\u{64b} کوچک"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("pienehkö musta neliö"),
            keywords: &["muoto", "neliö", "pienehkö musta neliö"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("medyo maliit na itim na parisukat"),
            keywords: &[
                "hugis",
                "itim",
                "maliit",
                "medyo",
                "medyo maliit na itim na parisukat",
                "parisukat",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("svartur miðalstórur fýrakantur"),
            keywords: &[
                "fýrakantur",
                "mátingarfrøðiligur",
                "svartur miðalstórur fýrakantur",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("carré petit moyen noir"),
            keywords: &["carré", "carré petit moyen noir", "forme", "géométrie"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("carré noir de taille intermédiaire"),
            keywords: &["carré noir de taille intermédiaire", "forme", "géométrie"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("meánchearnóg bheag dhubh"),
            keywords: &[
                "cearnóg",
                "cearnóg dubh meán-bheag",
                "geoiméadrach",
                "meánchearnóg bheag dhubh",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("ceàrnag mheadhanach bheag dhubh"),
            keywords: &["ceàrnag", "ceàrnag mheadhanach bheag dhubh", "geomatrach"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cadrado pequeno-mediano negro"),
            keywords: &[
                "cadrado",
                "cadrado pequeno-mediano negro",
                "mediano",
                "negro",
                "pequeno",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("કાળો મધ\u{acd}યમ-નાનો ચોરસ"),
            keywords: &["કાળો મધ\u{acd}યમ-નાનો ચોરસ", "ચોરસ", "ભૌમિતિક"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("baƙin matsakaicin-ƙaramin murabba’i"),
            keywords: &[
                "baƙin matsakaicin-ƙaramin murabba’i",
                "ilimin halayen sura",
                "murabba’i",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("ריבוע בינוני-קטן שחור"),
            keywords: &["צורה", "ריבוע", "ריבוע בינוני-קטן שחור", "שחור"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("काला मध\u{94d}यम-छोटा वर\u{94d}ग"),
            keywords: &["काला मध\u{94d}यम-छोटा वर\u{94d}ग", "ज\u{94d}यामिति"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("srednje mali crni kvadrat"),
            keywords: &["geometrija", "kvadrat", "srednje mali crni kvadrat"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("kis-közepes fekete négyzet"),
            keywords: &["geometria", "kis-közepes fekete négyzet", "négyzet"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("սև միջին-փոքր քառակուսի"),
            keywords: &["երկրաչափական", "սև միջին-փոքր քառակուսի", "քառակուսի"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("persegi kecil medium hitam"),
            keywords: &["geometri", "persegi", "persegi kecil medium hitam"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("sukwia obere-etiti ojii"),
            keywords: &["mgbakọ", "sukwia", "sukwia obere-etiti ojii"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("svartur meðalsmár ferningur"),
            keywords: &["ferningur", "rúmfræði", "svartur meðalsmár ferningur"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("quadrato nero medio-piccolo"),
            keywords: &["geometria", "quadrato", "quadrato nero medio-piccolo"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("黒四角中"),
            keywords: &["四角", "正方形", "黒", "黒四角中"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("kothak cilik-sedhengan ireng"),
            keywords: &["geometrik", "kothak", "kothak cilik-sedhengan ireng"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("საშუალო-პატარა შავი კვადრატი"),
            keywords: &[
                "გეომეტრია",
                "გეომეტრიული",
                "კვადრატი",
                "საშუალო-პატარა შავი კვადრატი",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("орташа-кіші қара шаршы"),
            keywords: &["геометриялық", "орташа-кіші қара шаршы", "шаршы"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("halvlille sort kvadrat"),
            keywords: &["geometrisk", "halvlille sort kvadrat", "kvadrat"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ប\u{17bd}នជ\u{17d2}រ\u{17bb}ងត\u{17bc}ចល\u{17d2}មមពណ\u{17cc}ខ\u{17d2}មៅ"),
            keywords: &[
                "ខ\u{17d2}មៅ",
                "ត\u{17bc}ចល\u{17d2}មម",
                "ប\u{17bd}នជ\u{17d2}រ\u{17bb}ង",
                "ប\u{17bd}នជ\u{17d2}រ\u{17bb}ងត\u{17bc}ចល\u{17d2}មមពណ\u{17cc}ខ\u{17d2}មៅ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕಪ\u{ccd}ಪು ಬಣ\u{ccd}ಣದ ಮಧ\u{ccd}ಯಮ ಸಣ\u{ccd}ಣ ಚ\u{ccc}ಕ"),
            keywords: &[
                "ಕಪ\u{ccd}ಪು ಬಣ\u{ccd}ಣದ ಮಧ\u{ccd}ಯಮ ಸಣ\u{ccd}ಣ ಚ\u{ccc}ಕ",
                "ಕಪ\u{ccd}ಪು ಬಣ\u{ccd}ಣದ ಸಣ\u{ccd}ಣ ಚ\u{ccc}ಕ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("중각 작은 검은색 사각형"),
            keywords: &["무늬", "사각형", "중각 작은 검은색 사각형"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("काळो मध\u{94d}यम-ल\u{94d}हान चवकोन"),
            keywords: &[
                "काळो मध\u{94d}यम-ल\u{94d}हान चवकोन",
                "चवकोन",
                "जियोम\u{945}ट\u{94d}रीक",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("кичирээк кара чарчы"),
            keywords: &["геометрия", "кичирээк кара чарчы", "чарчы"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("schwaarze mëttelklenge Quadrat"),
            keywords: &["Quadrat", "geometresch", "schwaarze mëttelklenge Quadrat"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ສ\u{eb5}\u{ec8}ຫ\u{ebc}\u{ec8}ຽມນ\u{ec9}ອຍ-ປານກາງສ\u{eb5}ດຳ"),
            keywords: &[
                "ສ\u{eb5}\u{ec8}ຫ\u{ebc}\u{ec8}ຽມ",
                "ສ\u{eb5}\u{ec8}ຫ\u{ebc}\u{ec8}ຽມນ\u{ec9}ອຍ-ປານກາງສ\u{eb5}ດຳ",
                "ເລຂາຄະນ\u{eb4}ດ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("juodas vidutiniškai mažas kvadratas"),
            keywords: &[
                "geometrija",
                "juodas vidutiniškai mažas kvadratas",
                "kvadratas",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("vidēji mazs melns kvadrāts"),
            keywords: &["kvadrāts", "vidēji mazs melns kvadrāts", "ģeometrija"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tapawhā rite pango waenga-iti"),
            keywords: &["tapawhā rite", "tapawhā rite pango waenga-iti", "āhuahanga"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("црн квадрат со средна големина"),
            keywords: &["геометрија", "квадрат", "црн квадрат со средна големина"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ചെറിയ കറ\u{d41}ത\u{d4d}ത ചത\u{d41}രം"),
            keywords: &[
                "കളം",
                "ചത\u{d41}രം",
                "ചെറിയ കറ\u{d41}ത\u{d4d}ത ചത\u{d41}രം",
                "ജിയോമെട\u{d4d}രിക\u{d4d}ക\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("хар жижгэвтэр дөрвөлжин"),
            keywords: &["геометр", "дөрвөлжин", "хар жижгэвтэр дөрвөлжин"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("काळा मध\u{94d}\u{200d}यम-लहान आकाराचा चौरस"),
            keywords: &[
                "काळा मध\u{94d}यम आकाराचा चौरस",
                "काळा मध\u{94d}\u{200d}यम-लहान आकाराचा चौरस",
                "चौरस",
                "भ\u{942}मितीय",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("persegi sederhana kecil hitam"),
            keywords: &["geometri", "persegi", "persegi sederhana kecil hitam"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("kwadrat medju żgħar iswed"),
            keywords: &["kwadrat medju żgħar iswed", "kwadru", "ġeometrika"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "အနက\u{103a}ရောင\u{103a} လေးထောင\u{1037}\u{103a}က\u{103d}က\u{103a} အလတ\u{103a}စားအသေး",
            ),
            keywords: &[
                "ဂျ\u{102e}ဩမေတြ\u{102e}ဆ\u{102d}\u{102f}င\u{103a}ရာ",
                "အနက\u{103a}ရောင\u{103a} လေးထောင\u{1037}\u{103a}က\u{103d}က\u{103a} အလတ\u{103a}စားအသေး",
                "အနက\u{103a}ရောင\u{103a} အလတ\u{103a}စားအသေး လေးထောင\u{1037}\u{103a}က\u{103d}က\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("liten/mellomstor svart firkant"),
            keywords: &[
                "firkant",
                "geometrisk",
                "kvadrat",
                "liten/mellomstor svart firkant",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("कालो मध\u{94d}यम-सानो वर\u{94d}ग"),
            keywords: &[
                "कालो मध\u{94d}यम-सानो वर\u{94d}ग",
                "ज\u{94d}यामितीय",
                "वर\u{94d}ग",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("klein tot middelgroot zwart vierkant"),
            keywords: &[
                "geometrisch",
                "klein tot middelgroot zwart vierkant",
                "vierkant",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("liten/mellomstor svart firkant"),
            keywords: &[
                "firkant",
                "geometrisk",
                "kvadrat",
                "liten/mellomstor svart firkant",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("କଳ\u{b3e} ମଧ\u{b4d}ୟମ-ଛୋଟ ବର\u{b4d}ଗକ\u{b4d}ଷେତ\u{b4d}ର"),
            keywords: &[
                "କଳ\u{b3e} ମଧ\u{b4d}ୟମ-ଛୋଟ ବର\u{b4d}ଗକ\u{b4d}ଷେତ\u{b4d}ର",
                "ଜ\u{b4d}ୟ\u{b3e}ମ\u{b3f}ତ\u{b3f}କ",
                "ବର\u{b4d}ଗକ\u{b4d}ଷେତ\u{b4d}ର",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਦਰਮਿਆਨਾ-ਛ\u{a4b}ਟਾ ਕਾਲਾ ਵਰਗ"),
            keywords: &["ਜਯਾਮਿਤੀ", "ਦਰਮਿਆਨਾ-ਛ\u{a4b}ਟਾ ਕਾਲਾ ਵਰਗ", "ਵਰਗ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("کالا درمیانہ ـ نیکا مربع"),
            keywords: &["جیومیٹری دے متعلق", "مربع", "کالا درمیانہ ـ نیکا مربع"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Blák Mídiọ\u{301}m-Smọ\u{301}l Skwea"),
            keywords: &[
                "Blák Mídiọ\u{301}m-Smọ\u{301}l Skwea",
                "Jiọ\u{301}mẹ\u{301}tri",
                "Skwea",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("mały/średni czarny kwadrat"),
            keywords: &[
                "czarny",
                "figura geometryczna",
                "kwadrat",
                "mały",
                "mały/średni czarny kwadrat",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("توره ميانه کوچنۍ مربع"),
            keywords: &["توره ميانه کوچنۍ مربع", "جيوميتريکي", "مربع"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("quadrado preto médio menor"),
            keywords: &["geométrico", "quadrado", "quadrado preto médio menor"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("quadrado preto pequeno/médio"),
            keywords: &["geométrico", "quadrado", "quadrado preto pequeno/médio"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("pătrat negru mediu spre mic"),
            keywords: &[
                "geometric",
                "negru",
                "pătrat",
                "pătrat negru mediu spre mic",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-040"),
            keywords: &["E10-040"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("небольшой черный квадрат"),
            keywords: &[
                "геометрия",
                "квадрат",
                "небольшой квадрат",
                "небольшой черный квадрат",
                "фигура",
                "черный",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("kare ntoya iringaniye y’umukara"),
            keywords: &["ishusho", "kare", "kare ntoya iringaniye y’umukara"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڪارو وچولو-ننڍو چورس"),
            keywords: &["جيوميٽرڪ", "چورس", "ڪارو وچولو-ننڍو چورس"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some(
                "කළ\u{dd4} මධ\u{dca}\u{200d}යම ප\u{dca}\u{200d}රම\u{dcf}ණයේ-ක\u{dd4}ඩ\u{dcf} කොට\u{dd4}ව",
            ),
            keywords: &[
                "කළ\u{dd4} මධ\u{dca}\u{200d}යම ප\u{dca}\u{200d}රම\u{dcf}ණයේ-ක\u{dd4}ඩ\u{dcf} කොට\u{dd4}ව",
                "ජ\u{dca}\u{200d}ය\u{dcf}ම\u{dd2}ත\u{dd2}ක",
                "හතරැස\u{dca}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("stredne malý čierny štvorec"),
            keywords: &["geometria", "stredne malý čierny štvorec", "štvorec"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("srednje majhen črn kvadrat"),
            keywords: &["geometrično", "kvadrat", "srednje majhen črn kvadrat"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("afar gees dhexdhexaad yar oo madow"),
            keywords: &[
                "afar gees",
                "afar gees dhexdhexaad oo madow",
                "afar gees dhexdhexaad yar oo madow",
                "joometriyeed",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("katror mesatarisht i vogël i zi"),
            keywords: &["gjeometri", "katror", "katror mesatarisht i vogël i zi"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("средњемали црни квадрат"),
            keywords: &["гeoмeтриja", "квaдрaт", "средњемали црни квадрат"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("srednjemali crni kvadrat"),
            keywords: &["geometrija", "kvadrat", "srednjemali crni kvadrat"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("mellanliten svart ruta"),
            keywords: &[
                "geometrisk",
                "medelstor svart ruta",
                "mellanliten svart ruta",
                "ruta",
                "svart",
            ],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mraba wastani mdogo mweusi"),
            keywords: &["jiometri", "mraba", "mraba wastani mdogo mweusi"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("நடுத\u{bcd}தரம\u{bcd}-சிறிய கருப\u{bcd}பு சதுரம\u{bcd}"),
            keywords: &[
                "நடுத\u{bcd}தரம\u{bcd}-சிறிய கருப\u{bcd}பு சதுரம\u{bcd}",
                "பிள\u{bbe}க\u{bcd} ம\u{bc0}டியம\u{bcd} ஸ\u{bcd}கொயர\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("మధ\u{c4d}యస\u{c4d}థ చ\u{c3f}న\u{c4d}న నలుపు రంగు చతురస\u{c4d}రం"),
            keywords: &[
                "చతురస\u{c4d}రం",
                "నలుపు రంగు",
                "మధ\u{c4d}యస\u{c4d}థ చ\u{c3f}న\u{c4d}న నలుపు రంగు చతురస\u{c4d}రం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("чоркунҷаи хурди миёнаи сиёҳ"),
            keywords: &["геометрӣ", "чоркунҷа", "чоркунҷаи хурди миёнаи сиёҳ"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ส\u{e35}\u{e48}เหล\u{e35}\u{e48}ยมเล\u{e47}กปานกลางส\u{e35}ดำ"),
            keywords: &[
                "ส\u{e35}\u{e48}เหล\u{e35}\u{e48}ยม",
                "ส\u{e35}\u{e48}เหล\u{e35}\u{e48}ยมเล\u{e47}กปานกลางส\u{e35}ดำ",
                "เรขาคณ\u{e34}ต",
            ],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ጸሊም ማእከላይ-ንኢሽተይ ትርብዒት"),
            keywords: &["ትርብዒት", "ጂኦሜትሪክ", "ጸሊም ማእከላይ-ንኢሽተይ ትርብዒት"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("gara orta-kiçi inedördül"),
            keywords: &["gara orta-kiçi inedördül", "geometrik", "inedördül"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tapafā siʻi mo ʻuliʻuli"),
            keywords: &["tapafā", "tapafā siʻi mo ʻuliʻuli", "ʻuliʻuli"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("küçük-orta siyah kare"),
            keywords: &["geometri", "kare", "küçük-orta siyah kare"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("قارا كىچىكرەك كىۋادرات"),
            keywords: &["قارا كىچىكرەك كىۋادرات", "كىۋادرات", "گېئومېتىرىيە"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("менший за середній чорний квадрат"),
            keywords: &[
                "геометричний",
                "квадрат",
                "менший за середній чорний квадрат",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("کالا میڈیم چھوٹا چوکور"),
            keywords: &["جیومیٹری", "میڈیم", "چوکور", "چھوٹا", "کالا"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("kichikroq qora kvadrat"),
            keywords: &["geometrik", "kichikroq qora kvadrat", "kvadrat"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("hình vuông nhỏ vừa màu đen"),
            keywords: &["hình học", "hình vuông", "hình vuông nhỏ vừa màu đen"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("kaare yam-ndaw te ñuul"),
            keywords: &["bu-geometri", "kaare", "kaare yam-ndaw te ñuul"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("iskrwere esiphakathi-buncinane esimnyama"),
            keywords: &[
                "ijiyometriki",
                "iskrwere esiphakathi-buncinane esimnyama",
                "iskwere",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("onigunmẹrin idaji-kekere dudu"),
            keywords: &[
                "ilà onigun mé\u{329}rin",
                "jiomé\u{329}tíríkì",
                "onigunmẹrin idaji-kekere dudu",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("中細黑色正方形"),
            keywords: &["中細黑色正方形", "幾何", "正方形"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("中细黑色正方形"),
            keywords: &["中细黑色正方形", "几何", "正方形"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("黑色中小方块"),
            keywords: &["中小", "正方形", "黑色", "黑色中小方块"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("黑色中小型方塊"),
            keywords: &["方形", "黑色中小型方塊"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("黑色中小正方形"),
            keywords: &["中小黑色正方形", "正方形", "黑色中小正方形"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("iskwele esimnyama esimaphakathi esincane"),
            keywords: &[
                "iskwele",
                "iskwele esimnyama esimaphakathi esincane",
                "jiyometrikhi",
            ],
        },
    ],
};
#[doc = "◽"]
pub const WHITE_MEDIUM_SMALL_SQUARE: crate::Emoji = crate::Emoji {
    glyph: "◽",
    codepoint: "25FD",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "white medium-small square",
    group: "Symbols",
    subgroup: "geometric",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("wit mediumklein vierkant"),
            keywords: &["geometries", "vierkant", "wit", "wit mediumklein vierkant"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ነጭ መካከለኛ- ትንሽ ካሬ"),
            keywords: &["ነጭ መካከለኛ- ትንሽ ካሬ", "ካሬ", "ጂኦሜትሪያዊ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("مربع صغير متوسط أبيض"),
            keywords: &["مربع", "مربع صغير متوسط أبيض", "هندسي"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("বগ\u{9be} মধ\u{9cd}যমীয\u{9bc}\u{9be}-সৰ\u{9c1} বৰ\u{9cd}গ"),
            keywords: &[
                "জ\u{9cd}য\u{9be}মিতিক",
                "বগ\u{9be} মধ\u{9cd}যমীয\u{9bc}\u{9be}-সৰ\u{9c1} বৰ\u{9cd}গ",
                "বৰ\u{9cd}গ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("ağ orta kiçiklikdə kvadrat"),
            keywords: &["ağ orta kiçiklikdə kvadrat", "həndəsi", "kvadrat"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("невялікі белы квадрат"),
            keywords: &["аб’ект", "геаметрычны", "квадрат", "невялікі белы квадрат"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Бял средномалък квадрат"),
            keywords: &["Бял средномалък квадрат", "геометричен", "квадрат"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("স\u{9be}দ\u{9be} ম\u{9be}ঝ\u{9be}রি ছোট বর\u{9cd}গক\u{9cd}ষেত\u{9cd}র"),
            keywords: &[
                "জ\u{9cd}য\u{9be}মিতিক",
                "বর\u{9cd}গ\u{9be}ক\u{9be}র",
                "স\u{9be}দ\u{9be} ম\u{9be}ঝ\u{9be}রি ছোট বর\u{9cd}গক\u{9cd}ষেত\u{9cd}র",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("bijeli srednje mali kvadrat"),
            keywords: &["bijeli srednje mali kvadrat", "geometrija", "kvadrat"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("quadrat blanc petit-mitjà"),
            keywords: &["blanc", "geometria", "petit-mitjà", "quadrat"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᏁᎦ ᎠᏲᏟᎨ-ᎤᏍᏗ ᏅᎩ ᏧᏅᏏᏯ"),
            keywords: &["ᎤᏁᎦ ᎠᏲᏟᎨ-ᎤᏍᏗ ᏅᎩ ᏧᏅᏏᏯ", "ᏅᎩ ᏧᏅᏏᏯ", "ᏗᏎᏍᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("větší bílý čtvereček"),
            keywords: &["geometrie", "větší bílý čtvereček", "čtverec"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("sgwâr canolig-bach gwyn"),
            keywords: &["geometrig", "sgwâr", "sgwâr canolig-bach gwyn"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("halvlille hvidt kvadrat"),
            keywords: &["geometrisk", "halvlille hvidt kvadrat", "kvadrat"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("mittelkleines weißes Quadrat"),
            keywords: &["Quadrat", "mittelkleines weißes Quadrat", "weiß"],
        },
        #[cfg(feature = "de_CH")]
        crate::Annotation {
            lang: "de_CH",
            tts: Some("Mittelkleines weisses Quadrat"),
            keywords: &["Mittelkleines weisses Quadrat", "Quadrat", "weiss"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("μικρομεσαίο λευκό τετράγωνο"),
            keywords: &["γεωμετρικό", "μικρομεσαίο λευκό τετράγωνο", "τετράγωνο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("white medium-small square"),
            keywords: &["geometric", "square", "white medium-small square"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("cuadrado blanco mediano-pequeño"),
            keywords: &[
                "blanco",
                "cuadrado",
                "cuadrado blanco mediano-pequeño",
                "geometría",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &[
                "blanco",
                "cuadrado",
                "cuadrado blanco mediano-pequeño",
                "mediano",
                "pequeño",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("väiksem valge ruut"),
            keywords: &["geomeetria", "ruut", "väiksem valge ruut"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("karratu zuri ertaina/txikia"),
            keywords: &["geometriko", "karratu", "karratu zuri ertaina/txikia"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("مربع سفید نسبتا\u{64b} کوچک"),
            keywords: &["شکل هندسی", "مربع", "مربع سفید نسبتا\u{64b} کوچک"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("pienehkö valkoinen neliö"),
            keywords: &["muoto", "neliö", "pienehkö valkoinen neliö"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("medyo maliit na puting parisukat"),
            keywords: &[
                "hugis",
                "maliit",
                "medyo maliit na puting parisukat",
                "parisukat",
                "puti",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("hvítur miðalstórur fýrakantur"),
            keywords: &[
                "fýrakantur",
                "hvítur miðalstórur fýrakantur",
                "mátingarfrøðiligur",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("carré petit moyen blanc"),
            keywords: &["carré", "carré petit moyen blanc", "forme", "géométrie"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("carré blanc de taille intermédiaire"),
            keywords: &["carré blanc de taille intermédiaire", "forme", "géométrie"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("meánchearnóg bheag bhán"),
            keywords: &[
                "cearnóg",
                "cearnóg bán meán-bheag",
                "geoiméadrach",
                "meánchearnóg bheag bhán",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("ceàrnag mheadhanach bheag gheal"),
            keywords: &["ceàrnag", "ceàrnag mheadhanach bheag gheal", "geomatrach"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cadrado pequeno-mediano branco"),
            keywords: &[
                "branco",
                "cadrado",
                "cadrado pequeno-mediano branco",
                "mediano",
                "pequeno",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("સફ\u{ac7}દ મધ\u{acd}યમ-નાનો ચોરસ"),
            keywords: &["ચોરસ", "ભૌમિતિક", "સફ\u{ac7}દ મધ\u{acd}યમ-નાનો ચોરસ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("farin matsakaicin-ƙaramin murabba’i"),
            keywords: &[
                "farin matsakaicin-ƙaramin murabba’i",
                "ilimin halayen sura",
                "murabba’i",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("ריבוע בינוני-קטן לבן"),
            keywords: &["לבן", "צורה", "ריבוע", "ריבוע בינוני-קטן לבן"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("सफ\u{93c}\u{947}द मध\u{94d}यम-छोटा वर\u{94d}ग"),
            keywords: &[
                "ज\u{94d}यामिति",
                "सफ\u{93c}\u{947}द मध\u{94d}यम-छोटा वर\u{94d}ग",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("srednje mali bijeli kvadrat"),
            keywords: &["geometrija", "kvadrat", "srednje mali bijeli kvadrat"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("kis-közepes fehér négyzet"),
            keywords: &["geometria", "kis-közepes fehér négyzet", "négyzet"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("սպիտակ միջին-փոքր քառակուսի"),
            keywords: &["երկրաչափական", "սպիտակ միջին-փոքր քառակուսի", "քառակուսի"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("persegi kecil medium putih"),
            keywords: &["geometri", "persegi", "persegi kecil medium putih"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("sukwia obere-etiti ọcha"),
            keywords: &["mgbakọ", "sukwia", "sukwia obere-etiti ọcha"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("hvítur meðalsmár ferningur"),
            keywords: &["ferningur", "hvítur meðalsmár ferningur", "rúmfræði"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("quadrato bianco medio-piccolo"),
            keywords: &["geometria", "quadrato", "quadrato bianco medio-piccolo"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("白四角中"),
            keywords: &["四角", "正方形", "白", "白四角中"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("kothak cilik-sedhengan putih"),
            keywords: &["geometrik", "kothak", "kothak cilik-sedhengan putih"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("საშუალო-პატარა თეთრი კვადრატი"),
            keywords: &[
                "გეომეტრია",
                "გეომეტრიული",
                "კვადრატი",
                "საშუალო-პატარა თეთრი კვადრატი",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("орташа-кіші ақ шаршы"),
            keywords: &["геометриялық", "орташа-кіші ақ шаршы", "шаршы"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("halvlille hvidt kvadrat"),
            keywords: &["geometrisk", "halvlille hvidt kvadrat", "kvadrat"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ប\u{17bd}នជ\u{17d2}រ\u{17bb}ងត\u{17bc}ចល\u{17d2}មមពណ\u{17cc}ស"),
            keywords: &[
                "ត\u{17bc}ចល\u{17d2}មម",
                "ប\u{17bd}នជ\u{17d2}រ\u{17bb}ង",
                "ប\u{17bd}នជ\u{17d2}រ\u{17bb}ងត\u{17bc}ចល\u{17d2}មមពណ\u{17cc}ស",
                "ស",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಬ\u{cbf}ಳ\u{cbf} ಬಣ\u{ccd}ಣದ ಮಧ\u{ccd}ಯಮ ಸಣ\u{ccd}ಣ ಚ\u{ccc}ಕ"),
            keywords: &[
                "ಬ\u{cbf}ಳ\u{cbf} ಬಣ\u{ccd}ಣದ ಮಧ\u{ccd}ಯಮ ಸಣ\u{ccd}ಣ ಚ\u{ccc}ಕ",
                "ಬ\u{cbf}ಳ\u{cbf} ಬಣ\u{ccd}ಣದ ಸಣ\u{ccd}ಣ ಚ\u{ccc}ಕ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("중간 작은 흰색 사각형"),
            keywords: &["무늬", "사각형", "중간 작은 흰색 사각형"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("धवो मध\u{94d}यम-ल\u{94d}हान चवकोन"),
            keywords: &[
                "चवकोन",
                "जियोम\u{945}ट\u{94d}रीक",
                "धवो मध\u{94d}यम-ल\u{94d}हान चवकोन",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("кичирээк ак чарчы"),
            keywords: &["геометрия", "кичирээк ак чарчы", "чарчы"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("wäisse mëttelklenge Quadrat"),
            keywords: &["Quadrat", "geometresch", "wäisse mëttelklenge Quadrat"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ສ\u{eb5}\u{ec8}ຫ\u{ebc}\u{ec8}ຽມນ\u{ec9}ອຍ-ປານກາງສ\u{eb5}ຂາວ"),
            keywords: &[
                "ສ\u{eb5}\u{ec8}ຫ\u{ebc}\u{ec8}ຽມ",
                "ສ\u{eb5}\u{ec8}ຫ\u{ebc}\u{ec8}ຽມນ\u{ec9}ອຍ-ປານກາງສ\u{eb5}ຂາວ",
                "ເລຂາຄະນ\u{eb4}ດ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("baltas vidutiniškai mažas kvadratas"),
            keywords: &[
                "baltas vidutiniškai mažas kvadratas",
                "geometrija",
                "kvadratas",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("vidēji mazs balts kvadrāts"),
            keywords: &["kvadrāts", "vidēji mazs balts kvadrāts", "ģeometrija"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tapawhā rite mā waenga-iti"),
            keywords: &["tapawhā rite", "tapawhā rite mā waenga-iti", "āhuahanga"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("бел квадрат со средна големина"),
            keywords: &["бел квадрат со средна големина", "геометрија", "квадрат"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ചെറിയ വെള\u{d41}ത\u{d4d}ത ചത\u{d41}രം"),
            keywords: &[
                "കളം",
                "ചത\u{d41}രം",
                "ചെറിയ വെള\u{d41}ത\u{d4d}ത ചത\u{d41}രം",
                "ജിയോമെട\u{d4d}രിക\u{d4d}ക\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("цагаан жижгэвтэр дөрвөлжин"),
            keywords: &["геометр", "дөрвөлжин", "цагаан жижгэвтэр дөрвөлжин"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("पा\u{902}ढरा मध\u{94d}\u{200d}यम-लहान आकाराचा चौरस"),
            keywords: &[
                "चौरस",
                "पा\u{902}ढरा मध\u{94d}\u{200d}यम-लहान आकाराचा चौरस",
                "भ\u{942}मितीय",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("persegi sederhana kecil putih"),
            keywords: &["geometri", "persegi", "persegi sederhana kecil putih"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("kwadrat medju żgħar abjad"),
            keywords: &["kwadrat medju żgħar abjad", "kwadru", "ġeometrika"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "အဖြ\u{1030}ရောင\u{103a} လေးထောင\u{1037}\u{103a}က\u{103d}က\u{103a} အလတ\u{103a}စားအသေး",
            ),
            keywords: &[
                "ဂျ\u{102e}ဩမေတြ\u{102e}",
                "လေးထောင\u{1037}\u{103a}က\u{103d}က\u{103a}",
                "အဖြ\u{1030}ရောင\u{103a} လေးထောင\u{1037}\u{103a}က\u{103d}က\u{103a} အလတ\u{103a}စားအသေး",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("liten/mellomstor hvit firkant"),
            keywords: &[
                "firkant",
                "geometrisk",
                "kvadrat",
                "liten/mellomstor hvit firkant",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("स\u{947}तो मध\u{94d}यम-सानो वर\u{94d}ग"),
            keywords: &[
                "ज\u{94d}यामितीय",
                "वर\u{94d}ग",
                "स\u{947}तो मध\u{94d}यम-सानो वर\u{94d}ग",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("klein tot middelgroot wit vierkant"),
            keywords: &[
                "klein tot middelgroot wit vierkant",
                "redelijk klein",
                "vierkant",
                "wit",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଧଳ\u{b3e} ମଧ\u{b4d}ୟମ-ଛୋଟ ବର\u{b4d}ଗକ\u{b4d}ଷେତ\u{b4d}ର"),
            keywords: &[
                "ଜ\u{b4d}ୟ\u{b3e}ମ\u{b3f}ତ\u{b3f}କ",
                "ଧଳ\u{b3e} ମଧ\u{b4d}ୟମ-ଛୋଟ ବର\u{b4d}ଗକ\u{b4d}ଷେତ\u{b4d}ର",
                "ବର\u{b4d}ଗକ\u{b4d}ଷେତ\u{b4d}ର",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਦਰਮਿਆਨਾ-ਛ\u{a4b}ਟਾ ਚਿ\u{a71}ਟਾ ਵਰਗ"),
            keywords: &["ਜਯਾਮਿਤੀ", "ਦਰਮਿਆਨਾ-ਛ\u{a4b}ਟਾ ਚਿ\u{a71}ਟਾ ਵਰਗ", "ਵਰਗ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("چٹ\u{651}ا درمیانہ ـ نیکا مربع"),
            keywords: &[
                "جیومیٹری دے متعلق",
                "مربع",
                "چٹ\u{651}ا درمیانہ ـ نیکا مربع",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Waít Mídiọ\u{301}m-Smọ\u{301}l Skwea"),
            keywords: &[
                "Jiọ\u{301}mẹ\u{301}tri",
                "Skwea",
                "Waít Mídiọ\u{301}m-Smọ\u{301}l Skwea",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("mały/średni biały kwadrat"),
            keywords: &[
                "biały",
                "figura geometryczna",
                "kwadracik",
                "kwadrat",
                "mały/średni biały kwadrat",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("سپينه ميانه کوچنۍ مربع"),
            keywords: &["جيوميتريکي", "سپينه ميانه کوچنۍ مربع", "مربع"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("quadrado branco médio menor"),
            keywords: &["geométrico", "quadrado", "quadrado branco médio menor"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("quadrado branco pequeno/médio"),
            keywords: &["geométrico", "quadrado", "quadrado branco pequeno/médio"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("pătrat alb mediu spre mic"),
            keywords: &["alb", "geometric", "pătrat", "pătrat alb mediu spre mic"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-039"),
            keywords: &["E10-039"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("небольшой белый квадрат"),
            keywords: &[
                "белый",
                "геометрия",
                "квадрат",
                "небольшой белый квадрат",
                "небольшой квадрат",
                "фигура",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("kare ntoya iringaniye y’umweru"),
            keywords: &["ishusho", "kare", "kare ntoya iringaniye y’umweru"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("سفيد وچولو-ننڍو چورس"),
            keywords: &["جيوميٽرڪ", "سفيد وچولو-ننڍو چورس", "چورس"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some(
                "ස\u{dd4}ද\u{dd4} මධ\u{dca}\u{200d}යම ප\u{dca}\u{200d}රම\u{dcf}ණයේ-ක\u{dd4}ඩ\u{dcf} කොට\u{dd4}ව",
            ),
            keywords: &[
                "ජ\u{dca}\u{200d}ය\u{dcf}ම\u{dd2}ත\u{dd2}ක",
                "ස\u{dd4}ද\u{dd4} මධ\u{dca}\u{200d}යම ප\u{dca}\u{200d}රම\u{dcf}ණයේ-ක\u{dd4}ඩ\u{dcf} කොට\u{dd4}ව",
                "හතරැස\u{dca}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("stredne malý biely štvorec"),
            keywords: &["geometria", "stredne malý biely štvorec", "štvorec"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("srednje mali beli kvadrat"),
            keywords: &["geometrično", "kvadrat", "srednje mali beli kvadrat"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("afar gees dhexdhexaad yar oo cad"),
            keywords: &[
                "afar gees",
                "afar gees dhexdhexaad yar oo cad",
                "joometriyeed",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("katror mesatarisht i vogël i bardhë"),
            keywords: &[
                "gjeometrik",
                "katror",
                "katror mesatarisht i vogël i bardhë",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("средњемали бели квадрат"),
            keywords: &["гeoмeтриja", "квaдрaт", "средњемали бели квадрат"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("средњемали бијели квадрат"),
            keywords: &["средњемали бијели квадрат"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("srednjemali beli kvadrat"),
            keywords: &["geometrija", "kvadrat", "srednjemali beli kvadrat"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("srednjemali bijeli kvadrat"),
            keywords: &["srednjemali bijeli kvadrat"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("mellanliten vit ruta"),
            keywords: &[
                "geometrisk",
                "medelstor vit ruta",
                "mellanliten vit ruta",
                "ruta",
                "vit",
            ],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mraba wastani mdogo mweupe"),
            keywords: &["jiometri", "mraba", "mraba wastani mdogo mweupe"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("நடுத\u{bcd}தரம\u{bcd}-சிறிய வெள\u{bcd}ளை சதுரம\u{bcd}"),
            keywords: &[
                "ஒயிட\u{bcd} ம\u{bc0}டியம\u{bcd} ஸ\u{bcd}கொயர\u{bcd}",
                "நடுத\u{bcd}தரம\u{bcd}-சிறிய வெள\u{bcd}ளை சதுரம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("మధ\u{c4d}యస\u{c4d}థ చ\u{c3f}న\u{c4d}న త\u{c46}లుపు రంగు చతురస\u{c4d}రం"),
            keywords: &[
                "చతురస\u{c4d}రం",
                "త\u{c46}లుపు రంగు",
                "మధ\u{c4d}యస\u{c4d}థ చ\u{c3f}న\u{c4d}న త\u{c46}లుపు రంగు చతురస\u{c4d}రం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("чоркунҷаи хурди миёнаи сафед"),
            keywords: &["геометрӣ", "чоркунҷа", "чоркунҷаи хурди миёнаи сафед"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ส\u{e35}\u{e48}เหล\u{e35}\u{e48}ยมเล\u{e47}กปานกลางส\u{e35}ขาว"),
            keywords: &[
                "ส\u{e35}\u{e48}เหล\u{e35}\u{e48}ยม",
                "ส\u{e35}\u{e48}เหล\u{e35}\u{e48}ยมเล\u{e47}กปานกลางส\u{e35}ขาว",
                "เรขาคณ\u{e34}ต",
            ],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ጻዕዳ ማእከላይ-ንኢሽተይ ትርብዒት"),
            keywords: &["ትርብዒት", "ጂኦሜትሪክ", "ጻዕዳ ማእከላይ-ንኢሽተይ ትርብዒት"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ak orta-kiçi inedördül"),
            keywords: &["ak orta-kiçi inedördül", "geometrik", "inedördül"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tapafā siʻi mo hinehina"),
            keywords: &["hinehina", "tapafā", "tapafā siʻi mo hinehina"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("küçük-orta beyaz kare"),
            keywords: &["geometri", "kare", "küçük-orta beyaz kare"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئاق كىچىكرەك كىۋادرات"),
            keywords: &["ئاق كىچىكرەك كىۋادرات", "كىۋادرات", "گېئومېتىرىيە"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("менший за середній білий квадрат"),
            keywords: &[
                "геометричний",
                "квадрат",
                "менший за середній білий квадрат",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("سفید میڈ\u{650}یم چھوٹا چوکور"),
            keywords: &[
                "جیومیٹری",
                "سفید",
                "سفید میڈ\u{650}یم چھوٹا چوکور",
                "میڈ\u{650}م",
                "چوکور",
                "چھوٹا",
            ],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("kichikroq oq kvadrat"),
            keywords: &["geometrik", "kichikroq oq kvadrat", "kvadrat"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("hình vuông nhỏ vừa màu trắng"),
            keywords: &["hình học", "hình vuông", "hình vuông nhỏ vừa màu trắng"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("kaare yam-ndaw te weex"),
            keywords: &["bu-geometri", "kaare", "kaare yam-ndaw te weex"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("iskwere esiphakathi-buncinane esimhlophe"),
            keywords: &[
                "ijiyometriki",
                "iskwere",
                "iskwere esiphakathi-buncinane esimhlophe",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("onigunmẹrin idaji-kekere funfun"),
            keywords: &[
                "ilà onigun mé\u{329}rin",
                "jiomé\u{329}tíríkì",
                "onigunmẹrin idaji-kekere funfun",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("中細白色正方形"),
            keywords: &["中細白色正方形", "幾何", "正方形"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("中细白色正方形"),
            keywords: &["中细白色正方形", "几何", "正方形"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("白色中小方块"),
            keywords: &["中小 正方形", "白色", "白色中小方块"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("白色中小型方塊"),
            keywords: &["方形", "白色中小型方塊"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("白色中細正方形"),
            keywords: &[
                "中小白色正方形",
                "正方形",
                "白色中小正方形",
                "白色中細正方形",
            ],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("iskwele esimhlophe esimaphakathi esincane"),
            keywords: &[
                "iskwele",
                "iskwele esimhlophe esimaphakathi esincane",
                "jiyometrikhi",
            ],
        },
    ],
};
#[doc = "▪\u{fe0f}"]
pub const BLACK_SMALL_SQUARE: crate::Emoji = crate::Emoji {
    glyph: "▪\u{fe0f}",
    codepoint: "25AA FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "black small square",
    group: "Symbols",
    subgroup: "geometric",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "▪",
        codepoint: "25AA",
        status: crate::Status::Unqualified,
        introduction_version: 0.6f32,
        name: "black small square",
        group: "Symbols",
        subgroup: "geometric",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("klein swart vierkant"),
            keywords: &["geometries", "klein swart vierkant", "swart", "vierkant"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ጥቁር ትንሽ ካሬ"),
            keywords: &["ካሬ", "ጂኦሜትሪያዊ", "ጥቁር ትንሽ ካሬ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("مربع صغير أسود"),
            keywords: &["مربع", "مربع صغير أسود", "هندسي"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ক’ল\u{9be} সৰ\u{9c1} বৰ\u{9cd}গ"),
            keywords: &[
                "ক’ল\u{9be} সৰ\u{9c1} বৰ\u{9cd}গ",
                "জ\u{9cd}য\u{9be}মিতিক",
                "বৰ\u{9cd}গ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("qara balaca kvadrat"),
            keywords: &["həndəsi", "kvadrat", "qara balaca kvadrat"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("малы чорны квадрат"),
            keywords: &["аб’ект", "геаметрычны", "квадрат", "малы чорны квадрат"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Малък черен квадрат"),
            keywords: &["Малък черен квадрат", "геометричен", "квадрат"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ক\u{9be}লো ছোট বর\u{9cd}গক\u{9cd}ষেত\u{9cd}র"),
            keywords: &[
                "ক\u{9be}লো ছোট বর\u{9cd}গক\u{9cd}ষেত\u{9cd}র",
                "জ\u{9cd}য\u{9be}মিতিক",
                "বর\u{9cd}গ\u{9be}ক\u{9be}র",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("karrez bihan du"),
            keywords: &["du", "karrez", "karrez bihan du"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("crni kvadratić"),
            keywords: &["crni kvadratić", "geometrija", "kvadrat"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("quadrat negre petit"),
            keywords: &["geometria", "negre", "petit", "quadrat"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎬᎿᎨ ᎤᏍᏗ ᏅᎩ ᏧᏅᏏᏯ"),
            keywords: &["ᎬᎿᎨ ᎤᏍᏗ ᏅᎩ ᏧᏅᏏᏯ", "ᏅᎩ ᏧᏅᏏᏯ", "ᏗᏎᏍᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("černý čtvereček"),
            keywords: &["geometrie", "černý čtvereček", "čtverec"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("sgwâr bach du"),
            keywords: &["geometrig", "sgwâr", "sgwâr bach du"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("lille sort kvadrat"),
            keywords: &["geometrisk", "kvadrat", "lille sort kvadrat"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("kleines schwarzes Quadrat"),
            keywords: &["Quadrat", "kleines schwarzes Quadrat", "schwarz"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("μικρό μαύρο τετράγωνο"),
            keywords: &["γεωμετρικό", "μικρό μαύρο τετράγωνο", "τετράγωνο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("black small square"),
            keywords: &["black small square", "geometric", "square"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("cuadrado negro pequeño"),
            keywords: &["cuadrado", "cuadrado negro pequeño", "geometría", "negro"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("väike must ruut"),
            keywords: &["geomeetria", "ruut", "väike must ruut"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("karratu beltz txikia"),
            keywords: &["geometriko", "karratu", "karratu beltz txikia"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("مربع مشکی کوچک"),
            keywords: &["شکل هندسی", "مربع", "مربع مشکی کوچک"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("pieni musta neliö"),
            keywords: &["muoto", "neliö", "pieni musta neliö"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("maliit na itim na parisukat"),
            keywords: &[
                "hugis",
                "itim",
                "maliit",
                "maliit na itim na parisukat",
                "parisukat",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("lítil svartur fýrakantur"),
            keywords: &[
                "fýrakantur",
                "lítil svartur fýrakantur",
                "mátingarfrøðiligur",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("petit carré noir"),
            keywords: &["carré", "forme géométrique", "petit carré noir"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("cearnóg dhubh bheag"),
            keywords: &[
                "cearnóg",
                "cearnóg dhubh bheag",
                "cearnóg dubh beag",
                "geoiméadrach",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("ceàrnag bheag dhubh"),
            keywords: &["ceàrnag", "ceàrnag bheag dhubh", "geomatrach"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cadrado pequeno negro"),
            keywords: &["cadrado", "negro", "pequeno"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("કાળો નાનો ચોરસ"),
            keywords: &["કાળો નાનો ચોરસ", "ચોરસ", "ભૌમિતિક"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("baƙin ƙaramin murabba’i"),
            keywords: &[
                "baƙin ƙaramin murabba’i",
                "ilimin halayen sura",
                "murabba’i",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("ריבוע שחור קטן"),
            keywords: &["צורה", "ריבוע", "ריבוע שחור קטן", "שחור"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("काला छोटा वर\u{94d}ग"),
            keywords: &["काला छोटा वर\u{94d}ग", "ज\u{94d}यामिति"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("mali crni kvadrat"),
            keywords: &["geometrija", "kvadrat", "mali crni kvadrat"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("kis fekete négyzet"),
            keywords: &["geometria", "kis fekete négyzet", "négyzet"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("սև փոքր քառակուսի"),
            keywords: &["երկրաչափական", "սև փոքր քառակուսի", "քառակուսի"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("persegi kecil hitam"),
            keywords: &["geometri", "persegi", "persegi kecil hitam"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("obere sukwia ojii"),
            keywords: &["mgbakọ", "obere sukwia ojii", "sukwia"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("lítill svartur ferningur"),
            keywords: &["ferningur", "lítill svartur ferningur", "rúmfræði"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("quadrato nero piccolo"),
            keywords: &["geometria", "quadrato", "quadrato nero piccolo"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("黒四角小"),
            keywords: &["四角", "正方形", "黒", "黒四角小"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("kothak cilik ireng"),
            keywords: &["geometrik", "kothak", "kothak cilik ireng"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("პატარა შავი კვადრატი"),
            keywords: &[
                "გეომეტრია",
                "გეომეტრიული",
                "კვადრატი",
                "პატარა შავი კვადრატი",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("кіші қара шаршы"),
            keywords: &["геометриялық", "кіші қара шаршы", "шаршы"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("lille sort kvadrat"),
            keywords: &["geometrisk", "kvadrat", "lille sort kvadrat"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ប\u{17bd}នជ\u{17d2}រ\u{17bb}ងត\u{17bc}ចពណ\u{17cc}ខ\u{17d2}មៅ"),
            keywords: &[
                "ខ\u{17d2}មៅ",
                "ត\u{17bc}ច",
                "ប\u{17bd}នជ\u{17d2}រ\u{17bb}ង",
                "ប\u{17bd}នជ\u{17d2}រ\u{17bb}ងត\u{17bc}ចពណ\u{17cc}ខ\u{17d2}មៅ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕಪ\u{ccd}ಪು ಬಣ\u{ccd}ಣದ ಸಣ\u{ccd}ಣ ಚ\u{ccc}ಕ"),
            keywords: &[
                "ಕಪ\u{ccd}ಪು ಬಣ\u{ccd}ಣದ ಸಣ\u{ccd}ಣ ಗಾತ\u{ccd}ರದ ಚ\u{ccc}ಕ",
                "ಕಪ\u{ccd}ಪು ಬಣ\u{ccd}ಣದ ಸಣ\u{ccd}ಣ ಚ\u{ccc}ಕ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("작은 검은색 사각형"),
            keywords: &["무늬", "사각형", "작은 검은색 사각형"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("काळो ल\u{94d}हान चवकोन"),
            keywords: &["काळो ल\u{94d}हान चवकोन", "चवकोन", "जियोम\u{945}ट\u{94d}रीक"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("кичинекей кара чарчы"),
            keywords: &["геометрия", "кичинекей кара чарчы", "чарчы"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("klenge schwaarze Quadrat"),
            keywords: &["Quadrat", "geometresch", "klenge schwaarze Quadrat"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ສ\u{eb5}\u{ec8}ຫ\u{ebc}\u{ec8}ຽມນ\u{ec9}ອຍສ\u{eb5}ດ\u{ecd}າ"),
            keywords: &[
                "ສ\u{eb5}\u{ec8}ຫ\u{ebc}\u{ec8}ຽມ",
                "ສ\u{eb5}\u{ec8}ຫ\u{ebc}\u{ec8}ຽມນ\u{ec9}ອຍສ\u{eb5}ດ\u{ecd}າ",
                "ເລຂາຄະນ\u{eb4}ດ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("juodas mažas kvadratas"),
            keywords: &["geometrija", "juodas mažas kvadratas", "kvadratas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("mazs melns kvadrāts"),
            keywords: &["kvadrāts", "mazs melns kvadrāts", "ģeometrija"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tapawhā rite pango iti"),
            keywords: &["tapawhā rite", "tapawhā rite pango iti", "āhuahanga"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("мал црн квадрат"),
            keywords: &["геометрија", "квадрат", "мал црн квадрат"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("വളരെ ചെറിയ കറ\u{d41}ത\u{d4d}ത ചത\u{d41}രം"),
            keywords: &[
                "കളം",
                "ചത\u{d41}രം",
                "ജിയോമെട\u{d4d}രിക\u{d4d}ക\u{d4d}",
                "വളരെ ചെറിയ കറ\u{d41}ത\u{d4d}ത ചത\u{d41}രം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("хар жижиг дөрвөлжин"),
            keywords: &["геометр", "дөрвөлжин", "хар жижиг дөрвөлжин"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("काळा लहान चौरस"),
            keywords: &["काळा लहान चौरस", "चौरस", "भ\u{942}मितीय"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("persegi kecil hitam"),
            keywords: &["geometri", "persegi", "persegi kecil hitam"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("kwadri żgħir iswed"),
            keywords: &["kwadri żgħir iswed", "kwadru", "ġeometrika"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အနက\u{103a}ရောင\u{103a} လေးထောင\u{1037}\u{103a}က\u{103d}က\u{103a} အသေး"),
            keywords: &[
                "ဂျ\u{102e}ဩမေတြ\u{102e}",
                "လေးထောင\u{1037}\u{103a}က\u{103d}က\u{103a}",
                "အနက\u{103a}ရောင\u{103a} လေးထောင\u{1037}\u{103a}က\u{103d}က\u{103a} အသေး",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("liten svart firkant"),
            keywords: &["firkant", "geometrisk", "kvadrat", "liten svart firkant"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("कालो सानो वर\u{94d}ग"),
            keywords: &["कालो सानो वर\u{94d}ग", "ज\u{94d}यामितीय", "वर\u{94d}ग"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("klein zwart vierkant"),
            keywords: &["geometrisch", "klein zwart vierkant", "vierkant"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("liten svart firkant"),
            keywords: &["firkant", "geometrisk", "kvadrat", "liten svart firkant"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("କଳ\u{b3e} ଛୋଟ ବର\u{b4d}ଗ\u{b3e}କ\u{b3e}ର କ\u{b4d}ଷେତ\u{b4d}ର"),
            keywords: &[
                "କଳ\u{b3e} ଛୋଟ ବର\u{b4d}ଗ\u{b3e}କ\u{b3e}ର କ\u{b4d}ଷେତ\u{b4d}ର",
                "ଜ\u{b4d}ୟ\u{b3e}ମ\u{b3f}ତ\u{b3f}କ",
                "ବର\u{b4d}ଗକ\u{b4d}ଷେତ\u{b4d}ର",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਛ\u{a4b}ਟਾ ਕਾਲਾ ਵਰਗ"),
            keywords: &["ਛ\u{a4b}ਟਾ ਕਾਲਾ ਵਰਗ", "ਜਯਾਮਿਤੀ", "ਵਰਗ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("کالا نیک\u{651}ا مربع"),
            keywords: &["جیومیٹری دے متعلق", "مربع", "کالا نیک\u{651}ا مربع"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Blák Smọ\u{301}l Skwea"),
            keywords: &["Blák Smọ\u{301}l Skwea", "Jiọ\u{301}mẹ\u{301}tri", "Skwea"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("mały czarny kwadrat"),
            keywords: &[
                "czarny",
                "figura geometryczna",
                "kwadracik",
                "kwadrat",
                "mały czarny kwadrat",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("توره کوچنۍ مربع"),
            keywords: &["توره کوچنۍ مربع", "جيوميتريکي", "مربع"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("quadrado preto pequeno"),
            keywords: &["geométrico", "quadrado", "quadrado preto pequeno"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["geométrico", "quadrado", "quadrado preto pequeno"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("pătrat negru mic"),
            keywords: &["geometric", "negru", "pătrat", "pătrat negru mic"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-033"),
            keywords: &["E10-033"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("черный квадратик"),
            keywords: &[
                "геометрия",
                "квадрат",
                "маленький квадрат",
                "фигура",
                "черный",
                "черный квадратик",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("kare ntoya y’umukara"),
            keywords: &["ishusho", "kare", "kare ntoya y’umukara"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڪارو ننڍو چورس"),
            keywords: &["جيوميٽرڪ", "چورس", "ڪارو ننڍو چورس"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("කළ\u{dd4} ක\u{dd4}ඩ\u{dcf} කොට\u{dd4}ව"),
            keywords: &[
                "කළ\u{dd4} ක\u{dd4}ඩ\u{dcf} කොට\u{dd4}ව",
                "ජ\u{dca}\u{200d}ය\u{dcf}ම\u{dd2}ත\u{dd2}ක",
                "හතරැස\u{dca}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("čierny štvorček"),
            keywords: &["geometria", "čierny štvorček", "štvorec"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("majhen črn kvadrat"),
            keywords: &["geometrično", "kvadrat", "majhen črn kvadrat"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("afar gees yar oo madow"),
            keywords: &["afar gees", "afar gees yar oo madow", "joometriyeed"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("katror i vogël i zi"),
            keywords: &["gjeometri", "katror", "katror i vogël i zi"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("мали црни квадрат"),
            keywords: &["гeoмeтриja", "квaдрaт", "мали црни квадрат"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("mali crni kvadrat"),
            keywords: &["geometrija", "kvadrat", "mali crni kvadrat"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("liten svart ruta"),
            keywords: &["liten svart ruta", "ruta", "svart"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mraba mdogo mweusi"),
            keywords: &["jiometri", "mraba", "mraba mdogo mweusi"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("சிறிய கருப\u{bcd}பு சதுரம\u{bcd}"),
            keywords: &[
                "கருப\u{bcd}பு சதுரம\u{bcd}",
                "சிறிய கருப\u{bcd}பு சதுரம\u{bcd}",
                "பிள\u{bbe}க\u{bcd} ஸ\u{bcd}கொயர\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("చ\u{c3f}న\u{c4d}న నలుపు రంగు చతురస\u{c4d}రం"),
            keywords: &[
                "చతురస\u{c4d}రం",
                "చ\u{c3f}న\u{c4d}న నలుపు రంగు చతురస\u{c4d}రం",
                "నలుపు రంగు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("чоркунҷаи хурди сиёҳ"),
            keywords: &["геометрӣ", "чоркунҷа", "чоркунҷаи хурди сиёҳ"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ส\u{e35}\u{e48}เหล\u{e35}\u{e48}ยมเล\u{e47}กส\u{e35}ดำ"),
            keywords: &[
                "ส\u{e35}\u{e48}เหล\u{e35}\u{e48}ยม",
                "ส\u{e35}\u{e48}เหล\u{e35}\u{e48}ยมเล\u{e47}กส\u{e35}ดำ",
                "เรขาคณ\u{e34}ต",
            ],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ጸሊም ንኢሽተይ ትርብዒት"),
            keywords: &["ትርብዒት", "ጂኦሜትሪክ", "ጸሊም ንኢሽተይ ትርብዒት"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("gara kiçi inedördül"),
            keywords: &["gara kiçi inedördül", "geometrik", "inedördül"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tapafā siʻisiʻi mo ʻuliʻuli"),
            keywords: &["tapafā", "tapafā siʻisiʻi mo ʻuliʻuli", "ʻuliʻuli"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("küçük siyah kare"),
            keywords: &["geometri", "kare", "küçük siyah kare"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("قارا كىچىك كىۋادرات"),
            keywords: &["قارا كىچىك كىۋادرات", "كىۋادرات", "گېئومېتىرىيە"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("малий чорний квадрат"),
            keywords: &["геометричний", "квадрат", "малий чорний квадрат"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("کالا چھوٹا چوکور"),
            keywords: &["جیومیٹری", "چوکور", "کالا", "کالا چھوٹا چوکور"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("kichik qora kvadrat"),
            keywords: &["geometrik", "kichik qora kvadrat", "kvadrat"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("hình vuông nhỏ màu đen"),
            keywords: &["hình học", "hình vuông", "hình vuông nhỏ màu đen"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("kaare bu ndaw te ñuul"),
            keywords: &["bu-geometri", "kaare", "kaare bu ndaw te ñuul"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("iskwere esincinane esimnyama"),
            keywords: &["ijiyometriki", "iskwere", "iskwere esincinane esimnyama"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("kékeré onígun mẹ\u{301}rin dúdú"),
            keywords: &[
                "ilà onigun mé\u{329}rin",
                "jiomé\u{329}tíríkì",
                "kékeré onígun mẹ\u{301}rin dúdú",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("細黑色正方形"),
            keywords: &["幾何", "正方形", "細黑色正方形"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("细黑色正方形"),
            keywords: &["几何", "正方形", "细黑色正方形"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("黑色小方块"),
            keywords: &["小", "正方形", "黑色", "黑色小方块"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("黑色小方塊"),
            keywords: &["方形", "黑色小方塊"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("黑色小正方形"),
            keywords: &["小黑色正方形", "正方形", "黑色小正方形"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("iskwele esincane esimnyama"),
            keywords: &["iskwele", "iskwele esincane esimnyama", "jiyometrikhi"],
        },
    ],
};
#[doc = "▫\u{fe0f}"]
pub const WHITE_SMALL_SQUARE: crate::Emoji = crate::Emoji {
    glyph: "▫\u{fe0f}",
    codepoint: "25AB FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "white small square",
    group: "Symbols",
    subgroup: "geometric",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "▫",
        codepoint: "25AB",
        status: crate::Status::Unqualified,
        introduction_version: 0.6f32,
        name: "white small square",
        group: "Symbols",
        subgroup: "geometric",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("klein wit vierkant"),
            keywords: &["geometries", "klein wit vierkant", "vierkant", "wit"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ነጭ ትንሽ ካሬ"),
            keywords: &["ነጭ ትንሽ ካሬ", "ካሬ", "ጂኦሜትሪያዊ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("مربع صغير أبيض"),
            keywords: &["مربع", "مربع صغير أبيض", "هندسة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("বগ\u{9be} সৰ\u{9c1} বৰ\u{9cd}গ"),
            keywords: &[
                "জ\u{9cd}য\u{9be}মিতিক",
                "বগ\u{9be} সৰ\u{9c1} বৰ\u{9cd}গ",
                "বৰ\u{9cd}গ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("ağ balaca kvadrat"),
            keywords: &["ağ balaca kvadrat", "həndəsi", "kvadrat"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("малы белы квадрат"),
            keywords: &["аб’ект", "геаметрычны", "квадрат", "малы белы квадрат"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Малък бял квадрат"),
            keywords: &["Малък бял квадрат", "геометричен", "квадрат"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("স\u{9be}দ\u{9be} ছোট বর\u{9cd}গক\u{9cd}ষেত\u{9cd}র"),
            keywords: &[
                "জ\u{9cd}য\u{9be}মিতিক",
                "বর\u{9cd}গ\u{9be}ক\u{9be}র",
                "স\u{9be}দ\u{9be} ছোট বর\u{9cd}গক\u{9cd}ষেত\u{9cd}র",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("karrez bihan gwenn"),
            keywords: &["gwenn", "karrez", "karrez bihan gwenn"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("bijeli kvadratić"),
            keywords: &["bijeli kvadratić", "geometrija", "kvadrat"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("quadrat blanc petit"),
            keywords: &["blanc", "geometria", "petit", "quadrat"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᏁᎦ ᎤᏍᏗ ᏅᎩ ᏧᏅᏏᏯ"),
            keywords: &["ᎤᏁᎦ ᎤᏍᏗ ᏅᎩ ᏧᏅᏏᏯ", "ᏅᎩ ᏧᏅᏏᏯ", "ᏗᏎᏍᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("bílý čtvereček"),
            keywords: &["bílý čtvereček", "geometrie", "čtverec"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("sgwâr bach gwyn"),
            keywords: &["geometrig", "sgwâr", "sgwâr bach gwyn"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("lille hvidt kvadrat"),
            keywords: &["geometrisk", "kvadrat", "lille hvidt kvadrat"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("kleines weißes Quadrat"),
            keywords: &["Quadrat", "kleines weißes Quadrat", "weiß"],
        },
        #[cfg(feature = "de_CH")]
        crate::Annotation {
            lang: "de_CH",
            tts: Some("Kleines weisses Quadrat"),
            keywords: &["Kleines weisses Quadrat", "Quadrat", "weiss"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("μικρό λευκό τετράγωνο"),
            keywords: &["γεωμετρικό", "μικρό λευκό τετράγωνο", "τετράγωνο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("white small square"),
            keywords: &["geometric", "square", "white small square"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("cuadrado blanco pequeño"),
            keywords: &["blanco", "cuadrado", "cuadrado blanco pequeño", "geometría"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("väike valge ruut"),
            keywords: &["geomeetria", "ruut", "väike valge ruut"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("karratu zuri txikia"),
            keywords: &["geometriko", "karratu", "karratu zuri txikia"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("مربع سفید کوچک"),
            keywords: &["شکل هندسی", "مربع", "مربع سفید کوچک"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("pieni valkoinen neliö"),
            keywords: &["muoto", "neliö", "pieni valkoinen neliö"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("maliit na puting parisukat"),
            keywords: &[
                "hugis",
                "maliit",
                "maliit na puting parisukat",
                "parisukat",
                "puti",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("lítil hvítur fýrakantur"),
            keywords: &[
                "fýrakantur",
                "lítil hvítur fýrakantur",
                "mátingarfrøðiligur",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("petit carré blanc"),
            keywords: &["carré", "forme géométrique", "petit carré blanc"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("cearnóg bhán bheag"),
            keywords: &[
                "cearnóg",
                "cearnóg bhán bheag",
                "cearnóg bán beag",
                "geoiméadrach",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("ceàrnag bheag gheal"),
            keywords: &["ceàrnag", "ceàrnag bheag gheal", "geomatrach"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cadrado pequeno branco"),
            keywords: &["branco", "cadrado", "pequeno"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("સફ\u{ac7}દ નાનો ચોરસ"),
            keywords: &["ચોરસ", "ભૌમિતિક", "સફ\u{ac7}દ નાનો ચોરસ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("farin ƙaramin murabba’i"),
            keywords: &[
                "farin ƙaramin murabba’i",
                "ilimin halayen sura",
                "murabba’i",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("ריבוע לבן קטן"),
            keywords: &["לבן", "צורה", "ריבוע", "ריבוע לבן קטן"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("सफ\u{93c}\u{947}द छोटा वर\u{94d}ग"),
            keywords: &["ज\u{94d}यामिति", "सफ\u{93c}\u{947}द छोटा वर\u{94d}ग"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("mali bijeli kvadrat"),
            keywords: &["geometrija", "kvadrat", "mali bijeli kvadrat"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("kis fehér négyzet"),
            keywords: &["geometria", "kis fehér négyzet", "négyzet"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("սպիտակ փոքր քառակուսի"),
            keywords: &["երկրաչափական", "սպիտակ փոքր քառակուսի", "քառակուսի"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("persegi kecil putih"),
            keywords: &["geometri", "persegi", "persegi kecil putih"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("obere sukwia ọcha"),
            keywords: &["mgbakọ", "obere sukwia ọcha", "sukwia"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("lítill hvítur ferningur"),
            keywords: &["ferningur", "lítill hvítur ferningur", "rúmfræði"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("quadrato bianco piccolo"),
            keywords: &["geometria", "quadrato", "quadrato bianco piccolo"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("白四角小"),
            keywords: &["四角", "正方形", "白", "白四角小"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("kothak cilik putih"),
            keywords: &["geometrik", "kothak", "kothak cilik putih"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("პატარა თეთრი კვადრატი"),
            keywords: &[
                "გეომეტრია",
                "გეომეტრიული",
                "კვადრატი",
                "პატარა თეთრი კვადრატი",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("кіші ақ шаршы"),
            keywords: &["геометриялық", "кіші ақ шаршы", "шаршы"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("lille hvidt kvadrat"),
            keywords: &["geometrisk", "kvadrat", "lille hvidt kvadrat"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ប\u{17bd}នជ\u{17d2}រ\u{17bb}ងត\u{17bc}ចពណ\u{17cc}ស"),
            keywords: &[
                "ប\u{17bd}នជ\u{17d2}រ\u{17bb}ង",
                "ប\u{17bd}នជ\u{17d2}រ\u{17bb}ងត\u{17bc}ចពណ\u{17cc}ស",
                "ស",
                "\u{200b} ត\u{17bc}ច",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಬ\u{cbf}ಳ\u{cbf} ಬಣ\u{ccd}ಣದ ಸಣ\u{ccd}ಣ ಚ\u{ccc}ಕ"),
            keywords: &[
                "ಬ\u{cbf}ಳ\u{cbf} ಬಣ\u{ccd}ಣದ ಸಣ\u{ccd}ಣ ಗಾತ\u{ccd}ರದ ಚ\u{ccc}ಕ",
                "ಬ\u{cbf}ಳ\u{cbf} ಬಣ\u{ccd}ಣದ ಸಣ\u{ccd}ಣ ಚ\u{ccc}ಕ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("작은 흰색 사각형"),
            keywords: &["무늬", "사각형", "작은 흰색 사각형"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("धवो ल\u{94d}हान चवकोन"),
            keywords: &["चवकोन", "जियोम\u{945}ट\u{94d}रीक", "धवो ल\u{94d}हान चवकोन"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("кичинекей ак чарчы"),
            keywords: &["геометрия", "кичинекей ак чарчы", "чарчы"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("klenge wäisse Quadrat"),
            keywords: &["Quadrat", "geometresch", "klenge wäisse Quadrat"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ສ\u{eb5}\u{ec8}ຫ\u{ebc}\u{ec8}ຽມນ\u{ec9}ອຍສ\u{eb5}ຂາວ"),
            keywords: &[
                "ສ\u{eb5}\u{ec8}ຫ\u{ebc}\u{ec8}ຽມ",
                "ສ\u{eb5}\u{ec8}ຫ\u{ebc}\u{ec8}ຽມນ\u{ec9}ອຍສ\u{eb5}ຂາວ",
                "ເລຂາຄະນ\u{eb4}ດ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("baltas mažas kvadratas"),
            keywords: &["baltas mažas kvadratas", "geometrija", "kvadratas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("mazs balts kvadrāts"),
            keywords: &["kvadrāts", "mazs balts kvadrāts", "ģeometrija"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tapawhā rite mā iti"),
            keywords: &["tapawhā rite", "tapawhā rite mā iti", "āhuahanga"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("мал бел квадрат"),
            keywords: &["геометрија", "квадрат", "мал бел квадрат"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("വളരെ ചെറിയ വെള\u{d41}ത\u{d4d}ത ചത\u{d41}രം"),
            keywords: &[
                "കളം",
                "ചത\u{d41}രം",
                "ജിയോമെട\u{d4d}രിക\u{d4d}ക\u{d4d}",
                "വളരെ ചെറിയ വെള\u{d41}ത\u{d4d}ത ചത\u{d41}രം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("цагаан жижиг дөрвөлжин"),
            keywords: &["геометр", "дөрвөлжин", "цагаан жижиг дөрвөлжин"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("पा\u{902}ढरा लहान चौरस"),
            keywords: &["चौरस", "पा\u{902}ढरा लहान चौरस", "भ\u{942}मितीय"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("persegi kecil putih"),
            keywords: &["geometri", "persegi", "persegi kecil putih"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("kwadrat żgħir abjad"),
            keywords: &["kwadrat żgħir abjad", "kwadru", "ġeometrika"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အဖြ\u{1030}ရောင\u{103a} လေးထောင\u{1037}\u{103a}က\u{103d}က\u{103a} အသေး"),
            keywords: &[
                "ဂျ\u{102e}ဩမေတြ\u{102e}",
                "လေထောင\u{1037}\u{103a}က\u{103d}က\u{103a}",
                "အဖြ\u{1030}ရောင\u{103a} လေးထောင\u{1037}\u{103a}က\u{103d}က\u{103a} အသေး",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("liten hvit firkant"),
            keywords: &["firkant", "geometrisk", "kvadrat", "liten hvit firkant"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("स\u{947}तो सानो वर\u{94d}ग"),
            keywords: &[
                "ज\u{94d}यामितीय",
                "वर\u{94d}ग",
                "स\u{947}तो सानो वर\u{94d}ग",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("klein wit vierkant"),
            keywords: &["geometrisch", "klein wit vierkant", "vierkant"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("liten kvit firkant"),
            keywords: &["firkant", "geometrisk", "kvadrat", "liten kvit firkant"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଧଳ\u{b3e} ଛୋଟ ବର\u{b4d}ଗକ\u{b4d}ଷେତ\u{b4d}ର"),
            keywords: &[
                "ଜ\u{b4d}ୟ\u{b3e}ମ\u{b3f}ତ\u{b3f}କ",
                "ଧଳ\u{b3e} ଛୋଟ ବର\u{b4d}ଗକ\u{b4d}ଷେତ\u{b4d}ର",
                "ବର\u{b4d}ଗକ\u{b4d}ଷେତ\u{b4d}ର",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਛ\u{a4b}ਟਾ ਚਿ\u{a71}ਟਾ ਵਰਗ"),
            keywords: &["ਛ\u{a4b}ਟਾ ਚਿ\u{a71}ਟਾ ਵਰਗ", "ਜਯਾਮਿਤੀ", "ਵਰਗ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("چ\u{650}یٹا نیک\u{651}ا مربع"),
            keywords: &["جیومیٹری دے متعلق", "مربع", "چ\u{650}یٹا نیک\u{651}ا مربع"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Waít Smọ\u{301}l Skwea"),
            keywords: &["Jiọ\u{301}mẹ\u{301}tri", "Skwea", "Waít Smọ\u{301}l Skwea"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("mały biały kwadrat"),
            keywords: &[
                "biały",
                "figura geometryczna",
                "kwadracik",
                "kwadrat",
                "mały biały kwadrat",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("سپينه کوچنۍ مربع"),
            keywords: &["جيوميتريکي", "سپينه کوچنۍ مربع", "مربع"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("quadrado branco pequeno"),
            keywords: &["geométrico", "quadrado", "quadrado branco pequeno"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["geométrico", "quadrado", "quadrado branco pequeno"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("pătrat alb mic"),
            keywords: &["alb", "geometric", "pătrat", "pătrat alb mic"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-034"),
            keywords: &["E10-034"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("белый квадратик"),
            keywords: &[
                "белый",
                "белый квадратик",
                "геометрия",
                "квадрат",
                "маленький квадрат",
                "фигура",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("kare ntoya y’umweru"),
            keywords: &["ishusho", "kare", "kare ntoya y’umweru"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("اڇو ننڍو چورس"),
            keywords: &["اڇو ننڍو چورس", "جيوميٽرڪ", "چورس"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ස\u{dd4}ද\u{dd4} ක\u{dd4}ඩ\u{dcf} කොට\u{dd4}ව"),
            keywords: &[
                "ජ\u{dca}\u{200d}ය\u{dcf}ම\u{dd2}ත\u{dd2}ක",
                "ස\u{dd4}ද\u{dd4} ක\u{dd4}ඩ\u{dcf} කොට\u{dd4}ව",
                "හතරැස\u{dca}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("biely štvorček"),
            keywords: &["biely štvorček", "geometria", "štvorec"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("majhen bel kvadrat"),
            keywords: &["geometrično", "kvadrat", "majhen bel kvadrat"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("afar gees yar oo cad"),
            keywords: &["afar gees", "afar gees yar oo cad", "joometriyeed"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("katror i vogël i bardhë"),
            keywords: &["gjeometrik", "katror", "katror i vogël i bardhë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("мали бели квадрат"),
            keywords: &["гeoмeтриja", "квaдрaт", "мали бели квадрат"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("мали бијели квадрат"),
            keywords: &["мали бијели квадрат"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("mali beli kvadrat"),
            keywords: &["geometrija", "kvadrat", "mali beli kvadrat"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("mali bijeli kvadrat"),
            keywords: &["mali bijeli kvadrat"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("liten vit ruta"),
            keywords: &["liten vit ruta", "ruta", "vit"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mraba mdogo mweupe"),
            keywords: &["jiometri", "mraba", "mraba mdogo mweupe"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("சிறிய வெள\u{bcd}ளை சதுரம\u{bcd}"),
            keywords: &[
                "ஒயிட\u{bcd} ஸ\u{bcd}கொயர\u{bcd}",
                "சிறிய வெள\u{bcd}ளை சதுரம\u{bcd}",
                "வெள\u{bcd}ளை சதுரம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("చ\u{c3f}న\u{c4d}న త\u{c46}లుపు రంగు చతురస\u{c4d}రం"),
            keywords: &[
                "చతురస\u{c4d}రం",
                "చ\u{c3f}న\u{c4d}న త\u{c46}లుపు రంగు చతురస\u{c4d}రం",
                "త\u{c46}లుపు రంగు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("чоркунҷаи хурди сафед"),
            keywords: &["геометрӣ", "чоркунҷа", "чоркунҷаи хурди сафед"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ส\u{e35}\u{e48}เหล\u{e35}\u{e48}ยมเล\u{e47}กส\u{e35}ขาว"),
            keywords: &[
                "ส\u{e35}\u{e48}เหล\u{e35}\u{e48}ยม",
                "ส\u{e35}\u{e48}เหล\u{e35}\u{e48}ยมเล\u{e47}กส\u{e35}ขาว",
                "เรขาคณ\u{e34}ต",
            ],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ጻዕዳ ንኢሽተይ ትርብዒት"),
            keywords: &["ትርብዒት", "ጂኦሜትሪክ", "ጻዕዳ ንኢሽተይ ትርብዒት"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ak kiçi inedördül"),
            keywords: &["ak kiçi inedördül", "geometrik", "inedördül"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tapafā siʻisiʻi mo hinehina"),
            keywords: &["hinehina", "tapafā", "tapafā siʻisiʻi mo hinehina"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("küçük beyaz kare"),
            keywords: &["geometri", "kare", "küçük beyaz kare"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئاق كىچىك كىۋادرات"),
            keywords: &["ئاق كىچىك كىۋادرات", "كىۋادرات", "گېئومېتىرىيە"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("малий білий квадрат"),
            keywords: &["геометричний", "квадрат", "малий білий квадрат"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("سفید چھوٹا چوکور"),
            keywords: &["جیومیٹری", "سفید", "چوکور", "چھوٹا"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("kichik oq kvadrat"),
            keywords: &["geometrik", "kichik oq kvadrat", "kvadrat"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("hình vuông nhỏ màu trắng"),
            keywords: &["hình học", "hình vuông", "hình vuông nhỏ màu trắng"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("kaare bu ndaw te weex"),
            keywords: &["bu-geometri", "kaare", "kaare bu ndaw te weex"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("iskwere esincinane esimhlophe"),
            keywords: &["ijiyometriki", "iskwere", "iskwere esincinane esimhlophe"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("kékeré onígun mẹ\u{301}rin funfun"),
            keywords: &[
                "ilà onigun mé\u{329}rin",
                "jiomé\u{329}tíríkì",
                "kékeré onígun mẹ\u{301}rin funfun",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("細白色正方形"),
            keywords: &["幾何", "正方形", "細白色正方形"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("细白色正方形"),
            keywords: &["几何", "正方形", "细白色正方形"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("白色小方块"),
            keywords: &["小", "正方形", "白色", "白色小方块"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("白色小方塊"),
            keywords: &["方形", "白色小方塊"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("白色細正方形"),
            keywords: &["小白色正方形", "正方形", "白色小正方形", "白色細正方形"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("isikwele esimhlophe esincane"),
            keywords: &["isikwele esimhlophe esincane", "iskwele", "jiyometrikhi"],
        },
    ],
};
#[doc = "🔶"]
pub const LARGE_ORANGE_DIAMOND: crate::Emoji = crate::Emoji {
    glyph: "🔶",
    codepoint: "1F536",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "large orange diamond",
    group: "Symbols",
    subgroup: "geometric",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("groot oranje diamant"),
            keywords: &["diamant", "geometries", "groot oranje diamant", "oranje"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ትልቅ ብርትኳናማ አልማዝ"),
            keywords: &["ብርትኳናማ", "ትልቅ ብርትኳናማ አልማዝ", "አልማዝ", "ጂኦሜትሪያዊ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("ماسة برتقالي كبيرة"),
            keywords: &[
                "برتقالي",
                "ماسة",
                "ماسة برتقالي كبيرة",
                "ماسة برتقالية كبيرة",
            ],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ড\u{9be}ঙৰ কমল\u{9be}ৰঙী হীৰ\u{9be}"),
            keywords: &[
                "কমল\u{9be}ৰঙী",
                "জ\u{9cd}য\u{9be}মিতিক",
                "ড\u{9be}ঙৰ কমল\u{9be}ৰঙী হীৰ\u{9be}",
                "হীৰ\u{9be}",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("böyük narıncı romb"),
            keywords: &["brilyant", "böyük narıncı romb", "həndəsi", "narıncı"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("вялікі аранжавы ромб"),
            keywords: &["аб’ект", "вялікі аранжавы ромб", "геаметрычны", "ромб"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Голям оранжев ромб"),
            keywords: &["Голям оранжев ромб", "геометричен", "оранжев", "ромб"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("কমল\u{9be} রঙের বড\u{9bc} হীরে"),
            keywords: &[
                "কমল\u{9be}",
                "কমল\u{9be} রঙের বড\u{9bc} হীরে",
                "জ\u{9cd}য\u{9be}মিতিক",
                "ড\u{9be}য\u{9bc}মন\u{9cd}ড",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("romb bras orañjez"),
            keywords: &["orañjez", "romb", "romb bras orañjez"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("veliki narandžasti romb"),
            keywords: &[
                "geometrija",
                "narandžasto",
                "romb",
                "veliki narandžasti romb",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("rombe gran taronja"),
            keywords: &["geometria", "gran", "rombe", "taronja"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᏔᎾ ᎣᏂᏥ ᎦᎸᏉᏗ ᏅᏯ"),
            keywords: &["ᎣᏂᏥ", "ᎤᏔᎾ ᎣᏂᏥ ᎦᎸᏉᏗ ᏅᏯ", "ᎤᏙᏢᏒᎢ", "ᎦᎸᏉᏗ ᏅᏯ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("velký oranžový kosočtverec"),
            keywords: &[
                "geometrie",
                "kosočtverec",
                "oranžová",
                "velký oranžový kosočtverec",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("diemwnt mawr oren"),
            keywords: &["diemwnt", "diemwnt mawr oren", "geometrig", "oren"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("stor orange ruder"),
            keywords: &["geometrisk", "orange", "ruder", "stor orange ruder"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("große orangefarbene Raute"),
            keywords: &["Raute", "große orangefarbene Raute", "orangefarben"],
        },
        #[cfg(feature = "de_CH")]
        crate::Annotation {
            lang: "de_CH",
            tts: Some("Grosse orangefarbene Raute"),
            keywords: &["Grosse orangefarbene Raute", "Raute", "orangefarben"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("μεγάλος πορτοκαλί ρόμβος"),
            keywords: &[
                "γεωμετρικό",
                "διαμάντι",
                "μεγάλος πορτοκαλί ρόμβος",
                "πορτοκαλί",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("large orange diamond"),
            keywords: &["diamond", "geometric", "large orange diamond", "orange"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("rombo naranja grande"),
            keywords: &["geometría", "naranja", "rombo", "rombo naranja grande"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("diamante naranja grande"),
            keywords: &[
                "anaranjado",
                "diamante",
                "diamante naranja grande",
                "naranja",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("rombo anaranjado grande"),
            keywords: &[
                "anaranjado",
                "diamante",
                "geométrico",
                "naranja",
                "rombo",
                "rombo anaranjado grande",
            ],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("suur oranž romb"),
            keywords: &["geomeetria", "oranž", "romb", "suur oranž romb", "teemant"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("diamante laranja handia"),
            keywords: &[
                "diamante",
                "diamante laranja handia",
                "geometriko",
                "laranja",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("لوزی نارنجی بزرگ"),
            keywords: &["شکل هندسی", "لوزی", "لوزی نارنجی بزرگ", "نارنجی"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("iso oranssi vinoneliö"),
            keywords: &["iso oranssi vinoneliö", "muoto", "oranssi", "vinoneliö"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("malaking orange na diamond"),
            keywords: &[
                "diamante",
                "hugis",
                "malaki",
                "malaking orange na diamond",
                "orange",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("stórur appilsingulur diamantur"),
            keywords: &[
                "diamantur",
                "mátingarfrøðiligur",
                "stórur appilsingulur diamantur",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("grand losange orange"),
            keywords: &["forme géométrique", "grand losange orange", "losange"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &[
                "grand losange",
                "grand losange orange",
                "géométrie",
                "orange",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("muileata mór flannbhuí"),
            keywords: &["muileata mór flannbhuí", "oráiste"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("daoimean mòr orains"),
            keywords: &[
                "daoimean",
                "daoimean mòr orains",
                "geomatrach",
                "orainds",
                "orains",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("rombo grande laranxa"),
            keywords: &["grande", "laranxa", "rombo"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("મોટો નાર\u{a82}ગી હીરો"),
            keywords: &[
                "નાર\u{a82}ગી",
                "મોટો નાર\u{a82}ગી હીરો",
                "મોટો હીરો",
                "હીરો",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("babban daimun na ruwan goro"),
            keywords: &[
                "babban daimun na ruwan goro",
                "daimun",
                "ilimin halayen sura",
                "ruwan goro",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("מעוין כתום גדול"),
            keywords: &["כתום", "מעוין", "מעוין כתום גדול", "צורה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("बड\u{93c}ा नार\u{902}गी हीरा"),
            keywords: &[
                "नार\u{902}गी",
                "बड\u{93c}ा नार\u{902}गी हीरा",
                "बड\u{93c}ा हीरा",
                "हीरा",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("veliki narančasti romb"),
            keywords: &["geometrija", "narančasto", "romb", "veliki narančasti romb"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("nagy narancssárga rombusz"),
            keywords: &[
                "geometria",
                "nagy narancssárga rombusz",
                "narancs",
                "rombusz",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("նարնջագույն մեծ շեղանկյուն"),
            keywords: &[
                "երկրաչափական",
                "նարնջագույն",
                "նարնջագույն մեծ շեղանկյուն",
                "շեղանկյուն",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("wajik oranye besar"),
            keywords: &["geometri", "oranye", "wajik", "wajik oranye besar"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("nnukwu orenji diamond"),
            keywords: &["diamond", "mgbakọ", "nnukwu orenji diamond", "orenji"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("stór appelsínugulur tígull"),
            keywords: &["appelsínugulur", "stór appelsínugulur tígull", "tígull"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("rombo arancione grande"),
            keywords: &["arancione", "grande", "rombo"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("大きいオレンジのひし形"),
            keywords: &[
                "ひし形",
                "オレンジ",
                "ダイア",
                "ダイヤ",
                "四角",
                "大きいオレンジのひし形",
            ],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("kupatan gedhe kunir"),
            keywords: &["geometrik", "kunir", "kupatan", "kupatan gedhe kunir"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("დიდი სტაფილოსფერი რომბი"),
            keywords: &[
                "გეომეტრია",
                "გეომეტრიული",
                "დიდი სტაფილოსფერი რომბი",
                "ნარინჯისფერი",
                "რომბი",
                "სტაფილოსფერი",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("үлкен сарғыш ромб"),
            keywords: &["геометриялық", "ромб", "сарғыш", "үлкен сарғыш ромб"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("stor orange diamant"),
            keywords: &["diamant", "geometrisk", "orange", "stor orange diamant"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ពេជ\u{17d2}រធ\u{17c6}ពណ\u{17cc}ទ\u{17b9}កក\u{17d2}រ\u{17bc}ច"),
            keywords: &[
                "ទ\u{17b9}កក\u{17d2}រ\u{17bc}ច",
                "ធ\u{17c6}",
                "ពេជ\u{17d2}រ",
                "ពេជ\u{17d2}រធ\u{17c6}ពណ\u{17cc}ទ\u{17b9}កក\u{17d2}រ\u{17bc}ច",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ದೊಡ\u{ccd}ಡ ಕ\u{cbf}ತ\u{ccd}ತಳ\u{cc6} ವಜ\u{ccd}ರ"),
            keywords: &[
                "ದೊಡ\u{ccd}ಡ ಕ\u{cbf}ತ\u{ccd}ತಳ\u{cc6} ವಜ\u{ccd}ರ",
                "ದೊಡ\u{ccd}ಡ ವಜ\u{ccd}ರ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("큰 주황색 마름모"),
            keywords: &["마름모", "오렌지색", "주황색", "큰 주황색 마름모"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("व\u{94d}हड नार\u{902}गी हिरो"),
            keywords: &[
                "जियोम\u{945}ट\u{94d}रीक",
                "नार\u{902}गी",
                "व\u{94d}हड नार\u{902}गी हिरो",
                "हिरो",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("чоң саргыч ромб"),
            keywords: &["геометрия", "ромб", "саргыч", "чоң саргыч ромб"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("grouss orange Raut"),
            keywords: &["Raut", "geometresch", "grouss orange Raut", "orange"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຮ\u{eb9}ບເພ\u{eb1}ດສ\u{eb5}ໝາກກ\u{ec9}ຽງໃຫຍ\u{ec8}"),
            keywords: &[
                "ສ\u{eb5}ໝາກກ\u{ec9}ຽງ",
                "ຮ\u{eb9}ບເພ\u{eb1}ດສ\u{eb5}ໝາກກ\u{ec9}ຽງໃຫຍ\u{ec8}",
                "ເພ\u{eb1}ດ",
                "ເລຂາຄະນ\u{eb4}ດ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("didelis oranžinis deimantas"),
            keywords: &[
                "deimantas",
                "didelis oranžinis deimantas",
                "geometrija",
                "oranžinis",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("liels oranžs rombs"),
            keywords: &["liels oranžs rombs", "rombs", "ģeometrija"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("taimana karaka rahi"),
            keywords: &["karaka", "taimana", "taimana karaka rahi", "āhuahanga"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("голем портокалов дијамант"),
            keywords: &["геометрија", "голем", "дијамант", "портокалов"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("വലിയ ഓറഞ\u{d4d}ച\u{d4d} ഡയമണ\u{d4d}ട\u{d4d}"),
            keywords: &["വജ\u{d4d}രം", "വലിയ ഓറഞ\u{d4d}ച\u{d4d} ഡയമണ\u{d4d}ട\u{d4d}"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("том улбар шар алмааз"),
            keywords: &["алмааз", "геометр", "том улбар шар алмааз", "улбар шар"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("मोठा नार\u{902}गी र\u{902}गाचा डायम\u{902}ड"),
            keywords: &[
                "डायम\u{902}ड",
                "नार\u{902}गी",
                "भ\u{942}मितीय",
                "मोठा नार\u{902}गी र\u{902}गाचा डायम\u{902}ड",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("berlian jingga besar"),
            keywords: &["berlian", "berlian jingga besar", "geometri", "oren"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("djamant kbir oranġjo"),
            keywords: &["djamant kbir oranġjo", "djamanti", "oranġjo", "ġeometrika"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("လ\u{102d}မ\u{1039}မော\u{103a}ရောင\u{103a} စ\u{102d}န\u{103a}ကြ\u{102e}း"),
            keywords: &[
                "ဂျ\u{102e}ဩမေတြ\u{102e}",
                "စ\u{102d}န\u{103a}",
                "လ\u{102d}မ\u{1039}မော\u{103a}",
                "လ\u{102d}မ\u{1039}မော\u{103a}ရောင\u{103a} စ\u{102d}န\u{103a}ကြ\u{102e}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("stort oransje rutersymbol"),
            keywords: &[
                "geometrisk",
                "oransje",
                "ruter",
                "stort oransje rutersymbol",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("ठ\u{942}लो स\u{941}न\u{94d}तला हिरा"),
            keywords: &[
                "ज\u{94d}यामितीय",
                "ठ\u{942}लो स\u{941}न\u{94d}तला हिरा",
                "स\u{941}न\u{94d}तला",
                "हिरा",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("grote oranje ruit"),
            keywords: &["geometrisch", "grote oranje ruit", "oranje", "ruit"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("stort oransje rutersymbol"),
            keywords: &[
                "geometrisk",
                "oransje",
                "ruter",
                "stort oransje rutersymbol",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ବ\u{b43}ହତ\u{b4d}\u{200c} କମଳ\u{b3e} ରଙ\u{b4d}ଗର ହୀର\u{b3e}"),
            keywords: &[
                "କମଳ\u{b3e}",
                "ଜ\u{b4d}ୟ\u{b3e}ମ\u{b3f}ତ\u{b3f}କ",
                "ବ\u{b43}ହତ\u{b4d}\u{200c} କମଳ\u{b3e} ରଙ\u{b4d}ଗର ହୀର\u{b3e}",
                "ହୀର\u{b3e}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਵ\u{a71}ਡਾ ਸ\u{a70}ਤਰੀ ਹੀਰਾ"),
            keywords: &[
                "ਜਯਾਮਿਤੀ",
                "ਵ\u{a71}ਡਾ ਸ\u{a70}ਤਰੀ ਹੀਰਾ",
                "ਵ\u{a71}ਡਾ ਹੀਰਾ",
                "ਸ\u{a70}ਤਰੀ",
                "ਹੀਰਾ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("وڈھا نارنگی ہیرا"),
            keywords: &["جیومیٹری دے متعلق", "مالٹا", "وڈھا نارنگی ہیرا", "پیرا"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Bíg Ọ\u{301}rénj Kọ\u{301}lọ\u{301} Dáyámọnd"),
            keywords: &[
                "Bíg Ọ\u{301}rénj Kọ\u{301}lọ\u{301} Dáyámọnd",
                "Dáyámọnd",
                "Jiọ\u{301}mẹ\u{301}tri",
                "Ọ\u{301}rénj Kọ\u{301}lọ",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("duży pomarańczowy romb"),
            keywords: &[
                "duży",
                "figura geometryczna",
                "kształt",
                "pomarańczowy",
                "romb",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("لوی نارنجي الماس"),
            keywords: &["الماس", "جيوميتريکي", "لوی نارنجي الماس", "نارنجي"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("losango laranja grande"),
            keywords: &["geométrico", "laranja", "losango", "losango laranja grande"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("losango cor de laranja grande"),
            keywords: &[
                "cor de laranja",
                "geométrico",
                "losango",
                "losango cor de laranja grande",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("romb portocaliu mare"),
            keywords: &["geometric", "portocaliu", "romb", "romb portocaliu mare"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-754"),
            keywords: &["E10-754"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("большой оранжевый ромб"),
            keywords: &[
                "большой оранжевый ромб",
                "большой ромб",
                "геометрия",
                "оранжевый",
                "ромб",
                "фигура",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ikaro nini ya oranje"),
            keywords: &["ikaro", "ikaro nini ya oranje", "jewometiri", "oranje"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("وڏو نارنگي هيرو"),
            keywords: &["جيوميٽرڪ", "نارنگي", "هيرو", "وڏو نارنگي هيرو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ව\u{dd2}ශ\u{dcf}ල තැඹ\u{dd2}ල\u{dd2} ද\u{dd2}යමන\u{dca}ත\u{dd2}ය"),
            keywords: &[
                "ජ\u{dca}\u{200d}ය\u{dcf}ම\u{dd2}ත\u{dd2}ක",
                "තැඹ\u{dd2}ල\u{dd2}",
                "ද\u{dd2}යමන\u{dca}ත\u{dd2}ය",
                "ව\u{dd2}ශ\u{dcf}ල තැඹ\u{dd2}ල\u{dd2} ද\u{dd2}යමන\u{dca}ත\u{dd2}ය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("veľký oranžový kosoštvorec"),
            keywords: &[
                "diamant",
                "geometria",
                "oranžový",
                "veľký oranžový kosoštvorec",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("velik oranžen karo"),
            keywords: &["geometrično", "karo", "oranžno", "velik oranžen karo"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("dheeman weyn oo oranji ah"),
            keywords: &[
                "dheeman",
                "dheeman weyn oo oranji ah",
                "joometriyeed",
                "oranji",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("diamant i madh portokalli"),
            keywords: &[
                "diamant",
                "diamant i madh portokalli",
                "gjeometrik",
                "portokalli",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("велики наранџасти ромб"),
            keywords: &["велики наранџасти ромб", "гeoмeтриja", "наранџaстo", "рoмб"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("veliki narandžasti romb"),
            keywords: &[
                "geometrija",
                "narandžasto",
                "romb",
                "veliki narandžasti romb",
            ],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("stor orange diamantform"),
            keywords: &["diamant", "orange", "stor orange diamantform"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("almasi kubwa ya njano"),
            keywords: &["almasi", "almasi kubwa ya njano", "jiometri", "manjano"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பெரிய ஆரஞ\u{bcd}சு வைரம\u{bcd}"),
            keywords: &[
                "ஆரஞ\u{bcd}சு",
                "டைமண\u{bcd}ட\u{bcd}",
                "பெரிய ஆரஞ\u{bcd}சு வைரம\u{bcd}",
                "பெரிய வைரம\u{bcd}",
                "வைரம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ప\u{c46}ద\u{c4d}ద క\u{c3e}ష\u{c3e}య రంగు చతుర\u{c4d}భుజ\u{c3e}క\u{c3e}రం"),
            keywords: &[
                "క\u{c3e}ష\u{c3e}య రంగు",
                "చతుర\u{c4d}భుజ\u{c3e}క\u{c3e}రం",
                "డ\u{c48}మండ\u{c4d}",
                "ప\u{c46}ద\u{c4d}ద క\u{c3e}ష\u{c3e}య రంగు చతుర\u{c4d}భుజ\u{c3e}క\u{c3e}రం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("алмоси калони норинҷӣ"),
            keywords: &["алмос", "алмоси калони норинҷӣ", "геометрӣ", "норанҷӣ"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เพชรใหญ\u{e48}ส\u{e35}ส\u{e49}ม"),
            keywords: &[
                "ส\u{e35}\u{e48}เหล\u{e35}\u{e48}ยม",
                "เพชรใหญ\u{e48}ส\u{e35}ส\u{e49}ม",
                "เรขาคณ\u{e34}ต",
            ],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ዓቢ ኣራንሾኒ ኣልማዝ"),
            keywords: &["ኣልማዝ", "ኣራንሾኒ", "ዓቢ ኣራንሾኒ ኣልማዝ", "ጂኦሜትሪክ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("uly mämişi pişme"),
            keywords: &["almaz", "geometrik", "mämişi", "uly mämişi pişme"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("taiamoni lahi mo lanumoli"),
            keywords: &["lanumoli", "taiamoni", "taiamoni lahi mo lanumoli"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("büyük turuncu karo"),
            keywords: &["büyük turuncu karo", "karo", "turuncu"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("چوڭ قىزغۇچ رومبا"),
            keywords: &["رومبا", "قىزغۇچ", "چوڭ قىزغۇچ رومبا", "گېئومېتىرىيە"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("великий оранжевий ромб"),
            keywords: &[
                "великий",
                "великий оранжевий ромб",
                "великий помаранчевий ромб",
                "геометричний",
                "діамант",
                "оранжевий",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("بڑا نارنجی ہیرا"),
            keywords: &["بڑا نارنجی ہیرا", "جیومیٹری", "نارنجی", "ہیرا"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("katta to‘q sariq romb"),
            keywords: &["geometrik", "katta to‘q sariq romb", "romb", "to‘q sariq"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("hình thoi lớn màu cam"),
            keywords: &["hình học", "hình thoi", "hình thoi lớn màu cam", "màu cam"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("karo rëy oraas"),
            keywords: &["karo", "karo rëy oraas", "oraas", "wu-geometri"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("idayimani eorenji enkulu"),
            keywords: &[
                "idayimani",
                "idayimani eorenji enkulu",
                "ijiyometriki",
                "iorenji",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("diamọndi alawọ oronbo nla"),
            keywords: &[
                "diamọndi alawọ oronbo nla",
                "díámọ\u{301}ndì",
                "jiomẹ\u{301}tíríkì",
                "òronbó",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("大橙色菱形"),
            keywords: &["大橙色菱形", "幾何", "橙色", "菱形"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("大橙色菱形"),
            keywords: &["几何", "大橙色菱形", "橙色", "菱形"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("橙色大菱形"),
            keywords: &["大", "方片", "橘黄色", "橙色大菱形"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("大橙色菱形"),
            keywords: &["大橙色菱形", "菱形"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("橙色大菱形"),
            keywords: &["橙色大菱形", "菱形"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("idayimande elukhulu eliphuzu"),
            keywords: &[
                "idayimande",
                "idayimande elukhulu eliphuzu",
                "jiyometrikhi",
                "phuzi",
            ],
        },
    ],
};
#[doc = "🔷"]
pub const LARGE_BLUE_DIAMOND: crate::Emoji = crate::Emoji {
    glyph: "🔷",
    codepoint: "1F537",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "large blue diamond",
    group: "Symbols",
    subgroup: "geometric",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("groot blou diamant"),
            keywords: &["blou", "diamant", "geometries", "groot blou diamant"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ትልቅ ሰማያዊ አልማዝ"),
            keywords: &["ሰማያዊ", "ትልቅ ሰማያዊ አልማዝ", "አልማዝ", "ጂኦሜትሪያዊ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("ماسة زرقاء كبيرة"),
            keywords: &["أزرق", "ماسة", "ماسة زرقاء كبيرة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ড\u{9be}ঙৰ নীল\u{9be} হীৰ\u{9be}"),
            keywords: &[
                "জ\u{9cd}য\u{9be}মিতিক",
                "ড\u{9be}ঙৰ নীল\u{9be} হীৰ\u{9be}",
                "নীল\u{9be}",
                "হীৰ\u{9be}",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("böyük mavi romb"),
            keywords: &["böyük mavi romb", "həndəsi", "mavi", "romb"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("вялікі сіні ромб"),
            keywords: &["аб’ект", "вялікі сіні ромб", "геаметрычны", "ромб", "сіні"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Голям син ромб"),
            keywords: &["Голям син ромб", "геометричен", "ромб", "син"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("নীল রঙের বড\u{9bc} হীরে"),
            keywords: &[
                "জ\u{9cd}য\u{9be}মিতিক",
                "ড\u{9be}য\u{9bc}মন\u{9cd}ড",
                "নীল",
                "নীল রঙের বড\u{9bc} হীরে",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("romb bras glas"),
            keywords: &["glas", "romb", "romb bras glas"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("veliki plavi romb"),
            keywords: &["geometrija", "plava", "romb", "veliki plavi romb"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("rombe gran blau"),
            keywords: &["blau", "geometria", "gran", "rombe"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᏔᎾ ᏌᎪᏂ ᎦᎸᏉᏗ ᏅᏯ"),
            keywords: &["ᎤᏔᎾ ᏌᎪᏂ ᎦᎸᏉᏗ ᏅᏯ", "ᎤᏙᏢᏒ", "ᎦᎸᏉᏗ ᏅᏯ", "ᏌᎪᏂᎨ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("velký modrý kosočtverec"),
            keywords: &[
                "geometrie",
                "kosočtverec",
                "modrá",
                "velký modrý kosočtverec",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("diemwnt mawr glas"),
            keywords: &["diemwnt", "diemwnt mawr glas", "geometrig", "glas"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("stor blå ruder"),
            keywords: &["blå", "geometrisk", "ruder", "stor blå ruder"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("große blaue Raute"),
            keywords: &["Raute", "blau", "große blaue Raute"],
        },
        #[cfg(feature = "de_CH")]
        crate::Annotation {
            lang: "de_CH",
            tts: Some("Grosse blaue Raute"),
            keywords: &["Grosse blaue Raute", "Raute", "blau"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("μεγάλος μπλε ρόμβος"),
            keywords: &["γεωμετρικό", "διαμάντι", "μεγάλος μπλε ρόμβος", "μπλε"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("large blue diamond"),
            keywords: &["blue", "diamond", "geometric", "large blue diamond"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("rombo azul grande"),
            keywords: &["azul", "geometría", "rombo", "rombo azul grande"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("diamante azul grande"),
            keywords: &["azul", "diamante", "diamante azul grande"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("rombo azul grande"),
            keywords: &[
                "azul",
                "diamante",
                "geométrico",
                "rombo",
                "rombo azul grande",
            ],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("suur sinine romb"),
            keywords: &[
                "geomeetria",
                "romb",
                "sinine",
                "suur sinine romb",
                "teemant",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("diamante urdin handia"),
            keywords: &["diamante", "diamante urdin handia", "geometriko", "urdin"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("لوزی آبی بزرگ"),
            keywords: &["آبی", "شکل هندسی", "لوزی", "لوزی آبی بزرگ"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("iso sininen vinoneliö"),
            keywords: &["iso sininen vinoneliö", "muoto", "sininen", "vinoneliö"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("malaking asul na diamond"),
            keywords: &[
                "asul",
                "diamante",
                "hugis",
                "malaki",
                "malaking asul na diamond",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("stórur bláur diamantur"),
            keywords: &["diamantur", "mátingarfrøðiligur", "stórur bláur diamantur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("grand losange bleu"),
            keywords: &[
                "forme géométrique",
                "grand losange bleu",
                "grand losange orange",
                "losange",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &[
                "bleu",
                "grand losange",
                "grand losange bleu",
                "géométrie",
                "losange",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("muileata mór gorm"),
            keywords: &["muileata mór gorm"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("daoimean mòr gorm"),
            keywords: &["daoimean", "daoimean mòr gorm", "geomatrach", "gorm"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("rombo grande azul"),
            keywords: &["azul", "grande", "rombo"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("મોટો વાદળી હીરો"),
            keywords: &["મોટો વાદળી હીરો", "મોટો હીરો", "વાદળી", "હીરો"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("babban daimun na shuɗi"),
            keywords: &[
                "babban daimun na shuɗi",
                "daimun",
                "ilimin halayen sura",
                "shuɗi",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("מעוין כחול גדול"),
            keywords: &["כחול", "מעוין", "מעוין כחול גדול", "צורה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("बड\u{93c}ा नीला हीरा"),
            keywords: &["नीला", "बड\u{93c}ा नीला हीरा", "बड\u{93c}ा हीरा", "हीरा"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("veliki plavi romb"),
            keywords: &["geometrija", "plavo", "romb", "veliki plavi romb"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("nagy kék rombusz"),
            keywords: &["geometria", "kék", "nagy kék rombusz", "rombusz"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("կապույտ մեծ շեղանկյուն"),
            keywords: &[
                "երկրաչափական",
                "կապույտ",
                "կապույտ մեծ շեղանկյուն",
                "շեղանկյուն",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("wajik biru besar"),
            keywords: &["biru", "geometri", "wajik", "wajik biru besar"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("nnukwu anụnụ diamond"),
            keywords: &["anụnụ", "diamond", "mgbakọ", "nnukwu anụnụ diamond"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("stór blár tígull"),
            keywords: &["blár", "stór blár tígull", "tígull"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("rombo blu grande"),
            keywords: &["blu", "grande", "rombo"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("大きい青のひし形"),
            keywords: &[
                "ひし形",
                "ダイア",
                "ダイヤ",
                "四角",
                "大きい青のひし形",
                "青",
            ],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("kupatan gedhe biru"),
            keywords: &["biru", "geometrik", "kupatan", "kupatan gedhe biru"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("დიდი ლურჯი რომბი"),
            keywords: &[
                "გეომეტრია",
                "გეომეტრიული",
                "დიდი ლურჯი რომბი",
                "ლურჯი",
                "რომბი",
                "ცისფერი",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("үлкен көк ромб"),
            keywords: &["геометриялық", "көк", "ромб", "үлкен көк ромб"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("stor blå diamant"),
            keywords: &["blå", "diamant", "geometrisk", "stor blå diamant"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ពេជ\u{17d2}រធ\u{17c6}ពណ\u{17cc}ខៀវ"),
            keywords: &[
                "ខៀវ",
                "ពេជ\u{17d2}រ",
                "ពេជ\u{17d2}រធ\u{17c6}ពណ\u{17cc}ខៀវ",
                "\u{200b} ធ\u{17c6}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ದೊಡ\u{ccd}ಡ ನೀಲ\u{cbf} ವಜ\u{ccd}ರ"),
            keywords: &[
                "ದೊಡ\u{ccd}ಡ ನೀಲ\u{cbf} ವಜ\u{ccd}ರ",
                "ದೊಡ\u{ccd}ಡ ವಜ\u{ccd}ರ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("큰 파란색 마름모"),
            keywords: &["마름모", "큰 파란색 마름모", "파란색", "파랑"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("व\u{94d}हड निळो हिरो"),
            keywords: &[
                "जियोम\u{945}ट\u{94d}रीक",
                "निळो",
                "व\u{94d}हड निळो हिरो",
                "हिरो",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("чоң көк ромб"),
            keywords: &["геометрия", "көк", "ромб", "чоң көк ромб"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("grouss blo Raut"),
            keywords: &["Raut", "blo", "geometresch", "grouss blo Raut"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຮ\u{eb9}ບເພ\u{eb1}ດສ\u{eb5}ຟ\u{ec9}າໃຫຍ\u{ec8}"),
            keywords: &[
                "ສ\u{eb5}ຟ\u{ec9}າ",
                "ຮ\u{eb9}ບເພ\u{eb1}ດສ\u{eb5}ຟ\u{ec9}າໃຫຍ\u{ec8}",
                "ເພ\u{eb1}ດ",
                "ເລຂາຄະນ\u{eb4}ດ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("didelis mėlynas deimantas"),
            keywords: &[
                "deimantas",
                "didelis mėlynas deimantas",
                "geometrija",
                "mėlynas",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("liels zils rombs"),
            keywords: &["liels zils rombs", "rombs", "ģeometrija"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("taimana kikorangi rahi"),
            keywords: &[
                "kikorangi",
                "taimana",
                "taimana kikorangi rahi",
                "āhuahanga",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("голем син дијамант"),
            keywords: &["геометрија", "голем", "дијамант", "син"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("വലിയ നീല ഡയമണ\u{d4d}ട\u{d4d}"),
            keywords: &["വജ\u{d4d}രം", "വലിയ നീല ഡയമണ\u{d4d}ട\u{d4d}"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("том цэнхэр алмааз"),
            keywords: &["алмааз", "геометр", "том цэнхэр алмааз", "цэнхэр"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("मोठा निळ\u{94d}\u{200d}या र\u{902}गाचा डायम\u{902}ड"),
            keywords: &[
                "डायम\u{902}ड",
                "निळा",
                "भ\u{942}मितीय",
                "मोठा निळ\u{94d}\u{200d}या र\u{902}गाचा डायम\u{902}ड",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("berlian biru besar"),
            keywords: &["berlian", "berlian biru besar", "biru", "geometri"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("djamant kbir blu"),
            keywords: &["blu", "djamant kbir blu", "djamanti", "ġeometrika"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အပြာရောင\u{103a} စ\u{102d}န\u{103a}ကြ\u{102e}း"),
            keywords: &[
                "ဂျ\u{102e}ဩမေတြ\u{102e}",
                "စ\u{102d}န\u{103a}",
                "အပြာ",
                "အပြာရောင\u{103a} စ\u{102d}န\u{103a}ကြ\u{102e}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("stort blått rutersymbol"),
            keywords: &["blå", "geometrisk", "ruter", "stort blått rutersymbol"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("ठ\u{942}लो नीलो हिरा"),
            keywords: &["ज\u{94d}यामितीय", "ठ\u{942}लो नीलो हिरा", "नीलो", "हिरा"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("grote blauwe ruit"),
            keywords: &["blauw", "geometrisch", "grote blauwe ruit", "ruit"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("stort blått rutersymbol"),
            keywords: &["blå", "geometrisk", "ruter", "stort blått rutersymbol"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ବ\u{b43}ହତ\u{b4d} ନୀଳ ହୀର\u{b3e}"),
            keywords: &[
                "ଜ\u{b4d}ୟ\u{b3e}ମ\u{b3f}ତ\u{b3f}କ",
                "ନୀଳ",
                "ବ\u{b43}ହତ\u{b4d} ନୀଳ ହୀର\u{b3e}",
                "ହୀର\u{b3e}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਵ\u{a71}ਡਾ ਨੀਲਾ ਹੀਰਾ"),
            keywords: &[
                "ਜਯਾਮਿਤੀ",
                "ਨੀਲਾ",
                "ਵ\u{a71}ਡਾ ਨੀਲਾ ਹੀਰਾ",
                "ਵ\u{a71}ਡਾ ਹੀਰਾ",
                "ਹੀਰਾ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("وڈھا نیلا ہیرا"),
            keywords: &["جیومیٹری دے متعلق", "نیلا", "وڈھا نیلا ہیرا", "پیرا"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Bíg Blú Dáyámọnd"),
            keywords: &[
                "Blu",
                "Bíg Blú Dáyámọnd",
                "Dáyámọnd",
                "Jiọ\u{301}mẹ\u{301}tri",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("duży niebieski romb"),
            keywords: &[
                "duży",
                "figura geometryczna",
                "kształt",
                "niebieski",
                "romb",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("لوي آسماني رنګ الماس"),
            keywords: &["آسماني رنګ", "الماس", "جيوميتريکي", "لوي آسماني رنګ الماس"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("losango azul grande"),
            keywords: &["azul", "geométrico", "losango", "losango azul grande"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("losango azul grande"),
            keywords: &["azul", "geométrico", "losango", "losango azul grande"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("romb albastru mare"),
            keywords: &["albastru", "geometric", "romb", "romb albastru mare"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-755"),
            keywords: &["E10-755"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("большой голубой ромб"),
            keywords: &[
                "большой голубой ромб",
                "большой ромб",
                "геометрия",
                "голубой",
                "ромб",
                "фигура",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ikaro nini y’ubururu"),
            keywords: &["ikaro nini y’ubururu", "jewometiri", "karo", "ubururu"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("وڏو نيرو هيرو"),
            keywords: &["جيوميٽرڪ", "نيرو", "هيرو", "وڏو نيرو هيرو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ව\u{dd2}ශ\u{dcf}\u{dcf}ල න\u{dd2}ල\u{dca} ද\u{dd2}යමන\u{dca}ත\u{dd2}ය"),
            keywords: &[
                "ජ\u{dca}\u{200d}ය\u{dcf}ම\u{dd2}ත\u{dd2}ක",
                "ද\u{dd2}යමන\u{dca}ත\u{dd2}ය",
                "න\u{dd2}ල\u{dca}",
                "ව\u{dd2}ශ\u{dcf}\u{dcf}ල න\u{dd2}ල\u{dca} ද\u{dd2}යමන\u{dca}ත\u{dd2}ය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("veľký modrý kosoštvorec"),
            keywords: &["diamant", "geometria", "modrý", "veľký modrý kosoštvorec"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("velik moder karo"),
            keywords: &["geometrično", "karo", "modro", "velik moder karo"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("dheeman weyn oo buluug ah"),
            keywords: &[
                "buluug",
                "dheeman",
                "dheeman weyn oo buluug ah",
                "joometriyeed",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("diamant i madh blu"),
            keywords: &["blu", "diamant", "diamant i madh blu", "gjeometrik"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("велики плави ромб"),
            keywords: &["велики плави ромб", "гeoмeтриja", "плaвo", "рoмб"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("veliki plavi romb"),
            keywords: &["geometrija", "plavo", "romb", "veliki plavi romb"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("stor blå diamantform"),
            keywords: &["blå", "diamant", "stor blå diamantform"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("almasi kubwa ya samawati"),
            keywords: &["almasi", "almasi kubwa ya samawati", "jiometri", "samawati"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பெரிய ந\u{bc0}ல வைரம\u{bcd}"),
            keywords: &[
                "டைமண\u{bcd}ட\u{bcd}",
                "ந\u{bc0}லம\u{bcd}",
                "பெரிய ந\u{bc0}ல வைரம\u{bcd}",
                "பெரிய வைரம\u{bcd}",
                "வைரம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ప\u{c46}ద\u{c4d}ద న\u{c40}ల\u{c3f} రంగు చతుర\u{c4d}భుజ\u{c3e}క\u{c3e}రం"),
            keywords: &[
                "చతుర\u{c4d}భుజ\u{c3e}క\u{c3e}రం",
                "డ\u{c48}మండ\u{c4d}",
                "న\u{c40}ల\u{c3f} రంగు",
                "ప\u{c46}ద\u{c4d}ద న\u{c40}ల\u{c3f} రంగు చతుర\u{c4d}భుజ\u{c3e}క\u{c3e}రం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("алмоси калони кабуд"),
            keywords: &["алмос", "алмоси калони кабуд", "геометрӣ", "кабуд"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เพชรใหญ\u{e48}ส\u{e35}น\u{e49}ำเง\u{e34}น"),
            keywords: &[
                "ส\u{e35}\u{e48}เหล\u{e35}\u{e48}ยม",
                "เพชรใหญ\u{e48}ส\u{e35}น\u{e49}ำเง\u{e34}น",
                "เรขาคณ\u{e34}ต",
            ],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ዓቢ ሰማያዊ ኣልማዝ"),
            keywords: &["ሰማያዊ", "ኣልማዝ", "ዓቢ ሰማያዊ ኣልማዝ", "ጂኦሜትሪክ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("uly gök pişme"),
            keywords: &["almaz", "geometrik", "gök", "uly gök pişme"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("taiamoni lahi mo lanupulū"),
            keywords: &["lanupulū", "taiamoni", "taiamoni lahi mo lanupulū"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("büyük mavi karo"),
            keywords: &["büyük mavi karo", "karo", "mavi"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("چوڭ كۆك رومبا"),
            keywords: &["رومبا", "كۆك", "چوڭ كۆك رومبا", "گېئومېتىرىيە"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("великий синій ромб"),
            keywords: &["великий синій ромб", "геометричний", "діамант", "синій"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("بڑا نیلا ہیرا"),
            keywords: &["بڑا نیلا ہیرا", "جیومیٹری", "نیلا", "ہیرا"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("katta ko‘k romb"),
            keywords: &["geometrik", "katta ko‘k romb", "ko‘k", "romb"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("hình thoi lớn màu lam"),
            keywords: &["hình học", "hình thoi", "hình thoi lớn màu lam", "màu lam"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("karo rëy baxa"),
            keywords: &["baxa", "karo", "karo rëy baxa", "wu-geometri"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("idayimani ebhlowu enkulu"),
            keywords: &[
                "bhlowu",
                "idayimani",
                "idayimani ebhlowu enkulu",
                "ijiyometriki",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("diamọndi alawọ bulu nla"),
            keywords: &[
                "Búlù",
                "diamọndi alawọ bulu nla",
                "díámọ\u{301}ndì",
                "jiomẹ\u{301}tíríkì",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("大藍色菱形"),
            keywords: &["大藍色菱形", "幾何", "菱形", "藍色"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("大蓝色菱形"),
            keywords: &["几何", "大蓝色菱形", "菱形", "蓝色"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("蓝色大菱形"),
            keywords: &["大", "方片", "蓝色", "蓝色大菱形"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("大藍色菱形"),
            keywords: &["大藍色菱形", "菱形"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("藍色大菱形"),
            keywords: &["菱形", "藍色大菱形"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("idayimande elikhulu eliphuzu sasibhakabhaka"),
            keywords: &[
                "idayimande elikhulu eliphuzu sasibhakabhaka",
                "jiyometrikhi",
                "luhlaza sasibhakabhaka",
                "phuzi",
            ],
        },
    ],
};
#[doc = "🔸"]
pub const SMALL_ORANGE_DIAMOND: crate::Emoji = crate::Emoji {
    glyph: "🔸",
    codepoint: "1F538",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "small orange diamond",
    group: "Symbols",
    subgroup: "geometric",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("klein oranje diamant"),
            keywords: &["diamant", "geometries", "klein oranje diamant", "oranje"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ትንሽ ብርትኳናማ አልማዝ"),
            keywords: &["ብርትኳናማ", "ትንሽ ብርትኳናማ አልማዝ", "አልማዝ", "ጂኦሜትሪያዊ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("ماسة برتقالي صغيرة"),
            keywords: &[
                "برتقالي",
                "ماسة",
                "ماسة برتقالي صغيرة",
                "ماسة برتقالية صغيرة",
            ],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("সৰ\u{9c1} কমল\u{9be}ৰঙী হীৰ\u{9be}"),
            keywords: &[
                "কমল\u{9be}",
                "জ\u{9cd}য\u{9be}মিতিক",
                "সৰ\u{9c1} কমল\u{9be}ৰঙী হীৰ\u{9be}",
                "হীৰ\u{9be}",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("balaca narıncı romb"),
            keywords: &["balaca narıncı romb", "brilyant", "həndəsi", "narıncı"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("малы аранжавы ромб"),
            keywords: &["аб’ект", "геаметрычны", "малы аранжавы ромб", "ромб"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Малък оранжев ромб"),
            keywords: &["Малък оранжев ромб", "геометричен", "оранжев", "ромб"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("কমল\u{9be} রঙের ছোট হীরে"),
            keywords: &[
                "কমল\u{9be}",
                "কমল\u{9be} রঙের ছোট হীরে",
                "জ\u{9cd}য\u{9be}মিতিক",
                "ড\u{9be}য\u{9bc}মন\u{9cd}ড",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("romb bihan orañjez"),
            keywords: &["orañjez", "romb", "romb bihan orañjez"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("mali narandžasti romb"),
            keywords: &["geometrija", "mali narandžasti romb", "narandžasta", "romb"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("rombe petit taronja"),
            keywords: &["geometria", "petit", "rombe", "taronja"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᏍᏗ ᎠᏓᎶᏂᎨ ᎤᏣᏍᏓᎷᎩᏍᎩ ᏅᏯ"),
            keywords: &["ᎣᏂᏥ", "ᎤᏍᏗ ᎠᏓᎶᏂᎨ ᎤᏣᏍᏓᎷᎩᏍᎩ ᏅᏯ", "ᎤᏙᏢᏒᎢ", "ᎦᎸᏉᏗ ᏅᏯ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("malý oranžový kosočtverec"),
            keywords: &[
                "geometrie",
                "kosočtverec",
                "malý oranžový kosočtverec",
                "oranžová",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("diemwnt bach oren"),
            keywords: &["diemwnt", "diemwnt bach oren", "geometrig", "oren"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("lille orange ruder"),
            keywords: &["geometrisk", "lille orange ruder", "orange", "ruder"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("kleine orangefarbene Raute"),
            keywords: &["Raute", "kleine orangefarbene Raute", "orangefarben"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("μικρός πορτοκαλί ρόμβος"),
            keywords: &[
                "γεωμετρικό",
                "διαμάντι",
                "μικρός πορτοκαλί ρόμβος",
                "πορτοκαλί",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("small orange diamond"),
            keywords: &["diamond", "geometric", "orange", "small orange diamond"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("rombo naranja pequeño"),
            keywords: &["geometría", "naranja", "rombo", "rombo naranja pequeño"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("diamante naranja pequeño"),
            keywords: &[
                "anaranjado",
                "diamante",
                "diamante naranja pequeño",
                "naranja",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("rombo anaranjado pequeño"),
            keywords: &[
                "anaranjado",
                "diamante",
                "geométrico",
                "naranja",
                "rombo",
                "rombo anaranjado pequeño",
            ],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("väike oranž romb"),
            keywords: &["geomeetria", "oranž", "romb", "teemant", "väike oranž romb"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("diamante laranja txikia"),
            keywords: &[
                "diamante",
                "diamante laranja txikia",
                "geometriko",
                "laranja",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("لوزی نارنجی کوچک"),
            keywords: &["شکل هندسی", "لوزی", "لوزی نارنجی کوچک", "نارنجی"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("pieni oranssi vinoneliö"),
            keywords: &["muoto", "oranssi", "pieni oranssi vinoneliö", "vinoneliö"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("maliit na orange na diamond"),
            keywords: &[
                "diamante",
                "hugis",
                "maliit",
                "maliit na orange na diamond",
                "orange",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("lítil appilsingulur diamantur"),
            keywords: &[
                "diamantur",
                "lítil appilsingulur diamantur",
                "mátingarfrøðiligur",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("petit losange orange"),
            keywords: &["forme géométrique", "losange", "petit losange orange"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &[
                "géométrie",
                "losange",
                "orange",
                "petit losange",
                "petit losange orange",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("muileata beag flannbhuí"),
            keywords: &["muileata beag flannbhuí", "oráiste"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("daoimean beag orains"),
            keywords: &[
                "daoimean",
                "daoimean beag orains",
                "geomatrach",
                "orainds",
                "orains",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("rombo pequeno laranxa"),
            keywords: &["laranxa", "pequeno", "rombo"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("નાનો નાર\u{a82}ગી હીરો"),
            keywords: &[
                "નાનો નાર\u{a82}ગી હીરો",
                "નાનો હીરો",
                "નાર\u{a82}ગી",
                "હીરો",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("ƙaramin diamun na ruwan goro"),
            keywords: &[
                "daimun",
                "ilimin halayen sura",
                "ruwan goro",
                "ƙaramin diamun na ruwan goro",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("מעוין כתום קטן"),
            keywords: &["כתום", "מעוין", "מעוין כתום קטן", "צורה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("छोटा नार\u{902}गी हीरा"),
            keywords: &[
                "छोटा नार\u{902}गी हीरा",
                "छोटा हीरा",
                "नार\u{902}गी",
                "हीरा",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("mali narančasti romb"),
            keywords: &["geometrija", "mali narančasti romb", "narančasto", "romb"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("kis narancssárga rombusz"),
            keywords: &[
                "geometria",
                "kis narancssárga rombusz",
                "narancs",
                "rombusz",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("նարնջագույն փոքր շեղանկյուն"),
            keywords: &[
                "երկրաչափական",
                "նարնջագույն",
                "նարնջագույն փոքր շեղանկյուն",
                "շեղանկյուն",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("wajik oranye kecil"),
            keywords: &["geometri", "oranye", "wajik", "wajik oranye kecil"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("obere orenji diamond"),
            keywords: &["diamond", "mgbakọ", "obere orenji diamond", "orenji"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("lítill appelsínugulur tígull"),
            keywords: &["appelsínugulur", "lítill appelsínugulur tígull", "tígull"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("rombo arancione piccolo"),
            keywords: &["arancione", "piccolo", "rombo"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("小さいオレンジのひし形"),
            keywords: &[
                "ひし形",
                "オレンジ",
                "ダイア",
                "ダイヤ",
                "四角",
                "小さいオレンジのひし形",
            ],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("kupatan cilik kunir"),
            keywords: &["geometrik", "kunir", "kupatan", "kupatan cilik kunir"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("პატარა სტაფილოსფერი რომბი"),
            keywords: &[
                "გეომეტრია",
                "გეომეტრიული",
                "ნარინჯისფერი",
                "პატარა სტაფილოსფერი რომბი",
                "რომბი",
                "სტაფილოსფერი",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("кіші сарғыш ромб"),
            keywords: &["геометриялық", "кіші сарғыш ромб", "ромб", "сарғыш"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("lille orange diamant"),
            keywords: &["diamant", "geometrisk", "lille orange diamant", "orange"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ពេជ\u{17d2}រត\u{17bc}ចពណ\u{17cc}ទ\u{17b9}កក\u{17d2}រ\u{17bc}ច"),
            keywords: &[
                "ត\u{17bc}ច",
                "ទ\u{17b9}កក\u{17d2}រ\u{17bc}ច",
                "ពេជ\u{17d2}រ",
                "ពេជ\u{17d2}រត\u{17bc}ចពណ\u{17cc}ទ\u{17b9}កក\u{17d2}រ\u{17bc}ច",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಸಣ\u{ccd}ಣ ಕ\u{cbf}ತ\u{ccd}ತಳ\u{cc6} ವಜ\u{ccd}ರ"),
            keywords: &[
                "ಸಣ\u{ccd}ಣ ಕ\u{cbf}ತ\u{ccd}ತಳ\u{cc6} ವಜ\u{ccd}ರ",
                "ಸಣ\u{ccd}ಣ ವಜ\u{ccd}ರ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("작은 주황색 마름모"),
            keywords: &["마름모", "오렌지색", "작은 주황색 마름모", "주황색"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("ल\u{94d}हान नार\u{902}गी हिरो"),
            keywords: &[
                "जियोम\u{945}ट\u{94d}रीक",
                "नार\u{902}गी",
                "ल\u{94d}हान नार\u{902}गी हिरो",
                "हिरो",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("кичинекей саргыч ромб"),
            keywords: &["геометрия", "кичинекей саргыч ромб", "ромб", "саргыч"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("kleng orange Raut"),
            keywords: &["Raut", "geometresch", "kleng orange Raut", "orange"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຮ\u{eb9}ບເພ\u{eb1}ດສ\u{eb5}ໝາກກ\u{ec9}ຽງນ\u{ec9}ອຍ"),
            keywords: &[
                "ສ\u{eb5}ໝາກກ\u{ec9}ຽງ",
                "ຮ\u{eb9}ບເພ\u{eb1}ດສ\u{eb5}ໝາກກ\u{ec9}ຽງນ\u{ec9}ອຍ",
                "ເພ\u{eb1}ດ",
                "ເລຂາຄະນ\u{eb4}ດ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("mažas oranžinis deimantas"),
            keywords: &[
                "deimantas",
                "geometrija",
                "mažas oranžinis deimantas",
                "oranžinis",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("mazs oranžs rombs"),
            keywords: &["mazs oranžs rombs", "rombs", "ģeometrija"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("taimana karaka iti"),
            keywords: &["karaka", "taimana", "taimana karaka iti", "āhuahanga"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("мал портокалов дијамант"),
            keywords: &["геометрија", "дијамант", "мал", "портокалов"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ചെറിയ ഓറഞ\u{d4d}ച\u{d4d} ഡയമണ\u{d4d}ട\u{d4d}"),
            keywords: &[
                "ചെറിയ ഓറഞ\u{d4d}ച\u{d4d} ഡയമണ\u{d4d}ട\u{d4d}",
                "വജ\u{d4d}രം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("жижиг улбар шар алмааз"),
            keywords: &["алмааз", "геометр", "жижиг улбар шар алмааз", "улбар шар"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("लहान नार\u{902}गी र\u{902}गाचा डायम\u{902}ड"),
            keywords: &[
                "डायम\u{902}ड",
                "नार\u{902}गी",
                "भ\u{942}मितीय",
                "लहान नार\u{902}गी र\u{902}गाचा डायम\u{902}ड",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("berlian jingga kecil"),
            keywords: &["berlian", "berlian jingga kecil", "geometri", "oren"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("djamant żgħir oranġjo"),
            keywords: &["djamant żgħir oranġjo", "djamanti", "oranġjo", "ġeometrika"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("လ\u{102d}မ\u{1039}မော\u{103a}ရောင\u{103a} စ\u{102d}န\u{103a}အသေး"),
            keywords: &[
                "ဂျ\u{102e}ဩမေတြ\u{102e}",
                "စ\u{102d}န\u{103a}",
                "လ\u{102d}မ\u{1039}မော\u{103a}",
                "လ\u{102d}မ\u{1039}မော\u{103a}ရောင\u{103a} စ\u{102d}န\u{103a}အသေး",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("lite oransje rutersymbol"),
            keywords: &["geometrisk", "lite oransje rutersymbol", "oransje", "ruter"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("सानो स\u{941}न\u{94d}तला हिरा"),
            keywords: &[
                "ज\u{94d}यामितीय",
                "सानो स\u{941}न\u{94d}तला हिरा",
                "स\u{941}न\u{94d}तला",
                "हिरा",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("kleine oranje ruit"),
            keywords: &["geometrisch", "kleine oranje ruit", "oranje", "ruit"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("lite oransje rutersymbol"),
            keywords: &["geometrisk", "lite oransje rutersymbol", "oransje", "ruter"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଛୋଟ କମଳ\u{b3e} ରଙ\u{b4d}ଗର ହୀର\u{b3e}"),
            keywords: &[
                "କମଳ\u{b3e}",
                "ଛୋଟ କମଳ\u{b3e} ରଙ\u{b4d}ଗର ହୀର\u{b3e}",
                "ଜ\u{b4d}ୟ\u{b3e}ମ\u{b3f}ତ\u{b3f}କ",
                "ହୀର\u{b3e}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਛ\u{a4b}ਟਾ ਸ\u{a70}ਤਰੀ ਹੀਰਾ"),
            keywords: &[
                "ਛ\u{a47}\u{a4b}ਟਾ ਹੀਰਾ",
                "ਛ\u{a4b}ਟਾ ਸ\u{a70}ਤਰੀ ਹੀਰਾ",
                "ਜਯਾਮਿਤੀ",
                "ਸ\u{a70}ਤਰੀ",
                "ਹੀਰਾ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("نیکا نارنگی ہیرا"),
            keywords: &["جیومیٹری دے متعلق", "مالٹا", "نیکا نارنگی ہیرا", "پیرا"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Smọ\u{301}l Ọ\u{301}rénj Kọ\u{301}lọ\u{301} Dáyámọnd"),
            keywords: &[
                "Dáyámọnd",
                "Jiọ\u{301}mẹ\u{301}tri",
                "Smọ\u{301}l Ọ\u{301}rénj Kọ\u{301}lọ\u{301} Dáyámọnd",
                "Ọ\u{301}rénj Kọ\u{301}lọ",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("mały pomarańczowy romb"),
            keywords: &[
                "figura geometryczna",
                "kształt",
                "mały",
                "pomarańczowy",
                "romb",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("کوچنی نارنجي رنګ الماس"),
            keywords: &["الماس", "جيوميتريکي", "نارنجي", "کوچنی نارنجي رنګ الماس"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("losango laranja pequeno"),
            keywords: &[
                "geométrico",
                "laranja",
                "losango",
                "losango laranja pequeno",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("losango cor de laranja pequeno"),
            keywords: &[
                "cor de laranja",
                "geométrico",
                "losango",
                "losango cor de laranja pequeno",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("romb portocaliu mic"),
            keywords: &["geometric", "portocaliu", "romb", "romb portocaliu mic"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-756"),
            keywords: &["E10-756"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("небольшой оранжевый ромб"),
            keywords: &[
                "геометрия",
                "небольшой оранжевый ромб",
                "небольшой ромб",
                "оранжевый",
                "ромб",
                "фигура",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ikaro nto ya oranje"),
            keywords: &["ikaro", "ikaro nto ya oranje", "jewometiri", "oranje"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ننڍو نارنگي هيرو"),
            keywords: &["جيوميٽرڪ", "نارنگي", "ننڍو نارنگي هيرو", "هيرو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ක\u{dd4}ඩ\u{dcf} තැඹ\u{dd2}ල\u{dd2} ද\u{dd2}යමන\u{dca}ත\u{dd2}ය"),
            keywords: &[
                "ක\u{dd4}ඩ\u{dcf} තැඹ\u{dd2}ල\u{dd2} ද\u{dd2}යමන\u{dca}ත\u{dd2}ය",
                "ජ\u{dca}\u{200d}ය\u{dcf}ම\u{dd2}ත\u{dd2}ක",
                "තැඹ\u{dd2}ල\u{dd2}",
                "ද\u{dd2}යමන\u{dca}ත\u{dd2}ය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("malý oranžový kosoštvorec"),
            keywords: &[
                "diamant",
                "geometria",
                "malý oranžový kosoštvorec",
                "oranžový",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("majhen oranžen karo"),
            keywords: &["geometrično", "karo", "majhen oranžen karo", "oranžno"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("dheeman yar oo oranji ah"),
            keywords: &[
                "dheeman",
                "dheeman yar oo oranji ah",
                "joometriyeed",
                "oranji",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("diamant i vogël portokalli"),
            keywords: &[
                "diamant",
                "diamant i vogël portokalli",
                "gjeometrik",
                "portokalli",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("мали наранџасти ромб"),
            keywords: &["гeoмeтриja", "мали наранџасти ромб", "наранџaстo", "рoмб"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("mali narandžasti romb"),
            keywords: &["geometrija", "mali narandžasti romb", "narandžasto", "romb"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("liten orange diamantform"),
            keywords: &["diamant", "liten orange diamantform", "orange"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("almasi ndogo ya njano"),
            keywords: &["almasi", "almasi ndogo ya njano", "jiometri", "manjano"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("சிறிய ஆரஞ\u{bcd}சு வைரம\u{bcd}"),
            keywords: &[
                "ஆரஞ\u{bcd}சு",
                "சிறிய ஆரஞ\u{bcd}சு வைரம\u{bcd}",
                "சிறிய வைரம\u{bcd}",
                "டைமண\u{bcd}ட\u{bcd}",
                "வைரம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("చ\u{c3f}న\u{c4d}న క\u{c3e}ష\u{c3e}య రంగు చతుర\u{c4d}భుజ\u{c3e}క\u{c3e}రం"),
            keywords: &[
                "క\u{c3e}ష\u{c3e}య రంగు",
                "చతుర\u{c4d}భుజ\u{c3e}క\u{c3e}రం",
                "చ\u{c3f}న\u{c4d}న క\u{c3e}ష\u{c3e}య రంగు చతుర\u{c4d}భుజ\u{c3e}క\u{c3e}రం",
                "డ\u{c48}మండ\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("алмоси хурди норинҷӣ"),
            keywords: &["алмос", "алмоси хурди норинҷӣ", "геометрӣ", "норанҷӣ"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เพชรเล\u{e47}กส\u{e35}ส\u{e49}ม"),
            keywords: &[
                "ส\u{e35}ส\u{e49}ม",
                "เพชร",
                "เพชรเล\u{e47}กส\u{e35}ส\u{e49}ม",
                "เรขาคณ\u{e34}ต",
            ],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ንኢሽተይ ሰማያዊ ኣልማዝ"),
            keywords: &["ንኢሽተይ ሰማያዊ ኣልማዝ", "ኣልማዝ", "ኣራንሾኒ", "ጂኦሜትሪክ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("kiçi mämişi pişme"),
            keywords: &["almaz", "geometrik", "kiçi mämişi pişme", "mämişi"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("taiamoni siʻi mo lanumoli"),
            keywords: &["lanumoli", "taiamoni", "taiamoni siʻi mo lanumoli"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("küçük turuncu karo"),
            keywords: &["karo", "küçük turuncu karo", "turuncu"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("كىچىك قىزغۇچ رومبا"),
            keywords: &["رومبا", "قىزغۇچ", "كىچىك قىزغۇچ رومبا", "گېئومېتىرىيە"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("малий оранжевий ромб"),
            keywords: &[
                "геометричний",
                "діамант",
                "малий",
                "малий оранжевий ромб",
                "малий помаранчевий ромб",
                "оранжевий",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("چھوٹا نارنجی ہیرا"),
            keywords: &["جیومیٹری", "نارنجی", "چھوٹا نارنجی ہیرا", "ہیرا"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("kichik to‘q sariq romb"),
            keywords: &["geometrik", "kichik to‘q sariq romb", "romb", "to‘q sariq"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("hình thoi nhỏ màu cam"),
            keywords: &["hình học", "hình thoi", "hình thoi nhỏ màu cam", "màu cam"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("karo ndaw oraas"),
            keywords: &["karo", "karo ndaw oraas", "oraas", "wu-geometri"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("idayimani eorenji encinane"),
            keywords: &[
                "idayimani",
                "idayimani eorenji encinane",
                "ijiyometriki",
                "iorenji",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("diamọndi alawọ oronbo kekere"),
            keywords: &[
                "diamọndi alawọ oronbo kekere",
                "díámọ\u{301}ndì",
                "jiomẹ\u{301}tíríkì",
                "òronbó",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("細橙色菱形"),
            keywords: &["幾何", "橙色", "細橙色菱形", "菱形"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("细橙色菱形"),
            keywords: &["几何", "橙色", "细橙色菱形", "菱形"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("橙色小菱形"),
            keywords: &["小", "方片", "橘黄色", "橙色小菱形"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("小橙色菱形"),
            keywords: &["小橙色菱形", "菱形"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("橙色小菱形"),
            keywords: &["橙色小菱形", "菱形"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("idayimande eliphuzi elincane"),
            keywords: &[
                "idayimande",
                "idayimande eliphuzi elincane",
                "jiyometrikhi",
                "phuzi",
            ],
        },
    ],
};
#[doc = "🔹"]
pub const SMALL_BLUE_DIAMOND: crate::Emoji = crate::Emoji {
    glyph: "🔹",
    codepoint: "1F539",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "small blue diamond",
    group: "Symbols",
    subgroup: "geometric",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("klein blou diamant"),
            keywords: &["blou", "diamant", "geometries", "klein blou diamant"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ትንሽ ሰማያዊ አልማዝ"),
            keywords: &["ሰማያዊ", "ትንሽ ሰማያዊ አልማዝ", "አልማዝ", "ጂኦሜትሪያዊ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("ماسة زرقاء صغيرة"),
            keywords: &["أزرق", "ماسة", "ماسة زرقاء صغيرة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("সৰ\u{9c1} নীল\u{9be} হীৰ\u{9be}"),
            keywords: &[
                "জ\u{9cd}য\u{9be}মিতিক",
                "নীল\u{9be}",
                "সৰ\u{9c1} নীল\u{9be} হীৰ\u{9be}",
                "হীৰ\u{9be}",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("balaca mavi romb"),
            keywords: &["balaca mavi romb", "həndəsi", "mavi", "romb"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("малы сіні ромб"),
            keywords: &["аб’ект", "геаметрычны", "малы сіні ромб", "ромб"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Малък син ромб"),
            keywords: &["Малък син ромб", "геометричен", "ромб", "син"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("নীল রঙের ছোট হীরে"),
            keywords: &[
                "জ\u{9cd}য\u{9be}মিতিক",
                "ড\u{9be}য\u{9bc}মন\u{9cd}ড",
                "নীল",
                "নীল রঙের ছোট হীরে",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("romb bihan glas"),
            keywords: &["glas", "romb", "romb bihan glas"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("mali plavi romb"),
            keywords: &["geometrija", "mali plavi romb", "plava", "romb"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("rombe petit blau"),
            keywords: &["blau", "geometria", "petit", "rombe"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᏍᏗ ᏌᎪᏂᎨ ᎤᏣᏍᏓᎷᎩᏍᎩ ᏅᏯ"),
            keywords: &["ᎤᏍᏗ ᏌᎪᏂᎨ ᎤᏣᏍᏓᎷᎩᏍᎩ ᏅᏯ", "ᎤᏙᏢᏒ", "ᎦᎸᏉᏗ ᏅᏯ", "ᏌᎪᏂᎨ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("malý modrý kosočtverec"),
            keywords: &[
                "geometrie",
                "kosočtverec",
                "malý modrý kosočtverec",
                "modrá",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("diemwnt bach glas"),
            keywords: &["diemwnt", "diemwnt bach glas", "geometrig", "glas"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("lille blå ruder"),
            keywords: &["blå", "geometrisk", "lille blå ruder", "ruder"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("kleine blaue Raute"),
            keywords: &["Raute", "blau", "kleine blaue Raute"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("μικρός μπλε ρόμβος"),
            keywords: &["γεωμετρικό", "διαμάντι", "μικρός μπλε ρόμβος", "μπλε"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("small blue diamond"),
            keywords: &["blue", "diamond", "geometric", "small blue diamond"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("rombo azul pequeño"),
            keywords: &["azul", "geometría", "rombo", "rombo azul pequeño"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &[
                "azul",
                "diamante",
                "diamante azul pequeño",
                "rombo azul pequeño",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("diamante azul pequeño"),
            keywords: &[
                "cómic",
                "diamante",
                "diamante azul pequeño",
                "flor",
                "pétalo de flor",
                "rombo con pétalo",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("väike sinine romb"),
            keywords: &[
                "geomeetria",
                "romb",
                "sinine",
                "teemant",
                "väike sinine romb",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("diamante urdin txikia"),
            keywords: &["diamante", "diamante urdin txikia", "geometriko", "urdin"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("لوزی آبی کوچک"),
            keywords: &["آبی", "شکل هندسی", "لوزی", "لوزی آبی کوچک"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("pieni sininen vinoneliö"),
            keywords: &["muoto", "pieni sininen vinoneliö", "sininen", "vinoneliö"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("maliit na asul na diamond"),
            keywords: &[
                "asul",
                "diamante",
                "hugis",
                "maliit",
                "maliit na asul na diamond",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("lítil bláur diamantur"),
            keywords: &["diamantur", "lítil bláur diamantur", "mátingarfrøðiligur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("petit losange bleu"),
            keywords: &["forme géométrique", "losange", "petit losange bleu"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &[
                "bleu",
                "géométrie",
                "losange",
                "petit losange",
                "petit losange bleu",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("muileata beag gorm"),
            keywords: &["muileata beag gorm"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("daoimean beag gorm"),
            keywords: &["daoimean", "daoimean beag gorm", "geomatrach", "gorm"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("rombo pequeno azul"),
            keywords: &["azul", "pequeno", "rombo"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("નાનો વાદળી હીરો"),
            keywords: &["નાનો વાદળી હીરો", "નાનો હીરો", "વાદળી", "હીરો"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("ƙaramin diamun na shuɗi"),
            keywords: &[
                "daimun",
                "ilimin halayen sura",
                "shuɗi",
                "ƙaramin diamun na shuɗi",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("מעוין כחול קטן"),
            keywords: &["כחול", "מעוין", "מעוין כחול קטן", "צורה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("छोटा नीला हीरा"),
            keywords: &["छोटा नीला हीरा", "छोटा हीरा", "नीला", "हीरा"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("mali plavi romb"),
            keywords: &["geometrija", "mali plavi romb", "plavo", "romb"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("kis kék rombusz"),
            keywords: &["geometria", "kis kék rombusz", "kék", "rombusz"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("կապույտ փոքր շեղանկյուն"),
            keywords: &[
                "երկրաչափական",
                "կապույտ",
                "կապույտ փոքր շեղանկյուն",
                "շեղանկյուն",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("wajik biru kecil"),
            keywords: &["biru", "geometri", "wajik", "wajik biru kecil"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("obere anụnụ diamond"),
            keywords: &["anụnụ", "diamond", "mgbakọ", "obere anụnụ diamond"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("lítill blár tígull"),
            keywords: &["blár", "lítill blár tígull", "tígull"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("rombo blu piccolo"),
            keywords: &["blu", "piccolo", "rombo"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("小さい青のひし形"),
            keywords: &[
                "ひし形",
                "ダイア",
                "ダイヤ",
                "四角",
                "小さい青のひし形",
                "青",
            ],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("kupatan cilik biru"),
            keywords: &["biru", "geometrik", "kupatan", "kupatan cilik biru"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("პატარა ლურჯი რომბი"),
            keywords: &[
                "გეომეტრია",
                "გეომეტრიული",
                "ლურჯი",
                "პატარა ლურჯი რომბი",
                "რომბი",
                "ცისფერი",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("кіші көк ромб"),
            keywords: &["геометриялық", "кіші көк ромб", "көк", "ромб"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("lille blå diamant"),
            keywords: &["blå", "diamant", "geometrisk", "lille blå diamant"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ពេជ\u{17d2}រត\u{17bc}ចពណ\u{17cc}ខៀវ"),
            keywords: &[
                "ខៀវ",
                "ត\u{17bc}ច",
                "ពេជ\u{17d2}រ",
                "ពេជ\u{17d2}រត\u{17bc}ចពណ\u{17cc}ខៀវ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಸಣ\u{ccd}ಣ ನೀಲ\u{cbf} ವಜ\u{ccd}ರ"),
            keywords: &[
                "ಸಣ\u{ccd}ಣ ನೀಲ\u{cbf} ಬಣ\u{ccd}ಣದ ವಜ\u{ccd}ರ",
                "ಸಣ\u{ccd}ಣ ನೀಲ\u{cbf} ವಜ\u{ccd}ರ",
                "ಸಣ\u{ccd}ಣ ವಜ\u{ccd}ರ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("작은 파란색 마름모"),
            keywords: &["마름모", "작은 파란색 마름모", "파란색", "파랑"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("ल\u{94d}हान निळो हिरो"),
            keywords: &[
                "जियोम\u{945}ट\u{94d}रीक",
                "निळो",
                "ल\u{94d}हान निळो हिरो",
                "हिरो",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("кичинекей көк ромб"),
            keywords: &["геометрия", "кичинекей көк ромб", "көк", "ромб"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("kleng blo Raut"),
            keywords: &["Raut", "blo", "geometresch", "kleng blo Raut"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຮ\u{eb9}ບເພ\u{eb1}ດສ\u{eb5}ຟ\u{ec9}ານ\u{ec9}ອຍ"),
            keywords: &[
                "ສ\u{eb5}ຟ\u{ec9}າ",
                "ຮ\u{eb9}ບເພ\u{eb1}ດສ\u{eb5}ຟ\u{ec9}ານ\u{ec9}ອຍ",
                "ເພ\u{eb1}ດ",
                "ເລຂາຄະນ\u{eb4}ດ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("mažas mėlynas deimantas"),
            keywords: &[
                "deimantas",
                "geometrija",
                "mažas mėlynas deimantas",
                "mėlynas",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("mazs zils rombs"),
            keywords: &["mazs zils rombs", "rombs", "ģeometrija"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("taimana kikorangi iti"),
            keywords: &["kikorangi", "taimana", "taimana kikorangi iti", "āhuahanga"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("мал син дијамант"),
            keywords: &["геометрија", "дијамант", "мал", "син"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ചെറിയ നീല ഡയമണ\u{d4d}ട\u{d4d}"),
            keywords: &["ചെറിയ നീല ഡയമണ\u{d4d}ട\u{d4d}", "വജ\u{d4d}രം"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("жижиг цэнхэр алмааз"),
            keywords: &["алмааз", "геометр", "жижиг цэнхэр алмааз", "цэнхэр"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("लहान निळ\u{94d}\u{200d}या र\u{902}गाचा डायम\u{902}ड"),
            keywords: &[
                "डायम\u{902}ड",
                "निळा",
                "भ\u{942}मितीय",
                "लहान निळ\u{94d}\u{200d}या र\u{902}गाचा डायम\u{902}ड",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("berlian biru kecil"),
            keywords: &["berlian", "berlian biru kecil", "biru", "geometri"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("djamant żgħir blu"),
            keywords: &["blu", "djamant żgħir blu", "djamanti", "ġeometrika"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အပြာရောင\u{103a} စ\u{102d}န\u{103a}အသေး"),
            keywords: &[
                "ဂျ\u{102e}ဩမေတြ\u{102e}",
                "စ\u{102d}န\u{103a}",
                "အပြာ",
                "အပြာရောင\u{103a} စ\u{102d}န\u{103a}အသေး",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("lite blått rutersymbol"),
            keywords: &["blå", "geometrisk", "lite blått rutersymbol", "ruter"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("सानो नीलो हिरा"),
            keywords: &["ज\u{94d}यामितीय", "नीलो", "सानो नीलो हिरा", "हिरा"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("kleine blauwe ruit"),
            keywords: &["blauw", "geometrisch", "kleine blauwe ruit", "ruit"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("lite blått rutersymbol"),
            keywords: &["blå", "geometrisk", "lite blått rutersymbol", "ruter"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଛୋଟ ନୀଳ ହୀର\u{b3e}"),
            keywords: &[
                "ଛୋଟ ନୀଳ ହୀର\u{b3e}",
                "ଜ\u{b4d}ୟ\u{b3e}ମ\u{b3f}ତ\u{b3f}କ",
                "ନୀଳ",
                "ହୀର\u{b3e}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਛ\u{a4b}ਟਾ ਨੀਲਾ ਹੀਰਾ"),
            keywords: &[
                "ਛ\u{a47}\u{a4b}ਟਾ ਹੀਰਾ",
                "ਛ\u{a4b}ਟਾ ਨੀਲਾ ਹੀਰਾ",
                "ਜਯਾਮਿਤੀ",
                "ਨੀਲਾ",
                "ਹੀਰਾ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("نیکا نیلا ہیرا"),
            keywords: &["جیومیٹری دے متعلق", "نیلا", "نیکا نیلا ہیرا", "پیرا"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Smọ\u{301}l Blú Dáyámọnd"),
            keywords: &[
                "Blu",
                "Dáyámọnd",
                "Jiọ\u{301}mẹ\u{301}tri",
                "Smọ\u{301}l Blú Dáyámọnd",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("mały niebieski romb"),
            keywords: &[
                "figura geometryczna",
                "kształt",
                "mały",
                "niebieski",
                "romb",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("کوچنی آسماني رنګ الماس"),
            keywords: &[
                "آسماني رنګ",
                "الماس",
                "جيوميتريکي",
                "کوچنی آسماني رنګ الماس",
            ],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("losango azul pequeno"),
            keywords: &["azul", "geométrico", "losango", "losango azul pequeno"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("losango azul pequeno"),
            keywords: &["azul", "geométrico", "losango", "losango azul pequeno"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("romb albastru mic"),
            keywords: &["albastru", "geometric", "romb", "romb albastru mic"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-757"),
            keywords: &["E10-757"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("небольшой голубой ромб"),
            keywords: &[
                "геометрия",
                "голубой",
                "небольшой голубой ромб",
                "небольшой ромб",
                "ромб",
                "фигура",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ikaro nto y’ubururu"),
            keywords: &["ikaro nto y’ubururu", "jewometiri", "karo", "ubururu"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ننڍو نيرو هيرو"),
            keywords: &["جيوميٽرڪ", "ننڍو نيرو هيرو", "نيرو", "هيرو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ක\u{dd4}ඩ\u{dcf} න\u{dd2}ල\u{dca} ද\u{dd2}යමන\u{dca}ත\u{dd2}ය"),
            keywords: &[
                "ක\u{dd4}ඩ\u{dcf} න\u{dd2}ල\u{dca} ද\u{dd2}යමන\u{dca}ත\u{dd2}ය",
                "ජ\u{dca}\u{200d}ය\u{dcf}ම\u{dd2}ත\u{dd2}ක",
                "ද\u{dd2}යමන\u{dca}ත\u{dd2}ය",
                "න\u{dd2}ල\u{dca}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("malý modrý kosoštvorec"),
            keywords: &["diamant", "geometria", "malý modrý kosoštvorec", "modrý"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("majhen moder karo"),
            keywords: &["geometrično", "karo", "majhen moder karo", "modro"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("dheeman yar oo buluug ah"),
            keywords: &[
                "buluug",
                "dheeman",
                "dheeman yar oo buluug ah",
                "joometriyeed",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("diamant i vogël blu"),
            keywords: &["blu", "diamant", "diamant i vogël blu", "gjeometrik"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("мали плави ромб"),
            keywords: &["гeoмeтриja", "мали плави ромб", "плaвo", "рoмб"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("mali plavi romb"),
            keywords: &["geometrija", "mali plavi romb", "plavo", "romb"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("liten blå romb"),
            keywords: &["blå", "diamant", "liten blå romb"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("almasi ndogo ya samawati"),
            keywords: &["almasi", "almasi ndogo ya samawati", "jiometri", "samawati"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("சிறிய ந\u{bc0}ல வைரம\u{bcd}"),
            keywords: &[
                "சிறிய ந\u{bc0}ல வைரம\u{bcd}",
                "சிறிய வைரம\u{bcd}",
                "டைமண\u{bcd}ட\u{bcd}",
                "ந\u{bc0}லம\u{bcd}",
                "வைரம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("చ\u{c3f}న\u{c4d}న న\u{c40}ల\u{c3f} రంగు చతుర\u{c4d}భుజ\u{c3e}క\u{c3e}రం"),
            keywords: &[
                "చతుర\u{c4d}భుజ\u{c3e}క\u{c3e}రం",
                "చ\u{c3f}న\u{c4d}న న\u{c40}ల\u{c3f} రంగు చతుర\u{c4d}భుజ\u{c3e}క\u{c3e}రం",
                "డ\u{c48}మండ\u{c4d}",
                "న\u{c40}ల\u{c3f} రంగు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("алмоси хурди кабуд"),
            keywords: &["алмос", "алмоси хурди кабуд", "геометрӣ", "кабуд"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เพชรเล\u{e47}กส\u{e35}น\u{e49}ำเง\u{e34}น"),
            keywords: &[
                "ส\u{e35}น\u{e49}ำเง\u{e34}น",
                "เพชร",
                "เพชรเล\u{e47}กส\u{e35}น\u{e49}ำเง\u{e34}น",
                "เรขาคณ\u{e34}ต",
            ],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ንኢሽተይ ሰማያዊት ኣልማዝ"),
            keywords: &[
                "ሰማያዊ",
                "ንኢሽተይ ሰማያዊ ኣልማዝ",
                "ንኢሽተይ ሰማያዊት ኣልማዝ",
                "ኣልማዝ",
                "ጂኦሜትሪክ",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("kiçi gök pişme"),
            keywords: &["almaz", "geometrik", "gök", "kiçi gök pişme"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("taiamoni siʻi mo lanupulū"),
            keywords: &["lanupulū", "taiamoni", "taiamoni siʻi mo lanupulū"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("küçük mavi karo"),
            keywords: &["karo", "küçük mavi karo", "mavi"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("كىچىك كۆك رومبا"),
            keywords: &["رومبا", "كىچىك كۆك رومبا", "كۆك", "گېئومېتىرىيە"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("малий синій ромб"),
            keywords: &["геометричний", "діамант", "малий синій ромб", "синій"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("چھوٹا نیلا ہیرا"),
            keywords: &["جیومیٹری", "نیلا", "چھوٹا نیلا ہیرا", "ہیرا"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("kichik ko‘k romb"),
            keywords: &["geometrik", "kichik ko‘k romb", "ko‘k", "romb"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("hình thoi nhỏ màu lam"),
            keywords: &["hình học", "hình thoi", "hình thoi nhỏ màu lam", "màu lam"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("karo ndaw baxa"),
            keywords: &["baxa", "karo", "karo ndaw baxa", "wu-geometri"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("idayimani ebhlowu encinane"),
            keywords: &[
                "bhlowu",
                "idayimani",
                "idayimani ebhlowu encinane",
                "ijiyometriki",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("diamọndi alawọ bulu kekere"),
            keywords: &[
                "Búlù",
                "diamọndi alawọ bulu kekere",
                "díámọ\u{301}ndì",
                "jiomẹ\u{301}tíríkì",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("細藍色菱形"),
            keywords: &["幾何", "細藍色菱形", "菱形", "藍色"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("细蓝色菱形"),
            keywords: &["几何", "细蓝色菱形", "菱形", "蓝色"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("蓝色小菱形"),
            keywords: &["小", "方片", "蓝色", "蓝色小菱形"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("小藍色菱形"),
            keywords: &["小藍色菱形", "菱形"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("藍色小菱形"),
            keywords: &["菱形", "藍色小菱形"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("idayimande eliluhlaza sasibhakabhaka elincane"),
            keywords: &[
                "idayimande eliluhlaza sasibhakabhaka elincane",
                "indingiliza",
                "jiyometrikhi",
                "luhlaza sasibhakabhaka",
            ],
        },
    ],
};
#[doc = "🔺"]
pub const RED_TRIANGLE_POINTED_UP: crate::Emoji = crate::Emoji {
    glyph: "🔺",
    codepoint: "1F53A",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "red triangle pointed up",
    group: "Symbols",
    subgroup: "geometric",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("rooi driehoek wat op wys"),
            keywords: &[
                "driehoek",
                "geometries",
                "op",
                "rooi",
                "rooi driehoek wat op wys",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ቀይ ሶስት ማዕዘን ወደ ላይ ጠቋሚ"),
            keywords: &["ቀይ", "ቀይ ሶስት ማዕዘን ወደ ላይ ጠቋሚ", "ጂኦሜትሪያዊ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("مثلث لأعلى أحمر"),
            keywords: &["أحمر", "مثلث", "مثلث أحمر لأعلى", "مثلث لأعلى أحمر"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ঊৰ\u{9cd}ধ\u{9cd}বম\u{9c1}খী ৰঙ\u{9be} ত\u{9cd}ৰিভ\u{9c1}জ"),
            keywords: &[
                "ঊৰ\u{9cd}ধ\u{9cd}বম\u{9c1}খী ৰঙ\u{9be} ত\u{9cd}ৰিভ\u{9c1}জ",
                "জ\u{9cd}য\u{9be}মিতিক",
                "ৰঙ\u{9be}",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("yuxarı yönəlmiş qırmızı üçbucaq"),
            keywords: &["həndəsi", "qırmızı", "yuxarı yönəlmiş qırmızı üçbucaq"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("чырвоны трохвугольнік вяршыняй уверх"),
            keywords: &[
                "аб’ект",
                "геаметрычны",
                "чырвоны",
                "чырвоны трохвугольнік вяршыняй уверх",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Сочещ нагоре червен триъгълник"),
            keywords: &["Сочещ нагоре червен триъгълник", "геометричен", "червен"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ল\u{9be}ল ত\u{9cd}রিভ\u{9c1}জ উপরের দিকে পয\u{9bc}েন\u{9cd}ট কর\u{9be}"),
            keywords: &[
                "জ\u{9cd}য\u{9be}মিতিক",
                "ল\u{9be}ল",
                "ল\u{9be}ল ত\u{9cd}রিভ\u{9c1}জ উপরের দিকে পয\u{9bc}েন\u{9cd}ট কর\u{9be}",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("crveni trokut prema gore"),
            keywords: &["crveni trokut prema gore", "crveno", "geometrija"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("triangle vermell cap amunt"),
            keywords: &[
                "amunt",
                "geometria",
                "triangle",
                "triangle vermell cap amunt",
                "vermell",
                "vermell cap amunt",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎩᎦᎨ ᏦᎢ ᏧᏏᏅᏓ ᎠᏎᎯ ᎦᎸᎳᏗ"),
            keywords: &["ᎤᏙᏢᏒ", "ᎩᎦᎨ", "ᎩᎦᎨ ᏦᎢ ᏧᏏᏅᏓ ᎠᏎᎯ ᎦᎸᎳᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("červený trojúhelník mířící nahoru"),
            keywords: &["geometrie", "červená", "červený trojúhelník mířící nahoru"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("triongl coch yn pwyntio tuag i fyny"),
            keywords: &["coch", "geometrig", "triongl coch yn pwyntio tuag i fyny"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("op-trekant"),
            keywords: &["op", "op-trekant", "rød trekant", "trekant"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("rotes Dreieck mit der Spitze nach oben"),
            keywords: &[
                "Dreieck",
                "aufwärts",
                "rot",
                "rotes Dreieck mit der Spitze nach oben",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κόκκινο τρίγωνο πάνω"),
            keywords: &["γεωμετρικό", "κόκκινο", "κόκκινο τρίγωνο πάνω"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("red triangle pointed up"),
            keywords: &["geometric", "red", "red triangle pointed up"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("triángulo rojo hacia arriba"),
            keywords: &[
                "geometría",
                "rojo",
                "triángulo",
                "triángulo hacia arriba rojo",
                "triángulo rojo hacia arriba",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("punane kolmnurk"),
            keywords: &["geomeetria", "punane", "punane kolmnurk", "üles"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("punta gora begira duen triangelu gorria"),
            keywords: &[
                "geometriko",
                "gorri",
                "punta gora begira duen triangelu gorria",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("مثلث با رأس بالا"),
            keywords: &["بالا", "شکل هندسی", "قرمز", "مثلث", "مثلث با رأس بالا"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("punainen kolmio kärki ylös"),
            keywords: &["kolmio", "muoto", "punainen", "punainen kolmio kärki ylös"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("pulang tatsulok na nakatutok pataas"),
            keywords: &[
                "hugis",
                "nakatutok",
                "pataas",
                "pula",
                "pulang tatsulok na nakatutok pataas",
                "tatsulok",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("reyður tríkantur sum peikar uppeftir"),
            keywords: &[
                "mátingarfrøðiligur",
                "reyður tríkantur sum peikar uppeftir",
                "tríkantur",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("triangle rouge pointant vers le haut"),
            keywords: &[
                "forme géométrique",
                "rouge",
                "triangle rouge pointant vers le haut",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("triangle rouge qui pointe vers le haut"),
            keywords: &[
                "géométrie",
                "rouge",
                "triangle qui pointe vers le haut",
                "triangle rouge qui pointe vers le haut",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("triantán dearg suas"),
            keywords: &["triantán dearg suas"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("triantan dearg a’ tomhadh suas"),
            keywords: &["dearg", "geomatrach", "triantan dearg a’ tomhadh suas"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("triángulo vermello"),
            keywords: &["arriba", "triángulo", "vermello"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ઉપર લાલ ત\u{acd}રિકોણ"),
            keywords: &[
                "ઉપર ત\u{acd}રિકોણ",
                "ઉપર લાલ ત\u{acd}રિકોણ",
                "ત\u{acd}રિકોણ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("jan alwatika mai nunawa sama"),
            keywords: &["ilimin halayen sura", "ja", "jan alwatika mai nunawa sama"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("משולש אדום כלפי מעלה"),
            keywords: &["אדום", "למעלה", "משולש", "משולש אדום כלפי מעלה", "צורה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ऊपर की ओर इशारा करता लाल त\u{94d}रिभ\u{941}ज"),
            keywords: &[
                "ऊपर",
                "ऊपर की ओर इशारा करता लाल त\u{94d}रिभ\u{941}ज",
                "ऊपर दिखाता लाल त\u{94d}रिभ\u{941}ज",
                "ज\u{94d}यामिति",
                "लाल",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("crveni trokut usmjeren prema gore"),
            keywords: &[
                "crveni trokut usmjeren prema gore",
                "crveno",
                "geometrija",
                "gore",
                "trokut",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("fölfelé mutató piros háromszög"),
            keywords: &[
                "alakzat",
                "felfelé",
                "fölfelé mutató piros háromszög",
                "piros",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("կարմիր եռանկյուն ուղղված վերև"),
            keywords: &["երկրաչափական", "կարմիր", "կարմիր եռանկյուն ուղղված վերև"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("segitiga merah mengarah ke atas"),
            keywords: &["geometri", "merah", "segitiga merah mengarah ke atas"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("akomgbà-atọ ncha ọbara chewara ihu elu"),
            keywords: &["akomgbà-atọ ncha ọbara chewara ihu elu", "mgbakọ", "ọbara"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("uppvísandi rauður þríhyrningur"),
            keywords: &[
                "rauður",
                "rauður þríhyrningur upp",
                "uppvísandi rauður þríhyrningur",
                "þríhyrningur",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("triangolo rosso con punta verso l’alto"),
            keywords: &[
                "alto",
                "rosso",
                "triangolo",
                "triangolo rosso con punta verso l’alto",
                "triangolo rosso punta in alto",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("赤い上三角"),
            keywords: &["三角", "上", "赤", "赤い上三角"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("pesagi telu abang pucuke marep ndhuwur"),
            keywords: &[
                "abang",
                "geometrik",
                "pesagi telu abang pucuke marep ndhuwur",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მაღლა მიმართული წითელი სამკუთხედი"),
            keywords: &[
                "გეომეტრია",
                "გეომეტრიული",
                "მაღლა მიმართული წითელი სამკუთხედი",
                "წითელი",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("жоғары қаратылған кіші үшбұрыш"),
            keywords: &["геометриялық", "жоғары қаратылған кіші үшбұрыш", "қызыл"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("op-trekant"),
            keywords: &["op", "op-trekant", "rød trekant", "trekant"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ត\u{17d2}រ\u{17b8}កោនក\u{17d2}រហមក\u{17c6}ព\u{17bc}លទៅលើ"),
            keywords: &[
                "ក\u{17d2}រហម",
                "ត\u{17d2}រ\u{17b8}កោន",
                "ត\u{17d2}រ\u{17b8}កោនក\u{17d2}រហមក\u{17c6}ព\u{17bc}លទៅលើ",
                "លើ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಮೇಲಕ\u{ccd}ಕ\u{cc6} ತೋರ\u{cbf}ಸ\u{cbf}ದ ಕ\u{cc6}ಂಪು ತ\u{ccd}ರ\u{cbf}ಕೋನ"),
            keywords: &[
                "ಮೇಲಕ\u{ccd}ಕ\u{cc6} ತೋರ\u{cbf}ಸ\u{cbf}ದ ಕ\u{cc6}ಂಪು ತ\u{ccd}ರ\u{cbf}ಕೋನ",
                "ಮೇಲ\u{cbf}ನ ಕ\u{cc6}ಂಪು ತ\u{ccd}ರ\u{cbf}ಕೋನ",
                "ಮೇಲ\u{cbf}ನ ತ\u{ccd}ರ\u{cbf}ಕೋನ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("빨간색 위쪽 삼각형"),
            keywords: &[
                "빨간색",
                "빨간색 위쪽 삼각형",
                "빨강",
                "삼각형",
                "위쪽 빨간색 삼각형",
            ],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("ता\u{902}बडो त\u{94d}रिकोण वयर पळयता"),
            keywords: &[
                "जियोम\u{945}ट\u{94d}रीक",
                "ता\u{902}बड\u{947}\u{902}",
                "ता\u{902}बडो त\u{94d}रिकोण वयर पळयता",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("өйдө караган кызыл үч бурчтук"),
            keywords: &["геометрия", "кызыл", "өйдө караган кызыл үч бурчтук"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("rouden Dräieck mat der Spëtzt no uewen"),
            keywords: &[
                "geometresch",
                "rouden Dräieck mat der Spëtzt no uewen",
                "rout",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຮ\u{eb9}ບສາມຫ\u{ebc}\u{ec8}ຽມຫງາຍສ\u{eb5}ແດງ"),
            keywords: &[
                "ສ\u{eb5}ແດງ",
                "ຫງາຍ",
                "ຮ\u{eb9}ບສາມຫ\u{ebc}\u{ec8}ຽມຫງາຍສ\u{eb5}ແດງ",
                "ເລຂາຄະນ\u{eb4}ດ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("raudonas į viršų nukreiptas trikampis"),
            keywords: &[
                "geometrija",
                "raudona",
                "raudonas į viršų nukreiptas trikampis",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("augšupvērsts sarkans trīsstūris"),
            keywords: &[
                "augšupvērsts sarkans trīsstūris",
                "trīsstūris",
                "ģeometrija",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tapatoru whero tohu ake"),
            keywords: &["tapatoru whero tohu ake", "whero", "āhuahanga"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("црвен триаголник свртен нагоре"),
            keywords: &[
                "геометрија",
                "триаголник",
                "црвен",
                "црвен триаголник свртен нагоре",
            ],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some(
                "മ\u{d41}കളിലേക\u{d4d}ക\u{d4d} ച\u{d42}ണ\u{d4d}ട\u{d41}ന\u{d4d}ന ച\u{d41}വന\u{d4d}ന ത\u{d4d}രികോണം",
            ),
            keywords: &[
                "ജിയോമെട\u{d4d}രിക\u{d4d}ക\u{d4d}",
                "മ\u{d41}കളിലേക\u{d4d}ക\u{d4d} ച\u{d42}ണ\u{d4d}ട\u{d41}ന\u{d4d}ന ച\u{d41}വന\u{d4d}ന ത\u{d4d}രികോണം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("дээшээ харсан гурвалжин"),
            keywords: &["геометр", "дээшээ харсан гурвалжин", "улаан"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("वर दर\u{94d}शविणारा लाल त\u{94d}रिकोण"),
            keywords: &[
                "भ\u{942}मितीय",
                "लाल",
                "वर दर\u{94d}शविणारा लाल त\u{94d}रिकोण",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("segi tiga merah menunjuk ke atas"),
            keywords: &["geometri", "merah", "segi tiga merah menunjuk ke atas"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("trijangolu aħmar jipponta ’l fuq"),
            keywords: &["aħmar", "trijangolu aħmar jipponta ’l fuq", "ġeometrika"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "အပေါ\u{103a}သ\u{102d}\u{102f}\u{1037} ည\u{103d}\u{103e}န\u{103a}ပြနေသည\u{1037}\u{103a} အန\u{102e}ရောင\u{103a} တြ\u{102d}ဂ\u{1036}",
            ),
            keywords: &[
                "ဂျ\u{102e}ဩမေတြ\u{102e}",
                "န\u{102e}",
                "အပေါ\u{103a}သ\u{102d}\u{102f}\u{1037} ည\u{103d}\u{103e}န\u{103a}ပြနေသည\u{1037}\u{103a} အန\u{102e}ရောင\u{103a} တြ\u{102d}ဂ\u{1036}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("rød trekant som peker opp"),
            keywords: &[
                "geometrisk",
                "oppover",
                "rød trekant som peker opp",
                "trekant",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("माथि स\u{902}क\u{947}त गरिएको रातो त\u{94d}रिकोण"),
            keywords: &[
                "ज\u{94d}यामितीय",
                "माथि स\u{902}क\u{947}त गरिएको रातो त\u{94d}रिकोण",
                "रातो",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("rode omhoogwijzende driehoek"),
            keywords: &["geometrisch", "rode omhoogwijzende driehoek", "rood"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("raud trekant som peikar opp"),
            keywords: &[
                "geometrisk",
                "oppover",
                "raud trekant som peikar opp",
                "trekant",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଉପର ମ\u{b41}ହ\u{b3e}\u{b01} ଲ\u{b3e}ଲ ତ\u{b4d}ର\u{b3f}ଭ\u{b41}ଜ"),
            keywords: &[
                "ଉପର ମ\u{b41}ହ\u{b3e}\u{b01} ଲ\u{b3e}ଲ ତ\u{b4d}ର\u{b3f}ଭ\u{b41}ଜ",
                "ଜ\u{b4d}ୟ\u{b3e}ମତ\u{b3f}କ",
                "ଲ\u{b3e}ଲ\u{b4d}\u{200c}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਉ\u{a71}ਪਰ ਵ\u{a71}ਲ ਇਸ\u{a3c}ਾਰਾ ਕਰਦਾ ਲਾਲ ਤਿਕ\u{a4b}ਣ"),
            keywords: &[
                "ਉ\u{a71}ਤ\u{a47} ਵ\u{a71}ਲ ਤਿਕ\u{a4b}ਣਾ",
                "ਉ\u{a71}ਪਰ ਵ\u{a71}ਲ ਇਸ\u{a3c}ਾਰਾ ਕਰਦਾ ਲਾਲ ਤਿਕ\u{a4b}ਣ",
                "ਜਯਾਮਿਤੀ",
                "ਤਿਕ\u{a4b}ਣਾ",
                "ਲਾਲ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("لال تکون ا\u{64f}وتے اشارہ کردی ہوئی"),
            keywords: &[
                "جیومیٹری دے متعلق",
                "لال",
                "لال تکون ا\u{64f}وتے اشارہ کردی ہوئی",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Rẹ\u{301}d Tráyángul Wé De Pọínt Ọp"),
            keywords: &[
                "Jiọ\u{301}mẹ\u{301}tri",
                "Rẹd",
                "Rẹ\u{301}d Tráyángul Wé De Pọínt Ọp",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("czerwony trójkąt skierowany w górę"),
            keywords: &[
                "czerwony",
                "czerwony trójkąt skierowany w górę",
                "do góry",
                "figura geometryczna",
                "trójkąt",
                "w górę",
                "wierzchołkiem",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("سور مثلث پورته"),
            keywords: &["جيوميتريکي", "سور", "سور مثلث پورته"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("triângulo vermelho para cima"),
            keywords: &["geométrico", "triângulo vermelho para cima", "vermelho"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("triângulo vermelho a apontar para cima"),
            keywords: &[
                "geométrico",
                "para cima",
                "triângulo",
                "triângulo vermelho a apontar para cima",
                "vermelho",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("triunghi roșu cu vârful în sus"),
            keywords: &[
                "geometric",
                "roșu",
                "triunghi",
                "triunghi roșu cu vârful în sus",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-758"),
            keywords: &["E10-758"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("треугольник вершиной вверх"),
            keywords: &[
                "вверх",
                "геометрия",
                "красный",
                "треугольник",
                "треугольник вершиной вверх",
                "фигура",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("mpandeshatu itukura ireba hejuru"),
            keywords: &[
                "byerekeye jewometiri",
                "mpandeshatu itukura ireba hejuru",
                "umutuku",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڳاڙهو ٽڪنڊو مٿي اشارو ڪيل"),
            keywords: &["جيوميٽرڪ", "ڳاڙهو", "ڳاڙهو ٽڪنڊو مٿي اشارو ڪيل"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ඉහළට යොම\u{dd4} ව\u{dd6} රත\u{dd4} ත\u{dca}\u{200d}ර\u{dd2}කෝණය"),
            keywords: &[
                "ඉහළට යොම\u{dd4} ව\u{dd6} රත\u{dd4} ත\u{dca}\u{200d}ර\u{dd2}කෝණය",
                "ජ\u{dca}\u{200d}ය\u{dcf}ම\u{dd2}ත\u{dd2}ක",
                "රත\u{dd4}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("červený trojuholník nahor"),
            keywords: &["geometria", "červený", "červený trojuholník nahor"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("rdeč trikotnik gor"),
            keywords: &["geometrično", "rdeč trikotnik gor", "rdeče"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("saddex xaggale cas oo kor tilmaamaya"),
            keywords: &[
                "cas",
                "joometriyeed",
                "saddex xaggale cas oo kor tilmaamaya",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("trekëndësh i kuq i drejtuar lart"),
            keywords: &[
                "e kuqe",
                "gjeometrik",
                "i kuq",
                "trekëndësh i kuq i drejtuar lart",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("црвени троугао окренут нагоре"),
            keywords: &["геометрија", "црвени троугао окренут нагоре", "црвено"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["црвени троугао окренут нагоре"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("crveni trougao okrenut nagore"),
            keywords: &["crveni trougao okrenut nagore", "crveno", "geometrija"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["crveni trougao okrenut nagore"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("uppåtpekande röd triangel"),
            keywords: &["röd triangel", "uppåtpekande röd triangel"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("pembetatu inayoelekeza juu"),
            keywords: &["jiometri", "nyekundu", "pembetatu inayoelekeza juu"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("மேல\u{bcd}நோக\u{bcd}கிய சிவப\u{bcd}பு முக\u{bcd}கோணம\u{bcd}"),
            keywords: &[
                "சிவப\u{bcd}பு",
                "முக\u{bcd}கோணம\u{bcd}",
                "மேல\u{bcd} முக\u{bcd}கோணம\u{bcd}",
                "மேல\u{bcd}நோக\u{bcd}கிய சிவப\u{bcd}பு முக\u{bcd}கோணம\u{bcd}",
                "மேல\u{bcd}நோக\u{bcd}கிய முக\u{bcd}கோணம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some(
                "ప\u{c48}క\u{c3f} సూచ\u{c3f}ంచ\u{c47} ప\u{c46}ద\u{c4d}ద ఎరుపురంగు త\u{c4d}ర\u{c3f}భుజం",
            ),
            keywords: &[
                "ఎరుపురంగు",
                "త\u{c4d}ర\u{c3f}భుజం",
                "ప\u{c48}క\u{c3f}",
                "ప\u{c48}క\u{c3f} సూచ\u{c3f}ంచ\u{c47} ప\u{c46}ద\u{c4d}ద ఎరుపురంగు త\u{c4d}ర\u{c3f}భుజం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("секунҷаи сурхи ба боло равонашуда"),
            keywords: &["геометрӣ", "секунҷаи сурхи ба боло равонашуда", "сурх"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("สามเหล\u{e35}\u{e48}ยมหงายส\u{e35}แดง"),
            keywords: &[
                "สามเหล\u{e35}\u{e48}ยมหงายส\u{e35}แดง",
                "ส\u{e35}แดง",
                "หงายข\u{e36}\u{e49}น",
                "เรขาคณ\u{e34}ต",
            ],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ቀያሕ ስሉስ-ኩርናዕ ኣርኣየ"),
            keywords: &[
                "ቀያሕ",
                "ቀያሕ ስሉስ-ኩርናዕ ንላዕሊ ኣርኣየ",
                "ቀያሕ ስሉስ-ኩርናዕ ኣርኣየ",
                "ጂኦሜትሪክ",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ýokaryk gyzyl üçburç"),
            keywords: &["geometrik", "gyzyl", "ýokaryk gyzyl üçburç"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tapatolu ki ʻolunga kulokula"),
            keywords: &[
                "hake",
                "kulokula",
                "tapatolu",
                "tapatolu ki ʻolunga kulokula",
                "ʻolunga",
            ],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("yukarı bakan kırmızı üçgen"),
            keywords: &[
                "kırmızı",
                "yukarı bakan kırmızı üçgen",
                "yukarı kırmızı üçgen",
                "üçgen",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("قىزىل ئۈستى ئۈچبۇلۇڭ"),
            keywords: &["قىزىل", "قىزىل ئۈستى ئۈچبۇلۇڭ", "گېئومېتىرىيە"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("червоний трикутник, направлений угору"),
            keywords: &[
                "геометричний",
                "червоний",
                "червоний трикутник, направлений угору",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("اوپر اشارہ کرتی سرخ مثلث"),
            keywords: &["اوپر اشارہ کرتی سرخ مثلث", "جیومیٹری", "مثلث", "نارنجی"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("tepaga qaragan qizil uchburchak"),
            keywords: &["geometrik", "qizil", "tepaga qaragan qizil uchburchak"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("tam giác màu đỏ trỏ lên trên"),
            keywords: &["hình học", "màu đỏ", "tam giác màu đỏ trỏ lên trên"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("xonk, tri-àngal, buñ defal tomb"),
            keywords: &["wu-geometri", "xonk", "xonk, tri-àngal, buñ defal tomb"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("unxantathu obomvu okhombe phezulu"),
            keywords: &["bomvu", "ijiyometriki", "unxantathu obomvu okhombe phezulu"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Alawọ Pupa Onigun Mẹta Toka Soke"),
            keywords: &[
                "Alawọ Pupa Onigun Mẹta Toka Soke",
                "jiomẹ\u{301}tíríkì",
                "pupa",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("指向上嘅紅色三角形"),
            keywords: &["幾何", "指向上嘅紅色三角形", "紅色"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("指向上嘅红色三角形"),
            keywords: &["几何", "指向上嘅红色三角形", "红色"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("红色正三角"),
            keywords: &["三角形", "向上", "正三角", "红色", "红色正三角"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("向上紅色三角"),
            keywords: &["三角形", "向上紅色三角"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("指向上嘅紅三角"),
            keywords: &["三角形", "指向上嘅紅三角"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("unxantathu obomvu obheke phezulu"),
            keywords: &["bomvu", "jiyometrikhi", "unxantathu obomvu obheke phezulu"],
        },
    ],
};
#[doc = "🔻"]
pub const RED_TRIANGLE_POINTED_DOWN: crate::Emoji = crate::Emoji {
    glyph: "🔻",
    codepoint: "1F53B",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "red triangle pointed down",
    group: "Symbols",
    subgroup: "geometric",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("rooi driehoek wat af wys"),
            keywords: &[
                "af",
                "driehoek",
                "geometries",
                "rooi",
                "rooi driehoek wat af wys",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ቀይ ሶስት ማዕዘን ወደ ታች ጠቋሚ"),
            keywords: &["ቀይ", "ቀይ ሶስት ማዕዘን ወደ ታች ጠቋሚ", "ታች", "ጂኦሜትሪያዊ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("مثلث لأسفل أحمر"),
            keywords: &["أحمر", "مثلث", "مثلث أحمر لأسفل", "مثلث لأسفل أحمر"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("অধোম\u{9c1}খী ৰঙ\u{9be} ত\u{9cd}ৰিভ\u{9c1}জ"),
            keywords: &[
                "অধোম\u{9c1}খী ৰঙ\u{9be} ত\u{9cd}ৰিভ\u{9c1}জ",
                "জ\u{9cd}য\u{9be}মিতিক",
                "তললৈ",
                "ৰঙ\u{9be}",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("aşağı yönəlmiş qırmızı üçbucaq"),
            keywords: &[
                "aşağı",
                "aşağı yönəlmiş qırmızı üçbucaq",
                "həndəsi",
                "qırmızı",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("чырвоны трохвугольнік вяршыняй уніз"),
            keywords: &[
                "аб’ект",
                "геаметрычны",
                "чырвоны",
                "чырвоны трохвугольнік вяршыняй уніз",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Сочещ надолу червен триъгълник"),
            keywords: &[
                "Сочещ надолу червен триъгълник",
                "геометричен",
                "надолу",
                "червен",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ল\u{9be}ল ত\u{9cd}রিভ\u{9c1}জ নীচের দিকে পয\u{9bc}েন\u{9cd}ট কর\u{9be}"),
            keywords: &[
                "জ\u{9cd}য\u{9be}মিতিক",
                "নিম\u{9cd}নম\u{9c1}খী",
                "ল\u{9be}ল",
                "ল\u{9be}ল ত\u{9cd}রিভ\u{9c1}জ নীচের দিকে পয\u{9bc}েন\u{9cd}ট কর\u{9be}",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("crveni trokut prema dolje"),
            keywords: &["crveni trokut prema dolje", "crveno", "dolje", "geometrija"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("triangle vermell cap avall"),
            keywords: &[
                "avall",
                "geometria",
                "triangle",
                "triangle vermell cap avall",
                "vermell",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎩᎦᎨ ᏦᎢ ᏧᏏᏅᏓ ᎠᏎᎯ ᎡᎳᏗᏜ"),
            keywords: &["ᎡᎳᏗ", "ᎤᏙᏢᏒ", "ᎩᎦᎨ", "ᎩᎦᎨ ᏦᎢ ᏧᏏᏅᏓ ᎠᏎᎯ ᎡᎳᏗᏜ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("červený trojúhelník mířící dolů"),
            keywords: &[
                "dolů",
                "geometrie",
                "červená",
                "červený trojúhelník mířící dolů",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("triongl coch yn pwyntio tuag i lawr"),
            keywords: &[
                "coch",
                "geometrig",
                "i lawr",
                "triongl coch yn pwyntio tuag i lawr",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("ned-trekant"),
            keywords: &["ned", "ned-trekant", "rød trekant", "trekant"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("rotes Dreieck mit der Spitze nach unten"),
            keywords: &[
                "Dreieck",
                "abwärts",
                "rot",
                "rotes Dreieck mit der Spitze nach unten",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κόκκινο τρίγωνο κάτω"),
            keywords: &["γεωμετρικό", "κάτω", "κόκκινο", "κόκκινο τρίγωνο κάτω"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("red triangle pointed down"),
            keywords: &["down", "geometric", "red", "red triangle pointed down"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("triángulo rojo hacia abajo"),
            keywords: &[
                "geometría",
                "rojo",
                "triángulo",
                "triángulo hacia abajo rojo",
                "triángulo rojo hacia abajo",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("punane tagurpidi kolmnurk"),
            keywords: &["alla", "geomeetria", "punane", "punane tagurpidi kolmnurk"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("punta behera begira duen triangelu gorria"),
            keywords: &[
                "behera",
                "geometriko",
                "gorri",
                "punta behera begira duen triangelu gorria",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("مثلث با رأس پایین"),
            keywords: &["شکل هندسی", "قرمز", "مثلث", "مثلث با رأس پایین", "پایین"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("punainen kolmio kärki alas"),
            keywords: &["kolmio", "muoto", "punainen", "punainen kolmio kärki alas"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("pulang tatsulok na nakatutok pababa"),
            keywords: &[
                "hugis",
                "pababa",
                "pula",
                "pulang tatsulok na nakatutok pababa",
                "tatsulok",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("reyður tríkantur sum peikar niðureftir"),
            keywords: &[
                "mátingarfrøðiligur",
                "reyður tríkantur sum peikar niðureftir",
                "tríkantur",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("triangle rouge pointant vers le bas"),
            keywords: &[
                "flèche",
                "forme",
                "géométrie",
                "triangle rouge pointant vers le bas",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("triangle rouge qui pointe vers le bas"),
            keywords: &[
                "géométrie",
                "rouge",
                "triangle qui pointe vers le bas",
                "triangle rouge qui pointe vers le bas",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("triantán dearg síos"),
            keywords: &["triantán dearg síos"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("triantan dearg a’ tomhadh sìos"),
            keywords: &[
                "dearg",
                "geomatrach",
                "sìos",
                "triantan dearg a’ tomhadh sìos",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("triángulo vermello invertido"),
            keywords: &["abaixo", "invertido", "triángulo", "vermello"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("નીચો લાલ ત\u{acd}રિકોણ"),
            keywords: &[
                "ત\u{acd}રિકોણ",
                "નીચ\u{ac7} ત\u{acd}રિકોણ",
                "નીચો લાલ ત\u{acd}રિકોણ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("jan alwatika mai nunawa ƙasa"),
            keywords: &[
                "ilimin halayen sura",
                "ja",
                "jan alwatika mai nunawa ƙasa",
                "ƙasa",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("משולש אדום כלפי מטה"),
            keywords: &["אדום", "למטה", "משולש", "משולש אדום כלפי מטה", "צורה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("नीच\u{947} की ओर इशारा करता लाल त\u{94d}रिभ\u{941}ज"),
            keywords: &[
                "ज\u{94d}यामिति",
                "नीच\u{947}",
                "नीच\u{947} की ओर इशारा करता लाल त\u{94d}रिभ\u{941}ज",
                "नीच\u{947} दिखाता लाल त\u{94d}रिभ\u{941}ज",
                "लाल",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("crveni trokut usmjeren prema dolje"),
            keywords: &[
                "crveni trokut usmjeren prema dolje",
                "crveno",
                "dolje",
                "geometrija",
                "trokut",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("lefelé mutató piros háromszög"),
            keywords: &[
                "alakzat",
                "lefelé",
                "lefelé mutató piros háromszög",
                "piros",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("կարմիր եռանկյուն ուղղված ներքև"),
            keywords: &[
                "երկրաչափական",
                "կարմիր",
                "կարմիր եռանկյուն ուղղված ներքև",
                "ներքև",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("segitiga merah mengarah ke bawah"),
            keywords: &[
                "geometri",
                "merah",
                "segitiga merah mengarah ke bawah",
                "turun",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("akomgbà-atọ ncha ọbara chewara ihu ala"),
            keywords: &[
                "akomgbà-atọ ncha ọbara chewara ihu ala",
                "ala",
                "mgbakọ",
                "obere",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("niðurvísandi rauður þríhyrningur"),
            keywords: &[
                "niðurvísandi rauður þríhyrningur",
                "rauður",
                "rauður þríhyrningur niður",
                "þríhyrningur",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("triangolo rosso con punta verso il basso"),
            keywords: &[
                "basso",
                "rosso",
                "triangolo",
                "triangolo rosso con punta verso il basso",
                "triangolo rosso punta in basso",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("赤い下三角"),
            keywords: &["三角", "下", "赤", "赤い下三角"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("pesagi telu abang pucuke marep ngisor"),
            keywords: &[
                "abang",
                "geometrik",
                "ngisor",
                "pesagi telu abang pucuke marep ngisor",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("დაბლა მიმართული წითელი სამკუთხედი"),
            keywords: &[
                "გეომეტრია",
                "გეომეტრიული",
                "დაბლა მიმართული წითელი სამკუთხედი",
                "ქვემოთ",
                "წითელი",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("төмен қаратылған кіші үшбұрыш"),
            keywords: &[
                "геометриялық",
                "төмен",
                "төмен қаратылған кіші үшбұрыш",
                "қызыл",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("ned-trekant"),
            keywords: &["ned", "ned-trekant", "rød trekant", "trekant"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ត\u{17d2}រ\u{17b8}កោនក\u{17d2}រហមក\u{17c6}ព\u{17bc}លច\u{17bb}ះក\u{17d2}រោម"),
            keywords: &[
                "ក\u{17d2}រហម",
                "ក\u{17d2}រោម",
                "ត\u{17d2}រ\u{17b8}កោន",
                "ត\u{17d2}រ\u{17b8}កោនក\u{17d2}រហមក\u{17c6}ព\u{17bc}លច\u{17bb}ះក\u{17d2}រោម",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕ\u{cc6}ಳಗ\u{cc6} ತೋರ\u{cbf}ಸ\u{cbf}ದ ಕ\u{cc6}ಂಪು ತ\u{ccd}ರ\u{cbf}ಕೋನ"),
            keywords: &[
                "ಕ\u{cc6}ಳಗ\u{cbf}ನ ಕ\u{cc6}ಂಪು ತ\u{ccd}ರ\u{cbf}ಕೋನ",
                "ಕ\u{cc6}ಳಗ\u{cbf}ನ ತ\u{ccd}ರ\u{cbf}ಕೋನ",
                "ಕ\u{cc6}ಳಗ\u{cc6} ತೋರ\u{cbf}ಸ\u{cbf}ದ ಕ\u{cc6}ಂಪು ತ\u{ccd}ರ\u{cbf}ಕೋನ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("빨간색 아래쪽 삼각형"),
            keywords: &[
                "빨간색",
                "빨간색 아래쪽 삼각형",
                "빨강",
                "삼각형",
                "아래쪽 빨간색 삼각형",
            ],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("ता\u{902}बडो त\u{94d}रिकोण सकयल पळयता"),
            keywords: &[
                "जियोम\u{945}ट\u{94d}रीक",
                "ता\u{902}बडो",
                "ता\u{902}बडो त\u{94d}रिकोण सकयल पळयता",
                "सकयल",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("төмөн караган кызыл үч бурчтук"),
            keywords: &[
                "геометрия",
                "кызыл",
                "төмөн",
                "төмөн караган кызыл үч бурчтук",
            ],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("rouden Dräieck mat der Spëtzt no ënnen"),
            keywords: &[
                "geometresch",
                "no ënnen",
                "rouden Dräieck mat der Spëtzt no ënnen",
                "rout",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຮ\u{eb9}ບສາມຫ\u{ebc}\u{ec8}ຽມຂວ\u{ecd}\u{ec9}າສ\u{eb5}ແດງ"),
            keywords: &[
                "ຂວ\u{ecd}\u{ec9}າ",
                "ຮ\u{eb9}ບສາມຫ\u{ebc}\u{ec8}ຽມຂວ\u{ecd}\u{ec9}າສ\u{eb5}ແດງ",
                "ເລຂາຄະນ\u{eb4}ດ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("raudonas į apačią nukreiptas trikampis"),
            keywords: &[
                "geometrija",
                "raudona",
                "raudonas į apačią nukreiptas trikampis",
                "į apačią",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("lejupvērsts sarkans trīsstūris"),
            keywords: &["lejupvērsts sarkans trīsstūris", "trīsstūris", "ģeometrija"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tapatoru whero tohu iho"),
            keywords: &["iho", "tapatoru whero tohu iho", "whero", "āhuahanga"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("црвен триаголник свртен надолу"),
            keywords: &[
                "геометрија",
                "триаголник",
                "црвен",
                "црвен триаголник свртен надолу",
            ],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some(
                "ത\u{d3e}ഴേക\u{d4d}ക\u{d4d} ച\u{d42}ണ\u{d4d}ട\u{d41}ന\u{d4d}ന ച\u{d41}വന\u{d4d}ന ത\u{d4d}രികോണം",
            ),
            keywords: &[
                "ജിയോമെട\u{d4d}രിക\u{d4d}ക\u{d4d}",
                "ത\u{d3e}ഴേക\u{d4d}ക\u{d4d} ച\u{d42}ണ\u{d4d}ട\u{d41}ന\u{d4d}ന ച\u{d41}വന\u{d4d}ന ത\u{d4d}രികോണം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("доошоо харсан гурвалжин"),
            keywords: &["геометр", "доош", "доошоо харсан гурвалжин", "улаан"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("खाली दर\u{94d}शविणारा लाल त\u{94d}रिकोण"),
            keywords: &[
                "खाली",
                "खाली दर\u{94d}शविणारा लाल त\u{94d}रिकोण",
                "भ\u{942}मितीय",
                "लाल",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("segi tiga merah menunjuk ke bawah"),
            keywords: &[
                "geometri",
                "ke bawah",
                "merah",
                "segi tiga merah menunjuk ke bawah",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("trijangolu aħmar jipponta ’l isfel"),
            keywords: &[
                "aħmar",
                "trijangolu aħmar jipponta ’l isfel",
                "ġeometriku",
                "’l isfel",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "အောက\u{103a}သ\u{102d}\u{102f}\u{1037} ည\u{103d}\u{103e}န\u{103a}ပြနေသည\u{1037}\u{103a} အန\u{102e}ရောင\u{103a} တြ\u{102d}ဂ\u{1036}",
            ),
            keywords: &[
                "ဂျ\u{102e}ဩမေတြ\u{102e}",
                "စ\u{102d}န\u{103a}",
                "အတ\u{103d}င\u{103a}းပ\u{102d}\u{102f}င\u{103a}း",
                "အောက\u{103a}သ\u{102d}\u{102f}\u{1037}",
                "အောက\u{103a}သ\u{102d}\u{102f}\u{1037} ည\u{103d}\u{103e}န\u{103a}ပြနေသည\u{1037}\u{103a} အန\u{102e}ရောင\u{103a} တြ\u{102d}ဂ\u{1036}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("rød trekant som peker ned"),
            keywords: &[
                "geometrisk",
                "nedover",
                "rød trekant som peker ned",
                "trekant",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("तल स\u{902}क\u{947}त गरिएको रातो त\u{94d}रिकोण"),
            keywords: &[
                "ज\u{94d}यामितीय",
                "तल",
                "तल स\u{902}क\u{947}त गरिएको रातो त\u{94d}रिकोण",
                "रातो",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("rode omlaagwijzende driehoek"),
            keywords: &[
                "geometrisch",
                "omlaag",
                "rode omlaagwijzende driehoek",
                "rood",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("raud trekant som peikar ned"),
            keywords: &[
                "gemoetrisk",
                "nedover",
                "raud trekant som peikar ned",
                "trekant",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ତଳ ମ\u{b41}ହ\u{b3e}\u{b01} ଲ\u{b3e}ଲ ତ\u{b4d}ର\u{b3f}ଭ\u{b41}ଜ"),
            keywords: &[
                "ଜ\u{b4d}ୟ\u{b3e}ମ\u{b3f}ତ\u{b3f}କ",
                "ତଳ",
                "ତଳ ମ\u{b41}ହ\u{b3e}\u{b01} ଲ\u{b3e}ଲ ତ\u{b4d}ର\u{b3f}ଭ\u{b41}ଜ",
                "ଲ\u{b3e}ଲ\u{b4d}\u{200c}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਥ\u{a71}ਲ\u{a47} ਵ\u{a71}ਲ ਇਸ\u{a3c}ਾਰਾ ਕਰਦਾ ਲਾਲ ਤਿਕ\u{a4b}ਣ"),
            keywords: &[
                "ਜਯਾਮਿਤੀ",
                "ਤਿਕ\u{a4b}ਣਾ",
                "ਥ\u{a71}ਲ\u{a47} ਵ\u{a71}ਲ ਇਸ\u{a3c}ਾਰਾ ਕਰਦਾ ਲਾਲ ਤਿਕ\u{a4b}ਣ",
                "ਥ\u{a71}ਲ\u{a47} ਵ\u{a71}ਲ ਤਿਕ\u{a4b}ਣਾ",
                "ਲਾਲ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("لال تکون ہیٹھاں اشارہ کردی ہوئی"),
            keywords: &[
                "جیومیٹری دے متعلق",
                "لال",
                "لال تکون ہیٹھاں اشارہ کردی ہوئی",
                "ہیٹھاں",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Rẹ\u{301}d Tráyángul Wé De Pọínt Daun"),
            keywords: &[
                "Jiọ\u{301}mẹ\u{301}tri",
                "Rẹd",
                "Rẹ\u{301}d Tráyángul Wé De Pọínt Daun",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("czerwony trójkąt skierowany w dół"),
            keywords: &[
                "czerwony",
                "czerwony trójkąt skierowany w dół",
                "figura geometryczna",
                "na dół",
                "trójkąt",
                "w dół",
                "wierzchołkiem",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("سور مثلث ښکته"),
            keywords: &["جيوميتريکي", "سور", "سور مثلث ښکته", "ښکته"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("triângulo vermelho para baixo"),
            keywords: &["geométrico", "triângulo vermelho para baixo", "vermelho"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("triângulo vermelho a apontar para baixo"),
            keywords: &[
                "geométrico",
                "para baixo",
                "triângulo",
                "triângulo vermelho a apontar para baixo",
                "vermelho",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("triunghi roșu cu vârful în jos"),
            keywords: &[
                "geometric",
                "jos",
                "roșu",
                "triunghi",
                "triunghi roșu cu vârful în jos",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-759"),
            keywords: &["E10-759"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("треугольник вершиной вниз"),
            keywords: &[
                "вниз",
                "геометрия",
                "красный",
                "треугольник",
                "треугольник вершиной вниз",
                "фигура",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("mpandeshatu itukura ireba hasi"),
            keywords: &[
                "byerekeye jewometiri",
                "hasi",
                "mpandeshatu itukura ireba hasi",
                "umutuku",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڳاڙهو ٽڪنڊو هيٺ اشارو ڪيل"),
            keywords: &["جيوميٽرڪ", "هيٺ", "ڳاڙهو", "ڳاڙهو ٽڪنڊو هيٺ اشارو ڪيل"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("පහළට යොම\u{dd4} ව\u{dd6} රත\u{dd4} ත\u{dca}\u{200d}ර\u{dd2}කෝණය"),
            keywords: &[
                "ජ\u{dca}\u{200d}ය\u{dcf}ම\u{dd2}ත\u{dd2}ක",
                "පහළ",
                "පහළට යොම\u{dd4} ව\u{dd6} රත\u{dd4} ත\u{dca}\u{200d}ර\u{dd2}කෝණය",
                "රත\u{dd4}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("červený trojuholník nadol"),
            keywords: &["geometria", "nadol", "červená", "červený trojuholník nadol"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("rdeč trikotnik dol"),
            keywords: &["geometrično", "navzdol", "rdeč trikotnik dol", "rdeče"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("saddex xaggale cas oo hoos tilmaamaya"),
            keywords: &[
                "cas",
                "hoos",
                "joometriyeed",
                "saddex xaggale cas oo hoos tilmaamaya",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("trekëndësh i kuq i drejtuar poshtë"),
            keywords: &[
                "e kuqe",
                "gjeometrik",
                "i kuq",
                "poshtë",
                "trekëndësh i kuq i drejtuar poshtë",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("црвени троугао окренут надоле"),
            keywords: &[
                "геометрија",
                "надоле",
                "црвени троугао окренут надоле",
                "црвено",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("црвени троугао окренут надоље"),
            keywords: &["црвени троугао окренут надоље"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("crveni trougao okrenut nadole"),
            keywords: &[
                "crveni trougao okrenut nadole",
                "crveno",
                "geometrija",
                "nadole",
            ],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("crveni trougao okrenut nadolje"),
            keywords: &["crveni trougao okrenut nadolje"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("nedåtpekande röd triangel"),
            keywords: &["nedåtpekande röd triangel", "röd triangel"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("pembetatu inayoelekeza chini"),
            keywords: &[
                "chini",
                "jiometri",
                "nyekundu",
                "pembetatu inayoelekeza chini",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("க\u{bc0}ழ\u{bcd}நோக\u{bcd}கிய சிவப\u{bcd}பு முக\u{bcd}கோணம\u{bcd}"),
            keywords: &[
                "க\u{bc0}ழ\u{bcd} முக\u{bcd}கோணம\u{bcd}",
                "க\u{bc0}ழ\u{bcd}நோக\u{bcd}கிய சிவப\u{bcd}பு முக\u{bcd}கோணம\u{bcd}",
                "க\u{bc0}ழ\u{bcd}நோக\u{bcd}கிய முக\u{bcd}கோணம\u{bcd}",
                "சிவப\u{bcd}பு",
                "முக\u{bcd}கோணம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some(
                "క\u{c4d}ర\u{c3f}ంద\u{c3f}క\u{c3f} సూచ\u{c3f}ంచ\u{c47} ప\u{c46}ద\u{c4d}ద ఎరుపురంగు త\u{c4d}ర\u{c3f}భుజం",
            ),
            keywords: &[
                "ఎరుపురంగు",
                "క\u{c4d}ర\u{c3f}ంద\u{c3f}క\u{c3f}",
                "క\u{c4d}ర\u{c3f}ంద\u{c3f}క\u{c3f} సూచ\u{c3f}ంచ\u{c47} ప\u{c46}ద\u{c4d}ద ఎరుపురంగు త\u{c4d}ర\u{c3f}భుజం",
                "త\u{c4d}ర\u{c3f}భుజం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("секунҷаи сурхи ба поён равонашуда"),
            keywords: &[
                "геометрӣ",
                "поён",
                "секунҷаи сурхи ба поён равонашуда",
                "сурх",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("สามเหล\u{e35}\u{e48}ยมคว\u{e48}ำส\u{e35}แดง"),
            keywords: &[
                "คว\u{e48}ำลง",
                "สามเหล\u{e35}\u{e48}ยมคว\u{e48}ำส\u{e35}แดง",
                "ส\u{e35}แดง",
                "เรขาคณ\u{e34}ต",
            ],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ቀያሕ ስሉስ-ኩርናዕ ንታሕቲ ኣርኣየ"),
            keywords: &["ቀያሕ", "ቀያሕ ስሉስ-ኩርናዕ ንታሕቲ ኣርኣየ", "ንታሕቲ", "ጂኦሜትሪክ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("aşak gyzyl üçburç"),
            keywords: &["aşak", "aşak gyzyl üçburç", "geometrik", "gyzyl"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tapatolu kulokula ki lalo"),
            keywords: &[
                "hifo",
                "kulokula",
                "lalo",
                "tapatolu",
                "tapatolu kulokula ki lalo",
            ],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("aşağı bakan kırmızı üçgen"),
            keywords: &[
                "aşağı bakan kırmızı üçgen",
                "aşağı kırmızı üçgen",
                "kırmızı",
                "üçgen",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("قىزىل ئاستى ئۈچبۇلۇڭ"),
            keywords: &["تۆۋەن", "قىزىل", "قىزىل ئاستى ئۈچبۇلۇڭ", "گېئومېتىرىيە"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("червоний трикутник, направлений униз"),
            keywords: &[
                "вниз",
                "геометричний",
                "червоний",
                "червоний трикутник, направлений униз",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("نیچے اشارہ کرتی سرخ مثلث"),
            keywords: &["جیومیٹری", "مثلث", "نارنجی", "نیچے اشارہ کرتی سرخ مثلث"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("pastga qaragan qizil uchburchak"),
            keywords: &[
                "geometrik",
                "pastga",
                "pastga qaragan qizil uchburchak",
                "qizil",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("tam giác màu đỏ trỏ xuống dưới"),
            keywords: &["hình học", "tam giác màu đỏ trỏ xuống dưới", "xuống", "đỏ"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("tri-àngal xonk muuse jëm suuf"),
            keywords: &[
                "suuf",
                "tri-àngal xonk muuse jëm suuf",
                "wu-geometri",
                "xonk",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("unxantathu obomvu okhombe ezantsi"),
            keywords: &[
                "bomvu",
                "ezantsi",
                "ijiyometriki",
                "unxantathu obomvu okhombe ezantsi",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Alawọ Pupa Onigun Mẹta Toka Sisalẹ"),
            keywords: &[
                "Alawọ Pupa Onigun Mẹta Toka Sisalẹ",
                "Ilẹ\u{300}",
                "jiomẹ\u{301}tíríkì",
                "pupa",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("指向下嘅紅色三角形"),
            keywords: &["向下", "幾何", "指向下嘅紅色三角形", "紅色"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("指向下嘅红色三角形"),
            keywords: &["几何", "向下", "指向下嘅红色三角形", "红色"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("红色倒三角"),
            keywords: &["三角形", "倒三角", "向下", "红色", "红色倒三角"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("向下紅色三角"),
            keywords: &["三角形", "向下紅色三角"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("指向下嘅紅三角"),
            keywords: &["三角形", "指向下嘅紅三角"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("unxantathu obomvu obheke phansi"),
            keywords: &[
                "bomvu",
                "jiyometrikhi",
                "phansi",
                "unxantathu obomvu obheke phansi",
            ],
        },
    ],
};
#[doc = "💠"]
pub const DIAMOND_WITH_A_DOT: crate::Emoji = crate::Emoji {
    glyph: "💠",
    codepoint: "1F4A0",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "diamond with a dot",
    group: "Symbols",
    subgroup: "geometric",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("diamant met ‘n kol"),
            keywords: &[
                "binne",
                "diamant",
                "diamant met ‘n kol",
                "geometries",
                "kol",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ባለ ነቁጥ አልማዝ"),
            keywords: &["ባለ ነቁጥ አልማዝ", "አልማዝ", "አስቂኝ", "ከውስጥ", "ጂኦሜትሪያዊ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("ماسة مع نقطة"),
            keywords: &["جذاب", "شكل ماسة", "ماسة", "ماسة مع نقطة", "مشاعر", "ورد"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("বিন\u{9cd}দ\u{9c1}সহ হীৰ\u{9be}"),
            keywords: &[
                "কমিক",
                "জ\u{9cd}য\u{9be}মিতিক",
                "বিন\u{9cd}দ\u{9c1}সহ হীৰ\u{9be}",
                "ভিতৰত",
                "হীৰ\u{9be}",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("nöqtəli romb"),
            keywords: &["daxili", "həndəsi", "komik", "nöqtəli romb", "romb"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("ромб з кропкай"),
            keywords: &["аб’ект", "геаметрычны", "кропка", "ромб", "ромб з кропкай"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Ромб с точка в средата"),
            keywords: &["Ромб с точка в средата", "геометричен", "комикс", "ромб"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("একটি ডটের স\u{9be}থে হীরে"),
            keywords: &[
                "একটি ডটের স\u{9be}থে হীরে",
                "কমিক",
                "জ\u{9cd}য\u{9be}মিতিক",
                "ড\u{9be}য\u{9bc}মন\u{9cd}ড",
                "ভিতরে",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("romb sa tačkom u sredini"),
            keywords: &[
                "geometrija",
                "romb",
                "romb sa tačkom u sredini",
                "tačka",
                "unutra",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("rombe amb punt"),
            keywords: &["flor", "geometria", "pètals", "rombe", "rombe amb punt"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᏥᏍᏓᎷᎩᏍᎩ ᎤᏓᏓᏟ"),
            keywords: &["ᎤᏙᏢᏒ", "ᎤᏥᏍᏓᎷᎩᏍᎩ ᎤᏓᏓᏟ", "ᎤᏬᏟᏗ", "ᎦᎸᏉᏗ ᏅᏯ", "ᏐᎭᏫᏂ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("kosočtverec s tečkou"),
            keywords: &[
                "geometrie",
                "kosočtverec",
                "kosočtverec s tečkou",
                "obrázek",
                "uvnitř",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("diemwnt â dot"),
            keywords: &["comig", "diemwnt", "diemwnt â dot", "geometric", "tu fewn"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("ruder med prik"),
            keywords: &["geometisk", "ruder", "ruder med prik"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Rautenform mit Punkt"),
            keywords: &["Diamant", "Rautenform", "Rautenform mit Punkt", "mit Punkt"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ρόμβος με τελεία"),
            keywords: &[
                "γεωμετρικό",
                "διαμάντι",
                "κόμικ",
                "μέσα",
                "ρόμβος με τελεία",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("diamond with a dot"),
            keywords: &[
                "comic",
                "diamond",
                "diamond with a dot",
                "geometric",
                "inside",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("rombo con pétalo"),
            keywords: &["flor", "geometría", "rombo", "rombo con pétalo"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &[
                "cómic",
                "diamante",
                "flor",
                "pétalo de flor",
                "rombo con pétalo",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("diamante en flor"),
            keywords: &[
                "cómic",
                "diamante",
                "diamante en flor",
                "flor",
                "rombo en flor",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("rombo con un punto"),
            keywords: &[
                "cómico",
                "dentro",
                "diamante",
                "geométrico",
                "rombo",
                "rombo con un punto",
            ],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("punktiga romb"),
            keywords: &[
                "geomeetria",
                "koomiks",
                "punktiga romb",
                "romb",
                "sees",
                "teemant",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("puntu bat duen diamantea"),
            keywords: &[
                "barnealde",
                "diamante",
                "geometriko",
                "komiki",
                "puntu bat duen diamantea",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("لوزی نقطه\u{200c}دار"),
            keywords: &[
                "درون",
                "شکل هندسی",
                "لوزی",
                "لوزی نقطه\u{200c}دار",
                "مصور",
                "نقطه",
                "کمیک",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("vinoneliö/kukka"),
            keywords: &["kukka", "muoto", "vinoneliö", "vinoneliö/kukka"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("diamond na may tuldok"),
            keywords: &[
                "diamante",
                "diamond na may tuldok",
                "hugis",
                "maganda",
                "makinang",
                "maliit",
                "tuldok",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("krossaður diamantur"),
            keywords: &["diamantur", "krossaður diamantur", "mátingarfrøðiligur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("diamant avec un point"),
            keywords: &[
                "dessin",
                "diamant",
                "diamant avec un point",
                "géométrique",
                "intérieur",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("muileata le ponc"),
            keywords: &["diamant", "muileata", "muileata le ponc"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("daoimean le dotag na bhroinn"),
            keywords: &[
                "a-staigh",
                "daoimean",
                "daoimean le dotag na bhroinn",
                "dealbh-èibhinn",
                "geomatrach",
                "na bhroinn",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("rombo en forma de flor"),
            keywords: &["flor", "punto", "rombo", "rombo en forma de flor"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ડાયમ\u{a82}ડ આકાર"),
            keywords: &[
                "ડાયમ\u{a82}ડ",
                "ડાયમ\u{a82}ડ આકાર",
                "પ\u{ac1}ષ\u{acd}પ",
                "પ\u{ac1}ષ\u{acd}પની પા\u{a82}ખડી",
                "લાગણી",
                "સ\u{ac1}\u{a82}દર",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("daimun tare da ɗigo"),
            keywords: &[
                "ciki",
                "daimun",
                "daimun tare da ɗigo",
                "ilimin halayen sura",
                "mai ban dariya",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("מעוין כחול עם נקודה"),
            keywords: &["בפנים", "כחול", "מעוין", "מעוין כחול עם נקודה", "צורה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("डॉट वाला हीरा"),
            keywords: &[
                "ज\u{94d}यामिति",
                "डायम\u{902}ड",
                "डॉट क\u{947} साथ हीरा",
                "डॉट वाला हीरा",
                "हीरा",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("romb s točkom"),
            keywords: &["geometrija", "romb", "romb s točkom", "unutra"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("rombusz ponttal"),
            keywords: &["alakzat", "képregény", "rombusz", "rombusz ponttal"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("կետով շեղանկյուն"),
            keywords: &[
                "երկրաչափական",
                "կետով շեղանկյուն",
                "կոմիքս",
                "ներսում",
                "շեղանկյուն",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("wajik bertitik"),
            keywords: &["di dalam", "geometri", "komik", "wajik", "wajik bertitik"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("diamond nwere kpọm"),
            keywords: &[
                "diamond",
                "diamond nwere kpọm",
                "mgbakọ",
                "mkpaọchị",
                "n’ime",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("blóm með punkti"),
            keywords: &[
                "blóm með punkti",
                "sætt",
                "tilfinningar",
                "tígull",
                "tígullaga",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("petalo di fiore"),
            keywords: &[
                "carino",
                "diamante",
                "emozione",
                "fiore",
                "forma di diamante",
                "petalo di fiore",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ドット付きひし形"),
            keywords: &["ひし形", "ダイア", "ダイヤ", "ドット付きひし形"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("kupatan mawa titik ing tengah"),
            keywords: &[
                "geometrik",
                "komik",
                "kupatan",
                "kupatan mawa titik ing tengah",
                "njero",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("რომბი წერტილით"),
            keywords: &[
                "გეომეტრია",
                "გეომეტრიული",
                "რომბი",
                "რომბი წერტილით",
                "სასაცილო",
                "შიგნით",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("нүктелі ромб"),
            keywords: &["геометриялық", "комик", "нүктелі ромб", "ромб", "ішкі"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("diamant med prik"),
            keywords: &["diamant med prik", "følelse"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ពេជ\u{17d2}រមានច\u{17c6}ន\u{17bb}ចប\u{17bd}ន"),
            keywords: &[
                "ច\u{17c6}ន\u{17bb}ច",
                "ប\u{17bd}ន",
                "ពេជ\u{17d2}រ",
                "ពេជ\u{17d2}រមានច\u{17c6}ន\u{17bb}ចប\u{17bd}ន",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಒಂದು ಬ\u{cbf}ಂದುವ\u{cbf}ನೊಂದ\u{cbf}ಗ\u{cc6} ವಜ\u{ccd}ರ"),
            keywords: &[
                "ಒಂದು ಡಾಟ\u{ccd}ನೊಂದ\u{cbf}ಗ\u{cc6} ವಜ\u{ccd}ರ",
                "ಒಂದು ಬ\u{cbf}ಂದುವ\u{cbf}ನೊಂದ\u{cbf}ಗ\u{cc6} ವಜ\u{ccd}ರ",
                "ಒಳಗ\u{cc6}",
                "ಕಾಮ\u{cbf}ಕ\u{ccd}",
                "ಜ\u{ccd}ಯಾಮ\u{cbf}ತೀಯ",
                "ವಜ\u{ccd}ರ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("점이 찍힌 다이아몬드 모양"),
            keywords: &["다이아몬드 모양", "마름모꼴", "점이 찍힌 다이아몬드 모양"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("बि\u{902}द\u{942} सयत हिरो"),
            keywords: &[
                "जियोम\u{945}ट\u{94d}रीक",
                "बि\u{902}द\u{942} सयत हिरो",
                "भितर",
                "विनोदी",
                "हिरो",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("чекиттүү ромб"),
            keywords: &["геометрия", "комикс", "ромб", "чекиттүү ромб"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Raut mat engem Punkt an der Mëtt"),
            keywords: &[
                "Comic",
                "Raut",
                "Raut mat engem Punkt an der Mëtt",
                "geometresch",
                "rout",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຮ\u{eb9}ບເພ\u{eb1}ດມ\u{eb5}ຈ\u{eb8}ດ"),
            keywords: &[
                "ຈ\u{eb8}ດ",
                "ຮ\u{eb9}ບເພ\u{eb1}ດມ\u{eb5}ຈ\u{eb8}ດ",
                "ເພ\u{eb1}ດ",
                "ເລຂາຄະນ\u{eb4}ດ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("deimantas su tašku"),
            keywords: &[
                "deimantas",
                "deimantas su tašku",
                "geometrija",
                "komiksas",
                "viduje",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("rombs ar punktu"),
            keywords: &["rombs", "rombs ar punktu", "ģeometrija"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("taimana whai ira"),
            keywords: &[
                "roto",
                "taimana",
                "taimana whai ira",
                "whakakata",
                "āhuahanga",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("дијамант со точка"),
            keywords: &[
                "геометрија",
                "дијамант",
                "дијамант со точка",
                "син",
                "точка",
            ],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഒര\u{d41} പ\u{d41}ള\u{d4d}ളിയ\u{d41}ള\u{d4d}ള ഡയമണ\u{d4d}ട\u{d4d}"),
            keywords: &[
                "ഒര\u{d41} പ\u{d41}ള\u{d4d}ളിയ\u{d41}ള\u{d4d}ള ഡയമണ\u{d4d}ട\u{d4d}",
                "പ\u{d42}വിതൾ",
                "പ\u{d42}വ\u{d4d}",
                "ഭംഗി",
                "വിക\u{d3e}രം",
                "വൈരക\u{d4d}കല\u{d4d}ലിന\u{d4d}റെ ആക\u{d43}തി",
                "വൈരക\u{d4d}കല\u{d4d}ല\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("дундаа цэгтэй алмааз"),
            keywords: &[
                "алмааз",
                "геометр",
                "дотор",
                "дундаа цэгтэй алмааз",
                "комик",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("बि\u{902}द\u{942} असल\u{947}ला डायम\u{902}ड"),
            keywords: &[
                "अ\u{902}तर\u{94d}भाग",
                "कॉमिक",
                "डायम\u{902}ड",
                "बि\u{902}द\u{942} असल\u{947}ला डायम\u{902}ड",
                "भ\u{942}मितीय",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("berlian berbintik"),
            keywords: &[
                "berlian",
                "berlian berbintik",
                "di dalam",
                "geometri",
                "komik",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("djamant b’tikka"),
            keywords: &[
                "djamant b’tikka",
                "djamanti",
                "komiku",
                "ġeometrika",
                "ġewwa",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အစက\u{103a}ပါ စ\u{102d}န\u{103a}"),
            keywords: &[
                "ဂျ\u{102e}ဩမေတြ\u{102e}",
                "စ\u{102d}န\u{103a}",
                "ဟာသ",
                "အစက\u{103a}ပါ စ\u{102d}န\u{103a}",
                "အတ\u{103d}င\u{103a}းပ\u{102d}\u{102f}င\u{103a}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("diamant med prikk"),
            keywords: &["blomst", "diamant", "diamant med prikk", "søtt"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("डटसहितको हिरा"),
            keywords: &[
                "ज\u{94d}यामितीय",
                "डटसहितको हिरा",
                "भित\u{94d}र",
                "ह\u{901}साउन\u{947}",
                "हिरा",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("ruitvorm met stip erin"),
            keywords: &[
                "binnen",
                "geometrisch",
                "ruit",
                "ruitvorm met stip erin",
                "strip",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("diamant med prikk"),
            keywords: &["blomst", "diamant", "diamant med prikk", "søtt"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଏକ ବ\u{b3f}ନ\u{b4d}ଦ\u{b41} ସହ\u{b3f}ତ ହୀର\u{b3e}"),
            keywords: &[
                "ଏକ ବ\u{b3f}ନ\u{b4d}ଦ\u{b41} ସହ\u{b3f}ତ ହୀର\u{b3e}",
                "କମ\u{b3f}କ\u{b4d}\u{200c}",
                "ଜ\u{b4d}ୟ\u{b3e}ମ\u{b3f}ତ\u{b3f}କ",
                "ଭ\u{b3f}ତର ପ\u{b3e}ର\u{b4d}ଶ\u{b4d}ଵ",
                "ହୀର\u{b3e}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਬਿ\u{a70}ਦ\u{a42} ਨਾਲ ਹੀਰਾ"),
            keywords: &[
                "ਕਾਮਿਕ",
                "ਜਯਾਮਿਤੀ",
                "ਫ\u{a41}\u{a71}ਲ",
                "ਬਿ\u{a70}ਦ\u{a42} ਨਾਲ ਹੀਰਾ",
                "ਸ\u{a4b}ਹਣਾ",
                "ਹੀਰਾ",
                "ਹੀਰ\u{a47} ਦਾ ਅਕਾਰ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("اک نقطے نال ہیرا"),
            keywords: &[
                "اندرون",
                "اک نقطے نال ہیرا",
                "جیومیٹری دے متعلق",
                "م\u{64f}ضح\u{650}کہ خیز",
                "پیرا",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Dáyámọnd Wit Dọt Fọ Mídul"),
            keywords: &[
                "Dáyámọnd",
                "Dáyámọnd Wit Dọt Fọ Mídul",
                "Jiọ\u{301}mẹ\u{301}tri",
                "Ínsaid",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("romb z kropką"),
            keywords: &["klejnot", "romb", "romb z kropką"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("الماس د ټکي سره"),
            keywords: &["الماس", "الماس د ټکي سره", "جيوميتريکي", "دننه", "کامک"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("diamante com um ponto"),
            keywords: &[
                "cômico",
                "dentro",
                "diamante",
                "diamante com ponto",
                "diamante com um ponto",
                "geométrico",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("losango com um ponto"),
            keywords: &[
                "desenho",
                "geométrico",
                "interior",
                "losango",
                "losango com um ponto",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("romb cu punct în centru"),
            keywords: &[
                "bandă desenată",
                "geometric",
                "interior",
                "romb",
                "romb cu punct în centru",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-605"),
            keywords: &["E10-605"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("ромб с точкой"),
            keywords: &["геометрия", "ромб", "ромб с точкой", "точка", "фигура"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ikaro ifite akadomo"),
            keywords: &[
                "bisekeje",
                "byerekeye jewometiri",
                "diyama",
                "ikaro ifite akadomo",
                "mo imbere",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("هڪ نقطي سان گڏ هيرو"),
            keywords: &["اندر", "جيوميٽرڪ", "هيرو", "هڪ نقطي سان گڏ هيرو", "چوڻي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ත\u{dd2}තක\u{dca} සහ\u{dd2}ත ද\u{dd2}යමන\u{dca}ත\u{dd2}ය"),
            keywords: &[
                "ඇත\u{dd4}ළත",
                "ජ\u{dca}\u{200d}ය\u{dcf}ම\u{dd2}ත\u{dd2}ක",
                "ත\u{dd2}තක\u{dca} සහ\u{dd2}ත ද\u{dd2}යමන\u{dca}ත\u{dd2}ය",
                "ද\u{dd2}යමන\u{dca}ත\u{dd2}ය",
                "ව\u{dd2}හ\u{dd2}ළ\u{dd4}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("kosoštvorec s bodkou"),
            keywords: &["diamant", "geometria", "kosoštvorec s bodkou", "vnútri"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("karo s piko"),
            keywords: &["geometrično", "karo", "karo s piko", "strip", "znotraj"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("dheeman leh dhibic"),
            keywords: &[
                "dheeman",
                "dheeman aan lahayn dhibic",
                "dheeman leh dhibic",
                "gudaha",
                "joometriyeed",
                "majaajilo",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("diamant me një pikë"),
            keywords: &[
                "brenda",
                "diamant",
                "diamant me një pikë",
                "gjeometrik",
                "vizatim komik",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("ромб са тачком"),
            keywords: &["гeoмeтриja", "рoмб", "ромб са тачком", "унутрa"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("romb sa tačkom"),
            keywords: &["geometrija", "romb", "romb sa tačkom", "unutra"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("diamantform med en prick"),
            keywords: &[
                "blomblad",
                "diamant",
                "diamantform",
                "diamantform med en prick",
                "känslor",
            ],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("almasi yenye kitone"),
            keywords: &[
                "almasi",
                "almasi yenye kitone",
                "jiometri",
                "kibonzo",
                "ndani",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பூ இதழ\u{bcd} வைர வடிவம\u{bcd}"),
            keywords: &[
                "பூ இதழ\u{bcd} வைர வடிவம\u{bcd}",
                "பூவிதழ\u{bcd}",
                "பூவிதழ\u{bcd} வைர வடிவம\u{bcd}",
                "வைரம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("చతుర\u{c4d}భుజ\u{c3e}క\u{c3e}రం మధ\u{c4d}యల\u{c4b} చుక\u{c4d}క"),
            keywords: &[
                "చతుర\u{c4d}భుజ\u{c3e}క\u{c3e}రం మధ\u{c4d}యల\u{c4b} చుక\u{c4d}క",
                "పుష\u{c4d}పం",
                "వజ\u{c4d}ర\u{c3e}క\u{c3e}రం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("алмос бо як нуқта"),
            keywords: &[
                "алмос",
                "алмос бо як нуқта",
                "геометрӣ",
                "дарун",
                "мазҳакавӣ",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ข\u{e49}าวหลามต\u{e31}ดม\u{e35}จ\u{e38}ดตรงกลาง"),
            keywords: &[
                "ข\u{e49}าวหลามต\u{e31}ด",
                "ข\u{e49}าวหลามต\u{e31}ดม\u{e35}จ\u{e38}ดตรงกลาง",
                "เพชร",
                "เรขาคณ\u{e34}ต",
            ],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ኣልማዝ ምስ ዶት"),
            keywords: &["መስሓቕ", "ኣልማዝ", "ኣልማዝ ምስ ዶት", "ኣብ ውሽጢ", "ጂኦሜትሪክ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("nokatly pişme"),
            keywords: &["almaz", "geometrik", "gülkünç", "içi", "nokatly pişme"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("taiamoni moe ʻila"),
            keywords: &["taiamoni", "taiamoni moe ʻila", "ʻila"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("içinde noktalı karo"),
            keywords: &[
                "baklava",
                "geometrik",
                "içinde noktalı baklava şekli",
                "içinde noktalı karo",
                "karo",
                "çizgi roman",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("چېكىتلىك رومبا"),
            keywords: &[
                "ئىچكى",
                "رومبا",
                "كۈلكىلىك",
                "چېكىتلىك رومبا",
                "گېئومېتىرىيە",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("ромб із крапкою"),
            keywords: &[
                "геометричний",
                "діамант",
                "крапка",
                "малюнок",
                "ромб із крапкою",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("نکتے والا ہیرا"),
            keywords: &["جیومیٹری", "نکتہ", "نکتے والا ہیرا", "ہیرا"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("nuqtali romb"),
            keywords: &["geometrik", "ichki", "latifa", "nuqtali romb", "romb"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("hình thoi có dấu chấm"),
            keywords: &[
                "bên trong",
                "hài hước",
                "hình học",
                "hình thoi",
                "hình thoi có chấm",
                "hình thoi có dấu chấm",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("karo bu ànd ak tomb"),
            keywords: &[
                "ci biir",
                "karo",
                "karo bu ànd ak tomb",
                "reelu",
                "wu-geometri",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("idayimani enechaphaza"),
            keywords: &[
                "ehlekisayo",
                "idayimani",
                "idayimani enechaphaza",
                "ijiyometriki",
                "ngaphakathi",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Diamọndi Pẹlu Dọti Kan"),
            keywords: &[
                "Diamọndi Pẹlu Dọti Kan",
                "Díámọ\u{301}ndì",
                "apanilé\u{329}rìn-ín",
                "inú ilé",
                "jiomẹ\u{301}tíríkì",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("有點嘅菱形"),
            keywords: &["內", "幾何", "有點嘅菱形", "漫畫", "菱形"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("有点嘅菱形"),
            keywords: &["内", "几何", "有点嘅菱形", "漫画", "菱形"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("带圆点的菱形"),
            keywords: &["中心", "内部", "圆", "带圆点的菱形", "梅花形"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("菱形加圓點"),
            keywords: &["菱形加圓點", "鑽石"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("中間有一點嘅菱形"),
            keywords: &["中間有一點嘅菱形", "鑽石"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("idayimande elingenachashashi"),
            keywords: &[
                "idayimande",
                "idayimande elingenachashashi",
                "jiyometrikhi",
                "ngaphakathi",
                "okuhlekisayo",
            ],
        },
    ],
};
#[doc = "🔘"]
pub const RADIO_BUTTON: crate::Emoji = crate::Emoji {
    glyph: "🔘",
    codepoint: "1F518",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "radio button",
    group: "Symbols",
    subgroup: "geometric",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("radioknoppie"),
            keywords: &["geometries", "knoppie", "radio", "radioknoppie"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የሬዲዮ አዝራር"),
            keywords: &["ሬዲዮ", "አዝራር", "የሬዲዮ አዝራር", "ጂኦሜትሪያዊ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("زر تبادلي"),
            keywords: &["تبادلي", "زر"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ৰেডিঅ’ ব\u{9c1}ট\u{9be}ম"),
            keywords: &["জ\u{9cd}য\u{9be}মিতিক", "ব\u{9c1}ট\u{9be}ম", "ৰেডিঅ’"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("radio düyməsi"),
            keywords: &["düymə", "həndəsi", "radio", "radio düyməsi"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("пераключальнік"),
            keywords: &["аб’ект", "выбар", "геаметрычны", "кнопка", "пераключальнік"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Бутон за избор"),
            keywords: &["Бутон за избор", "бутон", "геометричен", "избор"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("রেডিও বোত\u{9be}ম"),
            keywords: &["জ\u{9cd}য\u{9be}মিতিক", "বোত\u{9be}ম", "রেডিও"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("bouton radio"),
            keywords: &["bouton radio"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("radio dugme"),
            keywords: &["geometrija", "radio", "radio dugme", "tipka"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("botó d’opció"),
            keywords: &["botó", "botó d’opció", "geometria", "opció"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏗᎧᏃᎩᏍᏗ ᎦᏗ"),
            keywords: &["ᎤᏙᏢᏒ", "ᎦᏗ", "ᏗᎧᏃᎩᏍᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("přepínač"),
            keywords: &[
                "geometrie",
                "kulaté",
                "přepínací",
                "přepínač",
                "rádio",
                "tlačítko",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("botwm radio"),
            keywords: &["botwm", "geometrig", "radio"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("alternativknap"),
            keywords: &["alternativknap"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Optionsfeld"),
            keywords: &["Optionsfeld", "Schaltfläche"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("στρογγυλό κουμπί"),
            keywords: &["γεωμετρικό", "κουμπί", "στρογγυλό κουμπί"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("radio button"),
            keywords: &["button", "geometric", "radio"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("botón de opción"),
            keywords: &["botón", "botón de opción", "opción"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["botón", "botón de opción", "botón de radio", "radio"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("raadionupp"),
            keywords: &["geomeetria", "nupp", "raadio", "raadionupp"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("kontrol-laukia"),
            keywords: &["botoi", "geometriko", "kontrol", "kontrol-laukia"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("دکمه\u{654} رادیویی"),
            keywords: &["دکمه", "دکمه\u{654} رادیویی", "رادیو", "شکل هندسی"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("valintanappi"),
            keywords: &["muoto", "valinta", "valintanappi", "valintaruutu", "ympyrä"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("button ng radyo"),
            keywords: &["bilog", "buton", "button ng radyo", "hugis", "radyo"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("radioknappur"),
            keywords: &["radioknappur", "radioknøttur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("bouton radio"),
            keywords: &["bouton", "forme", "géométrie", "radio"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("cnaipe raidió"),
            keywords: &["cnaipe raidió"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("putan-rèidio"),
            keywords: &["geomatrach", "putan", "putan-rèidio", "rèidio"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("botón de opción"),
            keywords: &["botón", "botón de opción", "opción"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ર\u{ac7}ડિઓ બટન"),
            keywords: &["બટન", "ર\u{ac7}ડિઓ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("maɓallin rediyo"),
            keywords: &["ilimin halayen sura", "maɓallin", "rediyo"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("לחצן רדיו"),
            keywords: &["לחצן", "עיגול", "צורה", "רדיו"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("र\u{947}डियो बटन"),
            keywords: &["ज\u{94d}यामिति", "बटन", "र\u{947}डियो"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("kružić za označavanje"),
            keywords: &["geometrija", "kružić", "kružić za označavanje"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("választógomb"),
            keywords: &["gomb", "rádiógomb", "választó", "választógomb"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("կետակոճակ"),
            keywords: &["երկրաչափական", "կետ", "կետակոճակ", "կոճակ", "ռադիո"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("tombol radio"),
            keywords: &["geometri", "radio", "tombol"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ọdụmbi redio"),
            keywords: &["mgbakọ", "redio", "ọdụmbi"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("valhnappur"),
            keywords: &["hnappur", "valhnappur"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("pulsante rotondo"),
            keywords: &["opzione", "pulsante", "pulsante rotondo"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ラジオボタン"),
            keywords: &["ボタン", "ラジオボタン", "二重丸"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("tombol radio"),
            keywords: &["geometrik", "radio", "tombol"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("რადიო ღილაკი"),
            keywords: &["გეომეტრია", "გეომეტრიული", "რადიო", "ღილაკი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("радио түймесі"),
            keywords: &["геометриялық", "радио", "радио түймесі", "түйме"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("knap"),
            keywords: &["alternativknap", "knap"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some(
                "ប\u{17ca}\u{17bc}ត\u{17bb}ងម\u{17bc}លផ\u{17bb}សចេញព\u{17b8}ប\u{17ca}\u{17bc}ត\u{17bb}ងធ\u{17c6}",
            ),
            keywords: &[
                "ប\u{17ca}\u{17bc}ត\u{17bb}ង",
                "ប\u{17ca}\u{17bc}ត\u{17bb}ងម\u{17bc}ល",
                "ប\u{17ca}\u{17bc}ត\u{17bb}ងម\u{17bc}លផ\u{17bb}សចេញព\u{17b8}ប\u{17ca}\u{17bc}ត\u{17bb}ងធ\u{17c6}",
                "ផ\u{17bb}ស",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ರೇಡ\u{cbf}ಯೊ ಬಟನ\u{ccd}"),
            keywords: &[
                "ಜ\u{ccd}ಯಾಮ\u{cbf}ತೀಯ",
                "ಬಟನ\u{ccd}",
                "ರೇಡ\u{cbf}`ಯೊ``",
                "ರೇಡ\u{cbf}ಯೊ ಬಟನ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("라디오 버튼"),
            keywords: &["라디오", "버튼"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("र\u{947}डियो बटण"),
            keywords: &["जियोम\u{945}ट\u{94d}रीक", "बटण", "र\u{947}डियो"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("радио баскычы"),
            keywords: &["баскыч", "геометрия", "радио", "радио баскычы"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Optiounsknäppchen"),
            keywords: &["Knäppchen", "Optiounen", "Optiounsknäppchen", "geometresch"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ປ\u{eb8}\u{ec8}ມວ\u{eb4}ທະຍ\u{eb8}"),
            keywords: &[
                "ປ\u{eb8}\u{ec8}ມ",
                "ປ\u{eb8}\u{ec8}ມວ\u{eb4}ທະຍ\u{eb8}",
                "ວ\u{eb4}ທະຍ\u{eb8}",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("akutė"),
            keywords: &["akutė", "geometrija", "mygtukas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("radiopoga"),
            keywords: &["opcijas", "poga", "radiopoga"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pātene irirangi"),
            keywords: &["irirangi", "pātene", "āhuahanga"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("тркалезно копче"),
            keywords: &["копче", "круг", "тркалезно копче"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("റേഡിയോ ബട\u{d4d}ടൺ"),
            keywords: &["ബട\u{d4d}ടൺ", "റേഡിയോ"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("бөөрөнхий товчлуур"),
            keywords: &["бөөрөнхий товчлуур", "геометр", "радио", "товчлуур"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("र\u{947}डिओ बटण"),
            keywords: &["बटण", "भ\u{942}मितीय", "र\u{947}डिओ"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("butang radio"),
            keywords: &["butang", "geometri", "radio"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("buttuna tal-għażla"),
            keywords: &["buttuna", "buttuna tal-għażla", "radju", "ġeometrika"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ရေဒ\u{102e}ယ\u{102d}\u{102f} ခလ\u{102f}တ\u{103a}"),
            keywords: &[
                "ခလ\u{102f}တ\u{103a}",
                "ဂျ\u{102e}ဩမေတြ\u{102e}",
                "ရေဒ\u{102e}ယ\u{102d}\u{102f}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("radioknapp"),
            keywords: &["knapp", "radio", "radioknapp"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("र\u{947}डियो बटन"),
            keywords: &["ज\u{94d}यामितीय", "बटन", "र\u{947}डियो"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("keuzerondje"),
            keywords: &["geometrisch", "keuze", "keuzerondje", "rondje"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("radioknapp"),
            keywords: &["knapp", "radio", "radioknapp"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ରେଡ\u{b3f}ଓ ବଟନ\u{b4d}\u{200c}"),
            keywords: &[
                "ଜ\u{b4d}ୟ\u{b3e}ମ\u{b3f}ତ\u{b3f}କ",
                "ବଟନ\u{b4d}\u{200c}",
                "ରେଡ\u{b3f}ଓ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਰ\u{a47}ਡੀਓ ਬਟਨ"),
            keywords: &["ਜਯਾਮਿਤੀ", "ਬਟਨ", "ਰ\u{a47}ਡੀਓ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ریڈیو بٹن"),
            keywords: &["بٹن", "جیومیٹری دے متعلق", "ريڈيو", "ریڈیو بٹن"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Rédió Bọ\u{301}tin"),
            keywords: &["Bọ\u{301}tin", "Jiọ\u{301}mẹ\u{301}tri", "Rédió"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("przycisk radiowy"),
            keywords: &[
                "figura geometryczna",
                "kółko",
                "przycisk radiowy",
                "przycisk wyboru opcji",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د راديو بټن"),
            keywords: &["بټن", "جيوميتريکي", "د راديو بټن", "راديو"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("botão de opção"),
            keywords: &["botão", "botão de opção", "rádio"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["botão", "botão de opção", "geométrico", "opção"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("buton radio"),
            keywords: &["buton", "geometric", "radio"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-724"),
            keywords: &["E10-724"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("круглая кнопка"),
            keywords: &["кнопка", "круглая", "серая"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("buto ya radiyo"),
            keywords: &[
                "buto ya radiyo",
                "byerekeye jewometiri",
                "ibuto",
                "inyakiramajwi",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ريڊيو بٽڻ"),
            keywords: &["بٽڻ", "جيوميٽرڪ", "ريڊيو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("රේඩ\u{dd2}යෝ බොත\u{dca}තම"),
            keywords: &[
                "ජ\u{dca}\u{200d}ය\u{dcf}ම\u{dd2}ත\u{dd2}ක",
                "බොත\u{dca}තම",
                "රේඩ\u{dd2}යෝ බොත\u{dca}තම",
                "රේඩ\u{dd2}යෝව",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("okrúhle tlačidlo"),
            keywords: &["geometria", "okrúhle tlačidlo", "otáčacie", "tlačidlo"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("izbirni gumb"),
            keywords: &["geometrično", "gumb", "izbirni"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("badhan raadiye"),
            keywords: &["badhan", "joometriyeed", "raadiye"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("buton radioje"),
            keywords: &["buton", "buton radioje", "gjeometrik", "radio"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("дугме за избор"),
            keywords: &["геометрија", "дугме", "дугме за избор"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["дугме за избор"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("dugme za izbor"),
            keywords: &["dugme", "dugme za izbor", "geometrija"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["dugme za izbor"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("alternativknapp"),
            keywords: &["alternativknapp", "knapp"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kitufe"),
            keywords: &["jiometri", "kitufe"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ரேடியோ பட\u{bcd}டன\u{bcd}"),
            keywords: &[
                "பட\u{bcd}டன\u{bcd}",
                "பொத\u{bcd}த\u{bbe}ன\u{bcd}",
                "ரேடியோ பட\u{bcd}டன\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ర\u{c47}డ\u{c3f}య\u{c4b} బటన\u{c4d}"),
            keywords: &["బటన\u{c4d}", "ర\u{c47}డ\u{c3f}య\u{c4b}"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("тугмаи \"Радио\""),
            keywords: &["геометрӣ", "радио", "тугма", "тугмаи \"Радио\""],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ป\u{e38}\u{e48}มว\u{e34}ทย\u{e38}"),
            keywords: &[
                "ป\u{e38}\u{e38}\u{e48}ม",
                "ป\u{e38}\u{e48}มว\u{e34}ทย\u{e38}",
                "ว\u{e34}ทย\u{e38}",
            ],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("መልጎም ናይ ራድዮ"),
            keywords: &["መልጎም", "መልጎም ናይ ራድዮ", "ራድዮ", "ጂኦሜትሪክ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("radio düwmesi"),
            keywords: &["düwme", "geometrik", "radio", "radio düwmesi"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("meʻalolomi lētio"),
            keywords: &["lētio", "meʻalolomi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("radyo düğmesi"),
            keywords: &["düğme", "radyo", "radyo düğmesi"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("يۇمىلاق كۇنۇپكا"),
            keywords: &["رادىيۇس", "كۇنۇپكا", "يۇمىلاق كۇنۇپكا", "گېئومېتىرىيە"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("перемикач"),
            keywords: &["геометричний", "кнопка", "перемикач"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ریڈیو بٹن"),
            keywords: &["بٹن", "جیومیٹری", "ریڈیو"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("radio tugma"),
            keywords: &["geometrik", "radio", "tugma"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("nút radio"),
            keywords: &["hình học", "nút", "radio"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("bitoŋu rajo"),
            keywords: &["bitoŋ", "bitoŋu rajo", "radio", "wu-geometri"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("iqhosha lerediyo"),
            keywords: &["ijiyometriki", "iqhosha", "iqhosha lerediyo", "irediyo"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Bọ\u{301}tìnnì Rédíò"),
            keywords: &[
                "Bó\u{329}tìnì",
                "Bọ\u{301}tìnnì Rédíò",
                "jiomẹ\u{301}tíríkì",
                "rédíò",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("圓形按鈕"),
            keywords: &["圓形", "圓形按鈕", "幾何", "按鈕"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("圆形按钮"),
            keywords: &["几何", "圆形", "圆形按钮", "按钮"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("单选按钮"),
            keywords: &["单独", "单选按钮", "圆心", "按键", "选中"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("按鈕"),
            keywords: &["圓鈕", "按鈕"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("圓形按鈕"),
            keywords: &["圓形按鈕", "按鈕"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("inkinobho yomsakazo"),
            keywords: &[
                "inkinobho",
                "inkinobho yomsakazo",
                "jiyometrikhi",
                "umsakazo",
            ],
        },
    ],
};
#[doc = "🔳"]
pub const WHITE_SQUARE_BUTTON: crate::Emoji = crate::Emoji {
    glyph: "🔳",
    codepoint: "1F533",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "white square button",
    group: "Symbols",
    subgroup: "geometric",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("wit vierkant-knoppie"),
            keywords: &[
                "geometries",
                "knoppie",
                "vierkant",
                "wit buitelyn",
                "wit vierkant-knoppie",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("በነጭ የተከበበ ካሬ አዝራር"),
            keywords: &["በነጭ የተከበበ ካሬ አዝራር", "አዝራር", "ካሬ", "የተነደፈ", "ጂኦሜትሪያዊ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("زر مربع أبيض"),
            keywords: &["زر", "زر مربع أبيض", "مربع"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("বগ\u{9be} বৰ\u{9cd}গ ব\u{9c1}ট\u{9be}ম"),
            keywords: &[
                "জ\u{9cd}য\u{9be}মিতিক",
                "বগ\u{9be} বৰ\u{9cd}গ ব\u{9c1}ট\u{9be}ম",
                "ব\u{9c1}ট\u{9be}ম",
                "বৰ\u{9cd}গ",
                "ৰেখ\u{9be}স\u{9c2}চিত",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("ağ kvadrat düymə"),
            keywords: &[
                "ağ kvadrat düymə",
                "düymə",
                "göstərilmiş",
                "həndəsi",
                "kvadrat",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("белая квадратная кнопка"),
            keywords: &[
                "аб’ект",
                "белая квадратная кнопка",
                "белы",
                "геаметрычны",
                "квадрат",
                "кнопка",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Квадратен бутон с бял контур"),
            keywords: &[
                "Квадратен бутон с бял контур",
                "бутон",
                "геометричен",
                "квадрат",
                "контур",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("স\u{9be}দ\u{9be} বর\u{9cd}গ\u{9be}ক\u{9be}র বোত\u{9be}ম"),
            keywords: &[
                "জ\u{9cd}য\u{9be}মিতিক",
                "বর\u{9cd}গ\u{9be}ক\u{9be}র",
                "বোত\u{9be}ম",
                "র\u{9c2}পরেখ\u{9be}",
                "স\u{9be}দ\u{9be} বর\u{9cd}গ\u{9be}ক\u{9be}র বোত\u{9be}ম",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("bijeli kvadrat dugme"),
            keywords: &[
                "bijeli kvadrat dugme",
                "geometrija",
                "kvadrat",
                "tipka",
                "u okviru",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("botó de quadrat blanc"),
            keywords: &[
                "blanc",
                "botó",
                "botó de quadrat blanc",
                "geometria",
                "quadrat",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᏁᎦ ᏅᎩ ᏧᏅᏏᏯ ᎦᏛ"),
            keywords: &["ᎤᏁᎦ ᏅᎩ ᏧᏅᏏᏯ ᎦᏛ", "ᎤᏙᏢᏒ", "ᎦᏗ", "ᎦᏱᏕᏱᏍᏗ", "ᏅᎩ ᏧᏅᏏᏱ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("bílé čtvercové tlačítko"),
            keywords: &[
                "bílé čtvercové tlačítko",
                "geometrie",
                "obrys",
                "tlačítko",
                "čtvercové",
                "čtverec",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("botwm sgwâr gwyn"),
            keywords: &[
                "amlinelliad",
                "botwm",
                "botwm sgwâr gwyn",
                "geometrig",
                "sgwâr",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("hvid kvadratisk knap"),
            keywords: &[
                "geometrisk",
                "hvid kvadratisk knap",
                "knap",
                "kvadrat",
                "omrids",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("weiße quadratische Schaltfläche"),
            keywords: &[
                "Schaltfläche",
                "quadratisch",
                "weiß",
                "weiße quadratische Schaltfläche",
            ],
        },
        #[cfg(feature = "de_CH")]
        crate::Annotation {
            lang: "de_CH",
            tts: Some("Weisse quadratische Schaltfläche"),
            keywords: &[
                "Schaltfläche",
                "Weisse quadratische Schaltfläche",
                "quadratisch",
                "weiss",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("λευκό τετράγωνο κουμπί"),
            keywords: &[
                "γεωμετρικό",
                "κουμπί",
                "λευκό τετράγωνο κουμπί",
                "με περίγραμμα",
                "τετράγωνο",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("white square button"),
            keywords: &[
                "button",
                "geometric",
                "outlined",
                "square",
                "white square button",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("botón cuadrado con borde blanco"),
            keywords: &["botón", "botón cuadrado con borde blanco", "cuadrado"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("cuadrado negro con borde blanco"),
            keywords: &[
                "blanco",
                "borde",
                "botón",
                "cuadrado",
                "cuadrado negro con borde blanco",
                "marco",
                "negro",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &[
                "borde",
                "botón",
                "cuadrado",
                "cuadrado negro con borde blanco",
                "marco",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &[
                "borde",
                "botón",
                "cuadrado",
                "cuadrado negro con borde blanco",
                "marco",
            ],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("valge ruudukujuline nupp"),
            keywords: &[
                "geomeetria",
                "nupp",
                "piirjoon",
                "ruut",
                "valge ruudukujuline nupp",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("karratu zuri itxurako botoia"),
            keywords: &[
                "botoi",
                "geometriko",
                "karratu",
                "karratu zuri itxurako botoia",
                "nabarmendu",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("دکمۀ مربع سفید"),
            keywords: &["توپ\u{64f}ر", "دکمه", "دکمۀ مربع سفید", "شکل هندسی", "مربع"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("valkoinen neliöruutu"),
            keywords: &[
                "muoto",
                "neliö",
                "valinta",
                "valintaruutu",
                "valkoinen neliöruutu",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("puting parisukat na button"),
            keywords: &[
                "buton",
                "hugis",
                "loob",
                "parisukat",
                "puti",
                "puting parisukat na button",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("hvítur fýrakantaður karmur"),
            keywords: &[
                "fýrakantur",
                "hvítur fýrakantaður karmur",
                "karmur",
                "mátingarfrøðiligur",
                "rútur",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("carré blanc"),
            keywords: &["bouton", "carré", "carré blanc", "forme", "géométrie"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("bouton représentant un carré blanc"),
            keywords: &[
                "bouton",
                "bouton représentant un carré blanc",
                "carré blanc",
                "géométrie",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("cearnóg bhán"),
            keywords: &["cearnóg bhán"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("putan geal ceàrnagach"),
            keywords: &[
                "ceàrnag",
                "ceàrnagach",
                "geomatrach",
                "oir-loidhne",
                "putan",
                "putan geal ceàrnagach",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("botón con cadrado branco"),
            keywords: &["botón", "botón con cadrado branco", "branco", "cadrado"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("સફ\u{ac7}દ ચોરસ બટન"),
            keywords: &["ચોરસ", "બટન", "સફ\u{ac7}દ ચોરસ બટન"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("maɓallin farin murabba’i"),
            keywords: &[
                "ilimin halayen sura",
                "mai rubutu a gefe",
                "maɓallin",
                "maɓallin farin murabba’i",
                "murabba’i",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("לחצן ריבוע לבן"),
            keywords: &[
                "לחצן",
                "לחצן ריבוע לבן",
                "מסגרת",
                "צורה",
                "ריבוע",
                "ריבוע לבן",
            ],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("सफ\u{93c}\u{947}द वर\u{94d}ग बटन"),
            keywords: &[
                "ज\u{94d}यामिति",
                "बटन",
                "वर\u{94d}ग",
                "सफ\u{93c}\u{947}द वर\u{94d}ग बटन",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("bijela uglata tipka"),
            keywords: &[
                "bijela uglata tipka",
                "geometrija",
                "gumb",
                "obris",
                "uglato",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("fehér, négyzet alakú gomb"),
            keywords: &[
                "bekeretezett",
                "fehér, négyzet alakú gomb",
                "gomb",
                "négyzet",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("սպիտակ քառակուսի կոճակ"),
            keywords: &[
                "երկրաչափական",
                "կոճակ",
                "ուրվագծված",
                "սպիտակ քառակուսի կոճակ",
                "քառակուսի",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("tombol persegi putih"),
            keywords: &[
                "garis luar",
                "geometri",
                "persegi",
                "tombol",
                "tombol persegi putih",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ọdụmbi sukwia ọcha"),
            keywords: &[
                "edepụtara",
                "mgbakọ",
                "sukwia",
                "ọdụmbi",
                "ọdụmbi sukwia ọcha",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("hvítur ferningslaga hnappur"),
            keywords: &["ferningur", "hnappur", "hvítur ferningslaga hnappur"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("tasto quadrato nero con bordo bianco"),
            keywords: &[
                "contorno",
                "pulsante",
                "pulsante quadrato con contorno",
                "tasto quadrato nero con bordo bianco",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("白枠四角"),
            keywords: &["ボタン", "四角ボタン", "正方形", "白枠四角"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("tombol kothak putih"),
            keywords: &[
                "garis pinggir cetha",
                "geometrik",
                "kothak",
                "tombol",
                "tombol kothak putih",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("თეთრი კვადრატული ღილაკი"),
            keywords: &[
                "გეომეტრია",
                "გეომეტრიული",
                "თეთრი კვადრატული ღილაკი",
                "კვადრატი",
                "კონტურიანი",
                "ღილაკი",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("ақ шаршы түймесі"),
            keywords: &[
                "ақ шаршы түймесі",
                "геометриялық",
                "сызулы",
                "түйме",
                "шаршы",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("hvid kvadratisk knap"),
            keywords: &[
                "geometrisk",
                "hvid kvadratisk knap",
                "knap",
                "kvadrat",
                "omrids",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some(
                "ប\u{17bd}នជ\u{17d2}រ\u{17bb}ងពណ\u{17cc}ខ\u{17d2}មៅនៅក\u{17d2}ន\u{17bb}ងប\u{17bd}នជ\u{17d2}រ\u{17bb}ងពណ\u{17cc}ស",
            ),
            keywords: &[
                "ខ\u{17d2}មៅ",
                "ប\u{17bd}នជ\u{17d2}រ\u{17bb}ង",
                "ប\u{17bd}នជ\u{17d2}រ\u{17bb}ងពណ\u{17cc}ខ\u{17d2}មៅនៅក\u{17d2}ន\u{17bb}ងប\u{17bd}នជ\u{17d2}រ\u{17bb}ងពណ\u{17cc}ស",
                "ស",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಬ\u{cbf}ಳ\u{cbf} ಚ\u{ccc}ಕದ ಬಟನ\u{ccd}"),
            keywords: &[
                "ಚ\u{ccc}ಕ",
                "ಜ\u{ccd}ಯಾಮ\u{cbf}ತೀಯ",
                "ಬಟನ\u{ccd}",
                "ಬ\u{cbf}ಳ\u{cbf} ಚದರ ಬಟನ\u{ccd}",
                "ಬ\u{cbf}ಳ\u{cbf} ಚ\u{ccc}ಕದ ಬಟನ\u{ccd}",
                "ವ\u{cbf}ವರಣಾತ\u{ccd}ಮಕ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("테두리가 하얀 사각 버튼"),
            keywords: &["버튼", "사각형", "테두리가 하얀 사각 버튼"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("धवो चवकोन बटण"),
            keywords: &[
                "चवकोन",
                "जियोम\u{945}ट\u{94d}रीक",
                "धवो चवकोन बटण",
                "बटण",
                "र\u{941}पर\u{947}खा",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("ак чарчы баскычы"),
            keywords: &[
                "ак чарчы баскычы",
                "алкакта",
                "баскыч",
                "геометрия",
                "чарчы",
            ],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("wäisse véiereckege Knäppchen"),
            keywords: &[
                "Knäppchen",
                "Kontur",
                "Quadrat",
                "geometresch",
                "wäisse véiereckege Knäppchen",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ປ\u{eb8}\u{ec8}ມສ\u{eb5}\u{ec8}ຫ\u{ebc}\u{ec8}ຽມຂາວ"),
            keywords: &[
                "ຂາວ",
                "ປ\u{eb8}\u{ec8}ມ",
                "ປ\u{eb8}\u{ec8}ມສ\u{eb5}\u{ec8}ຫ\u{ebc}\u{ec8}ຽມຂາວ",
                "ສ\u{eb5}\u{ec8}ຫ\u{ebc}\u{ec8}ຽມ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("baltas kvadratinis mygtukas"),
            keywords: &[
                "baltas kvadratinis mygtukas",
                "geometrija",
                "kontūras",
                "kvadratas",
                "mygtukas",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("balta kvadrātveida poga"),
            keywords: &["balta kvadrātveida poga", "kvadrāts", "ģeometrija"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pātene tapawhā mā"),
            keywords: &[
                "pātene",
                "pātene tapawhā mā",
                "tapawhā rite",
                "whakahuahua",
                "āhuahanga",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("бело квадратно копче"),
            keywords: &["бело квадратно копче", "геометрија", "квадрат", "копче"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("വെള\u{d41}ത\u{d4d}ത ചത\u{d41}ര ബട\u{d4d}ടൺ"),
            keywords: &[
                "ചത\u{d41}ര ബട\u{d4d}ടൺ",
                "ചത\u{d41}രം",
                "ബട\u{d4d}ടൺ",
                "വെള\u{d41}ത\u{d4d}ത ചത\u{d41}ര ബട\u{d4d}ടൺ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("цагаан дөрвөлжин товчлуур"),
            keywords: &[
                "геометр",
                "дөрвөлжин",
                "товч",
                "хүрээтэй",
                "цагаан дөрвөлжин товчлуур",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("पा\u{902}ढर\u{947} चौरस बटण"),
            keywords: &[
                "आर\u{947}खन",
                "चौरस",
                "पा\u{902}ढर\u{947} चौरस बटण",
                "बटण",
                "भ\u{942}मितीय",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("butang persegi putih"),
            keywords: &[
                "butang",
                "butang persegi putih",
                "digariskan",
                "geometri",
                "persegi",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("buttuna kwadra bajda"),
            keywords: &[
                "buttuna",
                "buttuna kwadra bajda",
                "kwadra",
                "spjegati",
                "ġeometrika",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အဖြ\u{1030}ရောင\u{103a} လေးထောင\u{1037}\u{103a}ခလ\u{102f}တ\u{103a}"),
            keywords: &[
                "ခလ\u{102f}တ\u{103a}",
                "ဂျ\u{102e}ဩမေတြ\u{102e}",
                "မ\u{103e}တ\u{103a}ပေးထား",
                "လေးထောင\u{1037}\u{103a}က\u{103d}က\u{103a}",
                "အဖြ\u{1030}ရောင\u{103a} လေးထောင\u{1037}\u{103a}ခလ\u{102f}တ\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("hvit firkantet knapp"),
            keywords: &["firkant", "hvit firkantet knapp", "knapp"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("स\u{947}तो वर\u{94d}गीय बटन"),
            keywords: &[
                "छ\u{947}उको र\u{947}खा",
                "ज\u{94d}यामितीय",
                "बटन",
                "वर\u{94d}ग",
                "स\u{947}तो वर\u{94d}गीय बटन",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("witte vierkante knop"),
            keywords: &[
                "geometrisch",
                "knop",
                "omlijnd",
                "vierkant",
                "witte vierkante knop",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("kvit firkanta knapp"),
            keywords: &["firkant", "knapp", "kvit firkanta knapp"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଧଳ\u{b3e} ବର\u{b4d}ଗ\u{b3e}କ\u{b3e}ର ବଟନ\u{b4d}\u{200c}"),
            keywords: &[
                "ଜ\u{b4d}ୟ\u{b3e}ମ\u{b3f}ତ\u{b3f}କ",
                "ଧଳ\u{b3e} ବର\u{b4d}ଗ\u{b3e}କ\u{b3e}ର ବଟନ\u{b4d}\u{200c}",
                "ବଟନ\u{b4d}\u{200c}",
                "ବର\u{b4d}ଗକ\u{b4d}ଷେତ\u{b4d}ର",
                "ବ\u{b3e}ହ\u{b4d}ୟରେଖ\u{b3e}କ\u{b43}ତ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਵਰਗਾਕਾਰ ਸਫ\u{a47}ਦ ਬਟਨ"),
            keywords: &[
                "ਜਯਾਮਿਤੀ",
                "ਬਟਨ",
                "ਰ\u{a47}ਖਾ\u{a02}ਕਿਤ",
                "ਵਰਗ",
                "ਵਰਗਾਕਾਰ ਸਫ\u{a47}ਦ ਬਟਨ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("چٹا مربعی بٹن"),
            keywords: &[
                "بٹن",
                "جیومیٹری دے متعلق",
                "خاکہ ش\u{64f}دہ",
                "مربع",
                "چٹا مربعی بٹن",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Waít Skweá Bọ\u{301}tin"),
            keywords: &[
                "Bọ\u{301}dá-Lain",
                "Bọ\u{301}tin",
                "Jiọ\u{301}mẹ\u{301}tri",
                "Skwea",
                "Waít Skweá Bọ\u{301}tin",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("biały kwadratowy przycisk"),
            keywords: &[
                "biały",
                "biały kwadratowy przycisk",
                "czarny",
                "figura geometryczna",
                "kwadrat",
                "obramowanie",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("سپینه مربع بټن"),
            keywords: &["بټن", "جيوميتريکي", "سپینه مربع بټن", "مربع", "چاپيره"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("botão quadrado branco"),
            keywords: &[
                "botão",
                "botão quadrado branco",
                "botão quadrado branco e preto",
                "quadrado",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("botão quadrado branco"),
            keywords: &[
                "botão",
                "botão quadrado branco",
                "delineado",
                "geométrico",
                "quadrado",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("buton pătrat alb"),
            keywords: &["buton pătrat alb", "contur", "geometric", "pătrat"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-751"),
            keywords: &["E10-751"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("кнопка с белой рамкой"),
            keywords: &["белая", "квадрат", "кнопка", "кнопка с белой рамкой"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("buto ya kare y’umweru"),
            keywords: &[
                "buto ya kare y’umweru",
                "byagaragajwe",
                "byerekeye jewometiri",
                "ibuto",
                "mpandenye",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("اڇو چورس بٽڻ"),
            keywords: &["اڇو چورس بٽڻ", "بٽڻ", "جيوميٽرڪ", "ڀريل", "چورس"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ස\u{dd4}ද\u{dd4} හතරැස\u{dca} බොත\u{dca}තම"),
            keywords: &[
                "කොට\u{dd4}ව",
                "ජ\u{dca}\u{200d}ය\u{dcf}ම\u{dd2}ත\u{dd2}ක",
                "බොත\u{dca}තම",
                "වැට\u{dd2}සන",
                "ස\u{dd4}ද\u{dd4} හතරැස\u{dca} බොත\u{dca}තම",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("biele hranaté tlačidlo"),
            keywords: &[
                "biele hranaté tlačidlo",
                "geometria",
                "obrys",
                "tlačidlo",
                "štvorec",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("gumb z belim kvadratom"),
            keywords: &[
                "geometrično",
                "gumb",
                "gumb z belim kvadratom",
                "kvadrat",
                "obrobljeno",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("badhan afar gees oo cad"),
            keywords: &[
                "afar gees",
                "badhan",
                "badhan afar gees ah oo cad",
                "badhan afar gees oo cad",
                "joometriyeed",
                "sharaxan",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("buton katror i bardhë"),
            keywords: &[
                "buton",
                "buton katror i bardhë",
                "gjeometrik",
                "i konturuar",
                "katror",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("бело квадратно дугме"),
            keywords: &[
                "oбрис",
                "бело квадратно дугме",
                "гeoмeтриja",
                "дугме",
                "квадратно",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("бијело квадратно дугме"),
            keywords: &["бијело квадратно дугме"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("belo kvadratno dugme"),
            keywords: &[
                "belo kvadratno dugme",
                "dugme",
                "geometrija",
                "kvadratno",
                "obris",
            ],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("bijelo kvadratno dugme"),
            keywords: &["bijelo kvadratno dugme"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("vit fyrkantig knapp"),
            keywords: &["fyrkant", "knapp", "vit fyrkantig knapp"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kitufe cheupe cha mraba"),
            keywords: &[
                "iliyobainishwa",
                "jiometri",
                "kitufe",
                "kitufe cheupe cha mraba",
                "mraba",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("வெள\u{bcd}ளை சதுர பட\u{bcd}டன\u{bcd}"),
            keywords: &[
                "ஒயிட\u{bcd} ஸ\u{bcd}கொயர\u{bcd}",
                "சதுர பட\u{bcd}டன\u{bcd}",
                "பட\u{bcd}டன\u{bcd}",
                "வெள\u{bcd}ளை சதுர பட\u{bcd}டன\u{bcd}",
                "வெள\u{bcd}ளை சதுரம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("త\u{c46}లుపు రంగు చతురస\u{c4d}రం"),
            keywords: &[
                "చతురస\u{c4d}రం",
                "త\u{c46}లుపు రంగు",
                "త\u{c46}లుపు రంగు చతురస\u{c4d}రం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("тугмаи \"Чоркунҷаи сафед\""),
            keywords: &[
                "геометрӣ",
                "тугма",
                "тугмаи \"Чоркунҷаи сафед\"",
                "чоркунҷа",
                "ҳошиядор",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ป\u{e38}\u{e48}มส\u{e35}\u{e48}เหล\u{e35}\u{e48}ยมขอบขาว"),
            keywords: &[
                "ป\u{e38}\u{e48}ม",
                "ป\u{e38}\u{e48}มส\u{e35}\u{e48}เหล\u{e35}\u{e48}ยมขอบขาว",
                "ป\u{e38}\u{e48}มส\u{e35}\u{e48}เหล\u{e35}\u{e48}ยมส\u{e35}ขาว",
                "ส\u{e35}\u{e48}เหล\u{e35}\u{e48}ยม",
            ],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ጻዕዳ ትርብዒት መልጎም"),
            keywords: &["መልጎም", "ትርብዒት", "ንድፊ", "ጂኦሜትሪክ", "ጻዕዳ ትርብዒት መልጎም"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ak inedördül düwme"),
            keywords: &[
                "ak inedördül düwme",
                "düwme",
                "geometrik",
                "inedördül",
                "çarçuwaly",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("meʻalolomi tapafā hinehina"),
            keywords: &["hinehina", "meʻalolomi", "tapafā"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("beyaz kare düğme"),
            keywords: &["beyaz kare düğme", "düğme", "kare"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئاق كىۋادرات كۇنۇپكىسى"),
            keywords: &[
                "ئاق كىۋادرات كۇنۇپكىسى",
                "سىزىق",
                "كىۋادرات",
                "كۇنۇپكا",
                "گېئومېتىرىيە",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("квадратна кнопка з білою рамкою"),
            keywords: &[
                "біла квадратна кнопка",
                "геометричний",
                "квадрат",
                "квадратна кнопка з білою рамкою",
                "кнопка",
                "контур",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("سفید چوکور بٹن"),
            keywords: &["بٹن", "جیومیٹری", "سفید", "چوکور"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("oq kvadrat katak"),
            keywords: &[
                "chizilgan",
                "geometriya",
                "katak",
                "kvadrat",
                "oq kvadrat katak",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("nút hình vuông màu trắng"),
            keywords: &[
                "hình học",
                "hình vuông",
                "mờ",
                "nút",
                "nút hình vuông màu trắng",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("bitoŋu kaare bu weex"),
            keywords: &[
                "bitoŋ",
                "bitoŋu kaare bu weex",
                "fësal",
                "kaare",
                "wu-geometri",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("iqhosha leskwere elimhlophe"),
            keywords: &[
                "ibalaseliswe umphandle",
                "ijiyometriki",
                "iqhosha",
                "iqhosha leskwere elimhlophe",
                "iskwere",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Bọtini Onigunmẹrin Funfun"),
            keywords: &[
                "Bó\u{329}tìnì",
                "Bọtini Onigunmẹrin Funfun",
                "jiomẹ\u{301}tíríkì",
                "onígun mé\u{329}rin",
                "ààtò",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("白色方形按鈕"),
            keywords: &["外框", "幾何", "按鈕", "正方形", "白色方形按鈕"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("白色方形按钮"),
            keywords: &["几何", "外框", "按钮", "正方形", "白色方形按钮"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("白色方形按钮"),
            keywords: &[
                "按钮",
                "白线方形按钮",
                "白线正方形按钮",
                "白色方形按钮",
                "白色正方形按钮",
                "白边线方形按钮",
                "白边线正方形按钮",
            ],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("白色方按鈕"),
            keywords: &["按鈕", "白色方按鈕"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("白色正方形按鈕"),
            keywords: &["按鈕", "白色正方形按鈕"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("inkonobho eyiskwele emhlophe"),
            keywords: &[
                "inkobho",
                "inkonobho eyiskwele emhlophe",
                "iskwele",
                "jiyometrikhi",
                "okugqanyisiwe",
            ],
        },
    ],
};
#[doc = "🔲"]
pub const BLACK_SQUARE_BUTTON: crate::Emoji = crate::Emoji {
    glyph: "🔲",
    codepoint: "1F532",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "black square button",
    group: "Symbols",
    subgroup: "geometric",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("swart vierkant-knoppie"),
            keywords: &[
                "geometries",
                "knoppie",
                "swart buitelyn",
                "swart vierkant-knoppie",
                "vierkant",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("በጥቁር የተከበበ ካሬ አዝራር"),
            keywords: &["በጥቁር የተከበበ ካሬ አዝራር", "አዝራር", "ካሬ", "ጂኦሜትሪያዊ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("زر مربع أسود"),
            keywords: &["زر", "زر مربع أسود", "مربع"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ক’ল\u{9be} বৰ\u{9cd}গ ব\u{9c1}ট\u{9be}ম"),
            keywords: &[
                "ক’ল\u{9be} বৰ\u{9cd}গ ব\u{9c1}ট\u{9be}ম",
                "জ\u{9cd}য\u{9be}মিতিক",
                "ব\u{9c1}ট\u{9be}ম",
                "বৰ\u{9cd}গ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("qara kvadrat düymə"),
            keywords: &["düymə", "həndəsi", "kvadrat", "qara kvadrat düymə"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("чорная квадратная кнопка"),
            keywords: &[
                "аб’ект",
                "геаметрычны",
                "квадрат",
                "кнопка",
                "чорная квадратная кнопка",
                "чорны",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Квадратен бутон с черен контур"),
            keywords: &[
                "Квадратен бутон с черен контур",
                "бутон",
                "геометричен",
                "квадрат",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ক\u{9be}লো বর\u{9cd}গ\u{9be}ক\u{9be}র বোত\u{9be}ম"),
            keywords: &[
                "ক\u{9be}লো বর\u{9cd}গ\u{9be}ক\u{9be}র বোত\u{9be}ম",
                "জ\u{9cd}য\u{9be}মিতিক",
                "বর\u{9cd}গ\u{9be}ক\u{9be}র",
                "বোত\u{9be}ম",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("crni kvadrat dugme"),
            keywords: &["crni kvadrat dugme", "geometrija", "kvadrat", "tipka"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("botó de quadrat negre"),
            keywords: &[
                "botó",
                "botó de quadrat negre",
                "geometria",
                "negre",
                "quadrat",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎬᎿᎨ ᏅᎩ ᏧᏅᏏᏯ ᎦᏗ"),
            keywords: &["ᎤᏙᏢᏒ", "ᎦᏗ", "ᎬᎿᎨ ᏅᎩ ᏧᏅᏏᏯ ᎦᏗ", "ᏅᎩ ᏧᏅᏏᏯ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("černé čtvercové tlačítko"),
            keywords: &[
                "geometrie",
                "tlačítko",
                "černé čtvercové tlačítko",
                "čtvercové",
                "čtverec",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("botwm sgwâr du"),
            keywords: &["botwm", "botwm sgwâr du", "geometrig", "sgwâr"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("sort kvadratisk knap"),
            keywords: &["geometrisk", "knap", "kvadrat", "sort kvadratisk knap"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("schwarze quadratische Schaltfläche"),
            keywords: &[
                "Schaltfläche",
                "quadratisch",
                "schwarz",
                "schwarze quadratische Schaltfläche",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("μαύρο τετράγωνο κουμπί"),
            keywords: &[
                "γεωμετρικό",
                "κουμπί",
                "μαύρο τετράγωνο κουμπί",
                "τετράγωνο",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("black square button"),
            keywords: &["black square button", "button", "geometric", "square"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("botón cuadrado con borde negro"),
            keywords: &["botón", "botón cuadrado con borde negro", "cuadrado"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("cuadrado blanco con borde negro"),
            keywords: &[
                "blanco",
                "borde",
                "botón",
                "cuadrado",
                "cuadrado blanco con borde negro",
                "marco",
                "negro",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &[
                "borde",
                "botón",
                "cuadrado",
                "cuadrado blanco con borde negro",
                "marco",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &[
                "borde",
                "botón",
                "cuadrado",
                "cuadrado blanco con borde negro",
                "marco",
            ],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("must ruudukujuline nupp"),
            keywords: &[
                "geomeetria",
                "must ruudukujuline nupp",
                "nupp",
                "piirjoon",
                "ruut",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("karratu beltz itxurako botoia"),
            keywords: &[
                "botoi",
                "geometriko",
                "karratu",
                "karratu beltz itxurako botoia",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("دکمۀ مربع مشکی"),
            keywords: &["دکمه", "دکمۀ مربع مشکی", "شکل هندسی", "مربع"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("musta neliöruutu"),
            keywords: &[
                "muoto",
                "musta neliöruutu",
                "neliö",
                "valinta",
                "valintaruutu",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("itim na parisukat na button"),
            keywords: &[
                "buton",
                "gilid",
                "hugis",
                "itim",
                "itim na parisukat na button",
                "pantay",
                "parisukat",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("svartur fýrakantaður karmur"),
            keywords: &[
                "fýrakantur",
                "karmur",
                "mátingarfrøðiligur",
                "rútur",
                "svartur fýrakantaður karmur",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("carré noir"),
            keywords: &["bouton", "carré", "carré noir", "forme", "géométrie"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("bouton représentant un carré noir"),
            keywords: &[
                "bouton",
                "bouton représentant un carré noir",
                "carré noir",
                "géométrie",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("cearnóg dhubh"),
            keywords: &["cearnóg dhubh"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("putan ceàrnagach dubh"),
            keywords: &[
                "ceàrnag",
                "ceàrnagach",
                "geomatrach",
                "putan",
                "putan ceàrnagach dubh",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("botón con cadrado negro"),
            keywords: &["botón", "botón con cadrado negro", "cadrado", "negro"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("કાળો ચોરસ બટન"),
            keywords: &["કાળો ચોરસ બટન", "ચોરસ", "બટન"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("maɓallin baƙin murabba’i"),
            keywords: &[
                "ilimin halayen sura",
                "maɓallin",
                "maɓallin baƙin murabba’i",
                "murabba’i",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("לחצן ריבוע שחור"),
            keywords: &[
                "לחצן",
                "לחצן ריבוע שחור",
                "מסגרת",
                "צורה",
                "ריבוע",
                "ריבוע שחור",
            ],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("काला वर\u{94d}ग बटन"),
            keywords: &["काला वर\u{94d}ग बटन", "ज\u{94d}यामिति", "बटन", "वर\u{94d}ग"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("crna uglata tipka"),
            keywords: &["crna uglata tipka", "geometrija", "gumb", "uglato"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("fekete, négyzet alakú gomb"),
            keywords: &["fekete, négyzet alakú gomb", "gomb", "négyzet"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("սև քառակուսի կոճակ"),
            keywords: &["երկրաչափական", "կոճակ", "սև քառակուսի կոճակ", "քառակուսի"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("tombol persegi hitam"),
            keywords: &["geometri", "persegi", "tombol", "tombol persegi hitam"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ọdụmbi sukwia ojii"),
            keywords: &["mgbakọ", "sukwia", "ọdụmbi", "ọdụmbi sukwia ojii"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("svartur ferningslaga hnappur"),
            keywords: &["ferningur", "hnappur", "svartur ferningslaga hnappur"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("tasto quadrato bianco con bordo nero"),
            keywords: &[
                "pulsante",
                "pulsante quadrato pieno",
                "quadrato",
                "tasto quadrato bianco con bordo nero",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("黒枠四角"),
            keywords: &["ボタン", "四角ボタン", "正方形", "黒枠四角"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("tombol kothak ireng"),
            keywords: &["geometrik", "kothak", "tombol", "tombol kothak ireng"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("შავი კვადრატული ღილაკი"),
            keywords: &[
                "გეომეტრია",
                "გეომეტრიული",
                "კვადრატი",
                "ღილაკი",
                "შავი კვადრატული ღილაკი",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("қара шаршы түймесі"),
            keywords: &["геометриялық", "түйме", "шаршы", "қара шаршы түймесі"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("sort kvadratisk knap"),
            keywords: &["geometrisk", "knap", "kvadrat", "sort kvadratisk knap"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some(
                "ប\u{17bd}នជ\u{17d2}រ\u{17bb}ងពណ\u{17cc}សនៅក\u{17d2}ន\u{17bb}ងប\u{17bd}នជ\u{17d2}រ\u{17bb}ងពណ\u{17cc}ខ\u{17d2}មៅ",
            ),
            keywords: &[
                "ខ\u{17d2}មៅ",
                "ប\u{17bd}នជ\u{17d2}រ\u{17bb}ង",
                "ប\u{17bd}នជ\u{17d2}រ\u{17bb}ងពណ\u{17cc}សនៅក\u{17d2}ន\u{17bb}ងប\u{17bd}នជ\u{17d2}រ\u{17bb}ងពណ\u{17cc}ខ\u{17d2}មៅ",
                "ស",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕಪ\u{ccd}ಪು ಚ\u{ccc}ಕದ ಬಟನ\u{ccd}"),
            keywords: &["ಕಪ\u{ccd}ಪು ಚ\u{ccc}ಕದ ಬಟನ\u{ccd}", "ಚದರ", "ಚದರ ಬಟನ\u{ccd}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("테두리가 검은 사각 버튼"),
            keywords: &["버튼", "사각형", "테두리가 검은 사각 버튼"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("काळो चवकोन बटण"),
            keywords: &["काळो चवकोन बटण", "चवकोन", "जियोम\u{945}ट\u{94d}रीक", "बटण"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("кара чарчы баскычы"),
            keywords: &["баскыч", "геометрия", "кара чарчы баскычы", "чарчы"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("schwaarze véiereckege Knäppchen"),
            keywords: &[
                "Knäppchen",
                "Quadrat",
                "geometresch",
                "schwaarze véiereckege Knäppchen",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ປ\u{eb8}\u{ec8}ມສ\u{eb5}\u{ec8}ຫ\u{ebc}\u{ec8}ຽມດຳ"),
            keywords: &[
                "ດຳ",
                "ປ\u{eb8}\u{ec8}ມ",
                "ປ\u{eb8}\u{ec8}ມສ\u{eb5}\u{ec8}ຫ\u{ebc}\u{ec8}ຽມດຳ",
                "ສ\u{eb5}\u{ec8}ຫ\u{ebc}\u{ec8}ຽມ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("juodas kvadratinis mygtukas"),
            keywords: &[
                "geometrija",
                "juodas kvadratinis mygtukas",
                "kvadratas",
                "mygtukas",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("melna kvadrātveida poga"),
            keywords: &["kvadrāts", "melna kvadrātveida poga", "ģeometrija"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pātene tapawhā pango"),
            keywords: &[
                "pātene",
                "pātene tapawhā pango",
                "tapawhā rite",
                "āhuahanga",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("црно квадратно копче"),
            keywords: &["геометрија", "квадрат", "копче", "црно квадратно копче"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("കറ\u{d41}ത\u{d4d}ത ചത\u{d41}ര ബട\u{d4d}ടൺ"),
            keywords: &[
                "കറ\u{d41}ത\u{d4d}ത ചത\u{d41}ര ബട\u{d4d}ടൺ",
                "ചത\u{d41}ര ബട\u{d4d}ടൺ",
                "ചത\u{d41}രം",
                "ബട\u{d4d}ടൺ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("хар дөрвөлжин товчлуур"),
            keywords: &["геометр", "дөрвөлжин", "товчлуур", "хар дөрвөлжин товчлуур"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("काळ\u{947} चौरस बटण"),
            keywords: &["काळ\u{947} चौरस बटण", "चौरस", "बटण", "भ\u{942}मितीय"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("butang persegi hitam"),
            keywords: &["butang", "butang persegi hitam", "geometri", "persegi"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("buttuna kwadra sewda"),
            keywords: &["buttuna", "buttuna kwadra sewda", "kwadra", "ġeometrika"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အနက\u{103a}ရောင\u{103a} လေးထောင\u{1037}\u{103a}ခလ\u{102f}တ\u{103a}"),
            keywords: &[
                "ခလ\u{102f}တ\u{103a}",
                "ဂျ\u{102e}ဩမေတြ\u{102e}",
                "လေးထောင\u{1037}\u{103a}",
                "အနက\u{103a}ရောင\u{103a} လေးထောင\u{1037}\u{103a}ခလ\u{102f}တ\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("svart firkantet knapp"),
            keywords: &["firkant", "knapp", "svart firkantet knapp"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("कालो वर\u{94d}गीय बटन"),
            keywords: &[
                "कालो वर\u{94d}गीय बटन",
                "ज\u{94d}यामितीय",
                "बटन",
                "वर\u{94d}ग",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("zwarte vierkante knop"),
            keywords: &["geometrisch", "knop", "vierkant", "zwarte vierkante knop"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("svart firkanta knapp"),
            keywords: &["firkant", "knapp", "svart firkanta knapp"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("କଳ\u{b3e} ବର\u{b4d}ଗ\u{b3e}କ\u{b3e}ର ବଟନ\u{b4d}\u{200c}"),
            keywords: &[
                "କଳ\u{b3e} ବର\u{b4d}ଗ\u{b3e}କ\u{b3e}ର ବଟନ\u{b4d}\u{200c}",
                "ଜ\u{b4d}ୟ\u{b3e}ମ\u{b3f}ତ\u{b3f}କ",
                "ବଟନ\u{b4d}\u{200c}",
                "ବର\u{b4d}ଗକ\u{b4d}ଷେତ\u{b4d}ର",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਵਰਗਾਕਾਰ ਕਾਲਾ ਬਟਨ"),
            keywords: &["ਜਯਾਮਿਤੀ", "ਬਟਨ", "ਵਰਗ", "ਵਰਗਾਕਾਰ ਕਾਲਾ ਬਟਨ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("کالا مربعی بٹن"),
            keywords: &["بٹن", "جیومیٹری دے متعلق", "مربع", "کالا مربعی بٹن"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Blák Skweá Bọ\u{301}tin"),
            keywords: &[
                "Blák Skweá Bọ\u{301}tin",
                "Bọ\u{301}tin",
                "Jiọ\u{301}mẹ\u{301}tri",
                "Skwea",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("czarny kwadratowy przycisk"),
            keywords: &[
                "biały",
                "czarny",
                "czarny kwadratowy przycisk",
                "figura geometryczna",
                "kwadrat",
                "obramowanie",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("توره مربع بټن"),
            keywords: &["بټن", "توره مربع بټن", "جيوميتريکي", "مربع"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("botão quadrado preto"),
            keywords: &[
                "botão",
                "botão quadrado preto",
                "botão quadrado preto e branco",
                "quadrado",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("botão quadrado preto"),
            keywords: &["botão", "botão quadrado preto", "geométrico", "quadrado"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("buton pătrat negru"),
            keywords: &["buton pătrat negru", "geometric", "negru", "pătrat"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-750"),
            keywords: &["E10-750"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("кнопка с черной рамкой"),
            keywords: &["квадрат", "кнопка", "кнопка с черной рамкой", "черная"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("buto ya kare y’umukara"),
            keywords: &[
                "buto ya kare y’umukara",
                "byerekeye jewometiri",
                "ibuto",
                "ubwikube kabiri",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("چورس ڪارو بٽڻ"),
            keywords: &["بٽڻ", "جيوميٽرڪ", "چورس", "چورس ڪارو بٽڻ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("කළ\u{dd4} හතරැස\u{dca} බොත\u{dca}තම"),
            keywords: &[
                "කළ\u{dd4} හතරැස\u{dca} බොත\u{dca}තම",
                "කොට\u{dd4}ව",
                "ජ\u{dca}\u{200d}ය\u{dcf}ම\u{dd2}ත\u{dd2}ක",
                "බොත\u{dca}තම",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("čierne hranaté tlačidlo"),
            keywords: &[
                "geometria",
                "tlačidlo",
                "čierne hranaté tlačidlo",
                "štvorec",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("gumb s črnim kvadratom"),
            keywords: &["geometrično", "gumb", "gumb s črnim kvadratom", "kvadrat"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("badhan afar gees ah oo madow"),
            keywords: &[
                "afar gees",
                "badhan",
                "badhan afar gees ah oo madow",
                "joometriyeed",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("buton katror i zi"),
            keywords: &["buton", "buton katror i zi", "gjeometri", "katror"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("црно квадратно дугме"),
            keywords: &["гeoмeтриja", "дугме", "квадратно", "црно квадратно дугме"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("crno kvadratno dugme"),
            keywords: &["crno kvadratno dugme", "dugme", "geometrija", "kvadratno"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("svart fyrkantig knapp"),
            keywords: &["fyrkant", "knapp", "svart fyrkantig knapp"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kitufe cheusi cha mraba"),
            keywords: &["jiometri", "kitufe", "kitufe cheusi cha mraba", "mraba"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("கருப\u{bcd}பு சதுரப\u{bcd} பட\u{bcd}டன\u{bcd}"),
            keywords: &[
                "கருப\u{bcd}பு சதுரப\u{bcd} பட\u{bcd}டன\u{bcd}",
                "கருப\u{bcd}பு சதுரம\u{bcd}",
                "சதுர பட\u{bcd}டன\u{bcd}",
                "பட\u{bcd}டன\u{bcd}",
                "பிள\u{bbe}க\u{bcd} ஸ\u{bcd}கொயர\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("నలుపు రంగు చతురస\u{c4d}రం"),
            keywords: &["చతురస\u{c4d}రం", "నలుపు రంగు", "నలుపు రంగు చతురస\u{c4d}రం"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("тугмаи \"Чоркунҷаи сиёҳ\""),
            keywords: &["геометрӣ", "тугма", "тугмаи \"Чоркунҷаи сиёҳ\"", "чоркунҷа"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ป\u{e38}\u{e48}มส\u{e35}\u{e48}เหล\u{e35}\u{e48}ยมขอบดำ"),
            keywords: &[
                "ป\u{e38}\u{e48}ม",
                "ป\u{e38}\u{e48}มส\u{e35}\u{e48}เหล\u{e35}\u{e48}ยมขอบดำ",
                "ป\u{e38}\u{e48}มส\u{e35}\u{e48}เหล\u{e35}\u{e48}ยมส\u{e35}ดำ",
                "ส\u{e35}\u{e48}เหล\u{e35}\u{e48}ยม",
            ],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ጸሊም ትርብዒት መልጎም"),
            keywords: &["መልጎም", "ትርብዒት", "ጂኦሜትሪክ", "ጸሊም ትርብዒት መልጎም"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("gara inedördül düwme"),
            keywords: &["düwme", "gara inedördül düwme", "geometrik", "inedördül"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("meʻalolomi tapafā ʻuliʻuli"),
            keywords: &["meʻalolomi", "tapafā", "ʻuliʻuli"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("siyah kare düğme"),
            keywords: &["düğme", "kare", "siyah kare düğme"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("قارا چاسا كۇنۇپكا"),
            keywords: &["قارا چاسا كۇنۇپكا", "كىۋادرات", "كۇنۇپكا", "گېئومېتىرىيە"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("квадратна кнопка з чорною рамкою"),
            keywords: &[
                "геометричний",
                "квадрат",
                "квадратна кнопка з чорною рамкою",
                "кнопка",
                "чорна квадратна кнопка",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("سیاہ چوکور بٹن"),
            keywords: &["بٹن", "جیومیٹری", "سیاہ چوکور بٹن", "چوکور", "کالا"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("qora kvadrat katak"),
            keywords: &["geometriya", "katak", "kvadrat", "qora kvadrat katak"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("nút hình vuông màu đen"),
            keywords: &["hình học", "hình vuông", "nút", "nút hình vuông màu đen"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("bitoŋu kaare ñuul"),
            keywords: &["bitoŋ", "bitoŋu kaare ñuul", "kaare", "wu-geometri"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("iqhosha eliskrwere elimnyama"),
            keywords: &[
                "ijiyometriki",
                "iqhosha",
                "iqhosha eliskrwere elimnyama",
                "iskwere",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Bọtini Onigunmẹrin Dudu"),
            keywords: &[
                "Bó\u{329}tìnì",
                "Bọtini Onigunmẹrin Dudu",
                "jiomẹ\u{301}tíríkì",
                "onígun mé\u{329}rin",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("黑色正方按鈕"),
            keywords: &["幾何", "按鈕", "正方形", "黑色正方按鈕"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("黑色正方按钮"),
            keywords: &["几何", "按钮", "正方形", "黑色正方按钮"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("黑色方形按钮"),
            keywords: &[
                "按钮",
                "黑线方形按钮",
                "黑线正方形按钮",
                "黑色方形按钮",
                "黑色正方形按钮",
                "黑边线方形按钮",
                "黑边线正方形按钮",
            ],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("黑色方按鈕"),
            keywords: &["按鈕", "黑色方按鈕"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("黑色正方形按鈕"),
            keywords: &["按鈕", "黑色正方形按鈕"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("inkinobho eyiskwele esimnyama"),
            keywords: &[
                "inkinobho",
                "inkinobho eyiskwele esimnyama",
                "iskwele",
                "jiyometrikhi",
            ],
        },
    ],
};
