#[doc = "♀\u{fe0f}"]
pub const FEMALE_SIGN: crate::Emoji = crate::Emoji {
    glyph: "♀\u{fe0f}",
    codepoint: "2640 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "female sign",
    group: "Symbols",
    subgroup: "gender",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "♀",
        codepoint: "2640",
        status: crate::Status::Unqualified,
        introduction_version: 4f32,
        name: "female sign",
        group: "Symbols",
        subgroup: "gender",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("vroulik-teken"),
            keywords: &["vroulik", "vroulik-teken"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የሴት ምልክት"),
            keywords: &["ሴት", "የሴት ምልክት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("رمز أنثى"),
            keywords: &["رمز أنثى", "مؤنث"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("মহিল\u{9be} চিহ\u{9cd}ন"),
            keywords: &["মহিল\u{9be}", "মহিল\u{9be} চিহ\u{9cd}ন"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("qadın işarəsi"),
            keywords: &["qadın", "qadın işarəsi"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("жаночы сімвал"),
            keywords: &["жаночы сімвал", "жанчына"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("знак за женски пол"),
            keywords: &["жена", "женски", "знак за женски пол"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("স\u{9cd}ত\u{9cd}রী চিহ\u{9cd}ন"),
            keywords: &[
                "মহিল\u{9be}",
                "স\u{9cd}ত\u{9cd}রি",
                "স\u{9cd}ত\u{9cd}রী চিহ\u{9cd}ন",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("arouez ar mercʼhed"),
            keywords: &["arouez", "arouez ar mercʼhed", "mercʼhed"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("žensko"),
            keywords: &["žena", "žensko"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("símbol femení"),
            keywords: &["dona", "femella", "femení", "símbol femení"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᎨᏯ ᎪᏟᏍᏙᏗ"),
            keywords: &["ᎠᎨᏯ", "ᎠᎨᏯ ᎪᏟᏍᏙᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("symbol ženského pohlaví"),
            keywords: &["symbol ženského pohlaví", "žena"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("arwydd benyw"),
            keywords: &["arwydd benyw", "benywaidd", "menyw"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("kvindesymbol"),
            keywords: &["kvinde", "kvindesymbol", "kvindetegn", "symbol", "tegn"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Frauensymbol"),
            keywords: &["Frau", "Frauensymbol", "Zeichen", "weiblich"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("θηλυκό"),
            keywords: &["γυναίκα", "θηλυκό"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("female sign"),
            keywords: &["female sign", "woman"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("signo femenino"),
            keywords: &["mujer", "signo", "signo femenino", "símbolo"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("naisesümbol"),
            keywords: &["naine", "naisesümbol", "sümbol"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("emakumeen ikurra"),
            keywords: &["emakume", "emakumeen ikurra", "emakumezko"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("نشان ناهید"),
            keywords: &["نشان ناهید", "نماد جنس ماده", "نماد زن", "نماد ونوس"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("Venus-symboli"),
            keywords: &["Venus-symboli", "naissymboli"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("simbolo ng babae"),
            keywords: &["babae", "simbolo", "simbolo ng babae"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("konufólkatekin"),
            keywords: &["kona", "konufólk", "konufólkatekin", "kvinna"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("symbole de la femme"),
            keywords: &["femme", "symbole de la femme"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("comhartha baineann"),
            keywords: &["baineann", "bean", "comhartha baineann"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("samhla boireann"),
            keywords: &["boireannach", "samhla boireann"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("símbolo da muller"),
            keywords: &["feminismo", "muller", "sexo", "símbolo da muller", "xénero"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("સ\u{acd}ત\u{acd}રી ચિહ\u{acd}ન"),
            keywords: &[
                "મહિલા",
                "સ\u{acd}ત\u{acd}રી",
                "સ\u{acd}ત\u{acd}રી ચિહ\u{acd}ન",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("alamar mace"),
            keywords: &["alamar mace", "mace"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("סמל אישה"),
            keywords: &["אישה", "נשים", "סמל אישה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("मादा चिह\u{94d}न"),
            keywords: &["औरत", "मादा चिह\u{94d}न"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("ženski simbol"),
            keywords: &["ženski simbol"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("női nem jelképe"),
            keywords: &["nem", "női", "női nem jelképe"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("կնոջ նշան"),
            keywords: &["կին", "կնոջ նշան"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("simbol wanita"),
            keywords: &["perempuan", "simbol wanita"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("akàrà nwanyị"),
            keywords: &["akàrà nwanyị", "nwanyị"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("kvenkyns merki"),
            keywords: &["konur", "kvenkyns", "merki"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("simbolo genere femminile"),
            keywords: &[
                "donna",
                "femmina",
                "simbolo di femmina",
                "simbolo genere femminile",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("女性のマーク"),
            keywords: &["シンボル", "女", "女性", "女性のマーク"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("tandha wanita"),
            keywords: &["tandha wanita", "wadon"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მდედრობითი"),
            keywords: &["მდედრობითი", "ქალი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("әйел таңбасы"),
            keywords: &["таңба", "әйел", "әйел таңбасы"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ភេទស\u{17d2}រ\u{17b8}"),
            keywords: &[
                "នារ\u{17b8}",
                "ភេទ",
                "ភេទស\u{17d2}រ\u{17b8}",
                "ស\u{17d2}ត\u{17d2}រ\u{17b8}",
                "ស\u{17d2}រ\u{17b8}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಮಹ\u{cbf}ಳ\u{cc6} ಚ\u{cbf}ಹ\u{ccd}ನ\u{cc6}"),
            keywords: &[
                "ಮಹ\u{cbf}ಳ\u{cc6}",
                "ಮಹ\u{cbf}ಳ\u{cc6} ಚ\u{cbf}ಹ\u{ccd}ನ\u{cc6}",
                "ಸ\u{ccd}ತ\u{ccd}ರೀ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("여성 기호"),
            keywords: &["기호", "여성"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("बायल चिन\u{94d}न"),
            keywords: &["बायल", "बायल चिन\u{94d}न"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("аял белгиси"),
            keywords: &["аял", "аял белгиси"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("weiblecht Zeechen"),
            keywords: &["Fra", "weiblecht Zeechen"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ສ\u{eb1}ນຍາລ\u{eb1}ກຜ\u{eb9}\u{ec9}ຍ\u{eb4}ງ"),
            keywords: &[
                "ຍ\u{eb4}ງ",
                "ຜ\u{eb9}\u{ec9}ຍ\u{eb4}ງ",
                "ສ\u{eb1}ນຍາລ\u{eb1}ກຜ\u{eb9}\u{ec9}ຍ\u{eb4}ງ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("moteriškos lyties ženklas"),
            keywords: &["moteris", "moteriškos lyties ženklas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("sieviešu simbols"),
            keywords: &["sieviete", "sieviešu simbols"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tohu wahine"),
            keywords: &["tohu wahine", "wahine"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("знак за женско"),
            keywords: &["жена", "женско", "знак за женско"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("സ\u{d4d}ത\u{d4d}രീ ചിഹ\u{d4d}നം"),
            keywords: &["വനിത", "സ\u{d4d}ത\u{d4d}രീ ചിഹ\u{d4d}നം"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("эмэгтэй тэмдэг"),
            keywords: &["эмэгтэй", "эмэгтэй тэмдэг", "эмэгтэй хүн"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("महिला चिन\u{94d}ह"),
            keywords: &["महिला चिन\u{94d}ह", "स\u{94d}त\u{94d}री"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("simbol perempuan"),
            keywords: &["simbol perempuan", "wanita"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("sinjal femminili"),
            keywords: &["mara", "sinjal femminili"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အမသင\u{103a}\u{1039}ကေတ"),
            keywords: &["အမသင\u{103a}\u{1039}ကေတ", "အမျ\u{102d}\u{102f}းသမ\u{102e}း"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("kvinnesymbol"),
            keywords: &["kvinne", "kvinnesymbol"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("महिला चिन\u{94d}ह"),
            keywords: &["छोरी मान\u{94d}छ\u{947}", "महिला", "महिला चिन\u{94d}ह"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("vrouwelijkheidssymbool"),
            keywords: &["vrouw", "vrouwelijkheidssymbool"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("kvinnesymbol"),
            keywords: &["kvinne", "kvinnesymbol"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ସ\u{b4d}ତ\u{b4d}ରୀ ଚ\u{b3f}ହ\u{b4d}ନ"),
            keywords: &["ମହ\u{b3f}ଳ\u{b3e}", "ସ\u{b4d}ତ\u{b4d}ରୀ ଚ\u{b3f}ହ\u{b4d}ନ"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਇਸਤਰੀ ਚਿ\u{a70}ਨ\u{a4d}ਹ"),
            keywords: &["ਇਸਤਰੀ", "ਇਸਤਰੀ ਚਿ\u{a70}ਨ\u{a4d}ਹ", "ਔਰਤ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("زنانی دی علامت"),
            keywords: &["زنانی", "زنانی دی علامت"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Wúman Sain"),
            keywords: &["Wúman", "Wúman Sain"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("znak kobiety"),
            keywords: &["kobieta", "znak", "znak kobiety", "żeński"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ښځینه نښه"),
            keywords: &["ښځه", "ښځينه نښه", "ښځینه نښه"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("símbolo de feminino"),
            keywords: &["feminino", "mulher", "símbolo de feminino"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("símbolo feminino"),
            keywords: &["mulher", "símbolo feminino"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("warmi unancha"),
            keywords: &["warmi", "warmi unancha"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("semn feminin"),
            keywords: &["femeie", "feminin", "semn feminin"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-062"),
            keywords: &["E10-062"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("женский символ"),
            keywords: &["венера", "женский символ", "женщина", "символ"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ikimenyetso cy’umugore"),
            keywords: &["ikimenyetso cy’umugore", "umugore"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("عورت جي نشاني"),
            keywords: &["عورت", "عورت جي نشاني"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ස\u{dca}ත\u{dca}\u{200d}ර\u{dd3} ලක\u{dd4}ණ"),
            keywords: &[
                "ක\u{dcf}න\u{dca}ත\u{dcf}ව",
                "ස\u{dca}ත\u{dca}\u{200d}ර\u{dd2}ය",
                "ස\u{dca}ත\u{dca}\u{200d}ර\u{dd3} ලක\u{dd4}ණ",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("ženský symbol"),
            keywords: &["samica", "žena", "ženský symbol"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("znak za ženski spol"),
            keywords: &["dekle", "znak za ženski spol", "ženska"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("calaamad dheddig"),
            keywords: &["calaamad dheddig", "haweeney"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("shenja femër"),
            keywords: &["femër", "grua", "shenja femër"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("женски знак"),
            keywords: &["жена", "женски знак"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["женски знак"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("ženski znak"),
            keywords: &["žena", "ženski znak"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["ženski znak"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("kvinnosymbol"),
            keywords: &["kvinna", "kvinnlig", "kvinnosymbol"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("ishara ya jinsia ya kike"),
            keywords: &["ishara ya jinsia ya kike", "mwanamke"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பெண\u{bcd}களைக\u{bcd} குறிக\u{bcd}கும\u{bcd} சின\u{bcd}னம\u{bcd}"),
            keywords: &[
                "சின\u{bcd}னம\u{bcd}",
                "பெண\u{bcd}",
                "பெண\u{bcd}களைக\u{bcd} குறிக\u{bcd}கும\u{bcd} சின\u{bcd}னம\u{bcd}",
                "மகளிர\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("మహ\u{c3f}ళ సంక\u{c47}తం"),
            keywords: &[
                "మహ\u{c3f}ళ",
                "మహ\u{c3f}ళ సంక\u{c47}తం",
                "స\u{c4d}త\u{c4d}ర\u{c40}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("аломати зан"),
            keywords: &["аломати зан", "зан"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ส\u{e31}ญล\u{e31}กษณ\u{e4c}เพศหญ\u{e34}ง"),
            keywords: &[
                "ผ\u{e39}\u{e49}หญ\u{e34}ง",
                "ส\u{e31}ญล\u{e31}กษณ\u{e4c}เพศหญ\u{e34}ง",
            ],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ናይ ጋል-ኣንስተይቲ ምልክት"),
            keywords: &["ሰበይቲ", "ናይ ጋል-ኣንስተይቲ ምልክት"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("aýal-gyz nyşany"),
            keywords: &["aýal-gyz nyşany", "zenan"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("ʻilonga fakafefine"),
            keywords: &["fefine", "ʻilonga", "ʻilonga fakafefine"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("kadın sembolü"),
            keywords: &["bayan", "kadın", "kadın sembolü"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئايال بەلگىسى"),
            keywords: &["ئايال", "ئايال بەلگىسى"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("символ жінки"),
            keywords: &["жінка", "жіноча стать", "знак жінки", "символ жінки"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("عورتوں کیلئے"),
            keywords: &["علامت", "عورت", "عورتوں کیلئے", "لڑکی"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("ayol belgisi"),
            keywords: &["ayol", "ayol belgisi"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("ký hiệu nữ"),
            keywords: &["ký hiệu nữ", "phụ nữ"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("màndarga jigéen"),
            keywords: &["jigéen", "màndarga jigéen"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("uphawu lwebhinqa"),
            keywords: &["ibhinqa", "uphawu lwebhinqa"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("àmí obìnrin"),
            keywords: &["Obìnrin", "àmí obìnrin"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("女性標誌"),
            keywords: &["女", "女性標誌"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("女性标志"),
            keywords: &["女", "女性标志"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("女性符号"),
            keywords: &["女性符号", "符号", "雌性"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("女"),
            keywords: &["女"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("uphawu lowesifazane"),
            keywords: &["owesifazane", "uphawu lowesifazane"],
        },
    ],
};
#[doc = "♂\u{fe0f}"]
pub const MALE_SIGN: crate::Emoji = crate::Emoji {
    glyph: "♂\u{fe0f}",
    codepoint: "2642 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "male sign",
    group: "Symbols",
    subgroup: "gender",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "♂",
        codepoint: "2642",
        status: crate::Status::Unqualified,
        introduction_version: 4f32,
        name: "male sign",
        group: "Symbols",
        subgroup: "gender",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("manlik-teken"),
            keywords: &["manlik", "manlik-teken"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የወንድ ምልክት"),
            keywords: &["ሰው", "ወንድ", "የወንድ ምልክት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("رمز ذكر"),
            keywords: &["رمز ذكر", "مذكر"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("প\u{9c1}ৰ\u{9c1}ষ চিহ\u{9cd}ন"),
            keywords: &["প\u{9c1}ৰ\u{9c1}ষ", "প\u{9c1}ৰ\u{9c1}ষ চিহ\u{9cd}ন"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("kişi işarəsi"),
            keywords: &["kişi", "kişi işarəsi"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("мужчынскі сімвал"),
            keywords: &["мужчына", "мужчынскі сімвал"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("знак за мъжки пол"),
            keywords: &["знак за мъжки пол", "мъж", "мъжки"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("প\u{9c1}র\u{9c1}ষ চিহ\u{9cd}ন"),
            keywords: &["ছেলে", "প\u{9c1}র\u{9c1}ষ", "প\u{9c1}র\u{9c1}ষ চিহ\u{9cd}ন"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("arouez ar paotred"),
            keywords: &["arouez", "arouez ar paotred", "paotred"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("muško"),
            keywords: &["muškarac", "muško"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("símbol masculí"),
            keywords: &["home", "mascle", "masculí", "símbol masculí"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏍᎦᏯ ᎪᏟᏍᏙᏗ"),
            keywords: &["ᎠᏍᎦᏯ", "ᎠᏍᎦᏯ ᎪᏟᏍᏙᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("symbol mužského pohlaví"),
            keywords: &["muž", "symbol mužského pohlaví"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("arwydd gwrw"),
            keywords: &["arwydd gwrw", "dyn", "gwrywaidd"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("mandesymbol"),
            keywords: &["mand", "mandesymbol", "mandetegn", "symbol", "tegn"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Männersymbol"),
            keywords: &["Mann", "Männersymbol", "Symbol", "Zeichen"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("αρσενικό"),
            keywords: &["άντρας", "αρσενικό"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("male sign"),
            keywords: &["male sign", "man"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("signo masculino"),
            keywords: &["hombre", "signo", "signo masculino", "símbolo"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("mehesümbol"),
            keywords: &["mees", "mehesümbol", "sümbol"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("gizonen ikurra"),
            keywords: &["gizon", "gizonen ikurra", "gizonezko"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("نشان مریخ"),
            keywords: &["نشان مریخ", "نماد جنس نر", "نماد مارس", "نماد مرد"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("Mars-symboli"),
            keywords: &["Mars-symboli", "miessymboli"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("simbolo ng lalaki"),
            keywords: &["Ginoo", "lalaki", "simbolo", "simbolo ng lalaki"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("mannfólkatekin"),
            keywords: &["mannfólk", "mannfólkatekin", "maður"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("symbole de l’homme"),
            keywords: &["homme", "symbole de l’homme"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("comhartha fireann"),
            keywords: &["comhartha fearann", "comhartha fireann", "fear", "fearann"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("samhla fireann"),
            keywords: &["fireannach", "samhla fireann"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("símbolo do home"),
            keywords: &["home", "sexo", "símbolo do home", "xénero"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("પ\u{ac1}ર\u{ac1}ષ ચિહ\u{acd}ન"),
            keywords: &["પ\u{ac1}ર\u{ac1}ષ", "પ\u{ac1}ર\u{ac1}ષ ચિહ\u{acd}ન"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("alamar namiji"),
            keywords: &["alamar namiji", "namiji"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("סמל גבר"),
            keywords: &["איש", "גבר", "גברים", "סמל גבר"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("नर चिह\u{94d}न"),
            keywords: &["आदमी", "नर चिह\u{94d}न", "प\u{941}र\u{941}ष"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("muški simbol"),
            keywords: &["muški simbol"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("férfi nem jelképe"),
            keywords: &["férfi", "férfi nem jelképe", "nem"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("տղամարդու նշան"),
            keywords: &["տղամարդ", "տղամարդու նշան"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("simbol pria"),
            keywords: &["laki-laki", "simbol pria"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("akara oke"),
            keywords: &["akara oke", "nwoke"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("karlkyns merki"),
            keywords: &["karlar", "karlkyns", "merki"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("simbolo genere maschile"),
            keywords: &[
                "maschio",
                "simbolo di maschio",
                "simbolo genere maschile",
                "uomo",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("男性のマーク"),
            keywords: &["シンボル", "男", "男性", "男性のマーク"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("tandha priya"),
            keywords: &["lanang", "tandha priya"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მამრობითი"),
            keywords: &["კაცი", "მამრობითი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("ер таңбасы"),
            keywords: &["ер", "ер таңбасы", "таңба"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ភេទប\u{17d2}រ\u{17bb}ស"),
            keywords: &[
                "ប\u{17bb}រស",
                "ប\u{17d2}រ\u{17bb}ស",
                "ភេទ",
                "ភេទប\u{17d2}រ\u{17bb}ស",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಪುರುಷ ಚ\u{cbf}ಹ\u{ccd}ನ\u{cc6}"),
            keywords: &["ಗಂಡು", "ಪುರುಷ", "ಪುರುಷ ಚ\u{cbf}ಹ\u{ccd}ನ\u{cc6}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("남성 기호"),
            keywords: &["기호", "남성"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("दादलो चिन\u{94d}न"),
            keywords: &["दादलो", "दादलो चिन\u{94d}न"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("эркек белгиси"),
            keywords: &["эркек", "эркек белгиси"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("männlecht Zeechen"),
            keywords: &["Mann", "männlecht Zeechen"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ສ\u{eb1}ນຍາລ\u{eb1}ກຜ\u{eb9}\u{ec9}ຊາຍ"),
            keywords: &[
                "ຊາຍ",
                "ຜ\u{eb9}\u{ec9}ຊາຍ",
                "ສ\u{eb1}ນຍາລ\u{eb1}ກຜ\u{eb9}\u{ec9}ຊາຍ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("vyriškos lyties ženklas"),
            keywords: &["vyras", "vyriškos lyties ženklas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("vīriešu simbols"),
            keywords: &["vīrietis", "vīriešu simbols"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tohu tāne"),
            keywords: &["tohu tāne", "tāne"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("знак за машко"),
            keywords: &["знак за машко", "маж", "машко"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("പ\u{d41}ര\u{d41}ഷ ചിഹ\u{d4d}നം"),
            keywords: &[
                "ചിഹ\u{d4d}നം",
                "പ\u{d41}ര\u{d41}ഷ ചിഹ\u{d4d}നം",
                "പ\u{d41}ര\u{d41}ഷൻ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("эрэгтэй тэмдэг"),
            keywords: &["эрэгтэй", "эрэгтэй тэмдэг", "эрэгтэй хүн"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("प\u{941}र\u{941}ष चिन\u{94d}ह"),
            keywords: &["प\u{941}र\u{941}ष", "प\u{941}र\u{941}ष चिन\u{94d}ह"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("simbol lelaki"),
            keywords: &["lelaki", "simbol lelaki"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("sinjal maskili"),
            keywords: &["raġel", "sinjal maskili"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အဖ\u{102d}\u{102f}သင\u{103a}\u{1039}ကေတ"),
            keywords: &[
                "အဖ\u{102d}\u{102f}သင\u{103a}\u{1039}ကေတ",
                "အမျ\u{102d}\u{102f}းသား",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("mannssymbol"),
            keywords: &["mann", "mannssymbol"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("प\u{941}र\u{942}ष चिन\u{94d}ह"),
            keywords: &[
                "छोरा मान\u{94d}छ\u{947}",
                "प\u{941}र\u{942}ष",
                "प\u{941}र\u{942}ष चिन\u{94d}ह",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("mannelijkheidssymbool"),
            keywords: &["man", "mannelijkheidssymbool"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("mannssymbol"),
            keywords: &["mann", "mannssymbol"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ପ\u{b41}ର\u{b41}ଷ ଚ\u{b3f}ହ\u{b4d}ନ"),
            keywords: &["ପ\u{b41}ର\u{b41}ଷ", "ପ\u{b41}ର\u{b41}ଷ ଚ\u{b3f}ହ\u{b4d}ନ"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਪ\u{a41}ਰਸ\u{a3c} ਚਿ\u{a70}ਨ\u{a4d}ਹ"),
            keywords: &[
                "ਪ\u{a41}ਰਸ\u{a3c}",
                "ਪ\u{a41}ਰਸ\u{a3c} ਚਿ\u{a70}ਨ\u{a4d}ਹ",
                "ਬ\u{a70}ਦਾ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("مرد دی علامت"),
            keywords: &["بندہ", "مرد دی علامت"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Man Sain"),
            keywords: &["Man", "Man Sain"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("znak mężczyzny"),
            keywords: &["męski", "mężczyzna", "znak", "znak mężczyzny"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("نارينه نښه"),
            keywords: &["نارينه", "نارينه نښه"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("símbolo de masculino"),
            keywords: &["homem", "masculino", "símbolo de masculino"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("símbolo masculino"),
            keywords: &["homem", "símbolo masculino"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("tata unancha"),
            keywords: &["runa", "tata unancha"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("semn masculin"),
            keywords: &["bărbat", "masculin", "semn masculin"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-063"),
            keywords: &["E10-063"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("мужской символ"),
            keywords: &["марс", "мужской символ", "мужчина", "символ"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ikimenyetso cy’umugabo"),
            keywords: &["ikimenyetso cy’umugabo", "umugabo"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("مرد جي نشاني"),
            keywords: &["مرد", "مرد جي نشاني"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ප\u{dd4}ර\u{dd4}ෂ ලක\u{dd4}ණ"),
            keywords: &[
                "ප\u{dd4}ර\u{dd4}ෂ",
                "ප\u{dd4}ර\u{dd4}ෂ ලක\u{dd4}ණ",
                "ම\u{dd2}න\u{dd2}හ\u{dcf}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("mužský symbol"),
            keywords: &["muž", "mužský symbol", "samec"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("znak za moški spol"),
            keywords: &["fant", "moški", "znak za moški spol"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("calaamad lab"),
            keywords: &["calaamad lab", "nin"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("shenja mashkull"),
            keywords: &["burrë", "mashkull", "shenja mashkull"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("мушки знак"),
            keywords: &["мушкарац", "мушки знак"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["мушки знак"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("muški znak"),
            keywords: &["muškarac", "muški znak"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["muški znak"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("manssymbol"),
            keywords: &["man", "manlig", "manssymbol"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("ishara ya jinsia ya kiume"),
            keywords: &["ishara ya jinsia ya kiume", "mwanamume"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ஆண\u{bcd}களைக\u{bcd} குறிக\u{bcd}கும\u{bcd} சின\u{bcd}னம\u{bcd}"),
            keywords: &[
                "ஆடவர\u{bcd}",
                "ஆண\u{bcd}",
                "ஆண\u{bcd}களைக\u{bcd} குறிக\u{bcd}கும\u{bcd} சின\u{bcd}னம\u{bcd}",
                "சின\u{bcd}னம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("పురుషుల సంక\u{c47}తం"),
            keywords: &["పురుషుడు", "పురుషుల సంక\u{c47}తం", "మగ\u{c3e}డు"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("аломати мард"),
            keywords: &["аломати мард", "мард"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ส\u{e31}ญล\u{e31}กษณ\u{e4c}เพศชาย"),
            keywords: &["ผ\u{e39}\u{e49}ชาย", "ส\u{e31}ญล\u{e31}กษณ\u{e4c}เพศชาย"],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ናይ ወዲ-ተባዕታይ ምልክት"),
            keywords: &["ናይ ወዲ-ተባዕታይ ምልክት", "ወዲ-ተባዕታይ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("erkek nyşany"),
            keywords: &["erkek", "erkek nyşany"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("ʻilonga fakatangata"),
            keywords: &["tangata", "ʻilonga", "ʻilonga fakatangata"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("erkek sembolü"),
            keywords: &["adam", "erkek", "erkek sembolü"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئەر بەلگىسى"),
            keywords: &["ئەر", "ئەر بەلگىسى"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("символ чоловіка"),
            keywords: &[
                "знак чоловіка",
                "символ чоловіка",
                "чоловік",
                "чоловіча стать",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("مردوں کیلئے"),
            keywords: &["علامت", "لڑکا", "مرد", "مردوں کیلئے"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("erkak belgisi"),
            keywords: &["erkak", "erkak belgisi"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("ký hiệu nam"),
            keywords: &["ký hiệu nam", "đàn ông"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("màndarga góor"),
            keywords: &["góor", "màndarga góor"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("uphawu lwendoda"),
            keywords: &["indoda", "uphawu lwendoda"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("àmì ọkùnrin"),
            keywords: &["àmì ọkùnrin", "Ọkùnrin"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("男性標誌"),
            keywords: &["男", "男性標誌"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("男性标志"),
            keywords: &["男", "男性标志"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("男性符号"),
            keywords: &["男性符号", "符号", "雄性"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("男"),
            keywords: &["男"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("upahwu lwendoda"),
            keywords: &["indoda", "upahwu lwendoda"],
        },
    ],
};
#[doc = "⚧\u{fe0f}"]
pub const TRANSGENDER_SYMBOL: crate::Emoji = crate::Emoji {
    glyph: "⚧\u{fe0f}",
    codepoint: "26A7 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 13f32,
    name: "transgender symbol",
    group: "Symbols",
    subgroup: "gender",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "⚧",
        codepoint: "26A7",
        status: crate::Status::Unqualified,
        introduction_version: 13f32,
        name: "transgender symbol",
        group: "Symbols",
        subgroup: "gender",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("transgendersimbool"),
            keywords: &["transgender", "transgendersimbool"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የትራንስጀንደር ምልክት"),
            keywords: &["የትራንስጀንደር ምልክት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("رمز المتحو\u{651}لين جنسي\u{64b}ا"),
            keywords: &[
                "رمز المتحو\u{651}لين جنسي\u{64b}ا",
                "متحو\u{651}ل جنسي\u{64b}ا",
                "متحو\u{651}لة جنسي\u{64b}ا",
            ],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ট\u{9cd}ৰ\u{9be}ণ\u{9cd}সজেণ\u{9cd}ড\u{9be}ৰ চিহ\u{9cd}ন"),
            keywords: &[
                "ট\u{9cd}ৰ\u{9be}ণ\u{9cd}সজেণ\u{9cd}ড\u{9be}ৰ",
                "ট\u{9cd}ৰ\u{9be}ণ\u{9cd}সজেণ\u{9cd}ড\u{9be}ৰ চিহ\u{9cd}ন",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("transgender simvolu"),
            keywords: &["transgender", "transgender simvolu"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("сімвал трансгендара"),
            keywords: &["сімвал трансгендара", "трансгендар"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("символ за трансджендър"),
            keywords: &["символ за трансджендър", "трансджендър"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("র\u{9c2}প\u{9be}ন\u{9cd}তরিত লিঙ\u{9cd}গ চিহ\u{9cd}ন"),
            keywords: &[
                "র\u{9c2}প\u{9be}ন\u{9cd}তরিত লিঙ\u{9cd}গ",
                "র\u{9c2}প\u{9be}ন\u{9cd}তরিত লিঙ\u{9cd}গ চিহ\u{9cd}ন",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("arouez treuzjener"),
            keywords: &["arouez", "treuzjener"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("simbol transrodnih osoba"),
            keywords: &["simbol transrodnih osoba", "transrodna osoba"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("símbol transgènere"),
            keywords: &["símbol transgènere", "trans", "transgènere"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏄᏬᎵᏍᏛᎾ ᎪᏟᏍᏙᏗ"),
            keywords: &["ᏄᏬᎵᏍᏛᎾ", "ᏄᏬᎵᏍᏛᎾ ᎪᏟᏍᏙᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("symbol pro transgender osoby"),
            keywords: &["symbol pro transgender osoby", "transgender"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("symbol trawsryweddol"),
            keywords: &["symbol trawsryweddol", "trawsryweddol"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("symbol for transkønnethed"),
            keywords: &["symbol for transkønnethed", "transkønnet"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Transgender-Symbol"),
            keywords: &[
                "Symbol für Transgender",
                "Transgender",
                "Transgender-Symbol",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("σύμβολο της διεμφυλικότητας"),
            keywords: &["διεμφυλικός", "σύμβολο της διεμφυλικότητας"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("transgender symbol"),
            keywords: &["transgender", "transgender symbol"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: None,
            keywords: &["trans", "transgender", "transgender symbol"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["trans", "transgender", "transgender symbol"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("símbolo de transgénero"),
            keywords: &["símbolo de transgénero", "transgénero"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("transsoolisuse sümbol"),
            keywords: &["transsoolisus", "transsoolisuse sümbol"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("transgeneroen ikurra"),
            keywords: &["transgeneroa", "transgeneroen ikurra"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("علامت تراجنسیتی"),
            keywords: &["تراجنسیتی", "علامت تراجنسیتی"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("transsymboli"),
            keywords: &["trans", "transsukupuolinen", "transsymboli"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("simbolo ng transgender"),
            keywords: &["simbolo ng transgender", "transgender"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("tvørkyndtekin"),
            keywords: &["tvørkynd", "tvørkyndtekin", "tvørkyndur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("symbole de la communauté transgenre"),
            keywords: &["symbole de la communauté transgenre", "transgenre"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("symbole transgenre"),
            keywords: &[
                "symbole de la communauté transgenre",
                "symbole transgenre",
                "transgenre",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("siombail thrasinsnce"),
            keywords: &["siombail thrasinsnce", "siombail thrasinsnceach"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("samhla tar-ghnèitheach"),
            keywords: &["samhla tar-ghnèitheach", "tar-ghnèitheach"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("símbolo de transxénero"),
            keywords: &["sexo", "símbolo de transxénero", "transxénero", "xénero"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ટ\u{acd}રાન\u{acd}સજ\u{ac7}ન\u{acd}ડરન\u{ac1}\u{a82} પ\u{acd}રતીક"),
            keywords: &[
                "ટ\u{acd}રાન\u{acd}સજ\u{ac7}ન\u{acd}ડર",
                "ટ\u{acd}રાન\u{acd}સજ\u{ac7}ન\u{acd}ડરન\u{ac1}\u{a82} પ\u{acd}રતીક",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("סמל לטרנסג׳נדר"),
            keywords: &["טרנסג׳נדר", "סמל לטרנסג׳נדר"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ट\u{94d}रा\u{902}सज\u{947}\u{902}डर चिह\u{94d}न"),
            keywords: &[
                "ट\u{94d}रा\u{902}सज\u{947}\u{902}डर",
                "ट\u{94d}रा\u{902}सज\u{947}\u{902}डर चिह\u{94d}न",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("simbol transrodnosti"),
            keywords: &["simbol transrodnosti", "transrodnost"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("transznemű szimbólum"),
            keywords: &["transznemű", "transznemű szimbólum"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("տրանսգենդերի նշան"),
            keywords: &["տրանսգենդեր", "տրանսգենդերի նշան"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("simbol transgender"),
            keywords: &["simbol transgender", "transgender"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("transmerki"),
            keywords: &["trans", "transmerki"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("simbolo transgender"),
            keywords: &["simbolo transgender", "transgender"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("トランスジェンダーのマーク"),
            keywords: &[
                "LGBT",
                "TG",
                "シンボル",
                "トランスジェンダーのマーク",
                "性別",
            ],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("tandha wariya"),
            keywords: &["tandha wariya", "wariya"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ტრანსგენდერი სიმბოლო"),
            keywords: &["ტრანსგენდერი", "ტრანსგენდერი სიმბოლო"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("трансгендерлік таңба"),
            keywords: &["трансгендер", "трансгендерлік таңба"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ន\u{17b7}ម\u{17b7}ត\u{17d2}តសញ\u{17d2}ញាភេទទ\u{17b8}ប\u{17b8}"),
            keywords: &[
                "ន\u{17b7}ម\u{17b7}ត\u{17d2}តសញ\u{17d2}ញាភេទទ\u{17b8}ប\u{17b8}",
                "ភេទទ\u{17b8}ប\u{17b8}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ತೃತೀಯ ಲ\u{cbf}ಂಗ\u{cbf} ಚ\u{cbf}ಹ\u{ccd}ನ\u{cc6}"),
            keywords: &[
                "ತೃತೀಯ ಲ\u{cbf}ಂಗ\u{cbf}",
                "ತೃತೀಯ ಲ\u{cbf}ಂಗ\u{cbf} ಚ\u{cbf}ಹ\u{ccd}ನ\u{cc6}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("트랜스젠더 기호"),
            keywords: &["트랜스젠더", "트랜스젠더 기호"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("त\u{943}तियप\u{902}थी चिन\u{94d}न"),
            keywords: &["त\u{943}तियप\u{902}थी", "त\u{943}तियप\u{902}थी चिन\u{94d}न"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("трансгендер белгиси"),
            keywords: &["трансгендер белгиси"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ສ\u{eb1}ນຍາລ\u{eb1}ກຄ\u{ebb}ນ\u{200b}ຂ\u{ec9}າມ\u{200b}ເພດ"),
            keywords: &[
                "ຄ\u{ebb}ນຂ\u{ec9}າມເພດ",
                "ສ\u{eb1}ນຍາລ\u{eb1}ກຄ\u{ebb}ນ\u{200b}ຂ\u{ec9}າມ\u{200b}ເພດ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("translyčių simbolis"),
            keywords: &["translytis", "translyčių simbolis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("transdzimuma simbols"),
            keywords: &["transdzimuma simbols", "transdzimums"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("трансродов симбол"),
            keywords: &["трансродов", "трансродов симбол"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഭിന\u{d4d}നലിംഗ ചിഹ\u{d4d}നം"),
            keywords: &["ഭിന\u{d4d}നലിംഗ ചിഹ\u{d4d}നം", "ഭിന\u{d4d}നലിംഗം"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("трансжендер тэмдэг"),
            keywords: &["трансжендер", "трансжендер тэмдэг"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("ट\u{94d}रान\u{94d}सज\u{947}\u{902}डर चिन\u{94d}ह"),
            keywords: &[
                "ट\u{94d}रान\u{94d}सज\u{947}\u{902}डर",
                "ट\u{94d}रान\u{94d}सज\u{947}\u{902}डर चिन\u{94d}ह",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("simbol transgender"),
            keywords: &["simbol transgender", "transgender"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("လ\u{102d}င\u{103a}ပြောင\u{103a}းခြင\u{103a}း သင\u{103a}\u{1039}ကေတ"),
            keywords: &[
                "လ\u{102d}င\u{103a}ပြောင\u{103a}းခြင\u{103a}း",
                "လ\u{102d}င\u{103a}ပြောင\u{103a}းခြင\u{103a}း သင\u{103a}\u{1039}ကေတ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("transperson-symbol"),
            keywords: &["transperson", "transperson-symbol"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("ट\u{94d}रान\u{94d}सज\u{947}न\u{94d}डर प\u{94d}रतीक"),
            keywords: &[
                "ट\u{94d}रान\u{94d}सज\u{947}न\u{94d}डर",
                "ट\u{94d}रान\u{94d}सज\u{947}न\u{94d}डर प\u{94d}रतीक",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("transgendersymbool"),
            keywords: &["transgender", "transgendersymbool"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("transperson-symbol"),
            keywords: &["transperson", "transperson-symbol"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("କ\u{b4d}ଲୀବଲ\u{b3f}ଙ\u{b4d}ଗ ସଙ\u{b4d}କେତ"),
            keywords: &[
                "କ\u{b4d}ଲୀବଲ\u{b3f}ଙ\u{b4d}ଗ",
                "କ\u{b4d}ଲୀବଲ\u{b3f}ଙ\u{b4d}ଗ ସଙ\u{b4d}କେତ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਟਰਾ\u{a02}ਸਜ\u{a48}\u{a02}ਡਰ ਪ\u{a4d}ਰਤੀਕ"),
            keywords: &[
                "ਟਰਾ\u{a02}ਸਜ\u{a48}\u{a02}ਡਰ",
                "ਟਰਾ\u{a02}ਸਜ\u{a48}\u{a02}ਡਰ ਪ\u{a4d}ਰਤੀਕ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Transjẹ\u{301}ndá Símbul"),
            keywords: &["Transjẹ\u{301}nda", "Transjẹ\u{301}ndá Símbul"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("symbol transpłciowości"),
            keywords: &["symbol transpłciowości", "transpłciowość"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د جنس بدلوونکي سمبول"),
            keywords: &["جنس بدلوونکی", "د جنس بدلوونکي سمبول"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("símbolo transgênero"),
            keywords: &["símbolo transgênero", "transgênero"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("símbolo transgénero"),
            keywords: &["símbolo transgénero", "transgénero"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("transgenero unancha"),
            keywords: &["transgenero", "transgenero unancha"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("transgender"),
            keywords: &["simbol transgender", "transgender"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E13-075"),
            keywords: &["E13-075"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("трансгендер"),
            keywords: &[
                "символ",
                "трансгендер",
                "трансгендерная",
                "трансгендерное",
                "трансгендерные",
                "трансгендерный",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("وچ جنس جي نشاني"),
            keywords: &["وچ جنس", "وچ جنس جي نشاني"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("සංක\u{dca}\u{200d}ර\u{dcf}න\u{dca}ත\u{dd2} ල\u{dd2}ංග\u{dd2}ක සංකේතය"),
            keywords: &[
                "සංක\u{dca}\u{200d}ර\u{dcf}න\u{dca}ත\u{dd2} ල\u{dd2}ංග\u{dd2}ක සංකේතය",
                "සංක\u{dca}\u{200d}ර\u{dcf}න\u{dca}ත\u{dd2} ල\u{dd2}ංග\u{dd2}කයන\u{dca}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("transgenderový symbol"),
            keywords: &["transgender", "transgenderový symbol"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("simbol za transseksualnost"),
            keywords: &["simbol za transseksualnost", "transseksualnost"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("calaamada laba dhidiga"),
            keywords: &["calaamada laba dhidiga", "laba dhidig"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("simboli për transgjinorë"),
            keywords: &["simboli për transgjinorë", "transgjinorë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("трансродни симбол"),
            keywords: &["трансродни симбол", "трансродно"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("transrodni simbol"),
            keywords: &["transrodni simbol", "transrodno"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("transgendersymbol"),
            keywords: &["transgender", "transgendersymbol"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("ishara ya wabadili jinsia"),
            keywords: &["ishara ya wabadili jinsia", "wabadili jinsia"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("திருநங\u{bcd}கைக\u{bcd}க\u{bbe}ன குறிய\u{bc0}டு"),
            keywords: &[
                "திருநங\u{bcd}கை",
                "திருநங\u{bcd}கைக\u{bcd}க\u{bbe}ன குறிய\u{bc0}டு",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some(
                "ల\u{c3f}ంగం మ\u{c3e}ర\u{c4d}చుకున\u{c4d}న వ\u{c3e}ర\u{c3f} చ\u{c3f}హ\u{c4d}నం",
            ),
            keywords: &[
                "ల\u{c3f}ంగం మ\u{c3e}ర\u{c4d}చుకున\u{c4d}న వ\u{c3e}ర\u{c3f} చ\u{c3f}హ\u{c4d}నం",
                "ల\u{c3f}ంగం మ\u{c3e}ర\u{c4d}చుకున\u{c4d}న వ\u{c3e}ళ\u{c4d}లు",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ส\u{e31}ญล\u{e31}กษณ\u{e4c}คนข\u{e49}ามเพศ"),
            keywords: &[
                "คนข\u{e49}ามเพศ",
                "ส\u{e31}ญล\u{e31}กษณ\u{e4c}คนข\u{e49}ามเพศ",
            ],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ጸታ ዝቀየሩ ምልክት"),
            keywords: &["ጸታ ዝቀየሩ", "ጸታ ዝቀየሩ ምልክት"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("transgender nyşany"),
            keywords: &["transgender", "transgender nyşany"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("ʻilonga fakaleiti moe tomupoi"),
            keywords: &[
                "fakaleiti",
                "tomupoi",
                "ʻilonga",
                "ʻilonga fakaleiti moe tomupoi",
            ],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("transgender sembolü"),
            keywords: &["transgender", "transgender sembolü", "transseksüel"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("трансгендерний символ"),
            keywords: &["трансгендер", "трансгендерний символ"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ہیجڑوں کی علامت"),
            keywords: &["ہیجڑا", "ہیجڑوں کی علامت"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("transseksuallik belgisi"),
            keywords: &["transgender", "transseksual", "transseksuallik belgisi"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("biểu tượng chuyển giới"),
            keywords: &["biểu tượng chuyển giới", "người chuyển giới"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("跨性别人士符號"),
            keywords: &["跨性别人士", "跨性别人士符號"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("跨性别人士符号"),
            keywords: &["跨性别人士", "跨性别人士符号"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("跨性别符号"),
            keywords: &["跨性别", "跨性别符号"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("變性符號"),
            keywords: &["變性", "變性符號"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("isimbuli ye-transgender"),
            keywords: &["i-transgender", "isimbuli ye-transgender"],
        },
    ],
};
