#[doc = "💱"]
pub const CURRENCY_EXCHANGE: crate::Emoji = crate::Emoji {
    glyph: "💱",
    codepoint: "1F4B1",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "currency exchange",
    group: "Symbols",
    subgroup: "currency",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("wisselkoers"),
            keywords: &["bank", "geld", "wisselkoers"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የውጭ ምንዛሬ"),
            keywords: &["ምንዛሬ", "ባንክ", "የውጭ ምንዛሬ", "ገንዘብ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("صرف عملة"),
            keywords: &["أموال", "صرف عملة", "عملة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ম\u{9c1}দ\u{9cd}ৰ\u{9be} বিনিময\u{9bc}"),
            keywords: &["ধন", "বিনিময\u{9bc}", "বেংক", "ম\u{9c1}দ\u{9cd}ৰ\u{9be}"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("valyuta mübadiləsi"),
            keywords: &["bank", "mübadilə", "pul", "valyuta", "valyuta mübadiləsi"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("абмен валют"),
            keywords: &["абмен", "абмен валют", "банк", "валюта", "грошы"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("обмен на валута"),
            keywords: &[
                "банка",
                "валута",
                "обмен",
                "обмен на валута",
                "пари",
                "чейндж",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ম\u{9c1}দ\u{9cd}র\u{9be} বিনিময\u{9bc}"),
            keywords: &[
                "ট\u{9be}ক\u{9be}",
                "বিনিময\u{9bc}",
                "ব\u{9cd}য\u{9be}ংক",
                "ম\u{9c1}দ\u{9cd}র\u{9be}",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("mjenjačnica"),
            keywords: &["banka", "mjenjačnica", "novac", "pare", "valuta"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("canvi de divisa"),
            keywords: &["canvi", "canvi de divisa", "divisa"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏕᎳ ᎦᏁᏟᏴᏍᏗ"),
            keywords: &["ᎠᏕᎳ", "ᎠᏕᎳ ᏧᏂᏗ", "ᎦᏁᏟᏴᏍᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("směna peněz"),
            keywords: &[
                "banka",
                "měna",
                "peníze",
                "směna",
                "směna peněz",
                "směnárna",
                "výměna",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("cyfnewid arian cyfredol"),
            keywords: &[
                "arian",
                "arian cyfredol",
                "banc",
                "cyfnewid",
                "cyfnewid arian cyfredol",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("valutaveksling"),
            keywords: &["bank", "penge", "valuta", "valutaveksling", "veksling"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Geldwechsel"),
            keywords: &["Geld", "Geldwechsel", "Wechsel", "Währung"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ανταλλαγή νομισμάτων"),
            keywords: &[
                "ανταλλαγή νομισμάτων",
                "ανταλλακτήριο",
                "μετατροπή νομισμάτων",
                "συνάλλαγμα",
                "τράπεζα",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("currency exchange"),
            keywords: &["bank", "currency", "exchange", "money"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("cambio de divisas"),
            keywords: &["cambio", "cambio de divisas", "dinero", "divisa", "moneda"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &[
                "cambio",
                "cambio de divisa",
                "cambio de divisas",
                "dinero",
                "divisa",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("valuutavahetus"),
            keywords: &["pank", "raha", "vahetus", "valuuta", "valuutavahetus"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("truke-tasa"),
            keywords: &["banku", "diru", "moneta", "truke", "truke-tasa"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("تبدیل ارز"),
            keywords: &["ارز", "بانک", "تبدیل ارز", "پول"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("valuutanvaihto"),
            keywords: &["pankki", "raha", "vaihto", "valuutanvaihto", "valuutta"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("palitan ng pera"),
            keywords: &["bangko", "palitan", "palitan ng pera", "pera", "salapi"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("gjaldoyraveksil"),
            keywords: &["børs", "gjaldoyra", "gjaldoyraveksil", "veksil"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("conversion de devise"),
            keywords: &[
                "argent",
                "banque",
                "change",
                "conversion",
                "conversion de devise",
                "devise",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("change"),
            keywords: &["argent", "banque", "change", "devise"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("malartán airgeadra"),
            keywords: &["airgead", "airgeadra", "malartán airgeadra", "malartú"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("iomlaid airgid"),
            keywords: &["airgead", "airgeadra", "banca", "iomlaid", "iomlaid airgid"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cambio de divisas"),
            keywords: &["banco", "cambio", "cambio de divisas", "divisas", "diñeiro"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("મ\u{ac1}દ\u{acd}રા વિનિમય"),
            keywords: &["પ\u{ac8}સા", "મ\u{ac1}દ\u{acd}રા", "વિનિમય"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("musayar kuɗin ƙasa"),
            keywords: &[
                "banki",
                "kuɗi",
                "kuɗin ƙasa",
                "musaya",
                "musayar kuɗin ƙasa",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("המרת מטבעות"),
            keywords: &["בנק", "המרה", "המרת מטבעות", "כסף", "מטבעות"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("म\u{941}द\u{94d}रा विनिमय"),
            keywords: &["धन", "प\u{948}स\u{947}", "म\u{941}द\u{94d}रा", "विनिमय"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("mjenjačnica"),
            keywords: &["banka", "mjenjačnica", "novac", "valuta"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("pénzváltás"),
            keywords: &[
                "bank",
                "pénz",
                "pénzváltás",
                "pénzváltó",
                "valuta",
                "átváltás",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("տարադրամի փոխանակում"),
            keywords: &[
                "բանկ",
                "տարադրամ",
                "տարադրամի փոխանակում",
                "փոխանակում",
                "փող",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("kurs"),
            keywords: &["bank", "kurs", "mata uang", "uang"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("mgbanwe ego"),
            keywords: &["akwụkwọego", "ego", "mgbanwe", "ụlọ akụ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("gjaldmiðlar"),
            keywords: &[
                "gjaldmiðlar",
                "gjaldmiðlareikningur",
                "gjaldmiðlaskipti",
                "peningar",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("cambio valuta"),
            keywords: &["cambio", "cambio di valuta", "denaro", "valuta"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("外貨両替"),
            keywords: &["お金", "ドル", "両替", "円", "外貨両替", "通貨"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("rega ijol mata uang"),
            keywords: &[
                "bank",
                "dhuwit",
                "ijol-ijolan",
                "mata uang",
                "rega ijol mata uang",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ვალუტის გადაცვლა"),
            keywords: &[
                "ბანკი",
                "გადაცვლა",
                "გაცვლა",
                "ვალუტა",
                "ვალუტის გადაცვლა",
                "ფული",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("валюта айырбастау"),
            keywords: &["айырбастау", "ақша", "банк", "валюта"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("valutaveksling"),
            keywords: &["bank", "penge", "valuta", "valutaveksling", "veksling"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ដ\u{17bc}រល\u{17bb}យ"),
            keywords: &[
                "ដ\u{17bc}រល\u{17bb}យ",
                "ធនាគារ",
                "ប\u{17d2}ត\u{17bc}រប\u{17d2}រាក\u{17cb}",
                "រ\u{17bc}ប\u{17b7}យប\u{17d0}ណ\u{17d2}ណ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕರ\u{cc6}ನ\u{ccd}ಸ\u{cbf} ವ\u{cbf}ನ\u{cbf}ಮಯ"),
            keywords: &[
                "ಕರ\u{cc6}ನ\u{ccd}ಸ\u{cbf}",
                "ಕರ\u{cc6}ನ\u{ccd}ಸ\u{cbf} ವ\u{cbf}ನ\u{cbf}ಮಯ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("환전"),
            keywords: &["교환", "돈", "화폐", "환전"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("चलन विनियोग"),
            keywords: &["चलन", "पयश\u{947}", "ब\u{901}क", "विनियोग"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("акча алмаштыруу"),
            keywords: &["акча", "алмаштыруу", "валюта"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Wiesselcours"),
            keywords: &["Bank", "Geld", "Suen", "Wiesselcours", "Währung"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ແລກປ\u{ec8}ຽນເງ\u{eb4}ນຕາ"),
            keywords: &[
                "ທະນາຄານ",
                "ສະກ\u{eb8}ນເງ\u{eb4}ນ",
                "ອ\u{eb1}ດຕາແລກປ\u{ec8}ຽນ",
                "ເງ\u{eb4}ນ",
                "ແລກປ\u{ec8}ຽນເງ\u{eb4}ນຕາ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("valiutos keitimas"),
            keywords: &[
                "bankas",
                "keitimas",
                "pinigai",
                "valiuta",
                "valiutos keitimas",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("valūtas maiņa"),
            keywords: &["banka", "maiņa", "nauda", "valūta", "valūtas maiņa"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("whakawhitinga momo moni"),
            keywords: &[
                "momo moni",
                "moni",
                "pēke",
                "whakawhitinga momo moni",
                "whakawhitiwhiti",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("размена на валути"),
            keywords: &["банка", "валути", "пари", "размена", "размена на валути"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("കറൻസി വിനിമയം"),
            keywords: &[
                "എക\u{d4d}\u{200c}സ\u{d4d}\u{200c}ചേഞ\u{d4d}ച\u{d4d}",
                "കറൻസി",
                "പണം",
                "ബ\u{d3e}ങ\u{d4d}ക\u{d4d}. കറൻസി",
                "വിനിമയം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("валют арилжаа"),
            keywords: &["арилжаа", "банк", "валют", "мөнгө"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("चलन विनिमय"),
            keywords: &["चलन", "प\u{948}सा", "ब\u{901}क", "विनिमय"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("pertukaran mata wang"),
            keywords: &[
                "bank",
                "mata wang",
                "pertukaran",
                "pertukaran mata wang",
                "wang",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("kambju tal-munita"),
            keywords: &["bank", "flus", "kambju tal-munita", "munita", "skambju"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "န\u{102d}\u{102f}င\u{103a}င\u{1036}ခြားင\u{103d}ေ လ\u{1032}လ\u{103e}ယ\u{103a}ခြင\u{103a}း",
            ),
            keywords: &[
                "င\u{103d}ေ",
                "င\u{103d}ေကြေးစနစ\u{103a}",
                "င\u{103d}ေလ\u{1032}လ\u{103e}ယ\u{103a}ခြင\u{103a}း",
                "န\u{102d}\u{102f}င\u{103a}င\u{1036}ခြားင\u{103d}ေ လ\u{1032}လ\u{103e}ယ\u{103a}ခြင\u{103a}း",
                "ဘဏ\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("valutaveksling"),
            keywords: &["bank", "penger", "valuta", "valutaveksling", "veksling"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("म\u{941}द\u{94d}रा बिनिमय"),
            keywords: &[
                "प\u{948}सा",
                "बिनिमय",
                "ब\u{948}\u{902}क",
                "म\u{941}द\u{94d}रा",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("geld wisselen"),
            keywords: &["geld", "valuta", "wisselen"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("valutaveksling"),
            keywords: &["bank", "pengar", "valuta", "valutaveksling", "veksling"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ମ\u{b41}ଦ\u{b4d}ର\u{b3e} ବ\u{b3f}ନ\u{b3f}ମୟ"),
            keywords: &[
                "ଟଙ\u{b4d}କ\u{b3e}",
                "ବ\u{b3f}ନ\u{b3f}ମୟ",
                "ମ\u{b41}ଦ\u{b4d}ର\u{b3e}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਕਰ\u{a70}ਸੀ ਐਕਸਚ\u{a47}\u{a02}ਜ"),
            keywords: &[
                "ਕਰ\u{a70}ਸੀ ਐਕਸਚ\u{a47}\u{a02}ਜ",
                "ਪ\u{a48}ਸਾ",
                "ਬਦਲਣਾ",
                "ਮ\u{a41}\u{a71}ਦਰਾ",
                "ਮ\u{a41}\u{a71}ਦਰਾ ਬਦਲੀ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("کرنسی دا تبادلہ"),
            keywords: &["بینک", "تبادلہ", "پیسے", "کرنسی", "کرنسی دا تبادلہ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Kọ\u{301}rẹ\u{301}nsí Ẹ\u{301}kschenj"),
            keywords: &[
                "Bank",
                "Chenj",
                "Kọ\u{301}rẹ\u{301}nsi",
                "Kọ\u{301}rẹ\u{301}nsí Ẹ\u{301}kschenj",
                "Mọní",
                "Ẹ\u{301}ksenj",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("wymiana walut"),
            keywords: &["kantor", "waluta", "wymiana", "wymiana walut"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د اسعارو تبادله"),
            keywords: &["اسعار", "بانک", "تبادله", "د اسعارو تبادله", "پيسې"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("câmbio de moeda"),
            keywords: &["banco", "câmbio", "câmbio de moeda", "dinheiro", "moeda"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("câmbio de moeda"),
            keywords: &["banco", "câmbio", "câmbio de moeda", "dinheiro", "moeda"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("tikrasqa qullqi"),
            keywords: &["banco", "qullqi", "tikrasqa qullqi", "tikray"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("schimb valutar"),
            keywords: &["bani", "schimb", "schimb valutar", "valută"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-622"),
            keywords: &["E10-622"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("обмен валюты"),
            keywords: &["валюта", "деньги", "касса", "обмен валюты", "пункт"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("kuvunja amafaranga"),
            keywords: &[
                "amafaranga",
                "banki",
                "ifaranga",
                "ivunja",
                "kuvunja amafaranga",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("سڪو مٽاسٽا"),
            keywords: &["بئنڪ", "بدلائڻ", "رقم", "سڪو مٽاسٽا", "پئسا"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ම\u{dd4}දල\u{dca} හ\u{dd4}වම\u{dcf}ර\u{dd4}ව"),
            keywords: &[
                "බැංක\u{dd4}ව",
                "ම\u{dd4}දල\u{dca}",
                "ම\u{dd4}දල\u{dca} වර\u{dca}ගය",
                "හ\u{dd4}වම\u{dcf}ර\u{dd4}ව",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("zmenáreň"),
            keywords: &["banka", "mena", "peniaze", "zmenáreň"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("menjava valut"),
            keywords: &["banka", "denar", "menjava", "menjava valut", "valuta"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("sarifka lacagaha"),
            keywords: &["bangi", "lacag", "sarif", "sarifka lacagaha"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("këmbimi i valutës"),
            keywords: &["bankë", "këmbim", "këmbimi i valutës", "monedhë", "para"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("конверзија валута"),
            keywords: &["бaнкa", "вaлутa", "конверзија валута", "мeњaчницa", "нoвaц"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["конверзија валута"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("konverzija valuta"),
            keywords: &[
                "banka",
                "konverzija valuta",
                "menjačnica",
                "novac",
                "valuta",
            ],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["konverzija valuta"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("valutaväxling"),
            keywords: &["pengar", "valuta", "valutaväxling", "växelkurs"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("sarafu mbalimbali"),
            keywords: &[
                "benki",
                "pesa",
                "sarafu",
                "sarafu mbalimbali",
                "ubadilishaji wa pesa",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("ubadilishanaji wa sarafu"),
            keywords: &[
                "benki",
                "pesa",
                "sarafu",
                "sarafu mbalimbali",
                "ubadilishaji wa pesa",
                "ubadilishanaji wa sarafu",
            ],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ந\u{bbe}ணயப\u{bcd} பரிம\u{bbe}ற\u{bcd}றம\u{bcd}"),
            keywords: &[
                "ந\u{bbe}ணயப\u{bcd} பரிம\u{bbe}ற\u{bcd}றம\u{bcd}",
                "பணப\u{bcd} பரிம\u{bbe}ற\u{bcd}றம\u{bcd}",
                "பணம\u{bcd}",
                "வங\u{bcd}கி",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("కర\u{c46}న\u{c4d}స\u{c40} మ\u{c3e}ర\u{c4d}ప\u{c3f}డ\u{c3f}"),
            keywords: &[
                "కర\u{c46}న\u{c4d}స\u{c40}",
                "కర\u{c46}న\u{c4d}స\u{c40} మ\u{c3e}ర\u{c4d}ప\u{c3f}డ\u{c3f}",
                "మ\u{c3e}ర\u{c4d}పు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("мубодилаи асъор"),
            keywords: &["асъор", "бонк", "мубодила", "мубодилаи асъор", "пул"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("การแลกเปล\u{e35}\u{e48}ยนเง\u{e34}น"),
            keywords: &[
                "การแลกเปล\u{e35}\u{e48}ยนเง\u{e34}น",
                "ธนาคาร",
                "สก\u{e38}ลเง\u{e34}น",
                "เง\u{e34}น",
                "แลกเปล\u{e35}\u{e48}ยน",
            ],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ለውጢ ገንዘብ"),
            keywords: &["ለውጢ", "ባንክ", "ገንዘብ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("walýuta çalşygy"),
            keywords: &[
                "alyş-çalyş",
                "bank",
                "pul",
                "pul birligi",
                "walýuta çalşygy",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("paʻanga fakafetongi"),
            keywords: &["fakafetongi", "pangikē", "paʻanga"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("kambiyo"),
            keywords: &["bozdurma", "döviz", "kambiyo", "para"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("پۇل ئالماشتۇرۇش"),
            keywords: &["ئاقچا", "ئالماشتۇرۇش", "بانكا", "پۇل"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("обмін валют"),
            keywords: &["банк", "валюта", "гроші", "обмін", "обмін валют"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("کرنسی کا تبادلہ"),
            keywords: &["بنک", "تبادلہ", "رقم", "کرنسی", "کرنسی کا تبادلہ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("pul birligini almashtirish"),
            keywords: &[
                "ayirboshlash",
                "bank",
                "pul",
                "pul birligini almashtirish",
                "valyuta",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("đổi tiền"),
            keywords: &["ngân hàng", "tiền", "tiền tệ", "đổi tiền"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("wecci koppar"),
            keywords: &["bànk", "koppar", "wecci", "xaalis"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("utshintshiselwano lwekharensi"),
            keywords: &[
                "ibhanki",
                "ikharensi",
                "imali",
                "utshintshiselwano",
                "utshintshiselwano lwekharensi",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("paṣiparọ owo"),
            keywords: &[
                "owó",
                "paṣiparọ owo",
                "pàṣépàrò\u{329}",
                "ìlé ìfowópamọ\u{301}",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("貨幣兌換"),
            keywords: &["兌換", "貨幣", "貨幣兌換", "銀行", "錢"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("货币兑换"),
            keywords: &["兑换", "货币", "货币兑换", "钱", "银行"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("货币兑换"),
            keywords: &["兑换", "外汇", "换汇", "汇率", "流通", "货币兑换"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("貨幣兌換"),
            keywords: &["換匯", "貨幣兌換"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["兌換", "匯兌", "外匯", "貨幣", "貨幣兌換"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("izinga lokushintshanisa imali"),
            keywords: &[
                "ibhange",
                "imali",
                "izinga lokushintshanisa imali",
                "uhlobo lwemali",
                "ukushintsha",
            ],
        },
    ],
};
#[doc = "💲"]
pub const HEAVY_DOLLAR_SIGN: crate::Emoji = crate::Emoji {
    glyph: "💲",
    codepoint: "1F4B2",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "heavy dollar sign",
    group: "Symbols",
    subgroup: "currency",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("dik dollarteken"),
            keywords: &["dik dollarteken", "dollar", "geld", "wisselkoers"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ወፍራም የዶላር ምልክት"),
            keywords: &["ምንዛሬ", "ወፍራም የዶላር ምልክት", "ዶላር", "ገንዘብ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("علامة دولار"),
            keywords: &["أموال", "علامة دولار"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ড\u{9be}ঠ হৰফৰ ডল\u{9be}ৰ চিহ\u{9cd}ন"),
            keywords: &[
                "ডল\u{9be}ৰ",
                "ড\u{9be}ঠ হৰফৰ ডল\u{9be}ৰ চিহ\u{9cd}ন",
                "ধন",
                "ম\u{9c1}দ\u{9cd}ৰ\u{9be}",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("qalın dollar işarəsi"),
            keywords: &["dollar", "pul", "qalın dollar işarəsi", "valyuta"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("знак долара"),
            keywords: &["валюта", "грошы", "долар", "знак долара"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("удебелен знак за долар"),
            keywords: &["валута", "долар", "пари", "удебелен знак за долар"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("খ\u{9c1}ব বড\u{9bc} ডল\u{9be}রের চিহ\u{9cd}ন"),
            keywords: &[
                "খ\u{9c1}ব বড\u{9bc} ডল\u{9be}রের চিহ\u{9cd}ন",
                "ট\u{9be}ক\u{9be}",
                "ডল\u{9be}র",
                "ম\u{9c1}দ\u{9cd}র\u{9be}",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("podebljani znak dolara"),
            keywords: &["dolar", "pare", "podebljani znak dolara", "valuta"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("signe de dòlar gran"),
            keywords: &["dòlar", "gran", "signe", "signe de dòlar gran"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᏓᎨᏓ ᎤᏃᏍᏗ ᎪᏪᎵ"),
            keywords: &["ᎠᏕᎳ", "ᎤᎾᏓᏚᎬ", "ᎤᏃᏍᏗ", "ᎤᏓᎨᏓ ᎤᏃᏍᏗ ᎪᏪᎵ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("znak dolaru"),
            keywords: &["dolar", "měna", "peníze", "znak dolaru"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("arwydd doler drom"),
            keywords: &["arian", "arian cyfredol", "arwydd doler drom", "doler"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("dollartegn"),
            keywords: &["dollar", "dollartegn"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Dollarzeichen extrafett"),
            keywords: &["Dollar", "Dollarzeichen extrafett", "Geld", "Währung"],
        },
        #[cfg(feature = "de_CH")]
        crate::Annotation {
            lang: "de_CH",
            tts: Some("fettes Dollarzeichen"),
            keywords: &["fettes Dollarzeichen"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("έντονο σύμβολο δολαρίου"),
            keywords: &["έντονο σύμβολο δολαρίου", "δολάριο", "νόμισμα", "χρήματα"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("heavy dollar sign"),
            keywords: &["currency", "dollar", "heavy dollar sign", "money"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("símbolo de dólar"),
            keywords: &["dinero", "dólar", "símbolo", "símbolo de dólar"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["dinero", "divisa", "dólar", "símbolo", "símbolo de dólar"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("suur dollarimärk"),
            keywords: &["dollar", "raha", "suur dollarimärk", "valuuta"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("dolar-ikur lodia"),
            keywords: &["diru", "dolar", "dolar-ikur lodia", "moneta"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("نماد دلار"),
            keywords: &["ارز", "دلار", "نماد دلار", "پول"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("paksu dollarimerkki"),
            keywords: &["dollari", "paksu dollarimerkki", "raha", "valuutta"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("malaking dollar sign"),
            keywords: &[
                "dolyar",
                "malaking dollar sign",
                "malaking palatandaan",
                "pera",
                "salapi",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("stórt dollartekn"),
            keywords: &[
                "dollarar",
                "dollari",
                "dollartekn",
                "gjaldoyra",
                "pengar",
                "peningur",
                "stórt dollartekn",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("symbole dollar"),
            keywords: &["argent", "dollar", "symbole dollar"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("symbole du dollar en gras"),
            keywords: &["argent", "devise", "dollar", "symbole du dollar en gras"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("comhartha dollair trom"),
            keywords: &[
                "airgead",
                "comhartha dollair",
                "comhartha dollair trom",
                "dollar",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("samhla dolair trom"),
            keywords: &["airgead", "airgeadra", "dolar", "samhla dolair trom"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("símbolo do dólar"),
            keywords: &["divisa", "diñeiro", "dólar", "moeda", "símbolo do dólar"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ઘાટ\u{ac1}\u{a82} ડૉલરન\u{ac1}\u{a82} ચિહ\u{acd}ન"),
            keywords: &[
                "ઘાટ\u{ac1}\u{a82} ડૉલર ચિહ\u{acd}ન",
                "ઘાટ\u{ac1}\u{a82} ડૉલરન\u{ac1}\u{a82} ચિહ\u{acd}ન",
                "ડૉલર",
                "ડૉલર ચિહ\u{acd}ન",
                "પ\u{ac8}સા",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("alamar dala mai kauri"),
            keywords: &["alamar dala mai kauri", "dala", "kuɗi", "kuɗin ƙasa"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("סימן דולר"),
            keywords: &["דולר", "כסף", "מטבע", "סימן דולר"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("डॉलर का चिह\u{94d}न"),
            keywords: &[
                "गहरा डॉलर चिह\u{94d}न",
                "डॉलर",
                "डॉलर का चिह\u{94d}न",
                "प\u{948}स\u{947}",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("masno otisnut znak dolara"),
            keywords: &["dolar", "masno otisnut znak dolara", "novac", "valuta"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("vastag dollárjel"),
            keywords: &["dollár", "pénz", "pénznem", "vastag dollárjel"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("դոլարի թավ նշան"),
            keywords: &["դոլար", "դոլարի թավ նշան", "տարադրամ", "փող"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("tanda dolar tebal"),
            keywords: &[
                "dolar",
                "mata uang",
                "tanda dolar tebal",
                "tanda dollar tebal",
                "uang",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("nnukwu akara dọlla"),
            keywords: &["akwụkwọego", "dọlla", "ego", "nnukwu akara dọlla"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("dollaramerki"),
            keywords: &[
                "dalur",
                "dollaramerki",
                "dollari",
                "feitletrað dollaramerki",
                "peningar",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("Dollaro"),
            keywords: &["Dollaro", "denaro", "simbolo del Dollaro"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ドル記号"),
            keywords: &["お金", "ドル", "ドル記号", "通貨"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("tandha dolar kandel"),
            keywords: &["dhuwit", "dolar", "mata uang", "tandha dolar kandel"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მსხვილი დოლარის ნიშანი"),
            keywords: &["დოლარი", "ვალუტა", "მსხვილი დოლარის ნიშანი", "ფული"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: None,
            keywords: &["adulaṛ", "idrimen", "tadrimt"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("қалың доллар белгісі"),
            keywords: &["ақша", "валюта", "доллар", "қалың доллар белгісі"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("dollartegn"),
            keywords: &["dollartegn"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ដ\u{17bb}ល\u{17d2}លារ"),
            keywords: &[
                "ដ\u{17bb}ល\u{17d2}លារ",
                "រ\u{17bc}\u{200b}ប\u{17b7}យប\u{17d0}ណ\u{17d2}ណ",
                "ល\u{17bb}យ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಭಾರ\u{cbf} ಡಾಲರ\u{ccd} ಚ\u{cbf}ಹ\u{ccd}ನ\u{cc6}"),
            keywords: &[
                "ಡಾಲರ\u{ccd}",
                "ಡಾಲರ\u{ccd} ಚ\u{cbf}ಹ\u{ccd}ನ\u{cc6}",
                "ದಪ\u{ccd}ಪ ಡಾಲರ\u{ccd} ಚ\u{cbf}ಹ\u{ccd}ನ\u{cc6}",
                "ಭಾರ\u{cbf} ಡಾಲರ\u{ccd} ಚ\u{cbf}ಹ\u{ccd}ನ\u{cc6}",
                "ಹಣ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("미국 달러"),
            keywords: &["달러화", "돈", "미국 달러", "미국 돈", "미국 화폐", "불"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("जड डॉलर क\u{941}र\u{942}"),
            keywords: &["चलन", "जड डॉलर क\u{941}र\u{942}", "डॉलर", "पयश\u{947}"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("жоон доллар белгиси"),
            keywords: &["акча", "валюта", "доллар", "жоон доллар белгиси"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("déckt Dollarzeechen"),
            keywords: &["Dollar", "Geld", "Suen", "Währung", "déckt Dollarzeechen"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ສ\u{eb1}ນຍາລ\u{eb1}ກໂດລາໃຫຍ\u{ec8}ໜາ"),
            keywords: &["ສ\u{eb1}ນຍາລ\u{eb1}ກໂດລາໃຫຍ\u{ec8}ໜາ", "ເງ\u{eb4}ນ", "ໂດລາ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("paryškintas dolerio ženklas"),
            keywords: &[
                "doleris",
                "paryškintas dolerio ženklas",
                "pinigai",
                "valiuta",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("dolāra zīme"),
            keywords: &["dolāra zīme", "dolārs", "nauda"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tohu tāra taumaha"),
            keywords: &["momo moni", "moni", "tohu tāra taumaha", "tāra"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("задебелен знак за долар"),
            keywords: &["валута", "долар", "задебелен знак за долар", "пари"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("വലിയ ഡോളർ ചിഹ\u{d4d}നം"),
            keywords: &[
                "കട\u{d4d}ടിയ\u{d41}ള\u{d4d}ള ഡോളർ സൈൻ",
                "ഡോളർ",
                "ഡോളർ സൈൻ",
                "പണം",
                "വലിയ ഡോളർ ചിഹ\u{d4d}നം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("долларын тэмдэг"),
            keywords: &["доллар", "долларын тэмдэг", "тэмдэг"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("मोठ\u{947} डॉलरच\u{947} चिन\u{94d}ह"),
            keywords: &[
                "चलन",
                "डॉलर",
                "प\u{948}सा",
                "मोठ\u{947} डॉलरच\u{947} चिन\u{94d}ह",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("tanda dolar tebal"),
            keywords: &["dolar", "mata wang", "tanda dolar tebal", "wang"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("sinjal tad-dollaru grassett"),
            keywords: &["dollaru", "flus", "munita", "sinjal tad-dollaru grassett"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဒေါ\u{103a}လာ သင\u{103a}\u{1039}ကေတ စာလ\u{102f}\u{1036}းကြ\u{102e}း"),
            keywords: &[
                "င\u{103d}ေ",
                "င\u{103d}ေကြေး",
                "ဒေါ\u{103a}လာ",
                "ဒေါ\u{103a}လာ သင\u{103a}\u{1039}ကေတ စာလ\u{102f}\u{1036}းကြ\u{102e}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("dollartegn"),
            keywords: &["dollar", "dollartegn", "penger", "stort dollartegn"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("भारी डलरको चिन\u{94d}ह"),
            keywords: &[
                "डलर",
                "प\u{948}सा",
                "भारी डलरको चिन\u{94d}ह",
                "म\u{941}द\u{94d}रा",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("dollarteken"),
            keywords: &["dollar", "dollarteken", "geld", "vetgedrukt dollarteken"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("dollarteikn"),
            keywords: &["dollar", "dollarteikn", "pengar", "stort dollarteikn"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଭ\u{b3e}ରୀ ଡଲ\u{b3e}ର\u{b4d}\u{200c} ଚ\u{b3f}ହ\u{b4d}ନ"),
            keywords: &[
                "ଟଙ\u{b4d}କ\u{b3e}",
                "ଡଲ\u{b3e}ର\u{b4d}",
                "ଡଲ\u{b3e}ର\u{b4d} ଚ\u{b3f}ହ\u{b4d}ନ",
                "ବୋଲ\u{b4d}ଡ\u{b4d} ଡଲ\u{b3e}ର\u{b4d} ଚ\u{b3f}ହ\u{b4d}ନ",
                "ଭ\u{b3e}ରୀ ଡଲ\u{b3e}ର\u{b4d}\u{200c} ଚ\u{b3f}ହ\u{b4d}ନ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਡਾਲਰ ਦਾ ਵ\u{a71}ਡਾ ਨਿਸ\u{a3c}ਾਨ"),
            keywords: &[
                "ਗ\u{a41}ੜ\u{a4d}ਹਾ ਡਾਲਰ ਨਿਸ\u{a3c}ਾਨ",
                "ਡਾਲਰ",
                "ਡਾਲਰ ਦਾ ਵ\u{a71}ਡਾ ਨਿਸ\u{a3c}ਾਨ",
                "ਡਾਲਰ ਨਿਸ\u{a3c}ਾਨ",
                "ਪ\u{a48}ਸਾ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("واوا ڈالر دی علامت"),
            keywords: &["واوا ڈالر دی علامت", "پیسے", "ڈالر", "کرنسی"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Hẹ\u{301}ví Dọ\u{301}lá Sain"),
            keywords: &[
                "Dọ\u{301}la",
                "Hẹ\u{301}ví Dọ\u{301}lá Sain",
                "Kọ\u{301}rẹ\u{301}nsi",
                "Mọní",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("gruby symbol dolara"),
            keywords: &[
                "dolary",
                "gruby symbol dolara",
                "pieniądze",
                "usd",
                "waluta",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د دروند ډالر نښان"),
            keywords: &["اسعار", "د دروند ډالر نښان", "پيسې", "ډالر"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("cifrão"),
            keywords: &["cifrão", "dinheiro", "dólar", "moeda", "símbolo do dólar"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("símbolo de dólar"),
            keywords: &["dinheiro", "dólar", "moeda", "símbolo de dólar"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("dolar unancha"),
            keywords: &["dolar unancha"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("semnul dolar îngroșat"),
            keywords: &["bani", "dolar", "semnul dolar îngroșat"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-623"),
            keywords: &["E10-623"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("жирный знак доллара"),
            keywords: &["США", "валюта", "деньги", "доллар", "жирный знак доллара"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ikimenyetso kinini cy’idolari"),
            keywords: &[
                "amafaranga",
                "idorari",
                "ifaranga",
                "ikimenyetso kinini cy’idolari",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ٿلهي ڊالر جي نشاني"),
            keywords: &["سڪو، ڊالر، پئسا", "ٿلهي ڊالر جي نشاني"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("බර ඩොලර\u{dca} ලක\u{dd4}ණ"),
            keywords: &[
                "ඩොලර\u{dca}",
                "බර ඩොලර\u{dca} ලක\u{dd4}ණ",
                "ම\u{dd4}දල\u{dca}",
                "ම\u{dd4}දල\u{dca} වර\u{dca}ගය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("znak dolára"),
            keywords: &["dolár", "mena", "peniaze", "znak dolára"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("znak za dolar"),
            keywords: &["denar", "dolar", "valuta", "znak za dolar"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("calaamad doolar oo muujisan"),
            keywords: &[
                "calaamad doolar oo muujisan",
                "calaamad doolar oo muujisn",
                "doolar",
                "lacag",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("shenjë dollari e trashur"),
            keywords: &["dollar", "monedhë", "para", "shenjë dollari e trashur"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("црни знак за долар"),
            keywords: &["вaлутa", "дoлaр", "нoвaц", "црни знак за долар"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("crni znak za dolar"),
            keywords: &["crni znak za dolar", "dolar", "novac", "valuta"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("dollartecken"),
            keywords: &["dollar", "dollartecken", "pengar"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("alama ya dola"),
            keywords: &["alama ya dola", "dola", "pesa", "sarafu"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("alama nzito ya dola"),
            keywords: &["alama nzito ya dola", "dola", "pesa", "sarafu"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("தடிமன\u{bbe}ன ட\u{bbe}லர\u{bcd} சின\u{bcd}னம\u{bcd}"),
            keywords: &[
                "ட\u{bbe}லர\u{bcd}",
                "ட\u{bbe}லர\u{bcd} சின\u{bcd}னம\u{bcd}",
                "தடிமன\u{bbe}ன ட\u{bbe}லர\u{bcd} சின\u{bcd}னம\u{bcd}",
                "ந\u{bbe}ணயம\u{bcd}",
                "பணம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("డ\u{c3e}లర\u{c4d} చ\u{c3f}హ\u{c4d}నం"),
            keywords: &[
                "కర\u{c46}న\u{c4d}స\u{c40}",
                "డబ\u{c4d}బు",
                "డ\u{c3e}లర\u{c4d} చ\u{c3f}హ\u{c4d}నం",
                "ప\u{c46}ద\u{c4d}ద డ\u{c3e}లర\u{c4d} చ\u{c3f}హ\u{c4d}నం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("аломати доллари вазнин"),
            keywords: &["аломати доллари вазнин", "асъор", "доллар", "пул"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ส\u{e31}ญล\u{e31}กษณ\u{e4c}ดอลลาร\u{e4c}"),
            keywords: &["ส\u{e31}ญล\u{e31}กษณ\u{e4c}ดอลลาร\u{e4c}", "เง\u{e34}น"],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ከቢድ ምልክት ናይ ዶላር"),
            keywords: &["ከቢድ ምልክት ናይ ዶላር", "ዶላር", "ገንዘብ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("goýy dollar belgisi"),
            keywords: &["dollar", "goýy dollar belgisi", "pul", "pul birligi"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("fakaʻilonga paʻanga mamafa"),
            keywords: &["fakaʻilonga", "fakaʻilonga paʻanga mamafa", "paʻanga"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("dolar işareti"),
            keywords: &["dolar", "dolar işareti", "koyu renk dolar işareti", "para"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئېغىر دوللار بەلگىسى"),
            keywords: &["ئاقچا", "ئېغىر دوللار بەلگىسى", "دوللار", "پۇل"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("знак долара"),
            keywords: &["валюта", "гроші", "долар", "знак долара"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("بھاری ڈالر سائن"),
            keywords: &["بنک", "بھاری ڈالر سائن", "رقم", "ڈالر", "کرنسی"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("katta dollar belgisi"),
            keywords: &["dollar", "katta dollar belgisi", "pul", "valyuta"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("ký hiệu đô la đậm"),
            keywords: &["ký hiệu đô la đậm", "tiền", "tiền tệ", "đô la"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("màndarga dolaar bu dijj"),
            keywords: &["dolaar", "koppar", "màndarga dolaar bu dijj", "xaalis"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("uphawu lwe-dollar olungqindilili"),
            keywords: &[
                "i-dollar",
                "ikharensi",
                "imali",
                "uphawu lwe-dollar olungqindilili",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("aami dọla nla"),
            keywords: &["aami dọla nla", "dọ\u{301}là", "owó"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("粗美元符號"),
            keywords: &["粗美元符號", "美元", "貨幣", "錢"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("粗美元符号"),
            keywords: &["粗美元符号", "美元", "货币", "钱"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("粗美元符号"),
            keywords: &["粗美元符号", "美元", "货币", "金钱"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("貨幣符號"),
            keywords: &["貨幣", "貨幣符號", "錢"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("錢符號"),
            keywords: &["貨幣", "錢", "錢符號"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("uphawu olukhulu lwedola"),
            keywords: &[
                "idola",
                "imali",
                "uhlobo lwemali",
                "uphawu olukhulu lwedola",
            ],
        },
    ],
};
