#[doc = "⬆\u{fe0f}"]
pub const UP_ARROW: crate::Emoji = crate::Emoji {
    glyph: "⬆\u{fe0f}",
    codepoint: "2B06 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "up arrow",
    group: "Symbols",
    subgroup: "arrow",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "⬆",
        codepoint: "2B06",
        status: crate::Status::Unqualified,
        introduction_version: 0.6f32,
        name: "up arrow",
        group: "Symbols",
        subgroup: "arrow",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("pyl na bo"),
            keywords: &["noord", "op", "pyl", "pyl na bo", "rigting"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ወደ ላይ ጠቋሚ ቀስት"),
            keywords: &["ሰሜን", "ቀስት", "አቅጣጫ", "ካርዲናል", "ወደ ላይ ጠቋሚ ቀስት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("سهم لأعلى"),
            keywords: &["اتجاه", "سهم", "سهم لأعلى", "شمال", "كاردينال"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ঊৰ\u{9cd}ধ\u{9cd}বম\u{9c1}খী ক\u{9be}\u{981}ড\u{9bc}"),
            keywords: &[
                "উত\u{9cd}তৰ",
                "ঊৰ\u{9cd}ধ\u{9cd}বম\u{9c1}খী ক\u{9be}\u{981}ড\u{9bc}",
                "ক\u{9be}\u{981}ড\u{9bc}",
                "দিশ",
                "ম\u{9c1}খ\u{9cd}য দিশবিল\u{9be}ক",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("üzüyuxarı ox"),
            keywords: &["istiqamət", "ox", "üzüyuxarı ox", "şimal", "əsas"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("стрэлка ўверх"),
            keywords: &["кірунак", "поўнач", "стрэлка", "стрэлка ўверх", "уверх"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("стрелка нагоре"),
            keywords: &["посока", "север", "стрелка", "стрелка нагоре"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("উপরে তীর"),
            keywords: &[
                "উত\u{9cd}তর",
                "উত\u{9cd}তর দিক",
                "উপরে",
                "উপরে তীর",
                "দিকনির\u{9cd}দেশ",
                "পরিম\u{9be}ণব\u{9be}চক",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("strelica nagore"),
            keywords: &["sjever", "smjer", "strelica", "strelica nagore"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("fletxa cap amunt"),
            keywords: &["amunt", "direcció", "fletxa", "fletxa cap amunt", "nord"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎦᎸᎳᏓᎦᏘ ᎦᏝᏗ"),
            keywords: &["ᎤᏴᏢᎢ", "ᎦᎸᎳᏓᎦᏘ ᎦᏝᏗ", "ᎦᏝᏗ", "ᏂᏚᏳᎪᏛᎢ", "ᏧᎵᏍᎨᏓ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("šipka nahoru"),
            keywords: &[
                "hlavní",
                "sever",
                "směr",
                "strany",
                "světové",
                "šipka",
                "šipka nahoru",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("saeth i fyny"),
            keywords: &["Gogledd", "cyfeiriad", "saeth", "saeth i fyny"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("opadvendt pil"),
            keywords: &[
                "nord",
                "opadvendt pil",
                "pil",
                "pil op",
                "retning",
                "verdenshjørne",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Pfeil nach oben"),
            keywords: &[
                "Aufwärtspfeil",
                "Norden",
                "Pfeil",
                "Pfeil nach oben",
                "aufwärts",
                "nach oben",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("πάνω βέλος"),
            keywords: &["απόλυτη", "βέλος", "βόρεια", "κατεύθυνση", "πάνω βέλος"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("up arrow"),
            keywords: &["arrow", "cardinal", "direction", "north", "up arrow"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["arrow", "cardinal", "direction", "north", "up"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("flecha hacia arriba"),
            keywords: &[
                "dirección",
                "flecha",
                "flecha arriba",
                "flecha hacia arriba",
                "norte",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &[
                "cardinal",
                "dirección",
                "flecha",
                "flecha hacia arriba",
                "flecha hacia el norte",
                "norte",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &[
                "cardinal",
                "dirección",
                "flecha",
                "flecha hacia arriba",
                "flecha hacia el norte",
                "norte",
            ],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("nool üles"),
            keywords: &["nool", "nool üles", "põhi", "suund"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("gora gezia"),
            keywords: &["gezi", "gora gezia", "ipar", "kardinal", "norabide"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("پیکان بالا"),
            keywords: &["جهت اصلی", "شمال", "مسیر", "پیکان", "پیکان بالا"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("nuoli ylös"),
            keywords: &[
                "ilmansuunta",
                "nuoli",
                "nuoli ylös",
                "pohjoinen",
                "pääilmansuunta",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("pataas na arrow"),
            keywords: &[
                "arrow",
                "cardinal",
                "direksyon",
                "hilaga",
                "pataas na arrow",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("pílur sum peikar uppeftir"),
            keywords: &[
                "k´ós",
                "norður",
                "pílur",
                "pílur sum peikar uppeftir",
                "ætt",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("flèche haut"),
            keywords: &["direction", "flèche", "flèche haut", "nord"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("flèche pointant vers le haut"),
            keywords: &[
                "direction",
                "en haut",
                "flèche",
                "flèche pointant vers le haut",
                "nord",
                "point cardinal",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("saighead suas"),
            keywords: &["príomhaird", "saighead", "suas", "treo", "ó thuaidh"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("saighead gu tuath"),
            keywords: &[
                "combaist",
                "comhair",
                "saighead",
                "saighead gu tuath",
                "tuath",
                "àirde",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("frecha cara arriba"),
            keywords: &["arriba", "dirección", "frecha cara arriba", "norte"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ઉપર તીર"),
            keywords: &["ઉત\u{acd}તર", "ઉપર", "તીર", "દિશા", "મ\u{ac1}ખ\u{acd}ય"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("kibiyar sama"),
            keywords: &["arewa", "kibiya", "kibiyar sama", "shiyya", "tsinin shiyya"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("חץ למעלה"),
            keywords: &["חץ", "כיוון", "למעלה", "צפון"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("उर\u{94d}ध\u{94d}वम\u{941}खी तीर"),
            keywords: &[
                "उत\u{94d}तर दिशा",
                "उर\u{94d}ध\u{94d}वम\u{941}खी तीर",
                "ऊपर तीर",
                "ऊपर तीर, कार\u{94d}डिनल, उत\u{94d}तर दिशा",
                "कार\u{94d}डिनल",
                "तीर",
                "दिशा",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("strelica prema gore"),
            keywords: &["sjever", "smjer", "strelica", "strelica prema gore"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("felfelé mutató nyíl"),
            keywords: &["felfelé", "felfelé mutató nyíl", "irány", "nyíl", "észak"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("վերև սլաք"),
            keywords: &["գլխավոր", "հյուսիս", "ուղղություն", "սլաք", "վերև սլաք"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("tanda panah atas"),
            keywords: &["arah", "kardinal", "panah", "tanda panah atas", "utara"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ube dị elu"),
            keywords: &["kadịnal", "nduzị", "ube", "ube dị elu", "ugwu"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("ör upp"),
            keywords: &["höfuðátt", "norður", "átt", "ör", "ör upp"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("freccia rivolta verso l’alto"),
            keywords: &[
                "direzione",
                "freccia",
                "freccia in alto",
                "freccia rivolta verso l’alto",
                "nord",
                "punto cardinale",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("上矢印"),
            keywords: &["上", "上矢印", "北", "矢印"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("panah munggah"),
            keywords: &["arah", "kardinal", "lor", "panah", "panah munggah"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ისარი ზემოთ"),
            keywords: &[
                "ისარი",
                "ისარი ზემოთ",
                "კარდინალური",
                "მიმართულება",
                "ჩრდილოეთი",
            ],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("aneccab d asawen"),
            keywords: &["aneccab d asawen"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("жоғары қараған көрсеткі"),
            keywords: &[
                "бағыт",
                "жоғары бағытты көрсеткі",
                "жоғары қараған көрсеткі",
                "көрсеткі",
                "негізгі",
                "солтүстік",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("opadvendt pil"),
            keywords: &["nord", "opadvendt pil", "pil", "retning", "verdenshjørne"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ព\u{17d2}រ\u{17bd}ញទៅលើ"),
            keywords: &[
                "ជើង",
                "ទ\u{17b7}ស",
                "ទៅលើ",
                "ព\u{17d2}រ\u{17bd}ញ",
                "ព\u{17d2}រ\u{17bd}ញទៅលើ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಮೇಲ\u{ccd}ಮುಖ ಬಾಣ"),
            keywords: &[
                "ಉತ\u{ccd}ತರ",
                "ಕಾರ\u{ccd}ಡ\u{cbf}ನಲ\u{ccd}\u{200c}",
                "ದ\u{cbf}ಕ\u{ccd}ಕು",
                "ಬಾಣ",
                "ಮೇಲ\u{ccd}ಮುಖ ಬಾಣ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("상향 화살표"),
            keywords: &["북쪽", "상향 화살표", "위쪽", "화살표"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("वयर बाण"),
            keywords: &["उत\u{94d}तर", "कार\u{94d}डिनल", "दिशा", "बाण", "वयर बाण"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("өйдө караган жебе"),
            keywords: &["багыт", "жебе", "түндүк", "өйдө караган жебе"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Feil no uewen"),
            keywords: &[
                "Feil",
                "Feil no uewen",
                "Himmelsrichtung",
                "Norden",
                "Richtung",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ລ\u{eb9}ກສອນຂ\u{eb6}\u{ec9}ນ"),
            keywords: &[
                "ຂ\u{eb6}\u{ec9}ນ",
                "ທ\u{eb4}ດທາງ",
                "ລ\u{eb9}ກສອນ",
                "ລ\u{eb9}ກສອນຂ\u{eb6}\u{ec9}ນ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("rodyklė į viršų"),
            keywords: &[
                "koordinatė",
                "kryptis",
                "rodyklė",
                "rodyklė į viršų",
                "šiaurė",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("augšupbultiņa"),
            keywords: &[
                "augšupbultiņa",
                "augšupvērsta bultiņa",
                "bultiņa",
                "norāde",
                "ziemeļi",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pere ake"),
            keywords: &["ahunga", "matua", "pere", "pere ake", "raki"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("стрелка нагоре"),
            keywords: &["горе", "север", "стрелка", "стрелка нагоре"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some(
                "മ\u{d41}കളിലേക\u{d4d}ക\u{d4d} ച\u{d42}ണ\u{d4d}ട\u{d41}ന\u{d4d}ന അമ\u{d4d}പടയ\u{d3e}ളം",
            ),
            keywords: &[
                "അമ\u{d4d}പടയ\u{d3e}ളം",
                "ക\u{d3e}ർഡിനൽ",
                "ദിശ",
                "മ\u{d41}കളിലേക\u{d4d}ക\u{d4d} ച\u{d42}ണ\u{d4d}ട\u{d41}ന\u{d4d}ന അമ\u{d4d}പടയ\u{d3e}ളം",
                "വടക\u{d4d}ക\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("дээшээ сум"),
            keywords: &["дээшээ сум", "кардинал", "сум", "хойд", "чиглэл"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("वर दर\u{94d}शविणारा बाण"),
            keywords: &[
                "उत\u{94d}तर",
                "दिशा",
                "बाण",
                "महत\u{94d}वाच\u{947}",
                "वर दर\u{94d}शविणारा बाण",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("anak panah ke atas"),
            keywords: &[
                "anak panah",
                "anak panah ke atas",
                "arah",
                "kardinal",
                "utara",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("vleġġa ’l fuq"),
            keywords: &[
                "direzzjoni",
                "kardinal",
                "tramuntana",
                "vleġġa",
                "vleġġa ’l fuq",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အပေါ\u{103a}ည\u{103d}\u{103e}န\u{103a}မြား"),
            keywords: &[
                "မြား",
                "မြောက\u{103a}အရပ\u{103a} သင\u{103a}\u{1039}ကေတ",
                "လမ\u{103a}းည\u{103d}\u{103e}န\u{103a}",
                "အပေါ\u{103a}ည\u{103d}\u{103e}န\u{103a}မြား",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("pil opp"),
            keywords: &["nord", "oppoverpil", "pil", "pil opp", "retning"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("माथि फर\u{94d}क\u{947}को तीर"),
            keywords: &[
                "उत\u{94d}तर",
                "कार\u{94d}डिनल",
                "तीर",
                "दिशा",
                "माथि फर\u{94d}क\u{947}को तीर",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("pijl omhoog"),
            keywords: &["noord", "pijl", "pijl omhoog", "richting", "windrichting"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("pil opp"),
            keywords: &["nord", "oppoverpil", "pil", "pil opp", "retning"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଉପର ତୀର"),
            keywords: &[
                "ଉପର ତୀର",
                "ତୀର",
                "ଦ\u{b3f}ଗ",
                "ପ\u{b42}ର\u{b4d}ବ",
                "ପ\u{b4d}ରଧ\u{b3e}ନ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਉ\u{a71}ਪਰ ਤੀਰ"),
            keywords: &[
                "ਉ\u{a71}ਤਰ",
                "ਉ\u{a71}ਪਰ ਤੀਰ",
                "ਕਾਰਡੀਨਲ",
                "ਤੀਰ",
                "ਦਿਸ\u{a3c}ਾ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ا\u{64f}وتلا تیر"),
            keywords: &["ا\u{64f}وتلا تیر", "اہم", "تیر", "سمت", "شمال"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Áro De Pọínt Ọp"),
            keywords: &[
                "Dairẹ\u{301}kshọn",
                "Kọ\u{301}mpas",
                "Nọt",
                "Áro",
                "Áro De Pọínt Ọp",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("strzałka w górę"),
            keywords: &[
                "kierunek",
                "północ",
                "strzałka",
                "strzałka do góry",
                "strzałka w górę",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("پورته غشی"),
            keywords: &["اساسي", "اړخ", "شمال", "غشی", "پورته غشی"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("seta para cima"),
            keywords: &["cardinal", "direção", "norte", "seta", "seta para cima"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["cardeal", "direção", "norte", "seta", "seta para cima"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("hanaq wach’i"),
            keywords: &["hanaq wach’i"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("săgeată orientată în sus"),
            keywords: &[
                "cardinal",
                "direcție",
                "nord",
                "săgeată",
                "săgeată orientată în sus",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-157"),
            keywords: &["E10-157"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("стрелка вверх"),
            keywords: &["вверх", "направление", "север", "стрелка"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("akambi kazamuka"),
            keywords: &[
                "akambi kazamuka",
                "amajyaruguru",
                "icyerekezo",
                "kimwe mu byerekezo bine",
                "umwambi",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("مٿي تير"),
            keywords: &["اتر", "تير", "طرف", "مٿي تير", "ڪارڊينل"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("උඩ\u{dd4} ඊතලය"),
            keywords: &[
                "ඊතලය",
                "උඩ\u{dd4} ඊතලය",
                "උත\u{dd4}ර",
                "ක\u{dcf}ඩ\u{dd2}නල\u{dca}",
                "ද\u{dd2}ශ\u{dcf}ව",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("šípka nahor"),
            keywords: &["hore", "nahor", "sever", "šípka"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("puščica gor"),
            keywords: &["glavno", "puščica", "puščica gor", "sever", "smer"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("fallaarta kor"),
            keywords: &[
                "afarta jiho",
                "falaar",
                "falaarta ko",
                "fallaarta kor",
                "jiho",
                "waqooyi",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("shigjeta lart"),
            keywords: &["drejtim", "kryesore", "shigjeta lart", "shigjetë", "veri"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("стрелица нагоре"),
            keywords: &["сeвeр", "смер", "стрeлицa", "стрелица нагоре"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["стрелица нагоре"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("strelica nagore"),
            keywords: &["sever", "smer", "strelica", "strelica nagore"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["strelica nagore"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("uppåtpil"),
            keywords: &["norr", "pil", "riktning", "uppåtpil", "väderstreck"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mshale unaoelekeza juu"),
            keywords: &[
                "kaskazini",
                "mshale",
                "mshale unaoelekeza juu",
                "sehemu kuu ya dira",
                "uelekeo",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("மேல\u{bcd}நோக\u{bcd}கிய அம\u{bcd}புக\u{bcd}குறி"),
            keywords: &[
                "அம\u{bcd}புக\u{bcd}குறி",
                "க\u{bbe}ர\u{bcd}டினல\u{bcd}",
                "திசை",
                "மேல\u{bcd}",
                "மேல\u{bcd}நோக\u{bcd}கிய அம\u{bcd}புக\u{bcd}குறி",
                "வடக\u{bcd}கு",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ఎగువ బ\u{c3e}ణం"),
            keywords: &[
                "ఉత\u{c4d}తరం",
                "ఎగువ బ\u{c3e}ణం",
                "క\u{c3e}ర\u{c4d}డ\u{c3f}నల\u{c4d}",
                "ద\u{c3f}శ",
                "బ\u{c3e}ణం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("тири \"боло\""),
            keywords: &["асосӣ", "самт", "тир", "тири \"боло\"", "шимол"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ล\u{e39}กศรช\u{e35}\u{e49}ข\u{e36}\u{e49}น"),
            keywords: &[
                "ท\u{e34}ศทาง",
                "ล\u{e39}กศร",
                "ล\u{e39}กศรช\u{e35}\u{e49}ข\u{e36}\u{e49}น",
                "เหน\u{e37}อ",
            ],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ምልክት ናብ ላዕሊ"),
            keywords: &["ምልክት", "ምልክት ናብ ላዕሊ", "ሰሜን", "ኣንፈት", "ካርዲናል"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ýokary ok"),
            keywords: &["demirgazyk", "göni", "ok", "ugur", "ýokary ok"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("ngahau ki ʻolunga"),
            keywords: &["hake", "ngahau", "ngahau ki ʻolunga", "ʻolunga"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("yukarı ok"),
            keywords: &[
                "ana yön",
                "kuzey",
                "ok",
                "yukarı ok",
                "yukarı yönlü ok",
                "yön",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئۈستى كۆرسەتكۈچ"),
            keywords: &["ئاساس", "ئۈستى كۆرسەتكۈچ", "شىمال", "كۆرسەتكۈچ", "يۆنىلىش"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("стрілка вгору"),
            keywords: &[
                "на північ",
                "напрям",
                "сторона світу",
                "стрілка",
                "стрілка вгору",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("اوپر کا تیر"),
            keywords: &["اوپر کا تیر", "تیر", "سمت", "شمال", "کارڈینل"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("yuqoriga strelka"),
            keywords: &["shimol", "strelka", "yo‘nalish", "yuqoriga strelka"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("mũi tên lên"),
            keywords: &["bắc", "chính", "hướng", "mũi tên", "mũi tên lên"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("fettu kaw"),
            keywords: &["fett", "fettu kaw", "gànnaar", "jubluwaay", "kàrdinal"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("utolo oluphezulu"),
            keywords: &[
                "emntla",
                "ukhardinale",
                "ulwalathiso",
                "utolo",
                "utolo oluphezulu",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("àmì òkè ìtó\u{329}sọ\u{301}nà o\u{329}lọ\u{301}fà"),
            keywords: &[
                "kádínàlì",
                "àmì ìtó\u{329}sọ\u{301}nà o\u{329}lọ\u{301}fà",
                "àmì òkè ìtó\u{329}sọ\u{301}nà o\u{329}lọ\u{301}fà",
                "àríwá",
                "ìtọ\u{301}sọ\u{301}nà",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("向上箭咀"),
            keywords: &["北", "向上箭咀", "基點", "方向", "箭咀"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("向上箭咀"),
            keywords: &["北", "向上箭咀", "基点", "方向", "箭咀"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("向上箭头"),
            keywords: &["北", "向上箭头", "方向", "标识"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("向上箭頭"),
            keywords: &["向上箭頭", "方向"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("上箭嘴"),
            keywords: &["上箭嘴", "上箭嘴按鈕", "方向"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("inkomba phezulu"),
            keywords: &["enyakatho", "inkomba", "inkomba phezulu", "umcibisholo"],
        },
    ],
};
#[doc = "↗\u{fe0f}"]
pub const UP_RIGHT_ARROW: crate::Emoji = crate::Emoji {
    glyph: "↗\u{fe0f}",
    codepoint: "2197 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "up-right arrow",
    group: "Symbols",
    subgroup: "arrow",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "↗",
        codepoint: "2197",
        status: crate::Status::Unqualified,
        introduction_version: 0.6f32,
        name: "up-right arrow",
        group: "Symbols",
        subgroup: "arrow",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("pyl na regs bo"),
            keywords: &["noordoos", "pyl", "pyl na regs bo", "rigting"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ወደ ላይ ቀኝ ጠቋሚ ቀስት"),
            keywords: &["ሰሜን ምሥራቅ", "ቀስት", "አቅጣጫ", "ኢንተርካርዲናል", "ወደ ላይ ቀኝ ጠቋሚ ቀስት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("سهم لأعلى اليمين"),
            keywords: &["اتجاه", "سهم", "سهم لأعلى اليمين", "شمال شرق"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some(
                "সো\u{981}দিশে ঢ\u{9be}ল খোৱ\u{9be} ঊৰ\u{9cd}ধ\u{9cd}বম\u{9c1}খী ক\u{9be}\u{981}ড\u{9bc}",
            ),
            keywords: &[
                "আন\u{9cd}তঃদিশ",
                "উত\u{9cd}তৰ-প\u{9c2}ব",
                "ক\u{9be}\u{981}ড\u{9bc}",
                "দিশ",
                "সো\u{981}দিশে ঢ\u{9be}ল খোৱ\u{9be} ঊৰ\u{9cd}ধ\u{9cd}বম\u{9c1}খী ক\u{9be}\u{981}ড\u{9bc}",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("üzüyuxarı sağa yönəlmiş ox"),
            keywords: &[
                "interkardinal",
                "istiqamət",
                "ox",
                "üzüyuxarı sağa yönəlmiş ox",
                "şimal şərq",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("стрэлка ўверх-управа"),
            keywords: &[
                "кірунак",
                "паўночны ўсход",
                "стрэлка",
                "стрэлка ўверх-управа",
                "уверх-управа",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("стрелка нагоре и надясно"),
            keywords: &[
                "посока",
                "североизток",
                "стрелка",
                "стрелка нагоре и надясно",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("উপরে ড\u{9be}নে তীর"),
            keywords: &[
                "আন\u{9cd}তঃ দিগনির\u{9cd}ণয\u{9bc}",
                "উত\u{9cd}তর-প\u{9c2}র\u{9cd}ব",
                "উপরে ড\u{9be}নে তীর",
                "তীর",
                "দিক",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("strelica gore-desno"),
            keywords: &["sjeveroistok", "smjer", "strelica", "strelica gore-desno"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("fletxa cap amunt a la dreta"),
            keywords: &[
                "amunt a la dreta",
                "direcció",
                "fletxa",
                "fletxa cap amunt a la dreta",
                "nord-est",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎦᎸᎳᏗ-ᎠᎦᏘᏏ ᎦᏝᏗ"),
            keywords: &[
                "ᎤᏴᏝᎧᎸᎬᎢ",
                "ᎦᎸᎳᏗ-ᎠᎦᏘᏏ ᎦᏝᏗ",
                "ᎦᏝᏗ",
                "ᏂᏚᏳᎪᏛᎢ",
                "ᏅᎩᏂᏚᏳᎪᏛᎢ ᏂᏚᏓᎸᏗᏎᎯᎯ",
            ],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("šipka doprava nahoru"),
            keywords: &[
                "severovýchod",
                "směr",
                "strany",
                "světové",
                "vedlejší",
                "šipka",
                "šipka doprava nahoru",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("saeth i fyny-dde"),
            keywords: &["Gogledd-ddwyrain", "cyfeiriad", "saeth", "saeth i fyny-dde"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("opadvendt pil mod højre"),
            keywords: &["nordøst", "opadvendt pil mod højre", "pil", "retning"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Pfeil nach rechts oben"),
            keywords: &[
                "Nordosten",
                "Pfeil",
                "Pfeil nach rechts oben",
                "nach rechts oben",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("πάνω δεξιό βέλος"),
            keywords: &[
                "βέλος",
                "βορειοανατολικά",
                "ενδιάμεση",
                "κατεύθυνση",
                "πάνω δεξιό βέλος",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("up-right arrow"),
            keywords: &[
                "arrow",
                "direction",
                "intercardinal",
                "northeast",
                "up-right arrow",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("flecha hacia la esquina superior derecha"),
            keywords: &[
                "arriba",
                "derecha",
                "dirección",
                "flecha",
                "flecha hacia la esquina superior derecha",
                "noreste",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &[
                "derecha",
                "dirección",
                "flecha",
                "flecha hacia el noreste",
                "flecha hacia la esquina superior derecha",
                "noreste",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("nool üles paremale"),
            keywords: &["kirre", "nool", "nool üles paremale", "suund"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("gora eta eskuinera gezia"),
            keywords: &[
                "gezi",
                "gora eta eskuinera gezia",
                "ipar-ekialde",
                "kardinal arteko",
                "norabide",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("پیکان بالا راست"),
            keywords: &["جهت فرعی", "شمال شرقی", "مسیر", "پیکان", "پیکان بالا راست"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("nuoli yläoikealle"),
            keywords: &[
                "ilmansuunta",
                "koillinen",
                "nuoli",
                "nuoli yläoikealle",
                "väli-ilmansuunta",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("pataas na pakanan na arrow"),
            keywords: &[
                "arrow",
                "direksyon",
                "hilagang-silangan",
                "intercardinal",
                "pakanan",
                "pataas",
                "pataas na pakanan na arrow",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("pílur sum peikar uppeftir og til høgru"),
            keywords: &[
                "k´ós",
                "landnyrðingur",
                "pílur",
                "pílur sum peikar uppeftir og til høgru",
                "ætt",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("flèche haut droite"),
            keywords: &["direction", "flèche", "flèche haut droite", "nord-est"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("flèche pointant vers le haut à droite"),
            keywords: &[
                "direction",
                "en haut à droite",
                "flèche",
                "flèche pointant vers le haut à droite",
                "nord-est",
                "point intercardinal",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("saighead suas ar dheis"),
            keywords: &[
                "idirmheánach",
                "saighead",
                "saighead suas ar dheis",
                "soir ó thuaidh",
                "treo",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("saighead gun ear-thuath"),
            keywords: &[
                "combaist",
                "comhair",
                "ear-thuath",
                "saighead",
                "saighead gun ear-thuath",
                "àirde",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("frecha cara arriba á dereita"),
            keywords: &[
                "arriba",
                "dirección",
                "frecha",
                "frecha cara arriba á dereita",
                "nordeste",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ઉપર-જમણ\u{ac1}\u{a82} તીર"),
            keywords: &[
                "ઉત\u{acd}તરપ\u{ac2}ર\u{acd}વ",
                "ઉપર-જમણ\u{ac1}\u{a82} તીર",
                "તીર",
                "દિશા",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("kibiyar sama ta dama"),
            keywords: &[
                "a ƙetaren tsini shiyya",
                "arewa maso gabas",
                "kibiya",
                "kibiyar sama ta dama",
                "shiyya",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("חץ למעלה וימינה"),
            keywords: &["חץ", "חץ למעלה וימינה", "כיוון", "צפון-מזרח"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ऊपर-दाया\u{901} तीर"),
            keywords: &[
                "इ\u{902}टरकार\u{94d}डिनल",
                "उत\u{94d}तर-प\u{942}र\u{94d}व दिशा",
                "ऊपर-दाया\u{901} तीर",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("strelica prema gore-desno"),
            keywords: &[
                "sjeveroistok",
                "smjer",
                "strelica",
                "strelica prema gore-desno",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("jobbra felfelé mutató nyíl"),
            keywords: &[
                "felfelé",
                "irány",
                "jobbra felfelé mutató nyíl",
                "nyíl",
                "északkelet",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("վերև աջ սլաք"),
            keywords: &["հյուսիս-արևելք", "ուղղություն", "սլաք", "վերև աջ սլաք"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("tanda panah kanan atas"),
            keywords: &[
                "arah",
                "interkardinal",
                "panah",
                "tanda panah kanan atas",
                "timur laut",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ube akanri dị elu"),
            keywords: &[
                "intakadịnal",
                "nduzị",
                "ube",
                "ube akanri dị elu",
                "ugwuọwụwa anyanwụ",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("ör ská upp til hægri"),
            keywords: &["norðaustur", "átt", "ör", "ör ská upp til hægri"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("freccia rivolta verso destra che punta in alto"),
            keywords: &[
                "direzione",
                "freccia",
                "freccia in alto a destra",
                "freccia rivolta verso destra che punta in alto",
                "nord-est",
                "punto intercardinale",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("右上矢印"),
            keywords: &["北東", "右上", "右上矢印", "矢印"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("panah munggah-nengen"),
            keywords: &[
                "arah",
                "interkardinal",
                "lor-wetan",
                "panah",
                "panah munggah-nengen",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ისარი ზემოთ და მარჯვნივ"),
            keywords: &[
                "ინტერკარდინალური",
                "ისარი",
                "ისარი ზემოთ და მარჯვნივ",
                "კარდინალური",
                "მიმართულება",
                "ჩრდილო-აღმოსავლეთი",
            ],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("aneccab d asawen uẓẓil"),
            keywords: &["aneccab d asawen uẓẓil"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("жоғарғы оң жақ көрсеткісі"),
            keywords: &[
                "бағыт",
                "жоғарғы оң жақ көрсеткісі",
                "көрсеткі",
                "румба аралық",
                "солтүстік-шығыс",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("opadvendt pil mod højre"),
            keywords: &["nordøst", "opadvendt pil mod højre", "pil", "retning"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some(
                "ព\u{17d2}រ\u{17bd}ញទៅលើងាកទៅស\u{17d2}តា\u{17c6}ក\u{17d2}ន\u{17bb}ងរាងប\u{17bd}នជ\u{17d2}រ\u{17bb}ង",
            ),
            keywords: &[
                "ទ\u{17b7}ស",
                "ទ\u{17b7}សដៅ",
                "ព\u{17d2}រ\u{17bd}ញ",
                "ព\u{17d2}រ\u{17bd}ញទៅលើងាកទៅស\u{17d2}តា\u{17c6}ក\u{17d2}ន\u{17bb}ងរាងប\u{17bd}នជ\u{17d2}រ\u{17bb}ង",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಮೇಲ\u{cbf}ನ ಬಾಲ ಬಾಣ"),
            keywords: &[
                "ಈಶಾನ\u{ccd}ಯ",
                "ದ\u{cbf}ಕ\u{ccd}ಕು",
                "ನ\u{cbf}ರ\u{ccd}ದೇಶನ",
                "ಬಾಣದ ಗುರುತು",
                "ಮೇಲ\u{cbf}ನ ಬಾಲ ಬಾಣ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("우상향 화살표"),
            keywords: &["북동쪽", "우상향 화살표", "화살표"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("वयर-उजवो बाण"),
            keywords: &["ईशान\u{94d}य", "उपदिशा", "दिशा", "बाण", "वयर-उजवो बाण"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("өйдө оң жакты караган жебе"),
            keywords: &[
                "багыт",
                "жебе",
                "түндүк-чыгыш",
                "өйдө оң жакты караган жебе",
            ],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Feil no uewen a riets"),
            keywords: &[
                "Feil",
                "Feil no uewen a riets",
                "Himmelsrichtung",
                "Nordosten",
                "Richtung",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ລ\u{eb9}ກສອນຂ\u{eb6}\u{ec9}ນມ\u{eb8}ມຂວາ"),
            keywords: &[
                "ຂ\u{eb6}\u{ec9}ນ",
                "ທ\u{eb4}ດທາງ",
                "ມ\u{eb8}ມຂວາ",
                "ລ\u{eb9}ກສອນ",
                "ລ\u{eb9}ກສອນຂ\u{eb6}\u{ec9}ນມ\u{eb8}ມຂວາ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("rodyklė į viršų ir į dešinę"),
            keywords: &[
                "kryptis",
                "rodyklė",
                "rodyklė į viršų ir į dešinę",
                "šiaurės rytai",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("uz augšējo labo stūri vērsta bultiņa"),
            keywords: &[
                "bultiņa",
                "norāde",
                "uz augšējo labo stūri vērsta bultiņa",
                "ziemeļaustrumi",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pere ake-matau"),
            keywords: &[
                "ahunga",
                "pere",
                "pere ake-matau",
                "rāwhiti-mā-raki",
                "waenga-matua",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("стрелка нагоре десно"),
            keywords: &["горе", "североисток", "стрелка", "стрелка нагоре десно"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("മ\u{d41}കളിൽ വലത\u{d4d}തേക\u{d4d}ക\u{d41}ള\u{d4d}ള അമ\u{d4d}പടയ\u{d3e}ളം"),
            keywords: &[
                "അമ\u{d4d}പടയ\u{d3e}ളം",
                "ഇന\u{d4d}റർക\u{d3e}ർഡിനൽ",
                "ദിശ",
                "നോർത\u{d4d}ത\u{d4d} ഈസ\u{d4d}\u{200c}റ\u{d4d}റ\u{d4d}",
                "മ\u{d41}കളിൽ വലത\u{d4d}തേക\u{d4d}ക\u{d41}ള\u{d4d}ള അമ\u{d4d}പടയ\u{d3e}ളം",
                "വടക\u{d4d}ക\u{d4d} കിഴക\u{d4d}കൻ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("баруун дээшээ сум"),
            keywords: &["баруун дээшээ сум", "зүүн хойд", "сум", "чиглэл"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("वर उजवीकड\u{947} दर\u{94d}शविणारा बाण"),
            keywords: &[
                "अ\u{902}तर\u{94d}गत महत\u{94d}वाच\u{947}",
                "उत\u{94d}तरप\u{942}र\u{94d}व",
                "दिशा",
                "बाण",
                "वर उजवीकड\u{947} दर\u{94d}शविणारा बाण",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("anak panah penjuru atas kanan"),
            keywords: &[
                "anak panah",
                "anak panah penjuru atas kanan",
                "antara kardinal",
                "arah",
                "timur laut",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("vleġġa ’l fuq leminija"),
            keywords: &[
                "direzzjoni",
                "grigal",
                "interkardinal",
                "vleġġa",
                "vleġġa ’l fuq leminija",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ညာဘက\u{103a}အပေါ\u{103a}ည\u{103d}\u{103e}န\u{103a} မြား"),
            keywords: &[
                "ညာဘက\u{103a} အပေါ\u{103a}ည\u{103d}\u{103e}န\u{103a}မြား",
                "ညာဘက\u{103a}အပေါ\u{103a}ည\u{103d}\u{103e}န\u{103a} မြား",
                "ဌာနတ\u{103d}င\u{103a}း အရေးအကြ\u{102e}းဆ\u{102f}\u{1036}း",
                "မြား",
                "လမ\u{103a}းည\u{103d}\u{103e}န\u{103a}",
                "အရ\u{103e}ေ\u{1037}မြောက\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("pil opp-høyre"),
            keywords: &["nordøst", "pil", "pil opp-høyre", "retning"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("माथि-दाया\u{901} फर\u{94d}क\u{947}को तीर"),
            keywords: &[
                "उत\u{94d}तरदक\u{94d}षीण",
                "कार\u{94d}डिनल विपरित",
                "तीर",
                "दिशा",
                "माथि-दाया\u{901} फर\u{94d}क\u{947}को तीर",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("pijl rechtsomhoog"),
            keywords: &[
                "noordoost",
                "pijl",
                "pijl rechtsomhoog",
                "richting",
                "windrichting",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("pil opp-høgre"),
            keywords: &["nordaust", "pil", "pil opp-høgre", "retning"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଉପର-ଡ\u{b3e}ହ\u{b3e}ଣ ତୀର"),
            keywords: &[
                "ଅନ\u{b4d}ତଃପ\u{b4d}ରଧ\u{b3e}ନ",
                "ଉତ\u{b4d}ତରପ\u{b42}ର\u{b4d}ବ",
                "ଉପର-ଡ\u{b3e}ହ\u{b3e}ଣ ତୀର",
                "ତୀର",
                "ଦ\u{b3f}ଗ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਉ\u{a71}ਪਰ-ਸ\u{a71}ਜ\u{a47} ਤੀਰ"),
            keywords: &[
                "ਇ\u{a70}ਟਰਕਾਰਡੀਨਲ",
                "ਉ\u{a71}ਤਰ-ਪ\u{a42}ਰਬ",
                "ਉ\u{a71}ਪਰ-ਸ\u{a71}ਜ\u{a47} ਤੀਰ",
                "ਤੀਰ",
                "ਦਿਸ\u{a3c}ਾ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ا\u{64f}وتلا-سجا تیر"),
            keywords: &[
                "انٹر کارڈینل",
                "ا\u{64f}وتلا-سجا تیر",
                "تیر",
                "سمت",
                "شمال مشرق",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Áro De Pọínt Ọ\u{301}p-Rait"),
            keywords: &[
                "Dairẹ\u{301}kshọn",
                "Intakádínal",
                "Nọ\u{301}tist",
                "Áro",
                "Áro De Pọínt Ọ\u{301}p-Rait",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("strzałka w górę w prawo"),
            keywords: &[
                "kierunek",
                "północny wschód",
                "strzałka",
                "strzałka do góry w prawo",
                "strzałka w górę w prawo",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("پورته ښي غشی"),
            keywords: &["انتر کارډينل", "اړخ", "شمال ختيځ", "غشی", "پورته ښي غشی"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("seta para cima e para a direita"),
            keywords: &[
                "direção",
                "intercardinal",
                "nordeste",
                "seta",
                "seta para cima e para a direita",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("seta para cima e para a direita"),
            keywords: &[
                "direção",
                "intermédio",
                "nordeste",
                "seta",
                "seta para cima e para a direita",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("hanaq paña wach’i"),
            keywords: &["hanaq paña wach’i"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("săgeată orientată în dreapta-sus"),
            keywords: &[
                "direcție",
                "intercardinal",
                "nord-est",
                "săgeată",
                "săgeată orientată în dreapta-sus",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-009"),
            keywords: &["E10-009"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("стрелка вправо-вверх"),
            keywords: &["вправо-вверх", "направление", "северо-восток", "стрелка"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umwambi w’ahagana ejuru iburyo"),
            keywords: &[
                "amajyaruguru ashyira iburasirazuba",
                "icyerekezo",
                "kiri hagati y’ibyerekezo bine",
                "umwambi",
                "umwambi w’ahagana ejuru iburyo",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("مٿي ساڄي تير"),
            keywords: &["اتراوڀر", "انٽرڪارڊينل", "تير", "طرف", "مٿي ساڄي تير"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("උඩ\u{dd4}-දක\u{dd4}ණ\u{dd4} ඊතලය"),
            keywords: &[
                "ඉන\u{dca}ටර\u{dca}ක\u{dcf}ඩ\u{dd2}නල\u{dca}",
                "ඊතලය",
                "ඊස\u{dcf}න",
                "උඩ\u{dd4}-දක\u{dd4}ණ\u{dd4} ඊතලය",
                "ද\u{dd2}ශ\u{dcf}ව",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("šípka doprava nahor"),
            keywords: &[
                "doprava nahor",
                "severovýchod",
                "šípka",
                "šípka doprava nahor",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("puščica desno gor"),
            keywords: &[
                "puščica",
                "puščica desno gor",
                "severovzhod",
                "smer",
                "stransko",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("fallaarta kor ee midig"),
            keywords: &[
                "fallaar",
                "fallaarta kor ee midig",
                "isdhaafsiga jihooyinka",
                "jihada",
                "waqooyi bari",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("shigjeta lart-djathtas"),
            keywords: &[
                "drejtim",
                "i ndërmjetëm",
                "shigjeta lart-djathtas",
                "shigjetë",
                "verilindje",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("стрелица нагоре и надесно"),
            keywords: &[
                "сeвeрoистoк",
                "смер",
                "стрeлицa",
                "стрелица нагоре и надесно",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["стрелица нагоре и надесно"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("strelica nagore i nadesno"),
            keywords: &[
                "severoistok",
                "smer",
                "strelica",
                "strelica nagore i nadesno",
            ],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["strelica nagore i nadesno"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("uppåtpil höger"),
            keywords: &["höger", "pil", "uppåt", "uppåtpil höger"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mshale unaoelekeza juu kulia"),
            keywords: &[
                "kaskazini mashariki",
                "kati ya sehemu kuu ya dira",
                "mshale",
                "mshale unaoelekeza juu kulia",
                "uelekeo",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("மேல\u{bcd}-வலது நோக\u{bcd}கிய அம\u{bcd}புக\u{bcd}குறி"),
            keywords: &[
                "திசை",
                "மேல\u{bcd}-வலது நோக\u{bcd}கிய அம\u{bcd}புக\u{bcd}குறி",
                "வட கிழக\u{bcd}கு",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ఎగువ కుడ\u{c3f} మూల బ\u{c3e}ణం"),
            keywords: &[
                "ఈశ\u{c3e}న\u{c4d}యం",
                "ఎగువ కుడ\u{c3f} మూల బ\u{c3e}ణం",
                "ద\u{c3f}శ",
                "బ\u{c3e}ణం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("тири болову рост"),
            keywords: &["мобайнӣ", "самт", "тир", "тири болову рост", "шимолу шарқ"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ล\u{e39}กศรช\u{e35}\u{e49}ม\u{e38}มขวาบน"),
            keywords: &[
                "ตะว\u{e31}นออกเฉ\u{e35}ยงเหน\u{e37}อ",
                "ท\u{e34}ศทาง",
                "ล\u{e39}กศรช\u{e35}\u{e49}ม\u{e38}มขวาบน",
                "ล\u{e39}\u{e39}กศร",
            ],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ምልክት ናብ-የማናይ ላዕሊ"),
            keywords: &[
                "ምልክት",
                "ምልክት ናብ-የማናይ ላዕሊ",
                "ሰሜናዊ ምብራቅ",
                "ኣንፈት",
                "ውሽጣዊ ናይ ካርዲናል",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ýokary-saga ok"),
            keywords: &[
                "demirgazyk-gündogar",
                "gytak",
                "ok",
                "ugur",
                "ýokary-saga ok",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("ngahau ki ʻolunga toʻomataʻu"),
            keywords: &[
                "mataʻu",
                "ngahau",
                "ngahau ki ʻolunga toʻomataʻu",
                "ʻolunga",
            ],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("sağ yukarı ok"),
            keywords: &["ara yön", "kuzey doğu", "ok", "sağ yukarı ok", "yön"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئۈستى-ئوڭ كۆرسەتكۈچ"),
            keywords: &[
                "ئارا يۆنىلىشلىك",
                "ئۈستى-ئوڭ كۆرسەتكۈچ",
                "شەرقىي-شىمال",
                "كۆرسەتكۈچ",
                "يۆنىلىش",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("стрілка вгору вправо"),
            keywords: &[
                "на північний схід",
                "напрям",
                "стрілка",
                "стрілка вгору вправо",
                "четвертинний румб",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("اوپر دائیں تیر"),
            keywords: &["اوپر دائیں تیر", "تیر", "سائن", "سمت", "شمال مشرق"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("o‘ng-yuqoriga strelka"),
            keywords: &[
                "chiziq",
                "o‘ng-yuqoriga strelka",
                "shimoli-sharq",
                "yo‘nalish",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("mũi tên lên bên phải"),
            keywords: &[
                "hướng",
                "mũi tên",
                "mũi tên lên bên phải",
                "nhiều hướng",
                "đông bắc",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("fettu ndijooru kaw"),
            keywords: &[
                "fett",
                "fettu ndijooru kaw",
                "interkàrdinal",
                "jubluwaay",
                "penku-gànnaar",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("utolo olujonge phezulu"),
            keywords: &[
                "empuma-mzantsi",
                "ukhardinale",
                "ulwalathiso",
                "utolo",
                "utolo olujonge phezulu",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("àmì òkè ìtó\u{329}sọ\u{301}nà o\u{329}lọ\u{301}fà apá ọ\u{300}tún"),
            keywords: &[
                "ilà oòrùn àríwá",
                "àmì ìtó\u{329}sọ\u{301}nà o\u{329}lọ\u{301}fà",
                "àmì òkè ìtó\u{329}sọ\u{301}nà o\u{329}lọ\u{301}fà apá ọ\u{300}tún",
                "ìlọ\u{301}pọ\u{300} kádínàlì",
                "ìtọ\u{301}sọ\u{301}nà",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("向右上箭咀"),
            keywords: &["向右上箭咀", "基點間", "方向", "東北", "箭咀"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("向右上箭咀"),
            keywords: &["东北", "向右上箭咀", "基点间", "方向", "箭咀"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("右上箭头"),
            keywords: &["东北", "右上箭头", "方向", "标识"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("右上箭頭"),
            keywords: &["右上箭頭", "方向"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("上右箭嘴"),
            keywords: &["上右箭嘴", "方向"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("Inkomba phezulu-kwesokudla"),
            keywords: &[
                "Inkomba phezulu-kwesokudla",
                "enyakathompumalanga",
                "inkomba",
                "inkombakuhlanganisa",
                "umcibisholo",
            ],
        },
    ],
};
#[doc = "➡\u{fe0f}"]
pub const RIGHT_ARROW: crate::Emoji = crate::Emoji {
    glyph: "➡\u{fe0f}",
    codepoint: "27A1 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "right arrow",
    group: "Symbols",
    subgroup: "arrow",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "➡",
        codepoint: "27A1",
        status: crate::Status::Unqualified,
        introduction_version: 0.6f32,
        name: "right arrow",
        group: "Symbols",
        subgroup: "arrow",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("pyl na regs"),
            keywords: &["oos", "pyl", "pyl na regs", "regs", "rigting"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ወደ ቀኝ ጠቋሚ ቀስት"),
            keywords: &["ምሥራቅ", "ቀስት", "አቅጣጫ", "ካርዲናል", "ወደ ቀኝ ጠቋሚ ቀስት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("سهم لليمين"),
            keywords: &["اتجاه", "سهم", "سهم لليمين", "شرق", "كاردينال"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("সো\u{981}ম\u{9c1}খী ক\u{9be}\u{981}ড\u{9bc}"),
            keywords: &[
                "ক\u{9be}\u{981}ড\u{9bc}",
                "দিশ",
                "প\u{9c2}ব",
                "ম\u{9c1}খ\u{9cd}য দিশবিল\u{9be}ক",
                "সো\u{981}ম\u{9c1}খী ক\u{9be}\u{981}ড\u{9bc}",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("sağa ox"),
            keywords: &["istiqamət", "ox", "sağa ox", "şərq", "əsas"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("стрэлка ўправа"),
            keywords: &["кірунак", "стрэлка", "стрэлка ўправа", "управа", "усход"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("стрелка надясно"),
            keywords: &[
                "Стрелка надясно",
                "изток",
                "посока",
                "стрелка",
                "стрелка надясно",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ড\u{9be}নদিকের তীর"),
            keywords: &[
                "ড\u{9be}ন",
                "ড\u{9be}নদিকের তীর",
                "তীর",
                "দিকনির\u{9cd}দেশ",
                "পরিম\u{9be}ণব\u{9be}চক",
                "প\u{9c2}র\u{9cd}ব",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("strelica nadesno"),
            keywords: &["istok", "smjer", "strelica", "strelica nadesno"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("fletxa cap a la dreta"),
            keywords: &[
                "direcció",
                "dreta",
                "est",
                "fletxa",
                "fletxa cap a la dreta",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᎦᏘᏏ ᎦᏝᏗ"),
            keywords: &["ᎠᎦᏘᏏ ᎦᏝᏗ", "ᎦᏝᏗ", "ᎧᎸᎬᎢ", "ᏂᏚᏳᎪᏛᎢ", "ᏧᎵᏍᎨᏓ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("šipka doprava"),
            keywords: &[
                "hlavní",
                "směr",
                "strany",
                "světové",
                "východ",
                "šipka",
                "šipka doprava",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("saeth i’r dde"),
            keywords: &["Dwyrain", "cyfeiriad", "saeth", "saeth i’r dde"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("pil mod højre"),
            keywords: &["pil", "pil mod højre", "retning", "verdenshjørne", "øst"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Pfeil nach rechts"),
            keywords: &[
                "Osten",
                "Pfeil",
                "Pfeil nach rechts",
                "Rechtspfeil",
                "nach rechts",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("δεξιό βέλος"),
            keywords: &["ανατολικά", "απόλυτη", "βέλος", "δεξιό βέλος", "κατεύθυνση"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("right arrow"),
            keywords: &["arrow", "cardinal", "direction", "east", "right arrow"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("flecha hacia la derecha"),
            keywords: &[
                "derecha",
                "dirección",
                "este",
                "flecha",
                "flecha hacia la derecha",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &[
                "derecha",
                "dirección",
                "este",
                "flecha",
                "flecha hacia el este",
                "flecha hacia la derecha",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("nool paremale"),
            keywords: &["ida", "nool", "nool paremale", "suund"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("eskuinera gezia"),
            keywords: &["ekialde", "eskuinera gezia", "gezi", "kardinal", "norabide"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("پیکان راست"),
            keywords: &["جهت اصلی", "شرق", "مسیر", "پیکان", "پیکان راست"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("nuoli oikealle"),
            keywords: &[
                "ilmansuunta",
                "itä",
                "nuoli",
                "nuoli oikealle",
                "pääilmansuunta",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("pakanang arrow"),
            keywords: &[
                "arrow",
                "cardinal",
                "direksyon",
                "pakanan",
                "pakanang arrow",
                "silangan",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("pílur sum peikar til høgru"),
            keywords: &[
                "eystur",
                "k´ós",
                "pílur",
                "pílur sum peikar til høgru",
                "ætt",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("flèche droite"),
            keywords: &["direction", "est", "flèche", "flèche droite"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("flèche pointant vers la droite"),
            keywords: &[
                "direction",
                "est",
                "flèche",
                "flèche pointant vers la droite",
                "point cardinal",
                "à droite",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("saighead ar dheis"),
            keywords: &["príomhaird", "saighead", "saighead ar dheis", "soir"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("saighead gun ear"),
            keywords: &["saighead gun ear", "saighead gun ear-dheas"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("frecha cara á dereita"),
            keywords: &["dereita", "dirección", "frecha cara á dereita", "leste"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("જમણ\u{ac1}\u{a82} તીર"),
            keywords: &["જમણ\u{ac1}\u{a82} તીર", "તીર", "દિશા", "પ\u{ac2}ર\u{acd}વ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("kibiyar dama"),
            keywords: &["gabas", "kibiya", "kibiyar dama", "shiyya", "tsinin shiyya"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("חץ ימינה"),
            keywords: &["חץ", "ימינה", "כיוון", "מזרח"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("दाया\u{901} तीर"),
            keywords: &[
                "कार\u{94d}डिनल",
                "तीर",
                "दाया\u{901} तीर",
                "दिशा",
                "प\u{942}र\u{94d}व दिशा",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("strelica prema desno"),
            keywords: &["istok", "smjer", "strelica", "strelica prema desno"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("jobbra mutató nyíl"),
            keywords: &["irány", "jobbra", "jobbra mutató nyíl", "kelet", "nyíl"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("աջ սլաք"),
            keywords: &["աջ սլաք", "արևելք", "գլխավոր", "ուղղություն", "սլաք"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("tanda panah kanan"),
            keywords: &["arah", "kardinal", "panah", "tanda panah kanan", "timur"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ube akanri"),
            keywords: &["kadịnal", "nduzị", "ube", "ube akanri", "ọwụwa anyanwụ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("ör til hægri"),
            keywords: &["austur", "höfuðátt", "átt", "ör", "ör til hægri"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("freccia rivolta verso destra"),
            keywords: &[
                "direzione",
                "est",
                "freccia",
                "freccia a destra",
                "freccia rivolta verso destra",
                "punto cardinale",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("右矢印"),
            keywords: &["右", "右矢印", "東", "矢印"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("panah nengen"),
            keywords: &["arah", "kardinal", "panah", "panah nengen", "wetan"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ისარი მარჯვნივ"),
            keywords: &[
                "აღმოსავლეთი",
                "ისარი",
                "ისარი მარჯვნივ",
                "კარდინალური",
                "მიმართულება",
            ],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("aneccab ayeffus"),
            keywords: &["aneccab ayeffus"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("оң жақ бағытты көрсеткі"),
            keywords: &[
                "бағыт",
                "көрсеткі",
                "негізгі",
                "оң жақ бағытты көрсеткі",
                "шығыс",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("pil mod højre"),
            keywords: &["pil", "pil mod højre", "retning", "verdenshjørne", "øst"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ព\u{17d2}រ\u{17bd}ញទៅស\u{17d2}តា\u{17c6}"),
            keywords: &[
                "កើត",
                "ទ\u{17b7}ស",
                "ព\u{17d2}រ\u{17bd}ញ",
                "ព\u{17d2}រ\u{17bd}ញទៅស\u{17d2}តា\u{17c6}",
                "ស\u{17d2}តា\u{17c6}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಬಲಭಾಗದ ಬಾಣ"),
            keywords: &[
                "ಕಾರ\u{ccd}ಡ\u{cbf}ನಲ\u{ccd}\u{200c}",
                "ದ\u{cbf}ಕ\u{ccd}ಕು",
                "ಪ\u{cc2}ರ\u{ccd}ವ",
                "ಬಲಭಾಗದ ಬಾಣ",
                "ಬಾಣ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("우향 화살표"),
            keywords: &["동쪽", "우향 화살표", "화살표"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("उजवो बाण"),
            keywords: &[
                "उजवो बाण",
                "उद\u{947}\u{902}त",
                "दिशा",
                "बाण",
                "म\u{941}ख\u{947}ल दिशा",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("оң жакты караган жебе"),
            keywords: &["багыт", "жебе", "оң жакты караган жебе", "чыгыш"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Feil no riets"),
            keywords: &[
                "Feil",
                "Feil no riets",
                "Himmelsrichtung",
                "Osten",
                "Richtung",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ລ\u{eb9}ກສອນຂວາ"),
            keywords: &["ຂວາ", "ທ\u{eb4}ດທາງ", "ລ\u{eb9}ກສອນ", "ລ\u{eb9}ກສອນຂວາ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("rodyklė į dešinę"),
            keywords: &[
                "koordinatė",
                "kryptis",
                "rodyklė",
                "rodyklė į dešinę",
                "rytai",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("labā bultiņa"),
            keywords: &[
                "austrumi",
                "bultiņa",
                "labā bultiņa",
                "norāde",
                "pa labi vērsta bultiņa",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pere matau"),
            keywords: &["ahunga", "matua", "pere", "pere matau", "rāwhiti"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("стрелка надесно"),
            keywords: &["десно", "исток", "стрелка", "стрелка надесно"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some(
                "വലത\u{d4d}തേക\u{d4d}ക\u{d4d} ച\u{d42}ണ\u{d4d}ട\u{d41}ന\u{d4d}ന അമ\u{d4d}പടയ\u{d3e}ളം",
            ),
            keywords: &[
                "അമ\u{d4d}പടയ\u{d3e}ളം",
                "ക\u{d3e}ർഡിനൽ",
                "കിഴക\u{d4d}ക\u{d4d}",
                "ദിശ",
                "വലത\u{d4d}തേക\u{d4d}ക\u{d4d} ച\u{d42}ണ\u{d4d}ട\u{d41}ന\u{d4d}ന അമ\u{d4d}പടയ\u{d3e}ളം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("баруун сум"),
            keywords: &["баруун сум", "зүүн", "кардинал", "сум", "чиглэл"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("उजवा बाण"),
            keywords: &[
                "उजवा बाण",
                "दिशा",
                "प\u{942}र\u{94d}व",
                "बाण",
                "महत\u{94d}वाच\u{947}",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("anak panah ke kanan"),
            keywords: &[
                "anak panah",
                "anak panah ke kanan",
                "arah",
                "kardinal",
                "timur",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("vleġġa leminija"),
            keywords: &[
                "direzzjoni",
                "il-lvant",
                "kardinal",
                "vleġġa",
                "vleġġa leminija",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ညာည\u{103d}\u{103e}န\u{103a}မြား"),
            keywords: &[
                "ညာည\u{103d}\u{103e}န\u{103a}မြား",
                "မြား",
                "လမ\u{103a}းည\u{103d}\u{103e}န\u{103a}",
                "အရပ\u{103a}မျက\u{103a}န\u{103e}ာပြ အမ\u{103e}တ\u{103a}အသား",
                "အရ\u{103e}ေ\u{1037}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("pil høyre"),
            keywords: &["høyrepil", "pil", "pil høyre", "retning", "øst"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("दाया\u{901} तर\u{94d}फको तीर"),
            keywords: &[
                "कार\u{94d}डिनल",
                "तीर",
                "दाया\u{901} तर\u{94d}फको तीर",
                "दिशा",
                "प\u{942}र\u{94d}व",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("pijl naar rechts"),
            keywords: &[
                "oost",
                "pijl",
                "pijl naar rechts",
                "richting",
                "windrichting",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("pil høgre"),
            keywords: &["aust", "høgrepil", "pil", "pil høgre", "retning"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଡ\u{b3e}ହ\u{b3e}ଣ ତୀର"),
            keywords: &[
                "ଡ\u{b3e}ହ\u{b3e}ଣ ତୀର",
                "ତୀର",
                "ଦ\u{b3f}ଗ",
                "ପ\u{b42}ର\u{b4d}ବ",
                "ପ\u{b4d}ରଧ\u{b3e}ନ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਸ\u{a71}ਜ\u{a47} ਤੀਰ"),
            keywords: &[
                "ਕਾਰਡੀਨਲ",
                "ਤੀਰ",
                "ਦਿਸ\u{a3c}ਾ",
                "ਪ\u{a42}ਰਬ",
                "ਸ\u{a71}ਜ\u{a47} ਤੀਰ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("سجا تیر"),
            keywords: &["اہم", "تیر", "سجا تیر", "سمت", "مشرق"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Áro De Pọínt Rait"),
            keywords: &[
                "Dairẹ\u{301}kshọn",
                "Ist",
                "Kádínal",
                "Áro",
                "Áro De Pọínt Rait",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("strzałka w prawo"),
            keywords: &["kierunek", "strzałka", "strzałka w prawo", "wschód"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ښي غشی"),
            keywords: &["اساسي", "اړخ", "ختيځ", "غشی", "ښي غشی"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("seta para a direita"),
            keywords: &["direita", "direção", "leste", "seta", "seta para a direita"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["cardeal", "direção", "este", "seta", "seta para a direita"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("paña wach’i"),
            keywords: &["paña wach’i"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("săgeată orientată în dreapta"),
            keywords: &[
                "cardinal",
                "direcție",
                "est",
                "săgeată",
                "săgeată orientată în dreapta",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-151"),
            keywords: &["E10-151"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("стрелка вправо"),
            keywords: &["восток", "вправо", "направление", "стрелка"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("akambi k’iburyo"),
            keywords: &[
                "akambi k’iburyo",
                "iburasirazuba",
                "icyerekezo",
                "kimwe mu byerekezo bine",
                "umwambi",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ساڄي تير"),
            keywords: &["اوڀر", "تير", "ساڄي تير", "طرف", "ڪارڊينل"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("දක\u{dd4}ණ\u{dd4} ඊතලය"),
            keywords: &[
                "ඊතලය",
                "ක\u{dcf}\u{dcf}ඩ\u{dd2}නල\u{dca}",
                "දක\u{dd4}ණ\u{dd4} ඊතලය",
                "ද\u{dd2}ශ\u{dcf}ව",
                "නැගෙනහ\u{dd2}ර",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("šípka doprava"),
            keywords: &["doprava", "východ", "šípka"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("puščica desno"),
            keywords: &["glavno", "puščica", "puščica desno", "smer", "vzhod"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("fallarta midig"),
            keywords: &[
                "afarta jiho",
                "bari",
                "fallaar",
                "fallaarta midig",
                "fallarta midig",
                "jiho",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("shigjetë djathtas"),
            keywords: &[
                "drejtim",
                "kryesore",
                "lindje",
                "shigjetë",
                "shigjetë djathtas",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("стрелица надесно"),
            keywords: &["истoк", "смер", "стрeлицa", "стрелица надесно"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["стрелица надесно"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("strelica nadesno"),
            keywords: &["istok", "smer", "strelica", "strelica nadesno"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["strelica nadesno"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("högerpil"),
            keywords: &["högerpil", "pil", "riktning", "väderstreck", "öster"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mshale unaoelekeza kulia"),
            keywords: &[
                "mashariki",
                "mshale",
                "mshale unaoelekeza kulia",
                "sehemu kuu ya dira",
                "uelekeo",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("வலது நோக\u{bcd}கிய அம\u{bcd}புக\u{bcd}குறி"),
            keywords: &[
                "அம\u{bcd}புக\u{bcd}குறி",
                "க\u{bbe}ர\u{bcd}டினல\u{bcd}",
                "கிழக\u{bcd}கு",
                "திசை",
                "வலது",
                "வலது நோக\u{bcd}கிய அம\u{bcd}புக\u{bcd}குறி",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("కుడ\u{c3f} బ\u{c3e}ణం"),
            keywords: &[
                "క\u{c3e}ర\u{c4d}డ\u{c3f}నల\u{c4d}",
                "కుడ\u{c3f} బ\u{c3e}ణం",
                "తూర\u{c4d}పు",
                "ద\u{c3f}శ",
                "బ\u{c3e}ణం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("тири рост"),
            keywords: &["асосӣ", "самт", "тир", "тири рост", "шарқ"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ล\u{e39}กศรช\u{e35}\u{e49}ไปทางขวา"),
            keywords: &[
                "ตะว\u{e31}นออก",
                "ท\u{e34}ศทาง",
                "ล\u{e39}กศร",
                "ล\u{e39}กศรช\u{e35}\u{e49}ไปทางขวา",
            ],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("የማናይ ምልክት"),
            keywords: &["ምልክት", "ምብራቅ", "ኣንፈት", "ካርዲናል", "የማናይ ምልክት"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("saga ok"),
            keywords: &["göni", "gündogar", "ok", "saga ok", "ugur"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("ngahau ki toʻomataʻu"),
            keywords: &["mataʻu", "ngahau", "ngahau ki toʻomataʻu"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("sağ ok"),
            keywords: &["ana yön", "doğu", "ok", "sağ ok", "yön"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئوڭ كۆرسەتكۈچ"),
            keywords: &["ئاساس", "ئوڭ كۆرسەتكۈچ", "شەرق", "كۆرسەتكۈچ", "يۆنىلىش"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("стрілка вправо"),
            keywords: &[
                "напрям",
                "сторона",
                "стрілка",
                "стрілка вправо",
                "стрілка праворуч",
                "східний",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("دائیں تیر"),
            keywords: &["تیر", "دائیں تیر", "سمت", "مشرق", "کارڈینل"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("oʻngga strelka"),
            keywords: &[
                "oʻngga strelka",
                "o‘ngga strelka",
                "sharq",
                "strelka",
                "yo‘nalish",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("mũi tên phải"),
            keywords: &["chính", "hướng", "mũi tên", "mũi tên phải", "đông"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("fettu ndijoor"),
            keywords: &["fett", "fettu ndijoor", "jubluwaay", "kàrdinal", "penku"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("utolo olusekunene"),
            keywords: &[
                "empuma",
                "ukhardinale",
                "ulwalathiso",
                "utolo",
                "utolo olusekunene",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("àmì ìtó\u{329}sọ\u{301}nà o\u{329}lọ\u{301}fà apá ọ\u{300}tún"),
            keywords: &[
                "ilà oòrùn",
                "kádínàlì",
                "àmì ìtó\u{329}sọ\u{301}nà o\u{329}lọ\u{301}fà",
                "àmì ìtó\u{329}sọ\u{301}nà o\u{329}lọ\u{301}fà apá ọ\u{300}tún",
                "ìtọ\u{301}sọ\u{301}nà",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("向右箭咀"),
            keywords: &["向右箭咀", "基點", "方向", "東", "箭咀"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("向右箭咀"),
            keywords: &["东", "向右箭咀", "基点", "方向", "箭咀"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("向右箭头"),
            keywords: &["东", "向右箭头", "方向", "标识"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("向右箭頭"),
            keywords: &["向右箭頭", "方向"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("右箭嘴"),
            keywords: &["右箭嘴", "向右箭頭", "方向"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("Inkomba kwesokudla"),
            keywords: &[
                "Inkomba kwesokudla",
                "empumalanga",
                "inkomba",
                "umcibisholo",
            ],
        },
    ],
};
#[doc = "↘\u{fe0f}"]
pub const DOWN_RIGHT_ARROW: crate::Emoji = crate::Emoji {
    glyph: "↘\u{fe0f}",
    codepoint: "2198 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "down-right arrow",
    group: "Symbols",
    subgroup: "arrow",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "↘",
        codepoint: "2198",
        status: crate::Status::Unqualified,
        introduction_version: 0.6f32,
        name: "down-right arrow",
        group: "Symbols",
        subgroup: "arrow",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("pyl na regs onder"),
            keywords: &["pyl", "pyl na regs onder", "rigting", "suidoos"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ወደ ታች ቀኝ ጠቋሚ ቀስት"),
            keywords: &["ቀስት", "አቅጣጫ", "ኢንተርካርዲናል", "ወደ ታች ቀኝ ጠቋሚ ቀስት", "ደቡብ ምሥራቅ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("سهم لأسفل اليمين"),
            keywords: &["اتجاه", "جنوب شرق", "سهم", "سهم لأسفل اليمين"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("অধোগ\u{9be}মী সো\u{981}ম\u{9c1}খী ক\u{9be}\u{981}ড\u{9bc}"),
            keywords: &[
                "অধোগ\u{9be}মী সো\u{981}ম\u{9c1}খী ক\u{9be}\u{981}ড\u{9bc}",
                "আন\u{9cd}তঃদিশ",
                "ক\u{9be}\u{981}ড\u{9bc}",
                "দক\u{9cd}ষিণ-প\u{9c2}ব",
                "দিশ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("üzüaşağı sağa yönəlmiş ox"),
            keywords: &[
                "cənub şərq",
                "interkardinal",
                "istiqamət",
                "ox",
                "üzüaşağı sağa yönəlmiş ox",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("стрэлка ўніз-управа"),
            keywords: &[
                "кірунак",
                "паўднёвы ўсход",
                "стрэлка",
                "стрэлка ўніз-управа",
                "уніз-управа",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("стрелка надолу и надясно"),
            keywords: &["посока", "стрелка", "стрелка надолу и надясно", "югоизток"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("নীচে ড\u{9be}নে তীর"),
            keywords: &[
                "আন\u{9cd}তঃ দিগনির\u{9cd}ণয\u{9bc}",
                "তীর",
                "দক\u{9cd}ষিণ-প\u{9c2}র\u{9cd}ব",
                "দিক",
                "নীচে ড\u{9be}নে তীর",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("strelica dolje-desno"),
            keywords: &["jugoistok", "smjer", "strelica", "strelica dolje-desno"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("fletxa cap avall a la dreta"),
            keywords: &[
                "avall a la dreta",
                "direcció",
                "fletxa",
                "fletxa cap avall a la dreta",
                "sud-est",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎡᎳᏗ-ᎠᎦᏘᏏ ᎦᏝᏗ"),
            keywords: &[
                "ᎡᎳᏗ-ᎠᎦᏘᏏ ᎦᏝᏗ",
                "ᎤᎦᏅᏮᎧᎸᎬᎢ",
                "ᎦᏝᏗ",
                "ᏂᏚᏳᎪᏛᎢ",
                "ᏅᎩᏂᏚᏳᎪᏛᎢ ᏂᏚᏓᎸᏗᏎᎯᎯ",
            ],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("šipka doprava dolů"),
            keywords: &[
                "jihovýchod",
                "směr",
                "strany",
                "světové",
                "vedlejší",
                "šipka",
                "šipka doprava dolů",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("saeth i lawr-dde"),
            keywords: &["De-ddwyrain", "cyfeiriad", "saeth", "saeth i lawr-dde"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("nedadvendt pil mod højre"),
            keywords: &["nedadvendt pil mod højre", "pil", "retning", "sydøst"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Pfeil nach rechts unten"),
            keywords: &[
                "Pfeil",
                "Pfeil nach rechts unten",
                "Südosten",
                "nach rechts unten",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κάτω δεξιό βέλος"),
            keywords: &[
                "βέλος",
                "ενδιάμεση",
                "κάτω δεξιό βέλος",
                "κατεύθυνση",
                "νοτιοανατολικά",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("down-right arrow"),
            keywords: &[
                "arrow",
                "direction",
                "down-right arrow",
                "intercardinal",
                "southeast",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("flecha hacia la esquina inferior derecha"),
            keywords: &[
                "abajo",
                "derecha",
                "dirección",
                "flecha",
                "flecha hacia la esquina inferior derecha",
                "sudeste",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("flecha hacia el sureste"),
            keywords: &["flecha hacia el sureste"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("nool alla paremale"),
            keywords: &["kagu", "nool", "nool alla paremale", "suund"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("behera eta eskuinera gezia"),
            keywords: &[
                "behera eta eskuinera gezia",
                "gezi",
                "hego-ekialde",
                "kardinal arteko",
                "norabide",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("پیکان پایین راست"),
            keywords: &["جنوب شرقی", "جهت فرعی", "مسیر", "پیکان", "پیکان پایین راست"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("nuoli alaoikealle"),
            keywords: &[
                "ilmansuunta",
                "kaakko",
                "nuoli",
                "nuoli alaoikealle",
                "väli-ilmansuunta",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("pababang pakanan na arrow"),
            keywords: &[
                "arrow",
                "direksyon",
                "intercardinal",
                "pababang pakanan",
                "pababang pakanan na arrow",
                "timog-silangan",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("pílur sum peikar niðureftir og til høgru"),
            keywords: &[
                "k´ós",
                "landsynningur",
                "pílur",
                "pílur sum peikar niðureftir og til høgru",
                "ætt",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("flèche bas droite"),
            keywords: &["direction", "flèche", "flèche bas droite", "sud-est"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("flèche pointant vers le bas à droite"),
            keywords: &[
                "direction",
                "en bas à droite",
                "flèche pointant vers le bas à droite",
                "lèche",
                "point intercardinal",
                "sud-est",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("saighead síos ar dheis"),
            keywords: &[
                "idirmheánach",
                "saighead",
                "saighead síos ar dheis",
                "soir ó dheas",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("saighead gun ear-dheas"),
            keywords: &[
                "combaist",
                "comhair",
                "ear-dheas",
                "saighead",
                "saighead gun ear-dheas",
                "àirde",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("frecha cara abaixo á dereita"),
            keywords: &[
                "abaixo",
                "dirección",
                "frecha",
                "frecha cara abaixo á dereita",
                "sueste",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("નીચ\u{ac7}-જમણ\u{ac1}\u{a82} તીર"),
            keywords: &[
                "તીર",
                "દક\u{acd}ષિણપ\u{ac2}ર\u{acd}વ",
                "દિશા",
                "નીચ\u{ac7}-જમણ\u{ac1}\u{a82} તીર",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("kibiyar ƙasa ta dama"),
            keywords: &[
                "a ƙetaren tsini shiyya",
                "kibiya",
                "kibiyar ƙasa ta dama",
                "kudu maso gabas",
                "shiyya",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("חץ למטה וימינה"),
            keywords: &[
                "דרום-מזרח",
                "חץ",
                "חץ למטה וימינה",
                "חץ מטה וימינה",
                "ימינה",
                "כיוון",
                "למטה",
            ],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("नीच\u{947}-दाया\u{901} तीर"),
            keywords: &[
                "इ\u{902}टरकार\u{94d}डिनल",
                "दक\u{94d}षिण-प\u{942}र\u{94d}व दिशा",
                "नीच\u{947}-दाया\u{901} तीर",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("strelica prema dolje-desno"),
            keywords: &[
                "jugoistok",
                "smjer",
                "strelica",
                "strelica prema dolje-desno",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("jobbra lefelé mutató nyíl"),
            keywords: &["délkelet", "irány", "jobbra lefelé mutató nyíl", "nyíl"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ներքև աջ սլաք"),
            keywords: &["հարավ-արևելք", "ներքև աջ սլաք", "ուղղություն", "սլաք"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("tanda panah kanan bawah"),
            keywords: &[
                "arah",
                "interkardinal",
                "panah",
                "tanda panah kanan bawah",
                "tenggara",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ube-ala akanri"),
            keywords: &[
                "intakadịnal",
                "nduzi",
                "ndịdaọwụwa anyanwụ",
                "ube",
                "ube-ala akanri",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("ör ská niður til hægri"),
            keywords: &["suðaustur", "átt", "ör", "ör ská niður til hægri"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("freccia in basso a destra"),
            keywords: &[
                "direzione",
                "freccia",
                "freccia in basso a destra",
                "punto intercardinale",
                "sud-est",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("右下矢印"),
            keywords: &["南東", "右下", "右下矢印", "矢印"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("panah mudhun-nengen"),
            keywords: &[
                "arah",
                "interkardinal",
                "panah",
                "panah mudhun-nengen",
                "wetan-kidul",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ისარი ქვემოთ და მარჯვნივ"),
            keywords: &[
                "ინტერკარდინალური",
                "ისარი",
                "ისარი ქვემოთ და მარჯვნივ",
                "კარდინალური",
                "მიმართულება",
                "სამხრეთ-აღმოსავლეთი",
            ],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("aneccab d akesser uẓẓil"),
            keywords: &["aneccab d akesser uẓẓil"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("төменгі оң жақ көрсеткісі"),
            keywords: &[
                "бағыт",
                "көрсеткі",
                "оңтүстік-шығыс",
                "румба аралық",
                "төменгі оң жақ көрсеткісі",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("nedadvendt pil mod højre"),
            keywords: &["nedadvendt pil mod højre", "pil", "retning", "sydøst"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some(
                "ព\u{17d2}រ\u{17bd}ញទៅក\u{17d2}រោមងាកទៅស\u{17d2}តា\u{17c6}ក\u{17d2}ន\u{17bb}ងរាងប\u{17bd}នជ\u{17d2}រ\u{17bb}ង",
            ),
            keywords: &[
                "ទ\u{17b7}ស",
                "ទ\u{17b7}សដៅ",
                "ព\u{17d2}រ\u{17bd}ញ",
                "ព\u{17d2}រ\u{17bd}ញទៅក\u{17d2}រោមងាកទៅស\u{17d2}តា\u{17c6}ក\u{17d2}ន\u{17bb}ងរាងប\u{17bd}នជ\u{17d2}រ\u{17bb}ង",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕ\u{cc6}ಳಗ\u{cbf}ನ ಬಲ ಬಾಣ"),
            keywords: &[
                "ಆಗ\u{ccd}ನೇಯ",
                "ಕ\u{cc6}ಳಗ\u{cbf}ನ ಬಲ ಬಾಣ",
                "ದಕ\u{ccd}ಷ\u{cbf}ಣ",
                "ಬಾಣದ ಗುರುತು",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("우하향 화살표"),
            keywords: &["남동쪽", "우하향 화살표", "화살표"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("सकयल-उजवो बाण"),
            keywords: &[
                "आग\u{94d}न\u{947}य",
                "उपदिशा",
                "दिशा",
                "बाण",
                "सकयल-उजवो बाण",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("төмөн оң жакты караган жебе"),
            keywords: &[
                "багыт",
                "жебе",
                "түштүк-чыгыш",
                "төмөн оң жакты караган жебе",
            ],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Feil no ënnen a riets"),
            keywords: &[
                "Feil",
                "Feil no ënnen a riets",
                "Himmelsrichtung",
                "Richtung",
                "Südosten",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ລ\u{eb9}ກສອນລ\u{ebb}ງມ\u{eb8}ມຂວາ"),
            keywords: &[
                "ທ\u{eb4}ດທາງ",
                "ມ\u{eb8}ມຂວາ",
                "ລ\u{eb9}ກສອນ",
                "ລ\u{eb9}ກສອນລ\u{ebb}ງມ\u{eb8}ມຂວາ",
                "ລ\u{ebb}ງ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("rodyklė į apačią ir į dešinę"),
            keywords: &[
                "kryptis",
                "pietryčiai",
                "rodyklė",
                "rodyklė į apačią ir į dešinę",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("uz apakšējo labo stūri vērsta bultiņa"),
            keywords: &[
                "bultiņa",
                "dienvidaustrumi",
                "norāde",
                "uz apakšējo labo stūri vērsta bultiņa",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pere iho-matau"),
            keywords: &[
                "ahunga",
                "pere",
                "pere iho-matau",
                "rāwhiti-mā-tonga",
                "waenga-matua",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("стрелка надолу десно"),
            keywords: &["десно", "стрелка", "стрелка надолу десно", "југоисток"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some(
                "ത\u{d3e}ഴോട\u{d4d}ട\u{d4d} വലത\u{d4d}തേക\u{d4d}ക\u{d41}ള\u{d4d}ള അമ\u{d4d}പടയ\u{d3e}ളം",
            ),
            keywords: &[
                "അമ\u{d4d}പടയ\u{d3e}ളം",
                "ഇന\u{d4d}റർക\u{d3e}ർഡിനൽ",
                "ത\u{d3e}ഴോട\u{d4d}ട\u{d4d} വലത\u{d4d}തേക\u{d4d}ക\u{d41}ള\u{d4d}ള അമ\u{d4d}പടയ\u{d3e}ളം",
                "തെക\u{d4d}ക\u{d4d} കിഴക\u{d4d}ക\u{d4d}",
                "ദിശ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("баруун доошоо сум"),
            keywords: &["баруун доошоо сум", "зүүн өмнөд", "сум", "чиглэл"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("खाली-उजवीकड\u{947} दर\u{94d}शविणारा बाण"),
            keywords: &[
                "अ\u{902}तर\u{94d}गत महत\u{94d}वाच\u{947}",
                "खाली-उजवीकड\u{947} दर\u{94d}शविणारा बाण",
                "दक\u{94d}षिणप\u{942}र\u{94d}व",
                "दिशा",
                "बाण",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("anak panah penjuru bawah kanan"),
            keywords: &[
                "anak panah",
                "anak panah penjuru bawah kanan",
                "antara kardinal",
                "arah",
                "tenggara",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("vleġġa ’l isfel leminija"),
            keywords: &[
                "direzzjoni",
                "interkardinal",
                "vleġġa",
                "vleġġa ’l isfel leminija",
                "xlokk",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ညာဘက\u{103a}အောက\u{103a}ည\u{103d}\u{103e}န\u{103a} မြား"),
            keywords: &[
                "ညာဘက\u{103a}အောက\u{103a}ည\u{103d}\u{103e}န\u{103a} မြား",
                "မြား",
                "လမ\u{103a}းည\u{103d}\u{103e}န\u{103a}",
                "အရပ\u{103a}မျက\u{103a}န\u{103e}ာ န\u{103e}စ\u{103a}ခ\u{102f}ကြားပြ အမ\u{103e}တ\u{103a}အသား",
                "အရ\u{103e}ေ\u{1037}တောင\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("pil ned-høyre"),
            keywords: &["pil", "pil ned-høyre", "retning", "sørøst"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("तल दाया\u{901}तर\u{94d}फको तीर"),
            keywords: &[
                "इन\u{94d}टरकार\u{94d}डिनल",
                "तल दाया\u{901}तर\u{94d}फको तीर",
                "तीर",
                "दक\u{94d}षिण प\u{942}र\u{94d}व",
                "दिशा",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("pijl rechtsomlaag"),
            keywords: &[
                "pijl",
                "pijl rechtsomlaag",
                "richting",
                "windrichting",
                "zuidoost",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("pil ned -høgre"),
            keywords: &[
                "pil",
                "pil ned -høgre",
                "pil ned-høgre",
                "retning",
                "søraust",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ତଳ-ଡ\u{b3e}ହ\u{b3e}ଣ ତୀର"),
            keywords: &[
                "ଅନ\u{b4d}ତଃପ\u{b4d}ରଧ\u{b3e}ନ",
                "ତଳ-ଡ\u{b3e}ହ\u{b3e}ଣ ତୀର",
                "ତୀର",
                "ଦକ\u{b4d}ଷ\u{b3f}ଣପ\u{b42}ର\u{b4d}ବ",
                "ଦ\u{b3f}ଗ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਥ\u{a71}ਲ\u{a47}-ਸ\u{a71}ਜ\u{a47} ਤੀਰ"),
            keywords: &[
                "ਇ\u{a70}ਟਰਕਾਰਡੀਨਲ",
                "ਤੀਰ",
                "ਥ\u{a71}ਲ\u{a47}-ਸ\u{a71}ਜ\u{a47} ਤੀਰ",
                "ਦਿਸ\u{a3c}ਾ",
                "ਦ\u{a71}ਖਣ-ਪ\u{a42}ਰਬ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ہیٹھلا-سجا تیر"),
            keywords: &["انٹر کارڈینل", "تیر", "جنوب مشرق", "سمت", "ہیٹھلا-سجا تیر"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Áro De Pọínt Daún-Rait"),
            keywords: &[
                "Dairẹ\u{301}kshọn",
                "Intakádínal",
                "Saútist",
                "Áro",
                "Áro De Pọínt Daún-Rait",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("strzałka w dół w prawo"),
            keywords: &[
                "kierunek",
                "południowy wschód",
                "strzałka",
                "strzałka w dół w prawo",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ښکته ښي غشی"),
            keywords: &[
                "انټر کارډينل",
                "اړخ",
                "سويلي ختيځ",
                "غشی",
                "ښکته ښي غشی",
                "ښۍ ښکته غشی",
            ],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("seta para baixo e para a direita"),
            keywords: &[
                "direção",
                "intercardinal",
                "seta",
                "seta para baixo e para a direita",
                "sudeste",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("seta para a direita e para baixo"),
            keywords: &[
                "direção",
                "intermédio",
                "seta",
                "seta para a direita e para baixo",
                "sudeste",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("uran paña wach’i"),
            keywords: &["uran paña wach’i"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("săgeată orientată în dreapta-jos"),
            keywords: &[
                "direcție",
                "intercardinal",
                "sud-est",
                "săgeată",
                "săgeată orientată în dreapta-jos",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-010"),
            keywords: &["E10-010"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("стрелка вправо-вниз"),
            keywords: &["вправо-вниз", "направление", "стрелка", "юго-восток"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umwambi wo hasi ugana iburyo"),
            keywords: &[
                "amajyepfo ashyira iburasirazuba",
                "icyerekezo",
                "kiri hagati y’ibyerekeezo bine",
                "umwambi",
                "umwambi wo hasi ugana iburyo",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("هيٺ ساڄي طرف تير"),
            keywords: &["انٽرڪارڊينل", "تير", "طرف", "هيٺ ساڄي طرف تير", "ڏکڻ اوڀر"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("යට\u{dd2}-දක\u{dd4}ණ\u{dd4} ඊතලය"),
            keywords: &[
                "ඉන\u{dca}ටර\u{dca}ක\u{dcf}ඩ\u{dd2}නල\u{dca}",
                "ඊතලය",
                "ග\u{dd2}න\u{dd2}කොණ",
                "ද\u{dd2}\u{dd2}ශ\u{dcf}ව",
                "යට\u{dd2}-දක\u{dd4}ණ\u{dd4} ඊතලය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("šípka doprava nadol"),
            keywords: &[
                "doprava nadol",
                "juhovýchod",
                "šípka",
                "šípka doprava nadol",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("puščica desno dol"),
            keywords: &[
                "jugovzhod",
                "puščica",
                "puščica desno dol",
                "smer",
                "stransko",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("fallaarta hoose ee midig"),
            keywords: &[
                "fallaar",
                "fallaarta hoose ee midig",
                "isdhaafsiga jihooyinka",
                "jihada",
                "koonfur bari",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("shigjetë poshtë djathtas"),
            keywords: &[
                "drejtim",
                "i ndërmjetëm",
                "juglindje",
                "shigjetë",
                "shigjetë poshtë djathtas",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("стрелица надоле и надесно"),
            keywords: &["jугoистoк", "смер", "стрeлицa", "стрелица надоле и надесно"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("стрелица надоље и надесно"),
            keywords: &["стрелица надоље и надесно"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("strelica nadole i nadesno"),
            keywords: &["jugoistok", "smer", "strelica", "strelica nadole i nadesno"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("strelica nadolje i nadesno"),
            keywords: &["strelica nadolje i nadesno"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("nedåtpil höger"),
            keywords: &["höger", "nedåt", "nedåtpil höger", "pil"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mshale unaoelekeza chini kulia"),
            keywords: &[
                "kaskazini kusini mashariki",
                "kati ya sehemu kuu ya dira",
                "mshale",
                "mshale unaoelekeza chini kulia",
                "uelekeo",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("க\u{bc0}ழ\u{bcd}-வலது நோக\u{bcd}கிய அம\u{bcd}புக\u{bcd}குறி"),
            keywords: &[
                "க\u{bc0}ழ\u{bcd}-வலது நோக\u{bcd}கிய அம\u{bcd}புக\u{bcd}குறி",
                "திசை",
                "தென\u{bcd}கிழக\u{bcd}கு",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ద\u{c3f}గువ కుడ\u{c3f} మూల బ\u{c3e}ణం"),
            keywords: &[
                "ఆగ\u{c4d}న\u{c47}యం",
                "ద\u{c3f}గువ కుడ\u{c3f} మూల బ\u{c3e}ణం",
                "ద\u{c3f}శ",
                "బ\u{c3e}ణం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("тири поёну рост"),
            keywords: &["мобайнӣ", "самт", "тир", "тири поёну рост", "ҷанубу шарқ"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ล\u{e39}กศรช\u{e35}\u{e49}ม\u{e38}มขวาล\u{e48}าง"),
            keywords: &[
                "ตะว\u{e31}นออกเฉ\u{e35}ยงใต\u{e49}",
                "ท\u{e34}ศทาง",
                "ล\u{e39}กศร",
                "ล\u{e39}กศรช\u{e35}\u{e49}ม\u{e38}มขวาล\u{e48}าง",
            ],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ምልክት ናብ-የማናይ ታሕቲ"),
            keywords: &[
                "ምልክት",
                "ምልክት ናብ-የማናይ ታሕቲ",
                "ኣንፈት",
                "ውሽጣዊ ናይ ካርዲናል",
                "ደቡባዊ ምብራቅ",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("aşak-saga ok"),
            keywords: &["aşak-saga ok", "gytak", "günorta-gündogar", "ok", "ugur"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("ngahau ki lalo toʻomataʻu"),
            keywords: &["lalo", "mataʻu", "ngahau", "ngahau ki lalo toʻomataʻu"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("sağ aşağı ok"),
            keywords: &["ara yön", "güney doğu", "ok", "sağ aşağı ok", "yön"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئاستى ئوڭ كۆرسەتكۈچ"),
            keywords: &[
                "ئارا يۆنىلىشلىك",
                "ئاستى ئوڭ كۆرسەتكۈچ",
                "شەرقىي-جەنۇب",
                "كۆرسەتكۈچ",
                "يۆنىلىش",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("стрілка вниз управо"),
            keywords: &[
                "напрям",
                "проміжний",
                "південно-східний",
                "стрілка",
                "стрілка вниз управо",
                "стрілка вниз і праворуч",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("نیچے دائیں تیر"),
            keywords: &["تیر", "جنوب مشرق", "سائن", "سمت", "نیچے دائیں تیر"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("o‘ng-pastga strelka"),
            keywords: &["chiziq", "janubi-sharq", "o‘ng-pastga strelka", "yo‘nalish"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("mũi tên xuống bên phải"),
            keywords: &[
                "hướng",
                "mũi tên",
                "mũi tên xuống bên phải",
                "nhiều hướng",
                "đông nam",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("suuf-ndijoor fett"),
            keywords: &[
                "direction",
                "fett",
                "interkàrdinal",
                "penku-gànjool",
                "suuf-ndijoor fett",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("utolo olujonge ezantsi"),
            keywords: &[
                "empuma mzantsi",
                "ukhardinale ohlangeneyo",
                "ulwalathiso",
                "utolo",
                "utolo olujonge ezantsi",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("àmì ilẹ\u{300} ìtó\u{329}sọ\u{301}nà o\u{329}lọ\u{301}fà apá ọ\u{300}tún"),
            keywords: &[
                "gúúsù ilà oòrùn",
                "àmì ilẹ\u{300} ìtó\u{329}sọ\u{301}nà o\u{329}lọ\u{301}fà apá ọ\u{300}tún",
                "àmì ìtó\u{329}sọ\u{301}nà o\u{329}lọ\u{301}fà",
                "ìlọ\u{301}pọ\u{300} kádínàlì",
                "ìtọ\u{301}sọ\u{301}nà",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("向右下箭咀"),
            keywords: &["向右下箭咀", "基點間", "方向", "東南", "箭咀"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("向右下箭咀"),
            keywords: &["东南", "向右下箭咀", "基点间", "方向", "箭咀"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("右下箭头"),
            keywords: &["东南", "右下箭头", "方向", "标识"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("右下箭頭"),
            keywords: &["右下箭頭", "方向"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("下右箭嘴"),
            keywords: &["下右箭嘴", "方向"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("inkombaphansi ngqo"),
            keywords: &[
                "eningizimunempumalanga",
                "inkomba",
                "inkombakuhlanganisa",
                "inkombaphansi ngqo",
                "umcibisholo",
            ],
        },
    ],
};
#[doc = "⬇\u{fe0f}"]
pub const DOWN_ARROW: crate::Emoji = crate::Emoji {
    glyph: "⬇\u{fe0f}",
    codepoint: "2B07 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "down arrow",
    group: "Symbols",
    subgroup: "arrow",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "⬇",
        codepoint: "2B07",
        status: crate::Status::Unqualified,
        introduction_version: 0.6f32,
        name: "down arrow",
        group: "Symbols",
        subgroup: "arrow",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("pyl na onder"),
            keywords: &["af", "pyl", "pyl na onder", "rigting", "suid"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ወደ ታች ጠቋሚ ቀስት"),
            keywords: &["ቀስት", "ታች", "አቅጣጫ", "ካርዲናል", "ወደ ታች ጠቋሚ ቀስት", "ደቡብ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("سهم لأسفل"),
            keywords: &["اتجاه", "جنوب", "سهم", "سهم لأسفل", "كاردينال"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("অধোম\u{9c1}খী ক\u{9be}\u{981}ড\u{9bc}"),
            keywords: &[
                "অধোম\u{9c1}খী ক\u{9be}\u{981}ড\u{9bc}",
                "ক\u{9be}\u{981}ড\u{9bc}",
                "তল",
                "দক\u{9cd}ষিণ",
                "দিশ",
                "ম\u{9c1}খ\u{9cd}য দিশ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("üzüaşağı ox"),
            keywords: &["aşağı", "cənub", "istiqamət", "ox", "üzüaşağı ox", "əsas"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("стрэлка ўніз"),
            keywords: &["кірунак", "поўдзень", "стрэлка", "стрэлка ўніз", "уніз"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Стрелка надолу"),
            keywords: &["Стрелка надолу", "надолу", "посока", "стрелка", "юг"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("নিচের দিকের তীর"),
            keywords: &[
                "তীর",
                "দক\u{9cd}ষিণ",
                "দিক",
                "নিচে",
                "নিচের দিকের তীর",
                "পরিম\u{9be}ণব\u{9be}চক",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("strelica nadolje"),
            keywords: &["jug", "smjer", "strelica", "strelica nadolje"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("fletxa cap avall"),
            keywords: &["avall", "direcció", "fletxa", "fletxa cap avall", "sud"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎡᎳᏗ ᎦᏝᏗ"),
            keywords: &["ᎡᎳᏗ", "ᎤᎦᏅᏮ", "ᎦᏝᏗ", "ᏂᏚᏳᎪᏛᎢ", "ᏧᎵᏍᎨᏓ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("šipka dolů"),
            keywords: &[
                "hlavní",
                "jih",
                "směr",
                "strany",
                "světové",
                "šipka",
                "šipka dolů",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("saeth i lawr"),
            keywords: &["De", "cyfeiriad", "saeth", "saeth i lawr"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("nedadvendt pil"),
            keywords: &[
                "ned",
                "nedadvendt pil",
                "pil",
                "retning",
                "syd",
                "verdenshjørne",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Pfeil nach unten"),
            keywords: &[
                "Abwärtspfeil",
                "Pfeil",
                "Pfeil nach unten",
                "Süden",
                "abwärts",
                "nach unten",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κάτω βέλος"),
            keywords: &["απόλυτη", "βέλος", "κάτω", "κατεύθυνση", "νότια"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("down arrow"),
            keywords: &["arrow", "cardinal", "direction", "down", "south"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("flecha hacia abajo"),
            keywords: &["abajo", "dirección", "flecha", "flecha hacia abajo", "sur"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &[
                "cardinal",
                "dirección",
                "flecha",
                "flecha hacia abajo",
                "flecha hacia el sur",
                "punto",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &[
                "abajo",
                "cardinal",
                "dirección",
                "flecha",
                "flecha hacia abajo",
                "sur",
            ],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("nool alla"),
            keywords: &["lõuna", "nool", "nool alla", "suund"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("behera gezia"),
            keywords: &["behera", "gezia", "hegoa", "kardinala", "norabidea"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("پیکان پایین"),
            keywords: &["جنوب", "جهت اصلی", "مسیر", "پایین", "پیکان"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("nuoli alas"),
            keywords: &[
                "etelä",
                "ilmansuunta",
                "nuoli",
                "nuoli alas",
                "pääilmansuunta",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("pababang arrow"),
            keywords: &[
                "arrow",
                "cardinal",
                "direksyon",
                "pababa",
                "pababang arrow",
                "timog",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("pílur sum peikar niðureftir"),
            keywords: &[
                "k´ós",
                "niður",
                "pílur",
                "pílur sum peikar niðureftir",
                "suður",
                "ætt",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("flèche bas"),
            keywords: &["direction", "flèche", "flèche bas", "sud"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("flèche pointant vers le bas"),
            keywords: &[
                "direction",
                "en bas",
                "flèche",
                "flèche pointant vers le bas",
                "point cardinal",
                "sud",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("saighead síos"),
            keywords: &["príomhaird", "saighead", "síos", "treo", "ó dheas"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("saighead gu deas"),
            keywords: &[
                "combaist",
                "comhair",
                "deas",
                "saighead",
                "saighead gu deas",
                "àirde",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("frecha cara abaixo"),
            keywords: &["abaixo", "dirección", "frecha cara abaixo", "sur"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("નીચ\u{ac7} તીર"),
            keywords: &["તીર", "દક\u{acd}ષિણ", "દિશા", "નીચ\u{ac7}"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("kibiyar ƙasa"),
            keywords: &[
                "kibiya",
                "kibiyar ƙasa",
                "kudu",
                "shiyya",
                "tsinin shiyya",
                "ƙasa",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("חץ למטה"),
            keywords: &["דרום", "חץ", "כיוון", "למטה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("नीच\u{947} तीर"),
            keywords: &[
                "कार\u{94d}डिनल",
                "दक\u{94d}षिण दिशा",
                "नीच\u{947}",
                "नीच\u{947} तीर",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("strelica prema dolje"),
            keywords: &["jug", "smjer", "strelica", "strelica prema dolje"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("lefelé mutató nyíl"),
            keywords: &["dél", "irány", "lefelé", "lefelé mutató nyíl", "nyíl"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ներքև սլաք"),
            keywords: &["գլխավոր", "հարավ", "ներքև", "ուղղություն", "սլաք"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("tanda panah bawah"),
            keywords: &[
                "arah",
                "bawah",
                "kardinal",
                "panah",
                "selatan",
                "tanda panah bawah",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ube ala"),
            keywords: &["ala", "kadịnal", "nduzi", "ndịda", "ube"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("ör niður"),
            keywords: &["höfuðátt", "niður", "suður", "átt", "ör"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("freccia rivolta verso il basso"),
            keywords: &[
                "direzione",
                "freccia",
                "freccia in basso",
                "freccia rivolta verso il basso",
                "punto cardinale",
                "sud",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("下矢印"),
            keywords: &["下", "下矢印", "南", "矢印"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("panah mudhun"),
            keywords: &["arah", "kardinal", "kidul", "panah", "panah mudhun"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ისარი ქვემოთ"),
            keywords: &["ისარი", "კარდინალური", "მიმართულება", "სამხრეთი", "ქვემოთ"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("aneccab akesser"),
            keywords: &["aneccab akesser"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("төмен қараған көрсеткі"),
            keywords: &[
                "бағыт",
                "көрсеткі",
                "негізгі",
                "оңтүстік",
                "төмен",
                "төмен бағытты көрсеткі",
                "төмен қараған көрсеткі",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("nedadvendt pil"),
            keywords: &[
                "ned",
                "nedadvendt pil",
                "pil",
                "retning",
                "syd",
                "verdenshjørne",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ព\u{17d2}រ\u{17bd}ញទៅក\u{17d2}រោម"),
            keywords: &[
                "ច\u{17bb}ះក\u{17d2}រោម",
                "ត\u{17d2}ប\u{17bc}ង",
                "ទ\u{17b7}ស",
                "ព\u{17d2}រ\u{17bd}ញ",
                "ព\u{17d2}រ\u{17bd}ញទៅក\u{17d2}រោម",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕ\u{cc6}ಳಮುಖ ಬಾಣ"),
            keywords: &[
                "ಕ\u{cc6}ಳಗ\u{cbf}ನ ಬಾಣ",
                "ಕ\u{cc6}ಳಗ\u{cc6}",
                "ಕ\u{cc6}ಳಮುಖ ಬಾಣ",
                "ದ\u{cbf}ಕ\u{ccd}ಕು",
                "ನ\u{cbf}ರ\u{ccd}ದೇಶನ",
                "ಬಾಣದ ಗುರುತು",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("하향 화살표"),
            keywords: &["남쪽", "하향 화살표", "화살표"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("सकयल बाण"),
            keywords: &[
                "दक\u{94d}षिण",
                "दिशा",
                "बाण",
                "म\u{941}ख\u{947}लदिशा",
                "सकयल",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("төмөн караган жебе"),
            keywords: &["багыт", "жебе", "түштүк", "төмөн", "төмөн караган жебе"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Feil no ënnen"),
            keywords: &[
                "Feil",
                "Feil no ënnen",
                "Himmelsrichtung",
                "Richtung",
                "Süden",
                "no ënnen",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ລ\u{eb9}ກສອນລ\u{ebb}ງ"),
            keywords: &[
                "ທ\u{eb4}ດທາງ",
                "ລ\u{eb9}ກສອນ",
                "ລ\u{eb9}ກສອນລ\u{ebb}ງ",
                "ລ\u{ebb}ງ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("rodyklė į apačią"),
            keywords: &[
                "koordinatė",
                "kryptis",
                "pietūs",
                "rodyklė",
                "rodyklė į apačią",
                "į apačią",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("lejupbultiņa"),
            keywords: &[
                "bultiņa",
                "dienvidi",
                "lejupbultiņa",
                "lejupvērsta bultiņa",
                "norāde",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pere iho"),
            keywords: &["ahunga", "iho", "matua", "pere", "tonga"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("стрелка надолу"),
            keywords: &["долу", "стрелка", "стрелка надолу", "југ"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some(
                "ത\u{d3e}ഴേക\u{d4d}ക\u{d4d} ച\u{d42}ണ\u{d4d}ട\u{d41}ന\u{d4d}ന അമ\u{d4d}പടയ\u{d3e}ളം",
            ),
            keywords: &[
                "അമ\u{d4d}പടയ\u{d3e}ളം",
                "ക\u{d3e}ർഡിനൽ",
                "ത\u{d3e}ഴേക\u{d4d}ക\u{d4d}",
                "ത\u{d3e}ഴേക\u{d4d}ക\u{d4d} ച\u{d42}ണ\u{d4d}ട\u{d41}ന\u{d4d}ന അമ\u{d4d}പടയ\u{d3e}ളം",
                "തെക\u{d4d}ക\u{d4d}",
                "ദിശ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("доошоо сум"),
            keywords: &["доошоо", "кардинал", "сум", "чиглэл", "өмнөд"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("खाली दर\u{94d}शविणारा बाण"),
            keywords: &[
                "खाली दर\u{94d}शविणारा बाण",
                "बाण । महत\u{94d}त\u{94d}वाच\u{947} । दिशा । खाली । दक\u{94d}षिण",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("anak panah ke bawah"),
            keywords: &[
                "anak panah",
                "anak panah ke bawah",
                "arah",
                "kardinal",
                "ke bawah",
                "selatan",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("vleġġa ’l isfel"),
            keywords: &[
                "direzzjoni",
                "kardinal",
                "nofsinhar",
                "vleġġa",
                "vleġġa ’l isfel",
                "’l isfel",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အောက\u{103a}ည\u{103d}\u{103e}န\u{103a}မြား"),
            keywords: &[
                "တောင\u{103a}ဘက\u{103a}",
                "မြား",
                "လမ\u{103a}းည\u{103d}\u{103e}န\u{103a}",
                "အရပ\u{103a}မျက\u{103a}န\u{103e}ာပြ အမ\u{103e}တ\u{103a}အသား",
                "အောက\u{103a}ည\u{103d}\u{103e}န\u{103a}မြား",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("pil ned"),
            keywords: &["nedoverpil", "pil", "pil ned", "retning", "sør"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("तलतर\u{94d}फको तीर"),
            keywords: &[
                "कार\u{94d}डिनल",
                "तल",
                "तलतर\u{94d}फको तीर",
                "तीर",
                "दक\u{94d}षिण",
                "दिशा",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("pijl omlaag"),
            keywords: &["omlaag", "pijl", "richting", "windrichting", "zuid"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("pil ned"),
            keywords: &["nedoverpil", "pil", "pil ned", "retning", "sør"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ନ\u{b3f}ମ\u{b4d}ନମ\u{b41}ଖୀ ତୀର"),
            keywords: &[
                "ତୀର",
                "ଦକ\u{b4d}ଷ\u{b3f}ଣ",
                "ଦ\u{b3f}ଗ",
                "ନ\u{b3f}ମ\u{b4d}ନ",
                "ନ\u{b3f}ମ\u{b4d}ନମ\u{b41}ଖୀ ତୀର",
                "ପ\u{b4d}ରମ\u{b41}ଖ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਥ\u{a71}ਲ\u{a47}\u{a47} ਤੀਰ"),
            keywords: &[
                "ਕਾਰਡੀਨਲ",
                "ਤੀਰ",
                "ਥ\u{a71}ਲ\u{a47}",
                "ਥ\u{a71}ਲ\u{a47}\u{a47} ਤੀਰ",
                "ਦਿਸ\u{a3c}ਾ",
                "ਦ\u{a71}ਖਣ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ہیٹھلا تیر"),
            keywords: &["اہم", "تیر", "جنوب", "سمت", "ہیٹھاں", "ہیٹھلا تیر"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Áro De Pọínt Daun"),
            keywords: &[
                "Dairẹ\u{301}kshọn",
                "Daun",
                "Kádínal",
                "Saut",
                "Áro",
                "Áro De Pọínt Daun",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("strzałka w dół"),
            keywords: &[
                "kierunek",
                "południe",
                "strzałka",
                "strzałka na dół",
                "strzałka w dół",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ښکته غشی"),
            keywords: &["اساسي", "اړخ", "سويل", "غشی", "ښکته"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("seta para baixo"),
            keywords: &[
                "cardinal",
                "direção",
                "para baixo",
                "seta",
                "seta para baixo",
                "sul",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &[
                "cardeal",
                "direção",
                "para baixo",
                "seta",
                "seta para baixo",
                "sul",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("uran wach’i"),
            keywords: &["uran wach’i"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("săgeată orientată în jos"),
            keywords: &[
                "cardinal",
                "direcție",
                "jos",
                "sud",
                "săgeată",
                "săgeată orientată în jos",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-158"),
            keywords: &["E10-158"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("стрелка вниз"),
            keywords: &["вниз", "направление", "стрелка", "юг"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("akambi kamanura"),
            keywords: &[
                "akambi kamanura",
                "amajyepfo",
                "hasi",
                "icyerekezo",
                "kimwe mu byerekezo bine",
                "umwambi",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("هيٺ تير"),
            keywords: &["تير", "طرف", "هيٺ", "ڏکڻ", "ڪارڊينل"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("යට\u{dd2} ඊතලය"),
            keywords: &[
                "ඊතලය",
                "ක\u{dcf}ඩ\u{dd2}නල\u{dca}",
                "දක\u{dd4}ණ",
                "ද\u{dd2}ශ\u{dcf}ව",
                "පහළට",
                "යට\u{dd2} ඊතලය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("šípka nadol"),
            keywords: &["dolu", "juh", "nadol", "šípka"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("puščica dol"),
            keywords: &["glavno", "jug", "navzdol", "puščica", "puščica dol", "smer"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("fallaarta hoose"),
            keywords: &[
                "afarta jiho",
                "fallaar",
                "fallaarta hoose",
                "hoos",
                "jiho",
                "koonfur",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("shigjetë poshtë"),
            keywords: &["drejtim", "jug", "kryesore", "poshtë", "shigjetë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("стрелица надоле"),
            keywords: &["jуг", "смер", "стрeлицa", "стрелица надоле"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("стрелица надоље"),
            keywords: &["стрелица надоље"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("strelica nadole"),
            keywords: &["jug", "smer", "strelica", "strelica nadole"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("strelica nadolje"),
            keywords: &["strelica nadolje"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("nedåtpil"),
            keywords: &[
                "nedåt",
                "nedåtpil",
                "pil",
                "riktning",
                "söder",
                "väderstreck",
            ],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mshale unaoangalia chini"),
            keywords: &[
                "chini",
                "kusini",
                "mshale",
                "mshale unaoangalia chini",
                "mshale unaoelekea chini",
                "sehemu kuu ya dira",
                "uelekeo",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("க\u{bc0}ழ\u{bcd} நோக\u{bcd}கிய அம\u{bcd}புக\u{bcd}குறி"),
            keywords: &[
                "அம\u{bcd}புக\u{bcd}குறி",
                "க\u{bbe}ர\u{bcd}டினல\u{bcd}",
                "க\u{bc0}ழ\u{bcd} நோக\u{bcd}கிய அம\u{bcd}புக\u{bcd}குறி",
                "க\u{bc0}ழ\u{bcd}நோக\u{bcd}கிய",
                "திசை",
                "தெற\u{bcd}கு",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ద\u{c3f}గువ బ\u{c3e}ణం"),
            keywords: &[
                "క\u{c3e}ర\u{c4d}డ\u{c3f}నల\u{c4d}",
                "దక\u{c4d}ష\u{c3f}ణం",
                "ద\u{c3f}గువ",
                "ద\u{c3f}శ",
                "బ\u{c3e}ణం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("тири поён"),
            keywords: &["асосӣ", "поён", "самт", "тир", "тири поён", "ҷануб"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ล\u{e39}กศรช\u{e35}\u{e49}ลง"),
            keywords: &[
                "ท\u{e34}ศทาง",
                "ลง",
                "ล\u{e39}กศร",
                "ล\u{e39}กศรช\u{e35}\u{e49}ลง",
                "ใต\u{e49}",
            ],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ምልክት ናብ ታሕቲ"),
            keywords: &["ምልክት", "ምልክት ናብ ታሕቲ", "ታሕቲ", "ኣንፈት", "ካአዲናል", "ደቡብ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("aşak ok"),
            keywords: &["aşak", "göni", "günorta", "ok", "ugur"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("ngahau ki lalo"),
            keywords: &["hifo", "lalo", "ngahau", "ngahau ki lalo"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("aşağı ok"),
            keywords: &["ana yön", "aşağı", "aşağı yönlü ok", "güney", "ok", "yön"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئاستى كۆرسەتكۈچ"),
            keywords: &["ئاساس", "ئاستى", "جەنۇب", "كۆرسەتكۈچ", "يۆنىلىش"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("стрілка вниз"),
            keywords: &["напрям", "південний", "сторона", "стрілка", "стрілка вниз"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("نیچے کا تیر"),
            keywords: &["تیر", "جنوب", "سمت", "نیچے", "نیچے کا تیر", "کارڈینل"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("pastga strelka"),
            keywords: &["janub", "pastga", "strelka", "yo‘nalish"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("mũi tên xuống"),
            keywords: &["chính", "hướng", "mũi tên", "mũi tên xuống", "nam", "xuống"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("fettu suuf"),
            keywords: &[
                "direction",
                "fett",
                "fettu suuf",
                "gànjool",
                "kàrdinal",
                "suuf",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("utolo olusezantsi"),
            keywords: &[
                "emzantsi",
                "ezantsi",
                "ukhardinale",
                "ulwalathiso",
                "utolo",
                "utolo olusezantsi",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("àmì ilẹ\u{300} ìtó\u{329}sọ\u{301}nà o\u{329}lọ\u{301}fà"),
            keywords: &[
                "gúúsù",
                "ilè\u{329}",
                "kádínàlì",
                "àmì ilẹ\u{300} ìtó\u{329}sọ\u{301}nà o\u{329}lọ\u{301}fà",
                "àmì ìtó\u{329}sọ\u{301}nà o\u{329}lọ\u{301}fà",
                "ìtọ\u{301}sọ\u{301}nà",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("向下箭咀"),
            keywords: &["南", "向下", "向下箭咀", "基點", "方向", "箭咀"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("向下箭咀"),
            keywords: &["南", "向下", "向下箭咀", "基点", "方向", "箭咀"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("向下箭头"),
            keywords: &["向下", "向下箭头", "基本", "方位", "正南", "箭头"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("向下箭頭"),
            keywords: &["向下箭頭", "方向"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("下箭嘴"),
            keywords: &["下箭嘴", "方向"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("umcibisholo opheke phansi"),
            keywords: &[
                "inkomba",
                "ningizimu",
                "phansi",
                "umcibisholo",
                "umcibisholo opheke phansi",
            ],
        },
    ],
};
#[doc = "↙\u{fe0f}"]
pub const DOWN_LEFT_ARROW: crate::Emoji = crate::Emoji {
    glyph: "↙\u{fe0f}",
    codepoint: "2199 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "down-left arrow",
    group: "Symbols",
    subgroup: "arrow",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "↙",
        codepoint: "2199",
        status: crate::Status::Unqualified,
        introduction_version: 0.6f32,
        name: "down-left arrow",
        group: "Symbols",
        subgroup: "arrow",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("pyl na links onder"),
            keywords: &["pyl", "pyl na links onder", "rigting", "suidwes"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ወደ ታች ግራ ጠቋሚ ቀስት"),
            keywords: &["ቀስት", "አቅጣጫ", "ኢንተርካርዲናል", "ወደ ታች ግራ ጠቋሚ ቀስት", "ደቡብ ምዕራብ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("سهم لأسفل اليسار"),
            keywords: &["اتجاه", "جنوب غرب", "سهم", "سهم لأسفل اليسار", "كاردينال"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("অধোগ\u{9be}মী ব\u{9be}ও\u{981}ম\u{9c1}খী ক\u{9be}\u{981}ড\u{9bc}"),
            keywords: &[
                "অধোগ\u{9be}মী ব\u{9be}ও\u{981}ম\u{9c1}খী ক\u{9be}\u{981}ড\u{9bc}",
                "আন\u{9cd}তঃদিশ",
                "ক\u{9be}\u{981}ড\u{9bc}",
                "দক\u{9cd}ষিণ-পশ\u{9cd}চিম",
                "দিশ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("üzüaşağı sola yönəlmiş ox"),
            keywords: &[
                "cənub qərb",
                "interkardinal",
                "istiqamət",
                "ox",
                "üzüaşağı sola yönəlmiş ox",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("стрэлка ўніз-улева"),
            keywords: &[
                "кірунак",
                "паўднёвы захад",
                "стрэлка",
                "стрэлка ўніз-улева",
                "уніз-улева",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("стрелка надолу и наляво"),
            keywords: &["посока", "стрелка", "стрелка надолу и наляво", "югозапад"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("নীচের ব\u{9be}মে তীর"),
            keywords: &[
                "আন\u{9cd}তঃ দিগনির\u{9cd}ণয\u{9bc}",
                "তীর",
                "দক\u{9cd}ষিণ-পশ\u{9cd}চিম",
                "দিক",
                "নীচের ব\u{9be}মে তীর",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("strelica dolje-lijevo"),
            keywords: &["jugozapad", "smjer", "strelica", "strelica dolje-lijevo"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("fletxa cap avall a l’esquerra"),
            keywords: &[
                "avall a l’esquerra",
                "direcció",
                "fletxa",
                "fletxa cap avall a l’esquerra",
                "sud-oest",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎡᎳᏗ-ᎠᎦᏍᎦᏂ ᎦᏝᏗ"),
            keywords: &[
                "ᎡᎳᏗ-ᎠᎦᏍᎦᏂ ᎦᏝᏗ",
                "ᎤᎦᏅᏮᎤᏕᎵᎬ",
                "ᎦᏝᏗ",
                "ᏂᏚᏳᎪᏛᎢ",
                "ᏅᎩᏂᏚᏳᎪᏛᎢ ᏂᏚᏓᎸᏗᏎᎯᎯ",
            ],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("šipka doleva dolů"),
            keywords: &[
                "jihozápad",
                "směr",
                "strany",
                "světové",
                "vedlejší",
                "šipka",
                "šipka doleva dolů",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("saeth i lawr-chwith"),
            keywords: &["De-orllewin", "cyfeiriad", "saeth", "saeth i lawr-chwith"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("nedadvendt pil mod venstre"),
            keywords: &["nedadvendt pil mod venstre", "pil", "retning", "sydvest"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Pfeil nach links unten"),
            keywords: &["Pfeil", "Pfeil nach links unten", "nach links unten"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κάτω αριστερό βέλος"),
            keywords: &[
                "βέλος",
                "ενδιάμεση",
                "κάτω αριστερό βέλος",
                "κατεύθυνση",
                "νοτιοδυτικά",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("down-left arrow"),
            keywords: &[
                "arrow",
                "direction",
                "down-left arrow",
                "intercardinal",
                "southwest",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("flecha hacia la esquina inferior izquierda"),
            keywords: &[
                "abajo",
                "dirección",
                "flecha",
                "flecha hacia la esquina inferior izquierda",
                "izquierda",
                "suroeste",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("flecha hacia el suroeste"),
            keywords: &["flecha hacia el suroeste"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("nool alla vasakule"),
            keywords: &["edel", "nool", "nool alla vasakule", "suund"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("behera eta ezkerrera gezia"),
            keywords: &[
                "behera eta ezkerrera gezia",
                "gezi",
                "hego-mendebalde",
                "kardinal arteko",
                "norabide",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("پیکان پایین چپ"),
            keywords: &["جنوب غربی", "جهت فرعی", "مسیر", "پیکان", "پیکان پایین چپ"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("nuoli alavasemmalle"),
            keywords: &[
                "ilmansuunta",
                "lounas",
                "nuoli",
                "nuoli alavasemmalle",
                "väli-ilmansuunta",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("pababang pakaliwang arrow"),
            keywords: &[
                "arrow",
                "direksyon",
                "intercardinal",
                "pababa",
                "pababang pakaliwang arrow",
                "pakaliwa",
                "timog-kanluran",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("pílur sum peikar niðureftir og til vinstru"),
            keywords: &[
                "k´ós",
                "pílur",
                "pílur sum peikar niðureftir og til vinstru",
                "ætt",
                "útsynningur",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("flèche bas gauche"),
            keywords: &["direction", "flèche", "flèche bas gauche", "sud-ouest"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("flèche pointant vers le bas à gauche"),
            keywords: &[
                "direction",
                "en bas à gauche",
                "flèche",
                "flèche pointant vers le bas à gauche",
                "point intercardinal",
                "sud-ouest",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("saighead síos ar chlé"),
            keywords: &[
                "idirbunuimhir",
                "saighead",
                "saighead síos ar chlé",
                "thiar theas",
                "treo",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("saighead gun iar-dheas"),
            keywords: &[
                "combaist",
                "comhair",
                "iar-dheas",
                "saighead",
                "saighead gun iar-dheas",
                "àirde",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("frecha cara abaixo á esquerda"),
            keywords: &[
                "abaixo",
                "dirección",
                "frecha",
                "frecha cara abaixo á esquerda",
                "suroeste",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("નીચ\u{ac7}-ડાબ\u{ac1}\u{a82} તીર"),
            keywords: &[
                "તીર",
                "દક\u{acd}ષિણપશ\u{acd}ચિમ",
                "નીચ\u{ac7}-ડાબ\u{ac1}\u{a82} તીર",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("kibiyar ƙasa ta hagu"),
            keywords: &[
                "a ƙetaren tsini shiyya",
                "kibiya",
                "kibiyar ƙasa ta hagu",
                "kudu maso yamma",
                "shiyya",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("חץ למטה ושמאלה"),
            keywords: &[
                "דרום-מערב",
                "חץ",
                "חץ למטה ושמאלה",
                "כיוון",
                "למטה",
                "שמאלה",
            ],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("नीच\u{947}-बाया\u{901} तीर"),
            keywords: &[
                "इ\u{902}टरकार\u{94d}डिनल",
                "दक\u{94d}षिण-पश\u{94d}चिम दिशा",
                "नीच\u{947}-बाया\u{901} तीर",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("strelica prema dolje-lijevo"),
            keywords: &[
                "jugozapad",
                "smjer",
                "strelica",
                "strelica prema dolje-lijevo",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("balra lefelé mutató nyíl"),
            keywords: &["balra lefelé mutató nyíl", "délnyugat", "irány", "nyíl"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ներքև ձախ սլաք"),
            keywords: &["հարավ-արևմուտք", "ներքև ձախ սլաք", "ուղղություն", "սլաք"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("tanda panah kiri bawah"),
            keywords: &[
                "arah",
                "barat daya",
                "interkardinal",
                "panah",
                "tanda panah kiri bawah",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ube-ala akaekpe"),
            keywords: &[
                "intakadịnal",
                "nduzi",
                "ndịdaọdịda anyanwụ",
                "ube",
                "ube-ala akaekpe",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("ör ská niður til vinstri"),
            keywords: &["suðvestur", "átt", "ör", "ör ská niður til vinstri"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("freccia in basso a sinistra"),
            keywords: &[
                "direzione",
                "freccia",
                "freccia in basso a sinistra",
                "punto intercardinale",
                "sud-ovest",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("左下矢印"),
            keywords: &["南西", "左下", "左下矢印", "矢印"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("panah mudhun-ngiwa"),
            keywords: &[
                "arah",
                "interkardinal",
                "kidul-kulon",
                "panah",
                "panah mudhun-ngiwa",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ისარი ქვემოთ და მარცხნივ"),
            keywords: &[
                "ინტერკარდინალური",
                "ისარი",
                "ისარი ქვემოთ და მარცხნივ",
                "კარდინალური",
                "მიმართულება",
                "სამხრეთ-დასავლეთი",
            ],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("aneccab akesser ayeffus"),
            keywords: &["aneccab akesser ayeffus"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("төменгі сол жақ көрсеткісі"),
            keywords: &[
                "бағыт",
                "көрсеткі",
                "оңтүстік-батыс",
                "румба аралық",
                "төменгі сол жақ көрсеткісі",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("nedadvendt pil mod venstre"),
            keywords: &["nedadvendt pil mod venstre", "pil", "retning", "sydvest"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some(
                "ព\u{17d2}រ\u{17bd}ញទៅក\u{17d2}រោមងាកទៅឆ\u{17d2}វេងក\u{17d2}ន\u{17bb}ងរាងប\u{17bd}នជ\u{17d2}រ\u{17bb}ង",
            ),
            keywords: &[
                "ទ\u{17b7}ស",
                "ទ\u{17b7}សដៅ",
                "ព\u{17d2}រ\u{17bd}ញ",
                "ព\u{17d2}រ\u{17bd}ញទៅក\u{17d2}រោមងាកទៅឆ\u{17d2}វេងក\u{17d2}ន\u{17bb}ងរាងប\u{17bd}នជ\u{17d2}រ\u{17bb}ង",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕ\u{cc6}ಳಗ\u{cbf}ನ ಎಡ ಬಾಣ"),
            keywords: &[
                "ಆಗ\u{ccd}ನೇಯ",
                "ಕ\u{cc6}ಳಗ\u{cbf}ನ ಎಡ ಬಾಣ",
                "ದ\u{cbf}ಕ\u{ccd}ಕು",
                "ಬಾಣದ ಗುರುತು",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("좌하향 화살표"),
            keywords: &["남서쪽", "좌하향 화살표", "화살표"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("सकयल-दावो बाण"),
            keywords: &[
                "उपदिशा",
                "दिशा",
                "न\u{948}ऋत\u{94d}य",
                "बाण",
                "सकयल-दावो बाण",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("төмөн сол жакты караган жебе"),
            keywords: &[
                "багыт",
                "жебе",
                "түштүк-батыш",
                "төмөн сол жакты караган жебе",
            ],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Feil no ënnen a lénks"),
            keywords: &[
                "Feil",
                "Feil no ënnen a lénks",
                "Himmelsrichtung",
                "Richtung",
                "Südwesten",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ລ\u{eb9}ກສອນລ\u{ebb}ງມ\u{eb8}ມຊ\u{ec9}າຍ"),
            keywords: &[
                "ທ\u{eb4}ດທາງ",
                "ມ\u{eb8}ມຊ\u{ec9}າຍ",
                "ລ\u{eb9}ກສອນ",
                "ລ\u{eb9}ກສອນລ\u{ebb}ງມ\u{eb8}ມຊ\u{ec9}າຍ",
                "ລ\u{ebb}ງ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("rodyklė į apačią ir į kairę"),
            keywords: &[
                "kryptis",
                "pietvakariai",
                "rodyklė",
                "rodyklė į apačią ir į kairę",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("uz apakšējo kreiso stūri vērsta bultiņa"),
            keywords: &[
                "bultiņa",
                "dienvidrietumi",
                "norāde",
                "uz apakšējo kreiso stūri vērsta bultiņa",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pere iho-mauī"),
            keywords: &[
                "ahunga",
                "pere",
                "pere iho-mauī",
                "uru-mā-tonga",
                "waenga-matua",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("стрелка надолу лево"),
            keywords: &["долу", "стрелка", "стрелка надолу лево", "југозапад"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some(
                "ത\u{d3e}ഴോട\u{d4d}ട\u{d4d} ഇടത\u{d4d}തേക\u{d4d}ക\u{d41}ള\u{d4d}ള അമ\u{d4d}പടയ\u{d3e}ളം",
            ),
            keywords: &[
                "അമ\u{d4d}പടയ\u{d3e}ളം",
                "ഇന\u{d4d}റർക\u{d3e}ർഡിനൽ",
                "ത\u{d3e}ഴോട\u{d4d}ട\u{d4d} ഇടത\u{d4d}തേക\u{d4d}ക\u{d41}ള\u{d4d}ള അമ\u{d4d}പടയ\u{d3e}ളം",
                "തെക\u{d4d}ക\u{d4d} പടിഞ\u{d4d}ഞ\u{d3e}റൻ",
                "ദിശ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("зүүн доошоо сум"),
            keywords: &["баруун урд", "зүүн доошоо сум", "сум", "чиглэл"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("खाली-डावीकड\u{947} दर\u{94d}शविणारा बाण"),
            keywords: &[
                "अ\u{902}तर\u{94d}गत महत\u{94d}वाच\u{947}",
                "खाली-डावीकड\u{947} दर\u{94d}शविणारा बाण",
                "दक\u{94d}षिणपश\u{94d}चिम",
                "दिशा",
                "बाण",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("anak panah ke penjuru kiri bawah"),
            keywords: &[
                "anak panah",
                "anak panah ke penjuru kiri bawah",
                "antara kardinal",
                "arah",
                "barat daya",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("vleġġa xellugija ’l isfel"),
            keywords: &[
                "direzzjoni",
                "interkardinal",
                "lbiċ",
                "vleġġa",
                "vleġġa xellugija ’l isfel",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဘယ\u{103a}ဘက\u{103a}အောက\u{103a}ည\u{103d}\u{103e}န\u{103a} မြား"),
            keywords: &[
                "ဘယ\u{103a}ဘက\u{103a}အောက\u{103a}ည\u{103d}\u{103e}န\u{103a} မြား",
                "မြား",
                "လမ\u{103a}းည\u{103d}\u{103e}န\u{103a}",
                "အနောက\u{103a}တောင\u{103a}",
                "အရပ\u{103a}မျက\u{103a}န\u{103e}ာ န\u{103e}စ\u{103a}ခ\u{102f}ကြားပြ အမ\u{103e}တ\u{103a}အသား",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("pil ned-venstre"),
            keywords: &["pil", "pil ned-venstre", "retning", "sørvest"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("तल बाया\u{901}तर\u{94d}फको तीर"),
            keywords: &[
                "इन\u{94d}टरकार\u{94d}डिनल",
                "तल बाया\u{901}तर\u{94d}फको तीर",
                "तीर",
                "दक\u{94d}षिण प\u{942}र\u{94d}व",
                "दिशा",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("pijl linksomlaag"),
            keywords: &["linksbeneden", "linksomlaag", "pijl", "zuidwest"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ତଳ-ବ\u{b3e}ମ ତୀର"),
            keywords: &[
                "ଅନ\u{b4d}ତଃପ\u{b4d}ରଧ\u{b3e}ନ",
                "ତଳ-ବ\u{b3e}ମ ତୀର",
                "ତୀର",
                "ଦକ\u{b4d}ଷ\u{b3f}ଣପଶ\u{b4d}ଚ\u{b3f}ମ",
                "ଦ\u{b3f}ଗ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਥ\u{a71}ਲ\u{a47}-ਖ\u{a71}ਬ\u{a47} ਤੀਰ"),
            keywords: &[
                "ਇ\u{a70}ਟਰਕਾਰਡੀਨਲ",
                "ਤੀਰ",
                "ਥ\u{a71}ਲ\u{a47}-ਖ\u{a71}ਬ\u{a47} ਤੀਰ",
                "ਦਿਸ\u{a3c}ਾ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ہیٹھلا-کھبا تیر"),
            keywords: &["انٹر کارڈینل", "تیر", "جنوب مغرب", "سمت", "ہیٹھلا-کھبا تیر"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Áro De Pọínt Daún-Lẹft"),
            keywords: &[
                "Dairẹ\u{301}kshọn",
                "Kádínal",
                "Saútwẹst",
                "Áro",
                "Áro De Pọínt Daún-Lẹft",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("strzałka w dół w lewo"),
            keywords: &[
                "kierunek",
                "południowy zachód",
                "strzałka",
                "strzałka na dół w lewo",
                "strzałka w dół w lewo",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ښکته چپ اړخ ته غشی"),
            keywords: &[
                "انټر کارډينل",
                "اړخ",
                "سويلي ختيځ",
                "غشی",
                "چپ ښکته غشی",
                "ښکته چپ اړخ ته غشی",
            ],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("seta para baixo e para a esquerda"),
            keywords: &[
                "direção",
                "intercardinal",
                "seta",
                "seta para baixo e para a esquerda",
                "sudoeste",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("seta para baixo e para a esquerda"),
            keywords: &[
                "direção",
                "intermédio",
                "seta",
                "seta para baixo e para a esquerda",
                "sudoeste",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("uran lluq’i wach’i"),
            keywords: &["uran lluq’i wach’i"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("săgeată orientată în stânga jos"),
            keywords: &[
                "direcție",
                "intercardinal",
                "sud-vest",
                "săgeată",
                "săgeată orientată în stânga jos",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-011"),
            keywords: &["E10-011"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("стрелка влево-вниз"),
            keywords: &["влево-вниз", "направление", "стрелка", "юго-запад"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umwambi wo hasi ahagana ibumoso"),
            keywords: &[
                "amajyepfo ashyira iburengerazuba",
                "icyerekezo",
                "kiri hagati y’ibyerekezo bine",
                "umwambi",
                "umwambi wo hasi ahagana ibumoso",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("هيٺ کاٻي طرف تير"),
            keywords: &["انٽرڪارڊينل", "تير", "طرف", "هيٺ کاٻي طرف تير", "ڏکڻ اولھ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("යට\u{dd2}-වම\u{dca} ඊතලය"),
            keywords: &[
                "ඉන\u{dca}ටර\u{dca}ක\u{dcf}ඩ\u{dd2}නල\u{dca}",
                "ඊතලය",
                "ද\u{dd2}ශ\u{dcf}ව",
                "න\u{dd2}ර\u{dd2}ත",
                "යට\u{dd2}-වම\u{dca} ඊතලය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("šípka doľava nadol"),
            keywords: &["doľava nadol", "juhozápad", "šípka", "šípka doľava nadol"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("puščica levo dol"),
            keywords: &[
                "jugozahod",
                "puščica",
                "puščica levo dol",
                "smer",
                "stransko",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("fallaarta hoose ee bidix"),
            keywords: &[
                "fallaar",
                "fallaarta hoose ee bidix",
                "isdhaafsiga jihooyinka",
                "jihada",
                "koonfur galbeed",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("shigjetë poshtë majtas"),
            keywords: &[
                "drejtim",
                "i ndërmjetëm",
                "jugperëndim",
                "shigjetë",
                "shigjetë poshtë majtas",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("стрелица надоле и налево"),
            keywords: &["jугoзaпaд", "смер", "стрeлицa", "стрелица надоле и налево"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("стрелица надоље и налијево"),
            keywords: &["стрелица надоље и налијево"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("strelica nadole i nalevo"),
            keywords: &["jugozapad", "smer", "strelica", "strelica nadole i nalevo"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("strelica nadolje i nalijevo"),
            keywords: &["strelica nadolje i nalijevo"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("nedåtpil vänster"),
            keywords: &["nedåt", "nedåtpil vänster", "pil", "vänster"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mshale unaoelekeza chini kushoto"),
            keywords: &[
                "kati ya sehemu kuu ya dira",
                "kusini magharibi",
                "mshale",
                "mshale unaoelekeza chini kushoto",
                "uelekeo",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("க\u{bc0}ழ\u{bcd}-இடது நோக\u{bcd}கிய அம\u{bcd}புக\u{bcd}குறி"),
            keywords: &[
                "க\u{bc0}ழ\u{bcd}-இடது நோக\u{bcd}கிய அம\u{bcd}புக\u{bcd}குறி",
                "திசை",
                "தென\u{bcd}மேற\u{bcd}கு",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ద\u{c3f}గువ ఎడమ బ\u{c3e}ణం"),
            keywords: &[
                "ద\u{c3f}గువ ఎడమ బ\u{c3e}ణం",
                "ద\u{c3f}శ",
                "న\u{c48}రుత\u{c3f}",
                "బ\u{c3e}ణం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("тири поёну чап"),
            keywords: &["мобайнӣ", "самт", "тир", "тири поёну чап", "ҷанубу ғарб"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ล\u{e39}กศรช\u{e35}\u{e49}ม\u{e38}\u{e38}มซ\u{e49}ายล\u{e48}าง"),
            keywords: &[
                "ตะว\u{e31}นตกเฉ\u{e35}ยงใต\u{e49}",
                "ท\u{e34}ศทาง",
                "ล\u{e39}กศร",
                "ล\u{e39}กศรช\u{e35}\u{e49}ม\u{e38}\u{e38}มซ\u{e49}ายล\u{e48}าง",
            ],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ምልክት ናብ-ጸጋማይ ታሕቲ"),
            keywords: &[
                "ምልክት",
                "ምልክት ናብ-ጸጋማይ ታሕቲ",
                "ኣንፈት",
                "ውሽጣዊ ናይ ካርዲናል",
                "ደቡባዊ ምዕራብ",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("aşak-çepe ok"),
            keywords: &["aşak-çepe ok", "gytak", "günorta-günbatar", "ok", "ugur"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("ngahau ki lalo toʻohema"),
            keywords: &["hema", "lalo", "ngahau", "ngahau ki lalo toʻohema"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("sol aşağı ok"),
            keywords: &["ara yön", "güney batı", "ok", "sol aşağı ok", "yön"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئاستى سول كۆرسەتكۈچ"),
            keywords: &[
                "ئارا يۆنىلىشلىك",
                "ئاستى سول كۆرسەتكۈچ",
                "غەربىي-شىمال",
                "كۆرسەتكۈچ",
                "يۆنىلىش",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("стрілка вниз уліво"),
            keywords: &[
                "напрям",
                "проміжний",
                "південно-західний",
                "стрілка",
                "стрілка вниз уліво",
                "стрілка вниз і ліворуч",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("نیچے بائیں تیر"),
            keywords: &["تیر", "جنوب مغرب", "سائن", "سمت", "نیچے بائیں تیر"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("past-chapga strelka"),
            keywords: &[
                "chiziq",
                "janubi g‘arb",
                "past-chapga strelka",
                "past-chapga yo‘nalish",
                "yo‘nalish",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("mũi tên xuống bên trái"),
            keywords: &[
                "hướng",
                "mũi tên",
                "mũi tên xuống bên trái",
                "nhiều hướng",
                "tây nam",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("suuf-càmmoñ fett"),
            keywords: &[
                "fett",
                "interkàrdinal",
                "jubluwaay",
                "sowwu-gànjool",
                "suuf-càmmoñ fett",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("utolo olusezantsi ekhohlo"),
            keywords: &[
                "entshona mzantsi",
                "ukhardinale ohlangeneyo",
                "ulwalathiso",
                "utolo",
                "utolo olusezantsi ekhohlo",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("àmì ilẹ\u{300} ìtó\u{329}sọ\u{301}nà o\u{329}lọ\u{301}fà apá òsì"),
            keywords: &[
                "iwọ\u{300} oòrùn gúúsù",
                "àmì ilẹ\u{300} ìtó\u{329}sọ\u{301}nà o\u{329}lọ\u{301}fà apá òsì",
                "àmì ìtó\u{329}sọ\u{301}nà o\u{329}lọ\u{301}fà",
                "ìlọ\u{301}pọ\u{300} kádínàlì",
                "ìtọ\u{301}sọ\u{301}nà",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("向左下箭咀"),
            keywords: &["向左下箭咀", "基點間", "方向", "箭咀", "西南"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("向左下箭咀"),
            keywords: &["向左下箭咀", "基点间", "方向", "箭咀", "西南"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("左下箭头"),
            keywords: &["左下箭头", "方向", "标识", "西南"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("左下箭頭"),
            keywords: &["左下箭頭", "方向"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("下左箭嘴"),
            keywords: &["下左箭嘴", "方向"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("umcibisholo obheke phansi kwesokunxele"),
            keywords: &[
                "inkomba",
                "ningizimuntshonalanga",
                "umcibisholo",
                "umcibisholo obheke phansi kwesokunxele",
            ],
        },
    ],
};
#[doc = "⬅\u{fe0f}"]
pub const LEFT_ARROW: crate::Emoji = crate::Emoji {
    glyph: "⬅\u{fe0f}",
    codepoint: "2B05 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "left arrow",
    group: "Symbols",
    subgroup: "arrow",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "⬅",
        codepoint: "2B05",
        status: crate::Status::Unqualified,
        introduction_version: 0.6f32,
        name: "left arrow",
        group: "Symbols",
        subgroup: "arrow",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("pyl na links"),
            keywords: &["links", "pyl", "pyl na links", "rigting", "wes"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ወደ ግራ ጠቋሚ ቀስት"),
            keywords: &["ምዕራብ", "ቀስት", "አቅጣጫ", "ካርዲናል", "ወደ ግራ ጠቋሚ ቀስት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("سهم لليسار"),
            keywords: &["اتجاه", "سهم", "سهم لليسار", "غرب", "كاردينال"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ব\u{9be}ও\u{981}ম\u{9c1}খী ক\u{9be}\u{981}ড\u{9bc}"),
            keywords: &[
                "ক\u{9be}\u{981}ড\u{9bc}",
                "দিশ",
                "পশ\u{9cd}চিম",
                "ব\u{9be}ও\u{981}ম\u{9c1}খী ক\u{9be}\u{981}ড\u{9bc}",
                "ম\u{9c1}খ\u{9cd}য দিশবিল\u{9be}ক",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("sola ox"),
            keywords: &["istiqamət", "kardinal", "ox", "qərb", "sola ox"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("стрэлка ўлева"),
            keywords: &["захад", "кірунак", "стрэлка", "стрэлка ўлева", "улева"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Стрелка наляво"),
            keywords: &["Стрелка наляво", "запад", "посока", "стрелка"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ব\u{9be}ম তীর"),
            keywords: &[
                "তীর",
                "দিকনির\u{9cd}দেশ",
                "পরিম\u{9be}ণব\u{9be}চক",
                "পশ\u{9cd}চিম",
                "ব\u{9be}ম তীর",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("strelica nalijevo"),
            keywords: &["smjer", "strelica", "strelica nalijevo", "zapad"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("fletxa cap a l’esquerra"),
            keywords: &[
                "direcció",
                "esquerra",
                "fletxa",
                "fletxa cap a l’esquerra",
                "oest",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᎦᏍᎦᏂ ᎦᏝᏗ"),
            keywords: &["ᎠᎦᏍᎦᏂ ᎦᏝᏗ", "ᎤᏕᎵᎬᎢ", "ᎦᏝᏗ", "ᏂᏚᏳᎪᏛᎢ", "ᏧᏂᏍᎨᏓ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("šipka doleva"),
            keywords: &[
                "hlavní",
                "směr",
                "strany",
                "světové",
                "západ",
                "šipka",
                "šipka doleva",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("saeth i’r chwith"),
            keywords: &["Gorllewin", "cyfeiriad", "saeth", "saeth i’r chwith"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("pil mod venstre"),
            keywords: &["pil", "pil mod venstre", "retning", "verdenshjørne", "vest"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Pfeil nach links"),
            keywords: &[
                "Linkspfeil",
                "Pfeil",
                "Pfeil nach links",
                "Westen",
                "nach links",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("αριστερό βέλος"),
            keywords: &["απόλυτη", "αριστερό βέλος", "βέλος", "δυτικά", "κατεύθυνση"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("left arrow"),
            keywords: &["arrow", "cardinal", "direction", "left arrow", "west"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("flecha hacia la izquierda"),
            keywords: &["flecha", "flecha hacia la izquierda", "izquierda", "oeste"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &[
                "dirección",
                "flecha",
                "flecha hacia el oeste",
                "flecha hacia la izquierda",
                "izquierda",
                "oeste",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &[
                "cardinal",
                "dirección",
                "flecha",
                "flecha hacia la izquierda",
                "oeste",
            ],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("nool vasakule"),
            keywords: &["lääs", "nool", "nool vasakule", "suund"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("ezkerrera gezia"),
            keywords: &[
                "ezkerrera gezia",
                "gezi",
                "kardinal",
                "mendebalde",
                "norabide",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("پیکان چپ"),
            keywords: &["جهت اصلی", "غرب", "مسیر", "پیکان", "پیکان چپ"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("nuoli vasemmalle"),
            keywords: &[
                "ilmansuunta",
                "länsi",
                "nuoli",
                "nuoli vasemmalle",
                "pääilmansuunta",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("pakaliwang arrow"),
            keywords: &[
                "arrow",
                "cardinal",
                "direksyon",
                "kanluran",
                "pakaliwa",
                "pakaliwang arrow",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("pílur sum peikar til vinstru"),
            keywords: &[
                "k´ós",
                "pílur",
                "pílur sum peikar til vinstru",
                "vestur",
                "ætt",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("flèche gauche"),
            keywords: &["direction", "flèche", "flèche gauche", "ouest"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("flèche pointant vers la gauche"),
            keywords: &[
                "direction",
                "flèche",
                "flèche pointant vers la gauche",
                "ouest",
                "point cardinal",
                "à gauche",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("saighead ar chlé"),
            keywords: &["príomhaird", "saighead", "saighead ar chlé", "siar", "treo"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("saighead gun iar"),
            keywords: &[
                "combaist",
                "comhair",
                "iar",
                "saighead",
                "saighead gun iar",
                "àirde",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("frecha cara á esquerda"),
            keywords: &["dirección", "esquerda", "frecha cara á esquerda", "oeste"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ડાબ\u{ac1}\u{a82} તીર"),
            keywords: &[
                "ડાબ\u{ac1}\u{a82} તીર",
                "તીર",
                "દિશા",
                "પશ\u{acd}ચિમ",
                "મ\u{ac1}ખ\u{acd}ય",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("kibiyar hagu"),
            keywords: &["kibiya", "kibiyar hagu", "shiyya", "tsinin shiyya", "yamma"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("חץ שמאלה"),
            keywords: &["חץ", "כיוון", "מערב", "שמאלה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("बाया\u{901} तीर"),
            keywords: &[
                "कार\u{94d}डिनल",
                "तीर",
                "पश\u{94d}चिम दिशा",
                "बाया\u{901} तीर",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("strelica prema lijevo"),
            keywords: &["smjer", "strelica", "strelica prema lijevo", "zapad"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("balra mutató nyíl"),
            keywords: &["balra", "balra mutató nyíl", "irány", "nyugat", "nyíl"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ձախ սլաք"),
            keywords: &["արևմուտք", "գլխավոր", "ձախ սլաք", "ուղղություն", "սլաք"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("tanda panah kiri"),
            keywords: &["arah", "barat", "kardinal", "panah", "tanda panah kiri"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ube akaekpe"),
            keywords: &["kadịnal", "nduzi", "ube", "ube akaekpe", "ọdịda anyanwụ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("ör til vinstri"),
            keywords: &["höfuðátt", "vestur", "átt", "ör", "ör til vinstri"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("freccia rivolta a sinistra"),
            keywords: &[
                "direzione",
                "freccia",
                "freccia a sinistra",
                "freccia rivolta a sinistra",
                "ovest",
                "punto cardinale",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("左矢印"),
            keywords: &["左", "左矢印", "矢印", "西"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("panah ngiwa"),
            keywords: &["arah", "kardinal", "kulon", "panah", "panah ngiwa"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ისარი მარცხნივ"),
            keywords: &[
                "დასავლეთი",
                "ისარი",
                "ისარი მარცხნივ",
                "კარდინალური",
                "მიმართულება",
            ],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("aneccab azelmaḍ"),
            keywords: &["aneccab azelmaḍ"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("сол жақ бағытты көрсеткі"),
            keywords: &[
                "батыс",
                "бағыт",
                "көрсеткі",
                "негізгі",
                "сол жақ бағытты көрсеткі",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("pil mod venstre"),
            keywords: &["pil", "pil mod venstre", "retning", "verdenshjørne", "vest"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ព\u{17d2}រ\u{17bd}ញទៅឆ\u{17d2}វេង"),
            keywords: &[
                "ទ\u{17b7}ស",
                "ព\u{17d2}រ\u{17bd}ញ",
                "ព\u{17d2}រ\u{17bd}ញទៅឆ\u{17d2}វេង",
                "ល\u{17b7}ច",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಎಡಭಾಗದ ಬಾಣ"),
            keywords: &[
                "ಎಡ ಬಾಣ",
                "ಎಡಭಾಗದ ಬಾಣ",
                "ದ\u{cbf}ಕ\u{ccd}ಕು ಪಶ\u{ccd}ಚ\u{cbf}ಮ",
                "ನ\u{cbf}ರ\u{ccd}ದೇಶನ",
                "ಬಾಣದ ಗುರುತು",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("좌향 화살표"),
            keywords: &["서쪽", "좌향 화살표", "화살표"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("दावो बाण"),
            keywords: &[
                "अस\u{94d}त\u{902}त",
                "दावो बाण",
                "दिशा",
                "बाण",
                "म\u{941}ख\u{947}लदिशा",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("сол жакты караган жебе"),
            keywords: &["багыт", "батыш", "жебе", "сол жакты караган жебе"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Feil no lénks"),
            keywords: &[
                "Feil",
                "Feil no lénks",
                "Himmelsrichtung",
                "Richtung",
                "Westen",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ລ\u{eb9}ກສອນຊ\u{ec9}າຍ"),
            keywords: &[
                "ຊ\u{ec9}າຍ",
                "ທ\u{eb4}ດທາງ",
                "ລ\u{eb9}ກສອນ",
                "ລ\u{eb9}ກສອນຊ\u{ec9}າຍ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("rodyklė į kairę"),
            keywords: &[
                "koordinatė",
                "kryptis",
                "rodyklė",
                "rodyklė į kairę",
                "vakarai",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("kreisā bultiņa"),
            keywords: &[
                "bultiņa",
                "kreisā bultiņa",
                "norāde",
                "pa kreisi vērsta bultiņa",
                "rietumi",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pere mauī"),
            keywords: &["ahunga", "matua", "pere", "pere mauī", "uru"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("стрелка налево"),
            keywords: &["запад", "лево", "стрелка", "стрелка налево"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some(
                "ഇടത\u{d4d}തേക\u{d4d}ക\u{d4d} ച\u{d42}ണ\u{d4d}ട\u{d41}ന\u{d4d}ന അമ\u{d4d}പടയ\u{d3e}ളം",
            ),
            keywords: &[
                "അമ\u{d4d}പടയ\u{d3e}ളം",
                "ഇടത\u{d4d}തേക\u{d4d}ക\u{d4d} ച\u{d42}ണ\u{d4d}ട\u{d41}ന\u{d4d}ന അമ\u{d4d}പടയ\u{d3e}ളം",
                "ക\u{d3e}ർഡിനൽ",
                "ദിശ",
                "പടിഞ\u{d4d}ഞ\u{d3e}റ\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("зүүн сум"),
            keywords: &["баруун", "зүүн сум", "кардинал", "сум", "чиглэл"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("डावा बाण"),
            keywords: &[
                "डावा बाण",
                "दिशा",
                "पश\u{94d}चिम",
                "बाण",
                "महत\u{94d}वाच\u{947}",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("anak panah ke kiri"),
            keywords: &[
                "anak panah",
                "anak panah ke kiri",
                "arah",
                "barat",
                "kardinal",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("vleġġa xellugija"),
            keywords: &[
                "direzzjoni",
                "il-punent",
                "kardinal",
                "vleġġa",
                "vleġġa xellugija",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဘယ\u{103a}ည\u{103d}\u{103e}န\u{103a}မြား"),
            keywords: &[
                "ဘယ\u{103a}ည\u{103d}\u{103e}န\u{103a}မြား",
                "မြား",
                "လမ\u{103a}းည\u{103d}\u{103e}န\u{103a}",
                "အနောက\u{103a}",
                "အရပ\u{103a}မျက\u{103a}န\u{103e}ာပြ သင\u{103a}\u{1039}ကေတ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("pil venstre"),
            keywords: &["pil", "pil venstre", "retning", "venstrepil", "vest"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("बाया\u{901}तर\u{94d}फको तीर"),
            keywords: &[
                "कार\u{94d}डिनल",
                "तीर",
                "दिशा",
                "पश\u{94d}चिम",
                "बाया\u{901}तर\u{94d}फको तीर",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("pijl naar links"),
            keywords: &[
                "pijl",
                "pijl naar links",
                "richting",
                "west",
                "windrichting",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("pil venstre"),
            keywords: &["pil", "pil venstre", "retning", "venstrepil", "vest"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ବ\u{b3e}ମ ତୀର"),
            keywords: &[
                "ତୀର",
                "ଦ\u{b3f}ଗ",
                "ପଶ\u{b4d}ଚ\u{b3f}ମ",
                "ପ\u{b4d}ରଧ\u{b3e}ନ",
                "ବ\u{b3e}ମ ତୀର",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਖ\u{a71}ਬ\u{a47} ਤੀਰ"),
            keywords: &[
                "ਕਾਰਡੀਨਲ",
                "ਖ\u{a71}ਬ\u{a47} ਤੀਰ",
                "ਤੀਰ",
                "ਦਿਸ\u{a3c}ਾ",
                "ਪ\u{a71}ਛਮ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("کھبا تیر"),
            keywords: &["اہم", "تیر", "سمت", "مغرب", "کھبا تیر"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Áro De Pọínt Lẹft"),
            keywords: &[
                "Dairẹ\u{301}kshọn",
                "Kádínal",
                "Wẹst",
                "Áro",
                "Áro De Pọínt Lẹft",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("strzałka w lewo"),
            keywords: &["kierunek", "strzałka", "strzałka w lewo", "zachód"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("چپ غشی"),
            keywords: &["اساسي", "اړخ", "غشی", "لوېديځ", "چپ غشی"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("seta para a esquerda"),
            keywords: &[
                "direção",
                "esquerda",
                "oeste",
                "seta",
                "seta para a esquerda",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &[
                "cardeal",
                "direção",
                "oeste",
                "seta",
                "seta para a esquerda",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("lluq’i wach’i"),
            keywords: &["lluq’i wach’i"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("săgeată orientată în stânga"),
            keywords: &[
                "cardinal",
                "direcție",
                "săgeată",
                "săgeată orientată în stânga",
                "vest",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-156"),
            keywords: &["E10-156"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("стрелка влево"),
            keywords: &["влево", "запад", "направление", "стрелка"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("akambi k’ibumoso"),
            keywords: &[
                "akambi k’ibumoso",
                "iburengerazuba",
                "icyerekezo",
                "kimwe mu byerekezo bine",
                "umwambi",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("کاٻي طرف تير"),
            keywords: &["اولھ", "تير", "طرف", "کاٻي طرف تير", "ڪارڊينل"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("වම\u{dca} ඊතලය"),
            keywords: &[
                "ඊතලය",
                "ක\u{dcf}ඩ\u{dd2}නල\u{dca}",
                "ද\u{dd2}ශ\u{dcf}ව",
                "බටහ\u{dd2}ර",
                "වම\u{dca} ඊතලය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("šípka doľava"),
            keywords: &["doľava", "západ", "šípka"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("puščica levo"),
            keywords: &["glavno", "puščica", "puščica levo", "smer", "zahod"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("fallarta bidix"),
            keywords: &[
                "afarta jiho",
                "fallaar",
                "fallaarta bidix",
                "fallarta bidix",
                "galbeed",
                "jiho",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("shigjeta majtas"),
            keywords: &[
                "drejtim",
                "kryesor",
                "perëndim",
                "shigjeta majtas",
                "shigjetë",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("стрелица налево"),
            keywords: &["зaпaд", "смер", "стрeлицa", "стрелица налево"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("стрелица налијево"),
            keywords: &["стрелица налијево"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("strelica nalevo"),
            keywords: &["smer", "strelica", "strelica nalevo", "zapad"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("strelica nalijevo"),
            keywords: &["strelica nalijevo"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("vänsterpil"),
            keywords: &["pil", "riktning", "väderstreck", "vänsterpil", "väster"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mshale unaoelekeza kushoto"),
            keywords: &[
                "magharibi",
                "mshale",
                "mshale unaoelekeza kushoto",
                "sehemu kuu ya dira",
                "uelekeo",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("இடது நோக\u{bcd}கிய அம\u{bcd}புக\u{bcd}குறி"),
            keywords: &[
                "அம\u{bcd}புக\u{bcd}குறி",
                "இடது நோக\u{bcd}கிய அம\u{bcd}புக\u{bcd}குறி",
                "க\u{bbe}ர\u{bcd}டினல\u{bcd}",
                "திசை",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ఎడమ బ\u{c3e}ణం"),
            keywords: &[
                "ఎడమ బ\u{c3e}ణం",
                "క\u{c3e}ర\u{c4d}డ\u{c3f}నల\u{c4d}",
                "ద\u{c3f}శ",
                "బ\u{c3e}ణం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("тири чап"),
            keywords: &["асосӣ", "самт", "тир", "тири чап", "ғарб"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ล\u{e39}กศรช\u{e35}\u{e49}ไปทางซ\u{e49}าย"),
            keywords: &[
                "ตะว\u{e31}นตก",
                "ท\u{e34}ศทาง",
                "ล\u{e39}กศร",
                "ล\u{e39}กศรช\u{e35}\u{e49}ไปทางซ\u{e49}าย",
            ],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ምልክት ናብ-ጸጋም"),
            keywords: &["ምልክት", "ምልክት ናብ-ጸጋም", "ምዕራብ", "ኣንፈት", "ካርዲና፡"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("çepe ok"),
            keywords: &["göni", "günbatar", "ok", "ugur", "çepe ok"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("ngahau ki toʻohema"),
            keywords: &["hema", "ngahau", "ngahau ki toʻohema"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("sol ok"),
            keywords: &["ana yön", "batı", "ok", "sol ok", "yön"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("سول كۆرسەتكۈچ"),
            keywords: &["ئاساس", "سول كۆرسەتكۈچ", "غەرب", "كۆرسەتكۈچ", "يۆنىلىش"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("стрілка вліво"),
            keywords: &[
                "західний",
                "напрям",
                "сторона",
                "стрілка вліво",
                "стрілка ліворуч",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("بائیں تیر"),
            keywords: &["بائیں تیر", "تیر", "سمت", "مغرب", "کارڈینل"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("chapga strelka"),
            keywords: &["chapga strelka", "g‘arb", "strelka", "yo‘nalish"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("mũi tên trái"),
            keywords: &["chiều hướng", "chính", "mũi tên", "mũi tên trái", "tây"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("fettu càmmoñ"),
            keywords: &["fett", "fettu càmmoñ", "jubluwaay", "kàrdinal", "sowwu"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("utolo olusekhohlo"),
            keywords: &[
                "entshona",
                "ukhardinale",
                "ulwalathiso",
                "utolo",
                "utolo olusekhohlo",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("àmì ìtó\u{329}sọ\u{301}nà o\u{329}lọ\u{301}fà apá òsì"),
            keywords: &[
                "iwọ\u{300} oòrùn",
                "kádínàlì",
                "àmì ìtó\u{329}sọ\u{301}nà o\u{329}lọ\u{301}fà",
                "àmì ìtó\u{329}sọ\u{301}nà o\u{329}lọ\u{301}fà apá òsì",
                "ìtọ\u{301}sọ\u{301}nà",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("向左箭咀"),
            keywords: &["向左箭咀", "基點", "方向", "箭咀", "西"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("向左箭咀"),
            keywords: &["向左箭咀", "基点", "方向", "箭咀", "西"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("向左箭头"),
            keywords: &["向左箭头", "方向", "标识", "西"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("向左箭頭"),
            keywords: &["向左箭頭", "方向"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("左箭嘴"),
            keywords: &["左箭嘴", "方向"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("inkombasinxele"),
            keywords: &["inkomba", "inkombasinxele", "ntshonalanga"],
        },
    ],
};
#[doc = "↖\u{fe0f}"]
pub const UP_LEFT_ARROW: crate::Emoji = crate::Emoji {
    glyph: "↖\u{fe0f}",
    codepoint: "2196 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "up-left arrow",
    group: "Symbols",
    subgroup: "arrow",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "↖",
        codepoint: "2196",
        status: crate::Status::Unqualified,
        introduction_version: 0.6f32,
        name: "up-left arrow",
        group: "Symbols",
        subgroup: "arrow",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("pyl na links bo"),
            keywords: &["noordwes", "pyl", "pyl na links bo", "rigting"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ወደ ላይ ግራ ጠቋሚ ቀስት"),
            keywords: &["ሰሜን ምዕራብ", "ቀስት", "አቅጣጫ", "ኢንተርካርዲናል", "ወደ ላይ ግራ ጠቋሚ ቀስት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("سهم لأعلى اليسار"),
            keywords: &["اتجاه", "سهم", "سهم لأعلى اليسار", "شمال غرب", "كاردينال"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some(
                "ঊৰ\u{9cd}ধ\u{9cd}বগ\u{9be}মী ব\u{9be}ও\u{981}ম\u{9c1}খী ক\u{9be}\u{981}ড\u{9bc}",
            ),
            keywords: &[
                "আন\u{9cd}তঃদিশ",
                "উত\u{9cd}তৰ-পশ\u{9cd}চিম",
                "ঊৰ\u{9cd}ধ\u{9cd}বগ\u{9be}মী ব\u{9be}ও\u{981}ম\u{9c1}খী ক\u{9be}\u{981}ড\u{9bc}",
                "ক\u{9be}\u{981}ড\u{9bc}",
                "দিশ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("üzüyuxarı sola yönəlmiş ox"),
            keywords: &[
                "interkardinal",
                "istiqamət",
                "ox",
                "üzüyuxarı sola yönəlmiş ox",
                "şimal qərb",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("стрэлка ўверх-улева"),
            keywords: &[
                "кірунак",
                "паўночны захад",
                "стрэлка",
                "стрэлка ўверх-улева",
                "уверх-улева",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("стрелка нагоре и наляво"),
            keywords: &[
                "посока",
                "северозапад",
                "стрелка",
                "стрелка нагоре и наляво",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("উপরে ব\u{9be}মে তীর"),
            keywords: &[
                "আন\u{9cd}তঃ দিগনির\u{9cd}ণয\u{9bc}",
                "উত\u{9cd}তর-পশ\u{9cd}চিম",
                "উপরে ব\u{9be}মে তীর",
                "তীর",
                "দিক",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("strelica gore-lijevo"),
            keywords: &["sjeverozapad", "smjer", "strelica", "strelica gore-lijevo"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("fletxa cap amunt a l’esquerra"),
            keywords: &[
                "amunt a l’esquerra",
                "direcció",
                "fletxa",
                "fletxa cap amunt a l’esquerra",
                "nord-oest",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎦᎸᎳᏗ-ᎠᎦᏍᎦᏂ ᎦᏝᏗ"),
            keywords: &[
                "ᎤᏴᏢᎢᏭᏕᎵᎬᎢ",
                "ᎦᎸᎳᏗ-ᎠᎦᏍᎦᏂ ᎦᏝᏗ",
                "ᎦᏝᏗ",
                "ᏂᏚᏳᎪᏛᎢ",
                "ᏅᎩᏂᏚᏳᎪᏛᎢ ᏂᏚᏓᎸᏗᏎᎯᎯ",
            ],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("šipka doleva nahoru"),
            keywords: &[
                "severozápad",
                "směr",
                "strany",
                "světové",
                "vedlejší",
                "šipka",
                "šipka doleva nahoru",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("saeth i fyny-chwith"),
            keywords: &[
                "Gogledd-orllewin",
                "cyfeiriad",
                "saeth",
                "saeth i fyny-chwith",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("opadvendt pil mod venstre"),
            keywords: &["nordvest", "opadvendt pil mod venstre", "pil", "retning"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Pfeil nach links oben"),
            keywords: &[
                "Nordwesten",
                "Pfeil",
                "Pfeil nach links oben",
                "nach links oben",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("πάνω αριστερό βέλος"),
            keywords: &[
                "βέλος",
                "βορειοδυτικά",
                "ενδιάμεση",
                "κατεύθυνση",
                "πάνω αριστερό βέλος",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("up-left arrow"),
            keywords: &[
                "arrow",
                "direction",
                "intercardinal",
                "northwest",
                "up-left arrow",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("flecha hacia la esquina superior izquierda"),
            keywords: &[
                "arriba",
                "dirección",
                "flecha",
                "flecha hacia la esquina superior izquierda",
                "izquierda",
                "noroeste",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &[
                "arriba",
                "dirección",
                "flecha",
                "flecha hacia el noroeste",
                "flecha hacia la esquina superior izquierda",
                "noroeste",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &[
                "arriba",
                "dirección",
                "flecha",
                "flecha hacia el noroeste",
                "flecha hacia la esquina superior izquierda",
                "noroeste",
            ],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("nool üles vasakule"),
            keywords: &["loe", "nool", "nool üles vasakule", "suund"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("gora eta ezkerrera gezia"),
            keywords: &[
                "gezi",
                "gora eta ezkerrera gezia",
                "ipar-mendebalde",
                "kardinal arteko",
                "norabide",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("پیکان بالا چپ"),
            keywords: &["جهت فرعی", "شمال غربی", "مسیر", "پیکان", "پیکان بالا چپ"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("nuoli ylävasemmalle"),
            keywords: &[
                "ilmansuunta",
                "luode",
                "nuoli",
                "nuoli ylävasemmalle",
                "väli-ilmansuunta",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("pataas na pakaliwang arrow"),
            keywords: &[
                "arrow",
                "direksyon",
                "hilagang-kanluran",
                "intercardinal",
                "pakaliwang",
                "pataas",
                "pataas na pakaliwang arrow",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("pílur sum peikar uppeftir og til vinstru"),
            keywords: &[
                "k´ós",
                "pílur",
                "pílur sum peikar uppeftir og til vinstru",
                "ætt",
                "útnyrðingur",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("flèche haut gauche"),
            keywords: &["direction", "flèche", "flèche haut gauche", "nord-ouest"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("flèche pointant vers le haut à gauche"),
            keywords: &[
                "direction",
                "en haut à gauche",
                "flèche",
                "flèche pointant vers le haut à gauche",
                "nord-ouest",
                "point intercardinal",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("saighead suas ar chlé"),
            keywords: &[
                "idirmheánach",
                "saighead",
                "saighead suas ar chlé",
                "siar ó thuaidh",
                "treo",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("saighead gun iar-thuath"),
            keywords: &[
                "combaist",
                "comhair",
                "iar-thuath",
                "saighead",
                "saighead gun iar-thuath",
                "àirde",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("frecha cara arriba á esquerda"),
            keywords: &[
                "arriba",
                "dirección",
                "frecha",
                "frecha cara arriba á esquerda",
                "noroeste",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ઉપર-ડાબ\u{ac1}\u{a82} તીર"),
            keywords: &["ઉપર-ડાબ\u{ac1}\u{a82} તીર", "પ\u{ac2}ર\u{acd}વપશ\u{acd}ચિમ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("kibiyar sama ta hagu"),
            keywords: &[
                "a ƙetaren tsini shiyya",
                "arewa maso yamma",
                "kibiya",
                "kibiyar sama ta hagu",
                "shiyya",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("חץ למעלה ושמאלה"),
            keywords: &[
                "חץ",
                "חץ למעלה ושמאלה",
                "כיוון",
                "למעלה",
                "צפון-מערב",
                "שמאלה",
            ],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ऊपर-बाया\u{901} तीर"),
            keywords: &[
                "इ\u{902}टरकार\u{94d}डिनल",
                "उत\u{94d}तर-पश\u{94d}चिम दिशा",
                "ऊपर-बाया\u{901} तीर",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("strelica prema gore-lijevo"),
            keywords: &[
                "sjeverozapad",
                "smjer",
                "strelica",
                "strelica prema gore-lijevo",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("balra felfelé mutató nyíl"),
            keywords: &["balra felfelé mutató nyíl", "irány", "nyíl", "északnyugat"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("վերև ձախ սլաք"),
            keywords: &["հյուսիս-արևմուտք", "ուղղություն", "սլաք", "վերև ձախ սլաք"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("tanda panah kiri atas"),
            keywords: &[
                "arah",
                "barat laut",
                "interkardinal",
                "panah",
                "tanda panah kiri atas",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ube akaekpe-dị elu"),
            keywords: &[
                "intakadịnal",
                "nduzi",
                "ube",
                "ube akaekpe-dị elu",
                "ugwuọdịda anyanwụ",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("ör ská upp til vinstri"),
            keywords: &["norðvestur", "átt", "ör", "ör ská upp til vinstri"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("freccia in alto a sinistra"),
            keywords: &[
                "direzione",
                "freccia",
                "freccia in alto a sinistra",
                "nord-ovest",
                "punto intercardinale",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("左上矢印"),
            keywords: &["北西", "左上", "左上矢印", "矢印"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("panah munggah-ngiwa"),
            keywords: &[
                "arah",
                "interkardinal",
                "kulon-lor",
                "panah",
                "panah munggah-ngiwa",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ისარი ზემოთ და მარცხნივ"),
            keywords: &[
                "ინტერკარდინალური",
                "ისარი",
                "ისარი ზემოთ და მარცხნივ",
                "კარდინალური",
                "მიმართულება",
                "ჩრდილო-დასავლეთი",
            ],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("aneccab asawen azelmaḍ"),
            keywords: &["aneccab asawen azelmaḍ"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("жоғарғы сол жақ көрсеткісі"),
            keywords: &[
                "бағыт",
                "жоғарғы сол жақ көрсеткісі",
                "көрсеткі",
                "румба аралық",
                "солтүстік-батыс",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("opadvendt pil mod venstre"),
            keywords: &["nordvest", "opadvendt pil mod venstre", "pil", "retning"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some(
                "ព\u{17d2}រ\u{17bd}ញទៅលើងាកទៅឆ\u{17d2}វេងក\u{17d2}ន\u{17bb}ងរាងប\u{17bd}នជ\u{17d2}រ\u{17bb}ង",
            ),
            keywords: &[
                "ទ\u{17b7}ស",
                "ទ\u{17b7}សដៅ",
                "ព\u{17d2}រ\u{17bd}ញ",
                "ព\u{17d2}រ\u{17bd}ញទៅលើងាកទៅឆ\u{17d2}វេងក\u{17d2}ន\u{17bb}ងរាងប\u{17bd}នជ\u{17d2}រ\u{17bb}ង",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಮೇಲ\u{cbf}ನ ಎಡ ಬಾಣ"),
            keywords: &[
                "ಇಂಟರ\u{ccd}ಕಾರ\u{ccd}ಡ\u{cbf}ನಲ\u{ccd}",
                "ನ\u{cbf}ರ\u{ccd}ದೇಶನ",
                "ಬಾಣ",
                "ಮೇಲ\u{cbf}ನ ಎಡ ಬಾಣ",
                "ವಾಯುವ\u{ccd}ಯ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("좌상향 화살표"),
            keywords: &["북서쪽", "좌상향 화살표", "화살표"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("वयर-दावो बाण"),
            keywords: &["उपदिशा", "दिशा", "बाण", "वयर-दावो बाण", "वायव\u{94d}य"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("өйдө сол жакты караган жебе"),
            keywords: &[
                "багыт",
                "жебе",
                "түндүк-батыш",
                "өйдө сол жакты караган жебе",
            ],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Feil no uewen a lénks"),
            keywords: &[
                "Feil",
                "Feil no uewen a lénks",
                "Himmelsrichtung",
                "Nordwesten",
                "Richtung",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ລ\u{eb9}ກສອນຂ\u{eb6}\u{ec9}ນມ\u{eb8}ມຊ\u{ec9}າຍ"),
            keywords: &[
                "ຂ\u{eb6}\u{ec9}ນ",
                "ທ\u{eb4}ທາງ",
                "ມ\u{eb8}ມຊ\u{ec9}າຍ",
                "ລ\u{eb9}ກສອນ",
                "ລ\u{eb9}ກສອນຂ\u{eb6}\u{ec9}ນມ\u{eb8}ມຊ\u{ec9}າຍ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("rodyklė į viršų ir į kairę"),
            keywords: &[
                "kryptis",
                "rodyklė",
                "rodyklė į viršų ir į kairę",
                "šiaurės vakarai",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("uz augšējo kreiso stūri vērsta bultiņa"),
            keywords: &[
                "bultiņa",
                "norāde",
                "uz augšējo kreiso stūri vērsta bultiņa",
                "ziemeļrietumi",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pere ake-mauī"),
            keywords: &[
                "ahunga",
                "pere",
                "pere ake-mauī",
                "uru-mā-raki",
                "waenga-matua",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("стрелка нагоре лево"),
            keywords: &["лево", "северозапад", "стрелка", "стрелка нагоре лево"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("മ\u{d41}കളിൽ ഇടത\u{d4d}തേക\u{d4d}ക\u{d41}ള\u{d4d}ള അമ\u{d4d}പടയ\u{d3e}ളം"),
            keywords: &[
                "അമ\u{d4d}പടയ\u{d3e}ളം",
                "ഇന\u{d4d}റർക\u{d3e}ർഡിനൽ",
                "ദിശ",
                "മ\u{d41}കളിൽ ഇടത\u{d4d}തേക\u{d4d}ക\u{d41}ള\u{d4d}ള അമ\u{d4d}പടയ\u{d3e}ളം",
                "വടക\u{d4d}ക\u{d4d} പടിഞ\u{d4d}ഞ\u{d3e}റൻ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("зүүн дээшээ сум"),
            keywords: &["баруун хойд", "зүүн дээшээ сум", "сум", "чиглэл"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("वर-डावीकड\u{947} दर\u{94d}शविणारा बाण"),
            keywords: &[
                "अ\u{902}तर\u{94d}गत महत\u{94d}वाच\u{947}",
                "दक\u{94d}षिणपश\u{94d}चिम",
                "दिशा",
                "बाण",
                "वर-डावीकड\u{947} दर\u{94d}शविणारा बाण",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("anak panah ke penjuru kiri atas"),
            keywords: &[
                "anak panah",
                "anak panah ke penjuru kiri atas",
                "antara kardinal",
                "arah",
                "barat laut",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("vleġġa xellugija ’l fuq"),
            keywords: &[
                "direzzjoni",
                "interkardinal",
                "majjistral",
                "vleġġa",
                "vleġġa xellugija ’l fuq",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဘယ\u{103a}ဘက\u{103a}အပေါ\u{103a}ည\u{103d}\u{103e}န\u{103a} မြား"),
            keywords: &[
                "ဘယ\u{103a}ဘက\u{103a}အပေါ\u{103a}ည\u{103d}\u{103e}န\u{103a} မြား",
                "ဘယ\u{103a}ဘက\u{103a}အပေါ\u{103a}ည\u{103d}\u{103e}န\u{103a}မြား",
                "မြား",
                "လမ\u{103a}းည\u{103d}\u{103e}န\u{103a}",
                "အနောက\u{103a}မြောက\u{103a}",
                "အရပ\u{103a}မျက\u{103a}န\u{103e}ာ န\u{103e}စ\u{103a}ခ\u{102f}ကြားပြ သင\u{103a}\u{1039}ကေတ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("pil opp-venstre"),
            keywords: &["nordvest", "pil", "pil opp-venstre", "retning"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("माथि बायातर\u{94d}फको तीर"),
            keywords: &[
                "इन\u{94d}टरकार\u{94d}डिनल",
                "उत\u{94d}तर पश\u{94d}चिम",
                "तीर",
                "दिशा",
                "माथि बायातर\u{94d}फको तीर",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("pijl linksomhoog"),
            keywords: &[
                "noordwest",
                "pijl",
                "pijl linksomhoog",
                "richting",
                "windrichting",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("pil opp-venstre"),
            keywords: &["nordvest", "pil", "pil opp-venstre", "retning"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଉପର-ବ\u{b3e}ମ ତୀର"),
            keywords: &[
                "ଅନ\u{b4d}ତଃପ\u{b4d}ରଧ\u{b3e}ନ",
                "ଉତ\u{b4d}ତରପଶ\u{b4d}ଚ\u{b3f}ମ",
                "ଉପର-ବ\u{b3e}ମ ତୀର",
                "ତୀର",
                "ଦ\u{b3f}ଗ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਉ\u{a71}ਪਰ-ਖ\u{a71}ਬ\u{a47} ਤੀਰ"),
            keywords: &[
                "ਇ\u{a70}ਟਰਕਾਰੀਡਨਮਲ",
                "ਉ\u{a71}ਤਰ-ਪ\u{a71}ਛਮ",
                "ਉ\u{a71}ਪਰ-ਖ\u{a71}ਬ\u{a47} ਤੀਰ",
                "ਤੀਰ",
                "ਦਿਸ\u{a3c}ਾ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ا\u{64f}وتلا-کھبا تیر"),
            keywords: &[
                "انٹر کارڈینل",
                "ا\u{64f}وتلا-کھبا تیر",
                "تیر",
                "سمت",
                "شمال مغرب",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Áro De Pọínt Ọ\u{301}p-Lẹft"),
            keywords: &[
                "Dairẹ\u{301}kshọn",
                "Kádínal",
                "Nọ\u{301}twẹst",
                "Áro",
                "Áro De Pọínt Ọ\u{301}p-Lẹft",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("strzałka w górę w lewo"),
            keywords: &[
                "kierunek",
                "północny zachód",
                "strzałka",
                "strzałka do góry w lewo",
                "strzałka w górę w lewo",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("پورته چپ غشی"),
            keywords: &["انټر کارډينل", "اړخ", "سويلي ختيځ", "غشی", "پورته چپ غشی"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("seta para cima e para a esquerda"),
            keywords: &[
                "direção",
                "intercardinal",
                "noroeste",
                "seta",
                "seta para cima e para a esquerda",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("seta para cima e para a esquerda"),
            keywords: &[
                "direção",
                "intermédio",
                "noroeste",
                "seta",
                "seta para cima e para a esquerda",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("hanaq lluq’i wach’i"),
            keywords: &["hanaq lluq’i wach’i"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("săgeată orientată în stânga-sus"),
            keywords: &[
                "direcție",
                "intercardinal",
                "nord-vest",
                "săgeată",
                "săgeată orientată în stânga-sus",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-008"),
            keywords: &["E10-008"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("стрелка влево-вверх"),
            keywords: &["влево-вверх", "направление", "северо-запад", "стрелка"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umwambi wo hejuru ugana ibumoso"),
            keywords: &[
                "amajyaruguru ashyira iburengerazuba",
                "icyerekezo",
                "kiri hagati y’ibyerekezo bine",
                "umwambi",
                "umwambi wo hejuru ugana ibumoso",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("مٿ کاٻي طرف تير"),
            keywords: &["اتر اولھ", "انٽرڪارڊينل", "تير", "طرف", "مٿ کاٻي طرف تير"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("උඩ\u{dd4}-වම\u{dca} ඊතලය"),
            keywords: &[
                "ඉන\u{dca}ටර\u{dca}ක\u{dcf}ඩ\u{dd2}නල\u{dca}",
                "ඊතලය",
                "උඩ\u{dd4}-වම\u{dca} ඊතලය",
                "ද\u{dd2}ශ\u{dcf}ව",
                "වයඹ",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("šípka doľava nahor"),
            keywords: &["doľava nahor", "severozápad", "šípka", "šípka doľava nahor"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("puščica levo gor"),
            keywords: &[
                "puščica",
                "puščica levo gor",
                "severozahodno",
                "smer",
                "stransko",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("fallaarta kor ee bidix"),
            keywords: &[
                "fallaar",
                "fallaarta kor ee bidix",
                "isdhaafsiga jihooyinka",
                "jihada",
                "waqooyi galbeed",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("shigjeta lart-majtas"),
            keywords: &[
                "drejtim",
                "i ndërmjetëm",
                "shigjeta lart-majtas",
                "shigjetë",
                "veriperëndim",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("стрелица нагоре и налево"),
            keywords: &[
                "сeвeрoзaпaд",
                "смер",
                "стрeлицa",
                "стрелица нагоре и налево",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("стрелица нагоре и налијево"),
            keywords: &["стрелица нагоре и налијево"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("strelica nagore i nalevo"),
            keywords: &[
                "severozapad",
                "smer",
                "strelica",
                "strelica nagore i nalevo",
            ],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("strelica nagore i nalijevo"),
            keywords: &["strelica nagore i nalijevo"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("uppåtpil vänster"),
            keywords: &["pil", "uppåt", "uppåtpil vänster", "vänster"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mshale unaoelekeza juu kushoto"),
            keywords: &[
                "kaskazini magharibi",
                "kati ya sehemu kuu ya dira",
                "mshale",
                "mshale unaoelekeza juu kushoto",
                "uelekeo",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("மேல\u{bcd}-இடது நோக\u{bcd}கிய அம\u{bcd}புக\u{bcd}குறி"),
            keywords: &[
                "திசை",
                "மேல\u{bcd}-இடது நோக\u{bcd}கிய அம\u{bcd}புக\u{bcd}குறி",
                "வடமேற\u{bcd}கு",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ఎగువ ఎడమ బ\u{c3e}ణం"),
            keywords: &[
                "ఎగువ ఎడమ బ\u{c3e}ణం",
                "ద\u{c3f}శ",
                "బ\u{c3e}ణం",
                "వ\u{c3e}యువ\u{c4d}యం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("тири болову чап"),
            keywords: &["мобайнӣ", "самт", "тир", "тири болову чап", "шимолу ғарб"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ล\u{e39}กศรช\u{e35}\u{e49}ม\u{e38}มซ\u{e49}ายบน"),
            keywords: &[
                "ตะว\u{e31}นตกเฉ\u{e35}ยงเหน\u{e37}อ",
                "ท\u{e34}ศทาง",
                "ล\u{e39}กศร",
                "ล\u{e39}กศรช\u{e35}\u{e49}ม\u{e38}มซ\u{e49}ายบน",
            ],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ምልክት ናብ-ጸጋማይ ላዕሊ"),
            keywords: &[
                "ምልክት",
                "ምልክት ናብ-ጸጋማይ ላዕሊ",
                "ሰሜናዊ ምዕራብ",
                "ኣንፈት",
                "ውሽጣዊ ናይ ካርዲናል",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ýokary-çepe ok"),
            keywords: &[
                "demirgazyk-günbatar",
                "gytak",
                "ok",
                "ugur",
                "ýokary-çepe ok",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("ngahau ki ʻolunga toʻohema"),
            keywords: &["hema", "ngahau", "ngahau ki ʻolunga toʻohema", "ʻolunga"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("sol yukarı ok"),
            keywords: &["ara yön", "kuzey batı", "ok", "sol yukarı ok", "yön"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئۈستى سول كۆرسەتكۈچ"),
            keywords: &[
                "ئارا يۆنىلىشلىك",
                "ئۈستى سول كۆرسەتكۈچ",
                "غەربىي-شىمال",
                "كۆرسەتكۈچ",
                "يۆنىلىش",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("стрілка вгору вліво"),
            keywords: &[
                "напрям",
                "проміжний",
                "північно-західний",
                "стрілка вгору вліво",
                "стрілка вгору та ліворуч",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("اوپر بائیں تیر"),
            keywords: &["اوپر بائیں تیر", "تیر", "سائن", "سمت", "شمال مغرب"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("chap yuqoriga strelka"),
            keywords: &[
                "chap yuqoriga strelka",
                "chiziq",
                "shimoli-g‘arb",
                "yo‘nalish",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("mũi tên lên bên trái"),
            keywords: &[
                "hướng",
                "mũi tên",
                "mũi tên lên bên trái",
                "nhiều hướng",
                "tây bắc",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("fettu càmmoñu-kaw"),
            keywords: &[
                "direction",
                "fett",
                "fettu càmmoñu-kaw",
                "interkàrdinal",
                "sowwu-gànnaar",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("utolo olusekhohlo phezulu"),
            keywords: &[
                "entshona mntla",
                "ukhardinale ohlangeneyo",
                "ulwalathiso",
                "utolo",
                "utolo olusekhohlo phezulu",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("àmì òkè ìtó\u{329}sọ\u{301}nà o\u{329}lọ\u{301}fà apá òsì"),
            keywords: &[
                "iwọ\u{300} oòrùn àríwá",
                "àmì ìtó\u{329}sọ\u{301}nà o\u{329}lọ\u{301}fà",
                "àmì òkè ìtó\u{329}sọ\u{301}nà o\u{329}lọ\u{301}fà apá òsì",
                "ìlọ\u{301}pọ\u{300} kádínàlì",
                "ìtọ\u{301}sọ\u{301}nà",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("向左上箭咀"),
            keywords: &["向左上箭咀", "基點間", "方向", "箭咀", "西北"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("向左上箭咀"),
            keywords: &["向左上箭咀", "基点间", "方向", "箭咀", "西北"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("左上箭头"),
            keywords: &["左上箭头", "方向", "标识", "西北"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("左上箭頭"),
            keywords: &["左上箭頭", "方向"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("上左箭嘴"),
            keywords: &["上左箭嘴", "方向"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("umcibisholo obheke phezulu kwesokunxele"),
            keywords: &[
                "inkomba",
                "inkombakuhlanganisa",
                "inyakathontshonalanga",
                "umcibisholo",
                "umcibisholo obheke phezulu kwesokunxele",
            ],
        },
    ],
};
#[doc = "↕\u{fe0f}"]
pub const UP_DOWN_ARROW: crate::Emoji = crate::Emoji {
    glyph: "↕\u{fe0f}",
    codepoint: "2195 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "up-down arrow",
    group: "Symbols",
    subgroup: "arrow",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "↕",
        codepoint: "2195",
        status: crate::Status::Unqualified,
        introduction_version: 0.6f32,
        name: "up-down arrow",
        group: "Symbols",
        subgroup: "arrow",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("pyl op en af"),
            keywords: &["pyl op en af", "pyle"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ወደ ላይ ታች ጠቋሚ ቀስት"),
            keywords: &["ቀስት", "ወደ ላይ ታች ጠቋሚ ቀስት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("سهم لأعلى وأسفل"),
            keywords: &["سهم", "سهم لأعلى وأسفل"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ঊৰ\u{9cd}ধ\u{9cd}বগ\u{9be}মী-অধোগ\u{9be}মী ক\u{9be}\u{981}ড\u{9bc}"),
            keywords: &[
                "ঊৰ\u{9cd}ধ\u{9cd}বগ\u{9be}মী-অধোগ\u{9be}মী ক\u{9be}\u{981}ড\u{9bc}",
                "ক\u{9be}\u{981}ড\u{9bc}",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("üzü aşağı-yuxarı ox"),
            keywords: &["ox", "üzü aşağı-yuxarı ox"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("стрэлка ўверх-уніз"),
            keywords: &["падвоеная", "стрэлка", "стрэлка ўверх-уніз"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Стрелка нагоре и надолу"),
            keywords: &[
                "Стрелка нагоре и надолу",
                "стрелка",
                "стрелка нагоре и надолу",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("উপরে নীচে তীর"),
            keywords: &["উপরে নীচে তীর", "তীর"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("strelica gore-dolje"),
            keywords: &["strelica", "strelica gore-dolje"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("fletxa cap amunt i cap avall"),
            keywords: &["amunt", "avall", "fletxa", "fletxa cap amunt i cap avall"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎦᎸᎳᏗ - ᎡᎳᏗ ᎦᏝᏗ"),
            keywords: &["ᎦᎸᎳᏗ - ᎡᎳᏗ ᎦᏝᏗ", "ᎦᏝᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("šipka nahoru a dolů"),
            keywords: &["šipka", "šipka nahoru a dolů"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("saeth i fyny-lawr"),
            keywords: &["saeth", "saeth i fyny-lawr"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("op- og nedadvendt pil"),
            keywords: &["op- og nedadvendt pil", "pil"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Pfeil nach oben und unten"),
            keywords: &[
                "Pfeil",
                "Pfeil nach oben und unten",
                "entgegengesetzt",
                "nach oben und unten",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("πάνω κάτω βέλος"),
            keywords: &["βέλος", "πάνω κάτω βέλος"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("up-down arrow"),
            keywords: &["arrow", "up-down arrow"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("flecha arriba y abajo"),
            keywords: &[
                "abajo",
                "arriba",
                "dirección",
                "flecha",
                "flecha arriba y abajo",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["flecha", "flecha arriba y abajo"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("nool üles-alla"),
            keywords: &["nool", "nool üles-alla"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("gora eta behera gezia"),
            keywords: &["gezi", "gora eta behera gezia"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("پیکان بالا و پایین"),
            keywords: &["پیکان", "پیکان بالا و پایین"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("nuoli ylös ja alas"),
            keywords: &["nuoli", "nuoli ylös ja alas", "suunta"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("pataas-pababang arrow"),
            keywords: &["arrow", "pababa", "pataas", "pataas-pababang arrow"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("pílur sum peikar upp og niður"),
            keywords: &["pílur", "pílur sum peikar upp og niður"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("flèche haut bas"),
            keywords: &["flèche", "flèche haut bas"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("flèche pointant vers le haut et vers le bas"),
            keywords: &[
                "bas haut",
                "en bas et en haut",
                "en haut et en bas",
                "flèche",
                "flèche pointant vers le haut et vers le bas",
                "haut bas",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("saighead suas-síos"),
            keywords: &["saighead", "saighead suas-síos"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("saighead suas is sìos"),
            keywords: &["saighead", "saighead suas is sìos"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("frecha cara arriba e abaixo"),
            keywords: &[
                "abaixo",
                "arriba",
                "dirección",
                "frecha",
                "frecha cara arriba e abaixo",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ઉપર-નીચ\u{ac7} તીર"),
            keywords: &["ઉપર-નીચ\u{ac7} તીર", "તીર"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("kibiyar ƙasa ta sama"),
            keywords: &["kibiya", "kibiyar ƙasa ta sama"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("חץ מעלה ומטה"),
            keywords: &["חץ", "חץ מעלה ומטה", "למטה", "למעלה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ऊपर-नीच\u{947} तीर"),
            keywords: &["ऊपर-नीच\u{947} तीर", "तीर"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("strelica gore-dolje"),
            keywords: &["strelica", "strelica gore-dolje"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("fel-le mutató nyíl"),
            keywords: &["fel-le mutató nyíl", "nyíl"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("վերև-ներքև սլաք"),
            keywords: &["սլաք", "վերև-ներքև սլաք"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("tanda panah atas bawah"),
            keywords: &["panah", "tanda panah atas bawah"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ube-dị ala dị elu"),
            keywords: &["ube", "ube-dị ala dị elu"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("ör upp og niður"),
            keywords: &["ör", "ör upp og niður"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("freccia su-giù"),
            keywords: &["altezza", "doppia direzione", "freccia", "freccia su-giù"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("上下矢印"),
            keywords: &["上下", "上下矢印", "矢印"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("panah munggah-mudhun"),
            keywords: &["panah", "panah munggah-mudhun"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ისარი ზემოთ და ქვემოთ"),
            keywords: &["ისარი", "ისარი ზემოთ და ქვემოთ"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("aneccab asawen akesser"),
            keywords: &["aneccab asawen akesser"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("жоғары-төмен көрсеткісі"),
            keywords: &["жоғары-төмен көрсеткісі", "көрсеткі"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("op- og nedadvendt pil"),
            keywords: &["op- og nedadvendt pil", "pil"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some(
                "ព\u{17d2}រ\u{17bd}ញទៅលើទៅក\u{17d2}រោមក\u{17d2}ន\u{17bb}ងរាងប\u{17bd}នជ\u{17d2}រ\u{17bb}ង",
            ),
            keywords: &[
                "ទ\u{17b7}ស",
                "ទ\u{17b7}សដៅ",
                "ព\u{17d2}រ\u{17bd}ញ",
                "ព\u{17d2}រ\u{17bd}ញទៅលើទៅក\u{17d2}រោមក\u{17d2}ន\u{17bb}ងរាងប\u{17bd}នជ\u{17d2}រ\u{17bb}ង",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಮೇಲ\u{cbf}ನ ಕ\u{cc6}ಳ ಬಾಣ"),
            keywords: &["ಬಾಣ", "ಬಾಣದ ಗುರುತು", "ಮೇಲ\u{cbf}ನ ಕ\u{cc6}ಳ ಬಾಣ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("상하향 화살표"),
            keywords: &["상하향 화살표", "위아래", "화살표"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("वयर-सकयल बाण"),
            keywords: &["बाण", "वयर-सकयल बाण"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("өйдө-төмөн караган жебе"),
            keywords: &["жебе", "өйдө-төмөн караган жебе"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Feil no uewen an ënnen"),
            keywords: &["Feil no uewen an ënnen", "Feiler"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ລ\u{eb9}ກສອນຂ\u{eb6}\u{ec9}ນແລະລ\u{ebb}ງ"),
            keywords: &[
                "ຂ\u{eb6}\u{ec9}ນ",
                "ລ\u{eb9}ກສອນ",
                "ລ\u{eb9}ກສອນຂ\u{eb6}\u{ec9}ນແລະລ\u{ebb}ງ",
                "ລ\u{ebb}ງ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("rodyklė į viršų ir į apačią"),
            keywords: &["rodyklė", "rodyklė į viršų ir į apačią"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("augšup un lejup vērsta bultiņa"),
            keywords: &["augšup un lejup vērsta bultiņa", "bultiņa"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pere ake-iho"),
            keywords: &["pere", "pere ake-iho"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("стрелка нагоре-надолу"),
            keywords: &["горе", "долу", "стрелка", "стрелка нагоре-надолу"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some(
                "മ\u{d41}കളിലേക\u{d4d}ക\u{d41}ം ത\u{d3e}ഴേക\u{d4d}ക\u{d41}മ\u{d41}ള\u{d4d}ള അമ\u{d4d}പടയ\u{d3e}ളം",
            ),
            keywords: &[
                "അമ\u{d4d}പടയ\u{d3e}ളം",
                "ത\u{d3e}ഴേക\u{d4d}ക\u{d4d}",
                "മ\u{d41}കളിലേക\u{d4d}ക\u{d41}ം ത\u{d3e}ഴേക\u{d4d}ക\u{d41}മ\u{d41}ള\u{d4d}ള അമ\u{d4d}പടയ\u{d3e}ളം",
                "മ\u{d41}കളിലേക\u{d4d}ക\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("дээш доошоо сум"),
            keywords: &["баруун доошоо сум", "дээш доошоо сум", "сум"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("वर-खाली दर\u{94d}शविणारा बाण"),
            keywords: &["बाण", "वर-खाली दर\u{94d}शविणारा बाण"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("anak panah ke atas ke bawah"),
            keywords: &["anak panah", "anak panah ke atas ke bawah"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("vleġġa ’l isfel u ’l isfel"),
            keywords: &["vleġġa", "vleġġa ’l isfel u ’l isfel"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အပေါ\u{103a}−အောက\u{103a}ပြ မြား"),
            keywords: &[
                "မြား",
                "အပေါ\u{103a} အောက\u{103a} န\u{103e}စ\u{103a}ဘက\u{103a}ပြ မြား သင\u{103a}\u{1039}ကေတ",
                "အပေါ\u{103a}−အောက\u{103a}ပြ မြား",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("pil opp og ned"),
            keywords: &["pil", "pil opp og ned"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("माथि-तल वाण"),
            keywords: &["माथि-तल वाण", "वाण"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("pijl omhoog en omlaag"),
            keywords: &["pijl", "pijl omhoog en omlaag"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("pil opp og ned"),
            keywords: &["pil", "pil opp og ned"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଉପର-ତଳ ତୀର"),
            keywords: &["ଉପର-ତଳ ତୀର", "ତୀର"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਉ\u{a71}ਪਰ-ਥ\u{a71}ਲ\u{a47} ਤੀਰ"),
            keywords: &["ਉ\u{a71}ਪਰ-ਥ\u{a71}ਲ\u{a47} ਤੀਰ", "ਤੀਰ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ا\u{64f}وتلا-ہیٹھلا تیر"),
            keywords: &["ا\u{64f}وتلا-ہیٹھلا تیر", "تیر"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Áro De Pọínt Ọ\u{301}p An Daun"),
            keywords: &["Áro", "Áro De Pọínt Ọ\u{301}p An Daun"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("strzałka w górę i w dół"),
            keywords: &[
                "dwukierunkowa",
                "góra-dół",
                "strzałka do góry i na dół",
                "strzałka w górę i w dół",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("پورته ښکته غشی"),
            keywords: &["غشی", "پورته ښکته غشی"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("seta para cima e para baixo"),
            keywords: &[
                "para baixo",
                "para cima",
                "seta",
                "seta para cima e para baixo",
                "vertical",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &[
                "para baixo",
                "para cima",
                "seta",
                "seta para cima e para baixo",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("hanaq uran wach’i"),
            keywords: &["hanaq uran wach’i"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("săgeată sus-jos"),
            keywords: &["săgeată", "săgeată sus-jos"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-007"),
            keywords: &["E10-007"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("стрелка вверх-вниз"),
            keywords: &[
                "вверх и вниз",
                "вверх-вниз",
                "двойная",
                "стрелка",
                "стрелка вверх вниз",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("akambi kazamuka-kamanuka"),
            keywords: &["akambi kazamuka-kamanuka", "umwambi"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("مٿي هيٺ طرف تير"),
            keywords: &["تير", "مٿي هيٺ طرف تير"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("උඩ\u{dd4}-යට\u{dd2} ඊතලය"),
            keywords: &["ඊතලය", "උඩ\u{dd4}-යට\u{dd2} ඊතලය"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("šípka nahor aj nadol"),
            keywords: &["šípka", "šípka nahor aj nadol"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("puščica gor dol"),
            keywords: &["puščica", "puščica gor dol"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("fallaarta kor-hoose"),
            keywords: &["fallaar", "fallaarta kor-hoose"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("shigjeta lart-poshtë"),
            keywords: &["shigjeta lart-poshtë", "shigjetë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("стрелица нагоре и надоле"),
            keywords: &["стрeлицa", "стрелица нагоре и надоле"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("стрелица нагоре и надоље"),
            keywords: &["стрелица нагоре и надоље"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("strelica nagore i nadole"),
            keywords: &["strelica", "strelica nagore i nadole"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("strelica nagore i nadolje"),
            keywords: &["strelica nagore i nadolje"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("pil upp och ned"),
            keywords: &["nedåt", "pil", "pil upp och ned", "uppåt"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mshale unaoelekeza chini na juu"),
            keywords: &["mshale", "mshale unaoelekeza chini na juu"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("மேல\u{bcd}-க\u{bc0}ழ\u{bcd} நோக\u{bcd}கிய அம\u{bcd}புக\u{bcd}குறி"),
            keywords: &[
                "அம\u{bcd}புக\u{bcd}குறி",
                "மேல\u{bcd}-க\u{bc0}ழ\u{bcd} நோக\u{bcd}கிய அம\u{bcd}புக\u{bcd}குறி",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ఎగువ మర\u{c3f}యు ద\u{c3f}గువ బ\u{c3e}ణం"),
            keywords: &[
                "ఎగువ",
                "ఎగువ మర\u{c3f}యు ద\u{c3f}గువ బ\u{c3e}ణం",
                "ద\u{c3f}గువ",
                "బ\u{c3e}ణం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("тири поёну боло"),
            keywords: &["тир", "тири поёну боло"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ล\u{e39}กศรช\u{e35}\u{e49}ข\u{e36}\u{e49}นลง"),
            keywords: &[
                "ข\u{e35}\u{e49}น",
                "ลง",
                "ล\u{e39}กศร",
                "ล\u{e39}กศรช\u{e35}\u{e49}ข\u{e36}\u{e49}นลง",
            ],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ምልክት ናብ-ላዕሊ ታሕቲ"),
            keywords: &["ምልክት", "ምልክት ናብ-ላዕሊ ታሕቲ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ýokary-aşak ok"),
            keywords: &["ok", "ýokary-aşak ok"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("ngahau ki ʻolunga mo lalo"),
            keywords: &[
                "hake",
                "hifo",
                "lalo",
                "ngahau",
                "ngahau ki ʻolunga mo lalo",
                "ʻolunga",
            ],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("yukarı ve aşağı ok"),
            keywords: &["ok", "yukarı ve aşağı ok"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئاستى-ئۈستى كۆرسەتكۈچ"),
            keywords: &["ئاستى-ئۈستى كۆرسەتكۈچ", "كۆرسەتكۈچ"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("стрілка вгору-вниз"),
            keywords: &["стрілка", "стрілка вгору та вниз", "стрілка вгору-вниз"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("اوپر نیچے تیر"),
            keywords: &["اوپر نیچے تیر", "تیر", "سائن", "سمت"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("tepa-pastga strelka"),
            keywords: &["strelka", "tepa-pastga strelka"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("mũi tên lên xuống"),
            keywords: &["mũi tên", "mũi tên lên xuống"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("fettu suufu-kaw"),
            keywords: &["fett", "fettu suufu-kaw"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("utolo olusezantsi phezulu"),
            keywords: &["utolo", "utolo olusezantsi phezulu"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("ọfà tòkètilẹ\u{300}"),
            keywords: &["ọfà", "ọfà tòkètilẹ\u{300}"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("上下箭咀"),
            keywords: &["上下箭咀", "箭咀"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("上下箭咀"),
            keywords: &["上下箭咀", "箭咀"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("上下箭头"),
            keywords: &["上下", "上下箭头", "箭头"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("上下箭頭"),
            keywords: &["上下箭頭"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("上下箭嘴"),
            keywords: &["上下箭嘴"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("umcibisholo ophansi phezulu"),
            keywords: &["umcibisholo", "umcibisholo ophansi phezulu"],
        },
    ],
};
#[doc = "↔\u{fe0f}"]
pub const LEFT_RIGHT_ARROW: crate::Emoji = crate::Emoji {
    glyph: "↔\u{fe0f}",
    codepoint: "2194 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "left-right arrow",
    group: "Symbols",
    subgroup: "arrow",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "↔",
        codepoint: "2194",
        status: crate::Status::Unqualified,
        introduction_version: 0.6f32,
        name: "left-right arrow",
        group: "Symbols",
        subgroup: "arrow",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("pyl links en regs"),
            keywords: &["pyl links en regs", "pyle"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ግራ-ቀኝ ጠቋሚ ቀስት"),
            keywords: &["ቀስት", "ግራ-ቀኝ ጠቋሚ ቀስት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("سهم لليسار واليمين"),
            keywords: &["سهم", "سهم لليسار واليمين"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ব\u{9be}ও\u{981}ম\u{9c1}খী-সো\u{981}ম\u{9c1}খী ক\u{9be}\u{981}ড\u{9bc}"),
            keywords: &[
                "ক\u{9be}\u{981}ড\u{9bc}",
                "ব\u{9be}ও\u{981}ম\u{9c1}খী-সো\u{981}ম\u{9c1}খী ক\u{9be}\u{981}ড\u{9bc}",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("sola-sağa ox"),
            keywords: &["ox", "sola-sağa ox"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("стрэлка ўлева-ўправа"),
            keywords: &["падвоеная", "стрэлка", "стрэлка ўлева-ўправа"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("стрелка наляво и надясно"),
            keywords: &["стрелка", "стрелка наляво и надясно"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ব\u{9be}মে-ড\u{9be}নে তীর"),
            keywords: &["তীর", "ব\u{9be}মে-ড\u{9be}নে তীর"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("strelica lijevo-desno"),
            keywords: &["strelica", "strelica lijevo-desno"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("fletxa cap a l’esquerra i cap a la dreta"),
            keywords: &[
                "dreta",
                "esquerra",
                "fletxa",
                "fletxa cap a l’esquerra i cap a la dreta",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᎦᏍᎦᏂ - ᎦᏘᏏ ᎦᏝᏗ"),
            keywords: &["ᎠᎦᏍᎦᏂ - ᎦᏘᏏ ᎦᏝᏗ", "ᎦᏝᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("šipka doleva a doprava"),
            keywords: &["šipka", "šipka doleva a doprava"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("saeth chwith-dde"),
            keywords: &["saeth", "saeth chwith-dde"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("pil mod venstre og højre"),
            keywords: &["pil", "pil mod venstre og højre"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Pfeil nach links und rechts"),
            keywords: &[
                "Pfeil",
                "Pfeil nach links und rechts",
                "entgegengesetzt",
                "nach links und rechts",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("αριστερό δεξιό βέλος"),
            keywords: &["αριστερό δεξιό βέλος", "βέλος"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("left-right arrow"),
            keywords: &["arrow", "left-right arrow"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("flecha izquierda y derecha"),
            keywords: &[
                "derecha",
                "dirección",
                "flecha",
                "flecha izquierda y derecha",
                "izquierda",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["flecha", "flecha izquierda y derecha"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("nool paremale-vasakule"),
            keywords: &["nool", "nool paremale-vasakule"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("ezkerrera eta eskuinera gezia"),
            keywords: &["ezkerrera eta eskuinera gezia", "gezi"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("پیکان دوطرفه"),
            keywords: &["پیکان", "پیکان دوطرفه"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("nuoli oikealle ja vasemmalle"),
            keywords: &["nuoli", "nuoli oikealle ja vasemmalle", "suunta"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("pakaliwa-pakanang arrow"),
            keywords: &["arrow", "pakaliwa", "pakaliwa-pakanang arrow", "pakanan"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("pílur sum peikar til høgru og vinstu"),
            keywords: &["pílur", "pílur sum peikar til høgru og vinstu"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("flèche gauche droite"),
            keywords: &["flèche", "flèche gauche droite"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("flèche pointant à gauche et à droite"),
            keywords: &[
                "droite gauche",
                "flèche",
                "flèche pointant à gauche et à droite",
                "gauche droite",
                "à droite et à gauche",
                "à gauche et à droite",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("saighead chlé-dheas"),
            keywords: &["saighead", "saighead chlé-dheas"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("saighead chlì is dheas"),
            keywords: &["saighead", "saighead chlì is dheas"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("frecha cara á esquerda e a dereita"),
            keywords: &[
                "dereita",
                "dirección",
                "esquerda",
                "frecha",
                "frecha cara á esquerda e a dereita",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ડાબ\u{ac1}\u{a82}-જમણ\u{ac1}\u{a82} તીર"),
            keywords: &["ડાબ\u{ac1}\u{a82}-જમણ\u{ac1}\u{a82} તીર", "તીર"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("kibiyar dama ta dama"),
            keywords: &["kibiya", "kibiyar dama ta dama"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("חץ שמאלה וימינה"),
            keywords: &["חץ", "חץ שמאלה וימינה", "ימינה", "שמאלה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("बाए\u{901}-दाए\u{901} तीर"),
            keywords: &["तीर", "बाए\u{901}-दाए\u{901} तीर"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("strelica lijevo-desno"),
            keywords: &["strelica", "strelica lijevo-desno"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("balra-jobbra mutató nyíl"),
            keywords: &["balra-jobbra mutató nyíl", "nyíl"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ձախ-աջ սլաք"),
            keywords: &["աջ-ձախ սլաք", "ձախ-աջ սլաք", "սլաք"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("tanda panah kiri kanan"),
            keywords: &["panah", "tanda panah kiri kanan"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ube-akanri akaekpe"),
            keywords: &["ube", "ube-akanri akaekpe"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("ör til vinstri og hægri"),
            keywords: &["ör", "ör til vinstri og hægri"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("freccia sinistra-destra"),
            keywords: &[
                "destra",
                "doppia direzione",
                "freccia",
                "freccia sinistra-destra",
                "larghezza",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("左右矢印"),
            keywords: &["左右", "左右矢印", "矢印"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("panah ngiwa-nengen"),
            keywords: &["panah", "panah ngiwa-nengen"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ისარი მარცხნივ და მარჯვნივ"),
            keywords: &["ისარი", "ისარი მარცხნივ და მარჯვნივ"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("aneccab azelmaḍ ayeffus"),
            keywords: &["aneccab azelmaḍ ayeffus"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("сол-оң көрсеткісі"),
            keywords: &["көрсеткі", "сол-оң көрсеткісі"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("pil mod venstre og højre"),
            keywords: &["pil", "pil mod venstre og højre"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some(
                "ព\u{17d2}រ\u{17bd}ញទៅឆ\u{17d2}វេងទៅស\u{17d2}តា\u{17c6}ក\u{17d2}ន\u{17bb}ងរាងប\u{17bd}នជ\u{17d2}រ\u{17bb}ង",
            ),
            keywords: &[
                "ទ\u{17b7}ស",
                "ទ\u{17b7}សដៅ",
                "ព\u{17d2}រ\u{17bd}ញ",
                "ព\u{17d2}រ\u{17bd}ញទៅឆ\u{17d2}វេងទៅស\u{17d2}តា\u{17c6}ក\u{17d2}ន\u{17bb}ងរាងប\u{17bd}នជ\u{17d2}រ\u{17bb}ង",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಎಡ-ಬಲ ಬಾಣ"),
            keywords: &["ಎಡ-ಬಲ ಬಾಣ", "ಎಡ-ಬಲ ಬಾಣದ ಗುರುತು"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("좌우향 화살표"),
            keywords: &["좌우", "좌우향 화살표", "화살표"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("दावो - उजवो बाण"),
            keywords: &["दावो - उजवो बाण", "बाण"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("оңго-солго караган жебе"),
            keywords: &["жебе", "оңго-солго караган жебе"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Feil no lénks a riets"),
            keywords: &["Feil no lénks a riets", "Feiler"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ລ\u{eb9}ກສອນຊ\u{ec9}າຍຂວາ"),
            keywords: &[
                "ຂວາ",
                "ຊ\u{ec9}າຍ",
                "ລ\u{eb9}ກສອນ",
                "ລ\u{eb9}ກສອນຊ\u{ec9}າຍຂວາ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("rodyklė į kairę ir į dešinę"),
            keywords: &["rodyklė", "rodyklė į kairę ir į dešinę"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("pa kreisi un pa labi vērsta bultiņa"),
            keywords: &["bultiņa", "pa kreisi un pa labi vērsta bultiņa"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pere mauī-matau"),
            keywords: &["pere", "pere mauī-matau"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("стрелка налево-надесно"),
            keywords: &["десно", "лево", "стрелка", "стрелка налево-надесно"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some(
                "ഇടത\u{d4d}തോട\u{d4d}ട\u{d41}ം വലത\u{d4d}തോട\u{d4d}ട\u{d41}മ\u{d41}ള\u{d4d}ള അമ\u{d4d}പടയ\u{d3e}ളം",
            ),
            keywords: &[
                "അമ\u{d4d}പടയ\u{d3e}ളം",
                "ഇടത\u{d4d}",
                "ഇടത\u{d4d}തോട\u{d4d}ട\u{d41}ം വലത\u{d4d}തോട\u{d4d}ട\u{d41}മ\u{d41}ള\u{d4d}ള അമ\u{d4d}പടയ\u{d3e}ളം",
                "വലത\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("зүүн-баруун сум"),
            keywords: &["зүүн-баруун сум", "сум"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("डावा-उजवा दर\u{94d}शविणारा बाण"),
            keywords: &["डावा-उजवा दर\u{94d}शविणारा बाण", "बाण"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("anak panah ke kiri ke kanan"),
            keywords: &["anak panah", "anak panah ke kiri ke kanan"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("vleġġa ’l isfel xellugija"),
            keywords: &["vleġġa", "vleġġa ’l isfel xellugija"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဘယ\u{103a}−ညာပြ မြား"),
            keywords: &["ဘယ\u{103a}−ညာ မြား", "ဘယ\u{103a}−ညာပြ မြား", "မြား"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("pil venstre-høyre"),
            keywords: &["pil", "pil venstre-høyre"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("बाया\u{901}-दाया\u{901} वाण"),
            keywords: &["बाया\u{901}-दाया\u{901} वाण", "वाण"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("pijl naar links en rechts"),
            keywords: &["pijl", "pijl naar links en rechts"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("pil venstre-høgre"),
            keywords: &["pil", "pil venstre-høgre"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ବ\u{b3e}ମ-ଡ\u{b3e}ହ\u{b3e}ଣ ତୀର"),
            keywords: &["ତୀର", "ବ\u{b3e}ମ-ଡ\u{b3e}ହ\u{b3e}ଣ ତୀର"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਖ\u{a71}\u{a71}ਬ\u{a47}-ਸ\u{a71}ਜ\u{a47} ਤੀਰ"),
            keywords: &["ਖ\u{a71}\u{a71}ਬ\u{a47}-ਸ\u{a71}ਜ\u{a47} ਤੀਰ", "ਤੀਰ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("کھبا-سجا تیر"),
            keywords: &["تیر", "کھبا-سجا تیر"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Áro De Pọínt Lẹ\u{301}ft An Rait"),
            keywords: &["Áro", "Áro De Pọínt Lẹ\u{301}ft An Rait"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("strzałka w lewo i w prawo"),
            keywords: &[
                "dwukierunkowa",
                "lewo-prawo",
                "na boki",
                "strzałka w lewo i w prawo",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ښۍ چپ غشی"),
            keywords: &["غشی", "ښۍ چپ غشی"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("seta para esquerda e direita"),
            keywords: &[
                "horizontal",
                "lados",
                "seta",
                "seta para esquerda e direita",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("seta para a esquerda e para a direita"),
            keywords: &[
                "direita",
                "esquerda",
                "seta",
                "seta para a esquerda e para a direita",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("lluq’i paña wach’i"),
            keywords: &["lluq’i paña wach’i"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("săgeată dreapta-stânga"),
            keywords: &["săgeată", "săgeată dreapta-stânga"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-006"),
            keywords: &["E10-006"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("стрелка влево-вправо"),
            keywords: &[
                "влево и вправо",
                "влево-вправо",
                "двойная",
                "стрелка",
                "стрелка влево вправо",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("akambi kava ibumoso kajya iburyo"),
            keywords: &["akambi kava ibumoso kajya iburyo", "umwambi"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ساڄي کاٻي پاسي تير"),
            keywords: &["تير", "ساڄي کاٻي پاسي تير"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("වම\u{dca}-දක\u{dd4}ණ\u{dd4} ඊතලය"),
            keywords: &["ඊතලය", "වම\u{dca}-දක\u{dd4}ණ\u{dd4} ඊතලය"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("šípka doprava aj doľava"),
            keywords: &["šípka", "šípka doprava aj doľava"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("puščica levo desno"),
            keywords: &["puščica", "puščica levo desno"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("fallaarta bidix-midig"),
            keywords: &["fallaar", "fallaarta bidix-midig"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("shigjetë majtas-djathtas"),
            keywords: &["shigjetë", "shigjetë majtas-djathtas"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("стрелица налево и надесно"),
            keywords: &["стрeлицa", "стрелица налево и надесно"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("стрелица налијево и надесно"),
            keywords: &["стрелица налијево и надесно"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("strelica nalevo i nadesno"),
            keywords: &["strelica", "strelica nalevo i nadesno"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("strelica nalijevo i nadesno"),
            keywords: &["strelica nalijevo i nadesno"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("pil höger och vänster"),
            keywords: &["höger", "pil", "pil höger och vänster", "vänster"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mshale unaoeleza kushoto na kulia"),
            keywords: &["mshale", "mshale unaoeleza kushoto na kulia"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("இடது-வலது நோக\u{bcd}கிய அம\u{bcd}புக\u{bcd}குறி"),
            keywords: &[
                "அம\u{bcd}புக\u{bcd}குறி",
                "இடது-வலது நோக\u{bcd}கிய அம\u{bcd}புக\u{bcd}குறி",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ఎడమ మర\u{c3f}యు కుడ\u{c3f} బ\u{c3e}ణం"),
            keywords: &[
                "ఎడమ",
                "ఎడమ మర\u{c3f}యు కుడ\u{c3f} బ\u{c3e}ణం",
                "కుడ\u{c3f}",
                "బ\u{c3e}ణం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("тири чапу рост"),
            keywords: &["тир", "тири чапу рост"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ล\u{e39}กศรช\u{e35}\u{e49}ซ\u{e49}ายขวา"),
            keywords: &[
                "ขวา",
                "ซ\u{e49}าย",
                "ล\u{e39}กศร",
                "ล\u{e39}กศรช\u{e35}\u{e49}ซ\u{e49}ายขวา",
            ],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ምልክት ናብ-የማን ጸጋም"),
            keywords: &["ምልክት", "ምልክት ናብ-የማን ጸጋም"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("çepe-saga ok"),
            keywords: &["ok", "çepe-saga ok"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("ngahau ki toʻohema mo toʻomataʻu"),
            keywords: &[
                "hema",
                "mataʻu",
                "ngahau",
                "ngahau ki toʻohema mo toʻomataʻu",
            ],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("sol ve sağ ok"),
            keywords: &["ok", "sol ve sağ ok"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئوڭ-سول كۆرسەتكۈچ"),
            keywords: &["ئوڭ-سول كۆرسەتكۈچ", "كۆرسەتكۈچ"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("стрілка вліво-вправо"),
            keywords: &[
                "стрілка",
                "стрілка вліво-вправо",
                "стрілка праворуч і ліворуч",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("دائیں بائیں تیر"),
            keywords: &["تیر", "دائیں بائیں تیر", "سائن", "سمت"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("chapga-o‘ngga strelka"),
            keywords: &["chapga-o‘ngga strelka", "strelka"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("mũi tên trái phải"),
            keywords: &["mũi tên", "mũi tên trái phải"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("fettu càmmoñu-ndijoor"),
            keywords: &["fett", "fettu càmmoñu-ndijoor"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("utolo olusekunene ekhohlo"),
            keywords: &["utolo", "utolo olusekunene ekhohlo"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("àmì ìtó\u{329}sọ\u{301}nà o\u{329}lọ\u{301}fà tọ\u{300}tún-tòsì"),
            keywords: &[
                "àmì ìtó\u{329}sọ\u{301}nà o\u{329}lọ\u{301}fà tọ\u{300}tún-tòsì",
                "ọfà",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("左右箭咀"),
            keywords: &["左右箭咀", "箭咀"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("左右箭咀"),
            keywords: &["左右箭咀", "箭咀"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("左右箭头"),
            keywords: &["左右", "左右箭头", "箭头"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("左右箭頭"),
            keywords: &["左右箭頭"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("左右箭嘴"),
            keywords: &["左右箭嘴"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("umcibisholo okwesokunxele nesokudla"),
            keywords: &["umcibisholo", "umcibisholo okwesokunxele nesokudla"],
        },
    ],
};
#[doc = "↩\u{fe0f}"]
pub const RIGHT_ARROW_CURVING_LEFT: crate::Emoji = crate::Emoji {
    glyph: "↩\u{fe0f}",
    codepoint: "21A9 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "right arrow curving left",
    group: "Symbols",
    subgroup: "arrow",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "↩",
        codepoint: "21A9",
        status: crate::Status::Unqualified,
        introduction_version: 0.6f32,
        name: "right arrow curving left",
        group: "Symbols",
        subgroup: "arrow",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("pyl na regs buig na links"),
            keywords: &["pyl", "pyl na regs buig na links"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ወደ ግራ ታጣፊ ቀኝ ጠቋሚ ቀስት"),
            keywords: &["ቀስት", "ወደ ግራ ታጣፊ ቀኝ ጠቋሚ ቀስት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("سهم أيمن بانحناء أيسر"),
            keywords: &["سهم", "سهم أيمن بانحناء أيسر"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some(
                "ব\u{9be}ও\u{981}ফ\u{9be}ললৈ ভ\u{9be}\u{981}জ লোৱ\u{9be} সো\u{981}ম\u{9c1}খী ক\u{9be}\u{981}ড\u{9bc}",
            ),
            keywords: &[
                "ক\u{9be}\u{981}ড\u{9bc}",
                "ব\u{9be}ও\u{981}ফ\u{9be}ললৈ ভ\u{9be}\u{981}জ লোৱ\u{9be} সো\u{981}ম\u{9c1}খী ক\u{9be}\u{981}ড\u{9bc}",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("sola dönən sağ ox"),
            keywords: &["ox", "sola dönən sağ ox"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("стрэлка ўправа з паваротам улева"),
            keywords: &[
                "кірунак",
                "рух",
                "стрэлка",
                "стрэлка ўправа з паваротам улева",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("извита стрелка наляво"),
            keywords: &["извита стрелка наляво", "стрелка"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ড\u{9be}ন তীর ব\u{9be}দিকে ব\u{9be}\u{981}ক\u{9be}নো"),
            keywords: &[
                "ড\u{9be}ন তীর ব\u{9be}দিকে ব\u{9be}\u{981}ক\u{9be}নো",
                "তীর",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("strelica desno zakrivljena nalijevo"),
            keywords: &["strelica", "strelica desno zakrivljena nalijevo"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("fletxa dreta que gira cap a l’esquerra"),
            keywords: &[
                "dreta",
                "esquerra",
                "fletxa",
                "fletxa dreta que gira cap a l’esquerra",
                "gir",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᎦᏘᏏ ᎦᏝᏗ ᎠᏕᏲ ᎠᎦᏍᎦᏂ"),
            keywords: &["ᎠᎦᏘᏏ ᎦᏝᏗ ᎠᏕᏲ ᎠᎦᏍᎦᏂ", "ᎦᏝᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("šipka doprava stáčející se doleva"),
            keywords: &["šipka", "šipka doprava stáčející se doleva"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("saeth i’r dde yn troi i’r chwith"),
            keywords: &["saeth", "saeth i’r dde yn troi i’r chwith"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("pil mod højre med sving til venstre"),
            keywords: &["pil", "pil mod højre med sving til venstre"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("geschwungener Pfeil nach links"),
            keywords: &[
                "Pfeil",
                "geschwungen",
                "geschwungener Pfeil nach links",
                "links",
                "nach links",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("δεξιό βέλος που στρίβει αριστερά"),
            keywords: &["βέλος", "δεξιό βέλος που στρίβει αριστερά"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("right arrow curving left"),
            keywords: &["arrow", "right arrow curving left"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("flecha derecha curvándose a la izquierda"),
            keywords: &[
                "curva",
                "dirección",
                "flecha",
                "flecha derecha curvándose a la izquierda",
                "izquierda",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("flecha de retorno al oeste por la derecha"),
            keywords: &["flecha de retorno al oeste por la derecha"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["flecha", "flecha derecha curvándose a la izquierda"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kaardus nool vasakule"),
            keywords: &["kaardus nool vasakule", "nool", "vasak"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("ezkerrera okertzen den eskuinera gezia"),
            keywords: &["ezkerrera okertzen den eskuinera gezia", "gezi"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("پیکان خمیده راست"),
            keywords: &["پیکان", "پیکان خمیده راست"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("vasemmalle kääntyvä nuoli"),
            keywords: &["nuoli", "vasemmalle kääntyvä nuoli"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("pakanang arrow na kumurba pakaliwa"),
            keywords: &[
                "arrow",
                "direksyon",
                "kurba",
                "pakaliwa",
                "pakanan",
                "pakanang arrow na kumurba pakaliwa",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("bogin pílur sum peikar til vinstru"),
            keywords: &["bogin", "bogin pílur sum peikar til vinstru", "pílur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("flèche courbe gauche"),
            keywords: &["flèche", "flèche courbe gauche"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("flèche courbe vers la gauche"),
            keywords: &[
                "courbe vers la gauche",
                "flèche",
                "flèche courbe vers la gauche",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("saighead dheas ag dul ar chlé"),
            keywords: &["saighead", "saighead dheas ag dul ar chlé"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("saighead dheas a’ lùbadh dhan taobh chlì"),
            keywords: &["saighead", "saighead dheas a’ lùbadh dhan taobh chlì"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("frecha curvada cara á esquerda"),
            keywords: &[
                "curva",
                "esquerda",
                "frecha",
                "frecha curvada cara á esquerda",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ડાબ\u{ac7} વળત\u{ac1}\u{a82} જમણ\u{ac1}\u{a82} તીર"),
            keywords: &["ડાબ\u{ac7} વળત\u{ac1}\u{a82} જમણ\u{ac1}\u{a82} તીર", "તીર"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("kibiyar dama mai lanƙwasa ta hagu"),
            keywords: &["kibiya", "kibiyar dama mai lanƙwasa ta hagu"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("חץ ימינה מתעקל שמאלה"),
            keywords: &["חץ", "חץ ימינה מתעקל שמאלה", "מתעקל", "פרסה", "שמאלה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("बाई\u{902} ओर म\u{941}ड\u{93c}ा दाया\u{901} तीर"),
            keywords: &["तीर", "बाई\u{902} ओर म\u{941}ड\u{93c}ा दाया\u{901} तीर"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("desna strelica koja se zakrivljuje ulijevo"),
            keywords: &["desna strelica koja se zakrivljuje ulijevo", "strelica"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("balra görbülő jobb nyíl"),
            keywords: &["balra görbülő jobb nyíl", "nyíl"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("աջ շրջադարձի սլաք"),
            keywords: &["աջ շրջադարձի սլաք", "սլաք"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("tanda panah kanan melengkung ke kiri"),
            keywords: &["panah", "tanda panah kanan melengkung ke kiri"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ube-akanri gbagọrọ akaekpe"),
            keywords: &["ube", "ube-akanri gbagọrọ akaekpe"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("sveigð ör til vinstri"),
            keywords: &["sveigð ör til vinstri", "ör"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("freccia curva a sinistra"),
            keywords: &[
                "curva",
                "freccia",
                "freccia curva a sinistra",
                "verso sinistra",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("右カーブ矢印"),
            keywords: &["カーブ", "右カーブ矢印", "左", "曲線", "矢印"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("panah nengen menggok ngiwa"),
            keywords: &["panah", "panah nengen menggok ngiwa"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ისარი, რომელიც იმრუდება მარჯვნიდან მარცხნივ"),
            keywords: &["ისარი", "ისარი, რომელიც იმრუდება მარჯვნიდან მარცხნივ"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("aneccab ayeffus yettin s azelmaḍ"),
            keywords: &["aneccab ayeffus yettin s azelmaḍ"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("оң жақтан шығып, сол жаққа бұрылатын көрсеткі"),
            keywords: &["көрсеткі", "оң жақтан шығып, сол жаққа бұрылатын көрсеткі"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("pil mod højre med sving til venstre"),
            keywords: &["pil", "pil mod højre med sving til venstre"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some(
                "ព\u{17d2}រ\u{17bd}ញកោងត\u{17d2}រឡប\u{17cb}ទៅឆ\u{17d2}វេងក\u{17d2}ន\u{17bb}ងរាងប\u{17bd}នជ\u{17d2}រ\u{17bb}ង",
            ),
            keywords: &[
                "ទ\u{17b7}ស",
                "ទ\u{17b7}សដៅ",
                "ព\u{17d2}រ\u{17bd}ញ",
                "ព\u{17d2}រ\u{17bd}ញកោងត\u{17d2}រឡប\u{17cb}ទៅឆ\u{17d2}វេងក\u{17d2}ន\u{17bb}ងរាងប\u{17bd}នជ\u{17d2}រ\u{17bb}ង",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಎಡಕ\u{ccd}ಕ\u{cc6} ತ\u{cbf}ರುಗುವ ಬಲ ಬಾಣ"),
            keywords: &["ಎಡಕ\u{ccd}ಕ\u{cc6} ತ\u{cbf}ರುಗುವ ಬಲ ಬಾಣ", "ಬಾಣ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("왼쪽으로 꺾어지는 우향 화살표"),
            keywords: &["왼쪽으로 꺾어지는 우향 화살표", "좌회전", "화살표"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("उजवो बाण दाव\u{94d}यान वळा"),
            keywords: &["उजवो बाण दाव\u{94d}यान वळा", "बाण"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("оңдон солго ийилген жебе"),
            keywords: &["жебе", "оңдон солго ийилген жебе"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Rietsfeil mat Lénkskéier"),
            keywords: &["Feiler", "Rietsfeil mat Lénkskéier"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ລ\u{eb9}ກສອນໂຄ\u{ec9}ງຂວາໄປຊ\u{ec9}າຍ"),
            keywords: &[
                "ຊ\u{ec9}າຍ",
                "ລ\u{eb9}ກສອນ",
                "ລ\u{eb9}ກສອນໂຄ\u{ec9}ງຂວາໄປຊ\u{ec9}າຍ",
                "ໂຄ\u{ec9}ງ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("rodyklė į dešinę, užlenkta į kairę"),
            keywords: &["rodyklė", "rodyklė į dešinę, užlenkta į kairę"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("pa kreisi vērsta izliekta bultiņa"),
            keywords: &["bultiņa", "pa kreisi vērsta izliekta bultiņa"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pere matau piko mauī"),
            keywords: &["pere", "pere matau piko mauī"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("стрелка надесно што врти лево"),
            keywords: &["десно", "лево", "стрелка", "стрелка надесно што врти лево"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഇടത\u{d4d}തേക\u{d4d}ക\u{d4d} വളഞ\u{d4d}ഞ വലത\u{d4d} അമ\u{d4d}പടയ\u{d3e}ളം"),
            keywords: &[
                "അമ\u{d4d}പടയ\u{d3e}ളം",
                "ഇടത\u{d4d}തേക\u{d4d}ക\u{d4d} വളഞ\u{d4d}ഞ വലത\u{d4d} അമ\u{d4d}പടയ\u{d3e}ളം",
                "വലത\u{d4d}ത\u{d4d}",
                "വളവ\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("зүүн эргэсэн баруун сум"),
            keywords: &["баруун", "зүүн", "зүүн эргэсэн баруун сум", "сум", "эргэх"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("उजवा डावीकड\u{947} वळल\u{947}ला बाण"),
            keywords: &[
                "उजवा डावीकड\u{947} वळल\u{947}ला बाण",
                "उजवा-डावीकड\u{947} वळल\u{947}ला बाण",
                "बाण",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("anak panah ke kanan melengkung ke kiri"),
            keywords: &["anak panah", "anak panah ke kanan melengkung ke kiri"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("vleġġa leminija mgħawġa lejn ix-xellug"),
            keywords: &["vleġġa", "vleġġa leminija mgħawġa lejn ix-xellug"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ညာည\u{103d}\u{103e}န\u{103a} ဘယ\u{103a}ဝ\u{102d}\u{102f}က\u{103a} မြား"),
            keywords: &[
                "ညာည\u{103d}\u{103e}န\u{103a} ဘယ\u{103a}ဝ\u{102d}\u{102f}က\u{103a} မြား",
                "ဘယ\u{103a}က\u{103d}ေ\u{1037} ညာဖက\u{103a} မြား",
                "မြား",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("pil som bøyer mot venstre"),
            keywords: &["pil", "pil som bøyer mot venstre"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("बाया\u{901} मोड\u{947}को दाया\u{901} वाण"),
            keywords: &["बाया\u{901} मोड\u{947}को दाया\u{901} वाण", "वाण"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("pijl naar rechts die naar links draait"),
            keywords: &["pijl", "pijl naar rechts die naar links draait"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("pil som bøyer mot venstre"),
            keywords: &["pil", "pil som bøyer mot venstre"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଡ\u{b3e}ହ\u{b3e}ଣ ତୀର ବ\u{b3e}ମକ\u{b41} ମୋଡ\u{b3c}\u{b3f} ହେଉଛ\u{b3f}"),
            keywords: &[
                "ଡ\u{b3e}ହ\u{b3e}ଣ ତୀର ବ\u{b3e}ମକ\u{b41} ମୋଡ\u{b3c}\u{b3f} ହେଉଛ\u{b3f}",
                "ତୀର",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਸ\u{a71}\u{a71}ਜ\u{a47} ਮ\u{a41}ੜਨ ਵਾਲਾ ਖ\u{a71}ਬਾ ਤੀਰ"),
            keywords: &[
                "ਤੀਰ",
                "ਸ\u{a71}\u{a71}ਜ\u{a47} ਮ\u{a41}ੜਨ ਵਾਲਾ ਖ\u{a71}ਬਾ ਤੀਰ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("سجا تیر کھبے مڑدیاں ہوئیاں"),
            keywords: &["تیر", "سجا تیر کھبے مڑدیاں ہوئیاں"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Raít Áro Kọ\u{301}v Gó Lẹft"),
            keywords: &["Raít Áro Kọ\u{301}v Gó Lẹft", "Áro"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("strzałka zakręcona w lewo"),
            keywords: &["strzałka", "strzałka zakręcona w lewo", "zakręt", "zawróć"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ښۍ غشی چپ اړخ ته کوږ"),
            keywords: &["غشی", "ښۍ غشی چپ اړخ ته کوږ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("seta curva da direita para a esquerda"),
            keywords: &[
                "curva",
                "retorno",
                "seta",
                "seta curva da direita para a esquerda",
                "voltar à esquerda",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("seta para a direita com curva para a esquerda"),
            keywords: &[
                "curva",
                "esquerda",
                "seta",
                "seta para a direita com curva para a esquerda",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("paña wach’i llink’uwan lluq’iman"),
            keywords: &["paña wach’i llink’uwan lluq’iman"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("săgeată dreapta curbată spre stânga"),
            keywords: &["săgeată", "săgeată dreapta curbată spre stânga"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-012"),
            keywords: &["E10-012"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("стрелка вправо с поворотом влево"),
            keywords: &[
                "изгиб",
                "изогнутая стрелка",
                "поворот влево",
                "стрелка вправо",
                "стрелка вправо с поворотом влево",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umwambi w’iburyo uhetamiye ibumoso"),
            keywords: &["umwambi", "umwambi w’iburyo uhetamiye ibumoso"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ساڄي تير مڙندي کاٻي طرف"),
            keywords: &["تير", "ساڄي تير مڙندي کاٻي طرف"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("වමට රව\u{dd4}ම\u{dca} ව\u{dd6} දක\u{dd4}ණ\u{dd4} ඊතලය"),
            keywords: &[
                "ඊතලය",
                "වමට රව\u{dd4}ම\u{dca} ව\u{dd6} දක\u{dd4}ණ\u{dd4} ඊතලය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("šípka doprava zakrivená doľava"),
            keywords: &["šípka", "šípka doprava zakrivená doľava"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("puščica desno, ki se ukrivlja v levo"),
            keywords: &["puščica", "puščica desno, ki se ukrivlja v levo"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("fallaarta midig u qalloocsan bidix"),
            keywords: &["fallaar", "fallaarta midig u qalloocsan bidix"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("shigjetë djathtas e përkulur majtas"),
            keywords: &["shigjetë", "shigjetë djathtas e përkulur majtas"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("стрелица за полукружни окрет удесно"),
            keywords: &["стрeлицa", "стрелица за полукружни окрет удесно"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("strelica za polukružni okret udesno"),
            keywords: &["strelica", "strelica za polukružni okret udesno"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("svängd vänsterpil"),
            keywords: &["pil", "sväng", "svängd vänsterpil", "vänster"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mshale wa kulia unaopinda kushoto"),
            keywords: &["mshale", "mshale wa kulia unaopinda kushoto"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some(
                "இடப\u{bcd}பக\u{bcd}கம\u{bcd} வளைந\u{bcd}திருக\u{bcd}கும\u{bcd} வலது அம\u{bcd}புக\u{bcd}குறி",
            ),
            keywords: &[
                "அம\u{bcd}புக\u{bcd}குறி",
                "இடப\u{bcd}பக\u{bcd}கம\u{bcd} வளைந\u{bcd}த வலது அம\u{bcd}புக\u{bcd}குறி",
                "இடப\u{bcd}பக\u{bcd}கம\u{bcd} வளைந\u{bcd}திருக\u{bcd}கும\u{bcd} வலது அம\u{bcd}புக\u{bcd}குறி",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ఎడమవ\u{c48}పు వంపు త\u{c3f}ర\u{c3f}గ\u{c3f}న కుడ\u{c3f} బ\u{c3e}ణం"),
            keywords: &[
                "ఎడమవ\u{c48}పు",
                "ఎడమవ\u{c48}పు వంపు త\u{c3f}ర\u{c3f}గ\u{c3f}న కుడ\u{c3f} బ\u{c3e}ణం",
                "కుడ\u{c3f}",
                "బ\u{c3e}ణం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("тири рости ба тарафи чап каҷшаванда"),
            keywords: &["тир", "тири рости ба тарафи чап каҷшаванда"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ล\u{e39}กศรวนซ\u{e49}าย"),
            keywords: &["ซ\u{e49}าย", "ล\u{e39}กศร", "ล\u{e39}กศรวนซ\u{e49}าย", "วน"],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("የማናይ ምልክት ናብ ጸጋም ዝተጠውየ"),
            keywords: &["ምልክት", "የማናይ ምልክት ናብ ጸጋም ዝተጠውየ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("saga ok, çepe egrelýän"),
            keywords: &["ok", "saga ok, çepe egrelýän"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("ngahau afe ki toʻohema"),
            keywords: &["afe", "hema", "ngahau", "ngahau afe ki toʻohema"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("sola kıvrımlı sağ ok"),
            keywords: &["ok", "sola kıvrımlı sağ ok"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("سولغا ئېگىلگەن ئوڭ كۆرسەتكۈچ"),
            keywords: &["سولغا ئېگىلگەن ئوڭ كۆرسەتكۈچ", "كۆرسەتكۈچ"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("стрілка вправо з вигином уліво"),
            keywords: &[
                "стрілка",
                "стрілка вправо з вигином уліво",
                "стрілка праворуч із поворотом ліворуч",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("بائیں مڑتا ہوا دائیں تیر"),
            keywords: &["بائیں مڑتا ہوا دائیں تیر", "تیر", "سائن", "سمت"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("o‘ngdan chapga qayrilish"),
            keywords: &["o‘ngdan chapga qayrilish", "strelka"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("mũi tên phải cong sang trái"),
            keywords: &["mũi tên", "mũi tên phải cong sang trái"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("fettu ndijoor lemoo càmmoñ"),
            keywords: &["fett", "fettu ndijoor lemoo càmmoñ"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("utolo olusekunene olugobe ekhohlo"),
            keywords: &["utolo", "utolo olusekunene olugobe ekhohlo"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("àmì ìtó\u{329}sọ\u{301}nà o\u{329}lọ\u{301}fà apá ọ\u{300}tún onígun"),
            keywords: &[
                "àmì ìtó\u{329}sọ\u{301}nà o\u{329}lọ\u{301}fà apá ọ\u{300}tún onígun",
                "ọfà",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("向右箭咀彎向左"),
            keywords: &["向右箭咀彎向左", "箭咀"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("向右箭咀弯向左"),
            keywords: &["向右箭咀弯向左", "箭咀"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("右转弯箭头"),
            keywords: &["右转弯", "右转弯箭头", "向左弯曲的右箭头", "箭头"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("向左彎的右箭頭"),
            keywords: &["向左彎的右箭頭"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("向左彎嘅右箭嘴"),
            keywords: &["向左彎嘅右箭嘴"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("umcibisholo okhombe kwesokudla ogobe kwesokunxele"),
            keywords: &[
                "umcibisholo",
                "umcibisholo okhombe kwesokudla ogobe kwesokunxele",
            ],
        },
    ],
};
#[doc = "↪\u{fe0f}"]
pub const LEFT_ARROW_CURVING_RIGHT: crate::Emoji = crate::Emoji {
    glyph: "↪\u{fe0f}",
    codepoint: "21AA FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "left arrow curving right",
    group: "Symbols",
    subgroup: "arrow",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "↪",
        codepoint: "21AA",
        status: crate::Status::Unqualified,
        introduction_version: 0.6f32,
        name: "left arrow curving right",
        group: "Symbols",
        subgroup: "arrow",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("pyl na links buig na regs"),
            keywords: &["pyl", "pyl na links buig na regs"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ወደ ቀኝ ታጣፊ ግራ ጠቋሚ ቀስት"),
            keywords: &["ቀስት", "ወደ ቀኝ ታጣፊ ግራ ጠቋሚ ቀስት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("سهم أيسر بانحناء أيمن"),
            keywords: &["سهم", "سهم أيسر بانحناء أيمن"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some(
                "সো\u{981}ফ\u{9be}ললৈ ভ\u{9be}\u{981}জ লোৱ\u{9be} ব\u{9be}ও\u{981}ম\u{9c1}খী ক\u{9be}\u{981}ড\u{9bc}",
            ),
            keywords: &[
                "ক\u{9be}\u{981}ড\u{9bc}",
                "সো\u{981}ফ\u{9be}ললৈ ভ\u{9be}\u{981}জ লোৱ\u{9be} ব\u{9be}ও\u{981}ম\u{9c1}খী ক\u{9be}\u{981}ড\u{9bc}",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("sağa dönən sol ox"),
            keywords: &["ox", "sağa dönən sol ox"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("стрэлка ўлева з паваротам управа"),
            keywords: &[
                "кірунак",
                "рух",
                "стрэлка",
                "стрэлка ўлева з паваротам управа",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("извита стрелка надясно"),
            keywords: &["извита стрелка надясно", "стрелка"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ব\u{9be}ম তীর ড\u{9be}ন দিকে ব\u{9be}\u{981}ক\u{9be}নো"),
            keywords: &[
                "তীর",
                "ব\u{9be}ম তীর ড\u{9be}ন দিকে ব\u{9be}\u{981}ক\u{9be}নো",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("strelica lijevo zakrivljena nadesno"),
            keywords: &["strelica", "strelica lijevo zakrivljena nadesno"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("fletxa esquerra que gira cap a la dreta"),
            keywords: &[
                "dreta",
                "esquerra",
                "fletxa",
                "fletxa esquerra que gira cap a la dreta",
                "gir",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᎦᏍᎦᏂ ᎦᏝᏗ ᎠᏕᏲ ᎠᎦᏘᏏ"),
            keywords: &["ᎠᎦᏍᎦᏂ ᎦᏝᏗ ᎠᏕᏲ ᎠᎦᏘᏏ", "ᎦᏝᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("šipka doleva stáčející se doprava"),
            keywords: &["šipka", "šipka doleva stáčející se doprava"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("saeth i’r chwith yn troi i’r dde"),
            keywords: &["saeth", "saeth i’r chwith yn troi i’r dde"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("pil mod venstre med sving til højre"),
            keywords: &["pil", "pil mod venstre med sving til højre"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("geschwungener Pfeil nach rechts"),
            keywords: &[
                "Pfeil",
                "geschwungen",
                "geschwungener Pfeil nach rechts",
                "nach rechts",
                "rechts",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("αριστερό βέλος που στρίβει δεξιά"),
            keywords: &["αριστερό βέλος που στρίβει δεξιά", "βέλος"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("left arrow curving right"),
            keywords: &["arrow", "left arrow curving right"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("flecha izquierda curvándose a la derecha"),
            keywords: &[
                "curva",
                "derecha",
                "dirección",
                "flecha",
                "flecha izquierda curvándose a la derecha",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("flecha de retorno al este por la izquierda"),
            keywords: &["flecha de retorno al este por la izquierda"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &[
                "flecha",
                "flecha izquierda curvándose a la derecha",
                "flecha izquierda curvándose a la izquierda",
            ],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kaardus nool paremale"),
            keywords: &["kaardus nool paremale", "nool", "parem"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("eskuinera okertzen den ezkerrera gezia"),
            keywords: &["eskuinera okertzen den ezkerrera gezia", "gezi"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("پیکان خمیده چپ"),
            keywords: &["پیکان", "پیکان خمیده چپ"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("oikealle kääntyvä nuoli"),
            keywords: &["nuoli", "oikealle kääntyvä nuoli"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("pakaliwang arrow na kumurba pakanan"),
            keywords: &[
                "arrow",
                "direksyon",
                "kurba",
                "pakaliwa",
                "pakaliwang arrow na kumurba pakanan",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("bogin pílur sum peikar til høgru"),
            keywords: &["bogin", "bogin pílur sum peikar til høgru", "pílur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("flèche courbe droite"),
            keywords: &["flèche", "flèche courbe droite"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("flèche courbe vers la droite"),
            keywords: &[
                "courbe vers la droite",
                "flèche",
                "flèche courbe vers la droite",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("saighead chlé ag dul ar dheis"),
            keywords: &["saighead", "saighead chlé ag dul ar dheis"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("saighead chlì a’ lùbadh dhan taobh deas"),
            keywords: &["saighead", "saighead chlì a’ lùbadh dhan taobh deas"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("frecha curvada cara á dereita"),
            keywords: &[
                "curva",
                "dereita",
                "frecha",
                "frecha curvada cara á dereita",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("જમણ\u{ac7} વળત\u{ac1}\u{a82} ડાબ\u{ac1}\u{a82} તીર"),
            keywords: &["જમણ\u{ac7} વળત\u{ac1}\u{a82} ડાબ\u{ac1}\u{a82} તીર", "તીર"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("kibiyar hagu mai lanƙwasa ta dama"),
            keywords: &["kibiya", "kibiyar hagu mai lanƙwasa ta dama"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("חץ שמאלה מתעקל ימינה"),
            keywords: &["חץ", "חץ שמאלה מתעקל ימינה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("दाई\u{902} ओर म\u{941}ड\u{93c}ा बाया\u{901} तीर"),
            keywords: &["तीर", "दाई\u{902} ओर म\u{941}ड\u{93c}ा बाया\u{901} तीर"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("lijeva strelica koja se zakrivljuje udesno"),
            keywords: &["lijeva strelica koja se zakrivljuje udesno", "strelica"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("jobbra görbülő bal nyíl"),
            keywords: &["jobbra görbülő bal nyíl", "nyíl"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ձախ շրջադարձի սլաք"),
            keywords: &["ձախ շրջադարձի սլաք", "սլաք"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("tanda panah kanan melengkung ke kanan"),
            keywords: &["panah", "tanda panah kanan melengkung ke kanan"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ube-akaekpe gbagọrọ akanri"),
            keywords: &["ube", "ube-akaekpe gbagọrọ akanri"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("sveigð ör til hægri"),
            keywords: &["sveigð ör til hægri", "ör"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("freccia curva a destra"),
            keywords: &["curva", "freccia", "freccia curva a destra", "verso destra"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("左カーブ矢印"),
            keywords: &["カーブ", "右", "左カーブ矢印", "曲線", "矢印"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("panah ngiwa menggok nengen"),
            keywords: &["panah", "panah ngiwa menggok nengen"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ისარი, რომელიც იმრუდება მარცნიდან მარჯვნივ"),
            keywords: &["ისარი", "ისარი, რომელიც იმრუდება მარცნიდან მარჯვნივ"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("aneccab azelmaḍ yettin s ayeffus"),
            keywords: &["aneccab azelmaḍ yettin s ayeffus"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("сол жақтан шығып, оң жаққа бұрылатын көрсеткі"),
            keywords: &["көрсеткі", "сол жақтан шығып, оң жаққа бұрылатын көрсеткі"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("pil mod venstre med sving til højre"),
            keywords: &["pil", "pil mod venstre med sving til højre"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some(
                "ព\u{17d2}រ\u{17bd}ញកោងត\u{17d2}រឡប\u{17cb}ទៅស\u{17d2}តា\u{17c6}ក\u{17d2}ន\u{17bb}ងរាងប\u{17bd}នជ\u{17d2}រ\u{17bb}ង",
            ),
            keywords: &[
                "ទ\u{17b7}ស",
                "ទ\u{17b7}សដៅ",
                "ព\u{17d2}រ\u{17bd}ញ",
                "ព\u{17d2}រ\u{17bd}ញកោងត\u{17d2}រឡប\u{17cb}ទៅស\u{17d2}តា\u{17c6}ក\u{17d2}ន\u{17bb}ងរាងប\u{17bd}នជ\u{17d2}រ\u{17bb}ង",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಬಲಕ\u{ccd}ಕ\u{cc6} ತ\u{cbf}ರುಗುವ ಎಡ ಬಾಣ"),
            keywords: &["ಬಲಕ\u{ccd}ಕ\u{cc6} ತ\u{cbf}ರುಗುವ ಎಡ ಬಾಣ", "ಬಾಣ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("오른쪽으로 꺾어지는 좌향 화살표"),
            keywords: &["오른쪽으로 꺾어지는 좌향 화살표", "우회전", "화살표"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("दावो बाण उजव\u{94d}यान वळा"),
            keywords: &["दावो बाण उजव\u{94d}यान वळा", "बाण"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("солдон оңго ийилген жебе"),
            keywords: &["жебе", "солдон оңго ийилген жебе"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Lénksfeil mat Rietskéier"),
            keywords: &["Feiler", "Lénksfeil mat Rietskéier"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ລ\u{eb9}ກສອນໂຄ\u{ec9}ງຊ\u{ec9}າຍໄປຂວາ"),
            keywords: &[
                "ຂວາ",
                "ລ\u{eb9}ກສອນ",
                "ລ\u{eb9}ກສອນໂຄ\u{ec9}ງຊ\u{ec9}າຍໄປຂວາ",
                "ໂຄ\u{ec9}ງ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("rodyklė į kairę, užlenkta į dešinę"),
            keywords: &["rodyklė", "rodyklė į kairę, užlenkta į dešinę"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("pa labi vērsta izliekta bultiņa"),
            keywords: &["bultiņa", "pa labi vērsta izliekta bultiņa"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pere mauī piko matau"),
            keywords: &["pere", "pere mauī piko matau"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("стрелка налево што врти десно"),
            keywords: &["десно", "лево", "стрелка", "стрелка налево што врти десно"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("വലത\u{d4d}തേക\u{d4d}ക\u{d4d} വളഞ\u{d4d}ഞ ഇടത\u{d4d} അമ\u{d4d}പടയ\u{d3e}ളം"),
            keywords: &[
                "അമ\u{d4d}പടയ\u{d3e}ളം",
                "ഇടത\u{d4d}ത\u{d4d}",
                "വലത\u{d4d}തേക\u{d4d}ക\u{d4d} വളഞ\u{d4d}ഞ ഇടത\u{d4d} അമ\u{d4d}പടയ\u{d3e}ളം",
                "വളവ\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("баруун эргэсэн зүүн сум"),
            keywords: &["баруун", "баруун эргэсэн зүүн сум", "зүүн", "сум", "эргэх"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("डावा उजवीकड\u{947} वळल\u{947}ला बाण"),
            keywords: &[
                "डावा उजवीकड\u{947} वळल\u{947}ला बाण",
                "डावा-उजवीकड\u{947} वळल\u{947}ला बाण",
                "बाण",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("anak panah ke kiri melengkung ke kanan"),
            keywords: &["anak panah", "anak panah ke kiri melengkung ke kanan"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("vleġġa tax-xellug mgħawġa lejn il-lemin"),
            keywords: &["vleġġa", "vleġġa tax-xellug mgħawġa lejn il-lemin"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဘယ\u{103a}ည\u{103d}\u{103e}န\u{103a} ညာဝ\u{102d}\u{102f}က\u{103a} မြား"),
            keywords: &[
                "ညာက\u{103d}ေ\u{1037} ဘယ\u{103a}ဖက\u{103a} မြား",
                "ဘယ\u{103a}ည\u{103d}\u{103e}န\u{103a} ညာဝ\u{102d}\u{102f}က\u{103a} မြား",
                "မြား",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("pil som bøyer mot høyre"),
            keywords: &["pil", "pil som bøyer mot høyre"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("दाया\u{901} मोड\u{947}को बाया\u{901} वाण"),
            keywords: &["दाया\u{901} मोड\u{947}को बाया\u{901} वाण", "वाण"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("pijl naar links die naar rechts draait"),
            keywords: &["pijl", "pijl naar links die naar rechts draait"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("pil som bøyer mot høgre"),
            keywords: &["pil", "pil som bøyer mot høgre"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ବ\u{b3e}ମ ତୀର ଡ\u{b3e}ହ\u{b3e}ଣକ\u{b41} ମୋଡ\u{b3c}\u{b3f} ହେଉଛ\u{b3f}"),
            keywords: &[
                "ତୀର",
                "ବ\u{b3e}ମ ତୀର ଡ\u{b3e}ହ\u{b3e}ଣକ\u{b41} ମୋଡ\u{b3c}\u{b3f} ହେଉଛ\u{b3f}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਖ\u{a71}ਬ\u{a47}\u{a47} ਮ\u{a41}ੜਨ ਵਾਲਾ ਸ\u{a71}ਜਾ ਤੀਰ"),
            keywords: &[
                "ਖ\u{a71}ਬ\u{a47}\u{a47} ਮ\u{a41}ੜਨ ਵਾਲਾ ਸ\u{a71}ਜਾ ਤੀਰ",
                "ਤੀਰ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("کھبا تیر سجے مڑدیاں ہوئیاں"),
            keywords: &["تیر", "کھبا تیر سجے مڑدیاں ہوئیاں"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Lẹ\u{301}ft Áro Kọ\u{301}v Gó Raít"),
            keywords: &[
                "Lẹ\u{301}ft Áro Kọ\u{301}v Gó Rait",
                "Lẹ\u{301}ft Áro Kọ\u{301}v Gó Raít",
                "Áro",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("strzałka zakręcona w prawo"),
            keywords: &["strzałka", "strzałka zakręcona w prawo", "zakręt", "zawróć"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("چپ غشی ښۍ اړخ ته کوږ"),
            keywords: &["غشی", "چپ غشی ښۍ اړخ ته کوږ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("seta curva da esquerda para a direita"),
            keywords: &[
                "curva",
                "retorno",
                "seta",
                "seta curva da esquerda para a direita",
                "voltar à direita",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("seta para a esquerda com curva para a direita"),
            keywords: &[
                "curva",
                "direita",
                "seta",
                "seta para a esquerda com curva para a direita",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("lluq’i wach’i llink’uwan pañaman"),
            keywords: &["lluq’i wach’i llink’uwan pañaman"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("săgeată stânga curbată spre dreapta"),
            keywords: &["săgeată", "săgeată stânga curbată spre dreapta"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-013"),
            keywords: &["E10-013"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("стрелка влево с поворотом вправо"),
            keywords: &[
                "изгиб",
                "изогнутая стрелка",
                "поворот вправо",
                "стрелка влево",
                "стрелка влево с поворотом вправо",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umwambi w’ibumoso uhetamiye iburyo"),
            keywords: &["umwambi", "umwambi w’ibumoso uhetamiye iburyo"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("کاٻي تير مڙندي ساڄي طرف"),
            keywords: &["تير", "کاٻي تير مڙندي ساڄي طرف"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("දක\u{dd4}ණට රව\u{dd4}ම\u{dca} ව\u{dd6} වම\u{dca} ඊතලය"),
            keywords: &[
                "ඊතලය",
                "දක\u{dd4}ණට රව\u{dd4}ම\u{dca} ව\u{dd6} වම\u{dca} ඊතලය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("šípka doľava zakrivená doprava"),
            keywords: &["šípka", "šípka doľava zakrivená doprava"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("puščica levo, ki se ukrivlja v desno"),
            keywords: &["puščica", "puščica levo, ki se ukrivlja v desno"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("fallaarta bidix u qalloocsan midig"),
            keywords: &["fallaar", "fallaarta bidix u qalloocsan midig"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("shigjeta majtas me hark djathtas"),
            keywords: &["shigjeta majtas me hark djathtas", "shigjetë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("стрелица за полукружни окрет улево"),
            keywords: &["стрeлицa", "стрелица за полукружни окрет улево"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("стрелица за полукружни окрет улијево"),
            keywords: &["стрелица за полукружни окрет улијево"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("strelica za polukružni okret ulevo"),
            keywords: &["strelica", "strelica za polukružni okret ulevo"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("strelica za polukružni okret ulijevo"),
            keywords: &["strelica za polukružni okret ulijevo"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("svängd högerpil"),
            keywords: &["höger", "pil", "sväng", "svängd högerpil"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mshale wa kushoto unaopinda kulia"),
            keywords: &["mshale", "mshale wa kushoto unaopinda kulia"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some(
                "வலப\u{bcd}பக\u{bcd}கம\u{bcd} வளைந\u{bcd}திருக\u{bcd}கும\u{bcd} இடது அம\u{bcd}புக\u{bcd}குறி",
            ),
            keywords: &[
                "அம\u{bcd}புக\u{bcd}குறி",
                "வலப\u{bcd}பக\u{bcd}கம\u{bcd} வளைந\u{bcd}த இடது அம\u{bcd}புக\u{bcd}குறி",
                "வலப\u{bcd}பக\u{bcd}கம\u{bcd} வளைந\u{bcd}திருக\u{bcd}கும\u{bcd} இடது அம\u{bcd}புக\u{bcd}குறி",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("కుడ\u{c3f}వ\u{c48}పు వంపు త\u{c3f}ర\u{c3f}గ\u{c3f}న ఎడమ బ\u{c3e}ణం"),
            keywords: &[
                "ఎడమ",
                "కుడ\u{c3f}వ\u{c48}పు",
                "కుడ\u{c3f}వ\u{c48}పు వంపు త\u{c3f}ర\u{c3f}గ\u{c3f}న ఎడమ బ\u{c3e}ణం",
                "బ\u{c3e}ణం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("тири чапи ба тарафи рост каҷшаванда"),
            keywords: &["тир", "тири чапи ба тарафи рост каҷшаванда"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ล\u{e39}กศรวนขวา"),
            keywords: &["ขวา", "ล\u{e39}กศร", "ล\u{e39}กศรวนขวา", "วน"],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ጸጋማይ ምልክት ናብ የማን ዝተጠውየ"),
            keywords: &["ምልክት", "ጸጋማይ ምልክት ናብ የማን ዝተጠውየ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("çepe ok, saga egrelýän"),
            keywords: &["ok", "çepe ok, saga egrelýän"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("ngahau afe ki toʻomataʻu"),
            keywords: &["afe", "mataʻu", "ngahau", "ngahau afe ki toʻomataʻu"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("sağa kıvrımlı sol ok"),
            keywords: &["ok", "sağa kıvrımlı sol ok"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئوڭغا ئېگىلگەن سول كۆرسەتكۈچ"),
            keywords: &["ئوڭغا ئېگىلگەن سول كۆرسەتكۈچ", "كۆرسەتكۈچ"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("стрілка вліво з вигином управо"),
            keywords: &[
                "стрілка",
                "стрілка вліво з вигином управо",
                "стрілка ліворуч із поворотом праворуч",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("دائیں مڑتا ہوا بائیں تیر"),
            keywords: &["تیر", "دائیں مڑتا ہوا بائیں تیر", "سائن", "سمت"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("chapdan o‘ngga qayrilish"),
            keywords: &["chapdan o‘ngga qayrilish", "strelka"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("mũi tên trái cong sang phải"),
            keywords: &["mũi tên", "mũi tên trái cong sang phải"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("fettu càmmoñ lemoo ndijoor"),
            keywords: &["fett", "fettu càmmoñ lemoo ndijoor"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("utolo olusekhohlo olugobe ekunene"),
            keywords: &["utolo", "utolo olusekhohlo olugobe ekunene"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("àmì ìtó\u{329}sọ\u{301}nà o\u{329}lọ\u{301}fà apá òsì onígun"),
            keywords: &[
                "àmì ìtó\u{329}sọ\u{301}nà o\u{329}lọ\u{301}fà apá òsì onígun",
                "ọfà",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("向左箭咀彎向右"),
            keywords: &["向左箭咀彎向右", "箭咀"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("向左箭咀弯向右"),
            keywords: &["向左箭咀弯向右", "箭咀"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("左转弯箭头"),
            keywords: &["向右弯曲的左箭头", "左转弯", "左转弯箭头", "箭头"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("向右彎的左箭頭"),
            keywords: &["向右彎的左箭頭"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("向右彎嘅左箭嘴"),
            keywords: &["向右彎嘅左箭嘴"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("umcibisholo okhombe kwesokunxele ogobe kwesokudla"),
            keywords: &[
                "umcibisholo",
                "umcibisholo okhombe kwesokunxele ogobe kwesokudla",
            ],
        },
    ],
};
#[doc = "⤴\u{fe0f}"]
pub const RIGHT_ARROW_CURVING_UP: crate::Emoji = crate::Emoji {
    glyph: "⤴\u{fe0f}",
    codepoint: "2934 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "right arrow curving up",
    group: "Symbols",
    subgroup: "arrow",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "⤴",
        codepoint: "2934",
        status: crate::Status::Unqualified,
        introduction_version: 0.6f32,
        name: "right arrow curving up",
        group: "Symbols",
        subgroup: "arrow",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("pyl na regs buig op"),
            keywords: &["pyl", "pyl na regs buig op"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ወደ ላይ ታጣፊ ቀኝ ጠቋሚ ቀስት"),
            keywords: &["ቀስት", "ወደ ላይ ታጣፊ ቀኝ ጠቋሚ ቀስት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("سهم لأعلى من اليسار"),
            keywords: &["سهم", "سهم لأعلى من اليسار"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some(
                "ওপৰলৈ ভ\u{9be}\u{981}জ লোৱ\u{9be} সো\u{981}ম\u{9c1}খী ক\u{9be}\u{981}ড\u{9bc}",
            ),
            keywords: &[
                "ওপৰলৈ ভ\u{9be}\u{981}জ লোৱ\u{9be} সো\u{981}ম\u{9c1}খী ক\u{9be}\u{981}ড\u{9bc}",
                "ক\u{9be}\u{981}ড\u{9bc}",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("yuxarı dönən sağ ox"),
            keywords: &["ox", "yuxarı dönən sağ ox"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("стрэлка ўправа з паваротам уверх"),
            keywords: &[
                "кірунак",
                "стрэлка",
                "стрэлка ўправа з паваротам уверх",
                "уверх",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("извита стрелка надясно и нагоре"),
            keywords: &["извита стрелка надясно и нагоре", "стрелка"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ড\u{9be}ন তীর উপরের দিকে ব\u{9be}\u{981}ক\u{9be}নো"),
            keywords: &["ড\u{9be}ন তীর উপরের দিকে ব\u{9be}\u{981}ক\u{9be}নো", "তীর"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("strelica desno zakrivljena prema gore"),
            keywords: &["strelica", "strelica desno zakrivljena prema gore"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("fletxa dreta que gira cap amunt"),
            keywords: &[
                "amunt",
                "dreta",
                "fletxa",
                "fletxa dreta que gira cap amunt",
                "gir",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᎦᏘᏏ ᎦᏝᏗ ᎠᏕᏲ ᎦᎸᎳᏗᎠᎦᏘ"),
            keywords: &["ᎠᎦᏘᏏ ᎦᏝᏗ ᎠᏕᏲ ᎦᎸᎳᏗᎠᎦᏘ", "ᎦᏝᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("šipka doprava stáčející se nahoru"),
            keywords: &["šipka", "šipka doprava stáčející se nahoru"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("saeth i’r dde yn troi i fyny"),
            keywords: &["saeth", "saeth i’r dde yn troi i fyny"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("pil mod højre med sving opad"),
            keywords: &["pil", "pil mod højre med sving opad"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("geschwungener Pfeil nach oben"),
            keywords: &[
                "Pfeil",
                "geschwungen",
                "geschwungener Pfeil nach oben",
                "nach oben",
                "oben",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("δεξιό βέλος που στρίβει πάνω"),
            keywords: &["βέλος", "δεξιό βέλος που στρίβει πάνω"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("right arrow curving up"),
            keywords: &["arrow", "right arrow curving up"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("flecha derecha curvándose hacia arriba"),
            keywords: &[
                "arriba",
                "curva",
                "dirección",
                "flecha",
                "flecha derecha curvándose hacia arriba",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("flecha de retorno al norte por la izquierda"),
            keywords: &["flecha de retorno al norte por la izquierda"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["flecha", "flecha derecha curvándose hacia arriba"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kaardus nool üles"),
            keywords: &["kaardus nool üles", "nool", "üles"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("gora okertzen den eskuinera gezia"),
            keywords: &["gezi", "gora okertzen den eskuinera gezia"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("پیکان خمیده بالا راست"),
            keywords: &["پیکان", "پیکان خمیده بالا راست"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("ylös kääntyvä nuoli"),
            keywords: &["nuoli", "ylös", "ylös kääntyvä nuoli"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("pakanang arrow na kumurba pataas"),
            keywords: &[
                "arrow",
                "direksyon",
                "kurba",
                "pakaliwa",
                "pakanang arrow na kumurba pataas",
                "pataas",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("bogin pílur sum peikar uppeftir"),
            keywords: &["bogin", "bogin pílur sum peikar uppeftir", "pílur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("flèche courbe haut"),
            keywords: &["flèche", "flèche courbe haut"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("flèche courbe vers le haut"),
            keywords: &[
                "courbe vers le haut",
                "flèche",
                "flèche courbe vers le haut",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("saighead dheas ag dul suas"),
            keywords: &["saighead", "saighead dheas ag dul suas"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("saighead dheas a’ lùbadh suas"),
            keywords: &["saighead", "saighead dheas a’ lùbadh suas"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("frecha curvada cara arriba"),
            keywords: &["arriba", "curva", "frecha", "frecha curvada cara arriba"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ઉપર વળત\u{ac1}\u{a82} જમણ\u{ac1}\u{a82} તીર"),
            keywords: &["ઉપર વળત\u{ac1}\u{a82} જમણ\u{ac1}\u{a82} તીર", "તીર"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("kibiyar dama mai lanƙwasa ta sama"),
            keywords: &["kibiya", "kibiyar dama mai lanƙwasa ta sama"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("חץ ימינה מתעקל מעלה"),
            keywords: &["חץ", "חץ ימינה מתעקל מעלה", "למעלה", "מתעקל"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ऊपर की ओर म\u{941}ड\u{93c}ा दाया\u{901} तीर"),
            keywords: &["ऊपर की ओर म\u{941}ड\u{93c}ा दाया\u{901} तीर", "तीर"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("desna strelica koja se zakrivljuje prema gore"),
            keywords: &["desna strelica koja se zakrivljuje prema gore", "strelica"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("felfelé görbülő jobb nyíl"),
            keywords: &["felfelé görbülő jobb nyíl", "nyíl"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ձախից վերև թեքվող սլաք"),
            keywords: &["ձախից վերև թեքվող սլաք", "սլաք"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("tanda panah kanan melengkung ke atas"),
            keywords: &["panah", "tanda panah kanan melengkung ke atas"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ube-akanri na-eme mgbagọ dị elu"),
            keywords: &["ube", "ube-akanri na-eme mgbagọ dị elu"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("sveig ör upp"),
            keywords: &["sveig ör upp", "ör"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("freccia curva in alto"),
            keywords: &["curva", "freccia", "freccia curva in alto", "verso l’alto"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("上カーブ矢印"),
            keywords: &["カーブ", "上", "上カーブ矢印", "曲線", "矢印"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("panah nengen menggok munggah"),
            keywords: &["panah", "panah nengen menggok munggah"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ისარი, რომელიც იმრუდება მარჯვნიდან ზემოთ"),
            keywords: &["ისარი", "ისარი, რომელიც იმრუდება მარჯვნიდან ზემოთ"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("aneccab ayeffus yettin d asawen"),
            keywords: &["aneccab ayeffus yettin d asawen"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("оң жақтан шығып, жоғарыға бұрылатын көрсеткі"),
            keywords: &["көрсеткі", "оң жақтан шығып, жоғарыға бұрылатын көрсеткі"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("pil mod højre med sving opad"),
            keywords: &["pil", "pil mod højre med sving opad"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some(
                "ព\u{17d2}រ\u{17bd}ញកោងព\u{17b8}ក\u{17d2}រោមទៅលើក\u{17d2}ន\u{17bb}ងរាងប\u{17bd}នជ\u{17d2}រ\u{17bb}ង",
            ),
            keywords: &[
                "ទ\u{17b7}ស",
                "ទ\u{17b7}សដៅ",
                "ព\u{17d2}រ\u{17bd}ញ",
                "ព\u{17d2}រ\u{17bd}ញកោងព\u{17b8}ក\u{17d2}រោមទៅលើក\u{17d2}ន\u{17bb}ងរាងប\u{17bd}នជ\u{17d2}រ\u{17bb}ង",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಮೇಲಕ\u{ccd}ಕ\u{cc6} ತ\u{cbf}ರುಗುವ ಬಲ ಬಾಣ"),
            keywords: &["ಬಾಣ", "ಮೇಲಕ\u{ccd}ಕ\u{cc6} ತ\u{cbf}ರುಗುವ ಬಲ ಬಾಣ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("위쪽으로 꺾어지는 우향 화살표"),
            keywords: &["위쪽으로 꺾어지는 우향 화살표", "좌회전", "화살표"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("उजवो बाण वयर वळा"),
            keywords: &["उजवो बाण वयर वळा", "बाण"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("оңдон өйдө ийилген жебе"),
            keywords: &["жебе", "оңдон өйдө ийилген жебе"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Rietsfeil mat Kéier no uewen"),
            keywords: &["Feiler", "Rietsfeil mat Kéier no uewen"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ລ\u{eb9}ກສອນໂຄ\u{ec9}ງຂວາຂ\u{eb6}\u{ec9}ນເທ\u{eb4}ງ"),
            keywords: &[
                "ຂວາ",
                "ຂ\u{eb6}\u{ec9}ນເທ\u{eb4}ງ",
                "ລ\u{eb9}ກສອນ",
                "ລ\u{eb9}ກສອນໂຄ\u{ec9}ງຂວາຂ\u{eb6}\u{ec9}ນເທ\u{eb4}ງ",
                "ໂຄ\u{ec9}ງ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("rodyklė į dešinę, užlenkta į viršų"),
            keywords: &["rodyklė", "rodyklė į dešinę, užlenkta į viršų"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("augšup vērsta izliekta bultiņa"),
            keywords: &["augšup vērsta izliekta bultiņa", "bultiņa"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pere matau piko ake"),
            keywords: &["pere", "pere matau piko ake"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("десна стрелка што врти нагоре"),
            keywords: &["горе", "десна стрелка што врти нагоре", "десно", "стрелка"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("മ\u{d41}കളിലേക\u{d4d}ക\u{d4d} വളഞ\u{d4d}ഞ വലത\u{d4d} അമ\u{d4d}പടയ\u{d3e}ളം"),
            keywords: &[
                "അമ\u{d4d}പടയ\u{d3e}ളം",
                "മ\u{d41}കളിലേക\u{d4d}ക\u{d4d} വളഞ\u{d4d}ഞ വലത\u{d4d} അമ\u{d4d}പടയ\u{d3e}ളം",
                "മ\u{d41}\u{d41}കളിലേക\u{d4d}ക\u{d4d}",
                "വളവ\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("дээшээ заасан баруун сум"),
            keywords: &["баруун", "дээш", "дээшээ заасан баруун сум", "заах", "сум"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("उजवा वर वळल\u{947}ला बाण"),
            keywords: &["उजवा वर वळल\u{947}ला बाण", "बाण"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("anak panah ke kanan melengkung ke atas"),
            keywords: &["anak panah", "anak panah ke kanan melengkung ke atas"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("vleġġa leminija mgħawġa ’l fuq"),
            keywords: &["vleġġa", "vleġġa leminija mgħawġa ’l fuq"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ညာည\u{103d}\u{103e}န\u{103a} အပေါ\u{103a}ဝ\u{102d}\u{102f}က\u{103a} မြား"),
            keywords: &[
                "ညာည\u{103d}\u{103e}န\u{103a} အပေါ\u{103a}ဝ\u{102d}\u{102f}က\u{103a} မြား",
                "မြား",
                "အပေါ\u{103a}က\u{103d}ေ\u{1037} ညာ မြား",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("pil som bøyer opp"),
            keywords: &["pil", "pil som bøyer opp"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("माथि मोड\u{947}को दाया\u{901} वाण"),
            keywords: &["माथि मोड\u{947}को दाया\u{901} वाण", "वाण"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("pijl naar rechts die omhoog draait"),
            keywords: &["pijl", "pijl naar rechts die omhoog draait"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("pil som bøyer opp"),
            keywords: &["pil", "pil som bøyer opp"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଡ\u{b3e}ହ\u{b3e}ଣ ତୀର ଉପରକ\u{b41} ମୋଡ\u{b3c}\u{b3f} ହେଉଛ\u{b3f}"),
            keywords: &[
                "ଡ\u{b3e}ହ\u{b3e}ଣ ତୀର ଉପରକ\u{b41} ମୋଡ\u{b3c}\u{b3f} ହେଉଛ\u{b3f}",
                "ତୀର",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਉ\u{a71}ਪਰ ਮ\u{a41}ੜਨ ਵਾਲਾ ਸ\u{a71}ਜਾ ਤੀਰ"),
            keywords: &["ਉ\u{a71}ਪਰ ਮ\u{a41}ੜਨ ਵਾਲਾ ਸ\u{a71}ਜਾ ਤੀਰ", "ਤੀਰ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("سجا تیر ا\u{64f}وتے مڑدیاں ہوئیاں"),
            keywords: &["تیر", "سجا تیر ا\u{64f}وتے مڑدیاں ہوئیاں"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Raít Áro Kọ\u{301}v Gó Ọp"),
            keywords: &["Raít Áro Kọ\u{301}v Gó Ọp", "Áro"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("strzałka w prawo skręcająca w górę"),
            keywords: &["strzałka", "strzałka w prawo skręcająca w górę", "zakręt"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ښۍ غشی پورته کوږ"),
            keywords: &["غشی", "ښۍ غشی پورته ته کوږ", "ښۍ غشی پورته کوږ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("seta para a direita curvada para cima"),
            keywords: &[
                "curva",
                "seta",
                "seta curva de baixo para cima",
                "seta para a direita curvada para cima",
                "seta para cima",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("seta para a direita com curva para cima"),
            keywords: &[
                "curva",
                "para cima",
                "seta",
                "seta para a direita com curva para cima",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("paña wach’i llink’uwan hanaqman"),
            keywords: &["paña wach’i llink’uwan hanaqman"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("săgeată dreapta curbată în sus"),
            keywords: &["săgeată", "săgeată dreapta curbată în sus"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-154"),
            keywords: &["E10-154"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("стрелка вправо с поворотом вверх"),
            keywords: &[
                "изгиб",
                "изогнутая стрелка",
                "поворот вверх",
                "стрелка вправо",
                "стрелка вправо с поворотом вверх",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umwambi w’iburyo uhetamiye hejuru"),
            keywords: &["umwambi", "umwambi w’iburyo uhetamiye hejuru"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ساڄي تير مڙندي مٿين طرف"),
            keywords: &["تير", "ساڄي تير مڙندي مٿين طرف"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ඉහළට රව\u{dd4}ම\u{dca} ව\u{dd6} දක\u{dd4}ණ\u{dd4} ඊතලය"),
            keywords: &[
                "ඉහළට රව\u{dd4}ම\u{dca} ව\u{dd6} දක\u{dd4}ණ\u{dd4} ඊතලය",
                "ඊතලය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("šípka doprava zakrivená nahor"),
            keywords: &["šípka", "šípka doprava zakrivená nahor"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("puščica desno, ki se ukrivlja gor"),
            keywords: &["puščica", "puščica desno, ki se ukrivlja gor"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("fallaarta midig u qalloocsan kor"),
            keywords: &["fallaar", "fallaarta midig u qalloocsan kor"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("shigjetë djathtas e përkulur lart"),
            keywords: &["shigjetë", "shigjetë djathtas e përkulur lart"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("стрелица која скреће нагоре"),
            keywords: &["стрeлицa", "стрелица која скреће нагоре"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("strelica koja skreće nagore"),
            keywords: &["strelica", "strelica koja skreće nagore"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("svängd uppåtpil"),
            keywords: &["pil", "sväng", "svängd uppåtpil", "uppåt"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mshale wa kulia unaopinda juu"),
            keywords: &["mshale", "mshale wa kulia unaopinda juu"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some(
                "மேல\u{bcd} நோக\u{bcd}கி வளைந\u{bcd}திருக\u{bcd}கும\u{bcd} வலது அம\u{bcd}புக\u{bcd}குறி",
            ),
            keywords: &[
                "அம\u{bcd}புக\u{bcd}குறி",
                "மேல\u{bcd} நோக\u{bcd}கி வளைந\u{bcd}த வலது அம\u{bcd}புக\u{bcd}குறி",
                "மேல\u{bcd} நோக\u{bcd}கி வளைந\u{bcd}திருக\u{bcd}கும\u{bcd} வலது அம\u{bcd}புக\u{bcd}குறி",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ప\u{c48}క\u{c3f} వంపు త\u{c3f}ర\u{c3f}గ\u{c3f}న కుడ\u{c3f} బ\u{c3e}ణం"),
            keywords: &[
                "కుడ\u{c3f}",
                "ప\u{c48}క\u{c3f}",
                "ప\u{c48}క\u{c3f} వంపు త\u{c3f}ర\u{c3f}గ\u{c3f}న కుడ\u{c3f} బ\u{c3e}ణం",
                "బ\u{c3e}ణం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("тири рости ба тарафи боло каҷшаванда"),
            keywords: &["тир", "тири рости ба тарафи боло каҷшаванда"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ล\u{e39}กศรโค\u{e49}งข\u{e36}\u{e49}น"),
            keywords: &[
                "ข\u{e35}\u{e49}น",
                "ล\u{e39}กศร",
                "ล\u{e39}กศรโค\u{e49}งข\u{e36}\u{e49}น",
            ],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("የማናይ ምልክት ናብ ላዕሊ ዝተጠውየ"),
            keywords: &["ምልክት", "የማናይ ምልክት ናብ ላዕሊ ዝተጠውየ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("saga ok, ýokary egrelýän"),
            keywords: &["ok", "saga ok, ýokary egrelýän"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("ngahau afe ki ʻolunga"),
            keywords: &["afe", "hake", "ngahau", "ngahau afe ki ʻolunga", "ʻolunga"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("yukarı kıvrımlı sağ ok"),
            keywords: &["ok", "yukarı kıvrımlı sağ ok"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئۈستىگە ئېگىلگەن ئوڭ كۆرسەتكۈچ"),
            keywords: &["ئۈستىگە ئېگىلگەن ئوڭ كۆرسەتكۈچ", "كۆرسەتكۈچ"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("стрілка вправо з вигином угору"),
            keywords: &[
                "стрілка",
                "стрілка вправо з вигином угору",
                "стрілка праворуч із поворотом угору",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("اوپر مڑتا ہوا دائیں تیر"),
            keywords: &["اوپر مڑتا ہوا دائیں تیر", "تیر", "سائن", "سمت"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("o‘ngdan yuqoriga qayrilish"),
            keywords: &["o‘ngdan yuqoriga qayrilish", "strelka"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("mũi tên phải cong lên"),
            keywords: &["mũi tên", "mũi tên phải cong lên"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("fettu ndijoor lemoo kaw"),
            keywords: &["fett", "fettu ndijoor lemoo kaw"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("utolo olusekunene olugobe phezulu"),
            keywords: &["utolo", "utolo olusekunene olugobe phezulu"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("àmì ìtó\u{329}sọ\u{301}nà o\u{329}lọ\u{301}fà apá ọ\u{300}tún onígun òkè"),
            keywords: &[
                "àmì ìtó\u{329}sọ\u{301}nà o\u{329}lọ\u{301}fà apá ọ\u{300}tún onígun òkè",
                "ọfà",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("向右箭咀彎向上"),
            keywords: &["向右箭咀彎向上", "箭咀"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("向右箭咀弯向上"),
            keywords: &["向右箭咀弯向上", "箭咀"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("右上弯箭头"),
            keywords: &["右上弯", "右上弯箭头", "向上弯曲的右箭头", "箭头"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("右上旋轉箭頭"),
            keywords: &["右上旋轉箭頭"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("向上彎嘅右箭嘴"),
            keywords: &["向上彎嘅右箭嘴"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("umcibisholo wakwesokudla ogobele phezulu"),
            keywords: &["umcibisholo", "umcibisholo wakwesokudla ogobele phezulu"],
        },
    ],
};
#[doc = "⤵\u{fe0f}"]
pub const RIGHT_ARROW_CURVING_DOWN: crate::Emoji = crate::Emoji {
    glyph: "⤵\u{fe0f}",
    codepoint: "2935 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "right arrow curving down",
    group: "Symbols",
    subgroup: "arrow",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "⤵",
        codepoint: "2935",
        status: crate::Status::Unqualified,
        introduction_version: 0.6f32,
        name: "right arrow curving down",
        group: "Symbols",
        subgroup: "arrow",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("pyl na regs buig af"),
            keywords: &["af", "krulpyl na regs onder", "pyl", "pyl na regs buig af"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ወደ ታች ታጣፊ ቀኝ ጠቋሚ ቀስት"),
            keywords: &["ቀስት", "ታች", "ወደ ታች ታጣፊ ቀኝ ጠቋሚ ቀስት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("سهم لأسفل من اليسار"),
            keywords: &["سهم", "سهم لأسفل من اليسار", "لأسفل"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some(
                "তললৈ ভ\u{9be}\u{981}জ লোৱ\u{9be} সো\u{981}ম\u{9c1}খী ক\u{9be}\u{981}ড\u{9bc}",
            ),
            keywords: &[
                "ক\u{9be}\u{981}ড\u{9bc}",
                "তললৈ ভ\u{9be}\u{981}জ লোৱ\u{9be} সো\u{981}ম\u{9c1}খী ক\u{9be}\u{981}ড\u{9bc}",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("aşağı dönən sağ ox"),
            keywords: &["aşağı", "aşağı dönən sağ ox", "ox"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("стрэлка ўправа з паваротам уніз"),
            keywords: &[
                "кірунак",
                "стрэлка",
                "стрэлка ўправа з паваротам уніз",
                "уніз",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("извита стрелка надясно и надолу"),
            keywords: &["извита стрелка надясно и надолу", "надолу", "стрелка"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ড\u{9be}ন তীর নীচের দিকে ব\u{9be}\u{981}ক\u{9be}নো"),
            keywords: &[
                "ড\u{9be}ন তীর নীচের দিকে ব\u{9be}\u{981}ক\u{9be}নো",
                "তীর",
                "নিম\u{9cd}নম\u{9c1}খী",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("strelica desno zakrivljena prema dolje"),
            keywords: &["strelica", "strelica desno zakrivljena prema dolje"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("fletxa dreta que gira cap avall"),
            keywords: &[
                "avall",
                "dreta",
                "fletxa",
                "fletxa dreta que gira cap avall",
                "gir",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᎦᏘᏏ ᎦᏝᏗ ᎠᏑᏲ ᎡᎳᏗᎠᎦᏘ"),
            keywords: &["ᎠᎦᏘᏏ ᎦᏝᏗ ᎠᏑᏲ ᎡᎳᏗᎠᎦᏘ", "ᎡᎳᏗᎠᎦᏘ", "ᎦᏝᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("šipka doprava stáčející se dolů"),
            keywords: &["dolů", "šipka", "šipka doprava stáčející se dolů"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("saeth i’r dde yn troi i lawr"),
            keywords: &["i lawr", "saeth", "saeth i’r dde yn troi i lawr"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("pil mod højre med sving nedad"),
            keywords: &["ned", "pil", "pil mod højre med sving nedad"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("geschwungener Pfeil nach unten"),
            keywords: &[
                "Pfeil",
                "geschwungen",
                "geschwungener Pfeil nach unten",
                "nach unten",
                "unten",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("δεξιό βέλος που στρίβει κάτω"),
            keywords: &["βέλος", "δεξιό βέλος που στρίβει κάτω", "κάτω"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("right arrow curving down"),
            keywords: &["arrow", "down", "right arrow curving down"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("flecha derecha curvándose hacia abajo"),
            keywords: &[
                "abajo",
                "curva",
                "dirección",
                "flecha",
                "flecha derecha curvándose hacia abajo",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("flecha de retorno al sur por la derecha"),
            keywords: &["flecha de retorno al sur por la derecha"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["abajo", "flecha", "flecha derecha curvándose hacia abajo"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kaardus nool alla"),
            keywords: &["alla", "kaardus nool alla", "nool"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("behera okertzen den eskuinera gezia"),
            keywords: &["behera", "behera okertzen den eskuinera gezia", "gezi"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("پیکان خمیده پایین راست"),
            keywords: &["پایین", "پیکان", "پیکان خمیده پایین راست"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("alas kääntyvä nuoli"),
            keywords: &["alas", "alas kääntyvä nuoli", "nuoli"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("pakanang arrow na kumurba pababa"),
            keywords: &[
                "arrow",
                "direksyon",
                "kurba",
                "pababa",
                "pakanan",
                "pakanang arrow na kumurba pababa",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("bogin pílur sum peikar niðureftir"),
            keywords: &["bogin", "bogin pílur sum peikar niðureftir", "pílur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("flèche courbe bas"),
            keywords: &["flèche", "flèche courbe bas"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("flèche courbe vers le bas"),
            keywords: &["courbe vers le bas", "flèche", "flèche courbe vers le bas"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("saighead dheas ag dul síos"),
            keywords: &["saighead", "saighead dheas ag dul síos", "síos"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("saighead dheas a’ lùbadh sìos"),
            keywords: &["saighead", "saighead dheas a’ lùbadh sìos", "sìos"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("frecha curvada cara abaixo"),
            keywords: &["abaixo", "curva", "frecha", "frecha curvada cara abaixo"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("નીચ\u{ac7} વળત\u{ac1}\u{a82} જમણ\u{ac1}\u{a82} તીર"),
            keywords: &["તીર", "નીચ\u{ac7} વળત\u{ac1}\u{a82} જમણ\u{ac1}\u{a82} તીર"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("kibiyar dama mai lanƙwasa ta ƙasa"),
            keywords: &["kibiya", "kibiyar dama mai lanƙwasa ta ƙasa", "ƙasa"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("חץ ימינה מתעקל מטה"),
            keywords: &["חץ", "חץ ימינה מתעקל מטה", "למטה", "מתעקל"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("नीच\u{947} की ओर म\u{941}ड\u{93c}ा दाया\u{901} तीर"),
            keywords: &["तीर", "नीच\u{947} की ओर म\u{941}ड\u{93c}ा दाया\u{901} तीर"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("desna strelica koja se zakrivljuje prema dolje"),
            keywords: &["desna strelica koja se zakrivljuje prema dolje", "strelica"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("lefelé görbülő jobb nyíl"),
            keywords: &["lefelé", "lefelé görbülő jobb nyíl", "nyíl"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ձախից ներքև թեքվող սլաք"),
            keywords: &["ձախից ներքև թեքվող սլաք", "ներքև", "սլաք"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("tanda panah kanan melengkung ke bawah"),
            keywords: &["bawah", "panah", "tanda panah kanan melengkung ke bawah"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ube-akanri na-eme mgbagọ dị ala"),
            keywords: &["ala", "ube", "ube-akanri na-eme mgbagọ dị ala"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("sveigð ör niður"),
            keywords: &["niður", "sveigð ör niður", "ör"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("freccia curva in basso"),
            keywords: &[
                "curva",
                "freccia",
                "freccia curva in basso",
                "verso il basso",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("下カーブ矢印"),
            keywords: &["カーブ", "下", "下カーブ矢印", "曲線", "矢印"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("panah nengen menggok mudhun"),
            keywords: &["panah", "panah nengen menggok mudhun"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ისარი, რომელიც იმრუდება მარჯვნიდან ქვემოთ"),
            keywords: &[
                "ისარი",
                "ისარი, რომელიც იმრუდება მარჯვნიდან ქვემოთ",
                "ქვემოთ",
            ],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("aneccab ayeffus yettin d akesser"),
            keywords: &["aneccab ayeffus yettin d akesser"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("оң жақтан шығып, төменге бұрылатын көрсеткі"),
            keywords: &[
                "көрсеткі",
                "оң жақтан шығып, төменге бұрылатын көрсеткі",
                "төмен",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("pil mod højre med sving nedad"),
            keywords: &["ned", "pil", "pil mod højre med sving nedad"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ព\u{17d2}រ\u{17bd}ញស\u{17d2}ដា\u{17c6}កោងច\u{17bb}ះក\u{17d2}រោម"),
            keywords: &[
                "ច\u{17bb}ះក\u{17d2}រោម",
                "ព\u{17d2}រ\u{17bd}ញ",
                "ព\u{17d2}រ\u{17bd}ញស\u{17d2}ដា\u{17c6}កោងច\u{17bb}ះក\u{17d2}រោម",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕ\u{cc6}ಳಕ\u{ccd}ಕ\u{cc6} ತ\u{cbf}ರುಗುವ ಬಲ ಬಾಣ"),
            keywords: &["ಕ\u{cc6}ಳಕ\u{ccd}ಕ\u{cc6} ತ\u{cbf}ರುಗುವ ಬಲ ಬಾಣ", "ಬಾಣ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("아래쪽으로 꺾어지는 우향 화살표"),
            keywords: &["아래쪽으로 꺾어지는 우향 화살표", "우회전", "화살표"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("उजवो बाण सकयल वळा"),
            keywords: &["उजवो बाण सकयल वळा", "बाण", "सकयल"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("оңдон төмөн ийилген жебе"),
            keywords: &["жебе", "оңдон төмөн ийилген жебе"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Rietsfeil mat Kéier no ënnen"),
            keywords: &["Feil", "Rietsfeil mat Kéier no ënnen", "no ënnen"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ລ\u{eb9}ກສອນໂຄ\u{ec9}ງຂວາລ\u{ebb}ງລ\u{eb8}\u{ec8}ມ"),
            keywords: &[
                "ຂວາ",
                "ລ\u{eb9}ກສອນ",
                "ລ\u{eb9}ກສອນໂຄ\u{ec9}ງຂວາລ\u{ebb}ງລ\u{eb8}\u{ec8}ມ",
                "ລ\u{ebb}ງລ\u{eb8}\u{ec8}ມ",
                "ໂຄ\u{ec9}ງ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("rodyklė į dešinę, užlenkta į apačią"),
            keywords: &["rodyklė", "rodyklė į dešinę, užlenkta į apačią", "į apačią"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("lejup vērsta izliekta bultiņa"),
            keywords: &["bultiņa", "lejup vērsta izliekta bultiņa"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pere matau piko iho"),
            keywords: &["iho", "pere", "pere matau piko iho"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("десна стрелка што врти надолу"),
            keywords: &["десна стрелка што врти надолу", "десно", "долу", "стрелка"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ത\u{d3e}ഴേക\u{d4d}ക\u{d4d} വളഞ\u{d4d}ഞ വലത\u{d4d} അമ\u{d4d}പടയ\u{d3e}ളം"),
            keywords: &[
                "അമ\u{d4d}പടയ\u{d3e}ളം",
                "ത\u{d3e}ഴേക\u{d4d}ക\u{d4d}",
                "ത\u{d3e}ഴേക\u{d4d}ക\u{d4d} വളഞ\u{d4d}ഞ വലത\u{d4d} അമ\u{d4d}പടയ\u{d3e}ളം",
                "വളവ\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("доошоо заасан баруун сум"),
            keywords: &["баруун", "доош", "доошоо заасан баруун сум", "сум"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("उजवा खाली वळल\u{947}ला बाण"),
            keywords: &["उजवा खाली वळल\u{947}ला बाण", "खाली", "बाण"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("anak panah ke kanan melengkung ke bawah"),
            keywords: &[
                "anak panah",
                "anak panah ke kanan melengkung ke bawah",
                "ke bawah",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("vleġġa leminija mgħawġa ’l isfel"),
            keywords: &["vleġġa", "vleġġa leminija mgħawġa ’l isfel", "’l isfel"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ညာည\u{103d}\u{103e}န\u{103a} အောက\u{103a}ဝ\u{102d}\u{102f}က\u{103a} မြား"),
            keywords: &[
                "ညာည\u{103d}\u{103e}န\u{103a} အောက\u{103a}ဝ\u{102d}\u{102f}က\u{103a} မြား",
                "မြား",
                "အောက\u{103a}ည\u{103d}\u{103e}န\u{103a}မြား",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("pil som bøyer ned"),
            keywords: &["ned", "pil", "pil som bøyer ned"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("तल मोड\u{947}को दाया\u{901} वाण"),
            keywords: &["तल", "तल मोड\u{947}को दाया\u{901} वाण", "वाण"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("pijl naar rechts die omlaag draait"),
            keywords: &["omlaag", "pijl", "pijl naar rechts die omlaag draait"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("pil som bøyer ned"),
            keywords: &["ned", "pil", "pil som bøyer ned"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଡ\u{b3e}ହ\u{b3e}ଣ ତୀର ତଳକ\u{b41} ମୋଡ\u{b3c}\u{b3f} ହେଉଛ\u{b3f}"),
            keywords: &[
                "ଡ\u{b3e}ହ\u{b3e}ଣ ତୀର ତଳକ\u{b41} ମୋଡ\u{b3c}\u{b3f} ହେଉଛ\u{b3f}",
                "ତଳ",
                "ତୀର",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਥ\u{a71}ਲ\u{a47} ਮ\u{a41}ੜਨ ਵਾਲਾ ਖ\u{a71}ਬਾ ਤੀਰ"),
            keywords: &["ਤੀਰ", "ਥ\u{a71}ਲ\u{a47} ਮ\u{a41}ੜਨ ਵਾਲਾ ਖ\u{a71}ਬਾ ਤੀਰ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("سجا تیر ہیٹھاں مڑدیاں ہوئیاں"),
            keywords: &["تیر", "سجا تیر ہیٹھاں مڑدیاں ہوئیاں", "ہیٹھاں"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Raít Áro Kọ\u{301}v Gó Daun"),
            keywords: &["Daun", "Raít Áro Kọ\u{301}v Gó Daun", "Áro"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("strzałka w prawo skręcająca w dół"),
            keywords: &[
                "strzałka",
                "strzałka w prawo skręcająca dół",
                "strzałka w prawo skręcająca w dół",
                "zakręt",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ښۍ غشی ښکته کوږ"),
            keywords: &["غشی", "ښکته", "ښۍ غشی ښکته کوږ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("seta para a direita curvada para baixo"),
            keywords: &[
                "curva",
                "seta curva de cima para baixo",
                "seta para a direita curvada para baixo",
                "seta para baixo",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("seta para a direita com curva para baixo"),
            keywords: &[
                "curva",
                "para baixo",
                "seta",
                "seta para a direita com curva para baixo",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("paña wach’i llink’uwan uranman"),
            keywords: &["paña wach’i llink’uwan uranman"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("săgeată dreapta curbată în jos"),
            keywords: &["jos", "săgeată", "săgeată dreapta curbată în jos"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-155"),
            keywords: &["E10-155"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("стрелка вправо с поворотом вниз"),
            keywords: &[
                "изгиб",
                "изогнутая стрелка",
                "поворот вниз",
                "стрелка вправо",
                "стрелка вправо с поворотом вниз",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umwambi w’iburyo uhetamiye hasi"),
            keywords: &["hasi", "umwambi", "umwambi w’iburyo uhetamiye hasi"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("هيٺ مڙندي ساڄي طرف تير"),
            keywords: &["تير", "هيٺ", "هيٺ مڙندي ساڄي طرف تير"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("පහළට රව\u{dd4}ම\u{dca} ව\u{dd6} දක\u{dd4}ණ\u{dd4} ඊතලය"),
            keywords: &[
                "ඊතලය",
                "පහළ",
                "පහළට රව\u{dd4}ම\u{dca} ව\u{dd6} දක\u{dd4}ණ\u{dd4} ඊතලය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("šípka doprava zakrivená nadol"),
            keywords: &["nadol", "šípka", "šípka doprava zakrivená nadol"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("puščica desno, ki se ukrivlja dol"),
            keywords: &["navzdol", "puščica", "puščica desno, ki se ukrivlja dol"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("fallaarta midig u qalloocsan hoos"),
            keywords: &["fallaar", "fallaarta midig u qalloocsan hoos"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("shigjetë djathtas e përkulur poshtë"),
            keywords: &["poshtë", "shigjetë", "shigjetë djathtas e përkulur poshtë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("стрелица која скреће надоле"),
            keywords: &["стрeлицa", "стрелица која скреће надоле"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("стрелица која скреће надоље"),
            keywords: &["стрелица која скреће надоље"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("strelica koja skreće nadole"),
            keywords: &["strelica", "strelica koja skreće nadole"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("strelica koja skreće nadolje"),
            keywords: &["strelica koja skreće nadolje"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("svängd nedåtpil"),
            keywords: &["nedåt", "pil", "sväng", "svängd nedåtpil"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mshale wa kulia unaopinda chini"),
            keywords: &["chini", "mshale", "mshale wa kulia unaopinda chini"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some(
                "க\u{bc0}ழ\u{bcd}நோக\u{bcd}கி வளைந\u{bcd}திருக\u{bcd}கும\u{bcd} வலது அம\u{bcd}புக\u{bcd}குறி",
            ),
            keywords: &[
                "அம\u{bcd}புக\u{bcd}குறி",
                "க\u{bc0}ழ\u{bcd}நோக\u{bcd}கி வளைந\u{bcd}த வலது அம\u{bcd}புக\u{bcd}குறி",
                "க\u{bc0}ழ\u{bcd}நோக\u{bcd}கி வளைந\u{bcd}திருக\u{bcd}கும\u{bcd} வலது அம\u{bcd}புக\u{bcd}குறி",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some(
                "క\u{c4d}ర\u{c3f}ంద\u{c3f}క\u{c3f} వంపు త\u{c3f}ర\u{c3f}గ\u{c3f}న కుడ\u{c3f} బ\u{c3e}ణం",
            ),
            keywords: &[
                "క\u{c4d}ర\u{c3f}ంద\u{c3f}క\u{c3f}",
                "క\u{c4d}ర\u{c3f}ంద\u{c3f}క\u{c3f} వంపు త\u{c3f}ర\u{c3f}గ\u{c3f}న కుడ\u{c3f} బ\u{c3e}ణం",
                "బ\u{c3e}ణం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("тири рости ба тарафи поён каҷшаванда"),
            keywords: &["поён", "тир", "тири рости ба тарафи поён каҷшаванда"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ล\u{e39}กศรโค\u{e49}งลง"),
            keywords: &["ลง", "ล\u{e39}กศร", "ล\u{e39}กศรโค\u{e49}งลง"],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("የማናይ ምልክት ናብ ታሕቲ ዝተጠውየ"),
            keywords: &["ምልክት", "ታሕቲ", "የማናይ ምልክት ናብ ታሕቲ ዝተጠውየ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("saga ok, aşak egrelýän"),
            keywords: &["aşak", "ok", "saga ok, aşak egrelýän"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("ngahau afe ki lalo"),
            keywords: &["afe", "hifo", "lalo", "ngahau", "ngahau afe ki lalo"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("aşağı kıvrımlı sağ ok"),
            keywords: &["aşağı", "aşağı kıvrımlı sağ ok", "ok"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئاستىغا ئېگىلگەن ئوڭ كۆرسەتكۈچ"),
            keywords: &["ئاستى", "ئاستىغا ئېگىلگەن ئوڭ كۆرسەتكۈچ", "كۆرسەتكۈچ"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("стрілка вправо з вигином униз"),
            keywords: &[
                "вниз",
                "стрілка",
                "стрілка вправо з вигином униз",
                "стрілка праворуч із поворотом униз",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("نیچے مڑتا ہوا دائیں تیر"),
            keywords: &["تیر", "سائن", "سمت", "نیچے مڑتا ہوا دائیں تیر"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("o‘ngdan pastga qayrilish"),
            keywords: &["o‘ngdan pastga qayrilish", "pastga", "strelka"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("mũi tên phải cong xuống"),
            keywords: &["mũi tên", "mũi tên phải cong xuống", "xuống"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("fettu ndijoor lemoo suuf"),
            keywords: &["fett", "fettu ndijoor lemoo suuf", "suuf"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("utolo olusekunene olugobe ezantsi"),
            keywords: &["ezantsi", "utolo", "utolo olusekunene olugobe ezantsi"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some(
                "àmì ìtó\u{329}sọ\u{301}nà o\u{329}lọ\u{301}fà apá ọ\u{300}tún onígun ìsàlẹ\u{300}",
            ),
            keywords: &[
                "ilẹ\u{300}",
                "o\u{329}fà",
                "àmì ìtó\u{329}sọ\u{301}nà o\u{329}lọ\u{301}fà apá ọ\u{300}tún onígun ìsàlẹ\u{300}",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("向右箭咀彎向下"),
            keywords: &["向下", "向右箭咀彎向下", "箭咀"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("向右箭咀弯向下"),
            keywords: &["向下", "向右箭咀弯向下", "箭咀"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("右下弯箭头"),
            keywords: &["右下弯", "右下弯箭头", "向下弯曲的右箭头", "箭头"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("右下旋轉箭頭"),
            keywords: &["右下旋轉箭頭"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("向下彎嘅右箭嘴"),
            keywords: &["向下彎嘅右箭嘴"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("umcibisholo wakwesokudla ogobele phansi"),
            keywords: &[
                "phansi",
                "umcibisholo",
                "umcibisholo wakwesokudla ogobele phansi",
            ],
        },
    ],
};
#[doc = "🔃"]
pub const CLOCKWISE_VERTICAL_ARROWS: crate::Emoji = crate::Emoji {
    glyph: "🔃",
    codepoint: "1F503",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "clockwise vertical arrows",
    group: "Symbols",
    subgroup: "arrow",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("kloksgewyse vertikale pyle"),
            keywords: &["herlaai", "kloksgewys", "kloksgewyse vertikale pyle", "pyl"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("በሰዓት አዟዟር አቅጣጫ ያሉ ቀጥ ያሉ ቀስቶች"),
            keywords: &[
                "ቀስት",
                "በሰዓት አቆጣጠር አቅጣጫ",
                "በሰዓት አዟዟር አቅጣጫ ያሉ ቀጥ ያሉ ቀስቶች",
                "ዳግም ጫን",
            ],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("سهمان رأسيان مع عقارب الساعة"),
            keywords: &[
                "أسهم رأسية مع عقارب الساعة",
                "أسهم عمودية باتجاه عقارب الساعة",
                "سهمان رأسيان مع عقارب الساعة",
                "علامة إعادة تحميل",
            ],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some(
                "ঘড\u{9bc}ী ক\u{9be}\u{981}ট\u{9be}ৰ দিশৰ উলম\u{9cd}ব ক\u{9be}\u{981}ড\u{9bc}",
            ),
            keywords: &[
                "ক\u{9be}\u{981}ড\u{9bc}",
                "ঘড\u{9bc}ী ক\u{9be}\u{981}ট\u{9be}ৰ দিশৰ উলম\u{9cd}ব ক\u{9be}\u{981}ড\u{9bc}",
                "ঘড\u{9bc}ীৰ ক\u{9be}\u{981}ট\u{9be}ৰ দিশৰ",
                "প\u{9c1}নঃলোড",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("saat istiqamətində yönəlmiş şaquli ox"),
            keywords: &[
                "ox",
                "saat istiqaməti",
                "saat istiqamətində yönəlmiş şaquli ox",
                "yenidən yüklə",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("вертыкальныя стрэлкі па гадзіннікавай стрэлцы"),
            keywords: &[
                "вертыкальныя стрэлкі па гадзіннікавай стрэлцы",
                "па гадзіннікавай стрэлцы",
                "перазагрузіць",
                "стрэлка",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("вертикални стрелки по часовниковата стрелка"),
            keywords: &[
                "вертикални стрелки по часовниковата стрелка",
                "по часовниковата стрелка",
                "презареждане",
                "стрелка",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ঘড\u{9bc}ির ক\u{9be}\u{981}ট\u{9be}র উল\u{9cd}লম\u{9cd}ব তীর"),
            keywords: &[
                "ঘড\u{9bc}ির ক\u{9be}\u{981}ট\u{9be}র উল\u{9cd}লম\u{9cd}ব তীর",
                "ঘড\u{9bc}ির ক\u{9be}\u{981}ট\u{9be}র দিকে",
                "তীর",
                "প\u{9c1}নর\u{9be}য\u{9bc} লোড",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("strelice vertikalno kretanje kazaljki na satu"),
            keywords: &[
                "smjer kretanja kazaljki na satu",
                "strelica",
                "strelice vertikalno kretanje kazaljki na satu",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("fletxes que giren cap a la dreta"),
            keywords: &[
                "dreta",
                "fletxes",
                "fletxes que giren cap a la dreta",
                "fletxes verticals en sentit horari",
                "gir",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎪᏪᎵ ᏗᎦᏂᏱᏙᏗ"),
            keywords: &["ᎦᏝᏗ", "ᎪᏪᎵ ᏗᎦᏂᏱᏙᏗ", "ᏙᎪᏢᎯᏐᏗ", "ᏩᏥ ᎤᏪᏅᏍᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("svislé šipky ve směru hodinových ručiček"),
            keywords: &[
                "doprava",
                "hodin",
                "načtení",
                "načíst",
                "nové",
                "opětovné",
                "ručiček",
                "směr",
                "směru",
                "svislé šipky ve směru hodinových ručiček",
                "znovu",
                "šipka",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("saethau clocwedd fertigol"),
            keywords: &[
                "ail-lwytho",
                "clocwedd",
                "saeth",
                "saethau clocwedd fertigol",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("lodrette cirkulære pile med uret"),
            keywords: &[
                "cirkulære pile",
                "genindlæs",
                "lodrette cirkulære pile med uret",
                "lodrette pile",
                "med uret",
                "vertikale pile",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("kreisförmige Pfeile im Uhrzeigersinn"),
            keywords: &[
                "Pfeile",
                "im Uhrzeigersinn",
                "kreisförmige Pfeile im Uhrzeigersinn",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("δεξιόστροφα κάθετα βέλη"),
            keywords: &[
                "βέλος",
                "δεξιόστροφα κάθετα βέλη",
                "δεξιόστροφο",
                "επαναφόρτωση",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("clockwise vertical arrows"),
            keywords: &["arrow", "clockwise", "clockwise vertical arrows", "reload"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("flechas verticales en sentido horario"),
            keywords: &[
                "flechas",
                "flechas verticales en sentido horario",
                "flechas verticales sentido horario",
                "horario",
                "señal de recarga",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &[
                "flecha",
                "flechas verticales en sentido horario",
                "recarga",
                "sentido horario",
            ],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("vertikaalsed nooled päripäeva"),
            keywords: &[
                "laadimine",
                "nool",
                "päripäeva",
                "vertikaalsed nooled päripäeva",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("eskuinera gezi bertikalak"),
            keywords: &[
                "berriro",
                "eskuinera",
                "eskuinera gezi bertikalak",
                "gezi",
                "kargatu",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("جهت عقربه\u{200c}های ساعت"),
            keywords: &[
                "تازه\u{200c}سازی",
                "جهت حرکت عقربه\u{200c}های ساعت",
                "جهت عقربه\u{200c}های ساعت",
                "پیکان",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("pystynuolet myötäpäivään"),
            keywords: &[
                "myötäpäivään",
                "nuoli",
                "pystynuolet myötäpäivään",
                "päivitä",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("mga clockwise na patayong arrow"),
            keywords: &[
                "arrow",
                "clockwise",
                "mga clockwise na patayong arrow",
                "patayo",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("loddrættir pílar sum ganga við urinum"),
            keywords: &[
                "loddrættir pílar sum ganga við urinum",
                "lodrættir",
                "pílar",
                "við urinum",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("flèches dans le sens horaire"),
            keywords: &[
                "flèche",
                "flèches dans le sens horaire",
                "sens horaire",
                "symbole Recharger",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("flèches verticales dans le sens horaire"),
            keywords: &[
                "flèche",
                "flèches verticales dans le sens horaire",
                "horaire",
                "recharger",
                "sens des aiguilles d’une montre",
                "vertical",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("saigheada ingéaracha ar deiseal"),
            keywords: &[
                "athlódáil",
                "ciorcal saighead",
                "saigheada",
                "saigheada deisil ingearacha",
                "saigheada ingéaracha ar deiseal",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("saighdean inghearach a’ dol deiseil"),
            keywords: &[
                "ath-luchdadh",
                "ath-luchdaich",
                "deiseil",
                "saighdean inghearach a’ dol deiseil",
                "saighead",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("frechas verticais xirando cara á dereita"),
            keywords: &[
                "frechas",
                "frechas verticais xirando cara á dereita",
                "sentido das agullas do reloxo",
                "xirar",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ઊભા દક\u{acd}ષિણાવર\u{acd}તી તીર"),
            keywords: &[
                "ઊભા દક\u{acd}ષિણાવર\u{acd}તી તીર",
                "તીર",
                "ફરીથી લોડ કરો",
                "ફરીથી લોડ કરોન\u{ac1}\u{a82} ચિહ\u{acd}ન",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("kibiyoyi a tsaye ta hannun dama"),
            keywords: &[
                "kibiya",
                "kibiyoyi a tsaye ta hannun dama",
                "sake loda",
                "ta hannun dama",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("חצים אנכיים מתעקלים בכיוון השעון"),
            keywords: &[
                "חצים",
                "חצים אנכיים מתעקלים בכיוון השעון",
                "טעינה מחדש",
                "מעגל",
            ],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("घड\u{93c}ी की दिशा म\u{947}\u{902} ल\u{902}बवत तीर"),
            keywords: &[
                "घड\u{93c}ी की दिशा म\u{947}\u{902} ल\u{902}बवत तीर",
                "तीर",
                "दक\u{94d}षिणावर\u{94d}त",
                "रिलोड",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("okomite strelice u smjeru kazaljki na satu"),
            keywords: &[
                "okomite strelice u smjeru kazaljki na satu",
                "ponovno učitavanje",
                "smjer kazaljki na satu",
                "strelica",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("óramutató járásával megegyező irányú függőleges nyilak"),
            keywords: &[
                "nyíl",
                "óramutató járásával megegyező",
                "óramutató járásával megegyező irányú függőleges nyilak",
                "újratöltés",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ժամասլաքի ուղղությամբ ուղղահայաց սլաքներ"),
            keywords: &[
                "ժամասլաքի ուղղությամբ",
                "ժամասլաքի ուղղությամբ ուղղահայաց սլաքներ",
                "սլաք",
                "վերաբեռնել",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("tanda panah searah jarum jam"),
            keywords: &[
                "muat ulang",
                "panah",
                "searah jarum jam",
                "tanda panah searah jarum jam",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("njem okirikiri àkụ kwụọtọ"),
            keywords: &[
                "dọnyegharịa",
                "njem okirikiri",
                "njem okirikiri àkụ kwụọtọ",
                "ube",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("endurhlaða"),
            keywords: &[
                "endurhlaða",
                "endurhleðslutákn",
                "lóðréttar réttsælisörvar",
                "örvar",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("frecce verticali che ruotano in senso orario"),
            keywords: &[
                "frecce",
                "frecce a cerchio verticali",
                "frecce verticali che ruotano in senso orario",
                "frecce verticali senso orario",
                "ricarica",
                "simbolo ricarica",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("右回り縦矢印"),
            keywords: &["リロード", "右回り", "右回り縦矢印", "時計回り", "矢印"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("panah ngadeg arahe padha ubenge jam"),
            keywords: &[
                "arah ubenge jam",
                "ngisi maneh",
                "panah",
                "panah ngadeg arahe padha ubenge jam",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ვერტიკალური ისრები საათის მიმართულებით"),
            keywords: &[
                "გადატვირთვა",
                "ვერტიკალური ისრები საათის მიმართულებით",
                "ისარი",
                "საათის ისრის მიმართულებით",
            ],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("ineccaben tanila n isegnan n temrilt"),
            keywords: &["ineccaben tanila n isegnan n temrilt"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("сағат тілі бойынша тік көрсеткілер"),
            keywords: &[
                "көрсеткі",
                "сағат тілі бойынша",
                "сағат тілі бойынша тік көрсеткілер",
                "қайта жүктеу",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("genindlæse"),
            keywords: &["genindlæse", "genindlæse-tegn", "vertikale pile med uret"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some(
                "ព\u{17d2}រ\u{17bd}ញបញ\u{17d2}ឈវវ\u{17b7}លតាមទ\u{17b7}ស\u{200b}ទ\u{17d2}រន\u{17b7}ចនាឡ\u{17b7}កា",
            ),
            keywords: &[
                "ទ\u{17b7}ស",
                "ទ\u{17b7}សដៅ",
                "ព\u{17d2}រ\u{17bd}ញ",
                "ព\u{17d2}រ\u{17bd}ញបញ\u{17d2}ឈវវ\u{17b7}លតាមទ\u{17b7}ស\u{200b}ទ\u{17d2}រន\u{17b7}ចនាឡ\u{17b7}កា",
                "ព\u{17d2}រ\u{17bd}ញវ\u{17b7}លបញ\u{17d2}ឈរតាមទ\u{17d2}រន\u{17b7}ចនាឡ\u{17b7}កាក\u{17d2}ន\u{17bb}ងរាងប\u{17bd}ងជ\u{17d2}រ\u{17bb}ង",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಪ\u{ccd}ರದಕ\u{ccd}ಷ\u{cbf}ಣವಾಗ\u{cbf} ವರ\u{ccd}ಟ\u{cbf}ಕಲ\u{ccd} ಬಾಣಗಳು"),
            keywords: &[
                "ಪ\u{ccd}ರದಕ\u{ccd}ಷ\u{cbf}ಣವಾಗ\u{cbf} ವರ\u{ccd}ಟ\u{cbf}ಕಲ\u{ccd} ಬಾಣಗಳು",
                "ಬಾಣಗಳು",
                "ರ\u{cbf}ಲೋಡ\u{ccd} ಚ\u{cbf}ಹ\u{ccd}ನ\u{cc6}",
                "ವರ\u{ccd}ಟ\u{cbf}ಕಲ\u{ccd} ಕ\u{ccd}ಲಾಕ\u{ccd}\u{200c}ವೈಸ\u{ccd} ಬಾಣಗಳು",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("시계 방향 화살표"),
            keywords: &["새로고침", "새로고침 표시", "시계 방향 화살표", "화살표"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("सव\u{94d}य उब\u{947} बाण"),
            keywords: &[
                "उजव\u{94d}या दिश\u{947}न वचपी बाण",
                "बाण",
                "रिलोड",
                "सव\u{94d}य",
                "सव\u{94d}य उब\u{947} बाण",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("саат жебеси менен тик турган жебелер"),
            keywords: &[
                "жебе",
                "саат жебеси",
                "саат жебеси менен тик турган жебелер",
            ],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("vertikal Feiler an Zärerichtung"),
            keywords: &[
                "Feil",
                "an Zärerichtung",
                "opzéien",
                "vertikal Feiler an Zärerichtung",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ລ\u{eb9}ກສອນຕາມທ\u{eb4}ດເຂ\u{eb1}ມໂມງ"),
            keywords: &[
                "ທ\u{eb4}ດເຂ\u{eb1}ມໂມງ",
                "ລ\u{eb9}ກສອນ",
                "ລ\u{eb9}ກສອນຕາມທ\u{eb4}ດເຂ\u{eb1}ມໂມງ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("vertikalios laikrodžio rodyklės kryptimis nukreiptos rodyklės"),
            keywords: &[
                "pagal laikrodžio rodyklę",
                "rodyklė",
                "vertikalios laikrodžio rodyklės kryptimis nukreiptos rodyklės",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("pulksteņrādītāja virzienā vērstas vertikālas bultiņas"),
            keywords: &[
                "bultiņa",
                "pulksteņrādītāja virzienā",
                "pulksteņrādītāja virzienā vērstas vertikālas bultiņas",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pere poutū whakatekaraka"),
            keywords: &[
                "pere",
                "pere poutū whakatekaraka",
                "uta anō",
                "whakatekaraka",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("вертикални стрелки што вртат надесно"),
            keywords: &[
                "вертикални стрелки што вртат надесно",
                "десно",
                "стрелки",
                "часовник",
            ],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഘടിക\u{d3e}ര ദിശയില\u{d41}ള\u{d4d}ള അമ\u{d4d}പടയ\u{d3e}ളങ\u{d4d}ങൾ"),
            keywords: &[
                "അമ\u{d4d}പടയ\u{d3e}ളം",
                "ഘടിക\u{d3e}ര ദിശയില\u{d41}ള\u{d4d}ള അമ\u{d4d}പടയ\u{d3e}ളങ\u{d4d}ങൾ",
                "ഘടിക\u{d3e}ര ദിശയില\u{d41}ള\u{d4d}ള രണ\u{d4d}ട\u{d4d} ആരോകൾ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("цагийн зүүний босоо сум"),
            keywords: &["босоо", "сум", "цагийн зүү", "цагийн зүүний босоо сум"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some(
                "घड\u{94d}\u{200d}याळाच\u{94d}या दिश\u{947}त असल\u{947}ल\u{947} अन\u{941}ल\u{902}ब बाण",
            ),
            keywords: &[
                "घड\u{94d}याळाच\u{94d}या दिश\u{947}त",
                "घड\u{94d}\u{200d}याळाच\u{94d}या दिश\u{947}त असल\u{947}ल\u{947} अन\u{941}ल\u{902}ब बाण",
                "बाण",
                "रीलोड करा",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("anak panah menegak ikut jam"),
            keywords: &[
                "anak panah",
                "anak panah menegak ikut jam",
                "ikut arah jam",
                "muat semula",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("vleġeġ vertikali favur l-arloġġ"),
            keywords: &[
                "favur l-arloġġ",
                "terġa’ ttella’",
                "vleġeġ vertikali favur l-arloġġ",
                "vleġġa",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ညာရစ\u{103a} ဒေါင\u{103a}လ\u{102d}\u{102f}က\u{103a}ပြ မြားများ"),
            keywords: &[
                "ညာရစ\u{103a} ဒေါင\u{103a}လ\u{102d}\u{102f}က\u{103a}ပြ မြားများ",
                "နာရ\u{102e}လက\u{103a}တ\u{1036}လားရာ",
                "နာရ\u{102e}လက\u{103a}တ\u{1036}လားရာအတ\u{102d}\u{102f}င\u{103a}း ညာရစ\u{103a}ပြ ဒေါင\u{103a}လ\u{102d}\u{102f}က\u{103a} မြားများ",
                "မြား",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("vertikale piler med klokken"),
            keywords: &["last inn på nytt", "piler", "vertikale piler med klokken"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("घडीको दिशातिर ठाडो वाणहर\u{942}"),
            keywords: &[
                "घडीको दिशा तिर",
                "घडीको दिशातिर ठाडो वाणहर\u{942}",
                "प\u{941}नः लोड",
                "वाण",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("verticale pijlen met de klok mee"),
            keywords: &[
                "met de klok mee",
                "opnieuw laden",
                "pijl",
                "verticale pijlen met de klok mee",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("vertikale piler med klokka"),
            keywords: &["last inn på nytt", "piler", "vertikale piler med klokka"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some(
                "ଘଣ\u{b4d}ଟ\u{b3e}କଣ\u{b4d}ଟ\u{b3e} ଘ\u{b42}ର\u{b3f}ବ\u{b3e} ଦ\u{b3f}ଗରେ ଭ\u{b42}ଲମ\u{b4d}ବ ତୀରଗ\u{b41}ଡ\u{b3c}\u{b3f}କ",
            ),
            keywords: &[
                "ଘଣ\u{b4d}ଟ\u{b3e}କଣ\u{b4d}ଟ\u{b3e} ଘ\u{b42}ର\u{b3f}ବ\u{b3e} ଦ\u{b3f}ଗରେ",
                "ଘଣ\u{b4d}ଟ\u{b3e}କଣ\u{b4d}ଟ\u{b3e} ଘ\u{b42}ର\u{b3f}ବ\u{b3e} ଦ\u{b3f}ଗରେ ଭ\u{b42}ଲମ\u{b4d}ବ ତୀରଗ\u{b41}ଡ\u{b3c}\u{b3f}କ",
                "ତୀର",
                "ପ\u{b41}ନଃଲୋଡ\u{b4d}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਘੜੀ ਦੀ ਦਿਸ\u{a3c}ਾ ਵਿ\u{a71}ਚ ਲ\u{a70}ਬਕਾਰੀ ਤੀਰ"),
            keywords: &[
                "ਘੜੀ ਦੀ ਦਿਸ\u{a3c}ਾ ਵਿ\u{a71}ਚ ਲ\u{a70}ਬਕਾਰੀ ਤੀਰ",
                "ਤੀਰ",
                "ਰੀਲ\u{a4b}ਡ",
                "ਰੀਲ\u{a4b}ਡ ਨਿਸ\u{a3c}ਾਨ",
                "ਲ\u{a70}ਬਕਾਰੀ ਘੜੀ ਦੀ ਦਿਸ\u{a3c}ਾ ਵਿ\u{a71}ਚ ਤੀਰ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("گھڑی وار عمودی تیر"),
            keywords: &["تیر", "فیر لوڈ کرنا", "گھڑی وار", "گھڑی وار عمودی تیر"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Aro-dẹm De Múv Klọ\u{301}k Hánd Dairẹ\u{301}kshọn"),
            keywords: &[
                "Aro-dẹm De Múv Klọ\u{301}k Hánd Dairẹ\u{301}kshọn",
                "Klọ\u{301}k Hánd Dairẹ\u{301}kshọn",
                "Rilod",
                "Áro",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("pionowe strzałki zgodne z ruchem wskazówek zegara"),
            keywords: &[
                "odśwież",
                "okrężny",
                "pionowe strzałki zgodne z ruchem wskazówek zegara",
                "pionowe strzałki zgodnie z ruchem wskazówek zegara",
                "strzałka",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("کلاک وايز عمودي غشي"),
            keywords: &["بيا لوډ", "غشي", "کلاک وايز", "کلاک وايز عمودي غشي"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("setas verticais no sentido horário"),
            keywords: &[
                "recarregar",
                "sentido horário",
                "seta",
                "setas verticais no sentido horário",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("setas verticais no sentido dos ponteiros do relógio"),
            keywords: &[
                "recarregar",
                "sentido dos ponteiros do relógio",
                "seta",
                "setas verticais no sentido dos ponteiros do relógio",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("Sayanpa wachʼikuna phani qatichkanku"),
            keywords: &["Sayanpa wachʼikuna phani qatichkanku"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("săgeți verticale în sens orar"),
            keywords: &[
                "reîncărcare",
                "sensul acelor de ceasornic",
                "săgeți",
                "săgeți verticale în sens orar",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-703"),
            keywords: &["E10-703"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("по часовой стрелке"),
            keywords: &[
                "вертикальные стрелки",
                "замкнутые вертикальные стрелки",
                "замкнутые стрелки",
                "по часовой стрелке",
                "стрелки",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("utwambi duhagaritse tureba mu cyerekezo cy’inshinge z’isaha"),
            keywords: &[
                "kongera gushyiramo",
                "ukurikije icyerekezo nk’inshinge z’isaha",
                "umwambi",
                "utwambi duhagaritse tureba mu cyerekezo cy’inshinge z’isaha",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڪلاڪ وانگي عمودي تير"),
            keywords: &["تير", "ريلوڊ", "ڪلاڪ وانگي", "ڪلاڪ وانگي عمودي تير"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("දක\u{dca}ෂ\u{dd2}ණ\u{dcf}වර\u{dca}ත ස\u{dd2}රස\u{dca} ඊතල"),
            keywords: &[
                "ඊතලය",
                "දක\u{dca}ෂ\u{dd2}ණ\u{dcf}වර\u{dca}ත",
                "දක\u{dca}ෂ\u{dd2}ණ\u{dcf}වර\u{dca}ත ස\u{dd2}රස\u{dca} ඊතල",
                "නැවත ප\u{dd6}රණය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("zvislé šípky v smere hodinových ručičiek"),
            keywords: &[
                "v smere hodinových ručičiek",
                "znovu načítať",
                "zvislé šípky v smere hodinových ručičiek",
                "šípka",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("navpični puščici, ki se ukrivljata v smeri urnega kazalca"),
            keywords: &[
                "navpični puščici, ki se ukrivljata v smeri urinega kazalca",
                "navpični puščici, ki se ukrivljata v smeri urnega kazalca",
                "puščica",
                "smer urinega kazalca",
                "vnovično nalaganje",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("fallaarada taaggan ee saacad-wareegga"),
            keywords: &[
                "dib -usoo kicinta",
                "fallaar",
                "fallaarada taaggan ee saacad-wareegga",
                "saacad-wareeg",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("shigjeta vertikale orare"),
            keywords: &[
                "orar",
                "orare",
                "ringarko",
                "shigjeta vertikale orare",
                "shigjetë",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("стрелице које се врте удесно"),
            keywords: &[
                "пoнoвнo учитaвaњe",
                "смер кaзaљке нa сaту",
                "стрeлицa",
                "стрелице које се врте удесно",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["стрелице које се врте удесно"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("strelice koje se vrte udesno"),
            keywords: &[
                "ponovno učitavanje",
                "smer kazaljke na satu",
                "strelica",
                "strelice koje se vrte udesno",
            ],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["strelice koje se vrte udesno"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("vertikala pilar medurs"),
            keywords: &[
                "pilar",
                "pilar medurs",
                "uppdateringssymbol",
                "vertikala pilar medurs",
            ],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mishale wima inayoelekeza kwa mzunguko wa akrabu"),
            keywords: &[
                "mishale wima inayoelekeza kwa mzunguko wa akrabu",
                "mshale",
                "mzunguko wa akrabu",
                "pakia upya",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("வலஞ\u{bcd}சுழி அம\u{bcd}புக\u{bcd}குறிகள\u{bcd} பொத\u{bcd}த\u{bbe}ன\u{bcd}"),
            keywords: &[
                "புதுப\u{bcd}பிப\u{bcd}பு",
                "ம\u{bbe}ற\u{bcd}று",
                "ர\u{bc0}லோட\u{bcd} சிம\u{bcd}பல\u{bcd}",
                "வலஞ\u{bcd}சுழி அம\u{bcd}புக\u{bcd}குறிகள\u{bcd} பொத\u{bcd}த\u{bbe}ன\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("సవ\u{c4d}యద\u{c3f}శల\u{c4b} న\u{c3f}లువు బ\u{c3e}ణ\u{c3e}లు"),
            keywords: &[
                "మళ\u{c4d}ల\u{c40} ల\u{c4b}డ\u{c4d} చ\u{c47}య\u{c3f}",
                "ర\u{c40}ల\u{c4b}డ\u{c4d} చ\u{c3f}హ\u{c4d}నం",
                "సవ\u{c4d}యద\u{c3f}శల\u{c4b} న\u{c3f}లువు బ\u{c3e}ణ\u{c3e}లు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("тирҳои амудии самти ҳаракати ақрабҳои соат"),
            keywords: &[
                "аз нав бор кардан",
                "самти ҳаракати ақрабҳо соат",
                "тир",
                "тирҳои амудии самти ҳаракати ақрабҳои соат",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ส\u{e31}ญล\u{e31}กษณ\u{e4c}โหลดซ\u{e49}ำ"),
            keywords: &[
                "ซ\u{e49}ำ",
                "ตามเข\u{e47}มนาฬ\u{e34}กา",
                "ล\u{e39}กศร",
                "ส\u{e31}ญล\u{e31}กษณ\u{e4c}โหลดซ\u{e49}ำ",
                "โหลด",
            ],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ከመ ሰዓት ዝዘውር ትኹል ምልክት"),
            keywords: &["ምልክት", "እንደገና ምጽዓን", "ከመ ሰዓት", "ከመ ሰዓት ዝዘውር ትኹል ምልክት"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("sagadyň ugruna dik oklar"),
            keywords: &[
                "gaýtadan ýükle",
                "ok",
                "sagadyň ugruna",
                "sagadyň ugruna dik oklar",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("ngahau vilovilo toʻomataʻu"),
            keywords: &["mataʻu", "ngahau", "ngahau vilovilo toʻomataʻu", "vilovilo"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("saat yönünde dönen oklar"),
            keywords: &[
                "oklar",
                "saat yönünde dikey oklar",
                "saat yönünde dönen oklar",
                "saat yönüne dönen oklar",
                "yeniden yükle işareti",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("سائەت يۆنىلىشىدىكى تىك كۆرسەتكۈچ"),
            keywords: &[
                "سائەت يۆنىلىشى",
                "سائەت يۆنىلىشىدىكى تىك كۆرسەتكۈچ",
                "قايتا يۈكلەش",
                "كۆرسەتكۈچ",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("вертикальні стрілки за ходом годинника"),
            keywords: &[
                "вертикальні стрілки за ходом годинника",
                "за годинниковою стрілкою",
                "перезавантажити",
                "стрілка",
                "стрілки по колу за годинниковою стрілкою",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("گھڑی کی سمت میں عمودی تیر"),
            keywords: &[
                "تیر",
                "سائن",
                "سمت",
                "گھڑی کی سمت",
                "گھڑی کی سمت میں عمودی تیر",
            ],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("soat mili yo‘nalishi bo‘yicha"),
            keywords: &["chiziq", "qayta yuklash", "soat mili yo‘nalishi bo‘yicha"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("mũi tên thẳng đứng theo chiều kim đồng hồ"),
            keywords: &[
                "chiều kim đồng hồ",
                "mũi tên",
                "mũi tên thẳng đứng theo chiều kim đồng hồ",
                "tải lại",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("fett yu ci yoonu montar"),
            keywords: &[
                "ci yoonu montar",
                "fett",
                "fett yu ci yoonu montar",
                "yabaat",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("amatolo athe nkqo ajikeleza ngasekunene"),
            keywords: &[
                "amatolo athe nkqo ajikeleza ngasekunene",
                "jikeleza ngasekunene",
                "layisha kwakhona",
                "utolo",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("awọn ọfa yiyi ọna ago"),
            keywords: &[
                "awọn ọfa yiyi ọna ago",
                "àmì ìtó\u{329}sọ\u{301}nà o\u{329}lọ\u{301}fà",
                "àtúngbé",
                "ọlọ\u{301}wọ\u{301}-aago",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("順時針垂直箭咀"),
            keywords: &["箭咀", "重新載入", "順時針", "順時針垂直箭咀"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("顺时针垂直箭咀"),
            keywords: &["箭咀", "重新载入", "顺时针", "顺时针垂直箭咀"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("顺时针垂直箭头"),
            keywords: &["方向", "标识", "重新载入", "顺时针垂直箭头"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("順時針方向"),
            keywords: &["順時針", "順時針方向"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("順時針方向垂直嘅箭嘴"),
            keywords: &["順時針方向", "順時針方向垂直嘅箭嘴"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("imicibisholo ejikelezela ngakwesokudla"),
            keywords: &[
                "faka kabusha",
                "imicibisholo ejikelezela ngakwesokudla",
                "jikelezela ngakwesokudla",
                "umcisholo",
            ],
        },
    ],
};
#[doc = "🔄"]
pub const COUNTERCLOCKWISE_ARROWS_BUTTON: crate::Emoji = crate::Emoji {
    glyph: "🔄",
    codepoint: "1F504",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "counterclockwise arrows button",
    group: "Symbols",
    subgroup: "arrow",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("knoppie vir teenkloksgewyse pyle"),
            keywords: &[
                "agteruit",
                "antikloksgewys",
                "knoppie",
                "knoppie vir teenkloksgewyse pyle",
                "pyl",
                "teenkloksgewys",
                "teenkloksgewyse pyle",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("በሰዓት አዟዟር አቅጣጫ ተቃራኒ ያሉ ቀስቶች አዝራር"),
            keywords: &[
                "ቀስት",
                "በሰዓት አቆጣጠር አቅጣጫ ተቃራኒ",
                "በሰዓት አዟዟር አቅጣጫ ተቃራኒ ያሉ ቀስቶች አዝራር",
                "ኋልዮሽ",
            ],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("زر عكس اتجاه عقارب الساعة"),
            keywords: &[
                "أسهم",
                "زر عكس اتجاه عقارب الساعة",
                "عكس اتجاه عقارب الساعة",
            ],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some(
                "ঘড\u{9bc}ী ক\u{9be}\u{981}ট\u{9be}ৰ বিপৰীত দিশৰ উলম\u{9cd}ব ক\u{9be}\u{981}ড\u{9bc}",
            ),
            keywords: &[
                "ক\u{9be}\u{981}ড\u{9bc}",
                "ঘড\u{9bc}ী ক\u{9be}\u{981}ট\u{9be}ৰ দিশৰ উলম\u{9cd}ব ক\u{9be}\u{981}ড\u{9bc} ব\u{9c1}ট\u{9be}ম",
                "ঘড\u{9bc}ী ক\u{9be}\u{981}ট\u{9be}ৰ বিপৰীত দিশৰ উলম\u{9cd}ব ক\u{9be}\u{981}ড\u{9bc}",
                "ঘড\u{9bc}ীৰ ক\u{9be}\u{981}ট\u{9be}ৰ বিপৰীত দিশ",
                "ব\u{9be}ম\u{9be}ৱৰ\u{9cd}তী",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("saat istiqamətinin əksinə yönəlmiş oxlar düyməsi"),
            keywords: &[
                "ox",
                "saat istiqaməti əksinə",
                "saat istiqamətinin əksinə yönəlmiş oxlar düyməsi",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("кнопка са стрэлкамі супраць гадзіннікавай стрэлкі"),
            keywords: &[
                "абнавіць",
                "кнопка",
                "кнопка са стрэлкамі супраць гадзіннікавай стрэлкі",
                "стрэлка",
                "супраць гадзіннікавай стрэлкі",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("бутон със стрелки срещу часовниковата стрелка"),
            keywords: &[
                "бутон със стрелки срещу часовниковата стрелка",
                "срещу часовниковата стрелка",
                "стрелка",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ঘড\u{9bc}ির ক\u{9be}\u{981}ট\u{9be}র বিপরীতে তীর বোত\u{9be}ম"),
            keywords: &[
                "ঘড\u{9bc}ির ক\u{9be}\u{981}ট\u{9be}র বিপরীত দিকে",
                "ঘড\u{9bc}ির ক\u{9be}\u{981}ট\u{9be}র বিপরীত দিকে ঘোর\u{9be}",
                "ঘড\u{9bc}ির ক\u{9be}\u{981}ট\u{9be}র বিপরীতে তীর বোত\u{9be}ম",
                "তীর",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("strelice suprotno od smjera kretanja sata"),
            keywords: &[
                "smjer suprotan kretanju kazaljki na satu",
                "strelica",
                "strelice dugme suprotno kretanju kazaljki na satu",
                "strelice suprotno od smjera kretanja sata",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("botó de fletxes que giren cap a l’esquerra"),
            keywords: &[
                "botó de fletxes que giren cap a l’esquerra",
                "esquerra",
                "fletxes en sentit antihorari",
                "gir",
                "sentit antihorari",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏩᏥ ᎦᏏᏅᏍᏔᏅ ᎪᏪᎵ ᏗᎦᏂᏱᏙᏗ"),
            keywords: &[
                "ᎠᏗᏆᎸᏕᏲᎰᎢ ᎠᎦᏍᎦᏂ ᏗᏜ",
                "ᎦᏝᏗ",
                "ᏩᏥ ᎦᏏᏅᏍᏔᏅ",
                "ᏩᏥ ᎦᏏᏅᏍᏔᏅ ᎪᏪᎵ ᏗᎦᏂᏱᏙᏗ",
                "ᏩᏥ ᎦᏏᏅᏍᏔᏅᎢ",
                "ᏩᏥ ᎦᏏᏅᏍᏔᏅᎢ ᎦᏝᏗ ᎦᏗ",
            ],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("šipky proti směru hodinových ručiček"),
            keywords: &[
                "doleva",
                "hodin",
                "proti",
                "ručiček",
                "směr",
                "směru",
                "šipka",
                "šipky proti směru hodinových ručiček",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("botwm saethau gwrthglocwedd"),
            keywords: &[
                "botwm saethau gwrthglocwedd",
                "gwrthglocwedd",
                "o chwith",
                "saeth",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("vandrette cirkulære pile mod uret"),
            keywords: &[
                "cirkulære pile",
                "mod uret",
                "vandrette cirkulære pile mod uret",
                "vandrette pile",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Pfeile gegen den Uhrzeigersinn"),
            keywords: &[
                "Pfeile",
                "Pfeile gegen den Uhrzeigersinn",
                "gegen den Uhrzeigersinn",
                "kreisförmige Pfeile gegen den Uhrzeigersinn",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κουμπί αριστερόστροφων βελών"),
            keywords: &[
                "αντίστροφα",
                "αριστερόστροφο",
                "βέλος",
                "κουμπί αριστερόστροφων βελών",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("counterclockwise arrows button"),
            keywords: &[
                "anticlockwise",
                "arrow",
                "counterclockwise",
                "counterclockwise arrows button",
                "withershins",
            ],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: Some("anticlockwise arrows button"),
            keywords: &["anticlockwise arrows button"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &[
                "anticlockwise",
                "anticlockwise arrows button",
                "arrow",
                "counterclockwise",
                "counterclockwise arrows button",
                "withershins",
            ],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("flechas en sentido antihorario"),
            keywords: &[
                "dirección",
                "flechas",
                "flechas en sentido antihorario",
                "sentido antihorario",
                "señal de recarga",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("flechas horizontales en sentido horario"),
            keywords: &[
                "flechas",
                "flechas horizontales en sentido horario",
                "flechas horizontales sentido horario",
                "horario",
                "señal de recarga",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("botón de flechas contrasentido horario"),
            keywords: &[
                "antisentido horario",
                "botón de flechas contrasentido horario",
                "contrasentido horario",
                "dirección contraria al sol",
                "flecha",
            ],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("nooled vastupäeva"),
            keywords: &["nool", "nooled vastupäeva", "vastupäeva"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("ezkerrera gezien botoia"),
            keywords: &["ezkerrera", "ezkerrera gezien botoia", "gezi"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("خلاف جهت عقربه\u{200c}های ساعت"),
            keywords: &[
                "خلاف جهت عقربه\u{200c}های ساعت",
                "خلاف حرکت عقربه\u{200c}های ساعت",
                "پیکان",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("nuolet vastapäivään"),
            keywords: &["nuolet vastapäivään", "nuoli", "vastapäivään"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("mga counterclockwise na arrow"),
            keywords: &[
                "anticlockwise",
                "arrow",
                "button",
                "counterclockwise",
                "mga counterclockwise na arrow",
                "withershins",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("vatnrættir pílar sum ganga ímóti urinum"),
            keywords: &[
                "pílar",
                "vatnrættir",
                "vatnrættir pílar sum ganga ímóti urinum",
                "ímóti urinum",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("flèches dans le sens antihoraire"),
            keywords: &[
                "flèche",
                "flèches dans le sens antihoraire",
                "sens antihoraire",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("flèches verticales dans le sens antihoraire"),
            keywords: &[
                "antihoraire",
                "flèche",
                "flèches verticales dans le sens antihoraire",
                "sens inverse des aiguilles d’une montre",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("cnaipe saighead tuathail"),
            keywords: &[
                "cnaipe saighead tuathail",
                "saigheada",
                "saigheada tuathail",
                "tuathal",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("putan saighdean a’ dol tuathail"),
            keywords: &["putan saighdean a’ dol tuathail", "saighead", "tuathail"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("frechas xirando cara á esquerda"),
            keywords: &[
                "frechas",
                "frechas xirando cara á esquerda",
                "reiniciar",
                "sentido contrario ás agullas do reloxo",
                "xirar",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("વામાવર\u{acd}તી તીર બટન"),
            keywords: &["તીર", "વામાવર\u{acd}તી", "વામાવર\u{acd}તી તીર બટન"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("maɓallin kibiyoyi ta hannun hagu"),
            keywords: &[
                "akasin hanyar rana",
                "kibiya",
                "maɓallin kibiyoyi ta hannun hagu",
                "ta hannun hagu",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("לחצן חצים נגד כיוון השעון"),
            keywords: &["חץ", "לחצן חצים נגד כיוון השעון", "נגד כיוון השעון"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("घड\u{93c}ी की उल\u{94d}टी दिशा म\u{947}\u{902} तीर"),
            keywords: &[
                "घड\u{93c}ी की उल\u{94d}टी दिशा म\u{947}\u{902} तीर",
                "तीर",
                "वामावर\u{94d}त",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("tipka sa strelicama ulijevo"),
            keywords: &[
                "strelica",
                "suprotno od kazaljki na satu",
                "tipka sa strelicama ulijevo",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("óramutató járásával ellentétes irányú nyilak gombja"),
            keywords: &[
                "nyíl",
                "óramutató járásával ellentétes",
                "óramutató járásával ellentétes irányú nyilak gombja",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ժամասլաքին հակառակ ուղղությամբ սլաքներով կոճակ"),
            keywords: &[
                "ժամասլաքին հակառակ ուղղությամբ",
                "ժամասլաքին հակառակ ուղղությամբ սլաքներով կոճակ",
                "հակառակ ուղղությամբ",
                "սլաք",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("tanda panah berlawanan arah jarum jam"),
            keywords: &[
                "berlawan arah matahari",
                "berlawanan jarum jam",
                "kebalikan arah jarum jam",
                "panah",
                "tanda panah berlawanan arah jarum jam",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ọdụmbi ube nke enweghị ǹjem okirikiri"),
            keywords: &[
                "enweghị ǹjem okirikiri",
                "nduzịabụghị ya",
                "ube",
                "ọdụmbi ube nke enweghị ǹjem okirikiri",
                "ọgụu ǹjem okirikiri",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("rangsælis örvar"),
            keywords: &["rangsælis", "örvar"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("pulsante con frecce che ruotano in senso antiorario"),
            keywords: &[
                "antiorario",
                "frecce",
                "frecce a cerchio aperto",
                "frecce senso antiorario",
                "pulsante con frecce che ruotano in senso antiorario",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("左回り矢印"),
            keywords: &["リピート", "反時計回り", "左回り矢印", "矢印", "繰り返し"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("tombol panah arahe walikan ubenge jam"),
            keywords: &[
                "panah",
                "tombol panah arahe walikan ubenge jam",
                "walikan arahe srengenge",
                "walikan ubenge jam",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("საათის მიმართულების საწინააღმდეგო ისრების ღილაკი"),
            keywords: &[
                "ისარი",
                "საათის ისრის საწინააღმდეგოდ",
                "საათის მიმართულების საწინააღმდეგო ისრების ღილაკი",
            ],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("taqeffalt n ineccaben n tnila yettin n isegnan n temrilt"),
            keywords: &["taqeffalt n ineccaben n tnila yettin n isegnan n temrilt"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("сағат тіліне қарама-қарсы көрсеткілер түймесі"),
            keywords: &[
                "күннің бағытына қарама-қарсы",
                "көрсеткі",
                "сағат тіліне қарама-қарсы",
                "сағат тіліне қарама-қарсы көрсеткілер түймесі",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("mod uret"),
            keywords: &["mod uret", "pile", "pile mod uret"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some(
                "ព\u{17d2}រ\u{17bd}ញវ\u{17b7}លជារង\u{17d2}វង\u{17cb}ច\u{17d2}រាសទ\u{17d2}រន\u{17b7}ចនាឡ\u{17b7}កាក\u{17d2}ន\u{17bb}ងរាងប\u{17bd}ងជ\u{17d2}រ\u{17bb}ង",
            ),
            keywords: &[
                "ទ\u{17b7}ស",
                "ទ\u{17b7}សដៅ",
                "ព\u{17d2}រ\u{17bd}ញ",
                "ព\u{17d2}រ\u{17bd}ញវ\u{17b7}លជារង\u{17d2}វង\u{17cb}ច\u{17d2}រាសទ\u{17d2}រន\u{17b7}ចនាឡ\u{17b7}កាក\u{17d2}ន\u{17bb}ងរាងប\u{17bd}ងជ\u{17d2}រ\u{17bb}ង",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಅಪ\u{ccd}ರದಕ\u{ccd}ಷ\u{cbf}ಣವಾಗ\u{cbf} ಬಾಣಗಳ ಬಟನ\u{ccd}"),
            keywords: &[
                "ಅಪ\u{ccd}ರದಕ\u{ccd}ಷ\u{cbf}ಣವಾಗ\u{cbf}",
                "ಅಪ\u{ccd}ರದಕ\u{ccd}ಷ\u{cbf}ಣವಾಗ\u{cbf} ಬಾಣಗಳ ಬಟನ\u{ccd}",
                "ಬಾಣಗಳು",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("반시계 방향 화살표"),
            keywords: &["반시계 방향", "반시계 방향 화살표", "화살표"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("वाम बाणा\u{902}चो बटण"),
            keywords: &[
                "अपसव\u{94d}य",
                "दाव\u{94d}या दिश\u{947}न वचपी बाण",
                "बाण",
                "वाम बाणा\u{902}चो बटण",
                "विथरशिन\u{94d}स",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("саат жебесине каршы жебелер"),
            keywords: &["жебе", "саат жебесине каршы", "саат жебесине каршы жебелер"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("vertikal Feiler géint Zärerichtung"),
            keywords: &[
                "Feil",
                "a géigegesat Richtung",
                "counterclockwise",
                "géint Zärerichtung",
                "vertikal Feiler géint Zärerichtung",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ລ\u{eb9}ກສອນທວນທ\u{eb4}ດເຂ\u{eb1}ມໂມງ"),
            keywords: &[
                "ທວນທ\u{eb4}ດເຂ\u{eb1}ມໂມງ",
                "ລ\u{eb9}ກສອນ",
                "ລ\u{eb9}ກສອນທວນທ\u{eb4}ດເຂ\u{eb1}ມໂມງ",
                "ລ\u{ebb}ງລ\u{eb8}\u{ec8}ມ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("prieš laikrodžio rodyklę nukreiptų rodyklių mygtukas"),
            keywords: &[
                "prieš laikrodžio rodyklę",
                "prieš laikrodžio rodyklę nukreiptų rodyklių mygtukas",
                "rodyklė",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("pretēji pulksteņrādītāja virzienam vērstas bultiņas"),
            keywords: &[
                "bultiņa",
                "pretēji pulksteņrādītāja virzienam",
                "pretēji pulksteņrādītāja virzienam vērstas bultiņas",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pātene pere kōaro"),
            keywords: &["kōaro", "pere", "pātene pere kōaro"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("копче со стрелки што вртат налево"),
            keywords: &[
                "копче со стрелки што вртат налево",
                "лево",
                "спротивно",
                "стрелки",
                "часовник",
            ],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some(
                "വിപരീത ഘടിക\u{d3e}ര ദിശയില\u{d41}ള\u{d4d}ള അമ\u{d4d}പടയ\u{d3e}ളങ\u{d4d}ങള\u{d41}ടെ ബട\u{d4d}ടൺ",
            ),
            keywords: &[
                "അമ\u{d4d}പടയ\u{d3e}ളം",
                "വിപരീത ഘടിക\u{d3e}ര ദിശയില\u{d41}ള\u{d4d}ള അമ\u{d4d}പടയ\u{d3e}ളങ\u{d4d}ങള\u{d41}ടെ ബട\u{d4d}ടൺ",
                "വിപരീത ഘടിക\u{d3e}ര ദിശയില\u{d41}ള\u{d4d}ള രണ\u{d4d}ട\u{d4d} ആരോകൾ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("цагийн зүүний эсрэг товчлуур"),
            keywords: &[
                "товчлуур",
                "цагийн зүү",
                "цагийн зүүний эсрэг товчлуур",
                "эсрэг",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some(
                "घड\u{94d}\u{200d}याळाच\u{94d}या विर\u{942}द\u{94d}ध दिश\u{947}त असल\u{947}ल\u{947} बाण",
            ),
            keywords: &[
                "घड\u{94d}याळाच\u{94d}या दिश\u{947}त",
                "घड\u{94d}याळाच\u{94d}या दिश\u{947}त असल\u{947}ल\u{947} बाण",
                "घड\u{94d}याळाच\u{94d}या विर\u{942}द\u{94d}ध दिश\u{947}त",
                "घड\u{94d}\u{200d}याळाच\u{94d}या विर\u{942}द\u{94d}ध दिश\u{947}त असल\u{947}ल\u{947} बाण",
                "बाण",
                "वायरशिन\u{94d}स",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("butang anak panah lawan jam"),
            keywords: &[
                "anak panah",
                "arah lawan jam",
                "bertentangan arah jam",
                "butang anak panah lawan jam",
                "lawan jam",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("buttuna vleġeġ kontra l-arloġġ"),
            keywords: &[
                "buttuna vleġeġ kontra l-arloġġ",
                "kontra l-arloġġ",
                "vleġġa",
                "withershins",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဘယ\u{103a}ရစ\u{103a} မြားများ ခလ\u{102f}တ\u{103a}"),
            keywords: &[
                "နာရ\u{102e}လက\u{103a}တ\u{1036}လားရာ ဆန\u{1037}\u{103a}ကျင\u{103a}ဘက\u{103a}",
                "နာရ\u{102e}လက\u{103a}တ\u{1036}လားရာ ဆန\u{1037}\u{103a}ကျင\u{103a}ဘက\u{103a}ပြ မြားများ ခလ\u{102f}တ\u{103a}",
                "နေလားရာန\u{103e}င\u{1037}\u{103a} ဆန\u{1037}\u{103a}ကျင\u{103a}ဘက\u{103a}ပြ မြားများ",
                "ဘယ\u{103a}ရစ\u{103a} မြားများ ခလ\u{102f}တ\u{103a}",
                "မြား",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("piler mot klokken"),
            keywords: &["mot klokken", "piler", "piler mot klokken"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("घडीको दिशाविपरीततिर वाणहर\u{942}को बटन"),
            keywords: &[
                "घडीको दिशा तिर",
                "घडीको दिशा विपरीत तिर",
                "घडीको दिशाविपरीततिर वाणहर\u{942}को बटन",
                "वाण",
                "विथरसिन\u{94d}न",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("pijlen tegen de klok in"),
            keywords: &[
                "achteruit",
                "in tegengestelde richting",
                "pijl",
                "pijlen tegen de klok in",
                "tegen de klok in",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("piler mot klokka"),
            keywords: &["mot klokka", "piler", "piler mot klokka"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some(
                "ଘଣ\u{b4d}ଟ\u{b3e}କଣ\u{b4d}ଟ\u{b3e}ର ଘ\u{b42}ର\u{b3f}ବ\u{b3e}ର ବ\u{b3f}ପରୀତ ଦ\u{b3f}ଗରେ ତୀର ବଟନ\u{b4d}\u{200c}",
            ),
            keywords: &[
                "ଘଣ\u{b4d}ଟ\u{b3e}କଣ\u{b4d}ଟ\u{b3e} ଘ\u{b42}ର\u{b3f}ବ\u{b3e}ର ବ\u{b3f}ପରୀତ ଦ\u{b3f}ଗରେ",
                "ଘଣ\u{b4d}ଟ\u{b3e}କଣ\u{b4d}ଟ\u{b3e}ର ଘ\u{b42}ର\u{b3f}ବ\u{b3e}ର ବ\u{b3f}ପରୀତ ଦ\u{b3f}ଗରେ ତୀର ବଟନ\u{b4d}\u{200c}",
                "ଘଣ\u{b4d}ଟ\u{b3e}କଣ\u{b4d}ଟ\u{b3e}ର ବ\u{b3f}ପରୀତ ଦ\u{b3f}ଗରେ",
                "ତୀର",
                "ୱ\u{b3f}ଦରଶ\u{b3f}ନ\u{b4d}ସ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਘੜੀ ਦੀ ਉਲਟ ਦਿਸ\u{a3c}ਾ ਵਿ\u{a71}ਚ ਤੀਰ ਬਟਨ"),
            keywords: &[
                "ਘੜੀ ਦੀ ਉਲਟ ਦਿਸ\u{a3c}ਾ",
                "ਘੜੀ ਦੀ ਉਲਟ ਦਿਸ\u{a3c}ਾ ਵਿ\u{a71}ਚ ਤੀਰ",
                "ਘੜੀ ਦੀ ਉਲਟ ਦਿਸ\u{a3c}ਾ ਵਿ\u{a71}ਚ ਤੀਰ ਬਟਨ",
                "ਤੀਰ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("مخالف گھڑی وار تیراں دا بٹن"),
            keywords: &[
                "تیر",
                "خلاف\u{650} آفتاب",
                "مخالف گھڑی وار",
                "مخالف گھڑی وار تیراں دا بٹن",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Aro-dẹm Nọ\u{301} De Múv Klọ\u{301}k Hánd Wè"),
            keywords: &[
                "Aro-dẹm Nọ\u{301} De Múv Klọ\u{301}k Hánd Dairẹ\u{301}kshọn",
                "Aro-dẹm Nọ\u{301} De Múv Klọ\u{301}k Hánd Wè",
                "Bọ\u{301}tin Ópózít To Sọn Dairẹ\u{301}kshọn",
                "Nọ\u{301} Bi Klọ\u{301}k Hánd Dairẹ\u{301}kshọn Áro",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("przycisk ze strzałkami przeciwnie do ruchu wskazówek zegara"),
            keywords: &[
                "dookoła",
                "okrężny",
                "przycisk ze strzałkami przeciwnie do ruchu wskazówek zegara",
                "przycisk ze strzałkami w kierunku przeciwnym do ruchu wskazówek zegara",
                "strzałka",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("خلاف کلاک وايز غشي بټن"),
            keywords: &[
                "خلاف کلاک وايز",
                "خلاف کلاک وايز غشي بټن",
                "غشي",
                "ويدر شاين",
            ],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("botão de setas em sentido anti-horário"),
            keywords: &[
                "anti-horário",
                "botão de setas em sentido anti-horário",
                "botão de setas no sentido anti-horário",
                "sentido anti-horário",
                "seta",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("setas no sentido contrário ao dos ponteiros do relógio"),
            keywords: &[
                "sentido contrário ao dos ponteiros do relógio",
                "seta",
                "setas no sentido contrário ao dos ponteiros do relógio",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("buton cu săgeți în sens antiorar"),
            keywords: &[
                "antiorar",
                "buton cu săgeți în sens antiorar",
                "invers",
                "sens invers acelor de ceasornic",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-704"),
            keywords: &["E10-704"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("против часовой стрелки"),
            keywords: &[
                "горизонтальные стрелки",
                "замкнутые горизонтальные стрелки",
                "замкнутые стрелки",
                "против часовой стрелки",
                "стрелки",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("utwambi duhagaritse tutareba mu cyerekezo cy’inshinge z’isaha"),
            keywords: &[
                "mu cyerekezo kinyuranye n’icy’inshinge z’isaha",
                "mu cyerekezo kinyuranye n’icy’izuba",
                "mu cyerekezo kitari icy’inshinge z’isaha",
                "umwambi",
                "utwambi duhagaritse tutareba mu cyerekezo cy’inshinge z’isaha",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ابتي ڪلاڪ وانگي تيري بٽڻ"),
            keywords: &[
                "ابتي ڪلاڪ وانگي تيري بٽڻ",
                "اينٽي ڪلاڪ وايئز",
                "تير",
                "مخالف رخ",
                "ڪائونٽر ڪلاڪ وائيز",
            ],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ව\u{dcf}ම\u{dcf}වර\u{dca}ත ඊතල බොත\u{dca}තම"),
            keywords: &[
                "ඊතලය",
                "දක\u{dca}ෂ\u{dd2}ණ\u{dcf}වර\u{dca}ත දෙසට ව\u{dd2}ර\u{dd4}ද\u{dca}ධව",
                "ව\u{dcf}ම\u{dcf}වර\u{dca}ත",
                "ව\u{dcf}ම\u{dcf}වර\u{dca}ත ඊතල බොත\u{dca}තම",
                "ස\u{dd6}ර\u{dca}ය\u{dcf}ගමනයට ව\u{dd2}ර\u{dd4}ද\u{dca}ධව",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("tlačidlo so šípkami proti smeru hodinových ručičiek"),
            keywords: &[
                "proti smeru hodinových ručičiek",
                "tlačidlo so šípkami proti smeru hodinových ručičiek",
                "šípka",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("gumb s puščicama, ki se ukrivljata v obratni smeri urnega kazalca"),
            keywords: &[
                "gumb s puščicama, ki se ukrivljata v obratni smeri urinega kazalca",
                "gumb s puščicama, ki se ukrivljata v obratni smeri urnega kazalca",
                "nasprotna smer urinega kazalca",
                "nazaj",
                "puščica",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("badhanka fallaarada ee lid saacad-wareegga"),
            keywords: &[
                "badhanka fallaarada ee lid saacad-wareegga",
                "fallaar",
                "lid saacad-wareegga",
                "saacad-wareegga gacan bidix ah",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("butoni me shigjetat antiorare"),
            keywords: &[
                "antiorar",
                "butoni me shigjetat antiorare",
                "kundër drejtimit të orës",
                "kundërorar",
                "shigjetë",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("стрелице које се врте улево"),
            keywords: &[
                "стрeлицa",
                "стрелице које се врте улево",
                "супрoтнo oд кaзaљке нa сaту",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("стрелице које се врте улијево"),
            keywords: &["стрелице које се врте улијево"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("strelice koje se vrte ulevo"),
            keywords: &[
                "strelica",
                "strelice koje se vrte ulevo",
                "suprotno od kazaljke na satu",
            ],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("strelice koje se vrte ulijevo"),
            keywords: &["strelice koje se vrte ulijevo"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("pilar moturs"),
            keywords: &["moturs", "pilar"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kitufe cha mishale ya kinyume saa"),
            keywords: &[
                "chakaa",
                "kinyume saa",
                "kitufe cha mishale ya kinyume saa",
                "mshale",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("இடஞ\u{bcd}சுழி அம\u{bcd}புக\u{bcd}குறிகள\u{bcd} பொத\u{bcd}த\u{bbe}ன\u{bcd}"),
            keywords: &[
                "அம\u{bcd}புக\u{bcd}குறிகள\u{bcd}",
                "இடஞ\u{bcd}சுழி அம\u{bcd}புக\u{bcd}குறிகள\u{bcd}",
                "இடஞ\u{bcd}சுழி அம\u{bcd}புக\u{bcd}குறிகள\u{bcd} பொத\u{bcd}த\u{bbe}ன\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("అపసవ\u{c4d}యద\u{c3f}శల\u{c4b} బ\u{c3e}ణ\u{c3e}ల బటన\u{c4d}"),
            keywords: &[
                "అపసవ\u{c4d}యద\u{c3f}శల\u{c4b} బ\u{c3e}ణ\u{c3e}ల బటన\u{c4d}",
                "ర\u{c3f}ఫ\u{c4d}ర\u{c46}ష\u{c4d} చ\u{c3f}హ\u{c4d}నం",
                "ర\u{c3f}ఫ\u{c4d}ర\u{c46}ష\u{c4d} చ\u{c47}య\u{c3f}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("Тугмаи \"Тирҳои самти муқобили ҳаракати ақрабҳои соат\""),
            keywords: &[
                "Тугмаи \"Тирҳои самти муқобили ҳаракати ақрабҳои соат\"",
                "муқобили самти ҳаракати ақрабҳои соат",
                "муқобили ҳаракати офтоб",
                "тир",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ล\u{e39}กศรทวนเข\u{e47}มนาฬ\u{e34}กา"),
            keywords: &[
                "ทวนเข\u{e47}มนาฬ\u{e34}กา",
                "ล\u{e39}กศร",
                "ล\u{e39}กศรทวนเข\u{e47}มนาฬ\u{e34}กา",
            ],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ኣንጻር ሰዓት ዝዘውር ትኹል ምልክት መልጎም"),
            keywords: &[
                "withershins",
                "ምልክት",
                "ኣንጻር ሰዓት",
                "ኣንጻር ሰዓት ዝዘውር ትኹል ምልክት መልጎም",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("sagadyň tersine oklar düwmesi"),
            keywords: &[
                "ok",
                "sagadyň garşysyna",
                "sagadyň tersine",
                "sagadyň tersine oklar düwmesi",
                "yzygiderli oklar",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("ngahau vilovilo toʻohema"),
            keywords: &["hema", "ngahau", "ngahau vilovilo toʻohema", "vilovilo"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("saat yönünün tersinde dönen oklar"),
            keywords: &[
                "oklar",
                "saat yönünün tersinde dönen oklar",
                "saat yönünün tersine",
                "saat yönünün tersine dönen oklar",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("سائەتكە قارشى يۆنىلىشتىكى كۆرسەتكۈچ"),
            keywords: &[
                "سائەت يۆنىلىشىگە قارشى",
                "سائەتكە قارشى",
                "سائەتكە قارشى يۆنىلىشتىكى كۆرسەتكۈچ",
                "قارشى",
                "كۆرسەتكۈچ",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("кнопка стрілок проти ходу годинника"),
            keywords: &[
                "кнопка зі стрілками, напрямленими проти годинникової стрілки",
                "кнопка стрілок проти ходу годинника",
                "проти годинникової стрілки",
                "стрілка",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("گھڑی کی مخالف سمت میں تیر بٹن"),
            keywords: &[
                "تیر",
                "سائن",
                "سمت",
                "گھڑی کی مخالف سمت",
                "گھڑی کی مخالف سمت میں تیر بٹن",
            ],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("soat millariga qarshi yo‘nalish"),
            keywords: &[
                "chiziq",
                "soat millariga qarshi",
                "soat millariga qarshi yo‘nalish",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("nút mũi tên ngược chiều kim đồng hồ"),
            keywords: &[
                "mũi tên",
                "ngược chiều kim đồng",
                "nút mũi tên ngược chiều kim đồng hồ",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("bitoŋu fett yu juuyoo te safaan-montar"),
            keywords: &[
                "bitoŋu fett yu juuyoo te safaan-montar",
                "fett",
                "juuyoo",
                "safaan-montar",
                "yoonal",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("iqhosha lamatolo elijikeleza ngasekunene"),
            keywords: &[
                "i-whithershins",
                "iqhosha lamatolo elijikeleza ngasekunene",
                "jikeleza ngasekhohlo",
                "ngokujikeleza ngasekhohlo",
                "utolo",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("bọtini awọn ọfa yiyi lodi sọna ago"),
            keywords: &[
                "bọtini awọn ọfa yiyi lodi sọna ago",
                "o\u{329}fà",
                "ìlòdìsọ\u{301}wọ\u{301} aago",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("逆時針箭咀按鈕"),
            keywords: &["相反方向", "箭咀", "逆時針", "逆時針箭咀按鈕"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("逆时针箭咀按钮"),
            keywords: &["相反方向", "箭咀", "逆时针", "逆时针箭咀按钮"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("逆时针箭头按钮"),
            keywords: &["箭头", "逆时针", "逆时针箭头", "逆时针箭头按钮"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("逆時針"),
            keywords: &["逆時針"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("逆時針箭嘴按鈕"),
            keywords: &["逆時針", "逆時針箭嘴", "逆時針箭嘴按鈕"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("izinkinobho zemicibisholo ejikelezela kwesokunxele"),
            keywords: &[
                "izinkinobho zemicibisholo ejikelezela kwesokunxele",
                "okujikelezela ngakwesokunxele",
                "okuphambana nokuya ngakwesokudla",
                "umcibisholo",
            ],
        },
    ],
};
#[doc = "🔙"]
pub const BACK_ARROW: crate::Emoji = crate::Emoji {
    glyph: "🔙",
    codepoint: "1F519",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "BACK arrow",
    group: "Symbols",
    subgroup: "arrow",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("terugpyl"),
            keywords: &["pyl", "terug", "terugpyl"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ተመለስ ቀስት"),
            keywords: &["ቀስት", "ተመለስ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("سهم رجوع"),
            keywords: &["رجوع مع سهم أيسر", "سهم", "سهم أيسر", "سهم رجوع"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("পশ\u{9cd}চ\u{9be}দম\u{9c1}খী ক\u{9be}\u{981}ড\u{9bc}"),
            keywords: &[
                "ক\u{9be}\u{981}ড\u{9bc}",
                "পশ\u{9cd}চ\u{9be}দম\u{9c1}খী ক\u{9be}\u{981}ড\u{9bc}",
                "পিছলৈ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("geriyə yönəlmiş ox"),
            keywords: &["arxa", "geriyə yönəlmiş ox", "ox"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("стрэлка «назад»"),
            keywords: &["назад", "стрэлка", "стрэлка «назад»"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("стрелка с back"),
            keywords: &["back", "стрелка", "стрелка с back"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("পিছনে তীর"),
            keywords: &["তীর", "পিছনে"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("strelica za nazad"),
            keywords: &["nazad", "strelica", "strelica za nazad"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("fletxa amb la paraula Back"),
            keywords: &["Back", "fletxa", "fletxa amb la paraula Back", "paraula"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎣᏂᏗᏢ ᎦᏝᏗ"),
            keywords: &["ᎣᏂᏗᏝ", "ᎣᏂᏗᏢ ᎦᏝᏗ", "ᎦᏝᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("šipka zpět"),
            keywords: &["back", "zpět", "šipka"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("saeth BACK"),
            keywords: &["saeth", "saeth BACK", "yn ôl"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("BACK-pil"),
            keywords: &["BACK-pil", "tilbage-pil", "venstrepil"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("BACK-Pfeil"),
            keywords: &["BACK-Pfeil", "Pfeil", "links", "zurück"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("βέλος BACK"),
            keywords: &["βέλος", "βέλος BACK", "πίσω"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("BACK arrow"),
            keywords: &["BACK arrow", "arrow", "back"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("flecha BACK"),
            keywords: &[
                "atrás",
                "atrás con flecha izquierda",
                "back",
                "flecha",
                "flecha BACK",
                "flecha a la izquierda",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["atrás", "flecha", "flecha BACK"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("nool BACK"),
            keywords: &["nool", "nool BACK", "tagasi"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("atzera gezia"),
            keywords: &["atzera", "atzera gezia", "gezi"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("پیکان عقب"),
            keywords: &["برگشت", "پیکان", "پیکان عقب"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("BACK-nuoli"),
            keywords: &["BACK-nuoli", "nuoli", "takaisin"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("back arrow"),
            keywords: &["PABALIK", "arrow", "back arrow"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("BACK pílur"),
            keywords: &["BACK pílur", "back", "pílur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("flèche Retour"),
            keywords: &["flèche", "flèche Retour"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("étiquette «\u{a0}BACK\u{a0}» et flèche"),
            keywords: &[
                "back",
                "flèche",
                "retour",
                "étiquette «\u{a0}BACK\u{a0}» et flèche",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("saighead SIAR"),
            keywords: &["saighead SIAR", "siar agus saighead ar chlé"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("saighead “BACK”"),
            keywords: &["air ais", "saighead", "saighead “BACK”"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("frecha coa mensaxe \"volver\" en inglés"),
            keywords: &[
                "atrás",
                "back",
                "frecha",
                "frecha coa mensaxe \"volver\" en inglés",
                "volver",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("પાછળ તીર"),
            keywords: &[
                "ડાબા તીર સાથ\u{ac7} પાછળ",
                "ડાબ\u{ac1}\u{a82} તીર",
                "તીર",
                "પાછળ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("Kibiya Ta BAYA"),
            keywords: &["Kibiya Ta BAYA", "baya", "kibiya"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("חץ אחורה"),
            keywords: &["אחורה", "חזרה", "חץ"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("वापस तीर"),
            keywords: &[
                "तीर",
                "बाए\u{901} तीर क\u{947} साथ वापस",
                "बाया\u{901} तीर",
                "वापस",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("strelica s natpisom \"back\""),
            keywords: &["natrag", "strelica", "strelica s natpisom \"back\""],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("vissza nyíl"),
            keywords: &["nyíl", "vissza nyíl", "visszafelé"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("հետ գրությամբ սլաք"),
            keywords: &["հետ", "հետ գրությամբ սլաք", "սլաք"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("tanda panah BACK"),
            keywords: &["kembali", "panah", "tanda panah BACK"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("UBE àzụ"),
            keywords: &["UBE àzụ", "ube", "àzụ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("til baka"),
            keywords: &[
                "til baka",
                "vinstri ör",
                "ör",
                "ör til baka",
                "ör til vinstri",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("freccia BACK"),
            keywords: &[
                "freccia",
                "freccia BACK",
                "freccia verso sinistra",
                "indietro",
                "indietro con freccia verso sinistra",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("BACK矢印"),
            keywords: &["BACK", "BACK矢印", "バック", "戻る", "矢印"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("panah MBALIK"),
            keywords: &["mbalik", "panah", "panah MBALIK"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("უკანსვლის ღილაკი"),
            keywords: &["ისარი", "უკან", "უკანსვლის ღილაკი"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("Aneccab n tuɣalin"),
            keywords: &["Aneccab n tuɣalin"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("«артқа» көрсеткісі"),
            keywords: &["«артқа» көрсеткісі", "артқа", "көрсеткі"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("tilbage"),
            keywords: &["tilbage", "tilbage-pil", "venstrepil"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some(
                "ព\u{17d2}រ\u{17bd}ញទៅឆ\u{17d2}វេងមានអក\u{17d2}សរ Back នៅព\u{17b8}ក\u{17d2}រោម",
            ),
            keywords: &[
                "ថយក\u{17d2}រោយ",
                "ព\u{17d2}រ\u{17bd}ញ",
                "ព\u{17d2}រ\u{17bd}ញទៅឆ\u{17d2}វេងមានអក\u{17d2}សរ Back នៅព\u{17b8}ក\u{17d2}រោម",
                "ព\u{17d2}រ\u{17bd}ញអក\u{17d2}សរ BACK",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಹ\u{cbf}ಂದ\u{cbf}ನ ಬಾಣ"),
            keywords: &[
                "ಎಡ ಬಾಣದ ಗುರುತು",
                "ಎಡ ಬಾಣದೊಂದ\u{cbf}ಗ\u{cc6} ಹ\u{cbf}ಂದ\u{cc6}",
                "ಹ\u{cbf}ಂದ\u{cbf}ನ ಬಾಣ",
                "ಹ\u{cbf}ಂದ\u{cbf}ನ ಬಾಣದ ಗುರುತು",
                "ಹ\u{cbf}ಂದ\u{cc6}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("뒤로"),
            keywords: &["뒤로", "왼쪽 화살표", "화살표"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("फाटी\u{902} बाण"),
            keywords: &["फाटी\u{902}", "बाण"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("артка жебеси"),
            keywords: &["артка", "артка жебеси", "жебе"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("ZERÉCK-Feil"),
            keywords: &["Feil", "ZERÉCK-Feil", "zeréck"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ລ\u{eb9}ກສອນກ\u{eb1}ບ"),
            keywords: &["ກ\u{eb1}ບ", "ລ\u{eb9}ກສອນ", "ລ\u{eb9}ກສອນກ\u{eb1}ບ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("rodyklė su užrašu „Back“"),
            keywords: &["atgal", "rodyklė", "rodyklė su užrašu „Back“"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("bultiņa ar uzrakstu Back"),
            keywords: &["atpakaļ", "bultiņa", "bultiņa ar uzrakstu Back"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pere HOKI"),
            keywords: &["hoki", "pere", "pere HOKI"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("стрелка за назад"),
            keywords: &["назад", "стрелка", "стрелка за назад"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("പ\u{d41}റകിലേക\u{d4d}ക\u{d41}ള\u{d4d}ള അമ\u{d4d}പടയ\u{d3e}ളം"),
            keywords: &[
                "അമ\u{d4d}പടയ\u{d3e}ളം",
                "ഇടത\u{d4d}തോട\u{d4d}ട\u{d41}ള\u{d4d}ള ബ\u{d3e}ക\u{d4d}ക\u{d4d} ബട\u{d4d}ടൺ",
                "പ\u{d41}റകിലേക\u{d4d}ക\u{d41}ള\u{d4d}ള അമ\u{d4d}പടയ\u{d3e}ളം",
                "ബട\u{d4d}ടൺ",
                "ബ\u{d3e}ക\u{d4d}ക\u{d4d}",
                "മടങ\u{d4d}ങ\u{d41}ക",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("БУЦАХ сум"),
            keywords: &["БУЦАХ сум", "буцах", "сум"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("परत बाण"),
            keywords: &["परत", "बाण"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("anak panah ‘BACK’"),
            keywords: &["anak panah", "anak panah ‘BACK’", "kembali"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("vleġġa BACK"),
            keywords: &["lura", "vleġġa", "vleġġa BACK"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("နောက\u{103a}သ\u{102d}\u{102f}\u{1037} မြား"),
            keywords: &[
                "နောက\u{103a}သ\u{102d}\u{102f}\u{1037}",
                "နောက\u{103a}သ\u{102d}\u{102f}\u{1037}ပြ မြား သင\u{103a}\u{1039}ကေတ",
                "မြား",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("BACK-pil"),
            keywords: &[
                "BACK-pil",
                "pil",
                "pil til venstre",
                "tilbake",
                "tilbakepil",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("पछाडि स\u{902}क\u{947}त गर\u{94d}न\u{947} वाण"),
            keywords: &[
                "पछाडि जान\u{947}",
                "पछाडि स\u{902}क\u{947}त गर\u{94d}न\u{947} वाण",
                "वाण",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("BACK-pijl"),
            keywords: &["BACK-pijl", "pijl", "terug"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("BACK-pil"),
            keywords: &[
                "BACK-pil",
                "pil",
                "pil til venstre",
                "tilbake",
                "tilbakepil",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ପଛ ତୀର"),
            keywords: &["ତୀର", "ପଛ"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਪਿ\u{a71}ਛ\u{a47} ਵ\u{a71}ਲ ਇਸ\u{a3c}ਾਰਾ ਕਰਨ ਵਾਲਾ ਤੀਰ"),
            keywords: &[
                "ਖ\u{a71}ਬਾ ਤੀਰ",
                "ਖ\u{a71}ਬ\u{a47} ਤੀਰ ਨਾਲ ਪਿ\u{a71}ਛ\u{a47}",
                "ਤੀਰ",
                "ਪਿ\u{a71}ਛ\u{a47}",
                "ਪਿ\u{a71}ਛ\u{a47} ਵ\u{a71}ਲ ਇਸ\u{a3c}ਾਰਾ ਕਰਨ ਵਾਲਾ ਤੀਰ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("پیچھے دا تیر"),
            keywords: &["تیر", "پیچھے", "پیچھے دا تیر"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("BACK Áro"),
            keywords: &["BACK Áro", "Bak", "Áro"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("strzałka z napisem BACK"),
            keywords: &["strzałka", "strzałka z napisem BACK", "wstecz"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("شاته غشی"),
            keywords: &["شاته", "غشی"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("seta \"BACK\""),
            keywords: &["seta", "seta \"BACK\"", "seta para a esquerda", "voltar"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("seta BACK"),
            keywords: &["para trás", "seta", "seta BACK"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("QHIPA wachʼi"),
            keywords: &["QHIPA wachʼi"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("săgeată cu textul BACK"),
            keywords: &["săgeată", "săgeată cu textul BACK", "înapoi"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-725"),
            keywords: &["E10-725"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("стрелка «назад»"),
            keywords: &["назад", "стрелка", "стрелка «назад»"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("akambi ka BACK"),
            keywords: &["akambi ka BACK", "subira inyuma", "umwambi"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("پٺيان وارو تير"),
            keywords: &["تير", "پٺيان", "پٺيان وارو تير"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("පස\u{dd4} ඊතලය"),
            keywords: &["ඊතලය", "පස\u{dd4} ඊතලය", "පස\u{dd4}පසට"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("šípka BACK"),
            keywords: &["späť", "šípka", "šípka BACK"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("puščica nazaj"),
            keywords: &["nazaj", "puščica"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("fallaarta GADAAL"),
            keywords: &["falaar", "fallaarta GADAAL", "gadaal"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("shigjetë prapa"),
            keywords: &["prapa", "shigjetë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("стрелица за повратак"),
            keywords: &["назад", "стрeлицa", "стрелица за повратак"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("strelica za povratak"),
            keywords: &["nazad", "strelica", "strelica za povratak"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("Back med vänsterpil"),
            keywords: &["Back med vänsterpil", "bakåt", "vänsterpil"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mshale wa nyuma"),
            keywords: &["mshale", "mshale wa nyuma", "nyuma"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பின\u{bcd}ன\u{bbe}ல\u{bcd} செல\u{bcd}"),
            keywords: &[
                "திரும\u{bcd}பிப\u{bcd} போ",
                "பின\u{bcd}செல\u{bcd}லும\u{bcd} அம\u{bcd}புக\u{bcd}குறி",
                "பின\u{bcd}ன\u{bbe}ல\u{bcd} செல\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("వ\u{c46}నుకకు బ\u{c3e}ణం"),
            keywords: &["బ\u{c3e}ణం", "వ\u{c46}నుకకు"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("тири \"бозгашт\""),
            keywords: &["тир", "тири \"бозгашт\"", "қафо"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("กล\u{e31}บ"),
            keywords: &["กล\u{e31}บ", "ล\u{e39}กศร", "ล\u{e39}กศรกล\u{e31}บ"],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ዳሕረዋይ ምልክት"),
            keywords: &["ምልክት", "ዳሕረዋይ ምልክት", "ድሕሪት"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("BACK oky"),
            keywords: &["BACK oky", "ok", "yza"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("ngahau FOKI"),
            keywords: &["FOKI", "ngahau"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("geri oku"),
            keywords: &["geri oku", "ok", "sol geri ok", "sol ok"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئارقا كۆرسەتكۈچ"),
            keywords: &["ئارقا", "كۆرسەتكۈچ"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("стрілка назад [BACK]"),
            keywords: &[
                "назад",
                "стрілка",
                "стрілка BACK",
                "стрілка назад BACK",
                "стрілка назад [BACK]",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("واپسی تیر"),
            keywords: &["تیر", "واپسی تیر", "پیچھے"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("orqaga yo‘nalish"),
            keywords: &["chiziq", "orqaga", "orqaga yo‘nalish"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("mũi tên BACK"),
            keywords: &["back", "mũi tên", "mũi tên BACK"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("fettu DELLU"),
            keywords: &["fett", "fettu DELLU", "montar"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("utolo oluthi EMVA"),
            keywords: &["emva", "utolo", "utolo oluthi EMVA"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ọfa ẸYIN"),
            keywords: &["o\u{329}fà", "ẹ\u{300}yìn", "Ọfa ẸYIN"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("返回箭咀"),
            keywords: &["箭咀", "返回", "返回箭咀"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("返回箭咀"),
            keywords: &["箭咀", "返回", "返回箭咀"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("返回箭头"),
            keywords: &["回退", "箭头", "返回", "返回箭头"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("返回"),
            keywords: &["返回"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("後退箭嘴"),
            keywords: &["向後", "向後箭嘴", "後退", "後退箭嘴"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("umcibisholo oya emuva"),
            keywords: &["emuva", "umcibisholo", "umcibisholo oya emuva"],
        },
    ],
};
#[doc = "🔚"]
pub const END_ARROW: crate::Emoji = crate::Emoji {
    glyph: "🔚",
    codepoint: "1F51A",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "END arrow",
    group: "Symbols",
    subgroup: "arrow",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("eindpyl"),
            keywords: &["einde", "eindpyl", "pyl"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ማብቂያ ቀስት"),
            keywords: &["መጨረሻ", "ማብቂያ ቀስት", "ቀስት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("سهم النهاية"),
            keywords: &[
                "انتهاء مع سهم أيسر",
                "سهم",
                "سهم أيسر",
                "سهم النهاية",
                "سهم انتهاء",
            ],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("সম\u{9be}প\u{9cd}তি ক\u{9be}\u{981}ড\u{9bc}"),
            keywords: &[
                "ক\u{9be}\u{981}ড\u{9bc}",
                "সম\u{9be}প\u{9cd}ত",
                "সম\u{9be}প\u{9cd}তি ক\u{9be}\u{981}ড\u{9bc}",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("sona yönəlmiş ox"),
            keywords: &["ox", "son", "sona yönəlmiş ox"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("стрэлка «канец»"),
            keywords: &["канец", "стрэлка", "стрэлка «канец»"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("стрелка с end"),
            keywords: &["end", "стрелка", "стрелка с end"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("শেষের তীর"),
            keywords: &["তীর", "শেষ", "শেষের তীর"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("strelica za kraj"),
            keywords: &["kraj", "strelica", "strelica za kraj"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("fletxa amb la paraula End"),
            keywords: &["End", "fletxa", "fletxa amb la paraula End", "paraula"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏭᎵᏍᏆᏛ ᎦᏝᏗ"),
            keywords: &["ᎦᏝᏗ", "ᏭᎵᏍᏆᏛ ᎦᏝᏗ", "ᏭᎵᏍᏛ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("šipka s nápisem END"),
            keywords: &["konec", "šipka", "šipka s nápisem END"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("saeth END"),
            keywords: &["diwedd", "saeth", "saeth END"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("END-pil"),
            keywords: &["END-pil", "end-pil", "venstrepil"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("END-Pfeil"),
            keywords: &["END-Pfeil", "Pfeil", "links"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("βέλος END"),
            keywords: &["βέλος", "βέλος END", "τέλος"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("END arrow"),
            keywords: &["END arrow", "arrow", "end"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("flecha END"),
            keywords: &[
                "final",
                "final con flecha izquierda",
                "flecha",
                "flecha END",
                "flecha a la izquierda",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["fin", "flecha", "flecha END"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("nool END"),
            keywords: &["lõpp", "nool", "nool END"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("amaiera gezia"),
            keywords: &["amaiera", "amaiera gezia", "gezi"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("پیکان پایان"),
            keywords: &["پایان", "پیکان"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("END-nuoli"),
            keywords: &["END-nuoli", "lopeta", "nuoli"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("end arrow"),
            keywords: &["DULO", "arrow", "end arrow", "katapusan"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("END pílur"),
            keywords: &["END pílur", "end", "pílur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("flèche Fin"),
            keywords: &["flèche", "flèche Fin"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("étiquette « END » et flèche"),
            keywords: &["end", "fin", "flèche", "étiquette « END » et flèche"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("saighead DEIRIDH"),
            keywords: &["deireadh agus saighead ar chlé", "saighead DEIRIDH"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("saighead “END”"),
            keywords: &["deireadh", "saighead", "saighead “END”"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("frecha coa mensaxe \"fin\" en inglés"),
            keywords: &[
                "end",
                "fin",
                "final",
                "frecha",
                "frecha coa mensaxe \"fin\" en inglés",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("સમાપ\u{acd}તિ તીર"),
            keywords: &[
                "ડાબા તીર સાથ\u{ac7} સમાપ\u{acd}તિ",
                "ડાબ\u{ac1}\u{a82} તીર",
                "તીર",
                "સમાપ\u{acd}તિ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("Kibiya Ta ƘARSHE"),
            keywords: &["Kibiya Ta ƘARSHE", "kibiya", "ƙarshe"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("חץ לסוף"),
            keywords: &["חץ", "חץ לסוף", "סוף"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("END क\u{947} साथ तीर"),
            keywords: &[
                "END क\u{947} साथ तीर",
                "तीर",
                "बाए\u{901} तीर क\u{947} साथ समाप\u{94d}ति",
                "बाया\u{901} तीर",
                "समाप\u{94d}ति",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("strelica s natpisom \"end\""),
            keywords: &["kraj", "strelica", "strelica s natpisom \"end\""],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("vége nyíl"),
            keywords: &["nyíl", "vége"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ՎԵՐՋ սլաք"),
            keywords: &["ՎԵՐՋ սլաք", "սլաք", "վերջ", "վերջ գրությամբ սլաք"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("tanda panah END"),
            keywords: &["berakhir", "panah", "tanda panah END"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("UBE ngwụcha"),
            keywords: &["UBE ngwụcha", "ngwụcha", "ube"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("endir"),
            keywords: &["endaör", "endaör til vinstri", "endir", "vinstri ör", "ör"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("freccia END"),
            keywords: &[
                "end con freccia verso sinistra",
                "fine",
                "freccia",
                "freccia END",
                "freccia end",
                "freccia verso sinistra",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("END矢印"),
            keywords: &["END", "END矢印", "エンド", "矢印", "終わり"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("panah MENTOK"),
            keywords: &["mentok", "panah", "panah MENTOK"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ბოლოში გადასვლის ისარი"),
            keywords: &["ბოლო", "ბოლოში გადასვლის ისარი", "ისარი"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("Aneccab n tagara"),
            keywords: &["Aneccab n tagara"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("«соңы» көрсеткісі"),
            keywords: &["«соңы» көрсеткісі", "көрсеткі", "соңына"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("end"),
            keywords: &["end", "end-pil", "venstrepil"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some(
                "ព\u{17d2}រ\u{17bd}ញទៅឆ\u{17d2}វេងមានអក\u{17d2}សរ End នៅព\u{17b8}ក\u{17d2}រោម",
            ),
            keywords: &[
                "END",
                "ព\u{17d2}រ\u{17bd}ញ",
                "ព\u{17d2}រ\u{17bd}ញទៅឆ\u{17d2}វេងមានអក\u{17d2}សរ End នៅព\u{17b8}ក\u{17d2}រោម",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಅಂತ\u{cbf}ಮ ಬಾಣ"),
            keywords: &[
                "ಅಂತ\u{cbf}ಮ",
                "ಅಂತ\u{cbf}ಮ ಬಾಣದ ಗುರುತು",
                "ಎಡ ಬಾಣ",
                "ಎಡ ಬಾಣದೊಂದ\u{cbf}ಗ\u{cc6} ಅಂತ\u{cbf}ಮ",
                "ಬಾಣ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("종료"),
            keywords: &["끝내기 화살표", "종료", "화살표"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("समाप\u{94d}त बाण"),
            keywords: &["बाण", "समाप\u{94d}त"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("аягы жебеси"),
            keywords: &["аягы", "аягы жебеси", "жебе"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("ENN-Feil"),
            keywords: &["ENN-Feil", "Enn", "Feil"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ລ\u{eb9}ກສອນສ\u{eb4}\u{ec9}ນສ\u{eb8}ດ"),
            keywords: &[
                "ລ\u{eb9}ກສອນ",
                "ລ\u{eb9}ກສອນສ\u{eb4}\u{ec9}ນສ\u{eb8}ດ",
                "ສ\u{eb4}\u{ec9}ນສ\u{eb8}ດ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("rodyklė su užrašu „End“"),
            keywords: &["pabaiga", "rodyklė", "rodyklė su užrašu „End“"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("bultiņa ar uzrakstu End"),
            keywords: &["beigas", "beigt", "bultiņa", "bultiņa ar uzrakstu End"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pere MUTUNGA"),
            keywords: &["mutunga", "pere", "pere MUTUNGA"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("стрелка за крај"),
            keywords: &["крај", "стрелка", "стрелка за крај"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some(
                "അവസ\u{d3e}നിപ\u{d4d}പിക\u{d4d}ക\u{d41}ന\u{d4d}നതിന\u{d41}ള\u{d4d}ള അമ\u{d4d}പടയ\u{d3e}ളം",
            ),
            keywords: &[
                "അമ\u{d4d}പടയ\u{d3e}ളം",
                "അവസ\u{d3e}നിപ\u{d4d}പിക\u{d4d}ക\u{d41}ക",
                "അവസ\u{d3e}നിപ\u{d4d}പിക\u{d4d}ക\u{d41}ന\u{d4d}നതിന\u{d41}ള\u{d4d}ള അമ\u{d4d}പടയ\u{d3e}ളം",
                "ഇടത\u{d4d}തോട\u{d4d}ട\u{d41}ള\u{d4d}ള എൻഡ\u{d4d} ബട\u{d4d}ടൺ",
                "ബട\u{d4d}ടൺ",
                "ബ\u{d3e}ക\u{d4d}ക\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("төгсөх сум"),
            keywords: &["сум", "төгсөх"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("समाप\u{94d}ती बाण"),
            keywords: &["बाण", "समाप\u{94d}ती"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("anak panah ‘END’"),
            keywords: &["anak panah", "anak panah ‘END’", "tamat"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("vleġġa END"),
            keywords: &["tmiem", "vleġġa", "vleġġa END"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အဆ\u{102f}\u{1036}းသတ\u{103a}ပြ မြား"),
            keywords: &[
                "မြား",
                "အဆ\u{102f}\u{1036}း",
                "အဆ\u{102f}\u{1036}းသတ\u{103a}ပြ မြား",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("END-pil"),
            keywords: &[
                "END-pil",
                "pil",
                "pil til venstre",
                "slutt",
                "slutt med pil",
                "sluttpil",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("सकिएको स\u{902}क\u{947}त गर\u{94d}न\u{947} वाण"),
            keywords: &[
                "अन\u{94d}तिम",
                "वाण",
                "सकिएको स\u{902}क\u{947}त गर\u{94d}न\u{947} वाण",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("END-pijl"),
            keywords: &["END-pijl", "einde", "pijl"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("END-pil"),
            keywords: &[
                "END-pil",
                "pil",
                "pil til venstre",
                "slutt",
                "slutt med pil",
                "sluttpil",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଶେଷ ତୀର"),
            keywords: &["ତୀର", "ଶେଷ"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਸਮਾਪਤੀ ਵ\u{a71}ਲ ਇਸ\u{a3c}ਾਰਾ ਕਰਨ ਵਾਲਾ ਤੀਰ"),
            keywords: &[
                "ਖ\u{a71}ਬਾ ਤੀਰ",
                "ਖ\u{a71}ਬ\u{a47} ਤੀਰ ਨਾਲ ਸਮਾਪਤ",
                "ਤੀਰ",
                "ਸਮਾਪਤ",
                "ਸਮਾਪਤੀ ਵ\u{a71}ਲ ਇਸ\u{a3c}ਾਰਾ ਕਰਨ ਵਾਲਾ ਤੀਰ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("آخر دا تیر"),
            keywords: &["آخر دا تیر", "اختتام", "تیر"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("END Áro"),
            keywords: &["Bak", "END Áro", "Áro"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("strzałka z napisem END"),
            keywords: &["koniec", "strzałka", "strzałka z napisem END"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د پای غشی"),
            keywords: &["د پای غشی", "غشی", "پای"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("seta \"END\""),
            keywords: &["fim", "seta", "seta \"END\"", "seta para a esquerda"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("seta END"),
            keywords: &["para o fim", "seta", "seta END"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("TUKUY wachʼi"),
            keywords: &["TUKUY wachʼi"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("săgeată cu textul END"),
            keywords: &["final", "săgeată", "săgeată cu textul END"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-726"),
            keywords: &["E10-726"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("стрелка «конец»"),
            keywords: &["конец", "стрелка «конец»", "стрелка конец"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("akambi ka END"),
            keywords: &["ahahera", "akambi ka END", "umwambi"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("پڇاڙي وارو تير"),
            keywords: &["تير", "پڇاڙي", "پڇاڙي وارو تير"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("අවස\u{dcf}නයට ඊතලය"),
            keywords: &["අවස\u{dcf}නයට", "ඊතලය"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("šípka END"),
            keywords: &["koniec", "šípka", "šípka END"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("puščica konec"),
            keywords: &["konec", "puščica"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("Fallaarta DHAMMAADKA"),
            keywords: &["Fallaarta DHAMMAADKA", "dhammaad", "fallaar"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("shigjeta e fundit"),
            keywords: &["fund", "shigjeta e fundit", "shigjetë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("стрелица за крај"),
            keywords: &["крaj", "стрeлицa", "стрелица за крај"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("strelica za kraj"),
            keywords: &["kraj", "strelica", "strelica za kraj"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("End med högerpil"),
            keywords: &["End med högerpil", "framåt", "högerpil"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mshale wa mwisho"),
            keywords: &["mshale", "mshale wa mwisho", "mwisho"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("முடிவு"),
            keywords: &["அம\u{bcd}புக\u{bcd}குறி", "முடிவு"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ముగ\u{c3f}స\u{c3f}ంద\u{c3f} బ\u{c3e}ణం"),
            keywords: &[
                "బ\u{c3e}ణం",
                "ముగ\u{c3f}ంపు",
                "ముగ\u{c3f}స\u{c3f}ంద\u{c3f} బ\u{c3e}ణం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("тири \"охир\""),
            keywords: &["охир", "тир", "тири \"охир\""],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ส\u{e34}\u{e49}นส\u{e38}ด"),
            keywords: &[
                "ล\u{e39}กศร",
                "ล\u{e39}กศรส\u{e34}\u{e49}นส\u{e38}ด",
                "ส\u{e34}\u{e49}นส\u{e38}ด",
            ],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("መወዳእታ ናይ ምልክት"),
            keywords: &["መወዳእታ", "መወዳእታ ናይ ምልክት", "ምልክት"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("END oky"),
            keywords: &["END oky", "ok", "soňy"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("ngahau NGATA"),
            keywords: &["NGATA", "ngahau"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("bitiş oku"),
            keywords: &["bitiş oku", "ok", "sol bitiş oku", "sol ok"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئاياغ كۆرسەتكۈچ"),
            keywords: &["ئاياغ", "كۆرسەتكۈچ"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("стрілка [END]"),
            keywords: &["кінець", "стрілка", "стрілка [END]"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("اختتام تیر"),
            keywords: &["اختتام", "تیر"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("berk chizig‘i"),
            keywords: &["berk", "berk chizig‘i", "chiziq"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("mũi tên END"),
            keywords: &["end", "mũi tên", "mũi tên END"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("fettu JEEX"),
            keywords: &["fett", "fettu JEEX", "jeex"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("utolo oluthi UKUPHELA"),
            keywords: &["ukuphela", "utolo", "utolo oluthi UKUPHELA"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ọfa IPARI"),
            keywords: &["ìparí", "Ọfa IPARI", "ọfà"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("結束箭咀"),
            keywords: &["箭咀", "結束", "結束箭咀"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("结束箭咀"),
            keywords: &["箭咀", "结束", "结束箭咀"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("结束箭头"),
            keywords: &["箭头", "结束", "结束箭头"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("結束"),
            keywords: &["結束"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("結束箭嘴"),
            keywords: &["結束", "結束箭嘴"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("umcibisholo wesiphetho"),
            keywords: &["isiphetho", "umcibisholo", "umcibisholo wesiphetho"],
        },
    ],
};
#[doc = "🔛"]
pub const ON_ARROW: crate::Emoji = crate::Emoji {
    glyph: "🔛",
    codepoint: "1F51B",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "ON! arrow",
    group: "Symbols",
    subgroup: "arrow",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("aan!-pyl"),
            keywords: &["aan", "aan!-pyl", "merk", "pyl"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("በርቷል! ቀስት"),
            keywords: &["ምልክት", "ቀስት", "በርቷል! ቀስት", "አብራ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("سهم تشغيل"),
            keywords: &[
                "تشغيل مع علامة تعجب وسهم",
                "تعجب",
                "سهم",
                "سهم تشغيل",
                "علامة تعجب",
            ],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("চ\u{9be}ল\u{9c1}! ক\u{9be}\u{981}ড\u{9bc}"),
            keywords: &[
                "ক\u{9be}\u{981}ড\u{9bc}",
                "চ\u{9be}ল\u{9c1}",
                "চ\u{9be}ল\u{9c1}! ক\u{9be}\u{981}ড\u{9bc}",
                "চিহ\u{9cd}ন",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("aktivdir! oxu"),
            keywords: &["aktivdir! oxu", "işarə", "ox", "üstündə"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("стрэлка «уключана!»"),
            keywords: &["актыўна", "стрэлка", "стрэлка «уключана!»", "уключана"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("стрелка с „on!“"),
            keywords: &["on", "стрелка", "стрелка с „on!“"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("অন! তীর"),
            keywords: &["অন! তীর", "চ\u{9be}ল\u{9c1}", "চিহ\u{9cd}ন", "তীর"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("strelica za uključeno"),
            keywords: &["oznaka", "strelica", "strelica za uključeno", "uključeno"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("fletxa amb la paraula ON!"),
            keywords: &["ON!", "fletxa", "fletxa amb la paraula ON!", "paraula"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎧᏂᎩᏓ! ᎦᏝᏗ"),
            keywords: &["ᎦᏝᏗ", "ᎧᏂᎩᏓ! ᎦᏝᏗ", "ᎪᏪᎸ", "ᏄᏍᏛᎢ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("šipky s nápisem ON!"),
            keywords: &["kupředu", "značka", "šipka", "šipky s nápisem ON!"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("saeth ON!"),
            keywords: &["marc", "saeth", "saeth ON!", "ymlaen"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("ON!-dobbeltpil"),
            keywords: &["ON!", "ON!-dobbeltpil", "ON!-pil", "dobbeltpil"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("ON!-Pfeil"),
            keywords: &["ON!-Pfeil", "Pfeil", "rechts und links"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("βέλος ON!"),
            keywords: &["βέλος", "βέλος ON!", "ενεργοποίηση", "σήμα"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("ON! arrow"),
            keywords: &["ON! arrow", "arrow", "mark", "on"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("flecha ON!"),
            keywords: &[
                "flecha",
                "flecha ON!",
                "flecha de doble punta con la palabra \"on\" encima",
                "on",
                "señal",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["flecha", "flecha ON!", "marca"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("nool ON!"),
            keywords: &["märk", "nool", "nool ON!"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("“on” testua duen gezia"),
            keywords: &["gezi", "markatu", "on", "“on” testua duen gezia"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("پیکان روشن"),
            keywords: &["روشن", "علامت", "پیکان"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("ON!-nuoli"),
            keywords: &["ON!-nuoli", "nuoli", "päällä"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("on! arrow"),
            keywords: &["ON!", "arrow", "naka-on", "on! arrow"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("ON! pílur"),
            keywords: &["ON! pílur", "on", "pílur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("flèche Activé"),
            keywords: &["flèche", "flèche Activé"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("étiquette « ON! » et flèche"),
            keywords: &["en marche", "flèche", "on", "étiquette « ON! » et flèche"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("saighead AR SIÚL!"),
            keywords: &["ar siúl", "marc", "on", "saighead", "saighead AR SIÚL!"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("saighead “ON”"),
            keywords: &["air", "comharra", "saighead", "saighead “ON”"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("frecha coa mensaxe \"en marcha!\" en inglés"),
            keywords: &[
                "acender",
                "acendido",
                "frecha",
                "frecha coa mensaxe \"en marcha!\" en inglés",
                "on!",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ચાલ\u{ac1}! તીર"),
            keywords: &[
                "ઉદ\u{acd}ગારવાચક",
                "ઉદ\u{acd}ગારવાચક ચિહ\u{acd}ન",
                "ઉદ\u{acd}ગારવાચક ચિહ\u{acd}ન અન\u{ac7} તીર સાથ\u{ac7} ચાલ\u{ac1}",
                "ચાલ\u{ac1} તીર",
                "ચાલ\u{ac1}! તીર",
                "તીર",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("Kibiyar A KUNNE!"),
            keywords: &["Kibiyar A KUNNE!", "a kunne", "kibiya", "maki"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("חץ פועל!"),
            keywords: &["חץ", "חץ פועל!", "פועל"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("on! तीर"),
            keywords: &["ON! तीर", "on! तीर", "चाल\u{942}", "चिह\u{94d}न", "तीर"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("strelica s natpisom \"on!\""),
            keywords: &[
                "oznaka",
                "strelica",
                "strelica s natpisom \"on!\"",
                "uključeno",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("bekapcsolva nyíl"),
            keywords: &["bekapcsolva", "jelzés", "nyíl"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("միացված է գրությամբ սլաք"),
            keywords: &["միացված է", "միացված է գրությամբ սլաք", "նշան", "սլաք"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("tanda panah ON!"),
            keywords: &["aktif", "panah", "tanda", "tanda panah ON!"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("NA! ube"),
            keywords: &["NA! ube", "akara", "na", "ube"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("kveikt-ör"),
            keywords: &[
                "Kveikt með upphrópunarmerki og ör",
                "kveikt-ör",
                "upphrópun",
                "upphrópunarmerki",
                "ör",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("freccia ON"),
            keywords: &[
                "ON con freccia e punto esclamativo",
                "freccia",
                "freccia ON",
                "punto esclamativo",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ON矢印"),
            keywords: &["ON", "ON矢印", "オン", "矢印"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("panah ON!"),
            keywords: &["on", "panah", "panah ON!", "tenger"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ისარი on!"),
            keywords: &["ისარი", "ისარი on!", "ნიშანი", "ჩართვა"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("urmid"),
            keywords: &["urmid"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("«қосулы» көрсеткісі"),
            keywords: &["«қосулы» көрсеткісі", "белгі", "көрсеткі", "қосулы"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("ON-pil"),
            keywords: &["ON med udråbstegn", "ON-pil", "på"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some(
                "ព\u{17d2}រ\u{17bd}ញទៅឆ\u{17d2}វេងទៅស\u{17d2}តា\u{17c6}មានអក\u{17d2}សរ ON នៅព\u{17b8}ក\u{17d2}រោម",
            ),
            keywords: &[
                "ON!",
                "ព\u{17d2}រ\u{17bd}ញ",
                "ព\u{17d2}រ\u{17bd}ញទៅឆ\u{17d2}វេងទៅស\u{17d2}តា\u{17c6}មានអក\u{17d2}សរ ON នៅព\u{17b8}ក\u{17d2}រោម",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಆನ\u{ccd}! ಬಾಣದ ಗುರುತು"),
            keywords: &[
                "ಆನ\u{ccd} ಬಾಣದ ಗುರುತು",
                "ಆನ\u{ccd}! ಬಾಣದ ಗುರುತು",
                "ಆಶ\u{ccd}ಚರ\u{ccd}ಯ ಗುರುತು",
                "ಆಶ\u{ccd}ಚರ\u{ccd}ಯ ಸ\u{cc2}ಚಕ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("켜짐"),
            keywords: &["양쪽 방향 화살표", "켜짐", "화살표"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("चाल\u{942}! बाण"),
            keywords: &["ख\u{942}ण", "चाल\u{942}", "चाल\u{942}! बाण", "बाण"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("күйүк! жебеси"),
            keywords: &["белги", "жебе", "күйүк! жебеси"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("UN!-Feil"),
            keywords: &["Feil", "Markéierung", "UN!-Feil", "un"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ລ\u{eb9}ກສອນ ເປ\u{eb5}ດ!"),
            keywords: &["ລ\u{eb9}ກສອນ", "ລ\u{eb9}ກສອນ ເປ\u{eb5}ດ!", "ເປ\u{eb5}ດ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("rodyklė su užrašu „On!“"),
            keywords: &["rodyklė", "rodyklė su užrašu „On!“", "žymė"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("bultiņa ar uzrakstu On!"),
            keywords: &["bultiņa", "bultiņa ar uzrakstu On!", "ieslēgts"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pere KĀ!"),
            keywords: &["kā", "pere", "pere KĀ!", "tohu"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("стрелка за вклучено"),
            keywords: &["вклучено", "стрелка", "стрелка за вклучено"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഓൺ ചെയ\u{d4d}യ\u{d41}ന\u{d4d}നതിന\u{d41}ള\u{d4d}ള അമ\u{d4d}പടയ\u{d3e}ളം"),
            keywords: &[
                "അടയ\u{d3e}ളം",
                "അമ\u{d4d}പടയ\u{d3e}ളം",
                "ഇര\u{d41}ഭ\u{d3e}ഗത\u{d4d}തേക\u{d4d}ക\u{d41}മ\u{d41}ള\u{d4d}ള ആരോ ബട\u{d4d}ടണ\u{d41}കളിൽ ഓകെ ചിഹ\u{d4d}നം",
                "ഓൺ ചെയ\u{d4d}യ\u{d41}ന\u{d4d}നതിന\u{d41}ള\u{d4d}ള അമ\u{d4d}പടയ\u{d3e}ളം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("дээр гэсэн сум"),
            keywords: &["дээр", "дээр гэсэн сум", "сум"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("चाल\u{942}! बाण"),
            keywords: &["चाल\u{942}", "चाल\u{942}! बाण", "चिन\u{94d}ह", "बाण"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("anak panah ON!"),
            keywords: &["anak panah", "anak panah ON!", "hidup", "tanda"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("vleġġa ON!"),
            keywords: &["fuq", "marka", "vleġġa", "vleġġa ON!"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဖ\u{103d}င\u{1037}\u{103a}ထားခြင\u{103a}းပြ မြား သင\u{103a}\u{1039}ကေတ"),
            keywords: &[
                "ဖ\u{103d}င\u{1037}\u{103a}ထားခြင\u{103a}းပြ မြား သင\u{103a}\u{1039}ကေတ",
                "ဖ\u{103d}င\u{1037}\u{103a}ထားပြ\u{102e}း ပြ သင\u{103a}\u{1039}ကေတ",
                "ဖ\u{103d}င\u{1037}\u{103a}ထားပြ\u{102e}းပြ မြား သင\u{103a}\u{1039}ကေတ",
                "မြား",
                "အမ\u{103e}တ\u{103a}အသား",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("ON!-pil"),
            keywords: &["ON", "ON!-pil", "PÅ", "pil", "utrop", "utropstegn"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("चलिरह\u{947}को! स\u{902}क\u{947}त गर\u{94d}न\u{947} वाण"),
            keywords: &[
                "चलिरह\u{947}को! स\u{902}क\u{947}त गर\u{94d}न\u{947} वाण",
                "चिन\u{94d}ह",
                "मा",
                "वाण",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("ON!-pijl"),
            keywords: &["ON!-pijl", "aan", "pijl", "teken"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("ON!-pil"),
            keywords: &["ON", "ON!-pil", "PÅ", "pil", "utrop", "utropsteikn"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଅନ\u{b4d}\u{200c}! ତୀର"),
            keywords: &[
                "ଅନ\u{b4d}\u{200c}",
                "ଅନ\u{b4d}\u{200c}! ତୀର",
                "ଚ\u{b3f}ହ\u{b4d}ନ",
                "ତୀର",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਦ\u{a4b} ਪਾਸ\u{a47} ਚਾਲ\u{a42} ਵ\u{a71}ਲ ਇਸ\u{a3c}ਾਰਾ ਕਰਨ ਵਾਲਾ ਤੀਰ"),
            keywords: &[
                "ON ਤੀਰ",
                "ON ਹ\u{a48}ਰਾਨੀਵਾਚਕ ਨਿਸ\u{a3c}ਾਨ ਨਾਲ ਅਤ\u{a47} ਤੀਰ",
                "ਤੀਰ",
                "ਦ\u{a4b} ਪਾਸ\u{a47} ਚਾਲ\u{a42} ਵ\u{a71}ਲ ਇਸ\u{a3c}ਾਰਾ ਕਰਨ ਵਾਲਾ ਤੀਰ",
                "ਹ\u{a48}ਰਾਨੀਵਾਚਕ",
                "ਹ\u{a48}ਰਾਨੀਵਾਚਕ ਨਿਸ\u{a3c}ਾਨ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("چلان دا تیر"),
            keywords: &["تیر", "نشان لانا", "چلان دا تیر", "چلانا"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("ON! Áro"),
            keywords: &["Mak", "ON! Áro", "Áro", "Ọn"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("strzałka z napisem ON!"),
            keywords: &["strzałka", "strzałka z napisem ON!", "włączone"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("چالو! غشی"),
            keywords: &["غشی", "نښه", "چالو", "چالو! غشی"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("seta \"ON!\""),
            keywords: &["ON!", "marca", "on", "seta", "seta \"ON!\""],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("seta ON!"),
            keywords: &["ligado", "seta", "seta ON!"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("¡KAWSARICHIY! wachʼi"),
            keywords: &["¡KAWSARICHIY! wachʼi"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("săgeată cu textul ON!"),
            keywords: &["marcaj", "săgeată", "săgeată cu textul ON!"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-727"),
            keywords: &["E10-727"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("стрелка «активно»"),
            keywords: &[
                "активно",
                "включено",
                "стрелка «активно»",
                "стрелка активно",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("akambi ka BIRAFUNGUYE!"),
            keywords: &["akambi ka BIRAFUNGUYE!", "ikimenyetso", "kuri", "umwambi"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("آن! تير"),
            keywords: &["آن", "آن! تير", "تير", "نشان"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ක\u{dca}\u{200d}ර\u{dd2}ය\u{dcf}ත\u{dca}මකය\u{dd2}! ඊතලය"),
            keywords: &[
                "ඊතලය",
                "ක\u{dca}\u{200d}ර\u{dd2}ය\u{dcf}ත\u{dca}මක",
                "ක\u{dca}\u{200d}ර\u{dd2}ය\u{dcf}ත\u{dca}මකය\u{dd2}! ඊතලය",
                "ලක\u{dd4}ණ",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("šípka ON!"),
            keywords: &["zapnuté", "značka", "šípka", "šípka ON!"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("puščica NAPREJ!"),
            keywords: &["puščica", "puščica NAPREJ!", "vklop", "znak"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("fallaarta DUSHA!"),
            keywords: &["calaamad", "dusha", "fallaar", "fallaarta DUSHA!"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("shigjeta aktive!"),
            keywords: &["aktiv", "aktive", "shenjë", "shigjeta aktive!", "shigjetë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("стрелица за укључено"),
            keywords: &["oзнaкa", "стрeлицa", "стрелица за укључено", "укључeнo"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("strelica za uključeno"),
            keywords: &["oznaka", "strelica", "strelica za uključeno", "uključeno"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("ON! med pil höger och vänster ovanför"),
            keywords: &[
                "ON! med pil höger och vänster ovanför",
                "pil höger och vänster",
                "utropstecken",
            ],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mshale wa hewani!"),
            keywords: &["alama", "hewani", "mshale", "mshale wa hewani!"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ஆன\u{bcd}"),
            keywords: &[
                "அம\u{bcd}புக\u{bcd}குறி",
                "ஆன\u{bcd}",
                "ஆன\u{bcd}! அம\u{bcd}புக\u{bcd}குறி",
                "குறி",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ఇరువ\u{c48}పులు బ\u{c3e}ణం"),
            keywords: &[
                "ఇరువ\u{c48}పుల\u{c3e} ప\u{c4d}రవ\u{c47}శం ఉంద\u{c3f}",
                "ఇరువ\u{c48}పులు బ\u{c3e}ణం",
                "ఎల\u{c3e}గ\u{c48}న\u{c3e} వ\u{c46}ళ\u{c4d}లవచ\u{c4d}చు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("тири \"фаъол!\""),
            keywords: &["нишона", "тир", "тири \"фаъол!\"", "фаъол"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เป\u{e34}ด"),
            keywords: &["ล\u{e39}กศร", "เป\u{e34}ด"],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ኣብ ልዕሊ! ምልክት"),
            keywords: &["መፈለጥታ", "ምልክት", "ኣብ ልዕሊ", "ኣብ ልዕሊ! ምልክት"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ON! oky"),
            keywords: &["ON! oky", "açyk", "bellik", "ok"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("ngahau FUNGA"),
            keywords: &["FUNGA", "ngahau"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("açık oku"),
            keywords: &[
                "açık oku",
                "ok",
                "ünlem",
                "ünlem işareti",
                "ünlem işareti ve okla AÇIK",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئوچۇق! كۆرسەتكۈچ"),
            keywords: &["ئوچۇق", "ئوچۇق! كۆرسەتكۈچ", "بەلگە", "كۆرسەتكۈچ"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("стрілка [ON!]"),
            keywords: &["ввімкнено", "значок", "стрілка", "стрілка [ON!]"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("آن! تیر"),
            keywords: &["آن", "آن! تیر", "تیر"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("efirda chizig‘i"),
            keywords: &["belgi", "chiziq", "efirda", "efirda chizig‘i"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("mũi tên ON!"),
            keywords: &["dấu", "mũi tên", "mũi tên ON!", "on"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("fettu ci TAAL"),
            keywords: &["fett", "fettu ci TAAL", "mark", "taal"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("utolo oluthi iLayitile!"),
            keywords: &["ilayitile", "uphawu", "utolo", "utolo oluthi iLayitile!"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ọfa LORI!"),
            keywords: &["lórí", "o\u{329}fà", "àmì", "Ọfa LORI!"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("「在」箭咀"),
            keywords: &["「在」箭咀", "在", "標誌", "箭咀"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("“在”箭咀"),
            keywords: &["“在”箭咀", "在", "标志", "箭咀"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("ON! 箭头"),
            keywords: &["ON", "ON! 箭头", "开始", "标识", "箭头"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("ON"),
            keywords: &["ON"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("「On!」箭嘴"),
            keywords: &["「On!」", "「On!」箭嘴"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("kuvuliwe! umcibisholo"),
            keywords: &["kuvuliwe", "kuvuliwe! umcibisholo", "umcibisholo", "uphawu"],
        },
    ],
};
#[doc = "🔜"]
pub const SOON_ARROW: crate::Emoji = crate::Emoji {
    glyph: "🔜",
    codepoint: "1F51C",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "SOON arrow",
    group: "Symbols",
    subgroup: "arrow",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("binnekortpyl"),
            keywords: &["binnekort", "binnekortpyl", "gou", "pyl"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("በቅርቡ ይመጣል ቀስት"),
            keywords: &["ቀስት", "በቅርቡ", "በቅርቡ ይመጣል ቀስት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("سهم علامة قريب\u{64b}ا"),
            keywords: &[
                "سهم",
                "سهم علامة قريب\u{64b}ا",
                "علامة قريب\u{64b}ا",
                "قريب\u{64b}ا",
                "قريب\u{64b}ا مع سهم أيمن",
            ],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("শীঘ\u{9cd}ৰে ক\u{9be}\u{981}ড\u{9bc}"),
            keywords: &[
                "ক\u{9be}\u{981}ড\u{9bc}",
                "শীঘ\u{9cd}ৰে ক\u{9be}\u{981}ড\u{9bc}",
                "সোনক\u{9be}লে",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("tezliklə oxu"),
            keywords: &["ox", "tezliklə", "tezliklə oxu"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("стрэлка «неўзабаве»"),
            keywords: &["неўзабаве", "стрэлка", "стрэлка «неўзабаве»"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("стрелка със soon"),
            keywords: &["soon", "стрелка", "стрелка със soon"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("শীঘ\u{9cd}র তীর"),
            keywords: &["তীর", "শীঘ\u{9cd}র তীর", "শীঘ\u{9cd}রই"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("strelica za uskoro"),
            keywords: &["strelica", "strelica za uskoro", "uskoro"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("fletxa amb la paraula Soon"),
            keywords: &["Soon", "fletxa", "fletxa amb la paraula Soon", "paraula"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏞᎩᏭ ᎦᏝᏗ"),
            keywords: &["ᎦᏝᏗ", "ᏞᎩᏭ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("šipka s nápisem SOON"),
            keywords: &["brzy", "šipka", "šipka s nápisem SOON"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("saeth SOON"),
            keywords: &["cyn bo hir", "saeth", "saeth SOON"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("SOON-pil"),
            keywords: &["SOON-pil", "snart med højrepil", "snart-tegn"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("SOON-Pfeil"),
            keywords: &["Pfeil", "SOON-Pfeil", "rechts"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("βέλος SOON"),
            keywords: &["βέλος", "βέλος SOON", "σύντομα"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("SOON arrow"),
            keywords: &["SOON arrow", "arrow", "soon"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("flecha SOON"),
            keywords: &[
                "flecha",
                "flecha SOON",
                "soon",
                "soon con flecha a la derecha",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["flecha", "flecha SOON", "pronto"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("nool SOON"),
            keywords: &["nool", "nool SOON", "varsti"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("“soon” testua duen gezia"),
            keywords: &["gezi", "soon", "“soon” testua duen gezia"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("پیکان به\u{200c}زودی"),
            keywords: &["به\u{200c}زودی", "پیکان"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("SOON-nuoli"),
            keywords: &["SOON-nuoli", "nuoli", "tulossa"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("soon arrow"),
            keywords: &["SOON", "arrow", "malapit na", "soon arrow"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("SOON pílur"),
            keywords: &["SOON pílur", "pílur", "soon"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("flèche Bientôt"),
            keywords: &["flèche", "flèche Bientôt"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("étiquette « SOON » et flèche"),
            keywords: &["bientôt", "flèche", "soon", "étiquette « SOON » et flèche"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("saighead GO LUATH"),
            keywords: &["go luath agus saighead ar dheis", "saighead GO LUATH"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("saighead “SOON”"),
            keywords: &["a dh’aithghearr", "saighead", "saighead “SOON”"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("frecha coa mensaxe \"pronto\" en inglés"),
            keywords: &[
                "frecha",
                "frecha coa mensaxe \"pronto\" en inglés",
                "pronto",
                "soon",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("જલ\u{acd}દીન\u{ac1}\u{a82} તીર"),
            keywords: &[
                "જમણા\u{a82} તીર સાથ\u{ac7} જલ\u{acd}દી",
                "જલ\u{acd}દી",
                "જલ\u{acd}દીન\u{ac1}\u{a82} ચિહ\u{acd}ન",
                "જલ\u{acd}દીન\u{ac1}\u{a82} તીર",
                "તીર",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("Kibiyar BA DA DAƊEWA BA"),
            keywords: &["Kibiyar BA DA DAƊEWA BA", "ba da daɗewa ba", "kibiya"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("חץ בקרוב"),
            keywords: &["בקרוב", "חץ"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("SOON तीर"),
            keywords: &["SOON तीर", "जल\u{94d}दी", "तीर"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("strelica s natpisom \"soon\""),
            keywords: &["strelica", "strelica s natpisom \"soon\"", "uskoro"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("hamarosan nyíl"),
            keywords: &["hamarosan", "jön", "nyíl"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("շուտով գրությամբ սլաք"),
            keywords: &["շուտով", "շուտով գրությամբ սլաք", "սլաք"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("tanda panah SOON"),
            keywords: &["panah", "segera", "tanda panah SOON"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("UBE mgbe adịghị anya"),
            keywords: &["UBE mgbe adịghị anya", "mgbe adịghị anya", "ube"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("bráðum-ör"),
            keywords: &[
                "bráðum",
                "bráðum með vinstri ör",
                "bráðum-merki",
                "bráðum-ör",
                "ör",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("freccia SOON"),
            keywords: &[
                "freccia",
                "freccia SOON",
                "presto",
                "simbolo soon",
                "soon con freccia verso destra",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("SOON矢印"),
            keywords: &["SOON", "SOON矢印", "すぐ", "矢印"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("panah SOON"),
            keywords: &["gage", "panah", "panah SOON", "soon"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ისარი soon"),
            keywords: &["ისარი", "ისარი soon", "მალე"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("Aneccab Qrib"),
            keywords: &["Aneccab Qrib"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("«жақында» көрсеткісі"),
            keywords: &["«жақында» көрсеткісі", "жақында", "көрсеткі"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("snart"),
            keywords: &["snart", "snart med højrepil", "snart-tegn"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some(
                "ព\u{17d2}រ\u{17bd}ញទៅស\u{17d2}តា\u{17c6}មានអក\u{17d2}សរ Soon នៅព\u{17b8}ក\u{17d2}រោម",
            ),
            keywords: &[
                "SOON",
                "ព\u{17d2}រ\u{17bd}ញ",
                "ព\u{17d2}រ\u{17bd}ញទៅស\u{17d2}តា\u{17c6}មានអក\u{17d2}សរ Soon នៅព\u{17b8}ក\u{17d2}រោម",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ತಕ\u{ccd}ಷಣ ಚ\u{cbf}ಹ\u{ccd}ನ\u{cc6}"),
            keywords: &[
                "ತಕ\u{ccd}ಷಣ",
                "ತಕ\u{ccd}ಷಣ ಚ\u{cbf}ಹ\u{ccd}ನ\u{cc6}",
                "ಬಲ ಬಾಣದ ಗುರುತ\u{cbf}ನೊಂದ\u{cbf}ಗ\u{cc6} ತಕ\u{ccd}ಷಣ",
                "ಬಾಣ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("곧"),
            keywords: &[
                "곧",
                "곧 진행된다는 신호",
                "곧 진행된다는 표시",
                "곧 진행된다는 화살표",
                "화살표",
            ],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("रोखड\u{947}\u{902}च बाण"),
            keywords: &["बाण", "रोखड\u{947}\u{902}च"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("жакында жебеси"),
            keywords: &["жакында", "жакында жебеси", "жебе"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("GESCHWËNN-Feil"),
            keywords: &["Feil", "GESCHWËNN-Feil", "geschwënn"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ລ\u{eb9}ກສອນ ໄວໆນ\u{eb5}\u{ec9}"),
            keywords: &["ລ\u{eb9}ກສອນ", "ໄວໆນ\u{eb5}\u{ec9}"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("rodyklė su užrašu „Soon“"),
            keywords: &["greitai", "rodyklė", "rodyklė su užrašu „Soon“"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("bultiņa ar uzrakstu Soon"),
            keywords: &["bultiņa", "bultiņa ar uzrakstu Soon", "drīz"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pere ĀKUANEI"),
            keywords: &["pere", "pere ĀKUANEI", "ākuanei"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("стрелка за наскоро"),
            keywords: &["наскоро", "стрелка", "стрелка за наскоро"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some(
                "ഉടൻ തന\u{d4d}നെ എന\u{d4d}ന\u{d4d} അർത\u{d4d}ഥമ\u{d3e}ക\u{d4d}ക\u{d41}ന\u{d4d}ന അമ\u{d4d}പടയ\u{d3e}ളം",
            ),
            keywords: &[
                "അമ\u{d4d}പടയ\u{d3e}ളം",
                "ഉടൻ തന\u{d4d}നെ എന\u{d4d}ന\u{d4d} അർത\u{d4d}ഥമ\u{d3e}ക\u{d4d}ക\u{d41}ന\u{d4d}ന അമ\u{d4d}പടയ\u{d3e}ളം",
                "വലത\u{d4d}തോട\u{d4d}ട\u{d41}ള\u{d4d}ള ആരോയ\u{d4d}ക\u{d4d}കൊപ\u{d4d}പം ഉടനടി",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("удахгүй гэсэн сум"),
            keywords: &["сум", "удахгүй", "удахгүй гэсэн сум"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("लवकरच बाण"),
            keywords: &["बाण", "लवकरच"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("anak panah ‘SOON’"),
            keywords: &["anak panah", "anak panah ‘SOON’", "tidak lama lagi"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("vleġġa SOON"),
            keywords: &["mill-aktar fis", "vleġġa", "vleġġa SOON"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("မကြာမ\u{102e} မြား"),
            keywords: &[
                "မကြာမ\u{102e} ပြ သင\u{103a}\u{1039}ကေတ",
                "မကြာမ\u{102e} မြား",
                "မကြာမ\u{102e}ပြ မြား သင\u{103a}\u{1039}ကေတ",
                "မြား",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("SOON-pil"),
            keywords: &["SOON-pil", "pil", "snart", "snart med pil"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("छिट\u{94d}ट\u{948} आउन\u{947} स\u{902}क\u{947}त गर\u{94d}न\u{947} वाण"),
            keywords: &[
                "आउन\u{947}",
                "छिट\u{94d}ट\u{948} आउन\u{947} स\u{902}क\u{947}त गर\u{94d}न\u{947} वाण",
                "वाण",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("SOON-pijl"),
            keywords: &["SOON-pijl", "binnenkort", "pijl"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("SOON-pil"),
            keywords: &["SOON-pil", "pil", "snart", "snart med pil"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଶୀଘ\u{b4d}ର ତୀର"),
            keywords: &["ତୀର", "ଶୀଘ\u{b4d}ର"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਜਲਦ ਹੀ ਵ\u{a71}ਲ ਇਸ\u{a3c}ਾਰਾ ਕਰਨ ਵਾਲਾ ਤੀਰ"),
            keywords: &[
                "ਜਲਦ ਹੀ ਵ\u{a71}ਲ ਇਸ\u{a3c}ਾਰਾ ਕਰਨ ਵਾਲਾ ਤੀਰ",
                "ਜਲਦੀ",
                "ਜਲਦੀ ਨਿਸ\u{a3c}ਾਨ",
                "ਜਲਦੀ ਨਿਸ\u{a3c}ਾਨ ਸ\u{a71}ਜ\u{a47} ਤੀਰ ਨਾਲ",
                "ਤੀਰ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("چھیتی دا تیر"),
            keywords: &["تیر", "چ\u{650}ھیتی", "چھیتی دا تیر"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("SOON Áro"),
            keywords: &["SOON Áro", "Soon", "Áro"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("strzałka z napisem SOON"),
            keywords: &["strzałka", "strzałka z napisem SOON", "wkrótce"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ژر غشی"),
            keywords: &["غشی", "ژر"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("seta \"SOON\""),
            keywords: &["seta", "seta \"SOON\"", "soon"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("seta SOON"),
            keywords: &["brevemente", "seta", "seta SOON"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("QATIQ wachʼi"),
            keywords: &["QATIQ wachʼi"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("săgeată cu textul SOON"),
            keywords: &["curând", "săgeată", "săgeată cu textul SOON"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-728"),
            keywords: &["E10-728"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("стрелка «скоро»"),
            keywords: &["скоро", "стрелка «скоро»", "стрелка скоро"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("akambi ka SOON"),
            keywords: &["akambi ka SOON", "umwambi", "vuba cyane"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("جلدي تير"),
            keywords: &["تير", "جلدي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ඉක\u{dca}මන\u{dca} ඊතලය"),
            keywords: &[
                "ඉක\u{dca}මන\u{dca} ඊතලය",
                "ඉක\u{dca}මන\u{dd2}න\u{dca}",
                "ඊතලය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("šípka SOON"),
            keywords: &["čoskoro", "šípka", "šípka SOON"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("puščica kmalu"),
            keywords: &["kmalu", "puščica"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("falaarta DHAKHSASHADA"),
            keywords: &["dhakhsasho", "falaar", "falaarta DHAKHSASHADA"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("shigjeta shpejt"),
            keywords: &["shigjeta shpejt", "shigjetë", "shpejt"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("стрелица за ускоро"),
            keywords: &["стрeлицa", "стрелица за ускоро", "ускoрo"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("strelica za uskoro"),
            keywords: &["strelica", "strelica za uskoro", "uskoro"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("Soon med högerpil ovanför"),
            keywords: &["Soon med högerpil ovanför", "högerpil", "pil"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mshale unaoashiria hivi karibuni"),
            keywords: &[
                "hivi karibuni",
                "mshale",
                "mshale unaoashiria hivi karibuni",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ச\u{bc0}க\u{bcd}கிரம\u{bcd}"),
            keywords: &[
                "அம\u{bcd}புக\u{bcd}குறி",
                "ச\u{bc0}க\u{bcd}கிரம\u{bcd}",
                "விரைவில\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("సమ\u{c40}ప\u{c3f}స\u{c4d}త\u{c4b}ంద\u{c3f} బ\u{c3e}ణం"),
            keywords: &[
                "త\u{c4d}వరల\u{c4b} ర\u{c3e}బ\u{c4b}తుంద\u{c3f}",
                "దగ\u{c4d}గరల\u{c4b} ఉంద\u{c3f}",
                "సమ\u{c40}ప\u{c3f}స\u{c4d}త\u{c4b}ంద\u{c3f} బ\u{c3e}ణం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("тири \"ба қарибӣ\""),
            keywords: &["ба қарибӣ", "тир", "тири \"ба қарибӣ\""],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ส\u{e31}ญล\u{e31}กษณ\u{e4c}เร\u{e47}วๆ น\u{e35}\u{e49}"),
            keywords: &[
                "ล\u{e39}กศร",
                "ส\u{e31}ญล\u{e31}กษณ\u{e4c}เร\u{e47}วๆ น\u{e35}\u{e49}",
            ],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ቕልጡፍ ምልክት"),
            keywords: &["ምልክት", "ቕልጡፍ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("SOON oky"),
            keywords: &["SOON oky", "bahym", "ok"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("ngahau OFI"),
            keywords: &["OFI", "ngahau"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("yakında işareti"),
            keywords: &["Yakında", "ok", "sağ okla Yakında", "yakında işareti"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("يېقىندا دېگەن كۆرسەتكۈچ"),
            keywords: &["كۆرسەتكۈچ", "يېقىندا", "يېقىندا دېگەن كۆرسەتكۈچ"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("стрілка [SOON]"),
            keywords: &["незабаром", "стрілка", "стрілка [SOON]"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("جلد تیر"),
            keywords: &["تیر", "جلد"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("tez orada chizig‘i"),
            keywords: &["chiziq", "tez orada chizig‘i", "tezda"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("mũi tên SOON"),
            keywords: &["mũi tên", "mũi tên SOON", "soon"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("fettu CI KANAM"),
            keywords: &["ci kanam", "fett", "fettu CI KANAM"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("utolo oluthi KUNGEKUDALA"),
            keywords: &["kungekudala", "utolo", "utolo oluthi KUNGEKUDALA"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ọfa LAIPẸ"),
            keywords: &["láìpẹ\u{301}", "o\u{329}fà", "Ọfa LAIPẸ"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("「不久」箭咀"),
            keywords: &["「不久」箭咀", "不久", "箭咀"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("“不久”箭咀"),
            keywords: &["“不久”箭咀", "不久", "箭咀"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("SOON 箭头"),
            keywords: &["SOON 箭头", "箭头", "马上"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("馬上"),
            keywords: &["馬上"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("soon 標誌的箭嘴"),
            keywords: &["soon 標誌的箭嘴", "即將"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("umcibisholo wokushesha"),
            keywords: &["ngokushesha", "umcibisholo", "umcibisholo wokushesha"],
        },
    ],
};
#[doc = "🔝"]
pub const TOP_ARROW: crate::Emoji = crate::Emoji {
    glyph: "🔝",
    codepoint: "1F51D",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "TOP arrow",
    group: "Symbols",
    subgroup: "arrow",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("toppyl"),
            keywords: &["bopunt", "op", "pyl", "top", "toppyl"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ከፍተኛ ጠቋሚ ቀስት"),
            keywords: &["ላይ", "ቀስት", "ከፍተኛ", "ከፍተኛ ጠቋሚ ቀስት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("السهم لأعلى"),
            keywords: &["أعلى", "أعلى مع سهم لأعلى", "السهم لأعلى", "سهم لأعلى"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("শীৰ\u{9cd}ষ ক\u{9be}\u{981}ড\u{9bc}"),
            keywords: &["ওপৰলৈ", "ক\u{9be}\u{981}ড\u{9bc}", "শীৰ\u{9cd}ষ"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("yuxarı yönəlmiş ox"),
            keywords: &["ox", "yuxarı", "yuxarı yönəlmiş ox", "üst"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("стрэлка «верх»"),
            keywords: &["дагары", "стрэлка", "стрэлка «верх»", "уверх", "угару"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("стрелка с top"),
            keywords: &["top", "нагоре", "стрелка", "стрелка с top"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("শীর\u{9cd}ষের তীর"),
            keywords: &[
                "উর\u{9cd}দ\u{9cd}ধম\u{9c1}খী",
                "তীর",
                "শীর\u{9cd}ষ",
                "শীর\u{9cd}ষের তীর",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("strelica za gore"),
            keywords: &["gore", "strelica", "strelica za gore"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("fletxa amb la paraula Top"),
            keywords: &["Top", "fletxa", "fletxa amb la paraula Top", "paraula"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎦᏚ ᎦᏝᏗ"),
            keywords: &["ᎦᎸᎳᏗᏜ", "ᎦᏚ", "ᎦᏝᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("šipka s nápisem TOP"),
            keywords: &[
                "nahoru",
                "neklopit",
                "vzhůru",
                "šipka",
                "šipka s nápisem TOP",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("saeth TOP"),
            keywords: &["i fyny", "saeth", "saeth TOP", "top"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("TOP-pil"),
            keywords: &["TOP-pil", "pil peger op", "toppil"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("TOP-Pfeil"),
            keywords: &["Pfeil nach oben", "TOP-Pfeil"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("βέλος TOP"),
            keywords: &["βέλος", "βέλος TOP", "επάνω", "κορυφή"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("TOP arrow"),
            keywords: &["TOP arrow", "arrow", "top", "up"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("flecha TOP"),
            keywords: &[
                "arriba",
                "flecha TOP",
                "flecha hacia arriba",
                "top",
                "top con flecha hacia arriba",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["arriba", "flecha", "flecha TOP", "subir"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("nool TOP"),
            keywords: &["nool", "nool TOP", "üles"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("“top” testua duen gezia"),
            keywords: &["gezi", "gora", "top", "“top” testua duen gezia"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("پیکان رو"),
            keywords: &["بالا", "برتر", "پیکان", "پیکان رو"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("TOP-nuoli"),
            keywords: &["TOP-nuoli", "alkuun", "nuoli"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("top arrow"),
            keywords: &["IBABAW", "arrow", "itaas", "top arrow", "tuktok"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("TOP pílur"),
            keywords: &["TOP pílur", "pílur top"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("flèche En haut"),
            keywords: &["flèche", "flèche En haut"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("étiquette « TOP » et flèche"),
            keywords: &[
                "dessus",
                "flèche",
                "haut",
                "top",
                "étiquette « TOP » et flèche",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("saighead BHAIRR"),
            keywords: &["barr agus saighead thuas", "saighead BHAIRR"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("saighead “TOP”"),
            keywords: &[
                "barr",
                "ceann",
                "mullach",
                "saighead",
                "saighead “TOP”",
                "suas",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("frecha coa mensaxe \"destacado\" en inglés"),
            keywords: &[
                "arriba",
                "frecha",
                "frecha coa mensaxe \"destacado\" en inglés",
                "mellor",
                "principal",
                "top",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ટોચન\u{ac1}\u{a82} ચિહ\u{acd}ન"),
            keywords: &[
                "ઉપર",
                "ઉપર તીર",
                "ઉપરના\u{a82} તીર સાથ\u{ac7} ટોચ",
                "ટોચ",
                "ટોચન\u{ac1}\u{a82} ચિહ\u{acd}ન",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("Kibiya KAI"),
            keywords: &["Kibiya KAI", "kan", "kibiya", "sama"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("חץ מעלה"),
            keywords: &["חץ", "חץ מעלה", "למעלה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("TOP तीर"),
            keywords: &[
                "TOP तीर",
                "ऊपर",
                "ऊपर तीर",
                "ऊपर तीर क\u{947} साथ शीर\u{94d}ष",
                "शीर\u{94d}ष",
                "शीर\u{94d}ष चिह\u{94d}न",
                "शीर\u{94d}ष चिह\u{94d}न, ऊपर तीर क\u{947} साथ शीर\u{94d}ष",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("strelica s natpisom \"top\""),
            keywords: &["gore", "strelica", "strelica s natpisom \"top\"", "vrh"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("csúcsra nyíl"),
            keywords: &["csúcsra nyíl", "felfelé", "nyíl", "top"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("վերև գրությամբ սլաք"),
            keywords: &["սլաք", "վեր", "վերև", "վերև գրությամբ սլաք"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("tanda panah TOP"),
            keywords: &["ke atas", "panah", "tanda panah TOP"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("UBE kachasị elu"),
            keywords: &["UBE kachasị elu", "dị elu", "kachasị", "ube"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("efst-ör"),
            keywords: &["efst", "efst-ör", "upp", "uppör", "ör"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("freccia TOP"),
            keywords: &[
                "Top con freccia verso l’alto",
                "alto",
                "freccia TOP",
                "freccia verso l’alto",
                "simbolo Top",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("TOP矢印"),
            keywords: &["TOP", "TOP矢印", "トップ", "上", "矢印"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("panah TOP"),
            keywords: &["munggah", "panah", "panah TOP", "top"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ისარი top"),
            keywords: &["ზემოთ", "ისარი", "ისარი top"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("aneccab n ufalla"),
            keywords: &["aneccab n ufalla"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("«негізгі» көрсеткісі"),
            keywords: &["«негізгі» көрсеткісі", "жоғары", "көрсеткі", "үстіне"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("top"),
            keywords: &["pil peger op", "top", "toppil"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ព\u{17d2}រ\u{17bd}ញទៅលើមានអក\u{17d2}សរ Top នៅព\u{17b8}ក\u{17d2}រោម"),
            keywords: &[
                "TOP",
                "ព\u{17d2}រ\u{17bd}ញ",
                "ព\u{17d2}រ\u{17bd}ញទៅលើមានអក\u{17d2}សរ Top នៅព\u{17b8}ក\u{17d2}រោម",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಮೇಲ\u{cbf}ನ ಬಾಣದ ಗುರುತು"),
            keywords: &[
                "ಮೇಲ\u{cbf}ನ ಬಾಣ",
                "ಮೇಲ\u{cbf}ನ ಬಾಣದ ಗುರುತ\u{cbf}ನೊಂದ\u{cbf}ಗ\u{cc6} ಮೇಲ\u{cc6}",
                "ಮೇಲ\u{cbf}ನ ಬಾಣದ ಗುರುತು",
                "ಮೇಲ\u{cc6}",
                "ಮೇಲ\u{cc6} ಚ\u{cbf}ಹ\u{ccd}ನ\u{cc6}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("위로 화살표"),
            keywords: &["상단", "위로 화살표", "위쪽 화살표", "위쪽으로", "화살표"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("वयर ख\u{942}ण करपी बाण"),
            keywords: &[
                "बाण",
                "वयर",
                "वयर ख\u{941}णावपी बाण",
                "वयर ख\u{942}ण करपी बाण",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("башында жебеси"),
            keywords: &["башы", "башында жебеси", "жебе", "өйдө"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("TOP-Feil"),
            keywords: &["Feil", "TOP-Feil", "Top", "no uewen"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ລ\u{eb9}ກສອນຊ\u{eb5}\u{ec9}ຂ\u{eb6}\u{ec9}ນ"),
            keywords: &[
                "ຂ\u{eb6}\u{ec9}ນ",
                "ລ\u{eb9}ກສອນ",
                "ລ\u{eb9}ກສອນຊ\u{eb5}\u{ec9}ຂ\u{eb6}\u{ec9}ນ",
                "ເທ\u{eb4}ງສ\u{eb8}ດ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("rodyklė su užrašu „Top“"),
            keywords: &["rodyklė", "rodyklė su užrašu „Top“", "viršus", "į viršų"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("bultiņa ar uzrakstu Top"),
            keywords: &["augšup", "bultiņa", "bultiņa ar uzrakstu Top"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pere RUNGA"),
            keywords: &["ake", "pere", "pere RUNGA", "runga"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("стрелка за горе"),
            keywords: &["горе", "стрелка", "стрелка за горе"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some(
                "മ\u{d41}കളിലേക\u{d4d}ക\u{d41}ള\u{d4d}ള അമ\u{d4d}പടയ\u{d3e}ളത\u{d4d}തിനൊപ\u{d4d}പം ടോപ\u{d4d}പ\u{d4d}",
            ),
            keywords: &[
                "അമ\u{d4d}പടയ\u{d3e}ളം",
                "മ\u{d41}കളിലേക\u{d4d}ക\u{d41}ള\u{d4d}ള അമ\u{d4d}പടയ\u{d3e}ളത\u{d4d}തിനൊപ\u{d4d}പം ടോപ\u{d4d}പ\u{d4d}",
                "മ\u{d41}കളിലേക\u{d4d}ക\u{d41}ള\u{d4d}ള ആരോയ\u{d4d}ക\u{d4d}കൊപ\u{d4d}പം ടോപ\u{d4d}പ\u{d4d}",
                "മ\u{d41}കളിൽ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("дээшээ гэсэн сум"),
            keywords: &["дээш", "дээшээ гэсэн сум", "сум"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("शीर\u{94d}ष बाण"),
            keywords: &["बाण", "वर", "शीर\u{94d}ष बाण"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("anak panah ‘TOP’"),
            keywords: &["anak panah", "anak panah ‘TOP’", "atas", "top"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("vleġġa TOP"),
            keywords: &["fuq", "vleġġa", "vleġġa TOP", "’il fuq"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ထ\u{102d}ပ\u{103a}သ\u{102d}\u{102f}\u{1037} မြား"),
            keywords: &[
                "ထ\u{102d}ပ\u{103a}သ\u{102d}\u{102f}\u{1037} မြား",
                "မြား",
                "အထက\u{103a}သ\u{102d}\u{102f}\u{1037}",
                "အပေါ\u{103a}သ\u{102d}\u{102f}\u{1037}",
                "အပေါ\u{103a}သ\u{102d}\u{102f}\u{1037}ပြ မြား သင\u{103a}\u{1039}ကေတ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("TOP-pil"),
            keywords: &["TOP", "TOP-pil", "opp", "pil opp", "topp", "topp med pil"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("माथिको स\u{902}क\u{947}त गर\u{94d}न\u{947} वाण"),
            keywords: &[
                "माथि",
                "माथिको स\u{902}क\u{947}त गर\u{94d}न\u{947} वाण",
                "वाण",
                "शीर\u{94d}ष",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("TOP-pijl"),
            keywords: &["TOP-pijl", "bovenkant", "omhoog", "pijl"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("TOP-pil"),
            keywords: &["TOP", "TOP-pil", "opp", "pil opp", "topp", "topp med pil"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଶୀର\u{b4d}ଷ ତୀର"),
            keywords: &["ଉପର", "ତୀର", "ଶୀର\u{b4d}ଷ"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਉ\u{a71}ਪਰ ਵ\u{a71}ਲ ਇਸ\u{a3c}ਾਰਾ ਕਰਨ ਵਾਲਾ ਤੀਰ"),
            keywords: &[
                "ਉ\u{a71}ਤ\u{a47}",
                "ਉ\u{a71}ਤ\u{a47} ਤੀਰ",
                "ਉ\u{a71}ਤ\u{a47} ਤੀਰ ਨਾਲ ਉ\u{a71}ਪਰ",
                "ਉ\u{a71}ਪਰ",
                "ਉ\u{a71}ਪਰ ਦਾ ਨਿਸ\u{a3c}ਾਨ",
                "ਉ\u{a71}ਪਰ ਵ\u{a71}ਲ ਇਸ\u{a3c}ਾਰਾ ਕਰਨ ਵਾਲਾ ਤੀਰ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("اوتلا تیر"),
            keywords: &["اوتلا تیر", "ا\u{64f}وتے", "تیر", "چوٹی"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("TOP Áro"),
            keywords: &["TOP Áro", "Tọp", "Áro", "Ọp"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("strzałka z napisem TOP"),
            keywords: &["góra", "strzałka", "strzałka z napisem TOP"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("په سر غشی"),
            keywords: &["سر", "غشی", "په سر غشی", "پورته"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("seta \"TOP\""),
            keywords: &[
                "para cima",
                "seta",
                "seta \"TOP",
                "seta \"TOP\"",
                "seta para cima",
                "top",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("seta TOP"),
            keywords: &["parte superior", "seta", "seta TOP"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("HANAQ wachʼi"),
            keywords: &["HANAQ wachʼi"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("săgeată cu textul TOP"),
            keywords: &["sus", "săgeată", "săgeată cu textul TOP"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-729"),
            keywords: &["E10-729"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("стрелка «верх»"),
            keywords: &[
                "вверх",
                "верх",
                "наверх",
                "стрелка «верх»",
                "стрелка вверх",
                "топ",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("akambi ka TOP"),
            keywords: &["akambi ka TOP", "hejuru", "umwambi", "zamuka"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("مٿيون تير"),
            keywords: &["تير", "مٿي", "مٿيون تير"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ඉහළ ඊතලය"),
            keywords: &["ඉහළ", "ඊතලය", "ම\u{dd4}ද\u{dd4}න"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("šípka TOP"),
            keywords: &["nahor", "navrch", "šípka", "šípka TOP"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("puščica na vrh"),
            keywords: &["navzgor", "puščica", "puščica na vrh", "zgoraj"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("falaarta SARE"),
            keywords: &["falaarta SARE", "fallaar", "kor", "sare"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("shigjetë lart"),
            keywords: &["kreu", "lart", "shigjetë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("стрелица за врх"),
            keywords: &["врх", "гoрe", "стрeлицa", "стрелица за врх"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("strelica za vrh"),
            keywords: &["gore", "strelica", "strelica za vrh", "vrh"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("Top med uppåtpil"),
            keywords: &["Top med uppåtpil", "pil", "uppåtpil"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mshale unaoangalia juu"),
            keywords: &[
                "juu",
                "mshale",
                "mshale unaoangalia juu",
                "mshale unaoelekea juu",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("மேல\u{bcd}"),
            keywords: &["மேலே", "மேல\u{bcd}", "மேல\u{bcd} அம\u{bcd}புக\u{bcd}குறி"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ప\u{c48}క\u{c3f} బ\u{c3e}ణం"),
            keywords: &["ప\u{c48}క\u{c3f}", "బ\u{c3e}ణం"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("тири \"БОЛОЙ\""),
            keywords: &["боло", "тир", "тири \"БОЛОЙ\""],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ส\u{e31}ญล\u{e31}กษณ\u{e4c}บน"),
            keywords: &["ล\u{e39}กศร", "ส\u{e31}ญล\u{e31}กษณ\u{e4c}บน"],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ላዕለዋይ ምልክት"),
            keywords: &["ላዕለዋይ", "ምልክት", "ንላዕሊ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("TOP oky"),
            keywords: &["TOP oky", "ok", "üst", "ýokary"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("ngahau TUMUTUMU"),
            keywords: &["TUMUTUMU", "hake", "ngahau"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("yukarı oku"),
            keywords: &[
                "Yukarı",
                "yukarı",
                "yukarı ok",
                "yukarı okla Yukarı",
                "yukarı oku",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("چوققا كۆرسەتكۈچ"),
            keywords: &["ئۈستى", "كۆرسەتكۈچ", "يۇقىرى", "چوققا كۆرسەتكۈچ"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("стрілка [TOP]"),
            keywords: &["вверх", "вгору", "стрілка", "стрілка [TOP]"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("بالا تیر"),
            keywords: &["اوپر", "بالا تیر", "تیر"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("tepaga chizig‘i"),
            keywords: &["chiziq", "tepaga", "tepaga chizig‘i", "yuqoriga"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("mũi tên TOP"),
            keywords: &["lên", "mũi tên", "mũi tên TOP", "top"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("fettu COLLU"),
            keywords: &["cat", "fett", "fettu COLLU", "kaw"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("utolo oluthi PHEZULU"),
            keywords: &["phezulu", "utolo", "utolo oluthi PHEZULU"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ọfa LOKE"),
            keywords: &["orí òkè", "o\u{329}fà", "òkè", "Ọfa LOKE"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("「頂部」箭咀"),
            keywords: &["「頂部」箭咀", "向上", "箭咀", "頂部"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("“顶部”箭咀"),
            keywords: &["“顶部”箭咀", "向上", "箭咀", "顶部"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("置顶"),
            keywords: &["向上", "标识", "置顶"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("置頂"),
            keywords: &["置頂"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("top 標誌的箭嘴"),
            keywords: &["top 標誌的箭嘴", "向上"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("umcibisholo waphezulu"),
            keywords: &["phezulu", "umcibisholo", "umcibisholo waphezulu"],
        },
    ],
};
